/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl

trait UnmodifiableListIterableTestTrait extends UnmodifiableIterableTestTrait
{
    val classUnderTest: java.util.List[String]

    import org.junit.Test

    @Test(expected = classOf[UnsupportedOperationException])
    def listIterator_remove_throws
    {
        val iterator = classUnderTest.listIterator
        if (iterator.hasNext) iterator.next
        iterator.remove
    }

    @Test(expected = classOf[UnsupportedOperationException])
    def listIterator_add_throws
    {
        val iterator = classUnderTest.listIterator
        if (iterator.hasNext) iterator.next
        iterator.add("")
    }

    @Test(expected = classOf[UnsupportedOperationException])
    def listIterator_set_throws
    {
        val iterator = classUnderTest.listIterator
        if (iterator.hasNext) iterator.next
        iterator.set("")
    }
}
