char tcl_help[] = "\
#\n\
#    This file is part of tk707.\n\
#\n\
#    Copyright (C) 2000, 2001, 2002, 2003, 2004 Chris Willing and Pierre Saramito \n\
#\n\
#    tk707 is free software; you can redistribute it and/or modify\n\
#    it under the terms of the GNU General Public License as published by\n\
#    the Free Software Foundation; either version 2 of the License, or\n\
#    (at your option) any later version.\n\
#\n\
#    Foobar is distributed in the hope that it will be useful,\n\
#    but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
#    GNU General Public License for more details.\n\
#\n\
#    You should have received a copy of the GNU General Public License\n\
#    along with Foobar; if not, write to the Free Software\n\
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n\
#\n\
# =================================================================\n\
# The Help Module\n\
# =================================================================\n\
\n\
set HELP(UserGuide) $PKGDATADIR/tk707.help\n\
\n\
# ----------------------------------------------------------\n\
# formatText\n\
# ----------------------------------------------------------\n\
# This procedure tags the text in a text widget (if format is true),\n\
# based on the character in \"char\". \n\
# Text Marks \"first\" and \"last\" need to have been set prior to calling \n\
# the procedure. These mark the range of characters to be tagged.\n\
# The parameters are as follows:\n\
# w	: is the path of the text widget.\n\
# char  : is the character determining which tag is to be set.\n\
# 	  The current valid characters are:\n\
#		u  : underline\n\
#		i  : italic\n\
#		c  : command\n\
#		Cn : Content item, n is a positive integer. \n\
#		t  : title\n\
#		h  : highlight\n\
#		@  : keep the @ character.		\n\
# format : is a boolean value, which when true causes the text to be formatted.\n\
#  	   when false it removes all format information from the text\n\
#	   without tagging\n\
proc formatText { w char {format 1} } {\n\
   global HELP\n\
\n\
   # Format the text.\n\
   if {$format} {\n\
	switch $char {\n\
		u { 	$w delete last \"last + 1 chars\"\n\
			$w tag add underline \"last\" \"last wordend\"\n\
		  }\n\
		@ { 	$w insert first @ }\n\
		c { 	$w delete last \"last + 1 chars\"\n\
			$w tag add command \"last\" \"last wordend\"\n\
		  }\n\
		C {	\n\
			set tab \"\"\n\
			set tabs [$w get \"last + 1 chars\" \"last + 2 chars\"]\n\
			$w delete last \"last + 2 chars\"\n\
			while {$tabs} {\n\
			    set tab \"$tab      \" ;\n\
			    incr tabs -1\n\
			}\n\
			lappend HELP(Contents)\\\n\
			 [list \"$tab[$w get \"first\" \"first lineend\"]\" \\\n\
				[$w index first]]\n\
		  }\n\
		t { 	$w delete last \"last + 1 chars\"\n\
			$w tag add title \"last\" \"last lineend\"\n\
		  }\n\
		h {	$w delete last \"last + 1 chars\"\n\
			$w tag add highlight \"last\" \"last wordend\"\n\
		  }\n\
		i {	$w delete last \"last + 1 chars\"\n\
			$w tag add italic \"last\" \"last wordend\"\n\
		  }\n\
	default { }\n\
	}\n\
\n\
   # Remove all format data without formatting.\n\
   }  else {\n\
	set ok 0\n\
	foreach i {u c C t h i} {\n\
		if {$i==$char} { \n\
			$w delete last \"last + 1 chars\"\n\
			set ok 1 \n\
		}\n\
	}\n\
		if {!$ok} { $w insert last @ }\n\
  }\n\
}\n\
# ----------------------------------------------------------\n\
# Set Help globals.\n\
# ----------------------------------------------------------\n\
set HELP(BG) snow2\n\
set HELP(FG) black\n\
set HELP(AFG) grey\n\
set HELP(HIL) red\n\
set HELP(COM) DarkGreen\n\
set HELP(Log) \"0\"\n\
\n\
# ----------------------------------------------------------\n\
# about\n\
# ----------------------------------------------------------\n\
proc about {} {\n\
  global VERSION\n\
  if {[winfo exists .about]} {\n\
    wm deiconify .about\n\
  } else {\n\
    toplevel .about\n\
    wm title .about \"About tk707...\"\n\
    label    .about.label -text \"\n\
TK 707\\n\n\
version $VERSION\\n\n\
\n\
Copyright(C) 2000, 2001\\n\n\
Chris Willing <chris@vislab.usyd.edu.au>,\\n\n\
Pierre Saramito <pierre.saramito@imag.fr>.\\n\n\
\n\
Go to the Help menu for the complete documentation.\n\
This documentation is available in HTML and INFO formats.\n\
Type `man tk707` to access the on-line reference manual.\n\
\n\
The tk707 documentation is also available in html, pdf, postscript and\n\
dvi formats from\\n\n\
http://www-lmc.imag.fr/lmc-edp/Pierre.Saramito/tk707\n\
http://www.vislab.usyd.edu.au/staff/chris/tk707\n\
\n\
Send comments and requests, bugs, suggestions and mods \n\
to the both authors.\"\n\
\n\
    frame    .about.sep -width 100p -height 2p -borderwidth 1p -relief sunken\n\
    button   .about.dismiss -text \"Dissmiss\" -command {wm iconify .about}\n\
    pack     .about.label\n\
    pack     .about.dismiss -side bottom -pady 4p\n\
    pack     .about.sep     -side bottom -fill x -pady 4p\n\
  }\n\
}\n\
# ----------------------------------------------------------\n\
# UserManual\n\
# ----------------------------------------------------------\n\
# This procedure is the callback to to the Help-User's Manual menu item.\n\
# It creates a pop-up window containing the user's manual, with a few \n\
# basic highlighting and goto features.\n\
proc UserManual {} {\n\
   global HELP FILE\n\
\n\
   # Only procede if the help window is non-existant.	\n\
   if {![winfo exists .help]} {\n\
	set HELP(Contents) \"\"\n\
\n\
	# Create the toplevel window.\n\
	toplevel .help -bg $HELP(BG)\n\
	# Set the geometry\n\
	wm geometry .help 80x25\n\
	wm title .help \"Tk-707 User's Guide\"\n\
	# Set the Icon information.\n\
	wm iconname .help Help\n\
\n\
	# Create the buttons panel (Contents, Back, Exit)\n\
	frame .help.buttons -bg $HELP(BG) -relief ridge -bd 4\n\
	# Create the Contents button.\n\
	button .help.buttons.contents\\\n\
			-text Contents\\\n\
			-bg $HELP(AFG)\\\n\
			-fg $HELP(FG)\\\n\
			-activeforeground $HELP(FG)\\\n\
			-activebackground $HELP(AFG)\\\n\
			-width 10\\\n\
			-command {.help.help.text yview 0}\n\
	# Create the Back button.\n\
	button .help.buttons.prev\\\n\
			-text Back\\\n\
			-bg $HELP(AFG)\\\n\
			-fg $HELP(FG)\\\n\
			-width 10\\\n\
			-activebackground $HELP(AFG)\\\n\
			-command {\n\
 				set end [expr [llength $HELP(Log)]-1]\n\
				set value [lindex $HELP(Log) [expr $end-1]]\n\
				.help.help.text yview $value\n\
				set HELP(Log) [lreplace $HELP(Log) $end $end]\n\
			        }\n\
	# Create the Exit button.\n\
	button .help.buttons.exit\\\n\
			-text Exit\\\n\
			-bg $HELP(AFG)\\\n\
			-fg $HELP(FG)\\\n\
			-activeforeground $HELP(FG)\\\n\
			-activebackground $HELP(AFG)\\\n\
			-width 10\\\n\
			-command {destroy .help}\n\
\n\
        # Procedure to call when HELP(Log) is written\n\
        proc setlog {nm1 nm2 op} {\n\
	  global HELP\n\
	  if {$HELP(Log)==0} {\n\
	    .help.buttons.prev config -state disabled \n\
	  } else {\n\
	    .help.buttons.prev config -state normal\n\
	  }\n\
	}\n\
\n\
	# Set a variable trace on the Help(Log) variable to ensure that\n\
	# the Back button is disabled when the log is empty.\n\
        trace variable HELP(Log) w setlog\n\
\n\
	# Set the current state of the Back button.\n\
	set HELP(Log) $HELP(Log)\n\
\n\
	# Pack the buttons.\n\
	pack 	.help.buttons.contents \\\n\
		.help.buttons.prev\\\n\
		.help.buttons.exit\\\n\
		-side left -anchor w\n\
\n\
	pack .help.buttons  -anchor w -fill x\n\
\n\
	# Create and pack the text widget (with scrollbar)\n\
	setupText .help.help\n\
\n\
	# Load the User's Guide into widget and generate contents list.\n\
	loadFile .help.help.text $HELP(UserGuide)\n\
\n\
	# Insert the contents list.\n\
	set i 1\n\
	foreach item $HELP(Contents) {\n\
		.help.help.text insert $i.0 [format \"[lindex $item 0]\\n\"]\n\
		.help.help.text tag add content $i.0 \"$i.0 lineend\"\n\
		incr i\n\
	}\n\
	incr i 2\n\
	# Insert the \"Contents\" title.\n\
	.help.help.text insert 1.0 [format \"Contents\\n\\n\"]\n\
	# Give it the format of a title.\n\
	.help.help.text tag add title 1.0 \"1.0 lineend\"\n\
	# Store the number of lines added after Contents line.\n\
	set xtraLinesBefore 2\n\
	\n\
	# Add 3 blank lines after contents.\n\
	# This has to be stored for later\n\
	set xtraLinesAfter 3\n\
	.help.help.text insert $i.0 [format \"\\n\\n\\n\"]\n\
	# Strip the Format code from the Contents list\n\
	forAllMatches .help.help.text @ {\n\
		.help.help.text delete first last\n\
		set char [.help.help.text get last \"last+ 1 chars\"]\n\
		formatText .help.help.text $char 0\n\
	}\n\
	# Configure and Bind content list.\n\
	# A different cursor when above the item\n\
	.help.help.text tag bind content <Any-Enter> \\\n\
		\".help.help.text configure -cursor arrow\"\n\
	.help.help.text tag bind content <Any-Leave> \\\n\
		\".help.help.text configure -cursor {}\"\n\
	# Skip to the relevant line.\n\
	.help.help.text tag bind content <Button-1>\\\n\
	  \"set index \\[ expr \\[lindex \\[split \\[%W index @%x,%y\\] .\\] 0\\]\\\n\
			-(1 +$xtraLinesBefore)\\]\n\
	   set goto \\[expr \\[lindex \\[lindex \\$HELP(Contents) \\$index\\] 1\\] +2\\\n\
	   		+$xtraLinesAfter +\\[llength \\$HELP(Contents)\\]\\]\n\
\n\
 	   # Store in the log.\n\
	   lappend HELP(Log) \\$goto\n\
\n\
	   # Adjust the view to the selected line.\n\
	   %W yview \\$goto\"\n\
   } else {\n\
	# Bring  the user manual to the front.\n\
	# I am not using raise since it doesn't generally work for olwm.\n\
	wm withdraw .help\n\
	wm deiconify .help\n\
   }\n\
}\n\
\n\
# ----------------------------------------------------------\n\
# setupText\n\
# ----------------------------------------------------------\n\
# This procedure creates a text widget and scroll bar.\n\
# The parameter \"w\" is a path for the combined widget.\n\
proc setupText {w} {\n\
   global HELP\n\
\n\
   #Create Widgets if the path name is valid.\n\
   if {![winfo exists $w]} {\n\
	# Create the general frame.\n\
	frame $w\n\
\n\
	# Create the text widget.\n\
	# The configuration option \"setgrid\" sets up gridded \n\
	# window management.\n\
	text $w.text 	-yscrollcommand \"$w.scroll set\"\\\n\
			-setgrid 1 \\\n\
			-wrap word\n\
	# Create the scrollbar.\n\
	scrollbar $w.scroll -command \"$w.text yview\"\n\
\n\
	# Pack the widget.\n\
	pack $w.text  -fill both -expand 1 -side left\n\
	pack $w.scroll -side left -fill y -expand 1\n\
	pack $w -fill both -expand 1\n\
   }\n\
\n\
   # Configure the Widgets.\n\
   $w config -bg $HELP(BG)\n\
   $w.text config\\\n\
		-background $HELP(BG)\\\n\
		-foreground $HELP(FG)\\\n\
		-cursor {}\\\n\
		-font -adobe-helvetica-medium-r-normal--12-120-*\\\n\
		-exportselection 0\n\
\n\
   $w.scroll config -background $HELP(BG)\n\
\n\
   # Remove the default bindings that make the text widget editable.\n\
   bind $w.text <Any-KeyPress> { }\n\
   bind $w.text <Any-Button> { }\n\
   bind $w.text <Any-B1-Motion> { }\n\
\n\
   # Set the configuration for text tags.\n\
   # Underline.\n\
   $w.text tag configure underline -underline 1\n\
   # Command\n\
   $w.text tag configure command \\\n\
		-foreground DarkGreen\\\n\
		-font -adobe-helvetica-medium-r-normal--14-140-*\n\
   $w.text tag bind command <Button-1> { \n\
		puts [%W get \"@%x,%y wordstart\" \"@%x,%y wordend\"] }\n\
   $w.text tag bind command <Any-Enter> \"$w.text configure -cursor arrow\"\n\
   $w.text tag bind command <Any-Leave> \"$w.text configure -cursor {}\"\n\
   # Content\n\
   $w.text tag configure content \\\n\
		-foreground DarkGreen \\\n\
		-font -adobe-helvetica-medium-r-normal--14-140-*\n\
   # Title.\n\
   $w.text tag configure title -font -adobe-helvetica-medium-r-normal--24-240-*\n\
   # Italic\n\
   $w.text tag configure italic -font -adobe-helvetica-medium-o-normal--12-120-*\n\
   # Highlight.\n\
   $w.text tag configure highlight -foreground red\n\
}\n\
\n\
\n\
# ----------------------------------------------------------\n\
# loadFile\n\
# ----------------------------------------------------------\n\
# This procedure load a text file given by \"file\" formatted with a \n\
# simple form of hyper-text into the text widget given by \"w\". And\n\
# format it.\n\
proc loadFile {w file} {\n\
   # Delete all previous text in the text widget.\n\
   $w delete 1.0 end\n\
\n\
   # Open the text file.\n\
   set f [open $file]\n\
\n\
   # Insert the text into the text widget.\n\
   while {![eof $f]} {\n\
	$w insert end [read $f 1000]\n\
   }\n\
	\n\
   # Close the text file.\n\
   close $f\n\
\n\
   # Format the text. This is done by looking for all the \"@\" in the\n\
   # text widget, deleting it and sending the following character to\n\
   # the procedure formaText, which tags the text appropriately.\n\
	forAllMatches $w @ {\n\
		$w delete first last\n\
		set char [$w get last \"last+ 1 chars\"]\n\
		formatText $w $char\n\
	}\n\
}\n\
\n\
# ----------------------------------------------------------\n\
# forAllMatches\n\
# ----------------------------------------------------------\n\
# This procedure takes three arguments: the name of a text widget, \n\
# a regular expression pattern and a script. \n\
# It finds all of the ranges of characters that match the pattern. \n\
# For each matching range forAllMatches sets the marks first and last \n\
# to the beginning and end of the of the range, then it invokes the \n\
# script.\n\
# This procedure has been taken from John K. Ousterhout's book,\n\
# Tcl and the Tk Toolkit (1994) p.219. \n\
proc forAllMatches {w pattern script} {\n\
	scan [$w index end] %d numLines\n\
	for {set i 1} {$i<=$numLines} {incr i } {\n\
	   $w mark set last $i.0\n\
	   while {[regexp -indices $pattern \\\n\
		  [$w get last \"last lineend\" ] indices ] } {\n\
		$w mark set first \"last + [lindex $indices 0] chars\"\n\
		$w mark set last \"last + 1 chars +[lindex $indices 1] chars\"\n\
		uplevel $script\n\
	   }\n\
	}\n\
}\n\
";
