; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -hardware-loops -force-hardware-loops=true -hardware-loop-decrement=1 -hardware-loop-counter-bitwidth=32 -S %s -o - | FileCheck %s --check-prefix=CHECK-DEC
; RUN: opt -hardware-loops -force-hardware-loops=true -hardware-loop-decrement=1 -hardware-loop-counter-bitwidth=32 -force-hardware-loop-phi=true -S %s -o - | FileCheck %s --check-prefix=CHECK-PHI
; RUN: opt -hardware-loops -force-hardware-loops=true -hardware-loop-decrement=1 -hardware-loop-counter-bitwidth=32 -force-nested-hardware-loop=true -S %s -o - | FileCheck %s --check-prefix=CHECK-NESTED
; RUN: opt -hardware-loops -force-hardware-loops=true -hardware-loop-decrement=1 -hardware-loop-counter-bitwidth=32 -force-hardware-loop-guard=true -S %s -o - | FileCheck %s --check-prefix=CHECK-GUARD
; RUN: opt -hardware-loops -force-hardware-loops=true -hardware-loop-decrement=1 -hardware-loop-counter-bitwidth=32 -force-hardware-loop-phi=true -force-hardware-loop-guard=true -S %s -o - | FileCheck %s --check-prefix=CHECK-PHIGUARD

define void @while_lt(i32 %i, i32 %N, i32* nocapture %A) {
; CHECK-DEC-LABEL: @while_lt(
; CHECK-DEC-NEXT:  entry:
; CHECK-DEC-NEXT:    [[CMP4:%.*]] = icmp ult i32 [[I:%.*]], [[N:%.*]]
; CHECK-DEC-NEXT:    br i1 [[CMP4]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-DEC:       while.body.preheader:
; CHECK-DEC-NEXT:    [[TMP0:%.*]] = sub i32 [[N]], [[I]]
; CHECK-DEC-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[TMP0]])
; CHECK-DEC-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-DEC:       while.body:
; CHECK-DEC-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-DEC-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-DEC-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-DEC-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-DEC-NEXT:    [[TMP1:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-DEC-NEXT:    br i1 [[TMP1]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-DEC:       while.end:
; CHECK-DEC-NEXT:    ret void
;
; CHECK-PHI-LABEL: @while_lt(
; CHECK-PHI-NEXT:  entry:
; CHECK-PHI-NEXT:    [[CMP4:%.*]] = icmp ult i32 [[I:%.*]], [[N:%.*]]
; CHECK-PHI-NEXT:    br i1 [[CMP4]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-PHI:       while.body.preheader:
; CHECK-PHI-NEXT:    [[TMP0:%.*]] = sub i32 [[N]], [[I]]
; CHECK-PHI-NEXT:    [[TMP1:%.*]] = call i32 @llvm.start.loop.iterations.i32(i32 [[TMP0]])
; CHECK-PHI-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-PHI:       while.body:
; CHECK-PHI-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-PHI-NEXT:    [[TMP2:%.*]] = phi i32 [ [[TMP1]], [[WHILE_BODY_PREHEADER]] ], [ [[TMP3:%.*]], [[WHILE_BODY]] ]
; CHECK-PHI-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-PHI-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-PHI-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-PHI-NEXT:    [[TMP3]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP2]], i32 1)
; CHECK-PHI-NEXT:    [[TMP4:%.*]] = icmp ne i32 [[TMP3]], 0
; CHECK-PHI-NEXT:    br i1 [[TMP4]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-PHI:       while.end:
; CHECK-PHI-NEXT:    ret void
;
; CHECK-NESTED-LABEL: @while_lt(
; CHECK-NESTED-NEXT:  entry:
; CHECK-NESTED-NEXT:    [[CMP4:%.*]] = icmp ult i32 [[I:%.*]], [[N:%.*]]
; CHECK-NESTED-NEXT:    br i1 [[CMP4]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-NESTED:       while.body.preheader:
; CHECK-NESTED-NEXT:    [[TMP0:%.*]] = sub i32 [[N]], [[I]]
; CHECK-NESTED-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[TMP0]])
; CHECK-NESTED-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-NESTED:       while.body:
; CHECK-NESTED-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-NESTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-NESTED-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-NESTED-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-NESTED-NEXT:    [[TMP1:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-NESTED-NEXT:    br i1 [[TMP1]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-NESTED:       while.end:
; CHECK-NESTED-NEXT:    ret void
;
; CHECK-GUARD-LABEL: @while_lt(
; CHECK-GUARD-NEXT:  entry:
; CHECK-GUARD-NEXT:    [[CMP4:%.*]] = icmp ult i32 [[I:%.*]], [[N:%.*]]
; CHECK-GUARD-NEXT:    [[TMP0:%.*]] = sub i32 [[N]], [[I]]
; CHECK-GUARD-NEXT:    br i1 [[CMP4]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-GUARD:       while.body.preheader:
; CHECK-GUARD-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[TMP0]])
; CHECK-GUARD-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-GUARD:       while.body:
; CHECK-GUARD-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-GUARD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-GUARD-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-GUARD-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-GUARD-NEXT:    [[TMP1:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-GUARD-NEXT:    br i1 [[TMP1]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-GUARD:       while.end:
; CHECK-GUARD-NEXT:    ret void
;
; CHECK-PHIGUARD-LABEL: @while_lt(
; CHECK-PHIGUARD-NEXT:  entry:
; CHECK-PHIGUARD-NEXT:    [[CMP4:%.*]] = icmp ult i32 [[I:%.*]], [[N:%.*]]
; CHECK-PHIGUARD-NEXT:    [[TMP0:%.*]] = sub i32 [[N]], [[I]]
; CHECK-PHIGUARD-NEXT:    br i1 [[CMP4]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-PHIGUARD:       while.body.preheader:
; CHECK-PHIGUARD-NEXT:    [[TMP1:%.*]] = call i32 @llvm.start.loop.iterations.i32(i32 [[TMP0]])
; CHECK-PHIGUARD-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-PHIGUARD:       while.body:
; CHECK-PHIGUARD-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-PHIGUARD-NEXT:    [[TMP2:%.*]] = phi i32 [ [[TMP1]], [[WHILE_BODY_PREHEADER]] ], [ [[TMP3:%.*]], [[WHILE_BODY]] ]
; CHECK-PHIGUARD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-PHIGUARD-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-PHIGUARD-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-PHIGUARD-NEXT:    [[TMP3]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP2]], i32 1)
; CHECK-PHIGUARD-NEXT:    [[TMP4:%.*]] = icmp ne i32 [[TMP3]], 0
; CHECK-PHIGUARD-NEXT:    br i1 [[TMP4]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-PHIGUARD:       while.end:
; CHECK-PHIGUARD-NEXT:    ret void
;
entry:
  %cmp4 = icmp ult i32 %i, %N
  br i1 %cmp4, label %while.body, label %while.end

while.body:
  %i.addr.05 = phi i32 [ %inc, %while.body ], [ %i, %entry ]
  %arrayidx = getelementptr inbounds i32, i32* %A, i32 %i.addr.05
  store i32 %i.addr.05, i32* %arrayidx, align 4
  %inc = add nuw i32 %i.addr.05, 1
  %exitcond = icmp eq i32 %inc, %N
  br i1 %exitcond, label %while.end, label %while.body

while.end:
  ret void
}

define void @while_gt(i32 %i, i32 %N, i32* nocapture %A) {
; CHECK-DEC-LABEL: @while_gt(
; CHECK-DEC-NEXT:  entry:
; CHECK-DEC-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[I:%.*]], [[N:%.*]]
; CHECK-DEC-NEXT:    br i1 [[CMP4]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-DEC:       while.body.preheader:
; CHECK-DEC-NEXT:    [[TMP0:%.*]] = sub i32 [[I]], [[N]]
; CHECK-DEC-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[TMP0]])
; CHECK-DEC-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-DEC:       while.body:
; CHECK-DEC-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[DEC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-DEC-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-DEC-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-DEC-NEXT:    [[DEC]] = add nsw i32 [[I_ADDR_05]], -1
; CHECK-DEC-NEXT:    [[TMP1:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-DEC-NEXT:    br i1 [[TMP1]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-DEC:       while.end:
; CHECK-DEC-NEXT:    ret void
;
; CHECK-PHI-LABEL: @while_gt(
; CHECK-PHI-NEXT:  entry:
; CHECK-PHI-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[I:%.*]], [[N:%.*]]
; CHECK-PHI-NEXT:    br i1 [[CMP4]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-PHI:       while.body.preheader:
; CHECK-PHI-NEXT:    [[TMP0:%.*]] = sub i32 [[I]], [[N]]
; CHECK-PHI-NEXT:    [[TMP1:%.*]] = call i32 @llvm.start.loop.iterations.i32(i32 [[TMP0]])
; CHECK-PHI-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-PHI:       while.body:
; CHECK-PHI-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[DEC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-PHI-NEXT:    [[TMP2:%.*]] = phi i32 [ [[TMP1]], [[WHILE_BODY_PREHEADER]] ], [ [[TMP3:%.*]], [[WHILE_BODY]] ]
; CHECK-PHI-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-PHI-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-PHI-NEXT:    [[DEC]] = add nsw i32 [[I_ADDR_05]], -1
; CHECK-PHI-NEXT:    [[TMP3]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP2]], i32 1)
; CHECK-PHI-NEXT:    [[TMP4:%.*]] = icmp ne i32 [[TMP3]], 0
; CHECK-PHI-NEXT:    br i1 [[TMP4]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-PHI:       while.end:
; CHECK-PHI-NEXT:    ret void
;
; CHECK-NESTED-LABEL: @while_gt(
; CHECK-NESTED-NEXT:  entry:
; CHECK-NESTED-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[I:%.*]], [[N:%.*]]
; CHECK-NESTED-NEXT:    br i1 [[CMP4]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-NESTED:       while.body.preheader:
; CHECK-NESTED-NEXT:    [[TMP0:%.*]] = sub i32 [[I]], [[N]]
; CHECK-NESTED-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[TMP0]])
; CHECK-NESTED-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-NESTED:       while.body:
; CHECK-NESTED-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[DEC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-NESTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-NESTED-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-NESTED-NEXT:    [[DEC]] = add nsw i32 [[I_ADDR_05]], -1
; CHECK-NESTED-NEXT:    [[TMP1:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-NESTED-NEXT:    br i1 [[TMP1]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-NESTED:       while.end:
; CHECK-NESTED-NEXT:    ret void
;
; CHECK-GUARD-LABEL: @while_gt(
; CHECK-GUARD-NEXT:  entry:
; CHECK-GUARD-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[I:%.*]], [[N:%.*]]
; CHECK-GUARD-NEXT:    [[TMP0:%.*]] = sub i32 [[I]], [[N]]
; CHECK-GUARD-NEXT:    br i1 [[CMP4]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-GUARD:       while.body.preheader:
; CHECK-GUARD-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[TMP0]])
; CHECK-GUARD-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-GUARD:       while.body:
; CHECK-GUARD-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[DEC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-GUARD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-GUARD-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-GUARD-NEXT:    [[DEC]] = add nsw i32 [[I_ADDR_05]], -1
; CHECK-GUARD-NEXT:    [[TMP1:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-GUARD-NEXT:    br i1 [[TMP1]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-GUARD:       while.end:
; CHECK-GUARD-NEXT:    ret void
;
; CHECK-PHIGUARD-LABEL: @while_gt(
; CHECK-PHIGUARD-NEXT:  entry:
; CHECK-PHIGUARD-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[I:%.*]], [[N:%.*]]
; CHECK-PHIGUARD-NEXT:    [[TMP0:%.*]] = sub i32 [[I]], [[N]]
; CHECK-PHIGUARD-NEXT:    br i1 [[CMP4]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-PHIGUARD:       while.body.preheader:
; CHECK-PHIGUARD-NEXT:    [[TMP1:%.*]] = call i32 @llvm.start.loop.iterations.i32(i32 [[TMP0]])
; CHECK-PHIGUARD-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-PHIGUARD:       while.body:
; CHECK-PHIGUARD-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[DEC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-PHIGUARD-NEXT:    [[TMP2:%.*]] = phi i32 [ [[TMP1]], [[WHILE_BODY_PREHEADER]] ], [ [[TMP3:%.*]], [[WHILE_BODY]] ]
; CHECK-PHIGUARD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-PHIGUARD-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-PHIGUARD-NEXT:    [[DEC]] = add nsw i32 [[I_ADDR_05]], -1
; CHECK-PHIGUARD-NEXT:    [[TMP3]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP2]], i32 1)
; CHECK-PHIGUARD-NEXT:    [[TMP4:%.*]] = icmp ne i32 [[TMP3]], 0
; CHECK-PHIGUARD-NEXT:    br i1 [[TMP4]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-PHIGUARD:       while.end:
; CHECK-PHIGUARD-NEXT:    ret void
;
entry:
  %cmp4 = icmp sgt i32 %i, %N
  br i1 %cmp4, label %while.body, label %while.end

while.body:
  %i.addr.05 = phi i32 [ %dec, %while.body ], [ %i, %entry ]
  %arrayidx = getelementptr inbounds i32, i32* %A, i32 %i.addr.05
  store i32 %i.addr.05, i32* %arrayidx, align 4
  %dec = add nsw i32 %i.addr.05, -1
  %cmp = icmp sgt i32 %dec, %N
  br i1 %cmp, label %while.body, label %while.end

while.end:
  ret void
}

define void @while_gte(i32 %i, i32 %N, i32* nocapture %A) {
; CHECK-DEC-LABEL: @while_gte(
; CHECK-DEC-NEXT:  entry:
; CHECK-DEC-NEXT:    [[CMP4:%.*]] = icmp slt i32 [[I:%.*]], [[N:%.*]]
; CHECK-DEC-NEXT:    br i1 [[CMP4]], label [[WHILE_END:%.*]], label [[WHILE_BODY_PREHEADER:%.*]]
; CHECK-DEC:       while.body.preheader:
; CHECK-DEC-NEXT:    [[TMP0:%.*]] = add i32 [[I]], 1
; CHECK-DEC-NEXT:    [[TMP1:%.*]] = sub i32 [[TMP0]], [[N]]
; CHECK-DEC-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[TMP1]])
; CHECK-DEC-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-DEC:       while.body:
; CHECK-DEC-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[DEC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-DEC-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-DEC-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-DEC-NEXT:    [[DEC]] = add nsw i32 [[I_ADDR_05]], -1
; CHECK-DEC-NEXT:    [[TMP2:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-DEC-NEXT:    br i1 [[TMP2]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-DEC:       while.end:
; CHECK-DEC-NEXT:    ret void
;
; CHECK-PHI-LABEL: @while_gte(
; CHECK-PHI-NEXT:  entry:
; CHECK-PHI-NEXT:    [[CMP4:%.*]] = icmp slt i32 [[I:%.*]], [[N:%.*]]
; CHECK-PHI-NEXT:    br i1 [[CMP4]], label [[WHILE_END:%.*]], label [[WHILE_BODY_PREHEADER:%.*]]
; CHECK-PHI:       while.body.preheader:
; CHECK-PHI-NEXT:    [[TMP0:%.*]] = add i32 [[I]], 1
; CHECK-PHI-NEXT:    [[TMP1:%.*]] = sub i32 [[TMP0]], [[N]]
; CHECK-PHI-NEXT:    [[TMP2:%.*]] = call i32 @llvm.start.loop.iterations.i32(i32 [[TMP1]])
; CHECK-PHI-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-PHI:       while.body:
; CHECK-PHI-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[DEC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-PHI-NEXT:    [[TMP3:%.*]] = phi i32 [ [[TMP2]], [[WHILE_BODY_PREHEADER]] ], [ [[TMP4:%.*]], [[WHILE_BODY]] ]
; CHECK-PHI-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-PHI-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-PHI-NEXT:    [[DEC]] = add nsw i32 [[I_ADDR_05]], -1
; CHECK-PHI-NEXT:    [[TMP4]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP3]], i32 1)
; CHECK-PHI-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
; CHECK-PHI-NEXT:    br i1 [[TMP5]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-PHI:       while.end:
; CHECK-PHI-NEXT:    ret void
;
; CHECK-NESTED-LABEL: @while_gte(
; CHECK-NESTED-NEXT:  entry:
; CHECK-NESTED-NEXT:    [[CMP4:%.*]] = icmp slt i32 [[I:%.*]], [[N:%.*]]
; CHECK-NESTED-NEXT:    br i1 [[CMP4]], label [[WHILE_END:%.*]], label [[WHILE_BODY_PREHEADER:%.*]]
; CHECK-NESTED:       while.body.preheader:
; CHECK-NESTED-NEXT:    [[TMP0:%.*]] = add i32 [[I]], 1
; CHECK-NESTED-NEXT:    [[TMP1:%.*]] = sub i32 [[TMP0]], [[N]]
; CHECK-NESTED-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[TMP1]])
; CHECK-NESTED-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-NESTED:       while.body:
; CHECK-NESTED-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[DEC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-NESTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-NESTED-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-NESTED-NEXT:    [[DEC]] = add nsw i32 [[I_ADDR_05]], -1
; CHECK-NESTED-NEXT:    [[TMP2:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-NESTED-NEXT:    br i1 [[TMP2]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-NESTED:       while.end:
; CHECK-NESTED-NEXT:    ret void
;
; CHECK-GUARD-LABEL: @while_gte(
; CHECK-GUARD-NEXT:  entry:
; CHECK-GUARD-NEXT:    [[CMP4:%.*]] = icmp slt i32 [[I:%.*]], [[N:%.*]]
; CHECK-GUARD-NEXT:    br i1 [[CMP4]], label [[WHILE_END:%.*]], label [[WHILE_BODY_PREHEADER:%.*]]
; CHECK-GUARD:       while.body.preheader:
; CHECK-GUARD-NEXT:    [[TMP0:%.*]] = add i32 [[I]], 1
; CHECK-GUARD-NEXT:    [[TMP1:%.*]] = sub i32 [[TMP0]], [[N]]
; CHECK-GUARD-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[TMP1]])
; CHECK-GUARD-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-GUARD:       while.body:
; CHECK-GUARD-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[DEC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-GUARD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-GUARD-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-GUARD-NEXT:    [[DEC]] = add nsw i32 [[I_ADDR_05]], -1
; CHECK-GUARD-NEXT:    [[TMP2:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-GUARD-NEXT:    br i1 [[TMP2]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-GUARD:       while.end:
; CHECK-GUARD-NEXT:    ret void
;
; CHECK-PHIGUARD-LABEL: @while_gte(
; CHECK-PHIGUARD-NEXT:  entry:
; CHECK-PHIGUARD-NEXT:    [[CMP4:%.*]] = icmp slt i32 [[I:%.*]], [[N:%.*]]
; CHECK-PHIGUARD-NEXT:    br i1 [[CMP4]], label [[WHILE_END:%.*]], label [[WHILE_BODY_PREHEADER:%.*]]
; CHECK-PHIGUARD:       while.body.preheader:
; CHECK-PHIGUARD-NEXT:    [[TMP0:%.*]] = add i32 [[I]], 1
; CHECK-PHIGUARD-NEXT:    [[TMP1:%.*]] = sub i32 [[TMP0]], [[N]]
; CHECK-PHIGUARD-NEXT:    [[TMP2:%.*]] = call i32 @llvm.start.loop.iterations.i32(i32 [[TMP1]])
; CHECK-PHIGUARD-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-PHIGUARD:       while.body:
; CHECK-PHIGUARD-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[DEC:%.*]], [[WHILE_BODY]] ], [ [[I]], [[WHILE_BODY_PREHEADER]] ]
; CHECK-PHIGUARD-NEXT:    [[TMP3:%.*]] = phi i32 [ [[TMP2]], [[WHILE_BODY_PREHEADER]] ], [ [[TMP4:%.*]], [[WHILE_BODY]] ]
; CHECK-PHIGUARD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-PHIGUARD-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-PHIGUARD-NEXT:    [[DEC]] = add nsw i32 [[I_ADDR_05]], -1
; CHECK-PHIGUARD-NEXT:    [[TMP4]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP3]], i32 1)
; CHECK-PHIGUARD-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
; CHECK-PHIGUARD-NEXT:    br i1 [[TMP5]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-PHIGUARD:       while.end:
; CHECK-PHIGUARD-NEXT:    ret void
;
entry:
  %cmp4 = icmp slt i32 %i, %N
  br i1 %cmp4, label %while.end, label %while.body

while.body:
  %i.addr.05 = phi i32 [ %dec, %while.body ], [ %i, %entry ]
  %arrayidx = getelementptr inbounds i32, i32* %A, i32 %i.addr.05
  store i32 %i.addr.05, i32* %arrayidx, align 4
  %dec = add nsw i32 %i.addr.05, -1
  %cmp = icmp sgt i32 %i.addr.05, %N
  br i1 %cmp, label %while.body, label %while.end

while.end:
  ret void
}

define void @while_ne(i32 %N, i32* nocapture %A) {
; CHECK-DEC-LABEL: @while_ne(
; CHECK-DEC-NEXT:  entry:
; CHECK-DEC-NEXT:    [[CMP:%.*]] = icmp ne i32 [[N:%.*]], 0
; CHECK-DEC-NEXT:    br i1 [[CMP]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-DEC:       while.body.preheader:
; CHECK-DEC-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[N]])
; CHECK-DEC-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-DEC:       while.body:
; CHECK-DEC-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-DEC-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-DEC-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-DEC-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-DEC-NEXT:    [[TMP0:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-DEC-NEXT:    br i1 [[TMP0]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-DEC:       while.end:
; CHECK-DEC-NEXT:    ret void
;
; CHECK-PHI-LABEL: @while_ne(
; CHECK-PHI-NEXT:  entry:
; CHECK-PHI-NEXT:    [[CMP:%.*]] = icmp ne i32 [[N:%.*]], 0
; CHECK-PHI-NEXT:    br i1 [[CMP]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-PHI:       while.body.preheader:
; CHECK-PHI-NEXT:    [[TMP0:%.*]] = call i32 @llvm.start.loop.iterations.i32(i32 [[N]])
; CHECK-PHI-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-PHI:       while.body:
; CHECK-PHI-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-PHI-NEXT:    [[TMP1:%.*]] = phi i32 [ [[TMP0]], [[WHILE_BODY_PREHEADER]] ], [ [[TMP2:%.*]], [[WHILE_BODY]] ]
; CHECK-PHI-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-PHI-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-PHI-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-PHI-NEXT:    [[TMP2]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP1]], i32 1)
; CHECK-PHI-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
; CHECK-PHI-NEXT:    br i1 [[TMP3]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-PHI:       while.end:
; CHECK-PHI-NEXT:    ret void
;
; CHECK-NESTED-LABEL: @while_ne(
; CHECK-NESTED-NEXT:  entry:
; CHECK-NESTED-NEXT:    [[CMP:%.*]] = icmp ne i32 [[N:%.*]], 0
; CHECK-NESTED-NEXT:    br i1 [[CMP]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-NESTED:       while.body.preheader:
; CHECK-NESTED-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[N]])
; CHECK-NESTED-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-NESTED:       while.body:
; CHECK-NESTED-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-NESTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-NESTED-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-NESTED-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-NESTED-NEXT:    [[TMP0:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-NESTED-NEXT:    br i1 [[TMP0]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-NESTED:       while.end:
; CHECK-NESTED-NEXT:    ret void
;
; CHECK-GUARD-LABEL: @while_ne(
; CHECK-GUARD-NEXT:  entry:
; CHECK-GUARD-NEXT:    [[CMP:%.*]] = icmp ne i32 [[N:%.*]], 0
; CHECK-GUARD-NEXT:    [[TMP0:%.*]] = call i1 @llvm.test.set.loop.iterations.i32(i32 [[N]])
; CHECK-GUARD-NEXT:    br i1 [[TMP0]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-GUARD:       while.body.preheader:
; CHECK-GUARD-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-GUARD:       while.body:
; CHECK-GUARD-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-GUARD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-GUARD-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-GUARD-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-GUARD-NEXT:    [[TMP1:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-GUARD-NEXT:    br i1 [[TMP1]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-GUARD:       while.end:
; CHECK-GUARD-NEXT:    ret void
;
; CHECK-PHIGUARD-LABEL: @while_ne(
; CHECK-PHIGUARD-NEXT:  entry:
; CHECK-PHIGUARD-NEXT:    [[CMP:%.*]] = icmp ne i32 [[N:%.*]], 0
; CHECK-PHIGUARD-NEXT:    [[TMP0:%.*]] = call { i32, i1 } @llvm.test.start.loop.iterations.i32(i32 [[N]])
; CHECK-PHIGUARD-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1
; CHECK-PHIGUARD-NEXT:    [[TMP2:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0
; CHECK-PHIGUARD-NEXT:    br i1 [[TMP1]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-PHIGUARD:       while.body.preheader:
; CHECK-PHIGUARD-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-PHIGUARD:       while.body:
; CHECK-PHIGUARD-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-PHIGUARD-NEXT:    [[TMP3:%.*]] = phi i32 [ [[TMP2]], [[WHILE_BODY_PREHEADER]] ], [ [[TMP4:%.*]], [[WHILE_BODY]] ]
; CHECK-PHIGUARD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-PHIGUARD-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-PHIGUARD-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-PHIGUARD-NEXT:    [[TMP4]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP3]], i32 1)
; CHECK-PHIGUARD-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
; CHECK-PHIGUARD-NEXT:    br i1 [[TMP5]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-PHIGUARD:       while.end:
; CHECK-PHIGUARD-NEXT:    ret void
;
entry:
  %cmp = icmp ne i32 %N, 0
  br i1 %cmp, label %while.body, label %while.end

while.body:
  %i.addr.05 = phi i32 [ %inc, %while.body ], [ 0, %entry ]
  %arrayidx = getelementptr inbounds i32, i32* %A, i32 %i.addr.05
  store i32 %i.addr.05, i32* %arrayidx, align 4
  %inc = add nuw i32 %i.addr.05, 1
  %exitcond = icmp eq i32 %inc, %N
  br i1 %exitcond, label %while.end, label %while.body

while.end:
  ret void
}

define void @while_eq(i32 %N, i32* nocapture %A) {
; CHECK-DEC-LABEL: @while_eq(
; CHECK-DEC-NEXT:  entry:
; CHECK-DEC-NEXT:    [[CMP:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-DEC-NEXT:    br i1 [[CMP]], label [[WHILE_END:%.*]], label [[WHILE_BODY_PREHEADER:%.*]]
; CHECK-DEC:       while.body.preheader:
; CHECK-DEC-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[N]])
; CHECK-DEC-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-DEC:       while.body:
; CHECK-DEC-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-DEC-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-DEC-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-DEC-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-DEC-NEXT:    [[TMP0:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-DEC-NEXT:    br i1 [[TMP0]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-DEC:       while.end:
; CHECK-DEC-NEXT:    ret void
;
; CHECK-PHI-LABEL: @while_eq(
; CHECK-PHI-NEXT:  entry:
; CHECK-PHI-NEXT:    [[CMP:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-PHI-NEXT:    br i1 [[CMP]], label [[WHILE_END:%.*]], label [[WHILE_BODY_PREHEADER:%.*]]
; CHECK-PHI:       while.body.preheader:
; CHECK-PHI-NEXT:    [[TMP0:%.*]] = call i32 @llvm.start.loop.iterations.i32(i32 [[N]])
; CHECK-PHI-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-PHI:       while.body:
; CHECK-PHI-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-PHI-NEXT:    [[TMP1:%.*]] = phi i32 [ [[TMP0]], [[WHILE_BODY_PREHEADER]] ], [ [[TMP2:%.*]], [[WHILE_BODY]] ]
; CHECK-PHI-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-PHI-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-PHI-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-PHI-NEXT:    [[TMP2]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP1]], i32 1)
; CHECK-PHI-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
; CHECK-PHI-NEXT:    br i1 [[TMP3]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-PHI:       while.end:
; CHECK-PHI-NEXT:    ret void
;
; CHECK-NESTED-LABEL: @while_eq(
; CHECK-NESTED-NEXT:  entry:
; CHECK-NESTED-NEXT:    [[CMP:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-NESTED-NEXT:    br i1 [[CMP]], label [[WHILE_END:%.*]], label [[WHILE_BODY_PREHEADER:%.*]]
; CHECK-NESTED:       while.body.preheader:
; CHECK-NESTED-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[N]])
; CHECK-NESTED-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-NESTED:       while.body:
; CHECK-NESTED-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-NESTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-NESTED-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-NESTED-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-NESTED-NEXT:    [[TMP0:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-NESTED-NEXT:    br i1 [[TMP0]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-NESTED:       while.end:
; CHECK-NESTED-NEXT:    ret void
;
; CHECK-GUARD-LABEL: @while_eq(
; CHECK-GUARD-NEXT:  entry:
; CHECK-GUARD-NEXT:    [[CMP:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-GUARD-NEXT:    [[TMP0:%.*]] = call i1 @llvm.test.set.loop.iterations.i32(i32 [[N]])
; CHECK-GUARD-NEXT:    br i1 [[TMP0]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-GUARD:       while.body.preheader:
; CHECK-GUARD-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-GUARD:       while.body:
; CHECK-GUARD-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-GUARD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-GUARD-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-GUARD-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-GUARD-NEXT:    [[TMP1:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-GUARD-NEXT:    br i1 [[TMP1]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-GUARD:       while.end:
; CHECK-GUARD-NEXT:    ret void
;
; CHECK-PHIGUARD-LABEL: @while_eq(
; CHECK-PHIGUARD-NEXT:  entry:
; CHECK-PHIGUARD-NEXT:    [[CMP:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-PHIGUARD-NEXT:    [[TMP0:%.*]] = call { i32, i1 } @llvm.test.start.loop.iterations.i32(i32 [[N]])
; CHECK-PHIGUARD-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1
; CHECK-PHIGUARD-NEXT:    [[TMP2:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0
; CHECK-PHIGUARD-NEXT:    br i1 [[TMP1]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-PHIGUARD:       while.body.preheader:
; CHECK-PHIGUARD-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-PHIGUARD:       while.body:
; CHECK-PHIGUARD-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-PHIGUARD-NEXT:    [[TMP3:%.*]] = phi i32 [ [[TMP2]], [[WHILE_BODY_PREHEADER]] ], [ [[TMP4:%.*]], [[WHILE_BODY]] ]
; CHECK-PHIGUARD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-PHIGUARD-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-PHIGUARD-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-PHIGUARD-NEXT:    [[TMP4]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP3]], i32 1)
; CHECK-PHIGUARD-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
; CHECK-PHIGUARD-NEXT:    br i1 [[TMP5]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-PHIGUARD:       while.end:
; CHECK-PHIGUARD-NEXT:    ret void
;
entry:
  %cmp = icmp eq i32 %N, 0
  br i1 %cmp, label %while.end, label %while.body

while.body:
  %i.addr.05 = phi i32 [ %inc, %while.body ], [ 0, %entry ]
  %arrayidx = getelementptr inbounds i32, i32* %A, i32 %i.addr.05
  store i32 %i.addr.05, i32* %arrayidx, align 4
  %inc = add nuw i32 %i.addr.05, 1
  %exitcond = icmp eq i32 %inc, %N
  br i1 %exitcond, label %while.end, label %while.body

while.end:
  ret void
}

define void @while_preheader_eq(i32 %N, i32* nocapture %A) {
; CHECK-DEC-LABEL: @while_preheader_eq(
; CHECK-DEC-NEXT:  entry:
; CHECK-DEC-NEXT:    br label [[PREHEADER:%.*]]
; CHECK-DEC:       preheader:
; CHECK-DEC-NEXT:    [[CMP:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-DEC-NEXT:    br i1 [[CMP]], label [[WHILE_END:%.*]], label [[WHILE_BODY_PREHEADER:%.*]]
; CHECK-DEC:       while.body.preheader:
; CHECK-DEC-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[N]])
; CHECK-DEC-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-DEC:       while.body:
; CHECK-DEC-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-DEC-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-DEC-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-DEC-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-DEC-NEXT:    [[TMP0:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-DEC-NEXT:    br i1 [[TMP0]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-DEC:       while.end:
; CHECK-DEC-NEXT:    ret void
;
; CHECK-PHI-LABEL: @while_preheader_eq(
; CHECK-PHI-NEXT:  entry:
; CHECK-PHI-NEXT:    br label [[PREHEADER:%.*]]
; CHECK-PHI:       preheader:
; CHECK-PHI-NEXT:    [[CMP:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-PHI-NEXT:    br i1 [[CMP]], label [[WHILE_END:%.*]], label [[WHILE_BODY_PREHEADER:%.*]]
; CHECK-PHI:       while.body.preheader:
; CHECK-PHI-NEXT:    [[TMP0:%.*]] = call i32 @llvm.start.loop.iterations.i32(i32 [[N]])
; CHECK-PHI-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-PHI:       while.body:
; CHECK-PHI-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-PHI-NEXT:    [[TMP1:%.*]] = phi i32 [ [[TMP0]], [[WHILE_BODY_PREHEADER]] ], [ [[TMP2:%.*]], [[WHILE_BODY]] ]
; CHECK-PHI-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-PHI-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-PHI-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-PHI-NEXT:    [[TMP2]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP1]], i32 1)
; CHECK-PHI-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
; CHECK-PHI-NEXT:    br i1 [[TMP3]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-PHI:       while.end:
; CHECK-PHI-NEXT:    ret void
;
; CHECK-NESTED-LABEL: @while_preheader_eq(
; CHECK-NESTED-NEXT:  entry:
; CHECK-NESTED-NEXT:    br label [[PREHEADER:%.*]]
; CHECK-NESTED:       preheader:
; CHECK-NESTED-NEXT:    [[CMP:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-NESTED-NEXT:    br i1 [[CMP]], label [[WHILE_END:%.*]], label [[WHILE_BODY_PREHEADER:%.*]]
; CHECK-NESTED:       while.body.preheader:
; CHECK-NESTED-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[N]])
; CHECK-NESTED-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-NESTED:       while.body:
; CHECK-NESTED-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-NESTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-NESTED-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-NESTED-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-NESTED-NEXT:    [[TMP0:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-NESTED-NEXT:    br i1 [[TMP0]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-NESTED:       while.end:
; CHECK-NESTED-NEXT:    ret void
;
; CHECK-GUARD-LABEL: @while_preheader_eq(
; CHECK-GUARD-NEXT:  entry:
; CHECK-GUARD-NEXT:    br label [[PREHEADER:%.*]]
; CHECK-GUARD:       preheader:
; CHECK-GUARD-NEXT:    [[CMP:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-GUARD-NEXT:    [[TMP0:%.*]] = call i1 @llvm.test.set.loop.iterations.i32(i32 [[N]])
; CHECK-GUARD-NEXT:    br i1 [[TMP0]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-GUARD:       while.body.preheader:
; CHECK-GUARD-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-GUARD:       while.body:
; CHECK-GUARD-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-GUARD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-GUARD-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-GUARD-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-GUARD-NEXT:    [[TMP1:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-GUARD-NEXT:    br i1 [[TMP1]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-GUARD:       while.end:
; CHECK-GUARD-NEXT:    ret void
;
; CHECK-PHIGUARD-LABEL: @while_preheader_eq(
; CHECK-PHIGUARD-NEXT:  entry:
; CHECK-PHIGUARD-NEXT:    br label [[PREHEADER:%.*]]
; CHECK-PHIGUARD:       preheader:
; CHECK-PHIGUARD-NEXT:    [[CMP:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-PHIGUARD-NEXT:    [[TMP0:%.*]] = call { i32, i1 } @llvm.test.start.loop.iterations.i32(i32 [[N]])
; CHECK-PHIGUARD-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1
; CHECK-PHIGUARD-NEXT:    [[TMP2:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0
; CHECK-PHIGUARD-NEXT:    br i1 [[TMP1]], label [[WHILE_BODY_PREHEADER:%.*]], label [[WHILE_END:%.*]]
; CHECK-PHIGUARD:       while.body.preheader:
; CHECK-PHIGUARD-NEXT:    br label [[WHILE_BODY:%.*]]
; CHECK-PHIGUARD:       while.body:
; CHECK-PHIGUARD-NEXT:    [[I_ADDR_05:%.*]] = phi i32 [ [[INC:%.*]], [[WHILE_BODY]] ], [ 0, [[WHILE_BODY_PREHEADER]] ]
; CHECK-PHIGUARD-NEXT:    [[TMP3:%.*]] = phi i32 [ [[TMP2]], [[WHILE_BODY_PREHEADER]] ], [ [[TMP4:%.*]], [[WHILE_BODY]] ]
; CHECK-PHIGUARD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[I_ADDR_05]]
; CHECK-PHIGUARD-NEXT:    store i32 [[I_ADDR_05]], i32* [[ARRAYIDX]], align 4
; CHECK-PHIGUARD-NEXT:    [[INC]] = add nuw i32 [[I_ADDR_05]], 1
; CHECK-PHIGUARD-NEXT:    [[TMP4]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP3]], i32 1)
; CHECK-PHIGUARD-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
; CHECK-PHIGUARD-NEXT:    br i1 [[TMP5]], label [[WHILE_BODY]], label [[WHILE_END]]
; CHECK-PHIGUARD:       while.end:
; CHECK-PHIGUARD-NEXT:    ret void
;
entry:
  br label %preheader

preheader:
  %cmp = icmp eq i32 %N, 0
  br i1 %cmp, label %while.end, label %while.body

while.body:
  %i.addr.05 = phi i32 [ %inc, %while.body ], [ 0, %preheader ]
  %arrayidx = getelementptr inbounds i32, i32* %A, i32 %i.addr.05
  store i32 %i.addr.05, i32* %arrayidx, align 4
  %inc = add nuw i32 %i.addr.05, 1
  %exitcond = icmp eq i32 %inc, %N
  br i1 %exitcond, label %while.end, label %while.body

while.end:
  ret void
}

define void @nested(i32* nocapture %A, i32 %N) {
; CHECK-DEC-LABEL: @nested(
; CHECK-DEC-NEXT:  entry:
; CHECK-DEC-NEXT:    [[CMP20:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-DEC-NEXT:    br i1 [[CMP20]], label [[WHILE_END7:%.*]], label [[WHILE_COND1_PREHEADER_US:%.*]]
; CHECK-DEC:       while.cond1.preheader.us:
; CHECK-DEC-NEXT:    [[I_021_US:%.*]] = phi i32 [ [[INC6_US:%.*]], [[WHILE_COND1_WHILE_END_CRIT_EDGE_US:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-DEC-NEXT:    [[MUL_US:%.*]] = mul i32 [[I_021_US]], [[N]]
; CHECK-DEC-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[N]])
; CHECK-DEC-NEXT:    br label [[WHILE_BODY3_US:%.*]]
; CHECK-DEC:       while.body3.us:
; CHECK-DEC-NEXT:    [[J_019_US:%.*]] = phi i32 [ 0, [[WHILE_COND1_PREHEADER_US]] ], [ [[INC_US:%.*]], [[WHILE_BODY3_US]] ]
; CHECK-DEC-NEXT:    [[ADD_US:%.*]] = add i32 [[J_019_US]], [[MUL_US]]
; CHECK-DEC-NEXT:    [[ARRAYIDX_US:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[ADD_US]]
; CHECK-DEC-NEXT:    store i32 [[ADD_US]], i32* [[ARRAYIDX_US]], align 4
; CHECK-DEC-NEXT:    [[INC_US]] = add nuw i32 [[J_019_US]], 1
; CHECK-DEC-NEXT:    [[TMP0:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-DEC-NEXT:    br i1 [[TMP0]], label [[WHILE_BODY3_US]], label [[WHILE_COND1_WHILE_END_CRIT_EDGE_US]]
; CHECK-DEC:       while.cond1.while.end_crit_edge.us:
; CHECK-DEC-NEXT:    [[INC6_US]] = add nuw i32 [[I_021_US]], 1
; CHECK-DEC-NEXT:    [[EXITCOND23:%.*]] = icmp eq i32 [[INC6_US]], [[N]]
; CHECK-DEC-NEXT:    br i1 [[EXITCOND23]], label [[WHILE_END7]], label [[WHILE_COND1_PREHEADER_US]]
; CHECK-DEC:       while.end7:
; CHECK-DEC-NEXT:    ret void
;
; CHECK-PHI-LABEL: @nested(
; CHECK-PHI-NEXT:  entry:
; CHECK-PHI-NEXT:    [[CMP20:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-PHI-NEXT:    br i1 [[CMP20]], label [[WHILE_END7:%.*]], label [[WHILE_COND1_PREHEADER_US:%.*]]
; CHECK-PHI:       while.cond1.preheader.us:
; CHECK-PHI-NEXT:    [[I_021_US:%.*]] = phi i32 [ [[INC6_US:%.*]], [[WHILE_COND1_WHILE_END_CRIT_EDGE_US:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-PHI-NEXT:    [[MUL_US:%.*]] = mul i32 [[I_021_US]], [[N]]
; CHECK-PHI-NEXT:    [[TMP0:%.*]] = call i32 @llvm.start.loop.iterations.i32(i32 [[N]])
; CHECK-PHI-NEXT:    br label [[WHILE_BODY3_US:%.*]]
; CHECK-PHI:       while.body3.us:
; CHECK-PHI-NEXT:    [[J_019_US:%.*]] = phi i32 [ 0, [[WHILE_COND1_PREHEADER_US]] ], [ [[INC_US:%.*]], [[WHILE_BODY3_US]] ]
; CHECK-PHI-NEXT:    [[TMP1:%.*]] = phi i32 [ [[TMP0]], [[WHILE_COND1_PREHEADER_US]] ], [ [[TMP2:%.*]], [[WHILE_BODY3_US]] ]
; CHECK-PHI-NEXT:    [[ADD_US:%.*]] = add i32 [[J_019_US]], [[MUL_US]]
; CHECK-PHI-NEXT:    [[ARRAYIDX_US:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[ADD_US]]
; CHECK-PHI-NEXT:    store i32 [[ADD_US]], i32* [[ARRAYIDX_US]], align 4
; CHECK-PHI-NEXT:    [[INC_US]] = add nuw i32 [[J_019_US]], 1
; CHECK-PHI-NEXT:    [[TMP2]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP1]], i32 1)
; CHECK-PHI-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
; CHECK-PHI-NEXT:    br i1 [[TMP3]], label [[WHILE_BODY3_US]], label [[WHILE_COND1_WHILE_END_CRIT_EDGE_US]]
; CHECK-PHI:       while.cond1.while.end_crit_edge.us:
; CHECK-PHI-NEXT:    [[INC6_US]] = add nuw i32 [[I_021_US]], 1
; CHECK-PHI-NEXT:    [[EXITCOND23:%.*]] = icmp eq i32 [[INC6_US]], [[N]]
; CHECK-PHI-NEXT:    br i1 [[EXITCOND23]], label [[WHILE_END7]], label [[WHILE_COND1_PREHEADER_US]]
; CHECK-PHI:       while.end7:
; CHECK-PHI-NEXT:    ret void
;
; CHECK-NESTED-LABEL: @nested(
; CHECK-NESTED-NEXT:  entry:
; CHECK-NESTED-NEXT:    [[CMP20:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-NESTED-NEXT:    br i1 [[CMP20]], label [[WHILE_END7:%.*]], label [[WHILE_COND1_PREHEADER_US_PREHEADER:%.*]]
; CHECK-NESTED:       while.cond1.preheader.us.preheader:
; CHECK-NESTED-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[N]])
; CHECK-NESTED-NEXT:    br label [[WHILE_COND1_PREHEADER_US:%.*]]
; CHECK-NESTED:       while.cond1.preheader.us:
; CHECK-NESTED-NEXT:    [[I_021_US:%.*]] = phi i32 [ [[INC6_US:%.*]], [[WHILE_COND1_WHILE_END_CRIT_EDGE_US:%.*]] ], [ 0, [[WHILE_COND1_PREHEADER_US_PREHEADER]] ]
; CHECK-NESTED-NEXT:    [[MUL_US:%.*]] = mul i32 [[I_021_US]], [[N]]
; CHECK-NESTED-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[N]])
; CHECK-NESTED-NEXT:    br label [[WHILE_BODY3_US:%.*]]
; CHECK-NESTED:       while.body3.us:
; CHECK-NESTED-NEXT:    [[J_019_US:%.*]] = phi i32 [ 0, [[WHILE_COND1_PREHEADER_US]] ], [ [[INC_US:%.*]], [[WHILE_BODY3_US]] ]
; CHECK-NESTED-NEXT:    [[ADD_US:%.*]] = add i32 [[J_019_US]], [[MUL_US]]
; CHECK-NESTED-NEXT:    [[ARRAYIDX_US:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[ADD_US]]
; CHECK-NESTED-NEXT:    store i32 [[ADD_US]], i32* [[ARRAYIDX_US]], align 4
; CHECK-NESTED-NEXT:    [[INC_US]] = add nuw i32 [[J_019_US]], 1
; CHECK-NESTED-NEXT:    [[TMP0:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-NESTED-NEXT:    br i1 [[TMP0]], label [[WHILE_BODY3_US]], label [[WHILE_COND1_WHILE_END_CRIT_EDGE_US]]
; CHECK-NESTED:       while.cond1.while.end_crit_edge.us:
; CHECK-NESTED-NEXT:    [[INC6_US]] = add nuw i32 [[I_021_US]], 1
; CHECK-NESTED-NEXT:    [[TMP1:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-NESTED-NEXT:    br i1 [[TMP1]], label [[WHILE_COND1_PREHEADER_US]], label [[WHILE_END7]]
; CHECK-NESTED:       while.end7:
; CHECK-NESTED-NEXT:    ret void
;
; CHECK-GUARD-LABEL: @nested(
; CHECK-GUARD-NEXT:  entry:
; CHECK-GUARD-NEXT:    [[CMP20:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-GUARD-NEXT:    br i1 [[CMP20]], label [[WHILE_END7:%.*]], label [[WHILE_COND1_PREHEADER_US:%.*]]
; CHECK-GUARD:       while.cond1.preheader.us:
; CHECK-GUARD-NEXT:    [[I_021_US:%.*]] = phi i32 [ [[INC6_US:%.*]], [[WHILE_COND1_WHILE_END_CRIT_EDGE_US:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-GUARD-NEXT:    [[MUL_US:%.*]] = mul i32 [[I_021_US]], [[N]]
; CHECK-GUARD-NEXT:    call void @llvm.set.loop.iterations.i32(i32 [[N]])
; CHECK-GUARD-NEXT:    br label [[WHILE_BODY3_US:%.*]]
; CHECK-GUARD:       while.body3.us:
; CHECK-GUARD-NEXT:    [[J_019_US:%.*]] = phi i32 [ 0, [[WHILE_COND1_PREHEADER_US]] ], [ [[INC_US:%.*]], [[WHILE_BODY3_US]] ]
; CHECK-GUARD-NEXT:    [[ADD_US:%.*]] = add i32 [[J_019_US]], [[MUL_US]]
; CHECK-GUARD-NEXT:    [[ARRAYIDX_US:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[ADD_US]]
; CHECK-GUARD-NEXT:    store i32 [[ADD_US]], i32* [[ARRAYIDX_US]], align 4
; CHECK-GUARD-NEXT:    [[INC_US]] = add nuw i32 [[J_019_US]], 1
; CHECK-GUARD-NEXT:    [[TMP0:%.*]] = call i1 @llvm.loop.decrement.i32(i32 1)
; CHECK-GUARD-NEXT:    br i1 [[TMP0]], label [[WHILE_BODY3_US]], label [[WHILE_COND1_WHILE_END_CRIT_EDGE_US]]
; CHECK-GUARD:       while.cond1.while.end_crit_edge.us:
; CHECK-GUARD-NEXT:    [[INC6_US]] = add nuw i32 [[I_021_US]], 1
; CHECK-GUARD-NEXT:    [[EXITCOND23:%.*]] = icmp eq i32 [[INC6_US]], [[N]]
; CHECK-GUARD-NEXT:    br i1 [[EXITCOND23]], label [[WHILE_END7]], label [[WHILE_COND1_PREHEADER_US]]
; CHECK-GUARD:       while.end7:
; CHECK-GUARD-NEXT:    ret void
;
; CHECK-PHIGUARD-LABEL: @nested(
; CHECK-PHIGUARD-NEXT:  entry:
; CHECK-PHIGUARD-NEXT:    [[CMP20:%.*]] = icmp eq i32 [[N:%.*]], 0
; CHECK-PHIGUARD-NEXT:    br i1 [[CMP20]], label [[WHILE_END7:%.*]], label [[WHILE_COND1_PREHEADER_US:%.*]]
; CHECK-PHIGUARD:       while.cond1.preheader.us:
; CHECK-PHIGUARD-NEXT:    [[I_021_US:%.*]] = phi i32 [ [[INC6_US:%.*]], [[WHILE_COND1_WHILE_END_CRIT_EDGE_US:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-PHIGUARD-NEXT:    [[MUL_US:%.*]] = mul i32 [[I_021_US]], [[N]]
; CHECK-PHIGUARD-NEXT:    [[TMP0:%.*]] = call i32 @llvm.start.loop.iterations.i32(i32 [[N]])
; CHECK-PHIGUARD-NEXT:    br label [[WHILE_BODY3_US:%.*]]
; CHECK-PHIGUARD:       while.body3.us:
; CHECK-PHIGUARD-NEXT:    [[J_019_US:%.*]] = phi i32 [ 0, [[WHILE_COND1_PREHEADER_US]] ], [ [[INC_US:%.*]], [[WHILE_BODY3_US]] ]
; CHECK-PHIGUARD-NEXT:    [[TMP1:%.*]] = phi i32 [ [[TMP0]], [[WHILE_COND1_PREHEADER_US]] ], [ [[TMP2:%.*]], [[WHILE_BODY3_US]] ]
; CHECK-PHIGUARD-NEXT:    [[ADD_US:%.*]] = add i32 [[J_019_US]], [[MUL_US]]
; CHECK-PHIGUARD-NEXT:    [[ARRAYIDX_US:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[ADD_US]]
; CHECK-PHIGUARD-NEXT:    store i32 [[ADD_US]], i32* [[ARRAYIDX_US]], align 4
; CHECK-PHIGUARD-NEXT:    [[INC_US]] = add nuw i32 [[J_019_US]], 1
; CHECK-PHIGUARD-NEXT:    [[TMP2]] = call i32 @llvm.loop.decrement.reg.i32(i32 [[TMP1]], i32 1)
; CHECK-PHIGUARD-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
; CHECK-PHIGUARD-NEXT:    br i1 [[TMP3]], label [[WHILE_BODY3_US]], label [[WHILE_COND1_WHILE_END_CRIT_EDGE_US]]
; CHECK-PHIGUARD:       while.cond1.while.end_crit_edge.us:
; CHECK-PHIGUARD-NEXT:    [[INC6_US]] = add nuw i32 [[I_021_US]], 1
; CHECK-PHIGUARD-NEXT:    [[EXITCOND23:%.*]] = icmp eq i32 [[INC6_US]], [[N]]
; CHECK-PHIGUARD-NEXT:    br i1 [[EXITCOND23]], label [[WHILE_END7]], label [[WHILE_COND1_PREHEADER_US]]
; CHECK-PHIGUARD:       while.end7:
; CHECK-PHIGUARD-NEXT:    ret void
;
entry:
  %cmp20 = icmp eq i32 %N, 0
  br i1 %cmp20, label %while.end7, label %while.cond1.preheader.us

while.cond1.preheader.us:
  %i.021.us = phi i32 [ %inc6.us, %while.cond1.while.end_crit_edge.us ], [ 0, %entry ]
  %mul.us = mul i32 %i.021.us, %N
  br label %while.body3.us

while.body3.us:
  %j.019.us = phi i32 [ 0, %while.cond1.preheader.us ], [ %inc.us, %while.body3.us ]
  %add.us = add i32 %j.019.us, %mul.us
  %arrayidx.us = getelementptr inbounds i32, i32* %A, i32 %add.us
  store i32 %add.us, i32* %arrayidx.us, align 4
  %inc.us = add nuw i32 %j.019.us, 1
  %exitcond = icmp eq i32 %inc.us, %N
  br i1 %exitcond, label %while.cond1.while.end_crit_edge.us, label %while.body3.us

while.cond1.while.end_crit_edge.us:
  %inc6.us = add nuw i32 %i.021.us, 1
  %exitcond23 = icmp eq i32 %inc6.us, %N
  br i1 %exitcond23, label %while.end7, label %while.cond1.preheader.us

while.end7:
  ret void
}
