; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -verify -iroutliner -ir-outlining-no-cost < %s | FileCheck %s

@global1 = global i32 1, align 4
@global2 = global i32 2, align 4

; This test looks at the globals in the regions, and if it they are the
; same it outlines the region without elevating the globals to arguments.

define void @outline_globals1() {
; CHECK-LABEL: @outline_globals1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @outlined_ir_func_0()
; CHECK-NEXT:    ret void
;
entry:
  %0 = load i32, i32* @global1
  %1 = load i32, i32* @global2
  %2 = add i32 %0, %1
  ret void
}

define void @outline_globals2() {
; CHECK-LABEL: @outline_globals2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @outlined_ir_func_0()
; CHECK-NEXT:    ret void
;
entry:
  %0 = load i32, i32* @global1
  %1 = load i32, i32* @global2
  %2 = add i32 %0, %1
  ret void
}

; CHECK: define internal void @outlined_ir_func_0()
; CHECK: entry_to_outline:
; CHECK-NEXT: [[TMP1:%.*]] = load i32, i32* @global1, align 4
; CHECK-NEXT: [[TMP2:%.*]] = load i32, i32* @global2, align 4
; CHECK-NEXT: [[ADD:%.*]] = add i32 [[TMP1]], [[TMP2]]

