; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -amdgpu-scalarize-global-loads=false  -march=amdgcn -mtriple=amdgcn-- -mcpu=verde -verify-machineinstrs | FileCheck %s --check-prefixes=SI
; RUN: llc < %s -march=amdgcn -mtriple=amdgcn-- -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs | FileCheck %s -check-prefixes=VI
; RUN: llc < %s -amdgpu-scalarize-global-loads=false  -march=r600 -mtriple=r600-- -mcpu=redwood -verify-machineinstrs | FileCheck %s --check-prefixes=EG

declare i32 @llvm.amdgcn.workitem.id.x() #0

declare i32 @llvm.amdgcn.workgroup.id.x() #0

define amdgpu_kernel void @shl_v2i32(<2 x i32> addrspace(1)* %out, <2 x i32> addrspace(1)* %in) {
; SI-LABEL: shl_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshl_b32_e32 v1, v1, v3
; SI-NEXT:    v_lshl_b32_e32 v0, v0, v2
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: shl_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s5, s5, s7
; VI-NEXT:    s_lshl_b32 s4, s4, s6
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: shl_v2i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 3, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHL * T0.Y, T0.Y, T0.W,
; EG-NEXT:     LSHL T0.X, T0.X, T0.Z,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <2 x i32>, <2 x i32> addrspace(1)* %in, i32 1
  %a = load <2 x i32>, <2 x i32> addrspace(1)* %in
  %b = load <2 x i32>, <2 x i32> addrspace(1)* %b_ptr
  %result = shl <2 x i32> %a, %b
  store <2 x i32> %result, <2 x i32> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_v4i32(<4 x i32> addrspace(1)* %out, <4 x i32> addrspace(1)* %in) {
; SI-LABEL: shl_v4i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshl_b32_e32 v3, v3, v7
; SI-NEXT:    v_lshl_b32_e32 v2, v2, v6
; SI-NEXT:    v_lshl_b32_e32 v1, v1, v5
; SI-NEXT:    v_lshl_b32_e32 v0, v0, v4
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: shl_v4i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s3, s3, s7
; VI-NEXT:    s_lshl_b32 s2, s2, s6
; VI-NEXT:    s_lshl_b32 s1, s1, s5
; VI-NEXT:    s_lshl_b32 s0, s0, s4
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: shl_v4i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 5, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     LSHL * T0.W, T0.W, T1.W,
; EG-NEXT:     LSHL * T0.Z, T0.Z, T1.Z,
; EG-NEXT:     LSHL * T0.Y, T0.Y, T1.Y,
; EG-NEXT:     LSHL T0.X, T0.X, T1.X,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <4 x i32>, <4 x i32> addrspace(1)* %in, i32 1
  %a = load <4 x i32>, <4 x i32> addrspace(1)* %in
  %b = load <4 x i32>, <4 x i32> addrspace(1)* %b_ptr
  %result = shl <4 x i32> %a, %b
  store <4 x i32> %result, <4 x i32> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_i16(i16 addrspace(1)* %out, i16 addrspace(1)* %in) {
; SI-LABEL: shl_i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; SI-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 offset:2
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: shl_i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; VI-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 offset:2
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; VI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: shl_i16:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 12, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T1.X, T0.X, 2, #1
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     AND_INT T0.W, KC0[2].Y, literal.x,
; EG-NEXT:     LSHL * T1.W, T0.X, T1.X,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T1.W, PS, literal.x,
; EG-NEXT:     LSHL * T0.W, PV.W, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr i16, i16 addrspace(1)* %in, i16 1
  %a = load i16, i16 addrspace(1)* %in
  %b = load i16, i16 addrspace(1)* %b_ptr
  %result = shl i16 %a, %b
  store i16 %result, i16 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_i16_v_s(i16 addrspace(1)* %out, i16 addrspace(1)* %in, i16 %b) {
; SI-LABEL: shl_i16_v_s:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s12, s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s10, s2
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s6
; SI-NEXT:    s_mov_b32 s9, s7
; SI-NEXT:    s_mov_b32 s11, s3
; SI-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s0, s4
; SI-NEXT:    s_mov_b32 s1, s5
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, s12, v0
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: shl_i16_v_s:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s12, s[0:1], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s10, s2
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s6
; VI-NEXT:    s_mov_b32 s9, s7
; VI-NEXT:    s_mov_b32 s11, s3
; VI-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v0, s12, v0
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: shl_i16_v_s:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 1, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 12, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T1.X, T1.X, 0, #1
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 44, #3
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     MOV * T1.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     AND_INT T0.W, KC0[2].Y, literal.x,
; EG-NEXT:     LSHL * T1.W, T1.X, T0.X,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T1.W, PS, literal.x,
; EG-NEXT:     LSHL * T0.W, PV.W, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %a = load i16, i16 addrspace(1)* %in
  %result = shl i16 %a, %b
  store i16 %result, i16 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_i16_v_compute_s(i16 addrspace(1)* %out, i16 addrspace(1)* %in, i16 %b) {
; SI-LABEL: shl_i16_v_compute_s:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s12, s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s10, s2
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s6
; SI-NEXT:    s_mov_b32 s9, s7
; SI-NEXT:    s_mov_b32 s11, s3
; SI-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; SI-NEXT:    s_add_i32 s12, s12, 3
; SI-NEXT:    s_mov_b32 s0, s4
; SI-NEXT:    s_mov_b32 s1, s5
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, s12, v0
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: shl_i16_v_compute_s:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s12, s[0:1], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s10, s2
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s6
; VI-NEXT:    s_mov_b32 s9, s7
; VI-NEXT:    s_mov_b32 s11, s3
; VI-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; VI-NEXT:    s_add_i32 s12, s12, 3
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v0, s12, v0
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: shl_i16_v_compute_s:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @12, KC0[], KC1[]
; EG-NEXT:    TEX 0 @8
; EG-NEXT:    ALU 0, @13, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @10
; EG-NEXT:    ALU 15, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 44, #3
; EG-NEXT:    Fetch clause starting at 10:
; EG-NEXT:     VTX_READ_16 T1.X, T1.X, 0, #1
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     MOV * T0.X, 0.0,
; EG-NEXT:    ALU clause starting at 13:
; EG-NEXT:     MOV * T1.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     ADD_INT * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL * T0.W, T1.X, PV.W,
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, T1.W, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %a = load i16, i16 addrspace(1)* %in
  %b.add = add i16 %b, 3
  %result = shl i16 %a, %b.add
  store i16 %result, i16 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_i16_computed_amount(i16 addrspace(1)* %out, i16 addrspace(1)* %in) {
; SI-LABEL: shl_i16_computed_amount:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s14, 0
; SI-NEXT:    s_mov_b32 s15, s7
; SI-NEXT:    s_mov_b64 s[12:13], s[2:3]
; SI-NEXT:    buffer_load_ushort v2, off, s[8:11], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v0, v[0:1], s[12:15], 0 addr64 offset:2 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, v0, v2
; SI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: shl_i16_computed_amount:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 2, v0
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    buffer_load_ushort v2, off, s[8:11], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_load_ushort v0, v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_add_u16_e32 v0, 3, v0
; VI-NEXT:    v_lshlrev_b16_e32 v0, v0, v2
; VI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: shl_i16_computed_amount:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @8
; EG-NEXT:    ALU 1, @13, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @10
; EG-NEXT:    ALU 15, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_16 T1.X, T1.X, 0, #1
; EG-NEXT:    Fetch clause starting at 10:
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 2, #1
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     MOV * T1.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 13:
; EG-NEXT:     LSHL * T0.W, T0.X, 1,
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     ADD_INT * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL * T0.W, T1.X, PV.W,
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, T1.W, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep = getelementptr inbounds i16, i16 addrspace(1)* %in, i32 %tid
  %gep.out = getelementptr inbounds i16, i16 addrspace(1)* %out, i32 %tid
  %b_ptr = getelementptr i16, i16 addrspace(1)* %gep, i16 1
  %a = load volatile i16, i16 addrspace(1)* %in
  %b = load volatile i16, i16 addrspace(1)* %b_ptr
  %b.add = add i16 %b, 3
  %result = shl i16 %a, %b.add
  store i16 %result, i16 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_i16_i_s(i16 addrspace(1)* %out, i16 zeroext %a) {
; SI-LABEL: shl_i16_i_s:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s4, s4, 12
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: shl_i16_i_s:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s4, s4, 12
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: shl_i16_i_s:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 14, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 40, #3
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, 0.0,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_INT T0.W, T0.X, 0.0, literal.x,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    16(2.242078e-44), 3(4.203895e-45)
; EG-NEXT:     LSHL * T0.W, PV.W, literal.x,
; EG-NEXT:    12(1.681558e-44), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, T1.W, literal.y,
; EG-NEXT:    61440(8.609578e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %result = shl i16 %a, 12
  store i16 %result, i16 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_v2i16(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(1)* %in) {
; SI-LABEL: shl_v2i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s14, 0
; SI-NEXT:    s_mov_b32 s15, s7
; SI-NEXT:    s_mov_b64 s[12:13], s[2:3]
; SI-NEXT:    buffer_load_dword v2, off, s[8:11], 0
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[12:15], 0 addr64 offset:4
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, v0, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, v3, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: shl_v2i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 4, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_load_dword s4, s[2:3], 0x0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s5, s4, 16
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e64 v2, v0, s4
; VI-NEXT:    v_lshlrev_b16_sdwa v0, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: shl_v2i16:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @8
; EG-NEXT:    ALU 0, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @10
; EG-NEXT:    ALU 12, @16, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T7.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 4, #1
; EG-NEXT:    Fetch clause starting at 10:
; EG-NEXT:     VTX_READ_32 T7.X, T7.X, 0, #1
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     MOV * T7.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 16:
; EG-NEXT:     AND_INT T0.Y, T0.X, literal.x,
; EG-NEXT:     AND_INT T0.Z, T7.X, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     LSHR T0.W, T0.X, literal.y,
; EG-NEXT:     LSHR * T1.W, T7.X, literal.y,
; EG-NEXT:    65535(9.183409e-41), 16(2.242078e-44)
; EG-NEXT:     LSHL T0.W, PS, PV.W,
; EG-NEXT:     LSHL * T1.W, PV.Z, PV.Y,
; EG-NEXT:     AND_INT T1.W, PS, literal.x,
; EG-NEXT:     LSHL * T0.W, PV.W, literal.y,
; EG-NEXT:    65535(9.183409e-41), 16(2.242078e-44)
; EG-NEXT:     OR_INT T0.X, PV.W, PS,
; EG-NEXT:     LSHR * T7.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %in, i32 %tid
  %gep.out = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %out, i32 %tid
  %b_ptr = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %gep, i16 1
  %a = load <2 x i16>, <2 x i16> addrspace(1)* %in
  %b = load <2 x i16>, <2 x i16> addrspace(1)* %b_ptr
  %result = shl <2 x i16> %a, %b
  store <2 x i16> %result, <2 x i16> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_v4i16(<4 x i16> addrspace(1)* %out, <4 x i16> addrspace(1)* %in) {
; SI-LABEL: shl_v4i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; SI-NEXT:    v_mov_b32_e32 v5, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-NEXT:    buffer_load_dwordx4 v[0:3], v[4:5], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b32 s4, 0xffff
; SI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, v3, v1
; SI-NEXT:    v_lshlrev_b32_e32 v0, v2, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, v9, v7
; SI-NEXT:    v_lshlrev_b32_e32 v3, v8, v6
; SI-NEXT:    v_and_b32_e32 v1, s4, v1
; SI-NEXT:    v_and_b32_e32 v0, s4, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v3
; SI-NEXT:    buffer_store_dwordx2 v[0:1], v[4:5], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: shl_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v4
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v5, s1
; VI-NEXT:    v_add_u32_e32 v4, vcc, s0, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e32 v6, v3, v1
; VI-NEXT:    v_lshlrev_b16_sdwa v1, v3, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b16_e32 v3, v2, v0
; VI-NEXT:    v_lshlrev_b16_sdwa v0, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-NEXT:    v_or_b32_e32 v1, v6, v1
; VI-NEXT:    v_or_b32_e32 v0, v3, v0
; VI-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; VI-NEXT:    s_endpgm
;
; EG-LABEL: shl_v4i16:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 53, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T10.XY, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T10.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     MOV T4.X, T10.X,
; EG-NEXT:     MOV * T5.X, T10.Y,
; EG-NEXT:     MOV T0.X, PV.X,
; EG-NEXT:     MOV T0.Y, PS,
; EG-NEXT:     MOV * T2.X, T10.Z,
; EG-NEXT:     MOV T3.X, T10.W,
; EG-NEXT:     MOV * T0.Z, T6.X,
; EG-NEXT:     MOV * T1.Y, T2.X,
; EG-NEXT:     AND_INT T1.W, PV.Y, literal.x,
; EG-NEXT:     AND_INT * T2.W, T0.X, literal.x,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     LSHL * T1.W, PS, PV.W,
; EG-NEXT:     AND_INT T1.W, PV.W, literal.x,
; EG-NEXT:     AND_INT * T2.W, T0.Z, literal.y,
; EG-NEXT:    65535(9.183409e-41), -65536(nan)
; EG-NEXT:     OR_INT * T1.W, PS, PV.W,
; EG-NEXT:     MOV * T0.Z, T3.X,
; EG-NEXT:     MOV * T6.X, T1.W,
; EG-NEXT:     MOV T1.Z, PV.X,
; EG-NEXT:     LSHR T1.W, T1.Y, literal.x,
; EG-NEXT:     LSHR * T2.W, T0.X, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T1.W, PS, PV.W,
; EG-NEXT:     AND_INT * T2.W, PV.Z, literal.x,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     LSHL * T1.W, PV.W, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     OR_INT * T1.W, T2.W, PV.W,
; EG-NEXT:     MOV T6.X, PV.W,
; EG-NEXT:     MOV * T0.X, T7.X,
; EG-NEXT:     AND_INT T1.W, T0.Z, literal.x,
; EG-NEXT:     AND_INT * T2.W, T0.Y, literal.x,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     LSHL T1.W, PS, PV.W,
; EG-NEXT:     AND_INT * T2.W, T0.X, literal.x,
; EG-NEXT:    -65536(nan), 0(0.000000e+00)
; EG-NEXT:     AND_INT * T1.W, PV.W, literal.x,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     OR_INT * T1.W, T2.W, PV.W,
; EG-NEXT:     MOV * T7.X, PV.W,
; EG-NEXT:     MOV T0.X, PV.X,
; EG-NEXT:     LSHR T1.W, T0.Z, literal.x,
; EG-NEXT:     LSHR * T2.W, T0.Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL * T1.W, PS, PV.W,
; EG-NEXT:     AND_INT T0.Z, T0.X, literal.x,
; EG-NEXT:     LSHL T1.W, PV.W, literal.y,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, T0.W,
; EG-NEXT:    65535(9.183409e-41), 16(2.242078e-44)
; EG-NEXT:     LSHR T0.X, PS, literal.x,
; EG-NEXT:     OR_INT * T10.Y, PV.Z, PV.W,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MOV T7.X, PV.Y,
; EG-NEXT:     MOV * T10.X, T6.X,
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #0
  %gep = getelementptr inbounds <4 x i16>, <4 x i16> addrspace(1)* %in, i32 %tid
  %gep.out = getelementptr inbounds <4 x i16>, <4 x i16> addrspace(1)* %out, i32 %tid
  %b_ptr = getelementptr <4 x i16>, <4 x i16> addrspace(1)* %gep, i16 1
  %a = load <4 x i16>, <4 x i16> addrspace(1)* %gep
  %b = load <4 x i16>, <4 x i16> addrspace(1)* %b_ptr
  %result = shl <4 x i16> %a, %b
  store <4 x i16> %result, <4 x i16> addrspace(1)* %gep.out
  ret void
}

define amdgpu_kernel void @shl_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %in) {
; SI-LABEL: shl_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshl_b64 v[0:1], v[0:1], v2
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: shl_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], s6
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: shl_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 12, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     AND_INT T1.Y, T0.Z, literal.x,
; EG-NEXT:     LSHR T1.Z, T0.Y, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.W, T0.Y, T0.X, 1,
; EG-NEXT:     NOT_INT * T1.W, T0.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.Z, PV.W, PS,
; EG-NEXT:     LSHL T0.W, T0.X, PV.Y,
; EG-NEXT:     AND_INT * T1.W, T0.Z, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.Z, PV.W,
; EG-NEXT:     CNDE_INT T0.X, T1.W, T0.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr i64, i64 addrspace(1)* %in, i64 1
  %a = load i64, i64 addrspace(1)* %in
  %b = load i64, i64 addrspace(1)* %b_ptr
  %result = shl i64 %a, %b
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_v2i64(<2 x i64> addrspace(1)* %out, <2 x i64> addrspace(1)* %in) {
; SI-LABEL: shl_v2i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshl_b64 v[2:3], v[2:3], v6
; SI-NEXT:    v_lshl_b64 v[0:1], v[0:1], v4
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: shl_v2i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[8:11], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx8 s[0:7], s[10:11], 0x0
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[2:3], s[2:3], s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], s4
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: shl_v2i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 22, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     AND_INT T1.Y, T1.Z, literal.x,
; EG-NEXT:     LSHR T2.Z, T0.W, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.W, T0.W, T0.Z, 1,
; EG-NEXT:     NOT_INT * T1.W, T1.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T0.W, PV.Z, PV.W, PS,
; EG-NEXT:     LSHL * T1.W, T0.Z, PV.Y,
; EG-NEXT:     AND_INT T2.X, T1.Z, literal.x,
; EG-NEXT:     AND_INT T1.Y, T1.X, literal.y,
; EG-NEXT:     LSHR T0.Z, T0.Y, 1,
; EG-NEXT:     BIT_ALIGN_INT T2.W, T0.Y, T0.X, 1,
; EG-NEXT:     NOT_INT * T3.W, T1.X,
; EG-NEXT:    32(4.484155e-44), 31(4.344025e-44)
; EG-NEXT:     BIT_ALIGN_INT T0.Y, PV.Z, PV.W, PS,
; EG-NEXT:     LSHL T0.Z, T0.X, PV.Y,
; EG-NEXT:     AND_INT T2.W, T1.X, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T3.W, PV.X, T0.W, T1.W,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PV.Y, PV.Z,
; EG-NEXT:     CNDE_INT * T3.Z, T2.X, T1.W, 0.0,
; EG-NEXT:     CNDE_INT T3.X, T2.W, T0.Z, 0.0,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <2 x i64>, <2 x i64> addrspace(1)* %in, i64 1
  %a = load <2 x i64>, <2 x i64> addrspace(1)* %in
  %b = load <2 x i64>, <2 x i64> addrspace(1)* %b_ptr
  %result = shl <2 x i64> %a, %b
  store <2 x i64> %result, <2 x i64> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @shl_v4i64(<4 x i64> addrspace(1)* %out, <4 x i64> addrspace(1)* %in) {
; SI-LABEL: shl_v4i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s10, s2
; SI-NEXT:    s_mov_b32 s11, s3
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s6
; SI-NEXT:    s_mov_b32 s9, s7
; SI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; SI-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:48
; SI-NEXT:    buffer_load_dwordx4 v[7:10], off, s[8:11], 0
; SI-NEXT:    buffer_load_dwordx4 v[11:14], off, s[8:11], 0 offset:32
; SI-NEXT:    s_mov_b32 s0, s4
; SI-NEXT:    s_mov_b32 s1, s5
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshl_b64 v[2:3], v[2:3], v6
; SI-NEXT:    v_lshl_b64 v[0:1], v[0:1], v4
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshl_b64 v[9:10], v[9:10], v13
; SI-NEXT:    v_lshl_b64 v[7:8], v[7:8], v11
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[7:10], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: shl_v4i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[16:19], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx16 s[0:15], s[18:19], 0x0
; VI-NEXT:    s_mov_b32 s19, 0xf000
; VI-NEXT:    s_mov_b32 s18, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], s14
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], s12
; VI-NEXT:    s_lshl_b64 s[2:3], s[2:3], s10
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], s8
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0 offset:16
; VI-NEXT:    s_nop 0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: shl_v4i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 3 @6
; EG-NEXT:    ALU 47, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XYZW, T2.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 48, #1
; EG-NEXT:     VTX_READ_128 T2.XYZW, T0.X, 0, #1
; EG-NEXT:     VTX_READ_128 T3.XYZW, T0.X, 32, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 16, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     AND_INT T4.Z, T1.Z, literal.x,
; EG-NEXT:     LSHR T1.W, T0.W, 1,
; EG-NEXT:     NOT_INT * T3.W, T1.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.X, T0.W, T0.Z, 1,
; EG-NEXT:     AND_INT T1.Y, T3.Z, literal.x, BS:VEC_201
; EG-NEXT:     LSHR T5.Z, T2.W, 1, BS:VEC_120/SCL_212
; EG-NEXT:     BIT_ALIGN_INT T0.W, T2.W, T2.Z, 1, BS:VEC_102/SCL_221
; EG-NEXT:     NOT_INT * T2.W, T3.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.Y, PV.Z, PV.W, PS,
; EG-NEXT:     LSHL T2.Z, T2.Z, PV.Y,
; EG-NEXT:     BIT_ALIGN_INT T0.W, T1.W, PV.X, T3.W,
; EG-NEXT:     LSHL * T1.W, T0.Z, T4.Z,
; EG-NEXT:     AND_INT T4.X, T1.Z, literal.x,
; EG-NEXT:     AND_INT T1.Y, T1.X, literal.y,
; EG-NEXT:     LSHR T0.Z, T0.Y, 1,
; EG-NEXT:     BIT_ALIGN_INT T2.W, T0.Y, T0.X, 1,
; EG-NEXT:     NOT_INT * T3.W, T1.X,
; EG-NEXT:    32(4.484155e-44), 31(4.344025e-44)
; EG-NEXT:     AND_INT T5.X, T3.Z, literal.x,
; EG-NEXT:     BIT_ALIGN_INT T0.Y, PV.Z, PV.W, PS,
; EG-NEXT:     LSHL T0.Z, T0.X, PV.Y,
; EG-NEXT:     AND_INT T2.W, T1.X, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T4.W, PV.X, T0.W, T1.W,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.X, T3.X, literal.x,
; EG-NEXT:     CNDE_INT T4.Y, PV.W, PV.Y, PV.Z,
; EG-NEXT:     LSHR T1.Z, T2.Y, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.W, T2.Y, T2.X, 1,
; EG-NEXT:     NOT_INT * T3.W, T3.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T1.X, PV.Z, PV.W, PS,
; EG-NEXT:     LSHL T0.Y, T2.X, PV.X,
; EG-NEXT:     CNDE_INT T4.Z, T4.X, T1.W, 0.0, BS:VEC_120/SCL_212
; EG-NEXT:     AND_INT * T0.W, T3.X, literal.x, BS:VEC_201
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T1.W, T5.X, T3.Y, T2.Z,
; EG-NEXT:     CNDE_INT T4.X, T2.W, T0.Z, 0.0,
; EG-NEXT:     CNDE_INT T1.Y, T0.W, T1.X, T0.Y, BS:VEC_120/SCL_212
; EG-NEXT:     ADD_INT * T2.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PV.W, literal.x,
; EG-NEXT:     CNDE_INT T1.Z, T5.X, T2.Z, 0.0,
; EG-NEXT:     CNDE_INT * T1.X, T0.W, T0.Y, 0.0,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     LSHR * T2.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <4 x i64>, <4 x i64> addrspace(1)* %in, i64 1
  %a = load <4 x i64>, <4 x i64> addrspace(1)* %in
  %b = load <4 x i64>, <4 x i64> addrspace(1)* %b_ptr
  %result = shl <4 x i64> %a, %b
  store <4 x i64> %result, <4 x i64> addrspace(1)* %out
  ret void
}

; Make sure load width gets reduced to i32 load.
define amdgpu_kernel void @s_shl_32_i64(i64 addrspace(1)* %out, [8 x i32], i64 %a) {
; SI-LABEL: s_shl_32_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s4
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_32_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x4c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_mov_b32_e32 v0, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_32_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     MOV * T0.Y, KC0[4].W,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %result = shl i64 %a, 32
  store i64 %result, i64 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @v_shl_32_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %in) {
; SI-LABEL: v_shl_32_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_ashr_i32 s3, s2, 31
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[6:7]
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_load_dword v3, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b64 s[6:7], s[10:11]
; SI-NEXT:    v_mov_b32_e32 v2, 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_shl_32_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_ashr_i32 s3, s2, 31
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; VI-NEXT:    v_mov_b32_e32 v0, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_add_u32 s2, s6, s0
; VI-NEXT:    s_addc_u32 s3, s7, s1
; VI-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_shl_32_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 4, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XY, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T1.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     MOV T1.X, 0.0,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, T0.W,
; EG-NEXT:     LSHR T2.X, PV.W, literal.x,
; EG-NEXT:     MOV * T1.Y, T0.X,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %tid = call i32 @llvm.amdgcn.workgroup.id.x() #0
  %gep.in = getelementptr i64, i64 addrspace(1)* %in, i32 %tid
  %gep.out = getelementptr i64, i64 addrspace(1)* %out, i32 %tid
  %a = load i64, i64 addrspace(1)* %gep.in
  %result = shl i64 %a, 32
  store i64 %result, i64 addrspace(1)* %gep.out
  ret void
}

define amdgpu_kernel void @s_shl_constant_i64(i64 addrspace(1)* %out, i64 %a) {
; SI-LABEL: s_shl_constant_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s9, 0xffff
; SI-NEXT:    s_mov_b32 s8, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_lshl_b64 s[0:1], s[8:9], s2
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_constant_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s9, 0xffff
; VI-NEXT:    s_mov_b32 s8, s6
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_lshl_b64 s[0:1], s[8:9], s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_constant_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 12, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     AND_INT T0.Z, KC0[2].W, literal.x,
; EG-NEXT:     MOV T0.W, literal.y,
; EG-NEXT:     NOT_INT * T1.W, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), -1(nan)
; EG-NEXT:     BIT_ALIGN_INT T1.Z, literal.x, PV.W, PS,
; EG-NEXT:     LSHL T0.W, literal.y, PV.Z,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.z,
; EG-NEXT:    32767(4.591635e-41), -1(nan)
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.Z, PV.W,
; EG-NEXT:     CNDE_INT T0.X, T1.W, T0.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 281474976710655, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @v_shl_constant_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr) {
; SI-LABEL: v_shl_constant_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s2, 0xab19b207
; SI-NEXT:    s_movk_i32 s3, 0x11e
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshl_b64 v[0:1], s[2:3], v0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_shl_constant_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_mov_b32 s0, 0xab19b207
; VI-NEXT:    s_movk_i32 s1, 0x11e
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_shl_constant_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 12, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     NOT_INT T0.Z, T0.X,
; EG-NEXT:     MOV T0.W, literal.x,
; EG-NEXT:     AND_INT * T1.W, T0.X, literal.y,
; EG-NEXT:    1435293955(1.935796e+13), 31(4.344025e-44)
; EG-NEXT:     LSHL T1.Z, literal.x, PS,
; EG-NEXT:     BIT_ALIGN_INT T0.W, literal.y, PV.W, PV.Z,
; EG-NEXT:     AND_INT * T1.W, T0.X, literal.z,
; EG-NEXT:    -1424379385(-5.460358e-13), 143(2.003857e-43)
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, PV.Z,
; EG-NEXT:     CNDE_INT T0.X, T1.W, T1.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %a = load i64, i64 addrspace(1)* %aptr, align 8
  %shl = shl i64 1231231234567, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @v_shl_i64_32_bit_constant(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr) {
; SI-LABEL: v_shl_i64_32_bit_constant:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b64 s[2:3], 0x12d687
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshl_b64 v[0:1], s[2:3], v0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_shl_i64_32_bit_constant:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_mov_b64 s[0:1], 0x12d687
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_shl_i64_32_bit_constant:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 11, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     AND_INT T0.W, T0.X, literal.x,
; EG-NEXT:     NOT_INT * T1.W, T0.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T0.Z, 0.0, literal.x, PS,
; EG-NEXT:     LSHL T0.W, literal.y, PV.W,
; EG-NEXT:     AND_INT * T1.W, T0.X, literal.z,
; EG-NEXT:    617283(8.649977e-40), 1234567(1.729997e-39)
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.Z, PV.W,
; EG-NEXT:     CNDE_INT T0.X, T1.W, T0.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %a = load i64, i64 addrspace(1)* %aptr, align 8
  %shl = shl i64 1234567, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @v_shl_inline_imm_64_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr) {
; SI-LABEL: v_shl_inline_imm_64_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshl_b64 v[0:1], 64, v0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_shl_inline_imm_64_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s4, s[2:3], 0x0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], 64, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_shl_inline_imm_64_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 10, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     AND_INT T0.W, T0.X, literal.x,
; EG-NEXT:     NOT_INT * T1.W, T0.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T0.Z, 0.0, literal.x, PS,
; EG-NEXT:     LSHL T0.W, literal.y, PV.W,
; EG-NEXT:     AND_INT * T1.W, T0.X, literal.x,
; EG-NEXT:    32(4.484155e-44), 64(8.968310e-44)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.Z, PV.W,
; EG-NEXT:     CNDE_INT T0.X, T1.W, T0.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %a = load i64, i64 addrspace(1)* %aptr, align 8
  %shl = shl i64 64, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_64_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_imm_64_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[4:5], 64, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_imm_64_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], 64, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_64_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 10, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     NOT_INT T0.W, KC0[2].W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.Z, literal.x, PS,
; EG-NEXT:     BIT_ALIGN_INT T0.W, 0.0, literal.y, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    64(8.968310e-44), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, PV.Z,
; EG-NEXT:     CNDE_INT T0.X, T1.W, T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 64, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_1_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_imm_1_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[4:5], 1, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_imm_1_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], 1, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_1_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 11, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     AND_INT T0.W, KC0[2].W, literal.x,
; EG-NEXT:     LSHL * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    31(4.344025e-44), 26(3.643376e-44)
; EG-NEXT:     ASHR T1.W, PS, literal.x,
; EG-NEXT:     LSHL * T0.W, 1, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.Y, PV.W, PS,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, PV.W, T0.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 1, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_1_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_imm_1_0_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[4:5], 1.0, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_imm_1_0_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], 1.0, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_1_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     NOT_INT * T0.W, KC0[2].W,
; EG-NEXT:     BIT_ALIGN_INT T0.W, literal.x, 0.0, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    536346624(1.050321e-19), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 4607182418800017408, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_neg_1_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_imm_neg_1_0_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[4:5], -1.0, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_imm_neg_1_0_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], -1.0, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_neg_1_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     NOT_INT * T0.W, KC0[2].W,
; EG-NEXT:     BIT_ALIGN_INT T0.W, literal.x, 0.0, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    1610088448(3.574057e+19), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 13830554455654793216, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_0_5_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_imm_0_5_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[4:5], 0.5, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_imm_0_5_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], 0.5, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_0_5_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     NOT_INT * T0.W, KC0[2].W,
; EG-NEXT:     BIT_ALIGN_INT T0.W, literal.x, 0.0, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    535822336(1.016440e-19), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 4602678819172646912, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_neg_0_5_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_imm_neg_0_5_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[4:5], -0.5, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_imm_neg_0_5_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], -0.5, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_neg_0_5_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     NOT_INT * T0.W, KC0[2].W,
; EG-NEXT:     BIT_ALIGN_INT T0.W, literal.x, 0.0, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    1609564160(3.458765e+19), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 13826050856027422720, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_2_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_imm_2_0_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[4:5], 2.0, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_imm_2_0_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], 2.0, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_2_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     NOT_INT * T0.W, KC0[2].W,
; EG-NEXT:     BIT_ALIGN_INT T0.W, literal.x, 0.0, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    536870912(1.084202e-19), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 4611686018427387904, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_neg_2_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_imm_neg_2_0_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[4:5], -2.0, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_imm_neg_2_0_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], -2.0, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_neg_2_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     NOT_INT * T0.W, KC0[2].W,
; EG-NEXT:     BIT_ALIGN_INT T0.W, literal.x, 0.0, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    1610612736(3.689349e+19), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 13835058055282163712, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_4_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_imm_4_0_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[4:5], 4.0, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_imm_4_0_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], 4.0, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_4_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     NOT_INT * T0.W, KC0[2].W,
; EG-NEXT:     BIT_ALIGN_INT T0.W, literal.x, 0.0, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    537395200(1.151965e-19), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 4616189618054758400, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_imm_neg_4_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_imm_neg_4_0_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[4:5], -4.0, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_imm_neg_4_0_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], -4.0, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_neg_4_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     NOT_INT * T0.W, KC0[2].W,
; EG-NEXT:     BIT_ALIGN_INT T0.W, literal.x, 0.0, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    1611137024(3.919933e+19), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 13839561654909534208, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}


; Test with the 64-bit integer bitpattern for a 32-bit float in the
; low 32-bits, which is not a valid 64-bit inline immmediate.
define amdgpu_kernel void @s_shl_inline_imm_f32_4_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_imm_f32_4_0_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xd
; SI-NEXT:    s_mov_b64 s[0:1], 0x40800000
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_imm_f32_4_0_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s2, s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[0:1], 0x40800000
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_f32_4_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 11, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     NOT_INT T0.W, KC0[2].W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.Z, literal.x, PS,
; EG-NEXT:     BIT_ALIGN_INT T0.W, 0.0, literal.y, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.z,
; EG-NEXT:    1082130432(4.000000e+00), 541065216(1.626303e-19)
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, PV.Z,
; EG-NEXT:     CNDE_INT T0.X, T1.W, T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 1082130432, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

; FIXME: Copy of -1 register
define amdgpu_kernel void @s_shl_inline_imm_f32_neg_4_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_imm_f32_neg_4_0_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s0, -4.0
; SI-NEXT:    s_mov_b32 s1, s6
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_imm_f32_neg_4_0_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s2, s[0:1], 0x34
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s0, -4.0
; VI-NEXT:    s_mov_b32 s1, s6
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_imm_f32_neg_4_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 12, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     AND_INT T0.Z, KC0[2].W, literal.x,
; EG-NEXT:     MOV T0.W, literal.y,
; EG-NEXT:     NOT_INT * T1.W, KC0[2].W,
; EG-NEXT:    31(4.344025e-44), -532676608(-5.534023e+19)
; EG-NEXT:     BIT_ALIGN_INT T1.Z, literal.x, PV.W, PS,
; EG-NEXT:     LSHL T0.W, literal.y, PV.Z,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.z,
; EG-NEXT:    2147483647(nan), -1065353216(-4.000000e+00)
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.Z, PV.W,
; EG-NEXT:     CNDE_INT T0.X, T1.W, T0.W, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 -1065353216, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_high_imm_f32_4_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_high_imm_f32_4_0_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s0, 0
; SI-NEXT:    s_mov_b32 s1, 4.0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_high_imm_f32_4_0_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s2, s[0:1], 0x34
; VI-NEXT:    s_mov_b32 s0, 0
; VI-NEXT:    s_mov_b32 s1, 4.0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_high_imm_f32_4_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     NOT_INT * T0.W, KC0[2].W,
; EG-NEXT:     BIT_ALIGN_INT T0.W, literal.x, 0.0, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    541065216(1.626303e-19), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 4647714815446351872, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @s_shl_inline_high_imm_f32_neg_4_0_i64(i64 addrspace(1)* %out, i64 addrspace(1)* %aptr, i64 %a) {
; SI-LABEL: s_shl_inline_high_imm_f32_neg_4_0_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s0, 0
; SI-NEXT:    s_mov_b32 s1, -4.0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_shl_inline_high_imm_f32_neg_4_0_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s2, s[0:1], 0x34
; VI-NEXT:    s_mov_b32 s0, 0
; VI-NEXT:    s_mov_b32 s1, -4.0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_shl_inline_high_imm_f32_neg_4_0_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     NOT_INT * T0.W, KC0[2].W,
; EG-NEXT:     BIT_ALIGN_INT T0.W, literal.x, 0.0, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].W, literal.y,
; EG-NEXT:    1614807040(5.534023e+19), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT * T0.Y, PS, PV.W, 0.0,
; EG-NEXT:     MOV T0.X, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %shl = shl i64 13871086852301127680, %a
  store i64 %shl, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @test_mul2(i32 %p) {
; SI-LABEL: test_mul2:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s0, s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s0, s0, 1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_mul2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s0, s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s0, s0, 1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; EG-LABEL: test_mul2:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     MOV T0.X, literal.x,
; EG-NEXT:     LSHL * T1.X, KC0[2].Y, 1,
; EG-NEXT:    0(0.000000e+00), 0(0.000000e+00)
   %i = mul i32 %p, 2
   store volatile i32 %i, i32 addrspace(1)* undef
   ret void
}

define void @shl_or_k(i32 addrspace(1)* %out, i32 %in) {
; SI-LABEL: shl_or_k:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 2, v2
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    v_or_b32_e32 v2, 4, v2
; SI-NEXT:    buffer_store_dword v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: shl_or_k:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v2
; VI-NEXT:    v_or_b32_e32 v2, 4, v2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: shl_or_k:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 4, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     LSHL * T0.W, KC0[2].Z, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     OR_INT T0.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    4(5.605194e-45), 2(2.802597e-45)
  %tmp0 = or i32 %in, 1
  %tmp2 = shl i32 %tmp0, 2
  store i32 %tmp2, i32 addrspace(1)* %out
  ret void
}

define void @shl_or_k_two_uses(i32 addrspace(1)* %out0, i32 addrspace(1)* %out1, i32 %in) {
; SI-LABEL: shl_or_k_two_uses:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_or_b32_e32 v4, 1, v4
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    v_lshlrev_b32_e32 v5, 2, v4
; SI-NEXT:    buffer_store_dword v5, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    buffer_store_dword v4, v[2:3], s[4:7], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: shl_or_k_two_uses:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_or_b32_e32 v4, 1, v4
; VI-NEXT:    v_lshlrev_b32_e32 v5, 2, v4
; VI-NEXT:    flat_store_dword v[0:1], v5
; VI-NEXT:    flat_store_dword v[2:3], v4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: shl_or_k_two_uses:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 5, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.X, T3.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     LSHR T0.X, KC0[2].Z, literal.x,
; EG-NEXT:     OR_INT * T1.X, KC0[2].W, 1,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T2.X, PS, literal.x,
; EG-NEXT:     LSHR * T3.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %tmp0 = or i32 %in, 1
  %tmp2 = shl i32 %tmp0, 2
  store i32 %tmp2, i32 addrspace(1)* %out0
  store i32 %tmp0, i32 addrspace(1)* %out1
  ret void
}

attributes #0 = { nounwind readnone }
