; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN:  llc -amdgpu-scalarize-global-loads=false  -march=amdgcn -mcpu=verde -verify-machineinstrs < %s | FileCheck %s -check-prefixes=SI
; RUN:  llc -amdgpu-scalarize-global-loads=false  -march=amdgcn -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs -denormal-fp-math-f32=preserve-sign < %s | FileCheck %s -check-prefixes=VI
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=amdgcn--amdhsa -mcpu=fiji -denormal-fp-math-f32=ieee < %s | FileCheck %s -check-prefixes=GCN
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=amdgcn--amdhsa -mcpu=gfx1030 -denormal-fp-math-f32=ieee < %s | FileCheck %s -check-prefixes=GFX1030
; RUN:  llc -amdgpu-scalarize-global-loads=false  -march=r600 -mcpu=redwood < %s | FileCheck %s -check-prefixes=EG

define amdgpu_kernel void @udiv_i32(i32 addrspace(1)* %out, i32 addrspace(1)* %in) {
; SI-LABEL: udiv_i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_u32_e32 v2, v1
; SI-NEXT:    v_sub_i32_e32 v3, vcc, 0, v1
; SI-NEXT:    v_rcp_iflag_f32_e32 v2, v2
; SI-NEXT:    v_mul_f32_e32 v2, 0x4f7ffffe, v2
; SI-NEXT:    v_cvt_u32_f32_e32 v2, v2
; SI-NEXT:    v_mul_lo_u32 v3, v3, v2
; SI-NEXT:    v_mul_hi_u32 v3, v2, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; SI-NEXT:    v_mul_hi_u32 v2, v0, v2
; SI-NEXT:    v_mul_lo_u32 v3, v2, v1
; SI-NEXT:    v_add_i32_e32 v4, vcc, 1, v2
; SI-NEXT:    v_subrev_i32_e32 v0, vcc, v3, v0
; SI-NEXT:    v_cmp_ge_u32_e64 s[0:1], v0, v1
; SI-NEXT:    v_cndmask_b32_e64 v2, v2, v4, s[0:1]
; SI-NEXT:    v_subrev_i32_e32 v3, vcc, v1, v0
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; SI-NEXT:    v_add_i32_e32 v3, vcc, 1, v2
; SI-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v1
; SI-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: udiv_i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_u32_e32 v2, v1
; VI-NEXT:    v_sub_u32_e32 v3, vcc, 0, v1
; VI-NEXT:    v_rcp_iflag_f32_e32 v2, v2
; VI-NEXT:    v_mul_f32_e32 v2, 0x4f7ffffe, v2
; VI-NEXT:    v_cvt_u32_f32_e32 v2, v2
; VI-NEXT:    v_mul_lo_u32 v3, v3, v2
; VI-NEXT:    v_mul_hi_u32 v3, v2, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, v3, v2
; VI-NEXT:    v_mul_hi_u32 v2, v0, v2
; VI-NEXT:    v_mul_lo_u32 v3, v2, v1
; VI-NEXT:    v_add_u32_e32 v4, vcc, 1, v2
; VI-NEXT:    v_subrev_u32_e32 v0, vcc, v3, v0
; VI-NEXT:    v_cmp_ge_u32_e64 s[0:1], v0, v1
; VI-NEXT:    v_cndmask_b32_e64 v2, v2, v4, s[0:1]
; VI-NEXT:    v_subrev_u32_e32 v3, vcc, v1, v0
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; VI-NEXT:    v_add_u32_e32 v3, vcc, 1, v2
; VI-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v1
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: udiv_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_cvt_f32_u32_e32 v2, v1
; GCN-NEXT:    v_sub_u32_e32 v3, vcc, 0, v1
; GCN-NEXT:    v_rcp_iflag_f32_e32 v2, v2
; GCN-NEXT:    v_mul_f32_e32 v2, 0x4f7ffffe, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v2, v2
; GCN-NEXT:    v_mul_lo_u32 v3, v3, v2
; GCN-NEXT:    v_mul_hi_u32 v3, v2, v3
; GCN-NEXT:    v_add_u32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_mul_hi_u32 v4, v0, v2
; GCN-NEXT:    v_mov_b32_e32 v2, s0
; GCN-NEXT:    v_mov_b32_e32 v3, s1
; GCN-NEXT:    v_mul_lo_u32 v5, v4, v1
; GCN-NEXT:    v_add_u32_e32 v6, vcc, 1, v4
; GCN-NEXT:    v_subrev_u32_e32 v0, vcc, v5, v0
; GCN-NEXT:    v_cmp_ge_u32_e64 s[0:1], v0, v1
; GCN-NEXT:    v_cndmask_b32_e64 v4, v4, v6, s[0:1]
; GCN-NEXT:    v_subrev_u32_e32 v5, vcc, v1, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[0:1]
; GCN-NEXT:    v_add_u32_e32 v5, vcc, 1, v4
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GCN-NEXT:    flat_store_dword v[2:3], v0
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: udiv_i32:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX1030-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v3, v1
; GFX1030-NEXT:    v_sub_nc_u32_e32 v4, 0, v1
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v3, v3
; GFX1030-NEXT:    v_mul_f32_e32 v3, 0x4f7ffffe, v3
; GFX1030-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GFX1030-NEXT:    v_mul_lo_u32 v4, v4, v3
; GFX1030-NEXT:    v_mul_hi_u32 v4, v3, v4
; GFX1030-NEXT:    v_add_nc_u32_e32 v3, v3, v4
; GFX1030-NEXT:    v_mul_hi_u32 v3, v0, v3
; GFX1030-NEXT:    v_mul_lo_u32 v4, v3, v1
; GFX1030-NEXT:    v_sub_nc_u32_e32 v0, v0, v4
; GFX1030-NEXT:    v_add_nc_u32_e32 v4, 1, v3
; GFX1030-NEXT:    v_sub_nc_u32_e32 v5, v0, v1
; GFX1030-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v0, v1
; GFX1030-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc_lo
; GFX1030-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc_lo
; GFX1030-NEXT:    v_add_nc_u32_e32 v4, 1, v3
; GFX1030-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v0, v1
; GFX1030-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc_lo
; GFX1030-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: udiv_i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 17, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     SUB_INT T0.W, 0.0, T0.Y,
; EG-NEXT:     RECIP_UINT * T0.Z, T0.Y,
; EG-NEXT:     MULLO_INT * T0.W, PV.W, PS,
; EG-NEXT:     MULHI * T0.W, T0.Z, PS,
; EG-NEXT:     ADD_INT * T0.W, T0.Z, PS,
; EG-NEXT:     MULHI * T0.Z, T0.X, PV.W,
; EG-NEXT:     MULLO_INT * T0.W, PS, T0.Y,
; EG-NEXT:     SUB_INT * T0.W, T0.X, PS,
; EG-NEXT:     ADD_INT T1.Z, T0.Z, 1,
; EG-NEXT:     SETGE_UINT T1.W, PV.W, T0.Y,
; EG-NEXT:     SUB_INT * T2.W, PV.W, T0.Y,
; EG-NEXT:     CNDE_INT T0.W, PV.W, T0.W, PS,
; EG-NEXT:     CNDE_INT * T1.W, PV.W, T0.Z, PV.Z,
; EG-NEXT:     ADD_INT T2.W, PS, 1,
; EG-NEXT:     SETGE_UINT * T0.W, PV.W, T0.Y,
; EG-NEXT:     CNDE_INT T0.X, PS, T1.W, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr i32, i32 addrspace(1)* %in, i32 1
  %a = load i32, i32 addrspace(1)* %in
  %b = load i32, i32 addrspace(1)* %b_ptr
  %result = udiv i32 %a, %b
  store i32 %result, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @s_udiv_i32(i32 addrspace(1)* %out, i32 %a, i32 %b) {
; SI-LABEL: s_udiv_i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xb
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_cvt_f32_u32_e32 v0, s3
; SI-NEXT:    s_sub_i32 s4, 0, s3
; SI-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; SI-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; SI-NEXT:    v_cvt_u32_f32_e32 v0, v0
; SI-NEXT:    v_mul_lo_u32 v1, s4, v0
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    v_mul_hi_u32 v1, v0, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, v1, v0
; SI-NEXT:    v_mul_hi_u32 v0, s2, v0
; SI-NEXT:    v_mul_lo_u32 v1, v0, s3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 1, v0
; SI-NEXT:    v_sub_i32_e32 v1, vcc, s2, v1
; SI-NEXT:    v_cmp_le_u32_e64 s[0:1], s3, v1
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; SI-NEXT:    v_subrev_i32_e32 v2, vcc, s3, v1
; SI-NEXT:    v_cndmask_b32_e64 v1, v1, v2, s[0:1]
; SI-NEXT:    v_add_i32_e32 v2, vcc, 1, v0
; SI-NEXT:    v_cmp_le_u32_e32 vcc, s3, v1
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_udiv_i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x2c
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_u32_e32 v0, s3
; VI-NEXT:    s_sub_i32 s4, 0, s3
; VI-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; VI-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; VI-NEXT:    v_cvt_u32_f32_e32 v0, v0
; VI-NEXT:    v_mul_lo_u32 v1, s4, v0
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    v_mul_hi_u32 v1, v0, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, v1, v0
; VI-NEXT:    v_mul_hi_u32 v0, s2, v0
; VI-NEXT:    v_mul_lo_u32 v1, v0, s3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 1, v0
; VI-NEXT:    v_sub_u32_e32 v1, vcc, s2, v1
; VI-NEXT:    v_cmp_le_u32_e64 s[0:1], s3, v1
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; VI-NEXT:    v_subrev_u32_e32 v2, vcc, s3, v1
; VI-NEXT:    v_cndmask_b32_e64 v1, v1, v2, s[0:1]
; VI-NEXT:    v_add_u32_e32 v2, vcc, 1, v0
; VI-NEXT:    v_cmp_le_u32_e32 vcc, s3, v1
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: s_udiv_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x8
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s3
; GCN-NEXT:    s_sub_i32 s0, 0, s3
; GCN-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GCN-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_mul_lo_u32 v1, s0, v0
; GCN-NEXT:    v_mul_hi_u32 v1, v0, v1
; GCN-NEXT:    v_add_u32_e32 v0, vcc, v1, v0
; GCN-NEXT:    v_mul_hi_u32 v0, s2, v0
; GCN-NEXT:    v_mul_lo_u32 v1, v0, s3
; GCN-NEXT:    v_add_u32_e32 v2, vcc, 1, v0
; GCN-NEXT:    v_sub_u32_e32 v1, vcc, s2, v1
; GCN-NEXT:    v_cmp_le_u32_e64 s[0:1], s3, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GCN-NEXT:    v_subrev_u32_e32 v2, vcc, s3, v1
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, v2, s[0:1]
; GCN-NEXT:    v_add_u32_e32 v2, vcc, 1, v0
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s3, v1
; GCN-NEXT:    v_cndmask_b32_e32 v2, v0, v2, vcc
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: s_udiv_i32:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v0, s1
; GFX1030-NEXT:    s_sub_i32 s2, 0, s1
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GFX1030-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GFX1030-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GFX1030-NEXT:    v_mul_lo_u32 v1, s2, v0
; GFX1030-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX1030-NEXT:    v_mul_hi_u32 v1, v0, v1
; GFX1030-NEXT:    v_add_nc_u32_e32 v0, v0, v1
; GFX1030-NEXT:    v_mul_hi_u32 v0, s0, v0
; GFX1030-NEXT:    v_mul_lo_u32 v1, v0, s1
; GFX1030-NEXT:    v_add_nc_u32_e32 v2, 1, v0
; GFX1030-NEXT:    v_sub_nc_u32_e32 v1, s0, v1
; GFX1030-NEXT:    v_subrev_nc_u32_e32 v3, s1, v1
; GFX1030-NEXT:    v_cmp_le_u32_e32 vcc_lo, s1, v1
; GFX1030-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX1030-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX1030-NEXT:    v_mov_b32_e32 v3, 0
; GFX1030-NEXT:    v_add_nc_u32_e32 v2, 1, v0
; GFX1030-NEXT:    v_cmp_le_u32_e32 vcc_lo, s1, v1
; GFX1030-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    global_store_dword v3, v0, s[2:3]
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: s_udiv_i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 17, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     SUB_INT T0.W, 0.0, KC0[2].W,
; EG-NEXT:     RECIP_UINT * T0.X, KC0[2].W,
; EG-NEXT:     MULLO_INT * T0.Y, PV.W, PS,
; EG-NEXT:     MULHI * T0.Y, T0.X, PS,
; EG-NEXT:     ADD_INT * T0.W, T0.X, PS,
; EG-NEXT:     MULHI * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:     MULLO_INT * T0.Y, PS, KC0[2].W,
; EG-NEXT:     SUB_INT * T0.W, KC0[2].Z, PS,
; EG-NEXT:     SUB_INT T0.Z, PV.W, KC0[2].W,
; EG-NEXT:     SETGE_UINT T1.W, PV.W, KC0[2].W,
; EG-NEXT:     ADD_INT * T2.W, T0.X, 1,
; EG-NEXT:     CNDE_INT T2.W, PV.W, T0.X, PS,
; EG-NEXT:     CNDE_INT * T0.W, PV.W, T0.W, PV.Z,
; EG-NEXT:     SETGE_UINT T0.W, PS, KC0[2].W,
; EG-NEXT:     ADD_INT * T1.W, PV.W, 1,
; EG-NEXT:     CNDE_INT T0.X, PV.W, T2.W, PS,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %result = udiv i32 %a, %b
  store i32 %result, i32 addrspace(1)* %out
  ret void
}


; The code generated by udiv is long and complex and may frequently
; change. The goal of this test is to make sure the ISel doesn't fail
; when it gets a v4i32 udiv
define amdgpu_kernel void @udiv_v2i32(<2 x i32> addrspace(1)* %out, <2 x i32> addrspace(1)* %in) {
; SI-LABEL: udiv_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s2, 0x4f7ffffe
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_u32_e32 v4, v2
; SI-NEXT:    v_cvt_f32_u32_e32 v5, v3
; SI-NEXT:    v_sub_i32_e32 v6, vcc, 0, v2
; SI-NEXT:    v_rcp_iflag_f32_e32 v4, v4
; SI-NEXT:    v_rcp_iflag_f32_e32 v5, v5
; SI-NEXT:    v_sub_i32_e32 v7, vcc, 0, v3
; SI-NEXT:    v_mul_f32_e32 v4, s2, v4
; SI-NEXT:    v_mul_f32_e32 v5, s2, v5
; SI-NEXT:    v_cvt_u32_f32_e32 v4, v4
; SI-NEXT:    v_cvt_u32_f32_e32 v5, v5
; SI-NEXT:    v_mul_lo_u32 v6, v6, v4
; SI-NEXT:    v_mul_lo_u32 v7, v7, v5
; SI-NEXT:    v_mul_hi_u32 v6, v4, v6
; SI-NEXT:    v_mul_hi_u32 v7, v5, v7
; SI-NEXT:    v_add_i32_e32 v4, vcc, v6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, v7, v5
; SI-NEXT:    v_mul_hi_u32 v4, v0, v4
; SI-NEXT:    v_mul_hi_u32 v5, v1, v5
; SI-NEXT:    v_mul_lo_u32 v6, v4, v2
; SI-NEXT:    v_mul_lo_u32 v8, v5, v3
; SI-NEXT:    v_add_i32_e32 v7, vcc, 1, v4
; SI-NEXT:    v_subrev_i32_e32 v0, vcc, v6, v0
; SI-NEXT:    v_subrev_i32_e32 v1, vcc, v8, v1
; SI-NEXT:    v_add_i32_e32 v9, vcc, 1, v5
; SI-NEXT:    v_cmp_ge_u32_e64 s[0:1], v0, v2
; SI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v1, v3
; SI-NEXT:    v_cndmask_b32_e64 v4, v4, v7, s[0:1]
; SI-NEXT:    v_subrev_i32_e32 v6, vcc, v2, v0
; SI-NEXT:    v_cndmask_b32_e64 v5, v5, v9, s[2:3]
; SI-NEXT:    v_subrev_i32_e32 v7, vcc, v3, v1
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[0:1]
; SI-NEXT:    v_add_i32_e32 v6, vcc, 1, v4
; SI-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s[2:3]
; SI-NEXT:    v_add_i32_e32 v7, vcc, 1, v5
; SI-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; SI-NEXT:    v_cndmask_b32_e32 v0, v4, v6, vcc
; SI-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v3
; SI-NEXT:    v_cndmask_b32_e32 v1, v5, v7, vcc
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: udiv_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s2, 0x4f7ffffe
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_u32_e32 v4, v2
; VI-NEXT:    v_cvt_f32_u32_e32 v5, v3
; VI-NEXT:    v_sub_u32_e32 v6, vcc, 0, v2
; VI-NEXT:    v_rcp_iflag_f32_e32 v4, v4
; VI-NEXT:    v_rcp_iflag_f32_e32 v5, v5
; VI-NEXT:    v_sub_u32_e32 v7, vcc, 0, v3
; VI-NEXT:    v_mul_f32_e32 v4, s2, v4
; VI-NEXT:    v_mul_f32_e32 v5, s2, v5
; VI-NEXT:    v_cvt_u32_f32_e32 v4, v4
; VI-NEXT:    v_cvt_u32_f32_e32 v5, v5
; VI-NEXT:    v_mul_lo_u32 v6, v6, v4
; VI-NEXT:    v_mul_lo_u32 v7, v7, v5
; VI-NEXT:    v_mul_hi_u32 v6, v4, v6
; VI-NEXT:    v_mul_hi_u32 v7, v5, v7
; VI-NEXT:    v_add_u32_e32 v4, vcc, v6, v4
; VI-NEXT:    v_add_u32_e32 v5, vcc, v7, v5
; VI-NEXT:    v_mul_hi_u32 v4, v0, v4
; VI-NEXT:    v_mul_hi_u32 v5, v1, v5
; VI-NEXT:    v_mul_lo_u32 v6, v4, v2
; VI-NEXT:    v_mul_lo_u32 v8, v5, v3
; VI-NEXT:    v_add_u32_e32 v7, vcc, 1, v4
; VI-NEXT:    v_subrev_u32_e32 v0, vcc, v6, v0
; VI-NEXT:    v_subrev_u32_e32 v1, vcc, v8, v1
; VI-NEXT:    v_add_u32_e32 v9, vcc, 1, v5
; VI-NEXT:    v_cmp_ge_u32_e64 s[0:1], v0, v2
; VI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v1, v3
; VI-NEXT:    v_cndmask_b32_e64 v4, v4, v7, s[0:1]
; VI-NEXT:    v_subrev_u32_e32 v6, vcc, v2, v0
; VI-NEXT:    v_cndmask_b32_e64 v5, v5, v9, s[2:3]
; VI-NEXT:    v_subrev_u32_e32 v7, vcc, v3, v1
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[0:1]
; VI-NEXT:    v_add_u32_e32 v6, vcc, 1, v4
; VI-NEXT:    v_cndmask_b32_e64 v1, v1, v7, s[2:3]
; VI-NEXT:    v_add_u32_e32 v7, vcc, 1, v5
; VI-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v6, vcc
; VI-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v3
; VI-NEXT:    v_cndmask_b32_e32 v1, v5, v7, vcc
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: udiv_v2i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCN-NEXT:    s_mov_b32 s2, 0x4f7ffffe
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_cvt_f32_u32_e32 v4, v2
; GCN-NEXT:    v_cvt_f32_u32_e32 v5, v3
; GCN-NEXT:    v_rcp_iflag_f32_e32 v4, v4
; GCN-NEXT:    v_rcp_iflag_f32_e32 v5, v5
; GCN-NEXT:    v_mul_f32_e32 v4, s2, v4
; GCN-NEXT:    v_cvt_u32_f32_e32 v6, v4
; GCN-NEXT:    v_mul_f32_e32 v5, s2, v5
; GCN-NEXT:    v_cvt_u32_f32_e32 v7, v5
; GCN-NEXT:    v_sub_u32_e32 v4, vcc, 0, v2
; GCN-NEXT:    v_mul_lo_u32 v5, v4, v6
; GCN-NEXT:    v_sub_u32_e32 v4, vcc, 0, v3
; GCN-NEXT:    v_mul_lo_u32 v8, v4, v7
; GCN-NEXT:    v_mul_hi_u32 v9, v6, v5
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    v_mov_b32_e32 v5, s1
; GCN-NEXT:    v_mul_hi_u32 v8, v7, v8
; GCN-NEXT:    v_add_u32_e32 v6, vcc, v9, v6
; GCN-NEXT:    v_mul_hi_u32 v6, v0, v6
; GCN-NEXT:    v_add_u32_e32 v7, vcc, v8, v7
; GCN-NEXT:    v_mul_hi_u32 v7, v1, v7
; GCN-NEXT:    v_mul_lo_u32 v8, v6, v2
; GCN-NEXT:    v_add_u32_e32 v9, vcc, 1, v6
; GCN-NEXT:    v_mul_lo_u32 v10, v7, v3
; GCN-NEXT:    v_subrev_u32_e32 v0, vcc, v8, v0
; GCN-NEXT:    v_add_u32_e32 v11, vcc, 1, v7
; GCN-NEXT:    v_subrev_u32_e32 v1, vcc, v10, v1
; GCN-NEXT:    v_cmp_ge_u32_e64 s[0:1], v0, v2
; GCN-NEXT:    v_cmp_ge_u32_e64 s[2:3], v1, v3
; GCN-NEXT:    v_cndmask_b32_e64 v6, v6, v9, s[0:1]
; GCN-NEXT:    v_subrev_u32_e32 v8, vcc, v2, v0
; GCN-NEXT:    v_cndmask_b32_e64 v7, v7, v11, s[2:3]
; GCN-NEXT:    v_subrev_u32_e32 v9, vcc, v3, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, v8, s[0:1]
; GCN-NEXT:    v_add_u32_e32 v8, vcc, 1, v6
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, v9, s[2:3]
; GCN-NEXT:    v_add_u32_e32 v9, vcc, 1, v7
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; GCN-NEXT:    v_cndmask_b32_e32 v0, v6, v8, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v3
; GCN-NEXT:    v_cndmask_b32_e32 v1, v7, v9, vcc
; GCN-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: udiv_v2i32:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x0
; GFX1030-NEXT:    v_mov_b32_e32 v4, 0
; GFX1030-NEXT:    s_mov_b32 s0, 0x4f7ffffe
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    global_load_dwordx4 v[0:3], v4, s[6:7]
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v5, v2
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v6, v3
; GFX1030-NEXT:    v_sub_nc_u32_e32 v7, 0, v2
; GFX1030-NEXT:    v_sub_nc_u32_e32 v8, 0, v3
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v5, v5
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v6, v6
; GFX1030-NEXT:    v_mul_f32_e32 v5, s0, v5
; GFX1030-NEXT:    v_mul_f32_e32 v6, s0, v6
; GFX1030-NEXT:    v_cvt_u32_f32_e32 v5, v5
; GFX1030-NEXT:    v_cvt_u32_f32_e32 v6, v6
; GFX1030-NEXT:    v_mul_lo_u32 v7, v7, v5
; GFX1030-NEXT:    v_mul_lo_u32 v8, v8, v6
; GFX1030-NEXT:    v_mul_hi_u32 v7, v5, v7
; GFX1030-NEXT:    v_mul_hi_u32 v8, v6, v8
; GFX1030-NEXT:    v_add_nc_u32_e32 v5, v5, v7
; GFX1030-NEXT:    v_add_nc_u32_e32 v6, v6, v8
; GFX1030-NEXT:    v_mul_hi_u32 v5, v0, v5
; GFX1030-NEXT:    v_mul_hi_u32 v6, v1, v6
; GFX1030-NEXT:    v_mul_lo_u32 v7, v5, v2
; GFX1030-NEXT:    v_mul_lo_u32 v8, v6, v3
; GFX1030-NEXT:    v_sub_nc_u32_e32 v0, v0, v7
; GFX1030-NEXT:    v_add_nc_u32_e32 v7, 1, v5
; GFX1030-NEXT:    v_sub_nc_u32_e32 v1, v1, v8
; GFX1030-NEXT:    v_add_nc_u32_e32 v8, 1, v6
; GFX1030-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v0, v2
; GFX1030-NEXT:    v_sub_nc_u32_e32 v9, v1, v3
; GFX1030-NEXT:    v_cmp_ge_u32_e64 s0, v1, v3
; GFX1030-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc_lo
; GFX1030-NEXT:    v_sub_nc_u32_e32 v7, v0, v2
; GFX1030-NEXT:    v_cndmask_b32_e64 v6, v6, v8, s0
; GFX1030-NEXT:    v_cndmask_b32_e64 v1, v1, v9, s0
; GFX1030-NEXT:    v_cndmask_b32_e32 v0, v0, v7, vcc_lo
; GFX1030-NEXT:    v_add_nc_u32_e32 v7, 1, v5
; GFX1030-NEXT:    v_add_nc_u32_e32 v8, 1, v6
; GFX1030-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v0, v2
; GFX1030-NEXT:    v_cndmask_b32_e32 v0, v5, v7, vcc_lo
; GFX1030-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v1, v3
; GFX1030-NEXT:    v_cndmask_b32_e32 v1, v6, v8, vcc_lo
; GFX1030-NEXT:    global_store_dwordx2 v4, v[0:1], s[4:5]
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: udiv_v2i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 33, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XY, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     SUB_INT T1.W, 0.0, T0.W,
; EG-NEXT:     RECIP_UINT * T1.X, T0.W,
; EG-NEXT:     MULLO_INT * T1.Y, PV.W, PS,
; EG-NEXT:     SUB_INT T1.W, 0.0, T0.Z,
; EG-NEXT:     RECIP_UINT * T1.Z, T0.Z,
; EG-NEXT:     MULLO_INT * T1.W, PV.W, PS,
; EG-NEXT:     MULHI * T1.W, T1.Z, PS,
; EG-NEXT:     ADD_INT T1.W, T1.Z, PS,
; EG-NEXT:     MULHI * T1.Y, T1.X, T1.Y,
; EG-NEXT:     ADD_INT T2.W, T1.X, PS,
; EG-NEXT:     MULHI * T1.X, T0.X, PV.W,
; EG-NEXT:     MULHI * T1.Y, T0.Y, PV.W,
; EG-NEXT:     MULLO_INT * T1.Z, PS, T0.W,
; EG-NEXT:     SUB_INT T1.W, T0.Y, PS,
; EG-NEXT:     MULLO_INT * T0.Y, T1.X, T0.Z,
; EG-NEXT:     SUB_INT T0.Y, T0.X, PS,
; EG-NEXT:     ADD_INT T1.Z, T1.Y, 1,
; EG-NEXT:     SETGE_UINT T2.W, PV.W, T0.W,
; EG-NEXT:     SUB_INT * T3.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.X, PV.W, T1.W, PS,
; EG-NEXT:     CNDE_INT T1.Y, PV.W, T1.Y, PV.Z,
; EG-NEXT:     ADD_INT T1.Z, T1.X, 1,
; EG-NEXT:     SETGE_UINT T1.W, PV.Y, T0.Z,
; EG-NEXT:     SUB_INT * T2.W, PV.Y, T0.Z,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, T0.Y, PS,
; EG-NEXT:     CNDE_INT T1.Z, PV.W, T1.X, PV.Z,
; EG-NEXT:     ADD_INT T1.W, PV.Y, 1,
; EG-NEXT:     SETGE_UINT * T0.W, PV.X, T0.W,
; EG-NEXT:     CNDE_INT T1.Y, PS, T1.Y, PV.W,
; EG-NEXT:     ADD_INT T0.W, PV.Z, 1,
; EG-NEXT:     SETGE_UINT * T1.W, PV.Y, T0.Z,
; EG-NEXT:     CNDE_INT T1.X, PS, T1.Z, PV.W,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <2 x i32>, <2 x i32> addrspace(1)* %in, i32 1
  %a = load <2 x i32>, <2 x i32> addrspace(1) * %in
  %b = load <2 x i32>, <2 x i32> addrspace(1) * %b_ptr
  %result = udiv <2 x i32> %a, %b
  store <2 x i32> %result, <2 x i32> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @udiv_v4i32(<4 x i32> addrspace(1)* %out, <4 x i32> addrspace(1)* %in) {
; SI-LABEL: udiv_v4i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s6, s10
; SI-NEXT:    s_mov_b32 s7, s11
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s2
; SI-NEXT:    s_mov_b32 s5, s3
; SI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[4:7], 0 offset:16
; SI-NEXT:    buffer_load_dwordx4 v[4:7], off, s[4:7], 0
; SI-NEXT:    s_mov_b32 s2, 0x4f7ffffe
; SI-NEXT:    s_mov_b32 s8, s0
; SI-NEXT:    s_mov_b32 s9, s1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_u32_e32 v8, v0
; SI-NEXT:    v_cvt_f32_u32_e32 v10, v1
; SI-NEXT:    v_cvt_f32_u32_e32 v12, v2
; SI-NEXT:    v_cvt_f32_u32_e32 v14, v3
; SI-NEXT:    v_rcp_iflag_f32_e32 v8, v8
; SI-NEXT:    v_rcp_iflag_f32_e32 v10, v10
; SI-NEXT:    v_rcp_iflag_f32_e32 v12, v12
; SI-NEXT:    v_rcp_iflag_f32_e32 v14, v14
; SI-NEXT:    v_mul_f32_e32 v8, s2, v8
; SI-NEXT:    v_mul_f32_e32 v10, s2, v10
; SI-NEXT:    v_mul_f32_e32 v12, s2, v12
; SI-NEXT:    v_mul_f32_e32 v14, s2, v14
; SI-NEXT:    v_cvt_u32_f32_e32 v8, v8
; SI-NEXT:    v_cvt_u32_f32_e32 v10, v10
; SI-NEXT:    v_cvt_u32_f32_e32 v12, v12
; SI-NEXT:    v_cvt_u32_f32_e32 v14, v14
; SI-NEXT:    v_sub_i32_e32 v9, vcc, 0, v0
; SI-NEXT:    v_sub_i32_e32 v11, vcc, 0, v1
; SI-NEXT:    v_sub_i32_e32 v13, vcc, 0, v2
; SI-NEXT:    v_sub_i32_e32 v15, vcc, 0, v3
; SI-NEXT:    v_mul_lo_u32 v9, v9, v8
; SI-NEXT:    v_mul_lo_u32 v11, v11, v10
; SI-NEXT:    v_mul_lo_u32 v13, v13, v12
; SI-NEXT:    v_mul_lo_u32 v15, v15, v14
; SI-NEXT:    v_mul_hi_u32 v9, v8, v9
; SI-NEXT:    v_mul_hi_u32 v11, v10, v11
; SI-NEXT:    v_mul_hi_u32 v13, v12, v13
; SI-NEXT:    v_mul_hi_u32 v15, v14, v15
; SI-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, v11, v10
; SI-NEXT:    v_add_i32_e32 v10, vcc, v13, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, v15, v14
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_hi_u32 v8, v4, v8
; SI-NEXT:    v_mul_hi_u32 v9, v5, v9
; SI-NEXT:    v_mul_hi_u32 v10, v6, v10
; SI-NEXT:    v_mul_hi_u32 v11, v7, v11
; SI-NEXT:    v_mul_lo_u32 v12, v8, v0
; SI-NEXT:    v_mul_lo_u32 v14, v9, v1
; SI-NEXT:    v_mul_lo_u32 v16, v10, v2
; SI-NEXT:    v_mul_lo_u32 v18, v11, v3
; SI-NEXT:    v_subrev_i32_e32 v4, vcc, v12, v4
; SI-NEXT:    v_subrev_i32_e32 v5, vcc, v14, v5
; SI-NEXT:    v_subrev_i32_e32 v6, vcc, v16, v6
; SI-NEXT:    v_subrev_i32_e32 v7, vcc, v18, v7
; SI-NEXT:    v_add_i32_e32 v13, vcc, 1, v8
; SI-NEXT:    v_add_i32_e32 v15, vcc, 1, v9
; SI-NEXT:    v_add_i32_e32 v17, vcc, 1, v10
; SI-NEXT:    v_add_i32_e32 v19, vcc, 1, v11
; SI-NEXT:    v_cmp_ge_u32_e64 s[0:1], v4, v0
; SI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v5, v1
; SI-NEXT:    v_cmp_ge_u32_e64 s[4:5], v6, v2
; SI-NEXT:    v_cmp_ge_u32_e64 s[6:7], v7, v3
; SI-NEXT:    v_cndmask_b32_e64 v8, v8, v13, s[0:1]
; SI-NEXT:    v_subrev_i32_e32 v12, vcc, v0, v4
; SI-NEXT:    v_cndmask_b32_e64 v9, v9, v15, s[2:3]
; SI-NEXT:    v_subrev_i32_e32 v13, vcc, v1, v5
; SI-NEXT:    v_cndmask_b32_e64 v10, v10, v17, s[4:5]
; SI-NEXT:    v_subrev_i32_e32 v14, vcc, v2, v6
; SI-NEXT:    v_cndmask_b32_e64 v11, v11, v19, s[6:7]
; SI-NEXT:    v_subrev_i32_e32 v15, vcc, v3, v7
; SI-NEXT:    v_cndmask_b32_e64 v4, v4, v12, s[0:1]
; SI-NEXT:    v_add_i32_e32 v12, vcc, 1, v8
; SI-NEXT:    v_cndmask_b32_e64 v5, v5, v13, s[2:3]
; SI-NEXT:    v_add_i32_e32 v13, vcc, 1, v9
; SI-NEXT:    v_cndmask_b32_e64 v6, v6, v14, s[4:5]
; SI-NEXT:    v_add_i32_e32 v14, vcc, 1, v10
; SI-NEXT:    v_cndmask_b32_e64 v7, v7, v15, s[6:7]
; SI-NEXT:    v_add_i32_e32 v15, vcc, 1, v11
; SI-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, v8, v12, vcc
; SI-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v1
; SI-NEXT:    v_cndmask_b32_e32 v1, v9, v13, vcc
; SI-NEXT:    v_cmp_ge_u32_e32 vcc, v6, v2
; SI-NEXT:    v_cndmask_b32_e32 v2, v10, v14, vcc
; SI-NEXT:    v_cmp_ge_u32_e32 vcc, v7, v3
; SI-NEXT:    v_cndmask_b32_e32 v3, v11, v15, vcc
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: udiv_v4i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_mov_b32 s6, s10
; VI-NEXT:    s_mov_b32 s7, s11
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[4:7], 0 offset:16
; VI-NEXT:    buffer_load_dwordx4 v[4:7], off, s[4:7], 0
; VI-NEXT:    s_mov_b32 s2, 0x4f7ffffe
; VI-NEXT:    s_mov_b32 s8, s0
; VI-NEXT:    s_mov_b32 s9, s1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_cvt_f32_u32_e32 v8, v0
; VI-NEXT:    v_cvt_f32_u32_e32 v10, v1
; VI-NEXT:    v_cvt_f32_u32_e32 v12, v2
; VI-NEXT:    v_cvt_f32_u32_e32 v14, v3
; VI-NEXT:    v_rcp_iflag_f32_e32 v8, v8
; VI-NEXT:    v_rcp_iflag_f32_e32 v10, v10
; VI-NEXT:    v_rcp_iflag_f32_e32 v12, v12
; VI-NEXT:    v_rcp_iflag_f32_e32 v14, v14
; VI-NEXT:    v_mul_f32_e32 v8, s2, v8
; VI-NEXT:    v_mul_f32_e32 v10, s2, v10
; VI-NEXT:    v_mul_f32_e32 v12, s2, v12
; VI-NEXT:    v_mul_f32_e32 v14, s2, v14
; VI-NEXT:    v_cvt_u32_f32_e32 v8, v8
; VI-NEXT:    v_cvt_u32_f32_e32 v10, v10
; VI-NEXT:    v_cvt_u32_f32_e32 v12, v12
; VI-NEXT:    v_cvt_u32_f32_e32 v14, v14
; VI-NEXT:    v_sub_u32_e32 v9, vcc, 0, v0
; VI-NEXT:    v_sub_u32_e32 v11, vcc, 0, v1
; VI-NEXT:    v_sub_u32_e32 v13, vcc, 0, v2
; VI-NEXT:    v_sub_u32_e32 v15, vcc, 0, v3
; VI-NEXT:    v_mul_lo_u32 v9, v9, v8
; VI-NEXT:    v_mul_lo_u32 v11, v11, v10
; VI-NEXT:    v_mul_lo_u32 v13, v13, v12
; VI-NEXT:    v_mul_lo_u32 v15, v15, v14
; VI-NEXT:    v_mul_hi_u32 v9, v8, v9
; VI-NEXT:    v_mul_hi_u32 v11, v10, v11
; VI-NEXT:    v_mul_hi_u32 v13, v12, v13
; VI-NEXT:    v_mul_hi_u32 v15, v14, v15
; VI-NEXT:    v_add_u32_e32 v8, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, v11, v10
; VI-NEXT:    v_add_u32_e32 v10, vcc, v13, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, v15, v14
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mul_hi_u32 v8, v4, v8
; VI-NEXT:    v_mul_hi_u32 v9, v5, v9
; VI-NEXT:    v_mul_hi_u32 v10, v6, v10
; VI-NEXT:    v_mul_hi_u32 v11, v7, v11
; VI-NEXT:    v_mul_lo_u32 v12, v8, v0
; VI-NEXT:    v_mul_lo_u32 v14, v9, v1
; VI-NEXT:    v_mul_lo_u32 v16, v10, v2
; VI-NEXT:    v_mul_lo_u32 v18, v11, v3
; VI-NEXT:    v_subrev_u32_e32 v4, vcc, v12, v4
; VI-NEXT:    v_subrev_u32_e32 v5, vcc, v14, v5
; VI-NEXT:    v_subrev_u32_e32 v6, vcc, v16, v6
; VI-NEXT:    v_subrev_u32_e32 v7, vcc, v18, v7
; VI-NEXT:    v_add_u32_e32 v13, vcc, 1, v8
; VI-NEXT:    v_add_u32_e32 v15, vcc, 1, v9
; VI-NEXT:    v_add_u32_e32 v17, vcc, 1, v10
; VI-NEXT:    v_add_u32_e32 v19, vcc, 1, v11
; VI-NEXT:    v_cmp_ge_u32_e64 s[0:1], v4, v0
; VI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v5, v1
; VI-NEXT:    v_cmp_ge_u32_e64 s[4:5], v6, v2
; VI-NEXT:    v_cmp_ge_u32_e64 s[6:7], v7, v3
; VI-NEXT:    v_cndmask_b32_e64 v8, v8, v13, s[0:1]
; VI-NEXT:    v_subrev_u32_e32 v12, vcc, v0, v4
; VI-NEXT:    v_cndmask_b32_e64 v9, v9, v15, s[2:3]
; VI-NEXT:    v_subrev_u32_e32 v13, vcc, v1, v5
; VI-NEXT:    v_cndmask_b32_e64 v10, v10, v17, s[4:5]
; VI-NEXT:    v_subrev_u32_e32 v14, vcc, v2, v6
; VI-NEXT:    v_cndmask_b32_e64 v11, v11, v19, s[6:7]
; VI-NEXT:    v_subrev_u32_e32 v15, vcc, v3, v7
; VI-NEXT:    v_cndmask_b32_e64 v4, v4, v12, s[0:1]
; VI-NEXT:    v_add_u32_e32 v12, vcc, 1, v8
; VI-NEXT:    v_cndmask_b32_e64 v5, v5, v13, s[2:3]
; VI-NEXT:    v_add_u32_e32 v13, vcc, 1, v9
; VI-NEXT:    v_cndmask_b32_e64 v6, v6, v14, s[4:5]
; VI-NEXT:    v_add_u32_e32 v14, vcc, 1, v10
; VI-NEXT:    v_cndmask_b32_e64 v7, v7, v15, s[6:7]
; VI-NEXT:    v_add_u32_e32 v15, vcc, 1, v11
; VI-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v8, v12, vcc
; VI-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v9, v13, vcc
; VI-NEXT:    v_cmp_ge_u32_e32 vcc, v6, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v10, v14, vcc
; VI-NEXT:    v_cmp_ge_u32_e32 vcc, v7, v3
; VI-NEXT:    v_cndmask_b32_e32 v3, v11, v15, vcc
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: udiv_v4i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_add_u32 s4, s2, 16
; GCN-NEXT:    s_addc_u32 s5, s3, 0
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCN-NEXT:    v_mov_b32_e32 v5, s3
; GCN-NEXT:    v_mov_b32_e32 v4, s2
; GCN-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCN-NEXT:    s_mov_b32 s2, 0x4f7ffffe
; GCN-NEXT:    v_mov_b32_e32 v8, s0
; GCN-NEXT:    v_mov_b32_e32 v9, s1
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_cvt_f32_u32_e32 v10, v0
; GCN-NEXT:    v_cvt_f32_u32_e32 v12, v1
; GCN-NEXT:    v_cvt_f32_u32_e32 v14, v2
; GCN-NEXT:    v_cvt_f32_u32_e32 v16, v3
; GCN-NEXT:    v_rcp_iflag_f32_e32 v10, v10
; GCN-NEXT:    v_rcp_iflag_f32_e32 v12, v12
; GCN-NEXT:    v_rcp_iflag_f32_e32 v14, v14
; GCN-NEXT:    v_rcp_iflag_f32_e32 v16, v16
; GCN-NEXT:    v_mul_f32_e32 v10, s2, v10
; GCN-NEXT:    v_mul_f32_e32 v12, s2, v12
; GCN-NEXT:    v_mul_f32_e32 v14, s2, v14
; GCN-NEXT:    v_mul_f32_e32 v16, s2, v16
; GCN-NEXT:    v_cvt_u32_f32_e32 v10, v10
; GCN-NEXT:    v_cvt_u32_f32_e32 v12, v12
; GCN-NEXT:    v_cvt_u32_f32_e32 v14, v14
; GCN-NEXT:    v_cvt_u32_f32_e32 v16, v16
; GCN-NEXT:    v_sub_u32_e32 v11, vcc, 0, v0
; GCN-NEXT:    v_sub_u32_e32 v13, vcc, 0, v1
; GCN-NEXT:    v_sub_u32_e32 v15, vcc, 0, v2
; GCN-NEXT:    v_sub_u32_e32 v17, vcc, 0, v3
; GCN-NEXT:    v_mul_lo_u32 v11, v11, v10
; GCN-NEXT:    v_mul_lo_u32 v13, v13, v12
; GCN-NEXT:    v_mul_lo_u32 v15, v15, v14
; GCN-NEXT:    v_mul_lo_u32 v17, v17, v16
; GCN-NEXT:    v_mul_hi_u32 v11, v10, v11
; GCN-NEXT:    v_mul_hi_u32 v13, v12, v13
; GCN-NEXT:    v_mul_hi_u32 v15, v14, v15
; GCN-NEXT:    v_mul_hi_u32 v17, v16, v17
; GCN-NEXT:    v_add_u32_e32 v10, vcc, v11, v10
; GCN-NEXT:    v_add_u32_e32 v11, vcc, v13, v12
; GCN-NEXT:    v_add_u32_e32 v12, vcc, v15, v14
; GCN-NEXT:    v_add_u32_e32 v13, vcc, v17, v16
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_mul_hi_u32 v10, v4, v10
; GCN-NEXT:    v_mul_hi_u32 v11, v5, v11
; GCN-NEXT:    v_mul_hi_u32 v12, v6, v12
; GCN-NEXT:    v_mul_hi_u32 v13, v7, v13
; GCN-NEXT:    v_mul_lo_u32 v14, v10, v0
; GCN-NEXT:    v_mul_lo_u32 v16, v11, v1
; GCN-NEXT:    v_mul_lo_u32 v18, v12, v2
; GCN-NEXT:    v_mul_lo_u32 v19, v13, v3
; GCN-NEXT:    v_subrev_u32_e32 v4, vcc, v14, v4
; GCN-NEXT:    v_subrev_u32_e32 v5, vcc, v16, v5
; GCN-NEXT:    v_subrev_u32_e32 v6, vcc, v18, v6
; GCN-NEXT:    v_subrev_u32_e32 v7, vcc, v19, v7
; GCN-NEXT:    v_add_u32_e32 v15, vcc, 1, v10
; GCN-NEXT:    v_add_u32_e32 v17, vcc, 1, v11
; GCN-NEXT:    v_add_u32_e32 v14, vcc, 1, v12
; GCN-NEXT:    v_add_u32_e32 v16, vcc, 1, v13
; GCN-NEXT:    v_cmp_ge_u32_e64 s[0:1], v4, v0
; GCN-NEXT:    v_cmp_ge_u32_e64 s[2:3], v5, v1
; GCN-NEXT:    v_cmp_ge_u32_e64 s[4:5], v6, v2
; GCN-NEXT:    v_cmp_ge_u32_e64 s[6:7], v7, v3
; GCN-NEXT:    v_cndmask_b32_e64 v10, v10, v15, s[0:1]
; GCN-NEXT:    v_subrev_u32_e32 v15, vcc, v0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v11, v11, v17, s[2:3]
; GCN-NEXT:    v_subrev_u32_e32 v17, vcc, v1, v5
; GCN-NEXT:    v_cndmask_b32_e64 v12, v12, v14, s[4:5]
; GCN-NEXT:    v_subrev_u32_e32 v14, vcc, v2, v6
; GCN-NEXT:    v_cndmask_b32_e64 v13, v13, v16, s[6:7]
; GCN-NEXT:    v_subrev_u32_e32 v16, vcc, v3, v7
; GCN-NEXT:    v_cndmask_b32_e64 v4, v4, v15, s[0:1]
; GCN-NEXT:    v_add_u32_e32 v15, vcc, 1, v10
; GCN-NEXT:    v_cndmask_b32_e64 v5, v5, v17, s[2:3]
; GCN-NEXT:    v_add_u32_e32 v17, vcc, 1, v11
; GCN-NEXT:    v_cndmask_b32_e64 v6, v6, v14, s[4:5]
; GCN-NEXT:    v_add_u32_e32 v14, vcc, 1, v12
; GCN-NEXT:    v_cndmask_b32_e64 v7, v7, v16, s[6:7]
; GCN-NEXT:    v_add_u32_e32 v16, vcc, 1, v13
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v0
; GCN-NEXT:    v_cndmask_b32_e32 v0, v10, v15, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v1
; GCN-NEXT:    v_cndmask_b32_e32 v1, v11, v17, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v6, v2
; GCN-NEXT:    v_cndmask_b32_e32 v2, v12, v14, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v7, v3
; GCN-NEXT:    v_cndmask_b32_e32 v3, v13, v16, vcc
; GCN-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: udiv_v4i32:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x0
; GFX1030-NEXT:    v_mov_b32_e32 v8, 0
; GFX1030-NEXT:    s_mov_b32 s0, 0x4f7ffffe
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    s_clause 0x1
; GFX1030-NEXT:    global_load_dwordx4 v[0:3], v8, s[6:7] offset:16
; GFX1030-NEXT:    global_load_dwordx4 v[4:7], v8, s[6:7]
; GFX1030-NEXT:    s_waitcnt vmcnt(1)
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v9, v0
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v10, v1
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v11, v2
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v12, v3
; GFX1030-NEXT:    v_sub_nc_u32_e32 v13, 0, v0
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v9, v9
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v10, v10
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v11, v11
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v12, v12
; GFX1030-NEXT:    v_sub_nc_u32_e32 v14, 0, v1
; GFX1030-NEXT:    v_sub_nc_u32_e32 v15, 0, v2
; GFX1030-NEXT:    v_sub_nc_u32_e32 v16, 0, v3
; GFX1030-NEXT:    v_mul_f32_e32 v9, s0, v9
; GFX1030-NEXT:    v_mul_f32_e32 v10, s0, v10
; GFX1030-NEXT:    v_mul_f32_e32 v11, s0, v11
; GFX1030-NEXT:    v_mul_f32_e32 v12, s0, v12
; GFX1030-NEXT:    v_cvt_u32_f32_e32 v9, v9
; GFX1030-NEXT:    v_cvt_u32_f32_e32 v10, v10
; GFX1030-NEXT:    v_cvt_u32_f32_e32 v11, v11
; GFX1030-NEXT:    v_cvt_u32_f32_e32 v12, v12
; GFX1030-NEXT:    v_mul_lo_u32 v13, v13, v9
; GFX1030-NEXT:    v_mul_lo_u32 v14, v14, v10
; GFX1030-NEXT:    v_mul_lo_u32 v15, v15, v11
; GFX1030-NEXT:    v_mul_lo_u32 v16, v16, v12
; GFX1030-NEXT:    v_mul_hi_u32 v13, v9, v13
; GFX1030-NEXT:    v_mul_hi_u32 v14, v10, v14
; GFX1030-NEXT:    v_mul_hi_u32 v15, v11, v15
; GFX1030-NEXT:    v_mul_hi_u32 v16, v12, v16
; GFX1030-NEXT:    v_add_nc_u32_e32 v9, v9, v13
; GFX1030-NEXT:    v_add_nc_u32_e32 v10, v10, v14
; GFX1030-NEXT:    v_add_nc_u32_e32 v11, v11, v15
; GFX1030-NEXT:    v_add_nc_u32_e32 v12, v12, v16
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    v_mul_hi_u32 v9, v4, v9
; GFX1030-NEXT:    v_mul_hi_u32 v10, v5, v10
; GFX1030-NEXT:    v_mul_hi_u32 v11, v6, v11
; GFX1030-NEXT:    v_mul_hi_u32 v12, v7, v12
; GFX1030-NEXT:    v_mul_lo_u32 v13, v9, v0
; GFX1030-NEXT:    v_mul_lo_u32 v14, v10, v1
; GFX1030-NEXT:    v_mul_lo_u32 v15, v11, v2
; GFX1030-NEXT:    v_mul_lo_u32 v16, v12, v3
; GFX1030-NEXT:    v_add_nc_u32_e32 v17, 1, v9
; GFX1030-NEXT:    v_add_nc_u32_e32 v18, 1, v10
; GFX1030-NEXT:    v_add_nc_u32_e32 v19, 1, v11
; GFX1030-NEXT:    v_sub_nc_u32_e32 v4, v4, v13
; GFX1030-NEXT:    v_sub_nc_u32_e32 v5, v5, v14
; GFX1030-NEXT:    v_sub_nc_u32_e32 v6, v6, v15
; GFX1030-NEXT:    v_sub_nc_u32_e32 v7, v7, v16
; GFX1030-NEXT:    v_add_nc_u32_e32 v13, 1, v12
; GFX1030-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v4, v0
; GFX1030-NEXT:    v_sub_nc_u32_e32 v14, v4, v0
; GFX1030-NEXT:    v_cmp_ge_u32_e64 s0, v5, v1
; GFX1030-NEXT:    v_sub_nc_u32_e32 v15, v5, v1
; GFX1030-NEXT:    v_cmp_ge_u32_e64 s1, v6, v2
; GFX1030-NEXT:    v_cndmask_b32_e32 v9, v9, v17, vcc_lo
; GFX1030-NEXT:    v_cndmask_b32_e32 v4, v4, v14, vcc_lo
; GFX1030-NEXT:    v_cndmask_b32_e64 v10, v10, v18, s0
; GFX1030-NEXT:    v_sub_nc_u32_e32 v16, v6, v2
; GFX1030-NEXT:    v_cmp_ge_u32_e64 s2, v7, v3
; GFX1030-NEXT:    v_add_nc_u32_e32 v14, 1, v9
; GFX1030-NEXT:    v_cndmask_b32_e64 v5, v5, v15, s0
; GFX1030-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v4, v0
; GFX1030-NEXT:    v_cndmask_b32_e64 v11, v11, v19, s1
; GFX1030-NEXT:    v_cndmask_b32_e64 v12, v12, v13, s2
; GFX1030-NEXT:    v_sub_nc_u32_e32 v13, v7, v3
; GFX1030-NEXT:    v_add_nc_u32_e32 v15, 1, v10
; GFX1030-NEXT:    v_cndmask_b32_e64 v6, v6, v16, s1
; GFX1030-NEXT:    v_cndmask_b32_e32 v0, v9, v14, vcc_lo
; GFX1030-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v5, v1
; GFX1030-NEXT:    v_add_nc_u32_e32 v16, 1, v11
; GFX1030-NEXT:    v_cndmask_b32_e64 v7, v7, v13, s2
; GFX1030-NEXT:    v_add_nc_u32_e32 v13, 1, v12
; GFX1030-NEXT:    v_cndmask_b32_e32 v1, v10, v15, vcc_lo
; GFX1030-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v6, v2
; GFX1030-NEXT:    v_cndmask_b32_e32 v2, v11, v16, vcc_lo
; GFX1030-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v7, v3
; GFX1030-NEXT:    v_cndmask_b32_e32 v3, v12, v13, vcc_lo
; GFX1030-NEXT:    global_store_dwordx4 v8, v[0:3], s[4:5]
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: udiv_v4i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 65, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     SUB_INT T2.W, 0.0, T1.W,
; EG-NEXT:     RECIP_UINT * T2.X, T1.W,
; EG-NEXT:     MULLO_INT * T2.Y, PV.W, PS,
; EG-NEXT:     MULHI * T2.Y, T2.X, PS,
; EG-NEXT:     ADD_INT * T2.W, T2.X, PS,
; EG-NEXT:     MULHI * T2.X, T0.W, PV.W,
; EG-NEXT:     MULLO_INT * T2.Y, PS, T1.W,
; EG-NEXT:     SUB_INT T2.W, 0.0, T1.X,
; EG-NEXT:     RECIP_UINT * T2.Z, T1.X,
; EG-NEXT:     MULLO_INT * T2.W, PV.W, PS,
; EG-NEXT:     SUB_INT T3.W, 0.0, T1.Y,
; EG-NEXT:     RECIP_UINT * T3.X, T1.Y,
; EG-NEXT:     MULLO_INT * T3.Y, PV.W, PS,
; EG-NEXT:     SUB_INT T3.W, 0.0, T1.Z,
; EG-NEXT:     RECIP_UINT * T3.Z, T1.Z,
; EG-NEXT:     MULLO_INT * T3.W, PV.W, PS,
; EG-NEXT:     MULHI * T3.W, T3.Z, PS,
; EG-NEXT:     ADD_INT T3.W, T3.Z, PS,
; EG-NEXT:     MULHI * T3.Y, T3.X, T3.Y,
; EG-NEXT:     ADD_INT T4.W, T3.X, PS,
; EG-NEXT:     MULHI * T3.X, T0.Z, PV.W,
; EG-NEXT:     MULHI * T3.Y, T0.Y, PV.W,
; EG-NEXT:     MULLO_INT * T3.Z, PS, T1.Y,
; EG-NEXT:     SUB_INT T3.W, T0.Y, PS,
; EG-NEXT:     MULLO_INT * T0.Y, T3.X, T1.Z,
; EG-NEXT:     SUB_INT T4.X, T0.Z, PS,
; EG-NEXT:     ADD_INT T0.Y, T3.Y, 1,
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T1.Y,
; EG-NEXT:     SUB_INT T4.W, PV.W, T1.Y,
; EG-NEXT:     MULHI * T2.W, T2.Z, T2.W,
; EG-NEXT:     CNDE_INT T5.X, PV.Z, T3.W, PV.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.Z, T3.Y, PV.Y, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PV.X, T1.Z,
; EG-NEXT:     ADD_INT T2.W, T2.Z, PS,
; EG-NEXT:     SUB_INT * T0.W, T0.W, T2.Y,
; EG-NEXT:     ADD_INT T6.X, T3.X, 1,
; EG-NEXT:     ADD_INT T2.Y, T2.X, 1, BS:VEC_120/SCL_212
; EG-NEXT:     SETGE_UINT T2.Z, PS, T1.W,
; EG-NEXT:     SUB_INT T3.W, PS, T1.W,
; EG-NEXT:     MULHI * T2.W, T0.X, PV.W,
; EG-NEXT:     SUB_INT T7.X, T4.X, T1.Z,
; EG-NEXT:     CNDE_INT T3.Y, PV.Z, T0.W, PV.W,
; EG-NEXT:     CNDE_INT T2.Z, PV.Z, T2.X, PV.Y,
; EG-NEXT:     CNDE_INT * T0.W, T0.Z, T3.X, PV.X, BS:VEC_021/SCL_122
; EG-NEXT:     MULLO_INT * T2.X, T2.W, T1.X,
; EG-NEXT:     ADD_INT T3.X, T0.W, 1,
; EG-NEXT:     ADD_INT T2.Y, T2.Z, 1,
; EG-NEXT:     SETGE_UINT T3.Z, T3.Y, T1.W,
; EG-NEXT:     SUB_INT T1.W, T0.X, PS, BS:VEC_201
; EG-NEXT:     CNDE_INT * T3.W, T0.Z, T4.X, T7.X,
; EG-NEXT:     SETGE_UINT T0.X, PS, T1.Z, BS:VEC_021/SCL_122
; EG-NEXT:     ADD_INT T3.Y, T2.W, 1,
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T1.X,
; EG-NEXT:     SUB_INT T3.W, PV.W, T1.X,
; EG-NEXT:     CNDE_INT * T4.W, PV.Z, T2.Z, PV.Y,
; EG-NEXT:     CNDE_INT T2.X, PV.Z, T1.W, PV.W,
; EG-NEXT:     CNDE_INT T2.Y, PV.Z, T2.W, PV.Y, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T4.Z, PV.X, T0.W, T3.X, BS:VEC_201
; EG-NEXT:     ADD_INT T0.W, T0.Y, 1,
; EG-NEXT:     SETGE_UINT * T1.W, T5.X, T1.Y,
; EG-NEXT:     CNDE_INT T4.Y, PS, T0.Y, PV.W,
; EG-NEXT:     ADD_INT T0.W, PV.Y, 1,
; EG-NEXT:     SETGE_UINT * T1.W, PV.X, T1.X,
; EG-NEXT:     CNDE_INT T4.X, PS, T2.Y, PV.W,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %b_ptr = getelementptr <4 x i32>, <4 x i32> addrspace(1)* %in, i32 1
  %a = load <4 x i32>, <4 x i32> addrspace(1) * %in
  %b = load <4 x i32>, <4 x i32> addrspace(1) * %b_ptr
  %result = udiv <4 x i32> %a, %b
  store <4 x i32> %result, <4 x i32> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @udiv_i32_div_pow2(i32 addrspace(1)* %out, i32 addrspace(1)* %in) {
; SI-LABEL: udiv_i32_div_pow2:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v0, 4, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: udiv_i32_div_pow2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v0, 4, v0
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: udiv_i32_div_pow2:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    flat_load_dword v2, v[0:1]
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 4, v2
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: udiv_i32_div_pow2:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX1030-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    v_lshrrev_b32_e32 v1, 4, v1
; GFX1030-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: udiv_i32_div_pow2:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR T0.X, T0.X, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    4(5.605194e-45), 2(2.802597e-45)
  %b_ptr = getelementptr i32, i32 addrspace(1)* %in, i32 1
  %a = load i32, i32 addrspace(1)* %in
  %result = udiv i32 %a, 16
  store i32 %result, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @udiv_i32_div_k_even(i32 addrspace(1)* %out, i32 addrspace(1)* %in) {
; SI-LABEL: udiv_i32_div_k_even:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s2, 0xfabbd9c1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_hi_u32 v0, v0, s2
; SI-NEXT:    v_lshrrev_b32_e32 v0, 25, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: udiv_i32_div_k_even:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s2, 0xfabbd9c1
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mul_hi_u32 v0, v0, s2
; VI-NEXT:    v_lshrrev_b32_e32 v0, 25, v0
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: udiv_i32_div_k_even:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    flat_load_dword v0, v[0:1]
; GCN-NEXT:    s_mov_b32 s2, 0xfabbd9c1
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_mul_hi_u32 v2, v0, s2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 25, v2
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: udiv_i32_div_k_even:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX1030-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    v_mul_hi_u32 v1, 0xfabbd9c1, v1
; GFX1030-NEXT:    v_lshrrev_b32_e32 v1, 25, v1
; GFX1030-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: udiv_i32_div_k_even:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 4, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MULHI * T0.X, T0.X, literal.x,
; EG-NEXT:    -88352319(-4.876880e+35), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PS, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    25(3.503246e-44), 2(2.802597e-45)
  %b_ptr = getelementptr i32, i32 addrspace(1)* %in, i32 1
  %a = load i32, i32 addrspace(1)* %in
  %result = udiv i32 %a, 34259182
  store i32 %result, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @udiv_i32_div_k_odd(i32 addrspace(1)* %out, i32 addrspace(1)* %in) {
; SI-LABEL: udiv_i32_div_k_odd:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s2, 0x7d5deca3
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_hi_u32 v0, v0, s2
; SI-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: udiv_i32_div_k_odd:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s2, 0x7d5deca3
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mul_hi_u32 v0, v0, s2
; VI-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: udiv_i32_div_k_odd:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    flat_load_dword v0, v[0:1]
; GCN-NEXT:    s_mov_b32 s2, 0x7d5deca3
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_mul_hi_u32 v2, v0, s2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: udiv_i32_div_k_odd:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX1030-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    v_mul_hi_u32 v1, 0x7d5deca3, v1
; GFX1030-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX1030-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: udiv_i32_div_k_odd:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 4, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MULHI * T0.X, T0.X, literal.x,
; EG-NEXT:    2103307427(1.843675e+37), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PS, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    24(3.363116e-44), 2(2.802597e-45)
  %b_ptr = getelementptr i32, i32 addrspace(1)* %in, i32 1
  %a = load i32, i32 addrspace(1)* %in
  %result = udiv i32 %a, 34259183
  store i32 %result, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @v_udiv_i8(i32 addrspace(1)* %out, i8 addrspace(1)* %in) {
; SI-LABEL: v_udiv_i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0 offset:1
; SI-NEXT:    buffer_load_ubyte v1, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; SI-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_ubyte0_e32 v1, v1
; SI-NEXT:    v_mul_f32_e32 v2, v1, v2
; SI-NEXT:    v_trunc_f32_e32 v2, v2
; SI-NEXT:    v_cvt_u32_f32_e32 v3, v2
; SI-NEXT:    v_mad_f32 v1, -v2, v0, v1
; SI-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; SI-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_udiv_i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0 offset:1
; VI-NEXT:    buffer_load_ubyte v1, off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; VI-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_ubyte0_e32 v1, v1
; VI-NEXT:    v_mul_f32_e32 v2, v1, v2
; VI-NEXT:    v_trunc_f32_e32 v2, v2
; VI-NEXT:    v_cvt_u32_f32_e32 v3, v2
; VI-NEXT:    v_mad_f32 v1, -v2, v0, v1
; VI-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; VI-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; VI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: v_udiv_i8:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    flat_load_ushort v2, v[0:1]
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_cvt_f32_ubyte1_e32 v3, v2
; GCN-NEXT:    v_rcp_iflag_f32_e32 v4, v3
; GCN-NEXT:    v_cvt_f32_ubyte0_e32 v2, v2
; GCN-NEXT:    v_mul_f32_e32 v4, v2, v4
; GCN-NEXT:    v_trunc_f32_e32 v4, v4
; GCN-NEXT:    v_cvt_u32_f32_e32 v5, v4
; GCN-NEXT:    v_mad_f32 v2, -v4, v3, v2
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v2|, v3
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, 0, v5, vcc
; GCN-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: v_udiv_i8:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX1030-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    v_cvt_f32_ubyte1_e32 v2, v1
; GFX1030-NEXT:    v_cvt_f32_ubyte0_e32 v1, v1
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v3, v2
; GFX1030-NEXT:    v_mul_f32_e32 v3, v1, v3
; GFX1030-NEXT:    v_trunc_f32_e32 v3, v3
; GFX1030-NEXT:    v_fma_f32 v1, -v3, v2, v1
; GFX1030-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GFX1030-NEXT:    v_cmp_ge_f32_e64 vcc_lo, |v1|, v2
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v3, vcc_lo
; GFX1030-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX1030-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: v_udiv_i8:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 14, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T1.X, T0.X, 1, #1
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     UINT_TO_FLT * T0.Y, T1.X,
; EG-NEXT:     RECIP_IEEE * T0.Z, PS,
; EG-NEXT:     UINT_TO_FLT * T0.X, T0.X,
; EG-NEXT:     MUL_IEEE * T0.W, PS, T0.Z,
; EG-NEXT:     TRUNC * T0.W, PV.W,
; EG-NEXT:     MULADD_IEEE T1.W, -PV.W, T0.Y, T0.X,
; EG-NEXT:     TRUNC * T0.W, PV.W,
; EG-NEXT:     SETGE * T1.W, |PV.W|, |T0.Y|,
; EG-NEXT:     CNDE T1.W, PV.W, 0.0, literal.x,
; EG-NEXT:     FLT_TO_UINT * T0.X, T0.W,
; EG-NEXT:    1(1.401298e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, PS, PV.W,
; EG-NEXT:     AND_INT T0.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    255(3.573311e-43), 2(2.802597e-45)
  %den_ptr = getelementptr i8, i8 addrspace(1)* %in, i8 1
  %num = load i8, i8 addrspace(1) * %in
  %den = load i8, i8 addrspace(1) * %den_ptr
  %result = udiv i8 %num, %den
  %result.ext = zext i8 %result to i32
  store i32 %result.ext, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @v_udiv_i16(i32 addrspace(1)* %out, i16 addrspace(1)* %in) {
; SI-LABEL: v_udiv_i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_ushort v0, off, s[8:11], 0 offset:2
; SI-NEXT:    buffer_load_ushort v1, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_u32_e32 v0, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_u32_e32 v1, v1
; SI-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; SI-NEXT:    v_mul_f32_e32 v2, v1, v2
; SI-NEXT:    v_trunc_f32_e32 v2, v2
; SI-NEXT:    v_cvt_u32_f32_e32 v3, v2
; SI-NEXT:    v_mad_f32 v1, -v2, v0, v1
; SI-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; SI-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_udiv_i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_ushort v0, off, s[8:11], 0 offset:2
; VI-NEXT:    buffer_load_ushort v1, off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_cvt_f32_u32_e32 v0, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_u32_e32 v1, v1
; VI-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; VI-NEXT:    v_mul_f32_e32 v2, v1, v2
; VI-NEXT:    v_trunc_f32_e32 v2, v2
; VI-NEXT:    v_cvt_u32_f32_e32 v3, v2
; VI-NEXT:    v_mad_f32 v1, -v2, v0, v1
; VI-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; VI-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; VI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: v_udiv_i16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_add_u32 s4, s2, 2
; GCN-NEXT:    s_addc_u32 s5, s3, 0
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    flat_load_ushort v2, v[0:1]
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    flat_load_ushort v0, v[0:1]
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_cvt_f32_u32_e32 v2, v2
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_cvt_f32_u32_e32 v3, v0
; GCN-NEXT:    v_rcp_iflag_f32_e32 v4, v2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mul_f32_e32 v4, v3, v4
; GCN-NEXT:    v_trunc_f32_e32 v4, v4
; GCN-NEXT:    v_cvt_u32_f32_e32 v5, v4
; GCN-NEXT:    v_mad_f32 v3, -v4, v2, v3
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v3|, v2
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, 0, v5, vcc
; GCN-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: v_udiv_i16:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX1030-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    s_clause 0x1
; GFX1030-NEXT:    global_load_ushort v1, v0, s[2:3] offset:2
; GFX1030-NEXT:    global_load_ushort v2, v0, s[2:3]
; GFX1030-NEXT:    s_waitcnt vmcnt(1)
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v1, v1
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v2, v2
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v3, v1
; GFX1030-NEXT:    v_mul_f32_e32 v3, v2, v3
; GFX1030-NEXT:    v_trunc_f32_e32 v3, v3
; GFX1030-NEXT:    v_fma_f32 v2, -v3, v1, v2
; GFX1030-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GFX1030-NEXT:    v_cmp_ge_f32_e64 vcc_lo, |v2|, v1
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v3, vcc_lo
; GFX1030-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX1030-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: v_udiv_i16:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 14, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T1.X, T0.X, 2, #1
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     UINT_TO_FLT * T0.Y, T1.X,
; EG-NEXT:     RECIP_IEEE * T0.Z, PS,
; EG-NEXT:     UINT_TO_FLT * T0.X, T0.X,
; EG-NEXT:     MUL_IEEE * T0.W, PS, T0.Z,
; EG-NEXT:     TRUNC * T0.W, PV.W,
; EG-NEXT:     MULADD_IEEE T1.W, -PV.W, T0.Y, T0.X,
; EG-NEXT:     TRUNC * T0.W, PV.W,
; EG-NEXT:     SETGE * T1.W, |PV.W|, |T0.Y|,
; EG-NEXT:     CNDE T1.W, PV.W, 0.0, literal.x,
; EG-NEXT:     FLT_TO_UINT * T0.X, T0.W,
; EG-NEXT:    1(1.401298e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, PS, PV.W,
; EG-NEXT:     AND_INT T0.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    65535(9.183409e-41), 2(2.802597e-45)
  %den_ptr = getelementptr i16, i16 addrspace(1)* %in, i16 1
  %num = load i16, i16 addrspace(1) * %in
  %den = load i16, i16 addrspace(1) * %den_ptr
  %result = udiv i16 %num, %den
  %result.ext = zext i16 %result to i32
  store i32 %result.ext, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @v_udiv_i23(i32 addrspace(1)* %out, i23 addrspace(1)* %in) {
; SI-LABEL: v_udiv_i23:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0 offset:6
; SI-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 offset:4
; SI-NEXT:    buffer_load_ubyte v2, off, s[8:11], 0 offset:2
; SI-NEXT:    buffer_load_ushort v3, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_u32_e32 v0, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_cvt_f32_u32_e32 v1, v1
; SI-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; SI-NEXT:    v_mul_f32_e32 v2, v1, v2
; SI-NEXT:    v_trunc_f32_e32 v2, v2
; SI-NEXT:    v_cvt_u32_f32_e32 v3, v2
; SI-NEXT:    v_mad_f32 v1, -v2, v0, v1
; SI-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; SI-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; SI-NEXT:    v_and_b32_e32 v0, 0x7fffff, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_udiv_i23:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0 offset:6
; VI-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 offset:4
; VI-NEXT:    buffer_load_ubyte v2, off, s[8:11], 0 offset:2
; VI-NEXT:    buffer_load_ushort v3, off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    v_cvt_f32_u32_e32 v0, v0
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_e32 v1, v3, v1
; VI-NEXT:    v_cvt_f32_u32_e32 v1, v1
; VI-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; VI-NEXT:    v_mul_f32_e32 v2, v1, v2
; VI-NEXT:    v_trunc_f32_e32 v2, v2
; VI-NEXT:    v_cvt_u32_f32_e32 v3, v2
; VI-NEXT:    v_mad_f32 v1, -v2, v0, v1
; VI-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, v0
; VI-NEXT:    v_addc_u32_e32 v0, vcc, 0, v3, vcc
; VI-NEXT:    v_and_b32_e32 v0, 0x7fffff, v0
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: v_udiv_i23:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_add_u32 s4, s2, 4
; GCN-NEXT:    s_addc_u32 s5, s3, 0
; GCN-NEXT:    s_add_u32 s6, s2, 2
; GCN-NEXT:    s_addc_u32 s7, s3, 0
; GCN-NEXT:    v_mov_b32_e32 v0, s6
; GCN-NEXT:    v_mov_b32_e32 v1, s7
; GCN-NEXT:    s_add_u32 s6, s2, 6
; GCN-NEXT:    s_addc_u32 s7, s3, 0
; GCN-NEXT:    v_mov_b32_e32 v2, s6
; GCN-NEXT:    v_mov_b32_e32 v3, s7
; GCN-NEXT:    v_mov_b32_e32 v4, s4
; GCN-NEXT:    v_mov_b32_e32 v5, s5
; GCN-NEXT:    flat_load_ubyte v6, v[2:3]
; GCN-NEXT:    flat_load_ushort v4, v[4:5]
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_mov_b32_e32 v3, s3
; GCN-NEXT:    flat_load_ubyte v0, v[0:1]
; GCN-NEXT:    flat_load_ushort v1, v[2:3]
; GCN-NEXT:    s_waitcnt vmcnt(3)
; GCN-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GCN-NEXT:    s_waitcnt vmcnt(2)
; GCN-NEXT:    v_or_b32_e32 v2, v4, v2
; GCN-NEXT:    v_cvt_f32_u32_e32 v2, v2
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_or_b32_e32 v0, v1, v0
; GCN-NEXT:    v_cvt_f32_u32_e32 v3, v0
; GCN-NEXT:    v_rcp_iflag_f32_e32 v4, v2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mul_f32_e32 v4, v3, v4
; GCN-NEXT:    v_trunc_f32_e32 v4, v4
; GCN-NEXT:    v_cvt_u32_f32_e32 v5, v4
; GCN-NEXT:    v_mad_f32 v3, -v4, v2, v3
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v3|, v2
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, 0, v5, vcc
; GCN-NEXT:    v_and_b32_e32 v2, 0x7fffff, v2
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: v_udiv_i23:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX1030-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    s_clause 0x3
; GFX1030-NEXT:    global_load_ubyte v1, v0, s[2:3] offset:6
; GFX1030-NEXT:    global_load_ushort v2, v0, s[2:3] offset:4
; GFX1030-NEXT:    global_load_ubyte v3, v0, s[2:3] offset:2
; GFX1030-NEXT:    global_load_ushort v4, v0, s[2:3]
; GFX1030-NEXT:    s_waitcnt vmcnt(3)
; GFX1030-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX1030-NEXT:    s_waitcnt vmcnt(2)
; GFX1030-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX1030-NEXT:    s_waitcnt vmcnt(1)
; GFX1030-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v1, v1
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v3, v1
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v2, v2
; GFX1030-NEXT:    v_mul_f32_e32 v3, v2, v3
; GFX1030-NEXT:    v_trunc_f32_e32 v3, v3
; GFX1030-NEXT:    v_fma_f32 v2, -v3, v1, v2
; GFX1030-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GFX1030-NEXT:    v_cmp_ge_f32_e64 vcc_lo, |v2|, v1
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v3, vcc_lo
; GFX1030-NEXT:    v_and_b32_e32 v1, 0x7fffff, v1
; GFX1030-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: v_udiv_i23:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 3 @6
; EG-NEXT:    ALU 20, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T1.X, T0.X, 6, #1
; EG-NEXT:     VTX_READ_16 T2.X, T0.X, 0, #1
; EG-NEXT:     VTX_READ_8 T3.X, T0.X, 2, #1
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 4, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     LSHL * T0.W, T1.X, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     OR_INT T0.W, T0.X, PV.W,
; EG-NEXT:     LSHL * T1.W, T3.X, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     UINT_TO_FLT * T0.X, PV.W,
; EG-NEXT:     OR_INT T0.W, T2.X, T1.W,
; EG-NEXT:     RECIP_IEEE * T0.Y, PS,
; EG-NEXT:     UINT_TO_FLT * T0.Z, PV.W,
; EG-NEXT:     MUL_IEEE * T0.W, PS, T0.Y,
; EG-NEXT:     TRUNC * T0.W, PV.W,
; EG-NEXT:     MULADD_IEEE T1.W, -PV.W, T0.X, T0.Z,
; EG-NEXT:     TRUNC * T0.W, PV.W,
; EG-NEXT:     SETGE * T1.W, |PV.W|, |T0.X|,
; EG-NEXT:     CNDE T1.W, PV.W, 0.0, literal.x,
; EG-NEXT:     FLT_TO_UINT * T0.X, T0.W,
; EG-NEXT:    1(1.401298e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, PS, PV.W,
; EG-NEXT:     AND_INT T0.X, PV.W, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    8388607(1.175494e-38), 2(2.802597e-45)
  %den_ptr = getelementptr i23, i23 addrspace(1)* %in, i23 1
  %num = load i23, i23 addrspace(1) * %in
  %den = load i23, i23 addrspace(1) * %den_ptr
  %result = udiv i23 %num, %den
  %result.ext = zext i23 %result to i32
  store i32 %result.ext, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @v_udiv_i24(i32 addrspace(1)* %out, i24 addrspace(1)* %in) {
; SI-LABEL: v_udiv_i24:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0 offset:6
; SI-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 offset:4
; SI-NEXT:    buffer_load_ubyte v2, off, s[8:11], 0 offset:2
; SI-NEXT:    buffer_load_ushort v3, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_cvt_f32_u32_e32 v1, v0
; SI-NEXT:    v_sub_i32_e32 v4, vcc, 0, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; SI-NEXT:    v_cvt_u32_f32_e32 v1, v1
; SI-NEXT:    v_mul_lo_u32 v4, v4, v1
; SI-NEXT:    v_mul_hi_u32 v4, v1, v4
; SI-NEXT:    v_add_i32_e32 v1, vcc, v4, v1
; SI-NEXT:    v_mul_hi_u32 v1, v2, v1
; SI-NEXT:    v_mul_lo_u32 v3, v1, v0
; SI-NEXT:    v_add_i32_e32 v4, vcc, 1, v1
; SI-NEXT:    v_subrev_i32_e32 v2, vcc, v3, v2
; SI-NEXT:    v_cmp_ge_u32_e64 s[0:1], v2, v0
; SI-NEXT:    v_cndmask_b32_e64 v1, v1, v4, s[0:1]
; SI-NEXT:    v_subrev_i32_e32 v3, vcc, v0, v2
; SI-NEXT:    v_cndmask_b32_e64 v2, v2, v3, s[0:1]
; SI-NEXT:    v_add_i32_e32 v3, vcc, 1, v1
; SI-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, v1, v3, vcc
; SI-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_udiv_i24:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0 offset:6
; VI-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 offset:4
; VI-NEXT:    buffer_load_ubyte v2, off, s[8:11], 0 offset:2
; VI-NEXT:    buffer_load_ushort v3, off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(3)
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; VI-NEXT:    s_waitcnt vmcnt(2)
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    v_cvt_f32_u32_e32 v1, v0
; VI-NEXT:    v_sub_u32_e32 v4, vcc, 0, v0
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; VI-NEXT:    v_cvt_u32_f32_e32 v1, v1
; VI-NEXT:    v_mul_lo_u32 v4, v4, v1
; VI-NEXT:    v_mul_hi_u32 v4, v1, v4
; VI-NEXT:    v_add_u32_e32 v1, vcc, v4, v1
; VI-NEXT:    v_mul_hi_u32 v1, v2, v1
; VI-NEXT:    v_mul_lo_u32 v3, v1, v0
; VI-NEXT:    v_add_u32_e32 v4, vcc, 1, v1
; VI-NEXT:    v_subrev_u32_e32 v2, vcc, v3, v2
; VI-NEXT:    v_cmp_ge_u32_e64 s[0:1], v2, v0
; VI-NEXT:    v_cndmask_b32_e64 v1, v1, v4, s[0:1]
; VI-NEXT:    v_subrev_u32_e32 v3, vcc, v0, v2
; VI-NEXT:    v_cndmask_b32_e64 v2, v2, v3, s[0:1]
; VI-NEXT:    v_add_u32_e32 v3, vcc, 1, v1
; VI-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v3, vcc
; VI-NEXT:    v_and_b32_e32 v0, 0xffffff, v0
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: v_udiv_i24:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_add_u32 s4, s2, 4
; GCN-NEXT:    s_addc_u32 s5, s3, 0
; GCN-NEXT:    s_add_u32 s6, s2, 2
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    s_addc_u32 s7, s3, 0
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    s_add_u32 s4, s2, 6
; GCN-NEXT:    s_addc_u32 s5, s3, 0
; GCN-NEXT:    v_mov_b32_e32 v2, s4
; GCN-NEXT:    v_mov_b32_e32 v3, s5
; GCN-NEXT:    flat_load_ubyte v4, v[2:3]
; GCN-NEXT:    flat_load_ushort v5, v[0:1]
; GCN-NEXT:    v_mov_b32_e32 v2, s6
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v3, s7
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    flat_load_ubyte v2, v[2:3]
; GCN-NEXT:    flat_load_ushort v0, v[0:1]
; GCN-NEXT:    s_waitcnt vmcnt(3)
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 16, v4
; GCN-NEXT:    s_waitcnt vmcnt(2)
; GCN-NEXT:    v_or_b32_e32 v3, v5, v1
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, v3
; GCN-NEXT:    v_sub_u32_e32 v4, vcc, 0, v3
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GCN-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_or_b32_e32 v2, v0, v2
; GCN-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GCN-NEXT:    v_mul_lo_u32 v4, v4, v1
; GCN-NEXT:    v_mul_hi_u32 v4, v1, v4
; GCN-NEXT:    v_add_u32_e32 v0, vcc, v4, v1
; GCN-NEXT:    v_mul_hi_u32 v4, v2, v0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mul_lo_u32 v5, v4, v3
; GCN-NEXT:    v_add_u32_e32 v6, vcc, 1, v4
; GCN-NEXT:    v_subrev_u32_e32 v2, vcc, v5, v2
; GCN-NEXT:    v_cmp_ge_u32_e64 s[0:1], v2, v3
; GCN-NEXT:    v_cndmask_b32_e64 v4, v4, v6, s[0:1]
; GCN-NEXT:    v_subrev_u32_e32 v5, vcc, v3, v2
; GCN-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GCN-NEXT:    v_add_u32_e32 v5, vcc, 1, v4
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v3
; GCN-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc
; GCN-NEXT:    v_and_b32_e32 v2, 0xffffff, v2
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: v_udiv_i24:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX1030-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    s_clause 0x3
; GFX1030-NEXT:    global_load_ubyte v1, v0, s[2:3] offset:6
; GFX1030-NEXT:    global_load_ushort v2, v0, s[2:3] offset:4
; GFX1030-NEXT:    global_load_ubyte v3, v0, s[2:3] offset:2
; GFX1030-NEXT:    global_load_ushort v4, v0, s[2:3]
; GFX1030-NEXT:    s_waitcnt vmcnt(3)
; GFX1030-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX1030-NEXT:    s_waitcnt vmcnt(1)
; GFX1030-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX1030-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX1030-NEXT:    v_cvt_f32_u32_e32 v2, v1
; GFX1030-NEXT:    v_sub_nc_u32_e32 v5, 0, v1
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v2, v2
; GFX1030-NEXT:    v_mul_f32_e32 v2, 0x4f7ffffe, v2
; GFX1030-NEXT:    v_cvt_u32_f32_e32 v2, v2
; GFX1030-NEXT:    v_mul_lo_u32 v5, v5, v2
; GFX1030-NEXT:    v_mul_hi_u32 v5, v2, v5
; GFX1030-NEXT:    v_add_nc_u32_e32 v2, v2, v5
; GFX1030-NEXT:    v_mul_hi_u32 v2, v3, v2
; GFX1030-NEXT:    v_mul_lo_u32 v4, v2, v1
; GFX1030-NEXT:    v_sub_nc_u32_e32 v3, v3, v4
; GFX1030-NEXT:    v_add_nc_u32_e32 v4, 1, v2
; GFX1030-NEXT:    v_sub_nc_u32_e32 v5, v3, v1
; GFX1030-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v3, v1
; GFX1030-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc_lo
; GFX1030-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc_lo
; GFX1030-NEXT:    v_add_nc_u32_e32 v4, 1, v2
; GFX1030-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v3, v1
; GFX1030-NEXT:    v_cndmask_b32_e32 v1, v2, v4, vcc_lo
; GFX1030-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX1030-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: v_udiv_i24:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 3 @6
; EG-NEXT:    ALU 23, @15, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T1.X, T0.X, 6, #1
; EG-NEXT:     VTX_READ_16 T2.X, T0.X, 0, #1
; EG-NEXT:     VTX_READ_8 T3.X, T0.X, 2, #1
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 4, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     LSHL * T0.W, T1.X, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     OR_INT * T0.W, T0.X, PV.W,
; EG-NEXT:     SUB_INT T1.W, 0.0, PV.W,
; EG-NEXT:     RECIP_UINT * T0.X, PV.W,
; EG-NEXT:     MULLO_INT * T0.Y, PV.W, PS,
; EG-NEXT:     LSHL T1.W, T3.X, literal.x,
; EG-NEXT:     MULHI * T0.Y, T0.X, PS,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T2.W, T0.X, PS,
; EG-NEXT:     OR_INT * T1.W, T2.X, PV.W,
; EG-NEXT:     MULHI * T0.X, PS, PV.W,
; EG-NEXT:     MULLO_INT * T0.Y, PS, T0.W,
; EG-NEXT:     SUB_INT * T1.W, T1.W, PS,
; EG-NEXT:     ADD_INT T0.Z, T0.X, 1,
; EG-NEXT:     SETGE_UINT T2.W, PV.W, T0.W,
; EG-NEXT:     SUB_INT * T3.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T1.W, PV.W, T1.W, PS,
; EG-NEXT:     CNDE_INT * T2.W, PV.W, T0.X, PV.Z,
; EG-NEXT:     ADD_INT T3.W, PS, 1,
; EG-NEXT:     SETGE_UINT * T0.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.X, PS, T2.W, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %den_ptr = getelementptr i24, i24 addrspace(1)* %in, i24 1
  %num = load i24, i24 addrspace(1) * %in
  %den = load i24, i24 addrspace(1) * %den_ptr
  %result = udiv i24 %num, %den
  %result.ext = zext i24 %result to i32
  store i32 %result.ext, i32 addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @scalarize_mulhu_4xi32(<4 x i32> addrspace(1)* nocapture readonly %in, <4 x i32> addrspace(1)* nocapture %out) {
; SI-LABEL: scalarize_mulhu_4xi32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_mov_b32 s0, 0x1389c755
; SI-NEXT:    s_mov_b32 s4, s2
; SI-NEXT:    s_mov_b32 s5, s3
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 2, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 2, v3
; SI-NEXT:    v_mul_hi_u32 v0, v0, s0
; SI-NEXT:    v_mul_hi_u32 v1, v1, s0
; SI-NEXT:    v_mul_hi_u32 v2, v2, s0
; SI-NEXT:    v_mul_hi_u32 v3, v3, s0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 10, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 10, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 10, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 10, v3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: scalarize_mulhu_4xi32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_mov_b32 s0, 0x1389c755
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v0, 2, v0
; VI-NEXT:    v_lshrrev_b32_e32 v1, 2, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; VI-NEXT:    v_lshrrev_b32_e32 v3, 2, v3
; VI-NEXT:    v_mul_hi_u32 v0, v0, s0
; VI-NEXT:    v_mul_hi_u32 v1, v1, s0
; VI-NEXT:    v_mul_hi_u32 v2, v2, s0
; VI-NEXT:    v_mul_hi_u32 v3, v3, s0
; VI-NEXT:    v_lshrrev_b32_e32 v0, 10, v0
; VI-NEXT:    v_lshrrev_b32_e32 v1, 10, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 10, v2
; VI-NEXT:    v_lshrrev_b32_e32 v3, 10, v3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: scalarize_mulhu_4xi32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCN-NEXT:    s_mov_b32 s0, 0x1389c755
; GCN-NEXT:    v_mov_b32_e32 v4, s2
; GCN-NEXT:    v_mov_b32_e32 v5, s3
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 2, v0
; GCN-NEXT:    v_lshrrev_b32_e32 v1, 2, v1
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; GCN-NEXT:    v_lshrrev_b32_e32 v3, 2, v3
; GCN-NEXT:    v_mul_hi_u32 v0, v0, s0
; GCN-NEXT:    v_mul_hi_u32 v1, v1, s0
; GCN-NEXT:    v_mul_hi_u32 v2, v2, s0
; GCN-NEXT:    v_mul_hi_u32 v3, v3, s0
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 10, v0
; GCN-NEXT:    v_lshrrev_b32_e32 v1, 10, v1
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 10, v2
; GCN-NEXT:    v_lshrrev_b32_e32 v3, 10, v3
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: scalarize_mulhu_4xi32:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX1030-NEXT:    v_mov_b32_e32 v4, 0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    global_load_dwordx4 v[0:3], v4, s[0:1]
; GFX1030-NEXT:    s_mov_b32 s0, 0x1389c755
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    v_lshrrev_b32_e32 v0, 2, v0
; GFX1030-NEXT:    v_lshrrev_b32_e32 v1, 2, v1
; GFX1030-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; GFX1030-NEXT:    v_lshrrev_b32_e32 v3, 2, v3
; GFX1030-NEXT:    v_mul_hi_u32 v0, v0, s0
; GFX1030-NEXT:    v_mul_hi_u32 v1, v1, s0
; GFX1030-NEXT:    v_mul_hi_u32 v2, v2, s0
; GFX1030-NEXT:    v_mul_hi_u32 v3, v3, s0
; GFX1030-NEXT:    v_lshrrev_b32_e32 v0, 10, v0
; GFX1030-NEXT:    v_lshrrev_b32_e32 v1, 10, v1
; GFX1030-NEXT:    v_lshrrev_b32_e32 v2, 10, v2
; GFX1030-NEXT:    v_lshrrev_b32_e32 v3, 10, v3
; GFX1030-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3]
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: scalarize_mulhu_4xi32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 20, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Y,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR T0.W, T0.W, literal.x,
; EG-NEXT:     LSHR * T1.W, T0.Z, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MULHI * T0.Z, PV.W, literal.x,
; EG-NEXT:    327796565(3.478022e-27), 0(0.000000e+00)
; EG-NEXT:     LSHR T1.Z, T0.Y, literal.x,
; EG-NEXT:     LSHR T0.W, PS, literal.y,
; EG-NEXT:     MULHI * T0.Y, T1.W, literal.z,
; EG-NEXT:    2(2.802597e-45), 10(1.401298e-44)
; EG-NEXT:    327796565(3.478022e-27), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.Z, PS, literal.x,
; EG-NEXT:     LSHR T1.W, T0.X, literal.y,
; EG-NEXT:     MULHI * T0.X, PV.Z, literal.z,
; EG-NEXT:    10(1.401298e-44), 2(2.802597e-45)
; EG-NEXT:    327796565(3.478022e-27), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.Y, PS, literal.x,
; EG-NEXT:     MULHI * T0.X, PV.W, literal.y,
; EG-NEXT:    10(1.401298e-44), 327796565(3.478022e-27)
; EG-NEXT:     LSHR T0.X, PS, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Z, literal.y,
; EG-NEXT:    10(1.401298e-44), 2(2.802597e-45)
  %1 = load <4 x i32>, <4 x i32> addrspace(1)* %in, align 16
  %2 = udiv <4 x i32> %1, <i32 53668, i32 53668, i32 53668, i32 53668>
  store <4 x i32> %2, <4 x i32> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @test_udiv2(i32 %p) {
; SI-LABEL: test_udiv2:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s0, s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s0, s0, 1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_udiv2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s0, s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s0, s0, 1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: test_udiv2:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s0, s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshr_b32 s0, s0, 1
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    flat_store_dword v[0:1], v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: test_udiv2:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    s_lshr_b32 s0, s0, 1
; GFX1030-NEXT:    v_mov_b32_e32 v0, s0
; GFX1030-NEXT:    global_store_dword v[0:1], v0, off
; GFX1030-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: test_udiv2:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     MOV T0.X, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, 1,
; EG-NEXT:    0(0.000000e+00), 0(0.000000e+00)
  %i = udiv i32 %p, 2
  store volatile i32 %i, i32 addrspace(1)* undef
  ret void
}

define amdgpu_kernel void @test_udiv_3_mulhu(i32 %p) {
; SI-LABEL: test_udiv_3_mulhu:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s0, s[0:1], 0x9
; SI-NEXT:    v_mov_b32_e32 v0, 0xaaaaaaab
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mul_hi_u32 v0, s0, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 1, v0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_udiv_3_mulhu:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s0, s[0:1], 0x24
; VI-NEXT:    v_mov_b32_e32 v0, 0xaaaaaaab
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mul_hi_u32 v0, s0, v0
; VI-NEXT:    v_lshrrev_b32_e32 v0, 1, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: test_udiv_3_mulhu:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s0, s[4:5], 0x0
; GCN-NEXT:    v_mov_b32_e32 v0, 0xaaaaaaab
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mul_hi_u32 v0, s0, v0
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 1, v0
; GCN-NEXT:    flat_store_dword v[0:1], v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: test_udiv_3_mulhu:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    s_mul_hi_u32 s0, s0, 0xaaaaaaab
; GFX1030-NEXT:    s_lshr_b32 s0, s0, 1
; GFX1030-NEXT:    v_mov_b32_e32 v0, s0
; GFX1030-NEXT:    global_store_dword v[0:1], v0, off
; GFX1030-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: test_udiv_3_mulhu:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 4, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     MULHI * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    -1431655765(-3.031649e-13), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PS, 1,
; EG-NEXT:     MOV * T1.X, literal.x,
; EG-NEXT:    0(0.000000e+00), 0(0.000000e+00)
   %i = udiv i32 %p, 3
   store volatile i32 %i, i32 addrspace(1)* undef
   ret void
}

define amdgpu_kernel void @fdiv_test_denormals(i8 addrspace(1)* nocapture readonly %arg) {
; SI-LABEL: fdiv_test_denormals:
; SI:       ; %bb.0: ; %bb
; SI-NEXT:    s_mov_b32 s0, 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s1, s0
; SI-NEXT:    buffer_load_sbyte v0, off, s[0:3], 0
; SI-NEXT:    buffer_load_sbyte v1, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_i32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_i32_e32 v3, v1
; SI-NEXT:    v_xor_b32_e32 v0, v1, v0
; SI-NEXT:    v_ashrrev_i32_e32 v0, 30, v0
; SI-NEXT:    v_rcp_iflag_f32_e32 v4, v2
; SI-NEXT:    v_or_b32_e32 v0, 1, v0
; SI-NEXT:    v_mul_f32_e32 v1, v3, v4
; SI-NEXT:    v_trunc_f32_e32 v1, v1
; SI-NEXT:    v_mad_f32 v3, -v1, v2, v3
; SI-NEXT:    v_cvt_i32_f32_e32 v1, v1
; SI-NEXT:    v_cmp_ge_f32_e64 vcc, |v3|, |v2|
; SI-NEXT:    v_cndmask_b32_e32 v0, 0, v0, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fdiv_test_denormals:
; VI:       ; %bb.0: ; %bb
; VI-NEXT:    s_mov_b32 s0, 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s1, s0
; VI-NEXT:    buffer_load_sbyte v0, off, s[0:3], 0
; VI-NEXT:    buffer_load_sbyte v1, off, s[0:3], 0
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_cvt_f32_i32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cvt_f32_i32_e32 v3, v1
; VI-NEXT:    v_xor_b32_e32 v0, v1, v0
; VI-NEXT:    v_ashrrev_i32_e32 v0, 30, v0
; VI-NEXT:    v_rcp_iflag_f32_e32 v4, v2
; VI-NEXT:    v_or_b32_e32 v0, 1, v0
; VI-NEXT:    v_mul_f32_e32 v1, v3, v4
; VI-NEXT:    v_trunc_f32_e32 v1, v1
; VI-NEXT:    v_mad_f32 v3, -v1, v2, v3
; VI-NEXT:    v_cvt_i32_f32_e32 v1, v1
; VI-NEXT:    v_cmp_ge_f32_e64 vcc, |v3|, |v2|
; VI-NEXT:    v_cndmask_b32_e32 v0, 0, v0, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, v1, v0
; VI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GCN-LABEL: fdiv_test_denormals:
; GCN:       ; %bb.0: ; %bb
; GCN-NEXT:    flat_load_sbyte v2, v[0:1]
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    flat_load_sbyte v3, v[0:1]
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_cvt_f32_i32_e32 v4, v2
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_cvt_f32_i32_e32 v5, v3
; GCN-NEXT:    v_rcp_iflag_f32_e32 v6, v4
; GCN-NEXT:    v_xor_b32_e32 v2, v3, v2
; GCN-NEXT:    v_ashrrev_i32_e32 v2, 30, v2
; GCN-NEXT:    v_or_b32_e32 v2, 1, v2
; GCN-NEXT:    v_mul_f32_e32 v3, v5, v6
; GCN-NEXT:    v_trunc_f32_e32 v3, v3
; GCN-NEXT:    v_mad_f32 v5, -v3, v4, v5
; GCN-NEXT:    v_cvt_i32_f32_e32 v3, v3
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v5|, |v4|
; GCN-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GCN-NEXT:    v_add_u32_e32 v2, vcc, v3, v2
; GCN-NEXT:    flat_store_byte v[0:1], v2
; GCN-NEXT:    s_endpgm
;
; GFX1030-LABEL: fdiv_test_denormals:
; GFX1030:       ; %bb.0: ; %bb
; GFX1030-NEXT:    global_load_sbyte v2, v[0:1], off
; GFX1030-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030-NEXT:    v_mov_b32_e32 v1, 0
; GFX1030-NEXT:    global_load_sbyte v3, v[0:1], off
; GFX1030-NEXT:    s_waitcnt vmcnt(1)
; GFX1030-NEXT:    v_cvt_f32_i32_e32 v4, v2
; GFX1030-NEXT:    v_rcp_iflag_f32_e32 v5, v4
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    v_cvt_f32_i32_e32 v6, v3
; GFX1030-NEXT:    v_xor_b32_e32 v2, v3, v2
; GFX1030-NEXT:    v_ashrrev_i32_e32 v2, 30, v2
; GFX1030-NEXT:    v_mul_f32_e32 v5, v6, v5
; GFX1030-NEXT:    v_or_b32_e32 v2, 1, v2
; GFX1030-NEXT:    v_trunc_f32_e32 v3, v5
; GFX1030-NEXT:    v_fma_f32 v5, -v3, v4, v6
; GFX1030-NEXT:    v_cvt_i32_f32_e32 v3, v3
; GFX1030-NEXT:    v_cmp_ge_f32_e64 vcc_lo, |v5|, |v4|
; GFX1030-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc_lo
; GFX1030-NEXT:    v_add_nc_u32_e32 v2, v3, v2
; GFX1030-NEXT:    global_store_byte v[0:1], v2, off
; GFX1030-NEXT:    s_endpgm
;
; EG-LABEL: fdiv_test_denormals:
; EG:       ; %bb.0: ; %bb
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 0, @10, KC0[], KC1[]
; EG-NEXT:    TEX 0 @8
; EG-NEXT:    ALU 25, @11, KC0[], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    Fetch clause starting at 8:
; EG-NEXT:     VTX_READ_8 T1.X, T1.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T1.X, 0.0,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     BFE_INT * T0.W, T0.X, 0.0, literal.x,
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     INT_TO_FLT * T0.X, PV.W,
; EG-NEXT:     BFE_INT T1.W, T1.X, 0.0, literal.x,
; EG-NEXT:     RECIP_IEEE * T0.Y, PS,
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     INT_TO_FLT * T0.Z, PV.W,
; EG-NEXT:     MUL_IEEE * T2.W, PS, T0.Y,
; EG-NEXT:     TRUNC T2.W, PV.W,
; EG-NEXT:     XOR_INT * T0.W, T1.W, T0.W,
; EG-NEXT:     ASHR T0.W, PS, literal.x,
; EG-NEXT:     MULADD_IEEE * T1.W, -PV.W, T0.X, T0.Z,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     TRUNC T0.Z, T2.W,
; EG-NEXT:     SETGE T1.W, |PS|, |T0.X|,
; EG-NEXT:     OR_INT * T0.W, PV.W, 1,
; EG-NEXT:     CNDE T0.W, PV.W, 0.0, PS,
; EG-NEXT:     FLT_TO_INT * T1.W, PV.Z,
; EG-NEXT:     ADD_INT * T0.W, PS, PV.W,
; EG-NEXT:     AND_INT T0.X, PV.W, literal.x,
; EG-NEXT:     MOV * T0.W, literal.x,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     MOV * T1.X, literal.x,
; EG-NEXT:    0(0.000000e+00), 0(0.000000e+00)
bb:
  %tmp = load i8, i8 addrspace(1)* null, align 1
  %tmp1 = sext i8 %tmp to i32
  %tmp2 = getelementptr inbounds i8, i8 addrspace(1)* %arg, i64 undef
  %tmp3 = load i8, i8 addrspace(1)* %tmp2, align 1
  %tmp4 = sext i8 %tmp3 to i32
  %tmp5 = sdiv i32 %tmp1, %tmp4
  %tmp6 = trunc i32 %tmp5 to i8
  store i8 %tmp6, i8 addrspace(1)* null, align 1
  ret void
}

define i64 @v_test_udiv64_mulhi_fold(i64 %arg) {
; SI-LABEL: v_test_udiv64_mulhi_fold:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v2, 0x4f800000
; SI-NEXT:    v_madak_f32 v2, 0, v2, 0x47c35000
; SI-NEXT:    v_rcp_f32_e32 v2, v2
; SI-NEXT:    s_mov_b32 s4, 0xfffe7960
; SI-NEXT:    v_mov_b32_e32 v9, 0
; SI-NEXT:    v_mul_f32_e32 v2, 0x5f7ffffc, v2
; SI-NEXT:    v_mul_f32_e32 v3, 0x2f800000, v2
; SI-NEXT:    v_trunc_f32_e32 v3, v3
; SI-NEXT:    v_mac_f32_e32 v2, 0xcf800000, v3
; SI-NEXT:    v_cvt_u32_f32_e32 v2, v2
; SI-NEXT:    v_cvt_u32_f32_e32 v3, v3
; SI-NEXT:    v_mul_hi_u32 v4, v2, s4
; SI-NEXT:    v_mul_lo_u32 v5, v3, s4
; SI-NEXT:    v_mul_lo_u32 v6, v2, s4
; SI-NEXT:    v_subrev_i32_e32 v4, vcc, v2, v4
; SI-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; SI-NEXT:    v_mul_lo_u32 v5, v2, v4
; SI-NEXT:    v_mul_hi_u32 v7, v2, v6
; SI-NEXT:    v_mul_hi_u32 v8, v2, v4
; SI-NEXT:    v_mul_hi_u32 v10, v3, v4
; SI-NEXT:    v_mul_lo_u32 v4, v3, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, v7, v5
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v8, vcc
; SI-NEXT:    v_mul_lo_u32 v8, v3, v6
; SI-NEXT:    v_mul_hi_u32 v6, v3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, v5, v8
; SI-NEXT:    v_addc_u32_e32 v5, vcc, v7, v6, vcc
; SI-NEXT:    v_addc_u32_e32 v6, vcc, v10, v9, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v6, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; SI-NEXT:    v_addc_u32_e32 v3, vcc, v3, v5, vcc
; SI-NEXT:    v_mul_hi_u32 v4, v2, s4
; SI-NEXT:    v_mul_lo_u32 v5, v3, s4
; SI-NEXT:    v_mul_lo_u32 v6, v2, s4
; SI-NEXT:    s_mov_b32 s4, 0x186a0
; SI-NEXT:    v_subrev_i32_e32 v4, vcc, v2, v4
; SI-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; SI-NEXT:    v_mul_lo_u32 v5, v2, v4
; SI-NEXT:    v_mul_hi_u32 v7, v2, v6
; SI-NEXT:    v_mul_hi_u32 v8, v2, v4
; SI-NEXT:    v_mul_hi_u32 v10, v3, v4
; SI-NEXT:    v_mul_lo_u32 v4, v3, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, v7, v5
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v8, vcc
; SI-NEXT:    v_mul_lo_u32 v8, v3, v6
; SI-NEXT:    v_mul_hi_u32 v6, v3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, v5, v8
; SI-NEXT:    v_addc_u32_e32 v5, vcc, v7, v6, vcc
; SI-NEXT:    v_addc_u32_e32 v6, vcc, v10, v9, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v6, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; SI-NEXT:    v_addc_u32_e32 v3, vcc, v3, v5, vcc
; SI-NEXT:    v_mul_lo_u32 v4, v0, v3
; SI-NEXT:    v_mul_hi_u32 v5, v0, v2
; SI-NEXT:    v_mul_hi_u32 v6, v0, v3
; SI-NEXT:    v_mul_hi_u32 v7, v1, v3
; SI-NEXT:    v_mul_lo_u32 v3, v1, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v6, vcc
; SI-NEXT:    v_mul_lo_u32 v6, v1, v2
; SI-NEXT:    v_mul_hi_u32 v2, v1, v2
; SI-NEXT:    v_add_i32_e32 v4, vcc, v4, v6
; SI-NEXT:    v_addc_u32_e32 v2, vcc, v5, v2, vcc
; SI-NEXT:    v_addc_u32_e32 v4, vcc, v7, v9, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; SI-NEXT:    v_mul_lo_u32 v4, v3, s4
; SI-NEXT:    v_mul_hi_u32 v5, v2, s4
; SI-NEXT:    v_mul_lo_u32 v6, v2, s4
; SI-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; SI-NEXT:    v_sub_i32_e32 v0, vcc, v0, v6
; SI-NEXT:    v_subb_u32_e32 v1, vcc, v1, v4, vcc
; SI-NEXT:    v_subrev_i32_e32 v4, vcc, s4, v0
; SI-NEXT:    v_subbrev_u32_e32 v5, vcc, 0, v1, vcc
; SI-NEXT:    s_mov_b32 s4, 0x1869f
; SI-NEXT:    v_cmp_lt_u32_e32 vcc, s4, v4
; SI-NEXT:    v_cndmask_b32_e64 v4, 0, -1, vcc
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; SI-NEXT:    v_cndmask_b32_e32 v4, -1, v4, vcc
; SI-NEXT:    v_add_i32_e32 v5, vcc, 2, v2
; SI-NEXT:    v_addc_u32_e32 v6, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v7, vcc, 1, v2
; SI-NEXT:    v_cmp_lt_u32_e64 s[4:5], s4, v0
; SI-NEXT:    v_addc_u32_e32 v8, vcc, 0, v3, vcc
; SI-NEXT:    v_cndmask_b32_e64 v0, 0, -1, s[4:5]
; SI-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_cndmask_b32_e64 v0, -1, v0, s[4:5]
; SI-NEXT:    v_cndmask_b32_e32 v4, v7, v5, vcc
; SI-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v0
; SI-NEXT:    v_cndmask_b32_e32 v1, v8, v6, vcc
; SI-NEXT:    v_cndmask_b32_e64 v0, v2, v4, s[4:5]
; SI-NEXT:    v_cndmask_b32_e64 v1, v3, v1, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_test_udiv64_mulhi_fold:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, 0x4f800000
; VI-NEXT:    v_madak_f32 v2, 0, v2, 0x47c35000
; VI-NEXT:    v_rcp_f32_e32 v2, v2
; VI-NEXT:    s_mov_b32 s6, 0xfffe7960
; VI-NEXT:    v_mov_b32_e32 v9, 0
; VI-NEXT:    v_mul_f32_e32 v2, 0x5f7ffffc, v2
; VI-NEXT:    v_mul_f32_e32 v3, 0x2f800000, v2
; VI-NEXT:    v_trunc_f32_e32 v3, v3
; VI-NEXT:    v_mac_f32_e32 v2, 0xcf800000, v3
; VI-NEXT:    v_cvt_u32_f32_e32 v6, v2
; VI-NEXT:    v_cvt_u32_f32_e32 v7, v3
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v6, s6, 0
; VI-NEXT:    v_mul_lo_u32 v4, v7, s6
; VI-NEXT:    v_subrev_u32_e32 v3, vcc, v6, v3
; VI-NEXT:    v_add_u32_e32 v5, vcc, v4, v3
; VI-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v6, v5, 0
; VI-NEXT:    v_mul_hi_u32 v8, v6, v2
; VI-NEXT:    v_add_u32_e32 v8, vcc, v8, v3
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v7, v2, 0
; VI-NEXT:    v_addc_u32_e32 v10, vcc, 0, v4, vcc
; VI-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v7, v5, 0
; VI-NEXT:    v_add_u32_e32 v2, vcc, v8, v2
; VI-NEXT:    v_addc_u32_e32 v2, vcc, v10, v3, vcc
; VI-NEXT:    v_addc_u32_e32 v3, vcc, v5, v9, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; VI-NEXT:    v_addc_u32_e32 v7, vcc, v7, v3, vcc
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v6, s6, 0
; VI-NEXT:    v_mul_lo_u32 v4, v7, s6
; VI-NEXT:    s_mov_b32 s6, 0x186a0
; VI-NEXT:    v_subrev_u32_e32 v3, vcc, v6, v3
; VI-NEXT:    v_add_u32_e32 v5, vcc, v3, v4
; VI-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v6, v5, 0
; VI-NEXT:    v_mul_hi_u32 v8, v6, v2
; VI-NEXT:    v_add_u32_e32 v8, vcc, v8, v3
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v7, v2, 0
; VI-NEXT:    v_addc_u32_e32 v10, vcc, 0, v4, vcc
; VI-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v7, v5, 0
; VI-NEXT:    v_add_u32_e32 v2, vcc, v8, v2
; VI-NEXT:    v_addc_u32_e32 v2, vcc, v10, v3, vcc
; VI-NEXT:    v_addc_u32_e32 v3, vcc, v5, v9, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, v6, v2
; VI-NEXT:    v_addc_u32_e32 v5, vcc, v7, v3, vcc
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v0, v5, 0
; VI-NEXT:    v_mul_hi_u32 v6, v0, v4
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v3, vcc
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v1, v4, 0
; VI-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v1, v5, 0
; VI-NEXT:    v_add_u32_e32 v2, vcc, v6, v2
; VI-NEXT:    v_addc_u32_e32 v2, vcc, v7, v3, vcc
; VI-NEXT:    v_addc_u32_e32 v3, vcc, v5, v9, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, v2, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v3, vcc
; VI-NEXT:    v_mul_lo_u32 v6, v5, s6
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v4, s6, 0
; VI-NEXT:    s_mov_b32 s4, 0x1869f
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v6
; VI-NEXT:    v_sub_u32_e32 v0, vcc, v0, v2
; VI-NEXT:    v_subb_u32_e32 v1, vcc, v1, v3, vcc
; VI-NEXT:    v_subrev_u32_e32 v2, vcc, s6, v0
; VI-NEXT:    v_subbrev_u32_e32 v3, vcc, 0, v1, vcc
; VI-NEXT:    v_cmp_lt_u32_e32 vcc, s4, v2
; VI-NEXT:    v_cndmask_b32_e64 v2, 0, -1, vcc
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; VI-NEXT:    v_cndmask_b32_e32 v2, -1, v2, vcc
; VI-NEXT:    v_add_u32_e32 v3, vcc, 2, v4
; VI-NEXT:    v_addc_u32_e32 v6, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v7, vcc, 1, v4
; VI-NEXT:    v_cmp_lt_u32_e64 s[4:5], s4, v0
; VI-NEXT:    v_addc_u32_e32 v8, vcc, 0, v5, vcc
; VI-NEXT:    v_cndmask_b32_e64 v0, 0, -1, s[4:5]
; VI-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v1
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    v_cndmask_b32_e64 v0, -1, v0, s[4:5]
; VI-NEXT:    v_cndmask_b32_e32 v2, v7, v3, vcc
; VI-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v1, v8, v6, vcc
; VI-NEXT:    v_cndmask_b32_e64 v0, v4, v2, s[4:5]
; VI-NEXT:    v_cndmask_b32_e64 v1, v5, v1, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-LABEL: v_test_udiv64_mulhi_fold:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v2, 0x4f800000
; GCN-NEXT:    v_madak_f32 v2, 0, v2, 0x47c35000
; GCN-NEXT:    v_rcp_f32_e32 v2, v2
; GCN-NEXT:    s_mov_b32 s6, 0xfffe7960
; GCN-NEXT:    v_mov_b32_e32 v9, 0
; GCN-NEXT:    v_mul_f32_e32 v2, 0x5f7ffffc, v2
; GCN-NEXT:    v_mul_f32_e32 v3, 0x2f800000, v2
; GCN-NEXT:    v_trunc_f32_e32 v3, v3
; GCN-NEXT:    v_mac_f32_e32 v2, 0xcf800000, v3
; GCN-NEXT:    v_cvt_u32_f32_e32 v6, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v7, v3
; GCN-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v6, s6, 0
; GCN-NEXT:    v_mul_lo_u32 v4, v7, s6
; GCN-NEXT:    v_subrev_u32_e32 v3, vcc, v6, v3
; GCN-NEXT:    v_add_u32_e32 v5, vcc, v4, v3
; GCN-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v6, v5, 0
; GCN-NEXT:    v_mul_hi_u32 v8, v6, v2
; GCN-NEXT:    v_add_u32_e32 v8, vcc, v8, v3
; GCN-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v7, v2, 0
; GCN-NEXT:    v_addc_u32_e32 v10, vcc, 0, v4, vcc
; GCN-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v7, v5, 0
; GCN-NEXT:    v_add_u32_e32 v2, vcc, v8, v2
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, v10, v3, vcc
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v5, v9, vcc
; GCN-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GCN-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v7, v3, vcc
; GCN-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v6, s6, 0
; GCN-NEXT:    v_mul_lo_u32 v4, v7, s6
; GCN-NEXT:    s_mov_b32 s6, 0x186a0
; GCN-NEXT:    v_subrev_u32_e32 v3, vcc, v6, v3
; GCN-NEXT:    v_add_u32_e32 v5, vcc, v3, v4
; GCN-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], v6, v5, 0
; GCN-NEXT:    v_mul_hi_u32 v8, v6, v2
; GCN-NEXT:    v_add_u32_e32 v8, vcc, v8, v3
; GCN-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v7, v2, 0
; GCN-NEXT:    v_addc_u32_e32 v10, vcc, 0, v4, vcc
; GCN-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v7, v5, 0
; GCN-NEXT:    v_add_u32_e32 v2, vcc, v8, v2
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, v10, v3, vcc
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v5, v9, vcc
; GCN-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GCN-NEXT:    v_add_u32_e32 v4, vcc, v6, v2
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v7, v3, vcc
; GCN-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v0, v5, 0
; GCN-NEXT:    v_mul_hi_u32 v6, v0, v4
; GCN-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, 0, v3, vcc
; GCN-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v1, v4, 0
; GCN-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v1, v5, 0
; GCN-NEXT:    v_add_u32_e32 v2, vcc, v6, v2
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, v7, v3, vcc
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v5, v9, vcc
; GCN-NEXT:    v_add_u32_e32 v4, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, 0, v3, vcc
; GCN-NEXT:    v_mul_lo_u32 v6, v5, s6
; GCN-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], v4, s6, 0
; GCN-NEXT:    s_mov_b32 s4, 0x1869f
; GCN-NEXT:    v_add_u32_e32 v3, vcc, v3, v6
; GCN-NEXT:    v_sub_u32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, v1, v3, vcc
; GCN-NEXT:    v_subrev_u32_e32 v2, vcc, s6, v0
; GCN-NEXT:    v_subbrev_u32_e32 v3, vcc, 0, v1, vcc
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc, s4, v2
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GCN-NEXT:    v_cndmask_b32_e32 v2, -1, v2, vcc
; GCN-NEXT:    v_add_u32_e32 v3, vcc, 2, v4
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, 0, v5, vcc
; GCN-NEXT:    v_add_u32_e32 v7, vcc, 1, v4
; GCN-NEXT:    v_cmp_lt_u32_e64 s[4:5], s4, v0
; GCN-NEXT:    v_addc_u32_e32 v8, vcc, 0, v5, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, -1, s[4:5]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v1
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, -1, v0, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e32 v2, v7, v3, vcc
; GCN-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v8, v6, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, v4, v2, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v1, v5, v1, s[4:5]
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1030-LABEL: v_test_udiv64_mulhi_fold:
; GFX1030:       ; %bb.0:
; GFX1030-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-NEXT:    s_mov_b32 s4, 0x346d900
; GFX1030-NEXT:    s_mov_b32 s5, 0xfffe7960
; GFX1030-NEXT:    s_add_u32 s4, 0x4237, s4
; GFX1030-NEXT:    s_addc_u32 s6, 0, 0
; GFX1030-NEXT:    v_add_co_u32 v2, s4, 0xa9000000, s4
; GFX1030-NEXT:    s_cmpk_lg_u32 s4, 0x0
; GFX1030-NEXT:    s_addc_u32 s4, s6, 0xa7c5
; GFX1030-NEXT:    v_mul_hi_u32 v3, v2, s5
; GFX1030-NEXT:    v_mul_lo_u32 v4, v2, s5
; GFX1030-NEXT:    s_mul_i32 s5, s4, s5
; GFX1030-NEXT:    v_sub_nc_u32_e32 v3, v3, v2
; GFX1030-NEXT:    v_mul_hi_u32 v5, v2, v4
; GFX1030-NEXT:    v_mul_hi_u32 v8, s4, v4
; GFX1030-NEXT:    v_mul_lo_u32 v4, s4, v4
; GFX1030-NEXT:    v_add_nc_u32_e32 v3, s5, v3
; GFX1030-NEXT:    v_mul_lo_u32 v6, v2, v3
; GFX1030-NEXT:    v_mul_hi_u32 v7, v2, v3
; GFX1030-NEXT:    v_mul_hi_u32 v9, s4, v3
; GFX1030-NEXT:    v_mul_lo_u32 v3, s4, v3
; GFX1030-NEXT:    v_add_co_u32 v5, vcc_lo, v5, v6
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v6, vcc_lo, 0, v7, vcc_lo
; GFX1030-NEXT:    v_add_co_u32 v4, vcc_lo, v5, v4
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, v6, v8, vcc_lo
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, 0, v9, vcc_lo
; GFX1030-NEXT:    v_add_co_u32 v3, vcc_lo, v4, v3
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v4, vcc_lo, 0, v5, vcc_lo
; GFX1030-NEXT:    v_add_co_u32 v5, vcc_lo, v2, v3
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v6, vcc_lo, s4, v4, vcc_lo
; GFX1030-NEXT:    v_mul_hi_u32 v8, v0, v5
; GFX1030-NEXT:    v_mad_u64_u32 v[4:5], s4, v1, v5, 0
; GFX1030-NEXT:    v_mad_u64_u32 v[2:3], s4, v0, v6, 0
; GFX1030-NEXT:    v_mad_u64_u32 v[6:7], s4, v1, v6, 0
; GFX1030-NEXT:    s_mov_b32 s4, 0x186a0
; GFX1030-NEXT:    v_add_co_u32 v2, vcc_lo, v8, v2
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, 0, v3, vcc_lo
; GFX1030-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v4
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v3, v5, vcc_lo
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, 0, v7, vcc_lo
; GFX1030-NEXT:    v_add_co_u32 v4, vcc_lo, v2, v6
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, 0, v3, vcc_lo
; GFX1030-NEXT:    v_mad_u64_u32 v[2:3], s5, v4, s4, 0
; GFX1030-NEXT:    v_mul_lo_u32 v6, v5, s4
; GFX1030-NEXT:    v_sub_co_u32 v0, vcc_lo, v0, v2
; GFX1030-NEXT:    v_add_nc_u32_e32 v3, v3, v6
; GFX1030-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX1030-NEXT:    v_sub_co_u32 v2, vcc_lo, v0, s4
; GFX1030-NEXT:    s_mov_b32 s4, 0x1869f
; GFX1030-NEXT:    v_subrev_co_ci_u32_e32 v3, vcc_lo, 0, v1, vcc_lo
; GFX1030-NEXT:    v_cmp_lt_u32_e32 vcc_lo, s4, v2
; GFX1030-NEXT:    v_cndmask_b32_e64 v2, 0, -1, vcc_lo
; GFX1030-NEXT:    v_add_co_u32 v6, vcc_lo, v4, 2
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, 0, v5, vcc_lo
; GFX1030-NEXT:    v_cmp_lt_u32_e32 vcc_lo, s4, v0
; GFX1030-NEXT:    v_cmp_eq_u32_e64 s4, 0, v1
; GFX1030-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX1030-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v3
; GFX1030-NEXT:    v_cndmask_b32_e64 v0, -1, v0, s4
; GFX1030-NEXT:    v_cndmask_b32_e32 v2, -1, v2, vcc_lo
; GFX1030-NEXT:    v_add_co_u32 v3, vcc_lo, v4, 1
; GFX1030-NEXT:    v_add_co_ci_u32_e32 v8, vcc_lo, 0, v5, vcc_lo
; GFX1030-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX1030-NEXT:    v_cndmask_b32_e32 v1, v3, v6, vcc_lo
; GFX1030-NEXT:    v_cndmask_b32_e32 v2, v8, v7, vcc_lo
; GFX1030-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX1030-NEXT:    v_cndmask_b32_e32 v0, v4, v1, vcc_lo
; GFX1030-NEXT:    v_cndmask_b32_e32 v1, v5, v2, vcc_lo
; GFX1030-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: v_test_udiv64_mulhi_fold:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %d = udiv i64 %arg, 100000
  ret i64 %d
}
