; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-darwin-unknown < %s | FileCheck %s --check-prefix=X64
; RUN: llc -mtriple=i686-darwin-unknown < %s | FileCheck %s --check-prefix=X86

define zeroext i1 @smuloi128(i128 %v1, i128 %v2, i128* %res) {
; X64-LABEL: smuloi128:
; X64:       ## %bb.0:
; X64-NEXT:    pushq %r15
; X64-NEXT:    .cfi_def_cfa_offset 16
; X64-NEXT:    pushq %r14
; X64-NEXT:    .cfi_def_cfa_offset 24
; X64-NEXT:    pushq %r12
; X64-NEXT:    .cfi_def_cfa_offset 32
; X64-NEXT:    pushq %rbx
; X64-NEXT:    .cfi_def_cfa_offset 40
; X64-NEXT:    .cfi_offset %rbx, -40
; X64-NEXT:    .cfi_offset %r12, -32
; X64-NEXT:    .cfi_offset %r14, -24
; X64-NEXT:    .cfi_offset %r15, -16
; X64-NEXT:    movq %rdx, %r12
; X64-NEXT:    movq %rsi, %r10
; X64-NEXT:    movq %rdi, %r15
; X64-NEXT:    sarq $63, %rsi
; X64-NEXT:    movq %rdx, %rdi
; X64-NEXT:    imulq %rsi, %rdi
; X64-NEXT:    movq %rdx, %rax
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rax, %r9
; X64-NEXT:    addq %rdi, %rdx
; X64-NEXT:    imulq %rcx, %rsi
; X64-NEXT:    addq %rdx, %rsi
; X64-NEXT:    movq %rcx, %rdi
; X64-NEXT:    sarq $63, %rdi
; X64-NEXT:    movq %rdi, %rbx
; X64-NEXT:    imulq %r10, %rbx
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    mulq %r15
; X64-NEXT:    movq %rax, %r11
; X64-NEXT:    addq %rbx, %rdx
; X64-NEXT:    imulq %r15, %rdi
; X64-NEXT:    addq %rdx, %rdi
; X64-NEXT:    addq %r9, %r11
; X64-NEXT:    adcq %rsi, %rdi
; X64-NEXT:    movq %r15, %rax
; X64-NEXT:    mulq %r12
; X64-NEXT:    movq %rdx, %r14
; X64-NEXT:    movq %rax, %r9
; X64-NEXT:    movq %r10, %rax
; X64-NEXT:    mulq %r12
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    movq %rax, %rsi
; X64-NEXT:    addq %r14, %rsi
; X64-NEXT:    adcq $0, %rbx
; X64-NEXT:    movq %r15, %rax
; X64-NEXT:    mulq %rcx
; X64-NEXT:    movq %rdx, %r15
; X64-NEXT:    movq %rax, %r14
; X64-NEXT:    addq %rsi, %r14
; X64-NEXT:    adcq %rbx, %r15
; X64-NEXT:    setb %al
; X64-NEXT:    movzbl %al, %esi
; X64-NEXT:    movq %r10, %rax
; X64-NEXT:    mulq %rcx
; X64-NEXT:    addq %r15, %rax
; X64-NEXT:    adcq %rsi, %rdx
; X64-NEXT:    addq %r11, %rax
; X64-NEXT:    adcq %rdi, %rdx
; X64-NEXT:    movq %r14, 8(%r8)
; X64-NEXT:    sarq $63, %r14
; X64-NEXT:    xorq %r14, %rdx
; X64-NEXT:    xorq %rax, %r14
; X64-NEXT:    orq %rdx, %r14
; X64-NEXT:    setne %al
; X64-NEXT:    movq %r9, (%r8)
; X64-NEXT:    popq %rbx
; X64-NEXT:    popq %r12
; X64-NEXT:    popq %r14
; X64-NEXT:    popq %r15
; X64-NEXT:    retq
;
; X86-LABEL: smuloi128:
; X86:       ## %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    pushl %ebx
; X86-NEXT:    .cfi_def_cfa_offset 12
; X86-NEXT:    pushl %edi
; X86-NEXT:    .cfi_def_cfa_offset 16
; X86-NEXT:    pushl %esi
; X86-NEXT:    .cfi_def_cfa_offset 20
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    .cfi_def_cfa_offset 72
; X86-NEXT:    .cfi_offset %esi, -20
; X86-NEXT:    .cfi_offset %edi, -16
; X86-NEXT:    .cfi_offset %ebx, -12
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %ebx, %esi
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %ecx, %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %ecx, %edi
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %ebp, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %ebx, %ecx
; X86-NEXT:    setb %bl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %edi
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    movl %eax, (%esp) ## 4-byte Spill
; X86-NEXT:    movzbl %bl, %eax
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %ecx, %ebp
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    addl %ebp, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %ebx, %edi
; X86-NEXT:    setb %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    addl %edi, %ebx
; X86-NEXT:    movzbl %cl, %eax
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, (%esp) ## 4-byte Folded Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %edi, %esi
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %esi, %eax
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    adcl %ebp, %ecx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %ecx, %esi
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %ebp
; X86-NEXT:    addl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Folded Reload
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    addl (%esp), %esi ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Folded Reload
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %edx, (%esp) ## 4-byte Spill
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    addl (%esp), %ecx ## 4-byte Folded Reload
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    mull %edx
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    adcl %ebx, %edi
; X86-NEXT:    setb %bl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    movzbl %bl, %eax
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    addl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    adcl %ebp, %ecx
; X86-NEXT:    movl %ecx, (%esp) ## 4-byte Spill
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %edi
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    sarl $31, %ebx
; X86-NEXT:    movl %ebx, %esi
; X86-NEXT:    imull {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    addl %esi, %edx
; X86-NEXT:    imull %ebx, %ecx
; X86-NEXT:    addl %edx, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %ebx, %edi
; X86-NEXT:    imull {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %edi, %edx
; X86-NEXT:    movl %ebx, %ebp
; X86-NEXT:    imull %ecx, %ebp
; X86-NEXT:    addl %edx, %ebp
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Folded Reload
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Folded Reload
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    addl %edi, %ebx
; X86-NEXT:    movl %esi, %edx
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    addl %ecx, %ebx
; X86-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %edi, %edx
; X86-NEXT:    setb %cl
; X86-NEXT:    addl %eax, %edx
; X86-NEXT:    movzbl %cl, %eax
; X86-NEXT:    adcl %esi, %eax
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %ebp, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    sarl $31, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    imull %ecx, %edi
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    addl %edi, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    imull %ecx, %edi
; X86-NEXT:    addl %edx, %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    imull %ecx, %ebp
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %ebp, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    imull %ecx, %eax
; X86-NEXT:    addl %edx, %eax
; X86-NEXT:    addl %ebx, %esi
; X86-NEXT:    movl %esi, %ebx
; X86-NEXT:    adcl %edi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %edx, %esi
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %eax, %esi
; X86-NEXT:    adcl %edx, %ebp
; X86-NEXT:    setb %cl
; X86-NEXT:    addl %eax, %ebp
; X86-NEXT:    movzbl %cl, %eax
; X86-NEXT:    adcl %edx, %eax
; X86-NEXT:    addl %ebx, %ebp
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Folded Reload
; X86-NEXT:    adcl (%esp), %esi ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Reload
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    sarl $31, %ecx
; X86-NEXT:    xorl %ecx, %eax
; X86-NEXT:    xorl %ecx, %esi
; X86-NEXT:    orl %eax, %esi
; X86-NEXT:    xorl %ecx, %ebp
; X86-NEXT:    xorl %edi, %ecx
; X86-NEXT:    orl %ebp, %ecx
; X86-NEXT:    orl %esi, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %edx, 12(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    movl %ecx, 4(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    movl %ecx, 8(%eax)
; X86-NEXT:    setne %al
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %t = call {i128, i1} @llvm.smul.with.overflow.i128(i128 %v1, i128 %v2)
  %val = extractvalue {i128, i1} %t, 0
  %obit = extractvalue {i128, i1} %t, 1
  store i128 %val, i128* %res
  ret i1 %obit
}

define zeroext i1 @smuloi256(i256 %v1, i256 %v2, i256* %res) {
; X64-LABEL: smuloi256:
; X64:       ## %bb.0:
; X64-NEXT:    pushq %rbp
; X64-NEXT:    .cfi_def_cfa_offset 16
; X64-NEXT:    pushq %r15
; X64-NEXT:    .cfi_def_cfa_offset 24
; X64-NEXT:    pushq %r14
; X64-NEXT:    .cfi_def_cfa_offset 32
; X64-NEXT:    pushq %r13
; X64-NEXT:    .cfi_def_cfa_offset 40
; X64-NEXT:    pushq %r12
; X64-NEXT:    .cfi_def_cfa_offset 48
; X64-NEXT:    pushq %rbx
; X64-NEXT:    .cfi_def_cfa_offset 56
; X64-NEXT:    .cfi_offset %rbx, -56
; X64-NEXT:    .cfi_offset %r12, -48
; X64-NEXT:    .cfi_offset %r13, -40
; X64-NEXT:    .cfi_offset %r14, -32
; X64-NEXT:    .cfi_offset %r15, -24
; X64-NEXT:    .cfi_offset %rbp, -16
; X64-NEXT:    movq %rcx, %r15
; X64-NEXT:    movq %rdx, %r11
; X64-NEXT:    movq %rdx, %rax
; X64-NEXT:    movq %rdx, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %r10
; X64-NEXT:    movq %rax, %r14
; X64-NEXT:    movq %rcx, %rax
; X64-NEXT:    movq %rcx, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    movq %rax, %rbp
; X64-NEXT:    addq %r10, %rbp
; X64-NEXT:    adcq $0, %rbx
; X64-NEXT:    movq %r11, %rax
; X64-NEXT:    mulq %r9
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq %rax, %r11
; X64-NEXT:    addq %rbp, %r11
; X64-NEXT:    adcq %rbx, %rcx
; X64-NEXT:    setb %al
; X64-NEXT:    movzbl %al, %ebp
; X64-NEXT:    movq %r15, %rax
; X64-NEXT:    mulq %r9
; X64-NEXT:    movq %r9, %r15
; X64-NEXT:    movq %rdx, %r12
; X64-NEXT:    movq %rax, %r10
; X64-NEXT:    addq %rcx, %r10
; X64-NEXT:    adcq %rbp, %r12
; X64-NEXT:    movq %rdi, %r9
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq %r8, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rbp
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    movq %rsi, %rcx
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    movq %rax, %rsi
; X64-NEXT:    addq %rbp, %rsi
; X64-NEXT:    adcq $0, %rbx
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq %r15, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    mulq %r15
; X64-NEXT:    movq %rdx, %rbp
; X64-NEXT:    addq %rsi, %rax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    adcq %rbx, %rbp
; X64-NEXT:    setb %bl
; X64-NEXT:    movq %rcx, %rax
; X64-NEXT:    movq %rcx, %rdi
; X64-NEXT:    mulq %r15
; X64-NEXT:    movq %rdx, %r15
; X64-NEXT:    movq %rax, %rcx
; X64-NEXT:    addq %rbp, %rcx
; X64-NEXT:    movzbl %bl, %eax
; X64-NEXT:    adcq %rax, %r15
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r8
; X64-NEXT:    addq %r14, %rcx
; X64-NEXT:    adcq %r11, %r15
; X64-NEXT:    adcq $0, %r10
; X64-NEXT:    adcq $0, %r12
; X64-NEXT:    movq %r9, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    movq %r9, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rsi
; X64-NEXT:    movq %rax, %r11
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq %rdi, %r14
; X64-NEXT:    movq %rdi, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rbp
; X64-NEXT:    movq %rax, %rdi
; X64-NEXT:    addq %rsi, %rdi
; X64-NEXT:    adcq $0, %rbp
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; X64-NEXT:    movq %r9, %rax
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    addq %rdi, %rax
; X64-NEXT:    movq %rax, %rdi
; X64-NEXT:    adcq %rbp, %rbx
; X64-NEXT:    setb %r9b
; X64-NEXT:    movq %r14, %rax
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rdx, %r13
; X64-NEXT:    movq %rax, %r14
; X64-NEXT:    addq %rbx, %r14
; X64-NEXT:    movzbl %r9b, %eax
; X64-NEXT:    adcq %rax, %r13
; X64-NEXT:    addq %rcx, %r11
; X64-NEXT:    movq %r11, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    adcq %r15, %rdi
; X64-NEXT:    movq %rdi, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    adcq $0, %r14
; X64-NEXT:    adcq $0, %r13
; X64-NEXT:    addq %r10, %r14
; X64-NEXT:    adcq %r12, %r13
; X64-NEXT:    setb %r9b
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rbp ## 8-byte Reload
; X64-NEXT:    movq %rbp, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq %rax, %r10
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %r12 ## 8-byte Reload
; X64-NEXT:    movq %r12, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rdi
; X64-NEXT:    movq %rax, %rbx
; X64-NEXT:    addq %rcx, %rbx
; X64-NEXT:    adcq $0, %rdi
; X64-NEXT:    movq %rbp, %rax
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    addq %rbx, %rax
; X64-NEXT:    movq %rax, %rbp
; X64-NEXT:    adcq %rdi, %rcx
; X64-NEXT:    setb %bl
; X64-NEXT:    movq %r12, %rax
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rax, %r11
; X64-NEXT:    addq %rcx, %r11
; X64-NEXT:    movzbl %bl, %eax
; X64-NEXT:    adcq %rax, %rdx
; X64-NEXT:    addq %r14, %r10
; X64-NEXT:    movq %r10, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    adcq %r13, %rbp
; X64-NEXT:    movq %rbp, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    movzbl %r9b, %eax
; X64-NEXT:    adcq %rax, %r11
; X64-NEXT:    adcq $0, %rdx
; X64-NEXT:    movq %rdx, {{[-0-9]+}}(%r{{[sb]}}p) ## 8-byte Spill
; X64-NEXT:    movq %r12, %rdi
; X64-NEXT:    sarq $63, %rdi
; X64-NEXT:    movq %rdi, %rcx
; X64-NEXT:    imulq %rsi, %rcx
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rax, %rbx
; X64-NEXT:    addq %rcx, %rdx
; X64-NEXT:    imulq %rdi, %r8
; X64-NEXT:    addq %rdx, %r8
; X64-NEXT:    movq %rdi, %rcx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %r9 ## 8-byte Reload
; X64-NEXT:    imulq %r9, %rcx
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rbp ## 8-byte Reload
; X64-NEXT:    mulq %rbp
; X64-NEXT:    movq %rax, %r13
; X64-NEXT:    addq %rcx, %rdx
; X64-NEXT:    movq %rdi, %rcx
; X64-NEXT:    imulq %rbp, %rcx
; X64-NEXT:    movq %rbp, %rax
; X64-NEXT:    addq %rdx, %rcx
; X64-NEXT:    addq %rbx, %r13
; X64-NEXT:    adcq %r8, %rcx
; X64-NEXT:    mulq %rdi
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    movq %rax, %r14
; X64-NEXT:    movq %r9, %rax
; X64-NEXT:    mulq %rdi
; X64-NEXT:    movq %rax, %r8
; X64-NEXT:    addq %rbx, %r8
; X64-NEXT:    movq %rdx, %rbp
; X64-NEXT:    adcq $0, %rbp
; X64-NEXT:    addq %r14, %r8
; X64-NEXT:    adcq %rbx, %rbp
; X64-NEXT:    setb %bl
; X64-NEXT:    addq %rax, %rbp
; X64-NEXT:    movzbl %bl, %r15d
; X64-NEXT:    adcq %rdx, %r15
; X64-NEXT:    addq %r13, %rbp
; X64-NEXT:    adcq %rcx, %r15
; X64-NEXT:    sarq $63, %rsi
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %r10 ## 8-byte Reload
; X64-NEXT:    movq %r10, %rcx
; X64-NEXT:    imulq %rsi, %rcx
; X64-NEXT:    movq %r10, %rax
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rax, %rdi
; X64-NEXT:    addq %rcx, %rdx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %r9 ## 8-byte Reload
; X64-NEXT:    movq %r9, %rcx
; X64-NEXT:    imulq %rsi, %rcx
; X64-NEXT:    addq %rdx, %rcx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax ## 8-byte Reload
; X64-NEXT:    movq %rax, %rbx
; X64-NEXT:    imulq %rsi, %rbx
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rax, %r13
; X64-NEXT:    addq %rbx, %rdx
; X64-NEXT:    movq %r12, %rax
; X64-NEXT:    imulq %rsi, %rax
; X64-NEXT:    addq %rdx, %rax
; X64-NEXT:    addq %rdi, %r13
; X64-NEXT:    adcq %rcx, %rax
; X64-NEXT:    movq %rax, %r12
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    mulq %r10
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    movq %rax, %rcx
; X64-NEXT:    movq %rax, %rdi
; X64-NEXT:    addq %rdx, %rdi
; X64-NEXT:    adcq $0, %rbx
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    mulq %r9
; X64-NEXT:    addq %rax, %rdi
; X64-NEXT:    adcq %rdx, %rbx
; X64-NEXT:    setb %sil
; X64-NEXT:    addq %rax, %rbx
; X64-NEXT:    movzbl %sil, %eax
; X64-NEXT:    adcq %rdx, %rax
; X64-NEXT:    addq %r13, %rbx
; X64-NEXT:    adcq %r12, %rax
; X64-NEXT:    addq %r14, %rcx
; X64-NEXT:    adcq %r8, %rdi
; X64-NEXT:    adcq %rbp, %rbx
; X64-NEXT:    adcq %r15, %rax
; X64-NEXT:    addq {{[-0-9]+}}(%r{{[sb]}}p), %rcx ## 8-byte Folded Reload
; X64-NEXT:    adcq {{[-0-9]+}}(%r{{[sb]}}p), %rdi ## 8-byte Folded Reload
; X64-NEXT:    adcq %r11, %rbx
; X64-NEXT:    adcq {{[-0-9]+}}(%r{{[sb]}}p), %rax ## 8-byte Folded Reload
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rsi ## 8-byte Reload
; X64-NEXT:    movq %rsi, %rdx
; X64-NEXT:    sarq $63, %rdx
; X64-NEXT:    xorq %rdx, %rax
; X64-NEXT:    xorq %rdx, %rdi
; X64-NEXT:    orq %rax, %rdi
; X64-NEXT:    xorq %rdx, %rbx
; X64-NEXT:    xorq %rcx, %rdx
; X64-NEXT:    orq %rbx, %rdx
; X64-NEXT:    orq %rdi, %rdx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    movq %rsi, 24(%rax)
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx ## 8-byte Reload
; X64-NEXT:    movq %rcx, (%rax)
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx ## 8-byte Reload
; X64-NEXT:    movq %rcx, 8(%rax)
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx ## 8-byte Reload
; X64-NEXT:    movq %rcx, 16(%rax)
; X64-NEXT:    setne %al
; X64-NEXT:    popq %rbx
; X64-NEXT:    popq %r12
; X64-NEXT:    popq %r13
; X64-NEXT:    popq %r14
; X64-NEXT:    popq %r15
; X64-NEXT:    popq %rbp
; X64-NEXT:    retq
;
; X86-LABEL: smuloi256:
; X86:       ## %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    pushl %ebx
; X86-NEXT:    .cfi_def_cfa_offset 12
; X86-NEXT:    pushl %edi
; X86-NEXT:    .cfi_def_cfa_offset 16
; X86-NEXT:    pushl %esi
; X86-NEXT:    .cfi_def_cfa_offset 20
; X86-NEXT:    subl $152, %esp
; X86-NEXT:    .cfi_def_cfa_offset 172
; X86-NEXT:    .cfi_offset %esi, -20
; X86-NEXT:    .cfi_offset %edi, -16
; X86-NEXT:    .cfi_offset %ebx, -12
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, (%esp) ## 4-byte Spill
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ecx, %edi
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %esi, %ecx
; X86-NEXT:    setb %bl
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ecx, %edi
; X86-NEXT:    movzbl %bl, %eax
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %ebx, %ebp
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    addl %ebp, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %esi, %ebx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %ebx, %esi
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    addl (%esp), %esi ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    movl %ecx, (%esp) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ebx, %edi
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    adcl %ebp, %ecx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %ecx, %ebp
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %ebx
; X86-NEXT:    addl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Folded Reload
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Folded Reload
; X86-NEXT:    adcl (%esp), %ebx ## 4-byte Folded Reload
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, (%esp) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ecx, %edi
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    adcl %esi, %ecx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 1-byte Folded Reload
; X86-NEXT:    adcl %ecx, %edx
; X86-NEXT:    addl %ebp, (%esp) ## 4-byte Folded Spill
; X86-NEXT:    adcl %ebx, %edi
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 1-byte Folded Reload
; X86-NEXT:    adcl %ecx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ecx, %edi
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    mull %ebp
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %esi, %ecx
; X86-NEXT:    setb %bl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebp
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movzbl %bl, %eax
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    addl %edi, %ebx
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    movl %ebp, %edi
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    addl %ebx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %esi, %ebp
; X86-NEXT:    setb %bl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %ebp, %esi
; X86-NEXT:    movzbl %bl, %eax
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ebx, %edi
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    adcl %ebp, %ecx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %ecx, %ebp
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %ebx
; X86-NEXT:    addl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Folded Reload
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Folded Reload
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ecx, %edi
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    adcl %esi, %ecx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 1-byte Folded Reload
; X86-NEXT:    adcl %ecx, %edx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    addl %ebp, %ecx
; X86-NEXT:    movl %edi, %esi
; X86-NEXT:    adcl %ebx, %esi
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 1-byte Folded Reload
; X86-NEXT:    adcl %edi, %eax
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Folded Reload
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Folded Reload
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, (%esp) ## 4-byte Folded Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ecx, %edi
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %esi, %ecx
; X86-NEXT:    setb %bl
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    mull %edi
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movzbl %bl, %eax
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %ecx, %ebp
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    addl %ebp, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %esi, %ebx
; X86-NEXT:    setb %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %ebx, %esi
; X86-NEXT:    movzbl %cl, %eax
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ebx, %edi
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    adcl %ebp, %ecx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    addl %ecx, %ebx
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %ebp
; X86-NEXT:    addl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Folded Reload
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Folded Reload
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ecx, %edi
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %esi, %ecx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 1-byte Folded Reload
; X86-NEXT:    adcl %ecx, %edx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Reload
; X86-NEXT:    addl %ebx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Reload
; X86-NEXT:    adcl %ebp, %ebx
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 1-byte Folded Reload
; X86-NEXT:    adcl %ecx, %eax
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    addl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    adcl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    adcl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    adcl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    movl %edi, %edx
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl %ebx, %ecx
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    adcl $0, %eax
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    addl (%esp), %edx ## 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Folded Reload
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Folded Reload
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    addl %ecx, %ebx
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %ebx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %esi, %ecx
; X86-NEXT:    setb %bl
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    mull %edi
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movzbl %bl, %eax
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    movl %edx, (%esp) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %ecx, %ebp
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    addl %ebp, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %ebx, %edi
; X86-NEXT:    setb %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %edi, %ebp
; X86-NEXT:    movzbl %cl, %eax
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    adcl $0, (%esp) ## 4-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %edi, %esi
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %esi, %eax
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    adcl %ebx, %ecx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ecx, %edi
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %ebx
; X86-NEXT:    addl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Folded Reload
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Folded Reload
; X86-NEXT:    adcl (%esp), %ebx ## 4-byte Folded Reload
; X86-NEXT:    setb (%esp) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %ecx, %ebp
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    addl %ebp, %eax
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    adcl %esi, %ecx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %ecx, %esi
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    addl %edi, %ecx
; X86-NEXT:    adcl %ebx, %ebp
; X86-NEXT:    movzbl (%esp), %eax ## 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %esi
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Reload
; X86-NEXT:    addl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Reload
; X86-NEXT:    adcl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Reload
; X86-NEXT:    adcl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Reload
; X86-NEXT:    adcl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    sarl $31, %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    movl %eax, (%esp) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %esi, %ebp
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    addl %ecx, %ebp
; X86-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %esi, %edi
; X86-NEXT:    setb %cl
; X86-NEXT:    addl %eax, %edi
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movzbl %cl, %eax
; X86-NEXT:    adcl %edx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Reload
; X86-NEXT:    addl %eax, %esi
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    addl %edi, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    setb %al
; X86-NEXT:    addl %ebp, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movzbl %al, %esi
; X86-NEXT:    adcl %ecx, %esi
; X86-NEXT:    movl (%esp), %ecx ## 4-byte Reload
; X86-NEXT:    addl %edx, %ecx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Reload
; X86-NEXT:    adcl %esi, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Reload
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Reload
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Folded Reload
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    addl %ebp, %ecx
; X86-NEXT:    adcl %edi, %esi
; X86-NEXT:    setb %al
; X86-NEXT:    addl (%esp), %ecx ## 4-byte Folded Reload
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Folded Reload
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movzbl %al, %eax
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    imull %ebx, %ecx
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    imull %ebx, %edi
; X86-NEXT:    addl %edx, %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    imull %ebx, %ecx
; X86-NEXT:    mull %ebx
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    imull %ebx, %ecx
; X86-NEXT:    addl %edx, %ecx
; X86-NEXT:    addl %ebp, %esi
; X86-NEXT:    adcl %edi, %ecx
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %edx, %edi
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %eax, %edi
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %edx, %ebp
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    addl %eax, %ebp
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 1-byte Folded Reload
; X86-NEXT:    adcl %edx, %edi
; X86-NEXT:    addl %esi, %ebp
; X86-NEXT:    adcl %ecx, %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    imull %ebx, %ecx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Folded Reload
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    imull %ebx, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    imull %ebx, %ecx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Folded Reload
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    imull %ebx, %ecx
; X86-NEXT:    addl %edx, %ecx
; X86-NEXT:    movl (%esp), %edx ## 4-byte Reload
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    movl %edx, (%esp) ## 4-byte Spill
; X86-NEXT:    adcl %eax, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    addl %edx, %ecx
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %eax, %ecx
; X86-NEXT:    adcl %edx, %esi
; X86-NEXT:    setb %bl
; X86-NEXT:    addl %eax, %esi
; X86-NEXT:    movzbl %bl, %ebx
; X86-NEXT:    adcl %edx, %ebx
; X86-NEXT:    addl (%esp), %esi ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Reload
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Folded Reload
; X86-NEXT:    adcl %ebp, %esi
; X86-NEXT:    adcl %edi, %ebx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Folded Reload
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Folded Reload
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Folded Reload
; X86-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sarl $31, %eax
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    addl %edx, %ecx
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %eax, %ecx
; X86-NEXT:    movl %ecx, %ebx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %edx, %edi
; X86-NEXT:    setb %cl
; X86-NEXT:    addl %eax, %edi
; X86-NEXT:    movzbl %cl, %ebp
; X86-NEXT:    adcl %edx, %ebp
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    adcl %ebp, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Reload
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    movl %eax, (%esp) ## 4-byte Spill
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    addl %edx, %ebx
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %eax, %ebx
; X86-NEXT:    adcl %edx, %ecx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    addl %eax, %ecx
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 1-byte Folded Reload
; X86-NEXT:    adcl %edx, %eax
; X86-NEXT:    movl (%esp), %edx ## 4-byte Reload
; X86-NEXT:    addl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    adcl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Reload
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    adcl %ebp, %esi
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    addl (%esp), %eax ## 4-byte Folded Reload
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %ebx, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 1-byte Folded Reload
; X86-NEXT:    adcl %ecx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Reload
; X86-NEXT:    imull %ebp, %eax
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    imull %ebp, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    movl %ebp, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    imull %esi, %edx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    movl %ebp, %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    imull %eax, %edi
; X86-NEXT:    addl %edx, %edi
; X86-NEXT:    movl (%esp), %edx ## 4-byte Reload
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    movl %edx, (%esp) ## 4-byte Spill
; X86-NEXT:    adcl %ecx, %edi
; X86-NEXT:    mull %ebp
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    mull %ebp
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %ecx, %esi
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    addl %ebx, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %ecx, %edx
; X86-NEXT:    setb %cl
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    movzbl %cl, %eax
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    addl (%esp), %edx ## 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %edi, %eax
; X86-NEXT:    movl %eax, (%esp) ## 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    imull %ebp, %ecx
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    mull %edi
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    imull %ebp, %edi
; X86-NEXT:    addl %edx, %edi
; X86-NEXT:    movl %ebp, %ecx
; X86-NEXT:    imull {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    mull %ebx
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    movl %ebp, %esi
; X86-NEXT:    imull %ebx, %esi
; X86-NEXT:    addl %edx, %esi
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl %edi, %esi
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    mull %ebp
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebp
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    addl %ebx, %eax
; X86-NEXT:    adcl %edi, %edx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) ## 1-byte Folded Spill
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 1-byte Folded Reload
; X86-NEXT:    adcl %ebp, %ecx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    adcl %esi, %ecx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    adcl (%esp), %ecx ## 4-byte Folded Reload
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Folded Reload
; X86-NEXT:    movl %ebx, (%esp) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Reload
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Folded Reload
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Folded Reload
; X86-NEXT:    movl (%esp), %esi ## 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Folded Reload
; X86-NEXT:    movl %esi, (%esp) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Folded Reload
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Folded Reload
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Folded Reload
; X86-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Folded Reload
; X86-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Spill
; X86-NEXT:    movl (%esp), %ebx ## 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp ## 4-byte Reload
; X86-NEXT:    movl %ebp, %esi
; X86-NEXT:    sarl $31, %esi
; X86-NEXT:    xorl %esi, %edi
; X86-NEXT:    xorl %esi, %edx
; X86-NEXT:    orl %edi, %edx
; X86-NEXT:    movl %ebx, %edi
; X86-NEXT:    xorl %esi, %edi
; X86-NEXT:    orl %edx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx ## 4-byte Reload
; X86-NEXT:    xorl %esi, %edx
; X86-NEXT:    orl %edi, %edx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx ## 4-byte Reload
; X86-NEXT:    xorl %esi, %ebx
; X86-NEXT:    xorl %esi, %ecx
; X86-NEXT:    orl %ebx, %ecx
; X86-NEXT:    xorl %esi, %eax
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    xorl {{[-0-9]+}}(%e{{[sb]}}p), %esi ## 4-byte Folded Reload
; X86-NEXT:    orl %eax, %esi
; X86-NEXT:    orl %edx, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %ebp, 28(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    movl %ecx, 4(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    movl %ecx, 8(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    movl %ecx, 12(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    movl %ecx, 16(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    movl %ecx, 20(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx ## 4-byte Reload
; X86-NEXT:    movl %ecx, 24(%eax)
; X86-NEXT:    setne %al
; X86-NEXT:    addl $152, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %t = call {i256, i1} @llvm.smul.with.overflow.i256(i256 %v1, i256 %v2)
  %val = extractvalue {i256, i1} %t, 0
  %obit = extractvalue {i256, i1} %t, 1
  store i256 %val, i256* %res
  ret i1 %obit
}

declare {i128, i1} @llvm.smul.with.overflow.i128(i128, i128) nounwind readnone
declare {i256, i1} @llvm.smul.with.overflow.i256(i256, i256) nounwind readnone
