struct testCase {
	uint64_t input;
	double hi;
	double lo;
};

struct testCase tests[] = {
{ INT64_C(0x0000000000000061), 0x1.84p+6, 0x0p+0 },
{ INT64_C(0xffffffffffffff9e), -0x1.88p+6, 0x0p+0 },
{ INT64_C(0x0000000000000062), 0x1.88p+6, 0x0p+0 },
{ INT64_C(0xffffffffffffff9d), -0x1.8cp+6, 0x0p+0 },
{ INT64_C(0x0000000000000403), 0x1.00cp+10, 0x0p+0 },
{ INT64_C(0xfffffffffffffbfc), -0x1.01p+10, 0x0p+0 },
{ INT64_C(0x000000000000040a), 0x1.028p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffffbf5), -0x1.02cp+10, 0x0p+0 },
{ INT64_C(0x000000000000040c), 0x1.03p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffffbf3), -0x1.034p+10, 0x0p+0 },
{ INT64_C(0x000000000000040e), 0x1.038p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffffbf1), -0x1.03cp+10, 0x0p+0 },
{ INT64_C(0x0000000000000418), 0x1.06p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffffbe7), -0x1.064p+10, 0x0p+0 },
{ INT64_C(0x000000000000041a), 0x1.068p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffffbe5), -0x1.06cp+10, 0x0p+0 },
{ INT64_C(0x0000000000000504), 0x1.41p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffffafb), -0x1.414p+10, 0x0p+0 },
{ INT64_C(0x0000000000000506), 0x1.418p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffffaf9), -0x1.41cp+10, 0x0p+0 },
{ INT64_C(0x0000000000000510), 0x1.44p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffffaef), -0x1.444p+10, 0x0p+0 },
{ INT64_C(0x0000000000000518), 0x1.46p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffffae7), -0x1.464p+10, 0x0p+0 },
{ INT64_C(0x0000000000000602), 0x1.808p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff9fd), -0x1.80cp+10, 0x0p+0 },
{ INT64_C(0x0000000000000603), 0x1.80cp+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff9fc), -0x1.81p+10, 0x0p+0 },
{ INT64_C(0x0000000000000608), 0x1.82p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff9f7), -0x1.824p+10, 0x0p+0 },
{ INT64_C(0x0000000000000609), 0x1.824p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff9f6), -0x1.828p+10, 0x0p+0 },
{ INT64_C(0x0000000000000640), 0x1.9p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff9bf), -0x1.904p+10, 0x0p+0 },
{ INT64_C(0x0000000000000642), 0x1.908p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff9bd), -0x1.90cp+10, 0x0p+0 },
{ INT64_C(0x0000000000000648), 0x1.92p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff9b7), -0x1.924p+10, 0x0p+0 },
{ INT64_C(0x0000000000000660), 0x1.98p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff99f), -0x1.984p+10, 0x0p+0 },
{ INT64_C(0x0000000000000680), 0x1.ap+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff97f), -0x1.a04p+10, 0x0p+0 },
{ INT64_C(0x0000000000000681), 0x1.a04p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff97e), -0x1.a08p+10, 0x0p+0 },
{ INT64_C(0x0000000000000688), 0x1.a2p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff977), -0x1.a24p+10, 0x0p+0 },
{ INT64_C(0x0000000000000690), 0x1.a4p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff96f), -0x1.a44p+10, 0x0p+0 },
{ INT64_C(0x00000000000006a0), 0x1.a8p+10, 0x0p+0 },
{ INT64_C(0xfffffffffffff95f), -0x1.a84p+10, 0x0p+0 },
{ INT64_C(0x0000000000002003), 0x1.0018p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdffc), -0x1.002p+13, 0x0p+0 },
{ INT64_C(0x0000000000002009), 0x1.0048p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdff6), -0x1.005p+13, 0x0p+0 },
{ INT64_C(0x000000000000200c), 0x1.006p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdff3), -0x1.0068p+13, 0x0p+0 },
{ INT64_C(0x0000000000002082), 0x1.041p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdf7d), -0x1.0418p+13, 0x0p+0 },
{ INT64_C(0x0000000000002090), 0x1.048p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdf6f), -0x1.0488p+13, 0x0p+0 },
{ INT64_C(0x0000000000002098), 0x1.04cp+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdf67), -0x1.04c8p+13, 0x0p+0 },
{ INT64_C(0x00000000000020c0), 0x1.06p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdf3f), -0x1.0608p+13, 0x0p+0 },
{ INT64_C(0x00000000000020c2), 0x1.061p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdf3d), -0x1.0618p+13, 0x0p+0 },
{ INT64_C(0x00000000000020e0), 0x1.07p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdf1f), -0x1.0708p+13, 0x0p+0 },
{ INT64_C(0x0000000000002202), 0x1.101p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffddfd), -0x1.1018p+13, 0x0p+0 },
{ INT64_C(0x0000000000002208), 0x1.104p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffddf7), -0x1.1048p+13, 0x0p+0 },
{ INT64_C(0x0000000000002209), 0x1.1048p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffddf6), -0x1.105p+13, 0x0p+0 },
{ INT64_C(0x0000000000002240), 0x1.12p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffddbf), -0x1.1208p+13, 0x0p+0 },
{ INT64_C(0x0000000000002241), 0x1.1208p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffddbe), -0x1.121p+13, 0x0p+0 },
{ INT64_C(0x0000000000002250), 0x1.128p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffddaf), -0x1.1288p+13, 0x0p+0 },
{ INT64_C(0x0000000000002404), 0x1.202p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdbfb), -0x1.2028p+13, 0x0p+0 },
{ INT64_C(0x0000000000002405), 0x1.2028p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdbfa), -0x1.203p+13, 0x0p+0 },
{ INT64_C(0x0000000000002420), 0x1.21p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdbdf), -0x1.2108p+13, 0x0p+0 },
{ INT64_C(0x0000000000002421), 0x1.2108p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdbde), -0x1.211p+13, 0x0p+0 },
{ INT64_C(0x0000000000002424), 0x1.212p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdbdb), -0x1.2128p+13, 0x0p+0 },
{ INT64_C(0x0000000000002430), 0x1.218p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdbcf), -0x1.2188p+13, 0x0p+0 },
{ INT64_C(0x0000000000002440), 0x1.22p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdbbf), -0x1.2208p+13, 0x0p+0 },
{ INT64_C(0x0000000000002442), 0x1.221p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdbbd), -0x1.2218p+13, 0x0p+0 },
{ INT64_C(0x0000000000002450), 0x1.228p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdbaf), -0x1.2288p+13, 0x0p+0 },
{ INT64_C(0x0000000000002500), 0x1.28p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdaff), -0x1.2808p+13, 0x0p+0 },
{ INT64_C(0x0000000000002504), 0x1.282p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdafb), -0x1.2828p+13, 0x0p+0 },
{ INT64_C(0x0000000000002508), 0x1.284p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdaf7), -0x1.2848p+13, 0x0p+0 },
{ INT64_C(0x0000000000002520), 0x1.29p+13, 0x0p+0 },
{ INT64_C(0xffffffffffffdadf), -0x1.2908p+13, 0x0p+0 },
{ INT64_C(0x0000000000020041), 0x1.00208p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdffbe), -0x1.0021p+17, 0x0p+0 },
{ INT64_C(0x0000000000020042), 0x1.0021p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdffbd), -0x1.00218p+17, 0x0p+0 },
{ INT64_C(0x0000000000020050), 0x1.0028p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdffaf), -0x1.00288p+17, 0x0p+0 },
{ INT64_C(0x0000000000020051), 0x1.00288p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdffae), -0x1.0029p+17, 0x0p+0 },
{ INT64_C(0x0000000000020060), 0x1.003p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdff9f), -0x1.00308p+17, 0x0p+0 },
{ INT64_C(0x0000000000020062), 0x1.0031p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdff9d), -0x1.00318p+17, 0x0p+0 },
{ INT64_C(0x0000000000020070), 0x1.0038p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdff8f), -0x1.00388p+17, 0x0p+0 },
{ INT64_C(0x0000000000020202), 0x1.0101p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdfdfd), -0x1.01018p+17, 0x0p+0 },
{ INT64_C(0x0000000000020204), 0x1.0102p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdfdfb), -0x1.01028p+17, 0x0p+0 },
{ INT64_C(0x0000000000020210), 0x1.0108p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdfdef), -0x1.01088p+17, 0x0p+0 },
{ INT64_C(0x0000000000020218), 0x1.010cp+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdfde7), -0x1.010c8p+17, 0x0p+0 },
{ INT64_C(0x0000000000020300), 0x1.018p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdfcff), -0x1.01808p+17, 0x0p+0 },
{ INT64_C(0x0000000000020302), 0x1.0181p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdfcfd), -0x1.01818p+17, 0x0p+0 },
{ INT64_C(0x0000000000020310), 0x1.0188p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdfcef), -0x1.01888p+17, 0x0p+0 },
{ INT64_C(0x0000000000020801), 0x1.04008p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdf7fe), -0x1.0401p+17, 0x0p+0 },
{ INT64_C(0x0000000000020802), 0x1.0401p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdf7fd), -0x1.04018p+17, 0x0p+0 },
{ INT64_C(0x0000000000020820), 0x1.041p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdf7df), -0x1.04108p+17, 0x0p+0 },
{ INT64_C(0x0000000000020824), 0x1.0412p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdf7db), -0x1.04128p+17, 0x0p+0 },
{ INT64_C(0x0000000000020828), 0x1.0414p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdf7d7), -0x1.04148p+17, 0x0p+0 },
{ INT64_C(0x0000000000020a00), 0x1.05p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdf5ff), -0x1.05008p+17, 0x0p+0 },
{ INT64_C(0x0000000000020a08), 0x1.0504p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdf5f7), -0x1.05048p+17, 0x0p+0 },
{ INT64_C(0x0000000000020a40), 0x1.052p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdf5bf), -0x1.05208p+17, 0x0p+0 },
{ INT64_C(0x0000000000021002), 0x1.0801p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdeffd), -0x1.08018p+17, 0x0p+0 },
{ INT64_C(0x0000000000021020), 0x1.081p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdefdf), -0x1.08108p+17, 0x0p+0 },
{ INT64_C(0x0000000000021024), 0x1.0812p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdefdb), -0x1.08128p+17, 0x0p+0 },
{ INT64_C(0x0000000000021030), 0x1.0818p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdefcf), -0x1.08188p+17, 0x0p+0 },
{ INT64_C(0x0000000000021100), 0x1.088p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdeeff), -0x1.08808p+17, 0x0p+0 },
{ INT64_C(0x0000000000021104), 0x1.0882p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdeefb), -0x1.08828p+17, 0x0p+0 },
{ INT64_C(0x0000000000021108), 0x1.0884p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdeef7), -0x1.08848p+17, 0x0p+0 },
{ INT64_C(0x0000000000021110), 0x1.0888p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdeeef), -0x1.08888p+17, 0x0p+0 },
{ INT64_C(0x0000000000021180), 0x1.08cp+17, 0x0p+0 },
{ INT64_C(0xfffffffffffdee7f), -0x1.08c08p+17, 0x0p+0 },
{ INT64_C(0x0000000000021800), 0x1.0cp+17, 0x0p+0 },
{ INT64_C(0xfffffffffffde7ff), -0x1.0c008p+17, 0x0p+0 },
{ INT64_C(0x0000000000021804), 0x1.0c02p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffde7fb), -0x1.0c028p+17, 0x0p+0 },
{ INT64_C(0x0000000000021840), 0x1.0c2p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffde7bf), -0x1.0c208p+17, 0x0p+0 },
{ INT64_C(0x0000000000021a00), 0x1.0dp+17, 0x0p+0 },
{ INT64_C(0xfffffffffffde5ff), -0x1.0d008p+17, 0x0p+0 },
{ INT64_C(0x0000000000021c00), 0x1.0ep+17, 0x0p+0 },
{ INT64_C(0xfffffffffffde3ff), -0x1.0e008p+17, 0x0p+0 },
{ INT64_C(0x0000000000030008), 0x1.8004p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcfff7), -0x1.80048p+17, 0x0p+0 },
{ INT64_C(0x0000000000030020), 0x1.801p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcffdf), -0x1.80108p+17, 0x0p+0 },
{ INT64_C(0x0000000000030022), 0x1.8011p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcffdd), -0x1.80118p+17, 0x0p+0 },
{ INT64_C(0x0000000000030024), 0x1.8012p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcffdb), -0x1.80128p+17, 0x0p+0 },
{ INT64_C(0x0000000000030200), 0x1.81p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcfdff), -0x1.81008p+17, 0x0p+0 },
{ INT64_C(0x0000000000030202), 0x1.8101p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcfdfd), -0x1.81018p+17, 0x0p+0 },
{ INT64_C(0x0000000000030204), 0x1.8102p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcfdfb), -0x1.81028p+17, 0x0p+0 },
{ INT64_C(0x0000000000030210), 0x1.8108p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcfdef), -0x1.81088p+17, 0x0p+0 },
{ INT64_C(0x0000000000030300), 0x1.818p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcfcff), -0x1.81808p+17, 0x0p+0 },
{ INT64_C(0x0000000000030400), 0x1.82p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcfbff), -0x1.82008p+17, 0x0p+0 },
{ INT64_C(0x0000000000030401), 0x1.82008p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcfbfe), -0x1.8201p+17, 0x0p+0 },
{ INT64_C(0x0000000000030410), 0x1.8208p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcfbef), -0x1.82088p+17, 0x0p+0 },
{ INT64_C(0x0000000000030500), 0x1.828p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcfaff), -0x1.82808p+17, 0x0p+0 },
{ INT64_C(0x0000000000032000), 0x1.9p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcdfff), -0x1.90008p+17, 0x0p+0 },
{ INT64_C(0x0000000000032004), 0x1.9002p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcdffb), -0x1.90028p+17, 0x0p+0 },
{ INT64_C(0x0000000000032040), 0x1.902p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcdfbf), -0x1.90208p+17, 0x0p+0 },
{ INT64_C(0x0000000000032400), 0x1.92p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcdbff), -0x1.92008p+17, 0x0p+0 },
{ INT64_C(0x0000000000032800), 0x1.94p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffcd7ff), -0x1.94008p+17, 0x0p+0 },
{ INT64_C(0x0000000000033000), 0x1.98p+17, 0x0p+0 },
{ INT64_C(0xfffffffffffccfff), -0x1.98008p+17, 0x0p+0 },
{ INT64_C(0x0000000000040022), 0x1.00088p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbffdd), -0x1.0008cp+18, 0x0p+0 },
{ INT64_C(0x0000000000040028), 0x1.000ap+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbffd7), -0x1.000a4p+18, 0x0p+0 },
{ INT64_C(0x0000000000040104), 0x1.0041p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbfefb), -0x1.00414p+18, 0x0p+0 },
{ INT64_C(0x0000000000040108), 0x1.0042p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbfef7), -0x1.00424p+18, 0x0p+0 },
{ INT64_C(0x000000000004010a), 0x1.00428p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbfef5), -0x1.0042cp+18, 0x0p+0 },
{ INT64_C(0x0000000000040120), 0x1.0048p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbfedf), -0x1.00484p+18, 0x0p+0 },
{ INT64_C(0x0000000000040128), 0x1.004ap+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbfed7), -0x1.004a4p+18, 0x0p+0 },
{ INT64_C(0x0000000000040130), 0x1.004cp+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbfecf), -0x1.004c4p+18, 0x0p+0 },
{ INT64_C(0x0000000000040140), 0x1.005p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbfebf), -0x1.00504p+18, 0x0p+0 },
{ INT64_C(0x0000000000040148), 0x1.0052p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbfeb7), -0x1.00524p+18, 0x0p+0 },
{ INT64_C(0x0000000000041001), 0x1.04004p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbeffe), -0x1.04008p+18, 0x0p+0 },
{ INT64_C(0x0000000000041002), 0x1.04008p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbeffd), -0x1.0400cp+18, 0x0p+0 },
{ INT64_C(0x0000000000041003), 0x1.0400cp+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbeffc), -0x1.0401p+18, 0x0p+0 },
{ INT64_C(0x0000000000041004), 0x1.0401p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbeffb), -0x1.04014p+18, 0x0p+0 },
{ INT64_C(0x0000000000041010), 0x1.0404p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbefef), -0x1.04044p+18, 0x0p+0 },
{ INT64_C(0x0000000000041018), 0x1.0406p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbefe7), -0x1.04064p+18, 0x0p+0 },
{ INT64_C(0x0000000000041040), 0x1.041p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbefbf), -0x1.04104p+18, 0x0p+0 },
{ INT64_C(0x0000000000041042), 0x1.04108p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbefbd), -0x1.0410cp+18, 0x0p+0 },
{ INT64_C(0x0000000000041044), 0x1.0411p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbefbb), -0x1.04114p+18, 0x0p+0 },
{ INT64_C(0x0000000000041400), 0x1.05p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbebff), -0x1.05004p+18, 0x0p+0 },
{ INT64_C(0x0000000000041404), 0x1.0501p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbebfb), -0x1.05014p+18, 0x0p+0 },
{ INT64_C(0x0000000000041440), 0x1.051p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbebbf), -0x1.05104p+18, 0x0p+0 },
{ INT64_C(0x0000000000041600), 0x1.058p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbe9ff), -0x1.05804p+18, 0x0p+0 },
{ INT64_C(0x0000000000041800), 0x1.06p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbe7ff), -0x1.06004p+18, 0x0p+0 },
{ INT64_C(0x0000000000041802), 0x1.06008p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbe7fd), -0x1.0600cp+18, 0x0p+0 },
{ INT64_C(0x0000000000041820), 0x1.0608p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbe7df), -0x1.06084p+18, 0x0p+0 },
{ INT64_C(0x0000000000041840), 0x1.061p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbe7bf), -0x1.06104p+18, 0x0p+0 },
{ INT64_C(0x0000000000041a00), 0x1.068p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbe5ff), -0x1.06804p+18, 0x0p+0 },
{ INT64_C(0x0000000000041c00), 0x1.07p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbe3ff), -0x1.07004p+18, 0x0p+0 },
{ INT64_C(0x0000000000044008), 0x1.1002p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbff7), -0x1.10024p+18, 0x0p+0 },
{ INT64_C(0x0000000000044080), 0x1.102p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbf7f), -0x1.10204p+18, 0x0p+0 },
{ INT64_C(0x0000000000044084), 0x1.1021p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbf7b), -0x1.10214p+18, 0x0p+0 },
{ INT64_C(0x00000000000440c0), 0x1.103p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbf3f), -0x1.10304p+18, 0x0p+0 },
{ INT64_C(0x0000000000044200), 0x1.108p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbdff), -0x1.10804p+18, 0x0p+0 },
{ INT64_C(0x0000000000044201), 0x1.10804p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbdfe), -0x1.10808p+18, 0x0p+0 },
{ INT64_C(0x0000000000044204), 0x1.1081p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbdfb), -0x1.10814p+18, 0x0p+0 },
{ INT64_C(0x0000000000044240), 0x1.109p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbdbf), -0x1.10904p+18, 0x0p+0 },
{ INT64_C(0x0000000000044400), 0x1.11p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbbff), -0x1.11004p+18, 0x0p+0 },
{ INT64_C(0x0000000000044402), 0x1.11008p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbbfd), -0x1.1100cp+18, 0x0p+0 },
{ INT64_C(0x0000000000044408), 0x1.1102p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbbf7), -0x1.11024p+18, 0x0p+0 },
{ INT64_C(0x0000000000044420), 0x1.1108p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbbdf), -0x1.11084p+18, 0x0p+0 },
{ INT64_C(0x0000000000044480), 0x1.112p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbb7f), -0x1.11204p+18, 0x0p+0 },
{ INT64_C(0x0000000000044500), 0x1.114p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbbaff), -0x1.11404p+18, 0x0p+0 },
{ INT64_C(0x0000000000044600), 0x1.118p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbb9ff), -0x1.11804p+18, 0x0p+0 },
{ INT64_C(0x0000000000045000), 0x1.14p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbafff), -0x1.14004p+18, 0x0p+0 },
{ INT64_C(0x0000000000045001), 0x1.14004p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbaffe), -0x1.14008p+18, 0x0p+0 },
{ INT64_C(0x0000000000045002), 0x1.14008p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbaffd), -0x1.1400cp+18, 0x0p+0 },
{ INT64_C(0x0000000000045010), 0x1.1404p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbafef), -0x1.14044p+18, 0x0p+0 },
{ INT64_C(0x0000000000045080), 0x1.142p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbaf7f), -0x1.14204p+18, 0x0p+0 },
{ INT64_C(0x0000000000045100), 0x1.144p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbaeff), -0x1.14404p+18, 0x0p+0 },
{ INT64_C(0x0000000000045200), 0x1.148p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffbadff), -0x1.14804p+18, 0x0p+0 },
{ INT64_C(0x0000000000048002), 0x1.20008p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb7ffd), -0x1.2000cp+18, 0x0p+0 },
{ INT64_C(0x0000000000048003), 0x1.2000cp+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb7ffc), -0x1.2001p+18, 0x0p+0 },
{ INT64_C(0x0000000000048010), 0x1.2004p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb7fef), -0x1.20044p+18, 0x0p+0 },
{ INT64_C(0x0000000000048018), 0x1.2006p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb7fe7), -0x1.20064p+18, 0x0p+0 },
{ INT64_C(0x0000000000048040), 0x1.201p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb7fbf), -0x1.20104p+18, 0x0p+0 },
{ INT64_C(0x0000000000048042), 0x1.20108p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb7fbd), -0x1.2010cp+18, 0x0p+0 },
{ INT64_C(0x0000000000048060), 0x1.2018p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb7f9f), -0x1.20184p+18, 0x0p+0 },
{ INT64_C(0x0000000000048400), 0x1.21p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb7bff), -0x1.21004p+18, 0x0p+0 },
{ INT64_C(0x0000000000048402), 0x1.21008p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb7bfd), -0x1.2100cp+18, 0x0p+0 },
{ INT64_C(0x0000000000048410), 0x1.2104p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb7bef), -0x1.21044p+18, 0x0p+0 },
{ INT64_C(0x0000000000048440), 0x1.211p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb7bbf), -0x1.21104p+18, 0x0p+0 },
{ INT64_C(0x0000000000048480), 0x1.212p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb7b7f), -0x1.21204p+18, 0x0p+0 },
{ INT64_C(0x0000000000048600), 0x1.218p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb79ff), -0x1.21804p+18, 0x0p+0 },
{ INT64_C(0x000000000004a000), 0x1.28p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb5fff), -0x1.28004p+18, 0x0p+0 },
{ INT64_C(0x000000000004a004), 0x1.2801p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb5ffb), -0x1.28014p+18, 0x0p+0 },
{ INT64_C(0x000000000004a008), 0x1.2802p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb5ff7), -0x1.28024p+18, 0x0p+0 },
{ INT64_C(0x000000000004a010), 0x1.2804p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb5fef), -0x1.28044p+18, 0x0p+0 },
{ INT64_C(0x000000000004a080), 0x1.282p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb5f7f), -0x1.28204p+18, 0x0p+0 },
{ INT64_C(0x000000000004a200), 0x1.288p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb5dff), -0x1.28804p+18, 0x0p+0 },
{ INT64_C(0x000000000004a400), 0x1.29p+18, 0x0p+0 },
{ INT64_C(0xfffffffffffb5bff), -0x1.29004p+18, 0x0p+0 },
{ INT64_C(0x0000000000060002), 0x1.80008p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9fffd), -0x1.8000cp+18, 0x0p+0 },
{ INT64_C(0x0000000000060003), 0x1.8000cp+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9fffc), -0x1.8001p+18, 0x0p+0 },
{ INT64_C(0x0000000000060010), 0x1.8004p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9ffef), -0x1.80044p+18, 0x0p+0 },
{ INT64_C(0x0000000000060012), 0x1.80048p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9ffed), -0x1.8004cp+18, 0x0p+0 },
{ INT64_C(0x0000000000060080), 0x1.802p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9ff7f), -0x1.80204p+18, 0x0p+0 },
{ INT64_C(0x0000000000060084), 0x1.8021p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9ff7b), -0x1.80214p+18, 0x0p+0 },
{ INT64_C(0x00000000000600c0), 0x1.803p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9ff3f), -0x1.80304p+18, 0x0p+0 },
{ INT64_C(0x0000000000060200), 0x1.808p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9fdff), -0x1.80804p+18, 0x0p+0 },
{ INT64_C(0x0000000000060208), 0x1.8082p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9fdf7), -0x1.80824p+18, 0x0p+0 },
{ INT64_C(0x0000000000060210), 0x1.8084p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9fdef), -0x1.80844p+18, 0x0p+0 },
{ INT64_C(0x0000000000060280), 0x1.80ap+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9fd7f), -0x1.80a04p+18, 0x0p+0 },
{ INT64_C(0x0000000000060800), 0x1.82p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9f7ff), -0x1.82004p+18, 0x0p+0 },
{ INT64_C(0x0000000000060808), 0x1.8202p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9f7f7), -0x1.82024p+18, 0x0p+0 },
{ INT64_C(0x0000000000060810), 0x1.8204p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9f7ef), -0x1.82044p+18, 0x0p+0 },
{ INT64_C(0x0000000000060840), 0x1.821p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9f7bf), -0x1.82104p+18, 0x0p+0 },
{ INT64_C(0x0000000000060900), 0x1.824p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9f6ff), -0x1.82404p+18, 0x0p+0 },
{ INT64_C(0x0000000000060c00), 0x1.83p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9f3ff), -0x1.83004p+18, 0x0p+0 },
{ INT64_C(0x0000000000064000), 0x1.9p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9bfff), -0x1.90004p+18, 0x0p+0 },
{ INT64_C(0x0000000000064001), 0x1.90004p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9bffe), -0x1.90008p+18, 0x0p+0 },
{ INT64_C(0x0000000000064008), 0x1.9002p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9bff7), -0x1.90024p+18, 0x0p+0 },
{ INT64_C(0x0000000000064010), 0x1.9004p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9bfef), -0x1.90044p+18, 0x0p+0 },
{ INT64_C(0x0000000000064100), 0x1.904p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9beff), -0x1.90404p+18, 0x0p+0 },
{ INT64_C(0x0000000000065000), 0x1.94p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff9afff), -0x1.94004p+18, 0x0p+0 },
{ INT64_C(0x0000000000066000), 0x1.98p+18, 0x0p+0 },
{ INT64_C(0xfffffffffff99fff), -0x1.98004p+18, 0x0p+0 },
{ INT64_C(0x0000000000400005), 0x1.000014p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbffffa), -0x1.000018p+22, 0x0p+0 },
{ INT64_C(0x0000000000400012), 0x1.000048p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfffed), -0x1.00004cp+22, 0x0p+0 },
{ INT64_C(0x0000000000400018), 0x1.00006p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfffe7), -0x1.000064p+22, 0x0p+0 },
{ INT64_C(0x0000000000400019), 0x1.000064p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfffe6), -0x1.000068p+22, 0x0p+0 },
{ INT64_C(0x0000000000400042), 0x1.000108p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfffbd), -0x1.00010cp+22, 0x0p+0 },
{ INT64_C(0x0000000000400060), 0x1.00018p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfff9f), -0x1.000184p+22, 0x0p+0 },
{ INT64_C(0x0000000000400068), 0x1.0001ap+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfff97), -0x1.0001a4p+22, 0x0p+0 },
{ INT64_C(0x0000000000400408), 0x1.00102p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbffbf7), -0x1.001024p+22, 0x0p+0 },
{ INT64_C(0x0000000000400480), 0x1.0012p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbffb7f), -0x1.001204p+22, 0x0p+0 },
{ INT64_C(0x0000000000400482), 0x1.001208p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbffb7d), -0x1.00120cp+22, 0x0p+0 },
{ INT64_C(0x00000000004004a0), 0x1.00128p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbffb5f), -0x1.001284p+22, 0x0p+0 },
{ INT64_C(0x0000000000400600), 0x1.0018p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbff9ff), -0x1.001804p+22, 0x0p+0 },
{ INT64_C(0x0000000000400608), 0x1.00182p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbff9f7), -0x1.001824p+22, 0x0p+0 },
{ INT64_C(0x0000000000400610), 0x1.00184p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbff9ef), -0x1.001844p+22, 0x0p+0 },
{ INT64_C(0x0000000000400640), 0x1.0019p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbff9bf), -0x1.001904p+22, 0x0p+0 },
{ INT64_C(0x0000000000402004), 0x1.00801p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdffb), -0x1.008014p+22, 0x0p+0 },
{ INT64_C(0x0000000000402005), 0x1.008014p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdffa), -0x1.008018p+22, 0x0p+0 },
{ INT64_C(0x0000000000402006), 0x1.008018p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdff9), -0x1.00801cp+22, 0x0p+0 },
{ INT64_C(0x0000000000402040), 0x1.0081p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdfbf), -0x1.008104p+22, 0x0p+0 },
{ INT64_C(0x0000000000402042), 0x1.008108p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdfbd), -0x1.00810cp+22, 0x0p+0 },
{ INT64_C(0x0000000000402044), 0x1.00811p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdfbb), -0x1.008114p+22, 0x0p+0 },
{ INT64_C(0x0000000000402060), 0x1.00818p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdf9f), -0x1.008184p+22, 0x0p+0 },
{ INT64_C(0x0000000000402080), 0x1.0082p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdf7f), -0x1.008204p+22, 0x0p+0 },
{ INT64_C(0x0000000000402088), 0x1.00822p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdf77), -0x1.008224p+22, 0x0p+0 },
{ INT64_C(0x0000000000402090), 0x1.00824p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdf6f), -0x1.008244p+22, 0x0p+0 },
{ INT64_C(0x00000000004020a0), 0x1.00828p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdf5f), -0x1.008284p+22, 0x0p+0 },
{ INT64_C(0x0000000000402400), 0x1.009p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdbff), -0x1.009004p+22, 0x0p+0 },
{ INT64_C(0x0000000000402408), 0x1.00902p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdbf7), -0x1.009024p+22, 0x0p+0 },
{ INT64_C(0x0000000000402410), 0x1.00904p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdbef), -0x1.009044p+22, 0x0p+0 },
{ INT64_C(0x0000000000402480), 0x1.0092p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfdb7f), -0x1.009204p+22, 0x0p+0 },
{ INT64_C(0x0000000000402800), 0x1.00ap+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfd7ff), -0x1.00a004p+22, 0x0p+0 },
{ INT64_C(0x0000000000402808), 0x1.00a02p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfd7f7), -0x1.00a024p+22, 0x0p+0 },
{ INT64_C(0x0000000000402810), 0x1.00a04p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfd7ef), -0x1.00a044p+22, 0x0p+0 },
{ INT64_C(0x0000000000402880), 0x1.00a2p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfd77f), -0x1.00a204p+22, 0x0p+0 },
{ INT64_C(0x0000000000402a00), 0x1.00a8p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbfd5ff), -0x1.00a804p+22, 0x0p+0 },
{ INT64_C(0x0000000000420004), 0x1.08001p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdfffb), -0x1.080014p+22, 0x0p+0 },
{ INT64_C(0x0000000000420040), 0x1.0801p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdffbf), -0x1.080104p+22, 0x0p+0 },
{ INT64_C(0x0000000000420044), 0x1.08011p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdffbb), -0x1.080114p+22, 0x0p+0 },
{ INT64_C(0x0000000000420048), 0x1.08012p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdffb7), -0x1.080124p+22, 0x0p+0 },
{ INT64_C(0x0000000000420200), 0x1.0808p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdfdff), -0x1.080804p+22, 0x0p+0 },
{ INT64_C(0x0000000000420208), 0x1.08082p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdfdf7), -0x1.080824p+22, 0x0p+0 },
{ INT64_C(0x0000000000420220), 0x1.08088p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdfddf), -0x1.080884p+22, 0x0p+0 },
{ INT64_C(0x0000000000420300), 0x1.080cp+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdfcff), -0x1.080c04p+22, 0x0p+0 },
{ INT64_C(0x0000000000422000), 0x1.088p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbddfff), -0x1.088004p+22, 0x0p+0 },
{ INT64_C(0x0000000000422004), 0x1.08801p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbddffb), -0x1.088014p+22, 0x0p+0 },
{ INT64_C(0x0000000000422010), 0x1.08804p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbddfef), -0x1.088044p+22, 0x0p+0 },
{ INT64_C(0x0000000000422020), 0x1.08808p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbddfdf), -0x1.088084p+22, 0x0p+0 },
{ INT64_C(0x0000000000422040), 0x1.0881p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbddfbf), -0x1.088104p+22, 0x0p+0 },
{ INT64_C(0x0000000000422080), 0x1.0882p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbddf7f), -0x1.088204p+22, 0x0p+0 },
{ INT64_C(0x0000000000422400), 0x1.089p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbddbff), -0x1.089004p+22, 0x0p+0 },
{ INT64_C(0x0000000000422800), 0x1.08ap+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdd7ff), -0x1.08a004p+22, 0x0p+0 },
{ INT64_C(0x0000000000424000), 0x1.09p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdbfff), -0x1.090004p+22, 0x0p+0 },
{ INT64_C(0x0000000000424001), 0x1.090004p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdbffe), -0x1.090008p+22, 0x0p+0 },
{ INT64_C(0x0000000000424008), 0x1.09002p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdbff7), -0x1.090024p+22, 0x0p+0 },
{ INT64_C(0x0000000000424080), 0x1.0902p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdbf7f), -0x1.090204p+22, 0x0p+0 },
{ INT64_C(0x0000000000424100), 0x1.0904p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdbeff), -0x1.090404p+22, 0x0p+0 },
{ INT64_C(0x0000000000425000), 0x1.094p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbdafff), -0x1.094004p+22, 0x0p+0 },
{ INT64_C(0x0000000000430000), 0x1.0cp+22, 0x0p+0 },
{ INT64_C(0xffffffffffbcffff), -0x1.0c0004p+22, 0x0p+0 },
{ INT64_C(0x0000000000430002), 0x1.0c0008p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbcfffd), -0x1.0c000cp+22, 0x0p+0 },
{ INT64_C(0x0000000000430004), 0x1.0c001p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbcfffb), -0x1.0c0014p+22, 0x0p+0 },
{ INT64_C(0x0000000000430020), 0x1.0c008p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbcffdf), -0x1.0c0084p+22, 0x0p+0 },
{ INT64_C(0x0000000000430100), 0x1.0c04p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbcfeff), -0x1.0c0404p+22, 0x0p+0 },
{ INT64_C(0x0000000000430400), 0x1.0c1p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbcfbff), -0x1.0c1004p+22, 0x0p+0 },
{ INT64_C(0x0000000000431000), 0x1.0c4p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbcefff), -0x1.0c4004p+22, 0x0p+0 },
{ INT64_C(0x0000000000432000), 0x1.0c8p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbcdfff), -0x1.0c8004p+22, 0x0p+0 },
{ INT64_C(0x0000000000438000), 0x1.0ep+22, 0x0p+0 },
{ INT64_C(0xffffffffffbc7fff), -0x1.0e0004p+22, 0x0p+0 },
{ INT64_C(0x0000000000440002), 0x1.100008p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbfffd), -0x1.10000cp+22, 0x0p+0 },
{ INT64_C(0x0000000000440003), 0x1.10000cp+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbfffc), -0x1.10001p+22, 0x0p+0 },
{ INT64_C(0x0000000000440004), 0x1.10001p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbfffb), -0x1.100014p+22, 0x0p+0 },
{ INT64_C(0x0000000000440010), 0x1.10004p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbffef), -0x1.100044p+22, 0x0p+0 },
{ INT64_C(0x0000000000440018), 0x1.10006p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbffe7), -0x1.100064p+22, 0x0p+0 },
{ INT64_C(0x0000000000440080), 0x1.1002p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbff7f), -0x1.100204p+22, 0x0p+0 },
{ INT64_C(0x0000000000440084), 0x1.10021p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbff7b), -0x1.100214p+22, 0x0p+0 },
{ INT64_C(0x0000000000440090), 0x1.10024p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbff6f), -0x1.100244p+22, 0x0p+0 },
{ INT64_C(0x00000000004400c0), 0x1.1003p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbff3f), -0x1.100304p+22, 0x0p+0 },
{ INT64_C(0x0000000000440100), 0x1.1004p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbfeff), -0x1.100404p+22, 0x0p+0 },
{ INT64_C(0x0000000000440104), 0x1.10041p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbfefb), -0x1.100414p+22, 0x0p+0 },
{ INT64_C(0x0000000000440140), 0x1.1005p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbfebf), -0x1.100504p+22, 0x0p+0 },
{ INT64_C(0x0000000000440180), 0x1.1006p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbfe7f), -0x1.100604p+22, 0x0p+0 },
{ INT64_C(0x0000000000440400), 0x1.101p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbfbff), -0x1.101004p+22, 0x0p+0 },
{ INT64_C(0x0000000000440404), 0x1.10101p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbfbfb), -0x1.101014p+22, 0x0p+0 },
{ INT64_C(0x0000000000440408), 0x1.10102p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbfbf7), -0x1.101024p+22, 0x0p+0 },
{ INT64_C(0x0000000000440480), 0x1.1012p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbfb7f), -0x1.101204p+22, 0x0p+0 },
{ INT64_C(0x0000000000444000), 0x1.11p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbbfff), -0x1.110004p+22, 0x0p+0 },
{ INT64_C(0x0000000000444008), 0x1.11002p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbbff7), -0x1.110024p+22, 0x0p+0 },
{ INT64_C(0x0000000000444040), 0x1.1101p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbbfbf), -0x1.110104p+22, 0x0p+0 },
{ INT64_C(0x0000000000444100), 0x1.1104p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbbeff), -0x1.110404p+22, 0x0p+0 },
{ INT64_C(0x0000000000444400), 0x1.111p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbbbff), -0x1.111004p+22, 0x0p+0 },
{ INT64_C(0x0000000000445000), 0x1.114p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbbafff), -0x1.114004p+22, 0x0p+0 },
{ INT64_C(0x0000000000446000), 0x1.118p+22, 0x0p+0 },
{ INT64_C(0xffffffffffbb9fff), -0x1.118004p+22, 0x0p+0 },
{ INT64_C(0x0000000000600002), 0x1.800008p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffffd), -0x1.80000cp+22, 0x0p+0 },
{ INT64_C(0x0000000000600004), 0x1.80001p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffffb), -0x1.800014p+22, 0x0p+0 },
{ INT64_C(0x0000000000600040), 0x1.8001p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fffbf), -0x1.800104p+22, 0x0p+0 },
{ INT64_C(0x0000000000600044), 0x1.80011p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fffbb), -0x1.800114p+22, 0x0p+0 },
{ INT64_C(0x0000000000600050), 0x1.80014p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fffaf), -0x1.800144p+22, 0x0p+0 },
{ INT64_C(0x0000000000600100), 0x1.8004p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffeff), -0x1.800404p+22, 0x0p+0 },
{ INT64_C(0x0000000000600102), 0x1.800408p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffefd), -0x1.80040cp+22, 0x0p+0 },
{ INT64_C(0x0000000000600110), 0x1.80044p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffeef), -0x1.800444p+22, 0x0p+0 },
{ INT64_C(0x0000000000600120), 0x1.80048p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffedf), -0x1.800484p+22, 0x0p+0 },
{ INT64_C(0x0000000000600140), 0x1.8005p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffebf), -0x1.800504p+22, 0x0p+0 },
{ INT64_C(0x0000000000600180), 0x1.8006p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffe7f), -0x1.800604p+22, 0x0p+0 },
{ INT64_C(0x0000000000600200), 0x1.8008p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffdff), -0x1.800804p+22, 0x0p+0 },
{ INT64_C(0x0000000000600201), 0x1.800804p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffdfe), -0x1.800808p+22, 0x0p+0 },
{ INT64_C(0x0000000000600202), 0x1.800808p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffdfd), -0x1.80080cp+22, 0x0p+0 },
{ INT64_C(0x0000000000600204), 0x1.80081p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffdfb), -0x1.800814p+22, 0x0p+0 },
{ INT64_C(0x0000000000600240), 0x1.8009p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffdbf), -0x1.800904p+22, 0x0p+0 },
{ INT64_C(0x0000000000600280), 0x1.800ap+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ffd7f), -0x1.800a04p+22, 0x0p+0 },
{ INT64_C(0x0000000000601000), 0x1.804p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fefff), -0x1.804004p+22, 0x0p+0 },
{ INT64_C(0x0000000000601002), 0x1.804008p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9feffd), -0x1.80400cp+22, 0x0p+0 },
{ INT64_C(0x0000000000601020), 0x1.80408p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fefdf), -0x1.804084p+22, 0x0p+0 },
{ INT64_C(0x0000000000601040), 0x1.8041p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fefbf), -0x1.804104p+22, 0x0p+0 },
{ INT64_C(0x0000000000601400), 0x1.805p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9febff), -0x1.805004p+22, 0x0p+0 },
{ INT64_C(0x0000000000602000), 0x1.808p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fdfff), -0x1.808004p+22, 0x0p+0 },
{ INT64_C(0x0000000000602008), 0x1.80802p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fdff7), -0x1.808024p+22, 0x0p+0 },
{ INT64_C(0x0000000000602020), 0x1.80808p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fdfdf), -0x1.808084p+22, 0x0p+0 },
{ INT64_C(0x0000000000602080), 0x1.8082p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fdf7f), -0x1.808204p+22, 0x0p+0 },
{ INT64_C(0x0000000000602100), 0x1.8084p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fdeff), -0x1.808404p+22, 0x0p+0 },
{ INT64_C(0x0000000000602200), 0x1.8088p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fddff), -0x1.808804p+22, 0x0p+0 },
{ INT64_C(0x0000000000603000), 0x1.80cp+22, 0x0p+0 },
{ INT64_C(0xffffffffff9fcfff), -0x1.80c004p+22, 0x0p+0 },
{ INT64_C(0x0000000000620000), 0x1.88p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9dffff), -0x1.880004p+22, 0x0p+0 },
{ INT64_C(0x0000000000620004), 0x1.88001p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9dfffb), -0x1.880014p+22, 0x0p+0 },
{ INT64_C(0x0000000000620040), 0x1.8801p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9dffbf), -0x1.880104p+22, 0x0p+0 },
{ INT64_C(0x0000000000620400), 0x1.881p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9dfbff), -0x1.881004p+22, 0x0p+0 },
{ INT64_C(0x0000000000622000), 0x1.888p+22, 0x0p+0 },
{ INT64_C(0xffffffffff9ddfff), -0x1.888004p+22, 0x0p+0 },
{ INT64_C(0x0000000000628000), 0x1.8ap+22, 0x0p+0 },
{ INT64_C(0xffffffffff9d7fff), -0x1.8a0004p+22, 0x0p+0 },
{ INT64_C(0x0000000004000005), 0x1.0000014p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffffa), -0x1.0000018p+26, 0x0p+0 },
{ INT64_C(0x000000000400000a), 0x1.0000028p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffff5), -0x1.000002cp+26, 0x0p+0 },
{ INT64_C(0x0000000004000081), 0x1.0000204p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffff7e), -0x1.0000208p+26, 0x0p+0 },
{ INT64_C(0x0000000004000082), 0x1.0000208p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffff7d), -0x1.000020cp+26, 0x0p+0 },
{ INT64_C(0x00000000040000a0), 0x1.000028p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffff5f), -0x1.0000284p+26, 0x0p+0 },
{ INT64_C(0x00000000040000a4), 0x1.000029p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffff5b), -0x1.0000294p+26, 0x0p+0 },
{ INT64_C(0x00000000040000a8), 0x1.00002ap+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffff57), -0x1.00002a4p+26, 0x0p+0 },
{ INT64_C(0x0000000004000201), 0x1.0000804p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffdfe), -0x1.0000808p+26, 0x0p+0 },
{ INT64_C(0x0000000004000204), 0x1.000081p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffdfb), -0x1.0000814p+26, 0x0p+0 },
{ INT64_C(0x0000000004000206), 0x1.0000818p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffdf9), -0x1.000081cp+26, 0x0p+0 },
{ INT64_C(0x0000000004000208), 0x1.000082p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffdf7), -0x1.0000824p+26, 0x0p+0 },
{ INT64_C(0x0000000004000209), 0x1.0000824p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffdf6), -0x1.0000828p+26, 0x0p+0 },
{ INT64_C(0x000000000400020c), 0x1.000083p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffdf3), -0x1.0000834p+26, 0x0p+0 },
{ INT64_C(0x0000000004000280), 0x1.0000ap+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffd7f), -0x1.0000a04p+26, 0x0p+0 },
{ INT64_C(0x0000000004000282), 0x1.0000a08p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffd7d), -0x1.0000a0cp+26, 0x0p+0 },
{ INT64_C(0x0000000004000284), 0x1.0000a1p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffd7b), -0x1.0000a14p+26, 0x0p+0 },
{ INT64_C(0x00000000040002a0), 0x1.0000a8p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffd5f), -0x1.0000a84p+26, 0x0p+0 },
{ INT64_C(0x00000000040002c0), 0x1.0000bp+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffd3f), -0x1.0000b04p+26, 0x0p+0 },
{ INT64_C(0x0000000004000401), 0x1.0001004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffbfe), -0x1.0001008p+26, 0x0p+0 },
{ INT64_C(0x0000000004000408), 0x1.000102p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffbf7), -0x1.0001024p+26, 0x0p+0 },
{ INT64_C(0x000000000400040c), 0x1.000103p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffbf3), -0x1.0001034p+26, 0x0p+0 },
{ INT64_C(0x0000000004000410), 0x1.000104p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffbef), -0x1.0001044p+26, 0x0p+0 },
{ INT64_C(0x0000000004000414), 0x1.000105p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffbeb), -0x1.0001054p+26, 0x0p+0 },
{ INT64_C(0x0000000004000480), 0x1.00012p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffb7f), -0x1.0001204p+26, 0x0p+0 },
{ INT64_C(0x0000000004000482), 0x1.0001208p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffb7d), -0x1.000120cp+26, 0x0p+0 },
{ INT64_C(0x00000000040004a0), 0x1.000128p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfffb5f), -0x1.0001284p+26, 0x0p+0 },
{ INT64_C(0x0000000004002002), 0x1.0008008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdffd), -0x1.000800cp+26, 0x0p+0 },
{ INT64_C(0x0000000004002004), 0x1.000801p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdffb), -0x1.0008014p+26, 0x0p+0 },
{ INT64_C(0x0000000004002006), 0x1.0008018p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdff9), -0x1.000801cp+26, 0x0p+0 },
{ INT64_C(0x0000000004002040), 0x1.00081p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdfbf), -0x1.0008104p+26, 0x0p+0 },
{ INT64_C(0x0000000004002041), 0x1.0008104p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdfbe), -0x1.0008108p+26, 0x0p+0 },
{ INT64_C(0x0000000004002048), 0x1.000812p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdfb7), -0x1.0008124p+26, 0x0p+0 },
{ INT64_C(0x0000000004002050), 0x1.000814p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdfaf), -0x1.0008144p+26, 0x0p+0 },
{ INT64_C(0x0000000004002060), 0x1.000818p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdf9f), -0x1.0008184p+26, 0x0p+0 },
{ INT64_C(0x0000000004002400), 0x1.0009p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdbff), -0x1.0009004p+26, 0x0p+0 },
{ INT64_C(0x0000000004002401), 0x1.0009004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdbfe), -0x1.0009008p+26, 0x0p+0 },
{ INT64_C(0x0000000004002404), 0x1.000901p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdbfb), -0x1.0009014p+26, 0x0p+0 },
{ INT64_C(0x0000000004002440), 0x1.00091p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdbbf), -0x1.0009104p+26, 0x0p+0 },
{ INT64_C(0x0000000004002480), 0x1.00092p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdb7f), -0x1.0009204p+26, 0x0p+0 },
{ INT64_C(0x0000000004002500), 0x1.00094p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffdaff), -0x1.0009404p+26, 0x0p+0 },
{ INT64_C(0x0000000004002600), 0x1.00098p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbffd9ff), -0x1.0009804p+26, 0x0p+0 },
{ INT64_C(0x0000000004008004), 0x1.002001p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff7ffb), -0x1.0020014p+26, 0x0p+0 },
{ INT64_C(0x0000000004008008), 0x1.002002p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff7ff7), -0x1.0020024p+26, 0x0p+0 },
{ INT64_C(0x000000000400800c), 0x1.002003p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff7ff3), -0x1.0020034p+26, 0x0p+0 },
{ INT64_C(0x0000000004008020), 0x1.002008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff7fdf), -0x1.0020084p+26, 0x0p+0 },
{ INT64_C(0x0000000004008028), 0x1.00200ap+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff7fd7), -0x1.00200a4p+26, 0x0p+0 },
{ INT64_C(0x0000000004008200), 0x1.00208p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff7dff), -0x1.0020804p+26, 0x0p+0 },
{ INT64_C(0x0000000004008202), 0x1.0020808p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff7dfd), -0x1.002080cp+26, 0x0p+0 },
{ INT64_C(0x0000000004008220), 0x1.002088p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff7ddf), -0x1.0020884p+26, 0x0p+0 },
{ INT64_C(0x0000000004008280), 0x1.0020ap+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff7d7f), -0x1.0020a04p+26, 0x0p+0 },
{ INT64_C(0x0000000004008300), 0x1.0020cp+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff7cff), -0x1.0020c04p+26, 0x0p+0 },
{ INT64_C(0x0000000004008800), 0x1.0022p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff77ff), -0x1.0022004p+26, 0x0p+0 },
{ INT64_C(0x0000000004008802), 0x1.0022008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff77fd), -0x1.002200cp+26, 0x0p+0 },
{ INT64_C(0x0000000004008808), 0x1.002202p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff77f7), -0x1.0022024p+26, 0x0p+0 },
{ INT64_C(0x0000000004008840), 0x1.00221p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff77bf), -0x1.0022104p+26, 0x0p+0 },
{ INT64_C(0x0000000004008900), 0x1.00224p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff76ff), -0x1.0022404p+26, 0x0p+0 },
{ INT64_C(0x0000000004008a00), 0x1.00228p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff75ff), -0x1.0022804p+26, 0x0p+0 },
{ INT64_C(0x000000000400c000), 0x1.003p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff3fff), -0x1.0030004p+26, 0x0p+0 },
{ INT64_C(0x000000000400c002), 0x1.0030008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff3ffd), -0x1.003000cp+26, 0x0p+0 },
{ INT64_C(0x000000000400c010), 0x1.003004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff3fef), -0x1.0030044p+26, 0x0p+0 },
{ INT64_C(0x000000000400c080), 0x1.00302p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff3f7f), -0x1.0030204p+26, 0x0p+0 },
{ INT64_C(0x000000000400c800), 0x1.0032p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbff37ff), -0x1.0032004p+26, 0x0p+0 },
{ INT64_C(0x0000000004020008), 0x1.008002p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdfff7), -0x1.0080024p+26, 0x0p+0 },
{ INT64_C(0x0000000004020009), 0x1.0080024p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdfff6), -0x1.0080028p+26, 0x0p+0 },
{ INT64_C(0x0000000004020010), 0x1.008004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdffef), -0x1.0080044p+26, 0x0p+0 },
{ INT64_C(0x0000000004020018), 0x1.008006p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdffe7), -0x1.0080064p+26, 0x0p+0 },
{ INT64_C(0x0000000004020100), 0x1.00804p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdfeff), -0x1.0080404p+26, 0x0p+0 },
{ INT64_C(0x0000000004020108), 0x1.008042p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdfef7), -0x1.0080424p+26, 0x0p+0 },
{ INT64_C(0x0000000004020110), 0x1.008044p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdfeef), -0x1.0080444p+26, 0x0p+0 },
{ INT64_C(0x0000000004020120), 0x1.008048p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdfedf), -0x1.0080484p+26, 0x0p+0 },
{ INT64_C(0x0000000004020180), 0x1.00806p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdfe7f), -0x1.0080604p+26, 0x0p+0 },
{ INT64_C(0x0000000004020800), 0x1.0082p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdf7ff), -0x1.0082004p+26, 0x0p+0 },
{ INT64_C(0x0000000004020808), 0x1.008202p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdf7f7), -0x1.0082024p+26, 0x0p+0 },
{ INT64_C(0x0000000004020880), 0x1.00822p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdf77f), -0x1.0082204p+26, 0x0p+0 },
{ INT64_C(0x0000000004022000), 0x1.0088p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfddfff), -0x1.0088004p+26, 0x0p+0 },
{ INT64_C(0x0000000004022001), 0x1.0088004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfddffe), -0x1.0088008p+26, 0x0p+0 },
{ INT64_C(0x0000000004022004), 0x1.008801p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfddffb), -0x1.0088014p+26, 0x0p+0 },
{ INT64_C(0x0000000004022010), 0x1.008804p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfddfef), -0x1.0088044p+26, 0x0p+0 },
{ INT64_C(0x0000000004022100), 0x1.00884p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfddeff), -0x1.0088404p+26, 0x0p+0 },
{ INT64_C(0x0000000004023000), 0x1.008cp+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfdcfff), -0x1.008c004p+26, 0x0p+0 },
{ INT64_C(0x0000000004030000), 0x1.00cp+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfcffff), -0x1.00c0004p+26, 0x0p+0 },
{ INT64_C(0x0000000004030004), 0x1.00c001p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfcfffb), -0x1.00c0014p+26, 0x0p+0 },
{ INT64_C(0x0000000004030040), 0x1.00c01p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfcffbf), -0x1.00c0104p+26, 0x0p+0 },
{ INT64_C(0x0000000004030080), 0x1.00c02p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfcff7f), -0x1.00c0204p+26, 0x0p+0 },
{ INT64_C(0x0000000004030800), 0x1.00c2p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfcf7ff), -0x1.00c2004p+26, 0x0p+0 },
{ INT64_C(0x0000000004038000), 0x1.00ep+26, 0x0p+0 },
{ INT64_C(0xfffffffffbfc7fff), -0x1.00e0004p+26, 0x0p+0 },
{ INT64_C(0x0000000004200001), 0x1.0800004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdffffe), -0x1.0800008p+26, 0x0p+0 },
{ INT64_C(0x0000000004200004), 0x1.080001p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdffffb), -0x1.0800014p+26, 0x0p+0 },
{ INT64_C(0x0000000004200020), 0x1.080008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdfffdf), -0x1.0800084p+26, 0x0p+0 },
{ INT64_C(0x0000000004200024), 0x1.080009p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdfffdb), -0x1.0800094p+26, 0x0p+0 },
{ INT64_C(0x0000000004200040), 0x1.08001p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdfffbf), -0x1.0800104p+26, 0x0p+0 },
{ INT64_C(0x0000000004200041), 0x1.0800104p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdfffbe), -0x1.0800108p+26, 0x0p+0 },
{ INT64_C(0x0000000004200044), 0x1.080011p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdfffbb), -0x1.0800114p+26, 0x0p+0 },
{ INT64_C(0x0000000004200060), 0x1.080018p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdfff9f), -0x1.0800184p+26, 0x0p+0 },
{ INT64_C(0x0000000004200100), 0x1.08004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdffeff), -0x1.0800404p+26, 0x0p+0 },
{ INT64_C(0x0000000004200101), 0x1.0800404p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdffefe), -0x1.0800408p+26, 0x0p+0 },
{ INT64_C(0x0000000004200104), 0x1.080041p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdffefb), -0x1.0800414p+26, 0x0p+0 },
{ INT64_C(0x0000000004200110), 0x1.080044p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdffeef), -0x1.0800444p+26, 0x0p+0 },
{ INT64_C(0x0000000004200800), 0x1.0802p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdff7ff), -0x1.0802004p+26, 0x0p+0 },
{ INT64_C(0x0000000004200808), 0x1.080202p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdff7f7), -0x1.0802024p+26, 0x0p+0 },
{ INT64_C(0x0000000004200820), 0x1.080208p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdff7df), -0x1.0802084p+26, 0x0p+0 },
{ INT64_C(0x0000000004200840), 0x1.08021p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdff7bf), -0x1.0802104p+26, 0x0p+0 },
{ INT64_C(0x0000000004200880), 0x1.08022p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdff77f), -0x1.0802204p+26, 0x0p+0 },
{ INT64_C(0x0000000004200c00), 0x1.0803p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdff3ff), -0x1.0803004p+26, 0x0p+0 },
{ INT64_C(0x0000000004208000), 0x1.082p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdf7fff), -0x1.0820004p+26, 0x0p+0 },
{ INT64_C(0x0000000004208001), 0x1.0820004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdf7ffe), -0x1.0820008p+26, 0x0p+0 },
{ INT64_C(0x0000000004208010), 0x1.082004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdf7fef), -0x1.0820044p+26, 0x0p+0 },
{ INT64_C(0x0000000004208040), 0x1.08201p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdf7fbf), -0x1.0820104p+26, 0x0p+0 },
{ INT64_C(0x0000000004208100), 0x1.08204p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdf7eff), -0x1.0820404p+26, 0x0p+0 },
{ INT64_C(0x0000000004208200), 0x1.08208p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdf7dff), -0x1.0820804p+26, 0x0p+0 },
{ INT64_C(0x0000000004209000), 0x1.0824p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdf6fff), -0x1.0824004p+26, 0x0p+0 },
{ INT64_C(0x000000000420c000), 0x1.083p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdf3fff), -0x1.0830004p+26, 0x0p+0 },
{ INT64_C(0x0000000004210000), 0x1.084p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdeffff), -0x1.0840004p+26, 0x0p+0 },
{ INT64_C(0x0000000004210008), 0x1.084002p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdefff7), -0x1.0840024p+26, 0x0p+0 },
{ INT64_C(0x0000000004210040), 0x1.08401p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdeffbf), -0x1.0840104p+26, 0x0p+0 },
{ INT64_C(0x0000000004210200), 0x1.08408p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdefdff), -0x1.0840804p+26, 0x0p+0 },
{ INT64_C(0x0000000004212000), 0x1.0848p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdedfff), -0x1.0848004p+26, 0x0p+0 },
{ INT64_C(0x0000000004218000), 0x1.086p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbde7fff), -0x1.0860004p+26, 0x0p+0 },
{ INT64_C(0x0000000004240000), 0x1.09p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdbffff), -0x1.0900004p+26, 0x0p+0 },
{ INT64_C(0x0000000004240008), 0x1.090002p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdbfff7), -0x1.0900024p+26, 0x0p+0 },
{ INT64_C(0x0000000004240010), 0x1.090004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdbffef), -0x1.0900044p+26, 0x0p+0 },
{ INT64_C(0x0000000004240020), 0x1.090008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdbffdf), -0x1.0900084p+26, 0x0p+0 },
{ INT64_C(0x0000000004240200), 0x1.09008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdbfdff), -0x1.0900804p+26, 0x0p+0 },
{ INT64_C(0x0000000004241000), 0x1.0904p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdbefff), -0x1.0904004p+26, 0x0p+0 },
{ INT64_C(0x0000000004242000), 0x1.0908p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdbdfff), -0x1.0908004p+26, 0x0p+0 },
{ INT64_C(0x0000000004244000), 0x1.091p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbdbbfff), -0x1.0910004p+26, 0x0p+0 },
{ INT64_C(0x0000000004260000), 0x1.098p+26, 0x0p+0 },
{ INT64_C(0xfffffffffbd9ffff), -0x1.0980004p+26, 0x0p+0 },
{ INT64_C(0x0000000005000008), 0x1.400002p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafffff7), -0x1.4000024p+26, 0x0p+0 },
{ INT64_C(0x000000000500000c), 0x1.400003p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafffff3), -0x1.4000034p+26, 0x0p+0 },
{ INT64_C(0x0000000005000020), 0x1.400008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaffffdf), -0x1.4000084p+26, 0x0p+0 },
{ INT64_C(0x0000000005000028), 0x1.40000ap+26, 0x0p+0 },
{ INT64_C(0xfffffffffaffffd7), -0x1.40000a4p+26, 0x0p+0 },
{ INT64_C(0x0000000005000030), 0x1.40000cp+26, 0x0p+0 },
{ INT64_C(0xfffffffffaffffcf), -0x1.40000c4p+26, 0x0p+0 },
{ INT64_C(0x0000000005000200), 0x1.40008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafffdff), -0x1.4000804p+26, 0x0p+0 },
{ INT64_C(0x0000000005000204), 0x1.400081p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafffdfb), -0x1.4000814p+26, 0x0p+0 },
{ INT64_C(0x0000000005000220), 0x1.400088p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafffddf), -0x1.4000884p+26, 0x0p+0 },
{ INT64_C(0x0000000005000800), 0x1.4002p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafff7ff), -0x1.4002004p+26, 0x0p+0 },
{ INT64_C(0x0000000005000802), 0x1.4002008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafff7fd), -0x1.400200cp+26, 0x0p+0 },
{ INT64_C(0x0000000005000820), 0x1.400208p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafff7df), -0x1.4002084p+26, 0x0p+0 },
{ INT64_C(0x0000000005000a00), 0x1.40028p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafff5ff), -0x1.4002804p+26, 0x0p+0 },
{ INT64_C(0x0000000005001000), 0x1.4004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaffefff), -0x1.4004004p+26, 0x0p+0 },
{ INT64_C(0x0000000005001001), 0x1.4004004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaffeffe), -0x1.4004008p+26, 0x0p+0 },
{ INT64_C(0x0000000005001010), 0x1.400404p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaffefef), -0x1.4004044p+26, 0x0p+0 },
{ INT64_C(0x0000000005001100), 0x1.40044p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaffeeff), -0x1.4004404p+26, 0x0p+0 },
{ INT64_C(0x0000000005008000), 0x1.402p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaff7fff), -0x1.4020004p+26, 0x0p+0 },
{ INT64_C(0x0000000005008001), 0x1.4020004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaff7ffe), -0x1.4020008p+26, 0x0p+0 },
{ INT64_C(0x0000000005008010), 0x1.402004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaff7fef), -0x1.4020044p+26, 0x0p+0 },
{ INT64_C(0x0000000005008040), 0x1.40201p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaff7fbf), -0x1.4020104p+26, 0x0p+0 },
{ INT64_C(0x0000000005008100), 0x1.40204p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaff7eff), -0x1.4020404p+26, 0x0p+0 },
{ INT64_C(0x0000000005008200), 0x1.40208p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaff7dff), -0x1.4020804p+26, 0x0p+0 },
{ INT64_C(0x0000000005008800), 0x1.4022p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaff77ff), -0x1.4022004p+26, 0x0p+0 },
{ INT64_C(0x000000000500c000), 0x1.403p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaff3fff), -0x1.4030004p+26, 0x0p+0 },
{ INT64_C(0x0000000005010000), 0x1.404p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafeffff), -0x1.4040004p+26, 0x0p+0 },
{ INT64_C(0x0000000005010002), 0x1.4040008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafefffd), -0x1.404000cp+26, 0x0p+0 },
{ INT64_C(0x0000000005010020), 0x1.404008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafeffdf), -0x1.4040084p+26, 0x0p+0 },
{ INT64_C(0x0000000005010100), 0x1.40404p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafefeff), -0x1.4040404p+26, 0x0p+0 },
{ INT64_C(0x0000000005011000), 0x1.4044p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafeefff), -0x1.4044004p+26, 0x0p+0 },
{ INT64_C(0x0000000005012000), 0x1.4048p+26, 0x0p+0 },
{ INT64_C(0xfffffffffafedfff), -0x1.4048004p+26, 0x0p+0 },
{ INT64_C(0x0000000005100000), 0x1.44p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaefffff), -0x1.4400004p+26, 0x0p+0 },
{ INT64_C(0x0000000005100004), 0x1.440001p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaeffffb), -0x1.4400014p+26, 0x0p+0 },
{ INT64_C(0x0000000005100020), 0x1.440008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaefffdf), -0x1.4400084p+26, 0x0p+0 },
{ INT64_C(0x0000000005100040), 0x1.44001p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaefffbf), -0x1.4400104p+26, 0x0p+0 },
{ INT64_C(0x0000000005100200), 0x1.44008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaeffdff), -0x1.4400804p+26, 0x0p+0 },
{ INT64_C(0x0000000005100400), 0x1.4401p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaeffbff), -0x1.4401004p+26, 0x0p+0 },
{ INT64_C(0x0000000005101000), 0x1.4404p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaefefff), -0x1.4404004p+26, 0x0p+0 },
{ INT64_C(0x0000000005104000), 0x1.441p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaefbfff), -0x1.4410004p+26, 0x0p+0 },
{ INT64_C(0x0000000005140000), 0x1.45p+26, 0x0p+0 },
{ INT64_C(0xfffffffffaebffff), -0x1.4500004p+26, 0x0p+0 },
{ INT64_C(0x0000000005200000), 0x1.48p+26, 0x0p+0 },
{ INT64_C(0xfffffffffadfffff), -0x1.4800004p+26, 0x0p+0 },
{ INT64_C(0x0000000005200002), 0x1.4800008p+26, 0x0p+0 },
{ INT64_C(0xfffffffffadffffd), -0x1.480000cp+26, 0x0p+0 },
{ INT64_C(0x0000000005200010), 0x1.480004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffadfffef), -0x1.4800044p+26, 0x0p+0 },
{ INT64_C(0x0000000005200040), 0x1.48001p+26, 0x0p+0 },
{ INT64_C(0xfffffffffadfffbf), -0x1.4800104p+26, 0x0p+0 },
{ INT64_C(0x0000000005200100), 0x1.48004p+26, 0x0p+0 },
{ INT64_C(0xfffffffffadffeff), -0x1.4800404p+26, 0x0p+0 },
{ INT64_C(0x0000000005200400), 0x1.4801p+26, 0x0p+0 },
{ INT64_C(0xfffffffffadffbff), -0x1.4801004p+26, 0x0p+0 },
{ INT64_C(0x0000000005202000), 0x1.4808p+26, 0x0p+0 },
{ INT64_C(0xfffffffffadfdfff), -0x1.4808004p+26, 0x0p+0 },
{ INT64_C(0x0000000005204000), 0x1.481p+26, 0x0p+0 },
{ INT64_C(0xfffffffffadfbfff), -0x1.4810004p+26, 0x0p+0 },
{ INT64_C(0x0000000005208000), 0x1.482p+26, 0x0p+0 },
{ INT64_C(0xfffffffffadf7fff), -0x1.4820004p+26, 0x0p+0 },
{ INT64_C(0x0000000005240000), 0x1.49p+26, 0x0p+0 },
{ INT64_C(0xfffffffffadbffff), -0x1.4900004p+26, 0x0p+0 },
{ INT64_C(0x0000000020000022), 0x1.0000011p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfffffdd), -0x1.00000118p+29, 0x0p+0 },
{ INT64_C(0x0000000020000024), 0x1.0000012p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfffffdb), -0x1.00000128p+29, 0x0p+0 },
{ INT64_C(0x0000000020000025), 0x1.00000128p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfffffda), -0x1.0000013p+29, 0x0p+0 },
{ INT64_C(0x0000000020000028), 0x1.0000014p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfffffd7), -0x1.00000148p+29, 0x0p+0 },
{ INT64_C(0x0000000020000030), 0x1.0000018p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfffffcf), -0x1.00000188p+29, 0x0p+0 },
{ INT64_C(0x0000000020000034), 0x1.000001ap+29, 0x0p+0 },
{ INT64_C(0xffffffffdfffffcb), -0x1.000001a8p+29, 0x0p+0 },
{ INT64_C(0x0000000020000038), 0x1.000001cp+29, 0x0p+0 },
{ INT64_C(0xffffffffdfffffc7), -0x1.000001c8p+29, 0x0p+0 },
{ INT64_C(0x0000000020000044), 0x1.0000022p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfffffbb), -0x1.00000228p+29, 0x0p+0 },
{ INT64_C(0x0000000020000050), 0x1.0000028p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfffffaf), -0x1.00000288p+29, 0x0p+0 },
{ INT64_C(0x0000000020000058), 0x1.000002cp+29, 0x0p+0 },
{ INT64_C(0xffffffffdfffffa7), -0x1.000002c8p+29, 0x0p+0 },
{ INT64_C(0x0000000020000102), 0x1.0000081p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffefd), -0x1.00000818p+29, 0x0p+0 },
{ INT64_C(0x0000000020000108), 0x1.0000084p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffef7), -0x1.00000848p+29, 0x0p+0 },
{ INT64_C(0x000000002000010c), 0x1.0000086p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffef3), -0x1.00000868p+29, 0x0p+0 },
{ INT64_C(0x0000000020000120), 0x1.000009p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffedf), -0x1.00000908p+29, 0x0p+0 },
{ INT64_C(0x0000000020000122), 0x1.0000091p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffedd), -0x1.00000918p+29, 0x0p+0 },
{ INT64_C(0x0000000020000128), 0x1.0000094p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffed7), -0x1.00000948p+29, 0x0p+0 },
{ INT64_C(0x0000000020000140), 0x1.00000ap+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffebf), -0x1.00000a08p+29, 0x0p+0 },
{ INT64_C(0x0000000020000148), 0x1.00000a4p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffeb7), -0x1.00000a48p+29, 0x0p+0 },
{ INT64_C(0x0000000020000160), 0x1.00000bp+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffe9f), -0x1.00000b08p+29, 0x0p+0 },
{ INT64_C(0x0000000020000202), 0x1.0000101p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffdfd), -0x1.00001018p+29, 0x0p+0 },
{ INT64_C(0x0000000020000210), 0x1.0000108p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffdef), -0x1.00001088p+29, 0x0p+0 },
{ INT64_C(0x0000000020000218), 0x1.000010cp+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffde7), -0x1.000010c8p+29, 0x0p+0 },
{ INT64_C(0x0000000020000240), 0x1.000012p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffdbf), -0x1.00001208p+29, 0x0p+0 },
{ INT64_C(0x0000000020000244), 0x1.0000122p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffdbb), -0x1.00001228p+29, 0x0p+0 },
{ INT64_C(0x0000000020000404), 0x1.0000202p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffbfb), -0x1.00002028p+29, 0x0p+0 },
{ INT64_C(0x0000000020000420), 0x1.000021p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffbdf), -0x1.00002108p+29, 0x0p+0 },
{ INT64_C(0x0000000020000421), 0x1.00002108p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffbde), -0x1.0000211p+29, 0x0p+0 },
{ INT64_C(0x0000000020000422), 0x1.0000211p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffbdd), -0x1.00002118p+29, 0x0p+0 },
{ INT64_C(0x0000000020000424), 0x1.0000212p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffbdb), -0x1.00002128p+29, 0x0p+0 },
{ INT64_C(0x0000000020000440), 0x1.000022p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffbbf), -0x1.00002208p+29, 0x0p+0 },
{ INT64_C(0x0000000020000441), 0x1.00002208p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffbbe), -0x1.0000221p+29, 0x0p+0 },
{ INT64_C(0x0000000020000448), 0x1.0000224p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffbb7), -0x1.00002248p+29, 0x0p+0 },
{ INT64_C(0x0000000020000450), 0x1.0000228p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffffbaf), -0x1.00002288p+29, 0x0p+0 },
{ INT64_C(0x0000000020000808), 0x1.0000404p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffff7f7), -0x1.00004048p+29, 0x0p+0 },
{ INT64_C(0x000000002000080a), 0x1.0000405p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffff7f5), -0x1.00004058p+29, 0x0p+0 },
{ INT64_C(0x0000000020000810), 0x1.0000408p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffff7ef), -0x1.00004088p+29, 0x0p+0 },
{ INT64_C(0x0000000020000818), 0x1.000040cp+29, 0x0p+0 },
{ INT64_C(0xffffffffdffff7e7), -0x1.000040c8p+29, 0x0p+0 },
{ INT64_C(0x0000000020000900), 0x1.000048p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffff6ff), -0x1.00004808p+29, 0x0p+0 },
{ INT64_C(0x0000000020000902), 0x1.0000481p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffff6fd), -0x1.00004818p+29, 0x0p+0 },
{ INT64_C(0x0000000020000920), 0x1.000049p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffff6df), -0x1.00004908p+29, 0x0p+0 },
{ INT64_C(0x0000000020000980), 0x1.00004cp+29, 0x0p+0 },
{ INT64_C(0xffffffffdffff67f), -0x1.00004c08p+29, 0x0p+0 },
{ INT64_C(0x0000000020008001), 0x1.00040008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7ffe), -0x1.0004001p+29, 0x0p+0 },
{ INT64_C(0x0000000020008010), 0x1.0004008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7fef), -0x1.00040088p+29, 0x0p+0 },
{ INT64_C(0x0000000020008014), 0x1.000400ap+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7feb), -0x1.000400a8p+29, 0x0p+0 },
{ INT64_C(0x0000000020008020), 0x1.000401p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7fdf), -0x1.00040108p+29, 0x0p+0 },
{ INT64_C(0x0000000020008022), 0x1.0004011p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7fdd), -0x1.00040118p+29, 0x0p+0 },
{ INT64_C(0x0000000020008030), 0x1.0004018p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7fcf), -0x1.00040188p+29, 0x0p+0 },
{ INT64_C(0x0000000020008100), 0x1.000408p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7eff), -0x1.00040808p+29, 0x0p+0 },
{ INT64_C(0x0000000020008101), 0x1.00040808p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7efe), -0x1.0004081p+29, 0x0p+0 },
{ INT64_C(0x0000000020008102), 0x1.0004081p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7efd), -0x1.00040818p+29, 0x0p+0 },
{ INT64_C(0x0000000020008108), 0x1.0004084p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7ef7), -0x1.00040848p+29, 0x0p+0 },
{ INT64_C(0x0000000020008180), 0x1.00040cp+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7e7f), -0x1.00040c08p+29, 0x0p+0 },
{ INT64_C(0x0000000020008200), 0x1.00041p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7dff), -0x1.00041008p+29, 0x0p+0 },
{ INT64_C(0x0000000020008201), 0x1.00041008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7dfe), -0x1.0004101p+29, 0x0p+0 },
{ INT64_C(0x0000000020008210), 0x1.0004108p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7def), -0x1.00041088p+29, 0x0p+0 },
{ INT64_C(0x0000000020008280), 0x1.000414p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff7d7f), -0x1.00041408p+29, 0x0p+0 },
{ INT64_C(0x000000002000a000), 0x1.0005p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff5fff), -0x1.00050008p+29, 0x0p+0 },
{ INT64_C(0x000000002000a002), 0x1.0005001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff5ffd), -0x1.00050018p+29, 0x0p+0 },
{ INT64_C(0x000000002000a004), 0x1.0005002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff5ffb), -0x1.00050028p+29, 0x0p+0 },
{ INT64_C(0x000000002000a010), 0x1.0005008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff5fef), -0x1.00050088p+29, 0x0p+0 },
{ INT64_C(0x000000002000a020), 0x1.000501p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff5fdf), -0x1.00050108p+29, 0x0p+0 },
{ INT64_C(0x000000002000a040), 0x1.000502p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff5fbf), -0x1.00050208p+29, 0x0p+0 },
{ INT64_C(0x000000002000a080), 0x1.000504p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff5f7f), -0x1.00050408p+29, 0x0p+0 },
{ INT64_C(0x000000002000a400), 0x1.00052p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff5bff), -0x1.00052008p+29, 0x0p+0 },
{ INT64_C(0x000000002000b000), 0x1.00058p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfff4fff), -0x1.00058008p+29, 0x0p+0 },
{ INT64_C(0x0000000020040002), 0x1.0020001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbfffd), -0x1.00200018p+29, 0x0p+0 },
{ INT64_C(0x0000000020040008), 0x1.0020004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbfff7), -0x1.00200048p+29, 0x0p+0 },
{ INT64_C(0x000000002004000c), 0x1.0020006p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbfff3), -0x1.00200068p+29, 0x0p+0 },
{ INT64_C(0x0000000020040040), 0x1.002002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbffbf), -0x1.00200208p+29, 0x0p+0 },
{ INT64_C(0x0000000020040044), 0x1.0020022p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbffbb), -0x1.00200228p+29, 0x0p+0 },
{ INT64_C(0x0000000020040400), 0x1.00202p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbfbff), -0x1.00202008p+29, 0x0p+0 },
{ INT64_C(0x0000000020040408), 0x1.0020204p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbfbf7), -0x1.00202048p+29, 0x0p+0 },
{ INT64_C(0x0000000020040420), 0x1.002021p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbfbdf), -0x1.00202108p+29, 0x0p+0 },
{ INT64_C(0x0000000020040500), 0x1.002028p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbfaff), -0x1.00202808p+29, 0x0p+0 },
{ INT64_C(0x0000000020041000), 0x1.00208p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbefff), -0x1.00208008p+29, 0x0p+0 },
{ INT64_C(0x0000000020041008), 0x1.0020804p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbeff7), -0x1.00208048p+29, 0x0p+0 },
{ INT64_C(0x0000000020041040), 0x1.002082p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbefbf), -0x1.00208208p+29, 0x0p+0 },
{ INT64_C(0x0000000020041400), 0x1.0020ap+29, 0x0p+0 },
{ INT64_C(0xffffffffdffbebff), -0x1.0020a008p+29, 0x0p+0 },
{ INT64_C(0x0000000020050000), 0x1.0028p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffaffff), -0x1.00280008p+29, 0x0p+0 },
{ INT64_C(0x0000000020050004), 0x1.0028002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffafffb), -0x1.00280028p+29, 0x0p+0 },
{ INT64_C(0x0000000020050010), 0x1.0028008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffaffef), -0x1.00280088p+29, 0x0p+0 },
{ INT64_C(0x0000000020050100), 0x1.002808p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffafeff), -0x1.00280808p+29, 0x0p+0 },
{ INT64_C(0x0000000020050800), 0x1.00284p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffaf7ff), -0x1.00284008p+29, 0x0p+0 },
{ INT64_C(0x0000000020051000), 0x1.00288p+29, 0x0p+0 },
{ INT64_C(0xffffffffdffaefff), -0x1.00288008p+29, 0x0p+0 },
{ INT64_C(0x0000000020054000), 0x1.002ap+29, 0x0p+0 },
{ INT64_C(0xffffffffdffabfff), -0x1.002a0008p+29, 0x0p+0 },
{ INT64_C(0x0000000020080004), 0x1.0040002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7fffb), -0x1.00400028p+29, 0x0p+0 },
{ INT64_C(0x0000000020080008), 0x1.0040004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7fff7), -0x1.00400048p+29, 0x0p+0 },
{ INT64_C(0x0000000020080010), 0x1.0040008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7ffef), -0x1.00400088p+29, 0x0p+0 },
{ INT64_C(0x0000000020080018), 0x1.004000cp+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7ffe7), -0x1.004000c8p+29, 0x0p+0 },
{ INT64_C(0x0000000020080020), 0x1.004001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7ffdf), -0x1.00400108p+29, 0x0p+0 },
{ INT64_C(0x0000000020080024), 0x1.0040012p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7ffdb), -0x1.00400128p+29, 0x0p+0 },
{ INT64_C(0x0000000020080080), 0x1.004004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7ff7f), -0x1.00400408p+29, 0x0p+0 },
{ INT64_C(0x0000000020080084), 0x1.0040042p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7ff7b), -0x1.00400428p+29, 0x0p+0 },
{ INT64_C(0x00000000200800c0), 0x1.004006p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7ff3f), -0x1.00400608p+29, 0x0p+0 },
{ INT64_C(0x0000000020080200), 0x1.00401p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7fdff), -0x1.00401008p+29, 0x0p+0 },
{ INT64_C(0x0000000020080202), 0x1.0040101p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7fdfd), -0x1.00401018p+29, 0x0p+0 },
{ INT64_C(0x0000000020080210), 0x1.0040108p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7fdef), -0x1.00401088p+29, 0x0p+0 },
{ INT64_C(0x0000000020080220), 0x1.004011p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7fddf), -0x1.00401108p+29, 0x0p+0 },
{ INT64_C(0x0000000020080300), 0x1.004018p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7fcff), -0x1.00401808p+29, 0x0p+0 },
{ INT64_C(0x0000000020081000), 0x1.00408p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7efff), -0x1.00408008p+29, 0x0p+0 },
{ INT64_C(0x0000000020081008), 0x1.0040804p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7eff7), -0x1.00408048p+29, 0x0p+0 },
{ INT64_C(0x0000000020081010), 0x1.0040808p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7efef), -0x1.00408088p+29, 0x0p+0 },
{ INT64_C(0x0000000020081100), 0x1.004088p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7eeff), -0x1.00408808p+29, 0x0p+0 },
{ INT64_C(0x0000000020081800), 0x1.0040cp+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7e7ff), -0x1.0040c008p+29, 0x0p+0 },
{ INT64_C(0x0000000020082000), 0x1.0041p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7dfff), -0x1.00410008p+29, 0x0p+0 },
{ INT64_C(0x0000000020082008), 0x1.0041004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7dff7), -0x1.00410048p+29, 0x0p+0 },
{ INT64_C(0x0000000020082010), 0x1.0041008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7dfef), -0x1.00410088p+29, 0x0p+0 },
{ INT64_C(0x0000000020082020), 0x1.004101p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7dfdf), -0x1.00410108p+29, 0x0p+0 },
{ INT64_C(0x0000000020082040), 0x1.004102p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7dfbf), -0x1.00410208p+29, 0x0p+0 },
{ INT64_C(0x0000000020082080), 0x1.004104p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7df7f), -0x1.00410408p+29, 0x0p+0 },
{ INT64_C(0x0000000020082400), 0x1.00412p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff7dbff), -0x1.00412008p+29, 0x0p+0 },
{ INT64_C(0x00000000200a0000), 0x1.005p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff5ffff), -0x1.00500008p+29, 0x0p+0 },
{ INT64_C(0x00000000200a0001), 0x1.00500008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff5fffe), -0x1.0050001p+29, 0x0p+0 },
{ INT64_C(0x00000000200a0010), 0x1.0050008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff5ffef), -0x1.00500088p+29, 0x0p+0 },
{ INT64_C(0x00000000200a0080), 0x1.005004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff5ff7f), -0x1.00500408p+29, 0x0p+0 },
{ INT64_C(0x00000000200a0800), 0x1.00504p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff5f7ff), -0x1.00504008p+29, 0x0p+0 },
{ INT64_C(0x00000000200a8000), 0x1.0054p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff57fff), -0x1.00540008p+29, 0x0p+0 },
{ INT64_C(0x00000000200b0000), 0x1.0058p+29, 0x0p+0 },
{ INT64_C(0xffffffffdff4ffff), -0x1.00580008p+29, 0x0p+0 },
{ INT64_C(0x0000000020100002), 0x1.0080001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeffffd), -0x1.00800018p+29, 0x0p+0 },
{ INT64_C(0x0000000020100003), 0x1.00800018p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeffffc), -0x1.0080002p+29, 0x0p+0 },
{ INT64_C(0x0000000020100020), 0x1.008001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfefffdf), -0x1.00800108p+29, 0x0p+0 },
{ INT64_C(0x0000000020100028), 0x1.0080014p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfefffd7), -0x1.00800148p+29, 0x0p+0 },
{ INT64_C(0x0000000020100200), 0x1.00801p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeffdff), -0x1.00801008p+29, 0x0p+0 },
{ INT64_C(0x0000000020100201), 0x1.00801008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeffdfe), -0x1.0080101p+29, 0x0p+0 },
{ INT64_C(0x0000000020100204), 0x1.0080102p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeffdfb), -0x1.00801028p+29, 0x0p+0 },
{ INT64_C(0x0000000020100240), 0x1.008012p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeffdbf), -0x1.00801208p+29, 0x0p+0 },
{ INT64_C(0x0000000020100300), 0x1.008018p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeffcff), -0x1.00801808p+29, 0x0p+0 },
{ INT64_C(0x0000000020100400), 0x1.00802p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeffbff), -0x1.00802008p+29, 0x0p+0 },
{ INT64_C(0x0000000020100401), 0x1.00802008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeffbfe), -0x1.0080201p+29, 0x0p+0 },
{ INT64_C(0x0000000020100402), 0x1.0080201p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeffbfd), -0x1.00802018p+29, 0x0p+0 },
{ INT64_C(0x0000000020100410), 0x1.0080208p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeffbef), -0x1.00802088p+29, 0x0p+0 },
{ INT64_C(0x0000000020100500), 0x1.008028p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeffaff), -0x1.00802808p+29, 0x0p+0 },
{ INT64_C(0x0000000020100800), 0x1.00804p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeff7ff), -0x1.00804008p+29, 0x0p+0 },
{ INT64_C(0x0000000020100802), 0x1.0080401p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeff7fd), -0x1.00804018p+29, 0x0p+0 },
{ INT64_C(0x0000000020100820), 0x1.008041p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeff7df), -0x1.00804108p+29, 0x0p+0 },
{ INT64_C(0x0000000020100900), 0x1.008048p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfeff6ff), -0x1.00804808p+29, 0x0p+0 },
{ INT64_C(0x0000000020101000), 0x1.00808p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfefefff), -0x1.00808008p+29, 0x0p+0 },
{ INT64_C(0x0000000020101008), 0x1.0080804p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfefeff7), -0x1.00808048p+29, 0x0p+0 },
{ INT64_C(0x0000000020101020), 0x1.008081p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfefefdf), -0x1.00808108p+29, 0x0p+0 },
{ INT64_C(0x0000000020101100), 0x1.008088p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfefeeff), -0x1.00808808p+29, 0x0p+0 },
{ INT64_C(0x0000000020108000), 0x1.0084p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfef7fff), -0x1.00840008p+29, 0x0p+0 },
{ INT64_C(0x0000000020108002), 0x1.0084001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfef7ffd), -0x1.00840018p+29, 0x0p+0 },
{ INT64_C(0x0000000020108020), 0x1.008401p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfef7fdf), -0x1.00840108p+29, 0x0p+0 },
{ INT64_C(0x0000000020108080), 0x1.008404p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfef7f7f), -0x1.00840408p+29, 0x0p+0 },
{ INT64_C(0x0000000020108200), 0x1.00841p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfef7dff), -0x1.00841008p+29, 0x0p+0 },
{ INT64_C(0x000000002010a000), 0x1.0085p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfef5fff), -0x1.00850008p+29, 0x0p+0 },
{ INT64_C(0x000000002010c000), 0x1.0086p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfef3fff), -0x1.00860008p+29, 0x0p+0 },
{ INT64_C(0x0000000020180000), 0x1.00cp+29, 0x0p+0 },
{ INT64_C(0xffffffffdfe7ffff), -0x1.00c00008p+29, 0x0p+0 },
{ INT64_C(0x0000000020180008), 0x1.00c0004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfe7fff7), -0x1.00c00048p+29, 0x0p+0 },
{ INT64_C(0x0000000020180010), 0x1.00c0008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfe7ffef), -0x1.00c00088p+29, 0x0p+0 },
{ INT64_C(0x0000000020180020), 0x1.00c001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfe7ffdf), -0x1.00c00108p+29, 0x0p+0 },
{ INT64_C(0x0000000020180100), 0x1.00c008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfe7feff), -0x1.00c00808p+29, 0x0p+0 },
{ INT64_C(0x0000000020180800), 0x1.00c04p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfe7f7ff), -0x1.00c04008p+29, 0x0p+0 },
{ INT64_C(0x0000000020188000), 0x1.00c4p+29, 0x0p+0 },
{ INT64_C(0xffffffffdfe77fff), -0x1.00c40008p+29, 0x0p+0 },
{ INT64_C(0x00000000201a0000), 0x1.00dp+29, 0x0p+0 },
{ INT64_C(0xffffffffdfe5ffff), -0x1.00d00008p+29, 0x0p+0 },
{ INT64_C(0x0000000020800008), 0x1.0400004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7ffff7), -0x1.04000048p+29, 0x0p+0 },
{ INT64_C(0x0000000020800009), 0x1.04000048p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7ffff6), -0x1.0400005p+29, 0x0p+0 },
{ INT64_C(0x0000000020800010), 0x1.0400008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fffef), -0x1.04000088p+29, 0x0p+0 },
{ INT64_C(0x0000000020800012), 0x1.0400009p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fffed), -0x1.04000098p+29, 0x0p+0 },
{ INT64_C(0x0000000020800080), 0x1.040004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fff7f), -0x1.04000408p+29, 0x0p+0 },
{ INT64_C(0x0000000020800082), 0x1.0400041p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fff7d), -0x1.04000418p+29, 0x0p+0 },
{ INT64_C(0x0000000020800088), 0x1.0400044p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fff77), -0x1.04000448p+29, 0x0p+0 },
{ INT64_C(0x0000000020800090), 0x1.0400048p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fff6f), -0x1.04000488p+29, 0x0p+0 },
{ INT64_C(0x0000000020800100), 0x1.040008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7ffeff), -0x1.04000808p+29, 0x0p+0 },
{ INT64_C(0x0000000020800108), 0x1.0400084p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7ffef7), -0x1.04000848p+29, 0x0p+0 },
{ INT64_C(0x0000000020800140), 0x1.04000ap+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7ffebf), -0x1.04000a08p+29, 0x0p+0 },
{ INT64_C(0x0000000020800180), 0x1.04000cp+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7ffe7f), -0x1.04000c08p+29, 0x0p+0 },
{ INT64_C(0x0000000020800800), 0x1.04004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7ff7ff), -0x1.04004008p+29, 0x0p+0 },
{ INT64_C(0x0000000020800801), 0x1.04004008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7ff7fe), -0x1.0400401p+29, 0x0p+0 },
{ INT64_C(0x0000000020800810), 0x1.0400408p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7ff7ef), -0x1.04004088p+29, 0x0p+0 },
{ INT64_C(0x0000000020800840), 0x1.040042p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7ff7bf), -0x1.04004208p+29, 0x0p+0 },
{ INT64_C(0x0000000020800c00), 0x1.04006p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7ff3ff), -0x1.04006008p+29, 0x0p+0 },
{ INT64_C(0x0000000020801000), 0x1.04008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fefff), -0x1.04008008p+29, 0x0p+0 },
{ INT64_C(0x0000000020801008), 0x1.0400804p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7feff7), -0x1.04008048p+29, 0x0p+0 },
{ INT64_C(0x0000000020801020), 0x1.040081p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fefdf), -0x1.04008108p+29, 0x0p+0 },
{ INT64_C(0x0000000020801080), 0x1.040084p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fef7f), -0x1.04008408p+29, 0x0p+0 },
{ INT64_C(0x0000000020801400), 0x1.0400ap+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7febff), -0x1.0400a008p+29, 0x0p+0 },
{ INT64_C(0x0000000020802000), 0x1.0401p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fdfff), -0x1.04010008p+29, 0x0p+0 },
{ INT64_C(0x0000000020802004), 0x1.0401002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fdffb), -0x1.04010028p+29, 0x0p+0 },
{ INT64_C(0x0000000020802040), 0x1.040102p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fdfbf), -0x1.04010208p+29, 0x0p+0 },
{ INT64_C(0x0000000020802080), 0x1.040104p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fdf7f), -0x1.04010408p+29, 0x0p+0 },
{ INT64_C(0x0000000020802100), 0x1.040108p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fdeff), -0x1.04010808p+29, 0x0p+0 },
{ INT64_C(0x0000000020802200), 0x1.04011p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fddff), -0x1.04011008p+29, 0x0p+0 },
{ INT64_C(0x0000000020802400), 0x1.04012p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7fdbff), -0x1.04012008p+29, 0x0p+0 },
{ INT64_C(0x0000000020808000), 0x1.0404p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7f7fff), -0x1.04040008p+29, 0x0p+0 },
{ INT64_C(0x0000000020808001), 0x1.04040008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7f7ffe), -0x1.0404001p+29, 0x0p+0 },
{ INT64_C(0x0000000020808010), 0x1.0404008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7f7fef), -0x1.04040088p+29, 0x0p+0 },
{ INT64_C(0x0000000020808080), 0x1.040404p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7f7f7f), -0x1.04040408p+29, 0x0p+0 },
{ INT64_C(0x0000000020808100), 0x1.040408p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7f7eff), -0x1.04040808p+29, 0x0p+0 },
{ INT64_C(0x0000000020809000), 0x1.04048p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7f6fff), -0x1.04048008p+29, 0x0p+0 },
{ INT64_C(0x000000002080a000), 0x1.0405p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7f5fff), -0x1.04050008p+29, 0x0p+0 },
{ INT64_C(0x0000000020810000), 0x1.0408p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7effff), -0x1.04080008p+29, 0x0p+0 },
{ INT64_C(0x0000000020810001), 0x1.04080008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7efffe), -0x1.0408001p+29, 0x0p+0 },
{ INT64_C(0x0000000020810002), 0x1.0408001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7efffd), -0x1.04080018p+29, 0x0p+0 },
{ INT64_C(0x0000000020810004), 0x1.0408002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7efffb), -0x1.04080028p+29, 0x0p+0 },
{ INT64_C(0x0000000020810020), 0x1.040801p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7effdf), -0x1.04080108p+29, 0x0p+0 },
{ INT64_C(0x0000000020810040), 0x1.040802p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7effbf), -0x1.04080208p+29, 0x0p+0 },
{ INT64_C(0x0000000020810100), 0x1.040808p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7efeff), -0x1.04080808p+29, 0x0p+0 },
{ INT64_C(0x0000000020810400), 0x1.04082p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7efbff), -0x1.04082008p+29, 0x0p+0 },
{ INT64_C(0x0000000020814000), 0x1.040ap+29, 0x0p+0 },
{ INT64_C(0xffffffffdf7ebfff), -0x1.040a0008p+29, 0x0p+0 },
{ INT64_C(0x0000000020900000), 0x1.048p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf6fffff), -0x1.04800008p+29, 0x0p+0 },
{ INT64_C(0x0000000020900004), 0x1.0480002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf6ffffb), -0x1.04800028p+29, 0x0p+0 },
{ INT64_C(0x0000000020900040), 0x1.048002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf6fffbf), -0x1.04800208p+29, 0x0p+0 },
{ INT64_C(0x0000000020900100), 0x1.048008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf6ffeff), -0x1.04800808p+29, 0x0p+0 },
{ INT64_C(0x0000000020900800), 0x1.04804p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf6ff7ff), -0x1.04804008p+29, 0x0p+0 },
{ INT64_C(0x0000000020901000), 0x1.04808p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf6fefff), -0x1.04808008p+29, 0x0p+0 },
{ INT64_C(0x0000000020908000), 0x1.0484p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf6f7fff), -0x1.04840008p+29, 0x0p+0 },
{ INT64_C(0x0000000020910000), 0x1.0488p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf6effff), -0x1.04880008p+29, 0x0p+0 },
{ INT64_C(0x0000000020940000), 0x1.04ap+29, 0x0p+0 },
{ INT64_C(0xffffffffdf6bffff), -0x1.04a00008p+29, 0x0p+0 },
{ INT64_C(0x0000000020a00000), 0x1.05p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf5fffff), -0x1.05000008p+29, 0x0p+0 },
{ INT64_C(0x0000000020a00008), 0x1.0500004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf5ffff7), -0x1.05000048p+29, 0x0p+0 },
{ INT64_C(0x0000000020a00010), 0x1.0500008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf5fffef), -0x1.05000088p+29, 0x0p+0 },
{ INT64_C(0x0000000020a00040), 0x1.050002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf5fffbf), -0x1.05000208p+29, 0x0p+0 },
{ INT64_C(0x0000000020a00400), 0x1.05002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf5ffbff), -0x1.05002008p+29, 0x0p+0 },
{ INT64_C(0x0000000020a01000), 0x1.05008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf5fefff), -0x1.05008008p+29, 0x0p+0 },
{ INT64_C(0x0000000020a08000), 0x1.0504p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf5f7fff), -0x1.05040008p+29, 0x0p+0 },
{ INT64_C(0x0000000020a10000), 0x1.0508p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf5effff), -0x1.05080008p+29, 0x0p+0 },
{ INT64_C(0x0000000020b00000), 0x1.058p+29, 0x0p+0 },
{ INT64_C(0xffffffffdf4fffff), -0x1.05800008p+29, 0x0p+0 },
{ INT64_C(0x0000000024000008), 0x1.2000004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfffff7), -0x1.20000048p+29, 0x0p+0 },
{ INT64_C(0x0000000024000040), 0x1.200002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffffbf), -0x1.20000208p+29, 0x0p+0 },
{ INT64_C(0x0000000024000042), 0x1.2000021p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffffbd), -0x1.20000218p+29, 0x0p+0 },
{ INT64_C(0x0000000024000050), 0x1.2000028p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffffaf), -0x1.20000288p+29, 0x0p+0 },
{ INT64_C(0x0000000024000200), 0x1.20001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfffdff), -0x1.20001008p+29, 0x0p+0 },
{ INT64_C(0x0000000024000201), 0x1.20001008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfffdfe), -0x1.2000101p+29, 0x0p+0 },
{ INT64_C(0x0000000024000202), 0x1.2000101p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfffdfd), -0x1.20001018p+29, 0x0p+0 },
{ INT64_C(0x0000000024000204), 0x1.2000102p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfffdfb), -0x1.20001028p+29, 0x0p+0 },
{ INT64_C(0x0000000024000210), 0x1.2000108p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfffdef), -0x1.20001088p+29, 0x0p+0 },
{ INT64_C(0x0000000024000300), 0x1.200018p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfffcff), -0x1.20001808p+29, 0x0p+0 },
{ INT64_C(0x0000000024001000), 0x1.20008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffefff), -0x1.20008008p+29, 0x0p+0 },
{ INT64_C(0x0000000024001002), 0x1.2000801p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffeffd), -0x1.20008018p+29, 0x0p+0 },
{ INT64_C(0x0000000024001008), 0x1.2000804p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffeff7), -0x1.20008048p+29, 0x0p+0 },
{ INT64_C(0x0000000024001040), 0x1.200082p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffefbf), -0x1.20008208p+29, 0x0p+0 },
{ INT64_C(0x0000000024001100), 0x1.200088p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffeeff), -0x1.20008808p+29, 0x0p+0 },
{ INT64_C(0x0000000024001800), 0x1.2000cp+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffe7ff), -0x1.2000c008p+29, 0x0p+0 },
{ INT64_C(0x0000000024002000), 0x1.2001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffdfff), -0x1.20010008p+29, 0x0p+0 },
{ INT64_C(0x0000000024002002), 0x1.2001001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffdffd), -0x1.20010018p+29, 0x0p+0 },
{ INT64_C(0x0000000024002004), 0x1.2001002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffdffb), -0x1.20010028p+29, 0x0p+0 },
{ INT64_C(0x0000000024002020), 0x1.200101p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffdfdf), -0x1.20010108p+29, 0x0p+0 },
{ INT64_C(0x0000000024002080), 0x1.200104p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffdf7f), -0x1.20010408p+29, 0x0p+0 },
{ INT64_C(0x0000000024002400), 0x1.20012p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffdbff), -0x1.20012008p+29, 0x0p+0 },
{ INT64_C(0x0000000024002800), 0x1.20014p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbffd7ff), -0x1.20014008p+29, 0x0p+0 },
{ INT64_C(0x0000000024010000), 0x1.2008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfeffff), -0x1.20080008p+29, 0x0p+0 },
{ INT64_C(0x0000000024010008), 0x1.2008004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfefff7), -0x1.20080048p+29, 0x0p+0 },
{ INT64_C(0x0000000024010020), 0x1.200801p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfeffdf), -0x1.20080108p+29, 0x0p+0 },
{ INT64_C(0x0000000024010080), 0x1.200804p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfeff7f), -0x1.20080408p+29, 0x0p+0 },
{ INT64_C(0x0000000024010100), 0x1.200808p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfefeff), -0x1.20080808p+29, 0x0p+0 },
{ INT64_C(0x0000000024010800), 0x1.20084p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfef7ff), -0x1.20084008p+29, 0x0p+0 },
{ INT64_C(0x0000000024011000), 0x1.20088p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfeefff), -0x1.20088008p+29, 0x0p+0 },
{ INT64_C(0x0000000024040000), 0x1.202p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfbffff), -0x1.20200008p+29, 0x0p+0 },
{ INT64_C(0x0000000024040008), 0x1.2020004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfbfff7), -0x1.20200048p+29, 0x0p+0 },
{ INT64_C(0x0000000024040010), 0x1.2020008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfbffef), -0x1.20200088p+29, 0x0p+0 },
{ INT64_C(0x0000000024040040), 0x1.202002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfbffbf), -0x1.20200208p+29, 0x0p+0 },
{ INT64_C(0x0000000024040080), 0x1.202004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfbff7f), -0x1.20200408p+29, 0x0p+0 },
{ INT64_C(0x0000000024040100), 0x1.202008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfbfeff), -0x1.20200808p+29, 0x0p+0 },
{ INT64_C(0x0000000024040800), 0x1.20204p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfbf7ff), -0x1.20204008p+29, 0x0p+0 },
{ INT64_C(0x0000000024041000), 0x1.20208p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfbefff), -0x1.20208008p+29, 0x0p+0 },
{ INT64_C(0x0000000024042000), 0x1.2021p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbfbdfff), -0x1.20210008p+29, 0x0p+0 },
{ INT64_C(0x0000000024060000), 0x1.203p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbf9ffff), -0x1.20300008p+29, 0x0p+0 },
{ INT64_C(0x0000000024400000), 0x1.22p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbbfffff), -0x1.22000008p+29, 0x0p+0 },
{ INT64_C(0x0000000024400001), 0x1.22000008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbbffffe), -0x1.2200001p+29, 0x0p+0 },
{ INT64_C(0x0000000024400010), 0x1.2200008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbbfffef), -0x1.22000088p+29, 0x0p+0 },
{ INT64_C(0x0000000024400100), 0x1.220008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbbffeff), -0x1.22000808p+29, 0x0p+0 },
{ INT64_C(0x0000000024400200), 0x1.22001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbbffdff), -0x1.22001008p+29, 0x0p+0 },
{ INT64_C(0x0000000024400800), 0x1.22004p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbbff7ff), -0x1.22004008p+29, 0x0p+0 },
{ INT64_C(0x0000000024408000), 0x1.2204p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbbf7fff), -0x1.22040008p+29, 0x0p+0 },
{ INT64_C(0x0000000024420000), 0x1.221p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbbdffff), -0x1.22100008p+29, 0x0p+0 },
{ INT64_C(0x0000000024500000), 0x1.228p+29, 0x0p+0 },
{ INT64_C(0xffffffffdbafffff), -0x1.22800008p+29, 0x0p+0 },
{ INT64_C(0x0000000024800000), 0x1.24p+29, 0x0p+0 },
{ INT64_C(0xffffffffdb7fffff), -0x1.24000008p+29, 0x0p+0 },
{ INT64_C(0x0000000024800002), 0x1.2400001p+29, 0x0p+0 },
{ INT64_C(0xffffffffdb7ffffd), -0x1.24000018p+29, 0x0p+0 },
{ INT64_C(0x0000000024800004), 0x1.2400002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdb7ffffb), -0x1.24000028p+29, 0x0p+0 },
{ INT64_C(0x0000000024800010), 0x1.2400008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdb7fffef), -0x1.24000088p+29, 0x0p+0 },
{ INT64_C(0x0000000024800040), 0x1.240002p+29, 0x0p+0 },
{ INT64_C(0xffffffffdb7fffbf), -0x1.24000208p+29, 0x0p+0 },
{ INT64_C(0x0000000024800100), 0x1.240008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdb7ffeff), -0x1.24000808p+29, 0x0p+0 },
{ INT64_C(0x0000000024801000), 0x1.24008p+29, 0x0p+0 },
{ INT64_C(0xffffffffdb7fefff), -0x1.24008008p+29, 0x0p+0 },
{ INT64_C(0x0000000024810000), 0x1.2408p+29, 0x0p+0 },
{ INT64_C(0xffffffffdb7effff), -0x1.24080008p+29, 0x0p+0 },
{ INT64_C(0x0000000024900000), 0x1.248p+29, 0x0p+0 },
{ INT64_C(0xffffffffdb6fffff), -0x1.24800008p+29, 0x0p+0 },
{ INT64_C(0x0000000028000004), 0x1.4000002p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fffffb), -0x1.40000028p+29, 0x0p+0 },
{ INT64_C(0x0000000028000006), 0x1.4000003p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fffff9), -0x1.40000038p+29, 0x0p+0 },
{ INT64_C(0x0000000028000020), 0x1.400001p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffffdf), -0x1.40000108p+29, 0x0p+0 },
{ INT64_C(0x0000000028000021), 0x1.40000108p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffffde), -0x1.4000011p+29, 0x0p+0 },
{ INT64_C(0x0000000028000024), 0x1.4000012p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffffdb), -0x1.40000128p+29, 0x0p+0 },
{ INT64_C(0x0000000028000040), 0x1.400002p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffffbf), -0x1.40000208p+29, 0x0p+0 },
{ INT64_C(0x0000000028000041), 0x1.40000208p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffffbe), -0x1.4000021p+29, 0x0p+0 },
{ INT64_C(0x0000000028000048), 0x1.4000024p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffffb7), -0x1.40000248p+29, 0x0p+0 },
{ INT64_C(0x0000000028000060), 0x1.400003p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffff9f), -0x1.40000308p+29, 0x0p+0 },
{ INT64_C(0x0000000028000080), 0x1.400004p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffff7f), -0x1.40000408p+29, 0x0p+0 },
{ INT64_C(0x0000000028000081), 0x1.40000408p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffff7e), -0x1.4000041p+29, 0x0p+0 },
{ INT64_C(0x0000000028000090), 0x1.4000048p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffff6f), -0x1.40000488p+29, 0x0p+0 },
{ INT64_C(0x0000000028000100), 0x1.400008p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fffeff), -0x1.40000808p+29, 0x0p+0 },
{ INT64_C(0x0000000028000108), 0x1.4000084p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fffef7), -0x1.40000848p+29, 0x0p+0 },
{ INT64_C(0x0000000028000140), 0x1.40000ap+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fffebf), -0x1.40000a08p+29, 0x0p+0 },
{ INT64_C(0x0000000028000200), 0x1.40001p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fffdff), -0x1.40001008p+29, 0x0p+0 },
{ INT64_C(0x0000000028000208), 0x1.4000104p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fffdf7), -0x1.40001048p+29, 0x0p+0 },
{ INT64_C(0x0000000028000210), 0x1.4000108p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fffdef), -0x1.40001088p+29, 0x0p+0 },
{ INT64_C(0x0000000028000220), 0x1.400011p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fffddf), -0x1.40001108p+29, 0x0p+0 },
{ INT64_C(0x0000000028000240), 0x1.400012p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fffdbf), -0x1.40001208p+29, 0x0p+0 },
{ INT64_C(0x0000000028001000), 0x1.40008p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffefff), -0x1.40008008p+29, 0x0p+0 },
{ INT64_C(0x0000000028001001), 0x1.40008008p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffeffe), -0x1.4000801p+29, 0x0p+0 },
{ INT64_C(0x0000000028001004), 0x1.4000802p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffeffb), -0x1.40008028p+29, 0x0p+0 },
{ INT64_C(0x0000000028001008), 0x1.4000804p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffeff7), -0x1.40008048p+29, 0x0p+0 },
{ INT64_C(0x0000000028001010), 0x1.4000808p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffefef), -0x1.40008088p+29, 0x0p+0 },
{ INT64_C(0x0000000028001100), 0x1.400088p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffeeff), -0x1.40008808p+29, 0x0p+0 },
{ INT64_C(0x0000000028001200), 0x1.40009p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7ffedff), -0x1.40009008p+29, 0x0p+0 },
{ INT64_C(0x0000000028010000), 0x1.4008p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7feffff), -0x1.40080008p+29, 0x0p+0 },
{ INT64_C(0x0000000028010001), 0x1.40080008p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fefffe), -0x1.4008001p+29, 0x0p+0 },
{ INT64_C(0x0000000028010004), 0x1.4008002p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fefffb), -0x1.40080028p+29, 0x0p+0 },
{ INT64_C(0x0000000028010010), 0x1.4008008p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7feffef), -0x1.40080088p+29, 0x0p+0 },
{ INT64_C(0x0000000028010040), 0x1.400802p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7feffbf), -0x1.40080208p+29, 0x0p+0 },
{ INT64_C(0x0000000028010200), 0x1.40081p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fefdff), -0x1.40081008p+29, 0x0p+0 },
{ INT64_C(0x0000000028010800), 0x1.40084p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fef7ff), -0x1.40084008p+29, 0x0p+0 },
{ INT64_C(0x0000000028012000), 0x1.4009p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fedfff), -0x1.40090008p+29, 0x0p+0 },
{ INT64_C(0x0000000028040000), 0x1.402p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fbffff), -0x1.40200008p+29, 0x0p+0 },
{ INT64_C(0x0000000028040008), 0x1.4020004p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fbfff7), -0x1.40200048p+29, 0x0p+0 },
{ INT64_C(0x0000000028040040), 0x1.402002p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fbffbf), -0x1.40200208p+29, 0x0p+0 },
{ INT64_C(0x0000000028040080), 0x1.402004p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fbff7f), -0x1.40200408p+29, 0x0p+0 },
{ INT64_C(0x0000000028040100), 0x1.402008p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fbfeff), -0x1.40200808p+29, 0x0p+0 },
{ INT64_C(0x0000000028040800), 0x1.40204p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fbf7ff), -0x1.40204008p+29, 0x0p+0 },
{ INT64_C(0x0000000028044000), 0x1.4022p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7fbbfff), -0x1.40220008p+29, 0x0p+0 },
{ INT64_C(0x0000000028060000), 0x1.403p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7f9ffff), -0x1.40300008p+29, 0x0p+0 },
{ INT64_C(0x0000000028100000), 0x1.408p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7efffff), -0x1.40800008p+29, 0x0p+0 },
{ INT64_C(0x0000000028100004), 0x1.4080002p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7effffb), -0x1.40800028p+29, 0x0p+0 },
{ INT64_C(0x0000000028100010), 0x1.4080008p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7efffef), -0x1.40800088p+29, 0x0p+0 },
{ INT64_C(0x0000000028100040), 0x1.408002p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7efffbf), -0x1.40800208p+29, 0x0p+0 },
{ INT64_C(0x0000000028100080), 0x1.408004p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7efff7f), -0x1.40800408p+29, 0x0p+0 },
{ INT64_C(0x0000000028100100), 0x1.408008p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7effeff), -0x1.40800808p+29, 0x0p+0 },
{ INT64_C(0x0000000028101000), 0x1.40808p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7efefff), -0x1.40808008p+29, 0x0p+0 },
{ INT64_C(0x0000000028110000), 0x1.4088p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7eeffff), -0x1.40880008p+29, 0x0p+0 },
{ INT64_C(0x0000000028180000), 0x1.40cp+29, 0x0p+0 },
{ INT64_C(0xffffffffd7e7ffff), -0x1.40c00008p+29, 0x0p+0 },
{ INT64_C(0x0000000028400000), 0x1.42p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7bfffff), -0x1.42000008p+29, 0x0p+0 },
{ INT64_C(0x0000000028400001), 0x1.42000008p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7bffffe), -0x1.4200001p+29, 0x0p+0 },
{ INT64_C(0x0000000028400002), 0x1.4200001p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7bffffd), -0x1.42000018p+29, 0x0p+0 },
{ INT64_C(0x0000000028400008), 0x1.4200004p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7bffff7), -0x1.42000048p+29, 0x0p+0 },
{ INT64_C(0x0000000028400040), 0x1.420002p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7bfffbf), -0x1.42000208p+29, 0x0p+0 },
{ INT64_C(0x0000000028400400), 0x1.42002p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7bffbff), -0x1.42002008p+29, 0x0p+0 },
{ INT64_C(0x0000000028404000), 0x1.4202p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7bfbfff), -0x1.42020008p+29, 0x0p+0 },
{ INT64_C(0x0000000028410000), 0x1.4208p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7beffff), -0x1.42080008p+29, 0x0p+0 },
{ INT64_C(0x0000000028440000), 0x1.422p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7bbffff), -0x1.42200008p+29, 0x0p+0 },
{ INT64_C(0x0000000028480000), 0x1.424p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7b7ffff), -0x1.42400008p+29, 0x0p+0 },
{ INT64_C(0x0000000028500000), 0x1.428p+29, 0x0p+0 },
{ INT64_C(0xffffffffd7afffff), -0x1.42800008p+29, 0x0p+0 },
{ INT64_C(0x0000000028800000), 0x1.44p+29, 0x0p+0 },
{ INT64_C(0xffffffffd77fffff), -0x1.44000008p+29, 0x0p+0 },
{ INT64_C(0x0000000028800008), 0x1.4400004p+29, 0x0p+0 },
{ INT64_C(0xffffffffd77ffff7), -0x1.44000048p+29, 0x0p+0 },
{ INT64_C(0x0000000028800040), 0x1.440002p+29, 0x0p+0 },
{ INT64_C(0xffffffffd77fffbf), -0x1.44000208p+29, 0x0p+0 },
{ INT64_C(0x0000000028800400), 0x1.44002p+29, 0x0p+0 },
{ INT64_C(0xffffffffd77ffbff), -0x1.44002008p+29, 0x0p+0 },
{ INT64_C(0x0000000028804000), 0x1.4402p+29, 0x0p+0 },
{ INT64_C(0xffffffffd77fbfff), -0x1.44020008p+29, 0x0p+0 },
{ INT64_C(0x0000000028808000), 0x1.4404p+29, 0x0p+0 },
{ INT64_C(0xffffffffd77f7fff), -0x1.44040008p+29, 0x0p+0 },
{ INT64_C(0x0000000028880000), 0x1.444p+29, 0x0p+0 },
{ INT64_C(0xffffffffd777ffff), -0x1.44400008p+29, 0x0p+0 },
{ INT64_C(0x0000000028c00000), 0x1.46p+29, 0x0p+0 },
{ INT64_C(0xffffffffd73fffff), -0x1.46000008p+29, 0x0p+0 },
{ INT64_C(0x0000000080000006), 0x1.0000000cp+31, 0x0p+0 },
{ INT64_C(0xffffffff7ffffff9), -0x1.0000000ep+31, 0x0p+0 },
{ INT64_C(0x0000000080000048), 0x1.0000009p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffffb7), -0x1.00000092p+31, 0x0p+0 },
{ INT64_C(0x0000000080000049), 0x1.00000092p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffffb6), -0x1.00000094p+31, 0x0p+0 },
{ INT64_C(0x000000008000004a), 0x1.00000094p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffffb5), -0x1.00000096p+31, 0x0p+0 },
{ INT64_C(0x0000000080000088), 0x1.0000011p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffff77), -0x1.00000112p+31, 0x0p+0 },
{ INT64_C(0x000000008000008a), 0x1.00000114p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffff75), -0x1.00000116p+31, 0x0p+0 },
{ INT64_C(0x000000008000008c), 0x1.00000118p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffff73), -0x1.0000011ap+31, 0x0p+0 },
{ INT64_C(0x0000000080000090), 0x1.0000012p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffff6f), -0x1.00000122p+31, 0x0p+0 },
{ INT64_C(0x0000000080000092), 0x1.00000124p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffff6d), -0x1.00000126p+31, 0x0p+0 },
{ INT64_C(0x0000000080000401), 0x1.00000802p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ffffbfe), -0x1.00000804p+31, 0x0p+0 },
{ INT64_C(0x0000000080000408), 0x1.0000081p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ffffbf7), -0x1.00000812p+31, 0x0p+0 },
{ INT64_C(0x000000008000040a), 0x1.00000814p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ffffbf5), -0x1.00000816p+31, 0x0p+0 },
{ INT64_C(0x000000008000040c), 0x1.00000818p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ffffbf3), -0x1.0000081ap+31, 0x0p+0 },
{ INT64_C(0x0000000080000480), 0x1.000009p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ffffb7f), -0x1.00000902p+31, 0x0p+0 },
{ INT64_C(0x0000000080000488), 0x1.0000091p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ffffb77), -0x1.00000912p+31, 0x0p+0 },
{ INT64_C(0x00000000800004a0), 0x1.0000094p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ffffb5f), -0x1.00000942p+31, 0x0p+0 },
{ INT64_C(0x00000000800004c0), 0x1.0000098p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ffffb3f), -0x1.00000982p+31, 0x0p+0 },
{ INT64_C(0x0000000080001008), 0x1.0000201p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffeff7), -0x1.00002012p+31, 0x0p+0 },
{ INT64_C(0x000000008000100c), 0x1.00002018p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffeff3), -0x1.0000201ap+31, 0x0p+0 },
{ INT64_C(0x0000000080001020), 0x1.0000204p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffefdf), -0x1.00002042p+31, 0x0p+0 },
{ INT64_C(0x0000000080001024), 0x1.00002048p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffefdb), -0x1.0000204ap+31, 0x0p+0 },
{ INT64_C(0x0000000080001028), 0x1.0000205p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffefd7), -0x1.00002052p+31, 0x0p+0 },
{ INT64_C(0x0000000080001200), 0x1.000024p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffedff), -0x1.00002402p+31, 0x0p+0 },
{ INT64_C(0x0000000080001208), 0x1.0000241p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffedf7), -0x1.00002412p+31, 0x0p+0 },
{ INT64_C(0x0000000080001220), 0x1.0000244p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffeddf), -0x1.00002442p+31, 0x0p+0 },
{ INT64_C(0x0000000080001240), 0x1.0000248p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffedbf), -0x1.00002482p+31, 0x0p+0 },
{ INT64_C(0x0000000080001280), 0x1.000025p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffed7f), -0x1.00002502p+31, 0x0p+0 },
{ INT64_C(0x0000000080001300), 0x1.000026p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffecff), -0x1.00002602p+31, 0x0p+0 },
{ INT64_C(0x0000000080001400), 0x1.000028p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffebff), -0x1.00002802p+31, 0x0p+0 },
{ INT64_C(0x0000000080001402), 0x1.00002804p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffebfd), -0x1.00002806p+31, 0x0p+0 },
{ INT64_C(0x0000000080001404), 0x1.00002808p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffebfb), -0x1.0000280ap+31, 0x0p+0 },
{ INT64_C(0x0000000080001420), 0x1.0000284p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffebdf), -0x1.00002842p+31, 0x0p+0 },
{ INT64_C(0x0000000080001600), 0x1.00002cp+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffe9ff), -0x1.00002c02p+31, 0x0p+0 },
{ INT64_C(0x0000000080002001), 0x1.00004002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffdffe), -0x1.00004004p+31, 0x0p+0 },
{ INT64_C(0x0000000080002010), 0x1.0000402p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffdfef), -0x1.00004022p+31, 0x0p+0 },
{ INT64_C(0x0000000080002014), 0x1.00004028p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffdfeb), -0x1.0000402ap+31, 0x0p+0 },
{ INT64_C(0x0000000080002080), 0x1.000041p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffdf7f), -0x1.00004102p+31, 0x0p+0 },
{ INT64_C(0x0000000080002082), 0x1.00004104p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffdf7d), -0x1.00004106p+31, 0x0p+0 },
{ INT64_C(0x0000000080002090), 0x1.0000412p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffdf6f), -0x1.00004122p+31, 0x0p+0 },
{ INT64_C(0x00000000800020a0), 0x1.0000414p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffdf5f), -0x1.00004142p+31, 0x0p+0 },
{ INT64_C(0x0000000080002800), 0x1.00005p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffd7ff), -0x1.00005002p+31, 0x0p+0 },
{ INT64_C(0x0000000080002804), 0x1.00005008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffd7fb), -0x1.0000500ap+31, 0x0p+0 },
{ INT64_C(0x0000000080002808), 0x1.0000501p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffd7f7), -0x1.00005012p+31, 0x0p+0 },
{ INT64_C(0x0000000080002810), 0x1.0000502p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffd7ef), -0x1.00005022p+31, 0x0p+0 },
{ INT64_C(0x0000000080002900), 0x1.000052p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fffd6ff), -0x1.00005202p+31, 0x0p+0 },
{ INT64_C(0x0000000080008001), 0x1.00010002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7ffe), -0x1.00010004p+31, 0x0p+0 },
{ INT64_C(0x0000000080008008), 0x1.0001001p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7ff7), -0x1.00010012p+31, 0x0p+0 },
{ INT64_C(0x000000008000800a), 0x1.00010014p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7ff5), -0x1.00010016p+31, 0x0p+0 },
{ INT64_C(0x0000000080008080), 0x1.000101p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7f7f), -0x1.00010102p+31, 0x0p+0 },
{ INT64_C(0x0000000080008088), 0x1.0001011p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7f77), -0x1.00010112p+31, 0x0p+0 },
{ INT64_C(0x0000000080008090), 0x1.0001012p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7f6f), -0x1.00010122p+31, 0x0p+0 },
{ INT64_C(0x0000000080008100), 0x1.000102p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7eff), -0x1.00010202p+31, 0x0p+0 },
{ INT64_C(0x0000000080008108), 0x1.0001021p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7ef7), -0x1.00010212p+31, 0x0p+0 },
{ INT64_C(0x0000000080008180), 0x1.000103p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7e7f), -0x1.00010302p+31, 0x0p+0 },
{ INT64_C(0x0000000080008200), 0x1.000104p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7dff), -0x1.00010402p+31, 0x0p+0 },
{ INT64_C(0x0000000080008201), 0x1.00010402p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7dfe), -0x1.00010404p+31, 0x0p+0 },
{ INT64_C(0x0000000080008208), 0x1.0001041p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7df7), -0x1.00010412p+31, 0x0p+0 },
{ INT64_C(0x0000000080008240), 0x1.0001048p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff7dbf), -0x1.00010482p+31, 0x0p+0 },
{ INT64_C(0x0000000080009000), 0x1.00012p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff6fff), -0x1.00012002p+31, 0x0p+0 },
{ INT64_C(0x0000000080009002), 0x1.00012004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff6ffd), -0x1.00012006p+31, 0x0p+0 },
{ INT64_C(0x0000000080009008), 0x1.0001201p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff6ff7), -0x1.00012012p+31, 0x0p+0 },
{ INT64_C(0x0000000080009080), 0x1.000121p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff6f7f), -0x1.00012102p+31, 0x0p+0 },
{ INT64_C(0x0000000080009800), 0x1.00013p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fff67ff), -0x1.00013002p+31, 0x0p+0 },
{ INT64_C(0x0000000080080002), 0x1.00100004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7fffd), -0x1.00100006p+31, 0x0p+0 },
{ INT64_C(0x0000000080080010), 0x1.0010002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ffef), -0x1.00100022p+31, 0x0p+0 },
{ INT64_C(0x0000000080080018), 0x1.0010003p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ffe7), -0x1.00100032p+31, 0x0p+0 },
{ INT64_C(0x0000000080080020), 0x1.0010004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ffdf), -0x1.00100042p+31, 0x0p+0 },
{ INT64_C(0x0000000080080028), 0x1.0010005p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ffd7), -0x1.00100052p+31, 0x0p+0 },
{ INT64_C(0x0000000080080030), 0x1.0010006p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ffcf), -0x1.00100062p+31, 0x0p+0 },
{ INT64_C(0x0000000080080040), 0x1.0010008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ffbf), -0x1.00100082p+31, 0x0p+0 },
{ INT64_C(0x0000000080080042), 0x1.00100084p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ffbd), -0x1.00100086p+31, 0x0p+0 },
{ INT64_C(0x0000000080080050), 0x1.001000ap+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ffaf), -0x1.001000a2p+31, 0x0p+0 },
{ INT64_C(0x0000000080080080), 0x1.001001p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ff7f), -0x1.00100102p+31, 0x0p+0 },
{ INT64_C(0x0000000080080088), 0x1.0010011p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ff77), -0x1.00100112p+31, 0x0p+0 },
{ INT64_C(0x00000000800800c0), 0x1.0010018p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ff3f), -0x1.00100182p+31, 0x0p+0 },
{ INT64_C(0x0000000080080800), 0x1.00101p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7f7ff), -0x1.00101002p+31, 0x0p+0 },
{ INT64_C(0x0000000080080802), 0x1.00101004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7f7fd), -0x1.00101006p+31, 0x0p+0 },
{ INT64_C(0x0000000080080810), 0x1.0010102p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7f7ef), -0x1.00101022p+31, 0x0p+0 },
{ INT64_C(0x0000000080080880), 0x1.001011p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7f77f), -0x1.00101102p+31, 0x0p+0 },
{ INT64_C(0x0000000080080a00), 0x1.001014p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7f5ff), -0x1.00101402p+31, 0x0p+0 },
{ INT64_C(0x0000000080081000), 0x1.00102p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7efff), -0x1.00102002p+31, 0x0p+0 },
{ INT64_C(0x0000000080081002), 0x1.00102004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7effd), -0x1.00102006p+31, 0x0p+0 },
{ INT64_C(0x0000000080081008), 0x1.0010201p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7eff7), -0x1.00102012p+31, 0x0p+0 },
{ INT64_C(0x0000000080081080), 0x1.001021p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ef7f), -0x1.00102102p+31, 0x0p+0 },
{ INT64_C(0x0000000080081400), 0x1.001028p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ebff), -0x1.00102802p+31, 0x0p+0 },
{ INT64_C(0x0000000080081800), 0x1.00103p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7e7ff), -0x1.00103002p+31, 0x0p+0 },
{ INT64_C(0x0000000080082000), 0x1.00104p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7dfff), -0x1.00104002p+31, 0x0p+0 },
{ INT64_C(0x0000000080082008), 0x1.0010401p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7dff7), -0x1.00104012p+31, 0x0p+0 },
{ INT64_C(0x0000000080082040), 0x1.0010408p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7dfbf), -0x1.00104082p+31, 0x0p+0 },
{ INT64_C(0x0000000080082100), 0x1.001042p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7deff), -0x1.00104202p+31, 0x0p+0 },
{ INT64_C(0x0000000080082200), 0x1.001044p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7ddff), -0x1.00104402p+31, 0x0p+0 },
{ INT64_C(0x0000000080082800), 0x1.00105p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7d7ff), -0x1.00105002p+31, 0x0p+0 },
{ INT64_C(0x0000000080084000), 0x1.00108p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7bfff), -0x1.00108002p+31, 0x0p+0 },
{ INT64_C(0x0000000080084001), 0x1.00108002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7bffe), -0x1.00108004p+31, 0x0p+0 },
{ INT64_C(0x0000000080084002), 0x1.00108004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7bffd), -0x1.00108006p+31, 0x0p+0 },
{ INT64_C(0x0000000080084010), 0x1.0010802p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7bfef), -0x1.00108022p+31, 0x0p+0 },
{ INT64_C(0x0000000080084020), 0x1.0010804p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7bfdf), -0x1.00108042p+31, 0x0p+0 },
{ INT64_C(0x0000000080084200), 0x1.001084p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff7bdff), -0x1.00108402p+31, 0x0p+0 },
{ INT64_C(0x0000000080086000), 0x1.0010cp+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff79fff), -0x1.0010c002p+31, 0x0p+0 },
{ INT64_C(0x0000000080088000), 0x1.0011p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff77fff), -0x1.00110002p+31, 0x0p+0 },
{ INT64_C(0x0000000080088008), 0x1.0011001p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff77ff7), -0x1.00110012p+31, 0x0p+0 },
{ INT64_C(0x0000000080088020), 0x1.0011004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff77fdf), -0x1.00110042p+31, 0x0p+0 },
{ INT64_C(0x0000000080088040), 0x1.0011008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff77fbf), -0x1.00110082p+31, 0x0p+0 },
{ INT64_C(0x0000000080088200), 0x1.001104p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff77dff), -0x1.00110402p+31, 0x0p+0 },
{ INT64_C(0x0000000080088800), 0x1.00111p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff777ff), -0x1.00111002p+31, 0x0p+0 },
{ INT64_C(0x000000008008c000), 0x1.00118p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff73fff), -0x1.00118002p+31, 0x0p+0 },
{ INT64_C(0x00000000800a0000), 0x1.0014p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff5ffff), -0x1.00140002p+31, 0x0p+0 },
{ INT64_C(0x00000000800a0004), 0x1.00140008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff5fffb), -0x1.0014000ap+31, 0x0p+0 },
{ INT64_C(0x00000000800a0040), 0x1.0014008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff5ffbf), -0x1.00140082p+31, 0x0p+0 },
{ INT64_C(0x00000000800a0100), 0x1.001402p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff5feff), -0x1.00140202p+31, 0x0p+0 },
{ INT64_C(0x00000000800a1000), 0x1.00142p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff5efff), -0x1.00142002p+31, 0x0p+0 },
{ INT64_C(0x00000000800b0000), 0x1.0016p+31, 0x0p+0 },
{ INT64_C(0xffffffff7ff4ffff), -0x1.00160002p+31, 0x0p+0 },
{ INT64_C(0x0000000080400004), 0x1.00800008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbffffb), -0x1.0080000ap+31, 0x0p+0 },
{ INT64_C(0x0000000080400040), 0x1.0080008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfffbf), -0x1.00800082p+31, 0x0p+0 },
{ INT64_C(0x0000000080400044), 0x1.00800088p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfffbb), -0x1.0080008ap+31, 0x0p+0 },
{ INT64_C(0x0000000080400100), 0x1.008002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbffeff), -0x1.00800202p+31, 0x0p+0 },
{ INT64_C(0x0000000080400104), 0x1.00800208p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbffefb), -0x1.0080020ap+31, 0x0p+0 },
{ INT64_C(0x0000000080400108), 0x1.0080021p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbffef7), -0x1.00800212p+31, 0x0p+0 },
{ INT64_C(0x0000000080400180), 0x1.008003p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbffe7f), -0x1.00800302p+31, 0x0p+0 },
{ INT64_C(0x0000000080400800), 0x1.00801p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbff7ff), -0x1.00801002p+31, 0x0p+0 },
{ INT64_C(0x0000000080400808), 0x1.0080101p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbff7f7), -0x1.00801012p+31, 0x0p+0 },
{ INT64_C(0x0000000080400810), 0x1.0080102p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbff7ef), -0x1.00801022p+31, 0x0p+0 },
{ INT64_C(0x0000000080400820), 0x1.0080104p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbff7df), -0x1.00801042p+31, 0x0p+0 },
{ INT64_C(0x0000000080400840), 0x1.0080108p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbff7bf), -0x1.00801082p+31, 0x0p+0 },
{ INT64_C(0x0000000080400880), 0x1.008011p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbff77f), -0x1.00801102p+31, 0x0p+0 },
{ INT64_C(0x0000000080401000), 0x1.00802p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfefff), -0x1.00802002p+31, 0x0p+0 },
{ INT64_C(0x0000000080401008), 0x1.0080201p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfeff7), -0x1.00802012p+31, 0x0p+0 },
{ INT64_C(0x0000000080401020), 0x1.0080204p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfefdf), -0x1.00802042p+31, 0x0p+0 },
{ INT64_C(0x0000000080401040), 0x1.0080208p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfefbf), -0x1.00802082p+31, 0x0p+0 },
{ INT64_C(0x0000000080401200), 0x1.008024p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfedff), -0x1.00802402p+31, 0x0p+0 },
{ INT64_C(0x0000000080401400), 0x1.008028p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfebff), -0x1.00802802p+31, 0x0p+0 },
{ INT64_C(0x0000000080404000), 0x1.00808p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfbfff), -0x1.00808002p+31, 0x0p+0 },
{ INT64_C(0x0000000080404002), 0x1.00808004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfbffd), -0x1.00808006p+31, 0x0p+0 },
{ INT64_C(0x0000000080404010), 0x1.0080802p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfbfef), -0x1.00808022p+31, 0x0p+0 },
{ INT64_C(0x0000000080404100), 0x1.008082p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfbeff), -0x1.00808202p+31, 0x0p+0 },
{ INT64_C(0x0000000080404800), 0x1.00809p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbfb7ff), -0x1.00809002p+31, 0x0p+0 },
{ INT64_C(0x0000000080406000), 0x1.0080cp+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbf9fff), -0x1.0080c002p+31, 0x0p+0 },
{ INT64_C(0x0000000080408000), 0x1.0081p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbf7fff), -0x1.00810002p+31, 0x0p+0 },
{ INT64_C(0x0000000080408004), 0x1.00810008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbf7ffb), -0x1.0081000ap+31, 0x0p+0 },
{ INT64_C(0x0000000080408020), 0x1.0081004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbf7fdf), -0x1.00810042p+31, 0x0p+0 },
{ INT64_C(0x0000000080408080), 0x1.008101p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbf7f7f), -0x1.00810102p+31, 0x0p+0 },
{ INT64_C(0x0000000080408200), 0x1.008104p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbf7dff), -0x1.00810402p+31, 0x0p+0 },
{ INT64_C(0x000000008040a000), 0x1.00814p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbf5fff), -0x1.00814002p+31, 0x0p+0 },
{ INT64_C(0x000000008040c000), 0x1.00818p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbf3fff), -0x1.00818002p+31, 0x0p+0 },
{ INT64_C(0x0000000080440000), 0x1.0088p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbbffff), -0x1.00880002p+31, 0x0p+0 },
{ INT64_C(0x0000000080440002), 0x1.00880004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbbfffd), -0x1.00880006p+31, 0x0p+0 },
{ INT64_C(0x0000000080440020), 0x1.0088004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbbffdf), -0x1.00880042p+31, 0x0p+0 },
{ INT64_C(0x0000000080440080), 0x1.008801p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbbff7f), -0x1.00880102p+31, 0x0p+0 },
{ INT64_C(0x0000000080440100), 0x1.008802p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbbfeff), -0x1.00880202p+31, 0x0p+0 },
{ INT64_C(0x0000000080440400), 0x1.008808p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbbfbff), -0x1.00880802p+31, 0x0p+0 },
{ INT64_C(0x0000000080440800), 0x1.00881p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbbf7ff), -0x1.00881002p+31, 0x0p+0 },
{ INT64_C(0x0000000080448000), 0x1.0089p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fbb7fff), -0x1.00890002p+31, 0x0p+0 },
{ INT64_C(0x0000000080480000), 0x1.009p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fb7ffff), -0x1.00900002p+31, 0x0p+0 },
{ INT64_C(0x0000000080480002), 0x1.00900004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fb7fffd), -0x1.00900006p+31, 0x0p+0 },
{ INT64_C(0x0000000080480020), 0x1.0090004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fb7ffdf), -0x1.00900042p+31, 0x0p+0 },
{ INT64_C(0x0000000080480040), 0x1.0090008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fb7ffbf), -0x1.00900082p+31, 0x0p+0 },
{ INT64_C(0x0000000080480400), 0x1.009008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fb7fbff), -0x1.00900802p+31, 0x0p+0 },
{ INT64_C(0x0000000080484000), 0x1.00908p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fb7bfff), -0x1.00908002p+31, 0x0p+0 },
{ INT64_C(0x0000000080490000), 0x1.0092p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fb6ffff), -0x1.00920002p+31, 0x0p+0 },
{ INT64_C(0x00000000804a0000), 0x1.0094p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fb5ffff), -0x1.00940002p+31, 0x0p+0 },
{ INT64_C(0x0000000080500000), 0x1.00ap+31, 0x0p+0 },
{ INT64_C(0xffffffff7fafffff), -0x1.00a00002p+31, 0x0p+0 },
{ INT64_C(0x0000000080500008), 0x1.00a0001p+31, 0x0p+0 },
{ INT64_C(0xffffffff7faffff7), -0x1.00a00012p+31, 0x0p+0 },
{ INT64_C(0x0000000080500080), 0x1.00a001p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fafff7f), -0x1.00a00102p+31, 0x0p+0 },
{ INT64_C(0x0000000080500400), 0x1.00a008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7faffbff), -0x1.00a00802p+31, 0x0p+0 },
{ INT64_C(0x0000000080502000), 0x1.00a04p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fafdfff), -0x1.00a04002p+31, 0x0p+0 },
{ INT64_C(0x0000000080520000), 0x1.00a4p+31, 0x0p+0 },
{ INT64_C(0xffffffff7fadffff), -0x1.00a40002p+31, 0x0p+0 },
{ INT64_C(0x0000000080580000), 0x1.00bp+31, 0x0p+0 },
{ INT64_C(0xffffffff7fa7ffff), -0x1.00b00002p+31, 0x0p+0 },
{ INT64_C(0x0000000084000004), 0x1.08000008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfffffb), -0x1.0800000ap+31, 0x0p+0 },
{ INT64_C(0x0000000084000006), 0x1.0800000cp+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfffff9), -0x1.0800000ep+31, 0x0p+0 },
{ INT64_C(0x0000000084000040), 0x1.0800008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bffffbf), -0x1.08000082p+31, 0x0p+0 },
{ INT64_C(0x0000000084000044), 0x1.08000088p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bffffbb), -0x1.0800008ap+31, 0x0p+0 },
{ INT64_C(0x0000000084000060), 0x1.080000cp+31, 0x0p+0 },
{ INT64_C(0xffffffff7bffff9f), -0x1.080000c2p+31, 0x0p+0 },
{ INT64_C(0x0000000084000200), 0x1.080004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfffdff), -0x1.08000402p+31, 0x0p+0 },
{ INT64_C(0x0000000084000201), 0x1.08000402p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfffdfe), -0x1.08000404p+31, 0x0p+0 },
{ INT64_C(0x0000000084000204), 0x1.08000408p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfffdfb), -0x1.0800040ap+31, 0x0p+0 },
{ INT64_C(0x0000000084000208), 0x1.0800041p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfffdf7), -0x1.08000412p+31, 0x0p+0 },
{ INT64_C(0x0000000084000240), 0x1.0800048p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfffdbf), -0x1.08000482p+31, 0x0p+0 },
{ INT64_C(0x0000000084000800), 0x1.08001p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfff7ff), -0x1.08001002p+31, 0x0p+0 },
{ INT64_C(0x0000000084000801), 0x1.08001002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfff7fe), -0x1.08001004p+31, 0x0p+0 },
{ INT64_C(0x0000000084000810), 0x1.0800102p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfff7ef), -0x1.08001022p+31, 0x0p+0 },
{ INT64_C(0x0000000084000880), 0x1.080011p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfff77f), -0x1.08001102p+31, 0x0p+0 },
{ INT64_C(0x0000000084001000), 0x1.08002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bffefff), -0x1.08002002p+31, 0x0p+0 },
{ INT64_C(0x0000000084001004), 0x1.08002008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bffeffb), -0x1.0800200ap+31, 0x0p+0 },
{ INT64_C(0x0000000084001008), 0x1.0800201p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bffeff7), -0x1.08002012p+31, 0x0p+0 },
{ INT64_C(0x0000000084001010), 0x1.0800202p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bffefef), -0x1.08002022p+31, 0x0p+0 },
{ INT64_C(0x0000000084001100), 0x1.080022p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bffeeff), -0x1.08002202p+31, 0x0p+0 },
{ INT64_C(0x0000000084001800), 0x1.08003p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bffe7ff), -0x1.08003002p+31, 0x0p+0 },
{ INT64_C(0x0000000084008000), 0x1.0801p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bff7fff), -0x1.08010002p+31, 0x0p+0 },
{ INT64_C(0x0000000084008001), 0x1.08010002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bff7ffe), -0x1.08010004p+31, 0x0p+0 },
{ INT64_C(0x0000000084008002), 0x1.08010004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bff7ffd), -0x1.08010006p+31, 0x0p+0 },
{ INT64_C(0x0000000084008008), 0x1.0801001p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bff7ff7), -0x1.08010012p+31, 0x0p+0 },
{ INT64_C(0x0000000084008020), 0x1.0801004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bff7fdf), -0x1.08010042p+31, 0x0p+0 },
{ INT64_C(0x0000000084008080), 0x1.080101p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bff7f7f), -0x1.08010102p+31, 0x0p+0 },
{ INT64_C(0x0000000084008800), 0x1.08011p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bff77ff), -0x1.08011002p+31, 0x0p+0 },
{ INT64_C(0x000000008400a000), 0x1.08014p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bff5fff), -0x1.08014002p+31, 0x0p+0 },
{ INT64_C(0x0000000084010000), 0x1.0802p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfeffff), -0x1.08020002p+31, 0x0p+0 },
{ INT64_C(0x0000000084010002), 0x1.08020004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfefffd), -0x1.08020006p+31, 0x0p+0 },
{ INT64_C(0x0000000084010020), 0x1.0802004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfeffdf), -0x1.08020042p+31, 0x0p+0 },
{ INT64_C(0x0000000084010200), 0x1.080204p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfefdff), -0x1.08020402p+31, 0x0p+0 },
{ INT64_C(0x0000000084012000), 0x1.08024p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bfedfff), -0x1.08024002p+31, 0x0p+0 },
{ INT64_C(0x0000000084100000), 0x1.082p+31, 0x0p+0 },
{ INT64_C(0xffffffff7befffff), -0x1.08200002p+31, 0x0p+0 },
{ INT64_C(0x0000000084100001), 0x1.08200002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7beffffe), -0x1.08200004p+31, 0x0p+0 },
{ INT64_C(0x0000000084100010), 0x1.0820002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7befffef), -0x1.08200022p+31, 0x0p+0 },
{ INT64_C(0x0000000084100040), 0x1.0820008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7befffbf), -0x1.08200082p+31, 0x0p+0 },
{ INT64_C(0x0000000084100200), 0x1.082004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7beffdff), -0x1.08200402p+31, 0x0p+0 },
{ INT64_C(0x0000000084101000), 0x1.08202p+31, 0x0p+0 },
{ INT64_C(0xffffffff7befefff), -0x1.08202002p+31, 0x0p+0 },
{ INT64_C(0x0000000084102000), 0x1.08204p+31, 0x0p+0 },
{ INT64_C(0xffffffff7befdfff), -0x1.08204002p+31, 0x0p+0 },
{ INT64_C(0x0000000084108000), 0x1.0821p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bef7fff), -0x1.08210002p+31, 0x0p+0 },
{ INT64_C(0x0000000084120000), 0x1.0824p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bedffff), -0x1.08240002p+31, 0x0p+0 },
{ INT64_C(0x0000000084400000), 0x1.088p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bbfffff), -0x1.08800002p+31, 0x0p+0 },
{ INT64_C(0x0000000084400001), 0x1.08800002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bbffffe), -0x1.08800004p+31, 0x0p+0 },
{ INT64_C(0x0000000084400008), 0x1.0880001p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bbffff7), -0x1.08800012p+31, 0x0p+0 },
{ INT64_C(0x0000000084400020), 0x1.0880004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bbfffdf), -0x1.08800042p+31, 0x0p+0 },
{ INT64_C(0x0000000084400100), 0x1.088002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bbffeff), -0x1.08800202p+31, 0x0p+0 },
{ INT64_C(0x0000000084400400), 0x1.088008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bbffbff), -0x1.08800802p+31, 0x0p+0 },
{ INT64_C(0x0000000084400800), 0x1.08801p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bbff7ff), -0x1.08801002p+31, 0x0p+0 },
{ INT64_C(0x0000000084401000), 0x1.08802p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bbfefff), -0x1.08802002p+31, 0x0p+0 },
{ INT64_C(0x0000000084408000), 0x1.0881p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bbf7fff), -0x1.08810002p+31, 0x0p+0 },
{ INT64_C(0x0000000084420000), 0x1.0884p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bbdffff), -0x1.08840002p+31, 0x0p+0 },
{ INT64_C(0x0000000084480000), 0x1.089p+31, 0x0p+0 },
{ INT64_C(0xffffffff7bb7ffff), -0x1.08900002p+31, 0x0p+0 },
{ INT64_C(0x0000000084600000), 0x1.08cp+31, 0x0p+0 },
{ INT64_C(0xffffffff7b9fffff), -0x1.08c00002p+31, 0x0p+0 },
{ INT64_C(0x0000000085000000), 0x1.0ap+31, 0x0p+0 },
{ INT64_C(0xffffffff7affffff), -0x1.0a000002p+31, 0x0p+0 },
{ INT64_C(0x0000000085000001), 0x1.0a000002p+31, 0x0p+0 },
{ INT64_C(0xffffffff7afffffe), -0x1.0a000004p+31, 0x0p+0 },
{ INT64_C(0x0000000085000002), 0x1.0a000004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7afffffd), -0x1.0a000006p+31, 0x0p+0 },
{ INT64_C(0x0000000085000020), 0x1.0a00004p+31, 0x0p+0 },
{ INT64_C(0xffffffff7affffdf), -0x1.0a000042p+31, 0x0p+0 },
{ INT64_C(0x0000000085000080), 0x1.0a0001p+31, 0x0p+0 },
{ INT64_C(0xffffffff7affff7f), -0x1.0a000102p+31, 0x0p+0 },
{ INT64_C(0x0000000085000400), 0x1.0a0008p+31, 0x0p+0 },
{ INT64_C(0xffffffff7afffbff), -0x1.0a000802p+31, 0x0p+0 },
{ INT64_C(0x0000000085000800), 0x1.0a001p+31, 0x0p+0 },
{ INT64_C(0xffffffff7afff7ff), -0x1.0a001002p+31, 0x0p+0 },
{ INT64_C(0x0000000085008000), 0x1.0a01p+31, 0x0p+0 },
{ INT64_C(0xffffffff7aff7fff), -0x1.0a010002p+31, 0x0p+0 },
{ INT64_C(0x0000000085080000), 0x1.0a1p+31, 0x0p+0 },
{ INT64_C(0xffffffff7af7ffff), -0x1.0a100002p+31, 0x0p+0 },
{ INT64_C(0x0000000085100000), 0x1.0a2p+31, 0x0p+0 },
{ INT64_C(0xffffffff7aefffff), -0x1.0a200002p+31, 0x0p+0 },
{ INT64_C(0x0000000090000002), 0x1.20000004p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ffffffd), -0x1.20000006p+31, 0x0p+0 },
{ INT64_C(0x0000000090000020), 0x1.2000004p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fffffdf), -0x1.20000042p+31, 0x0p+0 },
{ INT64_C(0x0000000090000024), 0x1.20000048p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fffffdb), -0x1.2000004ap+31, 0x0p+0 },
{ INT64_C(0x0000000090000028), 0x1.2000005p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fffffd7), -0x1.20000052p+31, 0x0p+0 },
{ INT64_C(0x0000000090000200), 0x1.200004p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ffffdff), -0x1.20000402p+31, 0x0p+0 },
{ INT64_C(0x0000000090000204), 0x1.20000408p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ffffdfb), -0x1.2000040ap+31, 0x0p+0 },
{ INT64_C(0x0000000090000208), 0x1.2000041p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ffffdf7), -0x1.20000412p+31, 0x0p+0 },
{ INT64_C(0x0000000090000210), 0x1.2000042p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ffffdef), -0x1.20000422p+31, 0x0p+0 },
{ INT64_C(0x0000000090000240), 0x1.2000048p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ffffdbf), -0x1.20000482p+31, 0x0p+0 },
{ INT64_C(0x0000000090000400), 0x1.200008p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ffffbff), -0x1.20000802p+31, 0x0p+0 },
{ INT64_C(0x0000000090000401), 0x1.20000802p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ffffbfe), -0x1.20000804p+31, 0x0p+0 },
{ INT64_C(0x0000000090000410), 0x1.2000082p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ffffbef), -0x1.20000822p+31, 0x0p+0 },
{ INT64_C(0x0000000090000500), 0x1.20000ap+31, 0x0p+0 },
{ INT64_C(0xffffffff6ffffaff), -0x1.20000a02p+31, 0x0p+0 },
{ INT64_C(0x0000000090002000), 0x1.20004p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fffdfff), -0x1.20004002p+31, 0x0p+0 },
{ INT64_C(0x0000000090002001), 0x1.20004002p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fffdffe), -0x1.20004004p+31, 0x0p+0 },
{ INT64_C(0x0000000090002010), 0x1.2000402p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fffdfef), -0x1.20004022p+31, 0x0p+0 },
{ INT64_C(0x0000000090002020), 0x1.2000404p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fffdfdf), -0x1.20004042p+31, 0x0p+0 },
{ INT64_C(0x0000000090002080), 0x1.200041p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fffdf7f), -0x1.20004102p+31, 0x0p+0 },
{ INT64_C(0x0000000090002100), 0x1.200042p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fffdeff), -0x1.20004202p+31, 0x0p+0 },
{ INT64_C(0x0000000090002400), 0x1.200048p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fffdbff), -0x1.20004802p+31, 0x0p+0 },
{ INT64_C(0x0000000090008000), 0x1.2001p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fff7fff), -0x1.20010002p+31, 0x0p+0 },
{ INT64_C(0x0000000090008008), 0x1.2001001p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fff7ff7), -0x1.20010012p+31, 0x0p+0 },
{ INT64_C(0x0000000090008010), 0x1.2001002p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fff7fef), -0x1.20010022p+31, 0x0p+0 },
{ INT64_C(0x0000000090008080), 0x1.200101p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fff7f7f), -0x1.20010102p+31, 0x0p+0 },
{ INT64_C(0x0000000090008400), 0x1.200108p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fff7bff), -0x1.20010802p+31, 0x0p+0 },
{ INT64_C(0x0000000090008800), 0x1.20011p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fff77ff), -0x1.20011002p+31, 0x0p+0 },
{ INT64_C(0x0000000090080000), 0x1.201p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ff7ffff), -0x1.20100002p+31, 0x0p+0 },
{ INT64_C(0x0000000090080004), 0x1.20100008p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ff7fffb), -0x1.2010000ap+31, 0x0p+0 },
{ INT64_C(0x0000000090080040), 0x1.2010008p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ff7ffbf), -0x1.20100082p+31, 0x0p+0 },
{ INT64_C(0x0000000090080200), 0x1.201004p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ff7fdff), -0x1.20100402p+31, 0x0p+0 },
{ INT64_C(0x0000000090082000), 0x1.20104p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ff7dfff), -0x1.20104002p+31, 0x0p+0 },
{ INT64_C(0x0000000090084000), 0x1.20108p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ff7bfff), -0x1.20108002p+31, 0x0p+0 },
{ INT64_C(0x0000000090090000), 0x1.2012p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ff6ffff), -0x1.20120002p+31, 0x0p+0 },
{ INT64_C(0x00000000900a0000), 0x1.2014p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ff5ffff), -0x1.20140002p+31, 0x0p+0 },
{ INT64_C(0x0000000090200000), 0x1.204p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fdfffff), -0x1.20400002p+31, 0x0p+0 },
{ INT64_C(0x0000000090200008), 0x1.2040001p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fdffff7), -0x1.20400012p+31, 0x0p+0 },
{ INT64_C(0x0000000090200020), 0x1.2040004p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fdfffdf), -0x1.20400042p+31, 0x0p+0 },
{ INT64_C(0x0000000090200100), 0x1.204002p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fdffeff), -0x1.20400202p+31, 0x0p+0 },
{ INT64_C(0x0000000090201000), 0x1.20402p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fdfefff), -0x1.20402002p+31, 0x0p+0 },
{ INT64_C(0x0000000090208000), 0x1.2041p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fdf7fff), -0x1.20410002p+31, 0x0p+0 },
{ INT64_C(0x0000000090280000), 0x1.205p+31, 0x0p+0 },
{ INT64_C(0xffffffff6fd7ffff), -0x1.20500002p+31, 0x0p+0 },
{ INT64_C(0x0000000091000000), 0x1.22p+31, 0x0p+0 },
{ INT64_C(0xffffffff6effffff), -0x1.22000002p+31, 0x0p+0 },
{ INT64_C(0x0000000091000004), 0x1.22000008p+31, 0x0p+0 },
{ INT64_C(0xffffffff6efffffb), -0x1.2200000ap+31, 0x0p+0 },
{ INT64_C(0x0000000091000010), 0x1.2200002p+31, 0x0p+0 },
{ INT64_C(0xffffffff6effffef), -0x1.22000022p+31, 0x0p+0 },
{ INT64_C(0x0000000091000080), 0x1.220001p+31, 0x0p+0 },
{ INT64_C(0xffffffff6effff7f), -0x1.22000102p+31, 0x0p+0 },
{ INT64_C(0x0000000091000400), 0x1.220008p+31, 0x0p+0 },
{ INT64_C(0xffffffff6efffbff), -0x1.22000802p+31, 0x0p+0 },
{ INT64_C(0x0000000091000800), 0x1.22001p+31, 0x0p+0 },
{ INT64_C(0xffffffff6efff7ff), -0x1.22001002p+31, 0x0p+0 },
{ INT64_C(0x0000000091008000), 0x1.2201p+31, 0x0p+0 },
{ INT64_C(0xffffffff6eff7fff), -0x1.22010002p+31, 0x0p+0 },
{ INT64_C(0x0000000091080000), 0x1.221p+31, 0x0p+0 },
{ INT64_C(0xffffffff6ef7ffff), -0x1.22100002p+31, 0x0p+0 },
{ INT64_C(0x0000000091200000), 0x1.224p+31, 0x0p+0 },
{ INT64_C(0xffffffff6edfffff), -0x1.22400002p+31, 0x0p+0 },
{ INT64_C(0x0000000091800000), 0x1.23p+31, 0x0p+0 },
{ INT64_C(0xffffffff6e7fffff), -0x1.23000002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000004), 0x1.80000008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffffffb), -0x1.8000000ap+31, 0x0p+0 },
{ INT64_C(0x00000000c0000006), 0x1.8000000cp+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffffff9), -0x1.8000000ep+31, 0x0p+0 },
{ INT64_C(0x00000000c0000040), 0x1.8000008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fffffbf), -0x1.80000082p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000041), 0x1.80000082p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fffffbe), -0x1.80000084p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000042), 0x1.80000084p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fffffbd), -0x1.80000086p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000048), 0x1.8000009p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fffffb7), -0x1.80000092p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000400), 0x1.800008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffffbff), -0x1.80000802p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000408), 0x1.8000081p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffffbf7), -0x1.80000812p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000420), 0x1.8000084p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffffbdf), -0x1.80000842p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000480), 0x1.800009p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffffb7f), -0x1.80000902p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000800), 0x1.80001p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffff7ff), -0x1.80001002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000801), 0x1.80001002p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffff7fe), -0x1.80001004p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000808), 0x1.8000101p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffff7f7), -0x1.80001012p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000840), 0x1.8000108p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffff7bf), -0x1.80001082p+31, 0x0p+0 },
{ INT64_C(0x00000000c0000c00), 0x1.800018p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffff3ff), -0x1.80001802p+31, 0x0p+0 },
{ INT64_C(0x00000000c0008000), 0x1.8001p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fff7fff), -0x1.80010002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0008001), 0x1.80010002p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fff7ffe), -0x1.80010004p+31, 0x0p+0 },
{ INT64_C(0x00000000c0008008), 0x1.8001001p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fff7ff7), -0x1.80010012p+31, 0x0p+0 },
{ INT64_C(0x00000000c0008040), 0x1.8001008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fff7fbf), -0x1.80010082p+31, 0x0p+0 },
{ INT64_C(0x00000000c0008100), 0x1.800102p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fff7eff), -0x1.80010202p+31, 0x0p+0 },
{ INT64_C(0x00000000c0008800), 0x1.80011p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fff77ff), -0x1.80011002p+31, 0x0p+0 },
{ INT64_C(0x00000000c000a000), 0x1.80014p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fff5fff), -0x1.80014002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0040000), 0x1.8008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffbffff), -0x1.80080002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0040004), 0x1.80080008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffbfffb), -0x1.8008000ap+31, 0x0p+0 },
{ INT64_C(0x00000000c0040040), 0x1.8008008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffbffbf), -0x1.80080082p+31, 0x0p+0 },
{ INT64_C(0x00000000c0040200), 0x1.800804p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffbfdff), -0x1.80080402p+31, 0x0p+0 },
{ INT64_C(0x00000000c0042000), 0x1.80084p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ffbdfff), -0x1.80084002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0060000), 0x1.800cp+31, 0x0p+0 },
{ INT64_C(0xffffffff3ff9ffff), -0x1.800c0002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0200000), 0x1.804p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fdfffff), -0x1.80400002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0200008), 0x1.8040001p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fdffff7), -0x1.80400012p+31, 0x0p+0 },
{ INT64_C(0x00000000c0200020), 0x1.8040004p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fdfffdf), -0x1.80400042p+31, 0x0p+0 },
{ INT64_C(0x00000000c0200200), 0x1.804004p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fdffdff), -0x1.80400402p+31, 0x0p+0 },
{ INT64_C(0x00000000c0200400), 0x1.804008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fdffbff), -0x1.80400802p+31, 0x0p+0 },
{ INT64_C(0x00000000c0201000), 0x1.80402p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fdfefff), -0x1.80402002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0210000), 0x1.8042p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fdeffff), -0x1.80420002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0280000), 0x1.805p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fd7ffff), -0x1.80500002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0400000), 0x1.808p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fbfffff), -0x1.80800002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0400004), 0x1.80800008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fbffffb), -0x1.8080000ap+31, 0x0p+0 },
{ INT64_C(0x00000000c0400040), 0x1.8080008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fbfffbf), -0x1.80800082p+31, 0x0p+0 },
{ INT64_C(0x00000000c0400400), 0x1.808008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fbffbff), -0x1.80800802p+31, 0x0p+0 },
{ INT64_C(0x00000000c0404000), 0x1.80808p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fbfbfff), -0x1.80808002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0420000), 0x1.8084p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fbdffff), -0x1.80840002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0480000), 0x1.809p+31, 0x0p+0 },
{ INT64_C(0xffffffff3fb7ffff), -0x1.80900002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0600000), 0x1.80cp+31, 0x0p+0 },
{ INT64_C(0xffffffff3f9fffff), -0x1.80c00002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0800000), 0x1.81p+31, 0x0p+0 },
{ INT64_C(0xffffffff3f7fffff), -0x1.81000002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0800001), 0x1.81000002p+31, 0x0p+0 },
{ INT64_C(0xffffffff3f7ffffe), -0x1.81000004p+31, 0x0p+0 },
{ INT64_C(0x00000000c0800010), 0x1.8100002p+31, 0x0p+0 },
{ INT64_C(0xffffffff3f7fffef), -0x1.81000022p+31, 0x0p+0 },
{ INT64_C(0x00000000c0800100), 0x1.810002p+31, 0x0p+0 },
{ INT64_C(0xffffffff3f7ffeff), -0x1.81000202p+31, 0x0p+0 },
{ INT64_C(0x00000000c0800800), 0x1.81001p+31, 0x0p+0 },
{ INT64_C(0xffffffff3f7ff7ff), -0x1.81001002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0802000), 0x1.81004p+31, 0x0p+0 },
{ INT64_C(0xffffffff3f7fdfff), -0x1.81004002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0810000), 0x1.8102p+31, 0x0p+0 },
{ INT64_C(0xffffffff3f7effff), -0x1.81020002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0880000), 0x1.811p+31, 0x0p+0 },
{ INT64_C(0xffffffff3f77ffff), -0x1.81100002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0a00000), 0x1.814p+31, 0x0p+0 },
{ INT64_C(0xffffffff3f5fffff), -0x1.81400002p+31, 0x0p+0 },
{ INT64_C(0x00000000c0c00000), 0x1.818p+31, 0x0p+0 },
{ INT64_C(0xffffffff3f3fffff), -0x1.81800002p+31, 0x0p+0 },
{ INT64_C(0x00000000c1000000), 0x1.82p+31, 0x0p+0 },
{ INT64_C(0xffffffff3effffff), -0x1.82000002p+31, 0x0p+0 },
{ INT64_C(0x00000000c1000004), 0x1.82000008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3efffffb), -0x1.8200000ap+31, 0x0p+0 },
{ INT64_C(0x00000000c1000020), 0x1.8200004p+31, 0x0p+0 },
{ INT64_C(0xffffffff3effffdf), -0x1.82000042p+31, 0x0p+0 },
{ INT64_C(0x00000000c1000100), 0x1.820002p+31, 0x0p+0 },
{ INT64_C(0xffffffff3efffeff), -0x1.82000202p+31, 0x0p+0 },
{ INT64_C(0x00000000c1000800), 0x1.82001p+31, 0x0p+0 },
{ INT64_C(0xffffffff3efff7ff), -0x1.82001002p+31, 0x0p+0 },
{ INT64_C(0x00000000c1004000), 0x1.82008p+31, 0x0p+0 },
{ INT64_C(0xffffffff3effbfff), -0x1.82008002p+31, 0x0p+0 },
{ INT64_C(0x00000000c1008000), 0x1.8201p+31, 0x0p+0 },
{ INT64_C(0xffffffff3eff7fff), -0x1.82010002p+31, 0x0p+0 },
{ INT64_C(0x00000000c1080000), 0x1.821p+31, 0x0p+0 },
{ INT64_C(0xffffffff3ef7ffff), -0x1.82100002p+31, 0x0p+0 },
{ INT64_C(0x00000000c1200000), 0x1.824p+31, 0x0p+0 },
{ INT64_C(0xffffffff3edfffff), -0x1.82400002p+31, 0x0p+0 },
{ INT64_C(0x00000000c1800000), 0x1.83p+31, 0x0p+0 },
{ INT64_C(0xffffffff3e7fffff), -0x1.83000002p+31, 0x0p+0 },
{ INT64_C(0x00000000c8000000), 0x1.9p+31, 0x0p+0 },
{ INT64_C(0xffffffff37ffffff), -0x1.90000002p+31, 0x0p+0 },
{ INT64_C(0x00000000c8000004), 0x1.90000008p+31, 0x0p+0 },
{ INT64_C(0xffffffff37fffffb), -0x1.9000000ap+31, 0x0p+0 },
{ INT64_C(0x00000000c8000008), 0x1.9000001p+31, 0x0p+0 },
{ INT64_C(0xffffffff37fffff7), -0x1.90000012p+31, 0x0p+0 },
{ INT64_C(0x00000000c8000020), 0x1.9000004p+31, 0x0p+0 },
{ INT64_C(0xffffffff37ffffdf), -0x1.90000042p+31, 0x0p+0 },
{ INT64_C(0x00000000c8000200), 0x1.900004p+31, 0x0p+0 },
{ INT64_C(0xffffffff37fffdff), -0x1.90000402p+31, 0x0p+0 },
{ INT64_C(0x00000000c8002000), 0x1.90004p+31, 0x0p+0 },
{ INT64_C(0xffffffff37ffdfff), -0x1.90004002p+31, 0x0p+0 },
{ INT64_C(0x00000000c8010000), 0x1.9002p+31, 0x0p+0 },
{ INT64_C(0xffffffff37feffff), -0x1.90020002p+31, 0x0p+0 },
{ INT64_C(0x00000000c8020000), 0x1.9004p+31, 0x0p+0 },
{ INT64_C(0xffffffff37fdffff), -0x1.90040002p+31, 0x0p+0 },
{ INT64_C(0x00000000c8080000), 0x1.901p+31, 0x0p+0 },
{ INT64_C(0xffffffff37f7ffff), -0x1.90100002p+31, 0x0p+0 },
{ INT64_C(0x00000000c8100000), 0x1.902p+31, 0x0p+0 },
{ INT64_C(0xffffffff37efffff), -0x1.90200002p+31, 0x0p+0 },
{ INT64_C(0x00000000c8400000), 0x1.908p+31, 0x0p+0 },
{ INT64_C(0xffffffff37bfffff), -0x1.90800002p+31, 0x0p+0 },
{ INT64_C(0x00000000c9000000), 0x1.92p+31, 0x0p+0 },
{ INT64_C(0xffffffff36ffffff), -0x1.92000002p+31, 0x0p+0 },
{ INT64_C(0x000000080000000a), 0x1.000000014p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffffff5), -0x1.000000016p+35, 0x0p+0 },
{ INT64_C(0x0000000800000022), 0x1.000000044p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffffdd), -0x1.000000046p+35, 0x0p+0 },
{ INT64_C(0x0000000800000024), 0x1.000000048p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffffdb), -0x1.00000004ap+35, 0x0p+0 },
{ INT64_C(0x0000000800000025), 0x1.00000004ap+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffffda), -0x1.00000004cp+35, 0x0p+0 },
{ INT64_C(0x0000000800000026), 0x1.00000004cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffffd9), -0x1.00000004ep+35, 0x0p+0 },
{ INT64_C(0x0000000800000041), 0x1.000000082p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffffbe), -0x1.000000084p+35, 0x0p+0 },
{ INT64_C(0x0000000800000048), 0x1.00000009p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffffb7), -0x1.000000092p+35, 0x0p+0 },
{ INT64_C(0x000000080000004c), 0x1.000000098p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffffb3), -0x1.00000009ap+35, 0x0p+0 },
{ INT64_C(0x0000000800000102), 0x1.000000204p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffffefd), -0x1.000000206p+35, 0x0p+0 },
{ INT64_C(0x0000000800000120), 0x1.00000024p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffffedf), -0x1.000000242p+35, 0x0p+0 },
{ INT64_C(0x0000000800000121), 0x1.000000242p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffffede), -0x1.000000244p+35, 0x0p+0 },
{ INT64_C(0x0000000800000130), 0x1.00000026p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffffecf), -0x1.000000262p+35, 0x0p+0 },
{ INT64_C(0x0000000800000140), 0x1.00000028p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffffebf), -0x1.000000282p+35, 0x0p+0 },
{ INT64_C(0x0000000800000144), 0x1.000000288p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffffebb), -0x1.00000028ap+35, 0x0p+0 },
{ INT64_C(0x0000000800000160), 0x1.0000002cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffffe9f), -0x1.0000002c2p+35, 0x0p+0 },
{ INT64_C(0x0000000800001002), 0x1.000002004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffeffd), -0x1.000002006p+35, 0x0p+0 },
{ INT64_C(0x0000000800001020), 0x1.00000204p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffefdf), -0x1.000002042p+35, 0x0p+0 },
{ INT64_C(0x0000000800001022), 0x1.000002044p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffefdd), -0x1.000002046p+35, 0x0p+0 },
{ INT64_C(0x0000000800001024), 0x1.000002048p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffefdb), -0x1.00000204ap+35, 0x0p+0 },
{ INT64_C(0x0000000800001028), 0x1.00000205p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffefd7), -0x1.000002052p+35, 0x0p+0 },
{ INT64_C(0x0000000800001030), 0x1.00000206p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffefcf), -0x1.000002062p+35, 0x0p+0 },
{ INT64_C(0x0000000800001200), 0x1.0000024p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffedff), -0x1.000002402p+35, 0x0p+0 },
{ INT64_C(0x0000000800001208), 0x1.00000241p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffedf7), -0x1.000002412p+35, 0x0p+0 },
{ INT64_C(0x0000000800001220), 0x1.00000244p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffeddf), -0x1.000002442p+35, 0x0p+0 },
{ INT64_C(0x0000000800001300), 0x1.0000026p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffecff), -0x1.000002602p+35, 0x0p+0 },
{ INT64_C(0x0000000800004001), 0x1.000008002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffbffe), -0x1.000008004p+35, 0x0p+0 },
{ INT64_C(0x0000000800004008), 0x1.00000801p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffbff7), -0x1.000008012p+35, 0x0p+0 },
{ INT64_C(0x0000000800004009), 0x1.000008012p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffbff6), -0x1.000008014p+35, 0x0p+0 },
{ INT64_C(0x0000000800004080), 0x1.0000081p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffbf7f), -0x1.000008102p+35, 0x0p+0 },
{ INT64_C(0x0000000800004081), 0x1.000008102p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffbf7e), -0x1.000008104p+35, 0x0p+0 },
{ INT64_C(0x0000000800004088), 0x1.00000811p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffbf77), -0x1.000008112p+35, 0x0p+0 },
{ INT64_C(0x00000008000040c0), 0x1.00000818p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffbf3f), -0x1.000008182p+35, 0x0p+0 },
{ INT64_C(0x0000000800004800), 0x1.000009p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffb7ff), -0x1.000009002p+35, 0x0p+0 },
{ INT64_C(0x0000000800004801), 0x1.000009002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffb7fe), -0x1.000009004p+35, 0x0p+0 },
{ INT64_C(0x0000000800004802), 0x1.000009004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffb7fd), -0x1.000009006p+35, 0x0p+0 },
{ INT64_C(0x0000000800004808), 0x1.00000901p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffb7f7), -0x1.000009012p+35, 0x0p+0 },
{ INT64_C(0x0000000800004820), 0x1.00000904p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffb7df), -0x1.000009042p+35, 0x0p+0 },
{ INT64_C(0x0000000800004880), 0x1.0000091p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffb77f), -0x1.000009102p+35, 0x0p+0 },
{ INT64_C(0x0000000800004a00), 0x1.0000094p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffb5ff), -0x1.000009402p+35, 0x0p+0 },
{ INT64_C(0x0000000800005000), 0x1.00000ap+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffafff), -0x1.00000a002p+35, 0x0p+0 },
{ INT64_C(0x0000000800005001), 0x1.00000a002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffaffe), -0x1.00000a004p+35, 0x0p+0 },
{ INT64_C(0x0000000800005002), 0x1.00000a004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffaffd), -0x1.00000a006p+35, 0x0p+0 },
{ INT64_C(0x0000000800005020), 0x1.00000a04p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffafdf), -0x1.00000a042p+35, 0x0p+0 },
{ INT64_C(0x0000000800005080), 0x1.00000a1p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffaf7f), -0x1.00000a102p+35, 0x0p+0 },
{ INT64_C(0x0000000800005400), 0x1.00000a8p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffffabff), -0x1.00000a802p+35, 0x0p+0 },
{ INT64_C(0x0000000800040002), 0x1.000080004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbfffd), -0x1.000080006p+35, 0x0p+0 },
{ INT64_C(0x0000000800040010), 0x1.00008002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbffef), -0x1.000080022p+35, 0x0p+0 },
{ INT64_C(0x0000000800040018), 0x1.00008003p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbffe7), -0x1.000080032p+35, 0x0p+0 },
{ INT64_C(0x0000000800040040), 0x1.00008008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbffbf), -0x1.000080082p+35, 0x0p+0 },
{ INT64_C(0x0000000800040042), 0x1.000080084p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbffbd), -0x1.000080086p+35, 0x0p+0 },
{ INT64_C(0x0000000800040060), 0x1.0000800cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbff9f), -0x1.0000800c2p+35, 0x0p+0 },
{ INT64_C(0x0000000800040200), 0x1.0000804p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbfdff), -0x1.000080402p+35, 0x0p+0 },
{ INT64_C(0x0000000800040204), 0x1.000080408p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbfdfb), -0x1.00008040ap+35, 0x0p+0 },
{ INT64_C(0x0000000800040220), 0x1.00008044p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbfddf), -0x1.000080442p+35, 0x0p+0 },
{ INT64_C(0x0000000800040280), 0x1.0000805p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbfd7f), -0x1.000080502p+35, 0x0p+0 },
{ INT64_C(0x0000000800041000), 0x1.000082p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbefff), -0x1.000082002p+35, 0x0p+0 },
{ INT64_C(0x0000000800041002), 0x1.000082004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbeffd), -0x1.000082006p+35, 0x0p+0 },
{ INT64_C(0x0000000800041020), 0x1.00008204p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbefdf), -0x1.000082042p+35, 0x0p+0 },
{ INT64_C(0x0000000800041200), 0x1.0000824p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffbedff), -0x1.000082402p+35, 0x0p+0 },
{ INT64_C(0x0000000800050000), 0x1.0000ap+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffaffff), -0x1.0000a0002p+35, 0x0p+0 },
{ INT64_C(0x0000000800050008), 0x1.0000a001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffafff7), -0x1.0000a0012p+35, 0x0p+0 },
{ INT64_C(0x0000000800050020), 0x1.0000a004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffaffdf), -0x1.0000a0042p+35, 0x0p+0 },
{ INT64_C(0x0000000800050100), 0x1.0000a02p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffafeff), -0x1.0000a0202p+35, 0x0p+0 },
{ INT64_C(0x0000000800050800), 0x1.0000a1p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffaf7ff), -0x1.0000a1002p+35, 0x0p+0 },
{ INT64_C(0x0000000800058000), 0x1.0000bp+35, 0x0p+0 },
{ INT64_C(0xfffffff7fffa7fff), -0x1.0000b0002p+35, 0x0p+0 },
{ INT64_C(0x0000000800060000), 0x1.0000cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7fff9ffff), -0x1.0000c0002p+35, 0x0p+0 },
{ INT64_C(0x0000000800060008), 0x1.0000c001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fff9fff7), -0x1.0000c0012p+35, 0x0p+0 },
{ INT64_C(0x0000000800060080), 0x1.0000c01p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fff9ff7f), -0x1.0000c0102p+35, 0x0p+0 },
{ INT64_C(0x0000000800060400), 0x1.0000c08p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fff9fbff), -0x1.0000c0802p+35, 0x0p+0 },
{ INT64_C(0x0000000800061000), 0x1.0000c2p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fff9efff), -0x1.0000c2002p+35, 0x0p+0 },
{ INT64_C(0x0000000800068000), 0x1.0000dp+35, 0x0p+0 },
{ INT64_C(0xfffffff7fff97fff), -0x1.0000d0002p+35, 0x0p+0 },
{ INT64_C(0x0000000800070000), 0x1.0000ep+35, 0x0p+0 },
{ INT64_C(0xfffffff7fff8ffff), -0x1.0000e0002p+35, 0x0p+0 },
{ INT64_C(0x0000000800100008), 0x1.00020001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffeffff7), -0x1.000200012p+35, 0x0p+0 },
{ INT64_C(0x0000000800100009), 0x1.000200012p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffeffff6), -0x1.000200014p+35, 0x0p+0 },
{ INT64_C(0x0000000800100040), 0x1.00020008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefffbf), -0x1.000200082p+35, 0x0p+0 },
{ INT64_C(0x0000000800100044), 0x1.000200088p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefffbb), -0x1.00020008ap+35, 0x0p+0 },
{ INT64_C(0x0000000800100200), 0x1.0002004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffeffdff), -0x1.000200402p+35, 0x0p+0 },
{ INT64_C(0x0000000800100204), 0x1.000200408p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffeffdfb), -0x1.00020040ap+35, 0x0p+0 },
{ INT64_C(0x0000000800100220), 0x1.00020044p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffeffddf), -0x1.000200442p+35, 0x0p+0 },
{ INT64_C(0x0000000800100300), 0x1.0002006p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffeffcff), -0x1.000200602p+35, 0x0p+0 },
{ INT64_C(0x0000000800101000), 0x1.000202p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefefff), -0x1.000202002p+35, 0x0p+0 },
{ INT64_C(0x0000000800101001), 0x1.000202002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefeffe), -0x1.000202004p+35, 0x0p+0 },
{ INT64_C(0x0000000800101002), 0x1.000202004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefeffd), -0x1.000202006p+35, 0x0p+0 },
{ INT64_C(0x0000000800101020), 0x1.00020204p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefefdf), -0x1.000202042p+35, 0x0p+0 },
{ INT64_C(0x0000000800101080), 0x1.0002021p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefef7f), -0x1.000202102p+35, 0x0p+0 },
{ INT64_C(0x0000000800101400), 0x1.0002028p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefebff), -0x1.000202802p+35, 0x0p+0 },
{ INT64_C(0x0000000800102000), 0x1.000204p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefdfff), -0x1.000204002p+35, 0x0p+0 },
{ INT64_C(0x0000000800102001), 0x1.000204002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefdffe), -0x1.000204004p+35, 0x0p+0 },
{ INT64_C(0x0000000800102002), 0x1.000204004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefdffd), -0x1.000204006p+35, 0x0p+0 },
{ INT64_C(0x0000000800102008), 0x1.00020401p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefdff7), -0x1.000204012p+35, 0x0p+0 },
{ INT64_C(0x0000000800102010), 0x1.00020402p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefdfef), -0x1.000204022p+35, 0x0p+0 },
{ INT64_C(0x0000000800102020), 0x1.00020404p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefdfdf), -0x1.000204042p+35, 0x0p+0 },
{ INT64_C(0x0000000800102040), 0x1.00020408p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefdfbf), -0x1.000204082p+35, 0x0p+0 },
{ INT64_C(0x0000000800102100), 0x1.0002042p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefdeff), -0x1.000204202p+35, 0x0p+0 },
{ INT64_C(0x0000000800102400), 0x1.0002048p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffefdbff), -0x1.000204802p+35, 0x0p+0 },
{ INT64_C(0x0000000800120000), 0x1.00024p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffedffff), -0x1.000240002p+35, 0x0p+0 },
{ INT64_C(0x0000000800120002), 0x1.000240004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffedfffd), -0x1.000240006p+35, 0x0p+0 },
{ INT64_C(0x0000000800120008), 0x1.00024001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffedfff7), -0x1.000240012p+35, 0x0p+0 },
{ INT64_C(0x0000000800120080), 0x1.0002401p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffedff7f), -0x1.000240102p+35, 0x0p+0 },
{ INT64_C(0x0000000800120800), 0x1.000241p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffedf7ff), -0x1.000241002p+35, 0x0p+0 },
{ INT64_C(0x0000000800122000), 0x1.000244p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffeddfff), -0x1.000244002p+35, 0x0p+0 },
{ INT64_C(0x0000000800128000), 0x1.00025p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffed7fff), -0x1.000250002p+35, 0x0p+0 },
{ INT64_C(0x0000000800140000), 0x1.00028p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffebffff), -0x1.000280002p+35, 0x0p+0 },
{ INT64_C(0x0000000800140004), 0x1.000280008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffebfffb), -0x1.00028000ap+35, 0x0p+0 },
{ INT64_C(0x0000000800140010), 0x1.00028002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffebffef), -0x1.000280022p+35, 0x0p+0 },
{ INT64_C(0x0000000800140020), 0x1.00028004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffebffdf), -0x1.000280042p+35, 0x0p+0 },
{ INT64_C(0x0000000800140200), 0x1.0002804p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffebfdff), -0x1.000280402p+35, 0x0p+0 },
{ INT64_C(0x0000000800141000), 0x1.000282p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffebefff), -0x1.000282002p+35, 0x0p+0 },
{ INT64_C(0x0000000800142000), 0x1.000284p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffebdfff), -0x1.000284002p+35, 0x0p+0 },
{ INT64_C(0x0000000800144000), 0x1.000288p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffebbfff), -0x1.000288002p+35, 0x0p+0 },
{ INT64_C(0x0000000800160000), 0x1.0002cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffe9ffff), -0x1.0002c0002p+35, 0x0p+0 },
{ INT64_C(0x0000000800200002), 0x1.000400004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdffffd), -0x1.000400006p+35, 0x0p+0 },
{ INT64_C(0x0000000800200003), 0x1.000400006p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdffffc), -0x1.000400008p+35, 0x0p+0 },
{ INT64_C(0x0000000800200004), 0x1.000400008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdffffb), -0x1.00040000ap+35, 0x0p+0 },
{ INT64_C(0x0000000800200008), 0x1.00040001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdffff7), -0x1.000400012p+35, 0x0p+0 },
{ INT64_C(0x000000080020000c), 0x1.000400018p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdffff3), -0x1.00040001ap+35, 0x0p+0 },
{ INT64_C(0x0000000800200020), 0x1.00040004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdfffdf), -0x1.000400042p+35, 0x0p+0 },
{ INT64_C(0x0000000800200024), 0x1.000400048p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdfffdb), -0x1.00040004ap+35, 0x0p+0 },
{ INT64_C(0x0000000800200030), 0x1.00040006p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdfffcf), -0x1.000400062p+35, 0x0p+0 },
{ INT64_C(0x0000000800200200), 0x1.0004004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdffdff), -0x1.000400402p+35, 0x0p+0 },
{ INT64_C(0x0000000800200204), 0x1.000400408p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdffdfb), -0x1.00040040ap+35, 0x0p+0 },
{ INT64_C(0x0000000800200210), 0x1.00040042p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdffdef), -0x1.000400422p+35, 0x0p+0 },
{ INT64_C(0x0000000800200280), 0x1.0004005p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdffd7f), -0x1.000400502p+35, 0x0p+0 },
{ INT64_C(0x0000000800200800), 0x1.000401p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdff7ff), -0x1.000401002p+35, 0x0p+0 },
{ INT64_C(0x0000000800200802), 0x1.000401004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdff7fd), -0x1.000401006p+35, 0x0p+0 },
{ INT64_C(0x0000000800200810), 0x1.00040102p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdff7ef), -0x1.000401022p+35, 0x0p+0 },
{ INT64_C(0x0000000800200820), 0x1.00040104p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdff7df), -0x1.000401042p+35, 0x0p+0 },
{ INT64_C(0x0000000800200900), 0x1.0004012p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdff6ff), -0x1.000401202p+35, 0x0p+0 },
{ INT64_C(0x0000000800204000), 0x1.000408p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdfbfff), -0x1.000408002p+35, 0x0p+0 },
{ INT64_C(0x0000000800204008), 0x1.00040801p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdfbff7), -0x1.000408012p+35, 0x0p+0 },
{ INT64_C(0x0000000800204020), 0x1.00040804p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdfbfdf), -0x1.000408042p+35, 0x0p+0 },
{ INT64_C(0x0000000800204080), 0x1.0004081p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdfbf7f), -0x1.000408102p+35, 0x0p+0 },
{ INT64_C(0x0000000800204200), 0x1.0004084p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdfbdff), -0x1.000408402p+35, 0x0p+0 },
{ INT64_C(0x0000000800206000), 0x1.00040cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdf9fff), -0x1.00040c002p+35, 0x0p+0 },
{ INT64_C(0x0000000800208000), 0x1.00041p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdf7fff), -0x1.000410002p+35, 0x0p+0 },
{ INT64_C(0x0000000800208004), 0x1.000410008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdf7ffb), -0x1.00041000ap+35, 0x0p+0 },
{ INT64_C(0x0000000800208040), 0x1.00041008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdf7fbf), -0x1.000410082p+35, 0x0p+0 },
{ INT64_C(0x0000000800208100), 0x1.0004102p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdf7eff), -0x1.000410202p+35, 0x0p+0 },
{ INT64_C(0x0000000800208800), 0x1.000411p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdf77ff), -0x1.000411002p+35, 0x0p+0 },
{ INT64_C(0x0000000800240000), 0x1.00048p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdbffff), -0x1.000480002p+35, 0x0p+0 },
{ INT64_C(0x0000000800240004), 0x1.000480008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdbfffb), -0x1.00048000ap+35, 0x0p+0 },
{ INT64_C(0x0000000800240020), 0x1.00048004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdbffdf), -0x1.000480042p+35, 0x0p+0 },
{ INT64_C(0x0000000800240100), 0x1.0004802p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdbfeff), -0x1.000480202p+35, 0x0p+0 },
{ INT64_C(0x0000000800241000), 0x1.000482p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdbefff), -0x1.000482002p+35, 0x0p+0 },
{ INT64_C(0x0000000800250000), 0x1.0004ap+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffdaffff), -0x1.0004a0002p+35, 0x0p+0 },
{ INT64_C(0x0000000800300000), 0x1.0006p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffcfffff), -0x1.000600002p+35, 0x0p+0 },
{ INT64_C(0x0000000800300008), 0x1.00060001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffcffff7), -0x1.000600012p+35, 0x0p+0 },
{ INT64_C(0x0000000800300040), 0x1.00060008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffcfffbf), -0x1.000600082p+35, 0x0p+0 },
{ INT64_C(0x0000000800300200), 0x1.0006004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffcffdff), -0x1.000600402p+35, 0x0p+0 },
{ INT64_C(0x0000000800300400), 0x1.0006008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffcffbff), -0x1.000600802p+35, 0x0p+0 },
{ INT64_C(0x0000000800304000), 0x1.000608p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffcfbfff), -0x1.000608002p+35, 0x0p+0 },
{ INT64_C(0x0000000800340000), 0x1.00068p+35, 0x0p+0 },
{ INT64_C(0xfffffff7ffcbffff), -0x1.000680002p+35, 0x0p+0 },
{ INT64_C(0x0000000801000004), 0x1.002000008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefffffb), -0x1.00200000ap+35, 0x0p+0 },
{ INT64_C(0x0000000801000008), 0x1.00200001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefffff7), -0x1.002000012p+35, 0x0p+0 },
{ INT64_C(0x0000000801000009), 0x1.002000012p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefffff6), -0x1.002000014p+35, 0x0p+0 },
{ INT64_C(0x0000000801000040), 0x1.00200008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feffffbf), -0x1.002000082p+35, 0x0p+0 },
{ INT64_C(0x0000000801000041), 0x1.002000082p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feffffbe), -0x1.002000084p+35, 0x0p+0 },
{ INT64_C(0x0000000801000044), 0x1.002000088p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feffffbb), -0x1.00200008ap+35, 0x0p+0 },
{ INT64_C(0x0000000801000048), 0x1.00200009p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feffffb7), -0x1.002000092p+35, 0x0p+0 },
{ INT64_C(0x0000000801000200), 0x1.0020004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefffdff), -0x1.002000402p+35, 0x0p+0 },
{ INT64_C(0x0000000801000201), 0x1.002000402p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefffdfe), -0x1.002000404p+35, 0x0p+0 },
{ INT64_C(0x0000000801000202), 0x1.002000404p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefffdfd), -0x1.002000406p+35, 0x0p+0 },
{ INT64_C(0x0000000801000220), 0x1.00200044p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefffddf), -0x1.002000442p+35, 0x0p+0 },
{ INT64_C(0x0000000801000800), 0x1.002001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefff7ff), -0x1.002001002p+35, 0x0p+0 },
{ INT64_C(0x0000000801000804), 0x1.002001008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefff7fb), -0x1.00200100ap+35, 0x0p+0 },
{ INT64_C(0x0000000801000820), 0x1.00200104p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefff7df), -0x1.002001042p+35, 0x0p+0 },
{ INT64_C(0x0000000801000900), 0x1.0020012p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefff6ff), -0x1.002001202p+35, 0x0p+0 },
{ INT64_C(0x0000000801004000), 0x1.002008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feffbfff), -0x1.002008002p+35, 0x0p+0 },
{ INT64_C(0x0000000801004008), 0x1.00200801p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feffbff7), -0x1.002008012p+35, 0x0p+0 },
{ INT64_C(0x0000000801004010), 0x1.00200802p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feffbfef), -0x1.002008022p+35, 0x0p+0 },
{ INT64_C(0x0000000801004100), 0x1.0020082p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feffbeff), -0x1.002008202p+35, 0x0p+0 },
{ INT64_C(0x0000000801004200), 0x1.0020084p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feffbdff), -0x1.002008402p+35, 0x0p+0 },
{ INT64_C(0x0000000801005000), 0x1.00200ap+35, 0x0p+0 },
{ INT64_C(0xfffffff7feffafff), -0x1.00200a002p+35, 0x0p+0 },
{ INT64_C(0x0000000801006000), 0x1.00200cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7feff9fff), -0x1.00200c002p+35, 0x0p+0 },
{ INT64_C(0x0000000801020000), 0x1.00204p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefdffff), -0x1.002040002p+35, 0x0p+0 },
{ INT64_C(0x0000000801020004), 0x1.002040008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefdfffb), -0x1.00204000ap+35, 0x0p+0 },
{ INT64_C(0x0000000801020020), 0x1.00204004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefdffdf), -0x1.002040042p+35, 0x0p+0 },
{ INT64_C(0x0000000801020080), 0x1.0020401p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefdff7f), -0x1.002040102p+35, 0x0p+0 },
{ INT64_C(0x0000000801020200), 0x1.0020404p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefdfdff), -0x1.002040402p+35, 0x0p+0 },
{ INT64_C(0x0000000801020400), 0x1.0020408p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefdfbff), -0x1.002040802p+35, 0x0p+0 },
{ INT64_C(0x0000000801020800), 0x1.002041p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefdf7ff), -0x1.002041002p+35, 0x0p+0 },
{ INT64_C(0x0000000801022000), 0x1.002044p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefddfff), -0x1.002044002p+35, 0x0p+0 },
{ INT64_C(0x0000000801028000), 0x1.00205p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefd7fff), -0x1.002050002p+35, 0x0p+0 },
{ INT64_C(0x0000000801040000), 0x1.00208p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefbffff), -0x1.002080002p+35, 0x0p+0 },
{ INT64_C(0x0000000801040004), 0x1.002080008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefbfffb), -0x1.00208000ap+35, 0x0p+0 },
{ INT64_C(0x0000000801040008), 0x1.00208001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefbfff7), -0x1.002080012p+35, 0x0p+0 },
{ INT64_C(0x0000000801040010), 0x1.00208002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefbffef), -0x1.002080022p+35, 0x0p+0 },
{ INT64_C(0x0000000801040100), 0x1.0020802p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefbfeff), -0x1.002080202p+35, 0x0p+0 },
{ INT64_C(0x0000000801040200), 0x1.0020804p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefbfdff), -0x1.002080402p+35, 0x0p+0 },
{ INT64_C(0x0000000801040400), 0x1.0020808p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefbfbff), -0x1.002080802p+35, 0x0p+0 },
{ INT64_C(0x0000000801044000), 0x1.002088p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefbbfff), -0x1.002088002p+35, 0x0p+0 },
{ INT64_C(0x0000000801048000), 0x1.00209p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fefb7fff), -0x1.002090002p+35, 0x0p+0 },
{ INT64_C(0x0000000801060000), 0x1.0020cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7fef9ffff), -0x1.0020c0002p+35, 0x0p+0 },
{ INT64_C(0x0000000801100000), 0x1.0022p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feefffff), -0x1.002200002p+35, 0x0p+0 },
{ INT64_C(0x0000000801100004), 0x1.002200008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feeffffb), -0x1.00220000ap+35, 0x0p+0 },
{ INT64_C(0x0000000801100010), 0x1.00220002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feefffef), -0x1.002200022p+35, 0x0p+0 },
{ INT64_C(0x0000000801100040), 0x1.00220008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feefffbf), -0x1.002200082p+35, 0x0p+0 },
{ INT64_C(0x0000000801100400), 0x1.0022008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feeffbff), -0x1.002200802p+35, 0x0p+0 },
{ INT64_C(0x0000000801101000), 0x1.002202p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feefefff), -0x1.002202002p+35, 0x0p+0 },
{ INT64_C(0x0000000801110000), 0x1.00222p+35, 0x0p+0 },
{ INT64_C(0xfffffff7feeeffff), -0x1.002220002p+35, 0x0p+0 },
{ INT64_C(0x0000000801800000), 0x1.003p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fe7fffff), -0x1.003000002p+35, 0x0p+0 },
{ INT64_C(0x0000000801800001), 0x1.003000002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fe7ffffe), -0x1.003000004p+35, 0x0p+0 },
{ INT64_C(0x0000000801800004), 0x1.003000008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fe7ffffb), -0x1.00300000ap+35, 0x0p+0 },
{ INT64_C(0x0000000801800010), 0x1.00300002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fe7fffef), -0x1.003000022p+35, 0x0p+0 },
{ INT64_C(0x0000000801800100), 0x1.0030002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fe7ffeff), -0x1.003000202p+35, 0x0p+0 },
{ INT64_C(0x0000000801801000), 0x1.003002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fe7fefff), -0x1.003002002p+35, 0x0p+0 },
{ INT64_C(0x0000000801804000), 0x1.003008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fe7fbfff), -0x1.003008002p+35, 0x0p+0 },
{ INT64_C(0x0000000801810000), 0x1.00302p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fe7effff), -0x1.003020002p+35, 0x0p+0 },
{ INT64_C(0x0000000801840000), 0x1.00308p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fe7bffff), -0x1.003080002p+35, 0x0p+0 },
{ INT64_C(0x0000000801900000), 0x1.0032p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fe6fffff), -0x1.003200002p+35, 0x0p+0 },
{ INT64_C(0x0000000804000008), 0x1.00800001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfffff7), -0x1.008000012p+35, 0x0p+0 },
{ INT64_C(0x0000000804000009), 0x1.008000012p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfffff6), -0x1.008000014p+35, 0x0p+0 },
{ INT64_C(0x0000000804000010), 0x1.00800002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffffef), -0x1.008000022p+35, 0x0p+0 },
{ INT64_C(0x0000000804000018), 0x1.00800003p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffffe7), -0x1.008000032p+35, 0x0p+0 },
{ INT64_C(0x0000000804000080), 0x1.0080001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffff7f), -0x1.008000102p+35, 0x0p+0 },
{ INT64_C(0x0000000804000081), 0x1.008000102p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffff7e), -0x1.008000104p+35, 0x0p+0 },
{ INT64_C(0x0000000804000082), 0x1.008000104p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffff7d), -0x1.008000106p+35, 0x0p+0 },
{ INT64_C(0x0000000804000088), 0x1.00800011p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffff77), -0x1.008000112p+35, 0x0p+0 },
{ INT64_C(0x00000008040000c0), 0x1.00800018p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffff3f), -0x1.008000182p+35, 0x0p+0 },
{ INT64_C(0x0000000804000200), 0x1.0080004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfffdff), -0x1.008000402p+35, 0x0p+0 },
{ INT64_C(0x0000000804000202), 0x1.008000404p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfffdfd), -0x1.008000406p+35, 0x0p+0 },
{ INT64_C(0x0000000804000210), 0x1.00800042p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfffdef), -0x1.008000422p+35, 0x0p+0 },
{ INT64_C(0x0000000804000300), 0x1.0080006p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfffcff), -0x1.008000602p+35, 0x0p+0 },
{ INT64_C(0x0000000804002000), 0x1.008004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffdfff), -0x1.008004002p+35, 0x0p+0 },
{ INT64_C(0x0000000804002002), 0x1.008004004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffdffd), -0x1.008004006p+35, 0x0p+0 },
{ INT64_C(0x0000000804002010), 0x1.00800402p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffdfef), -0x1.008004022p+35, 0x0p+0 },
{ INT64_C(0x0000000804002100), 0x1.0080042p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffdeff), -0x1.008004202p+35, 0x0p+0 },
{ INT64_C(0x0000000804002200), 0x1.0080044p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffddff), -0x1.008004402p+35, 0x0p+0 },
{ INT64_C(0x0000000804002400), 0x1.0080048p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffdbff), -0x1.008004802p+35, 0x0p+0 },
{ INT64_C(0x0000000804002800), 0x1.008005p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbffd7ff), -0x1.008005002p+35, 0x0p+0 },
{ INT64_C(0x0000000804020000), 0x1.00804p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfdffff), -0x1.008040002p+35, 0x0p+0 },
{ INT64_C(0x0000000804020002), 0x1.008040004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfdfffd), -0x1.008040006p+35, 0x0p+0 },
{ INT64_C(0x0000000804020020), 0x1.00804004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfdffdf), -0x1.008040042p+35, 0x0p+0 },
{ INT64_C(0x0000000804020200), 0x1.0080404p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfdfdff), -0x1.008040402p+35, 0x0p+0 },
{ INT64_C(0x0000000804020400), 0x1.0080408p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfdfbff), -0x1.008040802p+35, 0x0p+0 },
{ INT64_C(0x0000000804020800), 0x1.008041p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfdf7ff), -0x1.008041002p+35, 0x0p+0 },
{ INT64_C(0x0000000804024000), 0x1.008048p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfdbfff), -0x1.008048002p+35, 0x0p+0 },
{ INT64_C(0x0000000804030000), 0x1.00806p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbfcffff), -0x1.008060002p+35, 0x0p+0 },
{ INT64_C(0x0000000804080000), 0x1.0081p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbf7ffff), -0x1.008100002p+35, 0x0p+0 },
{ INT64_C(0x0000000804080004), 0x1.008100008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbf7fffb), -0x1.00810000ap+35, 0x0p+0 },
{ INT64_C(0x0000000804080008), 0x1.00810001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbf7fff7), -0x1.008100012p+35, 0x0p+0 },
{ INT64_C(0x0000000804080080), 0x1.0081001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbf7ff7f), -0x1.008100102p+35, 0x0p+0 },
{ INT64_C(0x0000000804080800), 0x1.008101p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbf7f7ff), -0x1.008101002p+35, 0x0p+0 },
{ INT64_C(0x0000000804082000), 0x1.008104p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbf7dfff), -0x1.008104002p+35, 0x0p+0 },
{ INT64_C(0x0000000804090000), 0x1.00812p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbf6ffff), -0x1.008120002p+35, 0x0p+0 },
{ INT64_C(0x00000008040c0000), 0x1.00818p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbf3ffff), -0x1.008180002p+35, 0x0p+0 },
{ INT64_C(0x0000000804400000), 0x1.0088p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbbfffff), -0x1.008800002p+35, 0x0p+0 },
{ INT64_C(0x0000000804400004), 0x1.008800008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbbffffb), -0x1.00880000ap+35, 0x0p+0 },
{ INT64_C(0x0000000804400020), 0x1.00880004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbbfffdf), -0x1.008800042p+35, 0x0p+0 },
{ INT64_C(0x0000000804400040), 0x1.00880008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbbfffbf), -0x1.008800082p+35, 0x0p+0 },
{ INT64_C(0x0000000804400080), 0x1.0088001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbbfff7f), -0x1.008800102p+35, 0x0p+0 },
{ INT64_C(0x0000000804400200), 0x1.0088004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbbffdff), -0x1.008800402p+35, 0x0p+0 },
{ INT64_C(0x0000000804401000), 0x1.008802p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbbfefff), -0x1.008802002p+35, 0x0p+0 },
{ INT64_C(0x0000000804408000), 0x1.00881p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbbf7fff), -0x1.008810002p+35, 0x0p+0 },
{ INT64_C(0x0000000804420000), 0x1.00884p+35, 0x0p+0 },
{ INT64_C(0xfffffff7fbbdffff), -0x1.008840002p+35, 0x0p+0 },
{ INT64_C(0x0000000804600000), 0x1.008cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7fb9fffff), -0x1.008c00002p+35, 0x0p+0 },
{ INT64_C(0x0000000806000000), 0x1.00cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7f9ffffff), -0x1.00c000002p+35, 0x0p+0 },
{ INT64_C(0x0000000806000002), 0x1.00c000004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7f9fffffd), -0x1.00c000006p+35, 0x0p+0 },
{ INT64_C(0x0000000806000020), 0x1.00c00004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7f9ffffdf), -0x1.00c000042p+35, 0x0p+0 },
{ INT64_C(0x0000000806000040), 0x1.00c00008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7f9ffffbf), -0x1.00c000082p+35, 0x0p+0 },
{ INT64_C(0x0000000806000200), 0x1.00c0004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7f9fffdff), -0x1.00c000402p+35, 0x0p+0 },
{ INT64_C(0x0000000806002000), 0x1.00c004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7f9ffdfff), -0x1.00c004002p+35, 0x0p+0 },
{ INT64_C(0x0000000806010000), 0x1.00c02p+35, 0x0p+0 },
{ INT64_C(0xfffffff7f9feffff), -0x1.00c020002p+35, 0x0p+0 },
{ INT64_C(0x0000000806100000), 0x1.00c2p+35, 0x0p+0 },
{ INT64_C(0xfffffff7f9efffff), -0x1.00c200002p+35, 0x0p+0 },
{ INT64_C(0x0000000807000000), 0x1.00ep+35, 0x0p+0 },
{ INT64_C(0xfffffff7f8ffffff), -0x1.00e000002p+35, 0x0p+0 },
{ INT64_C(0x0000000840000004), 0x1.080000008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffffffb), -0x1.08000000ap+35, 0x0p+0 },
{ INT64_C(0x0000000840000006), 0x1.08000000cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffffff9), -0x1.08000000ep+35, 0x0p+0 },
{ INT64_C(0x0000000840000020), 0x1.08000004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffffdf), -0x1.080000042p+35, 0x0p+0 },
{ INT64_C(0x0000000840000021), 0x1.080000042p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffffde), -0x1.080000044p+35, 0x0p+0 },
{ INT64_C(0x0000000840000030), 0x1.08000006p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffffcf), -0x1.080000062p+35, 0x0p+0 },
{ INT64_C(0x0000000840000200), 0x1.0800004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffffdff), -0x1.080000402p+35, 0x0p+0 },
{ INT64_C(0x0000000840000201), 0x1.080000402p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffffdfe), -0x1.080000404p+35, 0x0p+0 },
{ INT64_C(0x0000000840000210), 0x1.08000042p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffffdef), -0x1.080000422p+35, 0x0p+0 },
{ INT64_C(0x0000000840000220), 0x1.08000044p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffffddf), -0x1.080000442p+35, 0x0p+0 },
{ INT64_C(0x0000000840000280), 0x1.0800005p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffffd7f), -0x1.080000502p+35, 0x0p+0 },
{ INT64_C(0x0000000840002000), 0x1.080004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffdfff), -0x1.080004002p+35, 0x0p+0 },
{ INT64_C(0x0000000840002002), 0x1.080004004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffdffd), -0x1.080004006p+35, 0x0p+0 },
{ INT64_C(0x0000000840002020), 0x1.08000404p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffdfdf), -0x1.080004042p+35, 0x0p+0 },
{ INT64_C(0x0000000840002100), 0x1.0800042p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffdeff), -0x1.080004202p+35, 0x0p+0 },
{ INT64_C(0x0000000840002800), 0x1.080005p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffd7ff), -0x1.080005002p+35, 0x0p+0 },
{ INT64_C(0x0000000840004000), 0x1.080008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffbfff), -0x1.080008002p+35, 0x0p+0 },
{ INT64_C(0x0000000840004001), 0x1.080008002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffbffe), -0x1.080008004p+35, 0x0p+0 },
{ INT64_C(0x0000000840004008), 0x1.08000801p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffbff7), -0x1.080008012p+35, 0x0p+0 },
{ INT64_C(0x0000000840004020), 0x1.08000804p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffbfdf), -0x1.080008042p+35, 0x0p+0 },
{ INT64_C(0x0000000840004080), 0x1.0800081p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffbf7f), -0x1.080008102p+35, 0x0p+0 },
{ INT64_C(0x0000000840004100), 0x1.0800082p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffbeff), -0x1.080008202p+35, 0x0p+0 },
{ INT64_C(0x0000000840004200), 0x1.0800084p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffbdff), -0x1.080008402p+35, 0x0p+0 },
{ INT64_C(0x0000000840005000), 0x1.08000ap+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfffafff), -0x1.08000a002p+35, 0x0p+0 },
{ INT64_C(0x0000000840040000), 0x1.08008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffbffff), -0x1.080080002p+35, 0x0p+0 },
{ INT64_C(0x0000000840040008), 0x1.08008001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffbfff7), -0x1.080080012p+35, 0x0p+0 },
{ INT64_C(0x0000000840040040), 0x1.08008008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffbffbf), -0x1.080080082p+35, 0x0p+0 },
{ INT64_C(0x0000000840040080), 0x1.0800801p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffbff7f), -0x1.080080102p+35, 0x0p+0 },
{ INT64_C(0x0000000840040800), 0x1.080081p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffbf7ff), -0x1.080081002p+35, 0x0p+0 },
{ INT64_C(0x0000000840048000), 0x1.08009p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffb7fff), -0x1.080090002p+35, 0x0p+0 },
{ INT64_C(0x0000000840050000), 0x1.0800ap+35, 0x0p+0 },
{ INT64_C(0xfffffff7bffaffff), -0x1.0800a0002p+35, 0x0p+0 },
{ INT64_C(0x0000000840060000), 0x1.0800cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7bff9ffff), -0x1.0800c0002p+35, 0x0p+0 },
{ INT64_C(0x0000000840100000), 0x1.0802p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfefffff), -0x1.080200002p+35, 0x0p+0 },
{ INT64_C(0x0000000840100002), 0x1.080200004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfeffffd), -0x1.080200006p+35, 0x0p+0 },
{ INT64_C(0x0000000840100008), 0x1.08020001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfeffff7), -0x1.080200012p+35, 0x0p+0 },
{ INT64_C(0x0000000840100080), 0x1.0802001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfefff7f), -0x1.080200102p+35, 0x0p+0 },
{ INT64_C(0x0000000840100400), 0x1.0802008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfeffbff), -0x1.080200802p+35, 0x0p+0 },
{ INT64_C(0x0000000840101000), 0x1.080202p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfefefff), -0x1.080202002p+35, 0x0p+0 },
{ INT64_C(0x0000000840110000), 0x1.08022p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfeeffff), -0x1.080220002p+35, 0x0p+0 },
{ INT64_C(0x0000000840200000), 0x1.0804p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfdfffff), -0x1.080400002p+35, 0x0p+0 },
{ INT64_C(0x0000000840200001), 0x1.080400002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfdffffe), -0x1.080400004p+35, 0x0p+0 },
{ INT64_C(0x0000000840200002), 0x1.080400004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfdffffd), -0x1.080400006p+35, 0x0p+0 },
{ INT64_C(0x0000000840200008), 0x1.08040001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfdffff7), -0x1.080400012p+35, 0x0p+0 },
{ INT64_C(0x0000000840200010), 0x1.08040002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfdfffef), -0x1.080400022p+35, 0x0p+0 },
{ INT64_C(0x0000000840200020), 0x1.08040004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfdfffdf), -0x1.080400042p+35, 0x0p+0 },
{ INT64_C(0x0000000840200080), 0x1.0804001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfdfff7f), -0x1.080400102p+35, 0x0p+0 },
{ INT64_C(0x0000000840200200), 0x1.0804004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfdffdff), -0x1.080400402p+35, 0x0p+0 },
{ INT64_C(0x0000000840200800), 0x1.080401p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfdff7ff), -0x1.080401002p+35, 0x0p+0 },
{ INT64_C(0x0000000840208000), 0x1.08041p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfdf7fff), -0x1.080410002p+35, 0x0p+0 },
{ INT64_C(0x0000000840210000), 0x1.08042p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfdeffff), -0x1.080420002p+35, 0x0p+0 },
{ INT64_C(0x0000000840280000), 0x1.0805p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bfd7ffff), -0x1.080500002p+35, 0x0p+0 },
{ INT64_C(0x0000000842000000), 0x1.084p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bdffffff), -0x1.084000002p+35, 0x0p+0 },
{ INT64_C(0x0000000842000004), 0x1.084000008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bdfffffb), -0x1.08400000ap+35, 0x0p+0 },
{ INT64_C(0x0000000842000010), 0x1.08400002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bdffffef), -0x1.084000022p+35, 0x0p+0 },
{ INT64_C(0x0000000842000080), 0x1.0840001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bdffff7f), -0x1.084000102p+35, 0x0p+0 },
{ INT64_C(0x0000000842000200), 0x1.0840004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bdfffdff), -0x1.084000402p+35, 0x0p+0 },
{ INT64_C(0x0000000842000800), 0x1.084001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bdfff7ff), -0x1.084001002p+35, 0x0p+0 },
{ INT64_C(0x0000000842002000), 0x1.084004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bdffdfff), -0x1.084004002p+35, 0x0p+0 },
{ INT64_C(0x0000000842010000), 0x1.08402p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bdfeffff), -0x1.084020002p+35, 0x0p+0 },
{ INT64_C(0x0000000842040000), 0x1.08408p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bdfbffff), -0x1.084080002p+35, 0x0p+0 },
{ INT64_C(0x0000000842400000), 0x1.0848p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bdbfffff), -0x1.084800002p+35, 0x0p+0 },
{ INT64_C(0x0000000843000000), 0x1.086p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bcffffff), -0x1.086000002p+35, 0x0p+0 },
{ INT64_C(0x0000000844000000), 0x1.088p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bbffffff), -0x1.088000002p+35, 0x0p+0 },
{ INT64_C(0x0000000844000001), 0x1.088000002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bbfffffe), -0x1.088000004p+35, 0x0p+0 },
{ INT64_C(0x0000000844000002), 0x1.088000004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bbfffffd), -0x1.088000006p+35, 0x0p+0 },
{ INT64_C(0x0000000844000008), 0x1.08800001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bbfffff7), -0x1.088000012p+35, 0x0p+0 },
{ INT64_C(0x0000000844000020), 0x1.08800004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bbffffdf), -0x1.088000042p+35, 0x0p+0 },
{ INT64_C(0x0000000844000200), 0x1.0880004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bbfffdff), -0x1.088000402p+35, 0x0p+0 },
{ INT64_C(0x0000000844000800), 0x1.088001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bbfff7ff), -0x1.088001002p+35, 0x0p+0 },
{ INT64_C(0x0000000844008000), 0x1.08801p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bbff7fff), -0x1.088010002p+35, 0x0p+0 },
{ INT64_C(0x0000000844040000), 0x1.08808p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bbfbffff), -0x1.088080002p+35, 0x0p+0 },
{ INT64_C(0x0000000844080000), 0x1.0881p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bbf7ffff), -0x1.088100002p+35, 0x0p+0 },
{ INT64_C(0x0000000844200000), 0x1.0884p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bbdfffff), -0x1.088400002p+35, 0x0p+0 },
{ INT64_C(0x0000000844400000), 0x1.0888p+35, 0x0p+0 },
{ INT64_C(0xfffffff7bbbfffff), -0x1.088800002p+35, 0x0p+0 },
{ INT64_C(0x0000000846000000), 0x1.08cp+35, 0x0p+0 },
{ INT64_C(0xfffffff7b9ffffff), -0x1.08c000002p+35, 0x0p+0 },
{ INT64_C(0x0000000848000000), 0x1.09p+35, 0x0p+0 },
{ INT64_C(0xfffffff7b7ffffff), -0x1.090000002p+35, 0x0p+0 },
{ INT64_C(0x0000000848000008), 0x1.09000001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7b7fffff7), -0x1.090000012p+35, 0x0p+0 },
{ INT64_C(0x0000000848000080), 0x1.0900001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7b7ffff7f), -0x1.090000102p+35, 0x0p+0 },
{ INT64_C(0x0000000848000800), 0x1.090001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7b7fff7ff), -0x1.090001002p+35, 0x0p+0 },
{ INT64_C(0x0000000848004000), 0x1.090008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7b7ffbfff), -0x1.090008002p+35, 0x0p+0 },
{ INT64_C(0x0000000848010000), 0x1.09002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7b7feffff), -0x1.090020002p+35, 0x0p+0 },
{ INT64_C(0x0000000848100000), 0x1.0902p+35, 0x0p+0 },
{ INT64_C(0xfffffff7b7efffff), -0x1.090200002p+35, 0x0p+0 },
{ INT64_C(0x0000000848800000), 0x1.091p+35, 0x0p+0 },
{ INT64_C(0xfffffff7b77fffff), -0x1.091000002p+35, 0x0p+0 },
{ INT64_C(0x0000000850000000), 0x1.0ap+35, 0x0p+0 },
{ INT64_C(0xfffffff7afffffff), -0x1.0a0000002p+35, 0x0p+0 },
{ INT64_C(0x0000000850000002), 0x1.0a0000004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7affffffd), -0x1.0a0000006p+35, 0x0p+0 },
{ INT64_C(0x0000000850000008), 0x1.0a000001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7affffff7), -0x1.0a0000012p+35, 0x0p+0 },
{ INT64_C(0x0000000850000010), 0x1.0a000002p+35, 0x0p+0 },
{ INT64_C(0xfffffff7afffffef), -0x1.0a0000022p+35, 0x0p+0 },
{ INT64_C(0x0000000850000080), 0x1.0a00001p+35, 0x0p+0 },
{ INT64_C(0xfffffff7afffff7f), -0x1.0a0000102p+35, 0x0p+0 },
{ INT64_C(0x0000000850000200), 0x1.0a00004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7affffdff), -0x1.0a0000402p+35, 0x0p+0 },
{ INT64_C(0x0000000850000400), 0x1.0a00008p+35, 0x0p+0 },
{ INT64_C(0xfffffff7affffbff), -0x1.0a0000802p+35, 0x0p+0 },
{ INT64_C(0x0000000850002000), 0x1.0a0004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7afffdfff), -0x1.0a0004002p+35, 0x0p+0 },
{ INT64_C(0x0000000850020000), 0x1.0a004p+35, 0x0p+0 },
{ INT64_C(0xfffffff7affdffff), -0x1.0a0040002p+35, 0x0p+0 },
{ INT64_C(0x0000000850080000), 0x1.0a01p+35, 0x0p+0 },
{ INT64_C(0xfffffff7aff7ffff), -0x1.0a0100002p+35, 0x0p+0 },
{ INT64_C(0x0000000850400000), 0x1.0a08p+35, 0x0p+0 },
{ INT64_C(0xfffffff7afbfffff), -0x1.0a0800002p+35, 0x0p+0 },
{ INT64_C(0x0000000852000000), 0x1.0a4p+35, 0x0p+0 },
{ INT64_C(0xfffffff7adffffff), -0x1.0a4000002p+35, 0x0p+0 },
{ INT64_C(0x0000000858000000), 0x1.0bp+35, 0x0p+0 },
{ INT64_C(0xfffffff7a7ffffff), -0x1.0b0000002p+35, 0x0p+0 },
{ INT64_C(0x0000000880000002), 0x1.100000004p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffffffd), -0x1.100000006p+35, 0x0p+0 },
{ INT64_C(0x0000000880000008), 0x1.10000001p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffffff7), -0x1.100000012p+35, 0x0p+0 },
{ INT64_C(0x000000088000000c), 0x1.100000018p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffffff3), -0x1.10000001ap+35, 0x0p+0 },
{ INT64_C(0x0000000880000040), 0x1.10000008p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffffbf), -0x1.100000082p+35, 0x0p+0 },
{ INT64_C(0x0000000880000041), 0x1.100000082p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffffbe), -0x1.100000084p+35, 0x0p+0 },
{ INT64_C(0x0000000880000048), 0x1.10000009p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffffb7), -0x1.100000092p+35, 0x0p+0 },
{ INT64_C(0x0000000880000200), 0x1.1000004p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffffdff), -0x1.100000402p+35, 0x0p+0 },
{ INT64_C(0x0000000880000201), 0x1.100000402p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffffdfe), -0x1.100000404p+35, 0x0p+0 },
{ INT64_C(0x0000000880000210), 0x1.10000042p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffffdef), -0x1.100000422p+35, 0x0p+0 },
{ INT64_C(0x0000000880000220), 0x1.10000044p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffffddf), -0x1.100000442p+35, 0x0p+0 },
{ INT64_C(0x0000000880000280), 0x1.1000005p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffffd7f), -0x1.100000502p+35, 0x0p+0 },
{ INT64_C(0x0000000880002000), 0x1.100004p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffdfff), -0x1.100004002p+35, 0x0p+0 },
{ INT64_C(0x0000000880002001), 0x1.100004002p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffdffe), -0x1.100004004p+35, 0x0p+0 },
{ INT64_C(0x0000000880002004), 0x1.100004008p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffdffb), -0x1.10000400ap+35, 0x0p+0 },
{ INT64_C(0x0000000880002008), 0x1.10000401p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffdff7), -0x1.100004012p+35, 0x0p+0 },
{ INT64_C(0x0000000880002040), 0x1.10000408p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffdfbf), -0x1.100004082p+35, 0x0p+0 },
{ INT64_C(0x0000000880002200), 0x1.1000044p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffddff), -0x1.100004402p+35, 0x0p+0 },
{ INT64_C(0x0000000880004000), 0x1.100008p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffbfff), -0x1.100008002p+35, 0x0p+0 },
{ INT64_C(0x0000000880004004), 0x1.100008008p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffbffb), -0x1.10000800ap+35, 0x0p+0 },
{ INT64_C(0x0000000880004010), 0x1.10000802p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffbfef), -0x1.100008022p+35, 0x0p+0 },
{ INT64_C(0x0000000880004020), 0x1.10000804p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffbfdf), -0x1.100008042p+35, 0x0p+0 },
{ INT64_C(0x0000000880004200), 0x1.1000084p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffbdff), -0x1.100008402p+35, 0x0p+0 },
{ INT64_C(0x0000000880005000), 0x1.10000ap+35, 0x0p+0 },
{ INT64_C(0xfffffff77fffafff), -0x1.10000a002p+35, 0x0p+0 },
{ INT64_C(0x0000000880020000), 0x1.10004p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffdffff), -0x1.100040002p+35, 0x0p+0 },
{ INT64_C(0x0000000880020008), 0x1.10004001p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffdfff7), -0x1.100040012p+35, 0x0p+0 },
{ INT64_C(0x0000000880020080), 0x1.1000401p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffdff7f), -0x1.100040102p+35, 0x0p+0 },
{ INT64_C(0x0000000880020400), 0x1.1000408p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffdfbff), -0x1.100040802p+35, 0x0p+0 },
{ INT64_C(0x0000000880022000), 0x1.100044p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ffddfff), -0x1.100044002p+35, 0x0p+0 },
{ INT64_C(0x0000000880080000), 0x1.1001p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ff7ffff), -0x1.100100002p+35, 0x0p+0 },
{ INT64_C(0x0000000880080008), 0x1.10010001p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ff7fff7), -0x1.100100012p+35, 0x0p+0 },
{ INT64_C(0x0000000880080080), 0x1.1001001p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ff7ff7f), -0x1.100100102p+35, 0x0p+0 },
{ INT64_C(0x0000000880080400), 0x1.1001008p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ff7fbff), -0x1.100100802p+35, 0x0p+0 },
{ INT64_C(0x0000000880084000), 0x1.100108p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ff7bfff), -0x1.100108002p+35, 0x0p+0 },
{ INT64_C(0x0000000880088000), 0x1.10011p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ff77fff), -0x1.100110002p+35, 0x0p+0 },
{ INT64_C(0x0000000880090000), 0x1.10012p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ff6ffff), -0x1.100120002p+35, 0x0p+0 },
{ INT64_C(0x00000008800a0000), 0x1.10014p+35, 0x0p+0 },
{ INT64_C(0xfffffff77ff5ffff), -0x1.100140002p+35, 0x0p+0 },
{ INT64_C(0x0000000880200000), 0x1.1004p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fdfffff), -0x1.100400002p+35, 0x0p+0 },
{ INT64_C(0x0000000880200001), 0x1.100400002p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fdffffe), -0x1.100400004p+35, 0x0p+0 },
{ INT64_C(0x0000000880200004), 0x1.100400008p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fdffffb), -0x1.10040000ap+35, 0x0p+0 },
{ INT64_C(0x0000000880200008), 0x1.10040001p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fdffff7), -0x1.100400012p+35, 0x0p+0 },
{ INT64_C(0x0000000880200020), 0x1.10040004p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fdfffdf), -0x1.100400042p+35, 0x0p+0 },
{ INT64_C(0x0000000880200040), 0x1.10040008p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fdfffbf), -0x1.100400082p+35, 0x0p+0 },
{ INT64_C(0x0000000880200080), 0x1.1004001p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fdfff7f), -0x1.100400102p+35, 0x0p+0 },
{ INT64_C(0x0000000880200200), 0x1.1004004p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fdffdff), -0x1.100400402p+35, 0x0p+0 },
{ INT64_C(0x0000000880200800), 0x1.100401p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fdff7ff), -0x1.100401002p+35, 0x0p+0 },
{ INT64_C(0x0000000880208000), 0x1.10041p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fdf7fff), -0x1.100410002p+35, 0x0p+0 },
{ INT64_C(0x0000000880240000), 0x1.10048p+35, 0x0p+0 },
{ INT64_C(0xfffffff77fdbffff), -0x1.100480002p+35, 0x0p+0 },
{ INT64_C(0x0000000881000000), 0x1.102p+35, 0x0p+0 },
{ INT64_C(0xfffffff77effffff), -0x1.102000002p+35, 0x0p+0 },
{ INT64_C(0x0000000881000004), 0x1.102000008p+35, 0x0p+0 },
{ INT64_C(0xfffffff77efffffb), -0x1.10200000ap+35, 0x0p+0 },
{ INT64_C(0x0000000881000008), 0x1.10200001p+35, 0x0p+0 },
{ INT64_C(0xfffffff77efffff7), -0x1.102000012p+35, 0x0p+0 },
{ INT64_C(0x0000000881000080), 0x1.1020001p+35, 0x0p+0 },
{ INT64_C(0xfffffff77effff7f), -0x1.102000102p+35, 0x0p+0 },
{ INT64_C(0x0000000881000200), 0x1.1020004p+35, 0x0p+0 },
{ INT64_C(0xfffffff77efffdff), -0x1.102000402p+35, 0x0p+0 },
{ INT64_C(0x0000000881000800), 0x1.102001p+35, 0x0p+0 },
{ INT64_C(0xfffffff77efff7ff), -0x1.102001002p+35, 0x0p+0 },
{ INT64_C(0x0000000881001000), 0x1.102002p+35, 0x0p+0 },
{ INT64_C(0xfffffff77effefff), -0x1.102002002p+35, 0x0p+0 },
{ INT64_C(0x0000000881010000), 0x1.10202p+35, 0x0p+0 },
{ INT64_C(0xfffffff77efeffff), -0x1.102020002p+35, 0x0p+0 },
{ INT64_C(0x0000000881020000), 0x1.10204p+35, 0x0p+0 },
{ INT64_C(0xfffffff77efdffff), -0x1.102040002p+35, 0x0p+0 },
{ INT64_C(0x0000000881100000), 0x1.1022p+35, 0x0p+0 },
{ INT64_C(0xfffffff77eefffff), -0x1.102200002p+35, 0x0p+0 },
{ INT64_C(0x0000000881200000), 0x1.1024p+35, 0x0p+0 },
{ INT64_C(0xfffffff77edfffff), -0x1.102400002p+35, 0x0p+0 },
{ INT64_C(0x0000000881800000), 0x1.103p+35, 0x0p+0 },
{ INT64_C(0xfffffff77e7fffff), -0x1.103000002p+35, 0x0p+0 },
{ INT64_C(0x0000000884000000), 0x1.108p+35, 0x0p+0 },
{ INT64_C(0xfffffff77bffffff), -0x1.108000002p+35, 0x0p+0 },
{ INT64_C(0x0000000884000008), 0x1.10800001p+35, 0x0p+0 },
{ INT64_C(0xfffffff77bfffff7), -0x1.108000012p+35, 0x0p+0 },
{ INT64_C(0x0000000884000010), 0x1.10800002p+35, 0x0p+0 },
{ INT64_C(0xfffffff77bffffef), -0x1.108000022p+35, 0x0p+0 },
{ INT64_C(0x0000000884000080), 0x1.1080001p+35, 0x0p+0 },
{ INT64_C(0xfffffff77bffff7f), -0x1.108000102p+35, 0x0p+0 },
{ INT64_C(0x0000000884000400), 0x1.1080008p+35, 0x0p+0 },
{ INT64_C(0xfffffff77bfffbff), -0x1.108000802p+35, 0x0p+0 },
{ INT64_C(0x0000000884001000), 0x1.108002p+35, 0x0p+0 },
{ INT64_C(0xfffffff77bffefff), -0x1.108002002p+35, 0x0p+0 },
{ INT64_C(0x0000000884010000), 0x1.10802p+35, 0x0p+0 },
{ INT64_C(0xfffffff77bfeffff), -0x1.108020002p+35, 0x0p+0 },
{ INT64_C(0x0000000884100000), 0x1.1082p+35, 0x0p+0 },
{ INT64_C(0xfffffff77befffff), -0x1.108200002p+35, 0x0p+0 },
{ INT64_C(0x0000000884800000), 0x1.109p+35, 0x0p+0 },
{ INT64_C(0xfffffff77b7fffff), -0x1.109000002p+35, 0x0p+0 },
{ INT64_C(0x0000000888000000), 0x1.11p+35, 0x0p+0 },
{ INT64_C(0xfffffff777ffffff), -0x1.110000002p+35, 0x0p+0 },
{ INT64_C(0x0000000888000008), 0x1.11000001p+35, 0x0p+0 },
{ INT64_C(0xfffffff777fffff7), -0x1.110000012p+35, 0x0p+0 },
{ INT64_C(0x0000000888000080), 0x1.1100001p+35, 0x0p+0 },
{ INT64_C(0xfffffff777ffff7f), -0x1.110000102p+35, 0x0p+0 },
{ INT64_C(0x0000000888000400), 0x1.1100008p+35, 0x0p+0 },
{ INT64_C(0xfffffff777fffbff), -0x1.110000802p+35, 0x0p+0 },
{ INT64_C(0x0000000888004000), 0x1.110008p+35, 0x0p+0 },
{ INT64_C(0xfffffff777ffbfff), -0x1.110008002p+35, 0x0p+0 },
{ INT64_C(0x0000000888010000), 0x1.11002p+35, 0x0p+0 },
{ INT64_C(0xfffffff777feffff), -0x1.110020002p+35, 0x0p+0 },
{ INT64_C(0x0000000888100000), 0x1.1102p+35, 0x0p+0 },
{ INT64_C(0xfffffff777efffff), -0x1.110200002p+35, 0x0p+0 },
{ INT64_C(0x0000000888200000), 0x1.1104p+35, 0x0p+0 },
{ INT64_C(0xfffffff777dfffff), -0x1.110400002p+35, 0x0p+0 },
{ INT64_C(0x0000000888400000), 0x1.1108p+35, 0x0p+0 },
{ INT64_C(0xfffffff777bfffff), -0x1.110800002p+35, 0x0p+0 },
{ INT64_C(0x0000000889000000), 0x1.112p+35, 0x0p+0 },
{ INT64_C(0xfffffff776ffffff), -0x1.112000002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00000004), 0x1.400000008p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffffffb), -0x1.40000000ap+35, 0x0p+0 },
{ INT64_C(0x0000000a00000020), 0x1.40000004p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffffdf), -0x1.400000042p+35, 0x0p+0 },
{ INT64_C(0x0000000a00000021), 0x1.400000042p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffffde), -0x1.400000044p+35, 0x0p+0 },
{ INT64_C(0x0000000a00000024), 0x1.400000048p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffffdb), -0x1.40000004ap+35, 0x0p+0 },
{ INT64_C(0x0000000a00000028), 0x1.40000005p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffffd7), -0x1.400000052p+35, 0x0p+0 },
{ INT64_C(0x0000000a00000100), 0x1.4000002p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffffeff), -0x1.400000202p+35, 0x0p+0 },
{ INT64_C(0x0000000a00000108), 0x1.40000021p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffffef7), -0x1.400000212p+35, 0x0p+0 },
{ INT64_C(0x0000000a00000140), 0x1.40000028p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffffebf), -0x1.400000282p+35, 0x0p+0 },
{ INT64_C(0x0000000a00001000), 0x1.400002p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffefff), -0x1.400002002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00001004), 0x1.400002008p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffeffb), -0x1.40000200ap+35, 0x0p+0 },
{ INT64_C(0x0000000a00001008), 0x1.40000201p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffeff7), -0x1.400002012p+35, 0x0p+0 },
{ INT64_C(0x0000000a00001010), 0x1.40000202p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffefef), -0x1.400002022p+35, 0x0p+0 },
{ INT64_C(0x0000000a00001080), 0x1.4000021p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffef7f), -0x1.400002102p+35, 0x0p+0 },
{ INT64_C(0x0000000a00001200), 0x1.4000024p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffedff), -0x1.400002402p+35, 0x0p+0 },
{ INT64_C(0x0000000a00002000), 0x1.400004p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffdfff), -0x1.400004002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00002004), 0x1.400004008p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffdffb), -0x1.40000400ap+35, 0x0p+0 },
{ INT64_C(0x0000000a00002040), 0x1.40000408p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffdfbf), -0x1.400004082p+35, 0x0p+0 },
{ INT64_C(0x0000000a00002080), 0x1.4000041p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffdf7f), -0x1.400004102p+35, 0x0p+0 },
{ INT64_C(0x0000000a00002400), 0x1.4000048p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffffdbff), -0x1.400004802p+35, 0x0p+0 },
{ INT64_C(0x0000000a00010000), 0x1.40002p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffeffff), -0x1.400020002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00010004), 0x1.400020008p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffefffb), -0x1.40002000ap+35, 0x0p+0 },
{ INT64_C(0x0000000a00010020), 0x1.40002004p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffeffdf), -0x1.400020042p+35, 0x0p+0 },
{ INT64_C(0x0000000a00010100), 0x1.4000202p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffefeff), -0x1.400020202p+35, 0x0p+0 },
{ INT64_C(0x0000000a00010800), 0x1.400021p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffef7ff), -0x1.400021002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00018000), 0x1.40003p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffe7fff), -0x1.400030002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00040000), 0x1.40008p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffbffff), -0x1.400080002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00040004), 0x1.400080008p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffbfffb), -0x1.40008000ap+35, 0x0p+0 },
{ INT64_C(0x0000000a00040040), 0x1.40008008p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffbffbf), -0x1.400080082p+35, 0x0p+0 },
{ INT64_C(0x0000000a00040200), 0x1.4000804p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffbfdff), -0x1.400080402p+35, 0x0p+0 },
{ INT64_C(0x0000000a00040400), 0x1.4000808p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffbfbff), -0x1.400080802p+35, 0x0p+0 },
{ INT64_C(0x0000000a00042000), 0x1.400084p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffbdfff), -0x1.400084002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00044000), 0x1.400088p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fffbbfff), -0x1.400088002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00060000), 0x1.4000cp+35, 0x0p+0 },
{ INT64_C(0xfffffff5fff9ffff), -0x1.4000c0002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00400000), 0x1.4008p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffbfffff), -0x1.400800002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00400001), 0x1.400800002p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffbffffe), -0x1.400800004p+35, 0x0p+0 },
{ INT64_C(0x0000000a00400010), 0x1.40080002p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffbfffef), -0x1.400800022p+35, 0x0p+0 },
{ INT64_C(0x0000000a00400080), 0x1.4008001p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffbfff7f), -0x1.400800102p+35, 0x0p+0 },
{ INT64_C(0x0000000a00400800), 0x1.400801p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffbff7ff), -0x1.400801002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00401000), 0x1.400802p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffbfefff), -0x1.400802002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00410000), 0x1.40082p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffbeffff), -0x1.400820002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00480000), 0x1.4009p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ffb7ffff), -0x1.400900002p+35, 0x0p+0 },
{ INT64_C(0x0000000a00600000), 0x1.400cp+35, 0x0p+0 },
{ INT64_C(0xfffffff5ff9fffff), -0x1.400c00002p+35, 0x0p+0 },
{ INT64_C(0x0000000a01000000), 0x1.402p+35, 0x0p+0 },
{ INT64_C(0xfffffff5feffffff), -0x1.402000002p+35, 0x0p+0 },
{ INT64_C(0x0000000a01000008), 0x1.40200001p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fefffff7), -0x1.402000012p+35, 0x0p+0 },
{ INT64_C(0x0000000a01000080), 0x1.4020001p+35, 0x0p+0 },
{ INT64_C(0xfffffff5feffff7f), -0x1.402000102p+35, 0x0p+0 },
{ INT64_C(0x0000000a01000800), 0x1.402001p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fefff7ff), -0x1.402001002p+35, 0x0p+0 },
{ INT64_C(0x0000000a01001000), 0x1.402002p+35, 0x0p+0 },
{ INT64_C(0xfffffff5feffefff), -0x1.402002002p+35, 0x0p+0 },
{ INT64_C(0x0000000a01010000), 0x1.40202p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fefeffff), -0x1.402020002p+35, 0x0p+0 },
{ INT64_C(0x0000000a01080000), 0x1.4021p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fef7ffff), -0x1.402100002p+35, 0x0p+0 },
{ INT64_C(0x0000000a01800000), 0x1.403p+35, 0x0p+0 },
{ INT64_C(0xfffffff5fe7fffff), -0x1.403000002p+35, 0x0p+0 },
{ INT64_C(0x0000000a10000000), 0x1.42p+35, 0x0p+0 },
{ INT64_C(0xfffffff5efffffff), -0x1.420000002p+35, 0x0p+0 },
{ INT64_C(0x0000000a10000002), 0x1.420000004p+35, 0x0p+0 },
{ INT64_C(0xfffffff5effffffd), -0x1.420000006p+35, 0x0p+0 },
{ INT64_C(0x0000000a10000020), 0x1.42000004p+35, 0x0p+0 },
{ INT64_C(0xfffffff5efffffdf), -0x1.420000042p+35, 0x0p+0 },
{ INT64_C(0x0000000a10000080), 0x1.4200001p+35, 0x0p+0 },
{ INT64_C(0xfffffff5efffff7f), -0x1.420000102p+35, 0x0p+0 },
{ INT64_C(0x0000000a10000400), 0x1.4200008p+35, 0x0p+0 },
{ INT64_C(0xfffffff5effffbff), -0x1.420000802p+35, 0x0p+0 },
{ INT64_C(0x0000000a10002000), 0x1.420004p+35, 0x0p+0 },
{ INT64_C(0xfffffff5efffdfff), -0x1.420004002p+35, 0x0p+0 },
{ INT64_C(0x0000000a10020000), 0x1.42004p+35, 0x0p+0 },
{ INT64_C(0xfffffff5effdffff), -0x1.420040002p+35, 0x0p+0 },
{ INT64_C(0x0000000a10040000), 0x1.42008p+35, 0x0p+0 },
{ INT64_C(0xfffffff5effbffff), -0x1.420080002p+35, 0x0p+0 },
{ INT64_C(0x0000000a10100000), 0x1.4202p+35, 0x0p+0 },
{ INT64_C(0xfffffff5efefffff), -0x1.420200002p+35, 0x0p+0 },
{ INT64_C(0x0000000a11000000), 0x1.422p+35, 0x0p+0 },
{ INT64_C(0xfffffff5eeffffff), -0x1.422000002p+35, 0x0p+0 },
{ INT64_C(0x0000000a14000000), 0x1.428p+35, 0x0p+0 },
{ INT64_C(0xfffffff5ebffffff), -0x1.428000002p+35, 0x0p+0 },
{ INT64_C(0x0000000b00000000), 0x1.6p+35, 0x0p+0 },
{ INT64_C(0xfffffff4ffffffff), -0x1.600000002p+35, 0x0p+0 },
{ INT64_C(0x0000000b00000004), 0x1.600000008p+35, 0x0p+0 },
{ INT64_C(0xfffffff4fffffffb), -0x1.60000000ap+35, 0x0p+0 },
{ INT64_C(0x0000000b00000008), 0x1.60000001p+35, 0x0p+0 },
{ INT64_C(0xfffffff4fffffff7), -0x1.600000012p+35, 0x0p+0 },
{ INT64_C(0x0000000b00000020), 0x1.60000004p+35, 0x0p+0 },
{ INT64_C(0xfffffff4ffffffdf), -0x1.600000042p+35, 0x0p+0 },
{ INT64_C(0x0000000b00000100), 0x1.6000002p+35, 0x0p+0 },
{ INT64_C(0xfffffff4fffffeff), -0x1.600000202p+35, 0x0p+0 },
{ INT64_C(0x0000000b00000400), 0x1.6000008p+35, 0x0p+0 },
{ INT64_C(0xfffffff4fffffbff), -0x1.600000802p+35, 0x0p+0 },
{ INT64_C(0x0000000b00001000), 0x1.600002p+35, 0x0p+0 },
{ INT64_C(0xfffffff4ffffefff), -0x1.600002002p+35, 0x0p+0 },
{ INT64_C(0x0000000b00002000), 0x1.600004p+35, 0x0p+0 },
{ INT64_C(0xfffffff4ffffdfff), -0x1.600004002p+35, 0x0p+0 },
{ INT64_C(0x0000000b00020000), 0x1.60004p+35, 0x0p+0 },
{ INT64_C(0xfffffff4fffdffff), -0x1.600040002p+35, 0x0p+0 },
{ INT64_C(0x0000000b00200000), 0x1.6004p+35, 0x0p+0 },
{ INT64_C(0xfffffff4ffdfffff), -0x1.600400002p+35, 0x0p+0 },
{ INT64_C(0x0000000b01000000), 0x1.602p+35, 0x0p+0 },
{ INT64_C(0xfffffff4feffffff), -0x1.602000002p+35, 0x0p+0 },
{ INT64_C(0x0000000b08000000), 0x1.61p+35, 0x0p+0 },
{ INT64_C(0xfffffff4f7ffffff), -0x1.610000002p+35, 0x0p+0 },
{ INT64_C(0x0000000b20000000), 0x1.64p+35, 0x0p+0 },
{ INT64_C(0xfffffff4dfffffff), -0x1.640000002p+35, 0x0p+0 },
{ INT64_C(0x000000200000000c), 0x1.000000006p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffff3), -0x1.0000000068p+37, 0x0p+0 },
{ INT64_C(0x0000002000000044), 0x1.000000022p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffffbb), -0x1.0000000228p+37, 0x0p+0 },
{ INT64_C(0x0000002000000060), 0x1.00000003p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffff9f), -0x1.0000000308p+37, 0x0p+0 },
{ INT64_C(0x0000002000000064), 0x1.000000032p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffff9b), -0x1.0000000328p+37, 0x0p+0 },
{ INT64_C(0x0000002000000408), 0x1.000000204p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffbf7), -0x1.0000002048p+37, 0x0p+0 },
{ INT64_C(0x000000200000040a), 0x1.000000205p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffbf5), -0x1.0000002058p+37, 0x0p+0 },
{ INT64_C(0x000000200000040c), 0x1.000000206p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffbf3), -0x1.0000002068p+37, 0x0p+0 },
{ INT64_C(0x0000002000000410), 0x1.000000208p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffbef), -0x1.0000002088p+37, 0x0p+0 },
{ INT64_C(0x0000002000000411), 0x1.0000002088p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffbee), -0x1.000000209p+37, 0x0p+0 },
{ INT64_C(0x0000002000000440), 0x1.00000022p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffbbf), -0x1.0000002208p+37, 0x0p+0 },
{ INT64_C(0x0000002000000442), 0x1.000000221p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffbbd), -0x1.0000002218p+37, 0x0p+0 },
{ INT64_C(0x0000002000000448), 0x1.000000224p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffbb7), -0x1.0000002248p+37, 0x0p+0 },
{ INT64_C(0x0000002000000480), 0x1.00000024p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffb7f), -0x1.0000002408p+37, 0x0p+0 },
{ INT64_C(0x0000002000000488), 0x1.000000244p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffb77), -0x1.0000002448p+37, 0x0p+0 },
{ INT64_C(0x00000020000004a0), 0x1.00000025p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffb5f), -0x1.0000002508p+37, 0x0p+0 },
{ INT64_C(0x0000002000000500), 0x1.00000028p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffaff), -0x1.0000002808p+37, 0x0p+0 },
{ INT64_C(0x0000002000000508), 0x1.000000284p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffaf7), -0x1.0000002848p+37, 0x0p+0 },
{ INT64_C(0x0000002000000510), 0x1.000000288p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffffaef), -0x1.0000002888p+37, 0x0p+0 },
{ INT64_C(0x0000002000001001), 0x1.0000008008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffeffe), -0x1.000000801p+37, 0x0p+0 },
{ INT64_C(0x0000002000001002), 0x1.000000801p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffeffd), -0x1.0000008018p+37, 0x0p+0 },
{ INT64_C(0x0000002000001003), 0x1.0000008018p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffeffc), -0x1.000000802p+37, 0x0p+0 },
{ INT64_C(0x0000002000001004), 0x1.000000802p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffeffb), -0x1.0000008028p+37, 0x0p+0 },
{ INT64_C(0x0000002000001040), 0x1.00000082p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffefbf), -0x1.0000008208p+37, 0x0p+0 },
{ INT64_C(0x0000002000001042), 0x1.000000821p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffefbd), -0x1.0000008218p+37, 0x0p+0 },
{ INT64_C(0x0000002000001044), 0x1.000000822p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffefbb), -0x1.0000008228p+37, 0x0p+0 },
{ INT64_C(0x0000002000001050), 0x1.000000828p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffefaf), -0x1.0000008288p+37, 0x0p+0 },
{ INT64_C(0x0000002000001060), 0x1.00000083p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffef9f), -0x1.0000008308p+37, 0x0p+0 },
{ INT64_C(0x0000002000001200), 0x1.0000009p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffedff), -0x1.0000009008p+37, 0x0p+0 },
{ INT64_C(0x0000002000001208), 0x1.000000904p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffedf7), -0x1.0000009048p+37, 0x0p+0 },
{ INT64_C(0x0000002000001220), 0x1.00000091p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffeddf), -0x1.0000009108p+37, 0x0p+0 },
{ INT64_C(0x0000002000001300), 0x1.00000098p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffecff), -0x1.0000009808p+37, 0x0p+0 },
{ INT64_C(0x0000002000001800), 0x1.000000cp+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffe7ff), -0x1.000000c008p+37, 0x0p+0 },
{ INT64_C(0x0000002000001802), 0x1.000000c01p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffe7fd), -0x1.000000c018p+37, 0x0p+0 },
{ INT64_C(0x0000002000001804), 0x1.000000c02p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffe7fb), -0x1.000000c028p+37, 0x0p+0 },
{ INT64_C(0x0000002000001810), 0x1.000000c08p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffe7ef), -0x1.000000c088p+37, 0x0p+0 },
{ INT64_C(0x0000002000001820), 0x1.000000c1p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffe7df), -0x1.000000c108p+37, 0x0p+0 },
{ INT64_C(0x0000002000001880), 0x1.000000c4p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffffe77f), -0x1.000000c408p+37, 0x0p+0 },
{ INT64_C(0x0000002000008004), 0x1.000004002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffff7ffb), -0x1.0000040028p+37, 0x0p+0 },
{ INT64_C(0x0000002000008020), 0x1.00000401p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffff7fdf), -0x1.0000040108p+37, 0x0p+0 },
{ INT64_C(0x0000002000008028), 0x1.000004014p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffff7fd7), -0x1.0000040148p+37, 0x0p+0 },
{ INT64_C(0x0000002000008100), 0x1.00000408p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffff7eff), -0x1.0000040808p+37, 0x0p+0 },
{ INT64_C(0x0000002000008108), 0x1.000004084p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffff7ef7), -0x1.0000040848p+37, 0x0p+0 },
{ INT64_C(0x0000002000008180), 0x1.0000040cp+37, 0x0p+0 },
{ INT64_C(0xffffffdfffff7e7f), -0x1.0000040c08p+37, 0x0p+0 },
{ INT64_C(0x0000002000009000), 0x1.0000048p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffff6fff), -0x1.0000048008p+37, 0x0p+0 },
{ INT64_C(0x0000002000009001), 0x1.0000048008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffff6ffe), -0x1.000004801p+37, 0x0p+0 },
{ INT64_C(0x0000002000009002), 0x1.000004801p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffff6ffd), -0x1.0000048018p+37, 0x0p+0 },
{ INT64_C(0x0000002000009008), 0x1.000004804p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffff6ff7), -0x1.0000048048p+37, 0x0p+0 },
{ INT64_C(0x0000002000009020), 0x1.00000481p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffff6fdf), -0x1.0000048108p+37, 0x0p+0 },
{ INT64_C(0x0000002000009200), 0x1.0000049p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffff6dff), -0x1.0000049008p+37, 0x0p+0 },
{ INT64_C(0x0000002000020001), 0x1.0000100008p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdfffe), -0x1.000010001p+37, 0x0p+0 },
{ INT64_C(0x0000002000020002), 0x1.000010001p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdfffd), -0x1.0000100018p+37, 0x0p+0 },
{ INT64_C(0x0000002000020008), 0x1.000010004p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdfff7), -0x1.0000100048p+37, 0x0p+0 },
{ INT64_C(0x000000200002000c), 0x1.000010006p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdfff3), -0x1.0000100068p+37, 0x0p+0 },
{ INT64_C(0x0000002000020040), 0x1.00001002p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdffbf), -0x1.0000100208p+37, 0x0p+0 },
{ INT64_C(0x0000002000020044), 0x1.000010022p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdffbb), -0x1.0000100228p+37, 0x0p+0 },
{ INT64_C(0x0000002000020050), 0x1.000010028p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdffaf), -0x1.0000100288p+37, 0x0p+0 },
{ INT64_C(0x0000002000020080), 0x1.00001004p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdff7f), -0x1.0000100408p+37, 0x0p+0 },
{ INT64_C(0x0000002000020081), 0x1.0000100408p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdff7e), -0x1.000010041p+37, 0x0p+0 },
{ INT64_C(0x0000002000020084), 0x1.000010042p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdff7b), -0x1.0000100428p+37, 0x0p+0 },
{ INT64_C(0x00000020000200a0), 0x1.00001005p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdff5f), -0x1.0000100508p+37, 0x0p+0 },
{ INT64_C(0x0000002000020100), 0x1.00001008p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdfeff), -0x1.0000100808p+37, 0x0p+0 },
{ INT64_C(0x0000002000020102), 0x1.000010081p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdfefd), -0x1.0000100818p+37, 0x0p+0 },
{ INT64_C(0x0000002000020120), 0x1.00001009p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdfedf), -0x1.0000100908p+37, 0x0p+0 },
{ INT64_C(0x0000002000020180), 0x1.0000100cp+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdfe7f), -0x1.0000100c08p+37, 0x0p+0 },
{ INT64_C(0x0000002000020800), 0x1.0000104p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdf7ff), -0x1.0000104008p+37, 0x0p+0 },
{ INT64_C(0x0000002000020808), 0x1.000010404p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdf7f7), -0x1.0000104048p+37, 0x0p+0 },
{ INT64_C(0x0000002000020810), 0x1.000010408p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdf7ef), -0x1.0000104088p+37, 0x0p+0 },
{ INT64_C(0x0000002000020820), 0x1.00001041p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdf7df), -0x1.0000104108p+37, 0x0p+0 },
{ INT64_C(0x0000002000020880), 0x1.00001044p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdf77f), -0x1.0000104408p+37, 0x0p+0 },
{ INT64_C(0x0000002000020900), 0x1.00001048p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdf6ff), -0x1.0000104808p+37, 0x0p+0 },
{ INT64_C(0x0000002000024000), 0x1.000012p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdbfff), -0x1.0000120008p+37, 0x0p+0 },
{ INT64_C(0x0000002000024008), 0x1.000012004p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdbff7), -0x1.0000120048p+37, 0x0p+0 },
{ INT64_C(0x0000002000024020), 0x1.00001201p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdbfdf), -0x1.0000120108p+37, 0x0p+0 },
{ INT64_C(0x0000002000024040), 0x1.00001202p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdbfbf), -0x1.0000120208p+37, 0x0p+0 },
{ INT64_C(0x0000002000024080), 0x1.00001204p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdbf7f), -0x1.0000120408p+37, 0x0p+0 },
{ INT64_C(0x0000002000024800), 0x1.0000124p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffdb7ff), -0x1.0000124008p+37, 0x0p+0 },
{ INT64_C(0x0000002000026000), 0x1.000013p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffd9fff), -0x1.0000130008p+37, 0x0p+0 },
{ INT64_C(0x0000002000028000), 0x1.000014p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffd7fff), -0x1.0000140008p+37, 0x0p+0 },
{ INT64_C(0x0000002000028004), 0x1.000014002p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffd7ffb), -0x1.0000140028p+37, 0x0p+0 },
{ INT64_C(0x0000002000028040), 0x1.00001402p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffd7fbf), -0x1.0000140208p+37, 0x0p+0 },
{ INT64_C(0x0000002000028400), 0x1.0000142p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffd7bff), -0x1.0000142008p+37, 0x0p+0 },
{ INT64_C(0x000000200002c000), 0x1.000016p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffd3fff), -0x1.0000160008p+37, 0x0p+0 },
{ INT64_C(0x0000002000030000), 0x1.000018p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffcffff), -0x1.0000180008p+37, 0x0p+0 },
{ INT64_C(0x0000002000030008), 0x1.000018004p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffcfff7), -0x1.0000180048p+37, 0x0p+0 },
{ INT64_C(0x0000002000030010), 0x1.000018008p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffcffef), -0x1.0000180088p+37, 0x0p+0 },
{ INT64_C(0x0000002000030040), 0x1.00001802p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffcffbf), -0x1.0000180208p+37, 0x0p+0 },
{ INT64_C(0x0000002000030200), 0x1.0000181p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffcfdff), -0x1.0000181008p+37, 0x0p+0 },
{ INT64_C(0x0000002000031000), 0x1.0000188p+37, 0x0p+0 },
{ INT64_C(0xffffffdffffcefff), -0x1.0000188008p+37, 0x0p+0 },
{ INT64_C(0x0000002000034000), 0x1.00001ap+37, 0x0p+0 },
{ INT64_C(0xffffffdffffcbfff), -0x1.00001a0008p+37, 0x0p+0 },
{ INT64_C(0x0000002000200002), 0x1.000100001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdffffd), -0x1.0001000018p+37, 0x0p+0 },
{ INT64_C(0x0000002000200010), 0x1.000100008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfffef), -0x1.0001000088p+37, 0x0p+0 },
{ INT64_C(0x0000002000200011), 0x1.0001000088p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfffee), -0x1.000100009p+37, 0x0p+0 },
{ INT64_C(0x0000002000200012), 0x1.000100009p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfffed), -0x1.0001000098p+37, 0x0p+0 },
{ INT64_C(0x0000002000200100), 0x1.00010008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdffeff), -0x1.0001000808p+37, 0x0p+0 },
{ INT64_C(0x0000002000200108), 0x1.000100084p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdffef7), -0x1.0001000848p+37, 0x0p+0 },
{ INT64_C(0x0000002000200120), 0x1.00010009p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdffedf), -0x1.0001000908p+37, 0x0p+0 },
{ INT64_C(0x0000002000200180), 0x1.0001000cp+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdffe7f), -0x1.0001000c08p+37, 0x0p+0 },
{ INT64_C(0x0000002000200200), 0x1.0001001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdffdff), -0x1.0001001008p+37, 0x0p+0 },
{ INT64_C(0x0000002000200204), 0x1.000100102p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdffdfb), -0x1.0001001028p+37, 0x0p+0 },
{ INT64_C(0x0000002000200240), 0x1.00010012p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdffdbf), -0x1.0001001208p+37, 0x0p+0 },
{ INT64_C(0x0000002000201000), 0x1.0001008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfefff), -0x1.0001008008p+37, 0x0p+0 },
{ INT64_C(0x0000002000201001), 0x1.0001008008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfeffe), -0x1.000100801p+37, 0x0p+0 },
{ INT64_C(0x0000002000201002), 0x1.000100801p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfeffd), -0x1.0001008018p+37, 0x0p+0 },
{ INT64_C(0x0000002000201010), 0x1.000100808p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfefef), -0x1.0001008088p+37, 0x0p+0 },
{ INT64_C(0x0000002000201040), 0x1.00010082p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfefbf), -0x1.0001008208p+37, 0x0p+0 },
{ INT64_C(0x0000002000201400), 0x1.000100ap+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfebff), -0x1.000100a008p+37, 0x0p+0 },
{ INT64_C(0x0000002000204000), 0x1.000102p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfbfff), -0x1.0001020008p+37, 0x0p+0 },
{ INT64_C(0x0000002000204002), 0x1.000102001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfbffd), -0x1.0001020018p+37, 0x0p+0 },
{ INT64_C(0x0000002000204010), 0x1.000102008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfbfef), -0x1.0001020088p+37, 0x0p+0 },
{ INT64_C(0x0000002000204080), 0x1.00010204p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfbf7f), -0x1.0001020408p+37, 0x0p+0 },
{ INT64_C(0x0000002000204200), 0x1.0001021p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfbdff), -0x1.0001021008p+37, 0x0p+0 },
{ INT64_C(0x0000002000204800), 0x1.0001024p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdfb7ff), -0x1.0001024008p+37, 0x0p+0 },
{ INT64_C(0x0000002000206000), 0x1.000103p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdf9fff), -0x1.0001030008p+37, 0x0p+0 },
{ INT64_C(0x0000002000240000), 0x1.00012p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdbffff), -0x1.0001200008p+37, 0x0p+0 },
{ INT64_C(0x0000002000240008), 0x1.000120004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdbfff7), -0x1.0001200048p+37, 0x0p+0 },
{ INT64_C(0x0000002000240020), 0x1.00012001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdbffdf), -0x1.0001200108p+37, 0x0p+0 },
{ INT64_C(0x0000002000240200), 0x1.0001201p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdbfdff), -0x1.0001201008p+37, 0x0p+0 },
{ INT64_C(0x0000002000240800), 0x1.0001204p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdbf7ff), -0x1.0001204008p+37, 0x0p+0 },
{ INT64_C(0x0000002000242000), 0x1.000121p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdbdfff), -0x1.0001210008p+37, 0x0p+0 },
{ INT64_C(0x0000002000248000), 0x1.000124p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffdb7fff), -0x1.0001240008p+37, 0x0p+0 },
{ INT64_C(0x0000002000300000), 0x1.00018p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffcfffff), -0x1.0001800008p+37, 0x0p+0 },
{ INT64_C(0x0000002000300001), 0x1.0001800008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffcffffe), -0x1.000180001p+37, 0x0p+0 },
{ INT64_C(0x0000002000300010), 0x1.000180008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffcfffef), -0x1.0001800088p+37, 0x0p+0 },
{ INT64_C(0x0000002000300040), 0x1.00018002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffcfffbf), -0x1.0001800208p+37, 0x0p+0 },
{ INT64_C(0x0000002000300100), 0x1.00018008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffcffeff), -0x1.0001800808p+37, 0x0p+0 },
{ INT64_C(0x0000002000300200), 0x1.0001801p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffcffdff), -0x1.0001801008p+37, 0x0p+0 },
{ INT64_C(0x0000002000300400), 0x1.0001802p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffcffbff), -0x1.0001802008p+37, 0x0p+0 },
{ INT64_C(0x0000002000301000), 0x1.0001808p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffcfefff), -0x1.0001808008p+37, 0x0p+0 },
{ INT64_C(0x0000002000304000), 0x1.000182p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffcfbfff), -0x1.0001820008p+37, 0x0p+0 },
{ INT64_C(0x0000002000308000), 0x1.000184p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffcf7fff), -0x1.0001840008p+37, 0x0p+0 },
{ INT64_C(0x0000002000310000), 0x1.000188p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffceffff), -0x1.0001880008p+37, 0x0p+0 },
{ INT64_C(0x0000002000400001), 0x1.0002000008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbffffe), -0x1.000200001p+37, 0x0p+0 },
{ INT64_C(0x0000002000400002), 0x1.000200001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbffffd), -0x1.0002000018p+37, 0x0p+0 },
{ INT64_C(0x0000002000400004), 0x1.000200002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbffffb), -0x1.0002000028p+37, 0x0p+0 },
{ INT64_C(0x0000002000400020), 0x1.00020001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfffdf), -0x1.0002000108p+37, 0x0p+0 },
{ INT64_C(0x0000002000400024), 0x1.000200012p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfffdb), -0x1.0002000128p+37, 0x0p+0 },
{ INT64_C(0x0000002000400100), 0x1.00020008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbffeff), -0x1.0002000808p+37, 0x0p+0 },
{ INT64_C(0x0000002000400102), 0x1.000200081p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbffefd), -0x1.0002000818p+37, 0x0p+0 },
{ INT64_C(0x0000002000400120), 0x1.00020009p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbffedf), -0x1.0002000908p+37, 0x0p+0 },
{ INT64_C(0x0000002000401000), 0x1.0002008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfefff), -0x1.0002008008p+37, 0x0p+0 },
{ INT64_C(0x0000002000401002), 0x1.000200801p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfeffd), -0x1.0002008018p+37, 0x0p+0 },
{ INT64_C(0x0000002000401008), 0x1.000200804p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfeff7), -0x1.0002008048p+37, 0x0p+0 },
{ INT64_C(0x0000002000401040), 0x1.00020082p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfefbf), -0x1.0002008208p+37, 0x0p+0 },
{ INT64_C(0x0000002000401400), 0x1.000200ap+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfebff), -0x1.000200a008p+37, 0x0p+0 },
{ INT64_C(0x0000002000404000), 0x1.000202p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfbfff), -0x1.0002020008p+37, 0x0p+0 },
{ INT64_C(0x0000002000404002), 0x1.000202001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfbffd), -0x1.0002020018p+37, 0x0p+0 },
{ INT64_C(0x0000002000404004), 0x1.000202002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfbffb), -0x1.0002020028p+37, 0x0p+0 },
{ INT64_C(0x0000002000404008), 0x1.000202004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfbff7), -0x1.0002020048p+37, 0x0p+0 },
{ INT64_C(0x0000002000404080), 0x1.00020204p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfbf7f), -0x1.0002020408p+37, 0x0p+0 },
{ INT64_C(0x0000002000404400), 0x1.0002022p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbfbbff), -0x1.0002022008p+37, 0x0p+0 },
{ INT64_C(0x0000002000420000), 0x1.00021p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbdffff), -0x1.0002100008p+37, 0x0p+0 },
{ INT64_C(0x0000002000420008), 0x1.000210004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbdfff7), -0x1.0002100048p+37, 0x0p+0 },
{ INT64_C(0x0000002000420010), 0x1.000210008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbdffef), -0x1.0002100088p+37, 0x0p+0 },
{ INT64_C(0x0000002000420020), 0x1.00021001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbdffdf), -0x1.0002100108p+37, 0x0p+0 },
{ INT64_C(0x0000002000420200), 0x1.0002101p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbdfdff), -0x1.0002101008p+37, 0x0p+0 },
{ INT64_C(0x0000002000421000), 0x1.0002108p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbdefff), -0x1.0002108008p+37, 0x0p+0 },
{ INT64_C(0x0000002000424000), 0x1.000212p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbdbfff), -0x1.0002120008p+37, 0x0p+0 },
{ INT64_C(0x0000002000440000), 0x1.00022p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbbffff), -0x1.0002200008p+37, 0x0p+0 },
{ INT64_C(0x0000002000440001), 0x1.0002200008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbbfffe), -0x1.000220001p+37, 0x0p+0 },
{ INT64_C(0x0000002000440010), 0x1.000220008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbbffef), -0x1.0002200088p+37, 0x0p+0 },
{ INT64_C(0x0000002000440040), 0x1.00022002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbbffbf), -0x1.0002200208p+37, 0x0p+0 },
{ INT64_C(0x0000002000440080), 0x1.00022004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbbff7f), -0x1.0002200408p+37, 0x0p+0 },
{ INT64_C(0x0000002000440100), 0x1.00022008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbbfeff), -0x1.0002200808p+37, 0x0p+0 },
{ INT64_C(0x0000002000440200), 0x1.0002201p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbbfdff), -0x1.0002201008p+37, 0x0p+0 },
{ INT64_C(0x0000002000442000), 0x1.000221p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbbdfff), -0x1.0002210008p+37, 0x0p+0 },
{ INT64_C(0x0000002000448000), 0x1.000224p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffbb7fff), -0x1.0002240008p+37, 0x0p+0 },
{ INT64_C(0x0000002000460000), 0x1.00023p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffb9ffff), -0x1.0002300008p+37, 0x0p+0 },
{ INT64_C(0x0000002000480000), 0x1.00024p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffb7ffff), -0x1.0002400008p+37, 0x0p+0 },
{ INT64_C(0x0000002000480002), 0x1.000240001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffb7fffd), -0x1.0002400018p+37, 0x0p+0 },
{ INT64_C(0x0000002000480008), 0x1.000240004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffb7fff7), -0x1.0002400048p+37, 0x0p+0 },
{ INT64_C(0x0000002000480010), 0x1.000240008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffb7ffef), -0x1.0002400088p+37, 0x0p+0 },
{ INT64_C(0x0000002000480040), 0x1.00024002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffb7ffbf), -0x1.0002400208p+37, 0x0p+0 },
{ INT64_C(0x0000002000480400), 0x1.0002402p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffb7fbff), -0x1.0002402008p+37, 0x0p+0 },
{ INT64_C(0x0000002000481000), 0x1.0002408p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffb7efff), -0x1.0002408008p+37, 0x0p+0 },
{ INT64_C(0x0000002000490000), 0x1.000248p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffb6ffff), -0x1.0002480008p+37, 0x0p+0 },
{ INT64_C(0x00000020004a0000), 0x1.00025p+37, 0x0p+0 },
{ INT64_C(0xffffffdfffb5ffff), -0x1.0002500008p+37, 0x0p+0 },
{ INT64_C(0x0000002000800001), 0x1.0004000008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7ffffe), -0x1.000400001p+37, 0x0p+0 },
{ INT64_C(0x0000002000800010), 0x1.000400008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7fffef), -0x1.0004000088p+37, 0x0p+0 },
{ INT64_C(0x0000002000800012), 0x1.000400009p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7fffed), -0x1.0004000098p+37, 0x0p+0 },
{ INT64_C(0x0000002000800040), 0x1.00040002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7fffbf), -0x1.0004000208p+37, 0x0p+0 },
{ INT64_C(0x0000002000800041), 0x1.0004000208p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7fffbe), -0x1.000400021p+37, 0x0p+0 },
{ INT64_C(0x0000002000800044), 0x1.000400022p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7fffbb), -0x1.0004000228p+37, 0x0p+0 },
{ INT64_C(0x0000002000800060), 0x1.00040003p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7fff9f), -0x1.0004000308p+37, 0x0p+0 },
{ INT64_C(0x0000002000800400), 0x1.0004002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7ffbff), -0x1.0004002008p+37, 0x0p+0 },
{ INT64_C(0x0000002000800408), 0x1.000400204p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7ffbf7), -0x1.0004002048p+37, 0x0p+0 },
{ INT64_C(0x0000002000800420), 0x1.00040021p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7ffbdf), -0x1.0004002108p+37, 0x0p+0 },
{ INT64_C(0x0000002000800600), 0x1.0004003p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7ff9ff), -0x1.0004003008p+37, 0x0p+0 },
{ INT64_C(0x0000002000804000), 0x1.000402p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7fbfff), -0x1.0004020008p+37, 0x0p+0 },
{ INT64_C(0x0000002000804002), 0x1.000402001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7fbffd), -0x1.0004020018p+37, 0x0p+0 },
{ INT64_C(0x0000002000804020), 0x1.00040201p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7fbfdf), -0x1.0004020108p+37, 0x0p+0 },
{ INT64_C(0x0000002000804080), 0x1.00040204p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7fbf7f), -0x1.0004020408p+37, 0x0p+0 },
{ INT64_C(0x0000002000804200), 0x1.0004021p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7fbdff), -0x1.0004021008p+37, 0x0p+0 },
{ INT64_C(0x0000002000804800), 0x1.0004024p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7fb7ff), -0x1.0004024008p+37, 0x0p+0 },
{ INT64_C(0x0000002000806000), 0x1.000403p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7f9fff), -0x1.0004030008p+37, 0x0p+0 },
{ INT64_C(0x0000002000810000), 0x1.000408p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7effff), -0x1.0004080008p+37, 0x0p+0 },
{ INT64_C(0x0000002000810001), 0x1.0004080008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7efffe), -0x1.000408001p+37, 0x0p+0 },
{ INT64_C(0x0000002000810010), 0x1.000408008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7effef), -0x1.0004080088p+37, 0x0p+0 },
{ INT64_C(0x0000002000810040), 0x1.00040802p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7effbf), -0x1.0004080208p+37, 0x0p+0 },
{ INT64_C(0x0000002000810400), 0x1.0004082p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7efbff), -0x1.0004082008p+37, 0x0p+0 },
{ INT64_C(0x0000002000811000), 0x1.0004088p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7eefff), -0x1.0004088008p+37, 0x0p+0 },
{ INT64_C(0x0000002000812000), 0x1.000409p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7edfff), -0x1.0004090008p+37, 0x0p+0 },
{ INT64_C(0x0000002000820000), 0x1.00041p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7dffff), -0x1.0004100008p+37, 0x0p+0 },
{ INT64_C(0x0000002000820008), 0x1.000410004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7dfff7), -0x1.0004100048p+37, 0x0p+0 },
{ INT64_C(0x0000002000820010), 0x1.000410008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7dffef), -0x1.0004100088p+37, 0x0p+0 },
{ INT64_C(0x0000002000820080), 0x1.00041004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7dff7f), -0x1.0004100408p+37, 0x0p+0 },
{ INT64_C(0x0000002000820100), 0x1.00041008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7dfeff), -0x1.0004100808p+37, 0x0p+0 },
{ INT64_C(0x0000002000820200), 0x1.0004101p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7dfdff), -0x1.0004101008p+37, 0x0p+0 },
{ INT64_C(0x0000002000820800), 0x1.0004104p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7df7ff), -0x1.0004104008p+37, 0x0p+0 },
{ INT64_C(0x0000002000822000), 0x1.000411p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7ddfff), -0x1.0004110008p+37, 0x0p+0 },
{ INT64_C(0x0000002000824000), 0x1.000412p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7dbfff), -0x1.0004120008p+37, 0x0p+0 },
{ INT64_C(0x0000002000828000), 0x1.000414p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7d7fff), -0x1.0004140008p+37, 0x0p+0 },
{ INT64_C(0x0000002000830000), 0x1.000418p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7cffff), -0x1.0004180008p+37, 0x0p+0 },
{ INT64_C(0x0000002000840000), 0x1.00042p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7bffff), -0x1.0004200008p+37, 0x0p+0 },
{ INT64_C(0x0000002000840002), 0x1.000420001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7bfffd), -0x1.0004200018p+37, 0x0p+0 },
{ INT64_C(0x0000002000840010), 0x1.000420008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7bffef), -0x1.0004200088p+37, 0x0p+0 },
{ INT64_C(0x0000002000840100), 0x1.00042008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7bfeff), -0x1.0004200808p+37, 0x0p+0 },
{ INT64_C(0x0000002000841000), 0x1.0004208p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7befff), -0x1.0004208008p+37, 0x0p+0 },
{ INT64_C(0x0000002000850000), 0x1.000428p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff7affff), -0x1.0004280008p+37, 0x0p+0 },
{ INT64_C(0x0000002000900000), 0x1.00048p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff6fffff), -0x1.0004800008p+37, 0x0p+0 },
{ INT64_C(0x0000002000900004), 0x1.000480002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff6ffffb), -0x1.0004800028p+37, 0x0p+0 },
{ INT64_C(0x0000002000900020), 0x1.00048001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff6fffdf), -0x1.0004800108p+37, 0x0p+0 },
{ INT64_C(0x0000002000900200), 0x1.0004801p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff6ffdff), -0x1.0004801008p+37, 0x0p+0 },
{ INT64_C(0x0000002000900400), 0x1.0004802p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff6ffbff), -0x1.0004802008p+37, 0x0p+0 },
{ INT64_C(0x0000002000904000), 0x1.000482p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff6fbfff), -0x1.0004820008p+37, 0x0p+0 },
{ INT64_C(0x0000002000910000), 0x1.000488p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff6effff), -0x1.0004880008p+37, 0x0p+0 },
{ INT64_C(0x0000002000c00000), 0x1.0006p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff3fffff), -0x1.0006000008p+37, 0x0p+0 },
{ INT64_C(0x0000002000c00002), 0x1.000600001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff3ffffd), -0x1.0006000018p+37, 0x0p+0 },
{ INT64_C(0x0000002000c00020), 0x1.00060001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff3fffdf), -0x1.0006000108p+37, 0x0p+0 },
{ INT64_C(0x0000002000c00200), 0x1.0006001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff3ffdff), -0x1.0006001008p+37, 0x0p+0 },
{ INT64_C(0x0000002000c01000), 0x1.0006008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff3fefff), -0x1.0006008008p+37, 0x0p+0 },
{ INT64_C(0x0000002000c02000), 0x1.000601p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff3fdfff), -0x1.0006010008p+37, 0x0p+0 },
{ INT64_C(0x0000002000c04000), 0x1.000602p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff3fbfff), -0x1.0006020008p+37, 0x0p+0 },
{ INT64_C(0x0000002000c08000), 0x1.000604p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff3f7fff), -0x1.0006040008p+37, 0x0p+0 },
{ INT64_C(0x0000002000c20000), 0x1.00061p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff3dffff), -0x1.0006100008p+37, 0x0p+0 },
{ INT64_C(0x0000002000e00000), 0x1.0007p+37, 0x0p+0 },
{ INT64_C(0xffffffdfff1fffff), -0x1.0007000008p+37, 0x0p+0 },
{ INT64_C(0x0000002004000002), 0x1.002000001p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfffffd), -0x1.0020000018p+37, 0x0p+0 },
{ INT64_C(0x0000002004000004), 0x1.002000002p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfffffb), -0x1.0020000028p+37, 0x0p+0 },
{ INT64_C(0x0000002004000006), 0x1.002000003p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfffff9), -0x1.0020000038p+37, 0x0p+0 },
{ INT64_C(0x0000002004000010), 0x1.002000008p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbffffef), -0x1.0020000088p+37, 0x0p+0 },
{ INT64_C(0x0000002004000012), 0x1.002000009p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbffffed), -0x1.0020000098p+37, 0x0p+0 },
{ INT64_C(0x0000002004000018), 0x1.00200000cp+37, 0x0p+0 },
{ INT64_C(0xffffffdffbffffe7), -0x1.00200000c8p+37, 0x0p+0 },
{ INT64_C(0x0000002004000100), 0x1.00200008p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfffeff), -0x1.0020000808p+37, 0x0p+0 },
{ INT64_C(0x0000002004000104), 0x1.002000082p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfffefb), -0x1.0020000828p+37, 0x0p+0 },
{ INT64_C(0x0000002004000140), 0x1.0020000ap+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfffebf), -0x1.0020000a08p+37, 0x0p+0 },
{ INT64_C(0x0000002004001000), 0x1.0020008p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbffefff), -0x1.0020008008p+37, 0x0p+0 },
{ INT64_C(0x0000002004001002), 0x1.002000801p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbffeffd), -0x1.0020008018p+37, 0x0p+0 },
{ INT64_C(0x0000002004001008), 0x1.002000804p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbffeff7), -0x1.0020008048p+37, 0x0p+0 },
{ INT64_C(0x0000002004001020), 0x1.00200081p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbffefdf), -0x1.0020008108p+37, 0x0p+0 },
{ INT64_C(0x0000002004001200), 0x1.0020009p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbffedff), -0x1.0020009008p+37, 0x0p+0 },
{ INT64_C(0x0000002004008000), 0x1.002004p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbff7fff), -0x1.0020040008p+37, 0x0p+0 },
{ INT64_C(0x0000002004008002), 0x1.002004001p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbff7ffd), -0x1.0020040018p+37, 0x0p+0 },
{ INT64_C(0x0000002004008020), 0x1.00200401p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbff7fdf), -0x1.0020040108p+37, 0x0p+0 },
{ INT64_C(0x0000002004008080), 0x1.00200404p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbff7f7f), -0x1.0020040408p+37, 0x0p+0 },
{ INT64_C(0x0000002004008800), 0x1.0020044p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbff77ff), -0x1.0020044008p+37, 0x0p+0 },
{ INT64_C(0x000000200400a000), 0x1.002005p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbff5fff), -0x1.0020050008p+37, 0x0p+0 },
{ INT64_C(0x000000200400c000), 0x1.002006p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbff3fff), -0x1.0020060008p+37, 0x0p+0 },
{ INT64_C(0x0000002004040000), 0x1.00202p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfbffff), -0x1.0020200008p+37, 0x0p+0 },
{ INT64_C(0x0000002004040001), 0x1.0020200008p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfbfffe), -0x1.002020001p+37, 0x0p+0 },
{ INT64_C(0x0000002004040002), 0x1.002020001p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfbfffd), -0x1.0020200018p+37, 0x0p+0 },
{ INT64_C(0x0000002004040004), 0x1.002020002p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfbfffb), -0x1.0020200028p+37, 0x0p+0 },
{ INT64_C(0x0000002004040020), 0x1.00202001p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfbffdf), -0x1.0020200108p+37, 0x0p+0 },
{ INT64_C(0x0000002004040200), 0x1.0020201p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfbfdff), -0x1.0020201008p+37, 0x0p+0 },
{ INT64_C(0x0000002004042000), 0x1.002021p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfbdfff), -0x1.0020210008p+37, 0x0p+0 },
{ INT64_C(0x0000002004044000), 0x1.002022p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfbbfff), -0x1.0020220008p+37, 0x0p+0 },
{ INT64_C(0x0000002004050000), 0x1.002028p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbfaffff), -0x1.0020280008p+37, 0x0p+0 },
{ INT64_C(0x0000002004060000), 0x1.00203p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbf9ffff), -0x1.0020300008p+37, 0x0p+0 },
{ INT64_C(0x0000002004200000), 0x1.0021p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbdfffff), -0x1.0021000008p+37, 0x0p+0 },
{ INT64_C(0x0000002004200004), 0x1.002100002p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbdffffb), -0x1.0021000028p+37, 0x0p+0 },
{ INT64_C(0x0000002004200040), 0x1.00210002p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbdfffbf), -0x1.0021000208p+37, 0x0p+0 },
{ INT64_C(0x0000002004200080), 0x1.00210004p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbdfff7f), -0x1.0021000408p+37, 0x0p+0 },
{ INT64_C(0x0000002004200200), 0x1.0021001p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbdffdff), -0x1.0021001008p+37, 0x0p+0 },
{ INT64_C(0x0000002004200400), 0x1.0021002p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbdffbff), -0x1.0021002008p+37, 0x0p+0 },
{ INT64_C(0x0000002004201000), 0x1.0021008p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbdfefff), -0x1.0021008008p+37, 0x0p+0 },
{ INT64_C(0x0000002004202000), 0x1.002101p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbdfdfff), -0x1.0021010008p+37, 0x0p+0 },
{ INT64_C(0x0000002004220000), 0x1.00211p+37, 0x0p+0 },
{ INT64_C(0xffffffdffbddffff), -0x1.0021100008p+37, 0x0p+0 },
{ INT64_C(0x0000002005000000), 0x1.0028p+37, 0x0p+0 },
{ INT64_C(0xffffffdffaffffff), -0x1.0028000008p+37, 0x0p+0 },
{ INT64_C(0x0000002005000001), 0x1.0028000008p+37, 0x0p+0 },
{ INT64_C(0xffffffdffafffffe), -0x1.002800001p+37, 0x0p+0 },
{ INT64_C(0x0000002005000008), 0x1.002800004p+37, 0x0p+0 },
{ INT64_C(0xffffffdffafffff7), -0x1.0028000048p+37, 0x0p+0 },
{ INT64_C(0x0000002005000040), 0x1.00280002p+37, 0x0p+0 },
{ INT64_C(0xffffffdffaffffbf), -0x1.0028000208p+37, 0x0p+0 },
{ INT64_C(0x0000002005000200), 0x1.0028001p+37, 0x0p+0 },
{ INT64_C(0xffffffdffafffdff), -0x1.0028001008p+37, 0x0p+0 },
{ INT64_C(0x0000002005001000), 0x1.0028008p+37, 0x0p+0 },
{ INT64_C(0xffffffdffaffefff), -0x1.0028008008p+37, 0x0p+0 },
{ INT64_C(0x0000002005004000), 0x1.002802p+37, 0x0p+0 },
{ INT64_C(0xffffffdffaffbfff), -0x1.0028020008p+37, 0x0p+0 },
{ INT64_C(0x0000002005008000), 0x1.002804p+37, 0x0p+0 },
{ INT64_C(0xffffffdffaff7fff), -0x1.0028040008p+37, 0x0p+0 },
{ INT64_C(0x0000002005080000), 0x1.00284p+37, 0x0p+0 },
{ INT64_C(0xffffffdffaf7ffff), -0x1.0028400008p+37, 0x0p+0 },
{ INT64_C(0x0000002005100000), 0x1.00288p+37, 0x0p+0 },
{ INT64_C(0xffffffdffaefffff), -0x1.0028800008p+37, 0x0p+0 },
{ INT64_C(0x0000002005200000), 0x1.0029p+37, 0x0p+0 },
{ INT64_C(0xffffffdffadfffff), -0x1.0029000008p+37, 0x0p+0 },
{ INT64_C(0x0000002008000002), 0x1.004000001p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fffffd), -0x1.0040000018p+37, 0x0p+0 },
{ INT64_C(0x0000002008000003), 0x1.0040000018p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fffffc), -0x1.004000002p+37, 0x0p+0 },
{ INT64_C(0x0000002008000008), 0x1.004000004p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fffff7), -0x1.0040000048p+37, 0x0p+0 },
{ INT64_C(0x0000002008000009), 0x1.0040000048p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fffff6), -0x1.004000005p+37, 0x0p+0 },
{ INT64_C(0x000000200800000a), 0x1.004000005p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fffff5), -0x1.0040000058p+37, 0x0p+0 },
{ INT64_C(0x000000200800000c), 0x1.004000006p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fffff3), -0x1.0040000068p+37, 0x0p+0 },
{ INT64_C(0x0000002008000020), 0x1.00400001p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7ffffdf), -0x1.0040000108p+37, 0x0p+0 },
{ INT64_C(0x0000002008000022), 0x1.004000011p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7ffffdd), -0x1.0040000118p+37, 0x0p+0 },
{ INT64_C(0x0000002008000030), 0x1.004000018p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7ffffcf), -0x1.0040000188p+37, 0x0p+0 },
{ INT64_C(0x0000002008000200), 0x1.0040001p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fffdff), -0x1.0040001008p+37, 0x0p+0 },
{ INT64_C(0x0000002008000204), 0x1.004000102p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fffdfb), -0x1.0040001028p+37, 0x0p+0 },
{ INT64_C(0x0000002008000210), 0x1.004000108p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fffdef), -0x1.0040001088p+37, 0x0p+0 },
{ INT64_C(0x0000002008000300), 0x1.00400018p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fffcff), -0x1.0040001808p+37, 0x0p+0 },
{ INT64_C(0x0000002008002000), 0x1.004001p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7ffdfff), -0x1.0040010008p+37, 0x0p+0 },
{ INT64_C(0x0000002008002004), 0x1.004001002p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7ffdffb), -0x1.0040010028p+37, 0x0p+0 },
{ INT64_C(0x0000002008002010), 0x1.004001008p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7ffdfef), -0x1.0040010088p+37, 0x0p+0 },
{ INT64_C(0x0000002008002020), 0x1.00400101p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7ffdfdf), -0x1.0040010108p+37, 0x0p+0 },
{ INT64_C(0x0000002008002040), 0x1.00400102p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7ffdfbf), -0x1.0040010208p+37, 0x0p+0 },
{ INT64_C(0x0000002008002100), 0x1.00400108p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7ffdeff), -0x1.0040010808p+37, 0x0p+0 },
{ INT64_C(0x0000002008002400), 0x1.0040012p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7ffdbff), -0x1.0040012008p+37, 0x0p+0 },
{ INT64_C(0x0000002008010000), 0x1.004008p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7feffff), -0x1.0040080008p+37, 0x0p+0 },
{ INT64_C(0x0000002008010004), 0x1.004008002p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fefffb), -0x1.0040080028p+37, 0x0p+0 },
{ INT64_C(0x0000002008010040), 0x1.00400802p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7feffbf), -0x1.0040080208p+37, 0x0p+0 },
{ INT64_C(0x0000002008010080), 0x1.00400804p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7feff7f), -0x1.0040080408p+37, 0x0p+0 },
{ INT64_C(0x0000002008010800), 0x1.0040084p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fef7ff), -0x1.0040084008p+37, 0x0p+0 },
{ INT64_C(0x0000002008018000), 0x1.00400cp+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fe7fff), -0x1.00400c0008p+37, 0x0p+0 },
{ INT64_C(0x0000002008040000), 0x1.00402p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fbffff), -0x1.0040200008p+37, 0x0p+0 },
{ INT64_C(0x0000002008040001), 0x1.0040200008p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fbfffe), -0x1.004020001p+37, 0x0p+0 },
{ INT64_C(0x0000002008040002), 0x1.004020001p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fbfffd), -0x1.0040200018p+37, 0x0p+0 },
{ INT64_C(0x0000002008040020), 0x1.00402001p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fbffdf), -0x1.0040200108p+37, 0x0p+0 },
{ INT64_C(0x0000002008040040), 0x1.00402002p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fbffbf), -0x1.0040200208p+37, 0x0p+0 },
{ INT64_C(0x0000002008040080), 0x1.00402004p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fbff7f), -0x1.0040200408p+37, 0x0p+0 },
{ INT64_C(0x0000002008040200), 0x1.0040201p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fbfdff), -0x1.0040201008p+37, 0x0p+0 },
{ INT64_C(0x0000002008040400), 0x1.0040202p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fbfbff), -0x1.0040202008p+37, 0x0p+0 },
{ INT64_C(0x0000002008044000), 0x1.004022p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7fbbfff), -0x1.0040220008p+37, 0x0p+0 },
{ INT64_C(0x0000002008400000), 0x1.0042p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7bfffff), -0x1.0042000008p+37, 0x0p+0 },
{ INT64_C(0x0000002008400002), 0x1.004200001p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7bffffd), -0x1.0042000018p+37, 0x0p+0 },
{ INT64_C(0x0000002008400010), 0x1.004200008p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7bfffef), -0x1.0042000088p+37, 0x0p+0 },
{ INT64_C(0x0000002008400040), 0x1.00420002p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7bfffbf), -0x1.0042000208p+37, 0x0p+0 },
{ INT64_C(0x0000002008400400), 0x1.0042002p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7bffbff), -0x1.0042002008p+37, 0x0p+0 },
{ INT64_C(0x0000002008402000), 0x1.004201p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7bfdfff), -0x1.0042010008p+37, 0x0p+0 },
{ INT64_C(0x0000002008408000), 0x1.004204p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7bf7fff), -0x1.0042040008p+37, 0x0p+0 },
{ INT64_C(0x0000002008440000), 0x1.00422p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7bbffff), -0x1.0042200008p+37, 0x0p+0 },
{ INT64_C(0x0000002008500000), 0x1.00428p+37, 0x0p+0 },
{ INT64_C(0xffffffdff7afffff), -0x1.0042800008p+37, 0x0p+0 },
{ INT64_C(0x0000002008800000), 0x1.0044p+37, 0x0p+0 },
{ INT64_C(0xffffffdff77fffff), -0x1.0044000008p+37, 0x0p+0 },
{ INT64_C(0x0000002008800004), 0x1.004400002p+37, 0x0p+0 },
{ INT64_C(0xffffffdff77ffffb), -0x1.0044000028p+37, 0x0p+0 },
{ INT64_C(0x0000002008800008), 0x1.004400004p+37, 0x0p+0 },
{ INT64_C(0xffffffdff77ffff7), -0x1.0044000048p+37, 0x0p+0 },
{ INT64_C(0x0000002008800040), 0x1.00440002p+37, 0x0p+0 },
{ INT64_C(0xffffffdff77fffbf), -0x1.0044000208p+37, 0x0p+0 },
{ INT64_C(0x0000002008800100), 0x1.00440008p+37, 0x0p+0 },
{ INT64_C(0xffffffdff77ffeff), -0x1.0044000808p+37, 0x0p+0 },
{ INT64_C(0x0000002008801000), 0x1.0044008p+37, 0x0p+0 },
{ INT64_C(0xffffffdff77fefff), -0x1.0044008008p+37, 0x0p+0 },
{ INT64_C(0x0000002008802000), 0x1.004401p+37, 0x0p+0 },
{ INT64_C(0xffffffdff77fdfff), -0x1.0044010008p+37, 0x0p+0 },
{ INT64_C(0x0000002008804000), 0x1.004402p+37, 0x0p+0 },
{ INT64_C(0xffffffdff77fbfff), -0x1.0044020008p+37, 0x0p+0 },
{ INT64_C(0x0000002008820000), 0x1.00441p+37, 0x0p+0 },
{ INT64_C(0xffffffdff77dffff), -0x1.0044100008p+37, 0x0p+0 },
{ INT64_C(0x0000002008840000), 0x1.00442p+37, 0x0p+0 },
{ INT64_C(0xffffffdff77bffff), -0x1.0044200008p+37, 0x0p+0 },
{ INT64_C(0x0000002008c00000), 0x1.0046p+37, 0x0p+0 },
{ INT64_C(0xffffffdff73fffff), -0x1.0046000008p+37, 0x0p+0 },
{ INT64_C(0x000000200c000000), 0x1.006p+37, 0x0p+0 },
{ INT64_C(0xffffffdff3ffffff), -0x1.0060000008p+37, 0x0p+0 },
{ INT64_C(0x000000200c000001), 0x1.0060000008p+37, 0x0p+0 },
{ INT64_C(0xffffffdff3fffffe), -0x1.006000001p+37, 0x0p+0 },
{ INT64_C(0x000000200c000010), 0x1.006000008p+37, 0x0p+0 },
{ INT64_C(0xffffffdff3ffffef), -0x1.0060000088p+37, 0x0p+0 },
{ INT64_C(0x000000200c000040), 0x1.00600002p+37, 0x0p+0 },
{ INT64_C(0xffffffdff3ffffbf), -0x1.0060000208p+37, 0x0p+0 },
{ INT64_C(0x000000200c000080), 0x1.00600004p+37, 0x0p+0 },
{ INT64_C(0xffffffdff3ffff7f), -0x1.0060000408p+37, 0x0p+0 },
{ INT64_C(0x000000200c000200), 0x1.0060001p+37, 0x0p+0 },
{ INT64_C(0xffffffdff3fffdff), -0x1.0060001008p+37, 0x0p+0 },
{ INT64_C(0x000000200c000800), 0x1.0060004p+37, 0x0p+0 },
{ INT64_C(0xffffffdff3fff7ff), -0x1.0060004008p+37, 0x0p+0 },
{ INT64_C(0x000000200c004000), 0x1.006002p+37, 0x0p+0 },
{ INT64_C(0xffffffdff3ffbfff), -0x1.0060020008p+37, 0x0p+0 },
{ INT64_C(0x000000200c008000), 0x1.006004p+37, 0x0p+0 },
{ INT64_C(0xffffffdff3ff7fff), -0x1.0060040008p+37, 0x0p+0 },
{ INT64_C(0x000000200c080000), 0x1.00604p+37, 0x0p+0 },
{ INT64_C(0xffffffdff3f7ffff), -0x1.0060400008p+37, 0x0p+0 },
{ INT64_C(0x000000200c800000), 0x1.0064p+37, 0x0p+0 },
{ INT64_C(0xffffffdff37fffff), -0x1.0064000008p+37, 0x0p+0 },
{ INT64_C(0x000000200e000000), 0x1.007p+37, 0x0p+0 },
{ INT64_C(0xffffffdff1ffffff), -0x1.0070000008p+37, 0x0p+0 },
{ INT64_C(0x0000002010000002), 0x1.008000001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffffffd), -0x1.0080000018p+37, 0x0p+0 },
{ INT64_C(0x0000002010000003), 0x1.0080000018p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffffffc), -0x1.008000002p+37, 0x0p+0 },
{ INT64_C(0x0000002010000020), 0x1.00800001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefffffdf), -0x1.0080000108p+37, 0x0p+0 },
{ INT64_C(0x0000002010000021), 0x1.0080000108p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefffffde), -0x1.008000011p+37, 0x0p+0 },
{ INT64_C(0x0000002010000030), 0x1.008000018p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefffffcf), -0x1.0080000188p+37, 0x0p+0 },
{ INT64_C(0x0000002010000200), 0x1.0080001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffffdff), -0x1.0080001008p+37, 0x0p+0 },
{ INT64_C(0x0000002010000208), 0x1.008000104p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffffdf7), -0x1.0080001048p+37, 0x0p+0 },
{ INT64_C(0x0000002010000220), 0x1.00800011p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffffddf), -0x1.0080001108p+37, 0x0p+0 },
{ INT64_C(0x0000002010000400), 0x1.0080002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffffbff), -0x1.0080002008p+37, 0x0p+0 },
{ INT64_C(0x0000002010000404), 0x1.008000202p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffffbfb), -0x1.0080002028p+37, 0x0p+0 },
{ INT64_C(0x0000002010000420), 0x1.00800021p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffffbdf), -0x1.0080002108p+37, 0x0p+0 },
{ INT64_C(0x0000002010000500), 0x1.00800028p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffffaff), -0x1.0080002808p+37, 0x0p+0 },
{ INT64_C(0x0000002010002000), 0x1.008001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefffdfff), -0x1.0080010008p+37, 0x0p+0 },
{ INT64_C(0x0000002010002002), 0x1.008001001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefffdffd), -0x1.0080010018p+37, 0x0p+0 },
{ INT64_C(0x0000002010002004), 0x1.008001002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefffdffb), -0x1.0080010028p+37, 0x0p+0 },
{ INT64_C(0x0000002010002020), 0x1.00800101p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefffdfdf), -0x1.0080010108p+37, 0x0p+0 },
{ INT64_C(0x0000002010002200), 0x1.0080011p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefffddff), -0x1.0080011008p+37, 0x0p+0 },
{ INT64_C(0x0000002010002800), 0x1.0080014p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefffd7ff), -0x1.0080014008p+37, 0x0p+0 },
{ INT64_C(0x0000002010008000), 0x1.008004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefff7fff), -0x1.0080040008p+37, 0x0p+0 },
{ INT64_C(0x0000002010008002), 0x1.008004001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefff7ffd), -0x1.0080040018p+37, 0x0p+0 },
{ INT64_C(0x0000002010008004), 0x1.008004002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefff7ffb), -0x1.0080040028p+37, 0x0p+0 },
{ INT64_C(0x0000002010008020), 0x1.00800401p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefff7fdf), -0x1.0080040108p+37, 0x0p+0 },
{ INT64_C(0x0000002010008040), 0x1.00800402p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefff7fbf), -0x1.0080040208p+37, 0x0p+0 },
{ INT64_C(0x0000002010008080), 0x1.00800404p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefff7f7f), -0x1.0080040408p+37, 0x0p+0 },
{ INT64_C(0x0000002010008200), 0x1.0080041p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefff7dff), -0x1.0080041008p+37, 0x0p+0 },
{ INT64_C(0x0000002010009000), 0x1.0080048p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefff6fff), -0x1.0080048008p+37, 0x0p+0 },
{ INT64_C(0x0000002010040000), 0x1.00802p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffbffff), -0x1.0080200008p+37, 0x0p+0 },
{ INT64_C(0x0000002010040008), 0x1.008020004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffbfff7), -0x1.0080200048p+37, 0x0p+0 },
{ INT64_C(0x0000002010040040), 0x1.00802002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffbffbf), -0x1.0080200208p+37, 0x0p+0 },
{ INT64_C(0x0000002010040100), 0x1.00802008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffbfeff), -0x1.0080200808p+37, 0x0p+0 },
{ INT64_C(0x0000002010040200), 0x1.0080201p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffbfdff), -0x1.0080201008p+37, 0x0p+0 },
{ INT64_C(0x0000002010040400), 0x1.0080202p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffbfbff), -0x1.0080202008p+37, 0x0p+0 },
{ INT64_C(0x0000002010040800), 0x1.0080204p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffbf7ff), -0x1.0080204008p+37, 0x0p+0 },
{ INT64_C(0x0000002010041000), 0x1.0080208p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffbefff), -0x1.0080208008p+37, 0x0p+0 },
{ INT64_C(0x0000002010048000), 0x1.008024p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeffb7fff), -0x1.0080240008p+37, 0x0p+0 },
{ INT64_C(0x0000002010060000), 0x1.00803p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeff9ffff), -0x1.0080300008p+37, 0x0p+0 },
{ INT64_C(0x0000002010100000), 0x1.00808p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefefffff), -0x1.0080800008p+37, 0x0p+0 },
{ INT64_C(0x0000002010100001), 0x1.0080800008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefeffffe), -0x1.008080001p+37, 0x0p+0 },
{ INT64_C(0x0000002010100008), 0x1.008080004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefeffff7), -0x1.0080800048p+37, 0x0p+0 },
{ INT64_C(0x0000002010100020), 0x1.00808001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefefffdf), -0x1.0080800108p+37, 0x0p+0 },
{ INT64_C(0x0000002010100100), 0x1.00808008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefeffeff), -0x1.0080800808p+37, 0x0p+0 },
{ INT64_C(0x0000002010101000), 0x1.0080808p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefefefff), -0x1.0080808008p+37, 0x0p+0 },
{ INT64_C(0x0000002010104000), 0x1.008082p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefefbfff), -0x1.0080820008p+37, 0x0p+0 },
{ INT64_C(0x0000002010120000), 0x1.00809p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefedffff), -0x1.0080900008p+37, 0x0p+0 },
{ INT64_C(0x0000002010400000), 0x1.0082p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefbfffff), -0x1.0082000008p+37, 0x0p+0 },
{ INT64_C(0x0000002010400004), 0x1.008200002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefbffffb), -0x1.0082000028p+37, 0x0p+0 },
{ INT64_C(0x0000002010400008), 0x1.008200004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefbffff7), -0x1.0082000048p+37, 0x0p+0 },
{ INT64_C(0x0000002010400080), 0x1.00820004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefbfff7f), -0x1.0082000408p+37, 0x0p+0 },
{ INT64_C(0x0000002010400400), 0x1.0082002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefbffbff), -0x1.0082002008p+37, 0x0p+0 },
{ INT64_C(0x0000002010402000), 0x1.008201p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefbfdfff), -0x1.0082010008p+37, 0x0p+0 },
{ INT64_C(0x0000002010408000), 0x1.008204p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefbf7fff), -0x1.0082040008p+37, 0x0p+0 },
{ INT64_C(0x0000002010480000), 0x1.00824p+37, 0x0p+0 },
{ INT64_C(0xffffffdfefb7ffff), -0x1.0082400008p+37, 0x0p+0 },
{ INT64_C(0x0000002014000000), 0x1.00ap+37, 0x0p+0 },
{ INT64_C(0xffffffdfebffffff), -0x1.00a0000008p+37, 0x0p+0 },
{ INT64_C(0x0000002014000008), 0x1.00a000004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfebfffff7), -0x1.00a0000048p+37, 0x0p+0 },
{ INT64_C(0x0000002014000010), 0x1.00a000008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfebffffef), -0x1.00a0000088p+37, 0x0p+0 },
{ INT64_C(0x0000002014000100), 0x1.00a00008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfebfffeff), -0x1.00a0000808p+37, 0x0p+0 },
{ INT64_C(0x0000002014000400), 0x1.00a0002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfebfffbff), -0x1.00a0002008p+37, 0x0p+0 },
{ INT64_C(0x0000002014004000), 0x1.00a002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfebffbfff), -0x1.00a0020008p+37, 0x0p+0 },
{ INT64_C(0x0000002014008000), 0x1.00a004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfebff7fff), -0x1.00a0040008p+37, 0x0p+0 },
{ INT64_C(0x0000002014020000), 0x1.00a01p+37, 0x0p+0 },
{ INT64_C(0xffffffdfebfdffff), -0x1.00a0100008p+37, 0x0p+0 },
{ INT64_C(0x0000002014100000), 0x1.00a08p+37, 0x0p+0 },
{ INT64_C(0xffffffdfebefffff), -0x1.00a0800008p+37, 0x0p+0 },
{ INT64_C(0x0000002015000000), 0x1.00a8p+37, 0x0p+0 },
{ INT64_C(0xffffffdfeaffffff), -0x1.00a8000008p+37, 0x0p+0 },
{ INT64_C(0x0000002016000000), 0x1.00bp+37, 0x0p+0 },
{ INT64_C(0xffffffdfe9ffffff), -0x1.00b0000008p+37, 0x0p+0 },
{ INT64_C(0x0000002020000004), 0x1.010000002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffffffb), -0x1.0100000028p+37, 0x0p+0 },
{ INT64_C(0x0000002020000006), 0x1.010000003p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffffff9), -0x1.0100000038p+37, 0x0p+0 },
{ INT64_C(0x0000002020000040), 0x1.01000002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfffffbf), -0x1.0100000208p+37, 0x0p+0 },
{ INT64_C(0x0000002020000041), 0x1.0100000208p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfffffbe), -0x1.010000021p+37, 0x0p+0 },
{ INT64_C(0x0000002020000044), 0x1.010000022p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfffffbb), -0x1.0100000228p+37, 0x0p+0 },
{ INT64_C(0x0000002020000050), 0x1.010000028p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfffffaf), -0x1.0100000288p+37, 0x0p+0 },
{ INT64_C(0x0000002020000400), 0x1.0100002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffffbff), -0x1.0100002008p+37, 0x0p+0 },
{ INT64_C(0x0000002020000401), 0x1.0100002008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffffbfe), -0x1.010000201p+37, 0x0p+0 },
{ INT64_C(0x0000002020000410), 0x1.010000208p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffffbef), -0x1.0100002088p+37, 0x0p+0 },
{ INT64_C(0x0000002020000440), 0x1.01000022p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffffbbf), -0x1.0100002208p+37, 0x0p+0 },
{ INT64_C(0x0000002020000800), 0x1.0100004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffff7ff), -0x1.0100004008p+37, 0x0p+0 },
{ INT64_C(0x0000002020000801), 0x1.0100004008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffff7fe), -0x1.010000401p+37, 0x0p+0 },
{ INT64_C(0x0000002020000804), 0x1.010000402p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffff7fb), -0x1.0100004028p+37, 0x0p+0 },
{ INT64_C(0x0000002020000808), 0x1.010000404p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffff7f7), -0x1.0100004048p+37, 0x0p+0 },
{ INT64_C(0x0000002020000820), 0x1.01000041p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffff7df), -0x1.0100004108p+37, 0x0p+0 },
{ INT64_C(0x0000002020000880), 0x1.01000044p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffff77f), -0x1.0100004408p+37, 0x0p+0 },
{ INT64_C(0x0000002020000900), 0x1.01000048p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffff6ff), -0x1.0100004808p+37, 0x0p+0 },
{ INT64_C(0x0000002020004000), 0x1.010002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfffbfff), -0x1.0100020008p+37, 0x0p+0 },
{ INT64_C(0x0000002020004002), 0x1.010002001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfffbffd), -0x1.0100020018p+37, 0x0p+0 },
{ INT64_C(0x0000002020004010), 0x1.010002008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfffbfef), -0x1.0100020088p+37, 0x0p+0 },
{ INT64_C(0x0000002020004020), 0x1.01000201p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfffbfdf), -0x1.0100020108p+37, 0x0p+0 },
{ INT64_C(0x0000002020004100), 0x1.01000208p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfffbeff), -0x1.0100020808p+37, 0x0p+0 },
{ INT64_C(0x0000002020005000), 0x1.0100028p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfffafff), -0x1.0100028008p+37, 0x0p+0 },
{ INT64_C(0x0000002020008000), 0x1.010004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfff7fff), -0x1.0100040008p+37, 0x0p+0 },
{ INT64_C(0x0000002020008008), 0x1.010004004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfff7ff7), -0x1.0100040048p+37, 0x0p+0 },
{ INT64_C(0x0000002020008040), 0x1.01000402p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfff7fbf), -0x1.0100040208p+37, 0x0p+0 },
{ INT64_C(0x0000002020008400), 0x1.0100042p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfff7bff), -0x1.0100042008p+37, 0x0p+0 },
{ INT64_C(0x000000202000a000), 0x1.010005p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfff5fff), -0x1.0100050008p+37, 0x0p+0 },
{ INT64_C(0x000000202000c000), 0x1.010006p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfff3fff), -0x1.0100060008p+37, 0x0p+0 },
{ INT64_C(0x0000002020020000), 0x1.01001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffdffff), -0x1.0100100008p+37, 0x0p+0 },
{ INT64_C(0x0000002020020004), 0x1.010010002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffdfffb), -0x1.0100100028p+37, 0x0p+0 },
{ INT64_C(0x0000002020020020), 0x1.01001001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffdffdf), -0x1.0100100108p+37, 0x0p+0 },
{ INT64_C(0x0000002020020200), 0x1.0100101p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffdfdff), -0x1.0100101008p+37, 0x0p+0 },
{ INT64_C(0x0000002020022000), 0x1.010011p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffddfff), -0x1.0100110008p+37, 0x0p+0 },
{ INT64_C(0x0000002020024000), 0x1.010012p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffdbfff), -0x1.0100120008p+37, 0x0p+0 },
{ INT64_C(0x0000002020040000), 0x1.01002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffbffff), -0x1.0100200008p+37, 0x0p+0 },
{ INT64_C(0x0000002020040008), 0x1.010020004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffbfff7), -0x1.0100200048p+37, 0x0p+0 },
{ INT64_C(0x0000002020040020), 0x1.01002001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffbffdf), -0x1.0100200108p+37, 0x0p+0 },
{ INT64_C(0x0000002020040080), 0x1.01002004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffbff7f), -0x1.0100200408p+37, 0x0p+0 },
{ INT64_C(0x0000002020040400), 0x1.0100202p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffbfbff), -0x1.0100202008p+37, 0x0p+0 },
{ INT64_C(0x0000002020040800), 0x1.0100204p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffbf7ff), -0x1.0100204008p+37, 0x0p+0 },
{ INT64_C(0x0000002020041000), 0x1.0100208p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffbefff), -0x1.0100208008p+37, 0x0p+0 },
{ INT64_C(0x0000002020048000), 0x1.010024p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdffb7fff), -0x1.0100240008p+37, 0x0p+0 },
{ INT64_C(0x0000002020060000), 0x1.01003p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdff9ffff), -0x1.0100300008p+37, 0x0p+0 },
{ INT64_C(0x0000002020100000), 0x1.01008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfefffff), -0x1.0100800008p+37, 0x0p+0 },
{ INT64_C(0x0000002020100002), 0x1.010080001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfeffffd), -0x1.0100800018p+37, 0x0p+0 },
{ INT64_C(0x0000002020100008), 0x1.010080004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfeffff7), -0x1.0100800048p+37, 0x0p+0 },
{ INT64_C(0x0000002020100080), 0x1.01008004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfefff7f), -0x1.0100800408p+37, 0x0p+0 },
{ INT64_C(0x0000002020100100), 0x1.01008008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfeffeff), -0x1.0100800808p+37, 0x0p+0 },
{ INT64_C(0x0000002020100200), 0x1.0100801p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfeffdff), -0x1.0100801008p+37, 0x0p+0 },
{ INT64_C(0x0000002020101000), 0x1.0100808p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfefefff), -0x1.0100808008p+37, 0x0p+0 },
{ INT64_C(0x0000002020102000), 0x1.010081p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfefdfff), -0x1.0100810008p+37, 0x0p+0 },
{ INT64_C(0x0000002020108000), 0x1.010084p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfef7fff), -0x1.0100840008p+37, 0x0p+0 },
{ INT64_C(0x0000002020140000), 0x1.0100ap+37, 0x0p+0 },
{ INT64_C(0xffffffdfdfebffff), -0x1.0100a00008p+37, 0x0p+0 },
{ INT64_C(0x0000002020800000), 0x1.0104p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdf7fffff), -0x1.0104000008p+37, 0x0p+0 },
{ INT64_C(0x0000002020800001), 0x1.0104000008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdf7ffffe), -0x1.010400001p+37, 0x0p+0 },
{ INT64_C(0x0000002020800004), 0x1.010400002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdf7ffffb), -0x1.0104000028p+37, 0x0p+0 },
{ INT64_C(0x0000002020800040), 0x1.01040002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdf7fffbf), -0x1.0104000208p+37, 0x0p+0 },
{ INT64_C(0x0000002020800080), 0x1.01040004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdf7fff7f), -0x1.0104000408p+37, 0x0p+0 },
{ INT64_C(0x0000002020800400), 0x1.0104002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdf7ffbff), -0x1.0104002008p+37, 0x0p+0 },
{ INT64_C(0x0000002020802000), 0x1.010401p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdf7fdfff), -0x1.0104010008p+37, 0x0p+0 },
{ INT64_C(0x0000002020808000), 0x1.010404p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdf7f7fff), -0x1.0104040008p+37, 0x0p+0 },
{ INT64_C(0x0000002020810000), 0x1.010408p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdf7effff), -0x1.0104080008p+37, 0x0p+0 },
{ INT64_C(0x0000002020900000), 0x1.01048p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdf6fffff), -0x1.0104800008p+37, 0x0p+0 },
{ INT64_C(0x0000002021000000), 0x1.0108p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdeffffff), -0x1.0108000008p+37, 0x0p+0 },
{ INT64_C(0x0000002021000001), 0x1.0108000008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdefffffe), -0x1.010800001p+37, 0x0p+0 },
{ INT64_C(0x0000002021000004), 0x1.010800002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdefffffb), -0x1.0108000028p+37, 0x0p+0 },
{ INT64_C(0x0000002021000020), 0x1.01080001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdeffffdf), -0x1.0108000108p+37, 0x0p+0 },
{ INT64_C(0x0000002021000040), 0x1.01080002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdeffffbf), -0x1.0108000208p+37, 0x0p+0 },
{ INT64_C(0x0000002021000400), 0x1.0108002p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdefffbff), -0x1.0108002008p+37, 0x0p+0 },
{ INT64_C(0x0000002021001000), 0x1.0108008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdeffefff), -0x1.0108008008p+37, 0x0p+0 },
{ INT64_C(0x0000002021010000), 0x1.010808p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdefeffff), -0x1.0108080008p+37, 0x0p+0 },
{ INT64_C(0x0000002021100000), 0x1.01088p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdeefffff), -0x1.0108800008p+37, 0x0p+0 },
{ INT64_C(0x0000002021400000), 0x1.010ap+37, 0x0p+0 },
{ INT64_C(0xffffffdfdebfffff), -0x1.010a000008p+37, 0x0p+0 },
{ INT64_C(0x0000002024000000), 0x1.012p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdbffffff), -0x1.0120000008p+37, 0x0p+0 },
{ INT64_C(0x0000002024000001), 0x1.0120000008p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdbfffffe), -0x1.012000001p+37, 0x0p+0 },
{ INT64_C(0x0000002024000002), 0x1.012000001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdbfffffd), -0x1.0120000018p+37, 0x0p+0 },
{ INT64_C(0x0000002024000008), 0x1.012000004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdbfffff7), -0x1.0120000048p+37, 0x0p+0 },
{ INT64_C(0x0000002024000080), 0x1.01200004p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdbffff7f), -0x1.0120000408p+37, 0x0p+0 },
{ INT64_C(0x0000002024000200), 0x1.0120001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdbfffdff), -0x1.0120001008p+37, 0x0p+0 },
{ INT64_C(0x0000002024002000), 0x1.012001p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdbffdfff), -0x1.0120010008p+37, 0x0p+0 },
{ INT64_C(0x0000002024020000), 0x1.01201p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdbfdffff), -0x1.0120100008p+37, 0x0p+0 },
{ INT64_C(0x0000002024200000), 0x1.0121p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdbdfffff), -0x1.0121000008p+37, 0x0p+0 },
{ INT64_C(0x0000002024400000), 0x1.0122p+37, 0x0p+0 },
{ INT64_C(0xffffffdfdbbfffff), -0x1.0122000008p+37, 0x0p+0 },
{ INT64_C(0x0000002200000008), 0x1.100000004p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffffff7), -0x1.1000000048p+37, 0x0p+0 },
{ INT64_C(0x0000002200000009), 0x1.1000000048p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffffff6), -0x1.100000005p+37, 0x0p+0 },
{ INT64_C(0x0000002200000010), 0x1.100000008p+37, 0x0p+0 },
{ INT64_C(0xffffffddffffffef), -0x1.1000000088p+37, 0x0p+0 },
{ INT64_C(0x0000002200000012), 0x1.100000009p+37, 0x0p+0 },
{ INT64_C(0xffffffddffffffed), -0x1.1000000098p+37, 0x0p+0 },
{ INT64_C(0x0000002200000014), 0x1.10000000ap+37, 0x0p+0 },
{ INT64_C(0xffffffddffffffeb), -0x1.10000000a8p+37, 0x0p+0 },
{ INT64_C(0x0000002200000040), 0x1.10000002p+37, 0x0p+0 },
{ INT64_C(0xffffffddffffffbf), -0x1.1000000208p+37, 0x0p+0 },
{ INT64_C(0x0000002200000048), 0x1.100000024p+37, 0x0p+0 },
{ INT64_C(0xffffffddffffffb7), -0x1.1000000248p+37, 0x0p+0 },
{ INT64_C(0x0000002200000060), 0x1.10000003p+37, 0x0p+0 },
{ INT64_C(0xffffffddffffff9f), -0x1.1000000308p+37, 0x0p+0 },
{ INT64_C(0x0000002200000100), 0x1.10000008p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffffeff), -0x1.1000000808p+37, 0x0p+0 },
{ INT64_C(0x0000002200000101), 0x1.1000000808p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffffefe), -0x1.100000081p+37, 0x0p+0 },
{ INT64_C(0x0000002200000104), 0x1.100000082p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffffefb), -0x1.1000000828p+37, 0x0p+0 },
{ INT64_C(0x0000002200000140), 0x1.1000000ap+37, 0x0p+0 },
{ INT64_C(0xffffffddfffffebf), -0x1.1000000a08p+37, 0x0p+0 },
{ INT64_C(0x0000002200000800), 0x1.1000004p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffff7ff), -0x1.1000004008p+37, 0x0p+0 },
{ INT64_C(0x0000002200000802), 0x1.100000401p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffff7fd), -0x1.1000004018p+37, 0x0p+0 },
{ INT64_C(0x0000002200000820), 0x1.10000041p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffff7df), -0x1.1000004108p+37, 0x0p+0 },
{ INT64_C(0x0000002200000840), 0x1.10000042p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffff7bf), -0x1.1000004208p+37, 0x0p+0 },
{ INT64_C(0x0000002200000c00), 0x1.1000006p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffff3ff), -0x1.1000006008p+37, 0x0p+0 },
{ INT64_C(0x0000002200008000), 0x1.100004p+37, 0x0p+0 },
{ INT64_C(0xffffffddffff7fff), -0x1.1000040008p+37, 0x0p+0 },
{ INT64_C(0x0000002200008001), 0x1.1000040008p+37, 0x0p+0 },
{ INT64_C(0xffffffddffff7ffe), -0x1.100004001p+37, 0x0p+0 },
{ INT64_C(0x0000002200008008), 0x1.100004004p+37, 0x0p+0 },
{ INT64_C(0xffffffddffff7ff7), -0x1.1000040048p+37, 0x0p+0 },
{ INT64_C(0x0000002200008010), 0x1.100004008p+37, 0x0p+0 },
{ INT64_C(0xffffffddffff7fef), -0x1.1000040088p+37, 0x0p+0 },
{ INT64_C(0x0000002200008100), 0x1.10000408p+37, 0x0p+0 },
{ INT64_C(0xffffffddffff7eff), -0x1.1000040808p+37, 0x0p+0 },
{ INT64_C(0x0000002200008800), 0x1.1000044p+37, 0x0p+0 },
{ INT64_C(0xffffffddffff77ff), -0x1.1000044008p+37, 0x0p+0 },
{ INT64_C(0x000000220000c000), 0x1.100006p+37, 0x0p+0 },
{ INT64_C(0xffffffddffff3fff), -0x1.1000060008p+37, 0x0p+0 },
{ INT64_C(0x0000002200040000), 0x1.10002p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffbffff), -0x1.1000200008p+37, 0x0p+0 },
{ INT64_C(0x0000002200040008), 0x1.100020004p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffbfff7), -0x1.1000200048p+37, 0x0p+0 },
{ INT64_C(0x0000002200040080), 0x1.10002004p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffbff7f), -0x1.1000200408p+37, 0x0p+0 },
{ INT64_C(0x0000002200040200), 0x1.1000201p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffbfdff), -0x1.1000201008p+37, 0x0p+0 },
{ INT64_C(0x0000002200041000), 0x1.1000208p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffbefff), -0x1.1000208008p+37, 0x0p+0 },
{ INT64_C(0x0000002200050000), 0x1.100028p+37, 0x0p+0 },
{ INT64_C(0xffffffddfffaffff), -0x1.1000280008p+37, 0x0p+0 },
{ INT64_C(0x0000002200060000), 0x1.10003p+37, 0x0p+0 },
{ INT64_C(0xffffffddfff9ffff), -0x1.1000300008p+37, 0x0p+0 },
{ INT64_C(0x0000002200100000), 0x1.10008p+37, 0x0p+0 },
{ INT64_C(0xffffffddffefffff), -0x1.1000800008p+37, 0x0p+0 },
{ INT64_C(0x0000002200100004), 0x1.100080002p+37, 0x0p+0 },
{ INT64_C(0xffffffddffeffffb), -0x1.1000800028p+37, 0x0p+0 },
{ INT64_C(0x0000002200100020), 0x1.10008001p+37, 0x0p+0 },
{ INT64_C(0xffffffddffefffdf), -0x1.1000800108p+37, 0x0p+0 },
{ INT64_C(0x0000002200100080), 0x1.10008004p+37, 0x0p+0 },
{ INT64_C(0xffffffddffefff7f), -0x1.1000800408p+37, 0x0p+0 },
{ INT64_C(0x0000002200100200), 0x1.1000801p+37, 0x0p+0 },
{ INT64_C(0xffffffddffeffdff), -0x1.1000801008p+37, 0x0p+0 },
{ INT64_C(0x0000002200102000), 0x1.100081p+37, 0x0p+0 },
{ INT64_C(0xffffffddffefdfff), -0x1.1000810008p+37, 0x0p+0 },
{ INT64_C(0x0000002200104000), 0x1.100082p+37, 0x0p+0 },
{ INT64_C(0xffffffddffefbfff), -0x1.1000820008p+37, 0x0p+0 },
{ INT64_C(0x0000002200120000), 0x1.10009p+37, 0x0p+0 },
{ INT64_C(0xffffffddffedffff), -0x1.1000900008p+37, 0x0p+0 },
{ INT64_C(0x0000002200400000), 0x1.1002p+37, 0x0p+0 },
{ INT64_C(0xffffffddffbfffff), -0x1.1002000008p+37, 0x0p+0 },
{ INT64_C(0x0000002200400001), 0x1.1002000008p+37, 0x0p+0 },
{ INT64_C(0xffffffddffbffffe), -0x1.100200001p+37, 0x0p+0 },
{ INT64_C(0x0000002200400002), 0x1.100200001p+37, 0x0p+0 },
{ INT64_C(0xffffffddffbffffd), -0x1.1002000018p+37, 0x0p+0 },
{ INT64_C(0x0000002200400010), 0x1.100200008p+37, 0x0p+0 },
{ INT64_C(0xffffffddffbfffef), -0x1.1002000088p+37, 0x0p+0 },
{ INT64_C(0x0000002200400020), 0x1.10020001p+37, 0x0p+0 },
{ INT64_C(0xffffffddffbfffdf), -0x1.1002000108p+37, 0x0p+0 },
{ INT64_C(0x0000002200400100), 0x1.10020008p+37, 0x0p+0 },
{ INT64_C(0xffffffddffbffeff), -0x1.1002000808p+37, 0x0p+0 },
{ INT64_C(0x0000002200400400), 0x1.1002002p+37, 0x0p+0 },
{ INT64_C(0xffffffddffbffbff), -0x1.1002002008p+37, 0x0p+0 },
{ INT64_C(0x0000002200404000), 0x1.100202p+37, 0x0p+0 },
{ INT64_C(0xffffffddffbfbfff), -0x1.1002020008p+37, 0x0p+0 },
{ INT64_C(0x0000002200408000), 0x1.100204p+37, 0x0p+0 },
{ INT64_C(0xffffffddffbf7fff), -0x1.1002040008p+37, 0x0p+0 },
{ INT64_C(0x0000002200410000), 0x1.100208p+37, 0x0p+0 },
{ INT64_C(0xffffffddffbeffff), -0x1.1002080008p+37, 0x0p+0 },
{ INT64_C(0x0000002200500000), 0x1.10028p+37, 0x0p+0 },
{ INT64_C(0xffffffddffafffff), -0x1.1002800008p+37, 0x0p+0 },
{ INT64_C(0x0000002204000000), 0x1.102p+37, 0x0p+0 },
{ INT64_C(0xffffffddfbffffff), -0x1.1020000008p+37, 0x0p+0 },
{ INT64_C(0x0000002204000004), 0x1.102000002p+37, 0x0p+0 },
{ INT64_C(0xffffffddfbfffffb), -0x1.1020000028p+37, 0x0p+0 },
{ INT64_C(0x0000002204000010), 0x1.102000008p+37, 0x0p+0 },
{ INT64_C(0xffffffddfbffffef), -0x1.1020000088p+37, 0x0p+0 },
{ INT64_C(0x0000002204000040), 0x1.10200002p+37, 0x0p+0 },
{ INT64_C(0xffffffddfbffffbf), -0x1.1020000208p+37, 0x0p+0 },
{ INT64_C(0x0000002204000400), 0x1.1020002p+37, 0x0p+0 },
{ INT64_C(0xffffffddfbfffbff), -0x1.1020002008p+37, 0x0p+0 },
{ INT64_C(0x0000002204004000), 0x1.102002p+37, 0x0p+0 },
{ INT64_C(0xffffffddfbffbfff), -0x1.1020020008p+37, 0x0p+0 },
{ INT64_C(0x0000002204010000), 0x1.102008p+37, 0x0p+0 },
{ INT64_C(0xffffffddfbfeffff), -0x1.1020080008p+37, 0x0p+0 },
{ INT64_C(0x0000002204080000), 0x1.10204p+37, 0x0p+0 },
{ INT64_C(0xffffffddfbf7ffff), -0x1.1020400008p+37, 0x0p+0 },
{ INT64_C(0x0000002204800000), 0x1.1024p+37, 0x0p+0 },
{ INT64_C(0xffffffddfb7fffff), -0x1.1024000008p+37, 0x0p+0 },
{ INT64_C(0x0000002220000000), 0x1.11p+37, 0x0p+0 },
{ INT64_C(0xffffffdddfffffff), -0x1.1100000008p+37, 0x0p+0 },
{ INT64_C(0x0000002220000008), 0x1.110000004p+37, 0x0p+0 },
{ INT64_C(0xffffffdddffffff7), -0x1.1100000048p+37, 0x0p+0 },
{ INT64_C(0x0000002220000080), 0x1.11000004p+37, 0x0p+0 },
{ INT64_C(0xffffffdddfffff7f), -0x1.1100000408p+37, 0x0p+0 },
{ INT64_C(0x0000002220000100), 0x1.11000008p+37, 0x0p+0 },
{ INT64_C(0xffffffdddffffeff), -0x1.1100000808p+37, 0x0p+0 },
{ INT64_C(0x0000002220000400), 0x1.1100002p+37, 0x0p+0 },
{ INT64_C(0xffffffdddffffbff), -0x1.1100002008p+37, 0x0p+0 },
{ INT64_C(0x0000002220000800), 0x1.1100004p+37, 0x0p+0 },
{ INT64_C(0xffffffdddffff7ff), -0x1.1100004008p+37, 0x0p+0 },
{ INT64_C(0x0000002220001000), 0x1.1100008p+37, 0x0p+0 },
{ INT64_C(0xffffffdddfffefff), -0x1.1100008008p+37, 0x0p+0 },
{ INT64_C(0x0000002220010000), 0x1.110008p+37, 0x0p+0 },
{ INT64_C(0xffffffdddffeffff), -0x1.1100080008p+37, 0x0p+0 },
{ INT64_C(0x0000002220020000), 0x1.11001p+37, 0x0p+0 },
{ INT64_C(0xffffffdddffdffff), -0x1.1100100008p+37, 0x0p+0 },
{ INT64_C(0x0000002220040000), 0x1.11002p+37, 0x0p+0 },
{ INT64_C(0xffffffdddffbffff), -0x1.1100200008p+37, 0x0p+0 },
{ INT64_C(0x0000002220080000), 0x1.11004p+37, 0x0p+0 },
{ INT64_C(0xffffffdddff7ffff), -0x1.1100400008p+37, 0x0p+0 },
{ INT64_C(0x0000002220400000), 0x1.1102p+37, 0x0p+0 },
{ INT64_C(0xffffffdddfbfffff), -0x1.1102000008p+37, 0x0p+0 },
{ INT64_C(0x0000002224000000), 0x1.112p+37, 0x0p+0 },
{ INT64_C(0xffffffdddbffffff), -0x1.1120000008p+37, 0x0p+0 },
{ INT64_C(0x0000002228000000), 0x1.114p+37, 0x0p+0 },
{ INT64_C(0xffffffddd7ffffff), -0x1.1140000008p+37, 0x0p+0 },
{ INT64_C(0x0000002230000000), 0x1.118p+37, 0x0p+0 },
{ INT64_C(0xffffffddcfffffff), -0x1.1180000008p+37, 0x0p+0 },
{ INT64_C(0x0000004000000005), 0x1.0000000014p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffffffa), -0x1.0000000018p+38, 0x0p+0 },
{ INT64_C(0x0000004000000006), 0x1.0000000018p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffffff9), -0x1.000000001cp+38, 0x0p+0 },
{ INT64_C(0x0000004000000021), 0x1.0000000084p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffffffde), -0x1.0000000088p+38, 0x0p+0 },
{ INT64_C(0x0000004000000022), 0x1.0000000088p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffffffdd), -0x1.000000008cp+38, 0x0p+0 },
{ INT64_C(0x0000004000000023), 0x1.000000008cp+38, 0x0p+0 },
{ INT64_C(0xffffffbfffffffdc), -0x1.000000009p+38, 0x0p+0 },
{ INT64_C(0x0000004000000048), 0x1.000000012p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffffffb7), -0x1.0000000124p+38, 0x0p+0 },
{ INT64_C(0x000000400000004c), 0x1.000000013p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffffffb3), -0x1.0000000134p+38, 0x0p+0 },
{ INT64_C(0x0000004000000084), 0x1.000000021p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffffff7b), -0x1.0000000214p+38, 0x0p+0 },
{ INT64_C(0x0000004000000086), 0x1.0000000218p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffffff79), -0x1.000000021cp+38, 0x0p+0 },
{ INT64_C(0x0000004000000090), 0x1.000000024p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffffff6f), -0x1.0000000244p+38, 0x0p+0 },
{ INT64_C(0x0000004000000098), 0x1.000000026p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffffff67), -0x1.0000000264p+38, 0x0p+0 },
{ INT64_C(0x0000004000000108), 0x1.000000042p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffffef7), -0x1.0000000424p+38, 0x0p+0 },
{ INT64_C(0x0000004000000109), 0x1.0000000424p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffffef6), -0x1.0000000428p+38, 0x0p+0 },
{ INT64_C(0x000000400000010a), 0x1.0000000428p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffffef5), -0x1.000000042cp+38, 0x0p+0 },
{ INT64_C(0x000000400000010c), 0x1.000000043p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffffef3), -0x1.0000000434p+38, 0x0p+0 },
{ INT64_C(0x0000004000000120), 0x1.000000048p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffffedf), -0x1.0000000484p+38, 0x0p+0 },
{ INT64_C(0x0000004000000121), 0x1.0000000484p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffffede), -0x1.0000000488p+38, 0x0p+0 },
{ INT64_C(0x0000004000000128), 0x1.00000004ap+38, 0x0p+0 },
{ INT64_C(0xffffffbffffffed7), -0x1.00000004a4p+38, 0x0p+0 },
{ INT64_C(0x0000004000000130), 0x1.00000004cp+38, 0x0p+0 },
{ INT64_C(0xffffffbffffffecf), -0x1.00000004c4p+38, 0x0p+0 },
{ INT64_C(0x0000004000000180), 0x1.00000006p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffffe7f), -0x1.0000000604p+38, 0x0p+0 },
{ INT64_C(0x0000004000000188), 0x1.000000062p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffffe77), -0x1.0000000624p+38, 0x0p+0 },
{ INT64_C(0x0000004000000808), 0x1.000000202p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff7f7), -0x1.0000002024p+38, 0x0p+0 },
{ INT64_C(0x000000400000080a), 0x1.0000002028p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff7f5), -0x1.000000202cp+38, 0x0p+0 },
{ INT64_C(0x0000004000000820), 0x1.000000208p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff7df), -0x1.0000002084p+38, 0x0p+0 },
{ INT64_C(0x0000004000000822), 0x1.0000002088p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff7dd), -0x1.000000208cp+38, 0x0p+0 },
{ INT64_C(0x0000004000000828), 0x1.00000020ap+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff7d7), -0x1.00000020a4p+38, 0x0p+0 },
{ INT64_C(0x0000004000000830), 0x1.00000020cp+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff7cf), -0x1.00000020c4p+38, 0x0p+0 },
{ INT64_C(0x0000004000000840), 0x1.00000021p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff7bf), -0x1.0000002104p+38, 0x0p+0 },
{ INT64_C(0x0000004000000844), 0x1.000000211p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff7bb), -0x1.0000002114p+38, 0x0p+0 },
{ INT64_C(0x0000004000000a00), 0x1.00000028p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff5ff), -0x1.0000002804p+38, 0x0p+0 },
{ INT64_C(0x0000004000000a02), 0x1.0000002808p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff5fd), -0x1.000000280cp+38, 0x0p+0 },
{ INT64_C(0x0000004000000a04), 0x1.000000281p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff5fb), -0x1.0000002814p+38, 0x0p+0 },
{ INT64_C(0x0000004000000a40), 0x1.00000029p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff5bf), -0x1.0000002904p+38, 0x0p+0 },
{ INT64_C(0x0000004000000c00), 0x1.0000003p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff3ff), -0x1.0000003004p+38, 0x0p+0 },
{ INT64_C(0x0000004000000c08), 0x1.000000302p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff3f7), -0x1.0000003024p+38, 0x0p+0 },
{ INT64_C(0x0000004000000c20), 0x1.000000308p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff3df), -0x1.0000003084p+38, 0x0p+0 },
{ INT64_C(0x0000004000000c40), 0x1.00000031p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff3bf), -0x1.0000003104p+38, 0x0p+0 },
{ INT64_C(0x0000004000000d00), 0x1.00000034p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffff2ff), -0x1.0000003404p+38, 0x0p+0 },
{ INT64_C(0x0000004000008004), 0x1.000002001p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff7ffb), -0x1.0000020014p+38, 0x0p+0 },
{ INT64_C(0x0000004000008006), 0x1.0000020018p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff7ff9), -0x1.000002001cp+38, 0x0p+0 },
{ INT64_C(0x0000004000008040), 0x1.00000201p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff7fbf), -0x1.0000020104p+38, 0x0p+0 },
{ INT64_C(0x0000004000008048), 0x1.000002012p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff7fb7), -0x1.0000020124p+38, 0x0p+0 },
{ INT64_C(0x0000004000008060), 0x1.000002018p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff7f9f), -0x1.0000020184p+38, 0x0p+0 },
{ INT64_C(0x0000004000008100), 0x1.00000204p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff7eff), -0x1.0000020404p+38, 0x0p+0 },
{ INT64_C(0x0000004000008104), 0x1.000002041p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff7efb), -0x1.0000020414p+38, 0x0p+0 },
{ INT64_C(0x0000004000008110), 0x1.000002044p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff7eef), -0x1.0000020444p+38, 0x0p+0 },
{ INT64_C(0x0000004000008120), 0x1.000002048p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff7edf), -0x1.0000020484p+38, 0x0p+0 },
{ INT64_C(0x0000004000009000), 0x1.0000024p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff6fff), -0x1.0000024004p+38, 0x0p+0 },
{ INT64_C(0x0000004000009002), 0x1.0000024008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff6ffd), -0x1.000002400cp+38, 0x0p+0 },
{ INT64_C(0x0000004000009020), 0x1.000002408p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff6fdf), -0x1.0000024084p+38, 0x0p+0 },
{ INT64_C(0x0000004000009080), 0x1.00000242p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff6f7f), -0x1.0000024204p+38, 0x0p+0 },
{ INT64_C(0x0000004000009200), 0x1.00000248p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff6dff), -0x1.0000024804p+38, 0x0p+0 },
{ INT64_C(0x0000004000009400), 0x1.0000025p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff6bff), -0x1.0000025004p+38, 0x0p+0 },
{ INT64_C(0x000000400000c000), 0x1.000003p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff3fff), -0x1.0000030004p+38, 0x0p+0 },
{ INT64_C(0x000000400000c004), 0x1.000003001p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff3ffb), -0x1.0000030014p+38, 0x0p+0 },
{ INT64_C(0x000000400000c020), 0x1.000003008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff3fdf), -0x1.0000030084p+38, 0x0p+0 },
{ INT64_C(0x000000400000c100), 0x1.00000304p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff3eff), -0x1.0000030404p+38, 0x0p+0 },
{ INT64_C(0x000000400000c400), 0x1.0000031p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff3bff), -0x1.0000031004p+38, 0x0p+0 },
{ INT64_C(0x000000400000d000), 0x1.0000034p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffff2fff), -0x1.0000034004p+38, 0x0p+0 },
{ INT64_C(0x0000004000010004), 0x1.000004001p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffefffb), -0x1.0000040014p+38, 0x0p+0 },
{ INT64_C(0x0000004000010005), 0x1.0000040014p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffefffa), -0x1.0000040018p+38, 0x0p+0 },
{ INT64_C(0x0000004000010006), 0x1.0000040018p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffefff9), -0x1.000004001cp+38, 0x0p+0 },
{ INT64_C(0x0000004000010010), 0x1.000004004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffeffef), -0x1.0000040044p+38, 0x0p+0 },
{ INT64_C(0x0000004000010018), 0x1.000004006p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffeffe7), -0x1.0000040064p+38, 0x0p+0 },
{ INT64_C(0x0000004000010100), 0x1.00000404p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffefeff), -0x1.0000040404p+38, 0x0p+0 },
{ INT64_C(0x0000004000010108), 0x1.000004042p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffefef7), -0x1.0000040424p+38, 0x0p+0 },
{ INT64_C(0x0000004000010110), 0x1.000004044p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffefeef), -0x1.0000040444p+38, 0x0p+0 },
{ INT64_C(0x0000004000010400), 0x1.0000041p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffefbff), -0x1.0000041004p+38, 0x0p+0 },
{ INT64_C(0x0000004000010404), 0x1.000004101p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffefbfb), -0x1.0000041014p+38, 0x0p+0 },
{ INT64_C(0x0000004000010410), 0x1.000004104p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffefbef), -0x1.0000041044p+38, 0x0p+0 },
{ INT64_C(0x0000004000010480), 0x1.00000412p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffefb7f), -0x1.0000041204p+38, 0x0p+0 },
{ INT64_C(0x0000004000012000), 0x1.0000048p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffedfff), -0x1.0000048004p+38, 0x0p+0 },
{ INT64_C(0x0000004000012004), 0x1.000004801p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffedffb), -0x1.0000048014p+38, 0x0p+0 },
{ INT64_C(0x0000004000012040), 0x1.00000481p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffedfbf), -0x1.0000048104p+38, 0x0p+0 },
{ INT64_C(0x0000004000012400), 0x1.0000049p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffedbff), -0x1.0000049004p+38, 0x0p+0 },
{ INT64_C(0x0000004000014000), 0x1.000005p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffebfff), -0x1.0000050004p+38, 0x0p+0 },
{ INT64_C(0x0000004000014002), 0x1.0000050008p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffebffd), -0x1.000005000cp+38, 0x0p+0 },
{ INT64_C(0x0000004000014020), 0x1.000005008p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffebfdf), -0x1.0000050084p+38, 0x0p+0 },
{ INT64_C(0x0000004000014040), 0x1.00000501p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffebfbf), -0x1.0000050104p+38, 0x0p+0 },
{ INT64_C(0x0000004000014100), 0x1.00000504p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffebeff), -0x1.0000050404p+38, 0x0p+0 },
{ INT64_C(0x0000004000015000), 0x1.0000054p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffeafff), -0x1.0000054004p+38, 0x0p+0 },
{ INT64_C(0x0000004000018000), 0x1.000006p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffe7fff), -0x1.0000060004p+38, 0x0p+0 },
{ INT64_C(0x0000004000018001), 0x1.0000060004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffe7ffe), -0x1.0000060008p+38, 0x0p+0 },
{ INT64_C(0x0000004000018010), 0x1.000006004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffe7fef), -0x1.0000060044p+38, 0x0p+0 },
{ INT64_C(0x0000004000018080), 0x1.00000602p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffe7f7f), -0x1.0000060204p+38, 0x0p+0 },
{ INT64_C(0x0000004000018400), 0x1.0000061p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffe7bff), -0x1.0000061004p+38, 0x0p+0 },
{ INT64_C(0x000000400001a000), 0x1.0000068p+38, 0x0p+0 },
{ INT64_C(0xffffffbffffe5fff), -0x1.0000068004p+38, 0x0p+0 },
{ INT64_C(0x0000004000080008), 0x1.000020002p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7fff7), -0x1.0000200024p+38, 0x0p+0 },
{ INT64_C(0x0000004000080009), 0x1.0000200024p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7fff6), -0x1.0000200028p+38, 0x0p+0 },
{ INT64_C(0x0000004000080080), 0x1.00002002p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7ff7f), -0x1.0000200204p+38, 0x0p+0 },
{ INT64_C(0x0000004000080088), 0x1.000020022p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7ff77), -0x1.0000200224p+38, 0x0p+0 },
{ INT64_C(0x00000040000800a0), 0x1.000020028p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7ff5f), -0x1.0000200284p+38, 0x0p+0 },
{ INT64_C(0x0000004000080100), 0x1.00002004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7feff), -0x1.0000200404p+38, 0x0p+0 },
{ INT64_C(0x0000004000080104), 0x1.000020041p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7fefb), -0x1.0000200414p+38, 0x0p+0 },
{ INT64_C(0x0000004000080110), 0x1.000020044p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7feef), -0x1.0000200444p+38, 0x0p+0 },
{ INT64_C(0x0000004000080120), 0x1.000020048p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7fedf), -0x1.0000200484p+38, 0x0p+0 },
{ INT64_C(0x0000004000080200), 0x1.00002008p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7fdff), -0x1.0000200804p+38, 0x0p+0 },
{ INT64_C(0x0000004000080201), 0x1.0000200804p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7fdfe), -0x1.0000200808p+38, 0x0p+0 },
{ INT64_C(0x0000004000080202), 0x1.0000200808p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7fdfd), -0x1.000020080cp+38, 0x0p+0 },
{ INT64_C(0x0000004000080220), 0x1.000020088p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7fddf), -0x1.0000200884p+38, 0x0p+0 },
{ INT64_C(0x0000004000080800), 0x1.0000202p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7f7ff), -0x1.0000202004p+38, 0x0p+0 },
{ INT64_C(0x0000004000080808), 0x1.000020202p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7f7f7), -0x1.0000202024p+38, 0x0p+0 },
{ INT64_C(0x0000004000080840), 0x1.00002021p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7f7bf), -0x1.0000202104p+38, 0x0p+0 },
{ INT64_C(0x0000004000080880), 0x1.00002022p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7f77f), -0x1.0000202204p+38, 0x0p+0 },
{ INT64_C(0x0000004000080900), 0x1.00002024p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7f6ff), -0x1.0000202404p+38, 0x0p+0 },
{ INT64_C(0x0000004000081000), 0x1.0000204p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7efff), -0x1.0000204004p+38, 0x0p+0 },
{ INT64_C(0x0000004000081008), 0x1.000020402p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7eff7), -0x1.0000204024p+38, 0x0p+0 },
{ INT64_C(0x0000004000081080), 0x1.00002042p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7ef7f), -0x1.0000204204p+38, 0x0p+0 },
{ INT64_C(0x0000004000081200), 0x1.00002048p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7edff), -0x1.0000204804p+38, 0x0p+0 },
{ INT64_C(0x0000004000084000), 0x1.000021p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7bfff), -0x1.0000210004p+38, 0x0p+0 },
{ INT64_C(0x0000004000084008), 0x1.000021002p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7bff7), -0x1.0000210024p+38, 0x0p+0 },
{ INT64_C(0x0000004000084040), 0x1.00002101p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7bfbf), -0x1.0000210104p+38, 0x0p+0 },
{ INT64_C(0x0000004000084400), 0x1.0000211p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff7bbff), -0x1.0000211004p+38, 0x0p+0 },
{ INT64_C(0x00000040000a0000), 0x1.000028p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff5ffff), -0x1.0000280004p+38, 0x0p+0 },
{ INT64_C(0x00000040000a0004), 0x1.000028001p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff5fffb), -0x1.0000280014p+38, 0x0p+0 },
{ INT64_C(0x00000040000a0010), 0x1.000028004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff5ffef), -0x1.0000280044p+38, 0x0p+0 },
{ INT64_C(0x00000040000a0080), 0x1.00002802p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff5ff7f), -0x1.0000280204p+38, 0x0p+0 },
{ INT64_C(0x00000040000a0800), 0x1.0000282p+38, 0x0p+0 },
{ INT64_C(0xffffffbffff5f7ff), -0x1.0000282004p+38, 0x0p+0 },
{ INT64_C(0x00000040000a8000), 0x1.00002ap+38, 0x0p+0 },
{ INT64_C(0xffffffbffff57fff), -0x1.00002a0004p+38, 0x0p+0 },
{ INT64_C(0x00000040000b0000), 0x1.00002cp+38, 0x0p+0 },
{ INT64_C(0xffffffbffff4ffff), -0x1.00002c0004p+38, 0x0p+0 },
{ INT64_C(0x0000004000200001), 0x1.0000800004p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdffffe), -0x1.0000800008p+38, 0x0p+0 },
{ INT64_C(0x0000004000200004), 0x1.000080001p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdffffb), -0x1.0000800014p+38, 0x0p+0 },
{ INT64_C(0x0000004000200006), 0x1.0000800018p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdffff9), -0x1.000080001cp+38, 0x0p+0 },
{ INT64_C(0x0000004000200020), 0x1.000080008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdfffdf), -0x1.0000800084p+38, 0x0p+0 },
{ INT64_C(0x0000004000200024), 0x1.000080009p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdfffdb), -0x1.0000800094p+38, 0x0p+0 },
{ INT64_C(0x0000004000200200), 0x1.00008008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdffdff), -0x1.0000800804p+38, 0x0p+0 },
{ INT64_C(0x0000004000200202), 0x1.0000800808p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdffdfd), -0x1.000080080cp+38, 0x0p+0 },
{ INT64_C(0x0000004000200204), 0x1.000080081p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdffdfb), -0x1.0000800814p+38, 0x0p+0 },
{ INT64_C(0x0000004000200220), 0x1.000080088p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdffddf), -0x1.0000800884p+38, 0x0p+0 },
{ INT64_C(0x0000004000200400), 0x1.0000801p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdffbff), -0x1.0000801004p+38, 0x0p+0 },
{ INT64_C(0x0000004000200401), 0x1.0000801004p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdffbfe), -0x1.0000801008p+38, 0x0p+0 },
{ INT64_C(0x0000004000200404), 0x1.000080101p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdffbfb), -0x1.0000801014p+38, 0x0p+0 },
{ INT64_C(0x0000004000200420), 0x1.000080108p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdffbdf), -0x1.0000801084p+38, 0x0p+0 },
{ INT64_C(0x0000004000200480), 0x1.00008012p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdffb7f), -0x1.0000801204p+38, 0x0p+0 },
{ INT64_C(0x0000004000201000), 0x1.0000804p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdfefff), -0x1.0000804004p+38, 0x0p+0 },
{ INT64_C(0x0000004000201004), 0x1.000080401p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdfeffb), -0x1.0000804014p+38, 0x0p+0 },
{ INT64_C(0x0000004000201040), 0x1.00008041p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdfefbf), -0x1.0000804104p+38, 0x0p+0 },
{ INT64_C(0x0000004000201200), 0x1.00008048p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdfedff), -0x1.0000804804p+38, 0x0p+0 },
{ INT64_C(0x0000004000202000), 0x1.0000808p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdfdfff), -0x1.0000808004p+38, 0x0p+0 },
{ INT64_C(0x0000004000202002), 0x1.0000808008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdfdffd), -0x1.000080800cp+38, 0x0p+0 },
{ INT64_C(0x0000004000202020), 0x1.000080808p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdfdfdf), -0x1.0000808084p+38, 0x0p+0 },
{ INT64_C(0x0000004000202100), 0x1.00008084p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdfdeff), -0x1.0000808404p+38, 0x0p+0 },
{ INT64_C(0x0000004000203000), 0x1.000080cp+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdfcfff), -0x1.000080c004p+38, 0x0p+0 },
{ INT64_C(0x0000004000210000), 0x1.000084p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdeffff), -0x1.0000840004p+38, 0x0p+0 },
{ INT64_C(0x0000004000210008), 0x1.000084002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdefff7), -0x1.0000840024p+38, 0x0p+0 },
{ INT64_C(0x0000004000210080), 0x1.00008402p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdeff7f), -0x1.0000840204p+38, 0x0p+0 },
{ INT64_C(0x0000004000210200), 0x1.00008408p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdefdff), -0x1.0000840804p+38, 0x0p+0 },
{ INT64_C(0x0000004000210400), 0x1.0000841p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdefbff), -0x1.0000841004p+38, 0x0p+0 },
{ INT64_C(0x0000004000211000), 0x1.0000844p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdeefff), -0x1.0000844004p+38, 0x0p+0 },
{ INT64_C(0x0000004000212000), 0x1.0000848p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdedfff), -0x1.0000848004p+38, 0x0p+0 },
{ INT64_C(0x0000004000218000), 0x1.000086p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffde7fff), -0x1.0000860004p+38, 0x0p+0 },
{ INT64_C(0x0000004000220000), 0x1.000088p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffddffff), -0x1.0000880004p+38, 0x0p+0 },
{ INT64_C(0x0000004000220008), 0x1.000088002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffddfff7), -0x1.0000880024p+38, 0x0p+0 },
{ INT64_C(0x0000004000220020), 0x1.000088008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffddffdf), -0x1.0000880084p+38, 0x0p+0 },
{ INT64_C(0x0000004000220100), 0x1.00008804p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffddfeff), -0x1.0000880404p+38, 0x0p+0 },
{ INT64_C(0x0000004000220200), 0x1.00008808p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffddfdff), -0x1.0000880804p+38, 0x0p+0 },
{ INT64_C(0x0000004000220400), 0x1.0000881p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffddfbff), -0x1.0000881004p+38, 0x0p+0 },
{ INT64_C(0x0000004000222000), 0x1.0000888p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdddfff), -0x1.0000888004p+38, 0x0p+0 },
{ INT64_C(0x0000004000230000), 0x1.00008cp+38, 0x0p+0 },
{ INT64_C(0xffffffbfffdcffff), -0x1.00008c0004p+38, 0x0p+0 },
{ INT64_C(0x0000004000300000), 0x1.0000cp+38, 0x0p+0 },
{ INT64_C(0xffffffbfffcfffff), -0x1.0000c00004p+38, 0x0p+0 },
{ INT64_C(0x0000004000300004), 0x1.0000c0001p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffcffffb), -0x1.0000c00014p+38, 0x0p+0 },
{ INT64_C(0x0000004000300010), 0x1.0000c0004p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffcfffef), -0x1.0000c00044p+38, 0x0p+0 },
{ INT64_C(0x0000004000300080), 0x1.0000c002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffcfff7f), -0x1.0000c00204p+38, 0x0p+0 },
{ INT64_C(0x0000004000300100), 0x1.0000c004p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffcffeff), -0x1.0000c00404p+38, 0x0p+0 },
{ INT64_C(0x0000004000300400), 0x1.0000c01p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffcffbff), -0x1.0000c01004p+38, 0x0p+0 },
{ INT64_C(0x0000004000300800), 0x1.0000c02p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffcff7ff), -0x1.0000c02004p+38, 0x0p+0 },
{ INT64_C(0x0000004000301000), 0x1.0000c04p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffcfefff), -0x1.0000c04004p+38, 0x0p+0 },
{ INT64_C(0x0000004000310000), 0x1.0000c4p+38, 0x0p+0 },
{ INT64_C(0xffffffbfffceffff), -0x1.0000c40004p+38, 0x0p+0 },
{ INT64_C(0x0000004000340000), 0x1.0000dp+38, 0x0p+0 },
{ INT64_C(0xffffffbfffcbffff), -0x1.0000d00004p+38, 0x0p+0 },
{ INT64_C(0x0000004002000001), 0x1.0008000004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfffffe), -0x1.0008000008p+38, 0x0p+0 },
{ INT64_C(0x0000004002000010), 0x1.000800004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdffffef), -0x1.0008000044p+38, 0x0p+0 },
{ INT64_C(0x0000004002000014), 0x1.000800005p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdffffeb), -0x1.0008000054p+38, 0x0p+0 },
{ INT64_C(0x0000004002000100), 0x1.00080004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfffeff), -0x1.0008000404p+38, 0x0p+0 },
{ INT64_C(0x0000004002000108), 0x1.000800042p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfffef7), -0x1.0008000424p+38, 0x0p+0 },
{ INT64_C(0x0000004002000110), 0x1.000800044p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfffeef), -0x1.0008000444p+38, 0x0p+0 },
{ INT64_C(0x0000004002000200), 0x1.00080008p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfffdff), -0x1.0008000804p+38, 0x0p+0 },
{ INT64_C(0x0000004002000208), 0x1.000800082p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfffdf7), -0x1.0008000824p+38, 0x0p+0 },
{ INT64_C(0x0000004002000210), 0x1.000800084p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfffdef), -0x1.0008000844p+38, 0x0p+0 },
{ INT64_C(0x0000004002000240), 0x1.00080009p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfffdbf), -0x1.0008000904p+38, 0x0p+0 },
{ INT64_C(0x0000004002001000), 0x1.0008004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdffefff), -0x1.0008004004p+38, 0x0p+0 },
{ INT64_C(0x0000004002001008), 0x1.000800402p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdffeff7), -0x1.0008004024p+38, 0x0p+0 },
{ INT64_C(0x0000004002001010), 0x1.000800404p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdffefef), -0x1.0008004044p+38, 0x0p+0 },
{ INT64_C(0x0000004002001100), 0x1.00080044p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdffeeff), -0x1.0008004404p+38, 0x0p+0 },
{ INT64_C(0x0000004002001800), 0x1.0008006p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdffe7ff), -0x1.0008006004p+38, 0x0p+0 },
{ INT64_C(0x0000004002010000), 0x1.000804p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfeffff), -0x1.0008040004p+38, 0x0p+0 },
{ INT64_C(0x0000004002010001), 0x1.0008040004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfefffe), -0x1.0008040008p+38, 0x0p+0 },
{ INT64_C(0x0000004002010008), 0x1.000804002p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfefff7), -0x1.0008040024p+38, 0x0p+0 },
{ INT64_C(0x0000004002010010), 0x1.000804004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfeffef), -0x1.0008040044p+38, 0x0p+0 },
{ INT64_C(0x0000004002010040), 0x1.00080401p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfeffbf), -0x1.0008040104p+38, 0x0p+0 },
{ INT64_C(0x0000004002010200), 0x1.00080408p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfefdff), -0x1.0008040804p+38, 0x0p+0 },
{ INT64_C(0x0000004002011000), 0x1.0008044p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfeefff), -0x1.0008044004p+38, 0x0p+0 },
{ INT64_C(0x0000004002018000), 0x1.000806p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdfe7fff), -0x1.0008060004p+38, 0x0p+0 },
{ INT64_C(0x0000004002100000), 0x1.00084p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdefffff), -0x1.0008400004p+38, 0x0p+0 },
{ INT64_C(0x0000004002100004), 0x1.000840001p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdeffffb), -0x1.0008400014p+38, 0x0p+0 },
{ INT64_C(0x0000004002100040), 0x1.00084001p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdefffbf), -0x1.0008400104p+38, 0x0p+0 },
{ INT64_C(0x0000004002100200), 0x1.00084008p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdeffdff), -0x1.0008400804p+38, 0x0p+0 },
{ INT64_C(0x0000004002102000), 0x1.0008408p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdefdfff), -0x1.0008408004p+38, 0x0p+0 },
{ INT64_C(0x0000004002104000), 0x1.000841p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdefbfff), -0x1.0008410004p+38, 0x0p+0 },
{ INT64_C(0x0000004002108000), 0x1.000842p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdef7fff), -0x1.0008420004p+38, 0x0p+0 },
{ INT64_C(0x0000004002120000), 0x1.000848p+38, 0x0p+0 },
{ INT64_C(0xffffffbffdedffff), -0x1.0008480004p+38, 0x0p+0 },
{ INT64_C(0x0000004002200000), 0x1.00088p+38, 0x0p+0 },
{ INT64_C(0xffffffbffddfffff), -0x1.0008800004p+38, 0x0p+0 },
{ INT64_C(0x0000004002200001), 0x1.0008800004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffddffffe), -0x1.0008800008p+38, 0x0p+0 },
{ INT64_C(0x0000004002200004), 0x1.000880001p+38, 0x0p+0 },
{ INT64_C(0xffffffbffddffffb), -0x1.0008800014p+38, 0x0p+0 },
{ INT64_C(0x0000004002200010), 0x1.000880004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffddfffef), -0x1.0008800044p+38, 0x0p+0 },
{ INT64_C(0x0000004002200100), 0x1.00088004p+38, 0x0p+0 },
{ INT64_C(0xffffffbffddffeff), -0x1.0008800404p+38, 0x0p+0 },
{ INT64_C(0x0000004002201000), 0x1.0008804p+38, 0x0p+0 },
{ INT64_C(0xffffffbffddfefff), -0x1.0008804004p+38, 0x0p+0 },
{ INT64_C(0x0000004002202000), 0x1.0008808p+38, 0x0p+0 },
{ INT64_C(0xffffffbffddfdfff), -0x1.0008808004p+38, 0x0p+0 },
{ INT64_C(0x0000004002204000), 0x1.000881p+38, 0x0p+0 },
{ INT64_C(0xffffffbffddfbfff), -0x1.0008810004p+38, 0x0p+0 },
{ INT64_C(0x0000004002208000), 0x1.000882p+38, 0x0p+0 },
{ INT64_C(0xffffffbffddf7fff), -0x1.0008820004p+38, 0x0p+0 },
{ INT64_C(0x0000004002240000), 0x1.00089p+38, 0x0p+0 },
{ INT64_C(0xffffffbffddbffff), -0x1.0008900004p+38, 0x0p+0 },
{ INT64_C(0x0000004002280000), 0x1.0008ap+38, 0x0p+0 },
{ INT64_C(0xffffffbffdd7ffff), -0x1.0008a00004p+38, 0x0p+0 },
{ INT64_C(0x0000004002300000), 0x1.0008cp+38, 0x0p+0 },
{ INT64_C(0xffffffbffdcfffff), -0x1.0008c00004p+38, 0x0p+0 },
{ INT64_C(0x0000004020000008), 0x1.008000002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffffff7), -0x1.0080000024p+38, 0x0p+0 },
{ INT64_C(0x0000004020000040), 0x1.00800001p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffffbf), -0x1.0080000104p+38, 0x0p+0 },
{ INT64_C(0x0000004020000041), 0x1.0080000104p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffffbe), -0x1.0080000108p+38, 0x0p+0 },
{ INT64_C(0x0000004020000048), 0x1.008000012p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffffb7), -0x1.0080000124p+38, 0x0p+0 },
{ INT64_C(0x0000004020000080), 0x1.00800002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffff7f), -0x1.0080000204p+38, 0x0p+0 },
{ INT64_C(0x0000004020000084), 0x1.008000021p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffff7b), -0x1.0080000214p+38, 0x0p+0 },
{ INT64_C(0x00000040200000a0), 0x1.008000028p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffff5f), -0x1.0080000284p+38, 0x0p+0 },
{ INT64_C(0x0000004020000200), 0x1.00800008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffffdff), -0x1.0080000804p+38, 0x0p+0 },
{ INT64_C(0x0000004020000202), 0x1.0080000808p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffffdfd), -0x1.008000080cp+38, 0x0p+0 },
{ INT64_C(0x0000004020000210), 0x1.008000084p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffffdef), -0x1.0080000844p+38, 0x0p+0 },
{ INT64_C(0x0000004020000220), 0x1.008000088p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffffddf), -0x1.0080000884p+38, 0x0p+0 },
{ INT64_C(0x0000004020000300), 0x1.0080000cp+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffffcff), -0x1.0080000c04p+38, 0x0p+0 },
{ INT64_C(0x0000004020001000), 0x1.0080004p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffefff), -0x1.0080004004p+38, 0x0p+0 },
{ INT64_C(0x0000004020001004), 0x1.008000401p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffeffb), -0x1.0080004014p+38, 0x0p+0 },
{ INT64_C(0x0000004020001010), 0x1.008000404p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffefef), -0x1.0080004044p+38, 0x0p+0 },
{ INT64_C(0x0000004020001040), 0x1.00800041p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffefbf), -0x1.0080004104p+38, 0x0p+0 },
{ INT64_C(0x0000004020001400), 0x1.0080005p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffebff), -0x1.0080005004p+38, 0x0p+0 },
{ INT64_C(0x0000004020002000), 0x1.0080008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffdfff), -0x1.0080008004p+38, 0x0p+0 },
{ INT64_C(0x0000004020002001), 0x1.0080008004p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffdffe), -0x1.0080008008p+38, 0x0p+0 },
{ INT64_C(0x0000004020002002), 0x1.0080008008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffdffd), -0x1.008000800cp+38, 0x0p+0 },
{ INT64_C(0x0000004020002004), 0x1.008000801p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffdffb), -0x1.0080008014p+38, 0x0p+0 },
{ INT64_C(0x0000004020002008), 0x1.008000802p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffdff7), -0x1.0080008024p+38, 0x0p+0 },
{ INT64_C(0x0000004020002040), 0x1.00800081p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffdfbf), -0x1.0080008104p+38, 0x0p+0 },
{ INT64_C(0x0000004020002400), 0x1.0080009p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfffdbff), -0x1.0080009004p+38, 0x0p+0 },
{ INT64_C(0x0000004020020000), 0x1.008008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffdffff), -0x1.0080080004p+38, 0x0p+0 },
{ INT64_C(0x0000004020020008), 0x1.008008002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffdfff7), -0x1.0080080024p+38, 0x0p+0 },
{ INT64_C(0x0000004020020010), 0x1.008008004p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffdffef), -0x1.0080080044p+38, 0x0p+0 },
{ INT64_C(0x0000004020020080), 0x1.00800802p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffdff7f), -0x1.0080080204p+38, 0x0p+0 },
{ INT64_C(0x0000004020020100), 0x1.00800804p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffdfeff), -0x1.0080080404p+38, 0x0p+0 },
{ INT64_C(0x0000004020020400), 0x1.0080081p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffdfbff), -0x1.0080081004p+38, 0x0p+0 },
{ INT64_C(0x0000004020020800), 0x1.0080082p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffdf7ff), -0x1.0080082004p+38, 0x0p+0 },
{ INT64_C(0x0000004020024000), 0x1.008009p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffdbfff), -0x1.0080090004p+38, 0x0p+0 },
{ INT64_C(0x0000004020030000), 0x1.00800cp+38, 0x0p+0 },
{ INT64_C(0xffffffbfdffcffff), -0x1.00800c0004p+38, 0x0p+0 },
{ INT64_C(0x0000004020200000), 0x1.00808p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfdfffff), -0x1.0080800004p+38, 0x0p+0 },
{ INT64_C(0x0000004020200008), 0x1.008080002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfdffff7), -0x1.0080800024p+38, 0x0p+0 },
{ INT64_C(0x0000004020200010), 0x1.008080004p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfdfffef), -0x1.0080800044p+38, 0x0p+0 },
{ INT64_C(0x0000004020200080), 0x1.00808002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfdfff7f), -0x1.0080800204p+38, 0x0p+0 },
{ INT64_C(0x0000004020200400), 0x1.0080801p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfdffbff), -0x1.0080801004p+38, 0x0p+0 },
{ INT64_C(0x0000004020201000), 0x1.0080804p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfdfefff), -0x1.0080804004p+38, 0x0p+0 },
{ INT64_C(0x0000004020202000), 0x1.0080808p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfdfdfff), -0x1.0080808004p+38, 0x0p+0 },
{ INT64_C(0x0000004020210000), 0x1.008084p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfdeffff), -0x1.0080840004p+38, 0x0p+0 },
{ INT64_C(0x0000004020240000), 0x1.00809p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdfdbffff), -0x1.0080900004p+38, 0x0p+0 },
{ INT64_C(0x0000004022000000), 0x1.0088p+38, 0x0p+0 },
{ INT64_C(0xffffffbfddffffff), -0x1.0088000004p+38, 0x0p+0 },
{ INT64_C(0x0000004022000004), 0x1.008800001p+38, 0x0p+0 },
{ INT64_C(0xffffffbfddfffffb), -0x1.0088000014p+38, 0x0p+0 },
{ INT64_C(0x0000004022000008), 0x1.008800002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfddfffff7), -0x1.0088000024p+38, 0x0p+0 },
{ INT64_C(0x0000004022000020), 0x1.008800008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfddffffdf), -0x1.0088000084p+38, 0x0p+0 },
{ INT64_C(0x0000004022000080), 0x1.00880002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfddffff7f), -0x1.0088000204p+38, 0x0p+0 },
{ INT64_C(0x0000004022000800), 0x1.0088002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfddfff7ff), -0x1.0088002004p+38, 0x0p+0 },
{ INT64_C(0x0000004022002000), 0x1.0088008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfddffdfff), -0x1.0088008004p+38, 0x0p+0 },
{ INT64_C(0x0000004022020000), 0x1.008808p+38, 0x0p+0 },
{ INT64_C(0xffffffbfddfdffff), -0x1.0088080004p+38, 0x0p+0 },
{ INT64_C(0x0000004022200000), 0x1.00888p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdddfffff), -0x1.0088800004p+38, 0x0p+0 },
{ INT64_C(0x0000004023000000), 0x1.008cp+38, 0x0p+0 },
{ INT64_C(0xffffffbfdcffffff), -0x1.008c000004p+38, 0x0p+0 },
{ INT64_C(0x0000004024000000), 0x1.009p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdbffffff), -0x1.0090000004p+38, 0x0p+0 },
{ INT64_C(0x0000004024000002), 0x1.0090000008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdbfffffd), -0x1.009000000cp+38, 0x0p+0 },
{ INT64_C(0x0000004024000008), 0x1.009000002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdbfffff7), -0x1.0090000024p+38, 0x0p+0 },
{ INT64_C(0x0000004024000020), 0x1.009000008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdbffffdf), -0x1.0090000084p+38, 0x0p+0 },
{ INT64_C(0x0000004024000200), 0x1.00900008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdbfffdff), -0x1.0090000804p+38, 0x0p+0 },
{ INT64_C(0x0000004024000800), 0x1.0090002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdbfff7ff), -0x1.0090002004p+38, 0x0p+0 },
{ INT64_C(0x0000004024001000), 0x1.0090004p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdbffefff), -0x1.0090004004p+38, 0x0p+0 },
{ INT64_C(0x0000004024004000), 0x1.009001p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdbffbfff), -0x1.0090010004p+38, 0x0p+0 },
{ INT64_C(0x0000004024020000), 0x1.009008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdbfdffff), -0x1.0090080004p+38, 0x0p+0 },
{ INT64_C(0x0000004024100000), 0x1.00904p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdbefffff), -0x1.0090400004p+38, 0x0p+0 },
{ INT64_C(0x0000004024800000), 0x1.0092p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdb7fffff), -0x1.0092000004p+38, 0x0p+0 },
{ INT64_C(0x0000004025000000), 0x1.0094p+38, 0x0p+0 },
{ INT64_C(0xffffffbfdaffffff), -0x1.0094000004p+38, 0x0p+0 },
{ INT64_C(0x0000004026000000), 0x1.0098p+38, 0x0p+0 },
{ INT64_C(0xffffffbfd9ffffff), -0x1.0098000004p+38, 0x0p+0 },
{ INT64_C(0x0000004028000000), 0x1.00ap+38, 0x0p+0 },
{ INT64_C(0xffffffbfd7ffffff), -0x1.00a0000004p+38, 0x0p+0 },
{ INT64_C(0x0000004028000001), 0x1.00a0000004p+38, 0x0p+0 },
{ INT64_C(0xffffffbfd7fffffe), -0x1.00a0000008p+38, 0x0p+0 },
{ INT64_C(0x0000004028000008), 0x1.00a000002p+38, 0x0p+0 },
{ INT64_C(0xffffffbfd7fffff7), -0x1.00a0000024p+38, 0x0p+0 },
{ INT64_C(0x0000004028000040), 0x1.00a00001p+38, 0x0p+0 },
{ INT64_C(0xffffffbfd7ffffbf), -0x1.00a0000104p+38, 0x0p+0 },
{ INT64_C(0x0000004028000200), 0x1.00a00008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfd7fffdff), -0x1.00a0000804p+38, 0x0p+0 },
{ INT64_C(0x0000004028002000), 0x1.00a0008p+38, 0x0p+0 },
{ INT64_C(0xffffffbfd7ffdfff), -0x1.00a0008004p+38, 0x0p+0 },
{ INT64_C(0x0000004028010000), 0x1.00a004p+38, 0x0p+0 },
{ INT64_C(0xffffffbfd7feffff), -0x1.00a0040004p+38, 0x0p+0 },
{ INT64_C(0x0000004028080000), 0x1.00a02p+38, 0x0p+0 },
{ INT64_C(0xffffffbfd7f7ffff), -0x1.00a0200004p+38, 0x0p+0 },
{ INT64_C(0x0000004028800000), 0x1.00a2p+38, 0x0p+0 },
{ INT64_C(0xffffffbfd77fffff), -0x1.00a2000004p+38, 0x0p+0 },
{ INT64_C(0x0000004029000000), 0x1.00a4p+38, 0x0p+0 },
{ INT64_C(0xffffffbfd6ffffff), -0x1.00a4000004p+38, 0x0p+0 },
{ INT64_C(0x000000402a000000), 0x1.00a8p+38, 0x0p+0 },
{ INT64_C(0xffffffbfd5ffffff), -0x1.00a8000004p+38, 0x0p+0 },
{ INT64_C(0x0000004200000008), 0x1.080000002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffffff7), -0x1.0800000024p+38, 0x0p+0 },
{ INT64_C(0x0000004200000080), 0x1.08000002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffff7f), -0x1.0800000204p+38, 0x0p+0 },
{ INT64_C(0x0000004200000081), 0x1.0800000204p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffff7e), -0x1.0800000208p+38, 0x0p+0 },
{ INT64_C(0x0000004200000084), 0x1.080000021p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffff7b), -0x1.0800000214p+38, 0x0p+0 },
{ INT64_C(0x00000042000000a0), 0x1.080000028p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffff5f), -0x1.0800000284p+38, 0x0p+0 },
{ INT64_C(0x0000004200000100), 0x1.08000004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffffeff), -0x1.0800000404p+38, 0x0p+0 },
{ INT64_C(0x0000004200000104), 0x1.080000041p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffffefb), -0x1.0800000414p+38, 0x0p+0 },
{ INT64_C(0x0000004200000110), 0x1.080000044p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffffeef), -0x1.0800000444p+38, 0x0p+0 },
{ INT64_C(0x0000004200000180), 0x1.08000006p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffffe7f), -0x1.0800000604p+38, 0x0p+0 },
{ INT64_C(0x0000004200000800), 0x1.0800002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffff7ff), -0x1.0800002004p+38, 0x0p+0 },
{ INT64_C(0x0000004200000801), 0x1.0800002004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffff7fe), -0x1.0800002008p+38, 0x0p+0 },
{ INT64_C(0x0000004200000808), 0x1.080000202p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffff7f7), -0x1.0800002024p+38, 0x0p+0 },
{ INT64_C(0x0000004200000820), 0x1.080000208p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffff7df), -0x1.0800002084p+38, 0x0p+0 },
{ INT64_C(0x0000004200000880), 0x1.08000022p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffff77f), -0x1.0800002204p+38, 0x0p+0 },
{ INT64_C(0x0000004200001000), 0x1.0800004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffefff), -0x1.0800004004p+38, 0x0p+0 },
{ INT64_C(0x0000004200001001), 0x1.0800004004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffeffe), -0x1.0800004008p+38, 0x0p+0 },
{ INT64_C(0x0000004200001002), 0x1.0800004008p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffeffd), -0x1.080000400cp+38, 0x0p+0 },
{ INT64_C(0x0000004200001008), 0x1.080000402p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffeff7), -0x1.0800004024p+38, 0x0p+0 },
{ INT64_C(0x0000004200001040), 0x1.08000041p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffefbf), -0x1.0800004104p+38, 0x0p+0 },
{ INT64_C(0x0000004200001080), 0x1.08000042p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffef7f), -0x1.0800004204p+38, 0x0p+0 },
{ INT64_C(0x0000004200001400), 0x1.0800005p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffebff), -0x1.0800005004p+38, 0x0p+0 },
{ INT64_C(0x0000004200001800), 0x1.0800006p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffe7ff), -0x1.0800006004p+38, 0x0p+0 },
{ INT64_C(0x0000004200004000), 0x1.080001p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffbfff), -0x1.0800010004p+38, 0x0p+0 },
{ INT64_C(0x0000004200004004), 0x1.080001001p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffbffb), -0x1.0800010014p+38, 0x0p+0 },
{ INT64_C(0x0000004200004040), 0x1.08000101p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffbfbf), -0x1.0800010104p+38, 0x0p+0 },
{ INT64_C(0x0000004200004100), 0x1.08000104p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffbeff), -0x1.0800010404p+38, 0x0p+0 },
{ INT64_C(0x0000004200004800), 0x1.0800012p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffb7ff), -0x1.0800012004p+38, 0x0p+0 },
{ INT64_C(0x0000004200005000), 0x1.0800014p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffffafff), -0x1.0800014004p+38, 0x0p+0 },
{ INT64_C(0x0000004200008000), 0x1.080002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffff7fff), -0x1.0800020004p+38, 0x0p+0 },
{ INT64_C(0x0000004200008008), 0x1.080002002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffff7ff7), -0x1.0800020024p+38, 0x0p+0 },
{ INT64_C(0x0000004200008020), 0x1.080002008p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffff7fdf), -0x1.0800020084p+38, 0x0p+0 },
{ INT64_C(0x0000004200008100), 0x1.08000204p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffff7eff), -0x1.0800020404p+38, 0x0p+0 },
{ INT64_C(0x0000004200008200), 0x1.08000208p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffff7dff), -0x1.0800020804p+38, 0x0p+0 },
{ INT64_C(0x0000004200008800), 0x1.0800022p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffff77ff), -0x1.0800022004p+38, 0x0p+0 },
{ INT64_C(0x000000420000c000), 0x1.080003p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffff3fff), -0x1.0800030004p+38, 0x0p+0 },
{ INT64_C(0x0000004200010000), 0x1.080004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffeffff), -0x1.0800040004p+38, 0x0p+0 },
{ INT64_C(0x0000004200010001), 0x1.0800040004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffefffe), -0x1.0800040008p+38, 0x0p+0 },
{ INT64_C(0x0000004200010002), 0x1.0800040008p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffefffd), -0x1.080004000cp+38, 0x0p+0 },
{ INT64_C(0x0000004200010020), 0x1.080004008p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffeffdf), -0x1.0800040084p+38, 0x0p+0 },
{ INT64_C(0x0000004200010200), 0x1.08000408p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffefdff), -0x1.0800040804p+38, 0x0p+0 },
{ INT64_C(0x0000004200012000), 0x1.0800048p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffedfff), -0x1.0800048004p+38, 0x0p+0 },
{ INT64_C(0x0000004200018000), 0x1.080006p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfffe7fff), -0x1.0800060004p+38, 0x0p+0 },
{ INT64_C(0x0000004200100000), 0x1.08004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffefffff), -0x1.0800400004p+38, 0x0p+0 },
{ INT64_C(0x0000004200100001), 0x1.0800400004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffeffffe), -0x1.0800400008p+38, 0x0p+0 },
{ INT64_C(0x0000004200100002), 0x1.0800400008p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffeffffd), -0x1.080040000cp+38, 0x0p+0 },
{ INT64_C(0x0000004200100010), 0x1.080040004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffefffef), -0x1.0800400044p+38, 0x0p+0 },
{ INT64_C(0x0000004200100040), 0x1.08004001p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffefffbf), -0x1.0800400104p+38, 0x0p+0 },
{ INT64_C(0x0000004200100080), 0x1.08004002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffefff7f), -0x1.0800400204p+38, 0x0p+0 },
{ INT64_C(0x0000004200100800), 0x1.0800402p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffeff7ff), -0x1.0800402004p+38, 0x0p+0 },
{ INT64_C(0x0000004200104000), 0x1.080041p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffefbfff), -0x1.0800410004p+38, 0x0p+0 },
{ INT64_C(0x0000004200120000), 0x1.080048p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffedffff), -0x1.0800480004p+38, 0x0p+0 },
{ INT64_C(0x0000004200140000), 0x1.08005p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffebffff), -0x1.0800500004p+38, 0x0p+0 },
{ INT64_C(0x0000004200200000), 0x1.08008p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffdfffff), -0x1.0800800004p+38, 0x0p+0 },
{ INT64_C(0x0000004200200004), 0x1.080080001p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffdffffb), -0x1.0800800014p+38, 0x0p+0 },
{ INT64_C(0x0000004200200040), 0x1.08008001p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffdfffbf), -0x1.0800800104p+38, 0x0p+0 },
{ INT64_C(0x0000004200200080), 0x1.08008002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffdfff7f), -0x1.0800800204p+38, 0x0p+0 },
{ INT64_C(0x0000004200200200), 0x1.08008008p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffdffdff), -0x1.0800800804p+38, 0x0p+0 },
{ INT64_C(0x0000004200202000), 0x1.0800808p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffdfdfff), -0x1.0800808004p+38, 0x0p+0 },
{ INT64_C(0x0000004200210000), 0x1.080084p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffdeffff), -0x1.0800840004p+38, 0x0p+0 },
{ INT64_C(0x0000004200240000), 0x1.08009p+38, 0x0p+0 },
{ INT64_C(0xffffffbdffdbffff), -0x1.0800900004p+38, 0x0p+0 },
{ INT64_C(0x0000004200300000), 0x1.0800cp+38, 0x0p+0 },
{ INT64_C(0xffffffbdffcfffff), -0x1.0800c00004p+38, 0x0p+0 },
{ INT64_C(0x0000004200800000), 0x1.0802p+38, 0x0p+0 },
{ INT64_C(0xffffffbdff7fffff), -0x1.0802000004p+38, 0x0p+0 },
{ INT64_C(0x0000004200800008), 0x1.080200002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdff7ffff7), -0x1.0802000024p+38, 0x0p+0 },
{ INT64_C(0x0000004200800080), 0x1.08020002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdff7fff7f), -0x1.0802000204p+38, 0x0p+0 },
{ INT64_C(0x0000004200800100), 0x1.08020004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdff7ffeff), -0x1.0802000404p+38, 0x0p+0 },
{ INT64_C(0x0000004200800800), 0x1.0802002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdff7ff7ff), -0x1.0802002004p+38, 0x0p+0 },
{ INT64_C(0x0000004200808000), 0x1.080202p+38, 0x0p+0 },
{ INT64_C(0xffffffbdff7f7fff), -0x1.0802020004p+38, 0x0p+0 },
{ INT64_C(0x0000004200810000), 0x1.080204p+38, 0x0p+0 },
{ INT64_C(0xffffffbdff7effff), -0x1.0802040004p+38, 0x0p+0 },
{ INT64_C(0x0000004200820000), 0x1.080208p+38, 0x0p+0 },
{ INT64_C(0xffffffbdff7dffff), -0x1.0802080004p+38, 0x0p+0 },
{ INT64_C(0x0000004200880000), 0x1.08022p+38, 0x0p+0 },
{ INT64_C(0xffffffbdff77ffff), -0x1.0802200004p+38, 0x0p+0 },
{ INT64_C(0x0000004200900000), 0x1.08024p+38, 0x0p+0 },
{ INT64_C(0xffffffbdff6fffff), -0x1.0802400004p+38, 0x0p+0 },
{ INT64_C(0x0000004200a00000), 0x1.08028p+38, 0x0p+0 },
{ INT64_C(0xffffffbdff5fffff), -0x1.0802800004p+38, 0x0p+0 },
{ INT64_C(0x0000004200c00000), 0x1.0803p+38, 0x0p+0 },
{ INT64_C(0xffffffbdff3fffff), -0x1.0803000004p+38, 0x0p+0 },
{ INT64_C(0x0000004202000000), 0x1.0808p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfdffffff), -0x1.0808000004p+38, 0x0p+0 },
{ INT64_C(0x0000004202000004), 0x1.080800001p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfdfffffb), -0x1.0808000014p+38, 0x0p+0 },
{ INT64_C(0x0000004202000010), 0x1.080800004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfdffffef), -0x1.0808000044p+38, 0x0p+0 },
{ INT64_C(0x0000004202000100), 0x1.08080004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfdfffeff), -0x1.0808000404p+38, 0x0p+0 },
{ INT64_C(0x0000004202000800), 0x1.0808002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfdfff7ff), -0x1.0808002004p+38, 0x0p+0 },
{ INT64_C(0x0000004202001000), 0x1.0808004p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfdffefff), -0x1.0808004004p+38, 0x0p+0 },
{ INT64_C(0x0000004202002000), 0x1.0808008p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfdffdfff), -0x1.0808008004p+38, 0x0p+0 },
{ INT64_C(0x0000004202004000), 0x1.080801p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfdffbfff), -0x1.0808010004p+38, 0x0p+0 },
{ INT64_C(0x0000004202020000), 0x1.080808p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfdfdffff), -0x1.0808080004p+38, 0x0p+0 },
{ INT64_C(0x0000004202040000), 0x1.08081p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfdfbffff), -0x1.0808100004p+38, 0x0p+0 },
{ INT64_C(0x0000004202400000), 0x1.0809p+38, 0x0p+0 },
{ INT64_C(0xffffffbdfdbfffff), -0x1.0809000004p+38, 0x0p+0 },
{ INT64_C(0x0000004210000000), 0x1.084p+38, 0x0p+0 },
{ INT64_C(0xffffffbdefffffff), -0x1.0840000004p+38, 0x0p+0 },
{ INT64_C(0x0000004210000004), 0x1.084000001p+38, 0x0p+0 },
{ INT64_C(0xffffffbdeffffffb), -0x1.0840000014p+38, 0x0p+0 },
{ INT64_C(0x0000004210000020), 0x1.084000008p+38, 0x0p+0 },
{ INT64_C(0xffffffbdefffffdf), -0x1.0840000084p+38, 0x0p+0 },
{ INT64_C(0x0000004210000080), 0x1.08400002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdefffff7f), -0x1.0840000204p+38, 0x0p+0 },
{ INT64_C(0x0000004210000800), 0x1.0840002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdeffff7ff), -0x1.0840002004p+38, 0x0p+0 },
{ INT64_C(0x0000004210008000), 0x1.084002p+38, 0x0p+0 },
{ INT64_C(0xffffffbdefff7fff), -0x1.0840020004p+38, 0x0p+0 },
{ INT64_C(0x0000004210080000), 0x1.08402p+38, 0x0p+0 },
{ INT64_C(0xffffffbdeff7ffff), -0x1.0840200004p+38, 0x0p+0 },
{ INT64_C(0x0000004210800000), 0x1.0842p+38, 0x0p+0 },
{ INT64_C(0xffffffbdef7fffff), -0x1.0842000004p+38, 0x0p+0 },
{ INT64_C(0x0000004218000000), 0x1.086p+38, 0x0p+0 },
{ INT64_C(0xffffffbde7ffffff), -0x1.0860000004p+38, 0x0p+0 },
{ INT64_C(0x0000004300000000), 0x1.0cp+38, 0x0p+0 },
{ INT64_C(0xffffffbcffffffff), -0x1.0c00000004p+38, 0x0p+0 },
{ INT64_C(0x0000004300000008), 0x1.0c0000002p+38, 0x0p+0 },
{ INT64_C(0xffffffbcfffffff7), -0x1.0c00000024p+38, 0x0p+0 },
{ INT64_C(0x0000004300000080), 0x1.0c000002p+38, 0x0p+0 },
{ INT64_C(0xffffffbcffffff7f), -0x1.0c00000204p+38, 0x0p+0 },
{ INT64_C(0x0000004300000200), 0x1.0c000008p+38, 0x0p+0 },
{ INT64_C(0xffffffbcfffffdff), -0x1.0c00000804p+38, 0x0p+0 },
{ INT64_C(0x0000004300002000), 0x1.0c00008p+38, 0x0p+0 },
{ INT64_C(0xffffffbcffffdfff), -0x1.0c00008004p+38, 0x0p+0 },
{ INT64_C(0x0000004300008000), 0x1.0c0002p+38, 0x0p+0 },
{ INT64_C(0xffffffbcffff7fff), -0x1.0c00020004p+38, 0x0p+0 },
{ INT64_C(0x0000004300010000), 0x1.0c0004p+38, 0x0p+0 },
{ INT64_C(0xffffffbcfffeffff), -0x1.0c00040004p+38, 0x0p+0 },
{ INT64_C(0x0000004300040000), 0x1.0c001p+38, 0x0p+0 },
{ INT64_C(0xffffffbcfffbffff), -0x1.0c00100004p+38, 0x0p+0 },
{ INT64_C(0x0000004300200000), 0x1.0c008p+38, 0x0p+0 },
{ INT64_C(0xffffffbcffdfffff), -0x1.0c00800004p+38, 0x0p+0 },
{ INT64_C(0x0000004300400000), 0x1.0c01p+38, 0x0p+0 },
{ INT64_C(0xffffffbcffbfffff), -0x1.0c01000004p+38, 0x0p+0 },
{ INT64_C(0x0000004301000000), 0x1.0c04p+38, 0x0p+0 },
{ INT64_C(0xffffffbcfeffffff), -0x1.0c04000004p+38, 0x0p+0 },
{ INT64_C(0x0000004308000000), 0x1.0c2p+38, 0x0p+0 },
{ INT64_C(0xffffffbcf7ffffff), -0x1.0c20000004p+38, 0x0p+0 },
{ INT64_C(0x0000004320000000), 0x1.0c8p+38, 0x0p+0 },
{ INT64_C(0xffffffbcdfffffff), -0x1.0c80000004p+38, 0x0p+0 },
{ INT64_C(0x0000004340000000), 0x1.0dp+38, 0x0p+0 },
{ INT64_C(0xffffffbcbfffffff), -0x1.0d00000004p+38, 0x0p+0 },
{ INT64_C(0x0000006000000008), 0x1.800000002p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffffff7), -0x1.8000000024p+38, 0x0p+0 },
{ INT64_C(0x000000600000000c), 0x1.800000003p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffffff3), -0x1.8000000034p+38, 0x0p+0 },
{ INT64_C(0x0000006000000040), 0x1.80000001p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffffffbf), -0x1.8000000104p+38, 0x0p+0 },
{ INT64_C(0x0000006000000044), 0x1.800000011p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffffffbb), -0x1.8000000114p+38, 0x0p+0 },
{ INT64_C(0x0000006000000060), 0x1.800000018p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffffff9f), -0x1.8000000184p+38, 0x0p+0 },
{ INT64_C(0x0000006000000100), 0x1.80000004p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffffeff), -0x1.8000000404p+38, 0x0p+0 },
{ INT64_C(0x0000006000000102), 0x1.8000000408p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffffefd), -0x1.800000040cp+38, 0x0p+0 },
{ INT64_C(0x0000006000000120), 0x1.800000048p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffffedf), -0x1.8000000484p+38, 0x0p+0 },
{ INT64_C(0x0000006000001000), 0x1.8000004p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffffefff), -0x1.8000004004p+38, 0x0p+0 },
{ INT64_C(0x0000006000001004), 0x1.800000401p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffffeffb), -0x1.8000004014p+38, 0x0p+0 },
{ INT64_C(0x0000006000001010), 0x1.800000404p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffffefef), -0x1.8000004044p+38, 0x0p+0 },
{ INT64_C(0x0000006000001080), 0x1.80000042p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffffef7f), -0x1.8000004204p+38, 0x0p+0 },
{ INT64_C(0x0000006000001200), 0x1.80000048p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffffedff), -0x1.8000004804p+38, 0x0p+0 },
{ INT64_C(0x0000006000010000), 0x1.800004p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffeffff), -0x1.8000040004p+38, 0x0p+0 },
{ INT64_C(0x0000006000010008), 0x1.800004002p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffefff7), -0x1.8000040024p+38, 0x0p+0 },
{ INT64_C(0x0000006000010010), 0x1.800004004p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffeffef), -0x1.8000040044p+38, 0x0p+0 },
{ INT64_C(0x0000006000010100), 0x1.80000404p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffefeff), -0x1.8000040404p+38, 0x0p+0 },
{ INT64_C(0x0000006000010800), 0x1.8000042p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffef7ff), -0x1.8000042004p+38, 0x0p+0 },
{ INT64_C(0x0000006000011000), 0x1.8000044p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffeefff), -0x1.8000044004p+38, 0x0p+0 },
{ INT64_C(0x0000006000012000), 0x1.8000048p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffedfff), -0x1.8000048004p+38, 0x0p+0 },
{ INT64_C(0x0000006000020000), 0x1.800008p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffdffff), -0x1.8000080004p+38, 0x0p+0 },
{ INT64_C(0x0000006000020002), 0x1.8000080008p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffdfffd), -0x1.800008000cp+38, 0x0p+0 },
{ INT64_C(0x0000006000020020), 0x1.800008008p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffdffdf), -0x1.8000080084p+38, 0x0p+0 },
{ INT64_C(0x0000006000020080), 0x1.80000802p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffdff7f), -0x1.8000080204p+38, 0x0p+0 },
{ INT64_C(0x0000006000020200), 0x1.80000808p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffdfdff), -0x1.8000080804p+38, 0x0p+0 },
{ INT64_C(0x0000006000020400), 0x1.8000081p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffdfbff), -0x1.8000081004p+38, 0x0p+0 },
{ INT64_C(0x0000006000022000), 0x1.8000088p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffddfff), -0x1.8000088004p+38, 0x0p+0 },
{ INT64_C(0x0000006000024000), 0x1.800009p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffdbfff), -0x1.8000090004p+38, 0x0p+0 },
{ INT64_C(0x0000006000030000), 0x1.80000cp+38, 0x0p+0 },
{ INT64_C(0xffffff9ffffcffff), -0x1.80000c0004p+38, 0x0p+0 },
{ INT64_C(0x0000006000200000), 0x1.80008p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffdfffff), -0x1.8000800004p+38, 0x0p+0 },
{ INT64_C(0x0000006000200004), 0x1.800080001p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffdffffb), -0x1.8000800014p+38, 0x0p+0 },
{ INT64_C(0x0000006000200020), 0x1.800080008p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffdfffdf), -0x1.8000800084p+38, 0x0p+0 },
{ INT64_C(0x0000006000200080), 0x1.80008002p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffdfff7f), -0x1.8000800204p+38, 0x0p+0 },
{ INT64_C(0x0000006000200800), 0x1.8000802p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffdff7ff), -0x1.8000802004p+38, 0x0p+0 },
{ INT64_C(0x0000006000202000), 0x1.8000808p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffdfdfff), -0x1.8000808004p+38, 0x0p+0 },
{ INT64_C(0x0000006000210000), 0x1.800084p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffdeffff), -0x1.8000840004p+38, 0x0p+0 },
{ INT64_C(0x0000006000220000), 0x1.800088p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffddffff), -0x1.8000880004p+38, 0x0p+0 },
{ INT64_C(0x0000006000240000), 0x1.80009p+38, 0x0p+0 },
{ INT64_C(0xffffff9fffdbffff), -0x1.8000900004p+38, 0x0p+0 },
{ INT64_C(0x0000006000280000), 0x1.8000ap+38, 0x0p+0 },
{ INT64_C(0xffffff9fffd7ffff), -0x1.8000a00004p+38, 0x0p+0 },
{ INT64_C(0x0000006000800000), 0x1.8002p+38, 0x0p+0 },
{ INT64_C(0xffffff9fff7fffff), -0x1.8002000004p+38, 0x0p+0 },
{ INT64_C(0x0000006000800004), 0x1.800200001p+38, 0x0p+0 },
{ INT64_C(0xffffff9fff7ffffb), -0x1.8002000014p+38, 0x0p+0 },
{ INT64_C(0x0000006000800010), 0x1.800200004p+38, 0x0p+0 },
{ INT64_C(0xffffff9fff7fffef), -0x1.8002000044p+38, 0x0p+0 },
{ INT64_C(0x0000006000800020), 0x1.800200008p+38, 0x0p+0 },
{ INT64_C(0xffffff9fff7fffdf), -0x1.8002000084p+38, 0x0p+0 },
{ INT64_C(0x0000006000800200), 0x1.80020008p+38, 0x0p+0 },
{ INT64_C(0xffffff9fff7ffdff), -0x1.8002000804p+38, 0x0p+0 },
{ INT64_C(0x0000006000802000), 0x1.8002008p+38, 0x0p+0 },
{ INT64_C(0xffffff9fff7fdfff), -0x1.8002008004p+38, 0x0p+0 },
{ INT64_C(0x0000006000804000), 0x1.800201p+38, 0x0p+0 },
{ INT64_C(0xffffff9fff7fbfff), -0x1.8002010004p+38, 0x0p+0 },
{ INT64_C(0x0000006000810000), 0x1.800204p+38, 0x0p+0 },
{ INT64_C(0xffffff9fff7effff), -0x1.8002040004p+38, 0x0p+0 },
{ INT64_C(0x0000006000840000), 0x1.80021p+38, 0x0p+0 },
{ INT64_C(0xffffff9fff7bffff), -0x1.8002100004p+38, 0x0p+0 },
{ INT64_C(0x0000006000a00000), 0x1.80028p+38, 0x0p+0 },
{ INT64_C(0xffffff9fff5fffff), -0x1.8002800004p+38, 0x0p+0 },
{ INT64_C(0x0000006004000000), 0x1.801p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffbffffff), -0x1.8010000004p+38, 0x0p+0 },
{ INT64_C(0x0000006004000008), 0x1.801000002p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffbfffff7), -0x1.8010000024p+38, 0x0p+0 },
{ INT64_C(0x0000006004000080), 0x1.80100002p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffbffff7f), -0x1.8010000204p+38, 0x0p+0 },
{ INT64_C(0x0000006004000200), 0x1.80100008p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffbfffdff), -0x1.8010000804p+38, 0x0p+0 },
{ INT64_C(0x0000006004001000), 0x1.8010004p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffbffefff), -0x1.8010004004p+38, 0x0p+0 },
{ INT64_C(0x0000006004010000), 0x1.801004p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffbfeffff), -0x1.8010040004p+38, 0x0p+0 },
{ INT64_C(0x0000006004040000), 0x1.80101p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffbfbffff), -0x1.8010100004p+38, 0x0p+0 },
{ INT64_C(0x0000006004100000), 0x1.80104p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffbefffff), -0x1.8010400004p+38, 0x0p+0 },
{ INT64_C(0x0000006005000000), 0x1.8014p+38, 0x0p+0 },
{ INT64_C(0xffffff9ffaffffff), -0x1.8014000004p+38, 0x0p+0 },
{ INT64_C(0x0000006040000000), 0x1.81p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbfffffff), -0x1.8100000004p+38, 0x0p+0 },
{ INT64_C(0x0000006040000001), 0x1.8100000004p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbffffffe), -0x1.8100000008p+38, 0x0p+0 },
{ INT64_C(0x0000006040000002), 0x1.8100000008p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbffffffd), -0x1.810000000cp+38, 0x0p+0 },
{ INT64_C(0x0000006040000020), 0x1.810000008p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbfffffdf), -0x1.8100000084p+38, 0x0p+0 },
{ INT64_C(0x0000006040000080), 0x1.81000002p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbfffff7f), -0x1.8100000204p+38, 0x0p+0 },
{ INT64_C(0x0000006040000100), 0x1.81000004p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbffffeff), -0x1.8100000404p+38, 0x0p+0 },
{ INT64_C(0x0000006040000200), 0x1.81000008p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbffffdff), -0x1.8100000804p+38, 0x0p+0 },
{ INT64_C(0x0000006040002000), 0x1.8100008p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbfffdfff), -0x1.8100008004p+38, 0x0p+0 },
{ INT64_C(0x0000006040004000), 0x1.810001p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbfffbfff), -0x1.8100010004p+38, 0x0p+0 },
{ INT64_C(0x0000006040008000), 0x1.810002p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbfff7fff), -0x1.8100020004p+38, 0x0p+0 },
{ INT64_C(0x0000006040040000), 0x1.81001p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbffbffff), -0x1.8100100004p+38, 0x0p+0 },
{ INT64_C(0x0000006040200000), 0x1.81008p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbfdfffff), -0x1.8100800004p+38, 0x0p+0 },
{ INT64_C(0x0000006040800000), 0x1.8102p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbf7fffff), -0x1.8102000004p+38, 0x0p+0 },
{ INT64_C(0x0000006042000000), 0x1.8108p+38, 0x0p+0 },
{ INT64_C(0xffffff9fbdffffff), -0x1.8108000004p+38, 0x0p+0 },
{ INT64_C(0x0000006050000000), 0x1.814p+38, 0x0p+0 },
{ INT64_C(0xffffff9fafffffff), -0x1.8140000004p+38, 0x0p+0 },
{ INT64_C(0x0000006400000000), 0x1.9p+38, 0x0p+0 },
{ INT64_C(0xffffff9bffffffff), -0x1.9000000004p+38, 0x0p+0 },
{ INT64_C(0x0000006400000001), 0x1.9000000004p+38, 0x0p+0 },
{ INT64_C(0xffffff9bfffffffe), -0x1.9000000008p+38, 0x0p+0 },
{ INT64_C(0x0000006400000010), 0x1.900000004p+38, 0x0p+0 },
{ INT64_C(0xffffff9bffffffef), -0x1.9000000044p+38, 0x0p+0 },
{ INT64_C(0x0000006400000020), 0x1.900000008p+38, 0x0p+0 },
{ INT64_C(0xffffff9bffffffdf), -0x1.9000000084p+38, 0x0p+0 },
{ INT64_C(0x0000006400000040), 0x1.90000001p+38, 0x0p+0 },
{ INT64_C(0xffffff9bffffffbf), -0x1.9000000104p+38, 0x0p+0 },
{ INT64_C(0x0000006400000400), 0x1.9000001p+38, 0x0p+0 },
{ INT64_C(0xffffff9bfffffbff), -0x1.9000001004p+38, 0x0p+0 },
{ INT64_C(0x0000006400000800), 0x1.9000002p+38, 0x0p+0 },
{ INT64_C(0xffffff9bfffff7ff), -0x1.9000002004p+38, 0x0p+0 },
{ INT64_C(0x0000006400008000), 0x1.900002p+38, 0x0p+0 },
{ INT64_C(0xffffff9bffff7fff), -0x1.9000020004p+38, 0x0p+0 },
{ INT64_C(0x0000006400020000), 0x1.900008p+38, 0x0p+0 },
{ INT64_C(0xffffff9bfffdffff), -0x1.9000080004p+38, 0x0p+0 },
{ INT64_C(0x0000006400200000), 0x1.90008p+38, 0x0p+0 },
{ INT64_C(0xffffff9bffdfffff), -0x1.9000800004p+38, 0x0p+0 },
{ INT64_C(0x0000006402000000), 0x1.9008p+38, 0x0p+0 },
{ INT64_C(0xffffff9bfdffffff), -0x1.9008000004p+38, 0x0p+0 },
{ INT64_C(0x0000006420000000), 0x1.908p+38, 0x0p+0 },
{ INT64_C(0xffffff9bdfffffff), -0x1.9080000004p+38, 0x0p+0 },
{ INT64_C(0x0000006600000000), 0x1.98p+38, 0x0p+0 },
{ INT64_C(0xffffff99ffffffff), -0x1.9800000004p+38, 0x0p+0 },
{ INT64_C(0x0000007000000000), 0x1.cp+38, 0x0p+0 },
{ INT64_C(0xffffff8fffffffff), -0x1.c000000004p+38, 0x0p+0 },
{ INT64_C(0x0000007000000002), 0x1.c000000008p+38, 0x0p+0 },
{ INT64_C(0xffffff8ffffffffd), -0x1.c00000000cp+38, 0x0p+0 },
{ INT64_C(0x0000007000000010), 0x1.c00000004p+38, 0x0p+0 },
{ INT64_C(0xffffff8fffffffef), -0x1.c000000044p+38, 0x0p+0 },
{ INT64_C(0x0000007000000040), 0x1.c0000001p+38, 0x0p+0 },
{ INT64_C(0xffffff8fffffffbf), -0x1.c000000104p+38, 0x0p+0 },
{ INT64_C(0x0000007000000100), 0x1.c0000004p+38, 0x0p+0 },
{ INT64_C(0xffffff8ffffffeff), -0x1.c000000404p+38, 0x0p+0 },
{ INT64_C(0x0000007000000200), 0x1.c0000008p+38, 0x0p+0 },
{ INT64_C(0xffffff8ffffffdff), -0x1.c000000804p+38, 0x0p+0 },
{ INT64_C(0x0000007000002000), 0x1.c000008p+38, 0x0p+0 },
{ INT64_C(0xffffff8fffffdfff), -0x1.c000008004p+38, 0x0p+0 },
{ INT64_C(0x0000007000020000), 0x1.c00008p+38, 0x0p+0 },
{ INT64_C(0xffffff8ffffdffff), -0x1.c000080004p+38, 0x0p+0 },
{ INT64_C(0x0000007000200000), 0x1.c0008p+38, 0x0p+0 },
{ INT64_C(0xffffff8fffdfffff), -0x1.c000800004p+38, 0x0p+0 },
{ INT64_C(0x0000007000400000), 0x1.c001p+38, 0x0p+0 },
{ INT64_C(0xffffff8fffbfffff), -0x1.c001000004p+38, 0x0p+0 },
{ INT64_C(0x0000007001000000), 0x1.c004p+38, 0x0p+0 },
{ INT64_C(0xffffff8ffeffffff), -0x1.c004000004p+38, 0x0p+0 },
{ INT64_C(0x0000007002000000), 0x1.c008p+38, 0x0p+0 },
{ INT64_C(0xffffff8ffdffffff), -0x1.c008000004p+38, 0x0p+0 },
{ INT64_C(0x0000007004000000), 0x1.c01p+38, 0x0p+0 },
{ INT64_C(0xffffff8ffbffffff), -0x1.c010000004p+38, 0x0p+0 },
{ INT64_C(0x0000007008000000), 0x1.c02p+38, 0x0p+0 },
{ INT64_C(0xffffff8ff7ffffff), -0x1.c020000004p+38, 0x0p+0 },
{ INT64_C(0x0000007040000000), 0x1.c1p+38, 0x0p+0 },
{ INT64_C(0xffffff8fbfffffff), -0x1.c100000004p+38, 0x0p+0 },
{ INT64_C(0x0000007080000000), 0x1.c2p+38, 0x0p+0 },
{ INT64_C(0xffffff8f7fffffff), -0x1.c200000004p+38, 0x0p+0 },
{ INT64_C(0x0000007200000000), 0x1.c8p+38, 0x0p+0 },
{ INT64_C(0xffffff8dffffffff), -0x1.c800000004p+38, 0x0p+0 },
{ INT64_C(0x0000007800000000), 0x1.ep+38, 0x0p+0 },
{ INT64_C(0xffffff87ffffffff), -0x1.e000000004p+38, 0x0p+0 },
{ INT64_C(0x0000010000000012), 0x1.0000000012p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffffed), -0x1.0000000013p+40, 0x0p+0 },
{ INT64_C(0x0000010000000014), 0x1.0000000014p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffffeb), -0x1.0000000015p+40, 0x0p+0 },
{ INT64_C(0x0000010000000016), 0x1.0000000016p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffffe9), -0x1.0000000017p+40, 0x0p+0 },
{ INT64_C(0x0000010000000024), 0x1.0000000024p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffffdb), -0x1.0000000025p+40, 0x0p+0 },
{ INT64_C(0x0000010000000026), 0x1.0000000026p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffffd9), -0x1.0000000027p+40, 0x0p+0 },
{ INT64_C(0x0000010000000081), 0x1.0000000081p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffff7e), -0x1.0000000082p+40, 0x0p+0 },
{ INT64_C(0x0000010000000090), 0x1.000000009p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffff6f), -0x1.0000000091p+40, 0x0p+0 },
{ INT64_C(0x0000010000000092), 0x1.0000000092p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffff6d), -0x1.0000000093p+40, 0x0p+0 },
{ INT64_C(0x00000100000000c0), 0x1.00000000cp+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffff3f), -0x1.00000000c1p+40, 0x0p+0 },
{ INT64_C(0x00000100000000c2), 0x1.00000000c2p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffff3d), -0x1.00000000c3p+40, 0x0p+0 },
{ INT64_C(0x00000100000000c8), 0x1.00000000c8p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffff37), -0x1.00000000c9p+40, 0x0p+0 },
{ INT64_C(0x0000010000000404), 0x1.0000000404p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffffbfb), -0x1.0000000405p+40, 0x0p+0 },
{ INT64_C(0x0000010000000440), 0x1.000000044p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffffbbf), -0x1.0000000441p+40, 0x0p+0 },
{ INT64_C(0x0000010000000441), 0x1.0000000441p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffffbbe), -0x1.0000000442p+40, 0x0p+0 },
{ INT64_C(0x0000010000000442), 0x1.0000000442p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffffbbd), -0x1.0000000443p+40, 0x0p+0 },
{ INT64_C(0x0000010000000444), 0x1.0000000444p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffffbbb), -0x1.0000000445p+40, 0x0p+0 },
{ INT64_C(0x0000010000000448), 0x1.0000000448p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffffbb7), -0x1.0000000449p+40, 0x0p+0 },
{ INT64_C(0x0000010000000460), 0x1.000000046p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffffb9f), -0x1.0000000461p+40, 0x0p+0 },
{ INT64_C(0x0000010000001008), 0x1.0000001008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffeff7), -0x1.0000001009p+40, 0x0p+0 },
{ INT64_C(0x0000010000001009), 0x1.0000001009p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffeff6), -0x1.000000100ap+40, 0x0p+0 },
{ INT64_C(0x0000010000001080), 0x1.000000108p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffef7f), -0x1.0000001081p+40, 0x0p+0 },
{ INT64_C(0x0000010000001088), 0x1.0000001088p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffef77), -0x1.0000001089p+40, 0x0p+0 },
{ INT64_C(0x0000010000001200), 0x1.00000012p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffedff), -0x1.0000001201p+40, 0x0p+0 },
{ INT64_C(0x0000010000001202), 0x1.0000001202p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffedfd), -0x1.0000001203p+40, 0x0p+0 },
{ INT64_C(0x0000010000001204), 0x1.0000001204p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffedfb), -0x1.0000001205p+40, 0x0p+0 },
{ INT64_C(0x0000010000001208), 0x1.0000001208p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffedf7), -0x1.0000001209p+40, 0x0p+0 },
{ INT64_C(0x0000010000001280), 0x1.000000128p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffed7f), -0x1.0000001281p+40, 0x0p+0 },
{ INT64_C(0x0000010000001300), 0x1.00000013p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffecff), -0x1.0000001301p+40, 0x0p+0 },
{ INT64_C(0x0000010000001400), 0x1.00000014p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffebff), -0x1.0000001401p+40, 0x0p+0 },
{ INT64_C(0x0000010000001402), 0x1.0000001402p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffebfd), -0x1.0000001403p+40, 0x0p+0 },
{ INT64_C(0x0000010000001408), 0x1.0000001408p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffebf7), -0x1.0000001409p+40, 0x0p+0 },
{ INT64_C(0x0000010000001480), 0x1.000000148p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffeb7f), -0x1.0000001481p+40, 0x0p+0 },
{ INT64_C(0x0000010000001600), 0x1.00000016p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffe9ff), -0x1.0000001601p+40, 0x0p+0 },
{ INT64_C(0x0000010000004004), 0x1.0000004004p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffbffb), -0x1.0000004005p+40, 0x0p+0 },
{ INT64_C(0x0000010000004040), 0x1.000000404p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffbfbf), -0x1.0000004041p+40, 0x0p+0 },
{ INT64_C(0x0000010000004044), 0x1.0000004044p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffbfbb), -0x1.0000004045p+40, 0x0p+0 },
{ INT64_C(0x0000010000004050), 0x1.000000405p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffbfaf), -0x1.0000004051p+40, 0x0p+0 },
{ INT64_C(0x0000010000004080), 0x1.000000408p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffbf7f), -0x1.0000004081p+40, 0x0p+0 },
{ INT64_C(0x0000010000004088), 0x1.0000004088p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffbf77), -0x1.0000004089p+40, 0x0p+0 },
{ INT64_C(0x0000010000004800), 0x1.00000048p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffb7ff), -0x1.0000004801p+40, 0x0p+0 },
{ INT64_C(0x0000010000004804), 0x1.0000004804p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffb7fb), -0x1.0000004805p+40, 0x0p+0 },
{ INT64_C(0x0000010000004820), 0x1.000000482p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffb7df), -0x1.0000004821p+40, 0x0p+0 },
{ INT64_C(0x0000010000004840), 0x1.000000484p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffb7bf), -0x1.0000004841p+40, 0x0p+0 },
{ INT64_C(0x0000010000004900), 0x1.00000049p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffb6ff), -0x1.0000004901p+40, 0x0p+0 },
{ INT64_C(0x0000010000004c00), 0x1.0000004cp+40, 0x0p+0 },
{ INT64_C(0xfffffeffffffb3ff), -0x1.0000004c01p+40, 0x0p+0 },
{ INT64_C(0x0000010000040001), 0x1.0000040001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbfffe), -0x1.0000040002p+40, 0x0p+0 },
{ INT64_C(0x0000010000040008), 0x1.0000040008p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbfff7), -0x1.0000040009p+40, 0x0p+0 },
{ INT64_C(0x0000010000040009), 0x1.0000040009p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbfff6), -0x1.000004000ap+40, 0x0p+0 },
{ INT64_C(0x0000010000040010), 0x1.000004001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbffef), -0x1.0000040011p+40, 0x0p+0 },
{ INT64_C(0x0000010000040011), 0x1.0000040011p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbffee), -0x1.0000040012p+40, 0x0p+0 },
{ INT64_C(0x0000010000040014), 0x1.0000040014p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbffeb), -0x1.0000040015p+40, 0x0p+0 },
{ INT64_C(0x0000010000040040), 0x1.000004004p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbffbf), -0x1.0000040041p+40, 0x0p+0 },
{ INT64_C(0x0000010000040041), 0x1.0000040041p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbffbe), -0x1.0000040042p+40, 0x0p+0 },
{ INT64_C(0x0000010000040048), 0x1.0000040048p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbffb7), -0x1.0000040049p+40, 0x0p+0 },
{ INT64_C(0x0000010000040200), 0x1.00000402p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbfdff), -0x1.0000040201p+40, 0x0p+0 },
{ INT64_C(0x0000010000040208), 0x1.0000040208p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbfdf7), -0x1.0000040209p+40, 0x0p+0 },
{ INT64_C(0x0000010000040220), 0x1.000004022p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbfddf), -0x1.0000040221p+40, 0x0p+0 },
{ INT64_C(0x0000010000040300), 0x1.00000403p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbfcff), -0x1.0000040301p+40, 0x0p+0 },
{ INT64_C(0x0000010000040800), 0x1.00000408p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbf7ff), -0x1.0000040801p+40, 0x0p+0 },
{ INT64_C(0x0000010000040801), 0x1.0000040801p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbf7fe), -0x1.0000040802p+40, 0x0p+0 },
{ INT64_C(0x0000010000040808), 0x1.0000040808p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbf7f7), -0x1.0000040809p+40, 0x0p+0 },
{ INT64_C(0x0000010000040820), 0x1.000004082p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbf7df), -0x1.0000040821p+40, 0x0p+0 },
{ INT64_C(0x0000010000040840), 0x1.000004084p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbf7bf), -0x1.0000040841p+40, 0x0p+0 },
{ INT64_C(0x0000010000040880), 0x1.000004088p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbf77f), -0x1.0000040881p+40, 0x0p+0 },
{ INT64_C(0x0000010000040c00), 0x1.0000040cp+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbf3ff), -0x1.0000040c01p+40, 0x0p+0 },
{ INT64_C(0x0000010000044000), 0x1.0000044p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbbfff), -0x1.0000044001p+40, 0x0p+0 },
{ INT64_C(0x0000010000044008), 0x1.0000044008p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbbff7), -0x1.0000044009p+40, 0x0p+0 },
{ INT64_C(0x0000010000044020), 0x1.000004402p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbbfdf), -0x1.0000044021p+40, 0x0p+0 },
{ INT64_C(0x0000010000044100), 0x1.00000441p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbbeff), -0x1.0000044101p+40, 0x0p+0 },
{ INT64_C(0x0000010000044400), 0x1.00000444p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbbbff), -0x1.0000044401p+40, 0x0p+0 },
{ INT64_C(0x0000010000044800), 0x1.00000448p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffbb7ff), -0x1.0000044801p+40, 0x0p+0 },
{ INT64_C(0x0000010000046000), 0x1.0000046p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffb9fff), -0x1.0000046001p+40, 0x0p+0 },
{ INT64_C(0x0000010000048000), 0x1.0000048p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffb7fff), -0x1.0000048001p+40, 0x0p+0 },
{ INT64_C(0x0000010000048004), 0x1.0000048004p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffb7ffb), -0x1.0000048005p+40, 0x0p+0 },
{ INT64_C(0x0000010000048010), 0x1.000004801p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffb7fef), -0x1.0000048011p+40, 0x0p+0 },
{ INT64_C(0x0000010000048040), 0x1.000004804p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffb7fbf), -0x1.0000048041p+40, 0x0p+0 },
{ INT64_C(0x0000010000048100), 0x1.00000481p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffb7eff), -0x1.0000048101p+40, 0x0p+0 },
{ INT64_C(0x0000010000049000), 0x1.0000049p+40, 0x0p+0 },
{ INT64_C(0xfffffefffffb6fff), -0x1.0000049001p+40, 0x0p+0 },
{ INT64_C(0x0000010000060000), 0x1.000006p+40, 0x0p+0 },
{ INT64_C(0xfffffefffff9ffff), -0x1.0000060001p+40, 0x0p+0 },
{ INT64_C(0x0000010000060004), 0x1.0000060004p+40, 0x0p+0 },
{ INT64_C(0xfffffefffff9fffb), -0x1.0000060005p+40, 0x0p+0 },
{ INT64_C(0x0000010000060020), 0x1.000006002p+40, 0x0p+0 },
{ INT64_C(0xfffffefffff9ffdf), -0x1.0000060021p+40, 0x0p+0 },
{ INT64_C(0x0000010000060080), 0x1.000006008p+40, 0x0p+0 },
{ INT64_C(0xfffffefffff9ff7f), -0x1.0000060081p+40, 0x0p+0 },
{ INT64_C(0x0000010000060800), 0x1.00000608p+40, 0x0p+0 },
{ INT64_C(0xfffffefffff9f7ff), -0x1.0000060801p+40, 0x0p+0 },
{ INT64_C(0x0000010000061000), 0x1.0000061p+40, 0x0p+0 },
{ INT64_C(0xfffffefffff9efff), -0x1.0000061001p+40, 0x0p+0 },
{ INT64_C(0x0000010000064000), 0x1.0000064p+40, 0x0p+0 },
{ INT64_C(0xfffffefffff9bfff), -0x1.0000064001p+40, 0x0p+0 },
{ INT64_C(0x0000010000068000), 0x1.0000068p+40, 0x0p+0 },
{ INT64_C(0xfffffefffff97fff), -0x1.0000068001p+40, 0x0p+0 },
{ INT64_C(0x0000010000100008), 0x1.0000100008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffeffff7), -0x1.0000100009p+40, 0x0p+0 },
{ INT64_C(0x0000010000100080), 0x1.000010008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffefff7f), -0x1.0000100081p+40, 0x0p+0 },
{ INT64_C(0x0000010000100082), 0x1.0000100082p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffefff7d), -0x1.0000100083p+40, 0x0p+0 },
{ INT64_C(0x0000010000100088), 0x1.0000100088p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffefff77), -0x1.0000100089p+40, 0x0p+0 },
{ INT64_C(0x0000010000100090), 0x1.000010009p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffefff6f), -0x1.0000100091p+40, 0x0p+0 },
{ INT64_C(0x0000010000100100), 0x1.00001001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffeffeff), -0x1.0000100101p+40, 0x0p+0 },
{ INT64_C(0x0000010000100104), 0x1.0000100104p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffeffefb), -0x1.0000100105p+40, 0x0p+0 },
{ INT64_C(0x0000010000100108), 0x1.0000100108p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffeffef7), -0x1.0000100109p+40, 0x0p+0 },
{ INT64_C(0x0000010000100180), 0x1.000010018p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffeffe7f), -0x1.0000100181p+40, 0x0p+0 },
{ INT64_C(0x0000010000101000), 0x1.0000101p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffefefff), -0x1.0000101001p+40, 0x0p+0 },
{ INT64_C(0x0000010000101008), 0x1.0000101008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffefeff7), -0x1.0000101009p+40, 0x0p+0 },
{ INT64_C(0x0000010000101080), 0x1.000010108p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffefef7f), -0x1.0000101081p+40, 0x0p+0 },
{ INT64_C(0x0000010000101400), 0x1.00001014p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffefebff), -0x1.0000101401p+40, 0x0p+0 },
{ INT64_C(0x0000010000110000), 0x1.000011p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffeeffff), -0x1.0000110001p+40, 0x0p+0 },
{ INT64_C(0x0000010000110002), 0x1.0000110002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffeefffd), -0x1.0000110003p+40, 0x0p+0 },
{ INT64_C(0x0000010000110020), 0x1.000011002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffeeffdf), -0x1.0000110021p+40, 0x0p+0 },
{ INT64_C(0x0000010000110100), 0x1.00001101p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffeefeff), -0x1.0000110101p+40, 0x0p+0 },
{ INT64_C(0x0000010000111000), 0x1.0000111p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffeeefff), -0x1.0000111001p+40, 0x0p+0 },
{ INT64_C(0x0000010000114000), 0x1.0000114p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffeebfff), -0x1.0000114001p+40, 0x0p+0 },
{ INT64_C(0x0000010000400008), 0x1.0000400008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbffff7), -0x1.0000400009p+40, 0x0p+0 },
{ INT64_C(0x000001000040000c), 0x1.000040000cp+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbffff3), -0x1.000040000dp+40, 0x0p+0 },
{ INT64_C(0x0000010000400020), 0x1.000040002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbfffdf), -0x1.0000400021p+40, 0x0p+0 },
{ INT64_C(0x0000010000400022), 0x1.0000400022p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbfffdd), -0x1.0000400023p+40, 0x0p+0 },
{ INT64_C(0x0000010000400028), 0x1.0000400028p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbfffd7), -0x1.0000400029p+40, 0x0p+0 },
{ INT64_C(0x0000010000400100), 0x1.00004001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbffeff), -0x1.0000400101p+40, 0x0p+0 },
{ INT64_C(0x0000010000400104), 0x1.0000400104p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbffefb), -0x1.0000400105p+40, 0x0p+0 },
{ INT64_C(0x0000010000400108), 0x1.0000400108p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbffef7), -0x1.0000400109p+40, 0x0p+0 },
{ INT64_C(0x0000010000400120), 0x1.000040012p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbffedf), -0x1.0000400121p+40, 0x0p+0 },
{ INT64_C(0x0000010000400400), 0x1.00004004p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbffbff), -0x1.0000400401p+40, 0x0p+0 },
{ INT64_C(0x0000010000400401), 0x1.0000400401p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbffbfe), -0x1.0000400402p+40, 0x0p+0 },
{ INT64_C(0x0000010000400408), 0x1.0000400408p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbffbf7), -0x1.0000400409p+40, 0x0p+0 },
{ INT64_C(0x0000010000400410), 0x1.000040041p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbffbef), -0x1.0000400411p+40, 0x0p+0 },
{ INT64_C(0x0000010000400500), 0x1.00004005p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbffaff), -0x1.0000400501p+40, 0x0p+0 },
{ INT64_C(0x0000010000400600), 0x1.00004006p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbff9ff), -0x1.0000400601p+40, 0x0p+0 },
{ INT64_C(0x0000010000404000), 0x1.0000404p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbfbfff), -0x1.0000404001p+40, 0x0p+0 },
{ INT64_C(0x0000010000404004), 0x1.0000404004p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbfbffb), -0x1.0000404005p+40, 0x0p+0 },
{ INT64_C(0x0000010000404008), 0x1.0000404008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbfbff7), -0x1.0000404009p+40, 0x0p+0 },
{ INT64_C(0x0000010000404040), 0x1.000040404p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbfbfbf), -0x1.0000404041p+40, 0x0p+0 },
{ INT64_C(0x0000010000404080), 0x1.000040408p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbfbf7f), -0x1.0000404081p+40, 0x0p+0 },
{ INT64_C(0x0000010000404400), 0x1.00004044p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbfbbff), -0x1.0000404401p+40, 0x0p+0 },
{ INT64_C(0x0000010000405000), 0x1.0000405p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbfafff), -0x1.0000405001p+40, 0x0p+0 },
{ INT64_C(0x0000010000406000), 0x1.0000406p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbf9fff), -0x1.0000406001p+40, 0x0p+0 },
{ INT64_C(0x0000010000408000), 0x1.0000408p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbf7fff), -0x1.0000408001p+40, 0x0p+0 },
{ INT64_C(0x0000010000408008), 0x1.0000408008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbf7ff7), -0x1.0000408009p+40, 0x0p+0 },
{ INT64_C(0x0000010000408040), 0x1.000040804p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbf7fbf), -0x1.0000408041p+40, 0x0p+0 },
{ INT64_C(0x0000010000408400), 0x1.00004084p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbf7bff), -0x1.0000408401p+40, 0x0p+0 },
{ INT64_C(0x0000010000409000), 0x1.0000409p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffbf6fff), -0x1.0000409001p+40, 0x0p+0 },
{ INT64_C(0x0000010000480000), 0x1.000048p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffb7ffff), -0x1.0000480001p+40, 0x0p+0 },
{ INT64_C(0x0000010000480004), 0x1.0000480004p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffb7fffb), -0x1.0000480005p+40, 0x0p+0 },
{ INT64_C(0x0000010000480008), 0x1.0000480008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffb7fff7), -0x1.0000480009p+40, 0x0p+0 },
{ INT64_C(0x0000010000480020), 0x1.000048002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffb7ffdf), -0x1.0000480021p+40, 0x0p+0 },
{ INT64_C(0x0000010000480080), 0x1.000048008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffb7ff7f), -0x1.0000480081p+40, 0x0p+0 },
{ INT64_C(0x0000010000480200), 0x1.00004802p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffb7fdff), -0x1.0000480201p+40, 0x0p+0 },
{ INT64_C(0x0000010000481000), 0x1.0000481p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffb7efff), -0x1.0000481001p+40, 0x0p+0 },
{ INT64_C(0x0000010000488000), 0x1.0000488p+40, 0x0p+0 },
{ INT64_C(0xfffffeffffb77fff), -0x1.0000488001p+40, 0x0p+0 },
{ INT64_C(0x00000100004a0000), 0x1.00004ap+40, 0x0p+0 },
{ INT64_C(0xfffffeffffb5ffff), -0x1.00004a0001p+40, 0x0p+0 },
{ INT64_C(0x0000010000600000), 0x1.00006p+40, 0x0p+0 },
{ INT64_C(0xfffffeffff9fffff), -0x1.0000600001p+40, 0x0p+0 },
{ INT64_C(0x0000010000600004), 0x1.0000600004p+40, 0x0p+0 },
{ INT64_C(0xfffffeffff9ffffb), -0x1.0000600005p+40, 0x0p+0 },
{ INT64_C(0x0000010000600010), 0x1.000060001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffff9fffef), -0x1.0000600011p+40, 0x0p+0 },
{ INT64_C(0x0000010000600020), 0x1.000060002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffff9fffdf), -0x1.0000600021p+40, 0x0p+0 },
{ INT64_C(0x0000010000600040), 0x1.000060004p+40, 0x0p+0 },
{ INT64_C(0xfffffeffff9fffbf), -0x1.0000600041p+40, 0x0p+0 },
{ INT64_C(0x0000010000600200), 0x1.00006002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffff9ffdff), -0x1.0000600201p+40, 0x0p+0 },
{ INT64_C(0x0000010000601000), 0x1.0000601p+40, 0x0p+0 },
{ INT64_C(0xfffffeffff9fefff), -0x1.0000601001p+40, 0x0p+0 },
{ INT64_C(0x0000010000608000), 0x1.0000608p+40, 0x0p+0 },
{ INT64_C(0xfffffeffff9f7fff), -0x1.0000608001p+40, 0x0p+0 },
{ INT64_C(0x0000010000620000), 0x1.000062p+40, 0x0p+0 },
{ INT64_C(0xfffffeffff9dffff), -0x1.0000620001p+40, 0x0p+0 },
{ INT64_C(0x0000010000680000), 0x1.000068p+40, 0x0p+0 },
{ INT64_C(0xfffffeffff97ffff), -0x1.0000680001p+40, 0x0p+0 },
{ INT64_C(0x0000010004000001), 0x1.0004000001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfffffe), -0x1.0004000002p+40, 0x0p+0 },
{ INT64_C(0x0000010004000010), 0x1.000400001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffffef), -0x1.0004000011p+40, 0x0p+0 },
{ INT64_C(0x0000010004000012), 0x1.0004000012p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffffed), -0x1.0004000013p+40, 0x0p+0 },
{ INT64_C(0x0000010004000040), 0x1.000400004p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffffbf), -0x1.0004000041p+40, 0x0p+0 },
{ INT64_C(0x0000010004000048), 0x1.0004000048p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffffb7), -0x1.0004000049p+40, 0x0p+0 },
{ INT64_C(0x0000010004000100), 0x1.00040001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfffeff), -0x1.0004000101p+40, 0x0p+0 },
{ INT64_C(0x0000010004000108), 0x1.0004000108p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfffef7), -0x1.0004000109p+40, 0x0p+0 },
{ INT64_C(0x0000010004000110), 0x1.000400011p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfffeef), -0x1.0004000111p+40, 0x0p+0 },
{ INT64_C(0x0000010004000180), 0x1.000400018p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfffe7f), -0x1.0004000181p+40, 0x0p+0 },
{ INT64_C(0x0000010004000400), 0x1.00040004p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfffbff), -0x1.0004000401p+40, 0x0p+0 },
{ INT64_C(0x0000010004000401), 0x1.0004000401p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfffbfe), -0x1.0004000402p+40, 0x0p+0 },
{ INT64_C(0x0000010004000402), 0x1.0004000402p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfffbfd), -0x1.0004000403p+40, 0x0p+0 },
{ INT64_C(0x0000010004000420), 0x1.000400042p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfffbdf), -0x1.0004000421p+40, 0x0p+0 },
{ INT64_C(0x0000010004000440), 0x1.000400044p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfffbbf), -0x1.0004000441p+40, 0x0p+0 },
{ INT64_C(0x0000010004000480), 0x1.000400048p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfffb7f), -0x1.0004000481p+40, 0x0p+0 },
{ INT64_C(0x0000010004000600), 0x1.00040006p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfff9ff), -0x1.0004000601p+40, 0x0p+0 },
{ INT64_C(0x0000010004001000), 0x1.0004001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffefff), -0x1.0004001001p+40, 0x0p+0 },
{ INT64_C(0x0000010004001001), 0x1.0004001001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffeffe), -0x1.0004001002p+40, 0x0p+0 },
{ INT64_C(0x0000010004001002), 0x1.0004001002p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffeffd), -0x1.0004001003p+40, 0x0p+0 },
{ INT64_C(0x0000010004001008), 0x1.0004001008p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffeff7), -0x1.0004001009p+40, 0x0p+0 },
{ INT64_C(0x0000010004001080), 0x1.000400108p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffef7f), -0x1.0004001081p+40, 0x0p+0 },
{ INT64_C(0x0000010004001400), 0x1.00040014p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffebff), -0x1.0004001401p+40, 0x0p+0 },
{ INT64_C(0x0000010004002000), 0x1.0004002p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffdfff), -0x1.0004002001p+40, 0x0p+0 },
{ INT64_C(0x0000010004002001), 0x1.0004002001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffdffe), -0x1.0004002002p+40, 0x0p+0 },
{ INT64_C(0x0000010004002002), 0x1.0004002002p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffdffd), -0x1.0004002003p+40, 0x0p+0 },
{ INT64_C(0x0000010004002004), 0x1.0004002004p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffdffb), -0x1.0004002005p+40, 0x0p+0 },
{ INT64_C(0x0000010004002010), 0x1.000400201p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffdfef), -0x1.0004002011p+40, 0x0p+0 },
{ INT64_C(0x0000010004002100), 0x1.00040021p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffdeff), -0x1.0004002101p+40, 0x0p+0 },
{ INT64_C(0x0000010004002400), 0x1.00040024p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffdbff), -0x1.0004002401p+40, 0x0p+0 },
{ INT64_C(0x0000010004002800), 0x1.00040028p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbffd7ff), -0x1.0004002801p+40, 0x0p+0 },
{ INT64_C(0x0000010004020000), 0x1.000402p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfdffff), -0x1.0004020001p+40, 0x0p+0 },
{ INT64_C(0x0000010004020001), 0x1.0004020001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfdfffe), -0x1.0004020002p+40, 0x0p+0 },
{ INT64_C(0x0000010004020002), 0x1.0004020002p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfdfffd), -0x1.0004020003p+40, 0x0p+0 },
{ INT64_C(0x0000010004020008), 0x1.0004020008p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfdfff7), -0x1.0004020009p+40, 0x0p+0 },
{ INT64_C(0x0000010004020010), 0x1.000402001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfdffef), -0x1.0004020011p+40, 0x0p+0 },
{ INT64_C(0x0000010004020080), 0x1.000402008p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfdff7f), -0x1.0004020081p+40, 0x0p+0 },
{ INT64_C(0x0000010004020400), 0x1.00040204p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfdfbff), -0x1.0004020401p+40, 0x0p+0 },
{ INT64_C(0x0000010004022000), 0x1.0004022p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfddfff), -0x1.0004022001p+40, 0x0p+0 },
{ INT64_C(0x0000010004030000), 0x1.000403p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbfcffff), -0x1.0004030001p+40, 0x0p+0 },
{ INT64_C(0x0000010004200000), 0x1.00042p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbdfffff), -0x1.0004200001p+40, 0x0p+0 },
{ INT64_C(0x0000010004200001), 0x1.0004200001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbdffffe), -0x1.0004200002p+40, 0x0p+0 },
{ INT64_C(0x0000010004200002), 0x1.0004200002p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbdffffd), -0x1.0004200003p+40, 0x0p+0 },
{ INT64_C(0x0000010004200008), 0x1.0004200008p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbdffff7), -0x1.0004200009p+40, 0x0p+0 },
{ INT64_C(0x0000010004200080), 0x1.000420008p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbdfff7f), -0x1.0004200081p+40, 0x0p+0 },
{ INT64_C(0x0000010004200800), 0x1.00042008p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbdff7ff), -0x1.0004200801p+40, 0x0p+0 },
{ INT64_C(0x0000010004202000), 0x1.0004202p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbdfdfff), -0x1.0004202001p+40, 0x0p+0 },
{ INT64_C(0x0000010004208000), 0x1.0004208p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbdf7fff), -0x1.0004208001p+40, 0x0p+0 },
{ INT64_C(0x0000010004280000), 0x1.000428p+40, 0x0p+0 },
{ INT64_C(0xfffffefffbd7ffff), -0x1.0004280001p+40, 0x0p+0 },
{ INT64_C(0x0000010005000000), 0x1.0005p+40, 0x0p+0 },
{ INT64_C(0xfffffefffaffffff), -0x1.0005000001p+40, 0x0p+0 },
{ INT64_C(0x0000010005000001), 0x1.0005000001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffafffffe), -0x1.0005000002p+40, 0x0p+0 },
{ INT64_C(0x0000010005000002), 0x1.0005000002p+40, 0x0p+0 },
{ INT64_C(0xfffffefffafffffd), -0x1.0005000003p+40, 0x0p+0 },
{ INT64_C(0x0000010005000010), 0x1.000500001p+40, 0x0p+0 },
{ INT64_C(0xfffffefffaffffef), -0x1.0005000011p+40, 0x0p+0 },
{ INT64_C(0x0000010005000080), 0x1.000500008p+40, 0x0p+0 },
{ INT64_C(0xfffffefffaffff7f), -0x1.0005000081p+40, 0x0p+0 },
{ INT64_C(0x0000010005000200), 0x1.00050002p+40, 0x0p+0 },
{ INT64_C(0xfffffefffafffdff), -0x1.0005000201p+40, 0x0p+0 },
{ INT64_C(0x0000010005002000), 0x1.0005002p+40, 0x0p+0 },
{ INT64_C(0xfffffefffaffdfff), -0x1.0005002001p+40, 0x0p+0 },
{ INT64_C(0x0000010005020000), 0x1.000502p+40, 0x0p+0 },
{ INT64_C(0xfffffefffafdffff), -0x1.0005020001p+40, 0x0p+0 },
{ INT64_C(0x0000010005040000), 0x1.000504p+40, 0x0p+0 },
{ INT64_C(0xfffffefffafbffff), -0x1.0005040001p+40, 0x0p+0 },
{ INT64_C(0x0000010005400000), 0x1.00054p+40, 0x0p+0 },
{ INT64_C(0xfffffefffabfffff), -0x1.0005400001p+40, 0x0p+0 },
{ INT64_C(0x0000010040000008), 0x1.0040000008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffffff7), -0x1.0040000009p+40, 0x0p+0 },
{ INT64_C(0x000001004000000c), 0x1.004000000cp+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffffff3), -0x1.004000000dp+40, 0x0p+0 },
{ INT64_C(0x0000010040000020), 0x1.004000002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffffdf), -0x1.0040000021p+40, 0x0p+0 },
{ INT64_C(0x0000010040000028), 0x1.0040000028p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffffd7), -0x1.0040000029p+40, 0x0p+0 },
{ INT64_C(0x0000010040000030), 0x1.004000003p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffffcf), -0x1.0040000031p+40, 0x0p+0 },
{ INT64_C(0x0000010040000040), 0x1.004000004p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffffbf), -0x1.0040000041p+40, 0x0p+0 },
{ INT64_C(0x0000010040000042), 0x1.0040000042p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffffbd), -0x1.0040000043p+40, 0x0p+0 },
{ INT64_C(0x0000010040000048), 0x1.0040000048p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffffb7), -0x1.0040000049p+40, 0x0p+0 },
{ INT64_C(0x0000010040000060), 0x1.004000006p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffff9f), -0x1.0040000061p+40, 0x0p+0 },
{ INT64_C(0x0000010040000080), 0x1.004000008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffff7f), -0x1.0040000081p+40, 0x0p+0 },
{ INT64_C(0x0000010040000088), 0x1.0040000088p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffff77), -0x1.0040000089p+40, 0x0p+0 },
{ INT64_C(0x00000100400000a0), 0x1.00400000ap+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffff5f), -0x1.00400000a1p+40, 0x0p+0 },
{ INT64_C(0x0000010040000800), 0x1.00400008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffff7ff), -0x1.0040000801p+40, 0x0p+0 },
{ INT64_C(0x0000010040000801), 0x1.0040000801p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffff7fe), -0x1.0040000802p+40, 0x0p+0 },
{ INT64_C(0x0000010040000808), 0x1.0040000808p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffff7f7), -0x1.0040000809p+40, 0x0p+0 },
{ INT64_C(0x0000010040000880), 0x1.004000088p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffff77f), -0x1.0040000881p+40, 0x0p+0 },
{ INT64_C(0x0000010040001000), 0x1.0040001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffefff), -0x1.0040001001p+40, 0x0p+0 },
{ INT64_C(0x0000010040001002), 0x1.0040001002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffeffd), -0x1.0040001003p+40, 0x0p+0 },
{ INT64_C(0x0000010040001008), 0x1.0040001008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffeff7), -0x1.0040001009p+40, 0x0p+0 },
{ INT64_C(0x0000010040001040), 0x1.004000104p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffefbf), -0x1.0040001041p+40, 0x0p+0 },
{ INT64_C(0x0000010040001080), 0x1.004000108p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffef7f), -0x1.0040001081p+40, 0x0p+0 },
{ INT64_C(0x0000010040001100), 0x1.00400011p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffeeff), -0x1.0040001101p+40, 0x0p+0 },
{ INT64_C(0x0000010040001200), 0x1.00400012p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfffedff), -0x1.0040001201p+40, 0x0p+0 },
{ INT64_C(0x0000010040010000), 0x1.004001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffeffff), -0x1.0040010001p+40, 0x0p+0 },
{ INT64_C(0x0000010040010001), 0x1.0040010001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffefffe), -0x1.0040010002p+40, 0x0p+0 },
{ INT64_C(0x0000010040010008), 0x1.0040010008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffefff7), -0x1.0040010009p+40, 0x0p+0 },
{ INT64_C(0x0000010040010010), 0x1.004001001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffeffef), -0x1.0040010011p+40, 0x0p+0 },
{ INT64_C(0x0000010040010020), 0x1.004001002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffeffdf), -0x1.0040010021p+40, 0x0p+0 },
{ INT64_C(0x0000010040010040), 0x1.004001004p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffeffbf), -0x1.0040010041p+40, 0x0p+0 },
{ INT64_C(0x0000010040010080), 0x1.004001008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffeff7f), -0x1.0040010081p+40, 0x0p+0 },
{ INT64_C(0x0000010040010200), 0x1.00400102p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffefdff), -0x1.0040010201p+40, 0x0p+0 },
{ INT64_C(0x0000010040010800), 0x1.00400108p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffef7ff), -0x1.0040010801p+40, 0x0p+0 },
{ INT64_C(0x0000010040011000), 0x1.0040011p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffeefff), -0x1.0040011001p+40, 0x0p+0 },
{ INT64_C(0x0000010040014000), 0x1.0040014p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbffebfff), -0x1.0040014001p+40, 0x0p+0 },
{ INT64_C(0x0000010040080000), 0x1.004008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbff7ffff), -0x1.0040080001p+40, 0x0p+0 },
{ INT64_C(0x0000010040080002), 0x1.0040080002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbff7fffd), -0x1.0040080003p+40, 0x0p+0 },
{ INT64_C(0x0000010040080020), 0x1.004008002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbff7ffdf), -0x1.0040080021p+40, 0x0p+0 },
{ INT64_C(0x0000010040080040), 0x1.004008004p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbff7ffbf), -0x1.0040080041p+40, 0x0p+0 },
{ INT64_C(0x0000010040080400), 0x1.00400804p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbff7fbff), -0x1.0040080401p+40, 0x0p+0 },
{ INT64_C(0x0000010040080800), 0x1.00400808p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbff7f7ff), -0x1.0040080801p+40, 0x0p+0 },
{ INT64_C(0x0000010040081000), 0x1.0040081p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbff7efff), -0x1.0040081001p+40, 0x0p+0 },
{ INT64_C(0x0000010040090000), 0x1.004009p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbff6ffff), -0x1.0040090001p+40, 0x0p+0 },
{ INT64_C(0x00000100400c0000), 0x1.00400cp+40, 0x0p+0 },
{ INT64_C(0xfffffeffbff3ffff), -0x1.00400c0001p+40, 0x0p+0 },
{ INT64_C(0x0000010040400000), 0x1.00404p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfbfffff), -0x1.0040400001p+40, 0x0p+0 },
{ INT64_C(0x0000010040400008), 0x1.0040400008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfbffff7), -0x1.0040400009p+40, 0x0p+0 },
{ INT64_C(0x0000010040400010), 0x1.004040001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfbfffef), -0x1.0040400011p+40, 0x0p+0 },
{ INT64_C(0x0000010040400100), 0x1.00404001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfbffeff), -0x1.0040400101p+40, 0x0p+0 },
{ INT64_C(0x0000010040400200), 0x1.00404002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfbffdff), -0x1.0040400201p+40, 0x0p+0 },
{ INT64_C(0x0000010040402000), 0x1.0040402p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfbfdfff), -0x1.0040402001p+40, 0x0p+0 },
{ INT64_C(0x0000010040404000), 0x1.0040404p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfbfbfff), -0x1.0040404001p+40, 0x0p+0 },
{ INT64_C(0x0000010040410000), 0x1.004041p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfbeffff), -0x1.0040410001p+40, 0x0p+0 },
{ INT64_C(0x0000010040480000), 0x1.004048p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfb7ffff), -0x1.0040480001p+40, 0x0p+0 },
{ INT64_C(0x0000010040500000), 0x1.00405p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbfafffff), -0x1.0040500001p+40, 0x0p+0 },
{ INT64_C(0x0000010042000000), 0x1.0042p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbdffffff), -0x1.0042000001p+40, 0x0p+0 },
{ INT64_C(0x0000010042000004), 0x1.0042000004p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbdfffffb), -0x1.0042000005p+40, 0x0p+0 },
{ INT64_C(0x0000010042000010), 0x1.004200001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbdffffef), -0x1.0042000011p+40, 0x0p+0 },
{ INT64_C(0x0000010042000020), 0x1.004200002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbdffffdf), -0x1.0042000021p+40, 0x0p+0 },
{ INT64_C(0x0000010042000200), 0x1.00420002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbdfffdff), -0x1.0042000201p+40, 0x0p+0 },
{ INT64_C(0x0000010042001000), 0x1.0042001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbdffefff), -0x1.0042001001p+40, 0x0p+0 },
{ INT64_C(0x0000010042004000), 0x1.0042004p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbdffbfff), -0x1.0042004001p+40, 0x0p+0 },
{ INT64_C(0x0000010042008000), 0x1.0042008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbdff7fff), -0x1.0042008001p+40, 0x0p+0 },
{ INT64_C(0x0000010042040000), 0x1.004204p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbdfbffff), -0x1.0042040001p+40, 0x0p+0 },
{ INT64_C(0x0000010042080000), 0x1.004208p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbdf7ffff), -0x1.0042080001p+40, 0x0p+0 },
{ INT64_C(0x0000010042400000), 0x1.00424p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbdbfffff), -0x1.0042400001p+40, 0x0p+0 },
{ INT64_C(0x0000010044000000), 0x1.0044p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbbffffff), -0x1.0044000001p+40, 0x0p+0 },
{ INT64_C(0x0000010044000001), 0x1.0044000001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbbfffffe), -0x1.0044000002p+40, 0x0p+0 },
{ INT64_C(0x0000010044000002), 0x1.0044000002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbbfffffd), -0x1.0044000003p+40, 0x0p+0 },
{ INT64_C(0x0000010044000020), 0x1.004400002p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbbffffdf), -0x1.0044000021p+40, 0x0p+0 },
{ INT64_C(0x0000010044000100), 0x1.00440001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbbfffeff), -0x1.0044000101p+40, 0x0p+0 },
{ INT64_C(0x0000010044001000), 0x1.0044001p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbbffefff), -0x1.0044001001p+40, 0x0p+0 },
{ INT64_C(0x0000010044004000), 0x1.0044004p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbbffbfff), -0x1.0044004001p+40, 0x0p+0 },
{ INT64_C(0x0000010044008000), 0x1.0044008p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbbff7fff), -0x1.0044008001p+40, 0x0p+0 },
{ INT64_C(0x0000010044010000), 0x1.004401p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbbfeffff), -0x1.0044010001p+40, 0x0p+0 },
{ INT64_C(0x0000010044020000), 0x1.004402p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbbfdffff), -0x1.0044020001p+40, 0x0p+0 },
{ INT64_C(0x0000010044040000), 0x1.004404p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbbfbffff), -0x1.0044040001p+40, 0x0p+0 },
{ INT64_C(0x0000010044200000), 0x1.00442p+40, 0x0p+0 },
{ INT64_C(0xfffffeffbbdfffff), -0x1.0044200001p+40, 0x0p+0 },
{ INT64_C(0x0000010046000000), 0x1.0046p+40, 0x0p+0 },
{ INT64_C(0xfffffeffb9ffffff), -0x1.0046000001p+40, 0x0p+0 },
{ INT64_C(0x0000010400000008), 0x1.0400000008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffffff7), -0x1.0400000009p+40, 0x0p+0 },
{ INT64_C(0x000001040000000a), 0x1.040000000ap+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffffff5), -0x1.040000000bp+40, 0x0p+0 },
{ INT64_C(0x0000010400000020), 0x1.040000002p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffffdf), -0x1.0400000021p+40, 0x0p+0 },
{ INT64_C(0x0000010400000024), 0x1.0400000024p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffffdb), -0x1.0400000025p+40, 0x0p+0 },
{ INT64_C(0x0000010400000028), 0x1.0400000028p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffffd7), -0x1.0400000029p+40, 0x0p+0 },
{ INT64_C(0x0000010400000200), 0x1.04000002p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffffdff), -0x1.0400000201p+40, 0x0p+0 },
{ INT64_C(0x0000010400000201), 0x1.0400000201p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffffdfe), -0x1.0400000202p+40, 0x0p+0 },
{ INT64_C(0x0000010400000202), 0x1.0400000202p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffffdfd), -0x1.0400000203p+40, 0x0p+0 },
{ INT64_C(0x0000010400000208), 0x1.0400000208p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffffdf7), -0x1.0400000209p+40, 0x0p+0 },
{ INT64_C(0x0000010400000280), 0x1.040000028p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffffd7f), -0x1.0400000281p+40, 0x0p+0 },
{ INT64_C(0x0000010400002000), 0x1.0400002p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffdfff), -0x1.0400002001p+40, 0x0p+0 },
{ INT64_C(0x0000010400002004), 0x1.0400002004p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffdffb), -0x1.0400002005p+40, 0x0p+0 },
{ INT64_C(0x0000010400002008), 0x1.0400002008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffdff7), -0x1.0400002009p+40, 0x0p+0 },
{ INT64_C(0x0000010400002040), 0x1.040000204p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffdfbf), -0x1.0400002041p+40, 0x0p+0 },
{ INT64_C(0x0000010400002400), 0x1.04000024p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffdbff), -0x1.0400002401p+40, 0x0p+0 },
{ INT64_C(0x0000010400002800), 0x1.04000028p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffd7ff), -0x1.0400002801p+40, 0x0p+0 },
{ INT64_C(0x0000010400004000), 0x1.0400004p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffbfff), -0x1.0400004001p+40, 0x0p+0 },
{ INT64_C(0x0000010400004001), 0x1.0400004001p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffbffe), -0x1.0400004002p+40, 0x0p+0 },
{ INT64_C(0x0000010400004010), 0x1.040000401p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffbfef), -0x1.0400004011p+40, 0x0p+0 },
{ INT64_C(0x0000010400004100), 0x1.04000041p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffbeff), -0x1.0400004101p+40, 0x0p+0 },
{ INT64_C(0x0000010400005000), 0x1.0400005p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffffafff), -0x1.0400005001p+40, 0x0p+0 },
{ INT64_C(0x0000010400010000), 0x1.040001p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffeffff), -0x1.0400010001p+40, 0x0p+0 },
{ INT64_C(0x0000010400010001), 0x1.0400010001p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffefffe), -0x1.0400010002p+40, 0x0p+0 },
{ INT64_C(0x0000010400010002), 0x1.0400010002p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffefffd), -0x1.0400010003p+40, 0x0p+0 },
{ INT64_C(0x0000010400010008), 0x1.0400010008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffefff7), -0x1.0400010009p+40, 0x0p+0 },
{ INT64_C(0x0000010400010010), 0x1.040001001p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffeffef), -0x1.0400010011p+40, 0x0p+0 },
{ INT64_C(0x0000010400010040), 0x1.040001004p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffeffbf), -0x1.0400010041p+40, 0x0p+0 },
{ INT64_C(0x0000010400010400), 0x1.04000104p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffefbff), -0x1.0400010401p+40, 0x0p+0 },
{ INT64_C(0x0000010400010800), 0x1.04000108p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffef7ff), -0x1.0400010801p+40, 0x0p+0 },
{ INT64_C(0x0000010400012000), 0x1.0400012p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffedfff), -0x1.0400012001p+40, 0x0p+0 },
{ INT64_C(0x0000010400020000), 0x1.040002p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffdffff), -0x1.0400020001p+40, 0x0p+0 },
{ INT64_C(0x0000010400020001), 0x1.0400020001p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffdfffe), -0x1.0400020002p+40, 0x0p+0 },
{ INT64_C(0x0000010400020004), 0x1.0400020004p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffdfffb), -0x1.0400020005p+40, 0x0p+0 },
{ INT64_C(0x0000010400020040), 0x1.040002004p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffdffbf), -0x1.0400020041p+40, 0x0p+0 },
{ INT64_C(0x0000010400020080), 0x1.040002008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffdff7f), -0x1.0400020081p+40, 0x0p+0 },
{ INT64_C(0x0000010400020400), 0x1.04000204p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffdfbff), -0x1.0400020401p+40, 0x0p+0 },
{ INT64_C(0x0000010400021000), 0x1.0400021p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffdefff), -0x1.0400021001p+40, 0x0p+0 },
{ INT64_C(0x0000010400030000), 0x1.040003p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffcffff), -0x1.0400030001p+40, 0x0p+0 },
{ INT64_C(0x0000010400040000), 0x1.040004p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffbffff), -0x1.0400040001p+40, 0x0p+0 },
{ INT64_C(0x0000010400040001), 0x1.0400040001p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffbfffe), -0x1.0400040002p+40, 0x0p+0 },
{ INT64_C(0x0000010400040008), 0x1.0400040008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffbfff7), -0x1.0400040009p+40, 0x0p+0 },
{ INT64_C(0x0000010400040010), 0x1.040004001p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffbffef), -0x1.0400040011p+40, 0x0p+0 },
{ INT64_C(0x0000010400040040), 0x1.040004004p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffbffbf), -0x1.0400040041p+40, 0x0p+0 },
{ INT64_C(0x0000010400040200), 0x1.04000402p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffbfdff), -0x1.0400040201p+40, 0x0p+0 },
{ INT64_C(0x0000010400040800), 0x1.04000408p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffbf7ff), -0x1.0400040801p+40, 0x0p+0 },
{ INT64_C(0x0000010400044000), 0x1.0400044p+40, 0x0p+0 },
{ INT64_C(0xfffffefbfffbbfff), -0x1.0400044001p+40, 0x0p+0 },
{ INT64_C(0x0000010400100000), 0x1.04001p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffefffff), -0x1.0400100001p+40, 0x0p+0 },
{ INT64_C(0x0000010400100004), 0x1.0400100004p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffeffffb), -0x1.0400100005p+40, 0x0p+0 },
{ INT64_C(0x0000010400100040), 0x1.040010004p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffefffbf), -0x1.0400100041p+40, 0x0p+0 },
{ INT64_C(0x0000010400100080), 0x1.040010008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffefff7f), -0x1.0400100081p+40, 0x0p+0 },
{ INT64_C(0x0000010400100800), 0x1.04001008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffeff7ff), -0x1.0400100801p+40, 0x0p+0 },
{ INT64_C(0x0000010400101000), 0x1.0400101p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffefefff), -0x1.0400101001p+40, 0x0p+0 },
{ INT64_C(0x0000010400108000), 0x1.0400108p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffef7fff), -0x1.0400108001p+40, 0x0p+0 },
{ INT64_C(0x0000010400180000), 0x1.040018p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffe7ffff), -0x1.0400180001p+40, 0x0p+0 },
{ INT64_C(0x0000010400200000), 0x1.04002p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffdfffff), -0x1.0400200001p+40, 0x0p+0 },
{ INT64_C(0x0000010400200001), 0x1.0400200001p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffdffffe), -0x1.0400200002p+40, 0x0p+0 },
{ INT64_C(0x0000010400200010), 0x1.040020001p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffdfffef), -0x1.0400200011p+40, 0x0p+0 },
{ INT64_C(0x0000010400200020), 0x1.040020002p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffdfffdf), -0x1.0400200021p+40, 0x0p+0 },
{ INT64_C(0x0000010400200080), 0x1.040020008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffdfff7f), -0x1.0400200081p+40, 0x0p+0 },
{ INT64_C(0x0000010400200400), 0x1.04002004p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffdffbff), -0x1.0400200401p+40, 0x0p+0 },
{ INT64_C(0x0000010400200800), 0x1.04002008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffdff7ff), -0x1.0400200801p+40, 0x0p+0 },
{ INT64_C(0x0000010400208000), 0x1.0400208p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffdf7fff), -0x1.0400208001p+40, 0x0p+0 },
{ INT64_C(0x0000010400220000), 0x1.040022p+40, 0x0p+0 },
{ INT64_C(0xfffffefbffddffff), -0x1.0400220001p+40, 0x0p+0 },
{ INT64_C(0x0000010400800000), 0x1.04008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbff7fffff), -0x1.0400800001p+40, 0x0p+0 },
{ INT64_C(0x0000010400800002), 0x1.0400800002p+40, 0x0p+0 },
{ INT64_C(0xfffffefbff7ffffd), -0x1.0400800003p+40, 0x0p+0 },
{ INT64_C(0x0000010400800008), 0x1.0400800008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbff7ffff7), -0x1.0400800009p+40, 0x0p+0 },
{ INT64_C(0x0000010400800080), 0x1.040080008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbff7fff7f), -0x1.0400800081p+40, 0x0p+0 },
{ INT64_C(0x0000010400800800), 0x1.04008008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbff7ff7ff), -0x1.0400800801p+40, 0x0p+0 },
{ INT64_C(0x0000010400801000), 0x1.0400801p+40, 0x0p+0 },
{ INT64_C(0xfffffefbff7fefff), -0x1.0400801001p+40, 0x0p+0 },
{ INT64_C(0x0000010400802000), 0x1.0400802p+40, 0x0p+0 },
{ INT64_C(0xfffffefbff7fdfff), -0x1.0400802001p+40, 0x0p+0 },
{ INT64_C(0x0000010400820000), 0x1.040082p+40, 0x0p+0 },
{ INT64_C(0xfffffefbff7dffff), -0x1.0400820001p+40, 0x0p+0 },
{ INT64_C(0x0000010400900000), 0x1.04009p+40, 0x0p+0 },
{ INT64_C(0xfffffefbff6fffff), -0x1.0400900001p+40, 0x0p+0 },
{ INT64_C(0x0000010400a00000), 0x1.0400ap+40, 0x0p+0 },
{ INT64_C(0xfffffefbff5fffff), -0x1.0400a00001p+40, 0x0p+0 },
{ INT64_C(0x0000010408000000), 0x1.0408p+40, 0x0p+0 },
{ INT64_C(0xfffffefbf7ffffff), -0x1.0408000001p+40, 0x0p+0 },
{ INT64_C(0x0000010408000008), 0x1.0408000008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbf7fffff7), -0x1.0408000009p+40, 0x0p+0 },
{ INT64_C(0x0000010408000010), 0x1.040800001p+40, 0x0p+0 },
{ INT64_C(0xfffffefbf7ffffef), -0x1.0408000011p+40, 0x0p+0 },
{ INT64_C(0x0000010408000100), 0x1.04080001p+40, 0x0p+0 },
{ INT64_C(0xfffffefbf7fffeff), -0x1.0408000101p+40, 0x0p+0 },
{ INT64_C(0x0000010408000200), 0x1.04080002p+40, 0x0p+0 },
{ INT64_C(0xfffffefbf7fffdff), -0x1.0408000201p+40, 0x0p+0 },
{ INT64_C(0x0000010408000800), 0x1.04080008p+40, 0x0p+0 },
{ INT64_C(0xfffffefbf7fff7ff), -0x1.0408000801p+40, 0x0p+0 },
{ INT64_C(0x0000010408004000), 0x1.0408004p+40, 0x0p+0 },
{ INT64_C(0xfffffefbf7ffbfff), -0x1.0408004001p+40, 0x0p+0 },
{ INT64_C(0x0000010408010000), 0x1.040801p+40, 0x0p+0 },
{ INT64_C(0xfffffefbf7feffff), -0x1.0408010001p+40, 0x0p+0 },
{ INT64_C(0x0000010408040000), 0x1.040804p+40, 0x0p+0 },
{ INT64_C(0xfffffefbf7fbffff), -0x1.0408040001p+40, 0x0p+0 },
{ INT64_C(0x0000010408080000), 0x1.040808p+40, 0x0p+0 },
{ INT64_C(0xfffffefbf7f7ffff), -0x1.0408080001p+40, 0x0p+0 },
{ INT64_C(0x0000010408800000), 0x1.04088p+40, 0x0p+0 },
{ INT64_C(0xfffffefbf77fffff), -0x1.0408800001p+40, 0x0p+0 },
{ INT64_C(0x000001040c000000), 0x1.040cp+40, 0x0p+0 },
{ INT64_C(0xfffffefbf3ffffff), -0x1.040c000001p+40, 0x0p+0 },
{ INT64_C(0x0000010480000000), 0x1.048p+40, 0x0p+0 },
{ INT64_C(0xfffffefb7fffffff), -0x1.0480000001p+40, 0x0p+0 },
{ INT64_C(0x0000010480000008), 0x1.0480000008p+40, 0x0p+0 },
{ INT64_C(0xfffffefb7ffffff7), -0x1.0480000009p+40, 0x0p+0 },
{ INT64_C(0x0000010480000010), 0x1.048000001p+40, 0x0p+0 },
{ INT64_C(0xfffffefb7fffffef), -0x1.0480000011p+40, 0x0p+0 },
{ INT64_C(0x0000010480000100), 0x1.04800001p+40, 0x0p+0 },
{ INT64_C(0xfffffefb7ffffeff), -0x1.0480000101p+40, 0x0p+0 },
{ INT64_C(0x0000010480001000), 0x1.0480001p+40, 0x0p+0 },
{ INT64_C(0xfffffefb7fffefff), -0x1.0480001001p+40, 0x0p+0 },
{ INT64_C(0x0000010480010000), 0x1.048001p+40, 0x0p+0 },
{ INT64_C(0xfffffefb7ffeffff), -0x1.0480010001p+40, 0x0p+0 },
{ INT64_C(0x0000010480080000), 0x1.048008p+40, 0x0p+0 },
{ INT64_C(0xfffffefb7ff7ffff), -0x1.0480080001p+40, 0x0p+0 },
{ INT64_C(0x0000010480800000), 0x1.04808p+40, 0x0p+0 },
{ INT64_C(0xfffffefb7f7fffff), -0x1.0480800001p+40, 0x0p+0 },
{ INT64_C(0x0000010484000000), 0x1.0484p+40, 0x0p+0 },
{ INT64_C(0xfffffefb7bffffff), -0x1.0484000001p+40, 0x0p+0 },
{ INT64_C(0x0000010488000000), 0x1.0488p+40, 0x0p+0 },
{ INT64_C(0xfffffefb77ffffff), -0x1.0488000001p+40, 0x0p+0 },
{ INT64_C(0x0000010600000000), 0x1.06p+40, 0x0p+0 },
{ INT64_C(0xfffffef9ffffffff), -0x1.0600000001p+40, 0x0p+0 },
{ INT64_C(0x0000010600000001), 0x1.0600000001p+40, 0x0p+0 },
{ INT64_C(0xfffffef9fffffffe), -0x1.0600000002p+40, 0x0p+0 },
{ INT64_C(0x0000010600000002), 0x1.0600000002p+40, 0x0p+0 },
{ INT64_C(0xfffffef9fffffffd), -0x1.0600000003p+40, 0x0p+0 },
{ INT64_C(0x0000010600000004), 0x1.0600000004p+40, 0x0p+0 },
{ INT64_C(0xfffffef9fffffffb), -0x1.0600000005p+40, 0x0p+0 },
{ INT64_C(0x0000010600000010), 0x1.060000001p+40, 0x0p+0 },
{ INT64_C(0xfffffef9ffffffef), -0x1.0600000011p+40, 0x0p+0 },
{ INT64_C(0x0000010600000020), 0x1.060000002p+40, 0x0p+0 },
{ INT64_C(0xfffffef9ffffffdf), -0x1.0600000021p+40, 0x0p+0 },
{ INT64_C(0x0000010600000200), 0x1.06000002p+40, 0x0p+0 },
{ INT64_C(0xfffffef9fffffdff), -0x1.0600000201p+40, 0x0p+0 },
{ INT64_C(0x0000010600001000), 0x1.0600001p+40, 0x0p+0 },
{ INT64_C(0xfffffef9ffffefff), -0x1.0600001001p+40, 0x0p+0 },
{ INT64_C(0x0000010600002000), 0x1.0600002p+40, 0x0p+0 },
{ INT64_C(0xfffffef9ffffdfff), -0x1.0600002001p+40, 0x0p+0 },
{ INT64_C(0x0000010600010000), 0x1.060001p+40, 0x0p+0 },
{ INT64_C(0xfffffef9fffeffff), -0x1.0600010001p+40, 0x0p+0 },
{ INT64_C(0x0000010600020000), 0x1.060002p+40, 0x0p+0 },
{ INT64_C(0xfffffef9fffdffff), -0x1.0600020001p+40, 0x0p+0 },
{ INT64_C(0x0000010600080000), 0x1.060008p+40, 0x0p+0 },
{ INT64_C(0xfffffef9fff7ffff), -0x1.0600080001p+40, 0x0p+0 },
{ INT64_C(0x0000010600100000), 0x1.06001p+40, 0x0p+0 },
{ INT64_C(0xfffffef9ffefffff), -0x1.0600100001p+40, 0x0p+0 },
{ INT64_C(0x0000010600400000), 0x1.06004p+40, 0x0p+0 },
{ INT64_C(0xfffffef9ffbfffff), -0x1.0600400001p+40, 0x0p+0 },
{ INT64_C(0x0000010604000000), 0x1.0604p+40, 0x0p+0 },
{ INT64_C(0xfffffef9fbffffff), -0x1.0604000001p+40, 0x0p+0 },
{ INT64_C(0x0000010610000000), 0x1.061p+40, 0x0p+0 },
{ INT64_C(0xfffffef9efffffff), -0x1.0610000001p+40, 0x0p+0 },
{ INT64_C(0x0000010620000000), 0x1.062p+40, 0x0p+0 },
{ INT64_C(0xfffffef9dfffffff), -0x1.0620000001p+40, 0x0p+0 },
{ INT64_C(0x0000010700000000), 0x1.07p+40, 0x0p+0 },
{ INT64_C(0xfffffef8ffffffff), -0x1.0700000001p+40, 0x0p+0 },
{ INT64_C(0x0000012000000002), 0x1.2000000002p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffffffd), -0x1.2000000003p+40, 0x0p+0 },
{ INT64_C(0x0000012000000008), 0x1.2000000008p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffffff7), -0x1.2000000009p+40, 0x0p+0 },
{ INT64_C(0x0000012000000020), 0x1.200000002p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffffdf), -0x1.2000000021p+40, 0x0p+0 },
{ INT64_C(0x0000012000000024), 0x1.2000000024p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffffdb), -0x1.2000000025p+40, 0x0p+0 },
{ INT64_C(0x0000012000000040), 0x1.200000004p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffffbf), -0x1.2000000041p+40, 0x0p+0 },
{ INT64_C(0x0000012000000048), 0x1.2000000048p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffffb7), -0x1.2000000049p+40, 0x0p+0 },
{ INT64_C(0x0000012000000060), 0x1.200000006p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffff9f), -0x1.2000000061p+40, 0x0p+0 },
{ INT64_C(0x0000012000000100), 0x1.20000001p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffffeff), -0x1.2000000101p+40, 0x0p+0 },
{ INT64_C(0x0000012000000102), 0x1.2000000102p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffffefd), -0x1.2000000103p+40, 0x0p+0 },
{ INT64_C(0x0000012000000120), 0x1.200000012p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffffedf), -0x1.2000000121p+40, 0x0p+0 },
{ INT64_C(0x0000012000000200), 0x1.20000002p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffffdff), -0x1.2000000201p+40, 0x0p+0 },
{ INT64_C(0x0000012000000201), 0x1.2000000201p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffffdfe), -0x1.2000000202p+40, 0x0p+0 },
{ INT64_C(0x0000012000000210), 0x1.200000021p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffffdef), -0x1.2000000211p+40, 0x0p+0 },
{ INT64_C(0x0000012000000280), 0x1.200000028p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffffd7f), -0x1.2000000281p+40, 0x0p+0 },
{ INT64_C(0x0000012000002000), 0x1.2000002p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffdfff), -0x1.2000002001p+40, 0x0p+0 },
{ INT64_C(0x0000012000002004), 0x1.2000002004p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffdffb), -0x1.2000002005p+40, 0x0p+0 },
{ INT64_C(0x0000012000002040), 0x1.200000204p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffdfbf), -0x1.2000002041p+40, 0x0p+0 },
{ INT64_C(0x0000012000002400), 0x1.20000024p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffdbff), -0x1.2000002401p+40, 0x0p+0 },
{ INT64_C(0x0000012000004000), 0x1.2000004p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffbfff), -0x1.2000004001p+40, 0x0p+0 },
{ INT64_C(0x0000012000004004), 0x1.2000004004p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffbffb), -0x1.2000004005p+40, 0x0p+0 },
{ INT64_C(0x0000012000004040), 0x1.200000404p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffbfbf), -0x1.2000004041p+40, 0x0p+0 },
{ INT64_C(0x0000012000004100), 0x1.20000041p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffbeff), -0x1.2000004101p+40, 0x0p+0 },
{ INT64_C(0x0000012000004400), 0x1.20000044p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffffbbff), -0x1.2000004401p+40, 0x0p+0 },
{ INT64_C(0x0000012000040000), 0x1.200004p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffbffff), -0x1.2000040001p+40, 0x0p+0 },
{ INT64_C(0x0000012000040002), 0x1.2000040002p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffbfffd), -0x1.2000040003p+40, 0x0p+0 },
{ INT64_C(0x0000012000040008), 0x1.2000040008p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffbfff7), -0x1.2000040009p+40, 0x0p+0 },
{ INT64_C(0x0000012000040010), 0x1.200004001p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffbffef), -0x1.2000040011p+40, 0x0p+0 },
{ INT64_C(0x0000012000040020), 0x1.200004002p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffbffdf), -0x1.2000040021p+40, 0x0p+0 },
{ INT64_C(0x0000012000040080), 0x1.200004008p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffbff7f), -0x1.2000040081p+40, 0x0p+0 },
{ INT64_C(0x0000012000040200), 0x1.20000402p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffbfdff), -0x1.2000040201p+40, 0x0p+0 },
{ INT64_C(0x0000012000042000), 0x1.2000042p+40, 0x0p+0 },
{ INT64_C(0xfffffedffffbdfff), -0x1.2000042001p+40, 0x0p+0 },
{ INT64_C(0x0000012000060000), 0x1.200006p+40, 0x0p+0 },
{ INT64_C(0xfffffedffff9ffff), -0x1.2000060001p+40, 0x0p+0 },
{ INT64_C(0x0000012000100000), 0x1.20001p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffefffff), -0x1.2000100001p+40, 0x0p+0 },
{ INT64_C(0x0000012000100008), 0x1.2000100008p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffeffff7), -0x1.2000100009p+40, 0x0p+0 },
{ INT64_C(0x0000012000100010), 0x1.200010001p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffefffef), -0x1.2000100011p+40, 0x0p+0 },
{ INT64_C(0x0000012000100100), 0x1.20001001p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffeffeff), -0x1.2000100101p+40, 0x0p+0 },
{ INT64_C(0x0000012000101000), 0x1.2000101p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffefefff), -0x1.2000101001p+40, 0x0p+0 },
{ INT64_C(0x0000012000108000), 0x1.2000108p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffef7fff), -0x1.2000108001p+40, 0x0p+0 },
{ INT64_C(0x0000012000180000), 0x1.200018p+40, 0x0p+0 },
{ INT64_C(0xfffffedfffe7ffff), -0x1.2000180001p+40, 0x0p+0 },
{ INT64_C(0x0000012001000000), 0x1.2001p+40, 0x0p+0 },
{ INT64_C(0xfffffedffeffffff), -0x1.2001000001p+40, 0x0p+0 },
{ INT64_C(0x0000012001000002), 0x1.2001000002p+40, 0x0p+0 },
{ INT64_C(0xfffffedffefffffd), -0x1.2001000003p+40, 0x0p+0 },
{ INT64_C(0x0000012001000004), 0x1.2001000004p+40, 0x0p+0 },
{ INT64_C(0xfffffedffefffffb), -0x1.2001000005p+40, 0x0p+0 },
{ INT64_C(0x0000012001000040), 0x1.200100004p+40, 0x0p+0 },
{ INT64_C(0xfffffedffeffffbf), -0x1.2001000041p+40, 0x0p+0 },
{ INT64_C(0x0000012001000400), 0x1.20010004p+40, 0x0p+0 },
{ INT64_C(0xfffffedffefffbff), -0x1.2001000401p+40, 0x0p+0 },
{ INT64_C(0x0000012001000800), 0x1.20010008p+40, 0x0p+0 },
{ INT64_C(0xfffffedffefff7ff), -0x1.2001000801p+40, 0x0p+0 },
{ INT64_C(0x0000012001004000), 0x1.2001004p+40, 0x0p+0 },
{ INT64_C(0xfffffedffeffbfff), -0x1.2001004001p+40, 0x0p+0 },
{ INT64_C(0x0000012001010000), 0x1.200101p+40, 0x0p+0 },
{ INT64_C(0xfffffedffefeffff), -0x1.2001010001p+40, 0x0p+0 },
{ INT64_C(0x0000012001100000), 0x1.20011p+40, 0x0p+0 },
{ INT64_C(0xfffffedffeefffff), -0x1.2001100001p+40, 0x0p+0 },
{ INT64_C(0x0000012001200000), 0x1.20012p+40, 0x0p+0 },
{ INT64_C(0xfffffedffedfffff), -0x1.2001200001p+40, 0x0p+0 },
{ INT64_C(0x0000012001400000), 0x1.20014p+40, 0x0p+0 },
{ INT64_C(0xfffffedffebfffff), -0x1.2001400001p+40, 0x0p+0 },
{ INT64_C(0x0000012001800000), 0x1.20018p+40, 0x0p+0 },
{ INT64_C(0xfffffedffe7fffff), -0x1.2001800001p+40, 0x0p+0 },
{ INT64_C(0x0000012008000000), 0x1.2008p+40, 0x0p+0 },
{ INT64_C(0xfffffedff7ffffff), -0x1.2008000001p+40, 0x0p+0 },
{ INT64_C(0x0000012008000008), 0x1.2008000008p+40, 0x0p+0 },
{ INT64_C(0xfffffedff7fffff7), -0x1.2008000009p+40, 0x0p+0 },
{ INT64_C(0x0000012008000010), 0x1.200800001p+40, 0x0p+0 },
{ INT64_C(0xfffffedff7ffffef), -0x1.2008000011p+40, 0x0p+0 },
{ INT64_C(0x0000012008000020), 0x1.200800002p+40, 0x0p+0 },
{ INT64_C(0xfffffedff7ffffdf), -0x1.2008000021p+40, 0x0p+0 },
{ INT64_C(0x0000012008000040), 0x1.200800004p+40, 0x0p+0 },
{ INT64_C(0xfffffedff7ffffbf), -0x1.2008000041p+40, 0x0p+0 },
{ INT64_C(0x0000012008000400), 0x1.20080004p+40, 0x0p+0 },
{ INT64_C(0xfffffedff7fffbff), -0x1.2008000401p+40, 0x0p+0 },
{ INT64_C(0x0000012008001000), 0x1.2008001p+40, 0x0p+0 },
{ INT64_C(0xfffffedff7ffefff), -0x1.2008001001p+40, 0x0p+0 },
{ INT64_C(0x0000012008002000), 0x1.2008002p+40, 0x0p+0 },
{ INT64_C(0xfffffedff7ffdfff), -0x1.2008002001p+40, 0x0p+0 },
{ INT64_C(0x0000012008004000), 0x1.2008004p+40, 0x0p+0 },
{ INT64_C(0xfffffedff7ffbfff), -0x1.2008004001p+40, 0x0p+0 },
{ INT64_C(0x0000012008020000), 0x1.200802p+40, 0x0p+0 },
{ INT64_C(0xfffffedff7fdffff), -0x1.2008020001p+40, 0x0p+0 },
{ INT64_C(0x0000012008080000), 0x1.200808p+40, 0x0p+0 },
{ INT64_C(0xfffffedff7f7ffff), -0x1.2008080001p+40, 0x0p+0 },
{ INT64_C(0x0000012008400000), 0x1.20084p+40, 0x0p+0 },
{ INT64_C(0xfffffedff7bfffff), -0x1.2008400001p+40, 0x0p+0 },
{ INT64_C(0x000001200c000000), 0x1.200cp+40, 0x0p+0 },
{ INT64_C(0xfffffedff3ffffff), -0x1.200c000001p+40, 0x0p+0 },
{ INT64_C(0x0000012040000000), 0x1.204p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbfffffff), -0x1.2040000001p+40, 0x0p+0 },
{ INT64_C(0x0000012040000001), 0x1.2040000001p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbffffffe), -0x1.2040000002p+40, 0x0p+0 },
{ INT64_C(0x0000012040000002), 0x1.2040000002p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbffffffd), -0x1.2040000003p+40, 0x0p+0 },
{ INT64_C(0x0000012040000010), 0x1.204000001p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbfffffef), -0x1.2040000011p+40, 0x0p+0 },
{ INT64_C(0x0000012040000040), 0x1.204000004p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbfffffbf), -0x1.2040000041p+40, 0x0p+0 },
{ INT64_C(0x0000012040000200), 0x1.20400002p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbffffdff), -0x1.2040000201p+40, 0x0p+0 },
{ INT64_C(0x0000012040002000), 0x1.2040002p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbfffdfff), -0x1.2040002001p+40, 0x0p+0 },
{ INT64_C(0x0000012040008000), 0x1.2040008p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbfff7fff), -0x1.2040008001p+40, 0x0p+0 },
{ INT64_C(0x0000012040020000), 0x1.204002p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbffdffff), -0x1.2040020001p+40, 0x0p+0 },
{ INT64_C(0x0000012040100000), 0x1.20401p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbfefffff), -0x1.2040100001p+40, 0x0p+0 },
{ INT64_C(0x0000012040200000), 0x1.20402p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbfdfffff), -0x1.2040200001p+40, 0x0p+0 },
{ INT64_C(0x0000012040400000), 0x1.20404p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbfbfffff), -0x1.2040400001p+40, 0x0p+0 },
{ INT64_C(0x0000012044000000), 0x1.2044p+40, 0x0p+0 },
{ INT64_C(0xfffffedfbbffffff), -0x1.2044000001p+40, 0x0p+0 },
{ INT64_C(0x0000012050000000), 0x1.205p+40, 0x0p+0 },
{ INT64_C(0xfffffedfafffffff), -0x1.2050000001p+40, 0x0p+0 },
{ INT64_C(0x0000012080000000), 0x1.208p+40, 0x0p+0 },
{ INT64_C(0xfffffedf7fffffff), -0x1.2080000001p+40, 0x0p+0 },
{ INT64_C(0x0000012080000002), 0x1.2080000002p+40, 0x0p+0 },
{ INT64_C(0xfffffedf7ffffffd), -0x1.2080000003p+40, 0x0p+0 },
{ INT64_C(0x0000012080000010), 0x1.208000001p+40, 0x0p+0 },
{ INT64_C(0xfffffedf7fffffef), -0x1.2080000011p+40, 0x0p+0 },
{ INT64_C(0x0000012080000040), 0x1.208000004p+40, 0x0p+0 },
{ INT64_C(0xfffffedf7fffffbf), -0x1.2080000041p+40, 0x0p+0 },
{ INT64_C(0x0000012080000200), 0x1.20800002p+40, 0x0p+0 },
{ INT64_C(0xfffffedf7ffffdff), -0x1.2080000201p+40, 0x0p+0 },
{ INT64_C(0x0000012080000800), 0x1.20800008p+40, 0x0p+0 },
{ INT64_C(0xfffffedf7ffff7ff), -0x1.2080000801p+40, 0x0p+0 },
{ INT64_C(0x0000012080004000), 0x1.2080004p+40, 0x0p+0 },
{ INT64_C(0xfffffedf7fffbfff), -0x1.2080004001p+40, 0x0p+0 },
{ INT64_C(0x0000012080010000), 0x1.208001p+40, 0x0p+0 },
{ INT64_C(0xfffffedf7ffeffff), -0x1.2080010001p+40, 0x0p+0 },
{ INT64_C(0x0000012080040000), 0x1.208004p+40, 0x0p+0 },
{ INT64_C(0xfffffedf7ffbffff), -0x1.2080040001p+40, 0x0p+0 },
{ INT64_C(0x0000012080080000), 0x1.208008p+40, 0x0p+0 },
{ INT64_C(0xfffffedf7ff7ffff), -0x1.2080080001p+40, 0x0p+0 },
{ INT64_C(0x0000012080200000), 0x1.20802p+40, 0x0p+0 },
{ INT64_C(0xfffffedf7fdfffff), -0x1.2080200001p+40, 0x0p+0 },
{ INT64_C(0x0000012082000000), 0x1.2082p+40, 0x0p+0 },
{ INT64_C(0xfffffedf7dffffff), -0x1.2082000001p+40, 0x0p+0 },
{ INT64_C(0x0000012088000000), 0x1.2088p+40, 0x0p+0 },
{ INT64_C(0xfffffedf77ffffff), -0x1.2088000001p+40, 0x0p+0 },
{ INT64_C(0x0000012090000000), 0x1.209p+40, 0x0p+0 },
{ INT64_C(0xfffffedf6fffffff), -0x1.2090000001p+40, 0x0p+0 },
{ INT64_C(0x0000012100000000), 0x1.21p+40, 0x0p+0 },
{ INT64_C(0xfffffedeffffffff), -0x1.2100000001p+40, 0x0p+0 },
{ INT64_C(0x0000012100000008), 0x1.2100000008p+40, 0x0p+0 },
{ INT64_C(0xfffffedefffffff7), -0x1.2100000009p+40, 0x0p+0 },
{ INT64_C(0x0000012100000020), 0x1.210000002p+40, 0x0p+0 },
{ INT64_C(0xfffffedeffffffdf), -0x1.2100000021p+40, 0x0p+0 },
{ INT64_C(0x0000012100000200), 0x1.21000002p+40, 0x0p+0 },
{ INT64_C(0xfffffedefffffdff), -0x1.2100000201p+40, 0x0p+0 },
{ INT64_C(0x0000012100000800), 0x1.21000008p+40, 0x0p+0 },
{ INT64_C(0xfffffedefffff7ff), -0x1.2100000801p+40, 0x0p+0 },
{ INT64_C(0x0000012100008000), 0x1.2100008p+40, 0x0p+0 },
{ INT64_C(0xfffffedeffff7fff), -0x1.2100008001p+40, 0x0p+0 },
{ INT64_C(0x0000012100010000), 0x1.210001p+40, 0x0p+0 },
{ INT64_C(0xfffffedefffeffff), -0x1.2100010001p+40, 0x0p+0 },
{ INT64_C(0x0000012100020000), 0x1.210002p+40, 0x0p+0 },
{ INT64_C(0xfffffedefffdffff), -0x1.2100020001p+40, 0x0p+0 },
{ INT64_C(0x0000012100200000), 0x1.21002p+40, 0x0p+0 },
{ INT64_C(0xfffffedeffdfffff), -0x1.2100200001p+40, 0x0p+0 },
{ INT64_C(0x0000012102000000), 0x1.2102p+40, 0x0p+0 },
{ INT64_C(0xfffffedefdffffff), -0x1.2102000001p+40, 0x0p+0 },
{ INT64_C(0x0000012104000000), 0x1.2104p+40, 0x0p+0 },
{ INT64_C(0xfffffedefbffffff), -0x1.2104000001p+40, 0x0p+0 },
{ INT64_C(0x0000012140000000), 0x1.214p+40, 0x0p+0 },
{ INT64_C(0xfffffedebfffffff), -0x1.2140000001p+40, 0x0p+0 },
{ INT64_C(0x0000012400000000), 0x1.24p+40, 0x0p+0 },
{ INT64_C(0xfffffedbffffffff), -0x1.2400000001p+40, 0x0p+0 },
{ INT64_C(0x0000012400000004), 0x1.2400000004p+40, 0x0p+0 },
{ INT64_C(0xfffffedbfffffffb), -0x1.2400000005p+40, 0x0p+0 },
{ INT64_C(0x0000012400000008), 0x1.2400000008p+40, 0x0p+0 },
{ INT64_C(0xfffffedbfffffff7), -0x1.2400000009p+40, 0x0p+0 },
{ INT64_C(0x0000012400000040), 0x1.240000004p+40, 0x0p+0 },
{ INT64_C(0xfffffedbffffffbf), -0x1.2400000041p+40, 0x0p+0 },
{ INT64_C(0x0000012400000200), 0x1.24000002p+40, 0x0p+0 },
{ INT64_C(0xfffffedbfffffdff), -0x1.2400000201p+40, 0x0p+0 },
{ INT64_C(0x0000012400000400), 0x1.24000004p+40, 0x0p+0 },
{ INT64_C(0xfffffedbfffffbff), -0x1.2400000401p+40, 0x0p+0 },
{ INT64_C(0x0000012400004000), 0x1.2400004p+40, 0x0p+0 },
{ INT64_C(0xfffffedbffffbfff), -0x1.2400004001p+40, 0x0p+0 },
{ INT64_C(0x0000012400040000), 0x1.240004p+40, 0x0p+0 },
{ INT64_C(0xfffffedbfffbffff), -0x1.2400040001p+40, 0x0p+0 },
{ INT64_C(0x0000012400400000), 0x1.24004p+40, 0x0p+0 },
{ INT64_C(0xfffffedbffbfffff), -0x1.2400400001p+40, 0x0p+0 },
{ INT64_C(0x0000012402000000), 0x1.2402p+40, 0x0p+0 },
{ INT64_C(0xfffffedbfdffffff), -0x1.2402000001p+40, 0x0p+0 },
{ INT64_C(0x0000012410000000), 0x1.241p+40, 0x0p+0 },
{ INT64_C(0xfffffedbefffffff), -0x1.2410000001p+40, 0x0p+0 },
{ INT64_C(0x0000012440000000), 0x1.244p+40, 0x0p+0 },
{ INT64_C(0xfffffedbbfffffff), -0x1.2440000001p+40, 0x0p+0 },
{ INT64_C(0x0000012480000000), 0x1.248p+40, 0x0p+0 },
{ INT64_C(0xfffffedb7fffffff), -0x1.2480000001p+40, 0x0p+0 },
{ INT64_C(0x0000012500000000), 0x1.25p+40, 0x0p+0 },
{ INT64_C(0xfffffedaffffffff), -0x1.2500000001p+40, 0x0p+0 },
{ INT64_C(0x0000080000000011), 0x1.00000000022p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffffee), -0x1.00000000024p+43, 0x0p+0 },
{ INT64_C(0x0000080000000022), 0x1.00000000044p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffffdd), -0x1.00000000046p+43, 0x0p+0 },
{ INT64_C(0x0000080000000024), 0x1.00000000048p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffffdb), -0x1.0000000004ap+43, 0x0p+0 },
{ INT64_C(0x0000080000000102), 0x1.00000000204p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffffefd), -0x1.00000000206p+43, 0x0p+0 },
{ INT64_C(0x0000080000000108), 0x1.0000000021p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffffef7), -0x1.00000000212p+43, 0x0p+0 },
{ INT64_C(0x000008000000010a), 0x1.00000000214p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffffef5), -0x1.00000000216p+43, 0x0p+0 },
{ INT64_C(0x0000080000000110), 0x1.0000000022p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffffeef), -0x1.00000000222p+43, 0x0p+0 },
{ INT64_C(0x0000080000000111), 0x1.00000000222p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffffeee), -0x1.00000000224p+43, 0x0p+0 },
{ INT64_C(0x0000080000000112), 0x1.00000000224p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffffeed), -0x1.00000000226p+43, 0x0p+0 },
{ INT64_C(0x0000080000000118), 0x1.0000000023p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffffee7), -0x1.00000000232p+43, 0x0p+0 },
{ INT64_C(0x0000080000000120), 0x1.0000000024p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffffedf), -0x1.00000000242p+43, 0x0p+0 },
{ INT64_C(0x0000080000000122), 0x1.00000000244p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffffedd), -0x1.00000000246p+43, 0x0p+0 },
{ INT64_C(0x0000080000001001), 0x1.00000002002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffeffe), -0x1.00000002004p+43, 0x0p+0 },
{ INT64_C(0x0000080000001008), 0x1.0000000201p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffeff7), -0x1.00000002012p+43, 0x0p+0 },
{ INT64_C(0x0000080000001010), 0x1.0000000202p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffefef), -0x1.00000002022p+43, 0x0p+0 },
{ INT64_C(0x0000080000001014), 0x1.00000002028p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffefeb), -0x1.0000000202ap+43, 0x0p+0 },
{ INT64_C(0x0000080000001020), 0x1.0000000204p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffefdf), -0x1.00000002042p+43, 0x0p+0 },
{ INT64_C(0x0000080000001022), 0x1.00000002044p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffefdd), -0x1.00000002046p+43, 0x0p+0 },
{ INT64_C(0x0000080000001080), 0x1.000000021p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffef7f), -0x1.00000002102p+43, 0x0p+0 },
{ INT64_C(0x0000080000001084), 0x1.00000002108p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffef7b), -0x1.0000000210ap+43, 0x0p+0 },
{ INT64_C(0x0000080000001090), 0x1.0000000212p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffef6f), -0x1.00000002122p+43, 0x0p+0 },
{ INT64_C(0x00000800000010c0), 0x1.0000000218p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffef3f), -0x1.00000002182p+43, 0x0p+0 },
{ INT64_C(0x0000080000001400), 0x1.000000028p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffebff), -0x1.00000002802p+43, 0x0p+0 },
{ INT64_C(0x0000080000001404), 0x1.00000002808p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffebfb), -0x1.0000000280ap+43, 0x0p+0 },
{ INT64_C(0x0000080000001420), 0x1.0000000284p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffebdf), -0x1.00000002842p+43, 0x0p+0 },
{ INT64_C(0x0000080000001480), 0x1.000000029p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffeb7f), -0x1.00000002902p+43, 0x0p+0 },
{ INT64_C(0x0000080000001600), 0x1.00000002cp+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffffe9ff), -0x1.00000002c02p+43, 0x0p+0 },
{ INT64_C(0x0000080000010004), 0x1.00000020008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffefffb), -0x1.0000002000ap+43, 0x0p+0 },
{ INT64_C(0x0000080000010010), 0x1.0000002002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffeffef), -0x1.00000020022p+43, 0x0p+0 },
{ INT64_C(0x0000080000010018), 0x1.0000002003p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffeffe7), -0x1.00000020032p+43, 0x0p+0 },
{ INT64_C(0x0000080000010100), 0x1.000000202p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffefeff), -0x1.00000020202p+43, 0x0p+0 },
{ INT64_C(0x0000080000010102), 0x1.00000020204p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffefefd), -0x1.00000020206p+43, 0x0p+0 },
{ INT64_C(0x0000080000010120), 0x1.0000002024p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffefedf), -0x1.00000020242p+43, 0x0p+0 },
{ INT64_C(0x0000080000010400), 0x1.000000208p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffefbff), -0x1.00000020802p+43, 0x0p+0 },
{ INT64_C(0x0000080000010401), 0x1.00000020802p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffefbfe), -0x1.00000020804p+43, 0x0p+0 },
{ INT64_C(0x0000080000010410), 0x1.0000002082p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffefbef), -0x1.00000020822p+43, 0x0p+0 },
{ INT64_C(0x0000080000010480), 0x1.000000209p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffefb7f), -0x1.00000020902p+43, 0x0p+0 },
{ INT64_C(0x0000080000010600), 0x1.00000020cp+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffef9ff), -0x1.00000020c02p+43, 0x0p+0 },
{ INT64_C(0x0000080000010800), 0x1.00000021p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffef7ff), -0x1.00000021002p+43, 0x0p+0 },
{ INT64_C(0x0000080000010801), 0x1.00000021002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffef7fe), -0x1.00000021004p+43, 0x0p+0 },
{ INT64_C(0x0000080000010810), 0x1.0000002102p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffef7ef), -0x1.00000021022p+43, 0x0p+0 },
{ INT64_C(0x0000080000010840), 0x1.0000002108p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffef7bf), -0x1.00000021082p+43, 0x0p+0 },
{ INT64_C(0x0000080000010880), 0x1.000000211p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffef77f), -0x1.00000021102p+43, 0x0p+0 },
{ INT64_C(0x0000080000010c00), 0x1.000000218p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffef3ff), -0x1.00000021802p+43, 0x0p+0 },
{ INT64_C(0x0000080000012000), 0x1.00000024p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffedfff), -0x1.00000024002p+43, 0x0p+0 },
{ INT64_C(0x0000080000012004), 0x1.00000024008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffedffb), -0x1.0000002400ap+43, 0x0p+0 },
{ INT64_C(0x0000080000012040), 0x1.0000002408p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffedfbf), -0x1.00000024082p+43, 0x0p+0 },
{ INT64_C(0x0000080000012200), 0x1.000000244p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffeddff), -0x1.00000024402p+43, 0x0p+0 },
{ INT64_C(0x0000080000012400), 0x1.000000248p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffedbff), -0x1.00000024802p+43, 0x0p+0 },
{ INT64_C(0x0000080000012800), 0x1.00000025p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffed7ff), -0x1.00000025002p+43, 0x0p+0 },
{ INT64_C(0x0000080000013000), 0x1.00000026p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffecfff), -0x1.00000026002p+43, 0x0p+0 },
{ INT64_C(0x0000080000020002), 0x1.00000040004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdfffd), -0x1.00000040006p+43, 0x0p+0 },
{ INT64_C(0x0000080000020008), 0x1.0000004001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdfff7), -0x1.00000040012p+43, 0x0p+0 },
{ INT64_C(0x0000080000020080), 0x1.000000401p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdff7f), -0x1.00000040102p+43, 0x0p+0 },
{ INT64_C(0x0000080000020088), 0x1.0000004011p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdff77), -0x1.00000040112p+43, 0x0p+0 },
{ INT64_C(0x00000800000200a0), 0x1.0000004014p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdff5f), -0x1.00000040142p+43, 0x0p+0 },
{ INT64_C(0x0000080000020800), 0x1.00000041p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdf7ff), -0x1.00000041002p+43, 0x0p+0 },
{ INT64_C(0x0000080000020802), 0x1.00000041004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdf7fd), -0x1.00000041006p+43, 0x0p+0 },
{ INT64_C(0x0000080000020808), 0x1.0000004101p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdf7f7), -0x1.00000041012p+43, 0x0p+0 },
{ INT64_C(0x0000080000020880), 0x1.000000411p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdf77f), -0x1.00000041102p+43, 0x0p+0 },
{ INT64_C(0x0000080000021000), 0x1.00000042p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdefff), -0x1.00000042002p+43, 0x0p+0 },
{ INT64_C(0x0000080000021002), 0x1.00000042004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdeffd), -0x1.00000042006p+43, 0x0p+0 },
{ INT64_C(0x0000080000021010), 0x1.0000004202p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdefef), -0x1.00000042022p+43, 0x0p+0 },
{ INT64_C(0x0000080000021040), 0x1.0000004208p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdefbf), -0x1.00000042082p+43, 0x0p+0 },
{ INT64_C(0x0000080000021100), 0x1.000000422p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffdeeff), -0x1.00000042202p+43, 0x0p+0 },
{ INT64_C(0x0000080000030000), 0x1.0000006p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffcffff), -0x1.00000060002p+43, 0x0p+0 },
{ INT64_C(0x0000080000030001), 0x1.00000060002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffcfffe), -0x1.00000060004p+43, 0x0p+0 },
{ INT64_C(0x0000080000030004), 0x1.00000060008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffcfffb), -0x1.0000006000ap+43, 0x0p+0 },
{ INT64_C(0x0000080000030020), 0x1.0000006004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffcffdf), -0x1.00000060042p+43, 0x0p+0 },
{ INT64_C(0x0000080000030200), 0x1.000000604p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffcfdff), -0x1.00000060402p+43, 0x0p+0 },
{ INT64_C(0x0000080000030800), 0x1.00000061p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffcf7ff), -0x1.00000061002p+43, 0x0p+0 },
{ INT64_C(0x0000080000038000), 0x1.0000007p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffc7fff), -0x1.00000070002p+43, 0x0p+0 },
{ INT64_C(0x0000080000040008), 0x1.0000008001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbfff7), -0x1.00000080012p+43, 0x0p+0 },
{ INT64_C(0x0000080000040009), 0x1.00000080012p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbfff6), -0x1.00000080014p+43, 0x0p+0 },
{ INT64_C(0x000008000004000c), 0x1.00000080018p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbfff3), -0x1.0000008001ap+43, 0x0p+0 },
{ INT64_C(0x0000080000040040), 0x1.0000008008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbffbf), -0x1.00000080082p+43, 0x0p+0 },
{ INT64_C(0x0000080000040044), 0x1.00000080088p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbffbb), -0x1.0000008008ap+43, 0x0p+0 },
{ INT64_C(0x0000080000040048), 0x1.0000008009p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbffb7), -0x1.00000080092p+43, 0x0p+0 },
{ INT64_C(0x0000080000040100), 0x1.000000802p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbfeff), -0x1.00000080202p+43, 0x0p+0 },
{ INT64_C(0x0000080000040101), 0x1.00000080202p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbfefe), -0x1.00000080204p+43, 0x0p+0 },
{ INT64_C(0x0000080000040102), 0x1.00000080204p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbfefd), -0x1.00000080206p+43, 0x0p+0 },
{ INT64_C(0x0000080000040110), 0x1.0000008022p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbfeef), -0x1.00000080222p+43, 0x0p+0 },
{ INT64_C(0x0000080000040800), 0x1.00000081p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbf7ff), -0x1.00000081002p+43, 0x0p+0 },
{ INT64_C(0x0000080000040802), 0x1.00000081004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbf7fd), -0x1.00000081006p+43, 0x0p+0 },
{ INT64_C(0x0000080000040820), 0x1.0000008104p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbf7df), -0x1.00000081042p+43, 0x0p+0 },
{ INT64_C(0x0000080000040840), 0x1.0000008108p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbf7bf), -0x1.00000081082p+43, 0x0p+0 },
{ INT64_C(0x0000080000040c00), 0x1.000000818p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffbf3ff), -0x1.00000081802p+43, 0x0p+0 },
{ INT64_C(0x0000080000048000), 0x1.0000009p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffb7fff), -0x1.00000090002p+43, 0x0p+0 },
{ INT64_C(0x0000080000048001), 0x1.00000090002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffb7ffe), -0x1.00000090004p+43, 0x0p+0 },
{ INT64_C(0x0000080000048004), 0x1.00000090008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffb7ffb), -0x1.0000009000ap+43, 0x0p+0 },
{ INT64_C(0x0000080000048008), 0x1.0000009001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffb7ff7), -0x1.00000090012p+43, 0x0p+0 },
{ INT64_C(0x0000080000048010), 0x1.0000009002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffb7fef), -0x1.00000090022p+43, 0x0p+0 },
{ INT64_C(0x0000080000048080), 0x1.000000901p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffb7f7f), -0x1.00000090102p+43, 0x0p+0 },
{ INT64_C(0x0000080000048100), 0x1.000000902p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffb7eff), -0x1.00000090202p+43, 0x0p+0 },
{ INT64_C(0x0000080000048400), 0x1.000000908p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffb7bff), -0x1.00000090802p+43, 0x0p+0 },
{ INT64_C(0x0000080000049000), 0x1.00000092p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffb6fff), -0x1.00000092002p+43, 0x0p+0 },
{ INT64_C(0x000008000004a000), 0x1.00000094p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffb5fff), -0x1.00000094002p+43, 0x0p+0 },
{ INT64_C(0x000008000004c000), 0x1.00000098p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffffb3fff), -0x1.00000098002p+43, 0x0p+0 },
{ INT64_C(0x0000080000080001), 0x1.00000100002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7fffe), -0x1.00000100004p+43, 0x0p+0 },
{ INT64_C(0x0000080000080002), 0x1.00000100004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7fffd), -0x1.00000100006p+43, 0x0p+0 },
{ INT64_C(0x0000080000080003), 0x1.00000100006p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7fffc), -0x1.00000100008p+43, 0x0p+0 },
{ INT64_C(0x0000080000080010), 0x1.0000010002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7ffef), -0x1.00000100022p+43, 0x0p+0 },
{ INT64_C(0x0000080000080012), 0x1.00000100024p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7ffed), -0x1.00000100026p+43, 0x0p+0 },
{ INT64_C(0x0000080000080014), 0x1.00000100028p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7ffeb), -0x1.0000010002ap+43, 0x0p+0 },
{ INT64_C(0x0000080000080020), 0x1.0000010004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7ffdf), -0x1.00000100042p+43, 0x0p+0 },
{ INT64_C(0x0000080000080021), 0x1.00000100042p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7ffde), -0x1.00000100044p+43, 0x0p+0 },
{ INT64_C(0x0000080000080022), 0x1.00000100044p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7ffdd), -0x1.00000100046p+43, 0x0p+0 },
{ INT64_C(0x0000080000080030), 0x1.0000010006p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7ffcf), -0x1.00000100062p+43, 0x0p+0 },
{ INT64_C(0x0000080000080040), 0x1.0000010008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7ffbf), -0x1.00000100082p+43, 0x0p+0 },
{ INT64_C(0x0000080000080042), 0x1.00000100084p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7ffbd), -0x1.00000100086p+43, 0x0p+0 },
{ INT64_C(0x0000080000080060), 0x1.000001000cp+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7ff9f), -0x1.000001000c2p+43, 0x0p+0 },
{ INT64_C(0x0000080000080100), 0x1.000001002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7feff), -0x1.00000100202p+43, 0x0p+0 },
{ INT64_C(0x0000080000080104), 0x1.00000100208p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7fefb), -0x1.0000010020ap+43, 0x0p+0 },
{ INT64_C(0x0000080000080140), 0x1.0000010028p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7febf), -0x1.00000100282p+43, 0x0p+0 },
{ INT64_C(0x0000080000080800), 0x1.00000101p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7f7ff), -0x1.00000101002p+43, 0x0p+0 },
{ INT64_C(0x0000080000080808), 0x1.0000010101p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7f7f7), -0x1.00000101012p+43, 0x0p+0 },
{ INT64_C(0x0000080000080810), 0x1.0000010102p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7f7ef), -0x1.00000101022p+43, 0x0p+0 },
{ INT64_C(0x0000080000080840), 0x1.0000010108p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7f7bf), -0x1.00000101082p+43, 0x0p+0 },
{ INT64_C(0x0000080000080900), 0x1.000001012p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff7f6ff), -0x1.00000101202p+43, 0x0p+0 },
{ INT64_C(0x0000080000088000), 0x1.0000011p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff77fff), -0x1.00000110002p+43, 0x0p+0 },
{ INT64_C(0x0000080000088004), 0x1.00000110008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff77ffb), -0x1.0000011000ap+43, 0x0p+0 },
{ INT64_C(0x0000080000088040), 0x1.0000011008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff77fbf), -0x1.00000110082p+43, 0x0p+0 },
{ INT64_C(0x0000080000088200), 0x1.000001104p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff77dff), -0x1.00000110402p+43, 0x0p+0 },
{ INT64_C(0x000008000008a000), 0x1.00000114p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff75fff), -0x1.00000114002p+43, 0x0p+0 },
{ INT64_C(0x00000800000c0000), 0x1.0000018p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff3ffff), -0x1.00000180002p+43, 0x0p+0 },
{ INT64_C(0x00000800000c0001), 0x1.00000180002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff3fffe), -0x1.00000180004p+43, 0x0p+0 },
{ INT64_C(0x00000800000c0004), 0x1.00000180008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff3fffb), -0x1.0000018000ap+43, 0x0p+0 },
{ INT64_C(0x00000800000c0020), 0x1.0000018004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff3ffdf), -0x1.00000180042p+43, 0x0p+0 },
{ INT64_C(0x00000800000c0040), 0x1.0000018008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff3ffbf), -0x1.00000180082p+43, 0x0p+0 },
{ INT64_C(0x00000800000c0100), 0x1.000001802p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff3feff), -0x1.00000180202p+43, 0x0p+0 },
{ INT64_C(0x00000800000c1000), 0x1.00000182p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff3efff), -0x1.00000182002p+43, 0x0p+0 },
{ INT64_C(0x00000800000c2000), 0x1.00000184p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff3dfff), -0x1.00000184002p+43, 0x0p+0 },
{ INT64_C(0x00000800000e0000), 0x1.000001cp+43, 0x0p+0 },
{ INT64_C(0xfffff7fffff1ffff), -0x1.000001c0002p+43, 0x0p+0 },
{ INT64_C(0x0000080000100008), 0x1.0000020001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeffff7), -0x1.00000200012p+43, 0x0p+0 },
{ INT64_C(0x000008000010000a), 0x1.00000200014p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeffff5), -0x1.00000200016p+43, 0x0p+0 },
{ INT64_C(0x0000080000100040), 0x1.0000020008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefffbf), -0x1.00000200082p+43, 0x0p+0 },
{ INT64_C(0x0000080000100042), 0x1.00000200084p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefffbd), -0x1.00000200086p+43, 0x0p+0 },
{ INT64_C(0x0000080000100048), 0x1.0000020009p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefffb7), -0x1.00000200092p+43, 0x0p+0 },
{ INT64_C(0x0000080000100060), 0x1.000002000cp+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefff9f), -0x1.000002000c2p+43, 0x0p+0 },
{ INT64_C(0x0000080000100100), 0x1.000002002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeffeff), -0x1.00000200202p+43, 0x0p+0 },
{ INT64_C(0x0000080000100108), 0x1.0000020021p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeffef7), -0x1.00000200212p+43, 0x0p+0 },
{ INT64_C(0x0000080000100110), 0x1.0000020022p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeffeef), -0x1.00000200222p+43, 0x0p+0 },
{ INT64_C(0x0000080000100140), 0x1.0000020028p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeffebf), -0x1.00000200282p+43, 0x0p+0 },
{ INT64_C(0x0000080000101000), 0x1.00000202p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefefff), -0x1.00000202002p+43, 0x0p+0 },
{ INT64_C(0x0000080000101001), 0x1.00000202002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefeffe), -0x1.00000202004p+43, 0x0p+0 },
{ INT64_C(0x0000080000101002), 0x1.00000202004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefeffd), -0x1.00000202006p+43, 0x0p+0 },
{ INT64_C(0x0000080000101010), 0x1.0000020202p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefefef), -0x1.00000202022p+43, 0x0p+0 },
{ INT64_C(0x0000080000101100), 0x1.000002022p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefeeff), -0x1.00000202202p+43, 0x0p+0 },
{ INT64_C(0x0000080000101200), 0x1.000002024p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefedff), -0x1.00000202402p+43, 0x0p+0 },
{ INT64_C(0x0000080000102000), 0x1.00000204p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefdfff), -0x1.00000204002p+43, 0x0p+0 },
{ INT64_C(0x0000080000102008), 0x1.0000020401p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefdff7), -0x1.00000204012p+43, 0x0p+0 },
{ INT64_C(0x0000080000102080), 0x1.000002041p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefdf7f), -0x1.00000204102p+43, 0x0p+0 },
{ INT64_C(0x0000080000102200), 0x1.000002044p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefddff), -0x1.00000204402p+43, 0x0p+0 },
{ INT64_C(0x0000080000102800), 0x1.00000205p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffefd7ff), -0x1.00000205002p+43, 0x0p+0 },
{ INT64_C(0x0000080000110000), 0x1.0000022p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeeffff), -0x1.00000220002p+43, 0x0p+0 },
{ INT64_C(0x0000080000110004), 0x1.00000220008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeefffb), -0x1.0000022000ap+43, 0x0p+0 },
{ INT64_C(0x0000080000110020), 0x1.0000022004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeeffdf), -0x1.00000220042p+43, 0x0p+0 },
{ INT64_C(0x0000080000110080), 0x1.000002201p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeeff7f), -0x1.00000220102p+43, 0x0p+0 },
{ INT64_C(0x0000080000110100), 0x1.000002202p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeefeff), -0x1.00000220202p+43, 0x0p+0 },
{ INT64_C(0x0000080000110200), 0x1.000002204p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeefdff), -0x1.00000220402p+43, 0x0p+0 },
{ INT64_C(0x0000080000112000), 0x1.00000224p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffeedfff), -0x1.00000224002p+43, 0x0p+0 },
{ INT64_C(0x0000080000118000), 0x1.0000023p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffee7fff), -0x1.00000230002p+43, 0x0p+0 },
{ INT64_C(0x0000080000180000), 0x1.000003p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffe7ffff), -0x1.00000300002p+43, 0x0p+0 },
{ INT64_C(0x0000080000180004), 0x1.00000300008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffe7fffb), -0x1.0000030000ap+43, 0x0p+0 },
{ INT64_C(0x0000080000180020), 0x1.0000030004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffe7ffdf), -0x1.00000300042p+43, 0x0p+0 },
{ INT64_C(0x0000080000180040), 0x1.0000030008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffe7ffbf), -0x1.00000300082p+43, 0x0p+0 },
{ INT64_C(0x0000080000180200), 0x1.000003004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffe7fdff), -0x1.00000300402p+43, 0x0p+0 },
{ INT64_C(0x0000080000180400), 0x1.000003008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffe7fbff), -0x1.00000300802p+43, 0x0p+0 },
{ INT64_C(0x0000080000182000), 0x1.00000304p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffe7dfff), -0x1.00000304002p+43, 0x0p+0 },
{ INT64_C(0x0000080000188000), 0x1.0000031p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffe77fff), -0x1.00000310002p+43, 0x0p+0 },
{ INT64_C(0x00000800001a0000), 0x1.0000034p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffffe5ffff), -0x1.00000340002p+43, 0x0p+0 },
{ INT64_C(0x0000080001000001), 0x1.00002000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffefffffe), -0x1.00002000004p+43, 0x0p+0 },
{ INT64_C(0x0000080001000010), 0x1.0000200002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeffffef), -0x1.00002000022p+43, 0x0p+0 },
{ INT64_C(0x0000080001000012), 0x1.00002000024p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeffffed), -0x1.00002000026p+43, 0x0p+0 },
{ INT64_C(0x0000080001000100), 0x1.000020002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffefffeff), -0x1.00002000202p+43, 0x0p+0 },
{ INT64_C(0x0000080001000108), 0x1.0000200021p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffefffef7), -0x1.00002000212p+43, 0x0p+0 },
{ INT64_C(0x0000080001000180), 0x1.000020003p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffefffe7f), -0x1.00002000302p+43, 0x0p+0 },
{ INT64_C(0x0000080001001000), 0x1.00002002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeffefff), -0x1.00002002002p+43, 0x0p+0 },
{ INT64_C(0x0000080001001002), 0x1.00002002004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeffeffd), -0x1.00002002006p+43, 0x0p+0 },
{ INT64_C(0x0000080001001008), 0x1.0000200201p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeffeff7), -0x1.00002002012p+43, 0x0p+0 },
{ INT64_C(0x0000080001001040), 0x1.0000200208p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeffefbf), -0x1.00002002082p+43, 0x0p+0 },
{ INT64_C(0x0000080001001200), 0x1.000020024p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeffedff), -0x1.00002002402p+43, 0x0p+0 },
{ INT64_C(0x0000080001010000), 0x1.0000202p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffefeffff), -0x1.00002020002p+43, 0x0p+0 },
{ INT64_C(0x0000080001010008), 0x1.0000202001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffefefff7), -0x1.00002020012p+43, 0x0p+0 },
{ INT64_C(0x0000080001010010), 0x1.0000202002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffefeffef), -0x1.00002020022p+43, 0x0p+0 },
{ INT64_C(0x0000080001010080), 0x1.000020201p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffefeff7f), -0x1.00002020102p+43, 0x0p+0 },
{ INT64_C(0x0000080001010800), 0x1.00002021p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffefef7ff), -0x1.00002021002p+43, 0x0p+0 },
{ INT64_C(0x0000080001012000), 0x1.00002024p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffefedfff), -0x1.00002024002p+43, 0x0p+0 },
{ INT64_C(0x0000080001100000), 0x1.000022p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeefffff), -0x1.00002200002p+43, 0x0p+0 },
{ INT64_C(0x0000080001100008), 0x1.0000220001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeeffff7), -0x1.00002200012p+43, 0x0p+0 },
{ INT64_C(0x0000080001100020), 0x1.0000220004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeefffdf), -0x1.00002200042p+43, 0x0p+0 },
{ INT64_C(0x0000080001100200), 0x1.000022004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeeffdff), -0x1.00002200402p+43, 0x0p+0 },
{ INT64_C(0x0000080001100400), 0x1.000022008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeeffbff), -0x1.00002200802p+43, 0x0p+0 },
{ INT64_C(0x0000080001104000), 0x1.00002208p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeefbfff), -0x1.00002208002p+43, 0x0p+0 },
{ INT64_C(0x0000080001120000), 0x1.0000224p+43, 0x0p+0 },
{ INT64_C(0xfffff7fffeedffff), -0x1.00002240002p+43, 0x0p+0 },
{ INT64_C(0x0000080008000001), 0x1.00010000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fffffe), -0x1.00010000004p+43, 0x0p+0 },
{ INT64_C(0x0000080008000004), 0x1.00010000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fffffb), -0x1.0001000000ap+43, 0x0p+0 },
{ INT64_C(0x0000080008000040), 0x1.0001000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7ffffbf), -0x1.00010000082p+43, 0x0p+0 },
{ INT64_C(0x0000080008000042), 0x1.00010000084p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7ffffbd), -0x1.00010000086p+43, 0x0p+0 },
{ INT64_C(0x0000080008000060), 0x1.000100000cp+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7ffff9f), -0x1.000100000c2p+43, 0x0p+0 },
{ INT64_C(0x0000080008000200), 0x1.000100004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fffdff), -0x1.00010000402p+43, 0x0p+0 },
{ INT64_C(0x0000080008000204), 0x1.00010000408p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fffdfb), -0x1.0001000040ap+43, 0x0p+0 },
{ INT64_C(0x0000080008000208), 0x1.0001000041p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fffdf7), -0x1.00010000412p+43, 0x0p+0 },
{ INT64_C(0x0000080008000210), 0x1.0001000042p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fffdef), -0x1.00010000422p+43, 0x0p+0 },
{ INT64_C(0x0000080008000280), 0x1.000100005p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fffd7f), -0x1.00010000502p+43, 0x0p+0 },
{ INT64_C(0x0000080008000300), 0x1.000100006p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fffcff), -0x1.00010000602p+43, 0x0p+0 },
{ INT64_C(0x0000080008000400), 0x1.000100008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fffbff), -0x1.00010000802p+43, 0x0p+0 },
{ INT64_C(0x0000080008000404), 0x1.00010000808p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fffbfb), -0x1.0001000080ap+43, 0x0p+0 },
{ INT64_C(0x0000080008000440), 0x1.0001000088p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fffbbf), -0x1.00010000882p+43, 0x0p+0 },
{ INT64_C(0x0000080008000600), 0x1.00010000cp+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fff9ff), -0x1.00010000c02p+43, 0x0p+0 },
{ INT64_C(0x0000080008000800), 0x1.00010001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fff7ff), -0x1.00010001002p+43, 0x0p+0 },
{ INT64_C(0x0000080008000801), 0x1.00010001002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fff7fe), -0x1.00010001004p+43, 0x0p+0 },
{ INT64_C(0x0000080008000808), 0x1.0001000101p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fff7f7), -0x1.00010001012p+43, 0x0p+0 },
{ INT64_C(0x0000080008000880), 0x1.000100011p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fff77f), -0x1.00010001102p+43, 0x0p+0 },
{ INT64_C(0x0000080008004000), 0x1.00010008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7ffbfff), -0x1.00010008002p+43, 0x0p+0 },
{ INT64_C(0x0000080008004008), 0x1.0001000801p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7ffbff7), -0x1.00010008012p+43, 0x0p+0 },
{ INT64_C(0x0000080008004080), 0x1.000100081p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7ffbf7f), -0x1.00010008102p+43, 0x0p+0 },
{ INT64_C(0x0000080008004200), 0x1.000100084p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7ffbdff), -0x1.00010008402p+43, 0x0p+0 },
{ INT64_C(0x0000080008004400), 0x1.000100088p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7ffbbff), -0x1.00010008802p+43, 0x0p+0 },
{ INT64_C(0x0000080008004800), 0x1.00010009p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7ffb7ff), -0x1.00010009002p+43, 0x0p+0 },
{ INT64_C(0x0000080008010000), 0x1.0001002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7feffff), -0x1.00010020002p+43, 0x0p+0 },
{ INT64_C(0x0000080008010001), 0x1.00010020002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fefffe), -0x1.00010020004p+43, 0x0p+0 },
{ INT64_C(0x0000080008010004), 0x1.00010020008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fefffb), -0x1.0001002000ap+43, 0x0p+0 },
{ INT64_C(0x0000080008010020), 0x1.0001002004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7feffdf), -0x1.00010020042p+43, 0x0p+0 },
{ INT64_C(0x0000080008010040), 0x1.0001002008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7feffbf), -0x1.00010020082p+43, 0x0p+0 },
{ INT64_C(0x0000080008010080), 0x1.000100201p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7feff7f), -0x1.00010020102p+43, 0x0p+0 },
{ INT64_C(0x0000080008010200), 0x1.000100204p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fefdff), -0x1.00010020402p+43, 0x0p+0 },
{ INT64_C(0x0000080008010400), 0x1.000100208p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fefbff), -0x1.00010020802p+43, 0x0p+0 },
{ INT64_C(0x0000080008012000), 0x1.00010024p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fedfff), -0x1.00010024002p+43, 0x0p+0 },
{ INT64_C(0x0000080008040000), 0x1.0001008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fbffff), -0x1.00010080002p+43, 0x0p+0 },
{ INT64_C(0x0000080008040008), 0x1.0001008001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fbfff7), -0x1.00010080012p+43, 0x0p+0 },
{ INT64_C(0x0000080008040020), 0x1.0001008004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fbffdf), -0x1.00010080042p+43, 0x0p+0 },
{ INT64_C(0x0000080008040040), 0x1.0001008008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fbffbf), -0x1.00010080082p+43, 0x0p+0 },
{ INT64_C(0x0000080008040200), 0x1.000100804p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fbfdff), -0x1.00010080402p+43, 0x0p+0 },
{ INT64_C(0x0000080008041000), 0x1.00010082p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fbefff), -0x1.00010082002p+43, 0x0p+0 },
{ INT64_C(0x0000080008048000), 0x1.0001009p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7fb7fff), -0x1.00010090002p+43, 0x0p+0 },
{ INT64_C(0x0000080008080000), 0x1.000101p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7f7ffff), -0x1.00010100002p+43, 0x0p+0 },
{ INT64_C(0x0000080008080008), 0x1.0001010001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7f7fff7), -0x1.00010100012p+43, 0x0p+0 },
{ INT64_C(0x0000080008080010), 0x1.0001010002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7f7ffef), -0x1.00010100022p+43, 0x0p+0 },
{ INT64_C(0x0000080008080020), 0x1.0001010004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7f7ffdf), -0x1.00010100042p+43, 0x0p+0 },
{ INT64_C(0x0000080008080080), 0x1.000101001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7f7ff7f), -0x1.00010100102p+43, 0x0p+0 },
{ INT64_C(0x0000080008080400), 0x1.000101008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7f7fbff), -0x1.00010100802p+43, 0x0p+0 },
{ INT64_C(0x0000080008082000), 0x1.00010104p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7f7dfff), -0x1.00010104002p+43, 0x0p+0 },
{ INT64_C(0x0000080008090000), 0x1.0001012p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7f6ffff), -0x1.00010120002p+43, 0x0p+0 },
{ INT64_C(0x0000080008100000), 0x1.000102p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7efffff), -0x1.00010200002p+43, 0x0p+0 },
{ INT64_C(0x0000080008100004), 0x1.00010200008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7effffb), -0x1.0001020000ap+43, 0x0p+0 },
{ INT64_C(0x0000080008100020), 0x1.0001020004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7efffdf), -0x1.00010200042p+43, 0x0p+0 },
{ INT64_C(0x0000080008100080), 0x1.000102001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7efff7f), -0x1.00010200102p+43, 0x0p+0 },
{ INT64_C(0x0000080008100200), 0x1.000102004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7effdff), -0x1.00010200402p+43, 0x0p+0 },
{ INT64_C(0x0000080008100800), 0x1.00010201p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7eff7ff), -0x1.00010201002p+43, 0x0p+0 },
{ INT64_C(0x0000080008102000), 0x1.00010204p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7efdfff), -0x1.00010204002p+43, 0x0p+0 },
{ INT64_C(0x0000080008120000), 0x1.0001024p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7edffff), -0x1.00010240002p+43, 0x0p+0 },
{ INT64_C(0x0000080008400000), 0x1.000108p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7bfffff), -0x1.00010800002p+43, 0x0p+0 },
{ INT64_C(0x0000080008400008), 0x1.0001080001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7bffff7), -0x1.00010800012p+43, 0x0p+0 },
{ INT64_C(0x0000080008400020), 0x1.0001080004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7bfffdf), -0x1.00010800042p+43, 0x0p+0 },
{ INT64_C(0x0000080008400080), 0x1.000108001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7bfff7f), -0x1.00010800102p+43, 0x0p+0 },
{ INT64_C(0x0000080008400800), 0x1.00010801p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7bff7ff), -0x1.00010801002p+43, 0x0p+0 },
{ INT64_C(0x0000080008404000), 0x1.00010808p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7bfbfff), -0x1.00010808002p+43, 0x0p+0 },
{ INT64_C(0x0000080008440000), 0x1.0001088p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7bbffff), -0x1.00010880002p+43, 0x0p+0 },
{ INT64_C(0x0000080008480000), 0x1.000109p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff7b7ffff), -0x1.00010900002p+43, 0x0p+0 },
{ INT64_C(0x000008000c000000), 0x1.00018p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff3ffffff), -0x1.00018000002p+43, 0x0p+0 },
{ INT64_C(0x000008000c000008), 0x1.0001800001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff3fffff7), -0x1.00018000012p+43, 0x0p+0 },
{ INT64_C(0x000008000c000040), 0x1.0001800008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff3ffffbf), -0x1.00018000082p+43, 0x0p+0 },
{ INT64_C(0x000008000c000100), 0x1.000180002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff3fffeff), -0x1.00018000202p+43, 0x0p+0 },
{ INT64_C(0x000008000c000400), 0x1.000180008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff3fffbff), -0x1.00018000802p+43, 0x0p+0 },
{ INT64_C(0x000008000c004000), 0x1.00018008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff3ffbfff), -0x1.00018008002p+43, 0x0p+0 },
{ INT64_C(0x000008000c040000), 0x1.0001808p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff3fbffff), -0x1.00018080002p+43, 0x0p+0 },
{ INT64_C(0x000008000c100000), 0x1.000182p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff3efffff), -0x1.00018200002p+43, 0x0p+0 },
{ INT64_C(0x000008000c800000), 0x1.00019p+43, 0x0p+0 },
{ INT64_C(0xfffff7fff37fffff), -0x1.00019000002p+43, 0x0p+0 },
{ INT64_C(0x0000080040000002), 0x1.00080000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbffffffd), -0x1.00080000006p+43, 0x0p+0 },
{ INT64_C(0x0000080040000010), 0x1.0008000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffffef), -0x1.00080000022p+43, 0x0p+0 },
{ INT64_C(0x0000080040000018), 0x1.0008000003p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffffe7), -0x1.00080000032p+43, 0x0p+0 },
{ INT64_C(0x0000080040000040), 0x1.0008000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffffbf), -0x1.00080000082p+43, 0x0p+0 },
{ INT64_C(0x0000080040000041), 0x1.00080000082p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffffbe), -0x1.00080000084p+43, 0x0p+0 },
{ INT64_C(0x0000080040000044), 0x1.00080000088p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffffbb), -0x1.0008000008ap+43, 0x0p+0 },
{ INT64_C(0x0000080040000060), 0x1.000800000cp+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffff9f), -0x1.000800000c2p+43, 0x0p+0 },
{ INT64_C(0x0000080040000400), 0x1.000800008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbffffbff), -0x1.00080000802p+43, 0x0p+0 },
{ INT64_C(0x0000080040000404), 0x1.00080000808p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbffffbfb), -0x1.0008000080ap+43, 0x0p+0 },
{ INT64_C(0x0000080040000408), 0x1.0008000081p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbffffbf7), -0x1.00080000812p+43, 0x0p+0 },
{ INT64_C(0x0000080040000420), 0x1.0008000084p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbffffbdf), -0x1.00080000842p+43, 0x0p+0 },
{ INT64_C(0x0000080040000600), 0x1.00080000cp+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbffff9ff), -0x1.00080000c02p+43, 0x0p+0 },
{ INT64_C(0x0000080040001000), 0x1.00080002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffefff), -0x1.00080002002p+43, 0x0p+0 },
{ INT64_C(0x0000080040001008), 0x1.0008000201p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffeff7), -0x1.00080002012p+43, 0x0p+0 },
{ INT64_C(0x0000080040001020), 0x1.0008000204p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffefdf), -0x1.00080002042p+43, 0x0p+0 },
{ INT64_C(0x0000080040001040), 0x1.0008000208p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffefbf), -0x1.00080002082p+43, 0x0p+0 },
{ INT64_C(0x0000080040001400), 0x1.000800028p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffebff), -0x1.00080002802p+43, 0x0p+0 },
{ INT64_C(0x0000080040001800), 0x1.00080003p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffe7ff), -0x1.00080003002p+43, 0x0p+0 },
{ INT64_C(0x0000080040004000), 0x1.00080008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffbfff), -0x1.00080008002p+43, 0x0p+0 },
{ INT64_C(0x0000080040004004), 0x1.00080008008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffbffb), -0x1.0008000800ap+43, 0x0p+0 },
{ INT64_C(0x0000080040004010), 0x1.0008000802p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffbfef), -0x1.00080008022p+43, 0x0p+0 },
{ INT64_C(0x0000080040004100), 0x1.000800082p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffbeff), -0x1.00080008202p+43, 0x0p+0 },
{ INT64_C(0x0000080040005000), 0x1.0008000ap+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfffafff), -0x1.0008000a002p+43, 0x0p+0 },
{ INT64_C(0x0000080040008000), 0x1.0008001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfff7fff), -0x1.00080010002p+43, 0x0p+0 },
{ INT64_C(0x0000080040008008), 0x1.0008001001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfff7ff7), -0x1.00080010012p+43, 0x0p+0 },
{ INT64_C(0x0000080040008020), 0x1.0008001004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfff7fdf), -0x1.00080010042p+43, 0x0p+0 },
{ INT64_C(0x0000080040008040), 0x1.0008001008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfff7fbf), -0x1.00080010082p+43, 0x0p+0 },
{ INT64_C(0x0000080040008100), 0x1.000800102p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfff7eff), -0x1.00080010202p+43, 0x0p+0 },
{ INT64_C(0x0000080040009000), 0x1.00080012p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfff6fff), -0x1.00080012002p+43, 0x0p+0 },
{ INT64_C(0x000008004000c000), 0x1.00080018p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfff3fff), -0x1.00080018002p+43, 0x0p+0 },
{ INT64_C(0x0000080040080000), 0x1.000801p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbff7ffff), -0x1.00080100002p+43, 0x0p+0 },
{ INT64_C(0x0000080040080002), 0x1.00080100004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbff7fffd), -0x1.00080100006p+43, 0x0p+0 },
{ INT64_C(0x0000080040080010), 0x1.0008010002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbff7ffef), -0x1.00080100022p+43, 0x0p+0 },
{ INT64_C(0x0000080040080080), 0x1.000801001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbff7ff7f), -0x1.00080100102p+43, 0x0p+0 },
{ INT64_C(0x0000080040080100), 0x1.000801002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbff7feff), -0x1.00080100202p+43, 0x0p+0 },
{ INT64_C(0x0000080040080400), 0x1.000801008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbff7fbff), -0x1.00080100802p+43, 0x0p+0 },
{ INT64_C(0x0000080040084000), 0x1.00080108p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbff7bfff), -0x1.00080108002p+43, 0x0p+0 },
{ INT64_C(0x00000800400a0000), 0x1.0008014p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbff5ffff), -0x1.00080140002p+43, 0x0p+0 },
{ INT64_C(0x0000080040100000), 0x1.000802p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfefffff), -0x1.00080200002p+43, 0x0p+0 },
{ INT64_C(0x0000080040100001), 0x1.00080200002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfeffffe), -0x1.00080200004p+43, 0x0p+0 },
{ INT64_C(0x0000080040100008), 0x1.0008020001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfeffff7), -0x1.00080200012p+43, 0x0p+0 },
{ INT64_C(0x0000080040100080), 0x1.000802001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfefff7f), -0x1.00080200102p+43, 0x0p+0 },
{ INT64_C(0x0000080040100200), 0x1.000802004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfeffdff), -0x1.00080200402p+43, 0x0p+0 },
{ INT64_C(0x0000080040100400), 0x1.000802008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfeffbff), -0x1.00080200802p+43, 0x0p+0 },
{ INT64_C(0x0000080040101000), 0x1.00080202p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfefefff), -0x1.00080202002p+43, 0x0p+0 },
{ INT64_C(0x0000080040102000), 0x1.00080204p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfefdfff), -0x1.00080204002p+43, 0x0p+0 },
{ INT64_C(0x0000080040104000), 0x1.00080208p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfefbfff), -0x1.00080208002p+43, 0x0p+0 },
{ INT64_C(0x0000080040110000), 0x1.0008022p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfeeffff), -0x1.00080220002p+43, 0x0p+0 },
{ INT64_C(0x0000080040180000), 0x1.000803p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfe7ffff), -0x1.00080300002p+43, 0x0p+0 },
{ INT64_C(0x0000080040400000), 0x1.000808p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfbfffff), -0x1.00080800002p+43, 0x0p+0 },
{ INT64_C(0x0000080040400001), 0x1.00080800002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfbffffe), -0x1.00080800004p+43, 0x0p+0 },
{ INT64_C(0x0000080040400008), 0x1.0008080001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfbffff7), -0x1.00080800012p+43, 0x0p+0 },
{ INT64_C(0x0000080040400080), 0x1.000808001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfbfff7f), -0x1.00080800102p+43, 0x0p+0 },
{ INT64_C(0x0000080040400400), 0x1.000808008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfbffbff), -0x1.00080800802p+43, 0x0p+0 },
{ INT64_C(0x0000080040404000), 0x1.00080808p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfbfbfff), -0x1.00080808002p+43, 0x0p+0 },
{ INT64_C(0x0000080040408000), 0x1.0008081p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfbf7fff), -0x1.00080810002p+43, 0x0p+0 },
{ INT64_C(0x0000080040410000), 0x1.0008082p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfbeffff), -0x1.00080820002p+43, 0x0p+0 },
{ INT64_C(0x0000080040420000), 0x1.0008084p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfbdffff), -0x1.00080840002p+43, 0x0p+0 },
{ INT64_C(0x0000080040500000), 0x1.00080ap+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbfafffff), -0x1.00080a00002p+43, 0x0p+0 },
{ INT64_C(0x0000080042000000), 0x1.00084p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbdffffff), -0x1.00084000002p+43, 0x0p+0 },
{ INT64_C(0x0000080042000001), 0x1.00084000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbdfffffe), -0x1.00084000004p+43, 0x0p+0 },
{ INT64_C(0x0000080042000010), 0x1.0008400002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbdffffef), -0x1.00084000022p+43, 0x0p+0 },
{ INT64_C(0x0000080042000100), 0x1.000840002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbdfffeff), -0x1.00084000202p+43, 0x0p+0 },
{ INT64_C(0x0000080042000200), 0x1.000840004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbdfffdff), -0x1.00084000402p+43, 0x0p+0 },
{ INT64_C(0x0000080042000400), 0x1.000840008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbdfffbff), -0x1.00084000802p+43, 0x0p+0 },
{ INT64_C(0x0000080042004000), 0x1.00084008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbdffbfff), -0x1.00084008002p+43, 0x0p+0 },
{ INT64_C(0x0000080042008000), 0x1.0008401p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbdff7fff), -0x1.00084010002p+43, 0x0p+0 },
{ INT64_C(0x0000080042040000), 0x1.0008408p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbdfbffff), -0x1.00084080002p+43, 0x0p+0 },
{ INT64_C(0x0000080042080000), 0x1.000841p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbdf7ffff), -0x1.00084100002p+43, 0x0p+0 },
{ INT64_C(0x0000080042100000), 0x1.000842p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbdefffff), -0x1.00084200002p+43, 0x0p+0 },
{ INT64_C(0x0000080042400000), 0x1.000848p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbdbfffff), -0x1.00084800002p+43, 0x0p+0 },
{ INT64_C(0x0000080042800000), 0x1.00085p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffbd7fffff), -0x1.00085000002p+43, 0x0p+0 },
{ INT64_C(0x0000080048000000), 0x1.0009p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffb7ffffff), -0x1.00090000002p+43, 0x0p+0 },
{ INT64_C(0x0000080048000004), 0x1.00090000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffb7fffffb), -0x1.0009000000ap+43, 0x0p+0 },
{ INT64_C(0x0000080048000010), 0x1.0009000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffb7ffffef), -0x1.00090000022p+43, 0x0p+0 },
{ INT64_C(0x0000080048000080), 0x1.000900001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffb7ffff7f), -0x1.00090000102p+43, 0x0p+0 },
{ INT64_C(0x0000080048000400), 0x1.000900008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffb7fffbff), -0x1.00090000802p+43, 0x0p+0 },
{ INT64_C(0x0000080048002000), 0x1.00090004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffb7ffdfff), -0x1.00090004002p+43, 0x0p+0 },
{ INT64_C(0x0000080048008000), 0x1.0009001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffb7ff7fff), -0x1.00090010002p+43, 0x0p+0 },
{ INT64_C(0x0000080048080000), 0x1.000901p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffb7f7ffff), -0x1.00090100002p+43, 0x0p+0 },
{ INT64_C(0x0000080048800000), 0x1.00091p+43, 0x0p+0 },
{ INT64_C(0xfffff7ffb77fffff), -0x1.00091000002p+43, 0x0p+0 },
{ INT64_C(0x0000080080000004), 0x1.00100000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffffffb), -0x1.0010000000ap+43, 0x0p+0 },
{ INT64_C(0x0000080080000040), 0x1.0010000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fffffbf), -0x1.00100000082p+43, 0x0p+0 },
{ INT64_C(0x0000080080000041), 0x1.00100000082p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fffffbe), -0x1.00100000084p+43, 0x0p+0 },
{ INT64_C(0x0000080080000048), 0x1.0010000009p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fffffb7), -0x1.00100000092p+43, 0x0p+0 },
{ INT64_C(0x0000080080000060), 0x1.001000000cp+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fffff9f), -0x1.001000000c2p+43, 0x0p+0 },
{ INT64_C(0x0000080080000400), 0x1.001000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffffbff), -0x1.00100000802p+43, 0x0p+0 },
{ INT64_C(0x0000080080000404), 0x1.00100000808p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffffbfb), -0x1.0010000080ap+43, 0x0p+0 },
{ INT64_C(0x0000080080000420), 0x1.0010000084p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffffbdf), -0x1.00100000842p+43, 0x0p+0 },
{ INT64_C(0x0000080080000500), 0x1.00100000ap+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffffaff), -0x1.00100000a02p+43, 0x0p+0 },
{ INT64_C(0x0000080080000800), 0x1.00100001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffff7ff), -0x1.00100001002p+43, 0x0p+0 },
{ INT64_C(0x0000080080000804), 0x1.00100001008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffff7fb), -0x1.0010000100ap+43, 0x0p+0 },
{ INT64_C(0x0000080080000808), 0x1.0010000101p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffff7f7), -0x1.00100001012p+43, 0x0p+0 },
{ INT64_C(0x0000080080000820), 0x1.0010000104p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffff7df), -0x1.00100001042p+43, 0x0p+0 },
{ INT64_C(0x0000080080000900), 0x1.001000012p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffff6ff), -0x1.00100001202p+43, 0x0p+0 },
{ INT64_C(0x0000080080000c00), 0x1.001000018p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffff3ff), -0x1.00100001802p+43, 0x0p+0 },
{ INT64_C(0x0000080080002000), 0x1.00100004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fffdfff), -0x1.00100004002p+43, 0x0p+0 },
{ INT64_C(0x0000080080002001), 0x1.00100004002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fffdffe), -0x1.00100004004p+43, 0x0p+0 },
{ INT64_C(0x0000080080002008), 0x1.0010000401p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fffdff7), -0x1.00100004012p+43, 0x0p+0 },
{ INT64_C(0x0000080080002080), 0x1.001000041p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fffdf7f), -0x1.00100004102p+43, 0x0p+0 },
{ INT64_C(0x0000080080002100), 0x1.001000042p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fffdeff), -0x1.00100004202p+43, 0x0p+0 },
{ INT64_C(0x0000080080002400), 0x1.001000048p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fffdbff), -0x1.00100004802p+43, 0x0p+0 },
{ INT64_C(0x0000080080002800), 0x1.00100005p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fffd7ff), -0x1.00100005002p+43, 0x0p+0 },
{ INT64_C(0x0000080080010000), 0x1.0010002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffeffff), -0x1.00100020002p+43, 0x0p+0 },
{ INT64_C(0x0000080080010004), 0x1.00100020008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffefffb), -0x1.0010002000ap+43, 0x0p+0 },
{ INT64_C(0x0000080080010010), 0x1.0010002002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffeffef), -0x1.00100020022p+43, 0x0p+0 },
{ INT64_C(0x0000080080010040), 0x1.0010002008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffeffbf), -0x1.00100020082p+43, 0x0p+0 },
{ INT64_C(0x0000080080010080), 0x1.001000201p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffeff7f), -0x1.00100020102p+43, 0x0p+0 },
{ INT64_C(0x0000080080010100), 0x1.001000202p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffefeff), -0x1.00100020202p+43, 0x0p+0 },
{ INT64_C(0x0000080080011000), 0x1.00100022p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffeefff), -0x1.00100022002p+43, 0x0p+0 },
{ INT64_C(0x0000080080012000), 0x1.00100024p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffedfff), -0x1.00100024002p+43, 0x0p+0 },
{ INT64_C(0x0000080080018000), 0x1.0010003p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffe7fff), -0x1.00100030002p+43, 0x0p+0 },
{ INT64_C(0x0000080080020000), 0x1.0010004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffdffff), -0x1.00100040002p+43, 0x0p+0 },
{ INT64_C(0x0000080080020008), 0x1.0010004001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffdfff7), -0x1.00100040012p+43, 0x0p+0 },
{ INT64_C(0x0000080080020010), 0x1.0010004002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffdffef), -0x1.00100040022p+43, 0x0p+0 },
{ INT64_C(0x0000080080020100), 0x1.001000402p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffdfeff), -0x1.00100040202p+43, 0x0p+0 },
{ INT64_C(0x0000080080020400), 0x1.001000408p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffdfbff), -0x1.00100040802p+43, 0x0p+0 },
{ INT64_C(0x0000080080022000), 0x1.00100044p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffddfff), -0x1.00100044002p+43, 0x0p+0 },
{ INT64_C(0x0000080080028000), 0x1.0010005p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ffd7fff), -0x1.00100050002p+43, 0x0p+0 },
{ INT64_C(0x0000080080080000), 0x1.001001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ff7ffff), -0x1.00100100002p+43, 0x0p+0 },
{ INT64_C(0x0000080080080001), 0x1.00100100002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ff7fffe), -0x1.00100100004p+43, 0x0p+0 },
{ INT64_C(0x0000080080080004), 0x1.00100100008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ff7fffb), -0x1.0010010000ap+43, 0x0p+0 },
{ INT64_C(0x0000080080080020), 0x1.0010010004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ff7ffdf), -0x1.00100100042p+43, 0x0p+0 },
{ INT64_C(0x0000080080080040), 0x1.0010010008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ff7ffbf), -0x1.00100100082p+43, 0x0p+0 },
{ INT64_C(0x0000080080080080), 0x1.001001001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ff7ff7f), -0x1.00100100102p+43, 0x0p+0 },
{ INT64_C(0x0000080080080200), 0x1.001001004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ff7fdff), -0x1.00100100402p+43, 0x0p+0 },
{ INT64_C(0x0000080080082000), 0x1.00100104p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ff7dfff), -0x1.00100104002p+43, 0x0p+0 },
{ INT64_C(0x0000080080084000), 0x1.00100108p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ff7bfff), -0x1.00100108002p+43, 0x0p+0 },
{ INT64_C(0x0000080080090000), 0x1.0010012p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ff6ffff), -0x1.00100120002p+43, 0x0p+0 },
{ INT64_C(0x00000800800c0000), 0x1.0010018p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ff3ffff), -0x1.00100180002p+43, 0x0p+0 },
{ INT64_C(0x0000080080400000), 0x1.001008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fbfffff), -0x1.00100800002p+43, 0x0p+0 },
{ INT64_C(0x0000080080400008), 0x1.0010080001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fbffff7), -0x1.00100800012p+43, 0x0p+0 },
{ INT64_C(0x0000080080400020), 0x1.0010080004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fbfffdf), -0x1.00100800042p+43, 0x0p+0 },
{ INT64_C(0x0000080080400080), 0x1.001008001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fbfff7f), -0x1.00100800102p+43, 0x0p+0 },
{ INT64_C(0x0000080080400100), 0x1.001008002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fbffeff), -0x1.00100800202p+43, 0x0p+0 },
{ INT64_C(0x0000080080400200), 0x1.001008004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fbffdff), -0x1.00100800402p+43, 0x0p+0 },
{ INT64_C(0x0000080080401000), 0x1.00100802p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fbfefff), -0x1.00100802002p+43, 0x0p+0 },
{ INT64_C(0x0000080080402000), 0x1.00100804p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fbfdfff), -0x1.00100804002p+43, 0x0p+0 },
{ INT64_C(0x0000080080420000), 0x1.0010084p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fbdffff), -0x1.00100840002p+43, 0x0p+0 },
{ INT64_C(0x0000080080500000), 0x1.00100ap+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7fafffff), -0x1.00100a00002p+43, 0x0p+0 },
{ INT64_C(0x0000080081000000), 0x1.00102p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7effffff), -0x1.00102000002p+43, 0x0p+0 },
{ INT64_C(0x0000080081000008), 0x1.0010200001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7efffff7), -0x1.00102000012p+43, 0x0p+0 },
{ INT64_C(0x0000080081000080), 0x1.001020001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7effff7f), -0x1.00102000102p+43, 0x0p+0 },
{ INT64_C(0x0000080081000200), 0x1.001020004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7efffdff), -0x1.00102000402p+43, 0x0p+0 },
{ INT64_C(0x0000080081001000), 0x1.00102002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7effefff), -0x1.00102002002p+43, 0x0p+0 },
{ INT64_C(0x0000080081002000), 0x1.00102004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7effdfff), -0x1.00102004002p+43, 0x0p+0 },
{ INT64_C(0x0000080081020000), 0x1.0010204p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7efdffff), -0x1.00102040002p+43, 0x0p+0 },
{ INT64_C(0x0000080081100000), 0x1.001022p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7eefffff), -0x1.00102200002p+43, 0x0p+0 },
{ INT64_C(0x0000080081200000), 0x1.001024p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7edfffff), -0x1.00102400002p+43, 0x0p+0 },
{ INT64_C(0x0000080081400000), 0x1.001028p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7ebfffff), -0x1.00102800002p+43, 0x0p+0 },
{ INT64_C(0x0000080082000000), 0x1.00104p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7dffffff), -0x1.00104000002p+43, 0x0p+0 },
{ INT64_C(0x0000080082000008), 0x1.0010400001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7dfffff7), -0x1.00104000012p+43, 0x0p+0 },
{ INT64_C(0x0000080082000080), 0x1.001040001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7dffff7f), -0x1.00104000102p+43, 0x0p+0 },
{ INT64_C(0x0000080082000800), 0x1.00104001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7dfff7ff), -0x1.00104001002p+43, 0x0p+0 },
{ INT64_C(0x0000080082002000), 0x1.00104004p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7dffdfff), -0x1.00104004002p+43, 0x0p+0 },
{ INT64_C(0x0000080082004000), 0x1.00104008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7dffbfff), -0x1.00104008002p+43, 0x0p+0 },
{ INT64_C(0x0000080082010000), 0x1.0010402p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7dfeffff), -0x1.00104020002p+43, 0x0p+0 },
{ INT64_C(0x0000080082040000), 0x1.0010408p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7dfbffff), -0x1.00104080002p+43, 0x0p+0 },
{ INT64_C(0x0000080082100000), 0x1.001042p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7defffff), -0x1.00104200002p+43, 0x0p+0 },
{ INT64_C(0x0000080083000000), 0x1.00106p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff7cffffff), -0x1.00106000002p+43, 0x0p+0 },
{ INT64_C(0x0000080088000000), 0x1.0011p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff77ffffff), -0x1.00110000002p+43, 0x0p+0 },
{ INT64_C(0x0000080088000001), 0x1.00110000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff77fffffe), -0x1.00110000004p+43, 0x0p+0 },
{ INT64_C(0x0000080088000008), 0x1.0011000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff77fffff7), -0x1.00110000012p+43, 0x0p+0 },
{ INT64_C(0x0000080088000080), 0x1.001100001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff77ffff7f), -0x1.00110000102p+43, 0x0p+0 },
{ INT64_C(0x0000080088000400), 0x1.001100008p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff77fffbff), -0x1.00110000802p+43, 0x0p+0 },
{ INT64_C(0x0000080088000800), 0x1.00110001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff77fff7ff), -0x1.00110001002p+43, 0x0p+0 },
{ INT64_C(0x0000080088008000), 0x1.0011001p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff77ff7fff), -0x1.00110010002p+43, 0x0p+0 },
{ INT64_C(0x0000080088010000), 0x1.0011002p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff77feffff), -0x1.00110020002p+43, 0x0p+0 },
{ INT64_C(0x0000080088100000), 0x1.001102p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff77efffff), -0x1.00110200002p+43, 0x0p+0 },
{ INT64_C(0x0000080088400000), 0x1.001108p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff77bfffff), -0x1.00110800002p+43, 0x0p+0 },
{ INT64_C(0x0000080088800000), 0x1.00111p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff777fffff), -0x1.00111000002p+43, 0x0p+0 },
{ INT64_C(0x0000080089000000), 0x1.00112p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff76ffffff), -0x1.00112000002p+43, 0x0p+0 },
{ INT64_C(0x000008008a000000), 0x1.00114p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff75ffffff), -0x1.00114000002p+43, 0x0p+0 },
{ INT64_C(0x000008008c000000), 0x1.00118p+43, 0x0p+0 },
{ INT64_C(0xfffff7ff73ffffff), -0x1.00118000002p+43, 0x0p+0 },
{ INT64_C(0x0000080200000008), 0x1.0040000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffffff7), -0x1.00400000012p+43, 0x0p+0 },
{ INT64_C(0x000008020000000a), 0x1.00400000014p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffffff5), -0x1.00400000016p+43, 0x0p+0 },
{ INT64_C(0x000008020000000c), 0x1.00400000018p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffffff3), -0x1.0040000001ap+43, 0x0p+0 },
{ INT64_C(0x0000080200000010), 0x1.0040000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffffef), -0x1.00400000022p+43, 0x0p+0 },
{ INT64_C(0x0000080200000014), 0x1.00400000028p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffffeb), -0x1.0040000002ap+43, 0x0p+0 },
{ INT64_C(0x0000080200000040), 0x1.0040000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffffbf), -0x1.00400000082p+43, 0x0p+0 },
{ INT64_C(0x0000080200000042), 0x1.00400000084p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffffbd), -0x1.00400000086p+43, 0x0p+0 },
{ INT64_C(0x0000080200000048), 0x1.0040000009p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffffb7), -0x1.00400000092p+43, 0x0p+0 },
{ INT64_C(0x0000080200000080), 0x1.004000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffff7f), -0x1.00400000102p+43, 0x0p+0 },
{ INT64_C(0x0000080200000082), 0x1.00400000104p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffff7d), -0x1.00400000106p+43, 0x0p+0 },
{ INT64_C(0x00000802000000a0), 0x1.0040000014p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffff5f), -0x1.00400000142p+43, 0x0p+0 },
{ INT64_C(0x0000080200000200), 0x1.004000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffffdff), -0x1.00400000402p+43, 0x0p+0 },
{ INT64_C(0x0000080200000202), 0x1.00400000404p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffffdfd), -0x1.00400000406p+43, 0x0p+0 },
{ INT64_C(0x0000080200000220), 0x1.0040000044p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffffddf), -0x1.00400000442p+43, 0x0p+0 },
{ INT64_C(0x0000080200000240), 0x1.0040000048p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffffdbf), -0x1.00400000482p+43, 0x0p+0 },
{ INT64_C(0x0000080200000280), 0x1.004000005p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffffd7f), -0x1.00400000502p+43, 0x0p+0 },
{ INT64_C(0x0000080200002000), 0x1.00400004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffdfff), -0x1.00400004002p+43, 0x0p+0 },
{ INT64_C(0x0000080200002002), 0x1.00400004004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffdffd), -0x1.00400004006p+43, 0x0p+0 },
{ INT64_C(0x0000080200002020), 0x1.0040000404p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffdfdf), -0x1.00400004042p+43, 0x0p+0 },
{ INT64_C(0x0000080200002080), 0x1.004000041p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffdf7f), -0x1.00400004102p+43, 0x0p+0 },
{ INT64_C(0x0000080200002800), 0x1.00400005p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffffd7ff), -0x1.00400005002p+43, 0x0p+0 },
{ INT64_C(0x0000080200008000), 0x1.0040001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffff7fff), -0x1.00400010002p+43, 0x0p+0 },
{ INT64_C(0x0000080200008001), 0x1.00400010002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffff7ffe), -0x1.00400010004p+43, 0x0p+0 },
{ INT64_C(0x0000080200008010), 0x1.0040001002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffff7fef), -0x1.00400010022p+43, 0x0p+0 },
{ INT64_C(0x0000080200008100), 0x1.004000102p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffff7eff), -0x1.00400010202p+43, 0x0p+0 },
{ INT64_C(0x0000080200008400), 0x1.004000108p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffff7bff), -0x1.00400010802p+43, 0x0p+0 },
{ INT64_C(0x000008020000a000), 0x1.00400014p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffff5fff), -0x1.00400014002p+43, 0x0p+0 },
{ INT64_C(0x0000080200040000), 0x1.0040008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffbffff), -0x1.00400080002p+43, 0x0p+0 },
{ INT64_C(0x0000080200040001), 0x1.00400080002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffbfffe), -0x1.00400080004p+43, 0x0p+0 },
{ INT64_C(0x0000080200040004), 0x1.00400080008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffbfffb), -0x1.0040008000ap+43, 0x0p+0 },
{ INT64_C(0x0000080200040040), 0x1.0040008008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffbffbf), -0x1.00400080082p+43, 0x0p+0 },
{ INT64_C(0x0000080200040400), 0x1.004000808p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffbfbff), -0x1.00400080802p+43, 0x0p+0 },
{ INT64_C(0x0000080200044000), 0x1.00400088p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffbbfff), -0x1.00400088002p+43, 0x0p+0 },
{ INT64_C(0x0000080200048000), 0x1.0040009p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfffb7fff), -0x1.00400090002p+43, 0x0p+0 },
{ INT64_C(0x0000080200200000), 0x1.004004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffdfffff), -0x1.00400400002p+43, 0x0p+0 },
{ INT64_C(0x0000080200200004), 0x1.00400400008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffdffffb), -0x1.0040040000ap+43, 0x0p+0 },
{ INT64_C(0x0000080200200040), 0x1.0040040008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffdfffbf), -0x1.00400400082p+43, 0x0p+0 },
{ INT64_C(0x0000080200200400), 0x1.004004008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffdffbff), -0x1.00400400802p+43, 0x0p+0 },
{ INT64_C(0x0000080200202000), 0x1.00400404p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffdfdfff), -0x1.00400404002p+43, 0x0p+0 },
{ INT64_C(0x0000080200220000), 0x1.0040044p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffddffff), -0x1.00400440002p+43, 0x0p+0 },
{ INT64_C(0x0000080200280000), 0x1.004005p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffd7ffff), -0x1.00400500002p+43, 0x0p+0 },
{ INT64_C(0x0000080200400000), 0x1.004008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffbfffff), -0x1.00400800002p+43, 0x0p+0 },
{ INT64_C(0x0000080200400004), 0x1.00400800008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffbffffb), -0x1.0040080000ap+43, 0x0p+0 },
{ INT64_C(0x0000080200400008), 0x1.0040080001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffbffff7), -0x1.00400800012p+43, 0x0p+0 },
{ INT64_C(0x0000080200400040), 0x1.0040080008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffbfffbf), -0x1.00400800082p+43, 0x0p+0 },
{ INT64_C(0x0000080200400080), 0x1.004008001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffbfff7f), -0x1.00400800102p+43, 0x0p+0 },
{ INT64_C(0x0000080200400800), 0x1.00400801p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffbff7ff), -0x1.00400801002p+43, 0x0p+0 },
{ INT64_C(0x0000080200408000), 0x1.0040081p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffbf7fff), -0x1.00400810002p+43, 0x0p+0 },
{ INT64_C(0x0000080200440000), 0x1.0040088p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffbbffff), -0x1.00400880002p+43, 0x0p+0 },
{ INT64_C(0x0000080200500000), 0x1.00400ap+43, 0x0p+0 },
{ INT64_C(0xfffff7fdffafffff), -0x1.00400a00002p+43, 0x0p+0 },
{ INT64_C(0x0000080200600000), 0x1.00400cp+43, 0x0p+0 },
{ INT64_C(0xfffff7fdff9fffff), -0x1.00400c00002p+43, 0x0p+0 },
{ INT64_C(0x0000080202000000), 0x1.00404p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfdffffff), -0x1.00404000002p+43, 0x0p+0 },
{ INT64_C(0x0000080202000002), 0x1.00404000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfdfffffd), -0x1.00404000006p+43, 0x0p+0 },
{ INT64_C(0x0000080202000008), 0x1.0040400001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfdfffff7), -0x1.00404000012p+43, 0x0p+0 },
{ INT64_C(0x0000080202000080), 0x1.004040001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfdffff7f), -0x1.00404000102p+43, 0x0p+0 },
{ INT64_C(0x0000080202000200), 0x1.004040004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfdfffdff), -0x1.00404000402p+43, 0x0p+0 },
{ INT64_C(0x0000080202002000), 0x1.00404004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfdffdfff), -0x1.00404004002p+43, 0x0p+0 },
{ INT64_C(0x0000080202008000), 0x1.0040401p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfdff7fff), -0x1.00404010002p+43, 0x0p+0 },
{ INT64_C(0x0000080202010000), 0x1.0040402p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfdfeffff), -0x1.00404020002p+43, 0x0p+0 },
{ INT64_C(0x0000080202080000), 0x1.004041p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfdf7ffff), -0x1.00404100002p+43, 0x0p+0 },
{ INT64_C(0x0000080202100000), 0x1.004042p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfdefffff), -0x1.00404200002p+43, 0x0p+0 },
{ INT64_C(0x0000080203000000), 0x1.00406p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfcffffff), -0x1.00406000002p+43, 0x0p+0 },
{ INT64_C(0x0000080204000000), 0x1.00408p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfbffffff), -0x1.00408000002p+43, 0x0p+0 },
{ INT64_C(0x0000080204000004), 0x1.00408000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfbfffffb), -0x1.0040800000ap+43, 0x0p+0 },
{ INT64_C(0x0000080204000010), 0x1.0040800002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfbffffef), -0x1.00408000022p+43, 0x0p+0 },
{ INT64_C(0x0000080204000040), 0x1.0040800008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfbffffbf), -0x1.00408000082p+43, 0x0p+0 },
{ INT64_C(0x0000080204000400), 0x1.004080008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfbfffbff), -0x1.00408000802p+43, 0x0p+0 },
{ INT64_C(0x0000080204004000), 0x1.00408008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfbffbfff), -0x1.00408008002p+43, 0x0p+0 },
{ INT64_C(0x0000080204020000), 0x1.0040804p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfbfdffff), -0x1.00408040002p+43, 0x0p+0 },
{ INT64_C(0x0000080204040000), 0x1.0040808p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfbfbffff), -0x1.00408080002p+43, 0x0p+0 },
{ INT64_C(0x0000080204100000), 0x1.004082p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfbefffff), -0x1.00408200002p+43, 0x0p+0 },
{ INT64_C(0x0000080205000000), 0x1.0040ap+43, 0x0p+0 },
{ INT64_C(0xfffff7fdfaffffff), -0x1.0040a000002p+43, 0x0p+0 },
{ INT64_C(0x0000080220000000), 0x1.0044p+43, 0x0p+0 },
{ INT64_C(0xfffff7fddfffffff), -0x1.00440000002p+43, 0x0p+0 },
{ INT64_C(0x0000080220000008), 0x1.0044000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fddffffff7), -0x1.00440000012p+43, 0x0p+0 },
{ INT64_C(0x0000080220000020), 0x1.0044000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fddfffffdf), -0x1.00440000042p+43, 0x0p+0 },
{ INT64_C(0x0000080220000100), 0x1.004400002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fddffffeff), -0x1.00440000202p+43, 0x0p+0 },
{ INT64_C(0x0000080220001000), 0x1.00440002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fddfffefff), -0x1.00440002002p+43, 0x0p+0 },
{ INT64_C(0x0000080220010000), 0x1.0044002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fddffeffff), -0x1.00440020002p+43, 0x0p+0 },
{ INT64_C(0x0000080220020000), 0x1.0044004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fddffdffff), -0x1.00440040002p+43, 0x0p+0 },
{ INT64_C(0x0000080220200000), 0x1.004404p+43, 0x0p+0 },
{ INT64_C(0xfffff7fddfdfffff), -0x1.00440400002p+43, 0x0p+0 },
{ INT64_C(0x0000080220800000), 0x1.00441p+43, 0x0p+0 },
{ INT64_C(0xfffff7fddf7fffff), -0x1.00441000002p+43, 0x0p+0 },
{ INT64_C(0x0000080224000000), 0x1.00448p+43, 0x0p+0 },
{ INT64_C(0xfffff7fddbffffff), -0x1.00448000002p+43, 0x0p+0 },
{ INT64_C(0x0000080240000000), 0x1.0048p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdbfffffff), -0x1.00480000002p+43, 0x0p+0 },
{ INT64_C(0x0000080240000008), 0x1.0048000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdbffffff7), -0x1.00480000012p+43, 0x0p+0 },
{ INT64_C(0x0000080240000040), 0x1.0048000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdbfffffbf), -0x1.00480000082p+43, 0x0p+0 },
{ INT64_C(0x0000080240000100), 0x1.004800002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdbffffeff), -0x1.00480000202p+43, 0x0p+0 },
{ INT64_C(0x0000080240000200), 0x1.004800004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdbffffdff), -0x1.00480000402p+43, 0x0p+0 },
{ INT64_C(0x0000080240000800), 0x1.00480001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdbffff7ff), -0x1.00480001002p+43, 0x0p+0 },
{ INT64_C(0x0000080240008000), 0x1.0048001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdbfff7fff), -0x1.00480010002p+43, 0x0p+0 },
{ INT64_C(0x0000080240020000), 0x1.0048004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdbffdffff), -0x1.00480040002p+43, 0x0p+0 },
{ INT64_C(0x0000080240100000), 0x1.004802p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdbfefffff), -0x1.00480200002p+43, 0x0p+0 },
{ INT64_C(0x0000080240200000), 0x1.004804p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdbfdfffff), -0x1.00480400002p+43, 0x0p+0 },
{ INT64_C(0x0000080240800000), 0x1.00481p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdbf7fffff), -0x1.00481000002p+43, 0x0p+0 },
{ INT64_C(0x0000080242000000), 0x1.00484p+43, 0x0p+0 },
{ INT64_C(0xfffff7fdbdffffff), -0x1.00484000002p+43, 0x0p+0 },
{ INT64_C(0x0000080260000000), 0x1.004cp+43, 0x0p+0 },
{ INT64_C(0xfffff7fd9fffffff), -0x1.004c0000002p+43, 0x0p+0 },
{ INT64_C(0x0000080280000000), 0x1.005p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd7fffffff), -0x1.00500000002p+43, 0x0p+0 },
{ INT64_C(0x0000080280000004), 0x1.00500000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd7ffffffb), -0x1.0050000000ap+43, 0x0p+0 },
{ INT64_C(0x0000080280000008), 0x1.0050000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd7ffffff7), -0x1.00500000012p+43, 0x0p+0 },
{ INT64_C(0x0000080280000040), 0x1.0050000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd7fffffbf), -0x1.00500000082p+43, 0x0p+0 },
{ INT64_C(0x0000080280000200), 0x1.005000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd7ffffdff), -0x1.00500000402p+43, 0x0p+0 },
{ INT64_C(0x0000080280000400), 0x1.005000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd7ffffbff), -0x1.00500000802p+43, 0x0p+0 },
{ INT64_C(0x0000080280002000), 0x1.00500004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd7fffdfff), -0x1.00500004002p+43, 0x0p+0 },
{ INT64_C(0x0000080280004000), 0x1.00500008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd7fffbfff), -0x1.00500008002p+43, 0x0p+0 },
{ INT64_C(0x0000080280040000), 0x1.0050008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd7ffbffff), -0x1.00500080002p+43, 0x0p+0 },
{ INT64_C(0x0000080280080000), 0x1.005001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd7ff7ffff), -0x1.00500100002p+43, 0x0p+0 },
{ INT64_C(0x0000080280800000), 0x1.00501p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd7f7fffff), -0x1.00501000002p+43, 0x0p+0 },
{ INT64_C(0x0000080281000000), 0x1.00502p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd7effffff), -0x1.00502000002p+43, 0x0p+0 },
{ INT64_C(0x0000080290000000), 0x1.0052p+43, 0x0p+0 },
{ INT64_C(0xfffff7fd6fffffff), -0x1.00520000002p+43, 0x0p+0 },
{ INT64_C(0x0000080400000008), 0x1.0080000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfffffff7), -0x1.00800000012p+43, 0x0p+0 },
{ INT64_C(0x0000080400000009), 0x1.00800000012p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfffffff6), -0x1.00800000014p+43, 0x0p+0 },
{ INT64_C(0x000008040000000c), 0x1.00800000018p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfffffff3), -0x1.0080000001ap+43, 0x0p+0 },
{ INT64_C(0x0000080400000010), 0x1.0080000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffffef), -0x1.00800000022p+43, 0x0p+0 },
{ INT64_C(0x0000080400000011), 0x1.00800000022p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffffee), -0x1.00800000024p+43, 0x0p+0 },
{ INT64_C(0x0000080400000012), 0x1.00800000024p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffffed), -0x1.00800000026p+43, 0x0p+0 },
{ INT64_C(0x0000080400000018), 0x1.0080000003p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffffe7), -0x1.00800000032p+43, 0x0p+0 },
{ INT64_C(0x0000080400000020), 0x1.0080000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffffdf), -0x1.00800000042p+43, 0x0p+0 },
{ INT64_C(0x0000080400000022), 0x1.00800000044p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffffdd), -0x1.00800000046p+43, 0x0p+0 },
{ INT64_C(0x0000080400000028), 0x1.0080000005p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffffd7), -0x1.00800000052p+43, 0x0p+0 },
{ INT64_C(0x0000080400000080), 0x1.008000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffff7f), -0x1.00800000102p+43, 0x0p+0 },
{ INT64_C(0x0000080400000084), 0x1.00800000108p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffff7b), -0x1.0080000010ap+43, 0x0p+0 },
{ INT64_C(0x0000080400000090), 0x1.0080000012p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffff6f), -0x1.00800000122p+43, 0x0p+0 },
{ INT64_C(0x00000804000000c0), 0x1.0080000018p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffff3f), -0x1.00800000182p+43, 0x0p+0 },
{ INT64_C(0x0000080400000200), 0x1.008000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfffffdff), -0x1.00800000402p+43, 0x0p+0 },
{ INT64_C(0x0000080400000208), 0x1.0080000041p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfffffdf7), -0x1.00800000412p+43, 0x0p+0 },
{ INT64_C(0x0000080400000240), 0x1.0080000048p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfffffdbf), -0x1.00800000482p+43, 0x0p+0 },
{ INT64_C(0x0000080400002000), 0x1.00800004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffdfff), -0x1.00800004002p+43, 0x0p+0 },
{ INT64_C(0x0000080400002008), 0x1.0080000401p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffdff7), -0x1.00800004012p+43, 0x0p+0 },
{ INT64_C(0x0000080400002040), 0x1.0080000408p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffdfbf), -0x1.00800004082p+43, 0x0p+0 },
{ INT64_C(0x0000080400002200), 0x1.008000044p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffddff), -0x1.00800004402p+43, 0x0p+0 },
{ INT64_C(0x0000080400002800), 0x1.00800005p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffffd7ff), -0x1.00800005002p+43, 0x0p+0 },
{ INT64_C(0x0000080400008000), 0x1.0080001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffff7fff), -0x1.00800010002p+43, 0x0p+0 },
{ INT64_C(0x0000080400008008), 0x1.0080001001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffff7ff7), -0x1.00800010012p+43, 0x0p+0 },
{ INT64_C(0x0000080400008010), 0x1.0080001002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffff7fef), -0x1.00800010022p+43, 0x0p+0 },
{ INT64_C(0x0000080400008020), 0x1.0080001004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffff7fdf), -0x1.00800010042p+43, 0x0p+0 },
{ INT64_C(0x0000080400008040), 0x1.0080001008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffff7fbf), -0x1.00800010082p+43, 0x0p+0 },
{ INT64_C(0x0000080400008100), 0x1.008000102p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffff7eff), -0x1.00800010202p+43, 0x0p+0 },
{ INT64_C(0x0000080400008400), 0x1.008000108p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffff7bff), -0x1.00800010802p+43, 0x0p+0 },
{ INT64_C(0x0000080400009000), 0x1.00800012p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffff6fff), -0x1.00800012002p+43, 0x0p+0 },
{ INT64_C(0x0000080400080000), 0x1.008001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfff7ffff), -0x1.00800100002p+43, 0x0p+0 },
{ INT64_C(0x0000080400080001), 0x1.00800100002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfff7fffe), -0x1.00800100004p+43, 0x0p+0 },
{ INT64_C(0x0000080400080002), 0x1.00800100004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfff7fffd), -0x1.00800100006p+43, 0x0p+0 },
{ INT64_C(0x0000080400080020), 0x1.0080010004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfff7ffdf), -0x1.00800100042p+43, 0x0p+0 },
{ INT64_C(0x0000080400080100), 0x1.008001002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfff7feff), -0x1.00800100202p+43, 0x0p+0 },
{ INT64_C(0x0000080400080200), 0x1.008001004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfff7fdff), -0x1.00800100402p+43, 0x0p+0 },
{ INT64_C(0x0000080400081000), 0x1.00800102p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfff7efff), -0x1.00800102002p+43, 0x0p+0 },
{ INT64_C(0x0000080400090000), 0x1.0080012p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfff6ffff), -0x1.00800120002p+43, 0x0p+0 },
{ INT64_C(0x00000804000a0000), 0x1.0080014p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfff5ffff), -0x1.00800140002p+43, 0x0p+0 },
{ INT64_C(0x0000080400100000), 0x1.008002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffefffff), -0x1.00800200002p+43, 0x0p+0 },
{ INT64_C(0x0000080400100002), 0x1.00800200004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffeffffd), -0x1.00800200006p+43, 0x0p+0 },
{ INT64_C(0x0000080400100004), 0x1.00800200008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffeffffb), -0x1.0080020000ap+43, 0x0p+0 },
{ INT64_C(0x0000080400100020), 0x1.0080020004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffefffdf), -0x1.00800200042p+43, 0x0p+0 },
{ INT64_C(0x0000080400100200), 0x1.008002004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffeffdff), -0x1.00800200402p+43, 0x0p+0 },
{ INT64_C(0x0000080400100800), 0x1.00800201p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffeff7ff), -0x1.00800201002p+43, 0x0p+0 },
{ INT64_C(0x0000080400108000), 0x1.0080021p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffef7fff), -0x1.00800210002p+43, 0x0p+0 },
{ INT64_C(0x0000080400180000), 0x1.008003p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffe7ffff), -0x1.00800300002p+43, 0x0p+0 },
{ INT64_C(0x0000080400200000), 0x1.008004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffdfffff), -0x1.00800400002p+43, 0x0p+0 },
{ INT64_C(0x0000080400200008), 0x1.0080040001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffdffff7), -0x1.00800400012p+43, 0x0p+0 },
{ INT64_C(0x0000080400200020), 0x1.0080040004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffdfffdf), -0x1.00800400042p+43, 0x0p+0 },
{ INT64_C(0x0000080400200080), 0x1.008004001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffdfff7f), -0x1.00800400102p+43, 0x0p+0 },
{ INT64_C(0x0000080400200100), 0x1.008004002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffdffeff), -0x1.00800400202p+43, 0x0p+0 },
{ INT64_C(0x0000080400200800), 0x1.00800401p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffdff7ff), -0x1.00800401002p+43, 0x0p+0 },
{ INT64_C(0x0000080400201000), 0x1.00800402p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffdfefff), -0x1.00800402002p+43, 0x0p+0 },
{ INT64_C(0x0000080400210000), 0x1.0080042p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffdeffff), -0x1.00800420002p+43, 0x0p+0 },
{ INT64_C(0x0000080400300000), 0x1.008006p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbffcfffff), -0x1.00800600002p+43, 0x0p+0 },
{ INT64_C(0x0000080400800000), 0x1.00801p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbff7fffff), -0x1.00801000002p+43, 0x0p+0 },
{ INT64_C(0x0000080400800004), 0x1.00801000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbff7ffffb), -0x1.0080100000ap+43, 0x0p+0 },
{ INT64_C(0x0000080400800010), 0x1.0080100002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbff7fffef), -0x1.00801000022p+43, 0x0p+0 },
{ INT64_C(0x0000080400800020), 0x1.0080100004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbff7fffdf), -0x1.00801000042p+43, 0x0p+0 },
{ INT64_C(0x0000080400800200), 0x1.008010004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbff7ffdff), -0x1.00801000402p+43, 0x0p+0 },
{ INT64_C(0x0000080400801000), 0x1.00801002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbff7fefff), -0x1.00801002002p+43, 0x0p+0 },
{ INT64_C(0x0000080400810000), 0x1.0080102p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbff7effff), -0x1.00801020002p+43, 0x0p+0 },
{ INT64_C(0x0000080400840000), 0x1.0080108p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbff7bffff), -0x1.00801080002p+43, 0x0p+0 },
{ INT64_C(0x0000080400900000), 0x1.008012p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbff6fffff), -0x1.00801200002p+43, 0x0p+0 },
{ INT64_C(0x0000080400c00000), 0x1.008018p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbff3fffff), -0x1.00801800002p+43, 0x0p+0 },
{ INT64_C(0x0000080401000000), 0x1.00802p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfeffffff), -0x1.00802000002p+43, 0x0p+0 },
{ INT64_C(0x0000080401000001), 0x1.00802000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfefffffe), -0x1.00802000004p+43, 0x0p+0 },
{ INT64_C(0x0000080401000010), 0x1.0080200002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfeffffef), -0x1.00802000022p+43, 0x0p+0 },
{ INT64_C(0x0000080401000100), 0x1.008020002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfefffeff), -0x1.00802000202p+43, 0x0p+0 },
{ INT64_C(0x0000080401000800), 0x1.00802001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfefff7ff), -0x1.00802001002p+43, 0x0p+0 },
{ INT64_C(0x0000080401008000), 0x1.0080201p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfeff7fff), -0x1.00802010002p+43, 0x0p+0 },
{ INT64_C(0x0000080401020000), 0x1.0080204p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfefdffff), -0x1.00802040002p+43, 0x0p+0 },
{ INT64_C(0x0000080401040000), 0x1.0080208p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfefbffff), -0x1.00802080002p+43, 0x0p+0 },
{ INT64_C(0x0000080401080000), 0x1.008021p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfef7ffff), -0x1.00802100002p+43, 0x0p+0 },
{ INT64_C(0x0000080401200000), 0x1.008024p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfedfffff), -0x1.00802400002p+43, 0x0p+0 },
{ INT64_C(0x0000080401800000), 0x1.00803p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfe7fffff), -0x1.00803000002p+43, 0x0p+0 },
{ INT64_C(0x0000080402000000), 0x1.00804p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfdffffff), -0x1.00804000002p+43, 0x0p+0 },
{ INT64_C(0x0000080402000002), 0x1.00804000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfdfffffd), -0x1.00804000006p+43, 0x0p+0 },
{ INT64_C(0x0000080402000020), 0x1.0080400004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfdffffdf), -0x1.00804000042p+43, 0x0p+0 },
{ INT64_C(0x0000080402000200), 0x1.008040004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfdfffdff), -0x1.00804000402p+43, 0x0p+0 },
{ INT64_C(0x0000080402000400), 0x1.008040008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfdfffbff), -0x1.00804000802p+43, 0x0p+0 },
{ INT64_C(0x0000080402004000), 0x1.00804008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfdffbfff), -0x1.00804008002p+43, 0x0p+0 },
{ INT64_C(0x0000080402020000), 0x1.0080404p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfdfdffff), -0x1.00804040002p+43, 0x0p+0 },
{ INT64_C(0x0000080402200000), 0x1.008044p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfddfffff), -0x1.00804400002p+43, 0x0p+0 },
{ INT64_C(0x0000080403000000), 0x1.00806p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfcffffff), -0x1.00806000002p+43, 0x0p+0 },
{ INT64_C(0x0000080404000000), 0x1.00808p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfbffffff), -0x1.00808000002p+43, 0x0p+0 },
{ INT64_C(0x0000080404000002), 0x1.00808000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfbfffffd), -0x1.00808000006p+43, 0x0p+0 },
{ INT64_C(0x0000080404000010), 0x1.0080800002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfbffffef), -0x1.00808000022p+43, 0x0p+0 },
{ INT64_C(0x0000080404000020), 0x1.0080800004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfbffffdf), -0x1.00808000042p+43, 0x0p+0 },
{ INT64_C(0x0000080404000200), 0x1.008080004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfbfffdff), -0x1.00808000402p+43, 0x0p+0 },
{ INT64_C(0x0000080404001000), 0x1.00808002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfbffefff), -0x1.00808002002p+43, 0x0p+0 },
{ INT64_C(0x0000080404010000), 0x1.0080802p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfbfeffff), -0x1.00808020002p+43, 0x0p+0 },
{ INT64_C(0x0000080404100000), 0x1.008082p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfbefffff), -0x1.00808200002p+43, 0x0p+0 },
{ INT64_C(0x0000080405000000), 0x1.0080ap+43, 0x0p+0 },
{ INT64_C(0xfffff7fbfaffffff), -0x1.0080a000002p+43, 0x0p+0 },
{ INT64_C(0x0000080420000000), 0x1.0084p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbdfffffff), -0x1.00840000002p+43, 0x0p+0 },
{ INT64_C(0x0000080420000002), 0x1.00840000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbdffffffd), -0x1.00840000006p+43, 0x0p+0 },
{ INT64_C(0x0000080420000008), 0x1.0084000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbdffffff7), -0x1.00840000012p+43, 0x0p+0 },
{ INT64_C(0x0000080420000080), 0x1.008400001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbdfffff7f), -0x1.00840000102p+43, 0x0p+0 },
{ INT64_C(0x0000080420000100), 0x1.008400002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbdffffeff), -0x1.00840000202p+43, 0x0p+0 },
{ INT64_C(0x0000080420000800), 0x1.00840001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbdffff7ff), -0x1.00840001002p+43, 0x0p+0 },
{ INT64_C(0x0000080420002000), 0x1.00840004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbdfffdfff), -0x1.00840004002p+43, 0x0p+0 },
{ INT64_C(0x0000080420008000), 0x1.0084001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbdfff7fff), -0x1.00840010002p+43, 0x0p+0 },
{ INT64_C(0x0000080420040000), 0x1.0084008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbdffbffff), -0x1.00840080002p+43, 0x0p+0 },
{ INT64_C(0x0000080420100000), 0x1.008402p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbdfefffff), -0x1.00840200002p+43, 0x0p+0 },
{ INT64_C(0x0000080420400000), 0x1.008408p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbdfbfffff), -0x1.00840800002p+43, 0x0p+0 },
{ INT64_C(0x0000080421000000), 0x1.00842p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbdeffffff), -0x1.00842000002p+43, 0x0p+0 },
{ INT64_C(0x0000080428000000), 0x1.0085p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbd7ffffff), -0x1.00850000002p+43, 0x0p+0 },
{ INT64_C(0x0000080430000000), 0x1.0086p+43, 0x0p+0 },
{ INT64_C(0xfffff7fbcfffffff), -0x1.00860000002p+43, 0x0p+0 },
{ INT64_C(0x0000080500000000), 0x1.00ap+43, 0x0p+0 },
{ INT64_C(0xfffff7faffffffff), -0x1.00a00000002p+43, 0x0p+0 },
{ INT64_C(0x0000080500000004), 0x1.00a00000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7fafffffffb), -0x1.00a0000000ap+43, 0x0p+0 },
{ INT64_C(0x0000080500000040), 0x1.00a0000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7faffffffbf), -0x1.00a00000082p+43, 0x0p+0 },
{ INT64_C(0x0000080500000100), 0x1.00a000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7fafffffeff), -0x1.00a00000202p+43, 0x0p+0 },
{ INT64_C(0x0000080500001000), 0x1.00a00002p+43, 0x0p+0 },
{ INT64_C(0xfffff7faffffefff), -0x1.00a00002002p+43, 0x0p+0 },
{ INT64_C(0x0000080500002000), 0x1.00a00004p+43, 0x0p+0 },
{ INT64_C(0xfffff7faffffdfff), -0x1.00a00004002p+43, 0x0p+0 },
{ INT64_C(0x0000080500004000), 0x1.00a00008p+43, 0x0p+0 },
{ INT64_C(0xfffff7faffffbfff), -0x1.00a00008002p+43, 0x0p+0 },
{ INT64_C(0x0000080500008000), 0x1.00a0001p+43, 0x0p+0 },
{ INT64_C(0xfffff7faffff7fff), -0x1.00a00010002p+43, 0x0p+0 },
{ INT64_C(0x0000080500020000), 0x1.00a0004p+43, 0x0p+0 },
{ INT64_C(0xfffff7fafffdffff), -0x1.00a00040002p+43, 0x0p+0 },
{ INT64_C(0x0000080500080000), 0x1.00a001p+43, 0x0p+0 },
{ INT64_C(0xfffff7fafff7ffff), -0x1.00a00100002p+43, 0x0p+0 },
{ INT64_C(0x0000080500400000), 0x1.00a008p+43, 0x0p+0 },
{ INT64_C(0xfffff7faffbfffff), -0x1.00a00800002p+43, 0x0p+0 },
{ INT64_C(0x0000080501000000), 0x1.00a02p+43, 0x0p+0 },
{ INT64_C(0xfffff7fafeffffff), -0x1.00a02000002p+43, 0x0p+0 },
{ INT64_C(0x0000080502000000), 0x1.00a04p+43, 0x0p+0 },
{ INT64_C(0xfffff7fafdffffff), -0x1.00a04000002p+43, 0x0p+0 },
{ INT64_C(0x0000080504000000), 0x1.00a08p+43, 0x0p+0 },
{ INT64_C(0xfffff7fafbffffff), -0x1.00a08000002p+43, 0x0p+0 },
{ INT64_C(0x0000080520000000), 0x1.00a4p+43, 0x0p+0 },
{ INT64_C(0xfffff7fadfffffff), -0x1.00a40000002p+43, 0x0p+0 },
{ INT64_C(0x0000084000000001), 0x1.08000000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffffffe), -0x1.08000000004p+43, 0x0p+0 },
{ INT64_C(0x0000084000000010), 0x1.0800000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffffffef), -0x1.08000000022p+43, 0x0p+0 },
{ INT64_C(0x0000084000000011), 0x1.08000000022p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffffffee), -0x1.08000000024p+43, 0x0p+0 },
{ INT64_C(0x0000084000000100), 0x1.080000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffffeff), -0x1.08000000202p+43, 0x0p+0 },
{ INT64_C(0x0000084000000108), 0x1.0800000021p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffffef7), -0x1.08000000212p+43, 0x0p+0 },
{ INT64_C(0x0000084000000120), 0x1.0800000024p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffffedf), -0x1.08000000242p+43, 0x0p+0 },
{ INT64_C(0x0000084000000180), 0x1.080000003p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffffe7f), -0x1.08000000302p+43, 0x0p+0 },
{ INT64_C(0x0000084000000200), 0x1.080000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffffdff), -0x1.08000000402p+43, 0x0p+0 },
{ INT64_C(0x0000084000000202), 0x1.08000000404p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffffdfd), -0x1.08000000406p+43, 0x0p+0 },
{ INT64_C(0x0000084000000208), 0x1.0800000041p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffffdf7), -0x1.08000000412p+43, 0x0p+0 },
{ INT64_C(0x0000084000000280), 0x1.080000005p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffffd7f), -0x1.08000000502p+43, 0x0p+0 },
{ INT64_C(0x0000084000000300), 0x1.080000006p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffffcff), -0x1.08000000602p+43, 0x0p+0 },
{ INT64_C(0x0000084000000800), 0x1.08000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffff7ff), -0x1.08000001002p+43, 0x0p+0 },
{ INT64_C(0x0000084000000801), 0x1.08000001002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffff7fe), -0x1.08000001004p+43, 0x0p+0 },
{ INT64_C(0x0000084000000808), 0x1.0800000101p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffff7f7), -0x1.08000001012p+43, 0x0p+0 },
{ INT64_C(0x0000084000000880), 0x1.080000011p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffff77f), -0x1.08000001102p+43, 0x0p+0 },
{ INT64_C(0x0000084000000900), 0x1.080000012p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffff6ff), -0x1.08000001202p+43, 0x0p+0 },
{ INT64_C(0x0000084000004000), 0x1.08000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffffbfff), -0x1.08000008002p+43, 0x0p+0 },
{ INT64_C(0x0000084000004002), 0x1.08000008004p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffffbffd), -0x1.08000008006p+43, 0x0p+0 },
{ INT64_C(0x0000084000004004), 0x1.08000008008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffffbffb), -0x1.0800000800ap+43, 0x0p+0 },
{ INT64_C(0x0000084000004010), 0x1.0800000802p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffffbfef), -0x1.08000008022p+43, 0x0p+0 },
{ INT64_C(0x0000084000004100), 0x1.080000082p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffffbeff), -0x1.08000008202p+43, 0x0p+0 },
{ INT64_C(0x0000084000005000), 0x1.0800000ap+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffffafff), -0x1.0800000a002p+43, 0x0p+0 },
{ INT64_C(0x0000084000010000), 0x1.0800002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffeffff), -0x1.08000020002p+43, 0x0p+0 },
{ INT64_C(0x0000084000010004), 0x1.08000020008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffefffb), -0x1.0800002000ap+43, 0x0p+0 },
{ INT64_C(0x0000084000010008), 0x1.0800002001p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffefff7), -0x1.08000020012p+43, 0x0p+0 },
{ INT64_C(0x0000084000010080), 0x1.080000201p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffeff7f), -0x1.08000020102p+43, 0x0p+0 },
{ INT64_C(0x0000084000010200), 0x1.080000204p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffefdff), -0x1.08000020402p+43, 0x0p+0 },
{ INT64_C(0x0000084000012000), 0x1.08000024p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffffedfff), -0x1.08000024002p+43, 0x0p+0 },
{ INT64_C(0x0000084000080000), 0x1.080001p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffff7ffff), -0x1.08000100002p+43, 0x0p+0 },
{ INT64_C(0x0000084000080008), 0x1.0800010001p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffff7fff7), -0x1.08000100012p+43, 0x0p+0 },
{ INT64_C(0x0000084000080010), 0x1.0800010002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffff7ffef), -0x1.08000100022p+43, 0x0p+0 },
{ INT64_C(0x0000084000080080), 0x1.080001001p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffff7ff7f), -0x1.08000100102p+43, 0x0p+0 },
{ INT64_C(0x0000084000080800), 0x1.08000101p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffff7f7ff), -0x1.08000101002p+43, 0x0p+0 },
{ INT64_C(0x0000084000088000), 0x1.0800011p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffff77fff), -0x1.08000110002p+43, 0x0p+0 },
{ INT64_C(0x00000840000a0000), 0x1.0800014p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffff5ffff), -0x1.08000140002p+43, 0x0p+0 },
{ INT64_C(0x00000840000c0000), 0x1.0800018p+43, 0x0p+0 },
{ INT64_C(0xfffff7bffff3ffff), -0x1.08000180002p+43, 0x0p+0 },
{ INT64_C(0x0000084000100000), 0x1.080002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffefffff), -0x1.08000200002p+43, 0x0p+0 },
{ INT64_C(0x0000084000100008), 0x1.0800020001p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffeffff7), -0x1.08000200012p+43, 0x0p+0 },
{ INT64_C(0x0000084000100020), 0x1.0800020004p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffefffdf), -0x1.08000200042p+43, 0x0p+0 },
{ INT64_C(0x0000084000100040), 0x1.0800020008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffefffbf), -0x1.08000200082p+43, 0x0p+0 },
{ INT64_C(0x0000084000100080), 0x1.080002001p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffefff7f), -0x1.08000200102p+43, 0x0p+0 },
{ INT64_C(0x0000084000100400), 0x1.080002008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffeffbff), -0x1.08000200802p+43, 0x0p+0 },
{ INT64_C(0x0000084000100800), 0x1.08000201p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffeff7ff), -0x1.08000201002p+43, 0x0p+0 },
{ INT64_C(0x0000084000101000), 0x1.08000202p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffefefff), -0x1.08000202002p+43, 0x0p+0 },
{ INT64_C(0x0000084000108000), 0x1.0800021p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffef7fff), -0x1.08000210002p+43, 0x0p+0 },
{ INT64_C(0x0000084000110000), 0x1.0800022p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffeeffff), -0x1.08000220002p+43, 0x0p+0 },
{ INT64_C(0x0000084000140000), 0x1.0800028p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfffebffff), -0x1.08000280002p+43, 0x0p+0 },
{ INT64_C(0x0000084000800000), 0x1.08001p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfff7fffff), -0x1.08001000002p+43, 0x0p+0 },
{ INT64_C(0x0000084000800004), 0x1.08001000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfff7ffffb), -0x1.0800100000ap+43, 0x0p+0 },
{ INT64_C(0x0000084000800040), 0x1.0800100008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfff7fffbf), -0x1.08001000082p+43, 0x0p+0 },
{ INT64_C(0x0000084000800080), 0x1.080010001p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfff7fff7f), -0x1.08001000102p+43, 0x0p+0 },
{ INT64_C(0x0000084000800400), 0x1.080010008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfff7ffbff), -0x1.08001000802p+43, 0x0p+0 },
{ INT64_C(0x0000084000801000), 0x1.08001002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfff7fefff), -0x1.08001002002p+43, 0x0p+0 },
{ INT64_C(0x0000084000802000), 0x1.08001004p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfff7fdfff), -0x1.08001004002p+43, 0x0p+0 },
{ INT64_C(0x0000084000810000), 0x1.0800102p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfff7effff), -0x1.08001020002p+43, 0x0p+0 },
{ INT64_C(0x0000084000900000), 0x1.080012p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfff6fffff), -0x1.08001200002p+43, 0x0p+0 },
{ INT64_C(0x0000084008000000), 0x1.0801p+43, 0x0p+0 },
{ INT64_C(0xfffff7bff7ffffff), -0x1.08010000002p+43, 0x0p+0 },
{ INT64_C(0x0000084008000004), 0x1.08010000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bff7fffffb), -0x1.0801000000ap+43, 0x0p+0 },
{ INT64_C(0x0000084008000040), 0x1.0801000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bff7ffffbf), -0x1.08010000082p+43, 0x0p+0 },
{ INT64_C(0x0000084008000200), 0x1.080100004p+43, 0x0p+0 },
{ INT64_C(0xfffff7bff7fffdff), -0x1.08010000402p+43, 0x0p+0 },
{ INT64_C(0x0000084008002000), 0x1.08010004p+43, 0x0p+0 },
{ INT64_C(0xfffff7bff7ffdfff), -0x1.08010004002p+43, 0x0p+0 },
{ INT64_C(0x0000084008004000), 0x1.08010008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bff7ffbfff), -0x1.08010008002p+43, 0x0p+0 },
{ INT64_C(0x0000084008020000), 0x1.0801004p+43, 0x0p+0 },
{ INT64_C(0xfffff7bff7fdffff), -0x1.08010040002p+43, 0x0p+0 },
{ INT64_C(0x0000084008040000), 0x1.0801008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bff7fbffff), -0x1.08010080002p+43, 0x0p+0 },
{ INT64_C(0x0000084008200000), 0x1.080104p+43, 0x0p+0 },
{ INT64_C(0xfffff7bff7dfffff), -0x1.08010400002p+43, 0x0p+0 },
{ INT64_C(0x0000084009000000), 0x1.08012p+43, 0x0p+0 },
{ INT64_C(0xfffff7bff6ffffff), -0x1.08012000002p+43, 0x0p+0 },
{ INT64_C(0x000008400a000000), 0x1.08014p+43, 0x0p+0 },
{ INT64_C(0xfffff7bff5ffffff), -0x1.08014000002p+43, 0x0p+0 },
{ INT64_C(0x0000084010000000), 0x1.0802p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfefffffff), -0x1.08020000002p+43, 0x0p+0 },
{ INT64_C(0x0000084010000002), 0x1.08020000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfeffffffd), -0x1.08020000006p+43, 0x0p+0 },
{ INT64_C(0x0000084010000008), 0x1.0802000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfeffffff7), -0x1.08020000012p+43, 0x0p+0 },
{ INT64_C(0x0000084010000040), 0x1.0802000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfefffffbf), -0x1.08020000082p+43, 0x0p+0 },
{ INT64_C(0x0000084010000100), 0x1.080200002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfeffffeff), -0x1.08020000202p+43, 0x0p+0 },
{ INT64_C(0x0000084010001000), 0x1.08020002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfefffefff), -0x1.08020002002p+43, 0x0p+0 },
{ INT64_C(0x0000084010010000), 0x1.0802002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfeffeffff), -0x1.08020020002p+43, 0x0p+0 },
{ INT64_C(0x0000084010100000), 0x1.080202p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfefefffff), -0x1.08020200002p+43, 0x0p+0 },
{ INT64_C(0x0000084010200000), 0x1.080204p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfefdfffff), -0x1.08020400002p+43, 0x0p+0 },
{ INT64_C(0x0000084010800000), 0x1.08021p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfef7fffff), -0x1.08021000002p+43, 0x0p+0 },
{ INT64_C(0x0000084014000000), 0x1.08028p+43, 0x0p+0 },
{ INT64_C(0xfffff7bfebffffff), -0x1.08028000002p+43, 0x0p+0 },
{ INT64_C(0x0000084080000000), 0x1.081p+43, 0x0p+0 },
{ INT64_C(0xfffff7bf7fffffff), -0x1.08100000002p+43, 0x0p+0 },
{ INT64_C(0x0000084080000002), 0x1.08100000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7bf7ffffffd), -0x1.08100000006p+43, 0x0p+0 },
{ INT64_C(0x0000084080000010), 0x1.0810000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bf7fffffef), -0x1.08100000022p+43, 0x0p+0 },
{ INT64_C(0x0000084080000100), 0x1.081000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bf7ffffeff), -0x1.08100000202p+43, 0x0p+0 },
{ INT64_C(0x0000084080001000), 0x1.08100002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bf7fffefff), -0x1.08100002002p+43, 0x0p+0 },
{ INT64_C(0x0000084080008000), 0x1.0810001p+43, 0x0p+0 },
{ INT64_C(0xfffff7bf7fff7fff), -0x1.08100010002p+43, 0x0p+0 },
{ INT64_C(0x0000084080020000), 0x1.0810004p+43, 0x0p+0 },
{ INT64_C(0xfffff7bf7ffdffff), -0x1.08100040002p+43, 0x0p+0 },
{ INT64_C(0x0000084080100000), 0x1.081002p+43, 0x0p+0 },
{ INT64_C(0xfffff7bf7fefffff), -0x1.08100200002p+43, 0x0p+0 },
{ INT64_C(0x0000084081000000), 0x1.08102p+43, 0x0p+0 },
{ INT64_C(0xfffff7bf7effffff), -0x1.08102000002p+43, 0x0p+0 },
{ INT64_C(0x0000084088000000), 0x1.0811p+43, 0x0p+0 },
{ INT64_C(0xfffff7bf77ffffff), -0x1.08110000002p+43, 0x0p+0 },
{ INT64_C(0x00000840a0000000), 0x1.0814p+43, 0x0p+0 },
{ INT64_C(0xfffff7bf5fffffff), -0x1.08140000002p+43, 0x0p+0 },
{ INT64_C(0x00000840c0000000), 0x1.0818p+43, 0x0p+0 },
{ INT64_C(0xfffff7bf3fffffff), -0x1.08180000002p+43, 0x0p+0 },
{ INT64_C(0x0000084800000000), 0x1.09p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7ffffffff), -0x1.09000000002p+43, 0x0p+0 },
{ INT64_C(0x0000084800000004), 0x1.09000000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7fffffffb), -0x1.0900000000ap+43, 0x0p+0 },
{ INT64_C(0x0000084800000008), 0x1.0900000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7fffffff7), -0x1.09000000012p+43, 0x0p+0 },
{ INT64_C(0x0000084800000040), 0x1.0900000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7ffffffbf), -0x1.09000000082p+43, 0x0p+0 },
{ INT64_C(0x0000084800000200), 0x1.090000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7fffffdff), -0x1.09000000402p+43, 0x0p+0 },
{ INT64_C(0x0000084800000800), 0x1.09000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7fffff7ff), -0x1.09000001002p+43, 0x0p+0 },
{ INT64_C(0x0000084800001000), 0x1.09000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7ffffefff), -0x1.09000002002p+43, 0x0p+0 },
{ INT64_C(0x0000084800004000), 0x1.09000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7ffffbfff), -0x1.09000008002p+43, 0x0p+0 },
{ INT64_C(0x0000084800040000), 0x1.0900008p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7fffbffff), -0x1.09000080002p+43, 0x0p+0 },
{ INT64_C(0x0000084800200000), 0x1.090004p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7ffdfffff), -0x1.09000400002p+43, 0x0p+0 },
{ INT64_C(0x0000084800800000), 0x1.09001p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7ff7fffff), -0x1.09001000002p+43, 0x0p+0 },
{ INT64_C(0x0000084801000000), 0x1.09002p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7feffffff), -0x1.09002000002p+43, 0x0p+0 },
{ INT64_C(0x0000084804000000), 0x1.09008p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7fbffffff), -0x1.09008000002p+43, 0x0p+0 },
{ INT64_C(0x0000084808000000), 0x1.0901p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7f7ffffff), -0x1.09010000002p+43, 0x0p+0 },
{ INT64_C(0x0000084820000000), 0x1.0904p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7dfffffff), -0x1.09040000002p+43, 0x0p+0 },
{ INT64_C(0x0000084840000000), 0x1.0908p+43, 0x0p+0 },
{ INT64_C(0xfffff7b7bfffffff), -0x1.09080000002p+43, 0x0p+0 },
{ INT64_C(0x0000084c00000000), 0x1.098p+43, 0x0p+0 },
{ INT64_C(0xfffff7b3ffffffff), -0x1.09800000002p+43, 0x0p+0 },
{ INT64_C(0x0000085000000000), 0x1.0ap+43, 0x0p+0 },
{ INT64_C(0xfffff7afffffffff), -0x1.0a000000002p+43, 0x0p+0 },
{ INT64_C(0x0000085000000002), 0x1.0a000000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7affffffffd), -0x1.0a000000006p+43, 0x0p+0 },
{ INT64_C(0x0000085000000008), 0x1.0a00000001p+43, 0x0p+0 },
{ INT64_C(0xfffff7affffffff7), -0x1.0a000000012p+43, 0x0p+0 },
{ INT64_C(0x0000085000000010), 0x1.0a00000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7afffffffef), -0x1.0a000000022p+43, 0x0p+0 },
{ INT64_C(0x0000085000000040), 0x1.0a00000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7afffffffbf), -0x1.0a000000082p+43, 0x0p+0 },
{ INT64_C(0x0000085000000100), 0x1.0a0000002p+43, 0x0p+0 },
{ INT64_C(0xfffff7affffffeff), -0x1.0a000000202p+43, 0x0p+0 },
{ INT64_C(0x0000085000000400), 0x1.0a0000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7affffffbff), -0x1.0a000000802p+43, 0x0p+0 },
{ INT64_C(0x0000085000002000), 0x1.0a000004p+43, 0x0p+0 },
{ INT64_C(0xfffff7afffffdfff), -0x1.0a000004002p+43, 0x0p+0 },
{ INT64_C(0x0000085000004000), 0x1.0a000008p+43, 0x0p+0 },
{ INT64_C(0xfffff7afffffbfff), -0x1.0a000008002p+43, 0x0p+0 },
{ INT64_C(0x0000085000008000), 0x1.0a00001p+43, 0x0p+0 },
{ INT64_C(0xfffff7afffff7fff), -0x1.0a000010002p+43, 0x0p+0 },
{ INT64_C(0x0000085000080000), 0x1.0a0001p+43, 0x0p+0 },
{ INT64_C(0xfffff7affff7ffff), -0x1.0a000100002p+43, 0x0p+0 },
{ INT64_C(0x0000085000200000), 0x1.0a0004p+43, 0x0p+0 },
{ INT64_C(0xfffff7afffdfffff), -0x1.0a000400002p+43, 0x0p+0 },
{ INT64_C(0x0000085000400000), 0x1.0a0008p+43, 0x0p+0 },
{ INT64_C(0xfffff7afffbfffff), -0x1.0a000800002p+43, 0x0p+0 },
{ INT64_C(0x0000085002000000), 0x1.0a004p+43, 0x0p+0 },
{ INT64_C(0xfffff7affdffffff), -0x1.0a004000002p+43, 0x0p+0 },
{ INT64_C(0x0000085020000000), 0x1.0a04p+43, 0x0p+0 },
{ INT64_C(0xfffff7afdfffffff), -0x1.0a040000002p+43, 0x0p+0 },
{ INT64_C(0x0000085040000000), 0x1.0a08p+43, 0x0p+0 },
{ INT64_C(0xfffff7afbfffffff), -0x1.0a080000002p+43, 0x0p+0 },
{ INT64_C(0x0000085080000000), 0x1.0a1p+43, 0x0p+0 },
{ INT64_C(0xfffff7af7fffffff), -0x1.0a100000002p+43, 0x0p+0 },
{ INT64_C(0x0000085400000000), 0x1.0a8p+43, 0x0p+0 },
{ INT64_C(0xfffff7abffffffff), -0x1.0a800000002p+43, 0x0p+0 },
{ INT64_C(0x0000090000000008), 0x1.2000000001p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffffff7), -0x1.20000000012p+43, 0x0p+0 },
{ INT64_C(0x000009000000000c), 0x1.20000000018p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffffff3), -0x1.2000000001ap+43, 0x0p+0 },
{ INT64_C(0x0000090000000020), 0x1.2000000004p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffffffdf), -0x1.20000000042p+43, 0x0p+0 },
{ INT64_C(0x0000090000000024), 0x1.20000000048p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffffffdb), -0x1.2000000004ap+43, 0x0p+0 },
{ INT64_C(0x0000090000000030), 0x1.2000000006p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffffffcf), -0x1.20000000062p+43, 0x0p+0 },
{ INT64_C(0x0000090000000200), 0x1.200000004p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffffdff), -0x1.20000000402p+43, 0x0p+0 },
{ INT64_C(0x0000090000000204), 0x1.20000000408p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffffdfb), -0x1.2000000040ap+43, 0x0p+0 },
{ INT64_C(0x0000090000000210), 0x1.2000000042p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffffdef), -0x1.20000000422p+43, 0x0p+0 },
{ INT64_C(0x0000090000000240), 0x1.2000000048p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffffdbf), -0x1.20000000482p+43, 0x0p+0 },
{ INT64_C(0x0000090000000280), 0x1.200000005p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffffd7f), -0x1.20000000502p+43, 0x0p+0 },
{ INT64_C(0x0000090000000300), 0x1.200000006p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffffcff), -0x1.20000000602p+43, 0x0p+0 },
{ INT64_C(0x0000090000000800), 0x1.20000001p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffff7ff), -0x1.20000001002p+43, 0x0p+0 },
{ INT64_C(0x0000090000000801), 0x1.20000001002p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffff7fe), -0x1.20000001004p+43, 0x0p+0 },
{ INT64_C(0x0000090000000810), 0x1.2000000102p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffff7ef), -0x1.20000001022p+43, 0x0p+0 },
{ INT64_C(0x0000090000000900), 0x1.200000012p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffff6ff), -0x1.20000001202p+43, 0x0p+0 },
{ INT64_C(0x0000090000000a00), 0x1.200000014p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffffff5ff), -0x1.20000001402p+43, 0x0p+0 },
{ INT64_C(0x0000090000008000), 0x1.2000001p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffff7fff), -0x1.20000010002p+43, 0x0p+0 },
{ INT64_C(0x0000090000008002), 0x1.20000010004p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffff7ffd), -0x1.20000010006p+43, 0x0p+0 },
{ INT64_C(0x0000090000008008), 0x1.2000001001p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffff7ff7), -0x1.20000010012p+43, 0x0p+0 },
{ INT64_C(0x0000090000008010), 0x1.2000001002p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffff7fef), -0x1.20000010022p+43, 0x0p+0 },
{ INT64_C(0x0000090000008080), 0x1.200000101p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffff7f7f), -0x1.20000010102p+43, 0x0p+0 },
{ INT64_C(0x0000090000008100), 0x1.200000102p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffff7eff), -0x1.20000010202p+43, 0x0p+0 },
{ INT64_C(0x0000090000008200), 0x1.200000104p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffff7dff), -0x1.20000010402p+43, 0x0p+0 },
{ INT64_C(0x0000090000008800), 0x1.20000011p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffff77ff), -0x1.20000011002p+43, 0x0p+0 },
{ INT64_C(0x0000090000009000), 0x1.20000012p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffff6fff), -0x1.20000012002p+43, 0x0p+0 },
{ INT64_C(0x000009000000a000), 0x1.20000014p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffff5fff), -0x1.20000014002p+43, 0x0p+0 },
{ INT64_C(0x0000090000080000), 0x1.200001p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffff7ffff), -0x1.20000100002p+43, 0x0p+0 },
{ INT64_C(0x0000090000080004), 0x1.20000100008p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffff7fffb), -0x1.2000010000ap+43, 0x0p+0 },
{ INT64_C(0x0000090000080010), 0x1.2000010002p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffff7ffef), -0x1.20000100022p+43, 0x0p+0 },
{ INT64_C(0x0000090000080040), 0x1.2000010008p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffff7ffbf), -0x1.20000100082p+43, 0x0p+0 },
{ INT64_C(0x0000090000080200), 0x1.200001004p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffff7fdff), -0x1.20000100402p+43, 0x0p+0 },
{ INT64_C(0x0000090000081000), 0x1.20000102p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffff7efff), -0x1.20000102002p+43, 0x0p+0 },
{ INT64_C(0x0000090000090000), 0x1.2000012p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffff6ffff), -0x1.20000120002p+43, 0x0p+0 },
{ INT64_C(0x00000900000c0000), 0x1.2000018p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffff3ffff), -0x1.20000180002p+43, 0x0p+0 },
{ INT64_C(0x0000090000100000), 0x1.200002p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffefffff), -0x1.20000200002p+43, 0x0p+0 },
{ INT64_C(0x0000090000100002), 0x1.20000200004p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffeffffd), -0x1.20000200006p+43, 0x0p+0 },
{ INT64_C(0x0000090000100020), 0x1.2000020004p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffefffdf), -0x1.20000200042p+43, 0x0p+0 },
{ INT64_C(0x0000090000100080), 0x1.200002001p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffefff7f), -0x1.20000200102p+43, 0x0p+0 },
{ INT64_C(0x0000090000100200), 0x1.200002004p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffeffdff), -0x1.20000200402p+43, 0x0p+0 },
{ INT64_C(0x0000090000102000), 0x1.20000204p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffefdfff), -0x1.20000204002p+43, 0x0p+0 },
{ INT64_C(0x0000090000104000), 0x1.20000208p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffefbfff), -0x1.20000208002p+43, 0x0p+0 },
{ INT64_C(0x0000090000108000), 0x1.2000021p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffef7fff), -0x1.20000210002p+43, 0x0p+0 },
{ INT64_C(0x0000090000140000), 0x1.2000028p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffebffff), -0x1.20000280002p+43, 0x0p+0 },
{ INT64_C(0x0000090000180000), 0x1.200003p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffe7ffff), -0x1.20000300002p+43, 0x0p+0 },
{ INT64_C(0x0000090000400000), 0x1.200008p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffbfffff), -0x1.20000800002p+43, 0x0p+0 },
{ INT64_C(0x0000090000400002), 0x1.20000800004p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffbffffd), -0x1.20000800006p+43, 0x0p+0 },
{ INT64_C(0x0000090000400008), 0x1.2000080001p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffbffff7), -0x1.20000800012p+43, 0x0p+0 },
{ INT64_C(0x0000090000400020), 0x1.2000080004p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffbfffdf), -0x1.20000800042p+43, 0x0p+0 },
{ INT64_C(0x0000090000400080), 0x1.200008001p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffbfff7f), -0x1.20000800102p+43, 0x0p+0 },
{ INT64_C(0x0000090000400400), 0x1.200008008p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffbffbff), -0x1.20000800802p+43, 0x0p+0 },
{ INT64_C(0x0000090000400800), 0x1.20000801p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffbff7ff), -0x1.20000801002p+43, 0x0p+0 },
{ INT64_C(0x0000090000402000), 0x1.20000804p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffbfdfff), -0x1.20000804002p+43, 0x0p+0 },
{ INT64_C(0x0000090000410000), 0x1.2000082p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffbeffff), -0x1.20000820002p+43, 0x0p+0 },
{ INT64_C(0x0000090000500000), 0x1.20000ap+43, 0x0p+0 },
{ INT64_C(0xfffff6ffffafffff), -0x1.20000a00002p+43, 0x0p+0 },
{ INT64_C(0x0000090002000000), 0x1.20004p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffdffffff), -0x1.20004000002p+43, 0x0p+0 },
{ INT64_C(0x0000090002000004), 0x1.20004000008p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffdfffffb), -0x1.2000400000ap+43, 0x0p+0 },
{ INT64_C(0x0000090002000008), 0x1.2000400001p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffdfffff7), -0x1.20004000012p+43, 0x0p+0 },
{ INT64_C(0x0000090002000010), 0x1.2000400002p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffdffffef), -0x1.20004000022p+43, 0x0p+0 },
{ INT64_C(0x0000090002000080), 0x1.200040001p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffdffff7f), -0x1.20004000102p+43, 0x0p+0 },
{ INT64_C(0x0000090002000800), 0x1.20004001p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffdfff7ff), -0x1.20004001002p+43, 0x0p+0 },
{ INT64_C(0x0000090002002000), 0x1.20004004p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffdffdfff), -0x1.20004004002p+43, 0x0p+0 },
{ INT64_C(0x0000090002004000), 0x1.20004008p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffdffbfff), -0x1.20004008002p+43, 0x0p+0 },
{ INT64_C(0x0000090002040000), 0x1.2000408p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffdfbffff), -0x1.20004080002p+43, 0x0p+0 },
{ INT64_C(0x0000090002100000), 0x1.200042p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffdefffff), -0x1.20004200002p+43, 0x0p+0 },
{ INT64_C(0x0000090002800000), 0x1.20005p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffd7fffff), -0x1.20005000002p+43, 0x0p+0 },
{ INT64_C(0x0000090004000000), 0x1.20008p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffbffffff), -0x1.20008000002p+43, 0x0p+0 },
{ INT64_C(0x0000090004000004), 0x1.20008000008p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffbfffffb), -0x1.2000800000ap+43, 0x0p+0 },
{ INT64_C(0x0000090004000008), 0x1.2000800001p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffbfffff7), -0x1.20008000012p+43, 0x0p+0 },
{ INT64_C(0x0000090004000080), 0x1.200080001p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffbffff7f), -0x1.20008000102p+43, 0x0p+0 },
{ INT64_C(0x0000090004000800), 0x1.20008001p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffbfff7ff), -0x1.20008001002p+43, 0x0p+0 },
{ INT64_C(0x0000090004004000), 0x1.20008008p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffbffbfff), -0x1.20008008002p+43, 0x0p+0 },
{ INT64_C(0x0000090004008000), 0x1.2000801p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffbff7fff), -0x1.20008010002p+43, 0x0p+0 },
{ INT64_C(0x0000090004020000), 0x1.2000804p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffbfdffff), -0x1.20008040002p+43, 0x0p+0 },
{ INT64_C(0x0000090004040000), 0x1.2000808p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffbfbffff), -0x1.20008080002p+43, 0x0p+0 },
{ INT64_C(0x0000090004080000), 0x1.200081p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffbf7ffff), -0x1.20008100002p+43, 0x0p+0 },
{ INT64_C(0x0000090004100000), 0x1.200082p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffbefffff), -0x1.20008200002p+43, 0x0p+0 },
{ INT64_C(0x0000090004800000), 0x1.20009p+43, 0x0p+0 },
{ INT64_C(0xfffff6fffb7fffff), -0x1.20009000002p+43, 0x0p+0 },
{ INT64_C(0x0000090008000000), 0x1.2001p+43, 0x0p+0 },
{ INT64_C(0xfffff6fff7ffffff), -0x1.20010000002p+43, 0x0p+0 },
{ INT64_C(0x0000090008000004), 0x1.20010000008p+43, 0x0p+0 },
{ INT64_C(0xfffff6fff7fffffb), -0x1.2001000000ap+43, 0x0p+0 },
{ INT64_C(0x0000090008000040), 0x1.2001000008p+43, 0x0p+0 },
{ INT64_C(0xfffff6fff7ffffbf), -0x1.20010000082p+43, 0x0p+0 },
{ INT64_C(0x0000090008000200), 0x1.200100004p+43, 0x0p+0 },
{ INT64_C(0xfffff6fff7fffdff), -0x1.20010000402p+43, 0x0p+0 },
{ INT64_C(0x0000090008002000), 0x1.20010004p+43, 0x0p+0 },
{ INT64_C(0xfffff6fff7ffdfff), -0x1.20010004002p+43, 0x0p+0 },
{ INT64_C(0x0000090008004000), 0x1.20010008p+43, 0x0p+0 },
{ INT64_C(0xfffff6fff7ffbfff), -0x1.20010008002p+43, 0x0p+0 },
{ INT64_C(0x0000090008040000), 0x1.2001008p+43, 0x0p+0 },
{ INT64_C(0xfffff6fff7fbffff), -0x1.20010080002p+43, 0x0p+0 },
{ INT64_C(0x0000090008080000), 0x1.200101p+43, 0x0p+0 },
{ INT64_C(0xfffff6fff7f7ffff), -0x1.20010100002p+43, 0x0p+0 },
{ INT64_C(0x0000090008400000), 0x1.200108p+43, 0x0p+0 },
{ INT64_C(0xfffff6fff7bfffff), -0x1.20010800002p+43, 0x0p+0 },
{ INT64_C(0x000009000a000000), 0x1.20014p+43, 0x0p+0 },
{ INT64_C(0xfffff6fff5ffffff), -0x1.20014000002p+43, 0x0p+0 },
{ INT64_C(0x000009000c000000), 0x1.20018p+43, 0x0p+0 },
{ INT64_C(0xfffff6fff3ffffff), -0x1.20018000002p+43, 0x0p+0 },
{ INT64_C(0x0000090010000000), 0x1.2002p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffefffffff), -0x1.20020000002p+43, 0x0p+0 },
{ INT64_C(0x0000090010000004), 0x1.20020000008p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffeffffffb), -0x1.2002000000ap+43, 0x0p+0 },
{ INT64_C(0x0000090010000040), 0x1.2002000008p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffefffffbf), -0x1.20020000082p+43, 0x0p+0 },
{ INT64_C(0x0000090010000100), 0x1.200200002p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffeffffeff), -0x1.20020000202p+43, 0x0p+0 },
{ INT64_C(0x0000090010000200), 0x1.200200004p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffeffffdff), -0x1.20020000402p+43, 0x0p+0 },
{ INT64_C(0x0000090010001000), 0x1.20020002p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffefffefff), -0x1.20020002002p+43, 0x0p+0 },
{ INT64_C(0x0000090010010000), 0x1.2002002p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffeffeffff), -0x1.20020020002p+43, 0x0p+0 },
{ INT64_C(0x0000090010020000), 0x1.2002004p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffeffdffff), -0x1.20020040002p+43, 0x0p+0 },
{ INT64_C(0x0000090010100000), 0x1.200202p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffefefffff), -0x1.20020200002p+43, 0x0p+0 },
{ INT64_C(0x0000090010400000), 0x1.200208p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffefbfffff), -0x1.20020800002p+43, 0x0p+0 },
{ INT64_C(0x0000090010800000), 0x1.20021p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffef7fffff), -0x1.20021000002p+43, 0x0p+0 },
{ INT64_C(0x0000090014000000), 0x1.20028p+43, 0x0p+0 },
{ INT64_C(0xfffff6ffebffffff), -0x1.20028000002p+43, 0x0p+0 },
{ INT64_C(0x0000090080000000), 0x1.201p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff7fffffff), -0x1.20100000002p+43, 0x0p+0 },
{ INT64_C(0x0000090080000001), 0x1.20100000002p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff7ffffffe), -0x1.20100000004p+43, 0x0p+0 },
{ INT64_C(0x0000090080000002), 0x1.20100000004p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff7ffffffd), -0x1.20100000006p+43, 0x0p+0 },
{ INT64_C(0x0000090080000008), 0x1.2010000001p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff7ffffff7), -0x1.20100000012p+43, 0x0p+0 },
{ INT64_C(0x0000090080000080), 0x1.201000001p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff7fffff7f), -0x1.20100000102p+43, 0x0p+0 },
{ INT64_C(0x0000090080000100), 0x1.201000002p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff7ffffeff), -0x1.20100000202p+43, 0x0p+0 },
{ INT64_C(0x0000090080001000), 0x1.20100002p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff7fffefff), -0x1.20100002002p+43, 0x0p+0 },
{ INT64_C(0x0000090080008000), 0x1.2010001p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff7fff7fff), -0x1.20100010002p+43, 0x0p+0 },
{ INT64_C(0x0000090080040000), 0x1.2010008p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff7ffbffff), -0x1.20100080002p+43, 0x0p+0 },
{ INT64_C(0x0000090080100000), 0x1.201002p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff7fefffff), -0x1.20100200002p+43, 0x0p+0 },
{ INT64_C(0x0000090080400000), 0x1.201008p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff7fbfffff), -0x1.20100800002p+43, 0x0p+0 },
{ INT64_C(0x0000090084000000), 0x1.20108p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff7bffffff), -0x1.20108000002p+43, 0x0p+0 },
{ INT64_C(0x00000900a0000000), 0x1.2014p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff5fffffff), -0x1.20140000002p+43, 0x0p+0 },
{ INT64_C(0x00000900c0000000), 0x1.2018p+43, 0x0p+0 },
{ INT64_C(0xfffff6ff3fffffff), -0x1.20180000002p+43, 0x0p+0 },
{ INT64_C(0x0000090800000000), 0x1.21p+43, 0x0p+0 },
{ INT64_C(0xfffff6f7ffffffff), -0x1.21000000002p+43, 0x0p+0 },
{ INT64_C(0x0000090800000004), 0x1.21000000008p+43, 0x0p+0 },
{ INT64_C(0xfffff6f7fffffffb), -0x1.2100000000ap+43, 0x0p+0 },
{ INT64_C(0x0000090800000020), 0x1.2100000004p+43, 0x0p+0 },
{ INT64_C(0xfffff6f7ffffffdf), -0x1.21000000042p+43, 0x0p+0 },
{ INT64_C(0x0000090800000100), 0x1.210000002p+43, 0x0p+0 },
{ INT64_C(0xfffff6f7fffffeff), -0x1.21000000202p+43, 0x0p+0 },
{ INT64_C(0x0000090800001000), 0x1.21000002p+43, 0x0p+0 },
{ INT64_C(0xfffff6f7ffffefff), -0x1.21000002002p+43, 0x0p+0 },
{ INT64_C(0x0000090800010000), 0x1.2100002p+43, 0x0p+0 },
{ INT64_C(0xfffff6f7fffeffff), -0x1.21000020002p+43, 0x0p+0 },
{ INT64_C(0x0000090800040000), 0x1.2100008p+43, 0x0p+0 },
{ INT64_C(0xfffff6f7fffbffff), -0x1.21000080002p+43, 0x0p+0 },
{ INT64_C(0x0000090800100000), 0x1.210002p+43, 0x0p+0 },
{ INT64_C(0xfffff6f7ffefffff), -0x1.21000200002p+43, 0x0p+0 },
{ INT64_C(0x0000090800400000), 0x1.210008p+43, 0x0p+0 },
{ INT64_C(0xfffff6f7ffbfffff), -0x1.21000800002p+43, 0x0p+0 },
{ INT64_C(0x0000090800800000), 0x1.21001p+43, 0x0p+0 },
{ INT64_C(0xfffff6f7ff7fffff), -0x1.21001000002p+43, 0x0p+0 },
{ INT64_C(0x0000090804000000), 0x1.21008p+43, 0x0p+0 },
{ INT64_C(0xfffff6f7fbffffff), -0x1.21008000002p+43, 0x0p+0 },
{ INT64_C(0x0000090820000000), 0x1.2104p+43, 0x0p+0 },
{ INT64_C(0xfffff6f7dfffffff), -0x1.21040000002p+43, 0x0p+0 },
{ INT64_C(0x0000090900000000), 0x1.212p+43, 0x0p+0 },
{ INT64_C(0xfffff6f6ffffffff), -0x1.21200000002p+43, 0x0p+0 },
{ INT64_C(0x0000090c00000000), 0x1.218p+43, 0x0p+0 },
{ INT64_C(0xfffff6f3ffffffff), -0x1.21800000002p+43, 0x0p+0 },
{ INT64_C(0x0000092000000000), 0x1.24p+43, 0x0p+0 },
{ INT64_C(0xfffff6dfffffffff), -0x1.24000000002p+43, 0x0p+0 },
{ INT64_C(0x0000092000000001), 0x1.24000000002p+43, 0x0p+0 },
{ INT64_C(0xfffff6dffffffffe), -0x1.24000000004p+43, 0x0p+0 },
{ INT64_C(0x0000092000000004), 0x1.24000000008p+43, 0x0p+0 },
{ INT64_C(0xfffff6dffffffffb), -0x1.2400000000ap+43, 0x0p+0 },
{ INT64_C(0x0000092000000040), 0x1.2400000008p+43, 0x0p+0 },
{ INT64_C(0xfffff6dfffffffbf), -0x1.24000000082p+43, 0x0p+0 },
{ INT64_C(0x0000092000000100), 0x1.240000002p+43, 0x0p+0 },
{ INT64_C(0xfffff6dffffffeff), -0x1.24000000202p+43, 0x0p+0 },
{ INT64_C(0x0000092000000800), 0x1.24000001p+43, 0x0p+0 },
{ INT64_C(0xfffff6dffffff7ff), -0x1.24000001002p+43, 0x0p+0 },
{ INT64_C(0x0000092000001000), 0x1.24000002p+43, 0x0p+0 },
{ INT64_C(0xfffff6dfffffefff), -0x1.24000002002p+43, 0x0p+0 },
{ INT64_C(0x0000092000002000), 0x1.24000004p+43, 0x0p+0 },
{ INT64_C(0xfffff6dfffffdfff), -0x1.24000004002p+43, 0x0p+0 },
{ INT64_C(0x0000092000020000), 0x1.2400004p+43, 0x0p+0 },
{ INT64_C(0xfffff6dffffdffff), -0x1.24000040002p+43, 0x0p+0 },
{ INT64_C(0x0000092000080000), 0x1.240001p+43, 0x0p+0 },
{ INT64_C(0xfffff6dffff7ffff), -0x1.24000100002p+43, 0x0p+0 },
{ INT64_C(0x0000092000200000), 0x1.240004p+43, 0x0p+0 },
{ INT64_C(0xfffff6dfffdfffff), -0x1.24000400002p+43, 0x0p+0 },
{ INT64_C(0x0000092002000000), 0x1.24004p+43, 0x0p+0 },
{ INT64_C(0xfffff6dffdffffff), -0x1.24004000002p+43, 0x0p+0 },
{ INT64_C(0x0000092020000000), 0x1.2404p+43, 0x0p+0 },
{ INT64_C(0xfffff6dfdfffffff), -0x1.24040000002p+43, 0x0p+0 },
{ INT64_C(0x0000092040000000), 0x1.2408p+43, 0x0p+0 },
{ INT64_C(0xfffff6dfbfffffff), -0x1.24080000002p+43, 0x0p+0 },
{ INT64_C(0x0000092080000000), 0x1.241p+43, 0x0p+0 },
{ INT64_C(0xfffff6df7fffffff), -0x1.24100000002p+43, 0x0p+0 },
{ INT64_C(0x0000092100000000), 0x1.242p+43, 0x0p+0 },
{ INT64_C(0xfffff6deffffffff), -0x1.24200000002p+43, 0x0p+0 },
{ INT64_C(0x0000092800000000), 0x1.25p+43, 0x0p+0 },
{ INT64_C(0xfffff6d7ffffffff), -0x1.25000000002p+43, 0x0p+0 },
{ INT64_C(0x0000100000000003), 0x1.00000000003p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffffffc), -0x1.00000000004p+44, 0x0p+0 },
{ INT64_C(0x0000100000000028), 0x1.00000000028p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffffd7), -0x1.00000000029p+44, 0x0p+0 },
{ INT64_C(0x0000100000000029), 0x1.00000000029p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffffd6), -0x1.0000000002ap+44, 0x0p+0 },
{ INT64_C(0x0000100000000030), 0x1.0000000003p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffffcf), -0x1.00000000031p+44, 0x0p+0 },
{ INT64_C(0x0000100000000034), 0x1.00000000034p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffffcb), -0x1.00000000035p+44, 0x0p+0 },
{ INT64_C(0x0000100000000038), 0x1.00000000038p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffffc7), -0x1.00000000039p+44, 0x0p+0 },
{ INT64_C(0x0000100000000041), 0x1.00000000041p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffffbe), -0x1.00000000042p+44, 0x0p+0 },
{ INT64_C(0x0000100000000050), 0x1.0000000005p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffffaf), -0x1.00000000051p+44, 0x0p+0 },
{ INT64_C(0x0000100000000058), 0x1.00000000058p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffffa7), -0x1.00000000059p+44, 0x0p+0 },
{ INT64_C(0x0000100000000408), 0x1.00000000408p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffffbf7), -0x1.00000000409p+44, 0x0p+0 },
{ INT64_C(0x000010000000040a), 0x1.0000000040ap+44, 0x0p+0 },
{ INT64_C(0xffffeffffffffbf5), -0x1.0000000040bp+44, 0x0p+0 },
{ INT64_C(0x0000100000000410), 0x1.0000000041p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffffbef), -0x1.00000000411p+44, 0x0p+0 },
{ INT64_C(0x0000100000000414), 0x1.00000000414p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffffbeb), -0x1.00000000415p+44, 0x0p+0 },
{ INT64_C(0x0000100000000418), 0x1.00000000418p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffffbe7), -0x1.00000000419p+44, 0x0p+0 },
{ INT64_C(0x0000100000000480), 0x1.0000000048p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffffb7f), -0x1.00000000481p+44, 0x0p+0 },
{ INT64_C(0x0000100000000484), 0x1.00000000484p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffffb7b), -0x1.00000000485p+44, 0x0p+0 },
{ INT64_C(0x0000100000000488), 0x1.00000000488p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffffb77), -0x1.00000000489p+44, 0x0p+0 },
{ INT64_C(0x0000100000004002), 0x1.00000004002p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbffd), -0x1.00000004003p+44, 0x0p+0 },
{ INT64_C(0x0000100000004010), 0x1.0000000401p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbfef), -0x1.00000004011p+44, 0x0p+0 },
{ INT64_C(0x0000100000004012), 0x1.00000004012p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbfed), -0x1.00000004013p+44, 0x0p+0 },
{ INT64_C(0x0000100000004040), 0x1.0000000404p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbfbf), -0x1.00000004041p+44, 0x0p+0 },
{ INT64_C(0x0000100000004042), 0x1.00000004042p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbfbd), -0x1.00000004043p+44, 0x0p+0 },
{ INT64_C(0x0000100000004048), 0x1.00000004048p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbfb7), -0x1.00000004049p+44, 0x0p+0 },
{ INT64_C(0x0000100000004060), 0x1.0000000406p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbf9f), -0x1.00000004061p+44, 0x0p+0 },
{ INT64_C(0x0000100000004100), 0x1.000000041p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbeff), -0x1.00000004101p+44, 0x0p+0 },
{ INT64_C(0x0000100000004101), 0x1.00000004101p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbefe), -0x1.00000004102p+44, 0x0p+0 },
{ INT64_C(0x0000100000004110), 0x1.0000000411p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbeef), -0x1.00000004111p+44, 0x0p+0 },
{ INT64_C(0x0000100000004180), 0x1.0000000418p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbe7f), -0x1.00000004181p+44, 0x0p+0 },
{ INT64_C(0x0000100000004400), 0x1.000000044p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbbff), -0x1.00000004401p+44, 0x0p+0 },
{ INT64_C(0x0000100000004401), 0x1.00000004401p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbbfe), -0x1.00000004402p+44, 0x0p+0 },
{ INT64_C(0x0000100000004404), 0x1.00000004404p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbbfb), -0x1.00000004405p+44, 0x0p+0 },
{ INT64_C(0x0000100000004410), 0x1.0000000441p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbbef), -0x1.00000004411p+44, 0x0p+0 },
{ INT64_C(0x0000100000004480), 0x1.0000000448p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffbb7f), -0x1.00000004481p+44, 0x0p+0 },
{ INT64_C(0x0000100000004800), 0x1.000000048p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffb7ff), -0x1.00000004801p+44, 0x0p+0 },
{ INT64_C(0x0000100000004802), 0x1.00000004802p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffb7fd), -0x1.00000004803p+44, 0x0p+0 },
{ INT64_C(0x0000100000004808), 0x1.00000004808p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffb7f7), -0x1.00000004809p+44, 0x0p+0 },
{ INT64_C(0x0000100000004820), 0x1.0000000482p+44, 0x0p+0 },
{ INT64_C(0xffffefffffffb7df), -0x1.00000004821p+44, 0x0p+0 },
{ INT64_C(0x0000100000004a00), 0x1.00000004ap+44, 0x0p+0 },
{ INT64_C(0xffffefffffffb5ff), -0x1.00000004a01p+44, 0x0p+0 },
{ INT64_C(0x0000100000006000), 0x1.00000006p+44, 0x0p+0 },
{ INT64_C(0xffffefffffff9fff), -0x1.00000006001p+44, 0x0p+0 },
{ INT64_C(0x0000100000006001), 0x1.00000006001p+44, 0x0p+0 },
{ INT64_C(0xffffefffffff9ffe), -0x1.00000006002p+44, 0x0p+0 },
{ INT64_C(0x0000100000006002), 0x1.00000006002p+44, 0x0p+0 },
{ INT64_C(0xffffefffffff9ffd), -0x1.00000006003p+44, 0x0p+0 },
{ INT64_C(0x0000100000006020), 0x1.0000000602p+44, 0x0p+0 },
{ INT64_C(0xffffefffffff9fdf), -0x1.00000006021p+44, 0x0p+0 },
{ INT64_C(0x0000100000006100), 0x1.000000061p+44, 0x0p+0 },
{ INT64_C(0xffffefffffff9eff), -0x1.00000006101p+44, 0x0p+0 },
{ INT64_C(0x0000100000006400), 0x1.000000064p+44, 0x0p+0 },
{ INT64_C(0xffffefffffff9bff), -0x1.00000006401p+44, 0x0p+0 },
{ INT64_C(0x0000100000040001), 0x1.00000040001p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbfffe), -0x1.00000040002p+44, 0x0p+0 },
{ INT64_C(0x0000100000040010), 0x1.0000004001p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbffef), -0x1.00000040011p+44, 0x0p+0 },
{ INT64_C(0x0000100000040011), 0x1.00000040011p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbffee), -0x1.00000040012p+44, 0x0p+0 },
{ INT64_C(0x0000100000040018), 0x1.00000040018p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbffe7), -0x1.00000040019p+44, 0x0p+0 },
{ INT64_C(0x0000100000040100), 0x1.000000401p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbfeff), -0x1.00000040101p+44, 0x0p+0 },
{ INT64_C(0x0000100000040108), 0x1.00000040108p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbfef7), -0x1.00000040109p+44, 0x0p+0 },
{ INT64_C(0x0000100000040180), 0x1.0000004018p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbfe7f), -0x1.00000040181p+44, 0x0p+0 },
{ INT64_C(0x0000100000040200), 0x1.000000402p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbfdff), -0x1.00000040201p+44, 0x0p+0 },
{ INT64_C(0x0000100000040208), 0x1.00000040208p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbfdf7), -0x1.00000040209p+44, 0x0p+0 },
{ INT64_C(0x0000100000040240), 0x1.0000004024p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbfdbf), -0x1.00000040241p+44, 0x0p+0 },
{ INT64_C(0x0000100000040300), 0x1.000000403p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbfcff), -0x1.00000040301p+44, 0x0p+0 },
{ INT64_C(0x0000100000041000), 0x1.00000041p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbefff), -0x1.00000041001p+44, 0x0p+0 },
{ INT64_C(0x0000100000041001), 0x1.00000041001p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbeffe), -0x1.00000041002p+44, 0x0p+0 },
{ INT64_C(0x0000100000041002), 0x1.00000041002p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbeffd), -0x1.00000041003p+44, 0x0p+0 },
{ INT64_C(0x0000100000041020), 0x1.0000004102p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbefdf), -0x1.00000041021p+44, 0x0p+0 },
{ INT64_C(0x0000100000041080), 0x1.0000004108p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbef7f), -0x1.00000041081p+44, 0x0p+0 },
{ INT64_C(0x0000100000041200), 0x1.000000412p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbedff), -0x1.00000041201p+44, 0x0p+0 },
{ INT64_C(0x0000100000042000), 0x1.00000042p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbdfff), -0x1.00000042001p+44, 0x0p+0 },
{ INT64_C(0x0000100000042001), 0x1.00000042001p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbdffe), -0x1.00000042002p+44, 0x0p+0 },
{ INT64_C(0x0000100000042010), 0x1.0000004201p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbdfef), -0x1.00000042011p+44, 0x0p+0 },
{ INT64_C(0x0000100000042040), 0x1.0000004204p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbdfbf), -0x1.00000042041p+44, 0x0p+0 },
{ INT64_C(0x0000100000042400), 0x1.000000424p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffbdbff), -0x1.00000042401p+44, 0x0p+0 },
{ INT64_C(0x0000100000048000), 0x1.00000048p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffb7fff), -0x1.00000048001p+44, 0x0p+0 },
{ INT64_C(0x0000100000048008), 0x1.00000048008p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffb7ff7), -0x1.00000048009p+44, 0x0p+0 },
{ INT64_C(0x0000100000048040), 0x1.0000004804p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffb7fbf), -0x1.00000048041p+44, 0x0p+0 },
{ INT64_C(0x0000100000048080), 0x1.0000004808p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffb7f7f), -0x1.00000048081p+44, 0x0p+0 },
{ INT64_C(0x0000100000048800), 0x1.000000488p+44, 0x0p+0 },
{ INT64_C(0xffffeffffffb77ff), -0x1.00000048801p+44, 0x0p+0 },
{ INT64_C(0x0000100000080001), 0x1.00000080001p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7fffe), -0x1.00000080002p+44, 0x0p+0 },
{ INT64_C(0x0000100000080010), 0x1.0000008001p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7ffef), -0x1.00000080011p+44, 0x0p+0 },
{ INT64_C(0x0000100000080018), 0x1.00000080018p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7ffe7), -0x1.00000080019p+44, 0x0p+0 },
{ INT64_C(0x0000100000080020), 0x1.0000008002p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7ffdf), -0x1.00000080021p+44, 0x0p+0 },
{ INT64_C(0x0000100000080022), 0x1.00000080022p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7ffdd), -0x1.00000080023p+44, 0x0p+0 },
{ INT64_C(0x0000100000080028), 0x1.00000080028p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7ffd7), -0x1.00000080029p+44, 0x0p+0 },
{ INT64_C(0x0000100000080200), 0x1.000000802p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7fdff), -0x1.00000080201p+44, 0x0p+0 },
{ INT64_C(0x0000100000080208), 0x1.00000080208p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7fdf7), -0x1.00000080209p+44, 0x0p+0 },
{ INT64_C(0x0000100000080220), 0x1.0000008022p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7fddf), -0x1.00000080221p+44, 0x0p+0 },
{ INT64_C(0x0000100000080300), 0x1.000000803p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7fcff), -0x1.00000080301p+44, 0x0p+0 },
{ INT64_C(0x0000100000082000), 0x1.00000082p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7dfff), -0x1.00000082001p+44, 0x0p+0 },
{ INT64_C(0x0000100000082004), 0x1.00000082004p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7dffb), -0x1.00000082005p+44, 0x0p+0 },
{ INT64_C(0x0000100000082020), 0x1.0000008202p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7dfdf), -0x1.00000082021p+44, 0x0p+0 },
{ INT64_C(0x0000100000082040), 0x1.0000008204p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7dfbf), -0x1.00000082041p+44, 0x0p+0 },
{ INT64_C(0x0000100000082080), 0x1.0000008208p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7df7f), -0x1.00000082081p+44, 0x0p+0 },
{ INT64_C(0x0000100000082400), 0x1.000000824p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff7dbff), -0x1.00000082401p+44, 0x0p+0 },
{ INT64_C(0x0000100000088000), 0x1.00000088p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff77fff), -0x1.00000088001p+44, 0x0p+0 },
{ INT64_C(0x0000100000088004), 0x1.00000088004p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff77ffb), -0x1.00000088005p+44, 0x0p+0 },
{ INT64_C(0x0000100000088010), 0x1.0000008801p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff77fef), -0x1.00000088011p+44, 0x0p+0 },
{ INT64_C(0x0000100000088020), 0x1.0000008802p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff77fdf), -0x1.00000088021p+44, 0x0p+0 },
{ INT64_C(0x0000100000088200), 0x1.000000882p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff77dff), -0x1.00000088201p+44, 0x0p+0 },
{ INT64_C(0x0000100000088400), 0x1.000000884p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff77bff), -0x1.00000088401p+44, 0x0p+0 },
{ INT64_C(0x000010000008a000), 0x1.0000008ap+44, 0x0p+0 },
{ INT64_C(0xffffeffffff75fff), -0x1.0000008a001p+44, 0x0p+0 },
{ INT64_C(0x00001000000a0000), 0x1.000000ap+44, 0x0p+0 },
{ INT64_C(0xffffeffffff5ffff), -0x1.000000a0001p+44, 0x0p+0 },
{ INT64_C(0x00001000000a0002), 0x1.000000a0002p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff5fffd), -0x1.000000a0003p+44, 0x0p+0 },
{ INT64_C(0x00001000000a0004), 0x1.000000a0004p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff5fffb), -0x1.000000a0005p+44, 0x0p+0 },
{ INT64_C(0x00001000000a0020), 0x1.000000a002p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff5ffdf), -0x1.000000a0021p+44, 0x0p+0 },
{ INT64_C(0x00001000000a0100), 0x1.000000a01p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff5feff), -0x1.000000a0101p+44, 0x0p+0 },
{ INT64_C(0x00001000000a0800), 0x1.000000a08p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff5f7ff), -0x1.000000a0801p+44, 0x0p+0 },
{ INT64_C(0x00001000000a4000), 0x1.000000a4p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff5bfff), -0x1.000000a4001p+44, 0x0p+0 },
{ INT64_C(0x00001000000c0000), 0x1.000000cp+44, 0x0p+0 },
{ INT64_C(0xffffeffffff3ffff), -0x1.000000c0001p+44, 0x0p+0 },
{ INT64_C(0x00001000000c0008), 0x1.000000c0008p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff3fff7), -0x1.000000c0009p+44, 0x0p+0 },
{ INT64_C(0x00001000000c0020), 0x1.000000c002p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff3ffdf), -0x1.000000c0021p+44, 0x0p+0 },
{ INT64_C(0x00001000000c0100), 0x1.000000c01p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff3feff), -0x1.000000c0101p+44, 0x0p+0 },
{ INT64_C(0x00001000000c1000), 0x1.000000c1p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff3efff), -0x1.000000c1001p+44, 0x0p+0 },
{ INT64_C(0x00001000000c4000), 0x1.000000c4p+44, 0x0p+0 },
{ INT64_C(0xffffeffffff3bfff), -0x1.000000c4001p+44, 0x0p+0 },
{ INT64_C(0x00001000000d0000), 0x1.000000dp+44, 0x0p+0 },
{ INT64_C(0xffffeffffff2ffff), -0x1.000000d0001p+44, 0x0p+0 },
{ INT64_C(0x00001000000e0000), 0x1.000000ep+44, 0x0p+0 },
{ INT64_C(0xffffeffffff1ffff), -0x1.000000e0001p+44, 0x0p+0 },
{ INT64_C(0x0000100000400008), 0x1.00000400008p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbffff7), -0x1.00000400009p+44, 0x0p+0 },
{ INT64_C(0x000010000040000c), 0x1.0000040000cp+44, 0x0p+0 },
{ INT64_C(0xffffefffffbffff3), -0x1.0000040000dp+44, 0x0p+0 },
{ INT64_C(0x0000100000400010), 0x1.0000040001p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbfffef), -0x1.00000400011p+44, 0x0p+0 },
{ INT64_C(0x0000100000400018), 0x1.00000400018p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbfffe7), -0x1.00000400019p+44, 0x0p+0 },
{ INT64_C(0x0000100000400080), 0x1.0000040008p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbfff7f), -0x1.00000400081p+44, 0x0p+0 },
{ INT64_C(0x0000100000400084), 0x1.00000400084p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbfff7b), -0x1.00000400085p+44, 0x0p+0 },
{ INT64_C(0x00001000004000a0), 0x1.000004000ap+44, 0x0p+0 },
{ INT64_C(0xffffefffffbfff5f), -0x1.000004000a1p+44, 0x0p+0 },
{ INT64_C(0x0000100000400400), 0x1.000004004p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbffbff), -0x1.00000400401p+44, 0x0p+0 },
{ INT64_C(0x0000100000400401), 0x1.00000400401p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbffbfe), -0x1.00000400402p+44, 0x0p+0 },
{ INT64_C(0x0000100000400404), 0x1.00000400404p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbffbfb), -0x1.00000400405p+44, 0x0p+0 },
{ INT64_C(0x0000100000400440), 0x1.0000040044p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbffbbf), -0x1.00000400441p+44, 0x0p+0 },
{ INT64_C(0x0000100000404000), 0x1.00000404p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbfbfff), -0x1.00000404001p+44, 0x0p+0 },
{ INT64_C(0x0000100000404004), 0x1.00000404004p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbfbffb), -0x1.00000404005p+44, 0x0p+0 },
{ INT64_C(0x0000100000404010), 0x1.0000040401p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbfbfef), -0x1.00000404011p+44, 0x0p+0 },
{ INT64_C(0x0000100000404100), 0x1.000004041p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbfbeff), -0x1.00000404101p+44, 0x0p+0 },
{ INT64_C(0x0000100000404200), 0x1.000004042p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbfbdff), -0x1.00000404201p+44, 0x0p+0 },
{ INT64_C(0x0000100000404400), 0x1.000004044p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbfbbff), -0x1.00000404401p+44, 0x0p+0 },
{ INT64_C(0x0000100000405000), 0x1.00000405p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbfafff), -0x1.00000405001p+44, 0x0p+0 },
{ INT64_C(0x0000100000408000), 0x1.00000408p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbf7fff), -0x1.00000408001p+44, 0x0p+0 },
{ INT64_C(0x0000100000408008), 0x1.00000408008p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbf7ff7), -0x1.00000408009p+44, 0x0p+0 },
{ INT64_C(0x0000100000408040), 0x1.0000040804p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbf7fbf), -0x1.00000408041p+44, 0x0p+0 },
{ INT64_C(0x0000100000408080), 0x1.0000040808p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbf7f7f), -0x1.00000408081p+44, 0x0p+0 },
{ INT64_C(0x0000100000408100), 0x1.000004081p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbf7eff), -0x1.00000408101p+44, 0x0p+0 },
{ INT64_C(0x0000100000408400), 0x1.000004084p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbf7bff), -0x1.00000408401p+44, 0x0p+0 },
{ INT64_C(0x000010000040c000), 0x1.0000040cp+44, 0x0p+0 },
{ INT64_C(0xffffefffffbf3fff), -0x1.0000040c001p+44, 0x0p+0 },
{ INT64_C(0x0000100000410000), 0x1.0000041p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbeffff), -0x1.00000410001p+44, 0x0p+0 },
{ INT64_C(0x0000100000410002), 0x1.00000410002p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbefffd), -0x1.00000410003p+44, 0x0p+0 },
{ INT64_C(0x0000100000410020), 0x1.0000041002p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbeffdf), -0x1.00000410021p+44, 0x0p+0 },
{ INT64_C(0x0000100000410100), 0x1.000004101p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbefeff), -0x1.00000410101p+44, 0x0p+0 },
{ INT64_C(0x0000100000410800), 0x1.000004108p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbef7ff), -0x1.00000410801p+44, 0x0p+0 },
{ INT64_C(0x0000100000411000), 0x1.00000411p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbeefff), -0x1.00000411001p+44, 0x0p+0 },
{ INT64_C(0x0000100000418000), 0x1.00000418p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbe7fff), -0x1.00000418001p+44, 0x0p+0 },
{ INT64_C(0x0000100000440000), 0x1.0000044p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbbffff), -0x1.00000440001p+44, 0x0p+0 },
{ INT64_C(0x0000100000440004), 0x1.00000440004p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbbfffb), -0x1.00000440005p+44, 0x0p+0 },
{ INT64_C(0x0000100000440008), 0x1.00000440008p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbbfff7), -0x1.00000440009p+44, 0x0p+0 },
{ INT64_C(0x0000100000440010), 0x1.0000044001p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbbffef), -0x1.00000440011p+44, 0x0p+0 },
{ INT64_C(0x0000100000440020), 0x1.0000044002p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbbffdf), -0x1.00000440021p+44, 0x0p+0 },
{ INT64_C(0x0000100000440200), 0x1.000004402p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbbfdff), -0x1.00000440201p+44, 0x0p+0 },
{ INT64_C(0x0000100000440400), 0x1.000004404p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbbfbff), -0x1.00000440401p+44, 0x0p+0 },
{ INT64_C(0x0000100000441000), 0x1.00000441p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbbefff), -0x1.00000441001p+44, 0x0p+0 },
{ INT64_C(0x0000100000444000), 0x1.00000444p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbbbfff), -0x1.00000444001p+44, 0x0p+0 },
{ INT64_C(0x0000100000448000), 0x1.00000448p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbb7fff), -0x1.00000448001p+44, 0x0p+0 },
{ INT64_C(0x0000100000450000), 0x1.0000045p+44, 0x0p+0 },
{ INT64_C(0xffffefffffbaffff), -0x1.00000450001p+44, 0x0p+0 },
{ INT64_C(0x0000100000480000), 0x1.0000048p+44, 0x0p+0 },
{ INT64_C(0xffffefffffb7ffff), -0x1.00000480001p+44, 0x0p+0 },
{ INT64_C(0x0000100000480002), 0x1.00000480002p+44, 0x0p+0 },
{ INT64_C(0xffffefffffb7fffd), -0x1.00000480003p+44, 0x0p+0 },
{ INT64_C(0x0000100000480008), 0x1.00000480008p+44, 0x0p+0 },
{ INT64_C(0xffffefffffb7fff7), -0x1.00000480009p+44, 0x0p+0 },
{ INT64_C(0x0000100000480020), 0x1.0000048002p+44, 0x0p+0 },
{ INT64_C(0xffffefffffb7ffdf), -0x1.00000480021p+44, 0x0p+0 },
{ INT64_C(0x0000100000480200), 0x1.000004802p+44, 0x0p+0 },
{ INT64_C(0xffffefffffb7fdff), -0x1.00000480201p+44, 0x0p+0 },
{ INT64_C(0x0000100000481000), 0x1.00000481p+44, 0x0p+0 },
{ INT64_C(0xffffefffffb7efff), -0x1.00000481001p+44, 0x0p+0 },
{ INT64_C(0x0000100000484000), 0x1.00000484p+44, 0x0p+0 },
{ INT64_C(0xffffefffffb7bfff), -0x1.00000484001p+44, 0x0p+0 },
{ INT64_C(0x00001000004a0000), 0x1.000004ap+44, 0x0p+0 },
{ INT64_C(0xffffefffffb5ffff), -0x1.000004a0001p+44, 0x0p+0 },
{ INT64_C(0x0000100000500000), 0x1.000005p+44, 0x0p+0 },
{ INT64_C(0xffffefffffafffff), -0x1.00000500001p+44, 0x0p+0 },
{ INT64_C(0x0000100000500008), 0x1.00000500008p+44, 0x0p+0 },
{ INT64_C(0xffffefffffaffff7), -0x1.00000500009p+44, 0x0p+0 },
{ INT64_C(0x0000100000500020), 0x1.0000050002p+44, 0x0p+0 },
{ INT64_C(0xffffefffffafffdf), -0x1.00000500021p+44, 0x0p+0 },
{ INT64_C(0x0000100000500080), 0x1.0000050008p+44, 0x0p+0 },
{ INT64_C(0xffffefffffafff7f), -0x1.00000500081p+44, 0x0p+0 },
{ INT64_C(0x0000100000500800), 0x1.000005008p+44, 0x0p+0 },
{ INT64_C(0xffffefffffaff7ff), -0x1.00000500801p+44, 0x0p+0 },
{ INT64_C(0x0000100000502000), 0x1.00000502p+44, 0x0p+0 },
{ INT64_C(0xffffefffffafdfff), -0x1.00000502001p+44, 0x0p+0 },
{ INT64_C(0x0000100000520000), 0x1.0000052p+44, 0x0p+0 },
{ INT64_C(0xffffefffffadffff), -0x1.00000520001p+44, 0x0p+0 },
{ INT64_C(0x0000100004000002), 0x1.00004000002p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfffffd), -0x1.00004000003p+44, 0x0p+0 },
{ INT64_C(0x0000100004000008), 0x1.00004000008p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfffff7), -0x1.00004000009p+44, 0x0p+0 },
{ INT64_C(0x0000100004000040), 0x1.0000400004p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffffbf), -0x1.00004000041p+44, 0x0p+0 },
{ INT64_C(0x0000100004000041), 0x1.00004000041p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffffbe), -0x1.00004000042p+44, 0x0p+0 },
{ INT64_C(0x0000100004000050), 0x1.0000400005p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffffaf), -0x1.00004000051p+44, 0x0p+0 },
{ INT64_C(0x0000100004000060), 0x1.0000400006p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffff9f), -0x1.00004000061p+44, 0x0p+0 },
{ INT64_C(0x0000100004000200), 0x1.000040002p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfffdff), -0x1.00004000201p+44, 0x0p+0 },
{ INT64_C(0x0000100004000202), 0x1.00004000202p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfffdfd), -0x1.00004000203p+44, 0x0p+0 },
{ INT64_C(0x0000100004000220), 0x1.0000400022p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfffddf), -0x1.00004000221p+44, 0x0p+0 },
{ INT64_C(0x0000100004001000), 0x1.00004001p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffefff), -0x1.00004001001p+44, 0x0p+0 },
{ INT64_C(0x0000100004001002), 0x1.00004001002p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffeffd), -0x1.00004001003p+44, 0x0p+0 },
{ INT64_C(0x0000100004001004), 0x1.00004001004p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffeffb), -0x1.00004001005p+44, 0x0p+0 },
{ INT64_C(0x0000100004001008), 0x1.00004001008p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffeff7), -0x1.00004001009p+44, 0x0p+0 },
{ INT64_C(0x0000100004001040), 0x1.0000400104p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffefbf), -0x1.00004001041p+44, 0x0p+0 },
{ INT64_C(0x0000100004001080), 0x1.0000400108p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffef7f), -0x1.00004001081p+44, 0x0p+0 },
{ INT64_C(0x0000100004001400), 0x1.000040014p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffebff), -0x1.00004001401p+44, 0x0p+0 },
{ INT64_C(0x0000100004001800), 0x1.000040018p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffe7ff), -0x1.00004001801p+44, 0x0p+0 },
{ INT64_C(0x0000100004004000), 0x1.00004004p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffbfff), -0x1.00004004001p+44, 0x0p+0 },
{ INT64_C(0x0000100004004001), 0x1.00004004001p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffbffe), -0x1.00004004002p+44, 0x0p+0 },
{ INT64_C(0x0000100004004004), 0x1.00004004004p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffbffb), -0x1.00004004005p+44, 0x0p+0 },
{ INT64_C(0x0000100004004040), 0x1.0000400404p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffbfbf), -0x1.00004004041p+44, 0x0p+0 },
{ INT64_C(0x0000100004004400), 0x1.000040044p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffbbff), -0x1.00004004401p+44, 0x0p+0 },
{ INT64_C(0x0000100004004800), 0x1.000040048p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbffb7ff), -0x1.00004004801p+44, 0x0p+0 },
{ INT64_C(0x0000100004020000), 0x1.0000402p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfdffff), -0x1.00004020001p+44, 0x0p+0 },
{ INT64_C(0x0000100004020004), 0x1.00004020004p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfdfffb), -0x1.00004020005p+44, 0x0p+0 },
{ INT64_C(0x0000100004020020), 0x1.0000402002p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfdffdf), -0x1.00004020021p+44, 0x0p+0 },
{ INT64_C(0x0000100004020080), 0x1.0000402008p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfdff7f), -0x1.00004020081p+44, 0x0p+0 },
{ INT64_C(0x0000100004020400), 0x1.000040204p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfdfbff), -0x1.00004020401p+44, 0x0p+0 },
{ INT64_C(0x0000100004022000), 0x1.00004022p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfddfff), -0x1.00004022001p+44, 0x0p+0 },
{ INT64_C(0x0000100004024000), 0x1.00004024p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfdbfff), -0x1.00004024001p+44, 0x0p+0 },
{ INT64_C(0x0000100004028000), 0x1.00004028p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbfd7fff), -0x1.00004028001p+44, 0x0p+0 },
{ INT64_C(0x0000100004080000), 0x1.0000408p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbf7ffff), -0x1.00004080001p+44, 0x0p+0 },
{ INT64_C(0x0000100004080008), 0x1.00004080008p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbf7fff7), -0x1.00004080009p+44, 0x0p+0 },
{ INT64_C(0x0000100004080020), 0x1.0000408002p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbf7ffdf), -0x1.00004080021p+44, 0x0p+0 },
{ INT64_C(0x0000100004080040), 0x1.0000408004p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbf7ffbf), -0x1.00004080041p+44, 0x0p+0 },
{ INT64_C(0x0000100004080400), 0x1.000040804p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbf7fbff), -0x1.00004080401p+44, 0x0p+0 },
{ INT64_C(0x0000100004080800), 0x1.000040808p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbf7f7ff), -0x1.00004080801p+44, 0x0p+0 },
{ INT64_C(0x0000100004084000), 0x1.00004084p+44, 0x0p+0 },
{ INT64_C(0xffffeffffbf7bfff), -0x1.00004084001p+44, 0x0p+0 },
{ INT64_C(0x00001000040c0000), 0x1.000040cp+44, 0x0p+0 },
{ INT64_C(0xffffeffffbf3ffff), -0x1.000040c0001p+44, 0x0p+0 },
{ INT64_C(0x0000100004800000), 0x1.000048p+44, 0x0p+0 },
{ INT64_C(0xffffeffffb7fffff), -0x1.00004800001p+44, 0x0p+0 },
{ INT64_C(0x0000100004800008), 0x1.00004800008p+44, 0x0p+0 },
{ INT64_C(0xffffeffffb7ffff7), -0x1.00004800009p+44, 0x0p+0 },
{ INT64_C(0x0000100004800040), 0x1.0000480004p+44, 0x0p+0 },
{ INT64_C(0xffffeffffb7fffbf), -0x1.00004800041p+44, 0x0p+0 },
{ INT64_C(0x0000100004800100), 0x1.000048001p+44, 0x0p+0 },
{ INT64_C(0xffffeffffb7ffeff), -0x1.00004800101p+44, 0x0p+0 },
{ INT64_C(0x0000100004800400), 0x1.000048004p+44, 0x0p+0 },
{ INT64_C(0xffffeffffb7ffbff), -0x1.00004800401p+44, 0x0p+0 },
{ INT64_C(0x0000100004802000), 0x1.00004802p+44, 0x0p+0 },
{ INT64_C(0xffffeffffb7fdfff), -0x1.00004802001p+44, 0x0p+0 },
{ INT64_C(0x0000100004808000), 0x1.00004808p+44, 0x0p+0 },
{ INT64_C(0xffffeffffb7f7fff), -0x1.00004808001p+44, 0x0p+0 },
{ INT64_C(0x0000100004810000), 0x1.0000481p+44, 0x0p+0 },
{ INT64_C(0xffffeffffb7effff), -0x1.00004810001p+44, 0x0p+0 },
{ INT64_C(0x0000100004900000), 0x1.000049p+44, 0x0p+0 },
{ INT64_C(0xffffeffffb6fffff), -0x1.00004900001p+44, 0x0p+0 },
{ INT64_C(0x0000100004a00000), 0x1.00004ap+44, 0x0p+0 },
{ INT64_C(0xffffeffffb5fffff), -0x1.00004a00001p+44, 0x0p+0 },
{ INT64_C(0x0000100008000004), 0x1.00008000004p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fffffb), -0x1.00008000005p+44, 0x0p+0 },
{ INT64_C(0x0000100008000040), 0x1.0000800004p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffffbf), -0x1.00008000041p+44, 0x0p+0 },
{ INT64_C(0x0000100008000048), 0x1.00008000048p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffffb7), -0x1.00008000049p+44, 0x0p+0 },
{ INT64_C(0x0000100008000050), 0x1.0000800005p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffffaf), -0x1.00008000051p+44, 0x0p+0 },
{ INT64_C(0x0000100008000080), 0x1.0000800008p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffff7f), -0x1.00008000081p+44, 0x0p+0 },
{ INT64_C(0x0000100008000081), 0x1.00008000081p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffff7e), -0x1.00008000082p+44, 0x0p+0 },
{ INT64_C(0x0000100008000088), 0x1.00008000088p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffff77), -0x1.00008000089p+44, 0x0p+0 },
{ INT64_C(0x0000100008000800), 0x1.000080008p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fff7ff), -0x1.00008000801p+44, 0x0p+0 },
{ INT64_C(0x0000100008000802), 0x1.00008000802p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fff7fd), -0x1.00008000803p+44, 0x0p+0 },
{ INT64_C(0x0000100008000810), 0x1.0000800081p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fff7ef), -0x1.00008000811p+44, 0x0p+0 },
{ INT64_C(0x0000100008000820), 0x1.0000800082p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fff7df), -0x1.00008000821p+44, 0x0p+0 },
{ INT64_C(0x0000100008000840), 0x1.0000800084p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fff7bf), -0x1.00008000841p+44, 0x0p+0 },
{ INT64_C(0x0000100008000a00), 0x1.00008000ap+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fff5ff), -0x1.00008000a01p+44, 0x0p+0 },
{ INT64_C(0x0000100008004000), 0x1.00008004p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffbfff), -0x1.00008004001p+44, 0x0p+0 },
{ INT64_C(0x0000100008004004), 0x1.00008004004p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffbffb), -0x1.00008004005p+44, 0x0p+0 },
{ INT64_C(0x0000100008004010), 0x1.0000800401p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffbfef), -0x1.00008004011p+44, 0x0p+0 },
{ INT64_C(0x0000100008004040), 0x1.0000800404p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffbfbf), -0x1.00008004041p+44, 0x0p+0 },
{ INT64_C(0x0000100008004080), 0x1.0000800408p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffbf7f), -0x1.00008004081p+44, 0x0p+0 },
{ INT64_C(0x0000100008004200), 0x1.000080042p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffbdff), -0x1.00008004201p+44, 0x0p+0 },
{ INT64_C(0x0000100008005000), 0x1.00008005p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7ffafff), -0x1.00008005001p+44, 0x0p+0 },
{ INT64_C(0x0000100008020000), 0x1.0000802p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fdffff), -0x1.00008020001p+44, 0x0p+0 },
{ INT64_C(0x0000100008020001), 0x1.00008020001p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fdfffe), -0x1.00008020002p+44, 0x0p+0 },
{ INT64_C(0x0000100008020008), 0x1.00008020008p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fdfff7), -0x1.00008020009p+44, 0x0p+0 },
{ INT64_C(0x0000100008020080), 0x1.0000802008p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fdff7f), -0x1.00008020081p+44, 0x0p+0 },
{ INT64_C(0x0000100008020200), 0x1.000080202p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fdfdff), -0x1.00008020201p+44, 0x0p+0 },
{ INT64_C(0x0000100008021000), 0x1.00008021p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fdefff), -0x1.00008021001p+44, 0x0p+0 },
{ INT64_C(0x0000100008022000), 0x1.00008022p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fddfff), -0x1.00008022001p+44, 0x0p+0 },
{ INT64_C(0x0000100008024000), 0x1.00008024p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fdbfff), -0x1.00008024001p+44, 0x0p+0 },
{ INT64_C(0x0000100008028000), 0x1.00008028p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7fd7fff), -0x1.00008028001p+44, 0x0p+0 },
{ INT64_C(0x0000100008080000), 0x1.0000808p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7f7ffff), -0x1.00008080001p+44, 0x0p+0 },
{ INT64_C(0x0000100008080008), 0x1.00008080008p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7f7fff7), -0x1.00008080009p+44, 0x0p+0 },
{ INT64_C(0x0000100008080040), 0x1.0000808004p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7f7ffbf), -0x1.00008080041p+44, 0x0p+0 },
{ INT64_C(0x0000100008080100), 0x1.000080801p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7f7feff), -0x1.00008080101p+44, 0x0p+0 },
{ INT64_C(0x0000100008080800), 0x1.000080808p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7f7f7ff), -0x1.00008080801p+44, 0x0p+0 },
{ INT64_C(0x0000100008084000), 0x1.00008084p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7f7bfff), -0x1.00008084001p+44, 0x0p+0 },
{ INT64_C(0x0000100008088000), 0x1.00008088p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7f77fff), -0x1.00008088001p+44, 0x0p+0 },
{ INT64_C(0x0000100008090000), 0x1.0000809p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7f6ffff), -0x1.00008090001p+44, 0x0p+0 },
{ INT64_C(0x00001000080c0000), 0x1.000080cp+44, 0x0p+0 },
{ INT64_C(0xffffeffff7f3ffff), -0x1.000080c0001p+44, 0x0p+0 },
{ INT64_C(0x0000100008400000), 0x1.000084p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7bfffff), -0x1.00008400001p+44, 0x0p+0 },
{ INT64_C(0x0000100008400002), 0x1.00008400002p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7bffffd), -0x1.00008400003p+44, 0x0p+0 },
{ INT64_C(0x0000100008400008), 0x1.00008400008p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7bffff7), -0x1.00008400009p+44, 0x0p+0 },
{ INT64_C(0x0000100008400010), 0x1.0000840001p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7bfffef), -0x1.00008400011p+44, 0x0p+0 },
{ INT64_C(0x0000100008400100), 0x1.000084001p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7bffeff), -0x1.00008400101p+44, 0x0p+0 },
{ INT64_C(0x0000100008400400), 0x1.000084004p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7bffbff), -0x1.00008400401p+44, 0x0p+0 },
{ INT64_C(0x0000100008401000), 0x1.00008401p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7bfefff), -0x1.00008401001p+44, 0x0p+0 },
{ INT64_C(0x0000100008404000), 0x1.00008404p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7bfbfff), -0x1.00008404001p+44, 0x0p+0 },
{ INT64_C(0x0000100008440000), 0x1.0000844p+44, 0x0p+0 },
{ INT64_C(0xffffeffff7bbffff), -0x1.00008440001p+44, 0x0p+0 },
{ INT64_C(0x0000100009000000), 0x1.00009p+44, 0x0p+0 },
{ INT64_C(0xffffeffff6ffffff), -0x1.00009000001p+44, 0x0p+0 },
{ INT64_C(0x0000100009000002), 0x1.00009000002p+44, 0x0p+0 },
{ INT64_C(0xffffeffff6fffffd), -0x1.00009000003p+44, 0x0p+0 },
{ INT64_C(0x0000100009000004), 0x1.00009000004p+44, 0x0p+0 },
{ INT64_C(0xffffeffff6fffffb), -0x1.00009000005p+44, 0x0p+0 },
{ INT64_C(0x0000100009000020), 0x1.0000900002p+44, 0x0p+0 },
{ INT64_C(0xffffeffff6ffffdf), -0x1.00009000021p+44, 0x0p+0 },
{ INT64_C(0x0000100009000200), 0x1.000090002p+44, 0x0p+0 },
{ INT64_C(0xffffeffff6fffdff), -0x1.00009000201p+44, 0x0p+0 },
{ INT64_C(0x0000100009000800), 0x1.000090008p+44, 0x0p+0 },
{ INT64_C(0xffffeffff6fff7ff), -0x1.00009000801p+44, 0x0p+0 },
{ INT64_C(0x0000100009004000), 0x1.00009004p+44, 0x0p+0 },
{ INT64_C(0xffffeffff6ffbfff), -0x1.00009004001p+44, 0x0p+0 },
{ INT64_C(0x0000100009040000), 0x1.0000904p+44, 0x0p+0 },
{ INT64_C(0xffffeffff6fbffff), -0x1.00009040001p+44, 0x0p+0 },
{ INT64_C(0x0000100009100000), 0x1.000091p+44, 0x0p+0 },
{ INT64_C(0xffffeffff6efffff), -0x1.00009100001p+44, 0x0p+0 },
{ INT64_C(0x0000100009200000), 0x1.000092p+44, 0x0p+0 },
{ INT64_C(0xffffeffff6dfffff), -0x1.00009200001p+44, 0x0p+0 },
{ INT64_C(0x000010000c000000), 0x1.0000cp+44, 0x0p+0 },
{ INT64_C(0xffffeffff3ffffff), -0x1.0000c000001p+44, 0x0p+0 },
{ INT64_C(0x000010000c000002), 0x1.0000c000002p+44, 0x0p+0 },
{ INT64_C(0xffffeffff3fffffd), -0x1.0000c000003p+44, 0x0p+0 },
{ INT64_C(0x000010000c000020), 0x1.0000c00002p+44, 0x0p+0 },
{ INT64_C(0xffffeffff3ffffdf), -0x1.0000c000021p+44, 0x0p+0 },
{ INT64_C(0x000010000c000040), 0x1.0000c00004p+44, 0x0p+0 },
{ INT64_C(0xffffeffff3ffffbf), -0x1.0000c000041p+44, 0x0p+0 },
{ INT64_C(0x000010000c000080), 0x1.0000c00008p+44, 0x0p+0 },
{ INT64_C(0xffffeffff3ffff7f), -0x1.0000c000081p+44, 0x0p+0 },
{ INT64_C(0x000010000c000100), 0x1.0000c0001p+44, 0x0p+0 },
{ INT64_C(0xffffeffff3fffeff), -0x1.0000c000101p+44, 0x0p+0 },
{ INT64_C(0x000010000c000400), 0x1.0000c0004p+44, 0x0p+0 },
{ INT64_C(0xffffeffff3fffbff), -0x1.0000c000401p+44, 0x0p+0 },
{ INT64_C(0x000010000c002000), 0x1.0000c002p+44, 0x0p+0 },
{ INT64_C(0xffffeffff3ffdfff), -0x1.0000c002001p+44, 0x0p+0 },
{ INT64_C(0x000010000c008000), 0x1.0000c008p+44, 0x0p+0 },
{ INT64_C(0xffffeffff3ff7fff), -0x1.0000c008001p+44, 0x0p+0 },
{ INT64_C(0x000010000c080000), 0x1.0000c08p+44, 0x0p+0 },
{ INT64_C(0xffffeffff3f7ffff), -0x1.0000c080001p+44, 0x0p+0 },
{ INT64_C(0x000010000c400000), 0x1.0000c4p+44, 0x0p+0 },
{ INT64_C(0xffffeffff3bfffff), -0x1.0000c400001p+44, 0x0p+0 },
{ INT64_C(0x000010000c800000), 0x1.0000c8p+44, 0x0p+0 },
{ INT64_C(0xffffeffff37fffff), -0x1.0000c800001p+44, 0x0p+0 },
{ INT64_C(0x0000100020000002), 0x1.00020000002p+44, 0x0p+0 },
{ INT64_C(0xffffefffdffffffd), -0x1.00020000003p+44, 0x0p+0 },
{ INT64_C(0x0000100020000020), 0x1.0002000002p+44, 0x0p+0 },
{ INT64_C(0xffffefffdfffffdf), -0x1.00020000021p+44, 0x0p+0 },
{ INT64_C(0x0000100020000024), 0x1.00020000024p+44, 0x0p+0 },
{ INT64_C(0xffffefffdfffffdb), -0x1.00020000025p+44, 0x0p+0 },
{ INT64_C(0x0000100020000040), 0x1.0002000004p+44, 0x0p+0 },
{ INT64_C(0xffffefffdfffffbf), -0x1.00020000041p+44, 0x0p+0 },
{ INT64_C(0x0000100020000048), 0x1.00020000048p+44, 0x0p+0 },
{ INT64_C(0xffffefffdfffffb7), -0x1.00020000049p+44, 0x0p+0 },
{ INT64_C(0x0000100020000050), 0x1.0002000005p+44, 0x0p+0 },
{ INT64_C(0xffffefffdfffffaf), -0x1.00020000051p+44, 0x0p+0 },
{ INT64_C(0x0000100020000100), 0x1.000200001p+44, 0x0p+0 },
{ INT64_C(0xffffefffdffffeff), -0x1.00020000101p+44, 0x0p+0 },
{ INT64_C(0x0000100020000104), 0x1.00020000104p+44, 0x0p+0 },
{ INT64_C(0xffffefffdffffefb), -0x1.00020000105p+44, 0x0p+0 },
{ INT64_C(0x0000100020000140), 0x1.0002000014p+44, 0x0p+0 },
{ INT64_C(0xffffefffdffffebf), -0x1.00020000141p+44, 0x0p+0 },
{ INT64_C(0x0000100020000800), 0x1.000200008p+44, 0x0p+0 },
{ INT64_C(0xffffefffdffff7ff), -0x1.00020000801p+44, 0x0p+0 },
{ INT64_C(0x0000100020000808), 0x1.00020000808p+44, 0x0p+0 },
{ INT64_C(0xffffefffdffff7f7), -0x1.00020000809p+44, 0x0p+0 },
{ INT64_C(0x0000100020000840), 0x1.0002000084p+44, 0x0p+0 },
{ INT64_C(0xffffefffdffff7bf), -0x1.00020000841p+44, 0x0p+0 },
{ INT64_C(0x0000100020000900), 0x1.000200009p+44, 0x0p+0 },
{ INT64_C(0xffffefffdffff6ff), -0x1.00020000901p+44, 0x0p+0 },
{ INT64_C(0x0000100020000a00), 0x1.00020000ap+44, 0x0p+0 },
{ INT64_C(0xffffefffdffff5ff), -0x1.00020000a01p+44, 0x0p+0 },
{ INT64_C(0x0000100020000c00), 0x1.00020000cp+44, 0x0p+0 },
{ INT64_C(0xffffefffdffff3ff), -0x1.00020000c01p+44, 0x0p+0 },
{ INT64_C(0x0000100020008000), 0x1.00020008p+44, 0x0p+0 },
{ INT64_C(0xffffefffdfff7fff), -0x1.00020008001p+44, 0x0p+0 },
{ INT64_C(0x0000100020008002), 0x1.00020008002p+44, 0x0p+0 },
{ INT64_C(0xffffefffdfff7ffd), -0x1.00020008003p+44, 0x0p+0 },
{ INT64_C(0x0000100020008010), 0x1.0002000801p+44, 0x0p+0 },
{ INT64_C(0xffffefffdfff7fef), -0x1.00020008011p+44, 0x0p+0 },
{ INT64_C(0x0000100020008040), 0x1.0002000804p+44, 0x0p+0 },
{ INT64_C(0xffffefffdfff7fbf), -0x1.00020008041p+44, 0x0p+0 },
{ INT64_C(0x0000100020008080), 0x1.0002000808p+44, 0x0p+0 },
{ INT64_C(0xffffefffdfff7f7f), -0x1.00020008081p+44, 0x0p+0 },
{ INT64_C(0x0000100020008800), 0x1.000200088p+44, 0x0p+0 },
{ INT64_C(0xffffefffdfff77ff), -0x1.00020008801p+44, 0x0p+0 },
{ INT64_C(0x0000100020080000), 0x1.0002008p+44, 0x0p+0 },
{ INT64_C(0xffffefffdff7ffff), -0x1.00020080001p+44, 0x0p+0 },
{ INT64_C(0x0000100020080001), 0x1.00020080001p+44, 0x0p+0 },
{ INT64_C(0xffffefffdff7fffe), -0x1.00020080002p+44, 0x0p+0 },
{ INT64_C(0x0000100020080008), 0x1.00020080008p+44, 0x0p+0 },
{ INT64_C(0xffffefffdff7fff7), -0x1.00020080009p+44, 0x0p+0 },
{ INT64_C(0x0000100020080010), 0x1.0002008001p+44, 0x0p+0 },
{ INT64_C(0xffffefffdff7ffef), -0x1.00020080011p+44, 0x0p+0 },
{ INT64_C(0x0000100020080020), 0x1.0002008002p+44, 0x0p+0 },
{ INT64_C(0xffffefffdff7ffdf), -0x1.00020080021p+44, 0x0p+0 },
{ INT64_C(0x0000100020080100), 0x1.000200801p+44, 0x0p+0 },
{ INT64_C(0xffffefffdff7feff), -0x1.00020080101p+44, 0x0p+0 },
{ INT64_C(0x0000100020080200), 0x1.000200802p+44, 0x0p+0 },
{ INT64_C(0xffffefffdff7fdff), -0x1.00020080201p+44, 0x0p+0 },
{ INT64_C(0x0000100020082000), 0x1.00020082p+44, 0x0p+0 },
{ INT64_C(0xffffefffdff7dfff), -0x1.00020082001p+44, 0x0p+0 },
{ INT64_C(0x0000100020090000), 0x1.0002009p+44, 0x0p+0 },
{ INT64_C(0xffffefffdff6ffff), -0x1.00020090001p+44, 0x0p+0 },
{ INT64_C(0x00001000200a0000), 0x1.000200ap+44, 0x0p+0 },
{ INT64_C(0xffffefffdff5ffff), -0x1.000200a0001p+44, 0x0p+0 },
{ INT64_C(0x0000100020800000), 0x1.000208p+44, 0x0p+0 },
{ INT64_C(0xffffefffdf7fffff), -0x1.00020800001p+44, 0x0p+0 },
{ INT64_C(0x0000100020800001), 0x1.00020800001p+44, 0x0p+0 },
{ INT64_C(0xffffefffdf7ffffe), -0x1.00020800002p+44, 0x0p+0 },
{ INT64_C(0x0000100020800008), 0x1.00020800008p+44, 0x0p+0 },
{ INT64_C(0xffffefffdf7ffff7), -0x1.00020800009p+44, 0x0p+0 },
{ INT64_C(0x0000100020800020), 0x1.0002080002p+44, 0x0p+0 },
{ INT64_C(0xffffefffdf7fffdf), -0x1.00020800021p+44, 0x0p+0 },
{ INT64_C(0x0000100020800100), 0x1.000208001p+44, 0x0p+0 },
{ INT64_C(0xffffefffdf7ffeff), -0x1.00020800101p+44, 0x0p+0 },
{ INT64_C(0x0000100020800200), 0x1.000208002p+44, 0x0p+0 },
{ INT64_C(0xffffefffdf7ffdff), -0x1.00020800201p+44, 0x0p+0 },
{ INT64_C(0x0000100020800400), 0x1.000208004p+44, 0x0p+0 },
{ INT64_C(0xffffefffdf7ffbff), -0x1.00020800401p+44, 0x0p+0 },
{ INT64_C(0x0000100020804000), 0x1.00020804p+44, 0x0p+0 },
{ INT64_C(0xffffefffdf7fbfff), -0x1.00020804001p+44, 0x0p+0 },
{ INT64_C(0x0000100020810000), 0x1.0002081p+44, 0x0p+0 },
{ INT64_C(0xffffefffdf7effff), -0x1.00020810001p+44, 0x0p+0 },
{ INT64_C(0x0000100020900000), 0x1.000209p+44, 0x0p+0 },
{ INT64_C(0xffffefffdf6fffff), -0x1.00020900001p+44, 0x0p+0 },
{ INT64_C(0x0000100020a00000), 0x1.00020ap+44, 0x0p+0 },
{ INT64_C(0xffffefffdf5fffff), -0x1.00020a00001p+44, 0x0p+0 },
{ INT64_C(0x0000100021000000), 0x1.00021p+44, 0x0p+0 },
{ INT64_C(0xffffefffdeffffff), -0x1.00021000001p+44, 0x0p+0 },
{ INT64_C(0x0000100021000002), 0x1.00021000002p+44, 0x0p+0 },
{ INT64_C(0xffffefffdefffffd), -0x1.00021000003p+44, 0x0p+0 },
{ INT64_C(0x0000100021000004), 0x1.00021000004p+44, 0x0p+0 },
{ INT64_C(0xffffefffdefffffb), -0x1.00021000005p+44, 0x0p+0 },
{ INT64_C(0x0000100021000020), 0x1.0002100002p+44, 0x0p+0 },
{ INT64_C(0xffffefffdeffffdf), -0x1.00021000021p+44, 0x0p+0 },
{ INT64_C(0x0000100021000040), 0x1.0002100004p+44, 0x0p+0 },
{ INT64_C(0xffffefffdeffffbf), -0x1.00021000041p+44, 0x0p+0 },
{ INT64_C(0x0000100021000080), 0x1.0002100008p+44, 0x0p+0 },
{ INT64_C(0xffffefffdeffff7f), -0x1.00021000081p+44, 0x0p+0 },
{ INT64_C(0x0000100021000800), 0x1.000210008p+44, 0x0p+0 },
{ INT64_C(0xffffefffdefff7ff), -0x1.00021000801p+44, 0x0p+0 },
{ INT64_C(0x0000100021002000), 0x1.00021002p+44, 0x0p+0 },
{ INT64_C(0xffffefffdeffdfff), -0x1.00021002001p+44, 0x0p+0 },
{ INT64_C(0x0000100021020000), 0x1.0002102p+44, 0x0p+0 },
{ INT64_C(0xffffefffdefdffff), -0x1.00021020001p+44, 0x0p+0 },
{ INT64_C(0x0000100021100000), 0x1.000211p+44, 0x0p+0 },
{ INT64_C(0xffffefffdeefffff), -0x1.00021100001p+44, 0x0p+0 },
{ INT64_C(0x0000100021200000), 0x1.000212p+44, 0x0p+0 },
{ INT64_C(0xffffefffdedfffff), -0x1.00021200001p+44, 0x0p+0 },
{ INT64_C(0x0000100028000000), 0x1.00028p+44, 0x0p+0 },
{ INT64_C(0xffffefffd7ffffff), -0x1.00028000001p+44, 0x0p+0 },
{ INT64_C(0x0000100028000008), 0x1.00028000008p+44, 0x0p+0 },
{ INT64_C(0xffffefffd7fffff7), -0x1.00028000009p+44, 0x0p+0 },
{ INT64_C(0x0000100028000020), 0x1.0002800002p+44, 0x0p+0 },
{ INT64_C(0xffffefffd7ffffdf), -0x1.00028000021p+44, 0x0p+0 },
{ INT64_C(0x0000100028000040), 0x1.0002800004p+44, 0x0p+0 },
{ INT64_C(0xffffefffd7ffffbf), -0x1.00028000041p+44, 0x0p+0 },
{ INT64_C(0x0000100028000200), 0x1.000280002p+44, 0x0p+0 },
{ INT64_C(0xffffefffd7fffdff), -0x1.00028000201p+44, 0x0p+0 },
{ INT64_C(0x0000100028000400), 0x1.000280004p+44, 0x0p+0 },
{ INT64_C(0xffffefffd7fffbff), -0x1.00028000401p+44, 0x0p+0 },
{ INT64_C(0x0000100028001000), 0x1.00028001p+44, 0x0p+0 },
{ INT64_C(0xffffefffd7ffefff), -0x1.00028001001p+44, 0x0p+0 },
{ INT64_C(0x0000100028010000), 0x1.0002801p+44, 0x0p+0 },
{ INT64_C(0xffffefffd7feffff), -0x1.00028010001p+44, 0x0p+0 },
{ INT64_C(0x0000100028020000), 0x1.0002802p+44, 0x0p+0 },
{ INT64_C(0xffffefffd7fdffff), -0x1.00028020001p+44, 0x0p+0 },
{ INT64_C(0x0000100028040000), 0x1.0002804p+44, 0x0p+0 },
{ INT64_C(0xffffefffd7fbffff), -0x1.00028040001p+44, 0x0p+0 },
{ INT64_C(0x0000100028100000), 0x1.000281p+44, 0x0p+0 },
{ INT64_C(0xffffefffd7efffff), -0x1.00028100001p+44, 0x0p+0 },
{ INT64_C(0x0000100028400000), 0x1.000284p+44, 0x0p+0 },
{ INT64_C(0xffffefffd7bfffff), -0x1.00028400001p+44, 0x0p+0 },
{ INT64_C(0x0000100029000000), 0x1.00029p+44, 0x0p+0 },
{ INT64_C(0xffffefffd6ffffff), -0x1.00029000001p+44, 0x0p+0 },
{ INT64_C(0x0000100040000004), 0x1.00040000004p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffffffb), -0x1.00040000005p+44, 0x0p+0 },
{ INT64_C(0x0000100040000005), 0x1.00040000005p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffffffa), -0x1.00040000006p+44, 0x0p+0 },
{ INT64_C(0x0000100040000006), 0x1.00040000006p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffffff9), -0x1.00040000007p+44, 0x0p+0 },
{ INT64_C(0x0000100040000008), 0x1.00040000008p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffffff7), -0x1.00040000009p+44, 0x0p+0 },
{ INT64_C(0x000010004000000a), 0x1.0004000000ap+44, 0x0p+0 },
{ INT64_C(0xffffefffbffffff5), -0x1.0004000000bp+44, 0x0p+0 },
{ INT64_C(0x0000100040000020), 0x1.0004000002p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfffffdf), -0x1.00040000021p+44, 0x0p+0 },
{ INT64_C(0x0000100040000021), 0x1.00040000021p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfffffde), -0x1.00040000022p+44, 0x0p+0 },
{ INT64_C(0x0000100040000030), 0x1.0004000003p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfffffcf), -0x1.00040000031p+44, 0x0p+0 },
{ INT64_C(0x0000100040000200), 0x1.000400002p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffffdff), -0x1.00040000201p+44, 0x0p+0 },
{ INT64_C(0x0000100040000208), 0x1.00040000208p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffffdf7), -0x1.00040000209p+44, 0x0p+0 },
{ INT64_C(0x0000100040000280), 0x1.0004000028p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffffd7f), -0x1.00040000281p+44, 0x0p+0 },
{ INT64_C(0x0000100040000300), 0x1.000400003p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffffcff), -0x1.00040000301p+44, 0x0p+0 },
{ INT64_C(0x0000100040002000), 0x1.00040002p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfffdfff), -0x1.00040002001p+44, 0x0p+0 },
{ INT64_C(0x0000100040002008), 0x1.00040002008p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfffdff7), -0x1.00040002009p+44, 0x0p+0 },
{ INT64_C(0x0000100040002020), 0x1.0004000202p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfffdfdf), -0x1.00040002021p+44, 0x0p+0 },
{ INT64_C(0x0000100040002040), 0x1.0004000204p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfffdfbf), -0x1.00040002041p+44, 0x0p+0 },
{ INT64_C(0x0000100040002080), 0x1.0004000208p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfffdf7f), -0x1.00040002081p+44, 0x0p+0 },
{ INT64_C(0x0000100040002200), 0x1.000400022p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfffddff), -0x1.00040002201p+44, 0x0p+0 },
{ INT64_C(0x0000100040003000), 0x1.00040003p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfffcfff), -0x1.00040003001p+44, 0x0p+0 },
{ INT64_C(0x0000100040020000), 0x1.0004002p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffdffff), -0x1.00040020001p+44, 0x0p+0 },
{ INT64_C(0x0000100040020001), 0x1.00040020001p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffdfffe), -0x1.00040020002p+44, 0x0p+0 },
{ INT64_C(0x0000100040020008), 0x1.00040020008p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffdfff7), -0x1.00040020009p+44, 0x0p+0 },
{ INT64_C(0x0000100040020080), 0x1.0004002008p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffdff7f), -0x1.00040020081p+44, 0x0p+0 },
{ INT64_C(0x0000100040020100), 0x1.000400201p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffdfeff), -0x1.00040020101p+44, 0x0p+0 },
{ INT64_C(0x0000100040021000), 0x1.00040021p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffdefff), -0x1.00040021001p+44, 0x0p+0 },
{ INT64_C(0x0000100040028000), 0x1.00040028p+44, 0x0p+0 },
{ INT64_C(0xffffefffbffd7fff), -0x1.00040028001p+44, 0x0p+0 },
{ INT64_C(0x0000100040200000), 0x1.000402p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfdfffff), -0x1.00040200001p+44, 0x0p+0 },
{ INT64_C(0x0000100040200004), 0x1.00040200004p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfdffffb), -0x1.00040200005p+44, 0x0p+0 },
{ INT64_C(0x0000100040200008), 0x1.00040200008p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfdffff7), -0x1.00040200009p+44, 0x0p+0 },
{ INT64_C(0x0000100040200010), 0x1.0004020001p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfdfffef), -0x1.00040200011p+44, 0x0p+0 },
{ INT64_C(0x0000100040200080), 0x1.0004020008p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfdfff7f), -0x1.00040200081p+44, 0x0p+0 },
{ INT64_C(0x0000100040200100), 0x1.000402001p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfdffeff), -0x1.00040200101p+44, 0x0p+0 },
{ INT64_C(0x0000100040200800), 0x1.000402008p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfdff7ff), -0x1.00040200801p+44, 0x0p+0 },
{ INT64_C(0x0000100040201000), 0x1.00040201p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfdfefff), -0x1.00040201001p+44, 0x0p+0 },
{ INT64_C(0x0000100040202000), 0x1.00040202p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfdfdfff), -0x1.00040202001p+44, 0x0p+0 },
{ INT64_C(0x0000100040220000), 0x1.0004022p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfddffff), -0x1.00040220001p+44, 0x0p+0 },
{ INT64_C(0x0000100040300000), 0x1.000403p+44, 0x0p+0 },
{ INT64_C(0xffffefffbfcfffff), -0x1.00040300001p+44, 0x0p+0 },
{ INT64_C(0x0000100041000000), 0x1.00041p+44, 0x0p+0 },
{ INT64_C(0xffffefffbeffffff), -0x1.00041000001p+44, 0x0p+0 },
{ INT64_C(0x0000100041000004), 0x1.00041000004p+44, 0x0p+0 },
{ INT64_C(0xffffefffbefffffb), -0x1.00041000005p+44, 0x0p+0 },
{ INT64_C(0x0000100041000020), 0x1.0004100002p+44, 0x0p+0 },
{ INT64_C(0xffffefffbeffffdf), -0x1.00041000021p+44, 0x0p+0 },
{ INT64_C(0x0000100041000100), 0x1.000410001p+44, 0x0p+0 },
{ INT64_C(0xffffefffbefffeff), -0x1.00041000101p+44, 0x0p+0 },
{ INT64_C(0x0000100041000800), 0x1.000410008p+44, 0x0p+0 },
{ INT64_C(0xffffefffbefff7ff), -0x1.00041000801p+44, 0x0p+0 },
{ INT64_C(0x0000100041001000), 0x1.00041001p+44, 0x0p+0 },
{ INT64_C(0xffffefffbeffefff), -0x1.00041001001p+44, 0x0p+0 },
{ INT64_C(0x0000100041002000), 0x1.00041002p+44, 0x0p+0 },
{ INT64_C(0xffffefffbeffdfff), -0x1.00041002001p+44, 0x0p+0 },
{ INT64_C(0x0000100041020000), 0x1.0004102p+44, 0x0p+0 },
{ INT64_C(0xffffefffbefdffff), -0x1.00041020001p+44, 0x0p+0 },
{ INT64_C(0x0000100041200000), 0x1.000412p+44, 0x0p+0 },
{ INT64_C(0xffffefffbedfffff), -0x1.00041200001p+44, 0x0p+0 },
{ INT64_C(0x0000100041400000), 0x1.000414p+44, 0x0p+0 },
{ INT64_C(0xffffefffbebfffff), -0x1.00041400001p+44, 0x0p+0 },
{ INT64_C(0x0000100041800000), 0x1.000418p+44, 0x0p+0 },
{ INT64_C(0xffffefffbe7fffff), -0x1.00041800001p+44, 0x0p+0 },
{ INT64_C(0x0000100044000000), 0x1.00044p+44, 0x0p+0 },
{ INT64_C(0xffffefffbbffffff), -0x1.00044000001p+44, 0x0p+0 },
{ INT64_C(0x0000100044000008), 0x1.00044000008p+44, 0x0p+0 },
{ INT64_C(0xffffefffbbfffff7), -0x1.00044000009p+44, 0x0p+0 },
{ INT64_C(0x0000100044000010), 0x1.0004400001p+44, 0x0p+0 },
{ INT64_C(0xffffefffbbffffef), -0x1.00044000011p+44, 0x0p+0 },
{ INT64_C(0x0000100044000040), 0x1.0004400004p+44, 0x0p+0 },
{ INT64_C(0xffffefffbbffffbf), -0x1.00044000041p+44, 0x0p+0 },
{ INT64_C(0x0000100044000400), 0x1.000440004p+44, 0x0p+0 },
{ INT64_C(0xffffefffbbfffbff), -0x1.00044000401p+44, 0x0p+0 },
{ INT64_C(0x0000100044001000), 0x1.00044001p+44, 0x0p+0 },
{ INT64_C(0xffffefffbbffefff), -0x1.00044001001p+44, 0x0p+0 },
{ INT64_C(0x0000100044010000), 0x1.0004401p+44, 0x0p+0 },
{ INT64_C(0xffffefffbbfeffff), -0x1.00044010001p+44, 0x0p+0 },
{ INT64_C(0x0000100044100000), 0x1.000441p+44, 0x0p+0 },
{ INT64_C(0xffffefffbbefffff), -0x1.00044100001p+44, 0x0p+0 },
{ INT64_C(0x0000100045000000), 0x1.00045p+44, 0x0p+0 },
{ INT64_C(0xffffefffbaffffff), -0x1.00045000001p+44, 0x0p+0 },
{ INT64_C(0x0000100200000004), 0x1.00200000004p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffffffb), -0x1.00200000005p+44, 0x0p+0 },
{ INT64_C(0x0000100200000010), 0x1.0020000001p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffffef), -0x1.00200000011p+44, 0x0p+0 },
{ INT64_C(0x0000100200000012), 0x1.00200000012p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffffed), -0x1.00200000013p+44, 0x0p+0 },
{ INT64_C(0x0000100200000018), 0x1.00200000018p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffffe7), -0x1.00200000019p+44, 0x0p+0 },
{ INT64_C(0x0000100200000080), 0x1.0020000008p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffff7f), -0x1.00200000081p+44, 0x0p+0 },
{ INT64_C(0x0000100200000088), 0x1.00200000088p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffff77), -0x1.00200000089p+44, 0x0p+0 },
{ INT64_C(0x0000100200000200), 0x1.002000002p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffffdff), -0x1.00200000201p+44, 0x0p+0 },
{ INT64_C(0x0000100200000208), 0x1.00200000208p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffffdf7), -0x1.00200000209p+44, 0x0p+0 },
{ INT64_C(0x0000100200000240), 0x1.0020000024p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffffdbf), -0x1.00200000241p+44, 0x0p+0 },
{ INT64_C(0x0000100200000280), 0x1.0020000028p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffffd7f), -0x1.00200000281p+44, 0x0p+0 },
{ INT64_C(0x0000100200002000), 0x1.00200002p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffdfff), -0x1.00200002001p+44, 0x0p+0 },
{ INT64_C(0x0000100200002002), 0x1.00200002002p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffdffd), -0x1.00200002003p+44, 0x0p+0 },
{ INT64_C(0x0000100200002020), 0x1.0020000202p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffdfdf), -0x1.00200002021p+44, 0x0p+0 },
{ INT64_C(0x0000100200002200), 0x1.002000022p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffddff), -0x1.00200002201p+44, 0x0p+0 },
{ INT64_C(0x0000100200004000), 0x1.00200004p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffbfff), -0x1.00200004001p+44, 0x0p+0 },
{ INT64_C(0x0000100200004002), 0x1.00200004002p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffbffd), -0x1.00200004003p+44, 0x0p+0 },
{ INT64_C(0x0000100200004004), 0x1.00200004004p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffbffb), -0x1.00200004005p+44, 0x0p+0 },
{ INT64_C(0x0000100200004008), 0x1.00200004008p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffbff7), -0x1.00200004009p+44, 0x0p+0 },
{ INT64_C(0x0000100200004080), 0x1.0020000408p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffbf7f), -0x1.00200004081p+44, 0x0p+0 },
{ INT64_C(0x0000100200004400), 0x1.002000044p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffffbbff), -0x1.00200004401p+44, 0x0p+0 },
{ INT64_C(0x0000100200006000), 0x1.00200006p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffff9fff), -0x1.00200006001p+44, 0x0p+0 },
{ INT64_C(0x0000100200008000), 0x1.00200008p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffff7fff), -0x1.00200008001p+44, 0x0p+0 },
{ INT64_C(0x0000100200008001), 0x1.00200008001p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffff7ffe), -0x1.00200008002p+44, 0x0p+0 },
{ INT64_C(0x0000100200008008), 0x1.00200008008p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffff7ff7), -0x1.00200008009p+44, 0x0p+0 },
{ INT64_C(0x0000100200008080), 0x1.0020000808p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffff7f7f), -0x1.00200008081p+44, 0x0p+0 },
{ INT64_C(0x0000100200008200), 0x1.002000082p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffff7dff), -0x1.00200008201p+44, 0x0p+0 },
{ INT64_C(0x0000100200008800), 0x1.002000088p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffff77ff), -0x1.00200008801p+44, 0x0p+0 },
{ INT64_C(0x0000100200009000), 0x1.00200009p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffff6fff), -0x1.00200009001p+44, 0x0p+0 },
{ INT64_C(0x000010020000c000), 0x1.0020000cp+44, 0x0p+0 },
{ INT64_C(0xffffeffdffff3fff), -0x1.0020000c001p+44, 0x0p+0 },
{ INT64_C(0x0000100200020000), 0x1.0020002p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffdffff), -0x1.00200020001p+44, 0x0p+0 },
{ INT64_C(0x0000100200020001), 0x1.00200020001p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffdfffe), -0x1.00200020002p+44, 0x0p+0 },
{ INT64_C(0x0000100200020002), 0x1.00200020002p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffdfffd), -0x1.00200020003p+44, 0x0p+0 },
{ INT64_C(0x0000100200020008), 0x1.00200020008p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffdfff7), -0x1.00200020009p+44, 0x0p+0 },
{ INT64_C(0x0000100200020010), 0x1.0020002001p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffdffef), -0x1.00200020011p+44, 0x0p+0 },
{ INT64_C(0x0000100200020040), 0x1.0020002004p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffdffbf), -0x1.00200020041p+44, 0x0p+0 },
{ INT64_C(0x0000100200020400), 0x1.002000204p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffdfbff), -0x1.00200020401p+44, 0x0p+0 },
{ INT64_C(0x0000100200022000), 0x1.00200022p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffddfff), -0x1.00200022001p+44, 0x0p+0 },
{ INT64_C(0x0000100200030000), 0x1.0020003p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfffcffff), -0x1.00200030001p+44, 0x0p+0 },
{ INT64_C(0x0000100200100000), 0x1.002001p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffefffff), -0x1.00200100001p+44, 0x0p+0 },
{ INT64_C(0x0000100200100001), 0x1.00200100001p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffeffffe), -0x1.00200100002p+44, 0x0p+0 },
{ INT64_C(0x0000100200100004), 0x1.00200100004p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffeffffb), -0x1.00200100005p+44, 0x0p+0 },
{ INT64_C(0x0000100200100008), 0x1.00200100008p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffeffff7), -0x1.00200100009p+44, 0x0p+0 },
{ INT64_C(0x0000100200100080), 0x1.0020010008p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffefff7f), -0x1.00200100081p+44, 0x0p+0 },
{ INT64_C(0x0000100200100800), 0x1.002001008p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffeff7ff), -0x1.00200100801p+44, 0x0p+0 },
{ INT64_C(0x0000100200108000), 0x1.00200108p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffef7fff), -0x1.00200108001p+44, 0x0p+0 },
{ INT64_C(0x0000100200120000), 0x1.0020012p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffedffff), -0x1.00200120001p+44, 0x0p+0 },
{ INT64_C(0x0000100200400000), 0x1.002004p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffbfffff), -0x1.00200400001p+44, 0x0p+0 },
{ INT64_C(0x0000100200400004), 0x1.00200400004p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffbffffb), -0x1.00200400005p+44, 0x0p+0 },
{ INT64_C(0x0000100200400020), 0x1.0020040002p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffbfffdf), -0x1.00200400021p+44, 0x0p+0 },
{ INT64_C(0x0000100200400100), 0x1.002004001p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffbffeff), -0x1.00200400101p+44, 0x0p+0 },
{ INT64_C(0x0000100200400400), 0x1.002004004p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffbffbff), -0x1.00200400401p+44, 0x0p+0 },
{ INT64_C(0x0000100200401000), 0x1.00200401p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffbfefff), -0x1.00200401001p+44, 0x0p+0 },
{ INT64_C(0x0000100200410000), 0x1.0020041p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffbeffff), -0x1.00200410001p+44, 0x0p+0 },
{ INT64_C(0x0000100200480000), 0x1.0020048p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffb7ffff), -0x1.00200480001p+44, 0x0p+0 },
{ INT64_C(0x0000100200500000), 0x1.002005p+44, 0x0p+0 },
{ INT64_C(0xffffeffdffafffff), -0x1.00200500001p+44, 0x0p+0 },
{ INT64_C(0x0000100204000000), 0x1.00204p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfbffffff), -0x1.00204000001p+44, 0x0p+0 },
{ INT64_C(0x0000100204000002), 0x1.00204000002p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfbfffffd), -0x1.00204000003p+44, 0x0p+0 },
{ INT64_C(0x0000100204000020), 0x1.0020400002p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfbffffdf), -0x1.00204000021p+44, 0x0p+0 },
{ INT64_C(0x0000100204000080), 0x1.0020400008p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfbffff7f), -0x1.00204000081p+44, 0x0p+0 },
{ INT64_C(0x0000100204000100), 0x1.002040001p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfbfffeff), -0x1.00204000101p+44, 0x0p+0 },
{ INT64_C(0x0000100204000200), 0x1.002040002p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfbfffdff), -0x1.00204000201p+44, 0x0p+0 },
{ INT64_C(0x0000100204000400), 0x1.002040004p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfbfffbff), -0x1.00204000401p+44, 0x0p+0 },
{ INT64_C(0x0000100204004000), 0x1.00204004p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfbffbfff), -0x1.00204004001p+44, 0x0p+0 },
{ INT64_C(0x0000100204010000), 0x1.0020401p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfbfeffff), -0x1.00204010001p+44, 0x0p+0 },
{ INT64_C(0x0000100204100000), 0x1.002041p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfbefffff), -0x1.00204100001p+44, 0x0p+0 },
{ INT64_C(0x0000100204400000), 0x1.002044p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfbbfffff), -0x1.00204400001p+44, 0x0p+0 },
{ INT64_C(0x0000100205000000), 0x1.00205p+44, 0x0p+0 },
{ INT64_C(0xffffeffdfaffffff), -0x1.00205000001p+44, 0x0p+0 },
{ INT64_C(0x0000100208000000), 0x1.00208p+44, 0x0p+0 },
{ INT64_C(0xffffeffdf7ffffff), -0x1.00208000001p+44, 0x0p+0 },
{ INT64_C(0x0000100208000008), 0x1.00208000008p+44, 0x0p+0 },
{ INT64_C(0xffffeffdf7fffff7), -0x1.00208000009p+44, 0x0p+0 },
{ INT64_C(0x0000100208000080), 0x1.0020800008p+44, 0x0p+0 },
{ INT64_C(0xffffeffdf7ffff7f), -0x1.00208000081p+44, 0x0p+0 },
{ INT64_C(0x0000100208000100), 0x1.002080001p+44, 0x0p+0 },
{ INT64_C(0xffffeffdf7fffeff), -0x1.00208000101p+44, 0x0p+0 },
{ INT64_C(0x0000100208000800), 0x1.002080008p+44, 0x0p+0 },
{ INT64_C(0xffffeffdf7fff7ff), -0x1.00208000801p+44, 0x0p+0 },
{ INT64_C(0x0000100208004000), 0x1.00208004p+44, 0x0p+0 },
{ INT64_C(0xffffeffdf7ffbfff), -0x1.00208004001p+44, 0x0p+0 },
{ INT64_C(0x0000100208040000), 0x1.0020804p+44, 0x0p+0 },
{ INT64_C(0xffffeffdf7fbffff), -0x1.00208040001p+44, 0x0p+0 },
{ INT64_C(0x0000100208200000), 0x1.002082p+44, 0x0p+0 },
{ INT64_C(0xffffeffdf7dfffff), -0x1.00208200001p+44, 0x0p+0 },
{ INT64_C(0x0000100208800000), 0x1.002088p+44, 0x0p+0 },
{ INT64_C(0xffffeffdf77fffff), -0x1.00208800001p+44, 0x0p+0 },
{ INT64_C(0x000010020c000000), 0x1.0020cp+44, 0x0p+0 },
{ INT64_C(0xffffeffdf3ffffff), -0x1.0020c000001p+44, 0x0p+0 },
{ INT64_C(0x0000100220000000), 0x1.0022p+44, 0x0p+0 },
{ INT64_C(0xffffeffddfffffff), -0x1.00220000001p+44, 0x0p+0 },
{ INT64_C(0x0000100220000004), 0x1.00220000004p+44, 0x0p+0 },
{ INT64_C(0xffffeffddffffffb), -0x1.00220000005p+44, 0x0p+0 },
{ INT64_C(0x0000100220000008), 0x1.00220000008p+44, 0x0p+0 },
{ INT64_C(0xffffeffddffffff7), -0x1.00220000009p+44, 0x0p+0 },
{ INT64_C(0x0000100220000010), 0x1.0022000001p+44, 0x0p+0 },
{ INT64_C(0xffffeffddfffffef), -0x1.00220000011p+44, 0x0p+0 },
{ INT64_C(0x0000100220000080), 0x1.0022000008p+44, 0x0p+0 },
{ INT64_C(0xffffeffddfffff7f), -0x1.00220000081p+44, 0x0p+0 },
{ INT64_C(0x0000100220000100), 0x1.002200001p+44, 0x0p+0 },
{ INT64_C(0xffffeffddffffeff), -0x1.00220000101p+44, 0x0p+0 },
{ INT64_C(0x0000100220001000), 0x1.00220001p+44, 0x0p+0 },
{ INT64_C(0xffffeffddfffefff), -0x1.00220001001p+44, 0x0p+0 },
{ INT64_C(0x0000100220008000), 0x1.00220008p+44, 0x0p+0 },
{ INT64_C(0xffffeffddfff7fff), -0x1.00220008001p+44, 0x0p+0 },
{ INT64_C(0x0000100220010000), 0x1.0022001p+44, 0x0p+0 },
{ INT64_C(0xffffeffddffeffff), -0x1.00220010001p+44, 0x0p+0 },
{ INT64_C(0x0000100220100000), 0x1.002201p+44, 0x0p+0 },
{ INT64_C(0xffffeffddfefffff), -0x1.00220100001p+44, 0x0p+0 },
{ INT64_C(0x0000100220400000), 0x1.002204p+44, 0x0p+0 },
{ INT64_C(0xffffeffddfbfffff), -0x1.00220400001p+44, 0x0p+0 },
{ INT64_C(0x0000100224000000), 0x1.00224p+44, 0x0p+0 },
{ INT64_C(0xffffeffddbffffff), -0x1.00224000001p+44, 0x0p+0 },
{ INT64_C(0x0000100228000000), 0x1.00228p+44, 0x0p+0 },
{ INT64_C(0xffffeffdd7ffffff), -0x1.00228000001p+44, 0x0p+0 },
{ INT64_C(0x0000100400000004), 0x1.00400000004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffffffb), -0x1.00400000005p+44, 0x0p+0 },
{ INT64_C(0x0000100400000040), 0x1.0040000004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffffbf), -0x1.00400000041p+44, 0x0p+0 },
{ INT64_C(0x0000100400000048), 0x1.00400000048p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffffb7), -0x1.00400000049p+44, 0x0p+0 },
{ INT64_C(0x0000100400000050), 0x1.0040000005p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffffaf), -0x1.00400000051p+44, 0x0p+0 },
{ INT64_C(0x0000100400000200), 0x1.004000002p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffffdff), -0x1.00400000201p+44, 0x0p+0 },
{ INT64_C(0x0000100400000204), 0x1.00400000204p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffffdfb), -0x1.00400000205p+44, 0x0p+0 },
{ INT64_C(0x0000100400000220), 0x1.0040000022p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffffddf), -0x1.00400000221p+44, 0x0p+0 },
{ INT64_C(0x0000100400000300), 0x1.004000003p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffffcff), -0x1.00400000301p+44, 0x0p+0 },
{ INT64_C(0x0000100400000800), 0x1.004000008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffff7ff), -0x1.00400000801p+44, 0x0p+0 },
{ INT64_C(0x0000100400000801), 0x1.00400000801p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffff7fe), -0x1.00400000802p+44, 0x0p+0 },
{ INT64_C(0x0000100400000808), 0x1.00400000808p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffff7f7), -0x1.00400000809p+44, 0x0p+0 },
{ INT64_C(0x0000100400000840), 0x1.0040000084p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffff7bf), -0x1.00400000841p+44, 0x0p+0 },
{ INT64_C(0x0000100400000c00), 0x1.00400000cp+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffff3ff), -0x1.00400000c01p+44, 0x0p+0 },
{ INT64_C(0x0000100400001000), 0x1.00400001p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffefff), -0x1.00400001001p+44, 0x0p+0 },
{ INT64_C(0x0000100400001004), 0x1.00400001004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffeffb), -0x1.00400001005p+44, 0x0p+0 },
{ INT64_C(0x0000100400001010), 0x1.0040000101p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffefef), -0x1.00400001011p+44, 0x0p+0 },
{ INT64_C(0x0000100400001040), 0x1.0040000104p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffefbf), -0x1.00400001041p+44, 0x0p+0 },
{ INT64_C(0x0000100400001080), 0x1.0040000108p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffef7f), -0x1.00400001081p+44, 0x0p+0 },
{ INT64_C(0x0000100400001200), 0x1.004000012p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffedff), -0x1.00400001201p+44, 0x0p+0 },
{ INT64_C(0x0000100400001400), 0x1.004000014p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffebff), -0x1.00400001401p+44, 0x0p+0 },
{ INT64_C(0x0000100400004000), 0x1.00400004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffbfff), -0x1.00400004001p+44, 0x0p+0 },
{ INT64_C(0x0000100400004008), 0x1.00400004008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffbff7), -0x1.00400004009p+44, 0x0p+0 },
{ INT64_C(0x0000100400004080), 0x1.0040000408p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffbf7f), -0x1.00400004081p+44, 0x0p+0 },
{ INT64_C(0x0000100400004400), 0x1.004000044p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffbbff), -0x1.00400004401p+44, 0x0p+0 },
{ INT64_C(0x0000100400005000), 0x1.00400005p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffffafff), -0x1.00400005001p+44, 0x0p+0 },
{ INT64_C(0x0000100400010000), 0x1.0040001p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffeffff), -0x1.00400010001p+44, 0x0p+0 },
{ INT64_C(0x0000100400010002), 0x1.00400010002p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffefffd), -0x1.00400010003p+44, 0x0p+0 },
{ INT64_C(0x0000100400010004), 0x1.00400010004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffefffb), -0x1.00400010005p+44, 0x0p+0 },
{ INT64_C(0x0000100400010010), 0x1.0040001001p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffeffef), -0x1.00400010011p+44, 0x0p+0 },
{ INT64_C(0x0000100400010100), 0x1.004000101p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffefeff), -0x1.00400010101p+44, 0x0p+0 },
{ INT64_C(0x0000100400011000), 0x1.00400011p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfffeefff), -0x1.00400011001p+44, 0x0p+0 },
{ INT64_C(0x0000100400080000), 0x1.0040008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfff7ffff), -0x1.00400080001p+44, 0x0p+0 },
{ INT64_C(0x0000100400080008), 0x1.00400080008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfff7fff7), -0x1.00400080009p+44, 0x0p+0 },
{ INT64_C(0x0000100400080040), 0x1.0040008004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfff7ffbf), -0x1.00400080041p+44, 0x0p+0 },
{ INT64_C(0x0000100400080080), 0x1.0040008008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfff7ff7f), -0x1.00400080081p+44, 0x0p+0 },
{ INT64_C(0x0000100400080400), 0x1.004000804p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfff7fbff), -0x1.00400080401p+44, 0x0p+0 },
{ INT64_C(0x0000100400080800), 0x1.004000808p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfff7f7ff), -0x1.00400080801p+44, 0x0p+0 },
{ INT64_C(0x0000100400081000), 0x1.00400081p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfff7efff), -0x1.00400081001p+44, 0x0p+0 },
{ INT64_C(0x0000100400088000), 0x1.00400088p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfff77fff), -0x1.00400088001p+44, 0x0p+0 },
{ INT64_C(0x00001004000c0000), 0x1.004000cp+44, 0x0p+0 },
{ INT64_C(0xffffeffbfff3ffff), -0x1.004000c0001p+44, 0x0p+0 },
{ INT64_C(0x0000100400400000), 0x1.004004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffbfffff), -0x1.00400400001p+44, 0x0p+0 },
{ INT64_C(0x0000100400400002), 0x1.00400400002p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffbffffd), -0x1.00400400003p+44, 0x0p+0 },
{ INT64_C(0x0000100400400008), 0x1.00400400008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffbffff7), -0x1.00400400009p+44, 0x0p+0 },
{ INT64_C(0x0000100400400010), 0x1.0040040001p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffbfffef), -0x1.00400400011p+44, 0x0p+0 },
{ INT64_C(0x0000100400400040), 0x1.0040040004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffbfffbf), -0x1.00400400041p+44, 0x0p+0 },
{ INT64_C(0x0000100400400080), 0x1.0040040008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffbfff7f), -0x1.00400400081p+44, 0x0p+0 },
{ INT64_C(0x0000100400400800), 0x1.004004008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffbff7ff), -0x1.00400400801p+44, 0x0p+0 },
{ INT64_C(0x0000100400401000), 0x1.00400401p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffbfefff), -0x1.00400401001p+44, 0x0p+0 },
{ INT64_C(0x0000100400408000), 0x1.00400408p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffbf7fff), -0x1.00400408001p+44, 0x0p+0 },
{ INT64_C(0x0000100400420000), 0x1.0040042p+44, 0x0p+0 },
{ INT64_C(0xffffeffbffbdffff), -0x1.00400420001p+44, 0x0p+0 },
{ INT64_C(0x0000100400600000), 0x1.004006p+44, 0x0p+0 },
{ INT64_C(0xffffeffbff9fffff), -0x1.00400600001p+44, 0x0p+0 },
{ INT64_C(0x0000100400800000), 0x1.004008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbff7fffff), -0x1.00400800001p+44, 0x0p+0 },
{ INT64_C(0x0000100400800008), 0x1.00400800008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbff7ffff7), -0x1.00400800009p+44, 0x0p+0 },
{ INT64_C(0x0000100400800080), 0x1.0040080008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbff7fff7f), -0x1.00400800081p+44, 0x0p+0 },
{ INT64_C(0x0000100400800400), 0x1.004008004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbff7ffbff), -0x1.00400800401p+44, 0x0p+0 },
{ INT64_C(0x0000100400800800), 0x1.004008008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbff7ff7ff), -0x1.00400800801p+44, 0x0p+0 },
{ INT64_C(0x0000100400802000), 0x1.00400802p+44, 0x0p+0 },
{ INT64_C(0xffffeffbff7fdfff), -0x1.00400802001p+44, 0x0p+0 },
{ INT64_C(0x0000100400804000), 0x1.00400804p+44, 0x0p+0 },
{ INT64_C(0xffffeffbff7fbfff), -0x1.00400804001p+44, 0x0p+0 },
{ INT64_C(0x0000100400808000), 0x1.00400808p+44, 0x0p+0 },
{ INT64_C(0xffffeffbff7f7fff), -0x1.00400808001p+44, 0x0p+0 },
{ INT64_C(0x0000100400810000), 0x1.0040081p+44, 0x0p+0 },
{ INT64_C(0xffffeffbff7effff), -0x1.00400810001p+44, 0x0p+0 },
{ INT64_C(0x0000100400820000), 0x1.0040082p+44, 0x0p+0 },
{ INT64_C(0xffffeffbff7dffff), -0x1.00400820001p+44, 0x0p+0 },
{ INT64_C(0x0000100400a00000), 0x1.00400ap+44, 0x0p+0 },
{ INT64_C(0xffffeffbff5fffff), -0x1.00400a00001p+44, 0x0p+0 },
{ INT64_C(0x0000100401000000), 0x1.00401p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfeffffff), -0x1.00401000001p+44, 0x0p+0 },
{ INT64_C(0x0000100401000001), 0x1.00401000001p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfefffffe), -0x1.00401000002p+44, 0x0p+0 },
{ INT64_C(0x0000100401000004), 0x1.00401000004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfefffffb), -0x1.00401000005p+44, 0x0p+0 },
{ INT64_C(0x0000100401000008), 0x1.00401000008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfefffff7), -0x1.00401000009p+44, 0x0p+0 },
{ INT64_C(0x0000100401000020), 0x1.0040100002p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfeffffdf), -0x1.00401000021p+44, 0x0p+0 },
{ INT64_C(0x0000100401000080), 0x1.0040100008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfeffff7f), -0x1.00401000081p+44, 0x0p+0 },
{ INT64_C(0x0000100401000200), 0x1.004010002p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfefffdff), -0x1.00401000201p+44, 0x0p+0 },
{ INT64_C(0x0000100401000800), 0x1.004010008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfefff7ff), -0x1.00401000801p+44, 0x0p+0 },
{ INT64_C(0x0000100401001000), 0x1.00401001p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfeffefff), -0x1.00401001001p+44, 0x0p+0 },
{ INT64_C(0x0000100401008000), 0x1.00401008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfeff7fff), -0x1.00401008001p+44, 0x0p+0 },
{ INT64_C(0x0000100401020000), 0x1.0040102p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfefdffff), -0x1.00401020001p+44, 0x0p+0 },
{ INT64_C(0x0000100401080000), 0x1.0040108p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfef7ffff), -0x1.00401080001p+44, 0x0p+0 },
{ INT64_C(0x0000100401400000), 0x1.004014p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfebfffff), -0x1.00401400001p+44, 0x0p+0 },
{ INT64_C(0x0000100404000000), 0x1.00404p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfbffffff), -0x1.00404000001p+44, 0x0p+0 },
{ INT64_C(0x0000100404000001), 0x1.00404000001p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfbfffffe), -0x1.00404000002p+44, 0x0p+0 },
{ INT64_C(0x0000100404000008), 0x1.00404000008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfbfffff7), -0x1.00404000009p+44, 0x0p+0 },
{ INT64_C(0x0000100404000010), 0x1.0040400001p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfbffffef), -0x1.00404000011p+44, 0x0p+0 },
{ INT64_C(0x0000100404000080), 0x1.0040400008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfbffff7f), -0x1.00404000081p+44, 0x0p+0 },
{ INT64_C(0x0000100404000200), 0x1.004040002p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfbfffdff), -0x1.00404000201p+44, 0x0p+0 },
{ INT64_C(0x0000100404001000), 0x1.00404001p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfbffefff), -0x1.00404001001p+44, 0x0p+0 },
{ INT64_C(0x0000100404004000), 0x1.00404004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfbffbfff), -0x1.00404004001p+44, 0x0p+0 },
{ INT64_C(0x0000100404040000), 0x1.0040404p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfbfbffff), -0x1.00404040001p+44, 0x0p+0 },
{ INT64_C(0x0000100404080000), 0x1.0040408p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfbf7ffff), -0x1.00404080001p+44, 0x0p+0 },
{ INT64_C(0x0000100404400000), 0x1.004044p+44, 0x0p+0 },
{ INT64_C(0xffffeffbfbbfffff), -0x1.00404400001p+44, 0x0p+0 },
{ INT64_C(0x0000100420000000), 0x1.0042p+44, 0x0p+0 },
{ INT64_C(0xffffeffbdfffffff), -0x1.00420000001p+44, 0x0p+0 },
{ INT64_C(0x0000100420000004), 0x1.00420000004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbdffffffb), -0x1.00420000005p+44, 0x0p+0 },
{ INT64_C(0x0000100420000008), 0x1.00420000008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbdffffff7), -0x1.00420000009p+44, 0x0p+0 },
{ INT64_C(0x0000100420000010), 0x1.0042000001p+44, 0x0p+0 },
{ INT64_C(0xffffeffbdfffffef), -0x1.00420000011p+44, 0x0p+0 },
{ INT64_C(0x0000100420000040), 0x1.0042000004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbdfffffbf), -0x1.00420000041p+44, 0x0p+0 },
{ INT64_C(0x0000100420000400), 0x1.004200004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbdffffbff), -0x1.00420000401p+44, 0x0p+0 },
{ INT64_C(0x0000100420004000), 0x1.00420004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbdfffbfff), -0x1.00420004001p+44, 0x0p+0 },
{ INT64_C(0x0000100420008000), 0x1.00420008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbdfff7fff), -0x1.00420008001p+44, 0x0p+0 },
{ INT64_C(0x0000100420080000), 0x1.0042008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbdff7ffff), -0x1.00420080001p+44, 0x0p+0 },
{ INT64_C(0x0000100420800000), 0x1.004208p+44, 0x0p+0 },
{ INT64_C(0xffffeffbdf7fffff), -0x1.00420800001p+44, 0x0p+0 },
{ INT64_C(0x0000100424000000), 0x1.00424p+44, 0x0p+0 },
{ INT64_C(0xffffeffbdbffffff), -0x1.00424000001p+44, 0x0p+0 },
{ INT64_C(0x0000100428000000), 0x1.00428p+44, 0x0p+0 },
{ INT64_C(0xffffeffbd7ffffff), -0x1.00428000001p+44, 0x0p+0 },
{ INT64_C(0x0000100430000000), 0x1.0043p+44, 0x0p+0 },
{ INT64_C(0xffffeffbcfffffff), -0x1.00430000001p+44, 0x0p+0 },
{ INT64_C(0x0000100440000000), 0x1.0044p+44, 0x0p+0 },
{ INT64_C(0xffffeffbbfffffff), -0x1.00440000001p+44, 0x0p+0 },
{ INT64_C(0x0000100440000002), 0x1.00440000002p+44, 0x0p+0 },
{ INT64_C(0xffffeffbbffffffd), -0x1.00440000003p+44, 0x0p+0 },
{ INT64_C(0x0000100440000004), 0x1.00440000004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbbffffffb), -0x1.00440000005p+44, 0x0p+0 },
{ INT64_C(0x0000100440000040), 0x1.0044000004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbbfffffbf), -0x1.00440000041p+44, 0x0p+0 },
{ INT64_C(0x0000100440000400), 0x1.004400004p+44, 0x0p+0 },
{ INT64_C(0xffffeffbbffffbff), -0x1.00440000401p+44, 0x0p+0 },
{ INT64_C(0x0000100440001000), 0x1.00440001p+44, 0x0p+0 },
{ INT64_C(0xffffeffbbfffefff), -0x1.00440001001p+44, 0x0p+0 },
{ INT64_C(0x0000100440008000), 0x1.00440008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbbfff7fff), -0x1.00440008001p+44, 0x0p+0 },
{ INT64_C(0x0000100440080000), 0x1.0044008p+44, 0x0p+0 },
{ INT64_C(0xffffeffbbff7ffff), -0x1.00440080001p+44, 0x0p+0 },
{ INT64_C(0x0000100440200000), 0x1.004402p+44, 0x0p+0 },
{ INT64_C(0xffffeffbbfdfffff), -0x1.00440200001p+44, 0x0p+0 },
{ INT64_C(0x0000100441000000), 0x1.00441p+44, 0x0p+0 },
{ INT64_C(0xffffeffbbeffffff), -0x1.00441000001p+44, 0x0p+0 },
{ INT64_C(0x0000100450000000), 0x1.0045p+44, 0x0p+0 },
{ INT64_C(0xffffeffbafffffff), -0x1.00450000001p+44, 0x0p+0 },
{ INT64_C(0x0000100480000000), 0x1.0048p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7fffffff), -0x1.00480000001p+44, 0x0p+0 },
{ INT64_C(0x0000100480000004), 0x1.00480000004p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7ffffffb), -0x1.00480000005p+44, 0x0p+0 },
{ INT64_C(0x0000100480000008), 0x1.00480000008p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7ffffff7), -0x1.00480000009p+44, 0x0p+0 },
{ INT64_C(0x0000100480000020), 0x1.0048000002p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7fffffdf), -0x1.00480000021p+44, 0x0p+0 },
{ INT64_C(0x0000100480000200), 0x1.004800002p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7ffffdff), -0x1.00480000201p+44, 0x0p+0 },
{ INT64_C(0x0000100480000400), 0x1.004800004p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7ffffbff), -0x1.00480000401p+44, 0x0p+0 },
{ INT64_C(0x0000100480000800), 0x1.004800008p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7ffff7ff), -0x1.00480000801p+44, 0x0p+0 },
{ INT64_C(0x0000100480004000), 0x1.00480004p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7fffbfff), -0x1.00480004001p+44, 0x0p+0 },
{ INT64_C(0x0000100480008000), 0x1.00480008p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7fff7fff), -0x1.00480008001p+44, 0x0p+0 },
{ INT64_C(0x0000100480020000), 0x1.0048002p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7ffdffff), -0x1.00480020001p+44, 0x0p+0 },
{ INT64_C(0x0000100480080000), 0x1.0048008p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7ff7ffff), -0x1.00480080001p+44, 0x0p+0 },
{ INT64_C(0x0000100480100000), 0x1.004801p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7fefffff), -0x1.00480100001p+44, 0x0p+0 },
{ INT64_C(0x0000100480200000), 0x1.004802p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7fdfffff), -0x1.00480200001p+44, 0x0p+0 },
{ INT64_C(0x0000100480800000), 0x1.004808p+44, 0x0p+0 },
{ INT64_C(0xffffeffb7f7fffff), -0x1.00480800001p+44, 0x0p+0 },
{ INT64_C(0x0000100488000000), 0x1.00488p+44, 0x0p+0 },
{ INT64_C(0xffffeffb77ffffff), -0x1.00488000001p+44, 0x0p+0 },
{ INT64_C(0x0000100600000000), 0x1.006p+44, 0x0p+0 },
{ INT64_C(0xffffeff9ffffffff), -0x1.00600000001p+44, 0x0p+0 },
{ INT64_C(0x0000100600000008), 0x1.00600000008p+44, 0x0p+0 },
{ INT64_C(0xffffeff9fffffff7), -0x1.00600000009p+44, 0x0p+0 },
{ INT64_C(0x0000100600000040), 0x1.0060000004p+44, 0x0p+0 },
{ INT64_C(0xffffeff9ffffffbf), -0x1.00600000041p+44, 0x0p+0 },
{ INT64_C(0x0000100600000200), 0x1.006000002p+44, 0x0p+0 },
{ INT64_C(0xffffeff9fffffdff), -0x1.00600000201p+44, 0x0p+0 },
{ INT64_C(0x0000100600002000), 0x1.00600002p+44, 0x0p+0 },
{ INT64_C(0xffffeff9ffffdfff), -0x1.00600002001p+44, 0x0p+0 },
{ INT64_C(0x0000100600004000), 0x1.00600004p+44, 0x0p+0 },
{ INT64_C(0xffffeff9ffffbfff), -0x1.00600004001p+44, 0x0p+0 },
{ INT64_C(0x0000100600020000), 0x1.0060002p+44, 0x0p+0 },
{ INT64_C(0xffffeff9fffdffff), -0x1.00600020001p+44, 0x0p+0 },
{ INT64_C(0x0000100600200000), 0x1.006002p+44, 0x0p+0 },
{ INT64_C(0xffffeff9ffdfffff), -0x1.00600200001p+44, 0x0p+0 },
{ INT64_C(0x0000100601000000), 0x1.00601p+44, 0x0p+0 },
{ INT64_C(0xffffeff9feffffff), -0x1.00601000001p+44, 0x0p+0 },
{ INT64_C(0x0000100610000000), 0x1.0061p+44, 0x0p+0 },
{ INT64_C(0xffffeff9efffffff), -0x1.00610000001p+44, 0x0p+0 },
{ INT64_C(0x0000100640000000), 0x1.0064p+44, 0x0p+0 },
{ INT64_C(0xffffeff9bfffffff), -0x1.00640000001p+44, 0x0p+0 },
{ INT64_C(0x0000102000000004), 0x1.02000000004p+44, 0x0p+0 },
{ INT64_C(0xffffefdffffffffb), -0x1.02000000005p+44, 0x0p+0 },
{ INT64_C(0x0000102000000006), 0x1.02000000006p+44, 0x0p+0 },
{ INT64_C(0xffffefdffffffff9), -0x1.02000000007p+44, 0x0p+0 },
{ INT64_C(0x0000102000000040), 0x1.0200000004p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffffffbf), -0x1.02000000041p+44, 0x0p+0 },
{ INT64_C(0x0000102000000044), 0x1.02000000044p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffffffbb), -0x1.02000000045p+44, 0x0p+0 },
{ INT64_C(0x0000102000000100), 0x1.020000001p+44, 0x0p+0 },
{ INT64_C(0xffffefdffffffeff), -0x1.02000000101p+44, 0x0p+0 },
{ INT64_C(0x0000102000000104), 0x1.02000000104p+44, 0x0p+0 },
{ INT64_C(0xffffefdffffffefb), -0x1.02000000105p+44, 0x0p+0 },
{ INT64_C(0x0000102000000140), 0x1.0200000014p+44, 0x0p+0 },
{ INT64_C(0xffffefdffffffebf), -0x1.02000000141p+44, 0x0p+0 },
{ INT64_C(0x0000102000001000), 0x1.02000001p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffffefff), -0x1.02000001001p+44, 0x0p+0 },
{ INT64_C(0x0000102000001004), 0x1.02000001004p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffffeffb), -0x1.02000001005p+44, 0x0p+0 },
{ INT64_C(0x0000102000001008), 0x1.02000001008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffffeff7), -0x1.02000001009p+44, 0x0p+0 },
{ INT64_C(0x0000102000001080), 0x1.0200000108p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffffef7f), -0x1.02000001081p+44, 0x0p+0 },
{ INT64_C(0x0000102000001800), 0x1.020000018p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffffe7ff), -0x1.02000001801p+44, 0x0p+0 },
{ INT64_C(0x0000102000010000), 0x1.0200001p+44, 0x0p+0 },
{ INT64_C(0xffffefdffffeffff), -0x1.02000010001p+44, 0x0p+0 },
{ INT64_C(0x0000102000010001), 0x1.02000010001p+44, 0x0p+0 },
{ INT64_C(0xffffefdffffefffe), -0x1.02000010002p+44, 0x0p+0 },
{ INT64_C(0x0000102000010008), 0x1.02000010008p+44, 0x0p+0 },
{ INT64_C(0xffffefdffffefff7), -0x1.02000010009p+44, 0x0p+0 },
{ INT64_C(0x0000102000010020), 0x1.0200001002p+44, 0x0p+0 },
{ INT64_C(0xffffefdffffeffdf), -0x1.02000010021p+44, 0x0p+0 },
{ INT64_C(0x0000102000010200), 0x1.020000102p+44, 0x0p+0 },
{ INT64_C(0xffffefdffffefdff), -0x1.02000010201p+44, 0x0p+0 },
{ INT64_C(0x0000102000010800), 0x1.020000108p+44, 0x0p+0 },
{ INT64_C(0xffffefdffffef7ff), -0x1.02000010801p+44, 0x0p+0 },
{ INT64_C(0x0000102000018000), 0x1.02000018p+44, 0x0p+0 },
{ INT64_C(0xffffefdffffe7fff), -0x1.02000018001p+44, 0x0p+0 },
{ INT64_C(0x0000102000100000), 0x1.020001p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffefffff), -0x1.02000100001p+44, 0x0p+0 },
{ INT64_C(0x0000102000100004), 0x1.02000100004p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffeffffb), -0x1.02000100005p+44, 0x0p+0 },
{ INT64_C(0x0000102000100020), 0x1.0200010002p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffefffdf), -0x1.02000100021p+44, 0x0p+0 },
{ INT64_C(0x0000102000100080), 0x1.0200010008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffefff7f), -0x1.02000100081p+44, 0x0p+0 },
{ INT64_C(0x0000102000100800), 0x1.020001008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffeff7ff), -0x1.02000100801p+44, 0x0p+0 },
{ INT64_C(0x0000102000104000), 0x1.02000104p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffefbfff), -0x1.02000104001p+44, 0x0p+0 },
{ INT64_C(0x0000102000120000), 0x1.0200012p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffedffff), -0x1.02000120001p+44, 0x0p+0 },
{ INT64_C(0x0000102000140000), 0x1.0200014p+44, 0x0p+0 },
{ INT64_C(0xffffefdfffebffff), -0x1.02000140001p+44, 0x0p+0 },
{ INT64_C(0x0000102000800000), 0x1.020008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfff7fffff), -0x1.02000800001p+44, 0x0p+0 },
{ INT64_C(0x0000102000800001), 0x1.02000800001p+44, 0x0p+0 },
{ INT64_C(0xffffefdfff7ffffe), -0x1.02000800002p+44, 0x0p+0 },
{ INT64_C(0x0000102000800010), 0x1.0200080001p+44, 0x0p+0 },
{ INT64_C(0xffffefdfff7fffef), -0x1.02000800011p+44, 0x0p+0 },
{ INT64_C(0x0000102000800100), 0x1.020008001p+44, 0x0p+0 },
{ INT64_C(0xffffefdfff7ffeff), -0x1.02000800101p+44, 0x0p+0 },
{ INT64_C(0x0000102000800800), 0x1.020008008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfff7ff7ff), -0x1.02000800801p+44, 0x0p+0 },
{ INT64_C(0x0000102000802000), 0x1.02000802p+44, 0x0p+0 },
{ INT64_C(0xffffefdfff7fdfff), -0x1.02000802001p+44, 0x0p+0 },
{ INT64_C(0x0000102000804000), 0x1.02000804p+44, 0x0p+0 },
{ INT64_C(0xffffefdfff7fbfff), -0x1.02000804001p+44, 0x0p+0 },
{ INT64_C(0x0000102000810000), 0x1.0200081p+44, 0x0p+0 },
{ INT64_C(0xffffefdfff7effff), -0x1.02000810001p+44, 0x0p+0 },
{ INT64_C(0x0000102000880000), 0x1.0200088p+44, 0x0p+0 },
{ INT64_C(0xffffefdfff77ffff), -0x1.02000880001p+44, 0x0p+0 },
{ INT64_C(0x0000102000a00000), 0x1.02000ap+44, 0x0p+0 },
{ INT64_C(0xffffefdfff5fffff), -0x1.02000a00001p+44, 0x0p+0 },
{ INT64_C(0x0000102004000000), 0x1.02004p+44, 0x0p+0 },
{ INT64_C(0xffffefdffbffffff), -0x1.02004000001p+44, 0x0p+0 },
{ INT64_C(0x0000102004000008), 0x1.02004000008p+44, 0x0p+0 },
{ INT64_C(0xffffefdffbfffff7), -0x1.02004000009p+44, 0x0p+0 },
{ INT64_C(0x0000102004000020), 0x1.0200400002p+44, 0x0p+0 },
{ INT64_C(0xffffefdffbffffdf), -0x1.02004000021p+44, 0x0p+0 },
{ INT64_C(0x0000102004000080), 0x1.0200400008p+44, 0x0p+0 },
{ INT64_C(0xffffefdffbffff7f), -0x1.02004000081p+44, 0x0p+0 },
{ INT64_C(0x0000102004000200), 0x1.020040002p+44, 0x0p+0 },
{ INT64_C(0xffffefdffbfffdff), -0x1.02004000201p+44, 0x0p+0 },
{ INT64_C(0x0000102004000800), 0x1.020040008p+44, 0x0p+0 },
{ INT64_C(0xffffefdffbfff7ff), -0x1.02004000801p+44, 0x0p+0 },
{ INT64_C(0x0000102004008000), 0x1.02004008p+44, 0x0p+0 },
{ INT64_C(0xffffefdffbff7fff), -0x1.02004008001p+44, 0x0p+0 },
{ INT64_C(0x0000102004040000), 0x1.0200404p+44, 0x0p+0 },
{ INT64_C(0xffffefdffbfbffff), -0x1.02004040001p+44, 0x0p+0 },
{ INT64_C(0x0000102004200000), 0x1.020042p+44, 0x0p+0 },
{ INT64_C(0xffffefdffbdfffff), -0x1.02004200001p+44, 0x0p+0 },
{ INT64_C(0x0000102006000000), 0x1.02006p+44, 0x0p+0 },
{ INT64_C(0xffffefdff9ffffff), -0x1.02006000001p+44, 0x0p+0 },
{ INT64_C(0x0000102010000000), 0x1.0201p+44, 0x0p+0 },
{ INT64_C(0xffffefdfefffffff), -0x1.02010000001p+44, 0x0p+0 },
{ INT64_C(0x0000102010000004), 0x1.02010000004p+44, 0x0p+0 },
{ INT64_C(0xffffefdfeffffffb), -0x1.02010000005p+44, 0x0p+0 },
{ INT64_C(0x0000102010000008), 0x1.02010000008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfeffffff7), -0x1.02010000009p+44, 0x0p+0 },
{ INT64_C(0x0000102010000040), 0x1.0201000004p+44, 0x0p+0 },
{ INT64_C(0xffffefdfefffffbf), -0x1.02010000041p+44, 0x0p+0 },
{ INT64_C(0x0000102010000100), 0x1.020100001p+44, 0x0p+0 },
{ INT64_C(0xffffefdfeffffeff), -0x1.02010000101p+44, 0x0p+0 },
{ INT64_C(0x0000102010000200), 0x1.020100002p+44, 0x0p+0 },
{ INT64_C(0xffffefdfeffffdff), -0x1.02010000201p+44, 0x0p+0 },
{ INT64_C(0x0000102010000800), 0x1.020100008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfeffff7ff), -0x1.02010000801p+44, 0x0p+0 },
{ INT64_C(0x0000102010004000), 0x1.02010004p+44, 0x0p+0 },
{ INT64_C(0xffffefdfefffbfff), -0x1.02010004001p+44, 0x0p+0 },
{ INT64_C(0x0000102010040000), 0x1.0201004p+44, 0x0p+0 },
{ INT64_C(0xffffefdfeffbffff), -0x1.02010040001p+44, 0x0p+0 },
{ INT64_C(0x0000102010400000), 0x1.020104p+44, 0x0p+0 },
{ INT64_C(0xffffefdfefbfffff), -0x1.02010400001p+44, 0x0p+0 },
{ INT64_C(0x0000102011000000), 0x1.02011p+44, 0x0p+0 },
{ INT64_C(0xffffefdfeeffffff), -0x1.02011000001p+44, 0x0p+0 },
{ INT64_C(0x0000102020000000), 0x1.0202p+44, 0x0p+0 },
{ INT64_C(0xffffefdfdfffffff), -0x1.02020000001p+44, 0x0p+0 },
{ INT64_C(0x0000102020000008), 0x1.02020000008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfdffffff7), -0x1.02020000009p+44, 0x0p+0 },
{ INT64_C(0x0000102020000010), 0x1.0202000001p+44, 0x0p+0 },
{ INT64_C(0xffffefdfdfffffef), -0x1.02020000011p+44, 0x0p+0 },
{ INT64_C(0x0000102020000040), 0x1.0202000004p+44, 0x0p+0 },
{ INT64_C(0xffffefdfdfffffbf), -0x1.02020000041p+44, 0x0p+0 },
{ INT64_C(0x0000102020000080), 0x1.0202000008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfdfffff7f), -0x1.02020000081p+44, 0x0p+0 },
{ INT64_C(0x0000102020000800), 0x1.020200008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfdffff7ff), -0x1.02020000801p+44, 0x0p+0 },
{ INT64_C(0x0000102020008000), 0x1.02020008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfdfff7fff), -0x1.02020008001p+44, 0x0p+0 },
{ INT64_C(0x0000102020020000), 0x1.0202002p+44, 0x0p+0 },
{ INT64_C(0xffffefdfdffdffff), -0x1.02020020001p+44, 0x0p+0 },
{ INT64_C(0x0000102020200000), 0x1.020202p+44, 0x0p+0 },
{ INT64_C(0xffffefdfdfdfffff), -0x1.02020200001p+44, 0x0p+0 },
{ INT64_C(0x0000102021000000), 0x1.02021p+44, 0x0p+0 },
{ INT64_C(0xffffefdfdeffffff), -0x1.02021000001p+44, 0x0p+0 },
{ INT64_C(0x0000102028000000), 0x1.02028p+44, 0x0p+0 },
{ INT64_C(0xffffefdfd7ffffff), -0x1.02028000001p+44, 0x0p+0 },
{ INT64_C(0x0000102030000000), 0x1.0203p+44, 0x0p+0 },
{ INT64_C(0xffffefdfcfffffff), -0x1.02030000001p+44, 0x0p+0 },
{ INT64_C(0x0000102040000000), 0x1.0204p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbfffffff), -0x1.02040000001p+44, 0x0p+0 },
{ INT64_C(0x0000102040000001), 0x1.02040000001p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbffffffe), -0x1.02040000002p+44, 0x0p+0 },
{ INT64_C(0x0000102040000010), 0x1.0204000001p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbfffffef), -0x1.02040000011p+44, 0x0p+0 },
{ INT64_C(0x0000102040000020), 0x1.0204000002p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbfffffdf), -0x1.02040000021p+44, 0x0p+0 },
{ INT64_C(0x0000102040000040), 0x1.0204000004p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbfffffbf), -0x1.02040000041p+44, 0x0p+0 },
{ INT64_C(0x0000102040000080), 0x1.0204000008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbfffff7f), -0x1.02040000081p+44, 0x0p+0 },
{ INT64_C(0x0000102040000800), 0x1.020400008p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbffff7ff), -0x1.02040000801p+44, 0x0p+0 },
{ INT64_C(0x0000102040001000), 0x1.02040001p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbfffefff), -0x1.02040001001p+44, 0x0p+0 },
{ INT64_C(0x0000102040002000), 0x1.02040002p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbfffdfff), -0x1.02040002001p+44, 0x0p+0 },
{ INT64_C(0x0000102040020000), 0x1.0204002p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbffdffff), -0x1.02040020001p+44, 0x0p+0 },
{ INT64_C(0x0000102040100000), 0x1.020401p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbfefffff), -0x1.02040100001p+44, 0x0p+0 },
{ INT64_C(0x0000102041000000), 0x1.02041p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbeffffff), -0x1.02041000001p+44, 0x0p+0 },
{ INT64_C(0x0000102042000000), 0x1.02042p+44, 0x0p+0 },
{ INT64_C(0xffffefdfbdffffff), -0x1.02042000001p+44, 0x0p+0 },
{ INT64_C(0x0000102060000000), 0x1.0206p+44, 0x0p+0 },
{ INT64_C(0xffffefdf9fffffff), -0x1.02060000001p+44, 0x0p+0 },
{ INT64_C(0x0000102080000000), 0x1.0208p+44, 0x0p+0 },
{ INT64_C(0xffffefdf7fffffff), -0x1.02080000001p+44, 0x0p+0 },
{ INT64_C(0x0000102080000004), 0x1.02080000004p+44, 0x0p+0 },
{ INT64_C(0xffffefdf7ffffffb), -0x1.02080000005p+44, 0x0p+0 },
{ INT64_C(0x0000102080000010), 0x1.0208000001p+44, 0x0p+0 },
{ INT64_C(0xffffefdf7fffffef), -0x1.02080000011p+44, 0x0p+0 },
{ INT64_C(0x0000102080000020), 0x1.0208000002p+44, 0x0p+0 },
{ INT64_C(0xffffefdf7fffffdf), -0x1.02080000021p+44, 0x0p+0 },
{ INT64_C(0x0000102080000100), 0x1.020800001p+44, 0x0p+0 },
{ INT64_C(0xffffefdf7ffffeff), -0x1.02080000101p+44, 0x0p+0 },
{ INT64_C(0x0000102080000800), 0x1.020800008p+44, 0x0p+0 },
{ INT64_C(0xffffefdf7ffff7ff), -0x1.02080000801p+44, 0x0p+0 },
{ INT64_C(0x0000102080008000), 0x1.02080008p+44, 0x0p+0 },
{ INT64_C(0xffffefdf7fff7fff), -0x1.02080008001p+44, 0x0p+0 },
{ INT64_C(0x0000102080020000), 0x1.0208002p+44, 0x0p+0 },
{ INT64_C(0xffffefdf7ffdffff), -0x1.02080020001p+44, 0x0p+0 },
{ INT64_C(0x0000102080200000), 0x1.020802p+44, 0x0p+0 },
{ INT64_C(0xffffefdf7fdfffff), -0x1.02080200001p+44, 0x0p+0 },
{ INT64_C(0x0000102080800000), 0x1.020808p+44, 0x0p+0 },
{ INT64_C(0xffffefdf7f7fffff), -0x1.02080800001p+44, 0x0p+0 },
{ INT64_C(0x0000102081000000), 0x1.02081p+44, 0x0p+0 },
{ INT64_C(0xffffefdf7effffff), -0x1.02081000001p+44, 0x0p+0 },
{ INT64_C(0x0000102090000000), 0x1.0209p+44, 0x0p+0 },
{ INT64_C(0xffffefdf6fffffff), -0x1.02090000001p+44, 0x0p+0 },
{ INT64_C(0x00001020a0000000), 0x1.020ap+44, 0x0p+0 },
{ INT64_C(0xffffefdf5fffffff), -0x1.020a0000001p+44, 0x0p+0 },
{ INT64_C(0x0000102100000000), 0x1.021p+44, 0x0p+0 },
{ INT64_C(0xffffefdeffffffff), -0x1.02100000001p+44, 0x0p+0 },
{ INT64_C(0x0000102100000002), 0x1.02100000002p+44, 0x0p+0 },
{ INT64_C(0xffffefdefffffffd), -0x1.02100000003p+44, 0x0p+0 },
{ INT64_C(0x0000102100000008), 0x1.02100000008p+44, 0x0p+0 },
{ INT64_C(0xffffefdefffffff7), -0x1.02100000009p+44, 0x0p+0 },
{ INT64_C(0x0000102100000020), 0x1.0210000002p+44, 0x0p+0 },
{ INT64_C(0xffffefdeffffffdf), -0x1.02100000021p+44, 0x0p+0 },
{ INT64_C(0x0000102100000100), 0x1.021000001p+44, 0x0p+0 },
{ INT64_C(0xffffefdefffffeff), -0x1.02100000101p+44, 0x0p+0 },
{ INT64_C(0x0000102100000400), 0x1.021000004p+44, 0x0p+0 },
{ INT64_C(0xffffefdefffffbff), -0x1.02100000401p+44, 0x0p+0 },
{ INT64_C(0x0000102100000800), 0x1.021000008p+44, 0x0p+0 },
{ INT64_C(0xffffefdefffff7ff), -0x1.02100000801p+44, 0x0p+0 },
{ INT64_C(0x0000102100004000), 0x1.02100004p+44, 0x0p+0 },
{ INT64_C(0xffffefdeffffbfff), -0x1.02100004001p+44, 0x0p+0 },
{ INT64_C(0x0000102100010000), 0x1.0210001p+44, 0x0p+0 },
{ INT64_C(0xffffefdefffeffff), -0x1.02100010001p+44, 0x0p+0 },
{ INT64_C(0x0000102100080000), 0x1.0210008p+44, 0x0p+0 },
{ INT64_C(0xffffefdefff7ffff), -0x1.02100080001p+44, 0x0p+0 },
{ INT64_C(0x0000102100200000), 0x1.021002p+44, 0x0p+0 },
{ INT64_C(0xffffefdeffdfffff), -0x1.02100200001p+44, 0x0p+0 },
{ INT64_C(0x0000102100400000), 0x1.021004p+44, 0x0p+0 },
{ INT64_C(0xffffefdeffbfffff), -0x1.02100400001p+44, 0x0p+0 },
{ INT64_C(0x0000102102000000), 0x1.02102p+44, 0x0p+0 },
{ INT64_C(0xffffefdefdffffff), -0x1.02102000001p+44, 0x0p+0 },
{ INT64_C(0x0000102104000000), 0x1.02104p+44, 0x0p+0 },
{ INT64_C(0xffffefdefbffffff), -0x1.02104000001p+44, 0x0p+0 },
{ INT64_C(0x0000102140000000), 0x1.0214p+44, 0x0p+0 },
{ INT64_C(0xffffefdebfffffff), -0x1.02140000001p+44, 0x0p+0 },
{ INT64_C(0x0000102800000000), 0x1.028p+44, 0x0p+0 },
{ INT64_C(0xffffefd7ffffffff), -0x1.02800000001p+44, 0x0p+0 },
{ INT64_C(0x0000102800000002), 0x1.02800000002p+44, 0x0p+0 },
{ INT64_C(0xffffefd7fffffffd), -0x1.02800000003p+44, 0x0p+0 },
{ INT64_C(0x0000102800000004), 0x1.02800000004p+44, 0x0p+0 },
{ INT64_C(0xffffefd7fffffffb), -0x1.02800000005p+44, 0x0p+0 },
{ INT64_C(0x0000102800000040), 0x1.0280000004p+44, 0x0p+0 },
{ INT64_C(0xffffefd7ffffffbf), -0x1.02800000041p+44, 0x0p+0 },
{ INT64_C(0x0000102800000200), 0x1.028000002p+44, 0x0p+0 },
{ INT64_C(0xffffefd7fffffdff), -0x1.02800000201p+44, 0x0p+0 },
{ INT64_C(0x0000102800000400), 0x1.028000004p+44, 0x0p+0 },
{ INT64_C(0xffffefd7fffffbff), -0x1.02800000401p+44, 0x0p+0 },
{ INT64_C(0x0000102800004000), 0x1.02800004p+44, 0x0p+0 },
{ INT64_C(0xffffefd7ffffbfff), -0x1.02800004001p+44, 0x0p+0 },
{ INT64_C(0x0000102800040000), 0x1.0280004p+44, 0x0p+0 },
{ INT64_C(0xffffefd7fffbffff), -0x1.02800040001p+44, 0x0p+0 },
{ INT64_C(0x0000102800080000), 0x1.0280008p+44, 0x0p+0 },
{ INT64_C(0xffffefd7fff7ffff), -0x1.02800080001p+44, 0x0p+0 },
{ INT64_C(0x0000102800800000), 0x1.028008p+44, 0x0p+0 },
{ INT64_C(0xffffefd7ff7fffff), -0x1.02800800001p+44, 0x0p+0 },
{ INT64_C(0x0000102804000000), 0x1.02804p+44, 0x0p+0 },
{ INT64_C(0xffffefd7fbffffff), -0x1.02804000001p+44, 0x0p+0 },
{ INT64_C(0x0000102810000000), 0x1.0281p+44, 0x0p+0 },
{ INT64_C(0xffffefd7efffffff), -0x1.02810000001p+44, 0x0p+0 },
{ INT64_C(0x0000102840000000), 0x1.0284p+44, 0x0p+0 },
{ INT64_C(0xffffefd7bfffffff), -0x1.02840000001p+44, 0x0p+0 },
{ INT64_C(0x0000102900000000), 0x1.029p+44, 0x0p+0 },
{ INT64_C(0xffffefd6ffffffff), -0x1.02900000001p+44, 0x0p+0 },
{ INT64_C(0x0000102c00000000), 0x1.02cp+44, 0x0p+0 },
{ INT64_C(0xffffefd3ffffffff), -0x1.02c00000001p+44, 0x0p+0 },
{ INT64_C(0x0000110000000004), 0x1.10000000004p+44, 0x0p+0 },
{ INT64_C(0xffffeefffffffffb), -0x1.10000000005p+44, 0x0p+0 },
{ INT64_C(0x0000110000000005), 0x1.10000000005p+44, 0x0p+0 },
{ INT64_C(0xffffeefffffffffa), -0x1.10000000006p+44, 0x0p+0 },
{ INT64_C(0x0000110000000006), 0x1.10000000006p+44, 0x0p+0 },
{ INT64_C(0xffffeefffffffff9), -0x1.10000000007p+44, 0x0p+0 },
{ INT64_C(0x0000110000000010), 0x1.1000000001p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffffffef), -0x1.10000000011p+44, 0x0p+0 },
{ INT64_C(0x0000110000000014), 0x1.10000000014p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffffffeb), -0x1.10000000015p+44, 0x0p+0 },
{ INT64_C(0x0000110000000018), 0x1.10000000018p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffffffe7), -0x1.10000000019p+44, 0x0p+0 },
{ INT64_C(0x0000110000000100), 0x1.100000001p+44, 0x0p+0 },
{ INT64_C(0xffffeefffffffeff), -0x1.10000000101p+44, 0x0p+0 },
{ INT64_C(0x0000110000000104), 0x1.10000000104p+44, 0x0p+0 },
{ INT64_C(0xffffeefffffffefb), -0x1.10000000105p+44, 0x0p+0 },
{ INT64_C(0x0000110000000110), 0x1.1000000011p+44, 0x0p+0 },
{ INT64_C(0xffffeefffffffeef), -0x1.10000000111p+44, 0x0p+0 },
{ INT64_C(0x0000110000000140), 0x1.1000000014p+44, 0x0p+0 },
{ INT64_C(0xffffeefffffffebf), -0x1.10000000141p+44, 0x0p+0 },
{ INT64_C(0x0000110000000180), 0x1.1000000018p+44, 0x0p+0 },
{ INT64_C(0xffffeefffffffe7f), -0x1.10000000181p+44, 0x0p+0 },
{ INT64_C(0x0000110000001000), 0x1.10000001p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffffefff), -0x1.10000001001p+44, 0x0p+0 },
{ INT64_C(0x0000110000001001), 0x1.10000001001p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffffeffe), -0x1.10000001002p+44, 0x0p+0 },
{ INT64_C(0x0000110000001008), 0x1.10000001008p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffffeff7), -0x1.10000001009p+44, 0x0p+0 },
{ INT64_C(0x0000110000001040), 0x1.1000000104p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffffefbf), -0x1.10000001041p+44, 0x0p+0 },
{ INT64_C(0x0000110000001400), 0x1.100000014p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffffebff), -0x1.10000001401p+44, 0x0p+0 },
{ INT64_C(0x0000110000008000), 0x1.10000008p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffff7fff), -0x1.10000008001p+44, 0x0p+0 },
{ INT64_C(0x0000110000008002), 0x1.10000008002p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffff7ffd), -0x1.10000008003p+44, 0x0p+0 },
{ INT64_C(0x0000110000008020), 0x1.1000000802p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffff7fdf), -0x1.10000008021p+44, 0x0p+0 },
{ INT64_C(0x0000110000008040), 0x1.1000000804p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffff7fbf), -0x1.10000008041p+44, 0x0p+0 },
{ INT64_C(0x0000110000008080), 0x1.1000000808p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffff7f7f), -0x1.10000008081p+44, 0x0p+0 },
{ INT64_C(0x0000110000008100), 0x1.100000081p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffff7eff), -0x1.10000008101p+44, 0x0p+0 },
{ INT64_C(0x0000110000008400), 0x1.100000084p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffff7bff), -0x1.10000008401p+44, 0x0p+0 },
{ INT64_C(0x0000110000009000), 0x1.10000009p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffff6fff), -0x1.10000009001p+44, 0x0p+0 },
{ INT64_C(0x0000110000080000), 0x1.1000008p+44, 0x0p+0 },
{ INT64_C(0xffffeefffff7ffff), -0x1.10000080001p+44, 0x0p+0 },
{ INT64_C(0x0000110000080001), 0x1.10000080001p+44, 0x0p+0 },
{ INT64_C(0xffffeefffff7fffe), -0x1.10000080002p+44, 0x0p+0 },
{ INT64_C(0x0000110000080010), 0x1.1000008001p+44, 0x0p+0 },
{ INT64_C(0xffffeefffff7ffef), -0x1.10000080011p+44, 0x0p+0 },
{ INT64_C(0x0000110000080100), 0x1.100000801p+44, 0x0p+0 },
{ INT64_C(0xffffeefffff7feff), -0x1.10000080101p+44, 0x0p+0 },
{ INT64_C(0x0000110000080800), 0x1.100000808p+44, 0x0p+0 },
{ INT64_C(0xffffeefffff7f7ff), -0x1.10000080801p+44, 0x0p+0 },
{ INT64_C(0x0000110000082000), 0x1.10000082p+44, 0x0p+0 },
{ INT64_C(0xffffeefffff7dfff), -0x1.10000082001p+44, 0x0p+0 },
{ INT64_C(0x0000110000090000), 0x1.1000009p+44, 0x0p+0 },
{ INT64_C(0xffffeefffff6ffff), -0x1.10000090001p+44, 0x0p+0 },
{ INT64_C(0x0000110000100000), 0x1.100001p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffefffff), -0x1.10000100001p+44, 0x0p+0 },
{ INT64_C(0x0000110000100002), 0x1.10000100002p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffeffffd), -0x1.10000100003p+44, 0x0p+0 },
{ INT64_C(0x0000110000100020), 0x1.1000010002p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffefffdf), -0x1.10000100021p+44, 0x0p+0 },
{ INT64_C(0x0000110000100200), 0x1.100001002p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffeffdff), -0x1.10000100201p+44, 0x0p+0 },
{ INT64_C(0x0000110000101000), 0x1.10000101p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffefefff), -0x1.10000101001p+44, 0x0p+0 },
{ INT64_C(0x0000110000108000), 0x1.10000108p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffef7fff), -0x1.10000108001p+44, 0x0p+0 },
{ INT64_C(0x0000110000140000), 0x1.1000014p+44, 0x0p+0 },
{ INT64_C(0xffffeeffffebffff), -0x1.10000140001p+44, 0x0p+0 },
{ INT64_C(0x0000110000800000), 0x1.100008p+44, 0x0p+0 },
{ INT64_C(0xffffeeffff7fffff), -0x1.10000800001p+44, 0x0p+0 },
{ INT64_C(0x0000110000800001), 0x1.10000800001p+44, 0x0p+0 },
{ INT64_C(0xffffeeffff7ffffe), -0x1.10000800002p+44, 0x0p+0 },
{ INT64_C(0x0000110000800010), 0x1.1000080001p+44, 0x0p+0 },
{ INT64_C(0xffffeeffff7fffef), -0x1.10000800011p+44, 0x0p+0 },
{ INT64_C(0x0000110000800100), 0x1.100008001p+44, 0x0p+0 },
{ INT64_C(0xffffeeffff7ffeff), -0x1.10000800101p+44, 0x0p+0 },
{ INT64_C(0x0000110000801000), 0x1.10000801p+44, 0x0p+0 },
{ INT64_C(0xffffeeffff7fefff), -0x1.10000801001p+44, 0x0p+0 },
{ INT64_C(0x0000110000802000), 0x1.10000802p+44, 0x0p+0 },
{ INT64_C(0xffffeeffff7fdfff), -0x1.10000802001p+44, 0x0p+0 },
{ INT64_C(0x0000110000820000), 0x1.1000082p+44, 0x0p+0 },
{ INT64_C(0xffffeeffff7dffff), -0x1.10000820001p+44, 0x0p+0 },
{ INT64_C(0x0000110000a00000), 0x1.10000ap+44, 0x0p+0 },
{ INT64_C(0xffffeeffff5fffff), -0x1.10000a00001p+44, 0x0p+0 },
{ INT64_C(0x0000110008000000), 0x1.10008p+44, 0x0p+0 },
{ INT64_C(0xffffeefff7ffffff), -0x1.10008000001p+44, 0x0p+0 },
{ INT64_C(0x0000110008000001), 0x1.10008000001p+44, 0x0p+0 },
{ INT64_C(0xffffeefff7fffffe), -0x1.10008000002p+44, 0x0p+0 },
{ INT64_C(0x0000110008000002), 0x1.10008000002p+44, 0x0p+0 },
{ INT64_C(0xffffeefff7fffffd), -0x1.10008000003p+44, 0x0p+0 },
{ INT64_C(0x0000110008000008), 0x1.10008000008p+44, 0x0p+0 },
{ INT64_C(0xffffeefff7fffff7), -0x1.10008000009p+44, 0x0p+0 },
{ INT64_C(0x0000110008000040), 0x1.1000800004p+44, 0x0p+0 },
{ INT64_C(0xffffeefff7ffffbf), -0x1.10008000041p+44, 0x0p+0 },
{ INT64_C(0x0000110008000200), 0x1.100080002p+44, 0x0p+0 },
{ INT64_C(0xffffeefff7fffdff), -0x1.10008000201p+44, 0x0p+0 },
{ INT64_C(0x0000110008000800), 0x1.100080008p+44, 0x0p+0 },
{ INT64_C(0xffffeefff7fff7ff), -0x1.10008000801p+44, 0x0p+0 },
{ INT64_C(0x0000110008002000), 0x1.10008002p+44, 0x0p+0 },
{ INT64_C(0xffffeefff7ffdfff), -0x1.10008002001p+44, 0x0p+0 },
{ INT64_C(0x0000110008004000), 0x1.10008004p+44, 0x0p+0 },
{ INT64_C(0xffffeefff7ffbfff), -0x1.10008004001p+44, 0x0p+0 },
{ INT64_C(0x0000110008010000), 0x1.1000801p+44, 0x0p+0 },
{ INT64_C(0xffffeefff7feffff), -0x1.10008010001p+44, 0x0p+0 },
{ INT64_C(0x0000110008080000), 0x1.1000808p+44, 0x0p+0 },
{ INT64_C(0xffffeefff7f7ffff), -0x1.10008080001p+44, 0x0p+0 },
{ INT64_C(0x0000110008800000), 0x1.100088p+44, 0x0p+0 },
{ INT64_C(0xffffeefff77fffff), -0x1.10008800001p+44, 0x0p+0 },
{ INT64_C(0x000011000c000000), 0x1.1000cp+44, 0x0p+0 },
{ INT64_C(0xffffeefff3ffffff), -0x1.1000c000001p+44, 0x0p+0 },
{ INT64_C(0x0000110010000000), 0x1.1001p+44, 0x0p+0 },
{ INT64_C(0xffffeeffefffffff), -0x1.10010000001p+44, 0x0p+0 },
{ INT64_C(0x0000110010000008), 0x1.10010000008p+44, 0x0p+0 },
{ INT64_C(0xffffeeffeffffff7), -0x1.10010000009p+44, 0x0p+0 },
{ INT64_C(0x0000110010000010), 0x1.1001000001p+44, 0x0p+0 },
{ INT64_C(0xffffeeffefffffef), -0x1.10010000011p+44, 0x0p+0 },
{ INT64_C(0x0000110010000080), 0x1.1001000008p+44, 0x0p+0 },
{ INT64_C(0xffffeeffefffff7f), -0x1.10010000081p+44, 0x0p+0 },
{ INT64_C(0x0000110010000200), 0x1.100100002p+44, 0x0p+0 },
{ INT64_C(0xffffeeffeffffdff), -0x1.10010000201p+44, 0x0p+0 },
{ INT64_C(0x0000110010002000), 0x1.10010002p+44, 0x0p+0 },
{ INT64_C(0xffffeeffefffdfff), -0x1.10010002001p+44, 0x0p+0 },
{ INT64_C(0x0000110010020000), 0x1.1001002p+44, 0x0p+0 },
{ INT64_C(0xffffeeffeffdffff), -0x1.10010020001p+44, 0x0p+0 },
{ INT64_C(0x0000110010100000), 0x1.100101p+44, 0x0p+0 },
{ INT64_C(0xffffeeffefefffff), -0x1.10010100001p+44, 0x0p+0 },
{ INT64_C(0x0000110010400000), 0x1.100104p+44, 0x0p+0 },
{ INT64_C(0xffffeeffefbfffff), -0x1.10010400001p+44, 0x0p+0 },
{ INT64_C(0x0000110012000000), 0x1.10012p+44, 0x0p+0 },
{ INT64_C(0xffffeeffedffffff), -0x1.10012000001p+44, 0x0p+0 },
{ INT64_C(0x0000110018000000), 0x1.10018p+44, 0x0p+0 },
{ INT64_C(0xffffeeffe7ffffff), -0x1.10018000001p+44, 0x0p+0 },
{ INT64_C(0x0000110040000000), 0x1.1004p+44, 0x0p+0 },
{ INT64_C(0xffffeeffbfffffff), -0x1.10040000001p+44, 0x0p+0 },
{ INT64_C(0x0000110040000008), 0x1.10040000008p+44, 0x0p+0 },
{ INT64_C(0xffffeeffbffffff7), -0x1.10040000009p+44, 0x0p+0 },
{ INT64_C(0x0000110040000020), 0x1.1004000002p+44, 0x0p+0 },
{ INT64_C(0xffffeeffbfffffdf), -0x1.10040000021p+44, 0x0p+0 },
{ INT64_C(0x0000110040000040), 0x1.1004000004p+44, 0x0p+0 },
{ INT64_C(0xffffeeffbfffffbf), -0x1.10040000041p+44, 0x0p+0 },
{ INT64_C(0x0000110040000200), 0x1.100400002p+44, 0x0p+0 },
{ INT64_C(0xffffeeffbffffdff), -0x1.10040000201p+44, 0x0p+0 },
{ INT64_C(0x0000110040002000), 0x1.10040002p+44, 0x0p+0 },
{ INT64_C(0xffffeeffbfffdfff), -0x1.10040002001p+44, 0x0p+0 },
{ INT64_C(0x0000110040008000), 0x1.10040008p+44, 0x0p+0 },
{ INT64_C(0xffffeeffbfff7fff), -0x1.10040008001p+44, 0x0p+0 },
{ INT64_C(0x0000110040040000), 0x1.1004004p+44, 0x0p+0 },
{ INT64_C(0xffffeeffbffbffff), -0x1.10040040001p+44, 0x0p+0 },
{ INT64_C(0x0000110040080000), 0x1.1004008p+44, 0x0p+0 },
{ INT64_C(0xffffeeffbff7ffff), -0x1.10040080001p+44, 0x0p+0 },
{ INT64_C(0x0000110040800000), 0x1.100408p+44, 0x0p+0 },
{ INT64_C(0xffffeeffbf7fffff), -0x1.10040800001p+44, 0x0p+0 },
{ INT64_C(0x0000110044000000), 0x1.10044p+44, 0x0p+0 },
{ INT64_C(0xffffeeffbbffffff), -0x1.10044000001p+44, 0x0p+0 },
{ INT64_C(0x0000110048000000), 0x1.10048p+44, 0x0p+0 },
{ INT64_C(0xffffeeffb7ffffff), -0x1.10048000001p+44, 0x0p+0 },
{ INT64_C(0x0000110060000000), 0x1.1006p+44, 0x0p+0 },
{ INT64_C(0xffffeeff9fffffff), -0x1.10060000001p+44, 0x0p+0 },
{ INT64_C(0x0000110080000000), 0x1.1008p+44, 0x0p+0 },
{ INT64_C(0xffffeeff7fffffff), -0x1.10080000001p+44, 0x0p+0 },
{ INT64_C(0x0000110080000001), 0x1.10080000001p+44, 0x0p+0 },
{ INT64_C(0xffffeeff7ffffffe), -0x1.10080000002p+44, 0x0p+0 },
{ INT64_C(0x0000110080000008), 0x1.10080000008p+44, 0x0p+0 },
{ INT64_C(0xffffeeff7ffffff7), -0x1.10080000009p+44, 0x0p+0 },
{ INT64_C(0x0000110080000040), 0x1.1008000004p+44, 0x0p+0 },
{ INT64_C(0xffffeeff7fffffbf), -0x1.10080000041p+44, 0x0p+0 },
{ INT64_C(0x0000110080000080), 0x1.1008000008p+44, 0x0p+0 },
{ INT64_C(0xffffeeff7fffff7f), -0x1.10080000081p+44, 0x0p+0 },
{ INT64_C(0x0000110080000200), 0x1.100800002p+44, 0x0p+0 },
{ INT64_C(0xffffeeff7ffffdff), -0x1.10080000201p+44, 0x0p+0 },
{ INT64_C(0x0000110080002000), 0x1.10080002p+44, 0x0p+0 },
{ INT64_C(0xffffeeff7fffdfff), -0x1.10080002001p+44, 0x0p+0 },
{ INT64_C(0x0000110080010000), 0x1.1008001p+44, 0x0p+0 },
{ INT64_C(0xffffeeff7ffeffff), -0x1.10080010001p+44, 0x0p+0 },
{ INT64_C(0x0000110080100000), 0x1.100801p+44, 0x0p+0 },
{ INT64_C(0xffffeeff7fefffff), -0x1.10080100001p+44, 0x0p+0 },
{ INT64_C(0x0000110080400000), 0x1.100804p+44, 0x0p+0 },
{ INT64_C(0xffffeeff7fbfffff), -0x1.10080400001p+44, 0x0p+0 },
{ INT64_C(0x0000110081000000), 0x1.10081p+44, 0x0p+0 },
{ INT64_C(0xffffeeff7effffff), -0x1.10081000001p+44, 0x0p+0 },
{ INT64_C(0x0000110088000000), 0x1.10088p+44, 0x0p+0 },
{ INT64_C(0xffffeeff77ffffff), -0x1.10088000001p+44, 0x0p+0 },
{ INT64_C(0x00001100c0000000), 0x1.100cp+44, 0x0p+0 },
{ INT64_C(0xffffeeff3fffffff), -0x1.100c0000001p+44, 0x0p+0 },
{ INT64_C(0x0000110400000000), 0x1.104p+44, 0x0p+0 },
{ INT64_C(0xffffeefbffffffff), -0x1.10400000001p+44, 0x0p+0 },
{ INT64_C(0x0000110400000004), 0x1.10400000004p+44, 0x0p+0 },
{ INT64_C(0xffffeefbfffffffb), -0x1.10400000005p+44, 0x0p+0 },
{ INT64_C(0x0000110400000040), 0x1.1040000004p+44, 0x0p+0 },
{ INT64_C(0xffffeefbffffffbf), -0x1.10400000041p+44, 0x0p+0 },
{ INT64_C(0x0000110400000080), 0x1.1040000008p+44, 0x0p+0 },
{ INT64_C(0xffffeefbffffff7f), -0x1.10400000081p+44, 0x0p+0 },
{ INT64_C(0x0000110400000200), 0x1.104000002p+44, 0x0p+0 },
{ INT64_C(0xffffeefbfffffdff), -0x1.10400000201p+44, 0x0p+0 },
{ INT64_C(0x0000110400002000), 0x1.10400002p+44, 0x0p+0 },
{ INT64_C(0xffffeefbffffdfff), -0x1.10400002001p+44, 0x0p+0 },
{ INT64_C(0x0000110400010000), 0x1.1040001p+44, 0x0p+0 },
{ INT64_C(0xffffeefbfffeffff), -0x1.10400010001p+44, 0x0p+0 },
{ INT64_C(0x0000110400100000), 0x1.104001p+44, 0x0p+0 },
{ INT64_C(0xffffeefbffefffff), -0x1.10400100001p+44, 0x0p+0 },
{ INT64_C(0x0000110400400000), 0x1.104004p+44, 0x0p+0 },
{ INT64_C(0xffffeefbffbfffff), -0x1.10400400001p+44, 0x0p+0 },
{ INT64_C(0x0000110400800000), 0x1.104008p+44, 0x0p+0 },
{ INT64_C(0xffffeefbff7fffff), -0x1.10400800001p+44, 0x0p+0 },
{ INT64_C(0x0000110404000000), 0x1.10404p+44, 0x0p+0 },
{ INT64_C(0xffffeefbfbffffff), -0x1.10404000001p+44, 0x0p+0 },
{ INT64_C(0x0000110420000000), 0x1.1042p+44, 0x0p+0 },
{ INT64_C(0xffffeefbdfffffff), -0x1.10420000001p+44, 0x0p+0 },
{ INT64_C(0x0000110480000000), 0x1.1048p+44, 0x0p+0 },
{ INT64_C(0xffffeefb7fffffff), -0x1.10480000001p+44, 0x0p+0 },
{ INT64_C(0x0000110600000000), 0x1.106p+44, 0x0p+0 },
{ INT64_C(0xffffeef9ffffffff), -0x1.10600000001p+44, 0x0p+0 },
{ INT64_C(0x0000112000000000), 0x1.12p+44, 0x0p+0 },
{ INT64_C(0xffffeedfffffffff), -0x1.12000000001p+44, 0x0p+0 },
{ INT64_C(0x0000112000000001), 0x1.12000000001p+44, 0x0p+0 },
{ INT64_C(0xffffeedffffffffe), -0x1.12000000002p+44, 0x0p+0 },
{ INT64_C(0x0000112000000004), 0x1.12000000004p+44, 0x0p+0 },
{ INT64_C(0xffffeedffffffffb), -0x1.12000000005p+44, 0x0p+0 },
{ INT64_C(0x0000112000000010), 0x1.1200000001p+44, 0x0p+0 },
{ INT64_C(0xffffeedfffffffef), -0x1.12000000011p+44, 0x0p+0 },
{ INT64_C(0x0000112000000080), 0x1.1200000008p+44, 0x0p+0 },
{ INT64_C(0xffffeedfffffff7f), -0x1.12000000081p+44, 0x0p+0 },
{ INT64_C(0x0000112000000100), 0x1.120000001p+44, 0x0p+0 },
{ INT64_C(0xffffeedffffffeff), -0x1.12000000101p+44, 0x0p+0 },
{ INT64_C(0x0000112000000400), 0x1.120000004p+44, 0x0p+0 },
{ INT64_C(0xffffeedffffffbff), -0x1.12000000401p+44, 0x0p+0 },
{ INT64_C(0x0000112000000800), 0x1.120000008p+44, 0x0p+0 },
{ INT64_C(0xffffeedffffff7ff), -0x1.12000000801p+44, 0x0p+0 },
{ INT64_C(0x0000112000001000), 0x1.12000001p+44, 0x0p+0 },
{ INT64_C(0xffffeedfffffefff), -0x1.12000001001p+44, 0x0p+0 },
{ INT64_C(0x0000112000004000), 0x1.12000004p+44, 0x0p+0 },
{ INT64_C(0xffffeedfffffbfff), -0x1.12000004001p+44, 0x0p+0 },
{ INT64_C(0x0000112000008000), 0x1.12000008p+44, 0x0p+0 },
{ INT64_C(0xffffeedfffff7fff), -0x1.12000008001p+44, 0x0p+0 },
{ INT64_C(0x0000112000020000), 0x1.1200002p+44, 0x0p+0 },
{ INT64_C(0xffffeedffffdffff), -0x1.12000020001p+44, 0x0p+0 },
{ INT64_C(0x0000112000100000), 0x1.120001p+44, 0x0p+0 },
{ INT64_C(0xffffeedfffefffff), -0x1.12000100001p+44, 0x0p+0 },
{ INT64_C(0x0000112001000000), 0x1.12001p+44, 0x0p+0 },
{ INT64_C(0xffffeedffeffffff), -0x1.12001000001p+44, 0x0p+0 },
{ INT64_C(0x0000112008000000), 0x1.12008p+44, 0x0p+0 },
{ INT64_C(0xffffeedff7ffffff), -0x1.12008000001p+44, 0x0p+0 },
{ INT64_C(0x0000112010000000), 0x1.1201p+44, 0x0p+0 },
{ INT64_C(0xffffeedfefffffff), -0x1.12010000001p+44, 0x0p+0 },
{ INT64_C(0x0000112100000000), 0x1.121p+44, 0x0p+0 },
{ INT64_C(0xffffeedeffffffff), -0x1.12100000001p+44, 0x0p+0 },
{ INT64_C(0x0000112400000000), 0x1.124p+44, 0x0p+0 },
{ INT64_C(0xffffeedbffffffff), -0x1.12400000001p+44, 0x0p+0 },
{ INT64_C(0x0000112800000000), 0x1.128p+44, 0x0p+0 },
{ INT64_C(0xffffeed7ffffffff), -0x1.12800000001p+44, 0x0p+0 },
{ INT64_C(0x0000118000000000), 0x1.18p+44, 0x0p+0 },
{ INT64_C(0xffffee7fffffffff), -0x1.18000000001p+44, 0x0p+0 },
{ INT64_C(0x0000118000000001), 0x1.18000000001p+44, 0x0p+0 },
{ INT64_C(0xffffee7ffffffffe), -0x1.18000000002p+44, 0x0p+0 },
{ INT64_C(0x0000118000000002), 0x1.18000000002p+44, 0x0p+0 },
{ INT64_C(0xffffee7ffffffffd), -0x1.18000000003p+44, 0x0p+0 },
{ INT64_C(0x0000118000000004), 0x1.18000000004p+44, 0x0p+0 },
{ INT64_C(0xffffee7ffffffffb), -0x1.18000000005p+44, 0x0p+0 },
{ INT64_C(0x0000118000000008), 0x1.18000000008p+44, 0x0p+0 },
{ INT64_C(0xffffee7ffffffff7), -0x1.18000000009p+44, 0x0p+0 },
{ INT64_C(0x0000118000000010), 0x1.1800000001p+44, 0x0p+0 },
{ INT64_C(0xffffee7fffffffef), -0x1.18000000011p+44, 0x0p+0 },
{ INT64_C(0x0000118000000020), 0x1.1800000002p+44, 0x0p+0 },
{ INT64_C(0xffffee7fffffffdf), -0x1.18000000021p+44, 0x0p+0 },
{ INT64_C(0x0000118000000100), 0x1.180000001p+44, 0x0p+0 },
{ INT64_C(0xffffee7ffffffeff), -0x1.18000000101p+44, 0x0p+0 },
{ INT64_C(0x0000118000000400), 0x1.180000004p+44, 0x0p+0 },
{ INT64_C(0xffffee7ffffffbff), -0x1.18000000401p+44, 0x0p+0 },
{ INT64_C(0x0000118000001000), 0x1.18000001p+44, 0x0p+0 },
{ INT64_C(0xffffee7fffffefff), -0x1.18000001001p+44, 0x0p+0 },
{ INT64_C(0x0000118000010000), 0x1.1800001p+44, 0x0p+0 },
{ INT64_C(0xffffee7ffffeffff), -0x1.18000010001p+44, 0x0p+0 },
{ INT64_C(0x0000118000040000), 0x1.1800004p+44, 0x0p+0 },
{ INT64_C(0xffffee7ffffbffff), -0x1.18000040001p+44, 0x0p+0 },
{ INT64_C(0x0000118000100000), 0x1.180001p+44, 0x0p+0 },
{ INT64_C(0xffffee7fffefffff), -0x1.18000100001p+44, 0x0p+0 },
{ INT64_C(0x0000118000200000), 0x1.180002p+44, 0x0p+0 },
{ INT64_C(0xffffee7fffdfffff), -0x1.18000200001p+44, 0x0p+0 },
{ INT64_C(0x0000118001000000), 0x1.18001p+44, 0x0p+0 },
{ INT64_C(0xffffee7ffeffffff), -0x1.18001000001p+44, 0x0p+0 },
{ INT64_C(0x0000118008000000), 0x1.18008p+44, 0x0p+0 },
{ INT64_C(0xffffee7ff7ffffff), -0x1.18008000001p+44, 0x0p+0 },
{ INT64_C(0x0000118080000000), 0x1.1808p+44, 0x0p+0 },
{ INT64_C(0xffffee7f7fffffff), -0x1.18080000001p+44, 0x0p+0 },
{ INT64_C(0x0000118800000000), 0x1.188p+44, 0x0p+0 },
{ INT64_C(0xffffee77ffffffff), -0x1.18800000001p+44, 0x0p+0 },
{ INT64_C(0x000011a000000000), 0x1.1ap+44, 0x0p+0 },
{ INT64_C(0xffffee5fffffffff), -0x1.1a000000001p+44, 0x0p+0 },
{ INT64_C(0x0000180000000008), 0x1.80000000008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffffff7), -0x1.80000000009p+44, 0x0p+0 },
{ INT64_C(0x0000180000000010), 0x1.8000000001p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffffffef), -0x1.80000000011p+44, 0x0p+0 },
{ INT64_C(0x0000180000000018), 0x1.80000000018p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffffffe7), -0x1.80000000019p+44, 0x0p+0 },
{ INT64_C(0x0000180000000020), 0x1.8000000002p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffffffdf), -0x1.80000000021p+44, 0x0p+0 },
{ INT64_C(0x0000180000000028), 0x1.80000000028p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffffffd7), -0x1.80000000029p+44, 0x0p+0 },
{ INT64_C(0x0000180000000200), 0x1.800000002p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffffdff), -0x1.80000000201p+44, 0x0p+0 },
{ INT64_C(0x0000180000000208), 0x1.80000000208p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffffdf7), -0x1.80000000209p+44, 0x0p+0 },
{ INT64_C(0x0000180000000280), 0x1.8000000028p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffffd7f), -0x1.80000000281p+44, 0x0p+0 },
{ INT64_C(0x0000180000000400), 0x1.800000004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffffbff), -0x1.80000000401p+44, 0x0p+0 },
{ INT64_C(0x0000180000000401), 0x1.80000000401p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffffbfe), -0x1.80000000402p+44, 0x0p+0 },
{ INT64_C(0x0000180000000408), 0x1.80000000408p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffffbf7), -0x1.80000000409p+44, 0x0p+0 },
{ INT64_C(0x0000180000000410), 0x1.8000000041p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffffbef), -0x1.80000000411p+44, 0x0p+0 },
{ INT64_C(0x0000180000000500), 0x1.800000005p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffffaff), -0x1.80000000501p+44, 0x0p+0 },
{ INT64_C(0x0000180000000600), 0x1.800000006p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffff9ff), -0x1.80000000601p+44, 0x0p+0 },
{ INT64_C(0x0000180000000800), 0x1.800000008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffff7ff), -0x1.80000000801p+44, 0x0p+0 },
{ INT64_C(0x0000180000000808), 0x1.80000000808p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffff7f7), -0x1.80000000809p+44, 0x0p+0 },
{ INT64_C(0x0000180000000880), 0x1.8000000088p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffff77f), -0x1.80000000881p+44, 0x0p+0 },
{ INT64_C(0x0000180000000a00), 0x1.80000000ap+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffff5ff), -0x1.80000000a01p+44, 0x0p+0 },
{ INT64_C(0x0000180000002000), 0x1.80000002p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffffdfff), -0x1.80000002001p+44, 0x0p+0 },
{ INT64_C(0x0000180000002004), 0x1.80000002004p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffffdffb), -0x1.80000002005p+44, 0x0p+0 },
{ INT64_C(0x0000180000002008), 0x1.80000002008p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffffdff7), -0x1.80000002009p+44, 0x0p+0 },
{ INT64_C(0x0000180000002080), 0x1.8000000208p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffffdf7f), -0x1.80000002081p+44, 0x0p+0 },
{ INT64_C(0x0000180000002400), 0x1.800000024p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffffdbff), -0x1.80000002401p+44, 0x0p+0 },
{ INT64_C(0x0000180000002800), 0x1.800000028p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffffd7ff), -0x1.80000002801p+44, 0x0p+0 },
{ INT64_C(0x0000180000010000), 0x1.8000001p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffeffff), -0x1.80000010001p+44, 0x0p+0 },
{ INT64_C(0x0000180000010004), 0x1.80000010004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffefffb), -0x1.80000010005p+44, 0x0p+0 },
{ INT64_C(0x0000180000010010), 0x1.8000001001p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffeffef), -0x1.80000010011p+44, 0x0p+0 },
{ INT64_C(0x0000180000010040), 0x1.8000001004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffeffbf), -0x1.80000010041p+44, 0x0p+0 },
{ INT64_C(0x0000180000010400), 0x1.800000104p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffefbff), -0x1.80000010401p+44, 0x0p+0 },
{ INT64_C(0x0000180000011000), 0x1.80000011p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffeefff), -0x1.80000011001p+44, 0x0p+0 },
{ INT64_C(0x0000180000014000), 0x1.80000014p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffffebfff), -0x1.80000014001p+44, 0x0p+0 },
{ INT64_C(0x0000180000100000), 0x1.800001p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffefffff), -0x1.80000100001p+44, 0x0p+0 },
{ INT64_C(0x0000180000100004), 0x1.80000100004p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffeffffb), -0x1.80000100005p+44, 0x0p+0 },
{ INT64_C(0x0000180000100008), 0x1.80000100008p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffeffff7), -0x1.80000100009p+44, 0x0p+0 },
{ INT64_C(0x0000180000100010), 0x1.8000010001p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffefffef), -0x1.80000100011p+44, 0x0p+0 },
{ INT64_C(0x0000180000100020), 0x1.8000010002p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffefffdf), -0x1.80000100021p+44, 0x0p+0 },
{ INT64_C(0x0000180000100040), 0x1.8000010004p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffefffbf), -0x1.80000100041p+44, 0x0p+0 },
{ INT64_C(0x0000180000100200), 0x1.800001002p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffeffdff), -0x1.80000100201p+44, 0x0p+0 },
{ INT64_C(0x0000180000100800), 0x1.800001008p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffeff7ff), -0x1.80000100801p+44, 0x0p+0 },
{ INT64_C(0x0000180000101000), 0x1.80000101p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffefefff), -0x1.80000101001p+44, 0x0p+0 },
{ INT64_C(0x0000180000110000), 0x1.8000011p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffffeeffff), -0x1.80000110001p+44, 0x0p+0 },
{ INT64_C(0x0000180001000000), 0x1.80001p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffeffffff), -0x1.80001000001p+44, 0x0p+0 },
{ INT64_C(0x0000180001000008), 0x1.80001000008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffefffff7), -0x1.80001000009p+44, 0x0p+0 },
{ INT64_C(0x0000180001000040), 0x1.8000100004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffeffffbf), -0x1.80001000041p+44, 0x0p+0 },
{ INT64_C(0x0000180001000400), 0x1.800010004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffefffbff), -0x1.80001000401p+44, 0x0p+0 },
{ INT64_C(0x0000180001000800), 0x1.800010008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffefff7ff), -0x1.80001000801p+44, 0x0p+0 },
{ INT64_C(0x0000180001004000), 0x1.80001004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffeffbfff), -0x1.80001004001p+44, 0x0p+0 },
{ INT64_C(0x0000180001008000), 0x1.80001008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffeff7fff), -0x1.80001008001p+44, 0x0p+0 },
{ INT64_C(0x0000180001040000), 0x1.8000104p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffefbffff), -0x1.80001040001p+44, 0x0p+0 },
{ INT64_C(0x0000180001080000), 0x1.8000108p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffef7ffff), -0x1.80001080001p+44, 0x0p+0 },
{ INT64_C(0x0000180001800000), 0x1.800018p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffe7fffff), -0x1.80001800001p+44, 0x0p+0 },
{ INT64_C(0x0000180004000000), 0x1.80004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffbffffff), -0x1.80004000001p+44, 0x0p+0 },
{ INT64_C(0x0000180004000008), 0x1.80004000008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffbfffff7), -0x1.80004000009p+44, 0x0p+0 },
{ INT64_C(0x0000180004000010), 0x1.8000400001p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffbffffef), -0x1.80004000011p+44, 0x0p+0 },
{ INT64_C(0x0000180004000040), 0x1.8000400004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffbffffbf), -0x1.80004000041p+44, 0x0p+0 },
{ INT64_C(0x0000180004000400), 0x1.800040004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffbfffbff), -0x1.80004000401p+44, 0x0p+0 },
{ INT64_C(0x0000180004000800), 0x1.800040008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffbfff7ff), -0x1.80004000801p+44, 0x0p+0 },
{ INT64_C(0x0000180004001000), 0x1.80004001p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffbffefff), -0x1.80004001001p+44, 0x0p+0 },
{ INT64_C(0x0000180004008000), 0x1.80004008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffbff7fff), -0x1.80004008001p+44, 0x0p+0 },
{ INT64_C(0x0000180004020000), 0x1.8000402p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffbfdffff), -0x1.80004020001p+44, 0x0p+0 },
{ INT64_C(0x0000180004040000), 0x1.8000404p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffbfbffff), -0x1.80004040001p+44, 0x0p+0 },
{ INT64_C(0x0000180004100000), 0x1.800041p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffbefffff), -0x1.80004100001p+44, 0x0p+0 },
{ INT64_C(0x0000180004200000), 0x1.800042p+44, 0x0p+0 },
{ INT64_C(0xffffe7fffbdfffff), -0x1.80004200001p+44, 0x0p+0 },
{ INT64_C(0x0000180006000000), 0x1.80006p+44, 0x0p+0 },
{ INT64_C(0xffffe7fff9ffffff), -0x1.80006000001p+44, 0x0p+0 },
{ INT64_C(0x0000180008000000), 0x1.80008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fff7ffffff), -0x1.80008000001p+44, 0x0p+0 },
{ INT64_C(0x0000180008000008), 0x1.80008000008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fff7fffff7), -0x1.80008000009p+44, 0x0p+0 },
{ INT64_C(0x0000180008000020), 0x1.8000800002p+44, 0x0p+0 },
{ INT64_C(0xffffe7fff7ffffdf), -0x1.80008000021p+44, 0x0p+0 },
{ INT64_C(0x0000180008000100), 0x1.800080001p+44, 0x0p+0 },
{ INT64_C(0xffffe7fff7fffeff), -0x1.80008000101p+44, 0x0p+0 },
{ INT64_C(0x0000180008000400), 0x1.800080004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fff7fffbff), -0x1.80008000401p+44, 0x0p+0 },
{ INT64_C(0x0000180008004000), 0x1.80008004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fff7ffbfff), -0x1.80008004001p+44, 0x0p+0 },
{ INT64_C(0x0000180008008000), 0x1.80008008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fff7ff7fff), -0x1.80008008001p+44, 0x0p+0 },
{ INT64_C(0x0000180008020000), 0x1.8000802p+44, 0x0p+0 },
{ INT64_C(0xffffe7fff7fdffff), -0x1.80008020001p+44, 0x0p+0 },
{ INT64_C(0x0000180008200000), 0x1.800082p+44, 0x0p+0 },
{ INT64_C(0xffffe7fff7dfffff), -0x1.80008200001p+44, 0x0p+0 },
{ INT64_C(0x000018000a000000), 0x1.8000ap+44, 0x0p+0 },
{ INT64_C(0xffffe7fff5ffffff), -0x1.8000a000001p+44, 0x0p+0 },
{ INT64_C(0x0000180040000000), 0x1.8004p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffbfffffff), -0x1.80040000001p+44, 0x0p+0 },
{ INT64_C(0x0000180040000001), 0x1.80040000001p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffbffffffe), -0x1.80040000002p+44, 0x0p+0 },
{ INT64_C(0x0000180040000008), 0x1.80040000008p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffbffffff7), -0x1.80040000009p+44, 0x0p+0 },
{ INT64_C(0x0000180040000010), 0x1.8004000001p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffbfffffef), -0x1.80040000011p+44, 0x0p+0 },
{ INT64_C(0x0000180040000040), 0x1.8004000004p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffbfffffbf), -0x1.80040000041p+44, 0x0p+0 },
{ INT64_C(0x0000180040000100), 0x1.800400001p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffbffffeff), -0x1.80040000101p+44, 0x0p+0 },
{ INT64_C(0x0000180040001000), 0x1.80040001p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffbfffefff), -0x1.80040001001p+44, 0x0p+0 },
{ INT64_C(0x0000180040010000), 0x1.8004001p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffbffeffff), -0x1.80040010001p+44, 0x0p+0 },
{ INT64_C(0x0000180040100000), 0x1.800401p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffbfefffff), -0x1.80040100001p+44, 0x0p+0 },
{ INT64_C(0x0000180041000000), 0x1.80041p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffbeffffff), -0x1.80041000001p+44, 0x0p+0 },
{ INT64_C(0x0000180050000000), 0x1.8005p+44, 0x0p+0 },
{ INT64_C(0xffffe7ffafffffff), -0x1.80050000001p+44, 0x0p+0 },
{ INT64_C(0x0000180100000000), 0x1.801p+44, 0x0p+0 },
{ INT64_C(0xffffe7feffffffff), -0x1.80100000001p+44, 0x0p+0 },
{ INT64_C(0x0000180100000008), 0x1.80100000008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fefffffff7), -0x1.80100000009p+44, 0x0p+0 },
{ INT64_C(0x0000180100000040), 0x1.8010000004p+44, 0x0p+0 },
{ INT64_C(0xffffe7feffffffbf), -0x1.80100000041p+44, 0x0p+0 },
{ INT64_C(0x0000180100000400), 0x1.801000004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fefffffbff), -0x1.80100000401p+44, 0x0p+0 },
{ INT64_C(0x0000180100000800), 0x1.801000008p+44, 0x0p+0 },
{ INT64_C(0xffffe7fefffff7ff), -0x1.80100000801p+44, 0x0p+0 },
{ INT64_C(0x0000180100001000), 0x1.80100001p+44, 0x0p+0 },
{ INT64_C(0xffffe7feffffefff), -0x1.80100001001p+44, 0x0p+0 },
{ INT64_C(0x0000180100002000), 0x1.80100002p+44, 0x0p+0 },
{ INT64_C(0xffffe7feffffdfff), -0x1.80100002001p+44, 0x0p+0 },
{ INT64_C(0x0000180100010000), 0x1.8010001p+44, 0x0p+0 },
{ INT64_C(0xffffe7fefffeffff), -0x1.80100010001p+44, 0x0p+0 },
{ INT64_C(0x0000180100040000), 0x1.8010004p+44, 0x0p+0 },
{ INT64_C(0xffffe7fefffbffff), -0x1.80100040001p+44, 0x0p+0 },
{ INT64_C(0x0000180100200000), 0x1.801002p+44, 0x0p+0 },
{ INT64_C(0xffffe7feffdfffff), -0x1.80100200001p+44, 0x0p+0 },
{ INT64_C(0x0000180101000000), 0x1.80101p+44, 0x0p+0 },
{ INT64_C(0xffffe7fefeffffff), -0x1.80101000001p+44, 0x0p+0 },
{ INT64_C(0x0000180104000000), 0x1.80104p+44, 0x0p+0 },
{ INT64_C(0xffffe7fefbffffff), -0x1.80104000001p+44, 0x0p+0 },
{ INT64_C(0x0000180140000000), 0x1.8014p+44, 0x0p+0 },
{ INT64_C(0xffffe7febfffffff), -0x1.80140000001p+44, 0x0p+0 },
{ INT64_C(0x0000180800000000), 0x1.808p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7ffffffff), -0x1.80800000001p+44, 0x0p+0 },
{ INT64_C(0x0000180800000001), 0x1.80800000001p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7fffffffe), -0x1.80800000002p+44, 0x0p+0 },
{ INT64_C(0x0000180800000004), 0x1.80800000004p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7fffffffb), -0x1.80800000005p+44, 0x0p+0 },
{ INT64_C(0x0000180800000008), 0x1.80800000008p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7fffffff7), -0x1.80800000009p+44, 0x0p+0 },
{ INT64_C(0x0000180800000080), 0x1.8080000008p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7ffffff7f), -0x1.80800000081p+44, 0x0p+0 },
{ INT64_C(0x0000180800000200), 0x1.808000002p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7fffffdff), -0x1.80800000201p+44, 0x0p+0 },
{ INT64_C(0x0000180800001000), 0x1.80800001p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7ffffefff), -0x1.80800001001p+44, 0x0p+0 },
{ INT64_C(0x0000180800004000), 0x1.80800004p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7ffffbfff), -0x1.80800004001p+44, 0x0p+0 },
{ INT64_C(0x0000180800040000), 0x1.8080004p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7fffbffff), -0x1.80800040001p+44, 0x0p+0 },
{ INT64_C(0x0000180800200000), 0x1.808002p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7ffdfffff), -0x1.80800200001p+44, 0x0p+0 },
{ INT64_C(0x0000180802000000), 0x1.80802p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7fdffffff), -0x1.80802000001p+44, 0x0p+0 },
{ INT64_C(0x0000180808000000), 0x1.80808p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7f7ffffff), -0x1.80808000001p+44, 0x0p+0 },
{ INT64_C(0x0000180810000000), 0x1.8081p+44, 0x0p+0 },
{ INT64_C(0xffffe7f7efffffff), -0x1.80810000001p+44, 0x0p+0 },
{ INT64_C(0x0000180880000000), 0x1.8088p+44, 0x0p+0 },
{ INT64_C(0xffffe7f77fffffff), -0x1.80880000001p+44, 0x0p+0 },
{ INT64_C(0x0000184000000000), 0x1.84p+44, 0x0p+0 },
{ INT64_C(0xffffe7bfffffffff), -0x1.84000000001p+44, 0x0p+0 },
{ INT64_C(0x0000184000000002), 0x1.84000000002p+44, 0x0p+0 },
{ INT64_C(0xffffe7bffffffffd), -0x1.84000000003p+44, 0x0p+0 },
{ INT64_C(0x0000184000000004), 0x1.84000000004p+44, 0x0p+0 },
{ INT64_C(0xffffe7bffffffffb), -0x1.84000000005p+44, 0x0p+0 },
{ INT64_C(0x0000184000000020), 0x1.8400000002p+44, 0x0p+0 },
{ INT64_C(0xffffe7bfffffffdf), -0x1.84000000021p+44, 0x0p+0 },
{ INT64_C(0x0000184000000100), 0x1.840000001p+44, 0x0p+0 },
{ INT64_C(0xffffe7bffffffeff), -0x1.84000000101p+44, 0x0p+0 },
{ INT64_C(0x0000184000001000), 0x1.84000001p+44, 0x0p+0 },
{ INT64_C(0xffffe7bfffffefff), -0x1.84000001001p+44, 0x0p+0 },
{ INT64_C(0x0000184000004000), 0x1.84000004p+44, 0x0p+0 },
{ INT64_C(0xffffe7bfffffbfff), -0x1.84000004001p+44, 0x0p+0 },
{ INT64_C(0x0000184000008000), 0x1.84000008p+44, 0x0p+0 },
{ INT64_C(0xffffe7bfffff7fff), -0x1.84000008001p+44, 0x0p+0 },
{ INT64_C(0x0000184000010000), 0x1.8400001p+44, 0x0p+0 },
{ INT64_C(0xffffe7bffffeffff), -0x1.84000010001p+44, 0x0p+0 },
{ INT64_C(0x0000184000100000), 0x1.840001p+44, 0x0p+0 },
{ INT64_C(0xffffe7bfffefffff), -0x1.84000100001p+44, 0x0p+0 },
{ INT64_C(0x0000184000200000), 0x1.840002p+44, 0x0p+0 },
{ INT64_C(0xffffe7bfffdfffff), -0x1.84000200001p+44, 0x0p+0 },
{ INT64_C(0x0000184000800000), 0x1.840008p+44, 0x0p+0 },
{ INT64_C(0xffffe7bfff7fffff), -0x1.84000800001p+44, 0x0p+0 },
{ INT64_C(0x0000184001000000), 0x1.84001p+44, 0x0p+0 },
{ INT64_C(0xffffe7bffeffffff), -0x1.84001000001p+44, 0x0p+0 },
{ INT64_C(0x0000184010000000), 0x1.8401p+44, 0x0p+0 },
{ INT64_C(0xffffe7bfefffffff), -0x1.84010000001p+44, 0x0p+0 },
{ INT64_C(0x0000184040000000), 0x1.8404p+44, 0x0p+0 },
{ INT64_C(0xffffe7bfbfffffff), -0x1.84040000001p+44, 0x0p+0 },
{ INT64_C(0x0000184200000000), 0x1.842p+44, 0x0p+0 },
{ INT64_C(0xffffe7bdffffffff), -0x1.84200000001p+44, 0x0p+0 },
{ INT64_C(0x0000184400000000), 0x1.844p+44, 0x0p+0 },
{ INT64_C(0xffffe7bbffffffff), -0x1.84400000001p+44, 0x0p+0 },
{ INT64_C(0x0000190000000000), 0x1.9p+44, 0x0p+0 },
{ INT64_C(0xffffe6ffffffffff), -0x1.90000000001p+44, 0x0p+0 },
{ INT64_C(0x0000190000000004), 0x1.90000000004p+44, 0x0p+0 },
{ INT64_C(0xffffe6fffffffffb), -0x1.90000000005p+44, 0x0p+0 },
{ INT64_C(0x0000190000000020), 0x1.9000000002p+44, 0x0p+0 },
{ INT64_C(0xffffe6ffffffffdf), -0x1.90000000021p+44, 0x0p+0 },
{ INT64_C(0x0000190000000080), 0x1.9000000008p+44, 0x0p+0 },
{ INT64_C(0xffffe6ffffffff7f), -0x1.90000000081p+44, 0x0p+0 },
{ INT64_C(0x0000190000000200), 0x1.900000002p+44, 0x0p+0 },
{ INT64_C(0xffffe6fffffffdff), -0x1.90000000201p+44, 0x0p+0 },
{ INT64_C(0x0000190000001000), 0x1.90000001p+44, 0x0p+0 },
{ INT64_C(0xffffe6ffffffefff), -0x1.90000001001p+44, 0x0p+0 },
{ INT64_C(0x0000190000010000), 0x1.9000001p+44, 0x0p+0 },
{ INT64_C(0xffffe6fffffeffff), -0x1.90000010001p+44, 0x0p+0 },
{ INT64_C(0x0000190000040000), 0x1.9000004p+44, 0x0p+0 },
{ INT64_C(0xffffe6fffffbffff), -0x1.90000040001p+44, 0x0p+0 },
{ INT64_C(0x0000190000100000), 0x1.900001p+44, 0x0p+0 },
{ INT64_C(0xffffe6ffffefffff), -0x1.90000100001p+44, 0x0p+0 },
{ INT64_C(0x0000190000800000), 0x1.900008p+44, 0x0p+0 },
{ INT64_C(0xffffe6ffff7fffff), -0x1.90000800001p+44, 0x0p+0 },
{ INT64_C(0x0000190008000000), 0x1.90008p+44, 0x0p+0 },
{ INT64_C(0xffffe6fff7ffffff), -0x1.90008000001p+44, 0x0p+0 },
{ INT64_C(0x0000190080000000), 0x1.9008p+44, 0x0p+0 },
{ INT64_C(0xffffe6ff7fffffff), -0x1.90080000001p+44, 0x0p+0 },
{ INT64_C(0x0000190200000000), 0x1.902p+44, 0x0p+0 },
{ INT64_C(0xffffe6fdffffffff), -0x1.90200000001p+44, 0x0p+0 },
{ INT64_C(0x0000191000000000), 0x1.91p+44, 0x0p+0 },
{ INT64_C(0xffffe6efffffffff), -0x1.91000000001p+44, 0x0p+0 },
{ INT64_C(0x0000192000000000), 0x1.92p+44, 0x0p+0 },
{ INT64_C(0xffffe6dfffffffff), -0x1.92000000001p+44, 0x0p+0 },
{ INT64_C(0x0000800000000011), 0x1.000000000022p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffffffee), -0x1.000000000024p+47, 0x0p+0 },
{ INT64_C(0x0000800000000012), 0x1.000000000024p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffffffed), -0x1.000000000026p+47, 0x0p+0 },
{ INT64_C(0x0000800000000018), 0x1.00000000003p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffffffe7), -0x1.000000000032p+47, 0x0p+0 },
{ INT64_C(0x000080000000001a), 0x1.000000000034p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffffffe5), -0x1.000000000036p+47, 0x0p+0 },
{ INT64_C(0x0000800000000104), 0x1.000000000208p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffffefb), -0x1.00000000020ap+47, 0x0p+0 },
{ INT64_C(0x0000800000000105), 0x1.00000000020ap+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffffefa), -0x1.00000000020cp+47, 0x0p+0 },
{ INT64_C(0x0000800000000140), 0x1.00000000028p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffffebf), -0x1.000000000282p+47, 0x0p+0 },
{ INT64_C(0x0000800000000144), 0x1.000000000288p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffffebb), -0x1.00000000028ap+47, 0x0p+0 },
{ INT64_C(0x0000800000000160), 0x1.0000000002cp+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffffe9f), -0x1.0000000002c2p+47, 0x0p+0 },
{ INT64_C(0x0000800000000802), 0x1.000000001004p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff7fd), -0x1.000000001006p+47, 0x0p+0 },
{ INT64_C(0x0000800000000804), 0x1.000000001008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff7fb), -0x1.00000000100ap+47, 0x0p+0 },
{ INT64_C(0x0000800000000820), 0x1.00000000104p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff7df), -0x1.000000001042p+47, 0x0p+0 },
{ INT64_C(0x0000800000000821), 0x1.000000001042p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff7de), -0x1.000000001044p+47, 0x0p+0 },
{ INT64_C(0x0000800000000824), 0x1.000000001048p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff7db), -0x1.00000000104ap+47, 0x0p+0 },
{ INT64_C(0x0000800000000830), 0x1.00000000106p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff7cf), -0x1.000000001062p+47, 0x0p+0 },
{ INT64_C(0x0000800000000880), 0x1.0000000011p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff77f), -0x1.000000001102p+47, 0x0p+0 },
{ INT64_C(0x0000800000000882), 0x1.000000001104p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff77d), -0x1.000000001106p+47, 0x0p+0 },
{ INT64_C(0x00008000000008a0), 0x1.00000000114p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff75f), -0x1.000000001142p+47, 0x0p+0 },
{ INT64_C(0x00008000000008c0), 0x1.00000000118p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff73f), -0x1.000000001182p+47, 0x0p+0 },
{ INT64_C(0x0000800000000a00), 0x1.0000000014p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff5ff), -0x1.000000001402p+47, 0x0p+0 },
{ INT64_C(0x0000800000000a04), 0x1.000000001408p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff5fb), -0x1.00000000140ap+47, 0x0p+0 },
{ INT64_C(0x0000800000000a10), 0x1.00000000142p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff5ef), -0x1.000000001422p+47, 0x0p+0 },
{ INT64_C(0x0000800000000a40), 0x1.00000000148p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffff5bf), -0x1.000000001482p+47, 0x0p+0 },
{ INT64_C(0x0000800000008008), 0x1.00000001001p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff7ff7), -0x1.000000010012p+47, 0x0p+0 },
{ INT64_C(0x0000800000008020), 0x1.00000001004p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff7fdf), -0x1.000000010042p+47, 0x0p+0 },
{ INT64_C(0x0000800000008024), 0x1.000000010048p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff7fdb), -0x1.00000001004ap+47, 0x0p+0 },
{ INT64_C(0x0000800000008030), 0x1.00000001006p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff7fcf), -0x1.000000010062p+47, 0x0p+0 },
{ INT64_C(0x0000800000008100), 0x1.0000000102p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff7eff), -0x1.000000010202p+47, 0x0p+0 },
{ INT64_C(0x0000800000008102), 0x1.000000010204p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff7efd), -0x1.000000010206p+47, 0x0p+0 },
{ INT64_C(0x0000800000008110), 0x1.00000001022p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff7eef), -0x1.000000010222p+47, 0x0p+0 },
{ INT64_C(0x0000800000008180), 0x1.0000000103p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff7e7f), -0x1.000000010302p+47, 0x0p+0 },
{ INT64_C(0x0000800000008200), 0x1.0000000104p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff7dff), -0x1.000000010402p+47, 0x0p+0 },
{ INT64_C(0x0000800000008202), 0x1.000000010404p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff7dfd), -0x1.000000010406p+47, 0x0p+0 },
{ INT64_C(0x0000800000008208), 0x1.00000001041p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff7df7), -0x1.000000010412p+47, 0x0p+0 },
{ INT64_C(0x0000800000008280), 0x1.0000000105p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff7d7f), -0x1.000000010502p+47, 0x0p+0 },
{ INT64_C(0x000080000000a000), 0x1.000000014p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff5fff), -0x1.000000014002p+47, 0x0p+0 },
{ INT64_C(0x000080000000a008), 0x1.00000001401p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff5ff7), -0x1.000000014012p+47, 0x0p+0 },
{ INT64_C(0x000080000000a020), 0x1.00000001404p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff5fdf), -0x1.000000014042p+47, 0x0p+0 },
{ INT64_C(0x000080000000a040), 0x1.00000001408p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff5fbf), -0x1.000000014082p+47, 0x0p+0 },
{ INT64_C(0x000080000000a080), 0x1.0000000141p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff5f7f), -0x1.000000014102p+47, 0x0p+0 },
{ INT64_C(0x000080000000a400), 0x1.0000000148p+47, 0x0p+0 },
{ INT64_C(0xffff7fffffff5bff), -0x1.000000014802p+47, 0x0p+0 },
{ INT64_C(0x0000800000040002), 0x1.000000080004p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbfffd), -0x1.000000080006p+47, 0x0p+0 },
{ INT64_C(0x0000800000040008), 0x1.00000008001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbfff7), -0x1.000000080012p+47, 0x0p+0 },
{ INT64_C(0x0000800000040080), 0x1.0000000801p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbff7f), -0x1.000000080102p+47, 0x0p+0 },
{ INT64_C(0x0000800000040082), 0x1.000000080104p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbff7d), -0x1.000000080106p+47, 0x0p+0 },
{ INT64_C(0x0000800000040084), 0x1.000000080108p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbff7b), -0x1.00000008010ap+47, 0x0p+0 },
{ INT64_C(0x0000800000040088), 0x1.00000008011p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbff77), -0x1.000000080112p+47, 0x0p+0 },
{ INT64_C(0x00008000000400a0), 0x1.00000008014p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbff5f), -0x1.000000080142p+47, 0x0p+0 },
{ INT64_C(0x00008000000400c0), 0x1.00000008018p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbff3f), -0x1.000000080182p+47, 0x0p+0 },
{ INT64_C(0x0000800000040100), 0x1.0000000802p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbfeff), -0x1.000000080202p+47, 0x0p+0 },
{ INT64_C(0x0000800000040101), 0x1.000000080202p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbfefe), -0x1.000000080204p+47, 0x0p+0 },
{ INT64_C(0x0000800000040104), 0x1.000000080208p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbfefb), -0x1.00000008020ap+47, 0x0p+0 },
{ INT64_C(0x0000800000040120), 0x1.00000008024p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbfedf), -0x1.000000080242p+47, 0x0p+0 },
{ INT64_C(0x0000800000040180), 0x1.0000000803p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbfe7f), -0x1.000000080302p+47, 0x0p+0 },
{ INT64_C(0x0000800000041000), 0x1.000000082p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbefff), -0x1.000000082002p+47, 0x0p+0 },
{ INT64_C(0x0000800000041004), 0x1.000000082008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbeffb), -0x1.00000008200ap+47, 0x0p+0 },
{ INT64_C(0x0000800000041008), 0x1.00000008201p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbeff7), -0x1.000000082012p+47, 0x0p+0 },
{ INT64_C(0x0000800000041080), 0x1.0000000821p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbef7f), -0x1.000000082102p+47, 0x0p+0 },
{ INT64_C(0x0000800000041400), 0x1.0000000828p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbebff), -0x1.000000082802p+47, 0x0p+0 },
{ INT64_C(0x0000800000044000), 0x1.000000088p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbbfff), -0x1.000000088002p+47, 0x0p+0 },
{ INT64_C(0x0000800000044004), 0x1.000000088008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbbffb), -0x1.00000008800ap+47, 0x0p+0 },
{ INT64_C(0x0000800000044008), 0x1.00000008801p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbbff7), -0x1.000000088012p+47, 0x0p+0 },
{ INT64_C(0x0000800000044010), 0x1.00000008802p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbbfef), -0x1.000000088022p+47, 0x0p+0 },
{ INT64_C(0x0000800000044100), 0x1.0000000882p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbbeff), -0x1.000000088202p+47, 0x0p+0 },
{ INT64_C(0x0000800000044200), 0x1.0000000884p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbbdff), -0x1.000000088402p+47, 0x0p+0 },
{ INT64_C(0x0000800000044800), 0x1.000000089p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffbb7ff), -0x1.000000089002p+47, 0x0p+0 },
{ INT64_C(0x0000800000046000), 0x1.00000008cp+47, 0x0p+0 },
{ INT64_C(0xffff7ffffffb9fff), -0x1.00000008c002p+47, 0x0p+0 },
{ INT64_C(0x0000800000080001), 0x1.000000100002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7fffe), -0x1.000000100004p+47, 0x0p+0 },
{ INT64_C(0x0000800000080010), 0x1.00000010002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7ffef), -0x1.000000100022p+47, 0x0p+0 },
{ INT64_C(0x0000800000080018), 0x1.00000010003p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7ffe7), -0x1.000000100032p+47, 0x0p+0 },
{ INT64_C(0x0000800000080020), 0x1.00000010004p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7ffdf), -0x1.000000100042p+47, 0x0p+0 },
{ INT64_C(0x0000800000080028), 0x1.00000010005p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7ffd7), -0x1.000000100052p+47, 0x0p+0 },
{ INT64_C(0x0000800000080030), 0x1.00000010006p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7ffcf), -0x1.000000100062p+47, 0x0p+0 },
{ INT64_C(0x0000800000080200), 0x1.0000001004p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7fdff), -0x1.000000100402p+47, 0x0p+0 },
{ INT64_C(0x0000800000080201), 0x1.000000100402p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7fdfe), -0x1.000000100404p+47, 0x0p+0 },
{ INT64_C(0x0000800000080202), 0x1.000000100404p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7fdfd), -0x1.000000100406p+47, 0x0p+0 },
{ INT64_C(0x0000800000080204), 0x1.000000100408p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7fdfb), -0x1.00000010040ap+47, 0x0p+0 },
{ INT64_C(0x0000800000080220), 0x1.00000010044p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7fddf), -0x1.000000100442p+47, 0x0p+0 },
{ INT64_C(0x0000800000080300), 0x1.0000001006p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7fcff), -0x1.000000100602p+47, 0x0p+0 },
{ INT64_C(0x0000800000080800), 0x1.000000101p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7f7ff), -0x1.000000101002p+47, 0x0p+0 },
{ INT64_C(0x0000800000080808), 0x1.00000010101p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7f7f7), -0x1.000000101012p+47, 0x0p+0 },
{ INT64_C(0x0000800000080810), 0x1.00000010102p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7f7ef), -0x1.000000101022p+47, 0x0p+0 },
{ INT64_C(0x0000800000080900), 0x1.0000001012p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7f6ff), -0x1.000000101202p+47, 0x0p+0 },
{ INT64_C(0x0000800000080c00), 0x1.0000001018p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7f3ff), -0x1.000000101802p+47, 0x0p+0 },
{ INT64_C(0x0000800000084000), 0x1.000000108p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7bfff), -0x1.000000108002p+47, 0x0p+0 },
{ INT64_C(0x0000800000084004), 0x1.000000108008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7bffb), -0x1.00000010800ap+47, 0x0p+0 },
{ INT64_C(0x0000800000084020), 0x1.00000010804p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7bfdf), -0x1.000000108042p+47, 0x0p+0 },
{ INT64_C(0x0000800000084100), 0x1.0000001082p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7beff), -0x1.000000108202p+47, 0x0p+0 },
{ INT64_C(0x0000800000084800), 0x1.000000109p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7b7ff), -0x1.000000109002p+47, 0x0p+0 },
{ INT64_C(0x0000800000085000), 0x1.00000010ap+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff7afff), -0x1.00000010a002p+47, 0x0p+0 },
{ INT64_C(0x0000800000088000), 0x1.00000011p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff77fff), -0x1.000000110002p+47, 0x0p+0 },
{ INT64_C(0x0000800000088001), 0x1.000000110002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff77ffe), -0x1.000000110004p+47, 0x0p+0 },
{ INT64_C(0x0000800000088008), 0x1.00000011001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff77ff7), -0x1.000000110012p+47, 0x0p+0 },
{ INT64_C(0x0000800000088010), 0x1.00000011002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff77fef), -0x1.000000110022p+47, 0x0p+0 },
{ INT64_C(0x0000800000088020), 0x1.00000011004p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff77fdf), -0x1.000000110042p+47, 0x0p+0 },
{ INT64_C(0x0000800000088200), 0x1.0000001104p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff77dff), -0x1.000000110402p+47, 0x0p+0 },
{ INT64_C(0x000080000008a000), 0x1.000000114p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff75fff), -0x1.000000114002p+47, 0x0p+0 },
{ INT64_C(0x00008000000c0000), 0x1.00000018p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff3ffff), -0x1.000000180002p+47, 0x0p+0 },
{ INT64_C(0x00008000000c0004), 0x1.000000180008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff3fffb), -0x1.00000018000ap+47, 0x0p+0 },
{ INT64_C(0x00008000000c0020), 0x1.00000018004p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff3ffdf), -0x1.000000180042p+47, 0x0p+0 },
{ INT64_C(0x00008000000c0080), 0x1.0000001801p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff3ff7f), -0x1.000000180102p+47, 0x0p+0 },
{ INT64_C(0x00008000000c0200), 0x1.0000001804p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff3fdff), -0x1.000000180402p+47, 0x0p+0 },
{ INT64_C(0x00008000000c1000), 0x1.000000182p+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff3efff), -0x1.000000182002p+47, 0x0p+0 },
{ INT64_C(0x00008000000d0000), 0x1.0000001ap+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff2ffff), -0x1.0000001a0002p+47, 0x0p+0 },
{ INT64_C(0x00008000000e0000), 0x1.0000001cp+47, 0x0p+0 },
{ INT64_C(0xffff7ffffff1ffff), -0x1.0000001c0002p+47, 0x0p+0 },
{ INT64_C(0x0000800000800002), 0x1.000001000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7ffffd), -0x1.000001000006p+47, 0x0p+0 },
{ INT64_C(0x0000800000800003), 0x1.000001000006p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7ffffc), -0x1.000001000008p+47, 0x0p+0 },
{ INT64_C(0x0000800000800020), 0x1.00000100004p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7fffdf), -0x1.000001000042p+47, 0x0p+0 },
{ INT64_C(0x0000800000800022), 0x1.000001000044p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7fffdd), -0x1.000001000046p+47, 0x0p+0 },
{ INT64_C(0x0000800000800030), 0x1.00000100006p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7fffcf), -0x1.000001000062p+47, 0x0p+0 },
{ INT64_C(0x0000800000800080), 0x1.0000010001p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7fff7f), -0x1.000001000102p+47, 0x0p+0 },
{ INT64_C(0x0000800000800084), 0x1.000001000108p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7fff7b), -0x1.00000100010ap+47, 0x0p+0 },
{ INT64_C(0x00008000008000c0), 0x1.00000100018p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7fff3f), -0x1.000001000182p+47, 0x0p+0 },
{ INT64_C(0x0000800000800400), 0x1.0000010008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7ffbff), -0x1.000001000802p+47, 0x0p+0 },
{ INT64_C(0x0000800000800401), 0x1.000001000802p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7ffbfe), -0x1.000001000804p+47, 0x0p+0 },
{ INT64_C(0x0000800000800404), 0x1.000001000808p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7ffbfb), -0x1.00000100080ap+47, 0x0p+0 },
{ INT64_C(0x0000800000800420), 0x1.00000100084p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7ffbdf), -0x1.000001000842p+47, 0x0p+0 },
{ INT64_C(0x0000800000800480), 0x1.0000010009p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7ffb7f), -0x1.000001000902p+47, 0x0p+0 },
{ INT64_C(0x0000800000802000), 0x1.000001004p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7fdfff), -0x1.000001004002p+47, 0x0p+0 },
{ INT64_C(0x0000800000802004), 0x1.000001004008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7fdffb), -0x1.00000100400ap+47, 0x0p+0 },
{ INT64_C(0x0000800000802010), 0x1.00000100402p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7fdfef), -0x1.000001004022p+47, 0x0p+0 },
{ INT64_C(0x0000800000802040), 0x1.00000100408p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7fdfbf), -0x1.000001004082p+47, 0x0p+0 },
{ INT64_C(0x0000800000802200), 0x1.0000010044p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7fddff), -0x1.000001004402p+47, 0x0p+0 },
{ INT64_C(0x0000800000802800), 0x1.000001005p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7fd7ff), -0x1.000001005002p+47, 0x0p+0 },
{ INT64_C(0x0000800000820000), 0x1.00000104p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7dffff), -0x1.000001040002p+47, 0x0p+0 },
{ INT64_C(0x0000800000820004), 0x1.000001040008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7dfffb), -0x1.00000104000ap+47, 0x0p+0 },
{ INT64_C(0x0000800000820008), 0x1.00000104001p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7dfff7), -0x1.000001040012p+47, 0x0p+0 },
{ INT64_C(0x0000800000820040), 0x1.00000104008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7dffbf), -0x1.000001040082p+47, 0x0p+0 },
{ INT64_C(0x0000800000820100), 0x1.0000010402p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7dfeff), -0x1.000001040202p+47, 0x0p+0 },
{ INT64_C(0x0000800000820800), 0x1.000001041p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7df7ff), -0x1.000001041002p+47, 0x0p+0 },
{ INT64_C(0x0000800000824000), 0x1.000001048p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff7dbfff), -0x1.000001048002p+47, 0x0p+0 },
{ INT64_C(0x0000800000900000), 0x1.0000012p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff6fffff), -0x1.000001200002p+47, 0x0p+0 },
{ INT64_C(0x0000800000900004), 0x1.000001200008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff6ffffb), -0x1.00000120000ap+47, 0x0p+0 },
{ INT64_C(0x0000800000900008), 0x1.00000120001p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff6ffff7), -0x1.000001200012p+47, 0x0p+0 },
{ INT64_C(0x0000800000900080), 0x1.0000012001p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff6fff7f), -0x1.000001200102p+47, 0x0p+0 },
{ INT64_C(0x0000800000900200), 0x1.0000012004p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff6ffdff), -0x1.000001200402p+47, 0x0p+0 },
{ INT64_C(0x0000800000900400), 0x1.0000012008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff6ffbff), -0x1.000001200802p+47, 0x0p+0 },
{ INT64_C(0x0000800000904000), 0x1.000001208p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff6fbfff), -0x1.000001208002p+47, 0x0p+0 },
{ INT64_C(0x0000800000908000), 0x1.00000121p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff6f7fff), -0x1.000001210002p+47, 0x0p+0 },
{ INT64_C(0x0000800000940000), 0x1.00000128p+47, 0x0p+0 },
{ INT64_C(0xffff7fffff6bffff), -0x1.000001280002p+47, 0x0p+0 },
{ INT64_C(0x0000800008000008), 0x1.00001000001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7fffff7), -0x1.000010000012p+47, 0x0p+0 },
{ INT64_C(0x0000800008000010), 0x1.00001000002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ffffef), -0x1.000010000022p+47, 0x0p+0 },
{ INT64_C(0x0000800008000011), 0x1.000010000022p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ffffee), -0x1.000010000024p+47, 0x0p+0 },
{ INT64_C(0x0000800008000014), 0x1.000010000028p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ffffeb), -0x1.00001000002ap+47, 0x0p+0 },
{ INT64_C(0x0000800008000080), 0x1.0000100001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ffff7f), -0x1.000010000102p+47, 0x0p+0 },
{ INT64_C(0x0000800008000082), 0x1.000010000104p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ffff7d), -0x1.000010000106p+47, 0x0p+0 },
{ INT64_C(0x0000800008000088), 0x1.00001000011p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ffff77), -0x1.000010000112p+47, 0x0p+0 },
{ INT64_C(0x0000800008000200), 0x1.0000100004p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7fffdff), -0x1.000010000402p+47, 0x0p+0 },
{ INT64_C(0x0000800008000204), 0x1.000010000408p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7fffdfb), -0x1.00001000040ap+47, 0x0p+0 },
{ INT64_C(0x0000800008000240), 0x1.00001000048p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7fffdbf), -0x1.000010000482p+47, 0x0p+0 },
{ INT64_C(0x0000800008000280), 0x1.0000100005p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7fffd7f), -0x1.000010000502p+47, 0x0p+0 },
{ INT64_C(0x0000800008001000), 0x1.000010002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ffefff), -0x1.000010002002p+47, 0x0p+0 },
{ INT64_C(0x0000800008001004), 0x1.000010002008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ffeffb), -0x1.00001000200ap+47, 0x0p+0 },
{ INT64_C(0x0000800008001040), 0x1.00001000208p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ffefbf), -0x1.000010002082p+47, 0x0p+0 },
{ INT64_C(0x0000800008001100), 0x1.0000100022p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ffeeff), -0x1.000010002202p+47, 0x0p+0 },
{ INT64_C(0x0000800008008000), 0x1.00001001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ff7fff), -0x1.000010010002p+47, 0x0p+0 },
{ INT64_C(0x0000800008008001), 0x1.000010010002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ff7ffe), -0x1.000010010004p+47, 0x0p+0 },
{ INT64_C(0x0000800008008004), 0x1.000010010008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ff7ffb), -0x1.00001001000ap+47, 0x0p+0 },
{ INT64_C(0x0000800008008008), 0x1.00001001001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ff7ff7), -0x1.000010010012p+47, 0x0p+0 },
{ INT64_C(0x0000800008008080), 0x1.0000100101p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ff7f7f), -0x1.000010010102p+47, 0x0p+0 },
{ INT64_C(0x0000800008008100), 0x1.0000100102p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ff7eff), -0x1.000010010202p+47, 0x0p+0 },
{ INT64_C(0x0000800008009000), 0x1.000010012p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ff6fff), -0x1.000010012002p+47, 0x0p+0 },
{ INT64_C(0x000080000800c000), 0x1.000010018p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7ff3fff), -0x1.000010018002p+47, 0x0p+0 },
{ INT64_C(0x0000800008080000), 0x1.0000101p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7f7ffff), -0x1.000010100002p+47, 0x0p+0 },
{ INT64_C(0x0000800008080008), 0x1.00001010001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7f7fff7), -0x1.000010100012p+47, 0x0p+0 },
{ INT64_C(0x0000800008080010), 0x1.00001010002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7f7ffef), -0x1.000010100022p+47, 0x0p+0 },
{ INT64_C(0x0000800008080100), 0x1.0000101002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7f7feff), -0x1.000010100202p+47, 0x0p+0 },
{ INT64_C(0x0000800008080400), 0x1.0000101008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7f7fbff), -0x1.000010100802p+47, 0x0p+0 },
{ INT64_C(0x0000800008080800), 0x1.000010101p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7f7f7ff), -0x1.000010101002p+47, 0x0p+0 },
{ INT64_C(0x0000800008082000), 0x1.000010104p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7f7dfff), -0x1.000010104002p+47, 0x0p+0 },
{ INT64_C(0x0000800008088000), 0x1.00001011p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7f77fff), -0x1.000010110002p+47, 0x0p+0 },
{ INT64_C(0x00008000080a0000), 0x1.00001014p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7f5ffff), -0x1.000010140002p+47, 0x0p+0 },
{ INT64_C(0x00008000080c0000), 0x1.00001018p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff7f3ffff), -0x1.000010180002p+47, 0x0p+0 },
{ INT64_C(0x0000800008800000), 0x1.000011p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff77fffff), -0x1.000011000002p+47, 0x0p+0 },
{ INT64_C(0x0000800008800008), 0x1.00001100001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff77ffff7), -0x1.000011000012p+47, 0x0p+0 },
{ INT64_C(0x0000800008800040), 0x1.00001100008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff77fffbf), -0x1.000011000082p+47, 0x0p+0 },
{ INT64_C(0x0000800008800200), 0x1.0000110004p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff77ffdff), -0x1.000011000402p+47, 0x0p+0 },
{ INT64_C(0x0000800008800800), 0x1.000011001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff77ff7ff), -0x1.000011001002p+47, 0x0p+0 },
{ INT64_C(0x0000800008808000), 0x1.00001101p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff77f7fff), -0x1.000011010002p+47, 0x0p+0 },
{ INT64_C(0x0000800008810000), 0x1.00001102p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff77effff), -0x1.000011020002p+47, 0x0p+0 },
{ INT64_C(0x0000800008880000), 0x1.0000111p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff777ffff), -0x1.000011100002p+47, 0x0p+0 },
{ INT64_C(0x0000800009000000), 0x1.000012p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff6ffffff), -0x1.000012000002p+47, 0x0p+0 },
{ INT64_C(0x0000800009000001), 0x1.000012000002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff6fffffe), -0x1.000012000004p+47, 0x0p+0 },
{ INT64_C(0x0000800009000010), 0x1.00001200002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff6ffffef), -0x1.000012000022p+47, 0x0p+0 },
{ INT64_C(0x0000800009000080), 0x1.0000120001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff6ffff7f), -0x1.000012000102p+47, 0x0p+0 },
{ INT64_C(0x0000800009000800), 0x1.000012001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff6fff7ff), -0x1.000012001002p+47, 0x0p+0 },
{ INT64_C(0x0000800009001000), 0x1.000012002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff6ffefff), -0x1.000012002002p+47, 0x0p+0 },
{ INT64_C(0x0000800009008000), 0x1.00001201p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff6ff7fff), -0x1.000012010002p+47, 0x0p+0 },
{ INT64_C(0x0000800009020000), 0x1.00001204p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff6fdffff), -0x1.000012040002p+47, 0x0p+0 },
{ INT64_C(0x0000800009200000), 0x1.0000124p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff6dfffff), -0x1.000012400002p+47, 0x0p+0 },
{ INT64_C(0x0000800009800000), 0x1.000013p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff67fffff), -0x1.000013000002p+47, 0x0p+0 },
{ INT64_C(0x000080000a000000), 0x1.000014p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff5ffffff), -0x1.000014000002p+47, 0x0p+0 },
{ INT64_C(0x000080000a000001), 0x1.000014000002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff5fffffe), -0x1.000014000004p+47, 0x0p+0 },
{ INT64_C(0x000080000a000004), 0x1.000014000008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff5fffffb), -0x1.00001400000ap+47, 0x0p+0 },
{ INT64_C(0x000080000a000040), 0x1.00001400008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff5ffffbf), -0x1.000014000082p+47, 0x0p+0 },
{ INT64_C(0x000080000a000400), 0x1.0000140008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff5fffbff), -0x1.000014000802p+47, 0x0p+0 },
{ INT64_C(0x000080000a000800), 0x1.000014001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff5fff7ff), -0x1.000014001002p+47, 0x0p+0 },
{ INT64_C(0x000080000a001000), 0x1.000014002p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff5ffefff), -0x1.000014002002p+47, 0x0p+0 },
{ INT64_C(0x000080000a010000), 0x1.00001402p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff5feffff), -0x1.000014020002p+47, 0x0p+0 },
{ INT64_C(0x000080000a100000), 0x1.0000142p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff5efffff), -0x1.000014200002p+47, 0x0p+0 },
{ INT64_C(0x000080000a400000), 0x1.0000148p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff5bfffff), -0x1.000014800002p+47, 0x0p+0 },
{ INT64_C(0x000080000c000000), 0x1.000018p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff3ffffff), -0x1.000018000002p+47, 0x0p+0 },
{ INT64_C(0x000080000c000008), 0x1.00001800001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff3fffff7), -0x1.000018000012p+47, 0x0p+0 },
{ INT64_C(0x000080000c000080), 0x1.0000180001p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff3ffff7f), -0x1.000018000102p+47, 0x0p+0 },
{ INT64_C(0x000080000c000200), 0x1.0000180004p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff3fffdff), -0x1.000018000402p+47, 0x0p+0 },
{ INT64_C(0x000080000c000400), 0x1.0000180008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff3fffbff), -0x1.000018000802p+47, 0x0p+0 },
{ INT64_C(0x000080000c004000), 0x1.000018008p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff3ffbfff), -0x1.000018008002p+47, 0x0p+0 },
{ INT64_C(0x000080000c020000), 0x1.00001804p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff3fdffff), -0x1.000018040002p+47, 0x0p+0 },
{ INT64_C(0x000080000c100000), 0x1.0000182p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff3efffff), -0x1.000018200002p+47, 0x0p+0 },
{ INT64_C(0x000080000c200000), 0x1.0000184p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff3dfffff), -0x1.000018400002p+47, 0x0p+0 },
{ INT64_C(0x000080000c400000), 0x1.0000188p+47, 0x0p+0 },
{ INT64_C(0xffff7ffff3bfffff), -0x1.000018800002p+47, 0x0p+0 },
{ INT64_C(0x000080000e000000), 0x1.00001cp+47, 0x0p+0 },
{ INT64_C(0xffff7ffff1ffffff), -0x1.00001c000002p+47, 0x0p+0 },
{ INT64_C(0x0000800020000001), 0x1.000040000002p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffffe), -0x1.000040000004p+47, 0x0p+0 },
{ INT64_C(0x0000800020000002), 0x1.000040000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffffd), -0x1.000040000006p+47, 0x0p+0 },
{ INT64_C(0x0000800020000003), 0x1.000040000006p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffffc), -0x1.000040000008p+47, 0x0p+0 },
{ INT64_C(0x0000800020000004), 0x1.000040000008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffffb), -0x1.00004000000ap+47, 0x0p+0 },
{ INT64_C(0x0000800020000010), 0x1.00004000002p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdfffffef), -0x1.000040000022p+47, 0x0p+0 },
{ INT64_C(0x0000800020000018), 0x1.00004000003p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdfffffe7), -0x1.000040000032p+47, 0x0p+0 },
{ INT64_C(0x0000800020000100), 0x1.0000400002p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffeff), -0x1.000040000202p+47, 0x0p+0 },
{ INT64_C(0x0000800020000108), 0x1.00004000021p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffef7), -0x1.000040000212p+47, 0x0p+0 },
{ INT64_C(0x0000800020000110), 0x1.00004000022p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffeef), -0x1.000040000222p+47, 0x0p+0 },
{ INT64_C(0x0000800020000140), 0x1.00004000028p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffebf), -0x1.000040000282p+47, 0x0p+0 },
{ INT64_C(0x0000800020000180), 0x1.0000400003p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffe7f), -0x1.000040000302p+47, 0x0p+0 },
{ INT64_C(0x0000800020000200), 0x1.0000400004p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffdff), -0x1.000040000402p+47, 0x0p+0 },
{ INT64_C(0x0000800020000202), 0x1.000040000404p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffdfd), -0x1.000040000406p+47, 0x0p+0 },
{ INT64_C(0x0000800020000208), 0x1.00004000041p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffdf7), -0x1.000040000412p+47, 0x0p+0 },
{ INT64_C(0x0000800020000280), 0x1.0000400005p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffffd7f), -0x1.000040000502p+47, 0x0p+0 },
{ INT64_C(0x0000800020002000), 0x1.000040004p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdfffdfff), -0x1.000040004002p+47, 0x0p+0 },
{ INT64_C(0x0000800020002004), 0x1.000040004008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdfffdffb), -0x1.00004000400ap+47, 0x0p+0 },
{ INT64_C(0x0000800020002020), 0x1.00004000404p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdfffdfdf), -0x1.000040004042p+47, 0x0p+0 },
{ INT64_C(0x0000800020002100), 0x1.0000400042p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdfffdeff), -0x1.000040004202p+47, 0x0p+0 },
{ INT64_C(0x0000800020002200), 0x1.0000400044p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdfffddff), -0x1.000040004402p+47, 0x0p+0 },
{ INT64_C(0x0000800020020000), 0x1.00004004p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffdffff), -0x1.000040040002p+47, 0x0p+0 },
{ INT64_C(0x0000800020020001), 0x1.000040040002p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffdfffe), -0x1.000040040004p+47, 0x0p+0 },
{ INT64_C(0x0000800020020004), 0x1.000040040008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffdfffb), -0x1.00004004000ap+47, 0x0p+0 },
{ INT64_C(0x0000800020020040), 0x1.00004004008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffdffbf), -0x1.000040040082p+47, 0x0p+0 },
{ INT64_C(0x0000800020020100), 0x1.0000400402p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffdfeff), -0x1.000040040202p+47, 0x0p+0 },
{ INT64_C(0x0000800020020200), 0x1.0000400404p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffdfdff), -0x1.000040040402p+47, 0x0p+0 },
{ INT64_C(0x0000800020020400), 0x1.0000400408p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffdfbff), -0x1.000040040802p+47, 0x0p+0 },
{ INT64_C(0x0000800020024000), 0x1.000040048p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffdbfff), -0x1.000040048002p+47, 0x0p+0 },
{ INT64_C(0x0000800020028000), 0x1.00004005p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdffd7fff), -0x1.000040050002p+47, 0x0p+0 },
{ INT64_C(0x0000800020080000), 0x1.0000401p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdff7ffff), -0x1.000040100002p+47, 0x0p+0 },
{ INT64_C(0x0000800020080002), 0x1.000040100004p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdff7fffd), -0x1.000040100006p+47, 0x0p+0 },
{ INT64_C(0x0000800020080008), 0x1.00004010001p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdff7fff7), -0x1.000040100012p+47, 0x0p+0 },
{ INT64_C(0x0000800020080010), 0x1.00004010002p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdff7ffef), -0x1.000040100022p+47, 0x0p+0 },
{ INT64_C(0x0000800020080080), 0x1.0000401001p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdff7ff7f), -0x1.000040100102p+47, 0x0p+0 },
{ INT64_C(0x0000800020080100), 0x1.0000401002p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdff7feff), -0x1.000040100202p+47, 0x0p+0 },
{ INT64_C(0x0000800020080200), 0x1.0000401004p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdff7fdff), -0x1.000040100402p+47, 0x0p+0 },
{ INT64_C(0x0000800020080800), 0x1.000040101p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdff7f7ff), -0x1.000040101002p+47, 0x0p+0 },
{ INT64_C(0x0000800020081000), 0x1.000040102p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdff7efff), -0x1.000040102002p+47, 0x0p+0 },
{ INT64_C(0x0000800020088000), 0x1.00004011p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdff77fff), -0x1.000040110002p+47, 0x0p+0 },
{ INT64_C(0x0000800020800000), 0x1.000041p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdf7fffff), -0x1.000041000002p+47, 0x0p+0 },
{ INT64_C(0x0000800020800008), 0x1.00004100001p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdf7ffff7), -0x1.000041000012p+47, 0x0p+0 },
{ INT64_C(0x0000800020800080), 0x1.0000410001p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdf7fff7f), -0x1.000041000102p+47, 0x0p+0 },
{ INT64_C(0x0000800020800100), 0x1.0000410002p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdf7ffeff), -0x1.000041000202p+47, 0x0p+0 },
{ INT64_C(0x0000800020800800), 0x1.000041001p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdf7ff7ff), -0x1.000041001002p+47, 0x0p+0 },
{ INT64_C(0x0000800020802000), 0x1.000041004p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdf7fdfff), -0x1.000041004002p+47, 0x0p+0 },
{ INT64_C(0x0000800020808000), 0x1.00004101p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdf7f7fff), -0x1.000041010002p+47, 0x0p+0 },
{ INT64_C(0x0000800020840000), 0x1.00004108p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdf7bffff), -0x1.000041080002p+47, 0x0p+0 },
{ INT64_C(0x0000800020a00000), 0x1.0000414p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdf5fffff), -0x1.000041400002p+47, 0x0p+0 },
{ INT64_C(0x0000800024000000), 0x1.000048p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdbffffff), -0x1.000048000002p+47, 0x0p+0 },
{ INT64_C(0x0000800024000004), 0x1.000048000008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdbfffffb), -0x1.00004800000ap+47, 0x0p+0 },
{ INT64_C(0x0000800024000010), 0x1.00004800002p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdbffffef), -0x1.000048000022p+47, 0x0p+0 },
{ INT64_C(0x0000800024000040), 0x1.00004800008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdbffffbf), -0x1.000048000082p+47, 0x0p+0 },
{ INT64_C(0x0000800024000400), 0x1.0000480008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdbfffbff), -0x1.000048000802p+47, 0x0p+0 },
{ INT64_C(0x0000800024000800), 0x1.000048001p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdbfff7ff), -0x1.000048001002p+47, 0x0p+0 },
{ INT64_C(0x0000800024004000), 0x1.000048008p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdbffbfff), -0x1.000048008002p+47, 0x0p+0 },
{ INT64_C(0x0000800024010000), 0x1.00004802p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdbfeffff), -0x1.000048020002p+47, 0x0p+0 },
{ INT64_C(0x0000800024100000), 0x1.0000482p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdbefffff), -0x1.000048200002p+47, 0x0p+0 },
{ INT64_C(0x0000800024400000), 0x1.0000488p+47, 0x0p+0 },
{ INT64_C(0xffff7fffdbbfffff), -0x1.000048800002p+47, 0x0p+0 },
{ INT64_C(0x0000800080000001), 0x1.000100000002p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffffffe), -0x1.000100000004p+47, 0x0p+0 },
{ INT64_C(0x0000800080000008), 0x1.00010000001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffffff7), -0x1.000100000012p+47, 0x0p+0 },
{ INT64_C(0x0000800080000009), 0x1.000100000012p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffffff6), -0x1.000100000014p+47, 0x0p+0 },
{ INT64_C(0x000080008000000c), 0x1.000100000018p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffffff3), -0x1.00010000001ap+47, 0x0p+0 },
{ INT64_C(0x0000800080000080), 0x1.0001000001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fffff7f), -0x1.000100000102p+47, 0x0p+0 },
{ INT64_C(0x0000800080000084), 0x1.000100000108p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fffff7b), -0x1.00010000010ap+47, 0x0p+0 },
{ INT64_C(0x0000800080000090), 0x1.00010000012p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fffff6f), -0x1.000100000122p+47, 0x0p+0 },
{ INT64_C(0x0000800080000200), 0x1.0001000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffffdff), -0x1.000100000402p+47, 0x0p+0 },
{ INT64_C(0x0000800080000202), 0x1.000100000404p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffffdfd), -0x1.000100000406p+47, 0x0p+0 },
{ INT64_C(0x0000800080000204), 0x1.000100000408p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffffdfb), -0x1.00010000040ap+47, 0x0p+0 },
{ INT64_C(0x0000800080000220), 0x1.00010000044p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffffddf), -0x1.000100000442p+47, 0x0p+0 },
{ INT64_C(0x0000800080000400), 0x1.0001000008p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffffbff), -0x1.000100000802p+47, 0x0p+0 },
{ INT64_C(0x0000800080000404), 0x1.000100000808p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffffbfb), -0x1.00010000080ap+47, 0x0p+0 },
{ INT64_C(0x0000800080000440), 0x1.00010000088p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffffbbf), -0x1.000100000882p+47, 0x0p+0 },
{ INT64_C(0x0000800080000500), 0x1.000100000ap+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffffaff), -0x1.000100000a02p+47, 0x0p+0 },
{ INT64_C(0x0000800080004000), 0x1.000100008p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fffbfff), -0x1.000100008002p+47, 0x0p+0 },
{ INT64_C(0x0000800080004008), 0x1.00010000801p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fffbff7), -0x1.000100008012p+47, 0x0p+0 },
{ INT64_C(0x0000800080004010), 0x1.00010000802p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fffbfef), -0x1.000100008022p+47, 0x0p+0 },
{ INT64_C(0x0000800080004100), 0x1.0001000082p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fffbeff), -0x1.000100008202p+47, 0x0p+0 },
{ INT64_C(0x0000800080005000), 0x1.00010000ap+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fffafff), -0x1.00010000a002p+47, 0x0p+0 },
{ INT64_C(0x0000800080020000), 0x1.00010004p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffdffff), -0x1.000100040002p+47, 0x0p+0 },
{ INT64_C(0x0000800080020008), 0x1.00010004001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffdfff7), -0x1.000100040012p+47, 0x0p+0 },
{ INT64_C(0x0000800080020080), 0x1.0001000401p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffdff7f), -0x1.000100040102p+47, 0x0p+0 },
{ INT64_C(0x0000800080020800), 0x1.000100041p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffdf7ff), -0x1.000100041002p+47, 0x0p+0 },
{ INT64_C(0x0000800080022000), 0x1.000100044p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffddfff), -0x1.000100044002p+47, 0x0p+0 },
{ INT64_C(0x0000800080028000), 0x1.00010005p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ffd7fff), -0x1.000100050002p+47, 0x0p+0 },
{ INT64_C(0x0000800080080000), 0x1.0001001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ff7ffff), -0x1.000100100002p+47, 0x0p+0 },
{ INT64_C(0x0000800080080001), 0x1.000100100002p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ff7fffe), -0x1.000100100004p+47, 0x0p+0 },
{ INT64_C(0x0000800080080004), 0x1.000100100008p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ff7fffb), -0x1.00010010000ap+47, 0x0p+0 },
{ INT64_C(0x0000800080080010), 0x1.00010010002p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ff7ffef), -0x1.000100100022p+47, 0x0p+0 },
{ INT64_C(0x0000800080080040), 0x1.00010010008p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ff7ffbf), -0x1.000100100082p+47, 0x0p+0 },
{ INT64_C(0x0000800080080100), 0x1.0001001002p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ff7feff), -0x1.000100100202p+47, 0x0p+0 },
{ INT64_C(0x0000800080080800), 0x1.000100101p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ff7f7ff), -0x1.000100101002p+47, 0x0p+0 },
{ INT64_C(0x0000800080081000), 0x1.000100102p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ff7efff), -0x1.000100102002p+47, 0x0p+0 },
{ INT64_C(0x0000800080088000), 0x1.00010011p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ff77fff), -0x1.000100110002p+47, 0x0p+0 },
{ INT64_C(0x00008000800a0000), 0x1.00010014p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7ff5ffff), -0x1.000100140002p+47, 0x0p+0 },
{ INT64_C(0x0000800080400000), 0x1.0001008p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fbfffff), -0x1.000100800002p+47, 0x0p+0 },
{ INT64_C(0x0000800080400008), 0x1.00010080001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fbffff7), -0x1.000100800012p+47, 0x0p+0 },
{ INT64_C(0x0000800080400040), 0x1.00010080008p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fbfffbf), -0x1.000100800082p+47, 0x0p+0 },
{ INT64_C(0x0000800080400400), 0x1.0001008008p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fbffbff), -0x1.000100800802p+47, 0x0p+0 },
{ INT64_C(0x0000800080400800), 0x1.000100801p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fbff7ff), -0x1.000100801002p+47, 0x0p+0 },
{ INT64_C(0x0000800080404000), 0x1.000100808p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fbfbfff), -0x1.000100808002p+47, 0x0p+0 },
{ INT64_C(0x0000800080410000), 0x1.00010082p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fbeffff), -0x1.000100820002p+47, 0x0p+0 },
{ INT64_C(0x0000800080500000), 0x1.000100ap+47, 0x0p+0 },
{ INT64_C(0xffff7fff7fafffff), -0x1.000100a00002p+47, 0x0p+0 },
{ INT64_C(0x0000800080600000), 0x1.000100cp+47, 0x0p+0 },
{ INT64_C(0xffff7fff7f9fffff), -0x1.000100c00002p+47, 0x0p+0 },
{ INT64_C(0x0000800080800000), 0x1.000101p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7f7fffff), -0x1.000101000002p+47, 0x0p+0 },
{ INT64_C(0x0000800080800002), 0x1.000101000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7f7ffffd), -0x1.000101000006p+47, 0x0p+0 },
{ INT64_C(0x0000800080800020), 0x1.00010100004p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7f7fffdf), -0x1.000101000042p+47, 0x0p+0 },
{ INT64_C(0x0000800080800040), 0x1.00010100008p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7f7fffbf), -0x1.000101000082p+47, 0x0p+0 },
{ INT64_C(0x0000800080800080), 0x1.0001010001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7f7fff7f), -0x1.000101000102p+47, 0x0p+0 },
{ INT64_C(0x0000800080800400), 0x1.0001010008p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7f7ffbff), -0x1.000101000802p+47, 0x0p+0 },
{ INT64_C(0x0000800080801000), 0x1.000101002p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7f7fefff), -0x1.000101002002p+47, 0x0p+0 },
{ INT64_C(0x0000800080804000), 0x1.000101008p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7f7fbfff), -0x1.000101008002p+47, 0x0p+0 },
{ INT64_C(0x0000800080820000), 0x1.00010104p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7f7dffff), -0x1.000101040002p+47, 0x0p+0 },
{ INT64_C(0x0000800080840000), 0x1.00010108p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7f7bffff), -0x1.000101080002p+47, 0x0p+0 },
{ INT64_C(0x0000800080900000), 0x1.0001012p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7f6fffff), -0x1.000101200002p+47, 0x0p+0 },
{ INT64_C(0x0000800084000000), 0x1.000108p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7bffffff), -0x1.000108000002p+47, 0x0p+0 },
{ INT64_C(0x0000800084000008), 0x1.00010800001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7bfffff7), -0x1.000108000012p+47, 0x0p+0 },
{ INT64_C(0x0000800084000010), 0x1.00010800002p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7bffffef), -0x1.000108000022p+47, 0x0p+0 },
{ INT64_C(0x0000800084000080), 0x1.0001080001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7bffff7f), -0x1.000108000102p+47, 0x0p+0 },
{ INT64_C(0x0000800084000100), 0x1.0001080002p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7bfffeff), -0x1.000108000202p+47, 0x0p+0 },
{ INT64_C(0x0000800084000200), 0x1.0001080004p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7bfffdff), -0x1.000108000402p+47, 0x0p+0 },
{ INT64_C(0x0000800084000800), 0x1.000108001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7bfff7ff), -0x1.000108001002p+47, 0x0p+0 },
{ INT64_C(0x0000800084002000), 0x1.000108004p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7bffdfff), -0x1.000108004002p+47, 0x0p+0 },
{ INT64_C(0x0000800084020000), 0x1.00010804p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7bfdffff), -0x1.000108040002p+47, 0x0p+0 },
{ INT64_C(0x0000800084080000), 0x1.0001081p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7bf7ffff), -0x1.000108100002p+47, 0x0p+0 },
{ INT64_C(0x0000800084100000), 0x1.0001082p+47, 0x0p+0 },
{ INT64_C(0xffff7fff7befffff), -0x1.000108200002p+47, 0x0p+0 },
{ INT64_C(0x0000800085000000), 0x1.00010ap+47, 0x0p+0 },
{ INT64_C(0xffff7fff7affffff), -0x1.00010a000002p+47, 0x0p+0 },
{ INT64_C(0x0000800090000000), 0x1.00012p+47, 0x0p+0 },
{ INT64_C(0xffff7fff6fffffff), -0x1.000120000002p+47, 0x0p+0 },
{ INT64_C(0x0000800090000008), 0x1.00012000001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff6ffffff7), -0x1.000120000012p+47, 0x0p+0 },
{ INT64_C(0x0000800090000020), 0x1.00012000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fff6fffffdf), -0x1.000120000042p+47, 0x0p+0 },
{ INT64_C(0x0000800090000200), 0x1.0001200004p+47, 0x0p+0 },
{ INT64_C(0xffff7fff6ffffdff), -0x1.000120000402p+47, 0x0p+0 },
{ INT64_C(0x0000800090002000), 0x1.000120004p+47, 0x0p+0 },
{ INT64_C(0xffff7fff6fffdfff), -0x1.000120004002p+47, 0x0p+0 },
{ INT64_C(0x0000800090008000), 0x1.00012001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff6fff7fff), -0x1.000120010002p+47, 0x0p+0 },
{ INT64_C(0x0000800090040000), 0x1.00012008p+47, 0x0p+0 },
{ INT64_C(0xffff7fff6ffbffff), -0x1.000120080002p+47, 0x0p+0 },
{ INT64_C(0x0000800090080000), 0x1.0001201p+47, 0x0p+0 },
{ INT64_C(0xffff7fff6ff7ffff), -0x1.000120100002p+47, 0x0p+0 },
{ INT64_C(0x0000800090400000), 0x1.0001208p+47, 0x0p+0 },
{ INT64_C(0xffff7fff6fbfffff), -0x1.000120800002p+47, 0x0p+0 },
{ INT64_C(0x0000800091000000), 0x1.000122p+47, 0x0p+0 },
{ INT64_C(0xffff7fff6effffff), -0x1.000122000002p+47, 0x0p+0 },
{ INT64_C(0x0000800098000000), 0x1.00013p+47, 0x0p+0 },
{ INT64_C(0xffff7fff67ffffff), -0x1.000130000002p+47, 0x0p+0 },
{ INT64_C(0x00008000c0000000), 0x1.00018p+47, 0x0p+0 },
{ INT64_C(0xffff7fff3fffffff), -0x1.000180000002p+47, 0x0p+0 },
{ INT64_C(0x00008000c0000008), 0x1.00018000001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff3ffffff7), -0x1.000180000012p+47, 0x0p+0 },
{ INT64_C(0x00008000c0000010), 0x1.00018000002p+47, 0x0p+0 },
{ INT64_C(0xffff7fff3fffffef), -0x1.000180000022p+47, 0x0p+0 },
{ INT64_C(0x00008000c0000080), 0x1.0001800001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff3fffff7f), -0x1.000180000102p+47, 0x0p+0 },
{ INT64_C(0x00008000c0000100), 0x1.0001800002p+47, 0x0p+0 },
{ INT64_C(0xffff7fff3ffffeff), -0x1.000180000202p+47, 0x0p+0 },
{ INT64_C(0x00008000c0000800), 0x1.000180001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff3ffff7ff), -0x1.000180001002p+47, 0x0p+0 },
{ INT64_C(0x00008000c0004000), 0x1.000180008p+47, 0x0p+0 },
{ INT64_C(0xffff7fff3fffbfff), -0x1.000180008002p+47, 0x0p+0 },
{ INT64_C(0x00008000c0008000), 0x1.00018001p+47, 0x0p+0 },
{ INT64_C(0xffff7fff3fff7fff), -0x1.000180010002p+47, 0x0p+0 },
{ INT64_C(0x00008000c0020000), 0x1.00018004p+47, 0x0p+0 },
{ INT64_C(0xffff7fff3ffdffff), -0x1.000180040002p+47, 0x0p+0 },
{ INT64_C(0x00008000c0100000), 0x1.0001802p+47, 0x0p+0 },
{ INT64_C(0xffff7fff3fefffff), -0x1.000180200002p+47, 0x0p+0 },
{ INT64_C(0x00008000c0800000), 0x1.000181p+47, 0x0p+0 },
{ INT64_C(0xffff7fff3f7fffff), -0x1.000181000002p+47, 0x0p+0 },
{ INT64_C(0x00008000c4000000), 0x1.000188p+47, 0x0p+0 },
{ INT64_C(0xffff7fff3bffffff), -0x1.000188000002p+47, 0x0p+0 },
{ INT64_C(0x0000800800000004), 0x1.001000000008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffffffb), -0x1.00100000000ap+47, 0x0p+0 },
{ INT64_C(0x0000800800000010), 0x1.00100000002p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffffffef), -0x1.001000000022p+47, 0x0p+0 },
{ INT64_C(0x0000800800000012), 0x1.001000000024p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffffffed), -0x1.001000000026p+47, 0x0p+0 },
{ INT64_C(0x0000800800000014), 0x1.001000000028p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffffffeb), -0x1.00100000002ap+47, 0x0p+0 },
{ INT64_C(0x0000800800000018), 0x1.00100000003p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffffffe7), -0x1.001000000032p+47, 0x0p+0 },
{ INT64_C(0x0000800800000020), 0x1.00100000004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffffffdf), -0x1.001000000042p+47, 0x0p+0 },
{ INT64_C(0x0000800800000022), 0x1.001000000044p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffffffdd), -0x1.001000000046p+47, 0x0p+0 },
{ INT64_C(0x0000800800000030), 0x1.00100000006p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffffffcf), -0x1.001000000062p+47, 0x0p+0 },
{ INT64_C(0x0000800800000080), 0x1.0010000001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffffff7f), -0x1.001000000102p+47, 0x0p+0 },
{ INT64_C(0x0000800800000082), 0x1.001000000104p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffffff7d), -0x1.001000000106p+47, 0x0p+0 },
{ INT64_C(0x00008008000000a0), 0x1.00100000014p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffffff5f), -0x1.001000000142p+47, 0x0p+0 },
{ INT64_C(0x0000800800000400), 0x1.0010000008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffffbff), -0x1.001000000802p+47, 0x0p+0 },
{ INT64_C(0x0000800800000402), 0x1.001000000804p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffffbfd), -0x1.001000000806p+47, 0x0p+0 },
{ INT64_C(0x0000800800000420), 0x1.00100000084p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffffbdf), -0x1.001000000842p+47, 0x0p+0 },
{ INT64_C(0x0000800800000500), 0x1.001000000ap+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffffaff), -0x1.001000000a02p+47, 0x0p+0 },
{ INT64_C(0x0000800800000600), 0x1.001000000cp+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffff9ff), -0x1.001000000c02p+47, 0x0p+0 },
{ INT64_C(0x0000800800000800), 0x1.001000001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffff7ff), -0x1.001000001002p+47, 0x0p+0 },
{ INT64_C(0x0000800800000802), 0x1.001000001004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffff7fd), -0x1.001000001006p+47, 0x0p+0 },
{ INT64_C(0x0000800800000820), 0x1.00100000104p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffff7df), -0x1.001000001042p+47, 0x0p+0 },
{ INT64_C(0x0000800800000a00), 0x1.0010000014p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffff5ff), -0x1.001000001402p+47, 0x0p+0 },
{ INT64_C(0x0000800800008000), 0x1.00100001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffff7fff), -0x1.001000010002p+47, 0x0p+0 },
{ INT64_C(0x0000800800008008), 0x1.00100001001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffff7ff7), -0x1.001000010012p+47, 0x0p+0 },
{ INT64_C(0x0000800800008020), 0x1.00100001004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffff7fdf), -0x1.001000010042p+47, 0x0p+0 },
{ INT64_C(0x0000800800008100), 0x1.0010000102p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffff7eff), -0x1.001000010202p+47, 0x0p+0 },
{ INT64_C(0x0000800800008200), 0x1.0010000104p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffff7dff), -0x1.001000010402p+47, 0x0p+0 },
{ INT64_C(0x000080080000a000), 0x1.001000014p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffff5fff), -0x1.001000014002p+47, 0x0p+0 },
{ INT64_C(0x0000800800020000), 0x1.00100004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffdffff), -0x1.001000040002p+47, 0x0p+0 },
{ INT64_C(0x0000800800020002), 0x1.001000040004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffdfffd), -0x1.001000040006p+47, 0x0p+0 },
{ INT64_C(0x0000800800020004), 0x1.001000040008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffdfffb), -0x1.00100004000ap+47, 0x0p+0 },
{ INT64_C(0x0000800800020040), 0x1.00100004008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffdffbf), -0x1.001000040082p+47, 0x0p+0 },
{ INT64_C(0x0000800800020200), 0x1.0010000404p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffdfdff), -0x1.001000040402p+47, 0x0p+0 },
{ INT64_C(0x0000800800021000), 0x1.001000042p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffdefff), -0x1.001000042002p+47, 0x0p+0 },
{ INT64_C(0x0000800800028000), 0x1.00100005p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fffd7fff), -0x1.001000050002p+47, 0x0p+0 },
{ INT64_C(0x0000800800200000), 0x1.0010004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffdfffff), -0x1.001000400002p+47, 0x0p+0 },
{ INT64_C(0x0000800800200008), 0x1.00100040001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffdffff7), -0x1.001000400012p+47, 0x0p+0 },
{ INT64_C(0x0000800800200020), 0x1.00100040004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffdfffdf), -0x1.001000400042p+47, 0x0p+0 },
{ INT64_C(0x0000800800200040), 0x1.00100040008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffdfffbf), -0x1.001000400082p+47, 0x0p+0 },
{ INT64_C(0x0000800800200080), 0x1.0010004001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffdfff7f), -0x1.001000400102p+47, 0x0p+0 },
{ INT64_C(0x0000800800200200), 0x1.0010004004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffdffdff), -0x1.001000400402p+47, 0x0p+0 },
{ INT64_C(0x0000800800202000), 0x1.001000404p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffdfdfff), -0x1.001000404002p+47, 0x0p+0 },
{ INT64_C(0x0000800800208000), 0x1.00100041p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffdf7fff), -0x1.001000410002p+47, 0x0p+0 },
{ INT64_C(0x0000800800220000), 0x1.00100044p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffddffff), -0x1.001000440002p+47, 0x0p+0 },
{ INT64_C(0x0000800800300000), 0x1.0010006p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ffcfffff), -0x1.001000600002p+47, 0x0p+0 },
{ INT64_C(0x0000800800800000), 0x1.001001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ff7fffff), -0x1.001001000002p+47, 0x0p+0 },
{ INT64_C(0x0000800800800004), 0x1.001001000008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ff7ffffb), -0x1.00100100000ap+47, 0x0p+0 },
{ INT64_C(0x0000800800800010), 0x1.00100100002p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ff7fffef), -0x1.001001000022p+47, 0x0p+0 },
{ INT64_C(0x0000800800800040), 0x1.00100100008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ff7fffbf), -0x1.001001000082p+47, 0x0p+0 },
{ INT64_C(0x0000800800800100), 0x1.0010010002p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ff7ffeff), -0x1.001001000202p+47, 0x0p+0 },
{ INT64_C(0x0000800800800800), 0x1.001001001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ff7ff7ff), -0x1.001001001002p+47, 0x0p+0 },
{ INT64_C(0x0000800800801000), 0x1.001001002p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ff7fefff), -0x1.001001002002p+47, 0x0p+0 },
{ INT64_C(0x0000800800810000), 0x1.00100102p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ff7effff), -0x1.001001020002p+47, 0x0p+0 },
{ INT64_C(0x0000800800840000), 0x1.00100108p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ff7bffff), -0x1.001001080002p+47, 0x0p+0 },
{ INT64_C(0x0000800800880000), 0x1.0010011p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ff77ffff), -0x1.001001100002p+47, 0x0p+0 },
{ INT64_C(0x0000800800a00000), 0x1.0010014p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ff5fffff), -0x1.001001400002p+47, 0x0p+0 },
{ INT64_C(0x0000800804000000), 0x1.001008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fbffffff), -0x1.001008000002p+47, 0x0p+0 },
{ INT64_C(0x0000800804000008), 0x1.00100800001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fbfffff7), -0x1.001008000012p+47, 0x0p+0 },
{ INT64_C(0x0000800804000040), 0x1.00100800008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fbffffbf), -0x1.001008000082p+47, 0x0p+0 },
{ INT64_C(0x0000800804000100), 0x1.0010080002p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fbfffeff), -0x1.001008000202p+47, 0x0p+0 },
{ INT64_C(0x0000800804000200), 0x1.0010080004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fbfffdff), -0x1.001008000402p+47, 0x0p+0 },
{ INT64_C(0x0000800804002000), 0x1.001008004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fbffdfff), -0x1.001008004002p+47, 0x0p+0 },
{ INT64_C(0x0000800804020000), 0x1.00100804p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fbfdffff), -0x1.001008040002p+47, 0x0p+0 },
{ INT64_C(0x0000800804100000), 0x1.0010082p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fbefffff), -0x1.001008200002p+47, 0x0p+0 },
{ INT64_C(0x0000800804800000), 0x1.001009p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7fb7fffff), -0x1.001009000002p+47, 0x0p+0 },
{ INT64_C(0x0000800808000000), 0x1.00101p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7f7ffffff), -0x1.001010000002p+47, 0x0p+0 },
{ INT64_C(0x0000800808000008), 0x1.00101000001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7f7fffff7), -0x1.001010000012p+47, 0x0p+0 },
{ INT64_C(0x0000800808000080), 0x1.0010100001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7f7ffff7f), -0x1.001010000102p+47, 0x0p+0 },
{ INT64_C(0x0000800808000400), 0x1.0010100008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7f7fffbff), -0x1.001010000802p+47, 0x0p+0 },
{ INT64_C(0x0000800808000800), 0x1.001010001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7f7fff7ff), -0x1.001010001002p+47, 0x0p+0 },
{ INT64_C(0x0000800808008000), 0x1.00101001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7f7ff7fff), -0x1.001010010002p+47, 0x0p+0 },
{ INT64_C(0x0000800808020000), 0x1.00101004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7f7fdffff), -0x1.001010040002p+47, 0x0p+0 },
{ INT64_C(0x0000800808200000), 0x1.0010104p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7f7dfffff), -0x1.001010400002p+47, 0x0p+0 },
{ INT64_C(0x0000800808400000), 0x1.0010108p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7f7bfffff), -0x1.001010800002p+47, 0x0p+0 },
{ INT64_C(0x0000800809000000), 0x1.001012p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7f6ffffff), -0x1.001012000002p+47, 0x0p+0 },
{ INT64_C(0x000080080c000000), 0x1.001018p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7f3ffffff), -0x1.001018000002p+47, 0x0p+0 },
{ INT64_C(0x0000800810000000), 0x1.00102p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7efffffff), -0x1.001020000002p+47, 0x0p+0 },
{ INT64_C(0x0000800810000008), 0x1.00102000001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7effffff7), -0x1.001020000012p+47, 0x0p+0 },
{ INT64_C(0x0000800810000080), 0x1.0010200001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7efffff7f), -0x1.001020000102p+47, 0x0p+0 },
{ INT64_C(0x0000800810000100), 0x1.0010200002p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7effffeff), -0x1.001020000202p+47, 0x0p+0 },
{ INT64_C(0x0000800810001000), 0x1.001020002p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7efffefff), -0x1.001020002002p+47, 0x0p+0 },
{ INT64_C(0x0000800810002000), 0x1.001020004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7efffdfff), -0x1.001020004002p+47, 0x0p+0 },
{ INT64_C(0x0000800810020000), 0x1.00102004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7effdffff), -0x1.001020040002p+47, 0x0p+0 },
{ INT64_C(0x0000800810040000), 0x1.00102008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7effbffff), -0x1.001020080002p+47, 0x0p+0 },
{ INT64_C(0x0000800810200000), 0x1.0010204p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7efdfffff), -0x1.001020400002p+47, 0x0p+0 },
{ INT64_C(0x0000800810800000), 0x1.001021p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ef7fffff), -0x1.001021000002p+47, 0x0p+0 },
{ INT64_C(0x0000800814000000), 0x1.001028p+47, 0x0p+0 },
{ INT64_C(0xffff7ff7ebffffff), -0x1.001028000002p+47, 0x0p+0 },
{ INT64_C(0x0000800900000000), 0x1.0012p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6ffffffff), -0x1.001200000002p+47, 0x0p+0 },
{ INT64_C(0x0000800900000001), 0x1.001200000002p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6fffffffe), -0x1.001200000004p+47, 0x0p+0 },
{ INT64_C(0x0000800900000010), 0x1.00120000002p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6ffffffef), -0x1.001200000022p+47, 0x0p+0 },
{ INT64_C(0x0000800900000040), 0x1.00120000008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6ffffffbf), -0x1.001200000082p+47, 0x0p+0 },
{ INT64_C(0x0000800900000200), 0x1.0012000004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6fffffdff), -0x1.001200000402p+47, 0x0p+0 },
{ INT64_C(0x0000800900002000), 0x1.001200004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6ffffdfff), -0x1.001200004002p+47, 0x0p+0 },
{ INT64_C(0x0000800900020000), 0x1.00120004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6fffdffff), -0x1.001200040002p+47, 0x0p+0 },
{ INT64_C(0x0000800900040000), 0x1.00120008p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6fffbffff), -0x1.001200080002p+47, 0x0p+0 },
{ INT64_C(0x0000800900080000), 0x1.0012001p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6fff7ffff), -0x1.001200100002p+47, 0x0p+0 },
{ INT64_C(0x0000800900200000), 0x1.0012004p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6ffdfffff), -0x1.001200400002p+47, 0x0p+0 },
{ INT64_C(0x0000800900800000), 0x1.001201p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6ff7fffff), -0x1.001201000002p+47, 0x0p+0 },
{ INT64_C(0x0000800901000000), 0x1.001202p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6feffffff), -0x1.001202000002p+47, 0x0p+0 },
{ INT64_C(0x0000800902000000), 0x1.001204p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6fdffffff), -0x1.001204000002p+47, 0x0p+0 },
{ INT64_C(0x0000800904000000), 0x1.001208p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6fbffffff), -0x1.001208000002p+47, 0x0p+0 },
{ INT64_C(0x0000800908000000), 0x1.00121p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6f7ffffff), -0x1.001210000002p+47, 0x0p+0 },
{ INT64_C(0x0000800920000000), 0x1.00124p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6dfffffff), -0x1.001240000002p+47, 0x0p+0 },
{ INT64_C(0x0000800940000000), 0x1.00128p+47, 0x0p+0 },
{ INT64_C(0xffff7ff6bfffffff), -0x1.001280000002p+47, 0x0p+0 },
{ INT64_C(0x0000802000000001), 0x1.004000000002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffffffe), -0x1.004000000004p+47, 0x0p+0 },
{ INT64_C(0x0000802000000002), 0x1.004000000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffffffd), -0x1.004000000006p+47, 0x0p+0 },
{ INT64_C(0x0000802000000020), 0x1.00400000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffffdf), -0x1.004000000042p+47, 0x0p+0 },
{ INT64_C(0x0000802000000022), 0x1.004000000044p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffffdd), -0x1.004000000046p+47, 0x0p+0 },
{ INT64_C(0x0000802000000024), 0x1.004000000048p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffffdb), -0x1.00400000004ap+47, 0x0p+0 },
{ INT64_C(0x0000802000000030), 0x1.00400000006p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffffcf), -0x1.004000000062p+47, 0x0p+0 },
{ INT64_C(0x0000802000000200), 0x1.0040000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffffdff), -0x1.004000000402p+47, 0x0p+0 },
{ INT64_C(0x0000802000000208), 0x1.00400000041p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffffdf7), -0x1.004000000412p+47, 0x0p+0 },
{ INT64_C(0x0000802000000220), 0x1.00400000044p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffffddf), -0x1.004000000442p+47, 0x0p+0 },
{ INT64_C(0x0000802000001000), 0x1.004000002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffefff), -0x1.004000002002p+47, 0x0p+0 },
{ INT64_C(0x0000802000001001), 0x1.004000002002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffeffe), -0x1.004000002004p+47, 0x0p+0 },
{ INT64_C(0x0000802000001004), 0x1.004000002008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffeffb), -0x1.00400000200ap+47, 0x0p+0 },
{ INT64_C(0x0000802000001020), 0x1.00400000204p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffefdf), -0x1.004000002042p+47, 0x0p+0 },
{ INT64_C(0x0000802000001040), 0x1.00400000208p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffefbf), -0x1.004000002082p+47, 0x0p+0 },
{ INT64_C(0x0000802000001400), 0x1.0040000028p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffebff), -0x1.004000002802p+47, 0x0p+0 },
{ INT64_C(0x0000802000002000), 0x1.004000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffdfff), -0x1.004000004002p+47, 0x0p+0 },
{ INT64_C(0x0000802000002002), 0x1.004000004004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffdffd), -0x1.004000004006p+47, 0x0p+0 },
{ INT64_C(0x0000802000002004), 0x1.004000004008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffdffb), -0x1.00400000400ap+47, 0x0p+0 },
{ INT64_C(0x0000802000002040), 0x1.00400000408p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffdfbf), -0x1.004000004082p+47, 0x0p+0 },
{ INT64_C(0x0000802000002200), 0x1.0040000044p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffddff), -0x1.004000004402p+47, 0x0p+0 },
{ INT64_C(0x0000802000002400), 0x1.0040000048p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffffdbff), -0x1.004000004802p+47, 0x0p+0 },
{ INT64_C(0x0000802000010000), 0x1.00400002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffeffff), -0x1.004000020002p+47, 0x0p+0 },
{ INT64_C(0x0000802000010001), 0x1.004000020002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffefffe), -0x1.004000020004p+47, 0x0p+0 },
{ INT64_C(0x0000802000010010), 0x1.00400002002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffeffef), -0x1.004000020022p+47, 0x0p+0 },
{ INT64_C(0x0000802000010020), 0x1.00400002004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffeffdf), -0x1.004000020042p+47, 0x0p+0 },
{ INT64_C(0x0000802000010040), 0x1.00400002008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffeffbf), -0x1.004000020082p+47, 0x0p+0 },
{ INT64_C(0x0000802000010200), 0x1.0040000204p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffefdff), -0x1.004000020402p+47, 0x0p+0 },
{ INT64_C(0x0000802000012000), 0x1.004000024p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffedfff), -0x1.004000024002p+47, 0x0p+0 },
{ INT64_C(0x0000802000014000), 0x1.004000028p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffffebfff), -0x1.004000028002p+47, 0x0p+0 },
{ INT64_C(0x0000802000080000), 0x1.0040001p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffff7ffff), -0x1.004000100002p+47, 0x0p+0 },
{ INT64_C(0x0000802000080002), 0x1.004000100004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffff7fffd), -0x1.004000100006p+47, 0x0p+0 },
{ INT64_C(0x0000802000080020), 0x1.00400010004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffff7ffdf), -0x1.004000100042p+47, 0x0p+0 },
{ INT64_C(0x0000802000080080), 0x1.0040001001p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffff7ff7f), -0x1.004000100102p+47, 0x0p+0 },
{ INT64_C(0x0000802000080400), 0x1.0040001008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffff7fbff), -0x1.004000100802p+47, 0x0p+0 },
{ INT64_C(0x0000802000084000), 0x1.004000108p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffff7bfff), -0x1.004000108002p+47, 0x0p+0 },
{ INT64_C(0x0000802000090000), 0x1.00400012p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffff6ffff), -0x1.004000120002p+47, 0x0p+0 },
{ INT64_C(0x0000802000400000), 0x1.0040008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffbfffff), -0x1.004000800002p+47, 0x0p+0 },
{ INT64_C(0x0000802000400008), 0x1.00400080001p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffbffff7), -0x1.004000800012p+47, 0x0p+0 },
{ INT64_C(0x0000802000400080), 0x1.0040008001p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffbfff7f), -0x1.004000800102p+47, 0x0p+0 },
{ INT64_C(0x0000802000400100), 0x1.0040008002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffbffeff), -0x1.004000800202p+47, 0x0p+0 },
{ INT64_C(0x0000802000400800), 0x1.004000801p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffbff7ff), -0x1.004000801002p+47, 0x0p+0 },
{ INT64_C(0x0000802000401000), 0x1.004000802p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffbfefff), -0x1.004000802002p+47, 0x0p+0 },
{ INT64_C(0x0000802000410000), 0x1.00400082p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffbeffff), -0x1.004000820002p+47, 0x0p+0 },
{ INT64_C(0x0000802000420000), 0x1.00400084p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffbdffff), -0x1.004000840002p+47, 0x0p+0 },
{ INT64_C(0x0000802000480000), 0x1.0040009p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfffb7ffff), -0x1.004000900002p+47, 0x0p+0 },
{ INT64_C(0x0000802002000000), 0x1.004004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffdffffff), -0x1.004004000002p+47, 0x0p+0 },
{ INT64_C(0x0000802002000002), 0x1.004004000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffdfffffd), -0x1.004004000006p+47, 0x0p+0 },
{ INT64_C(0x0000802002000020), 0x1.00400400004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffdffffdf), -0x1.004004000042p+47, 0x0p+0 },
{ INT64_C(0x0000802002000040), 0x1.00400400008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffdffffbf), -0x1.004004000082p+47, 0x0p+0 },
{ INT64_C(0x0000802002000100), 0x1.0040040002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffdfffeff), -0x1.004004000202p+47, 0x0p+0 },
{ INT64_C(0x0000802002000200), 0x1.0040040004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffdfffdff), -0x1.004004000402p+47, 0x0p+0 },
{ INT64_C(0x0000802002002000), 0x1.004004004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffdffdfff), -0x1.004004004002p+47, 0x0p+0 },
{ INT64_C(0x0000802002008000), 0x1.00400401p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffdff7fff), -0x1.004004010002p+47, 0x0p+0 },
{ INT64_C(0x0000802002080000), 0x1.0040041p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffdf7ffff), -0x1.004004100002p+47, 0x0p+0 },
{ INT64_C(0x0000802002200000), 0x1.0040044p+47, 0x0p+0 },
{ INT64_C(0xffff7fdffddfffff), -0x1.004004400002p+47, 0x0p+0 },
{ INT64_C(0x0000802020000000), 0x1.00404p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfdfffffff), -0x1.004040000002p+47, 0x0p+0 },
{ INT64_C(0x0000802020000008), 0x1.00404000001p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfdffffff7), -0x1.004040000012p+47, 0x0p+0 },
{ INT64_C(0x0000802020000080), 0x1.0040400001p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfdfffff7f), -0x1.004040000102p+47, 0x0p+0 },
{ INT64_C(0x0000802020000200), 0x1.0040400004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfdffffdff), -0x1.004040000402p+47, 0x0p+0 },
{ INT64_C(0x0000802020001000), 0x1.004040002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfdfffefff), -0x1.004040002002p+47, 0x0p+0 },
{ INT64_C(0x0000802020004000), 0x1.004040008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfdfffbfff), -0x1.004040008002p+47, 0x0p+0 },
{ INT64_C(0x0000802020010000), 0x1.00404002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfdffeffff), -0x1.004040020002p+47, 0x0p+0 },
{ INT64_C(0x0000802020080000), 0x1.0040401p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfdff7ffff), -0x1.004040100002p+47, 0x0p+0 },
{ INT64_C(0x0000802020100000), 0x1.0040402p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfdfefffff), -0x1.004040200002p+47, 0x0p+0 },
{ INT64_C(0x0000802020800000), 0x1.004041p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfdf7fffff), -0x1.004041000002p+47, 0x0p+0 },
{ INT64_C(0x0000802028000000), 0x1.00405p+47, 0x0p+0 },
{ INT64_C(0xffff7fdfd7ffffff), -0x1.004050000002p+47, 0x0p+0 },
{ INT64_C(0x0000802100000000), 0x1.0042p+47, 0x0p+0 },
{ INT64_C(0xffff7fdeffffffff), -0x1.004200000002p+47, 0x0p+0 },
{ INT64_C(0x0000802100000008), 0x1.00420000001p+47, 0x0p+0 },
{ INT64_C(0xffff7fdefffffff7), -0x1.004200000012p+47, 0x0p+0 },
{ INT64_C(0x0000802100000010), 0x1.00420000002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdeffffffef), -0x1.004200000022p+47, 0x0p+0 },
{ INT64_C(0x0000802100000040), 0x1.00420000008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdeffffffbf), -0x1.004200000082p+47, 0x0p+0 },
{ INT64_C(0x0000802100000200), 0x1.0042000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdefffffdff), -0x1.004200000402p+47, 0x0p+0 },
{ INT64_C(0x0000802100001000), 0x1.004200002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdeffffefff), -0x1.004200002002p+47, 0x0p+0 },
{ INT64_C(0x0000802100004000), 0x1.004200008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdeffffbfff), -0x1.004200008002p+47, 0x0p+0 },
{ INT64_C(0x0000802100040000), 0x1.00420008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdefffbffff), -0x1.004200080002p+47, 0x0p+0 },
{ INT64_C(0x0000802100200000), 0x1.0042004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdeffdfffff), -0x1.004200400002p+47, 0x0p+0 },
{ INT64_C(0x0000802100400000), 0x1.0042008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdeffbfffff), -0x1.004200800002p+47, 0x0p+0 },
{ INT64_C(0x0000802104000000), 0x1.004208p+47, 0x0p+0 },
{ INT64_C(0xffff7fdefbffffff), -0x1.004208000002p+47, 0x0p+0 },
{ INT64_C(0x0000802110000000), 0x1.00422p+47, 0x0p+0 },
{ INT64_C(0xffff7fdeefffffff), -0x1.004220000002p+47, 0x0p+0 },
{ INT64_C(0x0000802120000000), 0x1.00424p+47, 0x0p+0 },
{ INT64_C(0xffff7fdedfffffff), -0x1.004240000002p+47, 0x0p+0 },
{ INT64_C(0x0000802200000000), 0x1.0044p+47, 0x0p+0 },
{ INT64_C(0xffff7fddffffffff), -0x1.004400000002p+47, 0x0p+0 },
{ INT64_C(0x0000802200000001), 0x1.004400000002p+47, 0x0p+0 },
{ INT64_C(0xffff7fddfffffffe), -0x1.004400000004p+47, 0x0p+0 },
{ INT64_C(0x0000802200000010), 0x1.00440000002p+47, 0x0p+0 },
{ INT64_C(0xffff7fddffffffef), -0x1.004400000022p+47, 0x0p+0 },
{ INT64_C(0x0000802200000100), 0x1.0044000002p+47, 0x0p+0 },
{ INT64_C(0xffff7fddfffffeff), -0x1.004400000202p+47, 0x0p+0 },
{ INT64_C(0x0000802200000200), 0x1.0044000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fddfffffdff), -0x1.004400000402p+47, 0x0p+0 },
{ INT64_C(0x0000802200001000), 0x1.004400002p+47, 0x0p+0 },
{ INT64_C(0xffff7fddffffefff), -0x1.004400002002p+47, 0x0p+0 },
{ INT64_C(0x0000802200004000), 0x1.004400008p+47, 0x0p+0 },
{ INT64_C(0xffff7fddffffbfff), -0x1.004400008002p+47, 0x0p+0 },
{ INT64_C(0x0000802200008000), 0x1.00440001p+47, 0x0p+0 },
{ INT64_C(0xffff7fddffff7fff), -0x1.004400010002p+47, 0x0p+0 },
{ INT64_C(0x0000802200040000), 0x1.00440008p+47, 0x0p+0 },
{ INT64_C(0xffff7fddfffbffff), -0x1.004400080002p+47, 0x0p+0 },
{ INT64_C(0x0000802200200000), 0x1.0044004p+47, 0x0p+0 },
{ INT64_C(0xffff7fddffdfffff), -0x1.004400400002p+47, 0x0p+0 },
{ INT64_C(0x0000802201000000), 0x1.004402p+47, 0x0p+0 },
{ INT64_C(0xffff7fddfeffffff), -0x1.004402000002p+47, 0x0p+0 },
{ INT64_C(0x0000802202000000), 0x1.004404p+47, 0x0p+0 },
{ INT64_C(0xffff7fddfdffffff), -0x1.004404000002p+47, 0x0p+0 },
{ INT64_C(0x0000802210000000), 0x1.00442p+47, 0x0p+0 },
{ INT64_C(0xffff7fddefffffff), -0x1.004420000002p+47, 0x0p+0 },
{ INT64_C(0x0000802280000000), 0x1.0045p+47, 0x0p+0 },
{ INT64_C(0xffff7fdd7fffffff), -0x1.004500000002p+47, 0x0p+0 },
{ INT64_C(0x0000802300000000), 0x1.0046p+47, 0x0p+0 },
{ INT64_C(0xffff7fdcffffffff), -0x1.004600000002p+47, 0x0p+0 },
{ INT64_C(0x0000802400000000), 0x1.0048p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbffffffff), -0x1.004800000002p+47, 0x0p+0 },
{ INT64_C(0x0000802400000002), 0x1.004800000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbfffffffd), -0x1.004800000006p+47, 0x0p+0 },
{ INT64_C(0x0000802400000020), 0x1.00480000004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbffffffdf), -0x1.004800000042p+47, 0x0p+0 },
{ INT64_C(0x0000802400000100), 0x1.0048000002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbfffffeff), -0x1.004800000202p+47, 0x0p+0 },
{ INT64_C(0x0000802400001000), 0x1.004800002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbffffefff), -0x1.004800002002p+47, 0x0p+0 },
{ INT64_C(0x0000802400002000), 0x1.004800004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbffffdfff), -0x1.004800004002p+47, 0x0p+0 },
{ INT64_C(0x0000802400004000), 0x1.004800008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbffffbfff), -0x1.004800008002p+47, 0x0p+0 },
{ INT64_C(0x0000802400008000), 0x1.00480001p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbffff7fff), -0x1.004800010002p+47, 0x0p+0 },
{ INT64_C(0x0000802400010000), 0x1.00480002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbfffeffff), -0x1.004800020002p+47, 0x0p+0 },
{ INT64_C(0x0000802400100000), 0x1.0048002p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbffefffff), -0x1.004800200002p+47, 0x0p+0 },
{ INT64_C(0x0000802400200000), 0x1.0048004p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbffdfffff), -0x1.004800400002p+47, 0x0p+0 },
{ INT64_C(0x0000802400400000), 0x1.0048008p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbffbfffff), -0x1.004800800002p+47, 0x0p+0 },
{ INT64_C(0x0000802404000000), 0x1.004808p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbfbffffff), -0x1.004808000002p+47, 0x0p+0 },
{ INT64_C(0x0000802440000000), 0x1.00488p+47, 0x0p+0 },
{ INT64_C(0xffff7fdbbfffffff), -0x1.004880000002p+47, 0x0p+0 },
{ INT64_C(0x0000802600000000), 0x1.004cp+47, 0x0p+0 },
{ INT64_C(0xffff7fd9ffffffff), -0x1.004c00000002p+47, 0x0p+0 },
{ INT64_C(0x0000810000000002), 0x1.020000000004p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffffffd), -0x1.020000000006p+47, 0x0p+0 },
{ INT64_C(0x0000810000000003), 0x1.020000000006p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffffffc), -0x1.020000000008p+47, 0x0p+0 },
{ INT64_C(0x0000810000000004), 0x1.020000000008p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffffffb), -0x1.02000000000ap+47, 0x0p+0 },
{ INT64_C(0x0000810000000006), 0x1.02000000000cp+47, 0x0p+0 },
{ INT64_C(0xffff7efffffffff9), -0x1.02000000000ep+47, 0x0p+0 },
{ INT64_C(0x0000810000000040), 0x1.02000000008p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffffbf), -0x1.020000000082p+47, 0x0p+0 },
{ INT64_C(0x0000810000000041), 0x1.020000000082p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffffbe), -0x1.020000000084p+47, 0x0p+0 },
{ INT64_C(0x0000810000000044), 0x1.020000000088p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffffbb), -0x1.02000000008ap+47, 0x0p+0 },
{ INT64_C(0x0000810000000048), 0x1.02000000009p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffffb7), -0x1.020000000092p+47, 0x0p+0 },
{ INT64_C(0x0000810000000080), 0x1.0200000001p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffff7f), -0x1.020000000102p+47, 0x0p+0 },
{ INT64_C(0x0000810000000084), 0x1.020000000108p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffff7b), -0x1.02000000010ap+47, 0x0p+0 },
{ INT64_C(0x00008100000000a0), 0x1.02000000014p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffff5f), -0x1.020000000142p+47, 0x0p+0 },
{ INT64_C(0x0000810000000200), 0x1.0200000004p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffffdff), -0x1.020000000402p+47, 0x0p+0 },
{ INT64_C(0x0000810000000201), 0x1.020000000402p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffffdfe), -0x1.020000000404p+47, 0x0p+0 },
{ INT64_C(0x0000810000000202), 0x1.020000000404p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffffdfd), -0x1.020000000406p+47, 0x0p+0 },
{ INT64_C(0x0000810000000210), 0x1.02000000042p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffffdef), -0x1.020000000422p+47, 0x0p+0 },
{ INT64_C(0x0000810000000240), 0x1.02000000048p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffffdbf), -0x1.020000000482p+47, 0x0p+0 },
{ INT64_C(0x0000810000000800), 0x1.020000001p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffff7ff), -0x1.020000001002p+47, 0x0p+0 },
{ INT64_C(0x0000810000000801), 0x1.020000001002p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffff7fe), -0x1.020000001004p+47, 0x0p+0 },
{ INT64_C(0x0000810000000802), 0x1.020000001004p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffff7fd), -0x1.020000001006p+47, 0x0p+0 },
{ INT64_C(0x0000810000000810), 0x1.02000000102p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffff7ef), -0x1.020000001022p+47, 0x0p+0 },
{ INT64_C(0x0000810000000820), 0x1.02000000104p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffff7df), -0x1.020000001042p+47, 0x0p+0 },
{ INT64_C(0x0000810000000840), 0x1.02000000108p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffff7bf), -0x1.020000001082p+47, 0x0p+0 },
{ INT64_C(0x0000810000000900), 0x1.0200000012p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffff6ff), -0x1.020000001202p+47, 0x0p+0 },
{ INT64_C(0x0000810000001000), 0x1.020000002p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffefff), -0x1.020000002002p+47, 0x0p+0 },
{ INT64_C(0x0000810000001004), 0x1.020000002008p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffeffb), -0x1.02000000200ap+47, 0x0p+0 },
{ INT64_C(0x0000810000001010), 0x1.02000000202p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffefef), -0x1.020000002022p+47, 0x0p+0 },
{ INT64_C(0x0000810000001100), 0x1.0200000022p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffeeff), -0x1.020000002202p+47, 0x0p+0 },
{ INT64_C(0x0000810000004000), 0x1.020000008p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffbfff), -0x1.020000008002p+47, 0x0p+0 },
{ INT64_C(0x0000810000004008), 0x1.02000000801p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffbff7), -0x1.020000008012p+47, 0x0p+0 },
{ INT64_C(0x0000810000004020), 0x1.02000000804p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffbfdf), -0x1.020000008042p+47, 0x0p+0 },
{ INT64_C(0x0000810000004200), 0x1.0200000084p+47, 0x0p+0 },
{ INT64_C(0xffff7effffffbdff), -0x1.020000008402p+47, 0x0p+0 },
{ INT64_C(0x0000810000006000), 0x1.02000000cp+47, 0x0p+0 },
{ INT64_C(0xffff7effffff9fff), -0x1.02000000c002p+47, 0x0p+0 },
{ INT64_C(0x0000810000020000), 0x1.02000004p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffdffff), -0x1.020000040002p+47, 0x0p+0 },
{ INT64_C(0x0000810000020008), 0x1.02000004001p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffdfff7), -0x1.020000040012p+47, 0x0p+0 },
{ INT64_C(0x0000810000020020), 0x1.02000004004p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffdffdf), -0x1.020000040042p+47, 0x0p+0 },
{ INT64_C(0x0000810000020040), 0x1.02000004008p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffdffbf), -0x1.020000040082p+47, 0x0p+0 },
{ INT64_C(0x0000810000020100), 0x1.0200000402p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffdfeff), -0x1.020000040202p+47, 0x0p+0 },
{ INT64_C(0x0000810000020800), 0x1.020000041p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffdf7ff), -0x1.020000041002p+47, 0x0p+0 },
{ INT64_C(0x0000810000021000), 0x1.020000042p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffdefff), -0x1.020000042002p+47, 0x0p+0 },
{ INT64_C(0x0000810000030000), 0x1.02000006p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffcffff), -0x1.020000060002p+47, 0x0p+0 },
{ INT64_C(0x0000810000040000), 0x1.02000008p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffbffff), -0x1.020000080002p+47, 0x0p+0 },
{ INT64_C(0x0000810000040008), 0x1.02000008001p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffbfff7), -0x1.020000080012p+47, 0x0p+0 },
{ INT64_C(0x0000810000040040), 0x1.02000008008p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffbffbf), -0x1.020000080082p+47, 0x0p+0 },
{ INT64_C(0x0000810000040100), 0x1.0200000802p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffbfeff), -0x1.020000080202p+47, 0x0p+0 },
{ INT64_C(0x0000810000041000), 0x1.020000082p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffbefff), -0x1.020000082002p+47, 0x0p+0 },
{ INT64_C(0x0000810000042000), 0x1.020000084p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffbdfff), -0x1.020000084002p+47, 0x0p+0 },
{ INT64_C(0x0000810000044000), 0x1.020000088p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffbbfff), -0x1.020000088002p+47, 0x0p+0 },
{ INT64_C(0x0000810000048000), 0x1.02000009p+47, 0x0p+0 },
{ INT64_C(0xffff7efffffb7fff), -0x1.020000090002p+47, 0x0p+0 },
{ INT64_C(0x0000810000200000), 0x1.0200004p+47, 0x0p+0 },
{ INT64_C(0xffff7effffdfffff), -0x1.020000400002p+47, 0x0p+0 },
{ INT64_C(0x0000810000200002), 0x1.020000400004p+47, 0x0p+0 },
{ INT64_C(0xffff7effffdffffd), -0x1.020000400006p+47, 0x0p+0 },
{ INT64_C(0x0000810000200020), 0x1.02000040004p+47, 0x0p+0 },
{ INT64_C(0xffff7effffdfffdf), -0x1.020000400042p+47, 0x0p+0 },
{ INT64_C(0x0000810000200100), 0x1.0200004002p+47, 0x0p+0 },
{ INT64_C(0xffff7effffdffeff), -0x1.020000400202p+47, 0x0p+0 },
{ INT64_C(0x0000810000200200), 0x1.0200004004p+47, 0x0p+0 },
{ INT64_C(0xffff7effffdffdff), -0x1.020000400402p+47, 0x0p+0 },
{ INT64_C(0x0000810000202000), 0x1.020000404p+47, 0x0p+0 },
{ INT64_C(0xffff7effffdfdfff), -0x1.020000404002p+47, 0x0p+0 },
{ INT64_C(0x0000810000220000), 0x1.02000044p+47, 0x0p+0 },
{ INT64_C(0xffff7effffddffff), -0x1.020000440002p+47, 0x0p+0 },
{ INT64_C(0x0000810001000000), 0x1.020002p+47, 0x0p+0 },
{ INT64_C(0xffff7efffeffffff), -0x1.020002000002p+47, 0x0p+0 },
{ INT64_C(0x0000810001000008), 0x1.02000200001p+47, 0x0p+0 },
{ INT64_C(0xffff7efffefffff7), -0x1.020002000012p+47, 0x0p+0 },
{ INT64_C(0x0000810001000040), 0x1.02000200008p+47, 0x0p+0 },
{ INT64_C(0xffff7efffeffffbf), -0x1.020002000082p+47, 0x0p+0 },
{ INT64_C(0x0000810001000080), 0x1.0200020001p+47, 0x0p+0 },
{ INT64_C(0xffff7efffeffff7f), -0x1.020002000102p+47, 0x0p+0 },
{ INT64_C(0x0000810001000100), 0x1.0200020002p+47, 0x0p+0 },
{ INT64_C(0xffff7efffefffeff), -0x1.020002000202p+47, 0x0p+0 },
{ INT64_C(0x0000810001000200), 0x1.0200020004p+47, 0x0p+0 },
{ INT64_C(0xffff7efffefffdff), -0x1.020002000402p+47, 0x0p+0 },
{ INT64_C(0x0000810001000400), 0x1.0200020008p+47, 0x0p+0 },
{ INT64_C(0xffff7efffefffbff), -0x1.020002000802p+47, 0x0p+0 },
{ INT64_C(0x0000810001000800), 0x1.020002001p+47, 0x0p+0 },
{ INT64_C(0xffff7efffefff7ff), -0x1.020002001002p+47, 0x0p+0 },
{ INT64_C(0x0000810001001000), 0x1.020002002p+47, 0x0p+0 },
{ INT64_C(0xffff7efffeffefff), -0x1.020002002002p+47, 0x0p+0 },
{ INT64_C(0x0000810001002000), 0x1.020002004p+47, 0x0p+0 },
{ INT64_C(0xffff7efffeffdfff), -0x1.020002004002p+47, 0x0p+0 },
{ INT64_C(0x0000810001010000), 0x1.02000202p+47, 0x0p+0 },
{ INT64_C(0xffff7efffefeffff), -0x1.020002020002p+47, 0x0p+0 },
{ INT64_C(0x0000810001100000), 0x1.0200022p+47, 0x0p+0 },
{ INT64_C(0xffff7efffeefffff), -0x1.020002200002p+47, 0x0p+0 },
{ INT64_C(0x0000810001200000), 0x1.0200024p+47, 0x0p+0 },
{ INT64_C(0xffff7efffedfffff), -0x1.020002400002p+47, 0x0p+0 },
{ INT64_C(0x0000810001400000), 0x1.0200028p+47, 0x0p+0 },
{ INT64_C(0xffff7efffebfffff), -0x1.020002800002p+47, 0x0p+0 },
{ INT64_C(0x0000810010000000), 0x1.02002p+47, 0x0p+0 },
{ INT64_C(0xffff7effefffffff), -0x1.020020000002p+47, 0x0p+0 },
{ INT64_C(0x0000810010000001), 0x1.020020000002p+47, 0x0p+0 },
{ INT64_C(0xffff7effeffffffe), -0x1.020020000004p+47, 0x0p+0 },
{ INT64_C(0x0000810010000010), 0x1.02002000002p+47, 0x0p+0 },
{ INT64_C(0xffff7effefffffef), -0x1.020020000022p+47, 0x0p+0 },
{ INT64_C(0x0000810010000020), 0x1.02002000004p+47, 0x0p+0 },
{ INT64_C(0xffff7effefffffdf), -0x1.020020000042p+47, 0x0p+0 },
{ INT64_C(0x0000810010000200), 0x1.0200200004p+47, 0x0p+0 },
{ INT64_C(0xffff7effeffffdff), -0x1.020020000402p+47, 0x0p+0 },
{ INT64_C(0x0000810010001000), 0x1.020020002p+47, 0x0p+0 },
{ INT64_C(0xffff7effefffefff), -0x1.020020002002p+47, 0x0p+0 },
{ INT64_C(0x0000810010002000), 0x1.020020004p+47, 0x0p+0 },
{ INT64_C(0xffff7effefffdfff), -0x1.020020004002p+47, 0x0p+0 },
{ INT64_C(0x0000810010010000), 0x1.02002002p+47, 0x0p+0 },
{ INT64_C(0xffff7effeffeffff), -0x1.020020020002p+47, 0x0p+0 },
{ INT64_C(0x0000810010020000), 0x1.02002004p+47, 0x0p+0 },
{ INT64_C(0xffff7effeffdffff), -0x1.020020040002p+47, 0x0p+0 },
{ INT64_C(0x0000810010200000), 0x1.0200204p+47, 0x0p+0 },
{ INT64_C(0xffff7effefdfffff), -0x1.020020400002p+47, 0x0p+0 },
{ INT64_C(0x0000810012000000), 0x1.020024p+47, 0x0p+0 },
{ INT64_C(0xffff7effedffffff), -0x1.020024000002p+47, 0x0p+0 },
{ INT64_C(0x0000810018000000), 0x1.02003p+47, 0x0p+0 },
{ INT64_C(0xffff7effe7ffffff), -0x1.020030000002p+47, 0x0p+0 },
{ INT64_C(0x0000810020000000), 0x1.02004p+47, 0x0p+0 },
{ INT64_C(0xffff7effdfffffff), -0x1.020040000002p+47, 0x0p+0 },
{ INT64_C(0x0000810020000002), 0x1.020040000004p+47, 0x0p+0 },
{ INT64_C(0xffff7effdffffffd), -0x1.020040000006p+47, 0x0p+0 },
{ INT64_C(0x0000810020000020), 0x1.02004000004p+47, 0x0p+0 },
{ INT64_C(0xffff7effdfffffdf), -0x1.020040000042p+47, 0x0p+0 },
{ INT64_C(0x0000810020000080), 0x1.0200400001p+47, 0x0p+0 },
{ INT64_C(0xffff7effdfffff7f), -0x1.020040000102p+47, 0x0p+0 },
{ INT64_C(0x0000810020000100), 0x1.0200400002p+47, 0x0p+0 },
{ INT64_C(0xffff7effdffffeff), -0x1.020040000202p+47, 0x0p+0 },
{ INT64_C(0x0000810020000400), 0x1.0200400008p+47, 0x0p+0 },
{ INT64_C(0xffff7effdffffbff), -0x1.020040000802p+47, 0x0p+0 },
{ INT64_C(0x0000810020002000), 0x1.020040004p+47, 0x0p+0 },
{ INT64_C(0xffff7effdfffdfff), -0x1.020040004002p+47, 0x0p+0 },
{ INT64_C(0x0000810020020000), 0x1.02004004p+47, 0x0p+0 },
{ INT64_C(0xffff7effdffdffff), -0x1.020040040002p+47, 0x0p+0 },
{ INT64_C(0x0000810020100000), 0x1.0200402p+47, 0x0p+0 },
{ INT64_C(0xffff7effdfefffff), -0x1.020040200002p+47, 0x0p+0 },
{ INT64_C(0x0000810021000000), 0x1.020042p+47, 0x0p+0 },
{ INT64_C(0xffff7effdeffffff), -0x1.020042000002p+47, 0x0p+0 },
{ INT64_C(0x0000810030000000), 0x1.02006p+47, 0x0p+0 },
{ INT64_C(0xffff7effcfffffff), -0x1.020060000002p+47, 0x0p+0 },
{ INT64_C(0x0000810080000000), 0x1.0201p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7fffffff), -0x1.020100000002p+47, 0x0p+0 },
{ INT64_C(0x0000810080000002), 0x1.020100000004p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7ffffffd), -0x1.020100000006p+47, 0x0p+0 },
{ INT64_C(0x0000810080000010), 0x1.02010000002p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7fffffef), -0x1.020100000022p+47, 0x0p+0 },
{ INT64_C(0x0000810080000080), 0x1.0201000001p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7fffff7f), -0x1.020100000102p+47, 0x0p+0 },
{ INT64_C(0x0000810080000400), 0x1.0201000008p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7ffffbff), -0x1.020100000802p+47, 0x0p+0 },
{ INT64_C(0x0000810080002000), 0x1.020100004p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7fffdfff), -0x1.020100004002p+47, 0x0p+0 },
{ INT64_C(0x0000810080004000), 0x1.020100008p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7fffbfff), -0x1.020100008002p+47, 0x0p+0 },
{ INT64_C(0x0000810080010000), 0x1.02010002p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7ffeffff), -0x1.020100020002p+47, 0x0p+0 },
{ INT64_C(0x0000810080020000), 0x1.02010004p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7ffdffff), -0x1.020100040002p+47, 0x0p+0 },
{ INT64_C(0x0000810080040000), 0x1.02010008p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7ffbffff), -0x1.020100080002p+47, 0x0p+0 },
{ INT64_C(0x0000810080080000), 0x1.0201001p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7ff7ffff), -0x1.020100100002p+47, 0x0p+0 },
{ INT64_C(0x0000810080100000), 0x1.0201002p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7fefffff), -0x1.020100200002p+47, 0x0p+0 },
{ INT64_C(0x0000810080400000), 0x1.0201008p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7fbfffff), -0x1.020100800002p+47, 0x0p+0 },
{ INT64_C(0x0000810080800000), 0x1.020101p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7f7fffff), -0x1.020101000002p+47, 0x0p+0 },
{ INT64_C(0x0000810084000000), 0x1.020108p+47, 0x0p+0 },
{ INT64_C(0xffff7eff7bffffff), -0x1.020108000002p+47, 0x0p+0 },
{ INT64_C(0x00008100a0000000), 0x1.02014p+47, 0x0p+0 },
{ INT64_C(0xffff7eff5fffffff), -0x1.020140000002p+47, 0x0p+0 },
{ INT64_C(0x0000810100000000), 0x1.0202p+47, 0x0p+0 },
{ INT64_C(0xffff7efeffffffff), -0x1.020200000002p+47, 0x0p+0 },
{ INT64_C(0x0000810100000001), 0x1.020200000002p+47, 0x0p+0 },
{ INT64_C(0xffff7efefffffffe), -0x1.020200000004p+47, 0x0p+0 },
{ INT64_C(0x0000810100000010), 0x1.02020000002p+47, 0x0p+0 },
{ INT64_C(0xffff7efeffffffef), -0x1.020200000022p+47, 0x0p+0 },
{ INT64_C(0x0000810100000040), 0x1.02020000008p+47, 0x0p+0 },
{ INT64_C(0xffff7efeffffffbf), -0x1.020200000082p+47, 0x0p+0 },
{ INT64_C(0x0000810100000080), 0x1.0202000001p+47, 0x0p+0 },
{ INT64_C(0xffff7efeffffff7f), -0x1.020200000102p+47, 0x0p+0 },
{ INT64_C(0x0000810100000200), 0x1.0202000004p+47, 0x0p+0 },
{ INT64_C(0xffff7efefffffdff), -0x1.020200000402p+47, 0x0p+0 },
{ INT64_C(0x0000810100002000), 0x1.020200004p+47, 0x0p+0 },
{ INT64_C(0xffff7efeffffdfff), -0x1.020200004002p+47, 0x0p+0 },
{ INT64_C(0x0000810100008000), 0x1.02020001p+47, 0x0p+0 },
{ INT64_C(0xffff7efeffff7fff), -0x1.020200010002p+47, 0x0p+0 },
{ INT64_C(0x0000810100080000), 0x1.0202001p+47, 0x0p+0 },
{ INT64_C(0xffff7efefff7ffff), -0x1.020200100002p+47, 0x0p+0 },
{ INT64_C(0x0000810100800000), 0x1.020201p+47, 0x0p+0 },
{ INT64_C(0xffff7efeff7fffff), -0x1.020201000002p+47, 0x0p+0 },
{ INT64_C(0x0000810108000000), 0x1.02021p+47, 0x0p+0 },
{ INT64_C(0xffff7efef7ffffff), -0x1.020210000002p+47, 0x0p+0 },
{ INT64_C(0x0000810180000000), 0x1.0203p+47, 0x0p+0 },
{ INT64_C(0xffff7efe7fffffff), -0x1.020300000002p+47, 0x0p+0 },
{ INT64_C(0x0000810800000000), 0x1.021p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7ffffffff), -0x1.021000000002p+47, 0x0p+0 },
{ INT64_C(0x0000810800000004), 0x1.021000000008p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7fffffffb), -0x1.02100000000ap+47, 0x0p+0 },
{ INT64_C(0x0000810800000020), 0x1.02100000004p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7ffffffdf), -0x1.021000000042p+47, 0x0p+0 },
{ INT64_C(0x0000810800000200), 0x1.0210000004p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7fffffdff), -0x1.021000000402p+47, 0x0p+0 },
{ INT64_C(0x0000810800001000), 0x1.021000002p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7ffffefff), -0x1.021000002002p+47, 0x0p+0 },
{ INT64_C(0x0000810800004000), 0x1.021000008p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7ffffbfff), -0x1.021000008002p+47, 0x0p+0 },
{ INT64_C(0x0000810800008000), 0x1.02100001p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7ffff7fff), -0x1.021000010002p+47, 0x0p+0 },
{ INT64_C(0x0000810800010000), 0x1.02100002p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7fffeffff), -0x1.021000020002p+47, 0x0p+0 },
{ INT64_C(0x0000810800080000), 0x1.0210001p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7fff7ffff), -0x1.021000100002p+47, 0x0p+0 },
{ INT64_C(0x0000810800100000), 0x1.0210002p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7ffefffff), -0x1.021000200002p+47, 0x0p+0 },
{ INT64_C(0x0000810800400000), 0x1.0210008p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7ffbfffff), -0x1.021000800002p+47, 0x0p+0 },
{ INT64_C(0x0000810801000000), 0x1.021002p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7feffffff), -0x1.021002000002p+47, 0x0p+0 },
{ INT64_C(0x0000810810000000), 0x1.02102p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7efffffff), -0x1.021020000002p+47, 0x0p+0 },
{ INT64_C(0x0000810840000000), 0x1.02108p+47, 0x0p+0 },
{ INT64_C(0xffff7ef7bfffffff), -0x1.021080000002p+47, 0x0p+0 },
{ INT64_C(0x0000810a00000000), 0x1.0214p+47, 0x0p+0 },
{ INT64_C(0xffff7ef5ffffffff), -0x1.021400000002p+47, 0x0p+0 },
{ INT64_C(0x0000814000000000), 0x1.028p+47, 0x0p+0 },
{ INT64_C(0xffff7ebfffffffff), -0x1.028000000002p+47, 0x0p+0 },
{ INT64_C(0x0000814000000008), 0x1.02800000001p+47, 0x0p+0 },
{ INT64_C(0xffff7ebffffffff7), -0x1.028000000012p+47, 0x0p+0 },
{ INT64_C(0x0000814000000040), 0x1.02800000008p+47, 0x0p+0 },
{ INT64_C(0xffff7ebfffffffbf), -0x1.028000000082p+47, 0x0p+0 },
{ INT64_C(0x0000814000000100), 0x1.0280000002p+47, 0x0p+0 },
{ INT64_C(0xffff7ebffffffeff), -0x1.028000000202p+47, 0x0p+0 },
{ INT64_C(0x0000814000000800), 0x1.028000001p+47, 0x0p+0 },
{ INT64_C(0xffff7ebffffff7ff), -0x1.028000001002p+47, 0x0p+0 },
{ INT64_C(0x0000814000004000), 0x1.028000008p+47, 0x0p+0 },
{ INT64_C(0xffff7ebfffffbfff), -0x1.028000008002p+47, 0x0p+0 },
{ INT64_C(0x0000814000020000), 0x1.02800004p+47, 0x0p+0 },
{ INT64_C(0xffff7ebffffdffff), -0x1.028000040002p+47, 0x0p+0 },
{ INT64_C(0x0000814000040000), 0x1.02800008p+47, 0x0p+0 },
{ INT64_C(0xffff7ebffffbffff), -0x1.028000080002p+47, 0x0p+0 },
{ INT64_C(0x0000814000200000), 0x1.0280004p+47, 0x0p+0 },
{ INT64_C(0xffff7ebfffdfffff), -0x1.028000400002p+47, 0x0p+0 },
{ INT64_C(0x0000814000800000), 0x1.028001p+47, 0x0p+0 },
{ INT64_C(0xffff7ebfff7fffff), -0x1.028001000002p+47, 0x0p+0 },
{ INT64_C(0x0000814001000000), 0x1.028002p+47, 0x0p+0 },
{ INT64_C(0xffff7ebffeffffff), -0x1.028002000002p+47, 0x0p+0 },
{ INT64_C(0x0000814002000000), 0x1.028004p+47, 0x0p+0 },
{ INT64_C(0xffff7ebffdffffff), -0x1.028004000002p+47, 0x0p+0 },
{ INT64_C(0x0000814008000000), 0x1.02801p+47, 0x0p+0 },
{ INT64_C(0xffff7ebff7ffffff), -0x1.028010000002p+47, 0x0p+0 },
{ INT64_C(0x0000814020000000), 0x1.02804p+47, 0x0p+0 },
{ INT64_C(0xffff7ebfdfffffff), -0x1.028040000002p+47, 0x0p+0 },
{ INT64_C(0x0000814040000000), 0x1.02808p+47, 0x0p+0 },
{ INT64_C(0xffff7ebfbfffffff), -0x1.028080000002p+47, 0x0p+0 },
{ INT64_C(0x0000814080000000), 0x1.0281p+47, 0x0p+0 },
{ INT64_C(0xffff7ebf7fffffff), -0x1.028100000002p+47, 0x0p+0 },
{ INT64_C(0x0000814800000000), 0x1.029p+47, 0x0p+0 },
{ INT64_C(0xffff7eb7ffffffff), -0x1.029000000002p+47, 0x0p+0 },
{ INT64_C(0x0000900000000002), 0x1.200000000004p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffffffd), -0x1.200000000006p+47, 0x0p+0 },
{ INT64_C(0x0000900000000003), 0x1.200000000006p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffffffc), -0x1.200000000008p+47, 0x0p+0 },
{ INT64_C(0x0000900000000008), 0x1.20000000001p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffffff7), -0x1.200000000012p+47, 0x0p+0 },
{ INT64_C(0x000090000000000a), 0x1.200000000014p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffffff5), -0x1.200000000016p+47, 0x0p+0 },
{ INT64_C(0x0000900000000020), 0x1.20000000004p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffffdf), -0x1.200000000042p+47, 0x0p+0 },
{ INT64_C(0x0000900000000021), 0x1.200000000042p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffffde), -0x1.200000000044p+47, 0x0p+0 },
{ INT64_C(0x0000900000000024), 0x1.200000000048p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffffdb), -0x1.20000000004ap+47, 0x0p+0 },
{ INT64_C(0x0000900000000200), 0x1.2000000004p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffffdff), -0x1.200000000402p+47, 0x0p+0 },
{ INT64_C(0x0000900000000202), 0x1.200000000404p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffffdfd), -0x1.200000000406p+47, 0x0p+0 },
{ INT64_C(0x0000900000000204), 0x1.200000000408p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffffdfb), -0x1.20000000040ap+47, 0x0p+0 },
{ INT64_C(0x0000900000000208), 0x1.20000000041p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffffdf7), -0x1.200000000412p+47, 0x0p+0 },
{ INT64_C(0x0000900000000210), 0x1.20000000042p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffffdef), -0x1.200000000422p+47, 0x0p+0 },
{ INT64_C(0x0000900000000280), 0x1.2000000005p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffffd7f), -0x1.200000000502p+47, 0x0p+0 },
{ INT64_C(0x0000900000000800), 0x1.200000001p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffff7ff), -0x1.200000001002p+47, 0x0p+0 },
{ INT64_C(0x0000900000000804), 0x1.200000001008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffff7fb), -0x1.20000000100ap+47, 0x0p+0 },
{ INT64_C(0x0000900000000840), 0x1.20000000108p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffff7bf), -0x1.200000001082p+47, 0x0p+0 },
{ INT64_C(0x0000900000000c00), 0x1.2000000018p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffff3ff), -0x1.200000001802p+47, 0x0p+0 },
{ INT64_C(0x0000900000001000), 0x1.200000002p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffefff), -0x1.200000002002p+47, 0x0p+0 },
{ INT64_C(0x0000900000001001), 0x1.200000002002p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffeffe), -0x1.200000002004p+47, 0x0p+0 },
{ INT64_C(0x0000900000001008), 0x1.20000000201p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffeff7), -0x1.200000002012p+47, 0x0p+0 },
{ INT64_C(0x0000900000001010), 0x1.20000000202p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffefef), -0x1.200000002022p+47, 0x0p+0 },
{ INT64_C(0x0000900000001020), 0x1.20000000204p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffefdf), -0x1.200000002042p+47, 0x0p+0 },
{ INT64_C(0x0000900000001040), 0x1.20000000208p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffefbf), -0x1.200000002082p+47, 0x0p+0 },
{ INT64_C(0x0000900000001080), 0x1.2000000021p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffef7f), -0x1.200000002102p+47, 0x0p+0 },
{ INT64_C(0x0000900000001100), 0x1.2000000022p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffeeff), -0x1.200000002202p+47, 0x0p+0 },
{ INT64_C(0x0000900000001200), 0x1.2000000024p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffedff), -0x1.200000002402p+47, 0x0p+0 },
{ INT64_C(0x0000900000004000), 0x1.200000008p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffbfff), -0x1.200000008002p+47, 0x0p+0 },
{ INT64_C(0x0000900000004001), 0x1.200000008002p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffbffe), -0x1.200000008004p+47, 0x0p+0 },
{ INT64_C(0x0000900000004002), 0x1.200000008004p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffbffd), -0x1.200000008006p+47, 0x0p+0 },
{ INT64_C(0x0000900000004004), 0x1.200000008008p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffbffb), -0x1.20000000800ap+47, 0x0p+0 },
{ INT64_C(0x0000900000004010), 0x1.20000000802p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffbfef), -0x1.200000008022p+47, 0x0p+0 },
{ INT64_C(0x0000900000004100), 0x1.2000000082p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffbeff), -0x1.200000008202p+47, 0x0p+0 },
{ INT64_C(0x0000900000004200), 0x1.2000000084p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffbdff), -0x1.200000008402p+47, 0x0p+0 },
{ INT64_C(0x0000900000004800), 0x1.200000009p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffffb7ff), -0x1.200000009002p+47, 0x0p+0 },
{ INT64_C(0x0000900000006000), 0x1.20000000cp+47, 0x0p+0 },
{ INT64_C(0xffff6fffffff9fff), -0x1.20000000c002p+47, 0x0p+0 },
{ INT64_C(0x0000900000020000), 0x1.20000004p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffdffff), -0x1.200000040002p+47, 0x0p+0 },
{ INT64_C(0x0000900000020004), 0x1.200000040008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffdfffb), -0x1.20000004000ap+47, 0x0p+0 },
{ INT64_C(0x0000900000020008), 0x1.20000004001p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffdfff7), -0x1.200000040012p+47, 0x0p+0 },
{ INT64_C(0x0000900000020010), 0x1.20000004002p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffdffef), -0x1.200000040022p+47, 0x0p+0 },
{ INT64_C(0x0000900000020040), 0x1.20000004008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffdffbf), -0x1.200000040082p+47, 0x0p+0 },
{ INT64_C(0x0000900000020200), 0x1.2000000404p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffdfdff), -0x1.200000040402p+47, 0x0p+0 },
{ INT64_C(0x0000900000020400), 0x1.2000000408p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffdfbff), -0x1.200000040802p+47, 0x0p+0 },
{ INT64_C(0x0000900000022000), 0x1.200000044p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffffddfff), -0x1.200000044002p+47, 0x0p+0 },
{ INT64_C(0x0000900000080000), 0x1.2000001p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffff7ffff), -0x1.200000100002p+47, 0x0p+0 },
{ INT64_C(0x0000900000080004), 0x1.200000100008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffff7fffb), -0x1.20000010000ap+47, 0x0p+0 },
{ INT64_C(0x0000900000080020), 0x1.20000010004p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffff7ffdf), -0x1.200000100042p+47, 0x0p+0 },
{ INT64_C(0x0000900000080040), 0x1.20000010008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffff7ffbf), -0x1.200000100082p+47, 0x0p+0 },
{ INT64_C(0x0000900000080100), 0x1.2000001002p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffff7feff), -0x1.200000100202p+47, 0x0p+0 },
{ INT64_C(0x0000900000080200), 0x1.2000001004p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffff7fdff), -0x1.200000100402p+47, 0x0p+0 },
{ INT64_C(0x0000900000080400), 0x1.2000001008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffff7fbff), -0x1.200000100802p+47, 0x0p+0 },
{ INT64_C(0x0000900000080800), 0x1.200000101p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffff7f7ff), -0x1.200000101002p+47, 0x0p+0 },
{ INT64_C(0x0000900000088000), 0x1.20000011p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffff77fff), -0x1.200000110002p+47, 0x0p+0 },
{ INT64_C(0x0000900000090000), 0x1.20000012p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffff6ffff), -0x1.200000120002p+47, 0x0p+0 },
{ INT64_C(0x00009000000c0000), 0x1.20000018p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffff3ffff), -0x1.200000180002p+47, 0x0p+0 },
{ INT64_C(0x0000900000100000), 0x1.2000002p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffefffff), -0x1.200000200002p+47, 0x0p+0 },
{ INT64_C(0x0000900000100002), 0x1.200000200004p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffeffffd), -0x1.200000200006p+47, 0x0p+0 },
{ INT64_C(0x0000900000100004), 0x1.200000200008p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffeffffb), -0x1.20000020000ap+47, 0x0p+0 },
{ INT64_C(0x0000900000100020), 0x1.20000020004p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffefffdf), -0x1.200000200042p+47, 0x0p+0 },
{ INT64_C(0x0000900000100080), 0x1.2000002001p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffefff7f), -0x1.200000200102p+47, 0x0p+0 },
{ INT64_C(0x0000900000100400), 0x1.2000002008p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffeffbff), -0x1.200000200802p+47, 0x0p+0 },
{ INT64_C(0x0000900000100800), 0x1.200000201p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffeff7ff), -0x1.200000201002p+47, 0x0p+0 },
{ INT64_C(0x0000900000102000), 0x1.200000204p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffefdfff), -0x1.200000204002p+47, 0x0p+0 },
{ INT64_C(0x0000900000104000), 0x1.200000208p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffefbfff), -0x1.200000208002p+47, 0x0p+0 },
{ INT64_C(0x0000900000120000), 0x1.20000024p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffedffff), -0x1.200000240002p+47, 0x0p+0 },
{ INT64_C(0x0000900000400000), 0x1.2000008p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffbfffff), -0x1.200000800002p+47, 0x0p+0 },
{ INT64_C(0x0000900000400001), 0x1.200000800002p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffbffffe), -0x1.200000800004p+47, 0x0p+0 },
{ INT64_C(0x0000900000400004), 0x1.200000800008p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffbffffb), -0x1.20000080000ap+47, 0x0p+0 },
{ INT64_C(0x0000900000400010), 0x1.20000080002p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffbfffef), -0x1.200000800022p+47, 0x0p+0 },
{ INT64_C(0x0000900000400100), 0x1.2000008002p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffbffeff), -0x1.200000800202p+47, 0x0p+0 },
{ INT64_C(0x0000900000400400), 0x1.2000008008p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffbffbff), -0x1.200000800802p+47, 0x0p+0 },
{ INT64_C(0x0000900000401000), 0x1.200000802p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffbfefff), -0x1.200000802002p+47, 0x0p+0 },
{ INT64_C(0x0000900000408000), 0x1.20000081p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffbf7fff), -0x1.200000810002p+47, 0x0p+0 },
{ INT64_C(0x0000900000480000), 0x1.2000009p+47, 0x0p+0 },
{ INT64_C(0xffff6fffffb7ffff), -0x1.200000900002p+47, 0x0p+0 },
{ INT64_C(0x0000900001000000), 0x1.200002p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffeffffff), -0x1.200002000002p+47, 0x0p+0 },
{ INT64_C(0x0000900001000008), 0x1.20000200001p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffefffff7), -0x1.200002000012p+47, 0x0p+0 },
{ INT64_C(0x0000900001000040), 0x1.20000200008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffeffffbf), -0x1.200002000082p+47, 0x0p+0 },
{ INT64_C(0x0000900001000080), 0x1.2000020001p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffeffff7f), -0x1.200002000102p+47, 0x0p+0 },
{ INT64_C(0x0000900001000100), 0x1.2000020002p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffefffeff), -0x1.200002000202p+47, 0x0p+0 },
{ INT64_C(0x0000900001001000), 0x1.200002002p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffeffefff), -0x1.200002002002p+47, 0x0p+0 },
{ INT64_C(0x0000900001010000), 0x1.20000202p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffefeffff), -0x1.200002020002p+47, 0x0p+0 },
{ INT64_C(0x0000900001040000), 0x1.20000208p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffefbffff), -0x1.200002080002p+47, 0x0p+0 },
{ INT64_C(0x0000900001400000), 0x1.2000028p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffebfffff), -0x1.200002800002p+47, 0x0p+0 },
{ INT64_C(0x0000900004000000), 0x1.200008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffbffffff), -0x1.200008000002p+47, 0x0p+0 },
{ INT64_C(0x0000900004000002), 0x1.200008000004p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffbfffffd), -0x1.200008000006p+47, 0x0p+0 },
{ INT64_C(0x0000900004000020), 0x1.20000800004p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffbffffdf), -0x1.200008000042p+47, 0x0p+0 },
{ INT64_C(0x0000900004000040), 0x1.20000800008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffbffffbf), -0x1.200008000082p+47, 0x0p+0 },
{ INT64_C(0x0000900004000080), 0x1.2000080001p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffbffff7f), -0x1.200008000102p+47, 0x0p+0 },
{ INT64_C(0x0000900004000200), 0x1.2000080004p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffbfffdff), -0x1.200008000402p+47, 0x0p+0 },
{ INT64_C(0x0000900004002000), 0x1.200008004p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffbffdfff), -0x1.200008004002p+47, 0x0p+0 },
{ INT64_C(0x0000900004008000), 0x1.20000801p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffbff7fff), -0x1.200008010002p+47, 0x0p+0 },
{ INT64_C(0x0000900004080000), 0x1.2000081p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffbf7ffff), -0x1.200008100002p+47, 0x0p+0 },
{ INT64_C(0x0000900004800000), 0x1.200009p+47, 0x0p+0 },
{ INT64_C(0xffff6ffffb7fffff), -0x1.200009000002p+47, 0x0p+0 },
{ INT64_C(0x0000900020000000), 0x1.20004p+47, 0x0p+0 },
{ INT64_C(0xffff6fffdfffffff), -0x1.200040000002p+47, 0x0p+0 },
{ INT64_C(0x0000900020000002), 0x1.200040000004p+47, 0x0p+0 },
{ INT64_C(0xffff6fffdffffffd), -0x1.200040000006p+47, 0x0p+0 },
{ INT64_C(0x0000900020000008), 0x1.20004000001p+47, 0x0p+0 },
{ INT64_C(0xffff6fffdffffff7), -0x1.200040000012p+47, 0x0p+0 },
{ INT64_C(0x0000900020000020), 0x1.20004000004p+47, 0x0p+0 },
{ INT64_C(0xffff6fffdfffffdf), -0x1.200040000042p+47, 0x0p+0 },
{ INT64_C(0x0000900020000040), 0x1.20004000008p+47, 0x0p+0 },
{ INT64_C(0xffff6fffdfffffbf), -0x1.200040000082p+47, 0x0p+0 },
{ INT64_C(0x0000900020000400), 0x1.2000400008p+47, 0x0p+0 },
{ INT64_C(0xffff6fffdffffbff), -0x1.200040000802p+47, 0x0p+0 },
{ INT64_C(0x0000900020000800), 0x1.200040001p+47, 0x0p+0 },
{ INT64_C(0xffff6fffdffff7ff), -0x1.200040001002p+47, 0x0p+0 },
{ INT64_C(0x0000900020002000), 0x1.200040004p+47, 0x0p+0 },
{ INT64_C(0xffff6fffdfffdfff), -0x1.200040004002p+47, 0x0p+0 },
{ INT64_C(0x0000900020008000), 0x1.20004001p+47, 0x0p+0 },
{ INT64_C(0xffff6fffdfff7fff), -0x1.200040010002p+47, 0x0p+0 },
{ INT64_C(0x0000900020010000), 0x1.20004002p+47, 0x0p+0 },
{ INT64_C(0xffff6fffdffeffff), -0x1.200040020002p+47, 0x0p+0 },
{ INT64_C(0x0000900020080000), 0x1.2000401p+47, 0x0p+0 },
{ INT64_C(0xffff6fffdff7ffff), -0x1.200040100002p+47, 0x0p+0 },
{ INT64_C(0x0000900020200000), 0x1.2000404p+47, 0x0p+0 },
{ INT64_C(0xffff6fffdfdfffff), -0x1.200040400002p+47, 0x0p+0 },
{ INT64_C(0x0000900022000000), 0x1.200044p+47, 0x0p+0 },
{ INT64_C(0xffff6fffddffffff), -0x1.200044000002p+47, 0x0p+0 },
{ INT64_C(0x0000900030000000), 0x1.20006p+47, 0x0p+0 },
{ INT64_C(0xffff6fffcfffffff), -0x1.200060000002p+47, 0x0p+0 },
{ INT64_C(0x0000900200000000), 0x1.2004p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdffffffff), -0x1.200400000002p+47, 0x0p+0 },
{ INT64_C(0x0000900200000001), 0x1.200400000002p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdfffffffe), -0x1.200400000004p+47, 0x0p+0 },
{ INT64_C(0x0000900200000004), 0x1.200400000008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdfffffffb), -0x1.20040000000ap+47, 0x0p+0 },
{ INT64_C(0x0000900200000020), 0x1.20040000004p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdffffffdf), -0x1.200400000042p+47, 0x0p+0 },
{ INT64_C(0x0000900200000100), 0x1.2004000002p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdfffffeff), -0x1.200400000202p+47, 0x0p+0 },
{ INT64_C(0x0000900200000200), 0x1.2004000004p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdfffffdff), -0x1.200400000402p+47, 0x0p+0 },
{ INT64_C(0x0000900200000400), 0x1.2004000008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdfffffbff), -0x1.200400000802p+47, 0x0p+0 },
{ INT64_C(0x0000900200004000), 0x1.200400008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdffffbfff), -0x1.200400008002p+47, 0x0p+0 },
{ INT64_C(0x0000900200040000), 0x1.20040008p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdfffbffff), -0x1.200400080002p+47, 0x0p+0 },
{ INT64_C(0x0000900200100000), 0x1.2004002p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdffefffff), -0x1.200400200002p+47, 0x0p+0 },
{ INT64_C(0x0000900201000000), 0x1.200402p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdfeffffff), -0x1.200402000002p+47, 0x0p+0 },
{ INT64_C(0x0000900202000000), 0x1.200404p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdfdffffff), -0x1.200404000002p+47, 0x0p+0 },
{ INT64_C(0x0000900204000000), 0x1.200408p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdfbffffff), -0x1.200408000002p+47, 0x0p+0 },
{ INT64_C(0x0000900210000000), 0x1.20042p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdefffffff), -0x1.200420000002p+47, 0x0p+0 },
{ INT64_C(0x0000900240000000), 0x1.20048p+47, 0x0p+0 },
{ INT64_C(0xffff6ffdbfffffff), -0x1.200480000002p+47, 0x0p+0 },
{ INT64_C(0x0000902000000000), 0x1.204p+47, 0x0p+0 },
{ INT64_C(0xffff6fdfffffffff), -0x1.204000000002p+47, 0x0p+0 },
{ INT64_C(0x0000902000000004), 0x1.204000000008p+47, 0x0p+0 },
{ INT64_C(0xffff6fdffffffffb), -0x1.20400000000ap+47, 0x0p+0 },
{ INT64_C(0x0000902000000040), 0x1.20400000008p+47, 0x0p+0 },
{ INT64_C(0xffff6fdfffffffbf), -0x1.204000000082p+47, 0x0p+0 },
{ INT64_C(0x0000902000000200), 0x1.2040000004p+47, 0x0p+0 },
{ INT64_C(0xffff6fdffffffdff), -0x1.204000000402p+47, 0x0p+0 },
{ INT64_C(0x0000902000002000), 0x1.204000004p+47, 0x0p+0 },
{ INT64_C(0xffff6fdfffffdfff), -0x1.204000004002p+47, 0x0p+0 },
{ INT64_C(0x0000902000004000), 0x1.204000008p+47, 0x0p+0 },
{ INT64_C(0xffff6fdfffffbfff), -0x1.204000008002p+47, 0x0p+0 },
{ INT64_C(0x0000902000020000), 0x1.20400004p+47, 0x0p+0 },
{ INT64_C(0xffff6fdffffdffff), -0x1.204000040002p+47, 0x0p+0 },
{ INT64_C(0x0000902000100000), 0x1.2040002p+47, 0x0p+0 },
{ INT64_C(0xffff6fdfffefffff), -0x1.204000200002p+47, 0x0p+0 },
{ INT64_C(0x0000902000800000), 0x1.204001p+47, 0x0p+0 },
{ INT64_C(0xffff6fdfff7fffff), -0x1.204001000002p+47, 0x0p+0 },
{ INT64_C(0x0000902004000000), 0x1.204008p+47, 0x0p+0 },
{ INT64_C(0xffff6fdffbffffff), -0x1.204008000002p+47, 0x0p+0 },
{ INT64_C(0x0000902008000000), 0x1.20401p+47, 0x0p+0 },
{ INT64_C(0xffff6fdff7ffffff), -0x1.204010000002p+47, 0x0p+0 },
{ INT64_C(0x0000902080000000), 0x1.2041p+47, 0x0p+0 },
{ INT64_C(0xffff6fdf7fffffff), -0x1.204100000002p+47, 0x0p+0 },
{ INT64_C(0x0000902100000000), 0x1.2042p+47, 0x0p+0 },
{ INT64_C(0xffff6fdeffffffff), -0x1.204200000002p+47, 0x0p+0 },
{ INT64_C(0x0000902200000000), 0x1.2044p+47, 0x0p+0 },
{ INT64_C(0xffff6fddffffffff), -0x1.204400000002p+47, 0x0p+0 },
{ INT64_C(0x0000908000000000), 0x1.21p+47, 0x0p+0 },
{ INT64_C(0xffff6f7fffffffff), -0x1.210000000002p+47, 0x0p+0 },
{ INT64_C(0x0000908000000004), 0x1.210000000008p+47, 0x0p+0 },
{ INT64_C(0xffff6f7ffffffffb), -0x1.21000000000ap+47, 0x0p+0 },
{ INT64_C(0x0000908000000010), 0x1.21000000002p+47, 0x0p+0 },
{ INT64_C(0xffff6f7fffffffef), -0x1.210000000022p+47, 0x0p+0 },
{ INT64_C(0x0000908000000020), 0x1.21000000004p+47, 0x0p+0 },
{ INT64_C(0xffff6f7fffffffdf), -0x1.210000000042p+47, 0x0p+0 },
{ INT64_C(0x0000908000000100), 0x1.2100000002p+47, 0x0p+0 },
{ INT64_C(0xffff6f7ffffffeff), -0x1.210000000202p+47, 0x0p+0 },
{ INT64_C(0x0000908000000200), 0x1.2100000004p+47, 0x0p+0 },
{ INT64_C(0xffff6f7ffffffdff), -0x1.210000000402p+47, 0x0p+0 },
{ INT64_C(0x0000908000000800), 0x1.210000001p+47, 0x0p+0 },
{ INT64_C(0xffff6f7ffffff7ff), -0x1.210000001002p+47, 0x0p+0 },
{ INT64_C(0x0000908000002000), 0x1.210000004p+47, 0x0p+0 },
{ INT64_C(0xffff6f7fffffdfff), -0x1.210000004002p+47, 0x0p+0 },
{ INT64_C(0x0000908000010000), 0x1.21000002p+47, 0x0p+0 },
{ INT64_C(0xffff6f7ffffeffff), -0x1.210000020002p+47, 0x0p+0 },
{ INT64_C(0x0000908000040000), 0x1.21000008p+47, 0x0p+0 },
{ INT64_C(0xffff6f7ffffbffff), -0x1.210000080002p+47, 0x0p+0 },
{ INT64_C(0x0000908000080000), 0x1.2100001p+47, 0x0p+0 },
{ INT64_C(0xffff6f7ffff7ffff), -0x1.210000100002p+47, 0x0p+0 },
{ INT64_C(0x0000908000800000), 0x1.210001p+47, 0x0p+0 },
{ INT64_C(0xffff6f7fff7fffff), -0x1.210001000002p+47, 0x0p+0 },
{ INT64_C(0x0000908002000000), 0x1.210004p+47, 0x0p+0 },
{ INT64_C(0xffff6f7ffdffffff), -0x1.210004000002p+47, 0x0p+0 },
{ INT64_C(0x0000908020000000), 0x1.21004p+47, 0x0p+0 },
{ INT64_C(0xffff6f7fdfffffff), -0x1.210040000002p+47, 0x0p+0 },
{ INT64_C(0x0000908200000000), 0x1.2104p+47, 0x0p+0 },
{ INT64_C(0xffff6f7dffffffff), -0x1.210400000002p+47, 0x0p+0 },
{ INT64_C(0x000090a000000000), 0x1.214p+47, 0x0p+0 },
{ INT64_C(0xffff6f5fffffffff), -0x1.214000000002p+47, 0x0p+0 },
{ INT64_C(0x0000920000000000), 0x1.24p+47, 0x0p+0 },
{ INT64_C(0xffff6dffffffffff), -0x1.240000000002p+47, 0x0p+0 },
{ INT64_C(0x0000920000000001), 0x1.240000000002p+47, 0x0p+0 },
{ INT64_C(0xffff6dfffffffffe), -0x1.240000000004p+47, 0x0p+0 },
{ INT64_C(0x0000920000000002), 0x1.240000000004p+47, 0x0p+0 },
{ INT64_C(0xffff6dfffffffffd), -0x1.240000000006p+47, 0x0p+0 },
{ INT64_C(0x0000920000000010), 0x1.24000000002p+47, 0x0p+0 },
{ INT64_C(0xffff6dffffffffef), -0x1.240000000022p+47, 0x0p+0 },
{ INT64_C(0x0000920000000020), 0x1.24000000004p+47, 0x0p+0 },
{ INT64_C(0xffff6dffffffffdf), -0x1.240000000042p+47, 0x0p+0 },
{ INT64_C(0x0000920000000200), 0x1.2400000004p+47, 0x0p+0 },
{ INT64_C(0xffff6dfffffffdff), -0x1.240000000402p+47, 0x0p+0 },
{ INT64_C(0x0000920000000400), 0x1.2400000008p+47, 0x0p+0 },
{ INT64_C(0xffff6dfffffffbff), -0x1.240000000802p+47, 0x0p+0 },
{ INT64_C(0x0000920000001000), 0x1.240000002p+47, 0x0p+0 },
{ INT64_C(0xffff6dffffffefff), -0x1.240000002002p+47, 0x0p+0 },
{ INT64_C(0x0000920000002000), 0x1.240000004p+47, 0x0p+0 },
{ INT64_C(0xffff6dffffffdfff), -0x1.240000004002p+47, 0x0p+0 },
{ INT64_C(0x0000920000004000), 0x1.240000008p+47, 0x0p+0 },
{ INT64_C(0xffff6dffffffbfff), -0x1.240000008002p+47, 0x0p+0 },
{ INT64_C(0x0000920000020000), 0x1.24000004p+47, 0x0p+0 },
{ INT64_C(0xffff6dfffffdffff), -0x1.240000040002p+47, 0x0p+0 },
{ INT64_C(0x0000920000200000), 0x1.2400004p+47, 0x0p+0 },
{ INT64_C(0xffff6dffffdfffff), -0x1.240000400002p+47, 0x0p+0 },
{ INT64_C(0x0000920000400000), 0x1.2400008p+47, 0x0p+0 },
{ INT64_C(0xffff6dffffbfffff), -0x1.240000800002p+47, 0x0p+0 },
{ INT64_C(0x0000920000800000), 0x1.240001p+47, 0x0p+0 },
{ INT64_C(0xffff6dffff7fffff), -0x1.240001000002p+47, 0x0p+0 },
{ INT64_C(0x0000920004000000), 0x1.240008p+47, 0x0p+0 },
{ INT64_C(0xffff6dfffbffffff), -0x1.240008000002p+47, 0x0p+0 },
{ INT64_C(0x0000920040000000), 0x1.24008p+47, 0x0p+0 },
{ INT64_C(0xffff6dffbfffffff), -0x1.240080000002p+47, 0x0p+0 },
{ INT64_C(0x0000920400000000), 0x1.2408p+47, 0x0p+0 },
{ INT64_C(0xffff6dfbffffffff), -0x1.240800000002p+47, 0x0p+0 },
{ INT64_C(0x0000920800000000), 0x1.241p+47, 0x0p+0 },
{ INT64_C(0xffff6df7ffffffff), -0x1.241000000002p+47, 0x0p+0 },
{ INT64_C(0x0000928000000000), 0x1.25p+47, 0x0p+0 },
{ INT64_C(0xffff6d7fffffffff), -0x1.250000000002p+47, 0x0p+0 },
{ INT64_C(0x0001000000000005), 0x1.000000000005p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffffffa), -0x1.000000000006p+48, 0x0p+0 },
{ INT64_C(0x0001000000000018), 0x1.000000000018p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffffe7), -0x1.000000000019p+48, 0x0p+0 },
{ INT64_C(0x000100000000001a), 0x1.00000000001ap+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffffe5), -0x1.00000000001bp+48, 0x0p+0 },
{ INT64_C(0x0001000000000042), 0x1.000000000042p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffffbd), -0x1.000000000043p+48, 0x0p+0 },
{ INT64_C(0x0001000000000050), 0x1.00000000005p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffffaf), -0x1.000000000051p+48, 0x0p+0 },
{ INT64_C(0x0001000000000058), 0x1.000000000058p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffffa7), -0x1.000000000059p+48, 0x0p+0 },
{ INT64_C(0x0001000000000101), 0x1.000000000101p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffffefe), -0x1.000000000102p+48, 0x0p+0 },
{ INT64_C(0x0001000000000102), 0x1.000000000102p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffffefd), -0x1.000000000103p+48, 0x0p+0 },
{ INT64_C(0x0001000000000110), 0x1.00000000011p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffffeef), -0x1.000000000111p+48, 0x0p+0 },
{ INT64_C(0x0001000000000111), 0x1.000000000111p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffffeee), -0x1.000000000112p+48, 0x0p+0 },
{ INT64_C(0x0001000000000112), 0x1.000000000112p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffffeed), -0x1.000000000113p+48, 0x0p+0 },
{ INT64_C(0x0001000000001001), 0x1.000000001001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffeffe), -0x1.000000001002p+48, 0x0p+0 },
{ INT64_C(0x0001000000001004), 0x1.000000001004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffeffb), -0x1.000000001005p+48, 0x0p+0 },
{ INT64_C(0x0001000000001020), 0x1.00000000102p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffefdf), -0x1.000000001021p+48, 0x0p+0 },
{ INT64_C(0x0001000000001028), 0x1.000000001028p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffefd7), -0x1.000000001029p+48, 0x0p+0 },
{ INT64_C(0x0001000000001030), 0x1.00000000103p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffefcf), -0x1.000000001031p+48, 0x0p+0 },
{ INT64_C(0x0001000000001080), 0x1.00000000108p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffef7f), -0x1.000000001081p+48, 0x0p+0 },
{ INT64_C(0x0001000000001082), 0x1.000000001082p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffef7d), -0x1.000000001083p+48, 0x0p+0 },
{ INT64_C(0x0001000000001088), 0x1.000000001088p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffef77), -0x1.000000001089p+48, 0x0p+0 },
{ INT64_C(0x00010000000010a0), 0x1.0000000010ap+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffef5f), -0x1.0000000010a1p+48, 0x0p+0 },
{ INT64_C(0x0001000000001200), 0x1.0000000012p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffedff), -0x1.000000001201p+48, 0x0p+0 },
{ INT64_C(0x0001000000001204), 0x1.000000001204p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffedfb), -0x1.000000001205p+48, 0x0p+0 },
{ INT64_C(0x0001000000001208), 0x1.000000001208p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffedf7), -0x1.000000001209p+48, 0x0p+0 },
{ INT64_C(0x0001000000001240), 0x1.00000000124p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffedbf), -0x1.000000001241p+48, 0x0p+0 },
{ INT64_C(0x0001000000001400), 0x1.0000000014p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffebff), -0x1.000000001401p+48, 0x0p+0 },
{ INT64_C(0x0001000000001408), 0x1.000000001408p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffebf7), -0x1.000000001409p+48, 0x0p+0 },
{ INT64_C(0x0001000000001410), 0x1.00000000141p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffebef), -0x1.000000001411p+48, 0x0p+0 },
{ INT64_C(0x0001000000001420), 0x1.00000000142p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffebdf), -0x1.000000001421p+48, 0x0p+0 },
{ INT64_C(0x0001000000001500), 0x1.0000000015p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffeaff), -0x1.000000001501p+48, 0x0p+0 },
{ INT64_C(0x0001000000004001), 0x1.000000004001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffbffe), -0x1.000000004002p+48, 0x0p+0 },
{ INT64_C(0x0001000000004002), 0x1.000000004002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffbffd), -0x1.000000004003p+48, 0x0p+0 },
{ INT64_C(0x0001000000004010), 0x1.00000000401p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffbfef), -0x1.000000004011p+48, 0x0p+0 },
{ INT64_C(0x0001000000004012), 0x1.000000004012p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffbfed), -0x1.000000004013p+48, 0x0p+0 },
{ INT64_C(0x0001000000004018), 0x1.000000004018p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffbfe7), -0x1.000000004019p+48, 0x0p+0 },
{ INT64_C(0x0001000000004080), 0x1.00000000408p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffbf7f), -0x1.000000004081p+48, 0x0p+0 },
{ INT64_C(0x0001000000004084), 0x1.000000004084p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffbf7b), -0x1.000000004085p+48, 0x0p+0 },
{ INT64_C(0x0001000000004088), 0x1.000000004088p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffbf77), -0x1.000000004089p+48, 0x0p+0 },
{ INT64_C(0x0001000000004100), 0x1.0000000041p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffbeff), -0x1.000000004101p+48, 0x0p+0 },
{ INT64_C(0x0001000000004101), 0x1.000000004101p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffbefe), -0x1.000000004102p+48, 0x0p+0 },
{ INT64_C(0x0001000000004102), 0x1.000000004102p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffbefd), -0x1.000000004103p+48, 0x0p+0 },
{ INT64_C(0x0001000000004120), 0x1.00000000412p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffbedf), -0x1.000000004121p+48, 0x0p+0 },
{ INT64_C(0x0001000000004800), 0x1.0000000048p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffb7ff), -0x1.000000004801p+48, 0x0p+0 },
{ INT64_C(0x0001000000004808), 0x1.000000004808p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffb7f7), -0x1.000000004809p+48, 0x0p+0 },
{ INT64_C(0x0001000000004810), 0x1.00000000481p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffb7ef), -0x1.000000004811p+48, 0x0p+0 },
{ INT64_C(0x0001000000004840), 0x1.00000000484p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffb7bf), -0x1.000000004841p+48, 0x0p+0 },
{ INT64_C(0x0001000000004a00), 0x1.000000004ap+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffb5ff), -0x1.000000004a01p+48, 0x0p+0 },
{ INT64_C(0x0001000000005000), 0x1.000000005p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffafff), -0x1.000000005001p+48, 0x0p+0 },
{ INT64_C(0x0001000000005004), 0x1.000000005004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffaffb), -0x1.000000005005p+48, 0x0p+0 },
{ INT64_C(0x0001000000005020), 0x1.00000000502p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffafdf), -0x1.000000005021p+48, 0x0p+0 },
{ INT64_C(0x0001000000005100), 0x1.0000000051p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffffaeff), -0x1.000000005101p+48, 0x0p+0 },
{ INT64_C(0x0001000000040004), 0x1.000000040004p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbfffb), -0x1.000000040005p+48, 0x0p+0 },
{ INT64_C(0x0001000000040005), 0x1.000000040005p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbfffa), -0x1.000000040006p+48, 0x0p+0 },
{ INT64_C(0x0001000000040020), 0x1.00000004002p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbffdf), -0x1.000000040021p+48, 0x0p+0 },
{ INT64_C(0x0001000000040024), 0x1.000000040024p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbffdb), -0x1.000000040025p+48, 0x0p+0 },
{ INT64_C(0x0001000000040040), 0x1.00000004004p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbffbf), -0x1.000000040041p+48, 0x0p+0 },
{ INT64_C(0x0001000000040044), 0x1.000000040044p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbffbb), -0x1.000000040045p+48, 0x0p+0 },
{ INT64_C(0x0001000000040060), 0x1.00000004006p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbff9f), -0x1.000000040061p+48, 0x0p+0 },
{ INT64_C(0x0001000000040080), 0x1.00000004008p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbff7f), -0x1.000000040081p+48, 0x0p+0 },
{ INT64_C(0x0001000000040088), 0x1.000000040088p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbff77), -0x1.000000040089p+48, 0x0p+0 },
{ INT64_C(0x00010000000400c0), 0x1.0000000400cp+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbff3f), -0x1.0000000400c1p+48, 0x0p+0 },
{ INT64_C(0x0001000000040400), 0x1.0000000404p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbfbff), -0x1.000000040401p+48, 0x0p+0 },
{ INT64_C(0x0001000000040404), 0x1.000000040404p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbfbfb), -0x1.000000040405p+48, 0x0p+0 },
{ INT64_C(0x0001000000040410), 0x1.00000004041p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbfbef), -0x1.000000040411p+48, 0x0p+0 },
{ INT64_C(0x0001000000040420), 0x1.00000004042p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbfbdf), -0x1.000000040421p+48, 0x0p+0 },
{ INT64_C(0x0001000000040440), 0x1.00000004044p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbfbbf), -0x1.000000040441p+48, 0x0p+0 },
{ INT64_C(0x0001000000042000), 0x1.000000042p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbdfff), -0x1.000000042001p+48, 0x0p+0 },
{ INT64_C(0x0001000000042008), 0x1.000000042008p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbdff7), -0x1.000000042009p+48, 0x0p+0 },
{ INT64_C(0x0001000000042080), 0x1.00000004208p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbdf7f), -0x1.000000042081p+48, 0x0p+0 },
{ INT64_C(0x0001000000042100), 0x1.0000000421p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbdeff), -0x1.000000042101p+48, 0x0p+0 },
{ INT64_C(0x0001000000043000), 0x1.000000043p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbcfff), -0x1.000000043001p+48, 0x0p+0 },
{ INT64_C(0x0001000000044000), 0x1.000000044p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbbfff), -0x1.000000044001p+48, 0x0p+0 },
{ INT64_C(0x0001000000044001), 0x1.000000044001p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbbffe), -0x1.000000044002p+48, 0x0p+0 },
{ INT64_C(0x0001000000044010), 0x1.00000004401p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbbfef), -0x1.000000044011p+48, 0x0p+0 },
{ INT64_C(0x0001000000044080), 0x1.00000004408p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbbf7f), -0x1.000000044081p+48, 0x0p+0 },
{ INT64_C(0x0001000000044200), 0x1.0000000442p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbbdff), -0x1.000000044201p+48, 0x0p+0 },
{ INT64_C(0x0001000000044400), 0x1.0000000444p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbbbff), -0x1.000000044401p+48, 0x0p+0 },
{ INT64_C(0x0001000000044800), 0x1.0000000448p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffbb7ff), -0x1.000000044801p+48, 0x0p+0 },
{ INT64_C(0x0001000000046000), 0x1.000000046p+48, 0x0p+0 },
{ INT64_C(0xfffefffffffb9fff), -0x1.000000046001p+48, 0x0p+0 },
{ INT64_C(0x0001000000080004), 0x1.000000080004p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7fffb), -0x1.000000080005p+48, 0x0p+0 },
{ INT64_C(0x0001000000080006), 0x1.000000080006p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7fff9), -0x1.000000080007p+48, 0x0p+0 },
{ INT64_C(0x0001000000080008), 0x1.000000080008p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7fff7), -0x1.000000080009p+48, 0x0p+0 },
{ INT64_C(0x0001000000080040), 0x1.00000008004p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7ffbf), -0x1.000000080041p+48, 0x0p+0 },
{ INT64_C(0x0001000000080048), 0x1.000000080048p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7ffb7), -0x1.000000080049p+48, 0x0p+0 },
{ INT64_C(0x0001000000080050), 0x1.00000008005p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7ffaf), -0x1.000000080051p+48, 0x0p+0 },
{ INT64_C(0x0001000000080060), 0x1.00000008006p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7ff9f), -0x1.000000080061p+48, 0x0p+0 },
{ INT64_C(0x0001000000080200), 0x1.0000000802p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7fdff), -0x1.000000080201p+48, 0x0p+0 },
{ INT64_C(0x0001000000080202), 0x1.000000080202p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7fdfd), -0x1.000000080203p+48, 0x0p+0 },
{ INT64_C(0x0001000000080220), 0x1.00000008022p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7fddf), -0x1.000000080221p+48, 0x0p+0 },
{ INT64_C(0x0001000000081000), 0x1.000000081p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7efff), -0x1.000000081001p+48, 0x0p+0 },
{ INT64_C(0x0001000000081004), 0x1.000000081004p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7effb), -0x1.000000081005p+48, 0x0p+0 },
{ INT64_C(0x0001000000081020), 0x1.00000008102p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7efdf), -0x1.000000081021p+48, 0x0p+0 },
{ INT64_C(0x0001000000081100), 0x1.0000000811p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7eeff), -0x1.000000081101p+48, 0x0p+0 },
{ INT64_C(0x0001000000081800), 0x1.0000000818p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff7e7ff), -0x1.000000081801p+48, 0x0p+0 },
{ INT64_C(0x0001000000090000), 0x1.00000009p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff6ffff), -0x1.000000090001p+48, 0x0p+0 },
{ INT64_C(0x0001000000090001), 0x1.000000090001p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff6fffe), -0x1.000000090002p+48, 0x0p+0 },
{ INT64_C(0x0001000000090004), 0x1.000000090004p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff6fffb), -0x1.000000090005p+48, 0x0p+0 },
{ INT64_C(0x0001000000090040), 0x1.00000009004p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff6ffbf), -0x1.000000090041p+48, 0x0p+0 },
{ INT64_C(0x0001000000090080), 0x1.00000009008p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff6ff7f), -0x1.000000090081p+48, 0x0p+0 },
{ INT64_C(0x0001000000090200), 0x1.0000000902p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff6fdff), -0x1.000000090201p+48, 0x0p+0 },
{ INT64_C(0x0001000000092000), 0x1.000000092p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff6dfff), -0x1.000000092001p+48, 0x0p+0 },
{ INT64_C(0x00010000000a0000), 0x1.0000000ap+48, 0x0p+0 },
{ INT64_C(0xfffefffffff5ffff), -0x1.0000000a0001p+48, 0x0p+0 },
{ INT64_C(0x00010000000a0001), 0x1.0000000a0001p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff5fffe), -0x1.0000000a0002p+48, 0x0p+0 },
{ INT64_C(0x00010000000a0002), 0x1.0000000a0002p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff5fffd), -0x1.0000000a0003p+48, 0x0p+0 },
{ INT64_C(0x00010000000a0020), 0x1.0000000a002p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff5ffdf), -0x1.0000000a0021p+48, 0x0p+0 },
{ INT64_C(0x00010000000a0080), 0x1.0000000a008p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff5ff7f), -0x1.0000000a0081p+48, 0x0p+0 },
{ INT64_C(0x00010000000a0400), 0x1.0000000a04p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff5fbff), -0x1.0000000a0401p+48, 0x0p+0 },
{ INT64_C(0x00010000000a0800), 0x1.0000000a08p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff5f7ff), -0x1.0000000a0801p+48, 0x0p+0 },
{ INT64_C(0x00010000000a4000), 0x1.0000000a4p+48, 0x0p+0 },
{ INT64_C(0xfffefffffff5bfff), -0x1.0000000a4001p+48, 0x0p+0 },
{ INT64_C(0x00010000000b0000), 0x1.0000000bp+48, 0x0p+0 },
{ INT64_C(0xfffefffffff4ffff), -0x1.0000000b0001p+48, 0x0p+0 },
{ INT64_C(0x0001000000100002), 0x1.000000100002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeffffd), -0x1.000000100003p+48, 0x0p+0 },
{ INT64_C(0x0001000000100003), 0x1.000000100003p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeffffc), -0x1.000000100004p+48, 0x0p+0 },
{ INT64_C(0x0001000000100020), 0x1.00000010002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffefffdf), -0x1.000000100021p+48, 0x0p+0 },
{ INT64_C(0x0001000000100021), 0x1.000000100021p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffefffde), -0x1.000000100022p+48, 0x0p+0 },
{ INT64_C(0x0001000000100024), 0x1.000000100024p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffefffdb), -0x1.000000100025p+48, 0x0p+0 },
{ INT64_C(0x0001000000100028), 0x1.000000100028p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffefffd7), -0x1.000000100029p+48, 0x0p+0 },
{ INT64_C(0x0001000000100100), 0x1.0000001001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeffeff), -0x1.000000100101p+48, 0x0p+0 },
{ INT64_C(0x0001000000100108), 0x1.000000100108p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeffef7), -0x1.000000100109p+48, 0x0p+0 },
{ INT64_C(0x0001000000100180), 0x1.00000010018p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeffe7f), -0x1.000000100181p+48, 0x0p+0 },
{ INT64_C(0x0001000000100400), 0x1.0000001004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeffbff), -0x1.000000100401p+48, 0x0p+0 },
{ INT64_C(0x0001000000100408), 0x1.000000100408p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeffbf7), -0x1.000000100409p+48, 0x0p+0 },
{ INT64_C(0x0001000000100420), 0x1.00000010042p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeffbdf), -0x1.000000100421p+48, 0x0p+0 },
{ INT64_C(0x0001000000100440), 0x1.00000010044p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeffbbf), -0x1.000000100441p+48, 0x0p+0 },
{ INT64_C(0x0001000000100800), 0x1.0000001008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeff7ff), -0x1.000000100801p+48, 0x0p+0 },
{ INT64_C(0x0001000000100804), 0x1.000000100804p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeff7fb), -0x1.000000100805p+48, 0x0p+0 },
{ INT64_C(0x0001000000100810), 0x1.00000010081p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeff7ef), -0x1.000000100811p+48, 0x0p+0 },
{ INT64_C(0x0001000000100840), 0x1.00000010084p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeff7bf), -0x1.000000100841p+48, 0x0p+0 },
{ INT64_C(0x0001000000100a00), 0x1.000000100ap+48, 0x0p+0 },
{ INT64_C(0xfffeffffffeff5ff), -0x1.000000100a01p+48, 0x0p+0 },
{ INT64_C(0x0001000000108000), 0x1.000000108p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffef7fff), -0x1.000000108001p+48, 0x0p+0 },
{ INT64_C(0x0001000000108001), 0x1.000000108001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffef7ffe), -0x1.000000108002p+48, 0x0p+0 },
{ INT64_C(0x0001000000108002), 0x1.000000108002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffef7ffd), -0x1.000000108003p+48, 0x0p+0 },
{ INT64_C(0x0001000000108010), 0x1.00000010801p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffef7fef), -0x1.000000108011p+48, 0x0p+0 },
{ INT64_C(0x0001000000108100), 0x1.0000001081p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffef7eff), -0x1.000000108101p+48, 0x0p+0 },
{ INT64_C(0x0001000000109000), 0x1.000000109p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffef6fff), -0x1.000000109001p+48, 0x0p+0 },
{ INT64_C(0x0001000000120000), 0x1.00000012p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffedffff), -0x1.000000120001p+48, 0x0p+0 },
{ INT64_C(0x0001000000120004), 0x1.000000120004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffedfffb), -0x1.000000120005p+48, 0x0p+0 },
{ INT64_C(0x0001000000120008), 0x1.000000120008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffedfff7), -0x1.000000120009p+48, 0x0p+0 },
{ INT64_C(0x0001000000120040), 0x1.00000012004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffedffbf), -0x1.000000120041p+48, 0x0p+0 },
{ INT64_C(0x0001000000120200), 0x1.0000001202p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffedfdff), -0x1.000000120201p+48, 0x0p+0 },
{ INT64_C(0x0001000000120800), 0x1.0000001208p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffedf7ff), -0x1.000000120801p+48, 0x0p+0 },
{ INT64_C(0x0001000000128000), 0x1.000000128p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffed7fff), -0x1.000000128001p+48, 0x0p+0 },
{ INT64_C(0x0001000000200004), 0x1.000000200004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdffffb), -0x1.000000200005p+48, 0x0p+0 },
{ INT64_C(0x0001000000200008), 0x1.000000200008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdffff7), -0x1.000000200009p+48, 0x0p+0 },
{ INT64_C(0x0001000000200020), 0x1.00000020002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfffdf), -0x1.000000200021p+48, 0x0p+0 },
{ INT64_C(0x0001000000200028), 0x1.000000200028p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfffd7), -0x1.000000200029p+48, 0x0p+0 },
{ INT64_C(0x0001000000200030), 0x1.00000020003p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfffcf), -0x1.000000200031p+48, 0x0p+0 },
{ INT64_C(0x0001000000200100), 0x1.0000002001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdffeff), -0x1.000000200101p+48, 0x0p+0 },
{ INT64_C(0x0001000000200101), 0x1.000000200101p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdffefe), -0x1.000000200102p+48, 0x0p+0 },
{ INT64_C(0x0001000000200108), 0x1.000000200108p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdffef7), -0x1.000000200109p+48, 0x0p+0 },
{ INT64_C(0x0001000000200120), 0x1.00000020012p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdffedf), -0x1.000000200121p+48, 0x0p+0 },
{ INT64_C(0x0001000000200800), 0x1.0000002008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdff7ff), -0x1.000000200801p+48, 0x0p+0 },
{ INT64_C(0x0001000000200804), 0x1.000000200804p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdff7fb), -0x1.000000200805p+48, 0x0p+0 },
{ INT64_C(0x0001000000200810), 0x1.00000020081p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdff7ef), -0x1.000000200811p+48, 0x0p+0 },
{ INT64_C(0x0001000000200880), 0x1.00000020088p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdff77f), -0x1.000000200881p+48, 0x0p+0 },
{ INT64_C(0x0001000000201000), 0x1.000000201p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfefff), -0x1.000000201001p+48, 0x0p+0 },
{ INT64_C(0x0001000000201008), 0x1.000000201008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfeff7), -0x1.000000201009p+48, 0x0p+0 },
{ INT64_C(0x0001000000201080), 0x1.00000020108p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfef7f), -0x1.000000201081p+48, 0x0p+0 },
{ INT64_C(0x0001000000201200), 0x1.0000002012p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfedff), -0x1.000000201201p+48, 0x0p+0 },
{ INT64_C(0x0001000000204000), 0x1.000000204p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfbfff), -0x1.000000204001p+48, 0x0p+0 },
{ INT64_C(0x0001000000204002), 0x1.000000204002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfbffd), -0x1.000000204003p+48, 0x0p+0 },
{ INT64_C(0x0001000000204010), 0x1.00000020401p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfbfef), -0x1.000000204011p+48, 0x0p+0 },
{ INT64_C(0x0001000000204020), 0x1.00000020402p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfbfdf), -0x1.000000204021p+48, 0x0p+0 },
{ INT64_C(0x0001000000204040), 0x1.00000020404p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfbfbf), -0x1.000000204041p+48, 0x0p+0 },
{ INT64_C(0x0001000000204200), 0x1.0000002042p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfbdff), -0x1.000000204201p+48, 0x0p+0 },
{ INT64_C(0x0001000000205000), 0x1.000000205p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdfafff), -0x1.000000205001p+48, 0x0p+0 },
{ INT64_C(0x0001000000210000), 0x1.00000021p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdeffff), -0x1.000000210001p+48, 0x0p+0 },
{ INT64_C(0x0001000000210001), 0x1.000000210001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdefffe), -0x1.000000210002p+48, 0x0p+0 },
{ INT64_C(0x0001000000210010), 0x1.00000021001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdeffef), -0x1.000000210011p+48, 0x0p+0 },
{ INT64_C(0x0001000000210080), 0x1.00000021008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdeff7f), -0x1.000000210081p+48, 0x0p+0 },
{ INT64_C(0x0001000000210100), 0x1.0000002101p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdefeff), -0x1.000000210101p+48, 0x0p+0 },
{ INT64_C(0x0001000000211000), 0x1.000000211p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdeefff), -0x1.000000211001p+48, 0x0p+0 },
{ INT64_C(0x0001000000240000), 0x1.00000024p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdbffff), -0x1.000000240001p+48, 0x0p+0 },
{ INT64_C(0x0001000000240008), 0x1.000000240008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdbfff7), -0x1.000000240009p+48, 0x0p+0 },
{ INT64_C(0x0001000000240020), 0x1.00000024002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdbffdf), -0x1.000000240021p+48, 0x0p+0 },
{ INT64_C(0x0001000000240200), 0x1.0000002402p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdbfdff), -0x1.000000240201p+48, 0x0p+0 },
{ INT64_C(0x0001000000241000), 0x1.000000241p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdbefff), -0x1.000000241001p+48, 0x0p+0 },
{ INT64_C(0x0001000000244000), 0x1.000000244p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdbbfff), -0x1.000000244001p+48, 0x0p+0 },
{ INT64_C(0x0001000000250000), 0x1.00000025p+48, 0x0p+0 },
{ INT64_C(0xfffeffffffdaffff), -0x1.000000250001p+48, 0x0p+0 },
{ INT64_C(0x0001000001000002), 0x1.000001000002p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefffffd), -0x1.000001000003p+48, 0x0p+0 },
{ INT64_C(0x0001000001000020), 0x1.00000100002p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeffffdf), -0x1.000001000021p+48, 0x0p+0 },
{ INT64_C(0x0001000001000022), 0x1.000001000022p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeffffdd), -0x1.000001000023p+48, 0x0p+0 },
{ INT64_C(0x0001000001000030), 0x1.00000100003p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeffffcf), -0x1.000001000031p+48, 0x0p+0 },
{ INT64_C(0x0001000001000100), 0x1.0000010001p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefffeff), -0x1.000001000101p+48, 0x0p+0 },
{ INT64_C(0x0001000001000101), 0x1.000001000101p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefffefe), -0x1.000001000102p+48, 0x0p+0 },
{ INT64_C(0x0001000001000104), 0x1.000001000104p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefffefb), -0x1.000001000105p+48, 0x0p+0 },
{ INT64_C(0x0001000001000120), 0x1.00000100012p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefffedf), -0x1.000001000121p+48, 0x0p+0 },
{ INT64_C(0x0001000001000200), 0x1.0000010002p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefffdff), -0x1.000001000201p+48, 0x0p+0 },
{ INT64_C(0x0001000001000201), 0x1.000001000201p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefffdfe), -0x1.000001000202p+48, 0x0p+0 },
{ INT64_C(0x0001000001000208), 0x1.000001000208p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefffdf7), -0x1.000001000209p+48, 0x0p+0 },
{ INT64_C(0x0001000001000210), 0x1.00000100021p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefffdef), -0x1.000001000211p+48, 0x0p+0 },
{ INT64_C(0x0001000001000240), 0x1.00000100024p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefffdbf), -0x1.000001000241p+48, 0x0p+0 },
{ INT64_C(0x0001000001000300), 0x1.0000010003p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefffcff), -0x1.000001000301p+48, 0x0p+0 },
{ INT64_C(0x0001000001000800), 0x1.0000010008p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefff7ff), -0x1.000001000801p+48, 0x0p+0 },
{ INT64_C(0x0001000001000802), 0x1.000001000802p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefff7fd), -0x1.000001000803p+48, 0x0p+0 },
{ INT64_C(0x0001000001000820), 0x1.00000100082p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefff7df), -0x1.000001000821p+48, 0x0p+0 },
{ INT64_C(0x0001000001000840), 0x1.00000100084p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefff7bf), -0x1.000001000841p+48, 0x0p+0 },
{ INT64_C(0x0001000001000880), 0x1.00000100088p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefff77f), -0x1.000001000881p+48, 0x0p+0 },
{ INT64_C(0x0001000001000a00), 0x1.000001000ap+48, 0x0p+0 },
{ INT64_C(0xfffefffffefff5ff), -0x1.000001000a01p+48, 0x0p+0 },
{ INT64_C(0x0001000001008000), 0x1.000001008p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeff7fff), -0x1.000001008001p+48, 0x0p+0 },
{ INT64_C(0x0001000001008002), 0x1.000001008002p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeff7ffd), -0x1.000001008003p+48, 0x0p+0 },
{ INT64_C(0x0001000001008010), 0x1.00000100801p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeff7fef), -0x1.000001008011p+48, 0x0p+0 },
{ INT64_C(0x0001000001008040), 0x1.00000100804p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeff7fbf), -0x1.000001008041p+48, 0x0p+0 },
{ INT64_C(0x0001000001008080), 0x1.00000100808p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeff7f7f), -0x1.000001008081p+48, 0x0p+0 },
{ INT64_C(0x0001000001008100), 0x1.0000010081p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeff7eff), -0x1.000001008101p+48, 0x0p+0 },
{ INT64_C(0x0001000001008800), 0x1.0000010088p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeff77ff), -0x1.000001008801p+48, 0x0p+0 },
{ INT64_C(0x0001000001020000), 0x1.00000102p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefdffff), -0x1.000001020001p+48, 0x0p+0 },
{ INT64_C(0x0001000001020008), 0x1.000001020008p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefdfff7), -0x1.000001020009p+48, 0x0p+0 },
{ INT64_C(0x0001000001020040), 0x1.00000102004p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefdffbf), -0x1.000001020041p+48, 0x0p+0 },
{ INT64_C(0x0001000001020400), 0x1.0000010204p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefdfbff), -0x1.000001020401p+48, 0x0p+0 },
{ INT64_C(0x0001000001024000), 0x1.000001024p+48, 0x0p+0 },
{ INT64_C(0xfffefffffefdbfff), -0x1.000001024001p+48, 0x0p+0 },
{ INT64_C(0x0001000001100000), 0x1.0000011p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeefffff), -0x1.000001100001p+48, 0x0p+0 },
{ INT64_C(0x0001000001100001), 0x1.000001100001p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeeffffe), -0x1.000001100002p+48, 0x0p+0 },
{ INT64_C(0x0001000001100008), 0x1.000001100008p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeeffff7), -0x1.000001100009p+48, 0x0p+0 },
{ INT64_C(0x0001000001100080), 0x1.00000110008p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeefff7f), -0x1.000001100081p+48, 0x0p+0 },
{ INT64_C(0x0001000001100200), 0x1.0000011002p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeeffdff), -0x1.000001100201p+48, 0x0p+0 },
{ INT64_C(0x0001000001100800), 0x1.0000011008p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeeff7ff), -0x1.000001100801p+48, 0x0p+0 },
{ INT64_C(0x0001000001104000), 0x1.000001104p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeefbfff), -0x1.000001104001p+48, 0x0p+0 },
{ INT64_C(0x0001000001110000), 0x1.00000111p+48, 0x0p+0 },
{ INT64_C(0xfffefffffeeeffff), -0x1.000001110001p+48, 0x0p+0 },
{ INT64_C(0x0001000001180000), 0x1.00000118p+48, 0x0p+0 },
{ INT64_C(0xfffefffffee7ffff), -0x1.000001180001p+48, 0x0p+0 },
{ INT64_C(0x0001000010000004), 0x1.000010000004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffffffb), -0x1.000010000005p+48, 0x0p+0 },
{ INT64_C(0x0001000010000005), 0x1.000010000005p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffffffa), -0x1.000010000006p+48, 0x0p+0 },
{ INT64_C(0x0001000010000006), 0x1.000010000006p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffffff9), -0x1.000010000007p+48, 0x0p+0 },
{ INT64_C(0x0001000010000008), 0x1.000010000008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffffff7), -0x1.000010000009p+48, 0x0p+0 },
{ INT64_C(0x0001000010000080), 0x1.00001000008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffff7f), -0x1.000010000081p+48, 0x0p+0 },
{ INT64_C(0x0001000010000084), 0x1.000010000084p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffff7b), -0x1.000010000085p+48, 0x0p+0 },
{ INT64_C(0x0001000010000090), 0x1.00001000009p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffff6f), -0x1.000010000091p+48, 0x0p+0 },
{ INT64_C(0x0001000010000400), 0x1.0000100004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffffbff), -0x1.000010000401p+48, 0x0p+0 },
{ INT64_C(0x0001000010000401), 0x1.000010000401p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffffbfe), -0x1.000010000402p+48, 0x0p+0 },
{ INT64_C(0x0001000010000402), 0x1.000010000402p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffffbfd), -0x1.000010000403p+48, 0x0p+0 },
{ INT64_C(0x0001000010000408), 0x1.000010000408p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffffbf7), -0x1.000010000409p+48, 0x0p+0 },
{ INT64_C(0x0001000010000410), 0x1.00001000041p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffffbef), -0x1.000010000411p+48, 0x0p+0 },
{ INT64_C(0x0001000010000420), 0x1.00001000042p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffffbdf), -0x1.000010000421p+48, 0x0p+0 },
{ INT64_C(0x0001000010000480), 0x1.00001000048p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffffb7f), -0x1.000010000481p+48, 0x0p+0 },
{ INT64_C(0x0001000010000600), 0x1.0000100006p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffff9ff), -0x1.000010000601p+48, 0x0p+0 },
{ INT64_C(0x0001000010000800), 0x1.0000100008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffff7ff), -0x1.000010000801p+48, 0x0p+0 },
{ INT64_C(0x0001000010000804), 0x1.000010000804p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffff7fb), -0x1.000010000805p+48, 0x0p+0 },
{ INT64_C(0x0001000010000820), 0x1.00001000082p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffff7df), -0x1.000010000821p+48, 0x0p+0 },
{ INT64_C(0x0001000010000840), 0x1.00001000084p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffff7bf), -0x1.000010000841p+48, 0x0p+0 },
{ INT64_C(0x0001000010000c00), 0x1.000010000cp+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffff3ff), -0x1.000010000c01p+48, 0x0p+0 },
{ INT64_C(0x0001000010002000), 0x1.000010002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffdfff), -0x1.000010002001p+48, 0x0p+0 },
{ INT64_C(0x0001000010002002), 0x1.000010002002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffdffd), -0x1.000010002003p+48, 0x0p+0 },
{ INT64_C(0x0001000010002010), 0x1.00001000201p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffdfef), -0x1.000010002011p+48, 0x0p+0 },
{ INT64_C(0x0001000010002080), 0x1.00001000208p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffdf7f), -0x1.000010002081p+48, 0x0p+0 },
{ INT64_C(0x0001000010002400), 0x1.0000100024p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffdbff), -0x1.000010002401p+48, 0x0p+0 },
{ INT64_C(0x0001000010004000), 0x1.000010004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffbfff), -0x1.000010004001p+48, 0x0p+0 },
{ INT64_C(0x0001000010004008), 0x1.000010004008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffbff7), -0x1.000010004009p+48, 0x0p+0 },
{ INT64_C(0x0001000010004010), 0x1.00001000401p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffbfef), -0x1.000010004011p+48, 0x0p+0 },
{ INT64_C(0x0001000010004040), 0x1.00001000404p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffbfbf), -0x1.000010004041p+48, 0x0p+0 },
{ INT64_C(0x0001000010004200), 0x1.0000100042p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffbdff), -0x1.000010004201p+48, 0x0p+0 },
{ INT64_C(0x0001000010004400), 0x1.0000100044p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefffbbff), -0x1.000010004401p+48, 0x0p+0 },
{ INT64_C(0x0001000010040000), 0x1.00001004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffbffff), -0x1.000010040001p+48, 0x0p+0 },
{ INT64_C(0x0001000010040008), 0x1.000010040008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffbfff7), -0x1.000010040009p+48, 0x0p+0 },
{ INT64_C(0x0001000010040010), 0x1.00001004001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffbffef), -0x1.000010040011p+48, 0x0p+0 },
{ INT64_C(0x0001000010040040), 0x1.00001004004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffbffbf), -0x1.000010040041p+48, 0x0p+0 },
{ INT64_C(0x0001000010040200), 0x1.0000100402p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffbfdff), -0x1.000010040201p+48, 0x0p+0 },
{ INT64_C(0x0001000010040800), 0x1.0000100408p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffbf7ff), -0x1.000010040801p+48, 0x0p+0 },
{ INT64_C(0x0001000010041000), 0x1.000010041p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffbefff), -0x1.000010041001p+48, 0x0p+0 },
{ INT64_C(0x0001000010048000), 0x1.000010048p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeffb7fff), -0x1.000010048001p+48, 0x0p+0 },
{ INT64_C(0x0001000010080000), 0x1.00001008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeff7ffff), -0x1.000010080001p+48, 0x0p+0 },
{ INT64_C(0x0001000010080004), 0x1.000010080004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeff7fffb), -0x1.000010080005p+48, 0x0p+0 },
{ INT64_C(0x0001000010080008), 0x1.000010080008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeff7fff7), -0x1.000010080009p+48, 0x0p+0 },
{ INT64_C(0x0001000010080040), 0x1.00001008004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeff7ffbf), -0x1.000010080041p+48, 0x0p+0 },
{ INT64_C(0x0001000010080400), 0x1.0000100804p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeff7fbff), -0x1.000010080401p+48, 0x0p+0 },
{ INT64_C(0x0001000010084000), 0x1.000010084p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeff7bfff), -0x1.000010084001p+48, 0x0p+0 },
{ INT64_C(0x00010000100a0000), 0x1.0000100ap+48, 0x0p+0 },
{ INT64_C(0xfffeffffeff5ffff), -0x1.0000100a0001p+48, 0x0p+0 },
{ INT64_C(0x0001000010400000), 0x1.0000104p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefbfffff), -0x1.000010400001p+48, 0x0p+0 },
{ INT64_C(0x0001000010400004), 0x1.000010400004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefbffffb), -0x1.000010400005p+48, 0x0p+0 },
{ INT64_C(0x0001000010400040), 0x1.00001040004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefbfffbf), -0x1.000010400041p+48, 0x0p+0 },
{ INT64_C(0x0001000010400400), 0x1.0000104004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefbffbff), -0x1.000010400401p+48, 0x0p+0 },
{ INT64_C(0x0001000010401000), 0x1.000010401p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefbfefff), -0x1.000010401001p+48, 0x0p+0 },
{ INT64_C(0x0001000010404000), 0x1.000010404p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefbfbfff), -0x1.000010404001p+48, 0x0p+0 },
{ INT64_C(0x0001000010420000), 0x1.00001042p+48, 0x0p+0 },
{ INT64_C(0xfffeffffefbdffff), -0x1.000010420001p+48, 0x0p+0 },
{ INT64_C(0x0001000010600000), 0x1.0000106p+48, 0x0p+0 },
{ INT64_C(0xfffeffffef9fffff), -0x1.000010600001p+48, 0x0p+0 },
{ INT64_C(0x0001000011000000), 0x1.000011p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeeffffff), -0x1.000011000001p+48, 0x0p+0 },
{ INT64_C(0x0001000011000008), 0x1.000011000008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeefffff7), -0x1.000011000009p+48, 0x0p+0 },
{ INT64_C(0x0001000011000040), 0x1.00001100004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeeffffbf), -0x1.000011000041p+48, 0x0p+0 },
{ INT64_C(0x0001000011000100), 0x1.0000110001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeefffeff), -0x1.000011000101p+48, 0x0p+0 },
{ INT64_C(0x0001000011000400), 0x1.0000110004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeefffbff), -0x1.000011000401p+48, 0x0p+0 },
{ INT64_C(0x0001000011001000), 0x1.000011001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeeffefff), -0x1.000011001001p+48, 0x0p+0 },
{ INT64_C(0x0001000011004000), 0x1.000011004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeeffbfff), -0x1.000011004001p+48, 0x0p+0 },
{ INT64_C(0x0001000011020000), 0x1.00001102p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeefdffff), -0x1.000011020001p+48, 0x0p+0 },
{ INT64_C(0x0001000011040000), 0x1.00001104p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeefbffff), -0x1.000011040001p+48, 0x0p+0 },
{ INT64_C(0x0001000011080000), 0x1.00001108p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeef7ffff), -0x1.000011080001p+48, 0x0p+0 },
{ INT64_C(0x0001000011400000), 0x1.0000114p+48, 0x0p+0 },
{ INT64_C(0xfffeffffeebfffff), -0x1.000011400001p+48, 0x0p+0 },
{ INT64_C(0x0001000011800000), 0x1.0000118p+48, 0x0p+0 },
{ INT64_C(0xfffeffffee7fffff), -0x1.000011800001p+48, 0x0p+0 },
{ INT64_C(0x0001000018000000), 0x1.000018p+48, 0x0p+0 },
{ INT64_C(0xfffeffffe7ffffff), -0x1.000018000001p+48, 0x0p+0 },
{ INT64_C(0x0001000018000002), 0x1.000018000002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffe7fffffd), -0x1.000018000003p+48, 0x0p+0 },
{ INT64_C(0x0001000018000008), 0x1.000018000008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffe7fffff7), -0x1.000018000009p+48, 0x0p+0 },
{ INT64_C(0x0001000018000010), 0x1.00001800001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffe7ffffef), -0x1.000018000011p+48, 0x0p+0 },
{ INT64_C(0x0001000018000100), 0x1.0000180001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffe7fffeff), -0x1.000018000101p+48, 0x0p+0 },
{ INT64_C(0x0001000018000200), 0x1.0000180002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffe7fffdff), -0x1.000018000201p+48, 0x0p+0 },
{ INT64_C(0x0001000018002000), 0x1.000018002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffe7ffdfff), -0x1.000018002001p+48, 0x0p+0 },
{ INT64_C(0x0001000018004000), 0x1.000018004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffe7ffbfff), -0x1.000018004001p+48, 0x0p+0 },
{ INT64_C(0x0001000018010000), 0x1.00001801p+48, 0x0p+0 },
{ INT64_C(0xfffeffffe7feffff), -0x1.000018010001p+48, 0x0p+0 },
{ INT64_C(0x0001000018100000), 0x1.0000181p+48, 0x0p+0 },
{ INT64_C(0xfffeffffe7efffff), -0x1.000018100001p+48, 0x0p+0 },
{ INT64_C(0x0001000018200000), 0x1.0000182p+48, 0x0p+0 },
{ INT64_C(0xfffeffffe7dfffff), -0x1.000018200001p+48, 0x0p+0 },
{ INT64_C(0x000100001a000000), 0x1.00001ap+48, 0x0p+0 },
{ INT64_C(0xfffeffffe5ffffff), -0x1.00001a000001p+48, 0x0p+0 },
{ INT64_C(0x000100001c000000), 0x1.00001cp+48, 0x0p+0 },
{ INT64_C(0xfffeffffe3ffffff), -0x1.00001c000001p+48, 0x0p+0 },
{ INT64_C(0x0001000040000004), 0x1.000040000004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbffffffb), -0x1.000040000005p+48, 0x0p+0 },
{ INT64_C(0x0001000040000040), 0x1.00004000004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfffffbf), -0x1.000040000041p+48, 0x0p+0 },
{ INT64_C(0x0001000040000042), 0x1.000040000042p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfffffbd), -0x1.000040000043p+48, 0x0p+0 },
{ INT64_C(0x0001000040000044), 0x1.000040000044p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfffffbb), -0x1.000040000045p+48, 0x0p+0 },
{ INT64_C(0x0001000040000048), 0x1.000040000048p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfffffb7), -0x1.000040000049p+48, 0x0p+0 },
{ INT64_C(0x0001000040000050), 0x1.00004000005p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfffffaf), -0x1.000040000051p+48, 0x0p+0 },
{ INT64_C(0x0001000040000200), 0x1.0000400002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbffffdff), -0x1.000040000201p+48, 0x0p+0 },
{ INT64_C(0x0001000040000202), 0x1.000040000202p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbffffdfd), -0x1.000040000203p+48, 0x0p+0 },
{ INT64_C(0x0001000040000208), 0x1.000040000208p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbffffdf7), -0x1.000040000209p+48, 0x0p+0 },
{ INT64_C(0x0001000040000210), 0x1.00004000021p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbffffdef), -0x1.000040000211p+48, 0x0p+0 },
{ INT64_C(0x0001000040000280), 0x1.00004000028p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbffffd7f), -0x1.000040000281p+48, 0x0p+0 },
{ INT64_C(0x0001000040002000), 0x1.000040002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfffdfff), -0x1.000040002001p+48, 0x0p+0 },
{ INT64_C(0x0001000040002008), 0x1.000040002008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfffdff7), -0x1.000040002009p+48, 0x0p+0 },
{ INT64_C(0x0001000040002020), 0x1.00004000202p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfffdfdf), -0x1.000040002021p+48, 0x0p+0 },
{ INT64_C(0x0001000040002200), 0x1.0000400022p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfffddff), -0x1.000040002201p+48, 0x0p+0 },
{ INT64_C(0x0001000040020000), 0x1.00004002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbffdffff), -0x1.000040020001p+48, 0x0p+0 },
{ INT64_C(0x0001000040020008), 0x1.000040020008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbffdfff7), -0x1.000040020009p+48, 0x0p+0 },
{ INT64_C(0x0001000040020020), 0x1.00004002002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbffdffdf), -0x1.000040020021p+48, 0x0p+0 },
{ INT64_C(0x0001000040020200), 0x1.0000400202p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbffdfdff), -0x1.000040020201p+48, 0x0p+0 },
{ INT64_C(0x0001000040022000), 0x1.000040022p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbffddfff), -0x1.000040022001p+48, 0x0p+0 },
{ INT64_C(0x0001000040028000), 0x1.000040028p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbffd7fff), -0x1.000040028001p+48, 0x0p+0 },
{ INT64_C(0x0001000040100000), 0x1.0000401p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfefffff), -0x1.000040100001p+48, 0x0p+0 },
{ INT64_C(0x0001000040100004), 0x1.000040100004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfeffffb), -0x1.000040100005p+48, 0x0p+0 },
{ INT64_C(0x0001000040100010), 0x1.00004010001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfefffef), -0x1.000040100011p+48, 0x0p+0 },
{ INT64_C(0x0001000040100100), 0x1.0000401001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfeffeff), -0x1.000040100101p+48, 0x0p+0 },
{ INT64_C(0x0001000040101000), 0x1.000040101p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfefefff), -0x1.000040101001p+48, 0x0p+0 },
{ INT64_C(0x0001000040104000), 0x1.000040104p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfefbfff), -0x1.000040104001p+48, 0x0p+0 },
{ INT64_C(0x0001000040120000), 0x1.00004012p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfedffff), -0x1.000040120001p+48, 0x0p+0 },
{ INT64_C(0x0001000040200000), 0x1.0000402p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfdfffff), -0x1.000040200001p+48, 0x0p+0 },
{ INT64_C(0x0001000040200001), 0x1.000040200001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfdffffe), -0x1.000040200002p+48, 0x0p+0 },
{ INT64_C(0x0001000040200004), 0x1.000040200004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfdffffb), -0x1.000040200005p+48, 0x0p+0 },
{ INT64_C(0x0001000040200010), 0x1.00004020001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfdfffef), -0x1.000040200011p+48, 0x0p+0 },
{ INT64_C(0x0001000040200100), 0x1.0000402001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfdffeff), -0x1.000040200101p+48, 0x0p+0 },
{ INT64_C(0x0001000040200400), 0x1.0000402004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfdffbff), -0x1.000040200401p+48, 0x0p+0 },
{ INT64_C(0x0001000040204000), 0x1.000040204p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfdfbfff), -0x1.000040204001p+48, 0x0p+0 },
{ INT64_C(0x0001000040208000), 0x1.000040208p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfdf7fff), -0x1.000040208001p+48, 0x0p+0 },
{ INT64_C(0x0001000040210000), 0x1.00004021p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfdeffff), -0x1.000040210001p+48, 0x0p+0 },
{ INT64_C(0x0001000040220000), 0x1.00004022p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfddffff), -0x1.000040220001p+48, 0x0p+0 },
{ INT64_C(0x0001000040280000), 0x1.00004028p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbfd7ffff), -0x1.000040280001p+48, 0x0p+0 },
{ INT64_C(0x0001000041000000), 0x1.000041p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbeffffff), -0x1.000041000001p+48, 0x0p+0 },
{ INT64_C(0x0001000041000002), 0x1.000041000002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbefffffd), -0x1.000041000003p+48, 0x0p+0 },
{ INT64_C(0x0001000041000010), 0x1.00004100001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbeffffef), -0x1.000041000011p+48, 0x0p+0 },
{ INT64_C(0x0001000041000100), 0x1.0000410001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbefffeff), -0x1.000041000101p+48, 0x0p+0 },
{ INT64_C(0x0001000041000400), 0x1.0000410004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbefffbff), -0x1.000041000401p+48, 0x0p+0 },
{ INT64_C(0x0001000041002000), 0x1.000041002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbeffdfff), -0x1.000041002001p+48, 0x0p+0 },
{ INT64_C(0x0001000041020000), 0x1.00004102p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbefdffff), -0x1.000041020001p+48, 0x0p+0 },
{ INT64_C(0x0001000041100000), 0x1.0000411p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbeefffff), -0x1.000041100001p+48, 0x0p+0 },
{ INT64_C(0x0001000041200000), 0x1.0000412p+48, 0x0p+0 },
{ INT64_C(0xfffeffffbedfffff), -0x1.000041200001p+48, 0x0p+0 },
{ INT64_C(0x0001000048000000), 0x1.000048p+48, 0x0p+0 },
{ INT64_C(0xfffeffffb7ffffff), -0x1.000048000001p+48, 0x0p+0 },
{ INT64_C(0x0001000048000001), 0x1.000048000001p+48, 0x0p+0 },
{ INT64_C(0xfffeffffb7fffffe), -0x1.000048000002p+48, 0x0p+0 },
{ INT64_C(0x0001000048000004), 0x1.000048000004p+48, 0x0p+0 },
{ INT64_C(0xfffeffffb7fffffb), -0x1.000048000005p+48, 0x0p+0 },
{ INT64_C(0x0001000048000008), 0x1.000048000008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffb7fffff7), -0x1.000048000009p+48, 0x0p+0 },
{ INT64_C(0x0001000048000020), 0x1.00004800002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffb7ffffdf), -0x1.000048000021p+48, 0x0p+0 },
{ INT64_C(0x0001000048000200), 0x1.0000480002p+48, 0x0p+0 },
{ INT64_C(0xfffeffffb7fffdff), -0x1.000048000201p+48, 0x0p+0 },
{ INT64_C(0x0001000048000800), 0x1.0000480008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffb7fff7ff), -0x1.000048000801p+48, 0x0p+0 },
{ INT64_C(0x0001000048008000), 0x1.000048008p+48, 0x0p+0 },
{ INT64_C(0xfffeffffb7ff7fff), -0x1.000048008001p+48, 0x0p+0 },
{ INT64_C(0x0001000048020000), 0x1.00004802p+48, 0x0p+0 },
{ INT64_C(0xfffeffffb7fdffff), -0x1.000048020001p+48, 0x0p+0 },
{ INT64_C(0x0001000048040000), 0x1.00004804p+48, 0x0p+0 },
{ INT64_C(0xfffeffffb7fbffff), -0x1.000048040001p+48, 0x0p+0 },
{ INT64_C(0x0001000048100000), 0x1.0000481p+48, 0x0p+0 },
{ INT64_C(0xfffeffffb7efffff), -0x1.000048100001p+48, 0x0p+0 },
{ INT64_C(0x0001000049000000), 0x1.000049p+48, 0x0p+0 },
{ INT64_C(0xfffeffffb6ffffff), -0x1.000049000001p+48, 0x0p+0 },
{ INT64_C(0x0001000100000001), 0x1.000100000001p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffffffe), -0x1.000100000002p+48, 0x0p+0 },
{ INT64_C(0x0001000100000008), 0x1.000100000008p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffffff7), -0x1.000100000009p+48, 0x0p+0 },
{ INT64_C(0x000100010000000a), 0x1.00010000000ap+48, 0x0p+0 },
{ INT64_C(0xfffefffefffffff5), -0x1.00010000000bp+48, 0x0p+0 },
{ INT64_C(0x0001000100000020), 0x1.00010000002p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffffdf), -0x1.000100000021p+48, 0x0p+0 },
{ INT64_C(0x0001000100000022), 0x1.000100000022p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffffdd), -0x1.000100000023p+48, 0x0p+0 },
{ INT64_C(0x0001000100000030), 0x1.00010000003p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffffcf), -0x1.000100000031p+48, 0x0p+0 },
{ INT64_C(0x0001000100000080), 0x1.00010000008p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffff7f), -0x1.000100000081p+48, 0x0p+0 },
{ INT64_C(0x0001000100000088), 0x1.000100000088p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffff77), -0x1.000100000089p+48, 0x0p+0 },
{ INT64_C(0x00010001000000a0), 0x1.0001000000ap+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffff5f), -0x1.0001000000a1p+48, 0x0p+0 },
{ INT64_C(0x00010001000000c0), 0x1.0001000000cp+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffff3f), -0x1.0001000000c1p+48, 0x0p+0 },
{ INT64_C(0x0001000100000400), 0x1.0001000004p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffffbff), -0x1.000100000401p+48, 0x0p+0 },
{ INT64_C(0x0001000100000408), 0x1.000100000408p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffffbf7), -0x1.000100000409p+48, 0x0p+0 },
{ INT64_C(0x0001000100000440), 0x1.00010000044p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffffbbf), -0x1.000100000441p+48, 0x0p+0 },
{ INT64_C(0x0001000100001000), 0x1.000100001p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffefff), -0x1.000100001001p+48, 0x0p+0 },
{ INT64_C(0x0001000100001008), 0x1.000100001008p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffeff7), -0x1.000100001009p+48, 0x0p+0 },
{ INT64_C(0x0001000100001040), 0x1.00010000104p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffefbf), -0x1.000100001041p+48, 0x0p+0 },
{ INT64_C(0x0001000100001100), 0x1.0001000011p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffeeff), -0x1.000100001101p+48, 0x0p+0 },
{ INT64_C(0x0001000100001200), 0x1.0001000012p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffedff), -0x1.000100001201p+48, 0x0p+0 },
{ INT64_C(0x0001000100001800), 0x1.0001000018p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffe7ff), -0x1.000100001801p+48, 0x0p+0 },
{ INT64_C(0x0001000100004000), 0x1.000100004p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffbfff), -0x1.000100004001p+48, 0x0p+0 },
{ INT64_C(0x0001000100004004), 0x1.000100004004p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffbffb), -0x1.000100004005p+48, 0x0p+0 },
{ INT64_C(0x0001000100004020), 0x1.00010000402p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffbfdf), -0x1.000100004021p+48, 0x0p+0 },
{ INT64_C(0x0001000100004100), 0x1.0001000041p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffbeff), -0x1.000100004101p+48, 0x0p+0 },
{ INT64_C(0x0001000100004200), 0x1.0001000042p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffffbdff), -0x1.000100004201p+48, 0x0p+0 },
{ INT64_C(0x0001000100006000), 0x1.000100006p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffff9fff), -0x1.000100006001p+48, 0x0p+0 },
{ INT64_C(0x0001000100020000), 0x1.00010002p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffdffff), -0x1.000100020001p+48, 0x0p+0 },
{ INT64_C(0x0001000100020008), 0x1.000100020008p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffdfff7), -0x1.000100020009p+48, 0x0p+0 },
{ INT64_C(0x0001000100020010), 0x1.00010002001p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffdffef), -0x1.000100020011p+48, 0x0p+0 },
{ INT64_C(0x0001000100020020), 0x1.00010002002p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffdffdf), -0x1.000100020021p+48, 0x0p+0 },
{ INT64_C(0x0001000100020040), 0x1.00010002004p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffdffbf), -0x1.000100020041p+48, 0x0p+0 },
{ INT64_C(0x0001000100020400), 0x1.0001000204p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffdfbff), -0x1.000100020401p+48, 0x0p+0 },
{ INT64_C(0x0001000100021000), 0x1.000100021p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffdefff), -0x1.000100021001p+48, 0x0p+0 },
{ INT64_C(0x0001000100022000), 0x1.000100022p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffddfff), -0x1.000100022001p+48, 0x0p+0 },
{ INT64_C(0x0001000100028000), 0x1.000100028p+48, 0x0p+0 },
{ INT64_C(0xfffefffefffd7fff), -0x1.000100028001p+48, 0x0p+0 },
{ INT64_C(0x0001000100080000), 0x1.00010008p+48, 0x0p+0 },
{ INT64_C(0xfffefffefff7ffff), -0x1.000100080001p+48, 0x0p+0 },
{ INT64_C(0x0001000100080004), 0x1.000100080004p+48, 0x0p+0 },
{ INT64_C(0xfffefffefff7fffb), -0x1.000100080005p+48, 0x0p+0 },
{ INT64_C(0x0001000100080008), 0x1.000100080008p+48, 0x0p+0 },
{ INT64_C(0xfffefffefff7fff7), -0x1.000100080009p+48, 0x0p+0 },
{ INT64_C(0x0001000100080080), 0x1.00010008008p+48, 0x0p+0 },
{ INT64_C(0xfffefffefff7ff7f), -0x1.000100080081p+48, 0x0p+0 },
{ INT64_C(0x0001000100080400), 0x1.0001000804p+48, 0x0p+0 },
{ INT64_C(0xfffefffefff7fbff), -0x1.000100080401p+48, 0x0p+0 },
{ INT64_C(0x0001000100082000), 0x1.000100082p+48, 0x0p+0 },
{ INT64_C(0xfffefffefff7dfff), -0x1.000100082001p+48, 0x0p+0 },
{ INT64_C(0x0001000100088000), 0x1.000100088p+48, 0x0p+0 },
{ INT64_C(0xfffefffefff77fff), -0x1.000100088001p+48, 0x0p+0 },
{ INT64_C(0x00010001000c0000), 0x1.0001000cp+48, 0x0p+0 },
{ INT64_C(0xfffefffefff3ffff), -0x1.0001000c0001p+48, 0x0p+0 },
{ INT64_C(0x0001000100100000), 0x1.0001001p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffefffff), -0x1.000100100001p+48, 0x0p+0 },
{ INT64_C(0x0001000100100001), 0x1.000100100001p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffeffffe), -0x1.000100100002p+48, 0x0p+0 },
{ INT64_C(0x0001000100100010), 0x1.00010010001p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffefffef), -0x1.000100100011p+48, 0x0p+0 },
{ INT64_C(0x0001000100100100), 0x1.0001001001p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffeffeff), -0x1.000100100101p+48, 0x0p+0 },
{ INT64_C(0x0001000100100800), 0x1.0001001008p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffeff7ff), -0x1.000100100801p+48, 0x0p+0 },
{ INT64_C(0x0001000100101000), 0x1.000100101p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffefefff), -0x1.000100101001p+48, 0x0p+0 },
{ INT64_C(0x0001000100110000), 0x1.00010011p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffeeffff), -0x1.000100110001p+48, 0x0p+0 },
{ INT64_C(0x0001000100120000), 0x1.00010012p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffedffff), -0x1.000100120001p+48, 0x0p+0 },
{ INT64_C(0x0001000100400000), 0x1.0001004p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffbfffff), -0x1.000100400001p+48, 0x0p+0 },
{ INT64_C(0x0001000100400001), 0x1.000100400001p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffbffffe), -0x1.000100400002p+48, 0x0p+0 },
{ INT64_C(0x0001000100400004), 0x1.000100400004p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffbffffb), -0x1.000100400005p+48, 0x0p+0 },
{ INT64_C(0x0001000100400040), 0x1.00010040004p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffbfffbf), -0x1.000100400041p+48, 0x0p+0 },
{ INT64_C(0x0001000100400400), 0x1.0001004004p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffbffbff), -0x1.000100400401p+48, 0x0p+0 },
{ INT64_C(0x0001000100400800), 0x1.0001004008p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffbff7ff), -0x1.000100400801p+48, 0x0p+0 },
{ INT64_C(0x0001000100402000), 0x1.000100402p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffbfdfff), -0x1.000100402001p+48, 0x0p+0 },
{ INT64_C(0x0001000100410000), 0x1.00010041p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffbeffff), -0x1.000100410001p+48, 0x0p+0 },
{ INT64_C(0x0001000100420000), 0x1.00010042p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffbdffff), -0x1.000100420001p+48, 0x0p+0 },
{ INT64_C(0x0001000100480000), 0x1.00010048p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffb7ffff), -0x1.000100480001p+48, 0x0p+0 },
{ INT64_C(0x0001000100500000), 0x1.0001005p+48, 0x0p+0 },
{ INT64_C(0xfffefffeffafffff), -0x1.000100500001p+48, 0x0p+0 },
{ INT64_C(0x0001000100800000), 0x1.0001008p+48, 0x0p+0 },
{ INT64_C(0xfffefffeff7fffff), -0x1.000100800001p+48, 0x0p+0 },
{ INT64_C(0x0001000100800004), 0x1.000100800004p+48, 0x0p+0 },
{ INT64_C(0xfffefffeff7ffffb), -0x1.000100800005p+48, 0x0p+0 },
{ INT64_C(0x0001000100800020), 0x1.00010080002p+48, 0x0p+0 },
{ INT64_C(0xfffefffeff7fffdf), -0x1.000100800021p+48, 0x0p+0 },
{ INT64_C(0x0001000100800040), 0x1.00010080004p+48, 0x0p+0 },
{ INT64_C(0xfffefffeff7fffbf), -0x1.000100800041p+48, 0x0p+0 },
{ INT64_C(0x0001000100800080), 0x1.00010080008p+48, 0x0p+0 },
{ INT64_C(0xfffefffeff7fff7f), -0x1.000100800081p+48, 0x0p+0 },
{ INT64_C(0x0001000100800200), 0x1.0001008002p+48, 0x0p+0 },
{ INT64_C(0xfffefffeff7ffdff), -0x1.000100800201p+48, 0x0p+0 },
{ INT64_C(0x0001000100802000), 0x1.000100802p+48, 0x0p+0 },
{ INT64_C(0xfffefffeff7fdfff), -0x1.000100802001p+48, 0x0p+0 },
{ INT64_C(0x0001000100808000), 0x1.000100808p+48, 0x0p+0 },
{ INT64_C(0xfffefffeff7f7fff), -0x1.000100808001p+48, 0x0p+0 },
{ INT64_C(0x0001000100810000), 0x1.00010081p+48, 0x0p+0 },
{ INT64_C(0xfffefffeff7effff), -0x1.000100810001p+48, 0x0p+0 },
{ INT64_C(0x0001000100880000), 0x1.00010088p+48, 0x0p+0 },
{ INT64_C(0xfffefffeff77ffff), -0x1.000100880001p+48, 0x0p+0 },
{ INT64_C(0x0001000100a00000), 0x1.000100ap+48, 0x0p+0 },
{ INT64_C(0xfffefffeff5fffff), -0x1.000100a00001p+48, 0x0p+0 },
{ INT64_C(0x0001000101000000), 0x1.000101p+48, 0x0p+0 },
{ INT64_C(0xfffefffefeffffff), -0x1.000101000001p+48, 0x0p+0 },
{ INT64_C(0x0001000101000002), 0x1.000101000002p+48, 0x0p+0 },
{ INT64_C(0xfffefffefefffffd), -0x1.000101000003p+48, 0x0p+0 },
{ INT64_C(0x0001000101000020), 0x1.00010100002p+48, 0x0p+0 },
{ INT64_C(0xfffefffefeffffdf), -0x1.000101000021p+48, 0x0p+0 },
{ INT64_C(0x0001000101000100), 0x1.0001010001p+48, 0x0p+0 },
{ INT64_C(0xfffefffefefffeff), -0x1.000101000101p+48, 0x0p+0 },
{ INT64_C(0x0001000101001000), 0x1.000101001p+48, 0x0p+0 },
{ INT64_C(0xfffefffefeffefff), -0x1.000101001001p+48, 0x0p+0 },
{ INT64_C(0x0001000101004000), 0x1.000101004p+48, 0x0p+0 },
{ INT64_C(0xfffefffefeffbfff), -0x1.000101004001p+48, 0x0p+0 },
{ INT64_C(0x0001000101020000), 0x1.00010102p+48, 0x0p+0 },
{ INT64_C(0xfffefffefefdffff), -0x1.000101020001p+48, 0x0p+0 },
{ INT64_C(0x0001000101080000), 0x1.00010108p+48, 0x0p+0 },
{ INT64_C(0xfffefffefef7ffff), -0x1.000101080001p+48, 0x0p+0 },
{ INT64_C(0x0001000101800000), 0x1.0001018p+48, 0x0p+0 },
{ INT64_C(0xfffefffefe7fffff), -0x1.000101800001p+48, 0x0p+0 },
{ INT64_C(0x0001000110000000), 0x1.00011p+48, 0x0p+0 },
{ INT64_C(0xfffefffeefffffff), -0x1.000110000001p+48, 0x0p+0 },
{ INT64_C(0x0001000110000002), 0x1.000110000002p+48, 0x0p+0 },
{ INT64_C(0xfffefffeeffffffd), -0x1.000110000003p+48, 0x0p+0 },
{ INT64_C(0x0001000110000020), 0x1.00011000002p+48, 0x0p+0 },
{ INT64_C(0xfffefffeefffffdf), -0x1.000110000021p+48, 0x0p+0 },
{ INT64_C(0x0001000110000080), 0x1.00011000008p+48, 0x0p+0 },
{ INT64_C(0xfffefffeefffff7f), -0x1.000110000081p+48, 0x0p+0 },
{ INT64_C(0x0001000110000800), 0x1.0001100008p+48, 0x0p+0 },
{ INT64_C(0xfffefffeeffff7ff), -0x1.000110000801p+48, 0x0p+0 },
{ INT64_C(0x0001000110001000), 0x1.000110001p+48, 0x0p+0 },
{ INT64_C(0xfffefffeefffefff), -0x1.000110001001p+48, 0x0p+0 },
{ INT64_C(0x0001000110008000), 0x1.000110008p+48, 0x0p+0 },
{ INT64_C(0xfffefffeefff7fff), -0x1.000110008001p+48, 0x0p+0 },
{ INT64_C(0x0001000110020000), 0x1.00011002p+48, 0x0p+0 },
{ INT64_C(0xfffefffeeffdffff), -0x1.000110020001p+48, 0x0p+0 },
{ INT64_C(0x0001000110200000), 0x1.0001102p+48, 0x0p+0 },
{ INT64_C(0xfffefffeefdfffff), -0x1.000110200001p+48, 0x0p+0 },
{ INT64_C(0x0001000112000000), 0x1.000112p+48, 0x0p+0 },
{ INT64_C(0xfffefffeedffffff), -0x1.000112000001p+48, 0x0p+0 },
{ INT64_C(0x0001000140000000), 0x1.00014p+48, 0x0p+0 },
{ INT64_C(0xfffefffebfffffff), -0x1.000140000001p+48, 0x0p+0 },
{ INT64_C(0x0001000140000008), 0x1.000140000008p+48, 0x0p+0 },
{ INT64_C(0xfffefffebffffff7), -0x1.000140000009p+48, 0x0p+0 },
{ INT64_C(0x0001000140000020), 0x1.00014000002p+48, 0x0p+0 },
{ INT64_C(0xfffefffebfffffdf), -0x1.000140000021p+48, 0x0p+0 },
{ INT64_C(0x0001000140000100), 0x1.0001400001p+48, 0x0p+0 },
{ INT64_C(0xfffefffebffffeff), -0x1.000140000101p+48, 0x0p+0 },
{ INT64_C(0x0001000140000800), 0x1.0001400008p+48, 0x0p+0 },
{ INT64_C(0xfffefffebffff7ff), -0x1.000140000801p+48, 0x0p+0 },
{ INT64_C(0x0001000140008000), 0x1.000140008p+48, 0x0p+0 },
{ INT64_C(0xfffefffebfff7fff), -0x1.000140008001p+48, 0x0p+0 },
{ INT64_C(0x0001000140010000), 0x1.00014001p+48, 0x0p+0 },
{ INT64_C(0xfffefffebffeffff), -0x1.000140010001p+48, 0x0p+0 },
{ INT64_C(0x0001000140040000), 0x1.00014004p+48, 0x0p+0 },
{ INT64_C(0xfffefffebffbffff), -0x1.000140040001p+48, 0x0p+0 },
{ INT64_C(0x0001000140400000), 0x1.0001404p+48, 0x0p+0 },
{ INT64_C(0xfffefffebfbfffff), -0x1.000140400001p+48, 0x0p+0 },
{ INT64_C(0x0001000144000000), 0x1.000144p+48, 0x0p+0 },
{ INT64_C(0xfffefffebbffffff), -0x1.000144000001p+48, 0x0p+0 },
{ INT64_C(0x0001000160000000), 0x1.00016p+48, 0x0p+0 },
{ INT64_C(0xfffefffe9fffffff), -0x1.000160000001p+48, 0x0p+0 },
{ INT64_C(0x0001000180000000), 0x1.00018p+48, 0x0p+0 },
{ INT64_C(0xfffefffe7fffffff), -0x1.000180000001p+48, 0x0p+0 },
{ INT64_C(0x0001000180000002), 0x1.000180000002p+48, 0x0p+0 },
{ INT64_C(0xfffefffe7ffffffd), -0x1.000180000003p+48, 0x0p+0 },
{ INT64_C(0x0001000180000010), 0x1.00018000001p+48, 0x0p+0 },
{ INT64_C(0xfffefffe7fffffef), -0x1.000180000011p+48, 0x0p+0 },
{ INT64_C(0x0001000180000020), 0x1.00018000002p+48, 0x0p+0 },
{ INT64_C(0xfffefffe7fffffdf), -0x1.000180000021p+48, 0x0p+0 },
{ INT64_C(0x0001000180000040), 0x1.00018000004p+48, 0x0p+0 },
{ INT64_C(0xfffefffe7fffffbf), -0x1.000180000041p+48, 0x0p+0 },
{ INT64_C(0x0001000180000200), 0x1.0001800002p+48, 0x0p+0 },
{ INT64_C(0xfffefffe7ffffdff), -0x1.000180000201p+48, 0x0p+0 },
{ INT64_C(0x0001000180000800), 0x1.0001800008p+48, 0x0p+0 },
{ INT64_C(0xfffefffe7ffff7ff), -0x1.000180000801p+48, 0x0p+0 },
{ INT64_C(0x0001000180002000), 0x1.000180002p+48, 0x0p+0 },
{ INT64_C(0xfffefffe7fffdfff), -0x1.000180002001p+48, 0x0p+0 },
{ INT64_C(0x0001000180020000), 0x1.00018002p+48, 0x0p+0 },
{ INT64_C(0xfffefffe7ffdffff), -0x1.000180020001p+48, 0x0p+0 },
{ INT64_C(0x0001000180100000), 0x1.0001801p+48, 0x0p+0 },
{ INT64_C(0xfffefffe7fefffff), -0x1.000180100001p+48, 0x0p+0 },
{ INT64_C(0x0001000180400000), 0x1.0001804p+48, 0x0p+0 },
{ INT64_C(0xfffefffe7fbfffff), -0x1.000180400001p+48, 0x0p+0 },
{ INT64_C(0x0001000182000000), 0x1.000182p+48, 0x0p+0 },
{ INT64_C(0xfffefffe7dffffff), -0x1.000182000001p+48, 0x0p+0 },
{ INT64_C(0x0001000190000000), 0x1.00019p+48, 0x0p+0 },
{ INT64_C(0xfffefffe6fffffff), -0x1.000190000001p+48, 0x0p+0 },
{ INT64_C(0x00010001c0000000), 0x1.0001cp+48, 0x0p+0 },
{ INT64_C(0xfffefffe3fffffff), -0x1.0001c0000001p+48, 0x0p+0 },
{ INT64_C(0x0001000800000008), 0x1.000800000008p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffffff7), -0x1.000800000009p+48, 0x0p+0 },
{ INT64_C(0x000100080000000a), 0x1.00080000000ap+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffffff5), -0x1.00080000000bp+48, 0x0p+0 },
{ INT64_C(0x0001000800000040), 0x1.00080000004p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffffffbf), -0x1.000800000041p+48, 0x0p+0 },
{ INT64_C(0x0001000800000042), 0x1.000800000042p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffffffbd), -0x1.000800000043p+48, 0x0p+0 },
{ INT64_C(0x0001000800000060), 0x1.00080000006p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffffff9f), -0x1.000800000061p+48, 0x0p+0 },
{ INT64_C(0x0001000800000100), 0x1.0008000001p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffffeff), -0x1.000800000101p+48, 0x0p+0 },
{ INT64_C(0x0001000800000101), 0x1.000800000101p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffffefe), -0x1.000800000102p+48, 0x0p+0 },
{ INT64_C(0x0001000800000108), 0x1.000800000108p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffffef7), -0x1.000800000109p+48, 0x0p+0 },
{ INT64_C(0x0001000800000110), 0x1.00080000011p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffffeef), -0x1.000800000111p+48, 0x0p+0 },
{ INT64_C(0x0001000800000180), 0x1.00080000018p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffffe7f), -0x1.000800000181p+48, 0x0p+0 },
{ INT64_C(0x0001000800000400), 0x1.0008000004p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffffbff), -0x1.000800000401p+48, 0x0p+0 },
{ INT64_C(0x0001000800000408), 0x1.000800000408p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffffbf7), -0x1.000800000409p+48, 0x0p+0 },
{ INT64_C(0x0001000800000420), 0x1.00080000042p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffffbdf), -0x1.000800000421p+48, 0x0p+0 },
{ INT64_C(0x0001000800000600), 0x1.0008000006p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffff9ff), -0x1.000800000601p+48, 0x0p+0 },
{ INT64_C(0x0001000800004000), 0x1.000800004p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffffbfff), -0x1.000800004001p+48, 0x0p+0 },
{ INT64_C(0x0001000800004004), 0x1.000800004004p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffffbffb), -0x1.000800004005p+48, 0x0p+0 },
{ INT64_C(0x0001000800004020), 0x1.00080000402p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffffbfdf), -0x1.000800004021p+48, 0x0p+0 },
{ INT64_C(0x0001000800004040), 0x1.00080000404p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffffbfbf), -0x1.000800004041p+48, 0x0p+0 },
{ INT64_C(0x0001000800004100), 0x1.0008000041p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffffbeff), -0x1.000800004101p+48, 0x0p+0 },
{ INT64_C(0x0001000800004400), 0x1.0008000044p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffffbbff), -0x1.000800004401p+48, 0x0p+0 },
{ INT64_C(0x0001000800005000), 0x1.000800005p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffffafff), -0x1.000800005001p+48, 0x0p+0 },
{ INT64_C(0x0001000800006000), 0x1.000800006p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffff9fff), -0x1.000800006001p+48, 0x0p+0 },
{ INT64_C(0x0001000800040000), 0x1.00080004p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffbffff), -0x1.000800040001p+48, 0x0p+0 },
{ INT64_C(0x0001000800040008), 0x1.000800040008p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffbfff7), -0x1.000800040009p+48, 0x0p+0 },
{ INT64_C(0x0001000800040020), 0x1.00080004002p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffbffdf), -0x1.000800040021p+48, 0x0p+0 },
{ INT64_C(0x0001000800040100), 0x1.0008000401p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffbfeff), -0x1.000800040101p+48, 0x0p+0 },
{ INT64_C(0x0001000800040200), 0x1.0008000402p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffbfdff), -0x1.000800040201p+48, 0x0p+0 },
{ INT64_C(0x0001000800042000), 0x1.000800042p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fffbdfff), -0x1.000800042001p+48, 0x0p+0 },
{ INT64_C(0x0001000800060000), 0x1.00080006p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fff9ffff), -0x1.000800060001p+48, 0x0p+0 },
{ INT64_C(0x0001000800200000), 0x1.0008002p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffdfffff), -0x1.000800200001p+48, 0x0p+0 },
{ INT64_C(0x0001000800200004), 0x1.000800200004p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffdffffb), -0x1.000800200005p+48, 0x0p+0 },
{ INT64_C(0x0001000800200040), 0x1.00080020004p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffdfffbf), -0x1.000800200041p+48, 0x0p+0 },
{ INT64_C(0x0001000800200080), 0x1.00080020008p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffdfff7f), -0x1.000800200081p+48, 0x0p+0 },
{ INT64_C(0x0001000800200200), 0x1.0008002002p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffdffdff), -0x1.000800200201p+48, 0x0p+0 },
{ INT64_C(0x0001000800202000), 0x1.000800202p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffdfdfff), -0x1.000800202001p+48, 0x0p+0 },
{ INT64_C(0x0001000800204000), 0x1.000800204p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffdfbfff), -0x1.000800204001p+48, 0x0p+0 },
{ INT64_C(0x0001000800210000), 0x1.00080021p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffdeffff), -0x1.000800210001p+48, 0x0p+0 },
{ INT64_C(0x0001000800300000), 0x1.0008003p+48, 0x0p+0 },
{ INT64_C(0xfffefff7ffcfffff), -0x1.000800300001p+48, 0x0p+0 },
{ INT64_C(0x0001000802000000), 0x1.000802p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fdffffff), -0x1.000802000001p+48, 0x0p+0 },
{ INT64_C(0x0001000802000001), 0x1.000802000001p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fdfffffe), -0x1.000802000002p+48, 0x0p+0 },
{ INT64_C(0x0001000802000002), 0x1.000802000002p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fdfffffd), -0x1.000802000003p+48, 0x0p+0 },
{ INT64_C(0x0001000802000008), 0x1.000802000008p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fdfffff7), -0x1.000802000009p+48, 0x0p+0 },
{ INT64_C(0x0001000802000040), 0x1.00080200004p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fdffffbf), -0x1.000802000041p+48, 0x0p+0 },
{ INT64_C(0x0001000802000200), 0x1.0008020002p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fdfffdff), -0x1.000802000201p+48, 0x0p+0 },
{ INT64_C(0x0001000802002000), 0x1.000802002p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fdffdfff), -0x1.000802002001p+48, 0x0p+0 },
{ INT64_C(0x0001000802020000), 0x1.00080202p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fdfdffff), -0x1.000802020001p+48, 0x0p+0 },
{ INT64_C(0x0001000802200000), 0x1.0008022p+48, 0x0p+0 },
{ INT64_C(0xfffefff7fddfffff), -0x1.000802200001p+48, 0x0p+0 },
{ INT64_C(0x0001000808000000), 0x1.000808p+48, 0x0p+0 },
{ INT64_C(0xfffefff7f7ffffff), -0x1.000808000001p+48, 0x0p+0 },
{ INT64_C(0x0001000808000004), 0x1.000808000004p+48, 0x0p+0 },
{ INT64_C(0xfffefff7f7fffffb), -0x1.000808000005p+48, 0x0p+0 },
{ INT64_C(0x0001000808000040), 0x1.00080800004p+48, 0x0p+0 },
{ INT64_C(0xfffefff7f7ffffbf), -0x1.000808000041p+48, 0x0p+0 },
{ INT64_C(0x0001000808000400), 0x1.0008080004p+48, 0x0p+0 },
{ INT64_C(0xfffefff7f7fffbff), -0x1.000808000401p+48, 0x0p+0 },
{ INT64_C(0x0001000808004000), 0x1.000808004p+48, 0x0p+0 },
{ INT64_C(0xfffefff7f7ffbfff), -0x1.000808004001p+48, 0x0p+0 },
{ INT64_C(0x0001000808008000), 0x1.000808008p+48, 0x0p+0 },
{ INT64_C(0xfffefff7f7ff7fff), -0x1.000808008001p+48, 0x0p+0 },
{ INT64_C(0x0001000808010000), 0x1.00080801p+48, 0x0p+0 },
{ INT64_C(0xfffefff7f7feffff), -0x1.000808010001p+48, 0x0p+0 },
{ INT64_C(0x0001000808100000), 0x1.0008081p+48, 0x0p+0 },
{ INT64_C(0xfffefff7f7efffff), -0x1.000808100001p+48, 0x0p+0 },
{ INT64_C(0x0001000808800000), 0x1.0008088p+48, 0x0p+0 },
{ INT64_C(0xfffefff7f77fffff), -0x1.000808800001p+48, 0x0p+0 },
{ INT64_C(0x0001000809000000), 0x1.000809p+48, 0x0p+0 },
{ INT64_C(0xfffefff7f6ffffff), -0x1.000809000001p+48, 0x0p+0 },
{ INT64_C(0x0001000880000000), 0x1.00088p+48, 0x0p+0 },
{ INT64_C(0xfffefff77fffffff), -0x1.000880000001p+48, 0x0p+0 },
{ INT64_C(0x0001000880000004), 0x1.000880000004p+48, 0x0p+0 },
{ INT64_C(0xfffefff77ffffffb), -0x1.000880000005p+48, 0x0p+0 },
{ INT64_C(0x0001000880000020), 0x1.00088000002p+48, 0x0p+0 },
{ INT64_C(0xfffefff77fffffdf), -0x1.000880000021p+48, 0x0p+0 },
{ INT64_C(0x0001000880000200), 0x1.0008800002p+48, 0x0p+0 },
{ INT64_C(0xfffefff77ffffdff), -0x1.000880000201p+48, 0x0p+0 },
{ INT64_C(0x0001000880000400), 0x1.0008800004p+48, 0x0p+0 },
{ INT64_C(0xfffefff77ffffbff), -0x1.000880000401p+48, 0x0p+0 },
{ INT64_C(0x0001000880001000), 0x1.000880001p+48, 0x0p+0 },
{ INT64_C(0xfffefff77fffefff), -0x1.000880001001p+48, 0x0p+0 },
{ INT64_C(0x0001000880004000), 0x1.000880004p+48, 0x0p+0 },
{ INT64_C(0xfffefff77fffbfff), -0x1.000880004001p+48, 0x0p+0 },
{ INT64_C(0x0001000880008000), 0x1.000880008p+48, 0x0p+0 },
{ INT64_C(0xfffefff77fff7fff), -0x1.000880008001p+48, 0x0p+0 },
{ INT64_C(0x0001000880040000), 0x1.00088004p+48, 0x0p+0 },
{ INT64_C(0xfffefff77ffbffff), -0x1.000880040001p+48, 0x0p+0 },
{ INT64_C(0x0001000880100000), 0x1.0008801p+48, 0x0p+0 },
{ INT64_C(0xfffefff77fefffff), -0x1.000880100001p+48, 0x0p+0 },
{ INT64_C(0x0001000880200000), 0x1.0008802p+48, 0x0p+0 },
{ INT64_C(0xfffefff77fdfffff), -0x1.000880200001p+48, 0x0p+0 },
{ INT64_C(0x0001000881000000), 0x1.000881p+48, 0x0p+0 },
{ INT64_C(0xfffefff77effffff), -0x1.000881000001p+48, 0x0p+0 },
{ INT64_C(0x0001000890000000), 0x1.00089p+48, 0x0p+0 },
{ INT64_C(0xfffefff76fffffff), -0x1.000890000001p+48, 0x0p+0 },
{ INT64_C(0x00010008a0000000), 0x1.0008ap+48, 0x0p+0 },
{ INT64_C(0xfffefff75fffffff), -0x1.0008a0000001p+48, 0x0p+0 },
{ INT64_C(0x0001000c00000000), 0x1.000cp+48, 0x0p+0 },
{ INT64_C(0xfffefff3ffffffff), -0x1.000c00000001p+48, 0x0p+0 },
{ INT64_C(0x0001000c00000004), 0x1.000c00000004p+48, 0x0p+0 },
{ INT64_C(0xfffefff3fffffffb), -0x1.000c00000005p+48, 0x0p+0 },
{ INT64_C(0x0001000c00000020), 0x1.000c0000002p+48, 0x0p+0 },
{ INT64_C(0xfffefff3ffffffdf), -0x1.000c00000021p+48, 0x0p+0 },
{ INT64_C(0x0001000c00000080), 0x1.000c0000008p+48, 0x0p+0 },
{ INT64_C(0xfffefff3ffffff7f), -0x1.000c00000081p+48, 0x0p+0 },
{ INT64_C(0x0001000c00000800), 0x1.000c000008p+48, 0x0p+0 },
{ INT64_C(0xfffefff3fffff7ff), -0x1.000c00000801p+48, 0x0p+0 },
{ INT64_C(0x0001000c00002000), 0x1.000c00002p+48, 0x0p+0 },
{ INT64_C(0xfffefff3ffffdfff), -0x1.000c00002001p+48, 0x0p+0 },
{ INT64_C(0x0001000c00008000), 0x1.000c00008p+48, 0x0p+0 },
{ INT64_C(0xfffefff3ffff7fff), -0x1.000c00008001p+48, 0x0p+0 },
{ INT64_C(0x0001000c00010000), 0x1.000c0001p+48, 0x0p+0 },
{ INT64_C(0xfffefff3fffeffff), -0x1.000c00010001p+48, 0x0p+0 },
{ INT64_C(0x0001000c00020000), 0x1.000c0002p+48, 0x0p+0 },
{ INT64_C(0xfffefff3fffdffff), -0x1.000c00020001p+48, 0x0p+0 },
{ INT64_C(0x0001000c00040000), 0x1.000c0004p+48, 0x0p+0 },
{ INT64_C(0xfffefff3fffbffff), -0x1.000c00040001p+48, 0x0p+0 },
{ INT64_C(0x0001000c00200000), 0x1.000c002p+48, 0x0p+0 },
{ INT64_C(0xfffefff3ffdfffff), -0x1.000c00200001p+48, 0x0p+0 },
{ INT64_C(0x0001000c00800000), 0x1.000c008p+48, 0x0p+0 },
{ INT64_C(0xfffefff3ff7fffff), -0x1.000c00800001p+48, 0x0p+0 },
{ INT64_C(0x0001000c01000000), 0x1.000c01p+48, 0x0p+0 },
{ INT64_C(0xfffefff3feffffff), -0x1.000c01000001p+48, 0x0p+0 },
{ INT64_C(0x0001000c08000000), 0x1.000c08p+48, 0x0p+0 },
{ INT64_C(0xfffefff3f7ffffff), -0x1.000c08000001p+48, 0x0p+0 },
{ INT64_C(0x0001000c20000000), 0x1.000c2p+48, 0x0p+0 },
{ INT64_C(0xfffefff3dfffffff), -0x1.000c20000001p+48, 0x0p+0 },
{ INT64_C(0x0001000c40000000), 0x1.000c4p+48, 0x0p+0 },
{ INT64_C(0xfffefff3bfffffff), -0x1.000c40000001p+48, 0x0p+0 },
{ INT64_C(0x0001008000000008), 0x1.008000000008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffffff7), -0x1.008000000009p+48, 0x0p+0 },
{ INT64_C(0x0001008000000020), 0x1.00800000002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffffdf), -0x1.008000000021p+48, 0x0p+0 },
{ INT64_C(0x0001008000000028), 0x1.008000000028p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffffd7), -0x1.008000000029p+48, 0x0p+0 },
{ INT64_C(0x0001008000000080), 0x1.00800000008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffff7f), -0x1.008000000081p+48, 0x0p+0 },
{ INT64_C(0x0001008000000082), 0x1.008000000082p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffff7d), -0x1.008000000083p+48, 0x0p+0 },
{ INT64_C(0x0001008000000090), 0x1.00800000009p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffff6f), -0x1.008000000091p+48, 0x0p+0 },
{ INT64_C(0x00010080000000a0), 0x1.0080000000ap+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffff5f), -0x1.0080000000a1p+48, 0x0p+0 },
{ INT64_C(0x0001008000000800), 0x1.0080000008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffff7ff), -0x1.008000000801p+48, 0x0p+0 },
{ INT64_C(0x0001008000000802), 0x1.008000000802p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffff7fd), -0x1.008000000803p+48, 0x0p+0 },
{ INT64_C(0x0001008000000808), 0x1.008000000808p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffff7f7), -0x1.008000000809p+48, 0x0p+0 },
{ INT64_C(0x0001008000000810), 0x1.00800000081p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffff7ef), -0x1.008000000811p+48, 0x0p+0 },
{ INT64_C(0x0001008000000820), 0x1.00800000082p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffff7df), -0x1.008000000821p+48, 0x0p+0 },
{ INT64_C(0x0001008000000900), 0x1.0080000009p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffff6ff), -0x1.008000000901p+48, 0x0p+0 },
{ INT64_C(0x0001008000001000), 0x1.008000001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffefff), -0x1.008000001001p+48, 0x0p+0 },
{ INT64_C(0x0001008000001001), 0x1.008000001001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffeffe), -0x1.008000001002p+48, 0x0p+0 },
{ INT64_C(0x0001008000001004), 0x1.008000001004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffeffb), -0x1.008000001005p+48, 0x0p+0 },
{ INT64_C(0x0001008000001010), 0x1.00800000101p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffefef), -0x1.008000001011p+48, 0x0p+0 },
{ INT64_C(0x0001008000001020), 0x1.00800000102p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffefdf), -0x1.008000001021p+48, 0x0p+0 },
{ INT64_C(0x0001008000001080), 0x1.00800000108p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffef7f), -0x1.008000001081p+48, 0x0p+0 },
{ INT64_C(0x0001008000001800), 0x1.0080000018p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffe7ff), -0x1.008000001801p+48, 0x0p+0 },
{ INT64_C(0x0001008000002000), 0x1.008000002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffdfff), -0x1.008000002001p+48, 0x0p+0 },
{ INT64_C(0x0001008000002004), 0x1.008000002004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffdffb), -0x1.008000002005p+48, 0x0p+0 },
{ INT64_C(0x0001008000002040), 0x1.00800000204p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffdfbf), -0x1.008000002041p+48, 0x0p+0 },
{ INT64_C(0x0001008000002100), 0x1.0080000021p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffdeff), -0x1.008000002101p+48, 0x0p+0 },
{ INT64_C(0x0001008000003000), 0x1.008000003p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffffcfff), -0x1.008000003001p+48, 0x0p+0 },
{ INT64_C(0x0001008000008000), 0x1.008000008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffff7fff), -0x1.008000008001p+48, 0x0p+0 },
{ INT64_C(0x0001008000008004), 0x1.008000008004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffff7ffb), -0x1.008000008005p+48, 0x0p+0 },
{ INT64_C(0x0001008000008010), 0x1.00800000801p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffff7fef), -0x1.008000008011p+48, 0x0p+0 },
{ INT64_C(0x0001008000008040), 0x1.00800000804p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffff7fbf), -0x1.008000008041p+48, 0x0p+0 },
{ INT64_C(0x0001008000008100), 0x1.0080000081p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffff7eff), -0x1.008000008101p+48, 0x0p+0 },
{ INT64_C(0x0001008000008400), 0x1.0080000084p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffff7bff), -0x1.008000008401p+48, 0x0p+0 },
{ INT64_C(0x0001008000008800), 0x1.0080000088p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffff77ff), -0x1.008000008801p+48, 0x0p+0 },
{ INT64_C(0x0001008000020000), 0x1.00800002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffdffff), -0x1.008000020001p+48, 0x0p+0 },
{ INT64_C(0x0001008000020001), 0x1.008000020001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffdfffe), -0x1.008000020002p+48, 0x0p+0 },
{ INT64_C(0x0001008000020002), 0x1.008000020002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffdfffd), -0x1.008000020003p+48, 0x0p+0 },
{ INT64_C(0x0001008000020004), 0x1.008000020004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffdfffb), -0x1.008000020005p+48, 0x0p+0 },
{ INT64_C(0x0001008000020020), 0x1.00800002002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffdffdf), -0x1.008000020021p+48, 0x0p+0 },
{ INT64_C(0x0001008000020100), 0x1.0080000201p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffdfeff), -0x1.008000020101p+48, 0x0p+0 },
{ INT64_C(0x0001008000020400), 0x1.0080000204p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffdfbff), -0x1.008000020401p+48, 0x0p+0 },
{ INT64_C(0x0001008000021000), 0x1.008000021p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffdefff), -0x1.008000021001p+48, 0x0p+0 },
{ INT64_C(0x0001008000022000), 0x1.008000022p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffddfff), -0x1.008000022001p+48, 0x0p+0 },
{ INT64_C(0x0001008000024000), 0x1.008000024p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffffdbfff), -0x1.008000024001p+48, 0x0p+0 },
{ INT64_C(0x0001008000080000), 0x1.00800008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffff7ffff), -0x1.008000080001p+48, 0x0p+0 },
{ INT64_C(0x0001008000080008), 0x1.008000080008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffff7fff7), -0x1.008000080009p+48, 0x0p+0 },
{ INT64_C(0x0001008000080020), 0x1.00800008002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffff7ffdf), -0x1.008000080021p+48, 0x0p+0 },
{ INT64_C(0x0001008000080200), 0x1.0080000802p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffff7fdff), -0x1.008000080201p+48, 0x0p+0 },
{ INT64_C(0x0001008000080400), 0x1.0080000804p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffff7fbff), -0x1.008000080401p+48, 0x0p+0 },
{ INT64_C(0x0001008000081000), 0x1.008000081p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffff7efff), -0x1.008000081001p+48, 0x0p+0 },
{ INT64_C(0x0001008000090000), 0x1.00800009p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffff6ffff), -0x1.008000090001p+48, 0x0p+0 },
{ INT64_C(0x00010080000a0000), 0x1.0080000ap+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffff5ffff), -0x1.0080000a0001p+48, 0x0p+0 },
{ INT64_C(0x0001008000200000), 0x1.0080002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffdfffff), -0x1.008000200001p+48, 0x0p+0 },
{ INT64_C(0x0001008000200001), 0x1.008000200001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffdffffe), -0x1.008000200002p+48, 0x0p+0 },
{ INT64_C(0x0001008000200002), 0x1.008000200002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffdffffd), -0x1.008000200003p+48, 0x0p+0 },
{ INT64_C(0x0001008000200020), 0x1.00800020002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffdfffdf), -0x1.008000200021p+48, 0x0p+0 },
{ INT64_C(0x0001008000200080), 0x1.00800020008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffdfff7f), -0x1.008000200081p+48, 0x0p+0 },
{ INT64_C(0x0001008000200100), 0x1.0080002001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffdffeff), -0x1.008000200101p+48, 0x0p+0 },
{ INT64_C(0x0001008000200800), 0x1.0080002008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffdff7ff), -0x1.008000200801p+48, 0x0p+0 },
{ INT64_C(0x0001008000208000), 0x1.008000208p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffdf7fff), -0x1.008000208001p+48, 0x0p+0 },
{ INT64_C(0x0001008000240000), 0x1.00800024p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffdbffff), -0x1.008000240001p+48, 0x0p+0 },
{ INT64_C(0x0001008000280000), 0x1.00800028p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fffd7ffff), -0x1.008000280001p+48, 0x0p+0 },
{ INT64_C(0x0001008000800000), 0x1.0080008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fff7fffff), -0x1.008000800001p+48, 0x0p+0 },
{ INT64_C(0x0001008000800001), 0x1.008000800001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fff7ffffe), -0x1.008000800002p+48, 0x0p+0 },
{ INT64_C(0x0001008000800004), 0x1.008000800004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fff7ffffb), -0x1.008000800005p+48, 0x0p+0 },
{ INT64_C(0x0001008000800020), 0x1.00800080002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fff7fffdf), -0x1.008000800021p+48, 0x0p+0 },
{ INT64_C(0x0001008000800080), 0x1.00800080008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fff7fff7f), -0x1.008000800081p+48, 0x0p+0 },
{ INT64_C(0x0001008000800200), 0x1.0080008002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fff7ffdff), -0x1.008000800201p+48, 0x0p+0 },
{ INT64_C(0x0001008000800800), 0x1.0080008008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fff7ff7ff), -0x1.008000800801p+48, 0x0p+0 },
{ INT64_C(0x0001008000802000), 0x1.008000802p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fff7fdfff), -0x1.008000802001p+48, 0x0p+0 },
{ INT64_C(0x0001008000804000), 0x1.008000804p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fff7fbfff), -0x1.008000804001p+48, 0x0p+0 },
{ INT64_C(0x0001008000810000), 0x1.00800081p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fff7effff), -0x1.008000810001p+48, 0x0p+0 },
{ INT64_C(0x0001008000840000), 0x1.00800084p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fff7bffff), -0x1.008000840001p+48, 0x0p+0 },
{ INT64_C(0x0001008000c00000), 0x1.008000cp+48, 0x0p+0 },
{ INT64_C(0xfffeff7fff3fffff), -0x1.008000c00001p+48, 0x0p+0 },
{ INT64_C(0x0001008002000000), 0x1.008002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffdffffff), -0x1.008002000001p+48, 0x0p+0 },
{ INT64_C(0x0001008002000002), 0x1.008002000002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffdfffffd), -0x1.008002000003p+48, 0x0p+0 },
{ INT64_C(0x0001008002000004), 0x1.008002000004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffdfffffb), -0x1.008002000005p+48, 0x0p+0 },
{ INT64_C(0x0001008002000020), 0x1.00800200002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffdffffdf), -0x1.008002000021p+48, 0x0p+0 },
{ INT64_C(0x0001008002000080), 0x1.00800200008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffdffff7f), -0x1.008002000081p+48, 0x0p+0 },
{ INT64_C(0x0001008002000800), 0x1.0080020008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffdfff7ff), -0x1.008002000801p+48, 0x0p+0 },
{ INT64_C(0x0001008002004000), 0x1.008002004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffdffbfff), -0x1.008002004001p+48, 0x0p+0 },
{ INT64_C(0x0001008002040000), 0x1.00800204p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffdfbffff), -0x1.008002040001p+48, 0x0p+0 },
{ INT64_C(0x0001008002080000), 0x1.00800208p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffdf7ffff), -0x1.008002080001p+48, 0x0p+0 },
{ INT64_C(0x0001008002400000), 0x1.0080024p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ffdbfffff), -0x1.008002400001p+48, 0x0p+0 },
{ INT64_C(0x0001008010000000), 0x1.00801p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fefffffff), -0x1.008010000001p+48, 0x0p+0 },
{ INT64_C(0x0001008010000001), 0x1.008010000001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7feffffffe), -0x1.008010000002p+48, 0x0p+0 },
{ INT64_C(0x0001008010000010), 0x1.00801000001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fefffffef), -0x1.008010000011p+48, 0x0p+0 },
{ INT64_C(0x0001008010000040), 0x1.00801000004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fefffffbf), -0x1.008010000041p+48, 0x0p+0 },
{ INT64_C(0x0001008010000200), 0x1.0080100002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7feffffdff), -0x1.008010000201p+48, 0x0p+0 },
{ INT64_C(0x0001008010000800), 0x1.0080100008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7feffff7ff), -0x1.008010000801p+48, 0x0p+0 },
{ INT64_C(0x0001008010004000), 0x1.008010004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fefffbfff), -0x1.008010004001p+48, 0x0p+0 },
{ INT64_C(0x0001008010040000), 0x1.00801004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7feffbffff), -0x1.008010040001p+48, 0x0p+0 },
{ INT64_C(0x0001008010400000), 0x1.0080104p+48, 0x0p+0 },
{ INT64_C(0xfffeff7fefbfffff), -0x1.008010400001p+48, 0x0p+0 },
{ INT64_C(0x0001008011000000), 0x1.008011p+48, 0x0p+0 },
{ INT64_C(0xfffeff7feeffffff), -0x1.008011000001p+48, 0x0p+0 },
{ INT64_C(0x0001008080000000), 0x1.00808p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f7fffffff), -0x1.008080000001p+48, 0x0p+0 },
{ INT64_C(0x0001008080000002), 0x1.008080000002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f7ffffffd), -0x1.008080000003p+48, 0x0p+0 },
{ INT64_C(0x0001008080000010), 0x1.00808000001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f7fffffef), -0x1.008080000011p+48, 0x0p+0 },
{ INT64_C(0x0001008080000080), 0x1.00808000008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f7fffff7f), -0x1.008080000081p+48, 0x0p+0 },
{ INT64_C(0x0001008080000200), 0x1.0080800002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f7ffffdff), -0x1.008080000201p+48, 0x0p+0 },
{ INT64_C(0x0001008080000800), 0x1.0080800008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f7ffff7ff), -0x1.008080000801p+48, 0x0p+0 },
{ INT64_C(0x0001008080002000), 0x1.008080002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f7fffdfff), -0x1.008080002001p+48, 0x0p+0 },
{ INT64_C(0x0001008080020000), 0x1.00808002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f7ffdffff), -0x1.008080020001p+48, 0x0p+0 },
{ INT64_C(0x0001008080100000), 0x1.0080801p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f7fefffff), -0x1.008080100001p+48, 0x0p+0 },
{ INT64_C(0x0001008080400000), 0x1.0080804p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f7fbfffff), -0x1.008080400001p+48, 0x0p+0 },
{ INT64_C(0x0001008080800000), 0x1.0080808p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f7f7fffff), -0x1.008080800001p+48, 0x0p+0 },
{ INT64_C(0x0001008084000000), 0x1.008084p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f7bffffff), -0x1.008084000001p+48, 0x0p+0 },
{ INT64_C(0x0001008088000000), 0x1.008088p+48, 0x0p+0 },
{ INT64_C(0xfffeff7f77ffffff), -0x1.008088000001p+48, 0x0p+0 },
{ INT64_C(0x00010080a0000000), 0x1.0080ap+48, 0x0p+0 },
{ INT64_C(0xfffeff7f5fffffff), -0x1.0080a0000001p+48, 0x0p+0 },
{ INT64_C(0x0001008100000000), 0x1.0081p+48, 0x0p+0 },
{ INT64_C(0xfffeff7effffffff), -0x1.008100000001p+48, 0x0p+0 },
{ INT64_C(0x0001008100000004), 0x1.008100000004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7efffffffb), -0x1.008100000005p+48, 0x0p+0 },
{ INT64_C(0x0001008100000020), 0x1.00810000002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7effffffdf), -0x1.008100000021p+48, 0x0p+0 },
{ INT64_C(0x0001008100000100), 0x1.0081000001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7efffffeff), -0x1.008100000101p+48, 0x0p+0 },
{ INT64_C(0x0001008100001000), 0x1.008100001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7effffefff), -0x1.008100001001p+48, 0x0p+0 },
{ INT64_C(0x0001008100002000), 0x1.008100002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7effffdfff), -0x1.008100002001p+48, 0x0p+0 },
{ INT64_C(0x0001008100010000), 0x1.00810001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7efffeffff), -0x1.008100010001p+48, 0x0p+0 },
{ INT64_C(0x0001008100080000), 0x1.00810008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7efff7ffff), -0x1.008100080001p+48, 0x0p+0 },
{ INT64_C(0x0001008100200000), 0x1.0081002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7effdfffff), -0x1.008100200001p+48, 0x0p+0 },
{ INT64_C(0x0001008100400000), 0x1.0081004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7effbfffff), -0x1.008100400001p+48, 0x0p+0 },
{ INT64_C(0x0001008102000000), 0x1.008102p+48, 0x0p+0 },
{ INT64_C(0xfffeff7efdffffff), -0x1.008102000001p+48, 0x0p+0 },
{ INT64_C(0x0001008120000000), 0x1.00812p+48, 0x0p+0 },
{ INT64_C(0xfffeff7edfffffff), -0x1.008120000001p+48, 0x0p+0 },
{ INT64_C(0x0001008140000000), 0x1.00814p+48, 0x0p+0 },
{ INT64_C(0xfffeff7ebfffffff), -0x1.008140000001p+48, 0x0p+0 },
{ INT64_C(0x0001008180000000), 0x1.00818p+48, 0x0p+0 },
{ INT64_C(0xfffeff7e7fffffff), -0x1.008180000001p+48, 0x0p+0 },
{ INT64_C(0x0001008400000000), 0x1.0084p+48, 0x0p+0 },
{ INT64_C(0xfffeff7bffffffff), -0x1.008400000001p+48, 0x0p+0 },
{ INT64_C(0x0001008400000002), 0x1.008400000002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7bfffffffd), -0x1.008400000003p+48, 0x0p+0 },
{ INT64_C(0x0001008400000010), 0x1.00840000001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7bffffffef), -0x1.008400000011p+48, 0x0p+0 },
{ INT64_C(0x0001008400000040), 0x1.00840000004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7bffffffbf), -0x1.008400000041p+48, 0x0p+0 },
{ INT64_C(0x0001008400000100), 0x1.0084000001p+48, 0x0p+0 },
{ INT64_C(0xfffeff7bfffffeff), -0x1.008400000101p+48, 0x0p+0 },
{ INT64_C(0x0001008400000800), 0x1.0084000008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7bfffff7ff), -0x1.008400000801p+48, 0x0p+0 },
{ INT64_C(0x0001008400004000), 0x1.008400004p+48, 0x0p+0 },
{ INT64_C(0xfffeff7bffffbfff), -0x1.008400004001p+48, 0x0p+0 },
{ INT64_C(0x0001008400008000), 0x1.008400008p+48, 0x0p+0 },
{ INT64_C(0xfffeff7bffff7fff), -0x1.008400008001p+48, 0x0p+0 },
{ INT64_C(0x0001008400020000), 0x1.00840002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7bfffdffff), -0x1.008400020001p+48, 0x0p+0 },
{ INT64_C(0x0001008400200000), 0x1.0084002p+48, 0x0p+0 },
{ INT64_C(0xfffeff7bffdfffff), -0x1.008400200001p+48, 0x0p+0 },
{ INT64_C(0x0001008402000000), 0x1.008402p+48, 0x0p+0 },
{ INT64_C(0xfffeff7bfdffffff), -0x1.008402000001p+48, 0x0p+0 },
{ INT64_C(0x0001008408000000), 0x1.008408p+48, 0x0p+0 },
{ INT64_C(0xfffeff7bf7ffffff), -0x1.008408000001p+48, 0x0p+0 },
{ INT64_C(0x0001008480000000), 0x1.00848p+48, 0x0p+0 },
{ INT64_C(0xfffeff7b7fffffff), -0x1.008480000001p+48, 0x0p+0 },
{ INT64_C(0x000100a000000000), 0x1.00ap+48, 0x0p+0 },
{ INT64_C(0xfffeff5fffffffff), -0x1.00a000000001p+48, 0x0p+0 },
{ INT64_C(0x000100a000000002), 0x1.00a000000002p+48, 0x0p+0 },
{ INT64_C(0xfffeff5ffffffffd), -0x1.00a000000003p+48, 0x0p+0 },
{ INT64_C(0x000100a000000010), 0x1.00a00000001p+48, 0x0p+0 },
{ INT64_C(0xfffeff5fffffffef), -0x1.00a000000011p+48, 0x0p+0 },
{ INT64_C(0x000100a000000020), 0x1.00a00000002p+48, 0x0p+0 },
{ INT64_C(0xfffeff5fffffffdf), -0x1.00a000000021p+48, 0x0p+0 },
{ INT64_C(0x000100a000000100), 0x1.00a0000001p+48, 0x0p+0 },
{ INT64_C(0xfffeff5ffffffeff), -0x1.00a000000101p+48, 0x0p+0 },
{ INT64_C(0x000100a000000200), 0x1.00a0000002p+48, 0x0p+0 },
{ INT64_C(0xfffeff5ffffffdff), -0x1.00a000000201p+48, 0x0p+0 },
{ INT64_C(0x000100a000000400), 0x1.00a0000004p+48, 0x0p+0 },
{ INT64_C(0xfffeff5ffffffbff), -0x1.00a000000401p+48, 0x0p+0 },
{ INT64_C(0x000100a000004000), 0x1.00a000004p+48, 0x0p+0 },
{ INT64_C(0xfffeff5fffffbfff), -0x1.00a000004001p+48, 0x0p+0 },
{ INT64_C(0x000100a000010000), 0x1.00a00001p+48, 0x0p+0 },
{ INT64_C(0xfffeff5ffffeffff), -0x1.00a000010001p+48, 0x0p+0 },
{ INT64_C(0x000100a000020000), 0x1.00a00002p+48, 0x0p+0 },
{ INT64_C(0xfffeff5ffffdffff), -0x1.00a000020001p+48, 0x0p+0 },
{ INT64_C(0x000100a000100000), 0x1.00a0001p+48, 0x0p+0 },
{ INT64_C(0xfffeff5fffefffff), -0x1.00a000100001p+48, 0x0p+0 },
{ INT64_C(0x000100a000400000), 0x1.00a0004p+48, 0x0p+0 },
{ INT64_C(0xfffeff5fffbfffff), -0x1.00a000400001p+48, 0x0p+0 },
{ INT64_C(0x000100a001000000), 0x1.00a001p+48, 0x0p+0 },
{ INT64_C(0xfffeff5ffeffffff), -0x1.00a001000001p+48, 0x0p+0 },
{ INT64_C(0x000100a004000000), 0x1.00a004p+48, 0x0p+0 },
{ INT64_C(0xfffeff5ffbffffff), -0x1.00a004000001p+48, 0x0p+0 },
{ INT64_C(0x000100a020000000), 0x1.00a02p+48, 0x0p+0 },
{ INT64_C(0xfffeff5fdfffffff), -0x1.00a020000001p+48, 0x0p+0 },
{ INT64_C(0x000100a200000000), 0x1.00a2p+48, 0x0p+0 },
{ INT64_C(0xfffeff5dffffffff), -0x1.00a200000001p+48, 0x0p+0 },
{ INT64_C(0x000100b000000000), 0x1.00bp+48, 0x0p+0 },
{ INT64_C(0xfffeff4fffffffff), -0x1.00b000000001p+48, 0x0p+0 },
{ INT64_C(0x0001010000000008), 0x1.010000000008p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffffff7), -0x1.010000000009p+48, 0x0p+0 },
{ INT64_C(0x000101000000000a), 0x1.01000000000ap+48, 0x0p+0 },
{ INT64_C(0xfffefefffffffff5), -0x1.01000000000bp+48, 0x0p+0 },
{ INT64_C(0x0001010000000080), 0x1.01000000008p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffff7f), -0x1.010000000081p+48, 0x0p+0 },
{ INT64_C(0x0001010000000084), 0x1.010000000084p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffff7b), -0x1.010000000085p+48, 0x0p+0 },
{ INT64_C(0x00010100000000c0), 0x1.0100000000cp+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffff3f), -0x1.0100000000c1p+48, 0x0p+0 },
{ INT64_C(0x0001010000000100), 0x1.0100000001p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffffeff), -0x1.010000000101p+48, 0x0p+0 },
{ INT64_C(0x0001010000000104), 0x1.010000000104p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffffefb), -0x1.010000000105p+48, 0x0p+0 },
{ INT64_C(0x0001010000000140), 0x1.01000000014p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffffebf), -0x1.010000000141p+48, 0x0p+0 },
{ INT64_C(0x0001010000000400), 0x1.0100000004p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffffbff), -0x1.010000000401p+48, 0x0p+0 },
{ INT64_C(0x0001010000000404), 0x1.010000000404p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffffbfb), -0x1.010000000405p+48, 0x0p+0 },
{ INT64_C(0x0001010000000408), 0x1.010000000408p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffffbf7), -0x1.010000000409p+48, 0x0p+0 },
{ INT64_C(0x0001010000000440), 0x1.01000000044p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffffbbf), -0x1.010000000441p+48, 0x0p+0 },
{ INT64_C(0x0001010000000480), 0x1.01000000048p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffffb7f), -0x1.010000000481p+48, 0x0p+0 },
{ INT64_C(0x0001010000000600), 0x1.0100000006p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffff9ff), -0x1.010000000601p+48, 0x0p+0 },
{ INT64_C(0x0001010000001000), 0x1.010000001p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffefff), -0x1.010000001001p+48, 0x0p+0 },
{ INT64_C(0x0001010000001001), 0x1.010000001001p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffeffe), -0x1.010000001002p+48, 0x0p+0 },
{ INT64_C(0x0001010000001008), 0x1.010000001008p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffeff7), -0x1.010000001009p+48, 0x0p+0 },
{ INT64_C(0x0001010000001010), 0x1.01000000101p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffefef), -0x1.010000001011p+48, 0x0p+0 },
{ INT64_C(0x0001010000001020), 0x1.01000000102p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffefdf), -0x1.010000001021p+48, 0x0p+0 },
{ INT64_C(0x0001010000001040), 0x1.01000000104p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffefbf), -0x1.010000001041p+48, 0x0p+0 },
{ INT64_C(0x0001010000001080), 0x1.01000000108p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffef7f), -0x1.010000001081p+48, 0x0p+0 },
{ INT64_C(0x0001010000001800), 0x1.0100000018p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffe7ff), -0x1.010000001801p+48, 0x0p+0 },
{ INT64_C(0x0001010000004000), 0x1.010000004p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffbfff), -0x1.010000004001p+48, 0x0p+0 },
{ INT64_C(0x0001010000004001), 0x1.010000004001p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffbffe), -0x1.010000004002p+48, 0x0p+0 },
{ INT64_C(0x0001010000004002), 0x1.010000004002p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffbffd), -0x1.010000004003p+48, 0x0p+0 },
{ INT64_C(0x0001010000004010), 0x1.01000000401p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffbfef), -0x1.010000004011p+48, 0x0p+0 },
{ INT64_C(0x0001010000004080), 0x1.01000000408p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffbf7f), -0x1.010000004081p+48, 0x0p+0 },
{ INT64_C(0x0001010000004200), 0x1.0100000042p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffffbdff), -0x1.010000004201p+48, 0x0p+0 },
{ INT64_C(0x0001010000006000), 0x1.010000006p+48, 0x0p+0 },
{ INT64_C(0xfffefeffffff9fff), -0x1.010000006001p+48, 0x0p+0 },
{ INT64_C(0x0001010000010000), 0x1.01000001p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffeffff), -0x1.010000010001p+48, 0x0p+0 },
{ INT64_C(0x0001010000010001), 0x1.010000010001p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffefffe), -0x1.010000010002p+48, 0x0p+0 },
{ INT64_C(0x0001010000010008), 0x1.010000010008p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffefff7), -0x1.010000010009p+48, 0x0p+0 },
{ INT64_C(0x0001010000010020), 0x1.01000001002p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffeffdf), -0x1.010000010021p+48, 0x0p+0 },
{ INT64_C(0x0001010000010040), 0x1.01000001004p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffeffbf), -0x1.010000010041p+48, 0x0p+0 },
{ INT64_C(0x0001010000010100), 0x1.0100000101p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffefeff), -0x1.010000010101p+48, 0x0p+0 },
{ INT64_C(0x0001010000010800), 0x1.0100000108p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffef7ff), -0x1.010000010801p+48, 0x0p+0 },
{ INT64_C(0x0001010000018000), 0x1.010000018p+48, 0x0p+0 },
{ INT64_C(0xfffefefffffe7fff), -0x1.010000018001p+48, 0x0p+0 },
{ INT64_C(0x0001010000080000), 0x1.01000008p+48, 0x0p+0 },
{ INT64_C(0xfffefefffff7ffff), -0x1.010000080001p+48, 0x0p+0 },
{ INT64_C(0x0001010000080001), 0x1.010000080001p+48, 0x0p+0 },
{ INT64_C(0xfffefefffff7fffe), -0x1.010000080002p+48, 0x0p+0 },
{ INT64_C(0x0001010000080010), 0x1.01000008001p+48, 0x0p+0 },
{ INT64_C(0xfffefefffff7ffef), -0x1.010000080011p+48, 0x0p+0 },
{ INT64_C(0x0001010000080080), 0x1.01000008008p+48, 0x0p+0 },
{ INT64_C(0xfffefefffff7ff7f), -0x1.010000080081p+48, 0x0p+0 },
{ INT64_C(0x0001010000080400), 0x1.0100000804p+48, 0x0p+0 },
{ INT64_C(0xfffefefffff7fbff), -0x1.010000080401p+48, 0x0p+0 },
{ INT64_C(0x0001010000082000), 0x1.010000082p+48, 0x0p+0 },
{ INT64_C(0xfffefefffff7dfff), -0x1.010000082001p+48, 0x0p+0 },
{ INT64_C(0x00010100000a0000), 0x1.0100000ap+48, 0x0p+0 },
{ INT64_C(0xfffefefffff5ffff), -0x1.0100000a0001p+48, 0x0p+0 },
{ INT64_C(0x0001010000800000), 0x1.0100008p+48, 0x0p+0 },
{ INT64_C(0xfffefeffff7fffff), -0x1.010000800001p+48, 0x0p+0 },
{ INT64_C(0x0001010000800002), 0x1.010000800002p+48, 0x0p+0 },
{ INT64_C(0xfffefeffff7ffffd), -0x1.010000800003p+48, 0x0p+0 },
{ INT64_C(0x0001010000800010), 0x1.01000080001p+48, 0x0p+0 },
{ INT64_C(0xfffefeffff7fffef), -0x1.010000800011p+48, 0x0p+0 },
{ INT64_C(0x0001010000800020), 0x1.01000080002p+48, 0x0p+0 },
{ INT64_C(0xfffefeffff7fffdf), -0x1.010000800021p+48, 0x0p+0 },
{ INT64_C(0x0001010000800040), 0x1.01000080004p+48, 0x0p+0 },
{ INT64_C(0xfffefeffff7fffbf), -0x1.010000800041p+48, 0x0p+0 },
{ INT64_C(0x0001010000800100), 0x1.0100008001p+48, 0x0p+0 },
{ INT64_C(0xfffefeffff7ffeff), -0x1.010000800101p+48, 0x0p+0 },
{ INT64_C(0x0001010000801000), 0x1.010000801p+48, 0x0p+0 },
{ INT64_C(0xfffefeffff7fefff), -0x1.010000801001p+48, 0x0p+0 },
{ INT64_C(0x0001010000808000), 0x1.010000808p+48, 0x0p+0 },
{ INT64_C(0xfffefeffff7f7fff), -0x1.010000808001p+48, 0x0p+0 },
{ INT64_C(0x0001010000840000), 0x1.01000084p+48, 0x0p+0 },
{ INT64_C(0xfffefeffff7bffff), -0x1.010000840001p+48, 0x0p+0 },
{ INT64_C(0x0001010000880000), 0x1.01000088p+48, 0x0p+0 },
{ INT64_C(0xfffefeffff77ffff), -0x1.010000880001p+48, 0x0p+0 },
{ INT64_C(0x0001010000a00000), 0x1.010000ap+48, 0x0p+0 },
{ INT64_C(0xfffefeffff5fffff), -0x1.010000a00001p+48, 0x0p+0 },
{ INT64_C(0x0001010002000000), 0x1.010002p+48, 0x0p+0 },
{ INT64_C(0xfffefefffdffffff), -0x1.010002000001p+48, 0x0p+0 },
{ INT64_C(0x0001010002000001), 0x1.010002000001p+48, 0x0p+0 },
{ INT64_C(0xfffefefffdfffffe), -0x1.010002000002p+48, 0x0p+0 },
{ INT64_C(0x0001010002000008), 0x1.010002000008p+48, 0x0p+0 },
{ INT64_C(0xfffefefffdfffff7), -0x1.010002000009p+48, 0x0p+0 },
{ INT64_C(0x0001010002000080), 0x1.01000200008p+48, 0x0p+0 },
{ INT64_C(0xfffefefffdffff7f), -0x1.010002000081p+48, 0x0p+0 },
{ INT64_C(0x0001010002000400), 0x1.0100020004p+48, 0x0p+0 },
{ INT64_C(0xfffefefffdfffbff), -0x1.010002000401p+48, 0x0p+0 },
{ INT64_C(0x0001010002001000), 0x1.010002001p+48, 0x0p+0 },
{ INT64_C(0xfffefefffdffefff), -0x1.010002001001p+48, 0x0p+0 },
{ INT64_C(0x0001010002002000), 0x1.010002002p+48, 0x0p+0 },
{ INT64_C(0xfffefefffdffdfff), -0x1.010002002001p+48, 0x0p+0 },
{ INT64_C(0x0001010002010000), 0x1.01000201p+48, 0x0p+0 },
{ INT64_C(0xfffefefffdfeffff), -0x1.010002010001p+48, 0x0p+0 },
{ INT64_C(0x0001010002040000), 0x1.01000204p+48, 0x0p+0 },
{ INT64_C(0xfffefefffdfbffff), -0x1.010002040001p+48, 0x0p+0 },
{ INT64_C(0x0001010002080000), 0x1.01000208p+48, 0x0p+0 },
{ INT64_C(0xfffefefffdf7ffff), -0x1.010002080001p+48, 0x0p+0 },
{ INT64_C(0x0001010002100000), 0x1.0100021p+48, 0x0p+0 },
{ INT64_C(0xfffefefffdefffff), -0x1.010002100001p+48, 0x0p+0 },
{ INT64_C(0x0001010002800000), 0x1.0100028p+48, 0x0p+0 },
{ INT64_C(0xfffefefffd7fffff), -0x1.010002800001p+48, 0x0p+0 },
{ INT64_C(0x0001010010000000), 0x1.01001p+48, 0x0p+0 },
{ INT64_C(0xfffefeffefffffff), -0x1.010010000001p+48, 0x0p+0 },
{ INT64_C(0x0001010010000004), 0x1.010010000004p+48, 0x0p+0 },
{ INT64_C(0xfffefeffeffffffb), -0x1.010010000005p+48, 0x0p+0 },
{ INT64_C(0x0001010010000040), 0x1.01001000004p+48, 0x0p+0 },
{ INT64_C(0xfffefeffefffffbf), -0x1.010010000041p+48, 0x0p+0 },
{ INT64_C(0x0001010010000100), 0x1.0100100001p+48, 0x0p+0 },
{ INT64_C(0xfffefeffeffffeff), -0x1.010010000101p+48, 0x0p+0 },
{ INT64_C(0x0001010010001000), 0x1.010010001p+48, 0x0p+0 },
{ INT64_C(0xfffefeffefffefff), -0x1.010010001001p+48, 0x0p+0 },
{ INT64_C(0x0001010010004000), 0x1.010010004p+48, 0x0p+0 },
{ INT64_C(0xfffefeffefffbfff), -0x1.010010004001p+48, 0x0p+0 },
{ INT64_C(0x0001010010008000), 0x1.010010008p+48, 0x0p+0 },
{ INT64_C(0xfffefeffefff7fff), -0x1.010010008001p+48, 0x0p+0 },
{ INT64_C(0x0001010010020000), 0x1.01001002p+48, 0x0p+0 },
{ INT64_C(0xfffefeffeffdffff), -0x1.010010020001p+48, 0x0p+0 },
{ INT64_C(0x0001010010040000), 0x1.01001004p+48, 0x0p+0 },
{ INT64_C(0xfffefeffeffbffff), -0x1.010010040001p+48, 0x0p+0 },
{ INT64_C(0x0001010010100000), 0x1.0100101p+48, 0x0p+0 },
{ INT64_C(0xfffefeffefefffff), -0x1.010010100001p+48, 0x0p+0 },
{ INT64_C(0x0001010011000000), 0x1.010011p+48, 0x0p+0 },
{ INT64_C(0xfffefeffeeffffff), -0x1.010011000001p+48, 0x0p+0 },
{ INT64_C(0x0001010014000000), 0x1.010014p+48, 0x0p+0 },
{ INT64_C(0xfffefeffebffffff), -0x1.010014000001p+48, 0x0p+0 },
{ INT64_C(0x0001010040000000), 0x1.01004p+48, 0x0p+0 },
{ INT64_C(0xfffefeffbfffffff), -0x1.010040000001p+48, 0x0p+0 },
{ INT64_C(0x0001010040000008), 0x1.010040000008p+48, 0x0p+0 },
{ INT64_C(0xfffefeffbffffff7), -0x1.010040000009p+48, 0x0p+0 },
{ INT64_C(0x0001010040000080), 0x1.01004000008p+48, 0x0p+0 },
{ INT64_C(0xfffefeffbfffff7f), -0x1.010040000081p+48, 0x0p+0 },
{ INT64_C(0x0001010040000800), 0x1.0100400008p+48, 0x0p+0 },
{ INT64_C(0xfffefeffbffff7ff), -0x1.010040000801p+48, 0x0p+0 },
{ INT64_C(0x0001010040002000), 0x1.010040002p+48, 0x0p+0 },
{ INT64_C(0xfffefeffbfffdfff), -0x1.010040002001p+48, 0x0p+0 },
{ INT64_C(0x0001010040008000), 0x1.010040008p+48, 0x0p+0 },
{ INT64_C(0xfffefeffbfff7fff), -0x1.010040008001p+48, 0x0p+0 },
{ INT64_C(0x0001010040080000), 0x1.01004008p+48, 0x0p+0 },
{ INT64_C(0xfffefeffbff7ffff), -0x1.010040080001p+48, 0x0p+0 },
{ INT64_C(0x0001010040800000), 0x1.0100408p+48, 0x0p+0 },
{ INT64_C(0xfffefeffbf7fffff), -0x1.010040800001p+48, 0x0p+0 },
{ INT64_C(0x0001010042000000), 0x1.010042p+48, 0x0p+0 },
{ INT64_C(0xfffefeffbdffffff), -0x1.010042000001p+48, 0x0p+0 },
{ INT64_C(0x0001010044000000), 0x1.010044p+48, 0x0p+0 },
{ INT64_C(0xfffefeffbbffffff), -0x1.010044000001p+48, 0x0p+0 },
{ INT64_C(0x0001010048000000), 0x1.010048p+48, 0x0p+0 },
{ INT64_C(0xfffefeffb7ffffff), -0x1.010048000001p+48, 0x0p+0 },
{ INT64_C(0x0001010100000000), 0x1.0101p+48, 0x0p+0 },
{ INT64_C(0xfffefefeffffffff), -0x1.010100000001p+48, 0x0p+0 },
{ INT64_C(0x0001010100000001), 0x1.010100000001p+48, 0x0p+0 },
{ INT64_C(0xfffefefefffffffe), -0x1.010100000002p+48, 0x0p+0 },
{ INT64_C(0x0001010100000004), 0x1.010100000004p+48, 0x0p+0 },
{ INT64_C(0xfffefefefffffffb), -0x1.010100000005p+48, 0x0p+0 },
{ INT64_C(0x0001010100000040), 0x1.01010000004p+48, 0x0p+0 },
{ INT64_C(0xfffefefeffffffbf), -0x1.010100000041p+48, 0x0p+0 },
{ INT64_C(0x0001010100000200), 0x1.0101000002p+48, 0x0p+0 },
{ INT64_C(0xfffefefefffffdff), -0x1.010100000201p+48, 0x0p+0 },
{ INT64_C(0x0001010100000400), 0x1.0101000004p+48, 0x0p+0 },
{ INT64_C(0xfffefefefffffbff), -0x1.010100000401p+48, 0x0p+0 },
{ INT64_C(0x0001010100000800), 0x1.0101000008p+48, 0x0p+0 },
{ INT64_C(0xfffefefefffff7ff), -0x1.010100000801p+48, 0x0p+0 },
{ INT64_C(0x0001010100001000), 0x1.010100001p+48, 0x0p+0 },
{ INT64_C(0xfffefefeffffefff), -0x1.010100001001p+48, 0x0p+0 },
{ INT64_C(0x0001010100010000), 0x1.01010001p+48, 0x0p+0 },
{ INT64_C(0xfffefefefffeffff), -0x1.010100010001p+48, 0x0p+0 },
{ INT64_C(0x0001010100020000), 0x1.01010002p+48, 0x0p+0 },
{ INT64_C(0xfffefefefffdffff), -0x1.010100020001p+48, 0x0p+0 },
{ INT64_C(0x0001010100100000), 0x1.0101001p+48, 0x0p+0 },
{ INT64_C(0xfffefefeffefffff), -0x1.010100100001p+48, 0x0p+0 },
{ INT64_C(0x0001010100400000), 0x1.0101004p+48, 0x0p+0 },
{ INT64_C(0xfffefefeffbfffff), -0x1.010100400001p+48, 0x0p+0 },
{ INT64_C(0x0001010100800000), 0x1.0101008p+48, 0x0p+0 },
{ INT64_C(0xfffefefeff7fffff), -0x1.010100800001p+48, 0x0p+0 },
{ INT64_C(0x0001010102000000), 0x1.010102p+48, 0x0p+0 },
{ INT64_C(0xfffefefefdffffff), -0x1.010102000001p+48, 0x0p+0 },
{ INT64_C(0x0001010120000000), 0x1.01012p+48, 0x0p+0 },
{ INT64_C(0xfffefefedfffffff), -0x1.010120000001p+48, 0x0p+0 },
{ INT64_C(0x0001010180000000), 0x1.01018p+48, 0x0p+0 },
{ INT64_C(0xfffefefe7fffffff), -0x1.010180000001p+48, 0x0p+0 },
{ INT64_C(0x0001010400000000), 0x1.0104p+48, 0x0p+0 },
{ INT64_C(0xfffefefbffffffff), -0x1.010400000001p+48, 0x0p+0 },
{ INT64_C(0x0001010400000004), 0x1.010400000004p+48, 0x0p+0 },
{ INT64_C(0xfffefefbfffffffb), -0x1.010400000005p+48, 0x0p+0 },
{ INT64_C(0x0001010400000010), 0x1.01040000001p+48, 0x0p+0 },
{ INT64_C(0xfffefefbffffffef), -0x1.010400000011p+48, 0x0p+0 },
{ INT64_C(0x0001010400000020), 0x1.01040000002p+48, 0x0p+0 },
{ INT64_C(0xfffefefbffffffdf), -0x1.010400000021p+48, 0x0p+0 },
{ INT64_C(0x0001010400000100), 0x1.0104000001p+48, 0x0p+0 },
{ INT64_C(0xfffefefbfffffeff), -0x1.010400000101p+48, 0x0p+0 },
{ INT64_C(0x0001010400000200), 0x1.0104000002p+48, 0x0p+0 },
{ INT64_C(0xfffefefbfffffdff), -0x1.010400000201p+48, 0x0p+0 },
{ INT64_C(0x0001010400001000), 0x1.010400001p+48, 0x0p+0 },
{ INT64_C(0xfffefefbffffefff), -0x1.010400001001p+48, 0x0p+0 },
{ INT64_C(0x0001010400004000), 0x1.010400004p+48, 0x0p+0 },
{ INT64_C(0xfffefefbffffbfff), -0x1.010400004001p+48, 0x0p+0 },
{ INT64_C(0x0001010400008000), 0x1.010400008p+48, 0x0p+0 },
{ INT64_C(0xfffefefbffff7fff), -0x1.010400008001p+48, 0x0p+0 },
{ INT64_C(0x0001010400010000), 0x1.01040001p+48, 0x0p+0 },
{ INT64_C(0xfffefefbfffeffff), -0x1.010400010001p+48, 0x0p+0 },
{ INT64_C(0x0001010400020000), 0x1.01040002p+48, 0x0p+0 },
{ INT64_C(0xfffefefbfffdffff), -0x1.010400020001p+48, 0x0p+0 },
{ INT64_C(0x0001010400100000), 0x1.0104001p+48, 0x0p+0 },
{ INT64_C(0xfffefefbffefffff), -0x1.010400100001p+48, 0x0p+0 },
{ INT64_C(0x0001010400200000), 0x1.0104002p+48, 0x0p+0 },
{ INT64_C(0xfffefefbffdfffff), -0x1.010400200001p+48, 0x0p+0 },
{ INT64_C(0x0001010400400000), 0x1.0104004p+48, 0x0p+0 },
{ INT64_C(0xfffefefbffbfffff), -0x1.010400400001p+48, 0x0p+0 },
{ INT64_C(0x0001010401000000), 0x1.010401p+48, 0x0p+0 },
{ INT64_C(0xfffefefbfeffffff), -0x1.010401000001p+48, 0x0p+0 },
{ INT64_C(0x0001010404000000), 0x1.010404p+48, 0x0p+0 },
{ INT64_C(0xfffefefbfbffffff), -0x1.010404000001p+48, 0x0p+0 },
{ INT64_C(0x0001010410000000), 0x1.01041p+48, 0x0p+0 },
{ INT64_C(0xfffefefbefffffff), -0x1.010410000001p+48, 0x0p+0 },
{ INT64_C(0x0001010480000000), 0x1.01048p+48, 0x0p+0 },
{ INT64_C(0xfffefefb7fffffff), -0x1.010480000001p+48, 0x0p+0 },
{ INT64_C(0x0001010600000000), 0x1.0106p+48, 0x0p+0 },
{ INT64_C(0xfffefef9ffffffff), -0x1.010600000001p+48, 0x0p+0 },
{ INT64_C(0x0001010800000000), 0x1.0108p+48, 0x0p+0 },
{ INT64_C(0xfffefef7ffffffff), -0x1.010800000001p+48, 0x0p+0 },
{ INT64_C(0x0001010800000001), 0x1.010800000001p+48, 0x0p+0 },
{ INT64_C(0xfffefef7fffffffe), -0x1.010800000002p+48, 0x0p+0 },
{ INT64_C(0x0001010800000004), 0x1.010800000004p+48, 0x0p+0 },
{ INT64_C(0xfffefef7fffffffb), -0x1.010800000005p+48, 0x0p+0 },
{ INT64_C(0x0001010800000020), 0x1.01080000002p+48, 0x0p+0 },
{ INT64_C(0xfffefef7ffffffdf), -0x1.010800000021p+48, 0x0p+0 },
{ INT64_C(0x0001010800000100), 0x1.0108000001p+48, 0x0p+0 },
{ INT64_C(0xfffefef7fffffeff), -0x1.010800000101p+48, 0x0p+0 },
{ INT64_C(0x0001010800000800), 0x1.0108000008p+48, 0x0p+0 },
{ INT64_C(0xfffefef7fffff7ff), -0x1.010800000801p+48, 0x0p+0 },
{ INT64_C(0x0001010800002000), 0x1.010800002p+48, 0x0p+0 },
{ INT64_C(0xfffefef7ffffdfff), -0x1.010800002001p+48, 0x0p+0 },
{ INT64_C(0x0001010800004000), 0x1.010800004p+48, 0x0p+0 },
{ INT64_C(0xfffefef7ffffbfff), -0x1.010800004001p+48, 0x0p+0 },
{ INT64_C(0x0001010800020000), 0x1.01080002p+48, 0x0p+0 },
{ INT64_C(0xfffefef7fffdffff), -0x1.010800020001p+48, 0x0p+0 },
{ INT64_C(0x0001010800200000), 0x1.0108002p+48, 0x0p+0 },
{ INT64_C(0xfffefef7ffdfffff), -0x1.010800200001p+48, 0x0p+0 },
{ INT64_C(0x0001010800800000), 0x1.0108008p+48, 0x0p+0 },
{ INT64_C(0xfffefef7ff7fffff), -0x1.010800800001p+48, 0x0p+0 },
{ INT64_C(0x0001010808000000), 0x1.010808p+48, 0x0p+0 },
{ INT64_C(0xfffefef7f7ffffff), -0x1.010808000001p+48, 0x0p+0 },
{ INT64_C(0x0001010880000000), 0x1.01088p+48, 0x0p+0 },
{ INT64_C(0xfffefef77fffffff), -0x1.010880000001p+48, 0x0p+0 },
{ INT64_C(0x0001010a00000000), 0x1.010ap+48, 0x0p+0 },
{ INT64_C(0xfffefef5ffffffff), -0x1.010a00000001p+48, 0x0p+0 },
{ INT64_C(0x0001011000000000), 0x1.011p+48, 0x0p+0 },
{ INT64_C(0xfffefeefffffffff), -0x1.011000000001p+48, 0x0p+0 },
{ INT64_C(0x0001011000000004), 0x1.011000000004p+48, 0x0p+0 },
{ INT64_C(0xfffefeeffffffffb), -0x1.011000000005p+48, 0x0p+0 },
{ INT64_C(0x0001011000000010), 0x1.01100000001p+48, 0x0p+0 },
{ INT64_C(0xfffefeefffffffef), -0x1.011000000011p+48, 0x0p+0 },
{ INT64_C(0x0001011000000040), 0x1.01100000004p+48, 0x0p+0 },
{ INT64_C(0xfffefeefffffffbf), -0x1.011000000041p+48, 0x0p+0 },
{ INT64_C(0x0001011000000400), 0x1.0110000004p+48, 0x0p+0 },
{ INT64_C(0xfffefeeffffffbff), -0x1.011000000401p+48, 0x0p+0 },
{ INT64_C(0x0001011000001000), 0x1.011000001p+48, 0x0p+0 },
{ INT64_C(0xfffefeefffffefff), -0x1.011000001001p+48, 0x0p+0 },
{ INT64_C(0x0001011000008000), 0x1.011000008p+48, 0x0p+0 },
{ INT64_C(0xfffefeefffff7fff), -0x1.011000008001p+48, 0x0p+0 },
{ INT64_C(0x0001011000040000), 0x1.01100004p+48, 0x0p+0 },
{ INT64_C(0xfffefeeffffbffff), -0x1.011000040001p+48, 0x0p+0 },
{ INT64_C(0x0001011000100000), 0x1.0110001p+48, 0x0p+0 },
{ INT64_C(0xfffefeefffefffff), -0x1.011000100001p+48, 0x0p+0 },
{ INT64_C(0x0001011001000000), 0x1.011001p+48, 0x0p+0 },
{ INT64_C(0xfffefeeffeffffff), -0x1.011001000001p+48, 0x0p+0 },
{ INT64_C(0x0001011004000000), 0x1.011004p+48, 0x0p+0 },
{ INT64_C(0xfffefeeffbffffff), -0x1.011004000001p+48, 0x0p+0 },
{ INT64_C(0x0001011008000000), 0x1.011008p+48, 0x0p+0 },
{ INT64_C(0xfffefeeff7ffffff), -0x1.011008000001p+48, 0x0p+0 },
{ INT64_C(0x0001011010000000), 0x1.01101p+48, 0x0p+0 },
{ INT64_C(0xfffefeefefffffff), -0x1.011010000001p+48, 0x0p+0 },
{ INT64_C(0x0001011040000000), 0x1.01104p+48, 0x0p+0 },
{ INT64_C(0xfffefeefbfffffff), -0x1.011040000001p+48, 0x0p+0 },
{ INT64_C(0x0001011400000000), 0x1.0114p+48, 0x0p+0 },
{ INT64_C(0xfffefeebffffffff), -0x1.011400000001p+48, 0x0p+0 },
{ INT64_C(0x0001020000000002), 0x1.020000000002p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffffd), -0x1.020000000003p+48, 0x0p+0 },
{ INT64_C(0x0001020000000003), 0x1.020000000003p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffffc), -0x1.020000000004p+48, 0x0p+0 },
{ INT64_C(0x0001020000000008), 0x1.020000000008p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffff7), -0x1.020000000009p+48, 0x0p+0 },
{ INT64_C(0x0001020000000009), 0x1.020000000009p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffff6), -0x1.02000000000ap+48, 0x0p+0 },
{ INT64_C(0x0001020000000040), 0x1.02000000004p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffffbf), -0x1.020000000041p+48, 0x0p+0 },
{ INT64_C(0x0001020000000044), 0x1.020000000044p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffffbb), -0x1.020000000045p+48, 0x0p+0 },
{ INT64_C(0x0001020000000048), 0x1.020000000048p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffffb7), -0x1.020000000049p+48, 0x0p+0 },
{ INT64_C(0x0001020000000060), 0x1.02000000006p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffff9f), -0x1.020000000061p+48, 0x0p+0 },
{ INT64_C(0x0001020000000080), 0x1.02000000008p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffff7f), -0x1.020000000081p+48, 0x0p+0 },
{ INT64_C(0x0001020000000084), 0x1.020000000084p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffff7b), -0x1.020000000085p+48, 0x0p+0 },
{ INT64_C(0x00010200000000a0), 0x1.0200000000ap+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffff5f), -0x1.0200000000a1p+48, 0x0p+0 },
{ INT64_C(0x0001020000000100), 0x1.0200000001p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffeff), -0x1.020000000101p+48, 0x0p+0 },
{ INT64_C(0x0001020000000101), 0x1.020000000101p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffefe), -0x1.020000000102p+48, 0x0p+0 },
{ INT64_C(0x0001020000000102), 0x1.020000000102p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffefd), -0x1.020000000103p+48, 0x0p+0 },
{ INT64_C(0x0001020000000108), 0x1.020000000108p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffef7), -0x1.020000000109p+48, 0x0p+0 },
{ INT64_C(0x0001020000000110), 0x1.02000000011p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffeef), -0x1.020000000111p+48, 0x0p+0 },
{ INT64_C(0x0001020000000180), 0x1.02000000018p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffe7f), -0x1.020000000181p+48, 0x0p+0 },
{ INT64_C(0x0001020000000200), 0x1.0200000002p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffdff), -0x1.020000000201p+48, 0x0p+0 },
{ INT64_C(0x0001020000000201), 0x1.020000000201p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffdfe), -0x1.020000000202p+48, 0x0p+0 },
{ INT64_C(0x0001020000000208), 0x1.020000000208p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffdf7), -0x1.020000000209p+48, 0x0p+0 },
{ INT64_C(0x0001020000000240), 0x1.02000000024p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffffdbf), -0x1.020000000241p+48, 0x0p+0 },
{ INT64_C(0x0001020000002000), 0x1.020000002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffdfff), -0x1.020000002001p+48, 0x0p+0 },
{ INT64_C(0x0001020000002002), 0x1.020000002002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffdffd), -0x1.020000002003p+48, 0x0p+0 },
{ INT64_C(0x0001020000002020), 0x1.02000000202p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffdfdf), -0x1.020000002021p+48, 0x0p+0 },
{ INT64_C(0x0001020000002080), 0x1.02000000208p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffdf7f), -0x1.020000002081p+48, 0x0p+0 },
{ INT64_C(0x0001020000002100), 0x1.0200000021p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffdeff), -0x1.020000002101p+48, 0x0p+0 },
{ INT64_C(0x0001020000003000), 0x1.020000003p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffffcfff), -0x1.020000003001p+48, 0x0p+0 },
{ INT64_C(0x0001020000010000), 0x1.02000001p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffeffff), -0x1.020000010001p+48, 0x0p+0 },
{ INT64_C(0x0001020000010002), 0x1.020000010002p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffefffd), -0x1.020000010003p+48, 0x0p+0 },
{ INT64_C(0x0001020000010004), 0x1.020000010004p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffefffb), -0x1.020000010005p+48, 0x0p+0 },
{ INT64_C(0x0001020000010010), 0x1.02000001001p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffeffef), -0x1.020000010011p+48, 0x0p+0 },
{ INT64_C(0x0001020000010040), 0x1.02000001004p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffeffbf), -0x1.020000010041p+48, 0x0p+0 },
{ INT64_C(0x0001020000010080), 0x1.02000001008p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffeff7f), -0x1.020000010081p+48, 0x0p+0 },
{ INT64_C(0x0001020000010400), 0x1.0200000104p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffefbff), -0x1.020000010401p+48, 0x0p+0 },
{ INT64_C(0x0001020000011000), 0x1.020000011p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffffeefff), -0x1.020000011001p+48, 0x0p+0 },
{ INT64_C(0x0001020000100000), 0x1.0200001p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffefffff), -0x1.020000100001p+48, 0x0p+0 },
{ INT64_C(0x0001020000100002), 0x1.020000100002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffeffffd), -0x1.020000100003p+48, 0x0p+0 },
{ INT64_C(0x0001020000100010), 0x1.02000010001p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffefffef), -0x1.020000100011p+48, 0x0p+0 },
{ INT64_C(0x0001020000100080), 0x1.02000010008p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffefff7f), -0x1.020000100081p+48, 0x0p+0 },
{ INT64_C(0x0001020000100400), 0x1.0200001004p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffeffbff), -0x1.020000100401p+48, 0x0p+0 },
{ INT64_C(0x0001020000104000), 0x1.020000104p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffefbfff), -0x1.020000104001p+48, 0x0p+0 },
{ INT64_C(0x0001020000120000), 0x1.02000012p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffedffff), -0x1.020000120001p+48, 0x0p+0 },
{ INT64_C(0x0001020000140000), 0x1.02000014p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffebffff), -0x1.020000140001p+48, 0x0p+0 },
{ INT64_C(0x0001020000200000), 0x1.0200002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffdfffff), -0x1.020000200001p+48, 0x0p+0 },
{ INT64_C(0x0001020000200001), 0x1.020000200001p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffdffffe), -0x1.020000200002p+48, 0x0p+0 },
{ INT64_C(0x0001020000200004), 0x1.020000200004p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffdffffb), -0x1.020000200005p+48, 0x0p+0 },
{ INT64_C(0x0001020000200020), 0x1.02000020002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffdfffdf), -0x1.020000200021p+48, 0x0p+0 },
{ INT64_C(0x0001020000200100), 0x1.0200002001p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffdffeff), -0x1.020000200101p+48, 0x0p+0 },
{ INT64_C(0x0001020000200200), 0x1.0200002002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffdffdff), -0x1.020000200201p+48, 0x0p+0 },
{ INT64_C(0x0001020000200400), 0x1.0200002004p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffdffbff), -0x1.020000200401p+48, 0x0p+0 },
{ INT64_C(0x0001020000202000), 0x1.020000202p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffdfdfff), -0x1.020000202001p+48, 0x0p+0 },
{ INT64_C(0x0001020000210000), 0x1.02000021p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffdeffff), -0x1.020000210001p+48, 0x0p+0 },
{ INT64_C(0x0001020000240000), 0x1.02000024p+48, 0x0p+0 },
{ INT64_C(0xfffefdffffdbffff), -0x1.020000240001p+48, 0x0p+0 },
{ INT64_C(0x0001020002000000), 0x1.020002p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffdffffff), -0x1.020002000001p+48, 0x0p+0 },
{ INT64_C(0x0001020002000004), 0x1.020002000004p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffdfffffb), -0x1.020002000005p+48, 0x0p+0 },
{ INT64_C(0x0001020002000010), 0x1.02000200001p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffdffffef), -0x1.020002000011p+48, 0x0p+0 },
{ INT64_C(0x0001020002000040), 0x1.02000200004p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffdffffbf), -0x1.020002000041p+48, 0x0p+0 },
{ INT64_C(0x0001020002000080), 0x1.02000200008p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffdffff7f), -0x1.020002000081p+48, 0x0p+0 },
{ INT64_C(0x0001020002000100), 0x1.0200020001p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffdfffeff), -0x1.020002000101p+48, 0x0p+0 },
{ INT64_C(0x0001020002000400), 0x1.0200020004p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffdfffbff), -0x1.020002000401p+48, 0x0p+0 },
{ INT64_C(0x0001020002000800), 0x1.0200020008p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffdfff7ff), -0x1.020002000801p+48, 0x0p+0 },
{ INT64_C(0x0001020002002000), 0x1.020002002p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffdffdfff), -0x1.020002002001p+48, 0x0p+0 },
{ INT64_C(0x0001020002008000), 0x1.020002008p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffdff7fff), -0x1.020002008001p+48, 0x0p+0 },
{ INT64_C(0x0001020002080000), 0x1.02000208p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffdf7ffff), -0x1.020002080001p+48, 0x0p+0 },
{ INT64_C(0x0001020002800000), 0x1.0200028p+48, 0x0p+0 },
{ INT64_C(0xfffefdfffd7fffff), -0x1.020002800001p+48, 0x0p+0 },
{ INT64_C(0x0001020020000000), 0x1.02002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdfffffff), -0x1.020020000001p+48, 0x0p+0 },
{ INT64_C(0x0001020020000002), 0x1.020020000002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdffffffd), -0x1.020020000003p+48, 0x0p+0 },
{ INT64_C(0x0001020020000004), 0x1.020020000004p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdffffffb), -0x1.020020000005p+48, 0x0p+0 },
{ INT64_C(0x0001020020000010), 0x1.02002000001p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdfffffef), -0x1.020020000011p+48, 0x0p+0 },
{ INT64_C(0x0001020020000040), 0x1.02002000004p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdfffffbf), -0x1.020020000041p+48, 0x0p+0 },
{ INT64_C(0x0001020020000200), 0x1.0200200002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdffffdff), -0x1.020020000201p+48, 0x0p+0 },
{ INT64_C(0x0001020020000400), 0x1.0200200004p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdffffbff), -0x1.020020000401p+48, 0x0p+0 },
{ INT64_C(0x0001020020004000), 0x1.020020004p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdfffbfff), -0x1.020020004001p+48, 0x0p+0 },
{ INT64_C(0x0001020020008000), 0x1.020020008p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdfff7fff), -0x1.020020008001p+48, 0x0p+0 },
{ INT64_C(0x0001020020010000), 0x1.02002001p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdffeffff), -0x1.020020010001p+48, 0x0p+0 },
{ INT64_C(0x0001020020020000), 0x1.02002002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdffdffff), -0x1.020020020001p+48, 0x0p+0 },
{ INT64_C(0x0001020020200000), 0x1.0200202p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdfdfffff), -0x1.020020200001p+48, 0x0p+0 },
{ INT64_C(0x0001020021000000), 0x1.020021p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdeffffff), -0x1.020021000001p+48, 0x0p+0 },
{ INT64_C(0x0001020024000000), 0x1.020024p+48, 0x0p+0 },
{ INT64_C(0xfffefdffdbffffff), -0x1.020024000001p+48, 0x0p+0 },
{ INT64_C(0x0001020030000000), 0x1.02003p+48, 0x0p+0 },
{ INT64_C(0xfffefdffcfffffff), -0x1.020030000001p+48, 0x0p+0 },
{ INT64_C(0x0001020040000000), 0x1.02004p+48, 0x0p+0 },
{ INT64_C(0xfffefdffbfffffff), -0x1.020040000001p+48, 0x0p+0 },
{ INT64_C(0x0001020040000002), 0x1.020040000002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffbffffffd), -0x1.020040000003p+48, 0x0p+0 },
{ INT64_C(0x0001020040000020), 0x1.02004000002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffbfffffdf), -0x1.020040000021p+48, 0x0p+0 },
{ INT64_C(0x0001020040000200), 0x1.0200400002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffbffffdff), -0x1.020040000201p+48, 0x0p+0 },
{ INT64_C(0x0001020040002000), 0x1.020040002p+48, 0x0p+0 },
{ INT64_C(0xfffefdffbfffdfff), -0x1.020040002001p+48, 0x0p+0 },
{ INT64_C(0x0001020040008000), 0x1.020040008p+48, 0x0p+0 },
{ INT64_C(0xfffefdffbfff7fff), -0x1.020040008001p+48, 0x0p+0 },
{ INT64_C(0x0001020040040000), 0x1.02004004p+48, 0x0p+0 },
{ INT64_C(0xfffefdffbffbffff), -0x1.020040040001p+48, 0x0p+0 },
{ INT64_C(0x0001020040080000), 0x1.02004008p+48, 0x0p+0 },
{ INT64_C(0xfffefdffbff7ffff), -0x1.020040080001p+48, 0x0p+0 },
{ INT64_C(0x0001020040100000), 0x1.0200401p+48, 0x0p+0 },
{ INT64_C(0xfffefdffbfefffff), -0x1.020040100001p+48, 0x0p+0 },
{ INT64_C(0x0001020040200000), 0x1.0200402p+48, 0x0p+0 },
{ INT64_C(0xfffefdffbfdfffff), -0x1.020040200001p+48, 0x0p+0 },
{ INT64_C(0x0001020041000000), 0x1.020041p+48, 0x0p+0 },
{ INT64_C(0xfffefdffbeffffff), -0x1.020041000001p+48, 0x0p+0 },
{ INT64_C(0x0001020048000000), 0x1.020048p+48, 0x0p+0 },
{ INT64_C(0xfffefdffb7ffffff), -0x1.020048000001p+48, 0x0p+0 },
{ INT64_C(0x0001020200000000), 0x1.0202p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdffffffff), -0x1.020200000001p+48, 0x0p+0 },
{ INT64_C(0x0001020200000004), 0x1.020200000004p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdfffffffb), -0x1.020200000005p+48, 0x0p+0 },
{ INT64_C(0x0001020200000020), 0x1.02020000002p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdffffffdf), -0x1.020200000021p+48, 0x0p+0 },
{ INT64_C(0x0001020200000080), 0x1.02020000008p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdffffff7f), -0x1.020200000081p+48, 0x0p+0 },
{ INT64_C(0x0001020200000200), 0x1.0202000002p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdfffffdff), -0x1.020200000201p+48, 0x0p+0 },
{ INT64_C(0x0001020200000400), 0x1.0202000004p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdfffffbff), -0x1.020200000401p+48, 0x0p+0 },
{ INT64_C(0x0001020200001000), 0x1.020200001p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdffffefff), -0x1.020200001001p+48, 0x0p+0 },
{ INT64_C(0x0001020200010000), 0x1.02020001p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdfffeffff), -0x1.020200010001p+48, 0x0p+0 },
{ INT64_C(0x0001020200100000), 0x1.0202001p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdffefffff), -0x1.020200100001p+48, 0x0p+0 },
{ INT64_C(0x0001020200400000), 0x1.0202004p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdffbfffff), -0x1.020200400001p+48, 0x0p+0 },
{ INT64_C(0x0001020200800000), 0x1.0202008p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdff7fffff), -0x1.020200800001p+48, 0x0p+0 },
{ INT64_C(0x0001020204000000), 0x1.020204p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdfbffffff), -0x1.020204000001p+48, 0x0p+0 },
{ INT64_C(0x0001020240000000), 0x1.02024p+48, 0x0p+0 },
{ INT64_C(0xfffefdfdbfffffff), -0x1.020240000001p+48, 0x0p+0 },
{ INT64_C(0x0001020300000000), 0x1.0203p+48, 0x0p+0 },
{ INT64_C(0xfffefdfcffffffff), -0x1.020300000001p+48, 0x0p+0 },
{ INT64_C(0x0001020400000000), 0x1.0204p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbffffffff), -0x1.020400000001p+48, 0x0p+0 },
{ INT64_C(0x0001020400000001), 0x1.020400000001p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbfffffffe), -0x1.020400000002p+48, 0x0p+0 },
{ INT64_C(0x0001020400000004), 0x1.020400000004p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbfffffffb), -0x1.020400000005p+48, 0x0p+0 },
{ INT64_C(0x0001020400000008), 0x1.020400000008p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbfffffff7), -0x1.020400000009p+48, 0x0p+0 },
{ INT64_C(0x0001020400000020), 0x1.02040000002p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbffffffdf), -0x1.020400000021p+48, 0x0p+0 },
{ INT64_C(0x0001020400000200), 0x1.0204000002p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbfffffdff), -0x1.020400000201p+48, 0x0p+0 },
{ INT64_C(0x0001020400000400), 0x1.0204000004p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbfffffbff), -0x1.020400000401p+48, 0x0p+0 },
{ INT64_C(0x0001020400004000), 0x1.020400004p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbffffbfff), -0x1.020400004001p+48, 0x0p+0 },
{ INT64_C(0x0001020400010000), 0x1.02040001p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbfffeffff), -0x1.020400010001p+48, 0x0p+0 },
{ INT64_C(0x0001020400040000), 0x1.02040004p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbfffbffff), -0x1.020400040001p+48, 0x0p+0 },
{ INT64_C(0x0001020400200000), 0x1.0204002p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbffdfffff), -0x1.020400200001p+48, 0x0p+0 },
{ INT64_C(0x0001020402000000), 0x1.020402p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbfdffffff), -0x1.020402000001p+48, 0x0p+0 },
{ INT64_C(0x0001020408000000), 0x1.020408p+48, 0x0p+0 },
{ INT64_C(0xfffefdfbf7ffffff), -0x1.020408000001p+48, 0x0p+0 },
{ INT64_C(0x0001020480000000), 0x1.02048p+48, 0x0p+0 },
{ INT64_C(0xfffefdfb7fffffff), -0x1.020480000001p+48, 0x0p+0 },
{ INT64_C(0x0001020500000000), 0x1.0205p+48, 0x0p+0 },
{ INT64_C(0xfffefdfaffffffff), -0x1.020500000001p+48, 0x0p+0 },
{ INT64_C(0x0001021000000000), 0x1.021p+48, 0x0p+0 },
{ INT64_C(0xfffefdefffffffff), -0x1.021000000001p+48, 0x0p+0 },
{ INT64_C(0x0001021000000008), 0x1.021000000008p+48, 0x0p+0 },
{ INT64_C(0xfffefdeffffffff7), -0x1.021000000009p+48, 0x0p+0 },
{ INT64_C(0x0001021000000040), 0x1.02100000004p+48, 0x0p+0 },
{ INT64_C(0xfffefdefffffffbf), -0x1.021000000041p+48, 0x0p+0 },
{ INT64_C(0x0001021000000200), 0x1.0210000002p+48, 0x0p+0 },
{ INT64_C(0xfffefdeffffffdff), -0x1.021000000201p+48, 0x0p+0 },
{ INT64_C(0x0001021000002000), 0x1.021000002p+48, 0x0p+0 },
{ INT64_C(0xfffefdefffffdfff), -0x1.021000002001p+48, 0x0p+0 },
{ INT64_C(0x0001021000010000), 0x1.02100001p+48, 0x0p+0 },
{ INT64_C(0xfffefdeffffeffff), -0x1.021000010001p+48, 0x0p+0 },
{ INT64_C(0x0001021000020000), 0x1.02100002p+48, 0x0p+0 },
{ INT64_C(0xfffefdeffffdffff), -0x1.021000020001p+48, 0x0p+0 },
{ INT64_C(0x0001021000100000), 0x1.0210001p+48, 0x0p+0 },
{ INT64_C(0xfffefdefffefffff), -0x1.021000100001p+48, 0x0p+0 },
{ INT64_C(0x0001021000800000), 0x1.0210008p+48, 0x0p+0 },
{ INT64_C(0xfffefdefff7fffff), -0x1.021000800001p+48, 0x0p+0 },
{ INT64_C(0x0001021008000000), 0x1.021008p+48, 0x0p+0 },
{ INT64_C(0xfffefdeff7ffffff), -0x1.021008000001p+48, 0x0p+0 },
{ INT64_C(0x0001021040000000), 0x1.02104p+48, 0x0p+0 },
{ INT64_C(0xfffefdefbfffffff), -0x1.021040000001p+48, 0x0p+0 },
{ INT64_C(0x0001021100000000), 0x1.0211p+48, 0x0p+0 },
{ INT64_C(0xfffefdeeffffffff), -0x1.021100000001p+48, 0x0p+0 },
{ INT64_C(0x0001022000000000), 0x1.022p+48, 0x0p+0 },
{ INT64_C(0xfffefddfffffffff), -0x1.022000000001p+48, 0x0p+0 },
{ INT64_C(0x0001022000000002), 0x1.022000000002p+48, 0x0p+0 },
{ INT64_C(0xfffefddffffffffd), -0x1.022000000003p+48, 0x0p+0 },
{ INT64_C(0x0001022000000004), 0x1.022000000004p+48, 0x0p+0 },
{ INT64_C(0xfffefddffffffffb), -0x1.022000000005p+48, 0x0p+0 },
{ INT64_C(0x0001022000000008), 0x1.022000000008p+48, 0x0p+0 },
{ INT64_C(0xfffefddffffffff7), -0x1.022000000009p+48, 0x0p+0 },
{ INT64_C(0x0001022000000020), 0x1.02200000002p+48, 0x0p+0 },
{ INT64_C(0xfffefddfffffffdf), -0x1.022000000021p+48, 0x0p+0 },
{ INT64_C(0x0001022000000100), 0x1.0220000001p+48, 0x0p+0 },
{ INT64_C(0xfffefddffffffeff), -0x1.022000000101p+48, 0x0p+0 },
{ INT64_C(0x0001022000000400), 0x1.0220000004p+48, 0x0p+0 },
{ INT64_C(0xfffefddffffffbff), -0x1.022000000401p+48, 0x0p+0 },
{ INT64_C(0x0001022000000800), 0x1.0220000008p+48, 0x0p+0 },
{ INT64_C(0xfffefddffffff7ff), -0x1.022000000801p+48, 0x0p+0 },
{ INT64_C(0x0001022000002000), 0x1.022000002p+48, 0x0p+0 },
{ INT64_C(0xfffefddfffffdfff), -0x1.022000002001p+48, 0x0p+0 },
{ INT64_C(0x0001022000008000), 0x1.022000008p+48, 0x0p+0 },
{ INT64_C(0xfffefddfffff7fff), -0x1.022000008001p+48, 0x0p+0 },
{ INT64_C(0x0001022000040000), 0x1.02200004p+48, 0x0p+0 },
{ INT64_C(0xfffefddffffbffff), -0x1.022000040001p+48, 0x0p+0 },
{ INT64_C(0x0001022000200000), 0x1.0220002p+48, 0x0p+0 },
{ INT64_C(0xfffefddfffdfffff), -0x1.022000200001p+48, 0x0p+0 },
{ INT64_C(0x0001022000800000), 0x1.0220008p+48, 0x0p+0 },
{ INT64_C(0xfffefddfff7fffff), -0x1.022000800001p+48, 0x0p+0 },
{ INT64_C(0x0001022008000000), 0x1.022008p+48, 0x0p+0 },
{ INT64_C(0xfffefddff7ffffff), -0x1.022008000001p+48, 0x0p+0 },
{ INT64_C(0x0001022040000000), 0x1.02204p+48, 0x0p+0 },
{ INT64_C(0xfffefddfbfffffff), -0x1.022040000001p+48, 0x0p+0 },
{ INT64_C(0x0001022400000000), 0x1.0224p+48, 0x0p+0 },
{ INT64_C(0xfffefddbffffffff), -0x1.022400000001p+48, 0x0p+0 },
{ INT64_C(0x0001022800000000), 0x1.0228p+48, 0x0p+0 },
{ INT64_C(0xfffefdd7ffffffff), -0x1.022800000001p+48, 0x0p+0 },
{ INT64_C(0x0001028000000000), 0x1.028p+48, 0x0p+0 },
{ INT64_C(0xfffefd7fffffffff), -0x1.028000000001p+48, 0x0p+0 },
{ INT64_C(0x0001028000000008), 0x1.028000000008p+48, 0x0p+0 },
{ INT64_C(0xfffefd7ffffffff7), -0x1.028000000009p+48, 0x0p+0 },
{ INT64_C(0x0001028000000080), 0x1.02800000008p+48, 0x0p+0 },
{ INT64_C(0xfffefd7fffffff7f), -0x1.028000000081p+48, 0x0p+0 },
{ INT64_C(0x0001028000000800), 0x1.0280000008p+48, 0x0p+0 },
{ INT64_C(0xfffefd7ffffff7ff), -0x1.028000000801p+48, 0x0p+0 },
{ INT64_C(0x0001028000004000), 0x1.028000004p+48, 0x0p+0 },
{ INT64_C(0xfffefd7fffffbfff), -0x1.028000004001p+48, 0x0p+0 },
{ INT64_C(0x0001028000020000), 0x1.02800002p+48, 0x0p+0 },
{ INT64_C(0xfffefd7ffffdffff), -0x1.028000020001p+48, 0x0p+0 },
{ INT64_C(0x0001028000080000), 0x1.02800008p+48, 0x0p+0 },
{ INT64_C(0xfffefd7ffff7ffff), -0x1.028000080001p+48, 0x0p+0 },
{ INT64_C(0x0001028000800000), 0x1.0280008p+48, 0x0p+0 },
{ INT64_C(0xfffefd7fff7fffff), -0x1.028000800001p+48, 0x0p+0 },
{ INT64_C(0x0001028002000000), 0x1.028002p+48, 0x0p+0 },
{ INT64_C(0xfffefd7ffdffffff), -0x1.028002000001p+48, 0x0p+0 },
{ INT64_C(0x0001028010000000), 0x1.02801p+48, 0x0p+0 },
{ INT64_C(0xfffefd7fefffffff), -0x1.028010000001p+48, 0x0p+0 },
{ INT64_C(0x0001028080000000), 0x1.02808p+48, 0x0p+0 },
{ INT64_C(0xfffefd7f7fffffff), -0x1.028080000001p+48, 0x0p+0 },
{ INT64_C(0x0001028200000000), 0x1.0282p+48, 0x0p+0 },
{ INT64_C(0xfffefd7dffffffff), -0x1.028200000001p+48, 0x0p+0 },
{ INT64_C(0x0001028400000000), 0x1.0284p+48, 0x0p+0 },
{ INT64_C(0xfffefd7bffffffff), -0x1.028400000001p+48, 0x0p+0 },
{ INT64_C(0x0001029000000000), 0x1.029p+48, 0x0p+0 },
{ INT64_C(0xfffefd6fffffffff), -0x1.029000000001p+48, 0x0p+0 },
{ INT64_C(0x0001040000000001), 0x1.040000000001p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffffffe), -0x1.040000000002p+48, 0x0p+0 },
{ INT64_C(0x0001040000000008), 0x1.040000000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffffff7), -0x1.040000000009p+48, 0x0p+0 },
{ INT64_C(0x000104000000000a), 0x1.04000000000ap+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffffff5), -0x1.04000000000bp+48, 0x0p+0 },
{ INT64_C(0x000104000000000c), 0x1.04000000000cp+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffffff3), -0x1.04000000000dp+48, 0x0p+0 },
{ INT64_C(0x0001040000000040), 0x1.04000000004p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffffffbf), -0x1.040000000041p+48, 0x0p+0 },
{ INT64_C(0x0001040000000044), 0x1.040000000044p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffffffbb), -0x1.040000000045p+48, 0x0p+0 },
{ INT64_C(0x0001040000000200), 0x1.0400000002p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffffdff), -0x1.040000000201p+48, 0x0p+0 },
{ INT64_C(0x0001040000000208), 0x1.040000000208p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffffdf7), -0x1.040000000209p+48, 0x0p+0 },
{ INT64_C(0x0001040000000280), 0x1.04000000028p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffffd7f), -0x1.040000000281p+48, 0x0p+0 },
{ INT64_C(0x0001040000000800), 0x1.0400000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffff7ff), -0x1.040000000801p+48, 0x0p+0 },
{ INT64_C(0x0001040000000808), 0x1.040000000808p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffff7f7), -0x1.040000000809p+48, 0x0p+0 },
{ INT64_C(0x0001040000000810), 0x1.04000000081p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffff7ef), -0x1.040000000811p+48, 0x0p+0 },
{ INT64_C(0x0001040000000820), 0x1.04000000082p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffff7df), -0x1.040000000821p+48, 0x0p+0 },
{ INT64_C(0x0001040000000900), 0x1.0400000009p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffff6ff), -0x1.040000000901p+48, 0x0p+0 },
{ INT64_C(0x0001040000008000), 0x1.040000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffff7fff), -0x1.040000008001p+48, 0x0p+0 },
{ INT64_C(0x0001040000008008), 0x1.040000008008p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffff7ff7), -0x1.040000008009p+48, 0x0p+0 },
{ INT64_C(0x0001040000008010), 0x1.04000000801p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffff7fef), -0x1.040000008011p+48, 0x0p+0 },
{ INT64_C(0x0001040000008100), 0x1.0400000081p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffff7eff), -0x1.040000008101p+48, 0x0p+0 },
{ INT64_C(0x0001040000008200), 0x1.0400000082p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffff7dff), -0x1.040000008201p+48, 0x0p+0 },
{ INT64_C(0x0001040000009000), 0x1.040000009p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffff6fff), -0x1.040000009001p+48, 0x0p+0 },
{ INT64_C(0x000104000000a000), 0x1.04000000ap+48, 0x0p+0 },
{ INT64_C(0xfffefbffffff5fff), -0x1.04000000a001p+48, 0x0p+0 },
{ INT64_C(0x000104000000c000), 0x1.04000000cp+48, 0x0p+0 },
{ INT64_C(0xfffefbffffff3fff), -0x1.04000000c001p+48, 0x0p+0 },
{ INT64_C(0x0001040000040000), 0x1.04000004p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffbffff), -0x1.040000040001p+48, 0x0p+0 },
{ INT64_C(0x0001040000040004), 0x1.040000040004p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffbfffb), -0x1.040000040005p+48, 0x0p+0 },
{ INT64_C(0x0001040000040008), 0x1.040000040008p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffbfff7), -0x1.040000040009p+48, 0x0p+0 },
{ INT64_C(0x0001040000040040), 0x1.04000004004p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffbffbf), -0x1.040000040041p+48, 0x0p+0 },
{ INT64_C(0x0001040000040100), 0x1.0400000401p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffbfeff), -0x1.040000040101p+48, 0x0p+0 },
{ INT64_C(0x0001040000040800), 0x1.0400000408p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffbf7ff), -0x1.040000040801p+48, 0x0p+0 },
{ INT64_C(0x0001040000048000), 0x1.040000048p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffffb7fff), -0x1.040000048001p+48, 0x0p+0 },
{ INT64_C(0x0001040000060000), 0x1.04000006p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffff9ffff), -0x1.040000060001p+48, 0x0p+0 },
{ INT64_C(0x0001040000080000), 0x1.04000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffff7ffff), -0x1.040000080001p+48, 0x0p+0 },
{ INT64_C(0x0001040000080002), 0x1.040000080002p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffff7fffd), -0x1.040000080003p+48, 0x0p+0 },
{ INT64_C(0x0001040000080004), 0x1.040000080004p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffff7fffb), -0x1.040000080005p+48, 0x0p+0 },
{ INT64_C(0x0001040000080008), 0x1.040000080008p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffff7fff7), -0x1.040000080009p+48, 0x0p+0 },
{ INT64_C(0x0001040000080020), 0x1.04000008002p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffff7ffdf), -0x1.040000080021p+48, 0x0p+0 },
{ INT64_C(0x0001040000080100), 0x1.0400000801p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffff7feff), -0x1.040000080101p+48, 0x0p+0 },
{ INT64_C(0x0001040000080800), 0x1.0400000808p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffff7f7ff), -0x1.040000080801p+48, 0x0p+0 },
{ INT64_C(0x0001040000081000), 0x1.040000081p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffff7efff), -0x1.040000081001p+48, 0x0p+0 },
{ INT64_C(0x0001040000082000), 0x1.040000082p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffff7dfff), -0x1.040000082001p+48, 0x0p+0 },
{ INT64_C(0x0001040000088000), 0x1.040000088p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffff77fff), -0x1.040000088001p+48, 0x0p+0 },
{ INT64_C(0x00010400000c0000), 0x1.0400000cp+48, 0x0p+0 },
{ INT64_C(0xfffefbfffff3ffff), -0x1.0400000c0001p+48, 0x0p+0 },
{ INT64_C(0x0001040000400000), 0x1.0400004p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffbfffff), -0x1.040000400001p+48, 0x0p+0 },
{ INT64_C(0x0001040000400008), 0x1.040000400008p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffbffff7), -0x1.040000400009p+48, 0x0p+0 },
{ INT64_C(0x0001040000400010), 0x1.04000040001p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffbfffef), -0x1.040000400011p+48, 0x0p+0 },
{ INT64_C(0x0001040000400100), 0x1.0400004001p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffbffeff), -0x1.040000400101p+48, 0x0p+0 },
{ INT64_C(0x0001040000400400), 0x1.0400004004p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffbffbff), -0x1.040000400401p+48, 0x0p+0 },
{ INT64_C(0x0001040000402000), 0x1.040000402p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffbfdfff), -0x1.040000402001p+48, 0x0p+0 },
{ INT64_C(0x0001040000420000), 0x1.04000042p+48, 0x0p+0 },
{ INT64_C(0xfffefbffffbdffff), -0x1.040000420001p+48, 0x0p+0 },
{ INT64_C(0x0001040000600000), 0x1.0400006p+48, 0x0p+0 },
{ INT64_C(0xfffefbffff9fffff), -0x1.040000600001p+48, 0x0p+0 },
{ INT64_C(0x0001040004000000), 0x1.040004p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffbffffff), -0x1.040004000001p+48, 0x0p+0 },
{ INT64_C(0x0001040004000002), 0x1.040004000002p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffbfffffd), -0x1.040004000003p+48, 0x0p+0 },
{ INT64_C(0x0001040004000020), 0x1.04000400002p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffbffffdf), -0x1.040004000021p+48, 0x0p+0 },
{ INT64_C(0x0001040004000080), 0x1.04000400008p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffbffff7f), -0x1.040004000081p+48, 0x0p+0 },
{ INT64_C(0x0001040004000800), 0x1.0400040008p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffbfff7ff), -0x1.040004000801p+48, 0x0p+0 },
{ INT64_C(0x0001040004004000), 0x1.040004004p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffbffbfff), -0x1.040004004001p+48, 0x0p+0 },
{ INT64_C(0x0001040004040000), 0x1.04000404p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffbfbffff), -0x1.040004040001p+48, 0x0p+0 },
{ INT64_C(0x0001040004100000), 0x1.0400041p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffbefffff), -0x1.040004100001p+48, 0x0p+0 },
{ INT64_C(0x0001040004200000), 0x1.0400042p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffbdfffff), -0x1.040004200001p+48, 0x0p+0 },
{ INT64_C(0x0001040004800000), 0x1.0400048p+48, 0x0p+0 },
{ INT64_C(0xfffefbfffb7fffff), -0x1.040004800001p+48, 0x0p+0 },
{ INT64_C(0x0001040006000000), 0x1.040006p+48, 0x0p+0 },
{ INT64_C(0xfffefbfff9ffffff), -0x1.040006000001p+48, 0x0p+0 },
{ INT64_C(0x0001040020000000), 0x1.04002p+48, 0x0p+0 },
{ INT64_C(0xfffefbffdfffffff), -0x1.040020000001p+48, 0x0p+0 },
{ INT64_C(0x0001040020000001), 0x1.040020000001p+48, 0x0p+0 },
{ INT64_C(0xfffefbffdffffffe), -0x1.040020000002p+48, 0x0p+0 },
{ INT64_C(0x0001040020000008), 0x1.040020000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbffdffffff7), -0x1.040020000009p+48, 0x0p+0 },
{ INT64_C(0x0001040020000080), 0x1.04002000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbffdfffff7f), -0x1.040020000081p+48, 0x0p+0 },
{ INT64_C(0x0001040020000400), 0x1.0400200004p+48, 0x0p+0 },
{ INT64_C(0xfffefbffdffffbff), -0x1.040020000401p+48, 0x0p+0 },
{ INT64_C(0x0001040020002000), 0x1.040020002p+48, 0x0p+0 },
{ INT64_C(0xfffefbffdfffdfff), -0x1.040020002001p+48, 0x0p+0 },
{ INT64_C(0x0001040020004000), 0x1.040020004p+48, 0x0p+0 },
{ INT64_C(0xfffefbffdfffbfff), -0x1.040020004001p+48, 0x0p+0 },
{ INT64_C(0x0001040020040000), 0x1.04002004p+48, 0x0p+0 },
{ INT64_C(0xfffefbffdffbffff), -0x1.040020040001p+48, 0x0p+0 },
{ INT64_C(0x0001040020400000), 0x1.0400204p+48, 0x0p+0 },
{ INT64_C(0xfffefbffdfbfffff), -0x1.040020400001p+48, 0x0p+0 },
{ INT64_C(0x0001040020800000), 0x1.0400208p+48, 0x0p+0 },
{ INT64_C(0xfffefbffdf7fffff), -0x1.040020800001p+48, 0x0p+0 },
{ INT64_C(0x0001040028000000), 0x1.040028p+48, 0x0p+0 },
{ INT64_C(0xfffefbffd7ffffff), -0x1.040028000001p+48, 0x0p+0 },
{ INT64_C(0x0001040030000000), 0x1.04003p+48, 0x0p+0 },
{ INT64_C(0xfffefbffcfffffff), -0x1.040030000001p+48, 0x0p+0 },
{ INT64_C(0x0001040040000000), 0x1.04004p+48, 0x0p+0 },
{ INT64_C(0xfffefbffbfffffff), -0x1.040040000001p+48, 0x0p+0 },
{ INT64_C(0x0001040040000004), 0x1.040040000004p+48, 0x0p+0 },
{ INT64_C(0xfffefbffbffffffb), -0x1.040040000005p+48, 0x0p+0 },
{ INT64_C(0x0001040040000040), 0x1.04004000004p+48, 0x0p+0 },
{ INT64_C(0xfffefbffbfffffbf), -0x1.040040000041p+48, 0x0p+0 },
{ INT64_C(0x0001040040000200), 0x1.0400400002p+48, 0x0p+0 },
{ INT64_C(0xfffefbffbffffdff), -0x1.040040000201p+48, 0x0p+0 },
{ INT64_C(0x0001040040000800), 0x1.0400400008p+48, 0x0p+0 },
{ INT64_C(0xfffefbffbffff7ff), -0x1.040040000801p+48, 0x0p+0 },
{ INT64_C(0x0001040040002000), 0x1.040040002p+48, 0x0p+0 },
{ INT64_C(0xfffefbffbfffdfff), -0x1.040040002001p+48, 0x0p+0 },
{ INT64_C(0x0001040040020000), 0x1.04004002p+48, 0x0p+0 },
{ INT64_C(0xfffefbffbffdffff), -0x1.040040020001p+48, 0x0p+0 },
{ INT64_C(0x0001040040040000), 0x1.04004004p+48, 0x0p+0 },
{ INT64_C(0xfffefbffbffbffff), -0x1.040040040001p+48, 0x0p+0 },
{ INT64_C(0x0001040040200000), 0x1.0400402p+48, 0x0p+0 },
{ INT64_C(0xfffefbffbfdfffff), -0x1.040040200001p+48, 0x0p+0 },
{ INT64_C(0x0001040041000000), 0x1.040041p+48, 0x0p+0 },
{ INT64_C(0xfffefbffbeffffff), -0x1.040041000001p+48, 0x0p+0 },
{ INT64_C(0x0001040048000000), 0x1.040048p+48, 0x0p+0 },
{ INT64_C(0xfffefbffb7ffffff), -0x1.040048000001p+48, 0x0p+0 },
{ INT64_C(0x0001040050000000), 0x1.04005p+48, 0x0p+0 },
{ INT64_C(0xfffefbffafffffff), -0x1.040050000001p+48, 0x0p+0 },
{ INT64_C(0x0001040400000000), 0x1.0404p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbffffffff), -0x1.040400000001p+48, 0x0p+0 },
{ INT64_C(0x0001040400000008), 0x1.040400000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbfffffff7), -0x1.040400000009p+48, 0x0p+0 },
{ INT64_C(0x0001040400000040), 0x1.04040000004p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbffffffbf), -0x1.040400000041p+48, 0x0p+0 },
{ INT64_C(0x0001040400000080), 0x1.04040000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbffffff7f), -0x1.040400000081p+48, 0x0p+0 },
{ INT64_C(0x0001040400000200), 0x1.0404000002p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbfffffdff), -0x1.040400000201p+48, 0x0p+0 },
{ INT64_C(0x0001040400002000), 0x1.040400002p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbffffdfff), -0x1.040400002001p+48, 0x0p+0 },
{ INT64_C(0x0001040400004000), 0x1.040400004p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbffffbfff), -0x1.040400004001p+48, 0x0p+0 },
{ INT64_C(0x0001040400020000), 0x1.04040002p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbfffdffff), -0x1.040400020001p+48, 0x0p+0 },
{ INT64_C(0x0001040400040000), 0x1.04040004p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbfffbffff), -0x1.040400040001p+48, 0x0p+0 },
{ INT64_C(0x0001040400400000), 0x1.0404004p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbffbfffff), -0x1.040400400001p+48, 0x0p+0 },
{ INT64_C(0x0001040404000000), 0x1.040404p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbfbffffff), -0x1.040404000001p+48, 0x0p+0 },
{ INT64_C(0x0001040410000000), 0x1.04041p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbefffffff), -0x1.040410000001p+48, 0x0p+0 },
{ INT64_C(0x0001040440000000), 0x1.04044p+48, 0x0p+0 },
{ INT64_C(0xfffefbfbbfffffff), -0x1.040440000001p+48, 0x0p+0 },
{ INT64_C(0x0001040500000000), 0x1.0405p+48, 0x0p+0 },
{ INT64_C(0xfffefbfaffffffff), -0x1.040500000001p+48, 0x0p+0 },
{ INT64_C(0x0001040600000000), 0x1.0406p+48, 0x0p+0 },
{ INT64_C(0xfffefbf9ffffffff), -0x1.040600000001p+48, 0x0p+0 },
{ INT64_C(0x0001041000000000), 0x1.041p+48, 0x0p+0 },
{ INT64_C(0xfffefbefffffffff), -0x1.041000000001p+48, 0x0p+0 },
{ INT64_C(0x0001041000000008), 0x1.041000000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbeffffffff7), -0x1.041000000009p+48, 0x0p+0 },
{ INT64_C(0x0001041000000080), 0x1.04100000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbefffffff7f), -0x1.041000000081p+48, 0x0p+0 },
{ INT64_C(0x0001041000000800), 0x1.0410000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbeffffff7ff), -0x1.041000000801p+48, 0x0p+0 },
{ INT64_C(0x0001041000001000), 0x1.041000001p+48, 0x0p+0 },
{ INT64_C(0xfffefbefffffefff), -0x1.041000001001p+48, 0x0p+0 },
{ INT64_C(0x0001041000002000), 0x1.041000002p+48, 0x0p+0 },
{ INT64_C(0xfffefbefffffdfff), -0x1.041000002001p+48, 0x0p+0 },
{ INT64_C(0x0001041000004000), 0x1.041000004p+48, 0x0p+0 },
{ INT64_C(0xfffefbefffffbfff), -0x1.041000004001p+48, 0x0p+0 },
{ INT64_C(0x0001041000040000), 0x1.04100004p+48, 0x0p+0 },
{ INT64_C(0xfffefbeffffbffff), -0x1.041000040001p+48, 0x0p+0 },
{ INT64_C(0x0001041000400000), 0x1.0410004p+48, 0x0p+0 },
{ INT64_C(0xfffefbefffbfffff), -0x1.041000400001p+48, 0x0p+0 },
{ INT64_C(0x0001041001000000), 0x1.041001p+48, 0x0p+0 },
{ INT64_C(0xfffefbeffeffffff), -0x1.041001000001p+48, 0x0p+0 },
{ INT64_C(0x0001041002000000), 0x1.041002p+48, 0x0p+0 },
{ INT64_C(0xfffefbeffdffffff), -0x1.041002000001p+48, 0x0p+0 },
{ INT64_C(0x0001041004000000), 0x1.041004p+48, 0x0p+0 },
{ INT64_C(0xfffefbeffbffffff), -0x1.041004000001p+48, 0x0p+0 },
{ INT64_C(0x0001041010000000), 0x1.04101p+48, 0x0p+0 },
{ INT64_C(0xfffefbefefffffff), -0x1.041010000001p+48, 0x0p+0 },
{ INT64_C(0x0001041080000000), 0x1.04108p+48, 0x0p+0 },
{ INT64_C(0xfffefbef7fffffff), -0x1.041080000001p+48, 0x0p+0 },
{ INT64_C(0x0001041100000000), 0x1.0411p+48, 0x0p+0 },
{ INT64_C(0xfffefbeeffffffff), -0x1.041100000001p+48, 0x0p+0 },
{ INT64_C(0x0001041200000000), 0x1.0412p+48, 0x0p+0 },
{ INT64_C(0xfffefbedffffffff), -0x1.041200000001p+48, 0x0p+0 },
{ INT64_C(0x0001042000000000), 0x1.042p+48, 0x0p+0 },
{ INT64_C(0xfffefbdfffffffff), -0x1.042000000001p+48, 0x0p+0 },
{ INT64_C(0x0001042000000008), 0x1.042000000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbdffffffff7), -0x1.042000000009p+48, 0x0p+0 },
{ INT64_C(0x0001042000000020), 0x1.04200000002p+48, 0x0p+0 },
{ INT64_C(0xfffefbdfffffffdf), -0x1.042000000021p+48, 0x0p+0 },
{ INT64_C(0x0001042000000200), 0x1.0420000002p+48, 0x0p+0 },
{ INT64_C(0xfffefbdffffffdff), -0x1.042000000201p+48, 0x0p+0 },
{ INT64_C(0x0001042000000400), 0x1.0420000004p+48, 0x0p+0 },
{ INT64_C(0xfffefbdffffffbff), -0x1.042000000401p+48, 0x0p+0 },
{ INT64_C(0x0001042000000800), 0x1.0420000008p+48, 0x0p+0 },
{ INT64_C(0xfffefbdffffff7ff), -0x1.042000000801p+48, 0x0p+0 },
{ INT64_C(0x0001042000002000), 0x1.042000002p+48, 0x0p+0 },
{ INT64_C(0xfffefbdfffffdfff), -0x1.042000002001p+48, 0x0p+0 },
{ INT64_C(0x0001042000020000), 0x1.04200002p+48, 0x0p+0 },
{ INT64_C(0xfffefbdffffdffff), -0x1.042000020001p+48, 0x0p+0 },
{ INT64_C(0x0001042000040000), 0x1.04200004p+48, 0x0p+0 },
{ INT64_C(0xfffefbdffffbffff), -0x1.042000040001p+48, 0x0p+0 },
{ INT64_C(0x0001042000200000), 0x1.0420002p+48, 0x0p+0 },
{ INT64_C(0xfffefbdfffdfffff), -0x1.042000200001p+48, 0x0p+0 },
{ INT64_C(0x0001042001000000), 0x1.042001p+48, 0x0p+0 },
{ INT64_C(0xfffefbdffeffffff), -0x1.042001000001p+48, 0x0p+0 },
{ INT64_C(0x0001042008000000), 0x1.042008p+48, 0x0p+0 },
{ INT64_C(0xfffefbdff7ffffff), -0x1.042008000001p+48, 0x0p+0 },
{ INT64_C(0x0001042080000000), 0x1.04208p+48, 0x0p+0 },
{ INT64_C(0xfffefbdf7fffffff), -0x1.042080000001p+48, 0x0p+0 },
{ INT64_C(0x0001042100000000), 0x1.0421p+48, 0x0p+0 },
{ INT64_C(0xfffefbdeffffffff), -0x1.042100000001p+48, 0x0p+0 },
{ INT64_C(0x0001042800000000), 0x1.0428p+48, 0x0p+0 },
{ INT64_C(0xfffefbd7ffffffff), -0x1.042800000001p+48, 0x0p+0 },
{ INT64_C(0x0001050000000000), 0x1.05p+48, 0x0p+0 },
{ INT64_C(0xfffefaffffffffff), -0x1.050000000001p+48, 0x0p+0 },
{ INT64_C(0x0001050000000008), 0x1.050000000008p+48, 0x0p+0 },
{ INT64_C(0xfffefafffffffff7), -0x1.050000000009p+48, 0x0p+0 },
{ INT64_C(0x0001050000000080), 0x1.05000000008p+48, 0x0p+0 },
{ INT64_C(0xfffefaffffffff7f), -0x1.050000000081p+48, 0x0p+0 },
{ INT64_C(0x0001050000000100), 0x1.0500000001p+48, 0x0p+0 },
{ INT64_C(0xfffefafffffffeff), -0x1.050000000101p+48, 0x0p+0 },
{ INT64_C(0x0001050000000800), 0x1.0500000008p+48, 0x0p+0 },
{ INT64_C(0xfffefafffffff7ff), -0x1.050000000801p+48, 0x0p+0 },
{ INT64_C(0x0001050000001000), 0x1.050000001p+48, 0x0p+0 },
{ INT64_C(0xfffefaffffffefff), -0x1.050000001001p+48, 0x0p+0 },
{ INT64_C(0x0001050000002000), 0x1.050000002p+48, 0x0p+0 },
{ INT64_C(0xfffefaffffffdfff), -0x1.050000002001p+48, 0x0p+0 },
{ INT64_C(0x0001050000008000), 0x1.050000008p+48, 0x0p+0 },
{ INT64_C(0xfffefaffffff7fff), -0x1.050000008001p+48, 0x0p+0 },
{ INT64_C(0x0001050000010000), 0x1.05000001p+48, 0x0p+0 },
{ INT64_C(0xfffefafffffeffff), -0x1.050000010001p+48, 0x0p+0 },
{ INT64_C(0x0001050000100000), 0x1.0500001p+48, 0x0p+0 },
{ INT64_C(0xfffefaffffefffff), -0x1.050000100001p+48, 0x0p+0 },
{ INT64_C(0x0001050000400000), 0x1.0500004p+48, 0x0p+0 },
{ INT64_C(0xfffefaffffbfffff), -0x1.050000400001p+48, 0x0p+0 },
{ INT64_C(0x0001050001000000), 0x1.050001p+48, 0x0p+0 },
{ INT64_C(0xfffefafffeffffff), -0x1.050001000001p+48, 0x0p+0 },
{ INT64_C(0x0001050010000000), 0x1.05001p+48, 0x0p+0 },
{ INT64_C(0xfffefaffefffffff), -0x1.050010000001p+48, 0x0p+0 },
{ INT64_C(0x0001050100000000), 0x1.0501p+48, 0x0p+0 },
{ INT64_C(0xfffefafeffffffff), -0x1.050100000001p+48, 0x0p+0 },
{ INT64_C(0x0001051000000000), 0x1.051p+48, 0x0p+0 },
{ INT64_C(0xfffefaefffffffff), -0x1.051000000001p+48, 0x0p+0 },
{ INT64_C(0x0001058000000000), 0x1.058p+48, 0x0p+0 },
{ INT64_C(0xfffefa7fffffffff), -0x1.058000000001p+48, 0x0p+0 },
{ INT64_C(0x0001060000000000), 0x1.06p+48, 0x0p+0 },
{ INT64_C(0xfffef9ffffffffff), -0x1.060000000001p+48, 0x0p+0 },
{ INT64_C(0x0001060000000004), 0x1.060000000004p+48, 0x0p+0 },
{ INT64_C(0xfffef9fffffffffb), -0x1.060000000005p+48, 0x0p+0 },
{ INT64_C(0x0001060000000010), 0x1.06000000001p+48, 0x0p+0 },
{ INT64_C(0xfffef9ffffffffef), -0x1.060000000011p+48, 0x0p+0 },
{ INT64_C(0x0001060000000080), 0x1.06000000008p+48, 0x0p+0 },
{ INT64_C(0xfffef9ffffffff7f), -0x1.060000000081p+48, 0x0p+0 },
{ INT64_C(0x0001060000000200), 0x1.0600000002p+48, 0x0p+0 },
{ INT64_C(0xfffef9fffffffdff), -0x1.060000000201p+48, 0x0p+0 },
{ INT64_C(0x0001060000001000), 0x1.060000001p+48, 0x0p+0 },
{ INT64_C(0xfffef9ffffffefff), -0x1.060000001001p+48, 0x0p+0 },
{ INT64_C(0x0001060000010000), 0x1.06000001p+48, 0x0p+0 },
{ INT64_C(0xfffef9fffffeffff), -0x1.060000010001p+48, 0x0p+0 },
{ INT64_C(0x0001060000020000), 0x1.06000002p+48, 0x0p+0 },
{ INT64_C(0xfffef9fffffdffff), -0x1.060000020001p+48, 0x0p+0 },
{ INT64_C(0x0001060000200000), 0x1.0600002p+48, 0x0p+0 },
{ INT64_C(0xfffef9ffffdfffff), -0x1.060000200001p+48, 0x0p+0 },
{ INT64_C(0x0001060001000000), 0x1.060001p+48, 0x0p+0 },
{ INT64_C(0xfffef9fffeffffff), -0x1.060001000001p+48, 0x0p+0 },
{ INT64_C(0x0001060004000000), 0x1.060004p+48, 0x0p+0 },
{ INT64_C(0xfffef9fffbffffff), -0x1.060004000001p+48, 0x0p+0 },
{ INT64_C(0x0001060008000000), 0x1.060008p+48, 0x0p+0 },
{ INT64_C(0xfffef9fff7ffffff), -0x1.060008000001p+48, 0x0p+0 },
{ INT64_C(0x0001060020000000), 0x1.06002p+48, 0x0p+0 },
{ INT64_C(0xfffef9ffdfffffff), -0x1.060020000001p+48, 0x0p+0 },
{ INT64_C(0x0001060100000000), 0x1.0601p+48, 0x0p+0 },
{ INT64_C(0xfffef9feffffffff), -0x1.060100000001p+48, 0x0p+0 },
{ INT64_C(0x0001061000000000), 0x1.061p+48, 0x0p+0 },
{ INT64_C(0xfffef9efffffffff), -0x1.061000000001p+48, 0x0p+0 },
{ INT64_C(0x0001062000000000), 0x1.062p+48, 0x0p+0 },
{ INT64_C(0xfffef9dfffffffff), -0x1.062000000001p+48, 0x0p+0 },
{ INT64_C(0x0001200000000001), 0x1.200000000001p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffffffe), -0x1.200000000002p+48, 0x0p+0 },
{ INT64_C(0x0001200000000010), 0x1.20000000001p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffffffef), -0x1.200000000011p+48, 0x0p+0 },
{ INT64_C(0x0001200000000014), 0x1.200000000014p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffffffeb), -0x1.200000000015p+48, 0x0p+0 },
{ INT64_C(0x0001200000000080), 0x1.20000000008p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffffff7f), -0x1.200000000081p+48, 0x0p+0 },
{ INT64_C(0x0001200000000088), 0x1.200000000088p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffffff77), -0x1.200000000089p+48, 0x0p+0 },
{ INT64_C(0x00012000000000c0), 0x1.2000000000cp+48, 0x0p+0 },
{ INT64_C(0xfffedfffffffff3f), -0x1.2000000000c1p+48, 0x0p+0 },
{ INT64_C(0x0001200000000200), 0x1.2000000002p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffffdff), -0x1.200000000201p+48, 0x0p+0 },
{ INT64_C(0x0001200000000201), 0x1.200000000201p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffffdfe), -0x1.200000000202p+48, 0x0p+0 },
{ INT64_C(0x0001200000000208), 0x1.200000000208p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffffdf7), -0x1.200000000209p+48, 0x0p+0 },
{ INT64_C(0x0001200000000280), 0x1.20000000028p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffffd7f), -0x1.200000000281p+48, 0x0p+0 },
{ INT64_C(0x0001200000000800), 0x1.2000000008p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffff7ff), -0x1.200000000801p+48, 0x0p+0 },
{ INT64_C(0x0001200000000801), 0x1.200000000801p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffff7fe), -0x1.200000000802p+48, 0x0p+0 },
{ INT64_C(0x0001200000000808), 0x1.200000000808p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffff7f7), -0x1.200000000809p+48, 0x0p+0 },
{ INT64_C(0x0001200000000880), 0x1.20000000088p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffff77f), -0x1.200000000881p+48, 0x0p+0 },
{ INT64_C(0x0001200000000a00), 0x1.200000000ap+48, 0x0p+0 },
{ INT64_C(0xfffedffffffff5ff), -0x1.200000000a01p+48, 0x0p+0 },
{ INT64_C(0x0001200000004000), 0x1.200000004p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffffbfff), -0x1.200000004001p+48, 0x0p+0 },
{ INT64_C(0x0001200000004002), 0x1.200000004002p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffffbffd), -0x1.200000004003p+48, 0x0p+0 },
{ INT64_C(0x0001200000004010), 0x1.20000000401p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffffbfef), -0x1.200000004011p+48, 0x0p+0 },
{ INT64_C(0x0001200000004080), 0x1.20000000408p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffffbf7f), -0x1.200000004081p+48, 0x0p+0 },
{ INT64_C(0x0001200000004400), 0x1.2000000044p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffffbbff), -0x1.200000004401p+48, 0x0p+0 },
{ INT64_C(0x0001200000020000), 0x1.20000002p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffdffff), -0x1.200000020001p+48, 0x0p+0 },
{ INT64_C(0x0001200000020004), 0x1.200000020004p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffdfffb), -0x1.200000020005p+48, 0x0p+0 },
{ INT64_C(0x0001200000020008), 0x1.200000020008p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffdfff7), -0x1.200000020009p+48, 0x0p+0 },
{ INT64_C(0x0001200000020080), 0x1.20000002008p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffdff7f), -0x1.200000020081p+48, 0x0p+0 },
{ INT64_C(0x0001200000020100), 0x1.2000000201p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffdfeff), -0x1.200000020101p+48, 0x0p+0 },
{ INT64_C(0x0001200000020800), 0x1.2000000208p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffdf7ff), -0x1.200000020801p+48, 0x0p+0 },
{ INT64_C(0x0001200000021000), 0x1.200000021p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffdefff), -0x1.200000021001p+48, 0x0p+0 },
{ INT64_C(0x0001200000022000), 0x1.200000022p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffddfff), -0x1.200000022001p+48, 0x0p+0 },
{ INT64_C(0x0001200000028000), 0x1.200000028p+48, 0x0p+0 },
{ INT64_C(0xfffedffffffd7fff), -0x1.200000028001p+48, 0x0p+0 },
{ INT64_C(0x0001200000080000), 0x1.20000008p+48, 0x0p+0 },
{ INT64_C(0xfffedffffff7ffff), -0x1.200000080001p+48, 0x0p+0 },
{ INT64_C(0x0001200000080002), 0x1.200000080002p+48, 0x0p+0 },
{ INT64_C(0xfffedffffff7fffd), -0x1.200000080003p+48, 0x0p+0 },
{ INT64_C(0x0001200000080020), 0x1.20000008002p+48, 0x0p+0 },
{ INT64_C(0xfffedffffff7ffdf), -0x1.200000080021p+48, 0x0p+0 },
{ INT64_C(0x0001200000080080), 0x1.20000008008p+48, 0x0p+0 },
{ INT64_C(0xfffedffffff7ff7f), -0x1.200000080081p+48, 0x0p+0 },
{ INT64_C(0x0001200000080800), 0x1.2000000808p+48, 0x0p+0 },
{ INT64_C(0xfffedffffff7f7ff), -0x1.200000080801p+48, 0x0p+0 },
{ INT64_C(0x0001200000084000), 0x1.200000084p+48, 0x0p+0 },
{ INT64_C(0xfffedffffff7bfff), -0x1.200000084001p+48, 0x0p+0 },
{ INT64_C(0x00012000000c0000), 0x1.2000000cp+48, 0x0p+0 },
{ INT64_C(0xfffedffffff3ffff), -0x1.2000000c0001p+48, 0x0p+0 },
{ INT64_C(0x0001200000200000), 0x1.2000002p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffdfffff), -0x1.200000200001p+48, 0x0p+0 },
{ INT64_C(0x0001200000200004), 0x1.200000200004p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffdffffb), -0x1.200000200005p+48, 0x0p+0 },
{ INT64_C(0x0001200000200010), 0x1.20000020001p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffdfffef), -0x1.200000200011p+48, 0x0p+0 },
{ INT64_C(0x0001200000200080), 0x1.20000020008p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffdfff7f), -0x1.200000200081p+48, 0x0p+0 },
{ INT64_C(0x0001200000200400), 0x1.2000002004p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffdffbff), -0x1.200000200401p+48, 0x0p+0 },
{ INT64_C(0x0001200000204000), 0x1.200000204p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffdfbfff), -0x1.200000204001p+48, 0x0p+0 },
{ INT64_C(0x0001200000210000), 0x1.20000021p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffdeffff), -0x1.200000210001p+48, 0x0p+0 },
{ INT64_C(0x0001200000240000), 0x1.20000024p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffdbffff), -0x1.200000240001p+48, 0x0p+0 },
{ INT64_C(0x0001200000300000), 0x1.2000003p+48, 0x0p+0 },
{ INT64_C(0xfffedfffffcfffff), -0x1.200000300001p+48, 0x0p+0 },
{ INT64_C(0x0001200001000000), 0x1.200001p+48, 0x0p+0 },
{ INT64_C(0xfffedffffeffffff), -0x1.200001000001p+48, 0x0p+0 },
{ INT64_C(0x0001200001000001), 0x1.200001000001p+48, 0x0p+0 },
{ INT64_C(0xfffedffffefffffe), -0x1.200001000002p+48, 0x0p+0 },
{ INT64_C(0x0001200001000004), 0x1.200001000004p+48, 0x0p+0 },
{ INT64_C(0xfffedffffefffffb), -0x1.200001000005p+48, 0x0p+0 },
{ INT64_C(0x0001200001000040), 0x1.20000100004p+48, 0x0p+0 },
{ INT64_C(0xfffedffffeffffbf), -0x1.200001000041p+48, 0x0p+0 },
{ INT64_C(0x0001200001000080), 0x1.20000100008p+48, 0x0p+0 },
{ INT64_C(0xfffedffffeffff7f), -0x1.200001000081p+48, 0x0p+0 },
{ INT64_C(0x0001200001000800), 0x1.2000010008p+48, 0x0p+0 },
{ INT64_C(0xfffedffffefff7ff), -0x1.200001000801p+48, 0x0p+0 },
{ INT64_C(0x0001200001001000), 0x1.200001001p+48, 0x0p+0 },
{ INT64_C(0xfffedffffeffefff), -0x1.200001001001p+48, 0x0p+0 },
{ INT64_C(0x0001200001010000), 0x1.20000101p+48, 0x0p+0 },
{ INT64_C(0xfffedffffefeffff), -0x1.200001010001p+48, 0x0p+0 },
{ INT64_C(0x0001200001040000), 0x1.20000104p+48, 0x0p+0 },
{ INT64_C(0xfffedffffefbffff), -0x1.200001040001p+48, 0x0p+0 },
{ INT64_C(0x0001200001200000), 0x1.2000012p+48, 0x0p+0 },
{ INT64_C(0xfffedffffedfffff), -0x1.200001200001p+48, 0x0p+0 },
{ INT64_C(0x0001200001800000), 0x1.2000018p+48, 0x0p+0 },
{ INT64_C(0xfffedffffe7fffff), -0x1.200001800001p+48, 0x0p+0 },
{ INT64_C(0x0001200008000000), 0x1.200008p+48, 0x0p+0 },
{ INT64_C(0xfffedffff7ffffff), -0x1.200008000001p+48, 0x0p+0 },
{ INT64_C(0x0001200008000004), 0x1.200008000004p+48, 0x0p+0 },
{ INT64_C(0xfffedffff7fffffb), -0x1.200008000005p+48, 0x0p+0 },
{ INT64_C(0x0001200008000040), 0x1.20000800004p+48, 0x0p+0 },
{ INT64_C(0xfffedffff7ffffbf), -0x1.200008000041p+48, 0x0p+0 },
{ INT64_C(0x0001200008000080), 0x1.20000800008p+48, 0x0p+0 },
{ INT64_C(0xfffedffff7ffff7f), -0x1.200008000081p+48, 0x0p+0 },
{ INT64_C(0x0001200008000200), 0x1.2000080002p+48, 0x0p+0 },
{ INT64_C(0xfffedffff7fffdff), -0x1.200008000201p+48, 0x0p+0 },
{ INT64_C(0x0001200008001000), 0x1.200008001p+48, 0x0p+0 },
{ INT64_C(0xfffedffff7ffefff), -0x1.200008001001p+48, 0x0p+0 },
{ INT64_C(0x0001200008008000), 0x1.200008008p+48, 0x0p+0 },
{ INT64_C(0xfffedffff7ff7fff), -0x1.200008008001p+48, 0x0p+0 },
{ INT64_C(0x0001200008010000), 0x1.20000801p+48, 0x0p+0 },
{ INT64_C(0xfffedffff7feffff), -0x1.200008010001p+48, 0x0p+0 },
{ INT64_C(0x0001200008020000), 0x1.20000802p+48, 0x0p+0 },
{ INT64_C(0xfffedffff7fdffff), -0x1.200008020001p+48, 0x0p+0 },
{ INT64_C(0x0001200008200000), 0x1.2000082p+48, 0x0p+0 },
{ INT64_C(0xfffedffff7dfffff), -0x1.200008200001p+48, 0x0p+0 },
{ INT64_C(0x000120000a000000), 0x1.20000ap+48, 0x0p+0 },
{ INT64_C(0xfffedffff5ffffff), -0x1.20000a000001p+48, 0x0p+0 },
{ INT64_C(0x0001200010000000), 0x1.20001p+48, 0x0p+0 },
{ INT64_C(0xfffedfffefffffff), -0x1.200010000001p+48, 0x0p+0 },
{ INT64_C(0x0001200010000002), 0x1.200010000002p+48, 0x0p+0 },
{ INT64_C(0xfffedfffeffffffd), -0x1.200010000003p+48, 0x0p+0 },
{ INT64_C(0x0001200010000004), 0x1.200010000004p+48, 0x0p+0 },
{ INT64_C(0xfffedfffeffffffb), -0x1.200010000005p+48, 0x0p+0 },
{ INT64_C(0x0001200010000008), 0x1.200010000008p+48, 0x0p+0 },
{ INT64_C(0xfffedfffeffffff7), -0x1.200010000009p+48, 0x0p+0 },
{ INT64_C(0x0001200010000080), 0x1.20001000008p+48, 0x0p+0 },
{ INT64_C(0xfffedfffefffff7f), -0x1.200010000081p+48, 0x0p+0 },
{ INT64_C(0x0001200010000100), 0x1.2000100001p+48, 0x0p+0 },
{ INT64_C(0xfffedfffeffffeff), -0x1.200010000101p+48, 0x0p+0 },
{ INT64_C(0x0001200010000400), 0x1.2000100004p+48, 0x0p+0 },
{ INT64_C(0xfffedfffeffffbff), -0x1.200010000401p+48, 0x0p+0 },
{ INT64_C(0x0001200010001000), 0x1.200010001p+48, 0x0p+0 },
{ INT64_C(0xfffedfffefffefff), -0x1.200010001001p+48, 0x0p+0 },
{ INT64_C(0x0001200010004000), 0x1.200010004p+48, 0x0p+0 },
{ INT64_C(0xfffedfffefffbfff), -0x1.200010004001p+48, 0x0p+0 },
{ INT64_C(0x0001200010040000), 0x1.20001004p+48, 0x0p+0 },
{ INT64_C(0xfffedfffeffbffff), -0x1.200010040001p+48, 0x0p+0 },
{ INT64_C(0x0001200010400000), 0x1.2000104p+48, 0x0p+0 },
{ INT64_C(0xfffedfffefbfffff), -0x1.200010400001p+48, 0x0p+0 },
{ INT64_C(0x0001200011000000), 0x1.200011p+48, 0x0p+0 },
{ INT64_C(0xfffedfffeeffffff), -0x1.200011000001p+48, 0x0p+0 },
{ INT64_C(0x0001200080000000), 0x1.20008p+48, 0x0p+0 },
{ INT64_C(0xfffedfff7fffffff), -0x1.200080000001p+48, 0x0p+0 },
{ INT64_C(0x0001200080000002), 0x1.200080000002p+48, 0x0p+0 },
{ INT64_C(0xfffedfff7ffffffd), -0x1.200080000003p+48, 0x0p+0 },
{ INT64_C(0x0001200080000020), 0x1.20008000002p+48, 0x0p+0 },
{ INT64_C(0xfffedfff7fffffdf), -0x1.200080000021p+48, 0x0p+0 },
{ INT64_C(0x0001200080000200), 0x1.2000800002p+48, 0x0p+0 },
{ INT64_C(0xfffedfff7ffffdff), -0x1.200080000201p+48, 0x0p+0 },
{ INT64_C(0x0001200080001000), 0x1.200080001p+48, 0x0p+0 },
{ INT64_C(0xfffedfff7fffefff), -0x1.200080001001p+48, 0x0p+0 },
{ INT64_C(0x0001200080010000), 0x1.20008001p+48, 0x0p+0 },
{ INT64_C(0xfffedfff7ffeffff), -0x1.200080010001p+48, 0x0p+0 },
{ INT64_C(0x0001200080020000), 0x1.20008002p+48, 0x0p+0 },
{ INT64_C(0xfffedfff7ffdffff), -0x1.200080020001p+48, 0x0p+0 },
{ INT64_C(0x0001200080100000), 0x1.2000801p+48, 0x0p+0 },
{ INT64_C(0xfffedfff7fefffff), -0x1.200080100001p+48, 0x0p+0 },
{ INT64_C(0x0001200080200000), 0x1.2000802p+48, 0x0p+0 },
{ INT64_C(0xfffedfff7fdfffff), -0x1.200080200001p+48, 0x0p+0 },
{ INT64_C(0x0001200082000000), 0x1.200082p+48, 0x0p+0 },
{ INT64_C(0xfffedfff7dffffff), -0x1.200082000001p+48, 0x0p+0 },
{ INT64_C(0x00012000a0000000), 0x1.2000ap+48, 0x0p+0 },
{ INT64_C(0xfffedfff5fffffff), -0x1.2000a0000001p+48, 0x0p+0 },
{ INT64_C(0x0001200100000000), 0x1.2001p+48, 0x0p+0 },
{ INT64_C(0xfffedffeffffffff), -0x1.200100000001p+48, 0x0p+0 },
{ INT64_C(0x0001200100000008), 0x1.200100000008p+48, 0x0p+0 },
{ INT64_C(0xfffedffefffffff7), -0x1.200100000009p+48, 0x0p+0 },
{ INT64_C(0x0001200100000040), 0x1.20010000004p+48, 0x0p+0 },
{ INT64_C(0xfffedffeffffffbf), -0x1.200100000041p+48, 0x0p+0 },
{ INT64_C(0x0001200100000200), 0x1.2001000002p+48, 0x0p+0 },
{ INT64_C(0xfffedffefffffdff), -0x1.200100000201p+48, 0x0p+0 },
{ INT64_C(0x0001200100002000), 0x1.200100002p+48, 0x0p+0 },
{ INT64_C(0xfffedffeffffdfff), -0x1.200100002001p+48, 0x0p+0 },
{ INT64_C(0x0001200100010000), 0x1.20010001p+48, 0x0p+0 },
{ INT64_C(0xfffedffefffeffff), -0x1.200100010001p+48, 0x0p+0 },
{ INT64_C(0x0001200100100000), 0x1.2001001p+48, 0x0p+0 },
{ INT64_C(0xfffedffeffefffff), -0x1.200100100001p+48, 0x0p+0 },
{ INT64_C(0x0001200100800000), 0x1.2001008p+48, 0x0p+0 },
{ INT64_C(0xfffedffeff7fffff), -0x1.200100800001p+48, 0x0p+0 },
{ INT64_C(0x0001200104000000), 0x1.200104p+48, 0x0p+0 },
{ INT64_C(0xfffedffefbffffff), -0x1.200104000001p+48, 0x0p+0 },
{ INT64_C(0x0001200120000000), 0x1.20012p+48, 0x0p+0 },
{ INT64_C(0xfffedffedfffffff), -0x1.200120000001p+48, 0x0p+0 },
{ INT64_C(0x0001200200000000), 0x1.2002p+48, 0x0p+0 },
{ INT64_C(0xfffedffdffffffff), -0x1.200200000001p+48, 0x0p+0 },
{ INT64_C(0x0001200200000002), 0x1.200200000002p+48, 0x0p+0 },
{ INT64_C(0xfffedffdfffffffd), -0x1.200200000003p+48, 0x0p+0 },
{ INT64_C(0x0001200200000008), 0x1.200200000008p+48, 0x0p+0 },
{ INT64_C(0xfffedffdfffffff7), -0x1.200200000009p+48, 0x0p+0 },
{ INT64_C(0x0001200200000040), 0x1.20020000004p+48, 0x0p+0 },
{ INT64_C(0xfffedffdffffffbf), -0x1.200200000041p+48, 0x0p+0 },
{ INT64_C(0x0001200200000080), 0x1.20020000008p+48, 0x0p+0 },
{ INT64_C(0xfffedffdffffff7f), -0x1.200200000081p+48, 0x0p+0 },
{ INT64_C(0x0001200200000400), 0x1.2002000004p+48, 0x0p+0 },
{ INT64_C(0xfffedffdfffffbff), -0x1.200200000401p+48, 0x0p+0 },
{ INT64_C(0x0001200200002000), 0x1.200200002p+48, 0x0p+0 },
{ INT64_C(0xfffedffdffffdfff), -0x1.200200002001p+48, 0x0p+0 },
{ INT64_C(0x0001200200004000), 0x1.200200004p+48, 0x0p+0 },
{ INT64_C(0xfffedffdffffbfff), -0x1.200200004001p+48, 0x0p+0 },
{ INT64_C(0x0001200200008000), 0x1.200200008p+48, 0x0p+0 },
{ INT64_C(0xfffedffdffff7fff), -0x1.200200008001p+48, 0x0p+0 },
{ INT64_C(0x0001200200020000), 0x1.20020002p+48, 0x0p+0 },
{ INT64_C(0xfffedffdfffdffff), -0x1.200200020001p+48, 0x0p+0 },
{ INT64_C(0x0001200200100000), 0x1.2002001p+48, 0x0p+0 },
{ INT64_C(0xfffedffdffefffff), -0x1.200200100001p+48, 0x0p+0 },
{ INT64_C(0x0001200200800000), 0x1.2002008p+48, 0x0p+0 },
{ INT64_C(0xfffedffdff7fffff), -0x1.200200800001p+48, 0x0p+0 },
{ INT64_C(0x0001200201000000), 0x1.200201p+48, 0x0p+0 },
{ INT64_C(0xfffedffdfeffffff), -0x1.200201000001p+48, 0x0p+0 },
{ INT64_C(0x0001200202000000), 0x1.200202p+48, 0x0p+0 },
{ INT64_C(0xfffedffdfdffffff), -0x1.200202000001p+48, 0x0p+0 },
{ INT64_C(0x0001200204000000), 0x1.200204p+48, 0x0p+0 },
{ INT64_C(0xfffedffdfbffffff), -0x1.200204000001p+48, 0x0p+0 },
{ INT64_C(0x0001200240000000), 0x1.20024p+48, 0x0p+0 },
{ INT64_C(0xfffedffdbfffffff), -0x1.200240000001p+48, 0x0p+0 },
{ INT64_C(0x0001200300000000), 0x1.2003p+48, 0x0p+0 },
{ INT64_C(0xfffedffcffffffff), -0x1.200300000001p+48, 0x0p+0 },
{ INT64_C(0x0001202000000000), 0x1.202p+48, 0x0p+0 },
{ INT64_C(0xfffedfdfffffffff), -0x1.202000000001p+48, 0x0p+0 },
{ INT64_C(0x0001202000000002), 0x1.202000000002p+48, 0x0p+0 },
{ INT64_C(0xfffedfdffffffffd), -0x1.202000000003p+48, 0x0p+0 },
{ INT64_C(0x0001202000000010), 0x1.20200000001p+48, 0x0p+0 },
{ INT64_C(0xfffedfdfffffffef), -0x1.202000000011p+48, 0x0p+0 },
{ INT64_C(0x0001202000000080), 0x1.20200000008p+48, 0x0p+0 },
{ INT64_C(0xfffedfdfffffff7f), -0x1.202000000081p+48, 0x0p+0 },
{ INT64_C(0x0001202000000800), 0x1.2020000008p+48, 0x0p+0 },
{ INT64_C(0xfffedfdffffff7ff), -0x1.202000000801p+48, 0x0p+0 },
{ INT64_C(0x0001202000008000), 0x1.202000008p+48, 0x0p+0 },
{ INT64_C(0xfffedfdfffff7fff), -0x1.202000008001p+48, 0x0p+0 },
{ INT64_C(0x0001202000080000), 0x1.20200008p+48, 0x0p+0 },
{ INT64_C(0xfffedfdffff7ffff), -0x1.202000080001p+48, 0x0p+0 },
{ INT64_C(0x0001202000400000), 0x1.2020004p+48, 0x0p+0 },
{ INT64_C(0xfffedfdfffbfffff), -0x1.202000400001p+48, 0x0p+0 },
{ INT64_C(0x0001202001000000), 0x1.202001p+48, 0x0p+0 },
{ INT64_C(0xfffedfdffeffffff), -0x1.202001000001p+48, 0x0p+0 },
{ INT64_C(0x0001202010000000), 0x1.20201p+48, 0x0p+0 },
{ INT64_C(0xfffedfdfefffffff), -0x1.202010000001p+48, 0x0p+0 },
{ INT64_C(0x0001202040000000), 0x1.20204p+48, 0x0p+0 },
{ INT64_C(0xfffedfdfbfffffff), -0x1.202040000001p+48, 0x0p+0 },
{ INT64_C(0x0001202200000000), 0x1.2022p+48, 0x0p+0 },
{ INT64_C(0xfffedfddffffffff), -0x1.202200000001p+48, 0x0p+0 },
{ INT64_C(0x0001202400000000), 0x1.2024p+48, 0x0p+0 },
{ INT64_C(0xfffedfdbffffffff), -0x1.202400000001p+48, 0x0p+0 },
{ INT64_C(0x0001204000000000), 0x1.204p+48, 0x0p+0 },
{ INT64_C(0xfffedfbfffffffff), -0x1.204000000001p+48, 0x0p+0 },
{ INT64_C(0x0001204000000004), 0x1.204000000004p+48, 0x0p+0 },
{ INT64_C(0xfffedfbffffffffb), -0x1.204000000005p+48, 0x0p+0 },
{ INT64_C(0x0001204000000020), 0x1.20400000002p+48, 0x0p+0 },
{ INT64_C(0xfffedfbfffffffdf), -0x1.204000000021p+48, 0x0p+0 },
{ INT64_C(0x0001204000000200), 0x1.2040000002p+48, 0x0p+0 },
{ INT64_C(0xfffedfbffffffdff), -0x1.204000000201p+48, 0x0p+0 },
{ INT64_C(0x0001204000001000), 0x1.204000001p+48, 0x0p+0 },
{ INT64_C(0xfffedfbfffffefff), -0x1.204000001001p+48, 0x0p+0 },
{ INT64_C(0x0001204000002000), 0x1.204000002p+48, 0x0p+0 },
{ INT64_C(0xfffedfbfffffdfff), -0x1.204000002001p+48, 0x0p+0 },
{ INT64_C(0x0001204000004000), 0x1.204000004p+48, 0x0p+0 },
{ INT64_C(0xfffedfbfffffbfff), -0x1.204000004001p+48, 0x0p+0 },
{ INT64_C(0x0001204000010000), 0x1.20400001p+48, 0x0p+0 },
{ INT64_C(0xfffedfbffffeffff), -0x1.204000010001p+48, 0x0p+0 },
{ INT64_C(0x0001204000080000), 0x1.20400008p+48, 0x0p+0 },
{ INT64_C(0xfffedfbffff7ffff), -0x1.204000080001p+48, 0x0p+0 },
{ INT64_C(0x0001204000800000), 0x1.2040008p+48, 0x0p+0 },
{ INT64_C(0xfffedfbfff7fffff), -0x1.204000800001p+48, 0x0p+0 },
{ INT64_C(0x0001204008000000), 0x1.204008p+48, 0x0p+0 },
{ INT64_C(0xfffedfbff7ffffff), -0x1.204008000001p+48, 0x0p+0 },
{ INT64_C(0x0001204040000000), 0x1.20404p+48, 0x0p+0 },
{ INT64_C(0xfffedfbfbfffffff), -0x1.204040000001p+48, 0x0p+0 },
{ INT64_C(0x0001204080000000), 0x1.20408p+48, 0x0p+0 },
{ INT64_C(0xfffedfbf7fffffff), -0x1.204080000001p+48, 0x0p+0 },
{ INT64_C(0x0001204100000000), 0x1.2041p+48, 0x0p+0 },
{ INT64_C(0xfffedfbeffffffff), -0x1.204100000001p+48, 0x0p+0 },
{ INT64_C(0x0001205000000000), 0x1.205p+48, 0x0p+0 },
{ INT64_C(0xfffedfafffffffff), -0x1.205000000001p+48, 0x0p+0 },
{ INT64_C(0x0001206000000000), 0x1.206p+48, 0x0p+0 },
{ INT64_C(0xfffedf9fffffffff), -0x1.206000000001p+48, 0x0p+0 },
{ INT64_C(0x0001220000000000), 0x1.22p+48, 0x0p+0 },
{ INT64_C(0xfffeddffffffffff), -0x1.220000000001p+48, 0x0p+0 },
{ INT64_C(0x0001220000000004), 0x1.220000000004p+48, 0x0p+0 },
{ INT64_C(0xfffeddfffffffffb), -0x1.220000000005p+48, 0x0p+0 },
{ INT64_C(0x0001220000000020), 0x1.22000000002p+48, 0x0p+0 },
{ INT64_C(0xfffeddffffffffdf), -0x1.220000000021p+48, 0x0p+0 },
{ INT64_C(0x0001220000000040), 0x1.22000000004p+48, 0x0p+0 },
{ INT64_C(0xfffeddffffffffbf), -0x1.220000000041p+48, 0x0p+0 },
{ INT64_C(0x0001220000000400), 0x1.2200000004p+48, 0x0p+0 },
{ INT64_C(0xfffeddfffffffbff), -0x1.220000000401p+48, 0x0p+0 },
{ INT64_C(0x0001220000002000), 0x1.220000002p+48, 0x0p+0 },
{ INT64_C(0xfffeddffffffdfff), -0x1.220000002001p+48, 0x0p+0 },
{ INT64_C(0x0001220000008000), 0x1.220000008p+48, 0x0p+0 },
{ INT64_C(0xfffeddffffff7fff), -0x1.220000008001p+48, 0x0p+0 },
{ INT64_C(0x0001220000020000), 0x1.22000002p+48, 0x0p+0 },
{ INT64_C(0xfffeddfffffdffff), -0x1.220000020001p+48, 0x0p+0 },
{ INT64_C(0x0001220000080000), 0x1.22000008p+48, 0x0p+0 },
{ INT64_C(0xfffeddfffff7ffff), -0x1.220000080001p+48, 0x0p+0 },
{ INT64_C(0x0001220000100000), 0x1.2200001p+48, 0x0p+0 },
{ INT64_C(0xfffeddffffefffff), -0x1.220000100001p+48, 0x0p+0 },
{ INT64_C(0x0001220001000000), 0x1.220001p+48, 0x0p+0 },
{ INT64_C(0xfffeddfffeffffff), -0x1.220001000001p+48, 0x0p+0 },
{ INT64_C(0x0001220008000000), 0x1.220008p+48, 0x0p+0 },
{ INT64_C(0xfffeddfff7ffffff), -0x1.220008000001p+48, 0x0p+0 },
{ INT64_C(0x0001220020000000), 0x1.22002p+48, 0x0p+0 },
{ INT64_C(0xfffeddffdfffffff), -0x1.220020000001p+48, 0x0p+0 },
{ INT64_C(0x0001220100000000), 0x1.2201p+48, 0x0p+0 },
{ INT64_C(0xfffeddfeffffffff), -0x1.220100000001p+48, 0x0p+0 },
{ INT64_C(0x0001220200000000), 0x1.2202p+48, 0x0p+0 },
{ INT64_C(0xfffeddfdffffffff), -0x1.220200000001p+48, 0x0p+0 },
{ INT64_C(0x0001222000000000), 0x1.222p+48, 0x0p+0 },
{ INT64_C(0xfffedddfffffffff), -0x1.222000000001p+48, 0x0p+0 },
{ INT64_C(0x0001224000000000), 0x1.224p+48, 0x0p+0 },
{ INT64_C(0xfffeddbfffffffff), -0x1.224000000001p+48, 0x0p+0 },
{ INT64_C(0x0001240000000000), 0x1.24p+48, 0x0p+0 },
{ INT64_C(0xfffedbffffffffff), -0x1.240000000001p+48, 0x0p+0 },
{ INT64_C(0x0001240000000008), 0x1.240000000008p+48, 0x0p+0 },
{ INT64_C(0xfffedbfffffffff7), -0x1.240000000009p+48, 0x0p+0 },
{ INT64_C(0x0001240000000040), 0x1.24000000004p+48, 0x0p+0 },
{ INT64_C(0xfffedbffffffffbf), -0x1.240000000041p+48, 0x0p+0 },
{ INT64_C(0x0001240000000200), 0x1.2400000002p+48, 0x0p+0 },
{ INT64_C(0xfffedbfffffffdff), -0x1.240000000201p+48, 0x0p+0 },
{ INT64_C(0x0001240000001000), 0x1.240000001p+48, 0x0p+0 },
{ INT64_C(0xfffedbffffffefff), -0x1.240000001001p+48, 0x0p+0 },
{ INT64_C(0x0001240000008000), 0x1.240000008p+48, 0x0p+0 },
{ INT64_C(0xfffedbffffff7fff), -0x1.240000008001p+48, 0x0p+0 },
{ INT64_C(0x0001240000080000), 0x1.24000008p+48, 0x0p+0 },
{ INT64_C(0xfffedbfffff7ffff), -0x1.240000080001p+48, 0x0p+0 },
{ INT64_C(0x0001240000200000), 0x1.2400002p+48, 0x0p+0 },
{ INT64_C(0xfffedbffffdfffff), -0x1.240000200001p+48, 0x0p+0 },
{ INT64_C(0x0001240002000000), 0x1.240002p+48, 0x0p+0 },
{ INT64_C(0xfffedbfffdffffff), -0x1.240002000001p+48, 0x0p+0 },
{ INT64_C(0x0001240020000000), 0x1.24002p+48, 0x0p+0 },
{ INT64_C(0xfffedbffdfffffff), -0x1.240020000001p+48, 0x0p+0 },
{ INT64_C(0x0001240040000000), 0x1.24004p+48, 0x0p+0 },
{ INT64_C(0xfffedbffbfffffff), -0x1.240040000001p+48, 0x0p+0 },
{ INT64_C(0x0001240400000000), 0x1.2404p+48, 0x0p+0 },
{ INT64_C(0xfffedbfbffffffff), -0x1.240400000001p+48, 0x0p+0 },
{ INT64_C(0x0001244000000000), 0x1.244p+48, 0x0p+0 },
{ INT64_C(0xfffedbbfffffffff), -0x1.244000000001p+48, 0x0p+0 },
{ INT64_C(0x0001248000000000), 0x1.248p+48, 0x0p+0 },
{ INT64_C(0xfffedb7fffffffff), -0x1.248000000001p+48, 0x0p+0 },
{ INT64_C(0x0001400000000004), 0x1.400000000004p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffffffb), -0x1.400000000005p+48, 0x0p+0 },
{ INT64_C(0x0001400000000008), 0x1.400000000008p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffffff7), -0x1.400000000009p+48, 0x0p+0 },
{ INT64_C(0x0001400000000009), 0x1.400000000009p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffffff6), -0x1.40000000000ap+48, 0x0p+0 },
{ INT64_C(0x0001400000000040), 0x1.40000000004p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffffffbf), -0x1.400000000041p+48, 0x0p+0 },
{ INT64_C(0x0001400000000048), 0x1.400000000048p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffffffb7), -0x1.400000000049p+48, 0x0p+0 },
{ INT64_C(0x0001400000000050), 0x1.40000000005p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffffffaf), -0x1.400000000051p+48, 0x0p+0 },
{ INT64_C(0x0001400000000080), 0x1.40000000008p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffffff7f), -0x1.400000000081p+48, 0x0p+0 },
{ INT64_C(0x0001400000000088), 0x1.400000000088p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffffff77), -0x1.400000000089p+48, 0x0p+0 },
{ INT64_C(0x00014000000000c0), 0x1.4000000000cp+48, 0x0p+0 },
{ INT64_C(0xfffebfffffffff3f), -0x1.4000000000c1p+48, 0x0p+0 },
{ INT64_C(0x0001400000000800), 0x1.4000000008p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffff7ff), -0x1.400000000801p+48, 0x0p+0 },
{ INT64_C(0x0001400000000801), 0x1.400000000801p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffff7fe), -0x1.400000000802p+48, 0x0p+0 },
{ INT64_C(0x0001400000000802), 0x1.400000000802p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffff7fd), -0x1.400000000803p+48, 0x0p+0 },
{ INT64_C(0x0001400000000804), 0x1.400000000804p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffff7fb), -0x1.400000000805p+48, 0x0p+0 },
{ INT64_C(0x0001400000000808), 0x1.400000000808p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffff7f7), -0x1.400000000809p+48, 0x0p+0 },
{ INT64_C(0x0001400000000840), 0x1.40000000084p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffff7bf), -0x1.400000000841p+48, 0x0p+0 },
{ INT64_C(0x0001400000000c00), 0x1.400000000cp+48, 0x0p+0 },
{ INT64_C(0xfffebffffffff3ff), -0x1.400000000c01p+48, 0x0p+0 },
{ INT64_C(0x0001400000002000), 0x1.400000002p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffffdfff), -0x1.400000002001p+48, 0x0p+0 },
{ INT64_C(0x0001400000002002), 0x1.400000002002p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffffdffd), -0x1.400000002003p+48, 0x0p+0 },
{ INT64_C(0x0001400000002004), 0x1.400000002004p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffffdffb), -0x1.400000002005p+48, 0x0p+0 },
{ INT64_C(0x0001400000002010), 0x1.40000000201p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffffdfef), -0x1.400000002011p+48, 0x0p+0 },
{ INT64_C(0x0001400000002080), 0x1.40000000208p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffffdf7f), -0x1.400000002081p+48, 0x0p+0 },
{ INT64_C(0x0001400000002200), 0x1.4000000022p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffffddff), -0x1.400000002201p+48, 0x0p+0 },
{ INT64_C(0x0001400000020000), 0x1.40000002p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffdffff), -0x1.400000020001p+48, 0x0p+0 },
{ INT64_C(0x0001400000020002), 0x1.400000020002p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffdfffd), -0x1.400000020003p+48, 0x0p+0 },
{ INT64_C(0x0001400000020008), 0x1.400000020008p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffdfff7), -0x1.400000020009p+48, 0x0p+0 },
{ INT64_C(0x0001400000020010), 0x1.40000002001p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffdffef), -0x1.400000020011p+48, 0x0p+0 },
{ INT64_C(0x0001400000020080), 0x1.40000002008p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffdff7f), -0x1.400000020081p+48, 0x0p+0 },
{ INT64_C(0x0001400000020400), 0x1.4000000204p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffdfbff), -0x1.400000020401p+48, 0x0p+0 },
{ INT64_C(0x0001400000020800), 0x1.4000000208p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffdf7ff), -0x1.400000020801p+48, 0x0p+0 },
{ INT64_C(0x0001400000022000), 0x1.400000022p+48, 0x0p+0 },
{ INT64_C(0xfffebffffffddfff), -0x1.400000022001p+48, 0x0p+0 },
{ INT64_C(0x0001400000100000), 0x1.4000001p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffefffff), -0x1.400000100001p+48, 0x0p+0 },
{ INT64_C(0x0001400000100004), 0x1.400000100004p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffeffffb), -0x1.400000100005p+48, 0x0p+0 },
{ INT64_C(0x0001400000100008), 0x1.400000100008p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffeffff7), -0x1.400000100009p+48, 0x0p+0 },
{ INT64_C(0x0001400000100080), 0x1.40000010008p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffefff7f), -0x1.400000100081p+48, 0x0p+0 },
{ INT64_C(0x0001400000100100), 0x1.4000001001p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffeffeff), -0x1.400000100101p+48, 0x0p+0 },
{ INT64_C(0x0001400000100400), 0x1.4000001004p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffeffbff), -0x1.400000100401p+48, 0x0p+0 },
{ INT64_C(0x0001400000102000), 0x1.400000102p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffefdfff), -0x1.400000102001p+48, 0x0p+0 },
{ INT64_C(0x0001400000110000), 0x1.40000011p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffeeffff), -0x1.400000110001p+48, 0x0p+0 },
{ INT64_C(0x0001400000120000), 0x1.40000012p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffedffff), -0x1.400000120001p+48, 0x0p+0 },
{ INT64_C(0x0001400000140000), 0x1.40000014p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffebffff), -0x1.400000140001p+48, 0x0p+0 },
{ INT64_C(0x0001400000200000), 0x1.4000002p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffdfffff), -0x1.400000200001p+48, 0x0p+0 },
{ INT64_C(0x0001400000200002), 0x1.400000200002p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffdffffd), -0x1.400000200003p+48, 0x0p+0 },
{ INT64_C(0x0001400000200008), 0x1.400000200008p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffdffff7), -0x1.400000200009p+48, 0x0p+0 },
{ INT64_C(0x0001400000200020), 0x1.40000020002p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffdfffdf), -0x1.400000200021p+48, 0x0p+0 },
{ INT64_C(0x0001400000200040), 0x1.40000020004p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffdfffbf), -0x1.400000200041p+48, 0x0p+0 },
{ INT64_C(0x0001400000200080), 0x1.40000020008p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffdfff7f), -0x1.400000200081p+48, 0x0p+0 },
{ INT64_C(0x0001400000200400), 0x1.4000002004p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffdffbff), -0x1.400000200401p+48, 0x0p+0 },
{ INT64_C(0x0001400000201000), 0x1.400000201p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffdfefff), -0x1.400000201001p+48, 0x0p+0 },
{ INT64_C(0x0001400000202000), 0x1.400000202p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffdfdfff), -0x1.400000202001p+48, 0x0p+0 },
{ INT64_C(0x0001400000210000), 0x1.40000021p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffdeffff), -0x1.400000210001p+48, 0x0p+0 },
{ INT64_C(0x0001400000240000), 0x1.40000024p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffdbffff), -0x1.400000240001p+48, 0x0p+0 },
{ INT64_C(0x0001400000280000), 0x1.40000028p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffd7ffff), -0x1.400000280001p+48, 0x0p+0 },
{ INT64_C(0x0001400000400000), 0x1.4000004p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffbfffff), -0x1.400000400001p+48, 0x0p+0 },
{ INT64_C(0x0001400000400004), 0x1.400000400004p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffbffffb), -0x1.400000400005p+48, 0x0p+0 },
{ INT64_C(0x0001400000400020), 0x1.40000040002p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffbfffdf), -0x1.400000400021p+48, 0x0p+0 },
{ INT64_C(0x0001400000400080), 0x1.40000040008p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffbfff7f), -0x1.400000400081p+48, 0x0p+0 },
{ INT64_C(0x0001400000400400), 0x1.4000004004p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffbffbff), -0x1.400000400401p+48, 0x0p+0 },
{ INT64_C(0x0001400000404000), 0x1.400000404p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffbfbfff), -0x1.400000404001p+48, 0x0p+0 },
{ INT64_C(0x0001400000408000), 0x1.400000408p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffbf7fff), -0x1.400000408001p+48, 0x0p+0 },
{ INT64_C(0x0001400000420000), 0x1.40000042p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffbdffff), -0x1.400000420001p+48, 0x0p+0 },
{ INT64_C(0x0001400000440000), 0x1.40000044p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffbbffff), -0x1.400000440001p+48, 0x0p+0 },
{ INT64_C(0x0001400000500000), 0x1.4000005p+48, 0x0p+0 },
{ INT64_C(0xfffebfffffafffff), -0x1.400000500001p+48, 0x0p+0 },
{ INT64_C(0x0001400001000000), 0x1.400001p+48, 0x0p+0 },
{ INT64_C(0xfffebffffeffffff), -0x1.400001000001p+48, 0x0p+0 },
{ INT64_C(0x0001400001000008), 0x1.400001000008p+48, 0x0p+0 },
{ INT64_C(0xfffebffffefffff7), -0x1.400001000009p+48, 0x0p+0 },
{ INT64_C(0x0001400001000040), 0x1.40000100004p+48, 0x0p+0 },
{ INT64_C(0xfffebffffeffffbf), -0x1.400001000041p+48, 0x0p+0 },
{ INT64_C(0x0001400001000100), 0x1.4000010001p+48, 0x0p+0 },
{ INT64_C(0xfffebffffefffeff), -0x1.400001000101p+48, 0x0p+0 },
{ INT64_C(0x0001400001000800), 0x1.4000010008p+48, 0x0p+0 },
{ INT64_C(0xfffebffffefff7ff), -0x1.400001000801p+48, 0x0p+0 },
{ INT64_C(0x0001400001001000), 0x1.400001001p+48, 0x0p+0 },
{ INT64_C(0xfffebffffeffefff), -0x1.400001001001p+48, 0x0p+0 },
{ INT64_C(0x0001400001004000), 0x1.400001004p+48, 0x0p+0 },
{ INT64_C(0xfffebffffeffbfff), -0x1.400001004001p+48, 0x0p+0 },
{ INT64_C(0x0001400001020000), 0x1.40000102p+48, 0x0p+0 },
{ INT64_C(0xfffebffffefdffff), -0x1.400001020001p+48, 0x0p+0 },
{ INT64_C(0x0001400001040000), 0x1.40000104p+48, 0x0p+0 },
{ INT64_C(0xfffebffffefbffff), -0x1.400001040001p+48, 0x0p+0 },
{ INT64_C(0x0001400001100000), 0x1.4000011p+48, 0x0p+0 },
{ INT64_C(0xfffebffffeefffff), -0x1.400001100001p+48, 0x0p+0 },
{ INT64_C(0x0001400001800000), 0x1.4000018p+48, 0x0p+0 },
{ INT64_C(0xfffebffffe7fffff), -0x1.400001800001p+48, 0x0p+0 },
{ INT64_C(0x0001400008000000), 0x1.400008p+48, 0x0p+0 },
{ INT64_C(0xfffebffff7ffffff), -0x1.400008000001p+48, 0x0p+0 },
{ INT64_C(0x0001400008000004), 0x1.400008000004p+48, 0x0p+0 },
{ INT64_C(0xfffebffff7fffffb), -0x1.400008000005p+48, 0x0p+0 },
{ INT64_C(0x0001400008000040), 0x1.40000800004p+48, 0x0p+0 },
{ INT64_C(0xfffebffff7ffffbf), -0x1.400008000041p+48, 0x0p+0 },
{ INT64_C(0x0001400008000200), 0x1.4000080002p+48, 0x0p+0 },
{ INT64_C(0xfffebffff7fffdff), -0x1.400008000201p+48, 0x0p+0 },
{ INT64_C(0x0001400008002000), 0x1.400008002p+48, 0x0p+0 },
{ INT64_C(0xfffebffff7ffdfff), -0x1.400008002001p+48, 0x0p+0 },
{ INT64_C(0x0001400008004000), 0x1.400008004p+48, 0x0p+0 },
{ INT64_C(0xfffebffff7ffbfff), -0x1.400008004001p+48, 0x0p+0 },
{ INT64_C(0x0001400008020000), 0x1.40000802p+48, 0x0p+0 },
{ INT64_C(0xfffebffff7fdffff), -0x1.400008020001p+48, 0x0p+0 },
{ INT64_C(0x0001400008100000), 0x1.4000081p+48, 0x0p+0 },
{ INT64_C(0xfffebffff7efffff), -0x1.400008100001p+48, 0x0p+0 },
{ INT64_C(0x0001400008400000), 0x1.4000084p+48, 0x0p+0 },
{ INT64_C(0xfffebffff7bfffff), -0x1.400008400001p+48, 0x0p+0 },
{ INT64_C(0x0001400008800000), 0x1.4000088p+48, 0x0p+0 },
{ INT64_C(0xfffebffff77fffff), -0x1.400008800001p+48, 0x0p+0 },
{ INT64_C(0x0001400009000000), 0x1.400009p+48, 0x0p+0 },
{ INT64_C(0xfffebffff6ffffff), -0x1.400009000001p+48, 0x0p+0 },
{ INT64_C(0x0001400080000000), 0x1.40008p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7fffffff), -0x1.400080000001p+48, 0x0p+0 },
{ INT64_C(0x0001400080000001), 0x1.400080000001p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7ffffffe), -0x1.400080000002p+48, 0x0p+0 },
{ INT64_C(0x0001400080000008), 0x1.400080000008p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7ffffff7), -0x1.400080000009p+48, 0x0p+0 },
{ INT64_C(0x0001400080000020), 0x1.40008000002p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7fffffdf), -0x1.400080000021p+48, 0x0p+0 },
{ INT64_C(0x0001400080000040), 0x1.40008000004p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7fffffbf), -0x1.400080000041p+48, 0x0p+0 },
{ INT64_C(0x0001400080000200), 0x1.4000800002p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7ffffdff), -0x1.400080000201p+48, 0x0p+0 },
{ INT64_C(0x0001400080000800), 0x1.4000800008p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7ffff7ff), -0x1.400080000801p+48, 0x0p+0 },
{ INT64_C(0x0001400080004000), 0x1.400080004p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7fffbfff), -0x1.400080004001p+48, 0x0p+0 },
{ INT64_C(0x0001400080010000), 0x1.40008001p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7ffeffff), -0x1.400080010001p+48, 0x0p+0 },
{ INT64_C(0x0001400080020000), 0x1.40008002p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7ffdffff), -0x1.400080020001p+48, 0x0p+0 },
{ INT64_C(0x0001400080100000), 0x1.4000801p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7fefffff), -0x1.400080100001p+48, 0x0p+0 },
{ INT64_C(0x0001400080400000), 0x1.4000804p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7fbfffff), -0x1.400080400001p+48, 0x0p+0 },
{ INT64_C(0x0001400081000000), 0x1.400081p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7effffff), -0x1.400081000001p+48, 0x0p+0 },
{ INT64_C(0x0001400084000000), 0x1.400084p+48, 0x0p+0 },
{ INT64_C(0xfffebfff7bffffff), -0x1.400084000001p+48, 0x0p+0 },
{ INT64_C(0x0001400090000000), 0x1.40009p+48, 0x0p+0 },
{ INT64_C(0xfffebfff6fffffff), -0x1.400090000001p+48, 0x0p+0 },
{ INT64_C(0x00014000a0000000), 0x1.4000ap+48, 0x0p+0 },
{ INT64_C(0xfffebfff5fffffff), -0x1.4000a0000001p+48, 0x0p+0 },
{ INT64_C(0x0001400800000000), 0x1.4008p+48, 0x0p+0 },
{ INT64_C(0xfffebff7ffffffff), -0x1.400800000001p+48, 0x0p+0 },
{ INT64_C(0x0001400800000004), 0x1.400800000004p+48, 0x0p+0 },
{ INT64_C(0xfffebff7fffffffb), -0x1.400800000005p+48, 0x0p+0 },
{ INT64_C(0x0001400800000010), 0x1.40080000001p+48, 0x0p+0 },
{ INT64_C(0xfffebff7ffffffef), -0x1.400800000011p+48, 0x0p+0 },
{ INT64_C(0x0001400800000080), 0x1.40080000008p+48, 0x0p+0 },
{ INT64_C(0xfffebff7ffffff7f), -0x1.400800000081p+48, 0x0p+0 },
{ INT64_C(0x0001400800000100), 0x1.4008000001p+48, 0x0p+0 },
{ INT64_C(0xfffebff7fffffeff), -0x1.400800000101p+48, 0x0p+0 },
{ INT64_C(0x0001400800000200), 0x1.4008000002p+48, 0x0p+0 },
{ INT64_C(0xfffebff7fffffdff), -0x1.400800000201p+48, 0x0p+0 },
{ INT64_C(0x0001400800002000), 0x1.400800002p+48, 0x0p+0 },
{ INT64_C(0xfffebff7ffffdfff), -0x1.400800002001p+48, 0x0p+0 },
{ INT64_C(0x0001400800020000), 0x1.40080002p+48, 0x0p+0 },
{ INT64_C(0xfffebff7fffdffff), -0x1.400800020001p+48, 0x0p+0 },
{ INT64_C(0x0001400800080000), 0x1.40080008p+48, 0x0p+0 },
{ INT64_C(0xfffebff7fff7ffff), -0x1.400800080001p+48, 0x0p+0 },
{ INT64_C(0x0001400800800000), 0x1.4008008p+48, 0x0p+0 },
{ INT64_C(0xfffebff7ff7fffff), -0x1.400800800001p+48, 0x0p+0 },
{ INT64_C(0x0001400804000000), 0x1.400804p+48, 0x0p+0 },
{ INT64_C(0xfffebff7fbffffff), -0x1.400804000001p+48, 0x0p+0 },
{ INT64_C(0x0001400810000000), 0x1.40081p+48, 0x0p+0 },
{ INT64_C(0xfffebff7efffffff), -0x1.400810000001p+48, 0x0p+0 },
{ INT64_C(0x0001400880000000), 0x1.40088p+48, 0x0p+0 },
{ INT64_C(0xfffebff77fffffff), -0x1.400880000001p+48, 0x0p+0 },
{ INT64_C(0x0001400c00000000), 0x1.400cp+48, 0x0p+0 },
{ INT64_C(0xfffebff3ffffffff), -0x1.400c00000001p+48, 0x0p+0 },
{ INT64_C(0x0001404000000000), 0x1.404p+48, 0x0p+0 },
{ INT64_C(0xfffebfbfffffffff), -0x1.404000000001p+48, 0x0p+0 },
{ INT64_C(0x0001404000000001), 0x1.404000000001p+48, 0x0p+0 },
{ INT64_C(0xfffebfbffffffffe), -0x1.404000000002p+48, 0x0p+0 },
{ INT64_C(0x0001404000000002), 0x1.404000000002p+48, 0x0p+0 },
{ INT64_C(0xfffebfbffffffffd), -0x1.404000000003p+48, 0x0p+0 },
{ INT64_C(0x0001404000000010), 0x1.40400000001p+48, 0x0p+0 },
{ INT64_C(0xfffebfbfffffffef), -0x1.404000000011p+48, 0x0p+0 },
{ INT64_C(0x0001404000000100), 0x1.4040000001p+48, 0x0p+0 },
{ INT64_C(0xfffebfbffffffeff), -0x1.404000000101p+48, 0x0p+0 },
{ INT64_C(0x0001404000000200), 0x1.4040000002p+48, 0x0p+0 },
{ INT64_C(0xfffebfbffffffdff), -0x1.404000000201p+48, 0x0p+0 },
{ INT64_C(0x0001404000000800), 0x1.4040000008p+48, 0x0p+0 },
{ INT64_C(0xfffebfbffffff7ff), -0x1.404000000801p+48, 0x0p+0 },
{ INT64_C(0x0001404000001000), 0x1.404000001p+48, 0x0p+0 },
{ INT64_C(0xfffebfbfffffefff), -0x1.404000001001p+48, 0x0p+0 },
{ INT64_C(0x0001404000010000), 0x1.40400001p+48, 0x0p+0 },
{ INT64_C(0xfffebfbffffeffff), -0x1.404000010001p+48, 0x0p+0 },
{ INT64_C(0x0001404000020000), 0x1.40400002p+48, 0x0p+0 },
{ INT64_C(0xfffebfbffffdffff), -0x1.404000020001p+48, 0x0p+0 },
{ INT64_C(0x0001404000040000), 0x1.40400004p+48, 0x0p+0 },
{ INT64_C(0xfffebfbffffbffff), -0x1.404000040001p+48, 0x0p+0 },
{ INT64_C(0x0001404000100000), 0x1.4040001p+48, 0x0p+0 },
{ INT64_C(0xfffebfbfffefffff), -0x1.404000100001p+48, 0x0p+0 },
{ INT64_C(0x0001404001000000), 0x1.404001p+48, 0x0p+0 },
{ INT64_C(0xfffebfbffeffffff), -0x1.404001000001p+48, 0x0p+0 },
{ INT64_C(0x0001404002000000), 0x1.404002p+48, 0x0p+0 },
{ INT64_C(0xfffebfbffdffffff), -0x1.404002000001p+48, 0x0p+0 },
{ INT64_C(0x0001404004000000), 0x1.404004p+48, 0x0p+0 },
{ INT64_C(0xfffebfbffbffffff), -0x1.404004000001p+48, 0x0p+0 },
{ INT64_C(0x0001404040000000), 0x1.40404p+48, 0x0p+0 },
{ INT64_C(0xfffebfbfbfffffff), -0x1.404040000001p+48, 0x0p+0 },
{ INT64_C(0x0001404080000000), 0x1.40408p+48, 0x0p+0 },
{ INT64_C(0xfffebfbf7fffffff), -0x1.404080000001p+48, 0x0p+0 },
{ INT64_C(0x0001404400000000), 0x1.4044p+48, 0x0p+0 },
{ INT64_C(0xfffebfbbffffffff), -0x1.404400000001p+48, 0x0p+0 },
{ INT64_C(0x0001406000000000), 0x1.406p+48, 0x0p+0 },
{ INT64_C(0xfffebf9fffffffff), -0x1.406000000001p+48, 0x0p+0 },
{ INT64_C(0x0001410000000000), 0x1.41p+48, 0x0p+0 },
{ INT64_C(0xfffebeffffffffff), -0x1.410000000001p+48, 0x0p+0 },
{ INT64_C(0x0001410000000004), 0x1.410000000004p+48, 0x0p+0 },
{ INT64_C(0xfffebefffffffffb), -0x1.410000000005p+48, 0x0p+0 },
{ INT64_C(0x0001410000000010), 0x1.41000000001p+48, 0x0p+0 },
{ INT64_C(0xfffebeffffffffef), -0x1.410000000011p+48, 0x0p+0 },
{ INT64_C(0x0001410000000080), 0x1.41000000008p+48, 0x0p+0 },
{ INT64_C(0xfffebeffffffff7f), -0x1.410000000081p+48, 0x0p+0 },
{ INT64_C(0x0001410000000400), 0x1.4100000004p+48, 0x0p+0 },
{ INT64_C(0xfffebefffffffbff), -0x1.410000000401p+48, 0x0p+0 },
{ INT64_C(0x0001410000000800), 0x1.4100000008p+48, 0x0p+0 },
{ INT64_C(0xfffebefffffff7ff), -0x1.410000000801p+48, 0x0p+0 },
{ INT64_C(0x0001410000001000), 0x1.410000001p+48, 0x0p+0 },
{ INT64_C(0xfffebeffffffefff), -0x1.410000001001p+48, 0x0p+0 },
{ INT64_C(0x0001410000008000), 0x1.410000008p+48, 0x0p+0 },
{ INT64_C(0xfffebeffffff7fff), -0x1.410000008001p+48, 0x0p+0 },
{ INT64_C(0x0001410000080000), 0x1.41000008p+48, 0x0p+0 },
{ INT64_C(0xfffebefffff7ffff), -0x1.410000080001p+48, 0x0p+0 },
{ INT64_C(0x0001410000800000), 0x1.4100008p+48, 0x0p+0 },
{ INT64_C(0xfffebeffff7fffff), -0x1.410000800001p+48, 0x0p+0 },
{ INT64_C(0x0001410008000000), 0x1.410008p+48, 0x0p+0 },
{ INT64_C(0xfffebefff7ffffff), -0x1.410008000001p+48, 0x0p+0 },
{ INT64_C(0x0001410080000000), 0x1.41008p+48, 0x0p+0 },
{ INT64_C(0xfffebeff7fffffff), -0x1.410080000001p+48, 0x0p+0 },
{ INT64_C(0x0001410200000000), 0x1.4102p+48, 0x0p+0 },
{ INT64_C(0xfffebefdffffffff), -0x1.410200000001p+48, 0x0p+0 },
{ INT64_C(0x0001410400000000), 0x1.4104p+48, 0x0p+0 },
{ INT64_C(0xfffebefbffffffff), -0x1.410400000001p+48, 0x0p+0 },
{ INT64_C(0x0001411000000000), 0x1.411p+48, 0x0p+0 },
{ INT64_C(0xfffebeefffffffff), -0x1.411000000001p+48, 0x0p+0 },
{ INT64_C(0x0001480000000000), 0x1.48p+48, 0x0p+0 },
{ INT64_C(0xfffeb7ffffffffff), -0x1.480000000001p+48, 0x0p+0 },
{ INT64_C(0x0001480000000002), 0x1.480000000002p+48, 0x0p+0 },
{ INT64_C(0xfffeb7fffffffffd), -0x1.480000000003p+48, 0x0p+0 },
{ INT64_C(0x0001480000000004), 0x1.480000000004p+48, 0x0p+0 },
{ INT64_C(0xfffeb7fffffffffb), -0x1.480000000005p+48, 0x0p+0 },
{ INT64_C(0x0001480000000010), 0x1.48000000001p+48, 0x0p+0 },
{ INT64_C(0xfffeb7ffffffffef), -0x1.480000000011p+48, 0x0p+0 },
{ INT64_C(0x0001480000000020), 0x1.48000000002p+48, 0x0p+0 },
{ INT64_C(0xfffeb7ffffffffdf), -0x1.480000000021p+48, 0x0p+0 },
{ INT64_C(0x0001480000000080), 0x1.48000000008p+48, 0x0p+0 },
{ INT64_C(0xfffeb7ffffffff7f), -0x1.480000000081p+48, 0x0p+0 },
{ INT64_C(0x0001480000000200), 0x1.4800000002p+48, 0x0p+0 },
{ INT64_C(0xfffeb7fffffffdff), -0x1.480000000201p+48, 0x0p+0 },
{ INT64_C(0x0001480000000400), 0x1.4800000004p+48, 0x0p+0 },
{ INT64_C(0xfffeb7fffffffbff), -0x1.480000000401p+48, 0x0p+0 },
{ INT64_C(0x0001480000004000), 0x1.480000004p+48, 0x0p+0 },
{ INT64_C(0xfffeb7ffffffbfff), -0x1.480000004001p+48, 0x0p+0 },
{ INT64_C(0x0001480000020000), 0x1.48000002p+48, 0x0p+0 },
{ INT64_C(0xfffeb7fffffdffff), -0x1.480000020001p+48, 0x0p+0 },
{ INT64_C(0x0001480000200000), 0x1.4800002p+48, 0x0p+0 },
{ INT64_C(0xfffeb7ffffdfffff), -0x1.480000200001p+48, 0x0p+0 },
{ INT64_C(0x0001480002000000), 0x1.480002p+48, 0x0p+0 },
{ INT64_C(0xfffeb7fffdffffff), -0x1.480002000001p+48, 0x0p+0 },
{ INT64_C(0x0001480020000000), 0x1.48002p+48, 0x0p+0 },
{ INT64_C(0xfffeb7ffdfffffff), -0x1.480020000001p+48, 0x0p+0 },
{ INT64_C(0x0001480200000000), 0x1.4802p+48, 0x0p+0 },
{ INT64_C(0xfffeb7fdffffffff), -0x1.480200000001p+48, 0x0p+0 },
{ INT64_C(0x0001480400000000), 0x1.4804p+48, 0x0p+0 },
{ INT64_C(0xfffeb7fbffffffff), -0x1.480400000001p+48, 0x0p+0 },
{ INT64_C(0x0001480800000000), 0x1.4808p+48, 0x0p+0 },
{ INT64_C(0xfffeb7f7ffffffff), -0x1.480800000001p+48, 0x0p+0 },
{ INT64_C(0x0001482000000000), 0x1.482p+48, 0x0p+0 },
{ INT64_C(0xfffeb7dfffffffff), -0x1.482000000001p+48, 0x0p+0 },
{ INT64_C(0x0001488000000000), 0x1.488p+48, 0x0p+0 },
{ INT64_C(0xfffeb77fffffffff), -0x1.488000000001p+48, 0x0p+0 },
{ INT64_C(0x0001490000000000), 0x1.49p+48, 0x0p+0 },
{ INT64_C(0xfffeb6ffffffffff), -0x1.490000000001p+48, 0x0p+0 },
{ INT64_C(0x0001600000000000), 0x1.6p+48, 0x0p+0 },
{ INT64_C(0xfffe9fffffffffff), -0x1.600000000001p+48, 0x0p+0 },
{ INT64_C(0x0001600000000008), 0x1.600000000008p+48, 0x0p+0 },
{ INT64_C(0xfffe9ffffffffff7), -0x1.600000000009p+48, 0x0p+0 },
{ INT64_C(0x0001600000000020), 0x1.60000000002p+48, 0x0p+0 },
{ INT64_C(0xfffe9fffffffffdf), -0x1.600000000021p+48, 0x0p+0 },
{ INT64_C(0x0001600000000040), 0x1.60000000004p+48, 0x0p+0 },
{ INT64_C(0xfffe9fffffffffbf), -0x1.600000000041p+48, 0x0p+0 },
{ INT64_C(0x0001600000000100), 0x1.6000000001p+48, 0x0p+0 },
{ INT64_C(0xfffe9ffffffffeff), -0x1.600000000101p+48, 0x0p+0 },
{ INT64_C(0x0001600000001000), 0x1.600000001p+48, 0x0p+0 },
{ INT64_C(0xfffe9fffffffefff), -0x1.600000001001p+48, 0x0p+0 },
{ INT64_C(0x0001600000002000), 0x1.600000002p+48, 0x0p+0 },
{ INT64_C(0xfffe9fffffffdfff), -0x1.600000002001p+48, 0x0p+0 },
{ INT64_C(0x0001600000008000), 0x1.600000008p+48, 0x0p+0 },
{ INT64_C(0xfffe9fffffff7fff), -0x1.600000008001p+48, 0x0p+0 },
{ INT64_C(0x0001600000040000), 0x1.60000004p+48, 0x0p+0 },
{ INT64_C(0xfffe9ffffffbffff), -0x1.600000040001p+48, 0x0p+0 },
{ INT64_C(0x0001600000400000), 0x1.6000004p+48, 0x0p+0 },
{ INT64_C(0xfffe9fffffbfffff), -0x1.600000400001p+48, 0x0p+0 },
{ INT64_C(0x0001600001000000), 0x1.600001p+48, 0x0p+0 },
{ INT64_C(0xfffe9ffffeffffff), -0x1.600001000001p+48, 0x0p+0 },
{ INT64_C(0x0001600002000000), 0x1.600002p+48, 0x0p+0 },
{ INT64_C(0xfffe9ffffdffffff), -0x1.600002000001p+48, 0x0p+0 },
{ INT64_C(0x0001600008000000), 0x1.600008p+48, 0x0p+0 },
{ INT64_C(0xfffe9ffff7ffffff), -0x1.600008000001p+48, 0x0p+0 },
{ INT64_C(0x0001600020000000), 0x1.60002p+48, 0x0p+0 },
{ INT64_C(0xfffe9fffdfffffff), -0x1.600020000001p+48, 0x0p+0 },
{ INT64_C(0x0001600040000000), 0x1.60004p+48, 0x0p+0 },
{ INT64_C(0xfffe9fffbfffffff), -0x1.600040000001p+48, 0x0p+0 },
{ INT64_C(0x0001600200000000), 0x1.6002p+48, 0x0p+0 },
{ INT64_C(0xfffe9ffdffffffff), -0x1.600200000001p+48, 0x0p+0 },
{ INT64_C(0x0001600800000000), 0x1.6008p+48, 0x0p+0 },
{ INT64_C(0xfffe9ff7ffffffff), -0x1.600800000001p+48, 0x0p+0 },
{ INT64_C(0x0001601000000000), 0x1.601p+48, 0x0p+0 },
{ INT64_C(0xfffe9fefffffffff), -0x1.601000000001p+48, 0x0p+0 },
{ INT64_C(0x0001604000000000), 0x1.604p+48, 0x0p+0 },
{ INT64_C(0xfffe9fbfffffffff), -0x1.604000000001p+48, 0x0p+0 },
{ INT64_C(0x0001610000000000), 0x1.61p+48, 0x0p+0 },
{ INT64_C(0xfffe9effffffffff), -0x1.610000000001p+48, 0x0p+0 },
{ INT64_C(0x0001680000000000), 0x1.68p+48, 0x0p+0 },
{ INT64_C(0xfffe97ffffffffff), -0x1.680000000001p+48, 0x0p+0 },
{ INT64_C(0x0001700000000000), 0x1.7p+48, 0x0p+0 },
{ INT64_C(0xfffe8fffffffffff), -0x1.700000000001p+48, 0x0p+0 },
{ INT64_C(0x0001800000000004), 0x1.800000000004p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffffffffb), -0x1.800000000005p+48, 0x0p+0 },
{ INT64_C(0x0001800000000010), 0x1.80000000001p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffffffef), -0x1.800000000011p+48, 0x0p+0 },
{ INT64_C(0x0001800000000018), 0x1.800000000018p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffffffe7), -0x1.800000000019p+48, 0x0p+0 },
{ INT64_C(0x0001800000000100), 0x1.8000000001p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffffffeff), -0x1.800000000101p+48, 0x0p+0 },
{ INT64_C(0x0001800000000104), 0x1.800000000104p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffffffefb), -0x1.800000000105p+48, 0x0p+0 },
{ INT64_C(0x0001800000000110), 0x1.80000000011p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffffffeef), -0x1.800000000111p+48, 0x0p+0 },
{ INT64_C(0x0001800000000120), 0x1.80000000012p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffffffedf), -0x1.800000000121p+48, 0x0p+0 },
{ INT64_C(0x0001800000001000), 0x1.800000001p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffffefff), -0x1.800000001001p+48, 0x0p+0 },
{ INT64_C(0x0001800000001002), 0x1.800000001002p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffffeffd), -0x1.800000001003p+48, 0x0p+0 },
{ INT64_C(0x0001800000001020), 0x1.80000000102p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffffefdf), -0x1.800000001021p+48, 0x0p+0 },
{ INT64_C(0x0001800000001080), 0x1.80000000108p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffffef7f), -0x1.800000001081p+48, 0x0p+0 },
{ INT64_C(0x0001800000001100), 0x1.8000000011p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffffeeff), -0x1.800000001101p+48, 0x0p+0 },
{ INT64_C(0x0001800000001200), 0x1.8000000012p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffffedff), -0x1.800000001201p+48, 0x0p+0 },
{ INT64_C(0x0001800000001800), 0x1.8000000018p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffffe7ff), -0x1.800000001801p+48, 0x0p+0 },
{ INT64_C(0x0001800000010000), 0x1.80000001p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffffeffff), -0x1.800000010001p+48, 0x0p+0 },
{ INT64_C(0x0001800000010008), 0x1.800000010008p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffffefff7), -0x1.800000010009p+48, 0x0p+0 },
{ INT64_C(0x0001800000010010), 0x1.80000001001p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffffeffef), -0x1.800000010011p+48, 0x0p+0 },
{ INT64_C(0x0001800000010080), 0x1.80000001008p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffffeff7f), -0x1.800000010081p+48, 0x0p+0 },
{ INT64_C(0x0001800000010800), 0x1.8000000108p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffffef7ff), -0x1.800000010801p+48, 0x0p+0 },
{ INT64_C(0x0001800000011000), 0x1.800000011p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffffeefff), -0x1.800000011001p+48, 0x0p+0 },
{ INT64_C(0x0001800000018000), 0x1.800000018p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffffe7fff), -0x1.800000018001p+48, 0x0p+0 },
{ INT64_C(0x0001800000080000), 0x1.80000008p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffff7ffff), -0x1.800000080001p+48, 0x0p+0 },
{ INT64_C(0x0001800000080002), 0x1.800000080002p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffff7fffd), -0x1.800000080003p+48, 0x0p+0 },
{ INT64_C(0x0001800000080020), 0x1.80000008002p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffff7ffdf), -0x1.800000080021p+48, 0x0p+0 },
{ INT64_C(0x0001800000080040), 0x1.80000008004p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffff7ffbf), -0x1.800000080041p+48, 0x0p+0 },
{ INT64_C(0x0001800000080200), 0x1.8000000802p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffff7fdff), -0x1.800000080201p+48, 0x0p+0 },
{ INT64_C(0x0001800000082000), 0x1.800000082p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffff7dfff), -0x1.800000082001p+48, 0x0p+0 },
{ INT64_C(0x0001800000090000), 0x1.80000009p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffff6ffff), -0x1.800000090001p+48, 0x0p+0 },
{ INT64_C(0x00018000000a0000), 0x1.8000000ap+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffff5ffff), -0x1.8000000a0001p+48, 0x0p+0 },
{ INT64_C(0x00018000000c0000), 0x1.8000000cp+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffff3ffff), -0x1.8000000c0001p+48, 0x0p+0 },
{ INT64_C(0x0001800000400000), 0x1.8000004p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffbfffff), -0x1.800000400001p+48, 0x0p+0 },
{ INT64_C(0x0001800000400002), 0x1.800000400002p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffbffffd), -0x1.800000400003p+48, 0x0p+0 },
{ INT64_C(0x0001800000400004), 0x1.800000400004p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffbffffb), -0x1.800000400005p+48, 0x0p+0 },
{ INT64_C(0x0001800000400020), 0x1.80000040002p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffbfffdf), -0x1.800000400021p+48, 0x0p+0 },
{ INT64_C(0x0001800000400040), 0x1.80000040004p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffbfffbf), -0x1.800000400041p+48, 0x0p+0 },
{ INT64_C(0x0001800000400100), 0x1.8000004001p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffbffeff), -0x1.800000400101p+48, 0x0p+0 },
{ INT64_C(0x0001800000401000), 0x1.800000401p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffbfefff), -0x1.800000401001p+48, 0x0p+0 },
{ INT64_C(0x0001800000404000), 0x1.800000404p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffbfbfff), -0x1.800000404001p+48, 0x0p+0 },
{ INT64_C(0x0001800000440000), 0x1.80000044p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffffbbffff), -0x1.800000440001p+48, 0x0p+0 },
{ INT64_C(0x0001800000600000), 0x1.8000006p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffff9fffff), -0x1.800000600001p+48, 0x0p+0 },
{ INT64_C(0x0001800004000000), 0x1.800004p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffbffffff), -0x1.800004000001p+48, 0x0p+0 },
{ INT64_C(0x0001800004000008), 0x1.800004000008p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffbfffff7), -0x1.800004000009p+48, 0x0p+0 },
{ INT64_C(0x0001800004000080), 0x1.80000400008p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffbffff7f), -0x1.800004000081p+48, 0x0p+0 },
{ INT64_C(0x0001800004000400), 0x1.8000040004p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffbfffbff), -0x1.800004000401p+48, 0x0p+0 },
{ INT64_C(0x0001800004004000), 0x1.800004004p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffbffbfff), -0x1.800004004001p+48, 0x0p+0 },
{ INT64_C(0x0001800004040000), 0x1.80000404p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffbfbffff), -0x1.800004040001p+48, 0x0p+0 },
{ INT64_C(0x0001800004400000), 0x1.8000044p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffffbbfffff), -0x1.800004400001p+48, 0x0p+0 },
{ INT64_C(0x0001800008000000), 0x1.800008p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffff7ffffff), -0x1.800008000001p+48, 0x0p+0 },
{ INT64_C(0x0001800008000001), 0x1.800008000001p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffff7fffffe), -0x1.800008000002p+48, 0x0p+0 },
{ INT64_C(0x0001800008000004), 0x1.800008000004p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffff7fffffb), -0x1.800008000005p+48, 0x0p+0 },
{ INT64_C(0x0001800008000020), 0x1.80000800002p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffff7ffffdf), -0x1.800008000021p+48, 0x0p+0 },
{ INT64_C(0x0001800008000100), 0x1.8000080001p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffff7fffeff), -0x1.800008000101p+48, 0x0p+0 },
{ INT64_C(0x0001800008000400), 0x1.8000080004p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffff7fffbff), -0x1.800008000401p+48, 0x0p+0 },
{ INT64_C(0x0001800008000800), 0x1.8000080008p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffff7fff7ff), -0x1.800008000801p+48, 0x0p+0 },
{ INT64_C(0x0001800008004000), 0x1.800008004p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffff7ffbfff), -0x1.800008004001p+48, 0x0p+0 },
{ INT64_C(0x0001800008010000), 0x1.80000801p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffff7feffff), -0x1.800008010001p+48, 0x0p+0 },
{ INT64_C(0x0001800008080000), 0x1.80000808p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffff7f7ffff), -0x1.800008080001p+48, 0x0p+0 },
{ INT64_C(0x0001800008200000), 0x1.8000082p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffff7dfffff), -0x1.800008200001p+48, 0x0p+0 },
{ INT64_C(0x000180000a000000), 0x1.80000ap+48, 0x0p+0 },
{ INT64_C(0xfffe7ffff5ffffff), -0x1.80000a000001p+48, 0x0p+0 },
{ INT64_C(0x0001800020000000), 0x1.80002p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffdfffffff), -0x1.800020000001p+48, 0x0p+0 },
{ INT64_C(0x0001800020000008), 0x1.800020000008p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffdffffff7), -0x1.800020000009p+48, 0x0p+0 },
{ INT64_C(0x0001800020000020), 0x1.80002000002p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffdfffffdf), -0x1.800020000021p+48, 0x0p+0 },
{ INT64_C(0x0001800020000040), 0x1.80002000004p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffdfffffbf), -0x1.800020000041p+48, 0x0p+0 },
{ INT64_C(0x0001800020000080), 0x1.80002000008p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffdfffff7f), -0x1.800020000081p+48, 0x0p+0 },
{ INT64_C(0x0001800020000200), 0x1.8000200002p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffdffffdff), -0x1.800020000201p+48, 0x0p+0 },
{ INT64_C(0x0001800020002000), 0x1.800020002p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffdfffdfff), -0x1.800020002001p+48, 0x0p+0 },
{ INT64_C(0x0001800020010000), 0x1.80002001p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffdffeffff), -0x1.800020010001p+48, 0x0p+0 },
{ INT64_C(0x0001800020080000), 0x1.80002008p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffdff7ffff), -0x1.800020080001p+48, 0x0p+0 },
{ INT64_C(0x0001800020400000), 0x1.8000204p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffdfbfffff), -0x1.800020400001p+48, 0x0p+0 },
{ INT64_C(0x0001800021000000), 0x1.800021p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffdeffffff), -0x1.800021000001p+48, 0x0p+0 },
{ INT64_C(0x0001800028000000), 0x1.800028p+48, 0x0p+0 },
{ INT64_C(0xfffe7fffd7ffffff), -0x1.800028000001p+48, 0x0p+0 },
{ INT64_C(0x0001800100000000), 0x1.8001p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffeffffffff), -0x1.800100000001p+48, 0x0p+0 },
{ INT64_C(0x0001800100000004), 0x1.800100000004p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffefffffffb), -0x1.800100000005p+48, 0x0p+0 },
{ INT64_C(0x0001800100000010), 0x1.80010000001p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffeffffffef), -0x1.800100000011p+48, 0x0p+0 },
{ INT64_C(0x0001800100000080), 0x1.80010000008p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffeffffff7f), -0x1.800100000081p+48, 0x0p+0 },
{ INT64_C(0x0001800100000200), 0x1.8001000002p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffefffffdff), -0x1.800100000201p+48, 0x0p+0 },
{ INT64_C(0x0001800100002000), 0x1.800100002p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffeffffdfff), -0x1.800100002001p+48, 0x0p+0 },
{ INT64_C(0x0001800100008000), 0x1.800100008p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffeffff7fff), -0x1.800100008001p+48, 0x0p+0 },
{ INT64_C(0x0001800100020000), 0x1.80010002p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffefffdffff), -0x1.800100020001p+48, 0x0p+0 },
{ INT64_C(0x0001800100200000), 0x1.8001002p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffeffdfffff), -0x1.800100200001p+48, 0x0p+0 },
{ INT64_C(0x0001800102000000), 0x1.800102p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffefdffffff), -0x1.800102000001p+48, 0x0p+0 },
{ INT64_C(0x0001800108000000), 0x1.800108p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffef7ffffff), -0x1.800108000001p+48, 0x0p+0 },
{ INT64_C(0x0001800110000000), 0x1.80011p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffeefffffff), -0x1.800110000001p+48, 0x0p+0 },
{ INT64_C(0x0001800120000000), 0x1.80012p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffedfffffff), -0x1.800120000001p+48, 0x0p+0 },
{ INT64_C(0x0001800140000000), 0x1.80014p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffebfffffff), -0x1.800140000001p+48, 0x0p+0 },
{ INT64_C(0x0001800180000000), 0x1.80018p+48, 0x0p+0 },
{ INT64_C(0xfffe7ffe7fffffff), -0x1.800180000001p+48, 0x0p+0 },
{ INT64_C(0x0001801000000000), 0x1.801p+48, 0x0p+0 },
{ INT64_C(0xfffe7fefffffffff), -0x1.801000000001p+48, 0x0p+0 },
{ INT64_C(0x0001801000000002), 0x1.801000000002p+48, 0x0p+0 },
{ INT64_C(0xfffe7feffffffffd), -0x1.801000000003p+48, 0x0p+0 },
{ INT64_C(0x0001801000000008), 0x1.801000000008p+48, 0x0p+0 },
{ INT64_C(0xfffe7feffffffff7), -0x1.801000000009p+48, 0x0p+0 },
{ INT64_C(0x0001801000000020), 0x1.80100000002p+48, 0x0p+0 },
{ INT64_C(0xfffe7fefffffffdf), -0x1.801000000021p+48, 0x0p+0 },
{ INT64_C(0x0001801000000200), 0x1.8010000002p+48, 0x0p+0 },
{ INT64_C(0xfffe7feffffffdff), -0x1.801000000201p+48, 0x0p+0 },
{ INT64_C(0x0001801000002000), 0x1.801000002p+48, 0x0p+0 },
{ INT64_C(0xfffe7fefffffdfff), -0x1.801000002001p+48, 0x0p+0 },
{ INT64_C(0x0001801000020000), 0x1.80100002p+48, 0x0p+0 },
{ INT64_C(0xfffe7feffffdffff), -0x1.801000020001p+48, 0x0p+0 },
{ INT64_C(0x0001801000200000), 0x1.8010002p+48, 0x0p+0 },
{ INT64_C(0xfffe7fefffdfffff), -0x1.801000200001p+48, 0x0p+0 },
{ INT64_C(0x0001801000400000), 0x1.8010004p+48, 0x0p+0 },
{ INT64_C(0xfffe7fefffbfffff), -0x1.801000400001p+48, 0x0p+0 },
{ INT64_C(0x0001801002000000), 0x1.801002p+48, 0x0p+0 },
{ INT64_C(0xfffe7feffdffffff), -0x1.801002000001p+48, 0x0p+0 },
{ INT64_C(0x0001801010000000), 0x1.80101p+48, 0x0p+0 },
{ INT64_C(0xfffe7fefefffffff), -0x1.801010000001p+48, 0x0p+0 },
{ INT64_C(0x0001801020000000), 0x1.80102p+48, 0x0p+0 },
{ INT64_C(0xfffe7fefdfffffff), -0x1.801020000001p+48, 0x0p+0 },
{ INT64_C(0x0001801040000000), 0x1.80104p+48, 0x0p+0 },
{ INT64_C(0xfffe7fefbfffffff), -0x1.801040000001p+48, 0x0p+0 },
{ INT64_C(0x0001801080000000), 0x1.80108p+48, 0x0p+0 },
{ INT64_C(0xfffe7fef7fffffff), -0x1.801080000001p+48, 0x0p+0 },
{ INT64_C(0x0001801200000000), 0x1.8012p+48, 0x0p+0 },
{ INT64_C(0xfffe7fedffffffff), -0x1.801200000001p+48, 0x0p+0 },
{ INT64_C(0x0001802000000000), 0x1.802p+48, 0x0p+0 },
{ INT64_C(0xfffe7fdfffffffff), -0x1.802000000001p+48, 0x0p+0 },
{ INT64_C(0x0001802000000008), 0x1.802000000008p+48, 0x0p+0 },
{ INT64_C(0xfffe7fdffffffff7), -0x1.802000000009p+48, 0x0p+0 },
{ INT64_C(0x0001802000000080), 0x1.80200000008p+48, 0x0p+0 },
{ INT64_C(0xfffe7fdfffffff7f), -0x1.802000000081p+48, 0x0p+0 },
{ INT64_C(0x0001802000000800), 0x1.8020000008p+48, 0x0p+0 },
{ INT64_C(0xfffe7fdffffff7ff), -0x1.802000000801p+48, 0x0p+0 },
{ INT64_C(0x0001802000001000), 0x1.802000001p+48, 0x0p+0 },
{ INT64_C(0xfffe7fdfffffefff), -0x1.802000001001p+48, 0x0p+0 },
{ INT64_C(0x0001802000010000), 0x1.80200001p+48, 0x0p+0 },
{ INT64_C(0xfffe7fdffffeffff), -0x1.802000010001p+48, 0x0p+0 },
{ INT64_C(0x0001802000020000), 0x1.80200002p+48, 0x0p+0 },
{ INT64_C(0xfffe7fdffffdffff), -0x1.802000020001p+48, 0x0p+0 },
{ INT64_C(0x0001802000100000), 0x1.8020001p+48, 0x0p+0 },
{ INT64_C(0xfffe7fdfffefffff), -0x1.802000100001p+48, 0x0p+0 },
{ INT64_C(0x0001802000800000), 0x1.8020008p+48, 0x0p+0 },
{ INT64_C(0xfffe7fdfff7fffff), -0x1.802000800001p+48, 0x0p+0 },
{ INT64_C(0x0001802008000000), 0x1.802008p+48, 0x0p+0 },
{ INT64_C(0xfffe7fdff7ffffff), -0x1.802008000001p+48, 0x0p+0 },
{ INT64_C(0x0001802010000000), 0x1.80201p+48, 0x0p+0 },
{ INT64_C(0xfffe7fdfefffffff), -0x1.802010000001p+48, 0x0p+0 },
{ INT64_C(0x0001802100000000), 0x1.8021p+48, 0x0p+0 },
{ INT64_C(0xfffe7fdeffffffff), -0x1.802100000001p+48, 0x0p+0 },
{ INT64_C(0x0001802200000000), 0x1.8022p+48, 0x0p+0 },
{ INT64_C(0xfffe7fddffffffff), -0x1.802200000001p+48, 0x0p+0 },
{ INT64_C(0x0001803000000000), 0x1.803p+48, 0x0p+0 },
{ INT64_C(0xfffe7fcfffffffff), -0x1.803000000001p+48, 0x0p+0 },
{ INT64_C(0x0001820000000000), 0x1.82p+48, 0x0p+0 },
{ INT64_C(0xfffe7dffffffffff), -0x1.820000000001p+48, 0x0p+0 },
{ INT64_C(0x0001820000000002), 0x1.820000000002p+48, 0x0p+0 },
{ INT64_C(0xfffe7dfffffffffd), -0x1.820000000003p+48, 0x0p+0 },
{ INT64_C(0x0001820000000004), 0x1.820000000004p+48, 0x0p+0 },
{ INT64_C(0xfffe7dfffffffffb), -0x1.820000000005p+48, 0x0p+0 },
{ INT64_C(0x0001820000000008), 0x1.820000000008p+48, 0x0p+0 },
{ INT64_C(0xfffe7dfffffffff7), -0x1.820000000009p+48, 0x0p+0 },
{ INT64_C(0x0001820000000040), 0x1.82000000004p+48, 0x0p+0 },
{ INT64_C(0xfffe7dffffffffbf), -0x1.820000000041p+48, 0x0p+0 },
{ INT64_C(0x0001820000000400), 0x1.8200000004p+48, 0x0p+0 },
{ INT64_C(0xfffe7dfffffffbff), -0x1.820000000401p+48, 0x0p+0 },
{ INT64_C(0x0001820000001000), 0x1.820000001p+48, 0x0p+0 },
{ INT64_C(0xfffe7dffffffefff), -0x1.820000001001p+48, 0x0p+0 },
{ INT64_C(0x0001820000002000), 0x1.820000002p+48, 0x0p+0 },
{ INT64_C(0xfffe7dffffffdfff), -0x1.820000002001p+48, 0x0p+0 },
{ INT64_C(0x0001820000010000), 0x1.82000001p+48, 0x0p+0 },
{ INT64_C(0xfffe7dfffffeffff), -0x1.820000010001p+48, 0x0p+0 },
{ INT64_C(0x0001820000100000), 0x1.8200001p+48, 0x0p+0 },
{ INT64_C(0xfffe7dffffefffff), -0x1.820000100001p+48, 0x0p+0 },
{ INT64_C(0x0001820000800000), 0x1.8200008p+48, 0x0p+0 },
{ INT64_C(0xfffe7dffff7fffff), -0x1.820000800001p+48, 0x0p+0 },
{ INT64_C(0x0001820004000000), 0x1.820004p+48, 0x0p+0 },
{ INT64_C(0xfffe7dfffbffffff), -0x1.820004000001p+48, 0x0p+0 },
{ INT64_C(0x0001820040000000), 0x1.82004p+48, 0x0p+0 },
{ INT64_C(0xfffe7dffbfffffff), -0x1.820040000001p+48, 0x0p+0 },
{ INT64_C(0x0001820400000000), 0x1.8204p+48, 0x0p+0 },
{ INT64_C(0xfffe7dfbffffffff), -0x1.820400000001p+48, 0x0p+0 },
{ INT64_C(0x0001822000000000), 0x1.822p+48, 0x0p+0 },
{ INT64_C(0xfffe7ddfffffffff), -0x1.822000000001p+48, 0x0p+0 },
{ INT64_C(0x0001a00000000000), 0x1.ap+48, 0x0p+0 },
{ INT64_C(0xfffe5fffffffffff), -0x1.a00000000001p+48, 0x0p+0 },
{ INT64_C(0x0001a00000000008), 0x1.a00000000008p+48, 0x0p+0 },
{ INT64_C(0xfffe5ffffffffff7), -0x1.a00000000009p+48, 0x0p+0 },
{ INT64_C(0x0001a00000000020), 0x1.a0000000002p+48, 0x0p+0 },
{ INT64_C(0xfffe5fffffffffdf), -0x1.a00000000021p+48, 0x0p+0 },
{ INT64_C(0x0001a00000000200), 0x1.a000000002p+48, 0x0p+0 },
{ INT64_C(0xfffe5ffffffffdff), -0x1.a00000000201p+48, 0x0p+0 },
{ INT64_C(0x0001a00000000400), 0x1.a000000004p+48, 0x0p+0 },
{ INT64_C(0xfffe5ffffffffbff), -0x1.a00000000401p+48, 0x0p+0 },
{ INT64_C(0x0001a00000004000), 0x1.a00000004p+48, 0x0p+0 },
{ INT64_C(0xfffe5fffffffbfff), -0x1.a00000004001p+48, 0x0p+0 },
{ INT64_C(0x0001a00000040000), 0x1.a0000004p+48, 0x0p+0 },
{ INT64_C(0xfffe5ffffffbffff), -0x1.a00000040001p+48, 0x0p+0 },
{ INT64_C(0x0001a00000080000), 0x1.a0000008p+48, 0x0p+0 },
{ INT64_C(0xfffe5ffffff7ffff), -0x1.a00000080001p+48, 0x0p+0 },
{ INT64_C(0x0001a00000100000), 0x1.a000001p+48, 0x0p+0 },
{ INT64_C(0xfffe5fffffefffff), -0x1.a00000100001p+48, 0x0p+0 },
{ INT64_C(0x0001a00000200000), 0x1.a000002p+48, 0x0p+0 },
{ INT64_C(0xfffe5fffffdfffff), -0x1.a00000200001p+48, 0x0p+0 },
{ INT64_C(0x0001a00002000000), 0x1.a00002p+48, 0x0p+0 },
{ INT64_C(0xfffe5ffffdffffff), -0x1.a00002000001p+48, 0x0p+0 },
{ INT64_C(0x0001a00010000000), 0x1.a0001p+48, 0x0p+0 },
{ INT64_C(0xfffe5fffefffffff), -0x1.a00010000001p+48, 0x0p+0 },
{ INT64_C(0x0001a00100000000), 0x1.a001p+48, 0x0p+0 },
{ INT64_C(0xfffe5ffeffffffff), -0x1.a00100000001p+48, 0x0p+0 },
{ INT64_C(0x0001a00400000000), 0x1.a004p+48, 0x0p+0 },
{ INT64_C(0xfffe5ffbffffffff), -0x1.a00400000001p+48, 0x0p+0 },
{ INT64_C(0x0001a00800000000), 0x1.a008p+48, 0x0p+0 },
{ INT64_C(0xfffe5ff7ffffffff), -0x1.a00800000001p+48, 0x0p+0 },
{ INT64_C(0x0001a04000000000), 0x1.a04p+48, 0x0p+0 },
{ INT64_C(0xfffe5fbfffffffff), -0x1.a04000000001p+48, 0x0p+0 },
{ INT64_C(0x0001a10000000000), 0x1.a1p+48, 0x0p+0 },
{ INT64_C(0xfffe5effffffffff), -0x1.a10000000001p+48, 0x0p+0 },
{ INT64_C(0x0001a80000000000), 0x1.a8p+48, 0x0p+0 },
{ INT64_C(0xfffe57ffffffffff), -0x1.a80000000001p+48, 0x0p+0 },
{ INT64_C(0x0002000000000022), 0x1.000000000011p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffffffdd), -0x1.0000000000118p+49, 0x0p+0 },
{ INT64_C(0x0002000000000024), 0x1.000000000012p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffffffdb), -0x1.0000000000128p+49, 0x0p+0 },
{ INT64_C(0x0002000000000028), 0x1.000000000014p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffffffd7), -0x1.0000000000148p+49, 0x0p+0 },
{ INT64_C(0x000200000000002c), 0x1.000000000016p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffffffd3), -0x1.0000000000168p+49, 0x0p+0 },
{ INT64_C(0x0002000000000082), 0x1.000000000041p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffffff7d), -0x1.0000000000418p+49, 0x0p+0 },
{ INT64_C(0x0002000000000090), 0x1.000000000048p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffffff6f), -0x1.0000000000488p+49, 0x0p+0 },
{ INT64_C(0x0002000000000091), 0x1.0000000000488p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffffff6e), -0x1.000000000049p+49, 0x0p+0 },
{ INT64_C(0x0002000000000092), 0x1.000000000049p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffffff6d), -0x1.0000000000498p+49, 0x0p+0 },
{ INT64_C(0x0002000000000094), 0x1.00000000004ap+49, 0x0p+0 },
{ INT64_C(0xfffdffffffffff6b), -0x1.00000000004a8p+49, 0x0p+0 },
{ INT64_C(0x0002000000000202), 0x1.000000000101p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffffdfd), -0x1.0000000001018p+49, 0x0p+0 },
{ INT64_C(0x0002000000000220), 0x1.00000000011p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffffddf), -0x1.0000000001108p+49, 0x0p+0 },
{ INT64_C(0x0002000000000228), 0x1.000000000114p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffffdd7), -0x1.0000000001148p+49, 0x0p+0 },
{ INT64_C(0x0002000000000230), 0x1.000000000118p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffffdcf), -0x1.0000000001188p+49, 0x0p+0 },
{ INT64_C(0x0002000000000280), 0x1.00000000014p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffffd7f), -0x1.0000000001408p+49, 0x0p+0 },
{ INT64_C(0x0002000000000281), 0x1.0000000001408p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffffd7e), -0x1.000000000141p+49, 0x0p+0 },
{ INT64_C(0x0002000000000284), 0x1.000000000142p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffffd7b), -0x1.0000000001428p+49, 0x0p+0 },
{ INT64_C(0x00020000000002c0), 0x1.00000000016p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffffd3f), -0x1.0000000001608p+49, 0x0p+0 },
{ INT64_C(0x0002000000000801), 0x1.0000000004008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff7fe), -0x1.000000000401p+49, 0x0p+0 },
{ INT64_C(0x0002000000000802), 0x1.000000000401p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff7fd), -0x1.0000000004018p+49, 0x0p+0 },
{ INT64_C(0x0002000000000803), 0x1.0000000004018p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff7fc), -0x1.000000000402p+49, 0x0p+0 },
{ INT64_C(0x0002000000000804), 0x1.000000000402p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff7fb), -0x1.0000000004028p+49, 0x0p+0 },
{ INT64_C(0x0002000000000810), 0x1.000000000408p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff7ef), -0x1.0000000004088p+49, 0x0p+0 },
{ INT64_C(0x0002000000000814), 0x1.00000000040ap+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff7eb), -0x1.00000000040a8p+49, 0x0p+0 },
{ INT64_C(0x0002000000000840), 0x1.00000000042p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff7bf), -0x1.0000000004208p+49, 0x0p+0 },
{ INT64_C(0x0002000000000842), 0x1.000000000421p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff7bd), -0x1.0000000004218p+49, 0x0p+0 },
{ INT64_C(0x0002000000000848), 0x1.000000000424p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff7b7), -0x1.0000000004248p+49, 0x0p+0 },
{ INT64_C(0x0002000000000860), 0x1.00000000043p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff79f), -0x1.0000000004308p+49, 0x0p+0 },
{ INT64_C(0x0002000000000c00), 0x1.0000000006p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff3ff), -0x1.0000000006008p+49, 0x0p+0 },
{ INT64_C(0x0002000000000c08), 0x1.000000000604p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff3f7), -0x1.0000000006048p+49, 0x0p+0 },
{ INT64_C(0x0002000000000c40), 0x1.00000000062p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffff3bf), -0x1.0000000006208p+49, 0x0p+0 },
{ INT64_C(0x0002000000008004), 0x1.000000004002p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff7ffb), -0x1.0000000040028p+49, 0x0p+0 },
{ INT64_C(0x0002000000008005), 0x1.0000000040028p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff7ffa), -0x1.000000004003p+49, 0x0p+0 },
{ INT64_C(0x0002000000008006), 0x1.000000004003p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff7ff9), -0x1.0000000040038p+49, 0x0p+0 },
{ INT64_C(0x0002000000008010), 0x1.000000004008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff7fef), -0x1.0000000040088p+49, 0x0p+0 },
{ INT64_C(0x0002000000008012), 0x1.000000004009p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff7fed), -0x1.0000000040098p+49, 0x0p+0 },
{ INT64_C(0x0002000000008100), 0x1.00000000408p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff7eff), -0x1.0000000040808p+49, 0x0p+0 },
{ INT64_C(0x0002000000008104), 0x1.000000004082p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff7efb), -0x1.0000000040828p+49, 0x0p+0 },
{ INT64_C(0x0002000000008110), 0x1.000000004088p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff7eef), -0x1.0000000040888p+49, 0x0p+0 },
{ INT64_C(0x0002000000008180), 0x1.0000000040cp+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff7e7f), -0x1.0000000040c08p+49, 0x0p+0 },
{ INT64_C(0x0002000000009000), 0x1.0000000048p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff6fff), -0x1.0000000048008p+49, 0x0p+0 },
{ INT64_C(0x0002000000009008), 0x1.000000004804p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff6ff7), -0x1.0000000048048p+49, 0x0p+0 },
{ INT64_C(0x0002000000009040), 0x1.00000000482p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff6fbf), -0x1.0000000048208p+49, 0x0p+0 },
{ INT64_C(0x0002000000009400), 0x1.000000004ap+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff6bff), -0x1.000000004a008p+49, 0x0p+0 },
{ INT64_C(0x0002000000009800), 0x1.000000004cp+49, 0x0p+0 },
{ INT64_C(0xfffdffffffff67ff), -0x1.000000004c008p+49, 0x0p+0 },
{ INT64_C(0x0002000000010004), 0x1.000000008002p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffefffb), -0x1.0000000080028p+49, 0x0p+0 },
{ INT64_C(0x0002000000010010), 0x1.000000008008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffeffef), -0x1.0000000080088p+49, 0x0p+0 },
{ INT64_C(0x0002000000010014), 0x1.00000000800ap+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffeffeb), -0x1.00000000800a8p+49, 0x0p+0 },
{ INT64_C(0x0002000000010080), 0x1.00000000804p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffeff7f), -0x1.0000000080408p+49, 0x0p+0 },
{ INT64_C(0x0002000000010084), 0x1.000000008042p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffeff7b), -0x1.0000000080428p+49, 0x0p+0 },
{ INT64_C(0x00020000000100a0), 0x1.00000000805p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffeff5f), -0x1.0000000080508p+49, 0x0p+0 },
{ INT64_C(0x0002000000010200), 0x1.0000000081p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffefdff), -0x1.0000000081008p+49, 0x0p+0 },
{ INT64_C(0x0002000000010201), 0x1.0000000081008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffefdfe), -0x1.000000008101p+49, 0x0p+0 },
{ INT64_C(0x0002000000010202), 0x1.000000008101p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffefdfd), -0x1.0000000081018p+49, 0x0p+0 },
{ INT64_C(0x0002000000010208), 0x1.000000008104p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffefdf7), -0x1.0000000081048p+49, 0x0p+0 },
{ INT64_C(0x0002000000010280), 0x1.00000000814p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffefd7f), -0x1.0000000081408p+49, 0x0p+0 },
{ INT64_C(0x0002000000010300), 0x1.00000000818p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffefcff), -0x1.0000000081808p+49, 0x0p+0 },
{ INT64_C(0x0002000000010400), 0x1.0000000082p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffefbff), -0x1.0000000082008p+49, 0x0p+0 },
{ INT64_C(0x0002000000010401), 0x1.0000000082008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffefbfe), -0x1.000000008201p+49, 0x0p+0 },
{ INT64_C(0x0002000000010408), 0x1.000000008204p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffefbf7), -0x1.0000000082048p+49, 0x0p+0 },
{ INT64_C(0x0002000000010420), 0x1.00000000821p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffefbdf), -0x1.0000000082108p+49, 0x0p+0 },
{ INT64_C(0x0002000000010480), 0x1.00000000824p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffefb7f), -0x1.0000000082408p+49, 0x0p+0 },
{ INT64_C(0x0002000000010800), 0x1.0000000084p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffef7ff), -0x1.0000000084008p+49, 0x0p+0 },
{ INT64_C(0x0002000000010801), 0x1.0000000084008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffef7fe), -0x1.000000008401p+49, 0x0p+0 },
{ INT64_C(0x0002000000010802), 0x1.000000008401p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffef7fd), -0x1.0000000084018p+49, 0x0p+0 },
{ INT64_C(0x0002000000010808), 0x1.000000008404p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffef7f7), -0x1.0000000084048p+49, 0x0p+0 },
{ INT64_C(0x0002000000010810), 0x1.000000008408p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffef7ef), -0x1.0000000084088p+49, 0x0p+0 },
{ INT64_C(0x0002000000010880), 0x1.00000000844p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffef77f), -0x1.0000000084408p+49, 0x0p+0 },
{ INT64_C(0x0002000000010c00), 0x1.0000000086p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffef3ff), -0x1.0000000086008p+49, 0x0p+0 },
{ INT64_C(0x0002000000018000), 0x1.00000000cp+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffe7fff), -0x1.00000000c0008p+49, 0x0p+0 },
{ INT64_C(0x0002000000018001), 0x1.00000000c0008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffe7ffe), -0x1.00000000c001p+49, 0x0p+0 },
{ INT64_C(0x0002000000018008), 0x1.00000000c004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffe7ff7), -0x1.00000000c0048p+49, 0x0p+0 },
{ INT64_C(0x0002000000018010), 0x1.00000000c008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffe7fef), -0x1.00000000c0088p+49, 0x0p+0 },
{ INT64_C(0x0002000000018100), 0x1.00000000c08p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffe7eff), -0x1.00000000c0808p+49, 0x0p+0 },
{ INT64_C(0x0002000000018400), 0x1.00000000c2p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffe7bff), -0x1.00000000c2008p+49, 0x0p+0 },
{ INT64_C(0x0002000000018800), 0x1.00000000c4p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffe77ff), -0x1.00000000c4008p+49, 0x0p+0 },
{ INT64_C(0x000200000001c000), 0x1.00000000ep+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffe3fff), -0x1.00000000e0008p+49, 0x0p+0 },
{ INT64_C(0x0002000000020004), 0x1.000000010002p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdfffb), -0x1.0000000100028p+49, 0x0p+0 },
{ INT64_C(0x0002000000020005), 0x1.0000000100028p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdfffa), -0x1.000000010003p+49, 0x0p+0 },
{ INT64_C(0x0002000000020006), 0x1.000000010003p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdfff9), -0x1.0000000100038p+49, 0x0p+0 },
{ INT64_C(0x0002000000020020), 0x1.00000001001p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdffdf), -0x1.0000000100108p+49, 0x0p+0 },
{ INT64_C(0x0002000000020021), 0x1.0000000100108p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdffde), -0x1.000000010011p+49, 0x0p+0 },
{ INT64_C(0x0002000000020028), 0x1.000000010014p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdffd7), -0x1.0000000100148p+49, 0x0p+0 },
{ INT64_C(0x0002000000020040), 0x1.00000001002p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdffbf), -0x1.0000000100208p+49, 0x0p+0 },
{ INT64_C(0x0002000000020041), 0x1.0000000100208p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdffbe), -0x1.000000010021p+49, 0x0p+0 },
{ INT64_C(0x0002000000020048), 0x1.000000010024p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdffb7), -0x1.0000000100248p+49, 0x0p+0 },
{ INT64_C(0x0002000000020060), 0x1.00000001003p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdff9f), -0x1.0000000100308p+49, 0x0p+0 },
{ INT64_C(0x0002000000020200), 0x1.0000000101p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdfdff), -0x1.0000000101008p+49, 0x0p+0 },
{ INT64_C(0x0002000000020202), 0x1.000000010101p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdfdfd), -0x1.0000000101018p+49, 0x0p+0 },
{ INT64_C(0x0002000000020208), 0x1.000000010104p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdfdf7), -0x1.0000000101048p+49, 0x0p+0 },
{ INT64_C(0x0002000000020210), 0x1.000000010108p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdfdef), -0x1.0000000101088p+49, 0x0p+0 },
{ INT64_C(0x0002000000020300), 0x1.00000001018p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdfcff), -0x1.0000000101808p+49, 0x0p+0 },
{ INT64_C(0x0002000000020400), 0x1.0000000102p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdfbff), -0x1.0000000102008p+49, 0x0p+0 },
{ INT64_C(0x0002000000020404), 0x1.000000010202p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdfbfb), -0x1.0000000102028p+49, 0x0p+0 },
{ INT64_C(0x0002000000020440), 0x1.00000001022p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdfbbf), -0x1.0000000102208p+49, 0x0p+0 },
{ INT64_C(0x0002000000020600), 0x1.0000000103p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdf9ff), -0x1.0000000103008p+49, 0x0p+0 },
{ INT64_C(0x0002000000024000), 0x1.000000012p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdbfff), -0x1.0000000120008p+49, 0x0p+0 },
{ INT64_C(0x0002000000024008), 0x1.000000012004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdbff7), -0x1.0000000120048p+49, 0x0p+0 },
{ INT64_C(0x0002000000024020), 0x1.00000001201p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdbfdf), -0x1.0000000120108p+49, 0x0p+0 },
{ INT64_C(0x0002000000024200), 0x1.0000000121p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdbdff), -0x1.0000000121008p+49, 0x0p+0 },
{ INT64_C(0x0002000000025000), 0x1.0000000128p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffdafff), -0x1.0000000128008p+49, 0x0p+0 },
{ INT64_C(0x0002000000028000), 0x1.000000014p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffd7fff), -0x1.0000000140008p+49, 0x0p+0 },
{ INT64_C(0x0002000000028002), 0x1.000000014001p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffd7ffd), -0x1.0000000140018p+49, 0x0p+0 },
{ INT64_C(0x0002000000028010), 0x1.000000014008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffd7fef), -0x1.0000000140088p+49, 0x0p+0 },
{ INT64_C(0x0002000000028080), 0x1.00000001404p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffd7f7f), -0x1.0000000140408p+49, 0x0p+0 },
{ INT64_C(0x0002000000028200), 0x1.0000000141p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffd7dff), -0x1.0000000141008p+49, 0x0p+0 },
{ INT64_C(0x000200000002a000), 0x1.000000015p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffffd5fff), -0x1.0000000150008p+49, 0x0p+0 },
{ INT64_C(0x0002000000200008), 0x1.000000100004p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdffff7), -0x1.0000001000048p+49, 0x0p+0 },
{ INT64_C(0x000200000020000c), 0x1.000000100006p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdffff3), -0x1.0000001000068p+49, 0x0p+0 },
{ INT64_C(0x0002000000200080), 0x1.00000010004p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfff7f), -0x1.0000001000408p+49, 0x0p+0 },
{ INT64_C(0x0002000000200088), 0x1.000000100044p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfff77), -0x1.0000001000448p+49, 0x0p+0 },
{ INT64_C(0x0002000000200090), 0x1.000000100048p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfff6f), -0x1.0000001000488p+49, 0x0p+0 },
{ INT64_C(0x0002000000200400), 0x1.0000001002p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdffbff), -0x1.0000001002008p+49, 0x0p+0 },
{ INT64_C(0x0002000000200404), 0x1.000000100202p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdffbfb), -0x1.0000001002028p+49, 0x0p+0 },
{ INT64_C(0x0002000000200410), 0x1.000000100208p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdffbef), -0x1.0000001002088p+49, 0x0p+0 },
{ INT64_C(0x0002000000200500), 0x1.00000010028p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdffaff), -0x1.0000001002808p+49, 0x0p+0 },
{ INT64_C(0x0002000000200600), 0x1.0000001003p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdff9ff), -0x1.0000001003008p+49, 0x0p+0 },
{ INT64_C(0x0002000000201000), 0x1.0000001008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfefff), -0x1.0000001008008p+49, 0x0p+0 },
{ INT64_C(0x0002000000201002), 0x1.000000100801p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfeffd), -0x1.0000001008018p+49, 0x0p+0 },
{ INT64_C(0x0002000000201020), 0x1.00000010081p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfefdf), -0x1.0000001008108p+49, 0x0p+0 },
{ INT64_C(0x0002000000201040), 0x1.00000010082p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfefbf), -0x1.0000001008208p+49, 0x0p+0 },
{ INT64_C(0x0002000000201100), 0x1.00000010088p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfeeff), -0x1.0000001008808p+49, 0x0p+0 },
{ INT64_C(0x0002000000204000), 0x1.000000102p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfbfff), -0x1.0000001020008p+49, 0x0p+0 },
{ INT64_C(0x0002000000204001), 0x1.0000001020008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfbffe), -0x1.000000102001p+49, 0x0p+0 },
{ INT64_C(0x0002000000204008), 0x1.000000102004p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfbff7), -0x1.0000001020048p+49, 0x0p+0 },
{ INT64_C(0x0002000000204040), 0x1.00000010202p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfbfbf), -0x1.0000001020208p+49, 0x0p+0 },
{ INT64_C(0x0002000000204200), 0x1.0000001021p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfbdff), -0x1.0000001021008p+49, 0x0p+0 },
{ INT64_C(0x0002000000204400), 0x1.0000001022p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdfbbff), -0x1.0000001022008p+49, 0x0p+0 },
{ INT64_C(0x0002000000206000), 0x1.000000103p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdf9fff), -0x1.0000001030008p+49, 0x0p+0 },
{ INT64_C(0x0002000000240000), 0x1.00000012p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdbffff), -0x1.0000001200008p+49, 0x0p+0 },
{ INT64_C(0x0002000000240002), 0x1.000000120001p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdbfffd), -0x1.0000001200018p+49, 0x0p+0 },
{ INT64_C(0x0002000000240020), 0x1.00000012001p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdbffdf), -0x1.0000001200108p+49, 0x0p+0 },
{ INT64_C(0x0002000000240040), 0x1.00000012002p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdbffbf), -0x1.0000001200208p+49, 0x0p+0 },
{ INT64_C(0x0002000000240080), 0x1.00000012004p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdbff7f), -0x1.0000001200408p+49, 0x0p+0 },
{ INT64_C(0x0002000000240800), 0x1.0000001204p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdbf7ff), -0x1.0000001204008p+49, 0x0p+0 },
{ INT64_C(0x0002000000248000), 0x1.000000124p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdb7fff), -0x1.0000001240008p+49, 0x0p+0 },
{ INT64_C(0x0002000000250000), 0x1.000000128p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffdaffff), -0x1.0000001280008p+49, 0x0p+0 },
{ INT64_C(0x0002000000260000), 0x1.00000013p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffd9ffff), -0x1.0000001300008p+49, 0x0p+0 },
{ INT64_C(0x0002000000300000), 0x1.00000018p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffcfffff), -0x1.0000001800008p+49, 0x0p+0 },
{ INT64_C(0x0002000000300001), 0x1.0000001800008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffcffffe), -0x1.000000180001p+49, 0x0p+0 },
{ INT64_C(0x0002000000300002), 0x1.000000180001p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffcffffd), -0x1.0000001800018p+49, 0x0p+0 },
{ INT64_C(0x0002000000300010), 0x1.000000180008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffcfffef), -0x1.0000001800088p+49, 0x0p+0 },
{ INT64_C(0x0002000000300100), 0x1.00000018008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffcffeff), -0x1.0000001800808p+49, 0x0p+0 },
{ INT64_C(0x0002000000300800), 0x1.0000001804p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffcff7ff), -0x1.0000001804008p+49, 0x0p+0 },
{ INT64_C(0x0002000000308000), 0x1.000000184p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffcf7fff), -0x1.0000001840008p+49, 0x0p+0 },
{ INT64_C(0x0002000000320000), 0x1.00000019p+49, 0x0p+0 },
{ INT64_C(0xfffdffffffcdffff), -0x1.0000001900008p+49, 0x0p+0 },
{ INT64_C(0x0002000000800008), 0x1.000000400004p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7ffff7), -0x1.0000004000048p+49, 0x0p+0 },
{ INT64_C(0x0002000000800010), 0x1.000000400008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fffef), -0x1.0000004000088p+49, 0x0p+0 },
{ INT64_C(0x0002000000800012), 0x1.000000400009p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fffed), -0x1.0000004000098p+49, 0x0p+0 },
{ INT64_C(0x0002000000800014), 0x1.00000040000ap+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fffeb), -0x1.00000040000a8p+49, 0x0p+0 },
{ INT64_C(0x0002000000800020), 0x1.00000040001p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fffdf), -0x1.0000004000108p+49, 0x0p+0 },
{ INT64_C(0x0002000000800022), 0x1.000000400011p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fffdd), -0x1.0000004000118p+49, 0x0p+0 },
{ INT64_C(0x0002000000800024), 0x1.000000400012p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fffdb), -0x1.0000004000128p+49, 0x0p+0 },
{ INT64_C(0x0002000000800080), 0x1.00000040004p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fff7f), -0x1.0000004000408p+49, 0x0p+0 },
{ INT64_C(0x0002000000800082), 0x1.000000400041p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fff7d), -0x1.0000004000418p+49, 0x0p+0 },
{ INT64_C(0x0002000000800088), 0x1.000000400044p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fff77), -0x1.0000004000448p+49, 0x0p+0 },
{ INT64_C(0x0002000000800200), 0x1.0000004001p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7ffdff), -0x1.0000004001008p+49, 0x0p+0 },
{ INT64_C(0x0002000000800202), 0x1.000000400101p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7ffdfd), -0x1.0000004001018p+49, 0x0p+0 },
{ INT64_C(0x0002000000800204), 0x1.000000400102p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7ffdfb), -0x1.0000004001028p+49, 0x0p+0 },
{ INT64_C(0x0002000000800220), 0x1.00000040011p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7ffddf), -0x1.0000004001108p+49, 0x0p+0 },
{ INT64_C(0x0002000000800300), 0x1.00000040018p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7ffcff), -0x1.0000004001808p+49, 0x0p+0 },
{ INT64_C(0x0002000000801000), 0x1.0000004008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fefff), -0x1.0000004008008p+49, 0x0p+0 },
{ INT64_C(0x0002000000801001), 0x1.0000004008008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7feffe), -0x1.000000400801p+49, 0x0p+0 },
{ INT64_C(0x0002000000801004), 0x1.000000400802p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7feffb), -0x1.0000004008028p+49, 0x0p+0 },
{ INT64_C(0x0002000000801020), 0x1.00000040081p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fefdf), -0x1.0000004008108p+49, 0x0p+0 },
{ INT64_C(0x0002000000801200), 0x1.0000004009p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fedff), -0x1.0000004009008p+49, 0x0p+0 },
{ INT64_C(0x0002000000804000), 0x1.000000402p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fbfff), -0x1.0000004020008p+49, 0x0p+0 },
{ INT64_C(0x0002000000804002), 0x1.000000402001p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fbffd), -0x1.0000004020018p+49, 0x0p+0 },
{ INT64_C(0x0002000000804004), 0x1.000000402002p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fbffb), -0x1.0000004020028p+49, 0x0p+0 },
{ INT64_C(0x0002000000804008), 0x1.000000402004p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fbff7), -0x1.0000004020048p+49, 0x0p+0 },
{ INT64_C(0x0002000000804020), 0x1.00000040201p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fbfdf), -0x1.0000004020108p+49, 0x0p+0 },
{ INT64_C(0x0002000000804080), 0x1.00000040204p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fbf7f), -0x1.0000004020408p+49, 0x0p+0 },
{ INT64_C(0x0002000000804100), 0x1.00000040208p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fbeff), -0x1.0000004020808p+49, 0x0p+0 },
{ INT64_C(0x0002000000804400), 0x1.0000004022p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7fbbff), -0x1.0000004022008p+49, 0x0p+0 },
{ INT64_C(0x0002000000810000), 0x1.000000408p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7effff), -0x1.0000004080008p+49, 0x0p+0 },
{ INT64_C(0x0002000000810002), 0x1.000000408001p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7efffd), -0x1.0000004080018p+49, 0x0p+0 },
{ INT64_C(0x0002000000810008), 0x1.000000408004p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7efff7), -0x1.0000004080048p+49, 0x0p+0 },
{ INT64_C(0x0002000000810010), 0x1.000000408008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7effef), -0x1.0000004080088p+49, 0x0p+0 },
{ INT64_C(0x0002000000810040), 0x1.00000040802p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7effbf), -0x1.0000004080208p+49, 0x0p+0 },
{ INT64_C(0x0002000000810100), 0x1.00000040808p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7efeff), -0x1.0000004080808p+49, 0x0p+0 },
{ INT64_C(0x0002000000810400), 0x1.0000004082p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7efbff), -0x1.0000004082008p+49, 0x0p+0 },
{ INT64_C(0x0002000000810800), 0x1.0000004084p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7ef7ff), -0x1.0000004084008p+49, 0x0p+0 },
{ INT64_C(0x0002000000812000), 0x1.000000409p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7edfff), -0x1.0000004090008p+49, 0x0p+0 },
{ INT64_C(0x0002000000814000), 0x1.00000040ap+49, 0x0p+0 },
{ INT64_C(0xfffdffffff7ebfff), -0x1.00000040a0008p+49, 0x0p+0 },
{ INT64_C(0x0002000000880000), 0x1.00000044p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff77ffff), -0x1.0000004400008p+49, 0x0p+0 },
{ INT64_C(0x0002000000880001), 0x1.0000004400008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff77fffe), -0x1.000000440001p+49, 0x0p+0 },
{ INT64_C(0x0002000000880008), 0x1.000000440004p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff77fff7), -0x1.0000004400048p+49, 0x0p+0 },
{ INT64_C(0x0002000000880010), 0x1.000000440008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff77ffef), -0x1.0000004400088p+49, 0x0p+0 },
{ INT64_C(0x0002000000880080), 0x1.00000044004p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff77ff7f), -0x1.0000004400408p+49, 0x0p+0 },
{ INT64_C(0x0002000000880400), 0x1.0000004402p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff77fbff), -0x1.0000004402008p+49, 0x0p+0 },
{ INT64_C(0x0002000000884000), 0x1.000000442p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff77bfff), -0x1.0000004420008p+49, 0x0p+0 },
{ INT64_C(0x0002000000888000), 0x1.000000444p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff777fff), -0x1.0000004440008p+49, 0x0p+0 },
{ INT64_C(0x0002000000a00000), 0x1.0000005p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff5fffff), -0x1.0000005000008p+49, 0x0p+0 },
{ INT64_C(0x0002000000a00008), 0x1.000000500004p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff5ffff7), -0x1.0000005000048p+49, 0x0p+0 },
{ INT64_C(0x0002000000a00040), 0x1.00000050002p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff5fffbf), -0x1.0000005000208p+49, 0x0p+0 },
{ INT64_C(0x0002000000a00400), 0x1.0000005002p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff5ffbff), -0x1.0000005002008p+49, 0x0p+0 },
{ INT64_C(0x0002000000a00800), 0x1.0000005004p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff5ff7ff), -0x1.0000005004008p+49, 0x0p+0 },
{ INT64_C(0x0002000000a04000), 0x1.000000502p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff5fbfff), -0x1.0000005020008p+49, 0x0p+0 },
{ INT64_C(0x0002000000a20000), 0x1.00000051p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff5dffff), -0x1.0000005100008p+49, 0x0p+0 },
{ INT64_C(0x0002000000b00000), 0x1.00000058p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff4fffff), -0x1.0000005800008p+49, 0x0p+0 },
{ INT64_C(0x0002000000c00000), 0x1.0000006p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff3fffff), -0x1.0000006000008p+49, 0x0p+0 },
{ INT64_C(0x0002000000c00001), 0x1.0000006000008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff3ffffe), -0x1.000000600001p+49, 0x0p+0 },
{ INT64_C(0x0002000000c00010), 0x1.000000600008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff3fffef), -0x1.0000006000088p+49, 0x0p+0 },
{ INT64_C(0x0002000000c00020), 0x1.00000060001p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff3fffdf), -0x1.0000006000108p+49, 0x0p+0 },
{ INT64_C(0x0002000000c00100), 0x1.00000060008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff3ffeff), -0x1.0000006000808p+49, 0x0p+0 },
{ INT64_C(0x0002000000c01000), 0x1.0000006008p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff3fefff), -0x1.0000006008008p+49, 0x0p+0 },
{ INT64_C(0x0002000000c02000), 0x1.000000601p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff3fdfff), -0x1.0000006010008p+49, 0x0p+0 },
{ INT64_C(0x0002000000c20000), 0x1.00000061p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff3dffff), -0x1.0000006100008p+49, 0x0p+0 },
{ INT64_C(0x0002000000e00000), 0x1.0000007p+49, 0x0p+0 },
{ INT64_C(0xfffdffffff1fffff), -0x1.0000007000008p+49, 0x0p+0 },
{ INT64_C(0x0002000001000002), 0x1.000000800001p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefffffd), -0x1.0000008000018p+49, 0x0p+0 },
{ INT64_C(0x0002000001000008), 0x1.000000800004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefffff7), -0x1.0000008000048p+49, 0x0p+0 },
{ INT64_C(0x0002000001000009), 0x1.0000008000048p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefffff6), -0x1.000000800005p+49, 0x0p+0 },
{ INT64_C(0x0002000001000020), 0x1.00000080001p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeffffdf), -0x1.0000008000108p+49, 0x0p+0 },
{ INT64_C(0x0002000001000028), 0x1.000000800014p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeffffd7), -0x1.0000008000148p+49, 0x0p+0 },
{ INT64_C(0x0002000001000100), 0x1.00000080008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefffeff), -0x1.0000008000808p+49, 0x0p+0 },
{ INT64_C(0x0002000001000102), 0x1.000000800081p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefffefd), -0x1.0000008000818p+49, 0x0p+0 },
{ INT64_C(0x0002000001000110), 0x1.000000800088p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefffeef), -0x1.0000008000888p+49, 0x0p+0 },
{ INT64_C(0x0002000001001000), 0x1.0000008008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeffefff), -0x1.0000008008008p+49, 0x0p+0 },
{ INT64_C(0x0002000001001004), 0x1.000000800802p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeffeffb), -0x1.0000008008028p+49, 0x0p+0 },
{ INT64_C(0x0002000001001010), 0x1.000000800808p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeffefef), -0x1.0000008008088p+49, 0x0p+0 },
{ INT64_C(0x0002000001001040), 0x1.00000080082p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeffefbf), -0x1.0000008008208p+49, 0x0p+0 },
{ INT64_C(0x0002000001001400), 0x1.000000800ap+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeffebff), -0x1.000000800a008p+49, 0x0p+0 },
{ INT64_C(0x0002000001008000), 0x1.000000804p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeff7fff), -0x1.0000008040008p+49, 0x0p+0 },
{ INT64_C(0x0002000001008001), 0x1.0000008040008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeff7ffe), -0x1.000000804001p+49, 0x0p+0 },
{ INT64_C(0x0002000001008004), 0x1.000000804002p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeff7ffb), -0x1.0000008040028p+49, 0x0p+0 },
{ INT64_C(0x0002000001008010), 0x1.000000804008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeff7fef), -0x1.0000008040088p+49, 0x0p+0 },
{ INT64_C(0x0002000001008100), 0x1.00000080408p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeff7eff), -0x1.0000008040808p+49, 0x0p+0 },
{ INT64_C(0x0002000001008800), 0x1.0000008044p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeff77ff), -0x1.0000008044008p+49, 0x0p+0 },
{ INT64_C(0x0002000001010000), 0x1.000000808p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefeffff), -0x1.0000008080008p+49, 0x0p+0 },
{ INT64_C(0x0002000001010008), 0x1.000000808004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefefff7), -0x1.0000008080048p+49, 0x0p+0 },
{ INT64_C(0x0002000001010010), 0x1.000000808008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefeffef), -0x1.0000008080088p+49, 0x0p+0 },
{ INT64_C(0x0002000001010020), 0x1.00000080801p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefeffdf), -0x1.0000008080108p+49, 0x0p+0 },
{ INT64_C(0x0002000001010100), 0x1.00000080808p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefefeff), -0x1.0000008080808p+49, 0x0p+0 },
{ INT64_C(0x0002000001010800), 0x1.0000008084p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefef7ff), -0x1.0000008084008p+49, 0x0p+0 },
{ INT64_C(0x0002000001012000), 0x1.000000809p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefedfff), -0x1.0000008090008p+49, 0x0p+0 },
{ INT64_C(0x0002000001040000), 0x1.00000082p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefbffff), -0x1.0000008200008p+49, 0x0p+0 },
{ INT64_C(0x0002000001040001), 0x1.0000008200008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefbfffe), -0x1.000000820001p+49, 0x0p+0 },
{ INT64_C(0x0002000001040010), 0x1.000000820008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefbffef), -0x1.0000008200088p+49, 0x0p+0 },
{ INT64_C(0x0002000001040100), 0x1.00000082008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefbfeff), -0x1.0000008200808p+49, 0x0p+0 },
{ INT64_C(0x0002000001040800), 0x1.0000008204p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefbf7ff), -0x1.0000008204008p+49, 0x0p+0 },
{ INT64_C(0x0002000001048000), 0x1.000000824p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffefb7fff), -0x1.0000008240008p+49, 0x0p+0 },
{ INT64_C(0x0002000001100000), 0x1.00000088p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeefffff), -0x1.0000008800008p+49, 0x0p+0 },
{ INT64_C(0x0002000001100008), 0x1.000000880004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeeffff7), -0x1.0000008800048p+49, 0x0p+0 },
{ INT64_C(0x0002000001100010), 0x1.000000880008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeefffef), -0x1.0000008800088p+49, 0x0p+0 },
{ INT64_C(0x0002000001100020), 0x1.00000088001p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeefffdf), -0x1.0000008800108p+49, 0x0p+0 },
{ INT64_C(0x0002000001100040), 0x1.00000088002p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeefffbf), -0x1.0000008800208p+49, 0x0p+0 },
{ INT64_C(0x0002000001100080), 0x1.00000088004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeefff7f), -0x1.0000008800408p+49, 0x0p+0 },
{ INT64_C(0x0002000001100800), 0x1.0000008804p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeeff7ff), -0x1.0000008804008p+49, 0x0p+0 },
{ INT64_C(0x0002000001104000), 0x1.000000882p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeefbfff), -0x1.0000008820008p+49, 0x0p+0 },
{ INT64_C(0x0002000001108000), 0x1.000000884p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeef7fff), -0x1.0000008840008p+49, 0x0p+0 },
{ INT64_C(0x0002000001120000), 0x1.00000089p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffeedffff), -0x1.0000008900008p+49, 0x0p+0 },
{ INT64_C(0x0002000001180000), 0x1.0000008cp+49, 0x0p+0 },
{ INT64_C(0xfffdfffffee7ffff), -0x1.0000008c00008p+49, 0x0p+0 },
{ INT64_C(0x0002000001800000), 0x1.000000cp+49, 0x0p+0 },
{ INT64_C(0xfffdfffffe7fffff), -0x1.000000c000008p+49, 0x0p+0 },
{ INT64_C(0x0002000001800001), 0x1.000000c000008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffe7ffffe), -0x1.000000c00001p+49, 0x0p+0 },
{ INT64_C(0x0002000001800004), 0x1.000000c00002p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffe7ffffb), -0x1.000000c000028p+49, 0x0p+0 },
{ INT64_C(0x0002000001800008), 0x1.000000c00004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffe7ffff7), -0x1.000000c000048p+49, 0x0p+0 },
{ INT64_C(0x0002000001800020), 0x1.000000c0001p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffe7fffdf), -0x1.000000c000108p+49, 0x0p+0 },
{ INT64_C(0x0002000001800080), 0x1.000000c0004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffe7fff7f), -0x1.000000c000408p+49, 0x0p+0 },
{ INT64_C(0x0002000001800400), 0x1.000000c002p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffe7ffbff), -0x1.000000c002008p+49, 0x0p+0 },
{ INT64_C(0x0002000001800800), 0x1.000000c004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffe7ff7ff), -0x1.000000c004008p+49, 0x0p+0 },
{ INT64_C(0x0002000001804000), 0x1.000000c02p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffe7fbfff), -0x1.000000c020008p+49, 0x0p+0 },
{ INT64_C(0x0002000001820000), 0x1.000000c1p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffe7dffff), -0x1.000000c100008p+49, 0x0p+0 },
{ INT64_C(0x0002000001a00000), 0x1.000000dp+49, 0x0p+0 },
{ INT64_C(0xfffdfffffe5fffff), -0x1.000000d000008p+49, 0x0p+0 },
{ INT64_C(0x0002000002000002), 0x1.000001000001p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfffffd), -0x1.0000010000018p+49, 0x0p+0 },
{ INT64_C(0x0002000002000008), 0x1.000001000004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfffff7), -0x1.0000010000048p+49, 0x0p+0 },
{ INT64_C(0x000200000200000a), 0x1.000001000005p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfffff5), -0x1.0000010000058p+49, 0x0p+0 },
{ INT64_C(0x0002000002000010), 0x1.000001000008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffffef), -0x1.0000010000088p+49, 0x0p+0 },
{ INT64_C(0x0002000002000014), 0x1.00000100000ap+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffffeb), -0x1.00000100000a8p+49, 0x0p+0 },
{ INT64_C(0x0002000002000018), 0x1.00000100000cp+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffffe7), -0x1.00000100000c8p+49, 0x0p+0 },
{ INT64_C(0x0002000002000020), 0x1.00000100001p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffffdf), -0x1.0000010000108p+49, 0x0p+0 },
{ INT64_C(0x0002000002000022), 0x1.000001000011p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffffdd), -0x1.0000010000118p+49, 0x0p+0 },
{ INT64_C(0x0002000002000028), 0x1.000001000014p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffffd7), -0x1.0000010000148p+49, 0x0p+0 },
{ INT64_C(0x0002000002000080), 0x1.00000100004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffff7f), -0x1.0000010000408p+49, 0x0p+0 },
{ INT64_C(0x0002000002000082), 0x1.000001000041p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffff7d), -0x1.0000010000418p+49, 0x0p+0 },
{ INT64_C(0x0002000002000084), 0x1.000001000042p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffff7b), -0x1.0000010000428p+49, 0x0p+0 },
{ INT64_C(0x0002000002000088), 0x1.000001000044p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffff77), -0x1.0000010000448p+49, 0x0p+0 },
{ INT64_C(0x00020000020000a0), 0x1.00000100005p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffff5f), -0x1.0000010000508p+49, 0x0p+0 },
{ INT64_C(0x00020000020000c0), 0x1.00000100006p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffff3f), -0x1.0000010000608p+49, 0x0p+0 },
{ INT64_C(0x0002000002000100), 0x1.00000100008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfffeff), -0x1.0000010000808p+49, 0x0p+0 },
{ INT64_C(0x0002000002000101), 0x1.0000010000808p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfffefe), -0x1.000001000081p+49, 0x0p+0 },
{ INT64_C(0x0002000002000110), 0x1.000001000088p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfffeef), -0x1.0000010000888p+49, 0x0p+0 },
{ INT64_C(0x0002000002000180), 0x1.0000010000cp+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfffe7f), -0x1.0000010000c08p+49, 0x0p+0 },
{ INT64_C(0x0002000002001000), 0x1.0000010008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffefff), -0x1.0000010008008p+49, 0x0p+0 },
{ INT64_C(0x0002000002001004), 0x1.000001000802p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffeffb), -0x1.0000010008028p+49, 0x0p+0 },
{ INT64_C(0x0002000002001040), 0x1.00000100082p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffefbf), -0x1.0000010008208p+49, 0x0p+0 },
{ INT64_C(0x0002000002001100), 0x1.00000100088p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffeeff), -0x1.0000010008808p+49, 0x0p+0 },
{ INT64_C(0x0002000002001800), 0x1.000001000cp+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdffe7ff), -0x1.000001000c008p+49, 0x0p+0 },
{ INT64_C(0x0002000002010000), 0x1.000001008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfeffff), -0x1.0000010080008p+49, 0x0p+0 },
{ INT64_C(0x0002000002010001), 0x1.0000010080008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfefffe), -0x1.000001008001p+49, 0x0p+0 },
{ INT64_C(0x0002000002010002), 0x1.000001008001p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfefffd), -0x1.0000010080018p+49, 0x0p+0 },
{ INT64_C(0x0002000002010004), 0x1.000001008002p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfefffb), -0x1.0000010080028p+49, 0x0p+0 },
{ INT64_C(0x0002000002010020), 0x1.00000100801p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfeffdf), -0x1.0000010080108p+49, 0x0p+0 },
{ INT64_C(0x0002000002010040), 0x1.00000100802p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfeffbf), -0x1.0000010080208p+49, 0x0p+0 },
{ INT64_C(0x0002000002010200), 0x1.0000010081p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfefdff), -0x1.0000010081008p+49, 0x0p+0 },
{ INT64_C(0x0002000002010400), 0x1.0000010082p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfefbff), -0x1.0000010082008p+49, 0x0p+0 },
{ INT64_C(0x0002000002012000), 0x1.000001009p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfedfff), -0x1.0000010090008p+49, 0x0p+0 },
{ INT64_C(0x0002000002014000), 0x1.00000100ap+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfebfff), -0x1.00000100a0008p+49, 0x0p+0 },
{ INT64_C(0x0002000002018000), 0x1.00000100cp+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdfe7fff), -0x1.00000100c0008p+49, 0x0p+0 },
{ INT64_C(0x0002000002100000), 0x1.00000108p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdefffff), -0x1.0000010800008p+49, 0x0p+0 },
{ INT64_C(0x0002000002100004), 0x1.000001080002p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdeffffb), -0x1.0000010800028p+49, 0x0p+0 },
{ INT64_C(0x0002000002100010), 0x1.000001080008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdefffef), -0x1.0000010800088p+49, 0x0p+0 },
{ INT64_C(0x0002000002100040), 0x1.00000108002p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdefffbf), -0x1.0000010800208p+49, 0x0p+0 },
{ INT64_C(0x0002000002100080), 0x1.00000108004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdefff7f), -0x1.0000010800408p+49, 0x0p+0 },
{ INT64_C(0x0002000002100100), 0x1.00000108008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdeffeff), -0x1.0000010800808p+49, 0x0p+0 },
{ INT64_C(0x0002000002100800), 0x1.0000010804p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdeff7ff), -0x1.0000010804008p+49, 0x0p+0 },
{ INT64_C(0x0002000002101000), 0x1.0000010808p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdefefff), -0x1.0000010808008p+49, 0x0p+0 },
{ INT64_C(0x0002000002102000), 0x1.000001081p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdefdfff), -0x1.0000010810008p+49, 0x0p+0 },
{ INT64_C(0x0002000002104000), 0x1.000001082p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdefbfff), -0x1.0000010820008p+49, 0x0p+0 },
{ INT64_C(0x0002000002140000), 0x1.0000010ap+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdebffff), -0x1.0000010a00008p+49, 0x0p+0 },
{ INT64_C(0x0002000002400000), 0x1.0000012p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdbfffff), -0x1.0000012000008p+49, 0x0p+0 },
{ INT64_C(0x0002000002400004), 0x1.000001200002p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdbffffb), -0x1.0000012000028p+49, 0x0p+0 },
{ INT64_C(0x0002000002400010), 0x1.000001200008p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdbfffef), -0x1.0000012000088p+49, 0x0p+0 },
{ INT64_C(0x0002000002400040), 0x1.00000120002p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdbfffbf), -0x1.0000012000208p+49, 0x0p+0 },
{ INT64_C(0x0002000002400080), 0x1.00000120004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdbfff7f), -0x1.0000012000408p+49, 0x0p+0 },
{ INT64_C(0x0002000002400800), 0x1.0000012004p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdbff7ff), -0x1.0000012004008p+49, 0x0p+0 },
{ INT64_C(0x0002000002402000), 0x1.000001201p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdbfdfff), -0x1.0000012010008p+49, 0x0p+0 },
{ INT64_C(0x0002000002404000), 0x1.000001202p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdbfbfff), -0x1.0000012020008p+49, 0x0p+0 },
{ INT64_C(0x0002000002440000), 0x1.00000122p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffdbbffff), -0x1.0000012200008p+49, 0x0p+0 },
{ INT64_C(0x0002000003000000), 0x1.0000018p+49, 0x0p+0 },
{ INT64_C(0xfffdfffffcffffff), -0x1.0