; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mcpu=generic | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=generic | FileCheck %s --check-prefix=X64

; Verify upgrading of the old form of the rdtscp intrinsic.

define i64 @test_builtin_rdtscp(i8* %A) {
; X86-LABEL: test_builtin_rdtscp:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %esi, -8
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    rdtscp
; X86-NEXT:    movl %ecx, (%esi)
; X86-NEXT:    popl %esi
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    retl
;
; X64-LABEL: test_builtin_rdtscp:
; X64:       # %bb.0:
; X64-NEXT:    rdtscp
; X64-NEXT:    shlq $32, %rdx
; X64-NEXT:    orq %rdx, %rax
; X64-NEXT:    movl %ecx, (%rdi)
; X64-NEXT:    retq
  %1 = tail call i64 @llvm.x86.rdtscp(i8* %A)
  ret i64 %1
}

declare i64 @llvm.x86.rdtscp(i8*)
