//= MSP430InstPrinter.h - Convert MSP430 MCInst to assembly syntax -*- C++ -*-//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This class prints a MSP430 MCInst to a .s file.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIB_TARGET_MSP430_INSTPRINTER_MSP430INSTPRINTER_H
#define LLVM_LIB_TARGET_MSP430_INSTPRINTER_MSP430INSTPRINTER_H

#include "llvm/MC/MCInstPrinter.h"

namespace llvm {
  class MSP430InstPrinter : public MCInstPrinter {
  public:
    MSP430InstPrinter(const MCAsmInfo &MAI, const MCInstrInfo &MII,
                      const MCRegisterInfo &MRI)
      : MCInstPrinter(MAI, MII, MRI) {}

    void printInst(const MCInst *MI, raw_ostream &O, StringRef Annot,
                   const MCSubtargetInfo &STI) override;

    // Autogenerated by tblgen.
    void printInstruction(const MCInst *MI, raw_ostream &O);
    bool printAliasInstr(const MCInst *MI, raw_ostream &O);
    void printCustomAliasOperand(const MCInst *MI, unsigned OpIdx,
                                 unsigned PrintMethodIdx, raw_ostream &O);
    static const char *getRegisterName(unsigned RegNo);

private:
    void printOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O,
                      const char *Modifier = nullptr);
    void printPCRelImmOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O);
    void printSrcMemOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O,
                            const char *Modifier = nullptr);
    void printIndRegOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O);
    void printPostIndRegOperand(const MCInst *MI, unsigned OpNo,
                                raw_ostream &O);
    void printCCOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O);

  };
}

#endif
