#! /usr/bin/env python
# -*- coding: utf-8 -*-
# vi:ts=4:et

# Note: this test is meant to be run from pycurl project root.

import pycurl
import unittest

from . import util
from . import procmgr, localhost

setup_module, teardown_module = procmgr.vsftpd_setup()

class FtpTest(unittest.TestCase):
    def setUp(self):
        self.curl = util.DefaultCurl()

    def tearDown(self):
        self.curl.close()

    def test_get_ftp(self):
        self.curl.setopt(pycurl.URL, 'ftp://%s:8321' % localhost)
        sio = util.BytesIO()
        self.curl.setopt(pycurl.WRITEFUNCTION, sio.write)
        self.curl.perform()

        result = sio.getvalue().decode()
        assert 'README.rst' in result
        assert 'INSTALL.rst' in result

    # XXX this test needs to be fixed
    def test_quote(self):
        self.curl.setopt(pycurl.URL, 'ftp://%s:8321' % localhost)
        sio = util.BytesIO()
        self.curl.setopt(pycurl.WRITEFUNCTION, sio.write)
        self.curl.setopt(pycurl.QUOTE, ['CWD tests'])
        self.curl.perform()

        result = sio.getvalue().decode()
        assert 'README.rst' not in result
        assert 'ftp_test.py' in result

    def test_epsv(self):
        self.curl.setopt(pycurl.URL, 'ftp://%s:8321' % localhost)
        sio = util.BytesIO()
        self.curl.setopt(pycurl.WRITEFUNCTION, sio.write)
        self.curl.setopt(pycurl.FTP_USE_EPSV, 1)
        self.curl.perform()

        result = sio.getvalue().decode()
        assert 'README.rst' in result
        assert 'INSTALL.rst' in result
