/* tty_named_keys.h --
 * Copyright 2008 Red Hat Inc.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors:
 *      Miloslav Trmač <mitr@redhat.com>
 */

/* Longest sequences should go first, but these are comparatively common. */
E("\x01", "^A")
E("\x02", "^B")
E("\x03", "^C") // Or "cancel" (3 terms)
E("\x04", "^D")
E("\x05", "^E")
E("\x06", "^F")
E("\x07", "^G")
E("\x08", "backspace")
E("\t", "tab")
E("\n", "nl")
E("\x0B", "^K")
E("\x0C", "^L")
E("\r", "ret")
E("\x0E", "^N")
E("\x0F", "^O")
E("\x10", "^P")
E("\x11", "^Q")
E("\x12", "^R")
E("\x13", "^S")
E("\x14", "^T")
E("\x15", "^U")
E("\x16", "^V")
E("\x17", "^W")
E("\x18", "^X")
E("\x19", "^Y")
E("\x1A", "^Z") // Or "suspend" (9 terms)
/* \x1B handled only after all other escape sequences */
E("\x7F", "backspace") // 59 terms; alternative: "delete" (11 terms)

// Based on terminal descriptions in ncrses-base-5.6-20.20080927.fc10.
// Conflicts are marked by comments.  Ordering: longest sequences first, then
// lexicographically.
E("\x1B[11;2~", "F13")
E("\x1B[11;3~", "F49")
E("\x1B[11;4~", "F61")
E("\x1B[11;5~", "F25")
E("\x1B[11;6~", "F37")
E("\x1B[12;2~", "F14")
E("\x1B[12;3~", "F50")
E("\x1B[12;4~", "F62")
E("\x1B[12;5~", "F26")
E("\x1B[12;6~", "F38")
E("\x1B[13;2~", "F15")
E("\x1B[13;3~", "F51")
E("\x1B[13;4~", "F63")
E("\x1B[13;5~", "F27")
E("\x1B[13;6~", "F39")
E("\x1B[14;2~", "F16")
E("\x1B[14;3~", "F52")
E("\x1B[14;5~", "F28")
E("\x1B[14;6~", "F40")
E("\x1B[15;2~", "F17")
E("\x1B[15;3~", "F53")
E("\x1B[15;5~", "F29")
E("\x1B[15;6~", "F41")
E("\x1B[17;2~", "F18")
E("\x1B[17;3~", "F54")
E("\x1B[17;5~", "F30")
E("\x1B[17;6~", "F42")
E("\x1B[18;2~", "F19")
E("\x1B[18;3~", "F55")
E("\x1B[18;5~", "F31")
E("\x1B[18;6~", "F43")
E("\x1B[19;2~", "F20")
E("\x1B[19;3~", "F56")
E("\x1B[19;5~", "F32")
E("\x1B[19;6~", "F44")
E("\x1B[20;2~", "F21")
E("\x1B[20;3~", "F57")
E("\x1B[20;5~", "F33")
E("\x1B[20;6~", "F45")
E("\x1B[21;2~", "F22")
E("\x1B[21;3~", "F58")
E("\x1B[21;5~", "F34")
E("\x1B[21;6~", "F46")
E("\x1B[23;2~", "F23")
E("\x1B[23;3~", "F59")
E("\x1B[23;5~", "F35")
E("\x1B[23;6~", "F47")
E("\x1B[24;2~", "F24")
E("\x1B[24;3~", "F60")
E("\x1B[24;5~", "F36")
E("\x1B[24;6~", "F48")
E("\x1B""O1;2A", "scroll-backward")
E("\x1B""O1;2B", "scroll-forward")
E("\x1B""O1;2C", "shift-right")
E("\x1B""O1;2D", "shift-left")
E("\x1B[192z", "F11")
E("\x1B[193z", "resume") // 3 terms; alternative "F12" (1 term)
E("\x1B[194z", "options") // 3 terms; alternative "F13" (1 term)
E("\x1B[195z", "undo") // 4 terms; alternative "F14" (1 term)
E("\x1B[196z", "help") // 1 term; alternative "F15" (1 term)
E("\x1B[197z", "copy")
E("\x1B[198z", "F17")
E("\x1B[199z", "F18")
E("\x1B[1;2A", "scroll-backward")
E("\x1B[1;2B", "scroll-forward")
E("\x1B[1;2C", "shift-right")
E("\x1B[1;2D", "shift-left")
E("\x1B[1;2F", "shift-end")
E("\x1B[1;2H", "shift-home")
E("\x1B[200z", "find") // 1 term; alternative "F19" (1 term)
E("\x1B[201z", "F20")
E("\x1B[208z", "F31")
E("\x1B[209z", "F32")
E("\x1B[210z", "F33")
E("\x1B[211z", "F34")
E("\x1B[212z", "F35")
E("\x1B[213z", "F36")
E("\x1B[214z", "home")
E("\x1B[215z", "F38")
E("\x1B[216z", "page-up")
E("\x1B[217z", "F40")
E("\x1B[218z", "B2")
E("\x1B[219z", "F42")
E("\x1B[220z", "end")
E("\x1B[221z", "F44")
E("\x1B[222z", "page-down") // 4 terms; alternative "F45" (1 term)
E("\x1B[224z", "F1")
E("\x1B[225z", "F2")
E("\x1B[226z", "F3")
E("\x1B[227z", "F4")
E("\x1B[228z", "F5")
E("\x1B[229z", "F6")
E("\x1B[230z", "F7")
E("\x1B[231z", "F8")
E("\x1B[232z", "F9")
E("\x1B[233z", "F10")
E("\x1B[234z", "F11") // 3 terms; alternative "F46" (1 term)
E("\x1B[235z", "F12") // 3 terms; alternative "F47" (1 term)
E("\x1B[2;2~", "shift-insert")
E("\x1B[2;5~", "shift-insert")
E("\x1B[3;2~", "shift-del")
E("\x1B[3;5~", "shift-del")
E("\x1B[5;2~", "shift-previous")
E("\x1B[5;5~", "shift-previous")
E("\x1B[6;2~", "shift-next")
E("\x1B[6;5~", "shift-next")
E("\x1B[11^", "F23")
E("\x1B[11~", "F1")
E("\x1B[12^", "F24")
E("\x1B[12~", "F2")
E("\x1B[13^", "F25")
E("\x1B[13~", "F3")
E("\x1B[14^", "F26")
E("\x1B[14~", "F4")
E("\x1B[15^", "F27")
E("\x1B[15~", "F5")
E("\x1B[17^", "F28")
E("\x1B[17~", "F6")
E("\x1B[18^", "F29")
E("\x1B[18~", "F7")
E("\x1B[19^", "F30")
E("\x1B[19~", "F8")
E("\x1B[20^", "F31")
E("\x1B[20~", "F9")
E("\x1B[21^", "F32")
E("\x1B[21~", "F10") // 85 terms; alternative "F0" (9 terms)
E("\x1B[23$", "F21")
E("\x1B[23@", "F43")
E("\x1B[23^", "F33")
E("\x1B[23~", "F11")
E("\x1B[24$", "F22")
E("\x1B[24@", "F44")
E("\x1B[24^", "F34")
E("\x1B[24~", "F12")
E("\x1B[25^", "F35")
E("\x1B[25~", "F13")
E("\x1B[26^", "F36")
E("\x1B[26~", "F14")
E("\x1B[28^", "F37")
E("\x1B[28~", "F15") // 42 terms; alternative "help" (8 terms)
E("\x1B[29^", "F38")
E("\x1B[29~", "F16") // 42 terms; alternative "redo" (4 terms)
E("\x1B[30~", "insert-line")
E("\x1B[31^", "F39")
E("\x1B[31~", "F17") // 46 terms; alternative "delete-line" (1 term)
E("\x1B[32^", "F40")
E("\x1B[32~", "F18")
E("\x1B[33^", "F41")
E("\x1B[33~", "F19")
E("\x1B[34^", "F42")
E("\x1B[34~", "F20")
E("\x1B""O2A", "scroll-backward")
E("\x1B""O2B", "scroll-forward")
E("\x1B""O2C", "shift-right")
E("\x1B""O2D", "shift-left")
E("\x1B""O2P", "F13")
E("\x1B""O2Q", "F14")
E("\x1B""O2R", "F15")
E("\x1B""O2S", "F16")
E("\x1B""O3P", "F49")
E("\x1B""O3Q", "F50")
E("\x1B""O3R", "F51")
E("\x1B""O3S", "F52")
E("\x1B""O4P", "F61")
E("\x1B""O4Q", "F62")
E("\x1B""O4R", "F63")
E("\x1B""O5C", "shift-right")
E("\x1B""O5D", "shift-left")
E("\x1B""O5F", "shift-end")
E("\x1B""O5H", "shift-home")
E("\x1B""O5P", "F25")
E("\x1B""O5Q", "F26")
E("\x1B""O5R", "F27")
E("\x1B""O5S", "F28")
E("\x1B""O6P", "F37")
E("\x1B""O6Q", "F38")
E("\x1B""O6R", "F39")
E("\x1B""O6S", "F40")
E("\x1B[1~", "home") // 30 terms; alternative "find" (42 terms, but "home" is used in Linux)
E("\x1B[2$", "shift-insert")
E("\x1B[2z", "insert")
E("\x1B[2~", "insert")
E("\x1B[3$", "shift-del")
E("\x1B[3z", "delete")
E("\x1B[3~", "delete")
E("\x1B[4~", "end") // 30 terms; alternative "select" (42 terms, but "end" is used in Linux)
E("\x1B[5$", "shift-previous")
E("\x1B[5~", "page-up") // 86 terms; alternative "A3" (4 terms)
E("\x1B[6$", "shift-next")
E("\x1B[6~", "page-down") // 86 terms; alternative "C3" (4 terms)
E("\x1B[7$", "shift-home")
E("\x1B[7~", "home") // 17 terms; alternative "A1" (4 terms)
E("\x1B[8$", "shift-end")
E("\x1B[8^", "delete-eol")
E("\x1B[8~", "end") // 17 terms; alternatives "C1" (4 terms), "delete-eol" (1 term)
E("\x1B[>M", "mouse")
E("\x1B[[A", "F1")
E("\x1B[[B", "F2")
E("\x1B[[C", "F3")
E("\x1B[[D", "F4")
E("\x1B[[E", "F5")
E("\x9B""11~", "F1")
E("\x9B""12~", "F2")
E("\x9B""13~", "F3")
E("\x9B""14~", "F4")
E("\x9B""15~", "F5")
E("\x9B""17~", "F6")
E("\x9B""18~", "F7")
E("\x9B""19~", "F8")
E("\x9B""20~", "F9")
E("\x9B""21~", "F10")
E("\x9B""23~", "F11")
E("\x9B""24~", "F12")
E("\x9B""25~", "F13")
E("\x9B""26~", "F14")
E("\x9B""28~", "F15")
E("\x9B""29~", "F16")
E("\x9B""31~", "F17")
E("\x9B""32~", "F18")
E("\x9B""33~", "F19")
E("\x9B""34~", "F20")
E("\x1B""2$", "shift-insert")
E("\x1B""OA", "up")
E("\x1B""OB", "down")
E("\x1B""OC", "right")
E("\x1B""OD", "left")
E("\x1B""OE", "B2") // 16 terms; alternative "begin" (5 terms)
E("\x1B""OF", "end")
E("\x1B""OH", "home")
E("\x1B""OM", "send")
E("\x1B""OP", "F1")
E("\x1B""OQ", "F2")
E("\x1B""OR", "F3")
E("\x1B""OS", "F4")
E("\x1B""OT", "F5")
E("\x1B""OU", "F6")
E("\x1B""OV", "F7")
E("\x1B""OW", "F8")
E("\x1B""OX", "F9")
E("\x1B""OY", "F10")
E("\x1B""OZ", "F11")
E("\x1B""O[", "F12")
E("\x1B""Ol", "F8")
E("\x1B""On", "C3")
E("\x1B""Op", "C1")
E("\x1B""Oq", "C1") // 17 terms; alternatives "A1" (5 terms), "F0" (1 term)
E("\x1B""Or", "B2")
E("\x1B""Os", "C3") // 17 terms; alternative "A3" (7 terms)
E("\x1B""Ot", "F5")
E("\x1B""Ou", "B2") // 21 terms; alternative "F6" (4 terms), "begin" (4 terms)
E("\x1B""Ov", "F7")
E("\x1B""Ow", "A1") // 17 terms; alternative "F9" (4 terms)
E("\x1B""Ox", "F10")
E("\x1B""Oy", "A3") // 17 terms; alternative "F0" (5 terms)
E("\x1B[9", "delete")
E("\x1B[@", "F41") // 4 terms; alternative "insert" (3 terms)
E("\x1B[A", "up")
E("\x1B[B", "down")
E("\x1B[C", "right")
E("\x1B[D", "left")
E("\x1B[E", "B2") // 9 terms; alternative "begin" (1 term)
E("\x1B[F", "end") // 5 terms; alternative "lower-left" (3 terms)
E("\x1B[G", "B2") // 9 terms; alternative "page-down" (4 terms)
E("\x1B[H", "home")
E("\x1B[I", "page-up")
E("\x1B[L", "insert")
E("\x1B[M", "mouse") // 83 terms; alternative "F1" (4 terms)
E("\x1B[N", "F2")
E("\x1B[O", "F3")
E("\x1B[P", "F4")
E("\x1B[Q", "F5")
E("\x1B[R", "F6")
E("\x1B[S", "F7")
E("\x1B[T", "F8")
E("\x1B[U", "F9") // 4 terms; alternative "page-down" (3 terms)
E("\x1B[V", "F10") // 4 terms; alternative "page-dup" (3 terms)
E("\x1B[W", "F11")
E("\x1B[X", "F12")
E("\x1B[Y", "F13") // 4 terms; alternative "end" (3 terms)
E("\x1B[Z", "back-tab") // 59 terms; alternative "F14" (4 terms)
E("\x1B[[", "F42")
E("\x1B[\\", "F43")
E("\x1B[]", "F44")
E("\x1B[^", "F45")
E("\x1B[_", "F46")
E("\x1B[`", "F47")
E("\x1B[a", "F15")
E("\x1B[b", "F16")
E("\x1B[c", "shift-right") // 15 terms; alternative "F17" (4 terms)
E("\x1B[d", "shift-left") // 15 terms; alternative "F18" (4 terms)
E("\x1B[e", "F19")
E("\x1B[f", "F20")
E("\x1B[g", "F21")
E("\x1B[h", "F22")
E("\x1B[i", "F23")
E("\x1B[j", "F24")
E("\x1B[k", "F25")
E("\x1B[l", "F26")
E("\x1B[m", "F27")
E("\x1B[n", "F28")
E("\x1B[o", "F29")
E("\x1B[p", "F30")
E("\x1B[q", "F31")
E("\x1B[r", "F32")
E("\x1B[s", "F33")
E("\x1B[t", "F34")
E("\x1B[u", "F35")
E("\x1B[v", "F36")
E("\x1B[w", "F37")
E("\x1B[x", "F38")
E("\x1B[y", "F39")
E("\x1B[z", "F40")
E("\x1B[{", "F48")
E("\x9B""1~", "home")
E("\x9B""2~", "insert")
E("\x9B""3~", "delete")
E("\x9B""4~", "end")
E("\x9B""5~", "page-up")
E("\x9B""6~", "page-down")
E("\x1B""A", "up")
E("\x1B""B", "down")
E("\x1B""C", "right")
E("\x1B""D", "left")
E("\x1B""F", "end")
E("\x1B""J", "clear")
E("\x1B""P", "delete")
E("\x1B""Q", "insert")
E("\x1B""S", "page-down")
E("\x1B""T", "page-up")
E("\x1B""h", "home")
E("\x1B""p", "F1")
E("\x1B""q", "F2")
E("\x1B""r", "F3")
E("\x1B""s", "F4")
E("\x1B""t", "F5")
E("\x1B""u", "F6")
E("\x1B""v", "F7")
E("\x1B""w", "F8")
E("\x1B\x09", "back-tab")
E("\x8F""A", "up")
E("\x8F""B", "down")
E("\x8F""C", "right")
E("\x8F""D", "left")
E("\x8F""E", "begin")
E("\x8F""M", "send")
E("\x8F""q", "C1")
E("\x8F""s", "C3")
E("\x8F""u", "A3")
E("\x8F""w", "A1")
E("\x8F""y", "B2")
E("\x9B""M", "mouse")
E("\x9B""Z", "back-tab")

E("\x1B", "esc")
