//  Copyright (c) 2006 John Maddock
//
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// There are three values in each row:
//
// phi, k, ellint_1(k, phi)
//
   static const boost::array<boost::array<typename table_type<T>::type, 3>, 610> ellint_f_data = {{
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.12698681652545928955078125e0), SC_(0.17721911576221833285284471505772299979929420100157e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.135477006435394287109375e0), SC_(0.17721911596893097495385621130075639520810631802367e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.22103404998779296875e0), SC_(0.17721911879842626333735727252300568988042608181058e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.308167040348052978515625e0), SC_(0.17721912307586304284414392153484736630244171106967e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.6323592662811279296875e0), SC_(0.17721915136072145749706721763844561838990574996748e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.814723670482635498046875e0), SC_(0.17721917584088468746420484903332375635064689539385e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.835008561611175537109375e0), SC_(0.17721917894520936923412246849940510596766888342397e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.905791938304901123046875e0), SC_(0.17721919037560789892218093103766859258846695998999e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.9133758544921875e0), SC_(0.17721919165542367899383364723376572314588337429883e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.968867778778076171875e0), SC_(0.1772192013446002825503764323931321827613955432354e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.12698681652545928955078125e0), SC_(0.22177286739245139979235205992077921703857874992614e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.135477006435394287109375e0), SC_(0.22177286779754970704335950293621400375492832466137e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.22103404998779296875e0), SC_(0.22177287334256025917867525959622978930360537074924e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.308167040348052978515625e0), SC_(0.22177288172512715350908153180610533224553721306023e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.6323592662811279296875e0), SC_(0.2217729371554693319729054703026208450026061763822e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.814723670482635498046875e0), SC_(0.22177298512970423745998954480900177381552708544037e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.835008561611175537109375e0), SC_(0.2217729912133089721595554486266261343813239076347e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.905791938304901123046875e0), SC_(0.22177301361368343651109035690490962300073942661987e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.9133758544921875e0), SC_(0.22177301612176360421071258583990800763547750726474e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.968867778778076171875e0), SC_(0.22177303510983544844756451225638983381366612239496e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.12698681652545928955078125e0), SC_(0.74445011006718641819708303378218126160875363196343e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.135477006435394287109375e0), SC_(0.74445012538997345743072973657345052421185812852883e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.22103404998779296875e0), SC_(0.7444503351293811483247033675758072401037344482302e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.308167040348052978515625e0), SC_(0.74445065219959407401467925377833815036903664230965e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.6323592662811279296875e0), SC_(0.74445274886650082568519006341784743843976685124848e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.814723670482635498046875e0), SC_(0.74445456352769560796450156151400127382998272645198e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.835008561611175537109375e0), SC_(0.74445479364613446978911973710885424587373960669503e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.905791938304901123046875e0), SC_(0.74445564096573887453994590323758448047874147238395e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.9133758544921875e0), SC_(0.74445573583701508518948039844922043785925055729088e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.968867778778076171875e0), SC_(0.74445645408656423225725685299458948993261862803123e-2) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.12698681652545928955078125e0), SC_(0.14336012771572004313303282953555702877340432667875e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.135477006435394287109375e0), SC_(0.14336013865789252161967302705927923090033123892839e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.22103404998779296875e0), SC_(0.14336028843546510307044909433889108803989992630717e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.308167040348052978515625e0), SC_(0.14336051486049934782010291664500194812313169536713e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.6323592662811279296875e0), SC_(0.14336201216019080237489913190282411526700579073185e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.814723670482635498046875e0), SC_(0.14336330811999887083609618534824546245882513068397e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.835008561611175537109375e0), SC_(0.14336347246485787781200874226852611208775882622848e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.905791938304901123046875e0), SC_(0.14336407760582576201557263371323141017452648028165e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.9133758544921875e0), SC_(0.14336414536187317685947794701801663975831519240267e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.968867778778076171875e0), SC_(0.14336465833209128166372255292238755432460966798543e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.12698681652545928955078125e0), SC_(0.17609184380978861185686844051402854987830396635258e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.135477006435394287109375e0), SC_(0.17609186408789500419846933977020874867517546176364e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.22103404998779296875e0), SC_(0.1760921416571103349085943082737303345872943430306e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.308167040348052978515625e0), SC_(0.17609256127163964831115570232150804486066285764182e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.6323592662811279296875e0), SC_(0.17609533613743185319361344589522300705915673688072e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.814723670482635498046875e0), SC_(0.17609773793502177357795159012740745279433408620657e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.835008561611175537109375e0), SC_(0.17609804251901222009248779176903833413486036667612e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.905791938304901123046875e0), SC_(0.17609916404852657704429322263138229104993266575624e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.9133758544921875e0), SC_(0.1760992896240552553398130726999861697860870407761e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.968867778778076171875e0), SC_(0.17610024034162638690605314405325566252936262309737e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.12698681652545928955078125e0), SC_(0.61527743617821017309837317251112211820225287909855e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.135477006435394287109375e0), SC_(0.61527830061250812048027946124763113656851093792434e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.22103404998779296875e0), SC_(0.61529013370063563692372946253072143453390904798089e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.308167040348052978515625e0), SC_(0.61530802448197340746490712692471232101050993961418e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.6323592662811279296875e0), SC_(0.61542639923962778105311852278000229689228218960744e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.814723670482635498046875e0), SC_(0.61552895025692965307933631422367268195916509703533e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.835008561611175537109375e0), SC_(0.61554196132063228221650243038365314737062757534577e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.905791938304901123046875e0), SC_(0.61558988200653669357386111420505273705513915221039e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.9133758544921875e0), SC_(0.61559524874653086436154791531898624131363535519786e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.968867778778076171875e0), SC_(0.61563588723439851846457601010368343188236507772324e-1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.12698681652545928955078125e0), SC_(0.11959057453624120334328464580296093852234979832319e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.135477006435394287109375e0), SC_(0.11959120801241224829404843422425331039825816399323e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.22103404998779296875e0), SC_(0.11959988089267249852525096379530849147372849485837e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.308167040348052978515625e0), SC_(0.11961299840115507344869578732891575108359266237168e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.6323592662811279296875e0), SC_(0.11969993471932342512901186119137938273010491343839e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.814723670482635498046875e0), SC_(0.11977545304297570964095700217118618012823329027572e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.835008561611175537109375e0), SC_(0.11978504790549786604035595742049176901340492369488e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.905791938304901123046875e0), SC_(0.11982041286438468953360393124738982966366389995088e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.9133758544921875e0), SC_(0.11982437604947070134783045506622451496127174214852e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.968867778778076171875e0), SC_(0.11985440336661855301549423118012820509315718117197e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.12698681652545928955078125e0), SC_(0.15263876949340227518206289717013303150106829870099e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.135477006435394287109375e0), SC_(0.1526400843588230155682366958717934905571237493997e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.22103404998779296875e0), SC_(0.15265808845688818722969160139227782294722571051529e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.308167040348052978515625e0), SC_(0.15268532756614555185951232940143121587973495430525e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.6323592662811279296875e0), SC_(0.15286611056971117187897855912072736469367681312174e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.814723670482635498046875e0), SC_(0.15302351281614507246145987065383207949898475657898e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.835008561611175537109375e0), SC_(0.1530435356029459943950906219285804393294788945235e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.905791938304901123046875e0), SC_(0.15311738352257616185860950883692089730569486492446e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.9133758544921875e0), SC_(0.15312566397501259415031965429740682988005856648126e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.968867778778076171875e0), SC_(0.15318843193739198996381468724623288934348602518129e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.12698681652545928955078125e0), SC_(0.40826668831091663626441209189877606742300982945973e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.135477006435394287109375e0), SC_(0.40829116199484250382288115943353006881004084526972e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.22103404998779296875e0), SC_(0.40862694825468660603335613858853155144356700548887e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.308167040348052978515625e0), SC_(0.40913737969817628320962246135961573151967272603518e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.6323592662811279296875e0), SC_(0.41260107543378269414044566586047919507096924341891e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.814723670482635498046875e0), SC_(0.41573068432927359032136530554842076369488053445457e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.835008561611175537109375e0), SC_(0.41613683445341381464308582108835280048764059411648e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.905791938304901123046875e0), SC_(0.41765113398254723962055569064791926246615413254393e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.9133758544921875e0), SC_(0.41782256020276621609674017362671014750026501907095e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.968867778778076171875e0), SC_(0.41913296681896765017387990528505551996225614692784e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.12698681652545928955078125e0), SC_(0.65477569244498274628357445932008780234315571539044e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.135477006435394287109375e0), SC_(0.65487164806402153030573139984154302981551785243681e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.22103404998779296875e0), SC_(0.65619254194891227468042672889687463942443436690839e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.308167040348052978515625e0), SC_(0.65821620961354539414907061912932846886247912255255e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.6323592662811279296875e0), SC_(0.67248849848936050016610849963373465122330627892961e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.814723670482635498046875e0), SC_(0.68630164387246135032620177956466712274649070191177e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.835008561611175537109375e0), SC_(0.68816675621039760222631800074603375360142401438987e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.905791938304901123046875e0), SC_(0.69528261874286863026519970272329655298700166989486e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.9133758544921875e0), SC_(0.69610496181753652833224539834751851243394541480226e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.968867778778076171875e0), SC_(0.7025112262474545066603301157823427120637874200135e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.12698681652545928955078125e0), SC_(0.11003471149236776513507991265642138339242686949903e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.135477006435394287109375e0), SC_(0.11007377660649281456894166377025736959059995654682e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.22103404998779296875e0), SC_(0.11061549425514318379849291365895797405348292801433e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.308167040348052978515625e0), SC_(0.11146019681541067330906358155717865338186530102327e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.6323592662811279296875e0), SC_(0.11802074417620207931939611733260636276673966082443e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.814723670482635498046875e0), SC_(0.12578285181515702991797627592602165658058701930258e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.835008561611175537109375e0), SC_(0.12698430906776947015611432433077785700088931116721e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.905791938304901123046875e0), SC_(0.13204037251693329627187843072366712493935712110401e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.9133758544921875e0), SC_(0.13268204823908263101837949751919463104879377367912e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.968867778778076171875e0), SC_(0.13822453786208089290946476937753669578887421854728e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.97540400922298431396484375e-1), SC_(0.19562994006072772392989317248132709815452784959826e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.12698681652545928955078125e0), SC_(0.19601535246678452834518511364229816228893034488785e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.135477006435394287109375e0), SC_(0.19614596652758509958469918792231734860689477027169e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.188381969928741455078125e0), SC_(0.19716249959165646514429738081080084449821198227171e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.22103404998779296875e0), SC_(0.19797106668339028654214619902420748580297562979142e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.278498232364654541015625e0), SC_(0.19975512032997768028486010094015675843714455024392e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.308167040348052978515625e0), SC_(0.20087020936663850500582188095482001403774223406978e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.546881496906280517578125e0), SC_(0.21628418105431198748773405708776835286153103384277e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.54722058773040771484375e0), SC_(0.21631699315891608119894948133316654938901722748298e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.6323592662811279296875e0), SC_(0.22606368992258254906346157725003784007271672950414e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.814723670482635498046875e0), SC_(0.26534983966729379362939887794301988193856664827634e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.835008561611175537109375e0), SC_(0.27292696982824500489339800553879953551443341255962e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.905791938304901123046875e0), SC_(0.31275037362409136197983454894540518445246475543974e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.9133758544921875e0), SC_(0.31913382749674464369766643171969389446672569703398e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.957506835460662841796875e0), SC_(0.37701285737397544816409751357099760396932059212408e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.964888513088226318359375e0), SC_(0.39349208553332737987676519101722510664438127845638e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.967694938182830810546875e0), SC_(0.4007951596737977617848308394159967642617373648917e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.968867778778076171875e0), SC_(0.4040571139829913851415531047603326764659703286033e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.992881298065185546875e0), SC_(0.54149088557920911878614994884374272501219026526352e1) }}, 
      {{ SC_(0.1950808048248291015625e1), SC_(0.996461331844329833984375e0), SC_(0.60956543928985539645356626998293051370635689316592e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.97540400922298431396484375e-1), SC_(0.25469269551734735469869951766247718781962673424527e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.12698681652545928955078125e0), SC_(0.25519712959255786840106819755910446647478797877631e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.135477006435394287109375e0), SC_(0.2553680331713302438365097695192798456385454884366e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.188381969928741455078125e0), SC_(0.25669732544163506304944639375301687292868145656865e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.22103404998779296875e0), SC_(0.25775364568505656698646722868862598753622579518976e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.278498232364654541015625e0), SC_(0.26008112706780400458819419248957814565186202203651e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.308167040348052978515625e0), SC_(0.26153360429989087668689836138329779752799092806693e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.546881496906280517578125e0), SC_(0.28142666698646853744558793620002261556729643524801e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.54722058773040771484375e0), SC_(0.28146863814067030829651156108409285638641261767021e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.6323592662811279296875e0), SC_(0.29386365190461783835193915403079254430818525714849e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.814723670482635498046875e0), SC_(0.34235295715563359485713288547633976740340284127436e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.835008561611175537109375e0), SC_(0.35144016113968959525568278839562130837534604827633e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.905791938304901123046875e0), SC_(0.39792117967571638946322530084161902708818168749357e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.9133758544921875e0), SC_(0.40518874048220600618304570313896102054539797958828e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.957506835460662841796875e0), SC_(0.46921618063773848726048212047793957391451982157366e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.964888513088226318359375e0), SC_(0.48693879150964363521015432286640372931632381989609e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.967694938182830810546875e0), SC_(0.49473523092691194385675026458370079825733462855857e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.968867778778076171875e0), SC_(0.49820694300746426583417499086461889297101936185128e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.992881298065185546875e0), SC_(0.64048078252833184695833481910221841816079313986167e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.996461331844329833984375e0), SC_(0.70938316039256414225668295621475108351461655699934e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.97540400922298431396484375e-1), SC_(0.27169294744721183593709745148375231890329399912714e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.12698681652545928955078125e0), SC_(0.27221122917722527397799372344106138715796658428968e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.135477006435394287109375e0), SC_(0.27238680786788873635507735884409016001241816590325e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.188381969928741455078125e0), SC_(0.27375217975956563052334322709213847993729867727731e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.22103404998779296875e0), SC_(0.27483681515486312121622323338373370394382191983962e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.278498232364654541015625e0), SC_(0.27722559080262236923534751661407244360554184975449e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.308167040348052978515625e0), SC_(0.27871556710634124615155372525235134047227076712877e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.546881496906280517578125e0), SC_(0.29906821435784388502574295461513471848870727269653e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.54722058773040771484375e0), SC_(0.29911105588718031726855643800164507199925530063405e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.6323592662811279296875e0), SC_(0.31174669357911287744993815429792174618223969418419e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.814723670482635498046875e0), SC_(0.3609204869269757072282327024093439303976793662797e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.835008561611175537109375e0), SC_(0.37010046431238735541261054890022934113523719560981e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.905791938304901123046875e0), SC_(0.41693602816804916951827040390883654770081369591641e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.9133758544921875e0), SC_(0.42424461442817335583899393208653305821638950924034e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.957506835460662841796875e0), SC_(0.48852351693477390401084151775611711161714230790341e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.964888513088226318359375e0), SC_(0.50629040714491325618126117483322337300921080815852e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.967694938182830810546875e0), SC_(0.51410385483567375448743513424691722411248111114562e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.968867778778076171875e0), SC_(0.51758270351110881770260942395739431871605470855576e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.992881298065185546875e0), SC_(0.66000645504229846914922702272317711152053035415607e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.996461331844329833984375e0), SC_(0.72893181629270949803560477852024744504664030538627e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.12698681652545928955078125e0), SC_(0.31072221342043191145432052889288296013211028939737e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.135477006435394287109375e0), SC_(0.31090068165211348503583360474065341912435602071439e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.22103404998779296875e0), SC_(0.31339034518921156974896183038745980596645437343129e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.308167040348052978515625e0), SC_(0.31732941796126678149145766728864242326145635088789e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.6323592662811279296875e0), SC_(0.35077114184094613482533848633203259990888547383333e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.814723670482635498046875e0), SC_(0.4003179049799713108178282050098796262259848567719e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.835008561611175537109375e0), SC_(0.40954642770361940439776959775076106097768734099936e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.905791938304901123046875e0), SC_(0.45656328558700778621439810217797281282994138681161e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.9133758544921875e0), SC_(0.46389242501831577827889502649104292894624066689379e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.968867778778076171875e0), SC_(0.55738782887519763123643989468316581713502139828688e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.97540400922298431396484375e-1), SC_(0.37755122719095835811423337728430060413468445390786e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.12698681652545928955078125e0), SC_(0.37810318519851015551878920927743745775467406301024e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.135477006435394287109375e0), SC_(0.37829012818344106139255970656938698469776011528623e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.188381969928741455078125e0), SC_(0.37974311516704637313112906693457517341538187269562e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.22103404998779296875e0), SC_(0.380896402406573653462758558228966817469555107768e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.278498232364654541015625e0), SC_(0.38343346593105730714473048917413698679008037670856e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.308167040348052978515625e0), SC_(0.38501394576957168075020143444180403651849439608405e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.546881496906280517578125e0), SC_(0.40646274975573918187032728203694982450879349553607e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.54722058773040771484375e0), SC_(0.40650764486799282960997076628957112764962165205861e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.6323592662811279296875e0), SC_(0.41970788160335566139770626163874319202021553243668e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.814723670482635498046875e0), SC_(0.47045506999307748669309229710029290643499278736528e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.835008561611175537109375e0), SC_(0.47984475776619893260035778668406421478758732072107e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.905791938304901123046875e0), SC_(0.52747438794870471587914658385688589078450499746091e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.9133758544921875e0), SC_(0.53487412205026399386928570224184493137086797005622e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.957506835460662841796875e0), SC_(0.59970848037347436062720387300340600700666682758135e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.964888513088226318359375e0), SC_(0.61757261439064616697694349498787705608951479623778e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.967694938182830810546875e0), SC_(0.62542337044805795520963873498098322389333343816197e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.968867778778076171875e0), SC_(0.6289178662565526065927797559105874158450029262123e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.992881298065185546875e0), SC_(0.77166931593054033354394083476745032960438574245635e1) }}, 
      {{ SC_(0.37676393985748291015625e1), SC_(0.996461331844329833984375e0), SC_(0.84064475235391524325874806119559999401283228909939e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.97540400922298431396484375e-1), SC_(0.4430591540162268874333747828663776758862793783672e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.12698681652545928955078125e0), SC_(0.44375392011473424532034876134092452779729250423979e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.135477006435394287109375e0), SC_(0.4439892211912412619301776787698186848844755558552e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.188381969928741455078125e0), SC_(0.44581789142573870075430616936039449055369249521073e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.22103404998779296875e0), SC_(0.44726914365861570212743995565563739207023963785013e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.278498232364654541015625e0), SC_(0.45046091916528927847279370418393804088705611101869e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.308167040348052978515625e0), SC_(0.45244868212243216038416004047310696620652911445157e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.546881496906280517578125e0), SC_(0.47936660535955974363664026779667407854083585363437e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.54722058773040771484375e0), SC_(0.47942280927949870156729113770506404570756501259371e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.6323592662811279296875e0), SC_(0.49591636131763193688508550892421916452514613124629e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.814723670482635498046875e0), SC_(0.55853526291499763783413441524746494650935383084605e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.835008561611175537109375e0), SC_(0.5699496443024524782842452720232539826700714420455e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.905791938304901123046875e0), SC_(0.62684739469754992684911768340919066460397475196625e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.9133758544921875e0), SC_(0.63552732170416590253582547330217054202288645145355e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.957506835460662841796875e0), SC_(0.70968919231363598968181906769521003657527240252119e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.964888513088226318359375e0), SC_(0.7295489817825154986295052119287538105169730153571e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.967694938182830810546875e0), SC_(0.73820394172398209080112346932905471045769254532692e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.968867778778076171875e0), SC_(0.7420425888777766639122607263805607704202437036526e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.992881298065185546875e0), SC_(0.89317356257871990345011821794168317350909281522674e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.996461331844329833984375e0), SC_(0.96368355227379383369427056159155267142030818339148e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.12698681652545928955078125e0), SC_(0.51362697892293146024149566757160016652171029519725e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.135477006435394287109375e0), SC_(0.51393816800194071694472683522479070689338047948767e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.22103404998779296875e0), SC_(0.51828239697380023742666825202236522615796437588223e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.308167040348052978515625e0), SC_(0.52516751098980596673821312579840070371649973007858e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.6323592662811279296875e0), SC_(0.58421218838425566348206583832494168118961902186816e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.814723670482635498046875e0), SC_(0.67366707817207320894310903314321940366790653716336e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.835008561611175537109375e0), SC_(0.69058706579517599068095692635429767438914516020638e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.905791938304901123046875e0), SC_(0.77798168272927509964793385756033437734250053401127e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.9133758544921875e0), SC_(0.79177474760555272535418888568895017602010851855904e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.968867778778076171875e0), SC_(0.97102063222905397547513878468761960147066158328242e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.97540400922298431396484375e-1), SC_(0.55844691734507858137656858170096622106317642042824e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.12698681652545928955078125e0), SC_(0.55946435072669284662790267593422281103072851428504e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.135477006435394287109375e0), SC_(0.5598090429003808548016391653144469451067070740863e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.188381969928741455078125e0), SC_(0.56248977839286669537250587300752445327767367911234e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.22103404998779296875e0), SC_(0.56461966150484113071371849384367902106541159417831e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.278498232364654541015625e0), SC_(0.56931152259502926348309692552223811332215506880262e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.308167040348052978515625e0), SC_(0.57223876207987095562807947163219598811139051248937e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.546881496906280517578125e0), SC_(0.61227993821906502780327480133385818821209455713957e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.54722058773040771484375e0), SC_(0.61236433141512016457946752168581740042325212366111e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.6323592662811279296875e0), SC_(0.63727425473568638429145439517425636023128278810424e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.814723670482635498046875e0), SC_(0.73454042411239290351140002802119065012470861406926e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.835008561611175537109375e0), SC_(0.75274747820288477969748263486615852719666421837798e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.905791938304901123046875e0), SC_(0.84581967904629856268537754162744740969527487485085e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.9133758544921875e0), SC_(0.86036602011170770644003984577304728376400320901326e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.957506835460662841796875e0), SC_(0.98848252100647112319530218069729819390496885141157e1) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.964888513088226318359375e0), SC_(0.10239372982567268490979130974735669518912181671749e2) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.967694938182830810546875e0), SC_(0.10395337426720047901338904971339709355608782562757e2) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.968867778778076171875e0), SC_(0.10464786455438862794334753506877962984519701150706e2) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.992881298065185546875e0), SC_(0.1331054987349039168122567073578600680197110314181e2) }}, 
      {{ SC_(0.556996440887451171875e1), SC_(0.996461331844329833984375e0), SC_(0.14688637283873699838584062638782578404503163586353e2) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.97540400922298431396484375e-1), SC_(0.61783631190716027315019025898851077350917215931521e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.12698681652545928955078125e0), SC_(0.61888984358800004479413424228718147388833874544273e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.135477006435394287109375e0), SC_(0.61924672407586259231670414706944580242287742401112e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.188381969928741455078125e0), SC_(0.62202154136886917094664060275914124991586979670715e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.22103404998779296875e0), SC_(0.624225284773523836314060623992931844760251789472e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.278498232364654541015625e0), SC_(0.62907711141231261848668592016526274959858971574338e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.308167040348052978515625e0), SC_(0.63210227112318845177545380636420607704049301904653e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.546881496906280517578125e0), SC_(0.67334751547199296056179172628757848101255347201884e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.54722058773040771484375e0), SC_(0.67343419682802269138895824745501258517162939869565e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.6323592662811279296875e0), SC_(0.69897803420180864022909919741821358459016644605351e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.814723670482635498046875e0), SC_(0.79806488210490909837317416172039282908893438508284e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.835008561611175537109375e0), SC_(0.8165210788436412135085519279232064920913213327915e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.905791938304901123046875e0), SC_(0.91055166603620218664335859155880017503368103079059e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.9133758544921875e0), SC_(0.92520959425643497627601049249083637037525716863408e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.957506835460662841796875e0), SC_(0.10540134973068471631090579301791978824142610760547e2) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.964888513088226318359375e0), SC_(0.10895899598082500902707344491724188005760739630902e2) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.967694938182830810546875e0), SC_(0.11052331985699480570378348823755388260341201670884e2) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.968867778778076171875e0), SC_(0.11121977450594867122076795797700333003592905734443e2) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.992881298065185546875e0), SC_(0.13971879717734003393801201721441121744229233358639e2) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.996461331844329833984375e0), SC_(0.15350603827485982231303502413255463587806781247754e2) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.12698681652545928955078125e0), SC_(0.95454004986828653362057929010692037869227896715953e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.135477006435394287109375e0), SC_(0.95507548689869442847667388017333503400538819498748e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.22103404998779296875e0), SC_(0.96254492015177798916535606386773654146221183695006e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.308167040348052978515625e0), SC_(0.97436280774150178418798103764383492698312548104457e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.6323592662811279296875e0), SC_(0.10746924085825402325748543832012982352421706904113e2) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.814723670482635498046875e0), SC_(0.1223336536449578968618027415039525051971831731367e2) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.835008561611175537109375e0), SC_(0.12510225917081492880321679198442231849788383280755e2) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.905791938304901123046875e0), SC_(0.13920749595081598581954518121582750565969436125538e2) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.9133758544921875e0), SC_(0.1414062578749516941186266567362953568444178902917e2) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.968867778778076171875e0), SC_(0.1694550312061179115501473585165928260546294334011e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.97540400922298431396484375e-1), SC_(0.10963646610206798658249722105789069826347752802799e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.12698681652545928955078125e0), SC_(0.10981891651874504413661916860586302802863678440988e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.135477006435394287109375e0), SC_(0.1098807198503364724626399735601076460418617449507e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.188381969928741455078125e0), SC_(0.11036123299455733459985810769177967577713870443176e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.22103404998779296875e0), SC_(0.11074282816435212308083831359080124087764132889193e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.278498232364654541015625e0), SC_(0.11158287927321588292904319716655901345555657251695e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.308167040348052978515625e0), SC_(0.11210660295493829013001485037860770716406438804465e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.546881496906280517578125e0), SC_(0.11924264796517408091011634743477032835448050596572e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.54722058773040771484375e0), SC_(0.1192576361603510212712793465842272092903030481931e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.6323592662811279296875e0), SC_(0.12367273881279775351051150288008941369451574265176e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.814723670482635498046875e0), SC_(0.14076377036590804043482357034615432525655009626865e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.835008561611175537109375e0), SC_(0.14394024515629097522201571291989486751374749003521e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.905791938304901123046875e0), SC_(0.16008391252781965114431712554706427136217663748527e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.9133758544921875e0), SC_(0.16259384741738290011172877514514134871017060368919e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.957506835460662841796875e0), SC_(0.1845573432065792179989472365947112550213902456692e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.964888513088226318359375e0), SC_(0.19059046263882276029984622895969230989180600854906e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.967694938182830810546875e0), SC_(0.19323807582004519263424662133360235731198035088751e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.968867778778076171875e0), SC_(0.194415759520124225934949863251057195385264539859e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.992881298065185546875e0), SC_(0.24191686316432831322844489613644494982611622252385e2) }}, 
      {{ SC_(0.1093762969970703125e2), SC_(0.996461331844329833984375e0), SC_(0.26429541775511059034290701716123129217559603117067e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.97540400922298431396484375e-1), SC_(0.10970461541523682747355458653814043467367244057396e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.12698681652545928955078125e0), SC_(0.10988729373579871818537920348196397035079171317124e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.135477006435394287109375e0), SC_(0.10994917439755143861288957942891262447644638270139e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.188381969928741455078125e0), SC_(0.11043029102394708762269620069073447525794707462842e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.22103404998779296875e0), SC_(0.11081236829596933248848405497175796619417014928386e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.278498232364654541015625e0), SC_(0.11165348968140822237533113330055846036723650368255e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.308167040348052978515625e0), SC_(0.11217788691012088330586213377814407299980559959816e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.546881496906280517578125e0), SC_(0.11932361006460784173269687160588295510073957504097e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.54722058773040771484375e0), SC_(0.11933861960411066983507334813972987755774341687751e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.6323592662811279296875e0), SC_(0.12376020533177822825841829967437421518512959748557e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.814723670482635498046875e0), SC_(0.14088039873328027300817251189126401292512989990948e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.835008561611175537109375e0), SC_(0.14406309044650111751366545567902536930343297482049e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.905791938304901123046875e0), SC_(0.16024290482598164422160771707706643769440101928167e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.9133758544921875e0), SC_(0.16275921211204838128636593665063221747249244639666e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.957506835460662841796875e0), SC_(0.18478874723457283704932151551137391687396403708104e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.964888513088226318359375e0), SC_(0.1908436527336929073336423976599930324634785987703e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.967694938182830810546875e0), SC_(0.19350138081968353309613213762487673374633033171984e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.968867778778076171875e0), SC_(0.19468367596374444964951658514022395834888113880669e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.992881298065185546875e0), SC_(0.24243524107804909041787975504647233471841620587343e2) }}, 
      {{ SC_(0.109444122314453125e2), SC_(0.996461331844329833984375e0), SC_(0.26497308318441767897207472996276899324977478296401e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.97540400922298431396484375e-1), SC_(0.12677236706110367782549271525311628981337463378532e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.12698681652545928955078125e0), SC_(0.12698311703823960368329272085416947873851253345973e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.135477006435394287109375e0), SC_(0.1270545078454752334084595681657916305982619248666e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.188381969928741455078125e0), SC_(0.127609584418622420064875524352859139743323867435e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.22103404998779296875e0), SC_(0.12805042137113677772721529890580842526850421574962e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.278498232364654541015625e0), SC_(0.12902097628879921824880507556722716600356466567131e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.308167040348052978515625e0), SC_(0.12962612322216858533938983233684936264728463534302e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.546881496906280517578125e0), SC_(0.13787652235784692759159757793791973200170888666279e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.54722058773040771484375e0), SC_(0.1378938610863373233787592856761746639569953324591e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.6323592662811279296875e0), SC_(0.14300329413813784124057527394564366109025622616472e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.814723670482635498046875e0), SC_(0.1628224165011588388279149415775837870352458588289e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.835008561611175537109375e0), SC_(0.16651387851669406728318744269976515109089955012034e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.905791938304901123046875e0), SC_(0.18532081661221377344079742156094468153881757608401e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.9133758544921875e0), SC_(0.18825249421786445939315665022068666566932527992594e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.957506835460662841796875e0), SC_(0.21401382548733510689951829506820280650836218972868e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.964888513088226318359375e0), SC_(0.22112921268641332930460058419498382430939714078502e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.967694938182830810546875e0), SC_(0.22425789663719381950184643349827324981869849829139e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.968867778778076171875e0), SC_(0.22565082109474213831771453104739118391009029017993e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.992881298065185546875e0), SC_(0.28264918095678731651389959280869594157798962932526e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.996461331844329833984375e0), SC_(0.31022371071678070418149727053290705831200907328323e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.97540400922298431396484375e-1), SC_(0.16332335849207091109823957945908977308687495417936e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.12698681652545928955078125e0), SC_(0.16358887137525798553326252219914563268391293381365e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.135477006435394287109375e0), SC_(0.16367881026475127212157802387625954153421638007589e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.188381969928741455078125e0), SC_(0.16437805599790727624698263588190632711468111074403e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.22103404998779296875e0), SC_(0.16493333380886439753350310400826771464076281757905e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.278498232364654541015625e0), SC_(0.16615566883623039246168178792294104501713068061447e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.308167040348052978515625e0), SC_(0.16691768240787454863893571394130103320887386026289e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.546881496906280517578125e0), SC_(0.17729830041011270406739472325911576407893009020632e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.54722058773040771484375e0), SC_(0.17732010055485166822129505563081566136290531072432e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.6323592662811279296875e0), SC_(0.18374174097891067003317214752714830421328139857676e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.814723670482635498046875e0), SC_(0.20861278895371988062589770358837846293547800197758e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.835008561611175537109375e0), SC_(0.21324006384057404479117559678579067471187150716032e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.905791938304901123046875e0), SC_(0.23679775024628572650257350252783374984085623899523e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.9133758544921875e0), SC_(0.24046797175591689123465250475925160230942950790206e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.957506835460662841796875e0), SC_(0.2727039016669656030359715818368909425214276826001e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.964888513088226318359375e0), SC_(0.28160413256793780842690418454991050754045213691614e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.967694938182830810546875e0), SC_(0.28551728808580746334469718518664980378008087050345e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.968867778778076171875e0), SC_(0.28725940849051351011078468765794122846148342861865e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.992881298065185546875e0), SC_(0.35852756043126501796805453814599857861774809154537e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.996461331844329833984375e0), SC_(0.39299880890909155872805866540456283272877072915793e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.97540400922298431396484375e-1), SC_(0.16739008812038375551139393714029648811548620831914e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.12698681652545928955078125e0), SC_(0.16766242788505874547117187440653538778277110359314e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.135477006435394287109375e0), SC_(0.16775467589856196240594308803378836722256796922746e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.188381969928741455078125e0), SC_(0.1684718155964704912842520244156440574908760716928e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.22103404998779296875e0), SC_(0.16904122870111214312820522030036748927901786714062e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.278498232364654541015625e0), SC_(0.17029444558221217733009315523460128309062293197822e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.308167040348052978515625e0), SC_(0.17107554684784510609353430887134910997655584469126e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.546881496906280517578125e0), SC_(0.18170321532803242623540686899531048081371272468926e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.54722058773040771484375e0), SC_(0.18172550828241433969434987272297504177702506499321e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.6323592662811279296875e0), SC_(0.18828746052896298967269448069463749103706251523384e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.814723670482635498046875e0), SC_(0.21361072826294489971467076569820668779535583265053e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.835008561611175537109375e0), SC_(0.21830672055348773995019800260332036942958945700855e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.905791938304901123046875e0), SC_(0.24214808272090710104302580790903704452516964511139e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.9133758544921875e0), SC_(0.24585356880982658824798758656552918605968358220036e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.957506835460662841796875e0), SC_(0.27831885137582123028514114319998764489968298473821e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.964888513088226318359375e0), SC_(0.28726206697315074740765695360070471839779582791252e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.967694938182830810546875e0), SC_(0.29119196107553073084362488311565535383596697349093e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.968867778778076171875e0), SC_(0.29294114337846932310424864094970188193596770336044e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.992881298065185546875e0), SC_(0.36436321154494880151082257113005383382957690176199e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.996461331844329833984375e0), SC_(0.39885905798252447578288191719411612816972017823352e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.97540400922298431396484375e-1), SC_(0.18160351451480117558065298774495340775117518386233e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.12698681652545928955078125e0), SC_(0.18191570257582985990901186558654432710867815876507e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.135477006435394287109375e0), SC_(0.18202145942099527741591064867510771288489366600487e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.188381969928741455078125e0), SC_(0.18284381117851662569123403816303008548717206730046e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.22103404998779296875e0), SC_(0.18349700727987104158916905945679949883118409832651e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.278498232364654541015625e0), SC_(0.18493537839530114445239786069690986608480784911527e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.308167040348052978515625e0), SC_(0.18583240575191197992343279595518531545430270257635e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.546881496906280517578125e0), SC_(0.19807623055160910112676463201317703655071163516426e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.54722058773040771484375e0), SC_(0.19810198769909712537437476823656068024624632943299e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.6323592662811279296875e0), SC_(0.20569653353557630506746432862814268281378432144464e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.814723670482635498046875e0), SC_(0.2352243294913182509920736637424107626800849978303e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.835008561611175537109375e0), SC_(0.24073391036728761587154941055247761966103060656551e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.905791938304901123046875e0), SC_(0.26883779873538953768420791506854925489772742716466e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.9133758544921875e0), SC_(0.2732228804344448785365909397007966911385227964507e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.957506835460662841796875e0), SC_(0.31178811880826793631231649605900638774754521734655e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.964888513088226318359375e0), SC_(0.32244758251970303273759970075090971592366328715884e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.967694938182830810546875e0), SC_(0.32713536956536277600475871608099005733137864290554e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.968867778778076171875e0), SC_(0.32922255664295847128924208304922176923951390435245e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.992881298065185546875e0), SC_(0.41467369560650667725188799902157571185164372458279e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.996461331844329833984375e0), SC_(0.45602834257944001359415966760392429515296284001886e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.97540400922298431396484375e-1), SC_(0.18312300372506326241294500730893077699558488861926e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.12698681652545928955078125e0), SC_(0.18343708254413630378805328878396365848943038344861e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.135477006435394287109375e0), SC_(0.18354347826893519357961754405400947806553918265707e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.188381969928741455078125e0), SC_(0.18437076971104081002851192887230029061230550731767e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.22103404998779296875e0), SC_(0.18502785393138785912358347407325003047197892819858e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.278498232364654541015625e0), SC_(0.18647467659326146942316727117987550215704857340399e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.308167040348052978515625e0), SC_(0.18737689823802034505349353255540508911872283571262e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.546881496906280517578125e0), SC_(0.19968590858946203163810920494427914107663807716551e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.54722058773040771484375e0), SC_(0.19971179196248330412496219116000729408785832865871e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.6323592662811279296875e0), SC_(0.20734165817722928436480567474238341828986532137455e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.814723670482635498046875e0), SC_(0.23697489984334446431344934486158134041904842381922e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.835008561611175537109375e0), SC_(0.2424993867303742105328507260211256234323279427853e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.905791938304901123046875e0), SC_(0.2706617242267722414691163160764375847813717717449e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.9133758544921875e0), SC_(0.27505372763407864220086614223406204707060141528959e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.957506835460662841796875e0), SC_(0.31366215222928620647809692822883524559015721789254e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.964888513088226318359375e0), SC_(0.32432936002773805741225669213075502718161785228548e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.967694938182830810546875e0), SC_(0.32902013310798370828841390284256075117104305410948e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.968867778778076171875e0), SC_(0.33110857501358115355866917717358967139468954294776e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.992881298065185546875e0), SC_(0.4165863370824046888444255823639452522978422602125e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.996461331844329833984375e0), SC_(0.45794511104275158868373277569901296260878008705439e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.97540400922298431396484375e-1), SC_(0.19195255071886267905734211050079817202441855291762e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.12698681652545928955078125e0), SC_(0.19226896115986568463829974156731616708345686548771e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.135477006435394287109375e0), SC_(0.19237614362292146555392228656546752177979284920502e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.188381969928741455078125e0), SC_(0.19320949914402923045372060722904034331219911114421e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.22103404998779296875e0), SC_(0.19387133318099926450743698909948619097398431242012e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.278498232364654541015625e0), SC_(0.195328410123425720726653061458334417077334496782e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.308167040348052978515625e0), SC_(0.19623688660514213753434342090395296116415673459355e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.546881496906280517578125e0), SC_(0.20862143324961768851345919111343868316199681980527e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.54722058773040771484375e0), SC_(0.20864745774478503515900330797533678830537794131255e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.6323592662811279296875e0), SC_(0.21631606615558944761431611767012603200224334815787e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.814723670482635498046875e0), SC_(0.24605664816899151211957368248776661929561347076526e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.835008561611175537109375e0), SC_(0.25159536927531394461171365681798153984008860788433e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.905791938304901123046875e0), SC_(0.27981144116304097310999832251084464601495299273012e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.9133758544921875e0), SC_(0.2842095956069201237182209580237143358149447721357e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.957506835460662841796875e0), SC_(0.3228554268917209487068998151650754251587634078153e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.964888513088226318359375e0), SC_(0.33352916951148482276191354708667961683209471845728e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.967694938182830810546875e0), SC_(0.33822244860537716227785079860342838562349938371864e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.968867778778076171875e0), SC_(0.34031194134737293949506052326607402017063183344223e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.992881298065185546875e0), SC_(0.42581168561936959716980709473388925815561119615999e2) }}, 
      {{ SC_(0.191501369476318359375e2), SC_(0.996461331844329833984375e0), SC_(0.46717381433158210856334059154587912791924945189265e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.97540400922298431396484375e-1), SC_(0.19342982628708131433895278304168613379920608606336e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.12698681652545928955078125e0), SC_(0.19374689773610942509772563394512491878765485167684e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.135477006435394287109375e0), SC_(0.19385430319660352589984368111519041916999084782488e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.188381969928741455078125e0), SC_(0.19468937686314991463609027287559486292813687936264e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.22103404998779296875e0), SC_(0.19535255581381067407133658315578608960013449781566e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.278498232364654541015625e0), SC_(0.19681253365614675608611799334307280468796699370731e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.308167040348052978515625e0), SC_(0.1977227778386985949454928463790025668906232322804e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.546881496906280517578125e0), SC_(0.21012856060319105834560169950359243723097783093961e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.54722058773040771484375e0), SC_(0.21015462457200107208987738397941670483486147970704e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.6323592662811279296875e0), SC_(0.2178340396156453293630225427159108135935170341999e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.814723670482635498046875e0), SC_(0.24760422781218968616926899638780116092411638903143e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.835008561611175537109375e0), SC_(0.2531468352867127861778979703350290564620482923062e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.905791938304901123046875e0), SC_(0.28137748841553570479859160601033236680616154514941e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.9133758544921875e0), SC_(0.2857773026667808508643081683180461854320839559518e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.957506835460662841796875e0), SC_(0.32443318509404672259865818849318152942509061644305e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.964888513088226318359375e0), SC_(0.33510867594410750608035302554008769378152991743644e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.967694938182830810546875e0), SC_(0.33980262484505211179502091374296194517485807715332e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.968867778778076171875e0), SC_(0.34189239835265606599090370663118867345579422183663e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.992881298065185546875e0), SC_(0.42739800197991730528738944815644489569091822947309e2) }}, 
      {{ SC_(0.192977695465087890625e2), SC_(0.996461331844329833984375e0), SC_(0.46876102254398796228483373773359897821011055550046e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.97540400922298431396484375e-1), SC_(0.19399168335284176904234924545094028129533806151985e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.12698681652545928955078125e0), SC_(0.19430914670058108818658478242802865229933537562992e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.135477006435394287109375e0), SC_(0.19441668443345068824360917663234279430271912414544e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.188381969928741455078125e0), SC_(0.1952527782726560941262278723049449573586256412141e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.22103404998779296875e0), SC_(0.19591675707660317601139881943186872822092204138608e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.278498232364654541015625e0), SC_(0.19737846403604750962747538168233789057311450871052e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.308167040348052978515625e0), SC_(0.1982897644902540397051527622485752131661863988877e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.546881496906280517578125e0), SC_(0.21070839433502876428075384353813146894769373214289e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.54722058773040771484375e0), SC_(0.21073448245974306317660504029274307954995331548824e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.6323592662811279296875e0), SC_(0.21842055006396772612724969061930957826195872082693e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.814723670482635498046875e0), SC_(0.24820937924698674003672426700115065805726709523954e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.835008561611175537109375e0), SC_(0.25375448048096618398138687860814179129031727150161e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.905791938304901123046875e0), SC_(0.28199459044097423979479129192640406766590043517296e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.9133758544921875e0), SC_(0.28639549140424356664047741417330717301236740237857e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.957506835460662841796875e0), SC_(0.32505800013488926954471846265304385951704543101519e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.964888513088226318359375e0), SC_(0.3357346516002174426799302958153598225560810167169e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.967694938182830810546875e0), SC_(0.34042904581351626237017161120798419635896368374329e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.968867778778076171875e0), SC_(0.34251900609024499081879095809713735021646243651172e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.992881298065185546875e0), SC_(0.42802852178615091316605100215711100861134240554322e2) }}, 
      {{ SC_(0.193538990020751953125e2), SC_(0.996461331844329833984375e0), SC_(0.46939214022047184468864407874819371857388859478396e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.97540400922298431396484375e-1), SC_(0.1942265213062455442730487711056272532344602499804e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.12698681652545928955078125e0), SC_(0.19454417438245281072521639887164744063228552120154e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.135477006435394287109375e0), SC_(0.19465177616573950993276836025871799063376652263963e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.188381969928741455078125e0), SC_(0.19548836424020033391228637761624363274869989047818e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.22103404998779296875e0), SC_(0.19615273083546930580497236468994609251014925059012e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.278498232364654541015625e0), SC_(0.19761527700118236279676413294270784335847762518883e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.308167040348052978515625e0), SC_(0.19852709069955831322513295812458096246012950546068e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.546881496906280517578125e0), SC_(0.21095199967507860722465696732547113306908297482812e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.54722058773040771484375e0), SC_(0.21097809967101253013800351459923876879483608834996e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.6323592662811279296875e0), SC_(0.21866744605870484422233338060124216067065833763869e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.814723670482635498046875e0), SC_(0.24846556538866907585112446065856668877097292448131e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.835008561611175537109375e0), SC_(0.25401192124869322184373377196242822732558533903529e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.905791938304901123046875e0), SC_(0.2822568150952870373539701545971920732141358257908e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.9133758544921875e0), SC_(0.28665826846907600136939065224035897188637748584595e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.957506835460662841796875e0), SC_(0.32532415772317922321363543682940062124472089104758e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.964888513088226318359375e0), SC_(0.33600140346608663369110289991798618568036637590882e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.967694938182830810546875e0), SC_(0.34069602586873275279638524032678766324801463284443e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.968867778778076171875e0), SC_(0.34278608187932370382085390718528216333548457421904e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.992881298065185546875e0), SC_(0.42829760672372562224004917587316130959209536173258e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.996461331844329833984375e0), SC_(0.46966153287031080432066689306985536981383654997622e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.97540400922298431396484375e-1), SC_(0.19904030604423304605031563493514633738307992609437e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.12698681652545928955078125e0), SC_(0.19936570833315624190969427426242240013476377105113e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.135477006435394287109375e0), SC_(0.19947593105296469410263622445292701021573670308473e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.188381969928741455078125e0), SC_(0.20033282674063040050300953579141288722476938688633e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.22103404998779296875e0), SC_(0.2010132319880969855770131312945804722554982609894e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.278498232364654541015625e0), SC_(0.20251080842690084124232174281676568056350056899411e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.308167040348052978515625e0), SC_(0.20344426725511971972734022788166341869608037868837e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.546881496906280517578125e0), SC_(0.21614891816442160044565174998040660587540405838616e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.54722058773040771484375e0), SC_(0.21617557550721464687867748153117522385073682809606e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.6323592662811279296875e0), SC_(0.22402352004254272922326248272240394226215354060902e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.814723670482635498046875e0), SC_(0.25433206020659846451635653798433741272654750854019e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.835008561611175537109375e0), SC_(0.25995595362392898132463332233819698889754703798185e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.905791938304901123046875e0), SC_(0.28852114779554050919134805178087144273023505005268e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.9133758544921875e0), SC_(0.29296245945979418770003750443017967197228540341014e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.957506835460662841796875e0), SC_(0.33188793683429374062793811425224827701264176911718e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.964888513088226318359375e0), SC_(0.34261391951111262546295049437365991381281491936188e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.967694938182830810546875e0), SC_(0.34732752915035376811037289786157212393416163025554e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.968867778778076171875e0), SC_(0.34942559726678108457963694029838473139746833304693e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.992881298065185546875e0), SC_(0.43511199467896576068981961634268417139076781200662e2) }}, 
      {{ SC_(0.198576259613037109375e2), SC_(0.996461331844329833984375e0), SC_(0.47650391590892975191956118298593108301517309174576e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.97540400922298431396484375e-1), SC_(0.19975886328405901668305093050689660120707141316602e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.12698681652545928955078125e0), SC_(0.20008605915303070801582050926154802900088794048964e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.135477006435394287109375e0), SC_(0.20019688942140272434266047438835346018341741915511e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.188381969928741455078125e0), SC_(0.20105850846081957007436768267527465156969052735547e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.22103404998779296875e0), SC_(0.20174266422647172012150979392231829627779414396837e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.278498232364654541015625e0), SC_(0.20324849469295553710957519872007277741843364722133e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.308167040348052978515625e0), SC_(0.20418709708488624812924232071906879942886525542029e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.546881496906280517578125e0), SC_(0.21696140642124331439508133866139932201302076151348e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.54722058773040771484375e0), SC_(0.21698820879919996353144760914681524104995035006532e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.6323592662811279296875e0), SC_(0.2248785248670487339037134222906002093786314923977e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.814723670482635498046875e0), SC_(0.25534059615544403238480102528913553132379413621289e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.835008561611175537109375e0), SC_(0.26099050398865334629533525410109890297302254597982e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.905791938304901123046875e0), SC_(0.28967243162656729801455052134450446896264393672653e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.9133758544921875e0), SC_(0.29412943361256553874561548032106119373059225314887e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.957506835460662841796875e0), SC_(0.33316451349895040185793214377890308351033763723109e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.964888513088226318359375e0), SC_(0.34391265339548473169790956472595433220957162008448e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.967694938182830810546875e0), SC_(0.34863504351466085585554980530563512546455300394261e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.968867778778076171875e0), SC_(0.35073684228035671034339162557868963087508664681989e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.992881298065185546875e0), SC_(0.43650868172850778393525355531550453773052652935489e2) }}, 
      {{ SC_(0.19929225921630859375e2), SC_(0.996461331844329833984375e0), SC_(0.47791504341919311227161099998742414152705210735222e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.12698681652545928955078125e0), SC_(0.24852206550898319978190983067100514776615377727473e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.135477006435394287109375e0), SC_(0.24866464070855511040663338301964479223598462797236e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.22103404998779296875e0), SC_(0.25065363656732084822750387055815189187723429657877e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.308167040348052978515625e0), SC_(0.25380073970395947922582583397566279723752708041733e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.6323592662811279296875e0), SC_(0.2805260001123830228051193977609968789435237527768e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.814723670482635498046875e0), SC_(0.32013812288161230383507254058691739835624677000322e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.835008561611175537109375e0), SC_(0.32751766781102618452555944128390146420838932359409e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.905791938304901123046875e0), SC_(0.36511896764707420590932811629213597607442192208936e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.9133758544921875e0), SC_(0.37098090138580051103542727188386673865227695373655e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.968867778778076171875e0), SC_(0.44576670431026372474999805087999761032786564151124e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.12698681652545928955078125e0), SC_(0.64029707052819358798026202945496034201051376675713e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.135477006435394287109375e0), SC_(0.64065662867329731510905167206470426348000579756421e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.22103404998779296875e0), SC_(0.64567221477870510803896006565094849896791667291395e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.308167040348052978515625e0), SC_(0.65360653914250445223499712404078058345986158088873e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.6323592662811279296875e0), SC_(0.72091068969413354768470555979894375250854883743041e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.814723670482635498046875e0), SC_(0.82046315600696025842317036872213782774465494655701e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.835008561611175537109375e0), SC_(0.83898717232428299594870923028741701777220145751954e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.905791938304901123046875e0), SC_(0.93328998463557747079788635557387681634136121872602e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.9133758544921875e0), SC_(0.94798090083448401328383552423060476950786086617102e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.968867778778076171875e0), SC_(0.11352388177887899862769270203556217867987795179232e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.12698681652545928955078125e0), SC_(0.12579154382331624849995504971737598053587224775121e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.135477006435394287109375e0), SC_(0.1258629123249332796639091198974708149109486889059e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.22103404998779296875e0), SC_(0.12685851994596818963211475589675243092409541745734e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.308167040348052978515625e0), SC_(0.12843375727132041082283110776238893197168320725174e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.6323592662811279296875e0), SC_(0.14180779137123412498124168609891981092056098817107e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.814723670482635498046875e0), SC_(0.16162410252299947507128901048395142821231251884648e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.835008561611175537109375e0), SC_(0.1653152013141215856944195913668621513903319809522e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.905791938304901123046875e0), SC_(0.18412078840911869664652903874125802301205742425445e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.9133758544921875e0), SC_(0.18705231339830243358318239275545179927816644574167e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.968867778778076171875e0), SC_(0.22444947582863925345693507386186458537730111006249e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.12698681652545928955078125e0), SC_(0.25658502090244978090877141970893960506917422719394e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.135477006435394287109375e0), SC_(0.25672995659370167636074162037295145926099041806219e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.22103404998779296875e0), SC_(0.25875180174660371624905238703656604914656092031662e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.308167040348052978515625e0), SC_(0.26195057844009785727683464893701821156596484750488e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.6323592662811279296875e0), SC_(0.2891011463129193460573977573707949150504396644584e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.814723670482635498046875e0), SC_(0.32930739590633854381605546287467793111283231579432e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.835008561611175537109375e0), SC_(0.33679375763609597539308592356025124507335101594018e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.905791938304901123046875e0), SC_(0.37492445861810085142108868488536553926419178382588e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.9133758544921875e0), SC_(0.38086699090058068271279985054050727201708494031721e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.968867778778076171875e0), SC_(0.45664903993544502840751750992103769324314215524713e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.12698681652545928955078125e0), SC_(0.50505659203440279938830010253440085323070647638583e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.135477006435394287109375e0), SC_(0.50534216388830445980335135399460817135115935936356e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.22103404998779296875e0), SC_(0.50932593644875965893234599959022743691202259918901e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.308167040348052978515625e0), SC_(0.51562892434896885100439228418671454505533824895074e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.6323592662811279296875e0), SC_(0.5691388458382702939253765036826448847256790383481e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.814723670482635498046875e0), SC_(0.64841647174915260562168094112340451126659760019193e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.835008561611175537109375e0), SC_(0.66318246845203780675903083663338059471936088994611e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.905791938304901123046875e0), SC_(0.73841077722591654304210596796019202721941795711926e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.9133758544921875e0), SC_(0.75013755084726454965881401907276391709101666410419e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.968867778778076171875e0), SC_(0.89973134282710925452142048450157816262200221102697e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.12698681652545928955078125e0), SC_(0.10115604555368949483687471890824497026532038567019e4) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.135477006435394287109375e0), SC_(0.1012133050497275830780347173002131083103600802088e4) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.22103404998779296875e0), SC_(0.1020120880922149604989950464445671598395259388161e4) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.308167040348052978515625e0), SC_(0.10327591029439108059157922326032636145569231829932e4) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.6323592662811279296875e0), SC_(0.11400597837237931811476044006089184883421460101765e4) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.814723670482635498046875e0), SC_(0.12990515604873895842003339764405472011586481003657e4) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.835008561611175537109375e0), SC_(0.13286671610382179011061935562304250712176020940221e4) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.905791938304901123046875e0), SC_(0.14795587929982445488758894910099973156560147854256e4) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.9133758544921875e0), SC_(0.15030813318756246891355137019045501942292731438192e4) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.968867778778076171875e0), SC_(0.18031683136020447255217816635153572296860929726591e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.12698681652545928955078125e0), SC_(0.11902165793870267987435741776753047875920265751213e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.135477006435394287109375e0), SC_(0.11908897391528240120679535097563994079186387409261e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.22103404998779296875e0), SC_(0.12002804010608050581829575008183192405062961123642e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.308167040348052978515625e0), SC_(0.12151378934996375824220394156626328228788742423087e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.6323592662811279296875e0), SC_(0.13412676685915296881822755838145300215000346890517e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.814723670482635498046875e0), SC_(0.15281201627814349911219322982937563560261834041215e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.835008561611175537109375e0), SC_(0.15629208273736966018850653753226433255433492941276e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.905791938304901123046875e0), SC_(0.17402117426998289313370860215974579190403457757437e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.9133758544921875e0), SC_(0.17678472099706618291007501715448169066167629554269e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.968867778778076171875e0), SC_(0.2120363403215687272189669275949606957433496693392e4) }}
   }};


