// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System;
using System.Diagnostics;
using System.Globalization;
using System.Windows.Data;

namespace NuGet.PackageManagement.UI
{
    public class IntToVulnerabilitySeverityConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string result = null;
            if (value is int severity)
            {
                if (severity == 0)
                {
                    result = Resources.VulnerabilitySeverity_Low;
                }
                else if (severity == 1)
                {
                    result = Resources.VulnerabilitySeverity_Moderate;
                }
                else if (severity == 2)
                {
                    result = Resources.VulnerabilitySeverity_High;
                }
                else if (severity == 3)
                {
                    result = Resources.VulnerabilitySeverity_Critical;
                }
            }

            return result;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            // no op
            Debug.Fail("Not Implemented");
            return null;
        }
    }
}
