.\" dpkg manual page - start-stop-daemon(8)
.\"
.\" Copyright © 1999 Klee Dienes <klee@mit.edu>
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000-2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2002-2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2004 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2008-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH start\-stop\-daemon 8 %RELEASE_DATE% %VERSION% "Herramientas de dpkg"
.nh
.SH NOMBRE
start\-stop\-daemon \- Detiene y arranca demonios del sistema
.
.SH SINOPSIS
\fBstart\-stop\-daemon\fP [\fIopción\fP...] \fIorden\fP
.
.SH DESCRIPCIÓN
\fBstart\-stop\-daemon\fP sirve para controlar la creación y finalización de los
procesos del sistema. Usando una de las opciones de búsqueda, puede
configurar \fBstart\-stop\-daemon\fP para encontrar las instancias de un proceso
en ejecución.
.PP
Note: unless \fB\-\-pid\fP or \fB\-\-pidfile\fP are specified, \fBstart\-stop\-daemon\fP
behaves similar to \fBkillall\fP(1).  \fBstart\-stop\-daemon\fP will scan the
process table looking for any processes which match the process name, parent
pid, uid, and/or gid (if specified). Any matching process will prevent
\fB\-\-start\fP from starting the daemon. All matching processes will be sent the
TERM signal (or the one specified via \fB\-\-signal\fP or \fB\-\-retry\fP) if
\fB\-\-stop\fP is specified. For daemons which have long\-lived children which
need to live through a \fB\-\-stop\fP, you must specify a pidfile.
.
.SH ÓRDENES
.TP 
\fB\-S\fP, \fB\-\-start\fP [\fB\-\-\fP] \fIargumentos\fP
Comprueba la existencia del proceso especificado. Si este proceso ya existe,
\fBstart\-stop\-daemon\fP no hace nada y finaliza con un estado de error 1 (0 si
se especifica \fB\-\-oknodo\fP ). Si el proceso no existe, comienza uno nuevo
usando el ejecutable especificado por \fB\-\-exec\fP, (o, si se especifica, por
\fB\-\-startas\fP ). Cualquier argumento dado en la línea de órdenes después de
\fB\-\-\fP se introduce sin modificación alguna al programa que se va a ejecutar.
.TP 
\fB\-K\fP, \fB\-\-stop\fP
Comprueba la existencia del proceso especificado. Si este proceso existe,
\fBstart\-stop\-daemon\fP envía la señal especificada por \fB\-\-signal\fP, y finaliza
con un estado de error 0. Si este proceso no existe, \fBstart\-stop\-daemon\fP
termina con un estado de error 1 (0 si se ha especificado la opción
\fB\-\-oknodo\fP ). Si se especifica la opción \fB\-\-retry\fP, \fBstart\-stop\-daemon\fP
comprobará que el proceso o los procesos han terminado.
.TP 
\fB\-T\fP, \fB\-\-status\fP
Check for the existence of a specified process, and returns an exit status
code, according to the LSB Init Script Actions (since version 1.16.1).
.TP 
\fB\-H\fP, \fB\-\-help\fP
Muestra la información de uso y termina.
.TP 
\fB\-V\fP, \fB\-\-version\fP
Muestra la versión y termina.
.
.SH OPCIONES
.SS "Matching options"
.TP 
\fB\-\-pid\fP \fIpid\fP
Check for a process with the specified \fIpid\fP (since version 1.17.6).  The
\fIpid\fP must be a number greater than 0.
.TP 
\fB\-\-ppid\fP \fIppid\fP
Check for a process with the specified parent pid \fIppid\fP (since version
1.17.7).  The \fIppid\fP must be a number greater than 0.
.TP 
\fB\-p\fP, \fB\-\-pidfile\fP \fIfichero\-pid\fP
Comprueba si un proceso ha creado el \fIfichero\-pid\fP. Nota: utilizar solo
esta opción de búsqueda puede afectar a procesos de forma no deseada si el
proceso antiguo ha finalizado sin poder eliminar el \fIfichero\-pid\fP.
.TP 
\fB\-x\fP, \fB\-\-exec\fP \fIejecutable\fP
Busca procesos que son instancias de este \fIejecutable\fP. El argumento
\fIejecutable\fP debe ser un nombre de ruta absoluta. Nota: puede que funcione
de forma inesperada con scripts de intérprete de órdenes, ya que el
ejecutable apunta al intérprete de órdenes. Tenga en cuenta que también se
buscan entre los procesos iniciados dentro de una jaula de chroot, y puede
que necesite definir límites adicionales de la búsqueda.
.TP 
\fB\-n\fP, \fB\-\-name\fP \fInombre\-proceso\fP
Busca procesos con el nombre \fInombre\-proceso\fP. Habitualmente,
\fInombre\-proceso\fP es igual al nombre de fichero del proceso, pero puede que
el mismo proceso lo modifique. Nota: en la mayoría de sistemas, esta
información se obtiene a partir del nombre comm de proceso del núcleo, que
habitualmente tiene un límite corto de longitud (suponiendo que más de 15
caracteres no son portables).
.TP 
\fB\-u\fP, \fB\-\-user\fP \fInombre\-usuario\fP|\fIuid\fP
Busca procesos cuyo propietario es el usuario definido con \fInombre\-usuario\fP
o \fIuid\fP. Nota: tenga en cuenta que utilizar solo esta opción de búsqueda
provoca actuar sobre todos los procesos que coinciden con el usuario.
.
.SS "Generic options"
.TP 
\fB\-g\fP, \fB\-\-group\fP \fIgrupo\fP|\fIgid\fP
Pasa a \fIgrupo\fP o \fIgid\fP cuando comienza el proceso.
.TP 
\fB\-s\fP, \fB\-\-signal\fP \fIseñal\fP
Junto con \fB\-\-stop\fP, define la señal enviada al proceso que se desea parar
(TERM por omisión).
.TP 
\fB\-R\fP, \fB\-\-retry\fP \fItiempo\-de\-espera\fP|\fIacción\-programada\fP
Junto con \fB\-\-stop\fP, especifica que \fBstart\-stop\-daemon\fP compruebe que el
proceso o los procesos han terminado. Lo comprobará repetidas veces hasta
que no haya ningún proceso que coincida. Si el proceso no termina tomará una
decisión determinada por \fIacción\-programada\fP.

Si se especifica \fItiempo\-de\-espera\fP en vez de \fIacción\-programada\fP, se usa
la secuencia \fIseñal\fP\fB/\fP\fItiempo\-de\-espera\fP\fB/KILL/\fP\fItiempo\-de\-espera\fP,
donde \fIseñal\fP es la señal definida con \fB\-\-signal\fP.

\fIacción\-programada\fP es una lista de al menos dos elementos separados por
barras (\fB/\fP); cada elemento puede ser un \fB\-\fP\fInúmero\fP\fBde\fP\fIseñal\fP o
[\fB\-\fP]\fInombre\-de\-señal\fP, que significa que se debe mandar esa señal, o
\fItiempo\-de\-espera\fP, que significa que se debe esperar tantos segundos para
que el programa termine, o \fBforever\fP, que significa que se repita el resto
de la acción programada indefinidamente si es necesario.

Si se alcanza el final de la acción programada y no se ha especificado
\fBforever\fP, \fBstart\-stop\-daemon\fP termina con un estado de error 2. Si se
especifica una acción programada cualquier señal especificada con
\fB\-\-signal\fP no se tendrá en cuenta.
.TP 
\fB\-a\fP, \fB\-\-startas\fP \fInombre\-ruta\fP
Con \fB\-\-start\fP, comienza el proceso definido con \fInombre\-ruta\fP. Si no se
define, se usarán los argumentos dados con \fB\-\-exec\fP.
.TP 
\fB\-t\fP, \fB\-\-test\fP
Muestra las acciones que se realizarían y devuelve el valor apropiado, pero
no hace nada.
.TP 
\fB\-o\fP, \fB\-\-oknodo\fP
Devuelve un estado 0 en vez de 1 si no se realiza (o se vayan a realizar)
ninguna acción.
.TP 
\fB\-q\fP, \fB\-\-quiet\fP
No muestra mensajes informativos, sólo muestra mensajes de error.
.TP 
\fB\-c\fP, \fB\-\-chuid\fP \fInombre\-usuario\fP|\fIuid\fP[\fB:\fP\fIgrupo\fP|\fIgid\fP]
Change to this username/uid before starting the process. You can also
specify a group by appending a \fB:\fP, then the group or gid in the same way
as you would for the \fBchown\fP(1) command (\fIuser\fP\fB:\fP\fIgroup\fP).  If a user
is specified without a group, the primary GID for that user is used.  When
using this option you must realize that the primary and supplemental groups
are set as well, even if the \fB\-\-group\fP option is not specified. The
\fB\-\-group\fP option is only for groups that the user isn't normally a member
of (like adding per process group membership for generic users like
\fBnobody\fP).
.TP 
\fB\-r\fP, \fB\-\-chroot\fP \fIdirectorio\-raíz\fP
Ejecuta «chdir» y «chroot» sobre el \fIdirectorio\-raíz\fP antes de empezar el
proceso. Tenga en cuenta que el fichero pid también se escribe después de la
jaula de chroot.
.TP 
\fB\-d\fP, \fB\-\-chdir\fP \fIruta\fP
Chdir to \fIpath\fP before starting the process. This is done after the chroot
if the \fB\-r\fP|\fB\-\-chroot\fP option is set. When not specified,
\fBstart\-stop\-daemon\fP will chdir to the root directory before starting the
process.
.TP 
\fB\-b\fP, \fB\-\-background\fP
Typically used with programs that don't detach on their own. This option
will force \fBstart\-stop\-daemon\fP to fork before starting the process, and
force it into the background.  \fBWarning: start\-stop\-daemon\fP cannot check
the exit status if the process fails to execute for \fBany\fP reason. This is a
last resort, and is only meant for programs that either make no sense
forking on their own, or where it's not feasible to add the code for them to
do this themselves.
.TP 
\fB\-C\fP, \fB\-\-no\-close\fP
Do not close any file descriptor when forcing the daemon into the background
(since version 1.16.5).  Used for debugging purposes to see the process
output, or to redirect file descriptors to log the process output.  Only
relevant when using \fB\-\-background\fP.
.TP 
\fB\-N\fP, \fB\-\-nicelevel\fP \fIentero\fP
Altera la prioridad del proceso antes de iniciarlo.
.TP 
\fB\-P\fP, \fB\-\-procsched\fP \fIdirectriz\fP\fB:\fP\fIprioridad\fP
This alters the process scheduler policy and priority of the process before
starting it (since version 1.15.0).  The priority can be optionally
specified by appending a \fB:\fP followed by the value. The default \fIpriority\fP
is 0. The currently supported policy values are \fBother\fP, \fBfifo\fP and \fBrr\fP.
.TP 
\fB\-I\fP, \fB\-\-iosched\fP \fIclase\fP\fB:\fP\fIprioridad\fP
This alters the IO scheduler class and priority of the process before
starting it (since version 1.15.0).  The priority can be optionally
specified by appending a \fB:\fP followed by the value. The default \fIpriority\fP
is 4, unless \fIclass\fP is \fBidle\fP, then \fIpriority\fP will always be 7. The
currently supported values for \fIclass\fP are \fBidle\fP, \fBbest\-effort\fP and
\fBreal\-time\fP.
.TP 
\fB\-k\fP, \fB\-\-umask\fP \fImask\fP
This sets the umask of the process before starting it (since version
1.13.22).
.TP 
\fB\-m\fP, \fB\-\-make\-pidfile\fP
Used when starting a program that does not create its own pid file. This
option will make \fBstart\-stop\-daemon\fP create the file referenced with
\fB\-\-pidfile\fP and place the pid into it just before executing the
process. Note, the file will only be removed when stopping the program if
\fB\-\-remove\-pidfile\fP is used.  \fBNote:\fP This feature may not work in all
cases. Most notably when the program being executed forks from its main
process. Because of this, it is usually only useful when combined with the
\fB\-\-background\fP option.
.TP 
\fB\-\-remove\-pidfile\fP
Used when stopping a program that does not remove its own pid file (since
version 1.17.19).  This option will make \fBstart\-stop\-daemon\fP remove the
file referenced with \fB\-\-pidfile\fP after terminating the process.
.TP 
\fB\-v\fP, \fB\-\-verbose\fP
Muestra mensajes informativos detallados.
.
.SH "ESTADOS DE SALIDA"
.TP 
\fB0\fP
La acción requerida se ha llevado a cabo. Si se define \fB\-\-oknodo\fP es
posible que nada ocurra. Esto se puede dar si se define \fB\-\-start\fP y se
detecta una coincidencia con un proceso en ejecución, o cuando se define
\fB\-\-stop\fP y no concuerda ningún proceso.
.TP 
\fB1\fP
Si se define \fB\-\-oknodo\fP y no se ha hecho nada.
.TP 
\fB2\fP
Si se define \fB\-\-stop\fP y \fB\-\-retry\fP, pero los procesos aún se estaban
ejecutando tras alcanzar el límite de tiempo («schedule»).
.TP 
\fB3\fP
Cualquier otro fallo.
.PP
Al utilizar la orden \fB\-\-status\fP se devuelven los siguientes estados de
salida:
.TP 
\fB0\fP
El programa está en ejecución.
.TP 
\fB1\fP
El programa no se está ejecutando y el fichero de proceso PID existe.
.TP 
\fB3\fP
El programa no se está ejecutando.
.TP 
\fB4\fP
No se puede determinar el estado del programa.
.
.SH EJEMPLO
Arranca el demonio \fBfood\fP, a menos que se esté ejecutando uno (un proceso
llamado «food», ejecutándose como usuario «food», y con pid en «food.pid»):
.IP
.nf
start\-stop\-daemon \-\-start \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-startas /usr/sbin/food \e
	\-\-chuid food \-\- \-\-daemon
.fi
.PP
Envía \fBSIGTERM\fP a \fBfood\fP y espera 5 segundos para su finalización:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry 5
.fi
.PP
Un ejemplo de una acción programada personalizada para detener \fBfood\fP:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry=TERM/30/KILL/5
.fi
.SH TRADUCTOR
Rudy Godoy <rudy@kernel\-panik.org>,
Rubén Porras <nahoo@inicia.es>,
Bruno Barrera C. <bruno.barrera@igloo.cl>,
Carlos Izquierdo <gheesh@ertis.net>,
Esteban Manchado y
NOK.
Debian L10n Spanish <debian\-l10n\-spanish@lists.debian.org>.
.br
Revisiones por Santiago Vila <sanvila@unex.es>,
Javier Fernández\-Sanguino, Rubén Porras,
Luis Uribe y Omar Campagne.
