.\" Man page generated from reStructuredText.
.
.TH "KPROPLOG" "8" " " "1.16" "MIT Kerberos"
.SH NAME
kproplog \- display the contents of the Kerberos principal update log
.
.nr rst2man-indent-level 0
.
.de1 rstReportMargin
\\$1 \\n[an-margin]
level \\n[rst2man-indent-level]
level margin: \\n[rst2man-indent\\n[rst2man-indent-level]]
-
\\n[rst2man-indent0]
\\n[rst2man-indent1]
\\n[rst2man-indent2]
..
.de1 INDENT
.\" .rstReportMargin pre:
. RS \\$1
. nr rst2man-indent\\n[rst2man-indent-level] \\n[an-margin]
. nr rst2man-indent-level +1
.\" .rstReportMargin post:
..
.de UNINDENT
. RE
.\" indent \\n[an-margin]
.\" old: \\n[rst2man-indent\\n[rst2man-indent-level]]
.nr rst2man-indent-level -1
.\" new: \\n[rst2man-indent\\n[rst2man-indent-level]]
.in \\n[rst2man-indent\\n[rst2man-indent-level]]u
..
.SH SYNOPSIS
.sp
\fBkproplog\fP [\fB\-h\fP] [\fB\-e\fP \fInum\fP] [\-v]
\fBkproplog\fP [\-R]
.SH DESCRIPTION
.sp
The kproplog command displays the contents of the KDC database update
log to standard output.  It can be used to keep track of incremental
updates to the principal database.  The update log file contains the
update log maintained by the \fIkadmind(8)\fP process on the master
KDC server and the \fIkpropd(8)\fP process on the slave KDC servers.
When updates occur, they are logged to this file.  Subsequently any
KDC slave configured for incremental updates will request the current
data from the master KDC and update their log file with any updates
returned.
.sp
The kproplog command requires read access to the update log file.  It
will display update entries only for the KDC it runs on.
.sp
If no options are specified, kproplog displays a summary of the update
log.  If invoked on the master, kproplog also displays all of the
update entries.  If invoked on a slave KDC server, kproplog displays
only a summary of the updates, which includes the serial number of the
last update received and the associated time stamp of the last update.
.SH OPTIONS
.INDENT 0.0
.TP
.B \fB\-R\fP
Reset the update log.  This forces full resynchronization.  If used
on a slave then that slave will request a full resync.  If used on
the master then all slaves will request full resyncs.
.TP
.B \fB\-h\fP
Display a summary of the update log.  This information includes
the database version number, state of the database, the number of
updates in the log, the time stamp of the first and last update,
and the version number of the first and last update entry.
.TP
.B \fB\-e\fP \fInum\fP
Display the last \fInum\fP update entries in the log.  This is useful
when debugging synchronization between KDC servers.
.TP
.B \fB\-v\fP
Display individual attributes per update.  An example of the
output generated for one entry:
.INDENT 7.0
.INDENT 3.5
.sp
.nf
.ft C
Update Entry
   Update serial # : 4
   Update operation : Add
   Update principal : test@EXAMPLE.COM
   Update size : 424
   Update committed : True
   Update time stamp : Fri Feb 20 23:37:42 2004
   Attributes changed : 6
         Principal
         Key data
         Password last changed
         Modifying principal
         Modification time
         TL data
.ft P
.fi
.UNINDENT
.UNINDENT
.UNINDENT
.SH ENVIRONMENT
.sp
kproplog uses the following environment variables:
.INDENT 0.0
.IP \(bu 2
\fBKRB5_KDC_PROFILE\fP
.UNINDENT
.SH SEE ALSO
.sp
\fIkpropd(8)\fP
.SH AUTHOR
MIT
.SH COPYRIGHT
1985-2017, MIT
.\" Generated by docutils manpage writer.
.
