.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.ny0
.TH XQueryPointer __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XQueryPointer \- get pointer coordinates
.SH SYNTAX
.HP
Bool XQueryPointer\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, Window
*\fIroot_return\fP\^, Window *\fIchild_return\fP\^, int
*\fIroot_x_return\fP\^, int *\fIroot_y_return\fP\^, int *\fIwin_x_return\fP\^,
int *\fIwin_y_return\fP\^, unsigned int *\fImask_return\fP\^); 
.SH ARGUMENTS
.IP \fIchild_return\fP 1i
Returns the child window that the pointer is located in, if any.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fImask_return\fP 1i
Returns the current state of the modifier keys and pointer buttons.
.ds Ro that the pointer is in
.IP \fIroot_return\fP 1i
Returns the root window \*(Ro.
.IP \fIroot_x_return\fP 1i
.br
.ns
.IP \fIroot_y_return\fP 1i
Return the pointer coordinates relative to the root window's origin.
.IP \fIw\fP 1i
Specifies the window.
.IP \fIwin_x_return\fP 1i
.br
.ns
.IP \fIwin_y_return\fP 1i
Return the pointer coordinates relative to the specified window.
.SH DESCRIPTION
The
.ZN XQueryPointer
function returns the root window the pointer is logically on and the pointer
coordinates relative to the root window's origin.
If
.ZN XQueryPointer
returns 
.ZN False , 
the pointer is not on the same screen as the specified window, and
.ZN XQueryPointer
returns 
.ZN None
to child_return and zero to win_x_return and win_y_return.
If 
.ZN XQueryPointer
returns 
.ZN True , 
the pointer coordinates returned to win_x_return and win_y_return
are relative to the origin of the specified window.
In this case, 
.ZN XQueryPointer
returns the child that contains the pointer, if any,
or else
.ZN None
to child_return.
.LP
.ZN XQueryPointer
returns the current logical state of the keyboard buttons 
and the modifier keys in mask_return.
It sets mask_return to the bitwise inclusive OR of one or more
of the button or modifier key bitmasks to match 
the current state of the mouse buttons and the modifier keys.
.LP
.ZN XQueryPointer
can generate a
.ZN BadWindow 
error.
.SH DIAGNOSTICS
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XGetWindowAttributes(__libmansuffix__),
XQueryTree(__libmansuffix__)
.br
\fI\*(xL\fP
