'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetDeviceButtonActions __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetDeviceButtonActions \- Query the button actions associated with an X Input 
Extension device
.SH SYNOPSIS
.HP
.B Status XkbGetDeviceButtonActions
.BI "(\^Display *" "dpy" "\^,"
.BI "XkbDeviceInfoPtr " "device_info" "\^,"
.BI "Bool " "all_buttons" "\^,"
.BI "unsigned int " "first_button" "\^,"
.BI "unsigned int " "num_buttons" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to X server
.TP
.I \- device_info
structure to update with results
.TP
.I \- all_buttons
True => get information for all buttons
.TP
.I \- first_button
number of first button for which info is desired
.TP
.I \- num_buttons
number of buttons for which info is desired
.SH DESCRIPTION
.LP
.I XkbGetDeviceButtonActions 
queries the server for the desired button information for the device indicated 
by the 
.I device_spec 
field of 
.I device_info 
and waits for a reply. If successful, 
.I XkbGetDeviceButtonActions 
backfills the button actions 
.I (btn_acts 
field of 
.I device_info) 
for only the requested buttons, updates the 
.I name, type, supported, 
and 
.I unsupported 
fields, and returns Success.

.I all_buttons, first_button 
and 
.I num_buttons 
specify the device buttons for which actions should be returned. Setting
.I all_buttons 
to True requests actions for all device buttons; if 
.I all_buttons 
is False, 
.I first_button 
and 
.I num_buttons 
specify a range of buttons for which actions are requested.

If a compatible version of Xkb is not available in the server or the Xkb 
extension has not been properly initialized, 
.I XkbGetDeviceButtonActions 
returns BadAccess. If allocation errors occur, a BadAlloc status is returned. If 
the specified device 
.I (device_info->device_spec) 
is invalid, a BadKeyboard status is returned. If the device has no buttons, a 
BadMatch status is returned. If 
.I first_button 
and 
.I num_buttons 
specify illegal buttons, a BadValue status is returned. 
.SH DIAGNOSTICS
.TP 15
.B BadAccess
The Xkb extension has not been properly initialized
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadKeyboard
The device specified was not a valid core or input extension device
.TP 15
.B BadMatch
A compatible version of Xkb was not available in the server or an argument has 
correct type and range, but is otherwise invalid
.TP 15
.B BadValue
An argument is out of range
