.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\" Copyright \(co 2000  The XFree86 Project, Inc.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XmbTextExtents __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XmbTextExtents, XwcTextExtents, Xutf8TextExtents \- compute text extents
.SH SYNTAX
.HP
int XmbTextExtents\^(\^XFontSet \fIfont_set\fP\^, char *\fIstring\fP\^, int
\fInum_bytes\fP\^, XRectangle *\fIoverall_ink_return\fP\^, XRectangle
*\fIoverall_logical_return\fP\^);
.HP
int XwcTextExtents\^(\^XFontSet \fIfont_set\fP\^, wchar_t *\fIstring\fP\^, int
\fInum_wchars\fP\^, XRectangle *\fIoverall_ink_return\fP\^, XRectangle
*\fIoverall_logical_return\fP\^);
.HP
int Xutf8TextExtents\^(\^XFontSet \fIfont_set\fP\^, char *\fIstring\fP\^, int
\fInum_bytes\fP\^, XRectangle *\fIoverall_ink_return\fP\^, XRectangle
*\fIoverall_logical_return\fP\^);
.SH ARGUMENTS
.IP \fIfont_set\fP 1i
Specifies the font set.
.IP \fInum_bytes\fP 1i
Specifies the number of bytes in the string argument.
.IP \fInum_wchars\fP 1i
Specifies the number of characters in the string argument.
.IP \fIoverall_ink_return\fP 1i
Returns the overall ink dimensions.
.IP \fIoverall_logical_return\fP 1i
Returns the overall logical dimensions.
.IP \fIstring\fP 1i
Specifies the character string.
.SH DESCRIPTION
The
.BR XmbTextExtents ,
.B XwcTextExtents
and
.B Xutf8TextExtents
functions set the components of the specified overall_ink_return and
overall_logical_return
arguments to the overall bounding box of the string's image
and a logical bounding box for spacing purposes, respectively.
They return the value returned by
.BR XmbTextEscapement ,
.B XwcTextEscapement
or
.BR Xutf8TextEscapement .
These metrics are relative to the drawing origin of the string,
using the fonts loaded for the specified font set.
.LP
If the overall_ink_return argument is non-NULL,
it is set to the bounding box of the string's character ink.
The overall_ink_return for a nondescending, horizontally drawn
Latin character is conventionally entirely above the baseline;
that is, overall_ink_return.height <= \-overall_ink_return.y.
The overall_ink_return for a nonkerned character
is entirely at, and to the right of, the origin;
that is, overall_ink_return.x >= 0.
A character consisting of a single pixel at the origin would set
overall_ink_return fields y = 0, x = 0, width = 1, and height = 1.
.LP
If the overall_logical_return argument is non-NULL,
it is set to the bounding box that provides minimum spacing
to other graphical features for the string.
Other graphical features, for example, a border surrounding the text,
should not intersect this rectangle.
.LP
When the
.B XFontSet
has missing charsets,
metrics for each unavailable character are taken
from the default string returned by
.B XCreateFontSet
so that the metrics represent the text as it will actually be drawn.
The behavior for an invalid codepoint is undefined.
.LP
The function
.B Xutf8TextExtents
is an extension introduced by The XFree86 Project, Inc., in their 4.0.2
release.
Its presence is
indicated by the macro
.BR X_HAVE_UTF8_STRING .
.SH "SEE ALSO"
XmbTextEscapement(__libmansuffix__),
XmbTextPerCharExtents(__libmansuffix__)
\fI\*(xL\fP
