.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XGrabPointer __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XGrabPointer, XUngrabPointer, XChangeActivePointerGrab \- grab the pointer
.SH SYNTAX
.HP
int XGrabPointer\^(\^Display *\fIdisplay\fP\^, Window \fIgrab_window\fP\^,
Bool \fIowner_events\fP\^, unsigned int \fIevent_mask\fP\^, int
\fIpointer_mode\fP\^, int \fIkeyboard_mode\fP\^, Window \fIconfine_to\fP\^,
Cursor \fIcursor\fP\^, Time \fItime\fP\^);
.HP
int XUngrabPointer\^(\^Display *\fIdisplay\fP\^, Time \fItime\fP\^);
.HP
int XChangeActivePointerGrab\^(\^Display *\fIdisplay\fP\^, unsigned int
\fIevent_mask\fP\^, Cursor \fIcursor\fP\^, Time \fItime\fP\^);
.SH ARGUMENTS
.IP \fIconfine_to\fP 1i
Specifies the window to confine the pointer in or
.BR None .
.IP \fIcursor\fP 1i
Specifies the cursor that is to be displayed during the grab or
.BR None .
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIevent_mask\fP 1i
Specifies which pointer events are reported to the client.
The mask is the bitwise inclusive OR of the valid pointer event mask bits.
.IP \fIgrab_window\fP 1i
Specifies the grab window.
.IP \fIkeyboard_mode\fP 1i
Specifies further processing of keyboard events.
You can pass
.B GrabModeSync
or
.BR GrabModeAsync .
.IP \fIowner_events\fP 1i
Specifies a Boolean value that indicates whether the pointer
events are to be reported as usual or reported with respect to the grab window
if selected by the event mask.
.IP \fIpointer_mode\fP 1i
Specifies further processing of pointer events.
You can pass
.B GrabModeSync
or
.BR GrabModeAsync .
.IP \fItime\fP 1i
Specifies the time.
You can pass either a timestamp or
.BR CurrentTime .
.SH DESCRIPTION
The
.B XGrabPointer
function actively grabs control of the pointer and returns
.B GrabSuccess
if the grab was successful.
Further pointer events are reported only to the grabbing client.
.B XGrabPointer
overrides any active pointer grab by this client.
If owner_events is
.BR False ,
all generated pointer events
are reported with respect to grab_window and are reported only if
selected by event_mask.
If owner_events is
.B True
and if a generated
pointer event would normally be reported to this client,
it is reported as usual.
Otherwise, the event is reported with respect to the
grab_window and is reported only if selected by event_mask.
For either value of owner_events, unreported events are discarded.
.LP
If the pointer_mode is
.BR GrabModeAsync ,
pointer event processing continues as usual.
If the pointer is currently frozen by this client,
the processing of events for the pointer is resumed.
If the pointer_mode is
.BR GrabModeSync ,
the state of the pointer, as seen by
client applications,
appears to freeze, and the X server generates no further pointer events
until the grabbing client calls
.B XAllowEvents
or until the pointer grab is released.
Actual pointer changes are not lost while the pointer is frozen;
they are simply queued in the server for later processing.
.LP
If the keyboard_mode is
.BR GrabModeAsync ,
keyboard event processing is unaffected by activation of the grab.
If the keyboard_mode is
.BR GrabModeSync ,
the state of the keyboard, as seen by
client applications,
appears to freeze, and the X server generates no further keyboard events
until the grabbing client calls
.B XAllowEvents
or until the pointer grab is released.
Actual keyboard changes are not lost while the pointer is frozen;
they are simply queued in the server for later processing.
.LP
If a cursor is specified, it is displayed regardless of what
window the pointer is in.
If
.B None
is specified,
the normal cursor for that window is displayed
when the pointer is in grab_window or one of its subwindows;
otherwise, the cursor for grab_window is displayed.
.LP
If a confine_to window is specified,
the pointer is restricted to stay contained in that window.
The confine_to window need have no relationship to the grab_window.
If the pointer is not initially in the confine_to window,
it is warped automatically to the closest edge
just before the grab activates and enter/leave events are generated as usual.
If the confine_to window is subsequently reconfigured,
the pointer is warped automatically, as necessary,
to keep it contained in the window.
.LP
The time argument allows you to avoid certain circumstances that come up
if applications take a long time to respond or if there are long network
delays.
Consider a situation where you have two applications, both
of which normally grab the pointer when clicked on.
If both applications specify the timestamp from the event,
the second application may wake up faster and successfully grab the pointer
before the first application.
The first application then will get an indication that the other application
grabbed the pointer before its request was processed.
.LP
.B XGrabPointer
generates
.B EnterNotify
and
.B LeaveNotify
events.
.LP
Either if grab_window or confine_to window is not viewable
or if the confine_to window lies completely outside the boundaries of the root
window,
.B XGrabPointer
fails and returns
.BR GrabNotViewable .
If the pointer is actively grabbed by some other client,
it fails and returns
.BR AlreadyGrabbed .
If the pointer is frozen by an active grab of another client,
it fails and returns
.BR GrabFrozen .
If the specified time is earlier than the last-pointer-grab time or later
than the current X server time, it fails and returns
.BR GrabInvalidTime .
Otherwise, the last-pointer-grab time is set to the specified time
.RB ( CurrentTime
is replaced by the current X server time).
.LP
.B XGrabPointer
can generate
.BR BadCursor ,
.BR BadValue ,
and
.B BadWindow
errors.
.LP
The
.B XUngrabPointer
function releases the pointer and any queued events
if this client has actively grabbed the pointer from
.BR XGrabPointer ,
.BR XGrabButton ,
or from a normal button press.
.B XUngrabPointer
does not release the pointer if the specified
time is earlier than the last-pointer-grab time or is later than the
current X server time.
It also generates
.B EnterNotify
and
.B LeaveNotify
events.
The X server performs an
.B UngrabPointer
request automatically if the event window or confine_to window
for an active pointer grab becomes not viewable
or if window reconfiguration causes the confine_to window to lie completely
outside the boundaries of the root window.
.LP
The
.B XChangeActivePointerGrab
function changes the specified dynamic parameters if the pointer is actively
grabbed by the client and if the specified time is no earlier than the
last-pointer-grab time and no later than the current X server time.
This function has no effect on the passive parameters of a
.BR XGrabButton .
The interpretation of event_mask and cursor is the same as described in
.BR XGrabPointer .
.LP
.B XChangeActivePointerGrab
can generate a
.B BadCursor
and
.B BadValue
error.
.SH DIAGNOSTICS
.TP 1i
.B BadCursor
A value for a Cursor argument does not name a defined Cursor.
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllowEvents(__libmansuffix__),
XGrabButton(__libmansuffix__),
XGrabKey(__libmansuffix__),
XGrabKeyboard(__libmansuffix__)
.br
\fI\*(xL\fP
