/*
 * Copyright © 2013-2014 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 or 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Kevin DuBois <kevin.dubois@canonical.com>
 */

#ifndef MIR_TEST_DOUBLES_MOCK_SCENE_SESSION_H_
#define MIR_TEST_DOUBLES_MOCK_SCENE_SESSION_H_

#include "mir/scene/session.h"
#include "mir/scene/surface.h"
#include "mir/graphics/display_configuration.h"
#include "mir/input/mir_input_config.h"
#include "mir/client_visible_error.h"
#include "mir/shell/surface_specification.h"

#include <gmock/gmock.h>

namespace mir
{
namespace test
{
namespace doubles
{

struct MockSceneSession : public scene::Session
{
    MOCK_METHOD3(create_surface,
        std::shared_ptr<scene::Surface>(
            std::shared_ptr<Session> const&,
            shell::SurfaceSpecification const&,
            std::shared_ptr<scene::SurfaceObserver> const&));
    MOCK_METHOD1(destroy_surface, void(std::shared_ptr<scene::Surface> const&));
    MOCK_CONST_METHOD1(surface_after, std::shared_ptr<scene::Surface>(std::shared_ptr<scene::Surface> const&));

    MOCK_CONST_METHOD0(default_surface, std::shared_ptr<scene::Surface>());

    MOCK_CONST_METHOD0(name, std::string());
    MOCK_CONST_METHOD0(process_id, pid_t());
    MOCK_CONST_METHOD0(socket_fd, Fd());

    MOCK_METHOD0(hide, void());
    MOCK_METHOD0(show, void());

    MOCK_METHOD1(send_error, void(ClientVisibleError const&));
    MOCK_METHOD1(send_input_config, void(MirInputConfig const&));

    MOCK_METHOD1(set_lifecycle_state, void(MirLifecycleState state));

    MOCK_METHOD0(start_prompt_session, void());
    MOCK_METHOD0(stop_prompt_session, void());
    MOCK_METHOD0(suspend_prompt_session, void());
    MOCK_METHOD0(resume_prompt_session, void());

    MOCK_METHOD1(create_buffer_stream, std::shared_ptr<compositor::BufferStream>(graphics::BufferProperties const&));
    MOCK_METHOD1(destroy_buffer_stream, void(std::shared_ptr<frontend::BufferStream> const&));
    
    MOCK_METHOD2(configure_streams, void(scene::Surface&, std::vector<shell::StreamSpecification> const&));
    MOCK_METHOD1(destroy_surface, void (std::weak_ptr<scene::Surface> const&));
};

}
}
} // namespace mir

#endif // MIR_TEST_DOUBLES_MOCK_SESSION_H_
