/*
 * Collection of tag implications and a Filter to apply or compress them
 *
 * Copyright (C) 2003--2008  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tagcoll/Implications.h>
#include <tests/test-utils.h>

#include <tagcoll/coll/simple.h>

namespace tut {
using namespace std;
using namespace tagcoll;
using namespace tagcoll::tests;

struct tagcoll_implications_shar {
};
TESTGRP(tagcoll_implications);


template<> template<>
void to::test<1>()
{
	std::string input_coll(
			"a: coffee, milk\n"
			"b: tea, milk\n"
			"c: coffee, milk, sugar\n"
			"d: sugar\n"
			);
	std::string input_impl(
			"sugar: sweet\n"
			"coffee: awake, bitter\n"
			"tea: awake\n"
			);
	std::string output_coll(
			"a: coffee, milk, awake, bitter\n"
			"b: tea, milk, awake\n"
			"c: coffee, milk, sugar, awake, sweet, bitter\n"
			"d: sugar, sweet\n"
			);
	coll::Simple<string, string> result;
	Implications<string> implications;

	parseCollection(input_impl, inserter(implications));
	parseCollection(input_coll, addImplied(implications, inserter(result))); 

	coll::Simple<string, string> reference;
	parseCollection(output_coll, inserter(reference));

	ensure_coll_equals(reference, result);
}

template<> template<>
void to::test<2>()
{
	std::string input_coll(
			"a: coffee, milk, awake, bitter\n"
			"b: tea, milk, awake\n"
			"c: coffee, milk, sugar, awake, sweet, bitter\n"
			"d: sugar, sweet\n"
			);
	std::string input_impl(
			"sugar: sweet\n"
			"coffee: awake, bitter\n"
			"tea: awake\n"
			);
	std::string output_coll(
			"a: coffee, milk\n"
			"b: tea, milk\n"
			"c: coffee, milk, sugar\n"
			"d: sugar\n"
			);
	coll::Simple<string, string> result;
	Implications<string> implications;

	parseCollection(input_impl, inserter(implications));
	parseCollection(input_coll, removeImplied(implications, inserter(result)));

	coll::Simple<string, string> reference;
	parseCollection(output_coll, inserter(reference));

	ensure_coll_equals(reference, result);
}

}

#include <tagcoll/TextFormat.tcc>
#include <tagcoll/Implications.tcc>
#include <tagcoll/coll/simple.tcc>

// vim:set ts=4 sw=4:
