/*
 * On2 Audio for Video Codec decoder
 *
 * Copyright (c) 2013 Konstantin Shishkov
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "on2avcdata.h"

static const int on2avc_swb_start_long[] = {
      0,   4,   8,  12,  16,  20,  24,  28,  32,  36,  40,  48,  56,  64,
     72,  80,  88,  96, 108, 120, 132, 144, 156, 172, 188, 204, 224, 244,
    264, 288, 312, 340, 368, 400, 432, 464, 496, 528, 560, 592, 624, 656,
    688, 720, 752, 784, 816, 848, 880, 1024
};

static const int on2avc_swb_start_short[] = {
    0, 4, 8, 12, 16, 20, 24, 32, 40, 48, 56, 68, 80, 108, 128
};

static const int on2avc_swb_start_mode_4_40[] = {
      0,   8,  16,  24,  32,  40,  48,  56,  64,  72,  80,  88,  96, 104,
    112, 120, 128, 144, 160, 176, 192, 208, 224, 240, 256, 264, 272, 280,
    288, 296, 304, 312, 320, 328, 336, 344, 352, 360, 368, 376, 384, 400,
    416, 432, 448, 464, 480, 496, 512, 520, 528, 536, 544, 552, 560, 568,
    576, 584, 592, 600, 608, 616, 624, 632, 640, 648, 656, 664, 672, 680,
    688, 696, 704, 712, 720, 728, 736, 744, 752, 760, 768, 800, 832, 864,
    896, 928, 960, 992, 1024
};

static const int on2avc_swb_start_mode_5_40[] = {
      0,   8,  16,  24,  32,  40,  48,  56,  64,  80,  96, 112, 128, 136,
    144, 152, 160, 168, 176, 184, 192, 208, 224, 240, 256, 264, 272, 280,
    288, 296, 304, 312, 320, 328, 336, 344, 352, 360, 368, 376, 384, 416,
    448, 480, 512, 516, 520, 524, 528, 532, 536, 540, 548, 556, 568, 580,
    592, 608, 624, 640, 656, 672, 688, 704, 720, 736, 752, 768, 784, 800,
    816, 832, 848, 864, 880, 896, 912, 928, 944, 1024
};

static const int on2avc_swb_start_mode_6_40[] = {
      0,   4,   8,  12,  16,  20,  24,  28,  36,  44,  56,  68,  80,  96,
    112, 128, 144, 160, 176, 192, 208, 224, 240, 256, 272, 288, 304, 320,
    336, 352, 368, 384, 400, 416, 432, 512, 520, 528, 536, 544, 552, 560,
    568, 576, 592, 608, 624, 640, 648, 656, 664, 672, 680, 688, 696, 704,
    720, 736, 752, 768, 776, 784, 792, 800, 808, 816, 824, 832, 840, 848,
    856, 864, 872, 880, 888, 896, 928, 960, 992, 1024
};

static const int on2avc_swb_start_mode_4_44[] = {
      0,   8,  16,  24,  32,  40,  48,  56,  64,  72,  80,  88,  96, 104,
    112, 120, 128, 136, 144, 152, 160, 168, 176, 184, 192, 200, 208, 216,
    224, 232, 240, 248, 256, 264, 272, 280, 288, 296, 304, 312, 320, 328,
    336, 344, 352, 360, 368, 376, 384, 392, 400, 408, 416, 424, 432, 440,
    448, 456, 464, 472, 480, 488, 496, 504, 512, 528, 544, 560, 576, 592,
    608, 624, 640, 672, 704, 736, 768, 832, 896, 960, 1024
};

static const int on2avc_swb_start_mode_5_44[] = {
      0,   8,  16,  24,  32,  40,  48,  56,  64,  72,  80,  88,  96, 104,
    112, 120, 128, 136, 144, 152, 160, 168, 176, 184, 192, 200, 208, 216,
    224, 232, 240, 248, 256, 272, 288, 304, 320, 352, 384, 448, 512, 516,
    520, 524, 528, 532, 536, 540, 548, 556, 568, 580, 592, 608, 624, 640,
    656, 672, 688, 704, 720, 736, 752, 768, 784, 800, 816, 832, 848, 864,
    880, 896, 912, 928, 944, 1024
};

static const int on2avc_swb_start_mode_6_44[] = {
      0,   4,   8,  12,  16,  20,  24,  28,  36,  44,  56,  68,  80,  96,
    112, 128, 144, 160, 176, 192, 208, 224, 240, 256, 272, 288, 304, 320,
    336, 352, 368, 384, 400, 416, 432, 512, 520, 528, 536, 544, 552, 560,
    568, 576, 584, 592, 600, 608, 616, 624, 632, 640, 648, 656, 664, 672,
    680, 688, 696, 704, 712, 720, 728, 736, 744, 752, 760, 768, 784, 800,
    816, 832, 864, 896, 960, 1024
};

const On2AVCMode ff_on2avc_modes_40[8] = {
    { 1, 49, on2avc_swb_start_long },
    { 1, 49, on2avc_swb_start_long },
    { 1, 49, on2avc_swb_start_long },
    { 8, 14, on2avc_swb_start_short },
    { 1, 88, on2avc_swb_start_mode_4_40 },
    { 1, 79, on2avc_swb_start_mode_5_40 },
    { 1, 79, on2avc_swb_start_mode_6_40 },
    { 1, 49, on2avc_swb_start_long },
};

const On2AVCMode ff_on2avc_modes_44[8] = {
    { 1, 49, on2avc_swb_start_long },
    { 1, 49, on2avc_swb_start_long },
    { 1, 49, on2avc_swb_start_long },
    { 8, 14, on2avc_swb_start_short },
    { 1, 80, on2avc_swb_start_mode_4_44 },
    { 1, 75, on2avc_swb_start_mode_5_44 },
    { 1, 75, on2avc_swb_start_mode_6_44 },
    { 1, 49, on2avc_swb_start_long },
};

const uint32_t ff_on2avc_scale_diff_codes[ON2AVC_SCALE_DIFFS] = {
    0x6FFFF, 0xBFFF2, 0xBFFF3, 0xBFFF4, 0xBFFF5, 0xBFFF6,
    0xBFFF7, 0xBFFF8, 0xBFFF9, 0xBFFFA, 0xBFFFB, 0xBFFFC,
    0xBFFFD, 0xBFFFE, 0xBFFFF, 0xDF9A0, 0xDF9A1, 0xDF9A2,
    0xDF9A3, 0xDF9A4, 0xDF9A5, 0xDF9A6, 0xDF9A7, 0xDF9A8,
    0xDF9A9, 0x37FFE, 0x6FCDE, 0x6FFFA, 0x0BFF7, 0x0B7FF,
    0x0DF9F, 0x05FF8, 0x0B7FE, 0x05FF9, 0x06FCE, 0x05BFE,
    0x037FE, 0x02DFE, 0x00DFA, 0x00DFE, 0x017FC, 0x00DBE,
    0x00B7E, 0x005FE, 0x0037D, 0x002DE, 0x0017E, 0x0016C,
    0x000DE, 0x000BE, 0x0006C, 0x0005A, 0x0003E, 0x00034,
    0x0002C, 0x0001F, 0x0000E, 0x0000E, 0x00006, 0x00002,
    0x00000, 0x00004, 0x0000A, 0x0000C, 0x0001E, 0x0001E,
    0x0002E, 0x00035, 0x0003F, 0x0005E, 0x0006E, 0x000DA,
    0x0016D, 0x0016E, 0x001B6, 0x002FE, 0x0036E, 0x0037C,
    0x005BE, 0x006DE, 0x006FE, 0x00DBF, 0x00DFB, 0x016FE,
    0x017FD, 0x01BFE, 0x01BF2, 0x02FFE, 0x06FCC, 0x05FFE,
    0x05FFA, 0x06FFE, 0x0BFF6, 0x0BFFE, 0x0DF9E, 0x00DF8,
    0x0DFFE, 0x37FFC, 0x6FFFB, 0x5FFF8, 0xDF9AA, 0xDF9AB,
    0xDF9AC, 0xDF9AD, 0xDF9AE, 0xDF9AF, 0xDF9B0, 0xDF9B1,
    0xDF9B2, 0xDF9B3, 0x6FFFE, 0xDF9B4, 0xDF9B5, 0xDF9B6,
    0xDF9B7, 0xDF9B8, 0xDF9B9, 0xDF9BA, 0xDF9BB, 0xDF9BE,
    0xDF9BF,
};

const uint8_t ff_on2avc_scale_diff_bits[ON2AVC_SCALE_DIFFS] = {
    20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20,
    20, 20, 20, 21, 21, 21,
    21, 21, 21, 21, 21, 21,
    21, 19, 20, 20, 16, 16,
    17, 15, 16, 15, 16, 15,
    15, 14, 13, 13, 13, 13,
    12, 11, 11, 10,  9,  9,
     9,  8,  8,  7,  7,  7,
     6,  5,  5,  4,  3,  3,
     2,  3,  4,  5,  5,  6,
     6,  7,  7,  7,  8,  9,
     9,  9, 10, 10, 11, 11,
    11, 12, 12, 13, 13, 13,
    13, 14, 14, 14, 16, 15,
    15, 16, 16, 16, 17, 13,
    17, 19, 20, 19, 21, 21,
    21, 21, 21, 21, 21, 21,
    21, 21, 20, 21, 21, 21,
    21, 21, 21, 21, 21, 21,
    21,
};

#define ON2AVC_CB1_CODES 41
static const uint32_t on2avc_cb1_codes[ON2AVC_CB1_CODES] = {
    0x0000, 0x0022, 0x001C, 0x001B, 0x0024, 0x0030,
    0x0029, 0x0027, 0x0021, 0x002B, 0x002E, 0x0020,
    0x0026, 0x0033, 0x0031, 0x002C, 0x002A, 0x001E,
    0x0094, 0x01FF, 0x01F7, 0x012E, 0x001A, 0x01F5,
    0x007E, 0x012C, 0x01FC, 0x002D, 0x0032, 0x0028,
    0x002F, 0x001D, 0x01FD, 0x012D, 0x007C, 0x01F4,
    0x0023, 0x012F, 0x01F6, 0x01FE, 0x0095,
};

static const uint8_t on2avc_cb1_bits[ON2AVC_CB1_CODES] = {
    1,  6,  5,  5,  6,  6,
    6,  6,  6,  6,  6,  6,
    6,  6,  6,  6,  6,  5,
    8,  9,  9,  9,  5,  9,
    7,  9,  9,  6,  6,  6,
    6,  5,  9,  9,  7,  9,
    6,  9,  9,  9,  8,
};

static const uint16_t on2avc_cb1_syms[ON2AVC_CB1_CODES] = {
    0x0000, 0x0011, 0x001F, 0x00F1, 0x00FF, 0x0101,
    0x010F, 0x0110, 0x01F0, 0x0F01, 0x0F0F, 0x0F10,
    0x0FF0, 0x1001, 0x100F, 0x1010, 0x10F0, 0x1100,
    0x1111, 0x111F, 0x11F1, 0x11FF, 0x1F00, 0x1F11,
    0x1F1F, 0x1FF1, 0x1FFF, 0xF001, 0xF00F, 0xF010,
    0xF0F0, 0xF100, 0xF111, 0xF11F, 0xF1F1, 0xF1FF,
    0xFF00, 0xFF11, 0xFF1F, 0xFFF1, 0xFFFF,
};

#define ON2AVC_CB2_CODES 41
static const uint32_t on2avc_cb2_codes[ON2AVC_CB2_CODES] = {
    0x0006, 0x0003, 0x001F, 0x001E, 0x0000, 0x0014,
    0x0009, 0x000E, 0x000D, 0x000C, 0x0015, 0x0008,
    0x0010, 0x000F, 0x0004, 0x0012, 0x0007, 0x0016,
    0x0005, 0x002F, 0x0017, 0x0006, 0x001D, 0x002C,
    0x005E, 0x0014, 0x0016, 0x0006, 0x0011, 0x000A,
    0x0013, 0x001C, 0x002D, 0x0015, 0x005F, 0x002E,
    0x0002, 0x0007, 0x005D, 0x005C, 0x0004,
};

static const uint8_t on2avc_cb2_bits[ON2AVC_CB2_CODES] = {
    3,  5,  5,  5,  5,  5,
    5,  5,  5,  5,  5,  5,
    5,  5,  5,  5,  5,  5,
    7,  7,  7,  7,  5,  7,
    7,  7,  7,  5,  5,  5,
    5,  5,  7,  7,  7,  7,
    5,  7,  7,  7,  7,
};

static const uint16_t on2avc_cb2_syms[ON2AVC_CB2_CODES] = {
    0x0000, 0x0011, 0x001F, 0x00F1, 0x00FF, 0x0101,
    0x010F, 0x0110, 0x01F0, 0x0F01, 0x0F0F, 0x0F10,
    0x0FF0, 0x1001, 0x100F, 0x1010, 0x10F0, 0x1100,
    0x1111, 0x111F, 0x11F1, 0x11FF, 0x1F00, 0x1F11,
    0x1F1F, 0x1FF1, 0x1FFF, 0xF001, 0xF00F, 0xF010,
    0xF0F0, 0xF100, 0xF111, 0xF11F, 0xF1F1, 0xF1FF,
    0xFF00, 0xFF11, 0xFF1F, 0xFFF1, 0xFFFF,
};

#define ON2AVC_CB3_CODES 313
static const uint32_t on2avc_cb3_codes[ON2AVC_CB3_CODES] = {
    0x00000, 0x00044, 0x00042, 0x00034, 0x0002E, 0x000CD,
    0x002DF, 0x0024A, 0x000CC, 0x0022E, 0x002D6, 0x00031,
    0x0003B, 0x00048, 0x00052, 0x00056, 0x001B8, 0x00160,
    0x001FA, 0x0015E, 0x0015C, 0x0014E, 0x0003C, 0x0010C,
    0x00166, 0x000CA, 0x0324C, 0x00FDA, 0x003DE, 0x002DB,
    0x0057F, 0x02C9E, 0x008BF, 0x0037F, 0x021DC, 0x00B1E,
    0x002DE, 0x002D2, 0x000C8, 0x014D6, 0x03576, 0x002CA,
    0x002CF, 0x003DB, 0x007FE, 0x01F7E, 0x005A3, 0x008BE,
    0x02D7E, 0x002D3, 0x0037E, 0x0004D, 0x0004C, 0x00041,
    0x0016A, 0x0010D, 0x0015D, 0x0011F, 0x00162, 0x0021E,
    0x00055, 0x00161, 0x001BE, 0x0004E, 0x0004A, 0x0004B,
    0x003EE, 0x00352, 0x0043A, 0x0033E, 0x0035C, 0x0036C,
    0x00050, 0x0032F, 0x003D6, 0x00039, 0x0067E, 0x00536,
    0x000FE, 0x001F4, 0x0036D, 0x007EF, 0x00CFE, 0x002D0,
    0x00F8C, 0x00D96, 0x001E9, 0x001F6, 0x00476, 0x00367,
    0x001F2, 0x01FF6, 0x016BB, 0x007FC, 0x00D5C, 0x00B24,
    0x00C92, 0x0014F, 0x01EA6, 0x01936, 0x00366, 0x0035E,
    0x00116, 0x00FBE, 0x01B5E, 0x0092F, 0x007EE, 0x00CEE,
    0x00B26, 0x0011E, 0x014DF, 0x035DE, 0x00030, 0x00473,
    0x005A2, 0x001BC, 0x000D6, 0x002DA, 0x00B5E, 0x007AA,
    0x002C8, 0x00D94, 0x00D97, 0x001AA, 0x001EE, 0x0003A,
    0x035DF, 0x03D4F, 0x0064F, 0x0064A, 0x02D73, 0x1ABBE,
    0x0B1CF, 0x00F8E, 0x06AFF, 0x0475E, 0x00472, 0x00596,
    0x003E7, 0x0036E, 0x00196, 0x0357E, 0x03F6E, 0x0324E,
    0x0324F, 0x0163B, 0x0192F, 0x001B4, 0x0326A, 0x02C9F,
    0x0021F, 0x0F8FF, 0x064D6, 0x007BE, 0x00DDF, 0x033BC,
    0x033BD, 0x06AEE, 0x00876, 0x07C7E, 0x0B1CE, 0x00D76,
    0x00DDC, 0x001EC, 0x0649B, 0x0B1CD, 0x00F8D, 0x007D6,
    0x01AEE, 0x0163F, 0x03E3E, 0x00A6A, 0x06D7E, 0x0DDDF,
    0x00F7E, 0x00DAE, 0x0036F, 0x00338, 0x0016C, 0x033BF,
    0x036BE, 0x01FF7, 0x01937, 0x01ABA, 0x014D7, 0x0014C,
    0x01F7F, 0x0475F, 0x00040, 0x07FFC, 0x03F6F, 0x00477,
    0x00496, 0x014DE, 0x0649A, 0x064D7, 0x02C9C, 0x0B1CC,
    0x1ABBF, 0x00648, 0x006BA, 0x00364, 0x0032E, 0x00126,
    0x03D4E, 0x02C72, 0x011D6, 0x01638, 0x01934, 0x02C9D,
    0x0016E, 0x021DD, 0x03DFF, 0x001F0, 0x07FFE, 0x043BF,
    0x00D5E, 0x00FAE, 0x0092E, 0x07FFF, 0x0F8FE, 0x02D7F,
    0x043BE, 0x06D7F, 0x008E9, 0x00FFA, 0x0021C, 0x06EEE,
    0x0D5DE, 0x00F57, 0x00CFF, 0x016BA, 0x07FFD, 0x06AFE,
    0x021DE, 0x0DDDE, 0x023AE, 0x00FAF, 0x006D6, 0x0037B,
    0x003E6, 0x001B9, 0x01F1E, 0x033BE, 0x0192E, 0x016BE,
    0x01FB6, 0x01BBA, 0x0019E, 0x03776, 0x03DFE, 0x00046,
    0x00051, 0x0004F, 0x003D7, 0x0033A, 0x00376, 0x00353,
    0x00356, 0x003EA, 0x00054, 0x00339, 0x003E2, 0x0002F,
    0x0064C, 0x00534, 0x00238, 0x001A8, 0x002C6, 0x00D95,
    0x00F52, 0x002CE, 0x007DE, 0x00B2F, 0x000D8, 0x001BA,
    0x0036A, 0x0035F, 0x00127, 0x01EFE, 0x016B8, 0x008EA,
    0x00CEC, 0x007EC, 0x00A6E, 0x00114, 0x01ABE, 0x00FFE,
    0x0037A, 0x0045E, 0x00124, 0x0163E, 0x02D72, 0x00CED,
    0x00B2E, 0x00C96, 0x007A8, 0x001FE, 0x0163A, 0x01FFE,
    0x00038, 0x0057E, 0x0064E, 0x001F8, 0x001E8, 0x002BE,
    0x00DDE, 0x00F56, 0x003DA, 0x00B25, 0x008E8, 0x001F9,
    0x00115,
};

static const uint8_t on2avc_cb3_bits[ON2AVC_CB3_CODES] = {
     1,  7,  7,  6,  6,  8,
    10, 10,  8, 10, 10,  6,
     6,  7,  7,  7,  9,  9,
     9,  9,  9,  9,  6,  9,
     9,  8, 14, 12, 10, 10,
    11, 14, 12, 10, 14, 12,
    10, 10,  8, 13, 14, 10,
    10, 10, 11, 13, 11, 12,
    14, 10, 10,  7,  7,  7,
     9,  9,  9,  9,  9, 10,
     7,  9,  9,  7,  7,  7,
    10, 10, 11, 10, 10, 10,
     7, 10, 10,  6, 11, 11,
     8,  9, 10, 11, 12, 10,
    12, 12,  9,  9, 11, 10,
     9, 13, 13, 11, 12, 12,
    12,  9, 13, 13, 10, 10,
     9, 12, 13, 12, 11, 12,
    12,  9, 13, 14,  6, 11,
    11,  9,  8, 10, 12, 11,
    10, 12, 12,  9,  9,  6,
    14, 14, 11, 11, 14, 17,
    16, 12, 15, 15, 11, 11,
    10, 10,  9, 14, 14, 14,
    14, 13, 13,  9, 14, 14,
    10, 16, 15, 11, 12, 14,
    14, 15, 12, 15, 16, 12,
    12,  9, 15, 16, 12, 11,
    13, 13, 14, 12, 15, 16,
    12, 12, 10, 10,  9, 14,
    14, 13, 13, 13, 13,  9,
    13, 15,  7, 15, 14, 11,
    11, 13, 15, 15, 14, 16,
    17, 11, 11, 10, 10,  9,
    14, 14, 13, 13, 13, 14,
     9, 14, 14,  9, 15, 15,
    12, 12, 12, 15, 16, 14,
    15, 15, 12, 12, 10, 15,
    16, 12, 12, 13, 15, 15,
    14, 16, 14, 12, 11, 10,
    10,  9, 13, 14, 13, 13,
    13, 13,  9, 14, 14,  7,
     7,  7, 10, 10, 10, 10,
    10, 10,  7, 10, 10,  6,
    11, 11, 10,  9, 10, 12,
    12, 10, 11, 12,  8,  9,
    10, 10,  9, 13, 13, 12,
    12, 11, 12,  9, 13, 12,
    10, 11,  9, 13, 14, 12,
    12, 12, 11,  9, 13, 13,
     6, 11, 11,  9,  9, 10,
    12, 12, 10, 12, 12,  9,
     9,
};

static const uint16_t on2avc_cb3_syms[ON2AVC_CB3_CODES] = {
    0x0000, 0x0002, 0x000E, 0x0011, 0x001F, 0x0020,
    0x0022, 0x002E, 0x00E0, 0x00E2, 0x00EE, 0x00F1,
    0x00FF, 0x0101, 0x010F, 0x0110, 0x0112, 0x011E,
    0x0121, 0x012F, 0x01E1, 0x01EF, 0x01F0, 0x01F2,
    0x01FE, 0x0200, 0x0202, 0x020E, 0x0211, 0x021F,
    0x0220, 0x0222, 0x022E, 0x02E0, 0x02E2, 0x02EE,
    0x02F1, 0x02FF, 0x0E00, 0x0E02, 0x0E0E, 0x0E11,
    0x0E1F, 0x0E20, 0x0E22, 0x0E2E, 0x0EE0, 0x0EE2,
    0x0EEE, 0x0EF1, 0x0EFF, 0x0F01, 0x0F0F, 0x0F10,
    0x0F12, 0x0F1E, 0x0F21, 0x0F2F, 0x0FE1, 0x0FEF,
    0x0FF0, 0x0FF2, 0x0FFE, 0x1001, 0x100F, 0x1010,
    0x1012, 0x101E, 0x1021, 0x102F, 0x10E1, 0x10EF,
    0x10F0, 0x10F2, 0x10FE, 0x1100, 0x1102, 0x110E,
    0x1111, 0x111F, 0x1120, 0x1122, 0x112E, 0x11E0,
    0x11E2, 0x11EE, 0x11F1, 0x11FF, 0x1201, 0x120F,
    0x1210, 0x1212, 0x121E, 0x1221, 0x122F, 0x12E1,
    0x12EF, 0x12F0, 0x12F2, 0x12FE, 0x1E01, 0x1E0F,
    0x1E10, 0x1E12, 0x1E1E, 0x1E21, 0x1E2F, 0x1EE1,
    0x1EEF, 0x1EF0, 0x1EF2, 0x1EFE, 0x1F00, 0x1F02,
    0x1F0E, 0x1F11, 0x1F1F, 0x1F20, 0x1F22, 0x1F2E,
    0x1FE0, 0x1FE2, 0x1FEE, 0x1FF1, 0x1FFF, 0x2000,
    0x2002, 0x200E, 0x2011, 0x201F, 0x2020, 0x2022,
    0x202E, 0x20E0, 0x20E2, 0x20EE, 0x20F1, 0x20FF,
    0x2101, 0x210F, 0x2110, 0x2112, 0x211E, 0x2121,
    0x212F, 0x21E1, 0x21EF, 0x21F0, 0x21F2, 0x21FE,
    0x2200, 0x2202, 0x220E, 0x2211, 0x221F, 0x2220,
    0x2222, 0x222E, 0x22E0, 0x22E2, 0x22EE, 0x22F1,
    0x22FF, 0x2E00, 0x2E02, 0x2E0E, 0x2E11, 0x2E1F,
    0x2E20, 0x2E22, 0x2E2E, 0x2EE0, 0x2EE2, 0x2EEE,
    0x2EF1, 0x2EFF, 0x2F01, 0x2F0F, 0x2F10, 0x2F12,
    0x2F1E, 0x2F21, 0x2F2F, 0x2FE1, 0x2FEF, 0x2FF0,
    0x2FF2, 0x2FFE, 0xE000, 0xE002, 0xE00E, 0xE011,
    0xE01F, 0xE020, 0xE022, 0xE02E, 0xE0E0, 0xE0E2,
    0xE0EE, 0xE0F1, 0xE0FF, 0xE101, 0xE10F, 0xE110,
    0xE112, 0xE11E, 0xE121, 0xE12F, 0xE1E1, 0xE1EF,
    0xE1F0, 0xE1F2, 0xE1FE, 0xE200, 0xE202, 0xE20E,
    0xE211, 0xE21F, 0xE220, 0xE222, 0xE22E, 0xE2E0,
    0xE2E2, 0xE2EE, 0xE2F1, 0xE2FF, 0xEE00, 0xEE02,
    0xEE0E, 0xEE11, 0xEE1F, 0xEE20, 0xEE22, 0xEE2E,
    0xEEE0, 0xEEE2, 0xEEEE, 0xEEF1, 0xEEFF, 0xEF01,
    0xEF0F, 0xEF10, 0xEF12, 0xEF1E, 0xEF21, 0xEF2F,
    0xEFE1, 0xEFEF, 0xEFF0, 0xEFF2, 0xEFFE, 0xF001,
    0xF00F, 0xF010, 0xF012, 0xF01E, 0xF021, 0xF02F,
    0xF0E1, 0xF0EF, 0xF0F0, 0xF0F2, 0xF0FE, 0xF100,
    0xF102, 0xF10E, 0xF111, 0xF11F, 0xF120, 0xF122,
    0xF12E, 0xF1E0, 0xF1E2, 0xF1EE, 0xF1F1, 0xF1FF,
    0xF201, 0xF20F, 0xF210, 0xF212, 0xF21E, 0xF221,
    0xF22F, 0xF2E1, 0xF2EF, 0xF2F0, 0xF2F2, 0xF2FE,
    0xFE01, 0xFE0F, 0xFE10, 0xFE12, 0xFE1E, 0xFE21,
    0xFE2F, 0xFEE1, 0xFEEF, 0xFEF0, 0xFEF2, 0xFEFE,
    0xFF00, 0xFF02, 0xFF0E, 0xFF11, 0xFF1F, 0xFF20,
    0xFF22, 0xFF2E, 0xFFE0, 0xFFE2, 0xFFEE, 0xFFF1,
    0xFFFF,
};

#define ON2AVC_CB4_CODES 313
static const uint32_t on2avc_cb4_codes[ON2AVC_CB4_CODES] = {
    0x000A, 0x013B, 0x0127, 0x0004, 0x0015, 0x012C,
    0x065F, 0x08CD, 0x016A, 0x08E7, 0x06BA, 0x001B,
    0x001D, 0x0018, 0x000A, 0x0002, 0x00C0, 0x012B,
    0x00CE, 0x013C, 0x012A, 0x012D, 0x0020, 0x0128,
    0x0121, 0x00FC, 0x066B, 0x0472, 0x010A, 0x004E,
    0x06AE, 0x063F, 0x1ABF, 0x0B4E, 0x084E, 0x1ABE,
    0x010E, 0x0094, 0x00C8, 0x0464, 0x069A, 0x00C9,
    0x00FA, 0x041B, 0x2FDE, 0x08CB, 0x05B7, 0x1ABD,
    0x066A, 0x008D, 0x00F8, 0x0003, 0x001A, 0x001E,
    0x0120, 0x011E, 0x0138, 0x0125, 0x0170, 0x00C4,
    0x000B, 0x013E, 0x00C5, 0x000C, 0x000E, 0x001C,
    0x00FE, 0x009C, 0x010F, 0x0115, 0x009F, 0x008C,
    0x0008, 0x002E, 0x00CF, 0x001C, 0x0110, 0x002F,
    0x002C, 0x0002, 0x0116, 0x01FE, 0x032D, 0x00CB,
    0x030D, 0x02EC, 0x002E, 0x0037, 0x00CF, 0x0086,
    0x00C8, 0x032C, 0x031E, 0x01AC, 0x030C, 0x02ED,
    0x035C, 0x013A, 0x02FF, 0x02E2, 0x00BE, 0x00CE,
    0x0126, 0x0356, 0x034E, 0x0347, 0x025F, 0x0306,
    0x02DA, 0x0168, 0x02E7, 0x020F, 0x0016, 0x0081,
    0x0114, 0x0024, 0x001B, 0x010C, 0x03FE, 0x027F,
    0x0084, 0x02F9, 0x0237, 0x0000, 0x001A, 0x011A,
    0x05A6, 0x04A6, 0x00F9, 0x00CC, 0x05B6, 0x0BF6,
    0x0B96, 0x0446, 0x08CE, 0x007F, 0x002C, 0x000E,
    0x0080, 0x00C9, 0x00BA, 0x035E, 0x03EF, 0x0345,
    0x02FE, 0x02FB, 0x02E6, 0x00D2, 0x021C, 0x0238,
    0x06BB, 0x0B97, 0x007E, 0x01AA, 0x023A, 0x05BE,
    0x031D, 0x094E, 0x1ABC, 0x0948, 0x088E, 0x02E4,
    0x0273, 0x084C, 0x08CC, 0x094B, 0x02D2, 0x023B,
    0x043E, 0x2FDF, 0x063E, 0x109B, 0x08CA, 0x08E6,
    0x02DE, 0x02F4, 0x00D4, 0x002D, 0x00CA, 0x020E,
    0x0344, 0x02FD, 0x030F, 0x02EE, 0x02D6, 0x0123,
    0x02F7, 0x03ED, 0x009E, 0x05CA, 0x060E, 0x000D,
    0x004D, 0x0444, 0x043F, 0x094A, 0x05FA, 0x109A,
    0x0B4F, 0x00FD, 0x0117, 0x0096, 0x0082, 0x0122,
    0x025D, 0x0304, 0x034C, 0x027B, 0x035B, 0x02FC,
    0x00FC, 0x035F, 0x03EE, 0x088B, 0x0C1E, 0x088A,
    0x02F5, 0x0272, 0x17EE, 0x0C1F, 0x084F, 0x088F,
    0x069B, 0x0949, 0x023F, 0x02E3, 0x07FE, 0x041A,
    0x0B7E, 0x027A, 0x0336, 0x07FF, 0x08CF, 0x094F,
    0x065E, 0x0B7F, 0x02DD, 0x0212, 0x01FB, 0x00C6,
    0x0095, 0x00D0, 0x023E, 0x025C, 0x02FC, 0x032E,
    0x025E, 0x021E, 0x00BC, 0x021D, 0x035A, 0x0007,
    0x000F, 0x0006, 0x00C2, 0x000C, 0x00BD, 0x00CD,
    0x0113, 0x0118, 0x001D, 0x00CA, 0x008E, 0x0014,
    0x010D, 0x0085, 0x0001, 0x003E, 0x008F, 0x0236,
    0x030E, 0x00FF, 0x025E, 0x0337, 0x000A, 0x0026,
    0x010B, 0x009D, 0x012E, 0x025F, 0x02EF, 0x0305,
    0x02DC, 0x027E, 0x02FE, 0x0124, 0x034F, 0x003E,
    0x004F, 0x00BC, 0x016C, 0x02D7, 0x03EC, 0x02FA,
    0x02F8, 0x02F6, 0x01FA, 0x00CC, 0x02FF, 0x0334,
    0x001E, 0x004C, 0x0112, 0x0036, 0x0022, 0x00FE,
    0x031C, 0x0346, 0x0108, 0x020C, 0x001E, 0x0012,
    0x0026,
};

static const uint8_t on2avc_cb4_bits[ON2AVC_CB4_CODES] = {
     4,  9,  9,  6,  6,  9,
    11, 12,  9, 12, 11,  6,
     5,  6,  6,  6,  8,  9,
     8,  9,  9,  9,  6,  9,
     9,  9, 11, 11,  9,  9,
    11, 11, 13, 12, 12, 13,
     9,  9,  9, 11, 11,  9,
     9, 12, 14, 12, 11, 13,
    11,  9,  9,  6,  6,  6,
     9,  9,  9,  9,  9,  8,
     6,  9,  8,  6,  6,  6,
     8,  9,  9,  9,  9,  9,
     6,  9,  8,  5,  9,  9,
     6,  7,  9,  9, 10,  9,
    10, 10,  7,  6,  9,  9,
     8, 10, 10,  9, 10, 10,
    10,  9, 11, 10,  9,  9,
     9, 10, 10, 10, 10, 10,
    10,  9, 10, 11,  6,  9,
     9,  7,  7,  9, 10, 10,
     9, 10, 10,  7,  7,  9,
    11, 11,  9,  9, 11, 12,
    12, 11, 12, 12,  9,  9,
     9,  8,  8, 10, 11, 10,
    11, 10, 10,  8, 11, 10,
    11, 12, 12,  9, 10, 11,
    10, 12, 13, 12, 12, 10,
    10, 12, 12, 12, 10, 10,
    12, 14, 11, 13, 12, 12,
    10, 10,  8,  9,  8, 11,
    10, 11, 10, 10, 10,  9,
    10, 11,  9, 11, 11,  9,
     9, 11, 12, 12, 11, 13,
    12,  9,  9,  9,  9,  9,
    11, 10, 10, 10, 10, 11,
     8, 10, 11, 12, 12, 12,
    10, 10, 13, 12, 12, 12,
    11, 12, 10, 10, 11, 12,
    12, 10, 10, 11, 12, 12,
    11, 12, 10, 10,  9,  8,
     9,  8, 10, 11, 10, 10,
    11, 11,  8, 11, 10,  6,
     6,  6,  8,  9,  9,  9,
     9,  9,  6,  9,  9,  6,
     9,  9,  7,  6,  9, 10,
    10,  9, 10, 10,  7,  7,
     9,  9,  9, 11, 10, 10,
    10, 10, 10,  9, 10, 11,
     9,  9,  9, 10, 11, 10,
    10, 10,  9,  8, 10, 10,
     5,  9,  9,  6,  7,  9,
    10, 10,  9, 11, 10,  7,
     6,
};

static const uint16_t on2avc_cb4_syms[ON2AVC_CB4_CODES] = {
    0x0000, 0x0002, 0x000E, 0x0011, 0x001F, 0x0020,
    0x0022, 0x002E, 0x00E0, 0x00E2, 0x00EE, 0x00F1,
    0x00FF, 0x0101, 0x010F, 0x0110, 0x0112, 0x011E,
    0x0121, 0x012F, 0x01E1, 0x01EF, 0x01F0, 0x01F2,
    0x01FE, 0x0200, 0x0202, 0x020E, 0x0211, 0x021F,
    0x0220, 0x0222, 0x022E, 0x02E0, 0x02E2, 0x02EE,
    0x02F1, 0x02FF, 0x0E00, 0x0E02, 0x0E0E, 0x0E11,
    0x0E1F, 0x0E20, 0x0E22, 0x0E2E, 0x0EE0, 0x0EE2,
    0x0EEE, 0x0EF1, 0x0EFF, 0x0F01, 0x0F0F, 0x0F10,
    0x0F12, 0x0F1E, 0x0F21, 0x0F2F, 0x0FE1, 0x0FEF,
    0x0FF0, 0x0FF2, 0x0FFE, 0x1001, 0x100F, 0x1010,
    0x1012, 0x101E, 0x1021, 0x102F, 0x10E1, 0x10EF,
    0x10F0, 0x10F2, 0x10FE, 0x1100, 0x1102, 0x110E,
    0x1111, 0x111F, 0x1120, 0x1122, 0x112E, 0x11E0,
    0x11E2, 0x11EE, 0x11F1, 0x11FF, 0x1201, 0x120F,
    0x1210, 0x1212, 0x121E, 0x1221, 0x122F, 0x12E1,
    0x12EF, 0x12F0, 0x12F2, 0x12FE, 0x1E01, 0x1E0F,
    0x1E10, 0x1E12, 0x1E1E, 0x1E21, 0x1E2F, 0x1EE1,
    0x1EEF, 0x1EF0, 0x1EF2, 0x1EFE, 0x1F00, 0x1F02,
    0x1F0E, 0x1F11, 0x1F1F, 0x1F20, 0x1F22, 0x1F2E,
    0x1FE0, 0x1FE2, 0x1FEE, 0x1FF1, 0x1FFF, 0x2000,
    0x2002, 0x200E, 0x2011, 0x201F, 0x2020, 0x2022,
    0x202E, 0x20E0, 0x20E2, 0x20EE, 0x20F1, 0x20FF,
    0x2101, 0x210F, 0x2110, 0x2112, 0x211E, 0x2121,
    0x212F, 0x21E1, 0x21EF, 0x21F0, 0x21F2, 0x21FE,
    0x2200, 0x2202, 0x220E, 0x2211, 0x221F, 0x2220,
    0x2222, 0x222E, 0x22E0, 0x22E2, 0x22EE, 0x22F1,
    0x22FF, 0x2E00, 0x2E02, 0x2E0E, 0x2E11, 0x2E1F,
    0x2E20, 0x2E22, 0x2E2E, 0x2EE0, 0x2EE2, 0x2EEE,
    0x2EF1, 0x2EFF, 0x2F01, 0x2F0F, 0x2F10, 0x2F12,
    0x2F1E, 0x2F21, 0x2F2F, 0x2FE1, 0x2FEF, 0x2FF0,
    0x2FF2, 0x2FFE, 0xE000, 0xE002, 0xE00E, 0xE011,
    0xE01F, 0xE020, 0xE022, 0xE02E, 0xE0E0, 0xE0E2,
    0xE0EE, 0xE0F1, 0xE0FF, 0xE101, 0xE10F, 0xE110,
    0xE112, 0xE11E, 0xE121, 0xE12F, 0xE1E1, 0xE1EF,
    0xE1F0, 0xE1F2, 0xE1FE, 0xE200, 0xE202, 0xE20E,
    0xE211, 0xE21F, 0xE220, 0xE222, 0xE22E, 0xE2E0,
    0xE2E2, 0xE2EE, 0xE2F1, 0xE2FF, 0xEE00, 0xEE02,
    0xEE0E, 0xEE11, 0xEE1F, 0xEE20, 0xEE22, 0xEE2E,
    0xEEE0, 0xEEE2, 0xEEEE, 0xEEF1, 0xEEFF, 0xEF01,
    0xEF0F, 0xEF10, 0xEF12, 0xEF1E, 0xEF21, 0xEF2F,
    0xEFE1, 0xEFEF, 0xEFF0, 0xEFF2, 0xEFFE, 0xF001,
    0xF00F, 0xF010, 0xF012, 0xF01E, 0xF021, 0xF02F,
    0xF0E1, 0xF0EF, 0xF0F0, 0xF0F2, 0xF0FE, 0xF100,
    0xF102, 0xF10E, 0xF111, 0xF11F, 0xF120, 0xF122,
    0xF12E, 0xF1E0, 0xF1E2, 0xF1EE, 0xF1F1, 0xF1FF,
    0xF201, 0xF20F, 0xF210, 0xF212, 0xF21E, 0xF221,
    0xF22F, 0xF2E1, 0xF2EF, 0xF2F0, 0xF2F2, 0xF2FE,
    0xFE01, 0xFE0F, 0xFE10, 0xFE12, 0xFE1E, 0xFE21,
    0xFE2F, 0xFEE1, 0xFEEF, 0xFEF0, 0xFEF2, 0xFEFE,
    0xFF00, 0xFF02, 0xFF0E, 0xFF11, 0xFF1F, 0xFF20,
    0xFF22, 0xFF2E, 0xFFE0, 0xFFE2, 0xFFEE, 0xFFF1,
    0xFFFF,
};

#define ON2AVC_CB5_CODES 1201
static const uint32_t on2avc_cb5_codes[ON2AVC_CB5_CODES] = {
    0x00000, 0x000D6, 0x000E2, 0x00044, 0x0009E, 0x0009A,
    0x0003A, 0x004E6, 0x00A29, 0x007FE, 0x0024A, 0x004EE,
    0x00496, 0x001EE, 0x001C8, 0x008FA, 0x0050F, 0x001EF,
    0x00486, 0x00906, 0x00904, 0x0003E, 0x00094, 0x000A6,
    0x00046, 0x00061, 0x0012A, 0x0020D, 0x00060, 0x00066,
    0x00452, 0x00692, 0x0087E, 0x00242, 0x0050C, 0x008BE,
    0x0024C, 0x0045A, 0x0025A, 0x001C6, 0x002EE, 0x00294,
    0x006CE, 0x001EC, 0x00492, 0x00690, 0x00055, 0x00474,
    0x0063E, 0x00524, 0x04802, 0x04DC5, 0x00DEF, 0x01A62,
    0x00E6A, 0x00A7F, 0x027FB, 0x034B5, 0x036C5, 0x00A3A,
    0x036C6, 0x0219B, 0x00296, 0x0090F, 0x027FA, 0x028C8,
    0x0052A, 0x0127E, 0x0598E, 0x034B4, 0x00C78, 0x0146E,
    0x00F5F, 0x00BAA, 0x00432, 0x0FF63, 0x0598F, 0x0091C,
    0x00257, 0x0240B, 0x014E6, 0x00E6B, 0x05173, 0x01647,
    0x007F9, 0x022F3, 0x04DC6, 0x022F2, 0x0087F, 0x036C7,
    0x01AB9, 0x00C79, 0x06944, 0x043C6, 0x0043E, 0x00218,
    0x031C4, 0x014E5, 0x0093E, 0x0FF62, 0x3FAE0, 0x00328,
    0x00228, 0x01428, 0x03FEA, 0x007A3, 0x034B3, 0x0D23B,
    0x00B29, 0x01AB8, 0x028C7, 0x0598D, 0x00B28, 0x0149B,
    0x0149A, 0x008EE, 0x027F9, 0x07FC0, 0x00CFE, 0x0025E,
    0x01CBB, 0x026EF, 0x00512, 0x0297B, 0x05172, 0x00D36,
    0x00FCA, 0x01EA5, 0x00D86, 0x01FC5, 0x031C3, 0x02CD6,
    0x00276, 0x01F8A, 0x04801, 0x00B2A, 0x00329, 0x00FC9,
    0x03F0C, 0x00D35, 0x01971, 0x04DC4, 0x036C4, 0x00A4F,
    0x00FEA, 0x01FC4, 0x0122A, 0x00058, 0x001CA, 0x0013A,
    0x0005E, 0x00054, 0x0053E, 0x0039E, 0x006C6, 0x00284,
    0x001C2, 0x0087A, 0x0020E, 0x0050E, 0x006F2, 0x00288,
    0x0029E, 0x00457, 0x006F9, 0x005D3, 0x00248, 0x008F7,
    0x00068, 0x0069D, 0x00497, 0x0005F, 0x0091D, 0x00738,
    0x00057, 0x0005A, 0x00A3E, 0x009CF, 0x00D3E, 0x00D87,
    0x00C6B, 0x00CBD, 0x003F6, 0x00A74, 0x00C6E, 0x0049C,
    0x012FE, 0x0137F, 0x00DBB, 0x010DA, 0x00CAB, 0x0127F,
    0x00056, 0x00A2A, 0x0083E, 0x00040, 0x00BAE, 0x00BA2,
    0x0012E, 0x006F0, 0x0096E, 0x0022C, 0x00FDE, 0x011EB,
    0x01ABE, 0x007EA, 0x014E7, 0x011F2, 0x00256, 0x009FC,
    0x0297C, 0x01C13, 0x006F4, 0x00B26, 0x0144E, 0x021EE,
    0x001C0, 0x00707, 0x00B3F, 0x00244, 0x00E0B, 0x02CD8,
    0x034B6, 0x00B2B, 0x00914, 0x027FD, 0x028CA, 0x01396,
    0x014EB, 0x01972, 0x01B71, 0x013BE, 0x00D9A, 0x00D3F,
    0x009C9, 0x014EA, 0x031C6, 0x022F5, 0x027FC, 0x0240D,
    0x0297D, 0x006F5, 0x02CD7, 0x0396A, 0x0018C, 0x04DC7,
    0x028CB, 0x007E7, 0x0D23C, 0x043C8, 0x008FC, 0x00C7A,
    0x031C7, 0x018EB, 0x0396B, 0x0D23D, 0x036C9, 0x01973,
    0x018EA, 0x07FC1, 0x08FD8, 0x01673, 0x0067C, 0x027FE,
    0x036C8, 0x004BE, 0x08FD9, 0x07FC2, 0x009B6, 0x00148,
    0x026F0, 0x05174, 0x0071C, 0x07279, 0x08FD7, 0x005D4,
    0x00E0A, 0x01A63, 0x01F8B, 0x0114E, 0x01ABA, 0x05990,
    0x043C7, 0x01BEE, 0x3FAE1, 0x1FE94, 0x01CBE, 0x006F3,
    0x018E7, 0x0240C, 0x006FA, 0x03967, 0x08FD6, 0x0045B,
    0x00DBA, 0x01A65, 0x03969, 0x00CFF, 0x0067E, 0x026F1,
    0x028C9, 0x022F4, 0x018D2, 0x01B70, 0x011EA, 0x00BBF,
    0x00B3E, 0x0144D, 0x00D3D, 0x0146F, 0x01A64, 0x01FFF,
    0x01B6F, 0x03968, 0x024EB, 0x00656, 0x031C5, 0x0727A,
    0x0003C, 0x00D22, 0x00D99, 0x0021A, 0x00706, 0x007EE,
    0x0013E, 0x00CBC, 0x01C12, 0x01A66, 0x0022E, 0x00E77,
    0x01672, 0x004D8, 0x006D3, 0x01CBF, 0x01ABB, 0x008BF,
    0x00E76, 0x01BEF, 0x01FC6, 0x001B2, 0x00736, 0x008FB,
    0x0021D, 0x000D7, 0x04804, 0x06948, 0x00D37, 0x0396E,
    0x06949, 0x0120A, 0x03F0F, 0x1437E, 0x043CB, 0x028D0,
    0x0A2BE, 0x08FDD, 0x05996, 0x022F6, 0x1FE96, 0x0FF64,
    0x026F2, 0x028CF, 0x04DCB, 0x03F0E, 0x00A3F, 0x05178,
    0x05995, 0x00BA3, 0x00A4A, 0x07FC8, 0x0727E, 0x007AA,
    0x003D0, 0x0599A, 0x02CDB, 0x034BB, 0x07FC9, 0x0D261,
    0x04805, 0x04806, 0x0727F, 0x022F7, 0x018FE, 0x0240F,
    0x02CDA, 0x031CB, 0x04DCC, 0x034BA, 0x036CB, 0x0052B,
    0x05997, 0x036CE, 0x00907, 0x08FDF, 0x043CD, 0x00E7E,
    0x0517A, 0x04DCD, 0x0197E, 0x0A2BF, 0x028D1, 0x04807,
    0x028D2, 0x04808, 0x0D262, 0x024ED, 0x01ABF, 0x072C0,
    0x1437F, 0x034BE, 0x05179, 0x144F0, 0x072C1, 0x029C1,
    0x08FDE, 0x043CC, 0x023AE, 0x00A3B, 0x1FE97, 0x08FE1,
    0x0142A, 0x006AC, 0x04809, 0x024EE, 0x00C7B, 0x3FAE3,
    0x08FE2, 0x01F8F, 0x0A2C0, 0x023AF, 0x08FE3, 0x02416,
    0x072C2, 0x0FF65, 0x00FCB, 0x08FE0, 0x144F1, 0x01EA6,
    0x00590, 0x04DCE, 0x0396F, 0x01FC7, 0x05991, 0x3FAE2,
    0x0096C, 0x00657, 0x034B8, 0x05992, 0x0240E, 0x0A2BC,
    0x08FDA, 0x0114F, 0x0727C, 0x06945, 0x05175, 0x01B72,
    0x0727B, 0x07FC3, 0x01472, 0x0A2BB, 0x0D23E, 0x00CBE,
    0x00636, 0x034B7, 0x043C9, 0x008AA, 0x08FDB, 0x0D23F,
    0x02852, 0x0727D, 0x05994, 0x00E3E, 0x031CA, 0x06947,
    0x04DC8, 0x02CD9, 0x1FE95, 0x0D260, 0x028CD, 0x024EC,
    0x04803, 0x07FC4, 0x01976, 0x028CC, 0x05993, 0x07FC5,
    0x027FF, 0x06946, 0x03FEB, 0x03F0D, 0x0096D, 0x08FDC,
    0x04DC9, 0x0097E, 0x003D3, 0x0A2BD, 0x0286E, 0x07FC6,
    0x07FC7, 0x034B9, 0x029C0, 0x01F8E, 0x04DCA, 0x05177,
    0x01977, 0x03FEE, 0x0297E, 0x028CE, 0x036CA, 0x05176,
    0x0297F, 0x00596, 0x02853, 0x043CA, 0x0090E, 0x144FA,
    0x0D26A, 0x008AB, 0x000CE, 0x072C3, 0x034BF, 0x02417,
    0x3FAF0, 0x3FAEF, 0x026F3, 0x1FEA0, 0x3FAF1, 0x1FE9F,
    0x0D269, 0x0FF6A, 0x1FE9D, 0x029C6, 0x3FAEE, 0x1FE9E,
    0x036CF, 0x001AA, 0x0480E, 0x0A2C7, 0x000A0, 0x07FCE,
    0x3FAF4, 0x008F8, 0x3FAF5, 0x144FB, 0x00A16, 0x024EF,
    0x04DD3, 0x0694E, 0x1FEA2, 0x3FAF7, 0x3FAF6, 0x0D26B,
    0x04DD2, 0x3FAF2, 0x1FEA1, 0x08FE6, 0x0122B, 0x08FE7,
    0x0480F, 0x00C6F, 0x0FF6B, 0x3FAF3, 0x008EF, 0x00C7E,
    0x3FAF8, 0x1FEA4, 0x00DF6, 0x00362, 0x0694F, 0x0599B,
    0x0142B, 0x1FEA6, 0x1FEA5, 0x03FEF, 0x07FCF, 0x1FEA7,
    0x3FAF9, 0x029C7, 0x0D26E, 0x144FE, 0x01C3E, 0x1FEA3,
    0x0A2CA, 0x01CE6, 0x0049E, 0x043CF, 0x04EFE, 0x0036B,
    0x3FAFE, 0x11F32, 0x01EAE, 0x1FEAA, 0x0D26F, 0x049D2,
    0x02EAE, 0x0356A, 0x08FEA, 0x07ABE, 0x08FEB, 0x3FAFF,
    0x1FEAB, 0x0292E, 0x144FF, 0x3FAFA, 0x08FE8, 0x01EA7,
    0x0B27A, 0x0A2CB, 0x0164E, 0x3FAFB, 0x08FE9, 0x021EF,
    0x00A76, 0x1FE9A, 0x144F2, 0x029C3, 0x3FAE8, 0x3FAE7,
    0x014EE, 0x03F12, 0x0D264, 0x08FE4, 0x0FF67, 0x1FE9B,
    0x144F3, 0x0FF66, 0x0D263, 0x3FAE5, 0x3FAE4, 0x029C2,
    0x031FE, 0x0A2C1, 0x1FE98, 0x01FD6, 0x3FAE6, 0x1FE99,
    0x01473, 0x00D9B, 0x144F5, 0x144F4, 0x00FD2, 0x0036A,
    0x043CE, 0x03F13, 0x0517B, 0x0D267, 0x144F6, 0x01756,
    0x0A2C2, 0x144F8, 0x144F7, 0x0480A, 0x0FF68, 0x0D265,
    0x01B73, 0x0D266, 0x3FAE9, 0x01A67, 0x00493, 0x0694B,
    0x0694A, 0x00082, 0x03F7E, 0x04DCF, 0x009B7, 0x3FAEB,
    0x1FE9C, 0x0071D, 0x028D3, 0x0D268, 0x0A2C5, 0x0A2C6,
    0x3FAED, 0x3FAEC, 0x08FE5, 0x07FCA, 0x3FAEA, 0x144F9,
    0x0A2C3, 0x00D3C, 0x07FCB, 0x0480B, 0x009CA, 0x0FF69,
    0x0A2C4, 0x0091E, 0x007EB, 0x1FE85, 0x0FF56, 0x0091F,
    0x0019E, 0x0693A, 0x0593E, 0x020FC, 0x1FE86, 0x0FF57,
    0x027F4, 0x0146A, 0x04BFC, 0x0CBF9, 0x0CBF8, 0x1FE83,
    0x3F7F5, 0x08F9E, 0x3F7F6, 0x1FE84, 0x036C0, 0x00098,
    0x0593C, 0x071F9, 0x0006E, 0x0593F, 0x03963, 0x00A3C,
    0x13BFD, 0x1FE89, 0x007F2, 0x00FD3, 0x03F08, 0x03D5E,
    0x034A9, 0x13BFF, 0x13BFE, 0x071FA, 0x011E8, 0x1FE87,
    0x3F7F7, 0x0FF58, 0x01B66, 0x07FB8, 0x05168, 0x0070E,
    0x0FF59, 0x1FE88, 0x009B3, 0x00BBC, 0x1FE8B, 0x3F7F8,
    0x00FE6, 0x004FC, 0x0CBFC, 0x03FE6, 0x022F0, 0x1FE8C,
    0x0CBFD, 0x01CE7, 0x08F9F, 0x0FF5A, 0x071FD, 0x1FE8A,
    0x071FB, 0x14378, 0x01AB4, 0x0CBFB, 0x0CBFA, 0x036C1,
    0x0037E, 0x05980, 0x071FC, 0x00D5E, 0x3F7FC, 0x08FD0,
    0x014EF, 0x3F7FE, 0x3F7FD, 0x01CFE, 0x01FBE, 0x05982,
    0x1437A, 0x04BFD, 0x1FE8E, 0x3F7FF, 0x071FF, 0x0FF5B,
    0x1FE8D, 0x3F7F9, 0x14379, 0x047F7, 0x05981, 0x071FE,
    0x014E2, 0x3F7FB, 0x3F7FA, 0x02CCE, 0x0037F, 0x0A27E,
    0x3D5FA, 0x02CCC, 0x1FE80, 0x1FD7E, 0x01496, 0x018E4,
    0x3D5FB, 0x05164, 0x070FD, 0x3D5FC, 0x11F33, 0x0277E,
    0x0FF54, 0x08F98, 0x07FB6, 0x070FC, 0x026E8, 0x07FB7,
    0x034A6, 0x0356B, 0x3D5F9, 0x3D5F8, 0x034A8, 0x0114C,
    0x3F7F0, 0x3D5FF, 0x00C74, 0x0024D, 0x05167, 0x049D3,
    0x0292F, 0x08F9C, 0x3F7F1, 0x01CB6, 0x03962, 0x070FF,
    0x08F9D, 0x08F9A, 0x3D5FD, 0x0A2B0, 0x024E8, 0x070FE,
    0x3D5FE, 0x01A5E, 0x00392, 0x08F9B, 0x05166, 0x00099,
    0x06939, 0x06938, 0x009B2, 0x0C7FE, 0x3F7F4, 0x007F7,
    0x011D6, 0x02EAF, 0x028BE, 0x071F8, 0x0C7FF, 0x1FE82,
    0x047F6, 0x06936, 0x3F7F3, 0x3F7F2, 0x1FE81, 0x026EA,
    0x0C7FC, 0x0B27B, 0x009FA, 0x0C7FD, 0x13BFC, 0x007A8,
    0x000D4, 0x08FD1, 0x0D234, 0x00D34, 0x07274, 0x05988,
    0x00F5C, 0x0516D, 0x0516E, 0x0516C, 0x036C3, 0x0A2B4,
    0x0D235, 0x036C2, 0x034AC, 0x0D233, 0x07FBA, 0x034AB,
    0x0A2B3, 0x1437D, 0x1437C, 0x00B3B, 0x07273, 0x0516B,
    0x00D84, 0x009FB, 0x0693F, 0x0598A, 0x007F8, 0x005D6,
    0x047FB, 0x024EA, 0x026EC, 0x0516F, 0x047FC, 0x031A7,
    0x01397, 0x026ED, 0x02975, 0x02CD1, 0x034AD, 0x07275,
    0x027F6, 0x05989, 0x043C1, 0x0693E, 0x00454, 0x034AE,
    0x043C2, 0x007F6, 0x0A2B7, 0x07FBB, 0x02408, 0x0598B,
    0x047FD, 0x01B6A, 0x04DC1, 0x0FF5F, 0x07FBC, 0x01B6B,
    0x07277, 0x0D236, 0x020FD, 0x01B68, 0x0A2B5, 0x0FF5E,
    0x02976, 0x043C3, 0x02977, 0x0A2B6, 0x012DE, 0x07276,
    0x03FE9, 0x01B69, 0x00A4C, 0x0FF60, 0x1FE93, 0x013BC,
    0x00592, 0x02978, 0x02CD3, 0x00D8E, 0x0D237, 0x05170,
    0x01FC1, 0x028C2, 0x06941, 0x0D238, 0x07278, 0x034AF,
    0x06940, 0x00E5E, 0x08FD2, 0x07FBD, 0x020FE, 0x007E6,
    0x043C4, 0x02CD2, 0x0166E, 0x0CBFF, 0x0CBFE, 0x00A5C,
    0x005D0, 0x026EB, 0x047F8, 0x01F88, 0x1FE90, 0x1FE8F,
    0x00C68, 0x021EC, 0x0A2B1, 0x0D230, 0x04BFE, 0x0693B,
    0x028BF, 0x028C0, 0x07270, 0x0FF5C, 0x00E08, 0x00360,
    0x0436C, 0x05983, 0x009BE, 0x0FF5D, 0x1FE91, 0x01A60,
    0x04BFF, 0x0A2B2, 0x0436E, 0x03F0A, 0x07FB9, 0x05984,
    0x01FC0, 0x1FE92, 0x1437B, 0x01646, 0x03F09, 0x0693C,
    0x027F5, 0x047F9, 0x034AA, 0x0D231, 0x0436D, 0x01AB6,
    0x047FA, 0x07271, 0x00CFA, 0x006CF, 0x07272, 0x05986,
    0x00B3A, 0x00654, 0x028C1, 0x0436F, 0x02CD0, 0x03FE8,
    0x05987, 0x043C0, 0x0146B, 0x02974, 0x031A6, 0x02CCF,
    0x03964, 0x04DC0, 0x0516A, 0x05985, 0x05169, 0x02406,
    0x003D6, 0x0D232, 0x0693D, 0x0005C, 0x006F6, 0x0086E,
    0x00062, 0x0005B, 0x006F1, 0x007E0, 0x00D98, 0x00BBE,
    0x00E72, 0x00D8F, 0x004DA, 0x0137B, 0x0137A, 0x00386,
    0x00A7E, 0x00C6A, 0x00CBA, 0x00F5E, 0x00F5D, 0x013BD,
    0x00064, 0x009CE, 0x008EC, 0x0003B, 0x00F56, 0x00CAA,
    0x00246, 0x008ED, 0x0086C, 0x001ED, 0x00C77, 0x0240A,
    0x01B6D, 0x0086F, 0x02CD5, 0x01FC3, 0x0073E, 0x005D2,
    0x01970, 0x014E4, 0x00456, 0x00B22, 0x0114D, 0x02198,
    0x00138, 0x0069C, 0x00737, 0x0020C, 0x00A4E, 0x04DC2,
    0x018E6, 0x00E1E, 0x006D2, 0x047FF, 0x02979, 0x01FFE,
    0x04800, 0x021ED, 0x028C6, 0x00917, 0x01671, 0x01CFF,
    0x00CFB, 0x00FE7, 0x00A1A, 0x0146D, 0x01670, 0x01B6E,
    0x0137E, 0x006D1, 0x01FFD, 0x028C5, 0x00176, 0x05171,
    0x0219A, 0x0023C, 0x0A2BA, 0x043C5, 0x006F8, 0x006DF,
    0x01EA4, 0x01CBA, 0x027F8, 0x0FF61, 0x08FD5, 0x0177B,
    0x02199, 0x0D23A, 0x03966, 0x0297A, 0x00A38, 0x0177A,
    0x01A61, 0x00597, 0x07FBF, 0x04DC3, 0x007F4, 0x00196,
    0x034B0, 0x03F0B, 0x008F6, 0x0598C, 0x08FD3, 0x003D2,
    0x006D0, 0x01FC2, 0x031C1, 0x026EE, 0x0A2B9, 0x0D239,
    0x0175F, 0x0175E, 0x031C0, 0x06942, 0x01FF6, 0x00A3D,
    0x0166F, 0x027F7, 0x009C8, 0x0A2B8, 0x07FBE, 0x00734,
    0x00FC6, 0x03965, 0x06943, 0x010CF, 0x006DE, 0x02CD4,
    0x08FD4, 0x034B2, 0x01CB8, 0x028C3, 0x01FFC, 0x0041E,
    0x0146C, 0x01B6C, 0x00C76, 0x00B3C, 0x010CE, 0x022F1,
    0x0144C, 0x012DF, 0x01436, 0x0073A, 0x034B1, 0x031C2,
    0x00042, 0x00DEE, 0x00B3D, 0x001CC, 0x00A17, 0x007E8,
    0x0021C, 0x00A28, 0x01CB9, 0x02409, 0x00916, 0x020FF,
    0x047FE, 0x00726, 0x00238, 0x011E9, 0x01AB7, 0x0071E,
    0x00FC8, 0x028C4, 0x00D85, 0x00239, 0x008EA, 0x007A2,
    0x0012C,
};

static const uint8_t on2avc_cb5_bits[ON2AVC_CB5_CODES] = {
     1,  8,  8,  7,  8,  8,
     6, 11, 12, 11, 10, 11,
    11,  9,  9, 12, 11,  9,
    11, 12, 12,  6,  8,  8,
     7,  7,  9, 10,  7,  7,
    11, 11, 12, 10, 11, 12,
    10, 11, 10,  9, 10, 10,
    11,  9, 11, 11,  7, 11,
    11, 11, 15, 15, 12, 13,
    12, 12, 14, 14, 14, 12,
    14, 14, 10, 12, 14, 14,
    11, 13, 15, 14, 12, 13,
    12, 12, 11, 16, 15, 12,
    10, 14, 13, 12, 15, 13,
    11, 14, 15, 14, 12, 14,
    13, 12, 15, 15, 11, 10,
    14, 13, 12, 16, 18, 10,
    10, 13, 14, 11, 14, 16,
    12, 13, 14, 15, 12, 13,
    13, 12, 14, 15, 12, 10,
    13, 14, 11, 14, 15, 12,
    12, 13, 12, 13, 14, 14,
    10, 13, 15, 12, 10, 12,
    14, 12, 13, 15, 14, 12,
    12, 13, 13,  7,  9,  9,
     7,  7, 11, 10, 11, 10,
     9, 12, 10, 11, 11, 10,
    10, 11, 11, 11, 10, 12,
     7, 11, 11,  7, 12, 11,
     7,  7, 12, 12, 12, 12,
    12, 12, 10, 12, 12, 11,
    13, 13, 12, 13, 12, 13,
     7, 12, 12,  7, 12, 12,
     9, 11, 12, 10, 12, 13,
    13, 11, 13, 13, 10, 12,
    14, 13, 11, 12, 13, 14,
     9, 11, 12, 10, 12, 14,
    14, 12, 12, 14, 14, 13,
    13, 13, 13, 13, 12, 12,
    12, 13, 14, 14, 14, 14,
    14, 11, 14, 14,  9, 15,
    14, 11, 16, 15, 12, 12,
    14, 13, 14, 16, 14, 13,
    13, 15, 16, 13, 11, 14,
    14, 11, 16, 15, 12,  9,
    14, 15, 11, 15, 16, 11,
    12, 13, 13, 13, 13, 15,
    15, 13, 18, 17, 13, 11,
    13, 14, 11, 14, 16, 11,
    12, 13, 14, 12, 11, 14,
    14, 14, 13, 13, 13, 12,
    12, 13, 12, 13, 13, 13,
    13, 14, 14, 11, 14, 15,
     6, 12, 12, 10, 11, 11,
     9, 12, 13, 13, 10, 12,
    13, 11, 11, 13, 13, 12,
    12, 13, 13,  9, 11, 12,
    10,  8, 15, 15, 12, 14,
    15, 13, 14, 17, 15, 14,
    16, 16, 15, 14, 17, 16,
    14, 14, 15, 14, 12, 15,
    15, 12, 12, 15, 15, 11,
    10, 15, 14, 14, 15, 16,
    15, 15, 15, 14, 13, 14,
    14, 14, 15, 14, 14, 11,
    15, 14, 12, 16, 15, 12,
    15, 15, 13, 16, 14, 15,
    14, 15, 16, 14, 13, 15,
    17, 14, 15, 17, 15, 14,
    16, 15, 14, 12, 17, 16,
    13, 11, 15, 14, 12, 18,
    16, 13, 16, 14, 16, 14,
    15, 16, 12, 16, 17, 13,
    11, 15, 14, 13, 15, 18,
    12, 11, 14, 15, 14, 16,
    16, 13, 15, 15, 15, 13,
    15, 15, 13, 16, 16, 12,
    11, 14, 15, 12, 16, 16,
    14, 15, 15, 12, 14, 15,
    15, 14, 17, 16, 14, 14,
    15, 15, 13, 14, 15, 15,
    14, 15, 14, 14, 12, 16,
    15, 12, 10, 16, 14, 15,
    15, 14, 14, 13, 15, 15,
    13, 14, 14, 14, 14, 15,
    14, 11, 14, 15, 12, 17,
    16, 12,  8, 15, 14, 14,
    18, 18, 14, 17, 18, 17,
    16, 16, 17, 14, 18, 17,
    14,  9, 15, 16,  8, 15,
    18, 12, 18, 17, 12, 14,
    15, 15, 17, 18, 18, 16,
    15, 18, 17, 16, 13, 16,
    15, 12, 16, 18, 12, 12,
    18, 17, 12, 10, 15, 15,
    13, 17, 17, 14, 15, 17,
    18, 14, 16, 17, 13, 17,
    16, 13, 11, 15, 15, 10,
    18, 17, 13, 17, 16, 15,
    14, 14, 16, 15, 16, 18,
    17, 14, 17, 18, 16, 13,
    16, 16, 13, 18, 16, 14,
    12, 17, 17, 14, 18, 18,
    13, 14, 16, 16, 16, 17,
    17, 16, 16, 18, 18, 14,
    14, 16, 17, 13, 18, 17,
    13, 12, 17, 17, 12, 10,
    15, 14, 15, 16, 17, 13,
    16, 17, 17, 15, 16, 16,
    13, 16, 18, 13, 11, 15,
    15,  8, 14, 15, 12, 18,
    17, 11, 14, 16, 16, 16,
    18, 18, 16, 15, 18, 17,
    16, 12, 15, 15, 12, 16,
    16, 12, 11, 17, 16, 12,
     9, 15, 15, 14, 17, 16,
    14, 13, 15, 16, 16, 17,
    18, 16, 18, 17, 14,  8,
    15, 15,  7, 15, 14, 12,
    17, 17, 11, 12, 14, 14,
    14, 17, 17, 15, 13, 17,
    18, 16, 13, 15, 15, 11,
    16, 17, 12, 12, 17, 18,
    12, 11, 16, 14, 14, 17,
    16, 13, 16, 16, 15, 17,
    15, 17, 13, 16, 16, 14,
    10, 15, 15, 12, 18, 16,
    13, 18, 18, 13, 13, 15,
    17, 15, 17, 18, 15, 16,
    17, 18, 17, 15, 15, 15,
    13, 18, 18, 14, 10, 16,
    18, 14, 17, 17, 13, 13,
    18, 15, 15, 18, 17, 14,
    16, 16, 15, 15, 14, 15,
    14, 14, 18, 18, 14, 13,
    18, 18, 12, 10, 15, 15,
    14, 16, 18, 13, 14, 15,
    16, 16, 18, 16, 14, 15,
    18, 13, 10, 16, 15,  8,
    15, 15, 12, 16, 18, 11,
    13, 14, 14, 15, 16, 17,
    15, 15, 18, 18, 17, 14,
    16, 16, 12, 16, 17, 11,
     8, 16, 16, 12, 15, 15,
    12, 15, 15, 15, 14, 16,
    16, 14, 14, 16, 15, 14,
    16, 17, 17, 12, 15, 15,
    12, 12, 15, 15, 11, 11,
    15, 14, 14, 15, 15, 14,
    13, 14, 14, 14, 14, 15,
    14, 15, 15, 15, 11, 14,
    15, 11, 16, 15, 14, 15,
    15, 13, 15, 16, 15, 13,
    15, 16, 14, 13, 16, 16,
    14, 15, 14, 16, 13, 15,
    14, 13, 12, 16, 17, 13,
    11, 14, 14, 12, 16, 15,
    13, 14, 15, 16, 15, 14,
    15, 12, 16, 15, 14, 11,
    15, 14, 13, 16, 16, 12,
    11, 14, 15, 13, 17, 17,
    12, 14, 16, 16, 15, 15,
    14, 14, 15, 16, 12, 10,
    15, 15, 12, 16, 17, 13,
    15, 16, 15, 14, 15, 15,
    13, 17, 17, 13, 14, 15,
    14, 15, 14, 16, 15, 13,
    15, 15, 12, 11, 15, 15,
    12, 11, 14, 15, 14, 14,
    15, 15, 13, 14, 14, 14,
    14, 15, 15, 15, 15, 14,
    10, 16, 15,  7, 11, 12,
     7,  7, 11, 11, 12, 12,
    12, 12, 11, 13, 13, 10,
    12, 12, 12, 12, 12, 13,
     7, 12, 12,  6, 12, 12,
    10, 12, 12,  9, 12, 14,
    13, 12, 14, 13, 11, 11,
    13, 13, 11, 12, 13, 14,
     9, 11, 11, 10, 12, 15,
    13, 12, 11, 15, 14, 13,
    15, 14, 14, 12, 13, 13,
    12, 12, 12, 13, 13, 13,
    13, 11, 13, 14,  9, 15,
    14, 10, 16, 15, 11, 11,
    13, 13, 14, 16, 16, 13,
    14, 16, 14, 14, 12, 13,
    13, 11, 15, 15, 11,  9,
    14, 14, 12, 15, 16, 10,
    11, 13, 14, 14, 16, 16,
    13, 13, 14, 15, 13, 12,
    13, 14, 12, 16, 15, 11,
    12, 14, 15, 13, 11, 14,
    16, 14, 13, 14, 13, 11,
    13, 13, 12, 12, 13, 14,
    13, 13, 13, 11, 14, 14,
     7, 12, 12,  9, 12, 11,
    10, 12, 13, 14, 12, 14,
    15, 11, 10, 13, 13, 11,
    12, 14, 12, 10, 12, 11,
     9,
};

static const uint16_t on2avc_cb5_syms[ON2AVC_CB5_CODES] = {
    0x0000, 0x0002, 0x000E, 0x0011, 0x0013, 0x001D,
    0x001F, 0x0020, 0x0022, 0x002E, 0x0031, 0x0033,
    0x003D, 0x003F, 0x00D1, 0x00D3, 0x00DD, 0x00DF,
    0x00E0, 0x00E2, 0x00EE, 0x00F1, 0x00F3, 0x00FD,
    0x00FF, 0x0101, 0x0103, 0x010D, 0x010F, 0x0110,
    0x0112, 0x011E, 0x0121, 0x0123, 0x012D, 0x012F,
    0x0130, 0x0132, 0x013E, 0x01D0, 0x01D2, 0x01DE,
    0x01E1, 0x01E3, 0x01ED, 0x01EF, 0x01F0, 0x01F2,
    0x01FE, 0x0200, 0x0202, 0x020E, 0x0211, 0x0213,
    0x021D, 0x021F, 0x0220, 0x0222, 0x022E, 0x0231,
    0x0233, 0x023D, 0x023F, 0x02D1, 0x02D3, 0x02DD,
    0x02DF, 0x02E0, 0x02E2, 0x02EE, 0x02F1, 0x02F3,
    0x02FD, 0x02FF, 0x0301, 0x0303, 0x030D, 0x030F,
    0x0310, 0x0312, 0x031E, 0x0321, 0x0323, 0x032D,
    0x032F, 0x0330, 0x0332, 0x033E, 0x03D0, 0x03D2,
    0x03DE, 0x03E1, 0x03E3, 0x03ED, 0x03EF, 0x03F0,
    0x03F2, 0x03FE, 0x0D01, 0x0D03, 0x0D0D, 0x0D0F,
    0x0D10, 0x0D12, 0x0D1E, 0x0D21, 0x0D23, 0x0D2D,
    0x0D2F, 0x0D30, 0x0D32, 0x0D3E, 0x0DD0, 0x0DD2,
    0x0DDE, 0x0DE1, 0x0DE3, 0x0DED, 0x0DEF, 0x0DF0,
    0x0DF2, 0x0DFE, 0x0E00, 0x0E02, 0x0E0E, 0x0E11,
    0x0E13, 0x0E1D, 0x0E1F, 0x0E20, 0x0E22, 0x0E2E,
    0x0E31, 0x0E33, 0x0E3D, 0x0E3F, 0x0ED1, 0x0ED3,
    0x0EDD, 0x0EDF, 0x0EE0, 0x0EE2, 0x0EEE, 0x0EF1,
    0x0EF3, 0x0EFD, 0x0EFF, 0x0F01, 0x0F03, 0x0F0D,
    0x0F0F, 0x0F10, 0x0F12, 0x0F1E, 0x0F21, 0x0F23,
    0x0F2D, 0x0F2F, 0x0F30, 0x0F32, 0x0F3E, 0x0FD0,
    0x0FD2, 0x0FDE, 0x0FE1, 0x0FE3, 0x0FED, 0x0FEF,
    0x0FF0, 0x0FF2, 0x0FFE, 0x1001, 0x1003, 0x100D,
    0x100F, 0x1010, 0x1012, 0x101E, 0x1021, 0x1023,
    0x102D, 0x102F, 0x1030, 0x1032, 0x103E, 0x10D0,
    0x10D2, 0x10DE, 0x10E1, 0x10E3, 0x10ED, 0x10EF,
    0x10F0, 0x10F2, 0x10FE, 0x1100, 0x1102, 0x110E,
    0x1111, 0x1113, 0x111D, 0x111F, 0x1120, 0x1122,
    0x112E, 0x1131, 0x1133, 0x113D, 0x113F, 0x11D1,
    0x11D3, 0x11DD, 0x11DF, 0x11E0, 0x11E2, 0x11EE,
    0x11F1, 0x11F3, 0x11FD, 0x11FF, 0x1201, 0x1203,
    0x120D, 0x120F, 0x1210, 0x1212, 0x121E, 0x1221,
    0x1223, 0x122D, 0x122F, 0x1230, 0x1232, 0x123E,
    0x12D0, 0x12D2, 0x12DE, 0x12E1, 0x12E3, 0x12ED,
    0x12EF, 0x12F0, 0x12F2, 0x12FE, 0x1300, 0x1302,
    0x130E, 0x1311, 0x1313, 0x131D, 0x131F, 0x1320,
    0x1322, 0x132E, 0x1331, 0x1333, 0x133D, 0x133F,
    0x13D1, 0x13D3, 0x13DD, 0x13DF, 0x13E0, 0x13E2,
    0x13EE, 0x13F1, 0x13F3, 0x13FD, 0x13FF, 0x1D00,
    0x1D02, 0x1D0E, 0x1D11, 0x1D13, 0x1D1D, 0x1D1F,
    0x1D20, 0x1D22, 0x1D2E, 0x1D31, 0x1D33, 0x1D3D,
    0x1D3F, 0x1DD1, 0x1DD3, 0x1DDD, 0x1DDF, 0x1DE0,
    0x1DE2, 0x1DEE, 0x1DF1, 0x1DF3, 0x1DFD, 0x1DFF,
    0x1E01, 0x1E03, 0x1E0D, 0x1E0F, 0x1E10, 0x1E12,
    0x1E1E, 0x1E21, 0x1E23, 0x1E2D, 0x1E2F, 0x1E30,
    0x1E32, 0x1E3E, 0x1ED0, 0x1ED2, 0x1EDE, 0x1EE1,
    0x1EE3, 0x1EED, 0x1EEF, 0x1EF0, 0x1EF2, 0x1EFE,
    0x1F00, 0x1F02, 0x1F0E, 0x1F11, 0x1F13, 0x1F1D,
    0x1F1F, 0x1F20, 0x1F22, 0x1F2E, 0x1F31, 0x1F33,
    0x1F3D, 0x1F3F, 0x1FD1, 0x1FD3, 0x1FDD, 0x1FDF,
    0x1FE0, 0x1FE2, 0x1FEE, 0x1FF1, 0x1FF3, 0x1FFD,
    0x1FFF, 0x2000, 0x2002, 0x200E, 0x2011, 0x2013,
    0x201D, 0x201F, 0x2020, 0x2022, 0x202E, 0x2031,
    0x2033, 0x203D, 0x203F, 0x20D1, 0x20D3, 0x20DD,
    0x20DF, 0x20E0, 0x20E2, 0x20EE, 0x20F1, 0x20F3,
    0x20FD, 0x20FF, 0x2101, 0x2103, 0x210D, 0x210F,
    0x2110, 0x2112, 0x211E, 0x2121, 0x2123, 0x212D,
    0x212F, 0x2130, 0x2132, 0x213E, 0x21D0, 0x21D2,
    0x21DE, 0x21E1, 0x21E3, 0x21ED, 0x21EF, 0x21F0,
    0x21F2, 0x21FE, 0x2200, 0x2202, 0x220E, 0x2211,
    0x2213, 0x221D, 0x221F, 0x2220, 0x2222, 0x222E,
    0x2231, 0x2233, 0x223D, 0x223F, 0x22D1, 0x22D3,
    0x22DD, 0x22DF, 0x22E0, 0x22E2, 0x22EE, 0x22F1,
    0x22F3, 0x22FD, 0x22FF, 0x2301, 0x2303, 0x230D,
    0x230F, 0x2310, 0x2312, 0x231E, 0x2321, 0x2323,
    0x232D, 0x232F, 0x2330, 0x2332, 0x233E, 0x23D0,
    0x23D2, 0x23DE, 0x23E1, 0x23E3, 0x23ED, 0x23EF,
    0x23F0, 0x23F2, 0x23FE, 0x2D01, 0x2D03, 0x2D0D,
    0x2D0F, 0x2D10, 0x2D12, 0x2D1E, 0x2D21, 0x2D23,
    0x2D2D, 0x2D2F, 0x2D30, 0x2D32, 0x2D3E, 0x2DD0,
    0x2DD2, 0x2DDE, 0x2DE1, 0x2DE3, 0x2DED, 0x2DEF,
    0x2DF0, 0x2DF2, 0x2DFE, 0x2E00, 0x2E02, 0x2E0E,
    0x2E11, 0x2E13, 0x2E1D, 0x2E1F, 0x2E20, 0x2E22,
    0x2E2E, 0x2E31, 0x2E33, 0x2E3D, 0x2E3F, 0x2ED1,
    0x2ED3, 0x2EDD, 0x2EDF, 0x2EE0, 0x2EE2, 0x2EEE,
    0x2EF1, 0x2EF3, 0x2EFD, 0x2EFF, 0x2F01, 0x2F03,
    0x2F0D, 0x2F0F, 0x2F10, 0x2F12, 0x2F1E, 0x2F21,
    0x2F23, 0x2F2D, 0x2F2F, 0x2F30, 0x2F32, 0x2F3E,
    0x2FD0, 0x2FD2, 0x2FDE, 0x2FE1, 0x2FE3, 0x2FED,
    0x2FEF, 0x2FF0, 0x2FF2, 0x2FFE, 0x3001, 0x3003,
    0x300D, 0x300F, 0x3010, 0x3012, 0x301E, 0x3021,
    0x3023, 0x302D, 0x302F, 0x3030, 0x3032, 0x303E,
    0x30D0, 0x30D2, 0x30DE, 0x30E1, 0x30E3, 0x30ED,
    0x30EF, 0x30F0, 0x30F2, 0x30FE, 0x3100, 0x3102,
    0x310E, 0x3111, 0x3113, 0x311D, 0x311F, 0x3120,
    0x3122, 0x312E, 0x3131, 0x3133, 0x313D, 0x313F,
    0x31D1, 0x31D3, 0x31DD, 0x31DF, 0x31E0, 0x31E2,
    0x31EE, 0x31F1, 0x31F3, 0x31FD, 0x31FF, 0x3201,
    0x3203, 0x320D, 0x320F, 0x3210, 0x3212, 0x321E,
    0x3221, 0x3223, 0x322D, 0x322F, 0x3230, 0x3232,
    0x323E, 0x32D0, 0x32D2, 0x32DE, 0x32E1, 0x32E3,
    0x32ED, 0x32EF, 0x32F0, 0x32F2, 0x32FE, 0x3300,
    0x3302, 0x330E, 0x3311, 0x3313, 0x331D, 0x331F,
    0x3320, 0x3322, 0x332E, 0x3331, 0x3333, 0x333D,
    0x333F, 0x33D1, 0x33D3, 0x33DD, 0x33DF, 0x33E0,
    0x33E2, 0x33EE, 0x33F1, 0x33F3, 0x33FD, 0x33FF,
    0x3D00, 0x3D02, 0x3D0E, 0x3D11, 0x3D13, 0x3D1D,
    0x3D1F, 0x3D20, 0x3D22, 0x3D2E, 0x3D31, 0x3D33,
    0x3D3D, 0x3D3F, 0x3DD1, 0x3DD3, 0x3DDD, 0x3DDF,
    0x3DE0, 0x3DE2, 0x3DEE, 0x3DF1, 0x3DF3, 0x3DFD,
    0x3DFF, 0x3E01, 0x3E03, 0x3E0D, 0x3E0F, 0x3E10,
    0x3E12, 0x3E1E, 0x3E21, 0x3E23, 0x3E2D, 0x3E2F,
    0x3E30, 0x3E32, 0x3E3E, 0x3ED0, 0x3ED2, 0x3EDE,
    0x3EE1, 0x3EE3, 0x3EED, 0x3EEF, 0x3EF0, 0x3EF2,
    0x3EFE, 0x3F00, 0x3F02, 0x3F0E, 0x3F11, 0x3F13,
    0x3F1D, 0x3F1F, 0x3F20, 0x3F22, 0x3F2E, 0x3F31,
    0x3F33, 0x3F3D, 0x3F3F, 0x3FD1, 0x3FD3, 0x3FDD,
    0x3FDF, 0x3FE0, 0x3FE2, 0x3FEE, 0x3FF1, 0x3FF3,
    0x3FFD, 0x3FFF, 0xD001, 0xD003, 0xD00D, 0xD00F,
    0xD010, 0xD012, 0xD01E, 0xD021, 0xD023, 0xD02D,
    0xD02F, 0xD030, 0xD032, 0xD03E, 0xD0D0, 0xD0D2,
    0xD0DE, 0xD0E1, 0xD0E3, 0xD0ED, 0xD0EF, 0xD0F0,
    0xD0F2, 0xD0FE, 0xD100, 0xD102, 0xD10E, 0xD111,
    0xD113, 0xD11D, 0xD11F, 0xD120, 0xD122, 0xD12E,
    0xD131, 0xD133, 0xD13D, 0xD13F, 0xD1D1, 0xD1D3,
    0xD1DD, 0xD1DF, 0xD1E0, 0xD1E2, 0xD1EE, 0xD1F1,
    0xD1F3, 0xD1FD, 0xD1FF, 0xD201, 0xD203, 0xD20D,
    0xD20F, 0xD210, 0xD212, 0xD21E, 0xD221, 0xD223,
    0xD22D, 0xD22F, 0xD230, 0xD232, 0xD23E, 0xD2D0,
    0xD2D2, 0xD2DE, 0xD2E1, 0xD2E3, 0xD2ED, 0xD2EF,
    0xD2F0, 0xD2F2, 0xD2FE, 0xD300, 0xD302, 0xD30E,
    0xD311, 0xD313, 0xD31D, 0xD31F, 0xD320, 0xD322,
    0xD32E, 0xD331, 0xD333, 0xD33D, 0xD33F, 0xD3D1,
    0xD3D3, 0xD3DD, 0xD3DF, 0xD3E0, 0xD3E2, 0xD3EE,
    0xD3F1, 0xD3F3, 0xD3FD, 0xD3FF, 0xDD00, 0xDD02,
    0xDD0E, 0xDD11, 0xDD13, 0xDD1D, 0xDD1F, 0xDD20,
    0xDD22, 0xDD2E, 0xDD31, 0xDD33, 0xDD3D, 0xDD3F,
    0xDDD1, 0xDDD3, 0xDDDD, 0xDDDF, 0xDDE0, 0xDDE2,
    0xDDEE, 0xDDF1, 0xDDF3, 0xDDFD, 0xDDFF, 0xDE01,
    0xDE03, 0xDE0D, 0xDE0F, 0xDE10, 0xDE12, 0xDE1E,
    0xDE21, 0xDE23, 0xDE2D, 0xDE2F, 0xDE30, 0xDE32,
    0xDE3E, 0xDED0, 0xDED2, 0xDEDE, 0xDEE1, 0xDEE3,
    0xDEED, 0xDEEF, 0xDEF0, 0xDEF2, 0xDEFE, 0xDF00,
    0xDF02, 0xDF0E, 0xDF11, 0xDF13, 0xDF1D, 0xDF1F,
    0xDF20, 0xDF22, 0xDF2E, 0xDF31, 0xDF33, 0xDF3D,
    0xDF3F, 0xDFD1, 0xDFD3, 0xDFDD, 0xDFDF, 0xDFE0,
    0xDFE2, 0xDFEE, 0xDFF1, 0xDFF3, 0xDFFD, 0xDFFF,
    0xE000, 0xE002, 0xE00E, 0xE011, 0xE013, 0xE01D,
    0xE01F, 0xE020, 0xE022, 0xE02E, 0xE031, 0xE033,
    0xE03D, 0xE03F, 0xE0D1, 0xE0D3, 0xE0DD, 0xE0DF,
    0xE0E0, 0xE0E2, 0xE0EE, 0xE0F1, 0xE0F3, 0xE0FD,
    0xE0FF, 0xE101, 0xE103, 0xE10D, 0xE10F, 0xE110,
    0xE112, 0xE11E, 0xE121, 0xE123, 0xE12D, 0xE12F,
    0xE130, 0xE132, 0xE13E, 0xE1D0, 0xE1D2, 0xE1DE,
    0xE1E1, 0xE1E3, 0xE1ED, 0xE1EF, 0xE1F0, 0xE1F2,
    0xE1FE, 0xE200, 0xE202, 0xE20E, 0xE211, 0xE213,
    0xE21D, 0xE21F, 0xE220, 0xE222, 0xE22E, 0xE231,
    0xE233, 0xE23D, 0xE23F, 0xE2D1, 0xE2D3, 0xE2DD,
    0xE2DF, 0xE2E0, 0xE2E2, 0xE2EE, 0xE2F1, 0xE2F3,
    0xE2FD, 0xE2FF, 0xE301, 0xE303, 0xE30D, 0xE30F,
    0xE310, 0xE312, 0xE31E, 0xE321, 0xE323, 0xE32D,
    0xE32F, 0xE330, 0xE332, 0xE33E, 0xE3D0, 0xE3D2,
    0xE3DE, 0xE3E1, 0xE3E3, 0xE3ED, 0xE3EF, 0xE3F0,
    0xE3F2, 0xE3FE, 0xED01, 0xED03, 0xED0D, 0xED0F,
    0xED10, 0xED12, 0xED1E, 0xED21, 0xED23, 0xED2D,
    0xED2F, 0xED30, 0xED32, 0xED3E, 0xEDD0, 0xEDD2,
    0xEDDE, 0xEDE1, 0xEDE3, 0xEDED, 0xEDEF, 0xEDF0,
    0xEDF2, 0xEDFE, 0xEE00, 0xEE02, 0xEE0E, 0xEE11,
    0xEE13, 0xEE1D, 0xEE1F, 0xEE20, 0xEE22, 0xEE2E,
    0xEE31, 0xEE33, 0xEE3D, 0xEE3F, 0xEED1, 0xEED3,
    0xEEDD, 0xEEDF, 0xEEE0, 0xEEE2, 0xEEEE, 0xEEF1,
    0xEEF3, 0xEEFD, 0xEEFF, 0xEF01, 0xEF03, 0xEF0D,
    0xEF0F, 0xEF10, 0xEF12, 0xEF1E, 0xEF21, 0xEF23,
    0xEF2D, 0xEF2F, 0xEF30, 0xEF32, 0xEF3E, 0xEFD0,
    0xEFD2, 0xEFDE, 0xEFE1, 0xEFE3, 0xEFED, 0xEFEF,
    0xEFF0, 0xEFF2, 0xEFFE, 0xF001, 0xF003, 0xF00D,
    0xF00F, 0xF010, 0xF012, 0xF01E, 0xF021, 0xF023,
    0xF02D, 0xF02F, 0xF030, 0xF032, 0xF03E, 0xF0D0,
    0xF0D2, 0xF0DE, 0xF0E1, 0xF0E3, 0xF0ED, 0xF0EF,
    0xF0F0, 0xF0F2, 0xF0FE, 0xF100, 0xF102, 0xF10E,
    0xF111, 0xF113, 0xF11D, 0xF11F, 0xF120, 0xF122,
    0xF12E, 0xF131, 0xF133, 0xF13D, 0xF13F, 0xF1D1,
    0xF1D3, 0xF1DD, 0xF1DF, 0xF1E0, 0xF1E2, 0xF1EE,
    0xF1F1, 0xF1F3, 0xF1FD, 0xF1FF, 0xF201, 0xF203,
    0xF20D, 0xF20F, 0xF210, 0xF212, 0xF21E, 0xF221,
    0xF223, 0xF22D, 0xF22F, 0xF230, 0xF232, 0xF23E,
    0xF2D0, 0xF2D2, 0xF2DE, 0xF2E1, 0xF2E3, 0xF2ED,
    0xF2EF, 0xF2F0, 0xF2F2, 0xF2FE, 0xF300, 0xF302,
    0xF30E, 0xF311, 0xF313, 0xF31D, 0xF31F, 0xF320,
    0xF322, 0xF32E, 0xF331, 0xF333, 0xF33D, 0xF33F,
    0xF3D1, 0xF3D3, 0xF3DD, 0xF3DF, 0xF3E0, 0xF3E2,
    0xF3EE, 0xF3F1, 0xF3F3, 0xF3FD, 0xF3FF, 0xFD00,
    0xFD02, 0xFD0E, 0xFD11, 0xFD13, 0xFD1D, 0xFD1F,
    0xFD20, 0xFD22, 0xFD2E, 0xFD31, 0xFD33, 0xFD3D,
    0xFD3F, 0xFDD1, 0xFDD3, 0xFDDD, 0xFDDF, 0xFDE0,
    0xFDE2, 0xFDEE, 0xFDF1, 0xFDF3, 0xFDFD, 0xFDFF,
    0xFE01, 0xFE03, 0xFE0D, 0xFE0F, 0xFE10, 0xFE12,
    0xFE1E, 0xFE21, 0xFE23, 0xFE2D, 0xFE2F, 0xFE30,
    0xFE32, 0xFE3E, 0xFED0, 0xFED2, 0xFEDE, 0xFEE1,
    0xFEE3, 0xFEED, 0xFEEF, 0xFEF0, 0xFEF2, 0xFEFE,
    0xFF00, 0xFF02, 0xFF0E, 0xFF11, 0xFF13, 0xFF1D,
    0xFF1F, 0xFF20, 0xFF22, 0xFF2E, 0xFF31, 0xFF33,
    0xFF3D, 0xFF3F, 0xFFD1, 0xFFD3, 0xFFDD, 0xFFDF,
    0xFFE0, 0xFFE2, 0xFFEE, 0xFFF1, 0xFFF3, 0xFFFD,
    0xFFFF,
};

#define ON2AVC_CB6_CODES 1201
static const uint32_t on2avc_cb6_codes[ON2AVC_CB6_CODES] = {
    0x0018, 0x0088, 0x0082, 0x0024, 0x05B4, 0x08DF,
    0x0044, 0x0197, 0x01DE, 0x021F, 0x0D77, 0x0A72,
    0x7E77, 0x0B8B, 0x03F1, 0x0433, 0x073F, 0x1E5C,
    0x016A, 0x01C5, 0x00D2, 0x0062, 0x0CE4, 0x0096,
    0x0020, 0x0052, 0x00B7, 0x0127, 0x003A, 0x0041,
    0x00CC, 0x01B6, 0x0124, 0x07D3, 0x01AE, 0x01C4,
    0x00DA, 0x03D8, 0x03F3, 0x1638, 0x03F2, 0x12FC,
    0x01E2, 0x0DBC, 0x026C, 0x008A, 0x0054, 0x01A6,
    0x0195, 0x0164, 0x01E2, 0x026D, 0x0051, 0x049F,
    0x01B3, 0x01E0, 0x01B4, 0x026E, 0x07DE, 0x0129,
    0x0292, 0x0DBD, 0x013E, 0x00F3, 0x05B5, 0x09A6,
    0x01FB, 0x02CF, 0x01FF, 0x037C, 0x004A, 0x067E,
    0x016B, 0x002A, 0x09A7, 0x10EE, 0x1639, 0x0135,
    0x0CCA, 0x016A, 0x011B, 0x03EE, 0x07A2, 0x0D7E,
    0x028F, 0x0FE2, 0x07DA, 0x0357, 0x92F6, 0x0F31,
    0x0217, 0x036A, 0x0CE5, 0x07A1, 0x0229, 0x03D9,
    0x0377, 0x00B7, 0x01A6, 0x0655, 0x012E, 0x002B,
    0x002E, 0x00F2, 0x06F2, 0x02D0, 0x0F98, 0x07A0,
    0x009C, 0x0332, 0x0014, 0x01BD, 0x017E, 0x0331,
    0x0371, 0x025B, 0x0498, 0x161F, 0x039E, 0x0654,
    0x00C2, 0x06BA, 0x0140, 0x021E, 0x02F8, 0x01B4,
    0x0134, 0x03FF, 0x0066, 0x0477, 0x01DF, 0x01FE,
    0x0A14, 0x029E, 0x0356, 0x038F, 0x035A, 0x3CB3,
    0x01B2, 0x016A, 0x011A, 0x00B6, 0x02DE, 0x01DD,
    0x017C, 0x0376, 0x002F, 0x0039, 0x03D7, 0x01BE,
    0x0056, 0x0050, 0x017C, 0x01CC, 0x0034, 0x0B3E,
    0x0499, 0x0014, 0x08DE, 0x037B, 0x03EB, 0x08BF,
    0x186E, 0x050F, 0x0030, 0x0169, 0x07F2, 0x00F6,
    0x0042, 0x0198, 0x00BC, 0x002E, 0x023A, 0x01E3,
    0x0036, 0x004C, 0x012E, 0x01A1, 0x007D, 0x00C3,
    0x0392, 0x0063, 0x0F33, 0x016C, 0x01A7, 0x0E77,
    0x01DF, 0x0177, 0x0032, 0x03FE, 0x0322, 0x01AC,
    0x0030, 0x017E, 0x011E, 0x0022, 0x01FB, 0x012A,
    0x002B, 0x0068, 0x00D4, 0x006E, 0x0015, 0x001C,
    0x00E5, 0x01A9, 0x0436, 0x053F, 0x05AE, 0x00B2,
    0x072A, 0x02EA, 0x008E, 0x0175, 0x02BE, 0x018E,
    0x0002, 0x005E, 0x01D6, 0x0055, 0x006A, 0x07F3,
    0x02F9, 0x01D4, 0x016E, 0x03AB, 0x00FF, 0x003C,
    0x0192, 0x01D6, 0x0256, 0x0137, 0x0148, 0x022A,
    0x039C, 0x016D, 0x0116, 0x038A, 0x033E, 0x0156,
    0x03CF, 0x004B, 0x00E6, 0x018F, 0x1E5D, 0x03DA,
    0x0292, 0x0108, 0x06F5, 0x03DB, 0x0092, 0x0178,
    0x014A, 0x03FF, 0x03EE, 0x0A79, 0x0A16, 0x00F7,
    0x01B5, 0x0A15, 0x0D7F, 0x02FA, 0x01E4, 0x0157,
    0x01E2, 0x0185, 0x057E, 0x07DB, 0x0098, 0x0DBE,
    0x019A, 0x05FE, 0x003B, 0x03F5, 0x01BF, 0x01E4,
    0x011E, 0x001B, 0x03AA, 0x0337, 0x1F9C, 0x0942,
    0x05AB, 0x0430, 0x24BF, 0x163A, 0x037E, 0x014E,
    0x00F4, 0x0217, 0x0059, 0x0F32, 0x03F4, 0x01F2,
    0x0031, 0x0136, 0x05C6, 0x0076, 0x0006, 0x02FE,
    0x03FB, 0x009D, 0x013F, 0x002E, 0x02E6, 0x00AD,
    0x0234, 0x021E, 0x0253, 0x012A, 0x0346, 0x029A,
    0x012B, 0x021C, 0x02DA, 0x0004, 0x013C, 0x00F5,
    0x004E, 0x017D, 0x01F8, 0x0006, 0x01FA, 0x01F9,
    0x007A, 0x0067, 0x033B, 0x033A, 0x0586, 0x05C7,
    0x05FF, 0x00C8, 0x014B, 0x024F, 0x02C5, 0x00E7,
    0x014C, 0x035C, 0x00A2, 0x006A, 0x01F3, 0x0071,
    0x005E, 0x0084, 0x063A, 0x03EF, 0x0064, 0x02FE,
    0x0255, 0x003A, 0x061A, 0x0333, 0x037F, 0x00FE,
    0x115B, 0x0F9A, 0x00A6, 0x027D, 0x0B5F, 0x013F,
    0x029E, 0x0293, 0x07B6, 0x000F, 0x0196, 0x02FB,
    0x033F, 0x01FE, 0x019E, 0x01B3, 0x037F, 0x00C4,
    0x00DE, 0x02D2, 0x007A, 0x03CA, 0x01E3, 0x02F7,
    0x00AE, 0x05AF, 0x02FF, 0x026F, 0x00CA, 0x0356,
    0x02C7, 0x02D1, 0x0256, 0x006B, 0x0141, 0x012C,
    0x03BE, 0x0026, 0x00F0, 0x03A3, 0x02D6, 0x005F,
    0x00FF, 0x03F2, 0x00AE, 0x0257, 0x01FE, 0x035E,
    0x01B6, 0x00EE, 0x0658, 0x008F, 0x0232, 0x0657,
    0x12FD, 0x00AF, 0x00E6, 0x0426, 0x0666, 0x009E,
    0x0467, 0x003F, 0x014A, 0x02D3, 0x12FE, 0x099A,
    0x03BF, 0x00DD, 0x04DF, 0x009F, 0x00B8, 0x0863,
    0x06F7, 0x01B8, 0x0346, 0x0179, 0x0FE3, 0x0667,
    0x0659, 0x01CE, 0x00B3, 0x0372, 0x065A, 0x025E,
    0x01AA, 0x0276, 0x027E, 0x02DB, 0x0CE6, 0x115A,
    0x02E7, 0x0139, 0x03DA, 0x01FA, 0x021C, 0x0943,
    0x0862, 0x011F, 0x08B6, 0x07E6, 0x029F, 0x00E5,
    0x0656, 0x049A, 0x000E, 0x0F99, 0x06F6, 0x00DC,
    0x00EC, 0x014B, 0x0230, 0x04A2, 0x0016, 0x02EB,
    0x03AE, 0x02DF, 0x01AA, 0x033E, 0x0196, 0x092E,
    0x06F3, 0x00E7, 0x0B5E, 0x03F2, 0x0086, 0x0347,
    0x022A, 0x0A17, 0x01EF, 0x067F, 0x004A, 0x037E,
    0x02EE, 0x015E, 0x0696, 0x006A, 0x01CD, 0x0077,
    0x073F, 0x0016, 0x01E3, 0x012E, 0x00DB, 0x03BD,
    0x0496, 0x01C6, 0x0323, 0x005E, 0x02F6, 0x027C,
    0x0235, 0x0231, 0x00DA, 0x01EB, 0x0232, 0x02C6,
    0x01F2, 0x016F, 0x02C6, 0x036B, 0x0050, 0x0AFE,
    0x0F9B, 0x00C6, 0x014E, 0x02BC, 0x01CA, 0x027F,
    0x07A5, 0x0DE1, 0x01F1, 0x039E, 0x0DE2, 0x1E5E,
    0x065E, 0x0DE0, 0x115F, 0x00F7, 0x02AB, 0x116E,
    0x019B, 0x04CE, 0x00D3, 0x01C7, 0x02D6, 0x01F3,
    0x016F, 0x014E, 0x05B7, 0x0FA3, 0x0118, 0x025F,
    0x017E, 0x0437, 0x049B, 0x05AE, 0x497A, 0x0D2E,
    0x05B6, 0x1E5F, 0x0DE3, 0x0512, 0x031A, 0x01F2,
    0x007E, 0x015C, 0x035E, 0x04CF, 0x01C8, 0x0194,
    0x12FF, 0x1F7F, 0x00E0, 0x01A2, 0x012F, 0x0087,
    0x014C, 0x0643, 0x0D5E, 0x017F, 0x07A6, 0x0513,
    0x0D5F, 0x022B, 0x065F, 0x03F6, 0x022E, 0x03F7,
    0x0642, 0x036E, 0x00D0, 0x01CB, 0x0378, 0x125EE,
    0x035F, 0x014F, 0x035F, 0x116F, 0x0A4F, 0x0102,
    0x032A, 0x0173, 0x0536, 0x03A7, 0x075E, 0x1F9F,
    0x163B, 0x14DA, 0x526E, 0x165F, 0x0A6E, 0x0596,
    0x07A7, 0x042A, 0x0172, 0x19C2, 0x07E6, 0x04A3,
    0x0327, 0x02A8, 0x07A3, 0x046E, 0x012F, 0x2EFF,
    0x01D7, 0x0266, 0x0BBE, 0x066E, 0x186F, 0x0A73,
    0x1336, 0x02A9, 0x0373, 0x017F, 0x1F9E, 0x0B62,
    0x03A6, 0x0DBF, 0x035B, 0x063B, 0x053B, 0x10EF,
    0x016E, 0x011B, 0x115D, 0x115C, 0x00F2, 0x0176,
    0x0393, 0x034A, 0x0107, 0x115E, 0x0B63, 0x023F,
    0x002A, 0x0CE7, 0x0A7A, 0x06FA, 0x06FB, 0x02AA,
    0x02C2, 0x065B, 0x07A4, 0x02D4, 0x0130, 0x0106,
    0x01FB, 0x0B3F, 0x01B7, 0x00F6, 0x0056, 0x053F,
    0x0126, 0x0048, 0x0233, 0x017D, 0x00A4, 0x08BE,
    0x165E, 0x165D, 0x0A7B, 0x0427, 0x078F, 0x1F7E,
    0x0641, 0x02E4, 0x01E6, 0x01DA, 0x00F8, 0x043A,
    0x02BE, 0x011C, 0x006F, 0x036D, 0x19C3, 0x0020,
    0x06AE, 0x0372, 0x0288, 0x00C0, 0x079D, 0x036E,
    0x0117, 0x02FB, 0x0538, 0x06F2, 0x12F9, 0x1337,
    0x1E58, 0x0214, 0x005E, 0x0CE0, 0x01EE, 0x0A6E,
    0x0215, 0x01C2, 0x12FA, 0x033A, 0x009A, 0x0174,
    0x0CE2, 0x09A1, 0x00FE, 0x0250, 0x02CA, 0x035E,
    0x03A2, 0x0D7D, 0x2EFE, 0x02E8, 0x24BE, 0x1F7C,
    0x10EC, 0x04A2, 0x0052, 0x010D, 0x0277, 0x003A,
    0x0CDE, 0x0A6F, 0x0086, 0x00E4, 0x12FB, 0x14DE,
    0x009E, 0x0062, 0x03CA, 0x03BC, 0x02CA, 0x14DF,
    0x0FE0, 0x030C, 0x03F0, 0x06F3, 0x0796, 0x0B1E,
    0x05B0, 0x15FE, 0x013A, 0x0CDF, 0x079E, 0x01E2,
    0x0166, 0x02BD, 0x0151, 0x0153, 0x0650, 0x0940,
    0x010F, 0x3CB2, 0x10ED, 0x057E, 0x03D4, 0x029E,
    0x0358, 0x06F4, 0x7E76, 0x017C, 0x15FF, 0x047D,
    0x1158, 0x3F3A, 0x0CE3, 0x005F, 0x043A, 0x032F,
    0x010E, 0x1E5A, 0x0A4C, 0x0152, 0x125EF, 0x0B88,
    0x057F, 0x059E, 0x042B, 0x2936, 0x0138, 0x03A1,
    0x03C6, 0x0E56, 0x12F8, 0x149A, 0x526F, 0x0F2E,
    0x079C, 0x02FA, 0x0476, 0x0267, 0x0636, 0x03A0,
    0x014E, 0x0092, 0x0D7C, 0x05AF, 0x010C, 0x011C,
    0x0A10, 0x177E, 0x0131, 0x09A0, 0x03EA, 0x02C2,
    0x02D6, 0x0B89, 0x032E, 0x01E8, 0x0F30, 0x01BA,
    0x0532, 0x0A6C, 0x0F6E, 0x04CC, 0x008E, 0x036C,
    0x0E57, 0x00D6, 0x0162, 0x0024, 0x0252, 0x0F6F,
    0x01AE, 0x0150, 0x0038, 0x07CE, 0x01BB, 0x01F6,
    0x026A, 0x038B, 0x01DB, 0x07CF, 0x14DB, 0x24BC,
    0x0272, 0x053E, 0x073E, 0x078E, 0x0C36, 0x0176,
    0x032B, 0x017A, 0x0190, 0x0CCB, 0x047C, 0x0170,
    0x0054, 0x03EC, 0x049D, 0x0197, 0x043B, 0x0432,
    0x0192, 0x026A, 0x01F0, 0x0076, 0x0216, 0x0A11,
    0x1F7D, 0x02C4, 0x0298, 0x1159, 0x0A4E, 0x0116,
    0x00E4, 0x0216, 0x029A, 0x000F, 0x04DA, 0x04D2,
    0x002B, 0x0011, 0x049E, 0x045A, 0x01BF, 0x01EF,
    0x03CE, 0x01F8, 0x026E, 0x0466, 0x02DC, 0x0168,
    0x030E, 0x00B4, 0x01C3, 0x03CC, 0x028D, 0x01AE,
    0x038E, 0x01B0, 0x0664, 0x0119, 0x01BE, 0x035B,
    0x035F, 0x028E, 0x0A78, 0x01DE, 0x0397, 0x03FE,
    0x01B1, 0x028E, 0x07D2, 0x09A2, 0x033C, 0x02C1,
    0x0FA0, 0x0359, 0x031E, 0x00C1, 0x03D6, 0x0A12,
    0x01C4, 0x0330, 0x075F, 0x0B1F, 0x025A, 0x027B,
    0x04DB, 0x02E5, 0x01FA, 0x036F, 0x0A13, 0x02BB,
    0x00FA, 0x01D4, 0x01F8, 0x018A, 0x161E, 0x0E75,
    0x026B, 0x05B3, 0x01BC, 0x05B2, 0x09A3, 0x0424,
    0x047E, 0x01EE, 0x0FE1, 0x161D, 0x024C, 0x017E,
    0x026B, 0x01DC, 0x00A5, 0x0F2F, 0x161C, 0x028B,
    0x0196, 0x0168, 0x01EF, 0x0394, 0x0E74, 0x013C,
    0x00C9, 0x032E, 0x0941, 0x0D76, 0x050C, 0x0228,
    0x006C, 0x0236, 0x0D2F, 0x0156, 0x00D2, 0x0B8A,
    0x0148, 0x028A, 0x028B, 0x033B, 0x0214, 0x01E9,
    0x03C2, 0x049C, 0x02BA, 0x02E9, 0x028C, 0x01FC,
    0x0103, 0x0B5C, 0x050D, 0x031C, 0x0268, 0x0651,
    0x013A, 0x013B, 0x0118, 0x03D5, 0x0252, 0x0044,
    0x0637, 0x01D2, 0x000E, 0x00F0, 0x0323, 0x02C3,
    0x019A, 0x016C, 0x0046, 0x03E3, 0x024A, 0x00AC,
    0x0269, 0x02C0, 0x0396, 0x027A, 0x0253, 0x0273,
    0x073E, 0x0322, 0x003A, 0x025E, 0x0336, 0x0257,
    0x00D6, 0x0026, 0x03C3, 0x0034, 0x019A, 0x00FB,
    0x0038, 0x0040, 0x0096, 0x01F0, 0x0184, 0x021A,
    0x003E, 0x0042, 0x050E, 0x03CE, 0x035E, 0x0FA1,
    0x017B, 0x02CD, 0x0058, 0x0326, 0x00E4, 0x002E,
    0x004F, 0x000C, 0x0164, 0x0048, 0x0048, 0x0194,
    0x0074, 0x006E, 0x0070, 0x006C, 0x01A4, 0x00A3,
    0x034F, 0x011E, 0x0374, 0x0157, 0x0138, 0x011D,
    0x03CF, 0x033D, 0x0132, 0x0050, 0x023E, 0x005A,
    0x0076, 0x01EC, 0x005D, 0x0008, 0x004C, 0x024E,
    0x0154, 0x001E, 0x01C6, 0x0027, 0x00FE, 0x01EA,
    0x02CE, 0x01DD, 0x02CB, 0x035A, 0x0318, 0x013E,
    0x009B, 0x0288, 0x0339, 0x024D, 0x031F, 0x0128,
    0x00B6, 0x0028, 0x028A, 0x0289, 0x029F, 0x01FD,
    0x029A, 0x00F6, 0x0FA2, 0x0347, 0x0080, 0x01A8,
    0x028F, 0x0326, 0x0327, 0x0370, 0x165C, 0x043F,
    0x0375, 0x013D, 0x1E5B, 0x04DE, 0x0155, 0x00D8,
    0x0319, 0x0096, 0x0640, 0x07E7, 0x007C, 0x0652,
    0x0373, 0x05DE, 0x00CF, 0x0E76, 0x0653, 0x01A0,
    0x0160, 0x0169, 0x01D5, 0x05AA, 0x053A, 0x0B5D,
    0x0254, 0x079A, 0x0533, 0x0425, 0x053E, 0x00A6,
    0x030F, 0x01A2, 0x00B0, 0x04A3, 0x079F, 0x011A,
    0x01EE, 0x02CC, 0x045E, 0x005C, 0x0024, 0x022C,
    0x001A, 0x0338, 0x0132, 0x026C, 0x004E, 0x047F,
    0x01B2, 0x0113, 0x043E, 0x0336, 0x00F0, 0x02CE,
    0x0112, 0x018B, 0x0010, 0x0114, 0x01BE, 0x03FA,
    0x002A, 0x00FA, 0x0033, 0x0060, 0x0146, 0x01DC,
    0x0000, 0x0025, 0x037A, 0x034E, 0x012E, 0x029B,
    0x079B, 0x00E6, 0x03CD, 0x02DD, 0x0117, 0x017A,
    0x002C, 0x03E2, 0x003E, 0x0070, 0x00CE, 0x00B1,
    0x003B,
};

static const uint8_t on2avc_cb6_bits[ON2AVC_CB6_CODES] = {
     7, 10, 10,  7, 12, 12,
     7, 10, 11, 11, 12, 15,
    17, 12, 13, 11, 15, 13,
    10, 11, 11,  7, 13, 13,
     7,  7, 12, 12,  7,  7,
     9,  9,  9, 11, 10,  9,
    12, 12, 13, 13, 13, 13,
     9, 12, 10, 10,  7,  9,
     9, 10, 12, 11, 10, 11,
    11,  9, 11, 11, 11, 11,
    12, 12, 13, 11, 12, 12,
    10, 11, 12, 12, 10, 11,
    11, 10, 12, 14, 13, 11,
    12, 12, 11, 10, 13, 14,
    10, 12, 12, 12, 16, 12,
    12, 10, 13, 13, 13, 12,
    11, 11, 11, 13, 14, 13,
    13, 11, 11, 10, 13, 13,
    11, 12, 12, 13, 16, 12,
    14, 10, 13, 13, 10, 13,
    11, 11, 10, 11, 11,  9,
    11, 11, 10, 11, 12, 12,
    13, 12, 12, 10, 13, 14,
    12, 11, 11, 12, 11,  9,
    11, 11, 10,  7, 12, 13,
     7,  7,  9,  9, 10, 12,
    13, 10, 12, 10, 10, 12,
    13, 12, 10, 10, 11,  9,
     7,  9,  9,  7, 10, 10,
     7,  7,  9,  9, 10, 11,
    10, 10, 12, 11, 11, 12,
    11, 11, 10, 10, 10,  9,
     7,  9,  9,  7,  9,  9,
     7, 10, 10,  7, 10, 10,
    11, 10, 11, 11, 11, 10,
    11, 12, 10,  9, 10, 10,
     8, 10,  9,  7, 10, 11,
    11,  9,  9, 10, 10, 10,
    10, 11, 10, 11, 10, 10,
    10, 11, 11, 10, 11, 11,
    10, 10, 11, 10, 13, 12,
    11, 10, 13, 12, 10, 11,
    11, 10, 11, 12, 13, 12,
    11, 13, 14, 11, 10, 11,
    11,  9, 13, 12, 10, 12,
    11, 11, 10, 13, 13,  9,
    11, 11, 10, 11, 15, 13,
    11, 11, 14, 13, 11, 10,
    11, 11, 10, 12, 13,  9,
    10, 11, 11, 10, 10, 10,
    10, 11, 11, 11, 10, 11,
    10, 10, 10, 11, 10, 10,
    11, 11, 10, 10, 10, 11,
     7,  9,  9,  8,  9,  9,
     7, 10, 10, 10, 11, 11,
    11, 10, 10, 12, 11, 10,
     9, 10, 10,  7,  9, 10,
     7, 10, 11, 11, 10, 11,
    11, 10, 11, 12, 12, 12,
    13, 13, 12, 11, 13, 13,
    11, 11, 11, 11,  9, 11,
    11,  9,  9, 12, 11,  9,
     9, 10, 11, 10, 11, 11,
    11, 11, 11, 11, 11, 11,
    11, 10, 11, 11, 10,  9,
    10, 10, 11, 12, 11, 10,
    12, 11, 10, 11, 10, 12,
    11, 11, 13, 11, 10, 13,
    13, 11, 12, 12, 11, 11,
    11, 11, 10, 10, 13, 13,
    10, 10, 11, 11, 10, 12,
    13, 10, 12, 11, 12, 11,
    13, 13, 10, 14, 13, 10,
    10, 11, 11, 10, 13, 13,
    10, 10, 10, 11, 10, 13,
    12, 10, 12, 12, 12, 12,
    13, 13, 11, 13, 13, 10,
    10, 11, 11, 11, 12, 12,
    10, 11, 11, 10, 12, 12,
    11, 11, 13, 12, 11, 10,
    13, 13, 10, 11, 12, 12,
    10, 11, 11, 11,  9, 12,
    11, 10,  9, 11, 11, 10,
    11, 11, 10, 12, 11, 11,
    10, 11, 11, 10, 11, 11,
    10,  9, 10, 10,  9, 12,
    13,  9, 13, 10, 11, 11,
    13, 14, 11, 14, 14, 13,
    13, 14, 13, 11, 13, 13,
    11, 12, 11, 11, 13, 11,
    11,  9, 12, 12,  9, 11,
    11, 11, 13, 14, 15, 12,
    12, 13, 14, 12, 10, 11,
    11,  9, 13, 12,  9, 10,
    13, 13, 10,  9, 11, 11,
    10, 12, 13, 11, 13, 12,
    13, 13, 13, 13, 10, 13,
    12, 10, 10, 11, 10, 17,
    13, 13, 11, 13, 14, 11,
    11, 11, 12, 12, 11, 15,
    13, 13, 17, 14, 13, 12,
    13, 13, 11, 14, 13, 11,
    10, 13, 13, 11, 14, 14,
    11, 12, 12, 11, 13, 15,
    14, 13, 14, 16, 15, 13,
    12, 12, 13, 11, 14, 14,
    11, 10, 13, 13, 10,  9,
    10, 10, 11, 13, 13, 10,
    13, 13, 12, 13, 13, 13,
    10, 13, 13, 10, 10, 11,
    11, 12, 11, 11,  9, 12,
    12,  9, 11, 11, 11, 12,
    14, 14, 12, 12, 14, 13,
    12, 10, 11, 11,  9, 12,
    12,  9, 10, 14, 14,  9,
    12, 11, 11, 11, 13, 14,
    11, 17, 14, 13, 13, 14,
    13, 11, 14, 13, 11, 12,
    11, 11, 13, 11, 11,  9,
    13, 12,  9, 10, 11, 10,
    12, 14, 14, 12, 14, 13,
    14, 12, 11, 11, 11,  9,
    12, 12,  9, 10, 13, 14,
    10, 10, 11, 10, 10, 14,
    12, 10, 13, 13, 12, 12,
    12, 13, 10, 12, 13, 10,
     9, 10, 11, 11, 13, 13,
    11, 14, 14, 11, 12, 13,
    13, 13, 17, 16, 13, 13,
    13, 16, 13, 12, 11, 13,
    11, 13, 14, 11, 17, 12,
    13, 11, 13, 16, 11, 12,
    13, 12, 13, 15, 17, 13,
    13, 17, 11, 12, 11, 12,
    11, 11, 14, 14, 11, 10,
    13, 13, 10, 12, 10, 11,
    10, 12, 13, 10, 12, 13,
    13, 12, 12, 12, 11, 14,
    12, 10,  9, 11, 11, 12,
    11, 11, 10, 12, 13,  9,
    10, 10, 11, 12, 13, 14,
    12, 12, 15, 14, 12, 11,
    11, 11,  9, 12, 13,  9,
    10, 11, 11,  9, 11, 11,
     9, 11, 11, 12, 11, 13,
    13, 11, 12, 13, 14, 12,
    12, 12, 12, 10, 11, 11,
    10, 10, 11, 11,  9,  9,
    10, 10, 10, 11, 11, 10,
    10, 11, 11, 11, 11, 12,
    10, 11, 11, 11,  9, 10,
    10, 11, 12, 12, 10, 11,
    11, 10, 11, 12, 11, 10,
    12, 13, 10, 11, 12, 13,
    11, 12, 11, 12, 10, 11,
    11, 10, 10, 14, 13, 10,
    10, 11, 11, 10, 13, 12,
    10, 12, 13, 12, 12, 12,
    13, 10, 12, 13, 10, 10,
    11, 11, 11, 13, 13, 10,
    10, 11, 11, 10, 12, 13,
    10, 12, 13, 12, 12, 13,
    11, 10, 12, 12, 10, 12,
    11, 11, 11, 11, 12, 10,
    10, 11, 10, 12, 11, 12,
    11, 13, 12, 10, 11, 13,
    11, 11, 11, 12, 10, 10,
    11, 11, 10,  9, 11, 11,
     9,  9, 10, 10, 10, 11,
    11, 10, 10, 11, 11, 12,
    11, 11, 11, 11, 11, 10,
     9, 11, 10,  7, 10, 10,
     7,  7,  9,  9,  9, 10,
    11, 10, 12, 11, 11, 12,
    11, 11, 10, 10, 11, 10,
     7, 10,  9,  7, 10,  9,
     7, 10, 10,  7,  9, 10,
    10, 10, 11, 12, 10, 10,
    11, 11, 10, 10, 10, 11,
     7,  9, 10,  8, 10, 12,
    11, 10,  9, 11, 10, 10,
    11, 11, 10, 10, 10, 11,
    11, 10, 10, 10, 10, 11,
    11, 10, 10, 10, 13, 12,
    11, 12, 12, 12, 10, 10,
    11, 11, 11, 14, 14, 11,
    11, 13, 13, 11, 11, 11,
    10, 10, 12, 12, 10, 13,
    11, 11, 10, 12, 13,  9,
    10, 11, 11, 11, 14, 13,
    11, 11, 13, 12, 11, 11,
    10, 11, 10, 12, 13, 10,
     9, 11, 11, 10, 10, 10,
    11, 10, 11, 11, 11, 13,
    11, 11, 11, 10, 10, 10,
    11, 10, 10,  9, 10, 10,
     7,  9, 10,  7,  9,  9,
     8, 10, 10, 10, 10, 12,
    11, 10, 11, 11, 12, 10,
    10, 10, 10,  7, 10, 10,
     7,
};

static const uint16_t on2avc_cb6_syms[ON2AVC_CB6_CODES] = {
    0x0000, 0x0002, 0x000E, 0x0011, 0x0013, 0x001D,
    0x001F, 0x0020, 0x0022, 0x002E, 0x0031, 0x0033,
    0x003D, 0x003F, 0x00D1, 0x00D3, 0x00DD, 0x00DF,
    0x00E0, 0x00E2, 0x00EE, 0x00F1, 0x00F3, 0x00FD,
    0x00FF, 0x0101, 0x0103, 0x010D, 0x010F, 0x0110,
    0x0112, 0x011E, 0x0121, 0x0123, 0x012D, 0x012F,
    0x0130, 0x0132, 0x013E, 0x01D0, 0x01D2, 0x01DE,
    0x01E1, 0x01E3, 0x01ED, 0x01EF, 0x01F0, 0x01F2,
    0x01FE, 0x0200, 0x0202, 0x020E, 0x0211, 0x0213,
    0x021D, 0x021F, 0x0220, 0x0222, 0x022E, 0x0231,
    0x0233, 0x023D, 0x023F, 0x02D1, 0x02D3, 0x02DD,
    0x02DF, 0x02E0, 0x02E2, 0x02EE, 0x02F1, 0x02F3,
    0x02FD, 0x02FF, 0x0301, 0x0303, 0x030D, 0x030F,
    0x0310, 0x0312, 0x031E, 0x0321, 0x0323, 0x032D,
    0x032F, 0x0330, 0x0332, 0x033E, 0x03D0, 0x03D2,
    0x03DE, 0x03E1, 0x03E3, 0x03ED, 0x03EF, 0x03F0,
    0x03F2, 0x03FE, 0x0D01, 0x0D03, 0x0D0D, 0x0D0F,
    0x0D10, 0x0D12, 0x0D1E, 0x0D21, 0x0D23, 0x0D2D,
    0x0D2F, 0x0D30, 0x0D32, 0x0D3E, 0x0DD0, 0x0DD2,
    0x0DDE, 0x0DE1, 0x0DE3, 0x0DED, 0x0DEF, 0x0DF0,
    0x0DF2, 0x0DFE, 0x0E00, 0x0E02, 0x0E0E, 0x0E11,
    0x0E13, 0x0E1D, 0x0E1F, 0x0E20, 0x0E22, 0x0E2E,
    0x0E31, 0x0E33, 0x0E3D, 0x0E3F, 0x0ED1, 0x0ED3,
    0x0EDD, 0x0EDF, 0x0EE0, 0x0EE2, 0x0EEE, 0x0EF1,
    0x0EF3, 0x0EFD, 0x0EFF, 0x0F01, 0x0F03, 0x0F0D,
    0x0F0F, 0x0F10, 0x0F12, 0x0F1E, 0x0F21, 0x0F23,
    0x0F2D, 0x0F2F, 0x0F30, 0x0F32, 0x0F3E, 0x0FD0,
    0x0FD2, 0x0FDE, 0x0FE1, 0x0FE3, 0x0FED, 0x0FEF,
    0x0FF0, 0x0FF2, 0x0FFE, 0x1001, 0x1003, 0x100D,
    0x100F, 0x1010, 0x1012, 0x101E, 0x1021, 0x1023,
    0x102D, 0x102F, 0x1030, 0x1032, 0x103E, 0x10D0,
    0x10D2, 0x10DE, 0x10E1, 0x10E3, 0x10ED, 0x10EF,
    0x10F0, 0x10F2, 0x10FE, 0x1100, 0x1102, 0x110E,
    0x1111, 0x1113, 0x111D, 0x111F, 0x1120, 0x1122,
    0x112E, 0x1131, 0x1133, 0x113D, 0x113F, 0x11D1,
    0x11D3, 0x11DD, 0x11DF, 0x11E0, 0x11E2, 0x11EE,
    0x11F1, 0x11F3, 0x11FD, 0x11FF, 0x1201, 0x1203,
    0x120D, 0x120F, 0x1210, 0x1212, 0x121E, 0x1221,
    0x1223, 0x122D, 0x122F, 0x1230, 0x1232, 0x123E,
    0x12D0, 0x12D2, 0x12DE, 0x12E1, 0x12E3, 0x12ED,
    0x12EF, 0x12F0, 0x12F2, 0x12FE, 0x1300, 0x1302,
    0x130E, 0x1311, 0x1313, 0x131D, 0x131F, 0x1320,
    0x1322, 0x132E, 0x1331, 0x1333, 0x133D, 0x133F,
    0x13D1, 0x13D3, 0x13DD, 0x13DF, 0x13E0, 0x13E2,
    0x13EE, 0x13F1, 0x13F3, 0x13FD, 0x13FF, 0x1D00,
    0x1D02, 0x1D0E, 0x1D11, 0x1D13, 0x1D1D, 0x1D1F,
    0x1D20, 0x1D22, 0x1D2E, 0x1D31, 0x1D33, 0x1D3D,
    0x1D3F, 0x1DD1, 0x1DD3, 0x1DDD, 0x1DDF, 0x1DE0,
    0x1DE2, 0x1DEE, 0x1DF1, 0x1DF3, 0x1DFD, 0x1DFF,
    0x1E01, 0x1E03, 0x1E0D, 0x1E0F, 0x1E10, 0x1E12,
    0x1E1E, 0x1E21, 0x1E23, 0x1E2D, 0x1E2F, 0x1E30,
    0x1E32, 0x1E3E, 0x1ED0, 0x1ED2, 0x1EDE, 0x1EE1,
    0x1EE3, 0x1EED, 0x1EEF, 0x1EF0, 0x1EF2, 0x1EFE,
    0x1F00, 0x1F02, 0x1F0E, 0x1F11, 0x1F13, 0x1F1D,
    0x1F1F, 0x1F20, 0x1F22, 0x1F2E, 0x1F31, 0x1F33,
    0x1F3D, 0x1F3F, 0x1FD1, 0x1FD3, 0x1FDD, 0x1FDF,
    0x1FE0, 0x1FE2, 0x1FEE, 0x1FF1, 0x1FF3, 0x1FFD,
    0x1FFF, 0x2000, 0x2002, 0x200E, 0x2011, 0x2013,
    0x201D, 0x201F, 0x2020, 0x2022, 0x202E, 0x2031,
    0x2033, 0x203D, 0x203F, 0x20D1, 0x20D3, 0x20DD,
    0x20DF, 0x20E0, 0x20E2, 0x20EE, 0x20F1, 0x20F3,
    0x20FD, 0x20FF, 0x2101, 0x2103, 0x210D, 0x210F,
    0x2110, 0x2112, 0x211E, 0x2121, 0x2123, 0x212D,
    0x212F, 0x2130, 0x2132, 0x213E, 0x21D0, 0x21D2,
    0x21DE, 0x21E1, 0x21E3, 0x21ED, 0x21EF, 0x21F0,
    0x21F2, 0x21FE, 0x2200, 0x2202, 0x220E, 0x2211,
    0x2213, 0x221D, 0x221F, 0x2220, 0x2222, 0x222E,
    0x2231, 0x2233, 0x223D, 0x223F, 0x22D1, 0x22D3,
    0x22DD, 0x22DF, 0x22E0, 0x22E2, 0x22EE, 0x22F1,
    0x22F3, 0x22FD, 0x22FF, 0x2301, 0x2303, 0x230D,
    0x230F, 0x2310, 0x2312, 0x231E, 0x2321, 0x2323,
    0x232D, 0x232F, 0x2330, 0x2332, 0x233E, 0x23D0,
    0x23D2, 0x23DE, 0x23E1, 0x23E3, 0x23ED, 0x23EF,
    0x23F0, 0x23F2, 0x23FE, 0x2D01, 0x2D03, 0x2D0D,
    0x2D0F, 0x2D10, 0x2D12, 0x2D1E, 0x2D21, 0x2D23,
    0x2D2D, 0x2D2F, 0x2D30, 0x2D32, 0x2D3E, 0x2DD0,
    0x2DD2, 0x2DDE, 0x2DE1, 0x2DE3, 0x2DED, 0x2DEF,
    0x2DF0, 0x2DF2, 0x2DFE, 0x2E00, 0x2E02, 0x2E0E,
    0x2E11, 0x2E13, 0x2E1D, 0x2E1F, 0x2E20, 0x2E22,
    0x2E2E, 0x2E31, 0x2E33, 0x2E3D, 0x2E3F, 0x2ED1,
    0x2ED3, 0x2EDD, 0x2EDF, 0x2EE0, 0x2EE2, 0x2EEE,
    0x2EF1, 0x2EF3, 0x2EFD, 0x2EFF, 0x2F01, 0x2F03,
    0x2F0D, 0x2F0F, 0x2F10, 0x2F12, 0x2F1E, 0x2F21,
    0x2F23, 0x2F2D, 0x2F2F, 0x2F30, 0x2F32, 0x2F3E,
    0x2FD0, 0x2FD2, 0x2FDE, 0x2FE1, 0x2FE3, 0x2FED,
    0x2FEF, 0x2FF0, 0x2FF2, 0x2FFE, 0x3001, 0x3003,
    0x300D, 0x300F, 0x3010, 0x3012, 0x301E, 0x3021,
    0x3023, 0x302D, 0x302F, 0x3030, 0x3032, 0x303E,
    0x30D0, 0x30D2, 0x30DE, 0x30E1, 0x30E3, 0x30ED,
    0x30EF, 0x30F0, 0x30F2, 0x30FE, 0x3100, 0x3102,
    0x310E, 0x3111, 0x3113, 0x311D, 0x311F, 0x3120,
    0x3122, 0x312E, 0x3131, 0x3133, 0x313D, 0x313F,
    0x31D1, 0x31D3, 0x31DD, 0x31DF, 0x31E0, 0x31E2,
    0x31EE, 0x31F1, 0x31F3, 0x31FD, 0x31FF, 0x3201,
    0x3203, 0x320D, 0x320F, 0x3210, 0x3212, 0x321E,
    0x3221, 0x3223, 0x322D, 0x322F, 0x3230, 0x3232,
    0x323E, 0x32D0, 0x32D2, 0x32DE, 0x32E1, 0x32E3,
    0x32ED, 0x32EF, 0x32F0, 0x32F2, 0x32FE, 0x3300,
    0x3302, 0x330E, 0x3311, 0x3313, 0x331D, 0x331F,
    0x3320, 0x3322, 0x332E, 0x3331, 0x3333, 0x333D,
    0x333F, 0x33D1, 0x33D3, 0x33DD, 0x33DF, 0x33E0,
    0x33E2, 0x33EE, 0x33F1, 0x33F3, 0x33FD, 0x33FF,
    0x3D00, 0x3D02, 0x3D0E, 0x3D11, 0x3D13, 0x3D1D,
    0x3D1F, 0x3D20, 0x3D22, 0x3D2E, 0x3D31, 0x3D33,
    0x3D3D, 0x3D3F, 0x3DD1, 0x3DD3, 0x3DDD, 0x3DDF,
    0x3DE0, 0x3DE2, 0x3DEE, 0x3DF1, 0x3DF3, 0x3DFD,
    0x3DFF, 0x3E01, 0x3E03, 0x3E0D, 0x3E0F, 0x3E10,
    0x3E12, 0x3E1E, 0x3E21, 0x3E23, 0x3E2D, 0x3E2F,
    0x3E30, 0x3E32, 0x3E3E, 0x3ED0, 0x3ED2, 0x3EDE,
    0x3EE1, 0x3EE3, 0x3EED, 0x3EEF, 0x3EF0, 0x3EF2,
    0x3EFE, 0x3F00, 0x3F02, 0x3F0E, 0x3F11, 0x3F13,
    0x3F1D, 0x3F1F, 0x3F20, 0x3F22, 0x3F2E, 0x3F31,
    0x3F33, 0x3F3D, 0x3F3F, 0x3FD1, 0x3FD3, 0x3FDD,
    0x3FDF, 0x3FE0, 0x3FE2, 0x3FEE, 0x3FF1, 0x3FF3,
    0x3FFD, 0x3FFF, 0xD001, 0xD003, 0xD00D, 0xD00F,
    0xD010, 0xD012, 0xD01E, 0xD021, 0xD023, 0xD02D,
    0xD02F, 0xD030, 0xD032, 0xD03E, 0xD0D0, 0xD0D2,
    0xD0DE, 0xD0E1, 0xD0E3, 0xD0ED, 0xD0EF, 0xD0F0,
    0xD0F2, 0xD0FE, 0xD100, 0xD102, 0xD10E, 0xD111,
    0xD113, 0xD11D, 0xD11F, 0xD120, 0xD122, 0xD12E,
    0xD131, 0xD133, 0xD13D, 0xD13F, 0xD1D1, 0xD1D3,
    0xD1DD, 0xD1DF, 0xD1E0, 0xD1E2, 0xD1EE, 0xD1F1,
    0xD1F3, 0xD1FD, 0xD1FF, 0xD201, 0xD203, 0xD20D,
    0xD20F, 0xD210, 0xD212, 0xD21E, 0xD221, 0xD223,
    0xD22D, 0xD22F, 0xD230, 0xD232, 0xD23E, 0xD2D0,
    0xD2D2, 0xD2DE, 0xD2E1, 0xD2E3, 0xD2ED, 0xD2EF,
    0xD2F0, 0xD2F2, 0xD2FE, 0xD300, 0xD302, 0xD30E,
    0xD311, 0xD313, 0xD31D, 0xD31F, 0xD320, 0xD322,
    0xD32E, 0xD331, 0xD333, 0xD33D, 0xD33F, 0xD3D1,
    0xD3D3, 0xD3DD, 0xD3DF, 0xD3E0, 0xD3E2, 0xD3EE,
    0xD3F1, 0xD3F3, 0xD3FD, 0xD3FF, 0xDD00, 0xDD02,
    0xDD0E, 0xDD11, 0xDD13, 0xDD1D, 0xDD1F, 0xDD20,
    0xDD22, 0xDD2E, 0xDD31, 0xDD33, 0xDD3D, 0xDD3F,
    0xDDD1, 0xDDD3, 0xDDDD, 0xDDDF, 0xDDE0, 0xDDE2,
    0xDDEE, 0xDDF1, 0xDDF3, 0xDDFD, 0xDDFF, 0xDE01,
    0xDE03, 0xDE0D, 0xDE0F, 0xDE10, 0xDE12, 0xDE1E,
    0xDE21, 0xDE23, 0xDE2D, 0xDE2F, 0xDE30, 0xDE32,
    0xDE3E, 0xDED0, 0xDED2, 0xDEDE, 0xDEE1, 0xDEE3,
    0xDEED, 0xDEEF, 0xDEF0, 0xDEF2, 0xDEFE, 0xDF00,
    0xDF02, 0xDF0E, 0xDF11, 0xDF13, 0xDF1D, 0xDF1F,
    0xDF20, 0xDF22, 0xDF2E, 0xDF31, 0xDF33, 0xDF3D,
    0xDF3F, 0xDFD1, 0xDFD3, 0xDFDD, 0xDFDF, 0xDFE0,
    0xDFE2, 0xDFEE, 0xDFF1, 0xDFF3, 0xDFFD, 0xDFFF,
    0xE000, 0xE002, 0xE00E, 0xE011, 0xE013, 0xE01D,
    0xE01F, 0xE020, 0xE022, 0xE02E, 0xE031, 0xE033,
    0xE03D, 0xE03F, 0xE0D1, 0xE0D3, 0xE0DD, 0xE0DF,
    0xE0E0, 0xE0E2, 0xE0EE, 0xE0F1, 0xE0F3, 0xE0FD,
    0xE0FF, 0xE101, 0xE103, 0xE10D, 0xE10F, 0xE110,
    0xE112, 0xE11E, 0xE121, 0xE123, 0xE12D, 0xE12F,
    0xE130, 0xE132, 0xE13E, 0xE1D0, 0xE1D2, 0xE1DE,
    0xE1E1, 0xE1E3, 0xE1ED, 0xE1EF, 0xE1F0, 0xE1F2,
    0xE1FE, 0xE200, 0xE202, 0xE20E, 0xE211, 0xE213,
    0xE21D, 0xE21F, 0xE220, 0xE222, 0xE22E, 0xE231,
    0xE233, 0xE23D, 0xE23F, 0xE2D1, 0xE2D3, 0xE2DD,
    0xE2DF, 0xE2E0, 0xE2E2, 0xE2EE, 0xE2F1, 0xE2F3,
    0xE2FD, 0xE2FF, 0xE301, 0xE303, 0xE30D, 0xE30F,
    0xE310, 0xE312, 0xE31E, 0xE321, 0xE323, 0xE32D,
    0xE32F, 0xE330, 0xE332, 0xE33E, 0xE3D0, 0xE3D2,
    0xE3DE, 0xE3E1, 0xE3E3, 0xE3ED, 0xE3EF, 0xE3F0,
    0xE3F2, 0xE3FE, 0xED01, 0xED03, 0xED0D, 0xED0F,
    0xED10, 0xED12, 0xED1E, 0xED21, 0xED23, 0xED2D,
    0xED2F, 0xED30, 0xED32, 0xED3E, 0xEDD0, 0xEDD2,
    0xEDDE, 0xEDE1, 0xEDE3, 0xEDED, 0xEDEF, 0xEDF0,
    0xEDF2, 0xEDFE, 0xEE00, 0xEE02, 0xEE0E, 0xEE11,
    0xEE13, 0xEE1D, 0xEE1F, 0xEE20, 0xEE22, 0xEE2E,
    0xEE31, 0xEE33, 0xEE3D, 0xEE3F, 0xEED1, 0xEED3,
    0xEEDD, 0xEEDF, 0xEEE0, 0xEEE2, 0xEEEE, 0xEEF1,
    0xEEF3, 0xEEFD, 0xEEFF, 0xEF01, 0xEF03, 0xEF0D,
    0xEF0F, 0xEF10, 0xEF12, 0xEF1E, 0xEF21, 0xEF23,
    0xEF2D, 0xEF2F, 0xEF30, 0xEF32, 0xEF3E, 0xEFD0,
    0xEFD2, 0xEFDE, 0xEFE1, 0xEFE3, 0xEFED, 0xEFEF,
    0xEFF0, 0xEFF2, 0xEFFE, 0xF001, 0xF003, 0xF00D,
    0xF00F, 0xF010, 0xF012, 0xF01E, 0xF021, 0xF023,
    0xF02D, 0xF02F, 0xF030, 0xF032, 0xF03E, 0xF0D0,
    0xF0D2, 0xF0DE, 0xF0E1, 0xF0E3, 0xF0ED, 0xF0EF,
    0xF0F0, 0xF0F2, 0xF0FE, 0xF100, 0xF102, 0xF10E,
    0xF111, 0xF113, 0xF11D, 0xF11F, 0xF120, 0xF122,
    0xF12E, 0xF131, 0xF133, 0xF13D, 0xF13F, 0xF1D1,
    0xF1D3, 0xF1DD, 0xF1DF, 0xF1E0, 0xF1E2, 0xF1EE,
    0xF1F1, 0xF1F3, 0xF1FD, 0xF1FF, 0xF201, 0xF203,
    0xF20D, 0xF20F, 0xF210, 0xF212, 0xF21E, 0xF221,
    0xF223, 0xF22D, 0xF22F, 0xF230, 0xF232, 0xF23E,
    0xF2D0, 0xF2D2, 0xF2DE, 0xF2E1, 0xF2E3, 0xF2ED,
    0xF2EF, 0xF2F0, 0xF2F2, 0xF2FE, 0xF300, 0xF302,
    0xF30E, 0xF311, 0xF313, 0xF31D, 0xF31F, 0xF320,
    0xF322, 0xF32E, 0xF331, 0xF333, 0xF33D, 0xF33F,
    0xF3D1, 0xF3D3, 0xF3DD, 0xF3DF, 0xF3E0, 0xF3E2,
    0xF3EE, 0xF3F1, 0xF3F3, 0xF3FD, 0xF3FF, 0xFD00,
    0xFD02, 0xFD0E, 0xFD11, 0xFD13, 0xFD1D, 0xFD1F,
    0xFD20, 0xFD22, 0xFD2E, 0xFD31, 0xFD33, 0xFD3D,
    0xFD3F, 0xFDD1, 0xFDD3, 0xFDDD, 0xFDDF, 0xFDE0,
    0xFDE2, 0xFDEE, 0xFDF1, 0xFDF3, 0xFDFD, 0xFDFF,
    0xFE01, 0xFE03, 0xFE0D, 0xFE0F, 0xFE10, 0xFE12,
    0xFE1E, 0xFE21, 0xFE23, 0xFE2D, 0xFE2F, 0xFE30,
    0xFE32, 0xFE3E, 0xFED0, 0xFED2, 0xFEDE, 0xFEE1,
    0xFEE3, 0xFEED, 0xFEEF, 0xFEF0, 0xFEF2, 0xFEFE,
    0xFF00, 0xFF02, 0xFF0E, 0xFF11, 0xFF13, 0xFF1D,
    0xFF1F, 0xFF20, 0xFF22, 0xFF2E, 0xFF31, 0xFF33,
    0xFF3D, 0xFF3F, 0xFFD1, 0xFFD3, 0xFFDD, 0xFFDF,
    0xFFE0, 0xFFE2, 0xFFEE, 0xFFF1, 0xFFF3, 0xFFFD,
    0xFFFF,
};

#define ON2AVC_CB7_CODES 3281
static const uint32_t on2avc_cb7_codes[ON2AVC_CB7_CODES] = {
    0x00000, 0x000EA, 0x000E6, 0x000F4, 0x000F6, 0x00047,
    0x003E2, 0x004A7, 0x00044, 0x004D3, 0x0082A, 0x0026E,
    0x0020E, 0x008A5, 0x02603, 0x02895, 0x049B0, 0x02894,
    0x007BE, 0x0069E, 0x01154, 0x01153, 0x0095F, 0x0038E,
    0x004AC, 0x0128E, 0x00E5E, 0x00992, 0x02A84, 0x0386A,
    0x03F6F, 0x01C54, 0x005D4, 0x00AFB, 0x001BE, 0x00258,
    0x00A59, 0x00043, 0x004A6, 0x004D7, 0x00040, 0x0006C,
    0x007FF, 0x00D39, 0x0005B, 0x00066, 0x0034A, 0x00124,
    0x004B6, 0x00626, 0x0071F, 0x014A3, 0x014A2, 0x0083E,
    0x032D4, 0x049B3, 0x0045E, 0x00ED5, 0x02896, 0x00ABA,
    0x0107B, 0x009EC, 0x0082C, 0x0082B, 0x00D38, 0x0072B,
    0x004FC, 0x049B2, 0x050B1, 0x003FE, 0x009EB, 0x049B1,
    0x00966, 0x00F75, 0x03F70, 0x007BC, 0x00054, 0x00394,
    0x000E8, 0x0052F, 0x0057A, 0x00458, 0x0FB4B, 0x01C55,
    0x00948, 0x032D6, 0x00ED6, 0x0A05F, 0x050B3, 0x00BBD,
    0x0197E, 0x024FC, 0x020C6, 0x0094A, 0x0386B, 0x1F2FF,
    0x050B4, 0x0A060, 0x0FB4C, 0x009ED, 0x02A85, 0x0FB4D,
    0x02605, 0x00ABB, 0x009A2, 0x0145B, 0x0A05D, 0x03F71,
    0x00BFF, 0x1F2FE, 0x0FB49, 0x0FB48, 0x050B2, 0x01155,
    0x01FD6, 0x032D5, 0x00976, 0x02604, 0x00A5A, 0x0A05E,
    0x0FB4A, 0x00DB9, 0x0A063, 0x1F307, 0x0FB4F, 0x1F306,
    0x049B4, 0x0FB50, 0x0FB51, 0x050B6, 0x1F308, 0x050B7,
    0x1F30A, 0x1F309, 0x0A064, 0x1F30B, 0x0A066, 0x06535,
    0x020C7, 0x0A065, 0x032D7, 0x0FB52, 0x02897, 0x0077A,
    0x03F72, 0x0FB4E, 0x050B5, 0x0076E, 0x1F301, 0x1F302,
    0x06533, 0x01FD7, 0x1F300, 0x0A061, 0x1F304, 0x1F303,
    0x07E54, 0x024FD, 0x1F305, 0x06534, 0x02606, 0x0A062,
    0x007C0, 0x0A06A, 0x1F30F, 0x0FB54, 0x0386D, 0x009E6,
    0x1F310, 0x06538, 0x00DBA, 0x014A4, 0x050B9, 0x1F311,
    0x0A06B, 0x0128F, 0x07E55, 0x1F312, 0x0FB55, 0x01C56,
    0x07E56, 0x0FB56, 0x1F313, 0x050BA, 0x01C57, 0x02608,
    0x0A067, 0x1F30D, 0x1F30C, 0x02607, 0x0386C, 0x0A069,
    0x0A068, 0x01557, 0x00ED7, 0x06536, 0x1F30E, 0x0FB53,
    0x02609, 0x007BF, 0x050B8, 0x06537, 0x00DE5, 0x00392,
    0x03F69, 0x0A055, 0x0FB3C, 0x0A054, 0x00AB7, 0x050AB,
    0x0FB3D, 0x00CE6, 0x009E8, 0x014A1, 0x049A8, 0x1F2ED,
    0x02890, 0x009E9, 0x049A9, 0x1F2EE, 0x032D1, 0x020C4,
    0x049AA, 0x0A056, 0x0FB3E, 0x0FB3F, 0x0A051, 0x0A052,
    0x0A053, 0x0FB39, 0x0A050, 0x0096E, 0x0FB3A, 0x1F2EB,
    0x029FE, 0x007FE, 0x0128D, 0x049A7, 0x1F2EC, 0x07E50,
    0x00E36, 0x03867, 0x0FB3B, 0x006EA, 0x03F6B, 0x1F2F4,
    0x1F2F3, 0x03868, 0x049AB, 0x1F2F6, 0x029FF, 0x1F2F5,
    0x0A05A, 0x07E52, 0x1F2F7, 0x07E51, 0x03F6C, 0x1F2FA,
    0x07E53, 0x025FF, 0x1F2F8, 0x1F2F9, 0x009A0, 0x06532,
    0x0FB45, 0x024FB, 0x008B9, 0x01D7D, 0x0FB40, 0x01FD3,
    0x0FB42, 0x0A058, 0x050AC, 0x0A057, 0x0FB41, 0x0A059,
    0x1F2F0, 0x1F2EF, 0x0FB43, 0x03F6A, 0x0FB44, 0x020C5,
    0x1F2F1, 0x1F2F2, 0x004FE, 0x02601, 0x00A58, 0x01FD5,
    0x049AD, 0x00A46, 0x02A80, 0x050AD, 0x009E5, 0x01B56,
    0x02A81, 0x00A36, 0x01556, 0x032D3, 0x02A82, 0x0FB47,
    0x1F2FD, 0x050AE, 0x004BA, 0x00A6B, 0x03F6D, 0x049AE,
    0x01317, 0x009A1, 0x00AB8, 0x02891, 0x03869, 0x01FD4,
    0x049AC, 0x1F2FB, 0x0FB46, 0x0A05B, 0x02600, 0x032D2,
    0x0137E, 0x01C53, 0x02892, 0x00BFE, 0x0A05C, 0x1F2FC,
    0x00CE7, 0x00058, 0x00FF7, 0x009EA, 0x00068, 0x00060,
    0x004D2, 0x004BD, 0x000EE, 0x003A4, 0x006E2, 0x0137F,
    0x0197D, 0x006EB, 0x050B0, 0x03F6E, 0x00E37, 0x00316,
    0x02893, 0x004CB, 0x006EE, 0x01152, 0x008AE, 0x0067E,
    0x00991, 0x0145A, 0x00AB9, 0x049AF, 0x02A83, 0x00A6C,
    0x0045F, 0x02602, 0x006E1, 0x050AF, 0x012D2, 0x0073F,
    0x00061, 0x00526, 0x004D6, 0x0013E, 0x003AE, 0x0005E,
    0x01D7E, 0x0289F, 0x00059, 0x0006A, 0x0082D, 0x00F77,
    0x009EE, 0x006E3, 0x00D3F, 0x1F32B, 0x02A8B, 0x00D3E,
    0x032DE, 0x0FB60, 0x02A8C, 0x020CC, 0x03874, 0x0045B,
    0x00DE8, 0x0082E, 0x00636, 0x012D6, 0x049B9, 0x0260C,
    0x01157, 0x06540, 0x0A073, 0x02504, 0x0289D, 0x050C2,
    0x00AFE, 0x0260D, 0x0289E, 0x00A6F, 0x0004E, 0x006EF,
    0x0099C, 0x00EDA, 0x0062E, 0x00048, 0x00A3A, 0x01292,
    0x013C2, 0x00A72, 0x0012A, 0x028A0, 0x02507, 0x00174,
    0x00DE9, 0x00ABF, 0x00EDE, 0x01146, 0x013C3, 0x032E1,
    0x049BA, 0x03875, 0x03876, 0x00824, 0x0077B, 0x032E2,
    0x01050, 0x00677, 0x00EDB, 0x0145C, 0x02505, 0x032DF,
    0x019C0, 0x050C3, 0x06541, 0x0A074, 0x032E0, 0x00A37,
    0x02506, 0x00ABE, 0x00E78, 0x02A8D, 0x001B4, 0x02A8E,
    0x01D7F, 0x001A4, 0x00DEA, 0x1F32F, 0x050C5, 0x009EF,
    0x00977, 0x020CD, 0x01B60, 0x019C3, 0x017DE, 0x0131A,
    0x0260F, 0x0A075, 0x01C5C, 0x0FB61, 0x07E62, 0x00E79,
    0x02610, 0x0A076, 0x014A7, 0x02611, 0x009FA, 0x007C1,
    0x0145D, 0x1F32C, 0x049BB, 0x019C1, 0x06543, 0x1F32D,
    0x06544, 0x01FD8, 0x06542, 0x01B5E, 0x06545, 0x1F32E,
    0x019C2, 0x005F4, 0x0260E, 0x050C4, 0x01B5F, 0x01C5B,
    0x032E3, 0x1F339, 0x1F33A, 0x1F338, 0x0FB63, 0x028A1,
    0x1F33B, 0x0FB64, 0x049BC, 0x0A07A, 0x1F33C, 0x0A07B,
    0x032E4, 0x07E63, 0x1F33E, 0x07E64, 0x1F33D, 0x0FB65,
    0x028A2, 0x02612, 0x02613, 0x050C6, 0x00967, 0x0155A,
    0x03F78, 0x1F330, 0x0A077, 0x03877, 0x0A078, 0x1F333,
    0x1F331, 0x1F332, 0x03878, 0x1F335, 0x1F336, 0x06546,
    0x1F334, 0x06547, 0x1F337, 0x0A079, 0x0FB62, 0x006FE,
    0x1F342, 0x0FB69, 0x008A7, 0x009FB, 0x1F343, 0x1F344,
    0x050C7, 0x0654A, 0x020CF, 0x1F345, 0x020CE, 0x01FD9,
    0x028A5, 0x0A07C, 0x0A07D, 0x050C8, 0x013C6, 0x03F7A,
    0x0A07E, 0x0387B, 0x01C5D, 0x03879, 0x06548, 0x1F33F,
    0x028A3, 0x00DBE, 0x03F79, 0x1F340, 0x0FB66, 0x028A4,
    0x008B2, 0x0FB67, 0x0387A, 0x0131B, 0x005D5, 0x06549,
    0x1F341, 0x0FB68, 0x0155B, 0x00DE6, 0x07E59, 0x1F318,
    0x00266, 0x00823, 0x01B57, 0x0FB58, 0x1F319, 0x0386F,
    0x01B58, 0x02899, 0x050BB, 0x00DBB, 0x01B59, 0x032D9,
    0x050BC, 0x1F31A, 0x03F74, 0x032DA, 0x0A06D, 0x06539,
    0x03870, 0x0386E, 0x1F315, 0x1F314, 0x024FE, 0x0176A,
    0x032D8, 0x0A06C, 0x1F316, 0x07E57, 0x014A5, 0x049B5,
    0x07E58, 0x00D3A, 0x0075B, 0x02898, 0x1F317, 0x0FB57,
    0x03F73, 0x01B5A, 0x0FB5B, 0x050BE, 0x1F31F, 0x0FB5A,
    0x0653B, 0x1F320, 0x0FB5C, 0x07E5C, 0x07E5D, 0x1F322,
    0x050BF, 0x0A06F, 0x1F321, 0x0FB5D, 0x1F325, 0x1F323,
    0x1F324, 0x01C58, 0x00ED8, 0x0289A, 0x1F326, 0x03F77,
    0x013C0, 0x0653A, 0x03F75, 0x1F31B, 0x024FF, 0x03F76,
    0x0FB59, 0x07E5A, 0x0A06E, 0x02500, 0x07E5B, 0x02A86,
    0x050BD, 0x1F31C, 0x032DB, 0x1F31E, 0x1F31D, 0x049B6,
    0x00C49, 0x1F329, 0x1F328, 0x00BBE, 0x008A6, 0x03871,
    0x01B5B, 0x02A88, 0x01558, 0x020C9, 0x0FB5F, 0x049B7,
    0x014A6, 0x07E5F, 0x1F32A, 0x0197F, 0x01B5C, 0x03872,
    0x00726, 0x01156, 0x02501, 0x0104F, 0x00C48, 0x032DC,
    0x0653C, 0x0176B, 0x1F327, 0x0653D, 0x0289B, 0x07E5E,
    0x0FB5E, 0x0176E, 0x0A071, 0x0A070, 0x0260A, 0x00993,
    0x020C8, 0x0176F, 0x02A87, 0x0289C, 0x00042, 0x00CE8,
    0x01C5A, 0x00F76, 0x008BA, 0x001C8, 0x02A8A, 0x02503,
    0x00136, 0x00A6E, 0x020CB, 0x00A5B, 0x008AF, 0x00ED9,
    0x03873, 0x0653F, 0x07E61, 0x050C1, 0x007A9, 0x0067F,
    0x013C1, 0x01559, 0x00D3B, 0x00DE7, 0x01B5D, 0x050C0,
    0x0260B, 0x02A89, 0x0653E, 0x0A072, 0x07E60, 0x049B8,
    0x00A6D, 0x02502, 0x00E5F, 0x012D3, 0x020CA, 0x0015D,
    0x032DD, 0x01C59, 0x0018E, 0x000E0, 0x07E77, 0x07E78,
    0x07E76, 0x049C5, 0x00BEA, 0x0A090, 0x0A08F, 0x00A3B,
    0x03F80, 0x0655A, 0x0655B, 0x050D1, 0x0A091, 0x1F37E,
    0x1F37F, 0x1F37C, 0x1F37D, 0x0FB77, 0x0655D, 0x050D2,
    0x1F380, 0x0655C, 0x02618, 0x049C3, 0x1F379, 0x0A08D,
    0x07E72, 0x07E73, 0x1F37B, 0x1F37A, 0x0A08E, 0x0145E,
    0x06558, 0x06559, 0x07E74, 0x049C4, 0x0083F, 0x07E75,
    0x0FB76, 0x007AA, 0x008A8, 0x1F382, 0x0FB7B, 0x007AB,
    0x004B2, 0x050D5, 0x07E7C, 0x07E7B, 0x032E8, 0x0261A,
    0x07E7D, 0x1F383, 0x03F81, 0x1F384, 0x0655F, 0x0FB7C,
    0x0A094, 0x0A095, 0x020D3, 0x1F385, 0x050D6, 0x050D7,
    0x01B61, 0x0FB78, 0x07E79, 0x028A7, 0x07E7A, 0x0A092,
    0x1F381, 0x050D3, 0x0FB79, 0x032E7, 0x0655E, 0x0A093,
    0x01DA2, 0x0053B, 0x02619, 0x050D4, 0x0FB7A, 0x020D2,
    0x0094B, 0x0A09A, 0x0FB7F, 0x0FB7E, 0x03884, 0x00C4A,
    0x0FB80, 0x1F38B, 0x019C6, 0x032E9, 0x01C5F, 0x0FB82,
    0x1F38C, 0x0FB81, 0x050D9, 0x07E7E, 0x1F38D, 0x1F38E,
    0x03885, 0x050DB, 0x07E7F, 0x06562, 0x050DA, 0x00E7A,
    0x02A92, 0x1F386, 0x0A096, 0x06560, 0x06561, 0x1F389,
    0x1F387, 0x1F388, 0x050D8, 0x0A098, 0x0FB7D, 0x02A93,
    0x0A097, 0x01FDC, 0x1F38A, 0x0A099, 0x020D4, 0x07E82,
    0x0FB89, 0x1F394, 0x07E81, 0x0A09E, 0x0FB8B, 0x1F395,
    0x07E83, 0x0FB8A, 0x028A8, 0x1F397, 0x1F396, 0x0A09F,
    0x0FB8C, 0x03F82, 0x049C6, 0x1F398, 0x1F399, 0x06563,
    0x02508, 0x03886, 0x07E84, 0x012E6, 0x0A09B, 0x1F38F,
    0x032EA, 0x0FB85, 0x1F390, 0x0FB86, 0x0FB83, 0x0FB84,
    0x0A09C, 0x1F392, 0x1F391, 0x0FB87, 0x02A94, 0x1F393,
    0x0A09D, 0x07E80, 0x0FB88, 0x006B6, 0x1F39D, 0x1F39E,
    0x0A0A1, 0x0A0A2, 0x0155E, 0x1F39F, 0x0A0A3, 0x02509,
    0x020D5, 0x0A0A4, 0x1F3A0, 0x07E86, 0x06564, 0x01FDE,
    0x0FB90, 0x049C8, 0x06565, 0x050DE, 0x0A0A6, 0x07E87,
    0x0A0A5, 0x06566, 0x00E7B, 0x049C7, 0x1F39A, 0x0A0A0,
    0x050DC, 0x00DEC, 0x07E85, 0x0FB8D, 0x01FDD, 0x00CE9,
    0x050DD, 0x0FB8E, 0x1F39B, 0x03F83, 0x0051F, 0x1F39C,
    0x0FB8F, 0x01293, 0x009A3, 0x049BE, 0x1F34E, 0x1F34D,
    0x0654B, 0x0115A, 0x0A07F, 0x0654C, 0x00A47, 0x01C5E,
    0x049BF, 0x1F350, 0x1F34F, 0x0387C, 0x07E67, 0x1F351,
    0x07E66, 0x02A8F, 0x1F353, 0x07E68, 0x1F354, 0x1F352,
    0x0A080, 0x00BBF, 0x1F347, 0x1F348, 0x1F346, 0x0FB6A,
    0x032E5, 0x07E65, 0x1F349, 0x006E4, 0x012D7, 0x049BD,
    0x1F34A, 0x0FB6B, 0x050C9, 0x00DEB, 0x1F34C, 0x1F34B,
    0x0052E, 0x07E6A, 0x1F35F, 0x1F35E, 0x0A081, 0x0387D,
    0x1F361, 0x0654F, 0x1F360, 0x0A082, 0x0387E, 0x1F363,
    0x1F362, 0x050CA, 0x0A084, 0x1F365, 0x03F7D, 0x0A083,
    0x1F364, 0x032E6, 0x1F366, 0x0A085, 0x06550, 0x020D0,
    0x1F356, 0x1F355, 0x00A73, 0x1F357, 0x1F358, 0x1F359,
    0x07E69, 0x0654D, 0x1F35B, 0x0FB6C, 0x1F35A, 0x0654E,
    0x03F7B, 0x1F35D, 0x03F7C, 0x0FB6D, 0x1F35C, 0x009AA,
    0x03880, 0x1F36B, 0x0A086, 0x1F36A, 0x01FDA, 0x1F36C,
    0x0A087, 0x01051, 0x049C2, 0x0FB71, 0x07E6E, 0x0A088,
    0x03F7E, 0x06553, 0x1F36E, 0x1F36D, 0x06552, 0x028A6,
    0x02A90, 0x0A089, 0x1F36F, 0x03881, 0x0074A, 0x049C0,
    0x0FB6F, 0x0FB6E, 0x02614, 0x0FB70, 0x1F368, 0x1F367,
    0x07E6B, 0x0387F, 0x049C1, 0x07E6C, 0x06551, 0x050CB,
    0x014AA, 0x07E6D, 0x1F369, 0x02615, 0x0072C, 0x1F373,
    0x1F372, 0x008BB, 0x00450, 0x07E70, 0x1F375, 0x1F374,
    0x050CE, 0x03882, 0x1F376, 0x0FB74, 0x02617, 0x1F377,
    0x1F378, 0x07E71, 0x06557, 0x0FB75, 0x050CF, 0x050D0,
    0x0A08C, 0x03883, 0x02A91, 0x06555, 0x050CC, 0x06554,
    0x0A08A, 0x1F370, 0x050CD, 0x06556, 0x0FB72, 0x02616,
    0x07E6F, 0x0A08B, 0x01FDB, 0x0053A, 0x03F7F, 0x0FB73,
    0x1F371, 0x020D1, 0x01FE0, 0x1F3F9, 0x1F3F8, 0x02A98,
    0x00C4E, 0x0A0B6, 0x0FBB1, 0x1F3FA, 0x0FBB0, 0x1F3FC,
    0x1F3FD, 0x1F3FB, 0x0A0B7, 0x1F400, 0x1F401, 0x1F402,
    0x1F3FE, 0x1F3FF, 0x1F404, 0x1F405, 0x0FBB2, 0x1F403,
    0x1F3EF, 0x1F3F0, 0x1F3ED, 0x1F3EE, 0x1F3F3, 0x1F3F4,
    0x0FBAB, 0x1F3F1, 0x1F3F2, 0x0A0B5, 0x1F3F6, 0x1F3F5,
    0x0FBAC, 0x01052, 0x0FBAF, 0x1F3F7, 0x0FBAD, 0x0FBAE,
    0x004BC, 0x1F40D, 0x1F40E, 0x1F40C, 0x0FBB8, 0x049CC,
    0x1F410, 0x1F40F, 0x03F87, 0x0A0B9, 0x0A0BA, 0x1F412,
    0x0FBB9, 0x1F411, 0x1F415, 0x1F416, 0x1F413, 0x1F414,
    0x1F418, 0x0A0BB, 0x0FBBA, 0x1F417, 0x07E95, 0x07E93,
    0x1F406, 0x1F407, 0x0A0B8, 0x07E92, 0x0FBB5, 0x1F408,
    0x0FBB3, 0x0FBB4, 0x07E94, 0x0FBB7, 0x1F409, 0x0FBB6,
    0x03F86, 0x01DA3, 0x1F40B, 0x1F40A, 0x019C7, 0x06572,
    0x1F421, 0x1F420, 0x0250F, 0x00DBF, 0x1F422, 0x1F423,
    0x0FBBE, 0x050E2, 0x049CD, 0x1F425, 0x1F424, 0x07E97,
    0x1F427, 0x0FBC0, 0x1F428, 0x0FBBF, 0x1F426, 0x1F42A,
    0x1F42B, 0x1F429, 0x0A0C0, 0x013C7, 0x0A0BD, 0x1F419,
    0x0A0BC, 0x1F41C, 0x1F41D, 0x1F41E, 0x1F41A, 0x1F41B,
    0x0FBBC, 0x1F41F, 0x06571, 0x0FBBB, 0x01FE1, 0x0FBBD,
    0x0A0BF, 0x0A0BE, 0x07E96, 0x0FBC6, 0x1F437, 0x1F438,
    0x1F435, 0x1F436, 0x0A0C3, 0x1F43A, 0x1F439, 0x0FBC7,
    0x1F43B, 0x0FBC9, 0x0FBCA, 0x0FBC8, 0x07E99, 0x0A0C4,
    0x07E9A, 0x1F43C, 0x1F43D, 0x1F43E, 0x0A0C5, 0x050E4,
    0x0FBCB, 0x0FBCC, 0x050E3, 0x07E98, 0x0FBC2, 0x1F42C,
    0x0FBC1, 0x1F42F, 0x1F430, 0x1F42D, 0x1F42E, 0x0A0C1,
    0x1F432, 0x1F433, 0x0FBC3, 0x1F431, 0x0FBC5, 0x1F434,
    0x0FBC4, 0x0A0C2, 0x00AF6, 0x1F444, 0x0FBCF, 0x0261C,
    0x014AB, 0x0A0C8, 0x1F446, 0x1F445, 0x06573, 0x0261D,
    0x1F448, 0x1F447, 0x02A99, 0x0FBD1, 0x0A0C9, 0x1F449,
    0x0FBD0, 0x06574, 0x1F44C, 0x049CF, 0x1F44A, 0x1F44B,
    0x032EC, 0x1F440, 0x1F43F, 0x07E9B, 0x01B62, 0x0388A,
    0x1F441, 0x07E9C, 0x0A0C6, 0x00D6A, 0x0A0C7, 0x0FBCD,
    0x049CE, 0x00EDF, 0x0FBCE, 0x1F443, 0x1F442, 0x07E9D,
    0x03888, 0x0FB91, 0x1F3A8, 0x00E96, 0x00CEA, 0x0FB93,
    0x0FB94, 0x0FB92, 0x1F3A9, 0x03889, 0x0FB95, 0x0A0A7,
    0x0155F, 0x050E0, 0x0A0A8, 0x1F3AB, 0x1F3AA, 0x07E89,
    0x07E8A, 0x0A0AA, 0x0FB96, 0x0A0A9, 0x06567, 0x1F3A2,
    0x1F3A1, 0x02A95, 0x0250A, 0x06568, 0x1F3A4, 0x1F3A3,
    0x050DF, 0x02A96, 0x1F3A5, 0x06569, 0x00C4B, 0x00AFF,
    0x03887, 0x1F3A7, 0x1F3A6, 0x07E88, 0x0261B, 0x1F3BC,
    0x1F3BD, 0x1F3BA, 0x1F3BB, 0x0656C, 0x0FB97, 0x1F3BE,
    0x0656B, 0x1F3C0, 0x0FB98, 0x1F3C1, 0x07E8C, 0x1F3BF,
    0x1F3C2, 0x0FB9A, 0x0FB99, 0x0A0AC, 0x0656D, 0x0FB9B,
    0x1F3C4, 0x1F3C3, 0x07E8D, 0x049C9, 0x0A0AB, 0x1F3AE,
    0x1F3AC, 0x1F3AD, 0x1F3B1, 0x1F3B2, 0x1F3AF, 0x1F3B0,
    0x1F3B5, 0x1F3B6, 0x1F3B7, 0x1F3B3, 0x1F3B4, 0x0656A,
    0x1F3B9, 0x1F3B8, 0x07E8B, 0x03F84, 0x1F3CF, 0x1F3CE,
    0x032EB, 0x0250B, 0x0FB9E, 0x0A0AF, 0x1F3D0, 0x0A0AE,
    0x0A0B1, 0x1F3D1, 0x0A0B0, 0x049CA, 0x1F3D3, 0x1F3D4,
    0x0FBA0, 0x0FB9F, 0x1F3D2, 0x0FBA1, 0x0A0B2, 0x1F3D5,
    0x07E90, 0x07E8E, 0x1F3C6, 0x1F3C5, 0x0656E, 0x1F3C7,
    0x1F3C8, 0x0656F, 0x07E8F, 0x0FB9C, 0x0A0AD, 0x0FB9D,
    0x1F3C9, 0x050E1, 0x01FDF, 0x1F3CC, 0x1F3CD, 0x1F3CA,
    0x1F3CB, 0x00410, 0x0FBA9, 0x1F3DF, 0x1F3DE, 0x0FBA8,
    0x02A97, 0x1F3E1, 0x1F3E0, 0x0250E, 0x0FBAA, 0x1F3E3,
    0x1F3E4, 0x07E91, 0x1F3E2, 0x1F3E7, 0x1F3E8, 0x1F3E5,
    0x1F3E6, 0x1F3EA, 0x1F3EB, 0x1F3EC, 0x1F3E9, 0x0A0B4,
    0x03F85, 0x0FBA4, 0x1F3D6, 0x0FBA2, 0x0FBA3, 0x1F3D8,
    0x0FBA6, 0x1F3D7, 0x0FBA5, 0x1F3DB, 0x0A0B3, 0x1F3DC,
    0x1F3D9, 0x1F3DA, 0x049CB, 0x0FBA7, 0x1F3DD, 0x06570,
    0x0014C, 0x1F4A6, 0x1F4A7, 0x1F4A5, 0x0FBE7, 0x00DEF,
    0x1F4A9, 0x1F4A8, 0x01166, 0x050EB, 0x050EC, 0x1F4AB,
    0x1F4AA, 0x0A0D7, 0x0FBE8, 0x1F4AD, 0x1F4AC, 0x0A0D8,
    0x0A0D9, 0x1F4B0, 0x1F4B1, 0x1F4AE, 0x1F4AF, 0x0FBE6,
    0x1F49C, 0x1F49D, 0x1F49B, 0x0FBE5, 0x07EA2, 0x1F49F,
    0x1F49E, 0x0A0D6, 0x019F6, 0x1F4A1, 0x1F4A2, 0x1F4A0,
    0x050EA, 0x01C9E, 0x1F4A4, 0x1F4A3, 0x0133A, 0x00E4E,
    0x1F4BE, 0x1F4BD, 0x00BEE, 0x001AE, 0x050EE, 0x1F4C0,
    0x1F4BF, 0x050ED, 0x020DA, 0x1F4C2, 0x1F4C1, 0x050EF,
    0x0FBEB, 0x1F4C3, 0x1F4C4, 0x0FBE9, 0x0FBEA, 0x1F4C6,
    0x1F4C7, 0x1F4C5, 0x0A0DC, 0x1F4B4, 0x1F4B5, 0x1F4B2,
    0x1F4B3, 0x03F8A, 0x1F4B7, 0x1F4B8, 0x1F4B6, 0x0A0DA,
    0x02A9B, 0x1F4BA, 0x1F4B9, 0x0145F, 0x004AD, 0x0A0DB,
    0x1F4BC, 0x1F4BB, 0x03F8B, 0x003A6, 0x0A0DE, 0x1F4D1,
    0x1F4D0, 0x0FBED, 0x00DCA, 0x0FBEE, 0x1F4D2, 0x00EFE,
    0x02096, 0x0A0DF, 0x1F4D4, 0x1F4D3, 0x07EA6, 0x0FBEF,
    0x1F4D6, 0x1F4D5, 0x0A0E0, 0x1F4D9, 0x1F4DA, 0x1F4DB,
    0x1F4D7, 0x1F4D8, 0x07EA3, 0x1F4CA, 0x1F4CB, 0x1F4C8,
    0x1F4C9, 0x0388E, 0x0FBEC, 0x1F4CC, 0x049D8, 0x00CEB,
    0x0657A, 0x0A0DD, 0x1F4CD, 0x049D9, 0x00521, 0x1F4CF,
    0x1F4CE, 0x00CFA, 0x01B67, 0x1F4E4, 0x1F4E3, 0x032EF,
    0x00292, 0x0FBF2, 0x1F4E6, 0x1F4E5, 0x0FBF1, 0x014D2,
    0x0A0E5, 0x0A0E4, 0x028AA, 0x1F4E9, 0x0657F, 0x1F4EA,
    0x1F4E7, 0x1F4E8, 0x1F4ED, 0x1F4EE, 0x1F4EB, 0x1F4EC,
    0x0412E, 0x1F4DC, 0x0A0E1, 0x0A0E2, 0x049DA, 0x1F4DE,
    0x1F4DF, 0x1F4DD, 0x0657B, 0x01B66, 0x1F4E0, 0x0FBF0,
    0x0388F, 0x00522, 0x0A0E3, 0x1F4E2, 0x1F4E1, 0x0657E,
    0x007C2, 0x0A0EB, 0x1F4F8, 0x1F4F7, 0x0FBF5, 0x00F7A,
    0x1F4F9, 0x0FBF6, 0x020DB, 0x028AB, 0x1F4FB, 0x1F4FC,
    0x1F4FA, 0x0FBF7, 0x01DFE, 0x0BEFA, 0x1F4FD, 0x07EA7,
    0x1F502, 0x13FC2, 0x1F503, 0x1F4FE, 0x1F4FF, 0x1F4F1,
    0x0FBF3, 0x1F4F2, 0x1F4EF, 0x1F4F0, 0x02576, 0x0A0E7,
    0x1F4F3, 0x0A0E6, 0x07092, 0x0FBF4, 0x1F4F5, 0x1F4F4,
    0x049DB, 0x0096F, 0x1F4F6, 0x0A0EA, 0x02623, 0x006FF,
    0x1F45C, 0x1F45D, 0x1F45B, 0x07E9E, 0x03F88, 0x1F45F,
    0x1F45E, 0x020D7, 0x06575, 0x1F462, 0x0FBD2, 0x1F460,
    0x1F461, 0x1F464, 0x0FBD4, 0x0FBD3, 0x1F463, 0x1F467,
    0x1F468, 0x1F469, 0x1F465, 0x1F466, 0x1F44F, 0x1F450,
    0x1F451, 0x1F44D, 0x1F44E, 0x1F453, 0x1F454, 0x1F452,
    0x020D6, 0x0388B, 0x1F457, 0x1F458, 0x1F455, 0x1F456,
    0x028A9, 0x1F45A, 0x1F459, 0x00DED, 0x020D8, 0x1F472,
    0x1F471, 0x0261F, 0x006F0, 0x0FBD6, 0x1F474, 0x1F473,
    0x050E5, 0x049D3, 0x0FBD7, 0x1F475, 0x015EE, 0x1F477,
    0x0A0CD, 0x1F478, 0x1F476, 0x050E6, 0x1F47A, 0x1F47B,
    0x1F479, 0x0A0CE, 0x0A0CB, 0x1F46A, 0x0A0CA, 0x0261E,
    0x049D0, 0x0A0CC, 0x1F46C, 0x1F46B, 0x06576, 0x049D1,
    0x1F46E, 0x1F46D, 0x01FE2, 0x004DE, 0x049D2, 0x1F470,
    0x1F46F, 0x0FBD5, 0x00376, 0x0FBDB, 0x0FBDC, 0x1F482,
    0x0A0D0, 0x00C5E, 0x1F484, 0x1F483, 0x00BEB, 0x020D9,
    0x06578, 0x1F486, 0x1F485, 0x07E9F, 0x0A0D1, 0x1F487,
    0x07EA0, 0x050E8, 0x1F488, 0x0FBDF, 0x1F489, 0x0FBDD,
    0x0FBDE, 0x050E7, 0x0A0CF, 0x1F47D, 0x1F47C, 0x0FBD8,
    0x06577, 0x1F47F, 0x1F47E, 0x032ED, 0x012BA, 0x03F89,
    0x0FBD9, 0x1F480, 0x032EE, 0x00C4F, 0x1F481, 0x0FBDA,
    0x01B63, 0x00DEE, 0x0FBE1, 0x1F491, 0x0115B, 0x001CE,
    0x049D6, 0x1F493, 0x1F492, 0x0A0D4, 0x049D7, 0x1F495,
    0x1F494, 0x02A9A, 0x0A0D5, 0x0FBE3, 0x1F497, 0x1F496,
    0x0FBE2, 0x0FBE4, 0x1F49A, 0x1F498, 0x1F499, 0x049D4,
    0x1F48A, 0x0A0D2, 0x0FBE0, 0x049D5, 0x0A0D3, 0x1F48C,
    0x1F48B, 0x07EA1, 0x01FE3, 0x1F48E, 0x1F48D, 0x02622,
    0x00520, 0x050E9, 0x1F490, 0x1F48F, 0x06579, 0x0018A,
    0x09FE6, 0x1F0E6, 0x1F0E5, 0x0459C, 0x00DCB, 0x1F0E7,
    0x0FA96, 0x012D0, 0x020A6, 0x1F0E9, 0x1F0EA, 0x1F0E8,
    0x0FA97, 0x09FE7, 0x1F0EC, 0x1F0EB, 0x06370, 0x09FE8,
    0x1F0EE, 0x1F0EF, 0x0FA98, 0x1F0ED, 0x1F0DC, 0x1F0DD,
    0x1F0DE, 0x1F0DA, 0x1F0DB, 0x1F0DF, 0x1F0E0, 0x0FA93,
    0x0FA94, 0x0507C, 0x1F0E2, 0x1F0E3, 0x1F0E1, 0x0507B,
    0x00AAE, 0x1F0E4, 0x0FA95, 0x00F5D, 0x00DB4, 0x0FA9C,
    0x1F0F9, 0x00FF2, 0x003AC, 0x1F0FB, 0x1F0FC, 0x1F0FA,
    0x029E0, 0x025CF, 0x1F0FE, 0x1F0FD, 0x029E1, 0x029E2,
    0x09FE9, 0x1F180, 0x1F0FF, 0x07E04, 0x0FA9D, 0x1F183,
    0x1F181, 0x1F182, 0x0FA9A, 0x1F0F1, 0x0FA99, 0x1F0F0,
    0x0384C, 0x1F0F3, 0x1F0F4, 0x1F0F2, 0x0FA9B, 0x019F7,
    0x1F0F6, 0x1F0F5, 0x02878, 0x0018C, 0x06371, 0x1F0F8,
    0x1F0F7, 0x07E03, 0x002FC, 0x0507E, 0x1F18E, 0x1F18D,
    0x06373, 0x00D2C, 0x1F190, 0x1F18F, 0x01356, 0x01357,
    0x0FAA0, 0x1F192, 0x1F191, 0x0507F, 0x02879, 0x1F194,
    0x1F193, 0x0384D, 0x1F197, 0x0FAA1, 0x0FAA2, 0x1F195,
    0x1F196, 0x1F186, 0x1F187, 0x1F188, 0x1F184, 0x1F185,
    0x0507D, 0x1F189, 0x0FA9E, 0x06372, 0x020A7, 0x07E05,
    0x1F18B, 0x1F18A, 0x09FEA, 0x00AF8, 0x0FA9F, 0x1F18C,
    0x00A30, 0x0106F, 0x1F19F, 0x1F19E, 0x01AD6, 0x005F6,
    0x1F1A1, 0x1F1A2, 0x1F1A0, 0x0FAA8, 0x0099E, 0x0FAA9,
    0x1F1A3, 0x06375, 0x0459E, 0x07E07, 0x1F1A6, 0x1F1A4,
    0x1F1A5, 0x09FEC, 0x0FAAA, 0x1F1A7, 0x09FEB, 0x0FAA4,
    0x1F199, 0x1F198, 0x0FAA3, 0x0FAA6, 0x0459D, 0x1F19B,
    0x1F19A, 0x0FAA5, 0x01C49, 0x07E06, 0x1F19C, 0x03F56,
    0x0077E, 0x05080, 0x1F19D, 0x0FAA7, 0x06374, 0x008A2,
    0x1F1B3, 0x1F1B4, 0x0FAAE, 0x1F1B2, 0x00AB0, 0x1F1B6,
    0x1F1B5, 0x04980, 0x0384E, 0x0FAAF, 0x1F1B8, 0x1F1B7,
    0x06377, 0x04981, 0x1F1BA, 0x1F1B9, 0x07E09, 0x07E0A,
    0x1F1BC, 0x1F1BD, 0x1F1BB, 0x0FAB0, 0x1F1AA, 0x1F1AB,
    0x1F1AC, 0x1F1A8, 0x1F1A9, 0x0FAAC, 0x07E08, 0x0FAAB,
    0x1F1AD, 0x029E3, 0x06376, 0x0FAAD, 0x1F1AE, 0x1F1AF,
    0x0459F, 0x1F1B1, 0x1F1B0, 0x01AD7, 0x00822, 0x1DFF2,
    0x1DFF3, 0x1DFF1, 0x0FA82, 0x03F52, 0x1DFF5, 0x1DFF4,
    0x00BF6, 0x062F8, 0x07DFD, 0x1DFF7, 0x1DFF6, 0x09FE0,
    0x062F9, 0x1DFF9, 0x1DFF8, 0x029A6, 0x0FA83, 0x1DFFC,
    0x1DFFD, 0x1DFFA, 0x1DFFB, 0x13FC3, 0x17DF6, 0x17DF7,
    0x0FA80, 0x0412F, 0x05074, 0x1C24C, 0x05F7C, 0x05F7E,
    0x03848, 0x05F7F, 0x1C24E, 0x1C24D, 0x07DFC, 0x01FC6,
    0x1DFF0, 0x1C24F, 0x02577, 0x029A7, 0x1EF67, 0x1EF66,
    0x024EE, 0x003BE, 0x0FA88, 0x1EF69, 0x1EF68, 0x062FA,
    0x0384B, 0x1EF6B, 0x1EF6A, 0x015EF, 0x05076, 0x0FA89,
    0x1EF6D, 0x1EF6C, 0x07E00, 0x1EF6F, 0x0FA8A, 0x1EF6E,
    0x062FB, 0x1EF60, 0x0FA84, 0x1DFFE, 0x1DFFF, 0x07DFE,
    0x0FA85, 0x1EF62, 0x1EF61, 0x03F54, 0x0384A, 0x1EF63,
    0x0FA86, 0x00E30, 0x002EC, 0x0FA87, 0x1EF65, 0x1EF64,
    0x07DFF, 0x002FE, 0x09FE3, 0x1EF7C, 0x1EF7B, 0x07E01,
    0x0095C, 0x1EF7E, 0x1EF7D, 0x01456, 0x0133B, 0x05077,
    0x1F0C0, 0x1EF7F, 0x062FD, 0x05078, 0x1F0C2, 0x1F0C1,
    0x01C46, 0x03F55, 0x1F0C4, 0x1F0C5, 0x1F0C3, 0x0FA8D,
    0x1EF72, 0x1EF73, 0x1EF74, 0x1EF70, 0x1EF71, 0x062FC,
    0x1EF75, 0x0FA8B, 0x09FE2, 0x0154E, 0x1EF78, 0x0FA8C,
    0x1EF76, 0x1EF77, 0x00F5C, 0x1EF7A, 0x1EF79, 0x00DB2,
    0x0106E, 0x1F0D3, 0x1F0D2, 0x00ED0, 0x0045A, 0x07E02,
    0x0FA8F, 0x1F0D4, 0x1F0D5, 0x01C48, 0x0FA91, 0x0FA90,
    0x025CE, 0x032BE, 0x062FF, 0x1F0D7, 0x1F0D6, 0x0FA92,
    0x09FE5, 0x1F0D9, 0x1F0D8, 0x09FE4, 0x1F0C8, 0x1F0C9,
    0x1F0C6, 0x1F0C7, 0x05079, 0x1F0CB, 0x1F0CC, 0x1F0CA,
    0x0FA8E, 0x0507A, 0x1F0CE, 0x1F0CD, 0x024EF, 0x0018F,
    0x1F0D0, 0x1F0D1, 0x1F0CF, 0x062FE, 0x04986, 0x1F211,
    0x1F210, 0x029E5, 0x0149C, 0x09FFF, 0x1F212, 0x0FAD5,
    0x0FAD6, 0x0FAD8, 0x1F214, 0x1F213, 0x0FAD7, 0x0A000,
    0x0A001, 0x1F216, 0x1F215, 0x0FAD9, 0x0A003, 0x0FADA,
    0x1F217, 0x0A002, 0x0FAD1, 0x1F205, 0x1F203, 0x1F204,
    0x1F207, 0x1F208, 0x1F209, 0x1F206, 0x0FAD2, 0x1F20C,
    0x0FAD3, 0x1F20A, 0x1F20B, 0x00E31, 0x0FAD4, 0x1F20F,
    0x1F20D, 0x1F20E, 0x003BC, 0x1F221, 0x0FADD, 0x1F21F,
    0x1F220, 0x01D2E, 0x1F223, 0x1F222, 0x0384F, 0x0A007,
    0x1F225, 0x1F226, 0x07E18, 0x1F224, 0x1F229, 0x1F22A,
    0x1F227, 0x1F228, 0x01ADD, 0x0A009, 0x1F22B, 0x0A008,
    0x04987, 0x0FADC, 0x07E16, 0x1F218, 0x0FADB, 0x07E15,
    0x1F21B, 0x1F21C, 0x1F219, 0x1F21A, 0x0637A, 0x0A005,
    0x0A006, 0x07E17, 0x0A004, 0x025F0, 0x1F21E, 0x1F21D,
    0x01ADC, 0x05088, 0x1F235, 0x1F234, 0x05087, 0x01978,
    0x1F238, 0x07E1A, 0x1F236, 0x1F237, 0x07E1C, 0x1F239,
    0x0FAE2, 0x07E1B, 0x1F23B, 0x0A00D, 0x1F23C, 0x1F23A,
    0x0FAE3, 0x01979, 0x0A00E, 0x1F23D, 0x04989, 0x1F22E,
    0x1F22F, 0x1F22C, 0x1F22D, 0x1F231, 0x0A00A, 0x1F232,
    0x0FADE, 0x1F230, 0x04988, 0x0FADF, 0x1F233, 0x07E19,
    0x01ADE, 0x0A00C, 0x0FAE1, 0x0FAE0, 0x0A00B, 0x032C2,
    0x1F249, 0x1F24A, 0x1F248, 0x0A010, 0x05089, 0x1F24C,
    0x0A011, 0x1F24B, 0x0A012, 0x0FAEA, 0x1F24E, 0x0508A,
    0x1F24D, 0x0A014, 0x1F250, 0x0A013, 0x1F24F, 0x029E6,
    0x07E1D, 0x1F253, 0x1F251, 0x1F252, 0x0FAE4, 0x0FAE5,
    0x0FAE6, 0x1F23E, 0x1F23F, 0x1F242, 0x0A00F, 0x1F240,
    0x1F241, 0x0FAE8, 0x1F244, 0x1F245, 0x0FAE7, 0x1F243,
    0x0FAE9, 0x1F247, 0x1F246, 0x03850, 0x01286, 0x1F25E,
    0x1F25D, 0x03851, 0x00D2D, 0x1F260, 0x1F261, 0x1F25F,
    0x07E1E, 0x00A68, 0x1F262, 0x0A015, 0x0637C, 0x0508C,
    0x0498A, 0x1F265, 0x1F263, 0x1F264, 0x03852, 0x0FAEE,
    0x1F266, 0x0A016, 0x0FAEB, 0x0FAEC, 0x1F254, 0x1F255,
    0x1F258, 0x0637B, 0x1F259, 0x1F256, 0x1F257, 0x032C3,
    0x0FAED, 0x0508B, 0x03F59, 0x01310, 0x032C4, 0x1F25C,
    0x1F25A, 0x1F25B, 0x04982, 0x09FEE, 0x1F1C4, 0x00FF3,
    0x01457, 0x06378, 0x1F1C6, 0x1F1C5, 0x0FAB4, 0x0287B,
    0x0FAB6, 0x0FAB5, 0x00FF6, 0x03F57, 0x0FAB7, 0x09FEF,
    0x1F1C7, 0x05083, 0x09FF0, 0x1F1C8, 0x0FAB8, 0x01FC8,
    0x09FED, 0x0FAB2, 0x0FAB1, 0x1F1BE, 0x07E0B, 0x05081,
    0x0FAB3, 0x1F1BF, 0x024F0, 0x0287A, 0x1F1C1, 0x1F1C0,
    0x01FC7, 0x00E5A, 0x05082, 0x1F1C3, 0x1F1C2, 0x07E0C,
    0x032C0, 0x0FABE, 0x0FABF, 0x1F1D1, 0x1F1D2, 0x07E10,
    0x1F1D5, 0x1F1D3, 0x1F1D4, 0x0FAC2, 0x0FAC3, 0x1F1D6,
    0x0FAC0, 0x0FAC1, 0x1F1D9, 0x1F1DA, 0x1F1D7, 0x1F1D8,
    0x05085, 0x09FF2, 0x1F1DC, 0x1F1DB, 0x0FAC4, 0x0FAB9,
    0x0FABA, 0x1F1CA, 0x07E0D, 0x1F1C9, 0x1F1CB, 0x1F1CC,
    0x07E0E, 0x0FABB, 0x0FABD, 0x1F1CD, 0x1F1CE, 0x0FABC,
    0x09FF1, 0x07E0F, 0x1F1D0, 0x1F1CF, 0x05084, 0x0287C,
    0x1F1E6, 0x1F1E5, 0x03F58, 0x0287D, 0x09FF6, 0x1F1E9,
    0x1F1E7, 0x1F1E8, 0x07E13, 0x09FF8, 0x1F1EA, 0x09FF7,
    0x1F1ED, 0x09FF9, 0x0FAC8, 0x1F1EB, 0x1F1EC, 0x09FFB,
    0x04984, 0x09FFA, 0x04983, 0x09FF3, 0x1F1DE, 0x1F1DD,
    0x07E11, 0x1F1DF, 0x1F1E0, 0x0FAC6, 0x09FF4, 0x0FAC5,
    0x07E12, 0x1F1E2, 0x1F1E1, 0x05086, 0x00ED2, 0x09FF5,
    0x1F1E4, 0x1F1E3, 0x0FAC7, 0x004D4, 0x1F1F9, 0x1F1FA,
    0x09FFC, 0x0FACD, 0x029E4, 0x0FACE, 0x1F1FB, 0x0287E,
    0x09FFD, 0x0FAD0, 0x1F1FC, 0x0FACF, 0x06379, 0x1F1FE,
    0x1F1FF, 0x1F1FD, 0x09FFE, 0x04985, 0x07E14, 0x1F202,
    0x1F200, 0x1F201, 0x1F1EF, 0x1F1F0, 0x1F1F1, 0x1F1EE,
    0x0FAC9, 0x1F1F3, 0x1F1F4, 0x1F1F2, 0x0FACA, 0x032C1,
    0x1F1F6, 0x0FACC, 0x1F1F5, 0x0FACB, 0x01C9F, 0x1F1F8,
    0x1F1F7, 0x01FC9, 0x000EC, 0x0650B, 0x0650C, 0x07E2B,
    0x029EC, 0x00DB6, 0x0FB04, 0x1F298, 0x0098C, 0x01FCC,
    0x0650D, 0x07E2C, 0x0FB05, 0x0FB06, 0x0FB08, 0x1F29A,
    0x1F299, 0x0FB07, 0x00ED3, 0x05094, 0x1F29B, 0x07E2D,
    0x0FB09, 0x03855, 0x06508, 0x0FB02, 0x1F292, 0x0FB01,
    0x1F295, 0x1F296, 0x1F293, 0x1F294, 0x05093, 0x0FB03,
    0x0650A, 0x07E2A, 0x06509, 0x00BB6, 0x0A02B, 0x1F297,
    0x00A54, 0x00708, 0x1F2A2, 0x1F2A1, 0x007A8, 0x004CA,
    0x029EE, 0x07E2F, 0x05095, 0x0197B, 0x01C4A, 0x0A02D,
    0x07E30, 0x01FCD, 0x0FB0C, 0x0650F, 0x0FB0D, 0x1F2A3,
    0x0650E, 0x01D78, 0x06510, 0x07E31, 0x07E32, 0x04993,
    0x07E2E, 0x0A02C, 0x03F5D, 0x1F29E, 0x1F29F, 0x03856,
    0x1F29C, 0x1F29D, 0x03857, 0x0FB0A, 0x1F2A0, 0x029ED,
    0x004B8, 0x024F5, 0x03F5E, 0x0FB0B, 0x03858, 0x008AC,
    0x0FB13, 0x07E35, 0x0FB12, 0x06512, 0x01C4C, 0x07E36,
    0x0FB14, 0x01550, 0x02882, 0x07E37, 0x07E38, 0x06513,
    0x05096, 0x06514, 0x0A032, 0x1F2A7, 0x1F2A8, 0x006E7,
    0x032CA, 0x1F2A9, 0x0FB15, 0x029EF, 0x07E34, 0x0A02E,
    0x0A02F, 0x0FB0E, 0x07E33, 0x0FB10, 0x06511, 0x1F2A4,
    0x0FB0F, 0x04994, 0x02881, 0x0A031, 0x0A030, 0x0FB11,
    0x01289, 0x1F2A6, 0x1F2A5, 0x01C4B, 0x05098, 0x1F2AE,
    0x1F2AD, 0x07E3A, 0x06519, 0x1F2AF, 0x1F2B0, 0x0FB19,
    0x0A038, 0x05099, 0x1F2B2, 0x1F2B1, 0x07E3B, 0x0FB1A,
    0x1F2B4, 0x1F2B5, 0x04995, 0x1F2B3, 0x0149D, 0x03F60,
    0x0FB1B, 0x025F2, 0x0A033, 0x06516, 0x06515, 0x03F5F,
    0x0A035, 0x1F2AA, 0x07E39, 0x0A034, 0x0FB16, 0x06517,
    0x1F2AC, 0x1F2AB, 0x0FB17, 0x05097, 0x0A036, 0x0A037,
    0x0FB18, 0x06518, 0x0031A, 0x0A03C, 0x1F2BA, 0x1F2B9,
    0x07E3F, 0x0057E, 0x0FB1C, 0x1F2BB, 0x00F5E, 0x01551,
    0x025F3, 0x1F2BC, 0x07E40, 0x04996, 0x00BB8, 0x1F2BD,
    0x04997, 0x0385A, 0x00E32, 0x0651D, 0x1F2BF, 0x1F2BE,
    0x07E41, 0x0651A, 0x0A03A, 0x1F2B7, 0x1F2B6, 0x0A039,
    0x03859, 0x07E3D, 0x07E3C, 0x0509A, 0x029F0, 0x0651C,
    0x0A03B, 0x0651B, 0x07E3E, 0x0096A, 0x1F2B8, 0x0509B,
    0x01D79, 0x0073E, 0x0A01C, 0x1F26B, 0x1F26A, 0x0FAF0,
    0x01312, 0x0FAF1, 0x1F26C, 0x0074E, 0x00DE2, 0x0637D,
    0x0FAF2, 0x1F26D, 0x029E9, 0x025F1, 0x0508D, 0x1F26E,
    0x0072A, 0x01288, 0x1F270, 0x1F271, 0x1F26F, 0x0637E,
    0x1F267, 0x0A018, 0x0498B, 0x0A017, 0x029E7, 0x0A019,
    0x0A01A, 0x1F268, 0x029E8, 0x0175C, 0x0287F, 0x0A01B,
    0x1F269, 0x03F5A, 0x02880, 0x0498C, 0x0FAEF, 0x00DB5,
    0x07E1F, 0x1F27B, 0x1F27A, 0x0FAF4, 0x024F1, 0x1F27E,
    0x0A01F, 0x1F27C, 0x1F27D, 0x0FAF5, 0x1F280, 0x1F27F,
    0x06502, 0x0FAF6, 0x1F282, 0x07E21, 0x07E20, 0x1F281,
    0x029EA, 0x07E23, 0x07E22, 0x0154F, 0x0637F, 0x06500,
    0x0498D, 0x0FAF3, 0x1F272, 0x1F273, 0x0A01D, 0x0508E,
    0x032C5, 0x1F275, 0x1F276, 0x1F274, 0x06501, 0x03853,
    0x0A01E, 0x1F279, 0x1F277, 0x1F278, 0x0074F, 0x03854,
    0x032C7, 0x0FAFA, 0x1F286, 0x029EB, 0x07E25, 0x0A024,
    0x024F3, 0x01FCA, 0x0508F, 0x032C8, 0x1F287, 0x0A025,
    0x07E26, 0x0A026, 0x1F288, 0x1F289, 0x006E6, 0x0498E,
    0x1F28B, 0x1F28A, 0x032C9, 0x032C6, 0x0A021, 0x0A022,
    0x0A020, 0x03F5B, 0x1F283, 0x1F284, 0x06503, 0x0FAF7,
    0x024F2, 0x07E24, 0x1F285, 0x0FAF8, 0x01313, 0x01ADF,
    0x0FAF9, 0x0A023, 0x00AB1, 0x0055E, 0x1F28F, 0x1F28E,
    0x00972, 0x005FA, 0x024F4, 0x0FAFE, 0x1F290, 0x04990,
    0x020BC, 0x0FAFF, 0x1F291, 0x01D2F, 0x04991, 0x0A02A,
    0x05092, 0x0A029, 0x0FB00, 0x04992, 0x06507, 0x06506,
    0x01FCB, 0x03F5C, 0x05090, 0x06504, 0x0A027, 0x1F28C,
    0x1F28D, 0x07E28, 0x07E27, 0x0A028, 0x05091, 0x0FAFC,
    0x0FAFB, 0x0197A, 0x003D6, 0x0FAFD, 0x07E29, 0x0498F,
    0x06505, 0x00056, 0x020C0, 0x02888, 0x0005C, 0x0005A,
    0x0071E, 0x00CE4, 0x00A32, 0x005D6, 0x00A34, 0x0288A,
    0x02889, 0x00A33, 0x049A2, 0x0A046, 0x01D7A, 0x025F9,
    0x0A045, 0x01315, 0x01316, 0x07E4B, 0x01458, 0x00676,
    0x00F71, 0x01B51, 0x006FD, 0x07E4A, 0x06529, 0x01768,
    0x00AB3, 0x07E49, 0x009E4, 0x03F64, 0x050A1, 0x00DE3,
    0x00064, 0x008B8, 0x00AB4, 0x00BBB, 0x007FA, 0x0003C,
    0x009E7, 0x00AFA, 0x01459, 0x00AB5, 0x001AF, 0x03862,
    0x0288C, 0x0019E, 0x00BFD, 0x01C51, 0x0149F, 0x00F73,
    0x029FA, 0x07E4C, 0x0A047, 0x1F2D4, 0x03863, 0x00F74,
    0x01B52, 0x01B53, 0x050A2, 0x0137D, 0x006E8, 0x008A4,
    0x029F9, 0x00E33, 0x006E0, 0x03F65, 0x049A3, 0x1F2D3,
    0x03861, 0x00A35, 0x0197C, 0x00F72, 0x012D1, 0x0288B,
    0x0015C, 0x01FCF, 0x049A4, 0x001A6, 0x00BBC, 0x1F2D5,
    0x0A048, 0x00AB6, 0x0075A, 0x020C2, 0x03864, 0x0104E,
    0x050A5, 0x01D7B, 0x0A049, 0x1F2D6, 0x024F8, 0x0652B,
    0x1F2D7, 0x03865, 0x025FA, 0x07E4E, 0x014A0, 0x0652C,
    0x029FC, 0x00E5D, 0x00CE5, 0x0288D, 0x0098F, 0x006E9,
    0x0FB2C, 0x0652A, 0x01C52, 0x0104D, 0x0FB2B, 0x0128B,
    0x050A3, 0x07E4D, 0x029FB, 0x00990, 0x01FD0, 0x024F7,
    0x050A4, 0x020C1, 0x01B54, 0x1F2DD, 0x0FB30, 0x0FB2E,
    0x0FB2F, 0x049A6, 0x1F2DF, 0x1F2DE, 0x0288E, 0x029FD,
    0x0FB31, 0x025FD, 0x07E4F, 0x1F2E0, 0x0652E, 0x1F2E2,
    0x1F2E1, 0x0A04D, 0x0128C, 0x03F67, 0x0FB33, 0x0FB32,
    0x01B55, 0x025FC, 0x03F66, 0x0652D, 0x025FB, 0x0083C,
    0x1F2DA, 0x0FB2D, 0x1F2D8, 0x1F2D9, 0x0A04B, 0x050A6,
    0x050A7, 0x024F9, 0x0A04A, 0x0A04C, 0x1F2DC, 0x1F2DB,
    0x049A5, 0x00538, 0x0FB35, 0x0FB34, 0x01147, 0x0051E,
    0x03866, 0x0A04F, 0x1F2E7, 0x024FA, 0x002BC, 0x1F2E8,
    0x0FB36, 0x00DE4, 0x01555, 0x050AA, 0x1F2E9, 0x0FB37,
    0x0288F, 0x01FD2, 0x1F2EA, 0x0FB38, 0x032D0, 0x0652F,
    0x1F2E3, 0x020C3, 0x01FD1, 0x025FE, 0x03F68, 0x0A04E,
    0x06530, 0x01769, 0x01D7C, 0x1F2E4, 0x050A8, 0x00ED4,
    0x0099F, 0x050A9, 0x1F2E6, 0x1F2E5, 0x06531, 0x00F5F,
    0x0FB20, 0x0FB1F, 0x006B4, 0x0067C, 0x029F1, 0x1F2C2,
    0x1F2C1, 0x032CB, 0x0149E, 0x0509E, 0x1F2C3, 0x00A6A,
    0x00E5B, 0x025F4, 0x0FB21, 0x1F2C4, 0x1F2C5, 0x02883,
    0x0651F, 0x0FB22, 0x03F61, 0x0509C, 0x04998, 0x0FB1D,
    0x07E42, 0x0175D, 0x0107A, 0x0A03D, 0x07E43, 0x04999,
    0x01B50, 0x0509D, 0x0651E, 0x0104A, 0x0137C, 0x0499A,
    0x0FB1E, 0x1F2C0, 0x07E44, 0x0385C, 0x07E45, 0x0A040,
    0x1F2CA, 0x1F2CB, 0x032CC, 0x1F2CD, 0x1F2CC, 0x0385D,
    0x02884, 0x06523, 0x03F63, 0x1F2CE, 0x0FB24, 0x0FB25,
    0x1F2D1, 0x1F2CF, 0x1F2D0, 0x00F70, 0x07E46, 0x0FB26,
    0x1F2D2, 0x0499C, 0x03F62, 0x0095E, 0x01C4D, 0x0499B,
    0x00BF7, 0x06520, 0x1F2C6, 0x0FB23, 0x0A03E, 0x0A03F,
    0x1F2C7, 0x025F5, 0x0385B, 0x06521, 0x0509F, 0x1F2C9,
    0x1F2C8, 0x06522, 0x00AF9, 0x0A042, 0x0FB27, 0x00A56,
    0x006DE, 0x029F2, 0x029F3, 0x032CD, 0x032CE, 0x02886,
    0x0385E, 0x07E48, 0x0175F, 0x050A0, 0x0FB29, 0x01C4F,
    0x029F4, 0x0FB28, 0x01553, 0x0A043, 0x025F6, 0x01314,
    0x006FC, 0x0098E, 0x02885, 0x01552, 0x0A041, 0x06525,
    0x0128A, 0x020BD, 0x06524, 0x01C4E, 0x07E47, 0x0499D,
    0x00CE2, 0x0071A, 0x06526, 0x01FCE, 0x0175E, 0x024F6,
    0x00046, 0x009E2, 0x01C50, 0x00DB7, 0x00BB9, 0x00188,
    0x06527, 0x0499E, 0x0017C, 0x00D2F, 0x025F7, 0x00BBA,
    0x00DB8, 0x02887, 0x049A1, 0x06528, 0x0499F, 0x049A0,
    0x0104C, 0x020BF, 0x0FB2A, 0x029F8, 0x025F8, 0x00A31,
    0x0051C, 0x01554, 0x029F5, 0x00BFC, 0x032CF, 0x0A044,
    0x0385F, 0x029F6, 0x00AB2, 0x020BE, 0x00E5C, 0x00A57,
    0x00D2E, 0x001AC, 0x029F7, 0x03860, 0x00125,
};

static const uint8_t on2avc_cb7_bits[ON2AVC_CB7_CODES] = {
     1,  8,  8,  8,  8,  7,
    10, 11,  7, 11, 12, 10,
    10, 12, 14, 14, 15, 14,
    11, 11, 13, 13, 12, 10,
    11, 13, 12, 12, 14, 14,
    14, 13, 11, 12,  9, 10,
    12,  7, 11, 11,  7,  7,
    11, 12,  7,  7, 10,  9,
    11, 11, 11, 13, 13, 12,
    14, 15, 11, 12, 14, 12,
    13, 12, 12, 12, 12, 11,
    11, 15, 15, 10, 12, 15,
    12, 12, 14, 11,  7, 10,
     8, 11, 11, 11, 16, 13,
    12, 14, 12, 16, 15, 12,
    13, 14, 14, 12, 14, 17,
    15, 16, 16, 12, 14, 16,
    14, 12, 12, 13, 16, 14,
    12, 17, 16, 16, 15, 13,
    13, 14, 12, 14, 12, 16,
    16, 12, 16, 17, 16, 17,
    15, 16, 16, 15, 17, 15,
    17, 17, 16, 17, 16, 15,
    14, 16, 14, 16, 14, 11,
    14, 16, 15, 11, 17, 17,
    15, 13, 17, 16, 17, 17,
    15, 14, 17, 15, 14, 16,
    11, 16, 17, 16, 14, 12,
    17, 15, 12, 13, 15, 17,
    16, 13, 15, 17, 16, 13,
    15, 16, 17, 15, 13, 14,
    16, 17, 17, 14, 14, 16,
    16, 13, 12, 15, 17, 16,
    14, 11, 15, 15, 12, 10,
    14, 16, 16, 16, 12, 15,
    16, 12, 12, 13, 15, 17,
    14, 12, 15, 17, 14, 14,
    15, 16, 16, 16, 16, 16,
    16, 16, 16, 12, 16, 17,
    14, 11, 13, 15, 17, 15,
    12, 14, 16, 11, 14, 17,
    17, 14, 15, 17, 14, 17,
    16, 15, 17, 15, 14, 17,
    15, 14, 17, 17, 12, 15,
    16, 14, 12, 13, 16, 13,
    16, 16, 15, 16, 16, 16,
    17, 17, 16, 14, 16, 14,
    17, 17, 11, 14, 12, 13,
    15, 12, 14, 15, 12, 13,
    14, 12, 13, 14, 14, 16,
    17, 15, 11, 12, 14, 15,
    13, 12, 12, 14, 14, 13,
    15, 17, 16, 16, 14, 14,
    13, 13, 14, 12, 16, 17,
    12,  7, 12, 12,  7,  7,
    11, 11,  8, 10, 11, 13,
    13, 11, 15, 14, 12, 10,
    14, 11, 11, 13, 12, 11,
    12, 13, 12, 15, 14, 12,
    11, 14, 11, 15, 13, 11,
     7, 11, 11,  9, 10,  7,
    13, 14,  7,  7, 12, 12,
    12, 11, 12, 17, 14, 12,
    14, 16, 14, 14, 14, 11,
    12, 12, 11, 13, 15, 14,
    13, 15, 16, 14, 14, 15,
    12, 14, 14, 12,  7, 11,
    12, 12, 11,  7, 12, 13,
    13, 12,  9, 14, 14,  9,
    12, 12, 12, 13, 13, 14,
    15, 14, 14, 12, 11, 14,
    13, 11, 12, 13, 14, 14,
    13, 15, 15, 16, 14, 12,
    14, 12, 12, 14,  9, 14,
    13,  9, 12, 17, 15, 12,
    12, 14, 13, 13, 13, 13,
    14, 16, 13, 16, 15, 12,
    14, 16, 13, 14, 12, 11,
    13, 17, 15, 13, 15, 17,
    15, 13, 15, 13, 15, 17,
    13, 11, 14, 15, 13, 13,
    14, 17, 17, 17, 16, 14,
    17, 16, 15, 16, 17, 16,
    14, 15, 17, 15, 17, 16,
    14, 14, 14, 15, 12, 13,
    14, 17, 16, 14, 16, 17,
    17, 17, 14, 17, 17, 15,
    17, 15, 17, 16, 16, 11,
    17, 16, 12, 12, 17, 17,
    15, 15, 14, 17, 14, 13,
    14, 16, 16, 15, 13, 14,
    16, 14, 13, 14, 15, 17,
    14, 12, 14, 17, 16, 14,
    12, 16, 14, 13, 11, 15,
    17, 16, 13, 12, 15, 17,
    10, 12, 13, 16, 17, 14,
    13, 14, 15, 12, 13, 14,
    15, 17, 14, 14, 16, 15,
    14, 14, 17, 17, 14, 13,
    14, 16, 17, 15, 13, 15,
    15, 12, 11, 14, 17, 16,
    14, 13, 16, 15, 17, 16,
    15, 17, 16, 15, 15, 17,
    15, 16, 17, 16, 17, 17,
    17, 13, 12, 14, 17, 14,
    13, 15, 14, 17, 14, 14,
    16, 15, 16, 14, 15, 14,
    15, 17, 14, 17, 17, 15,
    12, 17, 17, 12, 12, 14,
    13, 14, 13, 14, 16, 15,
    13, 15, 17, 13, 13, 14,
    11, 13, 14, 13, 12, 14,
    15, 13, 17, 15, 14, 15,
    16, 13, 16, 16, 14, 12,
    14, 13, 14, 14,  7, 12,
    13, 12, 12,  9, 14, 14,
     9, 12, 14, 12, 12, 12,
    14, 15, 15, 15, 11, 11,
    13, 13, 12, 12, 13, 15,
    14, 14, 15, 16, 15, 15,
    12, 14, 12, 13, 14,  9,
    14, 13,  9,  8, 15, 15,
    15, 15, 12, 16, 16, 12,
    14, 15, 15, 15, 16, 17,
    17, 17, 17, 16, 15, 15,
    17, 15, 14, 15, 17, 16,
    15, 15, 17, 17, 16, 13,
    15, 15, 15, 15, 12, 15,
    16, 11, 12, 17, 16, 11,
    11, 15, 15, 15, 14, 14,
    15, 17, 14, 17, 15, 16,
    16, 16, 14, 17, 15, 15,
    13, 16, 15, 14, 15, 16,
    17, 15, 16, 14, 15, 16,
    13, 11, 14, 15, 16, 14,
    12, 16, 16, 16, 14, 12,
    16, 17, 13, 14, 13, 16,
    17, 16, 15, 15, 17, 17,
    14, 15, 15, 15, 15, 12,
    14, 17, 16, 15, 15, 17,
    17, 17, 15, 16, 16, 14,
    16, 13, 17, 16, 14, 15,
    16, 17, 15, 16, 16, 17,
    15, 16, 14, 17, 17, 16,
    16, 14, 15, 17, 17, 15,
    14, 14, 15, 13, 16, 17,
    14, 16, 17, 16, 16, 16,
    16, 17, 17, 16, 14, 17,
    16, 15, 16, 11, 17, 17,
    16, 16, 13, 17, 16, 14,
    14, 16, 17, 15, 15, 13,
    16, 15, 15, 15, 16, 15,
    16, 15, 12, 15, 17, 16,
    15, 12, 15, 16, 13, 12,
    15, 16, 17, 14, 11, 17,
    16, 13, 12, 15, 17, 17,
    15, 13, 16, 15, 12, 13,
    15, 17, 17, 14, 15, 17,
    15, 14, 17, 15, 17, 17,
    16, 12, 17, 17, 17, 16,
    14, 15, 17, 11, 13, 15,
    17, 16, 15, 12, 17, 17,
    11, 15, 17, 17, 16, 14,
    17, 15, 17, 16, 14, 17,
    17, 15, 16, 17, 14, 16,
    17, 14, 17, 16, 15, 14,
    17, 17, 12, 17, 17, 17,
    15, 15, 17, 16, 17, 15,
    14, 17, 14, 16, 17, 12,
    14, 17, 16, 17, 13, 17,
    16, 13, 15, 16, 15, 16,
    14, 15, 17, 17, 15, 14,
    14, 16, 17, 14, 11, 15,
    16, 16, 14, 16, 17, 17,
    15, 14, 15, 15, 15, 15,
    13, 15, 17, 14, 11, 17,
    17, 12, 11, 15, 17, 17,
    15, 14, 17, 16, 14, 17,
    17, 15, 15, 16, 15, 15,
    16, 14, 14, 15, 15, 15,
    16, 17, 15, 15, 16, 14,
    15, 16, 13, 11, 14, 16,
    17, 14, 13, 17, 17, 14,
    12, 16, 16, 17, 16, 17,
    17, 17, 16, 17, 17, 17,
    17, 17, 17, 17, 16, 17,
    17, 17, 17, 17, 17, 17,
    16, 17, 17, 16, 17, 17,
    16, 13, 16, 17, 16, 16,
    11, 17, 17, 17, 16, 15,
    17, 17, 14, 16, 16, 17,
    16, 17, 17, 17, 17, 17,
    17, 16, 16, 17, 15, 15,
    17, 17, 16, 15, 16, 17,
    16, 16, 15, 16, 17, 16,
    14, 13, 17, 17, 13, 15,
    17, 17, 14, 12, 17, 17,
    16, 15, 15, 17, 17, 15,
    17, 16, 17, 16, 17, 17,
    17, 17, 16, 13, 16, 17,
    16, 17, 17, 17, 17, 17,
    16, 17, 15, 16, 13, 16,
    16, 16, 15, 16, 17, 17,
    17, 17, 16, 17, 17, 16,
    17, 16, 16, 16, 15, 16,
    15, 17, 17, 17, 16, 15,
    16, 16, 15, 15, 16, 17,
    16, 17, 17, 17, 17, 16,
    17, 17, 16, 17, 16, 17,
    16, 16, 12, 17, 16, 14,
    13, 16, 17, 17, 15, 14,
    17, 17, 14, 16, 16, 17,
    16, 15, 17, 15, 17, 17,
    14, 17, 17, 15, 13, 14,
    17, 15, 16, 12, 16, 16,
    15, 12, 16, 17, 17, 15,
    14, 16, 17, 12, 12, 16,
    16, 16, 17, 14, 16, 16,
    13, 15, 16, 17, 17, 15,
    15, 16, 16, 16, 15, 17,
    17, 14, 14, 15, 17, 17,
    15, 14, 17, 15, 12, 12,
    14, 17, 17, 15, 14, 17,
    17, 17, 17, 15, 16, 17,
    15, 17, 16, 17, 15, 17,
    17, 16, 16, 16, 15, 16,
    17, 17, 15, 15, 16, 17,
    17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 15,
    17, 17, 15, 14, 17, 17,
    14, 14, 16, 16, 17, 16,
    16, 17, 16, 15, 17, 17,
    16, 16, 17, 16, 16, 17,
    15, 15, 17, 17, 15, 17,
    17, 15, 15, 16, 16, 16,
    17, 15, 13, 17, 17, 17,
    17, 11, 16, 17, 17, 16,
    14, 17, 17, 14, 16, 17,
    17, 15, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 16,
    14, 16, 17, 16, 16, 17,
    16, 17, 16, 17, 16, 17,
    17, 17, 15, 16, 17, 15,
     9, 17, 17, 17, 16, 12,
    17, 17, 13, 15, 15, 17,
    17, 16, 16, 17, 17, 16,
    16, 17, 17, 17, 17, 16,
    17, 17, 17, 16, 15, 17,
    17, 16, 13, 17, 17, 17,
    15, 13, 17, 17, 13, 12,
    17, 17, 12,  9, 15, 17,
    17, 15, 14, 17, 17, 15,
    16, 17, 17, 16, 16, 17,
    17, 17, 16, 17, 17, 17,
    17, 14, 17, 17, 17, 16,
    14, 17, 17, 13, 11, 16,
    17, 17, 14, 10, 16, 17,
    17, 16, 12, 16, 17, 12,
    14, 16, 17, 17, 15, 16,
    17, 17, 16, 17, 17, 17,
    17, 17, 15, 17, 17, 17,
    17, 14, 16, 17, 15, 12,
    15, 16, 17, 15, 11, 17,
    17, 12, 13, 17, 17, 14,
    10, 16, 17, 17, 16, 13,
    16, 16, 14, 17, 15, 17,
    17, 17, 17, 17, 17, 17,
    15, 17, 16, 16, 15, 17,
    17, 17, 15, 13, 17, 16,
    14, 11, 16, 17, 17, 15,
    11, 16, 17, 17, 16, 12,
    17, 16, 14, 14, 17, 17,
    17, 16, 13, 16, 17, 15,
    17, 17, 17, 17, 17, 17,
    16, 17, 17, 17, 14, 16,
    17, 16, 15, 16, 17, 17,
    15, 12, 17, 16, 14, 11,
    17, 17, 17, 15, 14, 17,
    17, 14, 15, 17, 16, 17,
    17, 17, 16, 16, 17, 17,
    17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17,
    14, 14, 17, 17, 17, 17,
    14, 17, 17, 12, 14, 17,
    17, 14, 11, 16, 17, 17,
    15, 15, 16, 17, 13, 17,
    16, 17, 17, 15, 17, 17,
    17, 16, 16, 17, 16, 14,
    15, 16, 17, 17, 15, 15,
    17, 17, 13, 11, 15, 17,
    17, 16, 10, 16, 16, 17,
    16, 12, 17, 17, 12, 14,
    15, 17, 17, 15, 16, 17,
    15, 15, 17, 16, 17, 16,
    16, 15, 16, 17, 17, 16,
    15, 17, 17, 14, 13, 14,
    16, 17, 14, 12, 17, 16,
    13, 12, 16, 17, 13,  9,
    15, 17, 17, 16, 15, 17,
    17, 14, 16, 16, 17, 17,
    16, 16, 17, 17, 17, 15,
    17, 16, 16, 15, 16, 17,
    17, 15, 13, 17, 17, 14,
    11, 15, 17, 17, 15,  9,
    16, 17, 17, 15, 12, 17,
    16, 13, 14, 17, 17, 17,
    16, 16, 17, 17, 15, 16,
    17, 17, 16, 17, 17, 17,
    17, 17, 17, 17, 17, 16,
    16, 15, 17, 17, 17, 15,
    12, 17, 16, 12, 12, 16,
    17, 12, 10, 17, 17, 17,
    14, 14, 17, 17, 14, 14,
    16, 17, 17, 15, 16, 17,
    17, 17, 16, 17, 16, 17,
    14, 17, 17, 17, 16, 13,
    17, 17, 14,  9, 15, 17,
    17, 15, 10, 15, 17, 17,
    15, 12, 17, 17, 13, 13,
    16, 17, 17, 15, 14, 17,
    17, 14, 17, 16, 16, 17,
    17, 17, 17, 17, 17, 17,
    15, 17, 16, 15, 14, 15,
    17, 17, 16, 12, 16, 17,
    12, 13, 17, 17, 13, 11,
    17, 17, 17, 16, 12, 16,
    17, 15, 15, 15, 17, 17,
    17, 16, 16, 17, 16, 16,
    17, 17, 16, 16, 15, 17,
    17, 16, 13, 15, 17, 14,
    11, 15, 17, 16, 15, 12,
    17, 17, 16, 17, 12, 17,
    17, 15, 14, 16, 17, 17,
    15, 15, 17, 17, 15, 15,
    17, 17, 17, 16, 17, 17,
    17, 17, 17, 16, 15, 16,
    17, 14, 15, 16, 17, 17,
    15, 17, 17, 13, 12, 17,
    17, 17, 16, 14, 17, 17,
    12, 15, 15, 17, 17, 16,
    15, 17, 17, 14, 16, 17,
    17, 17, 17, 17, 17, 17,
    16, 15, 15, 17, 15, 15,
    14, 15, 17, 17, 15, 13,
    17, 17, 14, 14, 17, 17,
    14, 10, 16, 17, 17, 15,
    14, 17, 17, 13, 15, 16,
    17, 17, 15, 17, 16, 17,
    15, 17, 16, 17, 17, 15,
    16, 17, 17, 14, 14, 17,
    16, 12, 10, 16, 17, 17,
    15, 10, 16, 17, 17, 15,
    12, 17, 17, 13, 13, 15,
    17, 17, 15, 15, 17, 17,
    13, 14, 17, 17, 17, 16,
    17, 17, 17, 17, 17, 15,
    17, 16, 16, 13, 17, 16,
    17, 17, 12, 17, 17, 12,
    13, 17, 17, 12, 11, 15,
    16, 17, 17, 13, 16, 16,
    14, 14, 15, 17, 17, 16,
    16, 17, 17, 16, 17, 17,
    17, 17, 15, 17, 17, 17,
    16, 15, 17, 17, 14,  9,
    17, 17, 17, 15, 15, 17,
    17, 14, 13, 16, 17, 16,
    16, 16, 17, 17, 16, 16,
    16, 17, 17, 16, 16, 16,
    17, 16, 16, 17, 17, 17,
    17, 17, 17, 17, 16, 17,
    16, 17, 17, 12, 16, 17,
    17, 17, 10, 17, 16, 17,
    17, 13, 17, 17, 14, 16,
    17, 17, 15, 17, 17, 17,
    17, 17, 13, 16, 17, 16,
    15, 16, 15, 17, 16, 15,
    17, 17, 17, 17, 15, 16,
    16, 15, 16, 14, 17, 17,
    13, 15, 17, 17, 15, 13,
    17, 15, 17, 17, 15, 17,
    16, 15, 17, 16, 17, 17,
    16, 13, 16, 17, 15, 17,
    17, 17, 17, 17, 16, 17,
    16, 17, 15, 16, 17, 15,
    13, 16, 16, 16, 16, 14,
    17, 17, 17, 16, 15, 17,
    16, 17, 16, 16, 17, 15,
    17, 16, 17, 16, 17, 14,
    15, 17, 17, 17, 16, 16,
    16, 17, 17, 17, 16, 17,
    17, 16, 17, 17, 16, 17,
    16, 17, 17, 14, 13, 17,
    17, 14, 12, 17, 17, 17,
    15, 12, 17, 16, 15, 15,
    15, 17, 17, 17, 14, 16,
    17, 16, 16, 16, 17, 17,
    17, 15, 17, 17, 17, 14,
    16, 15, 14, 13, 14, 17,
    17, 17, 15, 16, 17, 12,
    13, 15, 17, 17, 16, 14,
    16, 16, 12, 14, 16, 16,
    17, 15, 16, 17, 16, 13,
    16, 16, 16, 17, 15, 15,
    16, 17, 14, 14, 17, 17,
    13, 12, 15, 17, 17, 15,
    14, 16, 16, 17, 17, 15,
    17, 17, 17, 16, 16, 17,
    16, 16, 17, 17, 17, 17,
    15, 16, 17, 17, 16, 16,
    16, 17, 15, 17, 17, 17,
    15, 16, 16, 17, 17, 16,
    16, 15, 17, 17, 15, 14,
    17, 17, 14, 14, 16, 17,
    17, 17, 15, 16, 17, 16,
    17, 16, 16, 17, 17, 16,
    15, 16, 15, 16, 17, 17,
    15, 17, 17, 16, 16, 16,
    15, 17, 17, 15, 12, 16,
    17, 17, 16, 11, 17, 17,
    16, 16, 14, 16, 17, 14,
    16, 16, 17, 16, 15, 17,
    17, 17, 16, 15, 15, 17,
    17, 17, 17, 17, 17, 17,
    16, 17, 17, 17, 16, 14,
    17, 16, 17, 16, 13, 17,
    17, 13,  8, 15, 15, 15,
    14, 12, 16, 17, 12, 13,
    15, 15, 16, 16, 16, 17,
    17, 16, 12, 15, 17, 15,
    16, 14, 15, 16, 17, 16,
    17, 17, 17, 17, 15, 16,
    15, 15, 15, 12, 16, 17,
    12, 11, 17, 17, 11, 11,
    14, 15, 15, 13, 13, 16,
    15, 13, 16, 15, 16, 17,
    15, 13, 15, 15, 15, 15,
    15, 16, 14, 17, 17, 14,
    17, 17, 14, 16, 17, 14,
    11, 14, 14, 16, 14, 12,
    16, 15, 16, 15, 13, 15,
    16, 13, 14, 15, 15, 15,
    15, 15, 16, 17, 17, 11,
    14, 17, 16, 14, 15, 16,
    16, 16, 15, 16, 15, 17,
    16, 15, 14, 16, 16, 16,
    13, 17, 17, 13, 15, 17,
    17, 15, 15, 17, 17, 16,
    16, 15, 17, 17, 15, 16,
    17, 17, 15, 17, 13, 14,
    16, 14, 16, 15, 15, 14,
    16, 17, 15, 16, 16, 15,
    17, 17, 16, 15, 16, 16,
    16, 15, 10, 16, 17, 17,
    15, 11, 16, 17, 12, 13,
    14, 17, 15, 15, 12, 17,
    15, 14, 12, 15, 17, 17,
    15, 15, 16, 17, 17, 16,
    14, 15, 15, 15, 14, 15,
    16, 15, 15, 12, 17, 15,
    13, 11, 16, 17, 17, 16,
    13, 16, 17, 11, 12, 15,
    16, 17, 14, 14, 15, 17,
    11, 13, 17, 17, 17, 15,
    17, 16, 15, 16, 14, 16,
    16, 17, 14, 13, 14, 16,
    17, 14, 14, 15, 16, 12,
    15, 17, 17, 16, 14, 17,
    16, 17, 17, 16, 17, 17,
    15, 16, 17, 15, 15, 17,
    14, 15, 15, 13, 15, 15,
    15, 16, 17, 17, 16, 15,
    14, 17, 17, 17, 15, 14,
    16, 17, 17, 17, 11, 14,
    14, 16, 17, 14, 15, 16,
    14, 13, 15, 14, 17, 16,
    15, 16, 17, 17, 11, 15,
    17, 17, 14, 14, 16, 16,
    16, 14, 17, 17, 15, 16,
    14, 15, 17, 16, 13, 13,
    16, 16, 12, 11, 17, 17,
    12, 11, 14, 16, 17, 15,
    14, 16, 17, 13, 15, 16,
    15, 16, 16, 15, 15, 15,
    13, 14, 15, 15, 16, 17,
    17, 15, 15, 16, 15, 16,
    16, 13, 10, 16, 15, 15,
    15,  7, 14, 14,  7,  7,
    11, 12, 12, 11, 12, 14,
    14, 12, 15, 16, 13, 14,
    16, 13, 13, 15, 13, 11,
    12, 13, 11, 15, 15, 13,
    12, 15, 12, 14, 15, 12,
     7, 12, 12, 12, 11,  6,
    12, 12, 13, 12,  9, 14,
    14,  9, 12, 13, 13, 12,
    14, 15, 16, 17, 14, 12,
    13, 13, 15, 13, 11, 12,
    14, 12, 11, 14, 15, 17,
    14, 12, 13, 12, 13, 14,
     9, 13, 15,  9, 12, 17,
    16, 12, 11, 14, 14, 13,
    15, 13, 16, 17, 14, 15,
    17, 14, 14, 15, 13, 15,
    14, 12, 12, 14, 12, 11,
    16, 15, 13, 13, 16, 13,
    15, 15, 14, 12, 13, 14,
    15, 14, 13, 17, 16, 16,
    16, 15, 17, 17, 14, 14,
    16, 14, 15, 17, 15, 17,
    17, 16, 13, 14, 16, 16,
    13, 14, 14, 15, 14, 12,
    17, 16, 17, 17, 16, 15,
    15, 14, 16, 16, 17, 17,
    15, 11, 16, 16, 13, 11,
    14, 16, 17, 14, 10, 17,
    16, 12, 13, 15, 17, 16,
    14, 13, 17, 16, 14, 15,
    17, 14, 13, 14, 14, 16,
    15, 13, 13, 17, 15, 12,
    12, 15, 17, 17, 15, 12,
    16, 16, 11, 11, 14, 17,
    17, 14, 13, 15, 17, 12,
    12, 14, 16, 17, 17, 14,
    15, 16, 14, 15, 15, 16,
    15, 13, 13, 16, 15, 15,
    13, 15, 15, 13, 13, 15,
    16, 17, 15, 14, 15, 16,
    17, 17, 14, 17, 17, 14,
    14, 15, 14, 17, 16, 16,
    17, 17, 17, 12, 15, 16,
    17, 15, 14, 12, 13, 15,
    12, 15, 17, 16, 16, 16,
    17, 14, 14, 15, 15, 17,
    17, 15, 12, 16, 16, 12,
    11, 14, 14, 14, 14, 14,
    14, 15, 13, 15, 16, 13,
    14, 16, 13, 16, 14, 13,
    11, 12, 14, 13, 16, 15,
    13, 14, 15, 13, 15, 15,
    12, 11, 15, 13, 13, 14,
     7, 12, 13, 12, 12,  9,
    15, 15,  9, 12, 14, 12,
    12, 14, 15, 15, 15, 15,
    13, 14, 16, 14, 14, 12,
    11, 13, 14, 12, 14, 16,
    14, 14, 12, 14, 12, 12,
    12,  9, 14, 14,  9,
};

static const uint16_t on2avc_cb7_syms[ON2AVC_CB7_CODES] = {
    0x0000, 0x0002, 0x0004, 0x000C, 0x000E, 0x0011,
    0x0013, 0x001D, 0x001F, 0x0020, 0x0022, 0x0024,
    0x002C, 0x002E, 0x0031, 0x0033, 0x003D, 0x003F,
    0x0040, 0x0042, 0x0044, 0x004C, 0x004E, 0x00C0,
    0x00C2, 0x00C4, 0x00CC, 0x00CE, 0x00D1, 0x00D3,
    0x00DD, 0x00DF, 0x00E0, 0x00E2, 0x00E4, 0x00EC,
    0x00EE, 0x00F1, 0x00F3, 0x00FD, 0x00FF, 0x0101,
    0x0103, 0x010D, 0x010F, 0x0110, 0x0112, 0x0114,
    0x011C, 0x011E, 0x0121, 0x0123, 0x012D, 0x012F,
    0x0130, 0x0132, 0x0134, 0x013C, 0x013E, 0x0141,
    0x0143, 0x014D, 0x014F, 0x01C1, 0x01C3, 0x01CD,
    0x01CF, 0x01D0, 0x01D2, 0x01D4, 0x01DC, 0x01DE,
    0x01E1, 0x01E3, 0x01ED, 0x01EF, 0x01F0, 0x01F2,
    0x01F4, 0x01FC, 0x01FE, 0x0200, 0x0202, 0x0204,
    0x020C, 0x020E, 0x0211, 0x0213, 0x021D, 0x021F,
    0x0220, 0x0222, 0x0224, 0x022C, 0x022E, 0x0231,
    0x0233, 0x023D, 0x023F, 0x0240, 0x0242, 0x0244,
    0x024C, 0x024E, 0x02C0, 0x02C2, 0x02C4, 0x02CC,
    0x02CE, 0x02D1, 0x02D3, 0x02DD, 0x02DF, 0x02E0,
    0x02E2, 0x02E4, 0x02EC, 0x02EE, 0x02F1, 0x02F3,
    0x02FD, 0x02FF, 0x0301, 0x0303, 0x030D, 0x030F,
    0x0310, 0x0312, 0x0314, 0x031C, 0x031E, 0x0321,
    0x0323, 0x032D, 0x032F, 0x0330, 0x0332, 0x0334,
    0x033C, 0x033E, 0x0341, 0x0343, 0x034D, 0x034F,
    0x03C1, 0x03C3, 0x03CD, 0x03CF, 0x03D0, 0x03D2,
    0x03D4, 0x03DC, 0x03DE, 0x03E1, 0x03E3, 0x03ED,
    0x03EF, 0x03F0, 0x03F2, 0x03F4, 0x03FC, 0x03FE,
    0x0400, 0x0402, 0x0404, 0x040C, 0x040E, 0x0411,
    0x0413, 0x041D, 0x041F, 0x0420, 0x0422, 0x0424,
    0x042C, 0x042E, 0x0431, 0x0433, 0x043D, 0x043F,
    0x0440, 0x0442, 0x0444, 0x044C, 0x044E, 0x04C0,
    0x04C2, 0x04C4, 0x04CC, 0x04CE, 0x04D1, 0x04D3,
    0x04DD, 0x04DF, 0x04E0, 0x04E2, 0x04E4, 0x04EC,
    0x04EE, 0x04F1, 0x04F3, 0x04FD, 0x04FF, 0x0C00,
    0x0C02, 0x0C04, 0x0C0C, 0x0C0E, 0x0C11, 0x0C13,
    0x0C1D, 0x0C1F, 0x0C20, 0x0C22, 0x0C24, 0x0C2C,
    0x0C2E, 0x0C31, 0x0C33, 0x0C3D, 0x0C3F, 0x0C40,
    0x0C42, 0x0C44, 0x0C4C, 0x0C4E, 0x0CC0, 0x0CC2,
    0x0CC4, 0x0CCC, 0x0CCE, 0x0CD1, 0x0CD3, 0x0CDD,
    0x0CDF, 0x0CE0, 0x0CE2, 0x0CE4, 0x0CEC, 0x0CEE,
    0x0CF1, 0x0CF3, 0x0CFD, 0x0CFF, 0x0D01, 0x0D03,
    0x0D0D, 0x0D0F, 0x0D10, 0x0D12, 0x0D14, 0x0D1C,
    0x0D1E, 0x0D21, 0x0D23, 0x0D2D, 0x0D2F, 0x0D30,
    0x0D32, 0x0D34, 0x0D3C, 0x0D3E, 0x0D41, 0x0D43,
    0x0D4D, 0x0D4F, 0x0DC1, 0x0DC3, 0x0DCD, 0x0DCF,
    0x0DD0, 0x0DD2, 0x0DD4, 0x0DDC, 0x0DDE, 0x0DE1,
    0x0DE3, 0x0DED, 0x0DEF, 0x0DF0, 0x0DF2, 0x0DF4,
    0x0DFC, 0x0DFE, 0x0E00, 0x0E02, 0x0E04, 0x0E0C,
    0x0E0E, 0x0E11, 0x0E13, 0x0E1D, 0x0E1F, 0x0E20,
    0x0E22, 0x0E24, 0x0E2C, 0x0E2E, 0x0E31, 0x0E33,
    0x0E3D, 0x0E3F, 0x0E40, 0x0E42, 0x0E44, 0x0E4C,
    0x0E4E, 0x0EC0, 0x0EC2, 0x0EC4, 0x0ECC, 0x0ECE,
    0x0ED1, 0x0ED3, 0x0EDD, 0x0EDF, 0x0EE0, 0x0EE2,
    0x0EE4, 0x0EEC, 0x0EEE, 0x0EF1, 0x0EF3, 0x0EFD,
    0x0EFF, 0x0F01, 0x0F03, 0x0F0D, 0x0F0F, 0x0F10,
    0x0F12, 0x0F14, 0x0F1C, 0x0F1E, 0x0F21, 0x0F23,
    0x0F2D, 0x0F2F, 0x0F30, 0x0F32, 0x0F34, 0x0F3C,
    0x0F3E, 0x0F41, 0x0F43, 0x0F4D, 0x0F4F, 0x0FC1,
    0x0FC3, 0x0FCD, 0x0FCF, 0x0FD0, 0x0FD2, 0x0FD4,
    0x0FDC, 0x0FDE, 0x0FE1, 0x0FE3, 0x0FED, 0x0FEF,
    0x0FF0, 0x0FF2, 0x0FF4, 0x0FFC, 0x0FFE, 0x1001,
    0x1003, 0x100D, 0x100F, 0x1010, 0x1012, 0x1014,
    0x101C, 0x101E, 0x1021, 0x1023, 0x102D, 0x102F,
    0x1030, 0x1032, 0x1034, 0x103C, 0x103E, 0x1041,
    0x1043, 0x104D, 0x104F, 0x10C1, 0x10C3, 0x10CD,
    0x10CF, 0x10D0, 0x10D2, 0x10D4, 0x10DC, 0x10DE,
    0x10E1, 0x10E3, 0x10ED, 0x10EF, 0x10F0, 0x10F2,
    0x10F4, 0x10FC, 0x10FE, 0x1100, 0x1102, 0x1104,
    0x110C, 0x110E, 0x1111, 0x1113, 0x111D, 0x111F,
    0x1120, 0x1122, 0x1124, 0x112C, 0x112E, 0x1131,
    0x1133, 0x113D, 0x113F, 0x1140, 0x1142, 0x1144,
    0x114C, 0x114E, 0x11C0, 0x11C2, 0x11C4, 0x11CC,
    0x11CE, 0x11D1, 0x11D3, 0x11DD, 0x11DF, 0x11E0,
    0x11E2, 0x11E4, 0x11EC, 0x11EE, 0x11F1, 0x11F3,
    0x11FD, 0x11FF, 0x1201, 0x1203, 0x120D, 0x120F,
    0x1210, 0x1212, 0x1214, 0x121C, 0x121E, 0x1221,
    0x1223, 0x122D, 0x122F, 0x1230, 0x1232, 0x1234,
    0x123C, 0x123E, 0x1241, 0x1243, 0x124D, 0x124F,
    0x12C1, 0x12C3, 0x12CD, 0x12CF, 0x12D0, 0x12D2,
    0x12D4, 0x12DC, 0x12DE, 0x12E1, 0x12E3, 0x12ED,
    0x12EF, 0x12F0, 0x12F2, 0x12F4, 0x12FC, 0x12FE,
    0x1300, 0x1302, 0x1304, 0x130C, 0x130E, 0x1311,
    0x1313, 0x131D, 0x131F, 0x1320, 0x1322, 0x1324,
    0x132C, 0x132E, 0x1331, 0x1333, 0x133D, 0x133F,
    0x1340, 0x1342, 0x1344, 0x134C, 0x134E, 0x13C0,
    0x13C2, 0x13C4, 0x13CC, 0x13CE, 0x13D1, 0x13D3,
    0x13DD, 0x13DF, 0x13E0, 0x13E2, 0x13E4, 0x13EC,
    0x13EE, 0x13F1, 0x13F3, 0x13FD, 0x13FF, 0x1401,
    0x1403, 0x140D, 0x140F, 0x1410, 0x1412, 0x1414,
    0x141C, 0x141E, 0x1421, 0x1423, 0x142D, 0x142F,
    0x1430, 0x1432, 0x1434, 0x143C, 0x143E, 0x1441,
    0x1443, 0x144D, 0x144F, 0x14C1, 0x14C3, 0x14CD,
    0x14CF, 0x14D0, 0x14D2, 0x14D4, 0x14DC, 0x14DE,
    0x14E1, 0x14E3, 0x14ED, 0x14EF, 0x14F0, 0x14F2,
    0x14F4, 0x14FC, 0x14FE, 0x1C01, 0x1C03, 0x1C0D,
    0x1C0F, 0x1C10, 0x1C12, 0x1C14, 0x1C1C, 0x1C1E,
    0x1C21, 0x1C23, 0x1C2D, 0x1C2F, 0x1C30, 0x1C32,
    0x1C34, 0x1C3C, 0x1C3E, 0x1C41, 0x1C43, 0x1C4D,
    0x1C4F, 0x1CC1, 0x1CC3, 0x1CCD, 0x1CCF, 0x1CD0,
    0x1CD2, 0x1CD4, 0x1CDC, 0x1CDE, 0x1CE1, 0x1CE3,
    0x1CED, 0x1CEF, 0x1CF0, 0x1CF2, 0x1CF4, 0x1CFC,
    0x1CFE, 0x1D00, 0x1D02, 0x1D04, 0x1D0C, 0x1D0E,
    0x1D11, 0x1D13, 0x1D1D, 0x1D1F, 0x1D20, 0x1D22,
    0x1D24, 0x1D2C, 0x1D2E, 0x1D31, 0x1D33, 0x1D3D,
    0x1D3F, 0x1D40, 0x1D42, 0x1D44, 0x1D4C, 0x1D4E,
    0x1DC0, 0x1DC2, 0x1DC4, 0x1DCC, 0x1DCE, 0x1DD1,
    0x1DD3, 0x1DDD, 0x1DDF, 0x1DE0, 0x1DE2, 0x1DE4,
    0x1DEC, 0x1DEE, 0x1DF1, 0x1DF3, 0x1DFD, 0x1DFF,
    0x1E01, 0x1E03, 0x1E0D, 0x1E0F, 0x1E10, 0x1E12,
    0x1E14, 0x1E1C, 0x1E1E, 0x1E21, 0x1E23, 0x1E2D,
    0x1E2F, 0x1E30, 0x1E32, 0x1E34, 0x1E3C, 0x1E3E,
    0x1E41, 0x1E43, 0x1E4D, 0x1E4F, 0x1EC1, 0x1EC3,
    0x1ECD, 0x1ECF, 0x1ED0, 0x1ED2, 0x1ED4, 0x1EDC,
    0x1EDE, 0x1EE1, 0x1EE3, 0x1EED, 0x1EEF, 0x1EF0,
    0x1EF2, 0x1EF4, 0x1EFC, 0x1EFE, 0x1F00, 0x1F02,
    0x1F04, 0x1F0C, 0x1F0E, 0x1F11, 0x1F13, 0x1F1D,
    0x1F1F, 0x1F20, 0x1F22, 0x1F24, 0x1F2C, 0x1F2E,
    0x1F31, 0x1F33, 0x1F3D, 0x1F3F, 0x1F40, 0x1F42,
    0x1F44, 0x1F4C, 0x1F4E, 0x1FC0, 0x1FC2, 0x1FC4,
    0x1FCC, 0x1FCE, 0x1FD1, 0x1FD3, 0x1FDD, 0x1FDF,
    0x1FE0, 0x1FE2, 0x1FE4, 0x1FEC, 0x1FEE, 0x1FF1,
    0x1FF3, 0x1FFD, 0x1FFF, 0x2000, 0x2002, 0x2004,
    0x200C, 0x200E, 0x2011, 0x2013, 0x201D, 0x201F,
    0x2020, 0x2022, 0x2024, 0x202C, 0x202E, 0x2031,
    0x2033, 0x203D, 0x203F, 0x2040, 0x2042, 0x2044,
    0x204C, 0x204E, 0x20C0, 0x20C2, 0x20C4, 0x20CC,
    0x20CE, 0x20D1, 0x20D3, 0x20DD, 0x20DF, 0x20E0,
    0x20E2, 0x20E4, 0x20EC, 0x20EE, 0x20F1, 0x20F3,
    0x20FD, 0x20FF, 0x2101, 0x2103, 0x210D, 0x210F,
    0x2110, 0x2112, 0x2114, 0x211C, 0x211E, 0x2121,
    0x2123, 0x212D, 0x212F, 0x2130, 0x2132, 0x2134,
    0x213C, 0x213E, 0x2141, 0x2143, 0x214D, 0x214F,
    0x21C1, 0x21C3, 0x21CD, 0x21CF, 0x21D0, 0x21D2,
    0x21D4, 0x21DC, 0x21DE, 0x21E1, 0x21E3, 0x21ED,
    0x21EF, 0x21F0, 0x21F2, 0x21F4, 0x21FC, 0x21FE,
    0x2200, 0x2202, 0x2204, 0x220C, 0x220E, 0x2211,
    0x2213, 0x221D, 0x221F, 0x2220, 0x2222, 0x2224,
    0x222C, 0x222E, 0x2231, 0x2233, 0x223D, 0x223F,
    0x2240, 0x2242, 0x2244, 0x224C, 0x224E, 0x22C0,
    0x22C2, 0x22C4, 0x22CC, 0x22CE, 0x22D1, 0x22D3,
    0x22DD, 0x22DF, 0x22E0, 0x22E2, 0x22E4, 0x22EC,
    0x22EE, 0x22F1, 0x22F3, 0x22FD, 0x22FF, 0x2301,
    0x2303, 0x230D, 0x230F, 0x2310, 0x2312, 0x2314,
    0x231C, 0x231E, 0x2321, 0x2323, 0x232D, 0x232F,
    0x2330, 0x2332, 0x2334, 0x233C, 0x233E, 0x2341,
    0x2343, 0x234D, 0x234F, 0x23C1, 0x23C3, 0x23CD,
    0x23CF, 0x23D0, 0x23D2, 0x23D4, 0x23DC, 0x23DE,
    0x23E1, 0x23E3, 0x23ED, 0x23EF, 0x23F0, 0x23F2,
    0x23F4, 0x23FC, 0x23FE, 0x2400, 0x2402, 0x2404,
    0x240C, 0x240E, 0x2411, 0x2413, 0x241D, 0x241F,
    0x2420, 0x2422, 0x2424, 0x242C, 0x242E, 0x2431,
    0x2433, 0x243D, 0x243F, 0x2440, 0x2442, 0x2444,
    0x244C, 0x244E, 0x24C0, 0x24C2, 0x24C4, 0x24CC,
    0x24CE, 0x24D1, 0x24D3, 0x24DD, 0x24DF, 0x24E0,
    0x24E2, 0x24E4, 0x24EC, 0x24EE, 0x24F1, 0x24F3,
    0x24FD, 0x24FF, 0x2C00, 0x2C02, 0x2C04, 0x2C0C,
    0x2C0E, 0x2C11, 0x2C13, 0x2C1D, 0x2C1F, 0x2C20,
    0x2C22, 0x2C24, 0x2C2C, 0x2C2E, 0x2C31, 0x2C33,
    0x2C3D, 0x2C3F, 0x2C40, 0x2C42, 0x2C44, 0x2C4C,
    0x2C4E, 0x2CC0, 0x2CC2, 0x2CC4, 0x2CCC, 0x2CCE,
    0x2CD1, 0x2CD3, 0x2CDD, 0x2CDF, 0x2CE0, 0x2CE2,
    0x2CE4, 0x2CEC, 0x2CEE, 0x2CF1, 0x2CF3, 0x2CFD,
    0x2CFF, 0x2D01, 0x2D03, 0x2D0D, 0x2D0F, 0x2D10,
    0x2D12, 0x2D14, 0x2D1C, 0x2D1E, 0x2D21, 0x2D23,
    0x2D2D, 0x2D2F, 0x2D30, 0x2D32, 0x2D34, 0x2D3C,
    0x2D3E, 0x2D41, 0x2D43, 0x2D4D, 0x2D4F, 0x2DC1,
    0x2DC3, 0x2DCD, 0x2DCF, 0x2DD0, 0x2DD2, 0x2DD4,
    0x2DDC, 0x2DDE, 0x2DE1, 0x2DE3, 0x2DED, 0x2DEF,
    0x2DF0, 0x2DF2, 0x2DF4, 0x2DFC, 0x2DFE, 0x2E00,
    0x2E02, 0x2E04, 0x2E0C, 0x2E0E, 0x2E11, 0x2E13,
    0x2E1D, 0x2E1F, 0x2E20, 0x2E22, 0x2E24, 0x2E2C,
    0x2E2E, 0x2E31, 0x2E33, 0x2E3D, 0x2E3F, 0x2E40,
    0x2E42, 0x2E44, 0x2E4C, 0x2E4E, 0x2EC0, 0x2EC2,
    0x2EC4, 0x2ECC, 0x2ECE, 0x2ED1, 0x2ED3, 0x2EDD,
    0x2EDF, 0x2EE0, 0x2EE2, 0x2EE4, 0x2EEC, 0x2EEE,
    0x2EF1, 0x2EF3, 0x2EFD, 0x2EFF, 0x2F01, 0x2F03,
    0x2F0D, 0x2F0F, 0x2F10, 0x2F12, 0x2F14, 0x2F1C,
    0x2F1E, 0x2F21, 0x2F23, 0x2F2D, 0x2F2F, 0x2F30,
    0x2F32, 0x2F34, 0x2F3C, 0x2F3E, 0x2F41, 0x2F43,
    0x2F4D, 0x2F4F, 0x2FC1, 0x2FC3, 0x2FCD, 0x2FCF,
    0x2FD0, 0x2FD2, 0x2FD4, 0x2FDC, 0x2FDE, 0x2FE1,
    0x2FE3, 0x2FED, 0x2FEF, 0x2FF0, 0x2FF2, 0x2FF4,
    0x2FFC, 0x2FFE, 0x3001, 0x3003, 0x300D, 0x300F,
    0x3010, 0x3012, 0x3014, 0x301C, 0x301E, 0x3021,
    0x3023, 0x302D, 0x302F, 0x3030, 0x3032, 0x3034,
    0x303C, 0x303E, 0x3041, 0x3043, 0x304D, 0x304F,
    0x30C1, 0x30C3, 0x30CD, 0x30CF, 0x30D0, 0x30D2,
    0x30D4, 0x30DC, 0x30DE, 0x30E1, 0x30E3, 0x30ED,
    0x30EF, 0x30F0, 0x30F2, 0x30F4, 0x30FC, 0x30FE,
    0x3100, 0x3102, 0x3104, 0x310C, 0x310E, 0x3111,
    0x3113, 0x311D, 0x311F, 0x3120, 0x3122, 0x3124,
    0x312C, 0x312E, 0x3131, 0x3133, 0x313D, 0x313F,
    0x3140, 0x3142, 0x3144, 0x314C, 0x314E, 0x31C0,
    0x31C2, 0x31C4, 0x31CC, 0x31CE, 0x31D1, 0x31D3,
    0x31DD, 0x31DF, 0x31E0, 0x31E2, 0x31E4, 0x31EC,
    0x31EE, 0x31F1, 0x31F3, 0x31FD, 0x31FF, 0x3201,
    0x3203, 0x320D, 0x320F, 0x3210, 0x3212, 0x3214,
    0x321C, 0x321E, 0x3221, 0x3223, 0x322D, 0x322F,
    0x3230, 0x3232, 0x3234, 0x323C, 0x323E, 0x3241,
    0x3243, 0x324D, 0x324F, 0x32C1, 0x32C3, 0x32CD,
    0x32CF, 0x32D0, 0x32D2, 0x32D4, 0x32DC, 0x32DE,
    0x32E1, 0x32E3, 0x32ED, 0x32EF, 0x32F0, 0x32F2,
    0x32F4, 0x32FC, 0x32FE, 0x3300, 0x3302, 0x3304,
    0x330C, 0x330E, 0x3311, 0x3313, 0x331D, 0x331F,
    0x3320, 0x3322, 0x3324, 0x332C, 0x332E, 0x3331,
    0x3333, 0x333D, 0x333F, 0x3340, 0x3342, 0x3344,
    0x334C, 0x334E, 0x33C0, 0x33C2, 0x33C4, 0x33CC,
    0x33CE, 0x33D1, 0x33D3, 0x33DD, 0x33DF, 0x33E0,
    0x33E2, 0x33E4, 0x33EC, 0x33EE, 0x33F1, 0x33F3,
    0x33FD, 0x33FF, 0x3401, 0x3403, 0x340D, 0x340F,
    0x3410, 0x3412, 0x3414, 0x341C, 0x341E, 0x3421,
    0x3423, 0x342D, 0x342F, 0x3430, 0x3432, 0x3434,
    0x343C, 0x343E, 0x3441, 0x3443, 0x344D, 0x344F,
    0x34C1, 0x34C3, 0x34CD, 0x34CF, 0x34D0, 0x34D2,
    0x34D4, 0x34DC, 0x34DE, 0x34E1, 0x34E3, 0x34ED,
    0x34EF, 0x34F0, 0x34F2, 0x34F4, 0x34FC, 0x34FE,
    0x3C01, 0x3C03, 0x3C0D, 0x3C0F, 0x3C10, 0x3C12,
    0x3C14, 0x3C1C, 0x3C1E, 0x3C21, 0x3C23, 0x3C2D,
    0x3C2F, 0x3C30, 0x3C32, 0x3C34, 0x3C3C, 0x3C3E,
    0x3C41, 0x3C43, 0x3C4D, 0x3C4F, 0x3CC1, 0x3CC3,
    0x3CCD, 0x3CCF, 0x3CD0, 0x3CD2, 0x3CD4, 0x3CDC,
    0x3CDE, 0x3CE1, 0x3CE3, 0x3CED, 0x3CEF, 0x3CF0,
    0x3CF2, 0x3CF4, 0x3CFC, 0x3CFE, 0x3D00, 0x3D02,
    0x3D04, 0x3D0C, 0x3D0E, 0x3D11, 0x3D13, 0x3D1D,
    0x3D1F, 0x3D20, 0x3D22, 0x3D24, 0x3D2C, 0x3D2E,
    0x3D31, 0x3D33, 0x3D3D, 0x3D3F, 0x3D40, 0x3D42,
    0x3D44, 0x3D4C, 0x3D4E, 0x3DC0, 0x3DC2, 0x3DC4,
    0x3DCC, 0x3DCE, 0x3DD1, 0x3DD3, 0x3DDD, 0x3DDF,
    0x3DE0, 0x3DE2, 0x3DE4, 0x3DEC, 0x3DEE, 0x3DF1,
    0x3DF3, 0x3DFD, 0x3DFF, 0x3E01, 0x3E03, 0x3E0D,
    0x3E0F, 0x3E10, 0x3E12, 0x3E14, 0x3E1C, 0x3E1E,
    0x3E21, 0x3E23, 0x3E2D, 0x3E2F, 0x3E30, 0x3E32,
    0x3E34, 0x3E3C, 0x3E3E, 0x3E41, 0x3E43, 0x3E4D,
    0x3E4F, 0x3EC1, 0x3EC3, 0x3ECD, 0x3ECF, 0x3ED0,
    0x3ED2, 0x3ED4, 0x3EDC, 0x3EDE, 0x3EE1, 0x3EE3,
    0x3EED, 0x3EEF, 0x3EF0, 0x3EF2, 0x3EF4, 0x3EFC,
    0x3EFE, 0x3F00, 0x3F02, 0x3F04, 0x3F0C, 0x3F0E,
    0x3F11, 0x3F13, 0x3F1D, 0x3F1F, 0x3F20, 0x3F22,
    0x3F24, 0x3F2C, 0x3F2E, 0x3F31, 0x3F33, 0x3F3D,
    0x3F3F, 0x3F40, 0x3F42, 0x3F44, 0x3F4C, 0x3F4E,
    0x3FC0, 0x3FC2, 0x3FC4, 0x3FCC, 0x3FCE, 0x3FD1,
    0x3FD3, 0x3FDD, 0x3FDF, 0x3FE0, 0x3FE2, 0x3FE4,
    0x3FEC, 0x3FEE, 0x3FF1, 0x3FF3, 0x3FFD, 0x3FFF,
    0x4000, 0x4002, 0x4004, 0x400C, 0x400E, 0x4011,
    0x4013, 0x401D, 0x401F, 0x4020, 0x4022, 0x4024,
    0x402C, 0x402E, 0x4031, 0x4033, 0x403D, 0x403F,
    0x4040, 0x4042, 0x4044, 0x404C, 0x404E, 0x40C0,
    0x40C2, 0x40C4, 0x40CC, 0x40CE, 0x40D1, 0x40D3,
    0x40DD, 0x40DF, 0x40E0, 0x40E2, 0x40E4, 0x40EC,
    0x40EE, 0x40F1, 0x40F3, 0x40FD, 0x40FF, 0x4101,
    0x4103, 0x410D, 0x410F, 0x4110, 0x4112, 0x4114,
    0x411C, 0x411E, 0x4121, 0x4123, 0x412D, 0x412F,
    0x4130, 0x4132, 0x4134, 0x413C, 0x413E, 0x4141,
    0x4143, 0x414D, 0x414F, 0x41C1, 0x41C3, 0x41CD,
    0x41CF, 0x41D0, 0x41D2, 0x41D4, 0x41DC, 0x41DE,
    0x41E1, 0x41E3, 0x41ED, 0x41EF, 0x41F0, 0x41F2,
    0x41F4, 0x41FC, 0x41FE, 0x4200, 0x4202, 0x4204,
    0x420C, 0x420E, 0x4211, 0x4213, 0x421D, 0x421F,
    0x4220, 0x4222, 0x4224, 0x422C, 0x422E, 0x4231,
    0x4233, 0x423D, 0x423F, 0x4240, 0x4242, 0x4244,
    0x424C, 0x424E, 0x42C0, 0x42C2, 0x42C4, 0x42CC,
    0x42CE, 0x42D1, 0x42D3, 0x42DD, 0x42DF, 0x42E0,
    0x42E2, 0x42E4, 0x42EC, 0x42EE, 0x42F1, 0x42F3,
    0x42FD, 0x42FF, 0x4301, 0x4303, 0x430D, 0x430F,
    0x4310, 0x4312, 0x4314, 0x431C, 0x431E, 0x4321,
    0x4323, 0x432D, 0x432F, 0x4330, 0x4332, 0x4334,
    0x433C, 0x433E, 0x4341, 0x4343, 0x434D, 0x434F,
    0x43C1, 0x43C3, 0x43CD, 0x43CF, 0x43D0, 0x43D2,
    0x43D4, 0x43DC, 0x43DE, 0x43E1, 0x43E3, 0x43ED,
    0x43EF, 0x43F0, 0x43F2, 0x43F4, 0x43FC, 0x43FE,
    0x4400, 0x4402, 0x4404, 0x440C, 0x440E, 0x4411,
    0x4413, 0x441D, 0x441F, 0x4420, 0x4422, 0x4424,
    0x442C, 0x442E, 0x4431, 0x4433, 0x443D, 0x443F,
    0x4440, 0x4442, 0x4444, 0x444C, 0x444E, 0x44C0,
    0x44C2, 0x44C4, 0x44CC, 0x44CE, 0x44D1, 0x44D3,
    0x44DD, 0x44DF, 0x44E0, 0x44E2, 0x44E4, 0x44EC,
    0x44EE, 0x44F1, 0x44F3, 0x44FD, 0x44FF, 0x4C00,
    0x4C02, 0x4C04, 0x4C0C, 0x4C0E, 0x4C11, 0x4C13,
    0x4C1D, 0x4C1F, 0x4C20, 0x4C22, 0x4C24, 0x4C2C,
    0x4C2E, 0x4C31, 0x4C33, 0x4C3D, 0x4C3F, 0x4C40,
    0x4C42, 0x4C44, 0x4C4C, 0x4C4E, 0x4CC0, 0x4CC2,
    0x4CC4, 0x4CCC, 0x4CCE, 0x4CD1, 0x4CD3, 0x4CDD,
    0x4CDF, 0x4CE0, 0x4CE2, 0x4CE4, 0x4CEC, 0x4CEE,
    0x4CF1, 0x4CF3, 0x4CFD, 0x4CFF, 0x4D01, 0x4D03,
    0x4D0D, 0x4D0F, 0x4D10, 0x4D12, 0x4D14, 0x4D1C,
    0x4D1E, 0x4D21, 0x4D23, 0x4D2D, 0x4D2F, 0x4D30,
    0x4D32, 0x4D34, 0x4D3C, 0x4D3E, 0x4D41, 0x4D43,
    0x4D4D, 0x4D4F, 0x4DC1, 0x4DC3, 0x4DCD, 0x4DCF,
    0x4DD0, 0x4DD2, 0x4DD4, 0x4DDC, 0x4DDE, 0x4DE1,
    0x4DE3, 0x4DED, 0x4DEF, 0x4DF0, 0x4DF2, 0x4DF4,
    0x4DFC, 0x4DFE, 0x4E00, 0x4E02, 0x4E04, 0x4E0C,
    0x4E0E, 0x4E11, 0x4E13, 0x4E1D, 0x4E1F, 0x4E20,
    0x4E22, 0x4E24, 0x4E2C, 0x4E2E, 0x4E31, 0x4E33,
    0x4E3D, 0x4E3F, 0x4E40, 0x4E42, 0x4E44, 0x4E4C,
    0x4E4E, 0x4EC0, 0x4EC2, 0x4EC4, 0x4ECC, 0x4ECE,
    0x4ED1, 0x4ED3, 0x4EDD, 0x4EDF, 0x4EE0, 0x4EE2,
    0x4EE4, 0x4EEC, 0x4EEE, 0x4EF1, 0x4EF3, 0x4EFD,
    0x4EFF, 0x4F01, 0x4F03, 0x4F0D, 0x4F0F, 0x4F10,
    0x4F12, 0x4F14, 0x4F1C, 0x4F1E, 0x4F21, 0x4F23,
    0x4F2D, 0x4F2F, 0x4F30, 0x4F32, 0x4F34, 0x4F3C,
    0x4F3E, 0x4F41, 0x4F43, 0x4F4D, 0x4F4F, 0x4FC1,
    0x4FC3, 0x4FCD, 0x4FCF, 0x4FD0, 0x4FD2, 0x4FD4,
    0x4FDC, 0x4FDE, 0x4FE1, 0x4FE3, 0x4FED, 0x4FEF,
    0x4FF0, 0x4FF2, 0x4FF4, 0x4FFC, 0x4FFE, 0xC000,
    0xC002, 0xC004, 0xC00C, 0xC00E, 0xC011, 0xC013,
    0xC01D, 0xC01F, 0xC020, 0xC022, 0xC024, 0xC02C,
    0xC02E, 0xC031, 0xC033, 0xC03D, 0xC03F, 0xC040,
    0xC042, 0xC044, 0xC04C, 0xC04E, 0xC0C0, 0xC0C2,
    0xC0C4, 0xC0CC, 0xC0CE, 0xC0D1, 0xC0D3, 0xC0DD,
    0xC0DF, 0xC0E0, 0xC0E2, 0xC0E4, 0xC0EC, 0xC0EE,
    0xC0F1, 0xC0F3, 0xC0FD, 0xC0FF, 0xC101, 0xC103,
    0xC10D, 0xC10F, 0xC110, 0xC112, 0xC114, 0xC11C,
    0xC11E, 0xC121, 0xC123, 0xC12D, 0xC12F, 0xC130,
    0xC132, 0xC134, 0xC13C, 0xC13E, 0xC141, 0xC143,
    0xC14D, 0xC14F, 0xC1C1, 0xC1C3, 0xC1CD, 0xC1CF,
    0xC1D0, 0xC1D2, 0xC1D4, 0xC1DC, 0xC1DE, 0xC1E1,
    0xC1E3, 0xC1ED, 0xC1EF, 0xC1F0, 0xC1F2, 0xC1F4,
    0xC1FC, 0xC1FE, 0xC200, 0xC202, 0xC204, 0xC20C,
    0xC20E, 0xC211, 0xC213, 0xC21D, 0xC21F, 0xC220,
    0xC222, 0xC224, 0xC22C, 0xC22E, 0xC231, 0xC233,
    0xC23D, 0xC23F, 0xC240, 0xC242, 0xC244, 0xC24C,
    0xC24E, 0xC2C0, 0xC2C2, 0xC2C4, 0xC2CC, 0xC2CE,
    0xC2D1, 0xC2D3, 0xC2DD, 0xC2DF, 0xC2E0, 0xC2E2,
    0xC2E4, 0xC2EC, 0xC2EE, 0xC2F1, 0xC2F3, 0xC2FD,
    0xC2FF, 0xC301, 0xC303, 0xC30D, 0xC30F, 0xC310,
    0xC312, 0xC314, 0xC31C, 0xC31E, 0xC321, 0xC323,
    0xC32D, 0xC32F, 0xC330, 0xC332, 0xC334, 0xC33C,
    0xC33E, 0xC341, 0xC343, 0xC34D, 0xC34F, 0xC3C1,
    0xC3C3, 0xC3CD, 0xC3CF, 0xC3D0, 0xC3D2, 0xC3D4,
    0xC3DC, 0xC3DE, 0xC3E1, 0xC3E3, 0xC3ED, 0xC3EF,
    0xC3F0, 0xC3F2, 0xC3F4, 0xC3FC, 0xC3FE, 0xC400,
    0xC402, 0xC404, 0xC40C, 0xC40E, 0xC411, 0xC413,
    0xC41D, 0xC41F, 0xC420, 0xC422, 0xC424, 0xC42C,
    0xC42E, 0xC431, 0xC433, 0xC43D, 0xC43F, 0xC440,
    0xC442, 0xC444, 0xC44C, 0xC44E, 0xC4C0, 0xC4C2,
    0xC4C4, 0xC4CC, 0xC4CE, 0xC4D1, 0xC4D3, 0xC4DD,
    0xC4DF, 0xC4E0, 0xC4E2, 0xC4E4, 0xC4EC, 0xC4EE,
    0xC4F1, 0xC4F3, 0xC4FD, 0xC4FF, 0xCC00, 0xCC02,
    0xCC04, 0xCC0C, 0xCC0E, 0xCC11, 0xCC13, 0xCC1D,
    0xCC1F, 0xCC20, 0xCC22, 0xCC24, 0xCC2C, 0xCC2E,
    0xCC31, 0xCC33, 0xCC3D, 0xCC3F, 0xCC40, 0xCC42,
    0xCC44, 0xCC4C, 0xCC4E, 0xCCC0, 0xCCC2, 0xCCC4,
    0xCCCC, 0xCCCE, 0xCCD1, 0xCCD3, 0xCCDD, 0xCCDF,
    0xCCE0, 0xCCE2, 0xCCE4, 0xCCEC, 0xCCEE, 0xCCF1,
    0xCCF3, 0xCCFD, 0xCCFF, 0xCD01, 0xCD03, 0xCD0D,
    0xCD0F, 0xCD10, 0xCD12, 0xCD14, 0xCD1C, 0xCD1E,
    0xCD21, 0xCD23, 0xCD2D, 0xCD2F, 0xCD30, 0xCD32,
    0xCD34, 0xCD3C, 0xCD3E, 0xCD41, 0xCD43, 0xCD4D,
    0xCD4F, 0xCDC1, 0xCDC3, 0xCDCD, 0xCDCF, 0xCDD0,
    0xCDD2, 0xCDD4, 0xCDDC, 0xCDDE, 0xCDE1, 0xCDE3,
    0xCDED, 0xCDEF, 0xCDF0, 0xCDF2, 0xCDF4, 0xCDFC,
    0xCDFE, 0xCE00, 0xCE02, 0xCE04, 0xCE0C, 0xCE0E,
    0xCE11, 0xCE13, 0xCE1D, 0xCE1F, 0xCE20, 0xCE22,
    0xCE24, 0xCE2C, 0xCE2E, 0xCE31, 0xCE33, 0xCE3D,
    0xCE3F, 0xCE40, 0xCE42, 0xCE44, 0xCE4C, 0xCE4E,
    0xCEC0, 0xCEC2, 0xCEC4, 0xCECC, 0xCECE, 0xCED1,
    0xCED3, 0xCEDD, 0xCEDF, 0xCEE0, 0xCEE2, 0xCEE4,
    0xCEEC, 0xCEEE, 0xCEF1, 0xCEF3, 0xCEFD, 0xCEFF,
    0xCF01, 0xCF03, 0xCF0D, 0xCF0F, 0xCF10, 0xCF12,
    0xCF14, 0xCF1C, 0xCF1E, 0xCF21, 0xCF23, 0xCF2D,
    0xCF2F, 0xCF30, 0xCF32, 0xCF34, 0xCF3C, 0xCF3E,
    0xCF41, 0xCF43, 0xCF4D, 0xCF4F, 0xCFC1, 0xCFC3,
    0xCFCD, 0xCFCF, 0xCFD0, 0xCFD2, 0xCFD4, 0xCFDC,
    0xCFDE, 0xCFE1, 0xCFE3, 0xCFED, 0xCFEF, 0xCFF0,
    0xCFF2, 0xCFF4, 0xCFFC, 0xCFFE, 0xD001, 0xD003,
    0xD00D, 0xD00F, 0xD010, 0xD012, 0xD014, 0xD01C,
    0xD01E, 0xD021, 0xD023, 0xD02D, 0xD02F, 0xD030,
    0xD032, 0xD034, 0xD03C, 0xD03E, 0xD041, 0xD043,
    0xD04D, 0xD04F, 0xD0C1, 0xD0C3, 0xD0CD, 0xD0CF,
    0xD0D0, 0xD0D2, 0xD0D4, 0xD0DC, 0xD0DE, 0xD0E1,
    0xD0E3, 0xD0ED, 0xD0EF, 0xD0F0, 0xD0F2, 0xD0F4,
    0xD0FC, 0xD0FE, 0xD100, 0xD102, 0xD104, 0xD10C,
    0xD10E, 0xD111, 0xD113, 0xD11D, 0xD11F, 0xD120,
    0xD122, 0xD124, 0xD12C, 0xD12E, 0xD131, 0xD133,
    0xD13D, 0xD13F, 0xD140, 0xD142, 0xD144, 0xD14C,
    0xD14E, 0xD1C0, 0xD1C2, 0xD1C4, 0xD1CC, 0xD1CE,
    0xD1D1, 0xD1D3, 0xD1DD, 0xD1DF, 0xD1E0, 0xD1E2,
    0xD1E4, 0xD1EC, 0xD1EE, 0xD1F1, 0xD1F3, 0xD1FD,
    0xD1FF, 0xD201, 0xD203, 0xD20D, 0xD20F, 0xD210,
    0xD212, 0xD214, 0xD21C, 0xD21E, 0xD221, 0xD223,
    0xD22D, 0xD22F, 0xD230, 0xD232, 0xD234, 0xD23C,
    0xD23E, 0xD241, 0xD243, 0xD24D, 0xD24F, 0xD2C1,
    0xD2C3, 0xD2CD, 0xD2CF, 0xD2D0, 0xD2D2, 0xD2D4,
    0xD2DC, 0xD2DE, 0xD2E1, 0xD2E3, 0xD2ED, 0xD2EF,
    0xD2F0, 0xD2F2, 0xD2F4, 0xD2FC, 0xD2FE, 0xD300,
    0xD302, 0xD304, 0xD30C, 0xD30E, 0xD311, 0xD313,
    0xD31D, 0xD31F, 0xD320, 0xD322, 0xD324, 0xD32C,
    0xD32E, 0xD331, 0xD333, 0xD33D, 0xD33F, 0xD340,
    0xD342, 0xD344, 0xD34C, 0xD34E, 0xD3C0, 0xD3C2,
    0xD3C4, 0xD3CC, 0xD3CE, 0xD3D1, 0xD3D3, 0xD3DD,
    0xD3DF, 0xD3E0, 0xD3E2, 0xD3E4, 0xD3EC, 0xD3EE,
    0xD3F1, 0xD3F3, 0xD3FD, 0xD3FF, 0xD401, 0xD403,
    0xD40D, 0xD40F, 0xD410, 0xD412, 0xD414, 0xD41C,
    0xD41E, 0xD421, 0xD423, 0xD42D, 0xD42F, 0xD430,
    0xD432, 0xD434, 0xD43C, 0xD43E, 0xD441, 0xD443,
    0xD44D, 0xD44F, 0xD4C1, 0xD4C3, 0xD4CD, 0xD4CF,
    0xD4D0, 0xD4D2, 0xD4D4, 0xD4DC, 0xD4DE, 0xD4E1,
    0xD4E3, 0xD4ED, 0xD4EF, 0xD4F0, 0xD4F2, 0xD4F4,
    0xD4FC, 0xD4FE, 0xDC01, 0xDC03, 0xDC0D, 0xDC0F,
    0xDC10, 0xDC12, 0xDC14, 0xDC1C, 0xDC1E, 0xDC21,
    0xDC23, 0xDC2D, 0xDC2F, 0xDC30, 0xDC32, 0xDC34,
    0xDC3C, 0xDC3E, 0xDC41, 0xDC43, 0xDC4D, 0xDC4F,
    0xDCC1, 0xDCC3, 0xDCCD, 0xDCCF, 0xDCD0, 0xDCD2,
    0xDCD4, 0xDCDC, 0xDCDE, 0xDCE1, 0xDCE3, 0xDCED,
    0xDCEF, 0xDCF0, 0xDCF2, 0xDCF4, 0xDCFC, 0xDCFE,
    0xDD00, 0xDD02, 0xDD04, 0xDD0C, 0xDD0E, 0xDD11,
    0xDD13, 0xDD1D, 0xDD1F, 0xDD20, 0xDD22, 0xDD24,
    0xDD2C, 0xDD2E, 0xDD31, 0xDD33, 0xDD3D, 0xDD3F,
    0xDD40, 0xDD42, 0xDD44, 0xDD4C, 0xDD4E, 0xDDC0,
    0xDDC2, 0xDDC4, 0xDDCC, 0xDDCE, 0xDDD1, 0xDDD3,
    0xDDDD, 0xDDDF, 0xDDE0, 0xDDE2, 0xDDE4, 0xDDEC,
    0xDDEE, 0xDDF1, 0xDDF3, 0xDDFD, 0xDDFF, 0xDE01,
    0xDE03, 0xDE0D, 0xDE0F, 0xDE10, 0xDE12, 0xDE14,
    0xDE1C, 0xDE1E, 0xDE21, 0xDE23, 0xDE2D, 0xDE2F,
    0xDE30, 0xDE32, 0xDE34, 0xDE3C, 0xDE3E, 0xDE41,
    0xDE43, 0xDE4D, 0xDE4F, 0xDEC1, 0xDEC3, 0xDECD,
    0xDECF, 0xDED0, 0xDED2, 0xDED4, 0xDEDC, 0xDEDE,
    0xDEE1, 0xDEE3, 0xDEED, 0xDEEF, 0xDEF0, 0xDEF2,
    0xDEF4, 0xDEFC, 0xDEFE, 0xDF00, 0xDF02, 0xDF04,
    0xDF0C, 0xDF0E, 0xDF11, 0xDF13, 0xDF1D, 0xDF1F,
    0xDF20, 0xDF22, 0xDF24, 0xDF2C, 0xDF2E, 0xDF31,
    0xDF33, 0xDF3D, 0xDF3F, 0xDF40, 0xDF42, 0xDF44,
    0xDF4C, 0xDF4E, 0xDFC0, 0xDFC2, 0xDFC4, 0xDFCC,
    0xDFCE, 0xDFD1, 0xDFD3, 0xDFDD, 0xDFDF, 0xDFE0,
    0xDFE2, 0xDFE4, 0xDFEC, 0xDFEE, 0xDFF1, 0xDFF3,
    0xDFFD, 0xDFFF, 0xE000, 0xE002, 0xE004, 0xE00C,
    0xE00E, 0xE011, 0xE013, 0xE01D, 0xE01F, 0xE020,
    0xE022, 0xE024, 0xE02C, 0xE02E, 0xE031, 0xE033,
    0xE03D, 0xE03F, 0xE040, 0xE042, 0xE044, 0xE04C,
    0xE04E, 0xE0C0, 0xE0C2, 0xE0C4, 0xE0CC, 0xE0CE,
    0xE0D1, 0xE0D3, 0xE0DD, 0xE0DF, 0xE0E0, 0xE0E2,
    0xE0E4, 0xE0EC, 0xE0EE, 0xE0F1, 0xE0F3, 0xE0FD,
    0xE0FF, 0xE101, 0xE103, 0xE10D, 0xE10F, 0xE110,
    0xE112, 0xE114, 0xE11C, 0xE11E, 0xE121, 0xE123,
    0xE12D, 0xE12F, 0xE130, 0xE132, 0xE134, 0xE13C,
    0xE13E, 0xE141, 0xE143, 0xE14D, 0xE14F, 0xE1C1,
    0xE1C3, 0xE1CD, 0xE1CF, 0xE1D0, 0xE1D2, 0xE1D4,
    0xE1DC, 0xE1DE, 0xE1E1, 0xE1E3, 0xE1ED, 0xE1EF,
    0xE1F0, 0xE1F2, 0xE1F4, 0xE1FC, 0xE1FE, 0xE200,
    0xE202, 0xE204, 0xE20C, 0xE20E, 0xE211, 0xE213,
    0xE21D, 0xE21F, 0xE220, 0xE222, 0xE224, 0xE22C,
    0xE22E, 0xE231, 0xE233, 0xE23D, 0xE23F, 0xE240,
    0xE242, 0xE244, 0xE24C, 0xE24E, 0xE2C0, 0xE2C2,
    0xE2C4, 0xE2CC, 0xE2CE, 0xE2D1, 0xE2D3, 0xE2DD,
    0xE2DF, 0xE2E0, 0xE2E2, 0xE2E4, 0xE2EC, 0xE2EE,
    0xE2F1, 0xE2F3, 0xE2FD, 0xE2FF, 0xE301, 0xE303,
    0xE30D, 0xE30F, 0xE310, 0xE312, 0xE314, 0xE31C,
    0xE31E, 0xE321, 0xE323, 0xE32D, 0xE32F, 0xE330,
    0xE332, 0xE334, 0xE33C, 0xE33E, 0xE341, 0xE343,
    0xE34D, 0xE34F, 0xE3C1, 0xE3C3, 0xE3CD, 0xE3CF,
    0xE3D0, 0xE3D2, 0xE3D4, 0xE3DC, 0xE3DE, 0xE3E1,
    0xE3E3, 0xE3ED, 0xE3EF, 0xE3F0, 0xE3F2, 0xE3F4,
    0xE3FC, 0xE3FE, 0xE400, 0xE402, 0xE404, 0xE40C,
    0xE40E, 0xE411, 0xE413, 0xE41D, 0xE41F, 0xE420,
    0xE422, 0xE424, 0xE42C, 0xE42E, 0xE431, 0xE433,
    0xE43D, 0xE43F, 0xE440, 0xE442, 0xE444, 0xE44C,
    0xE44E, 0xE4C0, 0xE4C2, 0xE4C4, 0xE4CC, 0xE4CE,
    0xE4D1, 0xE4D3, 0xE4DD, 0xE4DF, 0xE4E0, 0xE4E2,
    0xE4E4, 0xE4EC, 0xE4EE, 0xE4F1, 0xE4F3, 0xE4FD,
    0xE4FF, 0xEC00, 0xEC02, 0xEC04, 0xEC0C, 0xEC0E,
    0xEC11, 0xEC13, 0xEC1D, 0xEC1F, 0xEC20, 0xEC22,
    0xEC24, 0xEC2C, 0xEC2E, 0xEC31, 0xEC33, 0xEC3D,
    0xEC3F, 0xEC40, 0xEC42, 0xEC44, 0xEC4C, 0xEC4E,
    0xECC0, 0xECC2, 0xECC4, 0xECCC, 0xECCE, 0xECD1,
    0xECD3, 0xECDD, 0xECDF, 0xECE0, 0xECE2, 0xECE4,
    0xECEC, 0xECEE, 0xECF1, 0xECF3, 0xECFD, 0xECFF,
    0xED01, 0xED03, 0xED0D, 0xED0F, 0xED10, 0xED12,
    0xED14, 0xED1C, 0xED1E, 0xED21, 0xED23, 0xED2D,
    0xED2F, 0xED30, 0xED32, 0xED34, 0xED3C, 0xED3E,
    0xED41, 0xED43, 0xED4D, 0xED4F, 0xEDC1, 0xEDC3,
    0xEDCD, 0xEDCF, 0xEDD0, 0xEDD2, 0xEDD4, 0xEDDC,
    0xEDDE, 0xEDE1, 0xEDE3, 0xEDED, 0xEDEF, 0xEDF0,
    0xEDF2, 0xEDF4, 0xEDFC, 0xEDFE, 0xEE00, 0xEE02,
    0xEE04, 0xEE0C, 0xEE0E, 0xEE11, 0xEE13, 0xEE1D,
    0xEE1F, 0xEE20, 0xEE22, 0xEE24, 0xEE2C, 0xEE2E,
    0xEE31, 0xEE33, 0xEE3D, 0xEE3F, 0xEE40, 0xEE42,
    0xEE44, 0xEE4C, 0xEE4E, 0xEEC0, 0xEEC2, 0xEEC4,
    0xEECC, 0xEECE, 0xEED1, 0xEED3, 0xEEDD, 0xEEDF,
    0xEEE0, 0xEEE2, 0xEEE4, 0xEEEC, 0xEEEE, 0xEEF1,
    0xEEF3, 0xEEFD, 0xEEFF, 0xEF01, 0xEF03, 0xEF0D,
    0xEF0F, 0xEF10, 0xEF12, 0xEF14, 0xEF1C, 0xEF1E,
    0xEF21, 0xEF23, 0xEF2D, 0xEF2F, 0xEF30, 0xEF32,
    0xEF34, 0xEF3C, 0xEF3E, 0xEF41, 0xEF43, 0xEF4D,
    0xEF4F, 0xEFC1, 0xEFC3, 0xEFCD, 0xEFCF, 0xEFD0,
    0xEFD2, 0xEFD4, 0xEFDC, 0xEFDE, 0xEFE1, 0xEFE3,
    0xEFED, 0xEFEF, 0xEFF0, 0xEFF2, 0xEFF4, 0xEFFC,
    0xEFFE, 0xF001, 0xF003, 0xF00D, 0xF00F, 0xF010,
    0xF012, 0xF014, 0xF01C, 0xF01E, 0xF021, 0xF023,
    0xF02D, 0xF02F, 0xF030, 0xF032, 0xF034, 0xF03C,
    0xF03E, 0xF041, 0xF043, 0xF04D, 0xF04F, 0xF0C1,
    0xF0C3, 0xF0CD, 0xF0CF, 0xF0D0, 0xF0D2, 0xF0D4,
    0xF0DC, 0xF0DE, 0xF0E1, 0xF0E3, 0xF0ED, 0xF0EF,
    0xF0F0, 0xF0F2, 0xF0F4, 0xF0FC, 0xF0FE, 0xF100,
    0xF102, 0xF104, 0xF10C, 0xF10E, 0xF111, 0xF113,
    0xF11D, 0xF11F, 0xF120, 0xF122, 0xF124, 0xF12C,
    0xF12E, 0xF131, 0xF133, 0xF13D, 0xF13F, 0xF140,
    0xF142, 0xF144, 0xF14C, 0xF14E, 0xF1C0, 0xF1C2,
    0xF1C4, 0xF1CC, 0xF1CE, 0xF1D1, 0xF1D3, 0xF1DD,
    0xF1DF, 0xF1E0, 0xF1E2, 0xF1E4, 0xF1EC, 0xF1EE,
    0xF1F1, 0xF1F3, 0xF1FD, 0xF1FF, 0xF201, 0xF203,
    0xF20D, 0xF20F, 0xF210, 0xF212, 0xF214, 0xF21C,
    0xF21E, 0xF221, 0xF223, 0xF22D, 0xF22F, 0xF230,
    0xF232, 0xF234, 0xF23C, 0xF23E, 0xF241, 0xF243,
    0xF24D, 0xF24F, 0xF2C1, 0xF2C3, 0xF2CD, 0xF2CF,
    0xF2D0, 0xF2D2, 0xF2D4, 0xF2DC, 0xF2DE, 0xF2E1,
    0xF2E3, 0xF2ED, 0xF2EF, 0xF2F0, 0xF2F2, 0xF2F4,
    0xF2FC, 0xF2FE, 0xF300, 0xF302, 0xF304, 0xF30C,
    0xF30E, 0xF311, 0xF313, 0xF31D, 0xF31F, 0xF320,
    0xF322, 0xF324, 0xF32C, 0xF32E, 0xF331, 0xF333,
    0xF33D, 0xF33F, 0xF340, 0xF342, 0xF344, 0xF34C,
    0xF34E, 0xF3C0, 0xF3C2, 0xF3C4, 0xF3CC, 0xF3CE,
    0xF3D1, 0xF3D3, 0xF3DD, 0xF3DF, 0xF3E0, 0xF3E2,
    0xF3E4, 0xF3EC, 0xF3EE, 0xF3F1, 0xF3F3, 0xF3FD,
    0xF3FF, 0xF401, 0xF403, 0xF40D, 0xF40F, 0xF410,
    0xF412, 0xF414, 0xF41C, 0xF41E, 0xF421, 0xF423,
    0xF42D, 0xF42F, 0xF430, 0xF432, 0xF434, 0xF43C,
    0xF43E, 0xF441, 0xF443, 0xF44D, 0xF44F, 0xF4C1,
    0xF4C3, 0xF4CD, 0xF4CF, 0xF4D0, 0xF4D2, 0xF4D4,
    0xF4DC, 0xF4DE, 0xF4E1, 0xF4E3, 0xF4ED, 0xF4EF,
    0xF4F0, 0xF4F2, 0xF4F4, 0xF4FC, 0xF4FE, 0xFC01,
    0xFC03, 0xFC0D, 0xFC0F, 0xFC10, 0xFC12, 0xFC14,
    0xFC1C, 0xFC1E, 0xFC21, 0xFC23, 0xFC2D, 0xFC2F,
    0xFC30, 0xFC32, 0xFC34, 0xFC3C, 0xFC3E, 0xFC41,
    0xFC43, 0xFC4D, 0xFC4F, 0xFCC1, 0xFCC3, 0xFCCD,
    0xFCCF, 0xFCD0, 0xFCD2, 0xFCD4, 0xFCDC, 0xFCDE,
    0xFCE1, 0xFCE3, 0xFCED, 0xFCEF, 0xFCF0, 0xFCF2,
    0xFCF4, 0xFCFC, 0xFCFE, 0xFD00, 0xFD02, 0xFD04,
    0xFD0C, 0xFD0E, 0xFD11, 0xFD13, 0xFD1D, 0xFD1F,
    0xFD20, 0xFD22, 0xFD24, 0xFD2C, 0xFD2E, 0xFD31,
    0xFD33, 0xFD3D, 0xFD3F, 0xFD40, 0xFD42, 0xFD44,
    0xFD4C, 0xFD4E, 0xFDC0, 0xFDC2, 0xFDC4, 0xFDCC,
    0xFDCE, 0xFDD1, 0xFDD3, 0xFDDD, 0xFDDF, 0xFDE0,
    0xFDE2, 0xFDE4, 0xFDEC, 0xFDEE, 0xFDF1, 0xFDF3,
    0xFDFD, 0xFDFF, 0xFE01, 0xFE03, 0xFE0D, 0xFE0F,
    0xFE10, 0xFE12, 0xFE14, 0xFE1C, 0xFE1E, 0xFE21,
    0xFE23, 0xFE2D, 0xFE2F, 0xFE30, 0xFE32, 0xFE34,
    0xFE3C, 0xFE3E, 0xFE41, 0xFE43, 0xFE4D, 0xFE4F,
    0xFEC1, 0xFEC3, 0xFECD, 0xFECF, 0xFED0, 0xFED2,
    0xFED4, 0xFEDC, 0xFEDE, 0xFEE1, 0xFEE3, 0xFEED,
    0xFEEF, 0xFEF0, 0xFEF2, 0xFEF4, 0xFEFC, 0xFEFE,
    0xFF00, 0xFF02, 0xFF04, 0xFF0C, 0xFF0E, 0xFF11,
    0xFF13, 0xFF1D, 0xFF1F, 0xFF20, 0xFF22, 0xFF24,
    0xFF2C, 0xFF2E, 0xFF31, 0xFF33, 0xFF3D, 0xFF3F,
    0xFF40, 0xFF42, 0xFF44, 0xFF4C, 0xFF4E, 0xFFC0,
    0xFFC2, 0xFFC4, 0xFFCC, 0xFFCE, 0xFFD1, 0xFFD3,
    0xFFDD, 0xFFDF, 0xFFE0, 0xFFE2, 0xFFE4, 0xFFEC,
    0xFFEE, 0xFFF1, 0xFFF3, 0xFFFD, 0xFFFF,
};

#define ON2AVC_CB8_CODES 3281
static const uint32_t on2avc_cb8_codes[ON2AVC_CB8_CODES] = {
    0x028C, 0x05E6, 0xFAD9, 0x7DEF, 0x06CE, 0x004C,
    0x0178, 0x0A1D, 0x00AE, 0x046E, 0x03D5, 0x3F58,
    0x0EAA, 0x0233, 0x1A6A, 0x271F, 0x05CE, 0x0179,
    0x02FB, 0x0029, 0x237D, 0x7DF0, 0x03BA, 0xFAD6,
    0xFAD7, 0x7DEE, 0xFAD5, 0x0081, 0x033C, 0x1A69,
    0xFAD8, 0x05A1, 0x01F1, 0x063D, 0x237C, 0x003E,
    0x0323, 0x010C, 0x05A3, 0x05A2, 0x0051, 0x019D,
    0xFADB, 0x0EAB, 0x00AA, 0x003E, 0x01A6, 0x7DF2,
    0x0058, 0x01F1, 0x029B, 0x03C0, 0x122D, 0x0075,
    0x3F5A, 0x0B98, 0x0005, 0x058B, 0x0D68, 0x013F,
    0x00D0, 0x05CF, 0x01C0, 0x03BB, 0x046F, 0xFADA,
    0x01A0, 0x0972, 0x122C, 0x3F59, 0x0766, 0x05A4,
    0x00ED, 0x05A5, 0x0D67, 0x03D0, 0x0046, 0x01FF,
    0x7DF1, 0x00D6, 0x017C, 0x0034, 0x08B5, 0x0234,
    0x237E, 0x0033, 0x0083, 0x0B99, 0x0EAC, 0x0202,
    0x0714, 0x0715, 0x01C3, 0x05A6, 0x0324, 0x13EC,
    0x02F8, 0x7DF3, 0x13EB, 0x0140, 0x0470, 0x04F8,
    0x0007, 0x0377, 0x0208, 0x04A3, 0x13EA, 0x0006,
    0x0188, 0x033D, 0x122E, 0x1A6B, 0x0A1E, 0x0126,
    0x03C1, 0x05E7, 0x05D0, 0x04F7, 0x03DB, 0x033E,
    0x122F, 0x0082, 0x1A6F, 0x2380, 0x05D2, 0x0009,
    0x05A9, 0x1A70, 0x1233, 0x05A7, 0x05A8, 0x0975,
    0x2381, 0x1234, 0x0788, 0x2720, 0x1235, 0x05D3,
    0xFADD, 0x3F5B, 0x0789, 0x0D69, 0xFADE, 0xFADF,
    0x01C4, 0x0EAD, 0x0EA1, 0x1230, 0x0008, 0x13ED,
    0x1A6C, 0xFADC, 0x1231, 0x0973, 0x1232, 0x1A6D,
    0x13EE, 0x1A6E, 0x0974, 0x237F, 0x05D1, 0x033F,
    0x0267, 0x078A, 0xFAE3, 0xFAE2, 0x0B9A, 0x00FC,
    0x0EAE, 0x05D6, 0x0325, 0x0326, 0x0B9B, 0x3F5F,
    0x3F5E, 0x0471, 0x02F9, 0xFAE4, 0x1A72, 0x03C2,
    0x05D7, 0x2721, 0x3F60, 0xFAE5, 0x2382, 0xFAE0,
    0x7DF5, 0xFAE1, 0x7DF4, 0x000A, 0x0235, 0x3F5C,
    0x1A71, 0x0716, 0x036C, 0x0767, 0x05D4, 0x3F5D,
    0x0717, 0x01BF, 0x000B, 0x05D5, 0x0243, 0xFAD0,
    0x04F6, 0x7DE5, 0xFACF, 0x0E9E, 0x0074, 0x271A,
    0x1A61, 0x015B, 0x0046, 0x06CA, 0x237A, 0x7DE6,
    0x0070, 0x1A62, 0x1227, 0x7DE7, 0x0032, 0xFAD1,
    0x05CA, 0x7DE8, 0x237B, 0x13E6, 0x05C8, 0x1226,
    0x2377, 0x2719, 0x3F54, 0x3F55, 0x13E5, 0x2378,
    0x03BF, 0x05C9, 0x01C0, 0x7DE4, 0x7DE3, 0x0A19,
    0x0045, 0x1A60, 0x2379, 0x021B, 0x271C, 0x13E7,
    0x271B, 0x1A67, 0x059D, 0x0EA6, 0x0EA7, 0x0174,
    0x0EA5, 0x0A1A, 0x1FFD, 0x033A, 0x0E9F, 0x3F57,
    0x122B, 0xFAD2, 0x0D64, 0x05CC, 0x06CB, 0x1FFE,
    0x059E, 0x02F7, 0x1228, 0x7DE9, 0x059B, 0x096C,
    0x1A63, 0x1A64, 0x1A65, 0x1229, 0x0EA3, 0x059C,
    0x096D, 0x05CB, 0x003C, 0x1A66, 0x0D63, 0x3F56,
    0x122A, 0x0EA4, 0x0712, 0x0232, 0x13E8, 0x061E,
    0x08B4, 0x016E, 0x0176, 0x033B, 0x0028, 0x05E5,
    0x061F, 0x0000, 0x0376, 0x0071, 0x096F, 0x7DEB,
    0x0001, 0x05CD, 0xFAD3, 0x0186, 0x0EA9, 0x13E9,
    0x06CD, 0x7DEA, 0x0340, 0x271D, 0x0175, 0x01C1,
    0x0D65, 0x1FFF, 0x0B97, 0x0EA8, 0x06CC, 0x0375,
    0x05E4, 0x08B3, 0x05E3, 0x0341, 0x0EA0, 0x096E,
    0x03CF, 0x0056, 0x0970, 0x1A68, 0x029A, 0x010A,
    0x00A8, 0x01CA, 0x7DED, 0x00A5, 0x001E, 0x05A0,
    0x0D66, 0x0047, 0x0971, 0x0A1C, 0x02CE, 0xFAD4,
    0x0004, 0x010F, 0x271E, 0x0415, 0x0212, 0x019F,
    0x7DEC, 0x01C2, 0x0187, 0x059F, 0x0A1B, 0x0527,
    0x0002, 0x003D, 0x0041, 0x0177, 0x0713, 0x010E,
    0x0102, 0x02CF, 0x00CA, 0x0003, 0x01BF, 0x0120,
    0x05DE, 0x0043, 0x01D0, 0x018C, 0x00AB, 0x029F,
    0x03DF, 0x03C5, 0x0247, 0x08BB, 0x0013, 0x03D2,
    0x0015, 0x0EB0, 0x02FA, 0x05E8, 0x0014, 0x0EB1,
    0x0476, 0x1A78, 0x01F4, 0x06D1, 0x017C, 0x0042,
    0x063F, 0x0011, 0x0012, 0x01C7, 0x04FB, 0x1A77,
    0x01AA, 0x04FC, 0x0A21, 0x021D, 0x01EE, 0x02BC,
    0x01C2, 0x021E, 0x00AA, 0x00D6, 0x021F, 0x016F,
    0x0077, 0x01AB, 0x00AC, 0x0073, 0x078D, 0x00AF,
    0x002E, 0x0220, 0x0086, 0x0103, 0x0086, 0x0127,
    0x0BA0, 0x05DF, 0x0EA5, 0x03D3, 0x05E0, 0x017D,
    0xFAE7, 0x015A, 0x03C6, 0x0768, 0xFAE6, 0x3F65,
    0x01F3, 0x0B9F, 0x0016, 0x0EA4, 0x078C, 0x02BD,
    0x004D, 0x0116, 0x037A, 0x0076, 0x0056, 0x058E,
    0x06D2, 0x0014, 0x009F, 0x0A23, 0x0346, 0x014E,
    0x02BF, 0x00A7, 0x0528, 0x0378, 0x0106, 0x01C3,
    0x017E, 0x0044, 0x03C7, 0x097F, 0x04A5, 0x020B,
    0x05E9, 0x0A24, 0x03D9, 0x0661, 0x0660, 0x014F,
    0x02BE, 0x023B, 0x04FD, 0x0313, 0x0017, 0x08BC,
    0x0769, 0x0622, 0x0D6C, 0x03D7, 0x01C8, 0x0A22,
    0x01AB, 0x0203, 0x076A, 0x03D8, 0x02D1, 0x00A6,
    0x05E3, 0x1A79, 0x1A7A, 0x0981, 0x05B1, 0x04FF,
    0x0982, 0x0348, 0x0128, 0x08BD, 0x0D6D, 0x13F4,
    0x05B2, 0x0624, 0x05B3, 0x0EB2, 0x2729, 0x1237,
    0x05B4, 0x0129, 0x0349, 0x2386, 0x0019, 0x04FE,
    0x05B0, 0xFAE8, 0x3F66, 0x0623, 0x05E1, 0x05E2,
    0x3F67, 0x0980, 0x0347, 0x0BA1, 0x0046, 0x0045,
    0x0EA6, 0x01C9, 0x0018, 0x13F3, 0x078E, 0x0152,
    0x0983, 0x1238, 0x272B, 0x01F2, 0x028F, 0x05E5,
    0x3F69, 0x0418, 0x02FC, 0x017F, 0x0EB3, 0x00EF,
    0x0790, 0x0791, 0x1239, 0x05E6, 0x05E7, 0x1A7C,
    0x034A, 0x001A, 0x0984, 0x05B5, 0x272A, 0x1A7B,
    0x0EA7, 0x0529, 0x02FB, 0x2387, 0x3F68, 0x078F,
    0x006D, 0x0D6E, 0x05B6, 0x039F, 0x014E, 0x058F,
    0x13F5, 0x05E4, 0x020C, 0x0342, 0x1A73, 0x7DF7,
    0x2724, 0x0082, 0x0209, 0x1A74, 0x05DB, 0x03D6,
    0x001F, 0x0B9C, 0x04F9, 0x0096, 0x03C3, 0x0620,
    0x7DF9, 0x7DF8, 0x0EA2, 0x000C, 0x2725, 0x3F61,
    0x0977, 0x0976, 0x2723, 0x05D8, 0x2722, 0x058C,
    0x08B6, 0x05D9, 0x2383, 0x0236, 0x036D, 0x0A1F,
    0x05AA, 0x019C, 0x01C0, 0x0327, 0x05DA, 0x7DF6,
    0x02CF, 0x05DD, 0x0341, 0x05AE, 0x0EAF, 0x2384,
    0x0342, 0x13F0, 0x000D, 0x08B7, 0x000E, 0x003F,
    0x097B, 0x0343, 0x0D6A, 0x1A75, 0x000F, 0x3F63,
    0x05AF, 0x06CF, 0x06D0, 0x2385, 0x13F1, 0x058D,
    0x0237, 0x05AB, 0x7DFA, 0x0EA3, 0x03C4, 0x13EF,
    0x05DC, 0x2726, 0x1236, 0x017A, 0x0978, 0x05AD,
    0x05AC, 0x0340, 0x0238, 0x097A, 0x3F62, 0x0979,
    0x03DE, 0x0010, 0x0345, 0x002A, 0x03D1, 0x01A7,
    0x01F2, 0x009E, 0x020A, 0x0189, 0x0D6B, 0x03C6,
    0x00EE, 0x0A20, 0x017B, 0x04FA, 0x0472, 0x0040,
    0x00CB, 0x08B9, 0x02D0, 0x029E, 0x0020, 0x0344,
    0x0239, 0x02D0, 0x0B9D, 0x023A, 0x0B9E, 0x028D,
    0x03C5, 0x03BE, 0x08B8, 0x078B, 0x0337, 0x0246,
    0x004C, 0x0416, 0x0141, 0x04A4, 0x00E2, 0x0213,
    0x028E, 0x01A7, 0x021C, 0x00D4, 0x01C6, 0x0072,
    0x0067, 0x002B, 0x0473, 0x036F, 0x01E0, 0x036E,
    0x0041, 0x3F64, 0x097E, 0x0621, 0x02BB, 0x00D7,
    0x2728, 0x2727, 0x01C1, 0x0129, 0x0417, 0x13F2,
    0x097C, 0x0142, 0x097D, 0x1A76, 0x08BA, 0x063E,
    0x0100, 0x01AA, 0x018A, 0x00EA, 0x014D, 0x001E,
    0x01C5, 0x03C7, 0x0053, 0x05EC, 0x012D, 0x004C,
    0x0D71, 0x01D0, 0x0023, 0x0D72, 0x0185, 0x02D2,
    0x0719, 0x012F, 0x0502, 0x012E, 0x0A28, 0x098E,
    0x238B, 0x272D, 0x05EE, 0x05BE, 0x0130, 0xFAEE,
    0x272E, 0x0BA2, 0x05EB, 0x01CF, 0xFAED, 0x238A,
    0x01CE, 0x098C, 0x7DFD, 0x05BD, 0x004A, 0x0036,
    0x0037, 0x0628, 0x02FD, 0x048A, 0x017E, 0x004B,
    0x098D, 0x0153, 0x0216, 0x0D73, 0x1A82, 0x0042,
    0x017F, 0x026C, 0x020D, 0x0794, 0x0143, 0x007E,
    0x062A, 0x0798, 0x004F, 0x0EBA, 0x0BA4, 0x023E,
    0x05BF, 0x0EB9, 0x0592, 0x03CC, 0x004E, 0x018E,
    0x032C, 0x0629, 0x0BA3, 0x01F7, 0x0EB8, 0x004D,
    0x0990, 0x0350, 0x098F, 0x0343, 0x0023, 0x052B,
    0x004E, 0x0178, 0x04A6, 0x0291, 0x05ED, 0x00DC,
    0x032D, 0x0504, 0x0991, 0x0A29, 0x0593, 0x01F3,
    0x0A2A, 0x0505, 0x015B, 0x0666, 0x0087, 0x03DA,
    0x0BA5, 0x076D, 0x05C1, 0x03CD, 0x0024, 0x0992,
    0x04A7, 0x0131, 0x05C2, 0x272F, 0x01D1, 0x076B,
    0x076C, 0x1242, 0x05EF, 0x062B, 0x0EAE, 0x13FD,
    0x05C0, 0x0EBB, 0x023F, 0x0D74, 0x0503, 0x02FE,
    0x041A, 0x037B, 0x08BE, 0x0240, 0x0316, 0x0EBD,
    0x3F70, 0x0EBC, 0x0A2B, 0x0BA7, 0x0053, 0x05C5,
    0x13FE, 0x0506, 0x03CE, 0x0026, 0x0994, 0x0038,
    0x0027, 0x0132, 0x020E, 0x2731, 0x0EBE, 0x0796,
    0x018F, 0x05C6, 0x02FF, 0x0795, 0x1A83, 0x3F6E,
    0x0BA6, 0x0025, 0x1243, 0x3F6F, 0x004F, 0x2730,
    0x062C, 0x0993, 0x05C3, 0x05C4, 0x0051, 0x0052,
    0x0351, 0x062D, 0x0050, 0x01F6, 0x08BF, 0x3F71,
    0x238E, 0x05C7, 0x01F7, 0x05C8, 0x062E, 0x012A,
    0x032F, 0x0077, 0x1A86, 0x0EBF, 0x03DB, 0x04AA,
    0x0BA8, 0x13FF, 0x062F, 0xFAF2, 0x071A, 0x0054,
    0xFAF1, 0x2732, 0xFAF0, 0x238C, 0x238D, 0xFAEF,
    0x1A84, 0x0392, 0x1244, 0x0995, 0x0799, 0x007F,
    0x032E, 0x7DFE, 0x1A85, 0x05EE, 0x018A, 0x0996,
    0x0028, 0x0152, 0x025A, 0x0A25, 0x7DFC, 0x3F6B,
    0x023C, 0x018B, 0x05B7, 0x0180, 0x00FD, 0x01BA,
    0x05EA, 0x123D, 0x05E8, 0x002F, 0x0625, 0x05B9,
    0x05B8, 0x0477, 0x13F7, 0x0D6F, 0x3F6C, 0xFAEA,
    0x01CB, 0xFAE9, 0x0985, 0x2388, 0x7DFB, 0x034B,
    0x01CA, 0x0047, 0x123A, 0x3F6A, 0x017D, 0x0662,
    0x123C, 0x123B, 0x0379, 0x024A, 0x13F6, 0x1A7D,
    0x016A, 0x0EAA, 0x123F, 0xFAEC, 0x0EA9, 0x13FB,
    0x0182, 0x0792, 0x05BA, 0x0181, 0x0D70, 0x001F,
    0x001E, 0x05BB, 0x3F6D, 0x0020, 0x2389, 0x1240,
    0x0183, 0x0501, 0x1A7F, 0x06D6, 0x0663, 0x06D3,
    0x13F8, 0x034C, 0x0EB4, 0x123E, 0x1A7E, 0x13F9,
    0x001B, 0x05E9, 0x0EA8, 0x001C, 0xFAEB, 0x05EA,
    0x034D, 0x0500, 0x13FA, 0x001D, 0x0048, 0x0794,
    0x0075, 0x0795, 0x0793, 0x0074, 0x008A, 0x03C9,
    0x05EB, 0x0087, 0x0076, 0x012B, 0x012C, 0x037A,
    0x0718, 0x0022, 0x272C, 0x0988, 0x0EB5, 0x0328,
    0x03CA, 0x05EC, 0x0EAB, 0x06D7, 0x0021, 0x0664,
    0x1A80, 0x0986, 0x0419, 0x03C8, 0x034E, 0x0987,
    0x0626, 0x02FC, 0x00AE, 0x01CC, 0x023D, 0x012A,
    0x0021, 0x0A26, 0x05BC, 0x01F6, 0x0221, 0x0049,
    0x0EB6, 0x0042, 0x02D2, 0x00F2, 0x00AF, 0x0290,
    0x0043, 0x052A, 0x13FC, 0x0A27, 0x032A, 0x1241,
    0x0EB7, 0x0EAD, 0x034F, 0x0EAC, 0x0022, 0x05ED,
    0x0797, 0x032B, 0x0035, 0x0989, 0x0184, 0x037B,
    0x098A, 0x1A81, 0x098B, 0x0796, 0x01CD, 0x025B,
    0x03CB, 0x0627, 0x02DA, 0x010C, 0x02D1, 0x06EA,
    0x0665, 0x0329, 0x0D78, 0x7E05, 0x7E04, 0x140A,
    0x0EB3, 0x0ECF, 0x3F7C, 0x1256, 0x05FB, 0x05CF,
    0xFAFF, 0x3F7D, 0x0ED0, 0x7E06, 0x3F7E, 0x3F7F,
    0xFB00, 0x239B, 0x0ED2, 0x1257, 0x7E07, 0x0ED1,
    0x002D, 0x1255, 0x273A, 0x09A4, 0x239A, 0x0ECD,
    0x273B, 0x1A8C, 0x002E, 0x09A5, 0xFAFE, 0x273C,
    0x0BAF, 0x0BB0, 0x05CE, 0x09A6, 0x00D1, 0x0ECE,
    0x09A8, 0x0030, 0x1A8E, 0x0ED3, 0x09A7, 0x0667,
    0x1258, 0x2740, 0x0D79, 0x3F80, 0x0189, 0x09A9,
    0x0EB5, 0x0359, 0x0ED4, 0x125A, 0x239D, 0x1259,
    0x05D1, 0x0D7A, 0x7E0A, 0x7E09, 0x09AA, 0x273D,
    0x0EB4, 0x273E, 0x002F, 0x0354, 0x05FC, 0x239C,
    0x1A8D, 0x0355, 0x0357, 0x05D0, 0x0358, 0x0356,
    0x01D2, 0x0508, 0x7E08, 0x273F, 0x0302, 0x0ED7,
    0x239E, 0x3F84, 0x08C4, 0x01D3, 0x0BB1, 0x0509,
    0x239F, 0x0303, 0x0133, 0x035C, 0x125B, 0x03D1,
    0x0ED8, 0x035D, 0x035E, 0x2743, 0x2744, 0x09AD,
    0x018A, 0x0031, 0x09AC, 0x3F82, 0x2741, 0x3F81,
    0x035A, 0x3F83, 0x05FD, 0x09AB, 0x0ED5, 0x0ED6,
    0x0633, 0x2742, 0x0055, 0x08C3, 0x0636, 0x035B,
    0x05FE, 0x0D7B, 0x0039, 0xFB05, 0x7E0B, 0x7E0C,
    0x140D, 0x018B, 0x09AF, 0x2746, 0x0032, 0x0056,
    0x09B0, 0x03D2, 0x0A30, 0x2747, 0x0057, 0x0EDA,
    0x050A, 0x125E, 0x0033, 0x2748, 0x0D7C, 0x03D3,
    0x3F85, 0x0034, 0xFB01, 0x140B, 0xFB02, 0x05FF,
    0x125C, 0xFB03, 0x125D, 0x1A8F, 0x0600, 0x05D2,
    0x0602, 0x2745, 0x0601, 0x0ED9, 0x1A90, 0xFB04,
    0x140C, 0x09AE, 0x033A, 0x7E0F, 0x23A2, 0x0A31,
    0x0EB6, 0x0058, 0x3F8A, 0x23A3, 0x01D6, 0x04AB,
    0x0059, 0x0EDB, 0x02D3, 0x018C, 0x04C6, 0x1260,
    0x3F8B, 0x125F, 0x1261, 0x071E, 0x7E10, 0x2749,
    0x140E, 0x3F87, 0x3F86, 0x0035, 0x3F88, 0x3F89,
    0x7E0D, 0x23A0, 0x1A91, 0x0797, 0x0603, 0x1A92,
    0x050B, 0x066A, 0x0306, 0x7E0E, 0x23A1, 0x079B,
    0x0BAA, 0x3F73, 0x7E01, 0x0292, 0x0216, 0x0998,
    0x1247, 0x2390, 0x0301, 0x0999, 0x1400, 0x1A87,
    0x041E, 0x1401, 0x0EC1, 0x2391, 0x3F74, 0x0A2C,
    0x1248, 0x3F75, 0x05C9, 0x0EC2, 0x2733, 0x238F,
    0xFAF3, 0xFAF4, 0x0EC0, 0x0997, 0x3F72, 0xFAF5,
    0x1245, 0x08C0, 0x0BA9, 0x1246, 0x020F, 0x041B,
    0x0186, 0x7E00, 0x7DFF, 0x0300, 0xFAFA, 0x2734,
    0x05F2, 0x124D, 0x2395, 0x099A, 0x2735, 0x3F77,
    0x0EC4, 0x0EC5, 0x1403, 0x0EC6, 0x1402, 0x1A89,
    0x3F78, 0x05F5, 0x05F3, 0x05F4, 0x2736, 0x1404,
    0x7E02, 0x124E, 0x0D75, 0x0029, 0x2392, 0xFAF7,
    0xFAF6, 0x0EC3, 0x1249, 0x2394, 0x2393, 0x05F0,
    0xFAF8, 0x124B, 0x124C, 0x124A, 0x3F76, 0x05CA,
    0x05F1, 0xFAF9, 0x1A88, 0x0187, 0x05F7, 0x124F,
    0x0631, 0x0D76, 0x0EAF, 0x2737, 0x0BAC, 0x099D,
    0x0A2D, 0x1250, 0x1407, 0x0BAD, 0x3F7A, 0x2396,
    0x2397, 0x0353, 0x1A8B, 0x08C2, 0x05CD, 0x099E,
    0x05CC, 0x0352, 0x002A, 0x05CB, 0x03CF, 0x1A8A,
    0x1405, 0x1406, 0x099B, 0x0EC7, 0x0630, 0x002B,
    0x3F79, 0x08C1, 0x0BAB, 0x0507, 0x05F6, 0x0EC8,
    0x099C, 0x0EB0, 0x0A2F, 0x0EB1, 0x2739, 0x09A1,
    0x03D0, 0x1252, 0x7E03, 0x0241, 0x0188, 0x0EB2,
    0x0BAE, 0x05FA, 0x09A2, 0x1254, 0x2398, 0xFAFB,
    0x1253, 0x2399, 0x0ECC, 0xFAFD, 0xFAFC, 0x09A3,
    0x1408, 0x09A0, 0x05F8, 0x3F7B, 0x099F, 0x0D77,
    0x1409, 0x002C, 0x0EC9, 0x0ECB, 0x0A2E, 0x1251,
    0x0ECA, 0x079A, 0x071B, 0x05F9, 0x2738, 0x0632,
    0x002E, 0x0012, 0x7E25, 0xFB1C, 0x0262, 0x001C,
    0x03D6, 0x018E, 0x007C, 0x0342, 0x052E, 0x7E26,
    0xFB1D, 0x01D7, 0x0D7F, 0x126A, 0x2756, 0x09B6,
    0xFB20, 0x3F97, 0xFB21, 0xFB1E, 0xFB1F, 0x23AF,
    0xFB19, 0xFB1A, 0x23AE, 0x7E24, 0x1A95, 0x2755,
    0x2754, 0x05D7, 0x050D, 0x0EE3, 0xFB1B, 0x0EE2,
    0x0BB5, 0x00E3, 0x08CB, 0x05D8, 0x01B9, 0x00E7,
    0x1412, 0x1A96, 0x015A, 0x009A, 0x007B, 0xFB24,
    0x3F99, 0x026D, 0x0026, 0x0EE5, 0x0EE4, 0x0222,
    0x05D9, 0x0D82, 0x7E28, 0x3F9A, 0x0A36, 0xFB25,
    0xFB26, 0x23B1, 0x7E29, 0x126B, 0x7E27, 0x23B0,
    0xFB22, 0x1411, 0x0BB6, 0x3F98, 0x126C, 0x09B7,
    0x02C2, 0x0442, 0x0A33, 0x012B, 0x01C1, 0x0034,
    0xFB23, 0x126D, 0x03DF, 0x0084, 0x0EB7, 0x23B2,
    0x7E2A, 0x052F, 0x018D, 0x0B16, 0x7E2B, 0x01A2,
    0x0736, 0x00F3, 0x060F, 0x003B, 0x003B, 0x081A,
    0x003F, 0x1416, 0x003E, 0x3F9D, 0x126E, 0x7E2E,
    0x7E2C, 0x7E2D, 0x2757, 0x060E, 0xFB28, 0xFB27,
    0x3F9B, 0x050E, 0x0EE6, 0x018F, 0x05DA, 0x0136,
    0x071F, 0xFB29, 0x1413, 0x0137, 0x3F9C, 0x0EE7,
    0x05DB, 0x02DB, 0x05EF, 0x23B5, 0x0EBB, 0x0243,
    0xFB2D, 0x0307, 0xFB2E, 0x275A, 0x0293, 0x041F,
    0x0686, 0x3F9E, 0x0217, 0x0612, 0x05FA, 0x23B6,
    0x7E2F, 0x1A97, 0x275B, 0x0613, 0xFB2F, 0x7E30,
    0xFB2A, 0x23B4, 0x126F, 0x23B3, 0x1270, 0x2758,
    0xFB2B, 0x0610, 0x0BB7, 0x03D7, 0x2759, 0x0916,
    0x050F, 0x0EBA, 0x0BF6, 0xFB2C, 0x0611, 0x00D3,
    0x2C5E, 0x7E36, 0xFB34, 0xFB33, 0x3FA2, 0xFB35,
    0x2FDE, 0x1417, 0x0A37, 0x3FA3, 0x02A2, 0x7E37,
    0xFB36, 0x005E, 0x058A, 0x076F, 0x0886, 0x005F,
    0xFB3B, 0x0686, 0x0342, 0xFB37, 0xFB3A, 0x3F9F,
    0x3FA0, 0xFB31, 0xFB30, 0x23B7, 0x3FA1, 0x23BB,
    0x23BA, 0x1271, 0x0D83, 0x1036, 0x7E32, 0x1272,
    0x7E31, 0x7E33, 0x162E, 0x1273, 0xFB32, 0xFB0C,
    0x1262, 0xFB0D, 0xFB0B, 0x3F8F, 0x0037, 0x1263,
    0x3F90, 0x0EDD, 0x0038, 0x05D3, 0xFB0E, 0x23A7,
    0x0606, 0x1265, 0x3F91, 0x1264, 0x0039, 0xFB0F,
    0x7E14, 0xFB10, 0x274A, 0x274B, 0xFB07, 0xFB08,
    0x23A5, 0xFB06, 0x23A4, 0x0EDC, 0xFB0A, 0xFB09,
    0x7E11, 0x0036, 0x0605, 0x3F8C, 0x7E12, 0x0604,
    0x3F8E, 0x23A6, 0x7E13, 0x3F8D, 0x03DE, 0x7E19,
    0x7E18, 0x0242, 0x0097, 0x08C5, 0xFB13, 0x7E1A,
    0x005A, 0x079B, 0x0607, 0x09B2, 0x033B, 0x05D4,
    0x09B3, 0xFB14, 0x23A8, 0x0637, 0x7E1B, 0x23AA,
    0x23A9, 0x0608, 0x274C, 0xFB12, 0xFB11, 0x7E15,
    0x1266, 0x140F, 0x1267, 0x7E16, 0x274D, 0x079E,
    0x274E, 0x0EDE, 0x066B, 0x09B1, 0x0D7D, 0x3F92,
    0x7E17, 0x079A, 0x002A, 0x00D2, 0x23AC, 0x23AB,
    0x02F2, 0x00B6, 0x0BB2, 0x05D5, 0x0066, 0x03A2,
    0x003A, 0x060B, 0x060A, 0x0317, 0x079F, 0x0362,
    0x2750, 0x050C, 0x3F95, 0x7E1D, 0x7E1E, 0xFB15,
    0x23AD, 0x274F, 0x3F93, 0x3F94, 0x7E1C, 0x0609,
    0x08C6, 0x0EE0, 0x0EDF, 0x035F, 0x0136, 0x076E,
    0x1A93, 0x1268, 0x0A32, 0x024B, 0x08C7, 0x1410,
    0x01EC, 0x0036, 0x0EE1, 0x0363, 0x0072, 0x0030,
    0x003E, 0x2753, 0x7E21, 0x00D7, 0x0117, 0x003A,
    0x0BB4, 0x0126, 0x018D, 0x05D6, 0x7E22, 0xFB16,
    0x0D7E, 0x060D, 0xFB18, 0xFB17, 0x7E23, 0x7E1F,
    0x2752, 0x1269, 0x2751, 0x09B4, 0x08CA, 0x1A94,
    0x3F96, 0x0BB3, 0x0107, 0x09B5, 0x005B, 0x03D6,
    0x00B0, 0x0101, 0x7E20, 0x060C, 0x03D7, 0x0032,
    0x04DE, 0xFA91, 0x7DA8, 0x088E, 0x0374, 0x7DA9,
    0x054E, 0x007A, 0x0223, 0x0152, 0x3F26, 0x7DAA,
    0x0610, 0x1A36, 0x13B3, 0x0E58, 0x1A35, 0x7DAD,
    0x3F27, 0x7DAE, 0x7DAB, 0x7DAC, 0xFA8D, 0x2347,
    0xFA8E, 0xFA8C, 0x7DA6, 0x3F24, 0x2348, 0x7DA7,
    0x0E4F, 0x02C8, 0x0376, 0xFA90, 0xFA8F, 0x0116,
    0x008A, 0x059A, 0x3F25, 0x0044, 0x00AC, 0x1A37,
    0x0153, 0x0066, 0x01DE, 0x049C, 0xFA96, 0x3F28,
    0x0370, 0x00EA, 0x054F, 0x3F29, 0x006B, 0x093C,
    0x0570, 0x11E2, 0x26E0, 0x1A38, 0x26E1, 0x234A,
    0x7DB1, 0x093D, 0x1FD7, 0x2349, 0x7DAF, 0x7DB0,
    0x0310, 0x0775, 0xFA93, 0xFA92, 0x13B4, 0x009A,
    0x0022, 0x093B, 0x020E, 0x002A, 0x003C, 0xFA95,
    0xFA94, 0x033C, 0x00A8, 0x00C9, 0x26E3, 0xFA99,
    0x051D, 0x00FA, 0x0154, 0x093E, 0x00DE, 0x0371,
    0x002E, 0xFA9A, 0x11E3, 0x0377, 0x0776, 0x7DB2,
    0x11E4, 0x11E5, 0x7DB3, 0x3F2B, 0xFA9B, 0x234E,
    0x11E6, 0x26E2, 0x059B, 0xFA98, 0xFA97, 0x234B,
    0x0A0D, 0x059C, 0x234C, 0x0571, 0x006C, 0x075C,
    0x234D, 0x3F2A, 0x06C2, 0x00FE, 0x0311, 0x059D,
    0x010A, 0x031C, 0x059E, 0x11E8, 0x0587, 0x2352,
    0x0312, 0x7DB6, 0xFA9E, 0x04DF, 0x1FD8, 0x11E9,
    0x093F, 0x0A0E, 0x0E5A, 0x11EA, 0x2353, 0x1FD9,
    0x0573, 0x11EB, 0x7DB7, 0xFA9F, 0x0E5B, 0xFA9C,
    0xFA9D, 0x7DB4, 0x234F, 0x0E59, 0x0572, 0x2351,
    0x2350, 0x11E7, 0x049D, 0x3F2D, 0x3F2C, 0x0023,
    0x010D, 0x088F, 0x7DB5, 0x26E4, 0x0611, 0xFAA4,
    0x1A39, 0xFAA5, 0xFAA3, 0x26E7, 0xFAA6, 0x3F2F,
    0x2356, 0x2357, 0x0940, 0x13B8, 0xFAA7, 0x7DBC,
    0x1FDA, 0x2358, 0xFAA8, 0x3F30, 0x26E8, 0xFAA9,
    0xFAAA, 0xFAAB, 0x2359, 0x7DBD, 0x7DB9, 0x2354,
    0x11EC, 0xFAA0, 0x7DB8, 0x13B5, 0x11ED, 0x2355,
    0x7DBA, 0x13B6, 0x13B7, 0x7DBB, 0xFAA1, 0x26E5,
    0x0612, 0x3F2E, 0x26E6, 0xFAA2, 0x7D9E, 0x0590,
    0x7D9F, 0xBF7D, 0x0D0F, 0x13AF, 0x0591, 0x1A1C,
    0x1FD3, 0x17EE, 0x0592, 0x3F1A, 0xBF7E, 0x11DC,
    0x0593, 0x206F, 0x7DA0, 0x3F1C, 0xBF7F, 0x1A1E,
    0x3F1D, 0x1A1D, 0x245C, 0x110E, 0x110F, 0x58BE,
    0x0220, 0x0150, 0x1FD2, 0x7D9C, 0x04DC, 0x05E6,
    0x0D0E, 0x001E, 0xBF7C, 0x58BF, 0x0B80, 0x054C,
    0x13AE, 0x206E, 0x02A3, 0x051C, 0x1A30, 0x245F,
    0x0466, 0x7DA1, 0x030A, 0x3F1F, 0xFA82, 0x088C,
    0x05E7, 0x04DD, 0x13B0, 0x0790, 0x1A31, 0x1FD4,
    0x13B1, 0x7DA2, 0x2638, 0x1A32, 0x2341, 0x2340,
    0x2639, 0x3F1E, 0xFA80, 0x0594, 0x11DE, 0x11DF,
    0x0596, 0x1A1F, 0x0595, 0x02C4, 0x051A, 0x0E4D,
    0x0E4C, 0x040C, 0x245E, 0x0464, 0xFA81, 0x245D,
    0x0222, 0x0074, 0x031A, 0x3F21, 0x263B, 0x06EB,
    0x0254, 0x0774, 0x0020, 0x0078, 0x0410, 0x02EE,
    0x13B2, 0xFA84, 0x06C0, 0x0A0A, 0x0E4E, 0x0597,
    0xFA85, 0xFA87, 0x0598, 0x11E0, 0xFA86, 0x263C,
    0x1FD5, 0x2343, 0xFA83, 0x3F20, 0x2342, 0x030B,
    0x263A, 0x0B81, 0x0586, 0x040E, 0x040F, 0x2345,
    0x2344, 0x02C6, 0x0130, 0x030C, 0x054D, 0x01BE,
    0x0132, 0x0599, 0x3F23, 0x00FA, 0x012E, 0x03CE,
    0xFA8B, 0x263E, 0x02C7, 0x006A, 0x093A, 0x0E6E,
    0x0182, 0x0021, 0x00C8, 0x1A33, 0x7DA5, 0x0E6F,
    0x1FD6, 0x1A34, 0x2346, 0x263F, 0x3F22, 0x7DA4,
    0xFA88, 0x7DA3, 0x030D, 0x0A0C, 0xFA89, 0x11E1,
    0x088D, 0x0256, 0x030F, 0x030E, 0x02F8, 0x0060,
    0x02B8, 0xFA8A, 0x263D, 0x0257, 0x13BE, 0x7DCD,
    0xFAB4, 0x0E83, 0x13BF, 0x015B, 0x26F8, 0x26F7,
    0x0B89, 0x0947, 0x3F39, 0x11F9, 0x13C0, 0x26F9,
    0x05AF, 0x11FC, 0x11FA, 0x11FB, 0x0E84, 0x11FE,
    0xFAB5, 0x11FD, 0x26F5, 0xFAB2, 0x235F, 0x05AC,
    0x26F6, 0x05AD, 0x7DCB, 0x7DCA, 0x2360, 0x0946,
    0x7DCC, 0xFAB3, 0x057A, 0x0318, 0x11F8, 0x05AE,
    0x2361, 0x0B88, 0x26FB, 0x1203, 0x1204, 0x0E85,
    0x0E86, 0x0D4F, 0x0E87, 0x0948, 0x0A10, 0x1FE2,
    0x057C, 0x1A3F, 0x0D50, 0x015D, 0x057D, 0x1205,
    0x1A40, 0x13C2, 0x26FC, 0x26FD, 0x1206, 0x3F3A,
    0x1A41, 0x1FE1, 0x0E8E, 0x26FA, 0xFAB6, 0x11FF,
    0x1201, 0x7DCE, 0x1200, 0x05B0, 0x13C1, 0x089E,
    0x0319, 0x015C, 0x057B, 0x070A, 0x1A3E, 0x1202,
    0x011D, 0x031A, 0x7DCF, 0x1209, 0x0E90, 0x015F,
    0x002B, 0x05B1, 0x0D54, 0x04E5, 0x0160, 0x05B2,
    0x13C4, 0x0E88, 0x1FE5, 0x1FE6, 0x2362, 0x3F3B,
    0x13C5, 0x26FF, 0x0161, 0x057E, 0x0779, 0x0D51,
    0x13C3, 0x1A42, 0x04E4, 0x1208, 0x1A44, 0x1FE3,
    0x1207, 0x1A43, 0x0225, 0x26FE, 0x1FE4, 0x015E,
    0x0D53, 0x002A, 0x0E8F, 0x0D52, 0x0778, 0x2701,
    0x2363, 0x3F3E, 0x1FE8, 0xFAB8, 0x13C9, 0x2365,
    0x2364, 0x031B, 0x120A, 0x0E8B, 0x05B8, 0x0E8A,
    0x13CA, 0x3F3F, 0x2702, 0x1FE9, 0x120B, 0x7DD0,
    0x094A, 0x2366, 0xFAB9, 0x13CB, 0x1A45, 0x13C7,
    0x05B3, 0xFAB7, 0x13C6, 0x3F3D, 0x05B4, 0x3F3C,
    0x1FE7, 0x05B5, 0x13C8, 0x0E89, 0x1A46, 0x1A47,
    0x05B6, 0x05B7, 0x2700, 0x0949, 0x0122, 0x05B9,
    0x2704, 0x031D, 0x0469, 0x094C, 0xFABA, 0x120F,
    0x1A48, 0x0638, 0x1210, 0x13CC, 0x01B3, 0x3F42,
    0x1A49, 0xFABB, 0x3F41, 0x0E8C, 0x1A4A, 0x2367,
    0x3F43, 0x094D, 0x2703, 0x094B, 0x7DD1, 0x3F40,
    0x031C, 0x0226, 0x1FEA, 0x7DD2, 0x120C, 0x03DA,
    0x0B8A, 0x120D, 0x002C, 0x03CC, 0x04E6, 0x7DD3,
    0x120E, 0x089F, 0x04E2, 0x059F, 0xFAAD, 0x0117,
    0x0137, 0x0613, 0x235C, 0x3F31, 0x0899, 0x02EF,
    0x0025, 0x0942, 0x0468, 0x0E8C, 0x0A0F, 0x13BA,
    0x7DBE, 0x13B9, 0x05A0, 0x7DC0, 0x26EB, 0x7DBF,
    0x235A, 0x235B, 0x0372, 0x0313, 0x0941, 0x0898,
    0x26E9, 0x0574, 0x02C9, 0x051E, 0x0024, 0x1FDB,
    0x0467, 0x0791, 0x04E1, 0x26EA, 0xFAAC, 0x04E0,
    0x3F34, 0x0E5D, 0x26ED, 0xFAAE, 0x1FDC, 0x0575,
    0x0314, 0x7DC4, 0x1FDD, 0x1FDE, 0x05A1, 0x0E5E,
    0x26EE, 0x26EF, 0x7DC5, 0x11EE, 0xFAAF, 0x3F35,
    0x11EF, 0x26F0, 0x7DC6, 0xFAB0, 0x05A2, 0x7DC1,
    0x0E5C, 0x7DC2, 0x00CA, 0x01B0, 0x235D, 0x3F32,
    0x075E, 0x0B82, 0x0155, 0x0156, 0x3F33, 0x26EC,
    0x0708, 0x0B83, 0x1A3B, 0x7DC3, 0x1A3A, 0x089B,
    0x11F2, 0x05A5, 0x0E5F, 0x0027, 0x01B2, 0x089C,
    0x26F3, 0x0B85, 0x0157, 0x011C, 0x0944, 0x0577,
    0x7DC8, 0x13BB, 0x089D, 0x05A6, 0x0315, 0x0E8D,
    0xFAB1, 0x1A3C, 0x03AC, 0x0576, 0x7DC7, 0x0B84,
    0x05A3, 0x26F1, 0x26F2, 0x05A4, 0x0224, 0x0943,
    0x0D4C, 0x11F0, 0x1FDF, 0x089A, 0x02F0, 0x0D4D,
    0x0026, 0x11F1, 0x0777, 0x0E82, 0x0029, 0x05A8,
    0x1A3D, 0x0028, 0x00CB, 0x0159, 0x11F6, 0x0709,
    0x0614, 0x04E3, 0x015A, 0x0578, 0x0B87, 0x1FE0,
    0x05AA, 0x7DC9, 0x05A9, 0x05AB, 0x0579, 0x11F7,
    0x3F38, 0x0945, 0x13BC, 0x26F4, 0x235E, 0x3F36,
    0x0158, 0x05A7, 0x3F37, 0x0E80, 0x11F3, 0x13BD,
    0x0B86, 0x0E81, 0x0316, 0x0317, 0x0D4E, 0x11F5,
    0x11F4, 0x075F, 0x06C3, 0x08A6, 0x0B8D, 0x0584,
    0x022A, 0x02CA, 0x13D5, 0x0E93, 0x0217, 0x011F,
    0x0124, 0x0120, 0x0B8E, 0x06C4, 0x0326, 0x0327,
    0x05BC, 0x0B8F, 0xFAC1, 0x0955, 0x1217, 0x7DD9,
    0x0328, 0x0323, 0x0324, 0x2369, 0x7DD8, 0x0031,
    0x1FF3, 0x1216, 0xFAC0, 0x1215, 0x0032, 0x00CD,
    0x03AF, 0x0A12, 0x01BC, 0x0070, 0x0325, 0x0E92,
    0x038E, 0x02D7, 0x2708, 0x13D7, 0x0296, 0x039A,
    0x00FE, 0x070D, 0x01ED, 0x02D8, 0x0398, 0x077E,
    0x0167, 0x0244, 0x0329, 0x01BD, 0x0521, 0x022B,
    0x1A50, 0x0122, 0x08A9, 0x0A13, 0x05DD, 0x070C,
    0x04E9, 0x0033, 0x0121, 0x13D6, 0x0956, 0x08A7,
    0x0585, 0x0166, 0x0204, 0x08A8, 0x0586, 0x04A0,
    0x02CB, 0x003D, 0x0588, 0x0289, 0x03C2, 0x03B8,
    0x077F, 0x0587, 0x04EB, 0x00CF, 0x01A3, 0x13D9,
    0x0617, 0x01A2, 0x06C5, 0x0522, 0x03B9, 0x070E,
    0x0762, 0x08AA, 0x1A51, 0x0169, 0x03BA, 0x1218,
    0x0523, 0x04EC, 0x3F49, 0x0E96, 0x04EA, 0x02CA,
    0x0D59, 0x13D8, 0x03D2, 0x0E95, 0x0957, 0x0E94,
    0x0168, 0x0123, 0x031E, 0x0412, 0x032A, 0x00CE,
    0x039C, 0x0E95, 0x0D5A, 0x0071, 0x13DC, 0x7DDA,
    0x236C, 0x0E96, 0x13DD, 0x032C, 0x1A52, 0x0B90,
    0x0589, 0x032D, 0x2709, 0x1FF6, 0x058A, 0x1219,
    0x05BD, 0x058B, 0x0035, 0x270A, 0x05DE, 0x095A,
    0x1A53, 0x016B, 0x022C, 0x070F, 0x13DA, 0x0958,
    0x3F4A, 0x0588, 0x0D5B, 0x13DB, 0x236A, 0x0780,
    0x3F4B, 0x1FF4, 0x0959, 0x0034, 0x016A, 0x236B,
    0x1FF5, 0x032B, 0x270B, 0x02F3, 0xFAC4, 0x7DDC,
    0x1FF7, 0x0124, 0x095C, 0x016C, 0x0072, 0x016A,
    0x04EE, 0x270D, 0x270C, 0x022D, 0x04A1, 0x270E,
    0x0E97, 0x0618, 0xFAC5, 0x0E98, 0x3F4C, 0x236E,
    0x1A54, 0x05BF, 0x032E, 0x121A, 0xFAC2, 0x05BE,
    0x01EE, 0x04ED, 0x236D, 0x03BB, 0x0125, 0x00EC,
    0x7DDB, 0xFAC3, 0x05DF, 0x00C9, 0x08AB, 0x095B,
    0x013C, 0x01FE, 0x0B8B, 0xFABD, 0x7DD4, 0x0615,
    0x01EA, 0x0E91, 0x057F, 0x016E, 0x0156, 0x08A1,
    0x094E, 0x7DD5, 0x03D1, 0x01B6, 0x1FEC, 0x1FEB,
    0xFABE, 0x7DD6, 0x1212, 0x7DD7, 0xFABF, 0x1A4C,
    0x0E8D, 0x3F44, 0xFABC, 0x002D, 0x006A, 0x01B5,
    0x13CD, 0x08A0, 0x01B4, 0x03D0, 0x006B, 0x1211,
    0x3F45, 0x0227, 0x02FE, 0x077A, 0x1A4B, 0x014A,
    0x0E91, 0x1FED, 0x2705, 0x0162, 0x094F, 0x002E,
    0x04E8, 0x1FEE, 0x0A11, 0x0950, 0x0581, 0x1FEF,
    0x1FF0, 0x2706, 0x3F47, 0x1A4F, 0x0582, 0x05BA,
    0x002F, 0x031E, 0x13CF, 0x0760, 0x0580, 0x0E92,
    0x031D, 0x04E7, 0x1A4D, 0x1A4E, 0x0E8E, 0x01B7,
    0x02F1, 0x02F2, 0x3F46, 0x0E8F, 0x0616, 0x0D55,
    0x006C, 0x0E93, 0x0E90, 0x13CE, 0x049E, 0x0411,
    0x13D0, 0x08A2, 0x03AD, 0x02D3, 0x0228, 0x13D1,
    0x006D, 0x006D, 0x0792, 0x01B8, 0x077C, 0x0229,
    0x0320, 0x1FF1, 0x3F48, 0x0D56, 0x13D2, 0x01B9,
    0x2707, 0x2368, 0x0D57, 0x00CC, 0x0520, 0x1213,
    0x0163, 0x051F, 0x0951, 0x1214, 0x0E94, 0x0164,
    0x00FC, 0x070B, 0x077B, 0x0761, 0x00C6, 0x017A,
    0x031F, 0x0583, 0x01EE, 0x00D4, 0x0165, 0x0952,
    0x02C8, 0x00C8, 0x023A, 0x0030, 0x01EC, 0x00FD,
    0x02F9, 0x01BB, 0x0953, 0x01A0, 0x13D4, 0x08A5,
    0x0030, 0x08A4, 0x077D, 0x006E, 0x0D58, 0x0954,
    0x05DC, 0x0123, 0x0321, 0x01BA, 0x0288, 0x05BB,
    0x13D3, 0x0322, 0x03AE, 0x0B8C, 0x049F, 0x1FF2,
    0x08A3, 0x006E, 0x02D6, 0x006F, 0x011E, 0x0373,
    0x03BF, 0x01EA, 0x08AF, 0x0595, 0x0100, 0x0112,
    0x0050, 0x02B9, 0x014C, 0x01A4, 0x0258, 0x04F2,
    0x0596, 0x00A4, 0x13E1, 0x0124, 0x08B0, 0x04F3,
    0x0171, 0x0413, 0x2713, 0x0E9B, 0x046C, 0x00A2,
    0x0765, 0x05E0, 0x019C, 0x0964, 0x0335, 0x061C,
    0x3F4F, 0x0E9A, 0x009A, 0x0170, 0x0784, 0x003E,
    0x012F, 0x01A3, 0x023D, 0x01F0, 0x016B, 0x00A3,
    0x023F, 0x03C4, 0x03D4, 0x0377, 0x0052, 0x01BE,
    0x0031, 0x0012, 0x0157, 0x021A, 0x0242, 0x039E,
    0x04A2, 0x05E1, 0x02F6, 0x1A5D, 0x0336, 0x0126,
    0x05E2, 0x2374, 0x05C4, 0x046D, 0x0311, 0x01A5,
    0x04F4, 0xFAC8, 0x023E, 0x0A17, 0x0D5F, 0x05C3,
    0x08B1, 0x009C, 0x02CD, 0x0299, 0x036A, 0x0376,
    0x006C, 0x0037, 0x0785, 0x0076, 0x0040, 0x0965,
    0x13E2, 0x02CC, 0x0259, 0x0414, 0x06C6, 0x01A6,
    0x033F, 0x0334, 0x0E9C, 0x0786, 0x0127, 0x0966,
    0x06C7, 0x063B, 0x0039, 0x0172, 0x0374, 0x003A,
    0x0597, 0x0128, 0x00FF, 0x0526, 0x2375, 0x0044,
    0x0337, 0x0B95, 0x0230, 0x7DDE, 0x0D60, 0x0185,
    0x0D61, 0x0038, 0x0321, 0x003F, 0x009D, 0x0101,
    0x03B9, 0x0312, 0x0969, 0x1A5E, 0x1220, 0x2714,
    0x003B, 0x0598, 0x2715, 0x1FFB, 0x08B2, 0x096A,
    0x0EA1, 0x7DDF, 0x1FFC, 0x0A18, 0x1A5F, 0x1222,
    0x1221, 0x0173, 0x0793, 0x061D, 0x096B, 0x7DE0,
    0x0787, 0x0231, 0x0711, 0x0EA0, 0xFAC9, 0x121D,
    0x05C5, 0x121F, 0x121E, 0x3F50, 0x0E9D, 0x0338,
    0x0968, 0x0967, 0x04F5, 0x0B96, 0x05C7, 0x05C6,
    0x03BE, 0x01B8, 0x1225, 0x1224, 0x02CE, 0x0160,
    0x0102, 0xFACD, 0x3F51, 0x0322, 0xFACE, 0x0339,
    0x059A, 0x019E, 0x063C, 0x01BF, 0x7DE2, 0x3F52,
    0x0D62, 0x2718, 0x3F53, 0x2717, 0x0EA2, 0x0599,
    0x13E3, 0xFACA, 0xFACB, 0x06C8, 0x06C9, 0xFACC,
    0x7DE1, 0x0125, 0x01BC, 0x13E4, 0x1223, 0x0336,
    0x02BA, 0x028B, 0x2716, 0x2376, 0x02CD, 0x013D,
    0x095E, 0x05C0, 0x0016, 0x016F, 0x0525, 0x2371,
    0x2370, 0x0205, 0x01C8, 0x058C, 0x0B91, 0x00E6,
    0x0639, 0x0330, 0x2372, 0x3F4D, 0x0763, 0x016E,
    0x121B, 0x1FF9, 0x058D, 0x016D, 0x1A55, 0x270F,
    0x13DE, 0xFAC6, 0x1FF8, 0x236F, 0x1A56, 0x04EF,
    0x0298, 0x0E99, 0x095D, 0x01BE, 0x02CC, 0x0524,
    0x032F, 0x7DDD, 0x0589, 0x095F, 0x03BC, 0x1A59,
    0x0E9A, 0x0E9B, 0x061A, 0x13E0, 0x0E9C, 0x08AD,
    0x0332, 0x0A15, 0x0591, 0x0D5D, 0x0590, 0x0960,
    0x2373, 0x2711, 0x1A5A, 0x058A, 0x006F, 0x3F4E,
    0x2712, 0x0764, 0x08AC, 0x05C1, 0xFAC7, 0x0331,
    0x1FFA, 0x13DF, 0x2710, 0x1A57, 0x0E97, 0x058E,
    0x0619, 0x0A14, 0x1A58, 0x0D5C, 0x0782, 0x058F,
    0x121C, 0x0781, 0x0210, 0x0594, 0x0962, 0x0080,
    0x0399, 0x03C3, 0x02F5, 0x0184, 0x028A, 0x046B,
    0x0963, 0x0B92, 0x0100, 0x1A5B, 0x0A16, 0x0E9D,
    0x03BD, 0x0B93, 0x01A4, 0x0333, 0x0783, 0x033E,
    0x00FE, 0x0592, 0x031F, 0x046A, 0x0593, 0x0961,
    0x04F0, 0x00FF, 0x02F4, 0x0073, 0x0E98, 0x04F1,
    0x033D, 0x0266, 0x02FF, 0x03D3, 0x0320, 0x0206,
    0x004E, 0x023C, 0x01EF, 0x0211, 0x0027, 0x000C,
    0x063A, 0x08AE, 0x008C, 0x03CE, 0x02D9, 0x02FA,
    0x01A2, 0x01A5, 0x061B, 0x0E9E, 0x05C2, 0x022F,
    0x039D, 0x01F0, 0x1A5C, 0x0E9F, 0x02CB, 0x03B8,
    0x014B, 0x0B94, 0x0E99, 0x013E, 0x016F, 0x0036,
    0x0334, 0x0D5E, 0x0310, 0x0207, 0x0044, 0x017B,
    0x00DF, 0x0042, 0x022E, 0x0710, 0x007E,
};

static const uint8_t on2avc_cb8_bits[ON2AVC_CB8_CODES] = {
    11, 11, 16, 15, 11,  9,
    13, 12,  9, 11, 11, 14,
    13, 12, 13, 14, 14, 13,
    10, 11, 15, 15, 10, 16,
    16, 15, 16, 11, 13, 13,
    16, 13, 11, 11, 15, 13,
    11,  9, 13, 13, 10,  9,
    16, 13,  9, 10, 10, 15,
    10, 10, 10, 12, 14, 11,
    14, 12, 14, 11, 12, 11,
    12, 14, 10, 10, 11, 16,
    10, 13, 14, 14, 11, 13,
    11, 13, 12, 10, 10, 10,
    15, 10, 10, 12, 12, 12,
    15, 12, 11, 12, 13, 10,
    11, 11, 12, 13, 11, 13,
    12, 15, 13, 11, 11, 12,
    14, 11, 11, 11, 13, 14,
    11, 13, 14, 13, 12, 12,
    12, 11, 14, 12, 10, 13,
    14, 11, 13, 15, 14, 14,
    13, 13, 14, 13, 13, 13,
    15, 14, 12, 14, 14, 14,
    16, 14, 12, 12, 16, 16,
    12, 13, 12, 14, 14, 13,
    13, 16, 14, 13, 14, 13,
    13, 13, 13, 15, 14, 13,
    10, 12, 16, 16, 12, 10,
    13, 14, 11, 11, 12, 14,
    14, 11, 12, 16, 13, 12,
    14, 14, 14, 16, 15, 16,
    15, 16, 15, 14, 12, 14,
    13, 11, 10, 11, 14, 14,
    11,  9, 14, 14, 10, 16,
    12, 15, 16, 12, 11, 14,
    13,  9, 11, 11, 15, 15,
    12, 13, 14, 15, 12, 16,
    14, 15, 15, 13, 14, 14,
    15, 14, 14, 14, 13, 15,
    12, 14, 12, 15, 15, 12,
    11, 13, 15, 10, 14, 13,
    14, 13, 13, 13, 13, 13,
    13, 12, 13, 13, 12, 14,
    14, 16, 12, 14, 11, 13,
    13, 12, 14, 15, 13, 13,
    13, 13, 13, 14, 13, 13,
    13, 14, 13, 13, 12, 14,
    14, 13, 11, 12, 13, 12,
    12, 10, 13, 13, 11, 11,
    12, 14, 11, 12, 13, 15,
    14, 14, 16, 11, 13, 13,
    11, 15, 10, 14, 13, 12,
    12, 13, 12, 13, 11, 11,
    11, 12, 11, 10, 12, 13,
    10, 10, 13, 13, 10, 10,
    10, 10, 15, 11, 11, 13,
    12, 11, 13, 12, 11, 16,
    14, 10, 14, 11, 10, 10,
    15, 12, 11, 13, 12, 11,
    14, 13, 11, 13, 11, 10,
     9, 10, 10, 14, 10,  9,
    14, 13,  9,  9, 10, 10,
    10, 10, 10, 12, 14, 10,
    14, 13, 12, 11, 14, 13,
    11, 13,  9, 11, 13, 13,
    11, 14, 14, 12, 12, 13,
    10, 12, 12, 10,  9, 10,
    10, 10, 10,  9, 10, 10,
    11, 10,  8, 12, 12,  9,
    11, 10, 10, 11, 11, 12,
    12, 14, 12, 10, 14, 13,
    16, 10, 10, 11, 16, 14,
    11, 12, 14, 12, 12, 10,
    11, 10, 10, 11,  9, 11,
    11,  9, 11, 12, 13, 10,
    10, 11, 11, 11, 11, 10,
    13, 13, 10, 13, 11, 11,
    11, 12, 11, 11, 11, 10,
    10, 12, 12, 10, 14, 12,
    11, 12, 12, 11, 12, 12,
    11, 10, 11, 11, 11, 11,
    14, 13, 13, 13, 13, 12,
    13, 13, 12, 12, 12, 13,
    13, 12, 13, 13, 14, 14,
    13, 12, 13, 15, 14, 12,
    13, 16, 14, 12, 14, 14,
    14, 13, 13, 12, 13, 13,
    12, 12, 14, 13, 12, 10,
    13, 14, 14, 10, 11, 14,
    14, 11, 10, 13, 13, 11,
    12, 12, 14, 14, 14, 13,
    13, 14, 13, 13, 14, 13,
    12, 11, 12, 15, 14, 12,
     9, 12, 13, 10,  9, 11,
    13, 14, 11, 10, 13, 15,
    14, 10, 11, 13, 14, 11,
    11, 12, 12, 10, 12, 12,
    15, 15, 12, 14, 14, 14,
    13, 13, 14, 14, 14, 11,
    12, 14, 15, 12, 10, 12,
    13,  9,  9, 11, 14, 15,
    11, 14, 13, 13, 13, 15,
    13, 13, 14, 12, 14, 13,
    13, 13, 12, 13, 14, 14,
    13, 11, 11, 15, 13, 11,
    12, 13, 15, 12, 12, 13,
    14, 14, 14, 13, 13, 13,
    13, 13, 12, 13, 14, 13,
    10, 14, 13, 11, 10, 11,
    11, 11, 11, 11, 12, 12,
    11, 12, 13, 12, 11, 13,
    10, 12, 11, 10, 11, 13,
    12, 10, 12, 12, 12, 11,
    12, 10, 12, 12, 10, 10,
    11, 11, 11, 11,  9, 10,
    11, 10, 10,  9, 12, 12,
     9, 11, 11, 10,  9, 10,
    13, 14, 13, 12, 10, 10,
    14, 14, 10, 11, 11, 13,
    13, 11, 13, 13, 12, 11,
    10, 11, 11, 10, 10,  9,
    12, 12,  9, 11, 12, 13,
    12, 12, 11, 12, 13, 11,
    11, 12, 12, 12, 12, 13,
    15, 14, 14, 13, 12, 16,
    14, 12, 11, 12, 16, 15,
    12, 13, 15, 13, 13, 12,
    12, 12, 12, 11, 10, 13,
    13, 10, 10, 12, 13, 10,
    10, 10, 11, 11, 11, 11,
    12, 12, 11, 13, 12, 12,
    13, 13, 11, 12, 13, 11,
    11, 12, 12, 11, 13, 13,
    13, 13, 13, 10, 14, 11,
    11, 10, 11, 11, 11, 10,
    11, 12, 13, 12, 11, 10,
    12, 12, 10, 11, 10, 11,
    12, 11, 13, 12, 14, 13,
    11, 12, 13, 14, 12, 11,
    11, 14, 14, 12, 12, 13,
    13, 13, 12, 12, 12, 12,
    11, 10, 12, 12, 10, 13,
    14, 13, 12, 12, 13, 13,
    13, 12, 12, 14, 13, 12,
    14, 12, 11, 14, 13, 11,
    11, 13, 12, 11, 13, 14,
    12, 14, 14, 14, 13, 14,
    12, 13, 13, 13, 13, 13,
    13, 12, 13, 10, 12, 14,
    15, 13, 10, 13, 12, 11,
    11, 12, 13, 13, 11, 11,
    12, 13, 12, 16, 11, 13,
    16, 14, 16, 15, 15, 16,
    13, 11, 14, 13, 12, 11,
    11, 15, 13, 11,  9, 13,
    14, 11, 10, 12, 15, 14,
    12, 11, 13, 13, 10, 11,
    11, 14, 14, 11, 12, 13,
    13, 11, 13, 12, 14, 16,
    12, 16, 13, 15, 15, 13,
    12, 13, 14, 14, 10, 11,
    14, 14, 11, 10, 13, 13,
     9, 12, 14, 16, 12, 13,
    13, 12, 13, 13, 12, 14,
    14, 13, 14, 14, 15, 14,
    13, 12, 13, 11, 11, 11,
    13, 13, 13, 14, 13, 13,
    14, 14, 12, 14, 16, 14,
    13, 12, 13, 14, 13, 12,
    12, 12, 12, 12, 11, 12,
    14, 11, 12, 12, 12, 11,
    11, 14, 14, 13, 13, 11,
    12, 14, 12, 11, 14, 11,
    13, 13, 11, 12, 13, 13,
    12, 12, 11, 12, 12, 12,
    11, 12, 13, 11, 10, 13,
    13, 11, 10, 11, 11, 11,
    11, 11, 13, 12, 11, 14,
    13, 12, 13, 12, 11, 14,
    12, 11, 12, 13, 13, 11,
    13, 13, 13, 12, 12, 10,
    12, 12, 10, 10, 10, 11,
    11, 11, 12, 15, 15, 13,
    12, 13, 14, 14, 14, 13,
    16, 14, 13, 15, 14, 14,
    16, 15, 13, 14, 15, 13,
    14, 14, 14, 13, 15, 13,
    14, 13, 14, 13, 16, 14,
    12, 12, 13, 13, 12, 13,
    13, 14, 13, 13, 13, 11,
    14, 14, 12, 14, 13, 13,
    12, 13, 13, 14, 15, 14,
    13, 12, 15, 15, 13, 14,
    12, 14, 14, 13, 14, 15,
    13, 13, 13, 13, 13, 13,
    12, 12, 15, 14, 12, 13,
    15, 14, 12, 12, 12, 12,
    15, 12, 12, 13, 14, 12,
    13, 13, 13, 14, 14, 13,
    13, 14, 13, 14, 14, 14,
    13, 14, 14, 13, 13, 13,
    12, 14, 13, 12, 12, 13,
    14, 12, 12, 16, 15, 15,
    13, 13, 13, 14, 14, 13,
    13, 12, 12, 14, 13, 13,
    12, 14, 14, 14, 12, 12,
    14, 14, 16, 13, 16, 14,
    14, 16, 14, 13, 14, 13,
    14, 14, 14, 13, 13, 16,
    13, 13, 11, 15, 15, 12,
    12, 13, 14, 15, 12, 11,
    13, 13, 11, 13, 11, 14,
    14, 14, 14, 11, 15, 14,
    13, 14, 14, 14, 14, 14,
    15, 15, 13, 11, 14, 13,
    12, 11, 12, 15, 15, 12,
    12, 14, 15, 11, 11, 13,
    14, 15, 12, 13, 13, 13,
    11, 13, 13, 15, 14, 12,
    14, 14, 13, 13, 14, 15,
    16, 16, 13, 13, 14, 16,
    14, 12, 12, 14, 11, 11,
    13, 15, 15, 12, 16, 14,
    14, 14, 15, 13, 14, 14,
    13, 13, 13, 13, 13, 13,
    14, 14, 14, 14, 14, 13,
    15, 14, 12, 14, 15, 16,
    16, 13, 14, 15, 15, 14,
    16, 14, 14, 14, 14, 13,
    14, 16, 13, 13, 14, 14,
    12, 12, 12, 14, 12, 13,
    12, 14, 13, 12, 14, 15,
    15, 13, 13, 12, 13, 13,
    13, 13, 14, 13, 12, 13,
    13, 13, 13, 13, 12, 14,
    14, 12, 12, 12, 14, 13,
    13, 12, 12, 12, 14, 13,
    12, 14, 15, 12, 13, 12,
    12, 14, 13, 14, 15, 16,
    14, 15, 13, 16, 16, 13,
    13, 13, 14, 14, 13, 12,
    13, 14, 13, 13, 12, 14,
    13, 12, 11, 14, 14, 12,
     7, 10, 15, 16, 10,  7,
    12, 13,  7, 11, 11, 15,
    16, 12, 12, 14, 14, 13,
    16, 14, 16, 16, 16, 15,
    16, 16, 15, 15, 13, 14,
    14, 13, 12, 13, 16, 13,
    12,  9, 12, 13,  9,  9,
    13, 13,  9,  8, 10, 16,
    14, 10, 11, 13, 13, 10,
    13, 12, 15, 14, 12, 16,
    16, 15, 15, 14, 15, 15,
    16, 13, 12, 14, 14, 13,
    10, 13, 12, 11,  9, 11,
    16, 14, 11,  9, 12, 15,
    15, 11,  9, 13, 15,  9,
    11, 11, 14, 14, 12, 12,
    14, 13, 14, 14, 14, 15,
    15, 15, 14, 14, 16, 16,
    14, 12, 13, 13, 13, 11,
    11, 16, 13, 12, 14, 13,
    13, 10, 11, 15, 12, 12,
    16, 12, 16, 14, 11, 11,
    13, 14, 11, 14, 11, 15,
    15, 13, 14, 14, 16, 15,
    16, 15, 14, 15, 14, 14,
    16, 14, 12, 12, 14, 12,
    12, 12, 12, 16, 14, 12,
    15, 15, 16, 16, 14, 16,
    14, 13, 12, 14, 14, 15,
    16, 13, 12, 11, 14, 13,
    16, 12, 12, 16, 16, 14,
    14, 16, 16, 15, 14, 15,
    15, 14, 12, 13, 15, 14,
    15, 15, 14, 14, 16, 16,
    14, 16, 16, 14, 14, 14,
    14, 13, 14, 13, 16, 15,
    14, 14, 14, 14, 14, 16,
    15, 16, 14, 14, 16, 16,
    15, 16, 15, 13, 16, 16,
    15, 14, 14, 14, 15, 14,
    14, 15, 15, 14, 11, 15,
    15, 12, 10, 12, 16, 15,
    13, 11, 14, 13, 11, 13,
    13, 16, 15, 12, 15, 15,
    15, 14, 14, 16, 16, 15,
    14, 13, 14, 15, 14, 12,
    14, 13, 11, 13, 12, 14,
    15, 11,  9, 12, 15, 15,
    11,  9, 12, 13,  9, 10,
    12, 14, 14, 10, 12, 13,
    14, 12, 14, 15, 15, 16,
    15, 14, 14, 14, 15, 14,
    12, 13, 13, 13, 12, 11,
    13, 14, 12, 10, 12, 13,
     9,  7, 13, 13,  7,  6,
     9, 14, 15,  9, 10, 14,
    12,  9, 13, 13, 15, 16,
    12, 14, 16, 16, 15, 15,
    14, 14, 14, 13, 12, 13,
    14, 12, 11, 13, 13, 10,
     9, 10, 15, 14, 10,  6,
    12, 16, 15, 12, 10, 15,
    13, 10, 12, 13, 14, 15,
    12, 13, 13, 13, 13, 15,
    14, 15, 15, 15, 16, 15,
    16, 16, 15, 14, 15, 15,
    13, 11, 12, 16, 16, 12,
     9, 14, 14,  8,  9, 13,
    13,  8,  9, 11, 16, 14,
    11, 11, 13, 14, 11, 13,
    13, 14, 14, 13, 14, 15,
    15, 13, 13, 15, 15, 15,
    13, 12, 16, 16, 13, 10,
    13, 13, 10,  6, 11, 16,
    16, 10,  9, 12, 14, 16,
    11, 10, 13, 13, 10, 11,
    12, 16, 14, 12, 12, 15,
    14, 14, 15, 14, 16, 15,
    14, 14, 14, 16, 16, 15,
    12, 14, 15, 13, 11, 11,
    15, 14, 11,  9, 13, 14,
     9, 11, 14, 14, 11, 15,
    13, 15, 16, 12, 13, 14,
    13, 12, 13, 14, 15, 13,
    13, 14, 15, 16, 13, 16,
    16, 15, 15, 13, 13, 15,
    15, 14, 11, 14, 14, 13,
    10, 12, 15, 14, 12, 16,
    13, 16, 16, 14, 16, 14,
    15, 15, 13, 13, 16, 15,
    13, 15, 16, 14, 14, 16,
    16, 16, 15, 15, 15, 15,
    14, 16, 15, 13, 14, 15,
    15, 13, 13, 15, 16, 14,
    12, 14, 14, 16, 15, 14,
    15, 16, 13, 13, 14, 15,
    13, 13, 14, 14, 16, 14,
    14, 14, 15, 14, 16, 15,
    14, 15, 14, 15, 15, 16,
    12, 13, 13, 15, 12, 12,
    13, 13, 16, 16, 12, 13,
    13, 14, 14, 11, 13, 14,
    11, 15, 13, 14, 16, 12,
    12, 12, 13, 11, 13, 13,
    13, 15, 14, 13, 15, 15,
    14, 14, 16, 14, 14, 14,
    14, 15, 14, 11, 11, 13,
    13, 11, 14, 11, 16, 14,
    12,  9, 11, 14, 14, 11,
    10, 12, 13, 10, 11, 12,
    13, 16, 11, 12, 13, 14,
    16, 16, 14, 14, 16, 14,
    13, 15, 16, 14, 15, 13,
    14, 12, 11, 11, 11, 15,
    15, 11,  9, 13, 13,  9,
     9, 14, 14,  9,  9, 11,
    16, 14, 11, 11, 13, 12,
    11, 13, 12, 13, 15, 12,
    13, 13, 15, 14, 14, 15,
    16, 15, 13, 12, 16, 14,
    12, 10, 13, 13, 10,  8,
    10, 16, 14, 10, 13, 15,
    16, 13, 13, 13, 14, 14,
    12, 13, 14, 14, 13, 14,
    14, 14, 14, 14, 13, 14,
    16, 14, 14, 16, 15, 14,
    14, 14, 15, 15, 15, 13,
    15, 16, 13, 13, 14, 14,
    15, 12, 14, 14, 14, 13,
    13, 12, 13, 13, 12, 13,
    13, 13, 12, 13, 13, 14,
    13, 13, 14, 14, 14, 14,
    13, 13, 12, 14, 16, 14,
    14, 15, 14, 14, 13, 12,
    13, 13, 13, 11, 13, 14,
    12, 13, 15, 14, 12, 13,
    13, 14, 12, 12, 13, 14,
    13, 13, 13, 13, 15, 14,
    13, 14, 13, 13, 12, 12,
    13, 13, 12, 14, 13, 13,
    14, 13, 12, 14, 13, 13,
    12, 13, 12, 12, 12, 14,
    15, 14, 13, 16, 13, 15,
    15, 13, 14, 13, 14, 13,
    13, 14, 14, 13, 14, 15,
    13, 15, 16, 13, 13, 13,
    14, 16, 13, 14, 14, 14,
    13, 14, 13, 13, 13, 13,
    14, 14, 14, 13, 11, 14,
    14, 13, 11, 13, 16, 14,
    13, 11, 14, 13, 12, 14,
    13, 16, 14, 13, 13, 15,
    14, 13, 14, 13, 15, 14,
    13, 12, 13, 15, 14, 10,
    12, 14, 13, 10, 12, 15,
    14, 12, 12, 14, 16, 12,
    11, 12, 15, 14, 12, 12,
    13, 13, 11, 12, 12, 13,
    15, 13, 14, 15, 14, 15,
    15, 15, 11, 13, 13, 12,
    14, 13, 11, 11, 13, 13,
    11, 11, 12, 14, 16, 12,
    14, 13, 14, 16, 13, 13,
    13, 15, 13, 13, 14, 13,
    14, 14, 15, 14, 16, 14,
    14, 14, 15, 16, 14, 15,
    13, 15, 12, 12, 15, 14,
    11, 12, 13, 13, 14, 14,
    11, 12, 13, 15, 13, 12,
    14, 14, 13, 13, 12, 12,
    14, 12, 13, 12, 13, 13,
    15, 13, 12, 14, 13, 12,
    16, 13, 12, 13, 15, 12,
    14, 14, 14, 14, 12, 13,
    12, 14, 13, 12, 12, 12,
    13, 14, 12, 13, 13, 14,
    13, 13, 12, 13, 14, 11,
    12, 12, 13, 13, 12, 13,
    14, 15, 14, 14, 13, 14,
    14, 13, 13, 14, 15, 14,
    13, 14, 14, 13, 14, 13,
    12, 13, 13, 13, 12, 14,
    14, 11, 11, 12, 12, 13,
    12, 10, 13, 13, 10, 12,
    11, 12, 12, 11, 13, 13,
    14, 12, 16, 13, 14, 15,
    13, 13, 13, 15, 15, 13,
    13, 14, 16, 14, 13, 12,
    12, 12, 12, 11, 13, 13,
    10, 10, 14, 13, 10, 10,
    11, 11, 11, 10, 10, 12,
    13, 10, 13, 12, 11, 12,
    13, 12, 12, 12, 11, 11,
    12, 13, 12, 13, 13, 12,
    13, 13, 11, 12, 13, 11,
    10, 11, 11, 11, 10, 12,
    12, 13, 12, 12, 11, 13,
    12, 11, 11, 11, 12, 11,
    11, 12, 13, 13, 12, 14,
    11, 12, 14, 12, 12, 11,
    12, 13, 11, 12, 13, 13,
    13, 12, 11, 11, 13, 12,
    10, 13, 12, 11, 13, 15,
    15, 13, 13, 13, 13, 12,
    13, 13, 14, 13, 13, 14,
    14, 13, 13, 14, 11, 13,
    13, 13, 12, 11, 13, 13,
    14, 13, 12, 13, 15, 12,
    14, 13, 13, 13, 13, 15,
    13, 13, 14, 12, 16, 15,
    13,  9, 13, 13, 11, 10,
    12, 14, 14, 12, 11, 14,
    13, 12, 16, 13, 14, 15,
    13, 14, 13, 14, 16, 14,
    11, 12, 15, 12, 11, 11,
    15, 16, 11, 10, 12, 13,
    11, 10, 12, 16, 15, 12,
    11, 12, 13,  9, 10, 12,
    13, 15, 11, 12, 13, 13,
    16, 15, 14, 15, 16, 13,
    13, 14, 16, 13, 12, 12,
    13, 12, 12, 11, 12, 14,
    14, 12, 10, 12, 13, 10,
    13, 13, 14, 13, 13, 13,
    12, 13, 12, 13, 13, 13,
    13, 14, 14, 13, 13, 14,
    13, 13, 13, 11, 13, 12,
    11, 12, 13, 13, 13, 12,
    12, 12, 14, 13, 12, 12,
    12, 12, 13, 13, 11, 11,
    13, 12, 12, 10, 12, 13,
    11, 12, 11, 12, 12, 12,
    13, 13, 14, 12, 13, 12,
    14, 15, 12, 12, 11, 14,
    13, 11, 13, 14, 12, 13,
    11, 11, 12, 11, 10, 10,
    13, 13, 10, 10, 13, 13,
    10, 10, 10, 12, 11, 11,
    10, 12, 13, 11, 13, 12,
    13, 12, 12, 12, 12, 13,
    11, 11, 13, 12, 11, 14,
    13, 13, 12, 12, 11, 13,
    12, 11, 10, 11, 12, 11,
    10,  9, 12, 13,  9,  9,
    10, 10, 10, 10, 10, 12,
    13, 11, 13, 12, 12, 12,
    13, 11, 14, 12, 11, 10,
    11, 11, 10, 13, 13, 12,
    14, 12, 11, 13, 12, 11,
     9, 10, 10, 10, 10, 10,
    10, 10, 11, 10,  9, 12,
    12,  9, 10, 10, 10, 10,
    11, 11, 12, 13, 13, 11,
    11, 15, 14, 11, 10, 10,
    12, 16, 10, 12, 12, 14,
    12, 11, 10, 10, 10, 10,
     9, 13, 12,  9, 11, 13,
    13, 11, 10, 11, 11, 11,
    10, 10, 12, 12, 11, 13,
    11, 11, 13, 13, 11, 13,
    13, 11, 10, 11, 15, 10,
    13, 12, 12, 15, 12, 11,
    12, 13, 11, 11, 11, 11,
    10, 10, 13, 13, 14, 14,
    13, 13, 14, 13, 12, 13,
    13, 15, 13, 12, 13, 14,
    14, 13, 11, 12, 13, 15,
    12, 12, 11, 13, 16, 14,
    14, 14, 14, 14, 12, 13,
    13, 13, 12, 12, 14, 14,
    12,  9, 14, 14, 10,  9,
    11, 16, 14, 11, 16, 13,
    13, 10, 11, 12, 15, 14,
    12, 14, 14, 14, 13, 13,
    13, 16, 16, 11, 11, 16,
    15, 12,  9, 13, 14, 10,
    10, 11, 14, 15, 11, 11,
    13, 14, 10,  9, 11, 15,
    15, 11, 10, 13, 12,  9,
    11, 13, 15, 14, 11, 13,
    14, 13, 13, 13, 13, 14,
    13, 16, 13, 15, 13, 12,
    10, 13, 13, 10, 10, 11,
    13, 15, 11, 13, 12, 13,
    13, 13, 12, 13, 13, 12,
    13, 12, 13, 12, 13, 13,
    15, 14, 13, 11, 12, 14,
    14, 11, 12, 14, 16, 13,
    13, 13, 14, 13, 12, 13,
    12, 12, 13, 12, 12, 13,
    14, 12, 10, 13, 13, 11,
    10, 10, 12, 11, 11, 11,
    13, 12, 11, 13, 12, 13,
    12, 12, 11, 13, 12, 10,
    10, 13, 11, 11, 13, 13,
    12, 11, 12, 11, 12, 12,
    10, 10, 10, 11, 11, 11,
     9, 10, 11, 10, 11,  9,
    11, 12,  9, 10, 10, 10,
    10, 11, 12, 13, 14, 12,
    10, 11, 13, 13, 11, 10,
    10, 12, 12, 11, 13, 13,
    13, 12, 10, 11, 11, 10,
    10,  9, 12, 11,  8,
};

static const uint16_t on2avc_cb8_syms[ON2AVC_CB8_CODES] = {
    0x0000, 0x0002, 0x0004, 0x000C, 0x000E, 0x0011,
    0x0013, 0x001D, 0x001F, 0x0020, 0x0022, 0x0024,
    0x002C, 0x002E, 0x0031, 0x0033, 0x003D, 0x003F,
    0x0040, 0x0042, 0x0044, 0x004C, 0x004E, 0x00C0,
    0x00C2, 0x00C4, 0x00CC, 0x00CE, 0x00D1, 0x00D3,
    0x00DD, 0x00DF, 0x00E0, 0x00E2, 0x00E4, 0x00EC,
    0x00EE, 0x00F1, 0x00F3, 0x00FD, 0x00FF, 0x0101,
    0x0103, 0x010D, 0x010F, 0x0110, 0x0112, 0x0114,
    0x011C, 0x011E, 0x0121, 0x0123, 0x012D, 0x012F,
    0x0130, 0x0132, 0x0134, 0x013C, 0x013E, 0x0141,
    0x0143, 0x014D, 0x014F, 0x01C1, 0x01C3, 0x01CD,
    0x01CF, 0x01D0, 0x01D2, 0x01D4, 0x01DC, 0x01DE,
    0x01E1, 0x01E3, 0x01ED, 0x01EF, 0x01F0, 0x01F2,
    0x01F4, 0x01FC, 0x01FE, 0x0200, 0x0202, 0x0204,
    0x020C, 0x020E, 0x0211, 0x0213, 0x021D, 0x021F,
    0x0220, 0x0222, 0x0224, 0x022C, 0x022E, 0x0231,
    0x0233, 0x023D, 0x023F, 0x0240, 0x0242, 0x0244,
    0x024C, 0x024E, 0x02C0, 0x02C2, 0x02C4, 0x02CC,
    0x02CE, 0x02D1, 0x02D3, 0x02DD, 0x02DF, 0x02E0,
    0x02E2, 0x02E4, 0x02EC, 0x02EE, 0x02F1, 0x02F3,
    0x02FD, 0x02FF, 0x0301, 0x0303, 0x030D, 0x030F,
    0x0310, 0x0312, 0x0314, 0x031C, 0x031E, 0x0321,
    0x0323, 0x032D, 0x032F, 0x0330, 0x0332, 0x0334,
    0x033C, 0x033E, 0x0341, 0x0343, 0x034D, 0x034F,
    0x03C1, 0x03C3, 0x03CD, 0x03CF, 0x03D0, 0x03D2,
    0x03D4, 0x03DC, 0x03DE, 0x03E1, 0x03E3, 0x03ED,
    0x03EF, 0x03F0, 0x03F2, 0x03F4, 0x03FC, 0x03FE,
    0x0400, 0x0402, 0x0404, 0x040C, 0x040E, 0x0411,
    0x0413, 0x041D, 0x041F, 0x0420, 0x0422, 0x0424,
    0x042C, 0x042E, 0x0431, 0x0433, 0x043D, 0x043F,
    0x0440, 0x0442, 0x0444, 0x044C, 0x044E, 0x04C0,
    0x04C2, 0x04C4, 0x04CC, 0x04CE, 0x04D1, 0x04D3,
    0x04DD, 0x04DF, 0x04E0, 0x04E2, 0x04E4, 0x04EC,
    0x04EE, 0x04F1, 0x04F3, 0x04FD, 0x04FF, 0x0C00,
    0x0C02, 0x0C04, 0x0C0C, 0x0C0E, 0x0C11, 0x0C13,
    0x0C1D, 0x0C1F, 0x0C20, 0x0C22, 0x0C24, 0x0C2C,
    0x0C2E, 0x0C31, 0x0C33, 0x0C3D, 0x0C3F, 0x0C40,
    0x0C42, 0x0C44, 0x0C4C, 0x0C4E, 0x0CC0, 0x0CC2,
    0x0CC4, 0x0CCC, 0x0CCE, 0x0CD1, 0x0CD3, 0x0CDD,
    0x0CDF, 0x0CE0, 0x0CE2, 0x0CE4, 0x0CEC, 0x0CEE,
    0x0CF1, 0x0CF3, 0x0CFD, 0x0CFF, 0x0D01, 0x0D03,
    0x0D0D, 0x0D0F, 0x0D10, 0x0D12, 0x0D14, 0x0D1C,
    0x0D1E, 0x0D21, 0x0D23, 0x0D2D, 0x0D2F, 0x0D30,
    0x0D32, 0x0D34, 0x0D3C, 0x0D3E, 0x0D41, 0x0D43,
    0x0D4D, 0x0D4F, 0x0DC1, 0x0DC3, 0x0DCD, 0x0DCF,
    0x0DD0, 0x0DD2, 0x0DD4, 0x0DDC, 0x0DDE, 0x0DE1,
    0x0DE3, 0x0DED, 0x0DEF, 0x0DF0, 0x0DF2, 0x0DF4,
    0x0DFC, 0x0DFE, 0x0E00, 0x0E02, 0x0E04, 0x0E0C,
    0x0E0E, 0x0E11, 0x0E13, 0x0E1D, 0x0E1F, 0x0E20,
    0x0E22, 0x0E24, 0x0E2C, 0x0E2E, 0x0E31, 0x0E33,
    0x0E3D, 0x0E3F, 0x0E40, 0x0E42, 0x0E44, 0x0E4C,
    0x0E4E, 0x0EC0, 0x0EC2, 0x0EC4, 0x0ECC, 0x0ECE,
    0x0ED1, 0x0ED3, 0x0EDD, 0x0EDF, 0x0EE0, 0x0EE2,
    0x0EE4, 0x0EEC, 0x0EEE, 0x0EF1, 0x0EF3, 0x0EFD,
    0x0EFF, 0x0F01, 0x0F03, 0x0F0D, 0x0F0F, 0x0F10,
    0x0F12, 0x0F14, 0x0F1C, 0x0F1E, 0x0F21, 0x0F23,
    0x0F2D, 0x0F2F, 0x0F30, 0x0F32, 0x0F34, 0x0F3C,
    0x0F3E, 0x0F41, 0x0F43, 0x0F4D, 0x0F4F, 0x0FC1,
    0x0FC3, 0x0FCD, 0x0FCF, 0x0FD0, 0x0FD2, 0x0FD4,
    0x0FDC, 0x0FDE, 0x0FE1, 0x0FE3, 0x0FED, 0x0FEF,
    0x0FF0, 0x0FF2, 0x0FF4, 0x0FFC, 0x0FFE, 0x1001,
    0x1003, 0x100D, 0x100F, 0x1010, 0x1012, 0x1014,
    0x101C, 0x101E, 0x1021, 0x1023, 0x102D, 0x102F,
    0x1030, 0x1032, 0x1034, 0x103C, 0x103E, 0x1041,
    0x1043, 0x104D, 0x104F, 0x10C1, 0x10C3, 0x10CD,
    0x10CF, 0x10D0, 0x10D2, 0x10D4, 0x10DC, 0x10DE,
    0x10E1, 0x10E3, 0x10ED, 0x10EF, 0x10F0, 0x10F2,
    0x10F4, 0x10FC, 0x10FE, 0x1100, 0x1102, 0x1104,
    0x110C, 0x110E, 0x1111, 0x1113, 0x111D, 0x111F,
    0x1120, 0x1122, 0x1124, 0x112C, 0x112E, 0x1131,
    0x1133, 0x113D, 0x113F, 0x1140, 0x1142, 0x1144,
    0x114C, 0x114E, 0x11C0, 0x11C2, 0x11C4, 0x11CC,
    0x11CE, 0x11D1, 0x11D3, 0x11DD, 0x11DF, 0x11E0,
    0x11E2, 0x11E4, 0x11EC, 0x11EE, 0x11F1, 0x11F3,
    0x11FD, 0x11FF, 0x1201, 0x1203, 0x120D, 0x120F,
    0x1210, 0x1212, 0x1214, 0x121C, 0x121E, 0x1221,
    0x1223, 0x122D, 0x122F, 0x1230, 0x1232, 0x1234,
    0x123C, 0x123E, 0x1241, 0x1243, 0x124D, 0x124F,
    0x12C1, 0x12C3, 0x12CD, 0x12CF, 0x12D0, 0x12D2,
    0x12D4, 0x12DC, 0x12DE, 0x12E1, 0x12E3, 0x12ED,
    0x12EF, 0x12F0, 0x12F2, 0x12F4, 0x12FC, 0x12FE,
    0x1300, 0x1302, 0x1304, 0x130C, 0x130E, 0x1311,
    0x1313, 0x131D, 0x131F, 0x1320, 0x1322, 0x1324,
    0x132C, 0x132E, 0x1331, 0x1333, 0x133D, 0x133F,
    0x1340, 0x1342, 0x1344, 0x134C, 0x134E, 0x13C0,
    0x13C2, 0x13C4, 0x13CC, 0x13CE, 0x13D1, 0x13D3,
    0x13DD, 0x13DF, 0x13E0, 0x13E2, 0x13E4, 0x13EC,
    0x13EE, 0x13F1, 0x13F3, 0x13FD, 0x13FF, 0x1401,
    0x1403, 0x140D, 0x140F, 0x1410, 0x1412, 0x1414,
    0x141C, 0x141E, 0x1421, 0x1423, 0x142D, 0x142F,
    0x1430, 0x1432, 0x1434, 0x143C, 0x143E, 0x1441,
    0x1443, 0x144D, 0x144F, 0x14C1, 0x14C3, 0x14CD,
    0x14CF, 0x14D0, 0x14D2, 0x14D4, 0x14DC, 0x14DE,
    0x14E1, 0x14E3, 0x14ED, 0x14EF, 0x14F0, 0x14F2,
    0x14F4, 0x14FC, 0x14FE, 0x1C01, 0x1C03, 0x1C0D,
    0x1C0F, 0x1C10, 0x1C12, 0x1C14, 0x1C1C, 0x1C1E,
    0x1C21, 0x1C23, 0x1C2D, 0x1C2F, 0x1C30, 0x1C32,
    0x1C34, 0x1C3C, 0x1C3E, 0x1C41, 0x1C43, 0x1C4D,
    0x1C4F, 0x1CC1, 0x1CC3, 0x1CCD, 0x1CCF, 0x1CD0,
    0x1CD2, 0x1CD4, 0x1CDC, 0x1CDE, 0x1CE1, 0x1CE3,
    0x1CED, 0x1CEF, 0x1CF0, 0x1CF2, 0x1CF4, 0x1CFC,
    0x1CFE, 0x1D00, 0x1D02, 0x1D04, 0x1D0C, 0x1D0E,
    0x1D11, 0x1D13, 0x1D1D, 0x1D1F, 0x1D20, 0x1D22,
    0x1D24, 0x1D2C, 0x1D2E, 0x1D31, 0x1D33, 0x1D3D,
    0x1D3F, 0x1D40, 0x1D42, 0x1D44, 0x1D4C, 0x1D4E,
    0x1DC0, 0x1DC2, 0x1DC4, 0x1DCC, 0x1DCE, 0x1DD1,
    0x1DD3, 0x1DDD, 0x1DDF, 0x1DE0, 0x1DE2, 0x1DE4,
    0x1DEC, 0x1DEE, 0x1DF1, 0x1DF3, 0x1DFD, 0x1DFF,
    0x1E01, 0x1E03, 0x1E0D, 0x1E0F, 0x1E10, 0x1E12,
    0x1E14, 0x1E1C, 0x1E1E, 0x1E21, 0x1E23, 0x1E2D,
    0x1E2F, 0x1E30, 0x1E32, 0x1E34, 0x1E3C, 0x1E3E,
    0x1E41, 0x1E43, 0x1E4D, 0x1E4F, 0x1EC1, 0x1EC3,
    0x1ECD, 0x1ECF, 0x1ED0, 0x1ED2, 0x1ED4, 0x1EDC,
    0x1EDE, 0x1EE1, 0x1EE3, 0x1EED, 0x1EEF, 0x1EF0,
    0x1EF2, 0x1EF4, 0x1EFC, 0x1EFE, 0x1F00, 0x1F02,
    0x1F04, 0x1F0C, 0x1F0E, 0x1F11, 0x1F13, 0x1F1D,
    0x1F1F, 0x1F20, 0x1F22, 0x1F24, 0x1F2C, 0x1F2E,
    0x1F31, 0x1F33, 0x1F3D, 0x1F3F, 0x1F40, 0x1F42,
    0x1F44, 0x1F4C, 0x1F4E, 0x1FC0, 0x1FC2, 0x1FC4,
    0x1FCC, 0x1FCE, 0x1FD1, 0x1FD3, 0x1FDD, 0x1FDF,
    0x1FE0, 0x1FE2, 0x1FE4, 0x1FEC, 0x1FEE, 0x1FF1,
    0x1FF3, 0x1FFD, 0x1FFF, 0x2000, 0x2002, 0x2004,
    0x200C, 0x200E, 0x2011, 0x2013, 0x201D, 0x201F,
    0x2020, 0x2022, 0x2024, 0x202C, 0x202E, 0x2031,
    0x2033, 0x203D, 0x203F, 0x2040, 0x2042, 0x2044,
    0x204C, 0x204E, 0x20C0, 0x20C2, 0x20C4, 0x20CC,
    0x20CE, 0x20D1, 0x20D3, 0x20DD, 0x20DF, 0x20E0,
    0x20E2, 0x20E4, 0x20EC, 0x20EE, 0x20F1, 0x20F3,
    0x20FD, 0x20FF, 0x2101, 0x2103, 0x210D, 0x210F,
    0x2110, 0x2112, 0x2114, 0x211C, 0x211E, 0x2121,
    0x2123, 0x212D, 0x212F, 0x2130, 0x2132, 0x2134,
    0x213C, 0x213E, 0x2141, 0x2143, 0x214D, 0x214F,
    0x21C1, 0x21C3, 0x21CD, 0x21CF, 0x21D0, 0x21D2,
    0x21D4, 0x21DC, 0x21DE, 0x21E1, 0x21E3, 0x21ED,
    0x21EF, 0x21F0, 0x21F2, 0x21F4, 0x21FC, 0x21FE,
    0x2200, 0x2202, 0x2204, 0x220C, 0x220E, 0x2211,
    0x2213, 0x221D, 0x221F, 0x2220, 0x2222, 0x2224,
    0x222C, 0x222E, 0x2231, 0x2233, 0x223D, 0x223F,
    0x2240, 0x2242, 0x2244, 0x224C, 0x224E, 0x22C0,
    0x22C2, 0x22C4, 0x22CC, 0x22CE, 0x22D1, 0x22D3,
    0x22DD, 0x22DF, 0x22E0, 0x22E2, 0x22E4, 0x22EC,
    0x22EE, 0x22F1, 0x22F3, 0x22FD, 0x22FF, 0x2301,
    0x2303, 0x230D, 0x230F, 0x2310, 0x2312, 0x2314,
    0x231C, 0x231E, 0x2321, 0x2323, 0x232D, 0x232F,
    0x2330, 0x2332, 0x2334, 0x233C, 0x233E, 0x2341,
    0x2343, 0x234D, 0x234F, 0x23C1, 0x23C3, 0x23CD,
    0x23CF, 0x23D0, 0x23D2, 0x23D4, 0x23DC, 0x23DE,
    0x23E1, 0x23E3, 0x23ED, 0x23EF, 0x23F0, 0x23F2,
    0x23F4, 0x23FC, 0x23FE, 0x2400, 0x2402, 0x2404,
    0x240C, 0x240E, 0x2411, 0x2413, 0x241D, 0x241F,
    0x2420, 0x2422, 0x2424, 0x242C, 0x242E, 0x2431,
    0x2433, 0x243D, 0x243F, 0x2440, 0x2442, 0x2444,
    0x244C, 0x244E, 0x24C0, 0x24C2, 0x24C4, 0x24CC,
    0x24CE, 0x24D1, 0x24D3, 0x24DD, 0x24DF, 0x24E0,
    0x24E2, 0x24E4, 0x24EC, 0x24EE, 0x24F1, 0x24F3,
    0x24FD, 0x24FF, 0x2C00, 0x2C02, 0x2C04, 0x2C0C,
    0x2C0E, 0x2C11, 0x2C13, 0x2C1D, 0x2C1F, 0x2C20,
    0x2C22, 0x2C24, 0x2C2C, 0x2C2E, 0x2C31, 0x2C33,
    0x2C3D, 0x2C3F, 0x2C40, 0x2C42, 0x2C44, 0x2C4C,
    0x2C4E, 0x2CC0, 0x2CC2, 0x2CC4, 0x2CCC, 0x2CCE,
    0x2CD1, 0x2CD3, 0x2CDD, 0x2CDF, 0x2CE0, 0x2CE2,
    0x2CE4, 0x2CEC, 0x2CEE, 0x2CF1, 0x2CF3, 0x2CFD,
    0x2CFF, 0x2D01, 0x2D03, 0x2D0D, 0x2D0F, 0x2D10,
    0x2D12, 0x2D14, 0x2D1C, 0x2D1E, 0x2D21, 0x2D23,
    0x2D2D, 0x2D2F, 0x2D30, 0x2D32, 0x2D34, 0x2D3C,
    0x2D3E, 0x2D41, 0x2D43, 0x2D4D, 0x2D4F, 0x2DC1,
    0x2DC3, 0x2DCD, 0x2DCF, 0x2DD0, 0x2DD2, 0x2DD4,
    0x2DDC, 0x2DDE, 0x2DE1, 0x2DE3, 0x2DED, 0x2DEF,
    0x2DF0, 0x2DF2, 0x2DF4, 0x2DFC, 0x2DFE, 0x2E00,
    0x2E02, 0x2E04, 0x2E0C, 0x2E0E, 0x2E11, 0x2E13,
    0x2E1D, 0x2E1F, 0x2E20, 0x2E22, 0x2E24, 0x2E2C,
    0x2E2E, 0x2E31, 0x2E33, 0x2E3D, 0x2E3F, 0x2E40,
    0x2E42, 0x2E44, 0x2E4C, 0x2E4E, 0x2EC0, 0x2EC2,
    0x2EC4, 0x2ECC, 0x2ECE, 0x2ED1, 0x2ED3, 0x2EDD,
    0x2EDF, 0x2EE0, 0x2EE2, 0x2EE4, 0x2EEC, 0x2EEE,
    0x2EF1, 0x2EF3, 0x2EFD, 0x2EFF, 0x2F01, 0x2F03,
    0x2F0D, 0x2F0F, 0x2F10, 0x2F12, 0x2F14, 0x2F1C,
    0x2F1E, 0x2F21, 0x2F23, 0x2F2D, 0x2F2F, 0x2F30,
    0x2F32, 0x2F34, 0x2F3C, 0x2F3E, 0x2F41, 0x2F43,
    0x2F4D, 0x2F4F, 0x2FC1, 0x2FC3, 0x2FCD, 0x2FCF,
    0x2FD0, 0x2FD2, 0x2FD4, 0x2FDC, 0x2FDE, 0x2FE1,
    0x2FE3, 0x2FED, 0x2FEF, 0x2FF0, 0x2FF2, 0x2FF4,
    0x2FFC, 0x2FFE, 0x3001, 0x3003, 0x300D, 0x300F,
    0x3010, 0x3012, 0x3014, 0x301C, 0x301E, 0x3021,
    0x3023, 0x302D, 0x302F, 0x3030, 0x3032, 0x3034,
    0x303C, 0x303E, 0x3041, 0x3043, 0x304D, 0x304F,
    0x30C1, 0x30C3, 0x30CD, 0x30CF, 0x30D0, 0x30D2,
    0x30D4, 0x30DC, 0x30DE, 0x30E1, 0x30E3, 0x30ED,
    0x30EF, 0x30F0, 0x30F2, 0x30F4, 0x30FC, 0x30FE,
    0x3100, 0x3102, 0x3104, 0x310C, 0x310E, 0x3111,
    0x3113, 0x311D, 0x311F, 0x3120, 0x3122, 0x3124,
    0x312C, 0x312E, 0x3131, 0x3133, 0x313D, 0x313F,
    0x3140, 0x3142, 0x3144, 0x314C, 0x314E, 0x31C0,
    0x31C2, 0x31C4, 0x31CC, 0x31CE, 0x31D1, 0x31D3,
    0x31DD, 0x31DF, 0x31E0, 0x31E2, 0x31E4, 0x31EC,
    0x31EE, 0x31F1, 0x31F3, 0x31FD, 0x31FF, 0x3201,
    0x3203, 0x320D, 0x320F, 0x3210, 0x3212, 0x3214,
    0x321C, 0x321E, 0x3221, 0x3223, 0x322D, 0x322F,
    0x3230, 0x3232, 0x3234, 0x323C, 0x323E, 0x3241,
    0x3243, 0x324D, 0x324F, 0x32C1, 0x32C3, 0x32CD,
    0x32CF, 0x32D0, 0x32D2, 0x32D4, 0x32DC, 0x32DE,
    0x32E1, 0x32E3, 0x32ED, 0x32EF, 0x32F0, 0x32F2,
    0x32F4, 0x32FC, 0x32FE, 0x3300, 0x3302, 0x3304,
    0x330C, 0x330E, 0x3311, 0x3313, 0x331D, 0x331F,
    0x3320, 0x3322, 0x3324, 0x332C, 0x332E, 0x3331,
    0x3333, 0x333D, 0x333F, 0x3340, 0x3342, 0x3344,
    0x334C, 0x334E, 0x33C0, 0x33C2, 0x33C4, 0x33CC,
    0x33CE, 0x33D1, 0x33D3, 0x33DD, 0x33DF, 0x33E0,
    0x33E2, 0x33E4, 0x33EC, 0x33EE, 0x33F1, 0x33F3,
    0x33FD, 0x33FF, 0x3401, 0x3403, 0x340D, 0x340F,
    0x3410, 0x3412, 0x3414, 0x341C, 0x341E, 0x3421,
    0x3423, 0x342D, 0x342F, 0x3430, 0x3432, 0x3434,
    0x343C, 0x343E, 0x3441, 0x3443, 0x344D, 0x344F,
    0x34C1, 0x34C3, 0x34CD, 0x34CF, 0x34D0, 0x34D2,
    0x34D4, 0x34DC, 0x34DE, 0x34E1, 0x34E3, 0x34ED,
    0x34EF, 0x34F0, 0x34F2, 0x34F4, 0x34FC, 0x34FE,
    0x3C01, 0x3C03, 0x3C0D, 0x3C0F, 0x3C10, 0x3C12,
    0x3C14, 0x3C1C, 0x3C1E, 0x3C21, 0x3C23, 0x3C2D,
    0x3C2F, 0x3C30, 0x3C32, 0x3C34, 0x3C3C, 0x3C3E,
    0x3C41, 0x3C43, 0x3C4D, 0x3C4F, 0x3CC1, 0x3CC3,
    0x3CCD, 0x3CCF, 0x3CD0, 0x3CD2, 0x3CD4, 0x3CDC,
    0x3CDE, 0x3CE1, 0x3CE3, 0x3CED, 0x3CEF, 0x3CF0,
    0x3CF2, 0x3CF4, 0x3CFC, 0x3CFE, 0x3D00, 0x3D02,
    0x3D04, 0x3D0C, 0x3D0E, 0x3D11, 0x3D13, 0x3D1D,
    0x3D1F, 0x3D20, 0x3D22, 0x3D24, 0x3D2C, 0x3D2E,
    0x3D31, 0x3D33, 0x3D3D, 0x3D3F, 0x3D40, 0x3D42,
    0x3D44, 0x3D4C, 0x3D4E, 0x3DC0, 0x3DC2, 0x3DC4,
    0x3DCC, 0x3DCE, 0x3DD1, 0x3DD3, 0x3DDD, 0x3DDF,
    0x3DE0, 0x3DE2, 0x3DE4, 0x3DEC, 0x3DEE, 0x3DF1,
    0x3DF3, 0x3DFD, 0x3DFF, 0x3E01, 0x3E03, 0x3E0D,
    0x3E0F, 0x3E10, 0x3E12, 0x3E14, 0x3E1C, 0x3E1E,
    0x3E21, 0x3E23, 0x3E2D, 0x3E2F, 0x3E30, 0x3E32,
    0x3E34, 0x3E3C, 0x3E3E, 0x3E41, 0x3E43, 0x3E4D,
    0x3E4F, 0x3EC1, 0x3EC3, 0x3ECD, 0x3ECF, 0x3ED0,
    0x3ED2, 0x3ED4, 0x3EDC, 0x3EDE, 0x3EE1, 0x3EE3,
    0x3EED, 0x3EEF, 0x3EF0, 0x3EF2, 0x3EF4, 0x3EFC,
    0x3EFE, 0x3F00, 0x3F02, 0x3F04, 0x3F0C, 0x3F0E,
    0x3F11, 0x3F13, 0x3F1D, 0x3F1F, 0x3F20, 0x3F22,
    0x3F24, 0x3F2C, 0x3F2E, 0x3F31, 0x3F33, 0x3F3D,
    0x3F3F, 0x3F40, 0x3F42, 0x3F44, 0x3F4C, 0x3F4E,
    0x3FC0, 0x3FC2, 0x3FC4, 0x3FCC, 0x3FCE, 0x3FD1,
    0x3FD3, 0x3FDD, 0x3FDF, 0x3FE0, 0x3FE2, 0x3FE4,
    0x3FEC, 0x3FEE, 0x3FF1, 0x3FF3, 0x3FFD, 0x3FFF,
    0x4000, 0x4002, 0x4004, 0x400C, 0x400E, 0x4011,
    0x4013, 0x401D, 0x401F, 0x4020, 0x4022, 0x4024,
    0x402C, 0x402E, 0x4031, 0x4033, 0x403D, 0x403F,
    0x4040, 0x4042, 0x4044, 0x404C, 0x404E, 0x40C0,
    0x40C2, 0x40C4, 0x40CC, 0x40CE, 0x40D1, 0x40D3,
    0x40DD, 0x40DF, 0x40E0, 0x40E2, 0x40E4, 0x40EC,
    0x40EE, 0x40F1, 0x40F3, 0x40FD, 0x40FF, 0x4101,
    0x4103, 0x410D, 0x410F, 0x4110, 0x4112, 0x4114,
    0x411C, 0x411E, 0x4121, 0x4123, 0x412D, 0x412F,
    0x4130, 0x4132, 0x4134, 0x413C, 0x413E, 0x4141,
    0x4143, 0x414D, 0x414F, 0x41C1, 0x41C3, 0x41CD,
    0x41CF, 0x41D0, 0x41D2, 0x41D4, 0x41DC, 0x41DE,
    0x41E1, 0x41E3, 0x41ED, 0x41EF, 0x41F0, 0x41F2,
    0x41F4, 0x41FC, 0x41FE, 0x4200, 0x4202, 0x4204,
    0x420C, 0x420E, 0x4211, 0x4213, 0x421D, 0x421F,
    0x4220, 0x4222, 0x4224, 0x422C, 0x422E, 0x4231,
    0x4233, 0x423D, 0x423F, 0x4240, 0x4242, 0x4244,
    0x424C, 0x424E, 0x42C0, 0x42C2, 0x42C4, 0x42CC,
    0x42CE, 0x42D1, 0x42D3, 0x42DD, 0x42DF, 0x42E0,
    0x42E2, 0x42E4, 0x42EC, 0x42EE, 0x42F1, 0x42F3,
    0x42FD, 0x42FF, 0x4301, 0x4303, 0x430D, 0x430F,
    0x4310, 0x4312, 0x4314, 0x431C, 0x431E, 0x4321,
    0x4323, 0x432D, 0x432F, 0x4330, 0x4332, 0x4334,
    0x433C, 0x433E, 0x4341, 0x4343, 0x434D, 0x434F,
    0x43C1, 0x43C3, 0x43CD, 0x43CF, 0x43D0, 0x43D2,
    0x43D4, 0x43DC, 0x43DE, 0x43E1, 0x43E3, 0x43ED,
    0x43EF, 0x43F0, 0x43F2, 0x43F4, 0x43FC, 0x43FE,
    0x4400, 0x4402, 0x4404, 0x440C, 0x440E, 0x4411,
    0x4413, 0x441D, 0x441F, 0x4420, 0x4422, 0x4424,
    0x442C, 0x442E, 0x4431, 0x4433, 0x443D, 0x443F,
    0x4440, 0x4442, 0x4444, 0x444C, 0x444E, 0x44C0,
    0x44C2, 0x44C4, 0x44CC, 0x44CE, 0x44D1, 0x44D3,
    0x44DD, 0x44DF, 0x44E0, 0x44E2, 0x44E4, 0x44EC,
    0x44EE, 0x44F1, 0x44F3, 0x44FD, 0x44FF, 0x4C00,
    0x4C02, 0x4C04, 0x4C0C, 0x4C0E, 0x4C11, 0x4C13,
    0x4C1D, 0x4C1F, 0x4C20, 0x4C22, 0x4C24, 0x4C2C,
    0x4C2E, 0x4C31, 0x4C33, 0x4C3D, 0x4C3F, 0x4C40,
    0x4C42, 0x4C44, 0x4C4C, 0x4C4E, 0x4CC0, 0x4CC2,
    0x4CC4, 0x4CCC, 0x4CCE, 0x4CD1, 0x4CD3, 0x4CDD,
    0x4CDF, 0x4CE0, 0x4CE2, 0x4CE4, 0x4CEC, 0x4CEE,
    0x4CF1, 0x4CF3, 0x4CFD, 0x4CFF, 0x4D01, 0x4D03,
    0x4D0D, 0x4D0F, 0x4D10, 0x4D12, 0x4D14, 0x4D1C,
    0x4D1E, 0x4D21, 0x4D23, 0x4D2D, 0x4D2F, 0x4D30,
    0x4D32, 0x4D34, 0x4D3C, 0x4D3E, 0x4D41, 0x4D43,
    0x4D4D, 0x4D4F, 0x4DC1, 0x4DC3, 0x4DCD, 0x4DCF,
    0x4DD0, 0x4DD2, 0x4DD4, 0x4DDC, 0x4DDE, 0x4DE1,
    0x4DE3, 0x4DED, 0x4DEF, 0x4DF0, 0x4DF2, 0x4DF4,
    0x4DFC, 0x4DFE, 0x4E00, 0x4E02, 0x4E04, 0x4E0C,
    0x4E0E, 0x4E11, 0x4E13, 0x4E1D, 0x4E1F, 0x4E20,
    0x4E22, 0x4E24, 0x4E2C, 0x4E2E, 0x4E31, 0x4E33,
    0x4E3D, 0x4E3F, 0x4E40, 0x4E42, 0x4E44, 0x4E4C,
    0x4E4E, 0x4EC0, 0x4EC2, 0x4EC4, 0x4ECC, 0x4ECE,
    0x4ED1, 0x4ED3, 0x4EDD, 0x4EDF, 0x4EE0, 0x4EE2,
    0x4EE4, 0x4EEC, 0x4EEE, 0x4EF1, 0x4EF3, 0x4EFD,
    0x4EFF, 0x4F01, 0x4F03, 0x4F0D, 0x4F0F, 0x4F10,
    0x4F12, 0x4F14, 0x4F1C, 0x4F1E, 0x4F21, 0x4F23,
    0x4F2D, 0x4F2F, 0x4F30, 0x4F32, 0x4F34, 0x4F3C,
    0x4F3E, 0x4F41, 0x4F43, 0x4F4D, 0x4F4F, 0x4FC1,
    0x4FC3, 0x4FCD, 0x4FCF, 0x4FD0, 0x4FD2, 0x4FD4,
    0x4FDC, 0x4FDE, 0x4FE1, 0x4FE3, 0x4FED, 0x4FEF,
    0x4FF0, 0x4FF2, 0x4FF4, 0x4FFC, 0x4FFE, 0xC000,
    0xC002, 0xC004, 0xC00C, 0xC00E, 0xC011, 0xC013,
    0xC01D, 0xC01F, 0xC020, 0xC022, 0xC024, 0xC02C,
    0xC02E, 0xC031, 0xC033, 0xC03D, 0xC03F, 0xC040,
    0xC042, 0xC044, 0xC04C, 0xC04E, 0xC0C0, 0xC0C2,
    0xC0C4, 0xC0CC, 0xC0CE, 0xC0D1, 0xC0D3, 0xC0DD,
    0xC0DF, 0xC0E0, 0xC0E2, 0xC0E4, 0xC0EC, 0xC0EE,
    0xC0F1, 0xC0F3, 0xC0FD, 0xC0FF, 0xC101, 0xC103,
    0xC10D, 0xC10F, 0xC110, 0xC112, 0xC114, 0xC11C,
    0xC11E, 0xC121, 0xC123, 0xC12D, 0xC12F, 0xC130,
    0xC132, 0xC134, 0xC13C, 0xC13E, 0xC141, 0xC143,
    0xC14D, 0xC14F, 0xC1C1, 0xC1C3, 0xC1CD, 0xC1CF,
    0xC1D0, 0xC1D2, 0xC1D4, 0xC1DC, 0xC1DE, 0xC1E1,
    0xC1E3, 0xC1ED, 0xC1EF, 0xC1F0, 0xC1F2, 0xC1F4,
    0xC1FC, 0xC1FE, 0xC200, 0xC202, 0xC204, 0xC20C,
    0xC20E, 0xC211, 0xC213, 0xC21D, 0xC21F, 0xC220,
    0xC222, 0xC224, 0xC22C, 0xC22E, 0xC231, 0xC233,
    0xC23D, 0xC23F, 0xC240, 0xC242, 0xC244, 0xC24C,
    0xC24E, 0xC2C0, 0xC2C2, 0xC2C4, 0xC2CC, 0xC2CE,
    0xC2D1, 0xC2D3, 0xC2DD, 0xC2DF, 0xC2E0, 0xC2E2,
    0xC2E4, 0xC2EC, 0xC2EE, 0xC2F1, 0xC2F3, 0xC2FD,
    0xC2FF, 0xC301, 0xC303, 0xC30D, 0xC30F, 0xC310,
    0xC312, 0xC314, 0xC31C, 0xC31E, 0xC321, 0xC323,
    0xC32D, 0xC32F, 0xC330, 0xC332, 0xC334, 0xC33C,
    0xC33E, 0xC341, 0xC343, 0xC34D, 0xC34F, 0xC3C1,
    0xC3C3, 0xC3CD, 0xC3CF, 0xC3D0, 0xC3D2, 0xC3D4,
    0xC3DC, 0xC3DE, 0xC3E1, 0xC3E3, 0xC3ED, 0xC3EF,
    0xC3F0, 0xC3F2, 0xC3F4, 0xC3FC, 0xC3FE, 0xC400,
    0xC402, 0xC404, 0xC40C, 0xC40E, 0xC411, 0xC413,
    0xC41D, 0xC41F, 0xC420, 0xC422, 0xC424, 0xC42C,
    0xC42E, 0xC431, 0xC433, 0xC43D, 0xC43F, 0xC440,
    0xC442, 0xC444, 0xC44C, 0xC44E, 0xC4C0, 0xC4C2,
    0xC4C4, 0xC4CC, 0xC4CE, 0xC4D1, 0xC4D3, 0xC4DD,
    0xC4DF, 0xC4E0, 0xC4E2, 0xC4E4, 0xC4EC, 0xC4EE,
    0xC4F1, 0xC4F3, 0xC4FD, 0xC4FF, 0xCC00, 0xCC02,
    0xCC04, 0xCC0C, 0xCC0E, 0xCC11, 0xCC13, 0xCC1D,
    0xCC1F, 0xCC20, 0xCC22, 0xCC24, 0xCC2C, 0xCC2E,
    0xCC31, 0xCC33, 0xCC3D, 0xCC3F, 0xCC40, 0xCC42,
    0xCC44, 0xCC4C, 0xCC4E, 0xCCC0, 0xCCC2, 0xCCC4,
    0xCCCC, 0xCCCE, 0xCCD1, 0xCCD3, 0xCCDD, 0xCCDF,
    0xCCE0, 0xCCE2, 0xCCE4, 0xCCEC, 0xCCEE, 0xCCF1,
    0xCCF3, 0xCCFD, 0xCCFF, 0xCD01, 0xCD03, 0xCD0D,
    0xCD0F, 0xCD10, 0xCD12, 0xCD14, 0xCD1C, 0xCD1E,
    0xCD21, 0xCD23, 0xCD2D, 0xCD2F, 0xCD30, 0xCD32,
    0xCD34, 0xCD3C, 0xCD3E, 0xCD41, 0xCD43, 0xCD4D,
    0xCD4F, 0xCDC1, 0xCDC3, 0xCDCD, 0xCDCF, 0xCDD0,
    0xCDD2, 0xCDD4, 0xCDDC, 0xCDDE, 0xCDE1, 0xCDE3,
    0xCDED, 0xCDEF, 0xCDF0, 0xCDF2, 0xCDF4, 0xCDFC,
    0xCDFE, 0xCE00, 0xCE02, 0xCE04, 0xCE0C, 0xCE0E,
    0xCE11, 0xCE13, 0xCE1D, 0xCE1F, 0xCE20, 0xCE22,
    0xCE24, 0xCE2C, 0xCE2E, 0xCE31, 0xCE33, 0xCE3D,
    0xCE3F, 0xCE40, 0xCE42, 0xCE44, 0xCE4C, 0xCE4E,
    0xCEC0, 0xCEC2, 0xCEC4, 0xCECC, 0xCECE, 0xCED1,
    0xCED3, 0xCEDD, 0xCEDF, 0xCEE0, 0xCEE2, 0xCEE4,
    0xCEEC, 0xCEEE, 0xCEF1, 0xCEF3, 0xCEFD, 0xCEFF,
    0xCF01, 0xCF03, 0xCF0D, 0xCF0F, 0xCF10, 0xCF12,
    0xCF14, 0xCF1C, 0xCF1E, 0xCF21, 0xCF23, 0xCF2D,
    0xCF2F, 0xCF30, 0xCF32, 0xCF34, 0xCF3C, 0xCF3E,
    0xCF41, 0xCF43, 0xCF4D, 0xCF4F, 0xCFC1, 0xCFC3,
    0xCFCD, 0xCFCF, 0xCFD0, 0xCFD2, 0xCFD4, 0xCFDC,
    0xCFDE, 0xCFE1, 0xCFE3, 0xCFED, 0xCFEF, 0xCFF0,
    0xCFF2, 0xCFF4, 0xCFFC, 0xCFFE, 0xD001, 0xD003,
    0xD00D, 0xD00F, 0xD010, 0xD012, 0xD014, 0xD01C,
    0xD01E, 0xD021, 0xD023, 0xD02D, 0xD02F, 0xD030,
    0xD032, 0xD034, 0xD03C, 0xD03E, 0xD041, 0xD043,
    0xD04D, 0xD04F, 0xD0C1, 0xD0C3, 0xD0CD, 0xD0CF,
    0xD0D0, 0xD0D2, 0xD0D4, 0xD0DC, 0xD0DE, 0xD0E1,
    0xD0E3, 0xD0ED, 0xD0EF, 0xD0F0, 0xD0F2, 0xD0F4,
    0xD0FC, 0xD0FE, 0xD100, 0xD102, 0xD104, 0xD10C,
    0xD10E, 0xD111, 0xD113, 0xD11D, 0xD11F, 0xD120,
    0xD122, 0xD124, 0xD12C, 0xD12E, 0xD131, 0xD133,
    0xD13D, 0xD13F, 0xD140, 0xD142, 0xD144, 0xD14C,
    0xD14E, 0xD1C0, 0xD1C2, 0xD1C4, 0xD1CC, 0xD1CE,
    0xD1D1, 0xD1D3, 0xD1DD, 0xD1DF, 0xD1E0, 0xD1E2,
    0xD1E4, 0xD1EC, 0xD1EE, 0xD1F1, 0xD1F3, 0xD1FD,
    0xD1FF, 0xD201, 0xD203, 0xD20D, 0xD20F, 0xD210,
    0xD212, 0xD214, 0xD21C, 0xD21E, 0xD221, 0xD223,
    0xD22D, 0xD22F, 0xD230, 0xD232, 0xD234, 0xD23C,
    0xD23E, 0xD241, 0xD243, 0xD24D, 0xD24F, 0xD2C1,
    0xD2C3, 0xD2CD, 0xD2CF, 0xD2D0, 0xD2D2, 0xD2D4,
    0xD2DC, 0xD2DE, 0xD2E1, 0xD2E3, 0xD2ED, 0xD2EF,
    0xD2F0, 0xD2F2, 0xD2F4, 0xD2FC, 0xD2FE, 0xD300,
    0xD302, 0xD304, 0xD30C, 0xD30E, 0xD311, 0xD313,
    0xD31D, 0xD31F, 0xD320, 0xD322, 0xD324, 0xD32C,
    0xD32E, 0xD331, 0xD333, 0xD33D, 0xD33F, 0xD340,
    0xD342, 0xD344, 0xD34C, 0xD34E, 0xD3C0, 0xD3C2,
    0xD3C4, 0xD3CC, 0xD3CE, 0xD3D1, 0xD3D3, 0xD3DD,
    0xD3DF, 0xD3E0, 0xD3E2, 0xD3E4, 0xD3EC, 0xD3EE,
    0xD3F1, 0xD3F3, 0xD3FD, 0xD3FF, 0xD401, 0xD403,
    0xD40D, 0xD40F, 0xD410, 0xD412, 0xD414, 0xD41C,
    0xD41E, 0xD421, 0xD423, 0xD42D, 0xD42F, 0xD430,
    0xD432, 0xD434, 0xD43C, 0xD43E, 0xD441, 0xD443,
    0xD44D, 0xD44F, 0xD4C1, 0xD4C3, 0xD4CD, 0xD4CF,
    0xD4D0, 0xD4D2, 0xD4D4, 0xD4DC, 0xD4DE, 0xD4E1,
    0xD4E3, 0xD4ED, 0xD4EF, 0xD4F0, 0xD4F2, 0xD4F4,
    0xD4FC, 0xD4FE, 0xDC01, 0xDC03, 0xDC0D, 0xDC0F,
    0xDC10, 0xDC12, 0xDC14, 0xDC1C, 0xDC1E, 0xDC21,
    0xDC23, 0xDC2D, 0xDC2F, 0xDC30, 0xDC32, 0xDC34,
    0xDC3C, 0xDC3E, 0xDC41, 0xDC43, 0xDC4D, 0xDC4F,
    0xDCC1, 0xDCC3, 0xDCCD, 0xDCCF, 0xDCD0, 0xDCD2,
    0xDCD4, 0xDCDC, 0xDCDE, 0xDCE1, 0xDCE3, 0xDCED,
    0xDCEF, 0xDCF0, 0xDCF2, 0xDCF4, 0xDCFC, 0xDCFE,
    0xDD00, 0xDD02, 0xDD04, 0xDD0C, 0xDD0E, 0xDD11,
    0xDD13, 0xDD1D, 0xDD1F, 0xDD20, 0xDD22, 0xDD24,
    0xDD2C, 0xDD2E, 0xDD31, 0xDD33, 0xDD3D, 0xDD3F,
    0xDD40, 0xDD42, 0xDD44, 0xDD4C, 0xDD4E, 0xDDC0,
    0xDDC2, 0xDDC4, 0xDDCC, 0xDDCE, 0xDDD1, 0xDDD3,
    0xDDDD, 0xDDDF, 0xDDE0, 0xDDE2, 0xDDE4, 0xDDEC,
    0xDDEE, 0xDDF1, 0xDDF3, 0xDDFD, 0xDDFF, 0xDE01,
    0xDE03, 0xDE0D, 0xDE0F, 0xDE10, 0xDE12, 0xDE14,
    0xDE1C, 0xDE1E, 0xDE21, 0xDE23, 0xDE2D, 0xDE2F,
    0xDE30, 0xDE32, 0xDE34, 0xDE3C, 0xDE3E, 0xDE41,
    0xDE43, 0xDE4D, 0xDE4F, 0xDEC1, 0xDEC3, 0xDECD,
    0xDECF, 0xDED0, 0xDED2, 0xDED4, 0xDEDC, 0xDEDE,
    0xDEE1, 0xDEE3, 0xDEED, 0xDEEF, 0xDEF0, 0xDEF2,
    0xDEF4, 0xDEFC, 0xDEFE, 0xDF00, 0xDF02, 0xDF04,
    0xDF0C, 0xDF0E, 0xDF11, 0xDF13, 0xDF1D, 0xDF1F,
    0xDF20, 0xDF22, 0xDF24, 0xDF2C, 0xDF2E, 0xDF31,
    0xDF33, 0xDF3D, 0xDF3F, 0xDF40, 0xDF42, 0xDF44,
    0xDF4C, 0xDF4E, 0xDFC0, 0xDFC2, 0xDFC4, 0xDFCC,
    0xDFCE, 0xDFD1, 0xDFD3, 0xDFDD, 0xDFDF, 0xDFE0,
    0xDFE2, 0xDFE4, 0xDFEC, 0xDFEE, 0xDFF1, 0xDFF3,
    0xDFFD, 0xDFFF, 0xE000, 0xE002, 0xE004, 0xE00C,
    0xE00E, 0xE011, 0xE013, 0xE01D, 0xE01F, 0xE020,
    0xE022, 0xE024, 0xE02C, 0xE02E, 0xE031, 0xE033,
    0xE03D, 0xE03F, 0xE040, 0xE042, 0xE044, 0xE04C,
    0xE04E, 0xE0C0, 0xE0C2, 0xE0C4, 0xE0CC, 0xE0CE,
    0xE0D1, 0xE0D3, 0xE0DD, 0xE0DF, 0xE0E0, 0xE0E2,
    0xE0E4, 0xE0EC, 0xE0EE, 0xE0F1, 0xE0F3, 0xE0FD,
    0xE0FF, 0xE101, 0xE103, 0xE10D, 0xE10F, 0xE110,
    0xE112, 0xE114, 0xE11C, 0xE11E, 0xE121, 0xE123,
    0xE12D, 0xE12F, 0xE130, 0xE132, 0xE134, 0xE13C,
    0xE13E, 0xE141, 0xE143, 0xE14D, 0xE14F, 0xE1C1,
    0xE1C3, 0xE1CD, 0xE1CF, 0xE1D0, 0xE1D2, 0xE1D4,
    0xE1DC, 0xE1DE, 0xE1E1, 0xE1E3, 0xE1ED, 0xE1EF,
    0xE1F0, 0xE1F2, 0xE1F4, 0xE1FC, 0xE1FE, 0xE200,
    0xE202, 0xE204, 0xE20C, 0xE20E, 0xE211, 0xE213,
    0xE21D, 0xE21F, 0xE220, 0xE222, 0xE224, 0xE22C,
    0xE22E, 0xE231, 0xE233, 0xE23D, 0xE23F, 0xE240,
    0xE242, 0xE244, 0xE24C, 0xE24E, 0xE2C0, 0xE2C2,
    0xE2C4, 0xE2CC, 0xE2CE, 0xE2D1, 0xE2D3, 0xE2DD,
    0xE2DF, 0xE2E0, 0xE2E2, 0xE2E4, 0xE2EC, 0xE2EE,
    0xE2F1, 0xE2F3, 0xE2FD, 0xE2FF, 0xE301, 0xE303,
    0xE30D, 0xE30F, 0xE310, 0xE312, 0xE314, 0xE31C,
    0xE31E, 0xE321, 0xE323, 0xE32D, 0xE32F, 0xE330,
    0xE332, 0xE334, 0xE33C, 0xE33E, 0xE341, 0xE343,
    0xE34D, 0xE34F, 0xE3C1, 0xE3C3, 0xE3CD, 0xE3CF,
    0xE3D0, 0xE3D2, 0xE3D4, 0xE3DC, 0xE3DE, 0xE3E1,
    0xE3E3, 0xE3ED, 0xE3EF, 0xE3F0, 0xE3F2, 0xE3F4,
    0xE3FC, 0xE3FE, 0xE400, 0xE402, 0xE404, 0xE40C,
    0xE40E, 0xE411, 0xE413, 0xE41D, 0xE41F, 0xE420,
    0xE422, 0xE424, 0xE42C, 0xE42E, 0xE431, 0xE433,
    0xE43D, 0xE43F, 0xE440, 0xE442, 0xE444, 0xE44C,
    0xE44E, 0xE4C0, 0xE4C2, 0xE4C4, 0xE4CC, 0xE4CE,
    0xE4D1, 0xE4D3, 0xE4DD, 0xE4DF, 0xE4E0, 0xE4E2,
    0xE4E4, 0xE4EC, 0xE4EE, 0xE4F1, 0xE4F3, 0xE4FD,
    0xE4FF, 0xEC00, 0xEC02, 0xEC04, 0xEC0C, 0xEC0E,
    0xEC11, 0xEC13, 0xEC1D, 0xEC1F, 0xEC20, 0xEC22,
    0xEC24, 0xEC2C, 0xEC2E, 0xEC31, 0xEC33, 0xEC3D,
    0xEC3F, 0xEC40, 0xEC42, 0xEC44, 0xEC4C, 0xEC4E,
    0xECC0, 0xECC2, 0xECC4, 0xECCC, 0xECCE, 0xECD1,
    0xECD3, 0xECDD, 0xECDF, 0xECE0, 0xECE2, 0xECE4,
    0xECEC, 0xECEE, 0xECF1, 0xECF3, 0xECFD, 0xECFF,
    0xED01, 0xED03, 0xED0D, 0xED0F, 0xED10, 0xED12,
    0xED14, 0xED1C, 0xED1E, 0xED21, 0xED23, 0xED2D,
    0xED2F, 0xED30, 0xED32, 0xED34, 0xED3C, 0xED3E,
    0xED41, 0xED43, 0xED4D, 0xED4F, 0xEDC1, 0xEDC3,
    0xEDCD, 0xEDCF, 0xEDD0, 0xEDD2, 0xEDD4, 0xEDDC,
    0xEDDE, 0xEDE1, 0xEDE3, 0xEDED, 0xEDEF, 0xEDF0,
    0xEDF2, 0xEDF4, 0xEDFC, 0xEDFE, 0xEE00, 0xEE02,
    0xEE04, 0xEE0C, 0xEE0E, 0xEE11, 0xEE13, 0xEE1D,
    0xEE1F, 0xEE20, 0xEE22, 0xEE24, 0xEE2C, 0xEE2E,
    0xEE31, 0xEE33, 0xEE3D, 0xEE3F, 0xEE40, 0xEE42,
    0xEE44, 0xEE4C, 0xEE4E, 0xEEC0, 0xEEC2, 0xEEC4,
    0xEECC, 0xEECE, 0xEED1, 0xEED3, 0xEEDD, 0xEEDF,
    0xEEE0, 0xEEE2, 0xEEE4, 0xEEEC, 0xEEEE, 0xEEF1,
    0xEEF3, 0xEEFD, 0xEEFF, 0xEF01, 0xEF03, 0xEF0D,
    0xEF0F, 0xEF10, 0xEF12, 0xEF14, 0xEF1C, 0xEF1E,
    0xEF21, 0xEF23, 0xEF2D, 0xEF2F, 0xEF30, 0xEF32,
    0xEF34, 0xEF3C, 0xEF3E, 0xEF41, 0xEF43, 0xEF4D,
    0xEF4F, 0xEFC1, 0xEFC3, 0xEFCD, 0xEFCF, 0xEFD0,
    0xEFD2, 0xEFD4, 0xEFDC, 0xEFDE, 0xEFE1, 0xEFE3,
    0xEFED, 0xEFEF, 0xEFF0, 0xEFF2, 0xEFF4, 0xEFFC,
    0xEFFE, 0xF001, 0xF003, 0xF00D, 0xF00F, 0xF010,
    0xF012, 0xF014, 0xF01C, 0xF01E, 0xF021, 0xF023,
    0xF02D, 0xF02F, 0xF030, 0xF032, 0xF034, 0xF03C,
    0xF03E, 0xF041, 0xF043, 0xF04D, 0xF04F, 0xF0C1,
    0xF0C3, 0xF0CD, 0xF0CF, 0xF0D0, 0xF0D2, 0xF0D4,
    0xF0DC, 0xF0DE, 0xF0E1, 0xF0E3, 0xF0ED, 0xF0EF,
    0xF0F0, 0xF0F2, 0xF0F4, 0xF0FC, 0xF0FE, 0xF100,
    0xF102, 0xF104, 0xF10C, 0xF10E, 0xF111, 0xF113,
    0xF11D, 0xF11F, 0xF120, 0xF122, 0xF124, 0xF12C,
    0xF12E, 0xF131, 0xF133, 0xF13D, 0xF13F, 0xF140,
    0xF142, 0xF144, 0xF14C, 0xF14E, 0xF1C0, 0xF1C2,
    0xF1C4, 0xF1CC, 0xF1CE, 0xF1D1, 0xF1D3, 0xF1DD,
    0xF1DF, 0xF1E0, 0xF1E2, 0xF1E4, 0xF1EC, 0xF1EE,
    0xF1F1, 0xF1F3, 0xF1FD, 0xF1FF, 0xF201, 0xF203,
    0xF20D, 0xF20F, 0xF210, 0xF212, 0xF214, 0xF21C,
    0xF21E, 0xF221, 0xF223, 0xF22D, 0xF22F, 0xF230,
    0xF232, 0xF234, 0xF23C, 0xF23E, 0xF241, 0xF243,
    0xF24D, 0xF24F, 0xF2C1, 0xF2C3, 0xF2CD, 0xF2CF,
    0xF2D0, 0xF2D2, 0xF2D4, 0xF2DC, 0xF2DE, 0xF2E1,
    0xF2E3, 0xF2ED, 0xF2EF, 0xF2F0, 0xF2F2, 0xF2F4,
    0xF2FC, 0xF2FE, 0xF300, 0xF302, 0xF304, 0xF30C,
    0xF30E, 0xF311, 0xF313, 0xF31D, 0xF31F, 0xF320,
    0xF322, 0xF324, 0xF32C, 0xF32E, 0xF331, 0xF333,
    0xF33D, 0xF33F, 0xF340, 0xF342, 0xF344, 0xF34C,
    0xF34E, 0xF3C0, 0xF3C2, 0xF3C4, 0xF3CC, 0xF3CE,
    0xF3D1, 0xF3D3, 0xF3DD, 0xF3DF, 0xF3E0, 0xF3E2,
    0xF3E4, 0xF3EC, 0xF3EE, 0xF3F1, 0xF3F3, 0xF3FD,
    0xF3FF, 0xF401, 0xF403, 0xF40D, 0xF40F, 0xF410,
    0xF412, 0xF414, 0xF41C, 0xF41E, 0xF421, 0xF423,
    0xF42D, 0xF42F, 0xF430, 0xF432, 0xF434, 0xF43C,
    0xF43E, 0xF441, 0xF443, 0xF44D, 0xF44F, 0xF4C1,
    0xF4C3, 0xF4CD, 0xF4CF, 0xF4D0, 0xF4D2, 0xF4D4,
    0xF4DC, 0xF4DE, 0xF4E1, 0xF4E3, 0xF4ED, 0xF4EF,
    0xF4F0, 0xF4F2, 0xF4F4, 0xF4FC, 0xF4FE, 0xFC01,
    0xFC03, 0xFC0D, 0xFC0F, 0xFC10, 0xFC12, 0xFC14,
    0xFC1C, 0xFC1E, 0xFC21, 0xFC23, 0xFC2D, 0xFC2F,
    0xFC30, 0xFC32, 0xFC34, 0xFC3C, 0xFC3E, 0xFC41,
    0xFC43, 0xFC4D, 0xFC4F, 0xFCC1, 0xFCC3, 0xFCCD,
    0xFCCF, 0xFCD0, 0xFCD2, 0xFCD4, 0xFCDC, 0xFCDE,
    0xFCE1, 0xFCE3, 0xFCED, 0xFCEF, 0xFCF0, 0xFCF2,
    0xFCF4, 0xFCFC, 0xFCFE, 0xFD00, 0xFD02, 0xFD04,
    0xFD0C, 0xFD0E, 0xFD11, 0xFD13, 0xFD1D, 0xFD1F,
    0xFD20, 0xFD22, 0xFD24, 0xFD2C, 0xFD2E, 0xFD31,
    0xFD33, 0xFD3D, 0xFD3F, 0xFD40, 0xFD42, 0xFD44,
    0xFD4C, 0xFD4E, 0xFDC0, 0xFDC2, 0xFDC4, 0xFDCC,
    0xFDCE, 0xFDD1, 0xFDD3, 0xFDDD, 0xFDDF, 0xFDE0,
    0xFDE2, 0xFDE4, 0xFDEC, 0xFDEE, 0xFDF1, 0xFDF3,
    0xFDFD, 0xFDFF, 0xFE01, 0xFE03, 0xFE0D, 0xFE0F,
    0xFE10, 0xFE12, 0xFE14, 0xFE1C, 0xFE1E, 0xFE21,
    0xFE23, 0xFE2D, 0xFE2F, 0xFE30, 0xFE32, 0xFE34,
    0xFE3C, 0xFE3E, 0xFE41, 0xFE43, 0xFE4D, 0xFE4F,
    0xFEC1, 0xFEC3, 0xFECD, 0xFECF, 0xFED0, 0xFED2,
    0xFED4, 0xFEDC, 0xFEDE, 0xFEE1, 0xFEE3, 0xFEED,
    0xFEEF, 0xFEF0, 0xFEF2, 0xFEF4, 0xFEFC, 0xFEFE,
    0xFF00, 0xFF02, 0xFF04, 0xFF0C, 0xFF0E, 0xFF11,
    0xFF13, 0xFF1D, 0xFF1F, 0xFF20, 0xFF22, 0xFF24,
    0xFF2C, 0xFF2E, 0xFF31, 0xFF33, 0xFF3D, 0xFF3F,
    0xFF40, 0xFF42, 0xFF44, 0xFF4C, 0xFF4E, 0xFFC0,
    0xFFC2, 0xFFC4, 0xFFCC, 0xFFCE, 0xFFD1, 0xFFD3,
    0xFFDD, 0xFFDF, 0xFFE0, 0xFFE2, 0xFFE4, 0xFFEC,
    0xFFEE, 0xFFF1, 0xFFF3, 0xFFFD, 0xFFFF,
};

#define ON2AVC_CB9_CODES 121
static const uint16_t on2avc_cb9_codes[ON2AVC_CB9_CODES] = {
    0x0000, 0x000F, 0x0098, 0x026E, 0x045C, 0x00A6,
    0x00AC, 0x045D, 0x027E, 0x009A, 0x0012, 0x000E,
    0x001A, 0x00DE, 0x022C, 0x053E, 0x00A2, 0x009E,
    0x0538, 0x01B2, 0x00BA, 0x0018, 0x00AD, 0x00BF,
    0x01BE, 0x037E, 0x05C6, 0x0132, 0x0112, 0x08B5,
    0x0457, 0x01B6, 0x00BC, 0x02AE, 0x022A, 0x045E,
    0x08B6, 0x08FA, 0x0147, 0x013E, 0x119F, 0x05C7,
    0x044F, 0x0170, 0x0456, 0x047F, 0x06C7, 0x0A72,
    0x0D8B, 0x0267, 0x0266, 0x0D8A, 0x08B7, 0x05CF,
    0x045F, 0x0054, 0x00A4, 0x0118, 0x0142, 0x0234,
    0x036F, 0x036E, 0x029E, 0x0156, 0x0114, 0x0088,
    0x00A0, 0x00A5, 0x00DA, 0x015F, 0x026F, 0x02E2,
    0x02E6, 0x0236, 0x015E, 0x0143, 0x00AA, 0x053A,
    0x0466, 0x04FE, 0x09FE, 0x119E, 0x0232, 0x0237,
    0x0A73, 0x09FF, 0x08B4, 0x046B, 0x02AF, 0x01B0,
    0x037F, 0x053F, 0x08FB, 0x0136, 0x0146, 0x08CE,
    0x05CE, 0x044E, 0x01B3, 0x008E, 0x00DD, 0x0226,
    0x047E, 0x06C6, 0x00AE, 0x011E, 0x06C4, 0x047C,
    0x0172, 0x00BE, 0x0010, 0x0016, 0x00BD, 0x0176,
    0x053B, 0x009D, 0x009C, 0x046A, 0x0177, 0x00DC,
    0x0019,
};

static const uint8_t on2avc_cb9_bits[ON2AVC_CB9_CODES] = {
     1,  4,  8, 10, 11,  8,
     8, 11, 10,  8,  5,  4,
     5,  8, 10, 11,  8,  8,
    11,  9,  8,  5,  8,  8,
     9, 10, 11,  9,  9, 12,
    11,  9,  8, 10, 10, 11,
    12, 12,  9,  9, 13, 11,
    11,  9, 11, 11, 11, 12,
    12, 10, 10, 12, 12, 11,
    11,  7,  8,  9,  9, 10,
    10, 10, 10,  9,  9,  8,
     8,  8,  8,  9, 10, 10,
    10, 10,  9,  9,  8, 11,
    11, 11, 12, 13, 10, 10,
    12, 12, 12, 11, 10,  9,
    10, 11, 12,  9,  9, 12,
    11, 11,  9,  8,  8, 10,
    11, 11,  8,  9, 11, 11,
     9,  8,  5,  5,  8,  9,
    11,  8,  8, 11,  9,  8,
     5,
};

static const uint16_t on2avc_cb9_syms[ON2AVC_CB9_CODES] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005,
    0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF, 0x0100,
    0x0101, 0x0102, 0x0103, 0x0104, 0x0105, 0x01FB,
    0x01FC, 0x01FD, 0x01FE, 0x01FF, 0x0200, 0x0201,
    0x0202, 0x0203, 0x0204, 0x0205, 0x02FB, 0x02FC,
    0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302,
    0x0303, 0x0304, 0x0305, 0x03FB, 0x03FC, 0x03FD,
    0x03FE, 0x03FF, 0x0400, 0x0401, 0x0402, 0x0403,
    0x0404, 0x0405, 0x04FB, 0x04FC, 0x04FD, 0x04FE,
    0x04FF, 0x0500, 0x0501, 0x0502, 0x0503, 0x0504,
    0x0505, 0x05FB, 0x05FC, 0x05FD, 0x05FE, 0x05FF,
    0xFB00, 0xFB01, 0xFB02, 0xFB03, 0xFB04, 0xFB05,
    0xFBFB, 0xFBFC, 0xFBFD, 0xFBFE, 0xFBFF, 0xFC00,
    0xFC01, 0xFC02, 0xFC03, 0xFC04, 0xFC05, 0xFCFB,
    0xFCFC, 0xFCFD, 0xFCFE, 0xFCFF, 0xFD00, 0xFD01,
    0xFD02, 0xFD03, 0xFD04, 0xFD05, 0xFDFB, 0xFDFC,
    0xFDFD, 0xFDFE, 0xFDFF, 0xFE00, 0xFE01, 0xFE02,
    0xFE03, 0xFE04, 0xFE05, 0xFEFB, 0xFEFC, 0xFEFD,
    0xFEFE, 0xFEFF, 0xFF00, 0xFF01, 0xFF02, 0xFF03,
    0xFF04, 0xFF05, 0xFFFB, 0xFFFC, 0xFFFD, 0xFFFE,
    0xFFFF,
};

#define ON2AVC_CB10_CODES 121
static const uint16_t on2avc_cb10_codes[ON2AVC_CB10_CODES] = {
    0x002E, 0x001A, 0x003C, 0x001F, 0x006E, 0x002E,
    0x00AE, 0x006F, 0x002A, 0x003E, 0x0014, 0x0016,
    0x0002, 0x000E, 0x004E, 0x00F7, 0x0042, 0x0027,
    0x00F6, 0x0046, 0x0014, 0x0008, 0x0032, 0x0016,
    0x0030, 0x0012, 0x0056, 0x0018, 0x005F, 0x00DE,
    0x006E, 0x0036, 0x001A, 0x0023, 0x003D, 0x003F,
    0x007A, 0x008E, 0x0071, 0x0006, 0x0012, 0x000F,
    0x0043, 0x003E, 0x00AE, 0x0001, 0x00AB, 0x00C7,
    0x0013, 0x000A, 0x0002, 0x01CA, 0x0003, 0x0000,
    0x000F, 0x0022, 0x0016, 0x002A, 0x007F, 0x001C,
    0x0036, 0x00AF, 0x00C6, 0x000E, 0x0010, 0x0006,
    0x008F, 0x001E, 0x0054, 0x000D, 0x00AA, 0x0056,
    0x00AC, 0x001D, 0x0076, 0x0013, 0x004F, 0x0057,
    0x00E6, 0x00EE, 0x000E, 0x01CB, 0x00AF, 0x000B,
    0x0007, 0x00EF, 0x00AD, 0x00E4, 0x0008, 0x005E,
    0x0070, 0x001E, 0x00DF, 0x000C, 0x007E, 0x00CE,
    0x0002, 0x001A, 0x003C, 0x0002, 0x0020, 0x003A,
    0x004D, 0x00CF, 0x0066, 0x0026, 0x002F, 0x001F,
    0x0022, 0x001B, 0x0012, 0x000E, 0x0017, 0x0062,
    0x00E7, 0x0019, 0x0014, 0x0006, 0x004C, 0x0012,
    0x000C,
};

static const uint8_t on2avc_cb10_bits[ON2AVC_CB10_CODES] = {
    6,  5,  6,  8,  9,  8,
    8,  9,  8,  6,  5,  5,
    5,  6,  7,  8,  7,  7,
    8,  7,  6,  5,  6,  6,
    6,  7,  8,  7,  7,  8,
    7,  6,  6,  8,  7,  7,
    7,  8,  7,  8,  9,  8,
    7,  7,  9,  9,  8,  8,
    9,  8,  9,  9,  9,  9,
    9,  8,  7,  7,  7,  8,
    8,  9,  8,  8,  7,  6,
    8,  7,  7,  8,  8,  9,
    8,  8,  7,  7,  7,  9,
    8,  8,  9,  9,  8,  8,
    9,  8,  8,  8,  8,  7,
    7,  8,  8,  8,  7,  8,
    8,  7,  7,  7,  6,  6,
    7,  8,  7,  7,  8,  7,
    6,  6,  5,  5,  6,  7,
    8,  7,  7,  9,  7,  6,
    5,
};

static const uint16_t on2avc_cb10_syms[ON2AVC_CB10_CODES] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005,
    0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF, 0x0100,
    0x0101, 0x0102, 0x0103, 0x0104, 0x0105, 0x01FB,
    0x01FC, 0x01FD, 0x01FE, 0x01FF, 0x0200, 0x0201,
    0x0202, 0x0203, 0x0204, 0x0205, 0x02FB, 0x02FC,
    0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302,
    0x0303, 0x0304, 0x0305, 0x03FB, 0x03FC, 0x03FD,
    0x03FE, 0x03FF, 0x0400, 0x0401, 0x0402, 0x0403,
    0x0404, 0x0405, 0x04FB, 0x04FC, 0x04FD, 0x04FE,
    0x04FF, 0x0500, 0x0501, 0x0502, 0x0503, 0x0504,
    0x0505, 0x05FB, 0x05FC, 0x05FD, 0x05FE, 0x05FF,
    0xFB00, 0xFB01, 0xFB02, 0xFB03, 0xFB04, 0xFB05,
    0xFBFB, 0xFBFC, 0xFBFD, 0xFBFE, 0xFBFF, 0xFC00,
    0xFC01, 0xFC02, 0xFC03, 0xFC04, 0xFC05, 0xFCFB,
    0xFCFC, 0xFCFD, 0xFCFE, 0xFCFF, 0xFD00, 0xFD01,
    0xFD02, 0xFD03, 0xFD04, 0xFD05, 0xFDFB, 0xFDFC,
    0xFDFD, 0xFDFE, 0xFDFF, 0xFE00, 0xFE01, 0xFE02,
    0xFE03, 0xFE04, 0xFE05, 0xFEFB, 0xFEFC, 0xFEFD,
    0xFEFE, 0xFEFF, 0xFF00, 0xFF01, 0xFF02, 0xFF03,
    0xFF04, 0xFF05, 0xFFFB, 0xFFFC, 0xFFFD, 0xFFFE,
    0xFFFF,
};

#define ON2AVC_CB11_CODES 225
static const uint16_t on2avc_cb11_codes[ON2AVC_CB11_CODES] = {
    0x0000, 0x000E, 0x0056, 0x00CD, 0x0173, 0x0232,
    0x00C7, 0x014F, 0x01AA, 0x00BE, 0x026F, 0x0192,
    0x00BC, 0x0058, 0x000F, 0x000C, 0x0010, 0x004E,
    0x0082, 0x0142, 0x01BF, 0x0098, 0x015E, 0x0136,
    0x0086, 0x01BB, 0x014E, 0x00BA, 0x003E, 0x0012,
    0x0054, 0x0036, 0x0050, 0x008F, 0x014B, 0x0262,
    0x00AA, 0x015C, 0x013E, 0x00B7, 0x02BE, 0x0176,
    0x00A2, 0x0058, 0x003C, 0x00C2, 0x00A6, 0x008A,
    0x00B2, 0x0122, 0x02AC, 0x00CA, 0x012F, 0x014A,
    0x00DC, 0x02DE, 0x017A, 0x0134, 0x0092, 0x00B4,
    0x0166, 0x0148, 0x016E, 0x013F, 0x0134, 0x02FF,
    0x014F, 0x019E, 0x0267, 0x016C, 0x02A6, 0x02CE,
    0x013A, 0x010A, 0x0108, 0x026E, 0x02CB, 0x028E,
    0x02CF, 0x020F, 0x02DF, 0x010B, 0x02AD, 0x0227,
    0x018A, 0x04DB, 0x02A7, 0x02FE, 0x0236, 0x026C,
    0x00C6, 0x009C, 0x00C4, 0x00CE, 0x00D6, 0x0135,
    0x0156, 0x025A, 0x02FF, 0x0286, 0x015F, 0x0132,
    0x00D7, 0x00AC, 0x00A2, 0x0176, 0x0118, 0x0123,
    0x0157, 0x01BC, 0x02AE, 0x02EE, 0x04DA, 0x0467,
    0x033F, 0x0287, 0x0193, 0x0182, 0x013B, 0x0112,
    0x0133, 0x017D, 0x0117, 0x0186, 0x026E, 0x025B,
    0x02EF, 0x0466, 0x0316, 0x0237, 0x02F6, 0x01BA,
    0x015D, 0x012E, 0x015A, 0x014A, 0x008E, 0x00B6,
    0x0135, 0x0100, 0x017B, 0x028C, 0x033E, 0x0297,
    0x015B, 0x0102, 0x0140, 0x00D4, 0x00BA, 0x0088,
    0x02EE, 0x0283, 0x02BF, 0x020E, 0x02CE, 0x0317,
    0x0172, 0x0296, 0x026F, 0x0101, 0x02CF, 0x02F7,
    0x01BD, 0x02EF, 0x028F, 0x0263, 0x0164, 0x011A,
    0x0147, 0x0292, 0x02FE, 0x015E, 0x02AF, 0x01AB,
    0x0130, 0x02CA, 0x0183, 0x014E, 0x017C, 0x017E,
    0x00C8, 0x00AA, 0x009E, 0x0132, 0x0152, 0x0226,
    0x00CC, 0x017E, 0x0187, 0x00CB, 0x0293, 0x0106,
    0x00C0, 0x0087, 0x00BC, 0x005C, 0x003D, 0x005A,
    0x00A8, 0x0103, 0x028D, 0x00A4, 0x0116, 0x0146,
    0x00B8, 0x01BE, 0x016D, 0x0093, 0x004A, 0x003F,
    0x000D, 0x0011, 0x004F, 0x00AE, 0x0166, 0x0266,
    0x0090, 0x0109, 0x012C, 0x00A6, 0x0282, 0x017A,
    0x00B5, 0x0034, 0x000E,
};

static const uint8_t on2avc_cb11_bits[ON2AVC_CB11_CODES] = {
     2,  4,  7,  9, 10, 11,
     9, 10, 10,  9, 11, 10,
     9,  7,  4,  4,  5,  7,
     9,  9, 10,  9, 10, 10,
     9, 10,  9,  8,  7,  5,
     7,  7,  8,  9,  9, 10,
     9, 10, 10,  9, 10,  9,
     9,  8,  7,  9,  8,  9,
     9, 10, 10,  9, 10, 10,
     9, 10, 10,  9,  9,  8,
    10,  9,  9, 10, 10, 10,
     9, 10, 10,  9, 11, 10,
    10, 10, 10, 11, 10, 10,
    10, 11, 10, 10, 10, 11,
    10, 11, 11, 10, 11, 10,
     9,  9,  9,  9,  9, 10,
    10, 11, 11, 10, 10, 10,
     9,  9,  8, 10, 10, 10,
    10, 10, 10, 10, 11, 12,
    11, 10, 10, 10, 10, 10,
    10,  9, 10, 10, 10, 11,
    11, 12, 11, 11, 10, 10,
    10, 10, 10,  9,  9,  9,
     9, 10, 10, 10, 11, 11,
    10, 10,  9,  9,  9,  9,
    11, 10, 10, 11, 11, 11,
    10, 11, 10, 10, 11, 10,
    10, 10, 10, 10,  9, 10,
    10, 10, 11,  9, 10, 10,
     9, 10, 10, 10,  9,  9,
     9,  8,  9,  9, 10, 11,
     9, 10, 10,  9, 10, 10,
     9,  9,  8,  7,  7,  8,
     9, 10, 10,  9, 10, 10,
     9, 10,  9,  9,  8,  7,
     4,  5,  7,  8,  9, 10,
     9, 10, 10,  9, 10,  9,
     8,  7,  5,
};

static const uint16_t on2avc_cb11_syms[ON2AVC_CB11_CODES] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005,
    0x0006, 0x0007, 0x00F9, 0x00FA, 0x00FB, 0x00FC,
    0x00FD, 0x00FE, 0x00FF, 0x0100, 0x0101, 0x0102,
    0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 0x01F9,
    0x01FA, 0x01FB, 0x01FC, 0x01FD, 0x01FE, 0x01FF,
    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205,
    0x0206, 0x0207, 0x02F9, 0x02FA, 0x02FB, 0x02FC,
    0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302,
    0x0303, 0x0304, 0x0305, 0x0306, 0x0307, 0x03F9,
    0x03FA, 0x03FB, 0x03FC, 0x03FD, 0x03FE, 0x03FF,
    0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405,
    0x0406, 0x0407, 0x04F9, 0x04FA, 0x04FB, 0x04FC,
    0x04FD, 0x04FE, 0x04FF, 0x0500, 0x0501, 0x0502,
    0x0503, 0x0504, 0x0505, 0x0506, 0x0507, 0x05F9,
    0x05FA, 0x05FB, 0x05FC, 0x05FD, 0x05FE, 0x05FF,
    0x0600, 0x0601, 0x0602, 0x0603, 0x0604, 0x0605,
    0x0606, 0x0607, 0x06F9, 0x06FA, 0x06FB, 0x06FC,
    0x06FD, 0x06FE, 0x06FF, 0x0700, 0x0701, 0x0702,
    0x0703, 0x0704, 0x0705, 0x0706, 0x0707, 0x07F9,
    0x07FA, 0x07FB, 0x07FC, 0x07FD, 0x07FE, 0x07FF,
    0xF900, 0xF901, 0xF902, 0xF903, 0xF904, 0xF905,
    0xF906, 0xF907, 0xF9F9, 0xF9FA, 0xF9FB, 0xF9FC,
    0xF9FD, 0xF9FE, 0xF9FF, 0xFA00, 0xFA01, 0xFA02,
    0xFA03, 0xFA04, 0xFA05, 0xFA06, 0xFA07, 0xFAF9,
    0xFAFA, 0xFAFB, 0xFAFC, 0xFAFD, 0xFAFE, 0xFAFF,
    0xFB00, 0xFB01, 0xFB02, 0xFB03, 0xFB04, 0xFB05,
    0xFB06, 0xFB07, 0xFBF9, 0xFBFA, 0xFBFB, 0xFBFC,
    0xFBFD, 0xFBFE, 0xFBFF, 0xFC00, 0xFC01, 0xFC02,
    0xFC03, 0xFC04, 0xFC05, 0xFC06, 0xFC07, 0xFCF9,
    0xFCFA, 0xFCFB, 0xFCFC, 0xFCFD, 0xFCFE, 0xFCFF,
    0xFD00, 0xFD01, 0xFD02, 0xFD03, 0xFD04, 0xFD05,
    0xFD06, 0xFD07, 0xFDF9, 0xFDFA, 0xFDFB, 0xFDFC,
    0xFDFD, 0xFDFE, 0xFDFF, 0xFE00, 0xFE01, 0xFE02,
    0xFE03, 0xFE04, 0xFE05, 0xFE06, 0xFE07, 0xFEF9,
    0xFEFA, 0xFEFB, 0xFEFC, 0xFEFD, 0xFEFE, 0xFEFF,
    0xFF00, 0xFF01, 0xFF02, 0xFF03, 0xFF04, 0xFF05,
    0xFF06, 0xFF07, 0xFFF9, 0xFFFA, 0xFFFB, 0xFFFC,
    0xFFFD, 0xFFFE, 0xFFFF,
};

#define ON2AVC_CB12_CODES 441
static const uint16_t on2avc_cb12_codes[ON2AVC_CB12_CODES] = {
    0x0000, 0x000C, 0x004F, 0x0156, 0x02E6, 0x0462,
    0x044C, 0x086A, 0x0222, 0x0228, 0x047F, 0x037A,
    0x028F, 0x02B8, 0x0BB7, 0x04B7, 0x02DA, 0x0262,
    0x0124, 0x0052, 0x000F, 0x000D, 0x000E, 0x0058,
    0x00A2, 0x0129, 0x02C8, 0x0256, 0x044D, 0x016E,
    0x02AA, 0x02BE, 0x027F, 0x02A9, 0x016E, 0x0597,
    0x02EE, 0x02EE, 0x013A, 0x00A4, 0x004E, 0x000C,
    0x0056, 0x004B, 0x0058, 0x0125, 0x010E, 0x01A7,
    0x026A, 0x0415, 0x010C, 0x0228, 0x0446, 0x0232,
    0x017E, 0x0128, 0x0473, 0x035E, 0x026A, 0x015E,
    0x00DB, 0x005E, 0x0048, 0x017A, 0x00AE, 0x00BA,
    0x0172, 0x0229, 0x02FB, 0x0458, 0x05A4, 0x015A,
    0x0296, 0x05BE, 0x044E, 0x0216, 0x012A, 0x0423,
    0x053E, 0x02F0, 0x02F1, 0x011E, 0x0110, 0x009C,
    0x026B, 0x0112, 0x011B, 0x01B3, 0x01BF, 0x0263,
    0x057E, 0x04B8, 0x016B, 0x02DE, 0x04DE, 0x0416,
    0x02DB, 0x02AB, 0x06EE, 0x04CF, 0x025F, 0x02EB,
    0x022A, 0x011A, 0x010A, 0x05A5, 0x0238, 0x0217,
    0x02D6, 0x025A, 0x0282, 0x044F, 0x043D, 0x01AE,
    0x026B, 0x05C2, 0x043C, 0x044F, 0x02DB, 0x05A7,
    0x044E, 0x05BF, 0x0297, 0x022A, 0x026C, 0x02BD,
    0x0897, 0x0283, 0x02B6, 0x02B7, 0x0264, 0x0459,
    0x040B, 0x04DF, 0x0298, 0x0456, 0x0AFF, 0x06B7,
    0x0448, 0x0449, 0x08BE, 0x06EF, 0x04B9, 0x0597,
    0x049A, 0x02D2, 0x02F8, 0x08F7, 0x0476, 0x0452,
    0x0453, 0x045A, 0x05BE, 0x043E, 0x04D2, 0x02F2,
    0x02E4, 0x0477, 0x0AFE, 0x05A6, 0x02E3, 0x0BB6,
    0x0A7E, 0x05A6, 0x0A66, 0x08BF, 0x05FF, 0x0492,
    0x0170, 0x0106, 0x0140, 0x0142, 0x022E, 0x02CF,
    0x02B9, 0x02E2, 0x02F3, 0x05A0, 0x088E, 0x0DD7,
    0x04F6, 0x047E, 0x045B, 0x0347, 0x029E, 0x026D,
    0x01AC, 0x013B, 0x0104, 0x035F, 0x02EC, 0x026E,
    0x0233, 0x0207, 0x023E, 0x026E, 0x053F, 0x05A7,
    0x0456, 0x04AE, 0x0DD6, 0x0A67, 0x0493, 0x04BA,
    0x05D3, 0x05C3, 0x0246, 0x0247, 0x0202, 0x02E8,
    0x05AE, 0x0374, 0x0537, 0x05C6, 0x04BB, 0x0686,
    0x04D3, 0x04DE, 0x08C3, 0x05BF, 0x04F7, 0x14FB,
    0x0997, 0x0A7F, 0x08C2, 0x0417, 0x0434, 0x0477,
    0x037B, 0x0463, 0x02EF, 0x0592, 0x02E5, 0x049B,
    0x035A, 0x0436, 0x05AF, 0x0687, 0x0896, 0x095F,
    0x09BE, 0x0996, 0x0558, 0x088F, 0x0B8E, 0x057E,
    0x04CA, 0x05CE, 0x05F3, 0x047A, 0x05A1, 0x02E2,
    0x02FA, 0x0204, 0x022C, 0x020E, 0x0360, 0x02AE,
    0x05FC, 0x0457, 0x05DA, 0x086B, 0x14FA, 0x04B6,
    0x02FE, 0x040A, 0x02E6, 0x0576, 0x044A, 0x028C,
    0x0212, 0x0248, 0x02E0, 0x029A, 0x0126, 0x017E,
    0x0130, 0x024C, 0x0232, 0x0596, 0x0378, 0x053A,
    0x04CC, 0x0A7C, 0x0470, 0x0593, 0x02D8, 0x029C,
    0x02D9, 0x02BE, 0x01A0, 0x014E, 0x0120, 0x013C,
    0x06EC, 0x04CD, 0x0559, 0x06B6, 0x0420, 0x057F,
    0x0596, 0x09BF, 0x0532, 0x055A, 0x095E, 0x08BC,
    0x0472, 0x02CA, 0x05F2, 0x05FD, 0x047E, 0x05A2,
    0x06EA, 0x05CF, 0x04D2, 0x043F, 0x028E, 0x0422,
    0x0460, 0x05DE, 0x053B, 0x08F6, 0x0B8F, 0x02CE,
    0x0473, 0x06ED, 0x0421, 0x028D, 0x023C, 0x047F,
    0x05A3, 0x044C, 0x044D, 0x0457, 0x02CA, 0x02D8,
    0x027C, 0x029E, 0x023E, 0x027D, 0x0361, 0x0414,
    0x05BC, 0x08BD, 0x02DA, 0x024A, 0x0437, 0x055B,
    0x0379, 0x01BE, 0x05DF, 0x04D3, 0x0268, 0x0206,
    0x0213, 0x02BA, 0x0203, 0x0236, 0x0127, 0x0136,
    0x0268, 0x0242, 0x02CF, 0x05FE, 0x05D2, 0x0237,
    0x0243, 0x0472, 0x0362, 0x027A, 0x02AE, 0x0471,
    0x0474, 0x024B, 0x02AF, 0x01A6, 0x012C, 0x0166,
    0x0166, 0x00A6, 0x00AC, 0x0100, 0x01B2, 0x020F,
    0x0363, 0x0446, 0x016A, 0x022E, 0x0577, 0x02FF,
    0x022D, 0x0168, 0x0475, 0x027E, 0x0222, 0x01A2,
    0x017B, 0x00D2, 0x00BE, 0x0050, 0x0054, 0x006A,
    0x011A, 0x0143, 0x024F, 0x02E7, 0x0447, 0x0110,
    0x0233, 0x02D9, 0x02AF, 0x024E, 0x016A, 0x0536,
    0x0342, 0x02BC, 0x0176, 0x00DA, 0x0054, 0x004A,
    0x000E, 0x0010, 0x004C, 0x00DC, 0x0164, 0x023A,
    0x0476, 0x04CE, 0x0118, 0x02CE, 0x025E, 0x0346,
    0x02A8, 0x0122, 0x05BD, 0x022F, 0x02EA, 0x014A,
    0x00AA, 0x0051, 0x000F,
};

static const uint8_t on2avc_cb12_bits[ON2AVC_CB12_CODES] = {
     2,  4,  7,  9, 10, 11,
    12, 13, 10, 11, 11, 11,
    11, 10, 12, 12, 11, 11,
     9,  7,  4,  4,  5,  7,
     9, 10, 10, 11, 12, 10,
    10, 11, 11, 10,  9, 12,
    11, 10, 10,  9,  7,  5,
     7,  7,  8,  9, 10, 10,
    11, 12, 10, 10, 11, 11,
    10, 10, 12, 11, 10, 10,
     9,  8,  7,  9,  9,  9,
     9, 10, 10, 11, 11, 10,
    11, 11, 11, 11, 10, 12,
    11, 10, 10, 10,  9,  9,
    10, 10, 10, 10, 10, 11,
    11, 12, 10, 11, 11, 12,
    11, 10, 12, 12, 11, 10,
    10, 10, 10, 11, 10, 11,
    10, 11, 11, 12, 12, 10,
    11, 11, 12, 11, 10, 12,
    12, 11, 11, 11, 10, 10,
    12, 11, 11, 11, 11, 11,
    12, 12, 10, 11, 12, 12,
    11, 11, 12, 12, 12, 11,
    11, 11, 10, 12, 12, 12,
    12, 11, 12, 12, 12, 10,
    11, 12, 12, 11, 11, 12,
    13, 12, 12, 12, 11, 12,
    10, 10, 10, 10, 10, 10,
    10, 10, 10, 11, 12, 13,
    12, 12, 11, 11, 11, 10,
    10, 10, 10, 11, 10, 10,
    11, 11, 11, 11, 11, 11,
    12, 12, 13, 12, 12, 12,
    11, 11, 11, 11, 11, 10,
    11, 11, 11, 11, 12, 12,
    12, 12, 12, 12, 12, 14,
    13, 13, 12, 12, 12, 11,
    11, 11, 11, 11, 11, 11,
    11, 12, 11, 12, 12, 13,
    12, 13, 12, 12, 12, 12,
    12, 11, 11, 11, 11, 11,
    10, 11, 11, 11, 11, 11,
    11, 12, 11, 13, 14, 12,
    11, 12, 11, 11, 11, 11,
    11, 11, 10, 10, 10,  9,
    10, 10, 10, 11, 11, 11,
    12, 13, 12, 11, 10, 10,
    10, 10, 10, 10, 10, 10,
    12, 12, 12, 12, 12, 12,
    12, 12, 11, 12, 13, 12,
    11, 10, 11, 11, 11, 11,
    12, 11, 11, 12, 11, 12,
    11, 11, 11, 12, 12, 11,
    11, 12, 12, 11, 10, 12,
    11, 11, 11, 11, 11, 11,
    11, 10, 10, 11, 11, 12,
    11, 12, 10, 11, 12, 12,
    11, 10, 11, 11, 11, 11,
    11, 10, 11, 10, 10, 10,
    10, 11, 11, 11, 11, 10,
    11, 12, 11, 11, 10, 12,
    11, 11, 10, 10, 10, 10,
     9,  9,  9, 10, 10, 11,
    11, 12, 10, 11, 11, 11,
    11, 10, 11, 11, 11, 10,
     9,  9,  9,  7,  7,  8,
     9, 10, 10, 11, 12, 10,
    10, 11, 11, 10,  9, 11,
    11, 10, 10,  9,  8,  7,
     4,  5,  7,  9, 10, 11,
    11, 12, 10, 10, 11, 11,
    10, 10, 11, 11, 10, 10,
     9,  7,  5,
};

static const uint16_t on2avc_cb12_syms[ON2AVC_CB12_CODES] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005,
    0x0006, 0x0007, 0x0008, 0x0009, 0x000A, 0x00F6,
    0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC,
    0x00FD, 0x00FE, 0x00FF, 0x0100, 0x0101, 0x0102,
    0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108,
    0x0109, 0x010A, 0x01F6, 0x01F7, 0x01F8, 0x01F9,
    0x01FA, 0x01FB, 0x01FC, 0x01FD, 0x01FE, 0x01FF,
    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205,
    0x0206, 0x0207, 0x0208, 0x0209, 0x020A, 0x02F6,
    0x02F7, 0x02F8, 0x02F9, 0x02FA, 0x02FB, 0x02FC,
    0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302,
    0x0303, 0x0304, 0x0305, 0x0306, 0x0307, 0x0308,
    0x0309, 0x030A, 0x03F6, 0x03F7, 0x03F8, 0x03F9,
    0x03FA, 0x03FB, 0x03FC, 0x03FD, 0x03FE, 0x03FF,
    0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405,
    0x0406, 0x0407, 0x0408, 0x0409, 0x040A, 0x04F6,
    0x04F7, 0x04F8, 0x04F9, 0x04FA, 0x04FB, 0x04FC,
    0x04FD, 0x04FE, 0x04FF, 0x0500, 0x0501, 0x0502,
    0x0503, 0x0504, 0x0505, 0x0506, 0x0507, 0x0508,
    0x0509, 0x050A, 0x05F6, 0x05F7, 0x05F8, 0x05F9,
    0x05FA, 0x05FB, 0x05FC, 0x05FD, 0x05FE, 0x05FF,
    0x0600, 0x0601, 0x0602, 0x0603, 0x0604, 0x0605,
    0x0606, 0x0607, 0x0608, 0x0609, 0x060A, 0x06F6,
    0x06F7, 0x06F8, 0x06F9, 0x06FA, 0x06FB, 0x06FC,
    0x06FD, 0x06FE, 0x06FF, 0x0700, 0x0701, 0x0702,
    0x0703, 0x0704, 0x0705, 0x0706, 0x0707, 0x0708,
    0x0709, 0x070A, 0x07F6, 0x07F7, 0x07F8, 0x07F9,
    0x07FA, 0x07FB, 0x07FC, 0x07FD, 0x07FE, 0x07FF,
    0x0800, 0x0801, 0x0802, 0x0803, 0x0804, 0x0805,
    0x0806, 0x0807, 0x0808, 0x0809, 0x080A, 0x08F6,
    0x08F7, 0x08F8, 0x08F9, 0x08FA, 0x08FB, 0x08FC,
    0x08FD, 0x08FE, 0x08FF, 0x0900, 0x0901, 0x0902,
    0x0903, 0x0904, 0x0905, 0x0906, 0x0907, 0x0908,
    0x0909, 0x090A, 0x09F6, 0x09F7, 0x09F8, 0x09F9,
    0x09FA, 0x09FB, 0x09FC, 0x09FD, 0x09FE, 0x09FF,
    0x0A00, 0x0A01, 0x0A02, 0x0A03, 0x0A04, 0x0A05,
    0x0A06, 0x0A07, 0x0A08, 0x0A09, 0x0A0A, 0x0AF6,
    0x0AF7, 0x0AF8, 0x0AF9, 0x0AFA, 0x0AFB, 0x0AFC,
    0x0AFD, 0x0AFE, 0x0AFF, 0xF600, 0xF601, 0xF602,
    0xF603, 0xF604, 0xF605, 0xF606, 0xF607, 0xF608,
    0xF609, 0xF60A, 0xF6F6, 0xF6F7, 0xF6F8, 0xF6F9,
    0xF6FA, 0xF6FB, 0xF6FC, 0xF6FD, 0xF6FE, 0xF6FF,
    0xF700, 0xF701, 0xF702, 0xF703, 0xF704, 0xF705,
    0xF706, 0xF707, 0xF708, 0xF709, 0xF70A, 0xF7F6,
    0xF7F7, 0xF7F8, 0xF7F9, 0xF7FA, 0xF7FB, 0xF7FC,
    0xF7FD, 0xF7FE, 0xF7FF, 0xF800, 0xF801, 0xF802,
    0xF803, 0xF804, 0xF805, 0xF806, 0xF807, 0xF808,
    0xF809, 0xF80A, 0xF8F6, 0xF8F7, 0xF8F8, 0xF8F9,
    0xF8FA, 0xF8FB, 0xF8FC, 0xF8FD, 0xF8FE, 0xF8FF,
    0xF900, 0xF901, 0xF902, 0xF903, 0xF904, 0xF905,
    0xF906, 0xF907, 0xF908, 0xF909, 0xF90A, 0xF9F6,
    0xF9F7, 0xF9F8, 0xF9F9, 0xF9FA, 0xF9FB, 0xF9FC,
    0xF9FD, 0xF9FE, 0xF9FF, 0xFA00, 0xFA01, 0xFA02,
    0xFA03, 0xFA04, 0xFA05, 0xFA06, 0xFA07, 0xFA08,
    0xFA09, 0xFA0A, 0xFAF6, 0xFAF7, 0xFAF8, 0xFAF9,
    0xFAFA, 0xFAFB, 0xFAFC, 0xFAFD, 0xFAFE, 0xFAFF,
    0xFB00, 0xFB01, 0xFB02, 0xFB03, 0xFB04, 0xFB05,
    0xFB06, 0xFB07, 0xFB08, 0xFB09, 0xFB0A, 0xFBF6,
    0xFBF7, 0xFBF8, 0xFBF9, 0xFBFA, 0xFBFB, 0xFBFC,
    0xFBFD, 0xFBFE, 0xFBFF, 0xFC00, 0xFC01, 0xFC02,
    0xFC03, 0xFC04, 0xFC05, 0xFC06, 0xFC07, 0xFC08,
    0xFC09, 0xFC0A, 0xFCF6, 0xFCF7, 0xFCF8, 0xFCF9,
    0xFCFA, 0xFCFB, 0xFCFC, 0xFCFD, 0xFCFE, 0xFCFF,
    0xFD00, 0xFD01, 0xFD02, 0xFD03, 0xFD04, 0xFD05,
    0xFD06, 0xFD07, 0xFD08, 0xFD09, 0xFD0A, 0xFDF6,
    0xFDF7, 0xFDF8, 0xFDF9, 0xFDFA, 0xFDFB, 0xFDFC,
    0xFDFD, 0xFDFE, 0xFDFF, 0xFE00, 0xFE01, 0xFE02,
    0xFE03, 0xFE04, 0xFE05, 0xFE06, 0xFE07, 0xFE08,
    0xFE09, 0xFE0A, 0xFEF6, 0xFEF7, 0xFEF8, 0xFEF9,
    0xFEFA, 0xFEFB, 0xFEFC, 0xFEFD, 0xFEFE, 0xFEFF,
    0xFF00, 0xFF01, 0xFF02, 0xFF03, 0xFF04, 0xFF05,
    0xFF06, 0xFF07, 0xFF08, 0xFF09, 0xFF0A, 0xFFF6,
    0xFFF7, 0xFFF8, 0xFFF9, 0xFFFA, 0xFFFB, 0xFFFC,
    0xFFFD, 0xFFFE, 0xFFFF,
};

#define ON2AVC_CB13_CODES 625
static const uint16_t on2avc_cb13_codes[ON2AVC_CB13_CODES] = {
    0x0000, 0x0015, 0x008E, 0x0338, 0x09FB, 0x0BEC,
    0x0C61, 0x13E1, 0x18A7, 0x313B, 0x61BB, 0x05D9,
    0x0896, 0x066B, 0x05C6, 0x18A6, 0x40E4, 0x2081,
    0x104F, 0x13E0, 0x0C22, 0x07E4, 0x03F7, 0x0087,
    0x0014, 0x0016, 0x001D, 0x009C, 0x02E2, 0x037E,
    0x0897, 0x0898, 0x0C63, 0x117D, 0x2082, 0x27AA,
    0x033B, 0x06C5, 0x04F2, 0x0331, 0x19EB, 0x18A8,
    0x13E2, 0x0DE7, 0x0C62, 0x06DF, 0x05C7, 0x02F4,
    0x0098, 0x001A, 0x007C, 0x0080, 0x0106, 0x02F5,
    0x03EC, 0x0617, 0x0621, 0x08F9, 0x1050, 0x117F,
    0x11E0, 0x036A, 0x045A, 0x06C6, 0x037F, 0x117E,
    0x2083, 0x0BED, 0x0C9E, 0x0658, 0x04F3, 0x0368,
    0x02EE, 0x00FA, 0x008D, 0x031C, 0x01FF, 0x0206,
    0x031E, 0x06C8, 0x0659, 0x09B5, 0x0C23, 0x0BEF,
    0x0C9F, 0x19EC, 0x04CC, 0x0623, 0x06C7, 0x0622,
    0x313C, 0x17BB, 0x11E1, 0x0C64, 0x0BEE, 0x07DC,
    0x04CB, 0x0375, 0x0205, 0x026E, 0x0C24, 0x06C9,
    0x0324, 0x04DF, 0x0642, 0x09B6, 0x0643, 0x0BF2,
    0x083B, 0x1051, 0x27AB, 0x036C, 0x0607, 0x06E2,
    0x045B, 0x313D, 0x2084, 0x18A9, 0x13E3, 0x0CA0,
    0x0899, 0x066E, 0x06E3, 0x0369, 0x0606, 0x0DE8,
    0x061A, 0x0453, 0x065A, 0x065B, 0x089B, 0x089C,
    0x09FD, 0x0BA5, 0x18AA, 0x11E2, 0x05C8, 0x09B7,
    0x066F, 0x06CA, 0x19ED, 0x2085, 0x2086, 0x0D83,
    0x1052, 0x1053, 0x09FC, 0x089A, 0x0644, 0x083E,
    0x13E4, 0x08FC, 0x0624, 0x1055, 0x0C65, 0x089D,
    0x0645, 0x08FD, 0x0C66, 0x0CA1, 0x1056, 0x05E1,
    0x089E, 0x08FA, 0x07E5, 0x313E, 0x2087, 0x11E3,
    0x19EE, 0x18AB, 0x1054, 0x19EF, 0x17BC, 0x08FB,
    0x07E6, 0x18AD, 0x0BF3, 0x07E7, 0x0C67, 0x1057,
    0x07EA, 0x08FF, 0x1058, 0x0DE9, 0x18AE, 0x19F0,
    0x0608, 0x089F, 0x08FE, 0x06CB, 0x313F, 0x2088,
    0x13E5, 0x3142, 0x11E4, 0x18AC, 0x11E5, 0x0CA2,
    0x065E, 0x13E6, 0x27AD, 0x19F1, 0x0D86, 0x0DEA,
    0x0CA3, 0x0DEB, 0x17BE, 0x0C2A, 0x13E8, 0x0CA6,
    0x0DEE, 0x05FD, 0x0992, 0x0C25, 0x063E, 0x40E5,
    0x11E6, 0x3143, 0x18AF, 0x27AC, 0x0C26, 0x17BD,
    0x13E7, 0x0C27, 0x11E7, 0x27B2, 0x40E8, 0x18B3,
    0x17C0, 0x18FE, 0x19F2, 0x19F3, 0x31FE, 0x17C1,
    0x19F6, 0x0BA6, 0x09FE, 0x0DEF, 0x17BF, 0x0C2B,
    0x40E6, 0x18B0, 0x40E7, 0x13E9, 0x2089, 0x27AE,
    0x27AF, 0x208A, 0x18B1, 0x18B2, 0x27B3, 0xBCEF,
    0x2F3A, 0x40EA, 0x17C5, 0x17C6, 0x17C7, 0x19F7,
    0x133E, 0x105A, 0x17CA, 0x065F, 0x0CA7, 0x0C7E,
    0x1059, 0xBCED, 0x40E9, 0xBCEE, 0x17C2, 0x63FE,
    0x208B, 0x208E, 0x208F, 0x17C3, 0x17C4, 0x0625,
    0x03ED, 0x045C, 0x04CD, 0x05DA, 0x05CE, 0x05FF,
    0x0626, 0x060A, 0x05E3, 0x083F, 0x0BA8, 0x0BA9,
    0x40EB, 0x13EA, 0x0CCA, 0x0BA7, 0x08A2, 0x0646,
    0x0609, 0x05E2, 0x041E, 0x05FE, 0x0373, 0x0376,
    0x099E, 0x05DE, 0x0647, 0x05E6, 0x06D6, 0x07EB,
    0x09FF, 0x1B5E, 0x0BAB, 0x08AE, 0x0C36, 0x0FBA,
    0x17CB, 0x4CFE, 0x105B, 0x0D87, 0x0DAE, 0x13EB,
    0x0BAA, 0x0993, 0x08A3, 0x085E, 0x0600, 0x0601,
    0x05DB, 0x0664, 0x04F0, 0x05F8, 0x0634, 0x085F,
    0x06F6, 0x08F4, 0x0C5A, 0x0CFC, 0x0DDC, 0x09F6,
    0x0C16, 0x115E, 0x13D8, 0x13DA, 0x0C94, 0x0CFA,
    0x082E, 0x0B9E, 0x06C2, 0x0BE4, 0x06DA, 0x05C0,
    0x0614, 0x05C9, 0x05DF, 0x033A, 0x0336, 0x05FA,
    0x04CE, 0x05C1, 0x0890, 0x0891, 0x0838, 0x0839,
    0x0CFD, 0x0BA0, 0x61B8, 0x07DE, 0x0635, 0x0B9F,
    0x0640, 0x06DB, 0x082F, 0x09AC, 0x04C8, 0x0666,
    0x04DE, 0x03F4, 0x0339, 0x2079, 0x267E, 0x179E,
    0x30DE, 0x63FF, 0x27A0, 0x1997, 0x36BF, 0x3EEC,
    0x99FE, 0x99FF, 0x0C95, 0x1048, 0x0C5B, 0x0636,
    0x0C5C, 0x2076, 0x13DB, 0x115F, 0x179C, 0x2077,
    0x1046, 0x36BE, 0x1996, 0x2078, 0x61B9, 0x1175,
    0x17B0, 0x3EED, 0x19E1, 0x19E2, 0x207A, 0x3EEE,
    0xBCEC, 0x3138, 0x3139, 0x07DF, 0x1176, 0x0892,
    0x0667, 0x18A0, 0x18A2, 0x13DC, 0x1174, 0x13DD,
    0x179F, 0x30DF, 0x19E0, 0x18A3, 0x1049, 0x17B2,
    0x207B, 0x17B3, 0x0C17, 0x19E3, 0x17B4, 0x207C,
    0x3EEF, 0x207D, 0x19E4, 0x27A1, 0x0C5F, 0x08F5,
    0x0DDD, 0x0652, 0x18A4, 0x0C96, 0x0C5D, 0x104A,
    0x1177, 0x0CFE, 0x0C5E, 0x0DDE, 0x09F7, 0x17B1,
    0x19E6, 0x0C1E, 0x09AE, 0x1179, 0x0DE0, 0x17B5,
    0x0BA2, 0x17B6, 0x27A3, 0x40E0, 0x40E1, 0x06DC,
    0x09AF, 0x09AD, 0x05C2, 0x19E5, 0x27A2, 0x0DDF,
    0x0C1C, 0x0C1D, 0x0BE6, 0x0BA1, 0x1178, 0x0654,
    0x13DE, 0x40E2, 0x0893, 0x0668, 0x07E1, 0x0BE7,
    0x08F6, 0x0DE1, 0x27A4, 0x104B, 0x19E7, 0x40E3,
    0x05D6, 0x09F9, 0x06DD, 0x04CA, 0x17B7, 0x17B8,
    0x0C97, 0x0C98, 0x07E0, 0x0C99, 0x0655, 0x09F8,
    0x0656, 0x0C9A, 0x0DE2, 0x0669, 0x04D3, 0x061C,
    0x0894, 0x13DF, 0x0C1F, 0x104C, 0x27A6, 0x61BA,
    0x27A7, 0x066A, 0x061D, 0x0637, 0x04D2, 0x27A5,
    0x117A, 0x0C9B, 0x09B0, 0x09B1, 0x05E0, 0x0602,
    0x05FB, 0x04F1, 0x08F7, 0x06FA, 0x0603, 0x037C,
    0x05C3, 0x0BE8, 0x0895, 0x0C60, 0x117B, 0x19E8,
    0x27A8, 0x19E9, 0x0657, 0x083A, 0x06C4, 0x05D7,
    0x17B9, 0x0CFF, 0x0DE3, 0x104D, 0x07E2, 0x0641,
    0x061E, 0x05D8, 0x0366, 0x0616, 0x032E, 0x0268,
    0x02E6, 0x0456, 0x0BA3, 0x06FB, 0x0D80, 0x0DE5,
    0x104E, 0x17BA, 0x27A9, 0x0330, 0x07E3, 0x061F,
    0x0367, 0x207E, 0x0C9C, 0x117C, 0x0DE4, 0x06DE,
    0x0620, 0x0450, 0x042E, 0x02F2, 0x0204, 0x0086,
    0x008C, 0x00FE, 0x022A, 0x0372, 0x05CA, 0x0452,
    0x08F8, 0x0BA4, 0x19EA, 0x18A5, 0x0306, 0x05FC,
    0x03F6, 0x0458, 0x0D81, 0x0BE9, 0x09B2, 0x0C20,
    0x09FA, 0x0604, 0x0370, 0x01FE, 0x010A, 0x0084,
    0x0012, 0x001C, 0x0088, 0x026A, 0x05CB, 0x063B,
    0x09B4, 0x0D82, 0x0DE6, 0x207F, 0x2080, 0x030C,
    0x0605, 0x0459, 0x0374, 0x313A, 0x0C9D, 0x0BEA,
    0x0BEB, 0x0C21, 0x09B3, 0x063A, 0x0216, 0x009D,
    0x001E,
};

static const uint8_t on2avc_cb13_bits[ON2AVC_CB13_CODES] = {
     1,  5,  8, 10, 12, 12,
    12, 13, 13, 14, 15, 11,
    12, 11, 11, 13, 15, 14,
    13, 13, 12, 11, 10,  8,
     5,  5,  5,  8, 10, 10,
    12, 12, 12, 13, 14, 14,
    10, 11, 11, 10, 13, 13,
    13, 12, 12, 11, 11, 10,
     8,  5,  7,  8,  9, 10,
    10, 11, 11, 12, 13, 13,
    13, 10, 11, 11, 10, 13,
    14, 12, 12, 11, 11, 10,
    10,  8,  8, 10,  9, 10,
    10, 11, 11, 12, 12, 12,
    12, 13, 11, 11, 11, 11,
    14, 13, 13, 12, 12, 11,
    11, 10, 10, 10, 12, 11,
    10, 11, 11, 12, 11, 12,
    12, 13, 14, 10, 11, 11,
    11, 14, 14, 13, 13, 12,
    12, 11, 11, 10, 11, 12,
    11, 11, 11, 11, 12, 12,
    12, 12, 13, 13, 11, 12,
    11, 11, 13, 14, 14, 12,
    13, 13, 12, 12, 11, 12,
    13, 12, 11, 13, 12, 12,
    11, 12, 12, 12, 13, 11,
    12, 12, 11, 14, 14, 13,
    13, 13, 13, 13, 13, 12,
    11, 13, 12, 11, 12, 13,
    11, 12, 13, 12, 13, 13,
    11, 12, 12, 11, 14, 14,
    13, 14, 13, 13, 13, 12,
    11, 13, 14, 13, 12, 12,
    12, 12, 13, 12, 13, 12,
    12, 11, 12, 12, 11, 15,
    13, 14, 13, 14, 12, 13,
    13, 12, 13, 14, 15, 13,
    13, 13, 13, 13, 14, 13,
    13, 12, 12, 12, 13, 12,
    15, 13, 15, 13, 14, 14,
    14, 14, 13, 13, 14, 16,
    14, 15, 13, 13, 13, 13,
    13, 13, 13, 11, 12, 12,
    13, 16, 15, 16, 13, 15,
    14, 14, 14, 13, 13, 11,
    10, 11, 11, 11, 11, 11,
    11, 11, 11, 12, 12, 12,
    15, 13, 12, 12, 12, 11,
    11, 11, 11, 11, 10, 10,
    12, 11, 11, 11, 11, 11,
    12, 13, 12, 12, 12, 12,
    13, 15, 13, 12, 12, 13,
    12, 12, 12, 12, 11, 11,
    11, 11, 11, 11, 11, 12,
    11, 12, 12, 12, 12, 12,
    12, 13, 13, 13, 12, 12,
    12, 12, 11, 12, 11, 11,
    11, 11, 11, 10, 10, 11,
    11, 11, 12, 12, 12, 12,
    12, 12, 15, 11, 11, 12,
    11, 11, 12, 12, 11, 11,
    11, 10, 10, 14, 14, 13,
    14, 15, 14, 13, 14, 14,
    16, 16, 12, 13, 12, 11,
    12, 14, 13, 13, 13, 14,
    13, 14, 13, 14, 15, 13,
    13, 14, 13, 13, 14, 14,
    16, 14, 14, 11, 13, 12,
    11, 13, 13, 13, 13, 13,
    13, 14, 13, 13, 13, 13,
    14, 13, 12, 13, 13, 14,
    14, 14, 13, 14, 12, 12,
    12, 11, 13, 12, 12, 13,
    13, 12, 12, 12, 12, 13,
    13, 12, 12, 13, 12, 13,
    12, 13, 14, 15, 15, 11,
    12, 12, 11, 13, 14, 12,
    12, 12, 12, 12, 13, 11,
    13, 15, 12, 11, 11, 12,
    12, 12, 14, 13, 13, 15,
    11, 12, 11, 11, 13, 13,
    12, 12, 11, 12, 11, 12,
    11, 12, 12, 11, 11, 11,
    12, 13, 12, 13, 14, 15,
    14, 11, 11, 11, 11, 14,
    13, 12, 12, 12, 11, 11,
    11, 11, 12, 11, 11, 10,
    11, 12, 12, 12, 13, 13,
    14, 13, 11, 12, 11, 11,
    13, 12, 12, 13, 11, 11,
    11, 11, 10, 11, 10, 10,
    10, 11, 12, 11, 12, 12,
    13, 13, 14, 10, 11, 11,
    10, 14, 12, 13, 12, 11,
    11, 11, 11, 10, 10,  8,
     8,  8, 10, 10, 11, 11,
    12, 12, 13, 13, 10, 11,
    10, 11, 12, 12, 12, 12,
    12, 11, 10,  9,  9,  8,
     5,  5,  8, 10, 11, 11,
    12, 12, 12, 14, 14, 10,
    11, 11, 10, 14, 12, 12,
    12, 12, 12, 11, 10,  8,
     5,
};

static const uint16_t on2avc_cb13_syms[ON2AVC_CB13_CODES] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005,
    0x0006, 0x0007, 0x0008, 0x0009, 0x000A, 0x000B,
    0x000C, 0x00F4, 0x00F5, 0x00F6, 0x00F7, 0x00F8,
    0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE,
    0x00FF, 0x0100, 0x0101, 0x0102, 0x0103, 0x0104,
    0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010A,
    0x010B, 0x010C, 0x01F4, 0x01F5, 0x01F6, 0x01F7,
    0x01F8, 0x01F9, 0x01FA, 0x01FB, 0x01FC, 0x01FD,
    0x01FE, 0x01FF, 0x0200, 0x0201, 0x0202, 0x0203,
    0x0204, 0x0205, 0x0206, 0x0207, 0x0208, 0x0209,
    0x020A, 0x020B, 0x020C, 0x02F4, 0x02F5, 0x02F6,
    0x02F7, 0x02F8, 0x02F9, 0x02FA, 0x02FB, 0x02FC,
    0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302,
    0x0303, 0x0304, 0x0305, 0x0306, 0x0307, 0x0308,
    0x0309, 0x030A, 0x030B, 0x030C, 0x03F4, 0x03F5,
    0x03F6, 0x03F7, 0x03F8, 0x03F9, 0x03FA, 0x03FB,
    0x03FC, 0x03FD, 0x03FE, 0x03FF, 0x0400, 0x0401,
    0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0407,
    0x0408, 0x0409, 0x040A, 0x040B, 0x040C, 0x04F4,
    0x04F5, 0x04F6, 0x04F7, 0x04F8, 0x04F9, 0x04FA,
    0x04FB, 0x04FC, 0x04FD, 0x04FE, 0x04FF, 0x0500,
    0x0501, 0x0502, 0x0503, 0x0504, 0x0505, 0x0506,
    0x0507, 0x0508, 0x0509, 0x050A, 0x050B, 0x050C,
    0x05F4, 0x05F5, 0x05F6, 0x05F7, 0x05F8, 0x05F9,
    0x05FA, 0x05FB, 0x05FC, 0x05FD, 0x05FE, 0x05FF,
    0x0600, 0x0601, 0x0602, 0x0603, 0x0604, 0x0605,
    0x0606, 0x0607, 0x0608, 0x0609, 0x060A, 0x060B,
    0x060C, 0x06F4, 0x06F5, 0x06F6, 0x06F7, 0x06F8,
    0x06F9, 0x06FA, 0x06FB, 0x06FC, 0x06FD, 0x06FE,
    0x06FF, 0x0700, 0x0701, 0x0702, 0x0703, 0x0704,
    0x0705, 0x0706, 0x0707, 0x0708, 0x0709, 0x070A,
    0x070B, 0x070C, 0x07F4, 0x07F5, 0x07F6, 0x07F7,
    0x07F8, 0x07F9, 0x07FA, 0x07FB, 0x07FC, 0x07FD,
    0x07FE, 0x07FF, 0x0800, 0x0801, 0x0802, 0x0803,
    0x0804, 0x0805, 0x0806, 0x0807, 0x0808, 0x0809,
    0x080A, 0x080B, 0x080C, 0x08F4, 0x08F5, 0x08F6,
    0x08F7, 0x08F8, 0x08F9, 0x08FA, 0x08FB, 0x08FC,
    0x08FD, 0x08FE, 0x08FF, 0x0900, 0x0901, 0x0902,
    0x0903, 0x0904, 0x0905, 0x0906, 0x0907, 0x0908,
    0x0909, 0x090A, 0x090B, 0x090C, 0x09F4, 0x09F5,
    0x09F6, 0x09F7, 0x09F8, 0x09F9, 0x09FA, 0x09FB,
    0x09FC, 0x09FD, 0x09FE, 0x09FF, 0x0A00, 0x0A01,
    0x0A02, 0x0A03, 0x0A04, 0x0A05, 0x0A06, 0x0A07,
    0x0A08, 0x0A09, 0x0A0A, 0x0A0B, 0x0A0C, 0x0AF4,
    0x0AF5, 0x0AF6, 0x0AF7, 0x0AF8, 0x0AF9, 0x0AFA,
    0x0AFB, 0x0AFC, 0x0AFD, 0x0AFE, 0x0AFF, 0x0B00,
    0x0B01, 0x0B02, 0x0B03, 0x0B04, 0x0B05, 0x0B06,
    0x0B07, 0x0B08, 0x0B09, 0x0B0A, 0x0B0B, 0x0B0C,
    0x0BF4, 0x0BF5, 0x0BF6, 0x0BF7, 0x0BF8, 0x0BF9,
    0x0BFA, 0x0BFB, 0x0BFC, 0x0BFD, 0x0BFE, 0x0BFF,
    0x0C00, 0x0C01, 0x0C02, 0x0C03, 0x0C04, 0x0C05,
    0x0C06, 0x0C07, 0x0C08, 0x0C09, 0x0C0A, 0x0C0B,
    0x0C0C, 0x0CF4, 0x0CF5, 0x0CF6, 0x0CF7, 0x0CF8,
    0x0CF9, 0x0CFA, 0x0CFB, 0x0CFC, 0x0CFD, 0x0CFE,
    0x0CFF, 0xF400, 0xF401, 0xF402, 0xF403, 0xF404,
    0xF405, 0xF406, 0xF407, 0xF408, 0xF409, 0xF40A,
    0xF40B, 0xF40C, 0xF4F4, 0xF4F5, 0xF4F6, 0xF4F7,
    0xF4F8, 0xF4F9, 0xF4FA, 0xF4FB, 0xF4FC, 0xF4FD,
    0xF4FE, 0xF4FF, 0xF500, 0xF501, 0xF502, 0xF503,
    0xF504, 0xF505, 0xF506, 0xF507, 0xF508, 0xF509,
    0xF50A, 0xF50B, 0xF50C, 0xF5F4, 0xF5F5, 0xF5F6,
    0xF5F7, 0xF5F8, 0xF5F9, 0xF5FA, 0xF5FB, 0xF5FC,
    0xF5FD, 0xF5FE, 0xF5FF, 0xF600, 0xF601, 0xF602,
    0xF603, 0xF604, 0xF605, 0xF606, 0xF607, 0xF608,
    0xF609, 0xF60A, 0xF60B, 0xF60C, 0xF6F4, 0xF6F5,
    0xF6F6, 0xF6F7, 0xF6F8, 0xF6F9, 0xF6FA, 0xF6FB,
    0xF6FC, 0xF6FD, 0xF6FE, 0xF6FF, 0xF700, 0xF701,
    0xF702, 0xF703, 0xF704, 0xF705, 0xF706, 0xF707,
    0xF708, 0xF709, 0xF70A, 0xF70B, 0xF70C, 0xF7F4,
    0xF7F5, 0xF7F6, 0xF7F7, 0xF7F8, 0xF7F9, 0xF7FA,
    0xF7FB, 0xF7FC, 0xF7FD, 0xF7FE, 0xF7FF, 0xF800,
    0xF801, 0xF802, 0xF803, 0xF804, 0xF805, 0xF806,
    0xF807, 0xF808, 0xF809, 0xF80A, 0xF80B, 0xF80C,
    0xF8F4, 0xF8F5, 0xF8F6, 0xF8F7, 0xF8F8, 0xF8F9,
    0xF8FA, 0xF8FB, 0xF8FC, 0xF8FD, 0xF8FE, 0xF8FF,
    0xF900, 0xF901, 0xF902, 0xF903, 0xF904, 0xF905,
    0xF906, 0xF907, 0xF908, 0xF909, 0xF90A, 0xF90B,
    0xF90C, 0xF9F4, 0xF9F5, 0xF9F6, 0xF9F7, 0xF9F8,
    0xF9F9, 0xF9FA, 0xF9FB, 0xF9FC, 0xF9FD, 0xF9FE,
    0xF9FF, 0xFA00, 0xFA01, 0xFA02, 0xFA03, 0xFA04,
    0xFA05, 0xFA06, 0xFA07, 0xFA08, 0xFA09, 0xFA0A,
    0xFA0B, 0xFA0C, 0xFAF4, 0xFAF5, 0xFAF6, 0xFAF7,
    0xFAF8, 0xFAF9, 0xFAFA, 0xFAFB, 0xFAFC, 0xFAFD,
    0xFAFE, 0xFAFF, 0xFB00, 0xFB01, 0xFB02, 0xFB03,
    0xFB04, 0xFB05, 0xFB06, 0xFB07, 0xFB08, 0xFB09,
    0xFB0A, 0xFB0B, 0xFB0C, 0xFBF4, 0xFBF5, 0xFBF6,
    0xFBF7, 0xFBF8, 0xFBF9, 0xFBFA, 0xFBFB, 0xFBFC,
    0xFBFD, 0xFBFE, 0xFBFF, 0xFC00, 0xFC01, 0xFC02,
    0xFC03, 0xFC04, 0xFC05, 0xFC06, 0xFC07, 0xFC08,
    0xFC09, 0xFC0A, 0xFC0B, 0xFC0C, 0xFCF4, 0xFCF5,
    0xFCF6, 0xFCF7, 0xFCF8, 0xFCF9, 0xFCFA, 0xFCFB,
    0xFCFC, 0xFCFD, 0xFCFE, 0xFCFF, 0xFD00, 0xFD01,
    0xFD02, 0xFD03, 0xFD04, 0xFD05, 0xFD06, 0xFD07,
    0xFD08, 0xFD09, 0xFD0A, 0xFD0B, 0xFD0C, 0xFDF4,
    0xFDF5, 0xFDF6, 0xFDF7, 0xFDF8, 0xFDF9, 0xFDFA,
    0xFDFB, 0xFDFC, 0xFDFD, 0xFDFE, 0xFDFF, 0xFE00,
    0xFE01, 0xFE02, 0xFE03, 0xFE04, 0xFE05, 0xFE06,
    0xFE07, 0xFE08, 0xFE09, 0xFE0A, 0xFE0B, 0xFE0C,
    0xFEF4, 0xFEF5, 0xFEF6, 0xFEF7, 0xFEF8, 0xFEF9,
    0xFEFA, 0xFEFB, 0xFEFC, 0xFEFD, 0xFEFE, 0xFEFF,
    0xFF00, 0xFF01, 0xFF02, 0xFF03, 0xFF04, 0xFF05,
    0xFF06, 0xFF07, 0xFF08, 0xFF09, 0xFF0A, 0xFF0B,
    0xFF0C, 0xFFF4, 0xFFF5, 0xFFF6, 0xFFF7, 0xFFF8,
    0xFFF9, 0xFFFA, 0xFFFB, 0xFFFC, 0xFFFD, 0xFFFE,
    0xFFFF,
};

#define ON2AVC_CB14_CODES 729
static const uint16_t on2avc_cb14_codes[ON2AVC_CB14_CODES] = {
    0x0000, 0x0018, 0x009C, 0x033F, 0x06CF, 0x0860,
    0x3ED2, 0x15F8, 0x0CA3, 0x15F9, 0x3ED3, 0x3ED4,
    0x3ED5, 0x03B3, 0x0336, 0x3ECF, 0x3ED0, 0x15F5,
    0x15F6, 0x3ED1, 0x1FB6, 0x15F7, 0x0D6D, 0x074E,
    0x02A4, 0x008C, 0x0017, 0x0016, 0x0024, 0x00A8,
    0x02AB, 0x043C, 0x038D, 0x15FA, 0x0CA4, 0x1FB8,
    0x15FB, 0x3ED9, 0x1FB9, 0x15FC, 0x01D8, 0x01F1,
    0x3ED6, 0x1090, 0x1FB7, 0x0D6E, 0x3ED7, 0x3ED8,
    0x074F, 0x0D6F, 0x0750, 0x01F2, 0x0098, 0x0020,
    0x0070, 0x009D, 0x00E4, 0x026F, 0x03AE, 0x055D,
    0x06D0, 0x0862, 0x0667, 0x09ED, 0x1900, 0x3EDA,
    0x1901, 0x01DE, 0x026B, 0x15FD, 0x15FE, 0x1091,
    0x15FF, 0x0D70, 0x0666, 0x0689, 0x0861, 0x034E,
    0x026E, 0x00E8, 0x008E, 0x019E, 0x01BF, 0x01F3,
    0x02B5, 0x054E, 0x0669, 0x09EE, 0x09EF, 0x0D71,
    0x0CA5, 0x1FBB, 0x1FBC, 0x3EDF, 0x02A6, 0x01CA,
    0x3EDB, 0x3EDC, 0x3EDD, 0x3EDE, 0x1FBA, 0x1092,
    0x0863, 0x0751, 0x0668, 0x038E, 0x02B4, 0x01C4,
    0x068A, 0x0CA7, 0x06D1, 0x055F, 0x043E, 0x09F0,
    0x0865, 0x0866, 0x0867, 0x0752, 0x1902, 0x3EE2,
    0x1096, 0x0278, 0x02B6, 0x3EE0, 0x1FBD, 0x3EE1,
    0x0864, 0x1FBE, 0x0CA6, 0x1093, 0x1094, 0x1095,
    0x0478, 0x043D, 0x055E, 0x3EE5, 0x0CA9, 0x066A,
    0x0D75, 0x0560, 0x0561, 0x0868, 0x0D76, 0x0CAA,
    0x0CAB, 0x3EE6, 0x3EE7, 0x3EE8, 0x02AC, 0x038F,
    0x3EE3, 0x1FBF, 0x3EE4, 0x0D72, 0x0D73, 0x0D74,
    0x09F1, 0x068B, 0x0CA8, 0x0479, 0x06D2, 0x1097,
    0x1099, 0x09F3, 0x066B, 0x06D3, 0x0CAD, 0x109A,
    0x06D4, 0x068C, 0x06D5, 0x0D79, 0x0D7A, 0x109B,
    0x1FC1, 0x02B2, 0x0396, 0x3EE9, 0x1903, 0x3EEA,
    0x1904, 0x1905, 0x1FC0, 0x09F2, 0x0D77, 0x0D78,
    0x1098, 0x0562, 0x0CAC, 0x190C, 0x109C, 0x06D6,
    0x0D7C, 0x1FC4, 0x0D7D, 0x09F4, 0x06D7, 0x09F5,
    0x3EEE, 0x0CAE, 0x0D7E, 0x3EEF, 0x03AF, 0x043F,
    0x3EEB, 0x1906, 0x1FC2, 0x1907, 0x3EEC, 0x1908,
    0x1909, 0x190A, 0x1FC3, 0x3EED, 0x0D7B, 0x190B,
    0x1FC6, 0x10A1, 0x10A2, 0x0D7F, 0x0CB0, 0x190E,
    0x0D80, 0x10A3, 0x0869, 0x190F, 0x1910, 0x10A4,
    0x10A5, 0x0753, 0x068D, 0x3EF0, 0x3EF1, 0x190D,
    0x1FC5, 0x3EF2, 0x3EF3, 0x109D, 0x109E, 0x0CAF,
    0x109F, 0x3EF4, 0x10A0, 0x10A7, 0x3EFC, 0x0CB1,
    0x09F7, 0x1911, 0x10A8, 0x09F8, 0x10A9, 0x1912,
    0x06D9, 0x09F9, 0x3EFD, 0x1913, 0x068E, 0x06D8,
    0x3EF5, 0x3EF6, 0x3EF7, 0x3EF8, 0x3EF9, 0x0D81,
    0x3EFA, 0x1FC7, 0x1FC8, 0x10A6, 0x09F6, 0x3EFB,
    0x1FCE, 0x0CB2, 0x3F02, 0x10AA, 0x3F03, 0x1FCF,
    0x10AB, 0x10AC, 0x1916, 0x3F04, 0x09FA, 0x0D83,
    0x3F05, 0x068F, 0x086A, 0x1914, 0x3EFE, 0x1FC9,
    0x1FCA, 0x3EFF, 0x0D82, 0x1FCB, 0x1FCC, 0x3F00,
    0x1FCD, 0x3F01, 0x1915, 0x3F0F, 0x1918, 0x10AD,
    0x0CB3, 0x3F10, 0x1919, 0x3F11, 0x191A, 0x1FD2,
    0x0CB4, 0x0CB5, 0x10AE, 0x191B, 0x047A, 0x06DA,
    0x3F06, 0x3F07, 0x1917, 0x3F08, 0x3F09, 0x3F0A,
    0x3F0B, 0x3F0C, 0x3F0D, 0x3F0E, 0x1FD0, 0x1FD1,
    0x3F18, 0x191F, 0x1FDA, 0x3F19, 0x3F1A, 0x10AF,
    0x3F1B, 0x10B2, 0x1FDB, 0x0D86, 0x0D87, 0x10B3,
    0x0CB6, 0x086B, 0x09FB, 0x3F12, 0x1FD3, 0x1FD4,
    0x3F13, 0x1FD5, 0x191E, 0x1FD6, 0x3F14, 0x3F15,
    0x3F16, 0x1FD7, 0x3F17, 0x033A, 0x01AA, 0x02B8,
    0x01DF, 0x02B9, 0x02BA, 0x086F, 0x03BB, 0x03B2,
    0x046A, 0x066F, 0x08DE, 0x0563, 0x046B, 0x0CB7,
    0x11BE, 0x086E, 0x066E, 0x06DB, 0x047B, 0x03BA,
    0x0A9E, 0x02B7, 0x0340, 0x0264, 0x01CE, 0x01A9,
    0x0265, 0x01A8, 0x0266, 0x02A8, 0x036F, 0x03AB,
    0x037A, 0x04FE, 0x0683, 0x06C4, 0x0C90, 0x065D,
    0x0D3C, 0x0FEC, 0x0436, 0x06C2, 0x0682, 0x0C8E,
    0x055A, 0x033B, 0x065C, 0x0348, 0x03AA, 0x0234,
    0x036E, 0x01F0, 0x01A6, 0x3E86, 0x3E87, 0x153E,
    0x3E88, 0x3E89, 0x0FEF, 0x3E8A, 0x3E8B, 0x3E8C,
    0x3E8D, 0x3E8E, 0x3E8F, 0x3E90, 0x09E4, 0x03AC,
    0x11BF, 0x1F8E, 0x1F8F, 0x0FEE, 0x3E80, 0x3E81,
    0x3E82, 0x3E83, 0x3E84, 0x3E85, 0x1F90, 0x1F91,
    0x3E95, 0x3E96, 0x0C91, 0x3E97, 0x3E98, 0x3E99,
    0x3E9A, 0x3E9B, 0x3E9C, 0x3E9D, 0x3E9E, 0x3E9F,
    0x3EA0, 0x0858, 0x04FF, 0x0FF0, 0x0FF1, 0x153F,
    0x0FF2, 0x3E91, 0x1F92, 0x3E92, 0x1F93, 0x3E93,
    0x1F94, 0x3E94, 0x0D3D, 0x3EA3, 0x1F99, 0x0FF7,
    0x0D3E, 0x3EA4, 0x1F9A, 0x15D9, 0x0D3F, 0x3EA5,
    0x3EA6, 0x3EA7, 0x0D58, 0x3EA8, 0x06C5, 0x072E,
    0x3EA1, 0x1F95, 0x1F96, 0x0C92, 0x0FF3, 0x0FF4,
    0x0FF5, 0x15D8, 0x1F97, 0x0FF6, 0x1F98, 0x3EA2,
    0x3EAC, 0x0FF9, 0x1F9C, 0x15DB, 0x1F9D, 0x15DC,
    0x0FFA, 0x1F9E, 0x3EAD, 0x3EAE, 0x3EAF, 0x3EB0,
    0x3EB1, 0x065E, 0x055B, 0x3EA9, 0x0D59, 0x15DA,
    0x0FF8, 0x3EAA, 0x0D5A, 0x3EAB, 0x0D5B, 0x0D5C,
    0x0D5D, 0x072F, 0x1F9B, 0x3EB4, 0x1FA0, 0x073C,
    0x0D5F, 0x1FA1, 0x1FA2, 0x0FFE, 0x1FA3, 0x1FA4,
    0x3EB5, 0x3EB6, 0x3EB7, 0x3EB8, 0x065F, 0x06C6,
    0x3EB2, 0x15DD, 0x0FFB, 0x3EB3, 0x1F9F, 0x0D5E,
    0x0C93, 0x0C94, 0x0FFC, 0x0FFD, 0x15DE, 0x15DF,
    0x1FA7, 0x15E1, 0x06C7, 0x0D62, 0x15E2, 0x0C96,
    0x15E3, 0x1082, 0x15E4, 0x1FA8, 0x3EBA, 0x3EBB,
    0x3EBC, 0x0660, 0x046E, 0x3EB9, 0x1FA5, 0x0FFF,
    0x1FA6, 0x1080, 0x1081, 0x0D60, 0x0C95, 0x15E0,
    0x0D61, 0x073D, 0x085A, 0x15E6, 0x09E9, 0x085B,
    0x0C97, 0x1083, 0x0C98, 0x0D63, 0x0D64, 0x0C99,
    0x15E7, 0x15E8, 0x1FAC, 0x3EBE, 0x0684, 0x037B,
    0x1FA9, 0x1FAA, 0x3EBD, 0x073E, 0x1FAB, 0x15E5,
    0x06C8, 0x09E5, 0x09E6, 0x09E7, 0x0661, 0x09E8,
    0x1FAE, 0x0C9A, 0x06CA, 0x055C, 0x0C9B, 0x3EC0,
    0x15EB, 0x1085, 0x1086, 0x15EC, 0x1087, 0x3EC1,
    0x3EC2, 0x02A9, 0x02B3, 0x1FAD, 0x15E9, 0x3EBF,
    0x15EA, 0x1084, 0x0D65, 0x0662, 0x0D66, 0x06C9,
    0x0438, 0x054A, 0x073F, 0x085D, 0x0663, 0x0439,
    0x0686, 0x06CB, 0x0C9E, 0x0C9F, 0x1088, 0x15EF,
    0x3EC6, 0x1089, 0x1FAF, 0x3EC7, 0x0349, 0x0267,
    0x3EC3, 0x3EC4, 0x15ED, 0x15EE, 0x3EC5, 0x09EA,
    0x0C9C, 0x0C9D, 0x054B, 0x0685, 0x085C, 0x09EB,
    0x01BC, 0x01DC, 0x01BE, 0x03AD, 0x038A, 0x0749,
    0x0688, 0x0665, 0x074A, 0x0CA1, 0x0D68, 0x3EC8,
    0x1FB1, 0x0236, 0x034A, 0x1FB0, 0x108A, 0x108B,
    0x0CA0, 0x0D67, 0x0687, 0x0748, 0x0664, 0x038B,
    0x023E, 0x01DA, 0x01DB, 0x006E, 0x0094, 0x00E6,
    0x033E, 0x043A, 0x06CD, 0x085E, 0x085F, 0x0D69,
    0x0D6A, 0x1FB3, 0x1FB4, 0x3ECA, 0x034B, 0x023F,
    0x3EC9, 0x108C, 0x1FB2, 0x15F0, 0x15F1, 0x074B,
    0x06CC, 0x074C, 0x038C, 0x0268, 0x0136, 0x0095,
    0x0014, 0x001E, 0x0097, 0x019C, 0x074D, 0x0D6C,
    0x06CE, 0x0CA2, 0x108E, 0x09EC, 0x3ECD, 0x108F,
    0x3ECE, 0x026A, 0x02AA, 0x3ECB, 0x1FB5, 0x15F2,
    0x3ECC, 0x15F3, 0x15F4, 0x0D6B, 0x108D, 0x043B,
    0x0269, 0x0096, 0x0022,
};

static const uint8_t on2avc_cb14_bits[ON2AVC_CB14_CODES] = {
     1,  5,  8, 10, 11, 12,
    14, 13, 12, 13, 14, 14,
    14, 10, 10, 14, 14, 13,
    13, 14, 13, 13, 12, 11,
    10,  8,  5,  5,  6,  8,
    10, 11, 10, 13, 12, 13,
    13, 14, 13, 13,  9,  9,
    14, 13, 13, 12, 14, 14,
    11, 12, 11,  9,  8,  6,
     7,  8,  8, 10, 10, 11,
    11, 12, 11, 12, 13, 14,
    13,  9, 10, 13, 13, 13,
    13, 12, 11, 11, 12, 10,
    10,  8,  8,  9,  9,  9,
    10, 11, 11, 12, 12, 12,
    12, 13, 13, 14, 10,  9,
    14, 14, 14, 14, 13, 13,
    12, 11, 11, 10, 10,  9,
    11, 12, 11, 11, 11, 12,
    12, 12, 12, 11, 13, 14,
    13, 10, 10, 14, 13, 14,
    12, 13, 12, 13, 13, 13,
    11, 11, 11, 14, 12, 11,
    12, 11, 11, 12, 12, 12,
    12, 14, 14, 14, 10, 10,
    14, 13, 14, 12, 12, 12,
    12, 11, 12, 11, 11, 13,
    13, 12, 11, 11, 12, 13,
    11, 11, 11, 12, 12, 13,
    13, 10, 10, 14, 13, 14,
    13, 13, 13, 12, 12, 12,
    13, 11, 12, 13, 13, 11,
    12, 13, 12, 12, 11, 12,
    14, 12, 12, 14, 10, 11,
    14, 13, 13, 13, 14, 13,
    13, 13, 13, 14, 12, 13,
    13, 13, 13, 12, 12, 13,
    12, 13, 12, 13, 13, 13,
    13, 11, 11, 14, 14, 13,
    13, 14, 14, 13, 13, 12,
    13, 14, 13, 13, 14, 12,
    12, 13, 13, 12, 13, 13,
    11, 12, 14, 13, 11, 11,
    14, 14, 14, 14, 14, 12,
    14, 13, 13, 13, 12, 14,
    13, 12, 14, 13, 14, 13,
    13, 13, 13, 14, 12, 12,
    14, 11, 12, 13, 14, 13,
    13, 14, 12, 13, 13, 14,
    13, 14, 13, 14, 13, 13,
    12, 14, 13, 14, 13, 13,
    12, 12, 13, 13, 11, 11,
    14, 14, 13, 14, 14, 14,
    14, 14, 14, 14, 13, 13,
    14, 13, 13, 14, 14, 13,
    14, 13, 13, 12, 12, 13,
    12, 12, 12, 14, 13, 13,
    14, 13, 13, 13, 14, 14,
    14, 13, 14, 10,  9, 10,
     9, 10, 10, 12, 10, 10,
    11, 11, 12, 11, 11, 12,
    13, 12, 11, 11, 11, 10,
    12, 10, 10, 10,  9,  9,
    10,  9, 10, 10, 10, 10,
    10, 11, 11, 11, 12, 11,
    12, 12, 11, 11, 11, 12,
    11, 10, 11, 10, 10, 10,
    10,  9,  9, 14, 14, 13,
    14, 14, 12, 14, 14, 14,
    14, 14, 14, 14, 12, 10,
    13, 13, 13, 12, 14, 14,
    14, 14, 14, 14, 13, 13,
    14, 14, 12, 14, 14, 14,
    14, 14, 14, 14, 14, 14,
    14, 12, 11, 12, 12, 13,
    12, 14, 13, 14, 13, 14,
    13, 14, 12, 14, 13, 12,
    12, 14, 13, 13, 12, 14,
    14, 14, 12, 14, 11, 11,
    14, 13, 13, 12, 12, 12,
    12, 13, 13, 12, 13, 14,
    14, 12, 13, 13, 13, 13,
    12, 13, 14, 14, 14, 14,
    14, 11, 11, 14, 12, 13,
    12, 14, 12, 14, 12, 12,
    12, 11, 13, 14, 13, 11,
    12, 13, 13, 12, 13, 13,
    14, 14, 14, 14, 11, 11,
    14, 13, 12, 14, 13, 12,
    12, 12, 12, 12, 13, 13,
    13, 13, 11, 12, 13, 12,
    13, 13, 13, 13, 14, 14,
    14, 11, 11, 14, 13, 12,
    13, 13, 13, 12, 12, 13,
    12, 11, 12, 13, 12, 12,
    12, 13, 12, 12, 12, 12,
    13, 13, 13, 14, 11, 10,
    13, 13, 14, 11, 13, 13,
    11, 12, 12, 12, 11, 12,
    13, 12, 11, 11, 12, 14,
    13, 13, 13, 13, 13, 14,
    14, 10, 10, 13, 13, 14,
    13, 13, 12, 11, 12, 11,
    11, 11, 11, 12, 11, 11,
    11, 11, 12, 12, 13, 13,
    14, 13, 13, 14, 10, 10,
    14, 14, 13, 13, 14, 12,
    12, 12, 11, 11, 12, 12,
     9,  9,  9, 10, 10, 11,
    11, 11, 11, 12, 12, 14,
    13, 10, 10, 13, 13, 13,
    12, 12, 11, 11, 11, 10,
    10,  9,  9,  7,  8,  8,
    10, 11, 11, 12, 12, 12,
    12, 13, 13, 14, 10, 10,
    14, 13, 13, 13, 13, 11,
    11, 11, 10, 10,  9,  8,
     5,  5,  8,  9, 11, 12,
    11, 12, 13, 12, 14, 13,
    14, 10, 10, 14, 13, 13,
    14, 13, 13, 12, 13, 11,
    10,  8,  6,
};

static const uint16_t on2avc_cb14_syms[ON2AVC_CB14_CODES] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005,
    0x0006, 0x0007, 0x0008, 0x0009, 0x000A, 0x000B,
    0x000C, 0x000D, 0x00F3, 0x00F4, 0x00F5, 0x00F6,
    0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC,
    0x00FD, 0x00FE, 0x00FF, 0x0100, 0x0101, 0x0102,
    0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108,
    0x0109, 0x010A, 0x010B, 0x010C, 0x010D, 0x01F3,
    0x01F4, 0x01F5, 0x01F6, 0x01F7, 0x01F8, 0x01F9,
    0x01FA, 0x01FB, 0x01FC, 0x01FD, 0x01FE, 0x01FF,
    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205,
    0x0206, 0x0207, 0x0208, 0x0209, 0x020A, 0x020B,
    0x020C, 0x020D, 0x02F3, 0x02F4, 0x02F5, 0x02F6,
    0x02F7, 0x02F8, 0x02F9, 0x02FA, 0x02FB, 0x02FC,
    0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302,
    0x0303, 0x0304, 0x0305, 0x0306, 0x0307, 0x0308,
    0x0309, 0x030A, 0x030B, 0x030C, 0x030D, 0x03F3,
    0x03F4, 0x03F5, 0x03F6, 0x03F7, 0x03F8, 0x03F9,
    0x03FA, 0x03FB, 0x03FC, 0x03FD, 0x03FE, 0x03FF,
    0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405,
    0x0406, 0x0407, 0x0408, 0x0409, 0x040A, 0x040B,
    0x040C, 0x040D, 0x04F3, 0x04F4, 0x04F5, 0x04F6,
    0x04F7, 0x04F8, 0x04F9, 0x04FA, 0x04FB, 0x04FC,
    0x04FD, 0x04FE, 0x04FF, 0x0500, 0x0501, 0x0502,
    0x0503, 0x0504, 0x0505, 0x0506, 0x0507, 0x0508,
    0x0509, 0x050A, 0x050B, 0x050C, 0x050D, 0x05F3,
    0x05F4, 0x05F5, 0x05F6, 0x05F7, 0x05F8, 0x05F9,
    0x05FA, 0x05FB, 0x05FC, 0x05FD, 0x05FE, 0x05FF,
    0x0600, 0x0601, 0x0602, 0x0603, 0x0604, 0x0605,
    0x0606, 0x0607, 0x0608, 0x0609, 0x060A, 0x060B,
    0x060C, 0x060D, 0x06F3, 0x06F4, 0x06F5, 0x06F6,
    0x06F7, 0x06F8, 0x06F9, 0x06FA, 0x06FB, 0x06FC,
    0x06FD, 0x06FE, 0x06FF, 0x0700, 0x0701, 0x0702,
    0x0703, 0x0704, 0x0705, 0x0706, 0x0707, 0x0708,
    0x0709, 0x070A, 0x070B, 0x070C, 0x070D, 0x07F3,
    0x07F4, 0x07F5, 0x07F6, 0x07F7, 0x07F8, 0x07F9,
    0x07FA, 0x07FB, 0x07FC, 0x07FD, 0x07FE, 0x07FF,
    0x0800, 0x0801, 0x0802, 0x0803, 0x0804, 0x0805,
    0x0806, 0x0807, 0x0808, 0x0809, 0x080A, 0x080B,
    0x080C, 0x080D, 0x08F3, 0x08F4, 0x08F5, 0x08F6,
    0x08F7, 0x08F8, 0x08F9, 0x08FA, 0x08FB, 0x08FC,
    0x08FD, 0x08FE, 0x08FF, 0x0900, 0x0901, 0x0902,
    0x0903, 0x0904, 0x0905, 0x0906, 0x0907, 0x0908,
    0x0909, 0x090A, 0x090B, 0x090C, 0x090D, 0x09F3,
    0x09F4, 0x09F5, 0x09F6, 0x09F7, 0x09F8, 0x09F9,
    0x09FA, 0x09FB, 0x09FC, 0x09FD, 0x09FE, 0x09FF,
    0x0A00, 0x0A01, 0x0A02, 0x0A03, 0x0A04, 0x0A05,
    0x0A06, 0x0A07, 0x0A08, 0x0A09, 0x0A0A, 0x0A0B,
    0x0A0C, 0x0A0D, 0x0AF3, 0x0AF4, 0x0AF5, 0x0AF6,
    0x0AF7, 0x0AF8, 0x0AF9, 0x0AFA, 0x0AFB, 0x0AFC,
    0x0AFD, 0x0AFE, 0x0AFF, 0x0B00, 0x0B01, 0x0B02,
    0x0B03, 0x0B04, 0x0B05, 0x0B06, 0x0B07, 0x0B08,
    0x0B09, 0x0B0A, 0x0B0B, 0x0B0C, 0x0B0D, 0x0BF3,
    0x0BF4, 0x0BF5, 0x0BF6, 0x0BF7, 0x0BF8, 0x0BF9,
    0x0BFA, 0x0BFB, 0x0BFC, 0x0BFD, 0x0BFE, 0x0BFF,
    0x0C00, 0x0C01, 0x0C02, 0x0C03, 0x0C04, 0x0C05,
    0x0C06, 0x0C07, 0x0C08, 0x0C09, 0x0C0A, 0x0C0B,
    0x0C0C, 0x0C0D, 0x0CF3, 0x0CF4, 0x0CF5, 0x0CF6,
    0x0CF7, 0x0CF8, 0x0CF9, 0x0CFA, 0x0CFB, 0x0CFC,
    0x0CFD, 0x0CFE, 0x0CFF, 0x0D00, 0x0D01, 0x0D02,
    0x0D03, 0x0D04, 0x0D05, 0x0D06, 0x0D07, 0x0D08,
    0x0D09, 0x0D0A, 0x0D0B, 0x0D0C, 0x0D0D, 0x0DF3,
    0x0DF4, 0x0DF5, 0x0DF6, 0x0DF7, 0x0DF8, 0x0DF9,
    0x0DFA, 0x0DFB, 0x0DFC, 0x0DFD, 0x0DFE, 0x0DFF,
    0xF300, 0xF301, 0xF302, 0xF303, 0xF304, 0xF305,
    0xF306, 0xF307, 0xF308, 0xF309, 0xF30A, 0xF30B,
    0xF30C, 0xF30D, 0xF3F3, 0xF3F4, 0xF3F5, 0xF3F6,
    0xF3F7, 0xF3F8, 0xF3F9, 0xF3FA, 0xF3FB, 0xF3FC,
    0xF3FD, 0xF3FE, 0xF3FF, 0xF400, 0xF401, 0xF402,
    0xF403, 0xF404, 0xF405, 0xF406, 0xF407, 0xF408,
    0xF409, 0xF40A, 0xF40B, 0xF40C, 0xF40D, 0xF4F3,
    0xF4F4, 0xF4F5, 0xF4F6, 0xF4F7, 0xF4F8, 0xF4F9,
    0xF4FA, 0xF4FB, 0xF4FC, 0xF4FD, 0xF4FE, 0xF4FF,
    0xF500, 0xF501, 0xF502, 0xF503, 0xF504, 0xF505,
    0xF506, 0xF507, 0xF508, 0xF509, 0xF50A, 0xF50B,
    0xF50C, 0xF50D, 0xF5F3, 0xF5F4, 0xF5F5, 0xF5F6,
    0xF5F7, 0xF5F8, 0xF5F9, 0xF5FA, 0xF5FB, 0xF5FC,
    0xF5FD, 0xF5FE, 0xF5FF, 0xF600, 0xF601, 0xF602,
    0xF603, 0xF604, 0xF605, 0xF606, 0xF607, 0xF608,
    0xF609, 0xF60A, 0xF60B, 0xF60C, 0xF60D, 0xF6F3,
    0xF6F4, 0xF6F5, 0xF6F6, 0xF6F7, 0xF6F8, 0xF6F9,
    0xF6FA, 0xF6FB, 0xF6FC, 0xF6FD, 0xF6FE, 0xF6FF,
    0xF700, 0xF701, 0xF702, 0xF703, 0xF704, 0xF705,
    0xF706, 0xF707, 0xF708, 0xF709, 0xF70A, 0xF70B,
    0xF70C, 0xF70D, 0xF7F3, 0xF7F4, 0xF7F5, 0xF7F6,
    0xF7F7, 0xF7F8, 0xF7F9, 0xF7FA, 0xF7FB, 0xF7FC,
    0xF7FD, 0xF7FE, 0xF7FF, 0xF800, 0xF801, 0xF802,
    0xF803, 0xF804, 0xF805, 0xF806, 0xF807, 0xF808,
    0xF809, 0xF80A, 0xF80B, 0xF80C, 0xF80D, 0xF8F3,
    0xF8F4, 0xF8F5, 0xF8F6, 0xF8F7, 0xF8F8, 0xF8F9,
    0xF8FA, 0xF8FB, 0xF8FC, 0xF8FD, 0xF8FE, 0xF8FF,
    0xF900, 0xF901, 0xF902, 0xF903, 0xF904, 0xF905,
    0xF906, 0xF907, 0xF908, 0xF909, 0xF90A, 0xF90B,
    0xF90C, 0xF90D, 0xF9F3, 0xF9F4, 0xF9F5, 0xF9F6,
    0xF9F7, 0xF9F8, 0xF9F9, 0xF9FA, 0xF9FB, 0xF9FC,
    0xF9FD, 0xF9FE, 0xF9FF, 0xFA00, 0xFA01, 0xFA02,
    0xFA03, 0xFA04, 0xFA05, 0xFA06, 0xFA07, 0xFA08,
    0xFA09, 0xFA0A, 0xFA0B, 0xFA0C, 0xFA0D, 0xFAF3,
    0xFAF4, 0xFAF5, 0xFAF6, 0xFAF7, 0xFAF8, 0xFAF9,
    0xFAFA, 0xFAFB, 0xFAFC, 0xFAFD, 0xFAFE, 0xFAFF,
    0xFB00, 0xFB01, 0xFB02, 0xFB03, 0xFB04, 0xFB05,
    0xFB06, 0xFB07, 0xFB08, 0xFB09, 0xFB0A, 0xFB0B,
    0xFB0C, 0xFB0D, 0xFBF3, 0xFBF4, 0xFBF5, 0xFBF6,
    0xFBF7, 0xFBF8, 0xFBF9, 0xFBFA, 0xFBFB, 0xFBFC,
    0xFBFD, 0xFBFE, 0xFBFF, 0xFC00, 0xFC01, 0xFC02,
    0xFC03, 0xFC04, 0xFC05, 0xFC06, 0xFC07, 0xFC08,
    0xFC09, 0xFC0A, 0xFC0B, 0xFC0C, 0xFC0D, 0xFCF3,
    0xFCF4, 0xFCF5, 0xFCF6, 0xFCF7, 0xFCF8, 0xFCF9,
    0xFCFA, 0xFCFB, 0xFCFC, 0xFCFD, 0xFCFE, 0xFCFF,
    0xFD00, 0xFD01, 0xFD02, 0xFD03, 0xFD04, 0xFD05,
    0xFD06, 0xFD07, 0xFD08, 0xFD09, 0xFD0A, 0xFD0B,
    0xFD0C, 0xFD0D, 0xFDF3, 0xFDF4, 0xFDF5, 0xFDF6,
    0xFDF7, 0xFDF8, 0xFDF9, 0xFDFA, 0xFDFB, 0xFDFC,
    0xFDFD, 0xFDFE, 0xFDFF, 0xFE00, 0xFE01, 0xFE02,
    0xFE03, 0xFE04, 0xFE05, 0xFE06, 0xFE07, 0xFE08,
    0xFE09, 0xFE0A, 0xFE0B, 0xFE0C, 0xFE0D, 0xFEF3,
    0xFEF4, 0xFEF5, 0xFEF6, 0xFEF7, 0xFEF8, 0xFEF9,
    0xFEFA, 0xFEFB, 0xFEFC, 0xFEFD, 0xFEFE, 0xFEFF,
    0xFF00, 0xFF01, 0xFF02, 0xFF03, 0xFF04, 0xFF05,
    0xFF06, 0xFF07, 0xFF08, 0xFF09, 0xFF0A, 0xFF0B,
    0xFF0C, 0xFF0D, 0xFFF3, 0xFFF4, 0xFFF5, 0xFFF6,
    0xFFF7, 0xFFF8, 0xFFF9, 0xFFFA, 0xFFFB, 0xFFFC,
    0xFFFD, 0xFFFE, 0xFFFF,
};

#define ON2AVC_CB15_CODES 1089
static const uint16_t on2avc_cb15_codes[ON2AVC_CB15_CODES] = {
    0x00000, 0x0000A, 0x00064, 0x00104, 0x0034B, 0x0047B,
    0x007D7, 0x00E14, 0x00957, 0x021FD, 0x013B0, 0x03F08,
    0x07A01, 0x0E579, 0x00E15, 0x013A1, 0x003A2, 0x00397,
    0x0137F, 0x01F96, 0x021FC, 0x034CD, 0x01E97, 0x01A82,
    0x013A0, 0x01A83, 0x0089D, 0x00F6B, 0x0076C, 0x0026A,
    0x00118, 0x0006E, 0x00008, 0x0000B, 0x00015, 0x00076,
    0x000EC, 0x001D2, 0x003A6, 0x00716, 0x00726, 0x01F98,
    0x00E77, 0x01BF0, 0x01A84, 0x021FE, 0x021FF, 0x00D93,
    0x01A85, 0x0036E, 0x003B4, 0x00FFE, 0x00FDF, 0x07A02,
    0x065AF, 0x01E98, 0x01F97, 0x00E16, 0x00F30, 0x00CF0,
    0x00846, 0x00398, 0x0020F, 0x000EB, 0x00074, 0x00012,
    0x0007C, 0x00049, 0x0009C, 0x00136, 0x00344, 0x0026D,
    0x0076E, 0x00847, 0x00F6C, 0x00958, 0x01A86, 0x00F6D,
    0x013A3, 0x013B1, 0x009F8, 0x00F31, 0x0032F, 0x00268,
    0x00FE0, 0x0076D, 0x01F99, 0x013A2, 0x03D05, 0x0111A,
    0x00FFF, 0x00CF1, 0x0080D, 0x004FA, 0x0040B, 0x0023E,
    0x0011B, 0x0008E, 0x00077, 0x0010A, 0x000F8, 0x001B0,
    0x001D4, 0x003D9, 0x004C6, 0x006AE, 0x007DE, 0x0080E,
    0x00F33, 0x00E78, 0x01BF1, 0x0111B, 0x034CE, 0x00959,
    0x0111C, 0x00262, 0x001FA, 0x00F32, 0x00FE1, 0x02200,
    0x01F9A, 0x013A4, 0x00E17, 0x00FE2, 0x004B7, 0x00FE3,
    0x00717, 0x00453, 0x00366, 0x001C6, 0x0011A, 0x0010E,
    0x0032B, 0x0023F, 0x00345, 0x0035A, 0x0036F, 0x007B6,
    0x00E19, 0x00705, 0x0076F, 0x0111D, 0x00E79, 0x00D57,
    0x01BF4, 0x01A87, 0x0095B, 0x0095C, 0x00216, 0x0039A,
    0x00F34, 0x0095A, 0x01BF2, 0x01BF3, 0x01000, 0x00F6E,
    0x00F6F, 0x00E18, 0x007DF, 0x008F1, 0x007BE, 0x003BD,
    0x003EB, 0x00342, 0x0022D, 0x00772, 0x007BF, 0x00454,
    0x00455, 0x0071E, 0x004FB, 0x00727, 0x0080F, 0x009E7,
    0x00E7C, 0x01BF6, 0x01A89, 0x01001, 0x01BF7, 0x0089E,
    0x00E1A, 0x0027F, 0x00334, 0x00F35, 0x00F36, 0x01BF5,
    0x01F9B, 0x013A5, 0x00E7A, 0x0095D, 0x00D58, 0x00E7B,
    0x01A88, 0x00FE4, 0x006CE, 0x0040E, 0x00687, 0x006D2,
    0x00E1C, 0x00706, 0x00747, 0x006B6, 0x0084E, 0x00CF2,
    0x006F2, 0x00D59, 0x00CF3, 0x01004, 0x013A6, 0x00F71,
    0x01A8B, 0x01E99, 0x00D5A, 0x00D94, 0x00335, 0x0022E,
    0x0095E, 0x00E1B, 0x01A8A, 0x01BF8, 0x01BF9, 0x01002,
    0x009F9, 0x00F70, 0x01003, 0x00773, 0x00F37, 0x00812,
    0x004D2, 0x004A3, 0x0089F, 0x013A9, 0x013AA, 0x00813,
    0x0081E, 0x00707, 0x008A0, 0x00E1E, 0x00D95, 0x008F2,
    0x009FB, 0x00E7D, 0x00E7E, 0x00F39, 0x01F9C, 0x00CF4,
    0x00F75, 0x00346, 0x0026E, 0x01005, 0x00F72, 0x013A7,
    0x0111E, 0x01BFA, 0x00F73, 0x013A8, 0x00F38, 0x00F74,
    0x009FA, 0x00FE5, 0x0084F, 0x0095F, 0x00E1D, 0x009EA,
    0x01A8D, 0x00E20, 0x00E21, 0x007CE, 0x00D96, 0x01008,
    0x00E22, 0x00960, 0x01121, 0x00E7F, 0x01122, 0x01A8E,
    0x01BFB, 0x01A8F, 0x008A1, 0x01009, 0x0035F, 0x00368,
    0x013B2, 0x01A8C, 0x01F9D, 0x02201, 0x01006, 0x0111F,
    0x013AB, 0x013AC, 0x01120, 0x00F76, 0x01007, 0x009FC,
    0x008F3, 0x00E1F, 0x01E9A, 0x01F9F, 0x013B3, 0x00F3B,
    0x00F77, 0x00F78, 0x00FE7, 0x009FD, 0x00FE8, 0x01123,
    0x00D97, 0x01BFF, 0x00E80, 0x01A93, 0x01124, 0x00D9E,
    0x00D5B, 0x003DA, 0x003A7, 0x00961, 0x01BFC, 0x01F9E,
    0x01BFD, 0x01BFE, 0x01A90, 0x01A91, 0x013AD, 0x00F3A,
    0x01A92, 0x00FE6, 0x00962, 0x0085E, 0x00963, 0x013AE,
    0x03D06, 0x01C01, 0x013B5, 0x00965, 0x01FA2, 0x02202,
    0x009FE, 0x00F79, 0x00F7A, 0x00E23, 0x00E26, 0x00966,
    0x013B1, 0x01E9C, 0x00F7B, 0x008A2, 0x003FE, 0x003AB,
    0x00964, 0x013B4, 0x01C00, 0x01E9B, 0x01FA0, 0x01FA1,
    0x0100A, 0x013AF, 0x03F09, 0x00E81, 0x01A94, 0x01125,
    0x01126, 0x01A95, 0x013B0, 0x03D08, 0x01E9E, 0x01FA3,
    0x013B4, 0x01A99, 0x0100B, 0x013B9, 0x00F3E, 0x00967,
    0x00E27, 0x0100C, 0x01E9F, 0x00968, 0x01C05, 0x00F3F,
    0x00E82, 0x0039B, 0x00386, 0x01A96, 0x01C02, 0x03D07,
    0x013B6, 0x01C03, 0x01E9D, 0x01127, 0x01A97, 0x01C04,
    0x013B2, 0x013B3, 0x013B7, 0x01A98, 0x013B8, 0x03F0A,
    0x0E57A, 0x07A03, 0x013BB, 0x01FA4, 0x01A9C, 0x01FA5,
    0x01FA6, 0x013BC, 0x0100D, 0x01FA7, 0x013B5, 0x0100E,
    0x01A9D, 0x0100F, 0x0096A, 0x01128, 0x00328, 0x003FF,
    0x00969, 0x01EA0, 0x01C06, 0x013BA, 0x01A9A, 0x034CF,
    0x00F7C, 0x02203, 0x034D2, 0x01EA1, 0x01C07, 0x02204,
    0x01A9B, 0x01EA2, 0x06982, 0x03D09, 0x0E57B, 0x01FA8,
    0x013C2, 0x013C3, 0x01129, 0x01FA9, 0x0112A, 0x01010,
    0x01FAA, 0x01EA6, 0x03F0F, 0x013B6, 0x00CF5, 0x0072A,
    0x00F7D, 0x00340, 0x0025F, 0x02205, 0x02206, 0x06983,
    0x01C08, 0x013BD, 0x013BE, 0x01EA3, 0x013BF, 0x034D3,
    0x01EA4, 0x02207, 0x01A9E, 0x01EA5, 0x03F0B, 0x03F0E,
    0x01AA2, 0x00E00, 0x00E3E, 0x00D9F, 0x00D5F, 0x00CF7,
    0x00CFE, 0x01011, 0x00E85, 0x00E01, 0x00E02, 0x0096B,
    0x00CFF, 0x00F92, 0x00D6E, 0x008CA, 0x00359, 0x00456,
    0x01CAE, 0x03D0A, 0x01A9F, 0x0112B, 0x00E83, 0x013B7,
    0x00F7E, 0x009FF, 0x00E84, 0x00FE9, 0x009EB, 0x00F7F,
    0x008A3, 0x00D5E, 0x00CF6, 0x0112E, 0x0112F, 0x01016,
    0x00F93, 0x01FAE, 0x00FEA, 0x00FEB, 0x009A6, 0x00E03,
    0x01C0A, 0x01017, 0x01C0B, 0x01FAF, 0x00F9E, 0x013BB,
    0x0196A, 0x0039C, 0x003F6, 0x0379A, 0x03D0B, 0x01FAB,
    0x01EA7, 0x013B8, 0x01012, 0x01AA3, 0x01C09, 0x013B9,
    0x01013, 0x00CB4, 0x00E86, 0x01F3E, 0x013BA, 0x00E87,
    0x007FB, 0x003CF, 0x0037A, 0x003AD, 0x00387, 0x0038A,
    0x003B5, 0x0039E, 0x0026F, 0x0038B, 0x00272, 0x0039F,
    0x00399, 0x0038E, 0x00252, 0x0039A, 0x00018, 0x0001B,
    0x003CE, 0x00457, 0x003E8, 0x0067E, 0x0041A, 0x003BE,
    0x003BF, 0x003EE, 0x00437, 0x0039D, 0x003AC, 0x00464,
    0x003C6, 0x003C7, 0x0041B, 0x007F6, 0x0042E, 0x0025C,
    0x0038C, 0x003BA, 0x003E9, 0x003EA, 0x00271, 0x003BB,
    0x0026A, 0x0025D, 0x0025E, 0x00389, 0x003EE, 0x004F4,
    0x00415, 0x0001A, 0x00017, 0x00388, 0x0038E, 0x003FC,
    0x00270, 0x00378, 0x0038A, 0x003AE, 0x003AA, 0x00398,
    0x003E8, 0x00358, 0x00414, 0x00384, 0x003B8, 0x006D3,
    0x01A6B, 0x00FEA, 0x01BCE, 0x009E4, 0x00E56, 0x01BCF,
    0x0131D, 0x009E5, 0x01BD8, 0x01BD9, 0x034C0, 0x01F86,
    0x01A6C, 0x01F3F, 0x065AC, 0x072BE, 0x00436, 0x0022C,
    0x009E0, 0x00F54, 0x009E2, 0x01104, 0x01105, 0x00FE8,
    0x009E3, 0x00FE9, 0x00F55, 0x0131C, 0x01A68, 0x01A6A,
    0x00E06, 0x01106, 0x01BCC, 0x00E6E, 0x00E3F, 0x00CB7,
    0x00F28, 0x00702, 0x0094E, 0x00F29, 0x00FEC, 0x00F2A,
    0x0131E, 0x00F56, 0x0131F, 0x00F57, 0x0110A, 0x0134E,
    0x01E86, 0x00712, 0x001F6, 0x0081F, 0x00D6F, 0x00FEB,
    0x01107, 0x00CB6, 0x0094C, 0x01BDA, 0x01108, 0x01109,
    0x009E6, 0x00E6C, 0x01F88, 0x00E6D, 0x00896, 0x0094D,
    0x03F00, 0x01E88, 0x0217C, 0x03F01, 0x03F02, 0x01399,
    0x01E89, 0x0E578, 0x0139A, 0x01E8A, 0x01F8A, 0x01F8B,
    0x01E8B, 0x03D02, 0x01F8C, 0x0139B, 0x00392, 0x0035E,
    0x00F58, 0x009DE, 0x0094F, 0x01358, 0x01359, 0x0135A,
    0x0134F, 0x01BDB, 0x0135B, 0x0379B, 0x01F89, 0x01398,
    0x034C2, 0x065AD, 0x01E87, 0x03F04, 0x07A00, 0x0217D,
    0x01A6D, 0x065AE, 0x01E8C, 0x0217E, 0x01BDD, 0x0135C,
    0x01A6E, 0x034C4, 0x01E8D, 0x03F05, 0x01E8E, 0x0217F,
    0x0139D, 0x003F7, 0x0032C, 0x034C3, 0x00E07, 0x0110B,
    0x009E7, 0x00F59, 0x03D03, 0x00D8A, 0x01F8D, 0x00E6F,
    0x00FED, 0x03F03, 0x00FEE, 0x01BDC, 0x0139C, 0x072BF,
    0x03F06, 0x021F2, 0x01A70, 0x021F3, 0x0135E, 0x0139E,
    0x01F8E, 0x01F8F, 0x0139F, 0x01E91, 0x013A0, 0x0135F,
    0x034C6, 0x0110E, 0x01A71, 0x021F4, 0x0026C, 0x00206,
    0x0110C, 0x009E8, 0x01BDE, 0x00F5A, 0x00FEF, 0x0135D,
    0x00FF0, 0x01E8F, 0x021F0, 0x009E9, 0x01E90, 0x021F1,
    0x01A6F, 0x0110D, 0x034C5, 0x021F5, 0x01A73, 0x01BE2,
    0x01BE3, 0x01F91, 0x01A74, 0x00E70, 0x021F6, 0x034C8,
    0x00FF3, 0x01F92, 0x013A1, 0x013A2, 0x013A3, 0x01A75,
    0x01372, 0x003BC, 0x00341, 0x034C7, 0x00950, 0x00FF1,
    0x00FF2, 0x009EA, 0x00F5B, 0x01370, 0x01BDF, 0x01371,
    0x01A72, 0x01BE0, 0x009EB, 0x01F90, 0x0110F, 0x01BE1,
    0x01E92, 0x013A6, 0x00D8B, 0x00FD8, 0x01BE5, 0x00FF4,
    0x00FF5, 0x01BE6, 0x013A7, 0x00F5F, 0x01BE7, 0x021F7,
    0x021F8, 0x034C9, 0x009EC, 0x013A8, 0x003EF, 0x00269,
    0x00CD8, 0x00FD6, 0x00F5C, 0x013A4, 0x00F5D, 0x00F2B,
    0x00E08, 0x01110, 0x01BE4, 0x00E09, 0x013A5, 0x00F2C,
    0x00898, 0x00F5E, 0x01A76, 0x013A9, 0x00D8C, 0x009DF,
    0x009E0, 0x00FF8, 0x00D8D, 0x01374, 0x01A78, 0x01112,
    0x01BE8, 0x01A79, 0x01F93, 0x01113, 0x01375, 0x00F61,
    0x01376, 0x00399, 0x0027C, 0x009ED, 0x00F60, 0x01373,
    0x01A77, 0x00951, 0x009EE, 0x00D50, 0x00CD9, 0x00FF6,
    0x00FD9, 0x00FF7, 0x00899, 0x007C8, 0x00D52, 0x01111,
    0x009EF, 0x007D3, 0x007D4, 0x0071E, 0x00CDB, 0x00746,
    0x00E0A, 0x00E0B, 0x021F9, 0x00FF9, 0x01A7A, 0x00952,
    0x013AB, 0x01377, 0x009F0, 0x01E93, 0x003AF, 0x0032E,
    0x009E1, 0x007CA, 0x013AA, 0x01114, 0x00F62, 0x00E71,
    0x008CB, 0x008CC, 0x0089A, 0x008CD, 0x00840, 0x00CDA,
    0x007D2, 0x009E2, 0x00E72, 0x00F63, 0x006D6, 0x00841,
    0x0079E, 0x00D53, 0x008CE, 0x00955, 0x00E0C, 0x0137A,
    0x00E74, 0x01115, 0x01F94, 0x01116, 0x01BEA, 0x00E0D,
    0x01A7B, 0x0038D, 0x0033E, 0x00CDC, 0x00D8E, 0x01BE9,
    0x01378, 0x01379, 0x00FDA, 0x00E73, 0x00953, 0x00954,
    0x009E3, 0x004D6, 0x007B7, 0x007BA, 0x007BB, 0x004A0,
    0x0089B, 0x006D7, 0x0047A, 0x00408, 0x007F7, 0x00E0E,
    0x009E4, 0x007D5, 0x00842, 0x00D90, 0x009F1, 0x034CA,
    0x01A7C, 0x01A7D, 0x00E0F, 0x01A7E, 0x00329, 0x0021E,
    0x00F64, 0x01117, 0x021FA, 0x01118, 0x013AC, 0x013AD,
    0x00D8F, 0x008CF, 0x008F0, 0x0071F, 0x004A1, 0x00686,
    0x00426, 0x00416, 0x007CB, 0x003D8, 0x00264, 0x00347,
    0x003DC, 0x004F6, 0x004D7, 0x00F2D, 0x00F65, 0x009F3,
    0x00FDB, 0x00E75, 0x009F4, 0x0137B, 0x013AE, 0x009E5,
    0x00E10, 0x0027E, 0x0020C, 0x00FFA, 0x00956, 0x01BEB,
    0x01E94, 0x01E95, 0x00D91, 0x009F2, 0x00D54, 0x007BC,
    0x007BD, 0x0040A, 0x00385, 0x0036A, 0x0022F, 0x0020E,
    0x000FC, 0x000F2, 0x001AE, 0x001C8, 0x0034A, 0x004F7,
    0x00452, 0x00CDE, 0x00843, 0x00E76, 0x00F2E, 0x00F67,
    0x0137C, 0x01A7F, 0x0080C, 0x00FDC, 0x0021A, 0x001FC,
    0x00E11, 0x009F5, 0x01BEC, 0x00F66, 0x013AF, 0x00CDD,
    0x00E12, 0x00D55, 0x00703, 0x0080A, 0x00394, 0x00265,
    0x001F6, 0x001B6, 0x0010C, 0x00078, 0x0004C, 0x000CC,
    0x001A4, 0x00212, 0x00396, 0x006C4, 0x0089C, 0x00CDF,
    0x01A80, 0x00F68, 0x00FFD, 0x0137D, 0x01F95, 0x00845,
    0x00E13, 0x00267, 0x00266, 0x00FFB, 0x009F6, 0x03D04,
    0x01BED, 0x01BEE, 0x034CB, 0x00FFC, 0x00844, 0x007D6,
    0x00704, 0x003C8, 0x0032A, 0x00130, 0x000CE, 0x00048,
    0x0000C, 0x00014, 0x0007A, 0x000F0, 0x001E6, 0x00417,
    0x004A2, 0x004B6, 0x00D92, 0x01A81, 0x009F7, 0x0137E,
    0x01E96, 0x03F07, 0x009E6, 0x00FDE, 0x003C9, 0x00268,
    0x00F2F, 0x00D56, 0x021FB, 0x034CC, 0x01BEF, 0x00F69,
    0x01119, 0x00F6A, 0x00FDD, 0x007FA, 0x003E6, 0x001E2,
    0x000EA, 0x00072, 0x00016,
};

static const uint8_t on2avc_cb15_bits[ON2AVC_CB15_CODES] = {
     2,  5,  7,  9, 10, 11,
    12, 12, 13, 14, 14, 14,
    16, 17, 12, 13, 11, 11,
    13, 13, 14, 14, 14, 13,
    13, 13, 12, 13, 12, 10,
     9,  7,  5,  5,  5,  7,
     9, 10, 11, 11, 12, 13,
    13, 13, 13, 14, 14, 12,
    13, 10, 11, 13, 12, 16,
    15, 14, 13, 12, 12, 12,
    12, 11, 10,  9,  7,  5,
     7,  8,  8,  9, 10, 11,
    12, 12, 13, 13, 13, 13,
    13, 14, 13, 12, 10, 10,
    12, 12, 13, 13, 15, 13,
    13, 12, 12, 11, 11, 10,
     9,  8,  7,  9,  9,  9,
     9, 10, 11, 11, 12, 12,
    12, 13, 13, 13, 14, 13,
    13, 10, 10, 12, 12, 14,
    13, 13, 12, 12, 12, 12,
    11, 11, 10, 10,  9,  9,
    10, 10, 10, 10, 10, 11,
    12, 12, 12, 13, 13, 12,
    13, 13, 13, 13, 10, 10,
    12, 13, 13, 13, 13, 13,
    13, 12, 12, 12, 11, 11,
    10, 10, 10, 12, 11, 11,
    11, 11, 11, 12, 12, 12,
    13, 13, 13, 13, 13, 12,
    12, 10, 10, 12, 12, 13,
    13, 13, 13, 13, 12, 13,
    13, 12, 11, 11, 11, 11,
    12, 12, 12, 11, 12, 12,
    11, 12, 12, 13, 13, 13,
    13, 14, 12, 12, 10, 10,
    13, 12, 13, 13, 13, 13,
    13, 13, 13, 12, 12, 12,
    12, 12, 12, 13, 13, 12,
    12, 12, 12, 12, 12, 12,
    13, 13, 13, 12, 13, 12,
    13, 10, 11, 13, 13, 13,
    13, 13, 13, 13, 12, 13,
    13, 12, 12, 13, 12, 12,
    13, 12, 12, 12, 12, 13,
    12, 13, 13, 13, 13, 13,
    13, 13, 12, 13, 10, 10,
    14, 13, 13, 14, 13, 13,
    13, 13, 13, 13, 13, 13,
    12, 12, 14, 13, 14, 12,
    13, 13, 12, 13, 12, 13,
    12, 13, 13, 13, 13, 12,
    12, 10, 11, 13, 13, 13,
    13, 13, 13, 13, 13, 12,
    13, 12, 13, 12, 13, 13,
    15, 13, 14, 13, 13, 14,
    13, 13, 13, 12, 12, 13,
    13, 14, 13, 12, 10, 10,
    13, 14, 13, 14, 13, 13,
    13, 13, 14, 13, 13, 13,
    13, 13, 13, 15, 14, 13,
    13, 13, 13, 14, 12, 13,
    12, 13, 14, 13, 13, 12,
    13, 10, 11, 13, 13, 15,
    14, 13, 14, 13, 13, 13,
    13, 13, 14, 13, 14, 14,
    17, 16, 14, 13, 13, 13,
    13, 14, 13, 13, 13, 13,
    13, 13, 13, 13, 10, 10,
    13, 14, 13, 14, 13, 14,
    13, 14, 14, 14, 13, 14,
    13, 14, 15, 15, 17, 13,
    14, 14, 13, 13, 13, 13,
    13, 14, 14, 13, 12, 12,
    13, 10, 11, 14, 14, 15,
    13, 14, 14, 14, 14, 14,
    14, 14, 13, 14, 14, 14,
    13, 13, 12, 12, 12, 12,
    12, 13, 13, 13, 13, 13,
    12, 13, 12, 12, 10, 11,
    14, 15, 13, 13, 13, 13,
    13, 13, 13, 12, 12, 13,
    12, 12, 12, 13, 13, 13,
    13, 13, 12, 12, 13, 13,
    13, 13, 13, 13, 13, 13,
    13, 10, 11, 14, 15, 13,
    14, 13, 13, 13, 13, 13,
    13, 12, 13, 14, 13, 13,
    11, 11, 10, 10, 11, 11,
    11, 10, 11, 11, 11, 10,
    11, 11, 11, 11,  5,  6,
    11, 11, 11, 11, 11, 11,
    11, 10, 11, 10, 10, 11,
    11, 11, 11, 11, 11, 11,
    10, 11, 10, 10, 11, 11,
    11, 11, 11, 11, 11, 11,
    11,  6,  5, 11, 10, 10,
    11, 10, 10, 10, 10, 10,
    10, 10, 11, 11, 11, 11,
    13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 14, 13,
    13, 14, 15, 16, 11, 10,
    13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13,
    12, 13, 13, 13, 12, 12,
    12, 12, 13, 12, 13, 12,
    13, 13, 13, 13, 13, 14,
    14, 11, 10, 12, 12, 13,
    13, 12, 13, 13, 13, 13,
    13, 13, 13, 13, 12, 13,
    14, 14, 14, 14, 14, 14,
    14, 17, 14, 14, 13, 13,
    14, 15, 13, 14, 11, 10,
    13, 12, 13, 13, 13, 13,
    14, 13, 13, 14, 13, 14,
    14, 15, 14, 14, 16, 14,
    13, 15, 14, 14, 13, 13,
    13, 14, 14, 14, 14, 14,
    14, 11, 10, 14, 12, 13,
    13, 13, 15, 12, 13, 13,
    13, 14, 13, 13, 14, 16,
    14, 14, 13, 14, 13, 14,
    13, 13, 14, 14, 14, 13,
    14, 13, 13, 14, 11, 10,
    13, 13, 13, 13, 13, 13,
    13, 14, 14, 13, 14, 14,
    13, 13, 14, 14, 13, 13,
    13, 13, 13, 13, 14, 14,
    13, 13, 14, 14, 14, 13,
    13, 11, 10, 14, 13, 13,
    13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13,
    14, 14, 12, 12, 13, 13,
    13, 13, 14, 13, 13, 14,
    14, 14, 13, 14, 10, 10,
    12, 12, 13, 14, 13, 12,
    12, 13, 13, 12, 14, 12,
    12, 13, 13, 14, 12, 12,
    12, 13, 12, 13, 13, 13,
    13, 13, 13, 13, 13, 13,
    13, 10, 10, 13, 13, 13,
    13, 13, 13, 12, 12, 13,
    12, 13, 12, 12, 12, 13,
    13, 12, 12, 12, 12, 12,
    12, 12, 14, 13, 13, 13,
    14, 13, 13, 14, 10, 10,
    12, 12, 14, 13, 13, 13,
    12, 12, 12, 12, 12, 12,
    12, 12, 13, 13, 11, 12,
    11, 12, 12, 13, 12, 13,
    13, 13, 13, 13, 13, 12,
    13, 10, 10, 12, 12, 13,
    13, 13, 12, 13, 13, 13,
    12, 12, 11, 11, 11, 12,
    12, 11, 11, 11, 11, 12,
    12, 12, 12, 12, 13, 14,
    13, 13, 12, 13, 10, 10,
    13, 13, 14, 13, 14, 14,
    12, 12, 12, 12, 12, 11,
    11, 11, 12, 10, 10, 10,
    10, 11, 12, 12, 13, 13,
    12, 13, 13, 13, 14, 12,
    12, 10, 10, 13, 13, 13,
    14, 14, 12, 13, 12, 11,
    11, 11, 11, 10, 10, 10,
     9,  9,  9, 10, 10, 11,
    11, 12, 12, 13, 12, 13,
    13, 13, 12, 12, 10, 10,
    12, 13, 13, 13, 14, 12,
    12, 12, 12, 12, 11, 10,
     9,  9,  9,  7,  8,  8,
     9, 10, 11, 11, 12, 12,
    13, 13, 13, 13, 13, 12,
    12, 10, 10, 13, 13, 15,
    13, 13, 14, 13, 12, 12,
    12, 10, 10,  9,  8,  8,
     5,  5,  7,  9, 10, 11,
    12, 12, 12, 13, 13, 13,
    14, 14, 12, 12, 10, 11,
    12, 12, 14, 14, 13, 13,
    13, 13, 12, 11, 11, 10,
     9,  7,  5,
};

static const uint16_t on2avc_cb15_syms[ON2AVC_CB15_CODES] = {
    0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005,
    0x0006, 0x0007, 0x0008, 0x0009, 0x000A, 0x000B,
    0x000C, 0x000D, 0x000E, 0x000F, 0x0010, 0x00F0,
    0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6,
    0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC,
    0x00FD, 0x00FE, 0x00FF, 0x0100, 0x0101, 0x0102,
    0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108,
    0x0109, 0x010A, 0x010B, 0x010C, 0x010D, 0x010E,
    0x010F, 0x0110, 0x01F0, 0x01F1, 0x01F2, 0x01F3,
    0x01F4, 0x01F5, 0x01F6, 0x01F7, 0x01F8, 0x01F9,
    0x01FA, 0x01FB, 0x01FC, 0x01FD, 0x01FE, 0x01FF,
    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205,
    0x0206, 0x0207, 0x0208, 0x0209, 0x020A, 0x020B,
    0x020C, 0x020D, 0x020E, 0x020F, 0x0210, 0x02F0,
    0x02F1, 0x02F2, 0x02F3, 0x02F4, 0x02F5, 0x02F6,
    0x02F7, 0x02F8, 0x02F9, 0x02FA, 0x02FB, 0x02FC,
    0x02FD, 0x02FE, 0x02FF, 0x0300, 0x0301, 0x0302,
    0x0303, 0x0304, 0x0305, 0x0306, 0x0307, 0x0308,
    0x0309, 0x030A, 0x030B, 0x030C, 0x030D, 0x030E,
    0x030F, 0x0310, 0x03F0, 0x03F1, 0x03F2, 0x03F3,
    0x03F4, 0x03F5, 0x03F6, 0x03F7, 0x03F8, 0x03F9,
    0x03FA, 0x03FB, 0x03FC, 0x03FD, 0x03FE, 0x03FF,
    0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405,
    0x0406, 0x0407, 0x0408, 0x0409, 0x040A, 0x040B,
    0x040C, 0x040D, 0x040E, 0x040F, 0x0410, 0x04F0,
    0x04F1, 0x04F2, 0x04F3, 0x04F4, 0x04F5, 0x04F6,
    0x04F7, 0x04F8, 0x04F9, 0x04FA, 0x04FB, 0x04FC,
    0x04FD, 0x04FE, 0x04FF, 0x0500, 0x0501, 0x0502,
    0x0503, 0x0504, 0x0505, 0x0506, 0x0507, 0x0508,
    0x0509, 0x050A, 0x050B, 0x050C, 0x050D, 0x050E,
    0x050F, 0x0510, 0x05F0, 0x05F1, 0x05F2, 0x05F3,
    0x05F4, 0x05F5, 0x05F6, 0x05F7, 0x05F8, 0x05F9,
    0x05FA, 0x05FB, 0x05FC, 0x05FD, 0x05FE, 0x05FF,
    0x0600, 0x0601, 0x0602, 0x0603, 0x0604, 0x0605,
    0x0606, 0x0607, 0x0608, 0x0609, 0x060A, 0x060B,
    0x060C, 0x060D, 0x060E, 0x060F, 0x0610, 0x06F0,
    0x06F1, 0x06F2, 0x06F3, 0x06F4, 0x06F5, 0x06F6,
    0x06F7, 0x06F8, 0x06F9, 0x06FA, 0x06FB, 0x06FC,
    0x06FD, 0x06FE, 0x06FF, 0x0700, 0x0701, 0x0702,
    0x0703, 0x0704, 0x0705, 0x0706, 0x0707, 0x0708,
    0x0709, 0x070A, 0x070B, 0x070C, 0x070D, 0x070E,
    0x070F, 0x0710, 0x07F0, 0x07F1, 0x07F2, 0x07F3,
    0x07F4, 0x07F5, 0x07F6, 0x07F7, 0x07F8, 0x07F9,
    0x07FA, 0x07FB, 0x07FC, 0x07FD, 0x07FE, 0x07FF,
    0x0800, 0x0801, 0x0802, 0x0803, 0x0804, 0x0805,
    0x0806, 0x0807, 0x0808, 0x0809, 0x080A, 0x080B,
    0x080C, 0x080D, 0x080E, 0x080F, 0x0810, 0x08F0,
    0x08F1, 0x08F2, 0x08F3, 0x08F4, 0x08F5, 0x08F6,
    0x08F7, 0x08F8, 0x08F9, 0x08FA, 0x08FB, 0x08FC,
    0x08FD, 0x08FE, 0x08FF, 0x0900, 0x0901, 0x0902,
    0x0903, 0x0904, 0x0905, 0x0906, 0x0907, 0x0908,
    0x0909, 0x090A, 0x090B, 0x090C, 0x090D, 0x090E,
    0x090F, 0x0910, 0x09F0, 0x09F1, 0x09F2, 0x09F3,
    0x09F4, 0x09F5, 0x09F6, 0x09F7, 0x09F8, 0x09F9,
    0x09FA, 0x09FB, 0x09FC, 0x09FD, 0x09FE, 0x09FF,
    0x0A00, 0x0A01, 0x0A02, 0x0A03, 0x0A04, 0x0A05,
    0x0A06, 0x0A07, 0x0A08, 0x0A09, 0x0A0A, 0x0A0B,
    0x0A0C, 0x0A0D, 0x0A0E, 0x0A0F, 0x0A10, 0x0AF0,
    0x0AF1, 0x0AF2, 0x0AF3, 0x0AF4, 0x0AF5, 0x0AF6,
    0x0AF7, 0x0AF8, 0x0AF9, 0x0AFA, 0x0AFB, 0x0AFC,
    0x0AFD, 0x0AFE, 0x0AFF, 0x0B00, 0x0B01, 0x0B02,
    0x0B03, 0x0B04, 0x0B05, 0x0B06, 0x0B07, 0x0B08,
    0x0B09, 0x0B0A, 0x0B0B, 0x0B0C, 0x0B0D, 0x0B0E,
    0x0B0F, 0x0B10, 0x0BF0, 0x0BF1, 0x0BF2, 0x0BF3,
    0x0BF4, 0x0BF5, 0x0BF6, 0x0BF7, 0x0BF8, 0x0BF9,
    0x0BFA, 0x0BFB, 0x0BFC, 0x0BFD, 0x0BFE, 0x0BFF,
    0x0C00, 0x0C01, 0x0C02, 0x0C03, 0x0C04, 0x0C05,
    0x0C06, 0x0C07, 0x0C08, 0x0C09, 0x0C0A, 0x0C0B,
    0x0C0C, 0x0C0D, 0x0C0E, 0x0C0F, 0x0C10, 0x0CF0,
    0x0CF1, 0x0CF2, 0x0CF3, 0x0CF4, 0x0CF5, 0x0CF6,
    0x0CF7, 0x0CF8, 0x0CF9, 0x0CFA, 0x0CFB, 0x0CFC,
    0x0CFD, 0x0CFE, 0x0CFF, 0x0D00, 0x0D01, 0x0D02,
    0x0D03, 0x0D04, 0x0D05, 0x0D06, 0x0D07, 0x0D08,
    0x0D09, 0x0D0A, 0x0D0B, 0x0D0C, 0x0D0D, 0x0D0E,
    0x0D0F, 0x0D10, 0x0DF0, 0x0DF1, 0x0DF2, 0x0DF3,
    0x0DF4, 0x0DF5, 0x0DF6, 0x0DF7, 0x0DF8, 0x0DF9,
    0x0DFA, 0x0DFB, 0x0DFC, 0x0DFD, 0x0DFE, 0x0DFF,
    0x0E00, 0x0E01, 0x0E02, 0x0E03, 0x0E04, 0x0E05,
    0x0E06, 0x0E07, 0x0E08, 0x0E09, 0x0E0A, 0x0E0B,
    0x0E0C, 0x0E0D, 0x0E0E, 0x0E0F, 0x0E10, 0x0EF0,
    0x0EF1, 0x0EF2, 0x0EF3, 0x0EF4, 0x0EF5, 0x0EF6,
    0x0EF7, 0x0EF8, 0x0EF9, 0x0EFA, 0x0EFB, 0x0EFC,
    0x0EFD, 0x0EFE, 0x0EFF, 0x0F00, 0x0F01, 0x0F02,
    0x0F03, 0x0F04, 0x0F05, 0x0F06, 0x0F07, 0x0F08,
    0x0F09, 0x0F0A, 0x0F0B, 0x0F0C, 0x0F0D, 0x0F0E,
    0x0F0F, 0x0F10, 0x0FF0, 0x0FF1, 0x0FF2, 0x0FF3,
    0x0FF4, 0x0FF5, 0x0FF6, 0x0FF7, 0x0FF8, 0x0FF9,
    0x0FFA, 0x0FFB, 0x0FFC, 0x0FFD, 0x0FFE, 0x0FFF,
    0x1000, 0x1001, 0x1002, 0x1003, 0x1004, 0x1005,
    0x1006, 0x1007, 0x1008, 0x1009, 0x100A, 0x100B,
    0x100C, 0x100D, 0x100E, 0x100F, 0x1010, 0x10F0,
    0x10F1, 0x10F2, 0x10F3, 0x10F4, 0x10F5, 0x10F6,
    0x10F7, 0x10F8, 0x10F9, 0x10FA, 0x10FB, 0x10FC,
    0x10FD, 0x10FE, 0x10FF, 0xF000, 0xF001, 0xF002,
    0xF003, 0xF004, 0xF005, 0xF006, 0xF007, 0xF008,
    0xF009, 0xF00A, 0xF00B, 0xF00C, 0xF00D, 0xF00E,
    0xF00F, 0xF010, 0xF0F0, 0xF0F1, 0xF0F2, 0xF0F3,
    0xF0F4, 0xF0F5, 0xF0F6, 0xF0F7, 0xF0F8, 0xF0F9,
    0xF0FA, 0xF0FB, 0xF0FC, 0xF0FD, 0xF0FE, 0xF0FF,
    0xF100, 0xF101, 0xF102, 0xF103, 0xF104, 0xF105,
    0xF106, 0xF107, 0xF108, 0xF109, 0xF10A, 0xF10B,
    0xF10C, 0xF10D, 0xF10E, 0xF10F, 0xF110, 0xF1F0,
    0xF1F1, 0xF1F2, 0xF1F3, 0xF1F4, 0xF1F5, 0xF1F6,
    0xF1F7, 0xF1F8, 0xF1F9, 0xF1FA, 0xF1FB, 0xF1FC,
    0xF1FD, 0xF1FE, 0xF1FF, 0xF200, 0xF201, 0xF202,
    0xF203, 0xF204, 0xF205, 0xF206, 0xF207, 0xF208,
    0xF209, 0xF20A, 0xF20B, 0xF20C, 0xF20D, 0xF20E,
    0xF20F, 0xF210, 0xF2F0, 0xF2F1, 0xF2F2, 0xF2F3,
    0xF2F4, 0xF2F5, 0xF2F6, 0xF2F7, 0xF2F8, 0xF2F9,
    0xF2FA, 0xF2FB, 0xF2FC, 0xF2FD, 0xF2FE, 0xF2FF,
    0xF300, 0xF301, 0xF302, 0xF303, 0xF304, 0xF305,
    0xF306, 0xF307, 0xF308, 0xF309, 0xF30A, 0xF30B,
    0xF30C, 0xF30D, 0xF30E, 0xF30F, 0xF310, 0xF3F0,
    0xF3F1, 0xF3F2, 0xF3F3, 0xF3F4, 0xF3F5, 0xF3F6,
    0xF3F7, 0xF3F8, 0xF3F9, 0xF3FA, 0xF3FB, 0xF3FC,
    0xF3FD, 0xF3FE, 0xF3FF, 0xF400, 0xF401, 0xF402,
    0xF403, 0xF404, 0xF405, 0xF406, 0xF407, 0xF408,
    0xF409, 0xF40A, 0xF40B, 0xF40C, 0xF40D, 0xF40E,
    0xF40F, 0xF410, 0xF4F0, 0xF4F1, 0xF4F2, 0xF4F3,
    0xF4F4, 0xF4F5, 0xF4F6, 0xF4F7, 0xF4F8, 0xF4F9,
    0xF4FA, 0xF4FB, 0xF4FC, 0xF4FD, 0xF4FE, 0xF4FF,
    0xF500, 0xF501, 0xF502, 0xF503, 0xF504, 0xF505,
    0xF506, 0xF507, 0xF508, 0xF509, 0xF50A, 0xF50B,
    0xF50C, 0xF50D, 0xF50E, 0xF50F, 0xF510, 0xF5F0,
    0xF5F1, 0xF5F2, 0xF5F3, 0xF5F4, 0xF5F5, 0xF5F6,
    0xF5F7, 0xF5F8, 0xF5F9, 0xF5FA, 0xF5FB, 0xF5FC,
    0xF5FD, 0xF5FE, 0xF5FF, 0xF600, 0xF601, 0xF602,
    0xF603, 0xF604, 0xF605, 0xF606, 0xF607, 0xF608,
    0xF609, 0xF60A, 0xF60B, 0xF60C, 0xF60D, 0xF60E,
    0xF60F, 0xF610, 0xF6F0, 0xF6F1, 0xF6F2, 0xF6F3,
    0xF6F4, 0xF6F5, 0xF6F6, 0xF6F7, 0xF6F8, 0xF6F9,
    0xF6FA, 0xF6FB, 0xF6FC, 0xF6FD, 0xF6FE, 0xF6FF,
    0xF700, 0xF701, 0xF702, 0xF703, 0xF704, 0xF705,
    0xF706, 0xF707, 0xF708, 0xF709, 0xF70A, 0xF70B,
    0xF70C, 0xF70D, 0xF70E, 0xF70F, 0xF710, 0xF7F0,
    0xF7F1, 0xF7F2, 0xF7F3, 0xF7F4, 0xF7F5, 0xF7F6,
    0xF7F7, 0xF7F8, 0xF7F9, 0xF7FA, 0xF7FB, 0xF7FC,
    0xF7FD, 0xF7FE, 0xF7FF, 0xF800, 0xF801, 0xF802,
    0xF803, 0xF804, 0xF805, 0xF806, 0xF807, 0xF808,
    0xF809, 0xF80A, 0xF80B, 0xF80C, 0xF80D, 0xF80E,
    0xF80F, 0xF810, 0xF8F0, 0xF8F1, 0xF8F2, 0xF8F3,
    0xF8F4, 0xF8F5, 0xF8F6, 0xF8F7, 0xF8F8, 0xF8F9,
    0xF8FA, 0xF8FB, 0xF8FC, 0xF8FD, 0xF8FE, 0xF8FF,
    0xF900, 0xF901, 0xF902, 0xF903, 0xF904, 0xF905,
    0xF906, 0xF907, 0xF908, 0xF909, 0xF90A, 0xF90B,
    0xF90C, 0xF90D, 0xF90E, 0xF90F, 0xF910, 0xF9F0,
    0xF9F1, 0xF9F2, 0xF9F3, 0xF9F4, 0xF9F5, 0xF9F6,
    0xF9F7, 0xF9F8, 0xF9F9, 0xF9FA, 0xF9FB, 0xF9FC,
    0xF9FD, 0xF9FE, 0xF9FF, 0xFA00, 0xFA01, 0xFA02,
    0xFA03, 0xFA04, 0xFA05, 0xFA06, 0xFA07, 0xFA08,
    0xFA09, 0xFA0A, 0xFA0B, 0xFA0C, 0xFA0D, 0xFA0E,
    0xFA0F, 0xFA10, 0xFAF0, 0xFAF1, 0xFAF2, 0xFAF3,
    0xFAF4, 0xFAF5, 0xFAF6, 0xFAF7, 0xFAF8, 0xFAF9,
    0xFAFA, 0xFAFB, 0xFAFC, 0xFAFD, 0xFAFE, 0xFAFF,
    0xFB00, 0xFB01, 0xFB02, 0xFB03, 0xFB04, 0xFB05,
    0xFB06, 0xFB07, 0xFB08, 0xFB09, 0xFB0A, 0xFB0B,
    0xFB0C, 0xFB0D, 0xFB0E, 0xFB0F, 0xFB10, 0xFBF0,
    0xFBF1, 0xFBF2, 0xFBF3, 0xFBF4, 0xFBF5, 0xFBF6,
    0xFBF7, 0xFBF8, 0xFBF9, 0xFBFA, 0xFBFB, 0xFBFC,
    0xFBFD, 0xFBFE, 0xFBFF, 0xFC00, 0xFC01, 0xFC02,
    0xFC03, 0xFC04, 0xFC05, 0xFC06, 0xFC07, 0xFC08,
    0xFC09, 0xFC0A, 0xFC0B, 0xFC0C, 0xFC0D, 0xFC0E,
    0xFC0F, 0xFC10, 0xFCF0, 0xFCF1, 0xFCF2, 0xFCF3,
    0xFCF4, 0xFCF5, 0xFCF6, 0xFCF7, 0xFCF8, 0xFCF9,
    0xFCFA, 0xFCFB, 0xFCFC, 0xFCFD, 0xFCFE, 0xFCFF,
    0xFD00, 0xFD01, 0xFD02, 0xFD03, 0xFD04, 0xFD05,
    0xFD06, 0xFD07, 0xFD08, 0xFD09, 0xFD0A, 0xFD0B,
    0xFD0C, 0xFD0D, 0xFD0E, 0xFD0F, 0xFD10, 0xFDF0,
    0xFDF1, 0xFDF2, 0xFDF3, 0xFDF4, 0xFDF5, 0xFDF6,
    0xFDF7, 0xFDF8, 0xFDF9, 0xFDFA, 0xFDFB, 0xFDFC,
    0xFDFD, 0xFDFE, 0xFDFF, 0xFE00, 0xFE01, 0xFE02,
    0xFE03, 0xFE04, 0xFE05, 0xFE06, 0xFE07, 0xFE08,
    0xFE09, 0xFE0A, 0xFE0B, 0xFE0C, 0xFE0D, 0xFE0E,
    0xFE0F, 0xFE10, 0xFEF0, 0xFEF1, 0xFEF2, 0xFEF3,
    0xFEF4, 0xFEF5, 0xFEF6, 0xFEF7, 0xFEF8, 0xFEF9,
    0xFEFA, 0xFEFB, 0xFEFC, 0xFEFD, 0xFEFE, 0xFEFF,
    0xFF00, 0xFF01, 0xFF02, 0xFF03, 0xFF04, 0xFF05,
    0xFF06, 0xFF07, 0xFF08, 0xFF09, 0xFF0A, 0xFF0B,
    0xFF0C, 0xFF0D, 0xFF0E, 0xFF0F, 0xFF10, 0xFFF0,
    0xFFF1, 0xFFF2, 0xFFF3, 0xFFF4, 0xFFF5, 0xFFF6,
    0xFFF7, 0xFFF8, 0xFFF9, 0xFFFA, 0xFFFB, 0xFFFC,
    0xFFFD, 0xFFFE, 0xFFFF,
};

const uint32_t * const ff_on2avc_quad_cb_codes[] = {
    on2avc_cb1_codes, on2avc_cb2_codes, on2avc_cb3_codes, on2avc_cb4_codes,
    on2avc_cb5_codes, on2avc_cb6_codes, on2avc_cb7_codes, on2avc_cb8_codes
};

const uint8_t * const ff_on2avc_quad_cb_bits[] = {
    on2avc_cb1_bits, on2avc_cb2_bits, on2avc_cb3_bits, on2avc_cb4_bits,
    on2avc_cb5_bits, on2avc_cb6_bits, on2avc_cb7_bits, on2avc_cb8_bits
};

const uint16_t * const ff_on2avc_quad_cb_syms[] = {
    on2avc_cb1_syms, on2avc_cb2_syms, on2avc_cb3_syms, on2avc_cb4_syms,
    on2avc_cb5_syms, on2avc_cb6_syms, on2avc_cb7_syms, on2avc_cb8_syms
};

const int ff_on2avc_quad_cb_elems[] = {
    ON2AVC_CB1_CODES, ON2AVC_CB2_CODES, ON2AVC_CB3_CODES, ON2AVC_CB4_CODES,
    ON2AVC_CB5_CODES, ON2AVC_CB6_CODES, ON2AVC_CB7_CODES, ON2AVC_CB8_CODES,
};

const uint16_t * const ff_on2avc_pair_cb_codes[] = {
    on2avc_cb9_codes,  on2avc_cb10_codes, on2avc_cb11_codes, on2avc_cb12_codes,
    on2avc_cb13_codes, on2avc_cb14_codes, on2avc_cb15_codes
};

const uint8_t * const ff_on2avc_pair_cb_bits[] = {
    on2avc_cb9_bits,  on2avc_cb10_bits, on2avc_cb11_bits, on2avc_cb12_bits,
    on2avc_cb13_bits, on2avc_cb14_bits, on2avc_cb15_bits
};

const uint16_t * const ff_on2avc_pair_cb_syms[] = {
    on2avc_cb9_syms,  on2avc_cb10_syms, on2avc_cb11_syms, on2avc_cb12_syms,
    on2avc_cb13_syms, on2avc_cb14_syms, on2avc_cb15_syms
};

const int ff_on2avc_pair_cb_elems[] = {
    ON2AVC_CB9_CODES,  ON2AVC_CB10_CODES, ON2AVC_CB11_CODES, ON2AVC_CB12_CODES,
    ON2AVC_CB13_CODES, ON2AVC_CB14_CODES, ON2AVC_CB15_CODES,
};

const float ff_on2avc_window_long_32000[1024] = {
    0.0007669903, 0.0023009691, 0.0038349426, 0.005368907,
    0.0069028586, 0.0084367944, 0.0099707097, 0.011504602,
    0.013038467,  0.014572302,  0.016106103,  0.017639864,
    0.019173585,  0.020707261,  0.022240886,  0.023774462,
    0.025307981,  0.026841439,  0.028374836,  0.029908165,
    0.031441424,  0.032974608,  0.034507714,  0.036040742,
    0.037573684,  0.039106537,  0.040639296,  0.042171963,
    0.043704528,  0.04523699,   0.046769347,  0.048301592,
    0.049833726,  0.051365741,  0.052897636,  0.054429408,
    0.05596105,   0.057492562,  0.059023935,  0.060555171,
    0.062086266,  0.063617215,  0.065148011,  0.066678658,
    0.068209141,  0.069739468,  0.071269631,  0.07279963,
    0.074329451,  0.0758591,    0.077388577,  0.078917861,
    0.080446966,  0.081975877,  0.083504602,  0.085033126,
    0.086561449,  0.08808957,   0.089617483,  0.091145188,
    0.092672676,  0.094199941,  0.095726989,  0.097253814,
    0.098780409,  0.10030677,   0.1018329,    0.10335878,
    0.10488442,   0.10640982,   0.10793497,   0.10945986,
    0.11098449,   0.11250886,   0.11403297,   0.11555681,
    0.11708038,   0.11860367,   0.12012669,   0.12164942,
    0.12317186,   0.12469402,   0.12621588,   0.12773743,
    0.12925871,   0.13077965,   0.13230032,   0.13382065,
    0.13534068,   0.13686039,   0.13837977,   0.13989884,
    0.14141756,   0.14293596,   0.14445402,   0.14597175,
    0.14748912,   0.14900614,   0.15052283,   0.15203916,
    0.15355512,   0.15507074,   0.15658598,   0.15810084,
    0.15961535,   0.16112947,   0.16264322,   0.16415659,
    0.16566956,   0.16718215,   0.16869435,   0.17020614,
    0.17171754,   0.17322853,   0.17473911,   0.1762493,
    0.17775905,   0.17926839,   0.18077731,   0.1822858,
    0.18379387,   0.1853015,    0.18680871,   0.18831545,
    0.18982176,   0.19132763,   0.19283305,   0.19433801,
    0.19584252,   0.19734655,   0.19885014,   0.20035326,
    0.2018559,    0.20335805,   0.20485975,   0.20636097,
    0.20786168,   0.20936191,   0.21086164,   0.21236089,
    0.21385963,   0.21535787,   0.2168556,    0.21835282,
    0.21984953,   0.22134572,   0.2228414,    0.22433653,
    0.22583115,   0.22732525,   0.22881879,   0.2303118,
    0.23180428,   0.2332962,    0.23478758,   0.2362784,
    0.23776866,   0.23925838,   0.24074753,   0.24223609,
    0.24372411,   0.24521156,   0.24669841,   0.2481847,
    0.24967039,   0.2511555,    0.25264001,   0.25412393,
    0.25560725,   0.25708997,   0.25857207,   0.2600536,
    0.26153448,   0.26301476,   0.26449442,   0.26597348,
    0.26745188,   0.26892966,   0.27040681,   0.27188334,
    0.27335921,   0.27483445,   0.27630904,   0.27778298,
    0.27925625,   0.28072888,   0.28220084,   0.28367215,
    0.28514278,   0.28661272,   0.28808203,   0.28955063,
    0.29101855,   0.2924858,    0.29395235,   0.29541823,
    0.2968834,    0.29834786,   0.29981163,   0.30127469,
    0.30273703,   0.30419868,   0.30565959,   0.30711982,
    0.3085793,    0.31003806,   0.31149608,   0.31295338,
    0.31440994,   0.31586576,   0.31732082,   0.31877515,
    0.32022873,   0.32168156,   0.32313362,   0.32458493,
    0.32603547,   0.32748523,   0.32893425,   0.33038247,
    0.33182994,   0.3332766,    0.33472249,   0.3361676,
    0.33761191,   0.33905542,   0.34049815,   0.34194005,
    0.34338117,   0.34482148,   0.34626096,   0.34769964,
    0.34913751,   0.35057455,   0.35201076,   0.35344613,
    0.35488069,   0.35631442,   0.35774729,   0.35917932,
    0.36061054,   0.36204088,   0.36347035,   0.36489901,
    0.36632678,   0.36775371,   0.36917976,   0.37060493,
    0.37202924,   0.37345266,   0.37487522,   0.37629691,
    0.3777177,    0.37913758,   0.38055661,   0.3819747,
    0.38339192,   0.38480824,   0.38622364,   0.38763815,
    0.38905171,   0.3904644,    0.39187613,   0.39328697,
    0.39469689,   0.39610586,   0.3975139,    0.39892101,
    0.40032718,   0.40173239,   0.40313667,   0.40454,
    0.40594238,   0.4073438,    0.40874428,   0.41014379,
    0.41154233,   0.41293988,   0.4143365,    0.41573212,
    0.41712677,   0.41852042,   0.41991311,   0.42130479,
    0.42269549,   0.4240852,    0.4254739,    0.42686161,
    0.42824832,   0.429634,     0.43101871,   0.43240237,
    0.43378502,   0.43516666,   0.43654725,   0.43792683,
    0.43930539,   0.44068289,   0.44205937,   0.44343483,
    0.4448092,    0.44618255,   0.44755486,   0.44892609,
    0.45029628,   0.45166543,   0.45303348,   0.45440048,
    0.45576641,   0.45713127,   0.45849505,   0.45985776,
    0.4612194,    0.46257991,   0.46393937,   0.46529773,
    0.46665499,   0.46801114,   0.46936622,   0.47072017,
    0.47207302,   0.47342476,   0.4747754,    0.47612491,
    0.47747329,   0.47882056,   0.4801667,    0.48151168,
    0.48285556,   0.4841983,    0.48553991,   0.48688036,
    0.48821968,   0.48955783,   0.49089485,   0.49223071,
    0.49356541,   0.49489892,   0.49623129,   0.4975625,
    0.49889255,   0.50022137,   0.50154907,   0.50287557,
    0.50420088,   0.50552505,   0.50684798,   0.50816971,
    0.50949025,   0.5108096,    0.51212776,   0.51344472,
    0.51476043,   0.51607502,   0.51738828,   0.51870042,
    0.52001131,   0.52132094,   0.52262932,   0.52393657,
    0.52524251,   0.52654725,   0.52785075,   0.52915299,
    0.53045398,   0.53175372,   0.53305221,   0.53434944,
    0.53564548,   0.53694022,   0.53823364,   0.53952587,
    0.54081678,   0.54210645,   0.5433948,    0.54468191,
    0.54596776,   0.5472523,    0.54853553,   0.5498175,
    0.55109817,   0.55237752,   0.55365556,   0.55493236,
    0.55620778,   0.55748194,   0.5587548,    0.56002629,
    0.56129652,   0.56256539,   0.56383294,   0.56509918,
    0.56636411,   0.56762767,   0.56888992,   0.57015079,
    0.57141036,   0.57266855,   0.57392544,   0.57518095,
    0.57643509,   0.57768792,   0.57893938,   0.58018941,
    0.58143812,   0.58268547,   0.58393145,   0.58517605,
    0.58641928,   0.58766115,   0.58890164,   0.5901407,
    0.59137839,   0.59261465,   0.5938496,    0.59508306,
    0.59631521,   0.59754586,   0.59877521,   0.60000306,
    0.60122955,   0.6024546,    0.60367823,   0.60490048,
    0.60612124,   0.60734063,   0.6085586,    0.60977507,
    0.61099017,   0.61220378,   0.61341602,   0.61462677,
    0.61583608,   0.61704391,   0.61825031,   0.61945528,
    0.62065876,   0.6218608,    0.62306136,   0.62426049,
    0.62545812,   0.62665427,   0.62784898,   0.62904221,
    0.63023394,   0.63142419,   0.63261294,   0.63380021,
    0.63498598,   0.63617027,   0.63735306,   0.63853437,
    0.63971412,   0.64089245,   0.64206922,   0.6432445,
    0.64441824,   0.64559048,   0.64676118,   0.64793038,
    0.64909804,   0.6502642,    0.65142882,   0.65259188,
    0.6537534,    0.65491343,   0.6560719,    0.65722883,
    0.6583842,    0.65953803,   0.66069031,   0.66184098,
    0.66299015,   0.66413778,   0.6652838,    0.66642827,
    0.66757119,   0.6687125,    0.66985226,   0.67099047,
    0.67212707,   0.67326206,   0.6743955,    0.67552739,
    0.67665762,   0.67778629,   0.67891335,   0.68003887,
    0.68116271,   0.68228501,   0.6834057,    0.68452471,
    0.68564218,   0.68675804,   0.68787223,   0.68898487,
    0.69009584,   0.6912052,    0.6923129,    0.69341904,
    0.69452351,   0.69562632,   0.69672751,   0.6978271,
    0.69892502,   0.70002127,   0.70111591,   0.70220888,
    0.70330018,   0.70438987,   0.70547789,   0.70656425,
    0.70764893,   0.70873195,   0.7098133,    0.71089298,
    0.71197098,   0.71304733,   0.714122,     0.71519494,
    0.71626627,   0.71733588,   0.71840382,   0.71947002,
    0.72053456,   0.72159743,   0.72265857,   0.72371799,
    0.72477573,   0.72583181,   0.72688609,   0.72793871,
    0.7289896,    0.73003882,   0.73108631,   0.73213202,
    0.73317605,   0.73421836,   0.73525894,   0.73629779,
    0.73733491,   0.7383703,    0.7394039,    0.74043584,
    0.74146599,   0.7424944,    0.74352109,   0.744546,
    0.74556917,   0.74659055,   0.74761021,   0.74862814,
    0.74964422,   0.75065863,   0.7516712,    0.75268203,
    0.75369114,   0.7546984,    0.75570393,   0.75670767,
    0.75770962,   0.75870979,   0.75970817,   0.76070476,
    0.76169956,   0.76269257,   0.7636838,    0.76467323,
    0.76566082,   0.76664668,   0.7676307,    0.76861292,
    0.7695933,    0.77057189,   0.77154869,   0.77252364,
    0.77349681,   0.77446812,   0.77543765,   0.77640533,
    0.77737117,   0.77833521,   0.77929735,   0.78025776,
    0.78121626,   0.78217292,   0.78312778,   0.7840808,
    0.78503191,   0.78598124,   0.78692871,   0.78787434,
    0.78881806,   0.78975999,   0.79070002,   0.7916382,
    0.79257452,   0.79350895,   0.79444152,   0.79537225,
    0.79630107,   0.79722804,   0.79815316,   0.79907638,
    0.79999769,   0.80091715,   0.8018347,    0.80275041,
    0.80366421,   0.8045761,    0.80548608,   0.80639422,
    0.80730045,   0.80820471,   0.80910712,   0.81000763,
    0.81090623,   0.81180298,   0.81269777,   0.81359059,
    0.81448156,   0.81537062,   0.81625772,   0.8171429,
    0.81802619,   0.81890756,   0.81978697,   0.82066447,
    0.82154006,   0.82241368,   0.8232854,    0.82415515,
    0.825023,     0.82588887,   0.82675278,   0.82761478,
    0.82847482,   0.82933295,   0.83018905,   0.83104324,
    0.83189547,   0.83274573,   0.83359408,   0.83444041,
    0.83528483,   0.83612722,   0.83696771,   0.83780622,
    0.83864272,   0.83947724,   0.84030986,   0.84114045,
    0.84196901,   0.84279567,   0.8436203,    0.84444296,
    0.84526366,   0.84608233,   0.84689903,   0.84771377,
    0.84852648,   0.84933716,   0.85014588,   0.85095257,
    0.85175729,   0.85255998,   0.85336071,   0.85415941,
    0.85495609,   0.85575074,   0.85654342,   0.85733408,
    0.85812265,   0.85890925,   0.85969388,   0.86047643,
    0.86125696,   0.86203545,   0.86281192,   0.86358637,
    0.86435878,   0.86512917,   0.86589754,   0.86666387,
    0.86742812,   0.86819035,   0.86895055,   0.86970872,
    0.8704648,    0.8712188,    0.87197083,   0.87272078,
    0.8734687,    0.87421453,   0.87495828,   0.8757,
    0.87643969,   0.8771773,    0.87791282,   0.87864625,
    0.87937766,   0.88010699,   0.88083428,   0.88155943,
    0.88228256,   0.88300359,   0.88372254,   0.88443947,
    0.88515425,   0.88586694,   0.88657761,   0.88728613,
    0.88799256,   0.88869697,   0.88939923,   0.89009941,
    0.8907975,    0.8914935,    0.89218742,   0.89287919,
    0.89356887,   0.89425647,   0.89494199,   0.89562535,
    0.89630663,   0.89698577,   0.89766282,   0.89833778,
    0.8990106,    0.89968133,   0.90034992,   0.90101641,
    0.90168077,   0.90234298,   0.9030031,    0.90366107,
    0.90431696,   0.90497071,   0.9056223,    0.90627176,
    0.90691912,   0.90756428,   0.90820736,   0.90884835,
    0.90948713,   0.91012377,   0.91075826,   0.91139066,
    0.91202086,   0.91264898,   0.91327488,   0.91389865,
    0.91452032,   0.91513979,   0.91575712,   0.9163723,
    0.91698527,   0.91759616,   0.91820484,   0.91881138,
    0.91941577,   0.92001796,   0.92061806,   0.92121589,
    0.92181164,   0.92240518,   0.92299652,   0.92358577,
    0.92417276,   0.92475766,   0.92534029,   0.92592078,
    0.92649913,   0.92707527,   0.92764926,   0.92822099,
    0.92879063,   0.92935801,   0.92992324,   0.93048626,
    0.93104708,   0.93160576,   0.93216223,   0.93271649,
    0.93326855,   0.93381846,   0.93436611,   0.93491161,
    0.93545485,   0.93599594,   0.93653482,   0.9370715,
    0.93760598,   0.93813825,   0.93866825,   0.93919611,
    0.93972176,   0.94024521,   0.94076639,   0.94128537,
    0.9418022,    0.94231677,   0.94282907,   0.94333923,
    0.94384712,   0.94435281,   0.94485629,   0.94535756,
    0.94585657,   0.94635338,   0.94684792,   0.94734025,
    0.94783038,   0.94831824,   0.9488039,    0.9492873,
    0.94976848,   0.95024747,   0.95072412,   0.95119864,
    0.95167089,   0.95214087,   0.95260859,   0.9530741,
    0.9535374,    0.95399845,   0.95445722,   0.95491374,
    0.95536804,   0.95582008,   0.95626986,   0.95671743,
    0.95716268,   0.95760572,   0.9580465,    0.95848507,
    0.95892131,   0.95935535,   0.95978713,   0.96021664,
    0.96064389,   0.96106887,   0.96149158,   0.96191204,
    0.96233022,   0.96274614,   0.9631598,    0.96357119,
    0.96398038,   0.96438724,   0.96479183,   0.96519411,
    0.96559417,   0.96599197,   0.96638745,   0.96678072,
    0.96717167,   0.96756035,   0.96794677,   0.96833086,
    0.96871275,   0.96909231,   0.96946961,   0.96984458,
    0.97021735,   0.97058779,   0.97095597,   0.97132182,
    0.97168541,   0.97204667,   0.97240573,   0.97276247,
    0.97311687,   0.97346902,   0.9738189,    0.97416645,
    0.97451174,   0.97485471,   0.97519541,   0.97553378,
    0.97586989,   0.97620368,   0.9765352,    0.9768644,
    0.97719133,   0.97751594,   0.97783822,   0.97815824,
    0.97847593,   0.97879136,   0.97910446,   0.97941524,
    0.97972369,   0.98002988,   0.98033381,   0.98063534,
    0.98093462,   0.98123157,   0.98152626,   0.98181856,
    0.98210859,   0.9823963,    0.98268169,   0.98296481,
    0.98324561,   0.98352402,   0.98380023,   0.98407406,
    0.98434556,   0.98461479,   0.98488164,   0.98514622,
    0.98540848,   0.98566842,   0.98592603,   0.98618132,
    0.98643428,   0.98668498,   0.98693329,   0.98717928,
    0.98742294,   0.98766434,   0.98790336,   0.98814011,
    0.98837447,   0.98860651,   0.98883629,   0.98906368,
    0.98928875,   0.98951149,   0.98973197,   0.98995006,
    0.99016583,   0.99037921,   0.99059033,   0.99079913,
    0.9910056,    0.99120969,   0.99141145,   0.99161088,
    0.991808,     0.99200279,   0.99219525,   0.99238533,
    0.99257314,   0.99275857,   0.99294168,   0.99312246,
    0.99330086,   0.99347699,   0.99365073,   0.99382216,
    0.9939912,    0.99415797,   0.99432236,   0.99448442,
    0.99464417,   0.99480152,   0.99495655,   0.99510926,
    0.99525958,   0.99540764,   0.99555331,   0.9956966,
    0.99583763,   0.99597627,   0.99611259,   0.99624652,
    0.99637812,   0.99650741,   0.9966343,    0.99675888,
    0.99688113,   0.99700099,   0.99711853,   0.99723375,
    0.99734658,   0.99745709,   0.99756527,   0.99767107,
    0.99777448,   0.99787563,   0.9979744,    0.99807078,
    0.99816483,   0.99825656,   0.99834591,   0.99843293,
    0.99851763,   0.99859995,   0.99867994,   0.99875754,
    0.99883282,   0.99890572,   0.99897629,   0.99904448,
    0.99911034,   0.99917388,   0.99923503,   0.99929386,
    0.99935031,   0.99940443,   0.99945617,   0.99950558,
    0.99955267,   0.99959737,   0.99963969,   0.99967968,
    0.99971735,   0.99975264,   0.9997856,    0.99981618,
    0.99984443,   0.9998703,    0.99989384,   0.999915,
    0.99993384,   0.99995029,   0.99996442,   0.99997616,
    0.99998558,   0.99999267,   0.99999738,   0.9999997,
};

const float ff_on2avc_window_long_24000[1024] = {
    0.00000102,     0.0000091700003, 0.000025470001, 0.00004993,
    0.000082530001, 0.00012328,      0.00017219,     0.00022924,
    0.00029443001,  0.00036778001,   0.00044927001,  0.00053890003,
    0.00063666998,  0.00074257998,   0.00085662998,  0.00097881001,
    0.00110913,     0.00124758,      0.00139415,     0.00154885,
    0.00171168,     0.00188262,      0.00206168,     0.00224885,
    0.0024441299,   0.00264751,      0.0028589999,   0.0030785799,
    0.0033062601,   0.00354202,      0.00378588,     0.00403781,
    0.0042978101,   0.0045658899,    0.0048420299,   0.0051262402,
    0.0054184902,   0.0057187998,    0.00602715,     0.0063435398,
    0.00666796,     0.00700041,      0.0073408699,   0.0076893498,
    0.0080458401,   0.0084103197,    0.0087828003,   0.0091632698,
    0.0095517104,   0.0099481298,    0.01035251,     0.01076485,
    0.01118513,     0.01161336,      0.01204952,     0.0124936,
    0.0129456,      0.01340551,      0.01387332,     0.01434902,
    0.0148326,      0.01532405,      0.015823361,    0.016330531,
    0.01684555,     0.017368389,     0.01789907,     0.018437561,
    0.01898385,     0.019537929,     0.020099809,    0.020669449,
    0.02124686,     0.021832019,     0.02242492,     0.02302555,
    0.023633899,    0.02424995,      0.024873709,    0.02550514,
    0.026144249,    0.026791019,     0.02744543,     0.02810749,
    0.02877716,     0.029454449,     0.030139331,    0.030831801,
    0.031531841,    0.032239441,     0.032954589,    0.033677269,
    0.03440747,     0.035145171,     0.035890371,    0.036643039,
    0.03740317,     0.038170759,     0.038945779,    0.039728221,
    0.040518072,    0.041315299,     0.04211992,     0.042931888,
    0.04375121,     0.044577859,     0.045411821,    0.046253089,
    0.047101639,    0.04795745,      0.048820522,    0.04969082,
    0.05056835,     0.051453069,     0.052344982,    0.053244069,
    0.054150298,    0.055063669,     0.055984162,    0.056911752,
    0.057846431,    0.058788169,     0.059736971,    0.060692791,
    0.061655629,    0.062625468,     0.063602284,    0.064586058,
    0.065576769,    0.06657441,      0.067578949,    0.06859038,
    0.069608673,    0.070633821,     0.071665794,    0.072704569,
    0.073750138,    0.074802481,     0.075861573,    0.076927401,
    0.077999942,    0.079079159,     0.080165058,    0.081257619,
    0.082356803,    0.083462588,     0.084574983,    0.085693933,
    0.086819433,    0.087951459,     0.089089997,    0.090235017,
    0.091386512,    0.092544436,     0.093708791,    0.094879538,
    0.09605667,     0.097240157,     0.098429978,    0.099626116,
    0.10082854,     0.10203723,      0.10325217,     0.10447333,
    0.1057007,      0.10693424,      0.10817393,     0.10941976,
    0.1106717,      0.11192972,      0.1131938,      0.11446393,
    0.11574007,     0.1170222,       0.1183103,      0.11960435,
    0.12090432,     0.12221018,      0.12352192,     0.12483951,
    0.12616292,     0.12749213,      0.12882711,     0.13016786,
    0.13151433,     0.13286649,      0.13422433,     0.13558783,
    0.13695695,     0.13833167,      0.13971195,     0.1410978,
    0.14248917,     0.14388604,      0.14528839,     0.1466962,
    0.14810941,     0.14952803,      0.150952,       0.15238133,
    0.15381598,     0.15525591,      0.15670112,     0.15815157,
    0.15960722,     0.16106807,      0.16253406,     0.16400519,
    0.16548143,     0.16696274,      0.1684491,      0.1699405,
    0.17143688,     0.17293824,      0.17444454,     0.17595574,
    0.17747185,     0.17899281,      0.1805186,      0.1820492,
    0.18358457,     0.18512468,      0.18666951,     0.18821906,
    0.18977325,     0.19133207,      0.19289552,     0.19446352,
    0.19603609,     0.19761316,      0.19919474,     0.20078079,
    0.20237127,     0.20396616,      0.20556541,     0.20716903,
    0.20877695,     0.21038917,      0.21200565,     0.21362637,
    0.21525128,     0.21688037,      0.21851361,     0.22015095,
    0.22179238,     0.22343788,      0.22508739,     0.2267409,
    0.22839837,     0.23005977,      0.2317251,      0.23339429,
    0.23506732,     0.2367442,       0.23842482,     0.24010922,
    0.24179734,     0.24348916,      0.24518465,     0.24688376,
    0.24858648,     0.25029278,      0.2520026,      0.25371596,
    0.25543278,     0.25715306,      0.25887677,     0.26060385,
    0.26233432,     0.26406807,      0.26580516,     0.26754549,
    0.26928905,     0.27103582,      0.27278578,     0.27453887,
    0.27629507,     0.27805433,      0.27981666,     0.281582,
    0.28335032,     0.28512162,      0.28689581,     0.28867289,
    0.29045284,     0.29223564,      0.29402119,     0.29580954,
    0.2976006,      0.29939437,      0.30119082,     0.3029899,
    0.30479157,     0.30659583,      0.30840263,     0.31021196,
    0.31202373,     0.31383798,      0.31565461,     0.31747365,
    0.31929505,     0.32111874,      0.32294473,     0.32477298,
    0.32660347,     0.32843611,      0.33027095,     0.33210787,
    0.33394691,     0.33578804,      0.33763117,     0.33947629,
    0.34132338,     0.34317243,      0.34502336,     0.34687617,
    0.3487308,      0.35058725,      0.35244548,     0.35430545,
    0.35616711,     0.35803047,      0.35989544,     0.36176205,
    0.36363024,     0.36549997,      0.36737123,     0.36924395,
    0.37111813,     0.37299374,      0.37487072,     0.37674904,
    0.3786287,      0.38050967,      0.38239187,     0.38427529,
    0.38615993,     0.3880457,       0.3899326,      0.39182061,
    0.39370969,     0.39559978,      0.39749089,     0.39938298,
    0.40127596,     0.40316987,      0.40506464,     0.40696028,
    0.40885669,     0.41075388,      0.41265181,     0.41455048,
    0.41644979,     0.41834977,      0.42025036,     0.42215151,
    0.42405322,     0.42595547,      0.42785817,     0.42976135,
    0.43166494,     0.43356892,      0.43547326,     0.43737793,
    0.43928292,     0.44118813,      0.4430936,      0.44499925,
    0.44690508,     0.44881102,      0.45071709,     0.45262322,
    0.4545294,      0.45643559,      0.45834175,     0.46024784,
    0.46215388,     0.46405977,      0.46596554,     0.46787113,
    0.46977648,     0.47168162,      0.47358647,     0.47549102,
    0.47739524,     0.4792991,       0.48120254,     0.48310557,
    0.48500812,     0.48691019,      0.48881173,     0.49071273,
    0.49261314,     0.49451295,      0.4964121,      0.4983106,
    0.50020838,     0.50210541,      0.50400168,     0.50589716,
    0.50779182,     0.50968558,      0.5115785,      0.51347047,
    0.51536149,     0.51725155,      0.5191406,      0.52102858,
    0.52291554,     0.52480137,      0.52668607,     0.52856964,
    0.53045195,     0.53233314,      0.53421301,     0.53609163,
    0.53796893,     0.53984493,      0.54171956,     0.54359275,
    0.54546458,     0.54733491,      0.54920375,     0.55107111,
    0.55293691,     0.55480117,      0.55666381,     0.55852479,
    0.56038415,     0.56224185,      0.56409782,     0.565952,
    0.56780452,     0.56965512,      0.571504,       0.57335097,
    0.57519609,     0.57703924,      0.57888049,     0.58071983,
    0.58255708,     0.58439237,      0.58622563,     0.58805674,
    0.58988583,     0.59171271,      0.59353751,     0.5953601,
    0.59718043,     0.59899855,      0.60081446,     0.60262799,
    0.60443926,     0.6062482,       0.6080547,      0.60985887,
    0.6116606,      0.61345983,      0.61525661,     0.61705089,
    0.61884266,     0.62063187,      0.62241846,     0.62420249,
    0.62598389,     0.62776262,      0.62953866,     0.63131201,
    0.63308257,     0.63485044,      0.63661551,     0.63837773,
    0.6401372,      0.64189374,      0.64364743,     0.6453982,
    0.64714605,     0.64889091,      0.65063286,     0.6523717,
    0.65410763,     0.65584046,      0.65757018,     0.65929681,
    0.6610204,      0.66274077,      0.66445798,     0.66617203,
    0.6678828,      0.66959041,      0.67129469,     0.67299575,
    0.67469347,     0.67638785,      0.67807889,     0.67976654,
    0.68145084,     0.68313169,      0.68480909,     0.68648309,
    0.68815356,     0.68982053,      0.69148397,     0.69314384,
    0.6948002,      0.69645292,      0.69810206,     0.69974756,
    0.70138937,     0.70302755,      0.70466202,     0.70629281,
    0.70791984,     0.70954311,      0.71116263,     0.71277833,
    0.71439022,     0.71599829,      0.71760249,     0.71920282,
    0.72079927,     0.72239184,      0.72398043,     0.72556508,
    0.72714579,     0.72872251,      0.73029518,     0.73186392,
    0.73342854,     0.73498911,      0.73654562,     0.73809808,
    0.73964638,     0.74119055,      0.74273056,     0.74426645,
    0.74579811,     0.74732566,      0.74884892,     0.75036794,
    0.75188273,     0.75339329,      0.75489956,     0.75640148,
    0.75789917,     0.75939244,      0.76088142,     0.76236606,
    0.76384634,     0.76532215,      0.76679361,     0.76826066,
    0.76972324,     0.77118134,      0.77263504,     0.77408427,
    0.77552897,     0.77696913,      0.77840483,     0.779836,
    0.78126258,     0.78268462,      0.78410208,     0.78551495,
    0.78692323,     0.78832692,      0.7897259,      0.79112029,
    0.79251003,     0.79389513,      0.79527551,     0.79665124,
    0.79802221,     0.79938853,      0.80075008,     0.80210692,
    0.80345899,     0.80480635,      0.80614889,     0.80748665,
    0.80881965,     0.81014782,      0.81147122,     0.8127898,
    0.81410348,     0.8154124,       0.81671643,     0.81801558,
    0.81930989,     0.82059932,      0.8218838,      0.82316345,
    0.82443815,     0.82570797,      0.82697284,     0.82823282,
    0.8294878,      0.83073789,      0.83198297,     0.8332231,
    0.83445829,     0.83568847,      0.8369137,      0.83813387,
    0.83934909,     0.8405593,       0.84176451,     0.84296465,
    0.84415978,     0.84534991,      0.84653497,     0.84771496,
    0.84888995,     0.85005987,      0.85122472,     0.85238451,
    0.85353923,     0.85468888,      0.85583341,     0.85697287,
    0.85810727,     0.85923654,      0.86036074,     0.86147982,
    0.86259383,     0.86370265,      0.86480641,     0.86590505,
    0.86699861,     0.86808699,      0.86917025,     0.87024838,
    0.87132144,     0.87238932,      0.87345207,     0.87450963,
    0.87556213,     0.87660944,      0.87765163,     0.87868869,
    0.87972057,     0.88074732,      0.88176894,     0.88278538,
    0.88379669,     0.88480288,      0.88580388,     0.88679975,
    0.88779044,     0.88877606,      0.88975644,     0.89073175,
    0.89170188,     0.89266688,      0.89362669,     0.89458138,
    0.89553094,     0.89647537,      0.89741462,     0.89834881,
    0.89927781,     0.90020168,      0.90112042,     0.90203404,
    0.90294254,     0.90384591,      0.90474415,     0.90563726,
    0.90652531,     0.90740818,      0.90828604,     0.90915871,
    0.91002631,     0.91088885,      0.91174626,     0.91259861,
    0.91344583,     0.91428804,      0.91512513,     0.91595721,
    0.91678417,     0.91760612,      0.918423,       0.91923481,
    0.92004162,     0.92084336,      0.92164016,     0.92243183,
    0.92321855,     0.92400026,      0.92477697,     0.92554867,
    0.92631537,     0.92707711,      0.92783386,     0.92858565,
    0.92933249,     0.93007439,      0.93081135,     0.93154335,
    0.93227047,     0.93299264,      0.93370992,     0.93442225,
    0.93512976,     0.93583232,      0.93653005,     0.93722296,
    0.93791091,     0.9385941,       0.9392724,      0.93994594,
    0.94061458,     0.94127852,      0.94193757,     0.94259191,
    0.94324142,     0.94388616,      0.9445262,      0.94516146,
    0.94579202,     0.94641781,      0.94703895,     0.94765538,
    0.9482671,      0.94887418,      0.94947654,     0.95007432,
    0.95066744,     0.95125592,      0.9518398,      0.95241904,
    0.95299375,     0.95356387,      0.95412946,     0.95469046,
    0.95524693,     0.95579892,      0.95634633,     0.95688927,
    0.9574278,      0.9579618,       0.95849133,     0.95901644,
    0.95953715,     0.96005344,      0.96056533,     0.96107286,
    0.96157598,     0.96207482,      0.96256924,     0.96305943,
    0.9635452,      0.96402675,      0.96450406,     0.96497703,
    0.96544582,     0.96591038,      0.9663707,      0.9668268,
    0.96727878,     0.96772653,      0.96817023,     0.96860969,
    0.9690451,      0.9694764,       0.96990365,     0.97032678,
    0.97074586,     0.97116095,      0.97157204,     0.97197908,
    0.97238219,     0.9727813,       0.97317648,     0.97356778,
    0.97395509,     0.97433859,      0.97471815,     0.9750939,
    0.97546583,     0.97583389,      0.9761982,      0.97655869,
    0.97691542,     0.97726846,      0.97761768,     0.97796327,
    0.97830516,     0.97864336,      0.97897792,     0.97930884,
    0.97963619,     0.97995991,      0.9802801,      0.98059666,
    0.98090976,     0.98121929,      0.98152536,     0.98182797,
    0.98212707,     0.98242277,      0.98271501,     0.98300391,
    0.98328942,     0.98357159,      0.98385036,     0.98412585,
    0.98439807,     0.984667,        0.98493266,     0.9851951,
    0.98545432,     0.98571032,      0.98596323,     0.98621291,
    0.98645949,     0.98670292,      0.9869433,      0.98718059,
    0.98741484,     0.98764604,      0.98787427,     0.98809952,
    0.98832178,     0.98854107,      0.98875749,     0.98897099,
    0.98918158,     0.98938936,      0.98959428,     0.98979634,
    0.98999566,     0.99019217,      0.99038595,     0.99057698,
    0.99076533,     0.99095094,      0.99113393,     0.99131429,
    0.99149197,     0.99166709,      0.99183959,     0.99200952,
    0.99217695,     0.99234182,      0.99250424,     0.99266416,
    0.99282163,     0.99297667,      0.99312931,     0.99327952,
    0.9934274,      0.99357295,      0.99371612,     0.99385703,
    0.99399561,     0.99413198,      0.99426609,     0.994398,
    0.9945277,      0.99465519,      0.9947806,      0.9949038,
    0.99502492,     0.99514401,      0.99526095,     0.99537587,
    0.99548876,     0.99559963,      0.99570858,     0.99581552,
    0.99592048,     0.9960236,       0.99612474,     0.99622405,
    0.9963215,      0.99641711,      0.99651092,     0.99660289,
    0.99669313,     0.99678159,      0.99686831,     0.99695337,
    0.9970367,      0.99711835,      0.99719834,     0.99727672,
    0.99735349,     0.99742872,      0.99750233,     0.99757439,
    0.9976449,      0.99771392,      0.99778146,     0.99784756,
    0.99791217,     0.99797535,      0.9980371,      0.99809748,
    0.99815649,     0.99821413,      0.99827045,     0.99832547,
    0.99837923,     0.99843168,      0.99848282,     0.99853277,
    0.99858153,     0.99862903,      0.99867541,     0.99872059,
    0.99876463,     0.99880755,      0.99884939,     0.9988901,
    0.99892974,     0.99896836,      0.99900591,     0.99904245,
    0.99907798,     0.99911255,      0.99914616,     0.99917883,
    0.99921054,     0.99924135,      0.99927121,     0.99930024,
    0.99932843,     0.99935573,      0.9993822,      0.99940789,
    0.99943274,     0.99945682,      0.99948019,     0.99950278,
    0.99952459,     0.99954569,      0.99956614,     0.99958587,
    0.99960488,     0.9996233,       0.99964106,     0.99965817,
    0.99967468,     0.99969059,      0.99970591,     0.99972069,
    0.99973488,     0.99974853,      0.99976164,     0.99977428,
    0.99978638,     0.999798,        0.99980915,     0.99981982,
    0.99983001,     0.99983978,      0.99984914,     0.99985808,
    0.99986666,     0.99987477,      0.99988258,     0.99988997,
    0.99989706,     0.99990374,      0.99991012,     0.9999162,
    0.99992198,     0.9999274,       0.99993259,     0.99993742,
    0.99994206,     0.99994642,      0.99995053,     0.9999544,
    0.99995804,     0.99996144,      0.99996465,     0.99996763,
    0.99997044,     0.99997306,      0.9999755,      0.99997777,
    0.99997985,     0.99998182,      0.99998367,     0.99998534,
    0.99998689,     0.99998826,      0.99998957,     0.99999076,
    0.99999183,     0.99999285,      0.99999374,     0.99999452,
    0.99999523,     0.99999589,      0.99999648,     0.99999702,
    0.9999975,      0.99999785,      0.99999821,     0.99999857,
    0.99999881,     0.99999905,      0.99999923,     0.9999994,
    0.99999952,     0.99999964,      0.9999997,      0.99999982,
    0.99999982,     0.99999988,      0.99999994,     0.99999994,
    0.99999994,     1.0,             1.0,            1.0,
    1.0,            1.0,             1.0,            1.0,
};

const float ff_on2avc_window_short[128] = {
    1.320684e-12,    1.3218859e-12,   1.324119e-12,   1.3269172e-12,
    1.3297907e-12,   1.3316993e-12,   1.3321618e-12,  1.3303409e-12,
    1.3297163e-12,   1.3598052e-12,   1.6224489e-12,  3.238457e-12,
    1.1376874e-11,   4.6434454e-11,   1.80557e-10,    6.4489758e-10,
    2.1179569e-9,    6.4429635e-9,    1.8292885e-8,   4.880043e-8,
    1.2303467e-7,    2.946195e-7,     6.729764e-7,    0.0000014718792,
    0.0000030924566, 0.0000062596109, 0.000012238012, 0.000023162085,
    0.000042523086,  0.000075864329,  0.00013174133,  0.00022300506,
    0.00036846122,   0.00059494411,   0.00093981833,  0.001453883,
    0.0022046037,    0.0032795328,    0.004789711,    0.0068727732,
    0.0096954042,    0.01345476,      0.018378416,    0.02472244,
    0.032767218,     0.042810757,     0.055159383,    0.070115872,
    0.087965287,     0.10895917,      0.1332987,      0.16111787,
    0.19246797,      0.22730421,      0.26547599,     0.30672187,
    0.35066974,      0.39684334,      0.44467437,     0.49352086,
    0.54269004,      0.59146535,      0.6391356,      0.68502444,
    0.72851861,      0.76909274,      0.80632913,     0.83993185,
    0.8697328,       0.89569116,      0.91788524,     0.93649811,
    0.95179814,      0.96411639,      0.97382277,     0.9813022,
    0.98693413,      0.99107492,      0.9940452,      0.99612254,
    0.99753785,      0.99847656,      0.99908221,     0.99946207,
    0.99969339,      0.99983019,      0.99990857,     0.99995208,
    0.9999755,       0.99998766,      0.9999938,      0.99999678,
    0.99999821,      0.99999893,      0.99999923,     0.99999946,
    0.99999958,      0.9999997,       0.99999982,     0.99999994,
    1.0000001,       1.0000002,       1.0000004,      1.0000005,
    1.0000006,       1.0000008,       1.000001,       1.000001,
    1.0000011,       1.0000012,       1.0000013,      1.0000014,
    1.0000014,       1.0000015,       1.0000015,      1.0000015,
    1.0000015,       1.0000014,       1.0000014,      1.0000014,
    1.0000013,       1.0000013,       1.0000012,      1.0000012,
    1.0000011,       1.0000011,       1.0000011,      1.0000011,
};

const double ff_on2avc_tab_10_1[] = {
    0.0033357253, -0.012580752, -0.0062414902, 0.077571494, -0.03224487,
    -0.24229489,   0.13842815,   0.72430853,   0.60382927,   0.1601024
};

const double ff_on2avc_tab_10_2[] = {
    -0.1601024,    0.60382927,  -0.72430853,   0.13842815,  0.24229489,
    -0.03224487,  -0.077571494, -0.0062414902, 0.012580752, 0.0033357253,
     0.33266699,   0.80689015,   0.45988244,  -0.13500994, -0.085442654,
     0.035226542, -0.035226543, -0.085442656,  0.13500994,  0.45988246,
    -0.80689017,   0.332667
};

const double ff_on2avc_tab_20_1[] = {
    -0.0014416961, -0.00056214974, 0.020948911,   0.025363335,   -0.10427845,
    -0.2318503,     0.06892613,    0.63810513,    0.6843251,      0.20162185,
    -0.033582,      0.07313663,    0.08143964,   -0.0063137698,  -0.012688661,
     0.0089685127,  0.0035534843, -0.0016078273, -0.000095677464, 0.0002453756
};

const double ff_on2avc_tab_20_2[] = {
    -0.0002453755997325089, -0.00009567746389569924,  0.001607827298247261,
     0.003553484296126244,  -0.008968512690223166,   -0.01268866098616772,
     0.006313769793117177,   0.08143963991122029,    -0.07313662992027165,
    -0.03358199996339129,   -0.2016218497802062,      0.6843250992539974,
    -0.6381051293043832,     0.06892612992486163,     0.2318502997472533,
    -0.1042784498863231,    -0.0253633349723507,      0.02094891097716299,
     0.0005621497393871844, -0.001441696098428365
};

const double ff_on2avc_tab_40_1[] = {
    -0.0000017445457, -0.000001814441,   0.000038676008,  0.000045716169,
    -0.00041789492,   -0.00062315149,    0.0027052457,    0.0053753308,
    -0.010572396,     -0.030726394,      0.01871785,      0.11585315,
     0.03958068,      -0.25000242,      -0.29886274,      0.18287176,
     0.65781885,       0.548686,         0.17696839,      0.08330372,
     0.14234582,       0.064187778,     -0.03396015,     -0.013302871,
     0.020618859,      0.0018984093,    -0.010561246,    -0.00010918036,
     0.0035190253,    -0.00057674024,   -0.0010263441,    0.00030131618,
     0.00022613687,   -0.000089637969,  -0.000032248444,  0.00001882641,
     0.0000029119687, -0.0000023940844, -1.3944369e-7,    1.3407205e-7,
};

const double ff_on2avc_tab_40_2[] = {
    -1.340720502155867e-7,    -1.394436902242243e-7,    0.000002394084403849667,
     0.000002911968704682421, -0.00001882641003027271, -0.00003224844405185522,
     0.00008963796914413709,   0.0002261368703636262,  -0.0003013161804845139,
    -0.001026344101650353,     0.0005767402409273933,   0.003519025305658563,
     0.0001091803601755611,   -0.01056124601698239,    -0.001898409303052626,
     0.02061885903315495,      0.0133028710213909,     -0.03396015005460763,
    -0.0641877781032134,       0.1423458202288909,     -0.08330372013395167,
     0.1769683902845637,      -0.5486860008822824,      0.6578188510577671,
    -0.1828717602940562,      -0.2988627404805687,      0.2500024204020018,
     0.03958068006364539,     -0.1158531501862909,      0.01871785003009814,
     0.03072639404940778,     -0.01057239601700032,    -0.005375330808643486,
     0.002705245704350012,     0.0006231514910020222,  -0.0004178949206719714,
    -0.00004571616907351121,   0.00003867600806219069,  0.000001814441002917606,
    -0.000001744545702805214
};

const double ff_on2avc_tab_84_1[] = {
    -0.003834605569340214,    -0.01399666493880675,     -0.02423522354202532,
    -0.02098660725909453,     -0.003033811991149968,     0.02580968794845409,
     0.05022200106698627,      0.05480106279059652,      0.0370527194554745,
     0.01293943431893363,      0.012874098608023,        0.06242007669752228,
     0.1711674720067008,       0.3168985339332503,       0.4463224645440312,
     0.4997307843290636,       0.442680199327905,        0.2862974432523162,
     0.08192922995482327,     -0.100687848630388,       -0.2010749890073668,
    -0.1970564705797125,      -0.1136363541357198,      -0.006482554176098804,
     0.06983853153253429,      0.08958734697447382,      0.0598384364842016,
     0.009627953684538691,    -0.02776530291935209,     -0.03485384358824609,
    -0.01638430987962629,      0.01132787970877885,      0.02744697607433038,
     0.02280082564277705,      0.003817601656862559,    -0.01536124106173835,
    -0.02070943469222549,     -0.01286651718416282,      0.0005632574484435138,
     0.007577496599690143,     0.01014022979594007,      0.006400316454349855,
    -0.001317309067039239,    -0.00317940336781777,     -0.002405842901164466,
    -0.001661745856529503,    -0.00005380161101133026,   0.0009898316472595594,
     0.0007039765787268925,   -0.000189661703240109,    -0.0001182674960570266,
     0.0002115051270037225,   -0.00008565649434604059,  -0.0001252806220197323,
     0.0001500012974557671,    0.00002957208561445737,  -0.000118882457357092,
    -0.000007421996284144832,  0.00004351015061547388,  -0.000005737099377545248,
    -0.0000164747057254053,    0.00001923482660002518,  -0.00001093031593938137,
    -0.00001002792095051621,   0.00001250573423880376,   0.000004127061570609871,
    -0.000003458244341720683, -0.000003058993334597815,  0.000002160520943418329,
     8.907414904197164e-7,    -0.000001316252923085336,  3.681255415998394e-7,
     6.245867533258108e-7,    -1.129925213069921e-7,     3.315839446922364e-7,
    -1.356572071896963e-7,    -4.318309977365961e-7,    -1.367503553365523e-7,
     4.470828965968303e-8,     9.212902857354196e-8,     3.695547755036224e-8,
     1.505766197979149e-8,    -6.958994047152974e-9,    -8.758631202056997e-9
};

const double ff_on2avc_tab_84_2[] = {
     0.002715349650922232,   -0.01033050750152524,     -0.01528172942791371,
     0.005838722508994047,    0.01599086024371182,     -0.01737535183522147,
    -0.01418596452135431,     0.05969677252151454,      0.07139735966046348,
    -0.06379927990205171,    -0.1516174471801191,       0.008365792873769096,
     0.1866714915958021,      0.04432405351099893,     -0.2179875184285703,
    -0.1089585577690529,      0.2761321070772847,       0.294949416655377,
    -0.1811068533291373,     -0.4710662031299601,      -0.1397679263799359,
     0.3386633432956985,      0.3588950861292916,       0.03198338392910033,
    -0.1801130026394404,     -0.178622266226761,       -0.1270863570294224,
    -0.0332786110926095,      0.1326619748641741,       0.2077421015185226,
     0.07027624884033033,    -0.1065486044522993,      -0.125884731750194,
    -0.0399897264540468,      0.003687144241560403,     0.01609004681595481,
     0.04950212493135606,     0.05748681524682781,      0.004041844771574074,
    -0.04142122345639772,    -0.02559310071302269,      0.002755316641486144,
     0.003184997421951853,   -0.005531116810971506,     0.008338191103621911,
     0.01252616152446114,    -0.003312308536298372,    -0.007161498814519848,
     0.001337745209122465,    0.002343332617933073,    -0.001621098790238126,
    -0.00129682569402033,     0.001491028268251773,     0.0003044153446278188,
    -0.0007048834926788463,   0.00004445131250124058,   0.0003635790848622476,
    -0.000143533732887211,   -0.00002972390773997905,   0.0001176094971737509,
    -0.00006171908908217019, -0.0001084231902960109,    0.00007896973444840752,
     0.0000499995995843891,  -0.00006444906759864038,  -0.000018321011061942,
     0.00001482481130354497,  0.00001058934262851235,  -0.000004798424433342611,
    -4.761276869473942e-7,    0.00000188617755070578,  -0.000001674634418015107,
    -1.53944330645465e-7,     9.240123633592371e-7,    -0.000001235630235014779,
     4.925891606823236e-8,    0.000001206615355189743,  3.647623817617871e-7,
    -1.087267533862797e-7,   -2.529052443169693e-7,    -1.1961026302477e-7,
    -4.873569574324943e-8,    2.252351108799612e-8,     2.834822470870021e-8
};

const double ff_on2avc_tab_84_3[] = {
    -0.00434676231664159,      0.006714123005267953,     0.008698054407437532,
    -0.01370846523601941,      0.01012828941725749,     -0.007068078935658625,
    -0.008138346009558437,     0.0467353028783406,      -0.0658381497176358,
     0.01310067828595943,      0.07269279617480232,     -0.1069564909021104,
     0.06762691282426264,      0.01034035065310993,     -0.1175699606097785,
     0.192812157569135,       -0.1084409432849384,      -0.1353394082449725,
     0.290587999391769,       -0.1665935202779336,      -0.09927986222827791,
     0.2394316349364771,      -0.196937680294991,        0.04675035632757467,
     0.160737603124711,       -0.2866953475517299,       0.11533530450257,
     0.2313808347485174,      -0.285955205900817,       -0.07033046899644142,
     0.3010809341153604,      -0.03711556319204814,     -0.2854261021892172,
     0.1326266190726841,       0.2334442000696142,      -0.2160410554670428,
    -0.122575309612308,        0.2186808995859664,       0.02544075501374961,
    -0.1660358993667236,       0.02009196196614523,      0.1162583994153812,
    -0.03991958608138682,     -0.07115975637749203,      0.04270444046513863,
     0.03536651879157764,     -0.02655940136961219,     -0.0166541988800009,
     0.01811758653663791,      0.003161066879299114,    -0.006590249135122636,
     0.0000224660373347443,    0.002764837297017082,    -0.001816050098089884,
     0.000221385824782758,     0.001325129169916481,    -0.0009313048485056467,
    -0.001002997644614651,     0.0006461390960813223,    0.0005091843808757102,
    -0.0004981831027749185,   -0.0002132118318370338,    0.0001692041329121999,
     0.00009203280989519006,  -0.0000726634301061485,   -0.000003776173954180476,
     0.000005650286559057409,  1.015871235188678e-8,     0.000009297695668468626,
     0.000008217172691037263, -0.000005352793597674221, -0.000004293043830914206,
     0.00000406840557498943,   0.000001957539844881767, -0.000001357985014138161,
    -7.970430363552399e-7,     5.338776009119553e-7,     1.022190984936616e-7,
     7.153181993493103e-9,    -9.647767193713991e-8,    -1.087063157245304e-7,
    -4.429283737485961e-8,     2.047021589652069e-8,     2.576393519656189e-8
};

const double ff_on2avc_tab_84_4[] = {
    -0.0008804814258974317,    0.001677984795861344,     0.0019438229200474,
    -0.002374701634816941,     0.002842769830143803,    -0.00313020546738317,
    -0.002246992394582708,     0.01055408593972395,     -0.01218520382203817,
    -0.0006735617784857061,    0.02057268271156303,     -0.03472338199007904,
     0.02960799007316684,     -0.003269335988224603,    -0.02972969305167542,
     0.05008512160999294,     -0.04400487480883553,      0.01713790123047206,
     0.001794796985095048,     0.02465108569696885,     -0.1185046238791295,
     0.2661533909042693,      -0.4170434096290337,       0.5056971209966197,
    -0.4839205146480338,       0.348475120088803,       -0.1457287020663733,
    -0.04963861239550338,      0.1710032440522816,      -0.1892135762829684,
     0.1231345995813251,      -0.02389080306388811,     -0.054785057318703,
     0.08416222204781872,     -0.0666027804409105,       0.02377207113744183,
     0.01203829040820619,     -0.02516530033022068,      0.01840432198285431,
    -0.006286010406016099,    -0.004035603243854861,     0.006949156667744018,
    -0.00161215048516293,     -0.001828701991824727,     0.0009090589499595256,
     0.0009761363135882747,   -0.002142429121283414,     0.0004188485015062717,
     0.001809279129203381,    -0.000932687525032396,    -0.0009486028487922317,
     0.0009397940062201393,    0.000281183371137153,    -0.0009248586848561844,
     0.0002152615409451283,    0.0005477801444594987,   -0.0002659748756010768,
    -0.0002773742035095173,    0.0002260622852620992,    0.0001512792970069076,
    -0.0001768728566277711,   -0.00002986876958461399,   0.00005130565743733275,
     0.000004374757277468806, -0.00002195539036180244,   0.000002913282980087422,
     3.818084416943484e-7,    -0.000006288075796943977,  0.000006984829418122699,
     0.00000614694006919441,  -0.000005946919055089292, -0.000001264733599421358,
     0.000004339214975250828,  0.000001188830031229202, -2.565690994853701e-7,
    -8.929058735983076e-7,    -5.618418560386023e-7,    -2.216635610199557e-7,
     9.901798023372271e-8,     1.312667895662033e-7,     6.845290101279972e-9,
     2.7891417275888e-9,      -1.289019550645086e-9,    -1.62236765541716e-9
};

static const double tabs_4_10[4 * 2][10] = {
    {  0.92756648,      0.17727433,    -0.31028851,    -0.041293536,    0.099339873,
      -0.0079929986,   -0.016111206,    0.004271808,    0.0,            0.0 },
    { 0.0,              0.0,            0.16008016,     0.60374538,     0.7244924,
      0.13948189,      -0.24189853,    -0.03548063,     0.075736174,    0.0034171261 },
    { 0.0,              0.0,           -2.0495447e-10, -7.6501622e-10,  0.15922493,
      0.60051988,       0.72580564,     0.15828764,    -0.23272256,    -0.089524832 },
    { 0.0,              0.0,            1.7673448e-10,  6.4163071e-10,  0.000032608112,
      0.00012297965,    0.15178394,     0.57192786,     0.73750254,     0.32549984 },
    { 0.32549984,      -0.73750254,     0.57192786,    -0.15178394,     0.00012297965,
      -0.000032608112,  6.4163071e-10, -1.7673448e-10,  0.0,            0.0 },
    { -0.089524832,     0.23272256,     0.15828764,    -0.72580564,     0.60051988,
      -0.15922493,     -7.6501621e-10,  2.0495446e-10,  0.0,            0.0 },
    { 0.0034171261,    -0.075736174,   -0.03548063,     0.24189853,     0.13948189,
     -0.7244924,        0.60374538,    -0.16008016,     0.0,            0.0 },
    { 0.0,              0.0,            0.004271808,    0.016111206,   -0.0079929986,
     -0.099339873,     -0.041293536,    0.31028851,     0.17727433,    -0.92756648 }
};

const double * const ff_on2avc_tabs_4_10_1[4] = {
    tabs_4_10[0], tabs_4_10[1], tabs_4_10[2], tabs_4_10[3]
};

const double * const ff_on2avc_tabs_4_10_2[4] = {
    tabs_4_10[4], tabs_4_10[5], tabs_4_10[6], tabs_4_10[7]
};

static const double tabs_9_20[9 * 2][20] = {
    { 0.20265566, 0.6892313,   0.64164786,  0.066309055,  -0.23597194,
     -0.10432145, 0.027402007, 0.02147583, -0.0011571443, -0.0016923795,
      0.00010941944, 0.000063155164, -0.000012061176, -0.0000094681391, 6.8164837e-7,
      8.0672986e-7, -1.2001096e-8, -3.0778157e-8, 0.0, 0.0, },
    { 0.07340142, -0.033796895, 0.20223772, 0.68677248, 0.64011737,
      0.068365159, -0.23333401, -0.10451285, 0.025911516, 0.021156819,
     -0.00066987817, -0.0015032608, 0.000010536012, 0.000009012748, -4.0880101e-7,
     -6.3486186e-7, 5.2718557e-9, 1.3520266e-8, 0.0, 0.0, },
    { -0.0063151262, 0.081450872, 0.073146431, -0.033591262, 0.20164331,
      0.68441526, 0.63817515, 0.068893633, -0.23191782, -0.10429366,
      0.025382739, 0.020958119, -0.0005645414, -0.0014434993, 1.2043506e-7,
      1.5836305e-7, -1.9186041e-9, -4.9204755e-9, 0.0, 0.0, },
    { 0.0089685824, -0.012688761, -0.0063138246, 0.081440272, 0.073137193,
     -0.033582316, 0.20162334, 0.68433035, 0.63810986, 0.068926154,
     -0.23185254, -0.1042793, 0.025363699, 0.020949148, -0.00056217266,
     -0.0014417225, 4.1287276e-10, 1.0588585e-9, 0.0, 0.0, },
    { -0.0016078274, 0.0035534844, 0.008968513, -0.012688661, -0.00631377,
      0.081439643, 0.073136632, -0.033582001, 0.20162186, 0.68432512,
      0.63810515, 0.068926132, -0.23185031, -0.10427845, 0.025363336,
      0.020948912, -0.00056214976, -0.0014416961, 0.0, 0.0, },
    { 0.0, 0.0, 0.00024537589, -0.000095677578, -0.0016078292,
      0.0035534886, 0.0089685234, -0.012688676, -0.0063137774, 0.081439737,
      0.073136717, -0.03358204, 0.20162209, 0.68432592, 0.63810589,
      0.068926212, -0.23185058, -0.10427857, 0.025363365, 0.020948936, },
    { 0.0, 0.0, -1.091532e-8, 4.2561286e-9, 0.00024558029,
      -0.000095887463, -0.0016090989, 0.0035559773, 0.0089736609, -0.01269917,
      -0.0063204498, 0.081485332, 0.073167353, -0.033630667, 0.20170289,
      0.68469343, 0.63846175, 0.068968176, -0.23197726, -0.10433598, },
    { 0.0, 0.0, 7.1344765e-8, -2.7818928e-8, -0.000002528456,
      0.0000018368197, 0.00026997937, -0.00013252441, -0.001740633, 0.0038067121,
      0.0093531772, -0.013821566, -0.0070879361, 0.084739015, 0.074159694,
      -0.040471924, 0.20317226, 0.70739793, 0.66214244, 0.072193371, },
    { 0.0, 0.0, -1.7745724e-7, 6.919457e-8, 0.0000079212679,
      -0.0000052051852, -0.00011186159, 0.00013087209, 0.0010011907, -0.0014292895,
      -0.0047484872, 0.010485041, 0.016207683, -0.039758642, -0.022104737,
      0.14309317, 0.071659816, -0.21620638, 0.12174763, 0.95412469, },
    { 0.96811974, -0.066460839, -0.18990589, -0.12699724, 0.074900229,
      0.019365102, -0.0094028752, -0.0073225687, 0.0024846173, 0.001133314,
      -0.000066782094, -0.00017127018, -5.1701849e-12, -2.6883967e-12, 8.4434004e-13,
      4.5714433e-13, -2.0336233e-14, -4.8142821e-14, 0.0, 0.0, },
    { 0.070051015, -0.67622735, 0.69971496, -0.18987268, -0.023601022,
      -0.073694534, 0.076964926, 0.0049448517, -0.011660957, -0.0084153664,
      0.003416879, 0.0015114204, -0.000092440393, -0.00023707381, -7.8278594e-12,
      -3.4041849e-12, 2.1213123e-13, 5.424444e-13, 0.0, 0.0, },
    { -0.10400446, 0.23379783, 0.070139677, -0.63985915, 0.68278382,
      -0.20175657, -0.032740047, -0.072931763, 0.08122816, 0.006212184,
      -0.012650812, -0.0089459474, 0.0035507517, 0.0016049328, -0.000095625024,
      -0.00024524111, -5.4947649e-15, -1.3849329e-14, 0.0, 0.0, },
    { 0.020927727, -0.025453371, -0.10434942, 0.23188113, 0.068987354,
      -0.63810296, 0.68429767, -0.20162896, -0.033573142, -0.073133229,
      0.081437918, 0.006312788, -0.012688459, -0.00896836, 0.0035534757,
      0.0016078143, -0.000095677348, -0.0002453753, 0.0, 0.0, },
    { 0.0, 0.0, -0.001441696, 0.00056214971, 0.020948908,
      -0.025363333, -0.10427841, 0.23185026, 0.068925853, -0.63810466,
      0.68432625, -0.20162446, -0.033584819, -0.073127012, 0.081444767,
      0.0062889982, -0.012692356, -0.008907458, 0.0035730328, 0.001494756, },
    { 0.0, 0.0, -8.891553e-14, 3.465479e-14, -0.0014416744,
      0.00056214128, 0.020948423, -0.025362886, -0.10427345, 0.23184342,
      0.06889794, -0.63805105, 0.68441106, -0.20186695, -0.033718945,
      -0.072480772, 0.081576567, 0.0047896878, -0.012951761, -0.0055205304, },
    { 0.0, 0.0, 3.1384661e-12, -1.2236911e-12, -4.5712737e-11,
      5.5252991e-11, -0.0014413395, 0.00056201026, 0.020940121, -0.025355656,
      -0.10419478, 0.23172734, 0.068557589, -0.63726677, 0.68504332,
      -0.20430545, -0.034154654, -0.067051635, 0.082518833, -0.0074921348, },
    { 0.0, 0.0, 2.1591083e-13, -8.4449036e-14, 1.2247511e-13,
      2.5428931e-12, -3.0481069e-11, 2.2021003e-11, -0.0014310921, 0.00055801468,
      0.020774997, -0.025169051, -0.10308717, 0.22974304, 0.064648504,
      -0.62768798, 0.69288569, -0.23617203, -0.037952156, 0.0066274123, },
    { 0.0, 0.0, 6.0226175e-14, -2.3096046e-14, -7.8692048e-13,
      1.0072813e-12, 5.1344469e-12, -8.9372637e-12, -3.4167908e-11, 5.4327109e-11,
      -0.0014266369, 0.00055627748, 0.020644778, -0.025065139, -0.10169917,
      0.22783, 0.058894795, -0.61350902, 0.69559873, -0.27013783, }
};

const double * const ff_on2avc_tabs_9_20_1[9] = {
    tabs_9_20[0], tabs_9_20[1], tabs_9_20[2], tabs_9_20[3], tabs_9_20[4],
    tabs_9_20[5], tabs_9_20[6], tabs_9_20[7], tabs_9_20[8]
};

const double * const ff_on2avc_tabs_9_20_2[9] = {
    tabs_9_20[ 9], tabs_9_20[10], tabs_9_20[11], tabs_9_20[12], tabs_9_20[13],
    tabs_9_20[14], tabs_9_20[15], tabs_9_20[16], tabs_9_20[17]
};

static const double tabs_19_40[19 * 2][40] = {
    { 0.56930638, 0.68416675, 0.20290636, -0.29270057, -0.25598083, 0.030953821, 0.11394564, 0.022880839,
      -0.028207704, -0.012215512, 0.003721839, 0.003276676, 0.00026276625, -0.00056233677, -0.00035737156, 0.000045825146,
      0.00015152336, 0.000014158357, -0.000048183036, -0.000010022261, 0.000012417808, 0.0000037410435, -0.0000026072561, -0.000001014039,
      4.4228357e-7, 2.1030097e-7, -5.993645000000001e-8, -3.3779106e-8, 6.3845155e-9, 4.1681669e-9, -5.2093484e-10, -3.8565026e-10,
      3.1069535e-11, 2.5581578e-11, -1.2377426e-12, -1.114565e-12, 2.5948758e-14, 2.4949169e-14, 0.0, 0.0, },
    { 0.083936735, 0.17821863, 0.5557409800000001, 0.66602779, 0.18178906, -0.30696561, -0.25275335, 0.044259687,
      0.11887063, 0.016608155, -0.032850108, -0.009887007200000001, 0.0065059949, 0.0025768587, -0.001107713, -0.00043230142,
      0.00021702341, 0.00006287448900000001, -0.000052147048, -0.000013629236, 0.000012262655, 0.0000039527411, -0.0000024594151, -9.9628076e-7,
      4.0201906e-7, 1.9618194e-7, -5.2873852e-8, -3.0291222e-8, 5.4982857e-9, 3.6241851e-9, -4.4014692e-10, -3.274108e-10,
      2.5877833e-11, 2.1342274e-11, -1.021061e-12, -9.1957797e-13, 2.1361163e-14, 2.0538295e-14, 0.0, 0.0, },
    { 0.06426235399999999, 0.14252447, 0.08331282299999999, 0.17697664, 0.54915213, 0.65833374, 0.18253037, -0.29973661,
      -0.2501844, 0.040186639, 0.1162191, 0.01848039, -0.030986232, -0.010520451, 0.0054986371, 0.0027059342,
      -0.00066811525, -0.00042405191, 0.000058970897, 0.000041824657, -0.0000050297476, -0.0000027888321, 6.4141372e-7, 2.6119558e-7,
      -1.0436111e-7, -5.1153743e-8, 1.3625299e-8, 7.8592626e-9, -1.3937291e-9, -9.315507e-10, 1.0721353e-10, 8.1948407e-11,
      -5.7676714e-12, -4.9562407e-12, 1.8554768e-13, 1.7299401e-13, -1.8580814e-15, -1.786505e-15, 0.0, 0.0, },
    { -0.013307048, -0.033975901, 0.06420919899999999, 0.14239611, 0.083308942, 0.17697702, 0.54882206, 0.65796781,
      0.18278485, -0.29910579, -0.25007544, 0.039720818, 0.11595345, 0.018673713, -0.030787294, -0.010566866,
      0.0054007477, 0.002707498, -0.0006312670199999999, -0.00041960532, 0.000047781271, 0.000039310002, -0.0000022421464, -0.0000019114661,
      7.288871400000001e-8, 3.3940173e-8, -1.0341206e-8, -5.5262517e-9, 1.2264303e-9, 7.3318115e-10, -1.205231e-10, -7.999549799999999e-11,
      9.360987e-12, 7.031617e-12, -5.2275601e-13, -4.536133e-13, 1.6843252e-14, 1.6194422e-14, 0.0, 0.0, },
    { 0.0018985257, 0.020620645, -0.013303786, -0.033963287, 0.064192393, 0.14235646, 0.08330606, 0.176973,
      0.5487176499999999, 0.65785432, 0.1828607, -0.29890778, -0.25001974, 0.039603104, 0.11587197, 0.018712544,
      -0.030736214, -0.010572356, 0.0053789802, 0.002705838, -0.00062416865, -0.00041818516, 0.000045935153, 0.000038762853,
      -0.0000018498967, -0.0000017627229, 4.1333815e-9, 2.700156e-9, -3.0391538e-10, -2.6291895e-10, 7.6542367e-12, 1.2019785e-11,
      9.0469833e-13, 5.0485213e-13, -1.0391267e-13, -9.305248e-14, 2.356875e-15, 2.2660843e-15, 0.0, 0.0, },
    { -0.0001091778, -0.010561339, 0.0018984228, 0.020619062, -0.013302974, -0.033960505, 0.064188298, 0.14234701,
      0.08330394300000001, 0.17696883, 0.54868941, 0.6578225599999999, 0.18287011, -0.29886826, -0.25000476, 0.039583069,
      0.11585553, 0.018717708, -0.030727247, -0.010572428, 0.0053756484, 0.0027053082, -0.0006232358500000001, -0.00041792434,
      0.000045731688, 0.000038685285, -0.0000018149671, -0.0000017460375, -5.167502e-10, 9.390694299999999e-12, 1.594319e-10, 5.8184529e-11,
      -2.4161347e-11, -1.4454629e-11, 2.1037566e-12, 1.7321615e-12, -9.986456699999999e-14, -9.6017617e-14, 0.0, 0.0, },
    { -0.0005767410599999999, 0.0035190291, -0.00010917955, -0.010561258, 0.0018984108, 0.020618888, -0.013302882, -0.033960202,
      0.064187838, 0.14234596, 0.083303668, 0.17696827, 0.54868618, 0.65781893, 0.18287097, -0.298864,
      -0.25000294, 0.039581151, 0.11585376, 0.018718064, -0.03072639, -0.010572378, 0.0053753363, 0.0027052073,
      -0.00062317825, -0.00041788417, 0.000045733074, 0.000038677454, -0.0000018196051, -0.0000017460967, 9.887897300000001e-10, 4.6848142e-10,
      -1.2195123e-10, -7.9561868e-11, 9.378916700000001e-12, 7.8791268e-12, -3.9130514e-13, -3.7623141e-13, 0.0, 0.0, },
    { 0.00030131631, -0.0010263444, -0.00057674065, 0.0035190268, -0.00010917966, -0.010561251, 0.0018984097, 0.020618873,
      -0.013302874, -0.033960176, 0.064187798, 0.14234586, 0.083303637, 0.17696821, 0.54868588, 0.65781858,
      0.182871, -0.29886366, -0.25000278, 0.039580995, 0.11585361, 0.018718039, -0.03072645, -0.010572511,
      0.0053752804, 0.0027052669, -0.00062312096, -0.00041789128, 0.000045707579, 0.000038673143, -0.0000018129216, -0.0000017437794,
      -1.7501699e-10, -1.1843802e-10, 1.2678547e-11, 1.0773126e-11, -4.8703456e-13, -4.6827318e-13, 0.0, 0.0, },
    { -0.000089637995, 0.00022613691, 0.0003013163, -0.0010263444, -0.00057674064, 0.0035190267, -0.00010917963, -0.010561251,
      0.0018984096, 0.020618873, -0.013302874, -0.033960176, 0.06418779600000001, 0.14234586, 0.083303635, 0.1769682,
      0.54868587, 0.65781858, 0.18287099, -0.29886369, -0.2500028, 0.039580943, 0.11585345, 0.018717863,
      -0.030726497, -0.010572431, 0.005375347, 0.002705256, -0.00062315197, -0.00041789626, 0.000045715815, 0.000038675974,
      -0.0000018143635, -0.0000017445048, -7.806062e-12, -6.3155567e-12, 4.0893858e-13, 3.9318559e-13, 0.0, 0.0, },
    { 0.000018826413, -0.000032248448, -0.000089637995, 0.00022613691, 0.0003013163, -0.0010263444, -0.00057674066, 0.0035190267,
      -0.00010917957, -0.010561251, 0.0018984095, 0.020618874, -0.013302874, -0.033960178, 0.06418779600000001, 0.14234587,
      0.083303632, 0.17696819, 0.54868589, 0.65781861, 0.18287101, -0.29886365, -0.25000267, 0.039581091,
      0.11585349, 0.018717796, -0.030726553, -0.010572422, 0.0053753731, 0.0027052603, -0.00062315889, -0.00041789864,
      0.000045717027, 0.000038676583, -0.0000018145039, -0.0000017445989, 2.4971934e-12, 2.4009973e-12, 0.0, 0.0, },
    { -0.0000023940844, 0.0000029119687, 0.00001882641, -0.000032248444, -0.000089637969, 0.00022613687, 0.00030131618, -0.0010263441,
      -0.00057674024, 0.0035190253, -0.00010918036, -0.010561246, 0.0018984093, 0.020618859, -0.013302871, -0.03396015,
      0.064187778, 0.14234582, 0.08330372, 0.17696839, 0.548686, 0.65781885, 0.18287176, -0.29886274,
      -0.25000242, 0.03958068, 0.11585315, 0.01871785, -0.030726394, -0.010572396, 0.0053753308, 0.0027052457,
      -0.00062315149, -0.00041789492, 0.000045716169, 0.000038676008, -0.000001814441, -0.0000017445457, 0.0, 0.0, },
    { 0.0, 0.0, 1.3407205e-7, -1.3944369e-7, -0.0000023940844, 0.0000029119687, 0.00001882641, -0.000032248444,
      -0.000089637969, 0.00022613687, 0.00030131618, -0.0010263441, -0.00057674024, 0.0035190253, -0.00010918036, -0.010561246,
      0.0018984093, 0.020618859, -0.013302871, -0.03396015, 0.064187778, 0.14234582, 0.08330372, 0.17696839,
      0.548686, 0.65781885, 0.18287176, -0.29886274, -0.25000242, 0.03958068, 0.11585315, 0.01871785,
      -0.030726394, -0.010572396, 0.0053753308, 0.0027052457, -0.00062315149, -0.00041789492, 0.000045716169, 0.000038676008, },
    { 0.0, 0.0, -1.8454182e-13, 1.9193555e-13, 1.3407535e-7, -1.394477e-7, -0.0000023941103, 0.0000029120131,
      0.000018826533, -0.000032248755, -0.000089638384, 0.00022613828, 0.00030131697, -0.0010263489, -0.00057674009, 0.0035190398,
      -0.00010918297, -0.010561274, 0.0018984276, 0.020618906, -0.013302959, -0.033960346, 0.06418766400000001, 0.14234558,
      0.08330296500000001, 0.17696749, 0.54868575, 0.65781926, 0.1828721, -0.2988628, -0.25000258, 0.039580654,
      0.11585319, 0.018717865, -0.030726402, -0.0105724, 0.0053753317, 0.0027052463, -0.00062315156, -0.00041789497, },
    { 0.0, 0.0, -2.9968756e-14, 3.1169464e-14, 3.4461485e-13, -4.5274253e-13, 1.3407128e-7, -1.3944066e-7,
      -0.0000023940918, 0.0000029119648, 0.000018826475, -0.000032248545, -0.000089638294, 0.00022613761, 0.00030131711, -0.001026347,
      -0.00057674067, 0.0035190367, -0.00010918012, -0.010561271, 0.0018984144, 0.020618881, -0.013302985, -0.033960402,
      0.06418755499999999, 0.14234546, 0.083302923, 0.17696757, 0.54868595, 0.65781945, 0.18287214, -0.29886289,
      -0.25000265, 0.039580667, 0.11585323, 0.01871787, -0.03072641, -0.010572403, 0.0053753332, 0.0027052471, },
    { 0.0, 0.0, 3.4053947e-14, -3.541833e-14, -5.9108424e-13, 7.219441e-13, 3.686965e-12, -6.9987332e-12,
      1.3406826e-7, -1.3941009e-7, -0.0000023941744, 0.0000029119806, 0.000018827177, -0.000032249608, -0.000089641497, 0.00022614485,
      0.00030132559, -0.0010263798, -0.00057675334, 0.0035191463, -0.00010917896, -0.01056153, 0.001898552, 0.020619502,
      -0.013303345, -0.033961425, 0.06418858299999999, 0.1423474, 0.083301974, 0.17696773, 0.54869501, 0.65783272,
      0.18287661, -0.29886847, -0.2500077, 0.039581297, 0.11585546, 0.018718257, -0.030726991, -0.010572606, },
    { 0.0, 0.0, 3.8851186e-14, -4.0407771e-14, -9.0297499e-13, 1.0614292e-12, 1.2369841e-11, -1.7194763e-11,
      -1.3889432e-10, 2.127443e-10, 1.3529716e-7, -1.415165e-7, -0.000002401917, 0.0000029279859, 0.000018862624, -0.000032344139,
      -0.00008976013300000001, 0.00022657145, 0.00030158676, -0.0010279007, -0.00057694943, 0.0035236425, -0.00011001072, -0.010572116,
      0.0019036557, 0.020640207, -0.013321797, -0.034004076, 0.064218883, 0.14240437, 0.083244411, 0.17692659,
      0.54894337, 0.65823916, 0.1830245, -0.29903361, -0.250163, 0.039598328, 0.11592277, 0.018730262, },
    { 0.0, 0.0, -2.5424375e-14, 2.6443011e-14, 1.3072139e-12, -1.4396059e-12, -2.9838328e-11, 3.6121355e-11,
      4.2808479e-10, -5.8577848e-10, -4.3953309e-9, 6.8915491e-9, 1.6727789e-7, -2.00599e-7, -0.0000025787194, 0.0000033304637,
      0.000019584144, -0.000034476114, -0.00009189714, 0.00023541633, 0.00030555578, -0.0010574794, -0.000577822, 0.0036058258,
      -0.00013178926, -0.010757609, 0.0020075294, 0.020999334, -0.013644546, -0.03471548, 0.0647074, 0.14319792,
      0.081890324, 0.17546099, 0.55189921, 0.66398787, 0.18532974, -0.30125552, -0.25236809, 0.039796138, },
    { 0.0, 0.0, 5.450404e-14, -5.6687762e-14, -2.413723e-12, 2.68197e-12, 5.4122889e-11, -6.597469100000001e-11,
      -7.9689529e-10, 1.0842539e-9, 8.4827594e-9, -1.309149e-8, -6.848642999999999e-8, 1.2194237e-7, 5.5864479e-7, -0.0000010344816,
      -0.0000044039463, 0.0000081482122, 0.000025993389, -0.000056794375, -0.0001079834, 0.00031887419, 0.00032752081, -0.0013147952,
      -0.00055367277, 0.0042710356, -0.00037367267, -0.01217995, 0.0029410132, 0.023714229, -0.016091617, -0.03973309,
      0.068419296, 0.14835553, 0.070059102, 0.15950508, 0.56354819, 0.6963379, 0.20020752, -0.31277075, },
    { 0.0, 0.0, 2.0986643e-14, -2.1827479e-14, -6.2317928e-13, 7.1419835e-13, 4.9978335e-12, -7.9628623e-12,
      6.4574499e-11, -3.0391734e-11, -2.093182e-9, 2.2676782e-9, 2.7596774e-8, -3.8208137e-8, -2.3879395e-7, 4.0380176e-7,
      0.0000016333254, -0.0000032376466, -0.0000094150001, 0.000021168371, 0.000043315086, -0.00011711363, -0.0001502271, 0.0005427171400000001,
      0.00038159158, -0.0019974544, -0.0004777833, 0.0060120078, -0.0010436508, -0.015880165, 0.0054219755, 0.030749996,
      -0.022330626, -0.052220715, 0.07871199800000001, 0.16235935, 0.039966293, 0.11703729, 0.58925396, 0.77487668, },
    { 0.76082901, -0.61501045, 0.070732318, -0.076233884, 0.16721565, -0.04604786, -0.038872216, 0.0073908504,
      0.018642214, -0.00059960166, -0.009041801, 0.000017181816, 0.0029672586, 0.0004791856, -0.00087051626, -0.0002528999,
      0.00019443347, 0.00007609031299999999, -0.000028013417, -0.000016226544, 0.0000025515355, 0.0000020939308, -1.2352758e-7, -1.1871399e-7,
      3.7653573e-11, -5.1553467e-12, -1.2189794e-11, -1.0694795e-12, 4.391544e-12, 1.0258575e-12, -1.1546382e-12, -3.8647265e-13,
      1.8127896e-13, 1.0023162e-13, -1.7537934e-14, -1.43414e-14, 8.6649097e-16, 8.3311729e-16, 0.0, 0.0, },
    { -0.29020148, -0.17058579, 0.73009051, -0.54522599, 0.15148724, -0.089863731, 0.14246903, -0.057880136,
      -0.032908729, 0.011933145, 0.019248716, -0.001642844, -0.009891541, 0.00011758938, 0.0032933357, 0.00053302425,
      -0.00096384007, -0.00028170914, 0.00021364396, 0.000084221396, -0.000030604054, -0.000017803479, 0.0000027741657, 0.0000022790848,
      -1.3343692e-7, -1.2837358e-7, -2.8291166e-11, -4.5113932e-12, 9.653859800000001e-12, 2.5188373e-12, -1.9411097e-12, -8.4860379e-13,
      2.4055653e-13, 1.6608885e-13, -1.7834093e-14, -1.5689603e-14, 5.0113872e-16, 4.818492e-16, 0.0, 0.0, },
    { 0.029507585, 0.23915664, -0.31374537, -0.19147782, 0.66761054, -0.54476742, 0.17718214, -0.085893937,
      0.14081423, -0.0629847, -0.033056336, 0.013055001, 0.020096625, -0.0018682292, -0.010351996, 0.00012827752,
      0.0034538681, 0.00056125575, -0.0010101514, -0.00029566086, 0.00022323168, 0.00008825740999999999, -0.000031896814, -0.000018596176,
      0.0000028845736, 0.0000023710501, -1.3832474e-7, -1.3304067e-7, -1.7294869e-11, -2.81197e-12, 6.3974866e-12, 1.5855057e-12,
      -1.1972211e-12, -5.6338465e-13, 1.3134602e-13, 1.0379039e-13, -7.732033400000001e-15, -7.434189599999999e-15, 0.0, 0.0, },
    { 0.02137026, -0.11253601, 0.042589994, 0.25148145, -0.29992597, -0.18470705, 0.65790258, -0.54797686,
      0.17746938, -0.083682167, 0.14200727, -0.064059583, -0.033780176, 0.013281042, 0.020536256, -0.0019008618,
      -0.010532156, 0.00011385908, 0.0035109303, 0.00057440761, -0.0010245672, -0.0003006148, 0.00022585476, 0.00008948980099999999,
      -0.000032218587, -0.000018804752, 0.0000029102318, 0.0000023922344, -1.3952226e-7, -1.3403637e-7, 3.9608302e-11, 1.3905461e-11,
      -6.1363765e-12, -3.3840174e-12, 5.9012281e-13, 4.7995226e-13, -3.0052643e-14, -2.8894955e-14, 0.0, 0.0, },
    { -0.01101232, 0.030164564, 0.018237721, -0.11605179, 0.039730974, 0.25027003, -0.29882164, -0.18303474,
      0.65775001, -0.54862086, 0.17703165, -0.083330352, 0.1423101, -0.064180839, -0.033943639, 0.013302586,
      0.020612508, -0.0018991492, -0.010559265, 0.00010961366, 0.003518543, 0.00057658118, -0.0010262483, -0.00030127666,
      0.00022612153, 0.000089630847, -0.000032246277, -0.000018825371, 0.0000029116033, 0.0000023939368, -1.3937709e-7, -1.3404451e-7,
      -9.1223008e-12, -5.4094957e-12, 8.1321806e-13, 6.7296866e-13, -3.7437071e-14, -3.5994924e-14, 0.0, 0.0, },
    { 0.0027523866, -0.0053151929, -0.010522001, 0.030746051, 0.018701664, -0.11588024, 0.039576589, 0.25001961,
      -0.29885452, -0.18288052, 0.65781266, -0.54868261, 0.1769717, -0.08330388900000001, 0.14234344, -0.064187437,
      -0.03395959, 0.013303046, 0.020618614, -0.0018984637, -0.010561198, 0.00010920031, 0.0035190207, 0.00057673481,
      -0.0010263442, -0.00030131581, 0.00022613719, 0.000089638071, -0.000032248498, -0.000018826446, 0.0000029119606, 0.0000023940888,
      -1.3944039e-7, -1.3407106e-7, -4.6440655e-13, -3.5507487e-13, 3.1428853e-14, 3.0218153e-14, 0.0, 0.0, },
    { -0.000421003, 0.00061919433, 0.0027019638, -0.0053765775, -0.010571322, 0.030728141, 0.018718075, -0.11585434,
      0.039580128, 0.25000318, -0.29886234, -0.18287235, 0.6578189800000001, -0.54868567, 0.17696763, -0.083302976,
      0.14234552, -0.064187667, -0.033960326, 0.013302963, 0.0206189, -0.0018984291, -0.010561273, 0.00010918342,
      0.0035190396, 0.00057673999, -0.0010263489, -0.00030131696, 0.00022613828, 0.000089638382, -0.000032248755, -0.000018826533,
      0.0000029120131, 0.0000023941103, -1.394477e-7, -1.3407534e-7, 1.9191457e-13, 1.8452165e-13, 0.0, 0.0, },
    { 0.000038791283, -0.000045569699, -0.00041777535, 0.00062319501, 0.0027052056, -0.005375393, -0.010572402, 0.030726437,
      0.018717868, -0.11585317, 0.039580663, 0.25000243, -0.29886273, -0.18287176, 0.65781885, -0.548686,
      0.17696839, -0.08330372, 0.14234582, -0.064187778, -0.03396015, 0.013302871, 0.020618859, -0.0018984093,
      -0.010561246, 0.00010918036, 0.0035190253, 0.00057674024, -0.0010263441, -0.00030131618, 0.00022613687, 0.000089637969,
      -0.000032248444, -0.00001882641, 0.0000029119687, 0.0000023940844, -1.3944369e-7, -1.3407205e-7, 0.0, 0.0, },
    { 0.0, 0.0, -0.0000017445457, 0.000001814441, 0.000038676008, -0.000045716169, -0.00041789492, 0.00062315149,
      0.0027052457, -0.0053753308, -0.010572396, 0.030726394, 0.01871785, -0.11585315, 0.03958068, 0.25000242,
      -0.29886274, -0.18287176, 0.65781885, -0.548686, 0.17696839, -0.08330372, 0.14234582, -0.064187778,
      -0.03396015, 0.013302872, 0.020618859, -0.0018984103, -0.010561245, 0.00010918227, 0.0035190235, 0.0005767369100000001,
      -0.0010263409, -0.00030131137, 0.00022613101, 0.000089630778, -0.000032235242, -0.000018797134, 0.0000029311054, 0.0000023933095, },
    { 0.0, 0.0, 2.400996e-12, -2.497192e-12, -0.0000017445989, 0.0000018145039, 0.000038676583, -0.000045717027,
      -0.00041789864, 0.00062315889, 0.0027052603, -0.0053753731, -0.010572422, 0.030726553, 0.018717796, -0.11585349,
      0.039581091, 0.25000267, -0.29886365, -0.182871, 0.65781861, -0.54868589, 0.17696819, -0.083303628,
      0.14234587, -0.064187807, -0.033960174, 0.013302897, 0.020618859, -0.0018984526, -0.010561213, 0.00010925545,
      0.0035189544, 0.0005766278600000001, -0.0010262111, -0.00030114598, 0.00022584654, 0.00008902247699999999, -0.000032552144, -0.000018664449, },
    { 0.0, 0.0, 3.9319783e-13, -4.0895132e-13, -6.3160719e-12, 7.8066363e-12, -0.0000017445047, 0.0000018143635,
      0.000038675973, -0.000045715815, -0.00041789626, 0.00062315196, 0.002705256, -0.005375347, -0.010572431, 0.030726497,
      0.018717863, -0.11585345, 0.039580944, 0.25000279, -0.29886369, -0.18287097, 0.65781858, -0.54868592,
      0.1769682, -0.083303514, 0.14234582, -0.064188067, -0.033960018, 0.013303399, 0.020618438, -0.0018993478,
      -0.010560376, 0.0001106233, 0.0035173821, 0.0005745302, -0.0010229283, -0.00029453156, 0.00022779928, 0.000085362615, },
    { 0.0, 0.0, -4.6834912e-13, 4.8711355e-13, 1.0776346e-11, -1.2682135e-11, -1.1850617e-10, 1.751009e-10,
      -0.0000017437784, 0.0000018129203, 0.000038673133, -0.000045707564, -0.00041789121, 0.0006231208299999999, 0.0027052664, -0.0053752795,
      -0.010572509, 0.030726445, 0.018718032, -0.11585358, 0.039581016, 0.25000268, -0.2988637, -0.18287068,
      0.65781858, -0.54868677, 0.17696847, -0.08330162200000001, 0.14234476, -0.064191787, -0.033957024, 0.013310076,
      0.020612258, -0.0019097554, -0.010548644, 0.00012671842, 0.0034937666, 0.00052913399, -0.0010278304, -0.00025627314, },
    { 0.0, 0.0, -3.7591141e-13, 3.9097232e-13, 7.8654833e-12, -9.3637194e-12, -7.9270845e-11, 1.2159335e-10,
      4.6441491e-10, -9.8316498e-10, -0.0000017460554, 0.00000181954, 0.000038677134, -0.000045732491, -0.00041788222, 0.00062317407,
      0.0027051979, -0.0053753121, -0.010572343, 0.030726274, 0.018717964, -0.1158533, 0.039581338, 0.25000143,
      -0.29886407, -0.1828668, 0.65781782, -0.54869588, 0.17697338, -0.083284289, 0.14233111, -0.06422307200000001,
      -0.033928145, 0.013359197, 0.020557279, -0.0019859605, -0.010440679, 0.00032845982, 0.0034922164, 0.00031950723, },
    { 0.0, 0.0, -9.7008176e-14, 1.0089481e-13, 1.77473e-12, -2.1511483e-12, -1.5372262e-11, 2.5287645e-11,
      7.115903100000001e-11, -1.77311e-10, -1.2348213e-10, 7.2542972e-10, -0.0000017450016, 0.0000018130844, 0.000038678971, -0.00004571817,
      -0.00041789388, 0.00062315711, 0.0027051921, -0.0053752707, -0.010572087, 0.030725736, 0.018717011, -0.11585044,
      0.03958358, 0.24999022, -0.29886524, -0.18283501, 0.65780555, -0.5487611999999999, 0.17702181, -0.083173702,
      0.14222973, -0.064399687, -0.033732817, 0.01363355, 0.020184552, -0.0026582356, -0.010334243, 0.0011989638, },
    { 0.0, 0.0, 4.8096417e-15, -5.0023409e-15, -2.0363605e-13, 2.2693214e-13, 2.9268545e-12, -3.8691566e-12,
      -2.2830499e-11, 4.010721e-11, 1.0030539e-10, -2.6202135e-10, -1.750769e-10, 1.0448174e-9, -0.0000017449923, 0.000001812272,
      0.000038676696, -0.00004571407, -0.0004178554, 0.00062310242, 0.0027048621, -0.0053746982, -0.010570284, 0.03072167,
      0.018710471, -0.11582959, 0.039596876, 0.24991347, -0.29886368, -0.18263206, 0.65769914, -0.54914259,
      0.17734742, -0.082618805, 0.14162772, -0.06527709199999999, -0.032607813, 0.015574165, 0.01947389, -0.0058478027, },
    { 0.0, 0.0, 1.1620773e-14, -1.2086359e-14, -2.5281225e-13, 2.9951516e-13, 2.5798868e-12, -3.9238172e-12,
      -1.5091708e-11, 3.1934537e-11, 4.7586293e-11, -1.6454863e-10, -2.4363315e-11, 5.0961544e-10, -4.3869198e-10, -6.2033089e-10,
      -0.0000017425281, 0.0000018129976, 0.000038659328, -0.000045695417, -0.00041768461, 0.00062286511, 0.0027034675, -0.0053722734,
      -0.010562778, 0.030704525, 0.018683973, -0.1157433, 0.039644886, 0.24960502, -0.29882338, -0.18185802,
      0.65720216, -0.55036798, 0.17856616, -0.080914163, 0.13954371, -0.06882522000000001, -0.030723701, 0.022700612, },
    { 0.0, 0.0, 3.3760298e-15, -3.5112922e-15, -6.3206989e-14, 7.636481800000001e-14, 5.5558903e-13, -9.0603035e-13,
      -2.6533985e-12, 6.4749011e-12, 5.3634022e-12, -2.7507239e-11, 1.1363474e-11, 5.960222e-11, -1.0091373e-10, 2.5808497e-11,
      1.3953072e-10, -2.6651685e-10, -0.000001742256, 0.0000018124516, 0.000038611107, -0.000045640594, -0.00041703113, 0.00062197544,
      0.0026981501, -0.0053630599, -0.010535085, 0.030640024, 0.018595029, -0.11543077, 0.039765416, 0.24856666,
      -0.29852909, -0.17958773, 0.6555599600000001, -0.5538587699999999, 0.18206628, -0.07570165600000001, 0.13430764, -0.08408151899999999, },
    { 0.0, 0.0, 5.9918017e-16, -6.2318032e-16, -9.9379759e-15, 1.2221683e-14, 8.0845727e-14, -1.3829585e-13,
      -3.7650038e-13, 9.459626799999999e-13, 9.869205499999999e-13, -4.1121055e-12, -1.1120552e-12, 1.2402418e-11, -2.0576524e-12, -2.6724353e-11,
      1.4957979e-12, 9.137734800000001e-11, -1.5845915e-9, 1.4784326e-9, -0.0000016861848, 0.0000017493852, 0.000037821856, -0.000044585784,
      -0.00041031894, 0.00061056275, 0.0026598482, -0.0052790669, -0.010386803, 0.030195423, 0.018217984, -0.11365566,
      0.040288546, 0.24321245, -0.29862004, -0.16484799, 0.64946229, -0.58650413, 0.20634045, -0.014365476, },
    { 0.0, 0.0, 6.6467568e-17, -6.912305e-17, -6.2475603e-16, 8.5867071e-16, 8.7357039e-16, -5.4126396e-15,
      2.2202664e-14, -5.4492598e-15, -1.70592e-13, 2.8319481e-13, 6.331548e-13, -1.7748409e-12, -1.7196603e-12, 6.8530479e-12,
      2.0919589e-12, -1.9194583e-11, -1.3868107e-8, 1.4507548e-8, 2.4548427e-7, -2.9905628e-7, -0.0000035971494, 0.0000050451109,
      0.00004672424, -0.000067456818, -0.00044153822, 0.00071430062, 0.0027532286, -0.0056688462, -0.010727074, 0.031800916,
      0.019871848, -0.11989559, 0.036659135, 0.26632201, -0.3057397, -0.23220335, 0.68741352, -0.54024027, }
};

const double * const ff_on2avc_tabs_19_40_1[19] = {
    tabs_19_40[ 0], tabs_19_40[ 1], tabs_19_40[ 2], tabs_19_40[ 3],
    tabs_19_40[ 4], tabs_19_40[ 5], tabs_19_40[ 6], tabs_19_40[ 7],
    tabs_19_40[ 8], tabs_19_40[ 9], tabs_19_40[10], tabs_19_40[11],
    tabs_19_40[12], tabs_19_40[13], tabs_19_40[14], tabs_19_40[15],
    tabs_19_40[16], tabs_19_40[17], tabs_19_40[18],
};

const double * const ff_on2avc_tabs_19_40_2[19] = {
    tabs_19_40[19], tabs_19_40[20], tabs_19_40[21], tabs_19_40[22],
    tabs_19_40[23], tabs_19_40[24], tabs_19_40[25], tabs_19_40[26],
    tabs_19_40[27], tabs_19_40[28], tabs_19_40[29], tabs_19_40[30],
    tabs_19_40[31], tabs_19_40[32], tabs_19_40[33], tabs_19_40[34],
    tabs_19_40[35], tabs_19_40[36], tabs_19_40[37],
};

static const double tabs_20_84[20 * 4][84] = {
    { -0.10690582, 0.094662183, 0.31757963, 0.48370235, 0.53678916, 0.46705598, 0.31621123, 0.15326227,
      0.038302765, -0.0054998811, 0.0073520352, 0.043879657, 0.067374408, 0.060077687, 0.027405389, -0.009983873000000001,
      -0.032034985, -0.033515334, -0.017328881, -0.0009890252300000001, 0.0060597434, 0.0056072468, 0.002571725, -0.0007936099700000001,
      -0.0027018322, -0.0027530703, -0.0014845177, 0.000064203217, 0.0010169666, 0.0011425746, 0.0006388587, -0.0000018624399,
      -0.0003856745, -0.00043471053, -0.00023808948, -0.0000010996843, 0.00013049299, 0.00014628934, 0.00008690307399999999, 0.000020136779,
      -0.00001317216, -0.000017142035, -0.0000073231078, 0.0000027043389, 0.0000059557329, 0.0000045096238, 0.0000020887956, 1.9940697e-7,
      -5.9358256e-7, -7.422066799999999e-7, -7.3570645e-7, -7.3115553e-7, -7.2933999e-7, -6.8435909e-7, -5.0707974e-7, -3.8679328e-7,
      -3.4522208e-7, -2.8271694e-7, -1.3713424e-7, 8.1184249e-9, 9.007577e-8, 1.0329366e-7, 6.463027099999999e-8, 2.1860912e-8,
      5.1066896e-10, -2.670761e-9, -8.5876196e-10, 4.9520519e-9, 1.0149098e-8, 1.0748594e-8, 5.7620398e-9, 1.747266e-12,
      -3.1210565e-9, -3.4682633e-9, -1.969792e-9, -4.3451013e-10, 2.1837603e-10, 2.5217949e-10, 1.4564222e-10, 3.9900967e-11,
      0.0, 0.0, 0.0, 0.0, },
    { -0.0065157518, -0.11553191, -0.2003235, -0.20418917, -0.10172818, 0.084274311, 0.29189952, 0.4498939,
      0.5060534800000001, 0.44955248, 0.316223, 0.16751007, 0.057934971, 0.009822325, 0.01258206, 0.039193775,
      0.05803246, 0.052804012, 0.026596935, -0.0041283092, -0.023092596, -0.026167999, -0.014874145, -0.0035171769,
      0.0010177737, 0.0010448012, 0.00056458234, -0.00002147272, -0.00037997699, -0.00042776572, -0.00024136656, -0.0000050238535,
      0.0001358557, 0.00015438052, 0.000084239467, -1.6787043e-7, -0.000046506822, -0.000051573195, -0.00003026341, -0.0000066056329,
      0.0000050707828, 0.0000063933192, 0.0000029272058, -5.6899116e-7, -0.0000017091248, -0.000001263969, -5.570908e-7, -1.1465662e-8,
      2.1544169e-7, 2.5116122e-7, 2.3708156e-7, 2.2251093e-7, 2.1287918e-7, 1.9828806e-7, 1.5178343e-7, 1.2339394e-7,
      1.1450823e-7, 9.427839099999999e-8, 4.5909852e-8, -2.8333617e-9, -3.0612544e-8, -3.510426e-8, -2.1859204e-8, -6.9884918e-9,
      6.0182974e-10, 1.7346196e-9, 7.5210778e-10, -1.6045901e-9, -3.5459042e-9, -3.7642404e-9, -2.0232963e-9, -2.1548766e-11,
      1.0548306e-9, 1.1724849e-9, 6.6598834e-10, 1.4716004e-10, -7.3310163e-11, -8.4658191e-11, -4.8892981e-11, -1.3394998e-11,
      0.0, 0.0, 0.0, 0.0, },
    { 0.009584246100000001, 0.060037953, 0.08995716600000001, 0.07015256, -0.0064981541, -0.11412419, -0.19788136, -0.20183985,
      -0.10090064, 0.082591928, 0.28777272, 0.44450316, 0.50121997, 0.44689528, 0.31636017, 0.16979842,
      0.060835882, 0.011721646, 0.012592987, 0.037481155, 0.055630623, 0.050971284, 0.026138847, -0.0031939983,
      -0.021447285, -0.024707738, -0.014251364, -0.0038152781, 0.00019304198, 0.00021786771, 0.00012308297, 0.0000035156435,
      -0.000067129672, -0.000076387194, -0.000041781791, -4.7347618e-7, 0.000021885498, 0.000024212644, 0.000014093384, 0.0000029734778,
      -0.0000024267734, -0.0000029909187, -0.0000014079434, 1.6425532e-7, 6.695171e-7, 4.7998271e-7, 2.0415765e-7, -5.5631332e-10,
      -8.1446112e-8, -9.140500800000001e-8, -8.6951648e-8, -8.2795203e-8, -7.961575299999999e-8, -7.5512625e-8, -6.0512776e-8, -5.3113926e-8,
      -5.1924925e-8, -4.3533669e-8, -2.1569411e-8, 9.781164100000001e-10, 1.3993484e-8, 1.6121335e-8, 9.9502597e-9, 2.8301122e-9,
      -9.3071063e-10, -1.4828863e-9, -7.242862e-10, 6.7853969e-10, 1.7198254e-9, 1.833935e-9, 9.910411099999999e-10, 3.1189792e-11,
      -4.7625005e-10, -5.2977179e-10, -3.0102006e-10, -6.6842961e-11, 3.2454035e-11, 3.7477749e-11, 2.1644673e-11, 5.9298973e-12,
      0.0, 0.0, 0.0, 0.0, },
    { 0.01136632, -0.016408158, -0.0349332, -0.02784739, 0.0096145776, 0.059932587, 0.089753479, 0.069975671,
      -0.0064946134, -0.11385923, -0.19742994, -0.20142361, -0.10079378, 0.08221251, 0.28695123, 0.44351114,
      0.50044723, 0.44666598, 0.31676682, 0.17065633, 0.061771278, 0.012354413, 0.012717225, 0.037140244,
      0.05507189, 0.050498426, 0.025957566, -0.0030533473, -0.02111719, -0.024381244, -0.01407801, -0.0038307086,
      0.000057284264, 0.000064716373, 0.000035447225, 3.3642675e-7, -0.000018979267, -0.000021222982, -0.000012582227, -0.0000029191463,
      0.0000018740006, 0.0000024460463, 0.0000010713877, -3.2487878e-7, -7.6781933e-7, -5.6583195e-7, -2.5068165e-7, -1.2347619e-8,
      8.297339600000001e-8, 9.823114000000001e-8, 9.7588203e-8, 9.926988499999999e-8, 1.0070428e-7, 9.5071923e-8, 7.044354799999999e-8, 5.3494703e-8,
      4.7613879e-8, 3.8919429e-8, 1.8845507e-8, -1.4101785e-9, -1.3040795e-8, -1.4945684e-8, -9.300971000000001e-9, -2.9841161e-9,
      2.2386009e-10, 6.990386e-10, 2.9986977e-10, -6.7535232e-10, -1.4832646e-9, -1.5740818e-9, -8.4577404e-10, -7.8396292e-12,
      4.4323404e-10, 4.9265612e-10, 2.7983182e-10, 6.1820257e-11, -3.0829599e-11, -3.5601859e-11, -2.0561283e-11, -5.6330855e-12,
      0.0, 0.0, 0.0, 0.0, },
    { -0.015370512, 0.0038188528, 0.022815308, 0.027466485, 0.011338678, -0.016392314, -0.034877413, -0.027788336,
      0.009626457999999999, 0.059869085, 0.089638544, 0.06987961299999999, -0.0064874855, -0.11370564, -0.19717232, -0.20118491,
      -0.10072609, 0.08200856400000001, 0.28649294, 0.44293937, 0.49997057, 0.44646556, 0.31690834, 0.17106178,
      0.062258998, 0.012728592, 0.012858441, 0.03704681, 0.054844697, 0.050274532, 0.025838622, -0.0030395781,
      -0.021015878, -0.024267531, -0.014014183, -0.0038334853, 0.000012294908, 0.000013971577, 0.0000084331492, 0.0000021207154,
      -0.0000010613403, -0.0000014692243, -5.674645600000001e-7, 3.6813259e-7, 6.6471952e-7, 5.0732461e-7, 2.3990309e-7, 3.2527713e-8,
      -5.2940032e-8, -7.0272097e-8, -7.4243847e-8, -8.004311e-8, -8.432345e-8, -7.9953609e-8, -5.7174812e-8, -4.0198391e-8,
      -3.3846855e-8, -2.7391787e-8, -1.3164822e-8, 9.3143613e-10, 8.8830013e-9, 1.0178346e-8, 6.3897086e-9, 2.2544123e-9,
      2.3155551e-10, -6.9016433e-11, 2.2668746e-11, 5.0194474e-10, 9.691114e-10, 1.0241351e-9, 5.4764968e-10, -5.1352834e-12,
      -3.0704315e-10, -3.4111839e-10, -1.9371648e-10, -4.2664063e-11, 2.1615536e-11, 2.4961507e-11, 1.4416119e-11, 3.9495215e-12,
      0.0, 0.0, 0.0, 0.0, },
    { 0.0075782552, 0.00056335562, -0.012867845, -0.020711565, -0.015362833, 0.0038178887, 0.022803262, 0.027450127,
      0.01132947, -0.016385813, -0.034857713, -0.027768817, 0.009628209800000001, 0.059844065, 0.08959629, 0.069845594,
      -0.0064833885, -0.11364823, -0.19707655, -0.20109459, -0.10069589, 0.08194085600000001, 0.28632947, 0.44272522,
      0.49977611, 0.44635552, 0.31691232, 0.17116302, 0.062405028, 0.012858212, 0.012929921, 0.037051865,
      0.054806207, 0.050228229, 0.025812903, -0.0030350316, -0.020990856, -0.02423998, -0.013999649, -0.0038354321,
      3.9449016e-7, 6.2546153e-7, 2.2880436e-7, -1.9648504e-7, -3.2799492e-7, -2.4605577e-7, -1.1018746e-7, -3.7855249e-9,
      4.0799542e-8, 4.9097347e-8, 4.6905093e-8, 4.6627152e-8, 4.7685199e-8, 4.451826e-8, 3.0728316e-8, 1.9838579e-8,
      1.5327733e-8, 1.1920072e-8, 5.4900593e-9, -8.1671795e-10, -4.4234746e-9, -5.0171323e-9, -3.160912e-9, -1.1972669e-9,
      -2.7582833e-10, -1.3699591e-10, -1.0291296e-10, -2.4784306e-10, -4.2875658e-10, -4.5038598e-10, -2.3901171e-10, 9.433746099999999e-12,
      1.480739e-10, 1.6435722e-10, 9.329815700000001e-11, 2.0425522e-11, -1.0664812e-11, -1.2315669e-11, -7.1127172e-12, -1.9486403e-12,
      0.0, 0.0, 0.0, 0.0, },
    { -0.0031794207, -0.0013173157, 0.0064003509, 0.010140285, 0.0075775394, 0.00056326184, -0.012866591, -0.020709553,
      -0.015361329, 0.00381762, 0.022800959, 0.027447143, 0.011327957, -0.016384398, -0.034854051, -0.027765481,
      0.009627986, 0.059838762, 0.089587849, 0.069838924, -0.0064825988, -0.11363701, -0.19705759, -0.2010761,
      -0.10068835, 0.081929799, 0.28629916, 0.44268271, 0.49973345, 0.44632462, 0.31689976, 0.17116777,
      0.062419762, 0.01287363, 0.012939169, 0.037052802, 0.054801411, 0.050222414, 0.025809986, -0.0030336964,
      -0.020986623, -0.024235277, -0.013996668, -0.0038345525, 6.739720499999999e-8, 4.946956e-8, 2.0815264e-8, -1.3278463e-9,
      -1.0398185e-8, -1.1792365e-8, -1.0980052e-8, -1.0573121e-8, -1.0506413e-8, -9.6865614e-9, -6.7673913e-9, -4.517767e-9,
      -3.5747705e-9, -2.7739698e-9, -1.2696313e-9, 2.1657762e-10, 1.0751539e-9, 1.2157822e-9, 7.633168300000001e-10, 2.8106144e-10,
      5.1205725e-11, 1.6271833e-11, 1.5300631e-11, 5.7579735e-11, 1.0429514e-10, 1.0968885e-10, 5.8276177e-11, -2.045035e-12,
      -3.5598539e-11, -3.951248e-11, -2.2429257e-11, -4.9097703e-12, 2.5651279e-12, 2.9621962e-12, 1.7107689e-12, 4.6869195e-13,
      0.0, 0.0, 0.0, 0.0, },
    { 0.0009898319599999999, -0.00005380164, -0.0016617464, -0.0024058437, -0.0031794045, -0.0013173095, 0.0064003186, 0.010140233,
      0.0075774991, 0.0005632576800000001, -0.012866521, -0.020709442, -0.015361246, 0.003817603, 0.022800833, 0.027446985,
      0.011327883, -0.016384315, -0.034853855, -0.027765311, 0.0096279578, 0.059838456, 0.089587375, 0.069838553,
      -0.0064825573, -0.11363639, -0.19705653, -0.20107505, -0.10068788, 0.08192925500000001, 0.28629754, 0.44268034,
      0.49973095, 0.44632262, 0.31689865, 0.17116753, 0.062420092, 0.012874085, 0.012939407, 0.03705269,
      0.054801034, 0.050221973, 0.02580966, -0.0030338396, -0.020986632, -0.024235242, -0.013996676, -0.0038346105,
      -2.2089352e-9, -9.1397999e-10, 4.1441104e-10, 1.5632064e-9, 2.1674468e-9, 2.2213076e-9, 1.6242991e-9, 1.220069e-9,
      1.1433859e-9, 1.0132949e-9, 5.303622e-10, 6.3673309e-11, -1.7092595e-10, -2.0591998e-10, -1.3238559e-10, -5.2482661e-11,
      -1.557149e-11, -1.0780691e-11, -7.849213899999999e-12, -1.390567e-11, -2.2913106e-11, -2.4240643e-11, -1.3014573e-11, -9.3497669e-14,
      6.8837583e-12, 7.660260199999999e-12, 4.3533487e-12, 9.690445799999999e-13, -4.6444337e-13, -5.3633676e-13, -3.097527e-13, -8.486160400000001e-14,
      0.0, 0.0, 0.0, 0.0, },
    { 0.00021150513, -0.0001182675, -0.00018966171, 0.0007039766, 0.0009898316799999999, -0.000053801616, -0.0016617459, -0.002405843,
      -0.0031794035, -0.0013173091, 0.0064003166, 0.01014023, 0.0075774968, 0.00056325744, -0.012866517, -0.020709435,
      -0.015361241, 0.0038176018, 0.022800826, 0.027446977, 0.01132788, -0.01638431, -0.034853844, -0.027765303,
      0.0096279543, 0.059838438, 0.089587349, 0.06983853299999999, -0.0064825542, -0.11363636, -0.19705648, -0.20107499,
      -0.10068785, 0.08192923000000001, 0.28629745, 0.44268021, 0.4997308, 0.44632248, 0.31689855, 0.17116749,
      0.062420089, 0.012874107, 0.01293944, 0.037052722, 0.054801064, 0.050222001, 0.025809687, -0.0030338132,
      -0.020986608, -0.024235225, -0.013996666, -0.0038346066, -1.0807056e-9, -9.6194735e-10, -5.8042675e-10, -2.3026093e-10,
      -5.2462083e-11, 8.934574699999999e-12, 2.8753664e-11, 4.2948201e-11, 5.7629255e-11, 6.1074334e-11, 3.9278999e-11, 2.0849977e-11,
      1.506808e-11, 1.3966739e-11, 7.822410799999999e-12, 2.9708823e-12, 1.5662219e-12, 1.4169493e-12, 5.9549711e-13, -6.4389303e-13,
      -1.5821434e-12, -1.7440449e-12, -9.8694023e-13, -2.0617409e-13, 1.3336526e-13, 1.540095e-13, 8.8945717e-14, 2.4368072e-14,
      0.0, 0.0, 0.0, 0.0, },
    { 0.000029572086, 0.0001500013, -0.00012528062, -0.000085656495, 0.00021150513, -0.0001182675, -0.00018966171, 0.00070397658,
      0.00098983166, -0.000053801612, -0.0016617459, -0.0024058429, -0.0031794034, -0.0013173091, 0.0064003165, 0.01014023,
      0.0075774967, 0.00056325745, -0.012866517, -0.020709435, -0.015361241, 0.0038176017, 0.022800826, 0.027446976,
      0.01132788, -0.01638431, -0.034853844, -0.027765303, 0.0096279538, 0.059838437, 0.089587348, 0.06983853199999999,
      -0.0064825542, -0.11363636, -0.19705647, -0.20107499, -0.10068785, 0.08192923000000001, 0.28629745, 0.4426802,
      0.49973079, 0.44632247, 0.31689854, 0.17116747, 0.062420078, 0.012874099, 0.012939434, 0.037052719,
      0.054801063, 0.050222001, 0.025809688, -0.0030338124, -0.020986608, -0.024235224, -0.013996665, -0.0038346058,
      -1.7349485e-10, -1.4014027e-10, -6.733694999999999e-11, 2.3535906e-12, 3.9700971e-11, 4.5614905e-11, 2.9175877e-11, 1.2428934e-11,
      5.1956468e-12, 4.160356e-12, 2.590853e-12, 2.6563084e-12, 3.7861708e-12, 3.9536444e-12, 2.0858696e-12, -1.2971498e-13,
      -1.3858912e-12, -1.5382753e-12, -8.7320447e-13, -1.911529e-13, 9.9847212e-14, 1.1530303e-13, 6.6591419e-14, 1.8243762e-14,
      0.0, 0.0, 0.0, 0.0, },
    { -0.0000057370994, 0.000043510151, -0.0000074219963, -0.00011888246, 0.000029572086, 0.0001500013, -0.00012528062, -0.000085656494,
      0.00021150513, -0.0001182675, -0.0001896617, 0.00070397658, 0.00098983165, -0.000053801611, -0.0016617459, -0.0024058429,
      -0.0031794034, -0.0013173091, 0.0064003165, 0.01014023, 0.0075774966, 0.00056325745, -0.012866517, -0.020709435,
      -0.015361241, 0.0038176017, 0.022800826, 0.027446976, 0.01132788, -0.01638431, -0.034853844, -0.027765303,
      0.009627953700000001, 0.059838437, 0.089587347, 0.06983853199999999, -0.0064825542, -0.11363635, -0.19705647, -0.20107499,
      -0.10068785, 0.08192923000000001, 0.28629744, 0.4426802, 0.49973078, 0.44632246, 0.31689853, 0.17116747,
      0.062420077, 0.012874099, 0.012939434, 0.037052719, 0.054801063, 0.050222001, 0.025809688, -0.003033812,
      -0.020986607, -0.024235224, -0.013996665, -0.0038346056, 8.9844115e-13, 1.8039035e-12, 1.1116515e-12, -1.2672024e-13,
      -9.559857e-13, -1.0248827e-12, -5.1382188e-13, 1.808146e-13, 6.3147038e-13, 6.9078155e-13, 3.8644389e-13, 6.3822893e-14,
      -8.5035914e-14, -9.6170938e-14, -5.5045873e-14, -1.3511746e-14, 3.2585157e-15, 3.7629168e-15, 2.1732123e-15, 5.9538554e-16,
      0.0, 0.0, 0.0, 0.0, },
    { -0.000010027921, -0.000010930316, 0.000019234827, -0.000016474706, -0.0000057370994, 0.000043510151, -0.0000074219963, -0.00011888246,
      0.000029572086, 0.0001500013, -0.00012528062, -0.000085656494, 0.00021150513, -0.0001182675, -0.0001896617, 0.00070397658,
      0.00098983165, -0.000053801611, -0.0016617459, -0.0024058429, -0.0031794034, -0.0013173091, 0.0064003165, 0.01014023,
      0.0075774966, 0.00056325745, -0.012866517, -0.020709435, -0.015361241, 0.0038176017, 0.022800826, 0.027446976,
      0.01132788, -0.01638431, -0.034853844, -0.027765303, 0.009627953700000001, 0.059838436, 0.089587347, 0.06983853199999999,
      -0.0064825542, -0.11363635, -0.19705647, -0.20107499, -0.10068785, 0.08192923000000001, 0.28629744, 0.4426802,
      0.49973078, 0.44632246, 0.31689853, 0.17116747, 0.062420077, 0.012874099, 0.012939434, 0.037052719,
      0.054801063, 0.050222001, 0.025809688, -0.003033812, -0.020986607, -0.024235224, -0.013996665, -0.0038346056,
      -5.2802279e-13, -3.8437399e-13, -2.4041388e-13, -2.8463768e-13, -4.2600563e-13, -4.4368416e-13, -2.3294104e-13, 1.9132449e-14,
      1.637729e-13, 1.8161207e-13, 1.0304955e-13, 2.2420723e-14, -1.2069513e-14, -1.393781e-14, -8.0495588e-15, -2.2053027e-15,
      0.0, 0.0, 0.0, 0.0, },
    { -0.0000030589933, -0.0000034582443, 0.0000041270616, 0.000012505734, -0.000010027921, -0.000010930316, 0.000019234827, -0.000016474706,
      -0.0000057370994, 0.000043510151, -0.0000074219963, -0.00011888246, 0.000029572086, 0.0001500013, -0.00012528062, -0.000085656494,
      0.00021150513, -0.0001182675, -0.0001896617, 0.00070397658, 0.00098983165, -0.000053801611, -0.0016617459, -0.0024058429,
      -0.0031794034, -0.0013173091, 0.0064003165, 0.01014023, 0.0075774966, 0.00056325745, -0.012866517, -0.020709435,
      -0.015361241, 0.0038176017, 0.022800826, 0.027446976, 0.01132788, -0.01638431, -0.034853844, -0.027765303,
      0.009627953700000001, 0.059838436, 0.089587347, 0.06983853199999999, -0.0064825542, -0.11363635, -0.19705647, -0.20107499,
      -0.10068785, 0.08192923000000001, 0.28629744, 0.4426802, 0.49973078, 0.44632246, 0.31689853, 0.17116747,
      0.062420077, 0.012874099, 0.012939434, 0.037052719, 0.054801063, 0.050222001, 0.025809688, -0.003033812,
      -0.020986607, -0.024235224, -0.013996665, -0.0038346056, -6.2170478e-14, -6.383222999999999e-14, -3.2934372e-14, 5.0060707e-15,
      2.7669088e-14, 3.0656054e-14, 1.738787e-14, 3.7610419e-15, -2.0823764e-15, -2.4047173e-15, -1.388806e-15, -3.8048514e-16,
      0.0, 0.0, 0.0, 0.0, },
    { 3.6812554e-7, -0.0000013162529, 8.907414900000001e-7, 0.0000021605209, -0.0000030589933, -0.0000034582443, 0.0000041270616, 0.000012505734,
      -0.000010027921, -0.000010930316, 0.000019234827, -0.000016474706, -0.0000057370994, 0.000043510151, -0.0000074219963, -0.00011888246,
      0.000029572086, 0.0001500013, -0.00012528062, -0.000085656494, 0.00021150513, -0.0001182675, -0.0001896617, 0.00070397658,
      0.00098983165, -0.000053801611, -0.0016617459, -0.0024058429, -0.0031794034, -0.0013173091, 0.0064003165, 0.01014023,
      0.0075774966, 0.00056325745, -0.012866517, -0.020709435, -0.015361241, 0.0038176017, 0.022800826, 0.027446976,
      0.01132788, -0.01638431, -0.034853844, -0.027765303, 0.009627953700000001, 0.059838436, 0.089587347, 0.06983853199999999,
      -0.0064825542, -0.11363635, -0.19705647, -0.20107499, -0.10068785, 0.08192923000000001, 0.28629744, 0.4426802,
      0.49973078, 0.44632246, 0.31689853, 0.17116747, 0.062420077, 0.012874099, 0.012939434, 0.037052719,
      0.054801063, 0.050222001, 0.025809688, -0.003033812, -0.020986607, -0.024235224, -0.013996665, -0.0038346056,
      6.8070256e-15, 7.5939277e-15, 4.3204891e-15, 9.7727649e-16, -4.2864944e-16, -4.9500211e-16, -2.8588054e-16, -7.832144999999999e-17,
      0.0, 0.0, 0.0, 0.0, },
    { -1.3565721e-7, 3.3158394e-7, -1.1299252e-7, 6.2458675e-7, 3.6812554e-7, -0.0000013162529, 8.907414900000001e-7, 0.0000021605209,
      -0.0000030589933, -0.0000034582443, 0.0000041270616, 0.000012505734, -0.000010027921, -0.000010930316, 0.000019234827, -0.000016474706,
      -0.0000057370994, 0.000043510151, -0.0000074219963, -0.00011888246, 0.000029572086, 0.0001500013, -0.00012528062, -0.000085656494,
      0.00021150513, -0.0001182675, -0.0001896617, 0.00070397658, 0.00098983165, -0.000053801611, -0.0016617459, -0.0024058429,
      -0.0031794034, -0.0013173091, 0.0064003165, 0.01014023, 0.0075774966, 0.00056325745, -0.012866517, -0.020709435,
      -0.015361241, 0.0038176017, 0.022800826, 0.027446976, 0.01132788, -0.01638431, -0.034853844, -0.027765303,
      0.009627953700000001, 0.059838436, 0.089587347, 0.06983853199999999, -0.0064825542, -0.11363635, -0.19705647, -0.20107499,
      -0.10068785, 0.08192923000000001, 0.28629744, 0.4426802, 0.49973078, 0.44632246, 0.31689853, 0.17116747,
      0.062420077, 0.012874099, 0.012939434, 0.037052719, 0.054801063, 0.050222001, 0.025809688, -0.003033812,
      -0.020986607, -0.024235224, -0.013996665, -0.0038346056, 4.0075758e-16, 4.6279274e-16, 2.6727853e-16, 7.3225139e-17,
      0.0, 0.0, 0.0, 0.0, },
    { 9.2129029e-8, 4.470829e-8, -1.3675036e-7, -4.31831e-7, -1.3565721e-7, 3.3158394e-7, -1.1299252e-7, 6.2458675e-7,
      3.6812554e-7, -0.0000013162529, 8.907414900000001e-7, 0.0000021605209, -0.0000030589933, -0.0000034582443, 0.0000041270616, 0.000012505734,
      -0.000010027921, -0.000010930316, 0.000019234827, -0.000016474706, -0.0000057370994, 0.000043510151, -0.0000074219963, -0.00011888246,
      0.000029572086, 0.0001500013, -0.00012528062, -0.000085656494, 0.00021150513, -0.0001182675, -0.0001896617, 0.00070397658,
      0.00098983165, -0.000053801611, -0.0016617459, -0.0024058429, -0.0031794034, -0.0013173091, 0.0064003165, 0.01014023,
      0.0075774966, 0.00056325745, -0.012866517, -0.020709435, -0.015361241, 0.0038176017, 0.022800826, 0.027446976,
      0.01132788, -0.01638431, -0.034853844, -0.027765303, 0.009627953700000001, 0.059838436, 0.089587347, 0.06983853199999999,
      -0.0064825542, -0.11363635, -0.19705647, -0.20107499, -0.10068785, 0.08192923000000001, 0.28629744, 0.4426802,
      0.49973078, 0.44632246, 0.31689853, 0.17116747, 0.062420077, 0.012874099, 0.012939434, 0.037052719,
      0.054801063, 0.050222001, 0.025809688, -0.003033812, -0.020986607, -0.024235224, -0.013996665, -0.0038346056,
      0.0, 0.0, 0.0, 0.0, },
    { 0.0, 0.0, 0.0, 0.0, -8.764059600000001e-9, -6.963307e-9, 1.5066994e-8, 3.6978382e-8,
      9.2186128e-8, 4.4735999e-8, -1.3683511e-7, -4.3209863e-7, -1.3574128e-7, 3.3178945e-7, -1.1306255e-7, 6.2497386e-7,
      3.683537e-7, -0.0000013170687, 8.9129355e-7, 0.00000216186, -0.0000030608892, -0.0000034603877, 0.0000041296194, 0.000012513485,
      -0.000010034136, -0.00001093709, 0.000019246748, -0.000016484916, -0.0000057406551, 0.000043537117, -0.0000074265962, -0.00011895614,
      0.000029590414, 0.00015009426, -0.00012535827, -0.00008570958199999999, 0.00021163621, -0.0001183408, -0.00018977925, 0.00070441288,
      0.0009904451199999999, -0.000053834956, -0.0016627758, -0.002407334, -0.0031813739, -0.0013181255, 0.0064042832, 0.010146514,
      0.0075821929, 0.00056360654, -0.012874492, -0.02072227, -0.015370762, 0.0038199677, 0.022814957, 0.027463987,
      0.0113349, -0.016394464, -0.034875445, -0.027782511, 0.009633920799999999, 0.059875523, 0.089642871, 0.069881816,
      -0.0064865719, -0.11370678, -0.1971786, -0.20119961, -0.10075025, 0.08198000699999999, 0.28647488, 0.44295456,
      0.5000405, 0.44659908, 0.31709494, 0.17127356, 0.062458763, 0.012882078, 0.012947454, 0.037075684,
      0.054835027, 0.050253127, 0.025825684, -0.0030356923, },
    { 0.0, 0.0, 0.0, 0.0, 2.3914563e-11, 1.9000834e-11, -4.1113434e-11, -1.0090322e-10,
      -9.0429743e-9, -7.1071213e-9, 1.5487424e-8, 3.8272917e-8, 9.284437599999999e-8, 4.3970329e-8, -1.3695386e-7, -4.3515323e-7,
      -1.3717026e-7, 3.3641935e-7, -1.1584767e-7, 6.2102624e-7, 3.7785615e-7, -0.0000013117388, 8.8280807e-7, 0.0000021344647,
      -0.0000030430666, -0.0000034413485, 0.0000040899953, 0.000012597541, -0.000010049803, -0.000011090041, 0.00001932711, -0.000016211794,
      -0.0000058393238, 0.000043263497, -0.0000071077195, -0.0001190937, 0.000029105316, 0.00015088585, -0.00012523184, -0.00008789934600000001,
      0.00020959441, -0.00011856341, -0.0001858346, 0.00071318131, 0.0010022188, -0.000050406274, -0.0016854432, -0.0024425377,
      -0.0032119973, -0.0013237792, 0.0064594112, 0.010234742, 0.0076478105, 0.00055494281, -0.012976947, -0.020861916,
      -0.015449686, 0.0038766312, 0.022981361, 0.027625553, 0.011344005, -0.016609039, -0.035228952, -0.028059949,
      0.0096817025, 0.060372756, 0.090460822, 0.070649035, -0.006231908, -0.11428553, -0.19857599, -0.20303655,
      -0.10242931, 0.08101735, 0.28650414, 0.44387032, 0.50143144, 0.44795843, 0.31804973, 0.17170719,
      0.062504161, 0.012785176, 0.012917411, 0.037199735, },
    { 0.0, 0.0, 0.0, 0.0, 1.7208769e-11, 1.3672881e-11, -2.9584969e-11, -7.260932400000001e-11,
      -1.9502299e-10, -9.8973137e-11, 2.9276962e-10, 9.0756433e-10, -8.4024356e-9, -7.5848188e-9, 1.5160135e-8, 3.5281047e-8,
      9.1795739e-8, 4.8119378e-8, -1.3958217e-7, -4.3792198e-7, -1.299519e-7, 3.3845784e-7, -1.2042094e-7, 6.0758667e-7,
      3.8536054e-7, -0.000001308981, 8.6541935e-7, 0.0000022271281, -0.0000030839153, -0.0000035840001, 0.0000041996021, 0.000012795353,
      -0.000010161269, -0.000011227452, 0.000019595831, -0.000016605111, -0.0000061431566, 0.000044269118, -0.0000072986449, -0.00012118588,
      0.000028160432, 0.0001509061, -0.00012314444, -0.000080367843, 0.00022072872, -0.00011654453, -0.00020614453, 0.00068484311,
      0.00097637937, -0.000057369856, -0.0016371767, -0.0023647844, -0.0031580486, -0.0013325879, 0.0063771053, 0.010119985,
      0.0075805926, 0.00060526641, -0.012846336, -0.020747422, -0.015463245, 0.0036989769, 0.022719278, 0.027446179,
      0.01143065, -0.016173272, -0.034553004, -0.027441455, 0.009878847, 0.059889938, 0.089299875, 0.06910726,
      -0.0076681795, -0.11513091, -0.19851945, -0.20202798, -0.10067452, 0.08315763499999999, 0.28866517, 0.44579776,
      0.5030154, 0.44918495, 0.31895639, 0.17236043, },
    { 0.0, 0.0, 0.0, 0.0, 3.6851694e-10, 2.9279771e-10, -6.335468899999999e-10, -1.5548913e-9,
      -4.6510001e-9, -2.4966087e-9, 7.0855764e-9, 2.1437864e-8, 1.3169401e-8, -1.0542802e-8, -6.1601155e-9, -6.1575439e-8,
      -3.4073418e-8, 7.724169599999999e-8, -3.4452297e-8, -1.1253081e-8, 2.9592187e-7, 1.2560497e-7, -3.1939331e-7, -9.671230100000001e-7,
      -3.3711275e-8, 5.7369354e-7, -5.5258612e-7, 0.0000029538269, -3.0498174e-7, -0.0000051446274, 0.0000037421504, 0.000007933204999999999,
      -0.0000073627242, -0.0000087743051, 0.000012632452, 0.000011519312, -0.000022548551, 0.0000044186995, 0.000026652061, -0.00007250452599999999,
      -0.000029667452, 0.000072190638, 0.000031608516, -0.000030718401, 0.00028455347, 0.00027795666, -0.00062873194, -0.00071930588,
      -0.00018882003, -0.00033095544, 0.00067798053, 0.0026897514, 0.0026281934, -0.00029899771, -0.0042160247, -0.0059853387,
      -0.0062551191, -0.0010063188, 0.012567797, 0.017963467, 0.011342289, -0.0027790647, -0.025355323, -0.035902046,
      -0.022213305, 0.014809325, 0.049440119, 0.055745988, 0.022283613, -0.034643741, -0.077415581, -0.07472068,
      -0.015256075, 0.073924579, 0.13781927, 0.12632161, 0.023452078, -0.13385396, -0.26083401, -0.26880791,
      -0.11637654, 0.16325051, 0.4764406, 0.7149867, },
    { -0.8535439, -0.35968119, 0.065351407, 0.059333029, -0.1269521, -0.076877898, -0.10933188, 0.15495355,
      0.054522357, -0.23877106, -0.00046647111, 0.089122653, -0.026462813, 0.048335133, -0.0079782051, -0.016659518,
      0.047159549, -0.037963054, -0.011292312, 0.027672996, -0.018929343, 0.0034709715, 0.0029394227, -0.0041317473,
      0.0053664905, -0.0034050512, -0.0026283962, 0.001701639, -1.4621633e-18, -7.386584000000001e-18, -8.5187602e-19, 8.977116299999999e-18,
      1.7897277e-18, -9.0759985e-18, 1.7650852e-18, 1.3050953e-18, -1.1888393e-18, 3.6267152e-18, -1.5965868e-18, -2.9834012e-19,
      2.6322817e-18, -2.3718141e-18, 6.9968316e-19, 2.1831511e-18, -1.8853562e-18, 1.9795454e-19, 2.0018813e-19, -4.9845616e-19,
      7.4533925e-19, -3.7752172e-19, -3.6230857e-19, 3.6040853e-19, -6.196548599999999e-20, -1.1505867e-19, 9.5248123e-20, 3.1535333e-20,
      -7.2976602e-20, 3.3552326e-20, -3.6298577e-20, -2.6232003e-20, 3.7424549e-20, -4.9240473e-20, -5.6073546e-21, 3.8346556e-20,
      -2.6796095e-20, 2.3158911e-21, 4.7582374e-21, -2.8967253e-21, 6.5855823e-21, -9.9663562e-21, -5.6020698e-21, 4.1833883e-21,
      1.0439859e-21, 1.7132787e-22, -5.812353400000001e-23, 3.0334018e-22, 2.9773051e-22, -3.5694498e-22, -2.5609715e-22, 1.0779825e-22,
      0.0, 0.0, 0.0, 0.0, },
    { 0.0097491326, 0.49799784, 0.49667555, -0.028559998, -0.42222797, -0.18514687, 0.2500187, 0.31609299,
      -0.068894788, -0.23630869, 0.051357429, 0.18649924, -0.0027572124, -0.13295343, -0.066275158, 0.0590209,
      0.064667315, -0.024369346, -0.018853311, 0.022018745, -0.00008582693, -0.012650973, -0.008405076799999999, 0.0012936423,
      0.0016217257, -0.0010289889, -0.00079428773, 0.0005142265, 3.837204e-18, -5.1417775e-18, 1.6180876e-18, 1.3329307e-18,
      -3.4207218e-18, 4.2353711e-18, 1.1016565e-18, -6.9071994e-18, 4.800252e-18, 4.6916197e-18, -3.6758436e-18, -2.1583284e-18,
      7.2104057e-19, 2.2650924e-19, 1.4887113e-18, -9.0359689e-19, -1.9341924e-18, 2.0497686e-18, 3.4265221e-19, -1.0853157e-18,
      6.8534707e-19, -3.3981292e-19, -5.8153225e-21, 3.4694372e-19, -3.6884567e-19, 2.325747e-19, 1.1847485e-19, -1.9271002e-19,
      1.0387854e-19, -4.2515241e-21, -4.4545004e-20, 4.429267e-21, -4.2326837e-21, 4.0949538e-21, 1.7076984e-20, -3.7107451e-21,
      -1.6750204e-20, 9.3038469e-21, 3.4943875e-21, -4.5159418e-21, 4.0634963e-21, -2.835022e-21, 1.4147726e-22, 2.8528805e-21,
      -2.5032938e-21, -4.1947499e-22, -1.4819835e-22, -4.270146e-22, 8.2949421e-22, -3.9522162e-22, -3.2534223e-22, 2.5448899e-22,
      0.0, 0.0, 0.0, 0.0, },
    { -0.043868099, -0.11359779, -0.23884371, -0.31126971, -0.03080143, 0.38884179, 0.3428215, -0.14827109,
      -0.46703243, -0.19177262, 0.29481908, 0.27261094, -0.11727332, -0.20703374, 0.041159567, 0.17723309,
      0.019225426, -0.14351258, -0.060622382, 0.07083052099999999, 0.054619012, -0.014728714, -0.017162395, 0.0148445,
      0.0059330378, -0.014589274, -0.009891233100000001, 0.0026891131, -1.4871029e-17, 4.5609802e-18, -6.5993686e-18, -2.0104526e-17,
      8.4690133e-18, -4.8460668e-18, -3.5542414e-18, -2.7023903e-18, 1.2011757e-18, 2.8554601e-18, -1.4641397e-19, -5.2258014e-18,
      2.1733685e-18, 3.3779312e-18, -1.3649109e-19, -2.1880083e-18, -1.5772341e-19, 1.5069148e-18, 1.3492288e-18, -8.802379500000001e-19,
      -1.0697808e-18, 6.9070831e-19, 2.3374065e-19, -1.1077769e-19, 1.3077631e-19, -2.8574171e-19, 1.415901e-19, 1.7828577e-19,
      -1.5396053e-19, 7.5893357e-20, -4.3050603e-20, -8.3679005e-20, 1.3347946e-19, -5.4974401e-20, -1.7493216e-21, 3.3365805e-20,
      -5.8985959e-20, 1.9211594e-20, 8.331346600000001e-21, -1.0148857e-20, 6.4122352e-21, -1.8011728e-20, -2.2948955e-21, 1.1046082e-20,
      -6.5384535e-21, -1.9688739e-21, -1.1027418e-21, -7.3109031e-22, 3.475493e-21, -1.7477936e-21, -1.424523e-21, 1.075262e-21,
      0.0, 0.0, 0.0, 0.0, },
    { -0.11350485, 0.078457191, 0.23123985, 0.16377816, -0.0053257425, -0.11081688, -0.17690723, -0.1882482,
      0.024386161, 0.35978077, 0.34619534, -0.13380312, -0.47092927, -0.18321328, 0.29495422, 0.27700897,
      -0.1107013, -0.2220893, 0.041645458, 0.187296, 0.010609985, -0.14990385, -0.063127034, 0.071396236,
      0.059312169, -0.014899249, -0.018035052, 0.015904326, 0.0060997472, -0.01511777, -0.01047208, 0.0025348521,
      0.000094772741, 0.00018699728, -0.00009023797399999999, -0.00018613552, 0.000039646997, 0.00012704541, 0.000021476997, -0.00007741941,
      -0.000031298152, 0.000067956454, 0.000037690455, -0.000029151857, -0.000015545855, 0.000014856125, 0.000015237388, -0.0000027604675,
      -0.0000057556044, -1.3476965e-8, 0.0000028285011, 9.4403854e-7, -2.2498423e-7, -0.0000015897131, -6.5328073e-7, 6.4520141e-7,
      5.13012e-7, -5.7050618e-7, -4.7024882e-7, 1.9002285e-7, 1.6475241e-7, -7.181441e-8, -8.440031899999999e-8, 2.4316993e-8,
      5.7585708e-9, 1.4360563e-8, 5.5108486e-9, -4.6057052e-9, -5.3604255e-9, 5.1973797e-9, 4.9569464e-9, -1.6041796e-9,
      -1.868336e-9, 7.621408200000001e-10, 5.8431354e-10, -4.9659479e-10, 2.442538e-10, -1.5448383e-10, -1.1904637e-10, 7.7304831e-11,
      0.0, 0.0, 0.0, 0.0, },
    { 0.018943425, -0.00023134148, -0.051032993, -0.14158766, -0.1219561, 0.060207541, 0.20496175, 0.1352868,
      -0.028897426, -0.12425083, -0.17929974, -0.18396477, 0.0280128, 0.35786456, 0.34036011, -0.13789513,
      -0.4700605, -0.17977395, 0.29670633, 0.27653234, -0.1105855, -0.21980639, 0.044009223, 0.18725153,
      0.008622334299999999, -0.15146531, -0.063196745, 0.07186579, 0.059376049, -0.014785703, -0.017430318, 0.016309961,
      0.0058585315, -0.015503177, -0.010351797, 0.0028796789, 0.000030161127, -0.00010871535, -0.000054762367, 0.000049991893,
      0.000030931583, -0.000034949267, -0.000026658113, 0.000012548204, 0.0000085226258, -0.0000033484801, -0.000006354489, -6.016628e-7,
      0.0000018156312, 0.0000016799919, -2.9269113e-7, -0.0000011148862, -3.2141225e-7, 0.0000011159281, 6.2161289e-7, -4.3728317e-7,
      -3.2357674e-7, 2.9479843e-7, 2.5855335e-7, -9.861939099999999e-8, -7.7174471e-8, 2.357143e-8, 3.4866513e-8, -7.2848793e-9,
      4.1725233e-10, -1.0232913e-8, -5.1858942e-9, 3.493822e-9, 3.2966092e-9, -2.9205056e-9, -2.772405e-9, 9.5707304e-10,
      9.349160000000001e-10, -3.607995e-10, -2.7638764e-10, 2.4385053e-10, -1.3420421e-10, 8.4880481e-11, 6.5409521e-11, -4.2474809e-11,
      0.0, 0.0, 0.0, 0.0, },
    { -0.042099341, 0.0049466918, 0.060032676, 0.053056167, 0.019616496, 0.0062036013, -0.038995874, -0.12624839,
      -0.10751575, 0.069583591, 0.20780096, 0.13338201, -0.032366324, -0.12649959, -0.17867505, -0.18073608,
      0.031238128, 0.35847857, 0.33866999, -0.13958546, -0.47087746, -0.18085881, 0.29523238, 0.27623237,
      -0.10915239, -0.21827969, 0.044204705, 0.18674789, 0.008460475699999999, -0.15160207, -0.063812811, 0.071407823,
      0.059707723, -0.014212698, -0.017418974, 0.015975258, 0.0058538568, -0.015264018, -0.01033238, 0.0027038771,
      -0.0000012051987, 0.000010834885, 0.0000041549531, -0.0000052634061, -0.0000023429131, 0.0000034400397, 0.0000028289785, -9.1863911e-7,
      -0.0000012270482, 4.0351997e-7, 7.5101858e-7, 4.7474055e-9, -1.4510685e-7, -1.8989353e-7, -3.8281943e-8, 8.072763899999999e-8,
      7.066967400000001e-8, -9.4210763e-8, -7.3956251e-8, 3.115984e-8, 2.9133811e-8, -1.5014384e-8, -1.606001e-8, 5.2321014e-9,
      1.7924899e-9, 1.7024681e-9, 3.7814988e-10, -4.778233e-10, -7.9390088e-10, 8.1430637e-10, 7.7594964e-10, -2.4383214e-10,
      -3.0886716e-10, 1.3001907e-10, 9.9726822e-11, -8.3004062e-11, 3.8036166e-11, -2.4056832e-11, -1.8538371e-11, 1.2038213e-11,
      0.0, 0.0, 0.0, 0.0, },
    { -0.0051186317, 0.0026082139, 0.0011561029, -0.027835056, -0.043654175, 0.0024567809, 0.056866436, 0.049722261,
      0.016705706, 0.0041957359, -0.039911418, -0.12626296, -0.10711407, 0.069886621, 0.207737, 0.13299916,
      -0.032807178, -0.12670819, -0.17850805, -0.18026528, 0.03173076, 0.3587233, 0.33861929, -0.13974791,
      -0.47100956, -0.18098662, 0.29508412, 0.27616175, -0.10905287, -0.21808239, 0.04432355, 0.18671439,
      0.008368981899999999, -0.15163858, -0.063790702, 0.071424185, 0.059696165, -0.014211805, -0.017387543, 0.016000355,
      0.0058451304, -0.015287092, -0.010335228, 0.0027174845, 0.0000020768948, -5.7483511e-7, -0.0000013986923, -2.0846925e-7,
      3.3989431e-7, 4.6234671e-7, 1.5124727e-8, -2.6644477e-7, -1.0785895e-7, 2.5703709e-7, 1.5722009e-7, -9.7984161e-8,
      -7.3898702e-8, 6.035174000000001e-8, 5.4781732e-8, -2.0282833e-8, -1.4592424e-8, 3.0544033e-9, 5.8925631e-9, -9.0937458e-10,
      5.4095235e-10, -2.3396208e-9, -1.3722115e-9, 7.9084999e-10, 7.5764257e-10, -6.0261359e-10, -5.6187916e-10, 2.161657e-10,
      1.5585732e-10, -5.5402911e-11, -4.2385399e-11, 3.9580331e-11, -2.5135395e-11, 1.5897448e-11, 1.225069e-11, -7.9551986e-12,
      0.0, 0.0, 0.0, 0.0, },
    { -0.0071084674, -0.0033836798, 0.012325746, 0.008056183999999999, -0.0058137499, 0.0029806292, 0.0026693637, -0.025573967,
      -0.041351054, 0.0041008264, 0.057495506, 0.049458219, 0.016024743, 0.0036418724, -0.039989343, -0.12584118,
      -0.10648721, 0.07032519399999999, 0.20775682, 0.13264239, -0.033314247, -0.12711621, -0.17863318, -0.18010455,
      0.032003531, 0.35891666, 0.33867579, -0.13976955, -0.47107608, -0.18111434, 0.29494862, 0.2761335,
      -0.10895874, -0.21798696, 0.044327136, 0.18667373, 0.0083638593, -0.15162138, -0.063800826, 0.071398434,
      0.059697546, -0.0141866, -0.017375994, 0.015991099, 0.005839154, -0.015281732, -0.010330736, 0.0027152827,
      6.7571268e-8, 1.0574211e-7, 1.1225055e-8, -5.6939946e-8, -2.7184582e-8, 5.4989418e-8, 3.5491693e-8, -2.0532338e-8,
      -1.5851011e-8, 1.199146e-8, 1.1153341e-8, -4.0527661e-9, -2.70396e-9, 3.3976271e-10, 9.757715999999999e-10, -9.7092189e-11,
      1.7708423e-10, -4.9642505e-10, -3.1843656e-10, 1.6615e-10, 1.6237103e-10, -1.1900391e-10, -1.092032e-10, 4.5808636e-11,
      2.4606003e-11, -7.796026e-12, -5.9521785e-12, 6.0340975e-12, -4.5217706e-12, 2.8598959e-12, 2.2038568e-12, -1.4311127e-12,
      0.0, 0.0, 0.0, 0.0, },
    { -0.001265786, -0.0016609477, 0.00222941, 0.0011762007, -0.0073250731, -0.0034332159, 0.012471328, 0.0083430294,
      -0.0054961577, 0.003215434, 0.0027593588, -0.025616888, -0.041455975, 0.0040184504, 0.057488632, 0.049527597,
      0.016124517, 0.0037132221, -0.039983743, -0.12589765, -0.1065697, 0.070258873, 0.20773562, 0.13266656,
      -0.033268011, -0.12707599, -0.17861669, -0.18011328, 0.031979675, 0.35889134, 0.33866157, -0.13976776,
      -0.4710648, -0.18110469, 0.29495129, 0.27613251, -0.10895966, -0.21798881, 0.044323721, 0.18667181,
      0.0083658499, -0.15161776, -0.06379945300000001, 0.071397486, 0.059696885, -0.014186055, -0.017375485, 0.015990851,
      0.005838785, -0.015281695, -0.010330521, 0.0027153303, -1.3725082e-9, 2.288355e-8, 1.1355676e-8, -8.889336600000001e-9,
      -7.3277766e-9, 7.1743165e-9, 6.1308246e-9, -2.3901982e-9, -1.9373079e-9, 6.9554647e-10, 9.1814463e-10, -2.40284e-10,
      -1.9481616e-11, -2.0716003e-10, -1.0771373e-10, 6.454408900000001e-11, 7.9297993e-11, -6.596152699999999e-11, -6.131494e-11, 2.3139144e-11,
      1.8220157e-11, -6.889387e-12, -5.2758971e-12, 4.7202158e-12, -2.698161e-12, 1.706513e-12, 1.3150514e-12, -8.5395143e-13,
      0.0, 0.0, 0.0, 0.0, },
    { 0.000050159503, -0.00071212184, 0.00028363207, 0.0014615066, -0.0013267837, -0.0016433511, 0.0023330548, 0.0013382911,
      -0.0071554962, -0.0033071427, 0.012526538, 0.0083335545, -0.0055376737, 0.0031805864, 0.0027555735, -0.025588465,
      -0.041414908, 0.0040466304, 0.057487914, 0.049499743, 0.016086099, 0.0036837639, -0.0399912, -0.12588418,
      -0.10654688, 0.070278005, 0.20774306, 0.13266193, -0.033279293, -0.1270871, -0.17862262, -0.18011286,
      0.031983838, 0.35889559, 0.33866366, -0.13976788, -0.47106632, -0.18110697, 0.29494939, 0.27613212,
      -0.10895856, -0.21798754, 0.04432405, 0.1866715, 0.008365786, -0.15161747, -0.063799301, 0.07139735799999999,
      0.05969678, -0.014185963, -0.017375356, 0.015990858, 0.0058387245, -0.015281726, -0.010330507, 0.0027153486,
      -7.4751925e-10, 1.1363937e-9, 8.6711229e-10, -3.7268833e-10, -3.6811377e-10, 2.0482729e-10, 2.0980924e-10, -7.258209800000001e-11,
      -2.7266282e-11, -1.5979419e-11, -9.5719216e-13, 3.8460406e-12, 8.9396574e-12, -9.508538499999999e-12, -9.0540185e-12, 2.7940998e-12,
      3.7212707e-12, -1.5943743e-12, -1.2232114e-12, 1.0063401e-12, -4.4202812e-13, 2.7957097e-13, 2.154394e-13, -1.3989921e-13,
      0.0, 0.0, 0.0, 0.0, },
    { 0.00011533996, -0.000026734332, -0.00013506823, 0.00037552805, 0.000056473736, -0.00069611, 0.00030822484, 0.0014903898,
      -0.001299667, -0.001623524, 0.0023429619, 0.0013395122, -0.0071588879, -0.0033105472, 0.012526018, 0.008336244899999999,
      -0.0055337618, 0.0031829767, 0.0027548042, -0.025592198, -0.041419704, 0.0040431007, 0.057487257, 0.049501718,
      0.016089174, 0.0036863006, -0.039990188, -0.12588473, -0.10654831, 0.070276592, 0.2077423, 0.13266197,
      -0.033278735, -0.12708649, -0.17862233, -0.18011298, 0.031983453, 0.35889516, 0.33866339, -0.13976791,
      -0.47106621, -0.18110686, 0.29494942, 0.27613211, -0.10895856, -0.21798752, 0.044324057, 0.1866715,
      0.008365790600000001, -0.15161745, -0.063799281, 0.07139736200000001, 0.059696773, -0.014185967, -0.017375353, 0.015990861,
      0.0058387231, -0.01528173, -0.010330508, 0.0027153498, 1.2421473e-10, -1.6472405e-11, -4.5499511e-11, 4.6952921e-12,
      -7.622754700000001e-12, 2.2440782e-11, 1.4394938e-11, -7.4419077e-12, -7.478396099999999e-12, 5.4641676e-12, 5.0064067e-12, -2.1114128e-12,
      -1.1146915e-12, 3.5181885e-13, 2.6859057e-13, -2.7304861e-13, 2.0563143e-13, -1.3005576e-13, -1.0022199e-13, 6.5081053e-14,
      0.0, 0.0, 0.0, 0.0, },
    { 0.000048301379, 0.000081244009, -0.00010202271, -0.0000527072, 0.00012665087, -0.000023161991, -0.00014073862, 0.00036301218,
      0.000042236451, -0.00070675058, 0.00030414781, 0.0014924293, -0.0012947379, -0.0016196213, 0.002343374, 0.0013363966,
      -0.0071634301, -0.0033138343, 0.01252572, 0.0083387958, -0.0055300282, 0.0031859358, 0.0027557003, -0.02559331,
      -0.041421766, 0.0040413078, 0.057486526, 0.049502138, 0.016090249, 0.0036873704, -0.039989605, -0.12588475,
      -0.1065487, 0.070276145, 0.20774205, 0.13266197, -0.033278579, -0.12708632, -0.17862224, -0.180113,
      0.031983382, 0.35889508, 0.33866334, -0.13976793, -0.4710662, -0.18110685, 0.29494942, 0.27613211,
      -0.10895856, -0.21798752, 0.044324053, 0.18667149, 0.0083657926, -0.15161745, -0.06379928, 0.07139736000000001,
      0.059696773, -0.014185965, -0.017375352, 0.01599086, 0.0058387226, -0.015281729, -0.010330508, 0.0027153497,
      8.4895945e-13, 8.9873902e-12, 4.4939672e-12, -2.8829398e-12, -3.2827318e-12, 2.8288238e-12, 2.6521985e-12, -9.600575e-13,
      -8.4408406e-13, 3.2522644e-13, 2.4913156e-13, -2.2004175e-13, 1.2146722e-13, -7.6823174e-14, -5.920069e-14, 3.8443518e-14,
      0.0, 0.0, 0.0, 0.0, },
    { 0.00001049566, 0.000014942095, -0.00001798232, -0.000063966374, 0.000050491712, 0.000079338435, -0.00010824893, -0.000061723045,
      0.00011751212, -0.000029813667, -0.00014355097, 0.00036364052, 0.000044544686, -0.00070482097, 0.00030440767, 0.0014909545,
      -0.0012969238, -0.0016211718, 0.0023433177, 0.0013377839, -0.0071614371, -0.0033122572, 0.012526182, 0.008338179500000001,
      -0.0055311464, 0.0031849683, 0.0027553009, -0.0255931, -0.041421213, 0.0040418568, 0.057486821, 0.049502123,
      0.01609004, 0.0036871372, -0.03998973, -0.12588473, -0.1065486, 0.070276251, 0.2077421, 0.13266198,
      -0.033278611, -0.12708636, -0.17862227, -0.180113, 0.031983384, 0.35889509, 0.33866334, -0.13976793,
      -0.4710662, -0.18110685, 0.29494942, 0.27613211, -0.10895856, -0.21798752, 0.044324053, 0.18667149,
      0.0083657929, -0.15161745, -0.06379928, 0.07139736000000001, 0.059696773, -0.014185965, -0.017375352, 0.01599086,
      0.0058387225, -0.015281729, -0.010330508, 0.0027153497, -2.141137e-13, 1.8621291e-13, 1.7348502e-13, -6.3446602e-14,
      -5.5329986e-14, 2.1752068e-14, 1.6668418e-14, -1.452183e-14, 7.7079643e-15, -4.8735409e-15, -3.7557779e-15, 2.4394086e-15,
      0.0, 0.0, 0.0, 0.0, },
    { -0.0000016862516, 0.0000019060019, -4.248487e-7, -0.0000047292013, 0.000010654859, 0.000014866629, -0.000018311699, -0.000064466384,
      0.000049972355, 0.000078950867, -0.00010842286, -0.0000617001, 0.0001176368, -0.000029701701, -0.00014352575, 0.00036357185,
      0.000044435351, -0.00070489915, 0.00030440706, 0.0014910288, -0.0012968196, -0.0016210916, 0.0023433373, 0.0013377465,
      -0.0071614998, -0.0033123101, 0.012526161, 0.0083381915, -0.0055311158, 0.0031849984, 0.0027553172, -0.025593101,
      -0.041421224, 0.0040418445, 0.057486815, 0.049502125, 0.016090047, 0.003687144, -0.039989727, -0.12588473,
      -0.1065486, 0.070276249, 0.2077421, 0.13266197, -0.033278611, -0.12708636, -0.17862227, -0.180113,
      0.031983384, 0.35889509, 0.33866334, -0.13976793, -0.4710662, -0.18110685, 0.29494942, 0.27613211,
      -0.10895856, -0.21798752, 0.044324054, 0.18667149, 0.0083657929, -0.15161745, -0.06379928, 0.07139736000000001,
      0.059696773, -0.014185965, -0.017375352, 0.01599086, 0.0058387225, -0.015281729, -0.010330508, 0.0027153497,
      -9.093892299999999e-16, 1.5923447e-15, 1.2350047e-15, -5.1775324e-16, -5.9423787e-16, 3.7692653e-16, 2.903267e-16, -1.8815403e-16,
      0.0, 0.0, 0.0, 0.0, },
    { 8.5507366e-8, -0.0000012851265, 7.857136300000001e-7, -3.4801813e-7, -0.0000018684855, 0.0000017467446, -5.336318e-7, -0.0000047832847,
      0.000010639476, 0.00001486632, -0.000018315371, -0.000064480605, 0.000049952572, 0.000078935834, -0.0001084256, -0.000061690695,
      0.00011765129, -0.000029690251, -0.00014352319, 0.00036356698, 0.000044428438, -0.00070490357, 0.00030440683, 0.0014910323,
      -0.0012968146, -0.0016210877, 0.0023433385, 0.0013377449, -0.0071615031, -0.0033123133, 0.012526159, 0.008338191300000001,
      -0.0055311149, 0.0031849995, 0.0027553178, -0.025593101, -0.041421224, 0.0040418441, 0.057486815, 0.049502125,
      0.016090047, 0.0036871443, -0.039989726, -0.12588473, -0.1065486, 0.070276249, 0.2077421, 0.13266197,
      -0.033278611, -0.12708636, -0.17862227, -0.180113, 0.031983384, 0.35889509, 0.33866334, -0.13976793,
      -0.4710662, -0.18110685, 0.29494942, 0.27613211, -0.10895856, -0.21798752, 0.044324054, 0.18667149,
      0.0083657929, -0.15161745, -0.06379928, 0.07139736000000001, 0.059696773, -0.014185965, -0.017375352, 0.01599086,
      0.0058387225, -0.015281729, -0.010330508, 0.0027153497, -2.284982e-15, 1.4420459e-15, 1.1116432e-15, -7.2294759e-16,
      0.0, 0.0, 0.0, 0.0, },
    { -2.565031e-7, -1.0384266e-7, 3.7843906e-7, 0.0000012258276, 6.8475377e-8, -0.0000012217701, 9.2978511e-7, -1.5535891e-7,
      -0.0000016795333, 0.0000018820924, -4.7671008e-7, -0.0000047953669, 0.000010593913, 0.000014828085, -0.000018320832, -0.000064451905,
      0.000049995467, 0.000078966429, -0.0001084242, -0.000061717862, 0.00011761178, -0.000029721923, -0.00014353291, 0.00036357866,
      0.000044450187, -0.00070488461, 0.00030441474, 0.0014910283, -0.0012968253, -0.0016210983, 0.0023433329, 0.0013377452,
      -0.007161499, -0.0033123087, 0.012526161, 0.0083381911, -0.0055311167, 0.0031849975, 0.0027553167, -0.025593101,
      -0.041421223, 0.0040418448, 0.057486815, 0.049502125, 0.016090047, 0.0036871442, -0.039989726, -0.12588473,
      -0.1065486, 0.070276249, 0.2077421, 0.13266197, -0.033278611, -0.12708636, -0.17862227, -0.180113,
      0.031983384, 0.35889509, 0.33866334, -0.13976793, -0.4710662, -0.18110685, 0.29494942, 0.27613211,
      -0.10895856, -0.21798752, 0.044324054, 0.18667149, 0.0083657929, -0.15161745, -0.06379928, 0.07139736000000001,
      0.059696773, -0.014185965, -0.017375352, 0.01599086, 0.0058387225, -0.015281729, -0.010330508, 0.0027153497,
      0.0, 0.0, 0.0, 0.0, },
    { 0.0, 0.0, 0.0, 0.0, 2.8347963e-8, 2.2523303e-8, -4.8735247e-8, -1.1960916e-7,
      -2.5287662e-7, -1.0870486e-7, 3.6471382e-7, 0.0000012064933, 4.9010332e-8, -0.0000012357305, 9.2436549e-7, -1.5276658e-7,
      -0.000001674434, 0.0000018850808, -4.7547238e-7, -0.0000047991778, 0.000010587354, 0.000014826825, -0.00001832123, -0.00006445143200000001,
      0.000050010787, 0.000078981352, -0.00010843969, -0.000061781033, 0.00011764661, -0.000029652232, -0.00014362553, 0.00036355273,
      0.000044555001, -0.00070494037, 0.00030431608, 0.0014913269, -0.0012968481, -0.0016216969, 0.0023436473, 0.0013391667,
      -0.0071627289, -0.0033138138, 0.012528415, 0.008339137700000001, -0.0055374361, 0.0031823423, 0.0027663458, -0.025586039,
      -0.041424124, 0.0040475437, 0.057484017, 0.049470067, 0.016054175, 0.0036921246, -0.039935715, -0.12582517,
      -0.1064918, 0.07029540300000001, 0.20762795, 0.13246998, -0.033414365, -0.12705281, -0.17833346, -0.1797243,
      0.032220064, 0.3587368, 0.33807475, -0.1405286, -0.47145321, -0.18066022, 0.2961133, 0.27732297,
      -0.10855845, -0.2187329, 0.042752897, 0.18508766, 0.0077641669, -0.15053787, -0.06122282, 0.074228853,
      0.06099463, -0.015859301, -0.02241404, 0.008369957900000001, },
    { 0.0, 0.0, 0.0, 0.0, 3.1104865e-11, 2.4713744e-11, -5.3474856e-11, -1.3124141e-10,
      2.8076073e-8, 2.240846e-8, -4.8344655e-8, -1.1830887e-7, -2.5288366e-7, -1.1009094e-7, 3.6581885e-7, 0.0000012066097,
      4.7227712e-8, -0.0000012339054, 9.2397559e-7, -1.5830681e-7, -0.0000016623097, 0.000001902708, -4.9736841e-7, -0.0000048746571,
      0.000010641936, 0.000014916903, -0.00001844127, -0.000064515498, 0.000050156285, 0.00007894542200000001, -0.00010861116, -0.000061388997,
      0.0001176581, -0.000030448803, -0.00014326261, 0.00036539096, 0.000043163251, -0.00070690185, 0.00030701988, 0.0014924274,
      -0.001304832, -0.0016246302, 0.002357033, 0.0013474944, -0.0071698505, -0.0033108691, 0.012533524, 0.0083162698,
      -0.0055818492, 0.003181139, 0.0028309669, -0.025523938, -0.041427794, 0.0040395529, 0.057468792, 0.049353567,
      0.015859766, 0.0037180721, -0.039555569, -0.12557329, -0.10652434, 0.070261595, 0.20734565, 0.1317388,
      -0.03404103, -0.12662826, -0.1770882, -0.17860175, 0.032710046, 0.35856033, 0.33678034, -0.14316156,
      -0.473647, -0.17975323, 0.30028384, 0.28157025, -0.10762441, -0.22181434, 0.037393303, 0.18007816,
      0.006253649, -0.14515602, -0.046992144, 0.09621433, },
    { 0.0, 0.0, 0.0, 0.0, 4.9302209e-11, 3.9172078e-11, -8.4759363e-11, -2.0802185e-10,
      -8.0623665e-11, 9.6317379e-11, 1.6817782e-11, 5.8283731e-10, 2.5759293e-8, 1.9418005e-8, -4.3417929e-8, -1.0682495e-7,
      -2.5975641e-7, -1.2300478e-7, 3.8217799e-7, 0.000001218181, 4.4579459e-8, -0.0000012107338, 9.0779212e-7, -3.1709409e-7,
      -0.0000014767929, 0.0000022412612, -9.1037095e-7, -0.0000058521315, 0.000011594129, 0.00001609105, -0.000020289796, -0.000065763475,
      0.000052689099, 0.00007888203399999999, -0.00011191315, -0.000056305446, 0.00011794491, -0.000041636402, -0.00013852035, 0.00039353835,
      0.000016087667, -0.00074771176, 0.00036439677, 0.0015550243, -0.001424237, -0.0016912016, 0.0025549356, 0.0014235625,
      -0.0074529838, -0.0033190717, 0.012908787, 0.0082218319, -0.0061297864, 0.0033308454, 0.003480986, -0.025683031,
      -0.041995976, 0.0044737841, 0.057981001, 0.048634771, 0.014743331, 0.0040970547, -0.037749205, -0.12495603,
      -0.10679701, 0.070623223, 0.20681414, 0.12717576, -0.038987624, -0.12484364, -0.16903315, -0.17130917,
      0.036125929, 0.35914755, 0.33062642, -0.16026408, -0.49087723, -0.17615148, 0.32895563, 0.31348535,
      -0.097420887, -0.24067157, -0.0068642378, 0.11219697, },
    { 0.0, 0.0, 0.0, 0.0, 1.6669958e-11, 1.3244779e-11, -2.8658655e-11, -7.0335904e-11,
      2.2814041e-10, 2.3549011e-10, -4.3339335e-10, -8.805498899999999e-10, -1.2935862e-9, -5.515234299999999e-10, 1.8861269e-9, 7.3446094e-9,
      1.2543352e-8, 1.545426e-9, -1.5165886e-8, -4.9146175e-8, -2.9234586e-7, -1.7639541e-7, 4.5374829e-7, 0.0000012209487,
      1.2278171e-7, -9.685260999999999e-7, 6.4489216e-7, -0.0000015008025, -3.9354283e-7, 0.0000042281365, -0.0000033565057, -0.000010303686,
      0.000017012562, 0.000020906574, -0.00002961357, -0.000069633977, 0.000062129587, 0.000073870575, -0.00012292418, -0.00001682869,
      0.00010857498, -0.00011195588, -0.00009026875400000001, 0.00053011919, -0.00014608608, -0.00092560829, 0.00067049494, 0.0018019183,
      -0.0020404998, -0.0019316755, 0.0035226148, 0.0016869094, -0.008693585, -0.0032849721, 0.014554009, 0.0078151739,
      -0.0084537802, 0.0041605347, 0.0058665682, -0.026774198, -0.045914986, 0.0049123195, 0.063776951, 0.050441966,
      0.013630997, 0.0075108398, -0.037034514, -0.1403178, -0.12671833, 0.072889677, 0.2323412, 0.15268124,
      -0.024786402, -0.12259352, -0.19576372, -0.23414639, -0.010289108, 0.39690249, 0.43370648, -0.089458844,
      -0.50864478, -0.25076346, 0.23238368, 0.17867278, },
    { -0.10336098, 0.43698355, -0.05205054, -0.38094273, 0.25644551, 0.2346896, -0.37978468, 0.12285758,
      0.11406574, -0.19346287, 0.25076721, -0.1000306, -0.21361052, 0.30863792, -0.1077896, -0.13642263,
      0.19131498, -0.10816236, 0.011856046, 0.073645325, -0.10939103, 0.064372891, 0.015456895, -0.058566397,
      0.042702958, -0.009002869700000001, -0.0076727162, 0.0096952662, -0.01108636, 0.0070343222, 0.0054298699, -0.0035153294,
      -2.8212126e-17, 2.9364612e-17, -2.8497598e-18, -6.5598367e-18, 2.2196917e-17, -1.5966312e-17, -6.8415466e-19, 1.0256422e-17,
      -1.0903092e-17, 6.136113e-18, 1.5503946e-18, -3.4403994e-18, 4.7292107e-18, -3.142732e-18, -1.0747554e-18, 2.4408853e-18,
      -1.2884504e-18, 7.997105e-20, 4.4808753e-19, -5.2762049e-19, 1.8594686e-19, 1.0847923e-19, -3.3301754e-19, 1.4273141e-19,
      2.0535414e-19, -1.8929296e-19, 1.2177378e-20, 7.566992799999999e-20, -1.7612349e-19, 5.9536839e-20, -1.1724752e-20, -8.3718063e-20,
      8.1945198e-20, 1.3593323e-21, -1.0939206e-21, 2.7296664e-20, -2.9975079e-20, -5.1646176e-22, 7.0238119e-21, -1.9083712e-21,
      1.5417738e-21, -4.847092e-22, -6.900116e-22, 7.7780343e-22, 1.6035611e-21, -1.1671024e-21, -8.809386700000001e-22, 5.1907549e-22,
      0.0, 0.0, 0.0, 0.0, },
    { -0.2381574, 0.24787821, 0.14738553, -0.31977596, -0.062372762, 0.32513857, -0.068171486, -0.31736026,
      0.24711974, 0.14518414, -0.30433735, 0.15030169, 0.051580316, -0.2025471, 0.24903716, -0.097704256,
      -0.18039066, 0.29862922, -0.1263385, -0.11264106, 0.19168629, -0.12019892, 0.009955064200000001, 0.07220718399999999,
      -0.10756871, 0.069730504, 0.014077653, -0.063847716, 0.046485607, -0.009319401499999999, -0.0075936564, 0.01014513,
      -0.012827683, 0.008134040299999999, 0.0063368034, -0.0040889465, -0.0000063505191, 0.000006950383, -0.00001241348, 0.000007111846,
      -0.0000064631173, 0.0000079486222, -0.0000051804315, 9.788376799999999e-7, -0.0000012868637, 0.0000029161477, -2.1119116e-7, -5.2479358e-7,
      1.2924158e-8, 4.5152466e-7, 5.6881144e-7, -1.4409161e-7, -1.6287584e-7, 6.6652555e-8, 1.7433987e-7, -6.663249100000001e-8,
      1.629114e-8, -4.3365806e-8, -8.7838571e-9, 1.3558251e-8, -8.1414893e-10, -6.6948214e-9, -7.456150700000001e-9, 8.8064106e-10,
      3.8271749e-9, -2.1546977e-9, -2.1125387e-9, 1.2521301e-9, -3.3478394e-10, 2.9664332e-10, 2.5333064e-10, -1.2786898e-10,
      -8.9606122e-12, 6.8636006e-12, 6.0126818e-12, -3.2434772e-12, 1.7503469e-13, -1.4327545e-13, -1.2368103e-13, 6.4898593e-14,
      0.0, 0.0, 0.0, 0.0, },
    { -0.16594546, 0.021972375, 0.21257073, -0.13795719, -0.23325892, 0.22979788, 0.13646732, -0.28662031,
      -0.036960515, 0.3065747, -0.073102404, -0.295528, 0.23381221, 0.12263712, -0.28890599, 0.15882495,
      0.047578576, -0.19677918, 0.24338164, -0.098716897, -0.17095421, 0.29074244, -0.13382557, -0.10865891,
      0.19302541, -0.11817653, 0.01048866, 0.06894270199999999, -0.10712826, 0.071793709, 0.01314768, -0.065370729,
      0.046759544, -0.0084408238, -0.0072321374, 0.010164083, -0.013519027, 0.008576618899999999, 0.0066295855, -0.0042906449,
      -9.998778500000001e-7, 0.0000015478204, -0.0000017517036, 7.332273e-7, -0.0000010317518, 0.0000016602753, -9.682844000000001e-7, 2.5190377e-7,
      -3.2823674e-7, 5.8315547e-7, 5.514423999999999e-10, -5.4213323e-8, -7.0818943e-8, 1.1415268e-7, 9.940506e-8, -5.6015297e-8,
      5.7225635e-10, 2.8129944e-9, 2.4769282e-8, -5.8898787e-9, -9.4554702e-11, -6.4790772e-9, 3.0551283e-9, 2.0083669e-9,
      -1.638693e-9, -1.0561361e-9, -1.5904414e-9, -2.499696e-10, 1.3374645e-9, -7.3325746e-10, -6.863901e-10, 4.357945e-10,
      -1.3965471e-10, 1.0984232e-10, 9.5653262e-11, -5.1031561e-11, 1.6616273e-12, -1.3601326e-12, -1.1741202e-12, 6.1609085e-13,
      0.0, 0.0, 0.0, 0.0, },
    { -0.069104323, -0.04237214, 0.10967353, 0.011282401, -0.17415051, 0.021403053, 0.21945724, -0.12028611,
      -0.21523085, 0.23230499, 0.12991487, -0.28748783, -0.035689801, 0.30409908, -0.070474384, -0.28821646,
      0.23193231, 0.1174521, -0.28651538, 0.16020319, 0.046143787, -0.19745216, 0.24009639, -0.099156989,
      -0.16726204, 0.29091257, -0.13494079, -0.10845704, 0.19287637, -0.11779632, 0.01034376, 0.06791125000000001,
      -0.10701528, 0.07252636899999999, 0.013108627, -0.065758523, 0.046754171, -0.0082023024, -0.0071059064, 0.010140732,
      -0.013675539, 0.008677084200000001, 0.0066982, -0.0043362722, -4.2928634e-7, 5.5762325e-7, -6.0251197e-7, 2.8545178e-7,
      -2.4847952e-7, 3.2216043e-7, -1.1454465e-7, -9.7613984e-9, -1.4180537e-8, 6.336785500000001e-8, 3.1840419e-8, -2.378838e-8,
      -4.0718732e-9, 1.1746141e-8, 1.8788076e-8, -7.626240800000001e-9, 9.9899638e-10, -3.5145479e-9, 3.664563e-9, 1.5251639e-9,
      -2.2503938e-9, -1.5662936e-10, -5.6682878e-10, -5.3093496e-10, 1.0615418e-9, -6.1065908e-10, -5.6545207e-10, 3.5065135e-10,
      -9.9709455e-11, 7.8470462e-11, 6.8324958e-11, -3.6442805e-11, 1.1691909e-12, -9.570465999999999e-13, -8.2616046e-13, 4.3350747e-13,
      0.0, 0.0, 0.0, 0.0, },
    { -0.015911608, -0.027299969, 0.033186044, 0.039995417, -0.07342411, -0.041121331, 0.1163226, 0.020910495,
      -0.16563933, 0.024714618, 0.21754715, -0.12284876, -0.2152654, 0.23413165, 0.13237649, -0.28594259,
      -0.036907369, 0.30169717, -0.07026452499999999, -0.2863606, 0.23127057, 0.11548435, -0.28671725, 0.1606467,
      0.04670782, -0.19688757, 0.23957645, -0.099297892, -0.16668393, 0.29063735, -0.13529883, -0.10844124,
      0.19282211, -0.11760804, 0.01034761, 0.06766707499999999, -0.10697097, 0.072675087, 0.013100453, -0.065832161,
      0.046742062, -0.0081473039, -0.0070743643, 0.010131315, -0.013705653, 0.0086962898, 0.0067125396, -0.0043457398,
      -8.1627608e-8, 8.543780100000001e-8, -5.3712589e-8, 1.327336e-9, 1.9107335e-9, 1.6196752e-8, 3.2215588e-9, -4.4466373e-9,
      -2.1746539e-9, 5.3420267e-9, 5.952181e-9, -3.0205576e-9, 6.0999665e-10, -9.590371300000001e-10, 1.368256e-9, 5.2928793e-10,
      -9.1403627e-10, 6.763270499999999e-11, -6.7608191e-11, -2.3474385e-10, 3.5310168e-10, -2.0783083e-10, -1.9147887e-10, 1.1741923e-10,
      -3.1338961e-11, 2.4671859e-11, 2.1480394e-11, -1.1455478e-11, 3.6436943e-13, -2.9825622e-13, -2.5746655e-13, 1.3509928e-13,
      0.0, 0.0, 0.0, 0.0, },
    { 0.00010953376, -0.0066695294, 0.002925938, 0.017851646, -0.016853728, -0.026665938, 0.035370231, 0.042794613,
      -0.07111854500000001, -0.040033922, 0.11610379, 0.020099525, -0.16589307, 0.025495639, 0.21858618, -0.12263584,
      -0.21596224, 0.23352451, 0.13258257, -0.28549906, -0.037093532, 0.30113508, -0.070353631, -0.28601051,
      0.23138871, 0.11537757, -0.28669649, 0.16070747, 0.046747369, -0.1969158, 0.2394417, -0.099292696,
      -0.1665998, 0.29059798, -0.1353337, -0.10844426, 0.19281049, -0.1175694, 0.010342358, 0.067627653,
      -0.1069576, 0.07269242200000001, 0.013100911, -0.065838073, 0.046735578, -0.008138709100000001, -0.0070683408, 0.010128424,
      -0.013708364, 0.008697987799999999, 0.0067140604, -0.0043467264, 1.9622188e-9, 1.7406201e-10, -1.672447e-9, 5.4651109e-10,
      -4.7595869e-10, 9.2437526e-10, 4.7383151e-10, -4.4720428e-10, 1.7140273e-10, -5.2404856e-11, 1.685328e-10, 6.967566999999999e-11,
      -1.444021e-10, 4.4055443e-11, 3.0290447e-11, -4.1955458e-11, 3.608598e-11, -2.2614881e-11, -2.0559587e-11, 1.2228308e-11,
      -2.6688281e-12, 2.1036316e-12, 1.8310149e-12, -9.7598049e-13, 3.0073196e-14, -2.4616691e-14, -2.1250116e-14, 1.1150436e-14,
      0.0, 0.0, 0.0, 0.0, },
    { 0.0012742472, 0.00027493115, -0.0016569906, 0.0029734957, 0.00020414488, -0.0064933966, 0.0031591306, 0.018059611,
      -0.016689805, -0.026524664, 0.035438013, 0.042736753, -0.071193733, -0.039967886, 0.11625315, 0.02011879,
      -0.16603009, 0.025409457, 0.21865285, -0.12256659, -0.21601375, 0.23345319, 0.13261377, -0.28543431,
      -0.037106847, 0.30108709, -0.07034105, -0.28596614, 0.23138499, 0.11534424, -0.28669767, 0.16073009,
      0.046750734, -0.19693178, 0.23943261, -0.099283807, -0.16659433, 0.29059092, -0.13533815, -0.10844243,
      0.19281158, -0.11756903, 0.010340932, 0.067626614, -0.10695672, 0.07269291, 0.013100859, -0.065838181,
      0.046735249, -0.008138348300000001, -0.007068071, 0.010128278, -0.013708444, 0.0086980397, 0.006714112, -0.0043467551,
      7.6250582e-11, -2.4269293e-10, -4.4500305e-10, 1.6738798e-10, -1.7254536e-11, 8.666511200000001e-11, -8.2471298e-11, -3.5152726e-11,
      4.9015492e-11, 6.2600825e-12, 1.5877804e-11, 1.1149878e-11, -2.4816445e-11, 1.4173131e-11, 1.3144982e-11, -8.180377100000001e-12,
      2.3708542e-12, -1.8656596e-12, -1.6244826e-12, 8.664931e-13, -2.7867857e-14, 2.2811437e-14, 1.9691784e-14, -1.0332754e-14,
      0.0, 0.0, 0.0, 0.0, },
    { 0.00048543251, 0.00067050041, -0.0009308460499999999, -0.00083948251, 0.001402981, 0.00026296786, -0.0018168877, 0.0027381465,
      0.0000065882746, -0.0065710155, 0.0031962766, 0.018128669, -0.016675065, -0.026579325, 0.035371358, 0.0427177,
      -0.071163305, -0.039936092, 0.11625122, 0.020099619, -0.16602767, 0.025440594, 0.21867805, -0.12257452,
      -0.21603854, 0.2334434, 0.13262307, -0.28542753, -0.037114116, 0.30108227, -0.070331567, -0.28595691,
      0.23138119, 0.11533681, -0.28669552, 0.16073649, 0.046750369, -0.19693692, 0.23943193, -0.09928029300000001,
      -0.16659375, 0.29058837, -0.13533921, -0.10844109, 0.1928121, -0.11756991, 0.010340415, 0.067626916,
      -0.10695652, 0.072692795, 0.01310069, -0.065838151, 0.046735307, -0.0081383532, -0.0070680841, 0.010128292,
      -0.013708463, 0.0086980527, 0.0067141216, -0.0043467614, -2.102711e-11, 3.3417224e-11, -3.8409085e-11, -1.7490935e-11,
      2.7166852e-11, -1.5216838e-12, 2.6753955e-12, 6.9083671e-12, -1.0809558e-11, 6.3270183e-12, 5.836294e-12, -3.5887054e-12,
      9.731098600000001e-13, -7.6601753e-13, -6.6694169e-13, 3.5569341e-13, -1.1340318e-14, 9.282481500000001e-15, 8.012984599999999e-15, -4.2046742e-15,
      0.0, 0.0, 0.0, 0.0, },
    { 0.00008874163200000001, 0.00017255261, -0.00020334688, -0.00048589084, 0.0005194140799999999, 0.00065162184, -0.0010030955, -0.00093500466,
      0.0013229135, 0.00022422489, -0.0018110625, 0.002766036, 0.000019216306, -0.0065926605, 0.0031624642, 0.018119477,
      -0.016655318, -0.026561899, 0.035366048, 0.042705799, -0.07115904100000001, -0.039919962, 0.11625833, 0.020092471,
      -0.16603572, 0.025440328, 0.21868056, -0.12257518, -0.2160409, 0.23344412, 0.13262646, -0.28542614,
      -0.0371155, 0.301081, -0.070330532, -0.28595529, 0.23138086, 0.11533536, -0.28669534, 0.16073756,
      0.046750343, -0.19693765, 0.23943165, -0.099279878, -0.16659353, 0.29058801, -0.1353394, -0.10844095,
      0.19281216, -0.11756996, 0.010340352, 0.067626914, -0.10695649, 0.072692796, 0.013100678, -0.06583815,
      0.046735303, -0.0081383464, -0.0070680792, 0.01012829, -0.013708465, 0.0086980544, 0.006714123, -0.0043467623,
      4.1692516e-12, -7.121456e-13, -1.7304044e-13, 1.1302171e-12, -1.37798e-12, 8.2446267e-13, 7.569006e-13, -4.6045708e-13,
      1.1710488e-13, -9.2217873e-14, -8.028399700000001e-14, 4.2809906e-14, -1.3535472e-15, 1.1074076e-15, 9.559748499999999e-16, -5.0178012e-16,
      0.0, 0.0, 0.0, 0.0, },
    { 4.9186471e-7, 0.0000051461586, -0.0000052735889, -0.000074617715, 0.000090338235, 0.00016829914, -0.00021319587, -0.00049763725,
      0.00050951791, 0.00064579957, -0.0010036791, -0.0009315934, 0.0013254699, 0.00022183375, -0.0018160248, 0.0027645817,
      0.000022431098, -0.0065899474, 0.0031613131, 0.01811749, -0.016654443, -0.026559467, 0.035366631, 0.042704497,
      -0.07115983400000001, -0.039919625, 0.11625849, 0.020092045, -0.16603593, 0.025440686, 0.21868092, -0.12257525,
      -0.21604106, 0.23344415, 0.13262661, -0.28542607, -0.037115559, 0.30108091, -0.07033048, -0.28595519,
      0.23138084, 0.1153353, -0.28669535, 0.16073761, 0.046750358, -0.19693768, 0.23943163, -0.099279862,
      -0.16659352, 0.290588, -0.13533941, -0.10844094, 0.19281216, -0.11756996, 0.010340351, 0.067626913,
      -0.10695649, 0.072692796, 0.013100678, -0.06583815, 0.046735303, -0.008138345999999999, -0.0070680789, 0.010128289,
      -0.013708465, 0.0086980544, 0.006714123, -0.0043467623, 2.3376946e-13, -1.3432021e-13, -1.2440416e-13, 7.7199335e-14,
      -2.2028344e-14, 1.7343448e-14, 1.5100496e-14, -8.051784e-15, 2.6023509e-16, -2.1274301e-16, -1.8354782e-16, 9.640321599999999e-17,
      0.0, 0.0, 0.0, 0.0, },
    { -0.0000040937358, -0.0000055585317, 0.0000076082811, 0.0000085197263, -6.5244263e-7, 0.0000052950016, -0.0000037713108, -0.00007243937499999999,
      0.000092169031, 0.00016904946, -0.00021350235, -0.00049827953, 0.00050935188, 0.00064630511, -0.0010030326, -0.00093141393,
      0.0013251546, 0.00022152265, -0.0018159844, 0.0027647772, 0.000022393482, -0.0065902524, 0.0031610922, 0.018117583,
      -0.016654221, -0.026559397, 0.035366549, 0.042704454, -0.071159768, -0.039919598, 0.11625841, 0.020091976,
      -0.1660359, 0.025440742, 0.2186809, -0.1225753, -0.21604106, 0.23344419, 0.13262662, -0.2854261,
      -0.037115562, 0.30108093, -0.07033047100000001, -0.2859552, 0.23138084, 0.1153353, -0.28669535, 0.1607376,
      0.046750357, -0.19693768, 0.23943163, -0.099279862, -0.16659352, 0.290588, -0.13533941, -0.10844094,
      0.19281216, -0.11756996, 0.010340351, 0.067626913, -0.10695649, 0.072692796, 0.013100678, -0.06583815,
      0.046735303, -0.008138345999999999, -0.0070680789, 0.010128289, -0.013708465, 0.0086980544, 0.006714123, -0.0043467623,
      -8.131355e-15, 6.378939e-15, 5.55643e-15, -2.9687905e-15, 9.4777622e-17, -7.491754e-17, -6.5217812e-17, 3.4928497e-17,
      0.0, 0.0, 0.0, 0.0, },
    { -7.6914904e-7, -0.0000013872766, 0.0000018717906, 0.0000039601571, -0.0000043842735, -0.0000054015677, 0.000008218305099999999, 0.000009330314099999999,
      3.0916655e-8, 0.0000056292333, -0.0000038169114, -0.000072676369, 0.000092055843, 0.00016922368, -0.00021322119, -0.0004981985,
      0.00050919173, 0.00064616029, -0.00100299, -0.0009313142, 0.0013251208, 0.00022138627, -0.0018160486, 0.0027648352,
      0.000022464236, -0.0065902472, 0.0031610699, 0.018117587, -0.0166542, -0.026559402, 0.03536652, 0.042704441,
      -0.071159757, -0.039919587, 0.1162584, 0.020091963, -0.1660359, 0.025440754, 0.2186809, -0.12257531,
      -0.21604106, 0.2334442, 0.13262662, -0.2854261, -0.037115563, 0.30108093, -0.07033046900000001, -0.28595521,
      0.23138083, 0.1153353, -0.28669535, 0.1607376, 0.046750356, -0.19693768, 0.23943163, -0.099279862,
      -0.16659352, 0.290588, -0.13533941, -0.10844094, 0.19281216, -0.11756996, 0.010340351, 0.067626913,
      -0.10695649, 0.072692796, 0.013100678, -0.06583815, 0.046735303, -0.008138345999999999, -0.0070680789, 0.010128289,
      -0.013708465, 0.0086980544, 0.006714123, -0.0043467623, 9.764870899999999e-18, -1.4718019e-17, -1.1346244e-17, 4.1658833e-18,
      0.0, 0.0, 0.0, 0.0, },
    { -1.0208573e-7, 1.3018186e-8, 1.194814e-7, 5.5588767e-7, -7.7832783e-7, -0.000001347968, 0.0000019573526, 0.0000040619503,
      -0.0000042970883, -0.0000053486099, 0.000008225291299999999, 0.000009300481599999999, 5.6623086e-9, 0.0000056459329, -0.0000037749505, -0.000072660374,
      0.000092031895, 0.00016920012, -0.00021321372, -0.00049818143, 0.00050918639, 0.0006461392299999999, -0.0010029982, -0.00093130473,
      0.0013251297, 0.00022138567, -0.0018160509, 0.002764837, 0.000022466322, -0.0065902489, 0.0031610667, 0.018117586,
      -0.016654199, -0.026559401, 0.035366519, 0.04270444, -0.071159756, -0.039919586, 0.1162584, 0.020091962,
      -0.1660359, 0.025440755, 0.2186809, -0.12257531, -0.21604106, 0.2334442, 0.13262662, -0.2854261,
      -0.037115563, 0.30108093, -0.07033046900000001, -0.28595521, 0.23138083, 0.1153353, -0.28669535, 0.1607376,
      0.046750356, -0.19693768, 0.23943163, -0.099279862, -0.16659352, 0.290588, -0.13533941, -0.10844094,
      0.19281216, -0.11756996, 0.010340351, 0.067626913, -0.10695649, 0.072692796, 0.013100678, -0.06583815,
      0.046735303, -0.008138345999999999, -0.0070680789, 0.010128289, -0.013708465, 0.0086980544, 0.006714123, -0.0043467623,
      0.0, 0.0, 0.0, 0.0, },
    { 0.0, 0.0, 0.0, 0.0, 2.5759653e-8, 2.0466814e-8, -4.4285476e-8, -1.0868825e-7,
      -9.6447646e-8, 7.1631101e-9, 1.0217806e-7, 5.3372984e-7, -7.9697132e-7, -0.0000013577621, 0.0000019572844, 0.0000040680546,
      -0.0000042928595, -0.0000053527451, 0.000008217056199999999, 0.0000092987249, 8.7710696e-9, 0.0000056470119, -0.0000037725847, -0.00007265115,
      0.000092025111, 0.00016919001, -0.00021319519, -0.0004981714, 0.00050916083, 0.00064614419, -0.0010029715, -0.00093137957,
      0.0013251136, 0.00022150757, -0.001816076, 0.0027646198, 0.000022551485, -0.0065901118, 0.0031609105, 0.018118037,
      -0.01665361, -0.026559824, 0.03536572, 0.042704521, -0.071159823, -0.039919898, 0.11625875, 0.020089684,
      -0.16603036, 0.025448944, 0.21867067, -0.12260165, -0.21601898, 0.23347556, 0.13258048, -0.28544691,
      -0.037013621, 0.30109905, -0.07049103, -0.28599544, 0.23154326, 0.11529805, -0.28686781, 0.16093501,
      0.047036544, -0.19708734, 0.2391103, -0.099324941, -0.16644021, 0.29049677, -0.13552768, -0.10796588,
      0.193457, -0.11803531, 0.0092231821, 0.0674976, -0.10592521, 0.07331246399999999, 0.012536859, -0.066336276,
      0.047126045, -0.0081144835, -0.0086391006, 0.0076846839, },
    { 0.0, 0.0, 0.0, 0.0, -2.310967e-13, -1.8361323e-13, 3.9729678e-13, 9.750711799999999e-13,
      2.5735935e-8, 2.0447217e-8, -4.424413e-8, -1.0858931e-7, -9.6323217e-8, 7.1885059e-9, 1.020196e-7, 5.3307751e-7,
      -7.9586216e-7, -0.0000013560898, 0.0000019547474, 0.0000040629048, -0.0000042915417, -0.0000053492893, 0.000008213601799999999, 0.0000093049104,
      -1.7246536e-8, 0.0000056052413, -0.000003712541, -0.00007247102700000001, 0.0000919272, 0.00016897358, -0.00021294943, -0.0004979377,
      0.00050890982, 0.00064625727, -0.0010028059, -0.00093287896, 0.0013259411, 0.00022450974, -0.0018185077, 0.0027565327,
      0.000028529945, -0.0065815284, 0.0031491404, 0.018115062, -0.016634876, -0.026565874, 0.035342312, 0.042743219,
      -0.07115894, -0.03999209, 0.11628727, 0.020224178, -0.16612642, 0.025312132, 0.21889516, -0.12262658,
      -0.21642083, 0.23358692, 0.1330733, -0.28544717, -0.037080723, 0.30159241, -0.070810965, -0.28752889,
      0.23108101, 0.11569811, -0.28635917, 0.16342308, 0.049077681, -0.19783438, 0.23674534, -0.10382321,
      -0.16979763, 0.29279912, -0.12921646, -0.10115504, 0.19504154, -0.1252006, -0.00050619406, 0.062627694,
      -0.1038641, 0.081254391, 0.025697232, -0.045830207, },
    { 0.0, 0.0, 0.0, 0.0, 7.9593377e-13, 6.3239315e-13, -1.3683533e-12, -3.3583002e-12,
      -6.753506499999999e-11, -5.1069531e-11, 1.1413876e-10, 2.8886963e-10, 2.6130704e-8, 2.0529246e-8, -4.474577e-8, -1.1054977e-7,
      -9.6160198e-8, 9.648097099999999e-9, 9.9857966e-8, 5.312347799999999e-7, -7.8437136e-7, -0.000001350296, 0.0000019393909, 0.0000040340277,
      -0.0000042756633, -0.0000053244108, 0.0000081703425, 0.0000093387318, -1.5955554e-7, 0.0000053730519, -0.0000033880106, -0.000071543951,
      0.00009094828600000001, 0.00016742405, -0.00021075319, -0.0004944841499999999, 0.00050572369, 0.00064373234, -0.00099767183, -0.00093517257,
      0.0013226017, 0.00023579616, -0.0018202749, 0.0027128501, 0.00005199085, -0.0065177271, 0.0030889539, 0.018017381,
      -0.016482816, -0.026474392, 0.035105113, 0.042707457, -0.070871596, -0.040071693, 0.11582208, 0.020809495,
      -0.16571684, 0.024391395, 0.21913828, -0.1225116, -0.2170174, 0.23390508, 0.13334994, -0.28507333,
      -0.037333319, 0.30268512, -0.071040561, -0.29189115, 0.23459309, 0.11814362, -0.29366771, 0.168199,
      0.055144579, -0.20517408, 0.23406798, -0.10369417, -0.16592475, 0.30024422, -0.13665322, -0.10712787,
      0.20336628, -0.12304478, -0.012787691, 0.034758271, },
    { 0.0, 0.0, 0.0, 0.0, -1.2748221e-12, -1.0128842e-12, 2.1916484e-12, 5.3788837e-12,
      1.0921985e-10, 8.2631556e-11, -1.8461942e-10, -4.6710814e-10, -1.2157947e-9, -5.9037309e-10, 1.8031028e-9, 5.6089956e-9,
      2.8816076e-8, 1.7242481e-8, -4.5066022e-8, -1.2254137e-7, -1.0212736e-7, 2.8041794e-8, 8.8809173e-8, 5.15863e-7,
      -7.6703574e-7, -0.0000013448302, 0.0000019407723, 0.0000040046758, -0.0000041631243, -0.0000052761599, 0.000007990014, 0.0000094025477,
      -3.7236461e-7, 0.0000050912212, -0.0000031816081, -0.000070497896, 0.00009005617, 0.00016543404, -0.00020781314, -0.00049140692,
      0.00050388753, 0.00064366586, -0.0009956896499999999, -0.00094188997, 0.0013264845, 0.00025337108, -0.0018357686, 0.0026434454,
      0.00010431219, -0.0064094357, 0.0029459426, 0.017888665, -0.016208348, -0.026453452, 0.034900135, 0.042639749,
      -0.070925263, -0.04027267, 0.11533201, 0.023882331, -0.16561734, 0.020518705, 0.22247747, -0.12340487,
      -0.2241639, 0.23400827, 0.14119997, -0.2774529, -0.045453944, 0.30578931, -0.060811587, -0.32120566,
      0.22629458, 0.14143909, -0.2932926, 0.18901876, 0.059268121, -0.24117229, 0.23667102, -0.10932962,
      -0.18469158, 0.33038169, -0.098611492, -0.050527617, },
    { 0.0, 0.0, 0.0, 0.0, -1.1957895e-23, -9.4222313e-24, 2.0608172e-23, 5.0220109e-23,
      1.0491953e-22, 4.314021e-23, -1.5016783e-22, -4.9824641e-22, 1.442234e-22, 6.4439341e-22, -6.6049116e-22, -6.2852714e-22,
      7.7306433e-22, -1.7153432e-22, -3.6703031e-22, 2.3998726e-21, 2.3787518e-8, 1.8899893e-8, -4.089502e-8, -1.0036718e-7,
      -9.1381028e-8, 4.773524e-9, 9.8339297e-8, 5.0264551e-7, -6.6787209e-7, -0.0000012072564, 0.0000016961125, 0.0000034579349,
      -0.0000043011076, -0.0000049521991, 0.0000079675964, 0.000010237278, -6.1866699e-7, 0.0000026148365, -6.6753709e-7, -0.000062941151,
      0.00008091389800000001, 0.00015367342, -0.00019217485, -0.00046113989, 0.00047238288, 0.00061502943, -0.00093819179, -0.00095701101,
      0.0013112531, 0.00036070637, -0.0018631093, 0.0022451801, 0.00035463833, -0.0057958687, 0.0023086156, 0.016757115,
      -0.014807134, -0.025281505, 0.032288107, 0.042350832, -0.06623280400000001, -0.040838204, 0.10990365, 0.024012049,
      -0.16246351, 0.01632983, 0.21889693, -0.10804326, -0.21710906, 0.22495868, 0.13671564, -0.29314566,
      -0.049448497, 0.30568883, -0.036034483, -0.32110046, 0.24258397, 0.18749043, -0.41990029, 0.17429974,
      0.14715901, -0.27307926, 0.27262049, -0.13077844, },
    { 0.0, 0.0, 0.0, 0.0, -1.1573241e-23, -9.2381678e-24, 1.9865137e-23, 4.8930224e-23,
      1.1706339e-22, 5.6286956e-23, -1.7324546e-22, -5.5311775e-22, -1.6848279e-22, 4.316996e-22, -1.5922221e-22, 7.5685334e-22,
      3.4316913e-22, -1.7509105e-21, 1.3472139e-21, 3.3351924e-21, -4.5929126e-10, -3.6492062e-10, 7.8960427e-10, 1.9378973e-9,
      2.5820175e-8, 1.902087e-8, -4.3254959e-8, -1.1120419e-7, -1.2565313e-7, -8.519962999999999e-9, 1.4601723e-7, 6.3621432e-7,
      -2.6331083e-7, -0.0000010138949, 0.00000110968, 0.0000016838337, -0.0000035744646, -0.0000026460073, 0.0000053205335, 0.000007853747200000001,
      8.9215155e-8, 3.1123563e-7, 0.0000013795845, -0.000044677231, 0.00006865306099999999, 0.00011781359, -0.00015710027, -0.00036064286,
      0.00038031484, 0.00050338751, -0.00077590559, -0.0008674142, 0.0010777226, 0.00039442868, -0.0015444235, 0.0016459382,
      0.00035101212, -0.0046446429, 0.0018138366, 0.01452449, -0.013180724, -0.022957383, 0.028828912, 0.041597157,
      -0.061093708, -0.041857191, 0.10188836, 0.033085447, -0.15855498, -0.0034829442, 0.23182062, -0.090326764,
      -0.24246823, 0.22358741, 0.14781968, -0.26594426, -0.097818221, 0.28723329, 0.07952021200000001, -0.41757914,
      0.21073239, 0.2897774, -0.48889789, 0.22573225, },
    { 0.0, 0.0, 0.0, 0.0, -1.0733383e-23, -8.6079257e-24, 1.872705e-23, 4.5550867e-23,
      4.5417363e-23, -1.2189591e-25, -4.7937773e-23, -2.4038838e-22, 2.7755606e-22, 5.4224665e-22, -7.515297e-22, -1.4797002e-21,
      1.0502481e-21, 1.4065423e-21, -1.940141e-21, -6.9675157e-22, 1.4806259e-8, 1.1764015e-8, -2.5454621e-8, -6.247236e-8,
      -1.3486342e-7, -5.8989698e-8, 1.9527931e-7, 6.419069e-7, 1.1234638e-7, -5.855622599999999e-7, 3.4054381e-7, -4.5951567e-7,
      -0.0000013005443, 9.7272754e-7, 2.3198668e-7, -4.0989736e-7, 0.00000479093, 0.0000044838884, -0.000006090609, -0.000028617073,
      0.000020212565, 0.000037572762, -0.000049522919, -0.000030274147, 0.000059032777, 4.0388774e-7, -0.000078724649, 0.00008755813499999999,
      0.00012618231, -0.00018340068, -0.000059928571, 0.00036247195, -0.00015621759, -0.00031281978, 0.00022071986, 0.000021631567,
      -0.0023678938, -0.0016216755, 0.0046514578, 0.0060223091, -0.0016579749, -0.0022419727, 0.00179991, -0.003098703,
      -0.031223321, -0.015841757, 0.053425774, 0.058517397, -0.03700466, -0.026055767, 0.044009586, -0.030427122,
      -0.17559441, -0.0033383422, 0.33021097, 0.014343156, -0.23379297, 0.10912792, 0.010642794, -0.24289997,
      -0.17351534, 0.4024428, 0.46042496, -0.56361982, },
    { 0.37382874, -0.51867853, 0.47943749, -0.09378391899999999, -0.18905132, 0.29135353, -0.16447188, -0.07414341200000001,
      0.26094242, -0.23048843, 0.053840185, 0.12786236, -0.1799737, 0.10120967, 0.0045846861, -0.07467683,
      0.08096257900000001, -0.039817601, -0.013746566, 0.036482493, -0.028176001, 0.009026072, 0.0074018258, -0.0070228506,
      0.0057997749, -0.0036799712, -0.0028406099, 0.0018390274, 1.0642048e-17, -2.3879718e-17, 1.2954511e-17, 1.4028154e-17,
      -1.4083962e-17, 7.6461113e-18, 2.0534728e-18, -6.184756e-18, 8.647686299999999e-18, -2.4031171e-18, -3.2001736e-18, 4.6656292e-18,
      -2.3971523e-19, 3.7425143e-20, 1.7166598e-18, -2.1279204e-19, -6.6740118e-19, 1.5729731e-19, -4.4520642e-19, -4.4010561e-19,
      8.861819300000001e-19, -1.5574435e-20, -1.5525456e-19, 3.1233122e-19, -3.2127869e-19, -9.465079100000001e-20, 8.2112468e-20, -6.74227e-20,
      -2.618406e-20, 9.9322619e-20, -1.5963306e-20, -4.8528886e-20, 1.2366602e-20, -5.19528e-20, -1.0067795e-20, 3.7232067e-20,
      -2.9793349e-20, 2.8624007e-21, 9.8584485e-21, -1.3461486e-21, 4.4190518e-21, -9.6223827e-21, -6.3801957e-21, 2.9912514e-21,
      3.1636145e-21, -2.3855177e-22, -4.4689007e-22, 8.2869664e-22, -7.0758818e-23, -1.2663701e-22, -7.723131e-23, -9.1997408e-24,
      0.0, 0.0, 0.0, 0.0, },
    { -0.03134196, -0.17628012, 0.35590505, -0.50759131, 0.53725117, -0.45869154, 0.26412691, -0.076134326,
      -0.007651761, -0.0021413273, 0.022998087, -0.047846877, 0.055539014, -0.025170751, -0.012140822, 0.032370535,
      -0.029020686, 0.015322765, -0.00035189435, -0.0094576725, 0.0073349447, -0.00025913263, -0.0029728115, 0.00072206717,
      -0.00059596822, 0.0014931631, 0.00129906, -0.00046872852, -0.00047383082, 0.00030064681, 0.00023207255, -0.00015024512,
      8.7917553e-18, 3.9419635e-18, 5.4735481e-19, 2.4625179e-18, -3.8542589e-18, 2.3167755e-19, 1.966174e-18, -1.1347933e-18,
      -6.7944871e-19, 4.0203463e-19, -1.9518285e-19, -2.2669119e-19, 5.6957285e-19, -3.1249475e-19, 7.4451522e-20, 2.8108751e-19,
      -4.0423298e-19, -9.275415100000001e-21, 5.3010949e-20, -2.2545586e-20, 1.1869787e-19, -5.9328308e-20, -3.3977341e-20, 5.9668567e-20,
      -4.12458e-21, -3.107239e-20, -1.4927732e-20, 3.7425643e-21, 1.7937482e-20, 1.4043326e-20, -7.4193836e-22, -3.6709159e-21,
      2.4343311e-21, -2.8813358e-22, -7.7778006e-22, -4.9534229e-22, -1.8648303e-21, 2.2475477e-21, 1.3430748e-21, -9.8408921e-22,
      -2.0997709e-22, 5.6528297e-23, 6.807894400000001e-23, -7.0085213e-23, -6.2883165e-23, 6.8688301e-23, 5.0209405e-23, -2.238441e-23,
      0.0, 0.0, 0.0, 0.0, },
    { -0.030822248, 0.12957914, -0.18512573, 0.16675695, -0.052857771, -0.13908969, 0.35276876, -0.49791235,
      0.51417242, -0.41258809, 0.26195585, -0.11804311, 0.023964219, 0.0010232861, 0.019152748, -0.044474532,
      0.047642352, -0.027203395, -0.0031796077, 0.027978106, -0.033547664, 0.020082559, -0.0007510504099999999, -0.011684609,
      0.009989718599999999, -0.0019747698, -0.0029026379, 0.0026834211, -0.002285624, 0.0018836202, 0.0016300179, -0.00085116188,
      -2.7174786e-17, 2.4608677e-17, -5.4277816e-18, -1.5178824e-17, 1.5015794e-17, -4.5329942e-18, 5.0668817e-18, 6.2404078e-18,
      -9.9984244e-18, 4.9554126e-18, 1.637905e-18, -2.8010555e-18, 3.3434367e-18, -2.1472836e-18, -6.7005628e-19, 1.7342157e-18,
      -7.3535143e-19, 3.8043225e-19, 2.1005548e-19, -4.6648549e-19, 2.3804352e-19, -6.6845216e-20, -1.9323802e-19, 6.5692847e-20,
      2.8876787e-20, -8.108969599999999e-21, 4.8925104e-20, 1.6282379e-20, -7.870229800000001e-20, 1.2005518e-20, -3.4489745e-21, -2.1516959e-20,
      2.5544882e-20, -2.6720197e-21, -6.2833653e-22, 1.1517223e-20, -9.406839299999999e-21, -2.564765e-21, 4.7206229e-22, -2.3146181e-22,
      1.3258513e-21, -8.4052303e-22, -7.1310092e-22, 5.6324852e-22, 5.6863617e-22, -2.894814e-22, -2.3203236e-22, 1.7479559e-22,
      0.0, 0.0, 0.0, 0.0, },
    { 0.025421777, -0.067751664, 0.083134478, -0.052379526, -0.022274344, 0.12127978, -0.18958, 0.17343447,
      -0.05080082, -0.14787227, 0.35019791, -0.48373671, 0.50542054, -0.41685964, 0.26577468, -0.11826206,
      0.02521028, 0.00094495453, 0.017027144, -0.043362773, 0.049765927, -0.029643921, -0.0032568805, 0.029534942,
      -0.034563771, 0.020453298, -0.00076002331, -0.012130441, 0.010544552, -0.0022418113, -0.0031245172, 0.0028394937,
      -0.0023731879, 0.0019425839, 0.0016769152, -0.00087992019, -5.2958493e-18, -4.0877396e-18, 2.772253e-18, -2.0311297e-18,
      -2.288765e-18, 7.9289036e-18, 2.5284364e-18, -2.5402696e-18, 9.968205199999999e-19, -5.0944616e-19, 3.9140977e-19, 1.4230412e-18,
      -1.2705171e-18, -6.1873396e-20, 3.8139103e-19, 1.7084439e-19, 2.5432643e-19, -3.3303833e-19, -1.4171105e-19, 4.2784771e-20,
      5.5757122e-20, -2.5390025e-20, -1.0232878e-19, 3.4361784e-20, 7.5020104e-20, -1.3646375e-20, 2.4618801e-20, 1.8847275e-20,
      -5.9354063e-20, 1.3866702e-20, -4.6895811e-21, -1.278071e-20, 1.7077252e-20, -8.771959499999999e-21, 4.4899158e-22, 1.03643e-20,
      -1.0025575e-20, -2.4458956e-21, -9.209271300000001e-22, -1.5410242e-21, 3.3222615e-21, -9.566303300000001e-22, -8.9521542e-22, 9.720106e-22,
      0.0, 0.0, 0.0, 0.0, },
    { -0.0071228475, 0.019049761, -0.024644883, 0.010765621, 0.023054686, -0.065592104, 0.084161342, -0.055948254,
      -0.023192439, 0.12405666, -0.19005779, 0.17094339, -0.04939618, -0.14612657, 0.34892501, -0.48406091,
      0.5052392999999999, -0.41645337, 0.26618139, -0.11881742, 0.024890949, 0.0016351911, 0.017138476, -0.043848154,
      0.049926304, -0.02967179, -0.0032277214, 0.029567187, -0.034684308, 0.020548686, -0.00069180842, -0.012172774,
      0.010553003, -0.0022464053, -0.0031296428, 0.0028424184, -0.0023745904, 0.0019437318, 0.0016779062, -0.00088044017,
      -1.8475243e-17, 1.4568058e-17, -2.0010569e-18, -1.4842759e-17, 9.308017300000001e-18, 2.7885175e-18, 1.4098213e-18, 7.8711632e-19,
      -4.1060061e-18, 3.3844641e-18, 1.6399896e-18, -2.4498493e-18, 4.7428963e-19, 8.4630943e-19, -4.6354074e-19, -1.2947061e-19,
      2.8272731e-19, 1.5542018e-19, 2.3918721e-19, -2.0130475e-19, -2.9555998e-19, 2.7180211e-19, 9.5026985e-20, -2.3738958e-19,
      5.1395559e-20, 1.2154465e-20, 2.7573762e-20, 5.0529356e-20, -7.842936e-20, -2.2160648e-20, 1.9633519e-20, 8.7787609e-21,
      -2.3803114e-21, -1.0067923e-20, -7.660827199999999e-21, 2.4925729e-21, 9.6896307e-21, -5.5581321e-21, -4.3914061e-21, 3.0391488e-21,
      0.0, 0.0, 0.0, 0.0, },
    { -0.0018057424, -0.0016866646, 0.0069035273, -0.0041188241, -0.0064422689, 0.018372935, -0.025072938, 0.012034045,
      0.023684689, -0.066573572, 0.084151978, -0.054928148, -0.023777293, 0.12329836, -0.18937441, 0.17096458,
      -0.049532242, -0.14576154, 0.3484839, -0.48395708, 0.50564701, -0.41694937, 0.26615718, -0.11857785,
      0.024683551, 0.0018054855, 0.017143896, -0.044001563, 0.050065196, -0.029716819, -0.0032594908, 0.029601577,
      -0.034723419, 0.020572699, -0.00067340378, -0.012185211, 0.010554037, -0.0022469977, -0.0031302016, 0.0028427593,
      -0.0023746848, 0.0019438091, 0.0016779729, -0.00088047518, -2.0693739e-17, 8.560389100000001e-18, -4.7354788e-18, -1.0263813e-17,
      1.0286909e-17, 2.8410305e-18, 2.8973959e-18, 3.0084238e-18, -5.0483408e-18, 6.748686e-19, 1.0579793e-18, -1.0668294e-18,
      7.5172508e-19, -8.7941528e-20, -3.5368006e-19, 3.726905e-19, 3.9127407e-19, -2.2086158e-19, -2.5947048e-20, -8.9091678e-20,
      -2.4548966e-20, 1.9645497e-19, -4.8562499e-20, -1.6401124e-19, 1.1905575e-19, 6.000222099999999e-20, 3.6002571e-20, 1.1443347e-20,
      -7.0656252e-20, 2.7338021e-20, 2.4165017e-20, -2.1090532e-20, 1.1579904e-21, -4.3668812e-22, -4.3928957e-22, 3.7120868e-22,
      0.0, 0.0, 0.0, 0.0, },
    { 0.00068393172, -0.0023926981, 0.00072610966, 0.0010990308, -0.0018198967, -0.0019500797, 0.0070152584, -0.0036896504,
      -0.0065067349, 0.018163296, -0.02497928, 0.011948147, 0.023789348, -0.066379495, 0.083933271, -0.054793027,
      -0.023683757, 0.12297215, -0.18920335, 0.17105637, -0.049743734, -0.14562801, 0.34847623, -0.48400863,
      0.50575808, -0.41704877, 0.26614614, -0.118491, 0.024627691, 0.0018094971, 0.017148822, -0.044012176,
      0.050085326, -0.029729752, -0.0032694011, 0.029607998, -0.034723337, 0.020572644, -0.00067351244, -0.012185184,
      0.010554055, -0.0022469936, -0.0031302016, 0.0028427628, -0.0023746918, 0.0019438149, 0.0016779778, -0.00088047778,
      -2.3067914e-17, 5.4003058e-18, -1.251809e-18, -5.2066413e-18, 7.792644200000001e-18, -3.7935423e-19, 3.7777487e-19, 3.4931246e-18,
      -2.7529126e-18, 5.0329172e-19, 1.6457288e-19, -6.692252e-19, 9.4932395e-19, -6.4945309e-19, 1.0398817e-19, 1.9002636e-19,
      -1.7541128e-19, -3.5753619e-20, -1.0769248e-20, -1.2646435e-19, 9.2812895e-20, -1.1354876e-19, -3.8668441e-20, 5.710273e-20,
      -3.4373439e-20, 1.9479008e-20, 9.9343437e-21, -9.122147999999999e-21, 6.8532923e-21, -9.546463e-21, -6.5673988e-21, 2.5025079e-21,
      0.0, 0.0, 0.0, 0.0, },
    { 0.0010687183, -0.0010450744, -0.0010070066, 0.0020253044, 0.0005517824499999999, -0.0022959155, 0.00097057671, 0.0010924508,
      -0.0019312501, -0.0017546407, 0.0070874093, -0.0040113854, -0.006331699, 0.018446531, -0.025235592, 0.012062147,
      0.02384824, -0.066697913, 0.084157576, -0.054739183, -0.023923087, 0.12315927, -0.18921469, 0.17097969,
      -0.049615501, -0.14573626, 0.34846795, -0.48391368, 0.5056902599999999, -0.41703911, 0.26615604, -0.11850642,
      0.02465109, 0.0017948116, 0.01713781, -0.044004865, 0.050085147, -0.029729697, -0.0032693156, 0.029607987,
      -0.03472338, 0.020572672, -0.00067355155, -0.012185201, 0.010554082, -0.0022469952, -0.0031302068, 0.0028427695,
      -0.0023746995, 0.0019438212, 0.0016779833, -0.00088048065, -2.1000047e-17, 7.565723700000001e-18, 2.5190234e-18, -7.738874199999999e-18,
      5.1613258e-18, 1.8630382e-18, 4.7500716e-18, 1.5683656e-18, -3.5332673e-18, 2.0768143e-18, -1.4987312e-18, -3.5413893e-21,
      2.4420979e-18, -1.345524e-18, 4.3500825e-20, 6.943662e-19, -6.1374977e-19, 1.0242197e-18, 2.718543e-20, -8.3072249e-19,
      5.9251615e-19, -4.9885031e-20, -4.0607809e-20, 1.0117644e-19, -2.4097676e-19, 1.301706e-19, 1.0250316e-19, -7.4365919e-20,
      0.0, 0.0, 0.0, 0.0, },
    { 0.00056402136, 0.00021333467, -0.00091125097, 0.00036685809, 0.0010149448, -0.00096200703, -0.00094793227, 0.0018387994,
      0.00040516071, -0.0021710487, 0.0010161009, 0.0009399139400000001, -0.0018566059, -0.0016341052, 0.0069538839, -0.0040202907,
      -0.0062841631, 0.018383441, -0.02517064, 0.012052401, 0.02377528, -0.066607666, 0.084161445, -0.054781921,
      -0.02388942, 0.12313141, -0.18921571, 0.17100415, -0.049638042, -0.14572902, 0.34847456, -0.48392014,
      0.50569705, -0.41704335, 0.26615332, -0.11850458, 0.02465106, 0.0017948162, 0.0171379, -0.044004883,
      0.050085129, -0.029729696, -0.0032693338, 0.029607991, -0.034723382, 0.020572681, -0.00067355989, -0.012185204,
      0.010554086, -0.0022469929, -0.0031302058, 0.0028427698, -0.0023747013, 0.0019438227, 0.0016779846, -0.0008804813,
      -9.379688700000001e-18, 2.6146403e-18, 1.5746634e-18, -1.0728369e-17, 4.5804656e-18, 7.107964500000001e-18, 2.3260764e-18, -1.9169252e-19,
      -7.0226566e-19, -1.873713e-18, 9.4236304e-19, 4.1572967e-19, -1.2076212e-18, 7.4089255e-19, -2.6527306e-20, -6.578718e-19,
      8.7291408e-19, -4.7704746e-21, -8.057007799999999e-20, 1.7753254e-19, -2.2058122e-19, 7.1324509e-20, 6.6889699e-20, -6.6102385e-20,
      0.0, 0.0, 0.0, 0.0, },
    { 0.00014271253, 0.00023780917, -0.00025714186, -0.00024317058, 0.00057409128, 0.00023010554, -0.00093069112, 0.00027243145,
      0.00094306671, -0.00094563757, -0.00092816994, 0.001821437, 0.00041076611, -0.0021577244, 0.00098623583, 0.00091431244,
      -0.0018365761, -0.0016126829, 0.0069466743, -0.0040339626, -0.0062805659, 0.018399842, -0.025165617, 0.012042197,
      0.023770284, -0.066603485, 0.08416202, -0.054785429, -0.023889813, 0.12313399, -0.18921405, 0.17100357,
      -0.049638649, -0.14572867, 0.34847509, -0.48392049, 0.5056971, -0.4170434, 0.26615338, -0.11850462,
      0.024651084, 0.0017947992, 0.017137901, -0.044004876, 0.050085122, -0.029729693, -0.0032693353, 0.02960799,
      -0.034723382, 0.020572683, -0.00067356152, -0.012185204, 0.010554086, -0.0022469925, -0.0031302055, 0.0028427698,
      -0.0023747016, 0.0019438229, 0.0016779848, -0.00088048141, -2.8978181e-17, 8.47362e-18, -4.2763004e-18, -6.8278819e-18,
      1.0819706e-17, 1.2087701e-18, 1.1162283e-18, 2.1511478e-18, -3.1994618e-18, 5.9178468e-19, 2.1698119e-19, -1.3697938e-18,
      9.570426299999999e-19, 1.7932389e-19, 9.624209700000001e-20, 1.6376431e-19, -2.5332735e-19, 9.4050075e-20, 7.611858e-20, -7.3344331e-20,
      0.0, 0.0, 0.0, 0.0, },
    { 0.0000018447549, 0.000053840851, -0.000026051496, -0.00017560402, 0.00015359699, 0.0002298131, -0.00027785099, -0.00026917927,
      0.0005488749299999999, 0.00021718602, -0.00092552858, 0.0002822896, 0.00093939925, -0.00095067092, -0.00093089337, 0.0018096997,
      0.00041718788, -0.0021417498, 0.00097583578, 0.00090879181, -0.0018277373, -0.0016127741, 0.006949134, -0.0040349802,
      -0.0062864137, 0.018404312, -0.025165254, 0.012038182, 0.023772235, -0.066602884, 0.084162157, -0.054785014,
      -0.023890803, 0.1231346, -0.18921358, 0.17100325, -0.049638615, -0.1457287, 0.34847512, -0.48392051,
      0.50569712, -0.41704341, 0.26615339, -0.11850462, 0.024651086, 0.0017947971, 0.017137901, -0.044004875,
      0.050085122, -0.029729693, -0.0032693359, 0.02960799, -0.034723382, 0.020572683, -0.00067356177, -0.012185204,
      0.010554086, -0.0022469924, -0.0031302055, 0.0028427698, -0.0023747016, 0.0019438229, 0.0016779848, -0.00088048143,
      -3.6791394e-17, 4.052262e-18, -1.969778e-18, -7.0296556e-18, 9.7759458e-18, -3.3222873e-18, 4.6273224e-19, 5.2111855e-18,
      -4.4401574e-18, -1.2256545e-18, -5.4477758e-19, -6.7353127e-19, 1.469541e-18, -4.7402283e-19, -4.2509837e-19, 4.3223452e-19,
      0.0, 0.0, 0.0, 0.0, },
    { -0.0000065232055, 3.1277378e-7, 0.0000025601527, -0.000023637333, 0.0000027834083, 0.000051419076, -0.000029530267, -0.00017738859,
      0.00015142412, 0.00022660426, -0.00027806924, -0.00026668364, 0.00054837847, 0.0002158698, -0.00092505622, 0.00028086916,
      0.00093984668, -0.00094828387, -0.00093257586, 0.0018090192, 0.00041872951, -0.0021422683, 0.00097615257, 0.00090894629,
      -0.0018286964, -0.0016120872, 0.0069491938, -0.0040356127, -0.0062860363, 0.018404337, -0.025165282, 0.012038277,
      0.023772074, -0.066602783, 0.08416222499999999, -0.05478506, -0.023890801, 0.1231346, -0.18921358, 0.17100324,
      -0.049638612, -0.1457287, 0.34847512, -0.48392051, 0.50569712, -0.41704341, 0.26615339, -0.11850462,
      0.024651086, 0.001794797, 0.017137901, -0.044004875, 0.050085122, -0.029729693, -0.003269336, 0.02960799,
      -0.034723382, 0.020572683, -0.00067356178, -0.012185204, 0.010554086, -0.0022469924, -0.0031302055, 0.0028427698,
      -0.0023747016, 0.0019438229, 0.0016779848, -0.00088048143, -1.6713031e-17, 5.5425368e-19, 1.4245021e-18, -1.0072591e-18,
      5.3286569e-18, 1.4946097e-18, 2.8736484e-19, 9.387527700000001e-19, -4.2179426e-19, -9.975578300000001e-19, -5.809857e-19, -5.1089939e-20,
      0.0, 0.0, 0.0, 0.0, },
    { -0.0000010713313, -0.0000062302572, 0.0000055244516, 0.0000061175856, -0.0000071482518, 3.4513491e-9, 0.0000030429546, -0.000021759169,
      0.0000044190563, 0.000051269961, -0.000030117431, -0.00017718171, 0.00015149658, 0.0002263981, -0.00027757249, -0.00026613844,
      0.00054793064, 0.00021538327, -0.00092477868, 0.00028111234, 0.00093967287, -0.00094853506, -0.0009326781, 0.0018092101,
      0.00041887081, -0.0021424066, 0.00097614709, 0.00090906261, -0.0018287172, -0.0016121413, 0.0069491642, -0.0040356085,
      -0.0062860096, 0.018404321, -0.0251653, 0.01203829, 0.023772072, -0.066602781, 0.08416222199999999, -0.054785057,
      -0.023890803, 0.1231346, -0.18921358, 0.17100324, -0.049638612, -0.1457287, 0.34847512, -0.48392051,
      0.50569712, -0.41704341, 0.26615339, -0.11850462, 0.024651086, 0.001794797, 0.017137901, -0.044004875,
      0.050085122, -0.029729693, -0.003269336, 0.02960799, -0.034723382, 0.020572683, -0.00067356178, -0.012185204,
      0.010554086, -0.0022469924, -0.0031302055, 0.0028427698, -0.0023747016, 0.0019438229, 0.0016779848, -0.00088048143,
      -1.8941367e-17, 1.5711291e-18, 2.3452836e-18, -3.899545e-18, 3.6296061e-18, -1.9151907e-19, -4.1068595e-19, 9.915058199999999e-19,
      0.0, 0.0, 0.0, 0.0, },
    { -9.0889843e-7, -2.2626776e-7, 0.000001260977, 0.0000044608021, -0.0000011469721, -0.0000059094081, 0.0000061283667, 0.0000069729643,
      -0.000006297129, 3.7634729e-7, 0.0000029524362, -0.00002191209, 0.0000043424749, 0.000051262029, -0.000029845963, -0.00017685033,
      0.00015126363, 0.00022604271, -0.00027738458, -0.00026596286, 0.00054779433, 0.00021525271, -0.0009248599599999999, 0.00028119182,
      0.0009397919999999999, -0.00094860626, -0.00093268933, 0.001809279, 0.00041885032, -0.0021424302, 0.00097613531, 0.00090905965,
      -0.0018287021, -0.0016121504, 0.0069491565, -0.0040356031, -0.0062860105, 0.018404322, -0.0251653, 0.01203829,
      0.023772071, -0.06660278, 0.08416222199999999, -0.054785057, -0.023890803, 0.1231346, -0.18921358, 0.17100324,
      -0.049638612, -0.1457287, 0.34847512, -0.48392051, 0.50569712, -0.41704341, 0.26615339, -0.11850462,
      0.024651086, 0.001794797, 0.017137901, -0.044004875, 0.050085122, -0.029729693, -0.003269336, 0.02960799,
      -0.034723382, 0.020572683, -0.00067356178, -0.012185204, 0.010554086, -0.0022469924, -0.0031302055, 0.0028427698,
      -0.0023747016, 0.0019438229, 0.0016779848, -0.00088048143, 6.1878754e-18, -3.6655866e-18, -2.9841768e-18, 1.9922148e-18,
      0.0, 0.0, 0.0, 0.0, },
    { 1.3144978e-7, 9.8657161e-8, -2.2253182e-7, -5.6333606e-7, -8.9434942e-7, -2.5701115e-7, 0.0000011890586, 0.0000043393418,
      -0.0000012646187, -0.0000059468393, 0.0000061464536, 0.0000069842975, -0.000006287677, 3.8234005e-7, 0.000002913009, -0.000021955667,
      0.000004374943, 0.000051305901, -0.000029868643, -0.00017687301, 0.00015127913, 0.00022606239, -0.00027737419, -0.00026597498,
      0.00054778017, 0.00021526158, -0.00092485866, 0.00028118337, 0.00093979398, -0.00094860284, -0.00093268751, 0.0018092791,
      0.0004188485, -0.0021424291, 0.00097613632, 0.00090905895, -0.001828702, -0.0016121505, 0.0069491567, -0.0040356032,
      -0.0062860104, 0.018404322, -0.0251653, 0.01203829, 0.023772071, -0.06660278, 0.08416222199999999, -0.054785057,
      -0.023890803, 0.1231346, -0.18921358, 0.17100324, -0.049638612, -0.1457287, 0.34847512, -0.48392051,
      0.50569712, -0.41704341, 0.26615339, -0.11850462, 0.024651086, 0.001794797, 0.017137901, -0.044004875,
      0.050085122, -0.029729693, -0.003269336, 0.02960799, -0.034723382, 0.020572683, -0.00067356178, -0.012185204,
      0.010554086, -0.0022469924, -0.0031302055, 0.0028427698, -0.0023747016, 0.0019438229, 0.0016779848, -0.00088048143,
      0.0, 0.0, 0.0, 0.0, },
    { 0.0, 0.0, 0.0, 0.0, -1.622356e-9, -1.2890103e-9, 2.7891217e-9, 6.845241e-9,
      1.3126578e-7, 9.901721900000001e-8, -2.2166186e-7, -5.6183755e-7, -8.9289394e-7, -2.5656308e-7, 0.0000011888122, 0.0000043391602,
      -0.0000012647803, -0.0000059469017, 0.0000061469773, 0.0000069850389, -0.0000062879678, 3.8158828e-7, 0.0000029133662, -0.000021955518,
      0.0000043746943, 0.000051306159, -0.000029869367, -0.00017687376, 0.00015128051, 0.00022606404, -0.00027737624, -0.00026598254,
      0.00054778393, 0.00021526722, -0.00092486527, 0.00028119529, 0.00093978004, -0.0009486419, -0.00093265228, 0.0018094229,
      0.00041867283, -0.0021426906, 0.00097650436, 0.00090964586, -0.0018293513, -0.0016126855, 0.0069502949, -0.0040354262,
      -0.0062870574, 0.018405222, -0.025164144, 0.012032827, 0.023774346, -0.066591942, 0.084151854, -0.054804601,
      -0.023862503, 0.12315689, -0.1892543, 0.17095475, -0.049559377, -0.14567882, 0.3483179, -0.4838932,
      0.50588033, -0.41713971, 0.26600252, -0.11841888, 0.024871591, 0.0016210723, 0.016891466, -0.043640211,
      0.050057842, -0.03006571, -0.0030367974, 0.029556911, -0.034590027, 0.020929563, -0.0012983588, -0.012419997,
      0.010951201, -0.002389025, -0.0031262218, 0.0028105997, },
    { 0.0, 0.0, 0.0, 0.0, -3.6439133e-24, -2.8986979e-24, 6.2660146e-24, 1.5379692e-23,
      -1.6222016e-9, -1.2888876e-9, 2.7888562e-9, 6.8445893e-9, 1.312523e-7, 9.9007009e-8, -2.2163906e-7, -5.6177991e-7,
      -8.9272771e-7, -2.5647732e-7, 0.0000011885618, 0.0000043383995, -0.0000012650025, -0.0000059463278, 0.0000061467672, 0.0000069861743,
      -0.0000062897555, 3.7727988e-7, 0.0000029191314, -0.000021941306, 0.0000043687192, 0.000051291624, -0.000029855051, -0.00017686176,
      0.00015125309, 0.0002260747, -0.00027735745, -0.00026608583, 0.00054791784, 0.00021551982, -0.00092512611, 0.00028035321,
      0.00094065862, -0.00094742205, -0.00093450757, 0.0018076545, 0.00042131052, -0.0021417278, 0.00097239854, 0.00091159722,
      -0.0018264239, -0.0016199728, 0.0069502154, -0.0040114121, -0.0063040316, 0.018365516, -0.025118693, 0.012102578,
      0.023644377, -0.066685113, 0.084356401, -0.054595596, -0.024125527, 0.12301898, -0.1887722, 0.17066016,
      -0.050419921, -0.14528907, 0.34913412, -0.4838335, 0.50558311, -0.41643331, 0.26613447, -0.12101845,
      0.024625157, 0.0033560726, 0.016841212, -0.041760408, 0.050984407, -0.03285494, -0.004117546, 0.028617951,
      -0.035237369, 0.023732977, 0.0015240184, -0.008435701800000001, },
    { 0.0, 0.0, 0.0, 0.0, -1.0431812e-23, -8.2803737e-24, 1.7939522e-23, 4.4007904e-23,
      6.4884103e-23, 1.7524634e-23, -8.5803103e-23, -3.2496948e-22, -1.6203806e-9, -1.2874408e-9, 2.7857256e-9, 6.836906e-9,
      1.3109947e-7, 9.889150299999999e-8, -2.2138082e-7, -5.611261e-7, -8.9219889e-7, -2.5658335e-7, 0.0000011880548, 0.0000043354995,
      -0.0000012608301, -0.000005938918, 0.0000061362301, 0.0000069641375, -0.0000062687907, 4.0459468e-7, 0.0000028787034, -0.000021983378,
      0.0000044129115, 0.000051289938, -0.000029905595, -0.00017666359, 0.00015087211, 0.00022542775, -0.0002765433, -0.00026376228,
      0.00054507147, 0.00021169912, -0.00091924555, 0.00028840249, 0.00093079662, -0.00095471267, -0.00091771013, 0.0018095019,
      0.00040700431, -0.0021236987, 0.0009811498199999999, 0.0008245475, -0.0017754444, -0.0014644008, 0.0068040412, -0.0043451443,
      -0.0058442993, 0.018818003, -0.025939109, 0.011340895, 0.024930389, -0.0661234, 0.082217785, -0.054081764,
      -0.020897545, 0.12165048, -0.1920747, 0.17211359, -0.048140833, -0.14851256, 0.3472333, -0.47646397,
      0.50599354, -0.42288577, 0.26917601, -0.12432367, 0.022587169, 0.010412511, 0.015359906, -0.041565257,
      0.055431988, -0.038165138, -0.009985203099999999, 0.018675575, },
    { 0.0, 0.0, 0.0, 0.0, 3.2812725e-24, 2.5848368e-24, -5.6275193e-24, -1.3782151e-23,
      -2.3902558e-23, -8.1365251e-24, 3.3008241e-23, 1.1640815e-22, -7.3250277e-23, -1.8762401e-22, 2.2730087e-22, 3.3780674e-22,
      -1.616205e-9, -1.2841231e-9, 2.778547e-9, 6.8192879e-9, 1.3237482e-7, 9.9918388e-8, -2.2358368e-7, -5.6648665e-7,
      -8.9932696e-7, -2.5816482e-7, 0.0000011972154, 0.0000043720435, -0.000001292952, -0.0000060081096, 0.0000062263636, 0.000007122935,
      -0.0000063986485, 2.6724076e-7, 0.0000030929214, -0.000021946257, 0.0000047207535, 0.000052048986, -0.000030742059, -0.00018076981,
      0.00015544318, 0.00023291138, -0.00028644303, -0.00028176127, 0.00056447015, 0.0002311271, -0.00095483998, 0.00027379593,
      0.00096725386, -0.0009771671, -0.00095367853, 0.0019658873, 0.00033910824, -0.0024180526, 0.0012134667, 0.0015009697,
      -0.0026057442, -0.0024276335, 0.0084128255, -0.0028188375, -0.008494489799999999, 0.017721873, -0.021825093, 0.010970745,
      0.018597655, -0.064282876, 0.08981873999999999, -0.057812995, -0.02662704, 0.12911772, -0.1885168, 0.15985436,
      -0.050361919, -0.13554452, 0.34264685, -0.47581746, 0.51144248, -0.43326474, 0.2710083, -0.12265704,
      0.015729342, 0.016261307, 0.026089652, -0.029242654, },
    { 0.0, 0.0, 0.0, 0.0, -2.2778956e-24, -1.8076424e-24, 3.9250879e-24, 9.6136326e-24,
      2.5282692e-23, 1.2550767e-23, -3.7660392e-23, -1.1740747e-22, -2.9437921e-23, 9.5145047e-23, -4.2770808e-23, 1.4239399e-22,
      1.9286708e-23, -4.034217e-22, 3.6553584e-22, 9.7305538e-22, -1.4431934e-9, -1.1466603e-9, 2.481109e-9, 6.0892965e-9,
      1.2633458e-7, 9.568202499999999e-8, -2.136268e-7, -5.4014939e-7, -8.7095084e-7, -2.5802661e-7, 0.000001165696, 0.000004230512,
      -0.0000012146636, -0.0000057632352, 0.0000059410362, 0.000006652386, -0.0000059549064, 6.5404746e-7, 0.0000024605114, -0.000022134786,
      0.0000037026798, 0.000049710525, -0.000028167748, -0.00016723509, 0.00014401584, 0.00021121699, -0.00026020494, -0.00023896016,
      0.00052168195, 0.0001958936, -0.00088205854, 0.0002546882, 0.0009008995099999999, -0.00085354557, -0.00092916911, 0.0015016721,
      0.00054407697, -0.0017561327, 0.0006602936, 0.00048076711, -0.00071974471, -0.0009798873499999999, 0.0049969489, -0.004765169,
      -0.0048724692, 0.017594955, -0.026661957, 0.015885895, 0.027476655, -0.070054739, 0.081437923, -0.056044498,
      -0.027087963, 0.12330761, -0.18331454, 0.17796109, -0.049807749, -0.14814388, 0.33642099, -0.49016986,
      0.51434408, -0.41486443, 0.27672635, -0.10432054, },
};

const double * const ff_on2avc_tabs_20_84_1[20] = {
    tabs_20_84[ 0], tabs_20_84[ 1], tabs_20_84[ 2], tabs_20_84[ 3],
    tabs_20_84[ 4], tabs_20_84[ 5], tabs_20_84[ 6], tabs_20_84[ 7],
    tabs_20_84[ 8], tabs_20_84[ 9], tabs_20_84[10], tabs_20_84[11],
    tabs_20_84[12], tabs_20_84[13], tabs_20_84[14], tabs_20_84[15],
    tabs_20_84[16], tabs_20_84[17], tabs_20_84[18], tabs_20_84[19]
};

const double * const ff_on2avc_tabs_20_84_2[20] = {
    tabs_20_84[20], tabs_20_84[21], tabs_20_84[22], tabs_20_84[23],
    tabs_20_84[24], tabs_20_84[25], tabs_20_84[26], tabs_20_84[27],
    tabs_20_84[28], tabs_20_84[29], tabs_20_84[30], tabs_20_84[31],
    tabs_20_84[32], tabs_20_84[33], tabs_20_84[34], tabs_20_84[35],
    tabs_20_84[36], tabs_20_84[37], tabs_20_84[38], tabs_20_84[39]
};

const double * const ff_on2avc_tabs_20_84_3[20] = {
    tabs_20_84[40], tabs_20_84[41], tabs_20_84[42], tabs_20_84[43],
    tabs_20_84[44], tabs_20_84[45], tabs_20_84[46], tabs_20_84[47],
    tabs_20_84[48], tabs_20_84[49], tabs_20_84[50], tabs_20_84[51],
    tabs_20_84[52], tabs_20_84[53], tabs_20_84[54], tabs_20_84[55],
    tabs_20_84[56], tabs_20_84[57], tabs_20_84[58], tabs_20_84[59]
};

const double * const ff_on2avc_tabs_20_84_4[20] = {
    tabs_20_84[60], tabs_20_84[61], tabs_20_84[62], tabs_20_84[63],
    tabs_20_84[64], tabs_20_84[65], tabs_20_84[66], tabs_20_84[67],
    tabs_20_84[68], tabs_20_84[69], tabs_20_84[70], tabs_20_84[71],
    tabs_20_84[72], tabs_20_84[73], tabs_20_84[74], tabs_20_84[75],
    tabs_20_84[76], tabs_20_84[77], tabs_20_84[78], tabs_20_84[79]
};

const float ff_on2avc_ctab_1[2048] = {
    2.0, -4.4408921e-16, 1.998863, -0.067429408, 1.9954522, -0.13479699, 1.9897684, -0.20204064,
    1.9818133, -0.26909772, 1.9715892, -0.33590481, 1.9590992, -0.40239748, 1.9443476, -0.46851003,
    1.9273404, -0.5341754, 1.9080848, -0.59932488, 1.8865899, -0.66388828, 1.8628675, -0.72779351,
    1.8369317, -0.79096675, 1.8087995, -0.85333258, 1.7784914, -0.91481382, 1.7460314, -0.9753319,
    1.7114476, -1.0348068, 1.6747727, -1.0931578, 1.6360439, -1.1503029, 1.5953034, -1.2061599,
    1.5525988, -1.2606467, 1.5079833, -1.3136812, 1.4615158, -1.3651828, 1.4132608, -1.4150716,
    1.3632895, -1.4632699, 1.3116785, -1.5097026, 1.2585107, -1.5542974, 1.2038751, -1.5969861,
    1.1478662, -1.637704, 1.0905846, -1.6763921, 1.0321362, -1.7129962, 0.97263169, -1.7474687,
    0.9121868, -1.7797679, 0.85092157, -1.8098596, 0.78895974, -1.8377171, 0.72642845, -1.8633214,
    0.66345739, -1.8866621, 0.60017854, -1.9077374, 0.5367251, -1.9265541, 0.47323114, -1.9431282,
    0.4098306, -1.9574846, 0.34665683, -1.9696577, 0.28384155, -1.9796903, 0.22151428, -1.9876345,
    0.15980156, -1.993551, 0.09882611, -1.9975084, 0.038706206, -1.9995835, -0.02044509, -1.99986,
    -0.078520596, -1.9984288, -0.13541964, -1.9953866, -0.19104865, -1.9908354, -0.24532171, -1.984882,
    -0.29816103, -1.9776367, -0.34949744, -1.9692125, -0.39927062, -1.9597243, -0.44742957, -1.949288,
    -0.49393275, -1.938019, -0.5387482, -1.9260317, -0.58185375, -1.9134382, -0.62323707, -1.900347,
    -0.66289538, -1.8868629, -0.70083576, -1.8730848, -0.73707455, -1.8591057, -0.77163762, -1.8450115,
    -0.80455959, -1.83088, -0.83588386, -1.8167808, -0.8656621, -1.8027737, -0.89395374, -1.7889093,
    -0.9208256, -1.7752278, -0.94635135, -1.761759, -0.97061092, -1.7485228, -0.99368966, -1.7355278,
    -1.0156779, -1.7227728, -1.0366703, -1.710247, -1.0567647, -1.6979295, -1.0760615, -1.6857911,
    -1.0946627, -1.673794, -1.112671, -1.6618937, -1.1301892, -1.650039, -1.1473182, -1.6381736,
    -1.164157, -1.6262373, -1.1808009, -1.6141669, -1.1973405, -1.6018976, -1.2138611, -1.5893645,
    -1.2304406, -1.5765032, -1.2471493, -1.5632517, -1.2640481, -1.5495512, -1.2811878, -1.5353475,
    -1.2986077, -1.5205914, -1.3163352, -1.5052403, -1.3343842, -1.4892588, -1.3527551, -1.4726188,
    -1.3714331, -1.4553007, -1.390389, -1.4372933, -1.4095774, -1.4185938, -1.4289376, -1.3992081,
    -1.4483931, -1.3791504, -1.4678518, -1.3584429, -1.4872066, -1.3371153, -1.5063359, -1.3152039,
    -1.525104, -1.2927508, -1.5433633, -1.2698036, -1.5609542, -1.2464136, -1.5777074, -1.222635,
    -1.5934458, -1.198524, -1.6079853, -1.1741376, -1.6211381, -1.1495321, -1.6327139, -1.1247627,
    -1.6425229, -1.0998815, -1.6503778, -1.0749379, -1.656096, -1.0499765, -1.6595027, -1.0250366,
    -1.6604328, -1.0001521, -1.6587337, -0.97535098, -1.6542674, -0.95065427, -1.6469128, -0.92607677,
    -1.6365674, -0.90162659, -1.6231499, -0.87730545, -1.6066011, -0.85310918, -1.5868859, -0.82902807,
    -1.5639942, -0.80504757, -1.5379412, -0.78114909, -1.5087692, -0.75731099, -1.4765463, -0.73350942,
    -1.4413673, -0.70971948, -1.4033529, -0.68591642, -1.3626487, -0.66207647, -1.3194243, -0.63817829,
    -1.2738714, -0.61420387, -1.2262026, -0.59013963, -1.1766489, -0.56597722, -1.1254574, -0.54171461,
    -1.0728892, -0.51735634, -1.0192158, -0.49291453, -0.96471739, -0.468409, -0.90967888, -0.44386747,
    -0.85438752, -0.41932571, -0.79912966, -0.39482722, -0.74418765, -0.37042305, -0.68983728, -0.34617117,
    -0.63634455, -0.32213587, -0.58396345, -0.29838684, -0.53293306, -0.27499828, -0.48347571, -0.25204778,
    -0.43579489, -0.22961509, -0.39007342, -0.20778094, -0.34647217, -0.18662569, -0.30512896, -0.16622795,
    -0.26615775, -0.14666332, -0.22964823, -0.12800303, -0.19566566, -0.11031273, -0.1642511, -0.093651295,
    -0.13542198, -0.078069784, -0.10917274, -0.063610479, -0.085476093, -0.050306138, -0.064284235, -0.038179338,
    -0.04553042, -0.02724205, -0.029130703, -0.017495384, -0.014985808, -0.0089295385, -0.0029831429, -0.0015239252,
    0.0070011336, 0.0047524893, 0.015099987, 0.0099406661, 0.021453392, 0.014090803, 0.026206236, 0.017261485,
    0.029506302, 0.019518688, 0.03150234, 0.020934677, 0.032342274, 0.021586809, 0.032171525, 0.021556264,
    0.031131554, 0.020926755, 0.029358514, 0.019783208, 0.026982145, 0.018210486, 0.024124846, 0.016292138,
    0.020900913, 0.014109233, 0.017415999, 0.011739281, 0.013766737, 0.0092552658, 0.010040524, 0.0067248093,
    0.006315473, 0.0042094728, 0.0026604859, 0.0017642101, -0.00086453988, -0.00056303042, -0.004208413, -0.0027315477,
    -0.0073282644, -0.0047079842, -0.010189103, -0.0064662765, -0.01276332, -0.0079874769, -0.015030168, -0.009259454,
    -0.016975222, -0.01027649, -0.018589836, -0.01103879, -0.019870605, -0.011551925, -0.020818852, -0.011826212,
    -0.021440107, -0.011876071, -0.02174365, -0.011719362, -0.021742038, -0.011376713, -0.021450687, -0.010870866,
    -0.020887457, -0.010226041, -0.020072276, -0.0094673438, -0.019026764, -0.0086202007, -0.017773898, -0.0077098534,
    -0.016337669, -0.0067608948, -0.014742769, -0.0057968628, -0.013014285, -0.0048398855, -0.011177403, -0.0039103772,
    -0.0092571331, -0.0030267884, -0.0072780494, -0.002205404, -0.0052640433, -0.0014601871, -0.0032381038, -0.00080267049,
    -0.0012221149, -0.00024189093, 0.00076331489, 0.00021563418, 0.0026989998, 0.00056588947, 0.0045672944, 0.00080730428,
    0.0063521829, 0.00094065693, 0.0080393394, 0.00096894189, 0.0096161636, 0.00089720206, 0.011071794, 0.00073232828,
    0.012397096, 0.00048283004, 0.013584645, 0.00015858111, 0.014628679, -0.00022945412, 0.015525063, -0.00066950807,
    0.016271239, -0.0011493041, 0.016866164, -0.0016563499, 0.017310271, -0.0021782229, 0.017605407, -0.0027028411,
    0.017754791, -0.0032187088, 0.017762953, -0.0037151384, 0.017635692, -0.0041824332, 0.017380001, -0.0046120379,
    0.017004017, -0.0049966443, 0.016516931, -0.0053302632, 0.015928905, -0.0056082504, 0.015250954, -0.0058273012,
    0.014494829, -0.0059854095, 0.013672867, -0.0060818009, 0.012797831, -0.0061168405, 0.011882732, -0.0060919276,
    0.010940637, -0.0060093803, 0.0099844718, -0.0058723139, 0.0090268105, -0.0056845243, 0.0080796788, -0.0054503735,
    0.0071543544, -0.005174689, 0.006261189, -0.0048626713, 0.0054094414, -0.0045198193, 0.0046071433, -0.0041518649,
    0.0038609891, -0.0037647239, 0.0031762596, -0.0033644575, 0.0025567838, -0.0029572411, 0.0020049347, -0.00254934,
    0.0015216633, -0.0021470881, 0.0011065686, -0.0017568644, 0.00075800065, -0.0013850661, 0.0004731935, -0.0010380755,
    0.00024842433, -0.00072221586, 0.00007919284, -0.00044369671, -0.000039584535, -0.00020854612, -0.0001133715, -0.000022529672,
    -0.0001478067, 0.000108944, -0.00014850247, 0.00018093004, -0.0001208542, 0.00018906515, -0.000069866226, 0.00012969374,
    -2.220446e-16, -5.5511151e-17, 0.000084950341, -0.00020185817, 0.00018195057, -0.00047661722, 0.00028878354, -0.0008237827,
    0.00040406833, -0.0012415157, 0.00052723964, -0.0017265369, 0.00065848755, -0.0022740522, 0.00079865806, -0.0028777081,
    0.00094911765, -0.0035295789, 0.0011115847, -0.0042201951, 0.0012879343, -0.0049386127, 0.0014799823, -0.0056725289,
    0.0016892579, -0.0064084502, 0.0019167721, -0.0071319067, 0.002162795, -0.0078277159, 0.0024266504, -0.0084802955,
    0.0027065387, -0.0090740146, 0.0029994014, -0.0095935827, 0.0033008344, -0.010024459, 0.0036050577, -0.01035328,
    0.003904952, -0.010568285, 0.0041921646, -0.010659733, 0.0044572824, -0.010620279, 0.0046900786, -0.01044532,
    0.0048798202, -0.010133266, 0.0050156307, -0.0096857436, 0.0050868993, -0.0091077117, 0.0050837183, -0.0084074708,
    0.0049973316, -0.0075965733, 0.0048205811, -0.0066896221, 0.0045483187, -0.0057039633, 0.0041777813, -0.0046592737,
    0.0037088934, -0.0035770566, 0.0031444894, -0.002480061, 0.0024904367, -0.0013916414, 0.0017556528, -0.0003350777,
    0.0009520037, 0.00066711544, 0.000094088718, 0.0015938688, -0.00080108939, 0.0024262008, -0.0017145583, 0.0031477951,
    -0.0026259006, 0.0037454946, -0.00351385, 0.0042096875, -0.0043569384, 0.0045345738, -0.0051341685, 0.0047182986,
    -0.0058256849, 0.0047629494, -0.0064134183, 0.0046744202, -0.0068816775, 0.0044621397, -0.0072176624, 0.0041386886,
    -0.0074118823, 0.0037193133, -0.0074584596, 0.0032213603, -0.00735531, 0.0026636559, -0.0071041943, 0.0020658553,
    -0.006710636, 0.0014477872, -0.0061837193, 0.00082882162, -0.0055357711, 0.00022728172, -0.0047819447, -0.00034007721,
    -0.0039397213, -0.00085850636, -0.0030283579, -0.0013156059, -0.0020682951, -0.0017015649, -0.0010805541, -0.0020092935,
    -0.000086142623, -0.0022344531, 0.00089450512, -0.0023753855, 0.0018420418, -0.0024329573, 0.0027386551, -0.0024103273,
    0.0035684374, -0.0023126558, 0.0043176766, -0.0021467698, 0.0049750544, -0.0019208054, 0.0055317623, -0.0016438378,
    0.0059815329, -0.0013255208, 0.0063205939, -0.00097574567, 0.0065475609, -0.00060433155, 0.0066632666, -0.00022075657,
    0.0066705542, 0.00016606481, 0.0065740347, 0.0005479547, 0.0063798288, 0.000917595, 0.0060953014, 0.0012686022,
    0.0057287971, 0.0015955586, 0.0052893902, 0.0018940041, 0.0047866534, 0.0021603971, 0.0042304504, 0.0023920508,
    0.0036307548, 0.0025870528, 0.0029974992, 0.0027441746, 0.0023404511, 0.0028627797, 0.0016691157, 0.0029427363,
    0.00099266251, 0.0029843359, 0.00031987071, 0.0029882274, -0.0003409097, 0.0029553634, -0.00098178594, 0.0028869633,
    -0.0015953446, 0.0027844929, -0.0021746708, 0.0026496551, -0.0027133694, 0.0024843954, -0.0032055897, 0.0022909143,
    -0.0036460557, 0.0020716845, -0.0040301029, 0.001829469, -0.0043537221, 0.0015673359, -0.0046136077, 0.0012886674,
    -0.0048072096, 0.00099715649, -0.0049327859, 0.00069679262, -0.0049894531, 0.000391832, -0.0049772309, 0.000086752072,
    -0.0048970757, -0.00021380912, -0.0047509046, -0.00050512824, -0.0045416015, -0.00078248454, -0.0042730039, -0.0010412579,
    -0.0039498731, -0.0012770331, -0.0035778389, -0.0014857076, -0.0031633279, -0.0016635971, -0.0027134682, -0.001807537,
    -0.0022359758, -0.0019149748, -0.0017390279, -0.0019840484, -0.0012311181, -0.0020136512, -0.00072090683, -0.0020034772,
    -0.0002170627, -0.0019540484, 0.00027189584, -0.0018667208, 0.00073775765, -0.00174367, 0.0011727696, -0.0015878571,
    0.0015697783, -0.0014029766, 0.001922359, -0.0011933852, 0.0022249303, -0.00096401788, 0.0024728517, -0.00072028884,
    0.0026625025, -0.00046798357, 0.0027913428, -0.00021314165, 0.0028579531, 0.000038065922, 0.0028620549, 0.00027946298,
    0.0028045103, 0.00050499593, 0.0026873015, 0.00070886087, 0.0025134915, 0.00088562793, 0.0022871648, 0.0010303608,
    0.0020133494, 0.0011387296, 0.0016979213, 0.0012071145, 0.0013474913, 0.0012326987, 0.00096927787, 0.0012135465,
    0.00057096494, 0.001148668, 0.00016054846, 0.0010380625, -0.00025382591, 0.00088274491, -0.00066403102, 0.00068474718,
    -0.0010621285, 0.0004470984, -0.001440537, 0.00017377918, -0.0017921957, -0.00013034795, -0.0021107141, -0.00045963225,
    -0.0023905102, -0.00080775097, -0.0026269264, -0.0011678453, -0.0028163234, -0.0015326737, -0.002956148, -0.0018947766,
    -0.003044971, -0.0022466506, -0.0030824956, -0.0025809242, -0.0030695351, -0.0028905307, -0.003007961, -0.0031688737,
    -0.0029006239, -0.0034099782, -0.0027512501, -0.0036086228, -0.0025643157, -0.0037604517, -0.0023449084, -0.0038620592,
    -0.0020985759, -0.0039110477, -0.0018311698, -0.003906057, -0.0015486911, -0.0038467669, -0.0012571397, -0.0037338703,
    -0.00096237543, -0.0035690248, -0.00066999131, -0.003354782, -0.00038520579, -0.003094499, -0.00011277314, -0.0027922371,
    0.00014308578, -0.0024526515, 0.00037873242, -0.0020808775, 0.00059113972, -0.0016824141, 0.0007779033, -0.0012630108,
    0.00093723694, -0.00082856242, 0.0010679543, -0.00038500843, 0.0011694405, 0.000061755964, 0.0012416149, 0.00050595973,
    0.0012848899, 0.00094202528, 0.0013001257, 0.0013646283, 0.0012885842, 0.0017687485, 0.0012518835, 0.0021497128,
    0.0011919539, 0.0025032314, 0.0011109948, 0.0028254308, 0.0010114345, 0.0031128798, 0.00089589041, 0.0033626144,
    0.00076713093, 0.0035721601, 0.00062803685, 0.0037395512, 0.00048156266, 0.0038633479, 0.00033069632, 0.0039426503,
    0.00017841732, 0.0039771087, 0.000027653001, 0.0039669303, -0.00011876698, 0.0039128768, -0.00025815735, 0.0038162593,
    -0.00038802426, 0.0036789209, -0.00050611183, 0.0035032146, -0.00061044592, 0.003291968, -0.00069937482, 0.0030484418,
    -0.00077160395, 0.0027762763, -0.00082622346, 0.0024794317, -0.00086272735, 0.0021621194, -0.0008810226, 0.0018287286,
    -0.00088142743, 0.0014837491, -0.00086465816, 0.0011316916, -0.00083180465, 0.00077700929, -0.00078429491, 0.0004240229,
    -0.00072384975, 0.000076850592, -0.00065242866, -0.00026065443, -0.00057216937, -0.00058495684, -0.00048532296, -0.0008928816,
    -0.00039418644, -0.0011816447, -0.00030103643, -0.0014488718, -0.00020806548, -0.0016926047, -0.0001173238, -0.0019112971,
    -0.000030668409, -0.0021038, 0.000050278504, -0.0022693386, 0.00012416096, -0.0024074819, 0.00018990933, -0.0025181088,
    0.00024674923, -0.0026013714, 0.00029419933, -0.0026576561, 0.00033205902, -0.0026875495, 0.0003603872, -0.0026918037,
    0.00037947373, -0.0026713097, 0.00038980544, -0.0026270729, 0.00039202863, -0.0025601962, 0.00038691019, -0.0024718693,
    0.00037529902, -0.0023633612, 0.00035808972, -0.0022360198, 0.00033618973, -0.0020912744, 0.00031049116, -0.001930638,
    0.00028184787, -0.0017557153, 0.0002510584, -0.0015682059, 0.0002188544, -0.001369908, 0.00018589437, -0.0011627187,
    0.00015276202, -0.00094863074, 0.00011996848, -0.00072972412, 0.000087957334, -0.00050815433, 0.000057111374, -0.00028613486,
    0.000027760274, -0.00006591557, 1.8815049e-7, 0.00015024227, -0.000025359737, 0.00036009445, -0.000048671653, 0.00056144409,
    -0.000069565853, 0.0007521729, -0.000087888977, 0.00093027257, -0.00010351629, 0.0010938746, -0.00011635367, 0.0012412785,
    -0.0001263407, 0.0013709769, -0.0001334548, 0.0014816767, -0.0001377154, 0.001572317, -0.00013918804, 0.0016420815,
    -0.00013798742, 0.0016904076, -0.00013427943, 0.0017169899, -0.0001282813, 0.0017217799, -0.00012026003, 0.0017049827,
    -0.00011052855, 0.0016670482, -0.000099440098, 0.0016086611, -0.000087380431, 0.0015307277, -0.000074758427, 0.0014343602,
    -0.000061995306, 0.0013208598, -0.000049512866, 0.0011916994, -0.000037721158, 0.0010485043, -0.000027006179, 0.00089303311,
    -0.000017717955, 0.00072715874, -0.000010159566, 0.0005528488, -0.0000045775087, 0.00037214643, -0.0000011537802, 0.00018715112,
};

const float ff_on2avc_ctab_2[2048] = {
    6.1062266e-16, -0.0047176247, 0.000025801086, 0.00017171795, 0.00010278686, 0.00033237049, 0.00022971108, 0.00047108173,
    0.00040451737, 0.00057735282, 0.00062436966, 0.00064124417, 0.00088569394, 0.00065355049, 0.0011842304, 0.0006059666,
    0.0015150951, 0.00049124041, 0.0018728492, 0.00030331188, 0.0022515757, 0.000037434522, 0.0026449619, -0.00030972183,
    0.0030463862, -0.00073999004, 0.003449009, -0.0012536477, 0.0038458654, -0.0018493842, 0.0042299605, -0.0025242937,
    0.0045943661, -0.0032738955, 0.0049323193, -0.0040921802, 0.0052373176, -0.0049716844, 0.0055032219, -0.0059035895,
    0.0057243509, -0.0068778461, 0.005895582, -0.0078833178, 0.006012449, -0.0089079468, 0.0060712346, -0.0099389348,
    0.0060690674, -0.010962932, 0.0060040066, -0.01196624, 0.0058751269, -0.01293501, 0.0056825895, -0.013855449,
    0.0054277065, -0.014714016, 0.005112987, -0.015497606, 0.0047421698, -0.016193733, 0.0043202331, -0.016790686,
    0.0038533837, -0.017277677, 0.0033490176, -0.017644968, 0.0028156566, -0.017883981, 0.0022628529, -0.017987385,
    0.0017010663, -0.017949177, 0.0011415118, -0.017764734, 0.00059597875, -0.017430862, 0.000076625569, -0.016945831,
    -0.00040424766, -0.016309388, -0.00083444483, -0.015522776, -0.0012021317, -0.014588747, -0.0014961021, -0.013511552,
    -0.0017060443, -0.012296947, -0.0018228046, -0.010952174, -0.001838639, -0.0094859507, -0.0017474507, -0.0079084486,
    -0.0015450044, -0.0062312619, -0.0012291165, -0.0044673691, -0.0007998143, -0.0026310843, -0.00025946245, -0.00073799869,
    0.00038714762, 0.0011950907, 0.0011327467, 0.003150264, 0.0019675777, 0.0051085735, 0.002879428, 0.007050151,
    0.0038537064, 0.0089543248, 0.0048735668, 0.010799746, 0.0059200767, 0.012564532, 0.0069724373, 0.014226408,
    0.0080082528, 0.015762862, 0.0090038506, 0.017151318, 0.0099346545, 0.018369311, 0.010775609, 0.019394677,
    0.011501653, 0.020205766, 0.012088243, 0.020781681, 0.012511919, 0.021102531, 0.012750908, 0.021149736,
    0.012785755, 0.020906361, 0.012599968, 0.020357504, 0.012180677, 0.019490732, 0.011519265, 0.018296573,
    0.010611986, 0.016769076, 0.0094605172, 0.014906418, 0.0080724526, 0.012711582, 0.006461692, 0.010193078,
    0.0046487241, 0.0073657078, 0.0026607637, 0.0042513679, 0.0005317349, 0.00087985705, -0.0016979208, -0.0027103117,
    -0.0039816312, -0.0064711315, -0.0062672808, -0.010344372, -0.0084980074, -0.014260936, -0.010613214, -0.018140316,
    -0.012549785, -0.02189021, -0.0142435, -0.02540629, -0.015630638, -0.028572179, -0.016649729, -0.031259675,
    -0.017243449, -0.033329193, -0.017360613, -0.034630522, -0.016958216, -0.035003848, -0.016003506, -0.03428109,
    -0.014476006, -0.032287523, -0.012369478, -0.028843746, -0.0096937334, -0.023767876, -0.0064762742, -0.016878078,
    -0.0027636932, -0.0079952935, 0.0013771985, 0.0030537986, 0.0058585741, 0.016433664, 0.010571149, 0.032296669,
    0.015384134, 0.050779779, 0.020145604, 0.072001241, 0.024683299, 0.096057333, 0.028805861, 0.12301921,
    0.032304518, 0.15292998, 0.034955185, 0.18580194, 0.036520973, 0.22161427, 0.036755085, 0.26031092,
    0.035404034, 0.30179903, 0.032211188, 0.34594777, 0.026920509, 0.39258778, 0.019280523, 0.44151106,
    0.0090483893, 0.49247134, -0.004005983, 0.54518533, -0.020095825, 0.59933424, -0.039413493, 0.65456611,
    -0.062126629, 0.71049863, -0.088374533, 0.76672238, -0.11826489, 0.82280493, -0.1518708, 0.87829489,
    -0.18922837, 0.93272704, -0.23033462, 0.98562711, -0.27514613, 1.0365173, -0.32357812, 1.084922,
    -0.37550423, 1.1303729, -0.43075687, 1.1724157, -0.48912829, 1.210615, -0.55037224, 1.2445599,
    -0.61420608, 1.2738692, -0.68031394, 1.2981967, -0.74834985, 1.3172354, -0.81794167, 1.330721,
    -0.8886956, 1.3384365, -0.96020055, 1.3402138, -1.0320334, 1.3359363, -1.1037641, 1.3255405,
    -1.1749605, 1.3090167, -1.2451944, 1.2864087, -1.3140464, 1.257813, -1.3811105, 1.2233779,
    -1.4460001, 1.1833013, -1.5083516, 1.1378273, -1.5678285, 1.0872437, -1.6241266, 1.0318775,
    -1.6769751, 0.97209138, -1.7261413, 0.90827817, -1.7714316, 0.84085637, -1.8126934, 0.77026486,
    -1.8498163, 0.69695753, -1.882732, 0.62139785, -1.9114146, 0.54405344, -1.9358792, 0.46539098,
    -1.9561808, 0.38587096, -1.9724123, 0.3059431, -1.9847021, 0.22604167, -1.9932109, 0.14658169,
    -1.9981292, 0.067955181, -1.9996731, -0.00947183, -1.9980807, -0.085361861, -1.9936082, -0.15940794,
    -1.9865264, -0.23133504, -1.9771156, -0.30090088, -1.9656627, -0.36789626, -1.952457, -0.43214479,
    -1.9377865, -0.49350214, -1.9219347, -0.55185497, -1.905178, -0.60711914, -1.8877819, -0.65923816,
    -1.8699998, -0.70818067, -1.8520706, -0.75393814, -1.8342167, -0.79652262, -1.8166438, -0.83596373,
    -1.7995393, -0.87230623, -1.7830721, -0.9056074, -1.7673923, -0.93593466, -1.7526317, -0.96336293,
    -1.7389038, -0.98797268, -1.7263044, -1.0098475, -1.7149128, -1.0290729, -1.7047921, -1.0457342,
    -1.6959906, -1.0599151, -1.6885422, -1.0716969, -1.6824687, -1.0811574, -1.677779, -1.0883702,
    -1.6744717, -1.0934039, -1.6725357, -1.0963222, -1.67195, -1.0971831, -1.6726862, -1.0960395,
    -1.6747082, -1.0929389, -1.6779734, -1.0879233, -1.6824325, -1.08103, -1.6880317, -1.0722916,
    -1.6947116, -1.0617367, -1.7024086, -1.04939, -1.7110549, -1.0352732, -1.7205796, -1.0194054,
    -1.730908, -1.0018036, -1.7419629, -0.9824838, -1.7536641, -0.96146131, -1.7659295, -0.93875134,
    -1.7786744, -0.91437006, -1.7918122, -0.88833487, -1.8052548, -0.86066544, -1.8189124, -0.83138382,
    -1.8326937, -0.80051541, -1.8465064, -0.76808912, -1.860257, -0.73413789, -1.8738515, -0.69869894,
    -1.8871957, -0.66181415, -1.9001952, -0.62353003, -1.9127564, -0.58389789, -1.924787, -0.54297411,
    -1.9361968, -0.50081998, -1.946898, -0.45750189, -1.9568071, -0.41309139, -1.9658449, -0.36766547,
    -1.9739379, -0.32130671, -1.9810196, -0.27410358, -1.9870309, -0.22615109, -1.9919212, -0.17755121,
    -1.9956495, -0.12841354, -1.9981841, -0.078856133, -1.9995037, -0.029006185, -1.9995972, 0.020999053,
    -1.9984629, 0.071011581, -1.9961088, 0.12087195, -1.9925506, 0.17040877, -1.9878117, 0.21943836,
    -1.9819202, 0.26776481, -1.9749084, 0.31518021, -1.9668094, 0.36146545, -1.9576563, 0.40639135,
    -1.9474785, 0.44972011, -1.9363006, 0.49120751, -1.9241393, 0.53060538, -1.9110016, 0.5676645,
    -1.8968834, 0.60213798, -1.8817675, 0.63378489, -1.8656229, 0.6623742, -1.8484042, 0.68768901,
    -1.8300512, 0.70953059, -1.8104898, 0.7277227, -1.7896332, 0.74211556, -1.7673825, 0.75258982,
    -1.7436302, 0.75905991, -1.718262, 0.76147729, -1.6911598, 0.75983286, -1.6622057, 0.75415885,
    -1.6312853, 0.7445302, -1.598292, 0.73106503, -1.5631305, 0.71392417, -1.5257218, 0.69331038,
    -1.4860063, 0.66946632, -1.4439477, 0.64267194, -1.3995371, 0.6132409, -1.3527952, 0.58151656,
    -1.3037754, 0.54786724, -1.2525655, 0.51268071, -1.199289, 0.47635838, -1.1441054, 0.43930924,
    -1.0872105, 0.40194324, -1.0288347, 0.36466473, -0.96924144, 0.32786602, -0.90872473, 0.2919209,
    -0.84760505, 0.25717854, -0.7862255, 0.22395785, -0.7249468, 0.19254236, -0.66414177, 0.16317582,
    -0.60418916, 0.13605864, -0.54546744, 0.11134519, -0.4883481, 0.089142092, -0.43318909, 0.069507554,
    -0.38032803, 0.052451812, -0.33007616, 0.037938587, -0.28271216, 0.025887616, -0.23847705, 0.016178153,
    -0.19756962, 0.0086534023, -0.16014262, 0.0031256941, -0.12630016, -0.00061766239, -0.096096113, -0.0028080596,
    -0.069533631, -0.003688961, -0.046565846, -0.0035091597, -0.027097713, -0.0025161188, -0.010989046, -0.00094958977,
    0.0019415142, 0.00096430612, 0.011911541, 0.0030183611, 0.019169118, 0.0050287801, 0.023986517, 0.006838772,
    0.026653459, 0.0083211483, 0.027470166, 0.0093798656, 0.026740402, 0.0099505046, 0.0247647, 0.0099997027,
    0.021834008, 0.0095235975, 0.018223884, 0.0085453819, 0.014189421, 0.0071120788, 0.0099610332, 0.0052907071,
    0.0057411729, 0.0031639794, 0.0017020478, 0.00082572823, -0.0020156475, -0.0016237673, -0.0053030066, -0.0040823757,
    -0.0080822473, -0.0064504636, -0.01030519, -0.0086348522, -0.011950996, -0.010552257, -0.013023298, -0.012132118,
    -0.013546856, -0.013318742, -0.013563911, -0.014072724, -0.013130371, -0.014371663, -0.012311992, -0.014210164,
    -0.011180677, -0.013599193, -0.0098110167, -0.012564868, -0.0082771704, -0.011146758, -0.0066501619, -0.0093958043,
    -0.0049956408, -0.0073719709, -0.0033721365, -0.0051417369, -0.0018298116, -0.0027755348, -0.00040969814, -0.00034523915,
    0.00085661822, 0.0020782049, 0.0019469126, 0.004426945, 0.002847892, 0.0066381125, 0.0035544888, 0.0086554019,
    0.0040689427, 0.010430313, 0.0043997411, 0.011923047, 0.0045604752, 0.013103063, 0.0045686788, 0.013949312,
    0.0044446858, 0.014450175, 0.0042105624, 0.014603134, 0.0038891311, 0.014414242, 0.0035031161, 0.01389739,
    0.0030744188, 0.01307346, 0.0026235317, 0.011969374, 0.0021690836, 0.010617082, 0.0017275107, 0.009052542,
    0.0013128433, 0.0073146918, 0.00093659078, 0.0054444592, 0.0006077115, 0.0034838144, 0.00033265035, 0.0014748911,
    0.00011543075, -0.00054083008, -0.000042213407, -0.0025232558, -0.00014067636, -0.0044343388, -0.00018229883, -0.0062386589,
    -0.00017117237, -0.0079039233, -0.00011293451, -0.0094013978, -0.000014556788, -0.010706257, 0.00011587302, -0.011797872,
    0.00026937437, -0.012660023, 0.00043630364, -0.013281046, 0.0006065903, -0.013653914, 0.00076997973, -0.013776246,
    0.00091628113, -0.013650244, 0.0010356199, -0.013282579, 0.0011186899, -0.012684184, 0.0011570023, -0.011869996,
    0.0011431255, -0.010858623, 0.0010709089, -0.0096719572, 0.00093568477, -0.0083347168, 0.00073444104, -0.0068739466,
    0.00046595652, -0.0053184745, 0.00013089461, -0.0036983292, -0.00026815146, -0.002044142, -0.00072666444, -0.00038653665,
    -0.001238263, 0.0012444736, -0.0017948141, 0.0028200729, -0.0023865986, 0.0043131965, -0.0030025232, 0.0056990399,
    -0.0036303743, 0.0069555123, -0.0042571067, 0.0080636218, -0.0048691588, 0.0090077901, -0.0054527833, 0.0097760875,
    -0.0059943851, 0.010360379, -0.0064808549, 0.010756395, -0.0068998942, 0.010963713, -0.0072403145, 0.010985666,
    -0.0074923136, 0.010829174, -0.0076477141, 0.010504506, -0.0077001643, 0.010024985, -0.0076453011, 0.0094066458,
    -0.0074808616, 0.0086678378, -0.0072067594, 0.0078288056, -0.0068251076, 0.0069112377, -0.0063402043, 0.0059377975,
    -0.0057584713, 0.0049316445, -0.0050883559, 0.0039159562, -0.004340189, 0.0029134497, -0.0035260066, 0.0019459217,
    -0.002659336, 0.001033804, -0.0017549467, 0.00019574871, -0.00082857109, -0.00055175176, 0.00010340517, -0.0011947021,
    0.0010242764, -0.0017218908, 0.0019173701, -0.0021251177, 0.0027664138, -0.0023993575, 0.0035559093, -0.0025428517,
    0.0042715017, -0.0025571233, 0.0049003414, -0.0024469129, 0.0054314188, -0.0022200351, 0.0058558695, -0.0018871534,
    0.0061672316, -0.0014614828, 0.0063616517, -0.00095842173, 0.0064380248, -0.00039512504, 0.0063980608, 0.00020997033,
    0.0062462785, 0.00083765347, 0.0059899129, 0.0014684666, 0.005638747, 0.0020832333, 0.0052048638, 0.0026635726,
    0.0047023292, 0.0031923822, 0.0041468102, 0.0036542746, 0.0035551451, 0.0040359539, 0.0029448776, 0.0043265228,
    0.0023337679, 0.0045177112, 0.0017393016, 0.0046040174, 0.001178207, 0.0045827716, 0.00066600286, 0.0044541075,
    0.00021658542, 0.004220861, -0.0001581293, 0.0038883933, -0.0004484996, 0.0034643558, -0.00064738019, 0.0029584002,
    -0.00075026811, 0.0023818521, -0.000755371, 0.0017473593, -0.00066359824, 0.0010685247, -0.00047847957, 0.00035953996,
    -0.00020601597, -0.00036517272, 0.00014552828, -0.0010913002, 0.00056588452, -0.0018049506, 0.001043079, -0.0024929349,
    0.0015637625, -0.0031430104, 0.0021135611, -0.003744086, 0.0026774362, -0.0042863889, 0.0032400466, -0.0047615874,
    0.0037861052, -0.0051628826, 0.0043007191, -0.005485056, 0.0047697132, -0.0057244869, 0.0051799244, -0.00587914,
    0.0055194702, -0.0059485212, 0.0057779811, -0.0059336093, 0.005946802, -0.0058367676, 0.006019149, -0.0056616301,
    0.0059902342, -0.0054129749, 0.0058573456, -0.0050965813, 0.0056198868, -0.0047190739, 0.0052793743, -0.0042877593,
    0.0048393975, -0.0038104532, 0.0043055299, -0.0032953112, 0.0036852097, -0.0027506526, 0.0029875766, -0.002184795,
    0.0022232747, -0.0016058958, 0.0014042265, -0.0010218052, 0.00054337748, -0.00043993912, -0.00034557868, 0.00013282956,
    -0.0012484904, 0.00069025467, -0.0021510462, 0.0012267748, -0.0030390718, 0.0017375433, -0.0038988206, 0.0022184309,
    -0.0047172462, 0.0026660003, -0.0054822522, 0.0030774584, -0.0061829095, 0.0034505837, -0.0068096397, 0.0037836414,
    -0.0073543512, 0.004075285, -0.0078105354, 0.0043244553, -0.008173313, 0.0045302799, -0.0084394356, 0.0046919878,
    -0.0086072432, 0.004808831, -0.0086765829, 0.00488004, -0.0086486926, 0.0049047922, -0.0085260663, 0.004882222,
    -0.0083122877, 0.0048114532, -0.0080118719, 0.0046916641, -0.0076300949, 0.0045221797, -0.0071728369, 0.0043025846,
    -0.0066464432, 0.0040328531, -0.0060576024, 0.0037134863, -0.0054132543, 0.0033456483, -0.0047205254, 0.0029312912,
    -0.0039866935, 0.0024732621, -0.0032191742, 0.0019753794, -0.0024255351, 0.0014424763, -0.001613521, 0.0008803992,
    -0.00079109054, 0.00029596357, 0.00003354808, -0.00030313883, 0.00085190887, -0.00090847781, 0.001655216, -0.0015110652,
    0.0024344153, -0.0021015715, 0.0031802151, -0.002670571, 0.0038831618, -0.0032088049, 0.00453375, -0.0037074534,
    0.0051225699, -0.0041584023, 0.0056404881, -0.0045544938, 0.0060788556, -0.0048897523, 0.0064297421, -0.0051595722,
    0.0066861785, -0.005360858, 0.006842406, -0.0054921173, 0.0068941191, -0.0055534914, 0.0068386863, -0.0055467347,
    0.0066753477, -0.0054751309, 0.0064053647, -0.005343359, 0.0060321307, -0.0051573105, 0.0055612195, -0.0049238643,
    0.0050003757, -0.0046506319, 0.0043594413, -0.0043456783, 0.0036502162, -0.0040172371, 0.002886259, -0.0036734226,
    0.0020826256, -0.0033219547, 0.0012555593, -0.002969909, 0.00042213459, -0.0026234936, -0.0004001323, -0.0022878707,
    -0.0011936954, -0.0019670199, -0.0019414022, -0.0016636539, -0.0026269152, -0.0013791855, -0.0032351194, -0.0011137482,
    -0.0037525038, -0.00086626812, -0.0041675051, -0.00063458277, -0.0044708052, -0.00041560392, -0.0046555689, -0.00020551546,
};

const float ff_on2avc_ctab_3[2048] = {
    -1.6653345e-16, -0.0028429052, -0.000042537456, 0.00019487554, -0.00016862253, 0.00040306276, -0.00037372447, 0.00063729816,
    -0.0006504606, 0.00090918731, -0.00098884385, 0.0012286865, -0.0013766177, 0.0016036412, -0.0017996682, 0.0020393939,
    -0.0022425, 0.0025384782, -0.0026887599, 0.0031004087, -0.0031217942, 0.0037215743, -0.0035252157, 0.0043952391,
    -0.0038834687, 0.0051116538, -0.0041823699, 0.005858277, -0.0044096061, 0.0066200914, -0.0045551774, 0.0073800222,
    -0.0046117627, 0.0081194276, -0.0045750043, 0.0088186627, -0.0044436962, 0.0094576869, -0.0042198659, 0.010016704,
    -0.0039087553, 0.010476815, -0.0035186927, 0.010820654, -0.0030608606, 0.011033002, -0.002548967, 0.011101345,
    -0.001998829, 0.011016356, -0.0014278793, 0.010772308, -0.00085461611, 0.01036737, -0.00029800553, 0.0098037962,
    0.00022313831, 0.0090879966, 0.00069077854, 0.0082304832, 0.001088266, 0.0072456878, 0.0014009145, 0.0061516552,
    0.0016165223, 0.0049696299, 0.0017258222, 0.0037235275, 0.0017228439, 0.002439322, 0.0016051769, 0.0011443575,
    0.0013741244, -0.0001333931, 0.0010347385, -0.001366102, 0.00059573731, -0.0025268681, 0.00006930346, -0.0035904851,
    -0.00052923308, -0.0045341686, -0.001181817, -0.0053382241, -0.0018681852, -0.0059866291, -0.0025664624, -0.0064675175,
    -0.0032538211, -0.0067735398, -0.0039071804, -0.0069020987, -0.0045039295, -0.0068554399, -0.0050226445, -0.0066406005,
    -0.0054437858, -0.0062692142, -0.0057503423, -0.0057571726, -0.0059284149, -0.0051241596, -0.0059677036, -0.0043930644,
    -0.0058618966, -0.003589293, -0.0056089377, -0.0027400018, -0.0052111652, -0.0018732708, -0.0046753148, -0.0010172459,
    -0.0040123845, -0.00019927412, -0.0032373657, 0.00055493839, -0.0023688413, 0.0012221204, -0.0014284686, 0.0017821564,
    -0.00044035583, 0.00221871, 0.00056964607, 0.0025197288, 0.0015747172, 0.002677816, 0.0025478832, 0.0026904519,
    0.003462845, 0.0025600623, 0.0042947996, 0.0022939243, 0.0050212229, 0.0019039178, 0.0056225881, 0.0014061241,
    0.0060830046, 0.00082028762, 0.0063907388, 0.00016915375, 0.0065386193, -0.00052229298, 0.0065242914, -0.0012276688,
    0.0063503282, -0.001920081, 0.00602418, -0.0025730385, 0.0055579683, -0.0031613547, 0.0049681277, -0.0036620118,
    0.0042749047, -0.0040549575, 0.0035017261, -0.0043238075, 0.0026744606, -0.0044564288, 0.0018205947, -0.0044453838,
    0.00096834335, -0.0042882231, 0.00014573456, -0.0039876048, -0.0006203127, -0.003551251, -0.0013048799, -0.0029917257,
    -0.0018858829, -0.0023260501, -0.0023448193, -0.0015751625, -0.0026674026, -0.00076324248, -0.0028440619, 0.000083084451,
    -0.0028702877, 0.00093562948, -0.00274681, 0.0017655863, -0.0024796019, 0.002544506, -0.0020797059, 0.0032452703,
    -0.001562885, 0.0038430272, -0.00094911043, 0.0043160599, -0.00026189955, 0.0046465569, 0.00047247464, 0.0048212567,
    0.001225878, 0.0048319423, 0.0019692846, 0.0046757692, 0.0026737878, 0.0043554134, 0.0033116213, 0.0038790288,
    0.0038571535, 0.0032600202, 0.0042878226, 0.0025166313, 0.0045849765, 0.0016713619, 0.004734592, 0.00075023499,
    0.0047278423, -0.00021806663, 0.0045614946, -0.0012031641, 0.0042381193, -0.0021740133, 0.003766102, -0.0030999696,
    0.0031594534, -0.0039518503, 0.0024374237, -0.0047029546, 0.0016239271, -0.0053300103, 0.00074679783, -0.0058140075,
    -0.00016310361, -0.0061408947, -0.0010729014, -0.0063021071, -0.0019488039, -0.0062949071, -0.0027572513, -0.0061225249,
    -0.0034660769, -0.0057940902, -0.0040456373, -0.0053243539, -0.0044698785, -0.0047332067, -0.0047172923, -0.0040450124,
    -0.0047717378, -0.0032877706, -0.0046230876, -0.0024921419, -0.0042676828, -0.0016903625, -0.0037085724, -0.00091508962,
    -0.0029555273, -0.0001982145, -0.0020248254, 0.00043031544, -0.00093881134, 0.00094362238, 0.00027475748, 0.0013189322,
    0.0015835584, 0.0015384787, 0.0029517193, 0.001590244, 0.0043409695, 0.0014685061, 0.005711888, 0.001174171,
    0.0070252069, 0.0007148743, 0.0082431259, 0.00010484495, 0.0093305949, -0.00063546957, 0.010256512, -0.0014800054,
    0.010994808, -0.0023978967, 0.011525363, -0.0033544756, 0.01183473, -0.0043124277, 0.011916637, -0.0052330629,
    0.011772243, -0.0060776612, 0.011410139, -0.0068088472, 0.010846091, -0.0073919417, 0.010102529, -0.0077962507,
    0.0092077944, -0.0079962341, 0.0081951711, -0.0079725226, 0.0071017356, -0.0077127367, 0.0059670559, -0.0072120731,
    0.0048317886, -0.0064736474, 0.0037362196, -0.0055085579, 0.0027188035, -0.0043356786, 0.0018147465, -0.0029811764,
    0.001054692, -0.0014777631, 0.00046354943, 0.00013628764, 0.000059517231, 0.0018183383, -0.00014666733, 0.0035227551,
    -0.00015221786, 0.0052024024, 0.000037492653, 0.0068102139, 0.00040901723, 0.008300784, 0.00094121607, 0.0096319281,
    0.0016059257, 0.010766147, 0.002368897, 0.011671957, 0.0031909735, 0.012325018, 0.0040294742, 0.012709031,
    0.0048397309, 0.012816358, 0.0055767358, 0.012648351, 0.0061968337, 0.01221535, 0.0066594072, 0.011536373,
    0.0069284872, 0.010638482, 0.0069742394, 0.0095558539, 0.0067742579, 0.0083285747, 0.0063146283, 0.0070012063,
    0.0055907099, 0.0056211669, 0.0046076039, 0.0042369836, 0.0033802853, 0.0028964775, 0.0019333874, 0.0016449478,
    0.00030063081, 0.00052342116, -0.0014760793, -0.0004329654, -0.0033478751, -0.0011963865, -0.0052604238, -0.0017474962,
    -0.0071556596, -0.0020762917, -0.0089736925, -0.0021826318, -0.010654833, -0.0020763816, -0.012141662, -0.0017771672,
    -0.013381075, -0.0013137354, -0.014326238, -0.00072293397, -0.014938361, -0.000048335231, -0.015188256, 0.00066145579,
    -0.015057592, 0.0013547561, -0.014539802, 0.0019789573, -0.013640625, 0.0024828047, -0.012378214, 0.002818716,
    -0.01078283, 0.0029450601, -0.0088961152, 0.0028283037, -0.0067699435, 0.0024449378, -0.0044648955, 0.0017831039,
    -0.002048397, 0.00084384187, 0.00040742956, -0.00035810683, 0.0028281235, -0.0017939941, 0.0051393877, -0.0034212973,
    0.0072696419, -0.0051845112, 0.0091525484, -0.0070165028, 0.010729411, -0.0088404194, 0.011951371, -0.010572106,
    0.01278131, -0.012122994, 0.013195385, -0.013403381, 0.013184131, -0.01432602, 0.01275308, -0.014809915,
    0.011922853, -0.01478422, 0.010728708, -0.01419212, 0.0092195272, -0.012994564, 0.0074562789, -0.011173738,
    0.0055099544, -0.0087361531, 0.0034590533, -0.0057152319, 0.0013866695, -0.0021732997, -0.00062274013, 0.0017971178,
    -0.0024868115, 0.0060727512, -0.0041288515, 0.010499856, -0.0054814275, 0.014895321, -0.0064898543, 0.019048614,
    -0.0071154684, 0.022724561, -0.0073385658, 0.025666898, -0.0071609118, 0.027602537, -0.0066077164, 0.028246468,
    -0.0057289964, 0.027307168, -0.004600253, 0.0244924, -0.0033224206, 0.019515269, -0.0020210496, 0.012100382,
    -0.00084472145, 0.0019899437, 0.000037296293, -0.01105034, 0.00043811565, -0.027225735, 0.00015696014, -0.046707455,
    -0.0010165154, -0.069628276, -0.0032974123, -0.096078917, -0.0069003948, -0.12610528, -0.01203424, -0.15970659,
    -0.018896269, -0.19683464, -0.027666792, -0.23739384, -0.038503725, -0.28124255, -0.051537503, -0.32819515,
    -0.06686642, -0.3780252, -0.084552586, -0.43046936, -0.10461849, -0.48523226, -0.12704438, -0.54199159,
    -0.15176651, -0.60040426, -0.17867628, -0.66011244, -0.20762028, -0.72074997, -0.23840135, -0.7819488,
    -0.27078056, -0.8433454, -0.30448011, -0.90458667, -0.33918688, -0.96533567, -0.37455717, -1.0252765,
    -0.41022155, -1.0841192, -0.44579068, -1.1416026, -0.48086143, -1.1974978, -0.51502305, -1.2516102,
    -0.54786384, -1.3037796, -0.57897753, -1.3538816, -0.60796958, -1.4018263, -0.63446349, -1.4475567,
    -0.65810603, -1.4910469, -0.67857265, -1.5322988, -0.6955719, -1.571339, -0.70884931, -1.6082149,
    -0.71819037, -1.6429906, -0.72342294, -1.6757429, -0.72441858, -1.7065566, -0.72109336, -1.7355207,
    -0.71340775, -1.7627244, -0.70136583, -1.7882535, -0.68501353, -1.8121873, -0.664437, -1.8345959,
    -0.63975936, -1.8555384, -0.61113822, -1.8750609, -0.5787617, -1.8931965, -0.54284513, -1.9099646,
    -0.50362706, -1.9253712, -0.46136531, -1.9394104, -0.41633323, -1.9520659, -0.36881575, -1.9633123,
    -0.31910598, -1.9731183, -0.26750168, -1.9814487, -0.21430217, -1.9882675, -0.15980564, -1.9935409,
    -0.1043066, -1.9972394, -0.048093725, -1.9993412, 0.0085518388, -1.9998351, 0.06535802, -1.9987217,
    0.12206294, -1.9960158, 0.17841578, -1.9917485, 0.23417741, -1.9859674, 0.28912079, -1.978738,
    0.34303114, -1.9701437, 0.39570591, -1.9602853, 0.44695485, -1.9492812, 0.49659961, -1.9372654,
    0.54447347, -1.924387, 0.59042108, -1.9108082, 0.63429779, -1.8967023, 0.6759693, -1.8822519,
    0.71531093, -1.8676466, 0.7522071, -1.8530809, 0.78655046, -1.8387512, 0.81824118, -1.8248546,
    0.84718591, -1.8115855, 0.87329692, -1.799134, 0.89649087, -1.7876834, 0.91668761, -1.7774082,
    0.93380904, -1.7684723, 0.94777751, -1.7610264, 0.95851475, -1.7552065, 0.96594018, -1.7511318,
    0.96996975, -1.7489027, 0.9705146, -1.7485988, 0.96748, -1.7502769, 0.96076453, -1.7539688,
    0.95025921, -1.7596794, 0.93584764, -1.7673841, 0.91740602, -1.7770265, 0.8948037, -1.788517,
    0.86790472, -1.8017294, 0.83656931, -1.8164997, 0.80065662, -1.8326236, 0.76002777, -1.8498554,
    0.71454966, -1.8679065, 0.66409934, -1.8864441, 0.60856909, -1.9050918, 0.54787195, -1.9234295,
    0.48194784, -1.9409947, 0.41076976, -1.9572846, 0.33435044, -1.9717588, 0.25274888, -1.9838443,
    0.16607688, -1.9929391, 0.07450521, -1.9984198, -0.021730689, -1.999648, -0.12232572, -1.9959785,
    -0.22690098, -1.9867691, -0.33500072, -1.9713904, -0.44609061, -1.9492363, -0.55955714, -1.9197356,
    -0.67470908, -1.8823639, -0.79077995, -1.8366553, -0.90693277, -1.7822139, -1.0222664, -1.718726,
    -1.1358232, -1.64597, -1.2465994, -1.5638269, -1.3535558, -1.4722892, -1.4556309, -1.3714676,
    -1.5517555, -1.2615976, -1.6408671, -1.1430426, -1.7219268, -1.016296, -1.7939352, -0.88198137,
    -1.8559498, -0.7408486, -1.9071014, -0.59376967, -1.9466108, -0.44173092, -1.9738038, -0.28582337,
    -1.9881259, -0.12723051, -1.9891552, 0.032785702, -1.976613, 0.19290088, -1.9503736, 0.35174593,
    -1.9104701, 0.50792599, -1.8570991, 0.6600405, -1.7906219, 0.80670393, -1.7115632, 0.94656676,
    -1.6206069, 1.0783361, -1.518589, 1.2007964, -1.4064881, 1.3128283, -1.2854123, 1.4134272,
    -1.1565856, 1.5017194, -1.0213295, 1.5769756, -0.8810457, 1.6386244, -0.73719448, 1.6862605,
    -0.5912739, 1.7196511, -0.44479746, 1.7387406, -0.2992714, 1.74365, -0.15617253, 1.734675,
    -0.016926099, 1.7122809, 0.11711492, 1.677093, 0.24468948, 1.629887, 0.36464623, 1.5715742,
    0.47595924, 1.5031863, 0.57774144, 1.4258577, 0.66925532, 1.3408059, 0.74992096, 1.2493112,
    0.81932145, 1.1526958, 0.87720448, 1.0523019, 0.92348218, 0.94947082, 0.95822722, 0.84552169,
    0.98166639, 0.74173182, 0.99417198, 0.63931787, 0.99625009, 0.53941888, 0.98852777, 0.44308114,
    0.97173774, 0.35124525, 0.94670212, 0.2647354, 0.91431493, 0.18425134, 0.87552404, 0.11036279,
    0.83131295, 0.04350647, 0.78268248, -0.016014282, 0.7306332, -0.068027422, 0.67614836, -0.11248776,
    0.62017834, -0.1494704, 0.56362599, -0.17916223, 0.50733423, -0.20185167, 0.45207494, -0.21791716,
    0.39854008, -0.22781442, 0.34733471, -0.2320631, 0.29897237, -0.23123281, 0.25387216, -0.22592908,
    0.21235825, -0.21677956, 0.17466106, -0.20442055, 0.14092025, -0.1894843, 0.11118954, -0.17258726,
    0.085442781, -0.15431944, 0.06358128, -0.13523506, 0.04544213, -0.11584474, 0.030807279, -0.096609004,
    0.01941302, -0.077933475, 0.010959785, -0.060165603, 0.005121904, -0.043592878, 0.0015571543, -0.028442509,
    -0.000084115498, -0.014882491, -0.00015046289, -0.003023857, 0.0010184186, 0.0070759403, 0.0030985889, 0.01540874,
    0.0057877772, 0.022010626, 0.0088102622, 0.026956297, 0.011920679, 0.030353062, 0.014906751, 0.032334596,
    0.017590966, 0.033054668, 0.019831251, 0.032680977, 0.021520695, 0.031389244, 0.022586443, 0.029357675,
    0.022987815, 0.026761938, 0.02271381, 0.023770688, 0.021780089, 0.020541752, 0.020225555, 0.017218968,
    0.018108679, 0.013929741, 0.015503671, 0.010783297, 0.012496619, 0.0078696031, 0.0091816904, 0.0052589499,
    0.0056575048, 0.0030021123, 0.0020237456, 0.0011310551, -0.0016219205, -0.00033990419, -0.0051865601, -0.0014125451,
    -0.0085842935, -0.0021028898, -0.011738192, -0.0024391229, -0.01458175, -0.0024593701, -0.017059926, -0.002209408,
    -0.019129775, -0.001740378, -0.020760702, -0.0011065705, -0.021934342, -0.00036333143, -0.022644157, 0.00043485823,
    -0.022894738, 0.0012360946, -0.022700895, 0.0019925251, -0.022086568, 0.0026615674, -0.021083612, 0.0032068638,
    -0.019730492, 0.0035989694, -0.018070942, 0.0038157802, -0.01615262, 0.0038427161, -0.014025783, 0.0036726766,
    -0.011742038, 0.0033057902, -0.0093531534, 0.0027489865, -0.0069099898, 0.0020154165, -0.0044615306, 0.0011237526,
    -0.0020540373, 0.000097393946, 0.00026966495, -0.0010363915, 0.0024707811, -0.002247364, 0.0045150127, -0.0035032234,
    0.0063729058, -0.0047705099, 0.0080200844, -0.0060154819, 0.0094373813, -0.0072049443, 0.010610872, -0.0083070258,
    0.011531814, -0.0092918845, 0.012196518, -0.010132339, 0.01260614, -0.010804415, 0.012766409, -0.011287811,
    0.012687304, -0.011566276, 0.01238268, -0.011627889, 0.011869849, -0.011465268, 0.011169123, -0.011075674,
    0.010303336, -0.010461045, 0.0092973243, -0.009627942, 0.0081774024, -0.0085874097, 0.00697082, -0.0073547787,
    0.0057052155, -0.0059493748, 0.0044080694, -0.0043941792, 0.0031061731, -0.0027154128, 0.0018251112, -0.00094207097,
    0.00058877678, 0.00089459657, -0.00058107794, 0.0027616499, -0.0016652432, 0.0046250583, -0.0026473978, 0.0064503294,
    -0.0035143902, 0.0082031535, -0.0042564487, 0.0098500587, -0.004867312, 0.011359059, -0.0053442805, 0.012700289,
    -0.0056881784, 0.013846606, -0.005903231, 0.014774157, -0.005996861, 0.015462888, -0.0059794001, 0.015896989,
    -0.0058637299, 0.01606526, -0.0056648538, 0.015961399, -0.0053994185, 0.01558418, -0.0050851903, 0.014937551,
    -0.0047405036, 0.014030606, -0.0043836995, 0.012877463, -0.0040325602, 0.011497032, -0.0037037728, 0.0099126762,
    -0.0034124162, 0.0081517817, -0.0031715068, 0.0062452359, -0.0029916021, 0.0042268233, -0.0028804804, 0.002132565,
};

const float ff_on2avc_ctab_4[2048] = {
    0.0, 1.9999924, -0.0000058932724, -0.00018632905, -0.000023430526, -0.00036967263, -0.000052186413, -0.00054710143,
    -0.000091459828, -0.00071579742, -0.00014028551, -0.00087310647, -0.00019745006, -0.0010165883, -0.00026151221, -0.0011440613,
    -0.00033082708, -0.0012536434, -0.00040357397, -0.0013437853, -0.00047778775, -0.0014132988, -0.00055139291, -0.0014613763,
    -0.0006222403, -0.0014876042, -0.00068814593, -0.0014919674, -0.00074693147, -0.0014748453, -0.00079646555, -0.0014370022,
    -0.00083470601, -0.0013795681, -0.00085974159, -0.001304013, -0.00086983346, -0.0012121156, -0.00086345506, -0.0011059257,
    -0.00083932967, -0.00098772196, -0.00079646567, -0.00085996656, -0.00073418743, -0.0007252564, -0.00065216236, -0.00058627356,
    -0.00055042218, -0.00044573518, -0.0004293785, -0.00030634343, -0.00028983151, -0.00017073752, -0.00013297109, -0.000041447816,
    0.000039629722, 0.000079147045, 0.00022602957, 0.00018885947, 0.00042394208, 0.00028572831, 0.00063076714, 0.0003680501,
    0.00084363052, 0.00043440601, 0.0010594303, 0.00048368447, 0.0012748899, 0.0005150995, 0.0014866164, 0.0005282049,
    0.0016911632, 0.00052290427, 0.0018850935, 0.00049945683, 0.0020650467, 0.00045847919, 0.0022278025, 0.00040094266,
    0.0023703419, 0.00032816609, 0.0024899046, 0.00024180381, 0.0025840413, 0.0001438281, 0.0026506572, 0.00003650627,
    0.0026880486, -0.000077628843, 0.002694932, -0.00019581451, 0.0026704618, -0.00031510059, 0.002614242, -0.00043239864,
    0.0025263282, -0.0005445375, 0.0024072223, -0.00064832467, 0.0022578605, -0.00074061239, 0.0020795963, -0.00081836781,
    0.0018741783, -0.00087874458, 0.0016437257, -0.0009191549, 0.0013906998, -0.00093733944, 0.0011178757, -0.0009314327,
    0.0008283116, -0.00090002158, 0.0005253178, -0.00084219524, 0.0002124242, -0.00075758353, -0.00010665277, -0.00064638274,
    -0.0004280459, -0.00050936721, -0.00074777508, -0.00034788603, -0.0010617886, -0.00016384445, -0.0013660089, 0.000040329032,
    -0.0016563823, 0.00026172952, -0.001928934, 0.0004970344, -0.0021798278, 0.00074257207, -0.0024054295, 0.00099439803,
    -0.0026023739, 0.0012483762, -0.0027676339, 0.0015002612, -0.0028985876, 0.0017457816, -0.0029930845, 0.0019807185,
    -0.0030495061, 0.0022009795, -0.0030668175, 0.0024026663, -0.0030446108, 0.002582133, -0.0029831338, 0.0027360369,
    -0.0028833048, 0.0028613801, -0.0027467103, 0.0029555426, -0.002575587, 0.0030163093, -0.0023727834, 0.0030418884,
    -0.0021417083, 0.0030309267, -0.00188626, 0.0029825219, -0.001610745, 0.0028962295, -0.0013197823, 0.0027720702,
    -0.0010182032, 0.002610537, -0.00071094313, 0.0024125993, -0.00040293398, 0.0021797076, -0.000098998527, 0.0019137961,
    0.00019625042, 0.0016172826, 0.0004785021, 0.0012930647, 0.00074382918, 0.00094451016, 0.00098875654, 0.00057544146,
    0.0012103159, 0.00019011059, 0.0014060856, -0.00020683407, 0.0015742163, -0.00061039196, 0.0017134408, -0.001015265,
    0.0018230709, -0.0014159229, 0.0019029821, -0.0018066789, 0.0019535855, -0.0021817745, 0.0019757913, -0.0025354712,
    0.0019709636, -0.002862151, 0.0019408683, -0.0031564159, 0.0018876162, -0.0034131943, 0.0018136023, -0.003627843,
    0.0017214427, -0.0037962461, 0.0016139107, -0.0039149108, 0.0014938725, -0.0039810524, 0.0013642251, -0.0039926702,
    0.0012278357, -0.0039486135, 0.001087485, -0.0038486305, 0.0009458157, -0.0036934058, 0.00080528553, -0.0034845807,
    0.00066812726, -0.0032247561, 0.0005363166, -0.0029174781, 0.00041154691, -0.0025672072, 0.00029521331, -0.0021792662,
    0.00018840475, -0.0017597722, 0.000091904491, -0.0013155513, 0.0000061986657, -0.00085403392, -0.000068508154, -0.00038313636,
    -0.00013227122, 0.000088872715, -0.00018537903, 0.00055351778, -0.00022832313, 0.0010022718, -0.00026176605, 0.0014267182,
    -0.0002865085, 0.0018187162, -0.00030345729, 0.002170566, -0.00031359497, 0.0024751695, -0.00031795207, 0.0027261837,
    -0.0003175826, 0.0029181617, -0.00031354246, 0.0030466772, -0.00030687143, 0.0031084325, -0.00029857742, 0.0031013431,
    -0.00028962348, 0.0030245974, -0.00028091561, 0.0028786955, -0.00027329178, 0.0026654552, -0.00026751086, 0.0023879989,
    -0.00026424107, 0.0020507087, -0.0002640482, 0.0016591615, -0.0002673828, 0.0012200392, -0.00027456757, 0.00074101909,
    -0.00028578506, 0.00023064682, -0.00030106661, -0.00030180693, -0.00032028355, -0.00084650156, -0.00034314199, -0.0013931919,
    -0.00036918154, -0.0019314003, -0.00039777948, -0.002450594, -0.00042816071, -0.0029403649, -0.00045941351, -0.0033906079,
    -0.00049051136, -0.0037916978, -0.00052034017, -0.0041346624, -0.00054773013, -0.0044113463, -0.00057149079, -0.0046145683,
    -0.00059044833, -0.0047382633, -0.00060348323, -0.0047776136, -0.00060956669, -0.0047291601, -0.00060779473, -0.0045908964,
    -0.00059741817, -0.0043623378, -0.00057786785, -0.0040445696, -0.00054877391, -0.0036402657, -0.00050997949, -0.0031536825,
    -0.00046154787, -0.0025906207, -0.0004037637, -0.0019583604, -0.00033712928, -0.0012655669, -0.00026235546, -0.0005221676,
    -0.0001803489, 0.00026079561, -0.000092195645, 0.0010713381, 8.5773814e-7, 0.001896725, 0.000097425305, 0.0027236806,
    0.00019600448, 0.0035386102, 0.00029500009, 0.0043278327, 0.00039274961, 0.0050778165, 0.00048754914, 0.0057754163,
    0.00057768018, 0.0064081079, 0.00066143664, 0.0069642127, 0.00073715224, 0.0074331141, 0.00080322672, 0.0078054559,
    0.00085815141, 0.0080733243, 0.00090053247, 0.0082304087, 0.00092911115, 0.0082721328, 0.00094278029, 0.0081957681,
    0.0009405961, 0.0080005014, 0.00092178461, 0.0076874876, 0.00088574266, 0.0072598509, 0.00083203381, 0.0067226603,
    0.00076037919, 0.0060828608, 0.00067064527, 0.0053491686, 0.0005628299, 0.0045319302, 0.00043704818, 0.0036429393,
    0.00029352194, 0.0026952275, 0.00013257378, 0.0017028196, -0.000045370962, 0.00068046764, -0.00023977279, -0.00035663525,
    -0.00044995558, -0.0013931503, -0.00067507266, -0.0024138922, -0.00091406191, -0.0034041218, -0.0011655915, -0.0043498254,
    -0.0014279993, -0.0052379691, -0.0016992289, -0.0060567264, -0.0019767685, -0.0067956652, -0.0022575972, -0.0074458965,
    -0.0025381455, -0.0080001755, -0.0028142736, -0.0084529584, -0.0030812761, -0.0088004144, -0.0033339155, -0.0090403967,
    -0.0035664875, -0.0091723735, -0.0037729202, -0.0091973282, -0.0039469078, -0.0091176452, -0.0040820716, -0.0089369677,
    -0.004172151, -0.0086600557, -0.0042112102, -0.0082926471, -0.0041938564, -0.0078413244, -0.0041154595, -0.0073133917,
    -0.0039723613, -0.0067167743, -0.0037620636, -0.0060599349, -0.0034833867, -0.0053518065, -0.0031365866, -0.0046017431,
    -0.0027234256, -0.0038194789, -0.002247188, -0.0030150977, -0.001712642, -0.0021989932, -0.0011259451, -0.0013818274,
    -0.00049449678, -0.00057446648, 0.00017325579, 0.00021210148, 0.0008680491, 0.00096687989, 0.0015800633, 0.0016790066,
    0.0022991966, 0.0023379293, 0.0030153422, 0.0029336107, 0.0037186535, 0.0034567595, 0.0043997848, 0.0038990804,
    0.0050500971, 0.0042535327, 0.0056618182, 0.0045145866, 0.0062281508, 0.0046784664, 0.006743324, 0.0047433623,
    0.0072025894, 0.0047096047, 0.0076021603, 0.0045797802, 0.0079391068, 0.0043587871, 0.0082112048, 0.004053812,
    0.0084167644, 0.0036742303, 0.0085544325, 0.0032314239, 0.0086230049, 0.0027385168, 0.008621241, 0.0022100355,
    0.0085477121, 0.0016615022, 0.008400687, 0.0011089721, 0.0081780711, 0.00056853076, 0.0078773974, 0.000055770324,
    0.0074958913, -0.00041473741, 0.007030596, -0.00082994968, 0.006478562, -0.0011788219, 0.0058371006, -0.0014527178,
    0.0051040803, -0.0016457422, 0.0042782673, -0.001754979, 0.0033596819, -0.0017806236, 0.0023499657, -0.0017259984,
    0.0012527303, -0.001597449, 0.000073873452, -0.0014041185, -0.0011781569, -0.001157607, -0.0024921719, -0.00087152363,
    -0.0038541388, -0.00056094711, -0.005247179, -0.00024181118, -0.0066516823, 0.000069761314, -0.0080455355, 0.00035815299,
    -0.0094044767, 0.00060894678, -0.010702565, 0.00080959394, -0.011912759, 0.00095002784, -0.013007595, 0.0010231955,
    -0.013959945, 0.0010254832, -0.014743825, 0.00095701526, -0.015335241, 0.0008218062, -0.015713034, 0.00062775693,
    -0.015859697, 0.0003864867, -0.015762128, 0.00011300056, -0.015412294, -0.00017480124, -0.014807777, -0.00045675918,
    -0.01395216, -0.00071121694, -0.012855255, -0.00091588532, -0.01153313, -0.0010487777, -0.010007947, -0.0010891829,
    -0.0083075836, -0.0010186376, -0.0064650625, -0.00082186121, -0.0045177857, -0.00048761227, -0.0025065942, -0.0000094309362,
    -0.00047468659, 0.00061376783, 0.0015335816, 0.0013772795, 0.0034739727, 0.0022703977, 0.0053036748, 0.0032764203,
    0.0069826017, 0.0043728831, 0.0084746322, 0.0055320212, 0.0097487466, 0.0067214468, 0.010780025, 0.0079050288,
    0.011550448, 0.009043945, 0.012049492, 0.010097877, 0.012274483, 0.011026301, 0.012230681, 0.011789839,
    0.011931112, 0.012351614, 0.01139613, 0.012678572, 0.010652733, 0.012742704, 0.0097336508, 0.012522144,
    0.0086762328, 0.012002093, 0.0075211856, 0.011175527, 0.0063111861, 0.010043681, 0.0050894427, 0.0086162686,
    0.0038982306, 0.006911451, 0.0027774705, 0.0049555404, 0.0017633948, 0.0027824503, 0.00088734273, 0.00043292236,
    0.00017473225, -0.0020464575, -0.00035576228, -0.0046044104, -0.00069279957, -0.0071862484, -0.00083271071, -0.009735249,
    -0.00077958073, -0.012194071, -0.00054507388, -0.01450618, -0.00014801256, -0.016617225, 0.00038627203, -0.018476345,
    0.0010267919, -0.020037353, 0.0017379262, -0.021259794, 0.0024805821, -0.022109814, 0.003213454, -0.022560883,
    0.0038943416, -0.022594307, 0.004481487, -0.022199562, 0.0049348958, -0.021374447, 0.0052176043, -0.020125058,
    0.0052968613, -0.018465608, 0.0051452029, -0.016418114, 0.0047413921, -0.014011954, 0.0040712133, -0.011283341,
    0.0031281023, -0.0082747173, 0.0019136185, -0.0050341059, 0.00043774495, -0.001614425, -0.0012809716, 0.0019271988,
    -0.0032154371, 0.0055301157, -0.0053301733, 0.009130815, -0.0075816144, 0.012663559, -0.0099185258, 0.016060976,
    -0.012282523, 0.019254617, -0.014608691, 0.022175461, -0.016826265, 0.024754377, -0.018859385, 0.026922559,
    -0.02062788, 0.028611908, -0.022048112, 0.029755389, -0.023033798, 0.03028737, -0.023496887, 0.030143932,
    -0.023348402, 0.029263169, -0.022499284, 0.027585492, -0.020861225, 0.025053922, -0.018347459, 0.021614388,
    -0.014873539, 0.017216032, -0.010358062, 0.011811542, -0.0047233663, 0.0053574666, 0.0021038246, -0.0021854306,
    0.010191803, -0.010851817, 0.019603329, -0.020671425, 0.030395132, -0.031668674, 0.04261747, -0.043862291,
    0.056313749, -0.057264935, 0.07152018, -0.071882829, 0.088265501, -0.087715395, 0.10657079, -0.10475491,
    0.12644924, -0.1229862, 0.14790612, -0.14238638, 0.17093869, -0.16292457, 0.19553615, -0.18456177,
    0.22167984, -0.20725067, 0.24934319, -0.23093559, 0.27849197, -0.25555256, 0.3090845, -0.28102925,
    0.34107187, -0.30728522, 0.37439832, -0.33423212, 0.40900153, -0.361774, 0.44481304, -0.38980758,
    0.48175868, -0.41822296, 0.51975912, -0.44690385, 0.55873019, -0.47572839, 0.59858364, -0.50456971,
    0.63922757, -0.53329676, 0.68056691, -0.56177497, 0.72250432, -0.58986712, 0.76494032, -0.61743438,
    0.80777425, -0.64433688, 0.8509047, -0.67043501, 0.89423001, -0.69559014, 0.93764895, -0.71966553,
    0.98106116, -0.74252748, 1.0243676, -0.76404625, 1.0674711, -0.78409678, 1.1102771, -0.80255991,
    1.152693, -0.81932294, 1.1946301, -0.83428079, 1.2360026, -0.84733653, 1.2767284, -0.85840225,
    1.3167298, -0.86739963, 1.3559328, -0.87426066, 1.3942684, -0.87892807, 1.4316717, -0.88135582,
    1.468083, -0.88150936, 1.5034472, -0.87936598, 1.5377145, -0.87491488, 1.5708399, -0.86815733,
    1.6027837, -0.85910636, 1.6335113, -0.84778708, 1.6629931, -0.83423591, 1.6912047, -0.81850064,
    1.7181267, -0.80063975, 1.7437447, -0.78072208, 1.7680489, -0.75882602, 1.7910345, -0.73503911,
    1.8127009, -0.70945716, 1.833052, -0.68218356, 1.8520958, -0.65332848, 1.8698444, -0.62300795,
    1.8863133, -0.59134328, 1.9015219, -0.55845982, 1.9154925, -0.52448642, 1.9282508, -0.48955446,
    1.9398252, -0.45379704, 1.9502468, -0.41734815, 1.9595492, -0.38034189, 1.9677683, -0.34291169,
    1.9749422, -0.30518964, 1.9811107, -0.26730573, 1.9863157, -0.22938718, 1.9906008, -0.1915579,
    1.994011, -0.15393782, 1.9965928, -0.11664244, 1.998394, -0.079782248, 1.9994637, -0.043462355,
    1.9998517, -0.0077820257, 1.9996089, 0.027165633, 1.9987869, 0.061293982, 1.997438, 0.094523117,
    1.9956142, 0.12678003, 1.9933683, 0.15799879, 1.9907526, 0.18812059, 1.9878191, 0.21709381,
    1.9846191, 0.24487394, 1.981203, 0.27142358, 1.97762, 0.29671216, 1.9739178, 0.3207159,
    1.9701425, 0.3434175, 1.9663377, 0.36480582, 1.9625452, 0.38487554, 1.9588039, 0.40362692,
    1.95515, 0.42106527, 1.9516169, 0.43720058, 1.9482347, 0.45204708, 1.9450303, 0.46562275,
    1.9420276, 0.47794896, 1.9392464, 0.48904994, 1.9367039, 0.49895242, 1.9344136, 0.50768507,
    1.9323857, 0.51527834, 1.9306273, 0.52176386, 1.929143, 0.52717417, 1.9279337, 0.53154266,
    1.9269985, 0.53490293, 1.9263337, 0.5372889, 1.9259334, 0.5387345, 1.9257902, 0.53927344,
    1.9258945, 0.53893936, 1.9262359, 0.53776574, 1.9268025, 0.53578556, 1.9275814, 0.53303164,
    1.9285592, 0.5295366, 1.9297218, 0.52533281, 1.9310548, 0.52045238, 1.9325439, 0.51492745,
    1.9341741, 0.50879002, 1.9359311, 0.50207198, 1.9378004, 0.4948054, 1.9397678, 0.48702216,
    1.9418195, 0.47875434, 1.943942, 0.47003385, 1.9461217, 0.46089265, 1.9483463, 0.45136252,
    1.9506031, 0.44147509, 1.9528806, 0.43126175, 1.9551672, 0.42075339, 1.9574521, 0.40998054,
    1.9597249, 0.39897302, 1.9619763, 0.38775995, 1.964197, 0.37636963, 1.9663788, 0.3648293,
    1.968514, 0.35316524, 1.9705957, 0.3414025, 1.9726177, 0.32956493, 1.9745748, 0.31767496,
    1.9764622, 0.30575377, 1.9782765, 0.29382104, 1.9800144, 0.28189498, 1.981674, 0.26999241,
    1.9832535, 0.25812861, 1.9847524, 0.24631737, 1.9861704, 0.23457102, 1.9875079, 0.22290041,
    1.988766, 0.21131492, 1.9899458, 0.1998225, 1.9910489, 0.18842971, 1.9920776, 0.17714165,
    1.9930336, 0.16596206, 1.9939193, 0.15489329, 1.9947368, 0.14393641, 1.9954883, 0.13309111,
    1.996176, 0.1223558, 1.9968017, 0.11172768, 1.9973674, 0.1012027, 1.9978747, 0.090775654,
    1.998325, 0.080440246, 1.9987197, 0.070189148, 1.9990598, 0.060014058, 1.9993461, 0.049905833,
    1.9995795, 0.039854541, 1.9997605, 0.029849617, 1.9998894, 0.019879945, 1.9999666, 0.0099340044,
};
