/*###############################################################################
# Linux Management Providers (LMP), Battery provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_BATTERYACCESS_H_
#define OPENDRIM_BATTERYACCESS_H_

#include "Battery_Common.h"

#include "OpenDRIM_Battery.h"

int Battery_OpenDRIM_Battery_load(const CMPIBroker* broker, string& errorMessage);

int Battery_OpenDRIM_Battery_unload(string& errorMessage);

int Battery_OpenDRIM_Battery_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_Battery>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Battery_OpenDRIM_Battery_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_Battery& instance, const char** properties, string& errorMessage);

int Battery_OpenDRIM_Battery_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& newInstance, const OpenDRIM_Battery& oldInstance, const char** properties, string& errorMessage);

int Battery_OpenDRIM_Battery_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, string& errorMessage);

int Battery_OpenDRIM_Battery_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, string& errorMessage);

int Battery_OpenDRIM_Battery_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, const OpenDRIM_Battery_RequestStateChange_In& in, OpenDRIM_Battery_RequestStateChange_Out& out, string& errorMessage);

int Battery_OpenDRIM_Battery_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, const OpenDRIM_Battery_SetPowerState_In& in, string& errorMessage);

int Battery_OpenDRIM_Battery_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, string& errorMessage);

int Battery_OpenDRIM_Battery_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, const OpenDRIM_Battery_EnableDevice_In& in, string& errorMessage);

int Battery_OpenDRIM_Battery_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, const OpenDRIM_Battery_OnlineDevice_In& in, string& errorMessage);

int Battery_OpenDRIM_Battery_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, const OpenDRIM_Battery_QuiesceDevice_In& in, string& errorMessage);

int Battery_OpenDRIM_Battery_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, string& errorMessage);

int Battery_OpenDRIM_Battery_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, string& errorMessage);

int Battery_OpenDRIM_Battery_populate(OpenDRIM_Battery& instance, string& errorMessage);

#endif /*OPENDRIM_BATTERYACCESS_H_*/
