/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#include "DHCP_Common.h"

int get_dhcp_leases(dhcp_lease &lease,string key,string &option,string &errorMessage)
{
	// dhcp_client lease path
	string filepath;
	
	CF_assert(get_dhcp_lease_path(filepath,errorMessage));
	
	// all the leases from the dhclient.leases file
	list<dhcp_lease> leases;
	
	// try to open the dhclient.leases file
	ifstream leasesFile;
	
	leasesFile.open(filepath.c_str());
	if (!leasesFile)
	{
		errorMessage= "Cannot open dhcp leases file.\n";
		return NOT_FOUND;
	}
	
	string line = "";
	char c;
	bool inLease = false;
	int leaseCount = 0;
	dhcp_lease currentLease;
	
	while (leasesFile)
	{
		leasesFile.get(c);
		switch (c)
		{
			case '{':
				inLease = true;
				break;
			case '}':
				inLease = false;
				leases.push_front(currentLease);
				currentLease = dhcp_lease();
				break;
			case '\n':
				if (inLease)
				{
					if (line.length() > 0)
					{
						int startOfs = line.find_first_not_of(" \t");
						int endOfs = line.find_last_of(";");
						// trim extra stuff off from line
						line = line.substr(startOfs, endOfs-startOfs);
						
						if (line.find("option") != string::npos )
						{
							// drop the option keyword
							line = line.substr(7);
							size_t ofs = line.find_first_of(" ");
							
							// extract the option name
							string key = line.substr(0,  ofs);
							
							// extract the comma delimited values
							list<string> values;
							line = line.substr(ofs+1);
							while (line.length())
							{
								ofs = line.find_first_of(',');
								string valStr;
								if (ofs == string::npos)
								{
									//ofs = line.length();
									ofs = 0;
									valStr = line;
									line = "";
								}
								else
								{
									valStr = line.substr(0, ofs);
									line = line.substr(ofs+1);
								}
								values.push_back(valStr);
							} // while
							pair<string, list<string> > p(key,values);
							currentLease.options.insert(p);
						}
						else if (line.find("renew") != string::npos)
						{
							// drop the expire and expire  number keyword
							line = line.substr(8);
							size_t endofs = line.find_last_of("\"");
							
							// extract the interface name
							currentLease.renew=line.substr(0,endofs);
						}
						else if (line.find("rebind") != string::npos)
						{
							// drop the expire and expire  number keyword
							line = line.substr(9);
							size_t endofs = line.find_last_of("\"");
							
							// extract the interface name
							currentLease.rebind=line.substr(0,endofs);
						}
						else if (line.find("expire") != string::npos)
						{
							// drop the expire and expire  number keyword
							line = line.substr(9);
							size_t endofs = line.find_last_of("\"");
							
							// extract the interface name
							currentLease.expire=line.substr(0,endofs);
						}
						else if (line.find("interface") != string::npos)
						{
							size_t ofs = line.find_first_of("\"");
							size_t endofs = line.find_last_of("\"");
							
							// extract the interface name
							currentLease.interface=line.substr(ofs,endofs);
						}
						else if (line.find("fixed-address") != string::npos)
						{
							size_t ofs = line.find_first_of(" ")+1;
							size_t endofs = line.find_last_of(";");
							
							// extract the adress name
							currentLease.address=line.substr(ofs,endofs);
						}
						
						// reset the line string
						line = "";
					}
				}
				break;

			default:
				if (inLease)
				{
					line += c;
				}
		}
	} // while lease file has values
	
	// retreive the last lease in the file (tokenize entire contents by { and } delimiters
	if (leases.size() > 0)
	{
		list<dhcp_lease>::iterator itr = leases.begin();
		lease = *itr;
		
		// get the requested option
		map<string, list<string> >::iterator valItr = lease.options.find(key);
		if (valItr != lease.options.end())
		{
			pair<string, list<string> > p = *valItr;
			list<string> valList = p.second;
			list<string>::iterator itmItr = valList.begin();
			option=*itmItr;
		}
		else
		{
			// this option could not be found in the lease
			errorMessage=key+" option could not be found in the lease";
			return NOT_FOUND;
		}
	}
	return OK;
}

int get_dhcp_lease_path(string &path, string &errorMessage)
{
	string stdOut, stdErr,start;
	int errorCode;
	start="/var/lib";
	
	CF_assertWithString(CF_runCommand("ls "+start+" |grep dhcp", stdOut, stdErr, errorMessage),"Cannot find dhcp folder from "+start);
	
	start+="/";
	start+=stdOut.substr(0,stdOut.find_last_of("\n\r"));
	stdOut="";
	
	CF_assertWithString(CF_runCommand("ls "+start+" |grep eth0.leases", stdOut, stdErr, errorMessage),"Cannot find dhcp  client configuration from "+start);
	
	start+="/";
	start+=stdOut.substr(0,stdOut.find_last_of("\n\r"));
	path=start;
	return OK;
}

int dhcp_ethernet_names(vector<string> &names,string &errorMessage)
{
	string filepath1("/etc/network/interfaces");
	ifstream ifs1(filepath1.c_str(), ifstream::in);
	
	if(!ifs1.is_open())
	{
		errorMessage = "Failed to open /etc/network/interfaces";
		return FAILED;
	}
	
	string line;
	while(getline(ifs1, line))
	{
		if(CF_startsWith(line,"iface"))
		{
			string ethname;
			bool is_dhcp;
			
			ethname=line.substr(line.find_first_of(" ")+1);
			ethname=ethname.substr(0,ethname.find_first_of(" "));
			is_dhcp=CF_endsWith(line,"dhcp");
			
			if(ethname!="lo" && is_dhcp )
				names.push_back(ethname);
		}
	}
	
	if (names.size()==0)
		return NOT_FOUND;
	else 
		return OK;
}

