/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#ifndef OPENDRIM_DHCPELEMENTCAPABILITIES_H_
#define OPENDRIM_DHCPELEMENTCAPABILITIES_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_Capabilities.h"
#include "CIM_CapabilitiesAccess.h"
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
*/

const static char* OpenDRIM_DHCPElementCapabilities_classnames[] = {"OpenDRIM_DHCPElementCapabilities"};
static string OpenDRIM_DHCPElementCapabilities_NAMESPACE = _NAMESPACE;
const static string Capabilities_role = "Capabilities";
const static char* Capabilities_classnames[] = {"OpenDRIM_DHCPCapabilities"};
const static string Capabilities_NAMESPACE = _NAMESPACE;

const static string ManagedElement_role = "ManagedElement";
const static char* ManagedElement_classnames[] = {"OpenDRIM_DHCPProtocolEndpoint"};
const static string ManagedElement_NAMESPACE = _NAMESPACE;

class OpenDRIM_DHCPElementCapabilities {

public:
	
	Objectpath ManagedElement;
	bool ManagedElement_isNULL;
	
	Objectpath Capabilities;
	bool Capabilities_isNULL;
	
	vector<unsigned short> Characteristics;
	bool Characteristics_isNULL;
	
	OpenDRIM_DHCPElementCapabilities() {
		ManagedElement_isNULL = true;
		Capabilities_isNULL = true;
		Characteristics_isNULL = true;
	}
	
	~OpenDRIM_DHCPElementCapabilities() {}
	
	string getKeys() const {
		return CF_toLowCase(".ManagedElement=\"" + CF_quoteString(ManagedElement.toString()) + "\""".Capabilities=\"" + CF_quoteString(Capabilities.toString()) + "\"");
	}

	int getManagedElement(Objectpath& value) const {
		if (ManagedElement_isNULL==true)
			return NOT_FOUND;
		value = ManagedElement;
		return OK;
	}
	
	int setManagedElement(const Objectpath& newValue) {
		ManagedElement = newValue;
		ManagedElement.setNamespace(ManagedElement_NAMESPACE);
		ManagedElement_isNULL = false;
		return OK;
	}

	int getCapabilities(Objectpath& value) const {
		if (Capabilities_isNULL==true)
			return NOT_FOUND;
		value = Capabilities;
		return OK;
	}
	
	int setCapabilities(const Objectpath& newValue) {
		Capabilities = newValue;
		Capabilities.setNamespace(Capabilities_NAMESPACE);
		Capabilities_isNULL = false;
		return OK;
	}

	int getCharacteristics(vector<unsigned short>& value) const {
		if (Characteristics_isNULL==true)
			return NOT_FOUND;
		value = Characteristics;
		return OK;
	}
	
	int setCharacteristics(const vector<unsigned short>& newValue) {
		Characteristics = newValue;
		Characteristics_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_DHCPELEMENTCAPABILITIES_H_*/
