/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_AssociatedPowerManagementService.h"

CMPIObjectPath* PowerManagement_OpenDRIM_AssociatedPowerManagementService_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_AssociatedPowerManagementService& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_AssociatedPowerManagementService_classnames[0], OpenDRIM_AssociatedPowerManagementService_NAMESPACE);

	if (!instance.ServiceProvided_isNULL)
		op.addKey("ServiceProvided", instance.ServiceProvided);

	if (!instance.UserOfService_isNULL)
		op.addKey("UserOfService", instance.UserOfService);

	_L_;
	return op.getHdl();
}

CMPIInstance* PowerManagement_OpenDRIM_AssociatedPowerManagementService_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_AssociatedPowerManagementService& instance) {
	_E_;
	Objectpath op(broker, PowerManagement_OpenDRIM_AssociatedPowerManagementService_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.PowerState_isNULL)
		ci.setProperty("PowerState", instance.PowerState);

	if (!instance.OtherPowerState_isNULL)
		ci.setProperty("OtherPowerState", instance.OtherPowerState);

	if (!instance.RequestedPowerState_isNULL)
		ci.setProperty("RequestedPowerState", instance.RequestedPowerState);

	if (!instance.OtherRequestedPowerState_isNULL)
		ci.setProperty("OtherRequestedPowerState", instance.OtherRequestedPowerState);

	if (!instance.PowerOnTime_isNULL)
		ci.setPropertyDatetime("PowerOnTime", instance.PowerOnTime);

	_L_;
	return ci.getHdl();
}

void PowerManagement_OpenDRIM_AssociatedPowerManagementService_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_AssociatedPowerManagementService& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("UserOfService", instance.UserOfService) == OK)
		instance.UserOfService_isNULL = false;

	if (op.getKey("ServiceProvided", instance.ServiceProvided) == OK)
		instance.ServiceProvided_isNULL = false;

	_L_;
}

void PowerManagement_OpenDRIM_AssociatedPowerManagementService_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_AssociatedPowerManagementService& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("ServiceProvided", instance.ServiceProvided) == OK)
		instance.ServiceProvided_isNULL = false;

	if (inst.getProperty("UserOfService", instance.UserOfService) == OK)
		instance.UserOfService_isNULL = false;

	if (inst.getProperty("PowerState", instance.PowerState) == OK)
		instance.PowerState_isNULL = false;

	if (inst.getProperty("OtherPowerState", instance.OtherPowerState) == OK)
		instance.OtherPowerState_isNULL = false;

	if (inst.getProperty("RequestedPowerState", instance.RequestedPowerState) == OK)
		instance.RequestedPowerState_isNULL = false;

	if (inst.getProperty("OtherRequestedPowerState", instance.OtherRequestedPowerState) == OK)
		instance.OtherRequestedPowerState_isNULL = false;

	if (inst.getPropertyDatetime("PowerOnTime", instance.PowerOnTime) == OK)
		instance.PowerOnTime_isNULL = false;

	_L_;
}

