#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Broken Sword 4
# send your bug reports to contact@dotslashplay.it
###

script_version=20240822.2

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='broken-sword-4'
GAME_NAME='Broken Sword Ⅳ: The Angel of Death'

ARCHIVE_BASE_FR_1_NAME='setup_broken_sword_4_the_angel_of_death_1.1a_(french)_(24519).exe'
ARCHIVE_BASE_FR_1_MD5='75736ac9d99d3a9c8fcc509bf425eaa3'
ARCHIVE_BASE_FR_1_TYPE='innosetup'
ARCHIVE_BASE_FR_1_PART1_NAME='setup_broken_sword_4_the_angel_of_death_1.1a_(french)_(24519)-1.bin'
ARCHIVE_BASE_FR_1_PART1_MD5='3600609e744183605ca94f5ab5e36325'
ARCHIVE_BASE_FR_1_SIZE='2800000'
ARCHIVE_BASE_FR_1_VERSION='1.1a-gog24519'
ARCHIVE_BASE_FR_1_URL='https://www.gog.com/game/broken_sword_4'

ARCHIVE_BASE_EN_1_NAME='setup_broken_sword_4_the_angel_of_death_1.1a_(24519).exe'
ARCHIVE_BASE_EN_1_MD5='25ed1fcd2a322bc6f722b84e899cdeb0'
ARCHIVE_BASE_EN_1_TYPE='innosetup'
ARCHIVE_BASE_EN_1_PART1_NAME='setup_broken_sword_4_the_angel_of_death_1.1a_(24519)-1.bin'
ARCHIVE_BASE_EN_1_PART1_MD5='75e4b7cc0c7d96f56c070a71442c49c0'
ARCHIVE_BASE_EN_1_SIZE='2800000'
ARCHIVE_BASE_EN_1_VERSION='1.1a-gog24519'
ARCHIVE_BASE_EN_1_URL='https://www.gog.com/game/broken_sword_4'

ARCHIVE_BASE_EN_0_NAME='setup_broken_sword_4_1.1_(15751).exe'
ARCHIVE_BASE_EN_0_MD5='b53297cce551b12e8bef23dade1eda68'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_PART1_NAME='setup_broken_sword_4_1.1_(15751)-1.bin'
ARCHIVE_BASE_EN_0_PART1_MD5='4518a353cc41a95745095ddfb220c750'
ARCHIVE_BASE_EN_0_SIZE='2900000'
ARCHIVE_BASE_EN_0_VERSION='1.1-gog15751'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_EN_0='app'
CONTENT_GAME_BIN_FILES='
system
bs4pc.exe
*.dll'
CONTENT_GAME_L10N_FILES='
english.pak
french.pak'
CONTENT_GAME_DATA_FILES='
data
audio.pak
bs4.pak'
CONTENT_GAME0_DATA_PATH="${CONTENT_PATH_DEFAULT}/app"
CONTENT_GAME0_DATA_FILES='
data'
CONTENT_DOC_DATA_FILES='
manual.pdf'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/Broken Sword - The Angel of Death'
## TODO: Check if the virtual desktop is still required with current WINE builds
WINE_VIRTUAL_DESKTOP='auto'
## Using the built-in Direct3D shaders compiler, the game is not displayed correctly
## Multiple errors related to shader compilation are spammed in WINE debug output
## TODO: Check if it is still a problem with current WINE builds
WINE_WINETRICKS_VERBS='d3dcompiler_47'

APP_MAIN_EXE='bs4pc.exe'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_BASE_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_BASE_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
