#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Batman: Arkham Knight
# send your bug reports to contact@dotslashplay.it
###

script_version=20231130.2

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='batman-arkham-4'
GAME_NAME='Batman: Arkham Knight'

ARCHIVE_BASE_0_NAME='setup_batman_arkham_knight_1.98_(37902).exe'
ARCHIVE_BASE_0_MD5='73307c30caaf63052132968a923f13ec'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
## Do not convert file paths to lower case.
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS=' '
ARCHIVE_BASE_0_PART1_NAME='setup_batman_arkham_knight_1.98_(37902)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='82a14c0140c2d3bfb587d55559edd3ab'
ARCHIVE_BASE_0_PART2_NAME='setup_batman_arkham_knight_1.98_(37902)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='075b116c6f6c79bc682a1dcd020e4910'
ARCHIVE_BASE_0_PART3_NAME='setup_batman_arkham_knight_1.98_(37902)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='ccf091fe25df898fb692854ffba23e95'
ARCHIVE_BASE_0_PART4_NAME='setup_batman_arkham_knight_1.98_(37902)-4.bin'
ARCHIVE_BASE_0_PART4_MD5='128dcddb67ed6c9838e802a82d29267f'
ARCHIVE_BASE_0_PART5_NAME='setup_batman_arkham_knight_1.98_(37902)-5.bin'
ARCHIVE_BASE_0_PART5_MD5='e4a186a946e10780ddc58e8ca79d6794'
ARCHIVE_BASE_0_PART6_NAME='setup_batman_arkham_knight_1.98_(37902)-6.bin'
ARCHIVE_BASE_0_PART6_MD5='ea31bab1b5ff9410a30663f2cd8ca35f'
ARCHIVE_BASE_0_PART7_NAME='setup_batman_arkham_knight_1.98_(37902)-7.bin'
ARCHIVE_BASE_0_PART7_MD5='e7726a1f658c9b29387bad9b10e8e4a3'
ARCHIVE_BASE_0_PART8_NAME='setup_batman_arkham_knight_1.98_(37902)-8.bin'
ARCHIVE_BASE_0_PART8_MD5='647176434aa98a19cce3edf625ef8631'
ARCHIVE_BASE_0_PART9_NAME='setup_batman_arkham_knight_1.98_(37902)-9.bin'
ARCHIVE_BASE_0_PART9_MD5='c8f4833b789186d3b03ff44af93b883b'
ARCHIVE_BASE_0_PART10_NAME='setup_batman_arkham_knight_1.98_(37902)-10.bin'
ARCHIVE_BASE_0_PART10_MD5='389d3f38c987268dfdb85c489b2e4831'
ARCHIVE_BASE_0_PART11_NAME='setup_batman_arkham_knight_1.98_(37902)-11.bin'
ARCHIVE_BASE_0_PART11_MD5='18947e9bd6b4a0b4ec35998f78961c88'
ARCHIVE_BASE_0_PART12_NAME='setup_batman_arkham_knight_1.98_(37902)-12.bin'
ARCHIVE_BASE_0_PART12_MD5='d67afeb3f4a687255d79ad1c1f45516e'
ARCHIVE_BASE_0_SIZE='53000000'
ARCHIVE_BASE_0_VERSION='1.98-gog37902'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/batman_arkham_knight'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
Binaries
Engine
BmGame/Config'
CONTENT_GAME_TEXTURES1_FILES='
BmGame/CookedPCConsole/Chunk0.tfc
BmGame/CookedPCConsole/Chunk1.tfc
BmGame/CookedPCConsole/Chunk2.tfc
BmGame/CookedPCConsole/Chunk3.tfc
BmGame/CookedPCConsole/Chunk4.tfc
BmGame/CookedPCConsole/Chunk5.tfc'
CONTENT_GAME_TEXTURES2_FILES='
BmGame/CookedPCConsole/Chunk6.tfc
BmGame/CookedPCConsole/Chunk7.tfc
BmGame/CookedPCConsole/Chunk8.tfc
BmGame/CookedPCConsole/Textures.tfc'
CONTENT_GAME_PACKAGES1_FILES='
BmGame/CookedPCConsole/City*.upk'
CONTENT_GAME_PACKAGES2_FILES='
BmGame/CookedPCConsole/*.upk'
CONTENT_GAME_MOVIES_FILES='
BmGame/Movies'
CONTENT_GAME_DATA_FILES='
BmGame/Splash
BmGame/CookedPCConsole/SFX
BmGame/CookedPCConsole/*.bin
BmGame/CookedPCConsole/English(US)
BmGame/Localization/INT'

USER_PERSISTENT_DIRECTORIES='
BmGame/Config
BmGame/SaveData'

WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/WB Games/Batman Arkham Knight'
WINE_WINETRICKS_VERBS='physx'

APP_MAIN_EXE='Binaries/Win64/BatmanAK.exe'
## Run the game binary from its parent directory.
APP_MAIN_PRERUN="${APP_MAIN_PRERUN:-}"'
# Run the game binary from its parent directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")
'

PACKAGES_LIST='
PKG_BIN
PKG_TEXTURES1
PKG_TEXTURES2
PKG_PACKAGES1
PKG_PACKAGES2
PKG_MOVIES
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_TEXTURES_ID="${GAME_ID}-textures"
PKG_TEXTURES1_ID="${PKG_TEXTURES_ID}-1"
PKG_TEXTURES2_ID="${PKG_TEXTURES_ID}-2"
PKG_TEXTURES_DESCRIPTION='textures'
PKG_TEXTURES1_DESCRIPTION="$PKG_TEXTURES_DESCRIPTION - 1"
PKG_TEXTURES2_DESCRIPTION="$PKG_TEXTURES_DESCRIPTION - 2"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_TEXTURES1_ID $PKG_TEXTURES2_ID"

PKG_PACKAGES_ID="${GAME_ID}-packages"
PKG_PACKAGES1_ID="${PKG_PACKAGES_ID}-1"
PKG_PACKAGES2_ID="${PKG_PACKAGES_ID}-2"
PKG_PACKAGES_DESCRIPTION='packages'
PKG_PACKAGES1_DESCRIPTION="$PKG_PACKAGES_DESCRIPTION - 1"
PKG_PACKAGES2_DESCRIPTION="$PKG_PACKAGES_DESCRIPTION - 2"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_PACKAGES1_ID $PKG_PACKAGES2_ID"

PKG_MOVIES_ID="${GAME_ID}-movies"
PKG_MOVIES_DESCRIPTION='movies'
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_MOVIES_ID"

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

## FIXME: This game should be run in a WINE virtual desktop.

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
