" Vim syntax file
" Language: VICE Gtk3 keymap
" Maintainer: Bas Wassink
" Latest Revision: 2021-10-06

if exists("b:current_syntax")
    finish
endif

" Keywords
syn match vkmKeyword "!\(CLEAR\|INCLUDE\|UNDEF\)"
syn match vkmKeyword "!\([LR]SHIFT\|SHIFTL\|LCBM\|LCTRL\)"
syn keyword vkmShiftKey LSHIFT RSHIFT
syn keyword vkmCtrlKey LCTRL
syn keyword vkmCbmKey LCBM
syn match vkmNumber contained '[-]?\d\+'
syn match vkmShiftFlag contained '\d\+' skipwhite
syn match vkmColumnNumber contained '\d\+' nextgroup=vkmShiftFlag skipwhite
syn match vkmRowNumber contained '[-]\?\d\+' nextgroup=vkmColumnNumber skipwhite
syn match vkmKeyword "!\(VCBM\).*$" contains=vkmCbmKey
syn match vkmKeyword "!\(VCTRL\).*$" contains=vkmCtrlKey
syn match vkmKeyword "!\(VSHIFT\).*$" contains=vkmShiftKey

syn match vkmKeyword "!\(LSHIFT\|RSHIFT\)" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmKeyword "!\(LCBM\|LCTRL\)" nextgroup=vkmRowNumber skipwhite contains=vkmNumber

" TODO and friends
syn keyword vkmTodo TODO FIXME XXX


" Comments
syn match vkmComment "[#;].*$" contains=vkmTodo

" {{{ GDK key names
syn match vkmGdkKeyname "\<VoidSymbol\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<BackSpace\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Tab\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Linefeed\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Clear\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Return\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pause\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Scroll_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sys_Req\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Escape\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Delete\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Multi_key\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Codeinput\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<SingleCandidate\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<MultipleCandidate\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<PreviousCandidate\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Kanji\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Muhenkan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Henkan_Mode\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Henkan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Romaji\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hiragana\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Katakana\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hiragana_Katakana\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Zenkaku\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hankaku\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Zenkaku_Hankaku\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Touroku\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Massyo\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Kana_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Kana_Shift\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Eisu_Shift\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Eisu_toggle\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Kanji_Bangou\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Zen_Koho\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Mae_Koho\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Home\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Left\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Up\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Right\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Down\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Prior\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Page_Up\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Next\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Page_Down\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<End\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Begin\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Select\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Print\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Execute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Insert\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Undo\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Redo\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Menu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Find\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cancel\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Help\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Break\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Mode_switch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<script_switch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Num_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Space\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Tab\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Enter\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_F1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_F2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_F3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_F4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Home\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Left\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Up\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Right\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Down\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Prior\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Page_Up\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Next\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Page_Down\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_End\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Begin\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Insert\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Delete\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Equal\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Multiply\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Add\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Separator\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Subtract\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Decimal\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_Divide\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_0\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_6\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_7\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_8\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KP_9\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F6\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F7\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F8\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F9\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F10\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F11\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<L1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F12\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<L2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F13\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<L3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F14\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<L4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F15\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<L5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F16\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<L6\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F17\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<L7\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F18\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<L8\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F19\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<L9\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F20\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<L10\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F21\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F22\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F23\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F24\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F25\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F26\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R6\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F27\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R7\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F28\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R8\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F29\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R9\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F30\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R10\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F31\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R11\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F32\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R12\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F33\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R13\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F34\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R14\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F35\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R15\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Shift_L\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Shift_R\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Control_L\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Control_R\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Caps_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Shift_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Meta_L\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Meta_R\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Alt_L\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Alt_R\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Super_L\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Super_R\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hyper_L\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hyper_R\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Level2_Latch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Level3_Shift\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Level3_Latch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Level3_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Level5_Shift\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Level5_Latch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Level5_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Group_Shift\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Group_Latch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Group_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Next_Group\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Next_Group_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Prev_Group\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Prev_Group_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_First_Group\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_First_Group_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Last_Group\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Last_Group_Lock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Left_Tab\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Move_Line_Up\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Move_Line_Down\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Partial_Line_Up\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Partial_Line_Down\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Partial_Space_Left\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Partial_Space_Right\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Set_Margin_Left\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Set_Margin_Right\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Release_Margin_Left\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Release_Margin_Right\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Release_Both_Margins\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Fast_Cursor_Left\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Fast_Cursor_Right\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Fast_Cursor_Up\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Fast_Cursor_Down\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Continuous_Underline\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Discontinuous_Underline\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Emphasize\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Center_Object\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ISO_Enter\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_grave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_acute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_circumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_tilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_perispomeni\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_macron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_breve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_abovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_diaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_abovering\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_doubleacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_caron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_cedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_ogonek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_iota\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_voiced_sound\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_semivoiced_sound\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_belowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_hook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_horn\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_stroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_abovecomma\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_psili\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_abovereversedcomma\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_dasia\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_doublegrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_belowring\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_belowmacron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_belowcircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_belowtilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_belowbreve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_belowdiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_invertedbreve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_belowcomma\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_currency\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_a\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_A\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_e\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_E\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_i\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_I\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_o\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_O\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_u\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_U\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_small_schwa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_capital_schwa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dead_greek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<First_Virtual_Screen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Prev_Virtual_Screen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Next_Virtual_Screen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Last_Virtual_Screen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Terminate_Server\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AccessX_Enable\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AccessX_Feedback_Enable\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<RepeatKeys_Enable\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<SlowKeys_Enable\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<BounceKeys_Enable\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<StickyKeys_Enable\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<MouseKeys_Enable\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<MouseKeys_Accel_Enable\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Overlay1_Enable\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Overlay2_Enable\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudibleBell_Enable\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Left\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Right\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Up\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Down\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_UpLeft\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_UpRight\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_DownLeft\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_DownRight\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Button_Dflt\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Button1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Button2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Button3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Button4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Button5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_DblClick_Dflt\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_DblClick1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_DblClick2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_DblClick3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_DblClick4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_DblClick5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Drag_Dflt\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Drag1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Drag2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Drag3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Drag4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Drag5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_EnableKeys\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_Accelerate\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_DfltBtnNext\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pointer_DfltBtnPrev\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<CH\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<c_h\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<C_h\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<C_H\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Duplicate\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_FieldMark\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Right2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Left2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_BackTab\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_EraseEOF\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_EraseInput\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Reset\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Quit\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_PA1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_PA2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_PA3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Test\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Attn\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_CursorBlink\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_AltCursor\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_KeyClick\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Jump\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Ident\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Rule\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Copy\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Play\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Setup\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Record\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_ChangeScreen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_DeleteWord\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_ExSelect\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_CursorSelect\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_PrintScreen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3270_Enter\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<space\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<exclam\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<quotedbl\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<numbersign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dollar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<percent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ampersand\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<apostrophe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<quoteright\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<parenleft\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<parenright\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<asterisk\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<plus\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<comma\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<minus\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<period\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<slash\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<0\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<6\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<7\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<8\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<9\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<colon\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<semicolon\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<less\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<equal\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<greater\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<question\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<at\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<A\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<B\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<C\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<D\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<E\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<F\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<G\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<H\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<I\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<J\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<K\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<L\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<M\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<N\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<O\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<P\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Q\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<R\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<S\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<T\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<U\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<V\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<W\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<X\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Y\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Z\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<bracketleft\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<backslash\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<bracketright\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<asciicircum\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<underscore\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<grave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<quoteleft\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<a\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<b\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<c\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<d\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<e\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<f\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<g\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<h\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<i\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<j\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<k\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<l\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<m\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<n\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<o\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<p\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<q\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<r\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<s\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<t\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<u\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<v\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<w\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<x\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<y\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<z\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braceleft\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<bar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braceright\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<asciitilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<nobreakspace\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<exclamdown\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<cent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<sterling\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<currency\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<yen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<brokenbar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<section\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<diaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<copyright\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ordfeminine\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<guillemotleft\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<notsign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hyphen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<registered\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<macron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<degree\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<plusminus\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<twosuperior\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<threesuperior\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<acute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<mu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<paragraph\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<periodcentered\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<cedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<onesuperior\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<masculine\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<guillemotright\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<onequarter\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<onehalf\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<threequarters\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<questiondown\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Agrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Aacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Acircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Atilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Adiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Aring\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ccedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Egrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Eacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ecircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ediaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Igrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Iacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Icircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Idiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ETH\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Eth\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ntilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ograve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Oacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ocircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Otilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Odiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<multiply\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Oslash\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ooblique\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ugrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Uacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ucircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Udiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Yacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<THORN\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thorn\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ssharp\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<agrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<aacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<acircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<atilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<adiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<aring\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ae\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ccedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<egrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<eacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ecircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ediaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<igrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<iacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<icircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<idiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<eth\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ntilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ograve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<oacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ocircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<otilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<odiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<division\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<oslash\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ooblique\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ugrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ucircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<udiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<yacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<thorn\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ydiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Aogonek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<breve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Lstroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Lcaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Scaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Scedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Tcaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Zacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Zcaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Zabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<aogonek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ogonek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<lstroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<lcaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<sacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<caron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<scaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<scedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<tcaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<zacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<doubleacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<zcaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<zabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Racute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Abreve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Lacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ccaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Eogonek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ecaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Dcaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Dstroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Nacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ncaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Odoubleacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Rcaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Uring\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Udoubleacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Tcedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<racute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<abreve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<lacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<cacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ccaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<eogonek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ecaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dcaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dstroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<nacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ncaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<odoubleacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rcaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uring\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<udoubleacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<tcedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<abovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hstroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hcircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Iabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Gbreve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Jcircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hstroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hcircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<idotless\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<gbreve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<jcircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ccircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Gabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Gcircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ubreve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Scircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<cabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ccircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<gabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<gcircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ubreve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<scircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kra\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kappa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Rcedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Itilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Lcedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Emacron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Gcedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Tslash\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rcedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<itilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<lcedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<emacron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<gcedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<tslash\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ENG\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<eng\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Amacron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Iogonek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Eabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Imacron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ncedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Omacron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Kcedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Uogonek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Utilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Umacron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<amacron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<iogonek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<eabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<imacron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ncedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<omacron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kcedilla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uogonek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<utilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<umacron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Wcircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<wcircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ycircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ycircumflex\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Babovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<babovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Dabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Fabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<fabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Mabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<mabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<pabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<sabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Tabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<tabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Wgrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<wgrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Wacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<wacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Wdiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<wdiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ygrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ygrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<OE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<oe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ydiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<overline\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_fullstop\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_openingbracket\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_closingbracket\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_comma\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_conjunctive\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_middledot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_WO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_a\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_i\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_u\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_e\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_o\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_ya\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_yu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_yo\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_tsu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_tu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<prolongedsound\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_A\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_I\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_U\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_E\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_O\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_KA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_KI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_KU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_KE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_KO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_SA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_SHI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_SU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_SE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_SO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_TA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_CHI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_TI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_TSU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_TU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_TE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_TO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_NA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_NI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_NU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_NE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_NO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_HA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_HI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_FU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_HU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_HE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_HO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_MA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_MI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_MU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_ME\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_MO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_YA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_YU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_YO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_RA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_RI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_RU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_RE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_RO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_WA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_N\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<voicedsound\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<semivoicedsound\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<kana_switch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Farsi_0\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Farsi_1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Farsi_2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Farsi_3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Farsi_4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Farsi_5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Farsi_6\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Farsi_7\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Farsi_8\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Farsi_9\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_percent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_superscript_alef\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_tteh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_peh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_tcheh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_ddal\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_rreh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_comma\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_fullstop\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_0\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_6\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_7\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_8\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_9\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_semicolon\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_question_mark\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_hamza\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_maddaonalef\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_hamzaonalef\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_hamzaonwaw\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_hamzaunderalef\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_hamzaonyeh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_alef\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_beh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_tehmarbuta\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_teh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_theh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_jeem\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_hah\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_khah\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_dal\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_thal\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_ra\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_zain\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_seen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_sheen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_sad\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_dad\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_tah\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_zah\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_ain\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_ghain\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_tatweel\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_feh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_qaf\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_kaf\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_lam\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_meem\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_noon\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_ha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_heh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_waw\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_alefmaksura\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_yeh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_fathatan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_dammatan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_kasratan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_fatha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_damma\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_kasra\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_shadda\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_sukun\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_madda_above\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_hamza_above\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_hamza_below\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_jeh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_veh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_keheh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_gaf\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_noon_ghunna\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_heh_doachashmee\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Farsi_yeh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_farsi_yeh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_yeh_baree\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_heh_goal\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Arabic_switch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_GHE_bar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ghe_bar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ZHE_descender\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_zhe_descender\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_KA_descender\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ka_descender\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_KA_vertstroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ka_vertstroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_EN_descender\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_en_descender\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_U_straight\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_u_straight\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_U_straight_bar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_u_straight_bar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_HA_descender\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ha_descender\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_CHE_descender\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_che_descender\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_CHE_vertstroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_che_vertstroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_SHHA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_shha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_SCHWA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_schwa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_I_macron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_i_macron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_O_bar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_o_bar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_U_macron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_u_macron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Serbian_dje\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Macedonia_gje\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_io\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukrainian_ie\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukranian_je\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Macedonia_dse\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukrainian_i\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukranian_i\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukrainian_yi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukranian_yi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_je\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Serbian_je\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_lje\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Serbian_lje\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_nje\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Serbian_nje\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Serbian_tshe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Macedonia_kje\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukrainian_ghe_with_upturn\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Byelorussian_shortu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_dzhe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Serbian_dze\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<numerosign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Serbian_DJE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Macedonia_GJE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_IO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukrainian_IE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukranian_JE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Macedonia_DSE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukrainian_I\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukranian_I\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukrainian_YI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukranian_YI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_JE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Serbian_JE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_LJE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Serbian_LJE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_NJE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Serbian_NJE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Serbian_TSHE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Macedonia_KJE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ukrainian_GHE_WITH_UPTURN\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Byelorussian_SHORTU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_DZHE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Serbian_DZE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_yu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_a\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_be\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_tse\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_de\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ie\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ef\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ghe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_i\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_shorti\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ka\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_el\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_em\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_en\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_o\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_pe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ya\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_er\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_es\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_te\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_u\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_zhe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_softsign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_yeru\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ze\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_sha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_e\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_shcha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_che\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_hardsign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_YU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_A\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_BE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_TSE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_DE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_IE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_EF\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_GHE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_HA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_I\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_SHORTI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_KA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_EL\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_EM\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_EN\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_O\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_PE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_YA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ER\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ES\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_TE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_U\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ZHE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_VE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_SOFTSIGN\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_YERU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_ZE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_SHA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_E\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_SHCHA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_CHE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cyrillic_HARDSIGN\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_ALPHAaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_EPSILONaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_ETAaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_IOTAaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_IOTAdieresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_IOTAdiaeresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_OMICRONaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_UPSILONaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_UPSILONdieresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_OMEGAaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_accentdieresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_horizbar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_alphaaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_epsilonaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_etaaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_iotaaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_iotadieresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_iotaaccentdieresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_omicronaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_upsilonaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_upsilondieresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_upsilonaccentdieresis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_omegaaccent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_ALPHA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_BETA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_GAMMA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_DELTA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_EPSILON\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_ZETA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_ETA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_THETA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_IOTA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_KAPPA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_LAMDA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_LAMBDA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_MU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_NU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_XI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_OMICRON\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_PI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_RHO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_SIGMA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_TAU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_UPSILON\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_PHI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_CHI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_PSI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_OMEGA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_alpha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_beta\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_gamma\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_delta\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_epsilon\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_zeta\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_eta\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_theta\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_iota\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_kappa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_lamda\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_lambda\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_mu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_nu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_xi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_omicron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_pi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_rho\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_sigma\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_finalsmallsigma\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_tau\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_upsilon\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_phi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_chi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_psi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_omega\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Greek_switch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<leftradical\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<topleftradical\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<horizconnector\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<topintegral\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<botintegral\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<vertconnector\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<topleftsqbracket\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<botleftsqbracket\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<toprightsqbracket\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<botrightsqbracket\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<topleftparens\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<botleftparens\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<toprightparens\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<botrightparens\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<leftmiddlecurlybrace\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rightmiddlecurlybrace\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<topleftsummation\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<botleftsummation\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<topvertsummationconnector\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<botvertsummationconnector\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<toprightsummation\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<botrightsummation\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rightmiddlesummation\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<lessthanequal\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<notequal\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<greaterthanequal\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<integral\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<therefore\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<variation\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<infinity\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<nabla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<approximate\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<similarequal\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ifonlyif\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<implies\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<identical\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<radical\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<includedin\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<includes\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<intersection\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<union\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<logicaland\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<logicalor\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<partialderivative\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<function\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<leftarrow\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uparrow\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rightarrow\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<downarrow\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<blank\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<soliddiamond\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<checkerboard\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ht\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ff\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<cr\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<lf\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<nl\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<vt\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<lowrightcorner\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uprightcorner\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<upleftcorner\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<lowleftcorner\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<crossinglines\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<horizlinescan1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<horizlinescan3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<horizlinescan5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<horizlinescan7\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<horizlinescan9\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<leftt\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rightt\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<bott\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<topt\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<vertbar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<emspace\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<enspace\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<em3space\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<em4space\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<digitspace\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<punctspace\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<thinspace\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hairspace\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<emdash\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<endash\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<signifblank\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ellipsis\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<doubbaselinedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<onethird\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<twothirds\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<onefifth\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<twofifths\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<threefifths\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<fourfifths\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<onesixth\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<fivesixths\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<careof\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<figdash\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<leftanglebracket\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<decimalpoint\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rightanglebracket\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<marker\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<oneeighth\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<threeeighths\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<fiveeighths\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<seveneighths\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<trademark\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<signaturemark\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<trademarkincircle\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<leftopentriangle\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rightopentriangle\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<emopencircle\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<emopenrectangle\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<leftsinglequotemark\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rightsinglequotemark\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<leftdoublequotemark\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rightdoublequotemark\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<prescription\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<permille\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<minutes\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<seconds\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<latincross\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hexagram\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<filledrectbullet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<filledlefttribullet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<filledrighttribullet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<emfilledcircle\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<emfilledrect\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<enopencircbullet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<enopensquarebullet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<openrectbullet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<opentribulletup\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<opentribulletdown\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<openstar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<enfilledcircbullet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<enfilledsqbullet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<filledtribulletup\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<filledtribulletdown\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<leftpointer\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rightpointer\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<club\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<diamond\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<heart\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<maltesecross\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dagger\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<doubledagger\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<checkmark\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ballotcross\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<musicalsharp\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<musicalflat\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<malesymbol\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<femalesymbol\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<telephone\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<telephonerecorder\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<phonographcopyright\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<caret\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<singlelowquotemark\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<doublelowquotemark\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<cursor\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<leftcaret\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rightcaret\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<downcaret\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<upcaret\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<overbar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<downtack\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<upshoe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<downstile\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<underbar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<jot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<quad\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uptack\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<circle\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<upstile\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<downshoe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<rightshoe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<leftshoe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<lefttack\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<righttack\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_doublelowline\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_aleph\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_bet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_beth\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_gimel\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_gimmel\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_dalet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_daleth\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_he\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_waw\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_zain\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_zayin\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_chet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_het\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_tet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_teth\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_yod\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_finalkaph\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_kaph\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_lamed\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_finalmem\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_mem\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_finalnun\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_nun\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_samech\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_samekh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_ayin\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_finalpe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_pe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_finalzade\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_finalzadi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_zade\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_zadi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_qoph\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_kuf\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_resh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_shin\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_taw\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<hebrew_taf\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hebrew_switch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_kokai\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_khokhai\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_khokhuat\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_khokhwai\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_khokhon\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_khorakhang\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_ngongu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_chochan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_choching\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_chochang\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_soso\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_chochoe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_yoying\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_dochada\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_topatak\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_thothan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_thonangmontho\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_thophuthao\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_nonen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_dodek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_totao\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_thothung\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_thothahan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_thothong\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_nonu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_bobaimai\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_popla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_phophung\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_fofa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_phophan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_fofan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_phosamphao\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_moma\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_yoyak\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_rorua\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_ru\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_loling\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_lu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_wowaen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_sosala\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_sorusi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_sosua\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_hohip\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_lochula\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_oang\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_honokhuk\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_paiyannoi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_saraa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_maihanakat\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_saraaa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_saraam\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_sarai\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_saraii\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_saraue\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_sarauee\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_sarau\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_sarauu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_phinthu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_maihanakat_maitho\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_baht\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_sarae\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_saraae\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_sarao\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_saraaimaimuan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_saraaimaimalai\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_lakkhangyao\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_maiyamok\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_maitaikhu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_maiek\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_maitho\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_maitri\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_maichattawa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_thanthakhat\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_nikhahit\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_leksun\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_leknung\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_leksong\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_leksam\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_leksi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_lekha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_lekhok\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_lekchet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_lekpaet\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Thai_lekkao\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Start\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_End\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Hanja\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Jamo\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Romaja\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Codeinput\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Jeonja\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Banja\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_PreHanja\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_PostHanja\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_SingleCandidate\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_MultipleCandidate\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_PreviousCandidate\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Special\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_switch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Kiyeog\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_SsangKiyeog\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_KiyeogSios\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Nieun\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_NieunJieuj\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_NieunHieuh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Dikeud\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_SsangDikeud\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Rieul\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_RieulKiyeog\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_RieulMieum\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_RieulPieub\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_RieulSios\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_RieulTieut\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_RieulPhieuf\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_RieulHieuh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Mieum\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Pieub\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_SsangPieub\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_PieubSios\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Sios\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_SsangSios\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Ieung\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Jieuj\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_SsangJieuj\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Cieuc\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Khieuq\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Tieut\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Phieuf\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_Hieuh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_A\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_AE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_YA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_YAE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_EO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_E\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_YEO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_YE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_O\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_WA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_WAE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_OE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_YO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_U\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_WEO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_WE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_WI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_YU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_EU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_YI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_I\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Kiyeog\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_SsangKiyeog\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_KiyeogSios\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Nieun\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_NieunJieuj\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_NieunHieuh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Dikeud\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Rieul\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_RieulKiyeog\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_RieulMieum\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_RieulPieub\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_RieulSios\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_RieulTieut\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_RieulPhieuf\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_RieulHieuh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Mieum\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Pieub\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_PieubSios\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Sios\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_SsangSios\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Ieung\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Jieuj\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Cieuc\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Khieuq\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Tieut\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Phieuf\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_Hieuh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_RieulYeorinHieuh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_SunkyeongeumMieum\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_SunkyeongeumPieub\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_PanSios\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_KkogjiDalrinIeung\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_SunkyeongeumPhieuf\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_YeorinHieuh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_AraeA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_AraeAE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_PanSios\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_KkogjiDalrinIeung\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hangul_J_YeorinHieuh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Korean_Won\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_ligature_ew\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_full_stop\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_verjaket\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_separation_mark\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_but\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_hyphen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_yentamna\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_exclam\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_amanak\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_accent\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_shesht\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_question\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_paruyk\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_AYB\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_ayb\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_BEN\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_ben\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_GIM\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_gim\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_DA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_da\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_YECH\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_yech\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_ZA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_za\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_E\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_e\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_AT\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_at\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_TO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_to\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_ZHE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_zhe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_INI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_ini\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_LYUN\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_lyun\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_KHE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_khe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_TSA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_tsa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_KEN\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_ken\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_HO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_ho\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_DZA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_dza\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_GHAT\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_ghat\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_TCHE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_tche\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_MEN\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_men\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_HI\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_hi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_NU\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_nu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_SHA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_sha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_VO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_vo\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_CHA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_cha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_PE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_pe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_JE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_je\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_RA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_ra\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_SE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_se\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_VEV\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_vev\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_TYUN\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_tyun\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_RE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_re\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_TSO\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_tso\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_VYUN\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_vyun\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_PYUR\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_pyur\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_KE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_ke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_O\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_o\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_FE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_fe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Armenian_apostrophe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_an\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_ban\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_gan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_don\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_en\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_vin\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_zen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_tan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_in\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_kan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_las\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_man\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_nar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_on\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_par\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_zhar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_rae\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_san\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_tar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_un\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_phar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_khar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_ghan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_qar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_shin\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_chin\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_can\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_jil\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_cil\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_char\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_xan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_jhan\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_hae\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_he\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_hie\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_we\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_har\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_hoe\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Georgian_fi\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Xabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ibreve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Zstroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Gcaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ocaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Obarred\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<xabovedot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ibreve\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<zstroke\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<gcaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ocaron\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<obarred\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<SCHWA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<schwa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<EZH\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ezh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Lbelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<lbelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Abelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<abelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ahook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ahook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Acircumflexacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<acircumflexacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Acircumflexgrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<acircumflexgrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Acircumflexhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<acircumflexhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Acircumflextilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<acircumflextilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Acircumflexbelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<acircumflexbelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Abreveacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<abreveacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Abrevegrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<abrevegrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Abrevehook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<abrevehook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Abrevetilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<abrevetilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Abrevebelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<abrevebelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ebelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ebelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ehook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ehook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Etilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<etilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ecircumflexacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ecircumflexacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ecircumflexgrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ecircumflexgrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ecircumflexhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ecircumflexhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ecircumflextilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ecircumflextilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ecircumflexbelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ecircumflexbelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ihook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ihook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ibelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ibelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Obelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<obelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ohook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ohook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ocircumflexacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ocircumflexacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ocircumflexgrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ocircumflexgrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ocircumflexhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ocircumflexhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ocircumflextilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ocircumflextilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ocircumflexbelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ocircumflexbelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ohornacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ohornacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ohorngrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ohorngrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ohornhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ohornhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ohorntilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ohorntilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ohornbelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ohornbelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ubelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ubelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Uhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Uhornacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uhornacute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Uhorngrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uhorngrave\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Uhornhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uhornhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Uhorntilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uhorntilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Uhornbelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uhornbelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ybelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ybelowdot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Yhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<yhook\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ytilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ytilde\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ohorn\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ohorn\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Uhorn\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<uhorn\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<EcuSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ColonSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<CruzeiroSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<FFrancSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<LiraSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<MillSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<NairaSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<PesetaSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<RupeeSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<WonSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<NewSheqelSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<DongSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<EuroSign\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<zerosuperior\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<foursuperior\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<fivesuperior\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<sixsuperior\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<sevensuperior\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<eightsuperior\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ninesuperior\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<zerosubscript\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<onesubscript\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<twosubscript\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<threesubscript\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<foursubscript\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<fivesubscript\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<sixsubscript\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<sevensubscript\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<eightsubscript\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ninesubscript\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<partdifferential\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<emptyset\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<elementof\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<notelementof\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<containsas\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<squareroot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<cuberoot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<fourthroot\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<dintegral\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<tintegral\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<because\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<approxeq\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<notapproxeq\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<notidentical\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<stricteq\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dot_1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dot_2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dot_3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dot_4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dot_5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dot_6\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dot_7\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dot_8\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dot_9\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dot_10\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_blank\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_13\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_23\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_123\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_14\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_24\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_124\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_34\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_134\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_234\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1234\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_15\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_25\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_125\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_35\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_135\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_235\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1235\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_45\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_145\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_245\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1245\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_345\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1345\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2345\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12345\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_6\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_16\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_26\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_126\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_36\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_136\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_236\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1236\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_46\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_146\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_246\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1246\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_346\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1346\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2346\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12346\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_56\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_156\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_256\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1256\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_356\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1356\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2356\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12356\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_456\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1456\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2456\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12456\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_3456\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_13456\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_23456\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_123456\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_7\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_17\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_27\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_127\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_37\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_137\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_237\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1237\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_47\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_147\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_247\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1247\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_347\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1347\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2347\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12347\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_57\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_157\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_257\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1257\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_357\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1357\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2357\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12357\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_457\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1457\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2457\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12457\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_3457\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_13457\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_23457\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_123457\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_67\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_167\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_267\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1267\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_367\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1367\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2367\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12367\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_467\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1467\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2467\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12467\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_3467\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_13467\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_23467\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_123467\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_3567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_13567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_23567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_123567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_4567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_14567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_24567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_124567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_34567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_134567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_234567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1234567\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_8\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_18\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_28\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_128\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_38\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_138\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_238\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1238\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_48\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_148\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_248\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1248\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_348\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1348\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2348\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12348\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_58\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_158\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_258\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1258\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_358\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1358\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2358\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12358\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_458\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1458\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2458\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12458\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_3458\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_13458\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_23458\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_123458\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_68\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_168\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_268\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1268\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_368\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1368\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2368\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12368\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_468\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1468\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2468\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12468\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_3468\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_13468\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_23468\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_123468\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_3568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_13568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_23568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_123568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_4568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_14568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_24568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_124568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_34568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_134568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_234568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1234568\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_78\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_178\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_278\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1278\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_378\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1378\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2378\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12378\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_478\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1478\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2478\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12478\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_3478\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_13478\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_23478\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_123478\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_3578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_13578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_23578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_123578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_4578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_14578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_24578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_124578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_34578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_134578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_234578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1234578\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_3678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_13678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_23678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_123678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_4678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_14678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_24678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_124678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_34678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_134678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_234678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1234678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_5678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_15678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_25678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_125678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_35678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_135678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_235678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1235678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_45678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_145678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_245678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1245678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_345678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_1345678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_2345678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<braille_dots_12345678\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ng\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_h2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_a\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_aa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ae\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_aee\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_i\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ii\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_u\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_uu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ri\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_rii\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_lu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_luu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_e\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ee\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ai\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_o\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_oo\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_au\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ka\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_kha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ga\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_gha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ng2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_nga\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ca\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_cha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ja\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_jha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_nya\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_jnya\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_nja\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_tta\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ttha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_dda\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ddha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_nna\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ndda\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_tha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_thha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_dha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_dhha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_na\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ndha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_pa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_pha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ba\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_bha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ma\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_mba\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ya\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ra\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_la\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_va\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_sha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ssha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_sa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ha\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_lla\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_fa\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_al\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_aa2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ae2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_aee2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_i2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ii2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_u2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_uu2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ru2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_e2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ee2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ai2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_o2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_oo2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_au2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_lu2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_ruu2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_luu2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sinh_kunddaliya\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ModeLock\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<MonBrightnessUp\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<MonBrightnessDown\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KbdLightOnOff\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KbdBrightnessUp\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<KbdBrightnessDown\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Standby\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioLowerVolume\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioMute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioRaiseVolume\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioPlay\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioStop\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioPrev\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioNext\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<HomePage\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Mail\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Start\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Search\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioRecord\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Calculator\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Memo\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ToDoList\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Calendar\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<PowerDown\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ContrastAdjust\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<RockerUp\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<RockerDown\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<RockerEnter\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Back\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Forward\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Stop\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Refresh\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<PowerOff\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<WakeUp\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Eject\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ScreenSaver\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<WWW\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Sleep\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Favorites\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioPause\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioMedia\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<MyComputer\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<VendorHome\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<LightBulb\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Shop\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<History\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<OpenURL\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AddFavorite\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<HotLinks\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<BrightnessAdjust\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Finance\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Community\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioRewind\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<BackForward\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Launch0\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Launch1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Launch2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Launch3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Launch4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Launch5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Launch6\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Launch7\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Launch8\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Launch9\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<LaunchA\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<LaunchB\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<LaunchC\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<LaunchD\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<LaunchE\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<LaunchF\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ApplicationLeft\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ApplicationRight\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Book\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<CD\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<WindowClear\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Close\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Copy\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Cut\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Display\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<DOS\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Documents\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Excel\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Explorer\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Game\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Go\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<iTouch\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<LogOff\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Market\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Meeting\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<MenuKB\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<MenuPB\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<MySites\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<New\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<News\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<OfficeHome\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Open\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Option\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Paste\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Phone\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Reply\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Reload\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<RotateWindows\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<RotationPB\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<RotationKB\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Save\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ScrollUp\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ScrollDown\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ScrollClick\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Send\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Spell\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<SplitScreen\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Support\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<TaskPane\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Terminal\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Tools\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Travel\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<UserPB\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<User1KB\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<User2KB\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Video\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<WheelButton\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Word\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Xfer\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ZoomIn\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ZoomOut\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Away\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Messenger\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<WebCam\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<MailForward\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Pictures\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Music\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Battery\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Bluetooth\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<WLAN\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<UWB\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioForward\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioRepeat\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioRandomPlay\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Subtitle\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioCycleTrack\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<CycleAngle\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<FrameBack\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<FrameForward\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Time\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<SelectButton\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<View\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<TopMenu\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Red\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Green\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Yellow\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Blue\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Suspend\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Hibernate\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<TouchpadToggle\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<TouchpadOn\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<TouchpadOff\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<AudioMicMute\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Switch_VT_1\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Switch_VT_2\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Switch_VT_3\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Switch_VT_4\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Switch_VT_5\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Switch_VT_6\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Switch_VT_7\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Switch_VT_8\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Switch_VT_9\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Switch_VT_10\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Switch_VT_11\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Switch_VT_12\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Ungrab\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<ClearGrab\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Next_VMode\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<Prev_VMode\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<LogWindowTree\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
syn match vkmGdkKeyname "\<LogGrabInfo\>" nextgroup=vkmRowNumber skipwhite contains=vkmNumber
" }}}


let b:current_syntax = "vkm"

hi link vkmTodo         Todo
hi link vkmKeyword      Keyword
hi link vkmComment      Comment
hi link vkmCbmKey       Type
hi link vkmCtrlKey      Type
hi link vkmShiftKey     Type
hi link vkmRowNumber    Number
hi link vkmColumnNumber Number
hi link vkmShiftFlag    Number
hi link vkmGdkKeyname   Special
