/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.store;

import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.L;
import android.databinding.tool.util.ParserHelper;
import android.databinding.tool.util.XmlEditor;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LayoutFileParser {
    private static final String XPATH_VARIABLE_DEFINITIONS = "/layout/data/variable";
    private static final String XPATH_BINDING_ELEMENTS = "/layout/*[name() != 'data' and name() != 'merge'] | /layout/merge/* | //*[include/.. or @*[starts-with(., '@{') and substring(., string-length(.)) = '}']]";
    private static final String XPATH_EXPRESSION_ELEMENTS = "//*[@*[starts-with(., '@{') and substring(., string-length(.)) = '}']]";
    private static final String XPATH_ID_ELEMENTS = "//*[@*[local-name()='id']]";
    private static final String XPATH_IMPORT_DEFINITIONS = "/layout/data/import";
    private static final String XPATH_MERGE_ELEMENT = "/layout/merge";
    private static final String XPATH_BINDING_LAYOUT = "/layout";
    private static final String XPATH_BINDING_CLASS = "/layout/data/@class";
    final String LAYOUT_PREFIX = "@layout/";

    public ResourceBundle.LayoutFileBundle parseXml(File xml, String pkg) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        NamedNodeMap attributes;
        String xmlNoExtension = ParserHelper.INSTANCE$.stripExtension(xml.getName());
        String newTag = xml.getParentFile().getName() + '/' + xmlNoExtension;
        File original = this.stripFileAndGetOriginal(xml, newTag);
        if (original == null) {
            L.d("assuming the file is the original for %s", xml.getAbsoluteFile());
            original = xml;
        }
        L.d("parsing file %s", xml.getAbsolutePath());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(original);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        if (!this.isBindingLayout(doc, xPath)) {
            return null;
        }
        List<Node> variableNodes = this.getVariableNodes(doc, xPath);
        List<Node> imports = this.getImportNodes(doc, xPath);
        ResourceBundle.LayoutFileBundle bundle = new ResourceBundle.LayoutFileBundle(xmlNoExtension, xml.getParentFile().getName(), pkg, this.isMerge(doc, xPath));
        L.d("number of variable nodes %d", variableNodes.size());
        for (Node item : variableNodes) {
            L.d("reading variable node %s", item);
            attributes = item.getAttributes();
            String variableName = attributes.getNamedItem("name").getNodeValue();
            String variableType = attributes.getNamedItem("type").getNodeValue();
            L.d("name: %s, type:%s", variableName, variableType);
            bundle.addVariable(variableName, variableType);
        }
        L.d("import node count %d", imports.size());
        for (Node item : imports) {
            String alias;
            attributes = item.getAttributes();
            String type = attributes.getNamedItem("type").getNodeValue();
            Node aliasNode = attributes.getNamedItem("alias");
            if (aliasNode == null) {
                String[] split = StringUtils.split(type, '.');
                alias = split[split.length - 1];
            } else {
                alias = aliasNode.getNodeValue();
            }
            bundle.addImport(alias, type);
        }
        Node layoutParent = this.getLayoutParent(doc, xPath);
        List<Node> bindingNodes = this.getBindingNodes(doc, xPath);
        HashMap<Node, String> nodeTagMap = new HashMap<Node, String>();
        L.d("number of binding nodes %d", bindingNodes.size());
        int tagNumber = 0;
        for (Node parent : bindingNodes) {
            String tag;
            NamedNodeMap attributes2 = parent.getAttributes();
            String nodeName = parent.getNodeName();
            String viewName = null;
            String includedLayoutName = null;
            Node id = attributes2.getNamedItem("android:id");
            if ("include".equals(nodeName)) {
                String layoutName;
                Node includedLayout = attributes2.getNamedItem("layout");
                Preconditions.checkNotNull(includedLayout, "must include a layout");
                String includeValue = includedLayout.getNodeValue();
                Preconditions.checkArgument(includeValue.startsWith("@layout/"));
                includedLayoutName = layoutName = includeValue.substring("@layout/".length());
                tag = (String)nodeTagMap.get(parent.getParentNode());
            } else {
                viewName = this.getViewName(parent);
                tag = layoutParent == parent.getParentNode() ? newTag + "_" + tagNumber : "binding_" + tagNumber;
                ++tagNumber;
            }
            Node originalTag = attributes2.getNamedItem("android:tag");
            ResourceBundle.BindingTargetBundle bindingTargetBundle = bundle.createBindingTarget(id == null ? null : id.getNodeValue(), viewName, true, tag, originalTag == null ? null : originalTag.getNodeValue());
            nodeTagMap.put(parent, tag);
            bindingTargetBundle.setIncludedLayout(includedLayoutName);
            int attrCount = attributes2.getLength();
            for (int i = 0; i < attrCount; ++i) {
                Node attr = attributes2.item(i);
                String value = attr.getNodeValue();
                if (value.charAt(0) != '@' || value.charAt(1) != '{' || value.charAt(value.length() - 1) != '}') continue;
                String strippedValue = value.substring(2, value.length() - 1);
                bindingTargetBundle.addBinding(attr.getNodeName(), strippedValue);
            }
        }
        List<Node> idNodes = this.getNakedIds(doc, xPath);
        for (Node node : idNodes) {
            if (bindingNodes.contains(node) || "include".equals(node.getNodeName())) continue;
            Node id = node.getAttributes().getNamedItem("android:id");
            String className = this.getViewName(node);
            bundle.createBindingTarget(id.getNodeValue(), className, true, null, null);
        }
        bundle.setBindingClass(this.getBindingClass(doc, xPath, original));
        return bundle;
    }

    private boolean isBindingLayout(Document doc, XPath xPath) throws XPathExpressionException {
        return !this.get(doc, xPath, XPATH_BINDING_LAYOUT).isEmpty();
    }

    private boolean hasBindingExpression(Document doc, XPath xPath) throws XPathExpressionException {
        return !this.get(doc, xPath, XPATH_EXPRESSION_ELEMENTS).isEmpty();
    }

    private Node getLayoutParent(Document doc, XPath xPath) throws XPathExpressionException {
        if (this.isMerge(doc, xPath)) {
            return this.get(doc, xPath, XPATH_MERGE_ELEMENT).get(0);
        }
        return this.get(doc, xPath, XPATH_BINDING_LAYOUT).get(0);
    }

    private String getBindingClass(Document doc, XPath xPath, File file) throws XPathExpressionException {
        List<Node> nodes = this.get(doc, xPath, XPATH_BINDING_CLASS);
        if (nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() > 1) {
            L.e("More than one binding class declared in %s", file.getAbsolutePath());
        }
        return nodes.get(0).getNodeValue();
    }

    private List<Node> getBindingNodes(Document doc, XPath xPath) throws XPathExpressionException {
        return this.get(doc, xPath, XPATH_BINDING_ELEMENTS);
    }

    private List<Node> getVariableNodes(Document doc, XPath xPath) throws XPathExpressionException {
        return this.get(doc, xPath, XPATH_VARIABLE_DEFINITIONS);
    }

    private List<Node> getImportNodes(Document doc, XPath xPath) throws XPathExpressionException {
        return this.get(doc, xPath, XPATH_IMPORT_DEFINITIONS);
    }

    private List<Node> getNakedIds(Document doc, XPath xPath) throws XPathExpressionException {
        return this.get(doc, xPath, XPATH_ID_ELEMENTS);
    }

    private boolean isMerge(Document doc, XPath xPath) throws XPathExpressionException {
        return !this.get(doc, xPath, XPATH_MERGE_ELEMENT).isEmpty();
    }

    private List<Node> get(Document doc, XPath xPath, String pattern) throws XPathExpressionException {
        XPathExpression expr = xPath.compile(pattern);
        return this.toList((NodeList)expr.evaluate(doc, XPathConstants.NODESET));
    }

    private List<Node> toList(NodeList nodeList) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            result.add(nodeList.item(i));
        }
        return result;
    }

    private String getViewName(Node viewNode) {
        String viewName = viewNode.getNodeName();
        if ("view".equals(viewName)) {
            Node classNode = viewNode.getAttributes().getNamedItem("class");
            if (classNode == null) {
                L.e("No class attribute for 'view' node", new Object[0]);
            } else {
                viewName = classNode.getNodeValue();
            }
        }
        return viewName;
    }

    private void stripBindingTags(File xml, String newTag) throws IOException {
        String res = XmlEditor.INSTANCE$.strip(xml, newTag);
        if (res != null) {
            L.d("file %s has changed, overwriting %s", xml.getName(), xml.getAbsolutePath());
            FileUtils.writeStringToFile(xml, res);
        }
    }

    private File stripFileAndGetOriginal(File xml, String binderId) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        L.d("parsing resource file %s", xml.getAbsolutePath());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(xml);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression commentElementExpr = xPath.compile("//comment()[starts-with(., \" From: file:\")][last()]");
        NodeList commentElementNodes = (NodeList)commentElementExpr.evaluate(doc, XPathConstants.NODESET);
        L.d("comment element nodes count %s", commentElementNodes.getLength());
        if (commentElementNodes.getLength() == 0) {
            L.d("cannot find comment element to find the actual file", new Object[0]);
            return null;
        }
        Node first = commentElementNodes.item(0);
        String actualFilePath = first.getNodeValue().substring(" From:".length()).trim();
        L.d("actual file to parse: %s", actualFilePath);
        File actualFile = LayoutFileParser.urlToFile(new URL(actualFilePath));
        if (!actualFile.canRead()) {
            L.d("cannot find original, skipping. %s", actualFile.getAbsolutePath());
            return null;
        }
        boolean changed = this.isBindingLayout(doc, xPath);
        if (changed) {
            this.stripBindingTags(xml, binderId);
        }
        return actualFile;
    }

    public static File urlToFile(String url) throws MalformedURLException {
        return LayoutFileParser.urlToFile(new URL(url));
    }

    public static File urlToFile(URL url) throws MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException e) {
            MalformedURLException ex = new MalformedURLException(e.getLocalizedMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }
}

