------------------------------------------------------------------------------
--                                                                          --
--                            GNAT2XML COMPONENTS                           --
--                                                                          --
--                    G N A T 2 X M L . A D A _ T R E E S                   --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2012-2017, AdaCore                     --
--                                                                          --
-- Gnat2xml is free software; you can redistribute it and/or modify it      --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Gnat2xml is distributed  in the hope  that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MER-      --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
-- The gnat2xml tool was derived from the Avatox sources.                   --
------------------------------------------------------------------------------

pragma Ada_2012;

--  This package provides a conversion routine for converting an Ada_Tree to
--  textual Ada code.

with Pp.Buffers; use Pp.Buffers;
with Pp.Formatting; use Pp.Formatting;

package Ada_Trees.Formatting is

   procedure Tree_To_Ada
     (Root      : Ada_Tree;
      Src_Buf   : in out Buffer;
      Write_BOM : Boolean;
      Source_Name : String;
      Options   : Formatting_Options;
      Output_Name : String;
      Form_String : String;
      Do_Diff : Boolean;
      Output_Written : out Boolean);
   --  Convert Tree to Ada source text. Src_Buf is the contents of the original
   --  Ada source file. It needs to be 'in out' because we call things like
   --  Move_Forward and Mark, but we don't modify the actual text.  Write_BOM
   --  indicates that a BOM should be written to the output.  Output goes to
   --  the file named Output_Name; "" means current output. Form_String is the
   --  Form string to pass to Create. If Do_Diff is True, and the output is
   --  identical to the input, nothing is written.  Output_Written indicates
   --  whether the output was written.

   procedure Tree_To_Ada
     (Root        : Ada_Tree;
      Source_Name : String;
      Options     : Formatting_Options;
      Output_Name : String);
   --  Same as above, but reads the source from the named file. This one is
   --  called from code generated by Ada_Trees.Self_Rep.

   --  For debugging:

   procedure Put_Ada_Templates;
   procedure Format_Debug_Output (Message : String);

end Ada_Trees.Formatting;
