//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_44.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot44(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[44] = {1.394026269787452e-02,1.254887261859858e-01,3.487264533764085e-01,6.839360245419450e-01,1.131543776215137e+00,
    1.692122807282550e+00,2.366397066581720e+00,3.155246593321557e+00,4.059714003670170e+00,5.081012341982421e+00,6.220534444334326e+00,7.479863996481541e+00,
    8.860788509558922e+00,1.036531448669457e+01,1.199568511468593e+01,1.375440089019443e+01,1.564424368379558e+01,1.766830486333247e+01,1.983001824797306e+01,
    2.213319885653819e+01,2.458208866231789e+01,2.718141089162620e+01,2.993643483281341e+01,3.285305369651100e+01,3.593787884478832e+01,3.919835477256694e+01,
    4.264290070800244e+01,4.628108679673196e+01,5.012385585568197e+01,5.418380611726070e+01,5.847555704006093e+01,6.301623049665658e+01,6.782609582919292e+01,
    7.292945366353734e+01,7.835587804220772e+01,8.414201528655593e+01,9.033428432237336e+01,9.699311155158021e+01,1.041999450430757e+02,1.120697167875161e+02,
    1.207751650537911e+02,1.306010653811563e+02,1.420929648799869e+02,1.566571642945627e+02};
  constexpr double aw[44] = {2.328749081845471e-01,2.083601726149635e-01,1.667777136192186e-01,1.193907729932987e-01,7.640628999619845e-02,
    4.368838005728940e-02,2.230329851479710e-02,1.015685234209423e-02,4.121796569996600e-03,1.488772654095434e-03,4.779519114281924e-04,1.361668444358730e-04,
    3.436524690691869e-05,7.667676245247865e-06,1.509168244222782e-06,2.613748469736829e-07,3.972315688450674e-08,5.281362971560191e-09,6.121978354544024e-10,
    6.163656612278241e-11,5.367349226807181e-12,4.023678119642042e-13,2.583219433937558e-14,1.412014041414147e-15,6.528497854709731e-17,2.534449921267411e-18,
    8.192799213995431e-20,2.184480007299850e-21,4.752613298191917e-23,8.332569096197455e-25,1.160424567801345e-26,1.262139334351897e-28,1.050916165015424e-30,
    6.540321701258348e-33,2.954986811717080e-35,9.349454598812688e-38,1.979215172273072e-40,2.642073629482833e-43,2.053664611058321e-46,8.308654338799789e-50,
    1.479045824609391e-53,8.793797991037640e-58,1.034074040165401e-62,6.355988880481435e-69};
  constexpr double x[16896] = {  6.229487728614898e-04, -3.498634945843954e-06,  1.473226145302269e-08, -5.512027284548852e-11,  1.932406067322336e-13,
 -6.499625585018529e-16,  2.123864388505481e-18, -6.792805644160976e-21,  2.136591621013155e-23, -6.630429056033160e-26,  2.034643087723155e-28, -6.183981967256100e-31,
  5.601985660252470e-03, -3.138466509032447e-05,  1.315041061598687e-07, -4.879601354412900e-10,  1.689436019632894e-12, -5.582896107063550e-15,  1.781287762069302e-17,
 -5.521959171014193e-20,  1.668817541037179e-22, -4.924472161065707e-25,  1.419119451089988e-27, -3.989415184240533e-30,  1.553579737291826e-02, -8.660931314682977e-05,
  3.593076137411343e-07, -1.311057336298960e-09,  4.424014988127996e-12, -1.408641885839687e-14,  4.267087921733412e-17, -1.231707768548458e-19,  3.375165732560478e-22,
 -8.688762738805674e-25,  2.054324020225134e-27, -4.229825488460118e-30,  3.037596619871953e-02, -1.680882003401846e-04,  6.869151051697832e-07, -2.442722299576742e-09,
  7.915964340914693e-12, -2.371413513325514e-14,  6.557525136228586e-17, -1.645792235031268e-19,  3.578428226947862e-22, -5.804437034015372e-25,  1.375496642756597e-28,
  4.305089150509848e-30,  5.005013134949012e-02, -2.742206868154232e-04,  1.098106065732996e-06, -3.768840532518052e-09,  1.152599236999479e-11, -3.144086814172982e-14,
  7.413822150137263e-17, -1.355715835765421e-19,  9.808093317034227e-23,  6.520742391550060e-25, -4.431417203907912e-27,  1.837255717324098e-29,  7.446230719340893e-02,
 -4.029204677872039e-04,  1.572382797603240e-06, -5.152243870356781e-09,  1.454368097457689e-11, -3.430129490825055e-14,  5.859101874323418e-17, -1.455800782039231e-20,
 -4.373099662287289e-22,  2.448150611241317e-24, -9.006365864603893e-27,  2.510997079501667e-29,  1.034933063826366e-01, -5.516555135937452e-04,  2.085876643582993e-06,
 -6.444043249107418e-09,  1.628596776048077e-11, -3.004253813661705e-14,  1.518004438345330e-17,  1.843430361702381e-19, -1.077580816625339e-21,  3.819112256227530e-24,
 -9.401062156050478e-27,  1.111663011538979e-29,  1.370012668442917e-01, -7.174966373449790e-04,  2.612406155710159e-06, -7.496039971963641e-09,  1.619455206622971e-11,
 -1.766667681624631e-14, -5.186450436501991e-17,  4.099710875173470e-19, -1.532037776541157e-21,  3.623672630415017e-24, -2.699861271905591e-27, -2.445227283765744e-29,
  1.748222813219684e-01, -8.971738151284569e-04,  3.124641942594550e-06, -8.173243509864671e-09,  1.391981144516321e-11,  2.243297897009205e-15, -1.303944627563223e-16,
  5.864400928676872e-19, -1.503177743508044e-21,  1.227894662226872e-24,  1.002794250061821e-26, -6.334516624395824e-29,  2.167711278594591e-01, -1.087139238368582e-03,
  3.595328137441308e-06, -8.365508613371579e-09,  9.380320299994966e-12,  2.748360504349263e-14, -2.025571249528298e-16,  6.360973567522529e-19, -8.242385501275345e-22,
 -2.971507824267162e-24,  2.304979149682237e-26, -7.572592953740736e-29,  2.626420993058159e-01, -1.283635948376365e-03,  3.998507697115877e-06, -7.997364669487581e-09,
  2.789914532697226e-12,  5.449527333760955e-14, -2.487310658965856e-16,  5.063068779285629e-19,  4.362659091232382e-22, -7.475377923833965e-24,  2.825924321026739e-26,
 -3.960444134778868e-29,  3.122099295893713e-01, -1.482770791696218e-03,  4.310698205700009e-06, -7.035241999953258e-09, -5.351882088109256e-12,  7.889990722398010e-14,
 -2.523059348917018e-16,  1.914457245512162e-19,  1.952571362072242e-21, -1.018155376978511e-23,  1.960500175425389e-26,  3.974746478965932e-29,  3.652308141562545e-01,
 -1.680590343705839e-03,  4.511966563436197e-06, -5.491493977468651e-09, -1.430581543156157e-11,  9.622054414021679e-14, -2.041721494199918e-16, -2.576060893834403e-19,
  3.222686290915291e-21, -9.295754633598716e-24, -2.668959849898023e-27,  1.249472892066139e-28,  4.214435215951640e-01, -1.873158379006090e-03,  4.586854854762103e-06,
 -3.424856450346765e-09, -2.317050929297979e-11,  1.026665520565692e-13, -1.057964847578305e-16, -7.407789953996710e-19,  3.732879286750846e-21, -4.263577115662846e-24,
 -3.058677988821623e-26,  1.631638151482461e-28,  4.805705930740963e-01, -2.056633422160134e-03,  4.525115678763920e-06, -9.372591771166564e-10, -3.098301276841114e-11,
  9.584595239148477e-14,  2.995805847027130e-17, -1.132229144717773e-18,  3.150574042164528e-21,  3.728872846413512e-24, -5.117302590046400e-26,  1.173200126511051e-28,
  5.423196257963976e-01, -2.227344892732103e-03,  4.322223076123815e-06,  1.832812669584639e-09, -3.683058588813061e-11,  7.527661160712726e-14,  1.806131370911210e-16,
 -1.314069298770232e-18,  1.473958789232787e-21,  1.198576412654690e-23, -5.249535159630035e-26, -6.451923105535950e-30,  6.063846362435448e-01, -2.381866365434475e-03,
  3.979634601360848e-06,  4.719936963368221e-09, -3.996040258270881e-11,  4.259859350705544e-14,  3.182018072103761e-16, -1.211037162065502e-18, -9.232860000648519e-22,
  1.725138529835500e-23, -3.014875827425244e-26, -1.539206647318870e-28,  6.724474985118818e-01, -2.517084500245978e-03,  3.504790698406347e-06,  7.543643777522265e-09,
 -3.987382096958449e-11,  1.438779764060732e-15,  4.149218881423981e-16, -8.158093240975406e-19, -3.379062127315344e-21,  1.703000437863648e-23,  9.304426814790866e-27,
 -2.472237676860071e-28,  7.401794525722600e-01, -2.630262258915000e-03,  2.910848911931604e-06,  1.012167835389636e-08, -3.639346707756433e-11, -4.306242632193535e-14,
  4.491028244176477e-16, -1.968432273946984e-19, -5.141220553163394e-21,  1.072289507972944e-23,  5.015980925856758e-26, -2.274401790548741e-28,  8.092426767881341e-01,
 -2.719095113161407e-03,  2.216162132489285e-06,  1.228362063203068e-08, -2.969443728697677e-11, -8.499390011129226e-14,  4.101483027766401e-16,  5.146302807547928e-19,
 -5.613915198456396e-21,  6.404604109348390e-26,  7.426989842404511e-26, -9.116957603571920e-29,  8.792919185229616e-01, -2.781759065474354e-03,  1.443521530172855e-06,
  1.388380160780319e-08, -2.029510314140846e-11, -1.185694317517476e-13,  3.012997674718124e-16,  1.155863846590981e-18, -4.566986896007889e-21, -1.139085992799400e-23,
  6.959698778197552e-26,  1.017640932438581e-28,  9.499761761563995e-01, -2.816949444481321e-03,  6.191955726716917e-07,  1.481249706585402e-08, -9.007811508532822e-12,
 -1.390302950511086e-13,  1.395231353598705e-16,  1.574042702448652e-18, -2.232154919222936e-21, -1.956623066907951e-23,  3.639244173643283e-26,  2.566416974548755e-28,
  1.020940425316342e+00, -2.823909601679807e-03, -2.281939417505574e-07,  1.500450072549441e-08,  3.145363506065876e-12, -1.434041911099681e-13, -4.754653015790110e-17,
  1.666594427372758e-18,  7.529713055912418e-22, -2.144908468399800e-23, -1.226511824174337e-26,  2.940062264319225e-28,  1.091827381626652e+00, -2.802448822548519e-03,
 -1.068910031137147e-06,  1.444437357017212e-08,  1.504233984174270e-11, -1.309913118262828e-13, -2.270030278372571e-16,  1.408992609306231e-18,  3.539052409045357e-21,
 -1.629789025206088e-23, -5.610751672543524e-26,  1.935077093699922e-28,  1.162279291775713e+00, -2.752948969785056e-03, -1.873398230612923e-06,  1.316792008397084e-08,
  2.558350677118318e-11, -1.034923706502871e-13, -3.672681966755243e-16,  8.619977727245224e-19,  5.333731268842870e-21, -5.961941575126821e-24, -7.689660373069377e-26,
  5.855298892485859e-30,  1.231939744236503e+00, -2.676359596187296e-03, -2.613585768367278e-06,  1.125973618352703e-08,  3.381252692404322e-11, -6.475309299348730e-14,
 -4.444605728597790e-16,  1.560299540350473e-19,  5.653521517151404e-21,  5.835769739210282e-24, -6.675252946217231e-26, -1.745684716963120e-28,  1.300455490523396e+00,
 -2.574181495513836e-03, -3.264123269711277e-06,  8.846984973740430e-09,  3.902104910994696e-11, -2.016467561846367e-14, -4.471365569857646e-16, -5.431071703744338e-19,
  4.472352899514328e-21,  1.495930939069571e-23, -3.151328381591112e-26, -2.608841430711747e-28,  1.367478267463201e+00, -2.448438897057812e-03, -3.803511861882969e-06,
  6.089860243132544e-09,  4.082472641147707e-11,  2.418123145658989e-14, -3.783642045519429e-16, -1.077567334568078e-18,  2.216469302864760e-21,  1.845491491185441e-23,
  1.245273152062559e-26, -2.192908293866640e-28,  1.432666610597593e+00, -2.301640748777617e-03, -4.215063042207334e-06,  3.169468998646548e-09,  3.920132784111592e-11,
  6.244191036241248e-14, -2.546900287854786e-16, -1.337701839015136e-18, -3.900971611598463e-22,  1.562010684982760e-23,  4.625664988117084e-26, -8.344244126078824e-29,
  1.495687648530449e+00, -2.136731769466167e-03, -4.487645687549011e-06,  2.740804949971085e-10,  3.448631463756594e-11,  8.991792209941906e-14, -1.022642438662699e-16,
 -1.288026388476987e-18, -2.572490929725850e-21,  8.123433148258723e-24,  5.722781056203394e-26,  6.899404360291023e-29,  1.556218867796298e+00, -1.957034177226911e-03,
 -4.616183853968481e-06, -2.415168696935857e-09,  2.732646612663982e-11,  1.037425371079353e-13,  4.896581586543898e-17, -9.720262560773765e-19, -3.755995098352281e-21,
 -8.312167724078264e-25,  4.408306269984388e-26,  1.619147889192370e-28,  1.613949837664355e+00, -1.766181214008877e-03, -4.601880155266477e-06, -4.737969161919477e-09,
  1.859733506627981e-11,  1.032523385541569e-13,  1.716537700334627e-16, -4.951913306528213e-19, -3.733915598414120e-21, -7.893371714470548e-24,  1.624617801921355e-26,
  1.608878639433822e-28,  1.668583884215406e+00, -1.568043778757606e-03, -4.452152028138057e-06, -6.566826742460113e-09,  9.294828038030236e-12,  8.998130254822846e-14,
  2.465896160065153e-16,  7.963810202779982e-21, -2.698534133460957e-21, -1.088881217933724e-23, -1.186205707356952e-26,  8.549848472705102e-29,  1.719839703044695e+00,
 -1.366651649713363e-03, -4.180281518185846e-06, -7.816368727722211e-09,  4.144570038544906e-13,  6.728716941003386e-14,  2.661485886501637e-16,  4.126307912669591e-19,
 -1.133265539804459e-21, -9.524338572827671e-24, -2.824834710994373e-26, -1.002593537706705e-29,  1.767452900061449e+00, -1.166110914767065e-03, -3.804792726886113e-06,
 -8.449205479836069e-09, -7.166639309892476e-12,  3.968376364323847e-14,  2.349476050398892e-16,  6.366283770910692e-19,  3.851899658385631e-22, -5.231633858915874e-24,
 -2.858376989513476e-26, -7.266406634927704e-29,  1.811177450084660e+00, -9.705193333385527e-04, -3.348584090246755e-06, -8.477863730940933e-09, -1.279017103230486e-11,
  1.200430362427851e-14,  1.676825798527871e-16,  6.582144209505289e-19,  1.395822923242735e-21, -3.069123199478034e-25, -1.687163676537095e-26, -7.961399308546098e-29,
  1.850787063290869e+00, -7.838814204070732e-04, -2.837854567294905e-06, -7.962630145780678e-09, -1.608719375998309e-11, -1.145077146342194e-14,  8.479352349493540e-17,
  5.145365194591831e-19,  1.695861210029242e-21,  3.196112758544755e-24, -1.825253527467468e-27, -4.434867824652218e-29,  1.886076450088893e+00, -6.100250702590218e-04,
 -2.300872992751110e-06, -7.005482909894733e-09, -1.701002469961770e-11, -2.762762653689289e-14,  7.107183903926045e-18,  2.826544772981217e-19,  1.370327353223780e-21,
  4.294996218338440e-24,  8.511808563947630e-27, -1.570066083223580e-32,  1.916862475787142e+00, -4.525215219302957e-04, -1.766647757381498e-06, -5.740616460829359e-09,
 -1.582197828878799e-11, -3.516864664929845e-14, -4.918354297797320e-17,  5.040445212450426e-20,  7.093254057006380e-22,  3.287675329761941e-24,  1.074339145301368e-26,
  2.537008281181823e-29,  1.942985197875822e+00, -3.146104073460267e-04, -1.263559182874850e-06, -4.322351930173005e-09, -1.304680410243266e-11, -3.452304036711745e-14,
 -7.597704692757334e-17, -1.128225072126148e-19,  5.784695957847196e-23,  1.330885331975151e-24,  6.748837689896409e-27,  2.461525079449816e-29,  1.964308782602524e+00,
 -1.991315074405872e-04, -8.180191142757259e-07, -2.911448208741888e-09, -9.384957171146631e-12, -2.770822444676725e-14, -7.436862628947188e-17, -1.758835761673944e-19,
 -3.338293554751143e-22, -3.165849663539487e-25,  1.201158437666367e-27,  9.589070504992903e-30,  1.980722313546003e+00, -1.084646171735326e-04, -4.532209746592879e-07,
 -1.660965141935248e-09, -5.608146727734446e-12, -1.777777295849919e-14, -5.324378077508038e-17, -1.504277392838677e-19, -3.971113766938536e-22, -9.574567298079081e-25,
 -1.994512461040926e-27, -2.980479485764952e-30,  1.992140613495498e+00, -4.447813304081800e-05, -1.880368740158379e-07, -7.028611992643813e-10, -2.446391880368480e-12,
 -8.106553731391560e-15, -2.585444488875468e-17, -7.980216711053287e-20, -2.389493275710923e-22, -6.941680383387070e-25, -1.952756949452152e-27, -5.295793560091279e-30,
  1.998506732528599e+00, -8.478068698965330e-06, -3.607426594945276e-08, -1.363065198525848e-10, -4.822470526476548e-13, -1.635484133624812e-15, -5.383054263053990e-18,
 -1.732129954542453e-20, -5.473889917630398e-23, -1.704090484917859e-25, -5.236786475506711e-28, -1.590827784781825e-30,  6.091858330447751e-04, -3.383371036136541e-06,
  1.408894909962875e-08, -5.212971093320369e-11,  1.807360670595904e-13, -6.011970873986134e-16,  1.942889820095122e-18, -6.145768539762547e-21,  1.911913087458875e-23,
 -5.868458020692420e-26,  1.781245806125885e-28, -5.355216590141131e-31,  5.478514618361713e-03, -3.035560313860727e-05,  1.258071595119351e-07, -4.617997095517335e-10,
  1.581931000660529e-12, -5.173353379968853e-15,  1.633890311843496e-17, -5.015240390720581e-20,  1.501344816029941e-22, -4.390441795761435e-25,  1.254595613655178e-27,
 -3.500031028211142e-30,  1.519501107283421e-02, -8.379660071254887e-05,  3.439905111978972e-07, -1.242472431672719e-09,  4.152254457549191e-12, -1.310251102247986e-14,
  3.936871351986940e-17, -1.128552185033722e-19,  3.076721082443818e-22, -7.903354621473872e-25,  1.874941673011727e-27, -3.924424389088843e-30,  2.971442138504437e-02,
 -1.627080125245222e-04,  6.583469915867315e-07, -2.319777165376863e-09,  7.457053038497895e-12, -2.219435302113438e-14,  6.112421494237731e-17, -1.534611769713268e-19,
  3.370884201086038e-22, -5.714920577661884e-25,  3.020776070892405e-28,  3.212150140198322e-30,  4.897053623115668e-02, -2.656136547335969e-04,  1.053966033286628e-06,
 -3.589359801254617e-09,  1.091466262461863e-11, -2.970672771140411e-14,  7.038945145299921e-17, -1.320900780132358e-19,  1.185522743670564e-22,  4.901634715547983e-25,
 -3.683771609531465e-27,  1.567386831060007e-29,  7.287539739314564e-02, -3.905848088733152e-04,  1.511929672721401e-06, -4.924956945283375e-09,  1.387167606758803e-11,
 -3.290150425966564e-14,  5.800024565734436e-17, -2.720920064326783e-20, -3.554010303508908e-22,  2.109315926195558e-24, -7.952025131766791e-27,  2.282380657973629e-29,
  1.013195748010507e-01, -5.352734302654265e-04,  2.010091818173920e-06, -6.188253089819443e-09,  1.568915869029481e-11, -2.962004987506175e-14,  1.987905048110045e-17,
  1.519886691259556e-19, -9.467391759168181e-22,  3.453334233614480e-24, -8.877239426112644e-27,  1.257471305383702e-29,  1.341725152771389e-01, -6.969528203735573e-04,
  2.523996484390180e-06, -7.239817633715781e-09,  1.582967274119002e-11, -1.877909474126042e-14, -4.105221567812042e-17,  3.630102950633511e-19, -1.403769339628209e-21,
  3.496273628658380e-24, -3.620153065710229e-27, -1.759351830023351e-29,  1.712829645143743e-01, -8.725652067550279e-04,  3.027900267185576e-06, -7.950332147789812e-09,
  1.393468486976596e-11, -6.945173479990639e-16, -1.146403972147206e-16,  5.391178075162723e-19, -1.452399162275168e-21,  1.576108949270889e-24,  7.451584532096219e-27,
 -5.389849156884089e-29,  2.124794640325241e-01, -1.058775566146514e-03,  3.495859844822125e-06, -8.211284245435136e-09,  9.882805559519285e-12,  2.283288966774814e-14,
 -1.851305083119939e-16,  6.081816454645881e-19, -9.154071653228201e-22, -2.114734325041410e-24,  1.982568090900356e-26, -7.068024051495134e-29,  2.575709250136599e-01,
 -1.252030920697221e-03,  3.902842082349126e-06, -7.944326293225763e-09,  3.821279973503672e-12,  4.869718345666698e-14, -2.343979479060661e-16,  5.161761970421456e-19,
  1.870601966771362e-22, -6.381884167627281e-24,  2.637042370063558e-26, -4.579370002034715e-29,  3.063472810157973e-01, -1.448624235578671e-03,  4.225812534494927e-06,
 -7.108575189840074e-09, -3.833968096672633e-12,  7.291561785843873e-14, -2.461247079955725e-16,  2.482178670110854e-19,  1.600521414704333e-21, -9.367943131983088e-24,
  2.094339474069300e-26,  2.160384275311402e-29,  3.585802215901039e-01, -1.644761949576922e-03,  4.444757914356312e-06, -5.705260224514098e-09, -1.243093120366474e-11,
  9.124520045020786e-14, -2.099917516076022e-16, -1.598447205380116e-19,  2.887383621906225e-21, -9.299005137140814e-24,  2.348426182553469e-27,  1.032625860439896e-28,
  4.140240087748231e-01, -1.836634080533318e-03,  4.543599502817152e-06, -3.779302720587789e-09, -2.114418036636819e-11,  9.989188285009318e-14, -1.248906442106160e-16,
 -6.240049421857848e-19,  3.559071153054498e-21, -5.346481852710995e-24, -2.363875843897337e-26,  1.521552188280033e-28,  4.724163782994724e-01, -2.020485766663021e-03,
  4.510957555329221e-06, -1.417623536126224e-09, -2.906141232858957e-11,  9.619601944519642e-14, -3.154767119563319e-19, -1.029647677491013e-18,  3.249246795808768e-21,
  1.788824942787192e-24, -4.575034398628511e-26,  1.281811780837607e-28,  5.334795270982117e-01, -2.192689035145431e-03,  4.340731503447241e-06,  1.255790663676243e-09,
 -3.528465762783193e-11,  7.917551365048858e-14,  1.445415075818640e-16, -1.260404043836314e-18,  1.867670999410934e-21,  9.890058391941796e-24, -5.205712197594563e-26,
  2.550677892712121e-29,  5.969211883945366e-01, -2.349813533490638e-03,  4.032467073799251e-06,  4.087789650288410e-09, -3.903482376167925e-11,  4.982575500461828e-14,
  2.839707662207180e-16, -1.230890841696208e-18, -3.254735135154939e-22,  1.592117305586555e-23, -3.608549957189097e-26, -1.160008770759435e-28,  6.624357951747155e-01,
 -2.488694919773972e-03,  3.591489217414089e-06,  6.906425925856132e-09, -3.974737511304801e-11,  1.111114299158654e-14,  3.906579641923735e-16, -9.140791296394643e-19,
 -2.761851059312805e-21,  1.719056221573125e-23, -1.118895570672262e-27, -2.256053371794506e-28,  7.297057323101372e-01, -2.606499587742340e-03,  3.028788749232665e-06,
  9.533076318812092e-09, -3.714747188326539e-11, -3.236831847215312e-14,  4.413486257794891e-16, -3.548184776658652e-19, -4.721528699747780e-21,  1.252535450473546e-23,
  3.988600830323891e-26, -2.380405740462812e-28,  7.984026769161897e-01, -2.700784404891209e-03,  2.360660563094303e-06,  1.179544997909638e-08, -3.129481734487732e-11,
 -7.499770256659536e-14,  4.220473018572695e-16,  3.355866398688283e-19, -5.559217392962178e-21,  2.942029684047510e-24,  6.932983203177288e-26, -1.322646122484610e-28,
  8.681890257468170e-01, -2.769550168643367e-03,  1.608101865771077e-06,  1.354051244540877e-08, -2.259164521817611e-11, -1.109667408005191e-13,  3.315601746500620e-16,
  1.003704280284513e-18, -4.926005489788785e-21, -8.532438496028055e-24,  7.295148443923750e-26,  5.064105289429121e-29,  9.387194075213766e-01, -2.811287540235748e-03,
  7.959896574845527e-07,  1.464632400411695e-08, -1.175140636630615e-11, -1.351615731959802e-13,  1.824925615458188e-16,  1.491646099636410e-18, -2.907697127265593e-21,
 -1.789379756114996e-23,  4.698929999067332e-26,  2.237267962977172e-28,  1.009642277068636e+00, -2.825014299938362e-03, -4.793278230134131e-08,  1.503183577613723e-08,
  2.696593863482306e-13, -1.439833256003103e-13, -6.611653040997346e-19,  1.678265592654265e-18, -2.488862700999322e-23, -2.167887808806726e-23,  8.079610193922579e-28,
  2.984668406633629e-28,  1.080601587059763e+00, -2.810302882312269e-03, -8.942208596073623e-07,  1.466381002255415e-08,  1.237129225600975e-11, -1.359537229571803e-13,
 -1.860569315294458e-16,  1.512438945727319e-18,  2.914094969012915e-21, -1.835968632840479e-23, -4.669159097590341e-26,  2.333902268935010e-28,  1.151238531899609e+00,
 -2.767297297129845e-03, -1.712997006009103e-06,  1.356022704573933e-08,  2.342756875992335e-11, -1.119981088591717e-13, -3.407792383878151e-16,  1.028650881856070e-18,
  5.063938739213881e-21, -9.017160678964877e-24, -7.547801425164802e-26,  5.886466138048150e-29,  1.221193357068923e+00, -2.696718720171397e-03, -2.475267541073988e-06,
  1.178979839834869e-08,  3.241125481112081e-11, -7.534710220792765e-14, -4.375311314522676e-16,  3.397742950590435e-19,  5.813788671540383e-21,  3.022313862421006e-24,
 -7.365124176562275e-26, -1.376462943600292e-28,  1.290107225878755e+00, -2.599859247130343e-03, -3.154228640115732e-06,  9.467507472186308e-09,  3.850929671429651e-11,
 -3.106177661506160e-14, -4.602608485000053e-16, -3.916410654198681e-19,  4.985430585097332e-21,  1.346916977110647e-23, -4.297763084942209e-26, -2.586642056315628e-28,
  1.357624134235613e+00, -2.478563540835968e-03, -3.726500031492862e-06,  6.746421369471864e-09,  4.121514374618372e-11,  1.474705951962927e-14, -4.074426603301491e-16,
 -9.959335806953199e-19,  2.887402496125146e-21,  1.875084676699936e-23,  2.124305947477368e-27, -2.494061753790914e-28,  1.423392862649099e+00, -2.335198363151502e-03,
 -4.173225985743292e-06,  3.806336080443198e-09,  4.038600149430602e-11,  5.587900342550112e-14, -2.922334069968023e-16, -1.340838576261689e-18,  2.045354508932977e-22,
  1.738469611604961e-23,  4.166547634437060e-26, -1.256174622920413e-28,  1.487068953373475e+00, -2.172610263077904e-03, -4.480987155438568e-06,  8.401026184096452e-10,
  3.625716154711133e-11,  8.702178740421806e-14, -1.394343128328264e-16, -1.365219751596158e-18, -2.238186410342773e-21,  1.046496109579677e-23,  5.963126896179568e-26,
  3.915729294135650e-29,  1.548316699294635e+00, -1.994071985300765e-03, -4.642473886550549e-06, -1.961292079820348e-09,  2.941079384511219e-11,  1.045775190505633e-13,
  2.006440323449223e-17, -1.092342657331908e-18, -3.752467744073422e-21,  1.073892636396711e-24,  5.114433735050842e-26,  1.580441951794424e-28,  1.606811129990276e+00,
 -1.803218460922241e-03, -4.656881582907100e-06, -4.423672550625087e-09,  2.070238477207503e-11,  1.071918851771199e-13,  1.560738757097326e-16, -6.190836072264501e-19,
 -4.004622472210574e-21, -7.096344626910134e-24,  2.374041298604889e-26,  1.794375181759375e-28,  1.662239979341261e+00, -1.603973535612788e-03, -4.530001216527351e-06,
 -6.403391036994285e-09,  1.115360168021733e-11,  9.589200598389987e-14,  2.455441210094103e-16, -8.474502048015494e-20, -3.098099181799096e-21, -1.128074649771013e-23,
 -7.549535325457480e-27,  1.109090473394284e-28,  1.714305618194386e+00, -1.400468870274979e-03, -4.273992610755830e-06, -7.798620560409977e-09,  1.824989348632021e-12,
  7.380895696447842e-14,  2.771414436461505e-16,  3.706616027226895e-19, -1.496545786252333e-21, -1.065853073408714e-23, -2.834136656478044e-26,  6.441392943091021e-30,
  1.762726934909215e+00, -1.196956705431098e-03, -3.906843989699929e-06, -8.557209851480749e-09, -6.315126307936391e-12,  4.553762407662743e-14,  2.529158416525352e-16,
  6.457141201642335e-19,  1.755013728992287e-22, -6.438777545551462e-24, -3.176527831993728e-26, -7.153692038935915e-29,  1.807241146202677e+00, -9.977184027475062e-04,
 -3.451537662965847e-06, -8.680360763963683e-09, -1.250832228604671e-11,  1.625487784324609e-14,  1.867352821648820e-16,  7.025667023181336e-19,  1.371756446355371e-21,
 -1.054675421596594e-24, -2.058678157008086e-26, -8.925567235130940e-29,  1.847605520576778e+00, -8.069708555711627e-04, -2.934957685333885e-06, -8.221741788550478e-09,
 -1.629465963353076e-11, -9.236604681005199e-15,  9.997746576482546e-17,  5.706269495738534e-19,  1.809109036235964e-21,  3.081003912736576e-24, -4.008907435341882e-27,
 -5.515796918507334e-29,  1.883598996836149e+00, -6.287729860274765e-04, -2.386589946682728e-06, -7.282051675695344e-09, -1.756020422237040e-11, -2.735698189855906e-14,
  1.565912852588689e-17,  3.290444987066980e-19,  1.531063041264638e-21,  4.634061997543720e-24,  8.404617272132448e-27, -5.080968072446477e-30,  1.915023680901813e+00,
 -4.669346110280132e-04, -1.837077482459925e-06, -5.999458704827547e-09, -1.653702722386826e-11, -3.632943848319533e-14, -4.743604355963262e-17,  7.508171193175611e-20,
  8.356895181876541e-22,  3.740120392807461e-24,  1.188777712550738e-26,  2.659187246783974e-29,  1.941706205720791e+00, -3.249299555564037e-04, -1.316703008288852e-06,
 -4.536724626061168e-09, -1.375575400662134e-11, -3.638414249430578e-14, -7.910257491199719e-17, -1.101505334268830e-19,  1.108884209560328e-22,  1.623538924622896e-24,
  7.910260669233667e-27,  2.824284350741173e-29,  1.963498943336714e+00, -2.058180053321170e-04, -8.538760548579222e-07, -3.066139512341090e-09, -9.957375316357822e-12,
 -2.955338566448663e-14, -7.944456425585444e-17, -1.867383327354347e-19, -3.442541546738526e-22, -2.594637735467230e-25,  1.671388404015019e-27,  1.185387947734128e-29,
  1.980281075118631e+00, -1.121716641940422e-04, -4.737029006562743e-07, -1.753610821462377e-09, -5.976829422796625e-12, -1.910763577791959e-14, -5.763895638783928e-17,
 -1.637024518337905e-19, -4.330473552801645e-22, -1.039845960366601e-24, -2.124449144737674e-27, -2.911424483045549e-30,  1.991959637999959e+00, -4.601684333393733e-05,
 -1.967115236760553e-07, -7.433350077062510e-10, -2.614913578555540e-12, -8.754761618925068e-15, -2.819982188179471e-17, -8.786392931848693e-20, -2.654033322466065e-22,
 -7.771390400857181e-25, -2.200910826488029e-27, -5.998627018176939e-30,  1.998472232517734e+00, -8.773339243086710e-06, -3.775734252158289e-08, -1.442913381929924e-10,
 -5.162890006030058e-13, -1.770701144937225e-15, -5.893525567543872e-18, -1.917528379861275e-20, -6.126817794663763e-23, -1.928264221583510e-25, -5.989978320908611e-28,
 -1.839139690252678e-30,  5.958738784460292e-04, -3.273113406898982e-06,  1.348035449063382e-08, -4.933164915433676e-11,  1.691648294554754e-13, -5.565654792053079e-16,
  1.779065614180444e-18, -5.566428322534696e-21,  1.712925609422791e-23, -5.200914953229927e-26,  1.561642531791144e-28, -4.644681648870830e-31,  5.359070620847178e-03,
 -2.937088969074342e-05,  1.204140816942203e-07, -4.372957120197212e-10,  1.482274269134502e-12, -4.797542291953788e-15,  1.499958729666713e-17, -4.559159783716862e-20,
  1.351962755536610e-22, -3.918105433597391e-25,  1.110192918776048e-27, -3.073347087066668e-30,  1.486523565888039e-02, -8.110320547401240e-05,  3.294709741937897e-07,
 -1.178082480010530e-09,  3.899402412782599e-12, -1.219449448956125e-14,  3.634242847747771e-17, -1.034508021452369e-19,  2.805291840579891e-22, -7.187025465021358e-25,
  1.708885331651903e-27, -3.625015948101733e-30,  2.907394940342156e-02, -1.575505908020771e-04,  6.312111486700239e-07, -2.203937146531358e-09,  7.027493958875666e-12,
 -2.077773482645262e-14,  5.697524282986340e-17, -1.430009350804812e-19,  3.167637524293081e-22, -5.568552291729398e-25,  4.233628445810080e-28,  2.332697924846534e-30,
  4.792467640985177e-02, -2.573512915136279e-04,  1.011922210751364e-06, -3.419387737435768e-09,  1.033712423953909e-11, -2.806131913707345e-14,  6.674649829762630e-17,
 -1.280412040208964e-19,  1.337055085607286e-22,  3.558921051373316e-25, -3.046840189066155e-27,  1.333315444728167e-29,  7.133687999709437e-02, -3.787220458493125e-04,
  1.454140399519209e-06, -4.708199017838335e-09,  1.322749797905476e-11, -3.151985776806054e-14,  5.709015749912814e-17, -3.742653241846976e-20, -2.849550855082827e-22,
  1.810662870935980e-24, -6.996715796737907e-27,  2.061544349971397e-29,  9.921017820734389e-02, -5.194855092643047e-04,  1.937319478874971e-06, -5.941938449684564e-09,
  1.510185616117165e-11, -2.909519543089746e-14,  2.372880126375809e-17,  1.236147036664746e-19, -8.286747687885553e-22,  3.109592617836422e-24, -8.303890520702560e-27,
  1.339406639513002e-29,  1.314245437537982e-01, -6.771040829490955e-04,  2.438625762987669e-06, -6.989597691090877e-09,  1.544503587807584e-11, -1.964733722299329e-14,
 -3.149810174791611e-17,  3.200741740046979e-19, -1.280680540815515e-21,  3.337728168759443e-24, -4.266063141681613e-27, -1.195392906486306e-29,  1.678405512147203e-01,
 -8.487198323281529e-04,  2.933833082334687e-06, -7.727632765122232e-09,  1.389447663383232e-11, -3.269940800773857e-15, -1.001868594891962e-16,  4.936019169418152e-19,
 -1.390841926823250e-21,  1.829333452336097e-24,  5.272195820767732e-27, -4.531016781908533e-29,  2.082996753066660e-01, -1.031200107742539e-03,  3.398287486601331e-06,
 -8.049741774830626e-09,  1.029639400066350e-11,  1.859073136753120e-14, -1.685219131379909e-16,  5.778175983511630e-19, -9.779976609613177e-22, -1.382256707161892e-24,
  1.683996428384549e-26, -6.495129513346192e-29,  2.526246445978793e-01, -1.221188400254013e-03,  3.807908173202302e-06, -7.875694995701929e-09,  4.740141443883026e-12,
  4.324553921120032e-14, -2.198943219635810e-16,  5.186857187444516e-19, -2.419816020892318e-23, -5.368610134338003e-24,  2.426667655840052e-26, -4.945348921273932e-29,
  3.006198554935874e-01, -1.415159880992434e-03,  4.140188662655290e-06, -7.158570663924759e-09, -2.434134101912326e-12,  6.709750776135945e-14, -2.385071113362681e-16,
  2.942018764445749e-19,  1.278541006495986e-21, -8.515852487665308e-24,  2.155129943334142e-26,  6.520154181273692e-30,  3.520718517257773e-01, -1.609480983059287e-03,
  4.375160753379407e-06, -5.889831058778222e-09, -1.065673509300818e-11,  8.616182290399624e-14, -2.132240032226606e-16, -7.277802399601207e-20,  2.555349209181507e-21,
 -9.120338246974911e-24,  6.435420524602458e-27,  8.274353419054639e-29,  4.067498748971786e-01, -1.800472291509401e-03,  4.496283414280194e-06, -4.101795473920949e-09,
 -1.917766597268118e-11,  9.669752727998560e-14, -1.407984802150818e-16, -5.133638613593276e-19,  3.351156728162255e-21, -6.161969291908704e-24, -1.723429091686117e-26,
  1.386218258327507e-28,  4.644064918474496e-01, -1.984473910686802e-03,  4.491219639079502e-06, -1.867224771876702e-09, -2.713984196570294e-11,  9.585428281238644e-14,
 -2.768272158622315e-17, -9.249834548120119e-19,  3.282081729715369e-21,  7.353942216563786e-26, -3.997571438663858e-26,  1.334411096921836e-28,  5.247783047126053e-01,
 -2.157912381080599e-03,  4.352466498177195e-06,  7.040808324701978e-10, -3.366927974242281e-11,  8.222808225042090e-14,  1.101375859139253e-16, -1.195341084439243e-18,
  2.186577985742910e-21,  7.838438078720570e-24, -5.033037746831681e-26,  5.207475968606038e-29,  5.875867495192063e-01, -2.317368122386385e-03,  4.077807258958108e-06,
  3.471563156209372e-09, -3.797295121023688e-11,  5.622681656586282e-14,  2.494441351751727e-16, -1.232423303927611e-18,  2.205770671021994e-22,  1.438663078302876e-23,
 -4.037341949057429e-26, -7.919716204166660e-29,  6.525389889748590e-01, -2.459642288721565e-03,  3.670559539813540e-06,  6.272746250519419e-09, -3.943351666284763e-11,
  2.017038773663366e-14,  3.639193027429937e-16, -9.925842097557355e-19, -2.146120774282408e-21,  1.695480139355067e-23, -1.047506051319868e-26, -1.989833028984126e-28,
  7.193289047681487e-01, -2.581821839676265e-03,  3.139599998966909e-06,  8.934109676736493e-09, -3.768980574027364e-11, -2.191181636631251e-14,  4.293683270260335e-16,
 -4.984054384138857e-19, -4.244433611929999e-21,  1.391018732348983e-23,  2.934306070124949e-26, -2.397796543695165e-28,  7.876381941568492e-01, -2.681341561384301e-03,
  2.499153952484232e-06,  1.128328645341254e-08, -3.269282233988620e-11, -6.477579563561196e-14,  4.289728674712331e-16,  1.599094957127897e-19, -5.404886069823616e-21,
  5.588318968063977e-24,  6.273834716025744e-26, -1.660669028194982e-28,  8.571375748870673e-01, -2.756041719861661e-03,  1.768347404965658e-06,  1.316173302921976e-08,
 -2.472922237892813e-11, -1.026901280031168e-13,  3.574149025572205e-16,  8.417240655236329e-19, -5.180247765214768e-21, -5.584793218696548e-24,  7.406280988269452e-26,
  1.513004283221532e-31,  9.274881015342065e-01, -2.804219999636013e-03,  9.705290130620191e-07,  1.443692762466095e-08, -1.440751337822760e-11, -1.302916546475702e-13,
  2.228618573315525e-16,  1.388674308107643e-18, -3.515771354050145e-21, -1.582866284282013e-23,  5.597597176597570e-26,  1.837388176631125e-28,  9.983425951789812e-01,
 -2.824676379513139e-03,  1.323801461567424e-07,  1.501312809830451e-08, -2.606363021330051e-12, -1.434361065936813e-13,  4.620198812768331e-17,  1.665013999129606e-18,
 -8.015898140441823e-22, -2.138496549401743e-23,  1.384242069141211e-26,  2.922593550960475e-28,  1.069347186922549e+00, -2.816749629470259e-03, -7.171579708611504e-07,
  1.483977006479284e-08,  9.611046166556378e-12, -1.399009955557281e-13, -1.425049396431711e-16,  1.594775049988668e-18,  2.222096399950414e-21, -2.001184425589082e-23,
 -3.568062300882750e-26,  2.657246523998932e-28,  1.140142974104415e+00, -2.780344183055285e-03, -1.548100565521103e-06,  1.391671419050504e-08,  2.110824583237209e-11,
 -1.198131933182021e-13, -3.097612903445922e-16,  1.184926356210564e-18,  4.685744471635844e-21, -1.196872804560593e-23, -7.171161274197906e-26,  1.122019273269126e-28,
  1.210367786222537e+00, -2.715946252532319e-03, -2.330730047299795e-06,  1.229575601233676e-08,  3.080018490327584e-11, -8.571258261354617e-14, -4.254006358325114e-16,
  5.269766964790101e-19,  5.868217443243226e-21, -3.224432152613568e-26, -7.875137182406879e-26, -9.300544139926407e-29,  1.279658055482949e+00, -2.624628212494301e-03,
 -3.036944112273644e-06,  1.007808275673648e-08,  3.777680536043069e-11, -4.222116543224181e-14, -4.689229239704780e-16, -2.247029397619616e-19,  5.436658210796999e-21,
  1.152524907841602e-23, -5.413078149896945e-26, -2.466262026609947e-28,  1.347650784651553e+00, -2.508040483425683e-03, -3.641578334674678e-06,  7.407682608249389e-09,
  4.141009652770605e-11,  4.644866610308534e-15, -4.339337744019490e-16, -8.927417464825365e-19,  3.561247074808634e-21,  1.860866524425456e-23, -9.411867384701007e-27,
 -2.738830691455362e-28,  1.413985602479273e+00, -2.368390399516191e-03, -4.123637285715645e-06,  4.461058928577034e-09,  4.143041084053717e-11,  4.841620899888620e-14,
 -3.295889423798617e-16, -1.323969775107022e-18,  8.589352094926457e-22,  1.892797491575639e-23,  3.518028342551757e-26, -1.692761138621970e-28,  1.478306894470050e+00,
 -2.208407842421059e-03, -4.467368426952538e-06,  1.433945728924927e-09,  3.796099645186159e-11,  8.320892141517409e-14, -1.786032383532756e-16, -1.430350779892500e-18,
 -1.818190527006226e-21,  1.287442486080530e-23,  6.057680048742752e-26,  2.763174539729811e-30,  1.540265994216517e+00, -2.031297759601879e-03, -4.663116878385050e-06,
 -1.473971453892563e-09,  3.150461232770997e-11,  1.046785188443857e-13, -1.219359174433157e-17, -1.211394771123273e-18, -3.675330319329896e-21,  3.256171950616970e-24,
  5.789336097752620e-26,  1.475578458781446e-28,  1.599523418008303e+00, -1.840680054595675e-03, -4.707906835413434e-06, -4.075086329465926e-09,  2.288220030920221e-11,
  1.107149362749483e-13,  1.369084560176437e-16, -7.511200022344190e-19, -4.241049706108655e-21, -5.983887856125863e-24,  3.199905523778094e-26,  1.954297882895932e-28,
  1.655751122999391e+00, -1.640517726503867e-03, -4.605706840007765e-06, -6.209271512766247e-09,  1.313012069080661e-11,  1.017450107531892e-13,  2.417219026858367e-16,
 -1.904301677636175e-19, -3.508393427088400e-21, -1.147717024041123e-23, -2.071420089020543e-27,  1.383902815549292e-28,  1.708634766988039e+00, -1.435034533996158e-03,
 -4.367350964549011e-06, -7.757246478553042e-09,  3.368493594521879e-12,  8.057912005303948e-14,  2.867902769958168e-16,  3.164149205657354e-19, -1.900538654204240e-21,
 -1.178077789211709e-23, -2.762143283176793e-26,  2.698012729029759e-29,  1.757875945904692e+00, -1.228623849745477e-03, -4.010105620077215e-06, -8.650629894512314e-09,
 -5.342207206304064e-12,  5.182497573513677e-14,  2.710378311970554e-16,  6.473700953813239e-19, -7.991605604776728e-23, -7.771403863864207e-24, -3.483726760213019e-26,
 -6.757561587884217e-29,  1.803194383513074e+00, -1.025750737308563e-03, -3.556891255594767e-06, -8.877642860108180e-09, -1.213678937498634e-11,  2.097750634033269e-14,
  2.070148103971774e-16,  7.456886353516625e-19,  1.317993565791924e-21, -1.959500274828489e-24, -2.472331877008031e-26, -9.870256242500006e-29,  1.844330046704593e+00,
 -8.308496059722818e-04, -3.035188532846274e-06, -8.483798277457929e-09, -1.645406871433340e-11, -6.638771850669713e-15,  1.167819264265376e-16,  6.302571924551405e-19,
  1.916521997175101e-21,  2.868586174466169e-24, -6.701956974304954e-27, -6.751238591423378e-29,  1.881045159219209e+00, -6.482200618909050e-04, -2.475678327057077e-06,
 -7.567368406748192e-09, -1.810281012153274e-11, -2.686491108400659e-14,  2.558382981362496e-17,  3.807720758143716e-19,  1.703870420429339e-21,  4.963963099362713e-24,
  8.042722356257835e-27, -1.163672514283709e-29,  1.913126086835595e+00, -4.819237585957788e-04, -1.910682717243150e-06, -6.269924936397081e-09, -1.727481420122458e-11,
 -3.743952647064672e-14, -4.493845754680433e-17,  1.040721650959162e-19,  9.791775786144393e-22,  4.239305338295010e-24,  1.307735849772895e-26,  2.739740629612221e-29,
  1.940385068503387e+00, -3.356851399490832e-04, -1.372488606695861e-06, -4.762742343429456e-09, -1.450266898629210e-11, -3.831915764875115e-14, -8.212787544653693e-17,
 -1.056033788985147e-19,  1.753411875401073e-22,  1.965961038221871e-24,  9.240244821448847e-27,  3.227958914783301e-29,  1.962661772388190e+00, -2.127989424767767e-04,
 -8.916454827563459e-07, -3.230291455071446e-09, -1.056793971589025e-11, -3.152405225284797e-14, -8.482876952875774e-17, -1.978899483966214e-19, -3.522588500261781e-22,
 -1.814119817142612e-25,  2.250999308663678e-27,  1.457345589236133e-29,  1.979824673607003e+00, -1.160471159561024e-04, -4.953328649720018e-07, -1.852374062219170e-09,
 -6.373195006773693e-12, -2.054757583624387e-14, -6.242237627033140e-17, -1.781755674495190e-19, -4.720419204725737e-22, -1.127344267653104e-24, -2.249230870271911e-27,
 -2.741281618361491e-30,  1.991772365726806e+00, -4.762694041057968e-05, -2.058884750586034e-07, -7.866120134577160e-10, -2.796981115386938e-12, -9.462065794041417e-15,
 -3.078324266641606e-17, -9.682198881474524e-20, -2.950306617509665e-22, -8.706817741798584e-25, -2.482034536162636e-27, -6.796350559862523e-30,  1.998436523875272e+00,
 -9.082467140419270e-06, -3.953959638952952e-08, -1.528431461615337e-10, -5.531621319949303e-13, -1.918816783160729e-15, -6.458959143615769e-18, -2.125172091532030e-20,
 -6.866145225643279e-23, -2.184869445329981e-25, -6.861420992888671e-28, -2.129487291929701e-30,  5.829934251475556e-04, -3.167593308465634e-06,  1.290425456380752e-08,
 -4.671179435793829e-11,  1.584481838833200e-13, -5.156779728899162e-16,  1.630606423680637e-18, -5.047082655092940e-21,  1.536461063315706e-23, -4.615267828151994e-26,
  1.371035414223940e-28, -4.034513992107570e-31,  5.243481012653733e-03, -2.842817122007287e-05,  1.153057272950505e-07, -4.143277964190834e-10,  1.389822394839557e-12,
 -4.452394837160661e-15,  1.378152961681276e-17, -4.148268685591204e-20,  1.218588831061950e-22, -3.499941060724818e-25,  9.833396076663948e-28, -2.701059842388798e-30,
  1.454600631161769e-02, -7.852294323460131e-05,  3.157004295616571e-07, -1.117596736900731e-09,  3.664005222180080e-12, -1.135604472497810e-14,  3.356768574912136e-17,
 -9.487495515332670e-20,  2.558486337535941e-22, -6.534512561806603e-25,  1.555782814544539e-27, -3.336236135940282e-30,  2.845368157688783e-02, -1.526048102235322e-04,
  6.054250660194920e-07, -2.094748726042485e-09,  6.625294836023424e-12, -1.945725029665188e-14,  5.311013750710311e-17, -1.331817878142237e-19,  2.970445085182681e-22,
 -5.380866863256890e-25,  5.099421118241976e-28,  1.628923706241253e-30,  4.691120603962704e-02, -2.494172748349654e-04,  9.718636799863553e-07, -3.258397733341637e-09,
  9.791629164890015e-12, -2.650193051820027e-14,  6.322300950489456e-17, -1.235800453662927e-19,  1.444596246602120e-22,  2.451344065936705e-25, -2.505777779741163e-27,
  1.130971143370503e-29,  6.984490525376452e-02, -3.673113657549223e-04,  1.398891288137317e-06, -4.501528155936870e-09,  1.261071250156951e-11, -3.016324135858769e-14,
  5.592397901242616e-17, -4.555443137780779e-20, -2.245959670915402e-22,  1.548309810311658e-24, -6.136207719006069e-27,  1.851914488336915e-29,  9.716278743569259e-02,
 -5.042681027920525e-04,  1.867446896160236e-06, -5.704931915813788e-09,  1.452591246741385e-11, -2.848706497385005e-14,  2.683514545712471e-17,  9.882529137496768e-20,
 -7.225649878559709e-22,  2.789351115878022e-24, -7.705824982195440e-27,  1.371993617357045e-29,  1.287546201159875e-01, -6.579264066006176e-04,  2.356220221976609e-06,
 -6.745658799321718e-09,  1.504523205083990e-11, -2.030026785845858e-14, -2.309194630979450e-17,  2.809810516679728e-19, -1.163707599627068e-21,  3.157985359533076e-24,
 -4.687756689388528e-27, -7.376663960037859e-30,  1.644920312425198e-01, -8.256163205406851e-04,  2.842432790183330e-06, -7.505970363773342e-09,  1.380612673185067e-11,
 -5.513542256660710e-15, -8.697893435642793e-17,  4.501856138698094e-19, -1.321649074880971e-21,  2.002678904223809e-24,  3.451141103916504e-27, -3.761244494986830e-29,
  2.042286396844122e-01, -1.004397367978508e-03,  3.302690612049403e-06, -7.882239269721309e-09,  1.062905540372724e-11,  1.473677425783955e-14, -1.527877490951019e-16,
  5.458500136965798e-19, -1.016306754476970e-21, -7.640416679531518e-25,  1.411509340074282e-26, -5.887225056651525e-29,  2.478002208793764e-01, -1.191101815014940e-03,
  3.713882513538158e-06, -7.793215254430153e-09,  5.553452784070302e-12,  3.814209439524845e-14, -2.054097067405880e-16,  5.150021019058057e-19, -2.005262723332202e-22,
 -4.442066581034442e-24,  2.204892796639917e-26, -5.104924402233544e-29,  2.950249141340776e-01, -1.382382545185726e-03,  4.054095422560702e-06, -7.187089341177366e-09,
 -1.148735690543827e-12,  6.147653481066444e-14, -2.297415719253275e-16,  3.303767638174039e-19,  9.875214880470205e-22, -7.651856537259340e-24,  2.155962696289877e-26,
 -5.685777414002366e-30,  3.457034788166369e-01, -1.574765178398259e-03,  4.303515698748711e-06, -6.046831503174376e-09, -8.984790982266137e-12,  8.102893212059588e-14,
 -2.141659569583832e-16,  3.796295291759961e-21,  2.232475871445061e-21, -8.795801988611852e-24,  9.653608364838173e-27,  6.383027473042005e-29,  3.996196073573404e-01,
 -1.764703980939043e-03,  4.445284025460369e-06, -4.393354798217749e-09, -1.727860963133875e-11,  9.315778184221849e-14, -1.537055794448073e-16, -4.097975181409031e-19,
  3.118347519519840e-21, -6.733717741743887e-24, -1.146333277627782e-26,  1.235041345970906e-28,  4.565403035798901e-01, -1.948641016979101e-03,  4.466270640336299e-06,
 -2.286170248745037e-09, -2.523143671845297e-11,  9.489096275866921e-14, -5.211362128397193e-17, -8.202115753462051e-19,  3.257366351583116e-21, -1.407608020411502e-24,
 -3.407849114556155e-26,  1.338892635164343e-28,  5.162163353992859e-01, -2.123067885395450e-03,  4.357737922323251e-06,  1.786612349701442e-10, -3.200095419137529e-11,
  8.447790333866594e-14,  7.768730187666556e-17, -1.121239314775879e-18,  2.433136863223677e-21,  5.877645981100843e-24, -4.755584242802148e-26,  7.313670584342129e-29,
  5.783827713182603e-01, -2.284589270406069e-03,  4.115858744857299e-06,  2.873305790346437e-09, -3.679133731072086e-11,  6.180064644289011e-14,  2.151107030743212e-16,
 -1.217396013973086e-18,  7.086817052329495e-22,  1.271235175921078e-23, -4.308934048101710e-26, -4.472346470895439e-29,  6.427596104031017e-01, -2.429987412804906e-03,
  3.742061700731680e-06,  5.645502214893848e-09, -3.894505718174562e-11,  2.856374301398616e-14,  3.352565689293109e-16, -1.051591588456221e-18, -1.545321666600371e-21,
  1.636933546904552e-23, -1.857945930156820e-26, -1.689701501986243e-28,  7.090525154895181e-01, -2.556286483740218e-03,  3.243178431973542e-06,  8.328121775627511e-09,
 -3.802620138126417e-11, -1.178931831936327e-14,  4.135882462611318e-16, -6.260090865580257e-19, -3.725071570476092e-21,  1.487421194421962e-23,  1.890430318249202e-26,
 -2.334629969692429e-28,  7.769536592250532e-01, -2.660815719281152e-03,  2.631373942255477e-06,  1.075039772255774e-08, -3.388512224545802e-11, -5.444605845087627e-14,
  4.310625562360429e-16, -9.358439918906628e-21, -5.160371443751162e-21,  7.943539885576172e-24,  5.483534079486966e-26, -1.917856014771753e-28,  8.461426921598592e-01,
 -2.741270056807589e-03,  1.923847951282855e-06,  1.275010879373772e-08, -2.669543385459099e-11, -9.384824817792070e-14,  3.786362727393404e-16,  6.733102114475353e-19,
 -5.328104449358545e-21, -2.636483195408136e-24,  7.300411081087315e-26, -4.768035571361123e-29,  9.162878414152386e-01, -2.795766909939719e-03,  1.142304007707253e-06,
  1.418586434259673e-08, -1.695677799164720e-11, -1.244895992307639e-13,  2.600871763938323e-16,  1.267499491557020e-18, -4.043469857850248e-21, -1.344092510604467e-23,
  6.308155245036325e-26,  1.385503338419736e-28,  9.870471474533019e-01, -2.822897634678915e-03,  3.121930429782071e-07,  1.494855255001823e-08, -5.460238407120869e-12,
 -1.417714196339405e-13,  9.234843887385572e-17,  1.627177167571174e-18, -1.558419339522416e-21, -2.057822485899924e-23,  2.637390182253526e-26,  2.756991837538251e-28,
  1.058069845108512e+00, -2.821772183850363e-03, -5.382509644370837e-07,  1.497099213592952e-08,  6.782480687470041e-12, -1.427779095369548e-13, -9.696587225934197e-17,
  1.654103192299042e-18,  1.478867632033230e-21, -2.119768640540253e-23, -2.344206607712870e-26,  2.889678897516970e-28,  1.128997893295649e+00, -2.792055428538570e-03,
 -1.379153957229801e-06,  1.423488366421318e-08,  1.864041247577164e-11, -1.268328030433693e-13, -2.745528001447576e-16,  1.327433156827442e-18,  4.204567725428284e-21,
 -1.472311445386431e-23, -6.563334087876146e-26,  1.635654433114848e-28,  1.199467655660103e+00, -2.733993652832495e-03, -2.180282509971586e-06,  1.277429563349418e-08,
  2.898514186249571e-11, -9.572393722010048e-14, -4.080208780153628e-16,  7.141259826600355e-19,  5.809501619694480e-21, -3.249544414479026e-24, -8.174218311205872e-26,
 -4.203456365715020e-29,  1.269111731878131e+00, -2.648429810287163e-03, -2.912410397560958e-06,  1.067514299981556e-08,  3.681943409480428e-11, -5.353078892336985e-14,
 -4.727197094317533e-16, -4.453011509169731e-20,  5.810029422360757e-21,  9.148803718548096e-24, -6.452893335345212e-26, -2.243079900123273e-28,  1.337560936354478e+00,
 -2.536806274448944e-03, -3.548709564080364e-06,  8.070413222384697e-09,  4.139689418372466e-11, -6.056011921990668e-15, -4.572350507909602e-16, -7.681598269950660e-19,
  4.221426100688621e-21,  1.798556294896564e-23, -2.186741626218288e-26, -2.909046183060413e-28,  1.404446417727826e+00, -2.401154027163556e-03, -4.066096730904583e-06,
  5.131249771326912e-09,  4.231664966863177e-11,  4.006496540227643e-14, -3.661710067567295e-16, -1.285325082672108e-18,  1.563759878263935e-21,  2.017336082762120e-23,
  2.677251333845253e-26, -2.126995221028920e-28,  1.469401908927194e+00, -2.244067510154288e-03, -4.446462696556732e-06,  2.054388471383316e-09,  3.957903396722179e-11,
  7.843571622300264e-14, -2.193946011407163e-16, -1.480650032979994e-18, -1.311176001018400e-21,  1.528783346243293e-23,  5.978378142222432e-26, -3.976576534794453e-29,
  1.532066093593571e+00, -2.068664717054369e-03, -4.677711088814634e-06, -9.531767641117788e-10,  3.359244063348649e-11,  1.039656786068364e-13, -4.773831223535328e-17,
 -1.326670422391221e-18, -3.514902272872743e-21,  5.697026573665563e-24,  6.401815929406746e-26,  1.295307740691137e-28,  1.592085070584047e+00, -1.878532520054351e-03,
 -4.754537550185780e-06, -3.691085635115298e-09,  2.512757345610198e-11,  1.137328374677620e-13,  1.139465807141866e-16, -8.900162208455454e-19, -4.431321977573983e-21,
 -4.528051319617062e-24,  4.088121968202958e-26,  2.075506180438159e-28,  1.649114894127732e+00, -1.677657698173375e-03, -4.678889439347818e-06, -5.982597220661458e-09,
  1.522253508086161e-11,  1.074692834865090e-13,  2.347559407301477e-16, -3.093131855868599e-19, -3.921518893976058e-21, -1.142981553599438e-23,  4.649650119776037e-27,
  1.672764579139042e-28,  1.702824163143949e+00, -1.470344648388878e-03, -4.460060145363367e-06, -7.690081063775356e-09,  5.049586083349830e-12,  8.756113033200966e-14,
  2.947331910711670e-16,  2.486014530426064e-19, -2.344184809483198e-21, -1.285489114794790e-23, -2.590303084918181e-26,  5.186088094957756e-29,  1.752896629423296e+00,
 -1.261121296920632e-03, -4.114390664535926e-06, -8.727453626005534e-09, -4.239193002665860e-12,  5.854684279409495e-14,  2.890843820424534e-16,  6.400618033933782e-19,
 -3.854689586075673e-22, -9.222436074763821e-24, -3.765982501199417e-26, -6.007824240013258e-29,  1.799033790986657e+00, -1.054635261742088e-03, -3.664573362510019e-06,
 -9.068197957984981e-09, -1.166584014332901e-11,  2.620110681812721e-14,  2.284725377289494e-16,  7.865362385522023e-19,  1.228579852963546e-21, -3.037945210478048e-24,
 -2.926304692845956e-26, -1.074967374895177e-28,  1.840957434165126e+00, -8.555428211303180e-04, -3.138577574377889e-06, -8.747967170818896e-09, -1.655735085202366e-11,
 -3.617215633584179e-15,  1.353028507705629e-16,  6.931804161292640e-19,  2.014213698346602e-21,  2.537111000339734e-24, -9.973266035167427e-27, -8.144291116270600e-29,
  1.878412085993393e+00, -6.683936867547028e-04, -2.568242230308800e-06, -7.861274655218693e-09, -1.863307208236863e-11, -2.611663124172441e-14,  3.703608305997822e-17,
  4.382161245488127e-19,  1.888219646400212e-21,  5.273119811736048e-24,  7.354516438788804e-27, -1.996151293513822e-29,  1.911167337654410e+00, -4.975149327637487e-04,
 -1.987605095686262e-06, -6.552369831290386e-09, -1.803413501417044e-11, -3.847939581393366e-14, -4.156208877524221e-17,  1.379510101933025e-19,  1.141499887295345e-21,
  4.786620302568430e-24,  1.428990161563694e-26,  2.760128823415782e-29,  1.939020000510767e+00, -3.468976641069479e-04, -1.431059411309508e-06, -5.001024200257591e-09,
 -1.528899877404035e-11, -4.032500734474656e-14, -8.499505237571396e-17, -9.878587845578467e-20,  2.531226631064991e-22,  2.365257789413860e-24,  1.075704298927822e-26,
  3.673493489037038e-29,  1.961796060666228e+00, -2.200900834529487e-04, -9.314446718239738e-07, -3.404534862501401e-09, -1.121923508629221e-11, -3.362771289334774e-14,
 -9.052835042611879e-17, -2.092480388694788e-19, -3.570061534394799e-22, -7.763094071921634e-26,  2.961757406020270e-27,  1.782959868733604e-29,  1.979352416547749e+00,
 -1.201004581096121e-04, -5.181870102211404e-07, -1.957715920666955e-09, -6.799540978920754e-12, -2.210732488752501e-14, -6.762899326874028e-17, -1.939478546896334e-19,
 -5.142741320252567e-22, -1.219647215907491e-24, -2.363702027893484e-27, -2.436557273038964e-30,  1.991578502873713e+00, -4.931258101434896e-05, -2.156027069645752e-07,
 -8.329187244959918e-10, -2.993835640755720e-12, -1.023449229933412e-14, -3.363128429341940e-17, -1.067842442153148e-19, -3.282366749846577e-22, -9.762020744727083e-25,
 -2.800569959469896e-27, -7.701302063191003e-30,  1.998399549540759e+00, -9.406273814995887e-06, -4.142811197361940e-08, -1.620093803196756e-10, -5.931381314462449e-13,
 -2.081228122419138e-15, -7.085988965801014e-18, -2.358022184131345e-20, -7.704445476289866e-23, -2.479027703884136e-25, -7.871248788105604e-28, -2.469543729632057e-30,
  5.705260297181425e-04, -3.066559110428912e-06,  1.235859046846382e-08, -4.425705264865406e-11,  1.485148039379585e-13, -4.781851782844088e-16,  1.495929026458024e-18,
 -4.580974370655363e-21,  1.379769747708801e-23, -4.100755322790949e-26,  1.205348074678250e-28, -3.509696267563580e-31,  5.131582255411559e-03, -2.752524175706117e-05,
  1.104643352602310e-07, -3.927854372949809e-10,  1.303990211335862e-12, -4.135147043858790e-15,  1.267276580245509e-17, -3.777743430256503e-20,  1.099393639075734e-22,
 -3.129385718134619e-25,  8.718039929021617e-28, -2.375988151189431e-30,  1.423688219277360e-02, -7.605000481327892e-05,  3.026336575921453e-07, -1.060746735078924e-09,
  3.444730086463955e-12, -1.058139441728349e-14,  3.102235470606209e-17, -8.705245835278893e-20,  2.334099235602006e-22, -5.940737934721342e-25,  1.415094066937854e-27,
 -3.061151734403842e-30,  2.785279244182693e-02, -1.478601846853193e-04,  5.809114887449629e-07, -1.991789161888174e-09,  6.248599682534138e-12, -1.822629971913797e-14,
  4.951124008974521e-17, -1.239822351435425e-19,  2.780562156613127e-22, -5.164297638473463e-25,  5.688313415502676e-28,  1.069332061126451e-30,  4.592884282848260e-02,
 -2.417961449162536e-04,  9.336856761742091e-07, -3.105890699768157e-09,  9.276486529085045e-12, -2.502557133328418e-14,  5.982868037457556e-17, -1.188345434409425e-19,
  1.515953498674679e-22,  1.543234919932110e-25, -2.047465042085882e-27,  9.565856074849132e-30,  6.839770471787578e-02, -3.563329240640574e-04,  1.346063905931087e-06,
 -4.304510397306742e-09,  1.202076212717128e-11, -2.883713444210472e-14,  5.455588671361198e-17, -5.189548894842822e-20, -1.730838775247101e-22,  1.318570432282625e-24,
 -5.365058317641141e-27,  1.655633361169614e-29,  9.517516612119151e-02, -4.895984563750460e-04,  1.800363515116149e-06, -5.477039358724105e-09,  1.396282262139492e-11,
 -2.781233829260648e-14,  2.929322318548390e-17,  7.725157086647629e-20, -6.275509262351929e-22,  2.493201092451927e-24, -7.102036453900107e-27,  1.367201874136844e-29,
  1.261601070795247e-01, -6.393963751831190e-04,  2.276703170074004e-06, -6.508210640697688e-09,  1.463430058522351e-11, -2.076416916427454e-14, -1.572898819938614e-17,
  2.455246531195272e-19, -1.053463045861134e-21,  2.965123212405230e-24, -4.928691668908433e-27, -3.714230528029274e-30,  1.612344797208531e-01, -8.032333986267469e-04,
  2.753682539152526e-06, -7.286063722707482e-09,  1.367597755037403e-11, -7.454485906189424e-15, -7.495482563734377e-17,  4.090699172914682e-19, -1.247447707022177e-21,
  2.109694171794836e-24,  1.949235841997577e-27, -3.079998639580785e-29,  2.002632983215968e-01, -9.783512783329811e-04,  3.209133225065917e-06, -7.710010604518174e-09,
  1.088834073013273e-11,  1.124957727628112e-14, -1.379626410485341e-16,  5.129921200053754e-19, -1.034257128773203e-21, -2.494288342110284e-25,  1.166050174240646e-26,
 -5.270326624581923e-29,  2.430946456619740e-01, -1.161763262439656e-03,  3.620921381444787e-06, -7.698520241098240e-09,  6.268160014477951e-12,  3.338443525254602e-14,
 -1.911023360358052e-16,  5.061924474141425e-19, -3.451078041967612e-22, -3.605125444430516e-24,  1.979849028425372e-26, -5.100562902394560e-29,  2.895597029409577e-01,
 -1.350294983035898e-03,  3.967779684666275e-06, -7.195929243436549e-09,  2.642371922656987e-14,  5.607706595854680e-14, -2.200888418562555e-16,  3.577357499643788e-19,
  7.274896530297451e-22, -6.797474516987468e-24,  2.108977990073544e-26, -1.525929997881012e-29,  3.394728115049672e-01, -1.540629623233250e-03,  4.230143755674768e-06,
 -6.177902624502344e-09, -7.415563070472444e-12,  7.589800755273298e-14, -2.131065527610252e-16,  7.024884932120712e-20,  1.923407266776142e-21, -8.358641680511819e-24,
  1.208039387746200e-26,  4.680564012616279e-29,  3.926315756330661e-01, -1.729357149268414e-03,  4.390965846063181e-06, -4.655111440602742e-09, -1.545321543984841e-11,
  8.934220501779477e-14, -1.638199038843701e-16, -3.139671639388404e-19,  2.868947483540949e-21, -7.088213314087531e-24, -6.377264948353461e-27,  1.076129028183585e-28,
  4.488170165939675e-01, -1.913027307224289e-03,  4.436476766507166e-06, -2.674766235553755e-09, -2.334792433060912e-11,  9.337636745125410e-14, -7.362967237903496e-17,
 -7.170382386521607e-19,  3.183569097875643e-21, -2.653703532032919e-24, -2.825207376000778e-26,  1.303617373726840e-28,  5.077937891244076e-01, -2.088205981524888e-03,
  4.356865820328465e-06, -3.197467768478679e-10, -3.029524789007507e-11,  8.597464294663956e-14,  4.741187669760899e-17, -1.040353941147502e-18,  2.611313651326394e-21,
  4.044771516880297e-24, -4.397364431767426e-26,  8.882670857953475e-29,  5.693104723459946e-01, -2.251534393310956e-03,  4.146848111469551e-06,  2.294801462954532e-09,
 -3.550644387260609e-11,  6.655723173495858e-14,  1.814075122140314e-16, -1.187731813096095e-18,  1.134914289610817e-21,  1.095887085111105e-23, -4.435729474016563e-26,
 -1.351037532161356e-29,  6.330999479031187e-01, -2.399790481941195e-03,  3.806089242434196e-06,  5.027378568669875e-09, -3.829573234279326e-11,  3.625151704305705e-14,
  3.052071870699555e-16, -1.091770565941602e-18, -9.711101222942985e-22,  1.548675557509699e-23, -2.531737637174157e-26, -1.371174610309947e-28,  6.988798787254131e-01,
 -2.529951664012369e-03,  3.339459327141933e-06,  7.718349386108273e-09, -3.816421385430025e-11, -2.086509821404408e-15,  3.944725840826471e-16, -7.365177851473641e-19,
 -3.178433944140762e-21,  1.542838350959757e-23,  8.901218080181941e-27, -2.201731048378607e-28,  7.663533022448330e-01, -2.639258004513517e-03,  2.757091628556357e-06,
  1.020008608157539e-08, -3.487070488787944e-11, -4.412208248657795e-14,  4.285345847347278e-16, -1.695083773062669e-19, -4.837009274549958e-21,  9.962479340644114e-24,
  4.598573620756294e-26, -2.090722604945202e-28,  8.352093520730770e-01, -2.725274668544354e-03,  2.074226171351154e-06,  1.230846593641728e-08, -2.848009891589029e-11,
 -8.455407949340014e-14,  3.950916896872480e-16,  5.018509489693837e-19, -5.371080857536070e-21,  2.285732238692753e-25,  6.993245303588516e-26, -9.107930837663436e-29,
  9.051241220072606e-01, -2.785952355595143e-03,  1.310825496928766e-06,  1.389498851052199e-08, -1.938135176239724e-11, -1.178366777632757e-13,  2.936964823299918e-16,
  1.130864558339523e-18, -4.480583051864340e-21, -1.080980826710105e-23,  6.812202428171432e-26,  9.021831387276989e-29,  9.757616857135051e-01, -2.819684259631252e-03,
  4.909583536972826e-07,  1.483864111137901e-08, -8.269844736752092e-12, -1.390146374715596e-13,  1.371014454112104e-16,  1.565681617797179e-18, -2.277385499456233e-21,
 -1.928767893059298e-23,  3.796322259327188e-26,  2.496090514930096e-28,  1.046775284470488e+00, -2.825357956873967e-03, -3.580425404257627e-07,  1.505655675208849e-08,
  3.907426816762529e-12, -1.445446751819716e-13, -5.010431681642382e-17,  1.689061276431689e-18,  7.019801375648231e-22, -2.187647167147052e-23, -1.040217702651063e-26,
  3.020042580393008e-28,  1.117808693870231e+00, -2.802400510636377e-03, -1.206630707848987e-06,  1.451249190273618e-08,  1.604095079316967e-11, -1.329613564897737e-13,
 -2.355842335999618e-16,  1.453007057425120e-18,  3.629144402529367e-21, -1.719026561787430e-23, -5.738105735458729e-26,  2.106463152244461e-28,  1.188497778309234e+00,
 -2.750815011685129e-03, -2.024273270547421e-06,  1.322221718892985e-08,  2.697446577196770e-11, -1.052556155307428e-13, -3.854447956585445e-16,  8.975245861975261e-19,
  5.633363765689683e-21, -6.540149823967308e-24, -8.238375010062910e-26,  1.344604874965589e-29,  1.258472239407831e+00, -2.671206757089822e-03, -2.780811343219087e-06,
  1.125507255037297e-08,  3.563537439463344e-11, -6.486972895530550e-14, -4.713178071156293e-16,  1.461435849970564e-19,  6.090626283418945e-21,  6.379110504184629e-24,
 -7.371841435970681e-26, -1.917338799766028e-28,  1.327357561134410e+00, -2.564797324285693e-03, -3.447896451202505e-06,  8.731191302255742e-09,  4.116437675139925e-11,
 -1.727189855351742e-14, -4.767563387558241e-16, -6.229085556402178e-19,  4.850048170531156e-21,  1.685183236743411e-23, -3.487677156626423e-26, -2.987985962523469e-28,
  1.394777150372362e+00, -2.433424933156819e-03, -4.000434472279723e-06,  5.814236947596466e-09,  4.302718491431504e-11,  3.085132453713011e-14, -4.013490025444458e-16,
 -1.223477276505000e-18,  2.306908697044396e-21,  2.104472638481133e-23,  1.649546247275008e-26, -2.538959186919906e-28,  1.460354666970063e+00, -2.279529718289603e-03,
 -4.417959645494837e-06,  2.699902464480326e-09,  4.109171318762363e-11,  7.266853110769169e-14, -2.613542044767328e-16, -1.513344579485238e-18, -7.183157403031807e-22,
  1.763045955877694e-23,  5.699898722332601e-26, -8.759950470710199e-29,  1.523716532013756e+00, -2.106122863545942e-03, -4.685855955036072e-06, -3.991383121234120e-10,
  3.565722330506299e-11,  1.023616954085412e-13, -8.642534186651565e-17, -1.435360854125425e-18, -3.262406448697808e-21,  8.364618521077701e-24,  6.916991989902986e-26,
  1.032279924978964e-28,  1.584494597258591e+00, -1.916738984070317e-03, -4.796342809621354e-06, -3.270707382534723e-09,  2.742747541886029e-11,  1.161523474020763e-13,
  8.701874280003459e-17, -1.034093061933296e-18, -4.562673516848876e-21, -2.707718334330249e-24,  5.018516627145550e-26,  2.143551177338668e-28,  1.642328952489928e+00,
 -1.715371672498716e-03, -4.749147329962389e-06, -5.721538656896592e-09,  1.742748576118004e-11,  1.129849380693261e-13,  2.242768147493804e-16, -4.413345548995905e-19,
 -4.327792002401547e-21, -1.108798093263955e-23,  1.265608532202573e-26,  1.966400769013470e-28,  1.696870841259580e+00, -1.506392744354422e-03, -4.551797316478239e-06,
 -7.594891364870375e-09,  6.872062835616416e-12,  9.470934579866092e-14,  3.005728688461112e-16,  1.659881051754632e-19, -2.824986014461683e-21, -1.383706061960027e-23,
 -2.299165201783483e-26,  8.121334933280065e-29,  1.747785649191105e+00, -1.294456401601004e-03, -4.219487191987436e-06, -8.785530188887451e-09, -2.997432778628339e-12,
  6.569821757903718e-14,  3.067814087576145e-16,  6.221189502580819e-19, -7.452008678905127e-22, -1.077856576071497e-23, -4.006088163460837e-26, -4.828844073859272e-29,
  1.794755923158152e+00, -1.084390253453874e-03, -3.774493380212301e-06, -9.250353728621960e-09, -1.108517823300730e-11,  3.195305708176760e-14,  2.510278499006995e-16,
  8.238656332409629e-19,  1.096983077507871e-21, -4.305400244605829e-24, -3.416479845397362e-26, -1.150494093359799e-28,  1.837484374430122e+00, -8.810758520675559e-04,
 -3.245144483603833e-06, -9.013280372868619e-09, -1.659561235817099e-11, -1.296737351891853e-16,  1.556274101835361e-16,  7.590123635620107e-19,  2.097465044143822e-21,
  2.062065574434443e-24, -1.389171078818114e-26, -9.691543381335552e-29,  1.875696814706799e+00, -6.893220733385213e-04, -2.664383369928006e-06, -8.163529877559513e-09,
 -1.914548613447036e-11, -2.507351943889299e-14,  5.018098908159609e-17,  5.017313586388146e-19,  2.083109420739344e-21,  5.546834988186822e-24,  6.255543548931091e-27,
 -3.036013570347639e-29,  1.909144971259061e+00, -5.137352513998313e-04, -2.067990378810928e-06, -6.847125502177783e-09, -1.881336293630054e-11, -3.942624351653273e-14,
 -3.716136310270463e-17,  1.773487877244792e-19,  1.324398692326016e-21,  5.382389317521677e-24,  1.549398367812927e-26,  2.696984307072032e-29,  1.937609126873219e+00,
 -3.585904091853906e-04, -1.492566421646574e-06, -5.252211938302728e-09, -1.611611670458148e-11, -4.239708363859188e-14, -8.763424645577710e-17, -8.923727537883564e-20,
  3.464192798220039e-22,  2.829269910513540e-24,  1.247902924076448e-26,  4.160404238885229e-29,  1.960900534096463e+00, -2.277081620239482e-04, -9.733987189234619e-07,
 -3.589543122205425e-09, -1.191399740239965e-11, -3.587199330455242e-14, -9.654748219079906e-17, -2.206924873426337e-19, -3.574694538074469e-22,  5.762422059642893e-26,
  3.829298472734683e-27,  2.171659706883309e-29,  1.978863572280678e+00, -1.243418082161106e-04, -5.423472388290714e-07, -2.070135816885124e-09, -7.258368094098024e-12,
 -2.379748804821638e-14, -7.329666001887293e-17, -2.111255938387870e-19, -5.599080002538752e-22, -1.316212167282740e-24, -2.461042674572589e-27, -1.954765085616994e-30,
  1.991377738434013e+00, -5.107821293862344e-05, -2.258920395335014e-07, -8.825025070740487e-10, -3.206845456391398e-12, -1.107874279434505e-14, -3.677373443475834e-17,
 -1.178724107575527e-19, -3.654806733656077e-22, -1.095294694003010e-24, -3.161530830511340e-27, -8.727144593091809e-30,  1.998361249050982e+00, -9.745639719246411e-06,
 -4.343056996552190e-08, -1.718420566557120e-10, -6.365182867978183e-13, -2.259501873760930e-15, -7.782137329890189e-18, -2.619473219745830e-20, -8.656289053520394e-23,
 -2.816737657934316e-25, -9.043292413356960e-28, -2.868484485163196e-30,  5.584542232750274e-04, -2.969775043562555e-06,  1.184145385740760e-08, -4.195541745312314e-11,
  1.392999858704531e-13, -4.437735281029729e-16,  1.373627643075565e-18, -4.162167243822987e-21,  1.240461544356810e-23, -3.648121802776599e-26,  1.061111201396270e-28,
 -3.057580729470158e-31,  5.023219358632751e-03, -2.666003227044875e-05,  1.058734164399578e-07, -3.725670447739663e-10,  1.224245066264261e-12, -3.843306515715726e-15,
  1.166260367893625e-17, -3.443309620961679e-20,  9.927687087815309e-23, -2.800708886779081e-25,  7.736484976383512e-28, -2.091921138192902e-30,  1.393744499718746e-02,
 -7.367893025419379e-05,  2.902285359492102e-07, -1.007284437455709e-09,  3.240354407781455e-12, -9.865282897191357e-15,  2.868631477438872e-17, -7.991486156831877e-20,
  2.130103825041520e-22, -5.400862889053583e-25,  1.286171328194192e-27, -2.801647849785339e-30,  2.727049727438737e-02, -1.433068263263201e-04,  5.575980609675345e-07,
 -1.894664374705707e-09,  5.895680318059685e-12, -1.707869955611176e-14,  4.616154357249360e-17, -1.153774247756162e-19,  2.598843735774788e-22, -4.928732425520290e-25,
  6.057810104939624e-28,  6.277459629459995e-31,  4.497636468459446e-02, -2.344732565936890e-04,  8.972892632557989e-07, -2.961394111499228e-09,  8.790067321768380e-12,
 -2.362905865393530e-14,  5.656995501287122e-17, -1.139096127962807e-19,  1.557740585241606e-22,  8.038503983576427e-26, -1.660369409841057e-27,  8.067167788467137e-30,
  6.699358746008646e-02, -3.457678030411244e-04,  1.295544970887133e-06, -4.116721508664214e-09,  1.145699209842307e-11, -2.754581350176494e-14,  5.303212034740495e-17,
 -5.671470267759532e-20, -1.293076088845547e-22,  1.117991919034223e-24, -4.677106078466287e-27,  1.473872694327921e-29,  9.324516716324675e-02, -4.754546902786755e-04,
  1.735961243287883e-06, -5.258045276893480e-09,  1.341377005288329e-11, -2.708553262981267e-14,  3.118823345733133e-17,  5.855236966439999e-20, -5.427648559543271e-22,
  2.221072751354714e-24, -6.506750259072997e-27,  1.334791233222475e-29,  1.236384597833107e-01, -6.214911950869840e-04,  2.199995770675255e-06, -6.277402338890670e-09,
  1.421577982113414e-11, -2.106288065537710e-14, -9.310474964990732e-18,  2.134834324068184e-19, -9.502983569629291e-22,  2.765607853073991e-24, -5.026091095159335e-27,
 -8.310190603678802e-31,  1.580650565419895e-01, -7.815499614531510e-04,  2.667557442202328e-06, -7.068534726643959e-09,  1.350980343191679e-11, -9.120394348911170e-15,
 -6.404821438714284e-17,  3.703792816111951e-19, -1.170405241166180e-21,  2.162374051611564e-24,  7.281565644199779e-28, -2.484058019404625e-29,  1.964006575812839e-01,
 -9.530453154582815e-04,  3.117665233670407e-06, -7.534172307430957e-09,  1.108136535589439e-11,  8.107094180732714e-15, -1.240629427380602e-16,  4.798378119112424e-19,
 -1.035383482623019e-21,  1.724099017639101e-25,  9.475603400157999e-27, -4.664122605522641e-29,  2.385049447386456e-01, -1.133163666270996e-03,  3.529162121533783e-06,
 -7.593132573654603e-09,  6.891125264643389e-12,  2.896669737544652e-14, -1.771020023800107e-16,  4.932209166462907e-19, -4.611756453220457e-22, -2.857766299784605e-24,
  1.757901343277534e-26, -4.970011082120706e-29,  2.842214607133435e-01, -1.318898059585363e-03,  3.881467161043495e-06, -7.186817679092280e-09,  1.095967717942301e-12,
  5.091754324319629e-14, -2.097819609419698e-16,  3.772614333567389e-19,  4.977822921480552e-22, -5.969598156255160e-24,  2.025145969591257e-26, -2.248309422703521e-29,
  3.333775030937792e-01, -1.507086915983634e-03,  4.155346224769711e-06, -6.284685052995327e-09, -5.948554390477969e-12,  7.081373432757038e-14, -2.103224486167342e-16,
  1.270803172631086e-19,  1.631648576432140e-21, -7.838798470080643e-24,  1.380261456101205e-26,  3.181971497006574e-29,  3.857840429443015e-01, -1.694456936725480e-03,
  4.333679266249525e-06, -4.888284561352365e-09, -1.370634758529266e-11,  8.531517115318856e-14, -1.713643561638084e-16, -2.262839088432802e-19,  2.610278313671177e-21,
 -7.253324144730142e-24, -1.994810794602738e-27,  9.162130210482768e-29,  4.412356789317978e-01, -1.877670091231721e-03,  4.402199470179922e-06, -3.033495439442689e-09,
 -2.149963525323646e-11,  9.137974645719815e-14, -9.229635645431335e-17, -6.168995488019392e-19,  3.069060952832368e-21, -3.670830727192199e-24, -2.265294677545113e-26,
  1.236933303440943e-28,  4.995106392900431e-01, -2.053374512080321e-03,  4.350177432091744e-06, -7.906627078128520e-10, -2.856668637588076e-11,  8.677253417484879e-14,
  1.947135020139787e-17, -9.547937321911106e-19,  2.726238689340909e-21,  2.367478930280373e-24, -3.981347699062479e-26,  9.947620425428549e-29,  5.603708452482196e-01,
 -2.218259013053655e-03,  4.171021773743914e-06,  1.737572844640592e-09, -3.413443249919243e-11,  7.051639026245231e-14,  1.487163267857495e-16, -1.145445342629971e-18,
  1.497429557145932e-21,  9.181026546257061e-24, -4.433600840752441e-26,  1.379419121649502e-29,  6.235620508542848e-01, -2.369110812633436e-03,  3.862766581612769e-06,
  4.420834633778191e-09, -3.749994440109616e-11,  4.320665097032968e-14,  2.742849091901588e-16, -1.114132400260840e-18, -4.331828033891622e-22,  1.436291003050473e-23,
 -3.063971558880975e-26, -1.048463437426808e-28,  6.888140753580783e-01, -2.502875889156020e-03,  3.428416024759249e-06,  7.107895303285106e-09, -3.811299826619777e-11,
  7.122384206565037e-15,  3.725100277653160e-16, -8.292908488156075e-19, -2.618891102615539e-21,  1.559590203147150e-23, -3.868016131749223e-28, -2.011803358016127e-28,
  7.558411454251687e-01, -2.616721215629175e-03,  2.876117758264410e-06,  9.635652155238801e-09, -3.565077162526186e-11, -3.391135425831991e-14,  4.216777127705856e-16,
 -3.182174741664557e-19, -4.447497703785831e-21,  1.161470195679109e-23,  3.656044245358667e-26, -2.179973324444110e-28,  8.243423653594917e-01, -2.708097924548185e-03,
  2.219139548480652e-06,  1.183977532909269e-08, -3.007532057514267e-11, -7.492265215230387e-14,  4.067423093130043e-16,  3.306393618085588e-19, -5.313572289628836e-21,
  2.934209899640453e-24,  6.507597890053709e-26, -1.286003690475762e-28,  8.940023341365719e-01, -2.774804240470191e-03,  1.475628246357137e-06,  1.356642646401729e-08,
 -2.166511855104166e-11, -1.104245340830875e-13,  3.232986762124428e-16,  9.817922488261212e-19, -4.819863827367011e-21, -8.020059610682486e-24,  7.100568891443440e-26,
  4.086186366563948e-29,  9.644919282927106e-01, -2.815046797493451e-03,  6.681370117470138e-07,  1.468427478290223e-08, -1.101372741588278e-11, -1.352069993696288e-13,
  1.798180882625358e-16,  1.482009575747630e-18, -2.941847626957181e-21, -1.755905532327620e-23,  4.821762729211278e-26,  2.152651161931762e-28,  1.035469269471005e+00,
 -2.827498739705584e-03, -1.770843135271342e-07,  1.509589921328736e-08,  1.008349090294768e-12, -1.451778457609623e-13, -2.614930912682476e-18,  1.698869581877240e-18,
 -8.984537633524081e-23, -2.202534841406240e-23,  2.974462570262065e-27,  3.042166251683727e-28,  1.106580894576586e+00, -2.811352797576745e-03, -1.031029584995410e-06,
  1.474758015779783e-08,  1.332854420606571e-11, -1.381146319303836e-13, -1.933702625315295e-16,  1.558813990349940e-18,  2.971328853773117e-21, -1.928764553651218e-23,
 -4.719188263492903e-26,  2.512639934475281e-28,  1.177463144921874e+00, -2.766367357579875e-03, -1.863088188169111e-06,  1.363647403069206e-08,  2.477898656661141e-11,
 -1.141845923650293e-13, -3.578302783026265e-16,  1.073391266013341e-18,  5.338898581851699e-21, -9.806740199063451e-24, -8.052440840521338e-26,  7.125988652367393e-29,
  1.247743788332459e+00, -2.692903414117789e-03, -2.642374276779405e-06,  1.181424657566707e-08,  3.422530964216272e-11, -7.611003692495829e-14, -4.644668120713356e-16,
  3.441330773902473e-19,  6.265269797181056e-21,  3.273416093058100e-24, -8.125832782230779e-26, -1.494663746963681e-28,  1.317043884831973e+00, -2.591950232322829e-03,
 -3.339183804107197e-06,  9.386430528758435e-09,  4.070319748174986e-11, -2.890525988826670e-14, -4.919358232812359e-16, -4.582953401436239e-19,  5.428432733962524e-21,
  1.519379060557475e-23, -4.800621927635860e-26, -2.961602057692899e-28,  1.384979902150099e+00, -2.465137578730677e-03, -3.926514384024947e-06,  6.507073270632092e-09,
  4.354515889488439e-11,  2.081690592401691e-14, -4.344581991277642e-16, -1.137429621043864e-18,  3.073600410757092e-21,  2.146989340775896e-23,  4.494744045102254e-27,
 -2.906755509621918e-28,  1.451166081857133e+00, -2.314732515018995e-03, -4.381569193645604e-06,  3.368641588469195e-09,  4.247891565660341e-11,  6.588555098046456e-14,
 -3.039511529378720e-16, -1.525743939867331e-18, -4.364519444188822e-23,  1.981830532049807e-23,  5.201533194334065e-26, -1.394671428830218e-28,  1.515217050426280e+00,
 -2.143619016271582e-03, -4.687155365525309e-06,  1.876285602551623e-10,  3.768040001584131e-11,  9.979370663678774e-14, -1.280278787542226e-16, -1.534397530672515e-18,
 -2.910470117169943e-21,  1.121258650390736e-23,  7.297333827271780e-26,  6.819579769558627e-29,  1.576750662029382e+00, -1.955259082989629e-03, -4.832881260070721e-06,
 -2.813180070217124e-09,  2.976897594457636e-11,  1.178767675726571e-13,  5.600827442317687e-17, -1.181252340033525e-18, -4.621739184391042e-21, -5.111406193637081e-25,
  5.964365088044255e-26,  2.143212906728626e-28,  1.635391051526659e+00, -1.753634571102659e-03, -4.816057249975678e-06, -5.424333325399786e-09,  1.973992758252343e-11,
  1.182032790080743e-13,  2.099213853719418e-16, -5.860954353780569e-19, -4.715683967945212e-21, -1.040016718536615e-23,  2.194329341278691e-26,  2.252693964128095e-28,
  1.690771867145241e+00, -1.543169661958934e-03, -4.642212513174159e-06, -7.469391526682730e-09,  8.838708932089286e-12,  1.019681850665510e-13,  3.038788336998982e-16,
  6.744846973221179e-20, -3.338725933484169e-21, -1.467563538740352e-23, -1.869117888776578e-26,  1.149713677762680e-28,  1.742539643073289e+00, -1.328634717398153e-03,
 -4.325156635076949e-06, -8.822571486184229e-09, -1.608445411526277e-12,  7.326693901677984e-14,  3.238063280544569e-16,  5.917509087694783e-19, -1.162544202887986e-21,
 -1.241892547295742e-23, -4.183434503785552e-26, -3.142124045136761e-29,  1.790357263033422e+00, -1.115033181908448e-03, -3.886539631108825e-06, -9.422268838263201e-09,
 -1.038398202259133e-11,  3.825835813111255e-14,  2.745622968915754e-16,  8.562154157060069e-19,  9.161532343069501e-22, -5.775048428337004e-24, -3.935832355230279e-26,
 -1.206250522321899e-28,  1.833907457329536e+00, -9.074741582430431e-04, -3.354896435005378e-06, -9.278620617164595e-09, -1.655909434053533e-11,  3.868061243434784e-15,
  1.778297662699745e-16,  8.272031199180515e-19,  2.160625467957263e-21,  1.416236530829849e-24, -1.852278894707492e-26, -1.138060231815027e-28,  1.872896268449707e+00,
 -7.110342349666405e-04, -2.764200018303503e-06, -8.473799068430835e-09, -1.963373544096094e-11, -2.369287527282895e-14,  6.519304775449225e-17,  5.716313060714438e-19,
  2.286945246617117e-21,  5.766758450524590e-24,  4.647458593039162e-27, -4.315785701444593e-29,  1.907056414722135e+00, -5.306130139231228e-04, -2.151988141143567e-06,
 -7.154494189682846e-09, -1.961037878084749e-11, -4.025355463933924e-14, -3.157227082279109e-17,  2.229517131223788e-19,  1.529602658752290e-21,  6.025457717237566e-24,
  1.664667643087214e-26,  2.521224550291859e-29,  1.936150478731131e+00, -3.707874955054718e-04, -1.557168466616393e-06, -5.516968439777996e-09, -1.698528610055694e-11,
 -4.452893897847102e-14, -8.996167429183855e-17, -7.642218974729609e-20,  4.577128646866640e-22,  3.366563299863023e-24,  1.442393824758746e-26,  4.686150889060694e-29,
  1.959973849615681e+00, -2.356709458064004e-04, -1.017641069269264e-06, -3.786034621702037e-09, -1.265511586303052e-11, -3.826457514100447e-14, -1.028864843227805e-16,
 -2.320668101462714e-19, -3.523958313464682e-22,  2.312107169683166e-25,  4.883703333969001e-27,  2.634238781337671e-29,  1.978357367325972e+00, -1.287819637253550e-04,
 -5.679016934966524e-07, -2.190174930231507e-09, -7.752398538152336e-12, -2.562961518124109e-14, -7.946627514692593e-17, -2.298199444622226e-19, -6.090826115000648e-22,
 -1.416183175552815e-24, -2.532325740586950e-27, -1.242207733319092e-30,  1.991169742985406e+00, -5.292859879410061e-05, -2.367973972090723e-07, -9.356337325704826e-10,
 -3.437520331119418e-12, -1.200227645435789e-14, -4.024400346975459e-17, -1.302238598076287e-19, -4.072831278089764e-22, -1.229767355974610e-24, -3.570561768840528e-27,
 -9.888892126057373e-30,  1.998321558293954e+00, -1.010150933229855e-05, -4.555530523910852e-08, -1.823982725791359e-10, -6.836371052612177e-13, -2.455397236563493e-15,
 -8.555945667289271e-18, -2.913422490671293e-20, -9.738587752601095e-23, -3.205037037076375e-25, -1.040580681321736e-27, -3.337301328602626e-30,  5.467614503670650e-04,
 -2.877020046236773e-06,  1.135107445193133e-08, -3.979586906534183e-11,  1.307449729199362e-13, -4.121612826355609e-16,  1.262452483109749e-18, -3.785439147728003e-21,
  1.116455844155103e-23, -3.249394136767117e-26,  9.353672010031383e-29, -2.667496453749157e-31,  4.918245351649221e-03, -2.583060090704216e-05,  1.015176512291867e-07,
 -3.535791661828236e-10,  1.150101683086721e-12, -3.574623669700602e-15,  1.074147884092933e-17, -3.141176007724661e-20,  8.972985526755844e-23, -2.508902979315892e-25,
  6.871899372288043e-28, -1.843486143998352e-30,  1.364729760395629e-02, -7.140458499912023e-05,  2.784458047612888e-07, -9.569805523988071e-10,  3.049756124252913e-12,
 -9.202910106875929e-15,  2.654127377069592e-17, -7.339992653285113e-20,  1.944642751065798e-22, -4.910321638366282e-25,  1.168304222834272e-27, -2.558729073115705e-30,
  2.670604977376669e-02, -1.389354076774472e-04,  5.354169938653003e-07, -1.803006968587270e-09,  5.564928209155498e-12, -1.600866580972176e-14,  4.304477007071176e-17,
 -1.073402957403342e-19,  2.425827612351465e-22, -4.681975479180954e-25,  6.254909287354970e-28,  2.824553871195666e-31,  4.405260654910974e-02, -2.274347339489341e-04,
  8.625810212149208e-07, -2.824460990769825e-09,  8.330807511728471e-12, -2.230908785212799e-14,  5.345062019390250e-17, -1.088906886864656e-19,  1.575543967479888e-22,
  2.067671842363120e-26, -1.334399789677905e-27,  6.782542449386465e-30,  6.563093644146731e-02, -3.355979710276539e-04,  1.247226226300877e-06, -3.937748359237164e-09,
  1.091867264503428e-11, -2.629253040102793e-14,  5.139197920597953e-17, -6.024345184661609e-20, -9.227571522969718e-23,  9.433759418973418e-25, -4.065840462952446e-27,
  1.307083867442547e-29,  9.137072926752796e-02, -4.618157788633646e-04,  1.674134678617894e-06, -5.047717448774471e-09,  1.287966753696993e-11, -2.631923195420500e-14,
  3.259621008017312e-17,  4.241414061447576e-20, -4.673508220410480e-22,  1.972407389513193e-24, -5.930323865857703e-27,  1.282633892979942e-29,  1.211872232692779e-01,
 -6.041887096263512e-04,  2.126017722049568e-06, -6.053330091812552e-09,  1.379275450061054e-11, -2.121794729314374e-14, -3.743981891074032e-18,  1.846280448696176e-19,
 -8.543576270742224e-22,  2.564532003836952e-24, -5.011498204936459e-27,  1.395402389042594e-30,  1.549810055754376e-01, -7.605451313042941e-04,  2.584025686065161e-06,
 -6.853917202909062e-09,  1.331284242696184e-11, -1.053726416191239e-14, -5.419020511654404e-17,  3.341754201436723e-19, -1.092284478908341e-21,  2.171214672051231e-24,
 -2.485742369538793e-28, -1.968380286211392e-29,  1.926377906362884e-01, -9.284626084341705e-04,  3.028323816015293e-06, -7.355730603948650e-09,  1.121480108970977e-11,
  5.287073366066203e-15, -1.110899039225041e-16,  4.468740902082309e-19, -1.022833061376264e-21,  5.121224190903232e-25,  7.552363155396798e-27, -4.082941736485614e-29,
  2.340281822918102e-01, -1.105292922724031e-03,  3.438724461371620e-06, -7.478466174561065e-09,  7.429064352109797e-12,  2.488021362111786e-14, -1.635129466899935e-16,
  4.769486900398977e-19, -5.519199922106870e-22, -2.197740330874319e-24,  1.543862963774883e-26, -4.746042061186030e-29,  2.790074262721086e-01, -1.288190915807045e-03,
  3.795363291140689e-06, -7.161405322939354e-09,  2.064835021218715e-12,  4.601114296999621e-14, -1.990268388789333e-16,  3.899062823003082e-19,  2.972040223553614e-22,
 -5.180986093713045e-24,  1.914149961670273e-26, -2.765636760516327e-29,  3.274151611888061e-01, -1.474147323213364e-03,  4.079404795128846e-06, -6.368804673571828e-09,
 -4.582439473599980e-12,  6.581433771182751e-14, -2.060748703708914e-16,  1.748869792486129e-19,  1.359690906386565e-21, -7.262641458899114e-24,  1.491124985881542e-26,
  1.891473735736909e-29,  3.790751774619260e-01, -1.660025740163727e-03,  4.273759620830972e-06, -5.094161141955330e-09, -1.204163706397368e-11,  8.113559234322241e-14,
 -1.765702214063023e-16, -1.469407098405947e-19,  2.348651738291128e-21, -7.257115462631883e-24,  1.691902013219638e-27,  7.606580561588819e-29,  4.337951951389858e-01,
 -1.842603813065236e-03,  4.363793465125466e-06, -3.362994873356100e-09, -1.969553376329627e-11,  8.896832528029347e-14, -1.082156569294587e-16, -5.209683792433449e-19,
  2.921889995747080e-21, -4.470607043692047e-24, -1.740160101007137e-26,  1.146799842232372e-28,  4.913666731947078e-01, -2.018618682557447e-03,  4.338004405418286e-06,
 -1.233829605094096e-09, -2.682867679771783e-11,  8.692896194222256e-14, -6.030847661305566e-18, -8.664890929439813e-19,  2.783876793481210e-21,  8.645827732377659e-25,
 -3.528707609406608e-26,  1.055615430164447e-28,  5.515646646351354e-01, -2.184816611541693e-03,  4.188642881802495e-06,  1.202887669754012e-09, -3.269098141007984e-11,
  7.370642037343706e-14,  1.173619620960889e-16, -1.092579981665712e-18,  1.796236008593916e-21,  7.426818175719326e-24, -4.320677103270745e-26,  3.680879000723292e-29,
  6.141477335419594e-01, -2.338006611957891e-03,  3.912246248489230e-06,  3.828095626349768e-09, -3.657251595516564e-11,  4.941404301337366e-14,  2.429711322445996e-16,
 -1.119966214344300e-18,  6.079490084370357e-23,  1.305441086710959e-23, -3.455606030780762e-26, -7.339598761112127e-29,  6.788579520407021e-01, -2.475117734776852e-03,
  3.510058172853887e-06,  6.499704606991194e-09, -3.788307574917892e-11,  1.577503149125618e-14,  3.482009061403136e-16, -9.041320354854634e-19, -2.059790857694194e-21,
  1.540998981190862e-23, -8.738757086366061e-27, -1.778543777441667e-28,  7.454209970029738e-01, -2.593259507258493e-03,  2.988302500761104e-06,  9.060360546567213e-09,
 -3.622859921669670e-11, -2.391369639820496e-14,  4.108399065929688e-16, -4.535839090476839e-19, -4.005365281179436e-21,  1.288443302979377e-23,  2.691886825876236e-26,
 -2.190038808370082e-28,  8.135463680222897e-01, -2.689784789854022e-03,  2.358281898555167e-06,  1.134711577094843e-08, -3.147550439523874e-11, -6.506884050042695e-14,
  4.136391258128116e-16,  1.627858915310967e-19, -5.162537431555070e-21,  5.414548562186165e-24,  5.871815322317244e-26, -1.591804635994884e-28,  8.829277497378532e-01,
 -2.762354084002494e-03,  1.636274022742042e-06,  1.320254725309871e-08, -2.379388197967781e-11, -1.023531593959658e-13,  3.485900799041297e-16,  8.234878705476182e-19,
 -5.057159592941317e-21, -5.158238156530105e-24,  7.173323401195352e-26, -7.457946005570877e-30,  9.532435428015855e-01, -2.809000055865730e-03,  8.432025523151986e-07,
  1.448667041713643e-08, -1.367140727027949e-11, -1.304046180847598e-13,  2.199041368716431e-16,  1.378146514427239e-18, -3.537079432487219e-21, -1.545255279608219e-23,
  5.680902069606500e-26,  1.743147630134121e-28,  1.024157588547847e+00, -2.828190757392851e-03,  4.067494277786126e-09,  1.508881709156424e-08, -1.891987155098201e-12,
 -1.446708399877173e-13,  4.479428039683224e-17,  1.683356982948161e-18, -8.774051642676297e-22, -2.164043476888145e-23,  1.620786475725929e-26,  2.955254056260301e-28,
  1.095320112568417e+00, -2.818889736543152e-03, -8.528710143160951e-07,  1.493850139403554e-08,  1.052343085452882e-11, -1.422216664678246e-13, -1.484991693404006e-16,
  1.642444753536610e-18,  2.245753475142103e-21, -2.094405434964856e-23, -3.539359880087021e-26,  2.834992094014946e-28,  1.166368911735119e+00, -2.780610948987398e-03,
 -1.697148561648856e-06,  1.401421223191422e-08,  2.241194821256717e-11, -1.223929023876638e-13, -3.254409618772915e-16,  1.237972846413644e-18,  4.928789655626066e-21,
 -1.294792627045530e-23, -7.611420387430124e-26,  1.289799339051070e-28,  1.236930807555359e+00, -2.713466134816464e-03, -2.497369872742562e-06,  1.234907194422289e-08,
  3.259253482734857e-11, -8.711887032903373e-14, -4.520110721085642e-16,  5.458678706553520e-19,  6.323151834603948e-21, -9.405605494609548e-26, -8.674480089569624e-26,
 -9.862627339499411e-29,  1.306623385897363e+00, -2.618202130944471e-03, -3.222660297269480e-06,  1.003241135908872e-08,  4.000609181353135e-11, -4.084558614029040e-14,
 -5.022567151648561e-16, -2.762297841921128e-19,  5.937732877255623e-21,  1.301623354651553e-23, -6.076837255879845e-26, -2.819741393042491e-28,  1.375057038900958e+00,
 -2.496225482094615e-03, -3.844237294602469e-06,  7.206549365185952e-09,  4.385470782773359e-11,  1.001956171636908e-14, -4.648129608085281e-16, -1.026698640594447e-18,
  3.846583757255482e-21,  2.138447161771348e-23, -8.985163504568112e-27, -3.207534203999325e-28,  1.441837319147326e+00, -2.349611722007986e-03, -4.337025357782745e-06,
  4.058435055487681e-09,  4.372022004536081e-11,  5.807858880324129e-14, -3.465814908766515e-16, -1.515336633100918e-18,  7.056418486854671e-22,  2.176034062905421e-23,
  4.469156836915355e-26, -1.936477463081010e-28,  1.506567608802920e+00, -2.181096853427580e-03, -4.681221221701832e-06,  8.063002133839470e-10,  3.964201470971735e-11,
  9.619534896523496e-14, -1.722301707942258e-16, -1.620505623453372e-18, -2.453663652838778e-21,  1.417926154546960e-23,  7.504107113945387e-26,  2.435616062518322e-29,
  1.568852097463617e+00, -1.994048888961972e-03, -4.863703595427777e-06, -2.317954683749085e-09,  3.213718781979185e-11,  1.188073530782613e-13,  2.086329261829821e-17,
 -1.328963612843165e-18, -4.594939530275889e-21,  2.061394161459120e-24,  6.892210175924939e-26,  2.059249260355435e-28,  1.628299051896132e+00, -1.792417846423306e-03,
 -4.879175331954046e-06, -5.089314112730821e-09,  2.215295545960876e-11,  1.230270728718284e-13,  1.913431234825196e-16, -7.427985469293737e-19, -5.071828974219863e-21,
 -9.316211362506472e-24,  3.244691007445651e-26,  2.516590409890715e-28,  1.684524349025092e+00, -1.580663331160392e-03, -4.730928111632678e-06, -7.311260597554681e-09,
  1.095109204300884e-11,  1.092713738558087e-13,  3.041912488034191e-16, -4.797768267666269e-20, -3.879188932918962e-21, -1.531124901686769e-23, -1.281382122587113e-26,
  1.528122387365835e-28,  1.737155230714776e+00, -1.363659777270580e-03, -4.431132164534200e-06, -8.836156106640319e-09, -6.407454227668410e-14,  8.123249072554990e-14,
  3.397850060291741e-16,  5.470708926422023e-19, -1.640023434367789e-21, -1.411371282566156e-23, -4.273962691099302e-26, -8.700971806561713e-30,  1.785834225671459e+00,
 -1.146580531785168e-03, -4.000577286764879e-06, -9.581924975885384e-09, -9.550961746658227e-12,  4.513865122354104e-14,  2.989132838744808e-16,  8.818915970088161e-19,
  6.786245261131063e-22, -7.456569460948054e-24, -4.473754503512086e-26, -1.233290523303202e-28,  1.830223170829443e+00, -9.347632001606741e-04, -3.467826229537901e-06,
 -9.542707330712479e-09, -1.643713731682402e-11,  8.421770452878050e-15,  2.019660007525999e-16,  8.970057842772732e-19,  2.197019172767103e-21,  5.699324902168133e-25,
 -2.392403415473060e-26, -1.318713135277643e-28,  1.870007252714712e+00, -7.335599532776176e-04, -2.867785792416439e-06, -8.791639090617574e-09, -2.009060659834732e-11,
 -2.192771140236383e-14,  8.225471851624991e-17,  6.481671137598482e-19,  2.497397725348318e-21,  5.910315986292056e-24,  2.417327116967818e-27, -5.869054257290816e-29,
  1.904898979503249e+00, -5.481777302383371e-04, -2.239751362445395e-06, -7.474739764537340e-09, -2.042249211149854e-11, -4.093064124195427e-14, -2.461082251731174e-17,
  2.755002964593056e-19,  1.758764720384367e-21,  6.712678861052685e-24,  1.769082378064469e-26,  2.197099095840636e-29,  1.934641988151492e+00, -3.835143461709602e-04,
 -1.625032446370223e-06, -5.795975653934972e-09, -1.789761996370826e-11, -4.671192585938236e-14, -9.187740267286319e-17, -5.972075494780444e-20,  5.898060468610751e-22,
  3.986383100378297e-24,  1.660778870891092e-26,  5.245321907381133e-29,  1.959014590899358e+00, -2.439973052587806e-04, -1.064314071156109e-06, -3.994775203597953e-09,
 -1.344563299745518e-11, -4.081309037953929e-14, -1.095406946492894e-16, -2.431702386559031e-19, -3.402626653068022e-22,  4.512882187229589e-25,  6.160120319189541e-27,
  3.182950701277159e-29,  1.977832983561535e+00, -1.334324539636603e-04, -5.949452802054530e-07, -2.318419897414259e-09, -8.284595564438237e-12, -2.761627553804633e-14,
 -8.618190690599203e-17, -2.501459500961629e-19, -6.618992061363283e-22, -1.518296071915936e-24, -2.565965683698953e-27, -2.312443883104792e-31,  1.990954167379213e+00,
 -5.486884198713841e-05, -2.483630988971661e-07, -9.926081670426979e-10, -3.687527557307703e-12, -1.301340240428438e-14, -4.407959144863071e-17, -1.439937039418137e-19,
 -4.542338141894482e-22, -1.381667174206672e-24, -4.033997321852596e-27, -1.120288038255305e-29,  1.998280409241942e+00, -1.047489664668083e-05, -4.781137114804850e-08,
 -1.937407706070843e-10, -7.348664196324206e-13, -2.670892135204842e-15, -9.417126386081415e-18, -3.244351283491866e-20, -1.097100259924516e-22, -3.652196666175922e-25,
 -1.199235193504919e-27, -3.889185951631250e-30,  5.354320122806565e-04, -2.788086705669489e-06,  1.088580874995220e-08, -3.776828439045912e-11,  1.227963546359631e-13,
 -3.830950151697198e-16,  1.161291070304566e-18, -3.446190019685289e-21,  1.005938860971470e-23, -2.897693404731869e-26,  8.255905832385890e-29, -2.330424715392738e-31,
  4.816520793012441e-03, -2.503512401341512e-05,  9.738279631369395e-08, -3.357357654597179e-10,  1.081117564877864e-12, -3.327066225546875e-15,  9.900827639338264e-18,
 -2.867976707377493e-20,  8.117363869421488e-23, -2.249588610763812e-25,  6.109652145551268e-28, -1.626034318717248e-30,  1.336606281925681e-02, -6.922213786086345e-05,
  2.672488510308268e-07, -9.096229965291529e-10,  2.871904922780255e-12, -8.589894745485241e-15,  2.457060140502770e-17, -6.745110108330813e-20,  1.776017824949608e-22,
 -4.464839332153046e-25,  1.060753155300901e-27, -2.332752658942304e-30,  2.615873989173346e-02, -1.347371263740507e-04,  5.143047566974291e-07, -1.716474379686070e-09,
  5.254846657915448e-12, -1.501079588910488e-14,  4.014541952444134e-17, -9.984248118179843e-20,  2.261802264954493e-22, -4.430130677767865e-25,  6.317904104942723e-28,
  1.549237329086111e-32,  4.315645740550502e-02, -2.206674273892134e-04,  8.294727458164680e-07, -2.694668851413970e-09,  7.897209885449841e-12, -2.106229018861325e-14,
  5.047230701802879e-17, -1.038467763888569e-19,  1.574068312579333e-22, -2.706656874079472e-26, -1.060761888403112e-27,  5.684118547959556e-30,  6.430820504872722e-02,
 -3.258062427916546e-04,  1.201004300992962e-06, -3.767189965769568e-09,  1.040501788459024e-11, -2.507966808329567e-14,  4.966871118014462e-17, -6.268318115640672e-20,
 -6.110717040125889e-23,  7.917868999448563e-25, -3.524673637624637e-27,  1.155195630360170e-29,  8.954987357380503e-02, -4.486615283295860e-04,  1.614781285341338e-06,
 -4.845810965634645e-09,  1.236119372226728e-11, -2.552429770113154e-14,  3.358478745302393e-17,  2.855033182711229e-20, -4.004796503795578e-22,  1.746296385192510e-24,
 -5.380011836237843e-27,  1.217007532709376e-29,  1.188040299151056e-01, -5.874674083396321e-04,  2.054687850391185e-06, -5.836044070365237e-09,  1.336790012623711e-11,
 -2.124877326567475e-14,  1.056455418766465e-18,  1.587272350277548e-19, -7.656230615135608e-22,  2.365830407152345e-24, -4.911367665868855e-27,  3.073895082392556e-30,
  1.519796536539455e-01, -7.401983092086042e-04,  2.503049537532995e-06, -6.642665239156769e-09,  1.308982929783557e-11, -1.172942372996661e-14, -4.531090927494210e-17,
  3.004694052910477e-19, -1.014496055073086e-21,  2.145301218092676e-24, -1.014943671806130e-27, -1.526787172394740e-29,  1.889718386640009e-01, -9.045860354330918e-04,
  2.941134701361609e-06, -7.175588528071575e-09,  1.129487545542782e-11,  2.767385836452712e-15, -9.903249118762278e-17,  4.144933034871967e-19, -9.993769654786669e-22,
  7.799228102818318e-25,  5.877450280158043e-27, -3.536671442553781e-29,  2.296614647297697e-01, -1.078140036248897e-03,  3.349711800034987e-06, -7.355829027879789e-09,
  7.888496627646138e-12,  2.111409297300880e-14, -1.504167113775797e-16,  4.581365013154957e-19, -6.204187705842159e-22, -1.621147195849477e-24,  1.341214285728026e-26,
 -4.456490716938279e-29,  2.739148450377356e-01, -1.258171127029014e-03,  3.709654188276520e-06, -7.121261981635547e-09,  2.938180588604793e-12,  4.136641492014438e-14,
 -1.880033156523122e-16,  3.965778855804018e-19,  1.241666844602124e-22, -4.440788086288013e-24,  1.784350774491960e-26, -3.107877067574897e-29,  3.215833567135659e-01,
 -1.441818935599660e-03,  4.002581796614584e-06, -6.431860382419589e-09, -3.315189644737623e-12,  6.093198205792716e-14, -2.006073696987137e-16,  2.143303465812110e-19,
  1.109141784646643e-21, -6.652889804518442e-24,  1.549720568387144e-26,  8.048905627120187e-30,  3.725030630356726e-01, -1.626083336433312e-03,  4.211526490166558e-06,
 -5.274077136940072e-09, -1.046159246234972e-11,  7.685678689913603e-14, -1.796715110761267e-16, -7.594460956871455e-20,  2.089380140185259e-21, -7.126904275243999e-24,
  4.711470117739209e-27,  6.135360684089558e-29,  4.264943376085801e-01, -1.807860111992143e-03,  4.321605004297581e-06, -3.664034366222843e-09, -1.794326661512471e-11,
  8.620651642061527e-14, -1.215188612548041e-16, -4.301676192522386e-19,  2.749607605581970e-21, -5.068786963076093e-24, -1.258488129592599e-26,  1.040514113340916e-28,
  4.833615026357950e-01, -1.983981036494522e-03,  4.320680222722636e-06, -1.649195731765970e-09, -2.509345804718687e-11,  8.650316700764683e-14, -2.904257562565652e-17,
 -7.771703087921439e-19,  2.790722998463790e-21, -4.531211329098185e-25, -3.058294877439240e-26,  1.076544085512303e-28,  5.428924954901013e-01, -2.151258508849173e-03,
  4.199988313466334e-06,  6.917677529929698e-10, -3.119112952986754e-11,  7.616273098458231e-14,  8.761227227113302e-17, -1.031152617652320e-18,  2.032936212142885e-21,
  5.736730393177674e-24, -4.116228778095541e-26,  5.539064030470840e-29,  6.048585800270794e-01, -2.306534763989354e-03,  3.954706044941087e-06,  3.251147799648782e-09,
 -3.552845916290089e-11,  5.486968593124240e-14,  2.117080289085022e-16, -1.110773992039775e-18,  5.051761502453618e-22,  1.161645777655223e-23, -3.712587662566286e-26,
 -4.379063423588476e-29,  6.690141214980858e-01, -2.446735560884737e-03,  3.584429711360683e-06,  5.896544719223833e-09, -3.748609380147683e-11,  2.382112648614935e-14,
  3.220452542735770e-16, -9.612515095313954e-19, -1.513140530827238e-21,  1.491149309354341e-23, -1.599457343849640e-26, -1.515820228633519e-28,  7.350964464460055e-01,
 -2.568928077015816e-03,  3.093534821729472e-06,  8.477407929780715e-09, -3.660937330337683e-11, -1.421999068216243e-14,  3.964162568210544e-16, -5.741451296604831e-19,
 -3.524455253333465e-21,  1.376978823293789e-23,  1.739386998265287e-26, -2.128442434483372e-28,  8.028258115414796e-01, -2.670382529839719e-03,  2.491384444592784e-06,
  1.083363728789522e-08, -3.267733427194759e-11, -5.510527718809922e-14,  4.159167678192157e-16,  1.142628615846026e-21, -4.927092300182749e-21,  7.615866129488764e-24,
  5.118030376063811e-26, -1.821634277025370e-28,  8.719055078415978e-01, -2.748636794074276e-03,  1.792354317092644e-06,  1.280593070598741e-08, -2.575551104223371e-11,
 -9.372874405862522e-14,  3.693581568362298e-16,  6.592399362956624e-19, -5.191411899263837e-21, -2.309103582538230e-24,  7.039271587654776e-26, -5.284769554441219e-29,
  9.420221292971852e-01, -2.801562990177776e-03,  1.015645039330389e-06,  1.424736280033346e-08, -1.622366522673245e-11, -1.246771496271181e-13,  2.568272082978141e-16,
  1.256512087855132e-18, -4.050739736909161e-21, -1.303995740375433e-23,  6.348808255596582e-26,  1.286728045486487e-28,  1.012846036332414e+00, -2.827434688279621e-03,
  1.848564186963682e-07,  1.503547233373433e-08, -4.770854907238389e-12, -1.430340567581824e-13,  9.141911841340713e-17,  1.642965407010309e-18, -1.641700708650781e-21,
 -2.073695816505381e-23,  2.882649901187372e-26,  2.763922552556733e-28,  1.084032046766617e+00, -2.824993011574402e-03, -6.726931987306742e-07,  1.508394295131689e-08,
  7.647121767887191e-12, -1.452263702895527e-13, -1.016197724064903e-16,  1.701996703128311e-18,  1.469358436331889e-21, -2.210298827355754e-23, -2.239044788798952e-26,
  3.058139865093132e-28,  1.155220386999826e+00, -2.793509547978097e-03, -1.526908588854090e-06,  1.435280826434805e-08,  1.988888226235160e-11, -1.297701555076700e-13,
 -2.886438187406668e-16,  1.387660600572578e-18,  4.409380386721615e-21, -1.586250192003112e-23, -6.921312686487228e-26,  1.840587941757842e-28,  1.226037935963753e+00,
 -2.732843609398259e-03, -2.346111518628841e-06,  1.285602966751421e-08,  3.074303085775696e-11, -9.776088720111307e-14, -4.338993275189797e-16,  7.474773776480705e-19,
  6.256413736369313e-21, -3.634075805298655e-24, -8.983532161150400e-26, -4.087592878665009e-29,  1.296099792547203e+00, -2.643491042272295e-03, -3.098459862009166e-06,
  1.066531635351933e-08,  3.906812472860723e-11, -5.297067406399708e-14, -5.072640842779633e-16, -7.921798850226739e-20,  6.359634762869024e-21,  1.034420608748059e-23,
 -7.264181838451532e-26, -2.557260121756068e-28,  1.365011193728886e+00, -2.526621526357016e-03, -3.753544026812247e-06,  7.909212189355676e-09,  4.394129029119629e-11,
 -1.466302677881363e-15, -4.917221770183475e-16, -8.913879044047843e-19,  4.606489700823033e-21,  2.073586116255062e-23, -2.359945019698076e-26, -3.418768122538865e-28,
  1.432369805195802e+00, -2.384101142815918e-03, -4.284090167370104e-06,  4.766784837446981e-09,  4.479519178231160e-11,  4.925476725516873e-14, -3.885746635270721e-16,
 -1.479894747281544e-18,  1.518992245248540e-21,  2.336152875934007e-23,  3.497173917110754e-26, -2.479917817017134e-28,  1.497768398541856e+00, -2.218496993482373e-03,
 -4.667677266822278e-06,  1.455723535836086e-09,  4.152086736425080e-11,  9.150895493568038e-14, -2.186226932828785e-16, -1.690275066495822e-18, -1.889056047008369e-21,
  1.718754321758890e-23,  7.499228598117864e-26, -2.790276667654276e-29,  1.560797919064601e+00, -2.033060857535220e-03, -4.888355415908793e-06, -1.784736245999934e-09,
  3.451524247354044e-11,  1.188450130532403e-13, -1.839117032832131e-17, -1.474264774375631e-18, -4.468962345990657e-21,  4.994894179626231e-24,  7.762056589853693e-26,
  1.877359741606999e-28,  1.621050935672534e+00, -1.831689321966716e-03, -4.938038431605685e-06, -4.714940387556119e-09,  2.465763853656397e-11,  1.273510873953510e-13,
  1.682240788577362e-16, -9.101906410584333e-19, -5.381118422179751e-21, -7.789935004993449e-24,  4.403000012047004e-26,  2.740189987084830e-28,  1.678125449622301e+00,
 -1.618858549198819e-03, -4.817538531826433e-06, -7.118163755327873e-09,  1.320934193910276e-11,  1.165413036671325e-13,  3.010265069489895e-16, -1.810160694032101e-19,
 -4.437891207900878e-21, -1.567739702622093e-23, -5.192798645842711e-27,  1.940931346329293e-28,  1.731629022085039e+00, -1.399532861130801e-03, -4.537117126313986e-06,
 -8.823735925859608e-09,  1.643331746476363e-12,  8.956473508059558e-14,  3.542895227146596e-16,  4.861304220560039e-19, -2.178908816226081e-21, -1.582283305437127e-23,
 -4.250314080215406e-26,  2.058680248764507e-29,  1.781183162507562e+00, -1.179047609154732e-03, -4.116446201644803e-06, -9.727119960257188e-09, -8.574437820137171e-12,
  5.261107887322801e-14,  3.238673935670000e-16,  8.989566059984843e-19,  3.766689895208359e-22, -9.354564213378815e-24, -5.015339339912268e-26, -1.221014594583417e-28,
  1.826427901270595e+00, -9.629683162950774e-04, -3.583910247538600e-06, -9.804081998244181e-09, -1.621815454509485e-11,  1.357830490371567e-14,  2.280681276484533e-16,
  9.674423072680482e-19,  2.198863011983721e-21, -5.085824642501398e-25, -3.013901893373438e-26, -1.507139937237288e-28,  1.867026452406532e+00, -7.569297355402492e-04,
 -2.975228267326144e-06, -9.116483634317618e-09, -2.050790214328096e-11, -1.972658628036571e-14,  1.015543207923015e-16,  7.315014843313691e-19,  2.711239910402087e-21,
  5.950120481211491e-24, -5.625288559225488e-28, -7.728946532109836e-29,  1.902669856555766e+00, -5.664601459740339e-04, -2.331435909593792e-06, -7.808077893343671e-09,
 -2.124635286580990e-11, -4.142214497078034e-14, -1.607157433173197e-17,  3.357856559197557e-19,  2.013379391326570e-21,  7.438283455303447e-24,  1.855189193438135e-26,
  1.681207064767288e-29,  1.933081482786236e+00, -3.967977525091144e-04, -1.696333545152464e-06, -6.089931818051955e-09, -1.885403290215260e-11, -4.893477965794530e-14,
 -9.326283565841443e-17, -3.841797664810983e-20,  7.458451444864761e-22,  4.698556901668627e-24,  1.904339938212390e-26,  5.828589971281135e-29,  1.958021263804173e+00,
 -2.527072872254860e-04, -1.113569560084763e-06, -4.216580603991093e-09, -1.428874237057327e-11, -4.352498585940078e-14, -1.164991011848865e-16, -2.537482982566632e-19,
 -3.192269402531879e-22,  7.275346020364760e-25,  7.699421940244435e-27,  3.831565916117777e-29,  1.977289555183723e+00, -1.383055964892453e-04, -6.235802375347208e-07,
 -2.455506836841672e-09, -8.858184650340110e-12, -2.977113498346854e-14, -9.349088260940979e-17, -2.722210702619018e-19, -7.184044121361598e-22, -1.620758917298558e-24,
 -2.547033619013392e-27,  1.163065611458950e-30,  1.990730641320893e+00, -5.690441513857115e-05, -2.606371784029690e-07, -1.053749633101966e-09, -3.958709972946964e-12,
 -1.412138409057565e-14, -4.832261722922257e-17, -1.593571580327600e-19, -5.070009419440847e-22, -1.553309387548697e-24, -4.558918017390697e-27, -1.268665466248887e-29,
  1.998237729661474e+00, -1.086689119762139e-05, -5.020861099981766e-08, -2.059385721540811e-10, -7.906200576029510e-13, -2.908213388389874e-15, -1.037673940366445e-17,
 -3.617420386336157e-20, -1.237642841115195e-22, -4.167953338431068e-25, -1.384286056086046e-27, -4.539999639638846e-30,  5.244510144066396e-04, -2.702780285338383e-06,
  1.044412976180180e-08, -3.586335576058491e-11,  1.154055322114809e-13, -3.563465161682131e-16,  1.069151963221011e-18, -3.140362460631391e-21,  9.073271835883785e-24,
 -2.587075768049665e-26,  7.296213608844730e-29, -2.038730182569925e-31,  4.717913314367363e-03, -2.427188787026524e-05,  9.345559963828119e-08, -3.189575721832721e-10,
  1.016888879110480e-12, -3.098796557862437e-15,  9.132975308293822e-18, -2.620720672970907e-20,  7.349830268126747e-23, -2.018932631237308e-25,  5.437017018224231e-28,
 -1.435541662663876e-30,  1.309338220393784e-02, -6.712704064993086e-05,  2.566035106736187e-07, -8.650154916275017e-10,  2.705854250159183e-12, -8.022236237649390e-15,
  2.275917704184835e-17, -6.201702676041418e-20,  1.622679403402002e-22, -4.060438610892432e-25,  9.627736669041039e-28, -2.123608287434657e-30,  2.562789179849379e-02,
 -1.307036722533629e-04,  4.942017893072321e-07, -1.634747146847671e-09,  4.964043363028985e-12, -1.408004958854384e-14,  3.744879596820879e-17, -9.285501462166426e-20,
  2.106862186624943e-22, -4.177918675253433e-25,  6.277890300594292e-28, -1.879836468651825e-31,  4.228685745590099e-02, -2.141588730784070e-04,  7.978811611553619e-07,
 -2.571618622183963e-09,  7.487844847643112e-12, -1.988527933527622e-14,  4.763491341865361e-17, -9.883306539190354e-20,  1.557263301621703e-22, -6.478174285102727e-26,
 -8.318187535655901e-28,  4.747120350092859e-30,  6.302391378573274e-02, -3.163762410404830e-04,  1.156780558700981e-06, -3.604658258901404e-09,  9.915201814482324e-12,
 -2.390887613805400e-14,  4.789030288320943e-17, -6.420878265293560e-20, -3.502190513799013e-23,  6.605508960797956e-25, -3.047135008378264e-27,  1.017768709285654e-29,
  8.778070037532641e-02, -4.359725532396693e-04,  1.557801524858247e-06, -4.652071712672609e-09,  1.185882562639735e-11, -2.471006139560288e-14,  3.421394270530583e-17,
  1.670035076685103e-20, -3.413594725142376e-22,  1.541592075093193e-24, -4.860608749393055e-27,  1.142856646494147e-29,  1.164865968387153e-01, -5.713064318649277e-04,
  1.985924624242116e-06, -5.625554632180591e-09,  1.294352422466605e-11, -2.117277712924133e-14,  5.170354071364038e-18,  1.355523881440614e-19, -6.839531439578480e-22,
  2.172471458868828e-24, -4.747659277709353e-27,  4.299990059634281e-30,  1.490584093696755e-01, -7.204892186049123e-04,  2.424586253121684e-06, -6.435160968233307e-09,
  1.284502901242005e-11, -1.271952520019817e-14, -3.734071291903892e-17,  2.692321452781454e-19, -9.381473334619109e-22,  2.092415881051245e-24, -1.602070276474362e-27,
 -1.152493696126026e-29,  1.854000116745069e-01, -8.813983104786715e-04,  2.856113365855927e-06, -6.994552996111037e-09,  1.132737688448834e-11,  5.262895427166588e-16,
 -8.786987231261074e-17,  3.830048976996603e-19, -9.674291318086447e-22,  9.854161075092012e-25,  4.434004640474988e-27, -3.031598263828134e-29,  2.254019440004849e-01,
 -1.051693245130294e-03,  3.262212459136305e-06, -7.226426649910887e-09,  8.275705719918994e-12,  1.765573201220460e-14, -1.378748943314734e-16,  4.374490827437486e-19,
 -6.695872582267134e-22, -1.122925282525056e-24,  1.152315507909360e-26, -4.124492473076161e-29,  2.689409749898976e-01, -1.228834853609843e-03,  3.624507627872439e-06,
 -7.067873840498953e-09,  3.721289241199330e-12,  3.698789164032579e-14, -1.768665753219847e-16,  3.981283604361770e-19, -2.319022905769204e-23, -3.755070630026018e-24,
  1.642812256628041e-26, -3.303854425371579e-29,  3.158796323054707e-01, -1.410107821329202e-03,  3.925120587305045e-06, -6.475413781827004e-09, -2.144189866910440e-12,
  5.619321382795510e-14, -1.941443737658450e-16,  2.461109822057808e-19,  8.808556752886888e-22, -6.028683043587588e-24,  1.564810372363815e-26, -8.818823908162588e-31,
  3.660657094187679e-01, -1.592647010470611e-03,  4.147283216538927e-06, -5.429400412172506e-09, -8.967712083925123e-12,  7.252647280032433e-14, -1.809001999572031e-16,
 -1.314813534640509e-20,  1.836817072193547e-21, -6.888540917008054e-24,  7.107775415755033e-27,  4.777453550470654e-29,  4.193317576552911e-01, -1.773467896191076e-03,
  4.275970410549335e-06, -3.937495968541552e-09, -1.624922577634348e-11,  8.315529814792276e-14, -1.323598044489442e-16, -3.451881976013853e-19,  2.559142994967832e-21,
 -5.483980392015728e-24, -8.259328398463617e-27,  9.245310563859392e-29,  4.754945745716155e-01, -1.949501450325685e-03,  4.298537851604010e-06, -2.036895642700503e-09,
 -2.337207548837680e-11,  8.555508393884214e-14, -4.955718229987889e-17, -6.883550105548430e-19,  2.753531494906961e-21, -1.581856171223070e-24, -2.586317800426385e-26,
  1.063774059480412e-28,  5.343547020181819e-01, -2.117633765015120e-03,  4.205345789045212e-06,  2.050002818907173e-10, -2.964914785866288e-11,  7.792648892554689e-14,
  5.967956498295016e-17, -9.631070328716867e-19,  2.210450496223038e-21,  4.143476561543476e-24, -3.839693763727203e-26,  6.960015528113921e-29,  5.956959498242999e-01,
 -2.274750639133171e-03,  3.990346165900921e-06,  2.691737133204728e-09, -3.438276370988033e-11,  5.957966135928854e-14,  1.808934815018236e-16, -1.088207164272882e-18,
  8.962482283567439e-22,  1.010103776900845e-23, -3.844865100158747e-26, -1.682389714365303e-29,  6.592849639237859e-01, -2.417787246374174e-03,  3.651606640021789e-06,
  5.300989302402773e-09, -3.693458671896771e-11,  3.122225185254916e-14,  2.945320725303770e-16, -1.001219025173404e-18, -9.893763364924791e-22,  1.414645199637059e-23,
 -2.205423385450479e-26, -1.236956587094754e-28,  7.248708608957928e-01, -2.543782858894884e-03,  3.191741490844404e-06,  7.889893995977330e-09, -3.679999928183593e-11,
 -4.911195323369886e-15,  3.788366114883826e-16, -6.788801526629461e-19, -3.018447715099883e-21,  1.428146060027517e-23,  8.279745703742807e-27, -2.005059652248382e-28,
  7.921849542755779e-01, -2.649940408165690e-03,  2.618216454572357e-06,  1.030252514438004e-08, -3.367970815224827e-11, -4.514044013667596e-14,  4.137853657508221e-16,
 -1.517584635771878e-19, -4.618049724808533e-21,  9.497749903766461e-24,  4.280367139355636e-26, -1.972978246943858e-28,  8.609406015111374e-01, -2.733690419671356e-03,
  1.943492672035584e-06,  1.237933351073659e-08, -2.754004208228397e-11, -8.466147332896289e-14,  3.854824700344672e-16,  4.923228463172079e-19, -5.224530797708101e-21,
  4.477024315293201e-25,  6.715008445350882e-26, -9.367359785640909e-29,  9.308332039797478e-01, -2.792758556560787e-03,  1.184974751030240e-06,  1.396818240853426e-08,
 -1.865279739610400e-11, -1.181061720205543e-13,  2.901277975035301e-16,  1.119877762399635e-18, -4.473230366821554e-21, -1.040128996567579e-23,  6.809349025990617e-26,
  8.040437992633154e-29,  1.001540395860313e+00, -2.825235648490640e-03,  3.647301107675810e-07,  1.493638794214460e-08, -7.605902784838612e-12, -1.402945791863546e-13,
  1.365761616521878e-16,  1.578732371751909e-18, -2.364614883401680e-21, -1.934844757850992e-23,  4.039053265803661e-26,  2.477882551841042e-28,  1.072722460653279e+00,
 -2.829648669409670e-03, -4.910479937896743e-07,  1.518294445730138e-08,  4.722090064249718e-12, -1.470888014919877e-13, -5.342629212045469e-17,  1.736138581708969e-18,
  6.608118962476935e-22, -2.272533183095003e-23, -8.644112306822305e-27,  3.171491566814535e-28,  1.144023016458192e+00, -2.805030671745565e-03, -1.352852387747601e-06,
  1.464990425456862e-08,  1.722743194509597e-11, -1.362159552206225e-13, -2.479034806054023e-16,  1.519106402403495e-18,  3.790587339418854e-21, -1.845390572891930e-23,
 -5.999323560812937e-26,  2.339747489211509e-28,  1.215070012404943e+00, -2.750987202254424e-03, -2.188954166213323e-06,  1.333171813577284e-08,  2.868548887018574e-11,
 -1.079008412169918e-13, -4.101917148211760e-16,  9.448934228349474e-19,  6.060636749796391e-21, -7.245323709986277e-24, -9.027147630517815e-26,  2.163688052792579e-29,
  1.285477078474955e+00, -2.667756244268488e-03, -2.966762630176799e-06,  1.128126923274360e-08,  3.788690843496068e-11, -6.514830938546257e-14, -5.065812114619742e-16,
  1.296663888824350e-19,  6.677105518656083e-21,  7.223893909623429e-24, -8.309524023813111e-26, -2.174926540901175e-28,  1.354845268884374e+00, -2.556258290790999e-03,
 -3.654418183912498e-06,  8.611388842298190e-09,  4.379201823437478e-11, -1.354980168461229e-14, -5.145065790358031e-16, -7.322482348423931e-19,  5.332327403759993e-21,
  1.948719548772881e-23, -3.890756127599309e-26, -3.519716856003193e-28,  1.422765234753336e+00, -2.418132802684784e-03, -4.222557582337862e-06,  5.490867987627594e-09,
  4.568370452482921e-11,  3.943800957597328e-14, -4.292029787110395e-16, -1.417583052287308e-18,  2.382415087850828e-21,  2.452660107091214e-23,  2.290291668644815e-26,
 -2.999781431370818e-28,  1.488819854491612e+00, -2.255757106050230e-03, -4.646163152924164e-06,  2.134397555673216e-09,  4.329471067130769e-11,  8.568783939471756e-14,
 -2.666995645674698e-16, -1.740249308832721e-18, -1.216760586552737e-21,  2.014559450492133e-23,  7.247495229925352e-26, -8.764860677521348e-29,  1.552587339799587e+00,
 -2.072243799638588e-03, -4.906380466602397e-06, -1.213515469813066e-09,  3.688430248959858e-11,  1.178923001993014e-13, -6.164128314090229e-17, -1.613779570983149e-18,
 -4.231337793494261e-21,  8.257163927639834e-24,  8.528034292352854e-26,  1.585347882548124e-28,  1.613644821159778e+00, -1.871413044726087e-03, -4.992165845186256e-06,
 -4.299831651072483e-09,  2.724286813524389e-11,  1.310629367266156e-13,  1.402884023499527e-16, -1.086509611194235e-18, -5.626899573075235e-21, -5.782289678200305e-24,
  5.647116060462230e-26,  2.903075146362830e-28,  1.671572399137688e+00, -1.657736756689352e-03, -4.901610216686024e-06, -6.887777155824129e-09,  1.561191867755168e-11,
  1.236885485213958e-13,  2.938848503377663e-16, -3.320813936326358e-19, -5.003842504171386e-21, -1.570157760030112e-23,  4.302188998806949e-27,  2.377888021433666e-28,
  1.725957626976900e+00, -1.436252751317204e-03, -4.642783576043495e-06, -8.782645787410226e-09,  3.520715481850346e-12,  9.822260650621049e-14,  3.668370640333769e-16,
  4.069656353849899e-19, -2.778822918630468e-21, -1.749465166456401e-23, -4.082242198930222e-26,  5.702783952459983e-29,  1.776400366486956e+00, -1.212448330017852e-03,
 -4.233958672437023e-06, -9.855462291229991e-09, -7.442443567145353e-12,  6.068698250176150e-14,  3.491534784144031e-16,  9.052241715379599e-19,  2.512040829627732e-24,
 -1.146668965068876e-23, -5.540655975520141e-26, -1.157200945804133e-28,  1.822517934133152e+00, -9.921145829318164e-04, -3.703106223804025e-06, -1.006109318854357e-08,
 -1.588961694801805e-11,  1.938492610769950e-14,  2.561371148030159e-16,  1.037266999919206e-18,  2.157204671727355e-21, -1.852383697545382e-24, -3.718973852250038e-26,
 -1.697438399149330e-28,  1.863950429045898e+00, -7.811747601314327e-04, -3.086607400667260e-06, -9.447626752772227e-09, -2.087635028010067e-11, -1.703349664099356e-14,
  1.232831285995542e-16,  8.216770692852673e-19,  2.924163529388453e-21,  5.853392154654733e-24, -4.433871683563579e-27, -9.925926594465516e-29,  1.900366111341636e+00,
 -5.854922630790493e-04, -2.427199891634260e-06, -8.154664708843778e-09, -2.207785268644757e-11, -4.168750581327163e-14, -5.726297109304852e-18,  4.046427968101661e-19,
  2.294675001237336e-21,  8.193114269702264e-24,  1.913439111930984e-26,  9.215443674021891e-30,  1.931466680265647e+00, -4.106659410671494e-04, -1.771255405902535e-06,
 -6.399547839132615e-09, -1.985518408670881e-11, -5.118313750279779e-14, -9.397789407435984e-17, -1.169242754984174e-20,  9.293383805024743e-22,  5.513328609121254e-24,
  2.173838612373196e-26,  6.421388953780299e-29,  1.956992291506825e+00, -2.618221932701158e-04, -1.165569471832876e-06, -4.452318830605685e-09, -1.518778322819396e-11,
 -4.640735163086344e-14, -1.237426862877503e-16, -2.634816357274215e-19, -2.870663079642379e-22,  1.071388301594498e-24,  9.548873721385826e-27,  4.595365143845173e-29,
  1.976726165433228e+00, -1.434145582011548e-04, -6.539167563528738e-07, -2.602125723933819e-09, -9.476676216095290e-12, -3.210903480895518e-14, -1.014438287627255e-16,
 -2.961631015061419e-19, -7.785686443221550e-22, -1.721101894827223e-24, -2.456408719227132e-27,  3.047071589780835e-30,  1.990498771831543e+00, -5.904119119885762e-05,
 -2.736717386118987e-07, -1.119412977554355e-09, -4.253106203691690e-12, -1.533655717971949e-14, -5.302041797225230e-17, -1.765122094232763e-19, -5.663413559910171e-22,
 -1.747308205060361e-24, -5.153198962554489e-27, -1.435873568723484e-29,  1.998193442798037e+00, -1.127866469587815e-05, -5.275773760412118e-08, -2.190676910974673e-10,
 -8.513591590854308e-13, -3.169871454491181e-15, -1.144739772440666e-17, -4.038582530104947e-20, -1.398157040702874e-22, -4.763789831707489e-25, -1.600493538456571e-27,
 -5.308849369684307e-30,  5.138043173392750e-04, -2.620917830750631e-06,  1.002461767087448e-08, -3.407251783043456e-11,  1.085282419986875e-13, -3.317100627392765e-16,
  9.851505440735157e-19, -2.864373130541491e-21,  8.192366040060718e-24, -2.312397755524355e-26,  6.456092368997800e-29, -1.785937909334383e-31,  4.622297196076349e-03,
 -2.353928107686440e-05,  8.972372280605983e-08, -3.031714929626199e-10,  9.570467696570330e-13, -2.888151570775779e-15,  8.431037338006959e-18, -2.396747466570894e-20,
  6.660685296133234e-23, -1.813577176124580e-25,  4.842916734761607e-28, -1.268523535550775e-30,  1.282891497954236e-02, -6.511500931965621e-05,  2.464778866528041e-07,
 -8.229762834721090e-10,  2.550734049380677e-12, -7.496280194134851e-15,  2.109325077012163e-17, -5.705108059873335e-20,  1.483215689467452e-22, -3.693437869473096e-25,
  8.736338418131303e-28, -1.930855940498368e-30,  2.511286197569669e-02, -1.268271966709018e-04,  4.750522346761620e-07, -1.557527298193050e-09,  4.691223366077144e-12,
 -1.321172965346252e-14,  3.494101634039812e-17, -8.634887633614034e-20,  1.960952815790492e-22, -3.928938869109235e-25,  6.160024817784672e-28, -3.402051492362345e-31,
  4.144279545513560e-02, -2.078972546159222e-04,  7.677276451735187e-07, -2.454933564177843e-09,  7.101350387030727e-12, -1.877468859143753e-14,  4.493695889484249e-17,
 -9.389316499423686e-20,  1.528433761804349e-22, -9.412118615767927e-26, -6.409594210016540e-28,  3.949650813266000e-30,  6.177664711651384e-02, -3.072923591712170e-04,
  1.114460939723657e-06, -3.449778614369505e-09,  9.448371774651191e-12, -2.278118850623525e-14,  4.608017930479869e-17, -6.497167680547469e-20, -1.333150572110500e-23,
  5.472481836871728e-25, -2.627005710092172e-27,  8.941153526305480e-30,  8.606138593395136e-02, -4.237302521511726e-04,  1.503098947827840e-06, -4.466239360068664e-09,
  1.137286745460109e-11, -2.388449984661674e-14,  3.453670468109521e-17,  6.628250669181102e-21, -2.892426949351849e-22,  1.356995119361505e-24, -4.374984223406912e-27,
  1.064021763042108e-29,  1.142327232910373e-01, -5.556855729873351e-04,  1.919646598209057e-06, -5.421837899908742e-09,  1.252160452007379e-11, -2.100554523950038e-14,
  8.670908263014159e-18,  1.148809662640963e-19, -6.091143284607753e-22,  1.986625443097116e-24, -4.538411109848285e-27,  5.156552146334599e-30,  1.462147617096902e-01,
 -7.013979420960714e-04,  2.348588898532554e-06, -6.231721817411514e-09,  1.258227011739435e-11, -1.352856351373271e-14, -3.021127233566232e-17,  2.404033608913595e-19,
 -8.640871965327041e-22,  2.019156682225350e-24, -2.038028934263636e-27, -8.385060954201579e-30,  1.819195890102696e-01, -8.588820609757500e-04,  2.773266144084418e-06,
 -6.813341758245027e-09,  1.131766462513087e-11, -1.457362031249844e-15, -7.757358100794336e-17,  3.526464702880494e-19, -9.290704399761670e-22,  1.137486524314915e-24,
  3.203053170588493e-27, -2.571155001984288e-29,  2.212468204226911e-01, -1.025940137255310e-03,  3.176300888759142e-06, -7.091366109625669e-09,  8.596709859592092e-12,
  1.449126195326547e-14, -1.259317584002018e-16,  4.154609562770878e-19, -7.021438554727076e-22, -6.972594506016458e-25,  9.786056010079414e-27, -3.768855043797251e-29,
  2.640830920403265e-01, -1.200176983598547e-03,  3.540074060826756e-06, -7.002641996873907e-09,  4.419501103905902e-12,  3.287666066067769e-14, -1.657488052586235e-16,
  3.953473143930589e-19, -1.468977691168064e-22, -3.127323043696689e-24,  1.495370769759009e-26, -3.380431063977522e-29,  3.103015101052882e-01, -1.379018175931183e-03,
  3.847246053685457e-06, -6.500980671992838e-09, -1.066346434185378e-12,  5.161943109820191e-14, -1.868904099922120e-16,  2.709464341608540e-19,  6.750598729218738e-22,
 -5.405761461331392e-24,  1.544597049244725e-26, -8.024938476659912e-30,  3.597610619737296e-01, -1.559731686468265e-03,  4.081316614521691e-06, -5.561515472316756e-09,
 -7.560595134340137e-12,  6.818686507744467e-14, -1.804823205583401e-16,  4.172097121978358e-20,  1.594419855945129e-21, -6.565896753971734e-24,  8.935136114429601e-27,
  3.551569720695985e-29,  4.123059962729109e-01, -1.739453427243528e-03,  4.227214848077877e-06, -4.184354452505437e-09, -1.461862200979623e-11,  7.987174896219429e-14,
 -1.409086667638475e-16, -2.665104101250237e-19,  2.356721308517881e-21, -5.736518045309729e-24, -4.455127541961562e-27,  8.043653853270036e-29,  4.677651817678773e-01,
 -1.915217146116166e-03,  4.271907624194707e-06, -2.397231034398156e-09, -2.167437751307804e-11,  8.414432151835402e-14, -6.760747224719939e-17, -6.013437168864837e-19,
  2.679082396497614e-21, -2.523774787615694e-24, -2.126203916824716e-26,  1.023662717367162e-28,  5.259514568422415e-01, -2.083989104348506e-03,  4.205011133100121e-06,
 -2.568490467806756e-10, -2.807843745563895e-11,  7.904331489389406e-14,  3.372319669845451e-17, -8.902762084895639e-19,  2.332738028706054e-21,  2.672099165044249e-24,
 -3.509869313804816e-26,  7.966145332518685e-29,  5.866609842967282e-01, -2.242707926492865e-03,  4.019386324696887e-06,  2.151371247536752e-09, -3.315020596481409e-11,
  6.355903350279142e-14,  1.508777444841634e-16, -1.054006856612964e-18,  1.232090529079386e-21,  8.555528455668025e-24, -3.865368266821490e-26,  6.941658757362003e-30,
  6.496726294024898e-01, -2.388329942069535e-03,  3.711694615929672e-06,  4.715405955012889e-09, -3.624174126485826e-11,  3.795149864203237e-14,  2.661299867517990e-16,
 -1.024911117244023e-18, -4.972189009770864e-22,  1.316376415790673e-23, -2.687405991478569e-26, -9.541541819174272e-29,  7.147473828189715e-01, -2.517880225944502e-03,
  3.282885759563582e-06,  7.300795565953395e-09, -3.680889648760831e-11,  3.942341835736962e-15,  3.585533510402345e-16, -7.671974147850111e-19, -2.500436871651222e-21,
  1.444099420453688e-23, -1.763918141041122e-28, -1.831332848898501e-28,  7.816278540790357e-01, -2.628509381319056e-03,  2.738585454799490e-06,  9.756965178625396e-09,
 -3.448363757518385e-11, -3.527695374666190e-14,  4.075209010126705e-16, -2.937520607923276e-19, -4.247430074870186e-21,  1.103354405039723e-23,  3.393209957441172e-26,
 -2.047106895744362e-28,  8.500378658036543e-01, -2.717555886575744e-03,  2.089346593818959e-06,  1.192565401822578e-08, -2.913973667385437e-11, -7.526333226053698e-14,
  3.969329889292750e-16,  3.259054218937319e-19, -5.161157466913926e-21,  3.040521324911821e-24,  6.223614784943302e-26, -1.286306833202505e-28,  9.196821835351845e-01,
 -2.782613536369512e-03,  1.350725575229330e-06,  1.365122935530190e-08, -2.094283527732945e-11, -1.107833281920394e-13,  3.194278595749616e-16,  9.712749875134403e-19,
 -4.797927978842634e-21, -7.621189595712037e-24,  7.055586206816194e-26,  3.160358802619453e-29,  9.902464209133373e-01, -2.821603141805557e-03,  5.431446225593248e-07,
  1.479243932780307e-08, -1.037548240355283e-11, -1.364954796188781e-13,  1.796189504537660e-16,  1.492252526554724e-18, -3.029542733968543e-21, -1.752503410267300e-23,
  5.051293577127143e-26,  2.111293493603584e-28,  1.061397164629565e+00, -2.832847211562948e-03, -3.084965986947720e-07,  1.523491058353576e-08,  1.771438421532394e-12,
 -1.477860580877315e-13, -4.641674945734030e-18,  1.744155397435052e-18, -1.601520496330376e-22, -2.279121193363931e-23,  5.348951170906015e-27,  3.169914665604718e-28,
  1.132782367865529e+00, -2.815145818657555e-03, -1.175490612809641e-06,  1.490344004718966e-08,  1.444712951361984e-11, -1.416421421360723e-13, -2.037733722196737e-16,
  1.629333532190793e-18,  3.085653022619648e-21, -2.063463650429434e-23, -4.873419165551409e-26,  2.763833094314249e-28,  1.204032064334517e+00, -2.767851278098814e-03,
 -2.026292663337035e-06,  1.377289631944051e-08,  2.643128120049908e-11, -1.174063087772030e-13, -3.810636975936978e-16,  1.133966593188625e-18,  5.735211770385360e-21,
 -1.081815692446609e-23, -8.789835802866270e-26,  8.637373252195837e-29,  1.274759457084879e+00, -2.690938642456920e-03, -2.827795389432526e-06,  1.187637712795998e-08,
  3.646278255633699e-11, -7.723832922832688e-14, -4.999247916029654e-16,  3.468353249056860e-19,  6.875154981149809e-21,  3.722479386466470e-24, -9.161486058693216e-26,
 -1.680011348620409e-28,  1.344562436279270e+00, -2.585068403156679e-03, -3.546888618393584e-06,  9.309215633286446e-09,  4.339598224245790e-11, -2.612407655997514e-14,
 -5.325174993251205e-16, -5.507198216302244e-19,  6.002117251665416e-21,  1.762096822156338e-23, -5.438448329673190e-26, -3.492991235687107e-28,  1.413025577544162e+00,
 -2.451637219469218e-03, -4.152257351197156e-06,  6.227544330977738e-09,  4.636628892866142e-11,  2.867026651330718e-14, -4.676941374526002e-16, -1.327068315886069e-18,
  3.278551253065632e-21,  2.516447991445302e-23,  8.649593824401767e-27, -3.468095848221521e-28,  1.479722666465119e+00, -2.292812056126154e-03, -4.616338708035397e-06,
  2.840458566930899e-09,  4.494049285531277e-11,  7.869861619023188e-14, -3.158586862030130e-16, -1.767030949908282e-18, -4.404386918701258e-22,  2.294849119576461e-23,
  6.719111497286236e-26, -1.533489221617958e-28,  1.544219784685467e+00, -2.111542880986988e-03, -4.917324253287948e-06, -6.045998768850003e-10,  3.922361671064892e-11,
  1.158556774808707e-13, -1.086732930254787e-16, -1.743754899702699e-18, -3.871097461206412e-21,  1.179667739642572e-23,  9.139610141094239e-26,  1.174441967653101e-28,
  1.606078978265489e+00, -1.911549152995356e-03, -5.041061444690254e-06, -3.842803466896038e-09,  2.989522596960664e-11,  1.340442681515402e-13,  1.073172423301277e-16,
 -1.269439859957275e-18, -5.791295574123273e-21, -3.264941243479108e-24,  6.945469373402068e-26,  2.982930771735871e-28,  1.664862509122364e+00, -1.697275814805094e-03,
 -4.982681931987547e-06, -6.617816556992985e-09,  1.815537312927860e-11,  1.306115910981315e-13,  2.822602321197364e-16, -5.011939991090345e-19, -5.563360691001552e-21,
 -1.530710432575792e-23,  1.574688249576129e-26,  2.824363707676460e-28,  1.720137665506065e+00, -1.473815476864057e-03, -4.747770950231789e-06, -8.710116681156674e-09,
  5.574077064681654e-12,  1.071527951983496e-13,  3.768902932406916e-16,  3.076568724464738e-19, -3.437305981271886e-21, -1.906497598228168e-23, -3.737357077499507e-26,
  1.009955788238339e-28,  1.771482078080489e+00, -1.246794990686968e-03, -4.352897142745367e-06, -9.964367562107528e-09, -6.142855661996074e-12,  6.937043342502350e-14,
  3.744357165296370e-16,  8.982622319526114e-19, -4.513796826372094e-22, -1.378151020960277e-23, -6.024066235149052e-26, -1.028169435538224e-28,  1.818489455398790e+00,
 -1.022226655486435e-03, -3.825350842001860e-06, -1.031188145450877e-08, -1.543805298295597e-11,  2.588846677685100e-14,  2.861348602327437e-16,  1.104928532694539e-18,
  2.061892143352713e-21, -3.494840896496840e-24, -4.506720048923585e-26, -1.881353699040210e-28,  1.860775618218039e+00, -8.063268085950233e-04, -3.201993750850438e-06,
 -9.784204940436819e-09, -2.118551323061538e-11, -1.378785101995858e-14,  1.476314947361490e-16,  9.185786544354400e-19,  3.130575064317174e-21,  5.581426942486987e-24,
 -9.350737624389990e-27, -1.248473637628867e-28,  1.897984678775061e+00, -6.053073546878569e-04, -2.527202869047345e-06, -8.514583814824438e-09, -2.291201532547416e-11,
 -4.168040158579745e-14,  6.677113665125205e-18,  4.829399728643594e-19,  2.603475705360364e-21,  8.963709613504681e-24,  1.931790055725369e-26, -1.433289168763001e-30,
  1.929795182321284e+00, -4.251486418155681e-04, -1.849990255631182e-06, -6.725542682138468e-09, -2.090140988175536e-11, -5.343898559456759e-14, -9.385787131717722e-17,
  2.139552841664367e-20,  1.144166526862132e-21,  6.441099614410215e-24,  2.469250571852532e-26,  7.002258576800395e-29,  1.955926009319519e+00, -2.713646630257358e-04,
 -1.220486483428825e-06, -4.702912425518123e-09, -1.614623128541038e-11, -4.946670558824043e-14, -1.312424302301268e-16, -2.719728158679105e-19, -2.411109461012720e-22,
  1.496317097645114e-24,  1.176277991391952e-26,  5.491034077753811e-29,  1.976141843066277e+00, -1.487734216220286e-04, -6.860736542458695e-07, -2.759025142576561e-09,
 -1.014388992437248e-11, -3.464607072707844e-14, -1.100946424464374e-16, -3.220873138355436e-19, -8.422584428895903e-22, -1.815989388641960e-24, -2.269729564977168e-27,
  5.553542275233312e-30,  1.990258141579040e+00, -6.128547754481366e-05, -2.875233433058718e-07, -1.189987382585914e-09, -4.572973413000970e-12, -1.667046277973183e-14,
 -5.822622814140544e-17, -1.956826326806090e-19, -6.331118811603603e-22, -1.966609341855443e-24, -5.825544500360678e-27, -1.623820969462076e-29,  1.998147467032909e+00,
 -1.171147833270849e-05, -5.547042191839510e-08, -2.332119382584587e-10, -9.175982404465965e-13, -3.458700510374829e-15, -1.264350724303653e-17, -4.514714999390478e-20,
 -1.581763160447539e-22, -5.453272245367009e-25, -1.853542755799499e-27, -6.218795798077168e-30,  5.034784914081002e-04, -2.542327346544023e-06,  9.625951327529399e-09,
 -3.238788167773284e-11,  1.021241303747603e-13, -3.090000072075115e-16,  9.084965958397984e-19, -2.615053384075660e-21,  7.404554161765690e-24, -2.069202028261168e-26,
  5.719667489214618e-29, -1.566547980633049e-31,  4.529552972107042e-03, -2.283578752903488e-05,  8.617567019988368e-08, -2.883100787398933e-10,  9.012540485974821e-13,
 -2.693624797439016e-15,  7.788832445880107e-18, -2.193688516632685e-20,  6.041362166616298e-23, -1.630578226441639e-25,  4.317702371713961e-28, -1.121960871505519e-30,
  1.257233700693383e-02, -6.318200650668070e-05,  2.368421818117195e-07, -7.833369715461601e-10,  2.405744154395493e-12, -7.008687056716873e-15,  1.956031682578152e-17,
 -5.251095093066411e-20,  1.356342207589226e-22, -3.360443669174914e-25,  7.926263967380225e-28, -1.753831007949163e-30,  2.461303742801468e-02, -1.231002838808889e-04,
  4.568036901745118e-07, -1.484536847444900e-09,  4.435182387464103e-12, -1.240146230316986e-14,  3.260900587187349e-17, -8.029541011481130e-20,  1.823906889802269e-22,
 -3.685885343563807e-25,  5.984574396293171e-28, -4.512338724086201e-31,  4.062330619381209e-02, -2.018713668595276e-04,  7.389379681412801e-07, -2.344258194326901e-09,
  6.736431378071917e-12, -1.772720029932498e-14,  4.237588135205356e-17, -8.906101161956034e-20,  1.490335012479550e-22, -1.164913157553398e-25, -4.824773317296014e-28,
  3.272457872835049e-30,  6.056505045469913e-02, -2.985397253098837e-04,  1.073955797408216e-06, -3.302190186753770e-09,  9.003659717324455e-12, -2.169712539578366e-14,
  4.425782131377256e-17, -6.510260123292703e-20,  4.569730497663856e-24,  4.497011980011912e-25, -2.258406937844904e-27,  7.833906219750444e-30,  8.439017939400599e-02,
 -4.119167826494916e-04,  1.450580253024153e-06, -4.288049920057225e-09,  1.090347608151982e-11, -2.305439378966236e-14,  3.459982346528772e-17, -1.878759676172924e-21,
 -2.434301849745885e-22,  1.191122390615146e-24, -3.924523945483820e-27,  9.834377508603374e-30,  1.120402880512789e-01, -5.405852743941259e-04,  1.855772793304852e-06,
 -5.224840753087157e-09,  1.210382407606794e-11, -2.076098115226190e-14,  1.162519654889368e-17,  9.649902265254184e-20, -5.408070798173841e-22,  1.809810513515746e-24,
 -4.298277129920037e-27,  5.714707147375633e-30,  1.434462785569960e-01, -6.829049519858041e-04,  2.275007084310467e-06, -6.032607227914086e-09,  1.230497751143264e-11,
 -1.417591647407769e-14, -2.385627773084557e-17,  2.138991984196895e-19, -7.929464704945209e-22,  1.931060132210403e-24, -2.347826300327731e-27, -5.779116503692622e-30,
  1.785279195529532e-01, -8.370198966786624e-04,  2.692591258288358e-06, -6.632590160871953e-09,  1.127068232840052e-11, -3.203959612103613e-15, -6.810938346770711e-17,
  3.235939988510775e-19, -8.860758986490762e-22,  1.244236071423648e-24,  2.164619326483141e-27, -2.156568802389162e-29,  2.171933450729226e-01, -1.000867756434143e-03,
  3.092038822583710e-06, -6.951660455734137e-09,  8.857240531585097e-12,  1.160593510904620e-14, -1.146166654876776e-16,  3.926631001902682e-19, -7.205891437121977e-22,
 -3.379127198949322e-25,  8.207830504468215e-27, -3.404507025284448e-29,  2.593384948513409e-01, -1.172191267236540e-03,  3.456487637701269e-06, -6.926882097090199e-09,
  5.038148079699766e-12,  2.903089487776493e-14, -1.547610095367365e-16,  3.889577793616887e-19, -2.490733654641770e-22, -2.558929475448099e-24,  1.346733895622384e-26,
 -3.361989272375423e-29,  3.048464989558810e-01, -1.348552467729009e-03,  3.769165202911931e-06, -6.510024189993122e-09, -7.818513617814039e-14,  4.722736470364888e-14,
 -1.790298933725821e-16,  2.895530775129422e-19,  4.914724347130036e-22, -4.796722946518657e-24,  1.496570275115474e-26, -1.355460742083955e-29,  3.535870108499677e-01,
 -1.527350060659267e-03,  4.013896854023512e-06, -5.671809946861875e-09, -6.240050087645322e-12,  6.387485718274194e-14, -1.786348593901335e-16,  8.903228672605869e-20,
  1.364827291640039e-21, -6.180532497571373e-24,  1.025413433953505e-26,  2.467737071809772e-29,  4.054154945355614e-01, -1.705840413538514e-03,  4.175651320522235e-06,
 -4.405659056044426e-09, -1.305556632745944e-11,  7.640872348461495e-14, -1.473463992947701e-16, -1.944272457966644e-19,  2.147819639763716e-21, -5.847481297149892e-24,
 -1.180333937249821e-27,  6.845613090888256e-29,  4.601724733607501e-01, -1.881162720344062e-03,  4.241115345993866e-06, -2.730651694941106e-09, -2.000903103382927e-11,
  8.232928865452606e-14, -8.325964578557228e-17, -5.172222046535057e-19,  2.573988366886372e-21, -3.285844141929426e-24, -1.688611975734363e-26,  9.623939902130737e-29,
  5.176827504590418e-01, -2.050368860982856e-03,  4.199285702787380e-06, -6.934214632657150e-10, -2.649145280033026e-11,  7.956205335872600e-14,  9.853099426642458e-18,
 -8.143534372856351e-19,  2.404526905381148e-21,  1.340358217025122e-24, -3.144280713042864e-26,  8.592199754950408e-29,  5.777546136754097e-01, -2.210458489092942e-03,
  4.042062918948282e-06,  1.631324191588662e-09, -3.184518092944747e-11,  6.683068225011334e-14,  1.219617093976824e-16, -1.009949407173677e-18,  1.512389579568342e-21,
  7.021706107624806e-24, -3.789014356596533e-26,  2.716242561480606e-29,  6.401790412809263e-01, -2.358419843517504e-03,  3.764826425624800e-06,  4.141947584093087e-09,
 -3.542117205513595e-11,  4.399288051290600e-14,  2.372794394052391e-16, -1.033454980866501e-18, -4.360963839632370e-23,  1.201304367267341e-23, -3.046077674922855e-26,
 -6.780647042413204e-29,  7.047289288248753e-01, -2.491276704707549e-03,  3.366965748432670e-06,  6.712944090175663e-09, -3.664578154152763e-11,  1.228128228239600e-14,
  3.360296831076218e-16, -8.389101505358765e-19, -1.982575826268186e-21,  1.427878185449526e-23, -7.779796623654242e-27, -1.619499118863439e-28,  7.711583621423088e-01,
 -2.606141793084949e-03,  2.852337038018767e-06,  9.200111004026254e-09, -3.509211564936972e-11, -2.561013557370803e-14,  3.974544735335095e-16, -4.230702069817529e-19,
 -3.827968043000812e-21,  1.221013290732325e-23,  2.489632971572757e-26, -2.048616114405297e-28,  8.392019668163243e-01, -2.700276719464097e-03,  2.229609037834968e-06,
  1.144789646721702e-08, -3.054909620910065e-11, -6.564598101640851e-14,  4.037659562057175e-16,  1.629685790339123e-19, -5.008333746713756e-21,  5.407967915924285e-24,
  5.593105254027857e-26, -1.567862409681385e-28,  9.085743702317460e-01, -2.771158334849657e-03,  1.512458072079714e-06,  1.329884412363166e-08, -2.307972697156119e-11,
 -1.028082944595882e-13,  3.444367365947801e-16,  8.138980512072966e-19, -5.021284133163006e-21, -4.785245561286340e-24,  7.089643144034117e-26, -1.572322254440063e-29,
  9.789698186297445e-01, -2.816550975750255e-03,  7.195685582021308e-07,  1.460484055754741e-08, -1.305895805676323e-11, -1.316947513597550e-13,  2.199528224888903e-16,
  1.385620144630632e-18, -3.621946645313076e-21, -1.533097265033124e-23,  5.887712059381111e-26,  1.681844767882118e-28,  1.050061998075059e+00, -2.834583651405018e-03,
 -1.256051266859091e-07,  1.523961836049342e-08, -1.181447200259588e-12, -1.473127571601537e-13,  4.400003377922783e-17,  1.725971229680744e-18, -9.734452305795093e-22,
 -2.230089653018196e-23,  1.908235551609484e-26,  3.054048099010572e-28,  1.121504114664305e+00, -2.823830665763170e-03, -9.953567095165711e-07,  1.511168135926623e-08,
  1.156913109494228e-11, -1.459747885218958e-13, -1.568838768207575e-16,  1.715837075310591e-18,  2.310744525587455e-21, -2.233035777918267e-23, -3.581221688305731e-26,
  3.092627543189817e-28,  1.192929295189959e+00, -2.783393512704558e-03, -1.858559571900969e-06,  1.417652606580926e-08,  2.399437713865466e-11, -1.261504701290601e-13,
 -3.468065952377686e-16,  1.310592110607882e-18,  5.283560638153725e-21, -1.423905750024961e-23, -8.267902603999944e-26,  1.505347344267849e-28,  1.263951374235092e+00,
 -2.712981143212792e-03, -2.681831515649669e-06,  1.244677536473377e-08,  3.479894955945756e-11, -8.909502879887972e-14, -4.871183083768674e-16,  5.682637003236498e-19,
  6.941571967943838e-21, -7.314095761849836e-26, -9.773362999004791e-26, -1.086478882158621e-28,  1.334166136555129e+00, -2.612984910290762e-03, -3.431031521112588e-06,
  9.998672249071380e-09,  4.274456207668284e-11, -3.906726435515537e-14, -5.451565075488540e-16, -3.489520908292598e-19,  6.593644655265577e-21,  1.514207041483277e-23,
 -6.943893145064582e-26, -3.326105368042537e-28,  1.403153083699078e+00, -2.484543704965638e-03, -4.073058742635232e-06,  6.973369913659835e-09,  4.682450270295524e-11,
  1.701240620750448e-14, -5.032467696079656e-16, -1.207623744525601e-18,  4.186911419332831e-21,  2.519318181788089e-23, -7.496971489351196e-27, -3.855463508802986e-28,
  1.470477790107525e+00, -2.329594083102824e-03, -4.577888357029809e-06,  3.571669510647104e-09,  4.643464654305608e-11,  7.052347425070955e-14, -3.654050562769351e-16,
 -1.767402348346777e-18,  4.322743332836480e-22,  2.548092253896889e-23,  5.892394808358718e-26, -2.228477920612319e-28,  1.535694905316658e+00, -2.150899651887108e-03,
 -4.920738024848525e-06,  4.135634179838281e-11,  4.151062324856159e-11,  1.126480367786355e-13, -1.591637535286048e-16, -1.860120316333681e-18, -3.379499830807483e-21,
  1.554105537480031e-23,  9.543403461429814e-26,  6.407058182960223e-29,  1.598351844366791e+00, -1.952053763022880e-03, -5.084216256005192e-06, -3.342905289817694e-09,
  3.259887976446191e-11,  1.361723200509376e-13,  6.916472757040209e-17, -1.456080041753108e-18, -5.855660849731291e-21, -2.241831211575011e-25,  8.256422704914629e-26,
  2.956496932957487e-28,  1.657993187234564e+00, -1.737449786298492e-03, -5.060265432856167e-06, -6.306069804776297e-09,  2.083410458799562e-11,  1.371968141600920e-13,
  2.656525838406197e-16, -6.878917794415625e-19, -6.099965162290672e-21, -1.441568697688961e-23,  2.914224544809826e-26,  3.260946822129856e-28,  1.714165779653756e+00,
 -1.512214047838777e-03, -4.851684918731495e-06, -8.603292838892742e-09,  7.808217440474847e-12,  1.162884613851796e-13,  3.838595904800068e-16,  1.864026881303121e-19,
 -4.149350891297123e-21, -2.045641272149870e-23, -3.182272370828287e-26,  1.525519255646533e-28,  1.766424492255731e+00, -1.282098019671058e-03, -4.473011878249920e-06,
 -1.005105720312148e-08, -4.663555604755826e-12,  7.865659927435719e-14,  3.993068900456758e-16,  8.754063440644561e-19, -9.919284285315994e-22, -1.627609516132810e-23,
 -6.433650902105791e-26, -8.191236632846324e-29,  1.814338553587167e+00, -1.053328589855311e-03, -3.950557148459799e-06, -1.055436437625008e-08, -1.484906731033808e-11,
  3.313428611351658e-14,  3.179750969597319e-16,  1.168531635972270e-18,  1.901588050748224e-21, -5.468158668428453e-24, -5.372011088302532e-26, -2.047840767705186e-28,
  1.857498327322831e+00, -8.324181825611149e-04, -3.321446471402584e-06, -1.012517774593906e-08, -2.142369607413387e-11, -9.924549754412113e-15,  1.747838220461988e-16,
  1.021888530491758e-18,  3.323374347917265e-21,  5.089167139605039e-24, -1.547605866024817e-26, -1.542029772972828e-28,  1.895522358120394e+00, -6.259399730056308e-04,
 -2.631604896179003e-06, -8.887831446498440e-09, -2.374287560362035e-11, -4.134816536533157e-14,  2.141536303537480e-17,  5.715630725840931e-19,  2.940027554927872e-21,
  9.731221112803344e-24,  1.895277682076867e-26, -1.584869419886270e-29,  1.928064468634454e+00, -4.402771571139467e-04, -1.932738968609781e-06, -7.068637587673540e-09,
 -2.199264464101353e-11, -5.568002707936617e-14, -9.270995622266020e-17,  6.191568143094086e-20,  1.394582132931401e-21,  7.492048048153694e-24,  2.789418780786349e-26,
  7.540799827112162e-29,  1.954820659161636e+00, -2.813587627786952e-04, -1.278504680243015e-06, -4.969340543304494e-09, -1.716768469723376e-11, -5.270872549673365e-14,
 -1.389569130574436e-16, -2.787307779103856e-19, -1.781652903018495e-22,  2.018111412232624e-24,  1.440305253873609e-26,  6.536410883377774e-29,  1.975535558549532e+00,
 -1.543972568110963e-04, -7.201791093477177e-07, -2.927017437941458e-09, -1.086398054583314e-11, -3.739967011050146e-14, -1.195003690492340e-16, -3.501025851967420e-19,
 -9.092012358733558e-22, -1.900985404685734e-24, -1.956102084408723e-27,  8.847749022034461e-30,  1.990008307066265e+00, -6.364405337620812e-05, -3.022534509886809e-07,
 -1.265900063180413e-09, -4.920812886723239e-12, -1.813599801271968e-14, -6.399994817660106e-17, -2.171213863415183e-19, -7.082818579196901e-22, -2.214523513231559e-24,
 -6.585499653678770e-27, -1.834406909036933e-29,  1.998099715509293e+00, -1.216669083433048e-05, -5.835939195674759e-08, -2.484638296493348e-10, -9.899121210106460e-13,
 -3.777904757103719e-15, -1.398154695025337e-17, -5.053776311413556e-20, -1.792113381652055e-22, -6.252457165587228e-25, -2.150236148663864e-27, -7.297724998512838e-30,
  4.934607743701342e-04, -2.466847038585756e-06,  9.246900494515359e-09, -3.080217533558886e-11,  9.615637398447951e-14, -2.880486448164936e-16,  8.384834278844119e-19,
 -2.389597827271251e-21,  6.699215086186550e-24, -1.853620351273412e-26,  5.073298653622014e-29, -1.375881171975387e-31,  4.439567061913525e-03, -2.215997993945791e-05,
  8.280072419002200e-08, -2.743110422696039e-10,  8.492022259997681e-13, -2.513850463628265e-15,  7.200805711806994e-18, -2.009433150896444e-20,  5.484287556339894e-23,
 -1.467352378423185e-25,  3.852962827317855e-28, -9.932365418694120e-31,  1.232333983217237e-02, -6.132422535434701e-05,  2.276685451363268e-07, -7.459414395732353e-10,
  2.270148282545138e-12, -6.556403642160139e-15,  1.814899842489602e-17, -4.835824634838704e-20,  1.240891628477974e-22, -3.058339158784267e-25,  7.190767316572399e-28,
 -1.591723820837014e-30,  2.412783400533445e-02, -1.195159243362674e-04,  4.394069762292705e-07, -1.415516393772425e-09,  4.194800549906915e-12, -1.164517799185258e-14,
  3.044048332268463e-17, -7.466663535330027e-20,  1.695473735091573e-22, -3.450724503520380e-25,  5.767787541455787e-28, -5.293281545230537e-31,  3.982746812195296e-02,
 -1.960705817888964e-04,  7.114420439717515e-07, -2.239257224392546e-09,  6.391858361467083e-12, -1.673956874299848e-14,  3.994828460736648e-17, -8.436249232446305e-20,
  1.445255174868157e-22, -1.330865036553814e-25, -3.514593012353391e-28,  2.698690776470635e-30,  5.938782729415680e-02, -2.901041676718925e-04,  1.035179731649983e-06,
 -3.161546078434803e-09,  8.580191580484292e-12, -2.065678128224028e-14,  4.243930901473069e-17, -6.471412070860908e-20,  1.921325413316848e-23,  3.659597873806004e-25,
 -1.935853263011741e-27,  6.846611128341997e-30,  8.276539979676537e-02, -4.005150360256671e-04,  1.400155317851138e-06, -4.117237920814894e-09,  1.045068351736389e-11,
 -2.222547097430525e-14,  3.444439665251766e-17, -9.011904225860235e-21, -2.032733100019712e-22,  1.042558880385500e-24, -3.509489866949862e-27,  9.033033527416398e-30,
  1.099072468368909e-01, -5.259866236174686e-04,  1.794223020663475e-06, -5.034485281350753e-09,  1.169160350455971e-11, -2.045144929439220e-14,  1.409444861155324e-17,
  8.020296295559506e-20, -4.786870353958757e-22,  1.643018035168164e-24, -4.039020509456959e-27,  6.034912512002972e-30,  1.407506050807127e-01, -6.649911352439775e-04,
  2.203787623984352e-06, -5.838024857402557e-09,  1.201620425027725e-11, -1.467940072818883e-14, -1.821202120317875e-17,  1.896186196012996e-19, -7.251739452117422e-22,
  1.832722593857992e-24, -2.553483842952925e-27, -3.640812563697934e-30,  1.752224216703317e-01, -8.157944707464633e-04,  2.614079767833770e-06, -6.452857668285653e-09,
  1.119097441399206e-11, -4.733019341146277e-15, -5.943887097306506e-17,  2.959711725140720e-19, -8.399433089710199e-22,  1.312962138786435e-24,  1.298569093536079e-27,
 -1.787411144219907e-29,  2.132388217653906e-01, -9.764626996975671e-04,  3.009476378083141e-06, -6.808233426591333e-09,  9.062728287912111e-12,  8.984455242394025e-15,
 -1.039463162989280e-16,  3.694701083554838e-19, -7.271956320958592e-22, -3.848973574031959e-26,  6.789659825575675e-27, -3.042980325023552e-29,  2.547045091327561e-01,
 -1.144870443265173e-03,  3.373867231508209e-06, -6.841824907370830e-09,  5.582500488625731e-12,  2.544633833890029e-14, -1.439949009650277e-16,  3.796145751472017e-19,
 -3.318528956855371e-22, -2.049597624493076e-24,  1.200596385669762e-26, -3.270156164874682e-29,  2.995121010290999e-01, -1.318711578250529e-03,  3.691067828301821e-06,
 -6.503949442284907e-09,  8.240602123619544e-13,  4.302955880315841e-14, -1.707273708561682e-16,  3.026315716603083e-19,  3.294099243409383e-22, -4.211327864584981e-24,
  1.427417973963202e-26, -1.765903145647340e-29,  3.475413996293642e-01, -1.495512734417204e-03,  3.945277495228812e-06, -5.761662777198758e-09, -5.005198741077168e-12,
  5.962226791155903e-14, -1.755633859447458e-16,  1.292278853912634e-19,  1.149946474077140e-21, -5.751519319519450e-24,  1.112814923476373e-26,  1.528901485169457e-29,
  3.986586036106500e-01, -1.672650110838757e-03,  4.121579880122059e-06, -4.602516574942839e-09, -1.156315664227264e-11,  7.281465416842174e-14, -1.518598174078925e-16,
 -1.290685942390247e-19,  1.937154914338578e-21, -5.837902049560884e-24,  1.574890548613974e-27,  5.687153434775814e-29,  4.527154652759833e-01, -1.847370186902538e-03,
  4.206480631263073e-06, -3.037736833821673e-09, -1.838355301312945e-11,  8.016646427856798e-14, -9.660738577938610e-17, -4.368694288014493e-19,  2.444540973731094e-21,
 -3.878761178362481e-24, -1.281561681364624e-26,  8.857474570023370e-29,  5.095484008731072e-01, -2.016814944286011e-03,  4.188473997528752e-06, -1.104549526820523e-09,
 -2.489964884890325e-11,  7.953363585095155e-14, -1.186600218147492e-17, -7.368718045485260e-19,  2.431062341336720e-21,  1.593370064102020e-25, -2.758724694342962e-26,
  8.881389101932238e-29,  5.689775646130028e-01, -2.178052241500800e-03,  4.058626269267035e-06,  1.132643730507305e-09, -3.048155782263654e-11,  6.942411225131262e-14,
  9.439660761083669e-17, -9.577982996267772e-19,  1.738225354089986e-21,  5.535137669590200e-24, -3.631788947244584e-26,  4.369221441133766e-29,  6.308059004065870e-01,
 -2.328111984356698e-03,  3.811159374808054e-06,  3.582547268187401e-09, -3.448671040564026e-11,  4.934057955127372e-14,  2.083864693666422e-16, -1.028171499195354e-18,
  3.662804797791951e-22,  1.074275047660556e-23, -3.286403722195782e-26, -4.175161473685934e-29,  6.948181895979396e-01, -2.464028703582099e-03,  3.444012585403489e-06,
  6.129006664039084e-09, -3.632144646390694e-11,  2.005742435669227e-14,  3.117287747569849e-16, -8.942015898845376e-19, -1.475796375758965e-21,  1.383192200594547e-23,
 -1.438999192969739e-26, -1.381878967715403e-28,  7.607801180485345e-01, -2.582891072089223e-03,  2.959354291530049e-06,  8.635053541182904e-09, -3.550995860033535e-11,
 -1.622680913665959e-14,  3.839609278365489e-16, -5.383575022841287e-19, -3.372638006589874e-21,  1.302714113509355e-23,  1.600065200279434e-26, -1.984825195384525e-28,
  8.284373918651141e-01, -2.681898753839958e-03,  2.364009464825548e-06,  1.094913530980704e-08, -3.176483516445301e-11, -5.591875577344315e-14,  4.061176090869269e-16,
  6.234773186020165e-21, -4.775100786541873e-21,  7.500569444641541e-24,  4.854743497835036e-26, -1.775968378658901e-28,  8.975149378687322e-01, -2.758426756754226e-03,
  1.669762169581137e-06,  1.291357573027569e-08, -2.505147656530005e-11, -9.428663965625799e-14,  3.649543393569909e-16,  6.510058259209804e-19, -5.142795478001063e-21,
 -1.976481680676245e-24,  6.922083827000196e-26, -5.976149215768956e-29,  9.677162325154270e-01, -2.810097145222538e-03,  8.934870309256746e-07,  1.437512583600787e-08,
 -1.563699161077625e-11, -1.259639055859684e-13,  2.570479036634138e-16,  1.261355405156730e-18, -4.129810624443794e-21, -1.284154534154477e-23,  6.525007378687645e-26,
  1.209639499288444e-28,  1.038722811250085e+00, -2.834857535552176e-03,  5.705987886809922e-08,  1.519721889866199e-08, -4.113249150995755e-12, -1.456810858996075e-13,
  9.177163319917918e-17,  1.682148931315187e-18, -1.759351496219808e-21, -2.127468321783443e-23,  3.206516156894208e-26,  2.830231295646495e-28,  1.110194018930121e+00,
 -2.831065235059524e-03, -8.130028576848935e-07,  1.527324338953869e-08,  8.615914709833419e-12, -1.491558766700705e-13, -1.079278917699947e-16,  1.776669210636471e-18,
  1.484413847835429e-21, -2.348343686329629e-23, -2.168299172978509e-26,  3.310421532336981e-28,  1.181767070559382e+00, -2.797575184181567e-03, -1.686222488222405e-06,
  1.453981260328391e-08,  2.139120322335973e-11, -1.340148602373378e-13, -3.078245129745350e-16,  1.470840123616088e-18,  4.713188333089910e-21, -1.739553686264390e-23,
 -7.470266087858031e-26,  2.112143790770336e-28,  1.253057499492004e+00, -2.733829024328820e-03, -2.529190356553722e-06,  1.298867401196679e-08,  3.290155902638797e-11,
 -1.005698604910896e-13, -4.681029241709028e-16,  7.895891642995122e-19,  6.867593279139977e-21, -4.058810186302623e-24, -1.010602627283588e-25, -4.147187903972888e-29,
  1.323660076638504e+00, -2.639941663686359e-03, -3.306972071330569e-06,  1.067562070910468e-08,  4.183171309179236e-11, -5.224394199998482e-14, -5.518952498488861e-16,
 -1.297978563017693e-19,  7.085308479871528e-21,  1.207996693690542e-23, -8.343810011688394e-26, -3.012885352245690e-28,  1.393150287924710e+00, -2.516780695346712e-03,
 -3.984874079671724e-06,  7.724616494623811e-09,  4.704131450270274e-11,  4.544697155165900e-15, -5.350487602250298e-16, -1.059222923313924e-18,  5.084295814143652e-21,
  2.454496634271223e-23, -2.511606751488907e-26, -4.132741016131566e-28,  1.461086456976517e+00, -2.366033015582105e-03, -4.530525640693831e-06,  4.325414336485041e-09,
  4.775342207879910e-11,  6.116233217803537e-14, -4.145576344019098e-16, -1.738458088954980e-18,  1.389460397167021e-21,  2.762098293954282e-23,  4.756494630848597e-26,
 -2.933844741313583e-28,  1.527012594207813e+00, -2.190252110304172e-03, -4.916183102418237e-06,  7.233245288032431e-10,  4.372110506434271e-11,  1.081914294111388e-13,
 -2.126717508023390e-16, -1.958571483174867e-18, -2.750795986442165e-21,  1.939639371029185e-23,  9.685624757145397e-26, -1.355806089247408e-30,  1.590462040585313e+00,
 -1.992878878132013e-03, -5.121111499934918e-06, -2.799459694268070e-09,  3.533551393334158e-11,  1.373218725067246e-13,  2.577462783960945e-17, -1.642927672356670e-18,
 -5.801180858850536e-21,  3.334989497927874e-24,  9.528130575277372e-26,  2.800878087494072e-28,  1.650961952859171e+00, -1.778228723479902e-03, -5.133846543321152e-06,
 -5.950433181759014e-09,  2.364012135332607e-11,  1.433188162889608e-13,  2.435825820859756e-16, -8.911403220021584e-19, -6.594378078804496e-21, -1.295085060411038e-23,
  4.439293730050219e-26,  3.663270238589856e-28,  1.708038645888949e+00, -1.551438181391550e-03, -4.954096467936800e-06, -8.459253157302078e-09,  1.022645526968784e-11,
  1.255480299050388e-13,  3.871075758441775e-16,  4.160901942781155e-20, -4.906924382965615e-21, -2.157827583194730e-23, -2.384219246125939e-26,  2.113348805918812e-28,
  1.761223766477782e+00, -1.318365710947885e-03, -4.594018643397370e-06, -1.011256007850084e-08, -2.992625443904516e-12,  8.852995502258802e-14,  4.232822179333375e-16,
  8.337863537312923e-19, -1.624985229246946e-21, -1.891342290626828e-23, -6.730834699827139e-26, -5.147205362851462e-29,  1.810061222549499e+00, -1.085443642365635e-03,
 -4.078611788992683e-06, -1.078622208225850e-08, -1.410738262545246e-11,  4.116499405138492e-14,  3.515132404212110e-16,  1.225800190714264e-18,  1.663845124552957e-21,
 -7.801426297352116e-24, -6.304165807560942e-26, -2.182643487966569e-28,  1.854114733690873e+00, -8.594816036648358e-04, -3.445011063986470e-06, -1.046930694627433e-08,
 -2.157785849980286e-11, -5.374201481818793e-15,  2.049121837556415e-16,  1.131034561225430e-18,  3.493720601309382e-21,  4.324946704684286e-24, -2.297621833084180e-26,
 -1.873238959088190e-28,  1.892975807874979e+00, -6.474259487866335e-04, -2.740565373588499e-06, -9.274299600237982e-09, -2.456334658296841e-11, -4.063119142936933e-14,
  3.878996054546760e-17,  6.713937829055739e-19,  3.303782465985486e-21,  1.047015583956033e-23,  1.785569475018120e-26, -3.484695266384013e-29,  1.926271890408300e+00,
 -4.560844308821493e-04, -2.019711052136054e-06, -7.429548916613662e-09, -2.312832799926875e-11, -5.787896247395519e-14, -9.030942407286619e-17,  1.110796485110793e-19,
  1.685192321657424e-21,  8.675590045749979e-24,  3.131607117065380e-26,  7.995184944376787e-29,  1.953674383666238e+00, -2.918300794846792e-04, -1.339820246482722e-06,
 -5.252640758562192e-09, -1.825584405745335e-11, -5.613791794833264e-14, -1.468294445457086e-16, -2.831526142772055e-19, -9.441882979187383e-23,  2.655197572764720e-24,
  1.753962522276915e-26,  7.750020696752713e-29,  1.974906219955199e+00, -1.603021994023037e-04, -7.563714585382814e-07, -3.106984295314278e-09, -1.164146533066825e-11,
 -4.038866486213558e-14, -1.297209546364633e-16, -3.803062627183172e-19, -9.789406587455585e-22, -1.970261598571387e-24, -1.476512771824004e-27,  1.313481184533223e-29,
  1.989748796662507e+00, -6.612421076763245e-05, -3.179288956392204e-07, -1.347620399017572e-09, -5.299398821556703e-12, -1.974758622335398e-14, -7.040901407367367e-17,
 -2.411144301192776e-19, -7.929468842886599e-22, -2.494759711691592e-24, -7.443425280642762e-27, -2.069420306885010e-29,  1.998050095724585e+00, -1.264576735320835e-05,
 -6.143854329459815e-08, -2.649256133344498e-10, -1.068943846638853e-12, -4.131112008113526e-15, -1.548039691790766e-17, -5.664991668552443e-20, -2.033490006170271e-22,
 -7.180384061192712e-25, -2.498728638280090e-27, -8.579423885381027e-30,  4.837390320139887e-04, -2.394324615353525e-06,  8.886318770913196e-09, -2.930869007352628e-11,
  9.059134013147357e-14, -2.687043259285738e-16,  7.744783444115742e-19, -2.185519674854373e-21,  6.067026819882273e-24, -1.662291047360988e-26,  4.505247916465041e-29,
 -1.209950204622846e-31,  4.352231427235125e-03, -2.151051385394415e-05,  7.958888585714080e-08, -2.611168206687994e-10,  8.006088407258666e-13, -2.347589286828028e-15,
  6.661960628542397e-18, -1.842098790494119e-20,  4.982760285630159e-23, -1.321630700294772e-25,  3.441360333626651e-28, -8.800804971516473e-31,  1.208162979471660e-02,
 -5.953807451625155e-05,  2.189309302927960e-07, -7.106448777674366e-10,  2.143268569341208e-12, -6.136637322453488e-15,  1.684894309672236e-17, -4.455813650360304e-20,
  1.135804060925095e-22, -2.784269913072907e-25,  6.523479370632574e-28, -1.443639285900113e-30,  2.365669482815021e-02, -1.160674897738483e-04,  4.228159212039256e-07,
 -1.350223819004100e-09,  3.969036482506682e-12, -1.093909261872637e-14,  2.842393870086283e-17, -6.943547500649236e-20,  1.575342753044628e-22, -3.224840879875822e-25,
  5.522618320474610e-28, -5.812507203848852e-31,  3.905440110530090e-02, -1.904848163080708e-04,  6.851736941359967e-07, -2.139614522831102e-09,  6.066465922551954e-12,
 -1.580863762398312e-14,  3.765014394638189e-17, -7.981682361695375e-20,  1.395086044095314e-22, -1.449187702951124e-25, -2.436852105344231e-28,  2.213657932264782e-30,
  5.824373647552023e-02, -2.819721812601624e-04,  9.980514212084818e-07, -3.027513371970983e-09,  8.177095026192186e-12, -1.965990068205009e-14,  4.063779853149395e-17,
 -6.390287533848316e-20,  3.106415951657515e-23,  2.942848609789031e-25, -1.654279798059244e-27,  5.969558042234386e-30,  8.118543319655597e-02, -3.895086118085215e-04,
  1.351737204836014e-06, -3.953538242982432e-09,  1.001441665900096e-11, -2.140253476072991e-14,  3.410645049201504e-17, -1.494246597920799e-20, -1.681743500723816e-22,
  9.098966107717297e-25, -3.129311649737613e-27,  8.252246079809097e-30,  1.078316297386162e-01, -5.118713455926406e-04,  1.734918154814899e-06, -4.850672744924084e-09,
  1.128613036885875e-11, -2.008791171300835e-14,  1.613435251319511e-17,  6.580069766686602e-20, -4.223819982814837e-22,  1.486819158191046e-24, -3.769958313366602e-27,
  6.168084468318089e-30,  1.381254620364526e-01, -6.476378134959100e-04,  2.134875120791972e-06, -5.648136283224174e-09,  1.171866210971309e-11, -1.505533935811275e-14,
 -1.321780128427255e-17,  1.674487080359247e-19, -6.610681043284806e-22,  1.727916756363523e-24, -2.674194223276700e-27, -1.908029946857357e-30,  1.720005829336800e-01,
 -7.951885335108170e-04,  2.537716442064017e-06, -6.274634105479356e-09,  1.108270445041263e-11, -6.063099169733454e-15, -5.152080413598541e-17,  2.698577992317372e-19,
 -7.919221816837341e-22,  1.350164355759355e-24,  5.852356354949871e-28, -1.462055197179567e-29,  2.093806086599135e-01, -9.527112060222748e-04,  2.928653099047677e-06,
 -6.661924337093922e-09,  9.218294646408388e-12,  6.611256598208852e-15, -9.392678637280013e-17,  3.462275378114406e-19, -7.240058875157037e-22,  2.073595447277624e-25,
  5.528309190572382e-27, -2.692894798587913e-29,  2.501784914498662e-01, -1.118206357092167e-03,  3.292317448836232e-06, -6.748617663268863e-09,  6.057722965893750e-12,
  2.211674629957809e-14, -1.335248107606436e-16,  3.679046089586021e-19, -3.973373296167241e-22, -1.597739251238836e-24,  1.059763903145855e-26, -3.123716110526349e-29,
  2.942958179020589e-01, -1.289494937080055e-03,  3.613127231050987e-06, -6.484099477243202e-09,  1.644368763606678e-12,  3.903484107245120e-14, -1.621281263449231e-16,
  3.108555840714613e-19,  1.878836740183369e-22, -3.656828632458075e-24,  1.342989547142235e-26, -2.052971217418338e-29,  3.416220334408689e-01, -1.464228346537859e-03,
  3.875695655476643e-06, -5.832434026204781e-09, -3.854574817007471e-12,  5.545613720757193e-14, -1.714603369731053e-16,  1.628003742317926e-19,  9.510437207089399e-22,
 -5.295384721590665e-24,  1.162058072710422e-26,  7.324539558014526e-30,  3.920335943581582e-01, -1.639901428385864e-03,  4.065287031341594e-06, -4.776075866945363e-09,
 -1.014356726319478e-11,  6.913346261540014e-14, -1.546373733079290e-16, -7.042541253059035e-20,  1.728697563205327e-21, -5.728128814354777e-24,  3.834231754985165e-27,
  4.595380950160077e-29,  4.453930504507878e-01, -1.813869032532316e-03,  4.168315458980092e-06, -3.319177025428737e-09, -1.680435519622045e-11,  7.770980597764779e-14,
 -1.077662292314989e-16, -3.609697458506448e-19,  2.296594940332726e-21, -4.315937818630894e-24, -9.106494776898529e-27,  7.989371855729719e-29,  5.015480633319115e-01,
 -1.983366822631143e-03,  4.172881460208294e-06, -1.490240856803431e-09, -2.331344977059608e-11,  7.901005146915969e-14, -3.140990849769373e-17, -6.591913459665504e-19,
  2.417879554384805e-21, -8.658026592447549e-25, -2.366975965876550e-26,  8.881869423437458e-29,  5.603303681833918e-01, -2.145537049151751e-03,  4.069337958490425e-06,
  6.561607535841541e-10, -2.907255944924724e-11,  7.137427022268826e-14,  6.838496041029030e-17, -8.992632154175577e-19,  1.911842068534908e-21,  4.124919283572124e-24,
 -3.409936966403992e-26,  5.655435776989359e-29,  6.215546901508960e-01, -2.297460050759942e-03,  3.850872636156684e-06,  3.038916370504191e-09, -3.345220962677182e-11,
  5.399806185773728e-14,  1.798180732973314e-16, -1.010519569445301e-18,  7.289804466491320e-22,  9.398638551547989e-24, -3.416806153109646e-26, -1.793824921809740e-29,
  6.850176308855186e-01, -2.436192256926817e-03,  3.514088337675526e-06,  5.551470599878508e-09, -3.584753676265120e-11,  2.723358258385935e-14,  2.861039730680940e-16,
 -9.335824325309299e-19, -9.896065961423165e-22,  1.314205953218721e-23, -1.991974574282348e-26, -1.130262245628670e-28,  7.504965460286342e-01, -2.558811435333895e-03,
  3.059556875635795e-06,  8.064793260181403e-09, -3.574362632947219e-11, -7.204393116933058e-15,  3.674472614522326e-16, -6.386716609764950e-19, -2.894217129379717e-21,
  1.349565582272106e-23,  7.512414622074267e-27, -1.865089198893600e-28,  8.177484408300502e-01, -2.662469841218484e-03,  2.492314472851009e-06,  1.043248027564414e-08,
 -3.278581604404319e-11, -4.618684252125692e-14,  4.041961128119112e-16, -1.418888997911932e-19, -4.472050930824592e-21,  9.281723229134865e-24,  4.041338294133392e-26,
 -1.909003397822582e-28,  8.865089186633973e-01, -2.744455761958540e-03,  1.822259465106232e-06,  1.249814800569466e-08, -2.684824015418903e-11, -8.532764068355096e-14,
  3.808716099578540e-16,  4.858264368977374e-19, -5.164852899077759e-21,  7.278245996124994e-25,  6.570874317685321e-26, -9.897336372175482e-29,  9.564912259823733e-01,
 -2.802263685425642e-03,  1.064405371507830e-06,  1.410512666995083e-08, -1.809179639574610e-11, -1.193862827868874e-13,  2.904498488292561e-16,  1.122318013547907e-18,
 -4.543974869744841e-21, -1.013954169773838e-23,  6.949030473539703e-26,  7.159697559895414e-29,  1.027385447184218e+00, -2.833672929396617e-03,  2.389359153211671e-07,
  1.510823349934186e-08, -7.001066410905980e-12, -1.429204247139616e-13,  1.379703786659756e-16,  1.613866854713966e-18, -2.499230707575544e-21, -1.975179019227724e-23,
  4.384610925622963e-26,  2.510057819459256e-28,  1.098857913719212e+00, -2.836834026256473e-03, -6.289956615390522e-07,  1.538710934706177e-08,  5.610948374565448e-12,
 -1.511446040049705e-13, -5.764425603497441e-17,  1.810505333616067e-18,  6.269444268445448e-22, -2.405569467836320e-23, -6.859499534968716e-27,  3.407015054753468e-28,
  1.170550903231060e+00, -2.810361440914852e-03, -1.509780892551013e-06,  1.486024237546469e-08,  1.864044955189170e-11, -1.408920021731919e-13, -2.646276272036510e-16,
  1.611084795141135e-18,  4.035554442697489e-21, -2.018122376357331e-23, -6.418546610183295e-26,  2.655734234902497e-28,  1.242082715915918e+00, -2.753430298397450e-03,
 -2.370236050508277e-06,  1.349840533416084e-08,  3.077973556984424e-11, -1.115143584656967e-13, -4.429452889439355e-16,  1.006231772694509e-18,  6.648463872420159e-21,
 -8.116688280470897e-24, -1.013060271033482e-25,  3.092070906310534e-29,  1.313048225730577e+00, -2.665873716327699e-03, -3.174885592827678e-06,  1.133584864662875e-08,
  4.065421903979344e-11, -6.550704143099723e-14, -5.522947339238167e-16,  1.032207293903819e-19,  7.457028575392621e-21,  8.489766161475273e-24, -9.573804294509845e-26,
 -2.554596789973477e-28,  1.383020012296105e+00, -2.548276108828476e-03, -3.887662002823417e-06,  8.477297231971342e-09,  4.700149287764895e-11, -8.633178534266233e-15,
 -5.622979902482733e-16, -8.826173525630731e-19,  5.945399397003324e-21,  2.317143625115213e-23, -4.366284410793713e-26, -4.272981562244973e-28,  1.451550183690786e+00,
 -2.402056522515844e-03, -4.473997769065897e-06,  5.098698031901107e-09,  4.887326197799304e-11,  5.063478258812735e-14, -4.624600321701878e-16, -1.677744943186542e-18,
  2.414765467692148e-21,  2.924502065334864e-23,  3.313921875524397e-26, -3.616620944122477e-28,  1.518172998812959e+00, -2.229534800849608e-03, -4.903235525327082e-06,
  1.439876698544304e-09,  4.582940182057286e-11,  1.024199524034511e-13, -2.686338116675714e-16, -2.034678306189440e-18, -1.983000484813634e-21,  2.324768760706328e-23,
  9.515107507626630e-26, -7.785385720608580e-29,  1.582408388374059e+00, -2.033972324068597e-03, -5.151222109261367e-06, -2.212102378008313e-09,  3.808430329015887e-11,
  1.373676006292578e-13, -2.280284531961571e-17, -1.825885276446237e-18, -5.609618053277958e-21,  7.384874855947421e-24,  1.069905281044128e-25,  2.495204508493050e-28,
  1.643766453555200e+00, -1.819578466641835e-03, -5.202886694765624e-06, -5.548951515862749e-09,  2.656281137590139e-11,  1.488411120879798e-13,  2.156089108446722e-16,
 -1.109245228115359e-18, -7.024664298827191e-21, -1.084222182402919e-23,  6.128572313333765e-26,  4.002172188053683e-28,  1.701752988899345e+00, -1.591474021577542e-03,
 -5.054541268982712e-06, -8.275037332283620e-09,  1.283032128628567e-11,  1.348341250277034e-13,  3.859563431698184e-16, -1.280064072931849e-19, -5.698497758508784e-21,
 -2.232724168521359e-23, -1.313175298579010e-26,  2.764378253232632e-28,  1.755876029813940e+00, -1.355603938782424e-03, -4.715596417251580e-06, -1.014571750909676e-08,
 -1.118580689142118e-12,  9.896235670994482e-14,  4.457941559428231e-16,  7.703693083085587e-19, -2.354774330595469e-21, -2.163969319177080e-23, -6.870321127388954e-26,
 -9.991713350467782e-30,  1.805653365107617e+00, -1.118594046938424e-03, -4.209372076885346e-06, -1.100488365758903e-08, -1.319690952404965e-11,  5.001891977432059e-14,
  3.865352475329587e-16,  1.274043963221253e-18,  1.335261834458974e-21, -1.051810327263577e-23, -7.285456271768225e-26, -2.267936190882143e-28,  1.850620883137447e+00,
 -8.875500944660444e-04, -3.572716873210152e-06, -1.081513435250721e-08, -2.163353254222554e-11, -6.351105272526507e-17,  2.381683838505282e-16,  1.245130664982004e-18,
  3.630793823005731e-21,  3.230505162222597e-24, -3.201296451441740e-26, -2.239893200278261e-28,  1.890341540673789e+00, -6.698023807845846e-04, -2.854241684809346e-06,
 -9.673756942977904e-09, -2.536507486322504e-11, -3.946234446177811e-14,  5.912670895863881e-17,  7.832800808906895e-19,  3.693133695127443e-21,  1.114694061660102e-23,
  1.580526523224649e-26, -5.934044493870123e-29,  1.924414663663996e+00, -4.726051172878670e-04, -2.111124537044030e-06, -7.808979391194640e-09, -2.430729683236544e-11,
 -6.000267483445909e-14, -8.639551164812285e-17,  1.702516487209900e-19,  2.020918700478469e-21,  9.999639128072472e-24,  3.490933714146831e-26,  8.309172787279906e-29,
  1.952485219899330e+00, -3.028058203895137e-04, -1.404642175225989e-06, -5.553910496524285e-09, -1.941448504476669e-11, -5.975721198126695e-14, -1.547846422849480e-16,
 -2.845023116113539e-19,  1.465461580777236e-23,  3.428962719067499e-24,  2.125059963913229e-26,  9.150309016566690e-29,  1.974252668530779e+00, -1.665055353033579e-04,
 -7.948000652615941e-07, -3.299882768152443e-09, -1.248125276557409e-11, -4.363335644378768e-14, -1.408188327452865e-16, -4.127774130970941e-19, -1.050780138867052e-21,
 -2.016234950744824e-24, -7.818871388532420e-28,  1.866851398684459e-29,  1.989479108462647e+00, -6.873379977282405e-05, -3.346224199272947e-07, -1.435664555391188e-09,
 -5.711810735297236e-12, -2.152136939062491e-14, -7.752938018041585e-17, -2.679850007331488e-19, -8.883437259532819e-22, -2.811456470032488e-24, -8.410418682648324e-27,
 -2.330390143216659e-29,  1.997998509085211e+00, -1.315028929490397e-05, -6.472306269311604e-08, -2.827104320886333e-10, -1.155413768185993e-12, -4.522435809382567e-15,
 -1.716172289207066e-17, -6.359072875405268e-20, -2.310923237186669e-22, -8.259671912061132e-25, -2.908815481321163e-27, -1.010490946164953e-29,  4.743017214491960e-04,
 -2.324616643436146e-06,  8.543137129310111e-09, -2.790123182222225e-11,  8.539828273558244e-14, -2.508297826670180e-16,  7.159142790269134e-19, -2.000611955020367e-21,
  5.499797123669286e-24, -1.492288660751427e-26,  4.005399611202578e-29, -1.065352163329677e-31,  4.267443251913968e-03, -2.088612212162771e-05,  7.653082071753292e-08,
 -2.486741784880223e-10,  7.552150596022019e-13, -2.193715810196771e-15,  6.167798978302292e-18, -1.690004772752491e-20,  4.530845481648890e-23, -1.191418708940966e-25,
  3.076488397474784e-28, -7.805224918289800e-31,  1.184692719342016e-02, -5.782016424601203e-05,  2.106049653900324e-07, -6.773128885290105e-10,  2.024480595316712e-12,
 -5.746832599822126e-15,  1.565072764735436e-17, -4.107902312394652e-20,  1.040117883604539e-22, -2.535628244852683e-25,  5.918435311265830e-28, -1.308641087644273e-30,
  2.319908880927129e-02, -1.127487099594597e-04,  4.069871613580045e-07, -1.288433076199987e-09,  3.756921794794126e-12, -1.027968934150137e-14,  2.654860557561908e-17,
 -6.457591625212608e-20,  1.463162146800677e-22, -3.009156536867987e-25,  5.259326137411926e-28, -6.125260223107361e-31,  3.830326430671070e-02, -1.851045018872408e-04,
  6.600704238694817e-07, -2.045032105145050e-09,  5.759150766513938e-12, -1.493135304215284e-14,  3.547697609296876e-17, -7.543771983427252e-20,  1.341383968304881e-22,
 -1.528436765454408e-25, -1.555381733946658e-28,  1.804593861807976e-30,  5.713158958323871e-02, -2.741308959042793e-04,  9.624934563298434e-07, -2.899773050185232e-09,
  7.793505772921893e-12, -1.870594321045275e-14,  3.886393928913786e-17, -6.275158566296140e-20,  4.052847719118893e-23,  2.331313534935966e-25, -1.409050198329285e-27,
  5.193028848684998e-30,  7.964872987870117e-02, -3.788817923278177e-04,  1.305242147898002e-06, -3.796687660002444e-09,  9.594514604897062e-12, -2.058957931551678e-14,
  3.361747550654228e-17, -1.982340619694790e-20, -1.375857050338117e-22,  7.917630798364582e-25, -2.782820225548622e-27,  7.503350335132153e-30,  1.058115386893878e-01,
 -4.982217932123524e-04,  1.677780362167816e-06, -4.673287086133317e-09,  1.088838592783554e-11, -1.968005712141187e-14,  1.779538715693206e-17,  5.311230886335533e-20,
 -3.715054019625722e-22,  1.341454598144881e-24, -3.498356516950205e-27,  6.156720447578212e-30,  1.355686439957079e-01, -6.308267585834300e-04,  2.068212488853584e-06,
 -5.463062227944867e-09,  1.141475071107774e-11, -1.531863750955387e-14, -8.816192493635178e-18,  1.472690260104024e-19, -6.008047875374634e-22,  1.619700846416419e-24,
 -2.726524173820042e-27, -5.236227137416741e-31,  1.688599596335913e-01, -7.751849795556050e-04,  2.463480560052953e-06, -6.098345595165030e-09,  1.094967490314678e-11,
 -7.211744795852837e-15, -4.431223462405959e-17,  2.452972961385321e-19, -7.430420036992775e-22,  1.361572667632880e-24,  5.861615413850110e-30, -1.178048727877818e-29,
  2.056161195312509e-01, -9.295992369523946e-04,  2.849598938864122e-06, -6.513493053137003e-09,  9.328749098122265e-12,  4.470736539861207e-15, -8.455535657334887e-17,
  3.232192091469456e-19, -7.128370492618938e-22,  4.057874486657142e-25,  4.417305802470837e-27, -2.360422986263578e-29,  2.457578325748202e-01, -1.092190070945154e-03,
  3.211929620831769e-06, -6.648326056809606e-09,  6.468838704425305e-12,  1.903427972998040e-14, -1.234095679247638e-16,  3.543486727242946e-19, -4.475521759744197e-22,
 -1.200800861906445e-24,  9.262773972669072e-27, -2.938662129824775e-29,  2.891951561058264e-01, -1.260900650764105e-03,  3.535500983003349e-06, -6.451752447484305e-09,
  2.386862863541106e-12,  3.524877492534073e-14, -1.533590601006931e-16,  3.148634025864470e-19,  6.568402071308875e-23, -3.138305585707145e-24,  1.248299329543474e-26,
 -2.235361526980135e-29,  3.358266865493763e-01, -1.433503703722999e-03,  3.805372289160692e-06, -5.885456216096674e-09, -2.786216285126526e-12,  5.139905609505312e-14,
 -1.665038748937758e-16,  1.902738489746202e-19,  7.688356082840726e-22, -4.826156368627491e-24,  1.179271802896142e-26,  7.162665009997190e-31,  3.855386664971101e-01,
 -1.607611039057145e-03,  4.007045311811563e-06, -4.927513796689627e-09, -8.798139203816183e-12,  6.540456430013760e-14, -1.558655959392777e-16, -1.837311997961768e-20,
  1.525705177559232e-21, -5.537348325748096e-24,  5.631511383136195e-27,  3.589422312066174e-29,  4.382040088122362e-01, -1.780686282952860e-03,  4.126922940809564e-06,
 -3.575756955661395e-09, -1.527679935013488e-11,  7.501028921726310e-14, -1.168683276225210e-16, -2.900282747416202e-19,  2.135487223166546e-21, -4.612584752570599e-24,
 -5.793212036297878e-27,  7.065129780724398e-29,  4.936812400920441e-01, -1.950061523970285e-03,  4.152812475938035e-06, -1.850661522054101e-09, -2.174223712528967e-11,
  7.804343328109142e-14, -4.879000051885867e-17, -5.824930185225833e-19,  2.370605589137541e-21, -1.734977452889876e-24, -1.980638429848353e-26,  8.643699099974700e-29,
  5.518133682421877e-01, -2.112958648477570e-03,  4.074468294614152e-06,  2.025004246769815e-10, -2.763066490638423e-11,  7.272039797665342e-14,  4.408257196262920e-17,
 -8.359665111868268e-19,  2.036415079515751e-21,  2.813712653941685e-24, -3.139285049994691e-26,  6.591033094531645e-29,  6.124266821321036e-01, -2.266516217133005e-03,
  3.884164592588011e-06,  2.512545620329887e-09, -3.233136899499630e-11,  5.797710020945941e-14,  1.518990863850305e-16, -9.820435126230803e-19,  1.042598999388671e-21,
  8.022546147327653e-24, -3.448298879503113e-26,  3.142028564278888e-30,  6.753294954751009e-01, -2.407822786392067e-03,  3.577283779585320e-06,  4.982631517928467e-09,
 -3.523633418185729e-11,  3.378324724961075e-14,  2.595902955142198e-16, -9.578430756447691e-19, -5.319648028766078e-22,  1.225331807783071e-23, -2.433160420925343e-26,
 -8.754149117973888e-29,  7.403108523854902e-01, -2.533957600387277e-03,  3.152899786774316e-06,  7.492215424566059e-09, -3.580102753224112e-11,  1.389732591110793e-15,
  3.483412059801630e-16, -7.234708997319604e-19, -2.404901279269188e-21,  1.363659073372644e-23, -3.453570643420027e-28, -1.700081851660196e-28,  8.071392186872350e-01,
 -2.642039550911933e-03,  2.614328017444497e-06,  9.901042758211366e-09, -3.361294985563035e-11, -3.654966192820856e-14,  3.982721059469015e-16, -2.793528418253587e-19,
 -4.110857250441587e-21,  1.072798650169678e-23,  3.185624228416358e-26, -1.968861076951532e-28,  8.755611911496235e-01, -2.729285204304410e-03,  1.969605114508088e-06,
  1.205542468684703e-08, -2.846237827980823e-11, -7.604211834581616e-14,  3.921683992854552e-16,  3.214685028964303e-19, -5.092484473582314e-21,  3.258839664144148e-24,
  6.060021196918548e-26, -1.321590273161656e-28,  9.453002665329048e-01, -2.793076496296670e-03,  1.231852539479839e-06,  1.379694525370048e-08, -2.040735494927350e-11,
 -1.120551365409861e-13,  3.197880334011391e-16,  9.716121936591155e-19, -4.858339214645462e-21, -7.311529800652844e-24,  7.155033821362535e-26,  2.220768831358654e-29,
  1.016055723693765e+00, -2.831038367150715e-03,  4.194689118147803e-07,  1.497354427531813e-08, -9.822751212224038e-12, -1.390765579799785e-13,  1.819346337133850e-16,
  1.522873871472114e-18, -3.176165923316103e-21, -1.778832750230110e-23,  5.403512612255367e-26,  2.109593062632186e-28,  1.087501684955111e+00, -2.841126114264627e-03,
 -4.439116500876753e-07,  1.545264348284087e-08,  2.578336215291710e-12, -1.519182706819898e-13, -6.799632596811368e-18,  1.816687863394139e-18, -2.403844055353923e-22,
 -2.403019136349402e-23,  8.113766135545846e-27,  3.378357949657749e-28,  1.159286437224395e+00, -2.821721542539546e-03, -1.329762564876554e-06,  1.513561736481911e-08,
  1.576282532330557e-11, -1.466878366120911e-13, -2.178219414858339e-16,  1.728126354561442e-18,  3.265762655920463e-21, -2.250083511553971e-23, -5.146388673137665e-26,
  3.110140299635023e-28,  1.231032108415602e+00, -2.771736064462556e-03, -2.205375775153925e-06,  1.397247121338445e-08,  2.844554666406763e-11, -1.217832085441103e-13,
 -4.118417690495839e-16,  1.213529291925429e-18,  6.283849892194191e-21, -1.211982075553614e-23, -9.830717812076961e-26,  1.054785920045477e-28,  1.302334809694336e+00,
 -2.690717726630587e-03, -3.034998167720443e-06,  1.197511630344226e-08,  3.921190203703945e-11, -7.870021281224582e-14, -5.460232500940452e-16,  3.459756376041154e-19,
  7.691168846520356e-21,  4.451986473037479e-24, -1.057181509129076e-25, -1.960659605362729e-28,  1.372765367568558e+00, -2.578957728104197e-03, -3.781430387774305e-06,
  9.227198566881153e-09,  4.669199034473205e-11, -2.240263335502316e-14, -5.842249499138539e-16, -6.793917388642261e-19,  6.743594712440903e-21,  2.104824891728587e-23,
 -6.248253948281389e-26, -4.253520092005136e-28,  1.441870780001241e+00, -2.437590400667290e-03, -4.408090137243836e-06,  5.888152938386200e-09,  4.977121138251766e-11,
  3.898173246825685e-14, -5.081951635187758e-16, -1.583403749226032e-18,  3.487438311566812e-21,  3.023342184705723e-23,  1.582656288424224e-26, -4.239712571338815e-28,
  1.509176535072539e+00, -2.268678952067593e-03, -4.881490973124884e-06,  2.189164532583915e-09,  4.780868042171381e-11,  9.528271786351520e-14, -3.263621808414393e-16,
 -2.084017251039531e-18, -1.078623838067925e-21,  2.696057325035038e-23,  8.986842539166543e-26, -1.635927287680835e-28,  1.574189926303562e+00, -2.075277714408539e-03,
 -5.174020726750395e-06, -1.580822188102525e-09,  4.082193783115882e-11,  1.361868262089307e-13, -7.639476543961838e-17, -2.000292658039869e-18, -5.264196461312305e-21,
  1.187142104540767e-23,  1.169926975814413e-25,  2.022604469683128e-28,  1.636404482281833e+00, -1.861460456777198e-03, -5.266824967161410e-06, -5.099861823351535e-09,
  2.958873124509421e-11,  1.536172754872369e-13,  1.813478918438748e-16, -1.339771544513059e-18, -7.366540880622293e-21, -8.030652446092407e-24,  7.946951517906510e-26,
  4.244293857815133e-28,  1.695305596451054e+00, -1.632303855463860e-03, -5.152519389567473e-06, -8.047677043511765e-09,  1.561923333428114e-11,  1.440327156365458e-13,
  3.796978226942465e-16, -3.232952042725638e-19, -6.508617812830084e-21, -2.258896290790717e-23,  5.547063988268262e-28,  3.462881886030812e-28,  1.750377393215191e+00,
 -1.393815854579514e-03, -4.837385193267379e-06, -1.014719233615122e-08,  9.693571103965017e-13,  1.099110068855067e-13,  4.661886615274041e-16,  6.820216927543343e-19,
 -3.183241372267536e-21, -2.438169697547305e-23, -6.800469327663337e-26,  4.388603092766605e-29,  1.801110797632298e+00, -1.152800768164423e-03, -4.342662905539427e-06,
 -1.120751492976380e-08, -1.210084974356161e-11,  5.972830232620482e-14,  4.227456284973010e-16,  1.310131886777529e-18,  9.017396588083107e-22, -1.363287842470904e-23,
 -8.289479881883537e-26, -2.282089968650649e-28,  1.847012689034612e+00, -9.166568382404580e-04, -3.704574307498562e-06, -1.116095837224429e-08, -2.157475012028145e-11,
  6.084121147363560e-15,  2.746742445950680e-16,  1.362909737124850e-18,  3.721563253215434e-21,  1.741388486959637e-24, -4.273203713318557e-26, -2.636775580734537e-28,
  1.887615918259572e+00, -6.931076133405138e-04, -2.972787589744573e-06, -1.008582731279767e-08, -2.613828425689388e-11, -3.776639194965528e-14,  8.277424022911403e-17,
  9.079974004747432e-19,  4.105096556764354e-21,  1.171831852172436e-23,  1.253810129177954e-26, -9.032217148521964e-29,  1.922489862264659e+00, -4.898756481071477e-04,
 -2.207205752179737e-06, -8.207607471608756e-09, -2.552765990700998e-11, -6.201131247708361e-14, -8.066701286858548e-17,  2.409575225240786e-19,  2.406926199555387e-21,
  1.146961111811376e-23,  3.859661457193927e-26,  8.408597212752022e-29,  1.951251092669187e+00, -3.143149183908223e-04, -1.473192992713687e-06, -5.874307956319829e-09,
 -2.064742206989526e-11, -6.356746305540142e-14, -1.627243676251938e-16, -2.818860811136478e-19,  1.544093303164970e-22,  4.364077688317478e-24,  2.562196758548290e-26,
  1.075445747915136e-28,  1.973573673915662e+00, -1.730257926345833e-04, -8.356262624825257e-07, -3.506751776051765e-09, -1.338867251571618e-11, -4.715556850341472e-14,
 -1.528582948441828e-16, -4.475680432120204e-19, -1.123711940523120e-21, -2.029119543577278e-24,  1.892758802858468e-28,  2.576179688440207e-29,  1.989198707957023e+00,
 -7.148127802563657e-05, -3.524132671230853e-07, -1.530600654800366e-09, -6.161469971172973e-12, -2.347542561831045e-14, -8.544662855960593e-17, -2.980983821167441e-19,
 -9.958662771888618e-22, -3.169208449685668e-24, -9.498154370795641e-27, -2.618368624190835e-29,  1.997944850420106e+00, -1.368196519229850e-05, -6.822956658977425e-08,
 -3.019436417733603e-10, -1.250129959879054e-12, -4.956547573413220e-15, -1.905042807888710e-17, -7.148479616463867e-20, -2.630332660068769e-22, -9.517243558698330e-25,
 -3.392285327047534e-27, -1.192407494722537e-29,  4.651378568737062e-04, -2.257587952485397e-06,  8.216358007759150e-09, -2.657407720574120e-11,  8.054906983459164e-14,
 -2.343006438832562e-16,  6.622824433465338e-19, -1.832913749554400e-21,  4.990317559062964e-24, -1.341063931645691e-26,  3.565023620203209e-29, -9.391784434232240e-32,
  4.185104642992612e-03, -2.028560978094006e-05,  7.361780898912914e-08, -2.369338472449521e-10,  7.127835160556037e-13, -2.051207095236463e-15,  5.714267585732297e-18,
 -1.551649340809256e-20,  4.123282175541875e-23, -1.074961632873199e-25,  2.752749068263742e-28, -6.928513504411002e-31,  1.161896550615141e-02, -5.616729348732627e-05,
  2.026678330115013e-07, -6.458206680832076e-10,  1.913208859297633e-12, -5.384649855336182e-15,  1.454577193279497e-17, -3.789223944645248e-20,  9.529611570053290e-23,
 -2.310036773785764e-25,  5.370085254994968e-28, -1.185783968367218e-30,  2.275450926543851e-02, -1.095536509767470e-04,  3.918799548251381e-07, -1.229933063767001e-09,
  3.557555907530000e-12, -9.663701101923567e-15,  2.480442966947571e-17, -6.006311766482318e-20,  1.358553755134445e-22, -2.804228622363321e-25,  4.985971911834023e-28,
 -6.276549913242610e-31,  3.757325418546942e-02, -1.799205559469494e-04,  6.360732103016438e-07, -1.955229156896835e-09,  5.468869572243863e-12, -1.410477276873828e-14,
  3.342397905651906e-17, -7.123438094765799e-20,  1.285422029076821e-22, -1.575828236770325e-25, -8.392466591124458e-29,  1.460440005576856e-30,  5.605024846780172e-02,
 -2.665680456332124e-04,  9.284321728948437e-07, -2.778019824818214e-09,  7.428572722468614e-12, -1.779413927251729e-14,  3.712623832775173e-17, -6.133083424331068e-20,
  4.795985096855547e-23,  1.811311597880290e-25, -1.195950959776353e-27,  4.507556798013558e-30,  7.815380167888379e-02, -3.686195174566667e-04,  1.260589521721438e-06,
 -3.646426119166241e-09,  9.190743791037032e-12, -1.978989249287087e-14,  3.300491727009446e-17, -2.379094356622655e-20, -1.110082335870893e-22,  6.868413602372188e-25,
 -2.468433057738554e-27,  6.793954436886004e-30,  1.038451449744087e-01, -4.850209362146821e-04,  1.622733289837909e-06, -4.502198033219912e-09,  1.049916938022852e-11,
 -1.923642178773745e-14,  1.912316784918007e-17,  4.197033483140141e-20, -3.256668155313738e-22,  1.206909592304104e-24, -3.229776526911651e-27,  6.035975615118564e-30,
  1.330780175209464e-01, -6.145402041995650e-04,  2.003741414384318e-06, -5.282887331286394e-09,  1.110658507888664e-11, -1.548286312231638e-14, -4.953204715607330e-18,
  1.289551474098381e-19, -5.444610746405802e-22,  1.510519146576894e-24, -2.724643317086585e-27,  5.641846854462649e-31,  1.657981761198283e-01, -7.557668886780416e-04,
  2.391346641040803e-06, -5.924360171565196e-09,  1.079534771134025e-11, -8.195460106503796e-15, -3.776942964442955e-17,  2.223032946483548e-19, -6.941392129043743e-22,
  1.352190050985061e-24, -4.571057311119240e-28, -9.324121436450759e-30,  2.019428247313062e-01, -9.071125495940221e-04,  2.772335183960531e-06, -6.363624979048654e-09,
  9.398590344570033e-12,  2.547446685666435e-15, -7.582214195531070e-17,  3.006742833306455e-19, -6.952900304887252e-22,  5.626393079854719e-25,  3.447919542431551e-27,
 -2.049720544005813e-29,  2.414399604130746e-01, -1.066811966201892e-03,  3.132782767154446e-06, -6.541936735062101e-09,  6.820701141268506e-12,  1.618985545634997e-14,
 -1.136943118470103e-16,  3.394043571791667e-19, -4.844179465042463e-22, -8.555454104198389e-25,  8.015329330733922e-27, -2.728344839953705e-29,  2.842076321708874e-01,
 -1.232925625497084e-03,  3.458331717068882e-06, -6.408119817424704e-09,  3.055747094726387e-12,  3.167408810438092e-14, -1.445297670821868e-16,  3.152520507229373e-19,
 -3.854744647012973e-23, -2.658995194722793e-24,  1.147559767224452e-26, -2.330750059802692e-29,  3.301531094277694e-01, -1.403343908433782e-03,  3.734512562934202e-06,
 -5.922027089335928e-09, -1.797750853498115e-12,  4.746951793768031e-14, -1.608572389995647e-16,  2.121877226137185e-19,  6.035770406241418e-22, -4.355479365359157e-24,
  1.170218686315793e-26, -4.632766312605997e-30,  3.791719573257433e-01, -1.575793492224786e-03,  3.947113033279782e-06, -5.058022620398660e-09, -7.527469594428289e-12,
  6.166295101260946e-14, -1.557261684741673e-16,  2.730633174414943e-20,  1.330770811303866e-21, -5.283247364927625e-24,  7.007399291297918e-27,  2.681456519151876e-29,
  4.311470169727155e-01, -1.747846578037298e-03,  4.082596290528983e-06, -3.808339119410417e-09, -1.380526049700212e-11,  7.211556689131512e-14, -1.240576688030124e-16,
 -2.243883412626025e-19,  1.965987020123822e-21, -4.784911346681239e-24, -2.891761594364175e-27,  6.123147130241732e-29,  4.859472901523287e-01, -1.916933651618576e-03,
  4.128568570704089e-06, -2.186119380797176e-09, -2.019435511630300e-11,  7.668526472822207e-14, -6.404821080748071e-17, -5.077785184906700e-19,  2.294792251757662e-21,
 -2.452305236915898e-24, -1.609118574446236e-26,  8.216335385191213e-29,  5.434267300670028e-01, -2.080360586771623e-03,  4.074293916122916e-06, -2.279052912805274e-10,
 -2.616753467902677e-11,  7.350494370639603e-14,  2.160135703304185e-17, -7.694170848926519e-19,  2.115823634441350e-21,  1.618024400992507e-24, -2.834704948728881e-26,
  7.202739400087700e-29,  6.034229425530253e-01, -2.235331002968939e-03,  3.911250209741964e-06,  2.004708850949443e-09, -3.113757790286324e-11,  6.129673905776633e-14,
  1.249104756815335e-16, -9.443249605435994e-19,  1.306667048144377e-21,  6.651529064258881e-24, -3.393644797316211e-26,  2.118345468626422e-29,  6.657558060896657e-01,
 -2.378974880621031e-03,  3.633716038184129e-06,  4.424584848203012e-09, -3.450054819080133e-11,  3.969005618411444e-14,  2.325973034556006e-16, -9.680029685173775e-19,
 -1.092249622423966e-22,  1.121041063887494e-23, -2.763254327868506e-26, -6.267178571380695e-29,  7.302260240477673e-01, -2.508384508603461e-03,  3.239371842659896e-06,
  6.920068540106575e-09, -3.569131484238928e-11,  9.498592345370601e-15,  3.270803241254000e-16, -7.925900282594221e-19, -1.915984388918778e-21,  1.347881815036092e-23,
 -7.398215013779296e-27, -1.501099211234943e-28,  7.966136292347307e-01, -2.620658871637942e-03,  2.729891238981219e-06,  9.357904039217056e-09, -3.424906663972450e-11,
 -2.709949357189821e-14,  3.886682772909172e-16, -4.044919910013234e-19, -3.703803932773875e-21,  1.182875021082595e-23,  2.318813508107562e-26, -1.960478232046782e-28,
  8.646764691487747e-01, -2.712957557017984e-03,  2.111489298724473e-06,  1.158837401366110e-08, -2.988846578869600e-11, -6.654035293269583e-14,  3.989089882267076e-16,
  1.608420461690043e-19, -4.933011701132614e-21,  5.558280088863147e-24,  5.417996431145019e-26, -1.584922769924968e-28,  9.341487106986736e-01, -2.782565140979134e-03,
  1.395384195349967e-06,  1.345292468702452e-08, -2.256959668830230e-11, -1.040715532275716e-13,  3.447810138685012e-16,  8.124873262595063e-19, -5.069931839550420e-21,
 -4.444135253431086e-24,  7.147388624285738e-26, -2.520133476680500e-29,  1.004739415668499e+00, -2.826966767303217e-03,  5.981174760651968e-07,  1.479437953311078e-08,
 -1.255722599318724e-11, -1.342105025276537e-13,  2.230589847662557e-16,  1.411425009508762e-18, -3.775522972862516e-21, -1.545448529587048e-23,  6.232077285102142e-26,
  1.648322635328061e-28,  1.076131252998225e+00, -2.843935210158314e-03, -2.583326556014622e-07,  1.546959834127633e-08, -4.575487359413573e-13, -1.514727203566255e-13,
  4.383049800289166e-17,  1.795245687958338e-18, -1.096078106224663e-21, -2.341193569197076e-23,  2.268851722809364e-26,  3.226777726216593e-28,  1.147979430916857e+00,
 -2.831629070664951e-03, -1.146719613877455e-06,  1.536408513082324e-08,  1.278076852056440e-11, -1.513238657517381e-13, -1.680957906169366e-16,  1.819300417679274e-18,
  2.422078029852781e-21, -2.427472351357359e-23, -3.698030132976938e-26,  3.453444613350824e-28,  1.219910950727874e+00, -2.788700843397455e-03, -2.035057432112210e-06,
  1.440758956114914e-08,  2.591390837682520e-11, -1.312373727963380e-13, -3.751187284096803e-16,  1.406882926323669e-18,  5.778072487342374e-21, -1.593748455526730e-23,
 -9.204109189060383e-26,  1.788681778488908e-28,  1.291524303819820e+00, -2.714412364984274e-03, -2.887586667818673e-06,  1.258920648331846e-08,  3.750778112695569e-11,
 -9.166059321784088e-14, -5.328721050708338e-16,  5.938255585298986e-19,  7.773426467447594e-21,  7.089544074927091e-26, -1.128176596509296e-25, -1.248839986858146e-28,
  1.362389752915586e+00, -2.608753604485663e-03, -3.666238843999863e-06,  9.969918141417403e-09,  4.610231175885758e-11, -3.662724093766399e-14, -6.001165249658690e-16,
 -4.519916489438175e-19,  7.451871889601268e-21,  1.817907432783522e-23, -8.083391465691872e-26, -4.058045271396316e-28,  1.432050355640751e+00, -2.472558897781769e-03,
 -4.332630724976578e-06,  6.690051876998311e-09,  5.042535748675549e-11,  2.626664459191286e-14, -5.508038179850585e-16, -1.454306569736094e-18,  4.582591172062245e-21,
  3.047711238064379e-23, -4.024127890580310e-27, -4.763691195227315e-28,  1.500023900331080e+00, -2.307612654027906e-03, -4.850569911726281e-06,  2.968903179616271e-09,
  4.963126504190824e-11,  8.674681666607313e-14, -3.850471197491009e-16, -2.102325814718895e-18, -4.531590774393426e-23,  3.038455837513707e-23,  8.065856232009658e-26,
 -2.558370998931780e-28,  1.565805926919424e+00, -2.116734449859636e-03, -5.188982179206370e-06, -9.060002892608160e-10,  4.352270636523677e-11,  1.336626457647370e-13,
 -1.346905367368065e-16, -2.160989457347969e-18, -4.750605810936187e-21,  1.671128945178712e-23,  1.245271855944421e-25,  1.372400252171125e-28,  1.628873995337529e+00,
 -1.903831566777754e-03, -5.325080673437597e-06, -4.601640118762402e-09,  3.270142293033999e-11,  1.574925799530647e-13,  1.404952033527490e-16, -1.579476198126126e-18,
 -7.593884636136636e-21, -4.474073813512334e-24,  9.843918391436166e-26,  4.353209825764967e-28,  1.688693335385969e+00, -1.673905828517528e-03, -5.247495411703444e-06,
 -7.774232460511003e-09,  1.859015707232107e-11,  1.530125505456993e-13,  3.676076540938688e-16, -5.445468655543242e-19, -7.317556311417785e-21, -2.224085275928676e-23,
  1.737738151819862e-26,  4.185365563238399e-28,  1.744723961044671e+00, -1.433001566647016e-03, -4.958983915353956e-06, -1.011348267608101e-08,  3.280946354036698e-12,
  1.213163537613175e-13,  4.837235073588119e-16,  5.655939991533170e-19, -4.109310929445750e-21, -2.704445016092156e-23, -6.464262400254250e-26,  1.112193273006054e-28,
  1.796429255659574e+00, -1.188083229125838e-03, -4.478273525707668e-06, -1.139100821190598e-08, -1.080183852461940e-11,  7.031718556610256e-14,  4.597548436584244e-16,
  1.330475512433060e-18,  3.488653457370657e-22, -1.714786275722185e-23, -9.279470766855469e-26, -2.199645502951278e-28,  1.843285931990393e+00, -9.468350153940406e-04,
 -3.840571772196863e-06, -1.150480952193805e-08, -2.138398504976958e-11,  1.314774341790354e-14,  3.145099149879865e-16,  1.482649489396828e-18,  3.750579372396276e-21,
 -2.121181238625828e-25, -5.524783325769661e-26, -3.054682591659147e-28,  1.884795146570050e+00, -7.173812000424373e-04, -3.096351344694423e-06, -1.050996562978987e-08,
 -2.687160855802278e-11, -3.545948597374974e-14,  1.101013122183907e-16,  1.046198629750941e-18,  4.534928782202648e-21,  1.212960563995627e-23,  7.745869095427602e-27,
 -1.288357837106315e-28,  1.920494410674289e+00, -5.079342977352814e-04, -2.308188958738204e-06, -8.626074574409362e-09, -2.678665310896393e-11, -6.385726325618509e-14,
 -7.277765956823542e-17,  3.248908429022629e-19,  2.848510591912753e-21,  1.308711278627703e-23,  4.226322279903113e-26,  8.197327638676373e-29,  1.949969807402584e+00,
 -3.263881432276584e-04, -1.545709489885618e-06, -6.215052367682259e-09, -2.195846096873797e-11, -6.756685078413098e-14, -1.705229187757451e-16, -2.742239082708898e-19,
  3.311514190823772e-22,  5.488796809150934e-24,  3.074669292066257e-26,  1.257662991508742e-28,  1.972867928974381e+00, -1.798828415315516e-04, -8.790243765253121e-07,
 -3.728719089295661e-09, -1.436950624684529e-11, -5.097868117137399e-14, -1.659045806204465e-16, -4.846917728051040e-19, -1.196328254524858e-21, -1.996373938998491e-24,
  1.513772016653049e-27,  3.479913688918479e-29,  1.988907025493018e+00, -7.437576533479183e-05, -3.713878387184843e-07, -1.633054568901649e-09, -6.652180829356103e-12,
 -2.563001491149805e-14, -9.425721920234276e-17, -3.318672002602781e-19, -1.117082339074005e-21, -3.573084500799375e-24, -1.071861017642318e-26, -2.933622079887596e-29,
  1.997889007448365e+00, -1.424264275396804e-05, -7.197625645916901e-08, -3.227643085633705e-10, -1.354000195004945e-12, -5.438760487636806e-15, -2.117518483882134e-17,
 -8.047730467289272e-20, -2.998697526298914e-22, -1.098520686302856e-24, -3.963354100278146e-27, -1.409773221367419e-29,  4.562369776302892e-04, -2.193111085393658e-06,
  7.905049904141949e-09, -2.532193370540961e-11,  7.601793909620984e-14, -2.190041157226297e-16,  6.131258586181482e-19, -1.680680776247056e-21,  4.532237530802976e-24,
 -1.206392492294830e-26,  3.176574969682045e-29, -8.289392438851686e-32,  4.105122351498639e-03, -1.970784932672456e-05,  7.084169998285839e-08, -2.258501977980023e-10,
  6.730963626216714e-13, -1.919132618305020e-15,  5.297711117962825e-18, -1.425689399169823e-20,  3.755402562863421e-23, -9.707142432331016e-26,  2.465246857953914e-28,
 -6.155798710658871e-31,  1.139749065919395e-02, -5.457643788569462e-05,  1.950981596464909e-07, -6.160522572562064e-10,  1.808922656673740e-12, -5.047946069025740e-15,
  1.352626067208229e-17, -3.497177618077742e-20,  8.735436314028613e-23, -2.105331824176305e-25,  4.873292813102699e-28, -1.074136840123875e-30,  2.232247261289258e-02,
 -1.064766949514857e-04,  3.774560086168969e-07, -1.174526579527332e-09,  3.370101225240102e-12, -9.088093936062658e-15,  2.318203506391607e-17, -5.587347417535590e-20,
  1.261124710014976e-22, -2.610328850750251e-25,  4.708827879900654e-28, -6.302939370846699e-31,  3.686360260776312e-02, -1.749243548909634e-04,  6.131263020977126e-07,
 -1.869941092371440e-09,  5.194636692144972e-12, -1.332607247676126e-14,  3.148614654086999e-17, -6.721232575174424e-20,  1.228234674108441e-22, -1.597433466704056e-25,
 -2.620394347568196e-29,  1.171642070932760e-30,  5.499862288783366e-02, -2.592719393653085e-04,  8.957974890800283e-07, -2.661961891603010e-09,  7.081462056554487e-12,
 -1.692353758568089e-14,  3.543137763117686e-17, -5.970064334719281e-20,  5.366560724320453e-23,  1.370764994394350e-25, -1.011176234992167e-27,  3.904101926747546e-30,
  7.669921940295710e-02, -3.587073596564757e-04,  1.217701797143499e-06, -3.502497796321903e-09,  8.802811183459067e-12, -1.900614746115952e-14,  3.229262381213896e-17,
 -2.696606998628866e-20, -8.798899209164951e-23,  5.938836120401054e-25, -2.184299452310269e-27,  6.128761651001329e-30,  1.019306867884746e-01, -4.722523487029522e-04,
  1.569702219479488e-06, -4.337263835134918e-09,  1.011911977457276e-11, -1.876450207005675e-14,  2.015879551236979e-17,  3.221975911738642e-20, -2.844799887145153e-22,
  1.082975922749970e-24, -2.968375845149298e-27,  5.834667505361143e-30,  1.306515193011966e-01, -5.987608540552130e-04,  1.941402762234960e-06, -5.107664494234075e-09,
  1.079602155317911e-11, -1.556033038181957e-14, -1.578353823601639e-18,  1.123814824425580e-19, -4.920357190343872e-22,  1.402293106030881e-24, -2.680563562291687e-27,
  1.401697960122973e-30,  1.628129239885991e-01, -7.369175612701292e-04,  2.321285109495668e-06, -5.752993061392963e-09,  1.062286524824252e-11, -9.029697684422430e-15,
 -3.184862332364646e-17,  2.008654089979849e-19, -6.458824525473453e-22,  1.326344607257540e-24, -8.198360371705649e-28, -7.218717153598074e-30,  1.983582518737468e-01,
 -8.852367624609764e-04,  2.696875317639903e-06, -6.212935996703859e-09,  9.432010982656434e-12,  8.262472937564213e-16, -6.771152714015633e-17,  2.787739883565059e-19,
 -6.727619921924497e-22,  6.833797410044192e-25,  2.609963450904111e-27, -1.763313988688188e-29,  2.372223425357494e-01, -1.042061838135954e-03,  3.054944527455060e-06,
 -6.430360198039450e-09,  7.117972218938140e-12,  1.357345387674913e-14, -1.044122115427787e-16,  3.234697579483614e-19, -5.097299163609423e-22, -5.582875882011465e-25,
  6.863934605013960e-27, -2.503684881020663e-29,  2.793307771946235e-01, -1.205565683413516e-03,  3.381747933577181e-06, -6.354345479038905e-09,  3.655255620032308e-12,
  2.831107366460108e-14, -1.357337494419377e-16,  3.125735288601545e-19, -1.262571610056085e-22, -2.220600599433670e-24,  1.044235276238001e-26, -2.355413445329275e-29,
  3.245990353240708e-01, -1.373752483417762e-03,  3.663306309811062e-06, -5.943403680491908e-09, -8.864743137769645e-13,  4.368228014893052e-14, -1.546685107243752e-16,
  2.290832936239741e-19,  4.551441021176876e-22, -3.892785344540676e-24,  1.140189842445626e-26, -8.838316540056479e-30,  3.729315499870218e-01, -1.544461328106049e-03,
  3.885734165428094e-06, -5.168798784371521e-09, -6.331498792946703e-12,  5.793933621051079e-14, -1.543936004705112e-16,  6.690410446849874e-20,  1.145881202402336e-21,
 -4.981796772361416e-24,  8.006596321213421e-27,  1.877808836988013e-29,  4.242206576094050e-01, -1.715372254467101e-03,  4.035617982809538e-06, -4.017848578182911e-09,
 -1.239319584999534e-11,  6.906973753043869e-14, -1.294858055650951e-16, -1.642500851459259e-19,  1.792272356673819e-21, -4.849449858408671e-24, -4.028144071777475e-28,
  5.194696396961040e-29,  4.783454388962456e-01, -1.884015413652224e-03,  4.100446808927119e-06, -2.497047625016803e-09, -1.867713051070802e-11,  7.498570621401820e-14,
 -7.725205943094410e-17, -4.358749402032185e-19,  2.195780568238026e-21, -3.025237518251353e-24, -1.259696752307254e-26,  7.646687842088663e-29,  5.351704492009296e-01,
 -2.047784180591337e-03,  4.069095554123970e-06, -6.348040735722980e-10, -2.469395677624946e-11,  7.377254910573956e-14,  1.012800435733463e-18, -7.009913143737574e-19,
  2.154437200066546e-21,  5.486717567354494e-25, -2.509717637088785e-26,  7.524728761634524e-29,  5.945443390696660e-01, -2.203953150502340e-03,  3.932358467591162e-06,
  1.516469063788052e-09, -2.988378101261010e-11,  6.398223413551156e-14,  9.908890577960310e-17, -8.989402202889641e-19,  1.521954843288435e-21,  5.317319831550549e-24,
 -3.266574932486169e-26,  3.604828204348389e-29,  6.562983691259958e-01, -2.349702094138267e-03,  3.683526156477810e-06,  3.879220575229106e-09, -3.365311963198534e-11,
  4.494711266273921e-14,  2.055034082440370e-16, -9.652592645214053e-19,  2.738540761723458e-22,  1.005699193507944e-23, -2.986732384059730e-26, -3.919379655530657e-29,
  7.202448282050596e-01, -2.482147061438956e-03,  3.318993928670119e-06,  6.350946125762356e-09, -3.542467522362297e-11,  1.707572767988652e-14,  3.041019095329551e-16,
 -8.462073824803167e-19, -1.437607408539687e-21,  1.305719025373816e-23, -1.352160253304541e-26, -1.279425381428955e-28,  7.861753700068841e-01, -2.598379915996847e-03,
  2.838881922032883e-06,  8.806085790823705e-09, -3.469876103746977e-11, -1.792035772545804e-14,  3.757483935544706e-16, -5.160381277981579e-19, -3.263338304704151e-21,
  1.258537903647407e-23,  1.469384081824580e-26, -1.891241427330035e-28,  8.538592918596546e-01, -2.695517628093699e-03,  2.247638265948054e-06,  1.110003349469957e-08,
 -3.112326125059995e-11, -5.693013255813129e-14,  4.012355588794567e-16,  6.591492110018355e-21, -4.695641553886403e-21,  7.579865322883678e-24,  4.676062928829622e-26,
 -1.775302652751646e-28,  9.230417898325990e-01, -2.770762621192377e-03,  1.554585399778743e-06,  1.307561668928717e-08, -2.456653289084228e-11, -9.554227419740970e-14,
  3.652391953273876e-16,  6.482385004130158e-19, -5.178847262507100e-21, -1.620531791036414e-24,  6.938820519004419e-26, -6.885028938701670e-29,  9.934422377632753e-01,
 -2.821475314887095e-03,  7.743569361453516e-07,  1.457229429046510e-08, -1.518477345021136e-11, -1.283969969227710e-13,  2.608073191229982e-16,  1.282200928656555e-18,
 -4.285397416988165e-21, -1.283112283807611e-23,  6.848262615156448e-26,  1.147918334253826e-28,  1.064752554045897e+00, -2.845259684918677e-03, -7.284114053556385e-08,
  1.543811609073950e-08, -3.472435969575232e-12, -1.498223211039842e-13,  9.348103652687006e-17,  1.746888433970765e-18, -1.919213061183304e-21, -2.222747845028278e-23,
  3.634044427426472e-26,  2.960778127969750e-28,  1.136635739393719e+00, -2.840062106470446e-03, -9.612241746374179e-07,  1.554416387859637e-08,  9.718116191623697e-12,
 -1.547389384887964e-13, -1.162035237505384e-16,  1.882569364142262e-18,  1.525292540166786e-21, -2.544271358132155e-23, -2.126194454345670e-26,  3.669199941649438e-28,
  1.208724691096198e+00, -2.804282892563154e-03, -1.859766785856383e-06,  1.480073872309722e-08,  2.320242887627969e-11, -1.397471712491228e-13, -3.332286543072116e-16,
  1.581907338483336e-18,  5.140139377052936e-21, -1.944102625894140e-23, -8.263452572551140e-26,  2.476666692010860e-28,  1.280621423966540e+00, -2.736898718107632e-03,
 -2.732978173210543e-06,  1.317397657985979e-08,  3.554817191936140e-11, -1.042219186629974e-13, -5.127683757018818e-16,  8.417357118734446e-19,  7.693634973761907e-21,
 -4.528611004430789e-24, -1.165717064537607e-25, -4.448451634817183e-29,  1.351896854013376e+00, -2.637592480115036e-03, -3.542200723818962e-06,  1.070090840840748e-08,
  4.522485559970911e-11, -5.115437921882410e-14, -6.093401160320711e-16, -2.037190022363344e-19,  8.043902097107553e-21,  1.459843771760326e-23, -9.792144597450608e-26,
 -3.678477296496669e-28,  1.422091325811982e+00, -2.506885070202840e-03, -4.247494295827221e-06,  7.500328477833166e-09,  5.081528902911077e-11,  1.257628825299206e-14,
 -5.893069217089246e-16, -1.290181668008319e-18,  5.671702844008842e-21,  2.988446286424866e-23, -2.588947720552082e-26, -5.149090489377181e-28,  1.490716085461038e+00,
 -2.346261077771291e-03, -4.810122900331012e-06,  3.776360805577260e-09,  5.126902551287303e-11,  7.680017285439465e-14, -4.437637991407476e-16, -2.085675421842928e-18,
  1.103635356863457e-21,  3.335783576767415e-23,  6.731203346808475e-26, -3.509522973499134e-28,  1.557255913528112e+00, -2.158277755208284e-03, -5.195588411392479e-06,
 -1.884474747710141e-10,  4.615864613324740e-11,  1.296873927571678e-13, -1.972291557109050e-16, -2.302411339241156e-18, -4.058092903471031e-21,  2.179000966451992e-23,
  1.288042055099409e-25,  5.423902631555559e-29,  1.621173130929361e+00, -1.946643955601586e-03, -5.377056521985131e-06, -4.053050865612316e-09,  3.588126868207060e-11,
  1.603061806163781e-13,  9.284923091463335e-17, -1.824260158908944e-18, -7.679460740214751e-21, -1.538817706039804e-25,  1.175256587805792e-25,  4.291166308486066e-28,
  1.681913168752792e+00, -1.716253662780791e-03, -5.338899020423851e-06, -7.451834248443010e-09,  2.173725901841404e-11,  1.616249721054902e-13,  3.489628804738582e-16,
 -7.913479519958896e-19, -8.101083725946445e-21, -2.115623304593155e-23,  3.737436072148012e-26,  4.899707874256199e-28,  1.738911843918949e+00, -1.473157804196322e-03,
 -5.079948610532176e-06, -1.004094103693553e-08,  5.824569161787087e-12,  1.330999810666617e-13,  4.975693076048399e-16,  4.180303293730838e-19, -5.128067553542473e-21,
 -2.950935941854066e-23, -5.801026001578953e-26,  1.925784736813283e-28,  1.791604400648028e+00, -1.224459012985635e-03, -4.615954214755463e-06, -1.155197467703065e-08,
 -9.282132128057823e-12,  8.179900660097555e-14,  4.970664297653983e-16,  1.331027015185580e-18, -3.375576547186209e-22, -2.104811271094088e-23, -1.020666297228272e-25,
 -1.991594046656396e-28,  1.839436260233279e+00, -9.781176141524378e-04, -3.980672303870821e-06, -1.184442516428284e-08, -2.104211514955942e-11,  2.120769073154874e-14,
  3.577000154785906e-16,  1.602092297575567e-18,  3.699811597403267e-21, -2.703353684693090e-24, -6.962344774580099e-26, -3.479303217639303e-28,  1.881875271002456e+00,
 -7.426638511427269e-04, -3.225073516931032e-06, -1.094543105234168e-08, -2.755191471629719e-11, -3.244872811011839e-14,  1.414925256760516e-16,  1.198350935761008e-18,
  4.975686364441861e-21,  1.231286159306662e-23,  1.074068750662830e-27, -1.759259722772434e-28,  1.918425076463539e+00, -5.268212446178889e-04, -2.414315816626599e-06,
 -9.064969804377313e-09, -2.808047303662047e-11, -6.548401638043252e-14, -6.233138914813272e-17,  4.239146006099215e-19,  3.350932058000289e-21,  1.484824320553189e-23,
  4.574652941476813e-26,  7.552753710756373e-29,  1.948639042564566e+00, -3.390582185209239e-04, -1.622443452037107e-06, -6.577423387838119e-09, -2.335133842962778e-11,
 -7.175015128432235e-14, -1.780213703084985e-16, -2.602169796431716e-19,  5.522724538656950e-22,  6.835203443938771e-24,  3.672286133618306e-26,  1.462545280685877e-28,
  1.972134044213729e+00, -1.870980024821060e-04, -9.251828377040824e-07, -3.967008810745486e-09, -1.543001888757450e-11, -5.512763937689303e-14, -1.800226081158971e-16,
 -5.241093204770495e-19, -1.266710191766882e-21, -1.902022349029906e-24,  3.287148834526649e-27,  4.625096657811682e-29,  1.988603453507287e+00, -7.742710382918832e-05,
 -3.916404256681129e-07, -1.743716409571363e-09, -7.188176926380784e-12, -2.800785679848142e-14, -1.040698960946313e-16, -3.697572629578122e-19, -1.253750814815159e-21,
 -4.028631703699878e-24, -1.208363104350932e-26, -3.275195829737533e-29,  1.997830860196092e+00, -1.483432223070216e-05, -7.598309334793363e-08, -3.453269119337214e-10,
 -1.468045734757772e-12, -5.975127293107956e-15, -2.356906159457562e-17, -9.073773825378490e-20, -3.424262112162923e-22, -1.270192877634132e-24, -4.639199267363203e-27,
 -1.670015072210523e-29,  4.475891183786714e-04, -2.131065789869057e-06,  7.608342425938391e-09, -2.413990353255251e-11,  7.178127823075609e-14, -2.048378079858574e-16,
  5.680336572755425e-19, -1.542359721282546e-21,  4.119955432524295e-24, -1.086330952031042e-26,  2.833523906857623e-29, -7.325001522131477e-32,  4.027407511455223e-03,
 -1.915177632700880e-05,  6.819487024503974e-08, -2.153809423228972e-10,  6.359535146393740e-13, -1.796645234728145e-15,  4.914830207155656e-18, -1.310922687053403e-20,
  3.423061396921061e-23, -8.773146339661086e-26,  2.209697009080634e-28, -5.474145837309676e-31,  1.118226034288655e-02, -5.304473864982206e-05,  1.878759137287780e-07,
 -5.878998552133226e-10,  1.711132325109052e-12, -4.734757327239254e-15,  1.258507258436888e-17, -3.229403209359112e-20,  8.011493492251708e-23, -1.919547061722493e-25,
  4.423325093807655e-28, -9.727988850686146e-31,  2.190251714135502e-02, -1.035125211109470e-04,  3.636793177252395e-07, -1.122029349400573e-09,  3.193778634307266e-12,
 -8.550051113528837e-15,  2.167268906758650e-17, -5.198464900240999e-20,  1.170476509715436e-22, -2.427508075646465e-25,  4.432715493995510e-28, -6.234033460026290e-31,
  3.617357506187704e-02, -1.701077086974593e-04,  5.911770301721090e-07, -1.788918650897353e-09,  4.935521752982438e-12, -1.259254949009699e-14,  2.965836092175492e-17,
 -6.337409292975562e-20,  1.170655819483328e-22, -1.598347573573186e-25,  1.987401418318452e-29,  9.299651520253379e-31,  5.397566826683531e-02, -2.522314328921956e-04,
  8.645227453211473e-07, -2.551320626998552e-09,  6.751360455675121e-12, -1.609304559510251e-14,  3.378448991048871e-17, -5.791186786706266e-20,  5.791223803865630e-23,
  9.990402294970041e-26, -8.513063978566624e-28,  3.374162733446620e-30,  7.528361034578719e-02, -3.491314994259672e-04,  1.176504485093286e-06, -3.364651953592913e-09,
  8.430375742241828e-12, -1.824048409246493e-14,  3.150125165840041e-17, -2.945598726640009e-20, -6.811858323857277e-23,  5.117194605103015e-25, -1.928413093998251e-27,
  5.510242005120116e-30,  1.000664668454778e-01, -4.599001955604327e-04,  1.518614190330153e-06, -4.178333663325237e-09,  9.748735752070809e-12, -1.827085860116463e-14,
  2.093920230651793e-17,  2.371777562664078e-20, -2.475688701207842e-22,  9.693027722494935e-25, -2.717166397484695e-27,  5.576194036414390e-30,  1.282871542611488e-01,
 -5.834718869950844e-04,  1.881136932735737e-06, -4.937418821965710e-09,  1.048468202192159e-11, -1.556218398741032e-14,  1.355338113641157e-18,  9.742349912079951e-20,
 -4.434664739996369e-22,  1.296502855924228e-24, -2.604377937741316e-27,  2.029865521628775e-30,  1.599019611385541e-01, -7.186205486274002e-04,  2.253262898818716e-06,
 -5.584511628872556e-09,  1.043507130380237e-11, -9.728865499235146e-15, -2.650661759163216e-17,  1.809542278440347e-19, -5.987958448755212e-22,  1.287746915117538e-24,
 -1.097027420446126e-27, -5.430378212611203e-30,  1.948599862686906e-01, -8.639574146454686e-04,  2.623225825190273e-06, -6.061977306786680e-09,  9.432904947815595e-12,
 -7.075705892663294e-16, -6.020341929121014e-17,  2.576579101143052e-19, -6.464609345901221e-22,  7.730476765844963e-25,  1.892433762505401e-27, -1.502441929497405e-29,
  2.331024883476765e-01, -1.017928983355154e-03,  2.978472056187768e-06, -6.314433997388553e-09,  7.365106397205474e-12,  1.117438672603037e-14, -9.558607326584251e-17,
  3.068877022099130e-19, -5.251455738749304e-22, -3.050864001674190e-25,  5.812903501726488e-27, -2.273421707367711e-29,  2.745621409565733e-01, -1.178815672400731e-03,
  3.305864812446380e-06, -6.291505647573192e-09,  4.189607247611859e-12,  2.515796080376073e-14, -1.270497087144157e-16,  3.073328242187130e-19, -1.989296093576580e-22,
 -1.823577745113677e-24,  9.411092562941958e-27, -2.324004276914715e-29,  3.191621863381728e-01, -1.344731492339295e-03,  3.591928547122783e-06, -5.950797583571272e-09,
 -4.942162482214433e-14,  4.004872731669501e-14, -1.480707188495898e-16,  2.414928608482388e-19,  3.231101735615065e-22, -3.445494910155737e-24,  1.093941928022021e-26,
 -1.202628560897170e-29,  3.668154812757082e-01, -1.513625192528719e-03,  3.823138345850020e-06, -5.261033091146726e-09, -5.209594075152902e-12,  5.426034961776711e-14,
 -1.520334428432105e-16,  1.007660860650342e-19,  9.724808577044530e-22, -4.647138498236329e-24,  8.675499004675984e-27,  1.180037345790594e-29,  4.174234285008073e-01,
 -1.683283434403949e-03,  3.986259088152173e-06, -4.205258852397263e-09, -1.104321740251531e-11,  6.591320970957731e-14, -1.333081122176412e-16, -1.096894513810011e-19,
  1.617928743822229e-21, -4.822504583586155e-24,  1.685201213918205e-27,  4.304225201744375e-29,  4.708747875923645e-01, -1.851336664342538e-03,  4.068738386154311e-06,
 -2.783988744881725e-09, -1.719690484948217e-11,  7.299303880281031e-14, -8.848987642219281e-17, -3.674432795289388e-19,  2.078595769323543e-21, -3.463735940743996e-24,
 -9.376721797174413e-27,  6.977708023597908e-29,  5.270443604276526e-01, -2.015268491399827e-03,  4.059155961654653e-06, -1.018108986554849e-09, -2.321981225546996e-11,
  7.356912516433818e-14, -1.764814279742101e-17, -6.319205372519862e-19,  2.156921080442669e-21, -3.886202650173200e-25, -2.176229949069650e-26,  7.595750743560317e-29,
  5.857915481086415e-01, -2.172429522584585e-03,  3.947729877065359e-06,  1.048686480259803e-09, -2.858236462864461e-11,  6.606399528922932e-14,  7.462741386938667e-17,
 -8.474237421880377e-19,  1.690275090099249e-21,  4.046081802940276e-24, -3.081098581160938e-26,  4.774364412374967e-29,  6.469587791581238e-01, -2.320056765932272e-03,
  3.726876611980391e-06,  3.348221008338112e-09, -3.270703926164478e-11,  4.955618381994009e-14,  1.786516023955415e-16, -9.509366644992656e-19,  6.140450254240622e-22,
  8.834293001698586e-24, -3.111111556332661e-26, -1.771225614444167e-29,  7.103698129684087e-01, -2.455299871616118e-03,  3.391817045639908e-06,  5.787271843607544e-09,
 -3.501212044743574e-11,  2.408507977694251e-14,  2.798339142127647e-16, -8.848048687134315e-19, -9.785787853000288e-22,  1.241056121861202e-23, -1.863957205022817e-26,
 -1.045790769006938e-28,  7.758279283599119e-01, -2.575255630646464e-03,  2.941213616265812e-06,  8.248523213308615e-09, -3.496821814728258e-11, -9.087163026387006e-15,
  3.599061778664050e-16, -6.131184297131761e-19, -2.801661888958718e-21,  1.300992125521530e-23,  6.621456849830533e-27, -1.770325988873413e-28,  8.431140151009411e-01,
 -2.677012269020881e-03,  2.377814955179284e-06,  1.059347546527350e-08, -3.216563905456197e-11, -4.731497918356155e-14,  3.993599794539058e-16, -1.389575696235613e-19,
 -4.391018323471543e-21,  9.290099228301933e-24,  3.866610656920427e-26, -1.891994165861986e-28,  9.119845968400125e-01, -2.757705132590690e-03,  1.709072913811860e-06,
  1.266774750488468e-08, -2.638834770480049e-11, -8.657748699867771e-14,  3.810647607545633e-16,  4.821110031971673e-19, -5.188064515034213e-21,  1.082679218575547e-24,
  6.549244929393256e-26, -1.072620909341145e-28,  9.821698276236667e-01, -2.814585312424793e-03,  9.476831216817914e-07,  1.430914641098158e-08, -1.768729342748986e-11,
 -1.217227054336754e-13,  2.947234670954654e-16,  1.138215143006763e-18, -4.696931136462601e-21, -1.000597401681865e-23,  7.239801019101330e-26,  6.309199817124991e-29,
  1.053371521512235e+00, -2.845102555829121e-03,  1.119844559512416e-07,  1.535872393927735e-08, -6.442523965185142e-12, -1.469994903124166e-13,  1.414159549870404e-16,
  1.672976026258010e-18, -2.690188416791274e-21, -2.052342492702659e-23,  4.859518957949108e-26,  2.594428761240364e-28,  1.125261296158026e+00, -2.847003372772088e-03,
 -7.738638382984438e-07,  1.567476198850896e-08,  6.599743137899746e-12, -1.568906157034206e-13, -6.294693272084875e-17,  1.916591377025671e-18,  5.979691065114389e-22,
 -2.596698087749502e-23, -4.894370800542014e-27,  3.747484247320415e-28,  1.197478936739731e+00, -2.818444495493360e-03, -1.680024086762911e-06,  1.514919889320591e-08,
  2.033119157351142e-11, -1.471952202881935e-13, -2.867421004208950e-16,  1.734578270136432e-18,  4.383562397615581e-21, -2.250985481970272e-23, -7.036296458424469e-26,
  3.085716066442112e-28,  1.269631116101774e+00, -2.758120686234402e-03, -2.571548759052638e-06,  1.372541168521702e-08,  3.334272121453425e-11, -1.162178991782633e-13,
 -4.857839670815305e-16,  1.084421285107768e-18,  7.446429640236180e-21, -9.205517675630594e-24, -1.166442328758042e-25,  4.187049991822728e-29,  1.341290639407693e+00,
 -2.665404224065729e-03, -3.409484576549809e-06,  1.141552540766318e-08,  4.405521663697816e-11, -6.581744703075017e-14, -6.113671418422209e-16,  6.130784033768178e-20,
  8.495178251051486e-21,  1.037311920188144e-23, -1.129350024680155e-25, -3.116461050246860e-28,  1.411996415179314e+00, -2.540491172979993e-03, -4.152606307872965e-06,
  8.314604951294198e-09,  5.092256518250565e-11, -1.979084206256865e-15, -6.227310348411688e-16, -1.091718387355393e-18,  6.723371657167901e-21,  2.838819442948305e-23,
 -4.907726623500871e-26, -5.359098901017724e-28,  1.481254386023327e+00, -2.384546737601872e-03, -4.759835984607434e-06,  4.608354804000646e-09,  5.269382074486936e-11,
  6.545417289370945e-14, -5.014842279997525e-16, -2.030657201408839e-18,  2.349006973060727e-21,  3.571366863631411e-23,  4.979779998355561e-26, -4.444828717807614e-28,
  1.548539676753263e+00, -2.199838757482413e-03, -5.193333850982563e-06,  5.705614860560935e-10,  4.869976449001048e-11,  1.241663692050123e-13, -2.633896630524697e-16,
 -2.418721899710714e-18, -3.180593764101760e-21,  2.696162468491114e-23,  1.290469790720684e-25, -4.589717316689954e-29,  1.613300228271281e+00, -1.989844950150171e-03,
 -5.422142384959448e-06, -3.453198368695040e-09,  3.910539527335878e-11,  1.618938700424928e-13,  3.833539609507724e-17, -2.069147656235872e-18, -7.595886311317479e-21,
  4.918454235708033e-24,  1.358950907860134e-25,  4.021463849201806e-28,  1.674962174052619e+00, -1.759316381866857e-03, -5.426126129911289e-06, -7.077731130574830e-09,
  2.505156043629853e-11,  1.697042024474938e-13,  3.230636620638432e-16, -1.062436711161191e-18, -8.830419163779279e-21, -1.920999406187748e-23,  6.042252699599549e-26,
  5.564729762280925e-28,  1.732937172921576e+00, -1.514277567421804e-03, -5.199790786572648e-06, -9.925799469686724e-09,  8.606833454078570e-12,  1.451625623767068e-13,
  5.068139888586575e-16,  2.365051113755958e-19, -6.229885250370027e-21, -3.163325167881783e-23, -4.749052665293298e-26,  2.878236551278608e-28,  1.786631827983542e+00,
 -1.261943537619689e-03, -4.755412874061491e-06, -1.168674013522834e-08, -7.523846666905130e-12,  9.417387665380326e-14,  5.340643336015442e-16,  1.307296907852203e-18,
 -1.170805213636772e-21, -2.529653510701184e-23, -1.100886684042748e-25, -1.626086616192854e-28,  1.835459190809734e+00, -1.010537213103792e-03, -4.124809898645685e-06,
 -1.217722384407121e-08, -2.052841109781209e-11,  3.034406273768653e-14,  4.041974757176739e-16,  1.718360962020080e-18,  3.548560486395961e-21, -5.806744272731836e-24,
 -8.584552306448382e-26, -3.889988148082086e-28,  1.878852171925472e+00, -7.689973621548607e-04, -3.359084459905836e-06, -1.139125724080231e-08, -2.816411848893225e-11,
 -2.863186001825738e-14,  1.773420633917603e-16,  1.364657317820284e-18,  5.417713254494688e-21,  1.218506210456748e-23, -7.876455834880583e-27, -2.325629060622020e-28,
  1.916278462579525e+00, -5.465786276330105e-04, -2.525834650863535e-06, -9.524811835599756e-09, -2.940408669467998e-11, -6.682491074777165e-14, -4.887764940730600e-17,
  5.400564989598359e-19,  3.919179447246827e-21,  1.674142854405650e-23,  4.882323935234948e-26,  6.320928394848811e-29,  1.947256341598457e+00, -3.523599446044594e-04,
 -1.703662374918238e-06, -6.962759405107721e-09, -2.482964543266181e-11, -7.610786223887608e-14, -1.850209395247331e-16, -2.383107081977033e-19,  8.263903328956436e-22,
  8.439356565137379e-24,  4.365050849836078e-26,  1.690048162959351e-28,  1.971370541748173e+00, -1.946941639160642e-04, -9.743053837369782e-07, -4.222949357456338e-09,
 -1.657698971812664e-11, -5.962892538612561e-14, -1.952752438681020e-16, -5.657100185032170e-19, -1.332289691167823e-21, -1.725824205324822e-24,  5.627844102003903e-27,
  6.069022032437466e-29,  1.988287343505192e+00, -8.064592427775265e-05, -4.132740221629158e-07, -1.863347808028378e-09, -7.774173458020981e-12, -3.063444372259309e-14,
 -1.150072644959580e-16, -4.122939483634909e-19, -1.407838686164988e-21, -4.541857665902885e-24, -1.360426554548821e-26, -3.640307614086226e-29,  1.997770280356870e+00,
 -1.545917126394990e-05, -8.027199423650819e-08, -3.698032847671719e-10, -1.593417231930107e-12, -6.572554433300262e-15, -2.627026341172730e-17, -1.024643117776505e-19,
 -3.916783875421305e-22, -1.471334718804188e-24, -5.440619008478583e-27, -1.982221954239595e-29,  4.391847812248321e-04, -2.071338547936346e-06,  7.325421753194222e-09,
 -2.302345083403799e-11,  6.781742756523109e-14, -1.917086890083427e-16,  5.266360567056514e-19, -1.416565814606290e-21,  3.748524442773232e-24, -9.791792521346216e-27,
  2.530211598033519e-29, -6.480287984798009e-32,  3.951875395776871e-03, -1.861638536079699e-05,  6.567018511324142e-08, -2.054868629973505e-10,  6.011710650042976e-13,
 -1.682973090540870e-15,  4.562644261895771e-18, -1.206272066955036e-20,  3.122574191685782e-23, -7.935614179059508e-26,  1.982346126927015e-28, -4.872296878855167e-31,
  1.097304337023675e-02, -5.156949219676550e-05,  1.809823115612775e-07, -5.612631905571047e-10,  1.619385823650117e-12, -4.443282949529287e-15,  1.171571618701739e-17,
 -2.983758733187478e-20,  7.351298277450316e-23, -1.750897655101625e-25,  4.015836845972911e-28, -8.809103290529251e-31,  2.149420186126930e-02, -1.006560880850209e-04,
  3.505160154589125e-07, -1.072269125624705e-09,  3.027863309791049e-12, -8.046958127506679e-15,  2.026826656372528e-17, -4.837558002126170e-20,  1.086211995526213e-22,
 -2.255648578546284e-25,  4.161283561889414e-28, -6.093714619731189e-31,  3.550246897207027e-02, -1.654628369817829e-04,  5.701756290135782e-07, -1.711927032038975e-09,
  4.690647202545072e-12, -1.190162452340114e-14,  2.793546821358019e-17, -5.971982942961985e-20,  1.113351316083579e-22, -1.582834627526542e-25,  5.622281960279700e-29,
  7.283268372848627e-31,  5.298038355945319e-02, -2.454359021276072e-04,  8.345445481992564e-07, -2.445830239541258e-09,  6.437477572768192e-12, -1.530146371892933e-14,
  3.218939775738223e-17, -5.600742176174897e-20,  6.093032835525399e-23,  6.867985853953939e-26, -7.132827975940217e-28,  2.909840037097228e-30,  7.390565590734116e-02,
 -3.398787012368582e-04,  1.136926071286800e-06, -3.232643626179338e-09,  8.073058351942445e-12, -1.749458108005208e-14,  3.064863287136803e-17, -3.135545496904611e-20,
 -5.102827738586345e-23,  4.392604244125255e-25, -1.698697912337999e-27,  4.939176520215073e-30,  9.825085004404741e-02, -4.479492179907577e-04,  1.469398095262025e-06,
 -4.025249713855445e-09,  9.388393288078776e-12, -1.776121227751417e-14,  2.149748823885635e-17,  1.633338851449519e-20, -2.145719711861774e-22,  8.654380276662794e-25,
 -2.478234507602795e-27,  5.279358352388095e-30,  1.259829936552129e-01, -5.686569594416908e-04,  1.822884173495691e-06, -4.772151192525205e-09,  1.017397647272085e-11,
 -1.549848273921413e-14,  3.891397493163725e-18,  8.395943542175681e-20, -3.986446547702662e-22,  1.194259317273824e-24, -2.504491080248449e-27,  2.484535344131451e-30,
  1.570631107148399e-01, -7.008596786596851e-04,  2.187243997716624e-06, -5.419139986846430e-09,  1.023453180012239e-11, -1.030634642487970e-14, -2.170125341310612e-17,
  1.625255946759561e-19, -5.532801540557567e-22,  1.239549490738574e-24, -1.301886139697970e-27, -3.925374329905032e-30,  1.914456711332262e-01, -8.432600187780688e-04,
  2.551386941689676e-06, -5.911240132993330e-09,  9.404877113400333e-12, -2.068190991433953e-15, -5.327433169117552e-17,  2.374297950856240e-19, -6.174214817226566e-22,
  8.362341157937248e-25,  1.284010175738400e-27, -1.267349262404400e-29,  2.290779509197629e-01, -9.944022802389578e-04,  2.903412877673171e-06, -6.194926150104179e-09,
  7.566339644154864e-12,  8.981527717513859e-15, -8.722982513949508e-17,  2.899502736617371e-19, -5.321782989388405e-22, -9.189937460572460e-26,  4.863135758550262e-27,
 -2.044377891991448e-29,  2.698992956074278e-01, -1.152669569420867e-03,  3.230785022528976e-06, -6.220609418587776e-09,  4.662967598736510e-12,  2.221125418280434e-14,
 -1.185428728490043e-16,  2.999873603966410e-19, -2.580471594702641e-22, -1.467393116952544e-24,  8.403581950533895e-27, -2.249448437158109e-29,  3.138402790246668e-01,
 -1.316281656057901e-03,  3.520540044682427e-06, -5.945371298821190e-09,  7.165692176381669e-13,  3.657722841388768e-14, -1.411822165198647e-16,  2.499311533326962e-19,
  2.068143933259941e-22, -3.019238195848536e-24,  1.035668292567414e-26, -1.432582081523938e-29,  3.608217489872492e-01, -1.483293951167166e-03,  3.759541000135683e-06,
 -5.335902171416929e-09, -4.160629045050310e-12,  5.064876872041581e-14, -1.488009884860310e-16,  1.292766016677639e-19,  8.115386365437480e-22, -4.291556643385014e-24,
  9.060331075994964e-27,  5.859613117590205e-30,  4.107537511989953e-01, -1.651598118824851e-03,  3.934778770073372e-06, -4.371578992099024e-09, -9.757166373823477e-12,
  6.268264992930050e-14, -1.356805707060030e-16, -6.067693064868130e-20,  1.445965488541579e-21, -4.719720773040204e-24,  3.393207588316579e-27,  3.469891883923183e-29,
  4.635343227077298e-01, -1.818924956088267e-03,  4.033727410738872e-06, -3.047579091398537e-09, -1.575907665820781e-11,  7.075321936967067e-14, -9.786630501412861e-17,
 -3.029898358112682e-19,  1.947870741708379e-21, -3.779517708165470e-24, -6.465590294524281e-27,  6.247467818746782e-29,  5.190481468119572e-01, -1.982850317080620e-03,
  4.044758016816120e-06, -1.377883811580382e-09, -2.175405826990261e-11,  7.294102509131786e-14, -3.437888040584234e-17, -5.632843891720783e-19,  2.128065133629111e-21,
 -1.192540628342902e-24, -1.844389959054672e-26,  7.456618529021038e-29,  5.771650625540211e-01, -2.140805020010272e-03,  3.957614103512333e-06,  6.020282437249294e-10,
 -2.724506397222322e-11,  6.757655706913718e-14,  5.167701852378785e-17, -7.912379785661993e-19,  1.814281922834631e-21,  2.858417802761732e-24, -2.850922569745542e-26,
  5.639545860806929e-29,  6.377384241266425e-01, -2.290089857948542e-03,  3.763948825385463e-06,  2.833061321961625e-09, -3.167518323411477e-11,  5.352681319073313e-14,
  1.523465596965664e-16, -9.264400227041233e-19,  9.095448449126192e-22,  7.580056811014941e-24, -3.146190018509397e-26,  1.339826423402297e-30,  7.006033089938820e-01,
 -2.427897030561253e-03,  3.457920199213986e-06,  5.231287950866920e-09, -3.446528200521531e-11,  3.050066820634118e-14,  2.546870645449470e-16, -9.091233881013875e-19,
 -5.462646784609569e-22,  1.157990508497906e-23, -2.272135994319747e-26, -8.099419847125996e-29,  7.655745787007489e-01, -2.551339514750497e-03,  3.036834452224401e-06,
  7.688041080928655e-09, -3.506502499329536e-11, -6.651191421857187e-16,  3.415544044949957e-16, -6.952417491627429e-19, -2.330373920707490e-21,  1.312350401556642e-23,
 -8.239800573615747e-28, -1.608019135611275e-28,  8.324448037261039e-01, -2.657490080154041e-03,  2.501819214130230e-06,  1.007177400466534e-08, -3.301648810936789e-11,
 -3.779258804978821e-14,  3.935543025807649e-16, -2.738369597857392e-19, -4.030759105421298e-21,  1.066840473743508e-23,  3.021600904689386e-26, -1.937610471855983e-28,
  9.009820739225473e-01, -2.743431803378518e-03,  1.858497082696486e-06,  1.223218270495494e-08, -2.802744521109682e-11, -7.728864963389357e-14,  3.922490236603341e-16,
  3.172123288372488e-19, -5.103162148158771e-21,  3.598060248530417e-24,  6.004304896533776e-26, -1.393172236048766e-28,  9.709277297663981e-01, -2.806322001836498e-03,
  1.117615835233641e-06,  1.400706892885266e-08, -2.004852154760979e-11, -1.142841987769691e-13,  3.244391253832198e-16,  9.827133386402022e-19, -5.004488873531643e-21,
 -7.069699831836448e-24,  7.404292773050273e-26,  1.194332564254609e-29,  1.041994067536321e+00, -2.843471435961763e-03,  2.955742816766404e-07,  1.523232378690157e-08,
 -9.344832753265520e-12, -1.430537839086032e-13,  1.869458068808834e-16,  1.575465240100108e-18, -3.391406407726115e-21, -1.836397311563178e-23,  5.905083004773846e-26,
  2.146400541427043e-28,  1.113862094346768e+00, -2.852440338689211e-03, -5.852368828654407e-07,  1.575519157118505e-08,  3.451177896324992e-12, -1.577560694480678e-13,
 -9.155100005023414e-18,  1.920763846181756e-18, -3.363979104131195e-22, -2.583378897981651e-23,  1.150877867724984e-26,  3.685514484335780e-28,  1.186179437220725e+00,
 -2.831152222639388e-03, -1.496380219912356e-06,  1.545058960002466e-08,  1.732248176121749e-11, -1.534791289511959e-13, -2.363356105060353e-16,  1.861370895888764e-18,
  3.525962017169985e-21, -2.503722246413869e-23, -5.564068074091345e-26,  3.586106667924744e-28,  1.258558544273565e+00, -2.778025368039324e-03, -2.403721643993431e-06,
  1.423967770237680e-08,  3.090437228892746e-11, -1.274857608359676e-13, -4.521403824583384e-16,  1.316509322488716e-18,  7.031728094799184e-21, -1.380840697251806e-23,
 -1.128550365770165e-25,  1.303899120080432e-28,  1.330575355116923e+00, -2.692120277656500e-03, -3.268314989856380e-06,  1.210908199999770e-08,  4.259243873502385e-11,
 -8.043862719780073e-14, -6.057949085741270e-16,  3.382309781753768e-19,  8.784176096732286e-21,  5.601850321138770e-24, -1.250949108100712e-25, -2.384293982079357e-28,
  1.401768660240037e+00, -2.573299079801351e-03, -4.047946446130119e-06,  9.128227355659786e-09,  5.073118163322987e-11, -1.726620509420507e-14, -6.501364113115017e-16,
 -8.606440245390188e-19,  7.704310075026212e-21,  2.595181386254737e-23, -7.274448964780007e-26, -5.362477353697066e-28,  1.471640412292260e+00, -2.422389796582432e-03,
 -4.699436091103309e-06,  5.461255504449942e-09,  5.387799144385150e-11,  5.274594535883041e-14, -5.570944806215841e-16, -1.934573301661716e-18,  3.665600256307323e-21,
  3.728820815949031e-23,  2.829611250706854e-26, -5.313138849584459e-28,  1.539657290690978e+00, -2.241344608616675e-03, -5.181731161901240e-06,  1.369257655533581e-09,
  5.111433718986712e-11,  1.170217580422442e-13, -3.323857956275600e-16, -2.503980661675803e-18, -2.117845964721865e-21,  3.205020647182928e-23,  1.245428417624937e-25,
 -1.610734414254906e-28,  1.605253847090640e+00, -2.033376959780365e-03, -5.459719690561522e-06, -2.801579225731448e-09,  4.234763922405629e-11,  1.620914211703319e-13,
 -2.296940020361158e-17, -2.308300021553784e-18, -7.316829824995845e-21,  1.069497697859434e-23,  1.525598913006990e-25,  3.511463763109951e-28,  1.667837562562777e+00,
 -1.803058047341169e-03, -5.508540613318307e-06, -6.649342913066558e-09,  2.852060248781861e-11,  1.770681996879216e-13,  2.892590501880148e-16, -1.355559659631055e-18,
 -9.472412509517324e-21, -1.628583925601560e-23,  8.619787951278106e-26,  6.130395931495439e-28,  1.726796115239894e+00, -1.556349766079923e-03, -5.317976170977178e-06,
 -9.764201406361846e-09,  1.163213551754920e-11,  1.573819718524938e-13,  5.104714828132381e-16,  1.858800899660795e-20, -7.399543349801704e-21, -3.324865734894311e-23,
 -3.249265101444531e-26,  3.958566937600346e-28,  1.781507076340169e+00, -1.300549702894640e-03, -4.896311600519993e-06, -1.179134508352182e-08, -5.509254306875252e-12,
  1.074255666094937e-13,  5.700010853021051e-16,  1.254397319846363e-18, -2.162335765835840e-21, -2.982830058628031e-23, -1.160947601621150e-25, -1.069704886804244e-28,
  1.831350111712242e+00, -1.044125733135810e-03, -4.272885532580527e-06, -1.250027971115128e-08, -1.982055979938213e-11,  4.063478534167303e-14,  4.538649894488276e-16,
  1.827873325050501e-18,  3.273480712950219e-21, -9.594149629250536e-24, -1.037935533312986e-25, -4.258473443435447e-28,  1.875721560519517e+00, -7.964245207739315e-04,
 -3.498501413747937e-06, -1.184621963101964e-08, -2.869099559464040e-11, -2.389713255312636e-14,  2.180449944576470e-16,  1.544960797223087e-18,  5.848067241381436e-21,
  1.164640767371332e-23, -1.954397953051963e-26, -2.995334565991357e-28,  1.914050999403304e+00, -5.672505956809783e-04, -2.642999481436148e-06, -1.000602754131992e-08,
 -3.075101504307983e-11, -6.780177310534824e-14, -3.190695317255074e-17,  6.754953554777279e-19,  4.557646920434480e-21,  1.874470519328993e-23,  5.119451620450962e-26,
  4.311626430455519e-29,  1.945819104363233e+00, -3.663303269812885e-04, -1.789650152520021e-06, -7.372454468533607e-09, -2.639673151170247e-11, -8.062515581533234e-14,
 -1.912752538259040e-16, -2.066531944346369e-19,  1.163492726424316e-21,  1.034127571139881e-23,  5.162661453734580e-26,  1.938734311390515e-28,  1.970575848775040e+00,
 -2.026959098137520e-04, -1.026612361898247e-06, -4.497981932877853e-09, -1.781774245005012e-11, -6.451048308443266e-14, -2.117209888707073e-16, -6.092883969664660e-19,
 -1.389678371409834e-21, -1.442263017593733e-24,  8.682097948108185e-27,  7.881093152054559e-29,  1.987958002761368e+00, -8.404371928358341e-05, -4.364012319841356e-07,
 -1.992790082424293e-09, -8.415426123355097e-12, -3.353839449587881e-14, -1.272075545673449e-16, -4.600691209151323e-19, -1.581536804823289e-21, -5.119180308570564e-24,
 -1.528978694249294e-26, -4.023508688615362e-29,  1.997707130589526e+00, -1.611954140279087e-05, -8.486705328753813e-08, -3.963848271940218e-10, -1.731413105855782e-12,
 -7.238935560502454e-15, -2.932300855960518e-17, -1.158892787237612e-19, -4.487833939466327e-22, -1.707457644497584e-24, -6.392847097550757e-27, -2.357539256594466e-29,
  4.310149096621222e-04, -2.013822140212052e-06,  7.055526476738359e-09, -2.196837189576406e-11,  6.410650236265674e-14, -1.795321539629005e-16,  4.885999206624701e-19,
 -1.302063213680688e-21,  3.413570888493777e-24, -8.834483491615110e-27,  2.261727396063403e-29, -5.739499088011403e-32,  3.878445187818925e-03, -1.810072625081162e-05,
  6.326096338092523e-08, -1.961315648026064e-10,  5.685798521068992e-13, -1.577412376126143e-15,  4.238458412852162e-18, -1.110771665273467e-20,  2.850663089293418e-23,
 -7.183938792008037e-26,  1.779903468435814e-28, -4.340445861069756e-31,  1.076961907549534e-02, -5.014814052040360e-05,  1.743997304693179e-07, -5.360489447016051e-10,
  1.533265614389704e-12, -4.171871082633488e-15,  1.091227164370784e-17, -2.758299766240253e-20,  6.748977995128237e-23, -1.597765153957213e-25,  3.646850787276790e-28,
 -7.976592017195069e-31,  2.109710541950997e-02, -9.790261736248097e-05,  3.379342342084077e-07, -1.025084849712884e-09,  2.871680813887991e-12, -7.576388540234356e-15,
  1.896121446499808e-17, -4.502646661431787e-20,  1.007940633827641e-22, -2.094506254590168e-25,  3.897236786265663e-28, -5.901167841620575e-31,  3.484961210540530e-02,
 -1.609823464477664e-04,  5.500750681516440e-07, -1.638745070228469e-09,  4.459185838224787e-12, -1.125084180925703e-14,  2.631233794050088e-17, -5.624778290484778e-20,
  1.056846563259940e-22, -1.554452523788337e-25,  8.446703902605392e-29,  5.606478390442087e-31,  5.201180922228332e-02, -2.388752175877586e-04,  8.058026187264459e-07,
 -2.345237386796719e-09,  6.139047876681953e-12, -1.454751424863940e-14,  3.064882058513597e-17, -5.402335523624261e-20,  6.291896395341382e-23,  4.258571378133962e-26,
 -5.943805194919187e-28,  2.503865545782385e-30,  7.256408930393926e-02, -3.309362900223515e-04,  1.098897943587537e-06, -3.106234161344826e-09,  7.730450394772325e-12,
 -1.676971968920584e-14,  2.975010566033660e-17, -3.274804420319910e-20, -3.638703082921184e-23,  3.755013557285097e-25, -1.493072423043285e-27,  4.415094540851328e-30,
  9.648226119241017e-02, -4.363847183861516e-04,  1.421984753248754e-06, -3.877849040589210e-09,  9.038361593616568e-12, -1.724053231842225e-14,  2.186324482719289e-17,
  9.946894592983822e-21, -1.851453930836020e-22,  7.708614825188070e-25, -2.252926650668884e-27,  4.959099685869365e-30,  1.237371731565257e-01, -5.543002055102271e-04,
  1.766584850488043e-06, -4.611841477956006e-09,  9.865123889539910e-12, -1.537828128815428e-14,  6.069995633305323e-18,  7.187158524119126e-20, -3.574272676634003e-22,
  1.096367345725472e-24, -2.387836235667115e-27,  2.796803702601566e-30,  1.542942599587095e-01, -6.836190774466334e-04,  2.123189943214657e-06, -5.257063280132979e-09,
  1.002355501279037e-11, -1.077452770290600e-14, -1.739177132614341e-17,  1.455242453147858e-19, -5.096318068613521e-22,  1.184406011771116e-24, -1.446156030773595e-27,
 -2.671091989607510e-30,  1.881130076017039e-01, -8.231301082282906e-04,  2.481353344339926e-06, -5.761160258941896e-09,  9.351254525613592e-12, -3.269202992358146e-15,
 -4.689831200992020e-17,  2.181628387402617e-19, -5.865211364067257e-22,  8.770774505799234e-25,  7.734367331212711e-28, -1.057536089311066e-29,  2.251463285130214e-01,
 -9.714702627019197e-04,  2.829805699286055e-06, -6.072538693375978e-09,  7.725682694122335e-12,  6.983509091878896e-15, -7.934987304280105e-17,  2.729034576892003e-19,
 -5.321959717695054e-22,  8.529696426143065e-26,  4.012902184158716e-27, -1.821723521776611e-29,  2.653398389576320e-01, -1.127120577394621e-03,  3.156599520859608e-06,
 -6.142599877755499e-09,  5.079417743019314e-12,  1.946604134946195e-14, -1.102663220127822e-16,  2.909475897298672e-19, -3.050586259735237e-22, -1.150751223175195e-24,
  7.436281433066576e-27, -2.142935543821476e-29,  3.086310295399025e-01, -1.288402464202803e-03,  3.449287930889384e-06, -5.928235544862380e-09,  1.414800346881184e-12,
  3.327348232125268e-14, -1.341072687591763e-16,  2.548888222154816e-19,  1.054220394465105e-22, -2.618081375765812e-24,  9.689968917561994e-27, -1.586402191855950e-29,
  3.549483188122560e-01, -1.453474802429604e-03,  3.695143556828231e-06, -5.394561187926313e-09, -3.183058139148348e-12,  4.712377621576741e-14, -1.448403990909693e-16,
  1.528442586928718e-19,  6.636141383407789e-22, -3.925514442093005e-24,  9.205708126321339e-27,  9.059725225187437e-31,  4.042099793214268e-01, -1.620332284279489e-03,
  3.881423930274273e-06, -4.517841843132198e-09, -8.536187967857907e-12,  5.941100140599352e-14, -1.367570719801623e-16, -1.709555135218633e-20,  1.278845502401711e-21,
 -4.555764016637522e-24,  4.748857270452737e-27,  2.704251815383141e-29,  4.563229249951803e-01, -1.786805600365636e-03,  3.995689866440547e-06, -3.288534179861567e-09,
 -1.436815150273602e-11,  6.830953958935454e-14, -1.054981544505137e-16, -2.428796445850163e-19,  1.807795146319675e-21, -3.985386256047798e-24, -3.883134929508566e-27,
  5.488661803787654e-29,  5.111813487449509e-01, -1.950564197919859e-03,  4.026183003023325e-06, -1.714328234524989e-09, -2.030472664545161e-11,  7.193431888908126e-14,
 -4.920490235677561e-17, -4.960092233660528e-19,  2.072637690858816e-21, -1.865477088026934e-24, -1.522543814337557e-26,  7.148115505069063e-29,  5.686651997276080e-01,
 -2.109122517366615e-03,  3.962267714812043e-06,  1.769794427183425e-10, -2.588289059361057e-11,  6.855759733237228e-14,  3.034908273251840e-17, -7.317496277842845e-19,
  1.897274090747135e-21,  1.769587700288347e-24, -2.588988006688978e-26,  6.222142799157092e-29,  6.286384911342852e-01, -2.259850813443944e-03,  3.794940690917861e-06,
  2.335012582846393e-09, -3.057016692599970e-11,  5.687537915775549e-14,  1.268530089229456e-16, -8.932109414852711e-19,  1.159834548336351e-21,  6.327774810140660e-24,
 -3.103308664354995e-26,  1.769211648608344e-29,  6.909474320018292e-01, -2.399991893226976e-03,  3.517408170068038e-06,  4.685046972106358e-09, -3.379621423483664e-11,
  3.630609576160567e-14,  2.290482646075923e-16, -9.201158020924892e-19, -1.465440407687545e-22,  1.060660498244600e-23, -2.577633147735227e-26, -5.803315973310919e-29,
  7.554183808214063e-01, -2.526685348998404e-03,  3.125725688105967e-06,  7.127332884196087e-09, -3.499797282682876e-11,  7.290594681988108e-15,  3.211145284901615e-16,
 -7.622744516798406e-19, -1.860176513587501e-21,  1.295453247416460e-23, -7.483943776433147e-27, -1.415072555219812e-28,  8.218556252178533e-01, -2.637001115898074e-03,
  2.619487630848757e-06,  9.537973711108484e-09, -3.367858169184333e-11, -2.845350643058253e-14,  3.841403915226483e-16, -3.964596589938728e-19, -3.626995226799729e-21,
  1.170667143953061e-23,  2.171198071678506e-26, -1.917613358744302e-28,  8.900390013950192e-01, -2.727984419554169e-03,  2.002543294222598e-06,  1.177189157992594e-08,
 -2.947845380116827e-11, -6.778640680551161e-14,  3.988674578696464e-16,  1.564346832022293e-19, -4.931950983682967e-21,  5.869303754195000e-24,  5.333725998109172e-26,
 -1.642819696485587e-28,  9.597213802255140e-01, -2.796714359962124e-03,  1.283701971943404e-06,  1.366843920795408e-08, -2.225420578656102e-11, -1.061857790385491e-13,
  3.496789036046312e-16,  8.190693119198851e-19, -5.205693351148767e-21, -4.112015659419595e-24,  7.348746956991024e-26, -3.660637523134023e-29,  1.030626064764578e+00,
 -2.840378447745495e-03,  4.773714777699914e-07,  1.506017640489436e-08, -1.215753419262439e-11, -1.380505856675835e-13,  2.294434506150235e-16,  1.456836065757680e-18,
 -4.007848975348201e-21, -1.582764614481522e-23,  6.739548535644339e-26,  1.638730130686231e-28,  1.102444167605567e+00, -2.856365285612461e-03, -3.959473787238674e-07,
  1.578517576098345e-08,  2.982056566519372e-13, -1.573324869888456e-13,  4.433658480036118e-17,  1.895239144770271e-18, -1.254262457209641e-21, -2.505397745543821e-23,
  2.733764088719089e-26,  3.487769995957575e-28,  1.174832066833305e+00, -2.842377159584488e-03, -1.309412432023106e-06,  1.570290240476128e-08,  1.420046253045981e-11,
 -1.585138605212929e-13, -1.827759759836417e-16,  1.959382286227405e-18,  2.588473088321436e-21, -2.693542705411777e-23, -3.900186912543429e-26,  3.953347384614159e-28,
  1.247409077077659e+00, -2.796563428217124e-03, -2.229964706935485e-06,  1.471317333064621e-08,  2.824925857089327e-11, -1.378698463191087e-13, -4.122087772781384e-16,
  1.532712506880408e-18,  6.454987511872692e-21, -1.818209947978852e-23, -1.051985400427644e-25,  2.169658757098459e-28,  1.319755517444546e+00, -2.717674103876709e-03,
 -3.118972769931236e-06,  1.277690467631149e-08,  4.083920734298241e-11, -9.483214448248259e-14, -5.923658099476956e-16,  6.215664979177598e-19,  8.893471116605939e-21,
  4.131464358572138e-25, -1.336995767205020e-25, -1.505139304451021e-28,  1.391411409962159e+00, -2.605230729367108e-03, -3.933551687453779e-06,  9.936308209825846e-09,
  5.022802041659300e-11, -3.312995452780022e-14, -6.706467317853150e-16, -5.997653340431327e-19,  8.580554844787306e-21,  2.257506795492722e-23, -9.592833911146008e-26,
 -5.136476789558667e-28,  1.461876097972687e+00, -2.459708414869651e-03, -4.628696328427704e-06,  6.330998104890015e-09,  5.479489385434239e-11,  3.874016301177635e-14,
 -6.094172546981879e-16, -1.795624765030989e-18,  5.022503314284099e-21,  3.792945891937002e-23,  3.222406016856221e-27, -6.059176670146004e-28,  1.530609128480228e+00,
 -2.282718655506463e-03, -5.160317328736647e-06,  2.205353139094118e-09,  5.336928580136228e-11,  1.081966034234205e-13, -4.032658295632389e-16, -2.552345382683226e-18,
 -8.764077775798546e-22,  3.685356207963976e-23,  1.147012286316120e-25, -2.878208810622960e-28,  1.597032787402393e+00, -2.077177428476476e-03, -5.489166445768150e-06,
 -2.098134768901795e-09,  4.557858469540975e-11,  1.607385076933166e-13, -9.081329331045178e-17, -2.535071494732302e-18, -6.818430149838808e-21,  1.708554990327802e-23,
  1.664042097594437e-25,  2.736121774843599e-28,  1.660536699683299e+00, -1.847437511575995e-03, -5.585476700353177e-06, -6.164318695368907e-09,  3.212813501592526e-11,
  1.835201799841399e-13,  2.469766539558029e-16, -1.667338469989001e-18, -9.990015519772525e-21, -1.228507597956504e-23,  1.141385237243912e-25,  6.538861342324875e-28,
  1.720484891265111e+00, -1.599358849630199e-03, -5.433923875217262e-06, -9.552240786442962e-09,  1.490218726233020e-11,  1.696116621917477e-13,  5.074954288256607e-16,
 -2.375633437173152e-19, -8.615381624992737e-21, -3.416578207989385e-23, -1.250004402489582e-26,  5.143609043885930e-28,  1.776225638506638e+00, -1.340287510605399e-03,
 -5.038263289114794e-06, -1.186154999219261e-08, -3.221142478633146e-12,  1.215182266930422e-13,  6.039876159369868e-16,  1.167117254617446e-18, -3.320686811036308e-21,
 -3.454499127974568e-23, -1.191718250775200e-25, -2.894309083537535e-29,  1.827104285065206e+00, -1.078914156317595e-03, -4.424762878721249e-06, -1.281029765240249e-08,
 -1.889473116513168e-11,  5.215319872624463e-14,  5.064541105039645e-16,  1.926259975781041e-18,  2.848759010957756e-21, -1.412987044444855e-23, -1.232036576105034e-25,
 -4.547664293152009e-28,  1.872478975038295e+00, -8.249889889787867e-04, -3.643425194868601e-06, -1.230879967768777e-08, -2.911299256507593e-11, -1.812341789764019e-14,
  2.639856298455470e-16,  1.738629313693033e-18,  6.249890188656004e-21,  1.057896099038798e-23, -3.439469673254715e-26, -3.772912818954767e-28,  1.911738936626219e+00,
 -5.888833484263944e-04, -2.766068775018885e-06, -1.050892693703028e-08, -3.211308827951664e-11, -6.832345535343742e-14, -1.084697409323839e-17,  8.325354721094260e-19,
  5.269701553188024e-21,  2.082236490047318e-23,  5.246898618175469e-26,  1.293750584918507e-29,  1.944324578046358e+00, -3.810087101070743e-04, -1.880707718100405e-06,
 -7.807953507679905e-09, -2.805558612203634e-11, -8.528063152760573e-14, -1.964813911148381e-16, -1.630491490202304e-19,  1.575075819225529e-21,  1.258467826234969e-23,
  6.073760154851318e-26,  2.205117460668907e-28,  1.969748290517781e+00, -2.111296581464637e-04, -1.082342135664014e-06, -4.793669464963607e-09, -1.916017317975751e-11,
 -6.980157820007713e-14, -2.294109264629717e-16, -6.545146691726471e-19, -1.434456242628394e-21, -1.019321837785670e-24,  1.262972301091661e-26,  1.014485524127341e-28,
  1.987614690712356e+00, -8.763292413755075e-05, -4.611452787659905e-07, -2.132973407137851e-09, -9.117797557147122e-12, -3.675185245873790e-14, -1.408265853897498e-16,
 -5.137485153301981e-19, -1.777273074671915e-21, -5.767330256554330e-24, -1.714627947665036e-26, -4.415531077270495e-29,  1.997641263746126e+00, -1.681798650236641e-05,
 -8.979479151630478e-08, -4.252850369876498e-10, -1.883500810478175e-12, -7.983307977296665e-15, -3.277856806563929e-17, -1.312852995676111e-19, -5.151161686310724e-22,
 -1.985187627875756e-24, -7.526562237145800e-27, -2.809661967363101e-29,  4.230708641908925e-04, -1.958415242090606e-06,  6.797943777497687e-09, -2.097076804557075e-11,
  6.063023275310881e-14, -1.682311933822688e-16,  4.536248350462491e-19, -1.197747822566519e-21,  3.111223404522144e-24, -7.978324336159164e-27,  2.023804294722899e-29,
 -5.089073773341162e-32,  3.807039767448978e-03, -1.760390056743113e-05,  6.096094479564092e-08, -1.872812501203694e-10,  5.380241650694325e-13, -1.479320828483309e-15,
  3.939834106923471e-18, -1.023554635973828e-20,  2.604409400909762e-23, -6.508746859262991e-26,  1.599481418663373e-28, -3.870045121653221e-31,  1.057177674990989e-02,
 -4.877826222782899e-05,  1.681116285833349e-07, -5.121702229089803e-10,  1.452385818749599e-12, -3.919005623179183e-15,  1.016933810148356e-17, -2.551260788652044e-20,
  6.199214823886806e-23, -1.458683203784242e-25,  3.312735648838929e-28, -7.222851038773889e-31,  2.071082507910094e-02, -9.524757782199154e-05,  3.259039758900838e-07,
 -9.803258756163350e-10,  2.724603468990585e-12, -7.136090675372823e-15,  1.774451675153263e-17, -4.191874188098397e-20,  9.352824336516133e-23, -1.943744504616128e-25,
  3.642523191895133e-28, -5.671729707238966e-31,  3.421436106613760e-02, -1.566592096483685e-04,  5.308308932903830e-07, -1.569164448887133e-09,  4.240358346355180e-12,
 -1.063786794429465e-14,  2.478391039119669e-17, -5.295471263129402e-20,  1.001549952681938e-22, -1.516160176105504e-25,  1.059833510228320e-28,  4.217192429068962e-31,
  5.106902528435567e-02, -2.325397200665923e-04,  7.782396453868953e-07, -2.249300767180061e-09,  5.855331964940115e-12, -1.382986562924970e-14,  2.916455330952206e-17,
 -5.198979866563400e-20,  6.404965863563129e-23,  2.090608380536052e-26, -4.921804811260761e-28,  2.149604905805788e-30,  7.125769337235302e-02, -3.222921282703763e-04,
  1.062354313681549e-06, -2.985191630013545e-09,  7.402121125314879e-12, -1.606683998388866e-14,  2.881881122551072e-17, -3.370729563371462e-20, -2.389849418297965e-23,
  3.195196631668083e-25, -1.309496844747463e-27,  3.936622092475298e-30,  9.475918279480512e-02, -4.251925446997177e-04,  1.376306961304135e-06, -3.735965147619054e-09,
  8.698817332147297e-12, -1.671311674115639e-14,  2.206286308442902e-17,  4.449286628367146e-21, -1.589647845801246e-22,  6.850112254725524e-25, -2.042005065422662e-27,
  4.627133311324725e-30,  1.215478909495986e-01, -5.403862351038251e-04,  1.712179682434532e-06, -4.456451444029833e-09,  9.559171540261367e-12, -1.520970918077592e-14,
  7.928076132040929e-18,  6.104723094214842e-20, -3.196470183734314e-22,  1.003380521014037e-24, -2.260075645244645e-27,  2.993415973217799e-30,  1.515933589784807e-01,
 -6.668831870492791e-04,  2.061060264189820e-06, -5.098431650493803e-09,  9.804211124318196e-12, -1.114483790332159e-14, -1.353907833358157e-17,  1.298868705595270e-19,
 -4.680598117131561e-22,  1.124528620534802e-24, -1.540182923457873e-27, -1.636684970238659e-30,  1.848597545579627e-01, -8.035532789811230e-04,  2.413114791478455e-06,
 -5.612122375280655e-09,  9.275098827806754e-12, -4.323551260534402e-15, -4.104772978495539e-17,  1.999044538115318e-19, -5.544964547201232e-22,  8.992719536047728e-25,
  3.498025618499357e-28, -8.719645986696871e-30,  2.213052658202875e-01, -9.491211876237808e-04,  2.757681181461835e-06, -5.947911317584485e-09,  7.846917921744291e-12,
  5.168887186796169e-15, -7.194632641898199e-17,  2.559517674944394e-19, -5.264233812729768e-22,  2.304157238213238e-25,  3.258515413646529e-27, -1.609229812615116e-29,
  2.608813973911428e-01, -1.102161215752374e-03,  3.083388335771542e-06, -6.058355665030448e-09,  5.442928665816933e-12,  1.691626864792845e-14, -1.022622849134889e-16,
  2.805784664346043e-19, -3.413554751553536e-22, -8.717916211223580e-25,  6.521100299044543e-27, -2.013977434734375e-29,  3.035321583526310e-01, -1.261092281784540e-03,
  3.378306325857861e-06, -5.900447425708733e-09,  2.048663946852381e-12,  3.014084727387344e-14, -1.269367963873241e-16,  2.568277346403789e-19,  1.797679447995406e-23,
 -2.244749783084014e-24,  8.970083043429836e-27, -1.676206341690436e-29,  3.491931307834015e-01, -1.424173388295366e-03,  3.630133742954327e-06, -5.438137689236472e-09,
 -2.274985803069354e-12,  4.370123390027957e-14, -1.402841988399972e-16,  1.718898846654856e-19,  5.289218217389130e-22, -3.557740741862826e-24,  9.153589899644364e-27,
 -3.130174315492871e-30,  3.977904064509166e-01, -1.589499981943253e-03,  3.826428987462207e-06, -4.645093503095350e-09, -7.380805148780016e-12,  5.612756170163392e-14,
 -1.366872061910212e-16,  2.124224728200467e-20,  1.118524841127146e-21, -4.344098120663442e-24,  5.784234616526337e-27,  2.015024086497717e-29,  4.492393783213660e-01,
 -1.755001736286241e-03,  3.954892746371475e-06, -3.507634843478133e-09, -1.302779790107020e-11,  6.570237978202717e-14, -1.115106482126737e-16, -1.873511708663045e-19,
  1.662086954789965e-21, -4.094656040786974e-24, -1.635747497306625e-27,  4.728460334033332e-29,  5.034433729389624e-01, -1.918442435636175e-03,  4.003709066680605e-06,
 -2.027763121027676e-09, -1.887893593784193e-11,  7.059417068681998e-14, -6.217551760954025e-17, -4.308707912487454e-19,  1.995265322965494e-21, -2.412800871040774e-24,
 -1.217275052220914e-26,  6.709339855496299e-29,  5.602921095906580e-01, -2.077422816350526e-03,  3.961952068100803e-06, -2.261448581450093e-10, -2.450607879481037e-11,
  6.904701983782700e-14,  1.071825534944175e-17, -6.702120175580976e-19,  1.943009026756545e-21,  7.898876439838633e-25, -2.307124662104247e-26,  6.550481493659120e-29,
  6.196599727688572e-01, -2.229387434914654e-03,  3.820064156417625e-06,  1.855146963717176e-09, -2.940421788598612e-11,  5.962412842145207e-14,  1.023952563710638e-16,
 -8.526892357705382e-19,  1.365516728599148e-21,  5.106208773328946e-24, -2.994667867050752e-26,  3.122125264217643e-29,  6.814040861206148e-01, -2.371636881099792e-03,
  3.570409202742558e-06,  4.150406434019505e-09, -3.301720882645468e-11,  4.149391088662243e-14,  2.032753276285350e-16, -9.188994044503590e-19,  2.161786486951099e-22,
  9.530968332336092e-24, -2.784782337292775e-26, -3.639263809308706e-29,  7.453621792924928e-01, -2.501346937198038e-03,  3.207900025397600e-06,  6.568943175088678e-09,
 -3.477685522765123e-11,  1.473492131084260e-14,  2.990071140374005e-16, -8.144078778819477e-19, -1.400646469457211e-21,  1.253680619547977e-23, -1.324715366153982e-26,
 -1.202120814144115e-28,  8.113502444568360e-01, -2.615596592701943e-03,  2.730693003964683e-06,  8.995060756869539e-09, -3.415642340530221e-11, -1.938006769755203e-14,
  3.714790836657063e-16, -5.056292445609613e-19, -3.191939249147401e-21,  1.240830336677173e-23,  1.342646477064178e-26, -1.839708596852911e-28,  8.791599876219641e-01,
 -2.711407140194019e-03,  2.140933010706986e-06,  1.128991178823065e-08, -3.073819024087334e-11, -5.817865009647982e-14,  4.010727316800307e-16,  2.390243793665324e-21,
 -4.684048157516380e-21,  7.852523193650142e-24,  4.569604737827340e-26, -1.818107027114812e-28,  9.485560920639624e-01, -2.785794870651141e-03,  1.445518253599822e-06,
  1.329584562933820e-08, -2.429223857212582e-11, -9.753721844231796e-14,  3.702624620152449e-16,  6.506819692417590e-19, -5.301325500004542e-21, -1.218102178907693e-24,
  7.088635788286752e-26, -8.077277812568800e-29,  1.019273328548032e+00, -2.835840102130471e-03,  6.568363643820437e-07,  1.484388056015258e-08, -1.486025243765975e-11,
 -1.320694458739083e-13,  2.683574714003990e-16,  1.320001628273431e-18, -4.527525439563931e-21, -1.300343485425599e-23,  7.341907989473014e-26,  1.095416156721520e-28,
  1.091013570778214e+00, -2.858775333774338e-03, -2.066002449333048e-07,  1.576484961896453e-08, -2.833531846720628e-12, -1.556369691299780e-13,  9.670745523319374e-17,
  1.840912218948427e-18, -2.132901163553502e-21, -2.366217909144173e-23,  4.201744088415225e-26,  3.165619385054844e-28,  1.163442806150116e+00, -2.852095099595730e-03,
 -1.119719698609128e-06,  1.590452805783417e-08,  1.099080749964647e-11, -1.622336774715726e-13, -1.269013578111725e-16,  2.026432019813316e-18,  1.594978869792510e-21,
 -2.814009850678155e-23, -2.107395401795215e-26,  4.169782080415921e-28,  1.236188272697768e+00, -2.813689442734685e-03, -2.050787392551022e-06,  1.514257977545581e-08,
  2.539652569004711e-11, -1.472251576921792e-13, -3.665050689758125e-16,  1.728007220900035e-18,  5.727211592861773e-21, -2.217484657483467e-23, -9.385236011380942e-26,
  2.974222171299523e-28,  1.308835903995405e+00, -2.742001635478954e-03, -2.961794423718487e-06,  1.341439290136392e-08,  3.880197249593136e-11, -1.088079422352249e-13,
 -5.709828625462558e-16,  9.053521248080253e-19,  8.810743103150768e-21, -5.038761083995821e-24, -1.381722815044446e-25, -5.124270416403564e-29,  1.380928324591094e+00,
 -2.636208594116410e-03, -3.809518811794524e-06,  1.073377607822767e-08,  4.940326928272822e-11, -4.939524657875343e-14, -6.834794289232619e-16, -3.129684298365346e-19,
  9.318848151085700e-21,  1.829790753639799e-23, -1.175895436644379e-25, -4.669491835254288e-28,  1.451963707440078e+00, -2.496419139738330e-03, -4.547441092915869e-06,
  7.213103401093773e-09,  5.541946371001429e-11,  2.353024161283780e-14, -6.572395225973460e-16, -1.613085677397393e-18,  6.383690662569094e-21,  3.750695876063408e-23,
 -2.476145630898243e-26, -6.626804021687637e-28,  1.521395877093962e+00, -2.323880659818383e-03, -5.128659999761172e-06,  3.076022970483573e-09,  5.543063428839723e-11,
  9.765872327390488e-14, -4.749185212252928e-16, -2.558304383852106e-18,  5.294989435634326e-22,  4.114934455164243e-23,  9.911528869327193e-26, -4.212603179038805e-28,
  1.588636109390291e+00, -2.121178829704922e-03, -5.509862882037783e-06, -1.343302242805424e-09,  4.876568527469480e-11,  1.576831640029300e-13, -1.647481978803790e-16,
 -2.742113490066201e-18, -6.080898278873144e-21,  2.395350733538528e-23,  1.762257922657421e-25,  1.681861233441163e-28,  1.653057126229084e+00, -1.892408192661876e-03,
 -5.656242102134000e-06, -5.620599776645614e-09,  3.585384318063309e-11,  1.888508943118829e-13,  1.957557735145947e-16, -1.993157271286203e-18, -1.034309465687935e-20,
 -7.136765120329823e-24,  1.434144987477586e-25,  6.726562988037282e-28,  1.713999793182029e+00, -1.643284432699078e-03, -5.547006074880207e-06, -9.286008986920652e-09,
  1.841551477954602e-11,  1.816794391756988e-13,  4.967986381132284e-16, -5.329850997343550e-19, -9.848563622454444e-21, -3.417662169065727e-23,  1.287049496254901e-26,
  6.395508614518773e-28,  1.770782973786907e+00, -1.381163657589776e-03, -5.180828335619508e-06, -1.189284687584240e-08, -6.432409481434778e-13,  1.363928912414407e-13,
  6.349857083939555e-16,  1.040036533654889e-18, -4.650160980016736e-21, -3.930883125805093e-23, -1.182673554230529e-25,  7.445596436785216e-29,  1.822716851505710e+00,
 -1.114932209346242e-03, -4.580263733830421e-06, -1.310358990612538e-08, -1.772569833035551e-11,  6.496511684542524e-14,  5.615821533272612e-16,  2.008290814852363e-18,
  2.246499186316213e-21, -1.946410461517234e-23, -1.436274132847505e-25, -4.710636737630160e-28,  1.869119777597698e+00, -8.547351568835098e-04, -3.793936438453970e-06,
 -1.277714610558048e-08, -2.940804290659461e-11, -1.118064215522364e-14,  3.155223662716564e-16,  1.944419784734512e-18,  6.601738996554909e-21,  8.845878142468501e-24,
 -5.290387307264500e-26, -4.657577826419681e-28,  1.909338334985254e+00, -6.115251657823100e-04, -2.895303871535398e-06, -1.103367396923727e-08, -3.348017099773780e-11,
 -6.828428843998741e-14,  1.494042710178135e-17,  1.013565101307381e-18,  6.057117461032665e-21,  2.292088205713512e-23,  5.214391608459038e-26, -3.008239100704435e-29,
  1.942769847531620e+00, -3.964369160380927e-04, -1.977153615597010e-06, -8.270745442641242e-09, -2.980869280791286e-11, -9.004483809461675e-14, -2.002695697432484e-16,
 -1.049095909072488e-19,  2.074267443579231e-21,  1.521635289098226e-23,  7.104848814409528e-26,  2.482790907204285e-28,  1.968886082592270e+00, -2.200238110064826e-04,
 -1.141752601192958e-06, -5.111705964897722e-09, -2.061277474296505e-11, -7.553257455397937e-14, -2.483847421987506e-16, -7.008977041903237e-19, -1.460911961429904e-21,
 -4.170096758266852e-25,  1.769079394474496e-26,  1.296012571255581e-28,  1.987256615008949e+00, -9.142700621281549e-05, -4.876411329386689e-07, -2.284927111325194e-09,
 -9.887832213762970e-12, -4.031093330103206e-14, -1.560399410278438e-16, -5.740794742366223e-19, -1.997720969591619e-21, -6.493185381971912e-24, -1.917462901232175e-26,
 -4.801712180549528e-29,  1.997572522022170e+00, -1.755728324716504e-05, -9.508443897545124e-08, -4.567424066984459e-10, -2.051341495894794e-12, -8.816036305794934e-15,
 -3.669650104201510e-17, -1.489730985127107e-19, -5.923138052135383e-22, -2.312507131206802e-24, -8.879140663469367e-27, -3.355452087700661e-29,  4.153443994942457e-04,
 -1.905022049237607e-06,  6.552005916142925e-09, -2.002702098917756e-11,  5.737181939016716e-14, -1.577356503373310e-16,  4.214396344596820e-19, -1.102632225635511e-21,
  2.838051380192212e-24, -7.211850147315764e-27,  1.812729741256214e-29, -4.517322129719626e-32,  3.737585510599160e-03, -1.712505838216526e-05,  5.876426014192766e-08,
 -1.789045130435175e-10,  5.093605721489903e-13, -1.388111899783233e-15,  3.664562923978895e-18, -9.438423478006940e-21,  2.381211962282062e-23, -5.901748212959618e-26,
  1.438543890591320e-28, -3.453638217872014e-31,  1.037931511208851e-02, -4.745756419284282e-05,  1.621024707045406e-07, -4.895460688001312e-10,  1.376389623082866e-12,
 -3.683294343631273e-15,  9.481986003089378e-18, -2.361038278523085e-20,  5.697193476959525e-23, -1.332324165195062e-25,  3.010183071711118e-28, -6.540807731995195e-31,
  2.033497575879466e-02, -9.268667126323998e-05,  3.143969913727821e-07, -9.378512488343766e-10,  2.586046988577879e-12, -6.723975138815831e-15,  1.661166044523197e-17,
 -3.903503412585677e-20,  8.678707704879330e-23, -1.802961332173996e-25,  3.398487517329222e-28, -5.417590850312396e-31,  3.359609987257945e-02, -1.524867449801884e-04,
  5.124010766374685e-07, -1.502988953674863e-09,  4.033430875079280e-12, -1.006048973113137e-14,  2.334523336245046e-17, -4.983623127134055e-20,  9.477727359131772e-23,
 -1.470409368552807e-25,  1.219362086757358e-28,  3.070852144739777e-31,  5.015114951259787e-02, -2.264201974667813e-04,  7.518011421868155e-07, -2.157790694432644e-09,
  5.585617431716783e-12, -1.314715275455761e-14,  2.773762029157477e-17, -4.993178799877498e-20,  6.446984109352989e-23,  3.016572569135767e-27, -4.045418136419711e-28,
  1.841042782258164e-30,  6.998529846424871e-02, -3.139345937612613e-04,  1.027232134485439e-06, -2.869291128991654e-09,  7.087623989382083e-12, -1.538659030745131e-14,
  2.786595951146261e-17, -3.429778254131523e-20, -1.329807915326347e-23,  2.704729348816020e-25, -1.146006556845085e-27,  3.501756742824642e-30,  9.308015290112433e-02,
 -4.143590744749076e-04,  1.332299528624542e-06, -3.599429366707866e-09,  8.369857299384882e-12, -1.618266565112878e-14,  2.211982405284914e-17, -2.583919607943828e-22,
 -1.357264553969393e-22,  6.073043419182434e-25, -1.845777109703525e-27,  4.292505130421007e-30,  1.194134058341221e-01, -5.269001302677923e-04,  1.659609942192996e-06,
 -4.305927353847251e-09,  9.257012715855868e-12, -1.500004656855546e-14,  9.499504138662522e-18,  5.137928568504991e-20, -2.851204877931062e-22,  9.156482821432118e-25,
 -2.125782710143618e-27,  3.097189963853136e-30,  1.489584194560509e-01, -6.506367799583981e-04,  2.000812879176099e-06, -4.943363894979632e-09,  9.578350980947768e-12,
 -1.142778932107384e-14, -1.010593631378172e-17,  1.155446698820785e-19, -4.287006674030533e-22,  1.061742152015357e-24, -1.593002261663730e-27, -7.934881856087967e-31,
  1.816837283099481e-01, -7.845152266066788e-04,  2.346656710647028e-06, -5.464464221076098e-09,  9.179219495550185e-12, -5.243503946168572e-15, -3.569393757597420e-17,
  1.826805278743716e-19, -5.219587336061827e-22,  9.060857920037621e-25,  2.740093812197850e-30, -7.092279971696968e-30,  2.175524549502573e-01, -9.273430962945176e-04,
  2.687062663911176e-06, -5.821625024375792e-09,  7.933599243639667e-12,  3.526280129969821e-15, -6.501409608996828e-17,  2.392627454902597e-19, -5.159474663314856e-22,
  3.471929177442273e-25,  2.594892820384611e-27, -1.409504772362765e-29,  2.565216284293846e-01, -1.077783404801994e-03,  3.011221328968684e-06, -5.968692904867506e-09,
  5.757340946466461e-12,  1.455498659146294e-14, -9.456338423952049e-17,  2.692015734582109e-19, -3.682545882170353e-22, -6.282564841673377e-25,  5.666113011571724e-27,
 -1.870513601374627e-29,  2.985413945384516e-01, -1.234348450666698e-03,  3.307716991947807e-06, -5.863009347340473e-09,  2.621598574490618e-12,  2.718065105406610e-14,
 -1.197492294879737e-16,  2.561778133317866e-19, -5.655485447092659e-23, -1.900840780541352e-24,  8.222680742912175e-27, -1.713252631193543e-29,  3.435541052841386e-01,
 -1.395393902511307e-03,  3.564685946851089e-06, -5.467726525946438e-09, -1.434230095056005e-12,  4.039396488464504e-14, -1.352530776339769e-16,  1.868364596459167e-19,
  4.073913402443802e-22, -3.195351497279256e-24,  8.942568444957044e-27, -6.331221523719496e-30,  3.914932736366300e-01, -1.559113437953532e-03,  3.770015775678461e-06,
 -4.754383942562080e-09, -6.290990371073033e-12,  5.285810786924082e-14, -1.356145065403177e-16,  5.457911823476341e-20,  9.664986680328079e-22, -4.096848069178318e-24,
  6.533901739454527e-27,  1.405882030291961e-29,  4.422823782077078e-01, -1.723534405434308e-03,  3.911593347584016e-06, -3.705714316217792e-09, -1.174090729168721e-11,
  6.296904778014692e-14, -1.160340934300389e-16, -1.365316006303482e-19,  1.513982950939513e-21, -4.120674143936866e-24,  2.809393367903846e-28,  3.988638335033224e-29,
  4.958335013227589e-01, -1.886515124046568e-03,  3.977609850003863e-06, -2.318616078743888e-09, -1.748291492812953e-11,  6.896431707989209e-14, -7.335971595930769e-17,
 -3.685003628476754e-19,  1.900337911280250e-21, -2.842180378496878e-24, -9.335072709541045e-27,  6.176476401637094e-29,  5.520457830994486e-01, -2.045744615401230e-03,
  3.956931345417111e-06, -6.071868728218753e-10, -2.312404965791547e-11,  6.908611269611110e-14, -7.174175260547693e-18, -6.077531951868458e-19,  1.955532783554538e-21,
 -7.485501061265780e-26, -2.015816627590483e-26,  6.657026022396149e-29,  6.108036738761816e-01, -2.198745781100085e-03,  3.839542877545781e-06,  1.394344834831318e-09,
 -2.818906814554305e-11,  6.180021035737971e-14,  7.915771237471677e-17, -8.062798208611490e-19,  1.528140608531412e-21,  3.939170658341100e-24, -2.832723968448925e-26,
  4.193065469354235e-29,  6.719749679810105e-01, -2.342883303900286e-03,  3.617072648659773e-06,  3.629026459690865e-09, -3.214062323686375e-11,  4.606485953283570e-14,
  1.776930248282924e-16, -9.067096069722787e-19,  5.389118053539425e-22,  8.391001912720893e-24, -2.900638786305477e-26, -1.661249999760876e-29,  7.354086038621485e-01,
 -2.475377862135650e-03,  3.283399732058773e-06,  6.015253145152044e-09, -3.441226659088868e-11,  2.163279938214616e-14,  2.756432658996244e-16, -8.521195891219797e-19,
 -9.600748330746585e-22,  1.190765478607282e-23, -1.804794502413870e-26, -9.791916494120488e-29,  8.009322196477393e-01, -2.593328602636316e-03,  2.835343481042470e-06,
  8.445936564352224e-09, -3.445607443351071e-11, -1.064558710090968e-14,  3.559592780217897e-16, -6.005361012833667e-19, -2.737493679028947e-21,  1.278687260587667e-23,
  5.594264291068717e-27, -1.713189735825847e-28,  8.683494601068792e-01, -2.693746206165047e-03,  2.273424381460945e-06,  1.078931488069894e-08, -3.180558674851472e-11,
 -4.856876550516784e-14,  3.990861261737294e-16, -1.426393379276632e-19, -4.370416968988472e-21,  9.516864501272555e-24,  3.744739441388601e-26, -1.919248363882126e-28,
  9.374370418379864e-01, -2.773599276611383e-03,  1.602673551767985e-06,  1.289205252876492e-08, -2.615274337583379e-11, -8.845148094438711e-14,  3.861038287727860e-16,
  4.808775055536696e-19, -5.295103294369889e-21,  1.534523610877400e-24,  6.646557544896157e-26, -1.191114909952191e-28,  1.007941599688197e+00, -2.829877145348050e-03,
  8.334503481926929e-07,  1.458534761448693e-08, -1.743432816971674e-11, -1.252021296117787e-13,  3.032229017978349e-16,  1.168206082207036e-18, -4.941774347401962e-21,
 -9.986595902839143e-24,  7.701876322113932e-26,  5.409591431462048e-29,  1.079576360568933e+00, -2.859672429335234e-03, -1.779633294033031e-08,  1.569475467764316e-08,
 -5.918929406495043e-12, -1.527059311091993e-13,  1.471718649475887e-16,  1.759380886071160e-18, -2.951237518359652e-21, -2.171483149910645e-23,  5.503712819612485e-26,
  2.736487976077316e-28,  1.152017722874805e+00, -2.860286697912328e-03, -9.279178017185464e-07,  1.605427749342053e-08,  7.720299388672891e-12, -1.645936024332901e-13,
 -6.959995602003939e-17,  2.061136034609384e-18,  5.712115411741058e-22, -2.861328919504535e-23, -2.544818987406390e-27,  4.225729556319256e-28,  1.224901862618028e+00,
 -2.829362216995002e-03, -1.866737039676064e-06,  1.552490705217847e-08,  2.236808424781625e-11, -1.554207221942894e-13, -3.156800971999069e-16,  1.897807644134589e-18,
  4.864695138541269e-21, -2.564564071328106e-23, -7.917449694774467e-26,  3.677799838911140e-28,  1.297821542912438e+00, -2.765041716053246e-03, -2.797170919691586e-06,
  1.401707981851079e-08,  3.649099490760695e-11, -1.221756787965464e-13, -5.417206814047344e-16,  1.183324322691773e-18,  8.529601457907325e-21, -1.057978702837697e-23,
 -1.381034903620456e-25,  5.515854149581561e-29,  1.370323372545179e+00, -2.666156166553283e-03, -3.676006279549674e-06,  1.151543152437945e-08,  4.825079608795816e-11,
 -6.586963807935044e-14, -6.879753721938497e-16, -5.172563563508760e-21,  9.888127579348184e-21,  1.320249832611910e-23, -1.366662930667910e-25, -3.963171848473831e-28,
  1.441905841340621e+00, -2.532437335300940e-03, -4.455550870731995e-06,  8.102707693395902e-09,  5.572879714179416e-11,  7.238819079369797e-15, -6.993447373564024e-16,
 -1.387452496613792e-18,  7.708975759138262e-21,  3.592160056431276e-23, -5.475180234002782e-26, -6.962932414557023e-28,  1.512018551148294e+00, -2.364747069284327e-03,
 -5.086364000947061e-06,  3.977894918250223e-09,  5.726404187480266e-11,  8.540439836656658e-14, -5.460858945445902e-16, -2.516931854184367e-18,  2.077410340730586e-21,
  4.470362907885091e-23,  7.762271411993602e-26, -5.551782349626653e-28,  1.580063153214490e+00, -2.165308708850994e-03, -5.521197700430158e-06, -5.380632936549126e-10,
  5.187347979340121e-11,  1.527867143404662e-13, -2.441122090552290e-16, -2.921532266397298e-18, -5.090241367782475e-21,  3.111332385211173e-23,  1.807951207848839e-25,
  3.504992245324962e-29,  1.645396580567523e+00, -1.937917877408026e-03, -5.720121915517421e-06, -5.016486527514782e-09,  3.967312782145284e-11,  1.928417350229071e-13,
  1.352832682636923e-16, -2.327082019261762e-18, -1.048962850370174e-20, -8.088591198506722e-25,  1.729094064876075e-25,  6.627512625437702e-28,  1.707337205058262e+00,
 -1.688100920375690e-03, -5.656548301835170e-06, -8.961649943995300e-09,  2.216693756925727e-11,  1.933867791962379e-13,  4.772789731245328e-16, -8.676682311042128e-19,
 -1.106253332939078e-20, -3.306165613827329e-23,  4.379932237662667e-26,  7.659623792030796e-28,  1.765174522079977e+00, -1.423181103141648e-03, -5.323511521484798e-06,
 -1.188047826548792e-08,  2.239279680415412e-12,  1.519638455223534e-13,  6.618042579965086e-16,  8.676850254434110e-19, -6.149313062056617e-21, -4.393749272157134e-23,
 -1.122112794546245e-25,  2.055191787937122e-28,  1.818182835905382e+00, -1.152208009322140e-03, -4.739163178070922e-06, -1.337605510119993e-08, -1.628702238559252e-11,
  7.912530947819558e-14,  6.187072475241025e-16,  2.067818034502657e-18,  1.437373304219557e-21, -2.562468005870843e-23, -1.643871688091628e-25, -4.690077558903618e-28,
  1.865639151612431e+00, -8.857079646196926e-04, -3.950091358677265e-06, -1.324903330968922e-08, -2.955139587224144e-11, -2.930629804842414e-15,  3.729684209746670e-16,
  2.160320476540951e-18,  6.876904714605682e-21,  6.291584991657188e-24, -7.552702606113136e-26, -5.640669115738529e-28,  1.906845057907951e+00, -6.352264233276311e-04,
 -3.030967032768992e-06, -1.158025265593796e-08, -3.483985581539348e-11, -6.756248102766811e-14,  4.616073679185147e-17,  1.220994310147660e-18,  6.919349421320138e-21,
  2.496406178339702e-23,  4.958522198417124e-26, -8.915872985274879e-29,  1.941151825203834e+00, -4.126593872777843e-04, -2.079324473339588e-06, -8.762353710298747e-09,
 -3.165785121655723e-11, -9.487853053501200e-14, -2.021913788764465e-16, -2.919805775844302e-20,  2.675918856322976e-21,  1.828501503181884e-23,  8.258764092936764e-26,
  2.761288515629756e-28,  1.967987322747607e+00, -2.294089173244139e-04, -1.205122818284240e-06, -5.453926234132309e-09, -2.218465554984857e-11, -8.173460135495445e-14,
 -2.686655822269754e-16, -7.477387852871184e-19, -1.461724994212213e-21,  4.143984238026882e-25,  2.413327213779877e-26,  1.644508544684192e-28,  1.986882927192100e+00,
 -9.544056389029051e-05, -5.160367697477396e-07, -2.449791250175873e-09, -1.073284074744695e-11, -4.425622773327554e-14, -1.730453660490932e-16, -6.418988461121544e-19,
 -2.245800467137565e-21, -7.303509559121767e-24, -2.136770168440935e-26, -5.159851884783617e-29,  1.997500736019951e+00, -1.834045407784607e-05, -1.007682541994696e-07,
 -4.910237464462819e-10, -2.236818657994349e-12, -9.749028546080566e-15, -4.114612564204142e-17, -1.693306883587531e-19, -6.823295637721662e-22, -2.699053029389836e-24,
 -1.049621360357592e-26, -4.015712946393542e-29,  4.078276430574697e-04, -1.853551930020198e-06,  6.317087005322228e-09, -1.913377034115592e-11,  5.431580316322782e-14,
 -1.479815561305773e-16,  3.917993242909774e-19, -1.015832459858474e-21,  2.591011405870490e-24, -6.524983058101447e-27,  1.625269437400168e-29, -4.014154117901119e-32,
  3.670012101341033e-03, -1.666339525090410e-05,  5.666540368375449e-08, -1.709721515324737e-10,  4.824568597231202e-13, -1.303249519447802e-15,  3.410643242491637e-18,
 -8.709348211612363e-21,  2.178750559610358e-23, -5.355604388337688e-26,  1.294861560347888e-28, -3.084715752504492e-31,  1.019204181059933e-02, -4.618387377990850e-05,
  1.563576597550438e-07, -4.681010185364685e-10,  1.304946910685941e-12, -3.463458107789531e-15,  8.845713905574474e-18, -2.186175405339499e-20,  5.238553533274533e-23,
 -1.217486666030891e-25,  2.736184183801377e-28, -5.923920591971503e-31,  1.996918912865101e-02, -9.021581886895140e-05,  3.033866682397816e-07, -8.975290374775196e-10,
  2.455467349615957e-12, -6.338103142241417e-15,  1.555660277507049e-17, -3.635912075892403e-20,  8.053543379359608e-23, -1.671710885511136e-25,  3.165996462081352e-28,
 -5.148376509656735e-31,  3.299423861164695e-02, -1.484585978401612e-04,  4.947458759627877e-07, -1.440033764183666e-09,  3.837712658457679e-12, -9.516611246411239e-15,
  2.199149017559242e-17, -4.688708808702914e-20,  8.957458300416122e-23, -1.419223331998017e-25,  1.333086572377886e-28,  2.129398669975850e-31,  4.925733566773632e-02,
 -2.205078627457001e-04,  7.264353118812302e-07, -2.070488661265297e-09,  5.329219365044352e-12, -1.249799383286399e-14,  2.636840766947002e-17, -4.786998509809557e-20,
  6.430594101119133e-23, -1.162669820883481e-26, -3.295751858916678e-28,  1.572755747994319e-30,  6.874578042833791e-02, -3.058525579790053e-04,  9.934710145027388e-07,
 -2.758314989667365e-09,  6.786502014681067e-12, -1.472937073193008e-14,  2.690106649441992e-17, -3.457608162439765e-20, -4.350132239326296e-24,  2.275954461268607e-25,
 -1.000734833682750e-27,  3.108082183696556e-30,  9.144376302088197e-02, -4.038711986646276e-04,  1.289899295372173e-06, -3.468072043207254e-09,  8.051509705544456e-12,
 -1.565234777946045e-14,  2.205497087635732e-17, -4.265717061294856e-21, -1.151478317836147e-22,  5.371529057517679e-25, -1.664201965921097e-27,  3.962067858769839e-30,
  1.173320353463842e-01, -5.138274400530109e-04,  1.608817628555387e-06, -4.160202299524770e-09,  8.959402992500025e-12, -1.475579614691204e-14,  1.081523019321601e-17,
  4.276669991162329e-20, -2.536547376200113e-22,  8.333561501813327e-25, -1.988605437906690e-27,  3.127440474562242e-30,  1.463875133017122e-01, -6.348649705309894e-04,
  1.942404452041476e-06, -4.791950831173112e-09,  9.347623961829442e-12, -1.163302408848010e-14, -7.057085318569467e-18,  1.024254585698009e-19, -3.916313865552905e-22,
  9.975345502755488e-25, -1.612440732001442e-27, -1.152486988798738e-31,  1.785828021255527e-01, -7.660017787204388e-04,  2.281960738252876e-06, -5.318480509125320e-09,
  9.066187564535908e-12, -6.040635067242046e-15, -3.080781982766100e-17,  1.664991906870639e-19, -4.894089242449972e-22,  9.003855851665001e-25, -2.774435156697724e-28,
 -5.676859720913613e-30,  2.138856361770886e-01, -9.061238702250849e-04,  2.617966848014637e-06, -5.694205765667503e-09,  7.989054520579782e-12,  2.044480676077036e-15,
 -5.854386871130964e-17,  2.229712626856491e-19, -5.017245783249630e-22,  4.391412464161985e-25,  2.016020512209039e-27, -1.224206655577090e-29,  2.522582229697727e-01,
 -1.053978544097877e-03,  2.940158932640796e-06, -5.874367423933245e-09,  6.026349050191493e-12,  1.237456611599948e-14, -8.719381569403808e-17,  2.570977098210201e-19,
 -3.869865532340575e-22, -4.176305394569192e-25,  4.876222110713567e-27, -1.719046369912288e-29,  2.936564796788462e-01, -1.208167385792811e-03,  3.237629993304940e-06,
 -5.816868584629440e-09,  3.137051474710993e-12,  2.439247979270129e-14, -1.126114306104067e-16,  2.533351770646584e-19, -1.192466207624042e-22, -1.587021655877450e-24,
  7.468685142604587e-27, -1.707773212293344e-29,  3.380291486307996e-01, -1.367139195658434e-03,  3.498961636079298e-06, -5.484385739249778e-09, -6.583806196754244e-13,
  3.721203736263138e-14, -1.298559498765847e-16,  1.981009045032903e-19,  2.987230627458523e-22, -2.843993917783079e-24,  8.607438400047094e-27, -8.786525033401169e-30,
  3.853167764927906e-01, -1.529183154128501e-03,  3.712393548374912e-06, -4.846758751814283e-09, -5.266234419526207e-12,  4.962505870918449e-14, -1.336751058160261e-16,
  8.319884508301193e-20,  8.238508275441308e-22, -3.824734220360673e-24,  7.033289386723100e-27,  8.772244753731619e-30,  4.354505400616797e-01, -1.692422631743745e-03,
  3.866038714814739e-06, -3.883646296738948e-09, -1.050965645997277e-11,  6.014369257246364e-14, -1.192009802501827e-16, -9.045217914796198e-20,  1.366244738261743e-21,
 -4.076436532211627e-24,  1.879745090731721e-27,  3.285908087595441e-29,  4.883508997933123e-01, -1.854810189983837e-03,  3.948153294513154e-06, -2.587407473660894e-09,
 -1.612203557382582e-11,  6.708664240774163e-14, -8.284224012918697e-17, -3.093934985679557e-19,  1.791937566682089e-21, -3.162945573428181e-24, -6.746520145292945e-27,
  5.581962727721817e-29,  5.439260606518705e-01, -2.014124494427392e-03,  3.947470745203950e-06, -9.661329031183511e-10, -2.174539107567814e-11,  6.871679071083079e-14,
 -2.331666749395929e-17, -5.453691586906788e-19,  1.939029225182987e-21, -8.227135108706722e-25, -1.724068223246024e-26,  6.576250904541033e-29,  6.020702187080736e-01,
 -2.167970082384937e-03,  3.853609966792675e-06,  9.533034250496208e-10, -2.693586564430812e-11,  6.343473449729925e-14,  5.728626571685656e-17, -7.553252806077410e-19,
  1.650023289438544e-21,  2.845525228969779e-24, -2.629680765592843e-26,  4.992784695346278e-29,  6.626615714859578e-01, -2.313781200209161e-03,  3.657566596234663e-06,
  3.122369983810388e-09, -3.117872491126659e-11,  5.002705748873358e-14,  1.525903972211595e-16, -8.848562486153883e-19,  8.199759871645861e-22,  7.221461493415027e-24,
 -2.934288924156658e-26,  9.229479665479454e-31,  7.255600708004918e-01, -2.448831257088131e-03,  3.352294611867898e-06,  5.468469396802735e-09, -3.391540510649230e-11,
  2.795884486469193e-14,  2.514172078835266e-16, -8.761305361518334e-19, -5.453718993074102e-22,  1.110617872223318e-23, -2.186271726761827e-26, -7.553235793545531e-29,
  7.906048993753666e-01, -2.570249835079827e-03,  2.933381398115638e-06,  7.893394360643881e-09, -3.458496731355788e-11, -2.313816809088278e-15,  3.379872964079505e-16,
 -6.807419459585966e-19, -2.274913524694034e-21,  1.286449349234297e-23, -1.592987583177019e-27, -1.548279415163924e-28,  8.576116577538256e-01, -2.675049645570029e-03,
  2.399812449670308e-06,  1.027317326045447e-08, -3.268158518902543e-11, -3.905410222833209e-14,  3.931877481454000e-16, -2.767384838613975e-19, -4.002896456123054e-21,
  1.084447445609400e-23,  2.891097894918665e-26, -1.949724827009274e-28,  9.263692570885976e-01, -2.760166314375904e-03,  1.754810783355350e-06,  1.245996411150054e-08,
 -2.782811611795553e-11, -7.904249218097174e-14,  3.972080934445747e-16,  3.128203530920642e-19, -5.193358310127689e-21,  4.078543213703137e-24,  6.050622899555402e-26,
 -1.505669983195567e-28,  9.966365278564095e-01, -2.822514375698714e-03,  1.006719501074830e-06,  1.428677222148256e-08, -1.986304145793479e-11, -1.175504430199874e-13,
  3.336689710543747e-16,  1.004915296818931e-18, -5.245411692984728e-21, -6.874360729999649e-24,  7.819798635726917e-26, -1.044645270036137e-31,  1.068138576334400e+00,
 -2.859063292506860e-03,  1.698723869907390e-07,  1.557582731848713e-08, -8.933794665991498e-12, -1.485940326117582e-13,  1.949980161065854e-16,  1.652881117750276e-18,
 -3.690574838286681e-21, -1.928712847903656e-23,  6.597347272861025e-26,  2.222641824037246e-28,  1.140562952157543e+00, -2.866937585759359e-03, -7.346341951468831e-07,
  1.615139619589407e-08,  4.416404643291348e-12, -1.655703457650978e-13, -1.178702926028152e-17,  2.062950177265628e-18, -4.562338771650652e-22, -2.834516912157771e-23,
  1.587377739307109e-26,  4.120065531345509e-28,  1.213555734124973e+00, -2.843545072477985e-03, -1.678394679968152e-06,  1.585753581021883e-08,  1.918829802272386e-11,
 -1.623426645464698e-13, -2.605050630226291e-16,  2.038127510557040e-18,  3.888510297087190e-21, -2.847117923184643e-23, -6.168885167371705e-26,  4.245187656763594e-28,
  1.286717700373567e+00, -2.786736528267200e-03, -2.625545718428643e-06,  1.458069303992575e-08,  3.392030991715432e-11, -1.347489250297998e-13, -5.048311610397216e-16,
  1.449118114185238e-18,  8.050170735255733e-21, -1.602339630109482e-23, -1.332850577500532e-25,  1.638041663459250e-28,  1.359600825340253e+00, -2.694998457807965e-03,
 -3.533235403376256e-06,  1.227600859909539e-08,  4.676846401859320e-11, -8.234662889395035e-14, -6.836265831559974e-16,  3.177645011646031e-19,  1.026104760298273e-20,
  7.412911023416201e-24, -1.521357643081625e-25, -3.033725178619630e-28,  1.431705440398094e+00, -2.567677649050021e-03, -4.352966625147263e-06,  8.994602021289593e-09,
  5.570273312020931e-11, -9.982584704696093e-15, -7.345487404371590e-16, -1.120557312762456e-18,  8.955309520887919e-21,  3.311491135028530e-23, -8.562595255995111e-26,
 -7.021827098555381e-28,  1.502478505521726e+00, -2.405231341446536e-03, -5.033077918775099e-06,  4.907048389180416e-09,  5.883540603291879e-11,  7.146166693068445e-14,
 -6.153833862840562e-16, -2.424156263693955e-18,  3.736393522564646e-21,  4.728181793648818e-23,  5.036039241262545e-26, -6.822340134441592e-28,  1.571313558545895e+00,
 -2.209489777877721e-03, -5.522574874554512e-06,  3.160118046199183e-10,  5.486391056209280e-11,  1.459290650492605e-13, -3.280171999214842e-16, -3.065102618896609e-18,
 -3.840023987325468e-21,  3.833098809107050e-23,  1.789312566618074e-25, -1.237156968222929e-28,  1.637553021476509e+00, -1.983908558841920e-03, -5.776383348769701e-06,
 -4.350708231485049e-09,  4.355695671825107e-11,  1.952687256267109e-13,  6.543108514526755e-17, -2.661824710590603e-18, -1.038731554307553e-20,  6.680252263166717e-24,
  2.012193242845977e-25,  6.177863141568974e-28,  1.700493624423226e+00, -1.733777138633234e-03, -5.761830448188553e-06, -8.575423680272935e-09,  2.614704088111290e-11,
  2.045088499036273e-13,  4.478521212759496e-16, -1.240306583231588e-18, -1.221276488101049e-20, -3.059948638421200e-23,  8.018683532500612e-26,  8.863214054720010e-28,
  1.759395719738248e+00, -1.466338612555026e-03, -5.465759176656366e-06, -1.181946474127118e-08,  5.439236290773571e-12,  1.681149619453718e-13,  6.831006960568611e-16,
  6.447530788383916e-19, -7.809269978427403e-21, -4.820013048337487e-23, -9.975619384949451e-26,  3.653851415551312e-28,  1.813497154588130e+00, -1.190767669851422e-03,
 -4.901184503322220e-06, -1.362316084783413e-08, -1.455131356921172e-11,  9.467336907476716e-14,  6.771021348081000e-16,  2.097745047239135e-18,  3.916030942598701e-22,
 -3.260696982240033e-23, -1.845303749257284e-25, -4.418451859873477e-28,  1.862032100016180e+00, -9.179526882584908e-04, -4.111916993917679e-06, -1.372181717749225e-08,
 -2.951546711666385e-11,  6.771534067562070e-15,  4.365678505149124e-16,  2.383371933598514e-18,  7.042761619966547e-21,  2.743348534026716e-24, -1.026585533136665e-25,
 -6.702493872722536e-28,  1.904254763129579e+00, -6.600395904023726e-04, -3.173319054185445e-06, -1.214842806756948e-08, -3.617712476222847e-11, -6.601850501159112e-14,
  8.358623006596669e-17,  1.457166650493406e-18,  7.852617347699079e-21,  2.684738368055324e-23,  4.400749414173762e-26, -1.679477612569016e-28,  1.939467240175357e+00,
 -4.297233329071032e-04, -2.187575345789469e-06, -9.284323648070317e-09, -3.360396130583303e-11, -9.973062642800687e-14, -2.017064687266892e-16,  6.762533318558766e-20,
  3.396643043630371e-21,  2.183944304395800e-23,  9.532582121262944e-26,  3.024620902216300e-28,  1.967049981929208e+00, -2.393178491046912e-04, -1.272754759385504e-06,
 -5.822315812388326e-09, -2.388555042104364e-11, -8.843908034892763e-14, -2.902534645628743e-16, -7.940741232453458e-19, -1.427578716711046e-21,  1.536444107229353e-24,
  3.228150145042588e-26,  2.073809833624079e-28,  1.986492717952104e+00, -9.968943612741377e-05, -5.464945745712268e-07, -2.628829609879562e-09, -1.166099503883670e-11,
 -4.863336429785044e-14, -1.920653810230090e-16, -7.181407388776090e-19, -2.524667300137821e-21, -8.204557630048399e-24, -2.370642051749066e-26, -5.457309902708418e-29,
  1.997425723714844e+00, -1.917079284124721e-05, -1.068818864221238e-07, -5.284280016861203e-10, -2.442071484267202e-12, -1.079599074281906e-14, -4.620827421187651e-17,
 -1.928045080493963e-19, -7.874988155644177e-22, -3.156484195873281e-24, -1.243360736618040e-26, -4.816161791125514e-29,  4.005130751277651e-04, -1.803919102715514e-06,
  6.092600039441287e-09, -1.828789313810674e-11,  5.144794748627381e-14, -1.389105356020590e-16,  3.644823502559496e-19, -9.365563877206487e-22,  2.367400619736681e-24,
 -5.908854314974524e-27,  1.458602140281636e-29, -3.570849668488729e-32,  3.604252355600466e-03, -1.621814940889204e-05,  5.465920776258789e-08, -1.634569957392833e-10,
  4.571910706438400e-13, -1.224243385402147e-15,  3.176259425867589e-18, -8.042022630016849e-21,  1.994953779986173e-23, -4.863813872880766e-26,  1.166473001232789e-28,
 -2.757590934962794e-31,  1.000977295661037e-02, -4.495513159573324e-05,  1.508634733574007e-07, -4.477646912188455e-10,  1.237752099475654e-12, -3.258321072892278e-15,
  8.256409377788839e-18, -2.025348178905544e-20,  4.819346081470462e-23, -1.113084086577761e-25,  2.488006449213857e-28, -5.366167776608852e-31,  1.961311275802204e-02,
 -8.783114853353165e-05,  2.928479262853160e-07, -8.592357115462863e-10,  2.332357890714986e-12, -5.976675598569360e-15,  1.457373970962100e-17, -3.387587709941374e-20,
  7.473984081528993e-23, -1.549520469384318e-25,  2.945540685006977e-28, -4.871625856772066e-31,  3.240821216657802e-02, -1.445687228764264e-04,  4.778277019306975e-07,
 -1.380124783142389e-09,  3.652553705327819e-12, -9.004250325785477e-15,  2.071802047498929e-17, -4.410140267191127e-20,  8.456340058622184e-23, -1.364263862364298e-25,
  1.409289008453662e-28,  1.360369471218684e-31,  4.838677184625829e-02, -2.147943329345267e-04,  7.020929144741794e-07, -1.987186897578835e-09,  5.085480536889066e-12,
 -1.188100430795099e-14,  2.505677684759965e-17, -4.582130522112382e-20,  6.366611278525026e-23, -2.349663951696629e-26, -2.656175072305039e-28,  1.339877348852242e-30,
  6.753805867749893e-02, -2.980353652163121e-04,  9.610131301656936e-07, -2.652052907111872e-09,  6.498292387294243e-12, -1.409537112854044e-14,  2.593216553323541e-17,
 -3.459165552884153e-20,  3.154751607582539e-24,  1.901939311758008e-25, -8.719272545218735e-28,  2.752933710532051e-30,  8.984865610212164e-02, -3.937163053540344e-04,
  1.249045138267578e-06, -3.341723551757534e-09,  7.743744190612990e-12, -1.512486071706156e-14,  2.188676199070790e-17, -7.653559974122944e-21, -9.696740836248784e-23,
  4.739761005888560e-25, -1.496977979185588e-27,  3.640886458677392e-30,  1.153021539038122e-01, -5.011541741125590e-04,  1.559745611579932e-06, -4.019198284981209e-09,
  8.666975095039556e-12, -1.448275104808598e-14,  1.190346269707699e-17,  3.511467839231923e-20, -2.250525811485090e-22,  7.565597836992859e-25, -1.851411463441123e-27,
  3.100390268591939e-30,  1.438787712686633e-01, -6.195532237380816e-04,  1.885790708966584e-06, -4.644258384044280e-09,  9.113494900902993e-12, -1.176936258425276e-14,
 -4.359313438536701e-18,  9.045538635538510e-20, -3.568807793170037e-22,  9.331030600165904e-25, -1.605224873398016e-27,  4.217812814402552e-31,  1.755549056469556e-01,
 -7.479989233108640e-04,  2.219005213453359e-06, -5.174426629484532e-09,  8.938349587301119e-12, -6.725818855533920e-15, -2.636024278863186e-17,  1.513541193536836e-19,
 -4.572515802766338e-22,  8.846651156118227e-25, -4.996880449235737e-28, -4.455712229307634e-30,  2.103025984774002e-01, -8.854512816728566e-04,  2.550404435850321e-06,
 -5.566128027396292e-09,  8.016389992137002e-12,  7.125470737081653e-16, -5.252296432354630e-17,  2.071835624506775e-19, -4.845890954743505e-22,  5.095206293130664e-25,
  1.515328699486926e-27, -1.054233180623122e-29,  2.480889072223801e-01, -1.030737585023475e-03,  2.870252858596033e-06, -5.776077187057870e-09,  6.253489668180041e-12,
  1.036688744414761e-14, -8.017045005985117e-17,  2.445097770090045e-19, -3.986885324486670e-22, -2.372557353961774e-25,  4.153757651800024e-27, -1.564792226656745e-29,
  2.888751713858785e-01, -1.182544666125968e-03,  3.168144357166584e-06, -5.762917406235691e-09,  3.598446446292165e-12,  2.177444411619157e-14, -1.055796545116008e-16,
  2.486613543418441e-19, -1.711822311075904e-22, -1.303209580613465e-24,  6.724759990646708e-27, -1.668888224702240e-29,  3.326161582414074e-01, -1.339410876693217e-03,
  3.433109819299125e-06, -5.489133331179234e-09,  5.514918213797694e-14,  3.416304440582698e-14, -1.241902191143672e-16,  2.060875599781244e-19,  2.024381537208487e-22,
 -2.508003041383804e-24,  8.178996967639397e-27, -1.058775484096956e-29,  3.792590718951785e-01, -1.499718008275613e-03,  3.653759075033640e-06, -4.923251961431912e-09,
 -4.305611712392085e-12,  4.644766475856365e-14, -1.309967613725659e-16,  1.074139928779783e-19,  6.913047097248438e-22, -3.537064209679853e-24,  7.317417058937200e-27,
  4.268968879252459e-30,  4.287424070805662e-01, -1.661683505269406e-03,  3.818465221423216e-06, -4.042334021318419e-09, -9.335571030248922e-12,  5.725728244331369e-14,
 -1.211435060393051e-16, -4.906315354348714e-20,  1.221176940546755e-21, -3.974293213123035e-24,  3.179813752837844e-27,  2.632391134596372e-29,  4.809946267857998e-01,
 -1.823353443124441e-03,  3.915600608902215e-06, -2.834737036552580e-09, -1.480085353290048e-11,  6.500084511798481e-14, -9.071993196129666e-17, -2.539207415052491e-19,
  1.673789287198119e-21, -3.385517802056814e-24, -4.427855292149728e-27,  4.954002016774488e-29,  5.359326405671823e-01, -1.982596913364765e-03,  3.933834833532198e-06,
 -1.303099944914874e-09, -2.037785205534535e-11,  6.798092619756976e-14, -3.772368767663602e-17, -4.839215779611873e-19,  1.897690422193310e-21, -1.455057622548593e-24,
 -1.439356132599516e-26,  6.342854494549323e-29,  5.934600583733821e-01, -2.137102673770783e-03,  3.862505854306760e-06,  5.325467513397889e-10, -2.565510411711305e-11,
  6.456186956831906e-14,  3.689034633441989e-17, -7.010841168389520e-19,  1.734074511641490e-21,  1.839375793504905e-24, -2.397082979629564e-26,  5.540104158254827e-29,
  6.534651931799813e-01, -2.284379197000959e-03,  3.692075517966774e-06,  2.631705324816047e-09, -3.014355260654082e-11,  5.339511247866201e-14,  1.282192408591306e-16,
 -8.546836230554352e-19,  1.058873864639985e-21,  6.053174109207068e-24, -2.896183136563700e-26,  1.597602657111792e-29,  7.158187851247498e-01, -2.421759594066417e-03,
  3.414679857698091e-06,  4.930615806744631e-09, -3.329788379004276e-11,  3.369686917681924e-14,  2.267000938330850e-16, -8.873601707864339e-19, -1.620326178470389e-22,
  1.017166259036669e-23, -2.470494739031062e-26, -5.382963413150775e-29,  7.803714207536913e-01, -2.546413308763030e-03,  3.024781856068726e-06,  7.340098785185299e-09,
 -3.455171132166548e-11,  5.561350084442881e-15,  3.179768200434455e-16, -7.461545272493767e-19, -1.814530672329917e-21,  1.267003268840881e-23, -7.989532524768138e-27,
 -1.355510188733933e-28,  8.469506243080938e-01, -2.655366979092606e-03,  2.519928973920020e-06,  9.744529067629110e-09, -3.336900306456111e-11, -2.972468658185017e-14,
  3.837059574620487e-16, -3.983783157601725e-19, -3.593742672401697e-21,  1.182989619671887e-23,  2.038495855436998e-26, -1.915738156002914e-28,  9.153576049207579e-01,
 -2.745537435845315e-03,  1.901608370636059e-06,  1.200258805630761e-08, -2.931302296059494e-11, -6.942301744399578e-14,  4.036657647899274e-16,  1.494358120317984e-19,
 -5.004633090554585e-21,  6.358691272166354e-24,  5.332688282721136e-26, -1.744933199544306e-28,  9.853636558009589e-01, -2.813780433174489e-03,  1.176177767190419e-06,
  1.395059981444209e-08, -2.213178953544500e-11, -1.092239106863433e-13,  3.594237503254240e-16,  8.337052508364962e-19, -5.436726782598180e-21, -3.761801378175836e-24,
  7.705969365908401e-26, -5.091569717830848e-29,  1.056706221159256e+00, -2.856959327825583e-03,  3.558274645339521e-07,  1.540938132332668e-08, -1.185519868415261e-11,
 -1.433726801905107e-13,  2.395246650926995e-16,  1.524200798935009e-18, -4.335203509283200e-21, -1.646912356660072e-23,  7.450915778419488e-26,  1.649694599679929e-28,
  1.129084676537583e+00, -2.872038442710512e-03, -5.405027386032572e-07,  1.619557164215799e-08,  1.106835103545155e-12, -1.651626705706057e-13,  4.561885613683827e-17,
  2.032181507910683e-18, -1.460919832601165e-21, -2.735422411613318e-23,  3.348402610083727e-26,  3.860201387367130e-28,  1.202155911733213e+00, -2.856206097852312e-03,
 -1.486370366569380e-06,  1.613825369730900e-08,  1.588361458041484e-11, -1.678968775343446e-13, -2.018527058654217e-16,  2.145721548685984e-18,  2.823755260438609e-21,
 -3.055202503424788e-23, -4.205974367009139e-26,  4.648118487789128e-28,  1.275529866411736e+00, -2.807032003449117e-03, -2.447412079955270e-06,  1.510121418289366e-08,
  3.110760658483230e-11, -1.463494291969643e-13, -4.607433410268212e-16,  1.696481129930439e-18,  7.379387567899522e-21, -2.117915946791675e-23, -1.237331236377852e-25,
  2.694369865419725e-28,  1.348765250506014e+00, -2.722662502540826e-03, -3.381490754176381e-06,  1.301024080910692e-08,  4.495837440057025e-11, -9.860959008886771e-14,
 -6.701006247158614e-16,  6.491891390460477e-19,  1.041544449130123e-20,  1.092264349450002e-24, -1.630792009883115e-25, -1.912199653178970e-28,  1.421365787287589e+00,
 -2.602054511457942e-03, -4.239693657467200e-06,  9.883280614856754e-09,  5.532442024473842e-11, -2.795480292402468e-14, -7.617382102851875e-16, -8.156344244969737e-19,
  1.007839186322090e-20,  2.907703630744228e-23, -1.160842102365802e-25, -6.769462410223782e-28,  1.492777446574216e+00, -2.445244319948927e-03, -4.968500636232816e-06,
  5.859023477854241e-09,  6.011152591807842e-11,  5.589304514403493e-14, -6.813275466720849e-16, -2.277029358595541e-18,  5.467248891938442e-21,  4.866150811147443e-23,
  1.780686662590885e-26, -7.943072960468303e-28,  1.562387283609794e+00, -2.253640066436471e-03, -5.513420950141049e-06,  1.216725876810461e-09,  5.769674990948629e-11,
  1.370142163529197e-13, -4.153431850076264e-16, -3.164537100257943e-18, -2.333057670855867e-21,  4.532770708056692e-23,  1.695919483637292e-25, -3.038503316039210e-28,
  1.629524651571467e+00, -2.030316314900708e-03, -5.824281296821543e-06, -3.622494618684839e-09,  4.747180470402234e-11,  1.959074170781754e-13, -1.370599365579261e-17,
 -2.988765663309210e-18, -9.995593188764837e-21,  1.525059136816527e-23,  2.266745423939242e-25,  5.321695861312418e-28,  1.693465685304326e+00, -1.780275975974514e-03,
 -5.862088583062397e-06, -8.123778226059588e-09,  3.034165690830500e-11,  2.147954026406216e-13,  4.074914788444563e-16, -1.648043075311667e-18, -1.324691581224966e-20,
 -2.657963806684980e-23,  1.215731533046563e-25,  9.915374977684881e-28,  1.753442017294775e+00, -1.510630279453278e-03, -5.606956730072505e-06, -1.170464219418747e-08,
  8.966789155744582e-12,  1.846961473389167e-13,  6.973890772232407e-16,  3.663576493226671e-19, -9.611942123757433e-21, -5.181546013014689e-23, -7.963993595596351e-26,
  5.534895503563320e-28,  1.808654624205814e+00, -1.230634865816855e-03, -5.065993960499332e-06, -1.383993120309476e-08, -1.249058146246546e-11,  1.116289421863815e-13,
  7.358275926968335e-16,  2.090032977798034e-18, -9.196631452126913e-22, -4.036202435208150e-23, -2.027869024187818e-25, -3.819257698201820e-28,  1.858293444417567e+00,
 -9.515146855355612e-04, -4.279405908514510e-06, -1.419238877267735e-08, -2.926972276917218e-11,  1.807550353181301e-14,  5.064662749335334e-16,  2.609468331546729e-18,
  7.060206164896483e-21, -1.985201014874720e-24, -1.345751291115227e-25, -7.808567623593508e-28,  1.901562894359231e+00, -6.860192071300335e-04, -3.322616374959728e-06,
 -1.273770163348340e-08, -3.747397873090371e-11, -6.349352762156741e-14,  1.280524972357884e-16,  1.724238122589745e-18,  8.848773085601739e-21,  2.843157750832811e-23,
  3.445595992640305e-26, -2.704738594962716e-28,  1.937712626923670e+00, -4.476788767812840e-04, -2.302279881761392e-06, -9.838206080095088e-09, -3.564676335547716e-11,
 -1.045358238738759e-13, -1.981676686467549e-16,  1.896598014211785e-19,  4.254769190815752e-21,  2.592563655429283e-23,  1.091479678094592e-25,  3.249427953229633e-28,
  1.966071894608211e+00, -2.497859921328196e-04, -1.344975178675663e-06, -6.219021014211249e-09, -2.572582024742225e-11, -9.567707405243929e-14, -3.131168956526675e-16,
 -8.386037221482801e-19, -1.346692239289443e-21,  3.024922709839740e-24,  4.252537941546678e-26,  2.599888595524057e-28,  1.986085011925975e+00, -1.041908239204216e-04,
 -5.791929138015351e-07, -2.823444326550357e-09, -1.268143512274667e-11, -5.349363750425706e-14, -2.133501079365932e-16, -8.038436690525119e-19, -2.837684829504916e-21,
 -9.201495115854422e-24, -2.615435232744006e-26, -5.647089025172216e-29,  1.997347289312873e+00, -2.005189353085685e-05, -1.134647869840510e-07, -5.692906476524461e-10,
 -2.669533740730706e-12, -1.197272776896694e-14, -5.197739193803193e-17, -2.199228980359580e-19, -9.106197270999859e-22, -3.698935946712315e-24, -1.475976440758651e-26,
 -5.788653172098204e-29,  3.933935099191272e-04, -1.756042335528664e-06,  5.877994159366273e-09, -1.748648514351940e-11,  4.875513185073984e-14, -1.304692742225859e-16,
  3.392881735260084e-19, -8.640934653959856e-22,  2.164816013909417e-24, -5.355650513933210e-27,  1.310263791397511e-29, -3.179863595298049e-32,  3.540242055698850e-03,
 -1.578859916093118e-05,  5.274081936627433e-08, -1.563337509909816e-10,  4.334506319574671e-13, -1.150644727537577e-15,  2.959763240981009e-18, -7.430775672697631e-21,
  1.827970725746833e-23, -4.420611858677741e-26,  1.051650909764123e-28, -2.467292148685207e-31,  9.832332684538710e-03, -4.376938472912590e-05,  1.456070051281011e-07,
 -4.284714123656941e-10,  1.174522166545786e-12, -3.066801785170632e-15,  7.710313588048859e-18, -1.877352921118054e-20,  4.435994343993374e-23, -1.018133958261280e-25,
  2.263171200219148e-28, -4.862028051610468e-31,  1.926640931259618e-02, -8.552898299871685e-05,  2.827571201882338e-07, -8.228555669353307e-10,  2.216246620943148e-12,
 -5.638022955034167e-15,  1.365787597087377e-17, -3.157122205131469e-20,  6.936855484703538e-23, -1.435903872895609e-25,  2.737317615459151e-28, -4.593187424786732e-31,
  3.183747901357438e-02, -1.408113672689635e-04,  4.616109932623553e-07, -1.323098002012301e-09,  3.477342562950805e-12, -8.521534623348774e-15,  1.952033508276608e-17,
 -4.147285694919336e-20,  7.975478418238574e-23, -1.306888572208251e-25,  1.454931528908693e-28,  7.361100848526096e-32,  4.753867890422733e-02, -2.092716091881055e-04,
  6.787271410298005e-07, -1.907687927728544e-09,  4.853771340670851e-12, -1.129480825761765e-14,  2.380216158607682e-17, -4.379946265184108e-20,  6.264263325720964e-23,
 -3.300376592129980e-26, -2.112082780351837e-28,  1.138058600375566e-30,  6.636109433806731e-02, -2.904728123858992e-04,  9.298031370429217e-07, -2.550302001780494e-09,
  6.222530315521808e-12, -1.348460445270807e-14,  2.496599518940600e-17, -3.438765194802753e-20,  9.402254380791822e-24,  1.576429121461398e-25, -7.579497374832015e-28,
  2.433523970182016e-30,  8.829352457544851e-02, -3.838822634847087e-04,  1.209677964916559e-06, -3.220215161057104e-09,  7.446480694173088e-12, -1.460248529876458e-14,
  2.163150546525162e-17, -1.049475564101380e-20, -8.094432236843571e-23,  4.172091851409873e-25, -1.343613569682311e-27,  3.332580607214476e-30,  1.133221909773016e-01,
 -4.888667952317069e-04,  1.512337754312667e-06, -3.882828081544865e-09,  8.380252444386238e-12, -1.418605853976100e-14,  1.278984427606858e-17,  2.833474713976041e-20,
 -1.991167281795416e-22,  6.852135887050880e-25, -1.716415474042215e-27,  3.029557646972708e-30,  1.414303815373721e-01, -6.046873615203508e-04,  1.830926719973388e-06,
 -4.500330409876834e-09,  8.877260027523793e-12, -1.184485298112734e-14, -1.981483357826025e-18,  7.956032073047118e-20, -3.244391530397091e-22,  8.693960241518470e-25,
 -1.577091429600959e-27,  8.388527446816820e-31,  1.725980241992785e-01, -7.304928332898992e-04,  2.157765628940049e-06, -5.032522129341498e-09,  8.797841602290293e-12,
 -7.309233839625442e-15, -2.232241797544350e-17,  1.372274141985584e-19, -4.258077266308102e-22,  8.610763114671387e-25, -6.721431803223628e-28, -3.410714345687372e-30,
  2.068011798751253e-01, -8.653130392255292e-04,  2.484380726698728e-06, -5.437818328852711e-09,  8.018496331866378e-12, -4.801253222510724e-16, -4.693608467712910e-17,
  1.919810143883998e-19, -4.652628471573834e-22,  5.613221596395941e-25,  1.085989235278430e-27, -8.998861201323733e-30,  2.440114443674312e-01, -1.008051097820580e-03,
  2.801546777162768e-06, -5.674464890936883e-09,  6.442133577110907e-12,  8.523503491603314e-15, -7.350385183820347e-17,  2.316458320605009e-19, -4.044008422684332e-22,
 -8.442328671400117e-26,  3.499008473230374e-27, -1.411838883216941e-29,  2.841952464736934e-01, -1.157475120312311e-03,  3.099348730755451e-06, -5.701993672323472e-09,
  4.009156799121155e-12,  1.932342209876707e-14, -9.870051733906016e-17,  2.424833631155633e-19, -2.134313691633768e-22, -1.048732090671963e-24,  6.003806072659349e-27,
 -1.604582341160346e-29,  3.273130274059368e-01, -1.312209410652664e-03,  3.367267542066448e-06, -5.482944827128860e-09,  7.090752615451178e-13,  3.125237539182697e-14,
 -1.183422036832786e-16,  2.111831769615638e-19,  1.179229191271888e-22, -2.190562539417805e-24,  7.684024665781065e-27, -1.182530701691282e-29,  3.733182842784621e-01,
 -1.470725353399978e-03,  3.594296817799556e-06, -4.984879876177811e-09, -3.407841597808842e-12,  4.334221771561027e-14, -1.276982031221962e-16,  1.275551820806087e-19,
  5.692735594874314e-22, -3.241769897770073e-24,  7.419915526617694e-27,  5.084222540048184e-31,  4.221564578142347e-01, -1.631332268803625e-03,  3.769098275356072e-06,
 -4.182700353063683e-09, -8.219588834333771e-12,  5.433763758544824e-14, -1.219915083394302e-16, -1.224797910459353e-20,  1.080654537626105e-21, -3.825734064247118e-24,
  4.204713858946558e-27,  2.036173353684715e-29,  4.737636416287813e-01, -1.792168633441998e-03,  3.880205393535183e-06, -3.061271166540217e-09, -1.352315450868199e-11,
  6.274418806934006e-14, -9.709839711163315e-17, -2.023395743028512e-19,  1.549230825989730e-21, -3.520913705922035e-24, -2.388403404165795e-27,  4.316367047657722e-29,
  5.280650875461725e-01, -1.951194223280583e-03,  3.916286056170336e-06, -1.618322305432587e-09, -1.902834950596257e-11,  6.691976985207194e-14, -5.043196219981313e-17,
 -4.241393130936236e-19,  1.835608958608161e-21, -1.975945067664701e-24, -1.167652258952769e-26,  5.990331797031695e-29,  5.849734785236969e-01, -2.106183944466683e-03,
  3.866476274022884e-06,  1.324365288192525e-10, -2.435657045909133e-11,  6.521799871873123e-14,  1.804551974919784e-17, -6.447144700937863e-19,  1.783630781140206e-21,
  9.303920579698306e-25, -2.145511713110977e-26,  5.859640275575388e-29,  6.443869381430687e-01, -2.254724387841205e-03,  3.720797961125915e-06,  2.158110833796537e-09,
 -2.904679554793187e-11,  5.618922284732126e-14,  1.047936497451364e-16, -8.175350069448385e-19,  1.256140485260744e-21,  4.912617541290424e-24, -2.797521153299945e-26,
  2.844101324437308e-29,  7.061867436365179e-01, -2.394214489572623e-03,  3.470673824951967e-06,  4.403528328149895e-09, -3.257155253431126e-11,  3.883926392500461e-14,
  2.018350826945398e-16, -8.868813238734992e-19,  1.858447249226693e-22,  9.142208229733625e-24, -2.661926140861432e-26, -3.344711219406664e-29,  7.702347086224817e-01,
 -2.521872116126847e-03,  3.109551071147803e-06,  6.788568645761832e-09, -3.436589429207432e-11,  1.293594347003383e-14,  2.963396482243749e-16, -7.969945522466105e-19,
 -1.365544007573440e-21,  1.223726363040635e-23, -1.349561642506822e-26, -1.145177602004717e-28,  8.363702029703206e-01, -2.634748928225361e-03,  2.633641890003869e-06,
  9.206365400047032e-09, -3.387237635924719e-11, -2.066219496021020e-14,  3.710064184185278e-16, -5.064230478908124e-19, -3.155200632208649e-21,  1.247898723411764e-23,
  1.213537509374995e-26, -1.825575363089852e-28,  9.044067817169895e-01, -2.729756519893148e-03,  2.042781266109768e-06,  1.152299948620218e-08, -3.060435718213120e-11,
 -5.970269955331450e-14,  4.056451516379076e-16, -6.653503975313001e-21, -4.739224610349287e-21,  8.332893432387053e-24,  4.526558193911366e-26, -1.906478827315611e-28,
  9.741284044445120e-01, -2.803707565029970e-03,  1.341389764425018e-06,  1.357949162652320e-08, -2.422821726107025e-11, -1.003373789057917e-13,  3.803156967415409e-16,
  6.581528778428165e-19, -5.517335444176805e-21, -7.380726621501136e-25,  7.379448217293714e-26, -9.651203548905521e-29,  1.045285243363294e+00, -2.853376498246184e-03,
  5.395083660771381e-07,  1.519708507726236e-08, -1.466179274595476e-11, -1.371281597874145e-13,  2.801751634358366e-16,  1.376576426106476e-18, -4.872856563076835e-21,
 -1.336124666643450e-23,  8.044392195801166e-26,  1.044962675147045e-28,  1.117589105681011e+00, -2.875585026686520e-03, -3.461583847888716e-07,  1.618693370328245e-08,
 -2.180891921341676e-12, -1.633911875806471e-13,  1.017194375350994e-16,  1.969967131665952e-18, -2.417566634631273e-21, -2.568596066183469e-23,  4.963847823316070e-26,
  3.461468664392118e-28,  1.190708537684033e+00, -2.867318361075464e-03, -1.291298103538842e-06,  1.636528541211184e-08,  1.248214729546946e-11, -1.720111962272464e-13,
 -1.406748885093842e-16,  2.218199547730403e-18,  1.698601907735467e-21, -3.181755331554341e-23, -2.105703323758588e-26,  4.867150222896845e-28,  1.264263739144157e+00,
 -2.825878206811439e-03, -2.263309671067365e-06,  1.557493579148371e-08,  2.807402201224785e-11, -1.568113059043399e-13, -4.100571925907569e-16,  1.919492080451625e-18,
  6.530976303629554e-21, -2.586195550824169e-23, -1.096972511334039e-25,  3.667613402302504e-28,  1.337821502481377e+00, -2.749077863867797e-03, -3.221119754841173e-06,
  1.371293031177539e-08,  4.282702544271049e-11, -1.144362243298376e-13, -6.472603589452101e-16,  9.818392419756024e-19,  1.033565151625736e-20, -5.562726242303516e-24,
 -1.687457028588890e-25, -6.436009369720197e-29,  1.410890506452947e+00, -2.635482663986452e-03, -4.115804833109103e-06,  1.076299816655957e-08,  5.458084948500799e-11,
 -4.647319592172762e-14, -7.799102123738520e-16, -4.773311085822628e-19,  1.103453587497855e-20,  2.385266731020541e-23, -1.447103882141004e-25, -6.187521438459896e-28,
  1.482917441757460e+00, -2.484694662497686e-03, -4.892387694856752e-06,  6.828841027767959e-09,  6.106081296033637e-11,  3.879749359797376e-14, -7.423711094670605e-16,
 -2.073980974807973e-18,  7.223202224273719e-21,  4.864671096767852e-23, -1.919350998831882e-26, -8.829806051460807e-28,  1.553284623505525e+00, -2.297673133086832e-03,
 -5.493192759293090e-06,  2.161224284056486e-09,  6.033013766830271e-11,  1.259758129905454e-13, -5.047409537545957e-16, -3.211806455916663e-18, -5.828895584986295e-22,
  5.178742750916320e-23,  1.519734294083289e-25, -4.987624736399445e-28,  1.621309941122974e+00, -2.077071235166819e-03, -5.863064777286748e-06, -2.831647525506388e-09,
  5.137970067305059e-11,  1.945386748593192e-13, -1.017741902423096e-16, -3.298046609410253e-18, -9.278036157185511e-21,  2.475085254930198e-23,  2.473890836201536e-25,
  4.017809774191705e-28,  1.686250182661849e+00, -1.827554043203337e-03, -5.956517681469649e-06, -7.603429644353775e-09,  3.473137397320585e-11,  2.239727063644777e-13,
  3.552749988876053e-16, -2.086228797575517e-18, -1.410549871308841e-20, -2.081853604819284e-23,  1.670611603080503e-25,  1.070871309660297e-27,  1.747308899137313e+00,
 -1.556045030491406e-03, -5.746426771439298e-06, -1.153070994863372e-08,  1.282872936210747e-11,  2.015200802551524e-13,  7.030564263585470e-16,  2.836623775058235e-20,
 -1.152821658440009e-20, -5.445284260918376e-23, -5.067378393348998e-26,  7.669546073695399e-28,  1.803649972439701e+00, -1.271830355628354e-03, -5.233195393336006e-06,
 -1.402094053702917e-08, -1.007668689208727e-11,  1.299863306302298e-13,  7.937067233387596e-16,  2.035758368165772e-18, -2.522517372430943e-21, -4.878314800298606e-23,
 -2.175350328552843e-25, -2.809786594012484e-28,  1.854417825361550e+00, -9.864390969386162e-04, -4.452510329046034e-06, -1.465712652417301e-08, -2.878061099820719e-11,
  3.113290031545481e-14,  5.826758108094362e-16,  2.833143375395683e-18,  6.883267608854057e-21, -8.087937013137496e-24, -1.713613744250381e-25, -8.905338769386113e-28,
  1.898764673087608e+00, -7.132218360717597e-04, -3.479107615090895e-06, -1.334726027452781e-08, -3.870903670011219e-11, -5.980797187245155e-14,  1.804510379348292e-16,
  2.024016043962518e-18,  9.893923908101735e-21,  2.953556277621440e-23,  1.979329488122564e-26, -4.009771904279540e-28,  1.935884313334825e+00, -4.665792062100536e-04,
 -2.423830269084176e-06, -1.042553634253727e-08, -3.778452664035045e-11, -1.092118437681644e-13, -1.908045769920838e-16,  3.416164912568844e-19,  5.270172463742105e-21,
  3.058267102050172e-23,  1.238159067886545e-25,  3.402694395866930e-28,  1.965050748317381e+00, -2.608514521158800e-04, -1.422137601086202e-06, -6.646358844159800e-09,
 -2.771643643208024e-11, -1.034784071060694e-13, -3.371822717391860e-16, -8.796037882277290e-19, -1.204257799745943e-21,  4.972694349355344e-24,  5.532980216645771e-26,
  3.240848132294168e-28,  1.985658761982707e+00, -1.089634250654493e-04, -6.143278918462169e-07, -3.035192320247553e-09, -1.380438937235727e-11, -5.889470605385899e-14,
 -2.371802797261230e-16, -9.001564312182650e-19, -3.188370680710574e-21, -1.029756324083358e-23, -2.865028832065588e-26, -5.662569263160178e-29,  1.997265221986406e+00,
 -2.098768254053337e-05, -1.205606774145879e-07, -6.139887569902696e-10, -2.921979210340719e-12, -1.329749931230838e-14, -5.856405155058223e-17, -2.513124390864391e-19,
 -1.055052185018781e-21, -4.343582973464166e-24, -1.755876980617898e-26, -6.972719750105425e-29,  3.864620779747735e-04, -1.709844667623883e-06,  5.672752131591289e-09,
 -1.672684377358694e-11,  4.622525547701019e-14, -1.226090400881437e-16,  3.160351149187777e-19, -7.978057287081919e-22,  1.981118893661751e-24, -4.858480558290341e-27,
  1.178099565557482e-29, -2.834659863334096e-32,  3.477919794970225e-03, -1.537406045172798e-05,  5.090567850110309e-08, -1.495788540751326e-10,  4.111315630605792e-13,
 -1.082042492921572e-15,  2.759657255105763e-18, -6.870496652927369e-21,  1.676146105554125e-23, -4.020882603711025e-26,  9.488727281894916e-29, -2.209470188734878e-31,
  9.659552738828774e-03, -4.262478044295802e-05,  1.405761103054042e-07, -4.101598676185550e-10,  1.114994842590506e-12, -2.887905084593136e-15,  7.203989228916785e-18,
 -1.741094938423396e-20,  4.085257958063330e-23, -9.317482426934311e-26,  2.059432122872514e-28, -4.406456893613183e-31,  1.892875579738530e-02, -8.330582874090240e-05,
  2.730919488458392e-07, -7.882801909084085e-10,  2.106693724906798e-12, -5.320595727456393e-15,  1.280419659446901e-17, -2.943206219275048e-20,  6.439159138362305e-23,
 -1.330371711468571e-25,  2.541298440237167e-28, -4.317545147307061e-31,  3.128152008337091e-02, -1.371810549790798e-04,  4.460620992988726e-07, -1.268798901716224e-09,
  3.311504162620727e-12, -8.066697374935403e-15,  1.839412598335129e-17, -3.899485204513511e-20,  7.515537733667131e-23, -1.248199664869380e-25,  1.475852471328832e-28,
  2.330879334940151e-32,  4.671230895891379e-02, -2.039320578231037e-04,  6.562934927831098e-07, -1.831804130490539e-09,  4.633489522920045e-12, -1.073804763700802e-14,
  2.260365084164388e-17, -4.181544436230088e-20,  6.131400749566938e-23, -4.050385601084324e-26, -1.650677337657958e-28,  9.634262977323469e-31,  6.521388847845720e-02,
 -2.831551295441049e-04,  8.997880806563941e-07, -2.452866824480483e-09,  5.958752271334592e-12, -1.289693578094244e-14,  2.400816577800614e-17, -3.400162465256546e-20,
  1.455668771023015e-23,  1.293798072079595e-25, -6.572917689567146e-28,  2.147036766835253e-30,  8.677710846301152e-02, -3.743574066633905e-04,  1.171740698576410e-06,
 -3.103379765116852e-09,  7.159597292279742e-12, -1.408713458596079e-14,  2.130357486986219e-17, -1.285475260160482e-20, -6.685765271478670e-23,  3.663099066279981e-25,
 -1.203484321842494e-27,  3.039611772954551e-30,  1.113906292952357e-01, -4.769522109696207e-04,  1.466539013500944e-06, -3.750996876763755e-09,  8.099661473347751e-12,
 -1.387027948255936e-14,  1.349762830825048e-17,  2.234470321354248e-20, -1.756529876841444e-22,  6.191945643177136e-25, -1.585290211867467e-27,  2.926114622322599e-30,
  1.390405882788132e-01, -5.902535670227981e-04,  1.777767148064268e-06, -4.360191273094088e-09,  8.640061912725158e-12, -1.186682099972620e-14,  1.054756985546036e-19,
  6.966694309507608e-20, -2.942665864000641e-22,  8.071502976741125e-25, -1.532895659897027e-27,  1.154800002237594e-30,  1.697101980079931e-01, -7.134698876004477e-04,
  2.098215041301215e-06, -4.892953970483656e-09,  8.646602940312212e-12, -7.800374730241407e-15, -1.866619070802787e-17,  1.240920809032113e-19, -3.953265944412583e-22,
  8.314610517563202e-25, -8.021629091647001e-28, -2.523907549553842e-30,  2.033792676133078e-01, -8.456968287792033e-04,  2.419896172181094e-06, -5.309658614615795e-09,
  7.998055963472606e-12, -1.543749171267876e-15, -4.176596074228015e-17,  1.774235595461526e-19, -4.443649184329318e-22,  5.972625832676219e-25,  7.211460287130749e-28,
 -7.610120327655993e-30,  2.400236359553409e-01, -9.859093333138673e-04,  2.734076964289141e-06, -5.570120663234347e-09,  6.595480529310824e-12,  6.835779861514434e-15,
 -6.719921133865960e-17,  2.186822010411940e-19, -4.050664810298945e-22,  4.355414993171365e-26,  2.910684543827658e-27, -1.263300426515415e-29,  2.796145037978180e-01,
 -1.132952907125076e-03,  3.031322028560995e-06, -5.634881827350476e-09,  4.372482938488007e-12,  1.703527906293673e-14, -9.201195364529683e-17,  2.350944717206731e-19,
 -2.470310378850155e-22, -8.224676525156657e-25,  5.315457109974636e-27, -1.521728167763218e-29,  3.221176496738563e-01, -1.285534212288339e-03,  3.301560407566069e-06,
 -5.466751543892169e-09,  1.306201506117405e-12,  2.848347568864368e-14, -1.123876836300707e-16,  2.137532333625382e-19,  4.446738489680127e-23, -1.893863419096130e-24,
  7.145402861311535e-27, -1.258565285351080e-29,  3.674925115399678e-01, -1.442211115220067e-03,  3.534179176362660e-06, -5.032635855366018e-09, -2.571345328645152e-12,
  4.032227208877612e-14, -1.238887595682786e-16,  1.439619441097976e-19,  4.579088187834740e-22, -2.945477924748492e-24,  7.372318038636848e-27, -2.563298270312742e-30,
  4.156911133774673e-01, -1.601382406386488e-03,  3.718152137986999e-06, -4.305678877241963e-09, -7.162122163435111e-12,  5.140950765402652e-14, -1.218707822985325e-16,
  2.016345833333162e-20,  9.461566035010927e-22, -3.641245635650451e-24,  4.980792444111311e-27,  1.501897078106106e-29,  4.666568126565018e-01, -1.761277515068348e-03,
  3.842212912700443e-06, -3.267731011889521e-09, -1.229200481583941e-11,  6.035132477139001e-14, -1.020890154574535e-16, -1.548070694006343e-19,  1.421199025068914e-21,
 -3.580326761497683e-24, -6.280011593428798e-28,  3.688437262869950e-29,  5.203228410641126e-01, -1.919946688741720e-03,  3.895083410228927e-06, -1.912138416891640e-09,
 -1.770298571419735e-11,  6.557346068773189e-14, -6.149681714180599e-17, -3.666230312942715e-19,  1.756691840802615e-21, -2.391533613157409e-24, -9.135015492498901e-27,
  5.549900360614065e-29,  5.766106072093204e-01, -2.075252303054041e-03,  3.865770385217839e-06, -2.468162086801283e-10, -2.304930832973520e-11,  6.544094189192275e-14,
  7.964649376972854e-19, -5.872629378777156e-19,  1.802303254587185e-21,  1.242402391618477e-25, -1.884376412005279e-26,  5.979706511257978e-29,  6.354277263352106e-01,
 -2.224862229303435e-03,  3.743944305229744e-06,  1.702481332408147e-09, -2.789969064415868e-11,  5.843427663891709e-14,  8.249048292824588e-17, -7.747221758208661e-19,
  1.413182657145201e-21,  3.821731473622694e-24, -2.649711066164681e-26,  3.832565146625772e-29,  6.966657387000402e-01, -2.366246528371772e-03,  3.520415759279952e-06,
  3.888852535578786e-09, -3.174833354623227e-11,  4.338628249366064e-14,  1.771336615646808e-16, -8.758764214324313e-19,  4.954950274149552e-22,  8.053616044001496e-24,
 -2.767502741061414e-26, -1.487308281966676e-29,  7.601974757388661e-01, -2.496679181650704e-03,  3.187724537572293e-06,  6.241162843894781e-09, -3.403788529699899e-11,
  1.977577014918413e-14,  2.734774671113641e-16, -8.337569564076011e-19, -9.358755141135729e-22,  1.160306126880171e-23, -1.805541445692899e-26, -9.268879852524716e-29,
  8.258740321669593e-01, -2.613247129140618e-03,  2.740854443100840e-06,  8.661580198408789e-09, -3.419778447745247e-11, -1.193919020233543e-14,  3.554811574602127e-16,
 -6.001233814100527e-19, -2.699122149094461e-21,  1.280747098929313e-23,  4.388452522760871e-27, -1.688937415595742e-28,  8.935213040182454e-01, -2.712869577487118e-03,
  2.178081550410842e-06,  1.102430593265016e-08, -3.170115877316166e-11, -4.998629925842645e-14,  4.033831739421522e-16, -1.531760955191724e-19, -4.408699588939469e-21,
  9.972697715209498e-24,  3.666267488247893e-26, -1.991619831848961e-28,  9.629360589613699e-01, -2.792331370652725e-03,  1.501953155125187e-06,  1.317628800795315e-08,
 -2.614229951991313e-11, -9.100861790456388e-14,  3.962722265452903e-16,  4.817336737378746e-19, -5.491907491667230e-21,  2.116790113610477e-24,  6.866487238980287e-26,
 -1.354596329192330e-28,  1.033881518580767e+00, -2.848335165238889e-03,  7.203765688075042e-07,  1.494093401870097e-08, -1.733408469558592e-11, -1.299594684776671e-13,
  3.164684269870415e-16,  1.213577881190780e-18, -5.294997590376951e-21, -1.006952130965779e-23,  8.369837138799372e-26,  4.357998939727248e-29,  1.106082456083369e+00,
 -2.877578161550082e-03, -1.522319036542532e-07,  1.612604807068254e-08, -5.419883875476336e-12, -1.602975940395683e-13,  1.556593354532823e-16,  1.878222038366142e-18,
 -3.302980809420277e-21, -2.341022475479648e-23,  6.377254428551397e-26,  2.945970893617376e-28,  1.179219851678827e+00, -2.876860079603503e-03, -1.093830456117233e-06,
  1.653731575154922e-08,  9.013219508674731e-12, -1.746369995096154e-13, -7.797743967228786e-17,  2.254107383491289e-18,  5.431923236974681e-22, -3.222935446674283e-23,
  4.857353217985827e-28,  4.892927653986484e-28,  1.252925207519206e+00, -2.843229692862780e-03, -2.073820512071863e-06,  1.599851430729159e-08,  2.484385386862799e-11,
 -1.659850029158832e-13, -3.535313490380032e-16,  2.112773106209119e-18,  5.525090366978022e-21, -2.990123955001962e-23, -9.165440514179256e-26,  4.507943464545191e-28,
  1.326774711501932e+00, -2.774177131678164e-03, -3.052531431441029e-06,  1.437901891213586e-08,  4.038537747887244e-11, -1.296034329507396e-13, -6.151779020373494e-16,
  1.308070061853341e-18,  1.001357324115986e-20, -1.232963849825003e-23, -1.686094957924538e-25,  7.151852899576265e-29,  1.400283561765099e+00, -2.667877710014538e-03,
 -3.981443070876748e-06,  1.162783522748472e-08,  5.346333395936695e-11, -6.531077118831080e-14, -7.882111870851859e-16, -1.116558215581286e-19,  1.178269777690863e-20,
  1.754421850194342e-23, -1.700483528866534e-25, -5.276605309679426e-28,  1.472900927413332e+00, -2.523489318559304e-03, -4.804557346681224e-06,  7.811034328452461e-09,
  6.165403180572942e-11,  2.031145944478804e-14, -7.969448087138949e-16, -1.815043371660392e-18,  8.951120598959614e-21,  4.708257769633724e-23, -5.943027209924492e-26,
 -9.401360156756185e-28,  1.544006227555731e+00, -2.341498339542905e-03, -5.461385446245304e-06,  3.145973842770604e-09,  6.272122828838639e-11,  1.127825188774974e-13,
 -5.946442968255166e-16, -3.199502583029873e-18,  1.385052743784135e-21,  5.736843307811092e-23,  1.256131249763037e-25, -6.995563876963927e-28,  1.612907652059039e+00,
 -2.124097402509491e-03, -5.891984217914411e-06, -1.978610830079127e-09,  5.523839875194301e-11,  1.909552936518436e-13, -1.981283012411801e-16, -3.578745703576401e-18,
 -8.205062431634587e-21,  3.495126128166239e-23,  2.613415714453091e-25,  2.247095368570025e-28,  1.678844098134835e+00, -1.875561358998259e-03, -6.044275359127096e-06,
 -7.011449536108877e-09,  3.929109616643065e-11,  2.317466838814695e-13,  2.904383929503641e-16, -2.548213378897135e-18, -1.472318104240368e-20, -1.317834786351215e-23,
  2.152516344903739e-25,  1.112323937577438e-27,  1.740991905190627e+00, -1.602566117061038e-03, -5.883427760959252e-06, -1.129229078367306e-08,  1.702770567304997e-11,
  2.183594559149934e-13,  6.983889541101263e-16, -3.722227127061746e-19, -1.351625947298085e-20, -5.573744356206076e-23, -1.185813452027413e-26,  9.999594816819390e-28,
  1.798477850699046e+00, -1.314371460380670e-03, -5.402324845614033e-06, -1.416031552589528e-08, -7.281907813212500e-12,  1.497085020591235e-13,  8.493017537095690e-16,
  1.925237511725373e-18, -4.437954311148876e-21, -5.769141241418222e-23, -2.267837367733611e-25, -1.305841377065907e-28,  1.850399703883934e+00, -1.022770497576187e-03,
 -4.631135702289890e-06, -1.511184781143885e-08, -2.801155791375066e-11,  4.609362757837829e-14,  6.650338725301549e-16,  3.047347882021582e-18,  6.458997601787706e-21,
 -1.575674263504321e-23, -2.128159322744470e-25, -9.915604039785662e-28,  1.895855090647619e+00, -7.417059836246615e-04, -3.643029462718964e-06, -1.397591890415519e-08,
 -3.985710833629611e-11, -5.476031411173544e-14,  2.417166880206638e-16,  2.357749716450682e-18,  1.096679422849091e-20,  2.992902521162734e-23, -1.304529033576074e-27,
 -5.636493021162510e-28,  1.933978408154784e+00, -4.864807190993289e-04, -2.552636895786917e-06, -1.104780786453934e-08, -4.001367889527496e-11, -1.136562613271975e-13,
 -1.787057793801936e-16,  5.288629167617480e-19,  6.463925158293074e-21,  3.583684590804658e-23,  1.389199777798138e-25,  3.438992738474778e-28,  1.963984072329896e+00,
 -2.725552772054698e-04, -1.504624428184119e-06, -7.106826507790733e-09, -2.986894500614391e-11, -1.118705016995136e-13, -3.623205598954471e-16, -9.148194435259266e-19,
 -9.817702091525813e-22,  7.492867018398341e-24,  7.124366807845433e-26,  4.016709753093115e-28,  1.985212842940065e+00, -1.140275837982477e-04, -6.521153173483565e-07,
 -3.265803767635870e-09, -1.504130938237559e-11, -6.490136504262845e-14, -2.638703852921417e-16, -1.008341716805748e-18, -3.580307376734205e-21, -1.149289593718965e-23,
 -3.109813243178788e-26, -5.410453718825751e-29,  1.997179294472932e+00, -2.198245491904780e-05, -1.282180829332690e-07, -6.629468547999609e-10, -3.202574893650378e-12,
 -1.479144208201579e-14, -6.609797305254313e-17, -2.877178056959066e-19, -1.224839339034099e-21, -5.111338008839175e-24, -2.093414067110046e-26, -8.417514998251314e-29,
  3.797122096063736e-04, -1.665253149528278e-06,  5.476388023353189e-09, -1.600645249084416e-11,  4.384715002843199e-14, -1.152852547492376e-16,  2.945584362539686e-19,
 -7.371198433283586e-22,  1.814403797785555e-24, -4.411260414464453e-27,  1.060222651281325e-29, -2.529570662153001e-32,  3.417226831761589e-03, -1.497388460257473e-05,
  4.914949821487499e-08, -1.431703416055401e-10,  3.901377563133179e-13, -1.018059908011049e-15,  2.574579987734566e-18, -6.356576249514992e-21,  1.537998278430864e-23,
 -3.660082766478917e-26,  8.567950630244215e-29, -1.980318174066404e-31,  9.491272085118437e-03, -4.151956028495908e-05,  1.357593553645836e-07, -3.927727840823617e-10,
  1.058926960785231e-12, -2.720714742614989e-15,  6.734291458814776e-18, -1.615578282930558e-20,  3.764200603902580e-23, -8.531244493260994e-26,  1.874754860923295e-28,
 -3.994859858212294e-31,  1.859984284275160e-02, -8.115836555880873e-05,  2.638313708886508e-07, -7.554079660140986e-10,  2.003289250446868e-12, -5.022955698209271e-15,
  1.200824006328417e-17, -2.744623547622212e-20,  5.978072118810198e-23, -1.232439358603899e-25,  2.357282044296684e-28, -4.048087162975248e-31,  3.073983768397286e-02,
 -1.336725719102073e-04,  4.311491695517307e-07, -1.217081887148457e-09,  3.154497752066661e-12, -7.638072971018845e-15,  1.733527234042680e-17, -3.666063566830158e-20,
  7.076825205645121e-23, -1.189085440676510e-25,  1.476934318462763e-28, -1.687038512129638e-32,  4.590694396437175e-02, -1.987683923022466e-04,  6.347496654996647e-07,
 -1.759357304696914e-09,  4.424059748913413e-12, -1.020938968554212e-14,  2.146005924916905e-17, -3.987792053651006e-20,  5.974681409427510e-23, -4.630477553969272e-26,
 -1.260768392348635e-28,  8.125408377703155e-31,  6.409548041426230e-02, -2.760729611273593e-04,  8.709173075314995e-07, -2.359559313911002e-09,  5.706498689469647e-12,
 -1.233210758441011e-14,  2.306330675718708e-17, -3.346618206889101e-20,  1.876316804645223e-23,  1.048999842294004e-25, -5.685660880333384e-28,  1.890695348172566e-30,
  8.529819355195437e-02, -3.651305171256267e-04,  1.135178254868026e-06, -2.991052496686398e-09,  6.882937105032278e-12, -1.358039788408342e-14,  2.091560728878684e-17,
 -1.479223724348622e-20, -5.450552637120769e-23,  3.207628685462720e-25, -1.075878528877186e-27,  2.763522024513987e-30,  1.095060030824299e-01, -4.653977645712393e-04,
  1.422295521665032e-06, -3.623603735446263e-09,  7.825542795503869e-12, -1.353944357855319e-14,  1.404785273456822e-17,  1.706847494823595e-20, -1.544726882320411e-22,
  5.583220140966751e-25, -1.459262426237527e-27,  2.799212507389294e-30,  1.367076902045620e-01, -5.762383869560104e-04,  1.726266468841264e-06, -4.223848191884927e-09,
  8.402903424672675e-12, -1.184191912955598e-14,  1.928603199362315e-18,  6.070360085725408e-20, -2.662999336094046e-22,  7.469244153427837e-25, -1.476714986010923e-27,
  1.386169138735677e-30,  1.668895213382218e-01, -6.969166891935691e-04,  2.040324443611109e-06, -4.755879568117951e-09,  8.486389729456357e-12, -8.208070437819138e-15,
 -1.536426423038587e-17,  1.119141554394293e-19, -3.659962129733307e-22,  7.973827070059835e-25, -8.963231361418830e-28, -1.777944504292677e-30,  2.000347981706154e-01,
 -8.265903502361048e-04,  2.356946891430437e-06, -5.181989521460498e-09,  7.957551326791630e-12, -2.488104686032451e-15, -3.699390816324374e-17,  1.635528403636480e-19,
 -4.224215017367559e-22,  6.197868227778097e-25,  4.140885130369031e-28, -6.371206740193071e-30,  2.361233230700024e-01, -9.643022795893829e-04,  2.667872915851363e-06,
 -5.463584822230337e-09,  6.716556726157787e-12,  5.295013514247594e-15, -6.125718974606582e-17,  2.057665694943325e-19, -4.015329384861737e-22,  1.492874471336391e-25,
  2.386312486704681e-27, -1.121465194279308e-29,  2.751307667829595e-01, -1.108971590783798e-03,  2.964134065696427e-06, -5.562314217579853e-09,  4.691634117760944e-12,
  1.490506473012977e-14, -8.554414448011564e-17,  2.267554790480897e-19, -2.729716286900024e-22, -6.229667066261734e-25,  4.666557562064926e-27, -1.426143077347205e-29,
  3.170279228755818e-01, -1.259383735462261e-03,  3.236103114317721e-06, -5.441439480187546e-09,  1.849383338924311e-12,  2.585809210972977e-14, -1.063925343294188e-16,
  2.141393951946170e-19, -1.870172738985253e-23, -1.619255938419476e-24,  6.582329761480827e-27, -1.294949211372879e-29,  3.617798305576799e-01, -1.414179887488963e-03,
  3.473566790153928e-06, -5.067485968960034e-09, -1.794298534458125e-12,  3.739887292075983e-14, -1.196682186439775e-16,  1.569750782044185e-19,  3.571454765804645e-22,
 -2.653603858727811e-24,  7.203583139167100e-27, -5.008595530957089e-30,  4.093447443060051e-01, -1.571845732854768e-03,  3.665829843894582e-06, -4.412205978160541e-09,
 -6.163118094486671e-12,  4.849468538588363e-14, -1.209017525253960e-16,  4.838276990879402e-20,  8.188040774910569e-22, -3.430228558189180e-24,  5.535790844655855e-27,
  1.031354016217147e-29,  4.596729250549910e-01, -1.730699915418456e-03,  3.801859504938195e-06, -3.454881383887774e-09, -1.110980473295588e-11,  5.785419308804835e-14,
 -1.058063096763151e-16, -1.113927505491655e-19,  1.292229819669568e-21, -3.574785879380172e-24,  8.611118512213275e-28,  3.085412434169081e-29,  5.127052236539756e-01,
 -1.888882520182222e-03,  3.870481272055405e-06, -2.184978003468848e-09, -1.640707475491997e-11,  6.398062197889811e-14, -7.098868259804417e-17, -3.118522469394915e-19,
  1.664594906007953e-21, -2.709532752176554e-24, -6.801397415544615e-27,  5.049754369934432e-29,  5.683714228454204e-01, -2.044344157112481e-03,  3.860639036506325e-06,
 -6.051390261525597e-10, -2.174159657220546e-11,  6.526925289101907e-14, -1.483980042568582e-17, -5.296579985593087e-19,  1.793842389919194e-21, -5.769213807707261e-25,
 -1.621793880227135e-26,  5.930464032227359e-29,  6.265882993199190e-01, -2.194836454990775e-03,  3.761734606051836e-06,  1.265536052091391e-09, -2.671293754271840e-11,
  6.015897154363417e-14,  6.145061246361409e-17, -7.275001283836694e-19,  1.532115226519254e-21,  2.797928044722309e-24, -2.463914827721131e-26,  4.573060514215561e-29,
  6.872573626889205e-01, -2.337905105515979e-03,  3.564063510147129e-06,  3.388043683579761e-09, -3.084007193658474e-11,  4.734524783449884e-14,  1.528731605493569e-16,
 -8.555963266543610e-19,  7.653872736821101e-22,  6.938525211128702e-24, -2.795987994862510e-26,  1.549406086563604e-30,  7.502622239051935e-01, -2.470887035501984e-03,
  3.259365040064072e-06,  5.700069423625697e-09, -3.357864213325051e-11,  2.605608368704113e-14,  2.497747577925790e-16, -8.571685887527409e-19, -5.320894162213622e-22,
  1.080571650749133e-23, -2.165319905176676e-26, -7.092131948146953e-29,  8.154655424494645e-01, -2.590913854708657e-03,  2.841504023837598e-06,  8.112963040462879e-09,
 -3.435266251361413e-11, -3.618617020842504e-15,  3.375379688421028e-16, -6.790985575576959e-19, -2.236640652075105e-21,  1.283923929049416e-23, -2.674161730565449e-27,
 -1.516279868068704e-28,  8.827055005912317e-01, -2.694924453684352e-03,  2.307298618628048e-06,  1.050961385535260e-08, -3.260450114655823e-11, -4.037217068427844e-14,
  3.971750364048595e-16, -2.882443764128545e-19, -4.025406274618002e-21,  1.126305066751046e-23,  2.784536594373087e-26, -2.004925846522088e-28,  9.517917559103605e-01,
 -2.779690529247370e-03,  1.657500570305900e-06,  1.274397080566172e-08, -2.786637623757161e-11, -8.135599162541293e-14,  4.073155597638358e-16,  3.077297426100619e-19,
 -5.367790933029566e-21,  4.734388340021711e-24,  6.198700889679610e-26, -1.667593452108625e-28,  1.022500832542616e+00, -2.841859897527894e-03,  8.979192991440259e-07,
  1.464321902817182e-08, -1.985466953794014e-11, -1.219759225509404e-13,  3.480265757882712e-16,  1.038986762324361e-18, -5.596935477674125e-21, -6.700773742134412e-24,
  8.431065234787497e-26, -1.519630549089312e-29,  1.094570930905660e+00, -2.878023682926069e-03,  4.065527375249027e-08,  1.601390294940201e-08, -8.584282672702830e-12,
 -1.559433914693680e-13,  2.066467728722662e-16,  1.759559019462806e-18, -4.096864875263489e-21, -2.061733527211849e-23,  7.543095888863543e-26,  2.341009555701233e-28,
  1.167696170019513e+00, -2.884814746502890e-03, -8.946329291332272e-07,  1.665350514190521e-08,  5.506882854156622e-12, -1.757501847011295e-13, -1.479323827602755e-17,
  2.252971105528780e-18, -6.115559026410887e-22, -3.178287266067017e-23,  2.171715861223660e-26,  4.726712109252859e-28,  1.241520332710405e+00, -2.859045825935402e-03,
 -1.879564318036877e-06,  1.636901782390568e-08,  2.144419699912909e-11, -1.737409037500147e-13, -2.920651007084427e-16,  2.271685389697984e-18,  4.387628035707993e-21,
 -3.314976182004518e-23, -7.028761795308587e-26,  5.172057015053549e-28,  1.315630270519526e+00, -2.797896407543790e-03, -2.876194309453291e-06,  1.500365930910363e-08,
  3.764881805065918e-11, -1.438924384512291e-13, -5.741418201219108e-16,  1.620109463825914e-18,  9.449437049516020e-21, -1.897030751964775e-23, -1.624155627024676e-25,
  2.098581666462297e-28,  1.389549251942007e+00, -2.699156682416032e-03, -3.836823003643633e-06,  1.247177073063264e-08,  5.196791711237458e-11, -8.422221423133539e-14,
 -7.859735649934002e-16,  2.741397697616426e-19,  1.228656297832753e-20,  1.031169033300011e-23, -1.906901792028191e-25, -4.058237756981648e-28,  1.462730714567403e+00,
 -2.561534053749987e-03, -4.704896154185757e-06,  8.799692777816122e-09,  6.186505158047116e-11,  6.088444521836262e-16, -8.435048527016466e-16, -1.502028224549112e-18,
  1.059325209835860e-20,  4.386958616347347e-23, -1.013546263739380e-25, -9.586273636282976e-28,  1.534553115428870e+00, -2.385021189953487e-03, -5.417540680485974e-06,
  4.166752937850620e-09,  6.482694166587872e-11,  9.744297265469396e-14, -6.832928397772041e-16, -3.121230657949974e-18,  3.532806913621778e-21,  6.171896444505995e-23,
  9.048647521956097e-26, -8.952783698460897e-28,  1.604316861918988e+00, -2.171312936325946e-03, -5.910299562336690e-06, -1.064536550215431e-09,  5.900168909884778e-11,
  1.849693215226682e-13, -3.018054143824616e-16, -3.819142547825769e-18, -6.756830209327167e-21,  4.554032085212361e-23,  2.664887108854687e-25,  1.986372640704596e-30,
  1.671244626978081e+00, -1.924241069679644e-03, -6.124486697306224e-06, -6.345359018195055e-09,  4.398967892743324e-11,  2.378073900149221e-13,  2.124335148267972e-16,
 -3.025188265157149e-18, -1.503080521116552e-20, -3.588004979970847e-24,  2.642011278800869e-25,  1.103286817878407e-27,  1.734486654647767e+00, -1.650170599768508e-03,
 -6.017153535233732e-06, -1.098400372739458e-08,  2.156140347486608e-11,  2.349449940740345e-13,  6.816096495468861e-16, -8.368490129221803e-19, -1.552009389791679e-20,
 -5.526056561878838e-23,  3.747486360672854e-26,  1.243157423622008e-27,  1.793132848988950e+00, -1.358271500127809e-03, -5.572845250683498e-06, -1.425174718673772e-08,
 -4.079630221126349e-12,  1.707205944502159e-13,  9.008954434830169e-16,  1.748234023643268e-18, -6.679005292933426e-21, -6.682094363228864e-23, -2.281808263239267e-25,
  7.711537669763648e-29,  1.846233364565167e+00, -1.060552495191016e-03, -4.815133674426299e-06, -1.555176112983416e-08, -2.692304758700718e-11,  6.310112012910276e-14,
  7.531557531850570e-16,  3.243230062432059e-18,  5.727774048398881e-21, -2.516785528335647e-23, -2.583373484828986e-25, -1.073399292280365e-27,  1.892828900659729e+00,
 -7.715319856407551e-04, -3.814601829690061e-06, -1.462205591726324e-08, -4.088874607029292e-11, -4.812625982888782e-14,  3.128084109402742e-16,  2.725864385219566e-18,
  1.203682025309708e-20,  2.932510137950511e-23, -3.033758018215300e-26, -7.622170481915958e-28,  1.931990787859762e+00, -5.074431670085358e-04, -2.689127656517851e-06,
 -1.170643929007159e-08, -4.232836804935849e-11, -1.177428973883646e-13, -1.608000132507159e-16,  7.574524748292930e-19,  7.857699303291725e-21,  4.169364123442403e-23,
  1.538174818712654e-25,  3.297254711129240e-28,  1.962869225413626e+00, -2.849416978125864e-04, -1.592849153914031e-06, -7.603110143730219e-09, -3.219540400021127e-11,
 -1.208768547602188e-13, -3.883306569231275e-16, -9.413340811950256e-19, -6.562355278727588e-22,  1.072231228535278e-23,  9.090726105145923e-26,  4.948864453788846e-28,
  1.984746044649908e+00, -1.194054570882394e-04, -6.927929045506769e-07, -3.517202860457888e-09, -1.640502105741423e-11, -7.158639449471320e-14, -2.937718688081304e-16,
 -1.129776107219646e-18, -4.017002296558845e-21, -1.278286382644771e-23, -3.335319009226021e-26, -4.761353970679981e-29,  1.997089261519815e+00, -2.304091518881949e-05,
 -1.364909416110757e-07, -7.166436965806224e-10, -3.514943425736619e-12, -1.647907162328992e-14, -7.473165779581573e-17, -3.300259423115453e-19, -1.424857243919387e-21,
 -6.027720575766119e-24, -2.501357793001488e-26, -1.018426471066378e-28,  3.731376193356204e-04, -1.622198601408660e-06,  5.288445056918634e-09, -1.532296652814219e-11,
  4.161050046573218e-14, -1.084571075252233e-16,  2.747086309817404e-19, -6.815200862050315e-22,  1.662971285319424e-24, -4.008613179833889e-27,  9.549787570908307e-30,
 -2.259676495586414e-32,  3.358106952176586e-03, -1.458745620171873e-05,  4.746824613272897e-08, -1.370877293669136e-10,  3.703803229746968e-13, -9.583513781643061e-16,
  2.403292620278978e-18, -5.884854101942100e-21,  1.412199881750434e-23, -3.334174301875685e-26,  7.742313803161643e-29, -1.776502435443043e-31,  9.327336544179433e-03,
 -4.045205458673229e-05,  1.311459713033202e-07, -3.762566369426101e-10,  1.006092946164780e-12, -2.564386764067444e-15,  6.298341570197937e-18, -1.499896499809998e-20,
  3.470160686622000e-23, -7.815375450790855e-26,  1.707297821296634e-28, -3.623064827999849e-31,  1.827937403076883e-02, -7.908343681383253e-05,  2.549555259318870e-07,
 -7.241436096245568e-10,  1.905650966055507e-12, -4.743767740100114e-15,  1.126587301184078e-17, -2.560245545809055e-20,  5.550944185612643e-23, -1.141632942030675e-25,
  2.184938192601640e-28, -3.787327591121324e-31,  3.021195448102479e-02, -1.302809519257087e-04,  4.168420498435338e-07, -1.167809754051229e-09,  3.005814917567043e-12,
 -7.234092425090151e-15,  1.633984330324926e-17, -3.446340478645272e-20,  6.659361363589870e-23, -1.130255586160949e-25,  1.462247179931161e-28, -4.862638442904671e-32,
  4.512189435726167e-02, -1.937736561229548e-04,  6.140554390013039e-07, -1.690178242917694e-09,  4.224933036189575e-12, -9.707532773775944e-15,  2.036998689932114e-17,
 -3.799359982408467e-20,  5.799731879448152e-23, -5.067253732587965e-26, -9.325912718201955e-29,  6.823547199944326e-31,  6.300494608699167e-02, -2.692173478975193e-04,
  8.431423769996691e-07, -2.270198714875200e-09,  5.465316194996816e-12, -1.178976167538129e-14,  2.213519690523764e-17, -3.280956909314520e-20,  2.214961466913020e-23,
  8.375188082542564e-26, -4.905058294581418e-28,  1.661810418580922e-30,  8.385560963159508e-02, -3.561908099133517e-04,  1.099937511761775e-06, -2.883071236949665e-09,
  6.616314369921425e-12, -1.308358021414179e-14,  2.047868427708507e-17, -1.635972727233159e-20, -4.370409787845811e-23,  2.800822740704987e-25, -9.600331704754215e-28,
  2.505131101517550e-30,  1.076668963366339e-01, -4.541912252897542e-04,  1.379554652673718e-06, -3.500542890614360e-09,  7.558161310467426e-12, -1.319710050340600e-14,
  1.445950897309033e-17,  1.243591536807681e-20, -1.353944545355740e-22,  5.023736958957854e-25, -1.339195241010921e-27,  2.656273765816173e-30,  1.344300391107845e-01,
 -5.626287323093373e-04,  1.676379163285212e-06, -4.091293368364238e-09,  8.166660709961149e-12, -1.177617474232060e-14,  3.512963436520306e-18,  5.260095371416305e-20,
 -2.404587077569565e-22,  6.891277365378010e-25, -1.411946268824259e-27,  1.547376467800094e-30,  1.641341415678652e-01, -6.808200801671826e-04,  1.984063102837110e-06,
 -4.621429616767519e-09,  8.318787990494784e-12, -8.540506792253635e-15, -1.239036890882050e-17,  1.006545080561745e-19, -3.379528831209855e-22,  7.601566243893814e-25,
 -9.604558518662712e-28, -1.156399872967016e-30,  1.967657571390582e-01, -8.079813502354426e-04,  2.295525147877682e-06, -5.055113507230809e-09,  7.899273826600939e-12,
 -3.322511486061904e-15, -3.260029946491455e-17,  1.503950180616169e-19, -3.998755448096457e-22,  6.310764595644535e-25,  1.583775605598231e-28, -5.274830925980322e-30,
  2.323083872749790e-01, -9.432197138915404e-04,  2.602957928678529e-06, -5.355350658979471e-09,  6.808214469031584e-12,  3.892532185671711e-15, -5.567467874232991e-17,
  1.930209862186555e-19, -3.945557169688912e-22,  2.352705272769962e-25,  1.922568309613078e-27, -9.879328808228924e-30,  2.707418856595522e-01, -1.085524211274577e-03,
  2.897846173820090e-06, -5.484972670202519e-09,  4.969713914479379e-12,  1.292718857373865e-14, -7.932040402612283e-17,  2.176963744191271e-19, -2.921870108741460e-22,
 -4.485541720305667e-25,  4.061610148062061e-27, -1.322668370492485e-29,  3.120417527950211e-01, -1.233755558197444e-03,  3.171000003860529e-06, -5.407848751173769e-09,
  2.341496069490086e-12,  2.337650242336558e-14, -1.004134172269300e-16,  2.126579471952789e-19, -7.239332057048427e-23, -1.367391463207552e-24,  6.010602433230738e-27,
 -1.299057687563222e-29,  3.561783023321016e-01, -1.386635024703476e-03,  3.412608887781412e-06, -5.090365456674958e-09, -1.074679122072874e-12,  3.458078444504295e-14,
 -1.151268827754941e-16,  1.669304019720351e-19,  2.667437348698914e-22, -2.370461430824458e-24,  6.939811333436011e-27, -6.894388659880511e-30,  4.031156770536928e-01,
 -1.542732483668544e-03,  3.612323210006543e-06, -4.503213861469904e-09, -5.222116252008377e-12,  4.561214817688731e-14, -1.191984656786542e-16,  7.265223732636795e-20,
  6.993995744140012e-22, -3.200965162485929e-24,  5.897716445326642e-27,  6.240519836037997e-30,  4.528106884230506e-01, -1.700453808515211e-03,  3.759372121220272e-06,
 -3.623520538060497e-09, -9.978343378615172e-12,  5.528196778451620e-14, -1.083656722008100e-16, -7.209127193068578e-20,  1.164469197563529e-21, -3.514887380137737e-24,
  2.092524852350194e-27,  2.518651002483231e-29,  5.052114490423968e-01, -1.858027915039453e-03,  3.842728376337851e-06, -2.437349730986406e-09, -1.514517616107386e-11,
  6.217803851551619e-14, -7.898982061851038e-17, -2.601941544095219e-19,  1.562676051533192e-21, -2.938708162074754e-24, -4.696373817489611e-27,  4.514609609299411e-29,
  5.602557622328267e-01, -2.013493906148973e-03,  3.851333176447997e-06, -9.425857678776923e-10, -2.044094090483376e-11,  6.474159558629058e-14, -2.887056849155940e-17,
 -4.727074732091617e-19,  1.762021119516383e-21, -1.173913943620181e-24, -1.364542359833837e-26,  5.742363653428363e-29,  6.178692272977976e-01, -2.164689006402601e-03,
  3.774396542480114e-06,  8.478277934515319e-10, -2.549663093247964e-11,  6.139497269733145e-14,  4.178080604188510e-17, -6.770470105156078e-19,  1.615600787064839e-21,
  1.854265862253051e-24, -2.250685822435711e-26,  5.082838130459942e-29,  6.779630130282135e-01, -2.309238286617865e-03,  3.601791258914366e-06,  2.902369026245391e-09,
 -2.985840265894039e-11,  5.072971405642156e-14,  1.292953713508613e-16, -8.273227986759080e-19,  9.950990970945913e-22,  5.825808499489882e-24, -2.757351515526390e-26,
  1.561312532624717e-29,  7.404312459697366e-01, -2.444547603559097e-03,  3.324560553196525e-06,  5.167297638850611e-09, -3.299952701662650e-11,  3.176109851362432e-14,
  2.255929164902969e-16, -8.681442481454518e-19, -1.593689058078723e-22,  9.883431065746508e-24, -2.430823088743766e-26, -4.994552027638754e-29,  8.051479544850906e-01,
 -2.567801746889563e-03,  2.935560744191922e-06,  7.563175005967675e-09, -3.434560592675331e-11,  4.246455452870277e-15,  3.175904590645409e-16, -7.433090138653766e-19,
 -1.777909850104395e-21,  1.260452128340615e-23, -8.917355313488910e-27, -1.318205254925303e-28,  8.719635056882318e-01, -2.675970529710085e-03,  2.430258976699305e-06,
  9.981997204852502e-09, -3.331734990008122e-11, -3.095099387676608e-14,  3.873632004136233e-16, -4.103720935476790e-19, -3.602004858797656e-21,  1.220150230106976e-23,
  1.911469802326445e-26, -1.953609809726031e-28,  9.407004714849141e-01, -2.765826513937784e-03,  1.807701080570248e-06,  1.228562554925254e-08, -2.939514198853030e-11,
 -7.149625669983234e-14,  4.135561711179353e-16,  1.391511734471048e-19, -5.154559105155390e-21,  7.059716840091739e-24,  5.411116261741171e-26, -1.898586345171481e-28,
  1.011148864681077e+00, -2.833979251498807e-03,  1.071652871305647e-06,  1.430649151902475e-08, -2.220841064558605e-11, -1.132946233733734e-13,  3.745791414705317e-16,
  8.566737638053871e-19, -5.777770672713655e-21, -3.358106908256703e-24,  8.242668844711087e-26, -6.953674622695242e-29,  1.083060700108391e+00, -2.876932343520557e-03,
  2.318960133556329e-07,  1.585188942729694e-08, -1.164964399184693e-11, -1.504081358709567e-13,  2.539717117374599e-16,  1.617185089463838e-18, -4.782470622353601e-21,
 -1.741330678116523e-23,  8.428663550086142e-26,  1.677224047284926e-28,  1.156143864335438e+00, -2.891171210976342e-03, -6.943782058058119e-07,  1.671349734266363e-08,
  1.993422631363719e-12, -1.753514857477740e-13,  4.784539517437041e-17,  2.215302207036782e-18, -1.735170018714163e-21, -3.050718747595106e-23,  4.181443534905807e-26,
  4.380140636289100e-28,  1.230055328306340e+00, -2.873291061254636e-03, -1.681193304170522e-06,  1.668396747598344e-08,  1.790451273207613e-11, -1.799724351871780e-13,
 -2.266752651664218e-16,  2.392498043665441e-18,  3.149253211520822e-21, -3.549114422477831e-23, -4.645050541439410e-26,  5.626163042371117e-28,  1.304393820221262e+00,
 -2.820175769395666e-03, -2.692633461791983e-06,  1.558228495649559e-08,  3.463702340468618e-11, -1.570939915546366e-13, -5.246568975739688e-16,  1.910331166006181e-18,
  8.652156753507578e-21, -2.524230609422416e-23, -1.502091622311536e-25,  3.436410856962078e-28,  1.378692203677391e+00, -2.729238620836973e-03, -3.682231732383355e-06,
  1.328876035361961e-08,  5.009569179365719e-11, -1.029487510601845e-13, -7.727481501242954e-16,  6.717447380335165e-19,  1.251656203287965e-20,  2.368874369403224e-24,
 -2.053698301693228e-25, -2.575324388857797e-28,  1.452409992538902e+00, -2.598734016724967e-03, -4.593363994398967e-06,  9.788517496131620e-09,  6.167158475554869e-11,
 -2.010021903319542e-14, -8.805844994191118e-16, -1.138640048666092e-18,  1.208944899639849e-20,  3.897601424002279e-23, -1.431374972927730e-25, -9.329734032320921e-28,
  1.524926691772742e+00, -2.428143736150259e-03, -5.361254913277186e-06,  5.218654408502741e-09,  6.660480670402522e-11,  8.001006165489853e-14, -7.687660596843307e-16,
 -2.972012480562974e-18,  5.809850438090678e-21,  6.449642450998468e-23,  4.708759412353019e-26, -1.073407703955728e-27,  1.595536987499793e+00, -2.218630103705365e-03,
 -5.917289134217565e-06, -9.134476513819251e-11,  6.261986083884917e-11,  1.764199153125746e-13, -4.115073546012289e-16, -4.007076854237029e-18, -4.926162651747326e-21,
  5.612672417740319e-23,  2.609094307268853e-25, -2.617696267698032e-28,  1.663449206035611e+00, -1.973529212178287e-03, -6.196250227197952e-06, -5.603227738080775e-09,
  4.878966851525387e-11,  2.418349356279726e-13,  1.209901117929008e-16, -3.506107012860669e-18, -1.495818812120226e-20,  7.934745014008386e-24,  3.114145866566279e-25,
  1.031472142522227e-27,  1.727788871765475e+00, -1.698828832680295e-03, -6.146733766663449e-06, -1.060055025365763e-08,  2.642169390523693e-11,  2.509644986195853e-13,
  6.509285083172383e-16, -1.364921520070859e-18, -1.746865848563773e-20, -5.259616607283064e-23,  9.749566764952611e-26,  1.483229658439359e-27,  1.787609513116900e+00,
 -1.403539188449208e-03, -5.744141336085178e-06, -1.428851502790908e-08, -4.451729089525931e-13,  1.929030549758562e-13,  9.464796677113534e-16,  1.494266474132380e-18,
 -9.247356556244191e-21, -7.580523951981782e-23, -2.190583098230470e-25,  3.484310087406331e-28,  1.841912920307997e+00, -1.099827269740402e-03, -5.004294507248404e-06,
 -1.597142036016701e-08, -2.547280893694178e-11,  8.228638434279538e-14,  8.463812698997366e-16,  3.409934312395382e-18,  4.624183404282989e-21, -3.646326339258404e-23,
 -3.067912968530474e-25, -1.122312432900294e-27,  1.889680612017417e+00, -8.027618510709786e-04, -3.994022189531408e-06, -1.528354140809943e-08, -4.176978594024751e-11,
 -3.965847699088289e-14,  3.946817475713464e-16,  3.127630134336153e-18,  1.306199386096933e-20,  2.737391056551592e-23, -6.894883131173204e-26, -9.993292937350072e-28,
  1.929917082968118e+00, -5.295297909562738e-04, -2.833746819889934e-06, -1.240273398533888e-08, -4.471994721124724e-11, -1.213177501888929e-13, -1.358368207772952e-16,
  1.034129704763270e-18,  9.472831841153549e-21,  4.812691522525110e-23,  1.675559935658660e-25,  2.897138356483487e-28,  1.961703382590071e+00, -2.980583845480903e-04,
 -1.687258678033923e-06, -8.138092287041745e-09, -3.470828605410800e-11, -1.305150688786820e-13, -4.149187162841079e-16, -9.554113218959338e-19, -1.992485637240168e-22,
  1.482541439899535e-23,  1.150561616589921e-25,  6.059007508518698e-28,  1.984257064381476e+00, -1.251211995823076e-04, -7.366227388393226e-07, -3.791531121347902e-09,
 -1.790989343599472e-11, -7.903148411163156e-14, -3.272762563316612e-16, -1.265944517315598e-18, -4.501677070006715e-21, -1.415577837916620e-23, -3.520366279782896e-26,
 -3.537274963864166e-29,  1.996994858155493e+00, -2.416822338105520e-05, -1.454393012062307e-07, -7.756201301137378e-10, -3.863236459353501e-12, -1.838888004440341e-14,
 -8.464477150698353e-17, -3.792955673992997e-19, -1.660999473782233e-21, -7.123939167339641e-24, -2.995493293501257e-26, -1.234936230665534e-28,  3.667322912694174e-04,
 -1.580615387849785e-06,  5.108493627832987e-09, -1.467419981940684e-11,  3.950577322032208e-14, -1.020872085804919e-16,  2.563498996613518e-19, -6.305421428983022e-22,
  1.525304076492789e-24, -3.645782347538492e-27,  8.609154904244182e-30, -2.020704136620053e-32,  3.300506340971224e-03, -1.421419113682652e-05,  4.585812738003423e-08,
 -1.313119016453350e-10,  3.517769980733253e-13, -9.025996891908969e-16,  2.244667089831253e-18, -5.451572234665024e-21,  1.297560721443104e-23, -3.039565699812131e-26,
  7.001325272435743e-29, -1.595102940275420e-31,  9.167598447135973e-03, -3.942067732280580e-05,  1.267258103069809e-07, -3.605613792142528e-10,  9.562834328485835e-13,
 -2.418143290956082e-15,  5.893503121384785e-18, -1.393224267729484e-20,  3.200724795389014e-23, -7.163326072854424e-26,  1.555394201741879e-28, -3.287294394466067e-31,
  1.796706525939631e-02, -7.707804027885471e-05,  2.464456611520900e-07, -6.943977464798788e-10,  1.813422375870037e-12, -4.481792228728691e-15,  1.057326647652828e-17,
 -2.389025675187843e-20,  5.155293067900775e-23, -1.057493795860059e-25,  2.023841827852638e-28, -3.537089883813198e-31,  2.969741253248636e-02, -1.270014636724981e-04,
  4.031121846593658e-07, -1.120853186809556e-09,  2.864977697149806e-12, -6.853278806748939e-15,  1.540409823544543e-17, -3.239638767530041e-20,  6.262938823939478e-23,
 -1.072271158479344e-25,  1.435171047841570e-28, -7.340313814536363e-32,  4.435649776938302e-02, -1.889412065694744e-04,  5.941725717497055e-07, -1.624106315067373e-09,
  4.035586084697481e-12, -9.231210929324295e-15,  1.933186986022787e-17, -3.616753631182292e-20,  5.611288259149499e-23, -5.383667083372850e-26, -6.576433341845581e-29,
  5.701724780517257e-31,  6.194139651362034e-02, -2.625797095882840e-04,  8.164169741823540e-07, -2.184611464198304e-09,  5.234759421915974e-12, -1.126945821785304e-14,
  2.122687907573365e-17, -3.205618775374992e-20,  2.482857453751651e-23,  6.553227594468541e-26, -4.219599204358237e-28,  1.457812120831079e-30,  8.244822879337867e-02,
 -3.475279173154533e-04,  1.065967274004774e-06, -2.779277034131950e-09,  6.359519767848688e-12, -1.259773763693511e-14,  2.000249667004305e-17, -1.760413120775230e-20,
 -3.428645401541364e-23,  2.438133928085391e-25, -8.551620286744584e-28,  2.264697608355776e-30,  1.058719411446999e-01, -4.433207782437766e-04,  1.338265072765523e-06,
 -3.381704880735605e-09,  7.297715326542332e-12, -1.284636705989404e-14,  1.474970433597725e-17,  8.382547443214688e-21, -1.182454588989462e-22,  4.510989239399693e-25,
 -1.225658420033239e-27,  2.503250379355970e-30,  1.322060384223024e-01, -5.494118776206243e-04,  1.628059886187656e-06, -3.962505918651743e-09,  7.932095227476161e-12,
 -1.167503666130947e-14,  4.881717267109486e-18,  4.529244771659674e-20, -2.166499832448208e-22,  6.340458440663539e-25, -1.341395718491783e-27,  1.650882903882531e-30,
  1.614422582053638e-01, -6.651671543376295e-04,  1.929398864577587e-06, -4.489710710481160e-09,  8.145226241200187e-12, -8.805252750512862e-15, -9.719384999703068e-18,
  9.027036138554824e-20, -3.112895810268783e-22,  7.208790061628488e-25, -9.996945171147963e-28, -6.439736184368688e-31,  1.935701789781794e-01, -7.898576512176910e-04,
  2.235619789367059e-06, -4.929297832618017e-09,  7.825333237239078e-12, -4.055810872192672e-15, -2.856496164249281e-17,  1.379632870733967e-19, -3.770960125107779e-22,
  6.330624441399402e-25, -5.206770644718634e-29, -4.312116611858030e-30,  2.285767513611935e-01, -9.226512500054155e-04,  2.539349648220502e-06, -5.245867210109495e-09,
  6.873133623062161e-12,  2.619776569798130e-15, -5.044547780133396e-17,  1.805447335058174e-19, -3.848030844521115e-22,  3.038520223732668e-25,  1.515552572107753e-27,
 -8.637388517031708e-30,  2.664457394287543e-01, -1.062603349822466e-03,  2.832511796825085e-06, -5.403490277925233e-09,  5.209709004651026e-12,  1.109557448317637e-14,
 -7.335801584834325e-17,  2.081182589398301e-19, -3.055479977917103e-22, -2.974147918119310e-25,  3.503185302006335e-27, -1.215261841530353e-29,  3.071570565107096e-01,
 -1.208646463328074e-03,  3.106345612333523e-06, -5.366773493542656e-09,  2.785407666098082e-12,  2.103772785235429e-14, -9.449850287587524e-17,  2.095990297615303e-19,
 -1.174291348486764e-22, -1.138352177234717e-24,  5.442938170339408e-27, -1.277507902568161e-29,  3.506859767631216e-01, -1.359578731860472e-03,  3.351443674509176e-06,
 -5.102175917032480e-09, -4.103106296573167e-13,  3.187471546805332e-14, -1.103457808684257e-16,  1.741537704715120e-19,  1.863265782560366e-22, -2.099379838760132e-24,
  6.604119144569729e-27, -8.288932199513459e-30,  3.970022001309716e-01, -1.514051404345233e-03,  3.557812923028607e-06, -4.579624476791074e-09, -4.338303520447707e-12,
  4.277822034421602e-14, -1.168678682443501e-16,  9.323527079673445e-20,  5.884676071555817e-22, -2.960627361963225e-24,  6.093954449222863e-27,  2.777367113043172e-30,
  4.460687440333093e-01, -1.670555391533262e-03,  3.714967980465208e-06, -3.774470838153826e-09, -8.898854019533653e-12,  5.266106341520421e-14, -1.098814409239254e-16,
 -3.683460554354865e-20,  1.039692572423831e-21, -3.410594460047430e-24,  3.084055416677100e-27,  1.996087555340162e-29,  4.978406301056805e-01, -1.827407106474226e-03,
  3.812066939980770e-06, -2.669829442777954e-09, -1.392113428399644e-11,  6.020040926639555e-14, -8.559131881726913e-17, -2.119136836186291e-19,  1.453965225297507e-21,
 -3.088447014322758e-24, -2.830582710824759e-27,  3.965494890215480e-29,  5.522633285826217e-01, -1.982733946649418e-03,  3.838102412389122e-06, -1.259324200363738e-09,
 -1.915407728047409e-11,  6.389620100606107e-14, -4.132406815027104e-17, -4.170994192176766e-19,  1.710537223346474e-21, -1.670003946432103e-24, -1.118077419752944e-26,
  5.444895160163895e-29,  6.092709163845158e-01, -2.134459979769532e-03,  3.782163479239391e-06,  4.497530366812887e-10, -2.426020919588592e-11,  6.217612183700558e-14,
  2.355610106661069e-17, -6.244490421974783e-19,  1.666698040790108e-21,  9.997505682747429e-25, -2.019698028602836e-26,  5.384295304518575e-29,  6.687838977592989e-01,
 -2.280292686153089e-03,  3.633787286969765e-06,  2.432912130147103e-09, -2.881463446563323e-11,  5.355860700334510e-14,  1.066061578752533e-16, -7.923352669094252e-19,
  1.185173910085789e-21,  4.740205375678197e-24, -2.662201763111712e-26,  2.723221597155300e-29,  7.307066286331603e-01, -2.417712014571175e-03,  3.383422062900562e-06,
  4.644672884552396e-09, -3.231213330549006e-11,  3.688337771736208e-14,  2.012656083241136e-16, -8.677428005192445e-19,  1.784568449186579e-22,  8.873034269902947e-24,
 -2.606884790090790e-26, -3.035156089624602e-29,  7.949242780938830e-01, -2.543963561430897e-03,  3.023025790655540e-06,  7.014731695348368e-09, -3.418617238858825e-11,
  1.161286226117221e-14,  2.960489640254037e-16, -7.930217423561590e-19, -1.331909101521745e-21,  1.213802524670728e-23, -1.425200672865133e-26, -1.104937139082708e-28,
  8.612992534930272e-01, -2.656058428133930e-03,  2.546825674906068e-06,  9.444468433216257e-09, -3.384439890749583e-11, -2.180477620670551e-14,  3.743260736087915e-16,
 -5.184772730101769e-19, -3.151035210097358e-21,  1.279694690864557e-23,  1.073541732960380e-26, -1.846840807965271e-28,  9.296670109274007e-01, -2.750783295910915e-03,
  1.952261215681432e-06,  1.180440414614622e-08, -3.072559332540428e-11, -6.154254332528398e-14,  4.151842507933277e-16, -2.132723061764807e-20, -4.863508652100889e-21,
  9.052138825700883e-24,  4.540234644499667e-26, -2.046351005508752e-28,  9.998311726633506e-01, -2.824725526618578e-03,  1.241125591259114e-06,  1.393352603860322e-08,
 -2.438256954966960e-11, -1.040378631304600e-13,  3.959638892562720e-16,  6.704802960347578e-19, -5.840186899760593e-21, -1.368755108101539e-25,  7.828510326896219e-26,
 -1.175382596269007e-28,  1.071557881042039e+00, -2.874319679817940e-03,  4.209021653683368e-07,  1.564177607808681e-08, -1.459327746965842e-11, -1.437872896503044e-13,
  2.970208233898091e-16,  1.454779883313866e-18, -5.347068857785862e-21, -1.391448678929318e-23,  9.015099631671153e-26,  9.866034664038320e-29,  1.144569340080745e+00,
 -2.895923712564096e-03, -4.937403416783022e-07,  1.671741922135945e-08, -1.497136571477858e-12, -1.734661314280710e-13,  1.089339117760574e-16,  2.142564324869590e-18,
 -2.798801593675944e-21, -2.846298044702851e-23,  6.002712095818705e-26,  3.874247727151590e-28,  1.218536539462371e+00, -2.885935182586326e-03, -1.479386537826359e-06,
  1.694137147174460e-08,  1.425614195091174e-11, -1.845985666980533e-13, -1.584688061241373e-16,  2.472521598463527e-18,  1.844171986562026e-21, -3.684579296185300e-23,
 -2.112004611655174e-26,  5.848291779789444e-28,  1.293071232242262e+00, -2.840959709276946e-03, -2.502426735230094e-06,  1.611067687780062e-08,  3.137371652915251e-11,
 -1.690134799710659e-13, -4.674361552605547e-16,  2.171532810564261e-18,  7.639266181779336e-21, -3.091122578468172e-23, -1.323459184150966e-25,  4.658575665873891e-28,
  1.367717362454344e+00, -2.758045151164664e-03, -3.518028612556925e-06,  1.407281916829673e-08,  4.785301476932932e-11, -1.212237189243874e-13, -7.483304751774531e-16,
  1.072034445540044e-18,  1.245168249139103e-20, -6.024178715663920e-24, -2.130550339631533e-25, -8.908513777989408e-29,  1.441942330207570e+00, -2.634994343232501e-03,
 -4.469998325731920e-06,  1.077088849782605e-08,  6.105588893848002e-11, -4.157185960708304e-14, -9.068477479191754e-16, -7.305118034213143e-19,  1.337979091088386e-20,
  3.244748967746793e-23, -1.827573205468095e-25, -8.600050754750513e-28,  1.515128759095476e+00, -2.470765048573976e-03, -5.292187515896645e-06,  6.296102566681515e-09,
  6.801388127684603e-11,  6.058424451419331e-14, -8.490284987053867e-16, -2.748678995524171e-18,  8.153818728939481e-21,  6.538930461844489e-23, -3.517143568716331e-27,
 -1.220594295218900e-27,  1.586567807911570e+00, -2.265955504244310e-03, -5.912259170771615e-06,  9.382251459068759e-10,  6.604032545238548e-11,  1.651814863365399e-13,
 -5.255944643945933e-16, -4.130398432795283e-18, -2.721293594215776e-21,  6.624755261400463e-23,  2.429737469597860e-25, -5.578906871747964e-28,  1.655455542558909e+00,
 -2.023354529692982e-03, -6.258645123292026e-06, -4.783776028047868e-09,  5.364717490536079e-11,  2.435069096006246e-13,  1.617843416013588e-17, -3.977707842034890e-18,
 -1.443770928353542e-20,  2.126189148293050e-23,  3.538849726957409e-25,  8.861143033265880e-28,  1.720894413708394e+00, -1.748503955613536e-03, -6.271235539289718e-06,
 -1.013681417323001e-08,  3.159377730746679e-11,  2.660632831056349e-13,  6.046062216910149e-16, -1.953329630218430e-18, -1.927558395890100e-20, -4.732432817954391e-23,
  1.676971188409103e-25,  1.702689042937106e-27,  1.781902364400399e+00, -1.450177987646973e-03, -5.915514901723958e-06, -1.426352550522876e-08,  3.643248574706329e-12,
  2.160846208922115e-13,  9.837541992775461e-16,  1.153031677417434e-18, -1.212951883373103e-20, -8.416625201859784e-23, -1.965273752314017e-25,  6.868559647799024e-28,
  1.837432319081546e+00, -1.140635050171529e-03, -5.198338967712423e-06, -1.636468305346545e-08, -2.361613506066949e-11,  1.037606938075942e-13,  9.437162787462903e-16,
  3.534440007931360e-18,  3.078672024590132e-21, -4.972649230576936e-23, -3.563639349612390e-25, -1.121131609550536e-27,  1.886404482594277e+00, -8.354590567424202e-04,
 -4.181459009911410e-06, -1.595765803820614e-08, -4.246089050538667e-11, -2.908710983378411e-14,  4.882509963416571e-16,  3.560758373501341e-18,  1.398650461283922e-20,
  2.365802060354036e-23, -1.188588081373720e-25, -1.275697874535640e-27,  1.927752663830424e+00, -5.528074460746681e-04, -2.986953357707164e-06, -1.313783062982315e-08,
 -4.717637365379837e-11, -1.241944648088719e-13, -1.023675361771226e-16,  1.366298787658054e-18,  1.132894177634046e-20,  5.506470626876837e-23,  1.787800953115373e-25,
  2.135166499896690e-28,  1.960483520823999e+00, -3.119567249992287e-04, -1.788335698370666e-06, -8.714857430774293e-09, -3.742033630739792e-11, -1.407943305161492e-13,
 -4.416726160838633e-16, -9.523052708231269e-19,  4.240660999504061e-22,  1.999786147861089e-23,  1.445188781391056e-25,  7.367299701060768e-28,  1.983744498423615e+00,
 -1.312011694394461e-04, -7.838940389078750e-07, -4.091173572799161e-09, -1.957202674303988e-11, -8.732823034983994e-14, -3.648180189725937e-16, -1.418426422822079e-18,
 -5.036959571119413e-21, -1.558973457585374e-23, -3.634578403034775e-26, -1.495051445982202e-29,  1.996895797764760e+00, -2.537004704385233e-05, -1.551301178011908e-07,
 -8.404882331224353e-10, -4.252221125076859e-12, -2.055404955500792e-14, -9.604944233540784e-17, -4.367932573616939e-19, -1.940405339324424e-21, -8.438241587801731e-24,
 -3.595370811728400e-26, -1.500827774911673e-28,  3.604904653452114e-04, -1.540441207878301e-06,  4.936129473327439e-09, -1.405811302604654e-11,  3.752415095382668e-14,
 -9.614127658854334e-17,  2.393587888786520e-19, -5.837676207231612e-22,  1.400046106058533e-24, -3.318556468344116e-27,  7.767558823629523e-30, -1.808939836119544e-32,
  3.244373460054676e-03, -1.385353475891073e-05,  4.431556877798207e-08, -1.258250096481352e-10,  3.342515984921551e-13, -8.505134796014648e-16,  2.097675413469699e-18,
 -5.053333632625210e-21,  1.193012643452869e-23, -2.773060516254222e-26,  6.335696877828046e-29, -1.433562047218804e-31,  9.011916310573822e-03, -3.842392130375669e-05,
  1.224893055280898e-07, -3.456401926699447e-10,  9.093039976463085e-13, -2.281267051942774e-15,  5.517360294041434e-18, -1.294809847641355e-20,  2.953703681039655e-23,
 -6.569181714951515e-26,  1.417535211972518e-28, -2.984139376301421e-31,  1.766264414211475e-02, -7.513931955444595e-05,  2.382840628075647e-07, -6.660865118089930e-10,
  1.726270880842557e-12, -4.235878006696875e-15,  9.926873649788690e-18, -2.229994222143977e-20,  4.788798376289800e-23, -9.795816925304105e-26,  1.873500009646334e-28,
 -3.298659069137632e-31,  2.919577237448873e-02, -1.238295981622515e-04,  3.899325253464905e-07, -1.076090285704624e-09,  2.731536785010083e-12, -6.494242694843421e-15,
  1.452448489410324e-17, -3.045290880107369e-20,  5.887171088371899e-23, -1.015570056813948e-25,  1.398499620150083e-28, -9.242768588473891e-32,  4.361011780354312e-02,
 -1.842646992885406e-04,  5.750647003595803e-07, -1.560989063390177e-09,  3.855520527880988e-12, -8.779197248488744e-15,  1.834402270658215e-17, -3.440339440584807e-20,
  5.413318789779793e-23, -5.599497189738231e-26, -4.285375519722695e-29,  4.736124666120625e-31,  6.090397630417117e-02, -2.561518282417948e-04,  7.906968245064931e-07,
 -2.102631050445052e-09,  5.014392477935613e-12, -1.077069215254881e-14,  2.034076116634615e-17, -3.122706216428560e-20,  2.689888053517262e-23,  4.988176978585168e-26,
 -3.618873594026905e-28,  1.276269367443268e-30,  8.107496379246851e-02, -3.391318736116174e-04,  1.033218233013544e-06, -2.679514442332906e-09,  6.112325080967409e-12,
 -1.212370880582887e-14,  1.949549422388153e-17, -1.856727218739635e-20, -2.610148428319542e-23,  2.115330353796392e-25, -7.604774044981954e-28,  2.042049485869668e-30,
  1.041198160400546e-01, -4.327750139185117e-04,  1.298376778768477e-06, -3.266977548327893e-09,  7.044344778691876e-12, -1.248997052312260e-14,  1.493381682014290e-17,
  4.849276325590746e-21, -1.028622489318587e-22,  4.042290780285391e-25, -1.118987980788871e-27,  2.344849899642851e-30,  1.300341417421315e-01, -5.365754589879298e-04,
  1.581263612546650e-06, -3.837453617762400e-09,  7.699864869073020e-12, -1.154341986659899e-14,  6.056205065473516e-18,  3.871464640635758e-20, -1.947724467307228e-22,
  5.818625022308548e-25, -1.267360983324868e-27,  1.707373585691074e-30,  1.588121218618551e-01, -6.499452674957158e-04,  1.876298427549497e-06, -4.360807765713119e-09,
  7.966987550337443e-12, -9.009289070035634e-15, -7.327426521395419e-18,  8.071655590062669e-20, -2.860633566700964e-22,  6.804538199841465e-25, -1.018526477828085e-27,
 -2.266109497355596e-31,  1.904461466598064e-01, -7.722071771084925e-04,  2.177216653403077e-06, -4.804777390124117e-09,  7.737667371845282e-12, -4.696356831421268e-15,
 -2.486750742316572e-17,  1.262601010238369e-19, -3.543866366025608e-22,  6.274406226165038e-25, -2.229147715644440e-28, -3.473243690427659e-30,  2.249263799136406e-01,
 -9.025863813902729e-04,  2.477060583134197e-06, -5.135541994906868e-09,  6.913824568397141e-12,  1.468367192686184e-15, -4.556089338541164e-17,  1.684170309755142e-19,
 -3.728616625612905e-22,  3.572168865511890e-25,  1.161013848494781e-27, -7.494647795731498e-30,  2.622402375749453e-01, -1.040201189686817e-03,  2.768177064134792e-06,
 -5.318453339495489e-09,  5.414480834098356e-12,  9.403796024416371e-15, -6.766901285858739e-17,  1.981954298583664e-19, -3.138586007033183e-22, -1.676629384211323e-25,
  2.992288259042627e-27, -1.107096804582238e-29,  3.023717654231688e-01, -1.184052514739582e-03,  3.042225220718333e-06, -5.318962173203570e-09,  3.183955603237410e-12,
  1.883972804261926e-14, -8.868820581515149e-17,  2.052265328853793e-19, -1.546253934484678e-22, -9.317675149635151e-25,  4.889313881813220e-27, -1.236138560376768e-29,
  3.453008970742523e-01, -1.333012150989912e-03,  3.290198749453322e-06, -5.103783154341386e-09,  2.010988653582845e-13,  2.928553812198913e-14, -1.053970035688950e-16,
  1.789572292437377e-19,  1.154130616442981e-22, -1.842823509962836e-24,  6.216636755593929e-27, -9.259366289979845e-30,  3.910025698874763e-01, -1.485809838917100e-03,
  3.502468694659378e-06, -4.642344288924901e-09, -3.510565358833760e-12,  4.000674966079182e-14, -1.140093335604606e-16,  1.104081431407906e-19,  4.862939398081766e-22,
 -2.715315633501764e-24,  6.150597094296077e-27, -1.114299209697078e-31,  4.394456717822784e-01, -1.641019163665636e-03,  3.668854331785664e-06, -3.908570302190330e-09,
 -7.872068886355292e-12,  5.001517937605660e-14, -1.104653064725717e-16, -5.503505118402895e-21,  9.193302697251965e-22, -3.271096856169717e-24,  3.856342936613738e-27,
  1.522691212756208e-29,  4.905917866177865e-01, -1.797042418546302e-03,  3.778731923221074e-06, -2.883049061070809e-09, -1.273812190224808e-11,  5.808016872269348e-14,
 -9.089037671660049e-17, -1.671842778405495e-19,  1.341148907983410e-21, -3.168387877687345e-24, -1.206225326943711e-27,  3.419742885383493e-29,  5.443936994984009e-01,
 -1.952094688068079e-03,  3.821193716922313e-06, -1.555623791521790e-09, -1.788698529827161e-11,  6.277040474608374e-14, -5.224615782910719e-17, -3.634058425976571e-19,
  1.642934689766521e-21, -2.070385634698960e-24, -8.865961726840100e-27,  5.065638958263968e-29,  6.007936160712328e-01, -2.104187587888558e-03,  3.785272655356815e-06,
  7.156275024272895e-11, -2.301241827687437e-11,  6.253770796104423e-14,  6.822534609372129e-18, -5.706901045722765e-19,  1.688722716935527e-21,  2.397262292538928e-25,
 -1.779561546425925e-26,  5.503100630380500e-29,  6.597210415562041e-01, -2.251113363380538e-03,  3.660251806187507e-06,  1.980578906265978e-09, -2.771965107298709e-11,
  5.585536612313441e-14,  8.497593147165124e-17, -7.518823460656432e-19,  1.336968747118935e-21,  3.702168238585479e-24, -2.521290097804852e-26,  3.642447948829657e-29,
  7.210902559911743e-01, -2.390430424942868e-03,  3.436081343357415e-06,  4.133834296859614e-09, -3.152812548472832e-11,  4.142312393485090e-14,  1.770953310763910e-16,
 -8.571248530550328e-19,  4.788438433484245e-22,  7.808944904758626e-24, -2.700619181644394e-26, -1.258591759051595e-29,  7.847973122793140e-01, -2.519451926501304e-03,
  3.103929592624867e-06,  6.469989411856527e-09, -3.388468515773660e-11,  1.844716550627957e-14,  2.733125133360386e-16, -8.287704813222227e-19, -9.063147544946882e-22,
  1.147714559207301e-23, -1.863234401377981e-26, -8.858951630156292e-29,  8.507164737349089e-01, -2.635239723923678e-03,  2.656897409842424e-06,  8.899952272283351e-09,
 -3.419188915106293e-11, -1.300612469554555e-14,  3.584668032767038e-16, -6.118721312467195e-19, -2.684536498570146e-21,  1.306801987728572e-23,  2.928922349470165e-27,
 -1.695037858085432e-28,  9.186959991403921e-01, -2.734607042177338e-03,  2.090925542827858e-06,  1.130348873081085e-08, -3.185693790914020e-11, -5.160256050045141e-14,
  4.124596227567531e-16, -1.714127445659783e-19, -4.507136118745596e-21,  1.068560739654846e-23,  3.622220137235719e-26, -2.113560519501389e-28,  9.885531779471795e-01,
 -2.814134499450368e-03,  1.405920201133597e-06,  1.352728120780419e-08, -2.636688391243526e-11, -9.433054973491344e-14,  4.121244395350244e-16,  4.841089640317731e-19,
 -5.790109863447500e-21,  2.878652741955005e-24,  7.219823832177364e-26, -1.577619043962975e-28,  1.060068519643679e+00, -2.870205842587710e-03,  6.071089156649802e-07,
  1.538567848334574e-08, -1.739454062318018e-11, -1.361897566305079e-13,  3.352888731701479e-16,  1.276362173479680e-18, -5.782220766249477e-21, -1.024195496896663e-23,
  9.297556654075524e-26,  3.005296879956744e-29,  1.132979014987641e+00, -2.899071869041191e-03, -2.933890083748030e-07,  1.666587270818565e-08, -4.935511984105917e-12,
 -1.701428658171840e-13,  1.675212999636442e-16,  2.037103695477584e-18, -3.776302514482508e-21, -2.573885722413065e-23,  7.571512713823362e-26,  3.237849004281466e-28,
  1.206970421194527e+00, -2.896953493202758e-03, -1.274843930394703e-06,  1.713975097160073e-08,  1.053177502813953e-11, -1.875656124812942e-13, -8.861229210937784e-17,
  2.510199316830345e-18,  5.087325808651632e-22, -3.717474380228148e-23,  4.658921493747773e-27,  5.829722760834917e-28,  1.281668590692776e+00, -2.860197537773759e-03,
 -2.306200201603954e-06,  1.658502580517899e-08,  2.788632555845456e-11, -1.794757528169625e-13, -4.033851793336456e-16,  2.397204798690086e-18,  6.436408431447690e-21,
 -3.576294098676812e-23, -1.094807376390135e-25,  5.699933294877374e-28,  1.356629981050846e+00, -2.785501059270984e-03, -3.344644031892901e-06,  1.481810679931828e-08,
  4.525160408300845e-11, -1.387786807963313e-13, -7.127795153735135e-16,  1.465369040313320e-18,  1.208094531831192e-20, -1.457219819833435e-23, -2.130294395281091e-25,
  9.152246975737731e-29,  1.431331674801389e+00, -2.670220790891656e-03, -4.334917583249691e-06,  1.173994262311771e-08,  6.000540591824366e-11, -6.353224910733300e-14,
 -9.211428048975521e-16, -2.851517870651186e-19,  1.440748193651656e-20,  2.441248825255909e-23, -2.181139718675945e-25, -7.393941432015164e-28,  1.505161528634245e+00,
 -2.512781751234821e-03, -5.210068623349840e-06,  7.392885403927242e-09,  6.901572692010545e-11,  3.931566010993522e-14, -9.219855253014853e-16, -2.450226858204959e-18,
  1.049204272139089e-20,  6.414053752253126e-23, -5.967295172078308e-26, -1.323615500940575e-27,  1.577409486737632e+00, -2.313190333407772e-03, -5.894553905910539e-06,
  2.020574546217539e-09,  6.920840349983355e-11,  1.511718345513333e-13, -6.420931600420624e-16, -4.177498980598215e-18, -1.681923170225665e-22,  7.538355784779302e-23,
  2.115259580540805e-25, -8.734866072756339e-28,  1.647261643639628e+00, -2.073638349821307e-03, -6.310739629647110e-06, -3.886477824355056e-09,  5.851190803114193e-11,
  2.425072821838437e-13, -1.015305073990414e-16, -4.424662948763070e-18, -1.340862910944826e-20,  3.613642631249514e-23,  3.881908864278336e-25,  6.593929481688389e-28,
  1.713799300390969e+00, -1.799151404059811e-03, -6.389666204995177e-06, -9.587975073867583e-09,  3.705535158940328e-11,  2.798462889404023e-13,  5.410315068865209e-16,
 -2.595962543192000e-18, -2.083994561337474e-20, -3.906201226075780e-23,  2.467134341435694e-25,  1.880062758422487e-27,  1.776005922026047e+00, -1.498185428287248e-03,
 -6.086180656682226e-06, -1.416936702182620e-08,  8.203418326728940e-12,  2.400354276167560e-13,  1.010139112664273e-15,  7.149559948995545e-19, -1.529268651805844e-20,
 -9.130846912071382e-23, -1.576353407883998e-25,  1.091527309048967e-27,  1.832785352891081e+00, -1.183013524409324e-03, -5.396909752632576e-06, -1.672467507141250e-08,
 -2.130636301852468e-11,  1.276068339816875e-13,  1.043770554944055e-15,  3.601468239025430e-18,  1.020176603093077e-21, -6.495239393325238e-23, -4.044107355892716e-25,
 -1.049304310202513e-27,  1.882994513883286e+00, -8.696882856736821e-04, -4.377044192144534e-06, -1.664101472650670e-08, -4.291711207219902e-11, -1.612134456928317e-14,
  5.943390181071419e-16,  4.020920840721422e-18,  1.473827543976839e-20,  1.769136643489021e-23, -1.817561807902048e-25, -1.588947214303222e-27,  1.925492625951651e+00,
 -5.773467103553819e-04, -3.149218620516508e-06, -1.391264344179502e-08, -4.968151272395399e-11, -1.261493623931560e-13, -5.872785672125522e-17,  1.761938863165659e-18,
  1.344196494456185e-20,  6.237096461205343e-23,  1.856212111629926e-25,  8.809804862927635e-29,  1.959206403567334e+00, -3.266921198684465e-04, -1.896601154394285e-06,
 -9.336694875101293e-09, -4.034437327570501e-11, -1.517122077360005e-13, -4.680306195448062e-16, -9.260347397712991e-19,  1.256245633319266e-21,  2.647014990163752e-23,
  1.802040554801422e-25,  8.889400980296793e-28,  1.983206832817402e+00, -1.376741575715207e-04, -8.349262516717690e-07, -4.418788078084411e-09, -2.140946103361392e-11,
 -9.657919636074194e-14, -4.068768938993679e-16, -1.588870205868350e-18, -5.624442458597429e-21, -1.704829876377928e-23, -3.635056124377587e-26,  1.695463586724569e-29,
  1.996791769942500e+00, -2.665262010265405e-05, -1.656381728860139e-07, -9.119419557268095e-10, -4.687382120048316e-12, -2.301330615409993e-14, -1.091966792335397e-16,
 -5.040376726410033e-19, -2.271742558004713e-21, -1.001760256797888e-23, -4.325249473325674e-26, -1.828049260927021e-28,  3.544066243878094e-04, -1.501616899081991e-06,
  4.770971978346675e-09, -1.347280255895809e-11,  3.565747324973599e-14, -9.058785729176428e-17,  2.236229748050306e-19, -5.408191907630580e-22,  1.285984107013172e-24,
 -3.023203678842860e-27,  7.013754358176955e-30, -1.621155637437955e-32,  3.189658934089032e-03, -1.350496016795991e-05,  4.283720420773971e-08, -1.206103782035116e-10,
  3.177335291372577e-13, -8.018249556860016e-16,  1.961380107368053e-18, -4.687065374162837e-21,  1.097596140588074e-23, -2.531812293274535e-26,  5.737194285911209e-29,
 -1.289640593841198e-31,  8.860154530251822e-03, -3.746035367947988e-05,  1.184274337366596e-07, -3.314492581700328e-10,  8.649739996464971e-13, -2.153096306722938e-15,
  5.167698260894157e-18, -1.203968263242399e-20,  2.727110510434787e-23, -6.027602276552978e-26,  1.292354419236841e-28, -2.710534322697516e-31,  1.736584944083098e-02,
 -7.326455601434825e-05,  2.304539923493910e-07, -6.391311827746216e-10,  1.643886075404949e-12, -4.004955864204958e-15,  9.323409084009515e-18, -2.082253228894179e-20,
  4.449294529826662e-23, -9.074771234308457e-26,  1.733372721960105e-28, -3.072909190981612e-31,  2.870661215543249e-02, -1.207610570648092e-04,  3.772774438176267e-07,
 -1.033406122171955e-09,  2.605069826289718e-12, -6.155677694430205e-15,  1.369763599753437e-17, -2.862643947792126e-20,  5.531532879864492e-23, -9.604886690085490e-26,
  1.354528078366420e-28, -1.067442205401913e-31,  4.288214286954607e-02, -1.797380736497042e-04,  5.566972438980670e-07, -1.500681809920818e-09,  3.684262125159361e-12,
 -8.350306371907655e-15,  1.740467415645135e-17, -3.270367710257959e-20,  5.209130385874932e-23, -5.731769981671041e-26, -2.388724674289134e-29,  3.905706657027765e-31,
  5.989186224459379e-02, -2.499258322220041e-04,  7.659396100335675e-07, -2.024097852701337e-09,  4.803790103959795e-12, -1.029290734904332e-14,  1.947870478772357e-17,
 -3.034025297046424e-20,  2.844715128728953e-23,  3.648050645995045e-26, -3.093508727834661e-28,  1.114899162442402e-30,  7.973476646969653e-02, -3.309931001520747e-04,
  1.001642923127610e-06, -2.583631790692296e-09,  5.874487254215249e-12, -1.166214310005798e-14,  1.896502109740779e-17, -1.928637551009261e-20, -1.901274863062958e-23,
  1.828492661086282e-25, -6.752066868571979e-28,  1.836688201060145e-30,  1.024092444027052e-01, -4.225429174069371e-04,  1.259841125097594e-06, -3.156246913812876e-09,
  6.798138616085757e-12, -1.213028837011463e-14,  1.502564152340974e-17,  1.782080709967803e-21, -8.909123754012572e-23,  3.614859179709509e-25, -1.019336542180772e-27,
  2.184730877791189e-30,  1.279128514111875e-01, -5.241074709908756e-04,  1.535945764062307e-06, -3.716094473607697e-09,  7.470534206738502e-12, -1.138574811208144e-14,
  7.056037246756325e-18,  3.280744435303380e-20, -1.747197147813740e-22,  5.326784891123525e-25, -1.191705370103142e-27,  1.725934790890453e-30,  1.562420331865178e-01,
 -6.351420455799172e-04,  1.824727590139363e-06, -4.234786256024524e-09,  7.785221000793473e-12, -9.159038595734651e-15, -5.191892865220193e-18,  7.194659370508159e-20,
 -2.623018025096485e-22,  6.396175269584010e-25, -1.020849205997324e-27,  1.084406302940384e-31,  1.873917912163398e-01, -7.550179758937338e-04,  2.120298939382785e-06,
 -4.681757377289486e-09,  7.638051856886770e-12, -5.252014275205325e-15, -2.148760803352691e-17,  1.152791280312195e-19, -3.319940733177858e-22,  6.156889443876923e-25,
 -3.593878293687684e-28, -2.747956704741991e-30,  2.213552797135927e-01, -8.830145203268840e-04,  2.416098587349823e-06, -5.024743695238215e-09,  6.932632351165795e-12,
  4.301577933633745e-16, -4.101026502562326e-17,  1.566995516354673e-19, -3.592425270012314e-22,  3.973760140565216e-25,  8.545265402057901e-28, -6.453355613596993e-30,
  2.581233215440654e-01, -1.018309572465485e-03,  2.704881339998553e-06, -5.230403412840170e-09,  5.586759812612240e-12,  7.845193693054992e-15, -6.226089759761320e-17,
  1.880775473396263e-19, -3.178545418828004e-22, -5.739861389646455e-26,  2.528682134337724e-27, -1.000662372001329e-29,  2.976838279860759e-01, -1.159969129227547e-03,
  2.978715399292625e-06, -5.265118233171943e-09,  3.539927432137173e-12,  1.677957842168275e-14, -8.301591480568814e-17,  1.997785129945119e-19, -1.847783942661589e-22,
 -7.469169414576039e-25,  4.357306972911357e-27, -1.180022001072638e-29,  3.400211038975600e-01, -1.306935444257222e-03,  3.228991545021947e-06, -5.096015613676010e-09,
  7.619221248358548e-13,  2.681649739518300e-14, -1.003441319740598e-16,  1.816361637455751e-19,  5.344730893650095e-23, -1.602509999750901e-24,  5.794598907255301e-27,
 -9.869912914794131e-30,  3.851150159436627e-01, -1.458013816909756e-03,  3.446449474742786e-06, -4.692259841309681e-09, -2.737533489246337e-12,  3.730929260461247e-14,
 -1.107144029019170e-16,  1.244529559524212e-19,  3.929631022185994e-22, -2.470120917757668e-24,  6.091963884631363e-27, -2.470327442308260e-30,  4.329399968217585e-01,
 -1.611858006501404e-03,  3.621228312957021e-06, -4.026665016399695e-09, -6.898272731651297e-12,  4.736537942688161e-14, -1.102250283687017e-16,  2.206191588683961e-20,
  8.044971010983163e-22, -3.104722688982021e-24,  4.431647007986009e-27,  1.100934199492000e-29,  4.834638527666188e-01, -1.766954326780342e-03,  3.742950419634300e-06,
 -3.077686211259363e-09, -1.159868677697730e-11,  5.584736970353944e-14, -9.498789890892917e-17, -1.260989674963109e-19,  1.226566748085226e-21, -3.188115445224063e-24,
  1.813345072267435e-28,  2.891134089342191e-29,  5.366463348748026e-01, -1.921604578583054e-03,  3.800850279417192e-06, -1.831843774170597e-09, -1.664491008333205e-11,
  6.140026223711283e-14, -6.169715470285844e-17, -3.120886343223549e-19,  1.562543154998775e-21, -2.381696579804650e-24, -6.731369277790956e-27,  4.629599249634091e-29,
  5.924374268095307e-01, -2.073908135922873e-03,  3.783963505330592e-06, -2.866263353817832e-10, -2.176128945932565e-11,  6.251580651772037e-14, -8.399895170645707e-18,
 -5.166455394993231e-19,  1.685123715892911e-21, -4.236753618035094e-25, -1.537715868383783e-26,  5.466543534688494e-29,  6.507752921240300e-01, -2.221743735303735e-03,
  3.681394870694390e-06,  1.546105086859863e-09, -2.658382931336351e-11,  5.764710675924871e-14,  6.454085501631048e-17, -7.071582720455602e-19,  1.452499949461696e-21,
  2.727890849707684e-24, -2.345096952453639e-26,  4.329200684500240e-29,  7.115838137423556e-01, -2.362751861376764e-03,  3.482688719972243e-06,  3.636234795821576e-09,
 -3.065909406204396e-11,  4.538740171073939e-14,  1.533511279682888e-16, -8.375131806189906e-19,  7.404315961029566e-22,  6.722384766403672e-24, -2.720795419064584e-26,
  3.044352374674908e-30,  7.747696461941039e-01, -2.494319116587097e-03,  3.178329843703945e-06,  5.931134451312267e-09, -3.345204183232089e-11,  2.472529816188688e-14,
  2.497619573688133e-16, -8.513127989076589e-19, -5.074337122376057e-22,  1.066030970357490e-23, -2.205167444560290e-26, -6.693802806862637e-29,  8.402186884421842e-01,
 -2.613566663891707e-03,  2.760407329548522e-06,  8.351262512530723e-09, -3.436741566037278e-11, -4.617782589479156e-15,  3.402025136092172e-16, -6.902417860204535e-19,
 -2.213728866781609e-21,  1.304127407584255e-23, -4.130727561081734e-27, -1.509192573494299e-28,  9.077918725134263e-01, -2.717345810413557e-03,  2.223476820943311e-06,
  1.078605724151368e-08, -3.279047025985680e-11, -4.177705704800982e-14,  4.057005875983956e-16, -3.092247731720831e-19, -4.098619129992940e-21,  1.194820388269841e-23,
  2.691308572010086e-26, -2.106198021147651e-28,  9.773201524364703e-01, -2.802245140005311e-03,  1.565655849111392e-06,  1.309085982097195e-08, -2.815359481029118e-11,
 -8.429772427612565e-14,  4.231049927302655e-16,  3.010267384997297e-19, -5.636260084797979e-21,  5.617824409677061e-24,  6.453082359278173e-26, -1.892682154345372e-28,
  1.048598572378766e+00, -2.864615394119318e-03,  7.899787448723059e-07,  1.508602445969356e-08, -2.003508104707315e-11, -1.277351894785232e-13,  3.683862762350700e-16,
  1.086150925239286e-18, -6.083848533352884e-21, -6.516026592767530e-24,  9.284529887834276e-26, -3.520025157196295e-29,  1.121379297659370e+00, -2.900620618780125e-03,
 -9.398387933428073e-08,  1.655991924248614e-08, -8.293618163747255e-12, -1.654523774985172e-13,  2.227334438751217e-16,  1.902047575897576e-18, -4.645143077500741e-21,
 -2.244630750823811e-23,  8.837848034589442e-26,  2.505440545871116e-28,  1.195363516007423e+00, -2.906326957688204e-03, -1.068279970594893e-06,  1.727815723800464e-08,
  6.764893228883865e-12, -1.888482750024691e-13, -1.829944324044547e-17,  2.505151930841214e-18, -8.200719361758642e-22, -3.648119051058249e-23,  2.983330876907535e-26,
  5.575411371284081e-28,  1.270192172144932e+00, -2.877843749173065e-03, -2.104622899253796e-06,  1.700198810398450e-08,  2.420555004895426e-11, -1.883294808478879e-13,
 -3.335792169801558e-16,  2.581775844864227e-18,  5.076396733035860e-21, -3.961500458417081e-23, -8.253564561497242e-26,  6.504930711665467e-28,  1.345435605776353e+00,
 -2.811534850873285e-03, -3.162577161024668e-06,  1.551901314069912e-08,  4.230851033879392e-11, -1.553498837420478e-13, -6.664274470705119e-16,  1.841932234679742e-18,
  1.140442851278813e-20, -2.295869415342417e-23, -2.049573350767849e-25,  2.750752848106069e-28,  1.420582348097045e+00, -2.704320397223911e-03, -4.188323580135307e-06,
  1.268866102017949e-08,  5.851331240747727e-11, -8.568263964173853e-14, -9.225527431692139e-16,  1.882044217948632e-19,  1.512185853034268e-20,  1.508286033959709e-23,
 -2.471620395377713e-25, -5.739929157974811e-28,  1.495027628961473e+00, -2.554088617608708e-03, -5.114706496882470e-06,  8.502202654691831e-09,  6.957541154169720e-11,
  1.640478476243078e-14, -9.855482636752116e-16, -2.078112307067226e-18,  1.274392817637998e-20,  6.057060205819795e-23, -1.191663597646500e-25, -1.370492011208742e-27,
  1.568062592977054e+00, -2.360230728247087e-03, -5.863566052030881e-06,  3.151219458201326e-09,  7.206827096875136e-11,  1.343599148454348e-13, -7.587193265764742e-16,
 -4.137908038406316e-18,  2.687794615515867e-21,  8.298181795600708e-23,  1.660673670110027e-25, -1.191654084879366e-27,  1.638865845987168e+00, -2.124294535016779e-03,
 -6.351600711585495e-06, -2.911661505135497e-09,  6.332740613235924e-11,  2.385366881523630e-13, -2.312108951648965e-16, -4.829875915069721e-18, -1.182199583481862e-20,
  5.215881203614865e-23,  4.106599822128400e-25,  3.479801960945142e-28,  1.706499746225029e+00, -1.850718447625965e-03, -6.500977679086005e-06, -8.949634622388421e-09,
  4.277584257711102e-11,  2.918822172354600e-13,  4.588113846155697e-16, -3.283271692724485e-18, -2.204824995349231e-20, -2.750074512680722e-23,  3.321580278038444e-25,
  1.990586761577391e-27,  1.769914728192458e+00, -1.547552398386606e-03, -6.255262826458172e-06, -1.399838366658207e-08,  1.324788295729500e-11,  2.644606148575209e-13,
  1.022804501908417e-15,  1.718812057460579e-19, -1.868051369697241e-20, -9.652069339350701e-23, -9.959496777238825e-26,  1.555491685535764e-27,  1.827965669247523e+00,
 -1.226997179188952e-03, -5.599562541163523e-06, -1.704376438590497e-08, -1.849554379269522e-11,  1.538688351958302e-13,  1.144694411804910e-15,  3.593491275060463e-18,
 -1.620050473383454e-21, -8.201104347310197e-23, -4.473161109971069e-25, -8.833659657355289e-28,  1.879444446810498e+00, -9.055151006474343e-04, -4.580864434305223e-06,
 -1.732945367171726e-08, -4.308750041856446e-11, -4.523503034387977e-16,  7.136124698631378e-16,  4.501190073318330e-18,  1.522655122256131e-20,  8.923651047141197e-24,
 -2.591306909369373e-25, -1.932140021495430e-27,  1.923131774920374e+00, -6.032219717338324e-04, -3.321023225689518e-06, -1.472779044927374e-08, -5.221433838557555e-11,
 -1.269160872762236e-13, -3.023770413251699e-18,  2.229445054439397e-18,  1.582144796281216e-20,  6.982256321429079e-23,  1.855722420535018e-25, -1.025698837228717e-28,
  1.957868564079261e+00, -3.423242987382433e-04, -2.012616683614065e-06, -1.000709783502265e-08, -4.349301762536529e-11, -1.632506155041795e-13, -4.932431617909132e-16,
 -8.691174485419343e-19,  2.348793904240046e-21,  3.451027267583006e-23,  2.230712966676274e-25,  1.063189675234808e-27,  1.982642433119982e+00, -1.445716431100916e-04,
 -8.900725200121791e-07, -4.777338192818390e-09, -2.344240652542608e-11, -1.068990172655248e-13, -4.539792639642821e-16, -1.778950613394095e-18, -6.264060052652223e-21,
 -1.847465560051845e-23, -3.461949759587778e-26,  6.479951849642109e-29,  1.996682438096466e+00, -2.802280959733161e-05, -1.770471285434519e-07, -9.907695417189581e-10,
 -5.175042516725284e-12, -2.581194330007071e-14, -1.243841649828127e-16, -5.828538786515778e-19, -2.665558029140684e-21, -1.191983590561580e-23, -5.215285526252179e-26,
 -2.231572533196031e-28,  3.484754819234280e-04, -1.464086254769559e-06,  4.612662607799620e-09, -1.291649050597671e-11,  3.389818265259748e-14, -8.539806968798522e-17,
  2.090401748715509e-19, -5.013562832032148e-22,  1.182031393545407e-24, -2.756414796530190e-27,  6.337821602310822e-30, -1.454547055209798e-32,  3.136315442719255e-03,
 -1.316796661130762e-05,  4.141986104826931e-08, -1.156524200080077e-10,  3.021573325867967e-13, -7.562878246158457e-16,  1.834925580541510e-18, -4.349985801256294e-21,
  1.010448479056279e-23, -2.313285094067541e-26,  5.198505307365998e-29, -1.161380518341612e-31,  8.712183092219744e-03, -3.652861173053843e-05,  1.145316806184196e-07,
 -3.179475437751938e-10,  8.231255163566034e-13, -2.033020239430807e-15,  4.842485368657013e-18, -1.120075143900204e-20,  2.519141172009100e-23, -5.533768216693274e-26,
  1.178613113604985e-28, -2.463735789011413e-31,  1.707643053000591e-02, -7.145116124483131e-05,  2.229396267957928e-07, -6.134578361551379e-10,  1.565978169644508e-12,
 -3.788032501984815e-15,  8.759829281980087e-18, -1.944971662258397e-20,  4.134762998770942e-23, -8.407828533251110e-26,  1.602888515741619e-28, -2.860411506837638e-31,
  2.822952681556443e-02, -1.177917416710620e-04,  3.651226514303665e-07, -9.926923206307494e-10,  2.485179800586190e-12, -5.836356051739774e-15,  1.292036454408640e-17,
 -2.691063679970936e-20,  5.195393283035328e-23, -9.072802939255035e-26,  1.305126825367683e-28, -1.172439944628155e-31,  4.217198507723859e-02, -1.753555388526431e-04,
  5.390373128155870e-07, -1.443047277217303e-09,  3.521359912949235e-12, -7.943396177905771e-15,  1.651199677174372e-17, -3.106992248981756e-20,  5.001460955749973e-23,
 -5.795128553895015e-26, -8.311763722969078e-30,  3.191864432910456e-31,  5.890426194226405e-02, -2.438941808893789e-04,  7.421048878256069e-07, -1.948858962956614e-09,
  4.602538570900604e-12, -9.835508763805507e-15,  1.864210297698093e-17, -2.941122621707347e-20,  2.954914163699075e-23,  2.504415610188031e-26, -2.635103440952707e-28,
  9.715679065459638e-31,  7.842662623247562e-02, -3.231023907991761e-04,  9.711956750050223e-07, -2.491481391900443e-09,  5.645751925611542e-12, -1.121352566620441e-14,
  1.841743818730153e-17, -1.979452023105974e-20, -1.289736641063610e-23,  1.574005377658741e-25, -5.986048455636199e-28,  1.647870380411998e-30,  1.007389929026502e-01,
 -4.126138574749957e-04,  1.222610840949703e-06, -3.049397937337420e-09,  6.559141429487203e-12, -1.176938460062295e-14,  1.503752824157840e-17, -8.683070680066379e-22,
 -7.678892785314978e-23,  3.225880474976083e-25, -9.267157121321421e-28,  2.025669579226205e-30,  1.258407170822143e-01, -5.119962626728593e-04,  1.492062317700322e-06,
 -3.598378143741219e-09,  7.244583909562569e-12, -1.120599430957088e-14,  7.899189381083513e-18,  2.751418481538733e-20, -1.563830251452620e-22,  4.865276135640800e-25,
 -1.115924451081714e-27,  1.714222248611119e-30,  1.537303417730037e-01, -6.207453909813715e-04,  1.774651471218101e-06, -4.111694268278463e-09,  7.600952536830279e-12,
 -9.260397457533203e-15, -3.291493947565261e-18,  6.391348913137141e-20, -2.400086728816608e-22,  5.989615244458415e-25, -1.010027988137310e-27,  3.726199802412437e-31,
  1.844052912044984e-01, -7.382782393424193e-04,  2.064847549687712e-06, -4.560415813583849e-09,  7.528109880740440e-12, -5.730163196119421e-15, -1.840521477860180e-17,
  1.050069550677883e-19, -3.101154249994980e-22,  5.990854528051153e-25, -4.662577110731075e-28, -2.125960799975527e-30,  2.178614999917260e-01, -8.639250333357445e-04,
  2.356467310409643e-06, -4.913804761177877e-09,  6.931741781393277e-12, -5.027230981423224e-16, -3.678142373221511e-17,  1.454387380393402e-19, -3.443875636297028e-22,
  4.261621561457105e-25,  5.916289658456465e-28, -5.513030927166850e-30,  2.540929660053678e-01, -9.969200501046187e-04,  2.642657747666742e-06, -5.139839443255813e-09,
  5.729141685233562e-12,  6.412975612239173e-15, -5.713730146726063e-17,  1.778918189723958e-19, -3.182035617071690e-22,  3.524859563896700e-26,  2.111167311336361e-27,
 -8.978612667439742e-30,  2.930912121586526e-01, -1.136391144037096e-03,  2.915884542557611e-06, -5.205901024899263e-09,  3.856044724414045e-12,  1.485363022030484e-14,
 -7.750870547794016e-17,  1.934680142753806e-19, -2.086535581534064e-22, -5.828192798206014e-25,  3.852425349727163e-27, -1.113500209894579e-29,  3.348446390333227e-01,
 -1.281347873484128e-03,  3.167929781948118e-06, -5.079663336857289e-09,  1.274582210261101e-12,  2.446940951658979e-14, -9.524273379927072e-17,  1.824673096793635e-19,
 -1.766495963274097e-25, -1.379522836495094e-24,  5.352502602593842e-27, -1.018062805504595e-29,  3.793377462782523e-01, -1.430668138415171e-03,  3.389903713204131e-06,
 -4.730234052581330e-09, -2.017629833419641e-12,  3.469530359214327e-14, -1.070667070660113e-16,  1.356517672034822e-19,  3.083933716488669e-22, -2.229202357506048e-24,
  5.940284773367937e-27, -4.349343593788884e-30,  4.265501958670276e-01, -1.583083265185917e-03,  3.572276894834891e-06, -4.129602391778430e-09, -5.977354512778742e-12,
  4.473019858116039e-14, -1.092634337116773e-16,  4.605259457563752e-20,  6.960242966766795e-22, -2.918894270781862e-24,  4.832849777223582e-27,  7.312470558313272e-30,
  4.764556844190613e-01, -1.737161523126587e-03,  3.704941166112759e-06, -3.254454606782424e-09, -1.050479999866926e-11,  5.352962020252913e-14, -9.798639822737749e-17,
 -8.868138798478571e-20,  1.112218053774875e-21, -3.156917615728044e-24,  1.342060034349699e-27,  2.390150852902521e-29,  5.290205846755390e-01, -1.891290139473060e-03,
  3.777310498447847e-06, -2.088421617098767e-09, -1.543239111457830e-11,  5.982023791365046e-14, -6.974885468921589e-17, -2.635071737939254e-19,  1.472434000586731e-21,
 -2.611578224132295e-24, -4.797025544218267e-27,  4.158787250740807e-29,  5.842023076671506e-01, -2.043656010086172e-03,  3.778476117293504e-06, -6.248202002108227e-10,
 -2.051412963919106e-11,  6.214669131844870e-14, -2.211414699976220e-17, -4.630796468414251e-19,  1.659376028224871e-21, -9.910564664685555e-25, -1.300390126475729e-26,
  5.302144139848988e-29,  6.419473269127156e-01, -2.192225505958227e-03,  3.697434385668939e-06,  1.130064879648831e-09, -2.541697370182890e-11,  5.896381870198799e-14,
  4.540463803042427e-17, -6.592842292757417e-19,  1.534292645821874e-21,  1.829485070722457e-24, -2.143504336700892e-26,  4.800151069534839e-29,  7.021887939896654e-01,
 -2.334724081371709e-03,  3.523410846269105e-06,  3.153143322807590e-09, -2.971642647823490e-11,  4.878931786883225e-14,  1.302673590279819e-16, -8.101568111716391e-19,
  9.629175561750620e-22,  5.640836666024850e-24, -2.677245303125342e-26,  1.636113900226686e-29,  7.648436609780548e-01, -2.468616842681099e-03,  3.246309412581055e-06,
  5.400175386264442e-09, -3.289953177750297e-11,  3.043205754033499e-14,  2.257543170299866e-16, -8.615859675193932e-19, -1.401931334657606e-22,  9.725520014282747e-24,
 -2.453697343778868e-26, -4.623703468798063e-29,  8.298092097970896e-01, -2.591091896761800e-03,  2.857321578785243e-06,  7.801081931251925e-09, -3.437972771174703e-11,
  3.307584003249912e-15,  3.199542716119987e-16, -7.536138563269816e-19, -1.748762921888961e-21,  1.274925445291510e-23, -1.031795940629593e-26, -1.300259150916257e-28,
  8.969588719703063e-01, -2.699049244186041e-03,  2.349735754843976e-06,  1.025525121649423e-08, -3.352941946440077e-11, -3.215855865010317e-14,  3.952721530153519e-16,
 -4.333086838601209e-19, -3.651324985749295e-21,  1.284109540497150e-23,  1.778503399542149e-26, -2.032849931556555e-28,  9.661372062999991e-01, -2.789099314254050e-03,
  1.719989579511928e-06,  1.262746889870045e-08, -2.973742584281181e-11, -7.406223591228256e-14,  4.290425557746644e-16,  1.243837247682191e-19, -5.389630392475621e-21,
  8.025253705041128e-24,  5.567786529473703e-26, -2.116178924789265e-28,  1.037153889054605e+00, -2.857577075515120e-03,  9.690049487413115e-07,  1.474551585016903e-08,
 -2.249902326175863e-11, -1.185511625524890e-13,  3.960427605751592e-16,  8.884271916543578e-19, -6.252114715211459e-21, -2.851171650789934e-24,  8.996468116572569e-26,
 -9.458690279924945e-29,  1.109776566482211e+00, -2.900580119067278e-03,  1.038307552169688e-07,  1.640105721185716e-08, -1.154498572966551e-11, -1.594852054494939e-13,
  2.737932550073461e-16,  1.741176399911869e-18, -5.387129533941200e-21, -1.871366962693816e-23,  9.767711680727296e-26,  1.714804007315151e-28,  1.183722431056306e+00,
 -2.914042292940858e-03, -8.604173061453682e-07,  1.735617972343737e-08,  2.989197105771473e-12, -1.884499000724743e-13,  5.128189887420931e-17,  2.458174047617167e-18,
 -2.106112852614889e-21, -3.480962168643892e-23,  5.340099818171659e-26,  5.103390043438954e-28,  1.258648424247057e+00, -2.893858341992078e-03, -1.898400947782357e-06,
  1.735873409220075e-08,  2.036484608490528e-11, -1.954508882481880e-13, -2.592338770613377e-16,  2.720822202167686e-18,  3.597892998990260e-21, -4.232636574069093e-23,
 -5.264854088671759e-26,  7.031576929846219e-28,  1.334140060511427e+00, -2.836079289303678e-03, -2.972392682580651e-06,  1.617024257012073e-08,  3.904595726020356e-11,
 -1.706848344503072e-13, -6.098795410825930e-16,  2.192094319248838e-18,  1.043374555579177e-20, -3.086208454328226e-23, -1.889242705489335e-25,  4.517494161009861e-28,
  1.409699039956679e+00, -2.737202152555617e-03, -4.030502810030555e-06,  1.360996456879934e-08,  5.657895827803179e-11, -1.077055558150401e-13, -9.104406716095872e-16,
  6.788375242795068e-19,  1.548131741796075e-20,  4.748796770416283e-24, -2.680537841207576e-25, -3.699267101705977e-28,  1.484730112093690e+00, -2.594579222853459e-03,
 -5.005994213320527e-06,  9.616729920881970e-09,  6.966250907418345e-11, -7.898558249545260e-15, -1.037705562867403e-15, -1.636455917385007e-18,  1.482413325201250e-20,
  5.459842933116115e-23, -1.793059031150009e-25, -1.351670975844381e-27,  1.558528120435051e+00, -2.406968197955176e-03, -5.818747498942419e-06,  4.324780827826871e-09,
  7.456405395319347e-11,  1.147728364748371e-13, -8.729190025525691e-16, -4.002927051230894e-18,  5.781245301128284e-21,  8.848538843012817e-23,  1.069199932454784e-25,
 -1.492140414460416e-27,  1.630266845742443e+00, -2.175229515021617e-03, -6.380304888514460e-06, -1.860605362093586e-09,  6.803148196990240e-11,  2.313238890030886e-13,
 -3.714386469289032e-16, -5.174942539471122e-18, -9.645905456712988e-21,  6.878135340682839e-23,  4.176005523056365e-25, -4.543664994410151e-29,  1.698992193634984e+00,
 -1.903143769104370e-03, -6.604072322265682e-06, -8.217954398250392e-09,  4.871573962194310e-11,  3.017099658589436e-13,  3.568726060675816e-16, -4.001919639831350e-18,
 -2.277788594977035e-20, -1.245000804140824e-23,  4.205053415084775e-25,  2.007528232537139e-27,  1.763623376144615e+00, -1.598262409341724e-03, -6.421792767906007e-06,
 -1.374276972414844e-08,  1.878259534659825e-11,  2.889948915734406e-13,  1.018721272146958e-15, -4.821174016346126e-19, -2.220913800309454e-20, -9.898854899067208e-23,
 -2.009200869144389e-26,  2.063912372900632e-27,  1.822966785422503e+00, -1.272616567248925e-03, -5.805756804236594e-06, -1.731354732296408e-08, -1.513533269907010e-11,
  1.825402027619167e-13,  1.244117501304541e-15,  3.490886270558999e-18, -4.903221462059685e-21, -1.006066010134422e-22, -4.803864343277184e-25, -5.980167373815605e-28,
  1.875747758999854e+00, -9.430055441233016e-04, -4.792951443181768e-06, -1.801795165882824e-08, -4.291478619344442e-11,  1.824202912797284e-14,  8.465003251047417e-16,
  4.991406670962067e-18,  1.533978262081334e-20, -3.247175681167040e-24, -3.520339355646504e-25, -2.291975115691296e-27,  1.920664611045209e+00, -6.305114866093668e-04,
 -3.502853004419812e-06, -1.558350809656170e-08, -5.474802374191723e-11, -1.261799803719381e-13,  6.687672126232938e-17,  2.777368666021063e-18,  1.846692143781395e-20,
  7.708106685673266e-23,  1.753520391976824e-25, -3.776460761335447e-28,  1.956466287444149e+00, -3.589176553641269e-04, -2.136987038398024e-06, -1.072975751046290e-08,
 -4.687833045535098e-11, -1.753707697651149e-13, -5.163265969585521e-16, -7.722611878005237e-19,  3.763556800401755e-21,  4.442477736586906e-23,  2.740771879035107e-25,
  1.258548152735626e-27,  1.982049533088460e+00, -1.519280782564009e-04, -9.497235675846751e-07, -5.170129880035221e-09, -2.569349625893922e-11, -1.184155217862634e-13,
 -5.066980327421004e-16, -1.990302536460398e-18, -6.953219379847674e-21, -1.978370883927462e-23, -3.032593924595906e-26,  1.345674261790227e-28,  1.996567436765230e+00,
 -2.948819149145315e-05, -1.894507439969932e-07, -1.077868057268221e-09, -5.722507045423859e-12, -2.900305220728914e-14, -1.419657394701204e-16, -6.754402054623173e-19,
 -3.134713902000120e-21, -1.421624117914242e-23, -6.303028722090280e-26, -2.730177141316415e-28,  3.426919707007628e-04, -1.427795853203233e-06,  4.460863454663560e-09,
 -1.238751538346808e-11,  3.223927553174723e-14, -8.054537694729215e-17,  1.955171730057947e-19, -4.650712703218662e-22,  1.087213555142941e-24, -2.515253882857807e-27,
  5.730991242719476e-30, -1.306680744858247e-32,  3.084297618999026e-03, -1.284207798650235e-05,  4.006054760127235e-08, -1.109365567598236e-10,  2.874622780847529e-13,
 -7.136754234815488e-16,  1.717530396698110e-18, -4.039575271807157e-21,  9.307931547276312e-24, -2.115218994168469e-26,  4.713123337867113e-29, -1.047073410867478e-31,
  8.567877300231225e-03, -3.562739892723988e-05,  1.107940085165281e-07, -3.050966091664362e-10,  7.836023678348622e-13, -1.920474759661272e-15,  4.539856959551097e-18,
 -1.042561167818612e-20,  2.328156421602968e-23, -5.083332242225635e-26,  1.075186553198600e-28, -2.241304207931161e-31,  1.679414689009655e-02, -6.969666994504287e-05,
  2.157260030667567e-07, -5.889970303305383e-10,  1.492276527670719e-12, -3.584184944114449e-15,  8.233314604578966e-18, -1.817380838498940e-20,  3.843324089354943e-23,
 -7.791249397605382e-26,  1.481455720152450e-28, -2.661528528739726e-31,  2.776412730943604e-02, -1.149177424851617e-04,  3.534451227323327e-07, -9.538466654819290e-10,
  2.371493491956383e-12, -5.535124393432508e-15,  1.218965817975458e-17, -2.529937297362316e-20,  4.878042752591169e-23, -8.561308670854793e-26,  1.251802825741844e-28,
 -1.246918990345785e-31,  4.147907918369807e-02, -1.711115607450564e-04,  5.220536223454075e-07, -1.387955222911406e-09,  3.366385328518758e-12, -7.557368825838893e-15,
  1.566413155078541e-17, -2.950287275566053e-20,  4.792559161511970e-23, -5.802161122279334e-26,  4.348624489570105e-30,  2.578100155675146e-31,  5.794041253149227e-02,
 -2.380496499199244e-04,  7.191540105209975e-07, -1.876767995984685e-09,  4.410236351169065e-12, -9.397872852305671e-15,  1.783194816654486e-17, -2.845318126326628e-20,
  3.027095320391256e-23,  1.532015893829309e-26, -2.236163350847795e-28,  8.442860951059603e-31,  7.714956859318546e-02, -3.154508977508886e-04,  9.418325668386231e-07,
 -2.402919698075281e-09,  5.425856484081996e-12, -1.077819967137849e-14,  1.785823331115111e-17, -2.012105579188966e-20, -7.644944669818024e-24,  1.348543924766473e-25,
 -5.299637721352893e-28,  1.474669895244078e-30,  9.910786998724701e-02, -4.029775755240489e-04,  1.186640038969250e-06, -2.946315180191816e-09,  6.327359384518270e-12,
 -1.140904286370963e-14,  1.498051004020589e-17, -3.146724721571344e-21, -6.582193427520518e-23,  2.872558213434323e-25, -8.410317368860824e-28,  1.869699846556798e-30,
  1.238163343114164e-01, -5.002305327202625e-04,  1.449569898132332e-06, -3.484247207769145e-09,  7.022419376074106e-12, -1.100771859985139e-14,  8.602099479673222e-18,
  2.278170000787351e-20, -1.396533976177131e-22,  4.433902124930741e-25, -1.041205537362198e-27,  1.678616453903432e-30,  1.512754450440297e-01, -6.067434871781456e-04,
  1.726034707302185e-06, -3.991564390295652e-09,  7.415095183177973e-12, -9.318766605340506e-15, -1.606253944446019e-18,  5.657045199957517e-20, -2.191687370171820e-22,
  5.589522815131455e-25, -9.889533772372309e-28,  5.760722316909000e-31,  1.814848720954423e-01, -7.219763201189772e-04,  2.010841401505349e-06, -4.440905902258198e-09,
  7.409321809689979e-12, -6.137707596340211e-15, -1.560073617074168e-17,  9.542456203586202e-20, -2.889051107593658e-22,  5.787263589132716e-25, -5.478471359974450e-28,
 -1.597225662651631e-30,  2.144431325465849e-01, -8.453072731162071e-04,  2.298166617054161e-06, -4.803023928992468e-09,  6.913183257590816e-12, -1.337840829475137e-15,
 -3.286108841508207e-17,  1.346679136945921e-19, -3.286758806471598e-22,  4.452306609242047e-25,  3.679273022787412e-28, -4.671179112903867e-30,  2.501471799133568e-01,
 -9.760239328180431e-04,  2.581533667742930e-06, -5.047219934385578e-09,  5.844085764220471e-12,  5.100303140519830e-15, -5.229858315694966e-17,  1.677451512053131e-19,
 -3.155071172043120e-22,  1.120858933675980e-25,  1.737818808280476e-27, -8.001027031428351e-30,  2.885919075963790e-01, -1.113312880171713e-03,  2.853793391550829e-06,
 -5.141926971822031e-09,  4.134950047172366e-12,  1.305765370326740e-14, -7.218802554143844e-17,  1.864841915119554e-19, -2.269774597023990e-22, -4.383092092118591e-25,
  3.378417670514053e-27, -1.040237535048897e-29,  3.297695488989542e-01, -1.256247875987123e-03,  3.107111934048048e-06, -5.055477375991380e-09,  1.741525787620571e-12,
  2.224484784983780e-14, -9.014090473031793e-17,  1.817074944356845e-19, -4.609397690780058e-23, -1.174417104250726e-24,  4.902309128261639e-27, -1.024662084237969e-29,
  3.736689519798397e-01, -1.403776456903094e-03,  3.332969662334578e-06, -4.757103185793273e-09, -1.349106658534764e-12,  3.217232424436176e-14, -1.031420371496052e-16,
  1.442817913187162e-19,  2.323687619135407e-22, -1.995874918659757e-24,  5.715518281544463e-27, -5.801302546437912e-30,  4.202747031799915e-01, -1.554704829715892e-03,
  3.522176901806879e-06, -4.218225229256444e-09, -5.108856717774235e-12,  4.212577092200759e-14, -1.076776698803608e-16,  6.668196887627468e-20,  5.944923575995686e-22,
 -2.720119893548548e-24,  5.082652398485084e-27,  4.124434186284200e-30,  4.695660661190423e-01, -1.707680984393431e-03,  3.664914163550760e-06, -3.414095215023189e-09,
 -9.457905118559490e-12,  5.115206688727823e-14, -9.998820327433258e-17, -5.489646127889435e-20,  9.997759715396631e-22, -3.083600515783510e-24,  2.289860095358371e-27,
  1.924303229484249e-29,  5.215156965586615e-01, -1.861176007009701e-03,  3.750807109607317e-06, -2.325862003294818e-09, -1.425329657203523e-11,  5.806296320355654e-14,
 -7.648178270107538e-17, -2.179270939099861e-19,  1.375391344814652e-21, -2.768288785714756e-24, -3.073973693351701e-27,  3.672016751018170e-29,  5.760880840052015e-01,
 -2.013463678106526e-03,  3.769049830064978e-06, -9.431359416970243e-10, -1.927752261492512e-11,  6.146632088938244e-14, -3.434302975592260e-17, -4.106463309689900e-19,
  1.614891015657199e-21, -1.465270713448800e-24, -1.072618513509919e-26,  5.036535879442327e-29,  6.332376600824769e-01, -2.162598611196579e-03,  3.708594225751450e-06,
  7.328805432110525e-10, -2.422826656140376e-11,  5.983761355904504e-14,  2.764078832685382e-17, -6.092943692640360e-19,  1.585238746311340e-21,  1.015271455399824e-24,
 -1.925553481610121e-26,  5.076544871747510e-29,  6.929065005646212e-01, -2.306393451364704e-03,  3.558428519482104e-06,  2.685649010932490e-09, -2.871119462588619e-11,
  5.164718399291679e-14,  1.080434192068234e-16, -7.762993963194365e-19,  1.146916198690233e-21,  4.587728716961982e-24, -2.580327444721879e-26,  2.730035360486148e-29,
  7.550215324011863e-01, -2.442396059505981e-03,  3.307974178485177e-06,  4.878938183317283e-09, -3.223866493966040e-11,  3.556047797080644e-14,  2.016183660800815e-16,
 -8.606633050710451e-19,  1.918214662140435e-22,  8.709127404274214e-24, -2.614280481428783e-26, -2.704189278966962e-29,  8.194911390457132e-01, -2.567868215782637e-03,
  2.947637622727143e-06,  7.251945438904316e-09, -3.423852709521263e-11,  1.072736971286828e-14,  2.981380059889625e-16, -8.023211588488337e-19, -1.298538744982432e-21,
  1.222857779691500e-23, -1.555435041508811e-26, -1.078639189986533e-28,  8.862010372291815e-01, -2.679768271644680e-03,  2.469560378323167e-06,  9.714146213443156e-09,
 -3.407877447164553e-11, -2.283039026125969e-14,  3.815740908009779e-16, -5.426346095060939e-19, -3.178365403861167e-21,  1.337703509767170e-23,  9.105972324168005e-27,
 -1.903942582878686e-28,  9.550092770008834e-01, -2.774741476625929e-03,  1.868617347014646e-06,  1.214038043603352e-08, -3.111551777948500e-11, -6.374262868241337e-14,
  4.301571359331614e-16, -4.305056583102791e-20, -5.062919734036737e-21,  1.006160018948750e-23,  4.604319775795621e-26, -2.248417489647282e-28,  1.025740196618003e+00,
 -2.849123547700866e-03,  1.143714683956022e-06,  1.436708778184904e-08, -2.477309844964819e-11, -1.087703026388301e-13,  4.181072437971118e-16,  6.874026759185004e-19,
 -6.291130175273985e-21,  6.483904996912938e-25,  8.463812954158071e-26, -1.460919689465195e-28,  1.098177149028511e+00, -2.898965602532583e-03,  2.994310638272734e-07,
  1.619119305154473e-08, -1.466513368631640e-11, -1.523492071120660e-13,  3.200369364160901e-16,  1.558776581089321e-18, -5.988892687196824e-21, -1.467951816490987e-23,
  1.034398703762499e-25,  9.045232265466385e-29,  1.172053815048190e+00, -2.920092007595495e-03, -6.519802832811378e-07,  1.737394501484020e-08, -7.619623167061756e-13,
 -1.864019458236149e-13,  1.189820323640671e-16,  2.371183207887851e-18, -3.315562206834550e-21, -3.224267030905057e-23,  7.446529278163266e-26,  4.443217876131332e-28,
  1.247043943153523e+00, -2.908207090251871e-03, -1.688271134744068e-06,  1.765298756459398e-08,  1.639984422894244e-11, -2.007467160229624e-13, -1.816706140357704e-16,
  2.811229431880955e-18,  2.043777391295180e-21, -4.380471621634614e-23, -2.110661896049998e-26,  7.254385169361923e-28,  1.322749428654942e+00, -2.859071903122114e-03,
 -2.774716529339086e-06,  1.676689456371483e-08,  3.549105159407584e-11, -1.845487490449261e-13, -5.440037664651372e-16,  2.506780938738633e-18,  9.191920775728693e-21,
 -3.797288134499114e-23, -1.654487829343213e-25,  6.118055848525982e-28,  1.398686799159609e+00, -2.768777678649426e-03, -3.861826566493149e-06,  1.449681526865833e-08,
  5.420817071745584e-11, -1.292719788180457e-13, -8.844868088468840e-16,  1.174877747913955e-18,  1.545595910144830e-20, -6.231923140571290e-24, -2.792799951745570e-25,
 -1.364018335885462e-28,  1.474272456889748e+00, -2.634146646191952e-03, -4.883915489911740e-06,  1.072869853678384e-08,  6.925206164292364e-11, -3.329797306807374e-14,
 -1.076600167292242e-15, -1.132134355310998e-18,  1.664642808940267e-20,  4.625804570220105e-23, -2.370542295050782e-25, -1.261159018958658e-27,  1.548807505219647e+00,
 -2.453290140172498e-03, -5.759620020102732e-06,  5.534993364732485e-09,  7.664105211064867e-11,  9.250167152580762e-14, -9.819269621306927e-16, -3.766267489416060e-18,
  9.027141423870054e-21,  9.136877538453590e-23,  3.535043189816542e-26, -1.752492057823624e-27,  1.621463727981530e+00, -2.226342410405566e-03, -6.395950161835579e-06,
 -7.356240468764973e-10,  7.255690757028379e-11,  2.206381041529993e-13, -5.202632352275308e-16, -5.440781311245021e-18, -6.870781826948974e-21,  8.531312312982812e-23,
  4.055960532393926e-25, -5.108522891529968e-28,  1.691273348151918e+00, -1.956357097385042e-03, -6.697810535707970e-06, -7.389803192127112e-09,  5.482608501673193e-11,
  3.088476047556258e-13,  2.345711241146002e-16, -4.734565184262973e-18, -2.290220747915028e-20,  6.116015413689569e-24,  5.070461338665957e-25,  1.904209074685986e-27,
  1.757126541174962e+00, -1.650290847691757e-03, -6.584707851846461e-06, -1.339468668019516e-08,  2.480546381838799e-11,  3.131986086835756e-13,  9.947365335364478e-16,
 -1.249795432593014e-18, -2.576389493965697e-20, -9.782084035371818e-23,  8.233090177912897e-26,  2.592434980315042e-27,  1.817782105782362e+00, -1.319897500599998e-03,
 -6.014846542424254e-06, -1.752485101440174e-08, -1.117812943272239e-11,  2.135507502101197e-13,  1.339094484752738e-15,  3.272280416146263e-18, -8.876248992728071e-21,
 -1.202330617254065e-22, -4.978072371080555e-25, -1.679929694574059e-28,  1.871897663802549e+00, -9.822256550308299e-04, -5.013270934971896e-06, -1.870051716307925e-08,
 -4.233517918097257e-11,  4.029040804612361e-14,  9.930938111343712e-16,  5.477488036281762e-18,  1.494415129976121e-20, -1.945119520389480e-23, -4.607543819207915e-25,
 -2.646704418662875e-27,  1.918085313828860e+00, -6.592974015865442e-04, -3.695193832947961e-06, -1.647955039080902e-08, -5.724891770048494e-11, -1.235723552939563e-13,
  1.533428210370072e-16,  3.414024009630397e-18,  2.136315849971805e-20,  8.365903593854392e-23,  1.507698894965364e-25, -7.592530456149543e-28,  1.954995591210232e+00,
 -3.765416019110238e-04, -2.270362393374697e-06, -1.150855049818858e-08, -5.051133883378469e-11, -1.880069226871060e-13, -5.360076793318397e-16, -6.240108424837358e-19,
  5.574088798058755e-21,  5.655698169420730e-23,  3.340849297374694e-25,  1.471508116508997e-27,  1.981426222159350e+00, -1.597812060425777e-04, -1.014312049202059e-06,
 -5.600852446435111e-09, -2.818806099250550e-11, -1.312708252058867e-13, -5.656502099250789e-16, -2.224421946553122e-18, -7.685600411944354e-21, -2.085147956508564e-23,
 -2.233782123334010e-26,  2.342463071019990e-28,  1.996446368612268e+00, -3.105713695224128e-05, -2.029542811123552e-07, -1.174260422026793e-09, -6.338232418955940e-12,
 -3.264900387533908e-14, -1.623629655822248e-16, -7.844507087628588e-19, -3.694930581368950e-21, -1.699492360875472e-23, -7.635306290687945e-26, -3.347435199464779e-28,
  };
  constexpr double w[16896] = {  7.056502674897336e-02, -2.089013222556692e-04,  6.475189158044318e-07, -2.079193847871408e-09,  6.839634381449054e-12,
 -2.283475305005380e-14,  7.683350249481788e-17, -2.593275471643772e-19,  8.753422398392730e-22, -2.949568845856048e-24,  9.911597906929481e-27, -3.319751268457641e-29,
  7.030540652362430e-02, -2.932100328909080e-04,  1.424282545079989e-06, -6.993585776194931e-09,  3.348037650812868e-11, -1.557693321536560e-13,  7.067635870749230e-16,
 -3.139256416934182e-18,  1.369239259089739e-20, -5.878426526344879e-23,  2.488682052835860e-25, -1.040471909085251e-27,  6.979022758511104e-02, -4.595707298687169e-04,
  3.255530991593974e-06, -2.137085119315650e-08,  1.313840874225336e-10, -7.683913129710384e-13,  4.319401264673260e-15, -2.349923025322886e-17,  1.243374294201579e-19,
 -6.421966842759577e-22,  3.247120746581382e-24, -1.610940097647075e-26,  6.902747498677585e-02, -7.035599849100088e-04,  6.674239321222849e-06, -5.563456881917467e-08,
  4.242229687214930e-10, -3.027527066476548e-12,  2.050273877233636e-14, -1.329796406771743e-16,  8.315581584319772e-19, -5.038449177664895e-21,  2.969426497345098e-23,
 -1.707406659601113e-25,  6.802878890042766e-02, -1.018762351198167e-03,  1.242554208808284e-05, -1.284848685406606e-07,  1.190388105480121e-09, -1.016550503280200e-11,
  8.140685558018960e-14, -6.184605234539129e-16,  4.494362472735575e-18, -3.143417719280451e-20,  2.126055212917665e-22, -1.395725071864074e-24,  6.680908019779613e-02,
 -1.397019442297092e-03,  2.140651066859877e-05, -2.699086024726404e-07,  2.990535940789599e-09, -3.011340239273088e-11,  2.812893663903427e-13, -2.471013484316842e-15,
  2.061329319813531e-17, -1.644777082835927e-19,  1.262312419515164e-21, -9.358627818163705e-24,  6.538605032232032e-02, -1.828739046931209e-03,  3.459361830505179e-05,
 -5.241868288343584e-07,  6.856249398257345e-09, -8.045648527849620e-11,  8.671376928295936e-13, -8.718491156005914e-15,  8.268384355398380e-17, -7.457388193958818e-19,
  6.436876223524162e-21, -5.343419078175785e-23,  6.377964005045685e-02, -2.303246971339466e-03,  5.296356556044737e-05, -9.522330050342715e-07,  1.454153640843793e-08,
 -1.968960942616668e-10,  2.426226531825495e-12, -2.768277446222278e-14,  2.960701411805535e-16, -2.995250847261992e-18,  2.886400547701636e-20, -2.663943781249908e-22,
  6.201143427560019e-02, -2.809162673835768e-03,  7.741346961901936e-05, -1.632637596485574e-06,  2.882597388652004e-08, -4.464637001363852e-10,  6.240130116053455e-12,
 -8.020183865107313e-14,  9.606195761660537e-16, -1.082909511873081e-17,  1.157731210601449e-19, -1.180769976251480e-21,  6.010405060970066e-02, -3.334779510501626e-03,
  1.086862190751546e-04, -2.660927734817360e-06,  5.384220764478855e-08, -9.464680147243513e-10,  1.489833328852385e-11, -2.142789036407269e-13,  2.856569632976216e-15,
 -3.567361814706894e-17,  4.207587050400490e-19, -4.716909395998513e-21,  5.808053846298616e-02, -3.868431475501912e-03,  1.473061114952397e-04, -4.146754469954662e-06,
  9.538450953669214e-08, -1.889457046674095e-09,  3.327952503535633e-11, -5.324388518886387e-13,  7.856000725586511e-15, -1.081108191790353e-16,  1.399720524412403e-18,
 -1.716493431556060e-20,  5.596381255467572e-02, -4.398830510813374e-03,  1.935288210152373e-04, -6.208966176736239e-06,  1.611428092723662e-07, -3.573317086447047e-09,
  7.000313264137041e-11, -1.238975820144745e-12,  2.012902391257041e-14, -3.037710812016204e-16,  4.297365932175045e-18, -5.739394229505003e-20,  5.377614086530193e-02,
 -4.915361510163319e-03,  2.473084166267681e-04, -8.968781392286190e-06,  2.608012922417623e-07, -6.434100757841145e-09,  1.394152517928972e-10, -2.715638920651471e-12,
  4.834766078481445e-14, -7.965144288961426e-16,  1.225952448611280e-17, -1.775928812897007e-19,  5.153870227297194e-02, -5.408325733093926e-03,  3.082827123430557e-04,
 -1.254150491970031e-05,  4.059444301932015e-07, -1.107749369361300e-08,  2.640927369511839e-10, -5.634195260783014e-12,  1.094258515804829e-13, -1.959704791693728e-15,
  3.268512453248881e-17, -5.115958385029512e-19,  4.927122395430338e-02, -5.869127146926889e-03,  3.757768189369243e-04, -1.702740972106198e-05,  6.097267877142347e-07,
 -1.830331174341607e-08,  4.777254781267914e-10, -1.111164367665332e-11,  2.344214103030092e-13, -4.545461364280531e-15,  8.184032015291805e-17, -1.379104590963285e-18,
  4.699170348882453e-02, -6.290399917794099e-03,  4.488235060206000e-04, -2.250251477807417e-05,  8.862850342815941e-07, -2.911642937082755e-08,  8.280797888253588e-10,
 -2.090767763225828e-11,  4.771910392609835e-13, -9.979865979702944e-15,  1.932743093128418e-16, -3.494310787042134e-18,  4.471621584051051e-02, -6.666078616042217e-03,
  5.261979661004181e-04, -2.901001694468426e-05,  1.249898692523806e-06, -4.471740495129440e-08,  1.379578007619194e-09, -3.765389206909299e-11,  9.261457316030284e-13,
 -2.081508366287966e-14,  4.321020423031215e-16, -8.354120382088075e-18,  4.245880127816263e-02, -6.991415492094611e-03,  6.064638564942471e-04, -3.655308459863389e-05,
  1.713936618570982e-06, -6.646701187112223e-08,  2.214884242036916e-09, -6.509070705051054e-11,  1.718924760180493e-12, -4.137146035151805e-14,  9.175421867005330e-16,
 -1.891007107873942e-17,  4.023142702005490e-02, -7.262951297177118e-03,  6.880271015449806e-04, -4.508960352599622e-05,  2.289654958513925e-06, -9.582095993778729e-08,
  3.434802441071573e-09, -1.082727445748431e-10,  3.058960024063634e-12, -7.857760264467531e-14,  1.855888854064517e-15, -4.064870990710255e-17,  3.804401303516884e-02,
 -7.478447524233380e-03,  7.691938539396705e-04, -5.452929856035145e-05,  2.984935504521599e-06, -1.342341582153944e-07,  5.155807008984576e-09, -1.736893370184404e-10,
  5.231786681486761e-12, -1.429694493519299e-13,  3.584944816729489e-15, -8.320006506481108e-17,  3.590451100444918e-02, -7.636788648584450e-03,  8.482292009666932e-04,
 -6.473345933956094e-05,  3.803067943613835e-06, -1.830376007584003e-07,  7.504663113883117e-09, -2.692376972973983e-10,  8.617723732793530e-12, -2.497399353023682e-13,
  6.628477592793041e-15, -1.625396389908520e-16,  3.381902487102457e-02, -7.737863028114974e-03,  9.234136018216001e-04, -7.551729702906983e-05,  4.741683625935000e-06,
 -2.432948839022858e-07,  1.060986008381938e-08, -4.039859224874531e-10,  1.369645964019764e-11, -4.196455787029076e-13,  1.175531244674825e-14, -3.037227828397787e-16,
  3.179196156716608e-02, -7.782430687307433e-03,  9.930945890054303e-04, -8.665477079611801e-05,  5.791941749762482e-06, -3.156489538657523e-07,  1.458995997976887e-08,
 -5.876745533375295e-10,  2.103846982392673e-11, -6.794904224935791e-13,  2.003249752510051e-14, -5.438782333007463e-16,  2.982620124614041e-02, -7.771985385591638e-03,
  1.055731892926659e-03, -9.788556394096088e-05,  6.938052191223442e-06, -4.001724201506485e-07,  1.953941445206174e-08, -8.299302953015085e-10,  3.127841375200159e-11,
 -1.061844556028971e-12,  3.285639593964487e-14, -9.349000082522624e-16,  2.792327750580162e-02, -7.708617289472220e-03,  1.109934792310255e-03, -1.089237704322747e-04,
  8.157194635785357e-06, -4.962362353862749e-07,  2.551286752648577e-08, -1.139202730105303e-09,  4.506698154169376e-11, -1.603641847583151e-12,  5.194102449390706e-14,
 -1.544958736957330e-15,  2.608355950905226e-02, -7.594881352794060e-03,  1.154491102745733e-03, -1.194677781867487e-04,  9.419863982113987e-06, -6.024114778617684e-07,
  3.250937117039343e-08, -1.521480708496214e-09,  6.300018529179365e-11, -2.343365633211894e-12,  7.924136212530218e-14, -2.457689389649759e-15,  2.430642944200785e-02,
 -7.433675266556417e-03,  1.188387753589762e-03, -1.292108057247959e-04,  1.069064030009815e-05, -7.164173157032729e-07,  4.045822641367051e-08, -1.978893463446697e-09,
  8.552867629264538e-11, -3.316688046646169e-12,  1.167926249950645e-13, -3.767817855960737e-15,  2.259045028576639e-02, -7.228129653338127e-03,  1.210823345160791e-03,
 -1.378515596164946e-04,  1.192935096835526e-05, -8.351251161336652e-07,  4.920826969048478e-08, -2.508344538165935e-09,  1.128538994933285e-10, -4.550676599897568e-12,
  1.664560248429140e-13, -5.572185600425955e-15,  2.093352032179163e-02, -6.981512112523975e-03,  1.221213412279835e-03, -1.451045242553594e-04,  1.309256561283806e-05,
 -9.546243966247852e-07,  5.852231786387215e-08, -3.100356229694920e-09,  1.448221118447291e-10, -6.056995477764646e-12,  2.295774645011444e-13, -7.955708349873304e-15,
  1.933301208168428e-02, -6.697145809258878e-03,  1.219189346193072e-03, -1.507094641637687e-04,  1.413534309237593e-05, -1.070351329211076e-06,  6.807815980050985e-08,
 -3.738311337271641e-09,  1.808306831284736e-10, -7.824860184674026e-12,  3.065864492075280e-13, -1.097277248969571e-14,  1.778589455283743e-02, -6.378342560456187e-03,
  1.204592052596507e-03, -1.544398029871069e-04,  1.501313524395139e-05, -1.177275302281092e-06,  7.747696055380121e-08, -4.398262975032192e-09,  2.197628534952939e-10,
 -9.814786386999398e-12,  3.965848323595880e-13, -1.462582939590917e-14,  1.628883834725724e-02, -6.028349806967070e-03,  1.177461462369661e-03, -1.561096338381027e-04,
  1.568374485904795e-05, -1.270134116546365e-06,  8.625927607375228e-08, -5.049440963700962e-09,  2.599665904532946e-10, -1.195433482182880e-11,  4.969940209928858e-13,
 -1.884426728211315e-14,  1.483830423395520e-02, -5.650310461720600e-03,  1.138022980333815e-03, -1.555792051937059e-04,  1.610923517772844e-05, -1.343704192074558e-06,
  9.392813190976765e-08, -5.655517737979791e-09,  2.992900367043145e-10, -1.413703156423090e-11,  6.033395070858883e-13, -2.346769872633986e-14,  1.343061594049247e-02,
 -5.247234370702196e-03,  1.086671873467558e-03, -1.527588092455547e-04,  1.625769428307965e-05, -1.393089044854916e-06,  9.997787959772634e-08, -6.176614477819504e-09,
  3.351803629683710e-10, -1.622540035542523e-11,  7.092483293574734e-13, -2.823824431403009e-14,  1.206201846932985e-02, -4.821979994025403e-03,  1.023956480443251e-03,
 -1.476110713761904e-04,  1.610476901004754e-05, -1.414007486772171e-06,  1.039268910452948e-07, -6.571938962799160e-09,  3.648451923507755e-10, -1.805858355139529e-11,
  8.067156467882024e-13, -3.280592532789648e-14,  1.072872337719402e-02, -4.377244883681167e-03,  9.505609842143242e-04, -1.401516979368713e-04,  1.563489801084366e-05,
 -1.403062613948674e-06,  1.053516568755833e-07, -6.802861806566345e-09,  3.854671106296945e-10, -1.946439770803638e-11,  8.866615486636424e-13, -3.674976930134936e-14,
  9.426942561250205e-03, -3.915563579797579e-03,  8.672883414906616e-04, -1.304487839634796e-04,  1.484219107150305e-05, -1.357973652099129e-06,  1.039195747563644e-07,
 -6.836168683806842e-09,  3.944533628381774e-10, -2.027495731732649e-11,  9.397527444086707e-13, -3.961478643068922e-14,  8.152912119899285e-03, -3.439311650065241e-03,
  7.750438179571221e-04, -1.186208134542421e-04,  1.373092037856888e-05, -1.277754993574081e-06,  9.941768085140805e-08, -6.647182810823958e-09,  3.896959872636837e-10,
 -2.034432262529037e-11,  9.574133945764441e-13, -4.096195660584054e-14,  6.902907863508275e-03, -2.950714751710794e-03,  6.748194463041799e-04, -1.048335042124291e-04,
  1.231560814049303e-05, -1.162830079235790e-06,  9.177479913087444e-08, -6.222441251691386e-09,  3.698135448814270e-10, -1.956610982238605e-11,  9.329046643670531e-13,
 -4.042535362275522e-14,  5.673254189064905e-03, -2.451861842114215e-03,  5.676796234977623e-04, -8.929566113018485e-05,  1.062071314879459e-05, -1.015071902154689e-06,
  8.107504314784236e-08, -5.561633730651414e-09,  3.343451192327747e-10, -1.788875368921832e-11,  8.623233823858723e-13, -3.776820295799412e-14,  4.460328959251668e-03,
 -1.944722272961371e-03,  4.547480640346326e-04, -7.225421928994493e-05,  8.679937197230887e-06, -8.377666671206419e-07,  6.756127293063745e-08, -4.678572877280516e-09,
  2.838707777835709e-10, -1.532620689092221e-11,  7.453643267204668e-13, -3.292864688515228e-14,  3.260573029028478e-03, -1.431169355156586e-03,  3.371968778135080e-04,
 -5.398875639525557e-05,  6.535199216199408e-06, -6.355030931027499e-07,  5.162799883819768e-08, -3.601059559138949e-09,  2.200402713558338e-10, -1.196232862777872e-11,
  5.857127480316828e-13, -2.604671101400678e-14,  2.070568347586977e-03, -9.130376238261282e-04,  2.162442930596095e-04, -3.480668617364035e-05,  4.235452043222572e-06,
 -4.140057031851481e-07,  3.380500239975124e-08, -2.369678809272424e-09,  1.455057946406742e-10, -7.948186781934924e-12,  3.909910444337290e-13, -1.746686970258167e-14,
  8.884024211541703e-04, -3.927516571474000e-04,  9.328884159930876e-05, -1.505994036863568e-05,  1.837921305999643e-06, -1.801695634952881e-07,  1.475304213081576e-08,
 -1.037030557775927e-09,  6.384974461262600e-11, -3.497027071890034e-12,  1.724746194996974e-13, -7.724552558635195e-15,  6.973962632533516e-02, -2.038191459233009e-04,
  6.232104415270639e-07, -1.973315480451170e-09,  6.400807157956356e-12, -2.107481325631860e-14,  6.994905086585398e-17, -2.329417957709503e-19,  7.759558485083397e-22,
 -2.580819415613699e-24,  8.561440731744785e-27, -2.831169229011878e-29,  6.915483595193167e-02, -2.821425889116399e-04,  1.343473729953277e-06, -6.481930244825558e-09,
  3.052774112129036e-11, -1.398141733905484e-13,  6.246936552035666e-16, -2.733124368883797e-18,  1.174484099906961e-20, -4.968751833082187e-23,  2.073232438612491e-25,
 -8.544131938051022e-28,  6.800245793322482e-02, -4.345176787610251e-04,  3.011204164183506e-06, -1.938623179403927e-08,  1.170018573372560e-10, -6.721923187820061e-13,
  3.713821423354277e-15, -1.986659281294525e-17,  1.033950627759944e-19, -5.254447545895204e-22,  2.614772051471554e-24, -1.277006424724500e-26,  6.631595169489574e-02,
 -6.527255752106451e-04,  6.045435002729823e-06, -4.930588401594051e-08,  3.683063445423902e-10, -2.577295333455826e-12,  1.712613188620918e-14, -1.090566080233192e-16,
  6.698599419554630e-19, -3.988291543224880e-21,  2.310532402487689e-23, -1.306348910838482e-25,  6.414322089088947e-02, -9.252162925957717e-04,  1.099162014131063e-05,
 -1.109645933150094e-07,  1.005292739737658e-09, -8.404281406710263e-12,  6.594435493300367e-14, -4.912186792590363e-16,  3.502083220851690e-18, -2.404183762319267e-20,
  1.596727557162732e-22, -1.029696236469676e-24,  6.154408442978833e-02, -1.237953044956124e-03,  1.843595101585240e-05, -2.265336202972872e-07,  2.450536294042792e-09,
 -2.412332218347182e-11,  2.205106682274641e-13, -1.897134174775674e-15,  1.550976931852282e-17, -1.213515834818781e-19,  9.136896699576678e-22, -6.648536980464775e-24,
  5.858723416988471e-02, -1.575401507182328e-03,  2.891192331441874e-05, -4.263070506131181e-07,  5.436905253206323e-09, -6.229874606301583e-11,  6.563556900095244e-13,
 -6.456721546613039e-15,  5.995602517159670e-17, -5.298038480039678e-19,  4.482896083625274e-21, -3.649807565859167e-23,  5.534691326143885e-02, -1.921570294642982e-03,
  4.281237760159573e-05, -7.481534790844695e-07,  1.112826180648557e-08, -1.469896803223168e-10,  1.769003055878409e-12, -1.973203624044223e-14,  2.064768587267777e-16,
 -2.045143518233790e-18,  1.930732646374272e-20, -1.746618131286738e-22,  5.189955535466242e-02, -2.261010167023844e-03,  6.031885898191572e-05, -1.235424422370453e-06,
  2.122896557123467e-08, -3.205054068940455e-10,  4.372057329947577e-12, -5.489843426727944e-14,  6.429560083309624e-16, -7.092432881060992e-18,  7.424434228754256e-20,
 -7.418617526487034e-22,  4.832060773757838e-02, -2.579691043826605e-03,  8.135704239348884e-05, -1.933328097939467e-06,  3.805120352793542e-08, -6.516562034537623e-10,
  1.000620287550863e-11, -1.405353220826265e-13,  1.831096865060451e-15, -2.236701017854218e-17,  2.582150891664806e-19, -2.835025738505044e-21,  4.468172495598453e-02,
 -2.865695480707873e-03,  1.055827889777480e-04, -2.884119214759662e-06,  6.450773338800183e-08, -1.244484147473918e-09,  2.137487887731312e-11, -3.338362816539224e-13,
  4.812800507853255e-15, -6.476522847017791e-17,  8.205292737270963e-19, -9.852547060022865e-21,  4.104846964443680e-02, -3.109691507401724e-03,  1.323989040437403e-04,
 -4.121732073808081e-06,  1.040044706226339e-07, -2.245781616278711e-09,  4.289627876069435e-11, -7.410289093306763e-13,  1.176154493969693e-14, -1.735428477955857e-16,
  2.402100474126232e-18, -3.140972699317679e-20,  3.747860113667582e-02, -3.305173102062365e-03,  1.609986011968869e-04, -5.666635786234228e-06,  1.602221627032206e-07,
 -3.849219469605475e-09,  8.132178235803278e-11, -1.546106823176454e-12,  2.689130570261476e-14, -4.331612137332328e-16,  6.523213650119324e-18, -9.251886951444284e-20,
  3.402097673870539e-02, -3.448479815739966e-03,  1.904286225178867e-04, -7.521689011886643e-06,  2.367964419081480e-07, -6.293822994681748e-09,  1.463243522294923e-10,
 -3.047392390208123e-12,  5.782896252121564e-14, -1.012728605865678e-15,  1.652880375317930e-17, -2.533336768950414e-19,  3.071504107881906e-02, -3.538625669038483e-03,
  2.196632580660441e-04, -9.669625111476593e-06,  3.369264108202343e-07, -9.854986893394847e-09,  2.509184479133007e-10, -5.698958611610356e-12,  1.175062500411068e-13,
 -2.228590193162964e-15,  3.927501228664411e-17, -6.482270384654367e-19,  2.759083976299930e-02, -3.576979943680176e-03,  2.476802161030185e-04, -1.207254493757355e-05,
  4.629587406218526e-07, -1.482721201698427e-08,  4.115499500974267e-10, -1.015086544562249e-11,  2.265205859332852e-13, -4.635445407362347e-15,  8.790106233591685e-17,
 -1.557094126798625e-18,  2.466946680642147e-02, -3.566848470732758e-03,  2.735302460503356e-04, -1.467348985545440e-05,  6.160031048251007e-07, -2.149912468487162e-08,
  6.477031474819746e-10, -1.727918742637128e-11,  4.157506007934775e-13, -9.147319146910905e-15,  1.860190092240700e-16, -3.525339818609619e-18,  2.196384128894810e-02,
 -3.513003987974733e-03,  2.963942692488941e-04, -1.739987197469054e-05,  7.956335983993041e-07, -3.012283051123861e-08,  9.809185066003716e-10, -2.819484281927411e-11,
  7.288128078989775e-13, -1.718213741588922e-14,  3.735099900520356e-16, -7.549792789659181e-18,  1.947970619655800e-02, -3.421209284652127e-03,  3.156241092734263e-04,
 -2.016830266724116e-05,  9.997199029092246e-07, -4.088093282699992e-08,  1.433196762466236e-09, -4.422019376111759e-11,  1.223754027674753e-12, -3.081285242097761e-14,
  7.137865208617912e-16, -1.534272799193440e-17,  1.721674923645222e-02, -3.297768717517454e-03,  3.307653220289720e-04, -2.289021672574404e-05,  1.224413747319693e-06,
 -5.385531976041111e-08,  2.024868941920456e-09, -6.682488063206691e-11,  1.973249220025706e-12, -5.289565356979300e-14,  1.301850302414826e-15, -2.967216804882319e-17,
  1.516975881162112e-02, -3.149133878081132e-03,  3.415627675359558e-04, -2.547764884830551e-05,  1.464294433600185e-06, -6.900191294178544e-08,  2.772118034834452e-09,
 -9.751742740827098e-11,  3.062576563260850e-12, -8.713477088626843e-14,  2.271794148036456e-15, -5.475191553996332e-17,  1.332974551743991e-02, -2.981579157686447e-03,
  3.479512133600695e-04, -2.784857255906329e-05,  1.712655975511504e-06, -8.613494676628032e-08,  3.684423571964694e-09, -1.376961749551959e-10,  4.584812892732540e-12,
 -1.380375602302720e-13,  3.801697693158978e-15, -9.662061970554596e-17,  1.168497798177491e-02, -2.800953812175952e-03,  3.500343090141151e-04, -2.993133585231582e-05,
  1.961901312728487e-06, -1.049231350873383e-07,  4.762246190927076e-09, -1.884708398138517e-10,  6.633039089036700e-12, -2.107166490059673e-13,  6.113354657091777e-15,
 -1.634112317923561e-16,  1.022189962945131e-02, -2.612509601745775e-03,  3.480557249217115e-04, -3.166789223647782e-05,  2.203998470073330e-06, -1.248985208663412e-07,
  5.995264470430012e-09, -2.504729078636816e-10,  9.289827912007275e-12, -3.105102362963177e-13,  9.464180211349941e-15, -2.653805843035459e-16,  8.925908634993457e-03,
 -2.420797525126538e-03,  3.423661929676016e-04, -3.301569964439406e-05,  2.430950296471821e-06, -1.454771836063318e-07,  7.361420742185113e-09, -3.236776614728048e-10,
  1.261482602395992e-11, -4.424170551667156e-13,  1.412917833257896e-14, -4.145565669047815e-16,  7.781996148430128e-03, -2.229623612406331e-03,  3.333897496090942e-04,
 -3.394831715612330e-05,  2.635232997897414e-06, -1.659895734880625e-07,  8.826936481854934e-09, -4.072618387506860e-10,  1.663173235166550e-11, -6.103759396737223e-13,
  2.037208537957152e-14, -6.238800026743729e-16,  6.775247557817612e-03, -2.042051987620773e-03,  3.215918135338896e-04, -3.445485313043442e-05,  2.810167487256946e-06,
 -1.857172543759300e-07,  1.034733894393190e-08, -4.995183522950197e-10,  2.131631078846077e-11, -8.164556871299147e-13,  2.840666143550976e-14, -9.057774832925370e-16,
  5.891218193302863e-03, -1.860443121649883e-03,  3.074509645588116e-04, -3.453849966909962e-05,  2.950199476936687e-06, -2.039323746855171e-07,  1.186941973975620e-08,
 -5.978435307064830e-10,  2.658717606442689e-11, -1.060051760479845e-12,  3.835130332478253e-14, -1.270198751595951e-15,  5.116198839177022e-03, -1.686515972899879e-03,
  2.914355394383653e-04, -3.421442690970897e-05,  3.051077042045286e-06, -2.199362461515125e-07,  1.333394237618289e-08, -6.988040138424843e-10,  3.230092174390218e-11,
 -1.337205285447984e-12,  5.018228369268971e-14, -1.722275234134488e-15,  4.437388195917952e-03, -1.521424170680681e-03,  2.739855006649232e-04, -3.350731201186326e-05,
  3.109926215093407e-06, -2.330939107860335e-07,  1.467884357484052e-08, -7.982811465832950e-10,  3.825273598351531e-11, -1.640161582028393e-12,  6.369250007564758e-14,
 -2.259882296020131e-15,  3.842989557402348e-03, -1.365838197404713e-03,  2.554995098570353e-04, -3.244875093686503e-05,  3.125234722171984e-06, -2.428623764244373e-07,
  1.584263957975676e-08, -8.916819603211824e-10,  4.418303914583189e-11, -1.957268108937548e-12,  7.846322057964765e-14, -2.871487949889388e-15,  3.322247945832732e-03,
 -1.220027406194669e-03,  2.363267628519057e-04, -3.107475649289565e-05,  3.096760550370542e-06, -2.488111424573100e-07,  1.676775344205558e-08, -9.741988647173125e-10,
  4.978997521012223e-11, -2.273276850945235e-12,  9.385567397989151e-14, -3.534716927239059e-15,  2.865442216850473e-03, -1.083937483327677e-03,  2.167629125356270e-04,
 -2.942349329544960e-05,  3.025385532217443e-06, -2.506345719503811e-07,  1.740351624276566e-08, -1.041095818519642e-09,  5.474690461085666e-11, -2.570068824625852e-12,
  1.090274211392951e-13, -4.216030943510861e-15,  2.463844560984584e-03, -9.572605151047999e-04,  1.970492974387735e-04, -2.753334719254525e-05,  2.912934868124406e-06,
 -2.481564788556353e-07,  1.770865434441659e-08, -1.087997309763849e-09,  5.872347747329646e-11, -2.827765738798395e-12,  1.229754829459637e-13, -4.871817218697067e-15,
  2.109657646245309e-03, -8.394960906371585e-04,  1.773746821522347e-04, -2.544137896363655e-05,  2.761982074366332e-06, -2.413279162861275e-07,  1.765314460480807e-08,
 -1.111157763325147e-09,  6.140848376940784e-11, -3.026143889865140e-12,  1.346046204705514e-13, -5.450998080656628e-15,  1.795937549345602e-03, -7.300028547380439e-04,
  1.578787713763513e-04, -2.318217305575463e-05,  2.575655943307922e-06, -2.302195434735455e-07,  1.721938931760195e-08, -1.107692444962335e-09,  6.253251525646080e-11,
 -3.146225306597936e-12,  1.428155243930959e-13, -5.899050591369987e-15,  1.516508720079534e-03, -6.280406378129629e-04,  1.386568570620873e-04, -2.078706311472680e-05,
  2.357462416703080e-06, -2.150101207208493e-07,  1.640272396399485e-08, -1.075755773267313e-09,  6.188853137039776e-11, -3.171896242901309e-12,  1.466045487860392e-13,
 -6.163093262024764e-15,  1.265875572368096e-03, -5.328037694125160e-04,  1.197650763851589e-04, -1.828369694443314e-05,  2.111130380816612e-06, -1.959726647424378e-07,
  1.521131816284483e-08, -1.014658369175010e-09,  5.934866582476830e-11, -3.091396004114366e-12,  1.451645073713783e-13, -6.197497412785565e-15,  1.039133918217573e-03,
 -4.434464750882062e-04,  1.012258815568596e-04, -1.569589317445310e-05,  1.840486730673060e-06, -1.734596373835314e-07,  1.366556110912546e-08, -9.249194488969524e-10,
  5.487599169880174e-11, -2.898529753526507e-12,  1.379752602850691e-13, -5.969349781586214e-15,  8.318843665443581e-04, -3.591014151839700e-04,  8.303344158371579e-05,
 -1.304373891691951e-05,  1.549362927530699e-06, -1.478882918362349e-07,  1.179703779169945e-08, -8.082557813907475e-10,  4.853042287388687e-11, -2.593485108113105e-12,
  1.248734725335548e-13, -5.463055920118660e-15,  6.401490621770221e-04, -2.788925298506038e-04,  6.515881378673375e-05, -1.034388166308620e-05,  1.241533002562350e-06,
 -1.197270262846250e-07,  9.647205037181743e-09, -6.675121723414203e-10,  4.046841936896984e-11, -2.183170411120255e-12,  1.060929429825738e-13, -4.683441291395878e-15,
  4.602933014679081e-04, -2.019437042270138e-04,  4.755489829187592e-05, -7.609987856951284e-06,  9.206827870184352e-07, -8.948345416851097e-08,  7.265880189648263e-09,
 -5.065418966970942e-10,  3.093668064618442e-11, -1.681040185854695e-12,  8.227012829162266e-14, -3.656877009096467e-15,  2.889607128392723e-04, -1.273880962040455e-04,
  3.016206437176191e-05, -4.853477332668274e-06,  5.904247077872115e-07, -5.769616663569876e-08,  4.709765915516469e-09, -3.300559365514116e-10,  2.026096496728762e-11,
 -1.106449889164990e-12,  5.441472141632692e-14, -2.430261310097735e-15,  1.231900455573387e-04, -5.445354772936291e-05,  1.293218541219655e-05, -2.087362782530301e-06,
  2.547029437112324e-07, -2.496440809220622e-08,  2.043877525498724e-09, -1.436478140368121e-10,  8.843040328083195e-12, -4.842584650099605e-13,  2.388031370070805e-14,
 -1.069364538988761e-15,  6.893417355313922e-02, -1.989264719665154e-04,  6.001315133967408e-07, -1.874185490684560e-09,  5.995584498225472e-12, -1.947158216682918e-14,
  6.376079889660413e-17, -2.095340262818512e-19,  6.889219644442373e-22, -2.262012835799772e-24,  7.408870629489546e-27, -2.419309537376094e-29,  6.804727999824357e-02,
 -2.716978355294662e-04,  1.268531522214794e-06, -6.015067329991786e-09,  2.787539808124649e-11, -1.256989834592236e-13,  5.531699519799620e-16, -2.384379625993662e-18,
  1.009673221677163e-20, -4.209977925678679e-23,  1.731615420523567e-25, -7.035701123632920e-28,  6.631113675135177e-02, -4.113277512497167e-04,  2.789373100158786e-06,
 -1.761709264497005e-08,  1.044061312913749e-10, -5.893786862431928e-13,  3.201171902774393e-15, -1.684147026874475e-17,  8.623378101337634e-20, -4.312764086415744e-22,
  2.112643730582065e-24, -1.015895294598689e-26,  6.379816554833734e-02, -6.066323756753510e-04,  5.487490394014948e-06, -4.380401355967056e-08,  3.206353468706056e-10,
 -2.200615531734125e-12,  1.435226895897506e-14, -8.975063335410218e-17,  5.416198652425177e-19, -3.169515547151012e-21,  1.805348490227420e-23, -1.003879371426295e-25,
  6.061015820041862e-02, -8.423484304723022e-04,  9.751272597135864e-06, -9.614306146163285e-08,  8.519818798207428e-10, -6.974760585940823e-12,  5.363735150433298e-14,
 -3.918508811800376e-16,  2.741403018564505e-18, -1.847659554555104e-20,  1.205237716479024e-22, -7.636554633297615e-25,  5.687092582251038e-02, -1.100707389755404e-03,
  1.593776207360641e-05, -1.909143262718492e-07,  2.016963302340904e-09, -1.941621782633052e-11,  1.737296934277490e-13, -1.464201242724204e-15,  1.173408828131604e-17,
 -9.004746538730886e-20,  6.652971664907196e-22, -4.752463796385625e-24,  5.271778915378320e-02, -1.363179444393599e-03,  2.427967785359608e-05, -3.484862597387043e-07,
  4.334861794344445e-09, -4.851532656448630e-11,  4.997901572998589e-13, -4.811601994524947e-15,  4.375787136207027e-17, -3.789257693341466e-19,  3.143750676453618e-21,
 -2.510833671713864e-23,  4.829276694853003e-02, -1.612165071869212e-03,  3.481282533100449e-05, -5.914880971857796e-07,  8.571864904609822e-09, -1.104800013325324e-10,
  1.298920889961639e-12, -1.416756458551337e-14,  1.450802162390642e-16, -1.407242198527948e-18,  1.301764455182300e-20, -1.154521384648014e-22,  4.373427748956969e-02,
 -1.832437951707522e-03,  4.733734707363109e-05, -9.418243125437062e-07,  1.575472580791621e-08, -2.319138834462181e-10,  3.088305341972876e-12, -3.789421944925901e-14,
  4.340493889325850e-16, -4.686114242359122e-18,  4.804145883074872e-20, -4.703886261968056e-22,  3.917002827498269e-02, -2.012196460435104e-03,  6.141880555528429e-05,
 -1.416953391532240e-06,  2.713213770146111e-08, -4.527843115268831e-10,  6.783408402744216e-12, -9.305115168349477e-14,  1.185188635068973e-15, -1.416296838964357e-17,
  1.600619934000099e-19, -1.721407868970168e-21,  3.471156190266424e-02, -2.143649911925217e-03,  7.642704271039936e-05, -2.026130643901135e-06,  4.407244223096982e-08,
 -8.282002007579092e-10,  1.387376967209455e-11, -2.115582398685199e-13,  2.980523272436854e-15, -3.922616938615816e-17,  4.863716665257710e-19, -5.719179222151823e-21,
  3.045069011627721e-02, -2.223136524022820e-03,  9.160394351802498e-05, -2.767406203888915e-06,  6.790081017155801e-08, -1.427897944900597e-09,  2.659546335852244e-11,
 -4.484814831166990e-13,  6.954930941157673e-15, -1.003463833966598e-16,  1.359128863213412e-18, -1.740149806203839e-20,  2.645782003242655e-02, -2.250830798408617e-03,
  1.061469420244054e-04, -3.626050483186268e-06,  9.969580628227923e-08, -2.332537226283673e-09,  4.805143386079693e-11, -8.917481053110925e-13,  1.515359269309988e-14,
 -2.386733977639695e-16,  3.517047315762722e-18, -4.884187473108274e-20,  2.278198661674328e-02, -2.230140352121994e-03,  1.192938927835471e-04, -4.574790280169977e-06,
  1.400791239367748e-07, -3.626465918761466e-09,  8.222105290778827e-11, -1.671642341499260e-12,  3.099577563126162e-14, -5.308117024579396e-16,  8.477948564323951e-18,
 -1.272416508750178e-19,  1.945227218568668e-02, -2.166912733656384e-03,  1.303965653158537e-04, -5.575865325870478e-06,  1.890386868350130e-07, -5.387422303081569e-09,
  1.338053303424351e-10, -2.967499920976043e-12,  5.979930484534682e-14, -1.109298998887550e-15,  1.913492773736139e-17, -3.093242472047505e-19,  1.648022350523946e-02,
 -2.068572422721952e-03,  1.389736994029739e-04, -6.584557943177880e-06,  2.458219570866676e-07, -7.674492168859641e-09,  2.078775171958864e-10, -5.008472685285745e-12,
  1.092701541023233e-13, -2.187824268809308e-15,  4.062052761694155e-17, -7.049815380150944e-19,  1.386286559803432e-02, -1.943291478138950e-03,  1.447391962290335e-04,
 -7.553592350546053e-06,  3.089238657855748e-07, -1.051627517750565e-08,  3.093476746716159e-10, -8.065430314568444e-12,  1.898152208666743e-13, -4.088001093788852e-15,
  8.143087305638704e-17, -1.512595738313165e-18,  1.158594670193220e-02, -1.799270395085030e-03,  1.476055473707116e-04, -8.437692424747167e-06,  3.761756474512637e-07,
 -1.390143350571698e-08,  4.422953967960141e-10, -1.243219405251925e-11,  3.145120715465480e-13, -7.261969198391076e-15,  1.547109562651684e-16, -3.066646306508642e-18,
  9.627115157826372e-03, -1.644175108576931e-03,  1.476662072500847e-04, -9.197631168898332e-06,  4.449217814466948e-07, -1.777351049700530e-08,  6.092648708270517e-10,
 -1.839626275243125e-11,  4.985845266611313e-13, -1.230299418989585e-14,  2.794832217698945e-16, -5.894644706259934e-18,  7.958810226847256e-03, -1.484747163677888e-03,
  1.451628529455326e-04, -9.803268713685110e-06,  5.122568453913445e-07, -2.203117983029748e-08,  8.106388582644870e-10, -2.620159208089036e-11,  7.582959539523296e-13,
 -1.993550376141987e-14,  4.814819947347944e-16, -1.077528621867642e-17,  6.550731121090008e-03, -1.326580571553569e-03,  1.404442791078378e-04, -1.023530430971471e-05,
  5.752855433411256e-07, -2.653410174108186e-08,  1.044205518929185e-09, -3.600821209505766e-11,  1.109277272467217e-12, -3.097741650652751e-14,  7.931779024375513e-16,
 -1.878391284175505e-17,  5.371821819583731e-03, -1.174042598285697e-03,  1.339232654160948e-04, -1.048570396011321e-05,  6.313685499086028e-07, -3.111356673100034e-08,
  1.305003853829564e-09, -4.785488599906817e-11,  1.564433018308565e-12, -4.627145851824410e-14,  1.252583455465617e-15, -3.130666289058220e-17,  4.391767642982039e-03,
 -1.030306852739489e-03,  1.260365146765630e-04, -1.055696256990810e-05,  6.783231326370029e-07, -3.558632700110204e-08,  1.585486549146818e-09, -6.163118137959744e-11,
  2.131685307084126e-12, -6.658795921324275e-14,  1.900553308147878e-15, -5.000315976555643e-17,  3.582040938548160e-03, -8.974645386514557e-04,  1.172111173797291e-04,
 -1.046049014567806e-05,  7.145583856951783e-07, -3.976960180641226e-08,  1.875984570359510e-09, -7.706413656618791e-11,  2.811890225297765e-12, -9.250819071315868e-14,
  2.776530604476019e-15, -7.670109008785674e-17,  2.916558301817584e-03, -7.766819687836152e-04,  1.078393253545845e-04, -1.021446819748530e-05,  7.391373957801675e-07,
 -4.349523865564155e-08,  2.165408544873592e-09, -9.372241638027041e-11,  3.597271503822427e-12, -1.243030591545611e-13,  3.913007570670634e-15, -1.132152803675879e-16,
  2.372023060491412e-03, -6.683776025567323e-04,  9.826197750200810e-05, -9.841513864821758e-06,  7.517701075778600e-07, -4.662136110906804e-08,  2.442087947399133e-09,
 -1.110379980726494e-10,  4.470656251563292e-12, -1.618253148198052e-13,  5.329296208526545e-15, -1.610979908114273e-16,  1.928027634037992e-03, -5.723983440639020e-04,
  8.875985697605768e-05, -9.366433987087650e-06,  7.527492190286237e-07, -4.904041148240375e-08,  2.694635767011675e-09, -1.283426541992653e-10,  5.405679337439335e-12,
 -2.044333973436391e-13,  7.025462052748910e-15, -2.213434885370716e-16,  1.566984307072740e-03, -4.881813787901372e-04,  7.955160702055840e-05, -8.814271066862919e-06,
  7.428462894179130e-07, -5.068315433789838e-08,  2.912733686154537e-09, -1.449143763472914e-10,  6.367973199947663e-12, -2.509614001643694e-13,  8.977389325538166e-15,
 -2.940847771394640e-16,  1.273942957034583e-03, -4.148936188944583e-04,  7.079655061580691e-05, -8.208757434227148e-06,  7.231864787112057e-07, -5.151881065486783e-08,
  3.087756370414111e-09, -1.600277731452050e-10,  7.317211084355140e-12, -2.997431487173895e-13,  1.113388038642093e-14, -3.783297595507603e-16,  1.036342744740910e-03,
 -3.515454472836731e-04,  6.260076305569403e-05, -7.571217362866466e-06,  6.951186879965964e-07, -5.155195043585501e-08,  3.213186227968171e-09, -1.730024696621203e-10,
  8.209753737368971e-12, -3.486904307479950e-13,  1.341645099796834e-14, -4.717852339630200e-16,  8.437333861963736e-04, -2.970787869717582e-04,  5.502493912312696e-05,
 -6.919897748254468e-06,  6.600943769416117e-07, -5.081704089802013e-08,  3.284804494339900e-09, -1.832444785446844e-10,  9.001582263329213e-12, -3.954176471472355e-13,
  1.572211265142116e-14, -5.708089960694999e-16,  6.874914046044028e-04, -2.504316679352176e-04,  4.809288763513110e-05, -6.269669043431400e-06,  6.195640440862518e-07,
 -4.937163139760963e-08,  3.300674566924650e-09, -1.902770863802972e-10,  9.651189708839490e-12, -4.373990446526411e-13,  1.792900928029415e-14, -6.705141600971423e-16,
  5.605482225969225e-04, -2.105826253073831e-04,  4.179980465885266e-05, -5.632018185932238e-06,  5.748961299057308e-07, -4.728908981948213e-08,  3.260955255301714e-09,
 -1.937596212669322e-10,  1.012214489905853e-11, -4.721412143373813e-13,  1.990438085972471e-14, -7.650286699865420e-16,  4.571402322985595e-04, -1.765786866520494e-04,
  3.611977417874585e-05, -5.015250563599282e-06,  5.273195186457453e-07, -4.465163903590599e-08,  3.167593590119809e-09, -1.934941921571836e-10,  1.038511901814539e-11,
 -4.973529968644063e-13,  2.151403027981559e-14, -8.478909015378762e-16,  3.725859720529973e-04, -1.475506294487567e-04,  3.101219407821681e-05, -4.424824060774186e-06,
  4.778881626267464e-07, -4.154422835079709e-08,  3.023949671843959e-09, -1.894218661050436e-10,  1.041925936042626e-11, -5.110970089706303e-13,  2.263231456561595e-14,
 -9.125432676269540e-16,  3.030920106676148e-04, -1.227188136469752e-04,  2.642701543186665e-05, -3.863750459428058e-06,  4.274646847359400e-07, -3.804955735906128e-08,
  2.834401716534932e-09, -1.816106458960800e-10,  1.021288733148555e-11, -5.119109354716237e-13,  2.315167613491555e-14, -9.528728937363193e-16,  2.455868094625937e-04,
 -1.013923720709947e-04,  2.230881531026435e-05, -3.333014286329751e-06,  3.767190228612961e-07, -3.424437889066802e-08,  2.603970526669285e-09, -1.702380104626893e-10,
  9.763575116693483e-12, -4.988915599141812e-13,  2.299085403866361e-14, -9.637432939771633e-16,  1.975804168276658e-04, -8.296398097224674e-05,  1.859980535840184e-05,
 -2.831973973955459e-06,  3.261380709634063e-07, -3.019706031986151e-08,  2.337991586993865e-09, -1.555707508583330e-10,  9.077709258053621e-12, -4.717393136506740e-13,
  2.210112894998871e-14, -9.414635126188432e-16,  1.570470974622811e-04, -6.690190176266240e-05,  1.524192108929581e-05, -2.358723333244739e-06,  2.760426296189024e-07,
 -2.596628343291764e-08,  2.041851905475823e-09, -1.379444899392087e-10,  8.169677310148733e-12, -4.307651927330333e-13,  2.047021135148166e-14, -8.841500564394538e-16,
  1.223277019171983e-04, -5.274052043513874e-05,  1.217815143177059e-05, -1.910402083991778e-06,  2.266086102011463e-07, -2.160070917088312e-08,  1.720799013285422e-09,
 -1.177447440124378e-10,  7.060818159083878e-12, -3.768648055991791e-13,  1.812363588673853e-14, -7.919500077544550e-16,  9.204858954817762e-05, -4.007023338145298e-05,
  9.353265723490520e-06, -1.483452593506570e-06,  1.778902075594145e-07, -1.713941894719182e-08,  1.379822138796029e-09, -9.539079855758993e-11,  5.778263501972624e-12,
 -3.114659851182825e-13,  1.512374512110075e-14, -6.671087312581786e-16,  6.505418883327567e-05, -2.852727403623811e-05,  6.714092623883763e-06, -1.073827644687343e-06,
  1.298437231549554e-07, -1.261297521871911e-08,  1.023602027558961e-09, -7.132321176263738e-11,  4.353779693496954e-12, -2.364572566370804e-13,  1.156653015395832e-14,
 -5.138812111641669e-16,  4.035157225366051e-05, -1.778431120516242e-05,  4.209597316740792e-06, -6.771757892157207e-07,  8.235357036847810e-08, -8.045182702666093e-09,
  6.565401063696262e-10, -4.599647866279075e-11,  2.822763117574395e-12, -1.541081190887139e-13,  7.576904606197154e-15, -3.383081966043843e-16,  1.708778856605662e-05,
 -7.552261029948155e-06,  1.793307954261654e-06, -2.894085720484929e-07,  3.530838405162245e-08, -3.460158777931921e-09,  2.832442986103224e-10, -1.990387627786294e-11,
  1.225105271338957e-12, -6.707845232761003e-14,  3.307354183022508e-15, -1.480820341188796e-16,  6.814792959534219e-02, -1.942137790302589e-04,  5.782042763571685e-07,
 -1.781290398667248e-09,  5.620992786014260e-12, -1.800930853335973e-14,  5.819063723087209e-17, -1.887362638080451e-19,  6.125771344899435e-22, -1.985881341953520e-24,
  6.423032046061033e-27, -2.071390069494786e-29,  6.698033847338530e-02, -2.618309109613969e-04,  1.198946067252017e-06, -5.588473524345832e-09,  2.548895434199760e-11,
 -1.131889004518309e-13,  4.907120059668711e-16, -2.084255105561409e-18,  8.698704623452131e-21, -3.575451966061307e-23,  1.449940889982052e-25, -5.809215263523941e-28,
  6.470915576097271e-02, -3.898308579368001e-04,  2.587615083875169e-06, -1.603687570488346e-08,  9.335019508425723e-11, -5.179112570297208e-13,  2.766020809646077e-15,
 -1.431493022385370e-17,  7.212709408181691e-20, -3.550713644637541e-22,  1.712519301203821e-24, -8.109701818376494e-27,  6.145622564900954e-02, -5.647510598063446e-04,
  4.991229189709068e-06, -3.900805162943615e-08,  2.798737182276828e-10, -1.884459445665965e-12,  1.206568930698318e-14, -7.411326495241994e-17,  4.395177638551739e-19,
 -2.528511425548703e-21,  1.416340585297830e-23, -7.747299646477107e-26,  5.738979170170135e-02, -7.687315426169955e-04,  8.674959562203477e-06, -8.356092960442328e-08,
  7.245196540355261e-10, -5.809796029365799e-12,  4.379995170487511e-14, -3.139000044904563e-16,  2.155494383482623e-18, -1.426601466086325e-20,  9.141893911115293e-23,
 -5.692449842433209e-25,  5.270932834488099e-02, -9.818486738540839e-04,  1.382830143645317e-05, -1.615361772237382e-07,  1.667220477282858e-09, -1.569906768704678e-11,
  1.375359721595559e-13, -1.135824438965983e-15,  8.924948734182521e-18, -6.719082646849875e-20,  4.872379606378715e-22, -3.417530663483616e-24,  4.762863369794831e-02,
 -1.184560005088091e-03,  2.048396182465924e-05, -2.862823099615551e-07,  3.474359443052010e-09, -3.799062011797283e-11,  3.827793577236221e-13, -3.607349100150578e-15,
  3.213686672429455e-17, -2.727819477734774e-19,  2.219495380693197e-21, -1.739294388699426e-23,  4.235924205409419e-02, -1.359879909038856e-03,  2.847008998997143e-05,
 -4.704472690234334e-07,  6.644398808687118e-09, -8.358504064187734e-11,  9.602718089166238e-13, -1.024423382584719e-14,  1.026844181654254e-16, -9.755902499398014e-19,
  8.844760727628589e-21, -7.691932297093469e-23,  3.709596055086651e-02, -1.494989484586610e-03,  3.740696900231700e-05, -7.231621598663621e-07,  1.177919262463935e-08,
 -1.691010470821192e-10,  2.198786926740361e-12, -2.636999203245977e-14,  2.954690732670432e-16, -3.122714480226948e-18,  3.135838453192485e-20, -3.009224319180913e-22,
  3.200583360522145e-02, -1.582114704978324e-03,  4.674761836729849e-05, -1.047253483957233e-06,  1.951372892459323e-08, -3.173924035552760e-10,  4.640310613849510e-12,
 -6.218172324521633e-14,  7.743707559733574e-16, -9.054467154125130e-18,  1.001914381364071e-19, -1.055641711751198e-21,  2.722120985674990e-02, -1.618650728439424e-03,
  5.585134984887053e-05, -1.437227820924410e-06,  3.040894421701461e-08, -5.567175602544973e-10,  9.097285793974198e-12, -1.354638152433132e-13,  1.865313130468942e-15,
 -2.401260294110237e-17,  2.914296489952210e-19, -3.356365505314095e-21,  2.283695665540438e-02, -1.606636038811551e-03,  6.407281036018582e-05, -1.878632849820090e-06,
  4.482567140083472e-08, -9.181443953762484e-10,  1.667765385365455e-11, -2.745664744628744e-13,  4.160709451019968e-15, -5.870747016179563e-17,  7.781711865761200e-19,
 -9.756640227951642e-21,  1.891134265722622e-02, -1.551765260834869e-03,  7.084760122783537e-05, -2.349060986303214e-06,  6.280764834803994e-08, -1.431198159812352e-09,
  2.875125635558955e-11, -5.208731575136796e-13,  8.648523618564753e-15, -1.332035111843311e-16,  1.920813855787546e-18, -2.612019730406823e-20,  1.546975640852791e-02,
 -1.462164812637307e-03,  7.575876007784311e-05, -2.820645293421484e-06,  8.400361905769598e-08, -2.118314149254735e-09,  4.683839406590032e-11, -9.296671388244698e-13,
  1.684403067209421e-14, -2.820925304272978e-16,  4.409208765447904e-18, -6.480405434107911e-20,  1.251026900177577e-02, -1.347144459237897e-03,  7.857462902669631e-05,
 -3.263537534578577e-06,  1.076514819019679e-07, -2.989150882661633e-09,  7.241845593581029e-11, -1.568256899589123e-12,  3.088592931326020e-14, -5.603966124048842e-16,
  9.461616774154799e-18, -1.498056806027184e-19,  1.001006331477529e-02, -1.216092906585067e-03,  7.925582150268689e-05, -3.649657831393083e-06,  1.326331844643229e-07,
 -4.036062501364401e-09,  1.066797152288358e-10, -2.510570755904360e-12,  5.354745529563430e-14, -1.048956009194348e-15,  1.906789133584184e-17, -3.242117677398072e-19,
  7.931895831085113e-03, -1.077623485156097e-03,  7.793525153143987e-05, -3.956003326860370e-06,  1.575921801380398e-07, -5.231906684940684e-09,  1.502533805173065e-10,
 -3.828188601208504e-12,  8.811496226877755e-14, -1.857421508618375e-15,  3.623824261759126e-17, -6.597151401991930e-19,  6.229973618248586e-03, -9.390126177453163e-04,
  7.487928512659312e-05, -4.166972646593896e-06,  1.810909690838171e-07, -6.530891875648564e-09,  2.029877569667369e-10, -5.578775530239492e-12,  1.381056665800034e-13,
 -3.122684063058651e-15,  6.519028087776274e-17, -1.267021380677384e-18,  4.854865720191203e-03, -8.059209489839856e-04,  7.043962222588104e-05, -4.275431935359103e-06,
  2.017784960191846e-07, -7.872484495124758e-09,  2.638164504697126e-10, -7.793816361424270e-12,  2.068315381860332e-13, -5.000911625420941e-15,  1.113864467894758e-16,
 -2.304806548477439e-18,  3.757284153726378e-03, -6.823510330780947e-04,  6.500483686522038e-05, -4.282531327073508e-06,  2.185374450602670e-07, -9.187710419381329e-09,
  3.307573991579676e-10, -1.046809306966289e-11,  2.968593975962983e-13, -7.652434325033334e-15,  1.813336277911856e-16, -3.983870258311336e-18,  2.890740039467812e-03,
 -5.707774485805002e-04,  5.895833871288298e-05, -4.196507119825722e-06,  2.305886430110629e-07, -1.040669133131466e-08,  4.010518425381635e-10, -1.355327542609681e-11,
  4.094551447155630e-13, -1.122036944956068e-14,  2.820852768137389e-16, -6.562734572559248e-18,  2.213195667122125e-03, -4.723824890177525e-04,  5.264673283279131e-05,
 -4.030835226035449e-06,  2.375409618247422e-07, -1.146607433873678e-08,  4.714222329098914e-10, -1.695728414730342e-11,  5.441196051646972e-13, -1.580569080387220e-14,
  4.204434442750057e-16, -1.033159438003989e-17,  1.687895908175057e-03, -3.873385567467383e-04,  4.635988090235289e-05, -3.802130160715939e-06,  2.393868597522665e-07,
 -1.231515474349317e-08,  5.384040068956811e-10, -2.054992275119844e-11,  6.983166766144313e-13, -2.144286893300582e-14,  6.019324961717538e-16, -1.558338782046289e-17,
  1.283582070941781e-03, -3.150921031175444e-04,  4.032188155324569e-05, -3.528131336476133e-06,  2.364531644657741e-07, -1.291987607860940e-08,  5.986939980174547e-10,
 -2.417398693761218e-11,  8.674615518882671e-13, -2.808074744388307e-14,  8.296878665096995e-16, -2.257357011141647e-17,  9.742807686218760e-04, -2.546192037628668e-04,
  3.469088552763568e-05, -3.226018140538198e-06,  2.293222725356168e-07, -1.326438599815173e-08,  6.494598955958954e-10, -2.765999751057380e-11,  1.045186354892723e-12,
 -3.557273537807072e-14,  1.103449661887589e-15, -3.147327785266949e-17,  7.388321128058553e-04, -2.046367132651901e-04,  2.956511326101218e-05, -2.911181165101352e-06,
  2.187403662786233e-07, -1.335029666683102e-08,  6.885682982232020e-10, -3.084211897625335e-11,  1.223846260108037e-12, -4.367879191595574e-14,  1.418855796363441e-15,
 -4.232307820987996e-17,  5.602858288924279e-04, -1.637638336686502e-04,  2.499248170555746e-05, -2.596475236311665e-06,  2.055273200936219e-07, -1.319414538633648e-08,
  7.147086641577825e-10, -3.357281303834803e-11,  1.395185115807709e-12, -5.207947254478903e-14,  1.767188124056888e-15, -5.499560037872536e-17,  4.252580210392312e-04,
 -1.306363876669785e-04,  2.098165664148033e-05, -2.291905458792798e-06,  1.904990037282004e-07, -1.282373030806273e-08,  7.274111941721424e-10, -3.573426106675920e-11,
  1.551055695453358e-12, -6.040007130725102e-14,  2.135647078150625e-15, -6.917460685982656e-17,  3.233096893608393e-04, -1.039803849723067e-04,  1.751292292454131e-05,
 -2.004654613932377e-06,  1.744080511186220e-07, -1.227401292683930e-08,  7.269737456648363e-10, -3.724538423858378e-11,  1.684089340844867e-12, -6.824117692098340e-14,
  2.508135421613571e-15, -8.435557243945351e-17,  2.463827442660423e-04, -8.265327212496537e-05,  1.454785350181938e-05, -1.739345467897652e-06,  1.579049191368438e-07,
 -1.158317394528644e-08,  7.143235876670150e-10, -3.806416682909764e-11,  1.788229802341837e-12, -7.521111539561335e-14,  2.866443408687230e-15, -9.986919333572613e-17,
  1.883105244200336e-04, -6.566133427255997e-05,  1.203726314644061e-05, -1.498437336994245e-06,  1.415178433410219e-07, -1.078923664149564e-08,  6.908436055735852e-10,
 -3.818574920456212e-11,  1.859078930167486e-12, -8.095586536912562e-14,  3.191665878197815e-15, -1.149253400759760e-16,  1.444070562998993e-04, -5.216077710162665e-05,
  9.927311978069158e-06, -1.282674155981112e-06,  1.256483200203416e-07, -9.927483630187853e-09,  6.581905484805829e-10, -3.763727756725221e-11,  1.894038403292418e-12,
 -8.518294435046748e-14,  3.465657598087995e-15, -1.286717005898177e-16,  1.111313748371325e-04, -4.144860924850591e-05,  8.163872534411684e-06, -1.091523952038807e-06,
  1.105779069574139e-07, -9.028726835941494e-09,  6.181270754375230e-10, -3.647073688863957e-11,  1.892263926876049e-12, -8.767715539349127e-14,  3.672346982047851e-15,
 -1.402593946426037e-16,  8.581893078563284e-05, -3.294794753339350e-05,  6.695410672167941e-06, -9.235717822794857e-07,  9.648216816730350e-08, -8.118367453214433e-09,
  5.723818543810447e-10, -3.475498125579960e-11,  1.854471139546375e-12, -8.830759136831242e-14,  3.798771612096695e-15, -1.489074438372467e-16,  6.647032386722818e-05,
 -2.619100227094904e-05,  5.474682728033265e-06, -7.768467923769403e-07,  8.344816775331340e-08, -7.216108214486515e-09,  5.225445885178411e-10, -3.256798389450050e-11,
  1.782643991266155e-12, -8.702660977236911e-14,  3.835758293802322e-15, -1.539590181212244e-16,  5.158741055508174e-05, -2.080187286114856e-05,  4.459547630983756e-06,
 -6.490778740672651e-07,  7.149275361567190e-08, -6.336149267941809e-09,  4.699967613124346e-10, -2.999004247005844e-11,  1.679697502279060e-12, -8.386242029677018e-14,
  3.778231442461006e-15, -1.549244195477977e-16,  4.004755941547498e-05, -1.648042093292646e-05,  3.613157181589757e-06, -5.378814750499328e-07,  6.057974470389603e-08,
 -5.487700622508673e-09,  4.158746385132474e-10, -2.709836978573766e-11,  1.549140256190548e-12, -7.890740239356391e-14,  3.625185043003156e-15, -1.515082440500147e-16,
  3.100799116958459e-05, -1.298786959068303e-05,  2.903738455118885e-06, -4.408901855984334e-07,  5.063490964242563e-08, -4.675666334755038e-09,  3.610586719175780e-10,
 -2.396323003396579e-11,  1.394771007312717e-12, -7.230432836915483e-14,  3.379388470998217e-15, -1.436205464620707e-16,  2.383343959493679e-05, -1.013436133170733e-05,
  2.304131065476988e-06, -3.558328031175102e-07,  4.155823515199690e-08, -3.901387692591851e-09,  3.061826229887077e-10, -2.064557603253826e-11,  1.220431437592020e-12,
 -6.423241216235194e-14,  3.046913167056566e-15, -1.313737273008150e-16,  1.804162322363588e-05, -7.768446904077802e-06,  1.791195625763085e-06, -2.805766626503715e-07,
  3.323341733692664e-08, -3.163366683601547e-09,  2.516560346334038e-10, -1.719601204333908e-11,  1.029825675081934e-12, -5.489466273829324e-14,  2.636567461930301e-15,
 -1.150680568535624e-16,  1.326213467124030e-05, -5.768329576131932e-06,  1.345171393379606e-06, -2.131419840557974e-07,  2.553478958174957e-08, -2.457922353334768e-09,
  1.976947095470463e-10, -1.365484509270355e-11,  8.264081402893454e-13, -4.450751804250558e-14,  2.159315253197039e-15, -9.516923995571998e-17,  9.205307776504499e-06,
 -4.034622424138919e-06,  9.490326571263880e-07, -1.516966430131784e-07,  1.833208436692648e-08, -1.779761101615104e-09,  1.443554174319214e-10, -1.005299359464983e-11,
  6.133359222681503e-13, -3.329330463355962e-14,  1.627737891222161e-15, -7.228141009077829e-17,  5.638524627387384e-06, -2.484413957159867e-06,  5.878865623952023e-07,
 -9.454053523466258e-08,  1.149379253544365e-08, -1.122490757936045e-09,  9.157483113884064e-11, -6.413715402555815e-12,  3.934885202352291e-13, -2.147622744027404e-14,
  1.055604986601849e-15, -4.711963308765696e-17,  2.371071893320139e-06, -1.047790932941236e-06,  2.487611997379816e-07, -4.013909844251875e-08,  4.896237268415634e-09,
 -4.797439599167358e-10,  3.926487787872525e-11, -2.758742348350401e-12,  1.697767269801891e-13, -9.294369620274063e-15,  4.581953350359398e-16, -2.051192748915734e-17,
  6.738019249255348e-02, -1.896721447384191e-04,  5.573567617189535e-07, -1.694161880611745e-09,  5.274355488275767e-12, -1.667399787421404e-14,  5.317005227881961e-17,
 -1.702298053563018e-19,  5.454986204738854e-22, -1.746285865107687e-24,  5.578182108947247e-27, -1.776877241078468e-29,  6.595178280867524e-02, -2.525008241430485e-04,
  1.134258639784091e-06, -5.198139881544157e-09,  2.333837778010245e-11, -1.020818180299824e-13,  4.360640793987081e-16, -1.825419923289541e-18,  7.510061757384712e-21,
 -3.043505188566877e-23,  1.217071746838208e-25, -4.809148168480510e-28,  6.319005020531079e-02, -3.698750804959876e-04,  2.403803695001635e-06, -1.462266322611278e-08,
  8.362464813432563e-11, -4.560871177169867e-13,  2.395684421324129e-15, -1.219883095937288e-17,  6.049617490834455e-20, -2.932041079801434e-22,  1.392588312234119e-24,
 -6.495616550180578e-27,  5.927422028457471e-02, -5.266202526637523e-04,  4.548805808065232e-06, -3.481652999529070e-08,  2.449200763799372e-10, -1.618276021134047e-12,
  1.017448013276044e-14, -6.140211045096019e-17,  3.579179935399504e-19, -2.024673636380290e-21,  1.115532406538103e-23, -6.003631856452675e-26,  5.444758127629206e-02,
 -7.031541954982804e-04,  7.738124998974436e-06, -7.284392130659316e-08,  6.181621529300095e-10, -4.856723795960824e-12,  3.590396704275860e-14, -2.524818744383136e-16,
  1.702120961578230e-18, -1.106496191173580e-20,  6.967221573907519e-23, -4.264333550971730e-25,  4.899151987973321e-02, -8.785452636985112e-04,  1.204011183560568e-05,
 -1.372034132950088e-07,  1.383829479408466e-09, -1.274967624224816e-11,  1.093928340020476e-13, -8.854420907506059e-16,  6.823444501460823e-18, -5.040673791859417e-20,
  3.588403717260485e-22, -2.471905239068300e-24,  4.319764151884550e-02, -1.033539500828945e-03,  1.735856661890838e-05, -2.363042755479343e-07,  2.798796805084478e-09,
 -2.990827425082506e-11,  2.948086116931906e-13, -2.720349725895658e-15,  2.374602755683246e-17, -1.976125804397773e-19,  1.577215899007701e-21, -1.212965705341229e-23,
  3.734188349839490e-02, -1.153012753821387e-03,  2.341122385583165e-05, -3.763495378860928e-07,  5.181718954141380e-09, -6.363943815536729e-11,  7.146069753864903e-13,
 -7.458103390410813e-15,  7.319198736344044e-17, -6.812745764353637e-19,  6.054597862995173e-21, -5.164164777775093e-23,  3.166376015745462e-02, -1.227481153973886e-03,
  2.975686415655240e-05, -5.591170976517228e-07,  8.870183914186770e-09, -1.242178813877394e-10,  1.577483885589469e-12, -1.849530833388748e-14,  2.027638721258031e-16,
 -2.098187420119728e-18,  2.064271626929687e-20, -1.941813062699715e-22,  2.635264879861437e-02, -1.253540061713568e-03,  3.586251212204032e-05, -7.803108357239684e-07,
  1.415181452059642e-08, -2.243935115766664e-10,  3.202167066024874e-12, -4.192633767202753e-14,  5.105932654074172e-16, -5.842705904732431e-18,  6.331256387591753e-20,
 -6.536379312299644e-22,  2.154165042600969e-02, -1.233330713691022e-03,  4.119161559463623e-05, -1.029074420872317e-06,  2.118245058797599e-08, -3.778785064164096e-10,
  6.024511623699845e-12, -8.761563109905102e-14,  1.179356984512096e-15, -1.485262818921183e-17,  1.764669783978851e-19, -1.990809281738139e-21,  1.730833784047301e-02,
 -1.173301595127728e-03,  4.529041068667568e-05, -1.288943797957662e-06,  2.991289223423360e-08, -5.968470893489244e-10,  1.057447585308458e-11, -1.699823744315616e-13,
  2.517389351054291e-15, -3.474132461474926e-17,  4.507147129303211e-19, -5.534448879151476e-21,  1.368084393662866e-02, -1.082610054352612e-03,  4.785294951895020e-05,
 -1.540086702451427e-06,  4.004723313209667e-08, -8.888598784357499e-10,  1.741442526059116e-11, -3.080088363799454e-13,  4.997451823626244e-15, -7.527405061870718e-17,
  1.062298449520900e-18, -1.414650998379464e-20,  1.064733169621324e-02, -9.714996173512760e-04,  4.875333736789448e-05, -1.762304243817818e-06,  5.104905266968395e-08,
 -1.253944637826773e-09,  2.704092115188355e-11, -5.240019385072427e-13,  9.277523418697113e-15, -1.519519362082729e-16,  2.324419624083641e-18, -3.345634375517855e-20,
  8.166895585682494e-03, -8.499127245899351e-04,  4.804334667232118e-05, -1.938080195953618e-06,  6.219875529940793e-08, -1.682675819360557e-09,  3.976573940119986e-11,
 -8.408695395978813e-13,  1.618499995703703e-14, -2.872322808631589e-16,  4.746772159973552e-18, -7.361062315514522e-20,  6.180262704802288e-03, -7.264906282825029e-04,
  4.592172767843496e-05, -2.055003750385320e-06,  7.269087565675545e-08, -2.155920944639361e-09,  5.560316233261884e-11, -1.278096310216238e-12,  2.664915319162392e-14,
 -5.107337083591309e-16,  9.089467217434722e-18, -1.514067414869118e-19,  4.619148016319853e-03, -6.080042414451177e-04,  4.268634559345650e-05, -2.107118195909286e-06,
  8.174939302635323e-08, -2.646504546371352e-09,  7.419444735601098e-11, -1.847094596134399e-12,  4.157787471219816e-14, -8.577695115950205e-16,  1.638983072933229e-17,
 -2.924079892298051e-19,  3.413636185834155e-03, -4.991748430752094e-04,  3.868130813103316e-05, -2.095061992826929e-06,  8.873543627566994e-08, -3.122523508013555e-09,
  9.479421979280179e-11, -2.546976312513998e-12,  6.169152519212779e-14, -1.365809012826839e-15,  2.793728003805977e-17, -5.323495356622335e-19,  2.497413175960373e-03,
 -4.027923690238414e-04,  3.424924786449801e-05, -2.025161687939973e-06,  9.322568979229268e-08, -3.551611880879024e-09,  1.163287634565670e-10, -3.361874310154268e-12,
  8.734379583515386e-14, -2.068977422605286e-15,  4.517638834618629e-17, -9.169610238749812e-19,  1.810999466420033e-03, -3.200211158695115e-04,  2.969524404082855e-05,
 -1.907830258422282e-06,  9.504911882546434e-08, -3.905239195749245e-09,  1.375176719244637e-10, -4.260667757345828e-12,  1.183702228537910e-13, -2.991341015468834e-15,
  6.953268057496316e-17, -1.499393282284533e-18,  1.303330843305313e-03, -2.507903641945212e-04,  2.526489074387345e-05, -1.755690727617780e-06,  9.428070206421297e-08,
 -4.162182512468251e-09,  1.570343198320786e-10, -5.199405728977818e-12,  1.540043476700491e-13, -4.140270188400453e-15,  1.021770934468698e-16, -2.334825811889171e-18,
  9.321087489472796e-04, -1.941901527823398e-04,  2.113575494193190e-05, -1.581799015065455e-06,  9.120023221511698e-08, -4.310589315110252e-09,  1.736721230070320e-10,
 -6.126057268189574e-12,  1.928884909221508e-13, -5.501409241475246e-15,  1.437670481778494e-16, -3.472511675652869e-18,  6.633319576527429e-04, -1.488203520773787e-04,
  1.741941096744068e-05, -1.398224547802896e-06,  8.622975616721383e-08, -4.348432206426644e-09,  1.864845325542867e-10, -6.986660338094652e-12,  2.331843798902855e-13,
 -7.036584448302832e-15,  1.942168109464508e-16, -4.946314133763056e-18,  4.703595804120922e-04, -1.130671265546717e-04,  1.417041415980172e-05, -1.215110510883869e-06,
  7.986437661872241e-08, -4.282521579310836e-09,  1.948757304450931e-10, -7.731660623562309e-12,  2.727652990175199e-13, -8.685381851911887e-15,  2.525510212175321e-16,
 -6.765444139848484e-18,  3.327718974843267e-04, -8.530090757316808e-05,  1.139871374625370e-05, -1.040216012275859e-06,  7.260878852872987e-08, -4.126496148163078e-09,
  1.986323219060294e-10, -8.321281203700824e-12,  3.094532800480661e-13, -1.037030037878362e-14,  3.168811899106110e-16, -8.907370961379759e-18,  2.352115058382813e-04,
 -6.400296089630990e-05,  9.082716580283855e-06, -8.788608856028224e-07,  6.492763232319101e-08, -3.898314966687639e-09,  1.978996096817585e-10, -8.729089998053552e-12,
  3.412570361218967e-13, -1.200458674162737e-14,  3.845192308019004e-16, -1.131461815970618e-17,  1.663151148377891e-04, -4.783421981874848e-05,  7.181137705303119e-06,
 -7.341546892747723e-07,  5.721308866844934e-08, -3.617741468608870e-09,  1.931158882885282e-10, -8.943403131806224e-12,  3.665699792151962e-13, -1.350131611414726e-14,
  4.522123042285527e-16, -1.389641897005960e-17,  1.177911443568691e-04, -3.566186468917852e-05,  5.642650367658485e-06, -6.073875014465237e-07,  4.976926660315460e-08,
 -3.304185845623407e-09,  1.849229880273859e-10, -8.966631234683090e-12,  3.843002197442522e-13, -1.478212490843505e-14,  5.164580691160252e-16, -1.653519578309227e-17,
  8.366026523122928e-05, -2.655793809099609e-05,  4.413034909430918e-06, -4.984789705642857e-07,  4.281041069467000e-08, -2.975111735257815e-09,  1.740711871596614e-10,
 -8.813027439999471e-12,  3.939212519421119e-13, -1.578422550030790e-14,  5.738454213711980e-16, -1.909683737116636e-17,  5.965264638255374e-05, -1.978160950753277e-05,
  3.439979637490491e-06, -4.064112928285504e-07,  3.646881943437187e-08, -2.645062812004877e-09,  1.613329715789764e-10, -8.505475056852078e-12,  3.954481557773485e-13,
 -1.646482447723159e-14,  6.213654620565708e-16, -2.144304069091562e-17,  4.274337978942060e-05, -1.475362720586361e-05,  2.675928405537565e-06, -3.296017785548292e-07,
  3.080834191791082e-08, -2.325252490535279e-09,  1.474347849301958e-10, -8.071963284307873e-12,  3.893559657760350e-13, -1.680265975649850e-14,  6.566490493594792e-16,
 -2.344371822630562e-17,  3.080282901272046e-05, -1.102866619932667e-05,  2.079451122677597e-06, -2.661957134904306e-07,  2.583998868990877e-08, -2.023594951148783e-09,
  1.330105236798058e-10, -7.542285360117372e-12,  3.764627481524106e-13, -1.679690958041507e-14,  6.781061420250297e-16, -2.498765940162635e-17,  2.233856047226486e-05,
 -8.269000570563147e-06,  1.615592475369591e-06, -2.142780230822405e-07,  2.153716179626997e-08, -1.745033589677072e-09,  1.185761915084615e-10, -6.945315648640442e-12,
  3.578001674254247e-13, -1.646410119191124e-14,  6.849625703713612e-16, -2.599016400131247e-17,  1.630789996536963e-05, -6.221264671601438e-06,  1.255580194148328e-06,
 -1.720128998070292e-07,  1.784898617253922e-08, -1.492031922378479e-09,  1.045223156693928e-10, -6.307035953218336e-12,  3.344904457230394e-13, -1.583381933743037e-14,
  6.772070701794244e-16, -2.639705771302663e-17,  1.198355759610216e-05, -4.696959206804465e-06,  9.761826516221460e-07, -1.377254280667572e-07,  1.471103877114735e-08,
 -1.265118435276656e-09,  9.111942374653823e-11, -5.649325393466170e-12,  3.076426193068797e-13, -1.494400345163973e-14,  6.554725338763272e-16, -2.618517322212157e-17,
  8.858305993968101e-06, -3.556688650697526e-06,  7.589180359795843e-07, -1.099401201226677e-07,  1.205335673000308e-08, -1.063409384537537e-09,  7.853176132157515e-11,
 -4.989421095347280e-12,  2.782746899277336e-13, -1.383648205009148e-14,  6.208797837105585e-16, -2.535989990968382e-17,  6.577916728796028e-06, -2.697761735632596e-06,
  5.892443974519933e-07, -8.738981249626877e-08,  9.805965767151324e-09, -8.850642800406501e-10,  6.683507041850240e-11, -4.339900535413107e-12,  2.472629155816587e-13,
 -1.255318895773994e-14,  5.748707623652923e-16, -2.395070548430068e-17,  4.894264877541566e-06, -2.044638999012352e-06,  4.558046802602682e-07, -6.900583846773061e-08,
  7.902346783483331e-09, -7.276535341425603e-10,  5.603524531176694e-11, -3.709021883193313e-12,  2.153157103831983e-13, -1.113329577257114e-14,  5.190527999159049e-16,
 -2.200561384178323e-17,  3.632667022070117e-06, -1.541687667398752e-06,  3.497623375753970e-07, -5.389763407327819e-08,  6.281306380137647e-09, -5.884352202062700e-10,
  4.608573629068167e-11, -3.101272864973334e-12,  1.829675174219427e-13, -9.611317374373176e-15,  4.550686541748243e-16, -1.958553087014170e-17,  2.669170658149355e-06,
 -1.147746325516367e-06,  2.642382600622067e-07, -4.132743011639803e-08,  4.887686118455524e-09, -4.645485830343536e-10,  3.690250054383750e-11, -2.518008452852359e-12,
  1.505873301649198e-13, -8.016121346938399e-15,  3.845000807601266e-16, -1.675911034163718e-17,  1.914743803787579e-06, -8.320723819764014e-07,  1.938450596354733e-07,
 -3.068364399248934e-08,  3.672275836619859e-09, -3.531373312279126e-10,  2.837602377263342e-11, -1.958092897285544e-12,  1.183968746251066e-13, -6.370701157458823e-15,
  3.088069417711211e-16, -1.359861249890926e-17,  1.304210374057709e-06, -5.713226710883461e-07,  1.343072220655816e-07, -2.145507867596986e-08,  2.591218486220574e-09,
 -2.514177759830462e-10,  2.038047134100986e-11, -1.418497205456261e-12,  8.649451867581470e-14, -4.692554767850280e-15,  2.293001161915982e-16, -1.017699242349503e-17,
  7.884340963240406e-07, -3.472968554836861e-07,  8.215442824141788e-08, -1.320728621779948e-08,  1.605157602471052e-09, -1.567103421362308e-10,  1.278067398571106e-11,
 -8.948544935718125e-13,  5.488356849707797e-14, -2.994596033676638e-15,  1.471479047983658e-16, -6.566435964653000e-18,  3.291217956536947e-07, -1.454197769499467e-07,
  3.451910254214491e-08, -5.568917468581570e-09,  6.791909475221527e-10, -6.653738526959855e-11,  5.444876044492740e-12, -3.824928108357483e-13,  2.353529185290699e-14,
 -1.288224621823477e-15,  6.349703969067674e-17, -2.842114591836711e-18,  6.663029485797999e-02, -1.852932006921683e-04,  5.375223726860091e-07, -1.612372284539921e-09,
  4.953260215407058e-12, -1.545319789694466e-14,  4.863884860627853e-17, -1.537381294650261e-19,  4.864672207342123e-22, -1.538030021628922e-24,  4.852796041556182e-27,
 -1.527070079959662e-29,  6.495954135362449e-02, -2.436700692546986e-04,  1.074055867072890e-06, -4.840507202454333e-09,  2.139739291723811e-11, -9.220344463101519e-14,
  3.881585813302547e-16, -1.601728811380288e-18,  6.497161621336447e-21, -2.596470865178658e-23,  1.024051414573731e-25, -3.991448130928773e-28,  6.174793064279026e-02,
 -3.513244663837198e-04,  2.236068496275495e-06, -1.335463114078246e-08,  7.505129361403597e-11, -4.024801268065092e-13,  2.079706149911137e-15, -1.042162297431726e-17,
  5.087826816863017e-20, -2.428194491707220e-22,  1.135928054863981e-24, -5.219830857214962e-27,  5.723796502200598e-02, -4.918367577700321e-04,  4.153493147322279e-06,
 -3.114402751114289e-08,  2.148635849943126e-10, -1.393489768555659e-12,  8.605196092598111e-15, -5.103373903266882e-17,  2.924635064068794e-19, -1.627110698476850e-21,
  8.819756516208546e-24, -4.671140926843803e-26,  5.175346636678919e-02, -6.445846531647505e-04,  6.920281419716047e-06, -6.368588132012909e-08,  5.291023147788494e-10,
 -4.074057332760953e-12,  2.954077347164765e-14, -2.038842096277791e-16,  1.349732433732377e-18, -8.619978170938666e-21,  5.334378228658798e-23, -3.209907267611059e-25,
  4.566006011354267e-02, -7.884522240836027e-04,  1.051854378660927e-05, -1.169674476113739e-07,  1.153202797835832e-09, -1.039866590137485e-11,  8.740314103574359e-14,
 -6.935554442558660e-16,  5.242942460757506e-18, -3.801349044846461e-20,  2.657205979384266e-22, -1.798062065134042e-24,  3.932427925484928e-02, -9.052953859116534e-04,
  1.477303839780570e-05, -1.959488531297924e-07,  2.265633011315226e-09, -2.366720201236509e-11,  2.282886786048644e-13, -2.063097918919120e-15,  1.764971725645708e-17,
 -1.440353792059298e-19,  1.127913811931735e-21, -8.514524123333087e-24,  3.307767896494473e-02, -9.824693251548194e-04,  1.935330775189775e-05, -3.027590114415014e-07,
  4.064798282380215e-09, -4.875122583861703e-11,  5.351921947004885e-13, -5.465742214925926e-15,  5.252810591002937e-17, -4.791141866426813e-19,  4.174798409642504e-21,
 -3.493018419157476e-23,  2.719062551599525e-02, -1.014027441651066e-03,  2.382322494150275e-05, -4.351757023856929e-07,  6.725987631518056e-09, -9.190398214905359e-11,
  1.140144274373284e-12, -1.307139616342887e-14,  1.402390985001676e-16, -1.421160895702870e-18,  1.370093193572920e-20, -1.263600838031818e-22,  2.185800164276100e-02,
 -1.000561395529255e-03,  2.772176679299103e-05, -5.859773888058169e-07,  1.034615211568942e-08, -1.599606216899756e-10,  2.228538527168589e-12, -2.851520587382658e-14,
  3.396635306377015e-16, -3.804446194694760e-18,  4.037853832075395e-20, -4.085367412222157e-22,  1.719662014841651e-02, -9.479589203051609e-04,  3.065017825910354e-05,
 -7.435230664544847e-07,  1.489215891298584e-08, -2.589138070505719e-10,  4.028046133682619e-12, -5.722376658547579e-14,  7.530890330783043e-16, -9.279889286342930e-18,
  1.079527051622972e-19, -1.193142816606509e-21,  1.325221256179329e-02, -8.655363426903216e-04,  3.234141293469049e-05, -8.935120665661667e-07,  2.017086345292834e-08,
 -3.921129606780737e-10,  6.777035056067253e-12, -1.063840893406599e-13,  1.539952038979743e-15, -2.078874854600879e-17,  2.640037736264072e-19, -3.175270253653987e-21,
  1.001277073167138e-02, -7.640346450292943e-04,  3.269606060380174e-05, -1.021476682026775e-06,  2.583467881019476e-08, -5.585721463159878e-10,  1.067374804602389e-11,
 -1.843286032133380e-13,  2.922776271801282e-15, -4.305819686338949e-17,  5.947408944695414e-19, -7.756742679988854e-21,  7.424802491370518e-03, -6.538776071391798e-04,
  3.178070593547916e-05, -1.115333075934487e-06,  3.142559992539899e-08, -7.519574142652665e-10,  1.581580876161519e-11, -2.992357701794613e-13,  5.177478279358585e-15,
 -8.293649771525421e-17,  1.241701070624819e-18, -1.750355018874506e-20,  5.409536934609500e-03, -5.439323664553465e-04,  2.979528802517204e-05, -1.167336503129564e-06,
  3.644815593609903e-08, -9.606911950218547e-10,  2.214637137256144e-11, -4.572769064817374e-13,  8.602226116458471e-15, -1.493222761989748e-16,  2.415419688343445e-18,
 -3.668774830771689e-20,  3.876987697433476e-03, -4.408450522546286e-04,  2.702246474522594e-05, -1.175019630238371e-06,  4.045261513861763e-08, -1.169291497122527e-09,
  2.942483022999380e-11, -6.605978082521428e-13,  1.346475595306350e-14, -2.524596036157171e-16,  4.398705499697837e-18, -7.177996942728892e-20,  2.736756858488524e-03,
 -3.488908881795275e-04,  2.377332177058953e-05, -1.141023997877917e-06,  4.310735622848685e-08, -1.360679542741427e-09,  3.723485634804568e-11, -9.056941099042460e-13,
  1.993611154337522e-14, -4.025017015168195e-16,  7.531682472911905e-18, -1.316759682897207e-19,  1.905312044043532e-03, -2.702003465536735e-04,  2.034098838665986e-05,
 -1.072035149307822e-06,  4.424395251096520e-08, -1.518893085702905e-09,  4.503206216369055e-11, -1.182726852484169e-12,  2.802612232058286e-14, -6.074754167293315e-16,
  1.217357325191857e-17, -2.274050980038390e-19,  1.310072604692346e-03, -2.052002159891060e-04,  1.696880949226946e-05, -9.772114756592385e-07,  4.386768079954863e-08,
 -1.631542745936032e-09,  5.222173291028371e-11, -1.476107663028427e-12,  3.753912526518706e-14, -8.710332860797396e-16,  1.864240902893316e-17, -3.711248900398410e-19,
  8.909712600950534e-04, -1.531265831980747e-04,  1.383467868122244e-05, -8.665288597074675e-07,  4.213605907305172e-08, -1.691465446557909e-09,  5.824832739257289e-11,
 -1.766330376579260e-12,  4.806537559736448e-14, -1.190554474299020e-15,  2.714184649677345e-17, -5.743698393261227e-19,  6.002562822816311e-04, -1.125065958622771e-04,
  1.104933649075257e-05, -7.493770977333569e-07,  3.931532160235117e-08, -1.697296481072358e-09,  6.267588147074058e-11, -2.032667882641155e-12,  5.901477679132040e-14,
 -1.556161089587142e-15,  3.769109190590349e-17, -8.457608499385711e-19,  4.012386968438004e-04, -8.155041857258079e-05,  8.664421491108426e-06, -6.335981603832630e-07,
  3.572778968127092e-08, -1.652988790562972e-09,  6.524240504759928e-11, -2.256119764445634e-12,  6.968799178099597e-14, -1.951026845892427e-15,  5.007650841449787e-17,
 -1.188615132868607e-18,  2.665443321603434e-04, -5.843268099983484e-05,  6.685681248625598e-06, -5.250088967089956e-07,  3.170205695444339e-08, -1.566551027689270e-09,
  6.587972760197688e-11, -2.421961489404976e-12,  7.936983067627291e-14, -2.353026212562143e-15,  6.384015093868313e-17, -1.599028993812407e-18,  1.762620395997329e-04,
 -4.146884801471466e-05,  5.087477835846404e-06, -4.273410060263144e-07,  2.753419988754551e-08, -1.448396069092764e-09,  6.469967311837184e-11, -2.521401421189832e-12,
  8.742449900669714e-14, -2.737417659830320e-15,  7.831189392745377e-17, -2.064970070486794e-18,  1.162257877287328e-04, -2.920605129487613e-05,  3.825955074364783e-06,
 -3.424736352999862e-07,  2.346364871912405e-08, -1.309684605469265e-09,  6.195488232857362e-11, -2.552122816745390e-12,  9.337320256042820e-14, -3.079995701871446e-15,
  9.268078507190094e-17, -2.566705831086547e-18,  7.654831976297397e-05, -2.045250658132199e-05,  2.849491460704430e-06, -2.708236746522228e-07,  1.966338152974798e-08,
 -1.160950795611522e-09,  5.798633994391666e-11, -2.517772928314811e-12,  9.694073194107238e-14, -3.360061530253114e-15,  1.060914878711619e-16, -3.078574511520627e-18,
  5.044168679745670e-05, -1.426810648623059e-05,  2.106062103829412e-06, -2.117801171753580e-07,  1.624152409652104e-08, -1.011161288699700e-09,  5.316959210137275e-11,
 -2.426675289840671e-12,  9.806636769390983e-14, -3.562660089239938e-15,  1.177462398251696e-16, -3.571778205695012e-18,  3.331066798686396e-05, -9.934228143675476e-06,
  1.547777392968338e-06, -1.641043672807322e-07,  1.325037390599479e-08, -8.672316850708730e-10,  4.786881812269487e-11, -2.290141403281880e-12,  9.688278266953102e-14,
 -3.679758580497824e-15,  1.269929375381453e-16, -4.017648584946759e-18,  2.208073083688912e-05, -6.915471234501431e-06,  1.133182667912699e-06, -1.262545255808167e-07,
  1.069899680881411e-08, -7.339338957306462e-10,  4.240388506842172e-11, -2.120746931008567e-12,  9.367236825824651e-14, -3.710311511663434e-15,  1.333850199488281e-16,
 -4.390765231213553e-18,  1.471437071142350e-05, -4.821254775940798e-06,  8.279787807953412e-07, -9.662056818842649e-08,  8.566374258629661e-09, -6.140821155873540e-10,
  3.703163564350501e-11, -1.930849044975674e-12,  8.881268576819717e-14, -3.659388810998139e-15,  1.367065826171211e-16, -4.671397189088054e-18,  9.871427636082889e-06,
 -3.371510778794918e-06,  6.047555038259468e-07, -7.367625818336396e-08,  6.813146829498243e-09, -5.088778926704909e-10,  3.193979668716799e-11, -1.731500607156142e-12,
  8.272189022704966e-14, -3.536684988386078e-15,  1.369640445546007e-16, -4.846941707778222e-18,  6.675306029037889e-06, -2.368192939999096e-06,  4.421985142311571e-07,
 -5.606331041639654e-08,  5.390985172611967e-09, -4.183127384085824e-10,  2.725033259275364e-11, -1.531802052594333e-12,  7.581209474566577e-14, -3.354766329756831e-15,
  1.343516643782911e-16, -4.912277054367252e-18,  4.554751009892098e-06, -1.672791357775244e-06,  3.240898475465291e-07, -4.262615226883782e-08,  4.249361322272344e-09,
 -3.415560502017792e-10,  2.302866234392882e-11, -1.338646851672843e-12,  6.845502765667592e-14, -3.127368510897376e-15,  1.292012650032679e-16, -4.869159786498255e-18,
  3.138217092474016e-06, -1.189247425350137e-06,  2.383001111773709e-07, -3.241425332779353e-08,  3.339955667950017e-09, -2.772862285842357e-10,  1.929554929595853e-11,
 -1.156768918916788e-12,  6.096102441278479e-14, -2.867963690271049e-15,  1.219267276826758e-16, -4.724936597409192e-18,  2.184117552114912e-06, -8.513447941793750e-07,
  1.758790814727649e-07, -2.466565710657474e-08,  2.619157607760424e-09, -2.239476144586051e-10,  1.603926408519134e-11, -9.889862167057938e-13,  5.356999153220556e-14,
 -2.588709843643281e-15,  1.129719279395282e-16, -4.490893516366714e-18,  1.535157835183078e-06, -6.136129847985878e-07,  1.302893479763936e-07, -1.878155092635899e-08,
  2.049170698919500e-09, -1.799329731386644e-10,  1.322649622364596e-11, -8.365440235859694e-13,  4.645164741635174e-14, -2.299802469037658e-15,  1.027678512963417e-16,
 -4.180543348018603e-18,  1.088624733501763e-06, -4.448806725341137e-07,  9.679006504609054e-08, -1.429830184767977e-08,  1.598185876408792e-09, -1.437010333701787e-10,
  1.081125143394000e-11, -6.994828640039842e-13,  3.971194667416622e-14, -2.009183755642099e-15,  9.170158983704193e-17, -3.808082489172895e-18,  7.771375754485521e-07,
 -3.237689192920429e-07,  7.195789160421394e-08, -1.086071671164959e-08,  1.239993984406499e-09, -1.138426647964328e-10,  8.741532656857598e-12, -5.769809544062910e-13,
  3.340284614838086e-14, -1.722529505893634e-15,  8.009741979195298e-17, -3.387159859258731e-18,  5.562045909157305e-07, -2.355722838121762e-07,  5.332372405665464e-08,
 -8.198395330108263e-09,  9.533076696716662e-10, -8.910958174376179e-11,  6.963954671431017e-12, -4.676434378192540e-13,  2.753316979904355e-14, -1.443424730840476e-15,
  6.820848543154174e-17, -2.930017041731132e-18,  3.961789690408898e-07, -1.701148587396091e-07,  3.910211942910118e-08, -6.105826018363126e-09,  7.209724094428347e-10,
 -6.841769430410040e-11,  5.426620575385863e-12, -3.697279162132168e-13,  2.207903238317759e-14, -1.173646873860403e-15,  5.621677496515782e-17, -2.446993972326100e-18,
  2.770459957806337e-07, -1.202809678830222e-07,  2.799209018226312e-08, -4.426158694621588e-09,  5.291751278224784e-10, -5.083463648527631e-11,  4.080643949301496e-12,
 -2.813073556432979e-13,  1.699293272138520e-14, -9.134930537928046e-16,  4.423891417927494e-17, -1.946353883811581e-18,  1.850241952658847e-07, -8.100663172741201e-08,
  1.903118738251694e-08, -3.038227172410653e-09,  3.667077456863072e-10, -3.555840418594032e-11,  2.880685356736803e-12, -2.003783482768505e-13,  1.221116435775535e-14,
 -6.621089899076897e-16,  3.233563907080864e-17, -1.434364942105683e-18,  1.103246085246921e-07, -4.858247372690872e-08,  1.148853029624882e-08, -1.846287347681719e-09,
  2.243139971442660e-10, -2.189229180964502e-11,  1.784861506341517e-12, -1.249288921662705e-13,  7.659758443377846e-15, -4.178071069514274e-16,  2.052386100964725e-17,
 -9.155983700937820e-19,  4.570106048722272e-08, -2.018961654644838e-08,  4.791703091349417e-09, -7.729034758564658e-10,  9.424762404839050e-11, -9.231427104808674e-12,
  7.552948001719526e-13, -5.304910457826060e-14,  3.263635162409574e-15, -1.786083741247470e-16,  8.802233472438338e-18, -3.939230181261357e-19,  6.589760174447473e-02,
 -1.810690913774920e-04,  5.186394206678382e-07, -1.535530640280021e-09,  4.655529781828625e-12, -1.433581232985464e-14,  4.454405415774945e-17, -1.390208949729670e-19,
  4.344361857052231e-22, -1.356706476986960e-24,  4.228837186310466e-27, -1.314764910159985e-29,  6.400168612780678e-02, -2.353042835077411e-04,  1.017964675001630e-06,
 -4.512410144698421e-09,  1.964296721734043e-11, -8.340316207591279e-14,  3.460858256375254e-16, -1.408017838059286e-18,  5.632121494523599e-21, -2.219905308932112e-23,
  8.636558130516854e-26, -3.321058713339517e-28,  6.037742295596529e-02, -3.340571213864072e-04,  2.082760731229125e-06, -1.221559133079026e-08,  6.747810195767301e-11,
 -3.558926430976879e-13,  1.809440046157415e-15, -8.925043088673877e-18,  4.290218281700597e-20, -2.016609517752046e-22,  9.293597484618425e-25, -4.207997609933180e-27,
  5.533478673923819e-02, -4.600473305552178e-04,  3.799507083295631e-06, -2.791841482320162e-08,  1.889485366024497e-10, -1.203106636389308e-12,  7.298932249991309e-15,
 -4.254785842288479e-17,  2.397719706797186e-19, -1.312220463696699e-21,  6.999142045947948e-24, -3.648625606949136e-26,  4.928120744466290e-02, -5.921413598705666e-04,
  6.204275468691435e-06, -5.583542899057649e-08,  4.542726029074131e-10, -3.428975898831678e-12,  2.439282793147370e-14, -1.652721771827790e-16,  1.074645185276424e-18,
 -6.743976529511981e-21,  4.102529594447215e-23, -2.427529909976849e-25,  4.266608127710652e-02, -7.096197370568702e-04,  9.219130701617031e-06, -1.000722927601579e-07,
  9.647261194591504e-10, -8.516261460892292e-12,  7.014047350542972e-14, -5.457709986897739e-16,  4.048131251171767e-18, -2.881313482916845e-20,  1.978083066627772e-22,
 -1.315107647808376e-24,  3.592539910944769e-02, -7.959345046367777e-04,  1.262444583816610e-05, -1.632063397462707e-07,  1.842709732335370e-09, -1.882215034924986e-11,
  1.777075714597238e-13, -1.573247241583173e-15,  1.319368697816249e-17, -1.056089080700534e-19,  8.115749668299961e-22, -6.014891172790157e-24,  2.943591350088467e-02,
 -8.411394834009030e-04,  1.608037072025230e-05, -2.448733543849227e-07,  3.206741573274056e-09, -3.756801616642405e-11,  4.033045096470859e-13, -4.031366913339926e-15,
  3.794888925038649e-17, -3.392557917573549e-19,  2.898981139105760e-21, -2.379830096025633e-23,  2.348502405484035e-02, -8.426312246961675e-04,  1.919065136593725e-05,
 -3.408936758995427e-07,  5.134329823628697e-09, -6.846914882675496e-11,  8.299764438902486e-13, -9.306558994606255e-15,  9.773396263234923e-17, -9.701234674340019e-19,
  9.166452046524672e-21, -8.290100901299452e-23,  1.825844464936761e-02, -8.043255457497692e-04,  2.158641619480688e-05, -4.433775255824121e-07,  7.622965006442970e-09,
 -1.149448018457951e-10,  1.563726465917425e-12, -1.955768601938064e-14,  2.279066893367947e-16, -2.499092855273657e-18,  2.598367208418580e-20, -2.576834949097756e-22,
  1.384391920334225e-02, -7.347578761124315e-04,  2.300230143358501e-05, -5.419216177374666e-07,  1.056369501653857e-08, -1.790259652225223e-10,  2.718337182330156e-12,
 -3.772967655175740e-14,  4.855472664898516e-16, -5.855118305541638e-18,  6.669959998270266e-20, -7.223340197280529e-22,  1.024664934248446e-02, -6.447503901774199e-04,
  2.332295859660306e-05, -6.255998554268333e-07,  1.373990282407358e-08, -2.602655968000581e-10,  4.388757302485964e-12, -6.728715501231125e-14,  9.521519686786465e-16,
 -1.257505253510823e-17,  1.563409805354607e-19, -1.842016932541232e-21,  7.411042168923671e-03, -5.452366089539196e-04,  2.259052384497731e-05, -6.851563140673305e-07,
  1.685596969441049e-08, -3.550511268811433e-10,  6.618152745663815e-12, -1.116041398701645e-13,  1.729598966156214e-15, -2.492370818115616e-17,  3.369744719007760e-19,
 -4.304643269897895e-21,  5.243731588975813e-03, -4.456420561559123e-04,  2.097703697892811e-05, -7.147569866123689e-07,  1.958976653565623e-08, -4.566494990245733e-10,
  9.368364871739730e-12, -1.730713386611546e-13,  2.926605050868552e-15, -4.585352871663406e-17,  6.719458738719933e-19, -9.277145314301926e-21,  3.634097831278004e-03,
 -3.529804849581553e-04,  1.873508883416170e-05, -7.128490160418846e-07,  2.165423586710490e-08, -5.560887509454885e-10,  1.250491270885568e-11, -2.521299246503109e-13,
  4.635691478970263e-15, -7.871054440749306e-17,  1.246278580121203e-18, -1.854132365267544e-20,  2.470135764454763e-03, -2.716192062283133e-04,  1.614295078684003e-05,
 -6.820041123245520e-07,  2.285047635131219e-08, -6.436889809273136e-10,  1.580442380524006e-11, -3.465383766155703e-13,  6.904732899230724e-15, -1.266533303531158e-16,
  2.160396497316435e-18, -3.453650628664646e-20,  1.649025867525552e-03, -2.035391223002624e-04,  1.345779791061926e-05, -6.279390920307850e-07,  2.309852325570338e-08,
 -7.108274525053932e-10,  1.898536714128816e-11, -4.511651722674513e-13,  9.710779203759964e-15, -1.918564537265982e-16,  3.515594866857671e-18, -6.022706831290857e-20,
  1.082857906667668e-03, -1.488722805120988e-04,  1.088485126378511e-05, -5.580985481836055e-07,  2.244020357194888e-08, -7.514534148771185e-10,  2.175506046775682e-11,
 -5.584615367244417e-13,  1.294508045510476e-14, -2.746817484470531e-16,  5.392310590833060e-18, -9.873895970826944e-20,  7.005628994895340e-04, -1.065224025132916e-04,
  8.564099395445853e-06, -4.802148458422487e-07,  2.101728240156592e-08, -7.629754436145054e-10,  2.386049973422131e-11, -6.595536706759240e-13,  1.641603478450763e-14,
 -3.730664589097348e-16,  7.825436309529838e-18, -1.527746100951950e-19,  4.472872634423111e-04, -7.473142361730421e-05,  6.571674526900025e-06, -4.011613625151850e-07,
  1.903430277861662e-08, -7.463670388923458e-10,  2.512974345702458e-11, -7.456909576268974e-13,  1.987163693931053e-14, -4.823557275604030e-16,  1.078330331696095e-17,
 -2.239029835575540e-19,  2.823302459803327e-04, -5.151964264468063e-05,  4.930713137822270e-06, -3.262552091860235e-07,  1.671751223919178e-08, -7.055756312927098e-10,
  2.549433708630499e-11, -8.096781239233908e-13,  2.303689777748384e-14, -5.956940498993243e-16,  1.415723761457829e-17, -3.118966035965583e-19,  1.765063974568702e-04,
 -3.498035057055089e-05,  3.626376541466606e-06, -2.590133741355132e-07,  1.427946837607669e-08, -6.464890762734449e-10,  2.498964351189628e-11, -8.469423154708922e-13,
  2.565708173099363e-14, -7.049251540236824e-16,  1.776629484587059e-17, -4.143131092671681e-19,  1.095029690210996e-04, -2.344424237615756e-05,  2.620870664747239e-06,
 -2.012635743448513e-07,  1.189495535414323e-08, -5.757712071753080e-10,  2.373628542442318e-11, -8.560193349767875e-13,  2.753620026976706e-14, -8.017963522978710e-16,
  2.137758286075583e-17, -5.264755860895061e-19,  6.754749965656502e-05, -1.554507618202488e-05,  1.865949200067792e-06, -1.534692744063045e-07,  9.689585296421132e-09,
 -4.998337790848967e-10,  2.191007684135564e-11, -8.384247518775118e-13,  2.856227020725965e-14, -8.791798307456160e-16,  2.473804354987748e-17, -6.419032586966110e-19,
  4.151320659628971e-05, -1.022071807237352e-05,  1.311896530161373e-06, -1.151356817885209e-07,  7.739238324784368e-09, -4.241083290283945e-10,  1.970897803220927e-11,
 -7.980358475517533e-13,  2.871525573798124e-14, -9.320354117051535e-16,  2.761038562176015e-17, -7.531183788107877e-19,  2.547102660771547e-05, -6.678660107543966e-06,
  9.130594568221834e-07, -8.519860551946214e-08,  6.076845096652407e-09, -3.526669377910559e-10,  1.732417479856191e-11, -7.402023945291867e-13,  2.805852236605143e-14,
 -9.579327537110201e-16,  2.980509866574027e-17, -8.526523229747699e-19,  1.563455835140446e-05, -4.347095942049953e-06,  6.305778746456828e-07, -6.234054536804595e-08,
  4.702792184315461e-09, -2.881514954002661e-10,  1.491952490443273e-11, -6.708162589746616e-13,  2.671838033146334e-14, -9.570832056586511e-16,  3.120216456797346e-17,
 -9.340289419284650e-19,  9.620480611426395e-06, -2.824760450593841e-06,  4.331510863286089e-07, -4.521475097357439e-08,  3.595931933478487e-09, -2.319221984255782e-10,
  1.262058419343669e-11, -5.955198022241248e-13,  2.485800581075719e-14, -9.319540476426086e-16,  3.175934048418933e-17, -9.925260239683551e-19,  5.946466664563935e-06,
 -1.836477861683990e-06,  2.966154981173298e-07, -3.258243824647216e-08,  2.723251995406995e-09, -1.843252655544101e-10,  1.051210234182996e-11, -5.191534437606871e-13,
  2.265172215887021e-14, -8.866159269152664e-16,  3.150744333329079e-17, -1.025590534945567e-18,  3.699338081860822e-06, -1.197090746920263e-06,  2.029342928559648e-07,
 -2.338079574595816e-08,  2.047290915034730e-09, -1.449950231951041e-10,  8.641616129346849e-12, -4.454644684529205e-13,  2.026395447222528e-14, -8.259963259755378e-16,
  3.053580896230023e-17, -1.032878962300256e-18,  2.320596997762231e-06, -7.839210527296575e-07,  1.390028067544677e-07, -1.674277213054517e-08,  1.531156422852807e-09,
 -1.131323743936553e-10,  7.026484233990471e-12, -3.770420104023539e-13,  1.783500177030851e-14, -7.551869832600003e-16,  2.897244521950642e-17, -1.015978846880139e-18,
  1.470379092641294e-06, -5.166768664625417e-07,  9.550458435349617e-08, -1.198756218779995e-08,  1.141459817463217e-09, -8.772906393882815e-11,  5.662086011298234e-12,
 -3.154136777550839e-13,  1.547382122800863e-14, -6.789017368517160e-16,  2.696334813314674e-17, -9.779204408802664e-19,  9.424639961158252e-07, -3.432966902782426e-07,
  6.593022498197980e-08, -8.596285323387178e-09,  8.496710780551176e-10, -6.772876149486689e-11,  4.529589692036497e-12, -2.612340192911444e-13,  1.325668986710478e-14,
 -6.011246735052869e-16,  2.465441617400626e-17, -9.226024654300366e-19,  6.118310482075820e-07, -2.302483958596533e-07,  4.579293956271776e-08, -6.182615366529872e-09,
  6.324118068415994e-10, -5.212978068602390e-11,  3.602402796919415e-12, -2.145056033058069e-13,  1.122998543892841e-14, -5.249421408935425e-16,  2.217793876971536e-17,
 -8.542398635348094e-19,  4.026056255468424e-07, -1.560249653603121e-07,  3.203161498232306e-08, -4.464126980241187e-09,  4.711208497817685e-10, -4.004099196345198e-11,
  2.850987997996571e-12, -1.747910629100979e-13,  9.415279692304949e-15, -4.525231785022666e-16,  1.964423746373034e-17, -7.769075109457662e-19,  2.686053157618514e-07,
 -1.068581225498895e-07,  2.257288914842347e-08, -3.237219514314160e-09,  3.514128073462139e-10, -3.070415437989743e-11,  2.246105582897882e-12, -1.413923775673393e-13,
  7.815244684978449e-15, -3.852012026096740e-16,  1.713799775302042e-17, -6.942156836549374e-19,  1.815882555512689e-07, -7.393095530057297e-08,  1.601868422799664e-08,
 -2.356609056193424e-09,  2.623398694582385e-10, -2.349459852331575e-11,  1.760742779764264e-12, -1.134881318223990e-13,  6.419325321690996e-15, -3.236111133111958e-16,
  1.471824299972087e-17, -6.091206274480489e-19,  1.241717896642399e-07, -5.158318770949323e-08,  1.142793417882256e-08, -1.719318393428278e-09,  1.956794470319953e-10,
 -1.790961750571332e-11,  1.371056233292821e-12, -9.022923651194477e-14,  5.208576855049137e-15, -2.678448479156852e-16,  1.242071920171847e-17, -5.238517325822200e-19,
  8.556701069153853e-08, -3.616345773732864e-08,  8.166518930772788e-09, -1.252588199725769e-09,  1.453077369561195e-10, -1.355115129377935e-11,  1.056637995556521e-12,
 -7.079894389205043e-14,  4.159422278681453e-15, -2.175999314471410e-16,  1.026155878948350e-17, -4.399261301478815e-19,  5.900500386701588e-08, -2.529818791053721e-08,
  5.805251784213144e-09, -9.049653304903896e-10,  1.066796194442688e-10, -1.010694846043823e-11,  8.003597039281736e-13, -5.444501364753024e-14,  3.246325692919646e-15,
 -1.723064791705549e-16,  8.241340342888179e-18, -3.582198339099929e-19,  4.017746906228956e-08, -1.742616539421385e-08,  4.051001958319582e-09, -6.398393049680300e-10,
  7.641263788697069e-11, -7.332562068792070e-12,  5.879828804041574e-13, -4.049180914055324e-14,  2.443513884890337e-15, -1.312267278732583e-16,  6.348953231255089e-18,
 -2.790686879807212e-19,  2.628498139246965e-08, -1.150128364590791e-08,  2.700262837725934e-09, -4.307952967123985e-10,  5.196176112013450e-11, -5.035281100082948e-12,
  4.076621376426773e-13, -2.833897652562013e-14,  1.725937531188342e-15, -9.352719248846526e-17,  4.564949685932064e-18, -2.023795760151891e-19,  1.544896388695500e-08,
 -6.801001323818817e-09,  1.607704634668817e-09, -2.582777961181637e-10,  3.136830191064594e-11, -3.060375622387099e-12,  2.494246466697823e-13, -1.745226182268349e-14,
  1.069696591178353e-15, -5.832849807233606e-17,  2.864350581094168e-18, -1.277430620767945e-19,  6.348315408830582e-09, -2.804098097885026e-09,  6.653934587339915e-10,
 -1.073088687954732e-10,  1.308285366244400e-11, -1.281218557101908e-12,  1.048078969622193e-13, -7.360031137614267e-15,  4.527185361157515e-16, -2.477163015640165e-17,
  1.220598337925689e-18, -5.461596425745867e-20,  6.518150866882876e-02, -1.769924365982974e-04,  5.006507068120666e-07, -1.463279104079873e-09,  4.379196740238151e-12,
 -1.331193911921868e-14,  4.083898038097205e-17, -1.258688513536953e-19,  3.885051725431313e-22, -1.198569757616009e-24,  3.691159898173167e-27, -1.133984329700749e-29,
  6.307642086477834e-02, -2.273719428134503e-04,  9.656478581341697e-07, -4.211028926391255e-09,  1.805487339366610e-11, -7.555054578309884e-14,  3.090689684393701e-16,
 -1.239937411707299e-18,  4.891773392718508e-21, -1.901968024020365e-23,  7.300415907749570e-26, -2.769997848202400e-28,  5.907361547436964e-02, -3.179635559147496e-04,
  1.942424061355960e-06, -1.119060727136709e-08,  6.077504690554235e-11, -3.153162223972877e-13,  1.577716758176477e-15, -7.661502198314998e-18,  3.626920966441664e-20,
 -1.679392727031473e-22,  7.625833526217802e-25, -3.402838724428108e-27,  5.355333795155127e-02, -4.309417326334587e-04,  3.481860874853342e-06, -2.507860748937465e-08,
  1.665459514957981e-10, -1.041403120200729e-12,  6.208276109700187e-15, -3.557995043737006e-17,  1.972072602178922e-19, -1.061894825257851e-21,  5.574455507843470e-24,
 -2.860796856021257e-26,  4.700783474021074e-02, -5.450687074890522e-04,  5.575696265080718e-06, -4.908540148498066e-08,  3.911916969863919e-10, -2.895407067631979e-12,
  2.021229221031432e-14, -1.344711117906776e-16,  8.589960262173189e-19, -5.298175568242226e-21,  3.168899810978178e-23, -1.844212928017650e-25,  3.996785703240911e-02,
 -6.404201312460400e-04,  8.105538848387315e-06, -8.591275764951954e-08,  8.100685697664886e-10, -7.002537628779393e-12,  5.652677709359665e-14, -4.314064732608096e-16,
  3.140358509581037e-18, -2.194736883581537e-20,  1.480107892380279e-22, -9.670179178613913e-25,  3.293192023324315e-02, -7.022988003438158e-04,  1.083115896206521e-05,
 -1.365169592843171e-07,  1.505580850424005e-09, -1.504137248501868e-11,  1.390377057542215e-13, -1.206097982243707e-15,  9.917482375960574e-18, -7.788121964755844e-20,
  5.874518602656391e-22, -4.275359559235107e-24,  2.631119130944778e-02, -7.234320725209789e-04,  1.342654710515045e-05, -1.990865095792091e-07,  2.543695251778737e-09,
 -2.911655682276616e-11,  3.057397212121170e-13, -2.991932876037378e-15,  2.759298423836566e-17, -2.418239736016061e-19,  2.026873984935934e-21, -1.632850916918247e-23,
  2.039748437934177e-02, -7.041698294509923e-04,  1.555091146987527e-05, -2.686998032741780e-07,  3.944732107391466e-09, -5.135321820880684e-11,  6.083933041506168e-13,
 -6.673666839258281e-15,  6.861531875718424e-17, -6.672625376643633e-19,  6.180468435937001e-21, -5.482241100643716e-23,  1.535554093130208e-02, -6.510052267972991e-04,
  1.692795690817893e-05, -3.379345152507407e-07,  5.658937302401498e-09, -8.323910994903613e-11,  1.105999541864220e-12, -1.352382111918536e-14,  1.542018838195978e-16,
 -1.655684186216413e-18,  1.686672717733425e-20, -1.639816684362628e-22,  1.123546314866502e-02, -5.741291300737690e-04,  1.740577137725677e-05, -3.983318639867218e-07,
  7.558315557882536e-09, -1.248850906658974e-10,  1.851083375449675e-12, -2.510616253626910e-14,  3.159955190147600e-16, -3.729608110669385e-18,  4.161164979822060e-20,
 -4.416213534810877e-22,  7.998067318925462e-03, -4.848196291305497e-04,  1.697994176938490e-05, -4.422645591412508e-07,  9.451449530490459e-09, -1.744796949751771e-10,
  2.870990808517054e-12, -4.299717742922147e-14,  5.948660866257721e-16, -7.687130297740934e-18,  9.357613682893739e-20, -1.080165191403609e-21,  5.545298105727990e-03,
 -3.933035583802439e-04,  1.577778886518154e-05, -4.645986307059969e-07,  1.111930162106704e-08, -2.282046969745951e-10,  4.149810108019229e-12, -6.834210710643891e-14,
  1.035293162051246e-15, -1.459430839578499e-17,  1.931631966354267e-19, -2.417103587277806e-21,  3.749172621967997e-03, -3.074278871074355e-04,  1.401467119810279e-05,
 -4.636433977702767e-07,  1.236149506984044e-08, -2.807359479253757e-10,  5.618145371626192e-12, -1.013504679797156e-13,  1.675061992991264e-15, -2.567154494396183e-17,
  3.682424679942141e-19, -4.979820766996724e-21,  2.475081867253143e-03, -2.321766869670477e-04,  1.193961013393977e-05, -4.411781751652001e-07,  1.303846692400731e-08,
 -3.262338827639594e-10,  7.156414951518787e-12, -1.409030540160413e-13,  2.532119012138714e-15, -4.205545975436696e-17,  6.518291688232235e-19, -9.498845489710977e-21,
  1.597749134986527e-03, -1.698557053713047e-04,  9.786430557851834e-06, -4.016762437857351e-07,  1.309692332908223e-08, -3.595351268066252e-10,  8.612856133343444e-12,
 -1.844439846958040e-13,  3.592455161266134e-15, -6.446673631450085e-17,  1.076552569720750e-18, -1.685953545839193e-20,  1.010095472554415e-03, -1.206736462661611e-04,
  7.740659285402627e-06, -3.510746710164161e-07,  1.257277354528358e-08, -3.771822297585948e-10,  9.831916452406468e-12, -2.282522400799509e-13,  4.803654833787124e-15,
 -9.286881454531731e-17,  1.666374241510486e-18, -2.797220411268524e-20,  6.264256692423752e-04, -8.345970645169200e-05,  5.925134200803571e-06, -2.954975471786574e-07,
  1.157371586445164e-08, -3.780010079560243e-10,  1.068477253543576e-11, -2.680553945308716e-13,  6.077555175172500e-15, -1.262339607426257e-16,  2.427404364133894e-18,
 -4.356662052541944e-20,  3.817653989813938e-04, -5.632812506026169e-05,  4.401509429300008e-06, -2.402513353857080e-07,  1.024947933505488e-08, -3.631096569933395e-10,
  1.109310634847395e-11, -2.998225071766895e-13,  7.302571357296069e-15, -1.625198072095252e-16,  3.340657042460111e-18, -6.395130733531053e-20,  2.290642682284090e-04,
 -3.718864888113807e-05,  3.181896274985146e-06, -1.892479068964312e-07,  8.759625600726437e-09, -3.354354843953961e-10,  1.104004258933565e-11, -3.205102070815784e-13,
  8.362854469736103e-15, -1.988992873279650e-16,  4.359568859802696e-18, -8.880592133382027e-20,  1.355849892878454e-04, -2.407647024859819e-05,  2.244601085739244e-06,
 -1.448520220737374e-07,  7.247066361518140e-09, -2.989463882031708e-10,  1.056680295579878e-11, -3.285605347181592e-13,  9.159058638425558e-15, -2.322027212431348e-16,
  5.413892473530478e-18, -1.170804583470667e-19,  7.933463470154635e-05, -1.532307983977616e-05,  1.549335959557259e-06, -1.080457043783907e-07,  5.821686103369169e-09,
 -2.578396018740720e-10,  9.758061038664751e-12, -3.240434091575385e-13,  9.625099957899088e-15, -2.594586056758388e-16,  6.419576886530984e-18, -1.470510643447780e-19,
  4.598914915152754e-05, -9.610793548490941e-06,  1.049278811162060e-06, -7.876489873620731e-08,  4.554560356600543e-09, -2.158813941687991e-10,  8.721581655493171e-12,
 -3.084547539790199e-13,  9.736910816396956e-15, -2.783896630337549e-16,  7.292279566999994e-18, -1.765358299326838e-19,  2.647102476152777e-05, -5.955768628168348e-06,
  6.991398703832829e-07, -5.627915994843475e-08,  3.480522642180046e-09, -1.759988098079866e-10,  7.567996561056548e-12, -2.842753696035114e-13,  9.511969505508277e-15,
 -2.877424563567286e-16,  7.961034462845692e-18, -2.032233762461728e-19,  1.516431163590539e-05, -3.655968236349378e-06,  4.595764955675000e-07, -3.952712059212653e-08,
  2.605681760485649e-09, -1.401319087721207e-10,  6.395026770832881e-12, -2.544373918119757e-13,  9.001113088259922e-15, -2.873887007809878e-16,  8.378723154679451e-18,
 -2.250327246766926e-19,  8.666645253249748e-06, -2.228875337362441e-06,  2.988593106740911e-07, -2.736610496429782e-08,  1.916657575275537e-09, -1.092911376772084e-10,
  5.278142437954664e-12, -2.218333657289277e-13,  8.275874235394723e-15, -2.782070138862091e-16,  8.527198820338788e-18, -2.404173889501204e-19,  4.953519718433722e-06,
 -1.353092898345811e-06,  1.927896518266040e-07, -1.872965878224778e-08,  1.389207752261732e-09, -8.373802717684137e-11,  4.267526383845687e-12, -1.889562667715526e-13,
  7.414970965468058e-15, -2.618088213296973e-16,  8.416616502847390e-18, -2.485492903883466e-19,  2.838431256425571e-06, -8.201007017529225e-07,  1.237066486991101e-07,
 -1.270750417822435e-08,  9.950005850518220e-10, -6.321151488217970e-11,  3.389843967554451e-12, -1.577023502556418e-13,  6.492852978045375e-15, -2.401967812136435e-16,
  8.080060365025944e-18, -2.493573262760652e-19,  1.634589418121702e-06, -4.975461057775433e-07,  7.917024162569159e-08, -8.570297300940186e-09,  7.061869120229790e-10,
 -4.714331951749436e-11,  2.652828971205060e-12, -1.293224916573669e-13,  5.571918492878626e-15, -2.154383314405920e-16,  7.565466008882018e-18, -2.434353143854960e-19,
  9.483130800423515e-07, -3.029224553799941e-07,  5.066737017736213e-08, -5.760951147036977e-09,  4.979945268596788e-10, -3.483113418733800e-11,  2.050868044688652e-12,
 -1.044811879808879e-13,  4.698720100703811e-15, -1.894111515591475e-16,  6.926986982192291e-18, -2.318617765976125e-19,  5.555451132344075e-07, -1.855354082446369e-07,
  3.250758986716856e-08, -3.869572379219139e-09,  3.498268623461084e-10, -2.555966768783723e-11,  1.570286574171329e-12, -8.337540006755166e-14,  3.903542853020477e-15,
 -1.636451373839340e-16,  6.217512643536285e-18, -2.159840970536570e-19,  3.293560426137321e-07, -1.145836826491588e-07,  2.095837430277245e-08, -2.603395113315725e-09,
  2.453846404768792e-10, -1.867341230208125e-11,  1.193626467361105e-12, -6.587200813961229e-14,  3.202282451796196e-15, -1.392579466010209e-16,  5.483313967815249e-18,
 -1.972138196554757e-19,  1.979969685287062e-07, -7.150443748312918e-08,  1.360754114791761e-08, -1.758192986418277e-09,  1.722461770446451e-10, -1.361168542613666e-11,
  9.026885797640580e-13, -5.163553747177298e-14,  2.599508026499811e-15, -1.169639173004831e-16,  4.761067021173123e-18, -1.768645181599847e-19,  1.209043527577256e-07,
 -4.516936361962879e-08,  8.913607906396853e-09, -1.194126483624211e-09,  1.212179141976047e-10, -9.917938147267222e-12,  6.804248645920394e-13, -4.023117287491257e-14,
  2.091806713955153e-15, -9.712968959351715e-17,  4.076968127771700e-18, -1.560459067357436e-19,  7.509038299142081e-08, -2.892437550221250e-08,  5.899305101038146e-09,
 -8.168009404341050e-10,  8.564873204569149e-11, -7.233809759319386e-12,  5.119175184510489e-13, -3.119861848487860e-14,  1.670817835779669e-15, -7.985148475069839e-17,
  3.447372889806301e-18, -1.356130048454029e-19,  4.746849213936457e-08, -1.879099837147029e-08,  3.948112989961092e-09, -5.631621345581239e-10,  6.081026153933787e-11,
 -5.285739225395501e-12,  3.847186669116378e-13, -2.409902944185883e-14,  1.325659554163526e-15, -6.503500527385892e-17,  2.880332095499030e-18, -1.161597870107015e-19,
  3.053975167918405e-08, -1.238500230409645e-08,  2.671919850567118e-09, -3.913862774611758e-10,  4.338432680284692e-11, -3.869249795386803e-12,  2.887939178610800e-13,
 -1.854044109491174e-14,  1.044672923639705e-15, -5.246609957295646e-17,  2.377484786836090e-18, -9.804294307556496e-20,  1.997037922645572e-08, -8.270960724821458e-09,
  1.826262933976998e-09, -2.738371595365825e-10,  3.106294533616269e-11, -2.833836329149100e-12,  2.162556705611594e-13, -1.418786150450681e-14,  8.165442629841852e-16,
 -4.186663103025549e-17,  1.935922061444292e-18, -8.142178829885893e-20,  1.322935207529129e-08, -5.578643215682315e-09,  1.256650811276731e-09, -1.922637235224815e-10,
  2.224864087374350e-11, -2.069845639160790e-12,  1.610122074604543e-13, -1.076353101104780e-14,  6.309298040758112e-16, -3.293450589675872e-17,  1.549793904378880e-18,
 -6.630317653189260e-20,  8.819428768799444e-09, -3.775350771807777e-09,  8.648201684896063e-10, -1.345757196553975e-10,  1.583636514786977e-11, -1.497779277304456e-12,
  1.184085412856943e-13, -8.041608991813533e-15,  4.787193970640170e-16, -2.536947820450451e-17,  1.211561210903905e-18, -5.258389598106394e-20,  5.840512621283385e-09,
 -2.530595853499196e-09,  5.875998300730627e-10, -9.270067934723479e-11,  1.105797096943236e-11, -1.059920413561583e-12,  8.489845267360557e-14, -5.840239598048602e-15,
  3.520607334972709e-16, -1.888753124012241e-17,  9.128844127078333e-19, -4.008641359977755e-20,  3.739499130150315e-09, -1.635258032130849e-09,  3.836601108777300e-10,
 -6.116574464535987e-11,  7.372599170030528e-12, -7.139451686155195e-13,  5.776325518497858e-14, -4.012838390767264e-15,  2.442389792752818e-16, -1.322684728571305e-17,
  6.451920905834375e-19, -2.858650260820637e-20,  2.165010041718105e-09, -9.527826899116919e-10,  2.251486191154807e-10, -3.615675973467989e-11,  4.389689574315933e-12,
 -4.281146166054355e-13,  3.487946628492309e-14, -2.439664690812399e-15,  1.494823330724847e-16, -8.148239181369150e-18,  4.000052813575435e-19, -1.783350418441439e-20,
  8.821824272386803e-10, -3.896044199755663e-10,  9.243368568403212e-11, -1.490413004857356e-11,  1.816739999658075e-12, -1.778825800159774e-13,  1.454872686249687e-14,
 -1.021485989201136e-15,  6.282085807390745e-17, -3.436798474821438e-18,  1.693156949764166e-19, -7.574784859004838e-21,  6.448143977989577e-02, -1.730562970932912e-04,
  4.835031438598534e-07, -1.395289785962370e-09,  4.122480937423742e-12, -1.237272956349564e-14,  3.748241385058270e-17, -1.140995136278221e-19,  3.478983758781853e-22,
 -1.060430721718636e-24,  3.227019962274350e-27, -9.797576046202527e-30,  6.218207020595280e-02, -2.198440906870174e-04,  9.168001895059192e-07, -3.933847507357127e-09,
  1.661531565662721e-11, -6.853243395368443e-14,  2.764431851513655e-16, -1.093815395785263e-18,  4.256819260296431e-21, -1.632927000555032e-23,  6.184690584294313e-26,
 -2.315864566518304e-28,  5.783201227167101e-02, -3.029452480271834e-04,  1.813769540408276e-06, -1.026667042131218e-08,  5.483065302977492e-11, -2.798995183555637e-13,
  1.378574751610439e-15, -6.592014067664557e-18,  3.073820959242882e-20, -1.402307463159249e-22,  6.275205533169582e-25, -2.760064404284199e-27,  5.188343675178395e-02,
 -4.042468502626137e-04,  3.196243998444315e-06, -2.257272750196977e-08,  1.471307209603432e-10, -9.036800985319791e-13,  5.294932508091466e-15, -2.984028042991567e-17,
  1.627068695396940e-19, -8.621844167749004e-22,  4.455401185921532e-24, -2.251395471390969e-26,  4.491318518341630e-02, -5.027170684145730e-04,  5.022396890134272e-06,
 -4.326446909127739e-08,  3.378448609647315e-10, -2.452556087891855e-12,  1.680491397422977e-14, -1.098053780845405e-16,  6.892493104566179e-19, -4.179129611745202e-21,
  2.458110173112660e-23, -1.407270412999071e-25,  3.752963337200650e-02, -5.794894787290279e-04,  7.147958683997353e-06, -7.400226729120935e-08,  6.826615452387147e-10,
 -5.780183191231280e-12,  4.574318609249599e-14, -3.424923518037941e-16,  2.447307387801450e-18, -1.679776867721323e-20,  1.113033798766650e-22, -7.147589213917960e-25,
  3.028619770378534e-02, -6.218145641555570e-04,  9.328121312534656e-06, -1.146638486226153e-07,  1.235561926855229e-09, -1.207629201462908e-11,  1.093188221208860e-13,
 -9.294069700760060e-16,  7.494998099997834e-18, -5.775539618973315e-20,  4.276933953470125e-22, -3.057170546161559e-24,  2.361807872642522e-02, -6.249257644324556e-04,
  1.126370453233556e-05, -1.626741359454896e-07,  2.028439398245802e-09, -2.269183424429509e-11,  2.331224237283636e-13, -2.233905360392291e-15,  2.018862866695702e-17,
 -1.734885410306863e-19,  1.426574334824540e-21, -1.128020010149986e-23,  1.781061645394373e-02, -5.916603619329252e-04,  1.267372140425564e-05, -2.130665974565211e-07,
  3.049740211182893e-09, -3.876661786949604e-11,  4.489737399640144e-13, -4.818956955228554e-15,  4.851773411300560e-17, -4.623351250059885e-19,  4.198698805185252e-21,
 -3.653498509057403e-23,  1.299870160187641e-02, -5.303809515011418e-04,  1.336540555129120e-05, -2.593869298559712e-07,  4.231586876460619e-09, -6.073227718199357e-11,
  7.883069638613700e-13, -9.425741775466448e-15,  1.051817338215338e-16, -1.106039754496870e-18,  1.104169679187781e-20, -1.052572315266228e-22,  9.189836273408062e-03,
 -4.521222779744456e-04,  1.327617529205555e-05, -2.951865531819992e-07,  5.453350833249575e-09, -8.786557272937372e-11,  1.271579623272586e-12, -1.685584611846657e-14,
  2.075286273680520e-16, -2.397782974632761e-18,  2.620560223288860e-20, -2.725931202635997e-22,  6.300163799463997e-03, -3.678807713359241e-04,  1.247604473188834e-05,
 -3.155880175855566e-07,  6.563494751654115e-09, -1.181039376990535e-10,  1.896624655719734e-12, -2.775063582225399e-14,  3.754229007479326e-16, -4.747534380792671e-18,
  5.659330972878367e-20, -6.401033272806426e-22,  4.193072138046549e-03, -2.866722223200611e-04,  1.113534378630245e-05, -3.183802005074190e-07,  7.413628482221015e-09,
 -1.482654686413400e-10,  2.630594438612608e-12, -4.231382358243114e-14,  6.266387725862033e-16, -8.642486981313479e-18,  1.119908534734571e-19, -1.372867065875029e-21,
  2.712697735458586e-03, -2.145865784712812e-04,  9.473703270592702e-06, -3.043170665361756e-07,  7.893286660093724e-09, -1.746591881314037e-10,  3.409853153389271e-12,
 -6.007247073378286e-14,  9.704696937581046e-16, -1.454956011131704e-17,  2.043078963849139e-19, -2.706427215314600e-21,  1.708301321208233e-03, -1.547311895092463e-04,
  7.708774755317707e-06, -2.766211252244434e-07,  7.953740073381652e-09, -1.939046046258126e-10,  4.149548859846821e-12, -7.978570856538284e-14,  1.401461737160853e-15,
 -2.276974992403037e-17,  3.454755377305110e-19, -4.931549216905767e-21,  1.048772832726026e-03, -1.077637383134561e-04,  6.018418099410578e-06, -2.399669289247613e-07,
  7.614000012224851e-09, -2.036891195874901e-10,  4.760730885421758e-12, -9.957154489626933e-14,  1.895810234985000e-15, -3.328251834342318e-17,  5.441281920222956e-19,
 -8.347946632474707e-21,  6.287349695798663e-04, -7.267982649992502e-05,  4.522076184666578e-06, -1.993345637774857e-07,  6.949275816449818e-09, -2.032216057281492e-10,
  5.169699558084998e-12, -1.172419367701150e-13,  2.412466439522939e-15, -4.563734304743565e-17,  8.018435242559758e-19, -1.318839665693371e-20,  3.687182638411194e-04,
 -4.758973664630728e-05,  3.279765955660224e-06, -1.590696814840269e-07,  6.068021285514707e-09, -1.932682564244760e-10,  5.333382845085278e-12, -1.307523163443982e-13,
  2.899422248883409e-15, -5.894522303772696e-17,  1.110209580038986e-18, -1.952925747180751e-20,  2.119292275527432e-04, -3.033065808765636e-05,  2.302858310596863e-06,
 -1.223321878943155e-07,  5.086129980889670e-09, -1.758136893403167e-10,  5.246262731781521e-12, -1.386255491261001e-13,  3.303655229142024e-15, -7.199258006210477e-17,
  1.450004429475407e-18, -2.721551411666982e-20,  1.196303273425792e-04, -1.886429166131578e-05,  1.569900118744986e-06, -9.094882194605070e-08,  4.105659513591925e-09,
 -1.535045664680327e-10,  4.937705424183606e-12, -1.402230878504663e-13,  3.581776533476033e-15, -8.345546273198303e-17,  1.793193696621677e-18, -3.583065685444837e-20,
  6.646411571103048e-05, -1.147964586609406e-05,  1.042122996968884e-06, -6.556932165039734e-08,  3.202117435824279e-09, -1.290670404498078e-10,  4.461832597508422e-12,
 -1.357979510749414e-13,  3.708204357940331e-15, -9.215384262711012e-17,  2.107478127255914e-18, -4.473053181411166e-20,  3.642712991253439e-05, -6.853442571643548e-06,
  6.755813453280305e-07, -4.598260163973745e-08,  2.420717423666380e-09, -1.048496686829174e-10,  3.883974879301518e-12, -1.263427772500985e-13,  3.678715340078403e-15,
 -9.727174430116741e-17,  2.362189724433001e-18, -5.313927483315411e-20,  1.974257080292040e-05, -4.025053211545596e-06,  4.289734888639045e-07, -3.146450857153289e-08,
  1.779480555258839e-09, -8.256549871687449e-11,  3.267841590795932e-12, -1.133068354987255e-13,  3.508937606380827e-15, -9.848405087783029e-17,  2.533864689420784e-18,
 -6.028355273622583e-20,  1.060773406794274e-05, -2.332040222858829e-06,  2.675935252631854e-07, -2.107342889506002e-08,  1.276070465728279e-09, -6.323049458470761e-11,
  2.666260848697641e-12, -9.827873873242249e-14,  3.228949010841349e-15, -9.596597964448492e-17,  2.609999285376391e-18, -6.552828492510145e-20,  5.665346491439925e-06,
 -1.336746936013385e-06,  1.644856095718708e-07, -1.385788592853260e-08,  8.955303597569338e-10, -4.724591045280692e-11,  2.116551200946607e-12, -8.271750232730735e-14,
  2.876040012083700e-15, -9.029961290604630e-17,  2.590190069611488e-18, -6.847800019090493e-20,  3.015781712865055e-06, -7.602979879752146e-07,  9.993495800444612e-08,
 -8.975830433776290e-09,  6.170266303608921e-10, -3.455583973102557e-11,  1.640057347326030e-12, -6.777885142424519e-14,  2.487728385621640e-15, -8.231837238838318e-17,
  2.484731269196573e-18, -6.902140570229435e-20,  1.604574685006271e-06, -4.303614457492989e-07,  6.019851323225178e-08, -5.744352985071078e-09,  4.187339224379557e-10,
 -2.482003932663285e-11,  1.244523481427600e-12, -5.424512775431340e-14,  2.096495474076077e-15, -7.293803181849816e-17,  2.311434212505099e-18, -6.731584184591447e-20,
  8.557490414607771e-07, -2.431668631297242e-07,  3.606448226915750e-08, -3.643914990815521e-09,  2.807821143179602e-10, -1.756308378311502e-11,  9.278035940472486e-13,
 -4.253922652643696e-14,  1.726850992334609e-15, -6.301398144788431e-17,  2.091740192191997e-18, -6.372513098608727e-20,  4.587857533313293e-07, -1.375645606120676e-07,
  2.155469958540264e-08, -2.298359718318834e-09,  1.866249264868255e-10, -1.228262669920631e-11,  6.816959956790757e-13, -3.279048128380538e-14,  1.394582300265485e-15,
 -5.324674170672137e-17,  1.847112438106363e-18, -5.873353740519320e-20,  2.479685119928128e-07, -7.815176444857192e-08,  1.289135221729722e-08, -1.445873971342263e-09,
  1.233344290607607e-10, -8.515668660805253e-12,  4.951612892923024e-13, -2.492103243824027e-14,  1.107595082040119e-15, -4.413958079458976e-17,  1.596354140219219e-18,
 -5.285897402028054e-20,  1.354967325219869e-07, -4.471687272405604e-08,  7.738223350976446e-09, -9.099283258357548e-10,  8.128618822093623e-11, -5.870600275415849e-12,
  3.566274784905144e-13, -1.872939372271176e-14,  8.676227769251401e-16, -3.599913991441438e-17,  1.354091629312447e-18, -4.658253935190120e-20,  7.505536653527884e-08,
 -2.584182579912487e-08,  4.675265017954739e-09, -5.744995999501249e-10,  5.358048902259403e-11, -4.035666265266157e-12,  2.553976605108150e-13, -1.395818084779253e-14,
  6.721803312678034e-16, -2.896402409903807e-17,  1.130328932520956e-18, -4.030276802933503e-20,  4.225244982226122e-08, -1.512276206552815e-08,  2.850649216829109e-09,
 -3.648636888799947e-10,  3.541619844777169e-11, -2.773673231855077e-12,  1.823384446787170e-13, -1.034167163650642e-14,  5.163416149567669e-16, -2.304627095955404e-17,
  9.307889031776930e-19, -3.431503033607735e-20,  2.422797649916618e-08, -8.982779556415451e-09,  1.758245972906233e-09, -2.336441945574671e-10,  2.352992270900773e-11,
 -1.910332615736960e-12,  1.300739209371699e-13, -7.634552001494476e-15,  3.941302416035709e-16, -1.817404499557185e-17,  7.577040548048566e-19, -2.881125021578037e-20,
  1.417693157795997e-08, -5.426277647657045e-09,  1.099161042095823e-09, -1.511497200135798e-10,  1.574337541907334e-11, -1.320987269005739e-12,  9.288785995319374e-14,
 -5.625937111266723e-15,  2.994753829105830e-16, -1.422845322040360e-17,  6.107643555736515e-19, -2.389290358069467e-20,  8.476214519990810e-09, -3.338048086880705e-09,
  6.974001195232642e-10, -9.891817992558351e-11,  1.062213788050327e-11, -9.183069155797354e-13,  6.648612142639881e-14, -4.143355117809462e-15,  2.267817246394694e-16,
 -1.107143606831935e-17,  4.880179499756839e-19, -1.959044962807472e-20,  5.180436109547244e-09, -2.092200056062802e-09,  4.493308916040671e-10, -6.552090497336298e-11,
  7.230527129636389e-12, -6.420501843762298e-13,  4.771789403275593e-14, -3.050781249850720e-15,  1.712046495975940e-16, -8.564534340899887e-18,  3.866133983856969e-19,
 -1.588389263913701e-20,  3.233834422106130e-09, -1.335071564568646e-09,  2.937564081759730e-10, -4.389197681863407e-11,  4.961656031765966e-12, -4.511092599625761e-13,
  3.431091325592205e-14, -2.243753900906614e-15,  1.287262508156392e-16, -6.579903725802646e-18,  3.033456456000040e-19, -1.272112659735222e-20,  2.056051550996849e-09,
 -8.649679620889327e-10,  1.943346673847631e-10, -2.965444876379481e-11,  3.422696120235441e-12, -3.176127533872452e-13,  2.464559087724157e-14, -1.643545712827839e-15,
  9.611270667021107e-17, -5.005522984882716e-18,  2.350152639041712e-19, -1.003246163132746e-20,  1.323189859755838e-09, -5.654832745892352e-10,  1.292963160214464e-10,
 -2.008251698544465e-11,  2.358892058476508e-12, -2.226983235300694e-13,  1.757462762977951e-14, -1.191511066857132e-15,  7.081191087340452e-17, -3.746492963064621e-18,
  1.786341333143652e-19, -7.740992383445970e-21,  8.511539245576708e-10, -3.683914043834628e-10,  8.543605105051127e-11, -1.346200447086262e-11,  1.603893385235773e-12,
 -1.535522478410479e-13,  1.228504008691276e-14, -8.441368222498633e-16,  5.082960537305746e-17, -2.723973044979888e-18,  1.315173853899629e-19, -5.769214568335389e-21,
  5.328142831840755e-10, -2.328465326287745e-10,  5.459038131815610e-11, -8.696805419319285e-12,  1.047507411835822e-12, -1.013658373286728e-13,  8.195488192160003e-15,
 -5.689547471138509e-16,  3.460592579668801e-17, -1.872870703945501e-18,  9.129834011333624e-20, -4.042633398944438e-21,  3.036466502651710e-10, -1.335846936973327e-10,
  3.155493101013521e-11, -5.065471648304211e-12,  6.147488090292881e-13, -5.993213465762494e-14,  4.880992214723328e-15, -3.412793435211657e-16,  2.090327619247891e-17,
 -1.139032048170409e-18,  5.589701409923506e-20, -2.491229244852296e-21,  1.226397763562748e-10, -5.415335075263361e-11,  1.284547762018999e-11, -2.070824584148341e-12,
  2.523749144948783e-13, -2.470610136660837e-14,  2.020291844320883e-15, -1.418211169174132e-16,  8.720327933698037e-18, -4.769848718166740e-19,  2.349473028597380e-20,
 -1.050915030517658e-21,  6.379684615843191e-02, -1.692541430316239e-04,  4.671474140080605e-07, -1.331261914663742e-09,  3.883769702797608e-12, -1.151026547104305e-14,
  3.443791974204063e-17, -1.035534799046959e-19,  3.119461272284396e-22, -9.395688087841579e-25,  2.825672240391754e-27, -8.479422884788896e-30,  6.131706991965696e-02,
 -2.126940963633346e-04,  8.711449982097501e-07, -3.678617307353678e-09,  1.530860987575278e-11, -6.225045341164458e-14,  2.476383271676422e-16, -9.665446097844387e-19,
  3.711145795892562e-21, -1.404762725316469e-23,  5.250832843720983e-26, -1.940674387325612e-28,  5.664849183365062e-02, -2.889133920181444e-04,  1.695654160676377e-06,
 -9.432427048648773e-09,  4.954912516875748e-11, -2.489219888132889e-13,  1.207043357757603e-15, -5.684547624623430e-18,  2.611391999758213e-20, -1.173989785554847e-22,
  5.178139169209245e-25, -2.245305442153225e-27,  5.031592846947797e-02, -3.797216997427545e-04,  2.938921003060670e-06, -2.035659404037672e-08,  1.302631483280179e-10,
 -7.860672007935204e-13,  4.527865640245471e-15, -2.509773047989090e-17,  1.346510129564700e-19, -7.023010423124586e-22,  3.573195323744327e-24, -1.778201154924665e-26,
  4.297951215107729e-02, -4.645262845354350e-04,  4.534105912559373e-06, -3.823044890547520e-08,  2.925901945223854e-10, -2.083772952105073e-12,  1.401781555571201e-14,
 -8.997829079527803e-17,  5.551023111127498e-19, -3.309369430613050e-21,  1.914605776119867e-23, -1.078479035632280e-25,  3.532066965144196e-02, -5.256806480537990e-04,
  6.321836742484220e-06, -6.394797094434614e-08,  5.773029447671110e-10, -4.789104188463214e-12,  3.716467196325644e-14, -2.730527074337137e-16,  1.915685663169345e-18,
 -1.291630284283214e-20,  8.410626779756936e-23, -5.309749977198798e-25,  2.793992630590997e-02, -5.523748573890886e-04,  8.063237430608739e-06, -9.669289662534113e-08,
  1.018297032717480e-09, -9.739628440837927e-12,  8.636271372084059e-14, -7.197785899313792e-16,  5.693864334492027e-18, -4.306351712695710e-20,  3.131394450669497e-22,
 -2.198852735490782e-24,  2.128696751838090e-02, -5.421053682522031e-04,  9.492298081256460e-06, -1.335658310220502e-07,  1.625839754123345e-09, -1.777988613318472e-11,
  1.787518929807446e-13, -1.677688083531565e-15,  1.486082024698655e-17, -1.252449060918176e-19,  1.010569298129486e-21, -7.844654382072562e-24,  1.563165942744486e-02,
 -4.997235951878727e-04,  1.038588963190679e-05, -1.699308574442108e-07,  2.372077577955797e-09, -2.944927110439950e-11,  3.334908113237994e-13, -3.503183939651088e-15,
  3.454551670163237e-17, -3.226376615900198e-19,  2.873350453681374e-21, -2.453123060901211e-23,  1.107282200078026e-02, -4.348433418754131e-04,  1.062201155764556e-05,
 -2.004540851947093e-07,  3.186577351731239e-09, -4.463357601671460e-11,  5.660807282677207e-13, -6.620068650013002e-15,  7.231126591630325e-17, -7.448337223313633e-19,
  7.288078144979048e-21, -6.813249870548454e-23,  7.573262452515686e-03, -3.587220467970686e-04,  1.020443016042160e-05, -2.204812131121670e-07,  3.966553849179042e-09,
 -6.233387072336509e-11,  8.809289036102958e-13, -1.141509657450931e-14,  1.375021810894319e-16, -1.555476311595774e-18,  1.665518429573310e-20, -1.698329625317555e-22,
  5.006575194076953e-03, -2.816000365308456e-04,  9.248479581835792e-06, -2.272371748106787e-07,  4.600066020115105e-09, -8.069519587793921e-11,  1.264924986676527e-12,
 -1.808453603651123e-14,  2.392703136853966e-16, -2.961426132521148e-18,  3.457432768767976e-20, -3.832266980147052e-22,  3.202927381749992e-03, -2.110601380957343e-04,
  7.938736142014554e-06, -2.204197854735436e-07,  4.994288535085351e-09, -9.734198855073970e-11,  1.685309137403552e-12, -2.648075301401541e-14,  3.834227216608032e-16,
 -5.174295375847248e-18,  6.565178843401279e-20, -7.885222290329286e-22,  1.985516791764687e-03, -1.514963940240763e-04,  6.477359035262766e-06, -2.020379435100512e-07,
  5.098493893122838e-09, -1.099307086628493e-10,  2.093877203703140e-12, -3.602773033391174e-14,  5.689616330195089e-16, -8.345162537702253e-18,  1.147253367035098e-19,
 -1.488799204793674e-21,  1.194399495475416e-03, -1.044383999450341e-04,  5.040555623416746e-06, -1.756522361563664e-07,  4.913878357079659e-09, -1.167273604147359e-10,
  2.436981795237911e-12, -4.576125034116328e-14,  7.857220827595547e-16, -1.248840724588838e-17,  1.854963978027871e-19, -2.593888922845075e-21,  6.983362771361774e-04,
 -6.933732299839126e-05,  3.753112092717487e-06, -1.453626153649390e-07,  4.488190328796825e-09, -1.170053651892530e-10,  2.668165947495764e-12, -5.450330492298162e-14,
  1.014427070319316e-15, -1.742310275961651e-17,  2.788705251475981e-19, -4.191364387547406e-21,  3.975298226669650e-04, -4.445113756965289e-05,  2.682192132555350e-06,
 -1.148969892048050e-07,  3.899033008980640e-09, -1.111406129285521e-10,  2.759040342476709e-12, -6.112260418091555e-14,  1.229672861524712e-15, -2.276141094744409e-17,
  3.915846564561807e-19, -6.310550913892844e-21,  2.207392894833101e-04, -2.759052791154052e-05,  1.845434625360769e-06, -8.702806945669669e-08,  3.232980929089690e-09,
 -1.004069483125641e-10,  2.704811421898286e-12, -6.479434357583089e-14,  1.405162549237986e-15, -2.795926794425782e-17,  5.157587975392461e-19, -8.891430067068530e-21,
  1.198047512583748e-04, -1.662487452281873e-05,  1.226115373201178e-06, -6.337511871707716e-08,  2.567423354744332e-09, -8.658141440416208e-11,  2.523160514195767e-12,
 -6.517291992716407e-14,  1.519531888920052e-15, -3.242052934659816e-17,  6.397569564036487e-19, -1.177202236341888e-20,  6.369401382731305e-05, -9.751180759520882e-06,
  7.890460598349466e-07, -4.451337552597148e-08,  1.959331339925934e-09, -7.151108643872913e-11,  2.247711413239360e-12, -6.242896064460776e-14,  1.560862330170914e-15,
 -3.562344239926666e-17,  7.502589125000170e-19, -1.470317591653217e-20,  3.324800989218559e-05, -5.582954000653040e-06,  4.933298717895923e-07, -3.025371466001245e-08,
  1.441764796255204e-09, -5.676913934732014e-11,  1.918934629134930e-12, -5.715550818622133e-14,  1.528548807804837e-15, -3.722914324519940e-17,  8.349578834848086e-19,
 -1.738999644403908e-20,  1.708259749153912e-05, -3.129114070181501e-06,  3.005947863704626e-07, -1.996165845613555e-08,  1.026404437393174e-09, -4.346487146278138e-11,
  1.575534598778071e-12, -5.019137044780752e-14,  1.432246684468390e-15, -3.713990261084433e-17,  8.850501150044732e-19, -1.954883100854281e-20,  8.661789422416875e-06,
 -1.721912845439480e-06,  1.790624337049643e-07, -1.282842104659808e-08,  7.093326142132442e-10, -3.220701659126096e-11,  1.248429564484496e-12, -4.242630845546240e-14,
  1.288631569837723e-15, -3.549502207430008e-17,  8.967830866394509e-19, -2.096274016980329e-20,  4.346447954136386e-06, -9.331622033572258e-07,  1.046177661039781e-07,
 -8.056703477505365e-09,  4.774978570709680e-10, -2.317685750192829e-11,  9.580547035530429e-13, -3.464250769173333e-14,  1.117254414151783e-15, -3.261428287506449e-17,
  8.717077823795048e-19, -2.151942770213762e-20,  2.164722647901367e-06, -4.996033014714172e-07,  6.014696697179627e-08, -4.961582762775897e-09,  3.141820914268148e-10,
 -1.625423418539523e-11,  7.145513530755328e-13, -2.742104409502970e-14,  9.367486235435170e-16, -2.891328190886094e-17,  8.157410981358966e-19, -2.122266839303214e-20,
  1.073331372631304e-06, -2.651074710823560e-07,  3.414197163948475e-08, -3.006456790978227e-09,  2.027655765846781e-10, -1.114840937524444e-11,  5.197876184625785e-13,
 -2.111510143377271e-14,  7.622086874817296e-16, -2.481785399315785e-17,  7.374864533044482e-19, -2.017768786950973e-20,  5.314962735227719e-07, -1.398909139467920e-07,
  1.920065064124941e-08, -1.798764131439775e-09,  1.288064982254940e-10, -7.504623002430310e-12,  3.700874083526734e-13, -1.587342494371020e-14,  6.039938524063905e-16,
 -2.069799453289065e-17,  6.463777146924382e-19, -1.855857681848702e-20,  2.637007803176028e-07, -7.365449899234687e-08,  1.073500735368633e-08, -1.066362107061935e-09,
  8.082553647887978e-11, -4.975691300872274e-12,  2.588241035047137e-13, -1.169084165088904e-14,  4.677552924610742e-16, -1.683052328132223e-17,  5.511175775892131e-19,
 -1.656916554100975e-20,  1.315237283921508e-07, -3.882767495031354e-08,  5.987779014282735e-09, -6.286059467869289e-10,  5.027632317036483e-11, -3.260779401902458e-12,
  1.784247833114437e-13, -8.465178969469083e-15,  3.552523240275549e-16, -1.338941765930522e-17,  4.586703636298953e-19, -1.440771145120415e-20,  6.616467045317920e-08,
 -2.056414355163190e-08,  3.343662529816635e-09, -3.697604378914618e-10,  3.111053592015128e-11, -2.119589735486029e-12,  1.216645688948725e-13, -6.046949230887265e-15,
  2.655005572002595e-16, -1.045636232690958e-17,  3.738491134614589e-19, -1.224188689114554e-20,  3.368344644386945e-08, -1.097963368270425e-08,  1.875724685379787e-09,
 -2.177865590208972e-10,  1.921661715199073e-11, -1.371296175350490e-12,  8.233876837419945e-14, -4.275650605588562e-15,  1.959029329798227e-16, -8.042114659168756e-18,
  2.993815734456841e-19, -1.019604720452003e-20,  1.740923987142503e-08, -5.929464861454446e-09,  1.060618762917406e-09, -1.288734519627716e-10,  1.188822736676021e-11,
 -8.859149818398044e-13,  5.548701625110379e-14, -3.002131037718898e-15,  1.431652325436582e-16, -6.110566698234200e-18,  2.362726033441721e-19, -8.349244184632810e-21,
  9.163331115954768e-09, -3.249118981034500e-09,  6.064182539440173e-10, -7.685863324270204e-11,  7.389107865451023e-12, -5.733005465491681e-13,  3.734685486168746e-14,
 -2.099547146930663e-15,  1.039294194813881e-16, -4.600153108539519e-18,  1.842862909006989e-19, -6.740615357857976e-21,  4.925659670527902e-09, -1.811746805370285e-09,
  3.516180492981283e-10, -4.633132035601504e-11,  4.627473997534966e-12, -3.726716959546049e-13,  2.517649308801818e-14, -1.466457056554104e-15,  7.514454901428523e-17,
 -3.440088862007772e-18,  1.424175288794824e-19, -5.378491822763456e-21,  2.710641578059530e-09, -1.030624387952352e-09,  2.072748013560125e-10, -2.830026291322958e-11,
  2.927104663322950e-12, -2.439324298413456e-13,  1.703874034358232e-14, -1.025317373220087e-15,  5.423572435508596e-17, -2.561042744366337e-18,  1.092796538269886e-19,
 -4.250265827029860e-21,  1.529984308962688e-09, -5.992568701783764e-10,  1.244618483431445e-10, -1.754957642480048e-11,  1.873631624958477e-12, -1.610646108617750e-13,
  1.159699350194347e-14, -7.188387054682141e-16,  3.913940025292751e-17, -1.901066857261552e-18,  8.338258472064148e-20, -3.331133929436711e-21,  8.866490469954855e-10,
 -3.565368304282433e-10,  7.620917501861700e-11, -1.106006263779790e-11,  1.214837659152100e-12, -1.073823705672024e-13,  7.945290826716456e-15, -5.057707524112493e-16,
  2.826321005120940e-17, -1.408060018589827e-18,  6.330714814664887e-20, -2.590842933731174e-21,  5.274160965553811e-10, -2.170131390305107e-10,  4.757380346273176e-11,
 -7.082044039607410e-12,  7.976593829011675e-13, -7.226429472280851e-14,  5.477250184938874e-15, -3.569700041502955e-16,  2.041209536941766e-17, -1.040018561556989e-18,
  4.779656099740617e-20, -1.998299288491134e-21,  3.212927147855837e-10, -1.348308988245809e-10,  3.020966540006433e-11, -4.597106995013312e-12,  5.291502661008543e-13,
 -4.897211634863643e-14,  3.790159019671559e-15, -2.521128777647957e-16,  1.470675537929130e-17, -7.640745165922121e-19,  3.578980346410977e-20, -1.524321428324617e-21,
  1.993031619289568e-10, -8.502659438883500e-11,  1.940339436178481e-11, -3.007873141779420e-12,  3.526225991645890e-13, -3.322739110942161e-14,  2.617346386367937e-15,
 -1.771283757214583e-16,  1.050825589040477e-17, -5.550122421949692e-19,  2.641886083502269e-20, -1.142979654899053e-21,  1.243678406685966e-10, -5.376684579959015e-11,
  1.245351707066715e-11, -1.959750728363809e-12,  2.331918095569840e-13, -2.229723342588375e-14,  1.781722763180697e-15, -1.222805502927721e-16,  7.354524385506910e-18,
 -3.936825709957392e-19,  1.898646355275891e-20, -8.319710634949331e-22,  7.603732310221724e-11, -3.320685999493345e-11,  7.779373216588740e-12, -1.238381989749617e-12,
  1.490464488482236e-13, -1.441223864714544e-14,  1.164384774988834e-15, -8.077708142721973e-17,  4.909718759278812e-18, -2.655318230669594e-19,  1.293543758794186e-20,
 -5.723999430501147e-22,  4.262264353530563e-11, -1.874460487696045e-11,  4.426032488212997e-12, -7.102190285399346e-13,  8.615814449460745e-14, -8.396283218694998e-15,
  6.835449959027728e-16, -4.777534440860359e-17,  2.925137259041695e-18, -1.593342491685649e-19,  7.816391628326667e-21, -3.482406825690858e-22,  1.705622650683310e-11,
 -7.530140544743090e-12,  1.785845415026045e-12, -2.878398424190105e-13,  3.507258912893684e-14, -3.432737702739935e-15,  2.806507782630385e-16, -1.969744433934272e-17,
  1.210932102515037e-18, -6.622328962534320e-20,  3.261346605671878e-21, -1.458531628011261e-22,  6.312720423768667e-02, -1.655798251147629e-04,  4.515376589684881e-07,
 -1.270919300774905e-09,  3.661600334629146e-12, -1.071745186087655e-14,  3.167324062454225e-17, -9.409129015748658e-20,  2.800693817062462e-22, -8.336589162923425e-25,
  2.478039253475604e-27, -7.350789809614645e-30,  6.047995803560414e-02, -2.058974386339432e-04,  8.284311532212783e-07, -3.443325667426462e-09,  1.412090930533143e-11,
 -5.661892623562149e-14,  2.221644418397485e-16, -8.554901343133125e-19,  3.241267234859769e-21, -1.210850299552207e-23,  4.467406200196714e-26, -1.629948153288166e-28,
  5.551927040827955e-02, -2.757878062663185e-04,  1.587062418264131e-06, -8.677947046292213e-09,  4.484795519522323e-11, -2.217722951725905e-13,  1.058967116952401e-15,
 -4.912711904563133e-18,  2.223775357305823e-20, -9.853401309443516e-23,  4.284436619140531e-25, -1.831798079636723e-27,  4.884256579809534e-02, -3.571531742695816e-04,
  2.706646825778899e-06, -1.839248054278754e-08,  1.155739911107201e-10, -6.853667765017740e-13,  3.881840139390279e-15, -2.116729849565894e-17,  1.117629289755264e-19,
 -5.738692012436890e-22,  2.875230361385334e-24, -1.409396359675796e-26,  4.119115551675521e-02, -4.300119669362746e-04,  4.102110848915143e-06, -3.386495207423276e-08,
  2.540848655960046e-10, -1.775675853828044e-12,  1.173020134430454e-14, -7.398220976632439e-17,  4.486786795402449e-19, -2.630614041069505e-21,  1.497247425539965e-23,
 -8.299712344117559e-26,  3.331444886974732e-02, -4.780254073153845e-04,  5.606871534459653e-06, -5.543139788398933e-08,  4.898551568894354e-10, -3.982378168293170e-12,
  3.031189776356171e-14, -2.185843396514237e-16,  1.506018847517608e-18, -9.976652564811253e-21,  6.385494366400458e-23, -3.963855275132501e-25,  2.585246240484690e-02,
 -4.922473453360702e-04,  6.994597958010075e-06, -8.185236707799709e-08,  8.426996859381663e-10, -7.889530402927240e-12,  6.854290285995685e-14, -5.601393878838042e-16,
  4.347518525598614e-18, -3.227866510243705e-20,  2.305254530539754e-22, -1.590493553755587e-24,  1.926086231851125e-02, -4.721615016640245e-04,  8.034567624682754e-06,
 -1.101791398165025e-07,  1.309598493659385e-09, -1.400371023739862e-11,  1.378083910853995e-13, -1.267109799449619e-15,  1.100344610775707e-17, -9.096797205203926e-20,
  7.203812166249104e-22, -5.490822402656376e-24,  1.378687976454983e-02, -4.241900486482949e-04,  8.556324936610858e-06, -1.362858605254099e-07,  1.855787502369827e-09,
 -2.250763329768375e-11,  2.492786464993943e-13, -2.563336684378774e-15,  2.476313853055646e-17, -2.267158815122987e-19,  1.980402076286798e-21, -1.659202462887983e-23,
  9.489306188966363e-03, -3.586856384933255e-04,  8.495245394512455e-06, -1.559306678722111e-07,  2.416003990182454e-09, -3.303340485313429e-11,  4.094527632091495e-13,
 -4.684252950146154e-15,  5.009412996132252e-17, -5.055262365360066e-19,  4.849121066873363e-21, -4.446345552683991e-23,  6.286295599431495e-03, -2.866785907137576e-04,
  7.901748705877535e-06, -1.659413861345773e-07,  2.907775655265074e-09, -4.457732367359063e-11,  6.153273906418862e-13, -7.795728526268751e-15,  9.188947038955501e-17,
 -1.017922404808026e-18,  1.068002978817194e-20, -1.067735593713121e-22,  4.012497935672352e-03, -2.173811022035131e-04,  6.914888516898200e-06, -1.650556604145486e-07,
  3.252814128018037e-09, -5.563792261034604e-11,  8.514513670036126e-13, -1.189659794058762e-14,  1.539587697942719e-16, -1.865284453140185e-18,  2.133118055069246e-20,
 -2.317353769185819e-22,  2.470694009163378e-03, -1.569067914910200e-04,  5.715390203630135e-06, -1.541174355728045e-07,  3.398360592051210e-09, -6.456119292062989e-11,
  1.090873014101656e-12, -1.674572073786959e-14,  2.370929247089159e-16, -3.131097152208225e-18,  3.890397322826795e-20, -4.578582912170764e-22,  1.469572032155299e-03,
 -1.081394719893505e-04,  4.477794171598058e-06, -1.356297758835847e-07,  3.330260016055568e-09, -6.997444488791372e-11,  1.300473579664096e-12, -2.185621775685707e-14,
  3.374440599457183e-16, -4.842586856395408e-18,  6.518229180793956e-20, -8.287216992053122e-22,  8.456218207885585e-04, -7.136743917203351e-05,  3.336636900755283e-06,
 -1.129181249207746e-07,  3.073511118945428e-09, -7.114365819664175e-11,  1.449129434073313e-12, -2.657662876346302e-14,  4.460791212855395e-16, -6.936441125606977e-18,
  1.008693965950216e-19, -1.381811974818740e-21,  4.715038311941522e-04, -4.522661914542223e-05,  2.372400102343353e-06, -8.925274868094319e-08,  2.681581623945727e-09,
 -6.812500106941135e-11,  1.515725904444014e-12, -3.024038983173941e-14,  5.502162214261717e-16, -9.245525423807191e-18,  1.448808593681003e-19, -2.133280615486285e-21,
  2.552089509877918e-04, -2.759627286043965e-05,  1.614620263148123e-06, -6.720779280907112e-08,  2.219885858761957e-09, -6.167548947744525e-11,  1.494080510470532e-12,
 -3.233209938401418e-14,  6.359506703569405e-16, -1.151800713535674e-17,  1.940241042856396e-19, -3.063595605541170e-21,  1.343557774094152e-04, -1.625745947996261e-05,
  1.055131695026145e-06, -4.837448967558351e-08,  1.749819540551362e-09, -5.298591006058704e-11,  1.393255916462904e-12, -3.261035663273259e-14,  6.915870404448954e-16,
 -1.346743656900646e-17,  2.433036926567792e-19, -4.110524813748770e-21,  6.894257011921561e-05, -9.272567637045795e-06,  6.641163954675203e-07, -3.339301875969511e-08,
  1.317932674747504e-09, -4.335313993736008e-11,  1.233700650947388e-12, -3.114677725276865e-14,  7.104004056102738e-16, -1.483850640255734e-17,  2.868535867507244e-19,
 -5.174265652655785e-21,  3.456091172534535e-05, -5.134755775622566e-06,  4.038694788751919e-07, -2.218097804911545e-08,  9.517766279462763e-10, -3.390355142347441e-11,
  1.041123010888900e-12, -2.827690248890637e-14,  6.919074432599095e-16, -1.546594332713461e-17,  3.192271436987276e-19, -6.135074665838112e-21,  1.696767029618286e-05,
 -2.768711613084865e-06,  2.380547732214350e-07, -1.422478782913315e-08,  6.613416715241589e-10, -2.543204968783367e-11,  8.404008103454867e-13, -2.449159038971636e-14,
  6.413712233112053e-16, -1.530707900656048e-17,  3.366160034913949e-19, -6.878529819790641e-21,  8.179922722214255e-06, -1.458094313513460e-06,  1.364464306500484e-07,
 -8.837431515351675e-09,  4.436962701332219e-10, -1.836461634806354e-11,  6.512396914684311e-13, -2.031263565281965e-14,  5.679390233019752e-16, -1.443996116388729e-17,
  3.376024247335345e-19, -7.320277718636851e-21,  3.883247479149945e-06, -7.523278045411552e-07,  7.630357464968463e-08, -5.337337755383244e-09,  2.884399323460238e-10,
 -1.281190153029380e-11,  4.862403587684677e-13, -1.619121206568819e-14,  4.822085174228302e-16, -1.303214266122102e-17,  3.232488763155340e-19, -7.422424817693050e-21,
  1.820816852470742e-06, -3.815586774218290e-07,  4.177490503173592e-08, -3.144693961864754e-09,  1.823483411778216e-10, -8.666898307384185e-12,  3.510889171577442e-13,
 -1.244987013654614e-14,  3.940239613091206e-16, -1.129427031443769e-17,  2.965833810162998e-19, -7.197275186163506e-21,  8.459498519078964e-07, -1.908641823018125e-07,
  2.247033709594322e-08, -1.814097384900109e-09,  1.125180353993353e-10, -5.706152821006035e-12,  2.460696691746668e-13, -9.269252125939922e-15,  3.110190806813909e-16,
 -9.434371140698294e-18,  2.617285373665348e-19, -6.698936353383460e-21,  3.907360730155546e-07, -9.449935718327342e-08,  1.191813853925080e-08, -1.028447997057333e-09,
  6.802124152174385e-11, -3.670197251590487e-12,  1.680401711818924e-13, -6.707434818478993e-15,  2.380459673115473e-16, -7.624407115688085e-18,  2.229807809374740e-19,
 -6.007134691007556e-21,  1.800536292270506e-07, -4.647934306915126e-08,  6.256572292275777e-09, -5.751623333556789e-10,  4.044146951822501e-11, -2.315062620109728e-12,
  1.122382300467483e-13, -4.735352696517802e-15,  1.773319627885882e-16, -5.983693409512849e-18,  1.840835836139155e-19, -5.209048005642384e-21,  8.307601978207825e-08,
 -2.279553826765421e-08,  3.263293498435296e-09, -3.185391012527537e-10,  2.373844894536868e-11, -1.437621393819577e-12,  7.360633389788060e-14, -3.274127113452859e-15,
  1.290670551428755e-16, -4.577593152789399e-18,  1.478127155761967e-19, -4.384087708689132e-21,  3.852353062382331e-08, -1.119095950392842e-08,  1.697692268556078e-09,
 -1.753879776039251e-10,  1.381087192385553e-11, -8.823243852700188e-13,  4.757932305555143e-14, -2.225630924020294e-15,  9.212884629498169e-17, -3.426416463035185e-18,
  1.158691299006622e-19, -3.594338962082208e-21,  1.802203314608582e-08, -5.520826043280849e-09,  8.844076778724744e-10, -9.638563983514708e-11,  7.995370569875557e-12,
 -5.372891970754268e-13,  3.043185920330186e-14, -1.493086007029690e-15,  6.473904478849025e-17, -2.518802147693537e-18,  8.899690633047734e-20, -2.881013777327938e-21,
  8.538241761429145e-09, -2.747611977360568e-09,  4.631716904697805e-10, -5.307664407839622e-11,  4.623789790511686e-12, -3.258830887758606e-13,  1.933322324103256e-14,
 -9.922626245910993e-16,  4.495096096329374e-17, -1.825091238010635e-18,  6.721898960200082e-20, -2.265632243041179e-21,  4.112083989752089e-09, -1.384824732562583e-09,
  2.447968427583601e-10, -2.939982587915641e-11,  2.681372062168227e-12, -1.976186036378930e-13,  1.224506769754958e-14, -6.556448877698437e-16,  3.095112226286954e-17,
 -1.308114078368480e-18,  5.009831607021857e-20, -1.753983094594887e-21,  2.020569414679105e-09, -7.094799732340200e-10,  1.310576470057385e-10, -1.644159455287321e-11,
  1.564968709572609e-12, -1.202468867590067e-13,  7.759634433071500e-15, -4.322398310737154e-16,  2.120617882929128e-17, -9.305288696445563e-19,  3.696485501129158e-20,
 -1.341039968657052e-21,  1.016471311918349e-09, -3.707735466763656e-10,  7.132243327158460e-11, -9.315397615996330e-12,  9.224092204122346e-13, -7.366389868907335e-14,
  4.935955160909283e-15, -2.852274529426904e-16,  1.450312027152480e-17, -6.589744957231347e-19,  2.708239882850160e-20, -1.015551584201303e-21,  5.251193036723876e-10,
 -1.982699071337038e-10,  3.957744692967659e-11, -5.363534591665165e-12,  5.507088453770204e-13, -4.556742053836218e-14,  3.160859488362512e-15, -1.889254807409540e-16,
  9.928013183085556e-18, -4.658180980327491e-19,  1.975317645267459e-20, -7.636434896036230e-22,  2.792865050758538e-10, -1.087663823971686e-10,  2.245070673758130e-11,
 -3.146134247883748e-12,  3.338571427669344e-13, -2.853018067372037e-14,  2.042413629050257e-15, -1.258896645499272e-16,  6.817083661285859e-18, -3.293605602193264e-19,
  1.437147533030127e-20, -5.712617834035185e-22,  1.531758037327730e-10, -6.131446655931413e-11,  1.304080936380709e-11, -1.883180380857656e-12,  2.058383134592055e-13,
 -1.810767821488579e-14,  1.333562160560394e-15, -8.450520811097984e-17,  4.701426443213059e-18, -2.332162044754003e-19,  1.044165528430699e-20, -4.255879509458870e-22,
  8.666339592113446e-11, -3.553356636669836e-11,  7.759593069787760e-12, -1.150648533122467e-12,  1.291043628266113e-13, -1.165259811873734e-14,  8.799877071410927e-16,
 -5.714800512034512e-17,  3.256509372110313e-18, -1.653638492585181e-19,  7.574766801770137e-21, -3.156801150549771e-22,  5.049556136730719e-11, -2.113525678159979e-11,
  4.721813116978547e-12, -7.164494004989833e-13,  8.223111179797091e-14, -7.589065300842500e-15,  5.857440584617663e-16, -3.885850555898311e-17,  2.260882784567866e-18,
 -1.171645061413952e-19,  5.474535261493579e-21, -2.326068982333101e-22,  3.014403204758740e-11, -1.283644605675563e-11,  2.923347043162252e-12, -4.522392054387903e-13,
  5.290986796471783e-14, -4.975747211797623e-15,  3.911817514163952e-16, -2.642295011573299e-17,  1.564660382836509e-18, -8.249137326907427e-20,  3.919732422440385e-21,
 -1.692928530912699e-22,  1.822251375031926e-11, -7.868533367100611e-12,  1.820070896219650e-12, -2.860280494787950e-13,  3.398909409583051e-14, -3.245688469640933e-15,
  2.590228446443036e-16, -1.775458200820055e-17,  1.066536946397642e-18, -5.702282523835571e-20,  2.746885812484117e-21, -1.202299329925644e-22,  1.086926464576132e-11,
 -4.743439274417319e-12,  1.110360611188232e-12, -1.766134890523995e-13,  2.123949735485585e-14, -2.052170586000936e-15,  1.656704058371767e-16, -1.148445299277326e-17,
  6.975252354014697e-19, -3.769713988539873e-20,  1.835137936166363e-21, -8.115044403477354e-23,  5.988137767347786e-12, -2.632500320774986e-12,  6.213363007186642e-13,
 -9.966017681076709e-14,  1.208493172587585e-14, -1.177215842641794e-15,  9.579888279667597e-17, -6.693062024589181e-18,  4.096362626586750e-19, -2.230467185322898e-20,
  1.093782473747747e-21, -4.871311607928187e-23,  2.373116811378131e-12, -1.047521383570424e-12,  2.483800621717038e-13, -4.002533046106927e-14,  4.875993071297227e-15,
 -4.771422415812634e-16,  3.900196861331436e-17, -2.736808126152349e-18,  1.682169161220176e-19, -9.197658147129014e-21,  4.528781269110919e-22, -2.024974631732806e-23,
  6.247201433481369e-02, -1.620275480407266e-04,  4.366311988564505e-07, -1.214008063690239e-09,  3.454644594817504e-12, -9.987923090699840e-15,  2.915977663647886e-17,
 -8.559074174322316e-20,  2.517666131827781e-22, -7.407103377800682e-25,  2.176437587425937e-27, -6.382727919499729e-30,  5.966936679805666e-02, -1.994315123710641e-04,
  7.884304006803402e-07, -3.226168382748754e-09,  1.303996890246364e-11, -5.156309467950329e-14,  1.995996545721709e-16, -7.584127425995386e-19,  2.835870988796968e-21,
 -1.045703542062143e-23,  3.808708214211423e-26, -1.371996951159755e-28,  5.444086944613911e-02, -2.634959780833946e-04,  1.487090436373481e-06, -7.994527800438432e-09,
  4.065592145814890e-11, -1.979305070169211e-13,  9.308631306080368e-16, -4.254703163124639e-18,  1.898053409914075e-20, -8.290496645961178e-23,  3.554333562093204e-25,
 -1.498630155516250e-27,  4.745590466888713e-02, -3.363524124461198e-04,  2.496595683613295e-06, -1.664808792845528e-08,  1.027523001980930e-10, -5.989290153097944e-13,
  3.336271292062948e-15, -1.790039470850969e-17,  9.303264495212364e-20, -4.703621483784469e-22,  2.321113047020302e-24, -1.120905147238537e-26,  3.953426181742700e-02,
 -3.987540897920243e-04,  3.718999316903576e-06, -3.006908238157867e-08,  2.212268332707913e-10, -1.517470164274277e-12,  9.846255140529101e-15, -6.103091881203150e-17,
  3.639313386237398e-19, -2.098822958098341e-21,  1.175429988901771e-23, -6.413319809484997e-26,  3.148802483384113e-02, -4.357037078953851e-04,  4.986215063878677e-06,
 -4.819335619682723e-08,  4.170134974907474e-10, -3.323206243678574e-12,  2.481556554321499e-14, -1.756775214253017e-16,  1.188921257285815e-18, -7.739913700789765e-21,
  4.870237035971293e-23, -2.973258605510876e-25,  2.398947429751653e-02, -4.400016977395537e-04,  6.088337239792624e-06, -6.954717986876531e-08,  7.001658898017783e-10,
 -6.418000262956801e-12,  5.464393349379842e-14, -4.379600405357510e-16,  3.335878390760029e-18, -2.431897481628983e-20,  1.706118567149158e-22, -1.156802573810816e-24,
  1.749287200258893e-02, -4.128375238245977e-04,  6.829447738529238e-06, -9.129783934803915e-08,  1.059917977658710e-09, -1.108510751094065e-11,  1.068036136379218e-13,
 -9.622761861304904e-16,  8.193879835683056e-18, -6.646303995365721e-20,  5.166619956322782e-22, -3.867497716802303e-24,  1.221733308063902e-02, -3.618086109043828e-04,
  7.085185125697557e-06, -1.098923059160084e-07,  1.460080717779833e-09, -1.730371164733229e-11,  1.874733735019836e-13, -1.887538158978079e-15,  1.786720375459838e-17,
 -1.603877521429428e-19,  1.374429002443404e-21, -1.130217400541853e-23,  8.179502491790037e-03, -2.975981450719322e-04,  6.835826797904853e-06, -1.220675604932748e-07,
  1.843850057569464e-09, -2.461487357305793e-11,  2.982461983649495e-13, -3.338508090921586e-15,  3.496120497651302e-17, -3.457222848092956e-19,  3.251542669068243e-21,
 -2.924841631947448e-23,  5.254431068165483e-03, -2.307017627022740e-04,  6.162587361388416e-06, -1.258156042919805e-07,  2.147810634144760e-09, -3.212768372342188e-11,
  4.332430404827996e-13, -5.367530898747054e-15,  6.192126871991480e-17, -6.718273777198710e-19,  6.908087914281088e-21, -6.772287255975617e-23,  3.242213541645496e-03,
 -1.691777806676035e-04,  5.213079282248542e-06, -1.209063895586323e-07,  2.320056358853116e-09, -3.870024984976202e-11,  5.782930428248714e-13, -7.897724875452562e-15,
  9.998889886000247e-17, -1.186003805477557e-18,  1.328725365453623e-20, -1.414971533893960e-22,  1.923986497436996e-03, -1.177465769821561e-04,  4.153819882874529e-06,
 -1.087961891596375e-07,  2.334991962571166e-09, -4.324379106147723e-11,  7.131976533025538e-13, -1.069737299098883e-14,  1.481207387724158e-16, -1.914489515029275e-18,
  2.329726019223267e-20, -2.686963578506379e-22,  1.099502296452945e-03, -7.801781119435257e-05,  3.128732041377213e-06, -9.203372703085383e-08,  2.198997724478637e-09,
 -4.503128511954250e-11,  8.166789626217093e-13, -1.340779652118190e-14,  2.023991531920599e-16, -2.842173347193528e-18,  3.746030211430248e-20, -4.666504592161042e-22,
  6.060081960891872e-04, -4.935542801826919e-05,  2.235215387491831e-06, -7.346196012587487e-08,  1.945603092576925e-09, -4.388685744617511e-11,  8.722181474624947e-13,
 -1.562407132467348e-14,  2.563754624254512e-16, -3.900468340806235e-18,  5.553434628121483e-20, -7.453349955459437e-22,  3.226803435966059e-04, -2.989416531158994e-05,
  1.519530568504720e-06, -5.552660911080119e-08,  1.623380224674391e-09, -4.019044610947363e-11,  8.724775266881138e-13, -1.700161158507948e-14,  3.024110194095763e-16,
 -4.971680600380177e-18,  7.627789058816583e-20, -1.100355412728219e-21,  1.662930933053872e-04, -1.738394043373651e-05,  9.860897999668035e-07, -3.988027387122103e-08,
  1.282060897951090e-09, -3.471700973824134e-11,  8.206744964405293e-13, -1.734768329275344e-14,  3.336026260941726e-16, -5.911880137525265e-18,  9.751117876934856e-20,
 -1.508561398540364e-21,  8.311051815450610e-05, -9.732542083510010e-06,  6.127836442757706e-07, -2.730891667356538e-08,  9.617648904644506e-10, -2.839273511681384e-11,
  7.286960180675901e-13, -1.666370453928787e-14,  3.455761568668450e-16, -6.585700286986595e-18,  1.165175453716425e-19, -1.929065598822189e-21,  4.037107022734350e-05,
 -5.260772769000056e-06,  3.658084735838245e-07, -1.788977721821365e-08,  6.877549854361381e-10, -2.206504709962031e-11,  6.130763577937980e-13, -1.512710919371082e-14,
  3.374850725093588e-16, -6.900528647595403e-18,  1.306754407229230e-19, -2.310482181785774e-21,  1.910526032416476e-05, -2.753490818045215e-06,  2.104496673110049e-07,
 -1.124949589769310e-08,  4.704736468967584e-10, -1.635358759220078e-11,  4.905589348245274e-13, -1.302696714346734e-14,  3.119178250933997e-16, -6.827670828062555e-18,
  1.381000733842803e-19, -2.602471644310525e-21,  8.831341130067088e-06, -1.399723408165848e-06,  1.170616006603186e-07, -6.813713826686873e-09,  3.089716890229844e-10,
 -1.160151317398983e-11,  3.747048200430746e-13, -1.068247738147895e-14,  2.738804176528824e-16, -6.404021069099074e-18,  1.380668963371572e-19, -2.767659621954964e-21,
  3.998556156844798e-06, -6.932599828465680e-07,  6.317106776307786e-08, -3.989188171177465e-09,  1.955028546131220e-10, -7.906956394240205e-12,  2.742405764646140e-13,
 -8.373041017141223e-15,  2.293366336739921e-16, -5.716002912873422e-18,  1.310877228236852e-19, -2.789807006909466e-21,  1.778629564887030e-06, -3.356451875896425e-07,
  3.318757215789139e-08, -2.265701894480991e-09,  1.196302132511276e-10, -5.196646780054394e-12,  1.930462029986229e-13, -6.296974249364505e-15,  1.838406047874096e-16,
 -4.873740575478144e-18,  1.186553870069822e-19, -2.675783711934999e-21,  7.797733853503289e-07, -1.594041333836795e-07,  1.703564465237070e-08, -1.253007756621934e-09,
  7.105986991853118e-11, -3.306099149249346e-12,  1.312043650245747e-13, -4.561363432896632e-15,  1.416266004381691e-16, -3.985140589332691e-18,  1.027889979095036e-19,
 -2.451448263077721e-21,  3.380944544723246e-07, -7.452989602890680e-08,  8.576305791467832e-09, -6.773364761662223e-10,  4.113305282171197e-11, -2.044022692587393e-12,
  8.643627265208590e-14, -3.195033763352538e-15,  1.052653308073619e-16, -3.137138703822329e-18,  8.555227236536923e-20, -2.153648853747620e-21,  1.455021917782982e-07,
 -3.443684198272110e-08,  4.251042859423138e-09, -3.593153915298674e-10,  2.329565716482737e-11, -1.233026302639441e-12,  5.541706372000489e-14, -2.172744439768395e-15,
  7.578618899145486e-17, -2.386988927873319e-18,  6.868302716994385e-20, -1.821391551206679e-21,  6.239105701658551e-08, -1.578698718508722e-08,  2.083053241371159e-09,
 -1.878201446874681e-10,  1.296157803263518e-11, -7.287130526872164e-13,  3.471886866792109e-14, -1.440321413057047e-15,  5.306544579962985e-17, -1.762513528510878e-18,
  5.339784253797106e-20, -1.488728087581188e-21,  2.676288184555954e-08, -7.210172378754270e-09,  1.013276582574394e-09, -9.714657654508387e-11,  7.114829823219695e-12,
 -4.236985936982438e-13,  2.134370446938294e-14, -9.345892994751196e-16,  3.628495894550408e-17, -1.268052429957249e-18,  4.036378436998886e-20, -1.180668787917199e-21,
  1.153197092265018e-08, -3.294632030208601e-09,  4.914059584503377e-10, -4.993417693128683e-11,  3.869509436183205e-12, -2.434015529446464e-13,  1.292974039907009e-14,
 -5.960836094916050e-16,  2.432917587829028e-17, -8.925539073569785e-19,  2.978513682766412e-20, -9.121419481090639e-22,  5.012881544939595e-09, -1.512763562228357e-09,
  2.386359809954300e-10, -2.561824712398724e-11,  2.094196883806017e-12, -1.387472898031193e-13,  7.751289221659031e-15, -3.752695124861882e-16,  1.606249897544301e-17,
 -6.171575171574908e-19,  2.154222550240767e-20, -6.891814196668615e-22,  2.207840528541210e-09, -7.010523383847855e-10,  1.165549805739625e-10, -1.317620459918341e-11,
  1.132770325950886e-12, -7.881918641554929e-14,  4.618156894196346e-15, -2.341789646249348e-16,  1.048510795487772e-17, -4.209011074789881e-19,  1.533172804187779e-20,
 -5.112527811814811e-22,  9.895320948875015e-10, -3.293484368321049e-10,  5.750877036427751e-11, -6.823645043632097e-12,  6.150414334129543e-13, -4.481214296786383e-14,
  2.745966253481231e-15, -1.454489988333223e-16,  6.794591673285161e-18, -2.842554495322200e-19,  1.077924364505046e-20, -3.737838849836787e-22,  4.532373107638014e-10,
 -1.575288004472602e-10,  2.878808864125982e-11, -3.573363963143260e-12,  3.366124280929170e-13, -2.560423741188757e-14,  1.636127696920843e-15, -9.027363540769307e-17,
  4.388108182766001e-18, -1.908260865358676e-19,  7.514492614641063e-21, -2.703135235587491e-22,  2.130220720267656e-10, -7.702869902906314e-11,  1.468067724205560e-11,
 -1.899898829395047e-12,  1.864442505683116e-13, -1.475971550252748e-14,  9.806118760898210e-16, -5.619836033588157e-17,  2.834661662889538e-18, -1.277949344973000e-19,
  5.212327609636870e-21, -1.940187032431650e-22,  1.031215738729723e-10, -3.865218163440241e-11,  7.655287546746614e-12, -1.029388903206842e-12,  1.048899286944485e-13,
 -8.614546818753776e-15,  5.932476234461941e-16, -3.520955697145577e-17,  1.837622027159379e-18, -8.564779502152995e-20,  3.608462779293102e-21, -1.386258396320187e-22,
  5.158065633541386e-11, -1.996767056284508e-11,  4.094936022519440e-12, -5.701458740179789e-13,  6.011929589632179e-14, -5.105853947743646e-15,  3.633191133274818e-16,
 -2.226310243321099e-17,  1.198711211493808e-18, -5.759375392492468e-20,  2.499530768591737e-21, -9.883581958421961e-23,  2.672126306228225e-11, -1.064507946510891e-11,
  2.252282051994567e-12, -3.235506949771871e-13,  3.518425360736480e-14, -3.079697402258090e-15,  2.257027527829921e-16, -1.423446712904893e-17,  7.882731511410549e-19,
 -3.892683977477923e-20,  1.735224286985546e-21, -7.042501006330642e-23,  1.435205748269504e-11, -5.862836815277371e-12,  1.275090289840374e-12, -1.883099459325133e-13,
  2.104401577989605e-14, -1.891935315744369e-15,  1.423304980154894e-16, -9.208801617092100e-18,  5.228505680491005e-19, -2.645640047548765e-20,  1.207716669281107e-21,
 -5.016397093960774e-23,  7.983825381456718e-12, -3.332505459226064e-12,  7.422527318717072e-13, -1.122798671955319e-13,  1.284829824118666e-14, -1.182275502967741e-15,
  9.098921641688315e-17, -6.019372506216636e-18,  3.492670640053124e-19, -1.805181910969095e-20,  8.412937100823732e-22, -3.565584591851119e-23,  4.579028102943449e-12,
 -1.946152826757974e-12,  4.422609090429162e-13, -6.826937913549533e-14,  7.970155744191300e-15, -7.479624112699862e-16,  5.868302718640885e-17, -3.955938055330996e-18,
  2.337999080307528e-19, -1.230298166751063e-20,  5.835215979915045e-22, -2.515709699907143e-23,  2.677746852797529e-12, -1.154798806821714e-12,  2.667395028491213e-13,
 -4.185897677345789e-14,  4.967159858097186e-15, -4.736698991887830e-16,  3.775033533185397e-17, -2.584168862170781e-18,  1.550343740242681e-19, -8.278588588457634e-21,
  3.983063302226271e-22, -1.741297426266041e-23,  1.556438066589098e-12, -6.787367472041299e-13,  1.587480405913561e-13, -2.522901847302367e-14,  3.031494300017357e-15,
 -2.926634629332781e-16,  2.360749893077745e-17, -1.635208623426045e-18,  9.924039457631787e-20, -5.359329942784105e-21,  2.607066134222437e-22, -1.152030361632914e-23,
  8.420539043540978e-13, -3.700410333716856e-13,  8.730113723768207e-14, -1.399663805673543e-14,  1.696510737791680e-15, -1.651892084915228e-16,  1.343700729811516e-17,
 -9.383980071040770e-19,  5.740958270153696e-20, -3.124706590757955e-21,  1.531705864961378e-22, -6.819073364736733e-24,  3.303284902798669e-13, -1.457843312847858e-13,
  3.456008383777648e-14, -5.568024620024901e-15,  6.781684479277593e-16, -6.634855342301253e-17,  5.422259633546557e-18, -3.804079134724830e-19,  2.337693387640714e-20,
 -1.277936080474298e-21,  6.291127663170924e-23, -2.812441926904685e-24,  6.183079928409371e-02, -1.585918461121837e-04,  4.223882769272921e-07, -1.160294592273620e-09,
  3.261694962197515e-12, -9.315960604167432e-15,  2.687213527134630e-17, -7.794459112009139e-20,  2.266027226491594e-22, -6.590156684014077e-25,  1.914351542556107e-27,
 -5.550963791176363e-30,  5.888401535228912e-02, -1.932754550964590e-04,  7.509350092752141e-07, -3.025525737461137e-09,  1.205494240391937e-11, -4.701761275719961e-14,
  1.795800044067767e-16, -6.734054981390945e-19,  2.485446195138919e-21, -9.047684269169956e-24,  3.253671472281795e-26, -1.157359223781857e-28,  5.341008662159059e-02,
 -2.519722266804885e-04,  1.394932261283420e-06, -7.374527397063972e-09,  3.691141215533864e-11, -1.769534012813866e-13,  8.198048807093469e-16, -3.692459290736671e-18,
  1.623674284609992e-20, -6.992302440811260e-23,  2.956231004211497e-25, -1.229407525692606e-27,  4.614921358658901e-02, -3.171516895014788e-04,  2.306301197070321e-06,
 -1.509569382366485e-08,  9.153550136499232e-11, -5.245516594435268e-13,  2.874315644569921e-15, -1.517728130134127e-17,  7.765845249152337e-20, -3.866752526658642e-22,
  1.879710140419427e-24, -8.944370012587870e-27,  3.799654620883516e-02, -3.703874634410565e-04,  3.378446632161237e-06, -2.675996696055206e-08,  1.931086293727129e-10,
 -1.300417156392947e-12,  8.289688175239749e-15, -5.050853842145768e-17,  2.961983764212427e-19, -1.680572550598291e-21,  9.262824623631436e-24, -4.975358195201880e-26,
  2.982148047675702e-02, -3.980186898466541e-04,  4.445835199636140e-06, -4.202209201211194e-08,  3.561278447458603e-10, -2.782605803947248e-12,  2.038988263941885e-14,
 -1.417384192751900e-16,  9.424111457870168e-19, -6.030296855850939e-21,  3.731129940429665e-23, -2.240591864678402e-25,  2.232185187768366e-02, -3.944521316028469e-04,
  5.316971051086676e-06, -5.930411226175133e-08,  5.839862072243017e-10, -5.242402104221531e-12,  4.375275550349453e-14, -3.439960184086867e-16,  2.571884672735433e-18,
 -1.841346137226913e-20,  1.269242044422799e-22, -8.458877954601316e-25,  1.594424031608441e-02, -3.623119284486333e-04,  5.828736953129951e-06, -7.598215177904757e-08,
  8.618104919049529e-10, -8.817592562145680e-12,  8.319765997931244e-14, -7.346767207848866e-16,  6.135543303793972e-18, -4.883844988165928e-20,  3.727557927678667e-22,
 -2.740797363791453e-24,  1.087563767543356e-02, -3.100296167130256e-04,  5.895970199017783e-06, -8.907201479327832e-08,  1.155031728396803e-09, -1.337893424051230e-11,
  1.418291592851057e-13, -1.398462310278971e-15,  1.297362804169194e-17, -1.142087513085293e-19,  9.603101285226551e-22, -7.752161953670257e-24,  7.089867716801425e-03,
 -2.483042832825514e-04,  5.532957982301555e-06, -9.614507339773344e-08,  1.416167570129914e-09, -1.846294507332368e-11,  2.187249128996640e-13, -2.396102233790276e-15,
  2.457599982758857e-17, -2.381863774653963e-19,  2.196842315721888e-21, -1.938913133856332e-23,  4.421428137234971e-03, -1.869014102390848e-04,  4.839485166388559e-06,
 -9.607345372086786e-08,  1.598130587870878e-09, -2.333000979814721e-11,  3.074059023867122e-13, -3.725024013317798e-15,  4.206572853176370e-17, -4.470844441335922e-19,
  4.506124977963069e-21, -4.332465134559128e-23,  2.640541894142427e-03, -1.326998713703074e-04,  3.961637752115816e-06, -8.929258660872768e-08,  1.668643279501430e-09,
 -2.714935689472329e-11,  3.961994680758143e-13, -5.289700710278554e-15,  6.552668231280420e-17, -7.610485927188098e-19,  8.354188825863449e-21, -8.721927102680766e-23,
  1.512009811856609e-03, -8.916327465318824e-05,  3.046639762412757e-06, -7.751827412834907e-08,  1.619541474094202e-09, -2.924354319987359e-11,  4.708277465863902e-13,
 -6.901247242965833e-15,  9.346498066330044e-17, -1.182501168680481e-18,  1.409489792678054e-20, -1.593273555701380e-22,  8.312583754980083e-04, -5.686955917344263e-05,
  2.208840584577755e-06, -6.310541123584202e-08,  1.467382021235008e-09, -2.928925168542141e-11,  5.184038987100168e-13, -8.314848873273676e-15,  1.227372737003118e-16,
 -1.686667188579373e-18,  2.177016530294716e-20, -2.657447594299358e-22,  4.394344658487498e-04, -3.453066961570730e-05,  1.514799078771703e-06, -4.835042055357695e-08,
  1.246054580706399e-09, -2.739212557777622e-11,  5.312120352736223e-13, -9.294927431239462e-15,  1.491182990306737e-16, -2.219823742650737e-18,  3.094684103038864e-20,
 -4.069451739073139e-22,  2.237474039681805e-04, -2.001606686275265e-05,  9.858162878394715e-07, -3.498939626950371e-08,  9.954256772361540e-10, -2.401646386103176e-11,
  5.087121720794932e-13, -9.682632475051448e-15,  1.683758122528367e-16, -2.708383113222436e-18,  4.068540922663620e-20, -5.750249982637920e-22,  1.099344600935510e-04,
 -1.110731149862168e-05,  6.107536518131010e-07, -2.399758620962806e-08,  7.508264838384316e-10, -1.981597728989438e-11,  4.570956843753055e-13, -9.438158479387928e-15,
  1.774494054767517e-16, -3.076910518940696e-18,  4.969314598822671e-20, -7.532519424244475e-22,  5.222874376207631e-05, -5.917189472807023e-06,  3.613600021441200e-07,
 -1.565197259205742e-08,  5.366375920180976e-10, -1.544402539691272e-11,  3.868519169525846e-13, -8.642734279750897e-15,  1.752620708731201e-16, -3.268525084854237e-18,
  5.663092440766332e-20, -9.187638864373522e-22,  2.404693753125383e-05, -3.034924844613137e-06,  2.048359273944081e-07, -9.741328980250840e-09,  3.647340293276936e-10,
 -1.141143408848920e-11,  3.095473333300736e-13, -7.463946568791736e-15,  1.628701836229679e-16, -3.259709443287783e-18,  6.046481986108746e-20, -1.047861077874819e-21,
  1.075599130965296e-05, -1.503144250328569e-06,  1.116042632652926e-07, -5.805101305014853e-09,  2.365790660413555e-10, -8.023242971278038e-12,  2.350640728464350e-13,
 -6.102445343379856e-15,  1.429648929362310e-16, -3.064201346118886e-18,  6.072827078875747e-20, -1.122047997066424e-21,  4.686446011395939e-06, -7.211493495510164e-07,
  5.864381211338470e-08, -3.324069312249080e-09,  1.469789324242695e-10, -5.387652795913339e-12,  1.700439565618352e-13, -4.741553029135201e-15,  1.189970503709134e-16,
 -2.725657814014441e-18,  5.760238636767226e-20, -1.132573735988021e-21,  1.994810075009903e-06, -3.362335416227647e-07,  2.982232395398445e-08, -1.835559191766795e-09,
  8.778526341601002e-11, -3.468380819575839e-12,  1.176281316824907e-13, -3.514756671832534e-15,  9.428724749387206e-17, -2.303267674630367e-18,  5.180431722604920e-20,
 -1.081915808441243e-21,  8.321282313515050e-07, -1.528776852910286e-07,  1.473032580580270e-08, -9.811316511614114e-10,  5.059764909290761e-11, -2.148856876624495e-12,
  7.811371120296541e-14, -2.495339225409393e-15,  7.139853411775840e-17, -1.856316830785313e-18,  4.434938211578121e-20, -9.820109606009756e-22,  3.413359970221711e-07,
 -6.803208588029966e-08,  7.093798340561724e-09, -5.096012642403350e-10,  2.825462199571738e-11, -1.286366961916676e-12,  4.999668408953991e-14, -1.703569690426718e-15,
  5.187800573947101e-17, -1.432624478794800e-18,  3.628623913644002e-20, -8.502947900114366e-22,  1.381837729957235e-07, -2.974525544321792e-08,  3.343959872189256e-09,
 -2.582433056898348e-10,  1.534855270980921e-11, -7.470947365274276e-13,  3.096936305015521e-14, -1.122959483101090e-15,  3.631689652807416e-17, -1.063048815350615e-18,
  2.848984474600483e-20, -7.051900562167200e-22,  5.542455836446786e-08, -1.282963166865357e-08,  1.549382395380088e-09, -1.282168483728537e-10,  8.145100578495473e-12,
 -4.227409551174803e-13,  1.864367593605135e-14, -7.177382561174243e-16,  2.459687756166535e-17, -7.615836234724405e-19,  2.155373077862881e-20, -5.624755648505845e-22,
  2.211612839738750e-08, -5.482165054698474e-09,  7.086817902329956e-10, -6.264302113170994e-11,  4.241056689021613e-12, -2.340745951327493e-13,  1.095527620475993e-14,
 -4.467222592451442e-16,  1.618652586206568e-17, -5.290119722432461e-19,  1.577834090395909e-20, -4.332772735928780e-22,  8.817948680974386e-09, -2.331134476986908e-09,
  3.214372960371767e-10, -3.025350730900777e-11,  2.176511237081454e-12, -1.273990220000540e-13,  6.311657265274197e-15, -2.719545432101428e-16,  1.039506438355572e-17,
 -3.578265731345786e-19,  1.122430966395929e-20, -3.236850045164016e-22,  3.529039324798172e-09, -9.910034446131836e-10,  1.452518271925452e-10, -1.451047105559762e-11,
  1.106049590769376e-12, -6.847176500002326e-14,  3.581568880938935e-15, -1.626674089600119e-16,  6.543852949631077e-18, -2.367255143838909e-19,  7.792843668619284e-21,
 -2.355180873026909e-22,  1.424391409210625e-09, -4.232118705165868e-10,  6.570741485786800e-11, -6.944957017171717e-12,  5.592150937662764e-13, -3.651176705946967e-14,
  2.011082346077935e-15, -9.603705813888636e-17,  4.056309396162682e-18, -1.538543833117777e-19,  5.303529725001082e-21, -1.676228288762150e-22,  5.826313221089894e-10,
 -1.824508037030163e-10,  2.990218489645576e-11, -3.333145719448756e-12,  2.826615181372715e-13, -1.940869168367210e-14,  1.122661454215477e-15, -5.622299815485746e-17,
  2.487069142109280e-18, -9.867319039787738e-20,  3.553549491101424e-21, -1.171947558055780e-22,  2.427079778621313e-10, -7.979784290041792e-11,  1.375723688256927e-11,
 -1.611981558735633e-12,  1.435276554579213e-13, -1.033398277244762e-14,  6.259810450627943e-16, -3.278835858653183e-17,  1.515160466965142e-18, -6.272313464677509e-20,
  2.354302767598382e-21, -8.083194827285345e-23,  1.034720175219971e-10, -3.558209435393892e-11,  6.430184856703359e-12, -7.893804724147686e-13,  7.356202387863363e-14,
 -5.537062126170518e-15,  3.502353959537603e-16, -1.913408662992429e-17,  9.211972033980021e-19, -3.968819187406567e-20,  1.548768518879666e-21, -5.522498042702246e-23,
  4.535985740035971e-11, -1.625325652073332e-11,  3.067860459112551e-12, -3.932423053375276e-13,  3.823072251385927e-14, -2.999046428258029e-15,  1.974944020717482e-16,
 -1.122129891323740e-17,  5.612921878804590e-19, -2.509993034101500e-20,  1.015688939435375e-21, -3.751844943564835e-23,  2.053817010315794e-11, -7.639412556525126e-12,
  1.500682924513400e-12, -2.001569176175899e-13,  2.023310265399243e-14, -1.648871969219447e-15,  1.126958840552953e-16, -6.639593302419781e-18,  3.440608646850249e-19,
 -1.592502258496495e-20,  6.664300343357887e-22, -2.543501108264718e-23,  9.642737551684489e-12, -3.709431239209433e-12,  7.555746870377216e-13, -1.044904713629372e-13,
  1.094515701743661e-14, -9.235586126799070e-16,  6.530503136237397e-17, -3.977232382616379e-18,  2.128727197618096e-19, -1.016862698465485e-20,  4.388297120673316e-22,
 -1.725738012757428e-23,  4.709066492158179e-12, -1.866548160184255e-12,  3.927653923139659e-13, -5.611444134974448e-14,  6.069392540884178e-15, -5.284749990353416e-16,
  3.853287827113332e-17, -2.418094483138633e-18,  1.332615178453740e-19, -6.549833973230748e-21,  2.906333327142220e-22, -1.174313168587816e-23,  2.396322641699764e-12,
 -9.750902863190216e-13,  2.111644347288338e-13, -3.105221277885410e-14,  3.455558730668398e-15, -3.093910073302104e-16,  2.318226664718590e-17, -1.494043044679435e-18,
  8.450546610662578e-20, -4.260194741271759e-21,  1.937752683986461e-22, -8.020575734383702e-24,  1.270283858502417e-12, -5.286912696899396e-13,  1.173798981809248e-13,
 -1.769899795184073e-14,  2.018917847279235e-15, -1.852029193074415e-16,  1.421045191344296e-17, -9.373278293095210e-19,  5.423174871299281e-20, -2.795151922211714e-21,
  1.299129876375332e-22, -5.491492065940500e-24,  6.987550229376723e-13, -2.963762000345093e-13,  6.719878978905670e-14, -1.034949329636045e-14,  1.205546871686075e-15,
 -1.128863767546965e-16,  8.837741550368318e-18, -5.945228263179572e-19,  3.506524507543096e-20, -1.841532146747279e-21,  8.717353386065577e-23, -3.751207799150170e-24,
  3.946901953203700e-13, -1.699866833042932e-13,  3.920576093799659e-14, -6.143270151045675e-15,  7.279069721011404e-16, -6.931272415652100e-17,  5.516222004897163e-18,
 -3.770859764346529e-19,  2.259232586637444e-20, -1.204806779154194e-21,  5.789231185676721e-23, -2.527754238142819e-24,  2.232852728686844e-13, -9.729466756672340e-14,
  2.273597690888913e-14, -3.610097913270328e-15,  4.334040786901826e-16, -4.180510522806615e-17,  3.369328438507770e-18, -2.331886623711980e-19,  1.414073703822503e-20,
 -7.630477160450502e-22,  3.709019226658798e-23, -1.637743034734563e-24,  1.185230916501576e-13, -5.206410835165457e-14,  1.227754083269939e-14, -1.967502493726603e-15,
  2.383690238256757e-16, -2.319954985620249e-17,  1.886291108604234e-18, -1.316756088348243e-19,  8.052275429484823e-21, -4.380899765991557e-22,  2.146609814058464e-23,
 -9.552807391013871e-25,  4.600131271505135e-14, -2.029800334762220e-14,  4.810877057517099e-15, -7.749178115549380e-16,  9.436202451507396e-17, -9.229903695681686e-18,
  7.541421638211205e-19, -5.289698870518858e-20,  3.249965821295145e-21, -1.776280631604491e-22,  8.742658490356302e-24, -3.907623917375453e-25,  6.120310316379084e-02,
 -1.552675607923893e-04,  4.087718275176710e-07, -1.109563712877019e-09,  3.081652427861207e-12, -8.696420749530797e-15,  2.478774081104795e-17, -7.105858273404441e-20,
  2.041996327895067e-22, -5.871079653349657e-25,  1.686245470341297e-27, -4.835104550303471e-30,  5.812270308884866e-02, -1.874099912898754e-04,  7.157556846823552e-07,
 -2.839941557609046e-09,  1.115620726897624e-11, -4.292526174757194e-14,  1.617908990644896e-16, -5.988411291856871e-19,  2.181979278995490e-21, -7.842558988790318e-24,
  2.784985100794042e-26, -9.783563750196909e-29,  5.242396999487580e-02, -2.411569681952883e-04,  1.309868008127658e-06, -6.811222446140416e-09,  3.356101665454864e-11,
 -1.584622852725172e-13,  7.233273365019074e-16, -3.210978670494710e-18,  1.391994702246980e-20, -5.911243695117553e-23,  2.464941145685946e-25, -1.011236369924861e-27,
  4.491639450326045e-02, -2.994017492367782e-04,  2.133605833352434e-06, -1.371144555508197e-08,  8.170128038637536e-11, -4.603991995069868e-13,  2.482149236460486e-15,
 -1.290116030240497e-17,  6.500180725284472e-20, -3.188019393350139e-22,  1.526936308521723e-24, -7.160426493231001e-27,  3.656708937702135e-02, -3.445937519659097e-04,
  3.075040928419644e-06, -2.386794814567268e-08,  1.689805651550249e-10, -1.117417903813214e-12,  6.999536780794295e-15, -4.193076220682252e-17,  2.418712443785430e-19,
 -1.350389704898361e-21,  7.326384987796496e-24, -3.874736238602014e-26,  2.829747678804093e-02, -3.643762651688571e-04,  3.974004430900178e-06, -3.674396552955283e-08,
  3.050646343568159e-10, -2.337655722179785e-12,  1.681271825901141e-14, -1.147849008154089e-16,  7.499674371997705e-19, -4.717817884713652e-21,  2.870863876158889e-23,
 -1.696109810659037e-25,  2.082482196837099e-02, -3.546117297175263e-04,  4.658100644392002e-06, -5.074517872916175e-08,  4.889042297167430e-10, -4.299197893529757e-12,
  3.518000356595940e-14, -2.713904337755071e-16,  1.992074690806735e-18, -1.400958250476180e-20,  9.489920255448876e-23, -6.217693672407393e-25,  1.458279186217345e-02,
 -3.191074947172457e-04,  4.994198561842574e-06, -6.350212377780851e-08,  7.038679561721711e-10, -7.047041205636878e-12,  6.513034853103389e-14, -5.638129856736475e-16,
  4.619013614832847e-18, -3.608799976102559e-20,  2.704857894453652e-22, -1.953914663491187e-24,  9.723503416341032e-03, -2.668423404346835e-04,  4.929723611001710e-06,
 -7.255970691816908e-08,  9.185475739004443e-10, -1.040155472794177e-11,  1.079155299206184e-13, -1.042296299013700e-15,  9.478511290703246e-18, -8.184380949589276e-20,
  6.753669582820065e-22, -5.353037755125381e-24,  6.178379897898781e-03, -2.082967030982686e-04,  4.503848849913301e-06, -7.617655410358189e-08,  1.094396024987753e-09,
 -1.393712627759349e-11,  1.614669244721158e-13, -1.731445235441695e-15,  1.739685921406539e-17, -1.652805906782069e-19,  1.495205083487313e-21, -1.295032330637550e-23,
  3.744522683726592e-03, -1.523953860099360e-04,  3.825834234417741e-06, -7.386821312617783e-08,  1.197586718963944e-09, -1.706548109085793e-11,  2.197590257962434e-13,
 -2.605070380130343e-15,  2.880256152264463e-17, -2.999234069160518e-19,  2.963528630128962e-21, -2.794884064391720e-23,  2.166932670586403e-03, -1.048770867190590e-04,
  3.033943440458863e-06, -6.646794513665648e-08,  1.209871944849241e-09, -1.920414746534166e-11,  2.737447050610247e-13, -3.573546069831782e-15,  4.332055391096537e-17,
 -4.927372434084312e-19,  5.300470881052135e-21, -5.426001491373919e-23,  1.198779514908273e-03, -6.811128288958227e-05,  2.254418587313627e-06, -5.573070556371420e-08,
  1.133610144378140e-09, -1.996028597239368e-11,  3.137683936883514e-13, -4.495061261513774e-15,  5.955248619194761e-17, -7.376087720226918e-19,  8.612922233376831e-21,
 -9.543410128698823e-23,  6.348354450421090e-04, -4.186925696190378e-05,  1.575104634536504e-06, -4.370941676297713e-08,  9.892316665458401e-10, -1.924814761386788e-11,
  3.325237255610859e-13, -5.211213023116968e-15,  7.522816420410974e-17, -1.011792562694259e-18,  1.279029797060828e-20, -1.530063534915336e-22,  3.223027085874444e-04,
 -2.443170889061052e-05,  1.038159975442040e-06, -3.218324169710906e-08,  8.071239714350394e-10, -1.729301341239943e-11,  3.272651074899268e-13, -5.594001879075119e-15,
  8.774970790603285e-17, -1.278247816881342e-18,  1.745015298192923e-20, -2.248436011428179e-22,  1.571360370697667e-04, -1.357088386005566e-05,  6.475745235127103e-07,
 -2.232413627695817e-08,  6.180286852744393e-10, -1.453186683005817e-11,  3.003547611038750e-13, -5.584206081678388e-15,  9.493955662391176e-17, -1.494249548279008e-18,
  2.197886054601919e-20, -3.043591833501950e-22,  7.370644725501117e-05, -7.195592763211886e-06,  3.834938604554925e-07, -1.463836097745942e-08,  4.457312389200657e-10,
 -1.146533155686747e-11,  2.580723904459922e-13, -5.205165199455435e-15,  9.568106829966937e-17, -1.623365299378852e-18,  2.567182835668392e-20, -3.812779011007299e-22,
  3.333099536099578e-05, -3.652202813994178e-06,  2.162944222340730e-07, -9.104490377516889e-09,  3.038649489069575e-10, -8.524643407092110e-12,  2.083948001101003e-13,
 -4.548413574155138e-15,  9.018813117799866e-17, -1.645920302886171e-18,  2.792633987117953e-20, -4.439665843325866e-22,  1.456438079324273e-05, -1.779650565528402e-06,
  1.165590520069555e-07, -5.389466199990709e-09,  1.965063569323800e-10, -5.994980790366144e-12,  1.587499454039516e-13, -3.740434833267292e-15,  7.982523724298674e-17,
 -1.563724576838095e-18,  2.841001664141078e-20, -4.825485194760483e-22,  6.164859709872042e-06, -8.350640982840765e-07,  6.021331161344708e-08, -3.046984034530477e-09,
  1.209825743839555e-10, -4.002451297674978e-12,  1.145150696151941e-13, -2.905989419444535e-15,  6.660409751387544e-17, -1.397656924166937e-18,  2.713846751511870e-20,
 -4.915808530777470e-22,  2.534738050255939e-06, -3.785207973625088e-07,  2.992041959845107e-08, -1.651113848070144e-09,  7.117263462268302e-11, -2.546357970913143e-12,
  7.852186170950953e-14, -2.141195125782307e-15,  5.259365207271661e-17, -1.179915634915018e-18,  2.443964550309860e-20, -4.712689234436157e-22,  1.015368381814496e-06,
 -1.663038263960613e-07,  1.435218002697574e-08, -8.607324749638315e-10,  4.015935268436944e-11, -1.549653038376875e-12,  5.137886681012148e-14, -1.502146891622526e-15,
  3.945980470693371e-17, -9.445851324388883e-19,  2.083247655641387e-20, -4.268873061633030e-22,  3.975693281430283e-07, -7.107281596054808e-08,  6.670588608519568e-09,
 -4.333221325624854e-10,  2.181929400657705e-11, -9.057071867357904e-13,  3.220881971466724e-14, -1.007401430159250e-15,  2.824313614350047e-17, -7.199852159961278e-19,
  1.687641169362589e-20, -3.668499729406557e-22,  1.527001570460815e-07, -2.965767345127732e-08,  3.015864360588260e-09, -2.115179800663218e-10,  1.146144395042949e-11,
 -5.104540919768868e-13,  1.942431301370943e-14, -6.485061786593206e-16,  1.936401231415980e-17, -5.246690390011891e-19,  1.304660485903576e-20, -3.003147778878225e-22,
  5.775189424876510e-08, -1.213250635308107e-08,  1.331858041845315e-09, -1.005315949732205e-10,  5.845509855211965e-12, -2.786037673356981e-13,  1.131731854192344e-14,
 -4.024300619986220e-16,  1.277144533805333e-17, -3.670771842333040e-19,  9.665307272963011e-21, -2.351752628009320e-22,  2.159641474721529e-08, -4.886526507727242e-09,
  5.770280677538142e-10, -4.672942096528155e-11,  2.907440654839352e-12, -1.479105412381015e-13,  6.398572543076063e-15, -2.417892009569969e-16,  8.138435482541231e-18,
 -2.476397190243936e-19,  6.891304329842844e-21, -1.769235123764834e-22,  8.020463425093729e-09, -1.946495392045517e-09,  2.463900444266198e-10, -2.134105816478471e-11,
  1.416804590013624e-12, -7.673459592492922e-14,  3.526553329702809e-15, -1.412942332786607e-16,  5.033283768513803e-18, -1.618112665717798e-19,  4.749737982470635e-21,
 -1.284260360221741e-22,  2.972041230201881e-09, -7.705242067736270e-10,  1.041910053361543e-10, -9.622224947513692e-12,  6.796869079690324e-13, -3.908758259156732e-14,
  1.903719931691065e-15, -8.068434796239643e-17,  3.035180853175428e-18, -1.028753376189626e-19,  3.178948670598237e-21, -9.035073329428333e-23,  1.104324640564080e-09,
 -3.046344565864129e-10,  4.385369645794899e-11, -4.304789264114888e-12,  3.226090262380688e-13, -1.964674907223817e-14,  1.011499084025901e-15, -4.524067369444822e-17,
  1.793118983896476e-18, -6.393909269581763e-20,  2.075634278385873e-21, -6.188681370458817e-23,  4.135950105187693e-10, -1.209217246884268e-10,  1.846814962681004e-11,
 -1.920899818383303e-12,  1.522830721906906e-13, -9.793985406595526e-15,  5.316432220827353e-16, -2.503188732492896e-17,  1.042894734311765e-18, -3.903501214862001e-20,
  1.328359084817208e-21, -4.146293777119092e-23,  1.569719917071901e-10, -4.845181229588957e-11,  7.823867694266905e-12, -8.595160425158119e-13,  7.186660258660412e-14,
 -4.867497152632244e-15,  2.778384358556460e-16, -1.373629753819307e-17,  6.001030055683927e-19, -2.352238309803886e-20,  8.372262555860543e-22, -2.729868697088253e-23,
  6.070483235759084e-11, -1.970574694259111e-11,  3.352605901491978e-12, -3.877533119623521e-13,  3.408989271630929e-14, -2.424455920921615e-15,  1.451193809420889e-16,
 -7.513770530959180e-18,  3.433373551141956e-19, -1.405911513083398e-20,  5.221527268892777e-22, -1.774443522056063e-23,  2.405361033358642e-11, -8.180160444311503e-12,
  1.461149328112947e-12, -1.773232111323408e-13,  1.634048410359069e-14, -1.216634181060020e-15,  7.614624269702641e-17, -4.117554775816219e-18,  1.962719427162413e-19,
 -8.374646869579433e-21,  3.237514389231896e-22, -1.143941072181569e-23,  9.818799372237217e-12, -3.484870081577793e-12,  6.511815600804890e-13, -8.264025575279909e-14,
  7.956263618240918e-15, -6.182437126957835e-16,  4.033929191025762e-17, -2.271584852943736e-18,  1.126417113487340e-19, -4.994767468634370e-21,  2.004656614527608e-22,
 -7.346282237294593e-24,  4.150637669572386e-12, -1.531536973497087e-12,  2.982881351964398e-13, -3.944789864011895e-14,  3.954589985420540e-15, -3.196726794532366e-16,
  2.167721460399084e-17, -1.267390016943960e-18,  6.518860845104568e-20, -2.995541982282928e-21,  1.244792425081065e-22, -4.718594243589844e-24,  1.825574945453615e-12,
 -6.976488953723707e-13,  1.410966602551058e-13, -1.937487881584341e-14,  2.015434669291966e-15, -1.689160259926715e-16,  1.186565363538947e-17, -7.180317140457341e-19,
  3.819247623982969e-20, -1.813387575061085e-21,  7.779788829591274e-23, -3.042049569731836e-24,  8.387136208623006e-13, -3.306875371354221e-13,  6.918530932181515e-14,
 -9.827909374998045e-15,  1.057021226570866e-15, -9.153213744645701e-17,  6.638251767236530e-18, -4.144112788722103e-19,  2.272276180691384e-20, -1.111335615888215e-21,
  4.907696494534295e-23, -1.973764473558486e-24,  4.035459493474543e-13, -1.635342532617157e-13,  3.525593016586112e-14, -5.161183758808565e-15,  5.718128055507398e-16,
 -5.097607456783496e-17,  3.803517648928018e-18, -2.441248120887033e-19,  1.375310797432258e-20, -6.906526730148802e-22,  3.129597517330307e-23, -1.290636604116874e-24,
  2.034490130448178e-13, -8.441710861200598e-14,  1.867925462647313e-14, -2.807028410609205e-15,  3.191334188234355e-16, -2.918024645050968e-17,  2.231883081616668e-18,
 -1.467618480456475e-19,  8.465816821268700e-21, -4.350599653403657e-22,  2.016316560142899e-23, -8.499535512122595e-25,  1.071412212675782e-13, -4.534624824347225e-14,
  1.025707092559227e-14, -1.575936957324444e-15,  1.831373056719744e-16, -1.710917250971046e-17,  1.336434335676379e-18, -8.970538240997582e-20,  5.279529628628052e-21,
 -2.766880534211485e-22,  1.307110586878988e-23, -5.613593316113751e-25,  5.836295520084977e-14, -2.510071434364737e-14,  5.780167374527405e-15, -9.042822725191503e-16,
  1.069801415653204e-16, -1.017130733847293e-17,  8.082716766789132e-19, -5.517262513792225e-20,  3.300864664745739e-21, -1.757856230110699e-22,  8.435316280920154e-24,
 -3.678294064071441e-25,  3.209412350249814e-14, -1.397320069834000e-14,  3.262256313575656e-15, -5.175077097885493e-16,  6.207101361298590e-17, -5.981782828206245e-18,
  4.816800718411105e-19, -3.330777894430300e-20,  2.018097589322532e-21, -1.088084363777918e-22,  5.284689029466491e-24, -2.331659415352820e-25,  1.669938274578074e-14,
 -7.332515302809549e-15,  1.728301556985887e-15, -2.768306097107479e-16,  3.352285904502925e-17, -3.261117627398762e-18,  2.650300614991385e-19, -1.849248748717328e-20,
  1.130358816733801e-21, -6.147136250922015e-23,  3.010776437950817e-24, -1.339296728120277e-25,  6.409122284763636e-15, -2.827463616987246e-15,  6.699952072416978e-16,
 -1.078958649224025e-16,  1.313555152949737e-17, -1.284550153135005e-18,  1.049327807039801e-19, -7.358585398851511e-21,  4.520110199218855e-22, -2.469960968041385e-23,
  1.215435004594069e-24, -5.431407530557970e-26,  6.058849010920680e-02, -1.520498200328688e-04,  3.957472648450106e-07, -1.061617041576062e-09,  2.913515644670963e-12,
 -8.124671342226304e-15,  2.288649495864336e-17, -6.484975558648582e-20,  1.842282976877080e-22, -5.237247590666579e-25,  1.487407860909157e-27, -4.217984736466217e-30,
  5.738430357873986e-02, -1.818172924222485e-04,  6.827197193783906e-07, -2.668104870136443e-09,  1.033521337526191e-11, -3.923585414376170e-14,  1.459599156987565e-16,
 -5.333282464488947e-19,  1.918703820958058e-21, -6.810062065791373e-24,  2.388390631292472e-26, -8.287409124290912e-29,  5.147979493472934e-02, -2.309960690939674e-04,
  1.231253585201557e-06, -6.298686613935924e-09,  3.055833904314328e-11, -1.421328838759891e-13,  6.393492329101609e-16, -2.797769890020912e-18,  1.195915620442419e-20,
 -5.008770936300362e-23,  2.060326186603194e-25, -8.339438129852334e-28,  4.375191360620238e-02, -2.829695085793975e-04,  1.976618105041802e-06, -1.247477094029478e-08,
  7.306092362155909e-11, -4.049375591003639e-13,  2.148392806973921e-15, -1.099353393517781e-17,  5.455244431338144e-20, -2.635865924382505e-22,  1.244091049695181e-24,
 -5.750433980878827e-27,  3.523616378154133e-02, -3.210947644308084e-04,  2.804138701112691e-06, -2.133430257356795e-08,  1.482213335189481e-10, -9.626861275321854e-13,
  5.926910177052520e-15, -3.491532001256337e-17,  1.981457706316651e-19, -1.088780931157680e-21,  5.815584271440295e-24, -3.028953462453493e-26,  2.690087589007556e-02,
 -3.342683785196661e-04,  3.560888341020746e-06, -3.221607840791922e-08,  2.620996173197495e-10, -1.970155684863645e-12,  1.391069307570167e-14, -9.329558758009254e-17,
  5.991160431027404e-19, -3.705902788807344e-21,  2.218277644903532e-23, -1.289597471181384e-25,  1.947722751026360e-02, -3.196559602473402e-04,  4.093397675462178e-06,
 -4.356716775355662e-08,  4.107833008500309e-10, -3.539302739325879e-12,  2.840262999445253e-14, -2.150312882786551e-16,  1.549940773031103e-18, -1.070917021870386e-20,
  7.130232261252627e-23, -4.593544982001378e-25,  1.338169972588328e-02, -2.820207412769544e-04,  4.295354489037168e-06, -5.328791477470849e-08,  5.773611730161656e-10,
 -5.657781386368643e-12,  5.123156217023670e-14, -4.348603741448628e-16,  3.495513162743924e-18, -2.681110866720680e-20,  1.973774495565883e-22, -1.401025642773844e-24,
  8.729828066658807e-03, -2.306525155159025e-04,  4.140752803794839e-06, -5.939581178964794e-08,  7.342185040924127e-10, -8.130066116042557e-12,  8.256933233235857e-14,
 -7.813404235552583e-16,  6.966510504254608e-18, -5.901366761900308e-20,  4.780008934416181e-22, -3.720620622881747e-24,  5.411859195657273e-03, -1.756446051325156e-04,
  3.686233292269492e-06, -6.070102319311955e-08,  8.507818444006031e-10, -1.058588985670281e-11,  1.199620141653493e-13, -1.259433946815930e-15,  1.239875008845274e-17,
 -1.154927130351058e-19,  1.024961037772216e-21, -8.713272142666425e-24,  3.190968381022412e-03, -1.250328364462710e-04,  3.043985530669277e-06, -5.717378350215166e-08,
  9.036096879223849e-10, -1.257163259703177e-11,  1.582475802434901e-13, -1.835473213534550e-15,  1.987241541413376e-17, -2.027790876210417e-19,  1.964621702231343e-21,
 -1.817712817607251e-23,  1.791344688924545e-03, -8.349394467358405e-05,  2.340870764344746e-06, -4.985709282187479e-08,  8.841279222186586e-10, -1.369337419982808e-11,
  1.906930734627282e-13, -2.434441458346943e-15,  2.888502097289442e-17, -3.218025075420675e-19,  3.392820735608537e-21, -3.406011382131237e-23,  9.585679600255228e-04,
 -5.247054523178544e-05,  1.682520022698081e-06, -4.041664615582741e-08,  8.005308849306378e-10, -1.374719059217837e-11,  2.110246155426319e-13, -2.955185207560723e-15,
  3.830485792863303e-17, -4.645291929030106e-19,  5.314452971541926e-21, -5.772857055621181e-23,  4.895827377419268e-04, -3.112406874442185e-05,  1.134134028116559e-06,
 -3.057291826208668e-08,  6.735303008339463e-10, -1.277694761804590e-11,  2.154705243641909e-13, -3.299791837797001e-15,  4.659063235963347e-17, -6.133619585685215e-19,
  7.594690373240685e-21, -8.904506480085926e-23,  2.390189824034878e-04, -1.747544272533787e-05,  7.192810867600569e-07, -2.165743363118477e-08,  5.285956802409447e-10,
 -1.103907530752308e-11,  2.038858782665277e-13, -3.404816210649252e-15,  5.222676669415341e-17, -7.445289529590831e-19,  9.953780829542114e-21, -1.256798056359222e-22,
  1.117281718406058e-04, -9.313527132388377e-06,  4.305616422588639e-07, -1.441668039880060e-08,  3.883949913230688e-10, -8.900574157702914e-12,  1.795161172890512e-13,
 -3.260315982705400e-15,  5.419623649391716e-17, -8.346695618535031e-19,  1.202190917851826e-20, -1.631211564778863e-22,  5.009812849181180e-05, -4.724508166480864e-06,
  2.440249141594407e-07, -9.048544266415702e-09,  2.681390181223524e-10, -6.722197225113123e-12,  1.476502448040903e-13, -2.909024230202644e-15,  5.228196107184790e-17,
 -8.679636119767927e-19,  1.344035064817880e-20, -1.955896101267593e-22,  2.159254197323285e-05, -2.287597015604445e-06,  1.313599880938334e-07, -5.372913289731690e-09,
  1.745494351794079e-10, -4.773208724338477e-12,  1.138763742775658e-13, -2.428081918439465e-15,  4.707581764168718e-17, -8.407111150341991e-19,  1.396851601967059e-20,
 -2.176044285594744e-22,  8.966069697225235e-06, -1.060348035136681e-06,  6.737783286285797e-08, -3.028563895117321e-09,  1.075200303242532e-10, -3.198214228736420e-12,
  8.266833585828354e-14, -1.903209483092504e-15,  3.972144603324726e-17, -7.615624289573308e-19,  1.355137746543229e-20, -2.255806525173890e-22,  3.595955308781307e-06,
 -4.719407480734071e-07,  3.303959899194436e-08, -1.626188799805856e-09,  6.289803914102943e-11, -2.029593443783729e-12,  5.670132952464890e-14, -1.406344226421031e-15,
  3.153098827276792e-17, -6.477535649775121e-19,  1.232165295221537e-20, -2.187926430484753e-22,  1.396853610185661e-06, -2.023460442725865e-07,  1.554226930709912e-08,
 -8.347826844520094e-10,  3.507248870301301e-11, -1.224485234860812e-12,  3.688603486265870e-14, -9.834866087128184e-16,  2.363996381482222e-17, -5.193865966751108e-19,
  1.054281226399307e-20, -1.993552195523528e-22,  5.271606759038020e-07, -8.386020649201770e-08,  7.039270863881120e-09, -4.112150049312325e-10,  1.871278414456549e-11,
 -7.050623365514837e-13,  2.284818701415287e-14, -6.534909400387754e-16,  1.680695433825003e-17, -3.941819809310147e-19,  8.523256104829398e-21, -1.713390825933555e-22,
  1.939320278793729e-07, -3.371761566741072e-08,  3.081289567637093e-09, -1.951458406891580e-10,  9.591404210899987e-12, -3.890263416558611e-13,  1.353079494205364e-14,
 -4.142617040673096e-16,  1.137733915994773e-17, -2.843213959934140e-19,  6.537353405033414e-21, -1.394788684167422e-22,  6.980138627932426e-08, -1.320365172095466e-08,
  1.308834466622873e-09, -8.958489426778387e-11,  4.742510847741210e-12, -2.065521386054531e-13,  7.693148065316783e-15, -2.515960041805256e-16,  7.364299510802091e-18,
 -1.957298728570922e-19,  4.777176895924444e-21, -1.079955839881590e-22,  2.467859913343535e-08, -5.056896108559836e-09,  5.418107618601126e-10, -3.995619941300787e-11,
  2.272050455132823e-12, -1.059948900334677e-13,  4.217920673361748e-15, -1.470369018684300e-16,  4.577776100802569e-18, -1.291590316574377e-19,  3.340335006912807e-21,
 -7.987596796162360e-23,  8.607906089534327e-09, -1.902699828716489e-09,  2.195835487863156e-10, -1.739412173936686e-11,  1.059524213693609e-12, -5.281310043432607e-14,
  2.240244820849840e-15, -8.306553505848074e-17,  2.745207920446120e-18, -8.206602453086100e-20,  2.244883155891342e-21, -5.668378543517311e-23,  2.975913923118150e-09,
 -7.066881650673180e-10,  8.754678138240345e-11, -7.426708446460716e-12,  4.832710240531333e-13, -2.567401178244229e-14,  1.158176418755187e-15, -4.557736964660627e-17,
  1.595644181027077e-18, -5.044229262879640e-20,  1.456742978665105e-21, -3.877151998233190e-23,  1.024849043481636e-09, -2.604139915689590e-10,  3.451356924038080e-11,
 -3.125977608767461e-12,  2.167041067076886e-13, -1.223865895343861e-14,  5.857437738570215e-16, -2.440951415977688e-17,  9.033557589416603e-19, -3.013796820950284e-20,
  9.171174737774244e-22, -2.568133716583218e-23,  3.534495320258854e-10, -9.572313531930500e-11,  1.352662978034175e-11, -1.304074039884828e-12,  9.604024394680632e-14,
 -5.751104916454373e-15,  2.913103480957948e-16, -1.282571651872027e-17,  5.006596394962481e-19, -1.759084830588338e-20,  5.629270403577905e-22, -1.655281034947945e-23,
  1.227620229947053e-10, -3.529746566369551e-11,  5.300193375946830e-12, -5.422259200333276e-13,  4.230175235884434e-14, -2.678703072989002e-15,  1.432397260094623e-16,
 -6.646974914165193e-18,  2.730588790291083e-19, -1.008191396934315e-20,  3.385746397726204e-22, -1.043339288680879e-23,  4.319397646654414e-11, -1.313430039586276e-11,
  2.088550879518192e-12, -2.260182038014527e-13,  1.862401385178965e-14, -1.243675220180563e-15,  7.002334301909016e-17, -3.416298219757284e-18,  1.473414764887197e-19,
 -5.703775891588199e-21,  2.005701441233788e-22, -6.463505930410654e-24,  1.548973285862948e-11, -4.961921260677984e-12,  8.326659848521420e-13, -9.501239008681334e-14,
  8.244173793890956e-15, -5.789001047786669e-16,  3.422568179005541e-17, -1.750999344940661e-18,  7.908746999203056e-20, -3.202235819419619e-21,  1.176372281458969e-22,
 -3.955541017821728e-24,  5.696559929817957e-12, -1.914952747994057e-12,  3.379299194850615e-13, -4.052370586996544e-14,  3.691072582488718e-15, -2.717297779600915e-16,
  1.682136661865243e-17, -8.999744063673525e-19,  4.245846029071823e-20, -1.793574599231834e-21,  6.866535043547381e-23, -2.403426599758417e-24,  2.161770226273613e-12,
 -7.596404488269127e-13,  1.404608729087741e-13, -1.764119446254341e-14,  1.681264941476143e-15, -1.293597197553825e-16,  8.359952337857905e-18, -4.664040969173245e-19,
  2.291967475171121e-20, -1.007427811879043e-21,  4.009011324695783e-23, -1.457053530897502e-24,  8.515966229555854e-13, -3.115975787799207e-13,  6.014686193549364e-14,
 -7.883933767484119e-15,  7.835164889107331e-16, -6.280290362351701e-17,  4.223847640005572e-18, -2.449896178659433e-19,  1.250377661733396e-20, -5.702604028717125e-22,
  2.352425083142046e-23, -8.854181558481330e-25,  3.501875471367840e-13, -1.328999736868831e-13,  2.667884346460966e-14, -3.636371878909301e-15,  3.755288602614941e-16,
 -3.125150956400515e-17,  2.180224613378603e-18, -1.310528110309594e-19,  6.925572462216168e-21, -3.267557739536524e-22,  1.393260161956299e-23, -5.415551198523609e-25,
  1.510397087919349e-13, -5.922103288624635e-14,  1.231543362104530e-14, -1.738924572548016e-15,  1.859246533242499e-16, -1.600749106844561e-17,  1.154426342887482e-18,
 -7.167599603900836e-20,  3.909297457151363e-21, -1.902139488850187e-22,  8.357887422005168e-24, -3.345037979801664e-25,  6.856916248876005e-14, -2.766723261868941e-14,
  5.936574414393566e-15, -8.649660795062014e-16,  9.538627551234678e-17, -8.465021352681608e-18,  6.288218901994068e-19, -4.018705877512785e-20,  2.254541324583952e-21,
 -1.127586653297694e-22,  5.089323556681980e-24, -2.090778824476070e-25,  3.281071058882163e-14, -1.357037290340106e-14,  2.992131836111723e-15, -4.480468624044940e-16,
  5.076092522116306e-17, -4.625525677505572e-18,  3.526109396324265e-19, -2.311147951573524e-20,  1.328958597874275e-21, -6.808583441060188e-23,  3.146063904202507e-24,
 -1.322341451359075e-25,  1.651104026974930e-14, -6.972267988835007e-15,  1.573127627848547e-15, -2.410913445299476e-16,  2.794719403618236e-17, -2.604548111180207e-18,
  2.029638848746905e-19, -1.359201532776258e-20,  7.981438493633368e-22, -4.173715865035949e-23,  1.967508824224726e-24, -8.432266637663292e-26,  8.659346214513064e-15,
 -3.718694819434225e-15,  8.549236242825481e-16, -1.335266577181964e-16,  1.577080981364455e-17, -1.497025204532157e-18,  1.187756925285453e-19, -8.095219709927860e-21,
  4.835979130575568e-22, -2.571629850229883e-23,  1.232285208876674e-24, -5.366099284316923e-26,  4.622441560991037e-15, -2.010777364737182e-15,  4.689888094195765e-16,
 -7.432472213015323e-17,  8.905994407072058e-18, -8.574511107530271e-19,  6.898134880963641e-20, -4.765653488914641e-21,  2.884910205382170e-22, -1.554087689430861e-23,
  7.541617390385265e-25, -3.324699491976670e-26,  2.355336006255746e-15, -1.033745427229956e-15,  2.435363467303913e-16, -3.898872814045869e-17,  4.718985128659910e-18,
 -4.588387828584270e-19,  3.727168224636766e-20, -2.599403667923215e-21,  1.588157797409012e-22, -8.632835584083234e-24,  4.226362623198905e-25, -1.879219272312281e-26,
  8.933841906027968e-16, -3.940479191123600e-16,  9.335207930159122e-17, -1.502987395418688e-17,  1.829352141523768e-18, -1.788543561038316e-19,  1.460697881188007e-20,
 -1.024107984976048e-21,  6.289326449519582e-23, -3.435978319815658e-24,  1.690436202724057e-25, -7.552451197535450e-27,  5.998654320516641e-02, -1.489340192144723e-04,
  3.832822905789560e-07, -1.016271500290320e-09,  2.756371267769093e-12, -7.596535831021369e-15,  2.115048149405470e-17, -5.924498591143756e-20,  1.664019024688234e-22,
 -4.677777620949441e-25,  1.313821544857252e-27, -3.685128522141024e-30,  5.666775904021162e-02, -1.764808509495859e-04,  6.516693487130742e-07, -2.508833816364630e-09,
  9.584352002599117e-12, -3.590529653480251e-14,  1.318507224658356e-16, -4.756748350505329e-19,  1.689894547469825e-21, -5.923785309401895e-24,  2.052116098842356e-26,
 -7.034170734764942e-29,  5.057504347176751e-02, -2.214402762561674e-04,  1.158511768342113e-06, -5.831686616813365e-09,  2.786299646346784e-11, -1.276869196379033e-13,
  5.661092410254220e-16, -2.442405896840707e-18,  1.029590962388127e-20, -4.253560887097823e-23,  1.726238554556994e-25, -6.894789922513581e-28,  4.265074064518462e-02,
 -2.677360779824426e-04,  1.833676240789257e-06, -1.136788588607597e-08,  6.545383685974397e-11, -3.568811339215409e-13,  1.863652534203246e-15, -9.390550919086703e-18,
  4.590129714856842e-20, -2.185354259017658e-22,  1.016603444465874e-24, -4.632341227045412e-27,  3.399508458510973e-02, -2.996467998122997e-04,  2.561745102504645e-06,
 -1.910938227863193e-08,  1.303144363698717e-10, -8.314900099845062e-13,  5.032463647113703e-15, -2.915937894356490e-17,  1.628345180084055e-19, -8.807690416750989e-22,
  4.632479356474003e-24, -2.376476771877394e-26,  2.561842500881591e-02, -3.072592335009487e-04,  3.198213083097438e-06, -2.832042061521943e-08,  2.258341701830090e-10,
 -1.665597379237147e-12,  1.154792382841007e-14, -7.609773399512518e-17,  4.803963288234077e-19, -2.922466133412690e-21,  1.721080565417515e-23, -9.847206377735210e-26,
  1.826093786654764e-02, -2.888934187200559e-04,  3.607805531960949e-06, -3.752583699001470e-08,  3.463537085749053e-10, -2.924623032226406e-12,  2.302187624960706e-14,
 -1.710884435867654e-16,  1.211224205463060e-18, -8.223764984592373e-21,  5.382821844019315e-23, -3.410435484701437e-25,  1.231850344231118e-02, -2.500668684964560e-04,
  3.707797662701154e-06, -4.489249844723665e-08,  4.755765856865084e-10, -4.562537413575310e-12,  4.048656312614627e-14, -3.370363027237137e-16,  2.658723748503565e-18,
 -2.002404798446101e-20,  1.448161007706322e-22, -1.010254423882306e-24,  7.869222453258240e-03, -2.001894779635691e-04,  3.493451682354414e-06, -4.884846494549464e-08,
  5.897840576208081e-10, -6.387580233057406e-12,  6.351797950016827e-14, -5.890118429155202e-16,  5.150059314870988e-18, -4.280794267844334e-20,  3.404099743500516e-22,
 -2.602505214720282e-24,  4.763953927509299e-03, -1.488521058930549e-04,  3.032985182570376e-06, -4.863705535395586e-08,  6.652149133770208e-10, -8.088713809937645e-12,
  8.967980624067309e-14, -9.219787288231600e-16,  8.895037535727820e-18, -8.125129584682273e-20,  7.075117444959069e-22, -5.904391867065177e-24,  2.735518977708488e-03,
 -1.031973619676982e-04,  2.436973008466745e-06, -4.453739710265419e-08,  6.863382111941632e-10, -9.324790371421572e-12,  1.147594316096170e-13, -1.302627609637699e-15,
  1.381315081801063e-17, -1.381446057018621e-19,  1.312559107732645e-21, -1.191587539135690e-23,  1.491347670345060e-03, -6.693894247558373e-05,  1.819170708863438e-06,
 -3.767474734641838e-08,  6.510030321894287e-10, -9.840100316078352e-12,  1.338986359777744e-13, -1.671962611934979e-15,  1.942006528237369e-17, -2.119491695021348e-19,
  2.190491864799853e-21, -2.156799199056433e-23,  7.728163818837438e-04, -4.075187779309011e-05,  1.266118179986655e-06, -2.955835220012938e-08,  5.701858621598383e-10,
 -9.551131249521488e-12,  1.431920097026978e-13, -1.960475312444391e-15,  2.486558925778887e-17, -2.952920132190062e-19,  3.310370837939184e-21, -3.525687503408460e-23,
  3.811442190543977e-04, -2.335303634824891e-05,  8.243162108172903e-07, -2.158839664117586e-08,  4.630115175125222e-10, -8.564395385285882e-12,  1.410068724622131e-13,
 -2.110454769938340e-15,  2.914818271192078e-17, -3.756539636150761e-19,  4.556530781817031e-21, -5.236631191993225e-23,  1.791625972465270e-04, -1.263217304459190e-05,
  5.036314642770893e-07, -1.472959597016264e-08,  3.499047871964319e-10, -7.123245259402939e-12,  1.284101717769224e-13, -2.095227777202434e-15,  3.143026363094918e-17,
 -4.385259489240512e-19,  5.741989927628745e-21, -7.105140855606607e-23,  8.040043241530710e-05, -6.467540146583310e-06,  2.896542589021490e-07, -9.420201348602812e-09,
  2.469790330621974e-10, -5.516443746523011e-12,  1.085782651623000e-13, -1.926440746028173e-15,  3.131238688152801e-17, -4.719089042317241e-19,  6.656104935683894e-21,
 -8.849889168187635e-23,  3.450772232459467e-05, -3.142796871781537e-06,  1.573025321708973e-07, -5.665964645472683e-09,  1.634002724846601e-10, -3.992512619673195e-12,
  8.557485116742676e-14, -1.646989641744275e-15,  2.894149853629938e-17, -4.701572364748938e-19,  7.129084706908899e-21, -1.016557279199872e-22,  1.419412261527288e-05,
 -1.453533479317381e-06,  8.091597199822562e-08, -3.215717366872061e-09,  1.016824625246387e-10, -2.710313442142328e-12,  6.310243233035598e-14, -1.314397883628658e-15,
  2.491742333414571e-17, -4.354512429967800e-19,  7.085002188621358e-21, -1.081527376023051e-22,  5.608214344588069e-06, -6.416923929514205e-07,  3.955143258092223e-08,
 -1.727983790439283e-09,  5.972670202886175e-11, -1.732042977159893e-12,  4.369865624450835e-14, -9.829489995114511e-16,  2.006178652776358e-17, -3.764371826448691e-19,
  6.560254337092222e-21, -1.070218244018320e-22,  2.133854065112600e-06, -2.712363644218870e-07,  1.843133486782309e-08, -8.821996119191433e-10,  3.323375135558200e-11,
 -1.045838212565985e-12,  2.852652208959354e-14, -6.914686101064361e-16,  1.516421190776981e-17, -3.049510385045200e-19,  5.682394740070096e-21, -9.890504933732158e-23,
  7.840598217872974e-07, -1.101273878907622e-07,  8.217171126538068e-09, -4.294617087821900e-10,  1.758272752709554e-11, -5.989323393081629e-13,  1.762205061170530e-14,
 -4.593496179834526e-16,  1.080357841871927e-17, -2.324268834974444e-19,  4.623015797994788e-21, -8.571314763036883e-23,  2.790794595995535e-07, -4.309957323367014e-08,
  3.517596385247692e-09, -2.001016547701401e-10,  8.878954500783219e-12, -3.265849325615226e-13,  1.034208652373349e-14, -2.893190297143372e-16,  7.283837441749458e-18,
 -1.673482018177658e-19,  3.547104523296462e-21, -6.994255503113980e-23,  9.655827350798233e-08, -1.631907064775022e-08,  1.451484406782726e-09, -8.959254191866114e-11,
  4.296934879227267e-12, -1.702510325004478e-13,  5.790101611578417e-15, -1.734859576869873e-16,  4.666542828345331e-18, -1.142975747353039e-19,  2.577415465137865e-21,
 -5.396492116140166e-23,  3.259649223704939e-08, -6.002071059060619e-09,  5.797180972988569e-10, -3.870934922466260e-11,  2.001351564026617e-12, -8.521478563805767e-14,
  3.105644553832785e-15, -9.946453096516113e-17,  2.853219276802518e-18, -7.436952884877911e-20,  1.781209322036073e-21, -3.953782429165727e-23,  1.078115359694662e-08,
 -2.153594639906777e-09,  2.251012036189242e-10, -1.621154131786602e-11,  9.011721856359559e-13, -4.113642586413697e-14,  1.603088332141046e-15, -5.476915066259706e-17,
  1.672321984164645e-18, -4.630485568383956e-20,  1.175946967187925e-21, -2.762851648679068e-23,  3.509371110390126e-09, -7.573610947045415e-10,  8.537816777848209e-11,
 -6.612455641108341e-12,  3.941668627997896e-13, -1.924367559432444e-14,  8.001243104788370e-16, -2.910110814217969e-17,  9.440114369736580e-19, -2.771685689413576e-20,
  7.450737113254716e-22, -1.849805551567729e-23,  1.129765359931437e-09, -2.623553522516233e-10,  3.179190737159313e-11, -2.640151105475479e-12,  1.683187194406090e-13,
 -8.767570427335058e-15,  3.880745944062668e-16, -1.499453396297890e-17,  5.157394763738782e-19, -1.602685976897670e-20,  4.552268593644103e-22, -1.192267704336562e-23,
  3.616078525338581e-10, -9.000223276555745e-11,  1.168491498818498e-11, -1.037424543441961e-12,  7.054809241855335e-14, -3.911119898771105e-15,  1.838687162258158e-16,
 -7.531078644582751e-18,  2.740956566893233e-19, -8.997749555290348e-21,  2.695493250820595e-22, -7.434225508218818e-24,  1.157290309853596e-10, -3.075234619536862e-11,
  4.263423065830453e-12, -4.034756299840215e-13,  2.918691895497385e-14, -1.717812861276980e-15,  8.557098719795080e-17, -3.707147830646225e-18,  1.424673727907418e-19,
 -4.930459836903213e-21,  1.554824047697545e-22, -4.507405880646149e-24,  3.725861410138133e-11, -1.052933395640280e-11,  1.553605842702707e-12, -1.562480379753074e-13,
  1.198988087362385e-14, -7.472087173145459e-16,  3.934335716188230e-17, -1.798625151536211e-18,  7.282621983445087e-20, -2.651453294652287e-21,  8.783931455535361e-23,
 -2.671381323644692e-24,  1.214400111888975e-11, -3.635756637492063e-12,  5.690189614798338e-13, -6.062774666343522e-14,  4.920965609290263e-15, -3.238485627765280e-16,
  1.797791697980384e-17, -8.651844201117921e-19,  3.682303681085280e-20, -1.407260611030950e-21,  4.887229082694816e-23, -1.556021172923850e-24,  4.034032500261900e-12,
 -1.274523845863954e-12,  2.108511566468783e-13, -2.372513838643503e-14,  2.030812714220214e-15, -1.407347155686672e-16,  8.214911014804064e-18, -4.151087371974544e-19,
  1.852564030236859e-20, -7.414218215223121e-22,  2.693101746438754e-23, -8.956951158066235e-25,  1.375101370180176e-12, -4.566956587181891e-13,  7.958283749112313e-14,
 -9.425639005696664e-15,  8.482128085000658e-16, -6.171547827817878e-17,  3.777258739790018e-18, -1.998729186996029e-19,  9.329114853942049e-21, -3.900192356350267e-22,
  1.478177331097160e-23, -5.123608627183393e-25,  4.843421214584198e-13, -1.684317100494539e-13,  3.080400253908648e-14, -3.827139893717790e-15,  3.609046211843035e-16,
 -2.748492190541318e-17,  1.758608967969671e-18, -9.716865461847104e-20,  4.730366348947253e-21, -2.060355550405847e-22,  8.126845827796180e-24, -2.928423977648758e-25,
  1.774798002306662e-13, -6.436972080367990e-14,  1.230933100982321e-14, -1.598584338744768e-15,  1.574359017857673e-16, -1.250848683504103e-17,  8.340880837939914e-19,
 -4.797752848506149e-20,  2.428974087804704e-21, -1.099126721546203e-22,  4.499671946412389e-24, -1.681142832582062e-25,  6.809666692581949e-14, -2.565583836161216e-14,
  5.110177500186977e-15, -6.911393651194512e-16,  7.083378914587012e-17, -5.851316373850742e-18,  4.052829595266738e-19, -2.419171678807198e-20,  1.269772823247617e-21,
 -5.951518089443207e-23,  2.521460196682757e-24, -9.740077149997421e-26,  2.751517928497375e-14, -1.072536643742423e-14,  2.216320559327884e-15, -3.109704032975541e-16,
  3.304339568035122e-17, -2.827791490965362e-18,  2.027390987608721e-19, -1.251593094190522e-20,  6.788534449573861e-22, -3.285303167126928e-23,  1.435989183651394e-24,
 -5.718025689645705e-26,  1.176067816222177e-14, -4.723779412627906e-15,  1.008556060647764e-15, -1.462191714574145e-16,  1.604617460380848e-17, -1.417244607916897e-18,
  1.047924092495402e-19, -6.666972547121819e-21,  3.723874879575318e-22, -1.854531219226828e-23,  8.335718243296167e-25, -3.410703539727167e-26,  5.330015995474213e-15,
 -2.196995081198137e-15,  4.826091759238280e-16, -7.199664885167812e-17,  8.126801913667235e-18, -7.378860733762108e-19,  5.605339602994040e-20, -3.661443860875458e-21,
  2.098431453759678e-22, -1.071613603535668e-23,  4.936117630499613e-25, -2.068420414223411e-26,  2.557942881448648e-15, -1.077582261090680e-15,  2.424871063769356e-16,
 -3.706374666582478e-17,  4.285157423220337e-18, -3.983335902445897e-19,  3.096327310287420e-20, -2.068491513705202e-21,  1.211772179469110e-22, -6.322083808508070e-24,
  2.973573028014638e-25, -1.271626688275647e-26,  1.289368786983062e-15, -5.528449226789301e-16,  1.268770903082750e-16, -1.978161306202968e-17,  2.332363471757395e-18,
 -2.210220491322462e-19,  1.750716551303546e-20, -1.191287962808306e-21,  7.105431345288307e-23, -3.772682125480353e-24,  1.805120284985365e-25, -7.849202274403520e-27,
  6.671813332954482e-16, -2.899599897403327e-16,  6.756007966585619e-17, -1.069572696267357e-17,  1.280307460489954e-18, -1.231415764465512e-19,  9.896925220022692e-21,
 -6.830846039558759e-22,  4.131216688931106e-23, -2.223437533869415e-24,  1.078021820641639e-25, -4.748318650537154e-27,  3.325694049748400e-16, -1.458954264435065e-16,
  3.435301862059423e-17, -5.496803855876040e-18,  6.649545028496157e-19, -6.462184490760529e-20,  5.246606948810147e-21, -3.657279813205954e-22,  2.233406225588614e-23,
 -1.213449780421809e-24,  5.937914624454966e-26, -2.639055834277695e-27,  1.245939533236869e-16, -5.494356243089267e-17,  1.301332942062776e-17, -2.094663824620006e-18,
  2.548890286667845e-19, -2.491433214303145e-20,  2.034264451589902e-21, -1.425908206581987e-22,  8.754882842286865e-24, -4.781879158063062e-25,  2.352071607320167e-26,
 -1.050618669176053e-27,  5.939686345176923e-02, -1.459158035591742e-04,  3.713467183277148e-07, -9.733579788937077e-10,  2.609385344064121e-12, -7.108244086380412e-15,
  1.956370884530363e-17, -5.417973097392362e-20,  1.504700654077344e-22, -4.183273253937007e-25,  1.162055418985050e-27, -3.224305987669118e-30,  5.597207528443982e-02,
 -1.713853667203779e-04,  6.224602880366867e-07, -2.361061519382255e-09,  8.896842179496004e-12, -3.289478681256408e-14,  1.192579357032196e-16, -4.248577444403662e-19,
  1.490697260368174e-21, -5.161609687542698e-24,  1.766420042748611e-26, -5.982183927736254e-29,  4.970738579626342e-02, -2.124447137328188e-04,  1.091124432521255e-06,
 -5.405592973646850e-09,  2.543977148669274e-11, -1.148850849124179e-13,  5.021134091807478e-16, -2.136161765625401e-18,  8.881940865818802e-21, -3.620092646841915e-23,
  1.449693141491878e-25, -5.714512413797522e-28,  4.160829563222550e-02, -2.535950502375158e-04,  1.703317271738540e-06, -1.037538177715031e-08,  5.874302096689415e-11,
 -3.151497174487136e-13,  1.620151903798415e-15, -8.040119468243669e-18,  3.871940010208309e-20, -1.816711883589527e-22,  8.330810742638329e-25, -3.742875919441250e-27,
  3.283608142096078e-02, -2.800358663811582e-04,  2.344414440985593e-06, -1.715109473268465e-08,  1.148292171983451e-10, -7.199476923070254e-13,  4.284427780952488e-15,
 -2.442218339228523e-17,  1.342247825338402e-19, -7.148019716809193e-22,  3.702634032915494e-24, -1.871217953717534e-26,  2.443849063363933e-02, -2.829739194793552e-04,
  2.878995693366036e-06, -2.495920537800165e-08,  1.951297164276892e-10, -1.412371597042872e-12,  9.617488828506644e-15, -6.228355712798886e-17,  3.866018481923543e-19,
 -2.313457439365956e-21,  1.340667674907572e-23, -7.550608816937596e-26,  1.716036449164412e-02, -2.617422645948636e-04,  3.188908169280993e-06, -3.242365013893370e-08,
  2.930199960229020e-10, -2.425463326210856e-12,  1.873232228368043e-14, -1.366782725966813e-16,  9.505621723503990e-19, -6.343298866332834e-21,  4.082496023399674e-23,
 -2.544239824371508e-25,  1.137432279258292e-02, -2.224365775993874e-04,  3.211894405643543e-06, -3.796352835798034e-08,  3.933252128762494e-10, -3.695118311849731e-12,
  3.213977877902145e-14, -2.624545159018533e-16,  2.032232770375341e-18, -1.503178403989679e-20,  1.068163859807219e-22, -7.324773979050906e-25,  7.120861606821570e-03,
 -1.744353670950309e-04,  2.959927316679410e-06, -4.035639512185181e-08,  4.760314160371169e-10, -5.043769358087721e-12,  4.911871227634545e-14, -4.464480884958285e-16,
  3.828765744141842e-18, -3.123404807578116e-20,  2.438861143436123e-22, -1.831702513148013e-24,  4.213616989989021e-03, -1.267534410515180e-04,  2.508218745067020e-06,
 -3.917909983496721e-08,  5.230281769784158e-10, -6.216538202501682e-12,  6.744583049752253e-14, -6.791469811941513e-16,  6.422419681171324e-18, -5.753960898755717e-20,
  4.916967129960912e-22, -4.028837138135384e-24,  2.358582276546989e-03, -8.566594851868634e-05,  1.962711251386575e-06, -3.490986375448501e-08,  5.246701902056680e-10,
 -6.962555365600586e-12,  8.379321941371448e-14, -9.309890822865283e-16,  9.670880758453176e-18, -9.480941208214969e-20,  8.835637371396786e-22, -7.871816814750057e-24,
  1.250066954962511e-03, -5.403078860473451e-05,  1.423600517949039e-06, -2.867324945176601e-08,  4.828797541120244e-10, -7.124578199669430e-12,  9.474740466727574e-14,
 -1.157390073003433e-15,  1.316216729684739e-17, -1.407480410742900e-19,  1.426124273250081e-21, -1.377438185579459e-23,  6.280215602313305e-04, -3.190003380215128e-05,
  9.604095335497446e-07, -2.179400047834086e-08,  4.095090682291312e-10, -6.692307556970628e-12,  9.800637520998283e-14, -1.312064494494359e-15,  1.628641301212458e-17,
 -1.894236519649861e-19,  2.081124145806770e-21, -2.173486603281159e-23,  2.994424400231316e-04, -1.768072640598256e-05,  6.045970106679540e-07, -1.538498643599195e-08,
  3.212746882920664e-10, -5.795284804461352e-12,  9.316637218986357e-14, -1.362977562211195e-15,  1.841629928186960e-17, -2.323752928329157e-19,  2.761468653309252e-21,
 -3.111173608313427e-23,  1.356939064813295e-04, -9.224798605512773e-06,  3.562582776445008e-07, -1.012146596504363e-08,  2.340371342468386e-10, -4.644887470205627e-12,
  8.173505785616662e-14, -1.303196268495583e-15,  1.911997616481781e-17, -2.611172426055717e-19,  3.348913351767269e-21, -4.061494520469972e-23,  5.853364648191561e-05,
 -4.542845987575852e-06,  1.970939998373379e-07, -6.226068801904522e-09,  1.588644573976538e-10, -3.458656881343747e-12,  6.643837044594699e-14, -1.151645216700610e-15,
  1.830462352257663e-17, -2.699785748977008e-19,  3.729267001512136e-21, -4.859032902603148e-23,  2.407833343942637e-05, -2.117312509857476e-06,  1.026850822710915e-07,
 -3.592751775820503e-09,  1.008336307925087e-10, -2.401320907486873e-12,  5.022732235145035e-14, -9.443467329903917e-16,  1.622570016387023e-17, -2.579375109671535e-19,
  3.830037476017476e-21, -5.351551195799556e-23,  9.464469153667891e-06, -9.365437101744472e-07,  5.053596066837616e-08, -1.951222566214174e-09,  6.005035760287056e-11,
 -1.560129008222882e-12,  3.544752037430947e-14, -7.213007516726280e-16,  1.337011489963515e-17, -2.286445743752070e-19,  3.643013222169784e-21, -5.449300747129719e-23,
  3.562820385800099e-06, -3.942826463080280e-07,  2.356808137943174e-08, -1.000697157693074e-09,  3.367189777967078e-11, -9.519186172721292e-13,  2.344033722734226e-14,
 -5.151379702835926e-16,  1.028126699443768e-17, -1.887983910795005e-19,  3.222287465380270e-21, -5.151544959626628e-23,  1.287697572244459e-06, -1.584687671893101e-07,
  1.044975549587440e-08, -4.863074058110072e-10,  1.784054438891193e-11, -5.474648831166895e-13,  1.457801482051478e-14, -3.453110384013957e-16,  7.406727805814679e-18,
 -1.457956855712341e-19,  2.661093413022864e-21, -4.539875027504150e-23,  4.481020511110202e-07, -6.100192763149920e-08,  4.420262693596782e-09, -2.247460530195913e-10,
  8.964776525903861e-12, -2.978961531571148e-13,  8.559571576657314e-15, -2.181042039557693e-16,  5.018613027635556e-18, -1.057134880248623e-19,  2.060149263981059e-21,
 -3.744809192241924e-23,  1.506057543804828e-07, -2.256936795003079e-08,  1.790371815074059e-09, -9.914908968835616e-11,  4.288817229250669e-12, -1.539664649343069e-13,
  4.763703184532332e-15, -1.303228545928928e-16,  3.211214589598897e-18, -7.226355784180149e-20,  1.501260754834408e-21, -2.903237965384907e-23,  4.905863400742594e-08,
 -8.055715644607326e-09,  6.970957458314404e-10, -4.192197582285714e-11,  1.961410158048624e-12, -7.589670527202551e-14,  2.523313177274243e-15, -7.397477861919632e-17,
  1.948469914212215e-18, -4.676572060082181e-20,  1.034078493857583e-21, -2.124359897025510e-23,  1.554773065756822e-08, -2.785267029968743e-09,  2.620111786236395e-10,
 -1.706105936017157e-11,  8.612002571685953e-13, -3.583740005346833e-14,  1.277665193807472e-15, -4.006271715923942e-17,  1.126013334244429e-18, -2.877666272837941e-20,
  6.761977466251994e-22, -1.473486797497800e-23,  4.814337429364726e-09, -9.369728348730454e-10,  9.549648386047267e-11, -6.713745308577870e-12,  3.647011621757653e-13,
 -1.628399127278936e-14,  6.212600612450141e-16, -2.079581480309977e-17,  6.225817499058804e-19, -1.691323248982363e-20,  4.216735494182483e-22, -9.731661430626645e-24,
  1.463343541385344e-09, -3.081535819924851e-10,  3.391626512506641e-11, -2.567102509202114e-12,  1.496900941346370e-13, -7.155097328550522e-15,  2.915072329459872e-16,
 -1.039647684602758e-17,  3.309278479437456e-19, -9.540067023796692e-21,  2.519476269184627e-22, -6.148688654358798e-24,  4.388428163433982e-10, -9.959645890013759e-11,
  1.179930859235284e-11, -9.587784876886618e-13,  5.986065844255918e-14, -3.056019518454354e-15,  1.326729129941258e-16, -5.031390509974964e-18,  1.699608960183604e-19,
 -5.190228212278101e-21,  1.449517717803132e-22, -3.734712259773854e-24,  1.305669726743944e-10, -3.181228699645828e-11,  4.043689006524257e-12, -3.517447490307480e-13,
  2.345328685256244e-14, -1.275797538264402e-15,  5.889053651874898e-17, -2.369880708938755e-18,  8.479277166503722e-20, -2.737893702794778e-21,  8.071796111761669e-23,
 -2.191967519647455e-24,  3.877266948373698e-11, -1.010282961035444e-11,  1.373378222235659e-12, -1.275184254746491e-13,  9.056416378419574e-15, -5.236470755904556e-16,
  2.564197236929123e-17, -1.092641955269518e-18,  4.132394123662122e-20, -1.408130028292810e-21,  4.374344006654130e-23, -1.249792618347916e-24,  1.156607887807126e-11,
 -3.210656670335441e-12,  4.652478701274751e-13, -4.597464043799202e-14,  3.468403567003539e-15, -2.126268813476555e-16,  1.101917982547748e-17, -4.960751209167775e-19,
  1.978963817343322e-20, -7.101980005579824e-22,  2.320173463053519e-23, -6.961323776066274e-25,  3.489769036374063e-12, -1.028077180213729e-12,  1.582754875352849e-13,
 -1.659514402517532e-14,  1.326165637887243e-15, -8.597005223758955e-17,  4.703441793352993e-18, -2.231824009430630e-19,  9.369986279904236e-21, -3.533825018665279e-22,
  1.211595921236260e-23, -3.809850328304563e-25,  1.072751795512248e-12, -3.340944987426822e-13,  5.445955634396176e-14, -6.039652422848092e-15,  5.097534064513771e-16,
 -3.484731336869784e-17,  2.007410175762966e-18, -1.001476181654739e-19,  4.414378529996401e-21, -1.745593465741446e-22,  6.267115861676743e-24, -2.060956342855975e-25,
  3.385010362519746e-13, -1.110129943947551e-13,  1.909288722562097e-14, -2.232354248007420e-15,  1.983849395108865e-16, -1.425977300959293e-17,  8.625260007991327e-19,
 -4.512152670895078e-20,  2.082839441819737e-21, -8.614526973094885e-23,  3.231022726630584e-24, -1.108656831589405e-25,  1.104880828089886e-13, -3.800620457233298e-14,
  6.871802214164972e-15, -8.441841086690804e-16,  7.873689757487748e-17, -5.932538454366559e-18,  3.756763759529766e-19, -2.054965842605621e-20,  9.906896700292988e-22,
 -4.274397746318862e-23,  1.670570945570057e-24, -5.966362588014848e-26,  3.759188110247793e-14, -1.350877931878084e-14,  2.558107502988630e-15, -3.290129449630405e-16,
  3.209764460532734e-17, -2.526849238874084e-18,  1.669965004581778e-19, -9.522879354238424e-21,  4.780782705726757e-22, -2.145736726731868e-23,  8.714948196626986e-25,
 -3.231093225601756e-26,  1.343086503738065e-14, -5.021597216292443e-15,  9.920585020119632e-16, -1.330876073930642e-16,  1.353194484843109e-17, -1.109206529859482e-18,
  7.625194616524139e-20, -4.518424752876354e-21,  2.354864697670698e-22, -1.096165564782520e-23,  4.613120056873401e-25, -1.770468283832141e-26,  5.073063173995309e-15,
 -1.965315089952942e-15,  4.034237399137731e-16, -5.623004860785271e-17,  5.936259955218466e-18, -5.048079071842685e-19,  3.597014033063084e-20, -2.207338965819763e-21,
  1.190301910944937e-22, -5.728009298480411e-24,  2.489981963338715e-25, -9.862353620513936e-27,  2.037001170871523e-15, -8.142580418623053e-16,  1.729418619896675e-16,
 -2.494220009292111e-17,  2.723170642227837e-18, -2.393180362421702e-19,  1.760944383495553e-20, -1.115033923889661e-21,  6.199485901216136e-23, -3.073633695572831e-24,
  1.375538914405946e-25, -5.604579758134692e-27,  8.724681277963995e-16, -3.583379886518436e-16,  7.840604254349380e-17, -1.165075026757065e-17,  1.310022003588752e-18,
 -1.184963549478304e-19,  8.968441377979777e-21, -5.837273603368438e-22,  3.333787625814375e-23, -1.696714513947028e-24,  7.789763758658880e-26, -3.253786415087199e-27,
  3.984967130057930e-16, -1.674502259591164e-16,  3.757585697685128e-17, -5.727296232891295e-18,  6.603385068269306e-19, -6.121717185331482e-20,  4.746016038021214e-21,
 -3.162439763458729e-22,  1.848015837558397e-23, -9.618129514846656e-25,  4.513187619623711e-26, -1.925615000921641e-27,  1.927061672131788e-16, -8.249054668804674e-17,
  1.889666670329105e-17, -2.940760889980874e-18,  3.461002377165662e-19, -3.273903327820458e-20,  2.588746064934803e-21, -1.758543264609618e-22,  1.047149630459617e-23,
 -5.550978065538654e-25,  2.651826031910971e-26, -1.151340925887175e-27,  9.651437398264342e-17, -4.190500010732136e-17,  9.753202455341108e-18, -1.542383874929350e-18,
  1.844282894993535e-19, -1.771978147964996e-20,  1.422672106377564e-21, -9.809362250479556e-23,  5.926754118351072e-24, -3.186744954043210e-25,  1.543632564744201e-26,
 -6.793001217442079e-28,  4.701236334990633e-17, -2.061389051114456e-17,  4.851152510230531e-18, -7.757985758731550e-19,  9.379759208445204e-20, -9.110541202452151e-21,
  7.392870849662059e-22, -5.150714556549242e-23,  3.143813077716932e-24, -1.707243481163127e-25,  8.350205257125518e-27, -3.709426025352266e-28,  1.738532109468839e-17,
 -7.664930474176421e-18,  1.814983335434794e-18, -2.920715403401079e-19,  3.553178774976270e-20, -3.472220639907696e-21,  2.834386637924407e-22, -1.986270899523528e-23,
  1.219253885664585e-24, -6.657957044660568e-26,  3.274109437347943e-27, -1.462143438659556e-28,  5.881906879778414e-02, -1.429910518840346e-04,  3.599123133838886e-07,
 -9.327201275433387e-10,  2.471795626911068e-12, -6.656388965181809e-15,  1.811188536843438e-17, -4.959694448693196e-20,  1.362138861346207e-22, -3.745608591170215e-25,
  1.029173949042011e-27, -2.825166256840847e-30,  5.529631709320636e-02, -1.665166444373587e-04,  5.949604290169068e-07, -2.223823647871068e-09,  8.266631917361608e-12,
 -3.017012514127020e-14,  1.080027598302288e-16, -3.799971354458930e-19,  1.316988112140202e-21, -4.504969386277576e-24,  1.523223123286374e-26, -5.097301281318756e-29,
  4.887466365106721e-02, -2.039684375876328e-04,  1.028625777463476e-06, -5.016303261034828e-09,  2.325789320939461e-11, -1.035211617061141e-13,  4.460917730487620e-16,
 -1.871719595218608e-18,  7.677300135744121e-21, -3.087517621452793e-23,  1.220218717538828e-25, -4.747728265448806e-28,  4.062040192120700e-02, -2.404510179588911e-04,
  1.584250661893403e-06, -9.483878816593275e-09,  5.281132684049470e-11, -2.788333634476289e-13,  1.411435698828216e-15, -6.899618579626929e-18,  3.274139552425117e-20,
 -1.514211398083286e-22,  6.845866946977422e-25, -3.033075299588809e-27,  3.175218779929347e-02, -2.620736289960375e-04,  2.149167226096399e-06, -1.542365605629126e-08,
  1.014055475993438e-10, -6.248647160668929e-13,  3.657065675774707e-15, -2.051166748417157e-17,  1.109706940742443e-19, -5.819356611408498e-22,  2.969253307353135e-24,
 -1.478514942063574e-26,  2.335083418579169e-02, -2.610889886781026e-04,  2.597324578971050e-06, -2.205113690438410e-08,  1.690561339312574e-10, -1.201154597242262e-12,
  8.034928342662010e-15, -5.114751409588260e-17,  3.122199350330157e-19, -1.838170058901821e-21,  1.048407238530958e-23, -5.813183559088726e-26,  1.616206161793566e-02,
 -2.377111672302522e-04,  2.826429194674470e-06, -2.810021931964583e-08,  2.487134085936308e-10, -2.018574512766290e-12,  1.529897886648578e-14, -1.096195150349554e-16,
  7.490858168629358e-19, -4.914016000592563e-21,  3.110263008476588e-23, -1.906942753477481e-25,  1.053322552486998e-02, -1.984620434382344e-04,  2.791781744007243e-06,
 -3.222200609435833e-08,  3.265771057988556e-10, -3.005071808218783e-12,  2.562567387894308e-14, -2.053159067989109e-16,  1.560814341270138e-18, -1.134042481482453e-20,
  7.919509471378557e-23, -5.339164002777927e-25,  6.467585077447905e-03, -1.525708455115466e-04,  2.518217139668017e-06, -3.348685853779655e-08,  3.859993518140185e-10,
 -4.002057365058373e-12,  3.817697689506049e-14, -3.401826809885207e-16,  2.862103438288997e-18, -2.291891158998225e-20,  1.757567722808373e-22, -1.296981373265266e-24,
  3.743946181562040e-03, -1.084349324394446e-04,  2.084445516914006e-06, -3.172341665943349e-08,  4.134564749822081e-10, -4.804594586991306e-12,  5.102073391889149e-14,
 -5.032980703464705e-16,  4.666072553362598e-18, -4.100954620386231e-20,  3.439683983111945e-22, -2.767673403393143e-24,  2.044857076715777e-03, -7.150713644444232e-05,
  1.589897094707287e-06, -2.752815519963978e-08,  4.035861558353509e-10, -5.232286178393210e-12,  6.158994120472626e-14, -6.699345157121098e-16,  6.818391832045736e-18,
 -6.553711088669550e-20,  5.991666419790439e-22, -5.239430643902772e-24,  1.054714338396966e-03, -4.389703522282914e-05,  1.121547804146119e-06, -2.197377367202064e-08,
  3.607300581504296e-10, -5.196244859785889e-12,  6.754752733823138e-14, -8.073477148536129e-16,  8.990941547950310e-18, -9.421590791640551e-20,  9.360769124616502e-22,
 -8.870279027372366e-24,  5.142764487447559e-04, -2.516088306190461e-05,  7.341597100792450e-07, -1.619633100848583e-08,  2.964882590686479e-10, -4.727886283372116e-12,
  6.764426967439991e-14, -8.856429443326550e-16,  1.076038076522723e-17, -1.225900830586440e-19,  1.320135302484032e-21, -1.352156993636075e-23,  2.373365044688849e-04,
 -1.350312235795692e-05,  4.473554187912297e-07, -1.106221750000863e-08,  2.249516275073114e-10, -3.957687981568476e-12,  6.213365328600382e-14, -8.886049399384805e-16,
  1.174781804906276e-17, -1.451477716408457e-19,  1.690116640358189e-21, -1.866883894148012e-23,  1.038069777586602e-04, -6.803329322567255e-06,  2.545167440427244e-07,
 -7.024736657681597e-09,  1.581237127783926e-10, -3.059823446508071e-12,  5.256401279186563e-14, -8.190425720379826e-16,  1.175413041675863e-17, -1.571389911395719e-19,
  1.974223126774494e-21, -2.346879331924577e-23,  4.309730608761667e-05, -3.226478417225650e-06,  1.356027622613108e-07, -4.160865454218146e-09,  1.033320054350471e-10,
 -2.192945426661611e-12,  4.111497070324600e-14, -6.963383228862128e-16,  1.082374079412330e-17, -1.562446299242602e-19,  2.113796442610087e-21, -2.699159813197893e-23,
  1.701338974268441e-05, -1.444122370025626e-06,  6.785713420800124e-08, -2.306163540161557e-09,  6.299032033037393e-11, -1.462120362762648e-12,  2.984557148511248e-14,
 -5.481974060517985e-16,  9.210229045775451e-18, -1.432815296500296e-19,  2.083512096249083e-21, -2.852790969943082e-23,  6.398850176351549e-06, -6.116829648904676e-07,
  3.198930651862200e-08, -1.199899273595248e-09,  3.594017836907125e-11, -9.101045317097431e-13,  2.017972404743497e-14, -4.011422674546289e-16,  7.270501066976974e-18,
 -1.216704426505495e-19,  1.898411399612978e-21, -2.782650957907900e-23,  2.297971885483272e-06, -2.458829182921202e-07,  1.425101431308677e-08, -5.879953200108131e-10,
  1.925927736100070e-11, -5.307494226325845e-13,  1.275527567321635e-14, -2.738622943981519e-16,  5.344762632262162e-18, -9.605041875348483e-20,  1.605442136369705e-21,
 -2.515251940704767e-23,  7.899506546756280e-07, -9.408405173845907e-08,  6.019065000932067e-09, -2.723044501417412e-10,  9.727035193008766e-12, -2.910360644034895e-13,
  7.565009740157138e-15, -1.750967341329256e-16,  3.673113045036077e-18, -7.076769086519315e-20,  1.265146878279972e-21, -2.115431333026750e-23,  2.606635256528408e-07,
 -3.437862630049707e-08,  2.418497297455197e-09, -1.196012164409559e-10,  4.647196075011068e-12, -1.506208411756982e-13,  4.225947108448326e-15, -1.052472698957132e-16,
  2.369082775500170e-18, -4.885541324708131e-20,  9.327616479837542e-22, -1.662160384271714e-23,  8.282148338228236e-08, -1.203806922282167e-08,  9.278663393366765e-10,
 -5.000970139262761e-11,  2.108346442047787e-12, -7.385828517377225e-14,  2.232277695648938e-15, -5.971208578765640e-17,  1.439836055147419e-18, -3.173168208718842e-20,
  6.460378246063665e-22, -1.225152589958139e-23,  2.542752406103280e-08, -4.054729487704194e-09,  3.412365410094590e-10, -1.998740674885123e-11,  9.120183450806863e-13,
 -3.445688049570742e-14,  1.119645720698175e-15, -3.210998361234511e-17,  8.280337354138302e-19, -1.947143446514485e-20,  4.221144068636465e-22, -8.507134820187614e-24,
  7.572720151602272e-09, -1.319144055498001e-09,  1.208086193456611e-10, -7.668554540723598e-12,  3.778012500622551e-13, -1.536072166323637e-14,  5.355769885645745e-16,
 -1.643791040566107e-17,  4.525717053641860e-19, -1.133779010340210e-20,  2.613285692842230e-22, -5.589201631025720e-24,  2.197159040537283e-09, -4.163907077789445e-10,
  4.136248598779904e-11, -2.837523123913287e-12,  1.505716966261680e-13, -6.573989661799791e-15,  2.454660924251737e-16, -8.048135686433088e-18,  2.361767206104298e-19,
 -6.293351283436873e-21,  1.539985405696533e-22, -3.490348395682604e-24,  6.240333466965046e-10, -1.281509993731669e-10,  1.376397408817607e-11, -1.017669154616046e-12,
  5.802502445121769e-14, -2.714519060906483e-15,  1.083285646825151e-16, -3.787268006580404e-18,  1.182556458332251e-19, -3.346319832809082e-21,  8.679840421308578e-23,
 -2.081690375945416e-24,  1.744125900250990e-10, -3.866193230920890e-11,  4.475630788934555e-12, -3.556806412233914e-13,  2.173777526914003e-14, -1.087235287916510e-15,
  4.627829979946279e-17, -1.721941329019401e-18,  5.710818488675279e-20, -1.713238148351849e-21,  4.703067461826371e-23, -1.191726695731690e-24,  4.824811392284422e-11,
 -1.150059853169317e-11,  1.430463637626196e-12, -1.218511289338353e-13,  7.962573112148884e-15, -4.248226554852298e-16,  1.924659287306495e-17, -7.606793353028972e-19,
  2.674637472102170e-20, -8.491797902265559e-22,  2.462974925697883e-23, -6.583450615923745e-25,  1.329387939240345e-11, -3.394543596980367e-12,  4.522230604325752e-13,
 -4.117520607203199e-14,  2.869614781899016e-15, -1.629316672022389e-16,  7.839643985655368e-18, -3.284441916912015e-19,  1.221991019248464e-20, -4.098451426119981e-22,
  1.253761050327071e-23, -3.529180341521321e-25,  3.673300614985330e-12, -1.000993373975887e-12,  1.423729836720027e-13, -1.381637766435198e-14,  1.024243614783315e-15,
 -6.173798026229175e-17,  3.147712070833520e-18, -1.394894737363161e-19,  5.480281790572039e-21, -1.937872258199747e-22,  6.240857921817960e-24, -1.846666004621606e-25,
  1.025367662961355e-12, -2.970605503290294e-13,  4.496207102621258e-14, -4.636697904616824e-15,  3.646270950498532e-16, -2.327304377128061e-17,  1.254296492884680e-18,
 -5.865912715221986e-20,  2.428327564569248e-21, -9.034341491635039e-23,  3.056839318392862e-24, -9.489973394952978e-26,  2.914127903821462e-13, -8.941113245861193e-14,
  1.435280771094927e-14, -1.568037532729698e-15,  1.304307885020039e-16, -8.791562203215930e-18,  4.995817551959884e-19, -2.459652156129818e-20,  1.070397813128303e-21,
 -4.180539288200871e-23,  1.482971808368394e-24, -4.820282468229352e-26,  8.501595701873337e-14, -2.751709635741141e-14,  4.668529288554133e-15, -5.385882858146533e-16,
  4.724431579157309e-17, -3.353305817866837e-18,  2.003657482707495e-19, -1.035836604709772e-20,  4.726916952258913e-22, -1.933390873945161e-23,  7.173623885593668e-25,
 -2.435856474892176e-26,  2.567611352485775e-14, -8.732158727487389e-15,  1.560127078589095e-15, -1.894191192837818e-16,  1.746605466971339e-17, -1.301465208090725e-18,
  8.153190380052437e-20, -4.413494363777281e-21,  2.106285734017149e-22, -8.998871346056340e-24,  3.483674912360312e-25, -1.232736383970998e-26,  8.096690472859704e-15,
 -2.881556791879767e-15,  5.401170247697507e-16, -6.876856131998439e-17,  6.643000625030426e-18, -5.179706212174135e-19,  3.391489506440221e-20, -1.916590182505478e-21,
  9.537942569035840e-23, -4.244625736214555e-24,  1.709791512396174e-25, -6.288601211052787e-27,  2.688253460573367e-15, -9.970543348728535e-16,  1.952945476556201e-16,
 -2.597743407322106e-17,  2.619435806539561e-18, -2.129836769951436e-19,  1.452686067301920e-20, -8.542686725581011e-22,  4.419336677267211e-23, -2.042419345920197e-24,
  8.535553252572413e-26, -3.253769407513785e-27,  9.471214976031201e-16, -3.645435765381601e-16,  7.430916976115267e-17, -1.028556469873475e-17,  1.078485647054934e-18,
 -9.110580584704259e-20,  6.450014821453173e-21, -3.933384464358830e-22,  2.108199802587315e-23, -1.008536972207746e-24,  4.359046065361918e-26, -1.716958055797523e-27,
  3.564525920764714e-16, -1.417662379842454e-16,  2.994466701566566e-17, -4.295043095098746e-18,  4.664092471546817e-19, -4.077420720574745e-20,  2.984938312987453e-21,
 -1.880700441174765e-22,  1.040615480746771e-23, -5.135106421331821e-25,  2.287656529814290e-26, -9.279878286829615e-28,  1.439601552745368e-16, -5.890353463508701e-17,
  1.283498952910940e-17, -1.899310630770821e-18,  2.126909567076084e-19, -1.916223293806616e-20,  1.444688948389531e-21, -9.367632550606045e-23,  5.330473757032790e-24,
 -2.703269755005653e-25,  1.236804453258066e-26, -5.148820936215488e-28,  6.244562799316630e-17, -2.616989418460228e-17,  5.855211150275380e-18, -8.898083203709781e-19,
  1.022934271983197e-19, -9.456222023868630e-21,  7.310860716232166e-22, -4.858349306032299e-23,  2.831596526538313e-24, -1.469964814822993e-25,  6.880515493428119e-27,
 -2.928605656348745e-28,  2.891531242706276e-17, -1.235599895214815e-17,  2.824978977206304e-18, -4.387742692558525e-19,  5.154035912354451e-20, -4.866242192696817e-21,
  3.840783120199901e-22, -2.604393114389624e-23,  1.548124938292690e-24, -8.192771751436497e-26,  3.907421739319980e-27, -1.693769696774473e-28,  1.399484618651161e-17,
 -6.070131897950780e-18,  1.411181577131454e-18, -2.229088477587669e-19,  2.662368158126446e-20, -2.555139921838758e-21,  2.049217909295531e-22, -1.411441040568570e-23,
  8.519011181291701e-25, -4.575951485074210e-26,  2.214374867922334e-27, -9.735409092775519e-29,  6.653760910018870e-18, -2.916034898496039e-18,  6.858471663587750e-19,
 -1.096170262200433e-19,  1.324554648557429e-20, -1.285807268904744e-21,  1.042805619480356e-22, -7.261419877594069e-24,  4.429757368189527e-25, -2.404324786555845e-26,
  1.175369654334964e-27, -5.218785111303767e-29,  2.427191352152903e-18, -1.069871354130676e-18,  2.532705754948124e-19, -4.074627696028877e-20,  4.955673874235713e-21,
 -4.841513669396960e-22,  3.951142484909302e-23, -2.768174975150716e-24,  1.698800696881378e-25, -9.274366916624373e-27,  4.559668292847179e-28, -2.035770724848028e-29,
  5.825279323655304e-02, -1.401558615812511e-04,  3.489526462523126e-07, -8.942132653068722e-10,  2.342904707934826e-12, -6.237887921508907e-15,  1.678222288934114e-17,
 -4.544613872437374e-20,  1.234417092486057e-22, -3.357745697932570e-25,  9.126613843604240e-28, -2.478933578975497e-30,  5.463960398678079e-02, -1.618615009776493e-04,
  5.690486761452439e-07, -2.096247455390502e-09,  7.688312234331656e-12, -2.770112146897165e-14,  9.792928347519481e-17, -3.403350335903859e-19,  1.165256900816888e-21,
 -3.938248699820045e-24,  1.315809773421141e-26, -4.351471255098593e-29,  4.807487540233803e-02, -1.959740414368592e-04,  9.705964088911873e-07, -4.660175984031549e-09,
  2.129042617540830e-11, -9.341709015655715e-14,  3.969624451586454e-16, -1.642927455394855e-18,  6.648840211179067e-21, -2.638759958762177e-23,  1.029348171223308e-25,
 -3.953816757779661e-28,  3.968324482061438e-02, -2.282182863527401e-04,  1.475335760873047e-06, -8.681734030190560e-09,  4.755834696942608e-11, -2.471636398173261e-13,
  1.232131253351848e-15, -5.934077788167121e-18,  2.775259712999528e-20, -1.265303769470832e-22,  5.640861053030945e-25, -2.464919973728269e-27,  3.073714548644804e-02,
 -2.455939641217092e-04,  1.973420806027408e-06, -1.389656512749717e-08,  8.974142314131994e-11, -5.436043584835130e-13,  3.129460767373243e-15, -1.727409167808788e-17,
  9.201090426445086e-20, -4.752196413551143e-22,  2.388835236410584e-24, -1.172194427689251e-26,  2.234642213127600e-02, -2.413246233699674e-04,  2.348180219272571e-06,
 -1.952841331863886e-08,  1.468510076773902e-10, -1.024431264823221e-12,  6.733273621754894e-15, -4.213907459405859e-17,  2.530161697977771e-19, -1.465814985558902e-21,
  8.229694201720093e-24, -4.493284410115882e-26,  1.525439581736756e-02, -2.163838377635285e-04,  2.511832675257662e-06, -2.442482369320020e-08,  2.117783914839823e-10,
 -1.685677747304917e-12,  1.254024958219493e-14, -8.825462911981211e-17,  5.926905911930392e-19, -3.822821404758494e-21,  2.379973036533779e-23, -1.435805392447202e-25,
  9.781716632119752e-03, -1.775899767221704e-04,  2.434588862116783e-06, -2.744602570433509e-08,  2.721878187117354e-10, -2.453754330270791e-12,  2.051880548312670e-14,
 -1.613337094178387e-16,  1.204337829589703e-18, -8.597040622728532e-21,  5.901165836659899e-23, -3.912070989758404e-25,  5.895188760698078e-03, -1.339332608268584e-04,
  2.150942255688121e-06, -2.790447695960615e-08,  3.143995646627596e-10, -3.190478425112703e-12,  2.981911057551205e-14, -2.605440892546358e-16,  2.150921412430604e-18,
 -1.691038468650712e-20,  1.273821436223467e-22, -9.237589327948260e-25,  3.341296256175956e-03, -9.317652549167898e-05,  1.740488420376495e-06, -2.581482158081454e-08,
  3.285498178649203e-10, -3.733607389850498e-12,  3.881448132113763e-14, -3.751710256283222e-16,  3.410591492286954e-18, -2.941084998337730e-20,  2.421698715858002e-22,
 -1.913828266620926e-24,  1.782319856957036e-03, -6.000699694147713e-05,  1.295093933970971e-06, -2.183358979009892e-08,  3.123213460362174e-10, -3.956595449408804e-12,
  4.556226569669346e-14, -4.852860477193517e-16,  4.840104986855567e-18, -4.562004481616117e-20,  4.092252057392739e-22, -3.512914749616344e-24,  8.955297396540538e-04,
 -3.588863729460261e-05,  8.893287293942868e-07, -1.695254872035206e-08,  2.713411099822670e-10, -3.816755143840973e-12,  4.850724963560932e-14, -5.673797549813680e-16,
  6.188553809101787e-18, -6.355987158214579e-20,  6.193130611682448e-22, -5.758531619782455e-24,  4.242536015537324e-04, -1.999103695511581e-05,  5.654104759521098e-07,
 -1.212855269601800e-08,  2.163415454312950e-10, -3.366830650727667e-12,  4.706989216154748e-14, -6.027918082554006e-16,  7.169715182078132e-18, -8.002259736057271e-20,
  8.447661221409832e-22, -8.486989002921628e-24,  1.897200387652872e-04, -1.039960699101176e-05,  3.338331426627419e-07, -8.022952055189412e-09,  1.588952225233681e-10,
 -2.726970083181317e-12,  4.181467209091648e-14, -5.846866187409330e-16,  7.564229522571570e-18, -9.152493555827577e-20,  1.044372949926644e-21, -1.131160381195117e-23,
  8.018715321121109e-05, -5.065614512021461e-06,  1.835827273486674e-07, -4.922880102565347e-09,  1.078843330717001e-10, -2.035710845321350e-12,  3.414421300653044e-14,
 -5.199969808759668e-16,  7.300276892949392e-18, -9.554862161388051e-20,  1.176048578400233e-21, -1.370487572953327e-23,  3.208049746967483e-05, -2.316286773259343e-06,
  9.430202241235290e-08, -2.810796961697185e-09,  6.794356705345666e-11, -1.405683859850063e-12,  2.572507098241116e-14, -4.257297850978557e-16,  6.472056624122711e-18,
 -9.144597029486598e-20,  1.211771409494213e-21, -1.516554350434376e-23,  1.216889376135004e-05, -9.968210229291335e-07,  4.537837075445912e-08, -1.498014544514737e-09,
  3.982134826909466e-11, -9.009633264443520e-13,  1.794864256757155e-14, -3.220896160529383e-16,  5.291693273941718e-18, -8.056493791374184e-20,  1.147338615995074e-21,
 -1.539516493831267e-23,  4.384926388402153e-06, -4.048175497377520e-07,  2.051594307021812e-08, -7.475517895413193e-10,  2.179186082040309e-11, -5.378618942158483e-13,
  1.163851183242031e-14, -2.260165713757989e-16,  4.005547353982757e-18, -6.559743440319760e-20,  1.002321294515061e-21, -1.439703002269626e-23,  1.504222608165230e-06,
 -1.555703936941321e-07,  8.741176833145349e-09, -3.504303269098133e-10,  1.117221679005141e-11, -3.001141111876544e-13,  7.038974756621261e-15, -1.476470725985763e-16,
  2.817649845760035e-18, -4.955318121849701e-20,  8.111324401409157e-22, -1.245340227748286e-23,  4.924479815398510e-07, -5.674207623549013e-08,  3.521038905722369e-09,
 -1.548278919150450e-10,  5.384590973741015e-12, -1.570715678581614e-13,  3.985186125851172e-15, -9.012525139917242e-17,  1.848925522549192e-18, -3.486433548159423e-20,
  6.104615154992235e-22, -1.000396114128802e-23,  1.542776664424941e-07, -1.970502416024648e-08,  1.345446690219316e-09, -6.470114900023739e-11,  2.448517883499256e-12,
 -7.739378759081930e-14,  2.120047256504758e-15, -5.160143386195344e-17,  1.136161318841667e-18, -2.293615501046997e-20,  4.289761640777057e-22, -7.493301185101862e-24,
  4.639670880501757e-08, -6.537970603066344e-09,  4.894797901677982e-10, -2.566933642292530e-11,  1.054503114214500e-12, -3.604071877647893e-14,  1.063902935986900e-15,
 -2.782212386289970e-17,  6.564241787488851e-19, -1.416576977270843e-20,  2.826062805919830e-22, -5.254977557660293e-24,  1.344084001592637e-08, -2.080377052413781e-09,
  1.702076562455660e-10, -9.707294237103589e-12,  4.318684821511864e-13, -1.592726640030772e-14,  5.057222175246887e-16, -1.418521536156826e-17,  3.580679114476124e-19,
 -8.248211097461502e-21,  1.752793346808974e-22, -3.464956685598932e-24,  3.765457791790391e-09, -6.374868570673256e-10,  5.681310759463554e-11, -3.514309786248485e-12,
  1.689302072106192e-13, -6.708899034502637e-15,  2.287082994747994e-16, -6.869215687256675e-18,  1.852215774212485e-19, -4.547662645605301e-21,  1.027987919216608e-22,
 -2.157550811110584e-24,  1.024609976236295e-09, -1.889754706517638e-10,  1.828763797755744e-11, -1.223695875635753e-12,  6.340972140877607e-14, -2.706229514596583e-15,
  9.886657090542057e-17, -3.174212719570193e-18,  9.128262085326432e-20, -2.385298454646949e-21,  5.727466068879832e-23, -1.274561483802085e-24,  2.721217456581385e-10,
 -5.446490352957927e-11,  5.705653967549827e-12, -4.119141337028038e-13,  2.295639738176927e-14, -1.050703654161646e-15,  4.105840527683196e-17, -1.406683030039714e-18,
  4.307384634791448e-20, -1.196096454868276e-21,  3.046359858567798e-23, -7.178072517443886e-25,  7.092174652352965e-11, -1.534590100321177e-11,  1.734977148667352e-12,
 -1.347845935042814e-13,  8.060109490727103e-15, -3.947949846737238e-16,  1.646998930890244e-17, -6.010621128796834e-19,  1.956485155794104e-20, -5.764254755440519e-22,
  1.554907321895084e-23, -3.873812384223700e-25,  1.824744420364046e-11, -4.252562244076606e-12,  5.173005048441348e-13, -4.313032916134533e-14,  2.760932598494797e-15,
 -1.444114213982626e-16,  6.418848558739753e-18, -2.490626071816260e-19,  8.602965573969340e-21, -2.684804709545143e-22,  7.658419163883753e-24, -2.014315255492451e-25,
  4.665349139335015e-12, -1.166684193915564e-12,  1.522313531647605e-13, -1.358510157219458e-14,  9.286383857187398e-16, -5.175271247630772e-17,  2.445786138226503e-18,
 -1.007044909786505e-19,  3.684450985533212e-21, -1.215844086803247e-22,  3.661398729806755e-24, -1.015068918716294e-25,  1.193829735319347e-12, -3.191629960792626e-13,
  4.453144190662460e-14, -4.241662862596208e-15,  3.088361510480633e-16, -1.829514314555102e-17,  9.172735700429609e-19, -3.999560794121483e-20,  1.546935254476992e-21,
 -5.387782706999882e-23,  1.709815632540930e-24, -4.987859053186846e-26,  3.081447546150935e-13, -8.773854314757197e-14,  1.304841898905661e-14, -1.322769896451899e-15,
  1.023128961708536e-16, -6.426640429290778e-18,  3.410472761252541e-19, -1.571287747662824e-20,  6.411254677446927e-22, -2.352046953511085e-23,  7.850962964626821e-25,
 -2.405478038599384e-26,  8.089978360382498e-14, -2.443921374099219e-14,  3.861276603916494e-15, -4.153402157107887e-16,  3.403198401279382e-17, -2.260711734684087e-18,
  1.266673108340461e-19, -6.151887751023573e-21,  2.642072469965425e-22, -1.018767341497951e-23,  3.569340519046425e-25, -1.146327763493723e-26,  2.179543587884097e-14,
 -6.958481758183902e-15,  1.163963228917615e-15, -1.324282290607183e-16,  1.146068163816627e-17, -8.028860579116294e-19,  4.737010186465607e-20, -2.419056371932383e-21,
  1.090869526033229e-22, -4.410755703646777e-24,  1.618382877192103e-25, -5.436200281272606e-27,  6.081694057302033e-15, -2.043841670104185e-15,  3.606530099982257e-16,
 -4.325555240931524e-17,  3.941335047013662e-18, -2.903127579791697e-19,  1.798459475093415e-20, -9.630423886481837e-22,  4.547936358775172e-23, -1.923347538849353e-24,
  7.372456711483219e-26, -2.583948508942448e-27,  1.774316731583742e-15, -6.250975299664849e-16,  1.159221993288667e-16, -1.460440966877362e-17,  1.396329625988487e-18,
 -1.077920203661334e-19,  6.989719477828244e-21, -3.913034951090563e-22,  1.929645958241906e-23, -8.511759509108893e-25,  3.399333990415876e-26, -1.239914543972285e-27,
  5.463434521520751e-16, -2.009322812004193e-16,  3.900489780254299e-17, -5.142315462671745e-18,  5.140357000832897e-19, -4.144373563827665e-20,  2.803614263125190e-21,
 -1.635612808661229e-22,  8.396250575594853e-24, -3.851365479264843e-25,  1.597859320082979e-26, -6.048241601939166e-28,  1.791460643560778e-16, -6.848330566448636e-17,
  1.385761999718414e-17, -1.904162953377618e-18,  1.982386180442822e-19, -1.663029222976642e-20,  1.169445371607086e-21, -7.084939744431309e-23,  3.773247837872039e-24,
 -1.793948328766157e-25,  7.707296864927107e-27, -3.018170841860830e-28,  6.304763019768682e-17, -2.494134954310290e-17,  5.237805606343567e-18, -7.469428270724124e-19,
  8.065419054913124e-20, -7.012094018111888e-21,  5.105825881154575e-22, -3.200257803498780e-23,  1.761795331420066e-24, -8.651229902273493e-26,  3.835693279885318e-27,
 -1.548760386279011e-28,  2.395403809300710e-17, -9.762050074662848e-18,  2.117845417379625e-18, -3.120281738789364e-19,  3.479212078908332e-20, -3.121458473325474e-21,
  2.343765278052746e-22, -1.513725836445760e-23,  8.580438432171460e-25, -4.335177641919348e-26,  1.976234992626660e-27, -8.198115507027360e-29,  9.845913283161231e-18,
 -4.114605385818717e-18,  9.177287106129492e-19, -1.390305162970539e-19,  1.593405579590319e-20, -1.468562376927108e-21,  1.132069960853388e-22, -7.501671021114915e-24,
  4.360129588392131e-25, -2.257393405735650e-26,  1.053868046816852e-27, -4.474306771064839e-29,  4.356793313840250e-18, -1.858294267213827e-18,  4.239946038791128e-19,
 -6.571886976564898e-20,  7.703960253464475e-21, -7.259347692451386e-22,  5.718505679173561e-23, -3.870351058064511e-24,  2.296428599372479e-25, -1.213116776179612e-26,
  5.775745268530103e-28, -2.499428525175618e-29,  2.034361661473382e-18, -8.814326556332539e-19,  2.046678079184033e-19, -3.228980513365954e-20,  3.851987655720564e-21,
 -3.692503485759679e-22,  2.957984503462810e-23, -2.035094087732253e-24,  1.226979836039910e-25, -6.583675975044257e-27,  3.182651104390428e-28, -1.397835101317633e-29,
  9.429186766640058e-19, -4.130149811394103e-19,  9.708166385389756e-20, -1.550677834722152e-20,  1.872621193837978e-21, -1.816758127972072e-22,  1.472553829076360e-23,
 -1.024805851888219e-24,  6.248243039528854e-26, -3.389492556783416e-27,  1.656094640299346e-28, -7.349457922161064e-30,  3.390547683949259e-19, -1.494154860929473e-19,
  3.536170958399544e-20, -5.687464724166014e-21,  6.915382369662858e-22, -6.754273612125296e-23,  5.510688318395527e-24, -3.859794432294027e-25,  2.368112966943058e-26,
 -1.292514690263264e-27,  6.352981093575784e-29, -2.835753245914541e-30,  5.769768595971111e-02, -1.374065347194133e-04,  3.384429586395529e-07, -8.577033927859336e-10,
  2.222073871538219e-12, -5.849949032038692e-15,  1.556326470334534e-17, -4.168257223890543e-20,  1.119854939031459e-22, -3.013579774329920e-25,  8.103581714887161e-28,
 -2.178155074238003e-30,  5.400110634470661e-02, -1.574076815172495e-04,  5.446139068942804e-07, -1.977542105115904e-09,  7.157042186477734e-12, -2.546108512861963e-14,
  8.890132693249575e-17, -3.052172914454213e-19,  1.032510071396288e-21, -3.448286625767847e-24,  1.138585978095524e-26, -3.721597574123982e-29,  4.730616259821762e-02,
 -1.884273063238875e-04,  9.166581577669635e-07, -4.333973479712714e-09,  1.951374982922632e-11, -8.441882305763039e-14,  3.538018216212746e-16, -1.444601972525629e-18,
  5.768992296426587e-21, -2.259798413282529e-23,  8.702166547830711e-26, -3.300255139536462e-28,  3.879333501549625e-02, -2.168197531522638e-04,  1.375562480214380e-06,
 -7.958794701257665e-09,  4.289782851603826e-11, -2.194900447891376e-13,  1.077755317525931e-15, -5.114724958387511e-18,  2.357880941183631e-20, -1.059945408532774e-22,
  4.660251879789086e-25, -2.008789173386240e-27,  2.978532162766157e-02, -2.304500236911641e-04,  1.814931205731549e-06, -1.254375689740673e-08,  7.958288365883139e-11,
 -4.739838559386846e-13,  2.684561060633857e-15, -1.458599064314103e-17,  7.650555116171980e-20, -3.892331829226971e-22,  1.927934232799734e-24, -9.324155704928955e-27,
  2.141726476922516e-02, -2.234381039991338e-04,  2.127288215082522e-06, -1.733431131601088e-08,  1.278873260610901e-10, -8.761231000547419e-13,  5.659229305588626e-15,
 -3.482700728592791e-17,  2.057248896607058e-19, -1.173006916404931e-21,  6.483949129510310e-24, -3.486484956731482e-26,  1.442727157624455e-02, -1.974064241855710e-04,
  2.238003732935052e-06, -2.129052857592999e-08,  1.808848945009960e-10, -1.412343030297733e-12,  1.031519795492058e-14, -7.131842166981488e-17,  4.707843518234216e-19,
 -2.986127964277133e-21,  1.828943586161942e-23, -1.085876704633513e-25,  9.108324061913762e-03, -1.593602031629339e-04,  2.129829762151958e-06, -2.345832583173754e-08,
  2.276926904532724e-10, -2.011426719826836e-12,  1.649754072814954e-14, -1.273228819033379e-16,  9.334874003552237e-19, -6.548053835859930e-21,  4.418738275187684e-23,
 -2.880948594783808e-25,  5.391864692809830e-03, -1.179842296635783e-04,  1.844284675068286e-06, -2.334802367581536e-08,  2.571936001055311e-10, -2.555114074177442e-12,
  2.340254603135666e-14, -2.005459421682033e-16,  1.624843262869138e-18, -1.254414398143385e-20,  9.283464322700613e-23, -6.617021574623515e-25,  2.994595117107330e-03,
 -8.040772713357482e-05,  1.459941864513267e-06, -2.110814924609741e-08,  2.624020742366285e-10, -2.916699947860469e-12,  2.969089832210570e-14, -2.812563562026727e-16,
  2.507606361579715e-18, -2.122073059072091e-20,  1.715644026075382e-22, -1.331891601996394e-24,  1.561466481411112e-03, -5.061495611706757e-05,  1.060642902179295e-06,
 -1.741441375794129e-08,  2.431081528855529e-10, -3.010066978824653e-12,  3.391661363585827e-14, -3.538000964756988e-16,  3.458608930589469e-18, -3.197227881062771e-20,
  2.814485224780774e-22, -2.372151004408264e-24,  7.650130894658000e-04, -2.951934080119565e-05,  7.096188821510008e-07, -1.316354267332016e-08,  2.054681947776340e-10,
 -2.822797776449806e-12,  3.508051875805562e-14, -4.016307614435418e-16,  4.291285246147228e-18, -4.320430736630761e-20,  4.129164841798144e-22, -3.767945703112463e-24,
  3.524910490839045e-04, -1.599582429078811e-05,  4.385987199364391e-07, -9.149705814684305e-09,  1.590580610686958e-10, -2.416211197684371e-12,  3.301325266097698e-14,
 -4.135991605585189e-16,  4.816677951297570e-18, -5.267522018174853e-20,  5.451966592450343e-22, -5.373266651348289e-24,  1.529091624260978e-04, -8.074640551762088e-06,
  2.511743803128830e-07, -5.867527832999282e-09,  1.131946910708557e-10, -1.895299034518835e-12,  2.838918257834809e-14, -3.881699393052136e-16,  4.914917214324338e-18,
 -5.824650857792903e-20,  6.514048923542221e-22, -6.918950577875855e-24,  6.252556449332440e-05, -3.806734190794550e-06,  1.336532523993577e-07, -3.482433632861753e-09,
  7.430940898108444e-11, -1.367451647932684e-12,  2.239619308227851e-14, -3.334073165408806e-16,  4.579500841810739e-18, -5.868717288983525e-20,  7.077486647630145e-22,
 -8.085906561868002e-24,  2.413408739683192e-05, -1.680245432152519e-06,  6.626581331029720e-08, -1.918731626267664e-09,  4.514751496553040e-11, -9.106615232586656e-13,
  1.626903593760519e-14, -2.631090538837770e-16,  3.912317288266538e-18, -5.411138891911845e-20,  7.023917521408648e-22, -8.616354015101225e-24,  8.807474884587944e-06,
 -6.960986871245826e-07,  3.069860636639251e-08, -9.843755639926934e-10,  2.546783149825865e-11, -5.616764861193168e-13,  1.092101166279617e-14, -1.914792965960125e-16,
  3.076453924843865e-18, -4.584155876288396e-20,  6.393959743684810e-22, -8.408251991848851e-24,  3.044499877919293e-06, -2.713737670378080e-07,  1.332620468504402e-08,
 -4.716798457069607e-10,  1.338177327316234e-11, -3.219283898866858e-13,  6.798247612627924e-15, -1.289764124668958e-16,  2.235114319824523e-18, -3.582132995210358e-20,
  5.360304394137862e-22, -7.545105623252859e-24,  9.989232790543324e-07, -9.982563207129955e-08,  5.436761708127635e-09, -2.117556927988062e-10,  6.570823831301937e-12,
 -1.720479443854703e-13,  3.938094649851413e-15, -8.069921913064075e-17,  1.505894471249888e-18, -2.591738340942808e-20,  4.154659162284122e-22, -6.250869605512599e-24,
  3.118401533180600e-07, -3.474969946687953e-08,  2.091106977829222e-09, -8.936026542383616e-11,  3.025382982312052e-12, -8.603384302212318e-14,  2.130499497975256e-15,
 -4.707455224269051e-17,  9.444014593758994e-19, -1.742861814932340e-20,  2.988790183010699e-22, -4.800100209190518e-24,  9.287253596350349e-08, -1.148295584504271e-08,
  7.607822779162643e-10, -3.556938206780799e-11,  1.310801263204950e-12, -4.040116379434127e-14,  1.080407336722343e-15, -2.569761527709966e-17,  5.534058425712108e-19,
 -1.093552042791697e-20,  2.003437362602324e-22, -3.430238430158232e-24,  2.646827202495987e-08, -3.614364479315466e-09,  2.627544189864151e-10, -1.340398339180363e-11,
  5.364442948355079e-13, -1.788477952965688e-14,  5.155681306830494e-16, -1.317922155490401e-17,  3.042102413037378e-19, -6.427694149319533e-21,  1.256396835397531e-22,
 -2.290488580265263e-24,  7.243498619970943e-09, -1.087709406406370e-09,  8.648395522605905e-11, -4.801139440272135e-12,  2.082067234452177e-13, -7.493876178332737e-15,
  2.324653552666852e-16, -6.376304911354519e-18,  1.575246474742449e-19, -3.554024892235318e-21,  7.402305716028815e-23, -1.435118685441655e-24,  1.910953270488338e-09,
 -3.142614554501956e-10,  2.724347802925787e-11, -1.641651091419235e-12,  7.697256401512235e-14, -2.985109732224387e-15,  9.947337660920912e-17, -2.923052073861033e-18,
  7.717475253453002e-20, -1.856707961404500e-21,  4.115334520222534e-23, -8.474465296953364e-25,  4.881327050212264e-10, -8.756921161649849e-11,  8.251908883096172e-12,
 -5.383750812402901e-13,  2.723307190017928e-14, -1.135779457682549e-15,  4.058616623867956e-17, -1.275654962213216e-18,  3.594088592257665e-20, -9.207726622525212e-22,
  2.169010872097026e-23, -4.738212991025301e-25,  1.213256094005851e-10, -2.365328468231498e-11,  2.415654124653241e-12, -1.702112708653942e-13,  9.268436655757348e-15,
 -4.148866157308413e-16,  1.587019161270870e-17, -5.326674386415546e-19,  1.599085528384255e-20, -4.356266458143452e-22,  1.089153271046912e-23, -2.520759764410126e-25,
  2.950447515723790e-11, -6.227928425163424e-12,  6.873044931826710e-13, -5.217161791517449e-14,  3.051387573283957e-15, -1.463125038973936e-16,  5.980176192857806e-18,
 -2.139823557883552e-19,  6.833977478427696e-21, -1.976767829434797e-22,  5.238287083710438e-24, -1.282748873351730e-25,  7.063349173471134e-12, -1.608405907195146e-12,
  1.912430810422845e-13, -1.559903301771264e-14,  9.777380145449008e-16, -5.011603372735054e-17,  2.184592874619379e-18, -8.318871898168898e-20,  2.821811051847810e-21,
 -8.653208945444461e-23,  2.426784441879154e-24, -6.278868613814399e-26,  1.676007458915316e-12, -4.102119198632692e-13,  5.239528487403757e-14, -4.580379564896474e-15,
  3.069535606402518e-16, -1.678298329998990e-17,  7.786928735197094e-19, -3.149843020405459e-20,  1.132834268251947e-21, -3.676787385124145e-23,  1.089588100627644e-24,
 -2.974108783888315e-26,  3.971355700771664e-13, -1.040945135369470e-13,  1.423930749491932e-14, -1.330543689932779e-15,  9.510159930114184e-17, -5.534151888645373e-18,
  2.727363981782211e-19, -1.169612366643852e-20,  4.451715460949314e-22, -1.526567664176259e-23,  4.772186190263481e-25, -1.371991536694549e-26,  9.474539493142825e-14,
 -2.649669782379983e-14,  3.869668324267706e-15, -3.854157409788063e-16,  2.930631998870853e-17, -1.810742146212770e-18,  9.457449705274073e-20, -4.290756992457064e-21,
  1.724878498983818e-22, -6.237414934772255e-24,  2.053141599088461e-25, -6.206208622867606e-27,  2.296092710816216e-14, -6.825315830081345e-15,  1.060759856078651e-15,
 -1.122821286938890e-16,  9.058027397054991e-18, -5.927276975249923e-19,  3.273071247450809e-20, -1.567427122915406e-21,  6.640613356097844e-23, -2.527021924735855e-24,
  8.741151665086055e-26, -2.772754738355732e-27,  5.706393015218031e-15, -1.796004836754782e-15,  2.960331421485259e-16, -3.319857251736405e-17,  2.833161908031375e-18,
 -1.958078899466831e-19,  1.140212292948233e-20, -5.749301242349447e-22,  2.560965571281338e-23, -1.023225853695389e-24,  3.711290174338247e-26, -1.232770672552373e-27,
  1.469034563234987e-15, -4.875882003653734e-16,  8.493242897967226e-17, -1.005769815782084e-17,  9.051591851312090e-19, -6.587741747778438e-20,  4.033881602468411e-21,
 -2.135886730570356e-22,  9.977217713042700e-24, -4.175036968566746e-25,  1.584020910383459e-26, -5.496913008684437e-28,  3.958309357254813e-16, -1.379791956011429e-16,
  2.530361400554579e-17, -3.152936607098567e-18,  2.982340914711497e-19, -2.278402834083912e-20,  1.462567471035549e-21, -8.108057053164886e-23,  3.960569259950175e-24,
 -1.731015951072650e-25,  6.851677567376999e-27, -2.477639654706628e-28,  1.128074000642794e-16, -4.112184963648825e-17,  7.907772759516750e-18, -1.032873481308592e-18,
  1.023132084141467e-19, -8.176327995577227e-21,  5.483933873203635e-22, -3.172787087569696e-23,  1.615626598202642e-24, -7.353097880605546e-26,  3.027575363963142e-27,
 -1.137600986415158e-28,  3.434879645727214e-17, -1.303665672770519e-17,  2.617703597243246e-18, -3.569514710312554e-19,  3.688419561666146e-20, -3.071755730753263e-21,
  2.144828316392156e-22, -1.290520899630958e-23,  6.827297788415575e-25, -3.225029069265185e-26,  1.376887692457095e-27, -5.359181539908319e-29,  1.127732500801515e-17,
 -4.436189043392795e-18,  9.259535361198303e-19, -1.312462181884650e-19,  1.408770396850213e-20, -1.217704332999492e-21,  8.816809793023960e-23, -5.496071829377971e-24,
  3.009637247638877e-25, -1.470263532441724e-26,  6.486120781779931e-28, -2.606257104834134e-29,  4.021052853276891e-18, -1.631799620255886e-18,  3.523827405994382e-19,
 -5.167855227950863e-20,  5.736297001825890e-21, -5.123790746641180e-22,  3.830744797128302e-23, -2.463793239422484e-24,  1.390933506997759e-25, -6.999939709325106e-27,
  3.178817963153669e-28, -1.313809669233146e-29,  1.562527812676270e-18, -6.510299745021090e-19,  1.447291527986070e-19, -2.185334489223349e-20,  2.496463773643363e-21,
 -2.293591508005883e-22,  1.762617267312562e-23, -1.164503433117390e-24,  6.748647456884540e-26, -3.484135119926362e-27,  1.622105911804030e-28, -6.868483187066864e-30,
  6.593435576897835e-19, -2.806789945515739e-19,  6.390180094016035e-20, -9.883160672667786e-21,  1.156080033164854e-21, -1.087078023632915e-22,  8.545906415695463e-24,
 -5.772476009727552e-25,  3.418413153297386e-26, -1.802425142500120e-27,  8.565807500727944e-29, -3.700247528162201e-30,  2.965048273843022e-19, -1.283207045468197e-19,
  2.975795396826720e-20, -4.688790255103937e-21,  5.586373588472269e-22, -5.348442741896836e-23,  4.279338624187816e-24, -2.940715100802638e-25,  1.770952685712076e-26,
 -9.491879807107036e-28,  4.583528630644864e-29, -2.010980480162143e-30,  1.338017087894510e-19, -5.857426490120652e-20,  1.375945520226320e-20, -2.196369999680049e-21,
  2.650677075227292e-22, -2.569993490349233e-23,  2.081804338469928e-24, -1.447938762936103e-25,  8.822922682994678e-27, -4.783450004392591e-28,  2.335875150821057e-29,
 -1.036058275784999e-30,  4.739033228805623e-20, -2.087899860202474e-20,  4.940003123091821e-21, -7.943106243846080e-22,  9.655305799538201e-23, -9.427750281648527e-24,
  7.689827987698307e-25, -5.384659306338508e-26,  3.302795830712502e-27, -1.802196104116816e-28,  8.855913082711928e-30, -3.951988937785873e-31,  5.715341056443063e-02,
 -1.347395651710690e-04,  3.283600407236732e-07, -8.230662978482533e-10,  2.108717589398712e-12, -5.490040889143382e-15,  1.444473477266350e-17, -3.826654530484598e-20,
  1.016976975477891e-22, -2.707807672176952e-25,  7.204075022190246e-28, -1.916490973495984e-30,  5.338004184615960e-02, -1.531437835295015e-04,  5.215540411050538e-07,
 -1.866990116358892e-09,  6.668483389548938e-12, -2.342638437443347e-14,  8.079975377164634e-17, -2.740783873447604e-19,  9.161899224163651e-22, -3.023969004812043e-24,
  9.868821499385435e-27, -3.188621594709643e-29,  4.656679784926079e-02, -1.812968894348126e-04,  8.664695373356332e-07, -4.034812523258514e-09,  1.790711415433931e-11,
 -7.639283329052600e-14,  3.158198047954503e-16, -1.272366243992311e-18,  5.014773624960475e-21, -1.939091438373347e-23,  7.372438614320635e-26, -2.760932878051898e-28,
  3.794747617829571e-02, -2.061859319766432e-04,  1.284034694898075e-06, -7.306189661395742e-09,  3.875551483431466e-11, -1.952606051072409e-13,  9.445573657587189e-16,
 -4.417824152560569e-18,  2.007829024072426e-20, -8.900739746834571e-23,  3.860047627869292e-25, -1.641530013315435e-27,  2.889163674446056e-02, -2.165117262136301e-04,
  1.671744222253893e-06, -1.134290155042037e-08,  7.071579683686431e-11, -4.141910737969181e-13,  2.308422922076764e-15, -1.234789432971233e-17,  6.378780416998384e-20,
 -3.197337363568667e-22,  1.560741920027310e-24, -7.440804300211899e-27,  2.055627896844343e-02, -2.072183452244656e-04,  1.930998451172690e-06, -1.542123281219978e-08,
  1.116477767369315e-10, -7.512968707915916e-13,  4.770229766152529e-15, -2.887225956989312e-17,  1.678176743243669e-19, -9.419113341466054e-22,  5.126920344017962e-24,
 -2.715459812819292e-26,  1.367190259463837e-02, -1.804772016241554e-04,  1.998991980806423e-06, -1.860954367895672e-08,  1.549603253984852e-10, -1.187133417368544e-12,
  8.513987628995018e-15, -5.784097884500961e-17,  3.753767239544512e-19, -2.341867911801099e-21,  1.411345742098764e-23, -8.247890307217421e-26,  8.503261264794174e-03,
 -1.433885556757670e-04,  1.868927322845405e-06, -2.011671232584261e-08,  1.911513607696170e-10, -1.655096945326263e-12,  1.331756000286370e-14, -1.009051736924256e-16,
  7.267371694971300e-19, -5.010300989404667e-21,  3.324477509634919e-23, -2.132074791557291e-25,  4.947755759735966e-03, -1.042843953143768e-04,  1.587206480321582e-06,
 -1.961303600049896e-08,  2.112817748354480e-10, -2.055353960221827e-12,  1.845209829278188e-14, -1.551130151839985e-16,  1.233625574213736e-18, -9.353907614947289e-21,
  6.802246165353369e-23, -4.766289977171190e-25,  2.694814277798584e-03, -6.967420452050243e-05,  1.230028122915153e-06, -1.734019414085755e-08,  2.106000319202044e-10,
 -2.290214242772606e-12,  2.283309956266954e-14, -2.120183353497393e-16,  1.854252786747012e-18, -1.540179089283257e-20,  1.222833403009134e-22, -9.326951195790408e-25,
  1.374741111892486e-03, -4.290388315595091e-05,  8.731562496708397e-07, -1.396522283353890e-08,  1.903047708250078e-10, -2.303429368803006e-12,  2.540101744028797e-14,
 -2.595568403197158e-16,  2.487376697744869e-18, -2.255591236280896e-20,  1.948842586302611e-22, -1.612974524839962e-24,  6.573627945445601e-04, -2.442236380331137e-05,
  5.696566371553129e-07, -1.028551590214048e-08,  1.565951527906388e-10, -2.101626698496058e-12,  2.554450864081421e-14, -2.863059830714110e-16,  2.997164214105081e-18,
 -2.958471367703702e-20,  2.773823269263243e-22, -2.484434279437698e-24,  2.948865199166813e-04, -1.288636791989972e-05,  3.426065222471023e-07, -6.951966505988684e-09,
  1.178020668274217e-10, -1.747057761891872e-12,  2.333279517152250e-14, -2.860203376419528e-16,  3.261871939026018e-18, -3.495742212639410e-20,  3.547906542164328e-22,
 -3.430723492759270e-24,  1.242234088210581e-04, -6.318755359603705e-06,  1.904903770447725e-07, -4.326039918093352e-09,  8.130598319354504e-11, -1.328382851084813e-12,
  1.943975204585946e-14, -2.599547099359980e-16,  3.221853769719529e-18, -3.740219791880374e-20,  4.100147059101945e-22, -4.271330168928872e-24,  4.919843039554138e-05,
 -2.886356242204178e-06,  9.818182916046571e-08, -2.485970041560921e-09,  5.165725189210002e-11, -9.271811762187312e-13,  1.483005107203941e-14, -2.158312382029640e-16,
  2.900773118954497e-18, -3.640230354265430e-20,  4.301777506583370e-22, -4.818851639528297e-24,  1.834320636101943e-05, -1.231195770416426e-06,  4.703660101763702e-08,
 -1.323133970035075e-09,  3.030824817267285e-11, -5.960853685817717e-13,  1.039659769594299e-14, -1.643250495210557e-16,  2.390195045103223e-18, -3.236386874867884e-20,
  4.115517759768907e-22, -4.948944587381463e-24,  6.448205750779122e-06, -4.916021386739251e-07,  2.100189695980092e-08, -6.541581674476262e-10,  1.647268090466249e-11,
 -3.541495976842420e-13,  6.721147200654767e-15, -1.151450384389754e-16,  1.809312842390918e-18, -2.638814984477703e-20,  3.605059448021110e-22, -4.646417273234908e-24,
  2.140935636634385e-06, -1.842022104983613e-07,  8.763904338231344e-09, -3.013114737906801e-10,  8.319471053206580e-12, -1.950826011798932e-13,  4.020495548194681e-15,
 -7.452088483863991e-17,  1.262847893477866e-18, -1.980733687579720e-20,  2.902802275689211e-22, -4.004226783874674e-24,  6.727317268049755e-07, -6.494014837979648e-08,
  3.427690030043942e-09, -1.296952083132136e-10,  3.916844010879323e-12, -9.996279673675361e-14,  2.232976841500704e-15, -4.470273500473878e-17,  8.156866563997700e-19,
 -1.373834097753847e-20,  2.156777617006436e-22, -3.179962927629537e-24,  2.005173154356881e-07, -2.160195298756768e-08,  1.260346140213754e-09, -5.233478083567854e-11,
  1.724720232775027e-12, -4.781040243069788e-14,  1.155508626683589e-15, -2.494405253982225e-17,  4.893507133145236e-19, -8.838084268340141e-21,  1.484344779825444e-22,
 -2.336254364411473e-24,  5.684254577196200e-08, -6.800829596670066e-09,  4.370945369114235e-10, -1.986470415998180e-11,  7.127721078709306e-13, -2.141966626057785e-14,
  5.591385436051031e-16, -1.299506096037441e-17,  2.736972680016437e-19, -5.293619265193526e-21,  9.499183675530749e-23, -1.594109652898369e-24,  1.537116385071521e-08,
 -2.033175546611680e-09,  1.434785444248590e-10, -7.118246771313442e-12,  2.774845324409787e-13, -9.022804708298801e-15,  2.539671338122239e-16, -6.345164026436172e-18,
  1.432741545414161e-19, -2.963670077232031e-21,  5.675304746067382e-23, -1.014290723834952e-24,  3.978608767763122e-09, -5.793459295866320e-10,  4.474997111311813e-11,
 -2.417506949369845e-12,  1.021671942246447e-13, -3.588023023274329e-15,  1.087196101138710e-16, -2.915635337019817e-18,  7.048487646042442e-20, -1.557339577188813e-21,
  3.178680633995951e-23, -6.043180017511583e-25,  9.895274542291673e-10, -1.579911808396282e-10,  1.331756047562771e-11, -7.814933470083510e-13,  3.573086581678116e-14,
 -1.352813692794211e-15,  4.405558023910749e-17, -1.266321245014293e-18,  3.273046928932666e-20, -7.714591310250271e-22,  1.676336380632612e-23, -3.386341684102415e-25,
  2.375208062678275e-10, -4.142308659031107e-11,  3.799299670006129e-12, -2.415929280073105e-13,  1.192560769829288e-14, -4.858883810758022e-16,  1.697856965938182e-17,
 -5.222943362492389e-19,  1.441358450306385e-20, -3.619497224300489e-22,  8.362875316005812e-24, -1.792980709533858e-25,  5.529756339817431e-11, -1.049486906678471e-11,
  1.044395271973955e-12, -7.179392526059979e-14,  3.818241935353360e-15, -1.671029692607813e-16,  6.255052573775217e-18, -2.056162447198277e-19,  6.049947740754535e-21,
 -1.616484860634597e-22,  3.966417291060948e-24, -9.014755006840225e-26,  1.255645279514536e-11, -2.584046071642227e-12,  2.782176918610804e-13, -2.062570274344831e-14,
  1.179379197746163e-15, -5.533820576139335e-17,  2.215208700162819e-18, -7.769135548736746e-20,  2.433722704729608e-21, -6.909398533299214e-23,  1.798141087018696e-24,
 -4.326902815079827e-26,  2.798384967625550e-12, -6.222353709646625e-13,  7.227774842882316e-14, -5.764671595323789e-15,  3.536351481937110e-16, -1.775566721476761e-17,
  7.587524210379712e-19, -2.834508427207850e-20,  9.438760661809359e-22, -2.843193074799233e-23,  7.837036010793703e-25, -1.994038117480086e-26,  6.164091917800639e-13,
 -1.475655549413183e-13,  1.843972297235895e-14, -1.578296560575538e-15,  1.036428093249151e-16, -5.557146690249252e-18,  2.530339488234894e-19, -1.005130254484771e-20,
  3.552145258142380e-22, -1.133535296888491e-23,  3.304498790604484e-25, -8.877775158236063e-27,  1.352477998048067e-13, -3.473417619322826e-14,  4.655550786084103e-15,
 -4.265290641157181e-16,  2.991278001908183e-17, -1.709118265802157e-18,  8.275635926090109e-20, -3.489025510518857e-21,  1.306299183104029e-22, -4.408769894362527e-24,
  1.357135896846807e-25, -3.843929019917931e-27,  2.981375372798679e-14, -8.184082070950162e-15,  1.173034238443758e-15, -1.147249674905801e-16,  8.571423339134160e-18,
 -5.206913700198999e-19,  2.675385765615642e-20, -1.194749291876093e-21,  4.729979898440162e-23, -1.685299887113741e-24,  5.468454018621857e-26, -1.630209162450500e-27,
  6.665028045687597e-15, -1.948309877712238e-15,  2.976800250905689e-16, -3.099033190291757e-17,  2.460170443643840e-18, -1.585035013941329e-19,  8.622220708303851e-21,
 -4.069563827210200e-22,  1.700085088318483e-23, -6.382154069107195e-25,  2.178743128827523e-26, -6.823540927888501e-28,  1.526480306579659e-15, -4.733426729790518e-16,
  7.683703367727744e-17, -8.488968006764147e-18,  7.140173537147646e-19, -4.866018733989000e-20,  2.795344639659898e-21, -1.391112957626329e-22,  6.118306348932071e-24,
 -2.414640147877398e-25,  8.654137232624553e-27, -2.841604841325166e-28,  3.620608642179061e-16, -1.186206512278301e-16,  2.038567401050782e-17, -2.382321175753271e-18,
  2.116604590957346e-19, -1.521382200533947e-20,  9.204162589880675e-22, -4.816875442865426e-23,  2.224756026831909e-24, -9.208129057390454e-26,  3.456649656808070e-27,
 -1.187252759772511e-28,  8.994781931688752e-17, -3.100720292933617e-17,  5.620374760224295e-18, -6.923180013417375e-19,  6.475708634408573e-20, -4.893790362876865e-21,
  3.108575881863800e-22, -1.705828345306493e-23,  8.250612556664008e-25, -3.571668385508713e-26,  1.400664791157045e-27, -5.019616458417603e-29,  2.367763229425299e-17,
 -8.551274155035449e-18,  1.628283036684720e-18, -2.106144808896226e-19,  2.066533159046289e-20, -1.636277615145178e-21,  1.087676032393078e-22, -6.238433919883203e-24,
  3.150053507070429e-25, -1.422002318284391e-26,  5.808771340277730e-28, -2.165946048425641e-29,  6.679789805036261e-18, -2.516110053458135e-18,  5.011470903755329e-19,
 -6.778956749866097e-20,  6.949966529172405e-21, -5.743963724703519e-22,  3.981045963738931e-23, -2.378184420600162e-24,  1.249392544269574e-25, -5.861974634926119e-27,
  2.486316533931326e-28, -9.615994749176730e-30,  2.040970667377844e-18, -7.981019910521799e-19,  1.655185418481445e-19, -2.331129060801570e-20,  2.486569580217805e-21,
 -2.136264418726632e-22,  1.537633090636191e-23, -9.530089989244182e-25,  5.189623597372911e-26, -2.521538484031330e-27,  1.106555939538930e-28, -4.423800943753937e-30,
  6.812643452847822e-19, -2.752343154721416e-19,  5.914717425269107e-20, -8.632105242980674e-21,  9.536003360272227e-22, -8.478267323382509e-23,  6.310093311624948e-24,
 -4.040637793284483e-25,  2.271436150311787e-26, -1.138389686503563e-27,  5.148931825422483e-29, -2.119793962411197e-30,  2.496701829044935e-19, -1.036966836004508e-19,
  2.297243959320152e-20, -3.456641532766940e-21,  3.935268176842588e-22, -3.603412325880822e-23,  2.760220173685456e-24, -1.817832390976829e-25,  1.050258688306358e-26,
 -5.406040025775060e-28,  2.509605073631503e-29, -1.059664027189255e-30,  1.002461399031342e-19, -4.258592992203844e-20,  9.673240241430063e-21, -1.492634348226533e-21,
  1.742050164581037e-22, -1.634449372274371e-23,  1.282129308343846e-24, -8.642198496193894e-26,  5.107405762325870e-27, -2.687643005963550e-28,  1.274809761870110e-29,
 -5.496627494807627e-31,  4.333538976374738e-20, -1.873193853858654e-20,  4.338136036779122e-21, -6.826074793148898e-22,  8.121924470918767e-23, -7.765825405884235e-24,
  6.205577144052135e-25, -4.259102470798171e-26,  2.561804847872243e-27, -1.371448083707126e-28,  6.614986076698241e-30, -2.899035156525546e-31,  1.901340310765701e-20,
 -8.318506394000688e-21,  1.952755956739359e-21, -3.114995075349633e-22,  3.756792311720695e-23, -3.640041641308977e-24,  2.946689851485238e-25, -2.048195403376633e-26,
  1.247288338721778e-27, -6.758265921379023e-29,  3.298296109896652e-30, -1.462100022596987e-31,  6.627867081346873e-21, -2.919332447141729e-21,  6.905199182171830e-22,
 -1.109972422547590e-22,  1.348842513826467e-23, -1.316673789877122e-24,  1.073652003017880e-25, -7.515951669517346e-27,  4.608805815055342e-28, -2.514153388617528e-29,
  1.235117294408387e-30, -5.510336367243185e-32,  5.661964431025679e-02, -1.321516266806605e-04,  3.186821186459387e-07, -7.901867448208915e-10,  2.002298582451997e-12,
 -5.155865887366949e-15,  1.341740532370786e-17, -3.516278790318302e-20,  9.244859664877421e-23, -2.435816054797825e-25,  6.412102960144865e-28, -1.688539887891289e-30,
  5.277567220004836e-02, -1.490591878350494e-04,  4.997752070100139e-07, -1.763939791631692e-09,  6.218742737794640e-12, -2.157606561112519e-14,  7.352017399019537e-17,
 -2.464285890222367e-19,  8.141071684292960e-22, -2.655891987005172e-24,  8.567923285439081e-27, -2.736782243130249e-29,  4.585517388490640e-02, -1.745540469025153e-04,
  8.197217524391611e-07, -3.760121515840956e-09,  1.645225956624145e-11, -6.922316485568523e-14,  2.823391492022804e-16, -1.122516429325527e-18,  4.366980834761837e-21,
 -1.667115676730858e-23,  6.258820984491246e-26, -2.314831255807492e-28,  3.714273623574058e-02, -1.962540990186280e-04,  1.199955954343651e-06, -6.716152206429782e-09,
  3.506733991097952e-11, -1.740058717425574e-13,  8.293921105181066e-16, -3.823742854825538e-18,  1.713538559942198e-20, -7.491986999872494e-23,  3.205297856700819e-25,
 -1.344987398363404e-27,  2.805150203541476e-02, -2.036636075939701e-04,  1.542154193322205e-06, -1.027482272362171e-08,  6.295914029133968e-11, -3.627173796392329e-13,
  1.989610751551164e-15, -1.047941449281113e-17,  5.332647976746663e-20, -2.633894607674271e-22,  1.267271847159820e-24, -5.956573436345178e-27,  1.975717096551316e-02,
 -1.924813114742845e-04,  1.756185411916722e-06, -1.374911983829072e-08,  9.770422037385994e-11, -6.459355793291693e-13,  4.032160402566521e-15, -2.400727867278292e-17,
  1.373294250133120e-19, -7.588727788691596e-22,  4.068130408792497e-24, -2.122705574164081e-26,  1.298062054790674e-02, -1.653381096160430e-04,  1.789804655050331e-06,
 -1.630954476583910e-08,  1.331365288547216e-10, -1.000949094121579e-12,  7.050672361535663e-15, -4.707560472571669e-17,  3.004134860156365e-19, -1.843742213099793e-21,
  1.093514344264568e-23, -6.291217820711595e-26,  7.958151230958273e-03, -1.293531536198156e-04,  1.644838679543344e-06, -1.730665535294697e-08,  1.610296893718878e-10,
 -1.366909683346682e-12,  1.079240641387500e-14, -8.029615454114436e-17,  5.682019014424965e-19, -3.850794056861043e-21,  2.512805064929282e-23, -1.585448746995977e-25,
  4.554600093053978e-03, -9.247367538752895e-05,  1.370850656806136e-06, -1.653872292991729e-08,  1.742732017820521e-10, -1.660454125406943e-12,  1.461449390014684e-14,
 -1.205381576046846e-16,  9.411949728666814e-19, -7.010487231656177e-21,  5.010409064755953e-23, -3.451830675505222e-25,  2.434556567765493e-03, -6.061232288361512e-05,
  1.040743063592510e-06, -1.430915757630034e-08,  1.698274284099399e-10, -1.807233495526462e-12,  1.765022946329272e-14, -1.606844724437157e-16,  1.378761923123437e-18,
 -1.124269859873598e-20,  8.767388888253948e-23, -6.571201799466343e-25,  1.216103440154275e-03, -3.654049861446840e-05,  7.224234821786586e-07, -1.125809054163569e-08,
  1.497872382937672e-10, -1.772721451939555e-12,  1.913567076807287e-14, -1.915771538173147e-16,  1.800102441247468e-18, -1.601541056863867e-20,  1.358368242219566e-22,
 -1.104192445501190e-24,  5.680623242013671e-04, -2.031921242896785e-05,  4.599774033060780e-07, -8.085486230712796e-09,  1.200960565585037e-10, -1.574832081475662e-12,
  1.872467015604170e-14, -2.054931603064819e-16,  2.108006988671729e-18, -2.040410771288665e-20,  1.877041053360922e-22, -1.650419816129167e-24,  2.483363715215278e-04,
 -1.044963852995143e-05,  2.694304624051358e-07, -5.318761408287996e-09,  8.786844616391876e-11, -1.272450325782368e-12,  1.661429556276173e-14, -1.993073465075790e-16,
  2.226202551643330e-18, -2.338391945387467e-20,  2.327553212931248e-22, -2.208525373240759e-24,  1.016962072321716e-04, -4.982232967605548e-06,  1.455823632117068e-07,
 -3.214616064672322e-09,  5.886960447930746e-11, -9.386628219764070e-13,  1.342259213952051e-14, -1.755682876872406e-16,  2.130248807746987e-18, -2.422808210823774e-20,
  2.603753593900631e-22, -2.660682115385247e-24,  3.905310596503262e-05, -2.207470558722523e-06,  7.275479584920138e-08, -1.790345031624354e-09,  3.623280814339082e-11,
 -6.343917255038826e-13,  9.910786055099614e-15, -1.410281918121396e-16,  1.854878860381476e-18, -2.279672616907343e-20,  2.640125153295891e-22, -2.900104975404736e-24,
  1.408099670805342e-05, -9.109946989441377e-07,  3.371515600134186e-08, -9.214401226582783e-10,  2.054951676129558e-11, -3.941099825092035e-13,  6.711551611031756e-15,
 -1.036856300637512e-16,  1.475445102032950e-18, -1.955982374183669e-20,  2.436930376868827e-22, -2.872859085551452e-24,  4.773792939291435e-06, -3.509923520834803e-07,
  1.452529320851336e-08, -4.394836441881715e-10,  1.077203580415797e-11, -2.257756785295734e-13,  4.182587746481189e-15, -7.001996091395448e-17,  1.076123747922000e-18,
 -1.536297358518052e-20,  2.055901469160089e-22, -2.597211799914100e-24,  1.524292300978019e-06, -1.265567098913237e-07,  5.833306318738382e-09, -1.948054238361980e-10,
  5.234795267553858e-12, -1.196498024924553e-13,  2.406648039725659e-15, -4.358272115391989e-17,  7.222542573045338e-19, -1.108708931957977e-20,  1.591371474742226e-22,
 -2.151376744523434e-24,  4.592825693768595e-07, -4.281355823031470e-08,  2.189774452111718e-09, -8.048577208888949e-11,  2.365617837703682e-12, -5.884555695415693e-14,
  1.282828244730117e-15, -2.508927633472032e-17,  4.476580154392189e-19, -7.378660370557238e-21,  1.134440560447896e-22, -1.639140963994975e-24,  1.308751128862509e-07,
 -1.362607339499241e-08,  7.706482331604588e-10, -3.109116937486802e-11,  9.972931901473414e-13, -2.694741280843585e-14,  6.356073534683629e-16, -1.340474289882852e-17,
  2.571484986268078e-19, -4.545114986248182e-21,  7.475809228722509e-23, -1.153100174380967e-24,  3.535909790813120e-08, -4.092074956178425e-09,  2.550694178292369e-10,
 -1.126630991078894e-11,  3.935524465368561e-13, -1.152990299698810e-14,  2.937713242390483e-16, -6.671004574986298e-18,  1.374034873679789e-19, -2.601011972506539e-21,
  4.571417963827738e-23, -7.518740761166483e-25,  9.083989070414350e-09, -1.163376297802546e-09,  7.967071733517543e-11, -3.843179237148590e-12,  1.458996712473519e-13,
 -4.626331361115444e-15,  1.271308598032021e-16, -3.104053554776780e-18,  6.855689006613860e-20, -1.388203808740020e-21,  2.604128485856504e-23, -4.562171905730594e-25,
  2.226547838295523e-09, -3.142509878362536e-10,  2.357298027141015e-11, -1.238903023276091e-12,  5.101241670897557e-14, -1.747700267428655e-15,  5.171848525310457e-17,
 -1.355870513941227e-18,  3.207026004363409e-20, -6.938216616607426e-22,  1.387632360095627e-23, -2.586660272805665e-25,  5.226661036224379e-10, -8.097884049954748e-11,
  6.634588169178654e-12, -3.790156103234366e-13,  1.689347161723769e-14, -6.242783658508937e-16,  1.986383763885588e-17, -5.583842726825463e-19,  1.412639563363008e-20,
 -3.261442366806047e-22,  6.946628892655442e-24, -1.376381424800951e-25,  1.180169786524841e-10, -1.999744357940649e-11,  1.784449480757774e-12, -1.105540663697739e-13,
  5.323723516034099e-15, -2.118384776406745e-16,  7.236625958765860e-18, -2.178233463290517e-19,  5.886599025888347e-21, -1.448642970119815e-22,  3.282310500964930e-24,
 -6.905315674570009e-26,  2.575996455458005e-11, -4.756587030128211e-12,  4.610206001471894e-13, -3.090528221608922e-14,  1.604746195849595e-15, -6.864048309684805e-17,
  2.513555719092970e-18, -8.089921730628739e-20,  2.332393570973516e-21, -6.110690151026639e-23,  1.471179976414338e-24, -3.282732370659135e-26,  5.466006344482162e-12,
 -1.096012052422246e-12,  1.150680945309699e-13, -8.327613051187324e-15,  4.653386783785378e-16, -2.135825500083424e-17,  8.370704816414293e-19, -2.876562234160678e-20,
  8.835740204858778e-22, -2.461354124531164e-23,  6.289100223517132e-25, -1.486719359446554e-26,  1.134704034832827e-12, -2.462160330606840e-13,  2.792469234853307e-14,
 -2.176725316263895e-15,  1.306311305463641e-16, -6.422097202929575e-18,  2.689322000094908e-19, -9.852536734754058e-21,  3.219671729515461e-22, -9.523688117463330e-24,
  2.579340675021601e-25, -6.451993183518983e-27,  2.321102820891197e-13, -5.431392909948417e-14,  6.636168497696844e-15, -5.558416670896465e-16,  3.574980065429656e-17,
 -1.878926694589430e-18,  8.392402308100897e-20, -3.272508400746506e-21,  1.136002073052242e-22, -3.562973224890166e-24,  1.021441785961709e-25, -2.700076259989051e-27,
  4.716180915210581e-14, -1.185958211479419e-14,  1.556611705893724e-15, -1.397526956870827e-16,  9.611693606865796e-18, -5.389688570294096e-19,  2.562940929014079e-20,
 -1.061852420511289e-21,  3.909162646320954e-23, -1.298017915454831e-24,  3.933094562120502e-26, -1.097119547924177e-27,  9.603907561666510e-15, -2.586049030773621e-15,
  3.635603386802436e-16, -3.489592602763961e-17,  2.560402161487842e-18, -1.528468725594665e-19,  7.722390249804932e-21, -3.392996740669463e-22,  1.322342083295752e-23,
 -4.640465526155438e-25,  1.483738610285754e-26, -4.360631863231797e-28,  1.979450997683386e-15, -5.686506635066046e-16,  8.536422611526095e-17, -8.735617306239024e-18,
  6.820579145195529e-19, -4.324464886731890e-20,  2.316270421122175e-21, -1.077013995871106e-22,  4.434672447020024e-24, -1.641638340729396e-25,  5.528739722152435e-27,
 -1.708946232948515e-28,  4.173993540630123e-16, -1.274407188705556e-16,  2.036163354400661e-17, -2.214950162294721e-18,  1.835247142686574e-19, -1.232685526275719e-20,
  6.982596225089154e-22, -3.428057623131308e-23,  1.488031497156051e-24, -5.798419352044343e-26,  2.052716467818037e-27, -6.660212689680404e-29,  9.109650231302570e-17,
 -2.944338839236901e-17,  4.989483523961904e-18, -5.751109186434218e-19,  5.041806151177375e-20, -3.577373771159193e-21,  2.137331326204719e-22, -1.105070718246909e-23,
  5.044427614564288e-25, -2.064265581127533e-26,  7.664191238792741e-28, -2.604497381855358e-29,  2.083162251751661e-17, -7.097971967193791e-18,  1.271000795666119e-18,
 -1.546957992640884e-19,  1.430191879217453e-20, -1.068663488281936e-21,  6.714291718879225e-23, -3.645586843150277e-24,  1.745244244052743e-25, -7.480271772771880e-27,
  2.905285804616322e-28, -1.031496118625825e-29,  5.055049583670874e-18, -1.807891045490472e-18,  3.407104407306065e-19, -4.362274787265609e-20,  4.237880841652154e-21,
 -3.323313564994890e-22,  2.188517687334610e-23, -1.243907181418742e-24,  6.226067774624641e-26, -2.786741493146900e-27,  1.128998313049615e-28, -4.176225377758263e-30,
  1.318296674652255e-18, -4.926265859558434e-19,  9.728752143115018e-20, -1.304942307104542e-20,  1.326887072786717e-21, -1.087893165396474e-22,  7.481668659206004e-24,
 -4.435839016627514e-25,  2.313436608380072e-26, -1.077772617753011e-27,  4.540007915197275e-29, -1.744241669576589e-30,  3.739323952345706e-19, -1.453078748645497e-19,
  2.993214955970609e-20, -4.187303896096248e-21,  4.437205034402547e-22, -3.787753797587165e-23,  2.709429254760856e-24, -1.669170544967192e-25,  9.036425656775393e-27,
 -4.365757884447001e-28,  1.905347284111465e-29, -7.576687707316631e-31,  1.165483878066664e-19, -4.686421653949252e-20,  1.001932742971538e-20, -1.454764029674972e-21,
  1.599036861863222e-22, -1.414724892798371e-23,  1.047932611735659e-24, -6.679444179972250e-26,  3.738030995408656e-27, -1.865274849003263e-28,  8.401063838386945e-30,
 -3.444564840016450e-31,  4.018194321277823e-20, -1.663308284817982e-20,  3.671259602887293e-21, -5.503786983114958e-22,  6.243249375886612e-23, -5.696634853257213e-24,
  4.348686412346835e-25, -2.854437334137047e-26,  1.643830830042585e-27, -8.434806755197115e-29,  3.903696165017025e-30, -1.643445804011494e-31,  1.531605144598834e-20,
 -6.492197489025407e-21,  1.471098295242039e-21, -2.264455539182232e-22,  2.636511542416608e-23, -2.467878528580301e-24,  1.931497905718209e-25, -1.299044687192632e-26,
  7.660635188577836e-28, -4.022787993558432e-29,  1.904223715622796e-30, -8.194328819160442e-32,  6.352272984966141e-21, -2.742288527320026e-21,  6.341815184137124e-22,
 -9.964548318011761e-23,  1.183943816695957e-23, -1.130469684738586e-24,  9.021269272618555e-26, -6.183482685397055e-27,  3.714548859901868e-28, -1.986092621316280e-29,
  9.568060619447776e-31, -4.188313007020578e-32,  2.705835274065605e-21, -1.183076671398212e-21,  2.775287090633017e-22, -4.423913477325787e-23,  5.331623516014851e-24,
 -5.162351456445780e-25,  4.176199777080272e-26, -2.900886957607741e-27,  1.765411080180965e-28, -9.559622346097527e-30,  4.662601996386029e-31, -2.065648363015882e-32,
  9.275400243136766e-22, -4.084394715230105e-22,  9.658069916036324e-23, -1.552008175589184e-23,  1.885434226484015e-24, -1.839917208753077e-25,  1.499876816615977e-26,
 -1.049663670542293e-27,  6.434739343922577e-29, -3.509238744767239e-30,  1.723495523366018e-31, -7.687115568909610e-33,  5.609607742193137e-02, -1.296395617949117e-04,
  3.093887512752387e-07, -7.589577385845574e-10,  1.902323386708903e-12, -4.845336491257698e-15,  1.247298043862405e-17, -3.233992733456385e-20,  8.412397939259524e-23,
 -2.193586115420459e-25,  5.713872139518858e-28, -1.489693019877551e-30,  5.218730013812559e-02, -1.451439959751357e-04,  4.791909928741456e-07, -1.667798502164132e-09,
  5.804322214857998e-12, -1.989152366752507e-14,  6.697097810912315e-17, -2.218430932107510e-19,  7.243845343480741e-22, -2.336083746247763e-24,  7.450427083816720e-27,
 -2.353017727508627e-29,  4.516979365799439e-02, -1.681723865803186e-04,  7.761351879490329e-07, -3.507603308101679e-09,  1.513309111594057e-11, -6.280893754733620e-14,
  2.527782051732485e-16, -9.919116787032428e-19,  3.809532666882468e-21, -1.435994487874864e-23,  5.324159691854239e-26, -1.944986095543940e-28,  3.637642183315481e-02,
 -1.869675460119528e-04,  1.122617155127270e-06, -6.181869498362581e-09,  3.177791429776308e-11, -1.553256835828352e-13,  7.296154908371468e-16, -3.316201102854522e-18,
  1.465547315279052e-20, -6.320791897099333e-23,  2.668152450878859e-25, -1.104880790660687e-27,  2.726076465567482e-02, -1.918029756079904e-04,  1.424669144274661e-06,
 -9.323013210968720e-09,  5.615949258728638e-11, -3.183034002095513e-13,  1.718718836338057e-15, -8.915386508738965e-18,  4.469709511584830e-20, -2.175749676687614e-22,
  1.031992044907696e-24, -4.783064725952513e-27,  1.901433601875433e-02, -1.790661591443496e-04,  1.600165689721926e-06, -1.228416399563015e-08,  8.570124201702159e-11,
 -5.567577560140047e-13,  3.417586923481144e-15, -2.002018125964222e-17,  1.127271674274865e-19, -6.133949811009969e-22,  3.239038313470408e-24, -1.665280496581295e-26,
  1.234671464966952e-02, -1.517677812461257e-04,  1.606239201128502e-06, -1.433074745535004e-08,  1.147083053150334e-10, -8.465225062967012e-13,  5.857734250754733e-15,
 -3.844508013506089e-17,  2.412877431938499e-19, -1.457060677404229e-21,  8.506055526284579e-24, -4.818476008490009e-26,  7.465799936380049e-03, -1.169833534848373e-04,
  1.451759089095199e-06, -1.493554160374351e-08,  1.361096607729273e-10, -1.132938299864583e-12,  8.779135908824748e-15, -6.415062901171679e-17,  4.461016402827848e-19,
 -2.972487731843441e-21,  1.907883729637727e-23, -1.184489818159585e-25,  4.205445801733237e-03, -8.225573205751733e-05,  1.188079046623514e-06, -1.399805621059939e-08,
  1.443148648429455e-10, -1.347023800716247e-12,  1.162573483496929e-14, -9.409902589603579e-17,  7.215087890248874e-19, -5.280159369293602e-21,  3.709474885852187e-23,
 -2.513093984209472e-25,  2.207733440827434e-03, -5.292962958641452e-05,  8.842144124740895e-07, -1.185950476368307e-08,  1.375786443404685e-10, -1.432983476150147e-12,
  1.371242081069040e-14, -1.224158191788653e-16,  1.030750415146148e-18, -8.252602734916007e-21,  6.322198951176058e-23, -4.657101833092002e-25,  1.080698766010938e-03,
 -3.126329799513067e-05,  6.006120878953672e-07, -9.121890425869672e-09,  1.185223822341276e-10, -1.371823576440110e-12,  1.449824086119499e-14, -1.422382879522310e-16,
  1.310669057846319e-18, -1.144276551159136e-20,  9.528957684733460e-23, -7.608833359896976e-25,  4.935737655237425e-04, -1.699707470773375e-05,  3.735154606493025e-07,
 -6.393332855318220e-09,  9.266396950175211e-11, -1.187493372273025e-12,  1.381438468252203e-14, -1.484716995584059e-16,  1.492752941771903e-18, -1.417078562005831e-20,
  1.279273721577812e-22, -1.104388387237958e-24,  2.104758369096730e-04, -8.527397393766168e-06,  2.132662016310919e-07, -4.096555224633678e-09,  6.599336368019507e-11,
 -9.333425641709289e-13,  1.191626276906997e-14, -1.399154843496742e-16,  1.530905874309622e-18, -1.576333923305357e-20,  1.539019797337877e-22, -1.433169723799735e-24,
  8.387314095846438e-05, -3.957183920908287e-06,  1.120913775826579e-07, -2.406927866986110e-09,  4.295621600238928e-11, -6.685479227349564e-13,  9.343014409317370e-15,
 -1.195543505579896e-16,  1.420329718665675e-18, -1.582836741616363e-20,  1.667837864484284e-22, -1.671984246014034e-24,  3.126397450546511e-05, -1.702399948013750e-06,
  5.436877189881075e-08, -1.300430071776634e-09,  2.563540319908810e-11, -4.379022692249726e-13,  6.682809024092022e-15, -9.299086798087991e-17,  1.197058632627734e-18,
 -1.441011619080688e-20,  1.635700056893228e-22, -1.762120071082552e-24,  1.091359825970468e-05, -6.804598329800156e-07,  2.439638220170043e-08, -6.478524065283865e-10,
  1.406796922527062e-11, -2.631249378408715e-13,  4.375599771747151e-15, -6.607896577320421e-17,  9.200013012146660e-19, -1.194234141038204e-20,  1.457889320916672e-22,
 -1.685077270775889e-24,  3.572552387673825e-06, -2.532660179820472e-07,  1.015259415239580e-08, -2.984036955498892e-10,  7.119670190977840e-12, -1.454883907805066e-13,
  2.631127511809796e-15, -4.304559560147441e-17,  6.471065401201563e-19, -9.043586547666218e-21,  1.185561890736009e-22, -1.468115624155490e-24,  1.098386914948914e-06,
 -8.798041819333447e-08,  3.928348325736127e-09, -1.274266449886155e-10,  3.332627967899092e-12, -7.425143937704574e-14,  1.457689268960195e-15, -2.579240130339878e-17,
  4.180157686070955e-19, -6.280509597006955e-21,  8.829447370671312e-23, -1.169885233267575e-24,  3.177506532428570e-07, -2.859488633779412e-08,  1.417036294875525e-09,
 -5.059095626930243e-11,  1.447111007581960e-12, -3.508625013749120e-14,  7.464571837490913e-16, -1.426268524090674e-17,  2.488497198472095e-19, -4.014190618836311e-21,
  6.044286849961664e-23, -8.558683186238874e-25,  8.667330448925210e-08, -8.718146888624471e-09,  4.778815965265499e-10, -1.872986800260546e-11,  5.847206922931217e-13,
 -1.539975478017198e-14,  3.544816187285343e-16, -7.303485314520175e-18,  1.370003473740625e-19, -2.369740873907537e-21,  3.817219905445485e-23, -5.770004684298915e-25,
  2.234647722045726e-08, -2.500575342037003e-09,  1.511316899726333e-10, -6.486742226746529e-12,  2.205715865733262e-13, -6.299338123093735e-15,  1.566479132207033e-16,
 -3.475389731399623e-18,  7.000065331612235e-20, -1.296848387691284e-21,  2.232310735529694e-23, -3.598271932788539e-25,  5.461085280018188e-09, -6.768838769201621e-10,
  4.497138939391228e-11, -2.108837228959261e-12,  7.795304901748591e-14, -2.410107352722406e-15,  6.465154795434319e-17, -1.542503913317634e-18,  3.332006481910451e-20,
 -6.604077513189713e-22,  1.213494255144381e-23, -2.083776603475814e-25,  1.269124124646723e-09, -1.735339918670665e-10,  1.263748959420680e-11, -6.459789272464854e-13,
  2.590948347220528e-14, -8.658004594405146e-16,  2.501804331669272e-17, -6.410775611775339e-19,  1.483404214100341e-20, -3.142028845029090e-22,  6.156731724467100e-24,
 -1.125160346276460e-25,  2.815187505064925e-10, -4.230356674021877e-11,  3.367473667499385e-12, -1.872211692086991e-13,  8.132908545535397e-15, -2.932717649871803e-16,
  9.115653103388079e-18, -2.505553509456498e-19,  6.203214626681431e-21, -1.402629082441801e-22,  2.927907611217046e-24, -5.689239529425023e-26,  5.986237731601790e-11,
 -9.850005835236754e-12,  8.547694121400900e-13, -5.157666361377305e-14,  2.422161446642279e-15, -9.410342427449863e-17,  3.141914836469326e-18, -9.251596117519888e-20,
  2.447862139600047e-21, -5.902243650838190e-23,  1.311183989276146e-24, -2.706277921279874e-26,  1.226261432709637e-11, -2.201710461979815e-12,  2.077386088115168e-13,
 -1.357510420198136e-14,  6.879536175962935e-16, -2.875055257202761e-17,  1.029644996907143e-18, -3.243798842090089e-20,  9.161439645432340e-22, -2.352967435896584e-23,
  5.557006835465736e-25, -1.217109938241861e-26,  2.433553212855565e-12, -4.751514371644985e-13,  4.861884694582736e-14, -3.433344162054059e-15,  1.874111498887202e-16,
 -8.411202689267873e-18,  3.226371832505294e-19, -1.086033594901354e-20,  3.270053762872499e-22, -8.935662360834232e-24,  2.241076463469484e-25, -5.203239904396029e-27,
  4.708855089048512e-13, -9.964565761335746e-14,  1.102847585388494e-14, -8.397788406293494e-16,  4.928090113757753e-17, -2.371271687445200e-18,  9.727169547101134e-20,
 -3.493543366339782e-21,  1.119983286943659e-22, -3.252148357859250e-24,  8.651700024953859e-26, -2.126989057761059e-27,  8.948930315140776e-14, -2.045519242336847e-14,
  2.442289656411485e-15, -2.000807286362401e-16,  1.259776231089896e-17, -6.487269958232148e-19,  2.841249324059511e-20, -1.087143191268218e-21,  3.705579915029068e-23,
 -1.141899014705763e-24,  3.218215660509748e-26, -8.367645799149649e-28,  1.684155538433393e-14, -4.144035515639709e-15,  5.323201440551549e-16, -4.680790290119298e-17,
  3.155529896685691e-18, -1.735725246395728e-19,  8.102340936560992e-21, -3.297452070815616e-22,  1.193185684103143e-23, -3.896405900494807e-25,  1.161742694503494e-26,
 -3.190418855092903e-28,  3.167812717730581e-15, -8.361686175630573e-16,  1.152309993478806e-16, -1.084864364452862e-17,  7.813055008283315e-19, -4.581184431125474e-20,
  2.274897405225487e-21, -9.829809510223121e-23,  3.769666368977932e-24, -1.302411826467842e-25,  4.101926914906082e-27, -1.188051136485450e-28,  6.016850553077844e-16,
 -1.697577756709942e-16,  2.502274549740282e-17, -2.515636927962824e-18,  1.930784158580002e-19, -1.204106713543520e-20,  6.347354566858343e-22, -2.906248667722329e-23,
  1.178973737646937e-24, -4.301910718114897e-26,  1.428727633073282e-27, -4.356989205178060e-29,  1.167173510649694e-16, -3.506620969880631e-17,  5.511166542253189e-18,
 -5.899541001236532e-19,  4.812776029945412e-20, -3.184406332636403e-21,  1.777826850545966e-22, -8.606526819930338e-24,  3.685523157055427e-25, -1.417401980475861e-26,
  4.954363148822097e-28, -1.587817194462863e-29,  2.341091792438540e-17, -7.460232335655256e-18,  1.245873826883442e-18, -1.415646087880820e-19,  1.223940592843236e-20,
 -8.568508141822656e-22,  5.053259013688617e-23, -2.580080795968030e-24,  1.163522639661203e-25, -4.705608323046576e-27,  1.727281174106294e-28, -5.805328561091300e-30,
  4.919914350693476e-18, -1.656033699951717e-18,  2.927898788473172e-19, -3.519314095073777e-20,  3.214366049128092e-21, -2.373711071625741e-22,  1.474472215627984e-23,
 -7.917936776603829e-25,  3.750259234836315e-26, -1.590847264427358e-27,  6.117090134018237e-29, -2.150844061087855e-30,  1.098402039258039e-18, -3.888205196836933e-19,
  7.248764529291073e-20, -9.182402703483094e-21,  8.828316641051516e-22, -6.853638806691009e-23,  4.469479007354221e-24, -2.516430756573520e-25,  1.248043283290573e-26,
 -5.536748181493057e-28,  2.223883073636474e-29, -8.158000350951676e-31,  2.641935700418576e-19, -9.789959803877442e-20,  1.916184233724380e-20, -2.547575733935313e-21,
  2.568140327102661e-22, -2.087986188116375e-23,  1.424316964955361e-24, -8.378368504705313e-26,  4.336330282846746e-27, -2.005278801437591e-28,  8.386581154894067e-30,
 -3.199751718888794e-31,  6.939319467267591e-20, -2.678770184917373e-20,  5.478828140412317e-21, -7.610409439529063e-22,  8.008958630627489e-23, -6.790849620929914e-24,
  4.825941671116666e-25, -2.954285231626450e-26,  1.589569121068886e-27, -7.634038325131955e-29,  3.312522527251114e-30, -1.309890283846783e-31,  2.014288047268946e-20,
 -8.059086960817650e-21,  1.713656163557672e-21, -2.474720500171257e-22,  2.705761551821253e-23, -2.381559039483525e-24,  1.755275143175609e-25, -1.113368631464136e-26,
  6.201425101370202e-28, -3.080369158596031e-29,  1.381226592181071e-30, -5.638942781738078e-32,  6.516103227844220e-21, -2.687734818144411e-21,  5.909298231445393e-22,
 -8.824498841079156e-23,  9.971929981523608e-24, -9.065026655309258e-25,  6.895026509747228e-26, -4.509941695451660e-27,  2.588361342768759e-28, -1.323743989478355e-29,
  6.106725022307401e-31, -2.562924491788215e-32,  2.352170252853293e-21, -9.947232480257978e-22,  2.248193613858257e-22, -3.451710549243737e-23,  4.008653180617648e-24,
 -3.742979370998559e-25,  2.922413114806953e-26, -1.960895855271386e-27,  1.153738496506588e-28, -6.045196097458953e-30,  2.855417190362390e-31, -1.226203845079890e-32,
  9.340369384737427e-22, -4.026786744823483e-22,  9.298276258877413e-23, -1.458767939015661e-23,  1.730651912581172e-24, -1.650069659559222e-25,  1.314897526157985e-26,
 -9.000256731078695e-28,  5.399354265611048e-29, -2.883138236248439e-30,  1.387189932546162e-31, -6.064766464264981e-33,  3.856745604444617e-22, -1.685168149107511e-22,
  3.950151114238591e-23, -6.291943088879214e-24,  7.577293134105253e-25, -7.331367905751183e-26,  5.926642743242440e-27, -4.113919584418461e-28,  2.501933975772219e-29,
 -1.353889234914176e-30,  6.599186365275320e-32, -2.921769489098041e-33,  1.298905970069841e-22, -5.718118921395452e-23,  1.351700181831765e-23, -2.171432063600415e-24,
  2.637099841706023e-25, -2.572634924776825e-26,  2.096535955071659e-27, -1.466783590490749e-28,  8.989144398404954e-30, -4.900881541640457e-31,  2.406288472992627e-32,
 -1.072950919582372e-33,  5.558241243489739e-02, -1.272003715849477e-04,  3.004607353928806e-07, -7.292798559645860e-10,  1.808338366943271e-12, -4.556554126158334e-15,
  1.160399356954245e-17, -2.977002445870539e-20,  7.662315553151721e-23, -1.977612280874166e-25,  5.097465437956205e-28, -1.316012342848217e-30,  5.161426664712414e-02,
 -1.413889732626390e-04,  4.597217746013233e-07, -1.578026726153814e-09,  5.422074850995130e-12, -1.835621579787931e-14,  6.107165152632967e-17, -1.999528195859074e-19,
  6.454094816733173e-22, -2.057773871018389e-24,  6.488839038691677e-27, -2.026480724590867e-29,  4.450926138470842e-02, -1.621276472086758e-04,  7.354563136172318e-07,
 -3.275202858617157e-09,  1.393539869631650e-11, -5.706223105500478e-14,  2.266364690804665e-16, -8.778831015512958e-19,  3.328933007757126e-21, -1.239198162855106e-23,
  4.538026537295355e-26, -1.637670563319004e-28,  3.564605560055343e-02, -1.782749249808597e-04,  1.051385883840974e-06, -5.697354203401373e-09,  2.883925241992767e-11,
 -1.388781923737259e-13,  6.429995835370797e-16, -2.881665331033099e-18,  1.256093353156591e-20, -5.344728046097640e-23,  2.226354500983720e-25, -9.099430872618939e-28,
  2.651565985575444e-02, -1.808383213759988e-04,  1.317981251551746e-06, -8.473230720877451e-09,  5.018650259999561e-11, -2.798950557483904e-13,  1.487989300719587e-15,
 -7.602829671860705e-18,  3.755937656500487e-20, -1.802147705635803e-22,  8.427910356473881e-25, -3.852273644516709e-27,  1.832277226563638e-02, -1.668319809958592e-04,
  1.460629513112138e-06, -1.099775234232074e-08,  7.534292519343652e-11, -4.810743735132645e-13,  2.904374235508113e-15, -1.674258758352730e-17,  9.281068307000220e-20,
 -4.973794191272357e-22,  2.587516404839920e-24, -1.310985989528169e-26,  1.176429662702625e-02, -1.395757816987968e-04,  1.444747303634427e-06, -1.262357058424665e-08,
  9.910082971116454e-11, -7.180281533403957e-13,  4.881928516583740e-15, -3.150140535201554e-17,  1.944792763519801e-19, -1.155718409012520e-21,  6.642029860317310e-24,
 -3.705296675133742e-26,  7.020009652535067e-03, -1.060508155490939e-04,  1.284886859590728e-06, -1.292819207503860e-08,  1.154203293262142e-10, -9.422743985134283e-13,
  7.167678616594591e-15, -5.144986206781200e-17,  3.516591802282072e-19, -2.304216561699798e-21,  1.454962785372856e-23, -8.889719495610785e-26,  3.894421122314680e-03,
 -7.338570598672941e-05,  1.033114331093061e-06, -1.189023326016093e-08,  1.199639224625498e-10, -1.097180373311249e-12,  9.287544765820117e-15, -7.378605648487363e-17,
  5.556647913940428e-19, -3.996061411373904e-21,  2.760017881314537e-23, -1.839074206278070e-25,  2.009311128814591e-03, -4.638981661249898e-05,  7.542170271403016e-07,
 -9.870744507607172e-09,  1.119504749909642e-10, -1.141547906406203e-12,  1.070515161326478e-14, -9.373467694831154e-17,  7.746347898636611e-19, -6.090698324130324e-21,
  4.584533491838842e-23, -3.319603133253452e-25,  9.646050141461529e-04, -2.686598267980557e-05,  5.016798837067648e-07, -7.427391846558008e-09,  9.426586145812752e-11,
 -1.067274347416843e-12,  1.104570869932631e-14, -1.062131264264647e-16,  9.599664514866728e-19, -8.225567901666663e-21,  6.726464517703407e-23, -5.276836320440232e-25,
  4.311091633106983e-04, -1.429232099726110e-05,  3.049621730154025e-07, -5.084016371114917e-09,  7.191883824706454e-11, -9.008751225886755e-13,  1.025576451180767e-14,
 -1.079662079401601e-16,  1.064086149443788e-18, -9.908661364677149e-21,  8.779436309245066e-23, -7.442665787568774e-25,  1.794907589595179e-04, -7.001276193284897e-06,
  1.698738164638250e-07, -3.175696131247940e-09,  4.989561703515630e-11, -6.893128443758960e-13,  8.606969956761420e-15, -9.893137024592053e-17,  1.060543675348205e-18,
 -1.070638449653184e-20,  1.025456114863567e-22, -9.373094563289989e-25,  6.967018945480253e-05, -3.165243683388667e-06,  8.692736191198937e-08, -1.815464861840333e-09,
  3.158089745067496e-11, -4.798337359222344e-13,  6.554545564872433e-15, -8.206476293828626e-17,  9.547385351208004e-19, -1.042680876320874e-20,  1.077370747886210e-22,
 -1.059706178728175e-24,  2.523447512996436e-05, -1.323510680171744e-06,  4.096157846702586e-08, -9.524267213722604e-10,  1.829081834510683e-11, -3.048689027952522e-13,
  4.545553735442325e-15, -6.186006128316489e-17,  7.794851440472696e-19, -9.191994300491271e-21,  1.022780930946256e-22, -1.080705573430774e-24,  8.537782216213351e-06,
 -5.129249796883540e-07,  1.781591332082091e-08, -4.597330460565723e-10,  9.721390336892663e-12, -1.773466840597535e-13,  2.880172693529578e-15, -4.252294199936546e-17,
  5.793180814652124e-19, -7.364165991091845e-21,  8.809679239936826e-23, -9.984403732584939e-25,  2.701719323561431e-06, -1.846328192935039e-07,  7.169303525466220e-09,
 -2.047073750740108e-10,  4.754671962275112e-12, -9.473569586919707e-14,  1.672670050025262e-15, -2.674514463818136e-17,  3.933110283863462e-19, -5.381326679599126e-21,
  6.911378969398349e-23, -8.390069693522644e-25,  8.007795110609852e-07, -6.186526560209028e-08,  2.675701361969722e-09, -8.430480479745149e-11,  2.145954126768438e-12,
 -4.660842544078564e-14,  8.931152836461848e-16, -1.544132088068232e-17,  2.447574752451057e-19, -3.599467833578682e-21,  4.956627729450828e-23, -6.437017519300274e-25,
  2.226913698041117e-07, -1.934096863812426e-08,  9.285281304902901e-10, -3.219875120756570e-11,  8.963271973211217e-13, -2.118220459868356e-14,  4.398052609111342e-16,
 -8.210024697209747e-18,  1.400780951552346e-19, -2.211432168433897e-21,  3.261193037548854e-23, -4.525622107445383e-25,  5.822042560027483e-08, -5.655800420580716e-09,
  3.004193248269007e-10, -1.143758517271660e-11,  3.474973927932110e-13, -8.920177419078632e-15,  2.003794019528263e-16, -4.033218862226570e-18,  7.397876582202194e-20,
 -1.252286749354333e-21,  1.975527476045051e-23, -2.926391403816333e-25,  1.434285752547085e-08, -1.551285365379320e-09,  9.088923984477760e-11, -3.790251332877287e-12,
  1.254434493651762e-13, -3.492063277743950e-15,  8.474841700263886e-17, -1.836903527630129e-18,  3.617921386936520e-20, -6.559536569824745e-22,  1.105812203280100e-23,
 -1.746837986832222e-25,  3.338534998069723e-09, -4.003143414592218e-10,  2.579579350913986e-11, -1.175668620459467e-12,  4.230924585828020e-14, -1.275281344409918e-15,
  3.339119879809119e-17, -7.784122715762039e-19,  1.644418637550762e-20, -3.190006189301833e-22,  5.741222196496524e-24, -9.662608300813023e-26,  7.365419920046333e-10,
 -9.752454714415523e-11,  6.892686498284549e-12, -3.425886368670333e-13,  1.338220327072288e-14, -4.360947059578251e-16,  1.230293743854950e-17, -3.081014079500165e-19,
  6.973572603200892e-21, -1.445983289880477e-22,  2.775695805503542e-24, -4.972702757271696e-26,  1.545751498002243e-10, -2.251717661738987e-11,  1.740862004098554e-12,
 -9.416571552838211e-14,  3.985692012987176e-15, -1.402162892102436e-16,  4.256617631546620e-18, -1.143800603440902e-19,  2.770820603332092e-21, -6.135033322830893e-23,
  1.254931955864940e-24, -2.391060921511619e-26,  3.098924263177476e-11, -4.948924898094234e-12,  4.174684854491432e-13, -2.452507410290737e-14,  1.122894006923551e-15,
 -4.258324519526853e-17,  1.389253409077289e-18, -4.000944109180427e-20,  1.036226638039060e-21, -2.447571936847916e-23,  5.330058253337059e-25, -1.079122987018287e-26,
  5.963811489977129e-12, -1.040582706108103e-12,  9.553527587568026e-14, -6.083186937394420e-15,  3.007726210140952e-16, -1.227729698779605e-17,  4.298862559107224e-19,
 -1.325306667093778e-20,  3.665826893914382e-22, -9.227576203354651e-24,  2.137307778524353e-25, -4.593929447447924e-27,  1.107931267408354e-12, -2.105154782023735e-13,
  2.098309612940375e-14, -1.445232853843126e-15,  7.703259555103006e-17, -3.379466753316850e-18,  1.268299767356255e-19, -4.180567660476235e-21,  1.233573511842162e-22,
 -3.305675132045432e-24,  8.135683334521483e-26, -1.854732153247522e-27,  1.999742103603461e-13, -4.124278718136454e-14,  4.451988036120906e-15, -3.310004110523750e-16,
  1.898558390364673e-17, -8.937703604836382e-19,  3.590127809246527e-20, -1.263612732247097e-21,  3.972830974377088e-23, -1.132114659490319e-24,  2.957479713131884e-26,
 -7.144014480810606e-28,  3.532703677200128e-14, -7.882562419053182e-15,  9.191760512948339e-16, -7.361339648054119e-17,  4.535296917832059e-18, -2.287269318352837e-19,
  9.818815384202163e-21, -3.685137477636211e-22,  1.232927798335449e-23, -3.731630072441459e-25,  1.033548000825836e-26, -2.642461862066450e-28,  6.159658581527758e-15,
 -1.482062512515334e-15,  1.862063018321941e-16, -1.602767141047195e-17,  1.058568153717236e-18, -5.709124375459869e-20,  2.614950481211666e-21, -1.044947742415299e-22,
  3.715046099072412e-24, -1.192663531659746e-25,  3.497851609297007e-27, -9.453863821560661e-29,  1.070158373351557e-15, -2.767149696260949e-16,  3.735744799891823e-17,
 -3.447830788872800e-18,  2.435989860098688e-19, -1.402256943359268e-20,  6.840686505105654e-22, -2.905658709656513e-23,  1.096022323832388e-24, -3.726665986443757e-26,
  1.155684475013025e-27, -3.297493058785996e-29,  1.872483127492205e-16, -5.184966565169142e-17,  7.499935102768130e-18, -7.403144358787244e-19,  5.582472048653736e-20,
 -3.422616272059665e-21,  1.774799124810073e-22, -7.998343992505346e-24,  3.195324493306985e-25, -1.148773419245931e-26,  3.760886897173216e-28, -1.131090814948653e-29,
  3.339087193133405e-17, -9.864946979101123e-18,  1.524172791932465e-18, -1.604660852729457e-19,  1.288169788419871e-20, -8.391883959003406e-22,  4.615371464932793e-23,
 -2.202178275221618e-24,  9.299083678875315e-26, -3.528157957461673e-27,  1.217148133467461e-28, -3.851605393321302e-30,  6.148294590081320e-18, -1.930489337157234e-18,
  3.175310261030935e-19, -3.554745767149712e-20,  3.029391413124275e-21, -2.091456191689540e-22,  1.216932078917638e-23, -6.133009544130728e-25,  2.731150745414300e-26,
 -1.091170653999999e-27,  3.958335670720805e-29, -1.315272172259371e-30,  1.185618216010547e-18, -3.940106646498082e-19,  6.874291702229427e-20, -8.155832682281772e-21,
  7.355419511561427e-22, -5.365579041002260e-23,  3.293633182102123e-24, -1.748509938429064e-25,  8.190214197167753e-27, -3.437109962881490e-28,  1.307936461842450e-29,
 -4.552757829154794e-31,  2.430594120372009e-19, -8.511726088406037e-20,  1.568961392912174e-20, -1.965424453736970e-21,  1.869218919696172e-22, -1.435918105871464e-23,
  9.269072297538937e-25, -5.167451490479385e-26,  2.538453036846433e-27, -1.115764881209294e-28,  4.441534101825797e-30, -1.615231068545258e-31,  5.379687512116337e-20,
 -1.975949088288798e-20,  3.831361444020229e-21, -5.046718035159342e-22,  5.041592203814664e-23, -4.063112010773934e-24,  2.748131522247759e-25, -1.603265996787593e-26,
  8.231817859933796e-28, -3.777315842050805e-29,  1.567949924956575e-30, -5.938931722685032e-32,  1.305147258570898e-20, -5.003103899929567e-21,  1.015615486198313e-21,
 -1.400270425401964e-22,  1.462909134066747e-23, -1.231662555349863e-24,  8.692967203169047e-26, -5.286253930401433e-27,  2.826009514548380e-28, -1.348755378217151e-29,
  5.817082793547190e-31, -2.286833260148153e-32,  3.518697887472876e-21, -1.400388814129535e-21,  2.960698520790001e-22, -4.251233115123805e-23,  4.622211839900006e-24,
 -4.046306464480463e-25,  2.966528595267461e-26, -1.872048276281656e-27,  1.037556442871387e-28, -5.128975658441166e-30,  2.289094537852624e-31, -9.303219663061709e-33,
  1.065160281104755e-21, -4.377004647471008e-22,  9.583727356915996e-23, -1.425274432053233e-23,  1.604105830746210e-24, -1.452491591974695e-25,  1.100574839430227e-26,
 -7.172034737482806e-28,  4.101400372049951e-29, -2.090228811316901e-30,  9.610059772283706e-32, -4.020026863479486e-33,  3.632125338340242e-22, -1.532219144451147e-22,
  3.453557322169496e-23, -5.287853650442533e-24,  6.124592029050871e-25, -5.703724118870386e-26,  4.441975633039306e-27, -2.973131611431295e-28,  1.745111824609818e-29,
 -9.122483334143087e-31,  4.299210834095249e-32, -1.842169912545910e-33,  1.377924749713188e-22, -5.931912713520526e-23,  1.367548148412124e-23, -2.142037281270229e-24,
  2.537245446842435e-25, -2.415365555569628e-26,  1.921842429970274e-27, -1.313541778066074e-28,  7.868857580202481e-30, -4.195981923854420e-31,  2.016133675831291e-32,
 -8.803002231417987e-34,  5.506252496998147e-23, -2.404211173212221e-23,  5.631191627853889e-24, -8.962425611271201e-25,  1.078483603504795e-25, -1.042677631414616e-26,
  8.422618687948109e-28, -5.842188565799385e-29,  3.550463430463400e-30, -1.919949010271158e-31,  9.351947878223286e-33, -4.137815823926963e-34,  1.820208000793783e-23,
 -8.010723487883754e-24,  1.893030888427184e-24, -3.040044762423170e-25,  3.690774689937481e-26, -3.599384444627183e-27,  2.932336456998792e-28, -2.050885436673519e-29,
  1.256493096045944e-30, -6.848332932145058e-32,  3.361473979168169e-33, -1.498428930489218e-34,  5.507836358044758e-02, -1.248312060958955e-04,  2.918800185315185e-07,
 -7.010606376547880e-10,  1.719926128983182e-12, -4.287790379765023e-15,  1.080371718882568e-17, -2.742816917389545e-20,  6.985723700855102e-23, -1.784832750497349e-25,
  4.552569940022903e-28, -1.164128683242944e-30,  5.105594841836734e-02, -1.377854969376564e-04,  4.412941108354278e-07, -1.494132748054409e-09,  5.069166015740556e-12,
 -1.695541320898750e-14,  5.575132665214235e-17, -1.804365925565387e-19,  5.757945097726463e-22, -1.815201865265129e-24,  5.660024708865268e-27, -1.748144615073378e-29,
  4.387227442068382e-02, -1.563975008636639e-04,  6.974549515031859e-07, -3.061079048527994e-09,  1.284661629533672e-11, -5.190628711910766e-14,  2.034824572734722e-16,
 -7.781583076238675e-19,  2.913831171608644e-21, -1.071301371394502e-23,  3.875442176903875e-26, -1.381749546907591e-28,  3.494935587851290e-02, -1.701296724155544e-04,
  9.856971850165082e-07, -5.257334842475493e-09,  2.620970026756078e-11, -1.243707398891815e-13,  5.676628108083153e-16, -2.508857674985103e-18,  1.078793108224199e-20,
 -4.529353750929647e-23,  1.862066371485883e-25, -7.512582557406698e-28,  2.581276903090098e-02, -1.706879488933952e-04,  1.220941749635065e-06, -7.713159560175810e-09,
  4.492915299222599e-11, -2.466078185904367e-13,  1.291005884484189e-15, -6.498544498821763e-18,  3.163972389849571e-20, -1.496628709557276e-22,  6.901930912592599e-25,
 -3.111702964035025e-27,  1.767800658235393e-02, -1.556550511224445e-04,  1.335583743391148e-06, -9.865603691613614e-09,  6.638218210283396e-11, -4.166751554715625e-13,
  2.474605293263205e-15, -1.404023639578668e-17,  7.663695035597750e-20, -4.045544907721511e-22,  2.073767522445790e-24, -1.035582596324030e-26,  1.122818673185878e-02,
 -1.285978307143324e-04,  1.302324068963747e-06, -1.114676349489500e-08,  8.584396202415125e-11, -6.107797905747620e-13,  4.081109044256700e-15, -2.589551241952394e-17,
  1.572872590026377e-19, -9.199879600545694e-22,  5.205949989080299e-24, -2.860429315542457e-26,  6.615424544218223e-03, -9.636225343700983e-05,  1.140235996170459e-06,
 -1.122335192543067e-08,  9.818465652758870e-11, -7.863384789562720e-13,  5.872913964859148e-15, -4.141890110315334e-17,  2.783043216189456e-19, -1.793542952615057e-21,
  1.114319133798387e-23, -6.701504429112712e-26,  3.616548432366803e-03, -6.566048472395059e-05,  9.012613241990249e-07, -1.013491632656286e-08,  1.000918256924898e-10,
 -8.971878113237585e-13,  7.450278463238083e-15, -5.810831974527551e-17,  4.298715547906943e-19, -3.038421813637626e-21,  2.063551222222318e-23, -1.352583171612925e-25,
  1.835109968613705e-03, -4.080107429556773e-05,  6.458048132559216e-07, -8.249069490337452e-09,  9.148982354474851e-11, -9.135086599035233e-13,  8.397021191034533e-15,
 -7.212740079977237e-17,  5.851365175302880e-19, -4.518932741330913e-21,  3.342623932342117e-23, -2.379533499894085e-25,  8.646376511060440e-04, -2.318495156028778e-05,
  4.209403404792680e-07, -6.076450382390689e-09,  7.534729615629198e-11, -8.346498254780752e-13,  8.460744225439924e-15, -7.975509667541347e-17,  7.071565997888063e-19,
 -5.948011131024500e-21,  4.777168845743719e-23, -3.682475221210592e-25,  3.784588038716702e-04, -1.207838175402938e-05,  2.503042772748638e-07, -4.065044070117566e-09,
  5.613642229674329e-11, -6.874725508545050e-13,  7.660280525036614e-15, -7.900433718620364e-17,  7.634132336107956e-19, -6.974319868817015e-21,  6.066026700011853e-23,
 -5.050514109452833e-25,  1.539801473460225e-04, -5.782126716026784e-06,  1.361344347534192e-07, -2.477309954938463e-09,  3.796906175692111e-11, -5.124812901507666e-13,
  6.259281073210677e-15, -7.044341612698383e-17,  7.399760855755836e-19, -7.325113288385042e-21,  6.883856472826869e-23, -6.176926717322369e-25,  5.827330816413133e-05,
 -2.549054555556362e-06,  6.788255157427534e-08, -1.379120084824917e-09,  2.338766258236184e-11, -3.469652813079086e-13,  4.633465439230956e-15, -5.677065395951276e-17,
  6.468757601304728e-19, -6.924213248204854e-21,  7.016818721505135e-23, -6.772670125502054e-25,  2.052989112624882e-05, -1.036987053874834e-06,  3.110486826542552e-08,
 -7.031671036452798e-10,  1.315743993618694e-11, -2.140216522637800e-13,  3.118067023829105e-15, -4.150607819142838e-17,  5.120234253336558e-19, -5.915583512979743e-21,
  6.452988865780786e-23, -6.688521266090913e-25,  6.739603267101966e-06, -3.900676742470364e-07,  1.312646550282709e-08, -3.291805694352194e-10,  6.779125028677339e-12,
 -1.206380509918998e-13,  1.913602479672929e-15, -2.762401647019568e-17,  3.682976491288789e-19, -4.585207039029724e-21,  5.375801104030281e-23, -5.974703111908090e-25,
  2.063991510416559e-06, -1.359420693066936e-07,  5.113164582741706e-09, -1.418403181960392e-10,  3.207395582108328e-12, -6.231734697165037e-14,  1.074308376025055e-15,
 -1.679004782215420e-17,  2.415611268693155e-19, -3.235991559203955e-21,  4.072039881696503e-23, -4.846337616996056e-25,  5.904618610183313e-07, -4.398653424127862e-08,
  1.842699835519055e-09, -5.639475210515831e-11,  1.397224050759947e-12, -2.958420901050861e-14,  5.533667120699397e-16, -9.349067474422731e-18,  1.449435602361581e-19,
 -2.086553393537461e-21,  2.814584444655593e-23, -3.582842195450643e-25,  1.580428417313156e-07, -1.324330762470521e-08,  6.158744964574117e-10, -2.074307000951827e-11,
  5.619515786159824e-13, -1.294436342622639e-14,  2.623031166421477e-16, -4.783984038678915e-18,  7.982173277828483e-20, -1.233341308024112e-21,  1.781386084403563e-23,
 -2.422787342379619e-25,  3.965216689465824e-08, -3.718964456443188e-09,  1.913927466739790e-10, -7.077628506951514e-12,  2.092613279520687e-13, -5.235494805624032e-15,
  1.147712263054677e-16, -2.256802733030067e-18,  4.047756738887753e-20, -6.705506201067547e-22,  1.035970470703854e-23, -1.503905938369908e-25,  9.345865905002489e-09,
 -9.766509867481890e-10,  5.545934045545067e-11, -2.246760151281929e-12,  7.236925658180128e-14, -1.963579709004873e-15,  4.650466376708041e-17, -9.847148604519785e-19,
  1.896461175834039e-20, -3.364909990108012e-22,  5.555387077291334e-24, -8.600189925454139e-26,  2.074666760719428e-09, -2.405603843522518e-10,  1.503087562846816e-11,
 -6.656860937589905e-13,  2.331951875613294e-14, -6.851878764435986e-16,  1.750972948386453e-17, -3.987984863366721e-19,  8.238526403339969e-21, -1.564136170776874e-22,
  2.757082807224342e-24, -4.547711517061682e-26,  4.350703914246195e-10, -5.575889656044187e-11,  3.823416554179206e-12, -1.847397978505013e-13,  7.026634504218794e-15,
 -2.232678926336652e-16,  6.148763965324643e-18, -1.504694125367750e-19,  3.331006737726903e-21, -6.760789837732996e-23,  1.271259163756139e-24, -2.232403635827759e-26,
  8.649276430273405e-11, -1.220794875545603e-11,  9.163448648936380e-13, -4.821035820383264e-14,  1.987776384812279e-15, -6.820927191253729e-17,  2.021992238135617e-18,
 -5.310849760261618e-20,  1.258641519573658e-21, -2.728554542509232e-23,  5.468494811720177e-25, -1.021545655481672e-26,  1.636779613071932e-11, -2.535559652263935e-12,
  2.078300904598217e-13, -1.188312536908096e-14,  5.302886233489295e-16, -1.962455399888771e-17,  6.254569391661189e-19, -1.761355495934885e-20,  4.464551853114618e-22,
 -1.032835405763882e-23,  2.204468758972630e-25, -4.377265890479900e-27,  2.962540971745788e-12, -5.020444253429987e-13,  4.482915731896379e-14, -2.780362433531310e-15,
  1.340766281413272e-16, -5.343970887355167e-18,  1.828965444174473e-19, -5.516394329783596e-21,  1.494014236556739e-22, -3.685005690006524e-24,  8.369149329923802e-26,
 -1.764982295323840e-27,  5.157156289811704e-13, -9.530059776571874e-14,  9.248605540997837e-15, -6.210290259886737e-16,  3.231024373573596e-17, -1.385076928757417e-18,
  5.084246868829998e-20, -1.640575107610385e-21,  4.742680893195814e-23, -1.246031454223893e-24,  3.008563918990760e-26, -6.733076830492807e-28,  8.689928805831056e-14,
 -1.745588527232462e-14,  1.836799423228844e-15, -1.332768188560112e-16,  7.468712546417013e-18, -3.438564315993020e-19,  1.352019348569718e-20, -4.661921738577644e-22,
  1.436991214239551e-23, -4.017406053060554e-25,  1.030275725783770e-26, -2.444624988858221e-28,  1.427903812772330e-14, -3.108113411266694e-15,  3.537659592994962e-16,
 -2.768222793462467e-17,  1.668044043451427e-18, -8.235215889267191e-20,  3.463675095007413e-21, -1.274634880959895e-22,  4.184372691793370e-24, -1.243468365912072e-25,
  3.383547827895850e-27, -8.503684328683358e-29,  2.307561378342756e-15, -5.425432269520576e-16,  6.663141724182690e-17, -5.611099720875550e-18,  3.628891686880128e-19,
 -1.918071059210128e-20,  8.616564914601589e-22, -3.379485283668985e-23,  1.180027147269495e-24, -3.722916723338813e-26,  1.073622884114235e-27, -2.854852200236113e-29,
  3.703388810030903e-16, -9.374185912866278e-17,  1.239017782559479e-17, -1.120370929221009e-18,  7.761515582757792e-20, -4.384096359785328e-21,  2.100096760598038e-22,
 -8.765082916874580e-24,  3.250631141275174e-25, -1.087308654127420e-26,  3.318844531141097e-28, -9.325491102848770e-30,  5.967929351137450e-17, -1.620766477391996e-17,
  2.299137566543289e-18, -2.226980108761434e-19,  1.648978815696308e-20, -9.934027428131507e-22,  5.064892869943210e-23, -2.245606397042754e-24,  8.830867764241905e-26,
 -3.126834577324525e-27,  1.008686893390104e-28, -2.990670061524944e-30,  9.777033390958402e-18, -2.838546598592310e-18,  4.308721535417289e-19, -4.458797993883113e-20,
  3.520314121765929e-21, -2.256815851295503e-22,  1.222126679060194e-23, -5.744690984428109e-25,  2.390989093366084e-26, -8.945709200161811e-28,  3.044625832849031e-29,
 -9.509292882534988e-31,  1.650931833944777e-18, -5.104370414244911e-19,  8.264060142416091e-20, -9.109785704328829e-21,  7.648222593912628e-22, -5.204500748599011e-23,
  2.986315172042455e-24, -1.484862731591017e-25,  6.526731654884591e-27, -2.574921892332706e-28,  9.227403682662319e-30, -3.030063420155566e-31,  2.916994392655213e-19,
 -9.565129164239441e-20,  1.645859743547137e-20, -1.926339525752181e-21,  1.714537818556821e-22, -1.234858433766991e-23,  7.487212709683529e-25, -3.927663322115618e-26,
  1.818660374008573e-27, -7.547461454168453e-29,  2.841177567251869e-30, -9.786883989925454e-32,  5.480860404742423e-20, -1.897740684246135e-20,  3.456844935101133e-21,
 -4.280101271193133e-22,  4.024653698672094e-23, -3.057892953609476e-24,  1.953020785365306e-25, -1.077642011092448e-26,  5.241294077098029e-28, -2.281660196139958e-29,
  8.998116221194494e-31, -3.242849471197877e-32,  1.113760043847144e-20, -4.052900073493000e-21,  7.781413596463969e-22, -1.015036965470347e-22,  1.004424204656770e-23,
 -8.020625003669193e-25,  5.376654438721499e-26, -3.109769839657220e-27,  1.583380647257993e-28, -7.206992536576555e-30,  2.968203889135818e-31, -1.115764701176567e-32,
  2.489327383276056e-21, -9.472239471760654e-22,  1.907676906711308e-22, -2.609632747839038e-23,  2.705567500207514e-24, -2.261006484374596e-25,  1.584329747354335e-26,
 -9.567322124230503e-28,  5.080138919480530e-29, -2.408719634964837e-30,  1.032279856434972e-31, -4.033263096108101e-33,  6.216109995266181e-22, -2.460099177048765e-22,
  5.169692178792296e-23, -7.378457395460158e-24,  7.975146890665044e-25, -6.941549151708319e-26,  5.060911932268882e-27, -3.176534220142882e-28,  1.751364465826315e-29,
 -8.613776843653307e-31,  3.825536388849373e-32, -1.547381987537019e-33,  1.755898932300679e-22, -7.186633974185474e-23,  1.566697043642178e-23, -2.319822647122216e-24,
  2.599762834278899e-25, -2.344270817797773e-26,  1.769127707694732e-27, -1.148364413572596e-28,  6.542122441142222e-30, -3.321846365212896e-31,  1.521806660465805e-32,
 -6.343964083737822e-34,  5.641034977292061e-23, -2.373442546481426e-23,  5.334170458891060e-24, -8.143677797488197e-25,  9.405520066469122e-26, -8.734937192537459e-27,
  6.784324056831394e-28, -4.529055334060716e-29,  2.651632768690916e-30, -1.382714707666044e-31,  6.500839598002924e-33, -2.779106038600079e-34,  2.039845027397283e-23,
 -8.768038276750890e-24,  2.017957911222820e-24, -3.155405322853977e-25,  3.731312836157370e-26, -3.546257944104551e-27,  2.817165294213604e-28, -1.922492970691277e-29,
  1.149947357749641e-30, -6.122996292299994e-32,  2.937866405157560e-33, -1.280988482649137e-34,  7.874932181522862e-24, -3.435894543867382e-24,  8.040909408664088e-25,
 -1.278689436055529e-25,  1.537420489494535e-26, -1.485170314378568e-27,  1.198750500757005e-28, -8.308475366007953e-30,  5.045492440968430e-31, -2.726399401291165e-32,
  1.327062733822850e-33, -5.867581170626487e-35,  2.552556812986644e-24, -1.123041692101601e-24,  2.652982926781271e-25, -4.258993269097937e-26,  5.168870606209095e-27,
 -5.039176210134300e-28,  4.103937619214522e-29, -2.869370443950705e-30,  1.757382411480589e-31, -9.575350113612244e-33,  4.698571362053595e-34, -2.093830353802009e-35,
  5.458365620772468e-02, -1.225293554655341e-04,  2.836296187786094e-07, -6.742140346509629e-10,  1.636702287173337e-12, -4.037470242155123e-15,  1.006608303175419e-17,
 -2.529212711710416e-20,  6.374765008796220e-23, -1.612570071547666e-25,  4.070245965409018e-28, -1.031156379266395e-30,  5.051175549546709e-02, -1.343255089180048e-04,
  4.238401981121720e-07, -1.415667939241746e-09,  4.743039349558391e-12, -1.567598484658602e-14,  5.094753715925158e-17, -1.630144896162790e-19,  5.143437537485001e-22,
 -1.603457802687075e-24,  4.944480853618895e-27, -1.510482950037988e-29,  4.325761588565361e-02, -1.509613759760130e-04,  6.619218596507263e-07, -2.863580075583278e-09,
  1.185561445915820e-11, -4.727397887059320e-14,  1.829435083273603e-16, -6.907987152191421e-19,  2.554660954155973e-21, -9.277864228786506e-24,  3.315852580953331e-26,
 -1.168168184314374e-28,  3.428421860756570e-02, -1.624895023194674e-04,  9.250455476398301e-07, -4.857161925579767e-09,  2.385302984871505e-11, -1.115522562551764e-13,
  5.020125467486686e-16, -2.188357665410416e-18,  9.283834108429491e-21, -3.846635190032376e-23,  1.560952449941657e-25, -6.217502010244346e-28,  2.514898287520048e-02,
 -1.612787900310748e-04,  1.132539561428226e-06, -7.032126761328307e-09,  4.029267016414463e-11, -2.176975733826726e-13,  1.122447751703627e-15, -5.567207479590085e-18,
  2.671749274475334e-20, -1.246098173614955e-22,  5.667605040262146e-25, -2.520689141118299e-27,  1.707603061324205e-02, -1.454264872242916e-04,  1.223304282126039e-06,
 -8.867058761788865e-09,  5.861211810935506e-11, -3.617379346798088e-13,  2.113731759297016e-15, -1.180571821302945e-17,  6.346246916633102e-20, -3.300458723408474e-22,
  1.667294299067813e-24, -8.207515237084080e-27,  1.073381722226717e-02, -1.186918282465192e-04,  1.176417401532793e-06, -9.865899773880609e-09,  7.455191592695307e-11,
 -5.209945392054890e-13,  3.421793301316738e-15, -2.135438150111408e-17,  1.276313003502316e-19, -7.348997998870100e-22,  4.095291264818459e-24, -2.216626158958315e-26,
  6.247402519121716e-03, -8.775352749930639e-05,  1.014486288472054e-06, -9.770930235330614e-09,  8.377840677234127e-11, -6.583556678850009e-13,  4.828739887550200e-15,
 -3.346567099881393e-17,  2.210966963381533e-19, -1.401648020199438e-21,  8.569933929091044e-24, -5.073826670967659e-26,  3.367593134604841e-03, -5.891094838134157e-05,
  7.886890226590764e-07, -8.667808468306852e-09,  8.381197102788105e-11, -7.364467579941045e-13,  6.000455785130432e-15, -4.595420810832210e-17,  3.340152563939342e-19,
 -2.320818041839705e-21,  1.550129631747296e-23, -9.996492605266652e-26,  1.681645006216048e-03, -3.600702654749778e-05,  5.550297671674876e-07, -6.921094408129645e-09,
  7.508167968195610e-11, -7.342406789075924e-13,  6.616866288755538e-15, -5.576706140762468e-17,  4.441950155659509e-19, -3.370048905542520e-21,  2.450098536900424e-23,
 -1.715024862670269e-25,  7.781984267163743e-04, -2.008980456968661e-05,  3.547391764972852e-07, -4.994120479585336e-09,  6.051641505732747e-11, -6.560180116839286e-13,
  6.514673583554569e-15, -6.021286393908937e-17,  5.238455878879460e-19, -4.325933869947534e-21,  3.412930814233218e-23, -2.585516132275404e-25,  3.338614580599366e-04,
 -1.025678414690538e-05,  2.064895284434007e-07, -3.267573187192488e-09,  4.405959665154006e-11, -5.276270408209625e-13,  5.755526005510117e-15, -5.816429732075565e-17,
  5.511376961140721e-19, -4.940580703588971e-21,  4.218906733147259e-23, -3.450375772825509e-25,  1.328551319487300e-04, -4.802363618189273e-06,  1.097382238341112e-07,
 -1.944265296036139e-09,  2.907475761808245e-11, -3.834776792289494e-13,  4.582232889976750e-15, -5.050099373511847e-17,  5.199136344998579e-19, -5.047524146283636e-21,
  4.654835538376263e-23, -4.100928719088394e-25,  4.906672955344596e-05, -2.066321117306474e-06,  5.336751935005079e-08, -1.054891033455431e-09,  1.744281039043962e-11,
 -2.527102592371025e-13,  3.299762364241416e-15, -3.957067168925531e-17,  4.416779790518471e-19, -4.634482307900794e-21,  4.606677153989623e-23, -4.363800942775848e-25,
  1.683083469608576e-05, -8.186220364174484e-07,  2.380088904399441e-08, -5.231897531202632e-10,  9.540001421702960e-12, -1.514629030297857e-13,  2.156512086624456e-15,
 -2.808294539588928e-17,  3.392039901212998e-19, -3.840004748611395e-21,  4.107148585219988e-23, -4.176443373469548e-25,  5.366718658628010e-06, -2.991810680234697e-07,
  9.754891751152181e-09, -2.377621572637534e-10,  4.769263056903031e-12, -8.280036253024635e-14,  1.282997570739589e-15, -1.811108164264812e-17,  2.363341075580581e-19,
 -2.881971378742463e-21,  3.311840801410743e-23, -3.609936154483310e-25,  1.592371326424478e-06, -1.010590313591652e-07,  3.681997457186610e-09, -9.923726836959731e-11,
  2.184898176860047e-12, -4.139927314816641e-14,  6.969138917207499e-16, -1.064714921654801e-17,  1.498768431844148e-19, -1.965997267493034e-21,  2.424132565146640e-23,
 -2.828763865383514e-25,  4.401955765143369e-07, -3.161252503903862e-08,  1.282685876907110e-09, -3.813144245008079e-11,  9.195843874377487e-13, -1.898291841286972e-14,
  3.466221343615854e-16, -5.722965979593385e-18,  8.678850884218717e-20, -1.223071503057780e-21,  1.616230648713721e-23, -2.016789228593344e-25,  1.135395254845153e-07,
 -9.176788092450930e-09,  4.133566997011190e-10, -1.352173120334809e-11,  3.565009717070641e-13, -8.004452497005240e-15,  1.583083742718467e-16, -2.821048398807004e-18,
  4.603273058158124e-20, -6.961565649958848e-22,  9.848558737153795e-24, -1.312815841301671e-25,  2.737166410854378e-08, -2.477712064039904e-09,  1.235267231127552e-10,
 -4.436576126529810e-12,  1.276493575532505e-13, -3.112641070445075e-15,  6.658867909215913e-17, -1.279164767413932e-18,  2.243460160074058e-20, -3.637161262027696e-22,
  5.503283441301084e-24, -7.829356049398791e-26,  6.180157394410336e-09, -6.237689526103188e-10,  3.432321098264599e-11, -1.350653065174761e-12,  4.233740749568582e-14,
 -1.119581078848642e-15,  2.587530257809312e-17, -5.352374741277553e-19,  1.007932394063336e-20, -1.750124514449326e-22,  2.829672665350032e-24, -4.292859054628927e-26,
  1.310074894546810e-09, -1.468334284784308e-10,  8.893838402840980e-12, -3.826916246112942e-13,  1.304799266575963e-14, -3.736890541409323e-16,  9.319428296827153e-18,
 -2.073627073620684e-19,  4.188849727646537e-21, -7.782930538353968e-23,  1.343569632241604e-24, -2.171885229204134e-26,  2.614779339464797e-10, -3.242142684616647e-11,
  2.156262560379217e-12, -1.012599855059884e-13,  3.749561759918936e-15, -1.161507922009855e-16,  3.122220876374024e-18, -7.465390580256548e-20,  1.616230311350652e-21,
 -3.210705627873111e-23,  5.913290385712548e-25, -1.017774713348258e-26,  4.930398606394878e-11, -6.739373471797659e-12,  4.909628571974228e-13, -2.511674986090465e-14,
  1.008575882016768e-15, -3.375062879909206e-17,  9.768197848021208e-19, -2.507448724564329e-20,  5.812862151741835e-22, -1.233636054553562e-23,  2.422154989737949e-25,
 -4.435695796534153e-27,  8.817808906224508e-12, -1.324329058897108e-12,  1.054332500834602e-13, -5.865345464470019e-15,  2.550399690940704e-16, -9.208276864621569e-18,
  2.866403358107489e-19, -7.891697859226687e-21,  1.957318307187903e-22, -4.434187295941470e-24,  9.274578625283528e-26, -1.805873721114556e-27,  1.502773637105910e-12,
 -2.471991427747577e-13,  2.145858478921044e-14, -1.295840843244575e-15,  6.092647022997398e-17, -2.370487262101058e-18,  7.927855969783502e-20, -2.338772507362157e-21,
  6.200606182719948e-23, -1.498284184513287e-24,  3.335914285446880e-26, -6.901340290089653e-28,  2.453852193412196e-13, -4.407397163933140e-14,  4.162388133761502e-15,
 -2.723710866974251e-16,  1.382668606546220e-17, -5.789821725706172e-19,  2.078083384037325e-20, -6.562430152911098e-22,  1.858124187054508e-23, -4.784987176158835e-25,
  1.133193274901535e-26, -2.489010298234009e-28,  3.863572866892365e-14, -7.554162618194338e-15,  7.744378309189896e-16, -5.481427057031474e-17,  2.999837340126297e-18,
 -1.350181694726587e-19,  5.194772196117143e-21, -1.754219450722321e-22,  5.299589481701018e-24, -1.453143968710137e-25,  3.657400642018006e-27, -8.522256033066699e-29,
  5.909233445756182e-15, -1.253934032534210e-15,  1.392298241215686e-16, -1.063952790624868e-17,  6.267372047988588e-19, -3.027779793093355e-20,  1.247198445357225e-21,
 -4.498606851792546e-23,  1.448545930878025e-24, -4.225100841338274e-26,  1.129130121844816e-27, -2.788721914647146e-29,  8.855224837622774e-16, -2.033064021625542e-16,
  2.439214083094617e-17, -2.008514347064784e-18,  1.271340174974773e-19, -6.582514061977574e-21,  2.899008430143456e-22, -1.115514327156313e-23,  3.824036570814468e-25,
 -1.185203576815904e-26,  3.359662924765760e-28, -8.786323138133822e-30,  1.313068368681108e-16, -3.251364575776967e-17,  4.204716687108703e-18, -3.722957270453648e-19,
  2.527541810958356e-20, -1.400230188304700e-21,  6.583322254226293e-23, -2.698636259130984e-24,  9.835885293667647e-26, -3.235280462444517e-27,  9.716238618988788e-29,
 -2.687613929400185e-30,  1.948538569552999e-17, -5.186435809254567e-18,  7.210557430654988e-19, -6.849466338115101e-20,  4.977432976656531e-21, -2.944902095260071e-22,
  1.475567671901457e-23, -6.433328290290543e-25,  2.489263920259715e-26, -8.677088643712480e-28,  2.757074065609373e-29, -8.055637978101703e-31,  2.931187562885915e-18,
 -8.357081034692577e-19,  1.245495462828584e-19, -1.266114499278979e-20,  9.825796348470985e-22, -6.195584628213371e-23,  3.301863860258292e-24, -1.528301581957871e-25,
  6.266828824638513e-27, -2.311147896867217e-28,  7.756967951978323e-30, -2.390291659461420e-31,  4.534773466505071e-19, -1.379687842402095e-19,  2.197316126767962e-20,
 -2.383656599679913e-21,  1.970426750569894e-22, -1.320917707405423e-23,  7.470586378783971e-25, -3.663047467430036e-26,  1.588520027882508e-27, -6.185775722244817e-29,
  2.188894747218848e-30, -7.100571191884595e-32,  7.331267113424849e-20, -2.370590122811456e-20,  4.020503869677845e-21, -4.639526084457271e-22,  4.073138660183148e-23,
 -2.894931034121428e-24,  1.732902954981982e-25, -8.978585680376807e-27,  4.107927784346756e-28, -1.685150702970391e-29,  6.272830269459353e-31, -2.137459732671973e-32,
  1.260210449396233e-20, -4.311899266519771e-21,  7.757448187750160e-22, -9.488390115926815e-23,  8.816942134910067e-24, -6.622570902772340e-25,  4.183014344044837e-26,
 -2.283460541267752e-27,  1.099122236470058e-28, -4.736876696170276e-30,  1.849970666024386e-31, -6.604685117732596e-33,  2.345885205566353e-21, -8.453199056796255e-22,
  1.606249592812744e-22, -2.073938479602055e-23,  2.031930119974376e-24, -1.606976193019343e-25,  1.067226216302546e-26, -6.117110798030511e-28,  3.087473807275573e-29,
 -1.393454939116781e-30,  5.692059335906215e-32, -2.122771604825987e-33,  4.817869771256303e-22, -1.819010951287544e-22,  3.632995316781656e-23, -4.928921590861410e-24,
  5.069112760647989e-25, -4.203190277183689e-26,  2.923019826771143e-27, -1.752223157532677e-28,  9.238221131779226e-30, -4.350208480172467e-31,  1.851935449135486e-32,
 -7.189283284133963e-34,  1.111153500525860e-22, -4.371507744762366e-23,  9.127668684823575e-24, -1.294477333091618e-24,  1.390479138284573e-25, -1.202971046210347e-26,
  8.719262700002368e-28, -5.441712232490174e-29,  2.983778827487994e-30, -1.459709194410541e-31,  6.449404446061536e-33, -2.595695962818357e-34,  2.920384617458368e-23,
 -1.190209354475650e-23,  2.582687321472596e-24, -3.806590832183676e-25,  4.246704456886089e-26, -3.812553497610964e-27,  2.864924496992524e-28, -1.851977475358134e-29,
  1.050828282655863e-30, -5.315000801016166e-32,  2.425748801368237e-33, -1.007543260499323e-34,  8.814697088646856e-24, -3.698414076532773e-24,  8.286457311487268e-25,
 -1.261209634179314e-25,  1.452245374656430e-26, -1.344748834973495e-27,  1.041473741993074e-28, -6.933399994836991e-30,  4.048414299457327e-31, -2.105582565703857e-32,
  9.874415344890746e-34, -4.210999361440403e-35,  3.030880240093189e-24, -1.300673806627001e-24,  2.988094880392022e-25, -4.663918558577827e-26,  5.505345825838624e-27,
 -5.223229127763188e-28,  4.142354236780521e-29, -2.822191856551565e-30,  1.685416140189042e-31, -8.960262211721294e-33,  4.292752723850420e-34, -1.869032754318358e-35,
  1.128330024755059e-24, -4.919110403788154e-25,  1.150187103642197e-25, -1.827435481862404e-26,  2.195274086157495e-27, -2.118846861473337e-28,  1.708788746844385e-29,
 -1.183386166795311e-30,  7.180647212249768e-32, -3.877158348025679e-33,  1.885768963570663e-34, -8.331797773128315e-36,  3.582239229961131e-25, -1.575574369884950e-25,
  3.720690445428889e-26, -5.970898260303735e-27,  7.243910215978781e-28, -7.059660504445021e-29,  5.747441098035775e-30, -4.017100632932412e-31,  2.459504020885514e-32,
 -1.339658012935518e-33,  6.571521748626742e-35, -2.927558769515226e-36,  5.409802624000494e-02, -1.202922416588001e-04,  2.756935509230782e-07, -6.486599038241537e-10,
  1.558312548669423e-12, -3.804157146470368e-15,  9.385611595973893e-18, -2.334203072428661e-20,  5.822484565019719e-23, -1.458480245060082e-25,  3.642730509555054e-28,
 -9.146217980481416e-31,  4.998112910264840e-02, -1.310014726909285e-04,  4.072973795099801e-07, -1.342222550742528e-09,  4.441386735269351e-12, -1.450620896045523e-14,
  4.660514433848777e-17, -1.474421721373188e-19,  4.600248267437810e-22, -1.418349471898135e-24,  4.325734805904065e-27, -1.307207958184327e-29,  4.266414795915047e-02,
 -1.458002985538411e-04,  6.286665920817070e-07, -2.681221936593377e-09,  1.095252105668351e-11, -4.310650509464567e-14,  1.646971890656017e-16, -6.141473512751800e-19,
  2.243343655012511e-21, -8.048832962212707e-24,  2.842306477522879e-26, -9.895455783658657e-29,  3.364870112399068e-02, -1.553159590940702e-04,  8.689779359056538e-07,
 -4.492727429809989e-09,  2.173767275892783e-11, -1.002069107138031e-13,  4.446978012751701e-16, -1.912278058046161e-18,  8.005141811975958e-21, -3.273695139347009e-23,
  1.311460272889956e-25, -5.157870845644802e-28,  2.452146895421070e-02, -1.525453776650913e-04,  1.051883056706058e-06, -6.420863291846429e-09,  3.619596199030522e-11,
 -1.925367923968894e-13,  9.778909728436633e-16, -4.779855573072815e-18,  2.261422882442472e-20, -1.040107255564975e-22,  4.666366955942728e-25, -2.047630461873816e-27,
  1.651324544042034e-02, -1.360502617675410e-04,  1.122296224239541e-06, -7.984495033412958e-09,  5.185902068910831e-11, -3.147561488412774e-13,  1.809904461999147e-15,
 -9.952828472949902e-18,  5.269907068339052e-20, -2.700518822102669e-22,  1.344640389483611e-24, -6.525958306828494e-27,  1.027715039851112e-02, -1.097345380011631e-04,
  1.064853649290626e-06, -8.752161519719817e-09,  6.490710920568460e-11, -4.456084182268855e-13,  2.877286986184940e-15, -1.766367983125743e-17,  1.039027134258329e-19,
 -5.890490692043975e-22,  3.233074096718112e-24, -1.724114476346105e-26,  5.911908500276516e-03, -8.008481543302335e-05,  9.048628974133757e-07, -8.529820741249462e-09,
  7.169823312881363e-11, -5.529552531787964e-13,  3.983614258766315e-15, -2.713589801601480e-17,  1.763051006943421e-19, -1.099663567375970e-21,  6.617737852688043e-24,
 -3.857723617005176e-26,  3.143940381445751e-03, -5.299576480067552e-05,  6.922594161956561e-07, -7.437240521449474e-09,  7.042485051506591e-11, -6.067417587998125e-13,
  4.851622362972523e-15, -3.649094392753991e-17,  2.606421409358169e-19, -1.780571128635549e-21,  1.169815731229283e-23, -7.423295508062984e-26,  1.545998800607891e-03,
 -3.187964123581646e-05,  4.787264422617972e-07, -5.829141025105383e-09,  6.186628323317559e-11, -5.926730984472294e-13,  5.237416858296032e-15, -4.331865578943831e-17,
  3.388347737258646e-19, -2.525858028159400e-21,  1.805192343971634e-23, -1.242686546486501e-25,  7.031574719605890e-04, -1.747609314451702e-05,  3.002123646195598e-07,
 -4.122866487893609e-09,  4.883222531686027e-11, -5.181381431353623e-13,  5.041741287592928e-15, -4.569881633743645e-17,  3.901691585116649e-19, -3.163906138287088e-21,
  2.452395604744448e-23, -1.826116611444194e-25,  2.959057381218958e-04, -8.750483064773137e-06,  1.711830179403321e-07, -2.640054626606013e-09,  3.476610787591043e-11,
 -4.071981007300061e-13,  4.349257675157656e-15, -4.307551442574440e-17,  4.003169201407263e-19, -3.521836097457516e-21,  2.953106390244479e-23, -2.372719971071403e-25,
  1.152641672589391e-04, -4.010420549659314e-06,  8.896324043661961e-08, -1.534899347785619e-09,  2.239945145553310e-11, -2.887482919583467e-13,  3.376180303831481e-15,
 -3.644434272815954e-17,  3.677790157809185e-19, -3.502297838996975e-21,  3.169954082491212e-23, -2.742400164930396e-25,  4.158137834905198e-05, -1.685629211757509e-06,
  4.222952195919117e-08, -8.122866539929509e-10,  1.309844526336503e-11, -1.853569190078294e-13,  2.366906843855563e-15, -2.778525845461171e-17,  3.038427659300733e-19,
 -3.125750213895911e-21,  3.048027084628156e-23, -2.834080322579987e-25,  1.390077967907384e-05, -6.509463485197840e-07,  1.834691500449390e-08, -3.922185166839322e-10,
  6.970449737743892e-12, -1.080331494629438e-13,  1.503438982958758e-15, -1.915597002841020e-17,  2.265809028532904e-19, -2.513711499663121e-21,  2.636484997456246e-23,
 -2.630522398923797e-25,  4.309680913745996e-06, -2.313730625716943e-07,  7.309929657141707e-09, -1.731871637768731e-10,  3.384140066666521e-12, -5.732659969817495e-14,
  8.678250710462703e-16, -1.198089155213981e-17,  1.530362267443210e-19, -1.828150927439694e-21,  2.059380861014522e-23, -2.201764660077453e-25,  1.240268032490634e-06,
 -7.582963726753989e-08,  2.676265520287178e-09, -7.008639229859948e-11,  1.502570258381810e-12, -2.776809060354450e-14,  4.565038311518386e-16, -6.818285602943141e-18,
  9.391755570179846e-20, -1.206441212654772e-21,  1.457772908288046e-23, -1.668048338899047e-25,  3.316889340612658e-07, -2.295738700525448e-08,  9.021877456944934e-10,
 -2.605268086298903e-11,  6.115998671960629e-13, -1.230969510872031e-14,  2.194392261989613e-16, -3.540975410228502e-18,  5.253012290394363e-20, -7.247536447396462e-22,
  9.382983208379452e-24, -1.147817785433984e-25,  8.254082444009084e-08, -6.432957033195089e-09,  2.806390051864167e-10, -8.916127543031094e-12,  2.287788551334066e-13,
 -5.007164025334905e-15,  9.665699496503676e-17, -1.682991385223799e-18,  2.685871171712491e-20, -3.975811411114597e-22,  5.509402016088686e-24, -7.198311736747020e-26,
  1.914348664869817e-08, -1.671955409938837e-09,  8.073900482615310e-11, -2.816236733819389e-12,  7.884962910243374e-14, -1.873920099725697e-15,  3.912218093575560e-17,
 -7.342132837037105e-19,  1.259199172730653e-20, -1.997909099526382e-22,  2.960662398797632e-24, -4.127945916025142e-26,  4.145865438382128e-09, -4.040042564316844e-10,
  2.153764649096501e-11, -8.231534171863763e-13,  2.510817360639288e-14, -6.470901123943753e-16,  1.459367397084553e-17, -2.948933983235442e-19,  5.429955248218802e-21,
 -9.226529266906866e-23,  1.460930202081004e-24, -2.171973084466402e-26,  8.403082890773786e-10, -9.100071739152583e-11,  5.342073133559999e-12, -2.232928890693340e-13,
  7.409086081434377e-15, -2.068094463850472e-16,  5.033021237642861e-18, -1.093989456032085e-19,  2.160850114133556e-21, -3.928964863277570e-23,  6.642329438918915e-25,
 -1.052240852568219e-26,  1.598332101014310e-10, -1.916516706982678e-11,  1.235913705217242e-12, -5.639753928300502e-14,  2.032767207404395e-15, -6.138108434765712e-17,
  1.610302640279031e-18, -3.761689348194973e-20,  7.963787531778256e-22, -1.548310882394243e-23,  2.792848248065562e-25, -4.711114668605756e-27,  2.862182492675127e-11,
 -3.787015277237699e-12,  2.676643384509176e-13, -1.331142298009691e-14,  5.204689956978861e-16, -1.698194056532577e-17,  4.797868958327572e-19, -1.203478938993004e-20,
  2.728734889981388e-22, -5.668576132157768e-24,  1.090237131510418e-25, -1.957065667125812e-27,  4.843799288692513e-12, -7.049240796295742e-13,  5.448795448614939e-14,
 -2.948311744927520e-15,  1.248838409209112e-16, -4.398043832142312e-18,  1.336877286617226e-19, -3.597728390406680e-21,  8.729836934361125e-23, -1.936375939777547e-24,
  3.968375905756642e-26, -7.575981792859462e-28,  7.782042977214509e-13, -1.241864440377024e-13,  1.047543100750908e-14, -6.157055709330014e-16,  2.821585716805831e-17,
 -1.071333372331233e-18,  3.500343492780592e-20, -1.009777713224172e-21,  2.620151789879837e-23, -6.201214289862840e-25,  1.353297724522911e-26, -2.745956163873024e-28,
  1.193255734276962e-13, -2.081854952883263e-14,  1.912396747950279e-15, -1.218985260760120e-16,  6.035674737033706e-18, -2.467995528493556e-19,  8.658804022762427e-21,
 -2.675300753229583e-22,  7.417434589219832e-24, -1.871785757062200e-25,  4.346835954178189e-27, -9.368492995860543e-29,  1.757233525025719e-14, -3.342085863846432e-15,
  3.336310623825498e-16, -2.302430611579291e-17,  1.230054516598422e-18, -5.410277424295007e-20,  2.036165757783003e-21, -6.731739499756581e-23,  1.992622124280612e-24,
 -5.357271190319594e-26,  1.322961878508195e-27, -3.026505226087874e-29,  2.503670240931411e-15, -5.175740501085721e-16,  5.602986511090453e-17, -4.179215855665994e-18,
  2.405559591229392e-19, -1.136696745863305e-20,  4.583918515776377e-22, -1.620004457709747e-23,  5.114844561024031e-25, -1.463854502967825e-26,  3.840972467038347e-28,
 -9.319693277748536e-30,  3.481056483535834e-16, -7.798820509695686e-17,  9.135208680444437e-18, -7.351284857926376e-19,  4.551927377664819e-20, -2.307627625487899e-21,
  9.959243108069134e-23, -3.758265487174731e-24,  1.264374433769466e-25, -3.848314332063097e-27,  1.071912283397412e-28, -2.756184489662023e-30,  4.770613335326638e-17,
 -1.154745582827263e-17,  1.460191387675355e-18, -1.265256344905216e-19,  8.413652884340762e-21, -4.569194022448011e-22,  2.107520175807966e-23, -8.481352253535176e-25,
  3.036779730255997e-26, -9.818734415488131e-28,  2.900227539610183e-29, -7.894591343544508e-31,  6.519066616215591e-18, -1.699404357979062e-18,  2.314036417125279e-19,
 -2.154446389360120e-20,  1.535656110127612e-21, -8.918458858221611e-23,  4.389449202152162e-24, -1.881048421434299e-25,  7.158318192705022e-27, -2.455471781062826e-28,
  7.681739656478940e-30, -2.210980775444860e-31,  9.001159910474204e-19, -2.518393597393902e-19,  3.682668908844210e-20, -3.675289881507228e-21,  2.802020308499053e-22,
 -1.736817290378288e-23,  9.104773029273160e-25, -4.147736562880041e-26,  1.674867864411737e-27, -6.085762199271556e-29,  2.013465939612285e-30, -6.118925204201102e-32,
  1.274799209511714e-19, -3.814007388715662e-20,  5.971371374243053e-21, -6.370882332646435e-22,  5.182434364964718e-23, -3.420686229424963e-24,  1.905872064177251e-25,
 -9.211044554376852e-27,  3.939123783549276e-28, -1.513362808889457e-29,  5.285741091062596e-31, -1.693147736831048e-32,  1.883312381104679e-20, -6.001243588080416e-21,
  1.002578552542932e-21, -1.140014446634300e-22,  9.866578969401342e-24, -6.916498342484516e-25,  4.085434856436001e-26, -2.089703979793497e-27,  9.442775218035815e-29,
 -3.827306685088896e-30,  1.408199643280657e-31, -4.744748443150505e-33,  2.956449150795145e-21, -9.990250354251880e-22,  1.774119060343579e-22, -2.142478201509129e-23,
  1.966369034958883e-24, -1.459390902992580e-25,  9.111833046199284e-27, -4.918684586350314e-28,  2.342076514809097e-29, -9.988491773664233e-31,  3.861635546746858e-32,
 -1.365224707119475e-33,  5.030248464774074e-22, -1.793977026896579e-22,  3.371955145279095e-23, -4.307314044632140e-24,  4.176274944722600e-25, -3.269646432569354e-26,
  2.150310478324752e-27, -1.220908759962758e-28,  6.106130858423871e-30, -2.731554913284716e-31,  1.106275311932373e-32, -4.091649865425276e-34,  9.468014193596681e-23,
 -3.545331830472615e-23,  7.018891722063256e-24, -9.440153468958676e-25,  9.626727917886219e-26, -7.916908895646942e-27,  5.461989256063068e-28, -3.249090741622369e-29,
  1.700284515422151e-30, -7.948910752828425e-32,  3.360369478862118e-33, -1.295723060693523e-34,  2.010952894528865e-23, -7.861924495887605e-24,  1.630477283487472e-24,
 -2.296824041684451e-25,  2.451009687554243e-26, -2.107002323242688e-27,  1.517762942311800e-28, -9.415828225167687e-30,  5.132993133974270e-31, -2.497072270297031e-32,
  1.097290906756335e-33, -4.393115097300816e-35,  4.902825931127339e-24, -1.989174140632257e-24,  4.295260054473795e-25, -6.299845834121971e-26,  6.994683605632450e-27,
 -6.250453945552620e-28,  4.675721604267380e-29, -3.009340554549965e-30,  1.700304494219474e-31, -8.564756377795157e-33,  3.893406234438788e-34, -1.610933265606468e-35,
  1.386312002085074e-24, -5.799362430752443e-25,  1.295137792431212e-25, -1.964795322071653e-26,  2.255180303623607e-27, -2.081757850015633e-28,  1.607400683139637e-29,
 -1.066960220781417e-30,  6.212291888188717e-32, -3.222121428493929e-33,  1.507024700290757e-34, -6.410204920635500e-36,  4.521021173852309e-25, -1.936803615186362e-25,
  4.440981237311060e-26, -6.918317608423900e-27,  8.151059831348254e-28, -7.719137232536679e-29,  6.110814737163881e-30, -4.156071105747981e-31,  2.477822973047523e-32,
 -1.315140617344390e-33,  6.290667586656574e-35, -2.734698337021288e-36,  1.619833523413275e-25, -7.055984823010802e-26,  1.648289333326603e-26, -2.616363348502389e-27,
  3.140088026142731e-28, -3.028018454322628e-29,  2.439849128508391e-30, -1.688211203168801e-31,  1.023527672039166e-32, -5.521983317751468e-34,  2.683645800036801e-35,
 -1.184788676392333e-36,  5.031217749557622e-26, -2.212152244618153e-26,  5.222022003525296e-27, -8.377056356955518e-28,  1.015927248740403e-28, -9.897226718025923e-30,
  8.054659916605581e-31, -5.627705561850643e-32,  3.444412997847410e-33, -1.875485429856539e-34,  9.196885139347809e-36, -4.095801133040719e-37,  5.362121966289914e-02,
 -1.181174107696778e-04,  2.680567583847793e-07, -6.243235478407734e-10,  1.484430080675948e-12, -3.586539602309124e-15,  8.757349739963913e-18, -2.156010877555366e-20,
  5.322717927865650e-23, -1.320509100755508e-25,  3.263269502971065e-28, -8.124034959773301e-31,  4.946353963795407e-02, -1.278063339415404e-04,  3.916077010253538e-07,
 -1.273421957618490e-09,  4.162121792850729e-12, -1.343560862969389e-14,  4.267541026493725e-17, -1.335060451067753e-19,  4.119450389396276e-22, -1.256291393341573e-24,
  3.789848039159399e-27, -1.133056765601430e-29,  4.209080577864684e-02, -1.408967495394357e-04,  5.975156006203862e-07, -2.512669579460281e-09,  1.012856620934543e-11,
 -3.935227423351939e-14,  1.484640373585368e-16, -5.467852934829898e-19,  1.973043174007220e-21, -6.994392545481598e-24,  2.440792650010696e-26, -8.398512160989851e-29,
  3.304100763839399e-02, -1.485740225118041e-04,  8.170877166569904e-07, -4.160395583152167e-09,  1.983607007777060e-11, -9.014879615133703e-14,  3.945701160178685e-16,
 -1.674000316768823e-18,  6.915813874892537e-21, -2.791817199200309e-23,  1.104255448395183e-25, -4.288740688038444e-28,  2.392764311042066e-02, -1.444289539391123e-04,
  9.781844449972131e-07, -5.871302693068010e-09,  3.256948765177540e-11, -1.705950027171415e-13,  8.536479836648345e-16, -4.112677048121037e-18,  1.918519193986607e-20,
 -8.702934761118829e-23,  3.851957743713001e-25, -1.667888102920498e-27,  1.598641361316594e-02, -1.274415056343118e-04,  1.031260404919157e-06, -7.202843004825184e-09,
  4.597664979716971e-11, -2.744806575941854e-13,  1.553443807648464e-15, -8.412164009004271e-18,  4.387993524598159e-20, -2.215972513495695e-22,  1.087700370541899e-24,
 -5.205339111592574e-27,  9.854608801670446e-03, -1.016188115827496e-04,  9.657764019157976e-07, -7.781354778308318e-09,  5.664729021353152e-11, -3.821315519354587e-13,
  2.426234144916886e-15, -1.465453735817871e-17,  8.485286448569319e-20, -4.737126109969178e-22,  2.561263735256884e-24, -1.345900236103342e-26,  5.605425243528825e-03,
 -7.323664971023204e-05,  8.090392759827292e-07, -7.466174533901594e-09,  6.153679723313982e-11, -4.658634850447607e-13,  3.297188300598800e-15, -2.207959622107967e-17,
  1.410994491459718e-19, -8.660258706933424e-22,  5.130519696175302e-24, -2.945190260618300e-26,  2.942494119607244e-03, -4.779640425971093e-05,  6.093924493022597e-07,
 -6.401526244537727e-09,  5.937627405670411e-11, -5.016774487559454e-13,  3.937615835605301e-15, -2.909171722211873e-17,  2.042322756544301e-19, -1.371995121547827e-21,
  8.867731499087408e-24, -5.538082969557486e-26,  1.425719466458443e-03, -2.831365929108168e-05,  4.143457957607209e-07, -4.927669977025519e-09,  5.117754753183099e-11,
 -4.803842257946650e-13,  4.163557433233505e-15, -3.380151084920229e-17,  2.596830181421070e-19, -1.902378155093991e-21,  1.336747663985823e-23, -9.051214486243385e-26,
  6.377609238783821e-04, -1.525975637134420e-05,  2.551040551090147e-07, -3.418289509295701e-09,  3.958270377940964e-11, -4.111791478555630e-13,  3.921111088656415e-15,
 -3.486116145854931e-17,  2.921463529727241e-19, -2.326689304096304e-21,  1.772126713483848e-23, -1.297233770990608e-25,  2.634546682116094e-04, -7.498869191314698e-06,
  1.425884683876258e-07, -2.143662624683630e-09,  2.757528456608020e-11, -3.159512213815916e-13,  3.304939385616773e-15, -3.208493875537845e-17,  2.924955946301025e-19,
 -2.525825121297365e-21,  2.080030270617575e-23, -1.642114928290011e-25,  1.005373013348735e-04, -3.366709068731951e-06,  7.251758923163623e-08, -1.218629746491001e-09,
  1.735852188384490e-11, -2.187436767884161e-13,  2.503166210094416e-15, -2.646982412491522e-17,  2.618816992664232e-19, -2.446576367944585e-21,  2.173693339010943e-23,
 -1.846881385521152e-25,  3.545748216419522e-05, -1.383482945793184e-06,  3.362651719065363e-08, -6.295281926731186e-10,  9.901613356458870e-12, -1.368844351270578e-13,
  1.709670788848426e-15, -1.964982534073705e-17,  2.105536055224309e-19, -2.123941020096318e-21,  2.032108091739508e-23, -1.854878669920644e-25,  1.156321147997111e-05,
 -5.212538772420213e-07,  1.424403962523740e-08, -2.961847683415173e-10,  5.131070686377063e-12, -7.764456625896361e-14,  1.056305573680445e-15, -1.317042334570010e-17,
  1.525743359260536e-19, -1.659029770868531e-21,  1.706562030701408e-23, -1.670874013855105e-25,  3.489178556936509e-06, -1.803664356695296e-07,  5.522102001611943e-09,
 -1.271863634179638e-10,  2.421334599450379e-12, -4.002656255336160e-14,  5.920587725721180e-16, -7.994968657009698e-18,  9.997691054496548e-20, -1.170104783773549e-21,
  1.292244971158262e-23, -1.355288462703222e-25,  9.749690121113472e-07, -5.741359993912519e-08,  1.962913193968248e-09, -4.995215892484612e-11,  1.042903914549651e-12,
 -1.879977329719144e-14,  3.018638213103896e-16, -4.408246550788208e-18,  5.942295096876883e-20, -7.476003303012069e-22,  8.853330755515836e-24, -9.934484390601211e-26,
  2.525267250870462e-07, -1.684106468571580e-08,  6.409871679676133e-10, -1.798106326852276e-11,  4.109285269527129e-13, -8.064716231377429e-15,  1.403673595990248e-16,
 -2.213887124800738e-18,  3.213083348240492e-20, -4.340423205507320e-22,  5.505746939115980e-24, -6.603228326961786e-26,  6.070035376218533e-08, -4.560456270612623e-09,
  1.926718823223652e-10, -5.945201710804054e-12,  1.484671250673558e-13, -3.167605212663060e-15,  5.968497245522596e-17, -1.015501164934090e-18,  1.585098227151436e-20,
 -2.296796054278573e-22,  3.117731744042266e-24, -3.992857168927497e-26,  1.356035685624144e-08, -1.142324198610920e-09,  5.342489611152720e-11, -1.809702818882765e-12,
  4.930518778590505e-14, -1.142059623739433e-15,  2.326858828448904e-17, -4.266322557313843e-19,  7.155154553418846e-21, -1.111094129610540e-22,  1.612617536681646e-24,
 -2.203588915620002e-26,  2.820376176895207e-09, -2.652575931913745e-10,  1.369785553163718e-11, -5.084167243648992e-13,  1.508981824454496e-14, -3.789992247092717e-16,
  8.340667350170863e-18, -1.646406445561517e-19,  2.964240791174710e-21, -4.929019084871122e-23,  7.643223600356285e-25, -1.113569646222090e-26,  5.472869981960106e-10,
 -5.724328297302524e-11,  3.256055492207491e-12, -1.321899653634051e-13,  4.268143419319649e-15, -1.161051422256955e-16,  2.757176948321716e-18, -5.854264563568788e-20,
  1.130615560321996e-21, -2.011683162315402e-23,  3.330539444550212e-25, -5.170299460172503e-27,  9.933376643482023e-11, -1.151327170417923e-11,  7.197125119254324e-13,
 -3.190661789257152e-14,  1.119251718368820e-15, -3.294032266731068e-17,  8.433136312896494e-19, -1.924482836869791e-20,  3.983860836794005e-22, -7.579741713577244e-24,
  1.338988291315424e-25, -2.213508691641896e-27,  1.691505704985819e-11, -2.165333383401065e-12,  1.484357797737387e-13, -7.174355882299669e-15,  2.730809551701704e-16,
 -8.686210189512848e-18,  2.395285295669212e-19, -5.870356303458914e-21,  1.301673715459333e-22, -2.646575725011566e-24,  4.985634038964914e-26, -8.771797219472511e-28,
  2.712224089932996e-12, -3.822729728645739e-13,  2.867753266960416e-14, -1.508828479319559e-15,  6.224171551061931e-17, -2.137588431271487e-18,  6.343753199654288e-20,
 -1.668446077980625e-21,  3.960119955607948e-23, -8.599226301072713e-25,  1.726496970911037e-26, -3.231231681884095e-28,  4.112823779143752e-13, -6.363564814300658e-14,
  5.213787537357424e-15, -2.981608852895048e-16,  1.331388849936754e-17, -4.931971060131536e-19,  1.573877373528121e-20, -4.438891151941410e-22,  1.127048031365460e-23,
 -2.612169825683785e-25,  5.586463976105808e-27, -1.111592497156628e-28,  5.928758301266911e-14, -1.004150880416321e-14,  8.967760026772072e-16, -5.565828212620887e-17,
  2.687036544598049e-18, -1.072571913290721e-19,  3.677319146610242e-21, -1.111333932528845e-22,  3.016409561225023e-24, -7.457429098526474e-26,  1.697874341360894e-27,
 -3.589926319811229e-29,  8.174556135312895e-15, -1.511339823385203e-15,  1.468351244397093e-16, -9.875635739006306e-18,  5.148269549441480e-19, -2.212069913759930e-20,
  8.140794708245048e-22, -2.634167917501172e-23,  7.637564176878696e-25, -2.012831770148596e-26,  4.875719471033656e-28, -1.094807125182309e-29,  1.085922671445537e-15,
 -2.185499631186285e-16,  2.305363049853073e-17, -1.677574912737515e-18,  9.431176236751697e-20, -4.357181536025789e-21,  1.719547857832862e-22, -5.952192833731335e-24,
  1.842091162094423e-25, -5.171315407112515e-27,  1.331837303130305e-28, -3.173854349173826e-30,  1.401815788616301e-16, -3.062445032591167e-17,  3.500133569923892e-18,
 -2.751146337805082e-19,  1.665624352802009e-20, -8.264012993516226e-22,  3.493587393423517e-23, -1.292399837788381e-24,  4.265451949608924e-26, -1.274473394834564e-27,
  3.487062377620954e-29, -8.812657469425333e-31,  1.776272867733102e-17, -4.199917250157332e-18,  5.189672169670610e-19, -4.398208671205824e-20,  2.863175744513717e-21,
 -1.523505527981172e-22,  6.890705730192136e-24, -2.721222771179039e-25,  9.567852403748930e-27, -3.039711584838494e-28,  8.827525630940428e-30, -2.363806827348998e-31,
  2.235387508537289e-18, -5.702920445131629e-19,  7.600794455258435e-20, -6.931716784017828e-21,  4.843583990007476e-22, -2.759735276957953e-23,  1.333545084870801e-24,
 -5.614499103443926e-26,  2.100429952857434e-27, -7.087164550502608e-29,  2.182101865891359e-30, -6.184564820307168e-32,  2.832194493339226e-19, -7.770454618469248e-20,
  1.114160840634799e-20, -1.090956248869334e-21,  8.166244444783380e-23, -4.973239942797890e-24,  2.563136520476618e-25, -1.148674142639220e-26,  4.565602869017535e-28,
 -1.633795214725183e-29,  5.326118531959173e-31, -1.595658762873270e-32,  3.669344672859604e-20, -1.078786442652374e-20,  1.659288828548299e-21, -1.740017948731253e-22,
  1.392046831284447e-23, -9.041903736262794e-25,  4.960406922421873e-26, -2.361817778519178e-27,  9.955762767545969e-29, -3.771949714626450e-30,  1.299795825190111e-31,
 -4.109666860291009e-33,  4.947770643907872e-21, -1.552666869197220e-21,  2.553470134725340e-22, -2.859298694128797e-23,  2.438197965312988e-24, -1.684864354026035e-25,
  9.815454342204828e-27, -4.954020788161161e-28,  2.209889582148631e-29, -8.846033297102810e-31,  3.215737201462373e-32, -1.070943353281192e-33,  7.081202147412683e-22,
 -2.361699482798258e-22,  4.137384375341928e-23, -4.930273103656691e-24,  4.466905111389420e-25, -3.274062310180301e-26,  2.019662334857699e-27, -1.077599044164024e-28,
  5.073575222970230e-30, -2.140322402114273e-31,  8.187859356867978e-33, -2.865347645265598e-34,  1.098834834128285e-22, -3.876448425420472e-23,  7.203353869250234e-24,
 -9.098587350487814e-25,  8.725877730202629e-26, -6.759659676187867e-27,  4.400285845947943e-28, -2.473809080907686e-29,  1.225446154727216e-30, -5.431490111405472e-32,
  2.180132393713623e-33, -7.993925144087961e-35,  1.890528708946078e-23, -7.017714619627535e-24,  1.376523121027522e-24, -1.834502898160277e-25,  1.854158442698189e-26,
 -1.511719039950794e-27,  1.034270376808139e-28, -6.102828967594471e-30,  3.168776032030574e-31, -1.470239890429865e-32,  6.169979866423448e-34, -2.362287899688502e-35,
  3.686954392915013e-24, -1.431861144772267e-24,  2.948321966028768e-25, -4.123838293430542e-26,  4.370264859137628e-27, -3.731685420566054e-28,  2.670622949483130e-29,
 -1.646365372935535e-30,  8.920423595363292e-32, -4.313978887792328e-33,  1.884875115988419e-34, -7.504668570803607e-36,  8.312673305167002e-25, -3.356507382286781e-25,
  7.210135173642703e-26, -1.052043076035075e-26,  1.162175932223018e-27, -1.033421553467677e-28,  7.693814223107776e-30, -4.928971709808966e-31,  2.772471518380716e-32,
 -1.390504335263795e-33,  6.294531303211096e-35, -2.593876107443756e-36,  2.195251086543374e-25, -9.154436703868669e-26,  2.037327103874501e-26, -3.080047392723294e-27,
  3.523284051316828e-28, -3.241623174522146e-29,  2.494965555751658e-30, -1.650969885338880e-31,  9.583740345516404e-33, -4.956304527570835e-34,  2.311578693352433e-35,
 -9.805587142324767e-37,  6.771794534471382e-26, -2.895701201538084e-26,  6.626156617637391e-27, -1.030139350165022e-27,  1.211263769444456e-28, -1.144839476229300e-29,
  9.045861590559245e-31, -6.140912663492480e-32,  3.654628472608807e-33, -1.936383984994318e-34,  9.246662619390037e-36, -4.013197931456684e-37,  2.330233081286457e-26,
 -1.014147713066111e-26,  2.366717588506720e-27, -3.752992897804540e-28,  4.499816924785455e-29, -4.335053370076304e-30,  3.489734493502801e-31, -2.412462216983956e-32,
  1.461330527375780e-33, -7.877160328662966e-35,  3.825038852923486e-36, -1.687324703207849e-37,  7.072070502526104e-27, -3.108417439558785e-27,  7.334906645751573e-28,
 -1.176187161970918e-28,  1.425863758077661e-29, -1.388551286494517e-30,  1.129618073923836e-31, -7.889600637177314e-33,  4.827045137373575e-34, -2.627396189208358e-35,
  1.287957582990016e-36, -5.733926959108575e-38,  5.315299204229091e-02, -1.160025258462671e-04,  2.607050504207359e-07, -6.011352951471378e-10,  1.414753130632937e-12,
 -3.383419239791595e-15,  8.176815375234143e-18, -1.993044938928940e-20,  4.869993692632995e-23, -1.196854885149686e-25,  2.925974174969780e-28, -7.226822282286284e-31,
  4.895848481711321e-02, -1.247334845569576e-04,  3.767175105758900e-07, -1.208923302281795e-09,  3.903356451839216e-12, -1.245480798811134e-14,  3.911519641189721e-17,
 -1.210191175846327e-19,  3.693312760812365e-22, -1.114211931933519e-24,  3.325005001204799e-27, -9.836162641744783e-30,  4.153659187927195e-02, -1.362345364872793e-04,
  5.683105487137031e-07, -2.356720366835958e-09,  9.375947893496773e-12, -3.596594877072176e-14,  1.340014215330747e-16, -4.874952467975261e-19,  1.737963599180017e-21,
 -6.088123236538613e-24,  2.099704706275310e-26, -7.141465935277113e-29,  3.245947620225820e-02, -1.422317581161835e-04,  7.690093583589511e-07, -3.856943248029578e-09,
  1.812411975990997e-11, -8.121746897113739e-14,  3.506511692672649e-16, -1.467958225518471e-18,  5.985920895848035e-21, -2.385651143514126e-23,  9.317761791248033e-26,
 -3.574140026972327e-28,  2.336514420046937e-02, -1.368766942694971e-04,  9.107463925489996e-07, -5.376410874735448e-09,  2.935348218618070e-11, -1.514227290173583e-13,
  7.466373877306097e-16, -3.546043875133795e-18,  1.631266195122056e-20, -7.299447049480702e-23,  3.187728339864373e-25, -1.362191183513272e-27,  1.549261746212032e-02,
 -1.195250576465866e-04,  9.490652396089208e-07, -6.509185143247090e-09,  4.084157417829155e-11, -2.398729051933552e-13,  1.336419511982587e-15, -7.127677276491475e-18,
  3.663336653675548e-20, -1.823456688674086e-22,  8.824502670028056e-25, -4.164793349822977e-27,  9.463015606648899e-03, -9.425125828963983e-05,  8.775959576933378e-07,
 -6.933109559965627e-09,  4.955524022704262e-11, -3.285341073412154e-13,  2.051491987990365e-15, -1.219343378282860e-17,  6.950901669889540e-20, -3.821928384574338e-22,
  2.035933963992896e-24, -1.054374125464591e-26,  5.324878574336856e-03, -6.710665505739715e-05,  7.250586185183908e-07, -6.552025776130016e-09,  5.296329578412839e-11,
 -3.936669462655546e-13,  2.737753584987781e-15, -1.802603946079781e-17,  1.133241588562875e-19, -6.845575557567827e-22,  3.992912823610417e-24, -2.257555358069516e-26,
  2.760594101297936e-03, -4.321311809171599e-05,  5.379590560722627e-07, -5.526903828336646e-09,  5.022540444320166e-11, -4.162542852541601e-13,  3.207580380402207e-15,
 -2.328259183987191e-17,  1.606785316905992e-19, -1.061627719068851e-21,  6.751555642637391e-24, -4.150358218000929e-26,  1.318738591160340e-03, -2.522219723301884e-05,
  3.598264936022574e-07, -4.180567085854575e-09,  4.249705223890865e-11, -3.909369164569170e-13,  3.323850423528861e-15, -2.649154313897049e-17,  1.999335753328197e-19,
 -1.439609018518469e-21,  9.947302962731835e-24, -6.625970671522611e-26,  5.805581889523836e-04, -1.337282867793112e-05,  2.176288419696750e-07, -2.845955601254475e-09,
  3.222627053694899e-11, -3.278021973530247e-13,  3.064202417173006e-15, -2.672627808698277e-17,  2.198790607945344e-19, -1.720132026902042e-21,  1.287588984484999e-23,
 -9.267296908846504e-26,  2.355876778332010e-04, -6.454010461958896e-06,  1.193163854418077e-07, -1.748988068398279e-09,  2.198180640740411e-11, -2.464341609025197e-13,
  2.524997254467486e-15, -2.403252008910130e-17,  2.149496038270192e-19, -1.822261001483651e-21,  1.474013890280581e-23, -1.143582145581117e-25,  8.814438320367775e-05,
 -2.840653533646864e-06,  5.942600324034452e-08, -9.728641979561858e-10,  1.352894402079722e-11, -1.666903390743063e-13,  1.867203497312310e-15, -1.934573418792471e-17,
  1.876758688494692e-19, -1.720355606004035e-21,  1.500593527681882e-23, -1.252361396468686e-25,  3.041727559248259e-05, -1.142189378773811e-06,  2.693913165700802e-08,
 -4.909486991486378e-10,  7.533334081326269e-12, -1.017587290496428e-13,  1.243341256873581e-15, -1.399331050094433e-17,  1.469473961470432e-19, -1.453720949535735e-21,
  1.364857903281676e-23, -1.223182126871959e-25,  9.685415853205491e-06, -4.202324331086824e-07,  1.113530146321608e-08, -2.252494652173694e-10,  3.804455380305916e-12,
 -5.621759477300746e-14,  7.477704236128513e-16, -9.125056421068000e-18,  1.035482108889810e-19, -1.103712518695968e-21,  1.113626417559053e-23, -1.070092386550698e-25,
  2.847255749160392e-06, -1.416921396317111e-07,  4.204203757902701e-09, -9.414728880293692e-11,  1.746480183272128e-12, -2.817756963561749e-14,  4.073056301883053e-16,
 -5.380535726812635e-18,  6.587831037822926e-20, -7.554900691160841e-22,  8.180807969523755e-24, -8.417545029810487e-26,  7.732906446580769e-07, -4.385054010419001e-08,
  1.452367274255298e-09, -3.591842634541624e-11,  7.303710929269208e-13, -1.284395988466436e-14,  2.014502332839167e-16, -2.876710870740242e-18,  3.795330140574687e-20,
 -4.677000004421394e-22,  5.428789345619647e-24, -5.974541453857657e-26,  1.941947149049436e-07, -1.247565174312159e-08,  4.598808152618307e-10, -1.253267932386255e-11,
  2.788455789385998e-13, -5.336628749029384e-15,  9.069709588369740e-17, -1.398308360830874e-18,  1.985589503120802e-20, -2.626428829587956e-22,  3.264526388522216e-24,
 -3.838871502836132e-26,  4.514069001268285e-08, -3.268421069294628e-09,  1.337196651818182e-10, -4.007441731703765e-12,  9.740294037187366e-14, -2.025914752410337e-15,
  3.726269599910509e-17, -6.195616717217953e-19,  9.459345423982371e-21, -1.341779007078491e-22,  1.784276809521547e-24, -2.240022501162074e-26,  9.725191298028123e-09,
 -7.899369789387634e-10,  3.577621533941652e-11, -1.176846475728862e-12,  3.120036801760629e-14, -7.043826211658120e-16,  1.400592321263425e-17, -2.508966793685624e-19,
  4.114998125658504e-21, -6.254155779195060e-23,  8.890643178206714e-25, -1.190700539770502e-26,  1.944987174466699e-09, -1.764868032917681e-10,  8.826708497975196e-12,
 -3.181369152786150e-13,  9.187325320909495e-15, -2.248739420866915e-16,  4.829045044215541e-18, -9.311808222427703e-20,  1.639300192677428e-21, -2.667561605086742e-23,
  4.050980138479429e-25, -5.783909009940592e-27,  3.617969836680391e-10, -3.653463883860361e-11,  2.013171816305302e-12, -7.937265467732751e-14,  2.493580096884917e-15,
 -6.610210244727785e-17,  1.531663596031156e-18, -3.176723028018093e-20,  5.998478866581402e-22, -1.044400307884875e-23,  1.693269733808919e-25, -2.575880450339716e-27,
  6.274296121609736e-11, -7.026392066333671e-12,  4.256582204742079e-13, -1.832955465003774e-14,  6.256892048163728e-16, -1.794589978952361e-17,  4.483083463256880e-19,
 -9.993535550942202e-21,  2.022715053855422e-22, -3.765924966870703e-24,  6.514847546407955e-26, -1.055395292231757e-27,  1.017315559907753e-11, -1.259358566195556e-12,
  8.370362276764403e-14, -3.930932433946790e-15,  1.456333092909120e-16, -4.515220637768831e-18,  1.215106896487870e-19, -2.909300443393049e-21,  6.308062134585161e-23,
 -1.255181078362053e-24,  2.315757418763444e-26, -3.993084709643713e-28,  1.547510817000920e-12, -2.111279607779161e-13,  1.536603520148477e-14, -7.858844153053707e-16,
  3.156497168731576e-17, -1.056936243657546e-18,  3.061849021569872e-20, -7.868816279464824e-22,  1.826672659836497e-23, -3.882582316117874e-25,  7.635816444046255e-27,
 -1.400817870040615e-28,  2.217698482691203e-13, -3.325036042919501e-14,  2.644963796724181e-15, -1.471172811285446e-16,  6.399198690239453e-18, -2.312146066133232e-19,
  7.204963329202875e-21, -1.986253609102926e-22,  4.933870236855189e-24, -1.119640924252189e-25,  2.346178921104244e-27, -4.577299324157611e-29,  3.009048686419454e-14,
 -4.944454475464976e-15,  4.290958920372365e-16, -2.592108627358117e-17,  1.219731797606272e-18, -4.751375910527162e-20,  1.591462158237656e-21, -4.703256781190271e-23,
  1.249417196150614e-24, -3.025572050896104e-26,  6.752011973925608e-28, -1.400267011524626e-29,  3.888753477553866e-15, -6.984524089108407e-16,  6.600794543040117e-17,
 -4.324659675590119e-18,  2.199051363221970e-19, -9.227021074018326e-21,  3.319429338612286e-22, -1.050927680529069e-23,  2.983849618921043e-25, -7.706363647997082e-27,
  1.830628652515677e-28, -4.033674489486994e-30,  4.821113221738150e-16, -9.439716362870453e-17,  9.697108891857337e-18, -6.880768974599638e-19,  3.776514654307275e-20,
 -1.705169168355237e-21,  6.583116632687458e-23, -2.231146534003790e-24,  6.766122549902511e-26, -1.862609322717367e-27,  4.707095484087579e-29, -1.101397333860312e-30,
  5.782694758528787e-17, -1.230998624764937e-17,  1.371944806523296e-18, -1.052727065027442e-19,  6.228716147436011e-21, -3.023163450535161e-22,  1.251359566515430e-23,
 -4.536314725580372e-25,  1.468225473352445e-26, -4.305060955892301e-28,  1.156659955626683e-29, -2.872198547293136e-31,  6.778457127211509e-18, -1.564450535746322e-18,
  1.887810587473780e-19, -1.563907134008177e-20,  9.961395184389511e-22, -5.190933228359182e-23,  2.301204328082056e-24, -8.914094097815502e-26,  3.076484179723158e-27,
 -9.600241020250288e-29,  2.740062372063233e-30, -7.215348537568740e-32,  7.857763851395561e-19, -1.960435503321145e-19,  2.555722229268963e-20, -2.281647346470449e-21,
  1.562065925823681e-22, -8.727273366107357e-24,  4.138347921689593e-25, -1.710976065956312e-26,  6.289818437912258e-28, -2.086713814758777e-29,  6.320793163348783e-31,
 -1.763396785911589e-32,  9.133940055014147e-20, -2.455591082314727e-20,  3.450050999153804e-21, -3.312409764222714e-22,  2.432999427280855e-23, -1.454979414989454e-24,
  7.368583014232321e-26, -3.246995588977923e-27,  1.269740800954113e-28, -4.472900770266233e-30,  1.436165470605533e-31, -4.239920927702303e-33,  1.081903767478913e-20,
 -3.123388561449901e-21,  4.716419897862253e-22, -4.858213011853565e-23,  3.820199318162228e-24, -2.440490987826564e-25,  1.317599305826151e-26, -6.177459869799995e-28,
  2.565485315795097e-29, -9.581032081304491e-31,  3.255966845439627e-32, -1.015719560195049e-33,  1.330088298663498e-21, -4.107677731490238e-22,  6.645651030205920e-23,
 -7.323749546882442e-24,  6.149531313710851e-25, -4.186721181043637e-26,  2.404280388951420e-27, -1.196786817824545e-28,  5.267697799871144e-30, -2.081545282397087e-31,
  7.472912473455090e-33, -2.458848069559805e-34,  1.732724066686654e-22, -5.700040197148090e-23,  9.844699433058177e-24, -1.156914814823936e-24,  1.034141704307998e-25,
 -7.481730046495108e-27,  4.557545819646984e-28, -2.402340163629729e-29,  1.117880806634641e-30, -4.662671805479442e-32,  1.764257063859143e-33, -6.108949363197308e-35,
  2.446997573326018e-23, -8.534103035521111e-24,  1.566917696589163e-24, -1.955970616203974e-25,  1.854486896724826e-26, -1.420783347032176e-27,  9.150271070409506e-29,
 -5.091269939711951e-30,  2.496959736303786e-31, -1.096067753946912e-32,  4.358524033699091e-34, -1.583774356469887e-35,  3.838196220524387e-24, -1.411687949499932e-24,
  2.742113829941588e-25, -3.619389155936525e-26,  3.624032014836200e-27, -2.928005836671985e-28,  1.985727193507581e-29, -1.161789892998520e-30,  5.983024210952143e-32,
 -2.754021112953921e-33,  1.146897735654409e-34, -4.358628021272727e-36,  6.852502558520606e-25, -2.642494647224002e-25,  5.400035819413020e-26, -7.496569963855224e-27,
  7.886600293366957e-28, -6.686573611101868e-29,  4.752540588890520e-30, -2.910389039442172e-31,  1.566808870960435e-32, -7.530175035173178e-34,  3.270343644278934e-35,
 -1.294540650165852e-36,  1.424155179537211e-25, -5.721283833514825e-26,  1.222223247919993e-26, -1.773598901705911e-27,  1.948784534066283e-28, -1.723878212076480e-29,
  1.276961750554302e-30, -8.140843054994157e-32,  4.557484011152175e-33, -2.275314297523389e-34,  1.025432446090737e-35, -4.207589469952580e-37,  3.501488215226388e-26,
 -1.455254290680096e-26,  3.226754078190862e-27, -4.860307396285706e-28,  5.539738413288605e-29, -5.079048979324616e-30,  3.895904309115390e-31, -2.569522977645341e-32,
  1.486835713304655e-33, -7.665566072674023e-35,  3.564474497917028e-36, -1.507665928905986e-37,  1.018782404511323e-26, -4.347903827982490e-27,  9.927629658896921e-28,
 -1.540055106416760e-28,  1.806980704388186e-29, -1.704346291701661e-30,  1.343963331397736e-31, -9.105855200837203e-33,  5.408877722861713e-34, -2.860596968555878e-35,
  1.363565059913126e-36, -5.907894953809242e-38,  3.359516476348966e-27, -1.460727446117854e-27,  3.405315860137032e-28, -5.394225910435323e-29,  6.460914432096621e-30,
 -6.218014993342230e-31,  5.000567913832680e-32, -3.453574377603884e-33,  2.090016684886349e-34, -1.125577523643254e-35,  5.460810909925685e-37, -2.406840901991798e-38,
  9.949279871670131e-28, -4.371475622539994e-28,  1.031114454180623e-28, -1.652760023549632e-29,  2.002783269667695e-30, -1.949589517974993e-31,  1.585409589971940e-32,
 -1.106870728036191e-33,  6.769533811636095e-35, -3.683341208195167e-36,  1.804929908802381e-37, -8.032618254963256e-39,  5.269310807000110e-02, -1.139453601986693e-04,
  2.536250441507672e-07, -5.790301161879884e-10,  1.349002872767279e-12, -3.193700104780912e-15,  7.639948377666984e-18, -1.843879214675178e-20,  4.459448542996046e-23,
 -1.085936180893081e-25,  2.625697515864782e-28, -6.438993731527101e-31,  4.846548795522364e-02, -1.217767296834532e-04,  3.625770951260755e-07, -1.148412490654935e-09,
  3.663380215918402e-12, -1.155540636177777e-14,  3.588626963850756e-17, -1.098174565751224e-19,  3.315129435870078e-22, -9.894754123025766e-25,  2.921171866598785e-27,
 -8.551793610805947e-30,  4.100057112104511e-02, -1.317986779729235e-04,  5.409068113911683e-07, -2.212289544917260e-09,  8.687715260345767e-12, -3.290762544898376e-14,
  1.210983344422578e-16, -4.352310227627150e-19,  1.533181548074950e-21, -5.307840665093451e-24,  1.809407756110519e-26, -6.083783861239531e-29,  3.190256699240193e-02,
 -1.362600073123132e-04,  7.244137952317983e-07, -3.579508473240193e-09,  1.658070592052406e-11, -7.327419836890812e-14,  3.121058758523564e-16, -1.289460433380043e-18,
  5.190551213121644e-21, -2.042577040470407e-23,  7.878810723266531e-26, -2.985204721161952e-28,  2.283181173450047e-02, -1.298410307043694e-04,  8.489505213860599e-07,
 -4.930041908601150e-09,  2.649647301013022e-11, -1.346382587887506e-13,  6.542780749132392e-16, -3.063735164153572e-18,  1.390063602917456e-20, -6.136581854875349e-23,
  2.644557059182909e-25, -1.115420643974106e-27,  1.502922279361873e-02, -1.122342213205504e-04,  8.747229580967692e-07, -5.892422477805502e-09,  3.634935090970011e-11,
 -2.100671007848952e-13,  1.152316012791345e-15, -6.053970966119193e-18,  3.066248093402201e-20, -1.504565542888492e-22,  7.179904269092663e-25, -3.342305705341192e-27,
  9.099543584528821e-03, -8.755028341172668e-05,  7.989474723924089e-07, -6.190227744936098e-09,  4.345050846168588e-11, -2.831561217707359e-13,  1.739254468787290e-15,
 -1.017443526519590e-17,  5.711064491717471e-20, -3.093281543020143e-22,  1.623708196007617e-24, -8.288479945070403e-27,  5.067574515254577e-03, -6.160685333258208e-05,
  6.512700779255500e-07, -5.764194240961125e-09,  4.570815969832679e-11, -3.336295446157714e-13,  2.280297888981783e-15, -1.476498911048144e-17,  9.133068977588831e-20,
 -5.430707834790605e-22,  3.119272463634162e-24, -1.737255540143053e-26,  2.595947414457301e-03, -3.916168230827299e-05,  4.761960885354391e-07, -4.785926989875959e-09,
  4.262019252895992e-11, -3.465478286488353e-13,  2.622258161923725e-15, -1.870362757678206e-17,  1.269109156404854e-19, -8.248431900161374e-22,  5.162304107728030e-24,
 -3.124111348352450e-26,  1.223304872463788e-03, -2.253326057188585e-05,  3.134947680933959e-07, -3.559069635719435e-09,  3.541949790355703e-11, -3.193879814172599e-13,
  2.664382454539974e-15, -2.085145124377578e-17,  1.546185652231925e-19, -1.094456365889865e-21,  7.437670268512681e-24, -4.874550911486993e-26,  5.303443922860159e-04,
 -1.176011177240240e-05,  1.863670281661611e-07, -2.379028733389065e-09,  2.634889859887441e-11, -2.625001386155359e-13,  2.405728128803025e-15, -2.058900507164879e-17,
  1.663194825324195e-19, -1.278301255183412e-21,  9.405392834238066e-24, -6.656892011575083e-26,  2.115557478452217e-04, -5.577806024171364e-06,  1.002862079902124e-07,
 -1.433631579220980e-09,  1.760839059873923e-11, -1.931886740868652e-13,  1.939279688314647e-15, -1.809912532996755e-17,  1.588504524125121e-19, -1.322279722944946e-21,
  1.050768146465998e-23, -8.012531544208756e-26,  7.766352737705846e-05, -2.408501534016012e-06,  4.894780758377977e-08, -7.808093706869086e-10,  1.060266866926489e-11,
 -1.277523220579869e-13,  1.401058596093451e-15, -1.422517022155239e-17,  1.353386151516556e-19, -1.217464756711076e-21,  1.042731188118138e-23, -8.549247369284361e-26,
  2.624493346489717e-05, -9.483375604849349e-07,  2.170869618986576e-08, -3.851996742647297e-10,  5.767378450376520e-12, -7.613376405495164e-14,  9.101878020423056e-16,
 -1.003267060306619e-17,  1.032675212399878e-19, -1.002046013672458e-21,  9.233337167607748e-24, -8.125635549817244e-26,  8.166887720724781e-06, -3.410067049760311e-07,
  8.763368453879961e-09, -1.724784774833561e-10,  2.840662573652186e-12, -4.099654702037703e-14,  5.332485687981763e-16, -6.369719664086351e-18,  7.081352013079461e-20,
 -7.399989884000093e-22,  7.324680771180710e-24, -6.908543148856660e-26,  2.341217493526260e-06, -1.121421539870224e-07,  3.225091351273722e-09, -7.022812840217519e-11,
  1.269611259536284e-12, -1.999491848214506e-14,  2.824869099986710e-16, -3.651036592663926e-18,  4.377483878934186e-20, -4.919572370601603e-22,  5.223903443798618e-24,
 -5.273968448522718e-26,  6.186532787009017e-07, -3.377496815676326e-08,  1.083766403148425e-09, -2.604993401049290e-11,  5.159638971640032e-13, -8.852667376712636e-15,
  1.356456456077019e-16, -1.894346627770800e-18,  2.446402105691381e-20, -2.953224821250465e-22,  3.360292088333580e-24, -3.627322082030667e-26,  1.507949926014486e-07,
 -9.329732327658641e-09,  3.330852778289062e-10, -8.818865444335908e-12,  1.910459731380371e-13, -3.565842239090704e-15,  5.918066739815744e-17, -8.919729162026042e-19,
  1.239365634832970e-20, -1.605394709980724e-22,  1.955444563714110e-24, -2.254807201706120e-26,  3.393566232389311e-08, -2.367318020429606e-09,  9.378659028237051e-11,
 -2.729886007674929e-12,  6.458201378189777e-14, -1.309592477935175e-15,  2.351464294582567e-17, -3.820977897205404e-19,  5.706672764245059e-21, -7.924778945774912e-23,
  1.032435923490521e-24, -1.270653163808771e-26,  7.059128060075215e-09, -5.526922471857476e-10,  2.423762593002060e-11, -7.742233340571735e-13,  1.997399476819551e-14,
 -4.395201120700784e-16,  8.529431867150551e-18, -1.492867897434166e-19,  2.394556364827230e-21, -3.562141170432352e-23,  4.959970812327416e-25, -6.510847955751203e-27,
  1.359212819436416e-09, -1.189496558458194e-10,  5.760841613560733e-12, -2.016126602233878e-13,  5.664866066867906e-15, -1.351235638123005e-16,  2.831484633847135e-18,
 -5.333695015751632e-20,  9.181366065686150e-22, -1.462109303355993e-23,  2.174518557880471e-25, -3.042656293740076e-27,  2.426766090096253e-10, -2.364975400707011e-11,
  1.262184760914740e-12, -4.832185078499524e-14,  1.476979022110913e-15, -3.815255254895512e-17,  8.625644245257401e-19, -1.747451614866723e-20,  3.226104323235357e-22,
 -5.496416465734047e-24,  8.726461660301743e-26, -1.300864053257723e-27,  4.026344548583787e-11, -4.354661130432912e-12,  2.555876385403732e-13, -1.068870077419341e-14,
  3.550072505397331e-16, -9.922223135598021e-18,  2.418454918104169e-19, -5.265874737682468e-21,  1.042049054936125e-22, -1.898415143451097e-24,  3.215993972093200e-26,
 -5.105225288010631e-28,  6.224250090261447e-12, -7.447582982964658e-13,  4.797959703124210e-14, -2.188855700440892e-15,  7.891564684021204e-17, -2.384510055228101e-18,
  6.261687330912106e-20, -1.464492853718505e-21,  3.104732380842237e-23, -6.045416233296994e-25,  1.092268772623746e-26, -1.845695612910009e-28,  8.994177222176364e-13,
 -1.187164840415678e-13,  8.379483158060573e-15, -4.164777539136548e-16,  1.628341338098398e-17, -5.315044941948186e-19,  1.502736404306384e-20, -3.773150721204835e-22,
  8.565495419198813e-24, -1.781835687562213e-25,  3.432263155063450e-27, -6.171389563145493e-29,  1.219676749129414e-13, -1.771033564623584e-14,  1.367225078419926e-15,
 -7.394113618702535e-17,  3.132093484049151e-18, -1.103554624576884e-19,  3.357250393092069e-21, -9.044865889400788e-23,  2.197673814989040e-24, -4.882189786163057e-26,
  1.002250686421081e-27, -1.916902191138275e-29,  1.559598007625779e-14, -2.484803071473732e-15,  2.094477837511658e-16, -1.231005072921642e-17,  5.644095990274290e-19,
 -2.144987456776007e-20,  7.017131221012364e-22, -2.027434413410871e-23,  5.270139488097895e-25, -1.249778294688659e-26,  2.733270845076661e-28, -5.558744120795071e-30,
  1.891368363660521e-15, -3.297990911472955e-16,  3.030229903329050e-17, -1.933131148394480e-18,  9.584406508153069e-20, -3.925823808576388e-21,  1.380165189399474e-22,
 -4.274135205842106e-24,  1.188033370498514e-25, -3.006157820615114e-27,  7.001296830186590e-29, -1.513498330328637e-30,  2.190596459076129e-16, -4.169998663055515e-17,
  4.169353616736671e-18, -2.883388343149926e-19,  1.544325330798449e-20, -6.812095441154083e-22,  2.571837253456648e-23, -8.531559084739557e-25,  2.534437990252909e-26,
 -6.839544979540287e-28,  1.695577771292036e-29, -3.894462879155899e-31,  2.443475072247942e-17, -5.064926720945736e-18,  5.501121407443335e-19, -4.118583390325517e-20,
  2.380348255758091e-21, -1.129695137421769e-22,  4.576617327241051e-24, -1.625160683851543e-25,  5.156465401758402e-27, -1.483244409957575e-28,  3.911983647016670e-30,
 -9.541880762507281e-32,  2.651319265033490e-18, -5.968565209584257e-19,  7.028850570071868e-20, -5.688570088455611e-21,  3.543409077607186e-22, -1.807447085547798e-23,
  7.850003240601011e-25, -2.981468395172157e-26,  1.009629230685461e-27, -3.093392423804618e-29,  8.674190648024299e-31, -2.245434557959229e-32,  2.832037531007264e-19,
 -6.904494164491315e-20,  8.798336226640362e-21, -7.684641839741341e-22,  5.151761015082183e-23, -2.820898208789014e-24,  1.311995814152295e-25, -5.324317374398581e-27,
  1.922501961964458e-28, -6.268637175027807e-30,  1.867314131569031e-31, -5.125979653268329e-33,  3.020181913937371e-20, -7.950130114278301e-21,  1.093735692327556e-21,
 -1.028999404091737e-22,  7.412095807300631e-24, -4.350262595942548e-25,  2.163782249769553e-26, -9.370709270153124e-28,  3.603606941838765e-29, -1.249094917014598e-30,
  3.948484297073349e-32, -1.148241515732865e-33,  3.269084250822790e-21, -9.260354717371126e-22,  1.371870370594926e-22, -1.387171492554342e-23,  1.071489592918218e-24,
 -6.728513040032322e-26,  3.573078739674388e-27, -1.648722064707734e-28,  6.742642359076951e-30, -2.480993477814310e-31,  8.311163451069915e-33, -2.557031599317175e-34,
  3.660746749913420e-22, -1.111780229291138e-22,  1.768289319713138e-23, -1.916635257876592e-24,  1.583749787149236e-25, -1.061716878539722e-26,  6.006929126887050e-28,
 -2.947455257393718e-29,  1.279475158669669e-30, -4.988646042398920e-32,  1.767934884144945e-33, -5.744860002440668e-35,  4.334246551218285e-23, -1.405399596045498e-23,
  2.391474536746178e-24, -2.769821217598809e-25,  2.441298891252511e-26, -1.742390436115034e-27,  1.047573239743976e-28, -5.452510101381065e-30,  2.506427174993810e-31,
 -1.033168869837314e-32,  3.864961359545245e-34, -1.323629359312345e-35,  5.558978632948531e-24, -1.915480682554790e-24,  3.472913435090742e-25, -4.281925912107682e-26,
  4.011355205549730e-27, -3.037800691833139e-28,  1.934646963534470e-29, -1.064870696632179e-30,  5.168265634505044e-32, -2.245873823754084e-33,  8.843962914965225e-35,
 -3.183509940623955e-36,  7.928637067162071e-25, -2.887893617897188e-25,  5.552109695679605e-26, -7.254416214395055e-27,  7.192452277113931e-28, -5.755878302078575e-29,
  3.867692805707134e-30, -2.242783999556838e-31,  1.145085548632214e-32, -5.227164798964300e-34,  2.159356466226465e-35, -8.142748764369585e-37,  1.291920943605391e-25,
 -4.944777276176068e-26,  1.002413999889241e-26, -1.380598557203979e-27,  1.441246477289534e-28, -1.212826463693245e-29,  8.558012455569393e-31, -5.204200694509131e-32,
  2.782759315382202e-33, -1.328673598725854e-34,  5.733942099502747e-36, -2.255888449551827e-37,  2.466857262720417e-26, -9.856635876022264e-27,  2.093339319888400e-27,
 -3.020058187114830e-28,  3.299552713079061e-29, -2.902697692185377e-30,  2.138713485662609e-31, -1.356433876048066e-32,  7.555828925134764e-34, -3.754022352525749e-35,
  1.683949922898858e-36, -6.878480630427918e-38,  5.627995553037696e-27, -2.330678900582981e-27,  5.147596922085753e-28, -7.723295554396658e-29,  8.769317507705496e-30,
 -8.010198572638551e-31,  6.122133954598639e-32, -4.023742063507761e-33,  2.320449695043728e-34, -1.192427567853854e-35,  5.527227680807100e-37, -2.330710540386474e-38,
  1.539886803844390e-27, -6.558116474486200e-28,  1.493967029351435e-28, -2.312210640377002e-29,  2.706825505065822e-30, -2.547453532800233e-31,  2.004497387147982e-32,
 -1.355303941503717e-33,  8.034315060298404e-35, -4.240833721190637e-36,  2.017667574543395e-37, -8.725961673998457e-39,  4.854679103843956e-28, -2.108713066875258e-28,
  4.910436822301200e-29, -7.769693953485458e-30,  9.295846098293313e-31, -8.936721012194341e-32,  7.179425440425650e-33, -4.953313123176165e-34,  2.994648978275903e-35,
 -1.611213590670990e-36,  7.809592556027685e-38, -3.438942512449437e-39,  1.400961331530448e-28, -6.153164106976903e-29,  1.450749032377477e-29, -2.324383074939072e-30,
  2.815438238323646e-31, -2.739506786867681e-32,  2.226851926697536e-33, -1.554071921155867e-34,  9.500819323686712e-36, -5.167447121629199e-37,  2.531219845954529e-38,
 -1.126071919956596e-39,  5.224134113532142e-02, -1.119437911528172e-04,  2.468041109886242e-07, -5.579472724295149e-10,  1.286921457414398e-12, -3.016379065354242e-15,
  7.143066955502798e-18, -1.707234564430132e-20,  4.086753004039731e-23, -9.863644239446738e-26,  2.357927391964323e-28, -5.747226534284825e-31,  4.798409637462027e-02,
 -1.189302575478708e-04,  3.491403519487903e-07, -1.091601500831540e-09,  3.440641785926832e-12, -1.072986793054682e-14,  3.295470023136795e-17, -9.975714434050659e-20,
  2.979074833278294e-22, -8.798166979265705e-25,  2.569812730374944e-27, -7.446267710357649e-30,  4.048186605553379e-02, -1.275752993352183e-04,  5.151721389177642e-07,
 -2.078397454465246e-09,  8.057667168315299e-12, -3.014213075400665e-14,  1.095709714946951e-16, -3.890919132461765e-19,  1.354506997907207e-21, -4.634879977172058e-24,
  1.561886763501560e-26, -5.192124733851846e-29,  3.136885176464008e-02, -1.306321121973877e-04,  6.830043659384511e-07, -3.325546010668355e-09,  1.518729706208631e-11,
 -6.619880533677995e-14,  2.782199985777900e-16, -1.134544575239853e-18,  4.508923152072172e-21, -1.752195064873337e-23,  6.675699260674275e-26, -2.498713331211957e-28,
  2.232566604848084e-02, -1.232790607525648e-04,  7.922475047390378e-07, -4.526815571118151e-09,  2.395403739229206e-11, -1.199167058937788e-13,  5.744028816550566e-16,
 -2.652312159205425e-18,  1.187061554642192e-20, -5.170730562856060e-23,  2.199236449678317e-25, -9.156788691289962e-28,  1.459384720069207e-02, -1.055096967290854e-04,
  8.073694963367944e-07, -5.342996680524230e-09,  3.241138681296887e-11, -1.843395886995004e-13,  9.957652595221953e-16, -5.154166952877287e-18,  2.572942412950242e-20,
 -1.244752333908285e-22,  5.858212370305982e-25, -2.690151493203925e-27,  8.761671288674385e-03, -8.144443215462337e-05,  7.286561958436186e-07, -5.538149873948438e-09,
  3.818275667687097e-11, -2.446359710526095e-13,  1.478367168678741e-15, -8.513212544532441e-18,  4.706105451498900e-20, -2.511261732630236e-22,  1.299129676673160e-24,
 -6.537589794257416e-27,  4.831146251260725e-03, -5.666142988602957e-05,  5.862767965917398e-07, -5.083405748745642e-09,  3.955098645465263e-11, -2.835504192150187e-13,
  1.905018644090880e-15, -1.213255424405303e-17,  7.385325548660339e-20, -4.323454584009860e-22,  2.445746774308911e-24, -1.341986121956496e-26,  2.446571790807034e-03,
 -3.557075079171914e-05,  4.226383906081887e-07, -4.156202277474866e-09,  3.627841834982838e-11, -2.894652183282769e-13,  2.151217918054405e-15, -1.508027624539016e-17,
  1.006243717419348e-19, -6.434347937779200e-22,  3.963560002483772e-24, -2.361756531670411e-26,  1.137930245486551e-03, -2.018696750953692e-05,  2.739861433954673e-07,
 -3.040174285395139e-09,  2.962664115074183e-11, -2.619242417883947e-13,  2.144274034954870e-15, -1.648059283024826e-17,  1.200936700916256e-19, -8.358082153966757e-22,
  5.587165902624574e-24, -3.603370394809511e-26,  4.861146279277017e-04, -1.037658157572946e-05,  1.601845786818284e-07, -1.996495015902088e-09,  2.163251146966855e-11,
 -2.111192185068045e-13,  1.897315234493064e-15, -1.593583982177994e-17,  1.264212631632570e-19, -9.547596340689654e-22,  6.906128801872836e-24, -4.807440385347732e-26,
  1.907465412489709e-04, -4.839819226355461e-06,  8.465327443803365e-08, -1.180441202391686e-09,  1.417178741328141e-11, -1.521941105536674e-13,  1.497053721634144e-15,
 -1.370285298286813e-17,  1.180346192561955e-19, -9.648857676945841e-22,  7.533897152713921e-24, -5.647347407738283e-26,  6.875717423214483e-05, -2.051696949320247e-06,
  4.051720295925453e-08, -6.299071738912781e-10,  8.353980884457058e-12, -9.845498044875889e-14,  1.057330554136711e-15, -1.052192023595749e-17,  9.819111912499611e-20,
 -8.669627840109846e-22,  7.292111612817978e-24, -5.874362977860801e-26,  2.277171845419075e-05, -7.916973089113858e-07,  1.759331909803394e-08, -3.040053324215089e-10,
  4.442191316564189e-12, -5.731776539349288e-14,  6.705841777821295e-16, -7.240460158552716e-18,  7.306137393082328e-20, -6.954760763035235e-22,  6.290436236041346e-24,
 -5.436690689793225e-26,  6.930980433945675e-06, -2.784641444993660e-07,  6.941369802869101e-09, -1.329482970777482e-10,  2.135490588620754e-12, -3.010547719671259e-14,
  3.829871385697029e-16, -4.478836771867863e-18,  4.878813435303901e-20, -4.999105618253680e-22,  4.854929385294003e-24, -4.495243629761311e-26,  1.939363279603820e-06,
 -8.939519980805921e-08,  2.492144524198236e-09, -5.277727858735109e-11,  9.299827295588331e-13, -1.429871868770629e-14,  1.974697437633744e-16, -2.497422822735019e-18,
  2.932584429474655e-20, -3.230175650896121e-22,  3.363940581736272e-24, -3.332695265566358e-26,  4.990956085840400e-07, -2.622728192988822e-08,  8.153842341269807e-10,
 -1.905061644054999e-11,  3.675877681824833e-13, -6.154178443144829e-15,  9.213384394070057e-17, -1.258494360634975e-18,  1.591059481749412e-20, -1.881723462690699e-22,
  2.099080808703017e-24, -2.222755487914659e-26,  1.182019934778870e-07, -7.041348949185761e-09,  2.434744288884915e-10, -6.263241790191703e-12,  1.321202668304946e-13,
 -2.405238584329489e-15,  3.898628109039746e-17, -5.745002192044487e-19,  7.811648162158194e-21, -9.909994136757855e-23,  1.183005778416136e-24, -1.337735591946370e-26,
  2.578191001508209e-08, -1.732301544238778e-09,  6.645371250179398e-11, -1.878742968927630e-12,  4.326349760199607e-14, -8.553666444512642e-16,  1.499466342983432e-17,
 -2.381401492314275e-19,  3.479419105681278e-21, -4.730731805787108e-23,  6.038528674713109e-25, -7.286176786434792e-27,  5.184192447134295e-09, -3.911233145198270e-10,
  1.660685562523677e-11, -5.151196193167819e-13,  1.293225232218927e-14, -2.773761132247580e-16,  5.253741728407265e-18, -8.984834367495945e-20,  1.409501190315581e-21,
 -2.052396620415056e-23,  2.799336857619607e-25, -3.601838560696628e-27,  9.621970298347157e-10, -8.118318483318760e-11,  3.806839364733872e-12, -1.293560417145108e-13,
  3.536276566203206e-15, -8.220141062516442e-17,  1.680849860832329e-18, -3.093090974877986e-20,  5.206390653748193e-22, -8.114036130429174e-24,  1.181868475772294e-25,
 -1.620684275555195e-27,  1.650990816807720e-10, -1.552141884033756e-11,  8.021666301061276e-13, -2.981730569746090e-14,  8.866438745930504e-16, -2.231714279197452e-17,
  4.922842098901164e-19, -9.741390534856639e-21,  1.758336904086053e-22, -2.931411060155327e-24,  4.557573014215031e-26, -6.657647783514029e-28,  2.624060784430183e-11,
 -2.739712469545866e-12,  1.557545526867098e-13, -6.324855390340893e-15,  2.043712503764433e-16, -5.565712468688685e-18,  1.323546934597029e-19, -2.814748664373185e-21,
  5.445535076389732e-23, -9.707185482714733e-25,  1.610253079665209e-26, -2.504776017066191e-28,  3.872655128929820e-12, -4.476773313840397e-13,  2.794620792218444e-14,
 -1.238227489364549e-15,  4.343673695709812e-17, -1.278954267360690e-18,  3.276856383580516e-20, -7.485746238340888e-22,  1.551551585107169e-23, -2.956159778672414e-25,
  5.230200136602559e-27, -8.660362312100868e-29,  5.322999457112866e-13, -6.793884565217461e-14,  4.649018437838387e-15, -2.244905281156293e-16,  8.542129870843897e-18,
 -2.717494712562384e-19,  7.497544841322199e-21, -1.838981766985093e-22,  4.081969181755144e-24, -8.309814230089923e-26,  1.567605569176761e-27, -2.762308278224387e-29,
  6.839521014005522e-14, -9.612836858927290e-15,  7.199097985195113e-16, -3.784313298197125e-17,  1.560655311843984e-18, -5.360886103808790e-20,  1.591888581280784e-21,
 -4.190521554041166e-23,  9.957846839829509e-25, -2.165262639417613e-26,  4.354005886475106e-28, -8.162599100696399e-30,  8.252582947439894e-15, -1.274078184362187e-15,
  1.042624895351219e-16, -5.959836897264081e-18,  2.661666303354944e-19, -9.865925181980242e-21,  3.151532963233057e-22, -8.900100546644089e-24,  2.263316575553792e-25,
 -5.255107905258203e-27,  1.126094419983114e-28, -2.245476422460200e-30,  9.402869383459846e-16, -1.590739388566719e-16,  1.420266509497763e-17, -8.818588995963303e-19,
  4.261489531601013e-20, -1.703422051753787e-21,  5.850463533807157e-23, -1.771720663424902e-24,  4.819926172162771e-26, -1.194619072786481e-27,  2.727175846870087e-29,
 -5.782625612781049e-31,  1.018529009996727e-16, -1.883692418587874e-17,  1.832098660777955e-18, -1.234280167284652e-19,  6.448310717971904e-21, -2.777709895360192e-22,
  1.025170094053115e-23, -3.327577635948806e-25,  9.680353219661103e-27, -2.560214112289166e-28,  6.224556670252399e-30, -1.403023108045845e-31,  1.057525130280406e-17,
 -2.132945188354732e-18,  2.256282985770525e-19, -1.647316748023759e-20,  9.295504254312703e-22, -4.311845091296038e-23,  1.708975421952024e-24, -5.942328264016009e-26,
  1.847681427598883e-27, -5.212170250447737e-29,  1.349039957898847e-30, -3.231171565874179e-32,  1.062954150878079e-18, -2.332236909803969e-19,  2.678701406695981e-20,
 -2.116701218738715e-21,  1.288724537348369e-22, -6.431543131466069e-24,  2.735398961921716e-25, -1.018212893107560e-26,  3.381849339956381e-28, -1.016978447677835e-29,
  2.800708296838440e-31, -7.124709624606902e-33,  1.046682526975966e-19, -2.491677472016427e-20,  3.101513222115329e-21, -2.648615632160651e-22,  1.737754756908150e-23,
 -9.320666346369095e-25,  4.249892254130347e-26, -1.692099886739823e-27,  5.998608375072616e-29, -1.921590713907231e-30,  5.626930186513528e-32, -1.519323278116917e-33,
  1.024153802680762e-20, -2.637611746384079e-21,  3.550698300481507e-22, -3.271317765573004e-23,  2.309508427865560e-24, -1.329578638441014e-25,  6.491698096895768e-27,
 -2.761636172022114e-28,  1.043907918600545e-29, -3.558877928478301e-31,  1.107096801907740e-32, -3.170031308507678e-34,  1.012686486364063e-21, -2.812580758450301e-22,
  4.084904137388593e-23, -4.051981228027103e-24,  3.072616965539906e-25, -1.895531312778045e-26,  9.895496974106602e-28, -4.491580525073529e-29,  1.807983777941178e-30,
 -6.551523708907343e-32,  2.162497164213370e-33, -6.558837665538303e-35,  1.032061121834382e-22, -3.080087649548709e-23,  4.812674814842045e-24, -5.127180772288151e-25,
  4.166751269681804e-26, -2.748897553122948e-27,  1.531430841971223e-28, -7.403372969235050e-30,  3.167964153881769e-31, -1.218182011167431e-32,  4.259705002163378e-34,
 -1.366395995530878e-35,  1.109005860313993e-23, -3.542027927818136e-24,  5.934265230165412e-25, -6.769617519043784e-26,  5.879811992980509e-27, -4.137557177601163e-28,
  2.453911763145480e-29, -1.260541590840233e-30,  5.721386961892863e-32, -2.329656128301714e-33,  8.612289101417030e-35, -2.915886901121877e-36,  1.289206726359232e-24,
 -4.386176007190298e-25,  7.847995220050781e-26, -9.551566108377712e-27,  8.836326682941805e-28, -6.611056921511094e-29,  4.161289087716371e-30, -2.264720435830240e-31,
  1.087234488043515e-32, -4.675040410972679e-34,  1.822307109842692e-35, -6.495449361170512e-37,  1.667684471777303e-25, -6.012102405527166e-26,  1.143384295529907e-26,
 -1.478086327645916e-27,  1.450344601562568e-28, -1.149079069182009e-29,  7.646841655164244e-31, -4.392918848689257e-32,  2.222683154584651e-33, -1.005800863691690e-34,
  4.120051458091905e-36, -1.541025297481636e-37,  2.472464026814531e-26, -9.388334459197417e-27,  1.887141514940224e-27, -2.577408416068704e-28,  2.668762685801084e-29,
 -2.228114100638226e-30,  1.560242385145333e-31, -9.418135406298962e-33,  5.000184608210970e-34, -2.371001318011111e-35,  1.016410585288041e-36, -3.973171506589011e-38,
  4.322772201498616e-27, -1.717293617950986e-27,  3.624531025517308e-28, -5.196904132041153e-29,  5.643752668697155e-30, -4.936020219141705e-31,  3.616358186789899e-32,
 -2.281087475171888e-33,  1.263946112733533e-34, -6.247731757207051e-36,  2.788732298192451e-37, -1.133698415185061e-38,  9.119841911819776e-28, -3.762310339545220e-28,
  8.274872691573161e-29, -1.236377911560857e-29,  1.398128978432470e-30, -1.272062307333625e-31,  9.685119776753109e-33, -6.341949133166545e-34,  3.644244503363522e-35,
 -1.866211133870567e-36,  8.621413213789041e-38, -3.623702711603807e-39,  2.339128742166898e-28, -9.939737531414039e-29,  2.258742204235710e-29, -3.487250935268416e-30,
  4.072566369106674e-31, -3.823795909359737e-32,  3.001959292865465e-33, -2.025244526055974e-34,  1.198012090472565e-35, -6.310510341058440e-37,  2.996347173664022e-38,
 -1.293346252741171e-39,  7.032555239080632e-29, -3.051451464309988e-29,  7.097291142632862e-30, -1.121651099266819e-30,  1.340396035132349e-31, -1.287138020296451e-32,
  1.032886995123021e-33, -7.118505858894126e-35,  4.299149551471103e-36, -2.310716348361455e-37,  1.118901198594812e-38, -4.922342804100389e-40,  1.974554867290743e-29,
 -8.669003894980347e-30,  2.043001838711054e-30, -3.271805298417188e-31,  3.961237505416838e-32, -3.852704044989715e-33,  3.130377991400324e-34, -2.183698606645098e-35,
  1.334451482134663e-36, -7.255074643092910e-38,  3.552415232953249e-39, -1.579764330727810e-40,  5.179747292070154e-02, -1.099957942165247e-04,  2.402303271037374e-07,
 -5.378299951134735e-10,  1.228270242139122e-12, -2.850537206736019e-15,  6.682828807538468e-18, -1.581962730133066e-20,  3.748046354100511e-23, -8.969204140378159e-26,
  2.118693295119319e-28, -5.140183265250782e-31,  4.751387992839573e-02, -1.161886117845991e-04,  3.363644904890481e-07, -1.038225968871803e-09,  3.233732751804709e-12,
 -9.971424864507766e-15,  3.029033899189285e-17, -9.071166358867524e-20,  2.680080531594622e-22, -7.832861467174725e-25,  2.263653074723684e-27, -6.493296537403653e-30,
  3.997965268909576e-02, -1.235515385220131e-04,  4.909854646206680e-07, -1.954158258115215e-09,  7.480263800071522e-12, -2.763841439543939e-14,  9.925896755997012e-17,
 -3.483011310561328e-19,  1.198367521369990e-21, -4.053507042643630e-24,  1.350460517148405e-26, -4.439004265974254e-29,  3.085700434637357e-02, -1.253236708511528e-04,
  6.445132494965699e-07, -3.092788782470144e-09,  1.392760246276966e-11, -5.988699302525090e-14,  2.483814727141125e-16, -9.998570653890962e-19,  3.923662299425979e-21,
 -1.505915088891515e-23,  5.667617672510566e-26, -2.095936356740500e-28,  2.184489069158111e-02, -1.171520298932443e-04,  7.401485195473535e-07, -4.162013123630243e-09,
  2.168775927624990e-11, -1.069809506594279e-13,  5.051880002395243e-16, -2.300613814779078e-18,  1.015824898373354e-20, -4.366598913104695e-23,  1.833219763270058e-25,
 -7.535755862669447e-28,  1.418433234486306e-02, -9.929866069888241e-05,  7.462474411351014e-07, -4.852657793109407e-09,  2.895235288259947e-11, -1.620839693721705e-13,
  8.623326580286087e-16, -4.398222275697973e-18,  2.164306493527329e-20, -1.032484349896370e-22,  4.792930627547830e-25, -2.171479198130781e-27,  8.447145347027955e-03,
 -7.587098778425232e-05,  6.657085125771252e-07, -4.964517819444964e-09,  3.362638270168738e-11, -2.118534339843397e-13,  1.259789848727070e-15, -7.142414843229800e-18,
  3.889048704818465e-20, -2.044878637713064e-22,  1.042710333071494e-24, -5.173548552964049e-27,  4.613509260622606e-03, -5.220487653277868e-05,  5.288934214135267e-07,
 -4.493584763323834e-09,  3.431098742287214e-11, -2.416531906243290e-13,  1.596181740393581e-15, -1.000049701105324e-17,  5.991618049513792e-20, -3.453784668073845e-22,
  1.924532866344398e-24, -1.040522409171382e-26,  2.310748503460458e-03, -3.237969609548251e-05,  3.760643540536430e-07, -3.619394112403643e-09,  3.097299768866198e-11,
 -2.425594609056254e-13,  1.770774557436597e-15, -1.220223885537383e-17,  8.008061020495753e-20, -5.038806801339624e-22,  3.055516107682477e-24, -1.792940228021400e-26,
  1.061345974201372e-03, -1.813332898863682e-05,  2.401839863019815e-07, -2.605409196258000e-09,  2.486753580865556e-11, -2.155912190731127e-13,  1.732386453562397e-15,
 -1.307880887075938e-17,  9.367240773926821e-20, -6.410898095370260e-22,  4.216172160717121e-24, -2.676213609117991e-26,  4.470274244319289e-04, -9.185358212222211e-06,
  1.381716395915924e-07, -1.681823681809115e-09,  1.783157468769202e-11, -1.705109063744863e-13,  1.502938712866349e-15, -1.239086502955368e-17,  9.655141343763705e-20,
 -7.166176105990202e-22,  5.096747404574259e-24, -3.489975775387642e-26,  1.726571553949421e-04, -4.215618752231060e-06,  7.175400823193149e-08, -9.762146672540859e-10,
  1.145819685947773e-11, -1.204722974770524e-13,  1.161419507143456e-15, -1.042789358932220e-17,  8.817311497520072e-20, -7.079533143795844e-22,  5.432202722555752e-24,
 -4.003384936831538e-26,  6.115381006878595e-05, -1.755663753647459e-06,  3.369952582802394e-08, -5.107116488412779e-10,  6.616496458467184e-12, -7.628629766994773e-14,
  8.023882670923466e-16, -7.827575220924581e-18,  7.166205441288215e-20, -6.211259919065624e-22,  5.131391360246005e-24, -4.062164783241817e-26,  1.986491561655808e-05,
 -6.644165017478718e-07,  1.433653078707821e-08, -2.412911282521244e-10,  3.441628017430530e-12, -4.341385711445850e-14,  4.971397594694321e-16, -5.258851756293148e-18,
  5.203026466114201e-20, -4.859446233421258e-22,  4.314952490199762e-24, -3.663073041089285e-26,  5.918845242875847e-06, -2.287765660528875e-07,  5.532636154694444e-09,
 -1.031375738736751e-10,  1.615985732142674e-12, -2.225763608686430e-14,  2.769776362303031e-16, -3.171640841601523e-18,  3.385720002206602e-20, -3.402158083874600e-22,
  3.242184315500716e-24, -2.947390135554534e-26,  1.617976150488955e-06, -7.175856951433090e-08,  1.939431827828302e-09, -3.994984602342418e-11,  6.862425510245840e-13,
 -1.030241942881602e-14,  1.391014736070263e-16, -1.721706056137534e-18,  1.980283002925378e-20, -2.138124635614506e-22,  2.184059999683556e-24, -2.123583875011911e-26,
  4.059145179138027e-07, -2.052728310603481e-08,  6.183622698058443e-10, -1.404475878142314e-11,  2.640347991870491e-13, -4.314011673726508e-15,  6.311087947155442e-17,
 -8.432761828852086e-19,  1.043818451731170e-20, -1.209612758114050e-22,  1.323006078676099e-24, -1.374437640076064e-26,  9.350248150103589e-08, -5.361603308937754e-09,
  1.795624870084523e-10, -4.488317854095583e-12,  9.220233508645833e-14, -1.637349346719171e-15,  2.592256198273125e-17, -3.735161958418686e-19,  4.970637104819036e-21,
 -6.176396239734114e-23,  7.226713513059696e-25, -8.014648112681366e-27,  1.978822511781458e-08, -1.280267359348353e-09,  4.755519762313541e-11, -1.305891997956288e-12,
  2.927368826325845e-14, -5.643495127046071e-16,  9.659415234894620e-18, -1.499488447259521e-19,  2.143478973186405e-21, -2.853603899445867e-23,  3.569091843637212e-25,
 -4.222444703252947e-27,  3.850721211430535e-09, -2.798576429914575e-10,  1.150390593301050e-11, -3.465045820061102e-13,  8.465554223761699e-15, -1.769910863161871e-16,
  3.272148234336549e-18, -5.468140277343389e-20,  8.390203015068818e-22, -1.195924368682766e-23,  1.597896073206583e-25, -2.015358974874617e-27,  6.897521659835853e-10,
 -5.608773413044306e-11,  2.546166409286301e-12, -8.399976736203347e-14,  2.234193934271451e-15, -5.061160551165915e-17,  1.009894257667991e-18, -1.815523399147397e-20,
  2.988303151650877e-22, -4.557922087153779e-24,  6.502232763841312e-26, -8.738669997546539e-28,  1.138824477550452e-10, -1.032431871206115e-11,  5.165985160823222e-13,
 -1.864224258415220e-14,  5.392695756949790e-16, -1.322583315235153e-17,  2.846451685769267e-19, -5.501718099873972e-21,  9.709297175159184e-23, -1.583936126267477e-24,
  2.411545736844544e-26, -3.452064171799844e-28,  1.736173253572276e-11, -1.749138662715267e-12,  9.629611314396945e-14, -3.796466389641014e-15,  1.193335359823813e-16,
 -3.166371987735233e-18,  7.345937194002938e-20, -1.525799561844020e-21,  2.885807578845098e-23, -5.033357450268380e-25,  8.175695494773031e-27, -1.246133759329491e-28,
  2.449407503289938e-12, -2.734258692384255e-13,  1.653441855656873e-14, -7.113723204866968e-16,  2.427728443946865e-17, -6.964809907744694e-19,  1.740927162652769e-20,
 -3.884232210595535e-22,  7.870457871163609e-24, -1.467215640755043e-25,  2.541828759462037e-27, -4.124084116944266e-29,  3.206737392810990e-13, -3.955604856139219e-14,
  2.623277767404500e-15, -1.230362963288732e-16,  4.555429145513971e-18, -1.412217318729372e-19,  3.801592299680655e-21, -9.107674475040013e-23,  1.976495374982278e-24,
 -3.937131270892381e-26,  7.273057727125195e-28, -1.255875499671431e-29,  3.909305396573051e-14, -5.315275881407125e-15,  3.860053251550699e-16, -1.971656745377903e-17,
  7.914306551419294e-19, -2.649840116369537e-20,  7.678923817844939e-22, -1.974784720271873e-23,  4.588669764913926e-25, -9.764815147971039e-27,  1.923097927959633e-28,
 -3.533473352912481e-30,  4.456872568908302e-15, -6.663471346882595e-16,  5.291574155430196e-17, -2.940731195555491e-18,  1.278868725586655e-19, -4.622193398823409e-21,
  1.441378846484055e-22, -3.977804580407801e-24,  9.894247045209992e-26, -2.248869340790877e-27,  4.720904677318384e-29, -9.228404259552085e-31,  4.776985915419901e-16,
 -7.835671350758862e-17,  6.794737606404437e-18, -4.104528949644728e-19,  1.932533195946426e-20, -7.536055031954187e-22,  2.527868246780406e-23, -7.483975434344316e-25,
  1.992212909782464e-26, -4.835384053759729e-28,  1.081776191718161e-29, -2.249406867249818e-31,  4.845063534814262e-17, -8.699601533927919e-18,  8.226269699597576e-19,
 -5.396256904710855e-20,  2.748784388905738e-21, -1.155895358632670e-22,  4.168944561305299e-24, -1.323638491530218e-25,  3.769771202689267e-27, -9.768323882848235e-29,
  2.328523263624874e-30, -5.149386388906356e-32,  4.687416467558378e-18, -9.192424047240619e-19,  9.464931383823681e-20, -6.735343494461422e-21,  3.708986967526051e-22,
 -1.680855342174585e-23,  6.515123509461110e-25, -2.217455905668443e-26,  6.754488490429452e-28, -1.867994394444073e-29,  4.743200730273974e-31, -1.115266656087306e-32,
  4.368040526004091e-19, -9.333935908888532e-20,  1.044895071059849e-20, -8.057040956495913e-22,  4.792186797342906e-23, -2.338803836434830e-24,  9.736659941232668e-26,
 -3.550647406701310e-27,  1.156218365078460e-28, -3.411327952070649e-30,  9.223405335194084e-32, -2.305019559041456e-33,  3.967304324752668e-20, -9.214586546499216e-21,
  1.119628765341738e-21, -9.342753560292328e-23,  5.995679587120072e-24, -3.148464753371624e-25,  1.406715652597273e-26, -5.492557031104855e-28,  1.910888838667347e-29,
 -6.011379081985985e-31,  1.729751795704404e-32, -4.592208436628604e-34,  3.562532952495582e-21, -8.969397298240708e-22,  1.180654303122367e-22, -1.064528544569819e-23,
  7.361501397707877e-25, -4.154707101118393e-26,  1.990241289843242e-27, -8.312871746999765e-29,  3.087286596540346e-30, -1.034737232494778e-31,  3.166345597225722e-33,
 -8.923545765583872e-35,  3.217351870673332e-22, -8.754112832114265e-23,  1.245565167430253e-23, -1.211242740135272e-24,  9.011281056984983e-26, -5.458194040172934e-27,
  2.799640210664276e-28, -1.249387048721426e-29,  4.947581640809734e-31, -1.764782623803317e-32,  5.737052072415432e-34, -1.714639251298734e-35,  2.982005163041439e-23,
 -8.738527668798383e-24,  1.340411381407590e-24, -1.402635945694833e-25,  1.120374345426776e-26, -7.269534210790681e-28,  3.985642738187098e-29, -1.897311741770332e-30,
  7.999027571414081e-32, -3.032091250760813e-33,  1.045670018141030e-34, -3.309674852183245e-36,  2.904433659506536e-24, -9.130465617878646e-25,  1.505060987503022e-25,
 -1.689964556401693e-26,  1.445568191463924e-27, -1.002355047644119e-28,  5.861006568924963e-30, -2.969807203214836e-31,  1.330271971532678e-32, -5.348076498276960e-34,
  1.952894379628380e-35, -6.533885748959164e-37,  3.054390508200709e-25, -1.025362035645915e-25,  1.809351997485432e-26, -2.172403723474121e-27,  1.983480556243813e-28,
 -1.465264902612315e-29,  9.110826022541843e-31, -4.900236903834481e-32,  2.325827446970642e-33, -9.891488634568541e-35,  3.814884983705863e-36, -1.345905223383683e-37,
  3.574355836346102e-26, -1.274632158202250e-26,  2.396547318893123e-27, -3.063470255530482e-28,  2.973379820528720e-29, -2.331055972511353e-30,  1.535559240723383e-31,
 -8.735198774332595e-33,  4.378038239246057e-34, -1.963075497672037e-35,  7.970484103189885e-37, -2.955862991627710e-38,  4.806685479507390e-27, -1.809843174193109e-27,
  3.605435457307948e-28, -4.880761913822475e-29,  5.010392194712056e-30, -4.148362086273187e-31,  2.881579500303823e-32, -1.725925893823052e-33,  9.094466821002566e-35,
 -4.281221158407411e-36,  1.822450080117356e-37, -7.075909639802480e-39,  7.668106676270115e-28, -3.027651354693181e-28,  6.348061050057615e-29, -9.042474149103714e-30,
  9.757453526993503e-31, -8.481189074188095e-32,  6.176615013938936e-33, -3.873533345512621e-34,  2.134345529416175e-35, -1.049327080935787e-36,  4.659357026135031e-38,
 -1.884637376014682e-39,  1.490618788727733e-28, -6.124355755731577e-29,  1.341012538078987e-29, -1.994793819116806e-30,  2.246024209761049e-31, -2.034938432970961e-32,
  1.543055178237185e-33, -1.006446058212651e-34,  5.761332861537044e-36, -2.939534664873730e-37,  1.353166666338042e-38, -5.668066524229136e-40,  3.572032882305149e-29,
 -1.514259093868059e-29,  3.432021566269429e-30, -5.284767641633271e-31,  6.155940940665529e-32, -5.765481113379075e-33,  4.515368515397300e-34, -3.039111167719485e-35,
  1.793674519660070e-36, -9.427400052413729e-38,  4.466787134442420e-39, -1.924091010400222e-40,  1.021415022175279e-29, -4.426916335746368e-30,  1.028341802763782e-30,
 -1.623120756816878e-31,  1.937243737586284e-32, -1.858009141973996e-33,  1.489230089080593e-34, -1.025177375739405e-35,  6.184557693692860e-37, -3.320496827677655e-38,
  1.606173687552763e-39, -7.058814322240411e-41,  2.785744945935055e-30, -1.222531514077728e-30,  2.879754683516289e-31, -4.609646015555220e-32,  5.578359087054711e-33,
 -5.423007871696126e-34,  4.404275235842797e-35, -3.070985177649137e-36,  1.875855863970875e-37, -1.019423102436107e-38,  4.989492744418595e-40, -2.217939290998765e-41,
  };
  int offset = -44;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 44;
    if (std::isnan(t)) {
      fill_n(rr+offset, 44, 0.5);
      fill_n(ww+offset, 44, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 44; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=44; ++j) {
        const int boxof = it*528+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
