DACSKEY(1)                   DACS Commands Manual                   DACSKEY(1)



[1mNAME[0m
       dacskey - generate encryption keys for [1mDACS[0m

[1mSYNOPSIS[0m
       [1mdacskey [22m[[34m[1mdacsoptions[0m[1m[22m[1]]
               [[1m-check [22m| [1m-gen [22m| [1m-priv [22m| [1m-private [22m| [1m-pub [22m| [1m-public[22m]
               [[1m-p [22m| [1m-pf [4m[22mpassphrase-file[24m] [[1m-pem[22m] [[1m-vfs[22m] [[1m-rsa_key_bits [4m[22mnumber[24m]
               [[1m--[22m] [4mkeyfile[0m

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacskey [22mutility generates encryption keys for [1mDACS [22mthat are
       cryptographically sound. Keys are represented externally as an XML
       document called a keyfile. The program can also validate a keyfile or
       display a key.

       Keys are created for at least three different purposes, although every
       keyfile has the same format:

       +o   Keys that are shared by all of the jurisdictions within the same
           [1mDACS [22mfederation, identified by the virtual filestore item type
           federation_keys. It is through these "master" keys that any
           jurisdiction is able to decrypt and validate credentials created by
           any other jurisdiction within the same federation quickly and
           without any additional communication. These keys are generated
           initially by a designated federation administrator at the time a
           federation is created. These keys can be generated at any
           jurisdiction within the federation.

           Ideally, new keys should be generated at regular intervals and also
           whenever warranted to maintain security, such as when a
           jurisdiction leaves the federation or if a key may have been
           compromised. When a jurisdiction joins a federation, it must
           receive a copy of the current keys. There is currently no automated
           key management support; administrators must distribute these keys
           to all jurisdictions over a secure channel whenever they are
           changed. Besides using some method of encryption to ensure the keys
           remain private during distribution, take care not to mangle the XML
           document (e.g., through line breaks or truncation).

       +o   Keys that are used by a jurisdiction for its own purposes,
           identified by the virtual filestore item type jurisdiction_keys.
           These keys are kept private to the jurisdiction (they are not
           shared with any other jurisdiction) and are ordinarily generated at
           that jurisdiction. These keys should be regenerated periodically as
           a routine security measure.

       +o   Keys that are used by a [1mDACS [22mapplication at a particular
           jurisdiction for its own purposes ([34m[1mdacsgrid(1)[0m[1m[22m[2], for instance).
           These keys should be regenerated periodically, but take care to
           retain the old keys so that they can be used for decryption before
           information is re-encrypted using the new keys.


       The program ordinarily uses [1mOpenSSL[22m's [34m[1mssl(3)[0m[1m[22m[3] library to acquire
       high-quality random material. In certain situations, an experienced
       administrator might find the [1m-p [22mand [1m-pf [22moptions useful; others should
       avoid them, however.

       When keys are generated, the output is written to [4mkeyfile[24m, which is
       either created or truncated. In this context, [4mkeyfile[24m must be a
       pathname. Unless directly written to where federation_keys (or
       jurisdiction_keys) points, [4mkeyfile[24m must be copied there.

       Assuming that the default site configuration file (conf/site.conf-std,
       which establishes default locations for these files) has been
       installed:

           % dacskey -u mysite.example.com -q fkeys
           % install -o root -g www -m 0640 fkeys \
                 /usr/local/dacs/federations/example.com/federation_keyfile
           % dacskey -u mysite.example.com -q jkeys
           % install -o root -g www -m 0640 jkeys \
                 /usr/local/dacs/federations/example.com/mysite/jurisdiction_keyfile

       The owner, group, and mode assigned to these files in this example are
       typical but are only suggestions.

           [1mSecurity[0m
           A keyfile generated by this command must be accessible (readable
           and writable) [4monly[24m by [1mDACS [22mweb services and the [1mDACS [22madministrator.
           It must be kept unreadable and unwritable by all others.

       When not generating keys, by default [4mkeyfile[24m is a pathname. If the [1m-vfs[0m
       flag is given, then [4mkeyfile[24m is a [1mDACS [22mURI, item type, or absolute
       pathname.

[1mOPTIONS[0m
       In addition to the standard [34m[4mdacsoptions[0m[4m[24m[1], [1mdacskey [22mrecognizes these
       options:

       [1m-gen[0m
           Generate new keys. This is the default operation.

       [1m-check[0m
           Validate [4mkeyfile[24m, an existing keyfile. The [4mkeyfile[24m is expressed as
           a vfs-ref or an absolute filename (see [34m[1mdacs.conf(5)[0m[1m[22m[4]).

       [1m-priv[0m
       [1m-private[0m
           Print the private key found in [4mkeyfile[24m, an existing keyfile, to
           stdout. The private key is [4mnot[24m encrypted. If the [1m-pem [22mflag is
           present, the PEM format is used, otherwise the [1mDACS [22mbase-64
           encoding is used (the latter is used when keys appear in XML
           attribute values).

       [1m-pub[0m
       [1m-public[0m
           Print the public key found in [4mkeyfile[24m, an existing keyfile, to
           stdout. If the [1m-pem [22mflag is present, the PEM format is used,
           otherwise the [1mDACS [22mbase-64 encoding is used (the latter is used
           when keys appear in XML attribute values).

       [1m-p[0m
           Rather than using the default source for generating random strings,
           derive the random strings from material read from the standard
           input. The user is prompted for input. This option should not be
           used under normal circumstances.

       [1m-pem[0m
           When printing a key, use the PEM format.

       [1m-pf [4m[22mpassphrase-file[0m
           Rather than using the default source for generating random strings,
           derive the random strings from material read from [4mpassphrase-file[24m.
           If the filename argument is "[1m-[22m", the standard input is read. This
           option should not be used under normal circumstances.

       [1m-rsa_key_bits [4m[22mnumber[0m
           This specifies the length of the RSA modulus, in bits, used for
           asymmetric key generation. Used as the [4mnum[24m argument to
           [34m[1mRSA_generate_key(3)[0m[1m[22m[5], the value must satisfy that function's
           constraints.

       [1m--[0m
           This argument explicitly marks the end of the flags.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacsauth(1)[0m[1m[22m[6], [34m[1mdacsgrid(1)[0m[1m[22m[2], [34m[1mdacsinit(1)[0m[1m[22m[7], [34m[1mdacsrlink(1)[0m[1m[22m[8]
       [34m[1mdacstoken(1)[0m[1m[22m[9], [34m[1mdacs.install(7)[0m[1m[22m[10], [34m[1mdacs_acs(8)[0m[1m[22m[11]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[12])

[1mCOPYING[0m
       Copyright (C) 2003-2013 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[13] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacsgrid(1)
           http://dacs.dss.ca/man/dacsgrid.1.html

        3. ssl(3)
           http://www.freebsd.org/cgi/man.cgi?query=ssl&apropos=0&sektion=3&manpath=FreeBSD+9.1-RELEASE&format=html

        4. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        5. RSA_generate_key(3)
           http://www.freebsd.org/cgi/man.cgi?query=RSA_generate_key&apropos=0&sektion=3&manpath=FreeBSD+9.1-RELEASE&format=html

        6. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

        7. dacsinit(1)
           http://dacs.dss.ca/man/dacsinit.1.html

        8. dacsrlink(1)
           http://dacs.dss.ca/man/dacsrlink.1.html

        9. dacstoken(1)
           http://dacs.dss.ca/man/dacstoken.1.html

       10. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

       11. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

       12. www.dss.ca
           http://www.dss.ca

       13. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013                        DACSKEY(1)
