DACS_AUTHENTICATE(8)       DACS Web Services Manual       DACS_AUTHENTICATE(8)



[1mNAME[0m
       dacs_authenticate - [1mDACS [22mauthentication service

[1mSYNOPSIS[0m
       [1mdacs_authenticate [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This web service is part of the [1mDACS [22msuite.

       The [1mdacs_authenticate [22mweb service is an authentication "driver" for
       [1mDACS[22m. When it receives a request to authenticate a user, it usually
       invokes one or more authentication modules, depending on its
       configuration. Successful authentication assigns a [1mDACS [22muser identity
       to the user and roles modules may be invoked to determine the roles
       with which the identity is associated; [1mDACS [22mcredentials are generated
       and returned to the user. The caller of [1mdacs_authenticate [22mcan be
       redirected to a configured URL, called the post-authentication handler
       (or just the handler), depending on whether authentication fails or
       succeeds.

       General [1mDACS [22mconfiguration directives are discussed in [34m[1mdacs.conf(5)[0m[1m[22m[2].
       Configuration directives specific to authentication are described here.

       [1mDACS [22mexpressions are described in [34m[1mdacs.exprs(5)[0m[1m[22m[3].

       [1mdacs_authenticate [22mmight be called from an HTML form (see the
       distribution's [34m[1mhtml/examples[0m[1m[22m[4] directory for examples of simple login
       pages), directly through a link on a web page, indirectly by [1mDACS [34mHTTP[0m
       [1m[34mAuthentication[0m[1m[22m[5], or from middleware.

       Command line authentication functionality is provided by
       [34m[1mdacsauth(1)[0m[1m[22m[6]. Other authentication mechanisms are provided by
       [34m[1mdacs_auth_agent(8)[0m[1m[22m[7], [34m[1mdacs_auth_transfer(8)[0m[1m[22m[8], and [34m[1mdacscookie(1)[0m[1m[22m[9].

   [1mAuthentication[0m
       Authentication is the procedure by which a claimed identity is
       confirmed. Following successful authentication, [1mDACS [22mcredentials may be
       created that represent the identity. For maximum convenience and
       interoperability in a web environment, [1mDACS [22mcredentials are usually
       encapsulated within an HTTP cookie and transmitted over a TCP/IP
       connection secured by SSL/TLS. Any secure method of transporting
       credentials can be used instead, however, such as the value of an HTTP
       extension-header entity-header field in a request message sent over a
       VPN.

       While [1mdacs_authenticate [22mprovides powerful and flexible ways to combine
       and compose a variety of authentication methods, most [1mDACS[0m
       jurisdictions will configure only one method, or perhaps just a few
       methods, in simple ways.

       To help integrate [1mDACS [22mseamlessly within a web site, [1mdacs_authenticate[0m
       allows handlers to be configured. Handlers allow various exceptions to
       be caught and processed so that an appropriate flow of control can
       occur. For example, if authentication succeeds the user can be
       redirected to a specific page, including the one originally requested
       before the exception occurred.

       Authentication succeeds (and the user is authenticated) if and only if:

       +o   at least one [34m[1mAuth clause[0m[1m[22m[10] has been configured,

       +o   the semantics of all [34m[1mCONTROL[0m[1m[22m[11] directives satisfy the
           requirements for success,

       +o   the [1mDACS [34musername[0m[1m[22m[12] arrived at is syntactically valid, and

       +o   the identity's access has not been revoked or denied (see
           [34m[1mdacs.acls(5)[0m[1m[22m[13]).


       An incorrect password, for instance, is not considered to be an error;
       it will cause its Auth clause to fail but depending on the control
       directives that have been configured, the user may still be
       successfully authenticated by some other Auth clause. True errors are
       fatal and cause [1mdacs_authenticate [22mto terminate without issuing
       credentials and possibly without invoking a handler.

       If a [1mDACS [22midentity reauthenticates, the user agent is expected to
       replace the old credentials with new ones; if re-authentication fails
       (e.g., the password is incorrect), the old credentials should continue
       to exist. If a user establishes multiple concurrent identities, the
       user agent is expected to send all credentials with each service
       request in accordance with the relevant standards. This is standard
       behaviour for most common web browsers.

       As an efficiency measure, the authentication architecture allows an
       authentication module to return roles.

       [1mNames[0m
           Please refer to [34m[1mdacs(1)[0m[1m[22m[14] for details about naming.

       [1mCredentials and Cookies[0m
           [1mDACS [22mcredentials are cryptographically protected XML documents
           ([34m[1mcredentials.dtd[0m[1m[22m[15]). They have been carefully designed to make it
           extremely difficult for an attacker to generate valid credentials,
           modify captured credentials to impersonate another user, or obtain
           greater access rights without being detected.  [1mDACS [22mis careful to
           not produce log information or error messages that might benefit an
           attacker.

           User agents and other software outside of [1mDACS [22mdo not need to
           decrypt the credentials and do not possess the required encryption
           key.

           New credentials are created and returned to the user after
           successful authentication. The lifetime of each set of credentials
           is independently configurable, but they are intended to be fairly
           transitory. If a user reauthenticates, new credentials different
           than previous credentials might well be returned (e.g., with
           different roles).

           [1mDACS [22mdoes not verify that a user's browser is configured to accept
           cookies - this is the responsibility of the [1mDACS [22madministrator (by
           supplying client-side code to test that cookies have been enabled,
           for instance). Failure to accept cookies may cause some features to
           be unavailable or work incorrectly. Also note that despite what
           [1mDACS [22m(or any other program) tells a browser about the lifetime of
           an HTTP cookie, browsers may be configured to impose a shorter
           lifetime and can delete a cookie at any time. (Aside: Firefox
           2.0.0.3 appears to show cookies that have been deleted.)

               [1mSecurity[0m
               +o   For [1mDACS [22mto operate securely, communication between a user
                   (or middleware) and [1mdacs_authenticate[22m, which may include
                   information such as passwords, [4mmust[24m [4monly[24m [4mbe[24m [4mtransmitted[0m
                   [4mover[24m [4ma[24m [4msecure[24m [4mconnection[24m [4m(SSL/TLS)[24m.

               +o   Communication between [1mdacs_authenticate [22m(and [1mdacsauth[22m) and
                   an external (not built-in) authentication module may
                   include information such as passwords and therefore [4mshould[0m
                   [4monly[24m [4mbe[24m [4mtransmitted[24m [4mover[24m [4ma[24m [4msecure[24m [4mconnection[24m [4m(SSL/TLS)[24m or
                   in a way that is not subject to eavesdropping or attack.

               +o   For [1mDACS [22mto operate securely, regardless of how they are
                   obtained, [1mDACS [22mcredentials [4mmust[24m [4monly[24m [4mbe[24m [4mtransmitted[24m [4mover[24m [4ma[0m
                   [4msecure[24m [4mconnection[24m [4m(SSL/TLS)[24m [4mso[24m [4mthat[24m [4mthey[24m [4mcannot[24m [4measily[24m [4mbe[0m
                   [4mcaptured[24m [4mand[24m [4mreused[24m [4mby[24m [4man[24m [4mattacker[24m.

               +o   It is unwise to configure both SSL/TLS and non-SSL/TLS
                   communication. Besides providing an avenue for attack, it
                   may cause [1mDACS [22mto behave strangely (e.g., infinite loops
                   may occur because cookies obtained over an SSL/TLS
                   connection are not subsequently forwarded over a
                   non-SSL/TLS connection).

               +o   The apparent IP address of an authenticated user, as
                   provided by the web server, is stored in credentials.  [1mDACS[0m
                   can be configured to consider credentials to be valid only
                   for requests that come from that address (refer to the
                   [34m[1mVERIFY_IP[0m[1m[22m[16] configuration directive), making it more
                   difficult for an attacker to replay captured credentials.

                   In some environments this constraint is a good idea, but in
                   general it is of dubious value so enable it with care.
                   Where a user is behind a firewall or router that has
                   multiple IP addresses, successive service requests might
                   legitimately not appear to be coming from the same address
                   and some requests would be denied if this constraint were
                   enabled. In situations where credentials are being
                   forwarded between web services they might be rejected. In
                   the case of dial-up Internet access, a user might be issued
                   credentials, lose the connection, and be assigned a
                   different IP address upon reconnecting; the user would be
                   forced to reauthenticate. Also, more than one user may be
                   associated with a particular IP address, as when a Network
                   Address Translation (NAT) facility such as [34m[1mnatd(8)[0m[1m[22m[17] is
                   used, so the check does not guarantee uniqueness.

               +o   Information associated with a user's browser can be
                   included in credentials created for that user to make it
                   difficult to reuse captured credentials with a different
                   browser. Please refer to [34m[1mVERIFY_UA[0m[1m[22m[18] for details.

               +o   Credentials have a limit on their lifetime that is
                   independent of the lifetime of the HTTP cookie that
                   contains them; that is, credentials can expire without
                   their cookie having expired, and vice versa. Expired
                   credentials are recognized and will not be used by [1mDACS[22m.
                   Refer to the [34m[1mAUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS[0m[1m[22m[19]
                   configuration directive for details.

               +o   Passwords do not appear in any credentials and are not
                   stored once the user has been authenticated.

               +o   It is forbidden to submit multiple credentials for the same
                   identity to [1mDACS [22mand such a request will trigger an error.

           All [1mDACS [22mjurisdictions within the same federation share an
           algorithm and key to encrypt and decrypt credentials. A
           cryptographically secure, symmetric encryption function, Rijndael
           (the [34m[1mAdvanced Encryption Standard[0m[1m[22m[20] (AES) algorithm and [34m[1mFederal[0m
           [1m[34mInformation Processing Standard[0m[1m[22m[21]), is used. The same 128 bit key
           is used by all [1mDACS [22mjurisdictions.  AES also supports 192 and 256
           bit key lengths and either can be configured at build-time.

           A cryptographically secure message authentication code (MAC) is
           used to detect modification of credentials. A key different from
           the encryption key is used. The Keyed-Hash Message Authentication
           Code (HMAC, [34m[1mFIPS 198[0m[1m[22m[22], [34m[1mRFC 2104[0m[1m[22m[23], [34m[1mRFC 4635[0m[1m[22m[24], [34m[1mRFC[0m
           [1m[34m4868[0m[1m[22m[25]), is employed using the 160-bit [34m[1mNIST[0m[1m[22m[26] secure hash
           standard, SHA-1 ([34m[1mFIPS 180-1[0m[1m[22m[27], [34m[1mRFC 4634[0m[1m[22m[28], [34m[1mRFC 6234[0m[1m[22m[29]). In
           addition to SHA-1, SHA-224, SHA-256, SHA-384, and SHA-512 ([34m[1mFIPS[0m
           [1m[34m180-4[0m[1m[22m[30]) can be used, although they must be configured at
           build-time.

           The AES key length and HMAC digest algorithm used by a federation
           can be changed at any time, perhaps forcing some users to
           reauthenticate, but the same key length and digest algorithm must
           be used throughout a federation.

               [1mSecurity[0m
               [1mDACS [22mcan be configured to use the less secure but widely-used
               and somewhat more efficient [34m[1mMD5 algorithm[0m[1m[22m[31] instead, although
               it is deprecated and it will eventually be removed.

           The [34m[1mNetscape HTTP Cookies Specification[0m[1m[22m[32] defines the syntax and
           semantics of the HTTP response header that a web server sends to a
           client; this syntax is used by default, but the [34m[4mCOOKIE_SYNTAX[0m[4m[24m[33]
           argument can be used to request a different syntax. The Netscape
           format is as follows:

               Set-Cookie: NAME=VALUE; expires=DATE; path=PATH; domain=DOMAIN_NAME; secure

           [1mDACS [22mformulates these response headers as follows.

           The NAME attribute of an authentication cookie returned to the user
           (e.g., by [1mdacs_authenticate[22m) has the following default format:

               DACS:[4mfederation-name[24m::[[4mjurisdiction-name[24m]:[[4musername[24m]

           where [4mfederation-name[24m is the official name assigned to the
           federation for which the cookie is valid, [4mjurisdiction-name[24m is the
           name of the authenticating jurisdiction, and [4musername[24m is the
           authenticated name of the user. If the [4mjurisdiction-name[24m is
           omitted, the [4musername[24m must also be omitted. Semicolons, commas, and
           whitespace within the name must be URL-style encoded. Colons are
           not allowed in any of the name components. Here is an example of a
           cookie name:

               DACS:EXAMPLE::METALOGIC:rick@example.com


           [1mDACS [22mcan also return HTTP cookies for other purposes. The NAME
           attribute of these cookies has the same format as an authentication
           cookie but is followed by a colon and a keyword; e.g.,
           DACS:EXAMPLE:::SELECTED.

           The default format of the NAME attribute can be overridden through
           the [34m[1mCOOKIE_NAME_TERMINATORS[0m[1m[22m[34] directive.

           The VALUE attribute of a cookie is a printable text encoding of
           credentials.

               [1mSecurity[0m
               +o   Although [1mDACS [22mperforms validity tests on cookie names,
                   middleware should not rely on cookie names for any purpose.
                   An apparently valid [1mDACS [22mcookie can easily be crafted with
                   any value. Also, an apparently legitimate cookie might
                   convey expired or otherwise invalid credentials. Middleware
                   should use [34m[1mdacs_current_credentials(8)[0m[1m[22m[35] to validate an
                   authentication cookie and not trust cookie names.

               +o   No expires attribute is set; this will cause the cookie to
                   be automatically deleted by a conforming browser when the
                   user's browser session ends and not made persistent (i.e.,
                   not stored on disk for use in a subsequent browser
                   session), closing a potential security hole.

               +o   By default, the value of the path attribute is "/", meaning
                   the cookie will be sent with every request to the domain
                   that created the cookie, whether it is for a [1mDACS[22m-wrapped
                   service request or not. The [34m[1mCOOKIE_PATH[0m[1m[22m[36] configuration
                   directive can specify an alternative value. Using a more
                   restricted path can potentially improve security. All of
                   the jurisdiction's [1mDACS[22m-wrapped services must appear under
                   that path, of course, or the cookie will not be sent;
                   ideally, no non-[1mDACS [22mwrapped service would appear under
                   that path.

           The value of the domain attribute associated with the cookie is
           dependent on the uniform domain name scheme chosen for the
           jurisdictions. The value will be configured to be the most specific
           tail string that tail matches all participating domain names. For
           example, if the uniform domain name scheme has hostnames of the
           form xxx.example.com, yyy.example.com, and zzz.example.com, then
           the value of the attribute will be example.com. This will ensure
           that the user agent sends the cookie with any service request
           directed to a hostname ending in example.com.

               [1mTip[0m
               The HTTP cookie specifications appear to say that a cookie
               having a domain attribute of example.com should [4mnot[24m be sent to
               a host of the same name, yet both Mozilla and IE (and perhaps
               other browsers) do just that. Without this behaviour, it would
               not be possible to use a single domain name with multiple [1mDACS[0m
               jurisdictions below it; that is, given domain=example.com, it
               is expected that jurisdictions can be identified by URI path
               prefixes such as example.com/metalogic, example.com/test, and
               so on.

           When operating securely (see the [34m[1mSECURE_MODE[0m[1m[22m[37] directive in
           [34m[1mdacs.conf(5)[0m[1m[22m[2]) or when an authentication request is sent over
           SSL/TLS, the secure attribute will be present so that the cookie
           will only be transmitted if the communications channel with the
           host is a secure one. At present, browsers define this to mean that
           secure cookies will only be sent to HTTPS (HTTP over SSL/TLS)
           servers.

   [1mWeb Service Arguments[0m
       In addition to the [34m[1mstandard CGI arguments[0m[1m[22m[38], [1mdacs_authenticate[0m
       understands the following CGI arguments. Some arguments are optional,
       while others are required depending on the authentication
       configuration. An invalid argument value will usually cause
       authentication to fail immediately. Unrecognized arguments are ignored.

       [4mAUTH_ID[0m
           This optional argument is used with the user_sufficient keyword
           (refer to the [34m[1mCONTROL[0m[1m[22m[11] directive).

       [4mAUTH_PROMPT_VAR_PREFIX[0m
           Reserved for use by [34m[1mlocal_pam_authenticate[0m[1m[22m[39].

       [4mAUTH_TRANSID[0m
           Reserved for use by [34m[1mlocal_pam_authenticate[0m[1m[22m[39].

       [4mAUTHORIZATION[0m
           Used internally with [34m[1mHTTP Authentication[0m[1m[22m[5].

       [4mAUXILIARY[0m
           This argument can be used to pass additional authentication
           material to authentication modules. A compile-time maximum length
           of [1m128 [22mcharacters is imposed.

       [4mCOOKIE_SYNTAX[0m
           By default, the [4mde[24m [4mfacto[24m standard [34m[1mNetscape HTTP Cookies[0m
           [1m[34mSpecification[0m[1m[22m[32] syntax is followed when cookies are created
           (COOKIE_SYNTAX=COOKIE_NETSCAPE). The value COOKIE_EXT_NETSCAPE
           selects an "extended" Netscape spec syntax (it is not the Netscape
           syntax but it is not fully RFC 2109 compliant either); instead of
           using the expires attribute it will use the Max-Age attribute as
           defined in [34m[1mRFC 2109[0m[1m[22m[40], [34m[1mRFC 2965[0m[1m[22m[41], and [34m[1mRFC 6265[0m[1m[22m[42]. Attribute
           values are not quoted and there is no support for the Comment
           field. Parameter values COOKIE_RFC2109, COOKIE_RFC2965, and
           COOKIE_RFC6265 are recognized but not implemented.

               [1mNote[0m
               [34m[1mRFC 2109[0m[1m[22m[40], [34m[1mRFC 2965[0m[1m[22m[41], and [34m[1mRFC 6265[0m[1m[22m[42] forbid the
               following characters from appearing within an HTTP cookie's
               NAME attribute:

                   ( ) <  > @ , ; : \ "  /  [  ]  ? = {  }

               Additionally, the space, tab, and all US-ASCII control
               characters (octets 0 - 31) and DEL (127) are disallowed (refer
               to the definition of a token in [34m[1mRFC 2616[0m[1m[22m[43], S2.2). By
               default, [1mDACS [22mcurrently follows the original Netscape spec
               syntax in this respect and produces cookies that are invalid
               according to RFC 2109, RFC 2965, and RFC 6265 because [34m[1mcolons[0m
               [1m[34mare used within cookie names[0m[1m[22m[44]. While this limitation does
               not appear to cause problems for web browsers in practice, it
               may be noteworthy for users of some cookie handling APIs. When
               necessary, the cookie name format can be customized using the
               [34m[1mCOOKIE_NAME_TERMINATORS[0m[1m[22m[34] directive.

       [4mDACS_AUTH_SUCCESS_HANDLER[0m
           This argument provides a way for the caller to specify where the
           user agent should be redirected after successful authentication,
           regardless of whether authentication handlers are configured or
           enabled. If its value is DACS_ERROR_URL and an argument by that
           name is present, the user agent will be redirected to the value of
           that argument; otherwise, the user agent will be redirected to the
           value of [4mDACS_AUTH_SUCCESS_HANDLER[24m. The [4mDACS_ERROR_URL[24m is passed to
           this web service by [34m[1mdacs_acs(8)[0m[1m[22m[45] as part of an authentication
           workflow initiated by a request that is denied because no
           credentials were supplied; [4mDACS_ERROR_URL[24m should not be generated
           by any non-[1mDACS [22msoftware.

       [4mDACS_BROWSER[0m
           If an argument named [4mDACS_BROWSER[24m is present and has the value [1m1[22m,
           it signifies that the request is coming from a browser rather than
           middleware. If the request comes from a browser, [1mDACS [22mwill return a
           cookie using the Set-Cookie HTTP response header, otherwise it will
           not.

       [4mDACS_DEBUG[0m
           If this argument is present, the web service will produce more
           detailed log information.

       [4mENABLE_AUTH_HANDLERS[0m
           The jurisdiction's authentication handler directives are honoured
           if and only if this argument is present and has the value [1m1[22m.

       [4mOPERATION[0m
           This is used with the identity selection mechanism described by
           [34m[1mdacs_select_credentials(8)[0m[1m[22m[46]. If the value of this parameter is
           SELECT and authentication is successful, any currently selected
           credentials are deselected and the new credentials are selected.

       [4mPASSWORD[0m
           This argument is the password that corresponds to [4mUSERNAME[24m. A
           compile-time maximum length of [1m128 [22mcharacters is imposed.

       [4mUSERNAME[0m
           This argument, which is almost always required, is the name
           provided by the user and is usually the name being authenticated.
           It will not necessarily be the same as the final [1mDACS [22musername. For
           example, if the value of [4mUSERNAME[24m is not a syntactically valid [1mDACS[0m
           username (see [34m[1mdacs(1)[0m[1m[22m[12]), the authentication procedure must
           transform it into something acceptable (using the [34m[1mstrtr()[0m[1m[22m[47]
           function, for instance; see [34m[1mdacs.exprs(5)[0m[1m[22m[3]). A compile-time
           maximum length of [1m64 [22mcharacters is imposed.

       [4mWWW_AUTHENTICATE[0m
           Reserved for internal use by [34m[1mHTTP Authentication[0m[1m[22m[5].

   [1mAuth Clause Directives[0m
       Each Auth clause in a [1mDACS [22mconfiguration file contains directives that
       describe a procedure for authenticating users. Some of these directives
       are common to all authentication modules, while others are understood
       only by a certain module; for example, [34m[1mLDAP_USERNAME_URL[0m[1m[22m[48] is only
       meaningful to the [34m[1mlocal_ldap_authenticate[0m[1m[22m[49] module. The
       general-purpose [34m[1mOPTION[0m[1m[22m[50] directive may sometimes be used to specify
       an argument to an authentication module.

           [1mImportant[0m
           The order in which the Auth clauses appear is significant. See the
           [34m[1mCONTROL[0m[1m[22m[11] directive.

       Every Auth element must have an id attribute. Its value is merely a
       label (an alphabetic followed by zero or more alphanumerics, hyphens,
       and underscores) that allows the clause to be referenced. Each id
       attribute value must be unique (case-sensitively) within the
       Jurisdiction section that contains it.

       The following configuration directives are recognized by
       [1mdacs_authenticate [22mwithin any Auth clause (see [34m[1mdacs.conf(5)[0m[1m[22m[51] for
       general information about directives).

       [1mAuth Clause Common Directives Index:[0m

        1. CONTROL (Required1)

        2. CREDENTIALS_LIFETIME_SECS (Optional1)

        3. EXIT* (Optional1)

        4. EXPR (Optional1)

        5. FLAGS (Optional1)

        6. INIT* (Optional1)

        7. OPTION (Optional)

        8. OPTION* (Optional)

        9. PASSWORD_AUDIT (Optional)

       10. PREDICATE (Optional1)

       11. STYLE (Required1)

       12. URL (Optional1)

       13. URL* (Optional1)

       CONTROL (Required1)
           This directive specifies a PAM-like control keyword that determines
           what will happen if the authentication module succeeds or fails;
           see [34m[1mpam(3)[0m[1m[22m[52] and the [34m[1mX/Open Single Sign-On Service (XSSO)[0m
           [1m[34mpreliminary specification[0m[1m[22m[53] (page 30), from which the description
           of these directives was adapted. Although this control mechanism
           allows for rather complicated authentication sequences to be
           described, in practice jurisdictions tend to construct fairly
           simple configurations. Most processing errors (other than errors
           encountered by a module) are considered fatal.

           The first Auth clause that appears after configuration merging (see
           [34m[1mdacs.conf(5)[0m[1m[22m[54]) is the "top" or first module in the stack, the
           next one is the second module in the stack, and so on.

           The value of this directive is a case-insensitive keyword that can
           be abbreviated up to the indicated minimum:

           +o   require[d]

           +o   requisite

           +o   opt[ional]

           +o   suff[icient]

           +o   user_suff[icient]
               For example, the keywords require and required are equivalent.

               The control flow of authentication module processing is as
               follows:

                1. If a requisite module fails, authentication fails and
                   [1mdacs_authenticate [22mstops processing the module stack,
                   returning the error reported by the requisite module;

                2. If all requisite and required modules in the stack succeed,
                   then authentication succeeds (any errors reported by
                   optional, sufficient, and user_sufficient modules are
                   ignored);

                3. If one or more required modules fail, then the error value
                   from the first required module that failed is returned;
                   unlike failure of a requisite module, processing continues;

                4. If none of the modules in the stack are designated as
                   required or requisite, then [1mdacs_authenticate [22mrequires that
                   at least one optional, sufficient, or user_sufficient
                   module succeed. If all fail, then the error value from the
                   first module in the stack is returned;

                5. The first exception to the above is caused by the
                   sufficient keyword. If a module that is designated as
                   sufficient succeeds, then [1mdacs_authenticate [22mimmediately
                   returns success (all subsequent modules are ignored, even
                   required and requisite ones), given that all prior required
                   and requisite modules have also succeeded. If a prior
                   required module failed, then the error value from that
                   module is returned;

                6. The second exception to the above involves the
                   user_sufficient keyword, which enables at most one
                   user_sufficient Auth clause and disables all other
                   user_sufficient [4mand[24m sufficient Auth clauses. This control
                   simplifies configuring user-selectable authentication
                   methods. Note that this mechanism will necessarily reveal
                   additional information about a jurisdiction's
                   authentication configuration.

                   If the [4mAUTH_ID[24m argument is [4mnot[24m given, then all Auth clauses
                   with the user_sufficient control are disabled - none of
                   their directives are evaluated - and any sufficient
                   controlled clauses are processed normally. If the [4mAUTH_ID[0m
                   is present, then only an Auth clause with a user_sufficient
                   control [4mand[24m an exactly matching id attribute is used. There
                   can be at most one such Auth clause; all other Auth clauses
                   having a user_sufficient [4mor[24m sufficient control is disabled.
                   In all other respects, an enabled user_sufficient Auth
                   clause is processed as for the sufficient control;

                7. If an error occurs while processing a directive, then
                   [1mdacs_authenticate [22mfails immediately.

               CREDENTIALS_LIFETIME_SECS (Optional1)
                   The lifetime, in seconds, of credentials returned after
                   successful authentication. This overrides the general
                   directive of the same name, and may in turn be overridden
                   by setting the variable [4m${Auth::CREDENTIALS_LIFETIME_SECS}[24m.
                   Authentication will fail if this value is invalid.

               EXIT* (Optional1)
                   If authentication is successful, this expression is
                   evaluated immediately after the module's authentication
                   processing is executed (but refer to the FLAGS directive).

               EXPR (Optional1)
                   This directive, which is required when STYLE is expr, gives
                   an expression that is evaluated to decide whether to grant
                   credentials and the [1mDACS [22midentity to use. See
                   [34m[1mAuthenticating Using an Expression[0m[1m[22m[55].

               FLAGS (Optional1)
                   This directive gives control flags that are interpreted by
                   [1mdacs_authenticate[22m. Each directive consists of a
                   whitespace-separated list of values.

                   The only value currently recognized is the keyword ident.

                       [1mImportant[0m
                       If there is more than one Auth clause, the ident flag
                       should ordinarily be specified in at least one of them
                       to indicate that the username returned by the module,
                       if authentication is successful, is to become the
                       "current" username. Those Auth clauses without the
                       ident flag will not change the current username. After
                       the last Auth clause is processed, the current username
                       is used in the resulting credentials.

                       The [4m${Auth::CURRENT_USERNAME}[24m variable (see below) is
                       updated only if there is exactly one Auth clause or if
                       the ident flag is given. This update occurs immediately
                       prior to execution of any EXIT* directive.

                       If ident is not specified in any successfully processed
                       Auth clause (i.e., one where authentication succeeds),
                       the username returned by the last successfully
                       processed clause is used. If the ident flag is
                       specified in one or more successfully processed
                       clauses, the username returned by the last such module
                       will be used.

               INIT* (Optional1)
                   The given expression is evaluated immediately prior to the
                   URL* and EXPR expressions, all of which are evaluated
                   before a module's authentication processing is invoked.

               OPTION (Optional)
                   The directive value is a [4mname[24m=[4mvalue[24m pair that may be
                   interpreted by [1mdacs_authenticate [22mor the authentication
                   module specified by the Auth clause. It causes a variable
                   called [4mname[24m to be put into the Options namespace, which
                   only exists within the context of the Auth clause
                   containing this OPTION. The variables in this namespace are
                   passed as arguments to the authentication module.
                   Whitespace may not precede or follow the '=' and any quotes
                   around the value are considered to be part of the value. A
                   given [4mname[24m may not be specified more than once within a
                   particular Auth clause. The Options namespace is
                   initialized with [4mUSERNAME[24m, [4mPASSWORD[24m, [4mAUXILIARY[24m,
                   [4mDACS_JURISDICTION[24m, and [4mDACS_VERSION[24m variables. If these
                   variables are specified by an OPTION, the argument
                   ordinarily used will be overridden.

                   For example, this directive causes SAMBA_PORT=139 to be
                   passed as a POST method parameter:

                       OPTION "SAMBA_PORT=139"


               OPTION* (Optional)
                   The given expression is evaluated before the module is
                   called, and after all OPTION directives and all OPTION*
                   directives that appear earlier. The value of the expression
                   must be a [4mname[24m=[4mvalue[24m pair, as with the OPTION directive,
                   and overrides any [4mname[24m in the Options namespace.

               PASSWORD_AUDIT (Optional)
                   This directive is used to audit password-type arguments
                   passed to authentication modules by [1mdacs_authenticate[22m,
                   regardless of the authentication method, against the
                   criteria selected by the specified constraint string, which
                   is in the format used by [34m[1mPASSWORD_CONSTRAINTS[0m[1m[22m[56]. If any
                   password does not meet the requirements, a log message will
                   be emitted (which does not include the password itself).
                   The message will be tagged as audit and sensitive; please
                   refer to the [34m[1mLOG_FILTER[0m[1m[22m[57] directive. This feature can be
                   used to notify the administrator about weak passwords.

                   The directive value can be a variable name, which is
                   matched exactly against the [4mPASSWORD[24m or [4mAUXILIARY[0m
                   arguments, or a keyword in one of the OPTION directives
                   within the same clause. In this form, the
                   PASSWORD_CONSTRAINTS directive must be configured and its
                   value is used as the constraint. In the second form, the
                   directive value is a variable name as in the first form,
                   followed by spaces or tabs, followed by the constraint
                   string to use in the syntax of PASSWORD_CONSTRAINTS.
                   Consider the following directives:

                       PASSWORD_CONSTRAINTS "8L,1C,1P"

                       <Auth id="auth1">
                         URL "https://foo.example.com/cgi-bin/dacs/local_woof_authenticate"
                         STYLE "pass"
                         CONTROL "sufficient"
                         PASSWORD_AUDIT "PASSWORD 10L"
                         PASSWORD_AUDIT "AUXILIARY"
                       </Auth>

                   Here, the [4mPASSWORD[24m argument must be at least ten characters
                   long but [4mAUXILIARY[24m must only be eight characters long and
                   include an upper case character and punctuation.

                       [1mNote[0m
                       Not all authentication modules require a [4mPASSWORD[0m
                       argument, such as [34m[1mlocal_cas_authenticate[0m[1m[22m[58] in its
                       interactive mode. This directive is ignored if the
                       argument is not passed to the module.

               PREDICATE (Optional1)
                   If provided, this expression is evaluated before any other
                   authentication module processing is done. If there is an
                   evaluation error or it returns [1mFalse [22m(zero or the empty
                   string), processing continues just as if the module were
                   run and indicated that authentication failed. Otherwise,
                   processing of the clause continues normally.

                   This directive provides a way to effectively enable or
                   disable a module based on run time context. This can be
                   used to configure layered authentication or risk-based
                   authentication because a predicate can examine various
                   aspects of an authentication request, such as the [4mUSERNAME[24m,
                   current date and time, IP address from where the request
                   originates, and so on.

               STYLE (Required1)
                   Each authentication module implements one or more
                   authentication styles. The value of the STYLE directive is
                   a comma-separated list of case-insensitive style names and
                   style options; the order is insignificant. No whitespace is
                   allowed. Keywords can be abbreviated up to the indicated
                   minimum.

                   cas
                       This style selects username/password authentication
                       using the [34m[1mCentral Authentication Service (CAS)[0m[1m[22m[59]
                       protocol through the [34m[1mlocal_cas_authenticate[0m[1m[22m[58]
                       authentication module.

                   cert[ificate]
                       An X.509 client certificate, obtained from the SSL/TLS
                       layer, will be provided for authentication. The request
                       must be sent using SSL/TLS and the client certificate
                       must be provided by [1mApache [22mthrough the [1mSSL_CLIENT_CERT[0m
                       environment variable.

                   digest
                       This selects the [34m[1mRFC 2617[0m[1m[22m[60] Digest Access
                       Authentication scheme as implemented by [1mDACS [22min
                       conjunction with the [34m[1mlocal_apache_authenticate[0m[1m[22m[61]
                       authentication module. See [34m[1mHTTP Authentication[0m[1m[22m[5].

                   expr
                       No authentication module will be used; [34m[1mexpression[0m
                       [1m[34mevaluation[0m[1m[22m[55] will be used instead.

                   infocard
                       A self-issued or managed [34m[1mInformation Card[0m[1m[22m[62]
                       (InfoCard) must be provided for authentication. To be
                       recognized, the InfoCard must have been previously
                       registered at this jurisdiction using
                       [34m[1mdacsinfocard(1)[0m[1m[22m[63], [34m[1mdacs_infocard(8)[0m[1m[22m[64], or
                       [34m[1mdacs_managed_infocard(8)[0m[1m[22m[65]. This style is implemented
                       by the [34m[1mlocal_infocard_authenticate[0m[1m[22m[66] authentication
                       module.

                   managed_infocard
                       A managed [34m[1mInformation Card[0m[1m[22m[62] (InfoCard) must be
                       provided for authentication. To be recognized, the
                       InfoCard must have been previously registered at this
                       jurisdiction using [34m[1mdacs_managed_infocard(8)[0m[1m[22m[65]. This
                       style is implemented by the
                       [34m[1mlocal_infocard_authenticate[0m[1m[22m[66] authentication module.

                   nat[ive]
                       The user is expected to have already authenticated
                       through the web server's native authentication
                       mechanism (e.g., HTTP Basic or Digest authentication,
                       [34m[1mRFC 2617[0m[1m[22m[60]); [1mDACS [22mwill import this identity without
                       any additional requirements. The [1mAUTH_TYPE [22menvironment
                       variable but be available and have the value Basic or
                       Digest (case insensitive), and the [1mREMOTE_USER[0m
                       environment variable must be set.

                   pass[word]
                   passwd
                       The username must be provided through a [4mUSERNAME[0m
                       argument and the password must accompany the
                       authentication request through a [4mPASSWORD[24m argument.

                   prompt[ed]
                       A dialog-based interaction will be conducted, such as
                       one based on Pluggable Authentication Modules (PAM).
                       See [34m[1mlocal_pam_authenticate[0m[1m[22m[39].

                   selfissued_infocard
                       A self-issued [34m[1mInformation Card[0m[1m[22m[62] (InfoCard) must be
                       provided for authentication. To be recognized, the
                       InfoCard must have been previously registered at this
                       jurisdiction using [34m[1mdacsinfocard(1)[0m[1m[22m[63] or
                       [34m[1mdacs_infocard(8)[0m[1m[22m[64]. This style is implemented by the
                       [34m[1mlocal_infocard_authenticate[0m[1m[22m[66] authentication module.

                   simple
                       This style of authentication merely requires a
                       recognized username, provided through a [4mUSERNAME[0m
                       argument and therefore offers little security. Still,
                       it can be used in appropriate situations to
                       authenticate a user that can provide a valid account
                       name, which might be a membership number or randomly
                       generated (and perhaps hard to guess) username. If a
                       [4mPASSWORD[24m argument is provided, it is logged as
                       sensitive data, much as an anonymous FTP password might
                       be logged. This style is implemented by the
                       [34m[1mlocal_simple_authenticate[0m[1m[22m[67] authentication module.

                   tgma
                       [4mExperimental[24m. This interactive style of authentication
                       requires only [4mUSERNAME[24m and [4mJURISDICTION[24m arguments to be
                       selected by the user. Refer to the TGMA authentication
                       module for details.

                       This style is implemented by the
                       [34m[1mlocal_tgma_authenticate[0m[1m[22m[68] authentication module.

                   set_roles
                       If the authentication module returns roles, this style
                       modifier says that they should override any other roles
                       currently in effect and no roles module should be
                       executed. This option may appear at most once among all
                       Auth clauses and only if [34m[1madd_roles[0m[1m[22m[69] is not used.

                   add_roles
                       If the authentication module returns roles, this style
                       modifier says that they should be appended to any other
                       roles currently in effect. Any configured roles modules
                       will still be executed. This option may be repeated in
                       other Auth clauses but may not appear if the
                       [34m[1mset_roles[0m[1m[22m[70] option also appears.

               URL (Optional1)
               URL* (Optional1)
                   Exactly one of these two directives must be specified,
                   except when STYLE is expr, where neither directive is used.
                   These directives specify the URL to be used to invoke the
                   authentication module. Use of an absolute URL is
                   recommended.

                   The difference between the two directives is that the value
                   of URL* is an expression that is evaluated immediately
                   before the module is invoked to determine the URL to be
                   used.

                   In the current implementation, the standard set of modules
                   must run within the context of a [1mDACS [22mjurisdiction. This is
                   not an architectural limitation, however.

                       [1mTip[0m
                       Some authentication modules are available as built-in
                       components of [1mdacs_authenticate [22mand [1mdacsauth[22m. These
                       modules are identified by specific relative URLs. A
                       module's description will provide its built-in name
                       when this capability is available. The built-in
                       capability will automatically be provided if the module
                       has been enabled at build-time.

                       Although it will be more efficient (and possibly more
                       secure) to use a built-in module, they are executed on
                       the same host as [1mdacs_authenticate [22mthereby giving up
                       some flexibility because access control rules are not
                       applied to them (other than the one for
                       [1mdacs_authenticate[22m), and [1mdacs_authenticate [22mmay need to
                       be executed setuid root or setgid www so that it can
                       access password files. When an external module is used,
                       it is subject to normal [1mDACS [22maccess control rules. In
                       contrast to a built-in module, the additional level of
                       indirection makes it simple to substitute a custom
                       version of an external module. The same comments apply
                       to [1mdacsauth[22m.

               Here is an example of a configuration that will authenticate
               using Unix user names and passwords:

                   <Auth id="passwd">
                     URL "https://foo.example.com:8443/cgi-bin/dacs/local_unix_authenticate"
                     STYLE "pass"
                     CONTROL "sufficient"
                   </Auth>

               In the following example, [1mdacs_authenticate [22mwill first try to
               authenticate using a Unix login name and password; if that
               fails, it will then try a [1mDACS [22maccount name and password.

                   <Auth id="passwd">
                     URL "https://foo.example.com:8443/cgi-bin/dacs/local_unix_authenticate"
                     STYLE "pass"
                     CONTROL "sufficient"
                   </Auth>

                   <Auth id="passwd2">
                     URL "https://foo2.example.com/cgi-bin/dacs/local_passwd_authenticate"
                     STYLE "pass"
                     CONTROL "sufficient"
                   </Auth>

               The preceding example can be changed to try authenticating
               using a [1mDACS [22maccount name and password if and only if the
               [4mAUXILIARY[24m argument has the value "guest" (which might have been
               provided when the user selected a button on a login form):

                   <Auth id="passwd">
                     URL "https://foo.example.com:8443/cgi-bin/dacs/local_unix_authenticate"
                     STYLE "pass"
                     CONTROL "sufficient"
                     PREDICATE '${Args::AUXILIARY} ne "guest"'
                   </Auth>

                   <Auth id="passwd2">
                     URL "https://foo2.example.com/cgi-bin/dacs/local_passwd_authenticate"
                     STYLE "pass"
                     CONTROL "sufficient"
                     PREDICATE '${Args::AUXILIARY} eq "guest"'
                   </Auth>

               In this example, a jurisdiction offers users a choice from
               among three authentication methods: a Google(TM) account, a
               Windows NTLM account, or a [1mDACS [22mpassword-based account. The
               jurisdiction's login form would be written to provide the
               appropriate [4mAUTH_ID[24m argument for the corresponding method;

                   # For AUTH_ID=google
                   <Auth id="google">
                     URL "local_http_authenticate"
                     STYLE "password"
                     CONTROL "user_sufficient"
                     OPTION 'AUTH_URL="https://www.google.com/accounts/ClientLogin"'
                     OPTION 'AUTH_METHOD=POST'
                     OPTION 'USERNAME_PARAMETER="Email"'
                     OPTION 'PASSWORD_PARAMETER="Passwd"'
                     OPTION 'service=xapi'
                     OPTION "source=DSS-DACS-1.4"
                   </Auth>

                   # For AUTH_ID=ntlm
                   <Auth id="ntlm">
                     URL "local__ntlm_authenticate"
                     STYLE "password"
                     CONTROL "user_sufficient"
                     OPTION 'SAMBA_SERVER="samba.example.com"'
                     OPTION 'SAMBA_PORT="139"'
                     EXIT* '${Auth::CURRENT_USERNAME}=strtr(${Auth::CURRENT_USERNAME}, "a-z", "A-Z")'
                   </Auth>

                   # For AUTH_ID=passwd
                   <Auth id="passwd">
                     URL "local_passwd_authenticate"
                     STYLE "password"
                     CONTROL "user_sufficient"
                   </Auth>


   [1mInitialization and the Auth Namespace[0m
       [1mdacs_authenticate [22muses a variable namespace called Auth to make
       authentication-related context available to its configuration
       directives (see [34m[1mdacs.exprs(5)[0m[1m[22m[71]). Aspects of [1mdacs_authenticate[22m's
       behaviour can be controlled by modifying these variables. This
       namespace disappears when [1mdacs_authenticate [22mterminates. The next
       section describes how these variables are used.

       Additionally, all environment variables are accessible through the Env
       namespace (e.g., [4m${Env::REMOTE_ADDR}[24m) during authentication processing.

   [1mAuthentication Clause Control Flow[0m
       Auth clauses are processed in the order in which they appear in the
       configuration file, subject to the semantics of the CONTROL directives.

       [1mdacs_authenticate [22mis typically configured so that the last thing it
       does is to redirect its caller to an appropriate web page. If
       authentication is successful, any [34m[1mAUTH_SUCCESS[0m[1m[22m[72] expression is
       evaluated and the [34m[1mAUTH_SUCCESS_HANDLER[0m[1m[22m[73] directive is consulted; if
       authentication fails, the [34m[1mAUTH_ERROR_HANDLER[0m[1m[22m[74] and
       [34m[1mAUTH_FAIL_DELAY_SECS[0m[1m[22m[75] directives are used. This behaviour is
       partially under the control of the caller through the
       [34m[4mDACS_AUTH_SUCCESS_HANDLER[0m[4m[24m[76] and [34m[4mENABLE_AUTH_HANDLERS[0m[4m[24m[77] arguments,
       however.

           [1mTip[0m
           To redirect the newly authenticated user to a web page based on the
           user's identity, jurisdiction, roles, or other contextual state,
           configure AUTH_SUCCESS_HANDLER to specify the URL of a [1mDACS[22m-wrapped
           CGI program. After examining environment variables automatically
           passed to it by [1mDACS [22mor its query arguments, this program can emit
           an appropriate redirect. To test this, configure:

               AUTH_SUCCESS_HANDLER "url /cgi-bin/dacs/dacs_prenv"

           (making sure that [34m[1mdacs_prenv(8)[0m[1m[22m[78] has been installed) and examine
           the information that is available.

       An Auth clause is processed in a sequence of steps, and with various
       hooks to provide fine-grained control. Only advanced [1mDACS[0m
       administrators usually need to be concerned with this level of detail.

       Before the first clause is examined, the variable
       [4m${Auth::CURRENT_USERNAME}[24m is set to the empty string; this variable is
       automatically updated by [1mdacs_authenticate[22m. The contents of the Args,
       DACS, Conf, and Env [34m[1mnamespaces[0m[1m[22m[71] are made available to all
       expressions evaluated during authentication module processing.
       Processing of each Auth clause is performed in the following sequence:

        1. If the clause has a PREDICATE directive, it is evaluated in the
           current context. If the value is not [1mTrue [22m(including cases where
           the expression was invalid), processing of the clause terminates
           immediately with the same result as if its authentication had been
           unsuccessful.

        2. If a variable named [4m${Auth::ABORT}[24m has the value yes (case
           insensitive), authentication terminates. If the variable
           [4m${Auth::MODULE_SKIP}[24m has the value yes (case insensitive),
           processing of the clause terminates immediately with the same
           result as if its authentication had been unsuccessful.

        3. If the clause has an INIT* directive, it is evaluated; if an error
           occurs, authentication terminates.

        4. If the clause has a URL directive, it names the authentication
           module to be invoked (or is the name of a built-in module).

           If the URL* directive is used instead, it is evaluated to obtain
           the URL to be invoked; if an error occurs, authentication
           terminates.

        5. If a variable named [4m${Auth::ABORT}[24m has the value yes (case
           insensitive), authentication terminates. If the variable
           [4m${Auth::MODULE_SKIP}[24m has the value yes (case insensitive),
           processing of the clause terminates immediately with the same
           result as if its authentication had been unsuccessful.

        6. If the clause's STYLE is expr, the EXPR directive is evaluated and
           is expected to either return [1mFalse [22mor a valid [1mDACS [22musername. If the
           expression's value is [1mFalse[22m, processing of the clause terminates
           immediately with the same result as if its authentication had been
           unsuccessful; if its value is an invalid username, authentication
           terminates, otherwise the module is deemed to have been successful.
           If an error occurs, authentication terminates.

           If the clause's STYLE is not expr, the authentication module is
           invoked.

        7. If an error occurs while executing the authentication module,
           authentication terminates. If the authentication module does not
           authenticate the user, the CONTROL directive determines whether
           authentication fails or continues.

           The username passed to the module, or returned by the module,
           becomes the tentative [1mDACS [22musername and the variable
           [4m${Auth::CURRENT_USERNAME}[24m is set to it. If the variable
           [4m${Auth::ROLES}[24m is set to a valid role descriptor, it becomes the
           current tentative roles for the user.

        8. The expression given by the EXIT* directive, if any, is evaluated.
           If an error occurs, authentication terminates. The expression may
           update [4m${Auth::CURRENT_USERNAME}[24m. For instance, the directive:

               EXIT* '${Auth::CURRENT_USERNAME}="bobo"'

           completely ignores the username returned by the module and simply
           assigns one, while this directive:

               EXIT* '${Auth::CURRENT_USERNAME} = \
                      strtr(${Auth::CURRENT_USERNAME}, "A-Z", "a-z")'

           converts all upper case characters in the username returned by the
           module to their lower case equivalents.

        9. If a variable named [4m${Auth::ABORT}[24m has the value yes (case
           insensitive), authentication terminates despite success of the
           module. If the variable [4m${Auth::MODULE_SKIP}[24m has the value yes
           (case insensitive), processing of the clause terminates immediately
           with the same result as if its authentication had been
           unsuccessful.

       The value of [4m${Auth::CURRENT_USERNAME}[24m when the last module has been
       processed is the username that will be assigned to a successfully
       authenticated user. If set, the value of
       [4m${Auth::CREDENTIALS_LIFETIME_SECS}[24m will be used as the lifetime of the
       generated credentials; if not set, the value returned by the last
       successful authentication module is used (typically that of the
       module's CREDENTIALS_LIFETIME_SECS directive), if available, or the
       jurisdiction's CREDENTIALS_LIFETIME_SECS directive's value.

   [1mAuthenticating Using an Expression[0m
       Rather than using an authentication module, the expr style of
       authentication involves evaluating an expression. The value of the
       expression is the [1mDACS [22musername to associate with the user. If no value
       is returned, an invalid value is returned, or an error occurs, the Auth
       clause fails.

       Here is a simple example that is unlikely to be used in practice. If
       the [4mPASSWORD[24m argument is "xyzzy", then authentication will succeed and
       the user will be assigned the [1mDACS [22musername bobo.

           <Auth id="expr1">
             STYLE "expr"
             CONTROL "sufficient"
             EXPR '${Args::PASSWORD} eq "xyzzy" ? "bobo" : ""'
           </Auth>

       This example illustrates how an expression can be used to read a
       password (its hex-encoded SHA-256 hash, actually) from a file and
       compare it with the one provided in the service request. Each user has
       his own password file that consists of a single line of text containing
       the hash. If a username is given that does not have a corresponding
       password file, or if the hash of the provided password does not match
       the stored one, the Auth clause will fail, otherwise the given username
       is returned as the authenticated name.

           <Auth id="expr5">
           STYLE "expr"
           EXPR '${pwd} = get("/usr/local/dacs/pwd/pwd." . ${Args::USERNAME}); \
             digest(${Args::PASSWORD}, 0, sha256) eq decode(hex, ${pwd}) \
                 ? ${Args::USERNAME} : ""'
           CONTROL "sufficient"
           </Auth>

       The expression can also assign a valid role string to [4m${Auth::ROLES}[24m to
       establish roles for the user (in conjunction with the [34m[1madd_roles[0m[1m[22m[69] or
       [34m[1mset_roles[0m[1m[22m[70] style modifier):

           <Auth id="expr2">
             STYLE "expr,add_roles"
             CONTROL "sufficient"
             EXPR '${Auth::ROLES}="foo,bar"; ${Args::PASSWORD} eq \
               "xyzzy" ? "bobo" : ""'
           </Auth>

       This style of authentication can be a useful alternative to the cert
       style with the [1mlocal_cert_authenticate [22mmodule. If the client has
       provided an X.509 certificate that has been adequately verified by the
       web server, then in many cases all that remains to be done is to assign
       a syntactically valid DACS username to the client.  [34m[1mEnvironment[0m
       [1m[34mvariables[0m[1m[22m[79] created by [34m[1mmod_ssl[0m[1m[22m[80] can be referenced as
       [4m${Auth::ssl_variable_name}[24m. Something such as the following might be
       suitable:

           <Auth id="expr3">
             STYLE "expr"
             CONTROL "sufficient"
             EXPR '${Auth::SSL_CLIENT_VERIFY} eq "SUCCESS" and
               ${Auth::SSL_CLIENT_S_DN_Email:ei} \
                   ? ${Auth::SSL_CLIENT_S_DN_Email:i} : ""'
           </Auth>

       Another application of this style of authentication is where it is the
       location of the user that is important rather than the user's identity
       [4mper[24m [4mse[24m. For example, if a system administrator needs to restrict access
       to a web server to the hosts in a lab or desktops in a group of offices
       (that presumably share a subnet) but does not require individual users
       to authenticate, a configuration like the following might be adequate:

           <Auth id="expr4">
             STYLE "expr"
             CONTROL "sufficient"
             EXPR '${Auth::CURRENT_USERNAME} = "user-${Env::REMOTE_ADDR}"'
           </Auth>

       A user would not provide a username or a password; by simply clicking
       on a link that invokes [1mdacs_authenticate[22m, a user from the computer with
       IP address 10.0.0.213 (for example) would be assigned the identity
       user-10.0.0.213. Access control rules could be expressed in terms of
       those identities or the corresponding IP addresses.

   [1mMiddleware Support[0m
       As with most [1mDACS [22mweb services, the [4mFORMAT[24m argument can be used to
       request a particular type of output (see [34m[1mdacs.services(8)[0m[1m[22m[81]) from
       [1mdacs_authenticate[22m. If any XML type is specified, the reply from
       [1mdacs_authenticate [22mwill conform to the DTD [34m[1mdacs_auth_reply.dtd[0m[1m[22m[82]. The
       reply indicates whether the user has been successfully authenticated or
       not. If authentication was successful, a description of the new
       credentials is returned as a dacs_current_credentials element, (as
       described by [34m[1mdacs_current_credentials.dtd[0m[1m[22m[83]). If authentication was
       unsuccessful because of a transient error condition, a reason may
       optionally be provided.

           [1mSecurity[0m
           This reason is solely used to inform the user; it should not reveal
           any details that might compromise security.

       Authentication modules return an [34m[1mauth_reply.dtd[0m[1m[22m[84] document to
       [1mdacs_authenticate[22m.

   [1mAuthentication Modules[0m
           [1mImportant[0m
           [1mDACS [22mprovides a set of authentication modules. At the time [1mDACS [22mis
           compiled, some standard modules are enabled by default while others
           needed must be specifically enabled (see [34m[1mdacs.install(7)[0m[1m[22m[85]). You
           should not enable authentication modules that you do not plan to
           use.

           [1mSecurity[0m
           +o   As a security measure, these modules should be executable only
               by [1mdacs_authenticate[22m, which is the default.

           +o   By default, access control rules are configured to restrict
               access to all authentication and roles modules. This prevents
               an attacker from calling an authentication module directly in
               an attempt to guess account names, passwords, and so on.

           +o   Modules may need to be installed setuid or setgid as
               appropriate so that it is possible for them to read the
               password files that they require or obtain encryption keys.

           +o   Modules may need to be installed setuid or setgid, and never
               run as the UID of a less-privileged user, so that it is
               impossible to circumvent the module's functionality (e.g., by
               attaching to the running module with a debugger).

       Each authentication module is called with the following arguments.
       Authentication modules are always invoked using the POST method.

       [4mAUXILIARY[0m
           The value of the [4mAUXILIARY[24m argument to [1mdacs_authenticate [22mif one was
           given, otherwise the empty string.

       [4mDACS_JURISDICTION[0m
           The value of the [4mDACS_JURISDICTION[24m argument to [1mdacs_authenticate[22m.

       [4mDACS_VERSION[0m
           The DACS_VERSION_NUMBER for this version of [1mdacs_authenticate[22m.

       [4mPASSWORD[0m
           The value of the [4mPASSWORD[24m argument to [1mdacs_authenticate [22mif one was
           given, otherwise the empty string.

       [4mUSERNAME[0m
           The value of the [4mUSERNAME[24m argument to [1mdacs_authenticate[22m.

       Directives
           Each directive in the Auth section being processed and its value is
           passed.

       SSL/TLS environment variables
           Each SSL/TLS environment variable passed to [1mdacs_authenticate [22mis
           passed.

       Transaction state data
           With respect to the prompted style of authentication, transaction
           state variables are passed.
       Ordinarily, a particular argument may not appear more than once.

       [1mAuthentication Module Index:[0m

        1. local_apache_authenticate: Password-protected accounts maintained
           by [1mApache [22mutilities

        2. local_cas_authenticate: Central Authentication Service (CAS)

        3. local_cert_authenticate: SSL-based X.509 client certificates

        4. local_grid_authenticate: Grid-based one-time passwords

        5. local_http_authenticate: Generic authentication via HTTP

        6. local_infocard_authenticate: Information Card-based accounts and
           identities

        7. local_ldap_authenticate: Lightweight Directory Access Protocol
           (LDAP) / Microsoft Active Directory

        8. local_native_authenticate: Importing an identity established by
           [1mApache[0m

        9. local_ntlm_authenticate: Microsoft Windows NT LAN Manager usernames
           and passwords

       10. local_pam_authenticate: Pluggable Authentication Modules (PAM)

       11. local_passwd_authenticate: Password-protected [1mDACS [22maccounts

       12. local_simple_authenticate: Account name without a password

       13. local_tgma_authenticate: Time-Gated Mutual Authentication
           ([4mexperimental[24m)

       14. local_token_authenticate: One-time passwords, two-factor
           authentication

       15. local_unix_authenticate: Unix usernames and passwords

       [1mlocal_apache_authenticate[0m
           The [1mlocal_apache_authenticate [22mmodule is used to authenticate
           against password files used by the [1mApache [34mmod_auth[0m[1m[22m[86],
           [34m[1mmod_auth_digest[0m[1m[22m[87], or [34m[1mmod_auth_dbm[0m[1m[22m[88] modules. These password
           files are managed by [1mApache's [34mhtpasswd(1)[0m[1m[22m[89], [34m[1mhtdigest(1)[0m[1m[22m[90], and
           [34m[1mhtdbm(1)[0m[1m[22m[91] utilities, respectively. An administrator can
           configure [1mDACS [22mto use an existing htpasswd file, for instance, and
           so avoid dealing with creating and managing a duplicate set of
           usernames and passwords.

           If HTTP Basic authentication ([34m[1mRFC 2617[0m[1m[22m[60]) is used, the STYLE
           should be password. If Digest authentication is used, because no
           password is passed to [1mDACS[22m, the STYLE for this module should be
           configured as digest.

           The following configuration options are recognized by this module.
           They should be provided using the OPTION directive.

           AUTH_MODULE
               This must be "mod_auth" (or "htpasswd"), "mod_auth_digest" (or
               "htdigest"), or "mod_auth_dbm" (or "htdbm"), depending on which
               module's authentication method is to be used. This value is
               case-insensitive.

           AUTH_FILE
               This is the absolute pathname of the flat-file or database file
               to use.

                   [1mNote[0m
                   This pathname is resolved on the host that runs this
                   module. This should eventually be extended to accept a [1mDACS[0m
                   virtual filestore URI.

           DBM_TYPE
               Required only in conjunction with mod_auth_dbm compatibility,
               this argument identifies the database format of AUTH_FILE. The
               names "sdbm" (not yet implemented), "gdbm", "ndbm", and "db"
               are recognized, although not all types may be available on a
               particular platform.

               [1mNotes[0m
               +o   This module does not rely on any [1mApache [22mmodule (other than
                   [1mmod_auth_dacs[22m).

               +o   This module does not require any [1mApache [22mconfiguration with
                   respect to authentication; only [1mDACS [22mneeds to be
                   configured.

               +o   It is not necessary to use [1mDACS's [34mHTTP Authentication[0m[1m[22m[5]
                   feature in order to use this module. For example, using
                   HTTP Basic authentication ([34m[1mRFC 2617[0m[1m[22m[60]), the [4mUSERNAME[24m and
                   [4mPASSWORD[24m arguments can be submitted from a site's login
                   page and verified by this module against an [1mhtpasswd [22mfile.

               +o   [1mhtpasswd [22mallows plaintext passwords to be stored in a
                   password file, although [1mhttpd [22mapparently restricts the use
                   of these passwords. This module imposes no such
                   restrictions. Under normal circumstances passwords should
                   not be stored in plaintext form.

               +o   The major difference between this module and
                   [34m[1mlocal_native_authenticate[0m[1m[22m[92] is that the latter "imports"
                   an identity already established by an [1mApache [22mauthentication
                   module, whereas this module authenticates using information
                   that can also be used by [1mApache [22mand which is administered
                   using [1mApache [22mutiltities.

               +o   [1mDACS [22mwill access [1mApache [22mpassword files in read-only mode
                   only; [1mDACS [22mnever modifies those files.

               +o   Some platforms may not support all possible DBM-type
                   databases and some types of database may not have been
                   configured at build-time.

           Here is an example configuration that uses an [1mhtpasswd[22m-managed file
           for authentication:

               HTTP_AUTH_ENABLE "yes"
               HTTP_AUTH "Basic \"DACS Basic Auth Area\" /restricted/*"

               <Auth id="apache-htpasswd">
               URL "https://example.com/cgi-bin/dacs/local_apache_authenticate"
               STYLE "pass"
               CONTROL "sufficient"
               OPTION "AUTH_FILE=/usr/local/apache2/conf/passwords"
               OPTION "AUTH_MODULE=mod_auth"
               </Auth>

           If the passwords were kept in a Berkeley DB database instead, the
           configuration might look like:

               HTTP_AUTH_ENABLE "yes"
               HTTP_AUTH "Basic \"DACS Basic Auth Area\" /restricted/*"

               <Auth id="apache-htpasswd">
               URL "https://example.com/cgi-bin/dacs/local_apache_authenticate"
               STYLE "pass"
               CONTROL "sufficient"
               OPTION "AUTH_FILE=/usr/local/apache2/conf/passwords.db"
               OPTION "AUTH_MODULE=mod_auth_dbm"
               OPTION "DBM_TYPE=db"
               </Auth>

           This example configuration is similar; the difference is that the
           username and password obtained through HTTP Basic authentication
           are verified against a Unix account:

               HTTP_AUTH_ENABLE "yes"
               HTTP_AUTH "Basic \"DACS Basic Auth Area\" /private/*"

               <Auth id="basic">
               URL "https://example.com/cgi-bin/dacs/local_unix_authenticate"
               STYLE "pass"
               CONTROL "sufficient"
               </Auth>

           This example configures HTTP Digest authentication and references
           an [1mhtdigest[22m-managed file:

               HTTP_AUTH_ENABLE "yes"
               HTTP_AUTH "Digest \"DACS Digest Auth Area\" /digest/*"

               <Auth id="apache-htdigest">
               URL "apache"
               STYLE "digest"
               CONTROL "sufficient"
               OPTION "AUTH_FILE=/usr/local/apache2/conf/passwords.digest"
               OPTION "AUTH_MODULE=mod_auth_digest"
               </Auth>


               [1mTip[0m
               A built-in version of this module can be selected by using the
               URL local_apache_authenticate or just apache.

       [1mlocal_cas_authenticate[0m
           This module coordinates with a specified [34m[1mCentral Authentication[0m
           [1m[34mService (CAS)[0m[1m[22m[93] server to authenticate a user that is purportedly
           known to that server. The module implements the client side of the
           [34m[1mCAS 2.0 Protocol[0m[1m[22m[94] and can be used in two different modes:
           interactive and non-interactive.

           Interactive mode is employed if neither a [4mUSERNAME[24m nor a [4mPASSWORD[0m
           argument is given to [1mdacs_authenticate[22m. When [1mdacs_authenticate [22mis
           called, whether directly or as the result of redirection after
           access was denied to an unauthenticated user, it redirects the user
           to a CAS login page. After successful CAS authentication (which may
           return a ticket granting cookie to the user's browser), CAS
           redirects the user to [1mdacs_authenticate[22m, passing it the CAS session
           ticket as an argument called [4mticket[24m. After successfully validating
           the session ticket at the CAS server, [1mDACS [22mauthentication succeeds.

               [1mSecurity[0m
               When interactive mode is used, [1mDACS [22mdoes not see the username
               and password, only CAS does. The username is obtained by the
               module as part of the session ticket validation protocol. This
               mode of operation is similar to, but simpler than, the
               [34m[1mOpenID[0m[1m[22m[95] Authentication protocol.

           A variant of this flow of control can occur if the user has
           authenticated against the CAS server outside of [1mDACS [22mand therefore
           holds a ticket granting cookie. This cookie will automatically be
           sent by the user's browser when it is redirected to the CAS server;
           as a result, the CAS server may not prompt the user to
           authenticate.

           In non-interactive mode, both a [4mUSERNAME[24m [4mand[24m a [4mPASSWORD[24m argument
           are passed to [1mdacs_authenticate[22m. This module will use these
           arguments to authenticate the user against the CAS server. In this
           mode, no ticket granting cookie will be returned to the user. This
           mode can be used with the [1mDACS [34mHTTP authentication[0m[1m[22m[5] feature.

           The STYLE should be configured as cas for this module.

           The following module-specific OPTION directive value is understood:

           CAS_SERVER_URI (Required1)
               This is the URI of the CAS server to authenticate against. For
               example, dacs.conf might contain authentication configuration
               similar to the following:

                   <Auth id="CAS">
                   URL "cas"
                   STYLE "cas"
                   CONTROL "sufficient"
                   OPTION "CAS_SERVER_URI=https://cas.example.com/castest"
                   </Auth>


           The module recognizes the following arguments (which are
           automatically passed to it as necessary by [1mdacs_authenticate[22m):

           CAS_TICKET (Required1-C)
               This is the session ticket returned by CAS via a callback to
               [1mdacs_authenticate [22m(i.e., the [4mticket[24m argument).

           CAS_REDIRECT_ARGS (Optional1)
               These are additional arguments to [1mdacs_authenticate [22mthat must
               be provided when CAS performs its callback to [1mdacs_authenticate[0m
               to preserve user preferences. The [4mDACS_BROWSER[24m, [4mFORMAT[24m,
               [4mDACS_ERROR_URL[24m, and [4mENABLE_AUTH_HANDLERS[24m arguments may be
               forwarded in this way.

           CAS_SERVER_URI (Required1-C)
               This argument has the value specified in the Auth clause's
               OPTION directive. Note that HTTP redirects are not handled in
               this context, so invoking GET on CAS_SERVER_URI must return a
               valid document.

               [1mNote[0m
               The [1mlocal_cas_authenticate [22mmodule extends the response of the
               [1mvalidate [22mservice of the CAS protocol to allow a role descriptor
               string ([4mrole_string[24m) to be returned. If authentication
               succeeds, the standard service returns the following text:
                yes\n[4musername[24m\n

               An invalid role string is discarded. If these roles should be
               used, it will be necessary to use either the [34m[1mset_roles[0m[1m[22m[70] or
               [34m[1madd_roles[0m[1m[22m[69] style modifier with the [34m[1mSTYLE[0m[1m[22m[96] directive.

               [1mTip[0m
               The authentication procedure described by the CAS protocol is
               notable because the authentication material provided by the
               user in interactive mode [4mdoes[24m [4mnot[24m [4mflow[24m [4mthrough[24m [1mDACS[22m; in
               particular, [1mDACS [22mdoes not see a user's password when this
               module is used. This may be an important consideration in some
               environments.

               Because the protocol implemented by this module is general
               purpose and relatively simple, writing middleware that
               implements a subset of the server-side CAS protocol to
               interface with this module may be a sensible solution for [1mDACS[0m
               administrators who require a CAS-like control flow but do not
               want to use actual CAS server-side software. The user would be
               redirected to the middleware component by
               [1mlocal_cas_authenticate [22mto perform the /login service; then it
               would prompt and authenticate the user, and redirect the user
               to a URL provided to it by [1mlocal_cas_authenticate[22m; then
               [1mlocal_cas_authenticate [22mwould call the middleware component
               directly, this time to perform the /validate service. The usual
               flow of control within [1mDACS [22mwould follow.

               A simple script for testing and working with
               [1mlocal_cas_authenticate [22mis available in src/cas_middleware_test.

               [1mTip[0m
               A built-in version of this module can be selected by using the
               URL local_cas_authenticate or just cas.

       [1mlocal_cert_authenticate[0m
           The [1mlocal_cert_authenticate [22mmodule authenticates a user that
           supplies an acceptable X.509 client certificate via SSL/TLS.
           [1mApache [22mmust be appropriately configured to request and verify
           client certificates, check for revocation, and so on (see
           [34m[1mSSLVerifyClient[0m[1m[22m[97] and related directives). As part of the SSL/TLS
           protocol, [1mApache[22m's [34m[1mmod_ssl[0m[1m[22m[80] module verifies that the client
           possesses the private key that corresponds to the client
           certificate.  [1mApache [22mwill usually be configured to verify the
           correctness and suitability of the client certificate.  [1mApache[0m
           directives such as [34m[1mSSLRequire[0m[1m[22m[98] might be used, for example.

           The STYLE should be configured as certificate for this module.

           The verification of the client certificate done by [1mApache [22mmay be
           sufficient, in which case the only remaining configuration task for
           the Auth clause is to assign a username and possibly extract role
           information from the certificate; it may impose additional tests on
           the certificate, however, by inspecting its fields. If verification
           beyond the ability of [34m[1mmod_ssl[0m[1m[22m[80] is required, or if it needs to be
           performed on a system other than where the web server is running,
           [1mlocal_cert_authenticate [22mcan execute an external program to decide
           whether the client certificate is suitable for authentication. This
           program is currently limited to [34m[1mOpenSSL[0m[1m[22m[99] but this may be
           generalized in future versions.

           To ensure that [1mlocal_cert_authenticate [22mis able to obtain
           information contained within the client certificate, [1mApache [22mmust be
           configured so that [1mStdEnvVars [22mand [1mExportCertData [22mare enabled in an
           appropriate [34m[1mSSLOptions[0m[1m[22m[100] directive, such as the following:

               SSLOptions +StdEnvVars +ExportCertData

           The following configuration directives are specific to this module:

           CERT_CA_PATH (Required1)
               This is the absolute pathname of a directory that contains
               trusted certificates. Refer to the [1m-CApath [22margument to
               [1mOpenSSL[22m's verify command.

           CERT_DUMP_CLIENT (Optional1)
               If configured, this gives the absolute pathname of a file to
               which the client certificate is to be written in PEM format.
               The file is created or truncated, as necessary. This is useful
               for debugging purposes.

           CERT_NAME_ATTR (Optional1)
               If this directive is configured, it gives the name of an
               [34m[1mSSL/TLS environment variable[0m[1m[22m[79]. The value of that variable is
               used as a key for the certnamemap item type (which must also be
               configured); the key's value becomes the username returned by
               the module (if the environment variable is not found or the
               lookup is unsuccessful, the module will fail to authenticate
               the user). If the module is not fully configured for this
               lookup, the value of the [4mUSERNAME[24m is returned by the module.

               To illustrate this, consider the following configuration:

                   VFS "[certmap]dacs-kwv-fs:/usr/local/dacs/federations/certnamemap"

                   <Auth id="cert">
                     URL "https://example.com/cgi-bin/dacs/local_cert_authenticate"
                     STYLE "cert"
                     CONTROL "sufficient"
                     CERT_CA_PATH "/usr/local/apache2/conf/ssl.crt"
                     CERT_NAME_ATTR "SSL_CLIENT_S_DN_CN"
                   </Auth>

               with the file /usr/local/dacs/federations/certnamemap
               containing the two lines:

                   Clark Kent:superman
                   Bruce Wayne:batman

               Given the configuration above, if the value of the
               [1mSSL_CLIENT_S_DN_CN [22menvironment variable is "Clark Kent", the
               username returned by the module will be "superman".

               As with any module, an expression can be used within an Auth
               clause to modify or override the value returned by a module.

           CERT_OPENSSL_PATH (Optional1)
               This is the absolute pathname of the [1mopenssl [22mprogram. If not
               provided, a build-time value is used ([4mOPENSSL_PATH[24m).

               [1mSecurity[0m
               The lifetime of credentials obtained through the local
               authentication service may be independent of the validity
               period of the certificate presented for authentication. It is
               therefore possible for the certificate to expire before the
               [1mDACS [22mcredentials. The local authentication service might take
               this into consideration before granting access and when
               computing a lifetime for the resulting [1mDACS [22mcredentials.

       [1mlocal_grid_authenticate[0m
           This module works in concert with the [34m[1mdacsgrid(1)[0m[1m[22m[101] utility to
           provide users with one-time passwords. It is also an approximation
           of the "something you have" factor of two-factor authentication.

           The STYLE should be configured as password for this module.

           Please refer to [34m[1mdacsgrid(1)[0m[1m[22m[101] for a complete description.

           In addition to the usual [4mUSERNAME[24m argument, the module requires the
           [4mPASSWORD[24m argument to be the user's response to the challenge and
           the [4mAUXILIARY[24m argument to be the encoded challenge. The latter two
           arguments must be produced by [34m[1mdacsgrid(1)[0m[1m[22m[101].

           The following OPTION directive values are understood:

           AUTH_GRID_CHALLENGE_SECS (Optional1)
               The number of seconds between when a challenge is created and
               when it expires, overriding the default value. This value
               should be relatively small, at most on the order of a few tens
               of seconds. If this module runs on a host other than the one
               running [1mdacs_authenticate[22m, the two system clocks must be
               suitably synchronized.

           AUTH_GRID_LIFETIME_SECS (Optional1)
               The length of time, in seconds, for which a grid is valid.
               After this period, all authentication against a grid will fail.

               [1mTip[0m
               A built-in version of this module can be selected by using the
               URL local_grid_authenticate or just grid.

       [1mlocal_http_authenticate[0m
           This module authenticates by invoking a given (non-interactive) web
           service with specified arguments. If the web service reports
           success by returning HTTP status code [1m200 [22m(see [34m[1mRFC 2616[0m[1m[22m[43],
           Section 10), then the module succeeds, otherwise it fails. No
           session is established with the web service and no additional
           requests are made to it.

           In its simple (default) mode of operation, any output returned by
           the web service is discarded, including cookies. The web service is
           used solely to determine whether a username/password is correct. In
           its alternate mode, the web service can return a document that
           specifies a replacement username, lifetime of generated
           credentials, and a role string.

           This module can be used to authenticate against any existing web
           service that follows the expected protocol, or provide a way to add
           a new, custom authentication method to [1mDACS[22m.

           The STYLE should be configured as password for this module.

           The following OPTION directive values are understood:

           AUTH_URL (Required1)
               The URL of the web service to invoke, which need not be
               [1mDACS[22m-wrapped. It may use either the http or https scheme. No
               [1mDACS [22mcredentials will be sent with the request.

           AUTH_METHOD (Optional1)
               The HTTP method to use to invoke AUTH_URL. The default is POST.
               Keep in mind that if query arguments are present (or if the GET
               method is used) they may appear in log files.

           PASSWORD_PARAMETER (Optional1)
               The name of the argument by which [4mPASSWORD[24m is passed to the web
               service. The default is [4mPASSWORD[24m.

           USERNAME_PARAMETER (Optional1)
               The name of the argument by which [4mUSERNAME[24m is passed to the web
               service. The default is [4mUSERNAME[24m.

           USE_AUTH_REPLY (Optional1)
               The default behaviour is to ignore any document that is
               returned by the web service. If this option is "yes" or "on",
               however, the web service must return a syntactically valid
               [34m[1mauth_reply.dtd[0m[1m[22m[84] document. For authentication to succeed, the
               document must indicate successful authentication. The contents
               of a valid document will provide the username (overriding
               USERNAME), and, optionally, the lifetime of the credentials and
               a role string. If the STYLE directive does not include an
               [34m[1madd_roles[0m[1m[22m[69] or [34m[1mset_roles[0m[1m[22m[70] modifier, the role string will
               be ignored. This capability allows a generic web service to be
               called with arbitrary arguments to dynamically authenticate a
               user, and set an identity and roles. The returned values must
               be valid.

           Any other OPTION directive values are simply passed to the invoked
           web service, including any duplicate argument names.

           For [34m[1mGoogle[0m[1m[22m[102](TM) [34m[1maccount authentication[0m[1m[22m[103], for instance, the
           following configuration might be used:

               <Auth id="google">
               URL "local_http_authenticate"
               STYLE "password"
               CONTROL "required"
               OPTION 'AUTH_URL="https://www.google.com/accounts/ClientLogin"'
               OPTION 'USERNAME_PARAMETER=Email'
               OPTION 'PASSWORD_PARAMETER=Passwd'
               OPTION 'service=xapi'
               OPTION "source=DSS-DACS-1.4"
               </Auth>

           This web service returns an HTTP status code of [1m200 [22mif the correct
           username and password are given (i.e., login succeeded), and [1m403 [22mif
           login fails. If [1mClientLogin [22mfails and requests a CAPTCHA challenge
           the request will not be passed back to the user.

               [1mNote[0m
               One of the reasons for inclusion of this module is to support
               reuse of accounts widely used by the public. Google(TM)
               provides exactly the right interface needed by systems such as
               [1mDACS[22m. As of 20-April-2012, Google has officially deprecated
               [1mClientLogin[22m. Accounts provided by [34m[1meBay[0m[1m[22m[104](TM)and
               [34m[1mYahoo![0m[1m[22m[105](R), for instance, do not appear to be directly
               usable in this way. In some cases, [34m[1mdacs_auth_transfer(8)[0m[1m[22m[8] may
               be a better approach than this module.

           The following outlines a trivial example of authentication using
           the USE_AUTH_REPLY directive. Assume that the following shell
           script can be invoked as http://example.com/cgi-bin/myauth:

               #! /bin/sh

               /bin/cat <<HERE

               <?xml version="1.0" encoding="US-ASCII"?>
               <!DOCTYPE auth_reply SYSTEM "http://example.com/dacs/dtd-xsd/auth_reply.dtd">
               <auth_reply>
               <ok username="guest">
               <roles_reply>
               <ok roles="bigwheel,mediumwheel,littlewheel"/>
               </roles_reply>
               </ok>
               </auth_reply>
               HERE

               exit 0

           Also assume the following Auth clause has been configured:

               <Auth id="http">
               URL "local_http_authenticate"
               STYLE "password,set_roles"
               CONTROL "required"
               OPTION 'AUTH_URL="http://example.com/cgi-bin/myauth"'
               OPTION 'AUTH_METHOD=GET'
               OPTION 'USE_AUTH_REPLY="YES"'
               </Auth>

           Invoking this URL will always successfully authenticate any user
           and issue credentials for the identity JUR1:guest with roles
           bigwheel,mediumwheel,littlewheel:

               https://example.com/cgi-bin/dacs/dacs_authenticate?USERNAME=alice&PASSWORD=test&DACS_JURISDICTION=JUR1

           This [34m[1mexpression[0m[1m[22m[3] is equivalent:

               % dacsexpr -e 'dacsauth("-m http passwd,set_roles suff -OAUTH_URL=http://bsd9.dss.ca/cgi-bin/dacs/http_auth \
                   -OAUTH_METHOD=GET -OUSE_AUTH_REPLY=yes -u test -p test")'
               {"result",1,"identity","DSS::BSD9:guest","roles","bigwheel,mediumwheel,littlewheel"}


               [1mTip[0m
               A built-in version of this module can be selected by using the
               URL local_http_authenticate or just http.

       [1mlocal_infocard_authenticate[0m
               [1mDeprecated[0m
               In early 2011, Microsoft [34m[1mannounced[0m[1m[22m[106] that it would not
               support [34m[1mCardSpace[0m[1m[22m[107] (aka, Infocards and Information Cards)
               starting with [34m[1mWindows 8[0m[1m[22m[108]. CardSpace has been the most
               widely available identity selector for using Information Cards.

               The implementation of Infocards support within [1mDACS [22mremains in
               the code base and is documented, but is no longer being
               actively tested and maintained (neither are the demos). Support
               for Information Cards within [1mDACS [22mwill likely be removed
               eventually. You may notice that other Infocard and CardSpace
               related projects have been terminated and their web pages are
               out of date or no longer available.

               References: [34m[1mOn the Demise of CardSpace[0m[1m[22m[109]; [34m[1mOpen Cardspace[0m
               [1m[34mopportunity[0m[1m[22m[110]; [34m[1mPersonal Reflections on the CardSpace[0m
               [1m[34mJourney[0m[1m[22m[111]; [34m[1mFrom CardSpace to Verified Claims[0m[1m[22m[112]; [34m[1mChange[0m
               [1m[34mwill come: the present is untenable[0m[1m[22m[113]; [34m[1mThe Clay Feet of[0m
               [1m[34mGiants?[0m[1m[22m[114]; [34m[1mRIP, Windows CardSpace. Hello, U-Prove[0m[1m[22m[115]; and
               [34m[1mU-Prove[0m[1m[22m[116].

           The [1mlocal_infocard_authenticate [22mmodule performs [1mDACS [22mauthentication
           using an [34m[1mInformation Card[0m[1m[22m[62] (InfoCard) previously registered at
           the jurisdiction. Self-issued InfoCards are registered using
           [34m[1mdacs_infocard(8)[0m[1m[22m[64] or [34m[1mdacsinfocard(1)[0m[1m[22m[63]. Managed InfoCards are
           also supported, provided they have been registered using
           [34m[1mdacs_managed_infocard(8)[0m[1m[22m[65] and include a dacs_identity claim in
           the [1mDACS [22mnamespace.  [1mDACS [22maims to conform to [34m[1mIdentity Selector[0m
           [1m[34mInteroperability Profile (ISIP) 1.5[0m[1m[22m[117].

           A [1mDACS [34mrole descriptor string[0m[1m[22m[118] can be associated with a managed
           InfoCard through the dacs_roles claim name in the [1mDACS [22mnamespace
           (see [34m[1mdacs_infocard(8)[0m[1m[22m[119]. These roles can be associated with new
           credentials via the [34m[1madd_roles[0m[1m[22m[69] and [34m[1mset_roles[0m[1m[22m[70] modifiers.

               [1mSecurity[0m
               At present, to be valid for authentication, the dacs_identity
               claim value must specify a user at the current jurisdiction;
               that is, it cannot specify an identity at a jurisdiction other
               than the one where authentication is being performed.

           The authentication style infocard causes the module to accept
           either type of InfoCard - the type of InfoCard actually used will
           be available in the resulting credentials. The styles
           managed_infocard and selfissued_infocard tell the module to limit
           authentication to managed InfoCards or self-issued InfoCards,
           respectively. When invoked as a web service,
           [1mlocal_infocard_authenticate [22munderstands an optional argument, [4mTYPE[24m,
           that may have the value "selfissued" or "managed" to restrict
           authentication to the corresponding InfoCard type; the default
           behaviour accepts either type of InfoCard.

               [1mTip[0m
               The [34m[1mexpression-based authentication style[0m[1m[22m[120], which does not
               call this module, provides an alternative way to support
               InfoCard-based authentication. It is somewhat more complicated
               to use, however, and may require a small amount of programming.

           For additional information about InfoCards, please refer to:

           +o   [34m[1mdacs_managed_infocard(8)[0m[1m[22m[121], [34m[1mdacs.conf(5)[0m[1m[22m[122] (the INFOCARD_
               prefixed directives), [34m[1mdacs_mex(8)[0m[1m[22m[123], and [34m[1mdacs_sts(8)[0m[1m[22m[124].

           +o   [34m[1mUsing InfoCards With DACS[0m[1m[22m[125], Distributed Systems Software
               (July, 2009).

           +o   [34m[4mIdentity[24m [4mSelector[24m [4mInteroperability[24m [4mProfile[24m [4mspecification[24m [4mand[0m
               [4m[34mcompanion[24m [4mguides[0m[4m[24m[126] (August, 2008).

           +o   [34m[4mIntroducing[24m [4mWindows[24m [4mCardSpace[0m[4m[24m[127] (April, 2006).


           [1mTip[0m
           A built-in version of this module can be selected by using the URL
           local_infocard_authenticate or just infocard.

       [1mlocal_ldap_authenticate[0m
           The [1mlocal_ldap_authenticate [22mmodule performs [1mDACS [22mauthentication
           using the Lightweight Directory Access Protocol, also known as
           LDAP, (see [34m[1mRFC 2251[0m[1m[22m[128], [34m[1mRFC 2252[0m[1m[22m[129], [34m[1mRFC 2253[0m[1m[22m[130], [34m[1mRFC[0m
           [1m[34m3377[0m[1m[22m[131], and many others). This form of authentication can be
           used with Microsoft's [34m[1mActive Directory (ADS)[0m[1m[22m[132].  [34m[1mOpenLDAP[0m[1m[22m[133]
           is used to supply LDAP client support.

           The STYLE should be configured as password for this module.

           In general, authentication using LDAP is challenging because an
           LDAP name (a distinguished name, or DN) is typically long and often
           has a site-specific structure. For this reason, this module often
           requires more local expertise for configuring and testing than
           other [1mDACS [22mauthentication modules. At least a basic familiarity
           with LDAP will be required to configure this module.

           The module implements two different approaches to authentication:

            1. In the direct method, which is the simpler and more efficient
               approach, the [4mUSERNAME[24m argument is directly mapped to the
               corresponding DN. The module binds to that DN using the given
               [4mPASSWORD[24m. If the bind operation succeeds, the user has been
               authenticated.

            2. When the simpler method is not possible, the indirect method
               can be used to bind to the directory as an LDAP administrator
               (or an identity with the ability to search the appropriate
               portion of the directory tree) and perform an LDAP search
               operation for a directory entry having an attribute that
               matches the [4mUSERNAME[24m argument. If the search returns exactly
               one entry, it binds to that entry's DN using the [4mPASSWORD[0m
               argument; if the bind operation succeeds, the user has been
               authenticated.

       Regardless of the approach, after successful authentication it may be
       necessary to map the [4mUSERNAME[24m or the DN into a valid [1mDACS [22musername.

       The following configuration directives are specific to this module:

       LDAP_ADMIN_PASSWORD (Optional1)
           This is the password for the LDAP administrator account that
           corresponds to LDAP_ADMIN_URL.

       LDAP_ADMIN_URL (Required1-C)
           If the indirect method is used, this directive is required. This
           value is a URI like LDAP_USERNAME_URL except that it identifies the
           LDAP directory's administrator. Example:

               LDAP_ADMIN_URL
                 "ldap://example.com/cn=Administrator, cn=Users, dc=example, dc=com"


       LDAP_BIND_METHOD (Required1-C)
           This directive tells the module to use the direct method, indirect
           method, or both methods (case insensitive). When both are used, the
           indirect method is attempted only if the direct method fails.

       LDAP_ROLES_SELECTOR* (Optional)
           Since LDAP directory operations are usually relatively expensive,
           this module can return role information for the authenticated user,
           avoiding a second LDAP operation during Roles clause processing.
           Roles are typically extracted from information in the user's
           directory entry. Each occurrence of this directive specifies an
           expression that is evaluated by iterating through each attribute of
           the entry and making the attribute name ([4m${LDAP::attrname}[24m) and its
           value ([4m${LDAP::attrvalue}[24m) available. All of the entry's attribute
           names and values are made available within the LDAP namespace. If
           the result of the expression is a valid role string (which excludes
           the empty string, ""), it is added to the list of roles.

           An example:

               LDAP_ROLES_SELECTOR* '"${LDAP::attrname}" eq "memberOf" \
                   ? strtr(ldap(rdn_attrvalue, \
                       ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") \
                   : ""'

           For each instance of the entry's memberOf attribute, this
           expression selects the least significant (left-most) component of
           the attribute value (a DN) using [34m[1mldap()[0m[1m[22m[134] and converts spaces to
           underscores. If the user's entry contains:

               memberOf: CN=Domain Guests,CN=Users,DC=example,DC=com
               memberOf: CN=Guests,CN=Builtin,DC=example,DC=com

           the resulting roles would be Domain_Guests and Guests.

               [1mNote[0m
               These roles are discarded unless the [34m[1mSTYLE[0m[1m[22m[96] directive for
               this module allows the roles to be incorporated into the user's
               credentials.

       LDAP_SEARCH_FILTER (Required1-C)
           If the indirect method is used, either this directive or
           LDAP_SEARCH_FILTER* (but not both) must be configured. This search
           filter is used to select the unique directory entry that
           corresponds to this user.

       LDAP_SEARCH_FILTER* (Required1-C)
           If the indirect method is used, either this directive or
           LDAP_SEARCH_FILTER (but not both) must be configured. This search
           filter is used to select the unique directory entry that
           corresponds to this user. This directive is exactly like
           LDAP_SEARCH_FILTER except that it is evaluated just before it is
           used, allowing various elements of the execution context to appear
           in the string. Example:

               LDAP_SEARCH_FILTER* '"(sAMAccountName=${Args::USERNAME})"'


       LDAP_SEARCH_ROOT_DN (Required1-C)
           This is the root DN at which the indirect method should begin
           searching for user entries.

       LDAP_TIMEOUT_SECS (Optional1)
           This is a maximum time limit, in seconds, for any individual LDAP
           read or search operation performed by the module. If not specified,
           there will not be an application-specified time limit.

       LDAP_USERNAME_EXPR* (Optional1)
           If authentication succeeds, this directive is evaluated to yield
           the [1mDACS [22musername returned to [1mdacs_authenticate[22m. All of the entry's
           attribute names and values are made available within the LDAP
           namespace. If unspecified, the value of the [4mUSERNAME[24m parameter is
           returned. Example:

               LDAP_USERNAME_EXPR* '"${LDAP::sAMAccountName}"'


       LDAP_USERNAME_URL (Optional1)
           If the direct method is used, either this directive or
           [34m[1mLDAP_USERNAME_URL*[0m[1m[22m[135] (but not both) must be configured. This
           directive identifies both the LDAP server to use and the user being
           authenticated. The value of this directive is a URI (see [34m[1mRFC[0m
           [1m[34m2396[0m[1m[22m[136] and [34m[1mRFC 3986[0m[1m[22m[137]) that gives the name of the LDAP server
           to contact to authenticate the user (as the scheme and authority
           part of the URI) and the DN for the user (as the path part of the
           URI). The scheme must be either ldap or ldaps (case insensitive).
           If no port number is specified, 389 is used with the former scheme
           and 636 with the latter.

               LDAP_USERNAME_URL
                 '"ldap://example.com/cn=Auggie%20Doggie, cn=Users, dc=example, dc=com"'


               [1mSecurity[0m
               The ldaps scheme is not implemented. Communication between this
               module and the LDAP server should use a secure channel or at
               least not be snoopable.

       LDAP_USERNAME_URL* (Optional1)
           If the direct method is used, either this directive or
           LDAP_USERNAME_URL (but not both) must be configured. This directive
           is exactly like LDAP_USERNAME_URL except that it is evaluated just
           before it is used, allowing various elements of the execution
           context to appear in the string. Example:

               LDAP_USERNAME_URL*
                 '"ldap://example.com/cn=${Args::USERNAME}, cn=Users, dc=example, dc=com"'


           [1mTip[0m
           Before using LDAP authentication with [1mDACS[22m, you should first make
           sure that your LDAP server is functioning as you expect and that
           the host that will run the [1mlocal_ldap_authenticate [22mmodule can
           communicate with the LDAP server.

           One way to do this is to use the [34m[1mldapsearch(1)[0m[1m[22m[138] command (found
           in the clients/tools directory of the OpenLDAP distribution) to
           bind to the directory and perform some searches. You should run
           this command on the same machine that will be running [1mDACS[22m's LDAP
           authentication module ([1mlocal_ldap_authenticate[22m). Some of the
           information that you obtain from this exercise may be helpful when
           you configure [1mDACS [22mto use this form of authentication.

           Here are some examples to try - you must adapt the names for your
           environment:

               % ./ldapsearch -h win2k.example.com -x -b "dc=example,dc=com" \
                    -D "CN=Administrator,CN=Users,DC=example,DC=com" -W -LLL
               % ./ldapsearch -h win2k.example.com -x -b "dc=example,dc=com" \
                    -D "CN=Auggie Doggie,CN=Users,DC=example,DC=com" -W -LLL
               % ./ldapsearch -h win2k.example.com -x -b "dc=example,dc=com" \
                    -D "CN=Administrator,CN=Users,DC=example,DC=com" -W -LLL \
                    "(cn=Administrator)" memberOf
               % ./ldapsearch -h win2k.example.com -x -b "dc=example,dc=com" \
                    -D "CN=Administrator,CN=Users,DC=example,DC=com" -W -LLL \
                    "(sAMAccountName=auggie)"

           In these examples, the LDAP server runs on a host named
           win2k.example.com (so change win2k.example.com, example, and com),
           and it expects a user named "Auggie Doggie" to exist and have the
           account name "auggie" (again, change to names that exist in your
           LDAP directory). You should be prompted for the LDAP password (in
           Windows, that will be the login password) for either Administrator
           or a user named "Auggie Doggie", depending on the argument that
           follows the [1m-D [22mflag.

       The following configuration illustrates authentication using this
       module:

           <Auth id="ldap">
             URL "https://example.com/cgi-bin/dacs/local_ldap_authenticate"
             STYLE "password,add_roles"
             CONTROL "required"
             LDAP_BIND_METHOD "direct"
             LDAP_USERNAME_URL* '"ldap://windows.example.com/cn=" \
                . encode(url, ${Args::USERNAME}) . ",cn=Users,dc=example,dc=com"'
             LDAP_USERNAME_EXPR* '"${LDAP::sAMAccountName}"'
             LDAP_ROLES_SELECTOR* '"${LDAP::attrname}" eq "memberOf" \
               ? strtr(ldap(rdn_attrvalue, \
                   ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") \
               : 0'
           </Auth>

       Here, the LDAP authentication module will construct a DN by plugging
       the user-provided [4mUSERNAME[24m argument into the template and binding to
       that DN with the [4mPASSWORD[24m argument. If successful, the [1mDACS [22musername
       will be the value of the user's entry's sAMAccountName attribute, and
       roles will extracted from the entry's memberOf attribute values, as
       described above.

           [1mNote[0m
           In Windows, the SAM-Account-Name Active Directory attribute value
           (sAMAccountName) need not be the same as the entry's Common Name;
           for instance, the former might be "doggie" and the latter
           "CN=Auggie Doggie". The sAMAccountName must not exceed 20
           characters in length and must be unique within the domain. It is
           composed of printable characters other than the following:

               \   /   [   ]   :   ;   |   =   ,   +   *   ?   <   >   @   "

           The userPrincipalName attribute value is a user account name (or
           "user login name") that is unique within its domain and a domain
           name identifying the domain in which the user account is located.
           The format is the same as a domain-name based email address; e.g.,
           doggie@example.com.

       [1mlocal_native_authenticate[0m
           The [1mlocal_native_authenticate [22mmodule transfers a user's current,
           context-dependent web server identity to a [1mDACS [22midentity. The web
           server will most likely have used HTTP Basic or Digest
           authentication ([34m[1mRFC 2617[0m[1m[22m[60]). The user, having already been
           authenticated by the web server at a particular jurisdiction, will
           automatically be given [1mDACS [22mcredentials associated with that
           jurisdiction and typically having the same username.

           The STYLE should be configured as native for this module.

           This method of authentication also depends on a CGI helper program
           ([34m[1mautologin(8)[0m[1m[22m[139]) and appropriate configuration of [1mApache[0m
           authentication. The general idea is that the helper program must be
           executable only by users that have been properly authenticated by
           the web server (by any [1mApache [22mmethod and using any [1mApache[0m
           authentication module). The helper program then invokes
           [1mdacs_authenticate [22mwith appropriate arguments; if this module has
           been enabled and accepts its arguments, the user will be given [1mDACS[0m
           credentials.

           There are no directives or options specific to this module.

       [1mlocal_ntlm_authenticate[0m
           The [1mlocal_ntlm_authenticate [22mmodule authenticates users through
           Windows NT LAN Manager using the NTLM protocol [[34m[1m1[0m[1m[22m[140], [34m[1m2[0m[1m[22m[141]].
           This module, which makes use of [34m[1mSamba[0m[1m[22m[142] libraries, provides
           Windows [34m[1mNTLM authentication[0m[1m[22m[143] based on a username and password.
           The module does not need to be (and will not usually be) executed
           on the host running Windows.

           The STYLE should be configured as password for this module.

           The following OPTION directive values are understood:

           SAMBA_SERVER (Required1)
               The domain name or IP address in standard dot notation of the
               Windows system providing NTLM authentication.

           SAMBA_PORT (Optional1)
               The port number to use on SAMBA_SERVER. The default is 0, which
               tells Samba to use a sequence of default ports until one works.

           SAMBA_DOMAIN (Optional1)
               The domain name to use on SAMBA_SERVER. The default is "".

           The module-specific option SAMBA_SERVER must be given to provide
           the domain name of the host providing the NTLM authentication. The
           module-specific options SAMBA_DOMAIN and SAMBA_PORT, which are
           optional, can be used to override the default port(s) used by Samba
           to contact SAMBA_SERVER.

           The following illustrates how this module might be configured:

               <Auth id="ntlm">
                 URL "https://example.com/cgi-bin/dacs/local_ntlm_authenticate"
                 STYLE "pass"
                 CONTROL "sufficient"
                 OPTION 'SAMBA_SERVER="10.0.0.123"'
                 OPTION 'SAMBA_PORT="139"'
               </Auth>

           Here, [1mdacs_authenticate [22mwill invoke the NTLM authentication module
           at the given URL. That module will try to authenticate the username
           and password given to it by asking the NTLM service at port 139 on
           the Windows system at 10.0.0.213.

           There are no directives specific to this module.

               [1mSecurity[0m
               Attacks against some versions of NTLM [34m[1mhave been[0m
               [1m[34midentified[0m[1m[22m[144]. Communication between this module and the NTLM
               service should use a secure channel or at least not be
               snoopable.

               [1mTip[0m
               +o   A built-in version of this module can be selected by using
                   the URL local_ntlm_authenticate or just ntlm.

               +o   Before attempting to use this module, it may save a lot of
                   time and aggravation if you first check that it is possible
                   to authenticate against NTLM, [4mfrom[24m [4mthe[24m [4mmachine[24m [4mon[24m [4mwhich[24m [4myou[0m
                   [4mintend[24m [4mto[24m [4mrun[24m [4mthis[24m [4mmodule[24m, using a username/password
                   combination that you know is correct. If you are not able
                   to successfully authenticate in this way, obviously you
                   will not have any luck with the [1mDACS [22mmodule.

                   To test whether it is possible to authenticate using a
                   particular username and password, you may be able to use
                   [34m[1msmbclient(1)[0m[1m[22m[145]. For example, if C:\Shared is a network
                   shared folder or HPLaserJ-PS is a shared printer on the
                   Windows machine on which you want to perform
                   authentication, to authenticate as the Administrator try
                   something like:

                       % smbclient //mywinhost/shared -U Administrator

                   or to authenticate as the user bob, try:

                       % smbclient //mywinhost/HPLaserJ-PS -U bob

                   Replace [4mmywinhost[24m with the name of your Windows machine.
                   You should be prompted for the account's password. If
                   [1msmbclient [22msuccessfully connects and establishes a session
                   using the username and password you provide, then this
                   module should also be able to authenticate that user,
                   otherwise you should see an error message.

                   Before you have configured [1mDACS[22m, you can test NTLM
                   authentication from the command line using [34m[1mdacsauth(1)[0m[1m[22m[6].
                   For example, try something like:

                       % dacsauth -m ntlm passwd suff -OSAMBA_SERVER="windows.example.com" -prompt -u bob

                   Change "bob" to the username you want to authenticate and
                   "windows.example.com" to the domain name of the Windows
                   machine where the user's account is. You may also need to
                   specify [4mSAMBA_PORT[24m if a non-standard port is being used.
                   You will be prompted for the password for the user's
                   account The program's exit status indicates success ("ok"
                   is exit status 0) or failure (exit status 1). Repeat this
                   with an invalid password to make sure that it fails.

                   After you have configured [1mDACS[22m, there is another method of
                   testing [1mlocal_ntlm_authenticate [22mfrom the command line. Set
                   the environment variable [1mQUERY_STRING [22m(using your preferred
                   shell's syntax) to something like this:

                       % export QUERY_STRING="USERNAME=bob&PASSWORD=test&DACS_JURISDICTION=Test\
                       &SAMBA_SERVER=windows.example.com"

                   Change "bob" to the username you want to authenticate,
                   "test" to the password for that username, "Test" to the
                   name of the [1mDACS [22mjurisdiction that will perform the
                   authentication, and "windows.example.com" to the domain
                   name of the Windows machine where the user's account is.
                   You may also need to specify [4mSAMBA_PORT[24m. Then from the
                   distribution's src directory:

                       % ./local_ntlm_auth -uj Test

                   Use the [1m-u[22m, [1m-uj[22m, or [1m-us [22mflag to specify a jurisdiction that
                   you have configured (see [34m[1mdacs(1)[0m[1m[22m[146]). The output, an XML
                   document, indicates success ("ok", exit status 0) or
                   failure ("failed", exit status 1). Repeat this with an
                   invalid password to make sure that it fails. When you are
                   done, remember to delete the [1mQUERY_STRING [22menvironment
                   variable.

       [1mlocal_pam_authenticate[0m
           This module makes a local or remote Pluggable Authentication
           Modules (PAM) infrastructure available for authentication. PAM
           authenticates a user that is known to the PAM-capable operating
           system (i.e., a user with an existing account) through one or more
           PAM authentication service modules that have been configured by the
           system administrator. Other PAM operations, such as password
           management, are currently unsupported by [1mDACS[22m. Please refer to
           [34m[1mX/Open Single Sign-On Service (XSSO) -- Pluggable[0m
           [1m[34mAuthentication[0m[1m[22m[53] for additional information about PAM.

               [1mNotes[0m
               +o   The PAM-based infrastructure described here was mainly
                   developed to allow a system's PAM authentication services
                   to be used for [1mDACS [22mweb-based authentication. See
                   src/pamd.c for architectural details.

                   Although a prototype has been developed, no "native" PAM
                   authentication module for [1mDACS [22mis distributed. Such a
                   module might be used to provide Unix services with [1mDACS[0m
                   authentication and access control functionality,
                   conceptually allowing [34m[1mdacsauth(1)[0m[1m[22m[6] or [34m[1mdacscheck(1)[0m[1m[22m[147]
                   to be used by them. For instance, configuration for [1mftp[0m
                   authentication that normally uses [1mpam_unix.so [22mmight be
                   replaced by a reference to the module, leveraging any
                   password style of [1mDACS [22mauthentication, such as
                   [34m[1mlocal_ldap_authenticate[0m[1m[22m[49].

               +o   By default, the [1mpamd [22mserver uses "dacs" as the name of the
                   PAM service policy (see [34m[1mpam_start(3)[0m[1m[22m[148]). Some systems
                   may revert to a default policy (such as "other") if no
                   "dacs" policy is defined. A policy name can be specified as
                   a [1mpamd [22margument.

           There is a huge selection of open source and vendor-supplied PAM
           authentication modules for a wide variety of platforms, including
           some that provide functionality similar to that of [1mDACS[0m
           authentication modules [[34m[1mGNU/Linux[0m[1m[22m[149], [34m[1mFreeBSD[0m[1m[22m[150], [34m[1mmacOS[0m[1m[22m[151]].
           For example, [34m[1mpam_unix(8)[0m[1m[22m[152] performs essentially the same
           authentication function as [34m[1mlocal_unix_authenticate[0m[1m[22m[153], except
           that the latter is not interactive (it does not prompt).

           The STYLE should be configured as prompted for this module.

               [1mNote[0m
               While this authentication module has been tested with only a
               few PAM authentication service modules, in theory it should
               work with any conformant PAM authentication module. If this
               module is used, the current implementation does not allow any
               other authentication modules to be configured for the
               jurisdiction; this can be partially ameliorated by configuring
               PAM to try multiple PAM modules (yes, writing "PAM modules"
               might be incorrect in the same way that "[34m[1mATM[0m[1m[22m[154] machine" is).

               [1mImportant[0m
               The [1mlocal_pam_authenticate [22mmodule depends on functionality
               provided by [34m[1mpamd(8)[0m[1m[22m[155] running on a PAM-capable system, which
               does not need to be the same host where [1mlocal_pam_authenticate[0m
               is run. The [1mlocal_pam_authenticate [22mmodule establishes
               connections with [1mpamd[22m, which interacts with the [34m[1mpam(3)[0m[1m[22m[52]
               library. Unlike the other [1mDACS [22mauthentication styles,
               authentication using the prompted style may involve more than
               one request to [1mdacs_authenticate[22m, each of which supplies
               additional authentication material.

               The prompted authentication style implements a [4msession[24m between
               the user and the PAM library that consists of a sequence of
               operations that comprise a PAM [4mtransaction[24m. For each operation,
               [1mdacs_authenticate [22m(via [1mlocal_pam_authenticate [22mand [1mpamd[22m)
               supplies the PAM library with authentication material (either
               initial data or data requested by the PAM library from the
               previous operation), determines if authentication has succeeded
               or failed, or whether the user must be prompted for additional
               data. If the PAM library requires additional data, the user is
               prompted for it, and the response is submitted to
               [1mdacs_authenticate [22min the transaction's next operation.

           If PAM requires information from the user, [1mlocal_pam_authenticate[0m
           can be configured to prompt for it using one of three methods. The
           first method is used if the Auth clause has an OPTION directive
           that configures PAM_HANDLER_URL; the user will be redirected to
           this URL. The other possibilities are selected by the [4mFORMAT[0m
           argument (see [34m[1mdacs.services(8)[0m[1m[22m[81]). If any XML type is specified,
           the reply from [1mdacs_authenticate [22mwill conform to the DTD
           [34m[1mdacs_auth_reply.dtd[0m[1m[22m[82]. If HTML is specified and PAM
           authentication requires additional information from the user,
           [1mdacs_authenticate [22mwill return a rudimentary HTML form that must be
           completed and submitted by the user. For example, if [1mpam_unix [22mis
           configured, [1mdacs_authenticate [22mmay emit a web page that prompts for
           a username (if none was provided with the initial invocation of
           [1mdacs_authenticate[22m), and after that form has been submitted by the
           user emit a web page that prompts for a password.

           If PAM_HANDLER_URL is configured, the handler to which the
           administrator redirects users has complete control over user
           prompting. In most implementations, the handler will emit a web
           page that includes a form element, with appropriate inputs and
           hidden variables, which is submitted to the web service named in
           the [4mservice[24m argument (see below). The handler is required to obtain
           values for a set of requested variables and submit them to a given
           URL ([1mdacs_authenticate[22m). Each variable has a type, an optional
           descriptive text label, and a name. The value of PAM_HANDLER_URL
           may either be an absolute URL or a web service name, beginning with
           a '/', that is interpreted relative to the current jurisdiction
           (i.e., the [34m[1mdacs_url[0m[1m[22m[156] is prepended). Query arguments may be
           included, provided none of the argument names used by
           [1mdacs_authenticate[22m, described below, are duplicated.

           The [1mpamd [22mserver requires the handler to respond within [1m60 [22mseconds
           (configured at compile time). The [1mlocal_pam_authenticate [22mmodule
           requires [1mpamd [22mto respond to the initial request with the first
           prompt within [1m20 [22mseconds (configured at compile time). Should the
           handler encounter a serious error, it can simply terminate; this
           will cause [1mpamd [22mto eventually time out, which will abort the PAM
           transaction.

               [1mSecurity[0m
               The handler does not have to be [1mDACS[22m-wrapped, but ideally it
               should be. If it is, don't forget to add an access control rule
               to grant access to any user that might authenticate through
               [1mlocal_pam_authenticate[22m.

           This "prompter" service might be configured as follows:

               OPTION "PAM_HANDLER_URL=/dacs_pam_handler"

           This will be expanded into a URL that looks something like
           https://example.com/cgi-bin/dacs/dacs_pam_handler. When a user is
           redirected to this handler, [1mdacs_authenticate [22madds the following
           query arguments:

           +o    [4mservice[24m: This is the URL of the [1mdacs_authenticate [22mservice to
               which the handler must submit the requested values. This URL
               will not include any query arguments. Because private
               information, such as a password, may be present, it will
               typically use the https scheme. The handler should use the POST
               method to invoke [4mservice[24m.

           +o    [4mCSS_PATH[24m: This is the path configured for HTML stylesheets.

           +o    [4mAUTH_TRANSID[24m: This is the unique transaction identifier for
               this PAM interaction. As part of a single authentication
               transaction, the handler may be called several times with the
               same [4mAUTH_TRANSID[24m. The handler is not required to retain state
               between these calls, but it may do so. The handler must pass
               this argument when calling [4mservice[24m. Although the lifetime of
               this identifier is relatively brief, it should be kept private
               by the handler.

           +o    [4mauth_prompt_var_prefix[24m: Each requested value will be
               identified by an argument to [4mservice[24m having this prefix, with a
               positive integer ([4mint[24m, which is assigned consecutive integers
               starting with [1m1[22m) appended. For instance, if
               [4mauth_prompt_var_prefix[24m is "AUTH_PROMPT_VAR", then the handler
               must submit the requested values as [4mAUTH_PROMPT_VAR1[24m,
               [4mAUTH_PROMPT_VAR2[24m, and so on. The first absent [4mint[24m value signals
               the end of the variable argument list.

           +o    [4mTYPEint[24m: This is the type ("text", "password", or "error") of
               the variable numbered [4mint[24m. The password type indicates the
               value should not be displayed during user input.

           +o    [4mLABELint[24m: This argument, which is optional, indicates a label
               that might be displayed beside the user prompt (e.g.,
               "Username?") for variable [4mint[24m.

           +o    [4mNAMEint[24m: If this argument is not present for a given [4mint[24m, then
               no value is required for this variable - presumably [4mLABELint[24m is
               informational. If [4mNAMEint[24m is present, it gives the name of the
               variable to use when the handler submits the value. For
               example, suppose the handler is called with arguments [4mTYPE2[24m as
               "text", [4mLABEL2[24m as "Login:", and [4mNAME2[24m as "AUTH_PROMPT_VAR2".
               This asks the handler to prompt for text input labeled
               "Login:". If the user submits the value "Auggie", then included
               with the arguments to [4mservice[24m there should be a variable named
               [4mAUTH_PROMPT_VAR2[24m with the value "Auggie".

       Any other arguments to the handler should be forwarded to [4mservice[0m
       verbatim. Such arguments include [4mDACS_VERSION[24m, [4mDACS_JURISDICTION[24m,
       [4mDACS_BROWSER[24m, and [4mENABLE_AUTH_HANDLERS[24m.

           [1mNote[0m
           For testing purposes, it may be helpful to set PAM_HANDLER_URL to
           [1mdacs_prenv[22m, which will display the arguments passed to the handler
           and other context. The [1mDACS [22mdistribution includes an example
           handler, html/handlers/dacs_pam_handler.

       If an HTML form is emitted, its appearance can be customized somewhat
       through the default stylesheet [34m[1mlocal_pam_authenticate.css[0m[1m[22m[157]. The
       content of the generated web page can be customized through the
       local_pam_authenticate VFS item type. The following items relative to
       that item type are emitted if they exist:

       +o   header: Initial HTML to emit instead of the default.

       +o   prologue: HTML to emit immediately after the header.

       +o   instructions: HTML to emit immediately after the prologue and
           before the form.

       +o   form: Additional HTML to emit within the form.

       +o   epilogue: HTML to emit immediately after the form.

       +o   trailer: Final HTML to emit instead of the default.

       For example, consider the configuration directive:

           VFS "[local_pam_authenticate]dacs-fs:${Conf::DACS_HOME}/pam_auth"

       Here, pam_auth is the directory ${Conf::DACS_HOME}/pam_auth. If files
       named header and trailer exist in that directory, they are expected to
       contain the initial and final HTML content, respectively. These files
       consist of text and HTML markup but are not complete HTML documents.

       Customization of the HTML form is possible using configuration
       variables:

       +o    [4mprompt_submit_label[24m: the text label to put in the form's submit
           button.

       For example, the submit button's text can be specified using the
       directive:

           EVAL ${Conf::prompt_submit_label} = " Continue "


           [1mTip[0m
           A built-in version of this module can be selected by using the URL
           local_pam_authenticate or just pam.

       [1mlocal_passwd_authenticate[0m
           The [1mlocal_passwd_authenticate [22mmodule provides support for [1mDACS[0m
           identities, strictly private to [1mDACS[22m, through password-protected
           accounts (similar to what [1mApache[22m's [34m[1mmod_auth[0m[1m[22m[86] and
           [34m[1mmod_auth_dbm[0m[1m[22m[88] modules do, along with the [34m[1mhtpasswd(1)[0m[1m[22m[89]
           utility). A secure hash of a password is stored rather than the
           plaintext password itself. Several hashing methods are available
           (see [34m[1mPASSWORD_DIGEST[0m[1m[22m[158]).

           The [1mlocal_passwd_authenticate [22mmodule performs authentication by
           consulting the [4mUSERNAME[24m and [4mPASSWORD[24m parameters and comparing them
           to the information previously stored by the administrator.

               [1mSecurity[0m
               This module always requires the [4mPASSWORD[24m argument and will not
               accept the empty string as a password value (even if that
               actually is the password). Use [34m[1mlocal_simple_authenticate[0m[1m[22m[67]
               for password-less accounts.

           The STYLE should be configured as password for this module.

           The [34m[1mdacspasswd(1)[0m[1m[22m[159] utility is used to manage these accounts.
           The item type is "passwds".

           The following example configuration, which reflects typical usage,
           maintains user and password information in a plain text file named
           /usr/local/dacs/federations/passwd.

               VFS "[passwds]dacs-kwv-fs:/usr/local/dacs/federations/passwd"

           There are no directives or options specific to this module.

               [1mNote[0m
               The name "local_passwd_authenticate" may be a little confusing
               because there are other modules that implement some form of
               password-based authentication. This module might more
               appropriately be called "local_dacspasswd_authenticate".

               [1mTip[0m
               A built-in version of this module can be selected by using the
               URL local_passwd_authenticate or just passwd.

       [1mlocal_simple_authenticate[0m
           The [1mlocal_simple_authenticate [22mmodule supports [1mDACS [22midentities,
           strictly private to [1mDACS[22m, through accounts that are [4mnot[0m
           password-protected. The [1mlocal_simple_authenticate [22mmodule performs
           authentication by looking up an account named by the [4mUSERNAME[0m
           argument. In typical use, the username will be an email address,
           account or membership number, or random character string.

               [1mSecurity[0m
               This form of authentication is [4minherently[24m [4minsecure[24m because no
               password is provided. It is only appropriate when the
               consequences of a valid account name being guessed or
               misappropriated are of little concern, such as for restricted
               guest accounts. Administrators should not assume that using
               difficult-to-guess account names with this module offers much
               security. Keep in mind that depending on the larger context of
               how these identities are used, these usernames may be publicly
               visible.

           The STYLE should be configured as simple for this module.

           The [34m[1mdacspasswd(1)[0m[1m[22m[159] utility is used to manage these accounts.
           The item type is "simple".

           The following example configuration, which reflects typical usage,
           maintains user account information in a plain text file named
           /usr/local/dacs/federations/simple_accounts.

               VFS "[simple]dacs-kwv-fs:/usr/local/dacs/federations/simple_accounts"


               [1mNote[0m
               Although it is possible to combine password-protected accounts
               and password-less accounts in the same VFS object (i.e., with
               the item types passwds and simple pointing to the same file or
               database), putting them in separate objects is recommended.

           There are no directives or options specific to this module.

               [1mTip[0m
               A built-in version of this module can be selected by using the
               URL local_simple_authenticate or just simple.

       [1mlocal_tgma_authenticate[0m
           [4mExperimental[24m. The [1mlocal_tgma_authenticate [22mmodule, together with a
           TGMA server and client [4mvalidator[24m software, implements strong,
           interactive mutual authentication without the user having to input
           a password. The [1mlocal_tgma_authenticate [22mmodule supports [1mDACS[0m
           identities that are strictly private to [1mDACS[22m.

           The user begins the authentication procedure by using a simple
           sign-on page to submit an identity ([4mUSERNAME[24m and [4mJURISDICTION[24m). A
           password is not normally required. A special web-based utility
           returns a new web page to the user that displays instructions and
           another form that the user must submit when she is ready to
           complete the procedure. Next, and within a configurable window of
           time, the user must prove his ownership of the identity by
           executing a secure validation protocol. The validation protocol is
           conducted from a device, such as a smart phone or tablet, which
           runs the custom validator app and has been configured with account
           information for the user's identity at the jurisdiction.

           This authentication module sends an authentication request message
           to a TGMA server. The TGMA server executes an authentication
           protocol with a user's [4mvalidator[24m and returns the result to the
           module. The TGMA server is a light-weight daemon that may serve one
           or more jurisdictions. The mutual authentication protocol, based on
           Secure Remote Password authentication ([34m[1mRFC 2945[0m[1m[22m[160], [34m[1mRFC[0m
           [1m[34m5054[0m[1m[22m[161]), verifies the user's identity using account information
           available to the module, TGMA server, and the validator. The user's
           validator confirms the identity of the TGMA server, and indirectly,
           the jurisdiction. Communication between the TGMA server and the
           module may use TCP, SSL, or UDP, depending on configuration.
           Likewise, communication between the TGMA server and a validator may
           also use TCP, SSL, or UDP. Choice of the networking protocol will
           depend on security, performance, and connectivity dependencies. An
           instance of the TGMA server must have network connectivity with
           both users' validator devices and instances of this authentication
           module. In a larger organization it will likely run on a firewall
           or DMZ-located server.

           The STYLE should be configured as tgma for this module.

       [1mlocal_token_authenticate[0m
           This module works in concert with the [34m[1mdacstoken(1)[0m[1m[22m[162] utility to
           support one-time passwords. Two-factor authentication, a strong
           authentication method, is supported by combining hardware
           token-based one-time passwords ("something you have") with a PIN (a
           password, "something you know"). Software-based clients may also be
           used. The implementation follows [34m[1mRFC 4226[0m[1m[22m[163], which has been
           adopted by [34m[1mOATH[0m[1m[22m[164], and other standards. Please refer to
           [34m[1mdacstoken(1)[0m[1m[22m[162] for complete details.

           The STYLE should be configured as password for this module.

           In addition to the usual [4mUSERNAME[24m argument, the module requires the
           [4mPASSWORD[24m argument to be the next one-time password (e.g., the value
           produced by the user's hardware token). If the user's [1mDACS [22maccount
           has a PIN associated with it, the PIN must be passed as the
           [4mAUXILIARY[24m argument. The PIN referred to here is the one managed by
           [1mdacstoken[22m, not a PIN that may be entered into the token device to
           unlock it.

           One-time password generation depends on a secret that is shared
           between the client and [1mDACS[22m, and a non-repeating value that may be
           based on synchronized counters or clocks. The client's token can
           become unsynchronized with the server's state. This can happen for
           many reasons, such as if a password is generated by the device but
           not used, if a password or PIN is typed incorrectly, or because of
           a configuration error. The method can tolerate a configurable
           deviation of the client's token from the server's state; that is,
           provided the client's password falls within a window of [4mN[24m from the
           one expected by [1mDACS[22m, [1mDACS [22mwill accept the client's token. For
           counter-based tokens, only the "forward" side of the window is
           examined, so [1mDACS [22mcan "catch up" to the client.

           If the user's password does not fall within the window, it is
           deemed to have become unsynchronized with [1mlocal_token_authenticate[0m
           and authentication will fail. The user can attempt to resynchronize
           by entering a sequence of passwords as [4mPASSWORD[24m, using a comma to
           separate them. Three consecutive, valid passwords are required
           (this number can be configured at build time). If the account has a
           PIN, it must be provided to enable synchronization. If
           synchronization succeeds, the user's account information is
           corrected and the module also reports successful authentication. If
           synchronization fails, the module also fails and a [1mDACS[0m
           administrator must be contacted to resynchronize the token.

               [1mNote[0m
               The token value must be entered exactly as it is displayed on
               the token. Leading zeroes must be typed, for example, and no
               spaces or punctuation are allowed. Whenever authentication
               fails, the user must obtain a new password from the token.

           The following OPTION directive value is understood:

           ACCEPT_WINDOW (Optional1)
               The (non-negative) size of the acceptance window for one-time
               passwords, overriding the default. If the size is zero, [1mDACS[0m
               will only consider a match with the expected password and will
               not try to match the user's password against "nearby"
               passwords. With some modes of operation, only forward matches
               are allowed.

               [1mTip[0m
               A built-in version of this module can be selected by using the
               URL local_token_authenticate or just token.

       [1mlocal_unix_authenticate[0m
           The [1mlocal_unix_authenticate [22mmodule implements native Unix
           username/password authentication, allowing a user having a
           pre-existing Unix account to be authenticated by [1mDACS [22musing the
           username and password for that account. Normally, the user's hashed
           password is compared to the string obtained by hashing the [4mPASSWORD[0m
           argument. But because some platforms do not make stored passwords
           available to applications (most notably macOS), a second algorithm
           can be used; if it is enabled and the [34m[1mpam(3)[0m[1m[22m[165] library is
           available, a simple PAM policy is used to validate the plaintext
           password provided.

           In the password comparison algorithm, the [34m[1mgetpwnam(3)[0m[1m[22m[166] library
           function is passed the [4mUSERNAME[24m parameter given to
           [1mdacs_authenticate[22m. It can be configured for systems with or without
           shadow passwords. On some Unix systems, when the [34m[1myp(8)[0m[1m[22m[167]
           password database is enabled, the [34m[1mgetpwnam(3)[0m[1m[22m[166] function will
           use the YP map "passwd.byname" if the requested password entry is
           not found in the local database. If the account information is
           obtained, the [4mPASSWORD[24m parameter is validated.

           In the PAM-based algorithm, the [4mUSERNAME[24m and [4mPASSWORD[24m parameters
           given to [1mdacs_authenticate [22mare passed to the PAM module (e.g.,
           [34m[1mpam_unix(8)[0m[1m[22m[152]) that has been configured by an administrator.
           This method is separate and much simpler than what is provided by
           [34m[1mlocal_pam_authenticate[0m[1m[22m[39]. To help protect against
           misconfiguration, any unexpected behaviour by PAM will cause
           authentication to fail. For example, the password prompt string
           produced by PAM must match "Password:", ignoring trailing spaces;
           currently, this default can only be changed at compile time.

           The STYLE should be configured as password for this module.

           The following OPTION directive values are understood:

           PAM_SERVICE (Optional1)
               This is the name of the PAM [4mservice[24m [4mpolicy[24m to use. If
               unspecified, a compile-time default (DEFAULT_PAM_SERVICE, set
               to "dacs-unix-auth") is used. The name of the service policy
               will usually identify a file (for instance,
               /etc/pam.d/dacs-unix-auth) that might simply contain something
               like:

                   auth        required    pam_unix.so     no_warn

               An existing policy file may be available or it may be necessary
               to create one. On macOS, for example, /etc/pam.d/chkpasswd
               contains the following entry, which is sufficient for password
               validation:

                   auth       required       pam_opendirectory.so

               To use that file with this module, the following [1mDACS[0m
               configuration directive would be placed in the appropriate Auth
               clause:

                   OPTION "PAM_SERVICE=chkpasswd"

               See [34m[1mpam_start(3)[0m[1m[22m[148] and [34m[1mpam.conf(5)[0m[1m[22m[168].

               Depending on the operating system, PAM modules might be found
               in /usr/lib, /usr/lib/pam, or /lib/security.

               It is possible to configure the PAM service policy to use a
               password-based "auth" facility other than the Unix password
               module, but do so with care.

           USE_PAM (Optional1)
               If "yes" or "on", only use the PAM-based algorithm, if "no" or
               "off", do not use the PAM-based algorithm, and if "both",
               "try", or unspecified, use the PAM-based method only if the
               password comparison algorithm is unavailable. These string
               values are case insensitive.

               [1mTip[0m
               A built-in version of this module can be selected by using the
               URL local_unix_authenticate or just unix. If the built-in
               version is used, [1mdacs_authenticate [22mmust be setuid root, and if
               the web-based version is used, [1mlocal_unix_authenticate [22mmust be
               setuid root, so that the shadow password file can be read
               and/or the PAM module used. Authentication using this module
               will fail if it does not execute with sufficient priviledges.

               [1mNote[0m
               On platforms where encrypted passwords are unavailable, such as
               macOS, authentication will always fail unless the PAM-based
               algorithm is available and enabled.

   [1mRoles[0m
       Each user authenticated by [1mDACS [22mmay be associated with one or more
       roles. The [34m[1msyntax of roles and role descriptors[0m[1m[22m[14] is described
       elsewhere. Role-based group membership is discussed in
       [34m[1mdacs.groups(5)[0m[1m[22m[169]. Configuration of a Roles clause is optional and if
       none are specified, an empty role descriptor string will be used. If
       more than one Roles clause is configured, their role strings are
       concatenated (duplicates are not removed). If a roles service fails, it
       is treated as if it returned no roles and processing continues
       normally.

       Like authentication, a modular mechanism is used to find the roles with
       which a user is associated. A roles module, analogous to an
       authentication module, can be called by [1mdacs_authenticate [22mto return
       roles. A roles service returns a roles_reply element (see
       [34m[1mroles_reply.dtd[0m[1m[22m[170]).

       Each Roles element must have an id attribute. Its value is merely a
       label (an alphabetic followed by zero or more alphanumerics, hyphens,
       and underscores) that allows the clause to be referenced. The id
       attribute values must be unique (case-sensitively) within the clause's
       Jurisdiction section.

           [1mNote[0m
           A maximum limit is imposed on the length of a role descriptor
           string. Please refer to the [34m[1mROLE_STRING_MAX_LENGTH[0m[1m[22m[171] directive.

   [1mRoles Clause Directives[0m
       The roles directives are largely analogous to the authentication
       directives.

       When evaluation of the Roles clauses begins, several variables are
       available in the Auth namespace to reflect the outcome of
       authentication. These variables may be useful when determining the
       user's roles: [4mDACS_USERNAME[24m, [4mDACS_IDENTITY[24m, [4mDACS_JURISDICTION[24m, and
       [4mDACS_VERSION[24m.

       [1mRoles Clause Directives Index:[0m

        1. EXIT* (Optional1)

        2. EXPR (Optional1)

        3. INIT* (Optional1)

        4. OPTION (Optional)

        5. OPTION* (Optional)

        6. PREDICATE (Optional1)

        7. URL (Optional1)

        8. URL* (Optional1)

       URL (Optional1)
       URL* (Optional1)
           Exactly one of these two directives must be specified, unless EXPR
           is specified, in which case neither URL nor URL* may be specified.
           These directives specify the URL to be used to invoke the roles
           module (or is the name of a built-in module). The difference
           between the two directives is that the value of URL* is an
           expression that is evaluated to determine the URL to be used; this
           evaluation occurs immediately before the module is invoked.

       INIT* (Optional1)
           An expression can be specified that is to be evaluated immediately
           prior to the URL* and EXPR expressions, all of which are evaluated
           before a module is invoked.

       EXIT* (Optional1)
           If authentication is successful, this expression is evaluated
           immediately after the module is executed or EXPR evaluated.

       EXPR (Optional1)
           This directive gives an expression that is evaluated to obtain
           roles instead of invoking a roles module. Please refer to Advanced
           Techniques.

       OPTION (Optional)
           Similar to the Auth clause's [34m[1mOPTION[0m[1m[22m[50] directive, this is used to
           pass an argument to the roles module. A given [4mname[24m may not be
           specified more than once within a particular Roles clause. The
           Options namespace is initialized with [4mDACS_USERNAME[24m,
           [4mDACS_JURISDICTION[24m, and [4mDACS_VERSION[24m variables. If these are
           specified by an OPTION, the argument ordinarily used will be
           overridden.

           For example:

               OPTION "PASSWORD=bobo"

           causes PASSWORD=bobo to be passed as a POST method parameter.

       OPTION* (Optional)
           The given expression is evaluated before the module is called, and
           after all OPTION directives and all OPTION* directives that appear
           earlier. The value of the expression must be a [4mname[24m=[4mvalue[24m pair, as
           with the OPTION directive, and overrides any [4mname[24m in the Options
           namespace.

       PREDICATE (Optional1)
           If provided, this expression is evaluated before any other roles
           module processing is done. If there is an evaluation error or it
           returns [1mFalse [22m(zero or the empty string), processing of the clause
           terminates and the next Roles clause, if any, is processed.
           Otherwise, processing of the clause continues normally.

   [1mRoles Clause Control Flow[0m
       If authentication succeeds, Roles clauses are processed in which they
       appear, but only if [34m[1mset_roles[0m[1m[22m[70] has not been specified for some
       authentication module's STYLE.

       A Roles clause is processed in a sequence of steps, and with various
       hooks to provide fine-grained control. Before the first clause is
       examined, the variables [4m${Auth::CURRENT_ROLES}[24m and [4m${Auth::LAST_ROLES}[0m
       are initialized to the role string, if any, obtained during
       authentication module processing. Processing of each Roles clause
       proceeds as follows:

        1. If the clause has a PREDICATE directive, it is evaluated in the
           current context. If the value is not [1mTrue [22mthe clause is not
           evaluated further. No variables are updated. If the expression was
           invalid, processing of roles is terminated.

        2. If the clause has an INIT* directive, it is evaluated; if an error
           occurs, processing of roles is terminated.

        3. If the clause has a URL* directive, it is evaluated to obtain the
           URL of the [1mDACS [22mroles service to be invoked; if an error occurs,
           processing of roles is terminated. If the clause has an EXPR*
           directive, it is evaluated to obtain the role string; if an error
           occurs during evaluation it is treated as if the expression
           returned the empty string.

        4. If a roles service has been specified, it is invoked. If an error
           occurs, roles processing [4mcontinues[24m [4mas[24m [4mif[24m [4mthe[24m [4mmodule[24m [4mreturned[24m [4mthe[0m
           [4mempty[24m [4mstring[24m [4mfor[24m [4mthe[24m [4mrole[24m [4mstring[24m.

        5. The variable [4m${Auth::LAST_ROLES}[24m is set to the roles string
           returned by the module or expression.

        6. If the clause has an EXIT* directive, it is evaluated; if an error
           occurs, processing of roles is terminated. The value of
           [4m${Auth::LAST_ROLES}[24m becomes the role string returned by the clause.

        7. The role string returned by the clause is appended to the variable
           [4m${Auth::CURRENT_ROLES}[24m.

       The value of [4m${Auth::CURRENT_ROLES}[24m when the last module has been
       processed is the roles string that will be used in the generated
       credentials.

           [1mTip[0m
           Some roles modules are available as built-in components of
           [1mdacs_authenticate[22m. These modules are identified by specific
           relative URLs; a module's description will provide its built-in
           name when this capability is available. The built-in capability
           will automatically be provided if the module has been enabled at
           build-time. The same applies for [1mdacsauth[22m.

           Although it will be more efficient (and possibly more secure) to
           use a built-in module, they are executed on the same host as
           [1mdacs_authenticate [22m(thereby giving up some flexibility), access
           control rules are not applied to them (other than the one for
           [1mdacs_authenticate[22m), and [1mdacs_authenticate [22mmay need to be executed
           setuid (probably as root) or setgid (as www, for example) so that
           it can access password files.

   [1mRoles Modules[0m
       If and only if authentication succeeds, [1mDACS [22mcan request the user's
       role descriptor from the jurisdiction. Roles modules are always invoked
       using the POST method and are passed the following arguments:

       [4mDACS_USERNAME[0m
           The [4musername[24m component of the user's [1mDACS [22midentity.

       [4mDACS_JURISDICTION[0m
           The name of the jurisdiction that authenticated [4mDACS_USERNAME[24m.

       [4mDACS_VERSION[0m
           The DACS_VERSION_NUMBER for this version of [1mdacs_authenticate[22m.

       OPTION directives
           For each [34m[1mOPTION directive[0m[1m[22m[172] or [34m[1mOPTION* directive[0m[1m[22m[173] in the
           Roles section being processed, the variable name and its value are
           passed.
       Any of the standard web service arguments will also be accepted;
       anything else will be ignored.

       Roles modules return an [34m[1mroles_reply.dtd[0m[1m[22m[170] document to
       [1mdacs_authenticate[22m.

           [1mNote[0m
           Although there is a roles module for obtaining LDAP or ADS roles,
           you may also get them by authenticating through
           [34m[1mlocal_ldap_authenticate[0m[1m[22m[49] or by using a Roles clause with an
           appropriate EXPR directive.

       [1mRoles Module Index:[0m

        1. local_roles: Private [1mDACS [22mroles

        2. local_ldap_roles: Roles imported from an LDAP/ADS directory

        3. local_unix_roles: Roles imported from Unix group membership

       [1mlocal_roles[0m
           This roles service consults a private list to obtain a
           username-to-roles mapping using [1mDACS [22mvirtual storage (the item type
           is "roles"). The following example configuration, which reflects
           typical usage, maintains mappings in a plain text file named
           /usr/local/dacs/federations/roles.

               VFS "[roles]dacs-kwv-fs:/usr/local/dacs/federations/roles"

           The file /usr/local/dacs/federations/roles might look something
           like this:

               admin:dacs,admin
               rick:metalogic,guests
               bobo:staff,users
               auggie:staff,users

           Here, user auggie is associated with the roles staff and users.

               [1mTip[0m
               A built-in version of this module can be selected by using the
               URL local_roles or just roles.

       [1mlocal_ldap_roles[0m
           This roles service returns roles derived from the attributes of a
           user's LDAP/ADS directory entry. This module is based on
           [34m[1mlocal_ldap_authenticate[0m[1m[22m[49]; please consult the description and
           examples presented with that authentication module for additional
           information.

               [1mNote[0m
               The user need not have been authenticated by LDAP/ADS for this
               module to be used. For example, the user can be authenticated
               on a Unix system but his roles can come from LDAP/ADS.

           The following configuration directives are recognized by this
           module. They function identically to the directives of the same
           name used by [34m[1mlocal_ldap_authenticate[0m[1m[22m[49], so for the most part
           their descriptions will not be repeated here.

               [1mNote[0m
               These module directives must be passed using either [34m[1mOPTION[0m[1m[22m[172]
               or [34m[1mOPTION*[0m[1m[22m[173] directives. Ensure that the option value is
               properly quoted.

           LDAP_BIND_METHOD (Required1-C)
               This tells the module how to find the user's entry in the
               directory.

           LDAP_USERNAME_URL (Optional1)
           LDAP_USERNAME_URL* (Optional1)
               With the direct method, one of these options is used to name
               the user's entry as a URI.

           LDAP_ADMIN_URL (Required1-C)
               If the indirect method is used, this option is required. This
               value is a URI like LDAP_USERNAME_URL except that it identifies
               the LDAP administrator within the directory.

           LDAP_ADMIN_PASSWORD (Optional1)
               This is the password for the LDAP administrator account that
               corresponds to LDAP_ADMIN_URL.

           LDAP_SEARCH_ROOT_DN (Required1-C)
               This is the root DN at which the indirect method should begin
               searching for user entries.

           LDAP_SEARCH_FILTER (Required1-C)
           LDAP_SEARCH_FILTER* (Required1-C)
               If the indirect method is used, either this option or
               LDAP_SEARCH_FILTER* (but not both) must be configured. This
               search filter is used to select the unique directory entry that
               corresponds to this user. The LDAP_SEARCH_FILTER* option is
               exactly like LDAP_SEARCH_FILTER except that it is evaluated
               just before it is used, allowing various elements of the
               execution context to appear in the string. The [1mDACS [22musername
               obtained from the preceding authentication phase can be
               referenced as [4m${Args::DACS_USERNAME}[24m.

           LDAP_USERNAME_EXPR* (Optional1)
               This option is evaluated to yield a username that can be
               referenced by the LDAP_ROLES_SELECTOR* option as
               [4m${LDAP::USERNAME}[24m.

           LDAP_ROLES_SELECTOR* (Optional)
               Each occurrence of this directive specifies an expression that
               is evaluated by iterating through each attribute of the entry
               and making the attribute name ([4m${LDAP::attrname}[24m) and its value
               ([4m${LDAP::attrvalue}[24m) available. All of the entry's attribute
               names and values are made available within the LDAP namespace.
               If the result of the expression is a valid role string (which
               excludes the empty string, ""), it is added to the list of
               roles.

           LDAP_TIMEOUT_SECS (Optional1)
               This is a maximum time limit, in seconds, for any individual
               LDAP read or search operation performed by the module. If not
               specified, there will not be an application-specified time
               limit.

           Here is an example that binds to the directory on x.example.com as
           the administrator, searches for the entry for the account of the
           authenticated user, and assigns the user a role from the attribute
           value of each memberOf attribute in the entry:

               <Roles id="ldap_roles">
               URL "http://example.com/cgi-bin/dacs/local_ldap_roles"
               OPTION "LDAP_BIND_METHOD=indirect"
               OPTION \
               'LDAP_ADMIN_URL="ldap://x.example.com/CN=Administrator,CN=Users,DC=example,DC=com"'
               OPTION 'LDAP_ADMIN_PASSWORD="secretpassword"'

               OPTION 'LDAP_SEARCH_ROOT_DN="cn=Users,dc=example,dc=com"'
               OPTION 'LDAP_SEARCH_FILTER*=\'"(sAMAccountName=${Args::DACS_USERNAME})"\''

               OPTION 'LDAP_ROLES_SELECTOR*=\'"${LDAP::attrname}" eq "memberOf" \
                   ? strtr(ldap(rdn_attrvalue, \
                       ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") \
                   : ""\''
               </Roles>

           For example, the resulting role string might look like:

               DnsAdmins,Print_Operators,Domain_Admins,Administrators


       [1mlocal_unix_roles[0m
           This roles service returns the Unix group membership associated
           with an authenticated username; that it, the resulting list of
           roles is the same as would be obtained if the user ran the Unix
           [34m[1mgroups(1)[0m[1m[22m[174].

               [1mNote[0m
               The user need not have been authenticated as this username on
               the Unix system where this service is run.

               [1mTip[0m
               A built-in version of this module can be selected by using the
               URL local_unix_roles or just unix.

   [1mRelated Services[0m
       The [34m[1mdacs_current_credentials(8)[0m[1m[22m[35] web service displays elements of
       each set of credentials sent with the request. The [34m[1mdacs_signout(8)[0m[1m[22m[175]
       service is typically called from a browser to cause one or more cookies
       (each representing a [1mDACS [22midentity) to be deleted. Cookies are
       automatically deleted when a browser terminates, but it is sometimes
       useful to explicitly logoff.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mNOTES[0m
       A separate but similar mechanism called "affiliated [1mDACS [22mfederations"
       supports cross-federation single sign-on; see [34m[1mdacs_auth_transfer(8)[0m[1m[22m[8].

       [1mdacs_authenticate [22mcould be modified to temporarily disable an account
       after some number of unsuccessful login attempts over a certain time
       period. The flip side of such a feature is that it could be used in a
       denial of service attack. Rather than disabling an account, a
       designated administrator might receive an email notification or a
       console message might be logged.

       It might be worthwhile to include a rule-based mechanism, called after
       the user has been identified but before credentials are returned, to
       decide whether authentication should be permitted. This might be used,
       for example, to restrict a particular user to login from a specified IP
       address or range of addresses, or limit the time of day at which login
       is allowed.

[1mBUGS[0m
       It would be nice to provide assistance to programs that generate login
       pages. Composing modules should be easier, to make multi-factor
       authentication more accessible.

[1mSEE ALSO[0m
       [34m[1mdacsauth(1)[0m[1m[22m[6], [34m[1mdacscred(1)[0m[1m[22m[176], [34m[1mdacscookie(1)[0m[1m[22m[9], [34m[1mdacs.exprs(5)[0m[1m[22m[3],
       [34m[1mdacs_autologin_ssl(8)[0m[1m[22m[177], [34m[1mautologin(8)[0m[1m[22m[139], [34m[1mdacs_auth_agent(8)[0m[1m[22m[7],
       [34m[1mdacs_auth_transfer(8)[0m[1m[22m[8], [34m[1mdacs_current_credentials(8)[0m[1m[22m[35],
       [34m[1mdacs_select_credentials(8)[0m[1m[22m[46], [34m[1mdacs_signout(8)[0m[1m[22m[175], [34m[1mpamd(8)[0m[1m[22m[155]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[178])

[1mCOPYING[0m
       Copyright (C) 2003-2016 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[179] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        3. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

        4. html/examples
           http://dacs.dss.ca/man//examples

        5. HTTP Authentication
           http://dacs.dss.ca/man/dacs_acs.8.html#http_authentication

        6. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

        7. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

        8. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

        9. dacscookie(1)
           http://dacs.dss.ca/man/dacscookie.1.html

       10. Auth clause
           http://dacs.dss.ca/man/#auth_clause

       11. CONTROL
           http://dacs.dss.ca/man/#CONTROL

       12. username
           http://dacs.dss.ca/man/dacs.1.html#dacs_identity

       13. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html#revocation_list

       14. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#naming

       15. credentials.dtd
           http://dacs.dss.ca/man/../dtd-xsd/credentials.dtd

       16. VERIFY_IP
           http://dacs.dss.ca/man/dacs.conf.5.html#VERIFY_IP

       17. natd(8)
           http://www.freebsd.org/cgi/man.cgi?query=natd&apropos=0&sektion=8&manpath=FreeBSD+10.1-RELEASE&format=html

       18. VERIFY_UA
           http://dacs.dss.ca/man/dacs.conf.5.html#VERIFY_UA

       19. AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS

       20. Advanced Encryption Standard
           https://en.wikipedia.org/wiki/Advanced_Encryption_Standard

       21. Federal Information Processing Standard
           http://www.nist.gov/itl/fips.cfhttp://www.nist.gov/itl/fips.cfm

       22. FIPS 198
           http://csrc.nist.gov/publications/fips/fips198-1/FIPS-198-1_final.pdf

       23. RFC 2104
           http://www.rfc-editor.org/rfc/rfc2104.txt

       24. RFC 4635
           http://www.rfc-editor.org/rfc/rfc4635.txt

       25. RFC 4868
           http://www.rfc-editor.org/rfc/rfc4868.txt

       26. NIST
           http://www.nist.gov/

       27. FIPS 180-1
           http://www.itl.nist.gov/fipspubs/fip180-1.htm

       28. RFC 4634
           http://www.rfc-editor.org/rfc/rfc4634.txt

       29. RFC 6234
           http://www.rfc-editor.org/rfc/rfc6234.txt

       30. FIPS 180-4
           http://csrc.nist.gov/publications/fips/fips180-4/fips-180-4.pdf

       31. MD5 algorithm
           http://www.rfc-editor.org/rfc/rfc1321.txt

       32. Netscape HTTP Cookies Specification
           http://web.archive.org/web/20070805052634/http://wp.netscape.com/newsref/std/cookie_spec.html

       33. [4mCOOKIE_SYNTAX[0m
           http://dacs.dss.ca/man/#COOKIE_SYNTAX

       34. COOKIE_NAME_TERMINATORS
           http://dacs.dss.ca/man/dacs.conf.5.html#COOKIE_NAME_TERMINATORS

       35. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       36. COOKIE_PATH
           http://dacs.dss.ca/man/dacs.conf.5.html#COOKIE_PATH

       37. SECURE_MODE
           http://dacs.dss.ca/man/dacs.conf.5.html#SECURE_MODE

       38. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

       39. local_pam_authenticate
           http://dacs.dss.ca/man/#local_pam_authenticate

       40. RFC 2109
           http://www.rfc-editor.org/rfc/rfc2109.txt

       41. RFC 2965
           http://www.rfc-editor.org/rfc/rfc2965.txt

       42. RFC 6265
           http://www.rfc-editor.org/rfc/rfc6265.txt

       43. RFC 2616
           http://www.rfc-editor.org/rfc/rfc2616.txt

       44. colons are used within cookie names
           http://dacs.dss.ca/man/#cookie-name-syntax

       45. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

       46. dacs_select_credentials(8)
           http://dacs.dss.ca/man/dacs_select_credentials.8.html

       47. [1mstrtr()[0m
           http://dacs.dss.ca/man/dacs.exprs.5.html#strtr

       48. LDAP_USERNAME_URL
           http://dacs.dss.ca/man/#LDAP_USERNAME_URL

       49. local_ldap_authenticate
           http://dacs.dss.ca/man/#local_ldap_authenticate

       50. OPTION
           http://dacs.dss.ca/man/#OPTION

       51. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#auth_clause

       52. pam(3)
           http://www.freebsd.org/cgi/man.cgi?query=pam&apropos=0&sektion=0&manpath=FreeBSD+10.1-RELEASE&format=html

       53. X/Open Single Sign-On Service (XSSO) preliminary specification
           http://www.opengroup.org/pubs/catalog/p702.htm

       54. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#merging

       55. Authenticating Using an Expression
           http://dacs.dss.ca/man/#expr

       56. PASSWORD_CONSTRAINTS
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_CONSTRAINTS

       57. LOG_FILTER
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_FILTER

       58. local_cas_authenticate
           http://dacs.dss.ca/man/#local_cas_authenticate

       59. Central Authentication Service (CAS)
           https://en.wikipedia.org/wiki/Central_Authentication_Service

       60. RFC 2617
           http://www.rfc-editor.org/rfc/rfc2617.txt

       61. local_apache_authenticate
           http://dacs.dss.ca/man/#local_apache_authenticate

       62. Information Card
           http://en.wikipedia.org/wiki/Information_Card

       63. dacsinfocard(1)
           http://dacs.dss.ca/man/dacsinfocard.1.html

       64. dacs_infocard(8)
           http://dacs.dss.ca/man/dacs_infocard.8.html

       65. dacs_managed_infocard(8)
           http://dacs.dss.ca/man/dacs_managed_infocard.8.html

       66. local_infocard_authenticate
           http://dacs.dss.ca/man/#local_infocard_authenticate

       67. local_simple_authenticate
           http://dacs.dss.ca/man/#local_simple_authenticate

       68. local_tgma_authenticate
           http://dacs.dss.ca/man/#local_tgma_authenticate

       69. add_roles
           http://dacs.dss.ca/man/#add_roles

       70. set_roles
           http://dacs.dss.ca/man/#set_roles

       71. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html#variables

       72. AUTH_SUCCESS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_SUCCESS

       73. AUTH_SUCCESS_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_SUCCESS_HANDLER

       74. AUTH_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_ERROR_HANDLER

       75. AUTH_FAIL_DELAY_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_FAIL_DELAY_SECS

       76. [4mDACS_AUTH_SUCCESS_HANDLER[0m
           http://dacs.dss.ca/man/#DACS_AUTH_SUCCESS_HANDLER

       77. [4mENABLE_AUTH_HANDLERS[0m
           http://dacs.dss.ca/man/#ENABLE_AUTH_HANDLERS

       78. dacs_prenv(8)
           http://dacs.dss.ca/man/dacs_prenv.8.html

       79. Environment variables
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#envvars

       80. mod_ssl
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html

       81. dacs.services(8)
           http://dacs.dss.ca/man/dacs.services.8.html#FORMAT

       82. dacs_auth_reply.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_auth_reply.dtd

       83. dacs_current_credentials.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_current_credentials.dtd

       84. auth_reply.dtd
           http://dacs.dss.ca/man/../dtd-xsd/auth_reply.dtd

       85. dacs.install(7)
           http://dacs.dss.ca/man//man/dacs.install.7.html

       86. [1mmod_auth[0m
           http://httpd.apache.org/docs-2.2/mod/mod_auth.html

       87. [1mmod_auth_digest[0m
           http://httpd.apache.org/docs-2.2/mod/mod_auth_digest.html

       88. [1mmod_auth_dbm[0m
           http://httpd.apache.org/docs-2.2/mod/mod_auth_dbm.html

       89. htpasswd(1)
           http://httpd.apache.org/docs/2.2/programs/htpasswd.html

       90. htdigest(1)
           http://httpd.apache.org/docs/2.2/programs/htdigest.html

       91. htdbm(1)
           http://httpd.apache.org/docs/2.2/programs/htdbm.html

       92. local_native_authenticate
           http://dacs.dss.ca/man/#local_native_authenticate

       93. Central Authentication Service (CAS)
           http://www.jasig.org/cas

       94. CAS 2.0 Protocol
           http://www.jasig.org/cas/protocol

       95. OpenID
           http://openid.net/

       96. STYLE
           http://dacs.dss.ca/man/#STYLE

       97. SSLVerifyClient
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#sslverifyclient

       98. SSLRequire
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#sslrequire

       99. OpenSSL
           http://www.openssl.org

       00. SSLOptions
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#ssloptions

       01. dacsgrid(1)
           http://dacs.dss.ca/man/dacsgrid.1.html

       02. Google
           http://www.google.com

       03. account authentication
           http://code.google.com/apis/accounts/AuthForInstalledApps.html

       04. eBay
           http://developer.ebay.com/developercenter/rest/

       05. Yahoo!
           http://developer.yahoo.com/auth/

       06. announced
           http://blogs.msdn.com/b/card/archive/2011/02/15/beyond-windows-cardspace.aspx

       07. CardSpace
           http://en.wikipedia.org/wiki/Windows_CardSpace

       08. Windows 8
           http://en.wikipedia.org/wiki/List_of_features_removed_in_Windows_8

       09. On the Demise of CardSpace
           http://upon2020.com/blog/2011/03/on-the-demise-of-cardspace/

       10. Open Cardspace opportunity
           http://blogs.law.harvard.edu/doc/2011/02/16/open-cardspace-opportunity/

       11. Personal Reflections on the CardSpace Journey
           http://self-issued.info/?p=458

       12. From CardSpace to Verified Claims
           http://www.identityblog.com/?p=1164

       13. Change will come: the present is untenable
           http://www.identityblog.com/?p=1165

       14. The Clay Feet of Giants?
           http://www.identityblog.com/?p=1167

       15. RIP, Windows CardSpace. Hello, U-Prove
           http://www.zdnet.com/blog/microsoft/rip-windows-cardspace-hello-u-prove/8717

       16. U-Prove
           http://research.microsoft.com/en-us/projects/u-prove/

       17. Identity Selector Interoperability Profile (ISIP) 1.5
           http://download.microsoft.com/download/1/1/a/11ac6505-e4c0-4e05-987c-6f1d31855cd2/Identity_Selector_Interoperability_Profile_V1.5.pdf

       18. role descriptor string
           http://dacs.dss.ca/man/dacs.1.html#roles

       19. dacs_infocard(8)
           http://dacs.dss.ca/man/dacs_infocard.8.html#about_claims

       20. expression-based authentication style
           http://dacs.dss.ca/man//man/dacs_authenticate.8.html#expr

       21. dacs_managed_infocard(8)
           http://dacs.dss.ca/man//man/dacs_managed_infocard.8.html

       22. dacs.conf(5)
           http://dacs.dss.ca/man//man/dacs.conf.5.html#INFOCARD_prefixed

       23. dacs_mex(8)
           http://dacs.dss.ca/man//man/dacs_mex.8.html

       24. dacs_sts(8)
           http://dacs.dss.ca/man//man/dacs_sts.8.html

       25. Using InfoCards With DACS
           http://dacs.dss.ca/man/using-infocards-with-dacs.html

       26. [4mIdentity[24m [4mSelector[24m [4mInteroperability[24m [4mProfile[24m [4mspecification[24m [4mand[0m
           [4mcompanion[24m [4mguides[0m
           http://www.microsoft.com/downloads/details.aspx?FamilyID=b94817fc-3991-4dd0-8e85-b73e626f6764&DisplayLang=en

       27. [4mIntroducing[24m [4mWindows[24m [4mCardSpace[0m
           http://msdn.microsoft.com/en-us/library/aa480189.aspx

       28. RFC 2251
           http://www.faqs.org/rfcs/rfc2251.html

       29. RFC 2252
           http://www.faqs.org/rfcs/rfc2252.html

       30. RFC 2253
           http://www.faqs.org/rfcs/rfc2253.html

       31. RFC 3377
           http://www.faqs.org/rfcs/rfc3377.html

       32. Active Directory (ADS)
           http://www.microsoft.com/windows2000/technologies/directory/ad/default.asp

       33. OpenLDAP
           http://www.openldap.org

       34. ldap()
           http://dacs.dss.ca/man/dacs.exprs.5.html#ldap

       35. LDAP_USERNAME_URL*
           http://dacs.dss.ca/man/#LDAP_USERNAME_URL*

       36. RFC 2396
           http://www.faqs.org/rfcs/rfc2396.html

       37. RFC 3986
           http://www.rfc-editor.org/rfc/rfc3986.txt

       38. ldapsearch(1)
           http://www.openldap.org/software/man.cgi?query=ldapsearch&apropos=0&sektion=0&manpath=OpenLDAP+2.4-Release&format=html

       39. autologin(8)
           http://dacs.dss.ca/man/autologin.8.html

       40. 1
           http://curl.haxx.se/rfc/ntlm.html

       41. 2
           http://msdn.microsoft.com/en-us/library/cc236621%28PROT.10%29.aspx

       42. Samba
           http://www.samba.org

       43. NTLM authentication
           https://en.wikipedia.org/wiki/NTLM

       44. have been identified
           http://support.microsoft.com/kb/2793313

       45. smbclient(1)
           http://www.samba.org/samba/docs/man/manpages-3/smbclient.1.html

       46. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       47. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

       48. pam_start(3)
           http://www.freebsd.org/cgi/man.cgi?query=pam_start&apropos=0&sektion=3&manpath=FreeBSD+10.1-RELEASE&format=html

       49. GNU/Linux
           http://www.kernel.org/pub/linux/libs/pam/modules.html

       50. FreeBSD
           http://www.freebsd.org/doc/en_US.ISO8859-1/articles/pam/pam-freebsd-modules.html

       51. macOS
           https://developer.apple.com/library/mac/documentation/Darwin/Reference/ManPages/man3/pam.3.html

       52. pam_unix(8)
           http://www.freebsd.org/cgi/man.cgi?query=pam_unix&apropos=0&sektion=8&manpath=FreeBSD+10.1-RELEASE&format=html

       53. local_unix_authenticate
           http://dacs.dss.ca/man/#local_unix_authenticate

       54. ATM
           https://en.wikipedia.org/wiki/Cash_machine

       55. pamd(8)
           http://dacs.dss.ca/man/pamd.8.html

       56. dacs_url
           http://dacs.dss.ca/man/dacs.groups.5.html#group_syntax

       57. local_pam_authenticate.css
           http://dacs.dss.ca/man//css/local_pam_authenticate.css

       58. PASSWORD_DIGEST
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_DIGEST

       59. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

       60. RFC 2945
           http://www.rfc-editor.org/rfc/rfc2945.txt

       61. RFC 5054
           http://www.rfc-editor.org/rfc/rfc5054.txt

       62. dacstoken(1)
           http://dacs.dss.ca/man/dacstoken.1.html

       63. RFC 4226
           http://www.rfc-editor.org/rfc/rfc4226.txt

       64. OATH
           http://www.openauthentication.org

       65. pam(3)
           http://www.freebsd.org/cgi/man.cgi?query=pam&apropos=0&sekti
           on=0&manpath=FreeBSD+10.1-RELEASE&format=html

       66. getpwnam(3)
           http://www.freebsd.org/cgi/man.cgi?query=getpwnam&apropos=0&sektion=3&manpath=FreeBSD+10.1-RELEASE&format=html

       67. yp(8)
           http://www.freebsd.org/cgi/man.cgi?query=yp&apropos=0&sektion=8&manpath=FreeBSD+10.1-RELEASE&format=html

       68. pam.conf(5)
           http://www.freebsd.org/cgi/man.cgi?query=pam.conf&apropos=0&sektion=5&manpath=FreeBSD+10.1-RELEASE&format=html

       69. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

       70. roles_reply.dtd
           http://dacs.dss.ca/man/../dtd-xsd/roles_reply.dtd

       71. ROLE_STRING_MAX_LENGTH
           http://dacs.dss.ca/man/dacs.conf.5.html#ROLE_STRING_MAX_LENGTH

       72. OPTION directive
           http://dacs.dss.ca/man/#r_OPTION

       73. OPTION* directive
           http://dacs.dss.ca/man/#r_OPTION*

       74. groups(1)
           http://www.freebsd.org/cgi/man.cgi?query=groups&apropos=0&sektion=1&manpath=FreeBSD+10.1-RELEASE&format=html

       75. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       76. dacscred(1)
           http://dacs.dss.ca/man/dacscred.1.html

       77. dacs_autologin_ssl(8)
           http://dacs.dss.ca/man/dacs_autologin_ssl.8.html

       78. www.dss.ca
           http://www.dss.ca

       79. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.38a                      11/23/2016              DACS_AUTHENTICATE(8)
