import sys
from os import listdir
from os.path import isdir, isfile, join

def display_tree(directory='.', prefix=''):
    """Filesystem tree view"""
    files = listdir(directory)
    files.sort()
    for f in files:
        print prefix + '|-- ' + f
        fullname = join(directory, f)
        if isdir(fullname):
            display_tree(fullname, prefix + '|   ')
 
if __name__ == "__main__":
    if len(sys.argv) > 1:
        display_tree(directory=sys.argv[1])
    else:
        display_tree()
