// ---------------------------------------------------------------------
// $Id: memory_consumption.cc 30037 2013-07-18 16:55:40Z maier $
//
// Copyright (C) 2000 - 2013 by the deal.II authors
//
// This file is part of the deal.II library.
//
// The deal.II library is free software; you can use it, redistribute
// it, and/or modify it under the terms of the GNU Lesser General
// Public License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// The full text of the license can be found in the file LICENSE at
// the top level of the deal.II distribution.
//
// ---------------------------------------------------------------------

#include <deal.II/base/memory_consumption.h>

DEAL_II_NAMESPACE_OPEN


namespace MemoryConsumption
{
  std::size_t
  memory_consumption (const std::vector<std::string> &v)
  {
    std::size_t mem = sizeof(v);
    for (unsigned int i=0; i<v.size(); ++i)
      mem += memory_consumption(v[i]);
    return mem;
  }


}

DEAL_II_NAMESPACE_CLOSE
