#! /usr/bin/env python
# -*- coding: utf-8 -*-

import os
import os.path

po_dir = "po"
templates = ("desktopnova",
             "desktopnova-module-gnome",
             "desktopnova-module-xfce",
             "desktopnova-tray")

languages = {
"ar"    : "Arabic",
"cs"    : "Czech",
"de"    : "German",
"es"    : "Spanish",
"fr"    : "French",
"gl"    : "Galician",
"hu"    : "Hungarian",
"it"    : "Italian",
"nl"    : "Dutch",
"pl"    : "Polish",
"pt"    : "Portuguese",
"pt_BR" : "Brazilian Portuguese",
"ru"    : "Russian",
"tr"    : "Turkish",
"zh_CN" : "Simplified Chinese"
}

pos = []
langs = []

def get_lang(lang):
    if lang in languages:
        return languages[lang]
    else:
        return "UNKNOWN LANGUAGE"

def get_pos(directory):
    pos = []
    entries = os.listdir(directory)
    entries.sort()

    for entry in entries:
        if entry[-3:] == ".po":
            pos.append(entry[:-3])

    return pos

def get_translators(lang):
    translators = []

    for i in range(0, len(pos)):
        if lang in pos[i]:
            name = os.path.join(po_dir, templates[i], lang + ".po")

            record = -1
            f = open(name, "r")
            for line in f:
                line = line.strip()

                if line == "":
                    record = -1

                if record == 0:
                    translator = line[1:-1]
                    translator = translator.strip()
                    if translator[-2:] == "\\n":
                        translator = translator[:-2]

                    if ((translator != "") and
                        (translator not in translators)):
                        translators.append(translator)

                if record > 0:
                    record -= 1

                if line == 'msgid "translator-credits"':
                    record = 2
            f.close()

    translators.sort(key=str.lower)
    return translators

for template in templates:
    directory = os.path.join(po_dir, template)
    pos.append(get_pos(directory))


for template in pos:
    for po in template:
        if po not in langs:
            langs.append(po)

langs.sort()
spacing = False

print """Translators:
============
(This is an automatically generated list of all translators.)
"""

for lang in langs:
    if spacing:
        print
        print
    else:
        spacing = True

    print "%s (%s) Translator(s):" % (get_lang(lang), lang)
    translators = get_translators(lang)
    for translator in translators:
        print "  %s" % translator

