#
# spec file for package gambas3
#
# copyright (c) 2024 munix9@googlemail.com
#
# Generated by the 'gambas-package-config' tool on Fri, 24 Jan 2025 08:10:25 GMT
#


Name:           gambas3
Version:        3.20.1
Release:        -20250123
Summary:        Complete visual development environment for Gambas
License:        GPL-2.0-or-later
URL:            https://gambas.sourceforge.net
Source0:        gambas-%{version}.tar.gz
Source99:       gambas-openSUSE.rpmlintrc
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  git
BuildRequires:  hicolor-icon-theme
BuildRequires:  libtool
BuildRequires:  make
BuildRequires:  pkgconfig
BuildRequires:  xdg-utils
BuildRequires:  pkgconfig(libffi)
Requires: %{name}-dev = %{version}
Requires: %{name}-dev-tools = %{version}
Requires: %{name}-devel = %{version}
Requires: %{name}-gb-args = %{version}
Requires: %{name}-gb-cairo = %{version}
Requires: %{name}-gb-chart = %{version}
Requires: %{name}-gb-clipper = %{version}
Requires: %{name}-gb-clipper2 = %{version}
Requires: %{name}-gb-complex = %{version}
Requires: %{name}-gb-compress = %{version}
Requires: %{name}-gb-compress-bzlib2 = %{version}
Requires: %{name}-gb-compress-zlib = %{version}
Requires: %{name}-gb-compress-zstd = %{version}
Requires: %{name}-gb-crypt = %{version}
Requires: %{name}-gb-data = %{version}
Requires: %{name}-gb-db = %{version}
Requires: %{name}-gb-db-form = %{version}
Requires: %{name}-gb-db-mysql = %{version}
Requires: %{name}-gb-db-odbc = %{version}
Requires: %{name}-gb-db-postgresql = %{version}
Requires: %{name}-gb-db-sqlite3 = %{version}
Requires: %{name}-gb-db2 = %{version}
Requires: %{name}-gb-db2-form = %{version}
Requires: %{name}-gb-db2-mysql = %{version}
Requires: %{name}-gb-db2-odbc = %{version}
Requires: %{name}-gb-db2-postgresql = %{version}
Requires: %{name}-gb-db2-sqlite3 = %{version}
Requires: %{name}-gb-dbus = %{version}
Requires: %{name}-gb-dbus-trayicon = %{version}
Requires: %{name}-gb-desktop = %{version}
Requires: %{name}-gb-desktop-gnome-keyring = %{version}
Requires: %{name}-gb-desktop-x11 = %{version}
Requires: %{name}-gb-eval-highlight = %{version}
Requires: %{name}-gb-form = %{version}
Requires: %{name}-gb-form-dialog = %{version}
Requires: %{name}-gb-form-editor = %{version}
Requires: %{name}-gb-form-htmlview = %{version}
Requires: %{name}-gb-form-mdi = %{version}
Requires: %{name}-gb-form-print = %{version}
Requires: %{name}-gb-form-stock = %{version}
Requires: %{name}-gb-form-terminal = %{version}
Requires: %{name}-gb-gmp = %{version}
Requires: %{name}-gb-gsl = %{version}
Requires: %{name}-gb-gtk = %{version}
Requires: %{name}-gb-gtk-opengl = %{version}
Requires: %{name}-gb-gtk3 = %{version}
Requires: %{name}-gb-gtk3-opengl = %{version}
Requires: %{name}-gb-gtk3-webview = %{version}
Requires: %{name}-gb-highlight = %{version}
Requires: %{name}-gb-httpd = %{version}
Requires: %{name}-gb-image = %{version}
Requires: %{name}-gb-image-effect = %{version}
Requires: %{name}-gb-image-imlib = %{version}
Requires: %{name}-gb-image-io = %{version}
Requires: %{name}-gb-inotify = %{version}
Requires: %{name}-gb-libxml = %{version}
Requires: %{name}-gb-logging = %{version}
Requires: %{name}-gb-map = %{version}
Requires: %{name}-gb-markdown = %{version}
Requires: %{name}-gb-media = %{version}
Requires: %{name}-gb-media-form = %{version}
Requires: %{name}-gb-memcached = %{version}
Requires: %{name}-gb-mime = %{version}
Requires: %{name}-gb-mysql = %{version}
Requires: %{name}-gb-ncurses = %{version}
Requires: %{name}-gb-net = %{version}
Requires: %{name}-gb-net-curl = %{version}
Requires: %{name}-gb-net-pop3 = %{version}
Requires: %{name}-gb-net-smtp = %{version}
Requires: %{name}-gb-openal = %{version}
Requires: %{name}-gb-opengl = %{version}
Requires: %{name}-gb-opengl-glsl = %{version}
Requires: %{name}-gb-opengl-glu = %{version}
Requires: %{name}-gb-opengl-sge = %{version}
Requires: %{name}-gb-openssl = %{version}
Requires: %{name}-gb-option = %{version}
Requires: %{name}-gb-pcre = %{version}
Requires: %{name}-gb-pdf = %{version}
Requires: %{name}-gb-poppler = %{version}
Requires: %{name}-gb-qt5 = %{version}
Requires: %{name}-gb-qt5-ext = %{version}
Requires: %{name}-gb-qt5-opengl = %{version}
Requires: %{name}-gb-qt5-webkit = %{version}
Requires: %{name}-gb-qt5-webview = %{version}
Requires: %{name}-gb-qt6 = %{version}
Requires: %{name}-gb-qt6-ext = %{version}
Requires: %{name}-gb-qt6-opengl = %{version}
Requires: %{name}-gb-qt6-webview = %{version}
Requires: %{name}-gb-report = %{version}
Requires: %{name}-gb-report2 = %{version}
Requires: %{name}-gb-scanner = %{version}
Requires: %{name}-gb-sdl = %{version}
Requires: %{name}-gb-sdl-sound = %{version}
Requires: %{name}-gb-sdl2 = %{version}
Requires: %{name}-gb-sdl2-audio = %{version}
Requires: %{name}-gb-settings = %{version}
Requires: %{name}-gb-signal = %{version}
Requires: %{name}-gb-term = %{version}
Requires: %{name}-gb-term-form = %{version}
Requires: %{name}-gb-util = %{version}
Requires: %{name}-gb-util-web = %{version}
Requires: %{name}-gb-v4l = %{version}
Requires: %{name}-gb-vb = %{version}
Requires: %{name}-gb-web = %{version}
Requires: %{name}-gb-web-feed = %{version}
Requires: %{name}-gb-web-form = %{version}
Requires: %{name}-gb-web-gui = %{version}
Requires: %{name}-gb-xml = %{version}
Requires: %{name}-gb-xml-html = %{version}
Requires: %{name}-gb-xml-rpc = %{version}
Requires: %{name}-gb-xml-xslt = %{version}
Requires: %{name}-gui = %{version}
Requires: %{name}-gui-opengl = %{version}
Requires: %{name}-gui-webview = %{version}
Requires: %{name}-ide = %{version}
Requires: %{name}-runtime = %{version}
Requires: %{name}-scripter = %{version}
%if 0%{?suse_version} < 1600
BuildRequires:  gcc11-PIE
BuildRequires:  gcc11-c++
%else
BuildRequires:  gcc-c++
%endif

%description
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This package doesn't include anything: it is a metapackage that installs the IDE and all the available Gambas components.

%package ide
Summary:        Visual development environment for the Gambas programming language
License:        GPL-2.0-or-later AND OFL-1.1 AND MIT
Requires: %{name}-runtime = %{version}
Requires: %{name}-dev-tools = %{version}
Requires: %{name}-gui-webview = %{version}
Requires: %{name}-gb-clipper = %{version}
Requires: %{name}-gb-db2 = %{version}
Requires: %{name}-gb-db2-form = %{version}
Requires: %{name}-gb-desktop = %{version}
Requires: %{name}-gb-form = %{version}
Requires: %{name}-gb-form-dialog = %{version}
Requires: %{name}-gb-form-editor = %{version}
Requires: %{name}-gb-form-htmlview = %{version}
Requires: %{name}-gb-form-mdi = %{version}
Requires: %{name}-gb-form-print = %{version}
Requires: %{name}-gb-form-stock = %{version}
Requires: %{name}-gb-form-terminal = %{version}
Requires: %{name}-gb-highlight = %{version}
Requires: %{name}-gb-image = %{version}
Requires: %{name}-gb-markdown = %{version}
Requires: %{name}-gb-net = %{version}
Requires: %{name}-gb-net-curl = %{version}
Requires: %{name}-gb-pcre = %{version}
Requires: %{name}-gb-settings = %{version}
Requires: %{name}-gb-signal = %{version}
Requires: %{name}-gb-term = %{version}
Requires: %{name}-gb-util = %{version}
Requires: %{name}-gb-util-web = %{version}
Requires:       gettext-tools
Requires:       gzip
Requires:       tar
Requires:       unzip
Requires:       zip
Recommends:     autoconf
Recommends:     automake
Recommends:     pngquant
Recommends:     patch
Recommends:     rpm-build
Recommends:     translate-shell
BuildArch:      noarch

%description ide
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This package includes the Gambas Development Environment.

%package runtime
Summary:        Gambas runtime interpreter
Recommends:     (gcc or clang)
Provides:       %{name}-gb-geom = %{version}
Obsoletes:      %{name}-gb-geom < %{version}
Provides:       %{name}-gb-gui = %{version}
Obsoletes:      %{name}-gb-gui < %{version}
Provides:       %{name}-gb-hash = %{version}
Obsoletes:      %{name}-gb-hash < %{version}
Provides:       %{name}-gb-jit = %{version}
Obsoletes:      %{name}-gb-jit < %{version}
Provides:       %{name}-gb-test = %{version}
Obsoletes:      %{name}-gb-test < %{version}

%description runtime
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This package includes the Gambas interpreter needed to run Gambas applications, and some components having no dependency except the 'libc' system library.

%package scripter
Summary:        Gambas scripter
Requires:       %{name}-dev-tools = %{version}
Requires:       %{name}-gb-pcre = %{version}
Requires:       %{name}-runtime = %{version}
Provides:       %{name}-script = %{version}
Obsoletes:      %{name}-script < %{version}
BuildArch:      noarch

%description scripter
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This package includes the scripter program that allows to write script files in Gambas and to serve Gambas webpages when run with another name.

%package dev-tools
Summary:        Gambas compilation tools
Requires:       %{name}-runtime = %{version}
Requires:       gettext-runtime
Provides:       %{name}-devel = %{version}
Obsoletes:      %{name}-devel < %{version}
Provides:       %{name}-dev = %{version}
Obsoletes:      %{name}-dev < %{version}

%description dev-tools
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This package includes all tools needed to compile Gambas projects without having to install the complete development environment. It includes the Gambas compiler, archiver, informer and help generator.

%package benchmark
Summary:        Gambas/Perl/Python/Java benchmarks
Requires:       %{name}-gb-args = %{version}
Requires:       %{name}-scripter = %{version}
Requires:       java-headless >= 11
BuildArch:      noarch

%description benchmark
Gambas is a free development environment based on a Basic interpreter
with object extensions, like Visual Basic(tm) (but it is NOT a clone!).

Gambas/Perl/Python/Java scripts to compare benchmark.

%package examples
Summary:        Example projects provided with Gambas
Requires:       %{name}-ide = %{version}
BuildArch:      noarch

%description examples
Gambas is a free development environment based on a Basic interpreter
with object extensions, like Visual Basic(tm) (but it is NOT a clone!).

This package includes example projects provided with Gambas.

%package gui
Summary:        Gambas GUI metapackage
Requires:       %{name}-gb-gtk = %{version} or %{name}-gb-gtk3 = %{version} or %{name}-gb-qt5 = %{version} or %{name}-gb-qt6 = %{version}

%description gui
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This package doesn't include anything: it is a metapackage that installs one of the GUI component packages.

%package gui-opengl
Summary:        Gambas GUI OpenGL metapackage
Requires:       %{name}-gb-gtk-opengl = %{version} or %{name}-gb-gtk3-opengl = %{version} or %{name}-gb-qt5-opengl = %{version} or %{name}-gb-qt6-opengl = %{version}

%description gui-opengl
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This package doesn't include anything: it is a metapackage that installs one of the GUI OpenGL component packages.

%package gui-webview
Summary:        Gambas GUI webview metapackage
Requires:       %{name}-gb-gtk3-webview = %{version} or %{name}-gb-qt5-webview = %{version} or %{name}-gb-qt6-webview = %{version}

%description gui-webview
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This package doesn't include anything: it is a metapackage that installs all one of the GUI webview component packages.

%package gb-cairo
Summary: Gambas bindings for cairo
BuildRequires:  pkgconfig(cairo)
Requires:       %{name}-runtime = %{version}
Requires:       %{name}-gb-image = %{version}

%description gb-cairo
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component includes Gambas bindings for the cairo graphics library.

%package gb-clipper
Summary: Gambas Clipper component (deprecated)
License:        GPL-2.0-or-later AND BSL-1.0
Requires:       %{name}-runtime = %{version}

%description gb-clipper
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides an interface to the Clipper library.
This component is deprecated.

%package gb-clipper2
Summary: Gambas Clipper2 component
License:        GPL-2.0-or-later AND BSL-1.0
Requires:       %{name}-runtime = %{version}

%description gb-clipper2
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides an interface to the Clipper2 library.

%package gb-compress-bzlib2
Summary: Gambas bzlib2 component
BuildRequires:  pkgconfig(bzip2)
Requires:       %{name}-gb-compress = %{version}

%description gb-compress-bzlib2
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to compress/uncompress data or files with the bzip2 algorithm.

%package gb-compress-zlib
Summary: Gambas zlib compression component
BuildRequires:  pkgconfig(zlib)
Requires:       %{name}-gb-compress = %{version}

%description gb-compress-zlib
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to compress/uncompress data or files with the gzip and PKZIP algorithm.

%package gb-compress-zstd
Summary: Gambas zstd component
BuildRequires:  pkgconfig(libzstd)
Requires:       %{name}-gb-compress = %{version}

%description gb-compress-zstd
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to compress/uncompress data or files with the zstd algorithm.

%package gb-db-mysql
Summary: MySQL driver for the Gambas database (deprecated version)
BuildRequires:  pkgconfig(libmariadb)
Requires:       %{name}-gb-db = %{version}

%description gb-db-mysql
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to access MySQL databases.
This component is deprecated.

%package gb-db-odbc
Summary: ODBC driver for the Gambas database (deprecated version)
BuildRequires:  pkgconfig(odbc)
Requires:       %{name}-gb-db = %{version}

%description gb-db-odbc
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to access to databases via unixODBC drivers from Gambas code.
This component is deprecated.

%package gb-db-postgresql
Summary: PostgreSQL driver for the Gambas database (deprecated version)
BuildRequires:  postgresql-devel
Requires:       %{name}-gb-db = %{version}

%description gb-db-postgresql
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to access PostgreSQL databases.
This component is deprecated.

%package gb-db-sqlite3
Summary: Gambas sqlite3 driver database (deprecated version)
BuildRequires:  pkgconfig(sqlite3)
Requires:       %{name}-gb-db = %{version}

%description gb-db-sqlite3
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to access sqlite3 databases.
This component is deprecated.

%package gb-db2-mysql
Summary: MySQL driver for the Gambas database
BuildRequires:  pkgconfig(libmariadb)
Requires:       %{name}-gb-db2 = %{version}

%description gb-db2-mysql
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to access MySQL databases.

%package gb-db2-odbc
Summary: ODBC driver for the Gambas database
BuildRequires:  pkgconfig(odbc)
Requires:       %{name}-gb-db2 = %{version}

%description gb-db2-odbc
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to access databases via unixODBC drivers.

%package gb-db2-postgresql
Summary: PostgreSQL driver for the Gambas database
BuildRequires:  postgresql-devel
Requires:       %{name}-gb-db2 = %{version}

%description gb-db2-postgresql
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to access PostgreSQL databases.

%package gb-db2-sqlite3
Summary: Gambas sqlite3 driver database
BuildRequires:  pkgconfig(sqlite3)
Requires:       %{name}-gb-db2 = %{version}

%description gb-db2-sqlite3
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to access sqlite3 databases.

%package gb-dbus
Summary: Gambas bindings for DBUS
BuildRequires:  pkgconfig(dbus-1)
Requires: %{name}-runtime = %{version}

%description gb-dbus
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component includes Gambas bindings for the DBUS system.

%package gb-desktop
Summary: Gambas desktop compatibility component
Requires:       %{name}-gb-desktop-x11 = %{version}
Requires:       %{name}-gb-image = %{version}
Requires:       %{name}-runtime = %{version}
Requires:       xdg-utils
Recommends:     libsecret-tools

%description gb-desktop
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides a common interface to access some standard desktop features. The Portland project (http://portland.freedesktop.org/wiki/) xdg utilities are used.

%package gb-desktop-gnome-keyring
Summary: Desktop component driver for Gnome keyring (deprecated)
BuildRequires:  pkgconfig(gnome-keyring-1)
Requires:       %{name}-gb-desktop = %{version}
Provides:       %{name}-gb-desktop-gnome = %{version}
Obsoletes:      %{name}-gb-desktop-gnome < %{version}

%description gb-desktop-gnome-keyring
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows to retrieve and store passwords in the old Gnome keyring.
This component is deprecated.

%package gb-desktop-x11
Summary: X11 support for the desktop compatibility component
BuildRequires:  pkgconfig(xtst)
Requires:       %{name}-gb-desktop = %{version}
Requires:       %{name}-gb-image = %{version}

%description gb-desktop-x11
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides X11 support for the 'gambas3-gb-desktop' package.

%package gb-gmp
Summary: Gambas GMP component
BuildRequires:  gmp-devel
Requires: %{name}-runtime = %{version}

%description gb-gmp
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides an interface to the GNU Multiple Precision Arithmetic Library.

%package gb-gsl
Summary: Gambas GNU Scientific Library component
BuildRequires:  pkgconfig(gsl)
Requires: %{name}-runtime = %{version}

%description gb-gsl
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows to use the GNU Scientific Library.

%package gb-gtk
Summary: Gambas GTK+ component
BuildRequires:  pkgconfig(fribidi)
BuildRequires:  pkgconfig(gdk-pixbuf-2.0)
BuildRequires:  pkgconfig(gtk+-2.0)
BuildRequires:  pkgconfig(gtkglext-1.0)
BuildRequires:  pkgconfig(ice)
BuildRequires:  pkgconfig(librsvg-2.0)
BuildRequires:  pkgconfig(pango)
BuildRequires:  pkgconfig(sm)
Requires:       %{name}-gb-image = %{version}
Provides:       %{name}-gui = %{version}

%description gb-gtk
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

These are the GTK+ components for Gambas.

%package gb-gtk3
Summary: Gambas GTK+3 component
BuildRequires:  pkgconfig(fribidi)
BuildRequires:  pkgconfig(gdk-pixbuf-2.0)
BuildRequires:  pkgconfig(gdk-wayland-3.0)
BuildRequires:  pkgconfig(gdk-x11-3.0)
BuildRequires:  pkgconfig(gtk+-3.0)
BuildRequires:  pkgconfig(gtkglext-1.0)
BuildRequires:  pkgconfig(ice)
BuildRequires:  pkgconfig(librsvg-2.0)
BuildRequires:  pkgconfig(pango)
BuildRequires:  pkgconfig(sm)
Requires:       %{name}-gb-image = %{version}
Provides:       %{name}-gb-gtk3-wayland = %{version}
Obsoletes:      %{name}-gb-gtk3-wayland < %{version}
Provides:       %{name}-gb-gtk3-x11 = %{version}
Obsoletes:      %{name}-gb-gtk3-x11 < %{version}
Provides:       %{name}-gui = %{version}

%description gb-gtk3
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

These are the GTK+3 components for Gambas.

%package gb-gtk3-webview
Summary: Gambas GTK+3 web browser component
BuildRequires:  pkgconfig(webkit2gtk-4.1)
Requires:       %{name}-gb-gtk3 = %{version}
Provides:       %{name}-gui-webview = %{version}

%description gb-gtk3-webview
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides a GTK+3 web browser based on webkit2gtk.

%package gb-gtk3-opengl
Summary: Gambas GTK+3 OpenGL component
Provides:       %{name}-gui-opengl = %{version}
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-gtk3 = %{version}
Requires: %{name}-gb-opengl = %{version}

%description gb-gtk3-opengl
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows to use OpenGL in GTK+3 applications.

%package gb-image-imlib
Summary: Gambas bindings for the Imlib2 image library (deprecated)
BuildRequires:  pkgconfig(imlib2)
Requires:       %{name}-gb-image = %{version}

%description gb-image-imlib
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides bindings to the Imlib2 image library.
This component is deprecated.

%package gb-image-io
Summary: Gambas image loading and saving routines
BuildRequires:  pkgconfig(gdk-pixbuf-2.0)
Requires:       %{name}-gb-image = %{version}

%description gb-image-io
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides image loading and saving routines.

%package gb-libxml
Summary: Gambas libxml component
BuildRequires:  pkgconfig(libxml-2.0)
Requires: %{name}-runtime = %{version}

%description gb-libxml
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component brings the power of the libxml libraries to Gambas.
This component is deprecated.

%package gb-media
Summary: Gambas media component
BuildRequires:  pkgconfig(gstreamer-1.0)
BuildRequires:  pkgconfig(gstreamer-video-1.0)
Requires:       %{name}-gb-image = %{version}

%description gb-media
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component is a simplified interface to the GStreamer library.

%package gb-mime
Summary: Gambas MIME message management
BuildRequires:  pkgconfig(gmime-3.0)
Requires: %{name}-runtime = %{version}

%description gb-mime
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This components allows to parse a string and converts it to a MIME message and the reverse.

%if %{with gb_mongodb}
%package gb-mongodb
Summary: Gambas MongoDB component
BuildRequires:  pkgconfig(libmongoc-1.0)
Requires: %{name}-runtime = %{version}

%description gb-mongodb
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This package allows you to access MongoDB databases.
%endif

%package gb-ncurses
Summary: Gambas NCurses component
BuildRequires:  pkgconfig(ncurses)
Requires: %{name}-runtime = %{version}

%description gb-ncurses
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows to use the NCurses library.

%package gb-net-curl
Summary: Gambas advanced networking component
BuildRequires:  pkgconfig(libcurl)
Requires:       %{name}-gb-net = %{version}
Requires:       %{name}-runtime = %{version}

%description gb-net-curl
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows your programs to easily become FTP or HTTP clients through the libcurl library.

%package gb-openal
Summary: Gambas OpenAL component
BuildRequires:  pkgconfig(alure)
BuildRequires:  pkgconfig(openal)
Requires: %{name}-runtime = %{version}

%description gb-openal
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides an interface to the OpenAL library.

%package gb-opengl
Summary: Gambas OpenGL component
BuildRequires:  pkgconfig(glew)
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-image = %{version}

%description gb-opengl
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to do 3D programming with OpenGL.

%package gb-openssl
Summary: Gambas OpenSSL component
BuildRequires:  pkgconfig(libssl)
Requires: %{name}-runtime = %{version}

%description gb-openssl
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This components provides the cryptographic functions available in OpenSSL.

%package gb-pcre
Summary: Gambas regular expressions component
BuildRequires:  pkgconfig(libpcre2-8)
Requires: %{name}-runtime = %{version}

%description gb-pcre
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to use Perl compatible regular expressions through the 'libpcre' library.

%package gb-pdf
Summary: Gambas PDF component (deprecated)
BuildRequires:  pkgconfig(poppler)
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-image = %{version}

%description gb-pdf
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides an interface to the Poppler library.
This component is deprecated.

%package gb-poppler
Summary: Gambas Poppler component
BuildRequires:  pkgconfig(poppler-cpp)
BuildRequires:  pkgconfig(poppler-glib)
Requires:       %{name}-gb-image = %{version}

%description gb-poppler
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides an interface to the Poppler library.

%package gb-qt5
Summary: Gambas Qt5 GUI component
BuildRequires:  pkgconfig(Qt5Core) >= 5.5.0
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  pkgconfig(Qt5Network)
BuildRequires:  pkgconfig(Qt5PrintSupport)
BuildRequires:  pkgconfig(Qt5Svg)
BuildRequires:  pkgconfig(Qt5Widgets)
BuildRequires:  pkgconfig(Qt5X11Extras)
BuildRequires:  pkgconfig(Qt5Xml)
BuildRequires:  pkgconfig(x11-xcb)
Requires:       %{name}-gb-image = %{version}
Provides:       %{name}-gb-qt5-wayland = %{version}
Obsoletes:      %{name}-gb-qt5-wayland < %{version}
Provides:       %{name}-gb-qt5-x11 = %{version}
Obsoletes:      %{name}-gb-qt5-x11 < %{version}
Provides:       %{name}-gui = %{version}

%description gb-qt5
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component includes the Gambas QT5 GUI component.

%package gb-qt5-opengl
Summary: Gambas OpenGL component with QT5 toolkit
BuildRequires:  pkgconfig(Qt5OpenGL)
Requires:       %{name}-gb-opengl = %{version}
Requires:       %{name}-gb-qt5 = %{version}
Provides:       %{name}-gui-opengl = %{version}

%description gb-qt5-opengl
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you integrate OpenGL in QT5 applications.

%package gb-qt5-webkit
Summary: Gambas QT5 WebKit component
BuildRequires:  pkgconfig(Qt5WebKit)
BuildRequires:  pkgconfig(Qt5WebKitWidgets)
Requires:       %{name}-gb-qt5 = %{version}

%description gb-qt5-webkit
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to use the old WebKit browser component from Qt5.

%package gb-qt5-webview
Summary: Gambas QT5 web browser component
BuildRequires:  pkgconfig(Qt5WebEngine)
Requires:       %{name}-gb-qt5 = %{version}
Provides:       %{name}-gui-webview = %{version}

%description gb-qt5-webview
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to use the new WebKit browser component from Qt5.

%package gb-qt6
Summary: Gambas Qt6 GUI component
BuildRequires:  pkgconfig(Qt6Core)
BuildRequires:  pkgconfig(Qt6Gui)
BuildRequires:  pkgconfig(Qt6Network)
BuildRequires:  pkgconfig(Qt6PrintSupport)
BuildRequires:  pkgconfig(Qt6Svg)
BuildRequires:  pkgconfig(Qt6Widgets)
BuildRequires:  pkgconfig(Qt6Xml)
Requires:       %{name}-gb-image = %{version}
Provides:       %{name}-gb-qt6-wayland = %{version}
Obsoletes:      %{name}-gb-qt6-wayland < %{version}
Provides:       %{name}-gb-qt6-x11 = %{version}
Obsoletes:      %{name}-gb-qt6-x11 < %{version}
Provides:       %{name}-gui = %{version}

%description gb-qt6
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component includes the Gambas QT6 GUI component.

%package gb-qt6-opengl
Summary: Gambas OpenGL component with QT6 toolkit
BuildRequires:  pkgconfig(Qt6OpenGL)
BuildRequires:  pkgconfig(Qt6OpenGLWidgets)
Requires:       %{name}-gb-opengl = %{version}
Requires:       %{name}-gb-qt6 = %{version}
Provides:       %{name}-gui-opengl = %{version}

%description gb-qt6-opengl
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you integrate OpenGL in QT6 applications.

%package gb-qt6-webview
Summary: Gambas QT6 web browser component
BuildRequires:  pkgconfig(Qt6WebEngineCore)
BuildRequires:  pkgconfig(Qt6WebEngineWidgets)
Requires:       %{name}-gb-qt6 = %{version}
Provides:       %{name}-gui-webview = %{version}

%description gb-qt6-webview
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to use the WebKit browser component from Qt6.

%package gb-scanner
Summary: Gambas frontend to scanimage provided by the SANE toolkit
Requires:       %{name}-gb-form-dialog = %{version}
Requires:       %{name}-gb-form-mdi = %{version}
Requires:       %{name}-gb-form-print = %{version}
Requires:       %{name}-gb-image = %{version}
Requires:       %{name}-gb-settings = %{version}
Requires:       sane-backends

%description gb-scanner
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides a frontend to scanimage provided by the SANE toolkit.

%package gb-sdl
Summary: Gambas SDL1 component (deprecated)
BuildRequires:  pkgconfig(SDL_ttf)
BuildRequires:  pkgconfig(glew)
Requires:       %{name}-gb-image = %{version}
Requires:       %{name}-gb-image-io = %{version}

%description gb-sdl
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides an interface to the SDL1 library.
This component is deprecated.

%package gb-sdl-sound
Summary: Gambas SDL1 sound component (deprecated)
BuildRequires:  pkgconfig(SDL_mixer)
Requires: %{name}-runtime = %{version}

%description gb-sdl-sound
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component is an interface to sound part of the SDL library.
This component is deprecated.

%package gb-sdl2
Summary: Gambas SDL2 component (deprecated)
BuildRequires:  pkgconfig(SDL2_image)
BuildRequires:  pkgconfig(SDL2_ttf)
Requires:       %{name}-gb-image = %{version}

%description gb-sdl2
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides an interface to the SDL2 library.

%package gb-sdl2-audio
Summary: Gambas SDL2 audio component
BuildRequires:  pkgconfig(SDL2_mixer)
Requires: %{name}-runtime = %{version}

%description gb-sdl2-audio
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component is an interface to the SDL2 mixer library.

%package gb-v4l
Summary: Gambas video for Linux component (deprecated)
BuildRequires:  pkgconfig(libjpeg)
BuildRequires:  pkgconfig(libv4l2)
Requires:       %{name}-gb-image = %{version}

%description gb-v4l
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows to use Video4Linux.
This component is deprecated.

%package gb-xml-xslt
Summary: Gambas XSLT component
BuildRequires:  pkgconfig(libxml-2.0)
BuildRequires:  pkgconfig(libxslt)
Requires:       %{name}-runtime = %{version}
Requires:       %{name}-gb-xml = %{version}

%description gb-xml-xslt
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component brings the power of the libxslt libraries to Gambas.

%package gb-args
Summary: Gambas arguments parser
Requires: %{name}-runtime = %{version}

%description gb-args
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides a command-line options analyzer, that automatically handles the '--help' option.

%package gb-chart
Summary: Gambas charting component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-form = %{version}

%description gb-chart
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This is a native Gambas component to draw charts.

%package gb-complex
Summary: Gambas Complex component
Requires: %{name}-runtime = %{version}

%description gb-complex
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component brings complex numbers support to the interpreter.

%package gb-compress
Summary: Gambas compression component
Requires: %{name}-runtime = %{version}

%description gb-compress
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component have the needed base libraries for the rest of compression components.

%package gb-crypt
Summary: Gambas crypt encryption component
Requires: %{name}-runtime = %{version}

%description gb-crypt
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to use the 'crypt()' glib function in gambas.

%package gb-data
Summary: Gambas abstract datatypes component
Requires: %{name}-runtime = %{version}

%description gb-data
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides abstract datatypes implementations for Gambas.

%package gb-db
Summary: Gambas database access common libraries (deprecated version)
Requires: %{name}-runtime = %{version}

%description gb-db
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides the needed common libraries for data access.
This component is deprecated.

%package gb-db-form
Summary: Gambas database bound controls (deprecated version)
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-db = %{version}
Requires: %{name}-gb-form = %{version}

%description gb-db-form
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This is a native Gambas component that provides data bound controls.
This component is deprecated.

%package gb-db2
Summary: Gambas database access common libraries
Requires: %{name}-runtime = %{version}

%description gb-db2
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides the needed common libraries for data access.

%package gb-db2-form
Summary: Gambas database bound controls
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-db2 = %{version}
Requires: %{name}-gb-form = %{version}

%description gb-db2-form
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This is a native Gambas component that provides data bound controls.

%package gb-dbus-trayicon
Summary: Gambas support for KDE & Unity tray icon DBus protocols
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-dbus = %{version}
Requires: %{name}-gb-image = %{version}

%description gb-dbus-trayicon
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component implements the DBus tray icon protocol and exports the tray icon menu with the DBus menu protocol.

%package gb-eval-highlight
Summary: Gambas syntax highlighting component (deprecated)
Requires: %{name}-runtime = %{version}

%description gb-eval-highlight
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component includes the component for syntax highlighting.
This component is deprecated.

%package gb-form
Summary: Gambas GUI controls component
Requires: %{name}-runtime = %{version}

%description gb-form
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides many useful controls for the GUI components.

%package gb-form-dialog
Summary: Gambas enhanced standard dialogs component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-form = %{version}

%description gb-form-dialog
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides enhanced versions of the standard dialogs.

%package gb-form-editor
Summary: Gambas Text Editor component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-form = %{version}
Requires: %{name}-gb-highlight = %{version}
Requires: %{name}-gb-util = %{version}

%description gb-form-editor
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component implements the TextEditor control.

%package gb-form-htmlview
Summary: HTML viewer based on the litehtml library
Requires: %{name}-runtime = %{version}

%description gb-form-htmlview
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides provides a lightweight HTML viewer.  

%package gb-form-mdi
Summary: Gambas multiple document interface management component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-form = %{version}
Requires: %{name}-gb-settings = %{version}

%description gb-form-mdi
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component implements the Workspace control.

%package gb-form-print
Summary: Gambas generic preview and printing
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-form = %{version}

%description gb-form-print
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component includes a generic preview and printing dialog.

%package gb-form-stock
Summary: Gambas form stock and flag icons
Requires: %{name}-runtime = %{version}

%description gb-form-stock
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides stock and flag icons.

%package gb-form-terminal
Summary: Gambas terminal emulator
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-term = %{version}

%description gb-form-terminal
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides a VT-100 terminal emulator control that you can put anywhere in your application.

%package gb-gtk-opengl
Summary: Gambas GTK+ OpenGL component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-gtk = %{version}
Requires: %{name}-gb-opengl = %{version}

%description gb-gtk-opengl
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows to use OpenGL in GTK+ applications.

%package gb-highlight
Summary: Gambas syntax highlighting component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-image = %{version}
Requires: %{name}-gb-pcre = %{version}

%description gb-highlight
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides syntax highlighting routines. Highlighting is defined by description files using a rather simple specific syntax.

%package gb-httpd
Summary: Gambas embedded HTTP server
Requires: %{name}-runtime = %{version}

%description gb-httpd
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides an embedded HTTP server for debugging web applications.

%package gb-image
Summary: Gambas image and color management
Requires: %{name}-runtime = %{version}

%description gb-image
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides common image and color management for all other components and a few image manipulation routines.

%package gb-image-effect
Summary: More image effects routines for Gambas
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-image = %{version}

%description gb-image-effect
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides more image effects routines for the 'gb.image' component.

%package gb-inotify
Summary: Gambas inotify component
Requires: %{name}-runtime = %{version}

%description gb-inotify
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component brings a Linux-specific inotify interface for Gambas.

%package gb-logging
Summary: Gambas logging system component
Requires: %{name}-runtime = %{version}

%description gb-logging
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component brings a flexible logging system for Gambas applications.

%package gb-map
Summary: Gambas online map viewer
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-net = %{version}
Requires: %{name}-gb-net-curl = %{version}

%description gb-map
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows to display maps from many different sources (Google Maps, OpenStreetMap).

%package gb-markdown
Summary: Gambas markup syntax
Requires: %{name}-runtime = %{version}

%description gb-markdown
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component gives access to the Gambas markup syntax generator.

%package gb-media-form
Summary: Gambas media player component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-media = %{version}

%description gb-media-form
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component implements a media player control.

%package gb-memcached
Summary: Gambas memcached client
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-net = %{version}

%description gb-memcached
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides a memcached client.

%package gb-mysql
Summary: Gambas MySQL component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-db = %{version}
Requires: %{name}-gb-db-mysql = %{version}

%description gb-mysql
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides MySQL utilities on top of the MySQL driver.

%package gb-net
Summary: Gambas networking component
Requires: %{name}-runtime = %{version}

%description gb-net
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to use TCP/IP and UDP sockets, and to access any serial ports.

%package gb-net-pop3
Summary: Gambas POP3 client implementation
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-mime = %{version}
Requires: %{name}-gb-net = %{version}

%description gb-net-pop3
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component retrieves mails using the POP3 protocol.

%package gb-net-smtp
Summary: Gambas smtp protocol component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-net = %{version}

%description gb-net-smtp
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows sending emails using the SMTP protocol.

%package gb-opengl-glsl
Summary: Gambas OpenGL shaders management
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-opengl = %{version}

%description gb-opengl-glsl
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides access to the OpenGL shaders.

%package gb-opengl-glu
Summary: Gambas OpenGL utility routines
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-opengl = %{version}

%description gb-opengl-glu
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

"This component provides access to the OpenGL utility routines.

%package gb-opengl-sge
Summary: Gambas simple OpenGL game engine based on MD2 format
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-opengl = %{version}

%description gb-opengl-sge
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides a simple game engine based on OpenGL and MD2 format.

%package gb-option
Summary: Gambas option parser component (deprecated)
Requires: %{name}-runtime = %{version}

%description gb-option
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides a parser for the program options.
This component is deprecated.

%package gb-qt5-ext
Summary: Gambas QT5 toolkit extensions
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-qt5 = %{version}

%description gb-qt5-ext
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides extended QT5 controls.

%package gb-qt6-ext
Summary: Gambas QT6 toolkit extensions
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-qt6 = %{version}

%description gb-qt6-ext
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides extended QT6 controls.

%package gb-report
Summary: Gambas report component (deprecated)
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-form = %{version}

%description gb-report
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component gives the tools and methods to create reports using Gambas.
This component is deprecated.

%package gb-report2
Summary: Gambas report component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-form = %{version}

%description gb-report2
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component is a new and better implementation of the reporting component.

%package gb-settings
Summary: Gambas application settings management
Requires: %{name}-runtime = %{version}

%description gb-settings
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides standard management of application settings files.

%package gb-signal
Summary: Gambas Unix signals management library
Requires: %{name}-runtime = %{version}

%description gb-signal
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This package allows to catch, manage and send Unix signals.

%package gb-term
Summary: Gambas terminal management
Requires: %{name}-runtime = %{version}

%description gb-term
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

"This component provides an interface to the virtual terminal system routines.

%package gb-term-form
Summary: Gambas GUI terminal applications component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-term = %{version}

%description gb-term-form
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows to develop GUI applications running in a terminal.

%package gb-util
Summary: Gambas interpreter utility routines component
Requires: %{name}-runtime = %{version}

%description gb-util
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides utility functions to the interpreter.

%package gb-util-web
Summary: Gambas web utility routines component
Requires: %{name}-runtime = %{version}

%description gb-util-web
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides utility functions to web applications.

%package gb-vb
Summary: Gambas Visual Basic(tm) compatibility component
Requires: %{name}-runtime = %{version}

%description gb-vb
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides compatibility with some MS Visual Basic functions.

%package gb-web
Summary: Gambas CGI for web applications
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-util-web = %{version}

%description gb-web
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows to make CGI web applications with an ASP-like interface.

%package gb-web-feed
Summary: Gambas web feed parser and generator
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-util = %{version}
Requires: %{name}-gb-xml = %{version}

%description gb-web-feed
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This components provides a web feed parser and generator.

%package gb-web-form
Summary: Gambas web applications GUI component (deprecated)
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-util = %{version}
Requires: %{name}-gb-util-web = %{version}
Requires: %{name}-gb-web = %{version}

%description gb-web-form
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to write web applications almost the same way you write desktop applications.
This component is deprecated.

%package gb-web-gui
Summary: Gambas web applications GUI component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-signal = %{version}
Requires: %{name}-gb-util = %{version}
Requires: %{name}-gb-util-web = %{version}
Requires: %{name}-gb-web = %{version}

%description gb-web-gui
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows you to write web applications almost the same way you write desktop applications. Sessions are managed using processes!

%package gb-xml
Summary: Gambas XML component
Requires: %{name}-runtime = %{version}

%description gb-xml
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component allows to deal with XML files.

%package gb-xml-html
Summary: Gambas HTML generator component
Requires: %{name}-runtime = %{version}
Requires: %{name}-gb-xml = %{version}

%description gb-xml-html
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This component provides an HTML generator based on XML.

%package gb-xml-rpc
Summary: Gambas XML-RPC component
Requires: %{name}-runtime = %{version}

%description gb-xml-rpc
GAMBAS is a free development environment and a full powerful object-oriented language and development platform based on a fast Basic interpreter with optional just-in-time compilation, as easy as Visual Basic™ was.

This components implements XML-RPC.

%prep
%autosetup -n gambas-%{version} -p1

# fix benchmark scripts shebang
sed -e 's|bin/python$|bin/python3|;s|bin/env gbs3|bin/gbs3|;s|bin/java.*|bin/cat|' \
    -e 's|, "python",|, "python3",|' -i benchmark/*

%build
%if 0%{?suse_version} < 1600
export CC="gcc-11"
export CXX="g++-11"
%endif

./reconf-all
GAMBAS_CONFIG_FAILURE=1 %configure -C \
	--disable-qtwebkit \
	--disable-qtwebview \
	--disable-qt4 \
	--disable-sqlite2 \
	--disable-mongodb \
	%{nil}

%make_build

%install
%make_install XDG_UTILS=""

# desktop
install -D -m 0644 -t %{buildroot}%{_datadir}/applications app/desktop/%{name}.desktop

# mime
install -D -m 0644 main/mime/application-x-%{name}.xml %{buildroot}%{_datadir}/mime/packages/x-%{name}.xml
install -m 0644 app/mime/application-x-gambasscript.xml %{buildroot}%{_datadir}/mime/packages/x-gambasscript.xml
install -m 0644 app/mime/application-x-gambasserverpage.xml %{buildroot}%{_datadir}/mime/packages/x-gambasserverpage.xml
install -D -m 0644 app/mime/application-x-gambasscript-48.png \
	%{buildroot}%{_datadir}/icons/hicolor/48x48/mimetypes/application-x-gambasscript.png
install -D -m 0644 app/mime/application-x-gambasserverpage-48.png \
	%{buildroot}%{_datadir}/icons/hicolor/48x48/mimetypes/application-x-gambasserverpage.png
install -D -m 0644 main/mime/application-x-%{name}-48.png \
	%{buildroot}%{_datadir}/icons/hicolor/48x48/mimetypes/application-x-%{name}.png
install -D -m 0644 main/mime/application-x-%{name}.png \
	%{buildroot}%{_datadir}/icons/hicolor/256x256/mimetypes/application-x-%{name}.png
install -D -m 0644 -t %{buildroot}%{_datadir}/icons/hicolor/256x256/mimetypes \
	app/mime/application-x-gambas{script,serverpage}.png

# icons
install -D -m 0644 app/desktop/%{name}-48.png %{buildroot}%{_datadir}/icons/hicolor/48x48/apps/%{name}.png
install -D -m 0644 -t %{buildroot}%{_datadir}/icons/hicolor/256x256/apps app/desktop/%{name}.png
install -D -m 0644 -t %{buildroot}%{_datadir}/icons/hicolor/scalable/apps app/desktop/%{name}.svg

# benchmark & examples
cp -a benchmark app/examples %{buildroot}%{_datadir}/%{name}

%check
export PATH=%{buildroot}%{_bindir}:$PATH
export GB_PATH=%{buildroot}%{_bindir}/gbx3
cd main/lib/test/gb.test
gbc3 . && gba3 . && gbx3 -T "@All good" . || :

%files
%license COPYING
%doc README.md

%files ide
%license COPYING app/src/gambas3/.hidden/font/LICENSE
%doc README.md
%dir %{_datadir}/%{name}
%{_bindir}/%{name}{,.gambas}
%{_datadir}/%{name}/template
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.{png,svg}
%attr(0644,root,root) %{_datadir}/metainfo/%{name}.appdata.xml
%{_mandir}/man1/%{name}.1%{?ext_man}
%exclude %{_datadir}/appdata

%files runtime
%license COPYING
%doc AUTHORS README
%{_bindir}/gb{r,x}3
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_datadir}/%{name}/info/gb.{debug,geom,gui,hash,jit,test}.*
%{_datadir}/%{name}/info/gb.eval.{info,list}
%{_datadir}/%{name}/info/gb.{info,list}
%{_datadir}/icons/hicolor/*/mimetypes/application-x-%{name}.png
%{_datadir}/mime/packages/x-%{name}.xml
%attr(0644,root,root) %{_libdir}/%{name}/gb.component
%{_libdir}/%{name}/gb.{debug,draw,geom,gui,hash,jit,test}.*
%{_libdir}/%{name}/gb.eval.{component,la,so*}
%{_mandir}/man1/gb{r,x}3.1%{?ext_man}

%files scripter
%{_bindir}/gb{s,w}3
%{_bindir}/gbs3.gambas
%{_datadir}/icons/hicolor/*/mimetypes/application-x-gambas{script,serverpage}.png
%{_datadir}/mime/packages/x-gambas{script,serverpage}.xml
%{_mandir}/man1/gb{s,w}3.1%{?ext_man}

%files dev-tools
%{_bindir}/gb{a,c,h,i}3
%{_bindir}/gbh3.gambas
%{_mandir}/man1/gb{a,c,h,i}3.1%{?ext_man}

%files benchmark
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/benchmark

%files examples
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/examples

%files gb-args
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.args.component
%{_libdir}/%{name}/gb.args.gambas
%{_datadir}/%{name}/info/gb.args.info
%{_datadir}/%{name}/info/gb.args.list

%files gb-cairo
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.cairo.component
%{_libdir}/%{name}/gb.cairo.la
%{_libdir}/%{name}/gb.cairo.so
%{_libdir}/%{name}/gb.cairo.so.0
%{_libdir}/%{name}/gb.cairo.so.0.0.0
%{_datadir}/%{name}/info/gb.cairo.info
%{_datadir}/%{name}/info/gb.cairo.list

%files gb-chart
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.chart.component
%{_libdir}/%{name}/gb.chart.gambas
%{_datadir}/%{name}/info/gb.chart.info
%{_datadir}/%{name}/info/gb.chart.list

%files gb-clipper
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.clipper.component
%{_libdir}/%{name}/gb.clipper.la
%{_libdir}/%{name}/gb.clipper.so
%{_libdir}/%{name}/gb.clipper.so.0
%{_libdir}/%{name}/gb.clipper.so.0.0.0
%{_datadir}/%{name}/info/gb.clipper.info
%{_datadir}/%{name}/info/gb.clipper.list

%files gb-clipper2
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.clipper2.component
%{_libdir}/%{name}/gb.clipper2.la
%{_libdir}/%{name}/gb.clipper2.so
%{_libdir}/%{name}/gb.clipper2.so.0
%{_libdir}/%{name}/gb.clipper2.so.0.0.0
%{_datadir}/%{name}/info/gb.clipper2.info
%{_datadir}/%{name}/info/gb.clipper2.list

%files gb-complex
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.complex.component
%{_libdir}/%{name}/gb.complex.la
%{_libdir}/%{name}/gb.complex.so
%{_libdir}/%{name}/gb.complex.so.0
%{_libdir}/%{name}/gb.complex.so.0.0.0
%{_datadir}/%{name}/info/gb.complex.info
%{_datadir}/%{name}/info/gb.complex.list

%files gb-compress
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.compress.component
%{_libdir}/%{name}/gb.compress.la
%{_libdir}/%{name}/gb.compress.so
%{_libdir}/%{name}/gb.compress.so.0
%{_libdir}/%{name}/gb.compress.so.0.0.0
%{_datadir}/%{name}/info/gb.compress.info
%{_datadir}/%{name}/info/gb.compress.list

%files gb-compress-bzlib2
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.compress.bzlib2.component
%{_libdir}/%{name}/gb.compress.bzlib2.la
%{_libdir}/%{name}/gb.compress.bzlib2.so
%{_libdir}/%{name}/gb.compress.bzlib2.so.0
%{_libdir}/%{name}/gb.compress.bzlib2.so.0.0.0
%{_datadir}/%{name}/info/gb.compress.bzlib2.info
%{_datadir}/%{name}/info/gb.compress.bzlib2.list

%files gb-compress-zlib
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.compress.zlib.component
%{_libdir}/%{name}/gb.compress.zlib.la
%{_libdir}/%{name}/gb.compress.zlib.so
%{_libdir}/%{name}/gb.compress.zlib.so.0
%{_libdir}/%{name}/gb.compress.zlib.so.0.0.0
%{_datadir}/%{name}/info/gb.compress.zlib.info
%{_datadir}/%{name}/info/gb.compress.zlib.list

%files gb-compress-zstd
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.compress.zstd.component
%{_libdir}/%{name}/gb.compress.zstd.la
%{_libdir}/%{name}/gb.compress.zstd.so
%{_libdir}/%{name}/gb.compress.zstd.so.0
%{_libdir}/%{name}/gb.compress.zstd.so.0.0.0
%{_datadir}/%{name}/info/gb.compress.zstd.info
%{_datadir}/%{name}/info/gb.compress.zstd.list

%files gb-crypt
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.crypt.component
%{_libdir}/%{name}/gb.crypt.la
%{_libdir}/%{name}/gb.crypt.so
%{_libdir}/%{name}/gb.crypt.so.0
%{_libdir}/%{name}/gb.crypt.so.0.0.0
%{_datadir}/%{name}/info/gb.crypt.info
%{_datadir}/%{name}/info/gb.crypt.list

%files gb-data
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.data.component
%{_libdir}/%{name}/gb.data.gambas
%{_libdir}/%{name}/gb.data.la
%{_libdir}/%{name}/gb.data.so
%{_libdir}/%{name}/gb.data.so.0
%{_libdir}/%{name}/gb.data.so.0.0.0
%{_datadir}/%{name}/info/gb.data.info
%{_datadir}/%{name}/info/gb.data.list

%files gb-db
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.db.component
%{_libdir}/%{name}/gb.db.gambas
%{_libdir}/%{name}/gb.db.la
%{_libdir}/%{name}/gb.db.so
%{_libdir}/%{name}/gb.db.so.0
%{_libdir}/%{name}/gb.db.so.0.0.0
%{_datadir}/%{name}/info/gb.db.info
%{_datadir}/%{name}/info/gb.db.list

%files gb-db-form
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.db.form.component
%{_libdir}/%{name}/gb.db.form.gambas
%{_datadir}/%{name}/control/gb.db.form
%{_datadir}/%{name}/info/gb.db.form.info
%{_datadir}/%{name}/info/gb.db.form.list

%files gb-db-mysql
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.db.mysql.component
%{_libdir}/%{name}/gb.db.mysql.la
%{_libdir}/%{name}/gb.db.mysql.so
%{_libdir}/%{name}/gb.db.mysql.so.0
%{_libdir}/%{name}/gb.db.mysql.so.0.0.0
%{_datadir}/%{name}/info/gb.db.mysql.info
%{_datadir}/%{name}/info/gb.db.mysql.list

%files gb-db-odbc
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.db.odbc.component
%{_libdir}/%{name}/gb.db.odbc.la
%{_libdir}/%{name}/gb.db.odbc.so
%{_libdir}/%{name}/gb.db.odbc.so.0
%{_libdir}/%{name}/gb.db.odbc.so.0.0.0
%{_datadir}/%{name}/info/gb.db.odbc.info
%{_datadir}/%{name}/info/gb.db.odbc.list

%files gb-db-postgresql
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.db.postgresql.component
%{_libdir}/%{name}/gb.db.postgresql.la
%{_libdir}/%{name}/gb.db.postgresql.so
%{_libdir}/%{name}/gb.db.postgresql.so.0
%{_libdir}/%{name}/gb.db.postgresql.so.0.0.0
%{_datadir}/%{name}/info/gb.db.postgresql.info
%{_datadir}/%{name}/info/gb.db.postgresql.list

%files gb-db-sqlite3
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.db.sqlite3.component
%{_libdir}/%{name}/gb.db.sqlite3.la
%{_libdir}/%{name}/gb.db.sqlite3.so
%{_libdir}/%{name}/gb.db.sqlite3.so.0
%{_libdir}/%{name}/gb.db.sqlite3.so.0.0.0
%{_datadir}/%{name}/info/gb.db.sqlite3.info
%{_datadir}/%{name}/info/gb.db.sqlite3.list

%files gb-db2
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.db2.component
%{_libdir}/%{name}/gb.db2.gambas
%{_datadir}/%{name}/info/gb.db2.info
%{_datadir}/%{name}/info/gb.db2.list

%files gb-db2-form
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.db2.form.component
%{_libdir}/%{name}/gb.db2.form.gambas
%{_datadir}/%{name}/control/gb.db2.form
%{_datadir}/%{name}/info/gb.db2.form.info
%{_datadir}/%{name}/info/gb.db2.form.list

%files gb-db2-mysql
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.db2.mysql.component
%{_libdir}/%{name}/gb.db2.mysql.gambas
%{_libdir}/%{name}/gb.db2.mysql.la
%{_libdir}/%{name}/gb.db2.mysql.so
%{_libdir}/%{name}/gb.db2.mysql.so.0
%{_libdir}/%{name}/gb.db2.mysql.so.0.0.0
%{_datadir}/%{name}/info/gb.db2.mysql.info
%{_datadir}/%{name}/info/gb.db2.mysql.list

%files gb-db2-odbc
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.db2.odbc.component
%{_libdir}/%{name}/gb.db2.odbc.gambas
%{_libdir}/%{name}/gb.db2.odbc.la
%{_libdir}/%{name}/gb.db2.odbc.so
%{_libdir}/%{name}/gb.db2.odbc.so.0
%{_libdir}/%{name}/gb.db2.odbc.so.0.0.0
%{_datadir}/%{name}/info/gb.db2.odbc.info
%{_datadir}/%{name}/info/gb.db2.odbc.list

%files gb-db2-postgresql
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.db2.postgresql.component
%{_libdir}/%{name}/gb.db2.postgresql.gambas
%{_libdir}/%{name}/gb.db2.postgresql.la
%{_libdir}/%{name}/gb.db2.postgresql.so
%{_libdir}/%{name}/gb.db2.postgresql.so.0
%{_libdir}/%{name}/gb.db2.postgresql.so.0.0.0
%{_datadir}/%{name}/info/gb.db2.postgresql.info
%{_datadir}/%{name}/info/gb.db2.postgresql.list

%files gb-db2-sqlite3
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.db2.sqlite3.component
%{_libdir}/%{name}/gb.db2.sqlite3.gambas
%{_libdir}/%{name}/gb.db2.sqlite3.la
%{_libdir}/%{name}/gb.db2.sqlite3.so
%{_libdir}/%{name}/gb.db2.sqlite3.so.0
%{_libdir}/%{name}/gb.db2.sqlite3.so.0.0.0
%{_datadir}/%{name}/info/gb.db2.sqlite3.info
%{_datadir}/%{name}/info/gb.db2.sqlite3.list

%files gb-dbus
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.dbus.component
%{_libdir}/%{name}/gb.dbus.gambas
%{_libdir}/%{name}/gb.dbus.la
%{_libdir}/%{name}/gb.dbus.so
%{_libdir}/%{name}/gb.dbus.so.0
%{_libdir}/%{name}/gb.dbus.so.0.0.0
%{_datadir}/%{name}/info/gb.dbus.info
%{_datadir}/%{name}/info/gb.dbus.list

%files gb-dbus-trayicon
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.dbus.trayicon.component
%{_libdir}/%{name}/gb.dbus.trayicon.gambas
%{_datadir}/%{name}/info/gb.dbus.trayicon.info
%{_datadir}/%{name}/info/gb.dbus.trayicon.list

%files gb-desktop
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.desktop.component
%{_libdir}/%{name}/gb.desktop.gambas
%{_datadir}/%{name}/control/gb.desktop
%{_datadir}/%{name}/info/gb.desktop.info
%{_datadir}/%{name}/info/gb.desktop.list

%files gb-desktop-gnome-keyring
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.desktop.gnome.keyring.component
%{_libdir}/%{name}/gb.desktop.gnome.keyring.la
%{_libdir}/%{name}/gb.desktop.gnome.keyring.so
%{_libdir}/%{name}/gb.desktop.gnome.keyring.so.0
%{_libdir}/%{name}/gb.desktop.gnome.keyring.so.0.0.0
%{_datadir}/%{name}/info/gb.desktop.gnome.keyring.info
%{_datadir}/%{name}/info/gb.desktop.gnome.keyring.list

%files gb-desktop-x11
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.desktop.x11.component
%{_libdir}/%{name}/gb.desktop.x11.gambas
%{_libdir}/%{name}/gb.desktop.x11.la
%{_libdir}/%{name}/gb.desktop.x11.so
%{_libdir}/%{name}/gb.desktop.x11.so.0
%{_libdir}/%{name}/gb.desktop.x11.so.0.0.0
%{_datadir}/%{name}/info/gb.desktop.x11.info
%{_datadir}/%{name}/info/gb.desktop.x11.list

%files gb-eval-highlight
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.eval.highlight.component
%{_libdir}/%{name}/gb.eval.highlight.gambas
%{_datadir}/%{name}/info/gb.eval.highlight.info
%{_datadir}/%{name}/info/gb.eval.highlight.list

%files gb-form
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.form.component
%{_libdir}/%{name}/gb.form.gambas
%{_datadir}/%{name}/control/gb.form
%{_datadir}/%{name}/info/gb.form.info
%{_datadir}/%{name}/info/gb.form.list

%files gb-form-dialog
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.form.dialog.component
%{_libdir}/%{name}/gb.form.dialog.gambas
%{_datadir}/%{name}/info/gb.form.dialog.info
%{_datadir}/%{name}/info/gb.form.dialog.list

%files gb-form-editor
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.form.editor.component
%{_libdir}/%{name}/gb.form.editor.gambas
%{_datadir}/%{name}/control/gb.form.editor
%{_datadir}/%{name}/info/gb.form.editor.info
%{_datadir}/%{name}/info/gb.form.editor.list

%files gb-form-htmlview
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.form.htmlview.component
%{_libdir}/%{name}/gb.form.htmlview.gambas
%{_libdir}/%{name}/gb.form.htmlview.la
%{_libdir}/%{name}/gb.form.htmlview.so
%{_libdir}/%{name}/gb.form.htmlview.so.0
%{_libdir}/%{name}/gb.form.htmlview.so.0.0.0
%{_datadir}/%{name}/control/gb.form.htmlview
%{_datadir}/%{name}/info/gb.form.htmlview.info
%{_datadir}/%{name}/info/gb.form.htmlview.list

%files gb-form-mdi
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.form.mdi.component
%{_libdir}/%{name}/gb.form.mdi.gambas
%{_datadir}/%{name}/control/gb.form.mdi
%{_datadir}/%{name}/info/gb.form.mdi.info
%{_datadir}/%{name}/info/gb.form.mdi.list

%files gb-form-print
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.form.print.component
%{_libdir}/%{name}/gb.form.print.gambas
%{_datadir}/%{name}/info/gb.form.print.info
%{_datadir}/%{name}/info/gb.form.print.list

%files gb-form-stock
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.form.stock.component
%{_libdir}/%{name}/gb.form.stock.gambas
%{_datadir}/%{name}/info/gb.form.stock.info
%{_datadir}/%{name}/info/gb.form.stock.list

%files gb-form-terminal
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.form.terminal.component
%{_libdir}/%{name}/gb.form.terminal.gambas
%{_datadir}/%{name}/control/gb.form.terminal
%{_datadir}/%{name}/info/gb.form.terminal.info
%{_datadir}/%{name}/info/gb.form.terminal.list

%files gb-gmp
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.gmp.component
%{_libdir}/%{name}/gb.gmp.la
%{_libdir}/%{name}/gb.gmp.so
%{_libdir}/%{name}/gb.gmp.so.0
%{_libdir}/%{name}/gb.gmp.so.0.0.0
%{_datadir}/%{name}/info/gb.gmp.info
%{_datadir}/%{name}/info/gb.gmp.list

%files gb-gsl
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.gsl.component
%{_libdir}/%{name}/gb.gsl.la
%{_libdir}/%{name}/gb.gsl.so
%{_libdir}/%{name}/gb.gsl.so.0
%{_libdir}/%{name}/gb.gsl.so.0.0.0
%{_datadir}/%{name}/info/gb.gsl.info
%{_datadir}/%{name}/info/gb.gsl.list

%files gb-gtk
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.gtk.component
%{_libdir}/%{name}/gb.gtk.la
%{_libdir}/%{name}/gb.gtk.so
%{_libdir}/%{name}/gb.gtk.so.0
%{_libdir}/%{name}/gb.gtk.so.0.0.0
%{_datadir}/%{name}/info/gb.gtk.info
%{_datadir}/%{name}/info/gb.gtk.list

%files gb-gtk-opengl
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.gtk.opengl.component
%{_libdir}/%{name}/gb.gtk.opengl.la
%{_libdir}/%{name}/gb.gtk.opengl.so
%{_libdir}/%{name}/gb.gtk.opengl.so.0
%{_libdir}/%{name}/gb.gtk.opengl.so.0.0.0
%{_datadir}/%{name}/info/gb.gtk.opengl.info
%{_datadir}/%{name}/info/gb.gtk.opengl.list

%files gb-gtk3
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.gtk3.component
%{_libdir}/%{name}/gb.gtk3.la
%{_libdir}/%{name}/gb.gtk3.so
%{_libdir}/%{name}/gb.gtk3.so.0
%{_libdir}/%{name}/gb.gtk3.so.0.0.0
%{_libdir}/%{name}/gb.gtk3.wayland.component
%{_libdir}/%{name}/gb.gtk3.wayland.la
%{_libdir}/%{name}/gb.gtk3.wayland.so
%{_libdir}/%{name}/gb.gtk3.wayland.so.0
%{_libdir}/%{name}/gb.gtk3.wayland.so.0.0.0
%{_libdir}/%{name}/gb.gtk3.x11.component
%{_libdir}/%{name}/gb.gtk3.x11.la
%{_libdir}/%{name}/gb.gtk3.x11.so
%{_libdir}/%{name}/gb.gtk3.x11.so.0
%{_libdir}/%{name}/gb.gtk3.x11.so.0.0.0
%{_datadir}/%{name}/info/gb.gtk3.info
%{_datadir}/%{name}/info/gb.gtk3.list
%{_datadir}/%{name}/info/gb.gtk3.wayland.info
%{_datadir}/%{name}/info/gb.gtk3.wayland.list
%{_datadir}/%{name}/info/gb.gtk3.x11.info
%{_datadir}/%{name}/info/gb.gtk3.x11.list

%files gb-gtk3-opengl
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.gtk3.opengl.component
%{_libdir}/%{name}/gb.gtk3.opengl.la
%{_libdir}/%{name}/gb.gtk3.opengl.so
%{_libdir}/%{name}/gb.gtk3.opengl.so.0
%{_libdir}/%{name}/gb.gtk3.opengl.so.0.0.0
%{_datadir}/%{name}/info/gb.gtk3.opengl.info
%{_datadir}/%{name}/info/gb.gtk3.opengl.list

%files gb-gtk3-webview
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.gtk3.webview.component
%{_libdir}/%{name}/gb.gtk3.webview.la
%{_libdir}/%{name}/gb.gtk3.webview.so
%{_libdir}/%{name}/gb.gtk3.webview.so.0
%{_libdir}/%{name}/gb.gtk3.webview.so.0.0.0
%{_datadir}/%{name}/info/gb.gtk3.webview.info
%{_datadir}/%{name}/info/gb.gtk3.webview.list

%files gb-highlight
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.highlight.component
%{_libdir}/%{name}/gb.highlight.gambas
%{_datadir}/%{name}/info/gb.highlight.info
%{_datadir}/%{name}/info/gb.highlight.list

%files gb-httpd
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.httpd.component
%{_libdir}/%{name}/gb.httpd.la
%{_libdir}/%{name}/gb.httpd.so
%{_libdir}/%{name}/gb.httpd.so.0
%{_libdir}/%{name}/gb.httpd.so.0.0.0
%{_datadir}/%{name}/info/gb.httpd.info
%{_datadir}/%{name}/info/gb.httpd.list

%files gb-image
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.image.component
%{_libdir}/%{name}/gb.image.la
%{_libdir}/%{name}/gb.image.so
%{_libdir}/%{name}/gb.image.so.0
%{_libdir}/%{name}/gb.image.so.0.0.0
%{_datadir}/%{name}/info/gb.image.info
%{_datadir}/%{name}/info/gb.image.list

%files gb-image-effect
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.image.effect.component
%{_libdir}/%{name}/gb.image.effect.la
%{_libdir}/%{name}/gb.image.effect.so
%{_libdir}/%{name}/gb.image.effect.so.0
%{_libdir}/%{name}/gb.image.effect.so.0.0.0
%{_datadir}/%{name}/info/gb.image.effect.info
%{_datadir}/%{name}/info/gb.image.effect.list

%files gb-image-imlib
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.image.imlib.component
%{_libdir}/%{name}/gb.image.imlib.la
%{_libdir}/%{name}/gb.image.imlib.so
%{_libdir}/%{name}/gb.image.imlib.so.0
%{_libdir}/%{name}/gb.image.imlib.so.0.0.0
%{_datadir}/%{name}/info/gb.image.imlib.info
%{_datadir}/%{name}/info/gb.image.imlib.list

%files gb-image-io
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.image.io.component
%{_libdir}/%{name}/gb.image.io.la
%{_libdir}/%{name}/gb.image.io.so
%{_libdir}/%{name}/gb.image.io.so.0
%{_libdir}/%{name}/gb.image.io.so.0.0.0
%{_datadir}/%{name}/info/gb.image.io.info
%{_datadir}/%{name}/info/gb.image.io.list

%files gb-inotify
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.inotify.component
%{_libdir}/%{name}/gb.inotify.la
%{_libdir}/%{name}/gb.inotify.so
%{_libdir}/%{name}/gb.inotify.so.0
%{_libdir}/%{name}/gb.inotify.so.0.0.0
%{_datadir}/%{name}/info/gb.inotify.info
%{_datadir}/%{name}/info/gb.inotify.list

%files gb-libxml
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.libxml.component
%{_libdir}/%{name}/gb.libxml.la
%{_libdir}/%{name}/gb.libxml.so
%{_libdir}/%{name}/gb.libxml.so.0
%{_libdir}/%{name}/gb.libxml.so.0.0.0
%{_datadir}/%{name}/info/gb.libxml.info
%{_datadir}/%{name}/info/gb.libxml.list

%files gb-logging
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.logging.component
%{_libdir}/%{name}/gb.logging.gambas
%{_datadir}/%{name}/info/gb.logging.info
%{_datadir}/%{name}/info/gb.logging.list

%files gb-map
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.map.component
%{_libdir}/%{name}/gb.map.gambas
%{_datadir}/%{name}/control/gb.map
%{_datadir}/%{name}/info/gb.map.info
%{_datadir}/%{name}/info/gb.map.list

%files gb-markdown
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.markdown.component
%{_libdir}/%{name}/gb.markdown.gambas
%{_datadir}/%{name}/info/gb.markdown.info
%{_datadir}/%{name}/info/gb.markdown.list

%files gb-media
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.media.component
%{_libdir}/%{name}/gb.media.la
%{_libdir}/%{name}/gb.media.so
%{_libdir}/%{name}/gb.media.so.0
%{_libdir}/%{name}/gb.media.so.0.0.0
%{_datadir}/%{name}/info/gb.media.info
%{_datadir}/%{name}/info/gb.media.list

%files gb-media-form
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.media.form.component
%{_libdir}/%{name}/gb.media.form.gambas
%{_datadir}/%{name}/control/gb.media.form
%{_datadir}/%{name}/info/gb.media.form.info
%{_datadir}/%{name}/info/gb.media.form.list

%files gb-memcached
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.memcached.component
%{_libdir}/%{name}/gb.memcached.gambas
%{_datadir}/%{name}/info/gb.memcached.info
%{_datadir}/%{name}/info/gb.memcached.list

%files gb-mime
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.mime.component
%{_libdir}/%{name}/gb.mime.la
%{_libdir}/%{name}/gb.mime.so
%{_libdir}/%{name}/gb.mime.so.0
%{_libdir}/%{name}/gb.mime.so.0.0.0
%{_datadir}/%{name}/info/gb.mime.info
%{_datadir}/%{name}/info/gb.mime.list

%files gb-mysql
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.mysql.component
%{_libdir}/%{name}/gb.mysql.gambas
%{_datadir}/%{name}/info/gb.mysql.info
%{_datadir}/%{name}/info/gb.mysql.list

%files gb-ncurses
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.ncurses.component
%{_libdir}/%{name}/gb.ncurses.la
%{_libdir}/%{name}/gb.ncurses.so
%{_libdir}/%{name}/gb.ncurses.so.0
%{_libdir}/%{name}/gb.ncurses.so.0.0.0
%{_datadir}/%{name}/info/gb.ncurses.info
%{_datadir}/%{name}/info/gb.ncurses.list

%files gb-net
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.net.component
%{_libdir}/%{name}/gb.net.la
%{_libdir}/%{name}/gb.net.so
%{_libdir}/%{name}/gb.net.so.0
%{_libdir}/%{name}/gb.net.so.0.0.0
%{_datadir}/%{name}/control/gb.net
%{_datadir}/%{name}/info/gb.net.info
%{_datadir}/%{name}/info/gb.net.list

%files gb-net-curl
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.net.curl.component
%{_libdir}/%{name}/gb.net.curl.gambas
%{_libdir}/%{name}/gb.net.curl.la
%{_libdir}/%{name}/gb.net.curl.so
%{_libdir}/%{name}/gb.net.curl.so.0
%{_libdir}/%{name}/gb.net.curl.so.0.0.0
%{_datadir}/%{name}/control/gb.net.curl
%{_datadir}/%{name}/info/gb.net.curl.info
%{_datadir}/%{name}/info/gb.net.curl.list

%files gb-net-pop3
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.net.pop3.component
%{_libdir}/%{name}/gb.net.pop3.gambas
%{_datadir}/%{name}/control/gb.net.pop3
%{_datadir}/%{name}/info/gb.net.pop3.info
%{_datadir}/%{name}/info/gb.net.pop3.list

%files gb-net-smtp
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.net.smtp.component
%{_libdir}/%{name}/gb.net.smtp.gambas
%{_datadir}/%{name}/control/gb.net.smtp
%{_datadir}/%{name}/info/gb.net.smtp.info
%{_datadir}/%{name}/info/gb.net.smtp.list

%files gb-openal
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.openal.component
%{_libdir}/%{name}/gb.openal.la
%{_libdir}/%{name}/gb.openal.so
%{_libdir}/%{name}/gb.openal.so.0
%{_libdir}/%{name}/gb.openal.so.0.0.0
%{_datadir}/%{name}/info/gb.openal.info
%{_datadir}/%{name}/info/gb.openal.list

%files gb-opengl
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.opengl.component
%{_libdir}/%{name}/gb.opengl.la
%{_libdir}/%{name}/gb.opengl.so
%{_libdir}/%{name}/gb.opengl.so.0
%{_libdir}/%{name}/gb.opengl.so.0.0.0
%{_datadir}/%{name}/info/gb.opengl.info
%{_datadir}/%{name}/info/gb.opengl.list

%files gb-opengl-glsl
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.opengl.glsl.component
%{_libdir}/%{name}/gb.opengl.glsl.la
%{_libdir}/%{name}/gb.opengl.glsl.so
%{_libdir}/%{name}/gb.opengl.glsl.so.0
%{_libdir}/%{name}/gb.opengl.glsl.so.0.0.0
%{_datadir}/%{name}/info/gb.opengl.glsl.info
%{_datadir}/%{name}/info/gb.opengl.glsl.list

%files gb-opengl-glu
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.opengl.glu.component
%{_libdir}/%{name}/gb.opengl.glu.la
%{_libdir}/%{name}/gb.opengl.glu.so
%{_libdir}/%{name}/gb.opengl.glu.so.0
%{_libdir}/%{name}/gb.opengl.glu.so.0.0.0
%{_datadir}/%{name}/info/gb.opengl.glu.info
%{_datadir}/%{name}/info/gb.opengl.glu.list

%files gb-opengl-sge
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.opengl.sge.component
%{_libdir}/%{name}/gb.opengl.sge.la
%{_libdir}/%{name}/gb.opengl.sge.so
%{_libdir}/%{name}/gb.opengl.sge.so.0
%{_libdir}/%{name}/gb.opengl.sge.so.0.0.0
%{_datadir}/%{name}/info/gb.opengl.sge.info
%{_datadir}/%{name}/info/gb.opengl.sge.list

%files gb-openssl
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.openssl.component
%{_libdir}/%{name}/gb.openssl.la
%{_libdir}/%{name}/gb.openssl.so
%{_libdir}/%{name}/gb.openssl.so.0
%{_libdir}/%{name}/gb.openssl.so.0.0.0
%{_datadir}/%{name}/info/gb.openssl.info
%{_datadir}/%{name}/info/gb.openssl.list

%files gb-option
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.option.component
%{_libdir}/%{name}/gb.option.la
%{_libdir}/%{name}/gb.option.so
%{_libdir}/%{name}/gb.option.so.0
%{_libdir}/%{name}/gb.option.so.0.0.0
%{_datadir}/%{name}/info/gb.option.info
%{_datadir}/%{name}/info/gb.option.list

%files gb-pcre
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.pcre.component
%{_libdir}/%{name}/gb.pcre.la
%{_libdir}/%{name}/gb.pcre.so
%{_libdir}/%{name}/gb.pcre.so.0
%{_libdir}/%{name}/gb.pcre.so.0.0.0
%{_datadir}/%{name}/info/gb.pcre.info
%{_datadir}/%{name}/info/gb.pcre.list

%files gb-pdf
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.pdf.component
%{_libdir}/%{name}/gb.pdf.la
%{_libdir}/%{name}/gb.pdf.so
%{_libdir}/%{name}/gb.pdf.so.0
%{_libdir}/%{name}/gb.pdf.so.0.0.0
%{_datadir}/%{name}/info/gb.pdf.info
%{_datadir}/%{name}/info/gb.pdf.list

%files gb-poppler
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.poppler.component
%{_libdir}/%{name}/gb.poppler.la
%{_libdir}/%{name}/gb.poppler.so
%{_libdir}/%{name}/gb.poppler.so.0
%{_libdir}/%{name}/gb.poppler.so.0.0.0
%{_datadir}/%{name}/info/gb.poppler.info
%{_datadir}/%{name}/info/gb.poppler.list

%files gb-qt5
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.qt5.component
%{_libdir}/%{name}/gb.qt5.la
%{_libdir}/%{name}/gb.qt5.so
%{_libdir}/%{name}/gb.qt5.so.0
%{_libdir}/%{name}/gb.qt5.so.0.0.0
%{_libdir}/%{name}/gb.qt5.wayland.component
%{_libdir}/%{name}/gb.qt5.wayland.la
%{_libdir}/%{name}/gb.qt5.wayland.so
%{_libdir}/%{name}/gb.qt5.wayland.so.0
%{_libdir}/%{name}/gb.qt5.wayland.so.0.0.0
%{_libdir}/%{name}/gb.qt5.x11.component
%{_libdir}/%{name}/gb.qt5.x11.la
%{_libdir}/%{name}/gb.qt5.x11.so
%{_libdir}/%{name}/gb.qt5.x11.so.0
%{_libdir}/%{name}/gb.qt5.x11.so.0.0.0
%{_datadir}/%{name}/info/gb.qt5.info
%{_datadir}/%{name}/info/gb.qt5.list
%{_datadir}/%{name}/info/gb.qt5.wayland.info
%{_datadir}/%{name}/info/gb.qt5.wayland.list
%{_datadir}/%{name}/info/gb.qt5.x11.info
%{_datadir}/%{name}/info/gb.qt5.x11.list

%files gb-qt5-ext
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.qt5.ext.component
%{_libdir}/%{name}/gb.qt5.ext.la
%{_libdir}/%{name}/gb.qt5.ext.so
%{_libdir}/%{name}/gb.qt5.ext.so.0
%{_libdir}/%{name}/gb.qt5.ext.so.0.0.0
%{_datadir}/%{name}/info/gb.qt5.ext.info
%{_datadir}/%{name}/info/gb.qt5.ext.list

%files gb-qt5-opengl
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.qt5.opengl.component
%{_libdir}/%{name}/gb.qt5.opengl.la
%{_libdir}/%{name}/gb.qt5.opengl.so
%{_libdir}/%{name}/gb.qt5.opengl.so.0
%{_libdir}/%{name}/gb.qt5.opengl.so.0.0.0
%{_datadir}/%{name}/info/gb.qt5.opengl.info
%{_datadir}/%{name}/info/gb.qt5.opengl.list

%files gb-qt5-webkit
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.qt5.webkit.component
%{_libdir}/%{name}/gb.qt5.webkit.la
%{_libdir}/%{name}/gb.qt5.webkit.so
%{_libdir}/%{name}/gb.qt5.webkit.so.0
%{_libdir}/%{name}/gb.qt5.webkit.so.0.0.0
%{_datadir}/%{name}/control/gb.qt5.webkit
%{_datadir}/%{name}/info/gb.qt5.webkit.info
%{_datadir}/%{name}/info/gb.qt5.webkit.list

%files gb-qt5-webview
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.qt5.webview.component
%{_libdir}/%{name}/gb.qt5.webview.la
%{_libdir}/%{name}/gb.qt5.webview.so
%{_libdir}/%{name}/gb.qt5.webview.so.0
%{_libdir}/%{name}/gb.qt5.webview.so.0.0.0
%{_datadir}/%{name}/info/gb.qt5.webview.info
%{_datadir}/%{name}/info/gb.qt5.webview.list

%files gb-qt6
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.qt6.component
%{_libdir}/%{name}/gb.qt6.la
%{_libdir}/%{name}/gb.qt6.so
%{_libdir}/%{name}/gb.qt6.so.0
%{_libdir}/%{name}/gb.qt6.so.0.0.0
%{_libdir}/%{name}/gb.qt6.wayland.component
%{_libdir}/%{name}/gb.qt6.wayland.la
%{_libdir}/%{name}/gb.qt6.wayland.so
%{_libdir}/%{name}/gb.qt6.wayland.so.0
%{_libdir}/%{name}/gb.qt6.wayland.so.0.0.0
%{_libdir}/%{name}/gb.qt6.x11.component
%{_libdir}/%{name}/gb.qt6.x11.la
%{_libdir}/%{name}/gb.qt6.x11.so
%{_libdir}/%{name}/gb.qt6.x11.so.0
%{_libdir}/%{name}/gb.qt6.x11.so.0.0.0
%{_datadir}/%{name}/info/gb.qt6.info
%{_datadir}/%{name}/info/gb.qt6.list
%{_datadir}/%{name}/info/gb.qt6.wayland.info
%{_datadir}/%{name}/info/gb.qt6.wayland.list
%{_datadir}/%{name}/info/gb.qt6.x11.info
%{_datadir}/%{name}/info/gb.qt6.x11.list

%files gb-qt6-ext
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.qt6.ext.component
%{_libdir}/%{name}/gb.qt6.ext.la
%{_libdir}/%{name}/gb.qt6.ext.so
%{_libdir}/%{name}/gb.qt6.ext.so.0
%{_libdir}/%{name}/gb.qt6.ext.so.0.0.0
%{_datadir}/%{name}/info/gb.qt6.ext.info
%{_datadir}/%{name}/info/gb.qt6.ext.list

%files gb-qt6-opengl
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.qt6.opengl.component
%{_libdir}/%{name}/gb.qt6.opengl.la
%{_libdir}/%{name}/gb.qt6.opengl.so
%{_libdir}/%{name}/gb.qt6.opengl.so.0
%{_libdir}/%{name}/gb.qt6.opengl.so.0.0.0
%{_datadir}/%{name}/info/gb.qt6.opengl.info
%{_datadir}/%{name}/info/gb.qt6.opengl.list

%files gb-qt6-webview
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.qt6.webview.component
%{_libdir}/%{name}/gb.qt6.webview.la
%{_libdir}/%{name}/gb.qt6.webview.so
%{_libdir}/%{name}/gb.qt6.webview.so.0
%{_libdir}/%{name}/gb.qt6.webview.so.0.0.0
%{_datadir}/%{name}/info/gb.qt6.webview.info
%{_datadir}/%{name}/info/gb.qt6.webview.list

%files gb-report
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.report.component
%{_libdir}/%{name}/gb.report.gambas
%{_datadir}/%{name}/control/gb.report
%{_datadir}/%{name}/info/gb.report.info
%{_datadir}/%{name}/info/gb.report.list

%files gb-report2
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.report2.component
%{_libdir}/%{name}/gb.report2.gambas
%{_datadir}/%{name}/control/gb.report2
%{_datadir}/%{name}/info/gb.report2.info
%{_datadir}/%{name}/info/gb.report2.list

%files gb-scanner
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.scanner.component
%{_libdir}/%{name}/gb.scanner.gambas
%{_datadir}/%{name}/info/gb.scanner.info
%{_datadir}/%{name}/info/gb.scanner.list

%files gb-sdl
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.sdl.component
%{_libdir}/%{name}/gb.sdl.la
%{_libdir}/%{name}/gb.sdl.so
%{_libdir}/%{name}/gb.sdl.so.0
%{_libdir}/%{name}/gb.sdl.so.0.0.0
%{_datadir}/%{name}/info/gb.sdl.info
%{_datadir}/%{name}/info/gb.sdl.list

%files gb-sdl-sound
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.sdl.sound.component
%{_libdir}/%{name}/gb.sdl.sound.la
%{_libdir}/%{name}/gb.sdl.sound.so
%{_libdir}/%{name}/gb.sdl.sound.so.0
%{_libdir}/%{name}/gb.sdl.sound.so.0.0.0
%{_datadir}/%{name}/info/gb.sdl.sound.info
%{_datadir}/%{name}/info/gb.sdl.sound.list

%files gb-sdl2
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.sdl2.component
%{_libdir}/%{name}/gb.sdl2.la
%{_libdir}/%{name}/gb.sdl2.so
%{_libdir}/%{name}/gb.sdl2.so.0
%{_libdir}/%{name}/gb.sdl2.so.0.0.0
%{_datadir}/%{name}/info/gb.sdl2.info
%{_datadir}/%{name}/info/gb.sdl2.list

%files gb-sdl2-audio
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.sdl2.audio.component
%{_libdir}/%{name}/gb.sdl2.audio.la
%{_libdir}/%{name}/gb.sdl2.audio.so
%{_libdir}/%{name}/gb.sdl2.audio.so.0
%{_libdir}/%{name}/gb.sdl2.audio.so.0.0.0
%{_datadir}/%{name}/info/gb.sdl2.audio.info
%{_datadir}/%{name}/info/gb.sdl2.audio.list

%files gb-settings
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.settings.component
%{_libdir}/%{name}/gb.settings.gambas
%{_datadir}/%{name}/info/gb.settings.info
%{_datadir}/%{name}/info/gb.settings.list

%files gb-signal
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.signal.component
%{_libdir}/%{name}/gb.signal.la
%{_libdir}/%{name}/gb.signal.so
%{_libdir}/%{name}/gb.signal.so.0
%{_libdir}/%{name}/gb.signal.so.0.0.0
%{_datadir}/%{name}/info/gb.signal.info
%{_datadir}/%{name}/info/gb.signal.list

%files gb-term
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.term.component
%{_libdir}/%{name}/gb.term.la
%{_libdir}/%{name}/gb.term.so
%{_libdir}/%{name}/gb.term.so.0
%{_libdir}/%{name}/gb.term.so.0.0.0
%{_datadir}/%{name}/info/gb.term.info
%{_datadir}/%{name}/info/gb.term.list

%files gb-term-form
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.term.form.component
%{_libdir}/%{name}/gb.term.form.gambas
%{_datadir}/%{name}/control/gb.term.form
%{_datadir}/%{name}/info/gb.term.form.info
%{_datadir}/%{name}/info/gb.term.form.list

%files gb-util
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.util.component
%{_libdir}/%{name}/gb.util.gambas
%{_datadir}/%{name}/info/gb.util.info
%{_datadir}/%{name}/info/gb.util.list

%files gb-util-web
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.util.web.component
%{_libdir}/%{name}/gb.util.web.gambas
%{_datadir}/%{name}/control/gb.util.web
%{_datadir}/%{name}/info/gb.util.web.info
%{_datadir}/%{name}/info/gb.util.web.list

%files gb-v4l
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.v4l.component
%{_libdir}/%{name}/gb.v4l.la
%{_libdir}/%{name}/gb.v4l.so
%{_libdir}/%{name}/gb.v4l.so.0
%{_libdir}/%{name}/gb.v4l.so.0.0.0
%{_datadir}/%{name}/info/gb.v4l.info
%{_datadir}/%{name}/info/gb.v4l.list

%files gb-vb
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.vb.component
%{_libdir}/%{name}/gb.vb.la
%{_libdir}/%{name}/gb.vb.so
%{_libdir}/%{name}/gb.vb.so.0
%{_libdir}/%{name}/gb.vb.so.0.0.0
%{_datadir}/%{name}/info/gb.vb.info
%{_datadir}/%{name}/info/gb.vb.list

%files gb-web
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.web.component
%{_libdir}/%{name}/gb.web.gambas
%{_datadir}/%{name}/info/gb.web.info
%{_datadir}/%{name}/info/gb.web.list

%files gb-web-feed
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.web.feed.component
%{_libdir}/%{name}/gb.web.feed.gambas
%{_datadir}/%{name}/info/gb.web.feed.info
%{_datadir}/%{name}/info/gb.web.feed.list

%files gb-web-form
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.web.form.component
%{_libdir}/%{name}/gb.web.form.gambas
%{_datadir}/%{name}/control/gb.web.form
%{_datadir}/%{name}/info/gb.web.form.info
%{_datadir}/%{name}/info/gb.web.form.list

%files gb-web-gui
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/control
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.web.gui.component
%{_libdir}/%{name}/gb.web.gui.gambas
%{_datadir}/%{name}/control/gb.web.gui
%{_datadir}/%{name}/info/gb.web.gui.info
%{_datadir}/%{name}/info/gb.web.gui.list

%files gb-xml
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.xml.component
%{_libdir}/%{name}/gb.xml.gambas
%{_libdir}/%{name}/gb.xml.la
%{_libdir}/%{name}/gb.xml.so
%{_libdir}/%{name}/gb.xml.so.0
%{_libdir}/%{name}/gb.xml.so.0.0.0
%{_datadir}/%{name}/info/gb.xml.info
%{_datadir}/%{name}/info/gb.xml.list

%files gb-xml-html
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.xml.html.component
%{_libdir}/%{name}/gb.xml.html.la
%{_libdir}/%{name}/gb.xml.html.so
%{_libdir}/%{name}/gb.xml.html.so.0
%{_libdir}/%{name}/gb.xml.html.so.0.0.0
%{_datadir}/%{name}/info/gb.xml.html.info
%{_datadir}/%{name}/info/gb.xml.html.list

%files gb-xml-rpc
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.xml.rpc.component
%{_libdir}/%{name}/gb.xml.rpc.gambas
%{_datadir}/%{name}/info/gb.xml.rpc.info
%{_datadir}/%{name}/info/gb.xml.rpc.list

%files gb-xml-xslt
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/info
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/gb.xml.xslt.component
%{_libdir}/%{name}/gb.xml.xslt.la
%{_libdir}/%{name}/gb.xml.xslt.so
%{_libdir}/%{name}/gb.xml.xslt.so.0
%{_libdir}/%{name}/gb.xml.xslt.so.0.0.0
%{_datadir}/%{name}/info/gb.xml.xslt.info
%{_datadir}/%{name}/info/gb.xml.xslt.list

%changelog
