#!/bin/sh
#
# Ad hoc script to rewrite the GAP test files tst/*.tst ;
# see debian/patches/debianization-tests.patch for further information.
#
# written for Debian by Jerome Benoit <calculus@rezozer.net>
# on behalf of the Debian Science Team
# copyright: 2016 Jerome Benoit <calculus@rezozer.net>
# distributed under the terms and conditions of GPL version 2 or later
#
TOP_SRCDIR=$PWD
[ -f $TOP_SRCDIR/README.sonata ] || exit 2
GAP=/usr/bin/gap
[ -e $GAP ] || exit 3
TESTWIDTH=2048
if [ -d $TOP_SRCDIR/tst ]; then
	listof_TestFile=$(find $TOP_SRCDIR/tst -name '*.tst' | sort)
	for idx in $(seq 1 9999); do
		new_TestDirectory=$TOP_SRCDIR/$(printf "tst-%04d" ${idx})
		if [ ! -e ${new_TestDirectory} ]; then
			mkdir ${new_TestDirectory}
			break;
		fi
		new_TestDirectory=''
	done
	[ -n "${new_TestDirectory}" ] || exit 4
	echo "======= Rewritting each test file"
	for tstfl in $listof_TestFile; do
		$GAP -A -q -T -x ${TESTWIDTH} <<-EOF
			SetPackagePath("sonata",".");
			LoadPackage("autpgrp");
			LoadPackage("sonata");
			rtstfl := Filename(Directory("${new_TestDirectory}"),"${tstfl##*/}");
			Test("${tstfl}", rec( width := ${TESTWIDTH}, reportDiff := Ignore, showProgress := false, rewriteToFile := rtstfl ) );
			QUIT_GAP(last);
			EOF
	done
	echo "======= Testing each rewritten test file"
	for tstfl in $listof_TestFile; do
		echo "SetPackagePath(\"sonata\",\".\"); LoadPackage(\"autpgrp\"); LoadPackage(\"sonata\"); QUIT_GAP(Test(\"${new_TestDirectory}/${tstfl##*/}\",rec(width:=${TESTWIDTH})));" | $GAP -A -q -T -x ${TESTWIDTH} || exit 5
	done
	echo "======= Testing the rewritten test directory"
	echo "SetPackagePath(\"sonata\",\".\"); LoadPackage(\"autpgrp\"); LoadPackage(\"sonata\"); QUIT_GAP(TestDirectory(\"${new_TestDirectory}\",rec(testOptions:=rec(width:=${TESTWIDTH}))));" | $GAP -A -q -T -x ${TESTWIDTH} || exit 6
fi
exit 0
# eos
