#! /bin/sh
#
# Assumes ../upstream is a git checkout of upstream

set -e

VERSION=0.9.0
DATE=`date +%Y%m%d`

dirname=gccxml-${VERSION}+git${DATE}.orig
tarname=gccxml_${VERSION}+git${DATE}.orig.tar.gz

cd ../upstream
git pull

cd ..
rm -rf ${dirname}
cp -a upstream ${dirname}
rm -rf ${dirname}/.git*

# Remove files with (a) no license, or (b) non-free license.
#
rm -rf ${dirname}/GCC_XML/Support/Borland
rm -f  ${dirname}/GCC/libiberty/xatexit.c

# Build tarball
#
GZIP="--best --no-name" tar czf tarballs/${tarname} ${dirname}
rm -rf ${dirname}
