static const char* edge_sobel_cl_source =
"#define SOBEL_RADIUS 1                                                        \n"
"kernel void kernel_edgesobel(global float4 *in,                               \n"
"                             global float4 *out,                              \n"
"                             const int horizontal,                            \n"
"                             const int vertical,                              \n"
"                             const int keep_sign,                             \n"
"                             const int has_alpha)                             \n"
"{                                                                             \n"
"    int gidx = get_global_id(0);                                              \n"
"    int gidy = get_global_id(1);                                              \n"
"                                                                              \n"
"    float4 hor_grad = 0.0f;                                                   \n"
"    float4 ver_grad = 0.0f;                                                   \n"
"    float4 gradient = 0.0f;                                                   \n"
"                                                                              \n"
"    int dst_width = get_global_size(0);                                       \n"
"    int src_width = dst_width + SOBEL_RADIUS * 2;                             \n"
"                                                                              \n"
"    int i = gidx + SOBEL_RADIUS, j = gidy + SOBEL_RADIUS;                     \n"
"    int gid1d = i + j * src_width;                                            \n"
"                                                                              \n"
"    float4 pix_fl = in[gid1d - 1 - src_width];                                \n"
"    float4 pix_fm = in[gid1d     - src_width];                                \n"
"    float4 pix_fr = in[gid1d + 1 - src_width];                                \n"
"    float4 pix_ml = in[gid1d - 1            ];                                \n"
"    float4 pix_mm = in[gid1d                ];                                \n"
"    float4 pix_mr = in[gid1d + 1            ];                                \n"
"    float4 pix_bl = in[gid1d - 1 + src_width];                                \n"
"    float4 pix_bm = in[gid1d     + src_width];                                \n"
"    float4 pix_br = in[gid1d + 1 + src_width];                                \n"
"                                                                              \n"
"    if (horizontal)                                                           \n"
"    {                                                                         \n"
"        hor_grad +=                                                           \n"
"            (-1.0f * pix_fl + 1.0f * pix_fr) +                                \n"
"            (-2.0f * pix_ml + 2.0f * pix_mr) +                                \n"
"            (-1.0f * pix_bl + 1.0f * pix_br);                                 \n"
"    }                                                                         \n"
"    if (vertical)                                                             \n"
"    {                                                                         \n"
"        ver_grad +=                                                           \n"
"            ( 1.0f * pix_fl) + ( 2.0f * pix_fm) + ( 1.0f * pix_fr) +          \n"
"            (-1.0f * pix_bl) + (-2.0f * pix_bm) + (-1.0f * pix_br);           \n"
"    }                                                                         \n"
"                                                                              \n"
"    if (horizontal && vertical)                                               \n"
"    {                                                                         \n"
"        /* sqrt(32.0) = 5.656854249492381 */                                  \n"
"        gradient = sqrt(hor_grad * hor_grad +                                 \n"
"                        ver_grad * ver_grad) / 5.656854249492381;             \n"
"    }                                                                         \n"
"    else                                                                      \n"
"    {                                                                         \n"
"        if (keep_sign)                                                        \n"
"            gradient = hor_grad + ver_grad;                                   \n"
"        else                                                                  \n"
"            gradient = fabs(hor_grad + ver_grad);                             \n"
"    }                                                                         \n"
"                                                                              \n"
"    if (has_alpha)                                                            \n"
"    {                                                                         \n"
"      gradient.w = pix_mm.w;                                                  \n"
"    }                                                                         \n"
"    else                                                                      \n"
"    {                                                                         \n"
"      gradient.w = 1.0f;                                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"    out[gidx + gidy * dst_width] = gradient;                                  \n"
"}                                                                             \n"
;
