static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Contains code originaly from GIMP tile-paper.c, copyright                  \n"
" * Copyright 1997-1999 Hirotsuna Mizuno <s1041150@u-aizu.ac.jp>               \n"
" *                                                                            \n"
" * Tile paper ported to GEGL:                                                 \n"
" * Copyright 2015 Akash Hiremath (akash akya) <akashh246@gmail.com>           \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_tile_paper_background_type)                                  \n"
"  enum_value (GEGL_BACKGROUND_TYPE_TRANSPARENT, \"transparent\", N_(\"Transparent\"))\n"
"  enum_value (GEGL_BACKGROUND_TYPE_INVERT,      \"invert\",      N_(\"Inverted image\"))\n"
"  enum_value (GEGL_BACKGROUND_TYPE_IMAGE,       \"image\",       N_(\"Image\"))\n"
"  enum_value (GEGL_BACKGROUND_TYPE_COLOR,       \"color\",       N_(\"Color\"))\n"
"enum_end (GeglTilePaperBackgroundType)                                        \n"
"                                                                              \n"
"enum_start (gegl_tile_paper_fractional_type)                                  \n"
"  enum_value (GEGL_FRACTIONAL_TYPE_BACKGROUND, \"background\", N_(\"Background\"))\n"
"  enum_value (GEGL_FRACTIONAL_TYPE_IGNORE,     \"ignore\",     N_(\"Ignore\"))\n"
"  enum_value (GEGL_FRACTIONAL_TYPE_FORCE,      \"force\",      N_(\"Force\")) \n"
"enum_end (GeglTilePaperFractionalType)                                        \n"
"                                                                              \n"
"property_int (tile_width, _(\"Tile Width\"), 155)                             \n"
"  description (_(\"Width of the tile\"))                                      \n"
"  value_range (1, G_MAXINT)                                                   \n"
"  ui_range    (1, 1500)                                                       \n"
"  ui_meta     (\"unit\", \"pixel-distance\")                                  \n"
"  ui_meta     (\"axis\", \"x\")                                               \n"
"                                                                              \n"
"property_int (tile_height, _(\"Tile Height\"), 56)                            \n"
"  description (_(\"Height of the tile\"))                                     \n"
"  value_range (1, G_MAXINT)                                                   \n"
"  ui_range    (1, 1500)                                                       \n"
"  ui_meta     (\"unit\", \"pixel-distance\")                                  \n"
"  ui_meta     (\"axis\", \"y\")                                               \n"
"                                                                              \n"
"property_double (move_rate, _(\"Move rate\"), 25.0)                           \n"
"  description (_(\"Move rate\"))                                              \n"
"  value_range (1.0, 100.0)                                                    \n"
"  ui_range    (1.0, 100.0)                                                    \n"
"  ui_meta     (\"unit\", \"percent\")                                         \n"
"                                                                              \n"
"property_boolean (wrap_around, _(\"Wrap around\"), FALSE)                     \n"
"  description (_(\"Wrap the fractional tiles\"))                              \n"
"                                                                              \n"
"property_enum (fractional_type, _(\"Fractional type\"),                       \n"
"               GeglTilePaperFractionalType, gegl_tile_paper_fractional_type,  \n"
"               GEGL_FRACTIONAL_TYPE_FORCE)                                    \n"
"  description (_(\"Fractional Type\"))                                        \n"
"                                                                              \n"
"property_boolean (centering, _(\"Centering\"), TRUE)                          \n"
"  description (_(\"Centering of the tiles\"))                                 \n"
"                                                                              \n"
"property_enum (background_type, _(\"Background type\"),                       \n"
"               GeglTilePaperBackgroundType, gegl_tile_paper_background_type,  \n"
"               GEGL_BACKGROUND_TYPE_INVERT)                                   \n"
"  description (_(\"Background type\"))                                        \n"
"                                                                              \n"
"property_color (bg_color, _(\"Background color\"), \"rgba(0.0, 0.0, 0.0, 1.0)\")\n"
"  description ((\"The tiles' background color\"))                             \n"
"  ui_meta     (\"role\", \"color-primary\")                                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE tile-paper.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"                                                                              \n"
"typedef struct _Tile                                                          \n"
"{                                                                             \n"
"  guint x;                                                                    \n"
"  guint y;                                                                    \n"
"  gint  z;                                                                    \n"
"  guint width;                                                                \n"
"  guint height;                                                               \n"
"  gint  move_x;                                                               \n"
"  gint  move_y;                                                               \n"
"} Tile;                                                                       \n"
"                                                                              \n"
"                                                                              \n"
"static gint                                                                   \n"
"tile_compare (const void *x,                                                  \n"
"              const void *y)                                                  \n"
"{                                                                             \n"
"  return ((Tile *) x)->z - ((Tile *) y)->z;                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"random_move (gint  *x,                                                        \n"
"             gint  *y,                                                        \n"
"             gint   max,                                                      \n"
"             GRand *gr)                                                       \n"
"{                                                                             \n"
"  gdouble angle  = g_rand_double_range (gr, 0.0, 1.0) * G_PI;                 \n"
"  gdouble radius = g_rand_double_range (gr, 0.0, 1.0) * (gdouble) max;        \n"
"                                                                              \n"
"  *x = (gint) (radius * cos (angle));                                         \n"
"  *y = (gint) (radius * sin (angle));                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"                                                                              \n"
"  op_area->left   = o->tile_width;                                            \n"
"  op_area->right  = o->tile_width;                                            \n"
"  op_area->top    = o->tile_height;                                           \n"
"  op_area->bottom = o->tile_height;                                           \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"randomize_tiles (GeglProperties      *o,                                      \n"
"                 const GeglRectangle *rect,                                   \n"
"                 gint                 division_x,                             \n"
"                 gint                 division_y,                             \n"
"                 gint                 offset_x,                               \n"
"                 gint                 offset_y,                               \n"
"                 gint                 n_tiles,                                \n"
"                 Tile                *tiles)                                  \n"
"{                                                                             \n"
"  Tile  *t = tiles;                                                           \n"
"  gint   move_max_pixels = o->move_rate * o->tile_width / 100;                \n"
"  gint   x;                                                                   \n"
"  gint   y;                                                                   \n"
"  GRand *gr;                                                                  \n"
"                                                                              \n"
"  gr = g_rand_new ();                                                         \n"
"                                                                              \n"
"  for (y = 0; y < division_y; y++)                                            \n"
"    {                                                                         \n"
"      gint srcy = offset_y + o->tile_height * y;                              \n"
"                                                                              \n"
"      for (x = 0; x < division_x; x++, t++)                                   \n"
"        {                                                                     \n"
"          gint srcx = offset_x + o->tile_width * x;                           \n"
"                                                                              \n"
"          if (srcx < 0)                                                       \n"
"            {                                                                 \n"
"              t->x     = 0;                                                   \n"
"              t->width = srcx + o->tile_width;                                \n"
"            }                                                                 \n"
"          else if (srcx + o->tile_width < rect->width)                        \n"
"            {                                                                 \n"
"              t->x     = srcx;                                                \n"
"              t->width = o->tile_width;                                       \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              t->x     = srcx;                                                \n"
"              t->width = rect->width - srcx;                                  \n"
"            }                                                                 \n"
"                                                                              \n"
"          if (srcy < 0)                                                       \n"
"            {                                                                 \n"
"              t->y      = 0;                                                  \n"
"              t->height = srcy + o->tile_height;                              \n"
"            }                                                                 \n"
"          else if (srcy + o->tile_height < rect->height)                      \n"
"            {                                                                 \n"
"              t->y      = srcy;                                               \n"
"              t->height = o->tile_height;                                     \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              t->y      = srcy;                                               \n"
"              t->height = rect->height - srcy;                                \n"
"            }                                                                 \n"
"                                                                              \n"
"          t->z = g_rand_int (gr);                                             \n"
"          random_move (&t->move_x, &t->move_y, move_max_pixels, gr);          \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  qsort (tiles, n_tiles, sizeof (*tiles), tile_compare);                      \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"draw_tiles (GeglProperties      *o,                                           \n"
"            const GeglRectangle *rect,                                        \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            gint                 num_of_tiles,                                \n"
"            Tile                *tiles)                                       \n"
"{                                                                             \n"
"  const Babl *format;                                                         \n"
"  gfloat     *tile_buffer;                                                    \n"
"  Tile       *t;                                                              \n"
"  gint        i;                                                              \n"
"                                                                              \n"
"  format = babl_format (\"RGBA float\");                                      \n"
"  tile_buffer = g_new0 (gfloat, 4 * o->tile_width * o->tile_height);          \n"
"                                                                              \n"
"  if (o->wrap_around)                                                         \n"
"    {                                                                         \n"
"      for (t = tiles, i = 0; i < num_of_tiles; i++, t++)                      \n"
"        {                                                                     \n"
"          GeglRectangle tile_rect = { t->x, t->y, t->width, t->height };      \n"
"                                                                              \n"
"          gegl_buffer_get (input, &tile_rect, 1.0, format, tile_buffer,       \n"
"                           GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);             \n"
"                                                                              \n"
"          tile_rect.x += t->move_x;                                           \n"
"          tile_rect.y += t->move_y;                                           \n"
"                                                                              \n"
"          gegl_buffer_set (output, &tile_rect, 0, format,                     \n"
"                           tile_buffer, GEGL_AUTO_ROWSTRIDE);                 \n"
"                                                                              \n"
"          if (tile_rect.x < 0 || tile_rect.x + tile_rect.width > rect->width ||\n"
"              tile_rect.y < 0 || tile_rect.y + tile_rect.height > rect->height)\n"
"            {                                                                 \n"
"              if (tile_rect.x < 0)                                            \n"
"                {                                                             \n"
"                  tile_rect.x = rect->width + tile_rect.x;                    \n"
"                }                                                             \n"
"              else if (tile_rect.x+tile_rect.width > rect->width)             \n"
"                {                                                             \n"
"                  tile_rect.x -= rect->width;                                 \n"
"                }                                                             \n"
"                                                                              \n"
"              if (tile_rect.y < 0)                                            \n"
"                {                                                             \n"
"                  tile_rect.y = rect->height + tile_rect.y;                   \n"
"                }                                                             \n"
"              else if (tile_rect.y + tile_rect.height > rect->height)         \n"
"                {                                                             \n"
"                  tile_rect.y -= rect->height;                                \n"
"                }                                                             \n"
"                                                                              \n"
"              gegl_buffer_set (output, &tile_rect, 0, format,                 \n"
"                               tile_buffer, GEGL_AUTO_ROWSTRIDE);             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      for (t = tiles, i = 0; i < num_of_tiles; i++, t++)                      \n"
"        {                                                                     \n"
"          GeglRectangle tile_rect = { t->x, t->y, t->width, t->height };      \n"
"                                                                              \n"
"          gegl_buffer_get (input, &tile_rect, 1.0, format, tile_buffer,       \n"
"                           GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);             \n"
"                                                                              \n"
"          tile_rect.x += t->move_x;                                           \n"
"          tile_rect.y += t->move_y;                                           \n"
"                                                                              \n"
"          gegl_buffer_set (output, &tile_rect, 0, format,                     \n"
"                           tile_buffer, GEGL_AUTO_ROWSTRIDE);                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (tile_buffer);                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"set_background (GeglProperties      *o,                                       \n"
"                const GeglRectangle *rect,                                    \n"
"                GeglBuffer          *input,                                   \n"
"                GeglBuffer          *output,                                  \n"
"                gint                 division_x,                              \n"
"                gint                 division_y,                              \n"
"                gint                 offset_x,                                \n"
"                gint                 offset_y)                                \n"
"{                                                                             \n"
"  const Babl *format;                                                         \n"
"  gfloat     *dest_buf;                                                       \n"
"  gfloat     *buf;                                                            \n"
"  gint        x;                                                              \n"
"  gint        y;                                                              \n"
"  gint        index;                                                          \n"
"  gint        clear_x0;                                                       \n"
"  gint        clear_y0;                                                       \n"
"  gint        clear_x1;                                                       \n"
"  gint        clear_y1;                                                       \n"
"                                                                              \n"
"  format = babl_format (\"RGBA float\");                                      \n"
"  dest_buf = g_new0 (gfloat, 4 * rect->width * rect->height);                 \n"
"                                                                              \n"
"  if (o->fractional_type == GEGL_FRACTIONAL_TYPE_IGNORE)                      \n"
"    {                                                                         \n"
"      clear_x0     = offset_x;                                                \n"
"      clear_y0     = offset_y;                                                \n"
"      clear_x1     = clear_x0 + o->tile_width * (rect->width / o->tile_width);\n"
"      clear_y1     = clear_y0 + o->tile_height * (rect->height / o->tile_height);\n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      clear_x0     = 0;                                                       \n"
"      clear_y0     = 0;                                                       \n"
"      clear_x1     = clear_x0 + rect->width;                                  \n"
"      clear_y1     = clear_y0 + rect->height;                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  switch (o->background_type)                                                 \n"
"    {                                                                         \n"
"    case GEGL_BACKGROUND_TYPE_TRANSPARENT:                                    \n"
"      gegl_buffer_set_color (output, rect,                                    \n"
"                             gegl_color_new (\"rgba(0.0,0.0,0.0,0.0)\"));     \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_BACKGROUND_TYPE_COLOR:                                          \n"
"      gegl_buffer_set_color (output, rect, o->bg_color);                      \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_BACKGROUND_TYPE_INVERT:                                         \n"
"      gegl_buffer_get (input, rect, 1.0, format, dest_buf,                    \n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"      buf = dest_buf;                                                         \n"
"      for (y = clear_y0; y < clear_y1; y++)                                   \n"
"        {                                                                     \n"
"          for (x = clear_x0; x < clear_x1; x++)                               \n"
"            {                                                                 \n"
"              index         = 4 * (y * rect->width + x);                      \n"
"              buf[index]    = 1 - buf[index];                                 \n"
"              buf[index+1]  = 1 - buf[index+1];                               \n"
"              buf[index+2]  = 1 - buf[index+2];                               \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      gegl_buffer_set (output, rect, 0, format, dest_buf, GEGL_AUTO_ROWSTRIDE);\n"
"      break;                                                                  \n"
"                                                                              \n"
"    case GEGL_BACKGROUND_TYPE_IMAGE:                                          \n"
"      gegl_buffer_get (input, rect, 1.0, format, dest_buf,                    \n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"      gegl_buffer_set (output, rect, 0, format, dest_buf, GEGL_AUTO_ROWSTRIDE);\n"
"      break;                                                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (dest_buf);                                                          \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Tile           *tiles;                                                      \n"
"  gint            offset_x;                                                   \n"
"  gint            offset_y;                                                   \n"
"  gint            division_x;                                                 \n"
"  gint            division_y;                                                 \n"
"  gint            n_tiles;                                                    \n"
"                                                                              \n"
"  division_x = result->width / o->tile_width;                                 \n"
"  division_y = result->height / o->tile_height;                               \n"
"                                                                              \n"
"  offset_x = 0;                                                               \n"
"  offset_y = 0;                                                               \n"
"                                                                              \n"
"  if (o->fractional_type == GEGL_FRACTIONAL_TYPE_FORCE)                       \n"
"    {                                                                         \n"
"      if (0 < result->width  % o->tile_width) division_x++;                   \n"
"      if (0 < result->height % o->tile_height) division_y++;                  \n"
"                                                                              \n"
"      if (o->centering)                                                       \n"
"        {                                                                     \n"
"          if (1 < result->width % o->tile_width)                              \n"
"            {                                                                 \n"
"              division_x++;                                                   \n"
"              offset_x = (result->width % o->tile_width) / 2 - o->tile_width; \n"
"            }                                                                 \n"
"                                                                              \n"
"          if (1 < result->height % o->tile_height)                            \n"
"            {                                                                 \n"
"              division_y++;                                                   \n"
"              offset_y = (result->height % o->tile_height) / 2 - o->tile_height;\n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      if (o->centering)                                                       \n"
"        {                                                                     \n"
"          offset_x = (result->width  % o->tile_width) / 2;                    \n"
"          offset_y = (result->height % o->tile_height) / 2;                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  n_tiles = division_x * division_y;                                          \n"
"  tiles = g_new(Tile, n_tiles);                                               \n"
"                                                                              \n"
"  randomize_tiles (o, result,  division_x, division_y,                        \n"
"                   offset_x, offset_y, n_tiles, tiles);                       \n"
"  set_background  (o, result, input, output, division_x, division_y,          \n"
"                   offset_x, offset_y);                                       \n"
"                                                                              \n"
"  draw_tiles (o, result, input, output, n_tiles, tiles);                      \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result  = { 0, 0, 0, 0 };                                    \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \n"
"                                                                   \"input\");\n"
"                                                                              \n"
"  if (! in_rect)                                                              \n"
"    return result;                                                            \n"
"                                                                              \n"
"  gegl_rectangle_copy (&result, in_rect);                                     \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"/* Compute the input rectangle required to compute the specified              \n"
" * region of interest (roi).                                                  \n"
" */                                                                           \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle  result = get_bounding_box (operation);                       \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return *gegl_operation_source_get_bounding_box (operation, \"input\");      \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->threaded                = FALSE;                           \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_bounding_box        = get_bounding_box;                \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_cached_region       = get_cached_region;               \n"
"                                                                              \n"
"  filter_class->process                    = process;                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:tile-paper\",                              \n"
"    \"title\",               _(\"Paper Tile\"),                               \n"
"    \"categories\",         \"artistic:map\",                                 \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"description\",        _(\"Cut image into paper tiles, and slide them\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
