static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" *                                                                            \n"
" * Exchange one color with the other (settable threshold to convert from      \n"
" * one color-shade to another...might do wonders on certain images, or be     \n"
" * totally useless on others).                                                \n"
" *                                                                            \n"
" * Author: Eiichi Takamori <taka@ma1.seikyou.ne.jp>                           \n"
" *                                                                            \n"
" * GEGL port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (center_x, _(\"Center X\"), 0.5)                              \n"
"  description (_(\"X coordinates of the center of supernova\"))               \n"
"  ui_range (0.0, 1.0)                                                         \n"
"  ui_meta  (\"unit\", \"relative-coordinate\")                                \n"
"  ui_meta  (\"axis\", \"x\")                                                  \n"
"                                                                              \n"
"property_double (center_y, _(\"Center Y\"), 0.5)                              \n"
"  description (_(\"Y coordinates of the center of supernova\"))               \n"
"  ui_range (0.0, 1.0)                                                         \n"
"  ui_meta  (\"unit\", \"relative-coordinate\")                                \n"
"  ui_meta  (\"axis\", \"y\")                                                  \n"
"                                                                              \n"
"property_int (radius, _(\"Radius\"), 20)                                      \n"
"  description (_(\"Radius of supernova\"))                                    \n"
"  ui_range (1.0, 100.0)                                                       \n"
"  value_range (1, 3000)                                                       \n"
"                                                                              \n"
"property_int (spokes_count, _(\"Number of spokes\"), 100)                     \n"
"  description (_(\"Number of spokes\"))                                       \n"
"  ui_range (1, 1024)                                                          \n"
"  value_range (1, 1024)                                                       \n"
"                                                                              \n"
"property_int (random_hue, _(\"Random hue\"), 0)                               \n"
"  description (_(\"Random hue\"))                                             \n"
"  ui_range (0, 360)                                                           \n"
"  value_range (0, 360)                                                        \n"
"                                                                              \n"
"property_color (color, _(\"Color\"), \"blue\")                                \n"
"  description(_(\"The color of supernova.\"))                                 \n"
"                                                                              \n"
"property_seed (seed, _(\"Random seed\"), rand)                                \n"
"  description (_(\"The random seed for spokes and random hue\"))              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_C_SOURCE supernova.c                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gdouble rand;                                                               \n"
"  gdouble color[4];                                                           \n"
"} SpokeType;                                                                  \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gint       spokes_count;                                                    \n"
"  gint       seed;                                                            \n"
"  gint       random_hue;                                                      \n"
"  gdouble    color[4];                                                        \n"
"  SpokeType *spokes;                                                          \n"
"} SnParamsType;                                                               \n"
"                                                                              \n"
"static gdouble                                                                \n"
"gauss (GRand *gr)                                                             \n"
"{                                                                             \n"
"  gdouble sum = 0.0;                                                          \n"
"  gint    i;                                                                  \n"
"                                                                              \n"
"  for (i = 0; i < 6; i++)                                                     \n"
"    sum += g_rand_double (gr);                                                \n"
"                                                                              \n"
"  return sum / 6.0;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"preprocess_spokes (GeglOperation *operation)                                  \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (operation);                       \n"
"  const Babl     *format = babl_format (\"R'G'B'A double\");                  \n"
"  SnParamsType *params;                                                       \n"
"  GRand      *gr;                                                             \n"
"  GeglColor  *tmp;                                                            \n"
"  gdouble     color[4];                                                       \n"
"  gint        i;                                                              \n"
"                                                                              \n"
"  params = (SnParamsType *) o->user_data;                                     \n"
"                                                                              \n"
"  gr = g_rand_new_with_seed (o->seed);                                        \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color, babl_format (\"HSVA double\"), &color);     \n"
"                                                                              \n"
"  for (i = 0; i < o->spokes_count; i++)                                       \n"
"    {                                                                         \n"
"      params->spokes[i].rand = gauss (gr);                                    \n"
"                                                                              \n"
"      color[0] += ((gdouble) o->random_hue / 360.0) *                         \n"
"                    g_rand_double_range (gr, -0.5, 0.5);                      \n"
"                                                                              \n"
"      if (color[0] < 0)                                                       \n"
"        color[0] += 1.0;                                                      \n"
"      else if (color[0] >= 1.0)                                               \n"
"        color[0] -= 1.0;                                                      \n"
"                                                                              \n"
"      tmp = gegl_color_duplicate (o->color);                                  \n"
"                                                                              \n"
"      gegl_color_set_pixel (tmp, babl_format (\"HSVA double\"), &color);      \n"
"                                                                              \n"
"      gegl_color_get_pixel (tmp, format, &(params->spokes[i].color));         \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* store parameters used for this spokes calculation */                     \n"
"  params->spokes_count = o->spokes_count;                                     \n"
"  params->seed = o->seed;                                                     \n"
"  params->random_hue = o->random_hue;                                         \n"
"  gegl_color_get_pixel (o->color, format, &(params->color));                  \n"
"                                                                              \n"
"  g_rand_free (gr);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (operation);                       \n"
"  const Babl     *format = babl_format (\"R'G'B'A double\");                  \n"
"  SnParamsType   *params;                                                     \n"
"  gdouble        c[4];                                                        \n"
"  gboolean need_preprocess_spokes = FALSE;                                    \n"
"                                                                              \n"
"  if (o->user_data == NULL)                                                   \n"
"    {                                                                         \n"
"      o->user_data = g_slice_new0 (SnParamsType);                             \n"
"      params = (SnParamsType *) o->user_data;                                 \n"
"      params->spokes = g_new0 (SpokeType, o->spokes_count);                   \n"
"      need_preprocess_spokes = TRUE;                                          \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      /* Preprocessing is done only if spokes_count, seed, random_hue         \n"
"       * or color parameters are changed.                                     \n"
"       * Reallocation is done only when spokes_count is changed.              \n"
"       *                                                                      \n"
"       * This to avoid the systematic reallocation and preproccessing of      \n"
"       * spokes at each prepare() call.                                       \n"
"       */                                                                     \n"
"                                                                              \n"
"      params = (SnParamsType *) o->user_data;                                 \n"
"                                                                              \n"
"      if (params->spokes_count != o->spokes_count)                            \n"
"        {                                                                     \n"
"          params->spokes = g_renew (SpokeType, params->spokes,                \n"
"                                    o->spokes_count);                         \n"
"                                                                              \n"
"          need_preprocess_spokes = TRUE;                                      \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          gegl_color_get_pixel (o->color, format, &c);                        \n"
"                                                                              \n"
"          if ((params->seed != o->seed) ||                                    \n"
"              (params->random_hue != o->random_hue) ||                        \n"
"              (c[0] != params->color[0]) ||                                   \n"
"              (c[1] != params->color[1]) ||                                   \n"
"              (c[2] != params->color[2]) ||                                   \n"
"              (c[3] != params->color[3]))                                     \n"
"            {                                                                 \n"
"              need_preprocess_spokes = TRUE;                                  \n"
"            }                                                                 \n"
"         }                                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (need_preprocess_spokes)                                                 \n"
"    preprocess_spokes (operation);                                            \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglOperation *op = (void*) object;                                         \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      SnParamsType *params;                                                   \n"
"      params = (SnParamsType *) o->user_data;                                 \n"
"      g_free (params->spokes);                                                \n"
"      g_slice_free (SnParamsType, o->user_data);                              \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle  *whole_region;                                               \n"
"  gdouble *input  = in_buf;                                                   \n"
"  gdouble *output = out_buf;                                                  \n"
"  SnParamsType *params;                                                       \n"
"  gdouble color[3];                                                           \n"
"  gint x, y;                                                                  \n"
"  gint real_x, real_y;                                                        \n"
"  gint idx;                                                                   \n"
"  gdouble       u, v, l, w, w1, c, t;                                         \n"
"  gdouble       nova_alpha, src_alpha, new_alpha = 0.0;                       \n"
"  gdouble       spokecol;                                                     \n"
"  gint          i, b;                                                         \n"
"  gdouble       compl_ratio, ratio;                                           \n"
"  SpokeType *spokes;                                                          \n"
"  gdouble cx, cy;                                                             \n"
"                                                                              \n"
"  params = (SnParamsType *) o->user_data;                                     \n"
"  g_assert (params != NULL);                                                  \n"
"                                                                              \n"
"  whole_region = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  cx = o->center_x * whole_region->width;                                     \n"
"  cy = o->center_y * whole_region->height;                                    \n"
"                                                                              \n"
"  spokes = params->spokes;                                                    \n"
"  g_assert (spokes != NULL);                                                  \n"
"                                                                              \n"
"  for (y = 0 ; y < roi->height ; y++)                                         \n"
"    {                                                                         \n"
"      real_y = roi->y + y;                                                    \n"
"      for (x = 0 ; x < roi->width ; x++)                                      \n"
"        {                                                                     \n"
"          real_x = roi->x + x;                                                \n"
"          idx = (x + y * roi->width) * 4;                                     \n"
"                                                                              \n"
"          u = (gdouble) (real_x - cx) / o->radius;                            \n"
"          v = (gdouble) (real_y - cy) / o->radius;                            \n"
"          l = sqrt(u*u + v*v);                                                \n"
"                                                                              \n"
"          t = (atan2 (u, v) / (2 * G_PI) + .51) * o->spokes_count;            \n"
"          i = (gint) floor (t);                                               \n"
"          t -= i;                                                             \n"
"          i %= o->spokes_count;                                               \n"
"                                                                              \n"
"          w1 = spokes[i].rand * (1 - t) +                                     \n"
"                 spokes[(i + 1) % o->spokes_count].rand * t;                  \n"
"                                                                              \n"
"          w1 = w1 * w1;                                                       \n"
"                                                                              \n"
"          w = 1.0 / (l + 0.001) * 0.9;                                        \n"
"                                                                              \n"
"          nova_alpha = CLAMP (w, 0.0, 1.0);                                   \n"
"          src_alpha = input[idx + 3];                                         \n"
"          new_alpha = src_alpha + (1.0 - src_alpha) * nova_alpha;             \n"
"                                                                              \n"
"          if (new_alpha != 0.0)                                               \n"
"            ratio = nova_alpha / new_alpha;                                   \n"
"          else                                                                \n"
"            ratio = 0.0;                                                      \n"
"                                                                              \n"
"          compl_ratio = 1.0 - ratio;                                          \n"
"                                                                              \n"
"          for (b = 0 ; b < 3 ; b++)                                           \n"
"            {                                                                 \n"
"              spokecol = spokes[i].color[b] * (1.0-t) +                       \n"
"                         spokes[(i+1) % o->spokes_count].color[b] * t;        \n"
"                                                                              \n"
"              if (w > 1.0)                                                    \n"
"                {                                                             \n"
"                  color[b] = CLAMP (spokecol * w, 0.0, 1.0);                  \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  color[b] = input[idx + b] * compl_ratio +                   \n"
"                             spokecol * ratio;                                \n"
"                }                                                             \n"
"                                                                              \n"
"              c = CLAMP (w1 * w, 0.0, 1.0);                                   \n"
"              color[b] += c;                                                  \n"
"              output[idx + b] = CLAMP (color[b], 0.0, 1.0);                   \n"
"            }                                                                 \n"
"                                                                              \n"
"          output[idx + 3] = new_alpha;                                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass                  *object_class;                                \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *filter_class;                                \n"
"                                                                              \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_POINT_FILTER_CLASS (klass);                \n"
"                                                                              \n"
"  object_class->finalize = finalize;                                          \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:supernova\",                                      \n"
"    \"title\",       _(\"Supernova\"),                                        \n"
"    \"categories\",  \"light\",                                               \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"This plug-in produces an effect like a supernova \"  \n"
"                     \"burst. The amount of the light effect is \"            \n"
"                     \"approximately in proportion to 1/r, where r is \"      \n"
"                     \"the distance from the center of the star.\"),          \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
