/*******************************************************************************
*
*       This file is part of the General Hidden Markov Model Library,
*       GHMM version __VERSION__, see http://ghmm.org
*
*       Filename: ghmm/ghmm/viterbi.h
*       Authors:  Bernhard Knab, Wasinee Rungsarityotin, Benjamin Georgi
*
*       Copyright (C) 1998-2004 Alexander Schliep 
*       Copyright (C) 1998-2001 ZAIK/ZPR, Universitaet zu Koeln
*	Copyright (C) 2002-2004 Max-Planck-Institut fuer Molekulare Genetik, 
*                               Berlin
*                                   
*       Contact: schliep@ghmm.org             
*
*       This library is free software; you can redistribute it and/or
*       modify it under the terms of the GNU Library General Public
*       License as published by the Free Software Foundation; either
*       version 2 of the License, or (at your option) any later version.
*
*       This library is distributed in the hope that it will be useful,
*       but WITHOUT ANY WARRANTY; without even the implied warranty of
*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*       Library General Public License for more details.
*
*       You should have received a copy of the GNU Library General Public
*       License along with this library; if not, write to the Free
*       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*
*       This file is version $Revision: 1988 $ 
*                       from $Date: 2007-12-05 10:48:14 -0500 (Wed, 05 Dec 2007) $
*             last change by $Author: grunau $.
*
*******************************************************************************/

#ifndef GHMM_VITERBI_H
#define GHMM_VITERBI_H

#ifdef __cplusplus
extern "C" {
#endif

#include <ghmm/model.h>

/**@name Viterbi-Algorithmus */
/*@{ (Doc++-Group: viterbi) */

/**
  Viterbi algorithm. Calculates the Viterbi path (the optimal path trough
  the model) and the Viterbi probability to a given model and a given 
  sequence. The matrices in the local_store struct are allocated using
  stat_matrix_d_alloc. In case of a model with silent states, the length of the viterbi 
  path is not identical with the sequence length. In such a case the end of the state path is
  marked by a -1 entry in the returned array. deprecated, use the argument pathlen instead
  @return Viterbi path
  @param mo:    model
  @param o:     sequence
  @param len:   length of the sequence
  @param pathlen: length of the viterbi path excluding the final "-1"
  @param log_p: probability of the sequence in the Viterbi path
  */
    int * ghmm_dmodel_viterbi (ghmm_dmodel * mo, int *o, int len, int *pathlen, double *log_p);

/**
  Calculates the logarithmic probability to a given path through the 
  states (does not have to be the Viterbi path), given sequence and
  a model.
  @param mo:        model
  @param o:         sequence
  @param len:       length of the sequence
  @param state_seq: path through the states
  @return log P
  */
  double ghmm_dmodel_viterbi_logp (ghmm_dmodel * mo, int *o, int len, int *state_seq);

#ifdef __cplusplus
}
#endif
#endif
/*@} (Doc++-Group: viterbi) */
