/* GKRELLMWireless
|  Copyright (C) 1999-2001 Sjoerd Simons
|
|  Author:  Sjoerd Simons sjoerd@gkrellm.luon.net
|  Latest versions might be found at:  http://gkrellm.luon.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
|
|  To get a copy of the GNU General Puplic License,  write to the
|  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <gkrellm2/gkrellm.h>
#ifdef __FreeBSD__
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <sys/sockio.h>
  #include <net/if.h>
  #if __FreeBSD_version >= 470000
    #include <dev/wi/if_wavelan_ieee.h>
  #else
    #include <machine/if_wavelan_ieee.h>
  #endif
  #define ANCACHE
  #include <dev/an/if_aironet_ieee.h>
#endif

#ifdef __NetBSD__
  #include <net/if.h>
  #include <net/if_dl.h>
  #include <net/if_ether.h>
  #include <net/if_media.h>
  #include <net/if_ieee80211.h>
  #include <dev/pcmcia/if_wi_ieee.h>
#endif

#ifdef __linux__
  #include <netinet/in.h>
  #include <linux/netdevice.h>
  #include <linux/wireless.h>
  #include <sys/ioctl.h>
#endif

#define PLUGIN_CONFIG_KEYWORD "gkrellmwireless"

#define WIRELESS_MAJOR_VERSION 2
#define WIRELESS_MINOR_VERSION 0
#define WIRELESS_EXTRA_VERSION ".2"

/* flags for all the differenct stuff */
#define ACTIVE       (1 << 0) /* this interface is alive now */ 
#define SHOW         (1 << 1) /* show or don't show this interface */
#define SHOW_LINK    (1 << 2) /* show link quality of this interface */
#define SHOW_LEVEL   (1 << 3) /* show level of this interface */ 
#define SHOW_NOISE   (1 << 4) /* show noise on this interface */
#define SHOW_BITRATE (1 << 5) /* show bit rate on this interface */
#define HIDE_NAME    (1 << 6) /* show name of this interface */

/* some maximums */
#define LINKQ_MAX 255
#define LEVEL_MAX 256
#define NOISE_MAX 256
#define BITRATE_MAX 1

typedef struct __wcard_t wcard_t;

struct __wcard_t {
  wcard_t *next;
  gchar *ifname;
  gint  flags; /* configuration flags */
  gint cflags;

  GkrellmPanel *level_panel;
  GkrellmPanel *link_panel;
  GkrellmPanel *noise_panel;
  GkrellmPanel *bitrate_panel;

  GkrellmDecal *level_text;
  GkrellmDecal *link_text;
  GkrellmDecal *noise_text;
  GkrellmDecal *bitrate_text;
};
