/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/util/InvokeHelper.java,v 1.4 2007/05/05 05:25:00 tcfujii Exp $
 * $Revision: 1.4 $
 * $Date: 2007/05/05 05:25:00 $
 */
 

package com.sun.cli.jmx.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

import com.sun.cli.util.ClassUtil;



public class InvokeHelper
{
	final Object	mTarget;
	
		public 
	InvokeHelper( Object target )
	{
		mTarget	= target;
	}
	
		static public Class []
	StringsToClasses( String [] signature )
		throws ClassNotFoundException
	{
		final int	count	= Array.getLength( signature );
		
		Class []	classes	 = new Class [ count ];
		
		for( int i = 0; i < count; ++i )
		{
			classes[ i ]	= ClassUtil.getClassFromName( signature[ i ] );
		}
		
		return( classes );
	}
	
        public Object
    invoke(
    	String	name,
    	Object	params[],
    	String	signature[] )
    	throws NoSuchMethodException, ClassNotFoundException,
    			InvocationTargetException, IllegalAccessException
    {
    	Object	result	= null;
    	
    	final Class []	signatureClasses	= StringsToClasses( signature );
    	
    	final Method	method	= mTarget.getClass().getDeclaredMethod( name, signatureClasses );
    	
    	result	= method.invoke( mTarget, params );
    	
    	return( result );
    }
}


