/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/**
 *	This generated bean class AvailabilityService matches the DTD element availability-service
 *
 */

package com.sun.enterprise.config.serverbeans;

import org.w3c.dom.*;
import org.netbeans.modules.schema2beans.*;
import java.beans.*;
import java.util.*;
import java.io.Serializable;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.util.i18n.StringManager;

// BEGIN_NOI18N

public class AvailabilityService extends ConfigBean implements Serializable
{

	static Vector comparators = new Vector();
	private static final org.netbeans.modules.schema2beans.Version runtimeVersion = new org.netbeans.modules.schema2beans.Version(4, 2, 0);

	static public final String WEB_CONTAINER_AVAILABILITY = "WebContainerAvailability";
	static public final String EJB_CONTAINER_AVAILABILITY = "EjbContainerAvailability";
	static public final String JMS_AVAILABILITY = "JmsAvailability";
	static public final String ELEMENT_PROPERTY = "ElementProperty";

	public AvailabilityService() {
		this(Common.USE_DEFAULT_VALUES);
	}

	public AvailabilityService(int options)
	{
		super(comparators, runtimeVersion);
		// Properties (see root bean comments for the bean graph)
		initPropertyTables(4);
		this.createProperty("web-container-availability", WEB_CONTAINER_AVAILABILITY, 
			Common.TYPE_0_1 | Common.TYPE_BEAN | Common.TYPE_KEY, 
			WebContainerAvailability.class);
		this.createAttribute(WEB_CONTAINER_AVAILABILITY, "availability-enabled", "AvailabilityEnabled", 
						AttrProp.CDATA | AttrProp.IMPLIED,
						null, null);
		this.createAttribute(WEB_CONTAINER_AVAILABILITY, "persistence-type", "PersistenceType", 
						AttrProp.CDATA,
						null, "memory");
		this.createAttribute(WEB_CONTAINER_AVAILABILITY, "persistence-frequency", "PersistenceFrequency", 
						AttrProp.CDATA | AttrProp.IMPLIED,
						null, null);
		this.createAttribute(WEB_CONTAINER_AVAILABILITY, "persistence-scope", "PersistenceScope", 
						AttrProp.CDATA | AttrProp.IMPLIED,
						null, null);
		this.createAttribute(WEB_CONTAINER_AVAILABILITY, "persistence-store-health-check-enabled", "PersistenceStoreHealthCheckEnabled", 
						AttrProp.CDATA,
						null, "false");
		this.createAttribute(WEB_CONTAINER_AVAILABILITY, "sso-failover-enabled", "SsoFailoverEnabled", 
						AttrProp.CDATA,
						null, "false");
		this.createAttribute(WEB_CONTAINER_AVAILABILITY, "http-session-store-pool-name", "HttpSessionStorePoolName", 
						AttrProp.CDATA | AttrProp.IMPLIED,
						null, null);
		this.createProperty("ejb-container-availability", EJB_CONTAINER_AVAILABILITY, 
			Common.TYPE_0_1 | Common.TYPE_BEAN | Common.TYPE_KEY, 
			EjbContainerAvailability.class);
		this.createAttribute(EJB_CONTAINER_AVAILABILITY, "availability-enabled", "AvailabilityEnabled", 
						AttrProp.CDATA | AttrProp.IMPLIED,
						null, null);
		this.createAttribute(EJB_CONTAINER_AVAILABILITY, "sfsb-ha-persistence-type", "SfsbHaPersistenceType", 
						AttrProp.CDATA,
						null, "ha");
		this.createAttribute(EJB_CONTAINER_AVAILABILITY, "sfsb-persistence-type", "SfsbPersistenceType", 
						AttrProp.CDATA,
						null, "file");
		this.createAttribute(EJB_CONTAINER_AVAILABILITY, "sfsb-checkpoint-enabled", "SfsbCheckpointEnabled", 
						AttrProp.CDATA | AttrProp.IMPLIED,
						null, null);
		this.createAttribute(EJB_CONTAINER_AVAILABILITY, "sfsb-quick-checkpoint-enabled", "SfsbQuickCheckpointEnabled", 
						AttrProp.CDATA | AttrProp.IMPLIED,
						null, null);
		this.createAttribute(EJB_CONTAINER_AVAILABILITY, "sfsb-store-pool-name", "SfsbStorePoolName", 
						AttrProp.CDATA | AttrProp.IMPLIED,
						null, null);
		this.createProperty("jms-availability", JMS_AVAILABILITY, 
			Common.TYPE_0_1 | Common.TYPE_BEAN | Common.TYPE_KEY, 
			JmsAvailability.class);
		this.createAttribute(JMS_AVAILABILITY, "availability-enabled", "AvailabilityEnabled", 
						AttrProp.CDATA,
						null, "false");
		this.createAttribute(JMS_AVAILABILITY, "mq-store-pool-name", "MqStorePoolName", 
						AttrProp.CDATA | AttrProp.IMPLIED,
						null, null);
		this.createProperty("property", ELEMENT_PROPERTY, 
			Common.TYPE_0_N | Common.TYPE_BEAN | Common.TYPE_KEY, 
			ElementProperty.class);
		this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.initialize(options);
	}

	// Setting the default values of the properties
	void initialize(int options) {

	}

	// This attribute is optional
	public void setWebContainerAvailability(WebContainerAvailability value) {
		this.setValue(WEB_CONTAINER_AVAILABILITY, value);
	}

	// Get Method
	public WebContainerAvailability getWebContainerAvailability() {
		return (WebContainerAvailability)this.getValue(WEB_CONTAINER_AVAILABILITY);
	}

	// This attribute is optional
	public void setEjbContainerAvailability(EjbContainerAvailability value) {
		this.setValue(EJB_CONTAINER_AVAILABILITY, value);
	}

	// Get Method
	public EjbContainerAvailability getEjbContainerAvailability() {
		return (EjbContainerAvailability)this.getValue(EJB_CONTAINER_AVAILABILITY);
	}

	// This attribute is optional
	public void setJmsAvailability(JmsAvailability value) {
		this.setValue(JMS_AVAILABILITY, value);
	}

	// Get Method
	public JmsAvailability getJmsAvailability() {
		return (JmsAvailability)this.getValue(JMS_AVAILABILITY);
	}

	// Get Method
	public ElementProperty getElementProperty(int index) {
		return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
	}

	// This attribute is an array, possibly empty
	public void setElementProperty(ElementProperty[] value) {
		this.setValue(ELEMENT_PROPERTY, value);
	}

	// Getter Method
	public ElementProperty[] getElementProperty() {
		return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
	}

	// Return the number of properties
	public int sizeElementProperty() {
		return this.size(ELEMENT_PROPERTY);
	}

	// Add a new element returning its index in the list
	public int addElementProperty(ElementProperty value)
			throws ConfigException{
		return addElementProperty(value, true);
	}

	// Add a new element returning its index in the list with a boolean flag
	public int addElementProperty(ElementProperty value, boolean overwrite)
			throws ConfigException{
		ElementProperty old = getElementPropertyByName(value.getName());
		if(old != null) {
			throw new ConfigException(StringManager.getManager(AvailabilityService.class).getString("cannotAddDuplicate",  "ElementProperty"));
		}
		return this.addValue(ELEMENT_PROPERTY, value, overwrite);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	//
	public int removeElementProperty(ElementProperty value){
		return this.removeValue(ELEMENT_PROPERTY, value);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	// with boolean overwrite
	//
	public int removeElementProperty(ElementProperty value, boolean overwrite)
			throws StaleWriteConfigException{
		return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
	}

	public ElementProperty getElementPropertyByName(String id) {
	 if (null != id) { id = id.trim(); }
	ElementProperty[] o = getElementProperty();
	 if (o == null) return null;

	 for (int i=0; i < o.length; i++) {
	     if(o[i].getAttributeValue(Common.convertName(ServerTags.NAME)).equals(id)) {
	         return o[i];
	     }
	 }

		return null;
		
	}
	/**
	* Getter for AvailabilityEnabled of the Element availability-service
	* @return  the AvailabilityEnabled of the Element availability-service
	*/
	public boolean isAvailabilityEnabled() {
		return toBoolean(getAttributeValue(ServerTags.AVAILABILITY_ENABLED));
	}
	/**
	* Modify  the AvailabilityEnabled of the Element availability-service
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setAvailabilityEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.AVAILABILITY_ENABLED, ""+(v==true), overwrite);
	}
	/**
	* Modify  the AvailabilityEnabled of the Element availability-service
	* @param v the new value
	*/
	public void setAvailabilityEnabled(boolean v) {
		setAttributeValue(ServerTags.AVAILABILITY_ENABLED, ""+(v==true));
	}
	/**
	* Get the default value of AvailabilityEnabled from dtd
	*/
	public static String getDefaultAvailabilityEnabled() {
		return "true".trim();
	}
	/**
	* Getter for HaAgentHosts of the Element availability-service
	* @return  the HaAgentHosts of the Element availability-service
	*/
	public String getHaAgentHosts() {
			return getAttributeValue(ServerTags.HA_AGENT_HOSTS);
	}
	/**
	* Modify  the HaAgentHosts of the Element availability-service
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setHaAgentHosts(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.HA_AGENT_HOSTS, v, overwrite);
	}
	/**
	* Modify  the HaAgentHosts of the Element availability-service
	* @param v the new value
	*/
	public void setHaAgentHosts(String v) {
		setAttributeValue(ServerTags.HA_AGENT_HOSTS, v);
	}
	/**
	* Getter for HaAgentPort of the Element availability-service
	* @return  the HaAgentPort of the Element availability-service
	*/
	public String getHaAgentPort() {
			return getAttributeValue(ServerTags.HA_AGENT_PORT);
	}
	/**
	* Modify  the HaAgentPort of the Element availability-service
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setHaAgentPort(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.HA_AGENT_PORT, v, overwrite);
	}
	/**
	* Modify  the HaAgentPort of the Element availability-service
	* @param v the new value
	*/
	public void setHaAgentPort(String v) {
		setAttributeValue(ServerTags.HA_AGENT_PORT, v);
	}
	/**
	* Getter for HaAgentPassword of the Element availability-service
	* @return  the HaAgentPassword of the Element availability-service
	*/
	public String getHaAgentPassword() {
			return getAttributeValue(ServerTags.HA_AGENT_PASSWORD);
	}
	/**
	* Modify  the HaAgentPassword of the Element availability-service
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setHaAgentPassword(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.HA_AGENT_PASSWORD, v, overwrite);
	}
	/**
	* Modify  the HaAgentPassword of the Element availability-service
	* @param v the new value
	*/
	public void setHaAgentPassword(String v) {
		setAttributeValue(ServerTags.HA_AGENT_PASSWORD, v);
	}
	/**
	* Getter for HaStoreName of the Element availability-service
	* @return  the HaStoreName of the Element availability-service
	*/
	public String getHaStoreName() {
			return getAttributeValue(ServerTags.HA_STORE_NAME);
	}
	/**
	* Modify  the HaStoreName of the Element availability-service
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setHaStoreName(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.HA_STORE_NAME, v, overwrite);
	}
	/**
	* Modify  the HaStoreName of the Element availability-service
	* @param v the new value
	*/
	public void setHaStoreName(String v) {
		setAttributeValue(ServerTags.HA_STORE_NAME, v);
	}
	/**
	* Getter for AutoManageHaStore of the Element availability-service
	* @return  the AutoManageHaStore of the Element availability-service
	*/
	public boolean isAutoManageHaStore() {
		return toBoolean(getAttributeValue(ServerTags.AUTO_MANAGE_HA_STORE));
	}
	/**
	* Modify  the AutoManageHaStore of the Element availability-service
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setAutoManageHaStore(boolean v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.AUTO_MANAGE_HA_STORE, ""+(v==true), overwrite);
	}
	/**
	* Modify  the AutoManageHaStore of the Element availability-service
	* @param v the new value
	*/
	public void setAutoManageHaStore(boolean v) {
		setAttributeValue(ServerTags.AUTO_MANAGE_HA_STORE, ""+(v==true));
	}
	/**
	* Get the default value of AutoManageHaStore from dtd
	*/
	public static String getDefaultAutoManageHaStore() {
		return "false".trim();
	}
	/**
	* Getter for StorePoolName of the Element availability-service
	* @return  the StorePoolName of the Element availability-service
	*/
	public String getStorePoolName() {
			return getAttributeValue(ServerTags.STORE_POOL_NAME);
	}
	/**
	* Modify  the StorePoolName of the Element availability-service
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setStorePoolName(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.STORE_POOL_NAME, v, overwrite);
	}
	/**
	* Modify  the StorePoolName of the Element availability-service
	* @param v the new value
	*/
	public void setStorePoolName(String v) {
		setAttributeValue(ServerTags.STORE_POOL_NAME, v);
	}
	/**
	* Getter for HaStoreHealthcheckEnabled of the Element availability-service
	* @return  the HaStoreHealthcheckEnabled of the Element availability-service
	*/
	public boolean isHaStoreHealthcheckEnabled() {
		return toBoolean(getAttributeValue(ServerTags.HA_STORE_HEALTHCHECK_ENABLED));
	}
	/**
	* Modify  the HaStoreHealthcheckEnabled of the Element availability-service
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setHaStoreHealthcheckEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.HA_STORE_HEALTHCHECK_ENABLED, ""+(v==true), overwrite);
	}
	/**
	* Modify  the HaStoreHealthcheckEnabled of the Element availability-service
	* @param v the new value
	*/
	public void setHaStoreHealthcheckEnabled(boolean v) {
		setAttributeValue(ServerTags.HA_STORE_HEALTHCHECK_ENABLED, ""+(v==true));
	}
	/**
	* Get the default value of HaStoreHealthcheckEnabled from dtd
	*/
	public static String getDefaultHaStoreHealthcheckEnabled() {
		return "false".trim();
	}
	/**
	* Getter for HaStoreHealthcheckIntervalInSeconds of the Element availability-service
	* @return  the HaStoreHealthcheckIntervalInSeconds of the Element availability-service
	*/
	public String getHaStoreHealthcheckIntervalInSeconds() {
		return getAttributeValue(ServerTags.HA_STORE_HEALTHCHECK_INTERVAL_IN_SECONDS);
	}
	/**
	* Modify  the HaStoreHealthcheckIntervalInSeconds of the Element availability-service
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setHaStoreHealthcheckIntervalInSeconds(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.HA_STORE_HEALTHCHECK_INTERVAL_IN_SECONDS, v, overwrite);
	}
	/**
	* Modify  the HaStoreHealthcheckIntervalInSeconds of the Element availability-service
	* @param v the new value
	*/
	public void setHaStoreHealthcheckIntervalInSeconds(String v) {
		setAttributeValue(ServerTags.HA_STORE_HEALTHCHECK_INTERVAL_IN_SECONDS, v);
	}
	/**
	* Get the default value of HaStoreHealthcheckIntervalInSeconds from dtd
	*/
	public static String getDefaultHaStoreHealthcheckIntervalInSeconds() {
		return "5".trim();
	}
	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public WebContainerAvailability newWebContainerAvailability() {
		return new WebContainerAvailability();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public EjbContainerAvailability newEjbContainerAvailability() {
		return new EjbContainerAvailability();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public JmsAvailability newJmsAvailability() {
		return new JmsAvailability();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public ElementProperty newElementProperty() {
		return new ElementProperty();
	}

	/**
	* get the xpath representation for this element
	* returns something like abc[@name='value'] or abc
	* depending on the type of the bean
	*/
	protected String getRelativeXPath() {
	    String ret = null;
	    ret = "availability-service";
	    return (null != ret ? ret.trim() : null);
	}

	/*
	* generic method to get default value from dtd
	*/
	public static String getDefaultAttributeValue(String attr) {
		if(attr == null) return null;
		attr = attr.trim();
		if(attr.equals(ServerTags.AVAILABILITY_ENABLED)) return "true".trim();
		if(attr.equals(ServerTags.AUTO_MANAGE_HA_STORE)) return "false".trim();
		if(attr.equals(ServerTags.HA_STORE_HEALTHCHECK_ENABLED)) return "false".trim();
		if(attr.equals(ServerTags.HA_STORE_HEALTHCHECK_INTERVAL_IN_SECONDS)) return "5".trim();
	return null;
	}
	//
	public static void addComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.add(c);
	}

	//
	public static void removeComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.remove(c);
	}
	public void validate() throws org.netbeans.modules.schema2beans.ValidateException {
	}

	// Dump the content of this bean returning it as a String
	public void dump(StringBuffer str, String indent){
		String s;
		Object o;
		org.netbeans.modules.schema2beans.BaseBean n;
		str.append(indent);
		str.append("WebContainerAvailability");	// NOI18N
		n = (org.netbeans.modules.schema2beans.BaseBean) this.getWebContainerAvailability();
		if (n != null)
			n.dump(str, indent + "\t");	// NOI18N
		else
			str.append(indent+"\tnull");	// NOI18N
		this.dumpAttributes(WEB_CONTAINER_AVAILABILITY, 0, str, indent);

		str.append(indent);
		str.append("EjbContainerAvailability");	// NOI18N
		n = (org.netbeans.modules.schema2beans.BaseBean) this.getEjbContainerAvailability();
		if (n != null)
			n.dump(str, indent + "\t");	// NOI18N
		else
			str.append(indent+"\tnull");	// NOI18N
		this.dumpAttributes(EJB_CONTAINER_AVAILABILITY, 0, str, indent);

		str.append(indent);
		str.append("JmsAvailability");	// NOI18N
		n = (org.netbeans.modules.schema2beans.BaseBean) this.getJmsAvailability();
		if (n != null)
			n.dump(str, indent + "\t");	// NOI18N
		else
			str.append(indent+"\tnull");	// NOI18N
		this.dumpAttributes(JMS_AVAILABILITY, 0, str, indent);

		str.append(indent);
		str.append("ElementProperty["+this.sizeElementProperty()+"]");	// NOI18N
		for(int i=0; i<this.sizeElementProperty(); i++)
		{
			str.append(indent+"\t");
			str.append("#"+i+":");
			n = (org.netbeans.modules.schema2beans.BaseBean) this.getElementProperty(i);
			if (n != null)
				n.dump(str, indent + "\t");	// NOI18N
			else
				str.append(indent+"\tnull");	// NOI18N
			this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
		}

	}
	public String dumpBeanNode(){
		StringBuffer str = new StringBuffer();
		str.append("AvailabilityService\n");	// NOI18N
		this.dump(str, "\n  ");	// NOI18N
		return str.toString();
	}}

// END_NOI18N

