
import numpy
import OpenGL.GL as gl

import glitch.glut
from glitch.limbo.vertices import DrawVertexArray

# Lines.

# The number of lines in each dimension.
nlines = 7
# We need four times as many points: two coordinates per line, two
# sets of lines.
lines = numpy.ndarray(shape=(nlines * 4, 2), dtype=numpy.float32)
indices = numpy.arange(nlines * 4)

# Horizontal / X.
lines[(indices >= nlines * 2) & (indices % 2 == 0), 0] = 0.0
lines[(indices >= nlines * 2) & (indices % 2 == 1), 0] = 1.0

# Horizontal / Y.
ys = (numpy.arange(nlines * 2) // 2) * (1.0 / (nlines - 1))
lines[nlines * 2 :, 1] = 0.1 + 0.8 * ys

# Vertical / X.
xs = (numpy.arange(nlines * 2) // 2) * (1.0 / (nlines - 1))
lines[: nlines * 2, 0] = 0.1 + 0.8 * xs

# Vertical / Y.
lines[(indices < nlines * 2) & (indices % 2 == 0), 1] = 0.0
lines[(indices < nlines * 2) & (indices % 2 == 1), 1] = 1.0

# Triangles.

ntriangles = 5
triangles = numpy.ndarray(shape=(ntriangles * 3, 2), dtype=numpy.float32)
nums = numpy.arange(ntriangles)
indices = numpy.arange(ntriangles * 3)

triangles[indices % 3 == 0, :] = numpy.tile(nums, (2, 1)).T
triangles[indices % 3 == 1, :] = numpy.tile(nums, (2, 1)).T + 1
triangles[indices % 3 == 2, 0] = nums + 1
triangles[indices % 3 == 2, 1] = nums
triangles[:, :] = triangles[:, :] / float(ntriangles)

print 'lines:'
print lines
print
print 'triangles:'
print triangles

camera = glitch.glut.GLUTCamera(
    eye=[0.5, 0.5, 1],
    ref=[0.5, 0.5, 0],
    children=[
        DrawVertexArray(gl.GL_LINES, lines),
        DrawVertexArray(gl.GL_TRIANGLES, triangles)])
camera.run()
