
"""
Glitch, an OpenGL rendering framework.

Glitch renders using a tree of L{Node}s which share state using a L{Context}.
The root of the tree is a special type of node called a L{Camera}. Texturing
is accomplished using L{Texture} and its associated classes, and shading is
accomplished using the L{Shader} node.

Glitch is organised into a small core, with seperate packages integrating with
other software (e.g. L{glitch.gtk} and L{glitch.glut} for windowing and
input).

Since Glitch leans towards being small and limited rather than all-inclusive,
it is not rare for programs using Glitch to include specialised nodes of their
own, and often those will need to call OpenGL directly. However, there is a
collection of useful nodes (of varying levels of quality) in the
L{glitch.limbo} package.
"""

from glitch.node import Node
from glitch.color import Color
from glitch.fbo import CameraTexture
from glitch.transform import (Translate, Scale, Rotate)
from glitch.shader import Shader
from glitch.texture import (
    Texture, ApplyTexture, TexturedRectangle, TexturedSquare)
